/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileTypeDetector;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.AbstractFileSystemProvider;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixCopyFile;
import sun.nio.fs.UnixDirectoryStream;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributeViews;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixSecureDirectoryStream;
import sun.nio.fs.UnixUriUtils;
import sun.nio.fs.Util;

public abstract class UnixFileSystemProvider
extends AbstractFileSystemProvider {
    private static final String USER_DIR = "user.dir";
    private final UnixFileSystem theFileSystem;

    public UnixFileSystemProvider() {
        String userDir = System.getProperty(USER_DIR);
        this.theFileSystem = this.newFileSystem(userDir);
    }

    abstract UnixFileSystem newFileSystem(String var1);

    @Override
    public final String getScheme() {
        return "file";
    }

    private void checkUri(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uri.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    @Override
    public final FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.checkUri(uri);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public final FileSystem getFileSystem(URI uri) {
        this.checkUri(uri);
        return this.theFileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        return UnixUriUtils.fromUri(this.theFileSystem, uri);
    }

    UnixPath checkPath(Path obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!(obj instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)obj;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path obj, Class<V> type, LinkOption ... options) {
        UnixPath file = UnixPath.toUnixPath(obj);
        boolean followLinks = Util.followLinks(options);
        if (type == BasicFileAttributeView.class) {
            return (V)UnixFileAttributeViews.createBasicView(file, followLinks);
        }
        if (type == PosixFileAttributeView.class) {
            return (V)UnixFileAttributeViews.createPosixView(file, followLinks);
        }
        if (type == FileOwnerAttributeView.class) {
            return (V)UnixFileAttributeViews.createOwnerView(file, followLinks);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path file, Class<A> type, LinkOption ... options) throws IOException {
        Class<BasicFileAttributeView> view;
        if (type == BasicFileAttributes.class) {
            view = BasicFileAttributeView.class;
        } else if (type == PosixFileAttributes.class) {
            view = PosixFileAttributeView.class;
        } else {
            if (type == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }
        return (A)this.getFileAttributeView(file, view, options).readAttributes();
    }

    @Override
    protected DynamicFileAttributeView getFileAttributeView(Path obj, String name, LinkOption ... options) {
        UnixPath file = UnixPath.toUnixPath(obj);
        boolean followLinks = Util.followLinks(options);
        if (name.equals("basic")) {
            return UnixFileAttributeViews.createBasicView(file, followLinks);
        }
        if (name.equals("posix")) {
            return UnixFileAttributeViews.createPosixView(file, followLinks);
        }
        if (name.equals("unix")) {
            return UnixFileAttributeViews.createUnixView(file, followLinks);
        }
        if (name.equals("owner")) {
            return UnixFileAttributeViews.createOwnerView(file, followLinks);
        }
        return null;
    }

    @Override
    public FileChannel newFileChannel(Path obj, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        UnixPath file = this.checkPath(obj);
        int mode = UnixFileModeAttribute.toUnixMode(438, attrs);
        try {
            return UnixChannelFactory.newFileChannel(file, options, mode);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(file);
            return null;
        }
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path obj, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        UnixPath file = this.checkPath(obj);
        int mode = UnixFileModeAttribute.toUnixMode(438, attrs);
        ThreadPool pool = executor == null ? null : ThreadPool.wrap(executor, 0);
        try {
            return UnixChannelFactory.newAsynchronousFileChannel(file, options, mode, pool);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(file);
            return null;
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path obj, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        UnixPath file = UnixPath.toUnixPath(obj);
        int mode = UnixFileModeAttribute.toUnixMode(438, attrs);
        try {
            return UnixChannelFactory.newFileChannel(file, options, mode);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(file);
            return null;
        }
    }

    @Override
    boolean implDelete(Path obj, boolean failIfNotExists) throws IOException {
        UnixPath file = UnixPath.toUnixPath(obj);
        file.checkDelete();
        UnixFileAttributes attrs = null;
        try {
            attrs = UnixFileAttributes.get(file, false);
            if (attrs.isDirectory()) {
                UnixNativeDispatcher.rmdir(file);
            } else {
                UnixNativeDispatcher.unlink(file);
            }
            return true;
        }
        catch (UnixException x) {
            if (!failIfNotExists && x.errno() == 2) {
                return false;
            }
            if (attrs != null && attrs.isDirectory() && (x.errno() == 17 || x.errno() == 66)) {
                throw new DirectoryNotEmptyException(file.getPathForExceptionMessage());
            }
            x.rethrowAsIOException(file);
            return false;
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        UnixCopyFile.copy(UnixPath.toUnixPath(source), UnixPath.toUnixPath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        UnixCopyFile.move(UnixPath.toUnixPath(source), UnixPath.toUnixPath(target), options);
    }

    @Override
    public void checkAccess(Path obj, AccessMode ... modes) throws IOException {
        UnixPath file = UnixPath.toUnixPath(obj);
        boolean e = false;
        boolean r = false;
        boolean w = false;
        boolean x = false;
        if (modes.length == 0) {
            e = true;
        } else {
            block7: for (AccessMode mode : modes) {
                switch (mode) {
                    case READ: {
                        r = true;
                        continue block7;
                    }
                    case WRITE: {
                        w = true;
                        continue block7;
                    }
                    case EXECUTE: {
                        x = true;
                        continue block7;
                    }
                    default: {
                        throw new AssertionError((Object)"Should not get here");
                    }
                }
            }
        }
        int mode = 0;
        if (e || r) {
            file.checkRead();
            mode |= r ? 4 : 0;
        }
        if (w) {
            file.checkWrite();
            mode |= 2;
        }
        if (x) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkExec(file.getPathForPermissionCheck());
            }
            mode |= 1;
        }
        try {
            UnixNativeDispatcher.access(file, mode);
        }
        catch (UnixException exc) {
            exc.rethrowAsIOException(file);
        }
    }

    @Override
    public boolean isSameFile(Path obj1, Path obj2) throws IOException {
        UnixFileAttributes attrs2;
        UnixFileAttributes attrs1;
        UnixPath file1 = UnixPath.toUnixPath(obj1);
        if (file1.equals(obj2)) {
            return true;
        }
        if (obj2 == null) {
            throw new NullPointerException();
        }
        if (!(obj2 instanceof UnixPath)) {
            return false;
        }
        UnixPath file2 = (UnixPath)obj2;
        file1.checkRead();
        file2.checkRead();
        try {
            attrs1 = UnixFileAttributes.get(file1, true);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(file1);
            return false;
        }
        try {
            attrs2 = UnixFileAttributes.get(file2, true);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(file2);
            return false;
        }
        return attrs1.isSameFile(attrs2);
    }

    @Override
    public boolean isHidden(Path obj) {
        UnixPath file = UnixPath.toUnixPath(obj);
        file.checkRead();
        UnixPath name = file.getFileName();
        if (name == null) {
            return false;
        }
        return name.asByteArray()[0] == 46;
    }

    abstract FileStore getFileStore(UnixPath var1) throws IOException;

    @Override
    public FileStore getFileStore(Path obj) throws IOException {
        UnixPath file = UnixPath.toUnixPath(obj);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            file.checkRead();
        }
        return this.getFileStore(file);
    }

    @Override
    public void createDirectory(Path obj, FileAttribute<?> ... attrs) throws IOException {
        UnixPath dir = UnixPath.toUnixPath(obj);
        dir.checkWrite();
        int mode = UnixFileModeAttribute.toUnixMode(511, attrs);
        try {
            UnixNativeDispatcher.mkdir(dir, mode);
        }
        catch (UnixException x) {
            if (x.errno() == 21) {
                throw new FileAlreadyExistsException(dir.toString());
            }
            x.rethrowAsIOException(dir);
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path obj, DirectoryStream.Filter<? super Path> filter) throws IOException {
        UnixPath dir = UnixPath.toUnixPath(obj);
        dir.checkRead();
        if (filter == null) {
            throw new NullPointerException();
        }
        if (!UnixNativeDispatcher.openatSupported()) {
            try {
                long ptr = UnixNativeDispatcher.opendir(dir);
                return new UnixDirectoryStream(dir, ptr, filter);
            }
            catch (UnixException x) {
                if (x.errno() == 20) {
                    throw new NotDirectoryException(dir.getPathForExceptionMessage());
                }
                x.rethrowAsIOException(dir);
            }
        }
        int dfd1 = -1;
        int dfd2 = -1;
        long dp = 0L;
        try {
            dfd1 = UnixNativeDispatcher.open(dir, 0, 0);
            dfd2 = UnixNativeDispatcher.dup(dfd1);
            dp = UnixNativeDispatcher.fdopendir(dfd1);
        }
        catch (UnixException x) {
            if (dfd1 != -1) {
                UnixNativeDispatcher.close(dfd1);
            }
            if (dfd2 != -1) {
                UnixNativeDispatcher.close(dfd2);
            }
            if (x.errno() == 20) {
                throw new NotDirectoryException(dir.getPathForExceptionMessage());
            }
            x.rethrowAsIOException(dir);
        }
        return new UnixSecureDirectoryStream(dir, dp, dfd2, filter);
    }

    @Override
    public void createSymbolicLink(Path obj1, Path obj2, FileAttribute<?> ... attrs) throws IOException {
        UnixPath link = UnixPath.toUnixPath(obj1);
        UnixPath target = UnixPath.toUnixPath(obj2);
        if (attrs.length > 0) {
            UnixFileModeAttribute.toUnixMode(0, attrs);
            throw new UnsupportedOperationException("Initial file attributesnot supported when creating symbolic link");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new LinkPermission("symbolic"));
            link.checkWrite();
        }
        try {
            UnixNativeDispatcher.symlink(target.asByteArray(), link);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(link);
        }
    }

    @Override
    public void createLink(Path obj1, Path obj2) throws IOException {
        UnixPath link = UnixPath.toUnixPath(obj1);
        UnixPath existing = UnixPath.toUnixPath(obj2);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new LinkPermission("hard"));
            link.checkWrite();
            existing.checkWrite();
        }
        try {
            UnixNativeDispatcher.link(existing, link);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(link, existing);
        }
    }

    @Override
    public Path readSymbolicLink(Path obj1) throws IOException {
        UnixPath link = UnixPath.toUnixPath(obj1);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission perm = new FilePermission(link.getPathForPermissionCheck(), "readlink");
            sm.checkPermission(perm);
        }
        try {
            byte[] target = UnixNativeDispatcher.readlink(link);
            return new UnixPath(link.getFileSystem(), target);
        }
        catch (UnixException x) {
            if (x.errno() == 22) {
                throw new NotLinkException(link.getPathForExceptionMessage());
            }
            x.rethrowAsIOException(link);
            return null;
        }
    }

    FileTypeDetector getFileTypeDetector() {
        return new AbstractFileTypeDetector(){

            @Override
            public String implProbeContentType(Path file) {
                return null;
            }
        };
    }

    final FileTypeDetector chain(final AbstractFileTypeDetector ... detectors) {
        return new AbstractFileTypeDetector(){

            @Override
            protected String implProbeContentType(Path file) throws IOException {
                for (AbstractFileTypeDetector detector : detectors) {
                    String result = detector.implProbeContentType(file);
                    if (result == null || result.isEmpty()) continue;
                    return result;
                }
                return null;
            }
        };
    }
}

