/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixDirectoryStream;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;
import sun.nio.fs.Util;

class UnixSecureDirectoryStream
implements SecureDirectoryStream<Path> {
    private final UnixDirectoryStream ds;
    private final int dfd;

    UnixSecureDirectoryStream(UnixPath dir, long dp, int dfd, DirectoryStream.Filter<? super Path> filter) {
        this.ds = new UnixDirectoryStream(dir, dp, filter);
        this.dfd = dfd;
    }

    @Override
    public void close() throws IOException {
        this.ds.writeLock().lock();
        try {
            if (this.ds.closeImpl()) {
                UnixNativeDispatcher.close(this.dfd);
            }
        }
        finally {
            this.ds.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.ds.iterator(this);
    }

    private UnixPath getName(Path obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!(obj instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureDirectoryStream<Path> newDirectoryStream(Path obj, LinkOption ... options) throws IOException {
        UnixPath file = this.getName(obj);
        UnixPath child = this.ds.directory().resolve(file);
        boolean followLinks = Util.followLinks(options);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            child.checkRead();
        }
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            int newdfd1 = -1;
            int newdfd2 = -1;
            long ptr = 0L;
            try {
                int flags = 0;
                if (!followLinks) {
                    flags |= 0x100;
                }
                newdfd1 = UnixNativeDispatcher.openat(this.dfd, file.asByteArray(), flags, 0);
                newdfd2 = UnixNativeDispatcher.dup(newdfd1);
                ptr = UnixNativeDispatcher.fdopendir(newdfd1);
            }
            catch (UnixException x) {
                if (newdfd1 != -1) {
                    UnixNativeDispatcher.close(newdfd1);
                }
                if (newdfd2 != -1) {
                    UnixNativeDispatcher.close(newdfd2);
                }
                if (x.errno() == 20) {
                    throw new NotDirectoryException(file.toString());
                }
                x.rethrowAsIOException(file);
            }
            UnixSecureDirectoryStream unixSecureDirectoryStream = new UnixSecureDirectoryStream(child, ptr, newdfd2, null);
            return unixSecureDirectoryStream;
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path obj, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        UnixPath file = this.getName(obj);
        int mode = UnixFileModeAttribute.toUnixMode(438, attrs);
        String pathToCheck = this.ds.directory().resolve(file).getPathForPermissionCheck();
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            try {
                FileChannel fileChannel = UnixChannelFactory.newFileChannel(this.dfd, file, pathToCheck, options, mode);
                return fileChannel;
            }
            catch (UnixException x) {
                x.rethrowAsIOException(file);
                SeekableByteChannel seekableByteChannel = null;
                this.ds.readLock().unlock();
                return seekableByteChannel;
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implDelete(Path obj, boolean haveFlags, int flags) throws IOException {
        UnixPath file = this.getName(obj);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.ds.directory().resolve(file).checkDelete();
        }
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            if (!haveFlags) {
                UnixFileAttributes attrs = null;
                try {
                    attrs = UnixFileAttributes.get(this.dfd, file, false);
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(file);
                }
                flags = attrs.isDirectory() ? 128 : 0;
            }
            try {
                UnixNativeDispatcher.unlinkat(this.dfd, file.asByteArray(), flags);
            }
            catch (UnixException x) {
                if ((flags & 0x80) != 0 && (x.errno() == 17 || x.errno() == 66)) {
                    throw new DirectoryNotEmptyException(null);
                }
                x.rethrowAsIOException(file);
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    @Override
    public void deleteFile(Path file) throws IOException {
        this.implDelete(file, true, 0);
    }

    @Override
    public void deleteDirectory(Path dir) throws IOException {
        this.implDelete(dir, true, 128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path fromObj, SecureDirectoryStream<Path> dir, Path toObj) throws IOException {
        UnixPath from = this.getName(fromObj);
        UnixPath to = this.getName(toObj);
        if (dir == null) {
            throw new NullPointerException();
        }
        if (!(dir instanceof UnixSecureDirectoryStream)) {
            throw new ProviderMismatchException();
        }
        UnixSecureDirectoryStream that = (UnixSecureDirectoryStream)dir;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.ds.directory().resolve(from).checkWrite();
            that.ds.directory().resolve(to).checkWrite();
        }
        this.ds.readLock().lock();
        try {
            that.ds.readLock().lock();
            try {
                if (!this.ds.isOpen() || !that.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                try {
                    UnixNativeDispatcher.renameat(this.dfd, from.asByteArray(), that.dfd, to.asByteArray());
                }
                catch (UnixException x) {
                    if (x.errno() == 18) {
                        throw new AtomicMoveNotSupportedException(from.toString(), to.toString(), x.errorString());
                    }
                    x.rethrowAsIOException(from, to);
                }
            }
            finally {
                that.ds.readLock().unlock();
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    private <V extends FileAttributeView> V getFileAttributeViewImpl(UnixPath file, Class<V> type, boolean followLinks) {
        if (type == null) {
            throw new NullPointerException();
        }
        Class<V> c = type;
        if (c == BasicFileAttributeView.class) {
            return (V)new BasicFileAttributeViewImpl(file, followLinks);
        }
        if (c == PosixFileAttributeView.class || c == FileOwnerAttributeView.class) {
            return (V)new PosixFileAttributeViewImpl(file, followLinks);
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type) {
        return this.getFileAttributeViewImpl(null, type, false);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path obj, Class<V> type, LinkOption ... options) {
        UnixPath file = this.getName(obj);
        boolean followLinks = Util.followLinks(options);
        return this.getFileAttributeViewImpl(file, type, followLinks);
    }

    private class PosixFileAttributeViewImpl
    extends BasicFileAttributeViewImpl
    implements PosixFileAttributeView {
        PosixFileAttributeViewImpl(UnixPath file, boolean followLinks) {
            super(file, followLinks);
        }

        private void checkWriteAndUserAccess() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                ((BasicFileAttributeViewImpl)this).checkWriteAccess();
                sm.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        @Override
        public String name() {
            return "posix";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (this.file == null) {
                    UnixSecureDirectoryStream.this.ds.directory().checkRead();
                } else {
                    UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkRead();
                }
                sm.checkPermission(new RuntimePermission("accessUserInformation"));
            }
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                try {
                    UnixFileAttributes attrs;
                    UnixFileAttributes unixFileAttributes = attrs = this.file == null ? UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd) : UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd, this.file, this.followLinks);
                    return unixFileAttributes;
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(this.file);
                    PosixFileAttributes posixFileAttributes = null;
                    UnixSecureDirectoryStream.this.ds.readLock().unlock();
                    return posixFileAttributes;
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            this.checkWriteAndUserAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int fd = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    UnixNativeDispatcher.fchmod(fd, UnixFileModeAttribute.toUnixMode(perms));
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(this.file);
                }
                finally {
                    if (this.file != null && fd >= 0) {
                        UnixNativeDispatcher.close(fd);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setOwners(int uid, int gid) throws IOException {
            this.checkWriteAndUserAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int fd = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    UnixNativeDispatcher.fchown(fd, uid, gid);
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(this.file);
                }
                finally {
                    if (this.file != null && fd >= 0) {
                        UnixNativeDispatcher.close(fd);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            if (!(owner instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            if (owner instanceof UnixUserPrincipals.Group) {
                throw new IOException("'owner' parameter can't be a group");
            }
            int uid = ((UnixUserPrincipals.User)owner).uid();
            this.setOwners(uid, -1);
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            if (!(group instanceof UnixUserPrincipals.Group)) {
                throw new ProviderMismatchException();
            }
            int gid = ((UnixUserPrincipals.Group)group).gid();
            this.setOwners(-1, gid);
        }
    }

    private class BasicFileAttributeViewImpl
    implements BasicFileAttributeView {
        final UnixPath file;
        final boolean followLinks;

        BasicFileAttributeViewImpl(UnixPath file, boolean followLinks) {
            this.file = file;
            this.followLinks = followLinks;
        }

        int open() throws IOException {
            int oflags = 0;
            if (!this.followLinks) {
                oflags |= 0x100;
            }
            try {
                return UnixNativeDispatcher.openat(UnixSecureDirectoryStream.this.dfd, this.file.asByteArray(), oflags, 0);
            }
            catch (UnixException x) {
                x.rethrowAsIOException(this.file);
                return -1;
            }
        }

        private void checkWriteAccess() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (this.file == null) {
                    UnixSecureDirectoryStream.this.ds.directory().checkWrite();
                } else {
                    UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkWrite();
                }
            }
        }

        @Override
        public String name() {
            return "basic";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    if (this.file == null) {
                        UnixSecureDirectoryStream.this.ds.directory().checkRead();
                    } else {
                        UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkRead();
                    }
                }
                try {
                    UnixFileAttributes attrs = this.file == null ? UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd) : UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd, this.file, this.followLinks);
                    BasicFileAttributes basicFileAttributes = attrs.asBasicFileAttributes();
                    return basicFileAttributes;
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(this.file);
                    BasicFileAttributes basicFileAttributes = null;
                    UnixSecureDirectoryStream.this.ds.readLock().unlock();
                    return basicFileAttributes;
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            this.checkWriteAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int fd = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    if (lastModifiedTime == null || lastAccessTime == null) {
                        try {
                            UnixFileAttributes attrs = UnixFileAttributes.get(fd);
                            if (lastModifiedTime == null) {
                                lastModifiedTime = attrs.lastModifiedTime();
                            }
                            if (lastAccessTime == null) {
                                lastAccessTime = attrs.lastAccessTime();
                            }
                        }
                        catch (UnixException x) {
                            x.rethrowAsIOException(this.file);
                        }
                    }
                    try {
                        UnixNativeDispatcher.futimes(fd, lastAccessTime.to(TimeUnit.MICROSECONDS), lastModifiedTime.to(TimeUnit.MICROSECONDS));
                    }
                    catch (UnixException x) {
                        x.rethrowAsIOException(this.file);
                    }
                }
                finally {
                    if (this.file != null) {
                        UnixNativeDispatcher.close(fd);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }
    }
}

