/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.spi.CalendarProvider;

public class HostLocaleProviderAdapterImpl {
    private static ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> dateFormatPatternsMap = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>(2);
    private static ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> numberFormatPatternsMap = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>(2);
    private static ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> dateFormatSymbolsMap = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>(2);
    private static ConcurrentMap<Locale, SoftReference<DecimalFormatSymbols>> decimalFormatSymbolsMap = new ConcurrentHashMap<Locale, SoftReference<DecimalFormatSymbols>>(2);
    private static final int CAT_DISPLAY = 0;
    private static final int CAT_FORMAT = 1;
    private static final int NF_NUMBER = 0;
    private static final int NF_CURRENCY = 1;
    private static final int NF_PERCENT = 2;
    private static final int NF_INTEGER = 3;
    private static final int NF_MAX = 3;
    private static final int CD_FIRSTDAYOFWEEK = 0;
    private static final int CD_MINIMALDAYSINFIRSTWEEK = 1;
    private static final int DN_LOCALE_LANGUAGE = 0;
    private static final int DN_LOCALE_SCRIPT = 1;
    private static final int DN_LOCALE_REGION = 2;
    private static final int DN_LOCALE_VARIANT = 3;
    private static final int DN_CURRENCY_CODE = 4;
    private static final int DN_CURRENCY_SYMBOL = 5;
    private static final int DN_TZ_SHORT_STANDARD = 0;
    private static final int DN_TZ_SHORT_DST = 1;
    private static final int DN_TZ_LONG_STANDARD = 2;
    private static final int DN_TZ_LONG_DST = 3;
    private static final Set<Locale> supportedLocaleSet;
    private static final Locale[] supportedLocale;

    private static Locale convertMacOSXLocaleToJavaLocale(String macosxloc) {
        String[] tmp = macosxloc.split("@");
        String langTag = tmp[0].replace('_', '-');
        if (tmp.length > 1) {
            String[] ext;
            block8: for (String keyval : ext = tmp[1].split(";")) {
                String calid;
                if (!keyval.startsWith("calendar=")) continue;
                switch (calid = keyval.substring(keyval.indexOf(61) + 1)) {
                    case "gregorian": {
                        langTag = langTag + "-u-ca-gregory";
                        continue block8;
                    }
                    case "japanese": {
                        if (tmp[0].equals("ja_JP")) {
                            return JRELocaleConstants.JA_JP_JP;
                        }
                    }
                    default: {
                        langTag = langTag + "-u-ca-" + calid;
                    }
                }
            }
        }
        return Locale.forLanguageTag(langTag);
    }

    public static DateFormatProvider getDateFormatProvider() {
        return new DateFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public DateFormat getDateInstance(int style, Locale locale) {
                return new SimpleDateFormat(this.getDateTimePattern(style, -1, locale), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getTimeInstance(int style, Locale locale) {
                return new SimpleDateFormat(this.getDateTimePattern(-1, style, locale), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
                return new SimpleDateFormat(this.getDateTimePattern(dateStyle, timeStyle, locale), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            private String getDateTimePattern(int dateStyle, int timeStyle, Locale locale) {
                String langTag;
                int index;
                String pattern;
                AtomicReferenceArray<String> dateFormatPatterns;
                SoftReference ref = (SoftReference)dateFormatPatternsMap.get(locale);
                if (ref == null || (dateFormatPatterns = (AtomicReferenceArray<String>)ref.get()) == null) {
                    dateFormatPatterns = new AtomicReferenceArray<String>(25);
                    ref = new SoftReference(dateFormatPatterns);
                    dateFormatPatternsMap.put(locale, ref);
                }
                if ((pattern = (String)dateFormatPatterns.get(index = (dateStyle + 1) * 5 + timeStyle + 1)) == null && !dateFormatPatterns.compareAndSet(index, null, pattern = HostLocaleProviderAdapterImpl.translateDateFormatLetters(HostLocaleProviderAdapterImpl.getCalendarID(langTag = locale.toLanguageTag()), HostLocaleProviderAdapterImpl.getDateTimePatternNative(dateStyle, timeStyle, langTag)))) {
                    pattern = (String)dateFormatPatterns.get(index);
                }
                return pattern;
            }
        };
    }

    public static DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        return new DateFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                if (this.isSupportedLocale(Locale.getDefault(Locale.Category.FORMAT))) {
                    return supportedLocale;
                }
                return new Locale[0];
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                Locale base = locale.stripExtensions();
                if (supportedLocaleSet.contains(base)) {
                    return HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag()).equals("gregorian");
                }
                return false;
            }

            @Override
            public DateFormatSymbols getInstance(Locale locale) {
                DateFormatSymbols dateFormatSymbols;
                SoftReference<DateFormatSymbols> ref = (SoftReference<DateFormatSymbols>)dateFormatSymbolsMap.get(locale);
                if (ref == null || (dateFormatSymbols = (DateFormatSymbols)ref.get()) == null) {
                    dateFormatSymbols = new DateFormatSymbols(locale);
                    String langTag = locale.toLanguageTag();
                    dateFormatSymbols.setAmPmStrings(HostLocaleProviderAdapterImpl.getAmPmStrings(langTag, dateFormatSymbols.getAmPmStrings()));
                    dateFormatSymbols.setEras(HostLocaleProviderAdapterImpl.getEras(langTag, dateFormatSymbols.getEras()));
                    dateFormatSymbols.setMonths(HostLocaleProviderAdapterImpl.getMonths(langTag, dateFormatSymbols.getMonths()));
                    dateFormatSymbols.setShortMonths(HostLocaleProviderAdapterImpl.getShortMonths(langTag, dateFormatSymbols.getShortMonths()));
                    dateFormatSymbols.setWeekdays(HostLocaleProviderAdapterImpl.getWeekdays(langTag, dateFormatSymbols.getWeekdays()));
                    dateFormatSymbols.setShortWeekdays(HostLocaleProviderAdapterImpl.getShortWeekdays(langTag, dateFormatSymbols.getShortWeekdays()));
                    ref = new SoftReference<DateFormatSymbols>(dateFormatSymbols);
                    dateFormatSymbolsMap.put(locale, ref);
                }
                return (DateFormatSymbols)dateFormatSymbols.clone();
            }
        };
    }

    public static NumberFormatProvider getNumberFormatProvider() {
        return new NumberFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public NumberFormat getCurrencyInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(1, locale), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getIntegerInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(3, locale), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getNumberInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(0, locale), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getPercentInstance(Locale locale) {
                return new DecimalFormat(this.getNumberPattern(2, locale), DecimalFormatSymbols.getInstance(locale));
            }

            private String getNumberPattern(int style, Locale locale) {
                String pattern;
                AtomicReferenceArray<String> numberFormatPatterns;
                SoftReference ref = (SoftReference)numberFormatPatternsMap.get(locale);
                if (ref == null || (numberFormatPatterns = (AtomicReferenceArray<String>)ref.get()) == null) {
                    numberFormatPatterns = new AtomicReferenceArray<String>(4);
                    ref = new SoftReference(numberFormatPatterns);
                    numberFormatPatternsMap.put(locale, ref);
                }
                if ((pattern = (String)numberFormatPatterns.get(style)) == null && !numberFormatPatterns.compareAndSet(style, null, pattern = HostLocaleProviderAdapterImpl.getNumberPatternNative(style, locale.toLanguageTag()))) {
                    pattern = (String)numberFormatPatterns.get(style);
                }
                return pattern;
            }
        };
    }

    public static DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        return new DecimalFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public DecimalFormatSymbols getInstance(Locale locale) {
                DecimalFormatSymbols decimalFormatSymbols;
                SoftReference<DecimalFormatSymbols> ref = (SoftReference<DecimalFormatSymbols>)decimalFormatSymbolsMap.get(locale);
                if (ref == null || (decimalFormatSymbols = (DecimalFormatSymbols)ref.get()) == null) {
                    decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    String langTag = locale.toLanguageTag();
                    decimalFormatSymbols.setInternationalCurrencySymbol(HostLocaleProviderAdapterImpl.getInternationalCurrencySymbol(langTag, decimalFormatSymbols.getInternationalCurrencySymbol()));
                    decimalFormatSymbols.setCurrencySymbol(HostLocaleProviderAdapterImpl.getCurrencySymbol(langTag, decimalFormatSymbols.getCurrencySymbol()));
                    decimalFormatSymbols.setDecimalSeparator(HostLocaleProviderAdapterImpl.getDecimalSeparator(langTag, decimalFormatSymbols.getDecimalSeparator()));
                    decimalFormatSymbols.setGroupingSeparator(HostLocaleProviderAdapterImpl.getGroupingSeparator(langTag, decimalFormatSymbols.getGroupingSeparator()));
                    decimalFormatSymbols.setInfinity(HostLocaleProviderAdapterImpl.getInfinity(langTag, decimalFormatSymbols.getInfinity()));
                    decimalFormatSymbols.setMinusSign(HostLocaleProviderAdapterImpl.getMinusSign(langTag, decimalFormatSymbols.getMinusSign()));
                    decimalFormatSymbols.setMonetaryDecimalSeparator(HostLocaleProviderAdapterImpl.getMonetaryDecimalSeparator(langTag, decimalFormatSymbols.getMonetaryDecimalSeparator()));
                    decimalFormatSymbols.setNaN(HostLocaleProviderAdapterImpl.getNaN(langTag, decimalFormatSymbols.getNaN()));
                    decimalFormatSymbols.setPercent(HostLocaleProviderAdapterImpl.getPercent(langTag, decimalFormatSymbols.getPercent()));
                    decimalFormatSymbols.setPerMill(HostLocaleProviderAdapterImpl.getPerMill(langTag, decimalFormatSymbols.getPerMill()));
                    decimalFormatSymbols.setZeroDigit(HostLocaleProviderAdapterImpl.getZeroDigit(langTag, decimalFormatSymbols.getZeroDigit()));
                    decimalFormatSymbols.setExponentSeparator(HostLocaleProviderAdapterImpl.getExponentSeparator(langTag, decimalFormatSymbols.getExponentSeparator()));
                    ref = new SoftReference<DecimalFormatSymbols>(decimalFormatSymbols);
                    decimalFormatSymbolsMap.put(locale, ref);
                }
                return (DecimalFormatSymbols)decimalFormatSymbols.clone();
            }
        };
    }

    public static CalendarDataProvider getCalendarDataProvider() {
        return new CalendarDataProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public int getFirstDayOfWeek(Locale locale) {
                return HostLocaleProviderAdapterImpl.getCalendarInt(locale.toLanguageTag(), 0);
            }

            @Override
            public int getMinimalDaysInFirstWeek(Locale locale) {
                return HostLocaleProviderAdapterImpl.getCalendarInt(locale.toLanguageTag(), 1);
            }
        };
    }

    public static CalendarNameProvider getCalendarNameProvider() {
        return new CalendarNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public String getDisplayName(String calType, int field, int value, int style, Locale locale) {
                return null;
            }

            @Override
            public Map<String, Integer> getDisplayNames(String calType, int field, int style, Locale locale) {
                return null;
            }
        };
    }

    public static CalendarProvider getCalendarProvider() {
        return new CalendarProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public Calendar getInstance(TimeZone zone, Locale locale) {
                return new Calendar.Builder().setLocale(locale).setCalendarType(HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag())).setTimeZone(zone).setInstant(System.currentTimeMillis()).build();
            }
        };
    }

    public static CurrencyNameProvider getCurrencyNameProvider() {
        return new CurrencyNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public String getDisplayName(String code, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 4, code);
            }

            @Override
            public String getSymbol(String code, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 5, code);
            }
        };
    }

    public static LocaleNameProvider getLocaleNameProvider() {
        return new LocaleNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public String getDisplayLanguage(String languageCode, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 0, languageCode);
            }

            @Override
            public String getDisplayCountry(String countryCode, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 2, countryCode);
            }

            @Override
            public String getDisplayScript(String scriptCode, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 1, scriptCode);
            }

            @Override
            public String getDisplayVariant(String variantCode, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 3, variantCode);
            }
        };
    }

    public static TimeZoneNameProvider getTimeZoneNameProvider() {
        return new TimeZoneNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions());
            }

            @Override
            public String getDisplayName(String ID2, boolean daylight, int style, Locale locale) {
                return HostLocaleProviderAdapterImpl.getTimeZoneDisplayString(locale.toLanguageTag(), style * 2 + (daylight ? 1 : 0), ID2);
            }
        };
    }

    private static Locale[] getSupportedCalendarLocales() {
        if (supportedLocale.length != 0 && supportedLocaleSet.contains(Locale.JAPAN) && HostLocaleProviderAdapterImpl.isJapaneseCalendar()) {
            Locale[] sup = new Locale[supportedLocale.length + 1];
            sup[0] = JRELocaleConstants.JA_JP_JP;
            System.arraycopy(supportedLocale, 0, sup, 1, supportedLocale.length);
            return sup;
        }
        return supportedLocale;
    }

    private static boolean isSupportedCalendarLocale(Locale locale) {
        Locale base = locale;
        if (base.hasExtensions() || base.getVariant() != "") {
            base = new Locale.Builder().setLocale(locale).clearExtensions().build();
        }
        if (!supportedLocaleSet.contains(base)) {
            return false;
        }
        String requestedCalType = locale.getUnicodeLocaleType("ca");
        String nativeCalType = HostLocaleProviderAdapterImpl.getCalendarID(base.toLanguageTag()).replaceFirst("gregorian", "gregory");
        if (requestedCalType == null) {
            return Calendar.getAvailableCalendarTypes().contains(nativeCalType);
        }
        return requestedCalType.equals(nativeCalType);
    }

    private static boolean isJapaneseCalendar() {
        return HostLocaleProviderAdapterImpl.getCalendarID("ja-JP").equals("japanese");
    }

    private static Locale getCalendarLocale(Locale locale) {
        String nativeCalType = HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag()).replaceFirst("gregorian", "gregory");
        if (Calendar.getAvailableCalendarTypes().contains(nativeCalType)) {
            return new Locale.Builder().setLocale(locale).setUnicodeLocaleKeyword("ca", nativeCalType).build();
        }
        return locale;
    }

    private static String translateDateFormatLetters(String calendarType, String cldrFormat) {
        String pattern = cldrFormat;
        int length = pattern.length();
        boolean inQuote = false;
        StringBuilder jrePattern = new StringBuilder(length);
        int count = 0;
        char lastLetter = '\u0000';
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (c == '\'') {
                char nextc;
                if (i + 1 < length && (nextc = pattern.charAt(i + 1)) == '\'') {
                    ++i;
                    if (count != 0) {
                        HostLocaleProviderAdapterImpl.convert(calendarType, lastLetter, count, jrePattern);
                        lastLetter = '\u0000';
                        count = 0;
                    }
                    jrePattern.append("''");
                    continue;
                }
                if (!inQuote) {
                    if (count != 0) {
                        HostLocaleProviderAdapterImpl.convert(calendarType, lastLetter, count, jrePattern);
                        lastLetter = '\u0000';
                        count = 0;
                    }
                    inQuote = true;
                } else {
                    inQuote = false;
                }
                jrePattern.append(c);
                continue;
            }
            if (inQuote) {
                jrePattern.append(c);
                continue;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                if (count != 0) {
                    HostLocaleProviderAdapterImpl.convert(calendarType, lastLetter, count, jrePattern);
                    lastLetter = '\u0000';
                    count = 0;
                }
                jrePattern.append(c);
                continue;
            }
            if (lastLetter == '\u0000' || lastLetter == c) {
                lastLetter = c;
                ++count;
                continue;
            }
            HostLocaleProviderAdapterImpl.convert(calendarType, lastLetter, count, jrePattern);
            lastLetter = c;
            count = 1;
        }
        if (count != 0) {
            HostLocaleProviderAdapterImpl.convert(calendarType, lastLetter, count, jrePattern);
        }
        if (cldrFormat.contentEquals(jrePattern)) {
            return cldrFormat;
        }
        return jrePattern.toString();
    }

    private static void convert(String calendarType, char cldrLetter, int count, StringBuilder sb) {
        switch (cldrLetter) {
            case 'G': {
                if (!calendarType.equals("gregorian")) {
                    if (count == 5) {
                        count = 1;
                    } else if (count == 1) {
                        count = 4;
                    }
                }
                HostLocaleProviderAdapterImpl.appendN(cldrLetter, count, sb);
                break;
            }
            case 'c': 
            case 'e': {
                switch (count) {
                    case 1: {
                        sb.append('u');
                        break;
                    }
                    case 3: 
                    case 4: {
                        HostLocaleProviderAdapterImpl.appendN('E', count, sb);
                        break;
                    }
                    case 5: {
                        HostLocaleProviderAdapterImpl.appendN('E', 3, sb);
                    }
                }
                break;
            }
            case 'V': 
            case 'v': {
                HostLocaleProviderAdapterImpl.appendN('z', count, sb);
                break;
            }
            case 'Z': {
                if (count != 4 && count != 5) break;
                sb.append("XXX");
                break;
            }
            case 'A': 
            case 'Q': 
            case 'U': 
            case 'g': 
            case 'j': 
            case 'l': 
            case 'q': 
            case 'u': {
                sb.append('\'');
                sb.append(cldrLetter);
                sb.append('\'');
                break;
            }
            default: {
                HostLocaleProviderAdapterImpl.appendN(cldrLetter, count, sb);
            }
        }
    }

    private static void appendN(char c, int n, StringBuilder sb) {
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
    }

    private static native String getDefaultLocale(int var0);

    private static native String getDateTimePatternNative(int var0, int var1, String var2);

    private static native String getCalendarID(String var0);

    private static native String getNumberPatternNative(int var0, String var1);

    private static native String[] getAmPmStrings(String var0, String[] var1);

    private static native String[] getEras(String var0, String[] var1);

    private static native String[] getMonths(String var0, String[] var1);

    private static native String[] getShortMonths(String var0, String[] var1);

    private static native String[] getWeekdays(String var0, String[] var1);

    private static native String[] getShortWeekdays(String var0, String[] var1);

    private static native String getCurrencySymbol(String var0, String var1);

    private static native char getDecimalSeparator(String var0, char var1);

    private static native char getGroupingSeparator(String var0, char var1);

    private static native String getInfinity(String var0, String var1);

    private static native String getInternationalCurrencySymbol(String var0, String var1);

    private static native char getMinusSign(String var0, char var1);

    private static native char getMonetaryDecimalSeparator(String var0, char var1);

    private static native String getNaN(String var0, String var1);

    private static native char getPercent(String var0, char var1);

    private static native char getPerMill(String var0, char var1);

    private static native char getZeroDigit(String var0, char var1);

    private static native String getExponentSeparator(String var0, String var1);

    private static native int getCalendarInt(String var0, int var1);

    private static native String getDisplayString(String var0, int var1, String var2);

    private static native String getTimeZoneDisplayString(String var0, int var1, String var2);

    static {
        HashSet<Locale> tmpSet = new HashSet<Locale>();
        Locale l = HostLocaleProviderAdapterImpl.convertMacOSXLocaleToJavaLocale(HostLocaleProviderAdapterImpl.getDefaultLocale(1));
        tmpSet.addAll(ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", l));
        l = HostLocaleProviderAdapterImpl.convertMacOSXLocaleToJavaLocale(HostLocaleProviderAdapterImpl.getDefaultLocale(0));
        tmpSet.addAll(ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", l));
        supportedLocaleSet = Collections.unmodifiableSet(tmpSet);
        supportedLocale = supportedLocaleSet.toArray(new Locale[0]);
    }
}

