/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.CompilerProgressListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.OSUtils;

public class EditorStatus
extends JPanel {
    private static final int NOTICE = 0;
    private static final int ERR = 1;
    private static final int EDIT = 2;
    private static final int PROGRESS = 5;
    private static final String NO_MESSAGE = "";
    private static final Color[] BGCOLOR = new Color[6];
    private static final Color[] FGCOLOR;
    static final int GRID_SIZE = 33;
    private final Editor editor;
    private final Font font;
    private int mode;
    private String message;
    private Image offscreen;
    private int sizeW;
    private int sizeH;
    private int imageW;
    private int imageH;
    private JButton cancelButton;
    private JButton okButton;
    private JTextField editField;
    private JProgressBar progressBar;
    private JButton copyErrorButton;
    private ArrayList<CompilerProgressListener> compilerProgressListeners;

    public EditorStatus(Editor editor) {
        this.editor = editor;
        this.message = NO_MESSAGE;
        this.mode = 0;
        this.font = Theme.getFont("status.font");
        this.compilerProgressListeners = new ArrayList();
        this.compilerProgressListeners.add(this::progressUpdate);
        this.initialize();
    }

    public void clearState() {
        this.changeState(0);
        this.repaint();
    }

    private void changeState(int newMode) {
        if (this.mode == newMode) {
            return;
        }
        this.mode = newMode;
        if (this.cancelButton.isVisible()) {
            this.cancelButton.doClick();
        }
        this.cancelButton.setVisible(false);
        this.okButton.setVisible(false);
        this.editField.setVisible(false);
        this.progressBar.setVisible(false);
        this.copyErrorButton.setVisible(false);
        this.message = NO_MESSAGE;
    }

    public void notice(String message) {
        this.changeState(0);
        this.message = message;
        if (this.copyErrorButton != null) {
            this.copyErrorButton.setVisible(false);
        }
        this.repaint();
    }

    public void error(String message) {
        this.changeState(1);
        this.message = message;
        if (this.copyErrorButton != null) {
            this.copyErrorButton.setVisible(true);
        }
        this.repaint();
    }

    public void edit(String message, String dflt) {
        this.changeState(2);
        this.message = message;
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.editField.setVisible(true);
        this.editField.setText(dflt);
        this.editField.selectAll();
        this.editField.requestFocusInWindow();
        this.repaint();
    }

    private void unedit() {
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.editField.setVisible(false);
        this.clearState();
        this.repaint();
    }

    public void progress(String message) {
        this.changeState(5);
        this.message = message;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(true);
        this.copyErrorButton.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.repaint();
    }

    public void progressNotice(String message) {
        this.message = message;
        this.repaint();
    }

    public void unprogress() {
        if (PreferencesData.getBoolean((String)"editor.beep.compile")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.progressBar == null) {
            return;
        }
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
        this.setCursor(null);
    }

    public void progressUpdate(int value) {
        if (this.progressBar == null) {
            return;
        }
        this.progressBar.setValue(value);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics screen) {
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
                this.setButtonBounds();
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.setButtonBounds();
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics2D g = Theme.setupGraphics2D(this.offscreen.getGraphics());
        g.setColor(BGCOLOR[this.mode]);
        g.fillRect(0, 0, this.imageW, this.imageH);
        g.setColor(FGCOLOR[this.mode]);
        g.setFont(this.font);
        int ascent = g.getFontMetrics().getAscent();
        assert (this.message != null);
        g.drawString(this.message, 6, (this.sizeH + ascent) / 2);
        screen.drawImage(this.offscreen, 0, 0, null);
    }

    private void initialize() {
        this.cancelButton = new JButton(I18n.PROMPT_CANCEL);
        this.okButton = new JButton(I18n.PROMPT_OK);
        this.cancelButton.addActionListener(e -> {
            if (this.mode == 2) {
                this.unedit();
            }
        });
        this.okButton.addActionListener(e -> {
            if (this.mode == 2) {
                String answer = this.editField.getText();
                this.editor.getSketchController().nameCode(answer);
                this.unedit();
            }
        });
        if (OSUtils.isMacOS()) {
            this.cancelButton.setBackground(BGCOLOR[2]);
            this.okButton.setBackground(BGCOLOR[2]);
        }
        this.setLayout(null);
        this.add(this.cancelButton);
        this.add(this.okButton);
        this.cancelButton.setVisible(false);
        this.okButton.setVisible(false);
        this.editField = new JTextField();
        this.editField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyChar() == '\u001b') {
                    EditorStatus.this.unedit();
                    event.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent event) {
                char c = event.getKeyChar();
                if (c == '\n') {
                    String answer = EditorStatus.this.editField.getText();
                    EditorStatus.this.editor.getSketchController().nameCode(answer);
                    EditorStatus.this.unedit();
                    event.consume();
                } else if (c != '\b' && c != '\u007f' && c != '\'' && c != '%' && c != '&' && c != '(' && c != '$' && c != '#' && c != '\u0010') {
                    if (c == ' ') {
                        String t = EditorStatus.this.editField.getText();
                        int start = EditorStatus.this.editField.getSelectionStart();
                        int end = EditorStatus.this.editField.getSelectionEnd();
                        EditorStatus.this.editField.setText(t.substring(0, start) + "_" + t.substring(end));
                        EditorStatus.this.editField.setCaretPosition(start + 1);
                        event.consume();
                    } else if (!(c == '_' || c == '.' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                        event.consume();
                    }
                }
            }
        });
        this.add(this.editField);
        this.editField.setVisible(false);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progressBar.setBorderPainted(true);
        this.add(this.progressBar);
        this.progressBar.setVisible(false);
        this.copyErrorButton = new JButton(I18n.tr((String)"Copy error messages"));
        this.add(this.copyErrorButton);
        this.copyErrorButton.setVisible(false);
        this.copyErrorButton.addActionListener(e -> {
            String message1 = NO_MESSAGE;
            message1 = message1 + I18n.tr((String)"Arduino: ") + BaseNoGui.VERSION_NAME_LONG + " (" + System.getProperty("os.name") + "), ";
            message1 = message1 + "TD: " + BaseNoGui.teensyduino_version + ", ";
            message1 = message1 + I18n.tr((String)"Board: ") + "\"" + (String)BaseNoGui.getBoardPreferences().get((Object)"name") + "\"\n\n";
            message1 = message1 + this.editor.console.getText();
            if (!PreferencesData.getBoolean((String)"build.verbose")) {
                message1 = message1 + "\n\n";
                message1 = message1 + I18n.tr((String)"This report would have more information with\n\"Show verbose output during compilation\"\noption enabled in File -> Preferences.\n");
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(message1);
            clipboard.setContents(data, null);
            Clipboard unixclipboard = Toolkit.getDefaultToolkit().getSystemSelection();
            if (unixclipboard != null) {
                unixclipboard.setContents(data, null);
            }
        });
    }

    private void setButtonBounds() {
        int top = (this.sizeH - Preferences.BUTTON_HEIGHT) / 2;
        int eachButton = 6 + Preferences.BUTTON_WIDTH;
        int cancelLeft = this.sizeW - eachButton;
        int noLeft = cancelLeft - eachButton;
        int yesLeft = noLeft - eachButton;
        this.cancelButton.setLocation(cancelLeft, top);
        this.okButton.setLocation(noLeft, top);
        this.progressBar.setLocation(noLeft, top);
        this.cancelButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.okButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.progressBar.setSize(2 * Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        int editWidth = 2 * Preferences.BUTTON_WIDTH;
        int editHeight = this.editField.getPreferredSize().height;
        int editTop = (1 + this.sizeH - editHeight) / 2;
        this.editField.setBounds(yesLeft - Preferences.BUTTON_WIDTH, editTop, editWidth, editHeight);
        this.progressBar.setBounds(noLeft, editTop, editWidth, editHeight);
        Dimension copyErrorButtonSize = this.copyErrorButton.getPreferredSize();
        this.copyErrorButton.setLocation(this.sizeW - copyErrorButtonSize.width - 5, top);
        this.copyErrorButton.setSize(copyErrorButtonSize.width, Preferences.BUTTON_HEIGHT);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return Theme.scale(new Dimension(300, 33));
    }

    @Override
    public Dimension getMaximumSize() {
        return Theme.scale(new Dimension(3000, 33));
    }

    public boolean isErr() {
        return this.mode == 1;
    }

    public void addCompilerProgressListener(CompilerProgressListener listener) {
        this.compilerProgressListeners.add(listener);
    }

    public ArrayList<CompilerProgressListener> getCompilerProgressListeners() {
        return this.compilerProgressListeners;
    }

    static {
        EditorStatus.BGCOLOR[0] = Theme.getColor("status.notice.bgcolor");
        EditorStatus.BGCOLOR[1] = Theme.getColor("status.error.bgcolor");
        EditorStatus.BGCOLOR[2] = Theme.getColor("status.edit.bgcolor");
        EditorStatus.BGCOLOR[3] = null;
        EditorStatus.BGCOLOR[4] = null;
        EditorStatus.BGCOLOR[5] = Theme.getColor("status.notice.bgcolor");
        FGCOLOR = new Color[6];
        EditorStatus.FGCOLOR[0] = Theme.getColor("status.notice.fgcolor");
        EditorStatus.FGCOLOR[1] = Theme.getColor("status.error.fgcolor");
        EditorStatus.FGCOLOR[2] = Theme.getColor("status.edit.fgcolor");
        EditorStatus.FGCOLOR[3] = null;
        EditorStatus.FGCOLOR[4] = null;
        EditorStatus.FGCOLOR[5] = Theme.getColor("status.notice.fgcolor");
    }
}

