/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import processing.app.BaseNoGui;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.inputListener;

class FakeSerial
extends Serial {
    Socket sock = null;
    InputStream input;
    OutputStream output;
    inputListener listener = null;
    int[] addrlist = new int[]{28541, 4984, 18924, 16924, 27183, 31091};
    static Process gateway = null;
    static boolean gateway_shutdown_scheduled = false;

    public FakeSerial(String name) throws SerialException {
        super("fake serial");
        int attempt = 1;
        do {
            if (this.gateway_connect(name)) {
                this.listener = new inputListener();
                this.listener.input = this.input;
                this.listener.consumer = this;
                this.listener.start();
                return;
            }
            if (attempt <= 2 && !this.gateway_start(name)) {
                System.err.println("Error starting " + name);
            }
            this.delay_20ms();
        } while (++attempt < 4);
        throw new SerialException("no connection");
    }

    private boolean gateway_connect(String name) {
        InetAddress local;
        int namelen = name.length();
        byte[] buf = new byte[namelen];
        byte[] namebuf = name.getBytes();
        try {
            byte[] loop = new byte[]{127, 0, 0, 1};
            local = InetAddress.getByAddress("localhost", loop);
        }
        catch (Exception e) {
            this.sock = null;
            return false;
        }
        for (int i = 0; i < this.addrlist.length; ++i) {
            try {
                this.sock = new Socket();
                InetSocketAddress addr = new InetSocketAddress(local, this.addrlist[i]);
                this.sock.connect(addr, 50);
                this.input = this.sock.getInputStream();
                this.output = this.sock.getOutputStream();
            }
            catch (Exception e) {
                this.sock = null;
                return false;
            }
            try {
                int wait = 0;
                while (this.input.available() < namelen) {
                    if (++wait > 6) {
                        throw new Exception();
                    }
                    this.delay_20ms();
                }
                this.input.read(buf, 0, namelen);
                String id = new String(buf, 0, namelen);
                for (int n = 0; n < namelen; ++n) {
                    if (buf[n] == namebuf[n]) continue;
                    throw new Exception();
                }
            }
            catch (Exception e) {
                this.close_sock();
                continue;
            }
            return true;
        }
        this.sock = null;
        return false;
    }

    private void close_sock() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sock = null;
    }

    private void delay_20ms() {
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.listener != null) {
            this.listener.interrupt();
            this.listener.consumer = null;
            this.listener = null;
        }
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock = null;
        }
        FakeSerial.dispose_gateway();
    }

    public static void dispose_gateway() {
        if (gateway != null) {
            gateway.destroy();
            gateway = null;
        }
    }

    private boolean gateway_start(String cmd) {
        String cmdline = BaseNoGui.getHardwarePath() + File.separator + "tools" + File.separator + cmd;
        try {
            FakeSerial.dispose_gateway();
            gateway = Runtime.getRuntime().exec(new String[]{cmdline});
            if (!gateway_shutdown_scheduled) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        FakeSerial.dispose_gateway();
                    }
                });
                gateway_shutdown_scheduled = true;
            }
        }
        catch (Exception e) {
            FakeSerial.dispose_gateway();
            return false;
        }
        return true;
    }

    protected void message(char[] chars, int length) {
    }

    public void write(byte[] bytes) {
        if (this.output == null) {
            return;
        }
        if (bytes.length > 0) {
            try {
                this.output.write(bytes, 0, bytes.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(int what) {
        byte[] b = new byte[]{(byte)(what & 0xFF)};
        this.write(b);
    }

    public void setDTR(boolean state) {
    }

    public void setRTS(boolean state) {
    }

    public boolean isOnline() {
        return true;
    }

    public static ArrayList<String> list() {
        return new ArrayList<String>();
    }
}

