/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import processing.app.FifoElementLine;
import processing.app.FifoElementRoot;
import processing.app.FifoEvent;
import processing.app.FifoPosition;

public class FifoDocument
implements Document {
    private int char_head;
    private int char_tail;
    private final int char_size;
    private final int char_threshold;
    private char[] char_buf;
    private long char_total;
    private FifoElementRoot line_root;
    private int line_head;
    private int line_tail;
    private final int line_size;
    private final int line_threshold;
    private FifoElementLine[] line_buf;
    private boolean last_line_incomplete;
    private int[] newline_offset;
    private final List<DocumentListener> listeners;
    private boolean scrolling = true;
    private final FifoEvent insertEvent;
    private final FifoEvent removeEvent;
    private final FifoPosition startPosition;
    private final FifoPosition endPosition;
    private long prior_milliseconds = 0L;

    public FifoDocument(int size) {
        this.char_size = size;
        this.char_threshold = this.char_size * 6 / 10;
        this.char_head = 0;
        this.char_tail = 0;
        this.char_buf = new char[this.char_size];
        this.char_total = 0L;
        this.line_root = new FifoElementRoot(this);
        this.line_size = size / 10;
        this.line_threshold = this.line_size * 6 / 10;
        this.line_head = 0;
        this.line_tail = 0;
        this.line_buf = new FifoElementLine[this.line_size];
        for (int i = 0; i < this.line_size; ++i) {
            this.line_buf[i] = new FifoElementLine(this, i);
        }
        this.newline_offset = new int[this.char_size - this.char_threshold];
        this.last_line_incomplete = false;
        this.listeners = new ArrayList<DocumentListener>();
        this.insertEvent = new FifoEvent(this, DocumentEvent.EventType.INSERT);
        this.removeEvent = new FifoEvent(this, DocumentEvent.EventType.REMOVE);
        this.startPosition = new FifoPosition(this, 0L);
        this.endPosition = new FifoPosition(this, Long.MAX_VALUE);
    }

    public synchronized void setScrollingMode(boolean mode) {
        this.scrolling = mode;
    }

    public synchronized void free() {
        this.char_tail = 0;
        this.char_head = 0;
        this.line_tail = 0;
        this.line_head = 0;
        this.char_buf = null;
        this.line_buf = null;
        this.newline_offset = null;
        System.gc();
    }

    public synchronized int charIndexToOffset(int index) {
        if (this.char_buf == null) {
            return 0;
        }
        int offset = index - this.char_tail - 1;
        if (offset < 0) {
            offset += this.char_size;
        }
        return offset;
    }

    public synchronized int lineIndexToOffset(int index) {
        if (this.char_buf == null) {
            return 0;
        }
        int offset = index - this.line_tail - 1;
        if (offset < 0) {
            offset += this.line_size;
        }
        return offset;
    }

    public char[] getBuffer() {
        return this.char_buf;
    }

    public synchronized int getAppendIndex() {
        int head = this.char_head + 1;
        if (head >= this.char_size) {
            head = 0;
        }
        return head;
    }

    public synchronized int getAvailableToAppend() {
        int available;
        int tail;
        int head = this.char_head + 1;
        if (head >= this.char_size) {
            head = 0;
        }
        if ((tail = this.char_tail + 1) >= this.char_size) {
            tail = 0;
        }
        if ((available = head < tail ? tail - head - 1 : this.char_size - head) > this.char_size - this.char_threshold) {
            available = this.char_size - this.char_threshold;
        }
        return available;
    }

    public synchronized void processAppended(int char_len) {
        int chead;
        if (!SwingUtilities.isEventDispatchThread()) {
            System.err.println("FifoDocument processAppended called from wrong thread");
        }
        if ((chead = this.char_head + 1) >= this.char_size) {
            chead = 0;
        }
        int newline_count = 0;
        for (int i = 0; i < char_len; ++i) {
            if (this.char_buf[chead + i] != '\n') continue;
            this.newline_offset[newline_count++] = i;
        }
        int line_len = newline_count > 0 && this.newline_offset[newline_count - 1] == char_len - 1 ? (this.last_line_incomplete ? newline_count - 1 : newline_count) : (this.last_line_incomplete ? newline_count : newline_count + 1);
        this.println("processAppended, newline_count = " + newline_count + ", line_len = " + line_len);
        this.println("  TEXT=\"" + new String(this.char_buf, chead, char_len) + "\"");
        if (this.scrolling) {
            int len;
            int char_count = this.getCharCount();
            int line_count = this.getElementCount();
            int ctail = this.char_tail;
            int ctail_begin = ctail + 1;
            if (ctail_begin >= this.char_size) {
                ctail_begin = 0;
            }
            int cdelete = 0;
            int ltail = this.line_tail;
            int ltail_begin = ltail + 1;
            if (ltail_begin >= this.line_size) {
                ltail_begin = 0;
            }
            int ldelete = 0;
            FifoElementLine shortened = null;
            int lines_to_delete = line_count + line_len - this.line_threshold;
            if (lines_to_delete > 0) {
                this.println("delete step #1, " + lines_to_delete + " lines");
                ldelete = lines_to_delete;
                line_count -= lines_to_delete;
                do {
                    if (++ltail >= this.line_size) {
                        ltail = 0;
                    }
                    if ((ctail += (len = this.line_buf[ltail].getLength())) >= this.char_size) {
                        ctail -= this.char_size;
                    }
                    char_count -= len;
                    cdelete += len;
                } while (--lines_to_delete > 0);
            }
            while (char_count + char_len > this.char_threshold && line_count > 1) {
                if (++ltail >= this.line_size) {
                    ltail = 0;
                }
                len = this.line_buf[ltail].getLength();
                this.println("delete step #2, line with " + len + " chars, lines=" + line_count + ", chars=" + char_count + ", thres=" + this.char_threshold + ", clen=" + char_len);
                if ((ctail += len) >= this.char_size) {
                    ctail -= this.char_size;
                }
                char_count -= len;
                cdelete += len;
                --line_count;
                ++ldelete;
            }
            int chars_to_delete = char_count + char_len - this.char_threshold;
            if (chars_to_delete > 0) {
                this.println("delete step #3, shorten last line by " + chars_to_delete + " chars");
                int last = ltail + 1;
                if (last >= this.line_size) {
                    last = 0;
                }
                shortened = this.line_buf[last];
                int index = shortened.getIndex();
                int len2 = shortened.getLength();
                if ((index += chars_to_delete) >= this.char_size) {
                    index -= this.char_size;
                }
                shortened.set(index, len2 -= chars_to_delete);
                if ((ctail += chars_to_delete) >= this.char_size) {
                    ctail -= this.char_size;
                }
                char_count -= chars_to_delete;
                cdelete += chars_to_delete;
            }
            if (cdelete > 0 || ldelete > 0) {
                this.char_tail = ctail;
                this.line_tail = ltail;
                this.removeEvent.setLineRange(ltail_begin, ldelete);
                this.removeEvent.setCharRange(ctail_begin, cdelete);
                this.removeEvent.setAppended(shortened);
                for (DocumentListener d : this.listeners) {
                    d.removeUpdate(this.removeEvent);
                }
            }
        } else {
            int line_count = this.getElementCount();
            if (line_count + line_len >= this.line_size) {
                return;
            }
        }
        if (char_len <= 0) {
            return;
        }
        this.char_head += char_len;
        if (this.char_head >= this.char_size) {
            this.char_head -= this.char_size;
        }
        this.char_total += (long)char_len;
        int npos = 0;
        int nindex = 0;
        if (this.last_line_incomplete) {
            if (newline_count > 0) {
                npos = this.newline_offset[0] + 1;
                this.line_buf[this.line_head].increaseLength(npos);
                nindex = 1;
                this.last_line_incomplete = false;
            } else {
                this.line_buf[this.line_head].increaseLength(char_len);
            }
            this.insertEvent.setAppended(this.line_buf[this.line_head]);
        } else {
            this.insertEvent.setAppended(null);
        }
        int lhead = this.line_head + 1;
        if (lhead > this.line_size) {
            lhead = 0;
        }
        if (line_len > 0) {
            while (nindex < newline_count) {
                this.addLine(chead + npos, this.newline_offset[nindex] - npos + 1);
                npos = this.newline_offset[nindex] + 1;
                ++nindex;
            }
            if (npos >= char_len) {
                this.last_line_incomplete = false;
            } else {
                this.addLine(chead + npos, char_len - npos);
                this.last_line_incomplete = true;
            }
        }
        this.insertEvent.setCharRange(this.charIndexToOffset(chead), char_len);
        this.insertEvent.setLineRange(this.lineIndexToOffset(lhead), line_len);
        for (DocumentListener d : this.listeners) {
            d.insertUpdate(this.insertEvent);
        }
    }

    @Override
    public synchronized void insertString(int offs, String s, AttributeSet a) throws BadLocationException {
    }

    private void addLine(int index, int len) {
        if (index >= this.char_size) {
            index -= this.char_size;
        }
        ++this.line_head;
        if (this.line_head >= this.line_size) {
            this.line_head = 0;
        }
        this.println(" addLine, " + len + " chars, into line index = " + this.line_head);
        this.line_buf[this.line_head].set(index, len);
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        if (this.char_buf == null) {
            return;
        }
        this.println("Document: remove, offset=" + offset + ", len=" + len);
        if (SwingUtilities.isEventDispatchThread()) {
            this.deleteEverything();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FifoDocument.this.deleteEverything();
                }
            });
        }
    }

    private synchronized void deleteEverything() {
        int line_len;
        int char_len = this.char_head - this.char_tail;
        if (char_len == 0) {
            return;
        }
        if (char_len < 0) {
            char_len += this.char_size;
        }
        if ((line_len = this.line_head - this.line_tail) < 0) {
            line_len += this.line_size;
        }
        this.removeEvent.setCharRange(0, char_len);
        this.removeEvent.setLineRange(0, line_len);
        for (DocumentListener d : this.listeners) {
            d.removeUpdate(this.removeEvent);
        }
        this.char_tail = this.char_head;
        this.line_tail = this.line_head;
        this.last_line_incomplete = false;
    }

    @Override
    public synchronized void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.println("Document: getText, offset=" + offset + ", len=" + length);
        if (length < 0 || offset < 0) {
            throw new BadLocationException("negative input not allowed", 0);
        }
        int chartotallen = this.char_head - this.char_tail;
        if (chartotallen < 0) {
            chartotallen += this.char_size;
        }
        if (offset + length > chartotallen) {
            throw new BadLocationException("access beyond data", offset + length);
        }
        txt.array = this.char_buf;
        int index = offset + this.char_tail + 1;
        if (index >= this.char_size) {
            index -= this.char_size;
        }
        txt.offset = index;
        if (index + length < this.char_size) {
            txt.count = length;
            txt.setPartialReturn(false);
        } else {
            txt.count = this.char_size - index;
            txt.setPartialReturn(true);
        }
        this.println("  text=" + txt.toString());
    }

    public synchronized int getCharCount() {
        int len = this.char_head - this.char_tail;
        if (len < 0) {
            len += this.char_size;
        }
        return len;
    }

    @Override
    public synchronized int getLength() {
        int len = this.getCharCount();
        this.println("Document: getLength -> " + len);
        return len;
    }

    public synchronized int getElementCount() {
        if (this.char_buf == null) {
            return 0;
        }
        int len = this.line_head - this.line_tail;
        if (len < 0) {
            len += this.line_size;
        }
        return len;
    }

    public synchronized FifoElementLine getElement(int offset) {
        if (this.char_buf == null) {
            return new FifoElementLine(this, 0);
        }
        int index = offset + this.line_tail + 1;
        if (index >= this.line_size) {
            index -= this.line_size;
        }
        return this.line_buf[index];
    }

    public synchronized int getLineOffset(int char_offset) {
        if (this.char_buf == null) {
            return 0;
        }
        if (char_offset <= 0) {
            return 0;
        }
        return this.getLineOffset_BinarySearch(char_offset);
    }

    private int getLineOffset_LinearSearch(int char_offset) {
        if (this.char_buf == null) {
            return 0;
        }
        int line_count = this.getElementCount();
        if (line_count < 1) {
            return 0;
        }
        for (int line_offset = 0; line_offset < line_count; ++line_offset) {
            FifoElementLine line = this.getElement(line_offset);
            int line_begin_offset = line.getStartOffset();
            int line_end_offset = line_begin_offset + line.getLength();
            if (char_offset < line_begin_offset || char_offset >= line_end_offset) continue;
            return line_offset;
        }
        return line_count - 1;
    }

    private int getLineOffset_BinarySearch(int char_offset) {
        int begin = 0;
        int end = this.getElementCount() - 1;
        if (end < 1) {
            return 0;
        }
        while (begin <= end) {
            int middle = begin + (end - begin) / 2;
            FifoElementLine line = this.getElement(middle);
            int line_begin_offset = line.getStartOffset();
            int line_end_offset = line_begin_offset + line.getLength();
            if (char_offset >= line_begin_offset && char_offset < line_end_offset) {
                return middle;
            }
            if (char_offset >= line_begin_offset) {
                begin = middle + 1;
                continue;
            }
            end = middle - 1;
        }
        return this.getElementCount() - 1;
    }

    public synchronized FifoElementLine[] getElementArray(int offset, int length) {
        if (this.char_buf == null) {
            return null;
        }
        FifoElementLine[] list = new FifoElementLine[length];
        int index = offset + this.line_tail + 1;
        if (index >= this.line_size) {
            index -= this.line_size;
        }
        for (int i = 0; i < length; ++i) {
            list[i] = this.line_buf[index++];
            if (index < this.line_size) continue;
            index -= this.line_size;
        }
        return list;
    }

    @Override
    public synchronized Position createPosition(int offset) throws BadLocationException {
        this.println("Document: createPosition");
        if (offset < 0) {
            throw new BadLocationException("negative input not allowed", 0);
        }
        if (offset == 0 || this.char_buf == null) {
            return this.startPosition;
        }
        int length = this.getCharCount();
        if (offset > length) {
            throw new BadLocationException("beyond end", offset);
        }
        long pos = this.char_total - (long)length + (long)offset;
        this.println("  offset=" + offset + " -> pos=" + pos);
        return new FifoPosition(this, this.char_total - (long)length + (long)offset);
    }

    @Override
    public Position getStartPosition() {
        this.println("Document: getStartPosition");
        return this.startPosition;
    }

    @Override
    public Position getEndPosition() {
        this.println("Document: getEndPosition");
        return this.endPosition;
    }

    public synchronized int positionToOffset(FifoPosition p) {
        int length;
        long first_location;
        long location = p.getPositionNumber();
        if (location <= (first_location = this.char_total - (long)(length = this.getCharCount()))) {
            return 0;
        }
        if (location >= this.char_total) {
            return length - 1;
        }
        return (int)(location - first_location);
    }

    @Override
    public synchronized String getText(int offset, int length) throws BadLocationException {
        String s;
        this.println("Document: getText (String), offset=" + offset + ", len=" + length);
        if (length < 0 || offset < 0) {
            throw new BadLocationException("negative input not allowed", 0);
        }
        int chartotallen = this.char_head - this.char_tail;
        if (chartotallen < 0) {
            chartotallen += this.char_size;
        }
        if (offset + length > chartotallen) {
            throw new BadLocationException("access beyond data", offset + length);
        }
        int index = offset + this.char_tail + 1;
        if (index >= this.char_size) {
            index -= this.char_size;
        }
        if (index + length < this.char_size) {
            s = new String(this.char_buf, index, length);
        } else {
            int remain = this.char_size - index;
            String s1 = new String(this.char_buf, index, remain);
            String s2 = new String(this.char_buf, 0, length - remain);
            s = s1 + s2;
        }
        this.println("  text=" + s);
        return s;
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.println("Document: addDocumentListener " + listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.println("Document: removeDocumentListener");
        this.listeners.remove(listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.println("Document: addUndoableEditListener " + listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.println("Document: removeUndoableEditListener");
    }

    @Override
    public Object getProperty(Object key) {
        this.println("Document: getProperty " + key + "   " + key.getClass().getName());
        return null;
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.println("Document: putProperty " + key + "  " + value);
    }

    @Override
    public Element[] getRootElements() {
        this.println("Document: getRootElements");
        return null;
    }

    @Override
    public Element getDefaultRootElement() {
        this.println("Document: getDefaultRootElement");
        return this.line_root;
    }

    @Override
    public void render(Runnable r) {
        this.println("Document: Runnable");
    }

    private void actual_print(String str) {
    }

    public void print(String str) {
        long now = System.currentTimeMillis();
        if (now - this.prior_milliseconds > 100L) {
            this.actual_print("\n\n");
        }
        this.prior_milliseconds = now;
        this.actual_print(str);
    }

    public void println(String str) {
        this.print(str + "\n");
    }
}

