/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import processing.app.FifoDocument;

public class FifoElementLine
implements Element {
    private FifoDocument doc;
    private final int n;
    private int index;
    private int len;

    public FifoElementLine(FifoDocument d, int i) {
        this.doc = d;
        this.n = i;
        this.index = 0;
        this.len = 0;
    }

    @Override
    public int getStartOffset() {
        int offset = this.doc.charIndexToOffset(this.index);
        return offset;
    }

    @Override
    public int getEndOffset() {
        int offset = this.doc.charIndexToOffset(this.index) + this.len;
        return offset;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    public void set(int new_index, int new_len) {
        this.index = new_index;
        this.len = new_len;
    }

    public int getLength() {
        return this.len;
    }

    public int getIndex() {
        return this.index;
    }

    public void increaseLength(int adder) {
        this.len += adder;
    }

    @Override
    public Element getParentElement() {
        this.doc.println("ElementLine[" + this.n + "]: getParentElement");
        return null;
    }

    @Override
    public String getName() {
        return "leaf[" + this.n + "]";
    }

    @Override
    public int getElementIndex(int offset) {
        this.doc.println("ElementLine[" + this.n + "]: getElementIndex, offset=" + offset);
        return -1;
    }

    @Override
    public int getElementCount() {
        this.doc.println("ElementLine[" + this.n + "]: getElementCount");
        return 0;
    }

    @Override
    public Element getElement(int index) {
        this.doc.println("ElementLine[" + this.n + "]: getElement, index=" + index);
        return null;
    }
}

