/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import processing.app.AbstractTextMonitor;
import processing.app.CommandHistory;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.legacy.PApplet;

public class SerialMonitor
extends AbstractTextMonitor {
    private Serial serial;
    private int serialRate;
    private static final int COMMAND_HISTORY_SIZE = 100;
    private final CommandHistory commandHistory = new CommandHistory(100);

    public SerialMonitor(BoardPort port) {
        super(port);
        this.serialRate = PreferencesData.getInteger((String)"serial.debug_rate");
        this.serialRates.setSelectedItem(this.serialRate + " " + I18n.tr((String)"baud"));
        this.onSerialRateChange(event -> {
            String wholeString = (String)this.serialRates.getSelectedItem();
            String rateString = wholeString.substring(0, wholeString.indexOf(32));
            this.serialRate = Integer.parseInt(rateString);
            PreferencesData.set((String)"serial.debug_rate", (String)rateString);
            try {
                this.close();
                Thread.sleep(100L);
                this.open();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                System.err.println(e);
            }
        });
        this.onSendCommand(event -> {
            String command = this.textField.getText();
            this.send(command);
            this.commandHistory.addCommand(command);
            this.textField.setText("");
        });
        this.onClearCommand(event -> this.textArea.setText(""));
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        if (!SerialMonitor.this.commandHistory.hasPreviousCommand()) break;
                        SerialMonitor.this.textField.setText(SerialMonitor.this.commandHistory.getPreviousCommand(SerialMonitor.this.textField.getText()));
                        break;
                    }
                    case 40: {
                        if (!SerialMonitor.this.commandHistory.hasNextCommand()) break;
                        SerialMonitor.this.textField.setText(SerialMonitor.this.commandHistory.getNextCommand());
                        break;
                    }
                    case 27: {
                        SerialMonitor.this.textField.setText(SerialMonitor.this.commandHistory.resetHistoryLocation());
                    }
                }
            }
        });
    }

    private void send(String s) {
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    s = s + "\n";
                    break;
                }
                case 2: {
                    s = s + "\r";
                    break;
                }
                case 3: {
                    s = s + "\r\n";
                    break;
                }
            }
            if ("".equals(s) && this.lineEndings.getSelectedIndex() == 0 && !PreferencesData.has((String)"runtime.line.ending.alert.notified")) {
                this.noLineEndingAlert.setForeground(Color.RED);
                PreferencesData.set((String)"runtime.line.ending.alert.notified", (String)"true");
            }
            this.serial.write(s);
        }
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.getBoardPort().getAddress(), this.serialRate){

            protected void message(char[] buff, int n) {
                SerialMonitor.this.addToUpdateBuffer(buff, n);
            }
        };
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.serial != null) {
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            PreferencesData.set((String)"last.serial.location", (String)locationStr);
            this.textArea.setText("");
            this.serial.dispose();
            this.serial = null;
        }
    }
}

