/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import processing.app.AbstractTextMonitor;
import processing.app.BaseNoGui;
import processing.app.FakeSerial;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.legacy.PApplet;

public class TeensyMonitor
extends AbstractTextMonitor {
    private Serial serial;
    private int serialRate = PreferencesData.getInteger((String)"serial.debug_rate");
    private Thread reopener;
    private Thread onlineChecker;
    private boolean isOpen;
    private final boolean debug = false;

    public TeensyMonitor(BoardPort port) {
        super(port);
        this.serialRates.setSelectedItem(this.serialRate + " " + I18n.tr((String)"baud"));
        this.isOpen = false;
        this.onSerialRateChange(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String wholeString = (String)TeensyMonitor.this.serialRates.getSelectedItem();
                String rateString = wholeString.substring(0, wholeString.indexOf(32));
                TeensyMonitor.this.serialRate = Integer.parseInt(rateString);
                PreferencesData.set((String)"serial.debug_rate", (String)rateString);
                try {
                    TeensyMonitor.this.close();
                    Thread.sleep(100L);
                    TeensyMonitor.this.open();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        });
        this.onSendCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeensyMonitor.this.send(TeensyMonitor.this.textField.getText());
                TeensyMonitor.this.textField.setText("");
            }
        });
        this.onClearCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeensyMonitor.this.textArea.setText("");
            }
        });
    }

    private void send(String s) {
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    s = s + "\n";
                    break;
                }
                case 2: {
                    s = s + "\r";
                    break;
                }
                case 3: {
                    s = s + "\r\n";
                }
            }
            if ("".equals(s) && this.lineEndings.getSelectedIndex() == 0 && !PreferencesData.has((String)"runtime.line.ending.alert.notified")) {
                this.noLineEndingAlert.setForeground(Color.RED);
                PreferencesData.set((String)"runtime.line.ending.alert.notified", (String)"true");
            }
            this.serial.write(s);
        }
    }

    @Override
    public void enableWindow(boolean enable) {
        super.enableWindow(enable);
    }

    private String teensyPortName() {
        String addr = this.getBoardPort().getAddress();
        if (addr.equals("fake serial")) {
            return "(emulated serial)";
        }
        return addr;
    }

    @Override
    public void open() throws Exception {
        String port = this.teensyPortName();
        if (Thread.currentThread() != this.reopener) {
            this.reopen_abort();
        }
        if (this.serial != null) {
            return;
        }
        super.open();
        if (this.onlineChecker != null) {
            this.onlineChecker.interrupt();
        }
        PreferencesMap prefs = BaseNoGui.getBoardPreferences();
        String fake = null;
        if (this.getBoardPort().getAddress().equals("fake serial")) {
            fake = "teensy_gateway";
        }
        boolean restart = prefs.getBoolean("serial.restart_cmd");
        if (fake == null) {
            if (port == null) {
                throw new SerialException("No serial port, please select with Tools > Port");
            }
            if (restart) {
                this.serial = new Serial(port, 150){

                    protected void message(char[] buff, int n) {
                        TeensyMonitor.this.addToUpdateBuffer(buff, n);
                    }
                };
                this.serial.setBaud(this.serialRate);
            } else {
                this.serial = new Serial(port, this.serialRate){

                    protected void message(char[] buff, int n) {
                        TeensyMonitor.this.addToUpdateBuffer(buff, n);
                    }
                };
            }
        } else {
            if (restart) {
                String cmdline = BaseNoGui.getHardwarePath() + File.separator + "tools" + File.separator + "teensy_restart";
                try {
                    Runtime.getRuntime().exec(new String[]{cmdline});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serial = new FakeSerial(fake){

                @Override
                protected void message(char[] buff, int n) {
                    TeensyMonitor.this.addToUpdateBuffer(buff, n);
                }
            };
        }
        this.textArea.setText("");
        this.isOpen = true;
        this.enableWindow(true);
        this.setTitle("TeensyMonitor: " + port + " Online");
        this.onlineChecker = new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        7.sleep(400L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (TeensyMonitor.this.serial != null) continue;
                    return;
                } while (TeensyMonitor.this.serial.isOnline());
                try {
                    TeensyMonitor.this.close();
                    TeensyMonitor.this.reopen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.onlineChecker.start();
    }

    @Override
    public void suspend() throws Exception {
        super.suspend();
    }

    @Override
    public void resume(BoardPort boardPort) throws Exception {
        if (!this.isVisible()) {
            return;
        }
        this.reopen_abort();
        this.setBoardPort(boardPort);
        this.setTitle("TeensyMonitor: " + this.teensyPortName() + " Offline");
        if (this.isOpen) {
            return;
        }
        this.reopener = new Thread(){

            @Override
            public void run() {
                int initial_delay = 800;
                if (OSUtils.isWindows()) {
                    initial_delay += 1000;
                }
                try {
                    8.sleep(initial_delay);
                }
                catch (InterruptedException e) {
                    return;
                }
                int attempt = 0;
                while (true) {
                    ++attempt;
                    try {
                        8.sleep(attempt < 50 ? 100L : 500L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    try {
                        TeensyMonitor.this.open();
                        return;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        };
        this.reopener.start();
    }

    private void reopen() throws Exception {
        this.resume(this.getBoardPort());
    }

    private void interrupt_thread(Thread th) {
        if (th != null && th != Thread.currentThread() && th.isAlive()) {
            th.interrupt();
        }
    }

    @Override
    public void close() throws Exception {
        this.setTitle("TeensyMonitor: Closed");
        this.interrupt_thread(this.reopener);
        this.interrupt_thread(this.onlineChecker);
        this.isOpen = false;
        super.close();
        if (this.serial != null) {
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            PreferencesData.set((String)"last.serial.location", (String)locationStr);
            this.enableWindow(false);
            this.serial.dispose();
            this.serial = null;
        }
    }

    private void reopen_abort() {
        if (this.reopener == null) {
            return;
        }
        int attempt = 0;
        while (attempt < 25) {
            if (!this.reopener.isAlive()) {
                this.reopener = null;
                break;
            }
            if (attempt == 0) {
                this.reopener.interrupt();
            }
            try {
                Thread.sleep(10L);
                ++attempt;
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

