/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import processing.app.AbstractTextMonitor;
import processing.app.BaseNoGui;
import processing.app.FifoDocument;
import processing.app.errorPipeListener;
import processing.app.inputPipeListener;

public class TeensyPipeMonitor
extends AbstractTextMonitor {
    public final boolean debug = false;
    private String teensyname = null;
    private String openport = null;
    Process program = null;
    inputPipeListener listener = null;
    errorPipeListener errors = null;

    public TeensyPipeMonitor(BoardPort port) {
        super(port);
        this.textArea.setFifo(new FifoDocument(10000000));
        String[] pieces = port.getLabel().trim().split("[\\(\\)]");
        this.teensyname = pieces.length > 2 && pieces[1].startsWith("Teensy") ? pieces[1] : "Teensy";
        this.serialRates.hide();
        this.addTimeStampBox.hide();
        this.disconnect();
        this.onClearCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeensyPipeMonitor.this.clear();
            }
        });
        this.onSendCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputStream out;
                String s = TeensyPipeMonitor.this.textField.getText();
                switch (TeensyPipeMonitor.this.lineEndings.getSelectedIndex()) {
                    case 1: {
                        s = s + "\n";
                        break;
                    }
                    case 2: {
                        s = s + "\r";
                        break;
                    }
                    case 3: {
                        s = s + "\r\n";
                    }
                }
                byte[] b = s.getBytes();
                if (TeensyPipeMonitor.this.program != null && (out = TeensyPipeMonitor.this.program.getOutputStream()) != null) {
                    try {
                        out.write(b);
                        out.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                TeensyPipeMonitor.this.textField.setText("");
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TeensyPipeMonitor.this.window_close();
            }
        });
    }

    private void clear() {
        this.textArea.select(0, 0);
        this.textArea.setCaretPosition(0);
        this.textArea.setText("");
    }

    @Override
    public void open() throws Exception {
        String port = this.getBoardPort().getAddress();
        if (this.openport != null && port.equals(this.openport) && this.program != null && this.listener != null && this.listener.isAlive() && this.errors != null && this.errors.isAlive()) {
            return;
        }
        if (this.program != null || this.listener != null || this.errors != null) {
            this.close();
        }
        String command = BaseNoGui.getHardwarePath() + File.separator + "tools" + File.separator + "teensy_serialmon";
        String[] cmdline = new String[]{command, port};
        try {
            this.program = Runtime.getRuntime().exec(cmdline);
        }
        catch (Exception e1) {
            System.err.println("Unable to run teensy_serialmon");
            this.program = null;
        }
        if (this.program != null) {
            this.openport = new String(port);
            this.clear();
            this.listener = new inputPipeListener();
            this.listener.input = this.program.getInputStream();
            this.listener.output = this;
            this.listener.start();
            this.errors = new errorPipeListener();
            this.errors.input = this.program.getErrorStream();
            this.errors.output = this;
            this.errors.start();
            super.open();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.program != null) {
            this.program.destroy();
            this.program = null;
        }
        if (this.listener != null) {
            if (this.listener.isAlive()) {
                this.listener.interrupt();
            }
            this.listener = null;
        }
        if (this.errors != null) {
            if (this.errors.isAlive()) {
                this.errors.interrupt();
            }
            this.errors = null;
        }
        this.openport = null;
        this.setTitle("[offline] (" + this.teensyname + ")");
        super.close();
    }

    public void opened(String device, String usbtype) {
        this.clear();
        this.setTitle(device + " (" + this.teensyname + ") " + usbtype);
        this.enableWindow(true);
    }

    public void disconnect() {
        this.setTitle("[offline] (" + this.teensyname + ")");
        this.enableWindow(false);
    }

    @Override
    protected void onEnableWindow(boolean enable) {
        this.textArea.setEnabled(true);
        if (enable) {
            this.textArea.setForeground(Color.BLACK);
            this.textArea.setBackground(Color.WHITE);
        } else {
            this.textArea.setForeground(new Color(64, 64, 64));
            this.textArea.setBackground(new Color(238, 238, 238));
        }
        this.textArea.invalidate();
        this.clearButton.setEnabled(enable);
        this.scrollPane.setEnabled(enable);
        this.textField.setEnabled(enable);
        this.sendButton.setEnabled(enable);
        this.autoscrollBox.setEnabled(enable);
        this.addTimeStampBox.setEnabled(enable);
        this.lineEndings.setEnabled(enable);
        this.serialRates.setEnabled(enable);
    }

    public void window_close() {
        this.textArea.getFifo().free();
        this.dispose();
        ((JFrame)SwingUtilities.getRoot(this)).dispose();
    }
}

