/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;
import processing.app.FifoDocument;
import processing.app.TeensyPipeMonitor;

class inputPipeListener
extends Thread {
    InputStream input;
    TeensyPipeMonitor output;
    FifoDocument doc;

    inputPipeListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("TeensyPipeMonitor inputPipeListener");
        this.doc = this.output.textArea.getFifo();
        char[] buffer = this.doc.getBuffer();
        InputStreamReader reader = new InputStreamReader(this.input);
        try {
            while (this.output.program != null) {
                int offset = this.doc.getAppendIndex();
                int length = this.doc.getAvailableToAppend();
                if (length <= 0) {
                    if (reader.ready()) {
                        long l = reader.skip(1000000L);
                    } else {
                        inputPipeListener.sleep(1L);
                    }
                    if (!this.output.autoscrollBox.isSelected()) continue;
                    this.update_gui(0, true);
                    continue;
                }
                int count = 0;
                int target = 500000;
                if (target > length) {
                    target = length;
                }
                long begin = System.currentTimeMillis();
                while (count < target && this.output.program != null) {
                    if (reader.ready()) {
                        int r;
                        int to_read = length - count;
                        if (to_read > 32768) {
                            to_read = 32768;
                        }
                        if ((r = reader.read(buffer, offset + count, to_read)) > 0) {
                            count += r;
                        }
                    } else {
                        inputPipeListener.sleep(1L);
                    }
                    if (count <= 0 || System.currentTimeMillis() - begin < 33L) continue;
                }
                boolean scroll = this.output.autoscrollBox.isSelected();
                this.update_gui(count, scroll);
                if (!scroll) continue;
                this.output.textArea.setCaretPosition(this.doc.getLength());
            }
        }
        catch (Exception e) {
            this.output.getClass();
        }
        finally {
            try {
                this.output.close();
            }
            catch (Exception e) {
                this.output.disconnect();
            }
            this.output.getClass();
            this.input = null;
            this.output = null;
            this.doc = null;
        }
    }

    private void update_gui(final int chars_added, final boolean auto_scroll) {
        Runnable do_update = new Runnable(){

            @Override
            public void run() {
                inputPipeListener.this.doc.setScrollingMode(auto_scroll);
                inputPipeListener.this.doc.processAppended(chars_added);
                inputPipeListener.this.output.textArea.invalidate();
            }
        };
        int retry = 0;
        while (true) {
            try {
                SwingUtilities.invokeAndWait(do_update);
                return;
            }
            catch (InterruptedException e) {
                this.output.getClass();
                if (this.output.program != null) continue;
                return;
                if (++retry <= 4) continue;
                return;
            }
            catch (Exception e) {
                this.output.getClass();
                e.printStackTrace();
                return;
            }
            break;
        }
    }
}

