/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.serial;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import processing.app.BaseNoGui;
import processing.app.Platform;
import processing.app.debug.TargetBoard;
import processing.app.helpers.BoardCloudResolver;

public class SerialDiscovery
implements Discovery,
Runnable {
    private Timer serialBoardsListerTimer;
    private final List<BoardPort> serialBoardPorts = new ArrayList<BoardPort>();
    private final List<BoardPort> boardPorts = new ArrayList<BoardPort>();
    private final List<String> oldPorts = new ArrayList<String>();
    public boolean uploadInProgress = false;
    public boolean pausePolling = false;
    private BoardPort oldUploadBoardPort = null;
    private final BoardCloudResolver boardCloudResolver = new BoardCloudResolver();

    @Override
    public List<BoardPort> listDiscoveredBoards() {
        return this.listDiscoveredBoards(false);
    }

    @Override
    public List<BoardPort> listDiscoveredBoards(boolean complete) {
        if (complete) {
            return new ArrayList<BoardPort>(this.serialBoardPorts);
        }
        ArrayList<BoardPort> onlineBoardPorts = new ArrayList<BoardPort>();
        for (BoardPort port : this.serialBoardPorts) {
            if (!port.isOnline()) continue;
            onlineBoardPorts.add(port);
        }
        return onlineBoardPorts;
    }

    public void setSerialBoardPorts(List<BoardPort> newSerialBoardPorts) {
        this.serialBoardPorts.clear();
        this.serialBoardPorts.addAll(newSerialBoardPorts);
    }

    public void setUploadInProgress(boolean param) {
        this.uploadInProgress = param;
    }

    public void pausePolling(boolean param) {
        this.pausePolling = param;
    }

    @Override
    public void run() {
        this.start();
    }

    @Override
    public void start() {
        this.serialBoardsListerTimer = new Timer(SerialDiscovery.class.getName());
        this.serialBoardsListerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (BaseNoGui.packages != null && !SerialDiscovery.this.pausePolling) {
                    SerialDiscovery.this.forceRefresh();
                }
            }
        }, 0L, 1000L);
    }

    @Override
    public void stop() {
        this.serialBoardsListerTimer.cancel();
    }

    public synchronized void forceRefresh() {
        Platform platform = BaseNoGui.getPlatform();
        if (platform == null) {
            return;
        }
        List<String> ports = platform.listSerials();
        if (ports.equals(this.oldPorts)) {
            return;
        }
        this.oldPorts.clear();
        this.oldPorts.addAll(ports);
        for (BoardPort board : this.boardPorts) {
            if (ports.contains(board.toString())) {
                if (!board.isOnline()) continue;
                ports.remove(ports.indexOf(board.toString()));
                continue;
            }
            if (this.uploadInProgress && board.isOnline()) {
                this.oldUploadBoardPort = board;
            }
            board.setOnlineStatus(false);
        }
        for (String newPort : ports) {
            String[] parts = newPort.split("_");
            if (parts.length < 3) continue;
            if (parts.length > 3) {
                for (int i = 1; i < parts.length - 2; ++i) {
                    parts[0] = parts[0] + "_" + parts[i];
                }
                parts[1] = parts[parts.length - 2];
                parts[2] = parts[parts.length - 1];
            }
            String port = parts[0];
            Map<String, Object> boardData = platform.resolveDeviceByVendorIdProductId(port, BaseNoGui.packages);
            BoardPort boardPort = null;
            int i = 0;
            for (BoardPort board : this.boardPorts) {
                if (board.toString().equals(newPort)) {
                    boardPort = this.boardPorts.get(i);
                    break;
                }
                ++i;
            }
            if (boardPort == null) {
                boardPort = new BoardPort();
                this.boardPorts.add(boardPort);
            }
            boardPort.setAddress(port);
            boardPort.setProtocol("serial");
            boardPort.setOnlineStatus(true);
            String label = port;
            if (boardData != null) {
                TargetBoard board;
                boardPort.getPrefs().put("vid", boardData.get("vid").toString());
                boardPort.getPrefs().put("pid", boardData.get("pid").toString());
                String iserial = boardData.get("iserial").toString();
                if (iserial.length() >= 10) {
                    boardPort.getPrefs().put("iserial", iserial);
                }
                if (this.uploadInProgress && this.oldUploadBoardPort != null) {
                    this.oldUploadBoardPort.getPrefs().put("iserial", iserial);
                }
                if ((board = (TargetBoard)boardData.get("board")) != null) {
                    String boardName = board.getName();
                    if (boardName != null && boardName.startsWith("Teensy")) {
                        boardName = "Teensy";
                    }
                    boardPort.setBoardName(boardName);
                }
            } else if (!parts[1].equals("0000")) {
                boardPort.getPrefs().put("vid", parts[1]);
                boardPort.getPrefs().put("pid", parts[2]);
                this.boardCloudResolver.getBoardBy(parts[1], parts[2]);
            } else {
                boardPort.getPrefs().put("vid", "0000");
                boardPort.getPrefs().put("pid", "0000");
                boardPort.getPrefs().put("iserial", "");
            }
            boardPort.setLabel(label);
        }
        this.setSerialBoardPorts(this.boardPorts);
    }
}

