/* Audio Library for Teensy 3.X
 * Copyright (c) 2014, Paul Stoffregen, paul@pjrc.com
 *
 * Development of this audio library was funded by PJRC.COM, LLC by sales of
 * Teensy and Audio Adaptor boards.  Please support PJRC's efforts to develop
 * open source software by purchasing Teensy or other PJRC products.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice, development funding notice, and this permission
 * notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <stdint.h>

const int16_t AudioWindowHanning256[] __attribute__ ((aligned (4))) = {
     0,     5,    20,    45,    80,   124,   179,   243,   317,   401,
   495,   598,   711,   833,   965,  1106,  1257,  1416,  1585,  1763,
  1949,  2145,  2349,  2561,  2782,  3011,  3249,  3494,  3747,  4008,
  4276,  4552,  4834,  5124,  5421,  5724,  6034,  6350,  6672,  7000,
  7334,  7673,  8018,  8367,  8722,  9081,  9445,  9812, 10184, 10560,
 10939, 11321, 11707, 12095, 12486, 12879, 13274, 13672, 14070, 14471,
 14872, 15275, 15678, 16081, 16485, 16889, 17292, 17695, 18097, 18498,
 18897, 19295, 19692, 20086, 20478, 20868, 21255, 21639, 22019, 22397,
 22770, 23140, 23506, 23867, 24224, 24576, 24923, 25265, 25602, 25932,
 26258, 26577, 26890, 27196, 27496, 27789, 28076, 28355, 28627, 28892,
 29148, 29398, 29639, 29872, 30097, 30314, 30522, 30722, 30913, 31095,
 31268, 31432, 31588, 31733, 31870, 31997, 32115, 32223, 32321, 32410,
 32489, 32558, 32618, 32667, 32707, 32737, 32757, 32767, 32767, 32757,
 32737, 32707, 32667, 32618, 32558, 32489, 32410, 32321, 32223, 32115,
 31997, 31870, 31733, 31588, 31432, 31268, 31095, 30913, 30722, 30522,
 30314, 30097, 29872, 29639, 29398, 29148, 28892, 28627, 28355, 28076,
 27789, 27496, 27196, 26890, 26577, 26258, 25932, 25602, 25265, 24923,
 24576, 24224, 23867, 23506, 23140, 22770, 22397, 22019, 21639, 21255,
 20868, 20478, 20086, 19692, 19295, 18897, 18498, 18097, 17695, 17292,
 16889, 16485, 16081, 15678, 15275, 14872, 14471, 14070, 13672, 13274,
 12879, 12486, 12095, 11707, 11321, 10939, 10560, 10184,  9812,  9445,
  9081,  8722,  8367,  8018,  7673,  7334,  7000,  6672,  6350,  6034,
  5724,  5421,  5124,  4834,  4552,  4276,  4008,  3747,  3494,  3249,
  3011,  2782,  2561,  2349,  2145,  1949,  1763,  1585,  1416,  1257,
  1106,   965,   833,   711,   598,   495,   401,   317,   243,   179,
   124,    80,    45,    20,     5,     0,
};

const int16_t AudioWindowBartlett256[] __attribute__ ((aligned (4))) = {
   128,   384,   640,   896,  1152,  1408,  1664,  1920,  2176,  2432,
  2688,  2944,  3200,  3456,  3712,  3968,  4224,  4480,  4736,  4992,
  5248,  5504,  5760,  6016,  6272,  6528,  6784,  7040,  7296,  7552,
  7808,  8064,  8320,  8576,  8832,  9088,  9344,  9600,  9856, 10112,
 10368, 10624, 10880, 11136, 11392, 11648, 11904, 12160, 12416, 12672,
 12928, 13184, 13440, 13696, 13952, 14208, 14464, 14720, 14976, 15232,
 15488, 15744, 16000, 16256, 16512, 16768, 17024, 17280, 17536, 17792,
 18048, 18304, 18560, 18816, 19072, 19328, 19584, 19840, 20096, 20352,
 20608, 20864, 21120, 21376, 21632, 21888, 22144, 22400, 22656, 22912,
 23168, 23424, 23680, 23936, 24192, 24448, 24704, 24960, 25216, 25472,
 25728, 25984, 26240, 26496, 26752, 27008, 27264, 27520, 27776, 28032,
 28288, 28544, 28800, 29056, 29312, 29568, 29824, 30080, 30336, 30592,
 30848, 31104, 31360, 31616, 31872, 32128, 32384, 32640, 32640, 32384,
 32128, 31872, 31616, 31360, 31104, 30848, 30592, 30336, 30080, 29824,
 29568, 29312, 29056, 28800, 28544, 28288, 28032, 27776, 27520, 27264,
 27008, 26752, 26496, 26240, 25984, 25728, 25472, 25216, 24960, 24704,
 24448, 24192, 23936, 23680, 23424, 23168, 22912, 22656, 22400, 22144,
 21888, 21632, 21376, 21120, 20864, 20608, 20352, 20096, 19840, 19584,
 19328, 19072, 18816, 18560, 18304, 18048, 17792, 17536, 17280, 17024,
 16768, 16512, 16256, 16000, 15744, 15488, 15232, 14976, 14720, 14464,
 14208, 13952, 13696, 13440, 13184, 12928, 12672, 12416, 12160, 11904,
 11648, 11392, 11136, 10880, 10624, 10368, 10112,  9856,  9600,  9344,
  9088,  8832,  8576,  8320,  8064,  7808,  7552,  7296,  7040,  6784,
  6528,  6272,  6016,  5760,  5504,  5248,  4992,  4736,  4480,  4224,
  3968,  3712,  3456,  3200,  2944,  2688,  2432,  2176,  1920,  1664,
  1408,  1152,   896,   640,   384,   128,
};

const int16_t AudioWindowBlackman256[] __attribute__ ((aligned (4))) = {
     0,     2,     7,    16,    29,    45,    65,    89,   116,   148,
   183,   222,   266,   314,   366,   422,   483,   549,   620,   695,
   776,   862,   953,  1050,  1153,  1261,  1376,  1496,  1623,  1757,
  1897,  2043,  2197,  2358,  2526,  2701,  2883,  3074,  3272,  3477,
  3691,  3912,  4142,  4380,  4626,  4880,  5142,  5413,  5692,  5979,
  6275,  6579,  6891,  7211,  7540,  7876,  8220,  8572,  8932,  9299,
  9674, 10056, 10445, 10840, 11242, 11651, 12065, 12485, 12911, 13342,
 13778, 14218, 14662, 15111, 15563, 16017, 16475, 16935, 17397, 17860,
 18324, 18789, 19253, 19718, 20182, 20644, 21104, 21563, 22018, 22470,
 22919, 23363, 23802, 24237, 24665, 25087, 25503, 25911, 26312, 26704,
 27088, 27462, 27828, 28183, 28527, 28861, 29183, 29494, 29793, 30079,
 30352, 30613, 30859, 31092, 31311, 31515, 31705, 31880, 32039, 32183,
 32312, 32425, 32522, 32603, 32668, 32717, 32750, 32766, 32766, 32750,
 32717, 32668, 32603, 32522, 32425, 32312, 32183, 32039, 31880, 31705,
 31515, 31311, 31092, 30859, 30613, 30352, 30079, 29793, 29494, 29183,
 28861, 28527, 28183, 27828, 27462, 27088, 26704, 26312, 25911, 25503,
 25087, 24665, 24237, 23802, 23363, 22919, 22470, 22018, 21563, 21104,
 20644, 20182, 19718, 19253, 18789, 18324, 17860, 17397, 16935, 16475,
 16017, 15563, 15111, 14662, 14218, 13778, 13342, 12911, 12485, 12065,
 11651, 11242, 10840, 10445, 10056,  9674,  9299,  8932,  8572,  8220,
  7876,  7540,  7211,  6891,  6579,  6275,  5979,  5692,  5413,  5142,
  4880,  4626,  4380,  4142,  3912,  3691,  3477,  3272,  3074,  2883,
  2701,  2526,  2358,  2197,  2043,  1897,  1757,  1623,  1496,  1376,
  1261,  1153,  1050,   953,   862,   776,   695,   620,   549,   483,
   422,   366,   314,   266,   222,   183,   148,   116,    89,    65,
    45,    29,    16,     7,     2,     0,
};

const int16_t AudioWindowFlattop256[] __attribute__ ((aligned (4))) = {
     0,     0,    -1,    -3,    -6,    -9,   -14,   -20,   -27,   -35,
   -45,   -56,   -68,   -83,   -99,  -117,  -137,  -160,  -185,  -213,
  -243,  -276,  -312,  -351,  -393,  -438,  -487,  -538,  -593,  -651,
  -713,  -777,  -844,  -914,  -987, -1062, -1139, -1218, -1298, -1380,
 -1462, -1544, -1626, -1707, -1787, -1865, -1939, -2010, -2077, -2139,
 -2194, -2243, -2284, -2316, -2339, -2351, -2352, -2339, -2314, -2273,
 -2217, -2144, -2054, -1945, -1817, -1668, -1498, -1306, -1090,  -851,
  -588,  -300,    13,   352,   718,  1111,  1530,  1976,  2449,  2949,
  3475,  4027,  4605,  5209,  5837,  6489,  7163,  7860,  8577,  9313,
 10068, 10840, 11626, 12426, 13238, 14059, 14889, 15724, 16563, 17404,
 18244, 19082, 19914, 20740, 21555, 22358, 23147, 23920, 24673, 25405,
 26113, 26796, 27451, 28076, 28669, 29228, 29752, 30238, 30685, 31092,
 31458, 31780, 32058, 32291, 32479, 32620, 32715, 32762, 32762, 32715,
 32620, 32479, 32291, 32058, 31780, 31458, 31092, 30685, 30238, 29752,
 29228, 28669, 28076, 27451, 26796, 26113, 25405, 24673, 23920, 23147,
 22358, 21555, 20740, 19914, 19082, 18244, 17404, 16563, 15724, 14889,
 14059, 13238, 12426, 11626, 10840, 10068,  9313,  8577,  7860,  7163,
  6489,  5837,  5209,  4605,  4027,  3475,  2949,  2449,  1976,  1530,
  1111,   718,   352,    13,  -300,  -588,  -851, -1090, -1306, -1498,
 -1668, -1817, -1945, -2054, -2144, -2217, -2273, -2314, -2339, -2352,
 -2351, -2339, -2316, -2284, -2243, -2194, -2139, -2077, -2010, -1939,
 -1865, -1787, -1707, -1626, -1544, -1462, -1380, -1298, -1218, -1139,
 -1062,  -987,  -914,  -844,  -777,  -713,  -651,  -593,  -538,  -487,
  -438,  -393,  -351,  -312,  -276,  -243,  -213,  -185,  -160,  -137,
  -117,   -99,   -83,   -68,   -56,   -45,   -35,   -27,   -20,   -14,
    -9,    -6,    -3,    -1,     0,     0,
};

const int16_t AudioWindowBlackmanHarris256[] __attribute__ ((aligned (4))) = {
     2,     2,     3,     5,     7,     9,    13,    17,    22,    27,
    34,    42,    51,    61,    73,    86,   101,   118,   137,   158,
   181,   207,   235,   267,   301,   339,   381,   427,   476,   530,
   589,   652,   721,   795,   875,   961,  1053,  1151,  1257,  1369,
  1489,  1617,  1752,  1896,  2049,  2210,  2380,  2560,  2749,  2948,
  3156,  3375,  3605,  3845,  4096,  4357,  4630,  4914,  5209,  5516,
  5833,  6162,  6503,  6855,  7218,  7592,  7978,  8374,  8781,  9199,
  9628, 10066, 10514, 10972, 11439, 11915, 12400, 12892, 13392, 13899,
 14413, 14932, 15457, 15987, 16521, 17058, 17599, 18141, 18685, 19229,
 19774, 20318, 20860, 21400, 21936, 22468, 22996, 23518, 24033, 24541,
 25041, 25532, 26012, 26482, 26941, 27387, 27821, 28240, 28645, 29034,
 29408, 29765, 30104, 30426, 30728, 31012, 31276, 31520, 31743, 31945,
 32126, 32284, 32421, 32535, 32627, 32696, 32742, 32765, 32765, 32742,
 32696, 32627, 32535, 32421, 32284, 32126, 31945, 31743, 31520, 31276,
 31012, 30728, 30426, 30104, 29765, 29408, 29034, 28645, 28240, 27821,
 27387, 26941, 26482, 26012, 25532, 25041, 24541, 24033, 23518, 22996,
 22468, 21936, 21400, 20860, 20318, 19774, 19229, 18685, 18141, 17599,
 17058, 16521, 15987, 15457, 14932, 14413, 13899, 13392, 12892, 12400,
 11915, 11439, 10972, 10514, 10066,  9628,  9199,  8781,  8374,  7978,
  7592,  7218,  6855,  6503,  6162,  5833,  5516,  5209,  4914,  4630,
  4357,  4096,  3845,  3605,  3375,  3156,  2948,  2749,  2560,  2380,
  2210,  2049,  1896,  1752,  1617,  1489,  1369,  1257,  1151,  1053,
   961,   875,   795,   721,   652,   589,   530,   476,   427,   381,
   339,   301,   267,   235,   207,   181,   158,   137,   118,   101,
    86,    73,    61,    51,    42,    34,    27,    22,    17,    13,
     9,     7,     5,     3,     2,     2,
};

const int16_t AudioWindowNuttall256[] __attribute__ ((aligned (4))) = {
     0,     0,     1,     2,     4,     6,     9,    13,    17,    22,
    28,    35,    43,    52,    62,    74,    87,   102,   119,   138,
   160,   183,   210,   239,   271,   306,   345,   388,   434,   485,
   540,   600,   665,   735,   811,   893,   981,  1075,  1176,  1284,
  1400,  1523,  1654,  1793,  1940,  2097,  2262,  2437,  2621,  2815,
  3019,  3233,  3458,  3693,  3939,  4196,  4465,  4744,  5035,  5338,
  5651,  5977,  6314,  6663,  7023,  7394,  7777,  8171,  8577,  8993,
  9420,  9857, 10305, 10762, 11229, 11705, 12190, 12683, 13184, 13693,
 14208, 14730, 15257, 15789, 16326, 16867, 17411, 17958, 18506, 19055,
 19604, 20153, 20700, 21245, 21787, 22325, 22858, 23386, 23908, 24422,
 24927, 25424, 25911, 26388, 26853, 27305, 27744, 28170, 28581, 28976,
 29355, 29717, 30062, 30388, 30696, 30984, 31252, 31499, 31726, 31932,
 32115, 32276, 32415, 32532, 32625, 32695, 32742, 32765, 32765, 32742,
 32695, 32625, 32532, 32415, 32276, 32115, 31932, 31726, 31499, 31252,
 30984, 30696, 30388, 30062, 29717, 29355, 28976, 28581, 28170, 27744,
 27305, 26853, 26388, 25911, 25424, 24927, 24422, 23908, 23386, 22858,
 22325, 21787, 21245, 20700, 20153, 19604, 19055, 18506, 17958, 17411,
 16867, 16326, 15789, 15257, 14730, 14208, 13693, 13184, 12683, 12190,
 11705, 11229, 10762, 10305,  9857,  9420,  8993,  8577,  8171,  7777,
  7394,  7023,  6663,  6314,  5977,  5651,  5338,  5035,  4744,  4465,
  4196,  3939,  3693,  3458,  3233,  3019,  2815,  2621,  2437,  2262,
  2097,  1940,  1793,  1654,  1523,  1400,  1284,  1176,  1075,   981,
   893,   811,   735,   665,   600,   540,   485,   434,   388,   345,
   306,   271,   239,   210,   183,   160,   138,   119,   102,    87,
    74,    62,    52,    43,    35,    28,    22,    17,    13,     9,
     6,     4,     2,     1,     0,     0,
};

const int16_t AudioWindowBlackmanNuttall256[] __attribute__ ((aligned (4))) = {
    12,    12,    13,    15,    18,    22,    26,    32,    38,    46,
    54,    64,    76,    89,   103,   119,   137,   158,   180,   205,
   232,   262,   295,   331,   371,   414,   461,   512,   567,   627,
   691,   761,   836,   916,  1002,  1095,  1193,  1299,  1411,  1531,
  1658,  1793,  1935,  2086,  2246,  2414,  2592,  2778,  2974,  3180,
  3396,  3621,  3857,  4104,  4361,  4628,  4907,  5196,  5497,  5808,
  6130,  6464,  6808,  7164,  7530,  7908,  8296,  8694,  9103,  9523,
  9952, 10391, 10839, 11296, 11763, 12237, 12720, 13210, 13707, 14211,
 14721, 15236, 15757, 16281, 16810, 17342, 17876, 18412, 18949, 19487,
 20024, 20560, 21094, 21625, 22153, 22677, 23196, 23709, 24215, 24714,
 25204, 25686, 26157, 26618, 27068, 27505, 27930, 28341, 28737, 29118,
 29484, 29833, 30165, 30479, 30775, 31052, 31310, 31549, 31767, 31964,
 32141, 32296, 32429, 32541, 32630, 32698, 32743, 32765, 32765, 32743,
 32698, 32630, 32541, 32429, 32296, 32141, 31964, 31767, 31549, 31310,
 31052, 30775, 30479, 30165, 29833, 29484, 29118, 28737, 28341, 27930,
 27505, 27068, 26618, 26157, 25686, 25204, 24714, 24215, 23709, 23196,
 22677, 22153, 21625, 21094, 20560, 20024, 19487, 18949, 18412, 17876,
 17342, 16810, 16281, 15757, 15236, 14721, 14211, 13707, 13210, 12720,
 12237, 11763, 11296, 10839, 10391,  9952,  9523,  9103,  8694,  8296,
  7908,  7530,  7164,  6808,  6464,  6130,  5808,  5497,  5196,  4907,
  4628,  4361,  4104,  3857,  3621,  3396,  3180,  2974,  2778,  2592,
  2414,  2246,  2086,  1935,  1793,  1658,  1531,  1411,  1299,  1193,
  1095,  1002,   916,   836,   761,   691,   627,   567,   512,   461,
   414,   371,   331,   295,   262,   232,   205,   180,   158,   137,
   119,   103,    89,    76,    64,    54,    46,    38,    32,    26,
    22,    18,    15,    13,    12,    12,
};

const int16_t AudioWindowWelch256[] __attribute__ ((aligned (4))) = {
   256,   764,  1268,  1768,  2264,  2756,  3244,  3728,  4208,  4684,
  5156,  5624,  6088,  6548,  7004,  7456,  7904,  8348,  8788,  9224,
  9656, 10084, 10508, 10928, 11344, 11756, 12164, 12568, 12968, 13364,
 13756, 14144, 14528, 14908, 15284, 15656, 16024, 16388, 16748, 17104,
 17456, 17804, 18148, 18488, 18824, 19156, 19484, 19808, 20128, 20444,
 20756, 21064, 21368, 21668, 21964, 22256, 22544, 22828, 23108, 23384,
 23656, 23924, 24188, 24448, 24704, 24956, 25204, 25448, 25688, 25924,
 26156, 26384, 26608, 26828, 27044, 27256, 27464, 27668, 27868, 28064,
 28256, 28444, 28628, 28808, 28984, 29156, 29324, 29488, 29648, 29804,
 29956, 30104, 30248, 30388, 30524, 30656, 30784, 30908, 31028, 31144,
 31256, 31364, 31468, 31568, 31664, 31756, 31844, 31928, 32008, 32084,
 32156, 32224, 32288, 32348, 32404, 32456, 32504, 32548, 32588, 32624,
 32656, 32684, 32708, 32728, 32744, 32756, 32764, 32767, 32767, 32764,
 32756, 32744, 32728, 32708, 32684, 32656, 32624, 32588, 32548, 32504,
 32456, 32404, 32348, 32288, 32224, 32156, 32084, 32008, 31928, 31844,
 31756, 31664, 31568, 31468, 31364, 31256, 31144, 31028, 30908, 30784,
 30656, 30524, 30388, 30248, 30104, 29956, 29804, 29648, 29488, 29324,
 29156, 28984, 28808, 28628, 28444, 28256, 28064, 27868, 27668, 27464,
 27256, 27044, 26828, 26608, 26384, 26156, 25924, 25688, 25448, 25204,
 24956, 24704, 24448, 24188, 23924, 23656, 23384, 23108, 22828, 22544,
 22256, 21964, 21668, 21368, 21064, 20756, 20444, 20128, 19808, 19484,
 19156, 18824, 18488, 18148, 17804, 17456, 17104, 16748, 16388, 16024,
 15656, 15284, 14908, 14528, 14144, 13756, 13364, 12968, 12568, 12164,
 11756, 11344, 10928, 10508, 10084,  9656,  9224,  8788,  8348,  7904,
  7456,  7004,  6548,  6088,  5624,  5156,  4684,  4208,  3728,  3244,
  2756,  2264,  1768,  1268,   764,   256,
};

const int16_t AudioWindowHamming256[] __attribute__ ((aligned (4))) = {
  2621,  2626,  2640,  2663,  2695,  2736,  2786,  2845,  2913,  2991,
  3077,  3172,  3276,  3388,  3509,  3639,  3778,  3925,  4080,  4243,
  4415,  4595,  4782,  4978,  5181,  5392,  5610,  5836,  6069,  6309,
  6555,  6809,  7069,  7336,  7609,  7888,  8173,  8464,  8760,  9062,
  9369,  9681,  9998, 10319, 10646, 10976, 11310, 11649, 11991, 12336,
 12685, 13037, 13391, 13749, 14108, 14470, 14834, 15199, 15566, 15935,
 16304, 16674, 17045, 17416, 17788, 18159, 18530, 18900, 19270, 19639,
 20007, 20373, 20738, 21101, 21461, 21820, 22176, 22529, 22879, 23226,
 23570, 23910, 24247, 24579, 24907, 25231, 25551, 25865, 26175, 26479,
 26778, 27072, 27360, 27642, 27918, 28188, 28451, 28708, 28958, 29202,
 29438, 29667, 29889, 30104, 30311, 30510, 30702, 30886, 31061, 31229,
 31388, 31539, 31682, 31816, 31942, 32059, 32167, 32266, 32357, 32439,
 32511, 32575, 32630, 32675, 32712, 32739, 32758, 32767, 32767, 32758,
 32739, 32712, 32675, 32630, 32575, 32511, 32439, 32357, 32266, 32167,
 32059, 31942, 31816, 31682, 31539, 31388, 31229, 31061, 30886, 30702,
 30510, 30311, 30104, 29889, 29667, 29438, 29202, 28958, 28708, 28451,
 28188, 27918, 27642, 27360, 27072, 26778, 26479, 26175, 25865, 25551,
 25231, 24907, 24579, 24247, 23910, 23570, 23226, 22879, 22529, 22176,
 21820, 21461, 21101, 20738, 20373, 20007, 19639, 19270, 18900, 18530,
 18159, 17788, 17416, 17045, 16674, 16304, 15935, 15566, 15199, 14834,
 14470, 14108, 13749, 13391, 13037, 12685, 12336, 11991, 11649, 11310,
 10976, 10646, 10319,  9998,  9681,  9369,  9062,  8760,  8464,  8173,
  7888,  7609,  7336,  7069,  6809,  6555,  6309,  6069,  5836,  5610,
  5392,  5181,  4978,  4782,  4595,  4415,  4243,  4080,  3925,  3778,
  3639,  3509,  3388,  3276,  3172,  3077,  2991,  2913,  2845,  2786,
  2736,  2695,  2663,  2640,  2626,  2621,
};

const int16_t AudioWindowCosine256[] __attribute__ ((aligned (4))) = {
     0,   404,   807,  1211,  1614,  2017,  2420,  2822,  3224,  3626,
  4027,  4427,  4827,  5226,  5624,  6021,  6417,  6813,  7207,  7600,
  7993,  8383,  8773,  9161,  9548,  9934, 10318, 10700, 11081, 11460,
 11837, 12213, 12586, 12958, 13328, 13696, 14061, 14425, 14786, 15145,
 15502, 15857, 16209, 16558, 16906, 17250, 17592, 17931, 18268, 18602,
 18932, 19261, 19586, 19908, 20227, 20543, 20856, 21166, 21472, 21776,
 22076, 22372, 22666, 22955, 23242, 23525, 23804, 24079, 24351, 24620,
 24884, 25145, 25402, 25655, 25904, 26149, 26391, 26628, 26861, 27090,
 27315, 27536, 27753, 27966, 28174, 28378, 28578, 28773, 28964, 29151,
 29333, 29510, 29684, 29852, 30017, 30176, 30331, 30482, 30628, 30769,
 30905, 31037, 31164, 31287, 31404, 31517, 31625, 31728, 31827, 31921,
 32009, 32093, 32172, 32247, 32316, 32380, 32440, 32494, 32544, 32588,
 32628, 32663, 32693, 32718, 32738, 32752, 32762, 32767, 32767, 32762,
 32752, 32738, 32718, 32693, 32663, 32628, 32588, 32544, 32494, 32440,
 32380, 32316, 32247, 32172, 32093, 32009, 31921, 31827, 31728, 31625,
 31517, 31404, 31287, 31164, 31037, 30905, 30769, 30628, 30482, 30331,
 30176, 30017, 29852, 29684, 29510, 29333, 29151, 28964, 28773, 28578,
 28378, 28174, 27966, 27753, 27536, 27315, 27090, 26861, 26628, 26391,
 26149, 25904, 25655, 25402, 25145, 24884, 24620, 24351, 24079, 23804,
 23525, 23242, 22955, 22666, 22372, 22076, 21776, 21472, 21166, 20856,
 20543, 20227, 19908, 19586, 19261, 18932, 18602, 18268, 17931, 17592,
 17250, 16906, 16558, 16209, 15857, 15502, 15145, 14786, 14425, 14061,
 13696, 13328, 12958, 12586, 12213, 11837, 11460, 11081, 10700, 10318,
  9934,  9548,  9161,  8773,  8383,  7993,  7600,  7207,  6813,  6417,
  6021,  5624,  5226,  4827,  4427,  4027,  3626,  3224,  2822,  2420,
  2017,  1614,  1211,   807,   404,     0,
};

const int16_t AudioWindowTukey256[] __attribute__ ((aligned (4))) = {
     0,    20,    80,   179,   317,   495,   711,   965,  1257,  1585,
  1949,  2349,  2782,  3249,  3747,  4276,  4834,  5421,  6034,  6672,
  7334,  8018,  8722,  9445, 10184, 10939, 11707, 12486, 13274, 14070,
 14872, 15678, 16485, 17292, 18097, 18897, 19692, 20478, 21255, 22019,
 22770, 23506, 24224, 24923, 25602, 26258, 26890, 27496, 28076, 28627,
 29148, 29639, 30097, 30522, 30913, 31268, 31588, 31870, 32115, 32321,
 32489, 32618, 32707, 32757, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32757, 32707, 32618, 32489, 32321, 32115, 31870, 31588,
 31268, 30913, 30522, 30097, 29639, 29148, 28627, 28076, 27496, 26890,
 26258, 25602, 24923, 24224, 23506, 22770, 22019, 21255, 20478, 19692,
 18897, 18097, 17292, 16485, 15678, 14872, 14070, 13274, 12486, 11707,
 10939, 10184,  9445,  8722,  8018,  7334,  6672,  6034,  5421,  4834,
  4276,  3747,  3249,  2782,  2349,  1949,  1585,  1257,   965,   711,
   495,   317,   179,    80,    20,     0,
};

const int16_t AudioWindowHanning1024[] __attribute__ ((aligned (4))) = {
     0,     0,     1,     3,     5,     8,    11,    15,    20,    25,
    31,    37,    44,    52,    61,    69,    79,    89,   100,   111,
   123,   136,   149,   163,   178,   193,   208,   225,   242,   259,
   277,   296,   315,   335,   356,   377,   399,   421,   444,   468,
   492,   517,   542,   568,   595,   622,   650,   678,   707,   736,
   767,   797,   829,   860,   893,   926,   960,   994,  1029,  1064,
  1100,  1137,  1174,  1211,  1250,  1288,  1328,  1368,  1408,  1449,
  1491,  1533,  1576,  1619,  1663,  1708,  1753,  1798,  1844,  1891,
  1938,  1986,  2034,  2083,  2133,  2182,  2233,  2284,  2335,  2387,
  2440,  2493,  2547,  2601,  2656,  2711,  2766,  2823,  2879,  2937,
  2994,  3053,  3111,  3171,  3230,  3291,  3351,  3413,  3474,  3536,
  3599,  3662,  3726,  3790,  3855,  3920,  3985,  4051,  4118,  4185,
  4252,  4320,  4388,  4457,  4526,  4596,  4666,  4737,  4808,  4879,
  4951,  5023,  5096,  5169,  5243,  5317,  5391,  5466,  5541,  5617,
  5693,  5769,  5846,  5923,  6001,  6079,  6158,  6236,  6316,  6395,
  6475,  6555,  6636,  6717,  6799,  6880,  6962,  7045,  7128,  7211,
  7295,  7379,  7463,  7547,  7632,  7717,  7803,  7889,  7975,  8062,
  8148,  8236,  8323,  8411,  8499,  8587,  8676,  8765,  8854,  8944,
  9033,  9123,  9214,  9304,  9395,  9486,  9578,  9670,  9761,  9854,
  9946, 10039, 10132, 10225, 10318, 10412, 10505, 10599, 10694, 10788,
 10883, 10978, 11073, 11168, 11264, 11359, 11455, 11551, 11648, 11744,
 11841, 11937, 12034, 12131, 12229, 12326, 12424, 12521, 12619, 12717,
 12815, 12914, 13012, 13111, 13209, 13308, 13407, 13506, 13605, 13704,
 13804, 13903, 14003, 14102, 14202, 14302, 14401, 14501, 14601, 14701,
 14802, 14902, 15002, 15102, 15203, 15303, 15403, 15504, 15604, 15705,
 15806, 15906, 16007, 16107, 16208, 16309, 16409, 16510, 16610, 16711,
 16812, 16912, 17013, 17113, 17214, 17314, 17415, 17515, 17616, 17716,
 17816, 17916, 18017, 18117, 18217, 18317, 18416, 18516, 18616, 18716,
 18815, 18915, 19014, 19113, 19213, 19312, 19411, 19509, 19608, 19707,
 19805, 19904, 20002, 20100, 20198, 20296, 20393, 20491, 20588, 20685,
 20782, 20879, 20976, 21072, 21169, 21265, 21361, 21457, 21552, 21647,
 21743, 21838, 21932, 22027, 22121, 22216, 22309, 22403, 22497, 22590,
 22683, 22776, 22868, 22961, 23053, 23144, 23236, 23327, 23418, 23509,
 23599, 23690, 23780, 23869, 23959, 24048, 24136, 24225, 24313, 24401,
 24489, 24576, 24663, 24750, 24836, 24922, 25008, 25093, 25178, 25263,
 25347, 25431, 25515, 25599, 25682, 25764, 25847, 25929, 26010, 26091,
 26172, 26253, 26333, 26413, 26492, 26571, 26650, 26728, 26806, 26883,
 26960, 27037, 27113, 27189, 27265, 27340, 27414, 27488, 27562, 27636,
 27708, 27781, 27853, 27925, 27996, 28067, 28137, 28207, 28276, 28345,
 28414, 28482, 28550, 28617, 28683, 28750, 28815, 28881, 28946, 29010,
 29074, 29137, 29200, 29263, 29325, 29386, 29447, 29508, 29568, 29627,
 29686, 29745, 29803, 29860, 29917, 29974, 30029, 30085, 30140, 30194,
 30248, 30301, 30354, 30407, 30458, 30510, 30560, 30611, 30660, 30709,
 30758, 30806, 30853, 30900, 30947, 30993, 31038, 31083, 31127, 31170,
 31213, 31256, 31298, 31339, 31380, 31420, 31460, 31499, 31538, 31576,
 31613, 31650, 31686, 31722, 31757, 31791, 31825, 31859, 31891, 31924,
 31955, 31986, 32017, 32046, 32076, 32104, 32132, 32160, 32187, 32213,
 32239, 32264, 32288, 32312, 32335, 32358, 32380, 32402, 32422, 32443,
 32462, 32481, 32500, 32518, 32535, 32551, 32567, 32583, 32598, 32612,
 32625, 32638, 32651, 32662, 32673, 32684, 32694, 32703, 32712, 32720,
 32727, 32734, 32740, 32746, 32751, 32755, 32759, 32762, 32764, 32766,
 32767, 32767, 32767, 32767, 32766, 32764, 32762, 32759, 32755, 32751,
 32746, 32740, 32734, 32727, 32720, 32712, 32703, 32694, 32684, 32673,
 32662, 32651, 32638, 32625, 32612, 32598, 32583, 32567, 32551, 32535,
 32518, 32500, 32481, 32462, 32443, 32422, 32402, 32380, 32358, 32335,
 32312, 32288, 32264, 32239, 32213, 32187, 32160, 32132, 32104, 32076,
 32046, 32017, 31986, 31955, 31924, 31891, 31859, 31825, 31791, 31757,
 31722, 31686, 31650, 31613, 31576, 31538, 31499, 31460, 31420, 31380,
 31339, 31298, 31256, 31213, 31170, 31127, 31083, 31038, 30993, 30947,
 30900, 30853, 30806, 30758, 30709, 30660, 30611, 30560, 30510, 30458,
 30407, 30354, 30301, 30248, 30194, 30140, 30085, 30029, 29974, 29917,
 29860, 29803, 29745, 29686, 29627, 29568, 29508, 29447, 29386, 29325,
 29263, 29200, 29137, 29074, 29010, 28946, 28881, 28815, 28750, 28683,
 28617, 28550, 28482, 28414, 28345, 28276, 28207, 28137, 28067, 27996,
 27925, 27853, 27781, 27708, 27636, 27562, 27488, 27414, 27340, 27265,
 27189, 27113, 27037, 26960, 26883, 26806, 26728, 26650, 26571, 26492,
 26413, 26333, 26253, 26172, 26091, 26010, 25929, 25847, 25764, 25682,
 25599, 25515, 25431, 25347, 25263, 25178, 25093, 25008, 24922, 24836,
 24750, 24663, 24576, 24489, 24401, 24313, 24225, 24136, 24048, 23959,
 23869, 23780, 23690, 23599, 23509, 23418, 23327, 23236, 23144, 23053,
 22961, 22868, 22776, 22683, 22590, 22497, 22403, 22309, 22216, 22121,
 22027, 21932, 21838, 21743, 21647, 21552, 21457, 21361, 21265, 21169,
 21072, 20976, 20879, 20782, 20685, 20588, 20491, 20393, 20296, 20198,
 20100, 20002, 19904, 19805, 19707, 19608, 19509, 19411, 19312, 19213,
 19113, 19014, 18915, 18815, 18716, 18616, 18516, 18416, 18317, 18217,
 18117, 18017, 17916, 17816, 17716, 17616, 17515, 17415, 17314, 17214,
 17113, 17013, 16912, 16812, 16711, 16610, 16510, 16409, 16309, 16208,
 16107, 16007, 15906, 15806, 15705, 15604, 15504, 15403, 15303, 15203,
 15102, 15002, 14902, 14802, 14701, 14601, 14501, 14401, 14302, 14202,
 14102, 14003, 13903, 13804, 13704, 13605, 13506, 13407, 13308, 13209,
 13111, 13012, 12914, 12815, 12717, 12619, 12521, 12424, 12326, 12229,
 12131, 12034, 11937, 11841, 11744, 11648, 11551, 11455, 11359, 11264,
 11168, 11073, 10978, 10883, 10788, 10694, 10599, 10505, 10412, 10318,
 10225, 10132, 10039,  9946,  9854,  9761,  9670,  9578,  9486,  9395,
  9304,  9214,  9123,  9033,  8944,  8854,  8765,  8676,  8587,  8499,
  8411,  8323,  8236,  8148,  8062,  7975,  7889,  7803,  7717,  7632,
  7547,  7463,  7379,  7295,  7211,  7128,  7045,  6962,  6880,  6799,
  6717,  6636,  6555,  6475,  6395,  6316,  6236,  6158,  6079,  6001,
  5923,  5846,  5769,  5693,  5617,  5541,  5466,  5391,  5317,  5243,
  5169,  5096,  5023,  4951,  4879,  4808,  4737,  4666,  4596,  4526,
  4457,  4388,  4320,  4252,  4185,  4118,  4051,  3985,  3920,  3855,
  3790,  3726,  3662,  3599,  3536,  3474,  3413,  3351,  3291,  3230,
  3171,  3111,  3053,  2994,  2937,  2879,  2823,  2766,  2711,  2656,
  2601,  2547,  2493,  2440,  2387,  2335,  2284,  2233,  2182,  2133,
  2083,  2034,  1986,  1938,  1891,  1844,  1798,  1753,  1708,  1663,
  1619,  1576,  1533,  1491,  1449,  1408,  1368,  1328,  1288,  1250,
  1211,  1174,  1137,  1100,  1064,  1029,   994,   960,   926,   893,
   860,   829,   797,   767,   736,   707,   678,   650,   622,   595,
   568,   542,   517,   492,   468,   444,   421,   399,   377,   356,
   335,   315,   296,   277,   259,   242,   225,   208,   193,   178,
   163,   149,   136,   123,   111,   100,    89,    79,    69,    61,
    52,    44,    37,    31,    25,    20,    15,    11,     8,     5,
     3,     1,     0,     0,
};

const int16_t AudioWindowBartlett1024[] __attribute__ ((aligned (4))) = {
    32,    96,   160,   224,   288,   352,   416,   480,   544,   608,
   672,   736,   800,   864,   928,   992,  1056,  1120,  1184,  1248,
  1312,  1376,  1440,  1504,  1568,  1632,  1696,  1760,  1824,  1888,
  1952,  2016,  2080,  2144,  2208,  2272,  2336,  2400,  2464,  2528,
  2592,  2656,  2720,  2784,  2848,  2912,  2976,  3040,  3104,  3168,
  3232,  3296,  3360,  3424,  3488,  3552,  3616,  3680,  3744,  3808,
  3872,  3936,  4000,  4064,  4128,  4192,  4256,  4320,  4384,  4448,
  4512,  4576,  4640,  4704,  4768,  4832,  4896,  4960,  5024,  5088,
  5152,  5216,  5280,  5344,  5408,  5472,  5536,  5600,  5664,  5728,
  5792,  5856,  5920,  5984,  6048,  6112,  6176,  6240,  6304,  6368,
  6432,  6496,  6560,  6624,  6688,  6752,  6816,  6880,  6944,  7008,
  7072,  7136,  7200,  7264,  7328,  7392,  7456,  7520,  7584,  7648,
  7712,  7776,  7840,  7904,  7968,  8032,  8096,  8160,  8224,  8288,
  8352,  8416,  8480,  8544,  8608,  8672,  8736,  8800,  8864,  8928,
  8992,  9056,  9120,  9184,  9248,  9312,  9376,  9440,  9504,  9568,
  9632,  9696,  9760,  9824,  9888,  9952, 10016, 10080, 10144, 10208,
 10272, 10336, 10400, 10464, 10528, 10592, 10656, 10720, 10784, 10848,
 10912, 10976, 11040, 11104, 11168, 11232, 11296, 11360, 11424, 11488,
 11552, 11616, 11680, 11744, 11808, 11872, 11936, 12000, 12064, 12128,
 12192, 12256, 12320, 12384, 12448, 12512, 12576, 12640, 12704, 12768,
 12832, 12896, 12960, 13024, 13088, 13152, 13216, 13280, 13344, 13408,
 13472, 13536, 13600, 13664, 13728, 13792, 13856, 13920, 13984, 14048,
 14112, 14176, 14240, 14304, 14368, 14432, 14496, 14560, 14624, 14688,
 14752, 14816, 14880, 14944, 15008, 15072, 15136, 15200, 15264, 15328,
 15392, 15456, 15520, 15584, 15648, 15712, 15776, 15840, 15904, 15968,
 16032, 16096, 16160, 16224, 16288, 16352, 16416, 16480, 16544, 16608,
 16672, 16736, 16800, 16864, 16928, 16992, 17056, 17120, 17184, 17248,
 17312, 17376, 17440, 17504, 17568, 17632, 17696, 17760, 17824, 17888,
 17952, 18016, 18080, 18144, 18208, 18272, 18336, 18400, 18464, 18528,
 18592, 18656, 18720, 18784, 18848, 18912, 18976, 19040, 19104, 19168,
 19232, 19296, 19360, 19424, 19488, 19552, 19616, 19680, 19744, 19808,
 19872, 19936, 20000, 20064, 20128, 20192, 20256, 20320, 20384, 20448,
 20512, 20576, 20640, 20704, 20768, 20832, 20896, 20960, 21024, 21088,
 21152, 21216, 21280, 21344, 21408, 21472, 21536, 21600, 21664, 21728,
 21792, 21856, 21920, 21984, 22048, 22112, 22176, 22240, 22304, 22368,
 22432, 22496, 22560, 22624, 22688, 22752, 22816, 22880, 22944, 23008,
 23072, 23136, 23200, 23264, 23328, 23392, 23456, 23520, 23584, 23648,
 23712, 23776, 23840, 23904, 23968, 24032, 24096, 24160, 24224, 24288,
 24352, 24416, 24480, 24544, 24608, 24672, 24736, 24800, 24864, 24928,
 24992, 25056, 25120, 25184, 25248, 25312, 25376, 25440, 25504, 25568,
 25632, 25696, 25760, 25824, 25888, 25952, 26016, 26080, 26144, 26208,
 26272, 26336, 26400, 26464, 26528, 26592, 26656, 26720, 26784, 26848,
 26912, 26976, 27040, 27104, 27168, 27232, 27296, 27360, 27424, 27488,
 27552, 27616, 27680, 27744, 27808, 27872, 27936, 28000, 28064, 28128,
 28192, 28256, 28320, 28384, 28448, 28512, 28576, 28640, 28704, 28768,
 28832, 28896, 28960, 29024, 29088, 29152, 29216, 29280, 29344, 29408,
 29472, 29536, 29600, 29664, 29728, 29792, 29856, 29920, 29984, 30048,
 30112, 30176, 30240, 30304, 30368, 30432, 30496, 30560, 30624, 30688,
 30752, 30816, 30880, 30944, 31008, 31072, 31136, 31200, 31264, 31328,
 31392, 31456, 31520, 31584, 31648, 31712, 31776, 31840, 31904, 31968,
 32032, 32096, 32160, 32224, 32288, 32352, 32416, 32480, 32544, 32608,
 32672, 32736, 32736, 32672, 32608, 32544, 32480, 32416, 32352, 32288,
 32224, 32160, 32096, 32032, 31968, 31904, 31840, 31776, 31712, 31648,
 31584, 31520, 31456, 31392, 31328, 31264, 31200, 31136, 31072, 31008,
 30944, 30880, 30816, 30752, 30688, 30624, 30560, 30496, 30432, 30368,
 30304, 30240, 30176, 30112, 30048, 29984, 29920, 29856, 29792, 29728,
 29664, 29600, 29536, 29472, 29408, 29344, 29280, 29216, 29152, 29088,
 29024, 28960, 28896, 28832, 28768, 28704, 28640, 28576, 28512, 28448,
 28384, 28320, 28256, 28192, 28128, 28064, 28000, 27936, 27872, 27808,
 27744, 27680, 27616, 27552, 27488, 27424, 27360, 27296, 27232, 27168,
 27104, 27040, 26976, 26912, 26848, 26784, 26720, 26656, 26592, 26528,
 26464, 26400, 26336, 26272, 26208, 26144, 26080, 26016, 25952, 25888,
 25824, 25760, 25696, 25632, 25568, 25504, 25440, 25376, 25312, 25248,
 25184, 25120, 25056, 24992, 24928, 24864, 24800, 24736, 24672, 24608,
 24544, 24480, 24416, 24352, 24288, 24224, 24160, 24096, 24032, 23968,
 23904, 23840, 23776, 23712, 23648, 23584, 23520, 23456, 23392, 23328,
 23264, 23200, 23136, 23072, 23008, 22944, 22880, 22816, 22752, 22688,
 22624, 22560, 22496, 22432, 22368, 22304, 22240, 22176, 22112, 22048,
 21984, 21920, 21856, 21792, 21728, 21664, 21600, 21536, 21472, 21408,
 21344, 21280, 21216, 21152, 21088, 21024, 20960, 20896, 20832, 20768,
 20704, 20640, 20576, 20512, 20448, 20384, 20320, 20256, 20192, 20128,
 20064, 20000, 19936, 19872, 19808, 19744, 19680, 19616, 19552, 19488,
 19424, 19360, 19296, 19232, 19168, 19104, 19040, 18976, 18912, 18848,
 18784, 18720, 18656, 18592, 18528, 18464, 18400, 18336, 18272, 18208,
 18144, 18080, 18016, 17952, 17888, 17824, 17760, 17696, 17632, 17568,
 17504, 17440, 17376, 17312, 17248, 17184, 17120, 17056, 16992, 16928,
 16864, 16800, 16736, 16672, 16608, 16544, 16480, 16416, 16352, 16288,
 16224, 16160, 16096, 16032, 15968, 15904, 15840, 15776, 15712, 15648,
 15584, 15520, 15456, 15392, 15328, 15264, 15200, 15136, 15072, 15008,
 14944, 14880, 14816, 14752, 14688, 14624, 14560, 14496, 14432, 14368,
 14304, 14240, 14176, 14112, 14048, 13984, 13920, 13856, 13792, 13728,
 13664, 13600, 13536, 13472, 13408, 13344, 13280, 13216, 13152, 13088,
 13024, 12960, 12896, 12832, 12768, 12704, 12640, 12576, 12512, 12448,
 12384, 12320, 12256, 12192, 12128, 12064, 12000, 11936, 11872, 11808,
 11744, 11680, 11616, 11552, 11488, 11424, 11360, 11296, 11232, 11168,
 11104, 11040, 10976, 10912, 10848, 10784, 10720, 10656, 10592, 10528,
 10464, 10400, 10336, 10272, 10208, 10144, 10080, 10016,  9952,  9888,
  9824,  9760,  9696,  9632,  9568,  9504,  9440,  9376,  9312,  9248,
  9184,  9120,  9056,  8992,  8928,  8864,  8800,  8736,  8672,  8608,
  8544,  8480,  8416,  8352,  8288,  8224,  8160,  8096,  8032,  7968,
  7904,  7840,  7776,  7712,  7648,  7584,  7520,  7456,  7392,  7328,
  7264,  7200,  7136,  7072,  7008,  6944,  6880,  6816,  6752,  6688,
  6624,  6560,  6496,  6432,  6368,  6304,  6240,  6176,  6112,  6048,
  5984,  5920,  5856,  5792,  5728,  5664,  5600,  5536,  5472,  5408,
  5344,  5280,  5216,  5152,  5088,  5024,  4960,  4896,  4832,  4768,
  4704,  4640,  4576,  4512,  4448,  4384,  4320,  4256,  4192,  4128,
  4064,  4000,  3936,  3872,  3808,  3744,  3680,  3616,  3552,  3488,
  3424,  3360,  3296,  3232,  3168,  3104,  3040,  2976,  2912,  2848,
  2784,  2720,  2656,  2592,  2528,  2464,  2400,  2336,  2272,  2208,
  2144,  2080,  2016,  1952,  1888,  1824,  1760,  1696,  1632,  1568,
  1504,  1440,  1376,  1312,  1248,  1184,  1120,  1056,   992,   928,
   864,   800,   736,   672,   608,   544,   480,   416,   352,   288,
   224,   160,    96,    32,
};

const int16_t AudioWindowBlackman1024[] __attribute__ ((aligned (4))) = {
     0,     0,     0,     1,     2,     3,     4,     5,     7,     9,
    11,    13,    16,    19,    22,    25,    29,    32,    36,    40,
    45,    49,    54,    59,    65,    70,    76,    82,    88,    95,
   101,   108,   115,   123,   131,   139,   147,   155,   164,   173,
   182,   191,   201,   211,   221,   231,   242,   253,   264,   276,
   287,   299,   312,   324,   337,   350,   363,   377,   391,   405,
   420,   434,   449,   465,   480,   496,   512,   529,   546,   563,
   580,   598,   616,   634,   653,   672,   691,   711,   730,   751,
   771,   792,   813,   835,   857,   879,   901,   924,   947,   971,
   995,  1019,  1044,  1068,  1094,  1119,  1145,  1172,  1199,  1226,
  1253,  1281,  1309,  1338,  1367,  1396,  1426,  1456,  1486,  1517,
  1549,  1580,  1613,  1645,  1678,  1711,  1745,  1779,  1814,  1849,
  1884,  1920,  1956,  1993,  2030,  2067,  2105,  2143,  2182,  2221,
  2261,  2301,  2342,  2383,  2424,  2466,  2508,  2551,  2595,  2638,
  2682,  2727,  2772,  2818,  2864,  2910,  2957,  3005,  3053,  3101,
  3150,  3199,  3249,  3299,  3350,  3402,  3453,  3506,  3558,  3612,
  3665,  3720,  3774,  3830,  3885,  3942,  3998,  4056,  4113,  4172,
  4230,  4290,  4349,  4410,  4470,  4532,  4593,  4656,  4719,  4782,
  4846,  4910,  4975,  5040,  5106,  5173,  5240,  5307,  5375,  5444,
  5513,  5582,  5652,  5723,  5794,  5865,  5938,  6010,  6083,  6157,
  6231,  6306,  6381,  6457,  6533,  6610,  6687,  6765,  6843,  6922,
  7001,  7081,  7161,  7242,  7323,  7405,  7487,  7570,  7653,  7737,
  7821,  7906,  7991,  8077,  8163,  8250,  8337,  8425,  8513,  8602,
  8691,  8780,  8870,  8961,  9052,  9143,  9235,  9328,  9421,  9514,
  9608,  9702,  9796,  9891,  9987, 10083, 10179, 10276, 10373, 10471,
 10569, 10668, 10767, 10866, 10966, 11066, 11166, 11267, 11369, 11470,
 11572, 11675, 11778, 11881, 11984, 12088, 12193, 12297, 12402, 12508,
 12613, 12719, 12826, 12932, 13039, 13147, 13254, 13362, 13470, 13579,
 13688, 13797, 13906, 14016, 14126, 14236, 14347, 14457, 14568, 14679,
 14791, 14903, 15014, 15127, 15239, 15352, 15464, 15577, 15690, 15804,
 15917, 16031, 16145, 16259, 16373, 16487, 16602, 16716, 16831, 16946,
 17061, 17176, 17291, 17406, 17521, 17637, 17752, 17868, 17984, 18099,
 18215, 18331, 18447, 18562, 18678, 18794, 18910, 19026, 19142, 19258,
 19373, 19489, 19605, 19721, 19836, 19952, 20067, 20183, 20298, 20414,
 20529, 20644, 20759, 20874, 20988, 21103, 21217, 21332, 21446, 21560,
 21674, 21787, 21901, 22014, 22127, 22240, 22353, 22465, 22577, 22689,
 22801, 22912, 23023, 23134, 23245, 23355, 23465, 23575, 23684, 23793,
 23902, 24011, 24119, 24226, 24334, 24441, 24548, 24654, 24760, 24865,
 24970, 25075, 25179, 25283, 25387, 25489, 25592, 25694, 25796, 25897,
 25997, 26098, 26197, 26297, 26395, 26493, 26591, 26688, 26785, 26881,
 26976, 27071, 27165, 27259, 27352, 27445, 27537, 27629, 27719, 27810,
 27899, 27988, 28076, 28164, 28251, 28338, 28423, 28508, 28593, 28676,
 28759, 28842, 28923, 29004, 29084, 29164, 29243, 29321, 29398, 29475,
 29550, 29625, 29700, 29773, 29846, 29918, 29989, 30059, 30129, 30198,
 30266, 30333, 30399, 30465, 30529, 30593, 30656, 30718, 30780, 30840,
 30900, 30959, 31017, 31074, 31130, 31185, 31239, 31293, 31345, 31397,
 31448, 31498, 31547, 31595, 31642, 31688, 31733, 31778, 31821, 31864,
 31905, 31946, 31986, 32024, 32062, 32099, 32135, 32170, 32204, 32237,
 32269, 32300, 32330, 32359, 32387, 32414, 32440, 32465, 32489, 32512,
 32534, 32556, 32576, 32595, 32613, 32630, 32646, 32662, 32676, 32689,
 32701, 32712, 32722, 32731, 32740, 32747, 32753, 32758, 32762, 32765,
 32767, 32767, 32767, 32767, 32765, 32762, 32758, 32753, 32747, 32740,
 32731, 32722, 32712, 32701, 32689, 32676, 32662, 32646, 32630, 32613,
 32595, 32576, 32556, 32534, 32512, 32489, 32465, 32440, 32414, 32387,
 32359, 32330, 32300, 32269, 32237, 32204, 32170, 32135, 32099, 32062,
 32024, 31986, 31946, 31905, 31864, 31821, 31778, 31733, 31688, 31642,
 31595, 31547, 31498, 31448, 31397, 31345, 31293, 31239, 31185, 31130,
 31074, 31017, 30959, 30900, 30840, 30780, 30718, 30656, 30593, 30529,
 30465, 30399, 30333, 30266, 30198, 30129, 30059, 29989, 29918, 29846,
 29773, 29700, 29625, 29550, 29475, 29398, 29321, 29243, 29164, 29084,
 29004, 28923, 28842, 28759, 28676, 28593, 28508, 28423, 28338, 28251,
 28164, 28076, 27988, 27899, 27810, 27719, 27629, 27537, 27445, 27352,
 27259, 27165, 27071, 26976, 26881, 26785, 26688, 26591, 26493, 26395,
 26297, 26197, 26098, 25997, 25897, 25796, 25694, 25592, 25489, 25387,
 25283, 25179, 25075, 24970, 24865, 24760, 24654, 24548, 24441, 24334,
 24226, 24119, 24011, 23902, 23793, 23684, 23575, 23465, 23355, 23245,
 23134, 23023, 22912, 22801, 22689, 22577, 22465, 22353, 22240, 22127,
 22014, 21901, 21787, 21674, 21560, 21446, 21332, 21217, 21103, 20988,
 20874, 20759, 20644, 20529, 20414, 20298, 20183, 20067, 19952, 19836,
 19721, 19605, 19489, 19373, 19258, 19142, 19026, 18910, 18794, 18678,
 18562, 18447, 18331, 18215, 18099, 17984, 17868, 17752, 17637, 17521,
 17406, 17291, 17176, 17061, 16946, 16831, 16716, 16602, 16487, 16373,
 16259, 16145, 16031, 15917, 15804, 15690, 15577, 15464, 15352, 15239,
 15127, 15014, 14903, 14791, 14679, 14568, 14457, 14347, 14236, 14126,
 14016, 13906, 13797, 13688, 13579, 13470, 13362, 13254, 13147, 13039,
 12932, 12826, 12719, 12613, 12508, 12402, 12297, 12193, 12088, 11984,
 11881, 11778, 11675, 11572, 11470, 11369, 11267, 11166, 11066, 10966,
 10866, 10767, 10668, 10569, 10471, 10373, 10276, 10179, 10083,  9987,
  9891,  9796,  9702,  9608,  9514,  9421,  9328,  9235,  9143,  9052,
  8961,  8870,  8780,  8691,  8602,  8513,  8425,  8337,  8250,  8163,
  8077,  7991,  7906,  7821,  7737,  7653,  7570,  7487,  7405,  7323,
  7242,  7161,  7081,  7001,  6922,  6843,  6765,  6687,  6610,  6533,
  6457,  6381,  6306,  6231,  6157,  6083,  6010,  5938,  5865,  5794,
  5723,  5652,  5582,  5513,  5444,  5375,  5307,  5240,  5173,  5106,
  5040,  4975,  4910,  4846,  4782,  4719,  4656,  4593,  4532,  4470,
  4410,  4349,  4290,  4230,  4172,  4113,  4056,  3998,  3942,  3885,
  3830,  3774,  3720,  3665,  3612,  3558,  3506,  3453,  3402,  3350,
  3299,  3249,  3199,  3150,  3101,  3053,  3005,  2957,  2910,  2864,
  2818,  2772,  2727,  2682,  2638,  2595,  2551,  2508,  2466,  2424,
  2383,  2342,  2301,  2261,  2221,  2182,  2143,  2105,  2067,  2030,
  1993,  1956,  1920,  1884,  1849,  1814,  1779,  1745,  1711,  1678,
  1645,  1613,  1580,  1549,  1517,  1486,  1456,  1426,  1396,  1367,
  1338,  1309,  1281,  1253,  1226,  1199,  1172,  1145,  1119,  1094,
  1068,  1044,  1019,   995,   971,   947,   924,   901,   879,   857,
   835,   813,   792,   771,   751,   730,   711,   691,   672,   653,
   634,   616,   598,   580,   563,   546,   529,   512,   496,   480,
   465,   449,   434,   420,   405,   391,   377,   363,   350,   337,
   324,   312,   299,   287,   276,   264,   253,   242,   231,   221,
   211,   201,   191,   182,   173,   164,   155,   147,   139,   131,
   123,   115,   108,   101,    95,    88,    82,    76,    70,    65,
    59,    54,    49,    45,    40,    36,    32,    29,    25,    22,
    19,    16,    13,    11,     9,     7,     5,     4,     3,     2,
     1,     0,     0,     0,
};

const int16_t AudioWindowFlattop1024[] __attribute__ ((aligned (4))) = {
     0,     0,     0,     0,     0,     0,     0,     0,    -1,    -1,
    -2,    -2,    -3,    -3,    -4,    -5,    -5,    -6,    -7,    -8,
    -9,   -10,   -12,   -13,   -14,   -15,   -17,   -18,   -20,   -21,
   -23,   -25,   -27,   -29,   -31,   -33,   -35,   -37,   -40,   -42,
   -44,   -47,   -50,   -53,   -55,   -58,   -61,   -65,   -68,   -71,
   -75,   -78,   -82,   -86,   -90,   -94,   -98,  -103,  -107,  -112,
  -116,  -121,  -126,  -131,  -136,  -142,  -147,  -153,  -159,  -165,
  -171,  -177,  -184,  -190,  -197,  -204,  -211,  -218,  -226,  -233,
  -241,  -249,  -257,  -265,  -274,  -283,  -291,  -300,  -310,  -319,
  -329,  -338,  -348,  -358,  -369,  -379,  -390,  -401,  -412,  -423,
  -435,  -447,  -459,  -471,  -483,  -495,  -508,  -521,  -534,  -548,
  -561,  -575,  -589,  -603,  -617,  -632,  -646,  -661,  -676,  -692,
  -707,  -723,  -739,  -755,  -771,  -787,  -804,  -821,  -838,  -855,
  -872,  -890,  -907,  -925,  -943,  -961,  -979,  -998, -1016, -1035,
 -1054, -1073, -1092, -1111, -1131, -1150, -1170, -1189, -1209, -1229,
 -1249, -1269, -1289, -1310, -1330, -1350, -1370, -1391, -1411, -1432,
 -1452, -1473, -1493, -1514, -1534, -1555, -1575, -1596, -1616, -1637,
 -1657, -1677, -1697, -1717, -1737, -1757, -1777, -1797, -1816, -1835,
 -1855, -1874, -1892, -1911, -1929, -1948, -1966, -1983, -2001, -2018,
 -2035, -2052, -2068, -2084, -2100, -2115, -2130, -2145, -2159, -2173,
 -2187, -2200, -2212, -2224, -2236, -2247, -2258, -2269, -2278, -2288,
 -2296, -2304, -2312, -2319, -2325, -2331, -2336, -2341, -2344, -2347,
 -2350, -2352, -2353, -2353, -2352, -2351, -2349, -2346, -2342, -2338,
 -2332, -2326, -2319, -2311, -2302, -2292, -2281, -2269, -2257, -2243,
 -2228, -2212, -2196, -2178, -2159, -2139, -2118, -2095, -2072, -2047,
 -2022, -1995, -1967, -1938, -1907, -1875, -1843, -1808, -1773, -1736,
 -1698, -1659, -1618, -1576, -1532, -1488, -1442, -1394, -1345, -1295,
 -1243, -1190, -1135, -1079, -1021,  -962,  -902,  -840,  -776,  -711,
  -644,  -576,  -506,  -435,  -362,  -288,  -211,  -134,   -55,    25,
   108,   192,   277,   365,   454,   544,   637,   730,   826,   923,
  1022,  1123,  1225,  1329,  1434,  1541,  1650,  1761,  1873,  1987,
  2102,  2219,  2338,  2459,  2581,  2705,  2830,  2958,  3086,  3217,
  3349,  3483,  3618,  3755,  3894,  4034,  4176,  4319,  4464,  4611,
  4759,  4908,  5060,  5212,  5367,  5523,  5680,  5839,  5999,  6161,
  6324,  6489,  6655,  6822,  6991,  7161,  7333,  7506,  7680,  7855,
  8032,  8210,  8390,  8570,  8752,  8935,  9119,  9305,  9491,  9679,
  9867, 10057, 10248, 10440, 10632, 10826, 11021, 11216, 11413, 11610,
 11808, 12007, 12207, 12407, 12609, 12811, 13013, 13216, 13420, 13625,
 13830, 14035, 14241, 14448, 14655, 14862, 15070, 15278, 15486, 15695,
 15904, 16113, 16322, 16531, 16741, 16950, 17160, 17370, 17579, 17789,
 17998, 18208, 18417, 18626, 18834, 19043, 19251, 19459, 19666, 19873,
 20080, 20286, 20491, 20696, 20901, 21104, 21307, 21510, 21711, 21912,
 22112, 22312, 22510, 22707, 22904, 23099, 23294, 23487, 23679, 23870,
 24060, 24249, 24437, 24623, 24808, 24991, 25173, 25354, 25534, 25711,
 25888, 26062, 26236, 26407, 26577, 26745, 26912, 27076, 27239, 27400,
 27560, 27717, 27872, 28026, 28177, 28327, 28474, 28620, 28763, 28904,
 29044, 29180, 29315, 29448, 29578, 29706, 29831, 29955, 30076, 30194,
 30310, 30424, 30535, 30644, 30750, 30854, 30955, 31054, 31150, 31243,
 31334, 31422, 31508, 31590, 31670, 31748, 31823, 31895, 31964, 32030,
 32094, 32155, 32213, 32268, 32320, 32370, 32416, 32460, 32501, 32539,
 32574, 32606, 32635, 32662, 32685, 32706, 32724, 32738, 32750, 32759,
 32765, 32767, 32767, 32765, 32759, 32750, 32738, 32724, 32706, 32685,
 32662, 32635, 32606, 32574, 32539, 32501, 32460, 32416, 32370, 32320,
 32268, 32213, 32155, 32094, 32030, 31964, 31895, 31823, 31748, 31670,
 31590, 31508, 31422, 31334, 31243, 31150, 31054, 30955, 30854, 30750,
 30644, 30535, 30424, 30310, 30194, 30076, 29955, 29831, 29706, 29578,
 29448, 29315, 29180, 29044, 28904, 28763, 28620, 28474, 28327, 28177,
 28026, 27872, 27717, 27560, 27400, 27239, 27076, 26912, 26745, 26577,
 26407, 26236, 26062, 25888, 25711, 25534, 25354, 25173, 24991, 24808,
 24623, 24437, 24249, 24060, 23870, 23679, 23487, 23294, 23099, 22904,
 22707, 22510, 22312, 22112, 21912, 21711, 21510, 21307, 21104, 20901,
 20696, 20491, 20286, 20080, 19873, 19666, 19459, 19251, 19043, 18834,
 18626, 18417, 18208, 17998, 17789, 17579, 17370, 17160, 16950, 16741,
 16531, 16322, 16113, 15904, 15695, 15486, 15278, 15070, 14862, 14655,
 14448, 14241, 14035, 13830, 13625, 13420, 13216, 13013, 12811, 12609,
 12407, 12207, 12007, 11808, 11610, 11413, 11216, 11021, 10826, 10632,
 10440, 10248, 10057,  9867,  9679,  9491,  9305,  9119,  8935,  8752,
  8570,  8390,  8210,  8032,  7855,  7680,  7506,  7333,  7161,  6991,
  6822,  6655,  6489,  6324,  6161,  5999,  5839,  5680,  5523,  5367,
  5212,  5060,  4908,  4759,  4611,  4464,  4319,  4176,  4034,  3894,
  3755,  3618,  3483,  3349,  3217,  3086,  2958,  2830,  2705,  2581,
  2459,  2338,  2219,  2102,  1987,  1873,  1761,  1650,  1541,  1434,
  1329,  1225,  1123,  1022,   923,   826,   730,   637,   544,   454,
   365,   277,   192,   108,    25,   -55,  -134,  -211,  -288,  -362,
  -435,  -506,  -576,  -644,  -711,  -776,  -840,  -902,  -962, -1021,
 -1079, -1135, -1190, -1243, -1295, -1345, -1394, -1442, -1488, -1532,
 -1576, -1618, -1659, -1698, -1736, -1773, -1808, -1843, -1875, -1907,
 -1938, -1967, -1995, -2022, -2047, -2072, -2095, -2118, -2139, -2159,
 -2178, -2196, -2212, -2228, -2243, -2257, -2269, -2281, -2292, -2302,
 -2311, -2319, -2326, -2332, -2338, -2342, -2346, -2349, -2351, -2352,
 -2353, -2353, -2352, -2350, -2347, -2344, -2341, -2336, -2331, -2325,
 -2319, -2312, -2304, -2296, -2288, -2278, -2269, -2258, -2247, -2236,
 -2224, -2212, -2200, -2187, -2173, -2159, -2145, -2130, -2115, -2100,
 -2084, -2068, -2052, -2035, -2018, -2001, -1983, -1966, -1948, -1929,
 -1911, -1892, -1874, -1855, -1835, -1816, -1797, -1777, -1757, -1737,
 -1717, -1697, -1677, -1657, -1637, -1616, -1596, -1575, -1555, -1534,
 -1514, -1493, -1473, -1452, -1432, -1411, -1391, -1370, -1350, -1330,
 -1310, -1289, -1269, -1249, -1229, -1209, -1189, -1170, -1150, -1131,
 -1111, -1092, -1073, -1054, -1035, -1016,  -998,  -979,  -961,  -943,
  -925,  -907,  -890,  -872,  -855,  -838,  -821,  -804,  -787,  -771,
  -755,  -739,  -723,  -707,  -692,  -676,  -661,  -646,  -632,  -617,
  -603,  -589,  -575,  -561,  -548,  -534,  -521,  -508,  -495,  -483,
  -471,  -459,  -447,  -435,  -423,  -412,  -401,  -390,  -379,  -369,
  -358,  -348,  -338,  -329,  -319,  -310,  -300,  -291,  -283,  -274,
  -265,  -257,  -249,  -241,  -233,  -226,  -218,  -211,  -204,  -197,
  -190,  -184,  -177,  -171,  -165,  -159,  -153,  -147,  -142,  -136,
  -131,  -126,  -121,  -116,  -112,  -107,  -103,   -98,   -94,   -90,
   -86,   -82,   -78,   -75,   -71,   -68,   -65,   -61,   -58,   -55,
   -53,   -50,   -47,   -44,   -42,   -40,   -37,   -35,   -33,   -31,
   -29,   -27,   -25,   -23,   -21,   -20,   -18,   -17,   -15,   -14,
   -13,   -12,   -10,    -9,    -8,    -7,    -6,    -5,    -5,    -4,
    -3,    -3,    -2,    -2,    -1,    -1,     0,     0,     0,     0,
     0,     0,     0,     0,
};

const int16_t AudioWindowBlackmanHarris1024[] __attribute__ ((aligned (4))) = {
     2,     2,     2,     2,     2,     2,     3,     3,     3,     3,
     4,     4,     5,     5,     5,     6,     7,     7,     8,     8,
     9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
    19,    20,    22,    23,    24,    26,    27,    29,    31,    32,
    34,    36,    38,    40,    42,    44,    46,    48,    51,    53,
    56,    58,    61,    64,    67,    70,    73,    76,    79,    82,
    86,    89,    93,    97,   100,   104,   109,   113,   117,   122,
   126,   131,   136,   141,   146,   151,   156,   162,   168,   173,
   179,   186,   192,   198,   205,   212,   219,   226,   233,   241,
   249,   256,   265,   273,   281,   290,   299,   308,   317,   327,
   337,   347,   357,   367,   378,   389,   400,   411,   423,   435,
   447,   459,   472,   485,   498,   512,   526,   540,   554,   569,
   584,   599,   614,   630,   646,   663,   680,   697,   714,   732,
   750,   769,   788,   807,   827,   846,   867,   887,   908,   930,
   952,   974,   996,  1019,  1043,  1067,  1091,  1115,  1140,  1166,
  1192,  1218,  1245,  1272,  1299,  1328,  1356,  1385,  1414,  1444,
  1475,  1506,  1537,  1569,  1601,  1634,  1667,  1701,  1735,  1770,
  1806,  1841,  1878,  1915,  1952,  1990,  2029,  2068,  2107,  2147,
  2188,  2229,  2271,  2314,  2357,  2400,  2444,  2489,  2534,  2580,
  2627,  2674,  2722,  2770,  2819,  2868,  2918,  2969,  3021,  3073,
  3125,  3178,  3232,  3287,  3342,  3398,  3454,  3511,  3569,  3628,
  3687,  3747,  3807,  3868,  3930,  3992,  4055,  4119,  4184,  4249,
  4315,  4381,  4448,  4516,  4585,  4654,  4724,  4794,  4866,  4938,
  5011,  5084,  5158,  5233,  5309,  5385,  5462,  5539,  5618,  5697,
  5777,  5857,  5938,  6020,  6103,  6186,  6270,  6355,  6440,  6526,
  6613,  6701,  6789,  6878,  6967,  7058,  7149,  7241,  7333,  7426,
  7520,  7615,  7710,  7806,  7902,  8000,  8097,  8196,  8295,  8395,
  8496,  8597,  8699,  8802,  8905,  9009,  9114,  9219,  9325,  9432,
  9539,  9647,  9755,  9864,  9974, 10084, 10195, 10307, 10419, 10532,
 10645, 10759, 10873, 10989, 11104, 11220, 11337, 11455, 11572, 11691,
 11810, 11929, 12049, 12170, 12291, 12413, 12535, 12657, 12780, 12904,
 13028, 13152, 13277, 13402, 13528, 13654, 13781, 13908, 14035, 14163,
 14292, 14420, 14549, 14679, 14808, 14938, 15069, 15199, 15330, 15462,
 15593, 15725, 15857, 15990, 16123, 16256, 16389, 16522, 16656, 16790,
 16924, 17058, 17193, 17327, 17462, 17597, 17732, 17867, 18002, 18138,
 18273, 18409, 18544, 18680, 18816, 18952, 19087, 19223, 19359, 19495,
 19630, 19766, 19902, 20037, 20173, 20308, 20444, 20579, 20714, 20849,
 20984, 21118, 21253, 21387, 21521, 21655, 21789, 21922, 22055, 22188,
 22321, 22453, 22585, 22717, 22848, 22979, 23110, 23240, 23370, 23500,
 23629, 23757, 23886, 24014, 24141, 24268, 24394, 24520, 24646, 24771,
 24895, 25019, 25142, 25265, 25387, 25509, 25630, 25750, 25870, 25989,
 26107, 26225, 26342, 26458, 26574, 26688, 26802, 26916, 27028, 27140,
 27251, 27362, 27471, 27580, 27687, 27794, 27901, 28006, 28110, 28214,
 28316, 28418, 28518, 28618, 28717, 28815, 28912, 29008, 29103, 29196,
 29289, 29381, 29472, 29562, 29650, 29738, 29825, 29910, 29995, 30078,
 30160, 30241, 30321, 30400, 30478, 30554, 30629, 30703, 30776, 30848,
 30919, 30988, 31056, 31123, 31188, 31253, 31316, 31378, 31438, 31498,
 31556, 31613, 31668, 31722, 31775, 31827, 31877, 31926, 31973, 32020,
 32065, 32108, 32150, 32191, 32231, 32269, 32305, 32341, 32375, 32407,
 32439, 32468, 32497, 32524, 32549, 32574, 32596, 32618, 32638, 32656,
 32673, 32689, 32703, 32716, 32728, 32738, 32746, 32754, 32759, 32764,
 32766, 32767, 32767, 32766, 32764, 32759, 32754, 32746, 32738, 32728,
 32716, 32703, 32689, 32673, 32656, 32638, 32618, 32596, 32574, 32549,
 32524, 32497, 32468, 32439, 32407, 32375, 32341, 32305, 32269, 32231,
 32191, 32150, 32108, 32065, 32020, 31973, 31926, 31877, 31827, 31775,
 31722, 31668, 31613, 31556, 31498, 31438, 31378, 31316, 31253, 31188,
 31123, 31056, 30988, 30919, 30848, 30776, 30703, 30629, 30554, 30478,
 30400, 30321, 30241, 30160, 30078, 29995, 29910, 29825, 29738, 29650,
 29562, 29472, 29381, 29289, 29196, 29103, 29008, 28912, 28815, 28717,
 28618, 28518, 28418, 28316, 28214, 28110, 28006, 27901, 27794, 27687,
 27580, 27471, 27362, 27251, 27140, 27028, 26916, 26802, 26688, 26574,
 26458, 26342, 26225, 26107, 25989, 25870, 25750, 25630, 25509, 25387,
 25265, 25142, 25019, 24895, 24771, 24646, 24520, 24394, 24268, 24141,
 24014, 23886, 23757, 23629, 23500, 23370, 23240, 23110, 22979, 22848,
 22717, 22585, 22453, 22321, 22188, 22055, 21922, 21789, 21655, 21521,
 21387, 21253, 21118, 20984, 20849, 20714, 20579, 20444, 20308, 20173,
 20037, 19902, 19766, 19630, 19495, 19359, 19223, 19087, 18952, 18816,
 18680, 18544, 18409, 18273, 18138, 18002, 17867, 17732, 17597, 17462,
 17327, 17193, 17058, 16924, 16790, 16656, 16522, 16389, 16256, 16123,
 15990, 15857, 15725, 15593, 15462, 15330, 15199, 15069, 14938, 14808,
 14679, 14549, 14420, 14292, 14163, 14035, 13908, 13781, 13654, 13528,
 13402, 13277, 13152, 13028, 12904, 12780, 12657, 12535, 12413, 12291,
 12170, 12049, 11929, 11810, 11691, 11572, 11455, 11337, 11220, 11104,
 10989, 10873, 10759, 10645, 10532, 10419, 10307, 10195, 10084,  9974,
  9864,  9755,  9647,  9539,  9432,  9325,  9219,  9114,  9009,  8905,
  8802,  8699,  8597,  8496,  8395,  8295,  8196,  8097,  8000,  7902,
  7806,  7710,  7615,  7520,  7426,  7333,  7241,  7149,  7058,  6967,
  6878,  6789,  6701,  6613,  6526,  6440,  6355,  6270,  6186,  6103,
  6020,  5938,  5857,  5777,  5697,  5618,  5539,  5462,  5385,  5309,
  5233,  5158,  5084,  5011,  4938,  4866,  4794,  4724,  4654,  4585,
  4516,  4448,  4381,  4315,  4249,  4184,  4119,  4055,  3992,  3930,
  3868,  3807,  3747,  3687,  3628,  3569,  3511,  3454,  3398,  3342,
  3287,  3232,  3178,  3125,  3073,  3021,  2969,  2918,  2868,  2819,
  2770,  2722,  2674,  2627,  2580,  2534,  2489,  2444,  2400,  2357,
  2314,  2271,  2229,  2188,  2147,  2107,  2068,  2029,  1990,  1952,
  1915,  1878,  1841,  1806,  1770,  1735,  1701,  1667,  1634,  1601,
  1569,  1537,  1506,  1475,  1444,  1414,  1385,  1356,  1328,  1299,
  1272,  1245,  1218,  1192,  1166,  1140,  1115,  1091,  1067,  1043,
  1019,   996,   974,   952,   930,   908,   887,   867,   846,   827,
   807,   788,   769,   750,   732,   714,   697,   680,   663,   646,
   630,   614,   599,   584,   569,   554,   540,   526,   512,   498,
   485,   472,   459,   447,   435,   423,   411,   400,   389,   378,
   367,   357,   347,   337,   327,   317,   308,   299,   290,   281,
   273,   265,   256,   249,   241,   233,   226,   219,   212,   205,
   198,   192,   186,   179,   173,   168,   162,   156,   151,   146,
   141,   136,   131,   126,   122,   117,   113,   109,   104,   100,
    97,    93,    89,    86,    82,    79,    76,    73,    70,    67,
    64,    61,    58,    56,    53,    51,    48,    46,    44,    42,
    40,    38,    36,    34,    32,    31,    29,    27,    26,    24,
    23,    22,    20,    19,    18,    17,    16,    15,    14,    13,
    12,    11,    10,     9,     8,     8,     7,     7,     6,     5,
     5,     5,     4,     4,     3,     3,     3,     3,     2,     2,
     2,     2,     2,     2,
};

const int16_t AudioWindowNuttall1024[] __attribute__ ((aligned (4))) = {
     0,     0,     0,     0,     0,     0,     1,     1,     1,     1,
     1,     2,     2,     3,     3,     3,     4,     4,     5,     6,
     6,     7,     8,     8,     9,    10,    11,    12,    13,    14,
    15,    16,    17,    18,    19,    20,    22,    23,    25,    26,
    28,    29,    31,    33,    34,    36,    38,    40,    42,    44,
    47,    49,    51,    54,    56,    59,    62,    64,    67,    70,
    73,    77,    80,    83,    87,    90,    94,    98,   102,   106,
   110,   114,   118,   123,   128,   132,   137,   142,   148,   153,
   158,   164,   170,   176,   182,   188,   194,   201,   208,   215,
   222,   229,   237,   244,   252,   260,   268,   277,   285,   294,
   303,   313,   322,   332,   342,   352,   362,   373,   384,   395,
   407,   418,   430,   442,   455,   467,   480,   494,   507,   521,
   535,   549,   564,   579,   594,   610,   626,   642,   659,   676,
   693,   710,   728,   747,   765,   784,   803,   823,   843,   864,
   884,   905,   927,   949,   971,   994,  1017,  1041,  1065,  1089,
  1114,  1139,  1165,  1191,  1217,  1244,  1272,  1299,  1328,  1357,
  1386,  1416,  1446,  1476,  1508,  1539,  1571,  1604,  1637,  1671,
  1705,  1740,  1775,  1811,  1847,  1884,  1921,  1959,  1997,  2036,
  2076,  2116,  2156,  2197,  2239,  2282,  2324,  2368,  2412,  2457,
  2502,  2548,  2594,  2641,  2689,  2737,  2786,  2836,  2886,  2937,
  2988,  3040,  3093,  3146,  3200,  3255,  3310,  3366,  3423,  3480,
  3538,  3597,  3656,  3716,  3776,  3838,  3900,  3962,  4025,  4089,
  4154,  4220,  4286,  4352,  4420,  4488,  4557,  4626,  4697,  4768,
  4839,  4912,  4985,  5059,  5133,  5208,  5284,  5361,  5438,  5517,
  5595,  5675,  5755,  5836,  5918,  6000,  6083,  6167,  6252,  6337,
  6423,  6510,  6597,  6685,  6774,  6864,  6954,  7045,  7137,  7229,
  7323,  7416,  7511,  7606,  7702,  7799,  7896,  7994,  8093,  8193,
  8293,  8393,  8495,  8597,  8700,  8804,  8908,  9013,  9118,  9224,
  9331,  9439,  9547,  9656,  9765,  9875,  9986, 10097, 10209, 10322,
 10435, 10549, 10663, 10778, 10894, 11010, 11127, 11244, 11362, 11480,
 11599, 11719, 11839, 11960, 12081, 12203, 12325, 12448, 12571, 12695,
 12819, 12944, 13069, 13194, 13321, 13447, 13574, 13702, 13829, 13958,
 14086, 14215, 14345, 14475, 14605, 14736, 14867, 14998, 15130, 15262,
 15394, 15526, 15659, 15793, 15926, 16060, 16194, 16328, 16462, 16597,
 16732, 16867, 17003, 17138, 17274, 17410, 17546, 17682, 17818, 17954,
 18091, 18227, 18364, 18501, 18638, 18774, 18911, 19048, 19185, 19322,
 19459, 19596, 19733, 19870, 20006, 20143, 20280, 20416, 20552, 20689,
 20825, 20961, 21097, 21232, 21368, 21503, 21638, 21773, 21907, 22041,
 22176, 22309, 22443, 22576, 22709, 22841, 22973, 23105, 23237, 23368,
 23498, 23629, 23758, 23888, 24017, 24145, 24273, 24401, 24528, 24654,
 24780, 24905, 25030, 25155, 25278, 25401, 25524, 25646, 25767, 25887,
 26007, 26127, 26245, 26363, 26480, 26596, 26712, 26827, 26941, 27055,
 27167, 27279, 27390, 27500, 27609, 27718, 27825, 27932, 28038, 28143,
 28247, 28350, 28452, 28553, 28654, 28753, 28851, 28949, 29045, 29140,
 29234, 29328, 29420, 29511, 29601, 29690, 29778, 29865, 29950, 30035,
 30118, 30201, 30282, 30362, 30441, 30518, 30595, 30670, 30744, 30817,
 30889, 30959, 31028, 31096, 31163, 31228, 31292, 31355, 31417, 31477,
 31536, 31594, 31650, 31705, 31759, 31811, 31862, 31912, 31960, 32007,
 32053, 32097, 32140, 32182, 32222, 32260, 32298, 32334, 32368, 32401,
 32433, 32463, 32492, 32520, 32546, 32570, 32594, 32615, 32636, 32654,
 32672, 32688, 32702, 32715, 32727, 32737, 32746, 32753, 32759, 32763,
 32766, 32767, 32767, 32766, 32763, 32759, 32753, 32746, 32737, 32727,
 32715, 32702, 32688, 32672, 32654, 32636, 32615, 32594, 32570, 32546,
 32520, 32492, 32463, 32433, 32401, 32368, 32334, 32298, 32260, 32222,
 32182, 32140, 32097, 32053, 32007, 31960, 31912, 31862, 31811, 31759,
 31705, 31650, 31594, 31536, 31477, 31417, 31355, 31292, 31228, 31163,
 31096, 31028, 30959, 30889, 30817, 30744, 30670, 30595, 30518, 30441,
 30362, 30282, 30201, 30118, 30035, 29950, 29865, 29778, 29690, 29601,
 29511, 29420, 29328, 29234, 29140, 29045, 28949, 28851, 28753, 28654,
 28553, 28452, 28350, 28247, 28143, 28038, 27932, 27825, 27718, 27609,
 27500, 27390, 27279, 27167, 27055, 26941, 26827, 26712, 26596, 26480,
 26363, 26245, 26127, 26007, 25887, 25767, 25646, 25524, 25401, 25278,
 25155, 25030, 24905, 24780, 24654, 24528, 24401, 24273, 24145, 24017,
 23888, 23758, 23629, 23498, 23368, 23237, 23105, 22973, 22841, 22709,
 22576, 22443, 22309, 22176, 22041, 21907, 21773, 21638, 21503, 21368,
 21232, 21097, 20961, 20825, 20689, 20552, 20416, 20280, 20143, 20006,
 19870, 19733, 19596, 19459, 19322, 19185, 19048, 18911, 18774, 18638,
 18501, 18364, 18227, 18091, 17954, 17818, 17682, 17546, 17410, 17274,
 17138, 17003, 16867, 16732, 16597, 16462, 16328, 16194, 16060, 15926,
 15793, 15659, 15526, 15394, 15262, 15130, 14998, 14867, 14736, 14605,
 14475, 14345, 14215, 14086, 13958, 13829, 13702, 13574, 13447, 13321,
 13194, 13069, 12944, 12819, 12695, 12571, 12448, 12325, 12203, 12081,
 11960, 11839, 11719, 11599, 11480, 11362, 11244, 11127, 11010, 10894,
 10778, 10663, 10549, 10435, 10322, 10209, 10097,  9986,  9875,  9765,
  9656,  9547,  9439,  9331,  9224,  9118,  9013,  8908,  8804,  8700,
  8597,  8495,  8393,  8293,  8193,  8093,  7994,  7896,  7799,  7702,
  7606,  7511,  7416,  7323,  7229,  7137,  7045,  6954,  6864,  6774,
  6685,  6597,  6510,  6423,  6337,  6252,  6167,  6083,  6000,  5918,
  5836,  5755,  5675,  5595,  5517,  5438,  5361,  5284,  5208,  5133,
  5059,  4985,  4912,  4839,  4768,  4697,  4626,  4557,  4488,  4420,
  4352,  4286,  4220,  4154,  4089,  4025,  3962,  3900,  3838,  3776,
  3716,  3656,  3597,  3538,  3480,  3423,  3366,  3310,  3255,  3200,
  3146,  3093,  3040,  2988,  2937,  2886,  2836,  2786,  2737,  2689,
  2641,  2594,  2548,  2502,  2457,  2412,  2368,  2324,  2282,  2239,
  2197,  2156,  2116,  2076,  2036,  1997,  1959,  1921,  1884,  1847,
  1811,  1775,  1740,  1705,  1671,  1637,  1604,  1571,  1539,  1508,
  1476,  1446,  1416,  1386,  1357,  1328,  1299,  1272,  1244,  1217,
  1191,  1165,  1139,  1114,  1089,  1065,  1041,  1017,   994,   971,
   949,   927,   905,   884,   864,   843,   823,   803,   784,   765,
   747,   728,   710,   693,   676,   659,   642,   626,   610,   594,
   579,   564,   549,   535,   521,   507,   494,   480,   467,   455,
   442,   430,   418,   407,   395,   384,   373,   362,   352,   342,
   332,   322,   313,   303,   294,   285,   277,   268,   260,   252,
   244,   237,   229,   222,   215,   208,   201,   194,   188,   182,
   176,   170,   164,   158,   153,   148,   142,   137,   132,   128,
   123,   118,   114,   110,   106,   102,    98,    94,    90,    87,
    83,    80,    77,    73,    70,    67,    64,    62,    59,    56,
    54,    51,    49,    47,    44,    42,    40,    38,    36,    34,
    33,    31,    29,    28,    26,    25,    23,    22,    20,    19,
    18,    17,    16,    15,    14,    13,    12,    11,    10,     9,
     8,     8,     7,     6,     6,     5,     4,     4,     3,     3,
     3,     2,     2,     1,     1,     1,     1,     1,     0,     0,
     0,     0,     0,     0,
};

const int16_t AudioWindowBlackmanNuttall1024[] __attribute__ ((aligned (4))) = {
    12,    12,    12,    12,    12,    12,    13,    13,    13,    14,
    14,    15,    15,    16,    17,    17,    18,    19,    20,    21,
    22,    23,    24,    25,    26,    27,    29,    30,    32,    33,
    35,    36,    38,    40,    42,    44,    45,    48,    50,    52,
    54,    57,    59,    61,    64,    67,    70,    72,    75,    78,
    82,    85,    88,    92,    95,    99,   103,   106,   110,   114,
   119,   123,   127,   132,   137,   141,   146,   151,   157,   162,
   167,   173,   179,   185,   191,   197,   203,   210,   217,   223,
   230,   238,   245,   252,   260,   268,   276,   284,   293,   302,
   310,   319,   329,   338,   348,   358,   368,   378,   389,   400,
   411,   422,   433,   445,   457,   469,   482,   494,   507,   521,
   534,   548,   562,   577,   591,   606,   621,   637,   653,   669,
   685,   702,   719,   736,   754,   772,   791,   809,   828,   848,
   867,   888,   908,   929,   950,   972,   993,  1016,  1038,  1061,
  1085,  1109,  1133,  1158,  1183,  1208,  1234,  1260,  1287,  1314,
  1342,  1370,  1398,  1427,  1457,  1486,  1517,  1547,  1579,  1610,
  1643,  1675,  1708,  1742,  1776,  1811,  1846,  1881,  1917,  1954,
  1991,  2029,  2067,  2106,  2145,  2185,  2225,  2266,  2307,  2349,
  2392,  2435,  2478,  2522,  2567,  2612,  2658,  2705,  2752,  2800,
  2848,  2897,  2946,  2996,  3047,  3098,  3150,  3202,  3255,  3309,
  3363,  3418,  3474,  3530,  3587,  3644,  3703,  3761,  3821,  3881,
  3941,  4003,  4065,  4127,  4191,  4255,  4319,  4385,  4451,  4517,
  4584,  4652,  4721,  4790,  4860,  4931,  5002,  5074,  5147,  5220,
  5295,  5369,  5445,  5521,  5598,  5675,  5753,  5832,  5912,  5992,
  6073,  6154,  6237,  6320,  6403,  6488,  6573,  6659,  6745,  6832,
  6920,  7008,  7097,  7187,  7278,  7369,  7461,  7553,  7647,  7740,
  7835,  7930,  8026,  8123,  8220,  8318,  8416,  8515,  8615,  8716,
  8817,  8919,  9021,  9124,  9228,  9332,  9437,  9542,  9649,  9755,
  9863,  9971, 10079, 10189, 10298, 10409, 10520, 10631, 10744, 10856,
 10970, 11083, 11198, 11313, 11428, 11544, 11661, 11778, 11895, 12013,
 12132, 12251, 12371, 12491, 12612, 12733, 12854, 12976, 13099, 13221,
 13345, 13469, 13593, 13717, 13842, 13968, 14094, 14220, 14346, 14473,
 14601, 14728, 14856, 14985, 15113, 15242, 15372, 15501, 15631, 15761,
 15892, 16022, 16153, 16285, 16416, 16548, 16680, 16812, 16944, 17076,
 17209, 17342, 17475, 17608, 17741, 17874, 18008, 18141, 18275, 18409,
 18543, 18677, 18810, 18944, 19078, 19212, 19346, 19480, 19614, 19748,
 19882, 20016, 20149, 20283, 20417, 20550, 20684, 20817, 20950, 21083,
 21216, 21348, 21481, 21613, 21745, 21876, 22008, 22139, 22270, 22401,
 22531, 22662, 22791, 22921, 23050, 23179, 23307, 23436, 23563, 23691,
 23818, 23944, 24070, 24196, 24321, 24445, 24570, 24693, 24816, 24939,
 25061, 25183, 25304, 25424, 25544, 25663, 25782, 25900, 26017, 26134,
 26250, 26366, 26480, 26594, 26708, 26820, 26932, 27043, 27154, 27263,
 27372, 27480, 27587, 27694, 27799, 27904, 28008, 28111, 28213, 28314,
 28415, 28514, 28613, 28711, 28807, 28903, 28998, 29092, 29185, 29277,
 29367, 29457, 29546, 29634, 29721, 29807, 29891, 29975, 30058, 30139,
 30219, 30299, 30377, 30454, 30530, 30605, 30678, 30751, 30822, 30892,
 30961, 31029, 31095, 31161, 31225, 31288, 31349, 31410, 31469, 31527,
 31584, 31639, 31694, 31747, 31798, 31849, 31898, 31945, 31992, 32037,
 32081, 32123, 32165, 32205, 32243, 32280, 32316, 32351, 32384, 32416,
 32446, 32475, 32503, 32529, 32555, 32578, 32600, 32621, 32641, 32659,
 32676, 32691, 32705, 32718, 32729, 32738, 32747, 32754, 32759, 32764,
 32766, 32767, 32767, 32766, 32764, 32759, 32754, 32747, 32738, 32729,
 32718, 32705, 32691, 32676, 32659, 32641, 32621, 32600, 32578, 32555,
 32529, 32503, 32475, 32446, 32416, 32384, 32351, 32316, 32280, 32243,
 32205, 32165, 32123, 32081, 32037, 31992, 31945, 31898, 31849, 31798,
 31747, 31694, 31639, 31584, 31527, 31469, 31410, 31349, 31288, 31225,
 31161, 31095, 31029, 30961, 30892, 30822, 30751, 30678, 30605, 30530,
 30454, 30377, 30299, 30219, 30139, 30058, 29975, 29891, 29807, 29721,
 29634, 29546, 29457, 29367, 29277, 29185, 29092, 28998, 28903, 28807,
 28711, 28613, 28514, 28415, 28314, 28213, 28111, 28008, 27904, 27799,
 27694, 27587, 27480, 27372, 27263, 27154, 27043, 26932, 26820, 26708,
 26594, 26480, 26366, 26250, 26134, 26017, 25900, 25782, 25663, 25544,
 25424, 25304, 25183, 25061, 24939, 24816, 24693, 24570, 24445, 24321,
 24196, 24070, 23944, 23818, 23691, 23563, 23436, 23307, 23179, 23050,
 22921, 22791, 22662, 22531, 22401, 22270, 22139, 22008, 21876, 21745,
 21613, 21481, 21348, 21216, 21083, 20950, 20817, 20684, 20550, 20417,
 20283, 20149, 20016, 19882, 19748, 19614, 19480, 19346, 19212, 19078,
 18944, 18810, 18677, 18543, 18409, 18275, 18141, 18008, 17874, 17741,
 17608, 17475, 17342, 17209, 17076, 16944, 16812, 16680, 16548, 16416,
 16285, 16153, 16022, 15892, 15761, 15631, 15501, 15372, 15242, 15113,
 14985, 14856, 14728, 14601, 14473, 14346, 14220, 14094, 13968, 13842,
 13717, 13593, 13469, 13345, 13221, 13099, 12976, 12854, 12733, 12612,
 12491, 12371, 12251, 12132, 12013, 11895, 11778, 11661, 11544, 11428,
 11313, 11198, 11083, 10970, 10856, 10744, 10631, 10520, 10409, 10298,
 10189, 10079,  9971,  9863,  9755,  9649,  9542,  9437,  9332,  9228,
  9124,  9021,  8919,  8817,  8716,  8615,  8515,  8416,  8318,  8220,
  8123,  8026,  7930,  7835,  7740,  7647,  7553,  7461,  7369,  7278,
  7187,  7097,  7008,  6920,  6832,  6745,  6659,  6573,  6488,  6403,
  6320,  6237,  6154,  6073,  5992,  5912,  5832,  5753,  5675,  5598,
  5521,  5445,  5369,  5295,  5220,  5147,  5074,  5002,  4931,  4860,
  4790,  4721,  4652,  4584,  4517,  4451,  4385,  4319,  4255,  4191,
  4127,  4065,  4003,  3941,  3881,  3821,  3761,  3703,  3644,  3587,
  3530,  3474,  3418,  3363,  3309,  3255,  3202,  3150,  3098,  3047,
  2996,  2946,  2897,  2848,  2800,  2752,  2705,  2658,  2612,  2567,
  2522,  2478,  2435,  2392,  2349,  2307,  2266,  2225,  2185,  2145,
  2106,  2067,  2029,  1991,  1954,  1917,  1881,  1846,  1811,  1776,
  1742,  1708,  1675,  1643,  1610,  1579,  1547,  1517,  1486,  1457,
  1427,  1398,  1370,  1342,  1314,  1287,  1260,  1234,  1208,  1183,
  1158,  1133,  1109,  1085,  1061,  1038,  1016,   993,   972,   950,
   929,   908,   888,   867,   848,   828,   809,   791,   772,   754,
   736,   719,   702,   685,   669,   653,   637,   621,   606,   591,
   577,   562,   548,   534,   521,   507,   494,   482,   469,   457,
   445,   433,   422,   411,   400,   389,   378,   368,   358,   348,
   338,   329,   319,   310,   302,   293,   284,   276,   268,   260,
   252,   245,   238,   230,   223,   217,   210,   203,   197,   191,
   185,   179,   173,   167,   162,   157,   151,   146,   141,   137,
   132,   127,   123,   119,   114,   110,   106,   103,    99,    95,
    92,    88,    85,    82,    78,    75,    72,    70,    67,    64,
    61,    59,    57,    54,    52,    50,    48,    45,    44,    42,
    40,    38,    36,    35,    33,    32,    30,    29,    27,    26,
    25,    24,    23,    22,    21,    20,    19,    18,    17,    17,
    16,    15,    15,    14,    14,    13,    13,    13,    12,    12,
    12,    12,    12,    12,
};

const int16_t AudioWindowWelch1024[] __attribute__ ((aligned (4))) = {
    64,   192,   319,   446,   573,   700,   827,   953,  1079,  1205,
  1330,  1455,  1580,  1705,  1830,  1954,  2078,  2202,  2325,  2448,
  2571,  2694,  2817,  2939,  3061,  3183,  3304,  3425,  3546,  3667,
  3788,  3908,  4028,  4148,  4267,  4386,  4505,  4624,  4743,  4861,
  4979,  5097,  5214,  5331,  5448,  5565,  5682,  5798,  5914,  6030,
  6145,  6260,  6375,  6490,  6605,  6719,  6833,  6947,  7060,  7173,
  7286,  7399,  7512,  7624,  7736,  7848,  7959,  8070,  8181,  8292,
  8403,  8513,  8623,  8733,  8842,  8951,  9060,  9169,  9278,  9386,
  9494,  9602,  9709,  9816,  9923, 10030, 10137, 10243, 10349, 10455,
 10560, 10665, 10770, 10875, 10980, 11084, 11188, 11292, 11395, 11498,
 11601, 11704, 11807, 11909, 12011, 12113, 12214, 12315, 12416, 12517,
 12618, 12718, 12818, 12918, 13017, 13116, 13215, 13314, 13413, 13511,
 13609, 13707, 13804, 13901, 13998, 14095, 14192, 14288, 14384, 14480,
 14575, 14670, 14765, 14860, 14955, 15049, 15143, 15237, 15330, 15423,
 15516, 15609, 15702, 15794, 15886, 15978, 16069, 16160, 16251, 16342,
 16433, 16523, 16613, 16703, 16792, 16881, 16970, 17059, 17148, 17236,
 17324, 17412, 17499, 17586, 17673, 17760, 17847, 17933, 18019, 18105,
 18190, 18275, 18360, 18445, 18530, 18614, 18698, 18782, 18865, 18948,
 19031, 19114, 19197, 19279, 19361, 19443, 19524, 19605, 19686, 19767,
 19848, 19928, 20008, 20088, 20167, 20246, 20325, 20404, 20483, 20561,
 20639, 20717, 20794, 20871, 20948, 21025, 21102, 21178, 21254, 21330,
 21405, 21480, 21555, 21630, 21705, 21779, 21853, 21927, 22000, 22073,
 22146, 22219, 22292, 22364, 22436, 22508, 22579, 22650, 22721, 22792,
 22863, 22933, 23003, 23073, 23142, 23211, 23280, 23349, 23418, 23486,
 23554, 23622, 23689, 23756, 23823, 23890, 23957, 24023, 24089, 24155,
 24220, 24285, 24350, 24415, 24480, 24544, 24608, 24672, 24735, 24798,
 24861, 24924, 24987, 25049, 25111, 25173, 25234, 25295, 25356, 25417,
 25478, 25538, 25598, 25658, 25717, 25776, 25835, 25894, 25953, 26011,
 26069, 26127, 26184, 26241, 26298, 26355, 26412, 26468, 26524, 26580,
 26635, 26690, 26745, 26800, 26855, 26909, 26963, 27017, 27070, 27123,
 27176, 27229, 27282, 27334, 27386, 27438, 27489, 27540, 27591, 27642,
 27693, 27743, 27793, 27843, 27892, 27941, 27990, 28039, 28088, 28136,
 28184, 28232, 28279, 28326, 28373, 28420, 28467, 28513, 28559, 28605,
 28650, 28695, 28740, 28785, 28830, 28874, 28918, 28962, 29005, 29048,
 29091, 29134, 29177, 29219, 29261, 29303, 29344, 29385, 29426, 29467,
 29508, 29548, 29588, 29628, 29667, 29706, 29745, 29784, 29823, 29861,
 29899, 29937, 29974, 30011, 30048, 30085, 30122, 30158, 30194, 30230,
 30265, 30300, 30335, 30370, 30405, 30439, 30473, 30507, 30540, 30573,
 30606, 30639, 30672, 30704, 30736, 30768, 30799, 30830, 30861, 30892,
 30923, 30953, 30983, 31013, 31042, 31071, 31100, 31129, 31158, 31186,
 31214, 31242, 31269, 31296, 31323, 31350, 31377, 31403, 31429, 31455,
 31480, 31505, 31530, 31555, 31580, 31604, 31628, 31652, 31675, 31698,
 31721, 31744, 31767, 31789, 31811, 31833, 31854, 31875, 31896, 31917,
 31938, 31958, 31978, 31998, 32017, 32036, 32055, 32074, 32093, 32111,
 32129, 32147, 32164, 32181, 32198, 32215, 32232, 32248, 32264, 32280,
 32295, 32310, 32325, 32340, 32355, 32369, 32383, 32397, 32410, 32423,
 32436, 32449, 32462, 32474, 32486, 32498, 32509, 32520, 32531, 32542,
 32553, 32563, 32573, 32583, 32592, 32601, 32610, 32619, 32628, 32636,
 32644, 32652, 32659, 32666, 32673, 32680, 32687, 32693, 32699, 32705,
 32710, 32715, 32720, 32725, 32730, 32734, 32738, 32742, 32745, 32748,
 32751, 32754, 32757, 32759, 32761, 32763, 32764, 32765, 32766, 32767,
 32767, 32767, 32767, 32767, 32767, 32766, 32765, 32764, 32763, 32761,
 32759, 32757, 32754, 32751, 32748, 32745, 32742, 32738, 32734, 32730,
 32725, 32720, 32715, 32710, 32705, 32699, 32693, 32687, 32680, 32673,
 32666, 32659, 32652, 32644, 32636, 32628, 32619, 32610, 32601, 32592,
 32583, 32573, 32563, 32553, 32542, 32531, 32520, 32509, 32498, 32486,
 32474, 32462, 32449, 32436, 32423, 32410, 32397, 32383, 32369, 32355,
 32340, 32325, 32310, 32295, 32280, 32264, 32248, 32232, 32215, 32198,
 32181, 32164, 32147, 32129, 32111, 32093, 32074, 32055, 32036, 32017,
 31998, 31978, 31958, 31938, 31917, 31896, 31875, 31854, 31833, 31811,
 31789, 31767, 31744, 31721, 31698, 31675, 31652, 31628, 31604, 31580,
 31555, 31530, 31505, 31480, 31455, 31429, 31403, 31377, 31350, 31323,
 31296, 31269, 31242, 31214, 31186, 31158, 31129, 31100, 31071, 31042,
 31013, 30983, 30953, 30923, 30892, 30861, 30830, 30799, 30768, 30736,
 30704, 30672, 30639, 30606, 30573, 30540, 30507, 30473, 30439, 30405,
 30370, 30335, 30300, 30265, 30230, 30194, 30158, 30122, 30085, 30048,
 30011, 29974, 29937, 29899, 29861, 29823, 29784, 29745, 29706, 29667,
 29628, 29588, 29548, 29508, 29467, 29426, 29385, 29344, 29303, 29261,
 29219, 29177, 29134, 29091, 29048, 29005, 28962, 28918, 28874, 28830,
 28785, 28740, 28695, 28650, 28605, 28559, 28513, 28467, 28420, 28373,
 28326, 28279, 28232, 28184, 28136, 28088, 28039, 27990, 27941, 27892,
 27843, 27793, 27743, 27693, 27642, 27591, 27540, 27489, 27438, 27386,
 27334, 27282, 27229, 27176, 27123, 27070, 27017, 26963, 26909, 26855,
 26800, 26745, 26690, 26635, 26580, 26524, 26468, 26412, 26355, 26298,
 26241, 26184, 26127, 26069, 26011, 25953, 25894, 25835, 25776, 25717,
 25658, 25598, 25538, 25478, 25417, 25356, 25295, 25234, 25173, 25111,
 25049, 24987, 24924, 24861, 24798, 24735, 24672, 24608, 24544, 24480,
 24415, 24350, 24285, 24220, 24155, 24089, 24023, 23957, 23890, 23823,
 23756, 23689, 23622, 23554, 23486, 23418, 23349, 23280, 23211, 23142,
 23073, 23003, 22933, 22863, 22792, 22721, 22650, 22579, 22508, 22436,
 22364, 22292, 22219, 22146, 22073, 22000, 21927, 21853, 21779, 21705,
 21630, 21555, 21480, 21405, 21330, 21254, 21178, 21102, 21025, 20948,
 20871, 20794, 20717, 20639, 20561, 20483, 20404, 20325, 20246, 20167,
 20088, 20008, 19928, 19848, 19767, 19686, 19605, 19524, 19443, 19361,
 19279, 19197, 19114, 19031, 18948, 18865, 18782, 18698, 18614, 18530,
 18445, 18360, 18275, 18190, 18105, 18019, 17933, 17847, 17760, 17673,
 17586, 17499, 17412, 17324, 17236, 17148, 17059, 16970, 16881, 16792,
 16703, 16613, 16523, 16433, 16342, 16251, 16160, 16069, 15978, 15886,
 15794, 15702, 15609, 15516, 15423, 15330, 15237, 15143, 15049, 14955,
 14860, 14765, 14670, 14575, 14480, 14384, 14288, 14192, 14095, 13998,
 13901, 13804, 13707, 13609, 13511, 13413, 13314, 13215, 13116, 13017,
 12918, 12818, 12718, 12618, 12517, 12416, 12315, 12214, 12113, 12011,
 11909, 11807, 11704, 11601, 11498, 11395, 11292, 11188, 11084, 10980,
 10875, 10770, 10665, 10560, 10455, 10349, 10243, 10137, 10030,  9923,
  9816,  9709,  9602,  9494,  9386,  9278,  9169,  9060,  8951,  8842,
  8733,  8623,  8513,  8403,  8292,  8181,  8070,  7959,  7848,  7736,
  7624,  7512,  7399,  7286,  7173,  7060,  6947,  6833,  6719,  6605,
  6490,  6375,  6260,  6145,  6030,  5914,  5798,  5682,  5565,  5448,
  5331,  5214,  5097,  4979,  4861,  4743,  4624,  4505,  4386,  4267,
  4148,  4028,  3908,  3788,  3667,  3546,  3425,  3304,  3183,  3061,
  2939,  2817,  2694,  2571,  2448,  2325,  2202,  2078,  1954,  1830,
  1705,  1580,  1455,  1330,  1205,  1079,   953,   827,   700,   573,
   446,   319,   192,    64,
};

const int16_t AudioWindowHamming1024[] __attribute__ ((aligned (4))) = {
  2621,  2622,  2623,  2624,  2626,  2629,  2632,  2635,  2640,  2644,
  2650,  2656,  2662,  2669,  2677,  2685,  2694,  2704,  2713,  2724,
  2735,  2747,  2759,  2772,  2785,  2799,  2813,  2828,  2844,  2860,
  2877,  2894,  2912,  2930,  2949,  2968,  2988,  3009,  3030,  3052,
  3074,  3097,  3120,  3144,  3169,  3194,  3219,  3245,  3272,  3299,
  3327,  3355,  3384,  3413,  3443,  3473,  3504,  3536,  3568,  3600,
  3633,  3667,  3701,  3736,  3771,  3807,  3843,  3880,  3917,  3955,
  3993,  4032,  4071,  4111,  4152,  4193,  4234,  4276,  4318,  4361,
  4405,  4449,  4493,  4538,  4583,  4629,  4676,  4723,  4770,  4818,
  4866,  4915,  4964,  5014,  5065,  5115,  5167,  5218,  5270,  5323,
  5376,  5430,  5484,  5538,  5593,  5649,  5705,  5761,  5818,  5875,
  5933,  5991,  6049,  6108,  6168,  6228,  6288,  6349,  6410,  6471,
  6533,  6596,  6659,  6722,  6786,  6850,  6914,  6979,  7044,  7110,
  7176,  7243,  7310,  7377,  7445,  7513,  7581,  7650,  7719,  7789,
  7859,  7929,  8000,  8071,  8142,  8214,  8286,  8359,  8432,  8505,
  8578,  8652,  8727,  8801,  8876,  8951,  9027,  9103,  9179,  9256,
  9332,  9410,  9487,  9565,  9643,  9721,  9800,  9879,  9959, 10038,
 10118, 10198, 10279, 10359, 10440, 10522, 10603, 10685, 10767, 10850,
 10932, 11015, 11098, 11181, 11265, 11349, 11433, 11517, 11602, 11687,
 11772, 11857, 11942, 12028, 12114, 12200, 12286, 12373, 12460, 12547,
 12634, 12721, 12808, 12896, 12984, 13072, 13160, 13249, 13337, 13426,
 13515, 13604, 13693, 13782, 13872, 13961, 14051, 14141, 14231, 14321,
 14412, 14502, 14593, 14683, 14774, 14865, 14956, 15047, 15138, 15229,
 15321, 15412, 15504, 15595, 15687, 15779, 15871, 15963, 16055, 16147,
 16239, 16331, 16423, 16516, 16608, 16700, 16793, 16885, 16978, 17070,
 17163, 17255, 17348, 17440, 17533, 17625, 17718, 17810, 17903, 17996,
 18088, 18181, 18273, 18366, 18458, 18551, 18643, 18735, 18828, 18920,
 19012, 19104, 19197, 19289, 19381, 19473, 19565, 19656, 19748, 19840,
 19931, 20023, 20114, 20206, 20297, 20388, 20479, 20570, 20661, 20752,
 20842, 20933, 21023, 21113, 21203, 21293, 21383, 21473, 21562, 21652,
 21741, 21830, 21919, 22008, 22097, 22185, 22273, 22361, 22449, 22537,
 22625, 22712, 22799, 22886, 22973, 23060, 23146, 23232, 23318, 23404,
 23490, 23575, 23660, 23745, 23830, 23914, 23998, 24082, 24166, 24250,
 24333, 24416, 24499, 24581, 24663, 24745, 24827, 24908, 24990, 25070,
 25151, 25231, 25311, 25391, 25471, 25550, 25629, 25707, 25785, 25863,
 25941, 26018, 26095, 26172, 26249, 26325, 26400, 26476, 26551, 26626,
 26700, 26774, 26848, 26921, 26994, 27067, 27139, 27211, 27283, 27354,
 27425, 27495, 27566, 27635, 27705, 27774, 27842, 27911, 27979, 28046,
 28113, 28180, 28246, 28312, 28378, 28443, 28507, 28572, 28636, 28699,
 28762, 28825, 28887, 28949, 29010, 29071, 29132, 29192, 29251, 29311,
 29369, 29428, 29486, 29543, 29600, 29657, 29713, 29768, 29824, 29878,
 29933, 29986, 30040, 30093, 30145, 30197, 30249, 30300, 30350, 30400,
 30450, 30499, 30547, 30596, 30643, 30690, 30737, 30783, 30829, 30874,
 30919, 30963, 31007, 31050, 31092, 31135, 31176, 31217, 31258, 31298,
 31338, 31377, 31415, 31454, 31491, 31528, 31565, 31601, 31636, 31671,
 31705, 31739, 31773, 31805, 31838, 31869, 31901, 31931, 31962, 31991,
 32020, 32049, 32077, 32104, 32131, 32157, 32183, 32208, 32233, 32257,
 32281, 32304, 32327, 32349, 32370, 32391, 32411, 32431, 32450, 32469,
 32487, 32504, 32521, 32538, 32554, 32569, 32584, 32598, 32611, 32624,
 32637, 32649, 32660, 32671, 32681, 32691, 32700, 32708, 32716, 32724,
 32730, 32737, 32742, 32747, 32752, 32756, 32759, 32762, 32765, 32766,
 32767, 32767, 32767, 32767, 32766, 32765, 32762, 32759, 32756, 32752,
 32747, 32742, 32737, 32730, 32724, 32716, 32708, 32700, 32691, 32681,
 32671, 32660, 32649, 32637, 32624, 32611, 32598, 32584, 32569, 32554,
 32538, 32521, 32504, 32487, 32469, 32450, 32431, 32411, 32391, 32370,
 32349, 32327, 32304, 32281, 32257, 32233, 32208, 32183, 32157, 32131,
 32104, 32077, 32049, 32020, 31991, 31962, 31931, 31901, 31869, 31838,
 31805, 31773, 31739, 31705, 31671, 31636, 31601, 31565, 31528, 31491,
 31454, 31415, 31377, 31338, 31298, 31258, 31217, 31176, 31135, 31092,
 31050, 31007, 30963, 30919, 30874, 30829, 30783, 30737, 30690, 30643,
 30596, 30547, 30499, 30450, 30400, 30350, 30300, 30249, 30197, 30145,
 30093, 30040, 29986, 29933, 29878, 29824, 29768, 29713, 29657, 29600,
 29543, 29486, 29428, 29369, 29311, 29251, 29192, 29132, 29071, 29010,
 28949, 28887, 28825, 28762, 28699, 28636, 28572, 28507, 28443, 28378,
 28312, 28246, 28180, 28113, 28046, 27979, 27911, 27842, 27774, 27705,
 27635, 27566, 27495, 27425, 27354, 27283, 27211, 27139, 27067, 26994,
 26921, 26848, 26774, 26700, 26626, 26551, 26476, 26400, 26325, 26249,
 26172, 26095, 26018, 25941, 25863, 25785, 25707, 25629, 25550, 25471,
 25391, 25311, 25231, 25151, 25070, 24990, 24908, 24827, 24745, 24663,
 24581, 24499, 24416, 24333, 24250, 24166, 24082, 23998, 23914, 23830,
 23745, 23660, 23575, 23490, 23404, 23318, 23232, 23146, 23060, 22973,
 22886, 22799, 22712, 22625, 22537, 22449, 22361, 22273, 22185, 22097,
 22008, 21919, 21830, 21741, 21652, 21562, 21473, 21383, 21293, 21203,
 21113, 21023, 20933, 20842, 20752, 20661, 20570, 20479, 20388, 20297,
 20206, 20114, 20023, 19931, 19840, 19748, 19656, 19565, 19473, 19381,
 19289, 19197, 19104, 19012, 18920, 18828, 18735, 18643, 18551, 18458,
 18366, 18273, 18181, 18088, 17996, 17903, 17810, 17718, 17625, 17533,
 17440, 17348, 17255, 17163, 17070, 16978, 16885, 16793, 16700, 16608,
 16516, 16423, 16331, 16239, 16147, 16055, 15963, 15871, 15779, 15687,
 15595, 15504, 15412, 15321, 15229, 15138, 15047, 14956, 14865, 14774,
 14683, 14593, 14502, 14412, 14321, 14231, 14141, 14051, 13961, 13872,
 13782, 13693, 13604, 13515, 13426, 13337, 13249, 13160, 13072, 12984,
 12896, 12808, 12721, 12634, 12547, 12460, 12373, 12286, 12200, 12114,
 12028, 11942, 11857, 11772, 11687, 11602, 11517, 11433, 11349, 11265,
 11181, 11098, 11015, 10932, 10850, 10767, 10685, 10603, 10522, 10440,
 10359, 10279, 10198, 10118, 10038,  9959,  9879,  9800,  9721,  9643,
  9565,  9487,  9410,  9332,  9256,  9179,  9103,  9027,  8951,  8876,
  8801,  8727,  8652,  8578,  8505,  8432,  8359,  8286,  8214,  8142,
  8071,  8000,  7929,  7859,  7789,  7719,  7650,  7581,  7513,  7445,
  7377,  7310,  7243,  7176,  7110,  7044,  6979,  6914,  6850,  6786,
  6722,  6659,  6596,  6533,  6471,  6410,  6349,  6288,  6228,  6168,
  6108,  6049,  5991,  5933,  5875,  5818,  5761,  5705,  5649,  5593,
  5538,  5484,  5430,  5376,  5323,  5270,  5218,  5167,  5115,  5065,
  5014,  4964,  4915,  4866,  4818,  4770,  4723,  4676,  4629,  4583,
  4538,  4493,  4449,  4405,  4361,  4318,  4276,  4234,  4193,  4152,
  4111,  4071,  4032,  3993,  3955,  3917,  3880,  3843,  3807,  3771,
  3736,  3701,  3667,  3633,  3600,  3568,  3536,  3504,  3473,  3443,
  3413,  3384,  3355,  3327,  3299,  3272,  3245,  3219,  3194,  3169,
  3144,  3120,  3097,  3074,  3052,  3030,  3009,  2988,  2968,  2949,
  2930,  2912,  2894,  2877,  2860,  2844,  2828,  2813,  2799,  2785,
  2772,  2759,  2747,  2735,  2724,  2713,  2704,  2694,  2685,  2677,
  2669,  2662,  2656,  2650,  2644,  2640,  2635,  2632,  2629,  2626,
  2624,  2623,  2622,  2621,
};

const int16_t AudioWindowCosine1024[] __attribute__ ((aligned (4))) = {
     0,   101,   201,   302,   403,   503,   604,   704,   805,   906,
  1006,  1107,  1207,  1308,  1408,  1509,  1609,  1710,  1810,  1911,
  2011,  2112,  2212,  2313,  2413,  2513,  2614,  2714,  2814,  2914,
  3015,  3115,  3215,  3315,  3415,  3515,  3615,  3715,  3815,  3915,
  4015,  4115,  4215,  4314,  4414,  4514,  4614,  4713,  4813,  4912,
  5012,  5111,  5211,  5310,  5409,  5508,  5608,  5707,  5806,  5905,
  6004,  6103,  6201,  6300,  6399,  6498,  6596,  6695,  6793,  6892,
  6990,  7088,  7186,  7285,  7383,  7481,  7579,  7676,  7774,  7872,
  7970,  8067,  8165,  8262,  8359,  8457,  8554,  8651,  8748,  8845,
  8942,  9039,  9135,  9232,  9328,  9425,  9521,  9617,  9713,  9810,
  9905, 10001, 10097, 10193, 10288, 10384, 10479, 10575, 10670, 10765,
 10860, 10955, 11050, 11144, 11239, 11333, 11428, 11522, 11616, 11710,
 11804, 11898, 11992, 12085, 12179, 12272, 12365, 12458, 12551, 12644,
 12737, 12830, 12922, 13015, 13107, 13199, 13291, 13383, 13475, 13567,
 13658, 13749, 13841, 13932, 14023, 14114, 14205, 14295, 14386, 14476,
 14566, 14656, 14746, 14836, 14926, 15015, 15105, 15194, 15283, 15372,
 15461, 15549, 15638, 15726, 15814, 15902, 15990, 16078, 16166, 16253,
 16340, 16428, 16515, 16601, 16688, 16775, 16861, 16947, 17033, 17119,
 17205, 17290, 17376, 17461, 17546, 17631, 17716, 17800, 17885, 17969,
 18053, 18137, 18221, 18304, 18388, 18471, 18554, 18637, 18719, 18802,
 18884, 18966, 19048, 19130, 19212, 19293, 19374, 19455, 19536, 19617,
 19697, 19778, 19858, 19938, 20018, 20097, 20177, 20256, 20335, 20414,
 20492, 20571, 20649, 20727, 20805, 20882, 20960, 21037, 21114, 21191,
 21268, 21344, 21420, 21496, 21572, 21648, 21723, 21799, 21874, 21948,
 22023, 22098, 22172, 22246, 22319, 22393, 22466, 22540, 22613, 22685,
 22758, 22830, 22902, 22974, 23046, 23117, 23188, 23259, 23330, 23401,
 23471, 23541, 23611, 23681, 23750, 23819, 23888, 23957, 24026, 24094,
 24162, 24230, 24297, 24365, 24432, 24499, 24566, 24632, 24698, 24764,
 24830, 24896, 24961, 25026, 25091, 25156, 25220, 25284, 25348, 25412,
 25475, 25538, 25601, 25664, 25726, 25788, 25850, 25912, 25974, 26035,
 26096, 26157, 26217, 26277, 26337, 26397, 26457, 26516, 26575, 26634,
 26692, 26750, 26808, 26866, 26923, 26981, 27038, 27094, 27151, 27207,
 27263, 27319, 27374, 27429, 27484, 27539, 27593, 27648, 27701, 27755,
 27808, 27861, 27914, 27967, 28019, 28071, 28123, 28175, 28226, 28277,
 28327, 28378, 28428, 28478, 28528, 28577, 28626, 28675, 28724, 28772,
 28820, 28868, 28915, 28962, 29009, 29056, 29102, 29148, 29194, 29240,
 29285, 29330, 29375, 29419, 29463, 29507, 29551, 29594, 29637, 29680,
 29723, 29765, 29807, 29848, 29890, 29931, 29972, 30012, 30053, 30093,
 30132, 30172, 30211, 30250, 30288, 30326, 30364, 30402, 30439, 30477,
 30513, 30550, 30586, 30622, 30658, 30693, 30728, 30763, 30798, 30832,
 30866, 30899, 30933, 30966, 30999, 31031, 31063, 31095, 31127, 31158,
 31189, 31220, 31250, 31280, 31310, 31340, 31369, 31398, 31426, 31455,
 31483, 31511, 31538, 31565, 31592, 31619, 31645, 31671, 31697, 31722,
 31747, 31772, 31796, 31820, 31844, 31868, 31891, 31914, 31937, 31959,
 31981, 32003, 32024, 32046, 32067, 32087, 32107, 32127, 32147, 32166,
 32185, 32204, 32223, 32241, 32258, 32276, 32293, 32310, 32327, 32343,
 32359, 32375, 32390, 32405, 32420, 32434, 32449, 32462, 32476, 32489,
 32502, 32515, 32527, 32539, 32551, 32562, 32573, 32584, 32595, 32605,
 32615, 32624, 32634, 32643, 32651, 32660, 32668, 32675, 32683, 32690,
 32697, 32703, 32709, 32715, 32721, 32726, 32731, 32736, 32740, 32744,
 32748, 32751, 32754, 32757, 32759, 32761, 32763, 32765, 32766, 32767,
 32767, 32767, 32767, 32767, 32767, 32766, 32765, 32763, 32761, 32759,
 32757, 32754, 32751, 32748, 32744, 32740, 32736, 32731, 32726, 32721,
 32715, 32709, 32703, 32697, 32690, 32683, 32675, 32668, 32660, 32651,
 32643, 32634, 32624, 32615, 32605, 32595, 32584, 32573, 32562, 32551,
 32539, 32527, 32515, 32502, 32489, 32476, 32462, 32449, 32434, 32420,
 32405, 32390, 32375, 32359, 32343, 32327, 32310, 32293, 32276, 32258,
 32241, 32223, 32204, 32185, 32166, 32147, 32127, 32107, 32087, 32067,
 32046, 32024, 32003, 31981, 31959, 31937, 31914, 31891, 31868, 31844,
 31820, 31796, 31772, 31747, 31722, 31697, 31671, 31645, 31619, 31592,
 31565, 31538, 31511, 31483, 31455, 31426, 31398, 31369, 31340, 31310,
 31280, 31250, 31220, 31189, 31158, 31127, 31095, 31063, 31031, 30999,
 30966, 30933, 30899, 30866, 30832, 30798, 30763, 30728, 30693, 30658,
 30622, 30586, 30550, 30513, 30477, 30439, 30402, 30364, 30326, 30288,
 30250, 30211, 30172, 30132, 30093, 30053, 30012, 29972, 29931, 29890,
 29848, 29807, 29765, 29723, 29680, 29637, 29594, 29551, 29507, 29463,
 29419, 29375, 29330, 29285, 29240, 29194, 29148, 29102, 29056, 29009,
 28962, 28915, 28868, 28820, 28772, 28724, 28675, 28626, 28577, 28528,
 28478, 28428, 28378, 28327, 28277, 28226, 28175, 28123, 28071, 28019,
 27967, 27914, 27861, 27808, 27755, 27701, 27648, 27593, 27539, 27484,
 27429, 27374, 27319, 27263, 27207, 27151, 27094, 27038, 26981, 26923,
 26866, 26808, 26750, 26692, 26634, 26575, 26516, 26457, 26397, 26337,
 26277, 26217, 26157, 26096, 26035, 25974, 25912, 25850, 25788, 25726,
 25664, 25601, 25538, 25475, 25412, 25348, 25284, 25220, 25156, 25091,
 25026, 24961, 24896, 24830, 24764, 24698, 24632, 24566, 24499, 24432,
 24365, 24297, 24230, 24162, 24094, 24026, 23957, 23888, 23819, 23750,
 23681, 23611, 23541, 23471, 23401, 23330, 23259, 23188, 23117, 23046,
 22974, 22902, 22830, 22758, 22685, 22613, 22540, 22466, 22393, 22319,
 22246, 22172, 22098, 22023, 21948, 21874, 21799, 21723, 21648, 21572,
 21496, 21420, 21344, 21268, 21191, 21114, 21037, 20960, 20882, 20805,
 20727, 20649, 20571, 20492, 20414, 20335, 20256, 20177, 20097, 20018,
 19938, 19858, 19778, 19697, 19617, 19536, 19455, 19374, 19293, 19212,
 19130, 19048, 18966, 18884, 18802, 18719, 18637, 18554, 18471, 18388,
 18304, 18221, 18137, 18053, 17969, 17885, 17800, 17716, 17631, 17546,
 17461, 17376, 17290, 17205, 17119, 17033, 16947, 16861, 16775, 16688,
 16601, 16515, 16428, 16340, 16253, 16166, 16078, 15990, 15902, 15814,
 15726, 15638, 15549, 15461, 15372, 15283, 15194, 15105, 15015, 14926,
 14836, 14746, 14656, 14566, 14476, 14386, 14295, 14205, 14114, 14023,
 13932, 13841, 13749, 13658, 13567, 13475, 13383, 13291, 13199, 13107,
 13015, 12922, 12830, 12737, 12644, 12551, 12458, 12365, 12272, 12179,
 12085, 11992, 11898, 11804, 11710, 11616, 11522, 11428, 11333, 11239,
 11144, 11050, 10955, 10860, 10765, 10670, 10575, 10479, 10384, 10288,
 10193, 10097, 10001,  9905,  9810,  9713,  9617,  9521,  9425,  9328,
  9232,  9135,  9039,  8942,  8845,  8748,  8651,  8554,  8457,  8359,
  8262,  8165,  8067,  7970,  7872,  7774,  7676,  7579,  7481,  7383,
  7285,  7186,  7088,  6990,  6892,  6793,  6695,  6596,  6498,  6399,
  6300,  6201,  6103,  6004,  5905,  5806,  5707,  5608,  5508,  5409,
  5310,  5211,  5111,  5012,  4912,  4813,  4713,  4614,  4514,  4414,
  4314,  4215,  4115,  4015,  3915,  3815,  3715,  3615,  3515,  3415,
  3315,  3215,  3115,  3015,  2914,  2814,  2714,  2614,  2513,  2413,
  2313,  2212,  2112,  2011,  1911,  1810,  1710,  1609,  1509,  1408,
  1308,  1207,  1107,  1006,   906,   805,   704,   604,   503,   403,
   302,   201,   101,     0,
};

const int16_t AudioWindowTukey1024[] __attribute__ ((aligned (4))) = {
     0,     1,     5,    11,    20,    31,    44,    61,    79,   100,
   123,   149,   178,   208,   242,   277,   315,   356,   399,   444,
   492,   542,   595,   650,   707,   767,   829,   893,   960,  1029,
  1100,  1174,  1250,  1328,  1408,  1491,  1576,  1663,  1753,  1844,
  1938,  2034,  2133,  2233,  2335,  2440,  2547,  2656,  2766,  2879,
  2994,  3111,  3230,  3351,  3474,  3599,  3726,  3855,  3985,  4118,
  4252,  4388,  4526,  4666,  4808,  4951,  5096,  5243,  5391,  5541,
  5693,  5846,  6001,  6158,  6316,  6475,  6636,  6799,  6962,  7128,
  7295,  7463,  7632,  7803,  7975,  8148,  8323,  8499,  8676,  8854,
  9033,  9214,  9395,  9578,  9761,  9946, 10132, 10318, 10505, 10694,
 10883, 11073, 11264, 11455, 11648, 11841, 12034, 12229, 12424, 12619,
 12815, 13012, 13209, 13407, 13605, 13804, 14003, 14202, 14401, 14601,
 14802, 15002, 15203, 15403, 15604, 15806, 16007, 16208, 16409, 16610,
 16812, 17013, 17214, 17415, 17616, 17816, 18017, 18217, 18416, 18616,
 18815, 19014, 19213, 19411, 19608, 19805, 20002, 20198, 20393, 20588,
 20782, 20976, 21169, 21361, 21552, 21743, 21932, 22121, 22309, 22497,
 22683, 22868, 23053, 23236, 23418, 23599, 23780, 23959, 24136, 24313,
 24489, 24663, 24836, 25008, 25178, 25347, 25515, 25682, 25847, 26010,
 26172, 26333, 26492, 26650, 26806, 26960, 27113, 27265, 27414, 27562,
 27708, 27853, 27996, 28137, 28276, 28414, 28550, 28683, 28815, 28946,
 29074, 29200, 29325, 29447, 29568, 29686, 29803, 29917, 30029, 30140,
 30248, 30354, 30458, 30560, 30660, 30758, 30853, 30947, 31038, 31127,
 31213, 31298, 31380, 31460, 31538, 31613, 31686, 31757, 31825, 31891,
 31955, 32017, 32076, 32132, 32187, 32239, 32288, 32335, 32380, 32422,
 32462, 32500, 32535, 32567, 32598, 32625, 32651, 32673, 32694, 32712,
 32727, 32740, 32751, 32759, 32764, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32764,
 32759, 32751, 32740, 32727, 32712, 32694, 32673, 32651, 32625, 32598,
 32567, 32535, 32500, 32462, 32422, 32380, 32335, 32288, 32239, 32187,
 32132, 32076, 32017, 31955, 31891, 31825, 31757, 31686, 31613, 31538,
 31460, 31380, 31298, 31213, 31127, 31038, 30947, 30853, 30758, 30660,
 30560, 30458, 30354, 30248, 30140, 30029, 29917, 29803, 29686, 29568,
 29447, 29325, 29200, 29074, 28946, 28815, 28683, 28550, 28414, 28276,
 28137, 27996, 27853, 27708, 27562, 27414, 27265, 27113, 26960, 26806,
 26650, 26492, 26333, 26172, 26010, 25847, 25682, 25515, 25347, 25178,
 25008, 24836, 24663, 24489, 24313, 24136, 23959, 23780, 23599, 23418,
 23236, 23053, 22868, 22683, 22497, 22309, 22121, 21932, 21743, 21552,
 21361, 21169, 20976, 20782, 20588, 20393, 20198, 20002, 19805, 19608,
 19411, 19213, 19014, 18815, 18616, 18416, 18217, 18017, 17816, 17616,
 17415, 17214, 17013, 16812, 16610, 16409, 16208, 16007, 15806, 15604,
 15403, 15203, 15002, 14802, 14601, 14401, 14202, 14003, 13804, 13605,
 13407, 13209, 13012, 12815, 12619, 12424, 12229, 12034, 11841, 11648,
 11455, 11264, 11073, 10883, 10694, 10505, 10318, 10132,  9946,  9761,
  9578,  9395,  9214,  9033,  8854,  8676,  8499,  8323,  8148,  7975,
  7803,  7632,  7463,  7295,  7128,  6962,  6799,  6636,  6475,  6316,
  6158,  6001,  5846,  5693,  5541,  5391,  5243,  5096,  4951,  4808,
  4666,  4526,  4388,  4252,  4118,  3985,  3855,  3726,  3599,  3474,
  3351,  3230,  3111,  2994,  2879,  2766,  2656,  2547,  2440,  2335,
  2233,  2133,  2034,  1938,  1844,  1753,  1663,  1576,  1491,  1408,
  1328,  1250,  1174,  1100,  1029,   960,   893,   829,   767,   707,
   650,   595,   542,   492,   444,   399,   356,   315,   277,   242,
   208,   178,   149,   123,   100,    79,    61,    44,    31,    20,
    11,     5,     1,     0,
};


/*
#! /usr/bin/perl

# http://en.wikipedia.org/wiki/Window_function

use Math::Trig ':pi';
$len = 256;

for ($i=0; $i < $len; $i++) {

	$name = "Hanning";
	$val = 0.5 * (1 - cos(2 * pi * $i / ($len -1)));

	#$name = "Bartlett";
	#$val = 1 - abs(($i - ($len - 1) / 2) / ($len / 2));

	#$name = "Blackman";
	#$a0 = (1 - 0.16) / 2;
	#$a1 = 0.5;
	#$a2 = 0.16 / 2;
	#$val = $a0 - $a1 * cos(2 * pi * $i / ($len -1)) + $a2 * cos(4 * pi * $i / ($len -1));

	#$name = "Flattop";
	#$a0 = 1;
	#$a1 = 1.93;
	#$a2 = 1.29;
	#$a3 = 0.388;
	#$a4 = 0.028;
	#$max = $a0 - $a1 * cos(pi) + $a2 * cos(2 * pi) - $a3 * cos(3 * pi) + $a4 * cos(4 * pi) ;
	#$val = $a0 - $a1 * cos(2 * pi * $i / ($len -1)) + $a2 * cos(4 * pi * $i / ($len -1));
	#$val += -1 * $a3 * cos(6 * pi * $i / ($len -1)) + $a4 * cos(8 * pi * $i / ($len -1));
	#$val /= $max;

	#$name = "BlackmanHarris";
	#$a0 = 0.35875;
	#$a1 = 0.48829;
	#$a2 = 0.14128;
	#$a3 = 0.01168;
	#$a4 = 0;
	#$val = $a0 - $a1 * cos(2 * pi * $i / ($len -1)) + $a2 * cos(4 * pi * $i / ($len -1));
	#$val += -1 * $a3 * cos(6 * pi * $i / ($len -1)) + $a4 * cos(8 * pi * $i / ($len -1));

	#$name = "Nuttall";
	#$a0 = 0.355768;
	#$a1 = 0.487396;
	#$a2 = 0.144232;
	#$a3 = 0.012604;
	#$a4 = 0;
	#$val = $a0 - $a1 * cos(2 * pi * $i / ($len -1)) + $a2 * cos(4 * pi * $i / ($len -1));
	#$val += -1 * $a3 * cos(6 * pi * $i / ($len -1)) + $a4 * cos(8 * pi * $i / ($len -1));

	#$name = "BlackmanNuttall";
	#$a0 = 0.3635819;
	#$a1 = 0.4891775;
	#$a2 = 0.1365995;
	#$a3 = 0.0106411;
	#$a4 = 0;
	#$val = $a0 - $a1 * cos(2 * pi * $i / ($len -1)) + $a2 * cos(4 * pi * $i / ($len -1));
	#$val += -1 * $a3 * cos(6 * pi * $i / ($len -1)) + $a4 * cos(8 * pi * $i / ($len -1));

	#$name = "Welch";
	#$val = 1 - (($i - ($len - 1) / 2) / ($len / 2)) ** 2;

	#$name = "Hamming";
	#$val = 0.54 - 0.46 * cos(2 * pi * $i / ($len -1));

	#$name = "Cosine";
	#$val = cos((pi * $i / ($len -1)) - (pi / 2));

	#$name = "Tukey";
	#$a = 0.5;
	#if ($i <= ($a * ($len - 1) / 2)) {
	#	$val = 0.5 * (1 + cos(pi * ((2 * $i / ($a * ($len - 1))) - 1)));
	#} elsif ($i < (($len - 1) * (1 - $a / 2))) {
	#	$val = 0.99999;
	#} else {
	#	$val = 0.5 * (1 + cos(pi * ((2 * $i / ($a * ($len - 1))) - (2 / $a) + 1)));
	#}

	#$name = "KaiserBessel";
	# TODO: what is the full equation, with the "zero-th order modified Bessel function"?

	$n = int($val * 32768 + 0.5);
	$n = 32767 if $n > 32767;

	if (0) {
		print $i;
		print "\t";
		printf "%9.6f", $val;
		print "\t";
		print $n;
		print "\n";
	} else {
		if ($i == 0) {
			print "const int16_t AudioWindow${name}${len}[] __attribute__ ((aligned (4))) = {\n";
		}
		printf "%6d", $n;
		print "," if ($i < $len);
		print "\n" if ($i % 10) == 9;
	}
}
print "\n" unless ($len % 10) == 9;
print "};\n";
*/
