#include "FrenchHorns_samples.h"
const AudioSynthWavetable::sample_data FrenchHorns_samples[1] = {
	{
		(int16_t*)sample_0_FrenchHorns_FrenchHornsA4L,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		17,	//Number of bits needed to hold length
		(32768*1.0*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 220.0 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)109900-1) << (32 - 17),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)109887-1) << (32 - 17),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)109887-1) << (32 - 17)) - (((uint32_t)30531-1) << (32 - 17)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(600*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(0 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(0/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(0/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_FrenchHorns_FrenchHornsA4L[55040] = {
0xfffefffd,0xfffdfffd,0xfffdfffd,0xfffefffe,0xfffdfffd,0xfffdfffe,0xfffdfffe,0xfffdfffd,
0xfffcfffe,0xfffefffe,0xfffcfffe,0xfffdfffe,0xfffdfffe,0xfffdfffe,0xfffefffd,0xfffdfffc,
0xfffefffe,0xfffffffd,0xfffefffc,0xfffefffc,0xfffdfffc,0xfffefffd,0xfffdfffd,0xfffdfffe,
0xfffdfffc,0xfffefffd,0xfffdfffd,0xfffefffe,0xfffdfffe,0xfffcfffd,0xfffdfffe,0xfffdfffd,
0xfffdfffd,0xfffefffe,0xfffdfffd,0xfffdfffe,0xfffefffd,0xfffdfffe,0xfffefffd,0xfffdfffd,
0xfffdfffe,0xfffefffe,0xfffcfffe,0xfffcfffe,0xfffdfffe,0xfffdfffe,0xfffdfffd,0xfffdfffd,
0xfffdfffe,0xfffdfffd,0xfffdfffd,0xfffdfffd,0xfffefffd,0xfffdfffd,0xfffdfffe,0xfffdfffd,
0xfffdfffc,0xfffefffc,0xfffefffd,0xfffdfffe,0xfffdfffe,0xfffefffd,0xfffefffd,0xfffefffc,
0xfffffffc,0x0003fffa,0x001c0024,0x0019001e,0x001e001b,0x00330025,0x00630044,0x00ad0089,
0x00ea00ce,0x011c0105,0x0134012b,0x01310135,0x0121012a,0x01080119,0x00e300f6,0x00b700d3,
0x00700097,0x001c0047,0xffc1ffee,0xff64ff91,0xff11ff38,0xfec9feea,0xfe8efeaa,0xfe63fe76,
0xfe49fe55,0xfe38fe3e,0xfe38fe34,0xfe45fe3f,0xfe5efe50,0xfe86fe70,0xfeb4fe9e,0xfeeafece,
0xff24ff06,0xff57ff3c,0xff87ff70,0xffaaff99,0xffcdffbe,0xffebffdd,0x0009fffa,0x002c001a,
0x004e003f,0x0068005b,0x00770070,0x006e0073,0x005d0068,0x00490053,0x0033003c,0x001b0026,
0xfffd000d,0xffdaffec,0xffb3ffc7,0xff84ff9a,0xff52ff6a,0xff23ff3a,0xfef5ff0c,0xfed3fee3,
0xfeb6fec1,0xfe9ffeaa,0xfe96fe99,0xfe8efe90,0xfe95fe8f,0xfeaafe9e,0xfec9feb8,0xfefafee0,
0xff2dff13,0xff6cff4c,0xffb3ff8d,0x0001ffdb,0x0061002f,0x00c60092,0x012500f5,0x017e0156,
0x01cc01a6,0x020a01ef,0x02360220,0x024f0246,0x02500253,0x0240024a,0x0213022d,0x01da01fb,
0x019401b6,0x0147016f,0x00f70120,0x00b000d6,0x0068008a,0x002c0047,0xfff90013,0xffd3ffe3,
0xffc1ffc8,0xffc2ffc1,0xffd1ffc6,0xfff2ffdf,0x00230009,0x00620041,0x00a60086,0x00ea00c9,
0x012c010d,0x016a0149,0x01a40188,0x01d101bb,0x01f201e3,0x020d0201,0x021f0218,0x02220223,
0x021a0220,0x02080213,0x01f401ff,0x01dd01e9,0x01cc01d4,0x01c401c4,0x01c201c3,0x01c601c6,
0x01c501c5,0x01c201c3,0x01b401bb,0x019601a8,0x01750186,0x0141015f,0x00f7011e,0x009c00cd,
0x00230063,0xff93ffde,0xfefdff48,0xfe5ffeae,0xfdd4fe15,0xfd59fd96,0xfcfefd25,0xfcd1fce4,
0xfcc4fcca,0xfcbffcbe,0xfcdafccc,0xfd06fcef,0xfd27fd1a,0xfd3dfd33,0xfd41fd3e,0xfd44fd46,
0xfd26fd36,0xfcedfd12,0xfc8cfcbf,0xfc10fc4e,0xfb8ffbd1,0xfaf9fb47,0xfa66faac,0xf9d9fa1f,
0xf95af995,0xf8f0f924,0xf8abf8c9,0xf87ef895,0xf86ff873,0xf86bf86a,0xf87ff872,0xf89ff891,
0xf8c9f8b6,0xf8e8f8d7,0xf911f8f7,0xf951f92f,0xf9a6f977,0xfa16f9da,0xfa98fa54,0xfb3efae8,
0xfbf7fb94,0xfccefc62,0xfdbcfd42,0xfec9fe3e,0xffefff5c,0x013c008f,0x029e01ed,0x03fd034e,
0x055704ad,0x068205f1,0x07810706,0x084807ed,0x08cf0891,0x092008fb,0x0925092d,0x08e10909,
0x087808b4,0x07d1082a,0x07190776,0x065a06bd,0x058c05ee,0x04d9052f,0x042c0484,0x039703dd,
0x03170354,0x02b302e2,0x02750291,0x024d025f,0x02410242,0x024c0244,0x02680257,0x0291027e,
0x02bd02a7,0x02ee02d5,0x032b030c,0x0369034b,0x038c037f,0x0387038c,0x036a037e,0x03200349,
0x02b702f2,0x02250270,0x017401d3,0x00960108,0xffa40021,0xfe96ff20,0xfd7efe0d,0xfc69fcf1,
0xfb6dfbe5,0xfa8ffafb,0xf9c4fa25,0xf919f96a,0xf884f8ca,0xf811f845,0xf7c7f7e8,0xf7a5f7b4,
0xf7a5f7a0,0xf7c3f7b0,0xf80ef7e2,0xf882f83e,0xf916f8cb,0xf9b5f95f,0xfa69fa14,0xfb1afac0,
0xfbc8fb73,0xfc6afc1d,0xfd0efcbb,0xfdb7fd61,0xfe66fe12,0xff18fec0,0xffc8ff73,0x00600018,
0x00d7009c,0x01290107,0x01530141,0x014e0156,0x01090135,0x008500cc,0xffdb0034,0xff17ff7d,
0xfe31fea8,0xfd32fdb4,0xfc31fcaf,0xfb2afbaf,0xfa3ffab0,0xf970f9d5,0xf8c8f916,0xf84bf881,
0xf7fdf81c,0xf7d0f7e3,0xf7cbf7c7,0xf7f1f7d9,0xf844f818,0xf8c0f87b,0xf979f914,0xfa5df9e6,
0xfb6ffae1,0xfca0fc0b,0xfde6fd3d,0xff42fe90,0x00abfff6,0x02040157,0x035902b0,0x04ab0403,
0x05fb0553,0x0732069c,0x083c07be,0x091808ae,0x09c30978,0x0a2f09ff,0x0a720a5b,0x0a6d0a76,
0x0a290a56,0x09ad09f1,0x08eb0955,0x07f40875,0x06d00766,0x05950637,0x045304f0,0x030a03b0,
0x01cd026b,0x00ae013c,0xffb8002b,0xfee3ff4b,0xfe3ffe89,0xfdc8fe00,0xfd67fd8e,0xfd43fd55,
0xfd41fd3b,0xfd5ffd4a,0xfda8fd7f,0xfe13fddb,0xfe98fe53,0xff41feea,0xffedff97,0x00a8004a,
0x0173010b,0x024101de,0x030c02a5,0x03b10369,0x041303ea,0x0430042e,0x03ec0419,0x036003b1,
0x028202f7,0x014e01f5,0xffdc0099,0xfe36ff0f,0xfc7cfd55,0xfac2fb9e,0xf91ef9ed,0xf791f84f,
0xf640f6e1,0xf532f5ad,0xf460f4bf,0xf3e5f41a,0xf39af3bb,0xf388f38b,0xf3bcf399,0xf41ff3e4,
0xf4c7f468,0xf5a1f531,0xf6a3f61d,0xf7c6f72e,0xf90af865,0xfa49f9ae,0xfb86fae7,0xfcc1fc24,
0xfe09fd64,0xff35fe9f,0x0062ffd0,0x017100ee,0x026a01f4,0x033302d8,0x03cf0382,0x04420412,
0x04840465,0x047d048b,0x044b0469,0x03e2041d,0x035a039f,0x02ba0310,0x01fa025a,0x012c0195,
0x005800c5,0xff74ffe7,0xfea1ff08,0xfde1fe40,0xfd25fd80,0xfc84fcce,0xfbfdfc3f,0xfb9bfbc7,
0xfb79fb82,0xfb7afb76,0xfb8ffb84,0xfbc1fba3,0xfc00fbdf,0xfc43fc1c,0xfcaafc73,0xfd2bfce9,
0xfdd0fd7b,0xfea2fe34,0xffa3ff1c,0x00da0037,0x02410188,0x03ae02f7,0x0532046c,0x06ab05f1,
0x080b0760,0x094e08b1,0x0a5d09df,0x0b250ac7,0x0ba20b6e,0x0bcb0bc0,0x0ba80bc6,0x0b4a0b82,
0x0a9e0af9,0x09bc0a31,0x08c40945,0x07bc0842,0x06ad0734,0x05b2062c,0x04cd0539,0x0410046b,
0x039003cc,0x033c0360,0x031f0328,0x03260323,0x03270329,0x0334032c,0x032a0334,0x03170320,
0x0301030b,0x02d602f3,0x029e02ba,0x026a0284,0x02190244,0x01d701fb,0x017901ab,0x0123014f,
0x00a500e9,0x0016005e,0xff66ffc7,0xfe79fef8,0xfd5cfdf4,0xfc04fcb8,0xfa83fb4a,0xf8def9b1,
0xf728f80a,0xf56bf645,0xf3c1f492,0xf22af2f1,0xf0b5f16d,0xef66f008,0xee38eece,0xed3dedad,
0xec92ecdf,0xec23ec4e,0xec16ec14,0xec4fec25,0xecd8ec8a,0xeda6ed37,0xeeb3ee24,0xeff5ef53,
0xf175f0ad,0xf313f245,0xf4c4f3e7,0xf685f5a3,0xf856f768,0xfa4df94d,0xfc53fb50,0xfe59fd53,
0x0060ff5c,0x02630162,0x0448035d,0x06070528,0x07a106d8,0x0909085f,0x0a2e09a4,0x0b150aab,
0x0ba40b66,0x0be00bc9,0x0bce0be2,0x0b5b0ba5,0x0a7b0af5,0x094d09ed,0x07e3089c,0x06500720,
0x04940579,0x02be03aa,0x00d801cb,0xfef5ffe8,0xfd21fe04,0xfb6ffc42,0xf9ecfaa4,0xf8abf942,
0xf7a8f822,0xf6f9f743,0xf6adf6c6,0xf6d0f6b4,0xf76bf70d,0xf869f7e2,0xf9b4f905,0xfb3ffa6f,
0xfceefc13,0xfeb8fdd3,0x008eff9f,0x026a017b,0x04370354,0x0602051e,0x07af06d5,0x0959088d,
0x0adf0a21,0x0c440b98,0x0d970cee,0x0eb30e2b,0x0f960f30,0x102f0fe7,0x107d1066,0x10701080,
0x10151049,0x0f610fca,0x0e4c0ee1,0x0d0e0dac,0x0bdb0c78,0x0a990b39,0x099c0a11,0x08f70942,
0x087b08b2,0x0849085e,0x080a0828,0x07e107f7,0x07ab07c8,0x074d0782,0x06d3070e,0x063d068e,
0x059505ed,0x04e0053f,0x04050477,0x03240392,0x025c02bc,0x018f01f4,0x00a7011d,0xffaf002f,
0xfe9eff27,0xfd61fe06,0xfc07fcb9,0xfa69fb41,0xf882f980,0xf652f772,0xf403f52a,0xf193f2cb,
0xef22f058,0xecd2edf8,0xeab5ebbe,0xe8c8e9b6,0xe71ae7e8,0xe5b1e65c,0xe49fe51d,0xe3ece437,
0xe399e3b4,0xe3bbe398,0xe474e401,0xe5abe505,0xe77ee681,0xe9c5e896,0xec87eb19,0xefbeee17,
0xf357f17e,0xf71ef539,0xfaf5f908,0xfec4fcde,0x027400a4,0x05e30438,0x08d9076d,0x0b400a1e,
0x0d190c3f,0x0e5b0dca,0x0f1f0ed0,0x0f5c0f53,0x0f200f4b,0x0e680ed4,0x0d2c0ddb,0x0b8b0c63,
0x099a0a9b,0x077b0896,0x05290654,0x02da0401,0x008901ac,0xfe60ff71,0xfc5ffd5d,0xfa85fb6b,
0xf8d7f9a7,0xf758f812,0xf629f6b5,0xf559f5b1,0xf4f0f518,0xf527f4fb,0xf5eaf576,0xf74af685,
0xf92cf82d,0xfb7bfa44,0xfe14fcc2,0x00c1ff69,0x03770220,0x060004c2,0x08540734,0x0a4e095c,
0x0bf30b31,0x0d250c98,0x0e070da2,0x0e870e52,0x0ebf0eae,0x0ea70ebb,0x0e610e89,0x0ddb0e24,
0x0d4a0d92,0x0caf0cfc,0x0c1c0c64,0x0b8d0bd3,0x0ae80b41,0x0a0e0a7e,0x09070990,0x07de0877,
0x0692073c,0x054705ee,0x040104a6,0x02cd035f,0x01eb0251,0x016e0197,0x016f0163,0x01f4019d,
0x03080270,0x046203b1,0x05db0516,0x0755069b,0x08a10801,0x09c40937,0x0adb0a4f,0x0bcf0b55,
0x0c9b0c40,0x0cfa0cdd,0x0cd30cf7,0x0c1a0c91,0x0ab30b7e,0x088909bc,0x0587071b,0x01df03c4,
0xfde1ffe6,0xf9bbfbd3,0xf589f7a2,0xf16cf379,0xed49ef5d,0xe93feb3c,0xe574e752,0xe202e3b0,
0xdf0ee075,0xdcadddce,0xdaf4dbb9,0xd9d1da51,0xd948d973,0xd976d949,0xda70d9d9,0xdc32db3a,
0xde9cdd51,0xe1c0e017,0xe593e395,0xea14e7be,0xef38ec92,0xf4f8f208,0xfb1df807,0x015ffe3d,
0x07b0048c,0x0d920ab1,0x12d7104b,0x173c1525,0x1a961911,0x1cd51bd4,0x1e351da3,0x1ed81ea0,
0x1e871ed0,0x1d461e02,0x1b311c53,0x183a19d9,0x144a165e,0x0fcd1213,0x0b010d70,0x05fe0888,
0x00fb0375,0xfc32fe8b,0xf7c6f9f2,0xf3f3f5c9,0xf0c9f243,0xee6aef81,0xecdded8a,0xec15ec63,
0xebf6ebeb,0xec87ec29,0xedc5ed0f,0xef98ee99,0xf1f7f0bc,0xf4b2f34f,0xf7a3f61f,0xfab1f924,
0xfdbafc3a,0x00baff41,0x0361021e,0x05c00496,0x07cf06dc,0x096108a3,0x0a970a0c,0x0b630b04,
0x0be10bb1,0x0bdc0bec,0x0b830bbf,0x0ad60b32,0x09f00a68,0x08e0096e,0x07b30847,0x06840721,
0x054d05e4,0x041004af,0x02c90370,0x01590215,0xffd7009e,0xfe44ff0f,0xfcb3fd75,0xfb63fc0b,
0xfa66fad7,0xf9c4fa03,0xf9bef9ab,0xfa5bf9f5,0xfbc9faf8,0xfdeffcca,0x0097ff32,0x03b3021a,
0x06e00547,0x0a0b0879,0x0d080b95,0x0f940e58,0x11bd10b9,0x138312ae,0x14ad142a,0x15441510,
0x15401551,0x14c11514,0x1381143a,0x119b12a5,0x0f101064,0x0bf60d94,0x085c0a35,0x043e0661,
0xff8901ef,0xfa9cfd14,0xf572f80e,0xf065f2e2,0xebb5ee01,0xe771e982,0xe3c1e583,0xe0cae22f,
0xde91df94,0xdd11ddb4,0xdc4adc97,0xdc5ddc37,0xdd35dcb1,0xdef0ddf4,0xe19ae028,0xe536e347,
0xe9c7e762,0xef39ec65,0xf55bf238,0xfc1cf8ad,0x0338ff9f,0x0a5e06d1,0x11220dd5,0x16e11430,
0x1b231931,0x1de71cb4,0x1f5e1eca,0x1f861f9c,0x1eb11f2e,0x1d1b1dfe,0x1aef1c15,0x17fd199b,
0x14221628,0x0f9911ee,0x0a8c0d1f,0x050807d8,0xff5f0234,0xf9b2fc83,0xf44bf6ef,0xef7ff1ca,
0xeb81ed65,0xe876e9db,0xe679e755,0xe589e5df,0xe59be574,0xe685e5f6,0xe843e74c,0xeaa1e962,
0xed6cebf7,0xf09eeefb,0xf41df25b,0xf7b1f5e2,0xfb6df98d,0xff28fd4a,0x02cf0103,0x061c0483,
0x090907a0,0x0b700a4c,0x0d650c80,0x0ebb0e1e,0x0f960f35,0x0fd20fc6,0x0f900fbf,0x0ef30f4e,
0x0e080e80,0x0cd70d7a,0x0b880c2e,0x0a0f0acb,0x089d0958,0x073507ed,0x05d80684,0x047d052b,
0x030c03ca,0x016d0244,0xff9c008b,0xfda0fe9d,0xfb82fc97,0xf958fa6b,0xf753f84b,0xf5a5f672,
0xf470f4fb,0xf3cbf405,0xf402f3ca,0xf4f3f46b,0xf671f5a4,0xf82bf747,0xfa1bf91f,0xfc11fb18,
0xfdf7fd05,0xffe7feef,0x01d400df,0x03ce02ce,0x05be04cb,0x07a606b1,0x096e0892,0x0af50a39,
0x0c090b95,0x0c910c5e,0x0c480c86,0x0b460bd9,0x09bd0a94,0x079f08c1,0x04fb065c,0x01ef0385,
0xfe85003f,0xfaccfcb0,0xf71af8f0,0xf37ef546,0xf046f1d1,0xed9beee0,0xeb6bec75,0xe9ccea89,
0xe8dce93d,0xe8bfe8ae,0xe986e904,0xeb56ea49,0xee33eca9,0xf1f2eff8,0xf692f428,0xfbe9f92a,
0x01b7fec4,0x07c504b5,0x0e0e0ae0,0x1464113c,0x1a74177c,0x1f961d2d,0x234621a3,0x252b246b,
0x25802586,0x246b2519,0x22332377,0x1f4120c8,0x1bd61d9a,0x18261a09,0x14061624,0x0f5a11c1,
0x09f30cc4,0x04120710,0xfdc200f4,0xf775fa99,0xf151f456,0xebb4ee6f,0xe6dfe92b,0xe303e4c9,
0xe03ee185,0xde8bdf3d,0xdddcde18,0xde1bdddf,0xdf07de7e,0xe07bdfb0,0xe279e16c,0xe4fee3a5,
0xe822e67c,0xebdbe9f3,0xefd7edd2,0xf41df1f1,0xf87cf64a,0xfce9fab8,0x0137ff16,0x05340342,
0x08ad0704,0x0b8d0a34,0x0db70cb6,0x0f240e88,0x0fdb0f8e,0x10121005,0x0fd61000,0x0f140f81,
0x0e140ea4,0x0cd90d78,0x0b820c2e,0x0a350ad1,0x094209b1,0x088b08e5,0x07d30834,0x06fc076c,
0x05cb0675,0x041c0500,0x02220327,0xfffc0113,0xfdc8fee2,0xfb76fca5,0xf926fa4c,0xf706f80c,
0xf535f612,0xf3e3f47b,0xf345f37b,0xf356f338,0xf402f39d,0xf51bf480,0xf695f5ce,0xf82ef75c,
0xf9daf901,0xfb8ffab3,0xfd35fc60,0xfef2fe16,0x00a0ffcd,0x0209015e,0x032a02a4,0x03f10399,
0x04660439,0x04580470,0x03d10426,0x02d80363,0x01a10241,0x001d00e8,0xfe3cff39,0xfc2bfd36,
0xfa04fb14,0xf803f8fc,0xf606f702,0xf433f51b,0xf286f354,0xf11df1ca,0xf013f08c,0xef87efb5,
0xefe1ef93,0xf15ff077,0xf40bf293,0xf7c0f5c2,0xfc50f9f2,0x0195fedf,0x07760476,0x0dca0a92,
0x1458110c,0x1ad6179b,0x20d71df2,0x25b62371,0x29062794,0x2a8e2a02,0x2a852ab8,0x291c29ec,
0x26e52814,0x24222594,0x2102229a,0x1dbd1f68,0x1a5d1c14,0x16671879,0x118d1420,0x0b8d0eb1,
0x04ac0835,0xfd3400fc,0xf5baf96e,0xee7cf20e,0xe7f8eb1f,0xe268e50d,0xdde8e003,0xdab2dc24,
0xd8e2d9a0,0xd835d868,0xd89fd84a,0xda09d937,0xdc1cdb00,0xdeaddd57,0xe1c6e027,0xe55be383,
0xe94be746,0xed9aeb68,0xf216efd6,0xf6a4f45f,0xfb13f8e1,0xff4ffd38,0x030b013d,0x062704b0,
0x086a0760,0x09d4093d,0x0a7a0a44,0x0a600a82,0x09c40a1f,0x08eb0959,0x0819087d,0x078807ca,
0x07350755,0x070f071b,0x07290715,0x075b0744,0x0780076e,0x077b0785,0x07130758,0x05f3069d,
0x04000512,0x017202c7,0xfe80ffff,0xfb9afd05,0xf91dfa50,0xf72ef80e,0xf5d1f66f,0xf515f55c,
0xf4d9f4e8,0xf4f1f4dc,0xf554f51a,0xf5e3f597,0xf6abf63d,0xf7bbf72c,0xf928f865,0xfaf4fa03,
0xfd22fbfe,0xff8efe57,0x020e00d0,0x0451033b,0x062c0553,0x076006e0,0x07d207b1,0x076b07b3,
0x064006f0,0x04780569,0x025a0373,0x0025013a,0xfe2cff22,0xfc61fd3d,0xfac8fb92,0xf94bfa06,
0xf7def894,0xf673f726,0xf50bf5c1,0xf3baf45b,0xf2b9f32a,0xf291f285,0xf35cf2da,0xf52bf422,
0xf7eff66c,0xfbb9f9b6,0x0051fded,0x058402db,0x0b3d0850,0x111a0e2a,0x1711140e,0x1cae19fc,
0x214a1f27,0x2477230a,0x2674259b,0x273226f4,0x27382747,0x269026f8,0x257c261a,0x23f724bd,
0x2225231e,0x1fe1210b,0x1d5a1eac,0x19f11bce,0x151317b8,0x0edc1218,0x07bb0b61,0xffe803e2,
0xf805fbf1,0xf081f42f,0xe9eded1b,0xe483e70d,0xe03ee234,0xdd51de9d,0xdbbbdc5a,0xdb2adb55,
0xdb5ddb2f,0xdc16dbaf,0xdd26dc96,0xde87ddd3,0xe006df3f,0xe1f1e0ec,0xe432e308,0xe6c9e573,
0xe9b9e832,0xed0eeb5a,0xf080eec6,0xf3fff23d,0xf753f5af,0xfa3ef8d9,0xfc98fb7d,0xfe6ffd95,
0xffceff2d,0x00dd0059,0x01ce0158,0x02ce024b,0x03e00351,0x0525047a,0x06b905e5,0x089e07a3,
0x0aa709a6,0x0ca30ba8,0x0e5d0d8d,0x0fa70f13,0x1083101d,0x10d510c2,0x108210bf,0x0f791014,
0x0e270ed3,0x0c9c0d69,0x0b080bd8,0x09580a35,0x078c0876,0x05850693,0x032f045f,0x00a701ed,
0xfe54ff75,0xfc62fd48,0xfaf4fb98,0xfa51fa85,0xfaa9fa5b,0xfbe9fb31,0xfda9fcbd,0xffa2fea2,
0x019800a1,0x033c027c,0x043e03d2,0x048a0486,0x03e20459,0x02220327,0xff4900d5,0xfbc0fd96,
0xf7eef9d4,0xf445f610,0xf108f299,0xee57ef9a,0xec30ed34,0xea4feb3c,0xe868e95b,0xe6bee783,
0xe589e615,0xe4d9e51d,0xe4fee4ce,0xe626e572,0xe872e721,0xebfcea13,0xf0a4ee31,0xf637f350,
0xfcb9f95a,0x03fe0047,0x0bb107d0,0x135b0f90,0x1a4d16fe,0x1fcf1d3a,0x241b2217,0x274d25d4,
0x29b92896,0x2bbe2ac5,0x2d7f2cab,0x2ed62e31,0x2fb32f56,0x30132ff8,0x2fc23003,0x2e982f4a,
0x2c4e2da4,0x281c2a7b,0x21f1253c,0x1a671e53,0x11ec1641,0x09270d88,0x00ba04dc,0xf927fcd0,
0xf28df5b8,0xed1aefad,0xe8c0ead1,0xe55ae6e9,0xe2ffe40d,0xe14fe216,0xe015e0a6,0xdf04df8e,
0xddf0de80,0xdd05dd76,0xdc39dc97,0xdbc4dbf3,0xdba0dba7,0xdbcedba8,0xdc65dc0d,0xdd60dcd5,
0xdee6de18,0xe133dff0,0xe423e295,0xe798e5d1,0xeb60e978,0xef11ed3e,0xf278f0d1,0xf5b0f415,
0xf8f2f750,0xfc62faa1,0x0020fe39,0x04460227,0x08840663,0x0cb60aa3,0x10860eac,0x13d61246,
0x16381526,0x17b51711,0x1852181d,0x181f184f,0x175117c5,0x164616cd,0x154015c1,0x142814b8,
0x12f4138d,0x1194124d,0x0fb810b6,0x0d6b0e9e,0x0abc0c17,0x080e0962,0x05df06dd,0x04760515,
0x03ee040e,0x045d0414,0x053004be,0x061c05ae,0x06ab0674,0x06a206c1,0x05b90648,0x04170501,
0x01cf0303,0xfed60061,0xfb54fd27,0xf738f957,0xf2cef506,0xee99f0ab,0xeab5ec9a,0xe73ce8e6,
0xe468e5b9,0xe20ee330,0xe019e10a,0xde2edf25,0xdc54dd38,0xdae4db89,0xda5cda7d,0xdb1bda8e,
0xdd31dbfc,0xe0b7dec7,0xe5a8e301,0xec07e8b0,0xf393efa4,0xfc2df7c3,0x054700b5,0x0e6909e0,
0x170912d7,0x1e071ace,0x233f20ce,0x27392569,0x2a2828c5,0x2c7b2b6a,0x2e862d87,0x305d2f72,
0x31f03131,0x33173299,0x339b3373,0x3373339d,0x328c3319,0x30b431be,0x2da32f56,0x28bf2b7a,
0x21c12577,0x194e1dbe,0x0fb81495,0x05d20ac2,0xfc5a00fe,0xf3f2f7fe,0xecb5f02e,0xe6c2e998,
0xe226e44a,0xdeaee04e,0xdc40dd57,0xda7ddb50,0xd91bd9c0,0xd833d89b,0xd789d7d4,0xd72bd74e,
0xd74cd72d,0xd7ced780,0xd8b3d833,0xda0cd952,0xdbbbdade,0xddbbdca9,0xe064def7,0xe3d2e207,
0xe7e3e5c5,0xec51ea0f,0xf0deee9d,0xf53cf316,0xf93df74d,0xfceafb19,0x0086feba,0x0407024b,
0x077205bc,0x0aef0931,0x0e320c9c,0x10e90f9f,0x12f41209,0x141213a4,0x14701454,0x1446146a,
0x139513fe,0x129d131b,0x11bc1227,0x1112115d,0x10a910d7,0x10711087,0x103e105d,0x0fd21012,
0x0f2f0f8b,0x0e390ebe,0x0cfc0d9f,0x0bd10c61,0x0b190b60,0x0b260b03,0x0bec0b7b,0x0d170c7d,
0x0e4e0dbb,0x0f070ec1,0x0ed80f0d,0x0da50e5e,0x0b770cac,0x08600a0b,0x046d067c,0x00110249,
0xfb64fdc5,0xf679f8f6,0xf18ef3f9,0xecebef30,0xe8c4eac6,0xe53fe6ed,0xe257e3ba,0xe022e12c,
0xde3edf29,0xdcecdd7b,0xdc3cdc86,0xdc1fdc1b,0xdc85dc3f,0xddb6dd02,0xdfdadea8,0xe2e0e13e,
0xe6e9e4c6,0xebf4e950,0xf1fbeedb,0xf8d2f54e,0x0043fc7d,0x07ce0410,0x0eb10b6d,0x13fb1182,
0x18251631,0x1b4919cf,0x1dd01c99,0x200d1eee,0x22862142,0x253223cf,0x2805269f,0x2aa82963,
0x2d122be2,0x2f272e2b,0x30922ffd,0x30ba30d3,0x2f593041,0x2bde2deb,0x25c22925,0x1d8a21db,
0x141518e9,0x0a360f21,0x00a2055a,0xf7defc1c,0xf022f3d7,0xe990ecb5,0xe44fe6c2,0xe034e21d,
0xdd4dde99,0xdb88dc52,0xda8fdaf3,0xda56da5c,0xdac9da7b,0xdbbadb39,0xdcdbdc46,0xde1cdd77,
0xdf67dec2,0xe0cbe019,0xe24ae188,0xe3f9e318,0xe600e4f1,0xe8abe737,0xec1bea4f,0xf044ee1a,
0xf50af299,0xfa01f787,0xfe9ffc63,0x028900ab,0x05be0431,0x08910739,0x0ac609c0,0x0c580ba4,
0x0d4c0ce4,0x0de20d9d,0x0e630e20,0x0ec50e99,0x0ec60ed8,0x0e6d0ea3,0x0dec0e2e,0x0d880dba,
0x0d470d62,0x0d120d27,0x0d030d08,0x0cd30cf7,0x0c360c91,0x0b4a0bc4,0x0a670ad2,0x09b00a0a,
0x09200964,0x08e208f2,0x091a08e7,0x0a060984,0x0b2c0a94,0x0c380bbf,0x0ca70c8d,0x0c2c0c88,
0x0af40ba8,0x09120a12,0x06cd07f8,0x041e0586,0x00e80298,0xfcfaff0e,0xf862fabb,0xf367f5e4,
0xeea0f0f9,0xea4dec67,0xe6a3e860,0xe3ebe52a,0xe1e9e2d8,0xe06ae119,0xdf87dfe4,0xdf46df55,
0xdf9ddf5c,0xe0a7e00d,0xe274e174,0xe4efe3a1,0xe81fe66a,0xebf6e9f5,0xf044ee0b,0xf509f295,
0xfa7cf7ad,0x0076fd68,0x06b70399,0x0c2f09a5,0x10410e5f,0x12fd11ca,0x14be13f4,0x160b156b,
0x178d16bc,0x19ac1889,0x1c611af2,0x1f7a1def,0x229b2108,0x25c0242d,0x28db2756,0x2ba42a4d,
0x2d822cbb,0x2e012df6,0x2ce42da8,0x29cf2ba5,0x24722760,0x1d772120,0x1579198c,0x0cfd1140,
0x049108b8,0xfcd200a1,0xf5c1f936,0xef7cf282,0xea09eca2,0xe5a0e7bd,0xe1fce3b2,0xdf09e072,
0xdc9cddbf,0xdacadba3,0xd98fda14,0xd8ccd926,0xd866d88d,0xd88cd85f,0xd930d8d7,0xda4bd9aa,
0xdbe9db05,0xde35dcf7,0xe135dfa4,0xe4aee2dd,0xe8fce6b2,0xee56eb89,0xf43ff13f,0xfa41f746,
0x000dfd36,0x04f402ad,0x08a106e9,0x0ba10a2a,0x0e510d00,0x10e70f9b,0x1335121a,0x1529143c,
0x16a215f7,0x17501713,0x1731175e,0x163b16d2,0x144f1564,0x11ad130a,0x0eb61035,0x0bec0d40,
0x09900ab2,0x0768087a,0x0558065e,0x038c0460,0x029a02f1,0x028c027d,0x030102b8,0x03b20357,
0x04450404,0x04900475,0x04810495,0x04390465,0x03af0402,0x02a3033b,0x012b01f2,0xff5b004e,
0xfd15fe48,0xfa58fbc3,0xf72df8d2,0xf399f56f,0xeff8f1be,0xecd3ee53,0xea61eb81,0xe8e1e982,
0xe83de875,0xe856e834,0xe8f3e896,0xea14e97a,0xeb4eeab1,0xecc1ec01,0xee4bed88,0xefc2ef07,
0xf133f07c,0xf2f2f201,0xf56bf410,0xf8cdf702,0xfd04fac8,0x01ffff71,0x07020494,0x0ae90927,
0x0d630c48,0x0f140e53,0x103d0fb3,0x114b10c0,0x12be11f7,0x14801393,0x168c1579,0x18ac17a3,
0x1ad219ba,0x1d341bfc,0x1f861e66,0x21632081,0x22e2222c,0x23e52373,0x24622439,0x2415245b,
0x227a237a,0x1ede20f2,0x19cf1c74,0x13ee16f0,0x0dca10e2,0x079e0ab1,0x01770484,0xfb7cfe74,
0xf5a5f88d,0xf025f2d3,0xeb18ed90,0xe6cce8d5,0xe30ee4e1,0xdf9ee148,0xdc90de10,0xd9f2db32,
0xd7e5d8dc,0xd647d70b,0xd52bd5a5,0xd4e0d4e7,0xd581d514,0xd73ad637,0xd9fad884,0xdd53db92,
0xe142df31,0xe60ce38d,0xeb79e8b7,0xf145ee52,0xf767f450,0xfda5fa88,0x03f200c7,0x0a2f0720,
0x0f9d0d09,0x13f611ef,0x176115c6,0x19e218bb,0x1b6f1acb,0x1c181bd7,0x1c431c3d,0x1bce1c22,
0x1a831b4d,0x1847197b,0x159916f6,0x12d01439,0x0ff91165,0x0d3c0e9c,0x0ac80bf0,0x08f509cb,
0x077a0830,0x061706c7,0x04ba0565,0x03ac042a,0x02ea0341,0x024f029c,0x017701f2,0x000d00d8,
0xfe00ff19,0xfb77fccc,0xf893fa0b,0xf563f705,0xf23af3cf,0xeee3f097,0xeb4eed1f,0xe806e990,
0xe5b6e6b7,0xe482e4fe,0xe449e448,0xe4b1e46b,0xe5a7e51e,0xe6fce64c,0xe869e7b1,0xe9abe90f,
0xeab5ea36,0xeb82eb21,0xec3cebe6,0xed28eca2,0xeef4edea,0xf1f5f044,0xf663f408,0xfbf1f904,
0x0278ff18,0x099e0602,0x10680d27,0x159e133a,0x19211791,0x1b131a44,0x1c471bba,0x1d4d1cc5,
0x1e851de0,0x1ff11f39,0x216f20b3,0x22bd2219,0x23a82352,0x23d623d6,0x234c23a5,0x223522cf,
0x2083216b,0x1ea41f96,0x1c881d98,0x1a861b7f,0x18f119b3,0x17291827,0x147615eb,0x110312d7,
0x0ce70f06,0x084d0aa7,0x03bd05fd,0xff32017b,0xfa9bfce9,0xf5f0f84e,0xf127f38c,0xec1eeeab,
0xe6dce980,0xe1c1e446,0xdd3cdf60,0xd98ddb49,0xd6c0d80f,0xd4bad5a3,0xd3a3d412,0xd3c2d38e,
0xd4d7d430,0xd6c9d5b0,0xd9ebd82f,0xddefdbdc,0xe242e015,0xe70de491,0xec76e9b5,0xf205ef3b,
0xf7ccf4dd,0xfde1fad4,0x03b400da,0x090f066c,0x0e170ba1,0x12421053,0x150913d3,0x169615f9,
0x17441701,0x1724174b,0x165e16d9,0x14f115b6,0x12ff1407,0x10e111ef,0x0f170fe7,0x0e0f0e7d,
0x0d740db9,0x0d170d3b,0x0d440d1b,0x0e0c0d98,0x0ef90e83,0x0fb80f68,0x0fe40fe8,0x0f5e0fb8,
0x0dc80eb9,0x0b090c87,0x077e0960,0x0300055f,0xfdf30082,0xf8ddfb64,0xf400f667,0xef5ef1a3,
0xeb2fed38,0xe74de939,0xe389e562,0xe04be1d9,0xddc2dee8,0xdc26dcdb,0xdb57dba3,0xdb5ddb43,
0xdc1bdba7,0xdd3ddca5,0xde68ddd1,0xdf7adef6,0xe070dff2,0xe16ce0ee,0xe274e1e8,0xe3cee311,
0xe61ee4cd,0xea19e7dd,0xf02cecdd,0xf82bf3f7,0x016afcb1,0x0b1d0641,0x14880fec,0x1c8718be,
0x230d1ffe,0x27f025aa,0x2bdd2a0a,0x2ebb2d68,0x30df2fe7,0x328631c0,0x339e3325,0x33e033d3,
0x33b333db,0x3307336c,0x31c1327f,0x2f9330c1,0x2c6e2e29,0x28252a64,0x234525bb,0x1e6420cf,
0x1a371c2a,0x173c1894,0x15601639,0x13891479,0x11231275,0x0d800f72,0x08c90b4c,0x0334060e,
0xfd08002f,0xf662f9c3,0xef99f300,0xe88aec13,0xe185e508,0xdad1de16,0xd4e9d7bd,0xd032d265,
0xcc7bce44,0xc98acade,0xc7f9c890,0xc80fc7d4,0xc9bac8ab,0xcd27cb40,0xd237cf7c,0xd865d530,
0xdf24dbc2,0xe5d0e287,0xebd3e8e8,0xf0f8ee81,0xf58cf34b,0xfa07f7c7,0xfe7bfc41,0x030800c3,
0x0777054b,0x0b1c096f,0x0d620c74,0x0e0d0de5,0x0db70df8,0x0cc60d53,0x0b280c12,0x08e60a15,
0x06b107c0,0x051f05ca,0x04be04c9,0x056c04f7,0x06f20612,0x099f081d,0x0d470b5f,0x112f0f44,
0x14a712fc,0x17841632,0x1957188f,0x1a6019ed,0x1b011aba,0x1b3b1b38,0x1a751af9,0x1881199f,
0x1570171a,0x113c137a,0x0c080ebf,0x05dd0918,0xfe700255,0xf5d9fa3a,0xed1ef174,0xe4e4e8e5,
0xdd93e11d,0xd73ada47,0xd23ad487,0xced9d04f,0xcd4ccddb,0xcd19cd0c,0xcdfccd6c,0xcf64ceaa,
0xd0b1d016,0xd18ed12c,0xd22dd1e5,0xd2cdd26f,0xd480d373,0xd83dd60d,0xde8adb13,0xe727e299,
0xf19eec32,0xfd54f757,0x09f40397,0x16381035,0x21211bec,0x2a1625d7,0x310a2dd5,0x361833c1,
0x39fd382a,0x3cfd3b93,0x3f303e35,0x40a93ffc,0x4123410b,0x409f40fd,0x3f383ffc,0x3d543e5a,
0x3aaa3c1f,0x370f3902,0x325134d3,0x2cb32f9f,0x269a29a0,0x213123cf,0x1cbc1ed1,0x19661afc,
0x164317d4,0x12781488,0x0db31024,0x081b0b07,0x01cd0503,0xfad7fe70,0xf32af70c,0xeb3bef41,
0xe384e745,0xdc2fdfcf,0xd5bfd8cd,0xd06dd2f7,0xcba3cdfd,0xc73fc95a,0xc3fcc567,0xc267c300,
0xc252c22c,0xc3e2c2e1,0xc72bc552,0xcc2dc973,0xd26dcf33,0xd93cd5d1,0xe003dca6,0xe668e340,
0xecb0e987,0xf316efe0,0xf966f650,0xfee8fc48,0x03730153,0x06bd0542,0x08be07eb,0x097e0935,
0x09a909a9,0x08eb0970,0x0732081c,0x05d20665,0x05840587,0x060f05b4,0x0759069f,0x09a20850,
0x0d480b4e,0x11ae0f74,0x162813e9,0x1a871863,0x1e541c88,0x214a1fee,0x23782271,0x25692472,
0x27242651,0x281d27c3,0x279a2819,0x251d269b,0x20e62333,0x1b7c1e50,0x14f1185b,0x0cd91118,
0x03eb0874,0xfa79ff3f,0xf0a5f59e,0xe669eb92,0xdc14e139,0xd252d70b,0xc9f8cdf2,0xc341c664,
0xbe4ac08e,0xbae4bc5d,0xb96cb9ef,0xb95db945,0xba13b9ab,0xbb61ba9c,0xbdb9bc6c,0xc107bf41,
0xc5a0c324,0xcbcdc886,0xd394cf83,0xdd05d816,0xe7ece24b,0xf45fedea,0x025bfb3d,0x10bf0997,
0x1e3a17ac,0x29a2243a,0x32ae2e76,0x3991365c,0x3ea33c4d,0x427140a5,0x451e43eb,0x466945ec,
0x46744694,0x454a4605,0x432a4456,0x404f41d4,0x3cb23e96,0x38663aa3,0x337d3604,0x2e0030d1,
0x28692b2f,0x236925d4,0x1f062124,0x1b9e1d2d,0x194d1a55,0x1760185f,0x149e1628,0x10a512ce,
0x0b750e32,0x0517086b,0xfdb00179,0xf5dff9c7,0xedfdf1eb,0xe651ea21,0xdf49e2ab,0xd937dc24,
0xd435d695,0xd02fd20e,0xcd3cce92,0xcb6ccc32,0xca86cad5,0xcacdca83,0xccc6cb8c,0xd06fce6e,
0xd52ad2ae,0xdaa3d7c6,0xe110ddb4,0xe813e492,0xef0aeb92,0xf5e1f274,0xfc59f93c,0x0161ff0f,
0x04dd0343,0x0712062e,0x07670774,0x061606f0,0x033e04dc,0xff550157,0xfbcdfd6f,0xf98dfa79,
0xf8a1f8f5,0xf90ef8a1,0xfb50f9f1,0xff61fd29,0x049b01e1,0x0a72077f,0x106a0d73,0x16221353,
0x1b3618c6,0x1fc01d86,0x23ea21e1,0x27a925d9,0x2ae3295b,0x2d6c2c3d,0x2edc2e59,0x2e742ee3,
0x2c3f2d94,0x27932a49,0x202f242b,0x16ff1bc1,0x0ccc1207,0x0172073e,0xf4fafb5b,0xe7f6ee71,
0xdbaae1ae,0xd040d5e3,0xc5d1cadd,0xbccdc122,0xb559b8e2,0xaf7ab22d,0xaba1ad46,0xa9d8aa7f,
0xaa05a9af,0xac6daaeb,0xb101ae85,0xb6f7b3d8,0xbdeaba58,0xc5f9c1c0,0xcfb1caa2,0xdabed502,
0xe74ce0da,0xf52aee14,0x043afc97,0x12fe0bcc,0x1f941999,0x29cd24f6,0x31b32e08,0x3811350a,
0x3d413ac7,0x414d3f75,0x442142ce,0x45fc452d,0x46f04697,0x46bb46f3,0x457d4639,0x434a4488,
0x3fc441b6,0x3aed3d79,0x3542382d,0x2ed53212,0x285b2b91,0x2261254c,0x1d181fa2,0x18dc1ad4,
0x15bb172e,0x136d1478,0x11861281,0x0ebb104e,0x0a740cc2,0x04a207c1,0xfdbe0141,0xf663fa17,
0xef60f2d2,0xe8f2ec07,0xe361e615,0xdee1e0f1,0xdbcadd27,0xd9dcdabe,0xd8b6d92a,0xd890d885,
0xd91cd8c9,0xd9fdd97d,0xdb87daac,0xddd2dc99,0xe0badf2f,0xe4c2e290,0xea03e74c,0xef95ecca,
0xf55cf26f,0xfb5ef85e,0x00a4fe26,0x04ff02e5,0x08b606f3,0x0ab40a05,0x09f20ab1,0x06550877,
0x00c103aa,0xfae5fdc8,0xf597f823,0xf15bf354,0xeeb8efc3,0xee86ee52,0xf0aaef55,0xf4a4f271,
0xf9f0f72e,0xffbffcd2,0x05b902b3,0x0c3a08ea,0x13200fa3,0x1a2b16a7,0x20ee1d9f,0x26cc23fe,
0x2b9c294f,0x2fd92dc7,0x331e31aa,0x34523412,0x322c33b8,0x2c962fbb,0x245c28c5,0x1a531f7d,
0x0f4914e6,0x03040959,0xf593fc5b,0xe83aeed1,0xdba5e1d6,0xd017d5b7,0xc5b2cabd,0xbc73c0e8,
0xb450b843,0xad57b0b4,0xa776aa3a,0xa38ba52d,0xa29ca2aa,0xa499a33c,0xa99da6c1,0xb0d2ad0b,
0xb929b4db,0xc2a7bdc5,0xcd82c7e7,0xd9c7d374,0xe772e075,0xf64feeba,0x0595fdfd,0x13b40ce0,
0x1fcf1a11,0x291824d1,0x2ffe2cbb,0x355332d1,0x3999379a,0x3cd63b4b,0x3f903e3f,0x41e340cd,
0x438142d7,0x43fd43e2,0x436043d6,0x41854298,0x3e974030,0x3aa83cbf,0x35a7384b,0x2fdb32d4,
0x299e2cc3,0x2345266c,0x1d7b2047,0x18951ae4,0x1481166e,0x119812e6,0x0fa81089,0x0db30eca,
0x0a720c3f,0x05970844,0xff340281,0xf848fbcd,0xf15df4c2,0xeb2dee30,0xe635e87c,0xe33be46d,
0xe231e28c,0xe1e3e1fc,0xe220e1e6,0xe31be294,0xe434e3b0,0xe50be4a1,0xe60de583,0xe737e6a1,
0xe8afe7de,0xeb22e9c3,0xeeb3ecc7,0xf301f0d4,0xf74af52c,0xfb41f94c,0xfeabfd0e,0x0131000d,
0x02c80210,0x0442037c,0x04ed04d7,0x03040452,0xff4d0144,0xfb5dfd5a,0xf70bf948,0xf262f4b1,
0xeedbf061,0xed8aedeb,0xee5dedb0,0xf135ef8a,0xf577f344,0xf9dcf7af,0xfe44fc04,0x035500b0,
0x0974063f,0x0ffe0cbe,0x1656132d,0x1ce9198c,0x23c52057,0x2a4c271b,0x2fef2d45,0x33b43225,
0x3441346f,0x318a3342,0x2c4a2f32,0x24bf28ca,0x1aba2010,0x0e6a14d5,0x006d078f,0xf1c2f91b,
0xe385ea87,0xd685dcde,0xcab8d074,0xc077c561,0xb815bc0a,0xb177b498,0xac0fae9c,0xa833a9f0,
0xa64ca703,0xa6b7a635,0xa977a7ca,0xadeeab85,0xb3b2b0a6,0xbab4b713,0xc32bbeb3,0xcdbec82e,
0xda6ad3cf,0xe8f8e17e,0xf863f0aa,0x07680006,0x14cc0e5a,0x200f1ac0,0x296024e0,0x31572d8d,
0x37f934d5,0x3d4b3ac2,0x41a53f95,0x450d4378,0x47934665,0x4966489a,0x4a574a02,0x4a094a5b,
0x4879496c,0x4558471c,0x40a84331,0x3a843dc0,0x330e36e9,0x2af82f06,0x234c270b,0x1c351fb5,
0x15b018d7,0x103912ce,0x0bff0df2,0x08d80a49,0x065e0794,0x03550503,0xfece0146,0xf890fbd8,
0xf1a4f525,0xeadbee24,0xe566e7e3,0xe296e399,0xe22ce22b,0xe302e282,0xe469e3a4,0xe64be54f,
0xe854e754,0xea14e93f,0xeb79ead2,0xecc1ec1b,0xee0aed62,0xef80eeb7,0xf167f061,0xf376f27b,
0xf4a0f432,0xf4f4f4d9,0xf52df517,0xf4fef528,0xf4e0f4db,0xf52ef508,0xf4e2f527,0xf3f2f46d,
0xf34ff394,0xf299f30d,0xf105f1e2,0xef67f020,0xeec9eeef,0xef3beeed,0xf050efaa,0xf263f13d,
0xf52af3b8,0xf831f6a8,0xfb78f9c7,0xffa5fd67,0x0494020f,0x09cd0723,0x0f7c0c91,0x1604129b,
0x1da819b8,0x263421d4,0x2ebc2a9b,0x35193254,0x38a1372e,0x39b2397c,0x379f3924,0x318c3518,
0x27d12d14,0x1b6e21e3,0x0da914ae,0xff0f0669,0xf0a7f7c3,0xe365e9cf,0xd7a1dd58,0xcd3dd246,
0xc435c890,0xbc1dc00e,0xb514b86d,0xaf75b212,0xab87ad3c,0xa9ceaa58,0xaa3aa9c8,0xac69ab1f,
0xb01dae18,0xb542b273,0xbc60b889,0xc572c0a3,0xd0f1cae2,0xde7ed785,0xed30e5c0,0xfbeff4a1,
0x098502e2,0x15c50fd4,0x20b01b6d,0x29c9256f,0x319c2dd2,0x38aa3537,0x3ed23bda,0x443241a1,
0x48d84697,0x4c7b4aca,0x4eeb4dde,0x50484fb8,0x505f5089,0x4eb74fc8,0x4b314d2a,0x45e748c1,
0x3f1542a1,0x378e3b68,0x2f783394,0x26c02b29,0x1e04225d,0x15ba19ca,0x0e2911d7,0x07bc0abd,
0x03560546,0xffe0019e,0xfb63fde3,0xf50df862,0xedd3f180,0xe67bea22,0xe063e328,0xdcb4de37,
0xdb63dbc9,0xdb8fdb5c,0xdc32dbd5,0xddbadcd6,0xdfe6dec6,0xe224e105,0xe45fe338,0xe6e7e5a6,
0xe8cfe7fd,0xea2de970,0xec51eb2a,0xee81ed7d,0xefc5ef41,0xf031f00d,0xf02af042,0xef7befe5,
0xee87ef07,0xed5aedf6,0xec24ecb8,0xeb89ebb9,0xebbeeb88,0xec86ec21,0xed23ecde,0xeda3ed5c,
0xee9bee0f,0xefa7ef23,0xf08ef019,0xf18af10b,0xf2c8f222,0xf492f396,0xf731f5bb,0xfb2df90b,
0xffc5fd70,0x04ea0240,0x0b0c07d7,0x12570e90,0x1ade166a,0x24a81fa5,0x2e6029a5,0x367332a6,
0x3cbf39d4,0x41113f37,0x4222421d,0x3ef74115,0x37d63bd6,0x2e0a3334,0x22182853,0x14b11b84,
0x06b40dbb,0xf8d0ffaf,0xebb4f223,0xdf56e56a,0xd3a7d96c,0xc8dace1b,0xbf4cc3de,0xb73bbb1c,
0xb097b3b6,0xabb2ade6,0xa8f6aa03,0xa8a9a87f,0xaaa7a95d,0xaf2cac9b,0xb63bb262,0xbfeabac2,
0xcb82c586,0xd871d1dc,0xe618df38,0xf3e2ed0c,0x00eafa71,0x0d3e0743,0x186112e4,0x22c71da5,
0x2cfe27f7,0x369131e5,0x3ee83ae3,0x45f142a0,0x4bda490b,0x505e4e50,0x536c5215,0x54e6545c,
0x54a15503,0x525753b5,0x4e3b5077,0x48c24bb1,0x41fb4578,0x3a933e52,0x326536a1,0x29962e05,
0x208c251a,0x16fe1bd3,0x0da81244,0x0538094d,0xfe2b017f,0xf876fb31,0xf323f5d4,0xed5ff05c,
0xe72dea3d,0xe13ce426,0xdc40de9a,0xd890da2a,0xd70bd795,0xd668d6bb,0xd5aad5fe,0xd5acd592,
0xd67bd603,0xd7b3d6f9,0xda68d8d6,0xde56dc47,0xe266e06c,0xe61ce443,0xe9b7e7ef,0xecafeb50,
0xeebaedc9,0xf053ef94,0xf1a8f102,0xf2a5f237,0xf264f2be,0xf0d9f1a6,0xefdaf038,0xef65efa3,
0xeed5ef1d,0xee53ee8f,0xeec3ee62,0xf04fef6a,0xf257f156,0xf424f342,0xf586f4e7,0xf655f5fa,
0xf718f6ab,0xf86af7a1,0xfaecf989,0xfe50fc88,0x02790043,0x079604ec,0x0db20a87,0x14ce1114,
0x1d8618f8,0x272c225a,0x304a2bd9,0x3871347e,0x3f2d3c0b,0x437541b5,0x43dc4431,0x403a4286,
0x396a3d25,0x3082353c,0x25762b37,0x18d61f53,0x0b33120b,0xfd97045e,0xf03bf6da,0xe2f8e9a2,
0xd562dc32,0xc85bcec1,0xbc44c22a,0xb17fb6b3,0xa870acbc,0xa187a4b0,0x9d889f13,0x9ce09cd3,
0x9f639dbd,0xa53fa1e7,0xae80a96d,0xbadbb468,0xc8adc1a5,0xd744cfec,0xe5b6de9b,0xf2e1ec7f,
0xfe8ff8d8,0x092203fa,0x12cc0e05,0x1cb517a4,0x274321ef,0x32482cc0,0x3ce037ad,0x462041b6,
0x4dd54a2d,0x53e75107,0x58655666,0x5aad59da,0x5a835adb,0x5831599a,0x53d45646,0x4dc650ea,
0x46aa4a56,0x3e8d42ae,0x36563a6c,0x2e5c3256,0x25f82a4a,0x1ce9217a,0x13fb1868,0x0b9e0faa,
0x044c07d5,0xfdd400f8,0xf854faf6,0xf342f5cb,0xee04f0ad,0xe8b2eb5f,0xe2efe5d7,0xddd9e03c,
0xda5adbe3,0xd785d8f2,0xd4b5d619,0xd2a7d384,0xd1c3d20c,0xd248d1d4,0xd484d327,0xd84ed647,
0xdcebda8c,0xe1a9df4c,0xe613e3f1,0xe9d8e80f,0xec8ceb5b,0xee59ed7c,0xf062ef4c,0xf20ef166,
0xf20af238,0xf16df1ad,0xf174f167,0xf130f161,0xf04ff0d0,0xef9eefe0,0xefcbef91,0xf109f04d,
0xf2b1f1df,0xf422f37c,0xf4b2f48a,0xf4baf4b9,0xf517f4d8,0xf62bf589,0xf81ef706,0xfb3ff981,
0xffe1fd5a,0x060f02d2,0x0d01097c,0x148310ab,0x1cc81895,0x24f120ed,0x2cac28ce,0x34763097,
0x3b4b381a,0x3f723dcb,0x40034034,0x3d003ee4,0x37973a81,0x30c6345b,0x28552cc5,0x1de82363,
0x119717f7,0x03d60ada,0xf56afcac,0xe690ee07,0xd7cbdf1d,0xc9c8d0a8,0xbd0fc342,0xb1c6b73e,
0xa7e7aca0,0xa03aa3b6,0x9b7d9d78,0x99f59a46,0x9bd19a7e,0xa0f09df9,0xa9a7a4d3,0xb58daf4a,
0xc35ebc47,0xd24dcac1,0xe125d9d4,0xeec7e826,0xfad0f503,0x053b0035,0x0ece0a0a,0x18a613aa,
0x234a1dd0,0x2eb528ed,0x3a2d3481,0x44a63f91,0x4de94975,0x55b3520b,0x5b1758b9,0x5dac5cbe,
0x5d675de0,0x5a935c48,0x55ea586e,0x4fdf5311,0x483e4c43,0x3f3543dc,0x36083a90,0x2d5f31a2,
0x251e2930,0x1d472120,0x15f41990,0x0f251280,0x08840bda,0x0210053f,0xfc0dfefc,0xf6d6f948,
0xf30cf4ca,0xefa7f167,0xeba1edb7,0xe77ae986,0xe3c6e58c,0xe07fe221,0xdd32ded4,0xda7fdbb7,
0xd95bd9b4,0xd9b1d95e,0xdafdda3b,0xddb4dc24,0xe193df9b,0xe552e37c,0xe8c1e71b,0xeb56ea32,
0xec76ec17,0xec97ec93,0xecd4eca9,0xec6eecd5,0xeaa9eba1,0xe96ce9d9,0xe983e954,0xea18e9d0,
0xea91ea52,0xeb92eafb,0xed74ec65,0xeff2eead,0xf25cf12d,0xf462f378,0xf5e1f529,0xf785f6ab,
0xf995f87c,0xfbdcfab9,0xfdf0fcf3,0x0075ff11,0x0466023c,0x099406e6,0x0f280c55,0x152d1213,
0x1ba71867,0x21f11ed4,0x2869251d,0x2f202bd2,0x34b13228,0x37c93690,0x37af382d,0x34953671,
0x2f5e322d,0x29192c4e,0x21cf259e,0x18db1d97,0x0dd7139a,0x011c07a4,0xf309fa40,0xe3d6eb88,
0xd48bdc1f,0xc62fcd30,0xb969bf91,0xae7eb3b5,0xa56da9b6,0x9eb3a1bc,0x9aa89c5c,0x999e99c6,
0x9b4f9a2d,0x9f9c9d18,0xa72da2f6,0xb1d0ac22,0xbefab81b,0xce43c66e,0xde36d650,0xed0ee5cf,
0xfa3ef3e3,0x055e0002,0x0fac0a8b,0x19f814c4,0x24f91f63,0x30af2ace,0x3c1b366f,0x46da419c,
0x50754bcc,0x588954c2,0x5e205bb1,0x60435fa5,0x5f506024,0x5c0f5deb,0x575159e3,0x51235468,
0x49814d85,0x40a9452f,0x37953c14,0x2ef53336,0x26b22acb,0x1e9f22a2,0x170a1abb,0x101d1386,
0x09910cd3,0x0336065a,0xfd2f0024,0xf7e5fa64,0xf454f5d6,0xf26df33d,0xf0faf1b8,0xef8bf038,
0xee5eeeee,0xed28edd1,0xeb0eec2d,0xe916e9fe,0xe83ae87f,0xe7f3e816,0xe80ae7e6,0xe8cee85f,
0xe998e944,0xea02e9cb,0xeaa1ea50,0xeaf2ead8,0xea92eae1,0xe991ea18,0xe7fce8ef,0xe506e6ab,
0xe17ce33a,0xdf19e00f,0xdf2aded2,0xe130e008,0xe413e283,0xe81ce5eb,0xed06ea89,0xf143ef4b,
0xf47ff2fd,0xf6caf5c2,0xf848f79f,0xf999f8e9,0xfbadfa84,0xfe00fce7,0xff92fed8,0x0156005c,
0x0421029a,0x079005cf,0x0b650966,0x10280dab,0x14fa12a1,0x19881737,0x1f0b1c1f,0x252a221f,
0x2a892807,0x2e2c2c9c,0x2f482f18,0x2d882eb3,0x298e2bc8,0x243226fb,0x1d9a211e,0x151b19a5,
0x0a090fdb,0xfd5703d2,0xefdaf6af,0xe1bbe8d0,0xd440dace,0xc830ce0a,0xbd97c2b8,0xb454b8c8,
0xacc4b050,0xa73aa9c2,0xa396a51f,0xa265a2b1,0xa336a298,0xa63aa464,0xabbea8a5,0xb427af8e,
0xc012b9a9,0xcf13c74b,0xdf15d713,0xee50e6e0,0xfb7af537,0x06dd014a,0x11920c46,0x1c5916e0,
0x27b021f0,0x332d2d74,0x3e0638b8,0x47b94309,0x50454c20,0x5789541a,0x5c6b5a54,0x5e155db0,
0x5c895da6,0x58b75ad3,0x53725648,0x4ca2503b,0x447448b1,0x3b3f3ffb,0x31963665,0x28812cf3,
0x20362449,0x188d1c49,0x114c14e7,0x0a290dbb,0x035006ad,0xfd2c0021,0xf7dffa6a,0xf3d8f5ab,
0xf167f26d,0xf0d5f0df,0xf1b6f127,0xf360f272,0xf5b2f480,0xf725f69d,0xf742f759,0xf719f718,
0xf752f73b,0xf767f76b,0xf72cf749,0xf6b1f704,0xf554f626,0xf2edf43a,0xf02ef188,0xedc0eee9,
0xeb5feca4,0xe81fe9e6,0xe39be5f9,0xdec5e128,0xda87dc87,0xd7d5d8df,0xd7e7d788,0xda19d8cd,
0xddd3dbc5,0xe32de051,0xe93ce637,0xef00ec31,0xf3e0f197,0xf784f5d8,0xf9def8d0,0xfbe8fadd,
0xfe3afd10,0x000fff45,0x013800ae,0x027d01c4,0x048f036c,0x075805d6,0x0af10915,0x0e550cbe,
0x11290fbe,0x14d212d4,0x19cc1725,0x1f6e1c9b,0x246e2217,0x277a2640,0x2823281d,0x2637277f,
0x221c2462,0x1cbb1f88,0x16b619d2,0x0f10132f,0x05700a6e,0xfa70001d,0xee70f482,0xe256e857,
0xd6eedc80,0xcc94d19c,0xc39cc7ed,0xbbcebf92,0xb585b879,0xb10db304,0xaecaafa6,0xae4aae5b,
0xaf98aeab,0xb2f6b10f,0xb7f5b535,0xbf49bb4b,0xc9bbc411,0xd776d049,0xe693def4,0xf4deedf0,
0x00dbfb26,0x0b30062c,0x14820feb,0x1db21919,0x27352265,0x30ff2c18,0x3a7b35d4,0x42e83ed6,
0x4a4446b0,0x508f4d9b,0x546e52e9,0x55445540,0x532e548b,0x4edd5149,0x48c34c03,0x412c451b,
0x38c43d10,0x2f81343e,0x26072ab9,0x1d5d2192,0x158c195a,0x0ec01209,0x08a60ba9,0x02c505b0,
0xfd700003,0xf8a5fb07,0xf46af669,0xf133f2ad,0xef62f012,0xefa0ef3f,0xf1eff080,0xf657f3f0,
0xfbc8f905,0x00a4fe60,0x03ef027d,0x05cb050a,0x066a0639,0x06300668,0x053d05c6,0x03aa048b,
0x00f90278,0xfceaff22,0xf7f0fa69,0xf38bf5a7,0xef6df18a,0xe9c9ecdf,0xe2c4e656,0xdbf3df44,
0xd647d8e5,0xd2dbd43a,0xd205d225,0xd3bcd28c,0xd7c1d583,0xdcddda45,0xe201df72,0xe720e49d,
0xeb85e974,0xef21ed63,0xf2a5f0d2,0xf700f4bc,0xfb87f957,0xff36fd81,0x025700ca,0x053903d0,
0x0801069e,0x0b41098c,0x0e9f0d04,0x10b30fd4,0x129b1184,0x1601141c,0x1a89182a,0x1f8a1d0b,
0x241421ea,0x273125de,0x284c280f,0x263427a6,0x21932427,0x1bb31eb2,0x154e189f,0x0d9011a3,
0x045c0923,0xfa09ff49,0xef91f4be,0xe57eea82,0xdba8e08d,0xd278d6f5,0xca34ce3a,0xc2cdc668,
0xbc57bf6a,0xb7d2b9c2,0xb59fb67d,0xb51fb525,0xb6e4b5ba,0xba58b874,0xbf72bc99,0xc6d9c2d8,
0xd116cb87,0xde1cd758,0xebe4e511,0xf81df258,0x020cfd4a,0x0a66065b,0x122f0e51,0x19bd15fc,
0x21991d9a,0x2a0325bb,0x32652e4a,0x3a07364f,0x40cd3d8b,0x464143bb,0x49c64852,0x4ab84a8f,
0x491f4a35,0x455d4786,0x3fce42c3,0x393b3c97,0x31d735aa,0x297a2dc0,0x2101252b,0x19561d07,
0x12d615f3,0x0cfc0fe6,0x073d0a11,0x02320486,0xfe58002d,0xfafcfca0,0xf816f976,0xf59df6d4,
0xf3ccf490,0xf3b0f379,0xf627f48f,0xfb18f861,0x0169fe23,0x081e04c9,0x0d340b07,0x0fa20eb6,
0x101f1009,0x0f9f1009,0x0da50ecf,0x0a6d0c2e,0x05fc0865,0xffdc031c,0xf929fc6e,0xf389f63b,
0xee0bf0f1,0xe6fdeab6,0xdf44e31b,0xd812db92,0xd222d4e9,0xcdbfcfbe,0xcba5cc49,0xcd36cbfb,
0xd17dcf2b,0xd62fd3de,0xdad6d87f,0xdf1ddd0c,0xe2d3e101,0xe6a5e4ae,0xeb6ce8de,0xf15dee48,
0xf7d3f494,0xfe2dfb14,0x03b8010d,0x084f0620,0x0c940a6b,0x10cf0ebf,0x13821274,0x14cc1428,
0x16e115a6,0x1a831885,0x1f191cbe,0x2396216d,0x27102578,0x2917284b,0x28bf2950,0x258c2778,
0x20202313,0x19b71cf9,0x12d11653,0x0b700f37,0x02ab0742,0xf8f6fdd0,0xf032f464,0xe854ec38,
0xe05ce45c,0xd852dc57,0xd059d44a,0xc8dfcc91,0xc208c552,0xbcd7bf2e,0xb9bdbb00,0xb932b922,
0xba90b9ba,0xbd4fbbbb,0xc240bf76,0xc9a8c59f,0xd406ce75,0xe0abda2c,0xed59e725,0xf808f2fa,
0x0082fc91,0x079b041e,0x0e810b0e,0x15d01222,0x1da419a0,0x25d621b9,0x2e2729ff,0x35fb322d,
0x3cc2398c,0x41fa3f98,0x451843d7,0x456c45a4,0x4324448e,0x3f0a4147,0x39a93c7e,0x337e36a6,
0x2ccc303a,0x25632935,0x1ddb218e,0x17331a5a,0x11e11471,0x0cb90f51,0x07740a0f,0x0310051e,
0xff750134,0xfc71fdd9,0xfa2ffb43,0xf814f924,0xf62ef70c,0xf58ef59e,0xf731f614,0xfb22f8db,
0x0191fe0a,0x0980057e,0x108e0d45,0x14f61320,0x16de1630,0x16b21709,0x144d15bf,0x101f1277,
0x0a0b0d45,0x02ac0684,0xfad2feb8,0xf357f70f,0xebdeefa9,0xe406e7f5,0xdc61e01c,0xd5c3d8ee,
0xd04bd2e9,0xcbb4cdd3,0xc9a6ca40,0xcb40ca04,0xcf00ccfe,0xd390d136,0xd837d5ef,0xdc60da55,
0xe09ede72,0xe55fe2e4,0xeacee803,0xf09eedaa,0xf70cf3bb,0xfde0fa7a,0x03fd011b,0x08dd068c,
0x0d570b21,0x11250f71,0x13381262,0x149513dc,0x1715159d,0x1b1f18f8,0x1fce1d75,0x24212217,
0x277725e5,0x296328b8,0x28bf296f,0x252b274b,0x1f462272,0x17f01bbe,0x1068141d,0x08c30cb4,
0xffc60468,0xf660fb07,0xedebf1fa,0xe6d6ea38,0xe06ce3a9,0xd948dcfb,0xd1f4d592,0xcb1ace79,
0xc4e8c7db,0xc011c244,0xbd34be55,0xbc8abcb5,0xbd56bcc2,0xbff5be5f,0xc4e0c218,0xcc95c859,
0xd6f6d182,0xe268dcbb,0xecbde7c9,0xf57df14b,0xfce9f959,0x03e00058,0x0b1e077a,0x12db0ee4,
0x1b3d1702,0x23ef1f8b,0x2ce1286c,0x35393136,0x3be838d0,0x40c63e85,0x43b74294,0x43db4425,
0x414d42e1,0x3cc73f39,0x373e3a0e,0x315e3455,0x2af52e41,0x23da2775,0x1cdf204e,0x16f019bc,
0x11cb1457,0x0c6c0f2a,0x073c09ba,0x02da04f8,0xfeed00d7,0xfba6fd35,0xf913fa51,0xf68cf7ce,
0xf48df56d,0xf45df42e,0xf646f512,0xfaa8f817,0x0247fe14,0x0bb706f4,0x145b104a,0x1a4717b4,
0x1d381c17,0x1d641dac,0x1aa81c61,0x14f9182f,0x0d5c1146,0x05450960,0xfcdd0117,0xf426f890,
0xeb3defb6,0xe26de6c9,0xda79de49,0xd435d71b,0xceebd183,0xcad2cc9c,0xc9b7c9cd,0xcbdbca77,
0xcfcdcdb5,0xd4a0d22a,0xd93fd6fd,0xddcedb78,0xe31ce053,0xe95be625,0xef9bec91,0xf549f275,
0xfb23f82b,0x00fefe17,0x061b03ae,0x0a53084b,0x0df40c40,0x10430f50,0x11a010f5,0x1377126d,
0x162814bd,0x196d17b7,0x1d111b3d,0x20711ecc,0x233021e7,0x24872423,0x239a2462,0x20142222,
0x1a7d1d84,0x133616f6,0x0b8b0f6f,0x0306076b,0xf9a9fe64,0xf05af4f6,0xe807ec06,0xe165e482,
0xdbadde87,0xd5e4d8c0,0xd08ad327,0xcb7acdf7,0xc6d6c91a,0xc2b9c4a7,0xbff6c129,0xbe7fbf1a,
0xbe48be34,0xc01abedc,0xc4f8c21d,0xcd35c8b2,0xd7f3d260,0xe335dda9,0xed89e87f,0xf639f224,
0xfdadfa00,0x04de013f,0x0c500892,0x1445103c,0x1ca31860,0x25c1210f,0x2f7e2a9a,0x38873431,
0x3fcc3c67,0x453d42c4,0x486a472d,0x489f48ec,0x4566476b,0x3f9b42b4,0x38e63c4c,0x31de356d,
0x2a722e37,0x22c6269b,0x1baf1f1b,0x15b01892,0x103b12f3,0x0aeb0d8b,0x06130878,0x014103a1,
0xfd09ff07,0xf961fb33,0xf5f5f79a,0xf2fbf462,0xf137f1e5,0xf109f0ed,0xf2c8f19e,0xf72ff49c,
0xfe9cfa8b,0x08570349,0x12650d73,0x1aff1702,0x20b01e40,0x22ee2246,0x21002286,0x1b011e65,
0x13641748,0x0b270f5f,0x021f06c3,0xf892fd55,0xef6ef3e5,0xe6f8eb26,0xdf7ae30a,0xd91fdc35,
0xd3c2d63f,0xd050d1bf,0xcf33cf77,0xd041cf74,0xd361d199,0xd70ad53c,0xda5ad8b9,0xddfddc18,
0xe28ae027,0xe7d1e521,0xed2eea85,0xf2a2efe1,0xf834f566,0xfdaafb00,0x025a001c,0x060d045f,
0x082f0754,0x096008ca,0x0b200a1f,0x0db60c52,0x10f40f46,0x148512b8,0x181d1653,0x1c1f1a06,
0x20221e38,0x230921cf,0x236a2398,0x20ee228f,0x1b231e72,0x1350174e,0x0ae60f2c,0x0209067a,
0xf8cefd78,0xef7ef419,0xe727eb19,0xe0c7e3c4,0xdb80de11,0xd68dd909,0xd1b5d415,0xcd78cf84,
0xc97bcb7d,0xc5c9c790,0xc256c40c,0xbfa7c0d5,0xbe8bbed9,0xbfdfbed2,0xc4bdc1e2,0xccc8c86d,
0xd6aed197,0xe132dbee,0xeb7ee673,0xf4aef037,0xfd28f8fa,0x05510142,0x0da1096d,0x160d11e0,
0x1e631a2c,0x272c22be,0x30312bb5,0x387c3477,0x3fa43c36,0x459742c6,0x49e247fc,0x4b4e4b14,
0x48aa4a80,0x42bf4608,0x3b2c3f11,0x32f63717,0x2ab32ed6,0x2276268e,0x1aaf1e82,0x13a41714,
0x0d981074,0x08c40b09,0x04910699,0x00d80297,0xfdc5ff51,0xfa73fc2d,0xf6e7f8aa,0xf3e2f547,
0xf1e6f2c0,0xf11af151,0xf21df152,0xf573f383,0xfb4af807,0x03e0ff45,0x0dfe08e5,0x177d12f0,
0x1ea61b6c,0x22a4211f,0x226c2311,0x1e9620e5,0x18561ba6,0x10b314b8,0x07a40c49,0xfe2302db,
0xf5a3f9ba,0xee7ef1e2,0xe845eb5c,0xe20fe522,0xdccadf40,0xd8eadab7,0xd60ed754,0xd517d538,
0xd623d57d,0xd776d6ce,0xd8e9d821,0xdb07d9dc,0xde36dc7e,0xe212e01d,0xe645e41f,0xeacee879,
0xf025ed5e,0xf5d6f2fb,0xfb62f8a7,0xffd3fddc,0x01f30124,0x03af02b4,0x06c60510,0x0aaa08b4,
0x0e560c87,0x11d4101d,0x1585139a,0x19c2179a,0x1e0d1bea,0x21922000,0x235322ae,0x22372337,
0x1dc8205f,0x16741a75,0x0d4211f8,0x03f00891,0xfa82ff4a,0xf0bcf59b,0xe7acec02,0xe067e3c9,
0xdb07dd8a,0xd697d8c6,0xd2a1d486,0xcf4ad0e5,0xcc51cdc5,0xc94bcad7,0xc602c7a2,0xc38cc499,
0xc29dc2de,0xc3dfc2ec,0xc7efc591,0xce40cae0,0xd5dbd1ed,0xdec9da2b,0xe863e38f,0xf217ed3b,
0xfb9ff6eb,0x04eb0049,0x0e340995,0x175612c2,0x20551bdf,0x290e24c0,0x30f62d20,0x37c23483,
0x3d453aa8,0x41ba3f9e,0x4530439f,0x465e4624,0x446945c6,0x3fc3426a,0x38fb3c8d,0x310a351f,
0x28e22cf5,0x20da24d4,0x18f31cea,0x114a1506,0x0abf0dd3,0x059f080d,0x017d036c,0xfe74ffde,
0xfbd2fd2c,0xf8dffa65,0xf60af75b,0xf406f4ec,0xf29df33f,0xf270f24d,0xf456f323,0xf812f5fa,
0xfdeefab3,0x060e01c3,0x0f710aaf,0x188f142c,0x1f8d1c6c,0x22fe21ba,0x2317236b,0x2065220a,
0x1b5e1e2d,0x13f317f6,0x0ac70f7b,0x01840607,0xf9dffd71,0xf414f6d0,0xee78f152,0xe8eceb95,
0xe421e674,0xdf80e1dc,0xdacbdd08,0xd7a6d8fe,0xd63dd6c4,0xd611d600,0xd6fbd661,0xd933d7ee,
0xdc40daae,0xdf91dddf,0xe2ffe13f,0xe700e4e4,0xebb9e94e,0xf11bee4e,0xf6c7f410,0xfacdf907,
0xfdc6fc43,0x0186ff81,0x061a03c3,0x0aa2086d,0x0e6c0ca5,0x117e0fef,0x15091334,0x18e116ec,
0x1d1e1af8,0x210a1f2e,0x232a227b,0x222c2307,0x1e33209b,0x17021aee,0x0e3312af,0x051209a5,
0xfb920067,0xf190f698,0xe794ec7f,0xdf77e320,0xda38dc95,0xd657d82e,0xd34dd4b9,0xd124d211,
0xcf91d065,0xcd39ce83,0xcaabcbe7,0xc8fec9b1,0xc874c896,0xc925c89a,0xcb2bca07,0xce47cc88,
0xd35bd08b,0xdac1d6ba,0xe43cdf44,0xef03e98c,0xf9e1f46f,0x047fff38,0x0eba09af,0x188813b1,
0x21831d2b,0x296c2598,0x304e2cfb,0x36393368,0x3ae938b9,0x3eb63ce7,0x4189404a,0x427f4250,
0x40d24204,0x3c753efa,0x360a396a,0x2eda327c,0x27972b38,0x202523ed,0x18441c38,0x10f01476,
0x0ab30db3,0x052607dd,0x007e02a4,0xfcf9fea4,0xf9bbfb57,0xf6baf82d,0xf49ef586,0xf38bf403,
0xf319f334,0xf3f9f35b,0xf658f4f6,0xfa41f81b,0xffc2fcca,0x072d0338,0x100f0b88,0x18ae148a,
0x1ea81c1f,0x21582057,0x214c21ab,0x1e96203f,0x19a31c66,0x124b1640,0x098b0df8,0x01470540,
0xfab7fdbd,0xf5aff81c,0xf112f34e,0xed2aef08,0xe9a0eb6b,0xe555e799,0xe0c5e300,0xdcc7deb1,
0xda21db38,0xd992d994,0xdaedda11,0xdd40dc12,0xdf73de5a,0xe1afe08c,0xe436e2e9,0xe6e3e589,
0xe9ede848,0xee31ebf4,0xf215f04e,0xf50cf38d,0xf8b3f6c1,0xfd51faea,0x023effc5,0x06e204a6,
0x0a8608d2,0x0df10c2d,0x11970fc3,0x15971385,0x1a5417de,0x1f661cec,0x22a2215b,0x22fa2334,
0x1f7e21c5,0x18531c43,0x0f6213fe,0x05ea0aa9,0xfc900138,0xf306f7da,0xe960ee16,0xe1cbe53b,
0xdceddf12,0xd9ccdb36,0xd7add89b,0xd6d2d718,0xd647d69b,0xd509d5bd,0xd37ad446,0xd21fd2ba,
0xd152d1b5,0xd09fd0f5,0xcfb2d038,0xcf2dcf39,0xd101cfc3,0xd5dbd2fc,0xdddad98b,0xe81fe2d6,
0xf363eda1,0xfee9f928,0x0a50049e,0x15300fdd,0x1ebf1a31,0x26c722e5,0x2dbf2a66,0x339c30da,
0x383c360e,0x3b9c3a1b,0x3db63ccd,0x3ec33e63,0x3e033eb1,0x3ab13cad,0x356b382f,0x2f813283,
0x29372c6a,0x220925c3,0x1a1f1e1b,0x12fe165e,0x0d1b0fee,0x07d30a6b,0x03150569,0xfe9200cd,
0xfa42fc5e,0xf67df844,0xf3a5f4fa,0xf1c3f291,0xf143f143,0xf281f1b2,0xf550f3b5,0xf9a8f74c,
0xff7dfc5f,0x06f002fd,0x0f810b27,0x175913b1,0x1c701a3a,0x1ea21deb,0x1dfa1ea9,0x1a921c9c,
0x14bf17f0,0x0d3f1117,0x05f0098e,0xff810280,0xfa63fcd8,0xf621f828,0xf323f475,0xf113f214,
0xee83eff3,0xeae7ecc2,0xe6b5e8eb,0xe244e467,0xdf3ce077,0xdf18deca,0xe134dffd,0xe3a5e27a,
0xe5c1e4b8,0xe7afe6bb,0xe917e888,0xe99de960,0xead1ea13,0xec97ebbd,0xedd4ed32,0xeff7eeb3,
0xf39af1a1,0xf80af5c5,0xfc9ffa54,0x00cffecd,0x047e02ad,0x081b064e,0x0c1109fc,0x10ba0e4d,
0x16761370,0x1c44197c,0x20711e99,0x21872184,0x1e6d2076,0x18351b9c,0x105a1467,0x08020c2a,
0xffc403ee,0xf6d6fb65,0xede3f249,0xe660e9d7,0xe1aae3a9,0xdf06e030,0xdd3fde13,0xdbabdc6f,
0xda91db0b,0xd9b6da2b,0xd851d915,0xd6f9d793,0xd5ecd677,0xd3e2d51a,0xd0d9d262,0xce7ccf7e,
0xce0acdf7,0xd0e2cefc,0xd772d3c0,0xe0d3dbdf,0xebd9e62c,0xf7e6f1c0,0x0453fe2b,0x0fd10a3c,
0x19c714ff,0x22651e3f,0x29ed2643,0x30c82d70,0x369233d9,0x3ae538e8,0x3e243ca3,0x405d3f73,
0x404940a9,0x3d9c3f3f,0x38f13b73,0x3374363e,0x2d53307d,0x260029db,0x1dac21d7,0x15bf19a5,
0x0eec1225,0x09490bff,0x03fe06a1,0xfee5016b,0xfa43fc7c,0xf65cf845,0xf299f46f,0xeffcf108,
0xef64ef7c,0xf064efb5,0xf2c8f167,0xf692f485,0xfbccf8fe,0x026ffeef,0x0a21063a,0x113a0ddc,
0x16bb1435,0x19b01899,0x19f91a31,0x16c118cb,0x10b513ff,0x09f20d37,0x043106ef,0xffb401da,
0xfb83fd90,0xf8a4f9d6,0xf7adf7f9,0xf6eff763,0xf52bf629,0xf2c1f419,0xeedaf0fc,0xea5cec92,
0xe75be889,0xe71ee6e3,0xe877e7bb,0xea27e941,0xec32eb23,0xee29ed3d,0xef0feec6,0xef24ef23,
0xeec6ef19,0xed23ee07,0xec3aec76,0xed25ec7d,0xef2aee13,0xf18ff057,0xf3fef2c8,0xf6a5f541,
0xf9ddf83c,0xfd23fb71,0x0133ff0e,0x0655038f,0x0cce0980,0x136a1017,0x18e5167e,0x1af81a67,
0x19a71ab0,0x157917e2,0x0f9d12a7,0x099d0c9f,0x03460683,0xfca8fffe,0xf59cf936,0xeeecf210,
0xeab5ec72,0xe8e2e995,0xe76ce84a,0xe511e641,0xe315e3fd,0xe114e233,0xde72dfc4,0xdbe5dd29,
0xd8b5da81,0xd3a3d660,0xce5dd0ea,0xca43cc0d,0xc8ebc927,0xcb74c9aa,0xd202ce4b,0xdbc1d692,
0xe786e16e,0xf4bcee06,0x01effb73,0x0dd00817,0x17d71310,0x1ffe1c2a,0x26e32381,0x2d622a31,
0x332a3067,0x382335bb,0x3c553a5d,0x3f093de4,0x3fcb3fb4,0x3e533f58,0x3add3cd4,0x35fe388f,
0x2feb3324,0x288f2c58,0x204e2482,0x17d11bfe,0x106913ee,0x0a100d26,0x04330710,0xfefa017f,
0xfaebfcd1,0xf749f91d,0xf3c4f574,0xf1a8f27d,0xf108f12d,0xf1a6f12f,0xf358f25f,0xf5f7f48e,
0xf96cf791,0xfe3afba1,0x044a0129,0x0abc0782,0x109f0dd2,0x148612eb,0x15001544,0x11d413ce,
0x0c2b0f2d,0x06a30946,0x028f0465,0xff6600ef,0xfd89fe31,0xfdb9fd6a,0xfea0fe38,0xfe8afebd,
0xfd95fe30,0xfad9fc7c,0xf667f8c0,0xf20ff413,0xefaaf094,0xeed4ef26,0xeecdeeb1,0xef8def1f,
0xf090f00f,0xf0fcf0e5,0xf0def0f1,0xf044f0ba,0xeda4ef39,0xea66ebe7,0xe8c7e957,0xe8c4e8a6,
0xe976e90e,0xea63e9f0,0xeb6dead1,0xed9dec5c,0xf0a0ef11,0xf430f255,0xf888f62e,0xfe6afb4d,
0x053201b1,0x0cd908fe,0x1393106d,0x18331636,0x19d6196c,0x1842196f,0x145c167d,0x0f6211fc,
0x0a360cc1,0x04dc07a3,0xfe9201d1,0xf804fb3f,0xf30cf530,0xf09ff1a7,0xee1fef77,0xeb54ecb5,
0xe8b0ea07,0xe58ee734,0xe1e5e3c7,0xdd4fdfc7,0xd735da72,0xd030d3b7,0xc9e0ccde,0xc58ec750,
0xc47dc493,0xc766c57a,0xcdf5ca37,0xd77bd267,0xe351dd2d,0xf029e9a7,0xfd1ff6b9,0x09110347,
0x13150e54,0x1b381757,0x225b1ede,0x28ad25a5,0x2e4a2b84,0x33bb3112,0x3854362d,0x3b8b3a1b,
0x3d713cae,0x3d903dbc,0x3ba53ce0,0x37ba39eb,0x325b352d,0x2c142f4e,0x24972881,0x1c842086,
0x14d618a2,0x0d801118,0x06b50a02,0x015703d1,0xfd3dff35,0xf996fb5d,0xf67ff7ee,0xf492f55b,
0xf424f428,0xf4dff466,0xf644f57f,0xf857f73d,0xfaeff98a,0xfdebfc67,0x0195ff9a,0x069603f5,
0x0bcc094c,0x0f1a0dd0,0x0f5e0f9a,0x0ce20e6e,0x08cc0aef,0x04ba06a7,0x00fa02e3,0xfdfcff3d,
0xfd54fd51,0xfeeefdfc,0x00b1ffdb,0x01ef0165,0x01b60221,0xff1600a9,0xfaf0fd1a,0xf724f8e8,
0xf406f589,0xf194f2a4,0xf0aaf0ef,0xf0a2f09c,0xf063f09d,0xefc5f008,0xef9defad,0xee78ef4a,
0xebe0ed3d,0xe98eea98,0xe83be8bf,0xe7c2e7f5,0xe7abe7ae,0xe7a5e7a9,0xe827e7c7,0xe9a2e8c1,
0xec63eadd,0xefd5ee0a,0xf46af1ed,0xf9fcf71c,0x0063fd19,0x071f03b8,0x0e340aa0,0x1448117f,
0x17dd166b,0x18b3189e,0x16c71814,0x1326150b,0x0f551143,0x0b250d4d,0x063a08cf,0x0092036e,
0xfba0fdf0,0xf7daf9a1,0xf492f630,0xf121f2e7,0xed5def3f,0xe9c5eb90,0xe568e7c8,0xdf14e27b,
0xd7b0db70,0xd05ed3fc,0xc9b2ccdf,0xc524c717,0xc39dc3f6,0xc5b3c432,0xcbaac835,0xd51bd006,
0xe065daa4,0xec5fe64b,0xf8dbf293,0x04f0ff11,0x0f250a51,0x1771137d,0x1e2a1b00,0x23b72102,
0x29272668,0x2e802be4,0x333630ed,0x375f355b,0x3ac13930,0x3cb73bf6,0x3c473cdc,0x391d3af7,
0x348e36ed,0x2ef131ed,0x28242baf,0x204f2454,0x17da1c1f,0x0f80139e,0x08310bb4,0x022c04fd,
0xfd82ffb8,0xf9f0fb91,0xf77df89f,0xf5dff689,0xf566f582,0xf5d9f585,0xf6f9f657,0xf874f7b0,
0xf9e9f93c,0xfb45fa8d,0xfdc7fc48,0x027bffe4,0x07fa054b,0x0bb10a2a,0x0c750c6e,0x0b010bfa,
0x07d2098b,0x03da05fa,0xff6f017e,0xfd29fdf8,0xfd37fcff,0xfe3dfd9d,0x0007ff0e,0x01ec0118,
0x0239024f,0x00c401b0,0xfe55ff95,0xfba6fd0c,0xf869fa0e,0xf5d3f6f1,0xf493f513,0xf407f447,
0xf304f39b,0xf20cf27d,0xf0e3f196,0xee74efcc,0xec12ed2e,0xea64eb23,0xe8ffe9ad,0xe7ede86a,
0xe72be781,0xe739e70a,0xe82be7a2,0xe9c7e8dc,0xec1aeae3,0xef4bed8c,0xf374f145,0xf8a1f5e8,
0xfe36fb74,0x03cf00eb,0x0a2606f9,0x0fb60d20,0x136011d0,0x14711447,0x12c613db,0x1058118d,
0x0df00f24,0x0baf0cce,0x092f0a88,0x05b40792,0x01660398,0xfd96ff55,0xfab2fc23,0xf729f910,
0xf329f529,0xef19f12e,0xe8efec75,0xdffee4a0,0xd6a1db3f,0xce40d244,0xc76fca94,0xc344c500,
0xc219c251,0xc427c2b3,0xc9b9c670,0xd2b7cde2,0xdd82d7f6,0xe905e33d,0xf4efeeee,0x009dfae1,
0x0b380617,0x13fd0fda,0x1aac1790,0x20561d92,0x25ff232b,0x2b5928b5,0x309a2df4,0x35d4333a,
0x3ac03861,0x3de83cac,0x3e393e64,0x3c463d76,0x39123ac9,0x34a33707,0x2eca31e3,0x27562b3b,
0x1f022333,0x16821ac2,0x0eae1278,0x07900b11,0x015a0445,0xfcaffed7,0xf971fae9,0xf716f82b,
0xf562f626,0xf490f4d8,0xf47bf472,0xf4bff49b,0xf4a3f4bf,0xf4cbf499,0xf660f557,0xf9cdf7dd,
0xfe50fc0a,0x01d3004e,0x035b02d3,0x0365038b,0x01fa02ec,0xfe9d006e,0xfbccfcfd,0xfb46fb45,
0xfc2dfb9e,0xfda7fcd9,0xffd7feb1,0x01ea00ea,0x034202ba,0x03ab0390,0x03430393,0x019d0297,
0xff260068,0xfcf0fdfe,0xfb82fc17,0xfa69faf8,0xf97bf9e6,0xf8a5f920,0xf65ef7c2,0xf34bf4c2,
0xf0e6f207,0xeea7efcc,0xec42ed7c,0xe99deaf6,0xe72be847,0xe643e683,0xe67fe646,0xe789e6e6,
0xe977e85f,0xec53ead2,0xef89edd9,0xf384f174,0xf7e3f5aa,0xfcb9fa33,0x025fff73,0x0867056e,
0x0d410b11,0x0f8d0ec6,0x0fa80fc7,0x0ec80f4e,0x0dc20e38,0x0d210d67,0x0c490ccc,0x0a4f0b85,
0x06970894,0x030604aa,0x005701a3,0xfd84fef8,0xfa58fbff,0xf5fdf86d,0xeedef2cd,0xe53cea4d,
0xda6edfe3,0xd027d518,0xc7e8cbb7,0xc29fc4cf,0xc12fc172,0xc35bc1d9,0xc919c5ca,0xd1cfcd23,
0xdc1ad6d5,0xe6e6e17d,0xf1efec5e,0xfd45f78e,0x081d02e4,0x10c10cc5,0x17501436,0x1ccc1a27,
0x21931f3e,0x265223e3,0x2b9728da,0x31852e7c,0x37723494,0x3bfa3a00,0x3db63d30,0x3d393daf,
0x3b243c58,0x381f39c2,0x33923618,0x2d27309b,0x255e2959,0x1d3c214d,0x15071920,0x0d0e10fb,
0x060b0960,0x00510304,0xfba3fde4,0xf7a5f98f,0xf475f5eb,0xf242f341,0xf0eef180,0xefa0f059,
0xee05eec9,0xed44ed78,0xee17ed7a,0xf098ef2a,0xf41df23f,0xf7f7f60f,0xfbd8f9e8,0xfefffd99,
0xfff9ffd6,0xfee5ff92,0xfe05fe4d,0xfe59fe0f,0xff67fed4,0x00e4000f,0x028801c2,0x04080349,
0x058104bf,0x0739065e,0x084107eb,0x07530806,0x05580669,0x030f042f,0x00cb01f7,0xfedeffb4,
0xfe0dfe5f,0xfc8cfd8e,0xf93ffaf9,0xf639f7aa,0xf3c2f4f6,0xf131f288,0xee4fefcb,0xeac0ec93,
0xe7bfe919,0xe5d6e6ae,0xe4f4e547,0xe4dae4d5,0xe5c3e522,0xe765e68c,0xe9a0e866,0xec75eb00,
0xf014ee21,0xf4d1f253,0xfb0cf7b5,0x0247feab,0x0844058f,0x0be00a55,0x0df90d17,0x0e8d0e61,
0x0f6a0ee1,0x108a0ffc,0x118b1117,0x115211b0,0x0ed81059,0x0b610d11,0x08df09f3,0x070e0809,
0x03c105b4,0xfd84010d,0xf480f94e,0xe8feef0b,0xdc1de293,0xd035d5ee,0xc6b1cb17,0xc09ac320,
0xbecabf2d,0xc0f2bf62,0xc695c362,0xceecca7a,0xd8f1d3cc,0xe36cde2a,0xee3ce8b9,0xf9c4f3f9,
0x0475ff58,0x0cda08f3,0x138a105d,0x18f31661,0x1da91b51,0x22b8201f,0x28702581,0x2ecf2b8e,
0x34ef31fa,0x39e13798,0x3d1b3bbf,0x3e0b3de3,0x3d2f3dc6,0x3b0c3c4f,0x37053946,0x31193448,
0x29c32d88,0x222225fb,0x19db1e12,0x11a015a2,0x0a6a0de5,0x042f0730,0xfe860151,0xf96bfbde,
0xf572f74e,0xf221f3b8,0xef31f0af,0xebe9ed8f,0xe904ea5a,0xe733e7f3,0xe717e6e8,0xe859e796,
0xeac2e960,0xef37ecb1,0xf526f217,0xfb09f838,0xfef4fd51,0x010e0020,0x028601dd,0x03c60333,
0x04c2043e,0x05fa0563,0x06d7066a,0x07970736,0x08c70817,0x0ac409b6,0x0bdd0b8d,0x0b170baf,
0x090f0a2b,0x064d07c5,0x030704a9,0x00bf01af,0xffa1002a,0xfd64febb,0xfa6cfbdd,0xf814f92b,
0xf60ef710,0xf3b9f4f6,0xf059f22e,0xec8fee6c,0xe991eaf4,0xe70be836,0xe585e628,0xe4dae512,
0xe49ce4c8,0xe4a8e47b,0xe584e512,0xe64de5e4,0xe85ae714,0xeca5ea36,0xf302ef9c,0xfac7f6c8,
0x0237fea8,0x085d0573,0x0cc00ad1,0x0fde0e61,0x12b71153,0x1569140e,0x179016a3,0x17d51800,
0x158516fc,0x118d139e,0x0dfb0f96,0x0b480ca1,0x072d0997,0x001a0405,0xf68bfb90,0xeae8f0f9,
0xde47e495,0xd26dd829,0xc89dcd2c,0xc222c4eb,0xbfa9c056,0xc16dc00d,0xc684c39f,0xce33ca0a,
0xd7cfd2d8,0xe20ddce6,0xeccce758,0xf79df245,0x0131fca3,0x08cc0536,0x0eb60c00,0x130710fd,
0x170b14ff,0x1bc41942,0x21931e8c,0x27bd24ac,0x2daa2ac0,0x335e308a,0x385d360a,0x3b6a3a24,
0x3c9d3c3b,0x3bd93c81,0x38e23aa4,0x33f836a3,0x2dbc30f7,0x26812a38,0x1ea2229d,0x16e21ab0,
0x0fd6133f,0x09840c9f,0x03a5068b,0xfe3b00db,0xf91afba4,0xf471f6ae,0xefc5f223,0xeb2eed67,
0xe79ce93e,0xe52ae642,0xe3d5e467,0xe352e36d,0xe4bce3ae,0xe902e68e,0xef9fec13,0xf664f327,
0xfc56f969,0x0181ff1d,0x04e40369,0x065e05d8,0x075f06dc,0x081207ca,0x088d0850,0x096008d5,
0x0b6a0a3e,0x0d8b0c9b,0x0e420e15,0x0da70e1f,0x0bcc0ce1,0x08dd0a6e,0x05c20736,0x037f048c,
0x00d20257,0xfd6aff11,0xfac7fbff,0xf8d2f9b8,0xf711f7fc,0xf49ef603,0xf10af2eb,0xed94ef3a,
0xea49ebf2,0xe78ee8d0,0xe5a4e67f,0xe48be510,0xe309e3da,0xe1c6e253,0xe0b0e13d,0xe021e03b,
0xe15fe074,0xe558e307,0xebc4e84b,0xf38bef8c,0xfc36f7c1,0x04b300aa,0x0b670836,0x11790e82,
0x16831426,0x1ac318b7,0x1df11c91,0x1f241ed4,0x1da61ebf,0x19bf1bdd,0x1548177a,0x1123133b,
0x0b310e80,0x02840733,0xf79afd41,0xeb69f194,0xdf01e535,0xd334d8e8,0xc9b8ce14,0xc360c625,
0xc0d7c191,0xc251c11e,0xc6efc44b,0xce31ca41,0xd791d2ae,0xe21cdcc4,0xec9ae76a,0xf679f1a2,
0xff53fb0a,0x069e0338,0x0bb0096e,0x0ef80d78,0x11bb105b,0x152b1344,0x1a141781,0x1f841cc3,
0x251c224a,0x2b58281a,0x31e42eb5,0x376b34d5,0x3b2e3999,0x3c5b3c18,0x3b053bf8,0x37a2398c,
0x32a73561,0x2bea2f74,0x24b62848,0x1da12127,0x16bb1a24,0x102a1364,0x0a070d0c,0x0438071f,
0xfe1b0132,0xf7b4faf7,0xf0f7f451,0xeb2fede1,0xe6c0e8ce,0xe3a9e512,0xe0f0e250,0xdeccdfab,
0xdf2ade92,0xe2a7e08a,0xe8b8e57f,0xef77ebff,0xf748f340,0xff09fb42,0x04b30243,0x07de0674,
0x09c9090a,0x0a5d0a2d,0x0a910a77,0x0b9d0aea,0x0dde0ca7,0x0fab0ef1,0x10321016,0x0f4c0ff0,
0x0d840e74,0x0b540c6d,0x096c0a4d,0x075b088e,0x03c905af,0x0091020b,0xfe21ff4c,0xfbdefd04,
0xf978fab2,0xf684f822,0xf302f4bf,0xef6ef147,0xeb77ed6b,0xe849e9c9,0xe62de707,0xe4b1e57f,
0xe2e1e3cd,0xe096e1db,0xddbcdf1f,0xdc13dcb3,0xdc55dbee,0xdef4dd54,0xe411e13e,0xead8e73b,
0xf41eef29,0xfe50f944,0x07ff0332,0x10b80c97,0x17b51463,0x1d2d1aac,0x20901f1e,0x224c219c,
0x22822298,0x20c921e9,0x1d581f2c,0x18d01b4e,0x119c159f,0x07410ccb,0xfae60132,0xedecf475,
0xe0d2e75c,0xd49ada76,0xcb3acf84,0xc51cc7b4,0xc2b2c37c,0xc346c2a2,0xc69bc49e,0xccabc947,
0xd590d0ce,0xe031daca,0xeab2e591,0xf43cef97,0xfce3f8a9,0x043300ca,0x092f06fa,0x0c1b0ad9,
0x0e1c0d20,0x10d70f4e,0x14d612b3,0x19da1739,0x1fd81cbc,0x269a232c,0x2dad2a19,0x347f3138,
0x395a3741,0x3b813abb,0x3ba23bce,0x39f83b08,0x360e384b,0x30333345,0x29942cf4,0x22a72623,
0x1b7d1f19,0x149817fc,0x0e1a114a,0x07e50afe,0x018d04bf,0xfa60fe1c,0xf2a1f67d,0xebccef08,
0xe664e8e3,0xe22fe43f,0xde0fe022,0xdabadc22,0xda94da31,0xddaddbcf,0xe25edfef,0xe874e51f,
0xf0b1ec5f,0xf9e9f550,0x0190fdff,0x073804b3,0x0a560912,0x0b7f0b18,0x0c1e0bbf,0x0d6b0cb2,
0x0f020e3d,0x103c0fae,0x10e810af,0x107f10d0,0x0f7a100b,0x0e870ee9,0x0e0f0e4a,0x0c2e0d72,
0x08b60a7e,0x05b5070e,0x03740490,0x0112024b,0xfe4effc3,0xfaf4fcb2,0xf764f92d,0xf348f56b,
0xef0cf11b,0xeb3aed0f,0xe836e9a5,0xe591e6d7,0xe32be46a,0xdf9fe191,0xdbe2dd9f,0xd993da85,
0xd8e9d90b,0xda50d954,0xddc5dbd3,0xe2e7e012,0xeaa0e673,0xf4b0ef5d,0x005cfa7d,0x0b1d05f0,
0x147b0fff,0x1b871858,0x1fd31df1,0x22de216d,0x25032416,0x252b255d,0x23432484,0x1e832148,
0x16731ae0,0x0b861151,0xfee3054f,0xf1c7f857,0xe4aaeb2f,0xd8c2de7d,0xcee9d384,0xc851cb20,
0xc54dc673,0xc4acc4b0,0xc688c540,0xcb7cc8a3,0xd38ecf20,0xdddfd88f,0xe884e341,0xf251ed8b,
0xfb5cf6f3,0x033fff7f,0x0913067b,0x0ca00b1d,0x0ea80db3,0x10a60fa4,0x131a11c2,0x170914d0,
0x1ceb19c5,0x23a1203b,0x2aea272e,0x321b2ea9,0x373f3502,0x3a1638e7,0x3b213ad1,0x3a4b3af8,
0x374c3915,0x326f3509,0x2c5e2f88,0x256328fa,0x1e3d21c8,0x17391aaf,0x108513de,0x09970d12,
0x02a40628,0xfac9fede,0xf2a1f6a7,0xeb33eece,0xe4eae7e4,0xdf57e21f,0xd9cfdc86,0xd5dfd780,
0xd573d52a,0xd885d6a1,0xdd7cdacc,0xe4a9e0d0,0xedc2e8f8,0xf7f8f2d9,0x0184fce1,0x093705bd,
0x0de70bea,0x10510f4d,0x11b81117,0x12c91245,0x1344131d,0x136a1355,0x13641385,0x12e41330,
0x1197124e,0x10d61110,0x10a810d0,0x0e900fed,0x0b5e0cf2,0x08cf09f9,0x066c07ae,0x034804f5,
0xff51016a,0xfb1bfd2d,0xf6eaf913,0xf247f499,0xee0cf029,0xe9f0ebe9,0xe681e82c,0xe3a9e4f3,
0xe114e278,0xdd7edf60,0xda15dba6,0xd7e1d8d4,0xd70dd741,0xd818d757,0xda7fd925,0xdee0dc5b,
0xe5afe206,0xef80ea1c,0xfbf3f59d,0x086c023b,0x13e80e67,0x1cb118b4,0x22931fe8,0x26dc24dd,
0x29fc288f,0x2c0f2b27,0x2bd02c6c,0x26a829e5,0x1d0a224a,0x100f16ed,0x015408d5,0xf234f9ac,
0xe4a8eb2c,0xd921dea4,0xcf98d40b,0xc91dcbf8,0xc569c6fe,0xc3a6c447,0xc44bc3a7,0xc7b8c59e,
0xce6bcab1,0xd7abd2cb,0xe216dcd5,0xec7ee74e,0xf69bf19e,0xffc2fb61,0x06f3039e,0x0bfd09bf,
0x0f240dc6,0x10ee1028,0x12ad11b5,0x16181416,0x1b8b18a0,0x221d1eb5,0x295e25b5,0x30332cee,
0x35893313,0x394737a2,0x3b3a3a7b,0x3b043b69,0x38b23a0e,0x3528371b,0x2ff332c8,0x29562cc5,
0x21ed25b2,0x1aa41e39,0x133b16fd,0x0bb40f77,0x03c307d4,0xfb79ff99,0xf37ef76e,0xebe3efa0,
0xe4fde863,0xddfee181,0xd77eda91,0xd381d50f,0xd34bd2e7,0xd638d47b,0xdb74d881,0xe316defa,
0xecc5e7c7,0xf6c2f1c6,0x0085fbb8,0x090704fa,0x0f890c8b,0x13c411f7,0x15f31500,0x16e7169d,
0x166e16cd,0x153b15d4,0x143414a8,0x130713bc,0x114b1221,0x106210b9,0x0f60100d,0x0cf90e48,
0x0aac0bbd,0x08d309bb,0x06ad07d7,0x03a4054f,0xff7501a3,0xfb41fd4d,0xf6f2f92d,0xf275f4ab,
0xeddef037,0xe989ebac,0xe544e75d,0xe1c2e367,0xde84e029,0xdb9edcfa,0xd967da6f,0xd7d7d885,
0xd789d77e,0xd877d7ee,0xda1bd915,0xddd7dbb9,0xe3dfe076,0xed77e844,0xf93bf32b,0x0649ffac,
0x12870cb0,0x1c4d17bc,0x23902039,0x28862652,0x2c012a56,0x2f182da4,0x2f702fdf,0x2ad22db3,
0x21d226de,0x14fd1bc5,0x05fb0daf,0xf6a1fe2c,0xe8c2ef80,0xdc97e274,0xd2bfd74b,0xcbc2cef0,
0xc6e1c911,0xc3fdc529,0xc376c370,0xc597c429,0xcaaac7c7,0xd24cce31,0xdbcfd6e0,0xe638e0f4,
0xf0a2eb7d,0xfa42f58f,0x02c0feaa,0x09a1066b,0x0e760c5e,0x11361005,0x13571235,0x168614c3,
0x1b2818a8,0x21561e15,0x27db24a3,0x2da82add,0x32cb304a,0x373e3524,0x3a4538fd,0x3b123af3,
0x39e63ab9,0x36e438a1,0x321b34b7,0x2b9d2f14,0x23e327d7,0x1bf71feb,0x13a717da,0x0aea0f5f,
0x01d10660,0xf95bfd71,0xf1b7f578,0xea95ee13,0xe37be716,0xdc2adfca,0xd5f4d8c8,0xd29bd3df,
0xd2dad24a,0xd601d40d,0xdbe1d8ac,0xe3f8dfa2,0xed59e8a5,0xf67ff1f5,0xfefdfae5,0x06f202f0,
0x0ec50ae7,0x155d1252,0x199117cf,0x1abf1a82,0x19a21a6d,0x176d1891,0x15401657,0x12bc1408,
0x10891189,0x0ec10fab,0x0c440d9e,0x0a1f0b0a,0x08db096f,0x07c50859,0x0688072b,0x046405ab,
0x010902c6,0xfd62ff4f,0xf90ffb45,0xf451f6c6,0xef36f1c1,0xe9deeca0,0xe47de712,0xdfb6e212,
0xdb92dd7c,0xd900da15,0xd7a1d839,0xd716d736,0xd7a5d73f,0xd8c7d827,0xdaf6d9b6,0xde39dc75,
0xe3d1e08c,0xeca2e7f3,0xf78bf1cc,0x046dfddf,0x10fb0ae7,0x1bb7169d,0x24352047,0x2a6c2793,
0x2f052cdd,0x324930e0,0x329c32e3,0x2f27316e,0x269b2b87,0x1a0420b9,0x0b5a12cb,0xfcb703f2,
0xeedff5b5,0xe25ce85f,0xd83edcfb,0xd08cd41f,0xcaeccd85,0xc705c8be,0xc508c5c4,0xc541c4d7,
0xc814c652,0xcd9cca8b,0xd567d143,0xde99d9e6,0xe825e35f,0xf1c9ecf3,0xfb25f688,0x03a5ff97,
0x0a01071b,0x0e550c5b,0x11d7101c,0x156c1393,0x19f2177d,0x1fc91cc1,0x25e422e1,0x2b9d28d0,
0x30f12e58,0x35e33381,0x397f37f4,0x3b233a87,0x3af33b44,0x38fb3a35,0x3527374b,0x2f88328f,
0x28632c21,0x1fee2459,0x16941b4b,0x0c8611a3,0x02870765,0xf9c4fe05,0xf1c8f5b1,0xea36ee08,
0xe226e633,0xda8bde2e,0xd4bfd763,0xd184d2ba,0xd139d10f,0xd3f8d227,0xd9f0d695,0xe236dded,
0xeae8e68f,0xf38eef49,0xfbb2f7b3,0x0369ff91,0x0b73075f,0x139f0f9b,0x1a02172f,0x1cdc1bea,
0x1c521cf1,0x1a2f1b54,0x172c18c7,0x1418158b,0x120512f4,0x0fa610fd,0x0d0f0e35,0x0c240c64,
0x0bdb0c0a,0x0af20b73,0x09f70a7f,0x0830092f,0x05b7070e,0x0213040d,0xfd89ffe1,0xf84ffaff,
0xf288f587,0xebd3ef39,0xe533e87f,0xde8ae1d8,0xd926db8d,0xd5f6d758,0xd429d4ee,0xd3add3be,
0xd436d3e2,0xd56cd4ac,0xd7a7d67e,0xdab5d8fa,0xe02add1b,0xe7ece3bc,0xf2bcecf0,0xff8af907,
0x0ca90629,0x18ed12fa,0x23831e6c,0x2c762830,0x33353037,0x36b8355b,0x378c3772,0x3454369c,
0x2bf030b4,0x1fac2633,0x117e18ab,0x02fd0a38,0xf4a0fbbf,0xe7ccedf3,0xdd60e244,0xd564d91c,
0xcfb1d248,0xcba4cd83,0xc8cdca0b,0xc765c7e0,0xc81cc76c,0xcb51c963,0xd100cde3,0xd84ad48c,
0xe07ddc48,0xe954e4d4,0xf28eede6,0xfb82f730,0x02b6ff5a,0x083005a0,0x0cd70a90,0x11440f0b,
0x164f13a2,0x1c3e193c,0x22781f55,0x28a6258f,0x2eaf2bb1,0x3445318c,0x38c436b5,0x3baf3a6c,
0x3d0f3c95,0x3c953d19,0x39dc3b7d,0x34ff37aa,0x2e2e31d9,0x255b29fb,0x1b212063,0x103515a7,
0x06550b10,0xfdb401e3,0xf598f9a5,0xec99f147,0xe311e7c5,0xdaf4debd,0xd539d7bf,0xd197d340,
0xcfa7d046,0xd17dd008,0xd745d3ff,0xdf18db0b,0xe7a5e350,0xf004ebea,0xf80ff40d,0xfff5fc00,
0x082b03fe,0x10580c5f,0x170d13f0,0x1b8a199d,0x1d891cd0,0x1d401db3,0x1b0c1c45,0x18a619c9,
0x15a4175a,0x1178138f,0x0e980fbc,0x0dc60e05,0x0d6f0da8,0x0c860d05,0x0b260be0,0x09c30a68,
0x07e90907,0x049c0674,0xffc0024f,0xfa56fd18,0xf3d4f749,0xec85f028,0xe4b9e8bd,0xdd09e0b4,
0xd791d9fa,0xd431d5ac,0xd260d31f,0xd184d1e0,0xd1a9d166,0xd379d269,0xd605d4af,0xd9aed7b0,
0xde8adbf1,0xe5ade1b1,0xefbdea71,0xfb67f56a,0x07ed01a3,0x14700e37,0x204a1a74,0x2b4025ef,
0x33a22fe4,0x38b83686,0x3af43a48,0x38bd3a7c,0x313935a0,0x258c2bbe,0x17eb1ee9,0x094c10a3,
0xfae101f2,0xee1cf446,0xe336e869,0xda5ede83,0xd3b2d6ca,0xce78d0f0,0xca61cc46,0xc783c8c9,
0xc673c6af,0xc7f8c6e1,0xcbe0c9a6,0xd1b4ce93,0xd8bcd51a,0xe0acdc9a,0xe9c7e51b,0xf313ee80,
0xfb49f765,0x023efedb,0x08500567,0x0ddd0b1a,0x13b810b9,0x1a0216cd,0x20df1d60,0x27f02466,
0x2ed32b74,0x3508320c,0x3a4837c6,0x3e693c81,0x40dc3fdf,0x414b4156,0x3f9140c7,0x3b343dac,
0x343f3814,0x2ab52fc9,0x1f0f2510,0x13321908,0x087d0dad,0xff0d03a8,0xf5a8fa78,0xeb5af093,
0xe1bbe658,0xd9fadd87,0xd49cd712,0xd0acd275,0xcef8cf6e,0xd11dcf8c,0xd668d37f,0xdd5bd9b3,
0xe51de13d,0xecd1e8fa,0xf499f0ac,0xfcc1f89c,0x05600114,0x0cf50962,0x13331034,0x189515fe,
0x1cd91af3,0x1e761e06,0x1dc51e50,0x1bb61cf9,0x176b19cc,0x12ac14f6,0x0f5d10c0,0x0dd70e6e,
0x0cf90d66,0x0bd30c7a,0x0a910b1d,0x0a270a4e,0x098309e7,0x07a108d5,0x03dd05f0,0xfe720170,
0xf763fb03,0xef60f393,0xe63aead6,0xddc3e1cc,0xd72ada33,0xd2bbd4ac,0xd046d153,0xcee0cf71,
0xcf46cece,0xd13bd01f,0xd49fd2b9,0xd8f5d6c6,0xddeedb40,0xe4f2e134,0xedc6e91d,0xf847f2d4,
0x03d7fdfa,0x106a09ff,0x1d3c16e7,0x28dc234e,0x320e2dca,0x389635b1,0x3bab3a95,0x3abf3bc2,
0x34d93874,0x2a7e301c,0x1d77243f,0x0ef21643,0x00b007b4,0xf38ef9f3,0xe7fbed95,0xde44e2d7,
0xd68dda2d,0xd0bfd36c,0xcc83ce7e,0xc91ccabb,0xc6fcc7d8,0xc6dcc6a0,0xc92ac7b3,0xcdcacb43,
0xd3c2d0a7,0xdafcd732,0xe370df16,0xec5fe7e1,0xf50cf0c0,0xfd63f954,0x0484011b,0x0b0107c9,
0x112f0e21,0x1785144f,0x1e841aec,0x2600223f,0x2cf8299a,0x3334301b,0x39643653,0x3edf3c47,
0x42bf4110,0x445c43db,0x43674437,0x3f7141cf,0x38793c54,0x2e5a33cc,0x2245286b,0x16501c2f,
0x0ba210c8,0x01cf06bc,0xf777fcb6,0xed41f238,0xe468e8a7,0xdd62e0a1,0xd7e3da8b,0xd420d5b1,
0xd2fad32c,0xd4fed3a3,0xd8f2d6c9,0xde78db8e,0xe486e179,0xeb1de7bb,0xf243ee91,0xfa4cf633,
0x01f9fe55,0x0809051b,0x0d850adb,0x12c6101e,0x179c154e,0x1b5b199e,0x1d9c1cc2,0x1c461d86,
0x180c1a4a,0x13e515df,0x10c7122f,0x0ec70fa9,0x0d7f0e1d,0x0bd80cb2,0x0abd0b2d,0x0a200a6a,
0x09ad09ec,0x085e0925,0x05c30753,0x00c50387,0xfa63fdc0,0xf200f670,0xe8aded4c,0xe019e44c,
0xd89fdc29,0xd321d597,0xcf77d11f,0xcda5ce40,0xcde1cd92,0xcfe7cea1,0xd3ded1b7,0xd857d60d,
0xddebdaf2,0xe4bbe137,0xecb8e888,0xf66cf161,0x0188fbcd,0x0dcd0791,0x1a74142c,0x25b32052,
0x2f0f2a95,0x36403305,0x3a5838ab,0x3ad53b1e,0x36ca396d,0x2e2e32f5,0x2223287f,0x14cf1b7f,
0x076b0e17,0xfa4b00cd,0xee1df407,0xe34ae887,0xda08de6d,0xd2f9d642,0xcd80d014,0xc8eacb1b,
0xc550c6f8,0xc38bc424,0xc4a0c3ad,0xc83fc62f,0xcdbfcabf,0xd503d13b,0xdd38d90b,0xe5d0e171,
0xef31ea68,0xf855f3e0,0x00d0fc9a,0x08c404e8,0x0fea0c6c,0x16a3134d,0x1db91a11,0x254d2190,
0x2c2228ce,0x32be2f69,0x394b360f,0x3f8f3c77,0x44bc425f,0x47a24688,0x47a5480e,0x445d4671,
0x3d9a416d,0x337638e0,0x27b52dad,0x1bbb21ac,0x1080160c,0x05280ae8,0xf9e7ff6c,0xf017f4cc,
0xe7cbebbc,0xe09de42d,0xda4add33,0xd6a8d81d,0xd5b6d5e4,0xd685d5f6,0xd8dfd77d,0xdc49da7a,
0xe0b7de5f,0xe63fe34e,0xed7de99e,0xf5dff1b9,0xfcc0f98a,0x0267ffaa,0x077f04fb,0x0c6c09fb,
0x11600ed3,0x16b8140e,0x1a7418fd,0x1a901ae8,0x189719b9,0x15c1173c,0x12d21442,0x10651188,
0x0e390f4e,0x0c9a0d48,0x0bbb0c24,0x0b260b58,0x0acc0afe,0x0a1a0a88,0x07ac0938,0x0339059e,
0xfcf40064,0xf4d9f90a,0xec58f09c,0xe3cee80f,0xdbe0dfaf,0xd569d879,0xd065d2a2,0xcdebcedd,
0xcd31cd56,0xcef7cdc1,0xd2a2d0a8,0xd77bd4e2,0xdd72da62,0xe3d2e097,0xeb19e748,0xf434ef6a,
0xff19f981,0x0ad904da,0x16be10e5,0x21451c31,0x2a612603,0x31e12e57,0x374f34ee,0x397038d8,
0x37783901,0x30cd34c0,0x266e2be6,0x1aa220a2,0x0e211475,0x017707c1,0xf55bfb54,0xea26ef9a,
0xe0b3e539,0xd8e3dc9c,0xd216d567,0xcbdacee6,0xc65ac8ef,0xc2c2c442,0xc1cbc1eb,0xc38ec25f,
0xc823c585,0xceb6cb45,0xd63ed259,0xdf1fda7a,0xe8ebe405,0xf2a2edc4,0xfc6cf793,0x05840113,
0x0dcc09be,0x153c1193,0x1c7518d7,0x23611ffa,0x2a5b26ca,0x31a92e0d,0x389c3528,0x3f3a3c00,
0x44ad422b,0x480e46a9,0x487e48b3,0x4595477f,0x3ecd429f,0x35513a4d,0x2a733009,0x1f0724b8,
0x13741947,0x079f0d91,0xfcb601eb,0xf39ef7f6,0xebb0ef9c,0xe3c2e7b1,0xdd83e055,0xd9dbdb5c,
0xd84ad8e7,0xd79ad7cd,0xd83dd7c6,0xda2dd8fe,0xdd6fdbac,0xe242df8f,0xe94ce588,0xf0cbed31,
0xf739f413,0xfcd9fa32,0x01b4ff53,0x06600401,0x0bcc08f7,0x11770ebe,0x155113b1,0x17da16a3,
0x198918de,0x196f19b8,0x17e218c9,0x157b16cd,0x12d01411,0x114611eb,0x103e10bd,0x0f7f0fdb,
0x0e950f0b,0x0d030e01,0x09ca0b8d,0x054107bf,0xfec80236,0xf756fb1e,0xef03f351,0xe5d8ea7b,
0xdd11e14e,0xd594d926,0xd000d273,0xccaace24,0xcb8bcbbb,0xcd3dcc1e,0xd097ceb4,0xd587d2f1,
0xda91d812,0xdff9dd1a,0xe70ae341,0xf057eb6d,0xfb64f5ad,0x077d0173,0x12c60d47,0x1d3a1814,
0x26922215,0x2ec12ac5,0x35363250,0x387f3753,0x37a938a6,0x32603588,0x2a052e76,0x1fce2529,
0x14501a26,0x08650e59,0xfcdd028c,0xf295f787,0xe99fedf8,0xe117e561,0xd888dccc,0xd06ed468,
0xc942cca3,0xc406c659,0xc15ec260,0xc1a6c11c,0xc4bbc2e6,0xc986c6eb,0xd055cca3,0xd93cd4a2,
0xe2e5ddfa,0xed41e805,0xf775f26d,0x0120fc5a,0x0a1c05b9,0x12790e5e,0x19fd165f,0x21201d7e,
0x28fb24ff,0x31112d01,0x38ef3513,0x3fb53c81,0x44f74287,0x483846e9,0x48d948ea,0x45ae47c7,
0x3ef742af,0x36183ab9,0x2be2311e,0x20952661,0x14411a82,0x08740e20,0xfe7c033c,0xf61cfa21,
0xee24f22a,0xe6ceea45,0xe13fe3ce,0xdd4ddf1b,0xda64dbbc,0xd88fd955,0xd788d7ec,0xd84dd7a8,
0xdae5d95e,0xdf7edcf2,0xe57ae262,0xebcce8a2,0xf263ef1e,0xf872f57b,0xfda5fb2b,0x02de0023,
0x08d605db,0x0d5b0b6b,0x10a80ef4,0x14cc129f,0x190d16ff,0x1bbd1ab9,0x1b861c03,0x18e31a5e,
0x16321770,0x13f51511,0x12411301,0x111b119d,0x106610c8,0x0e6e0f99,0x0b690d12,0x06640931,
0x001a0345,0xf967fcd4,0xf1c7f5bc,0xe933ed8c,0xe049e4c9,0xd81bdbe6,0xd215d4f0,0xcdadcf97,
0xcc36cc81,0xcd73cc8c,0xd0fdcef9,0xd57fd33a,0xda31d7cb,0xdfb9dccc,0xe6d1e30a,0xefedeb13,
0xfb1cf55b,0x063700cf,0x10580b54,0x1a391559,0x23701ef1,0x2bb727b6,0x32a52f68,0x36fe354b,
0x371e3799,0x33c835d2,0x2d813103,0x24ab2962,0x19b81f65,0x0db713cb,0x023707c9,0xf830fd0b,
0xeebaf378,0xe55fea01,0xdc68e0d9,0xd3bed80a,0xcbd0cf96,0xc5ddc888,0xc283c3cf,0xc202c1fa,
0xc324c267,0xc65dc468,0xcc49c903,0xd3f8cff4,0xdd34d86a,0xe736e23b,0xf0fcec20,0xfa64f5c2,
0x0371fee9,0x0c2607ec,0x13f5101a,0x1c2817f2,0x25152089,0x2e4729bd,0x36933297,0x3d613a2e,
0x42af403f,0x45fe449b,0x469946ba,0x43984586,0x3dd34102,0x35e03a1b,0x2c5a314a,0x215f270a,
0x15a21b7c,0x0b15101a,0x02670687,0xfab8fe92,0xf376f6ef,0xed82f055,0xe8a9eafb,0xe464e67a,
0xe100e289,0xde31df9e,0xdbb2dcca,0xdaf3db10,0xdc70db62,0xdf90dde7,0xe361e160,0xe862e5b3,
0xee4eeb41,0xf4baf18e,0xfad9f7c8,0x0151fe0b,0x06ec0465,0x0a7f08db,0x0e0a0c2d,0x1256101e,
0x172514be,0x1b351958,0x1d281c8b,0x1c991d17,0x1a921bc1,0x17d5192f,0x158a16a1,0x13e214a3,
0x11d11301,0x0eec1064,0x0af50d2b,0x05790854,0xff720288,0xf8bafc2d,0xf161f522,0xe92fed69,
0xe045e4ab,0xd880dc38,0xd1dfd507,0xcd62cf44,0xcb97cc29,0xccc9cbcb,0xcfddce37,0xd3a3d1af,
0xd858d5e2,0xde08db16,0xe51fe15e,0xee6ae97b,0xf8d3f397,0x02fdfdf3,0x0cdb07ef,0x16ac11c5,
0x20731b9a,0x298e2526,0x314a2d9f,0x36523455,0x373f3734,0x34ea3673,0x2fd632b3,0x27d32c38,
0x1d6b22da,0x11d817a7,0x06c60c2e,0xfcbf01b0,0xf2f3f7d9,0xe98fee2c,0xe092e512,0xd793dc0e,
0xcf0fd334,0xc815cb4e,0xc3b3c58a,0xc169c25a,0xc10ec0ee,0xc3abc1ef,0xc8f9c606,0xd083cc7c,
0xd9f6d518,0xe3f4def1,0xed9fe8df,0xf6edf24f,0x0018fb8c,0x08dc0483,0x11ae0d40,0x1aeb1632,
0x24e81fda,0x2e6e29cf,0x36cf32c9,0x3d983a6c,0x42844047,0x45464440,0x4509458b,0x421243de,
0x3cce3faf,0x356b3963,0x2b9230c3,0x202425f9,0x15251a7d,0x0ba01026,0x03aa0792,0xfc3cffc6,
0xf67af917,0xf269f45c,0xee16f055,0xe9b7ebc5,0xe616e7ed,0xe215e416,0xde5ce020,0xdc87dd1e,
0xdd15dc8e,0xdec1ddd9,0xe1b2e00d,0xe593e37c,0xeb14e831,0xf13fee15,0xf814f494,0xfe80fb7f,
0x02d700e5,0x06c504c4,0x0af708d6,0x0f740d2d,0x141511c5,0x1827163b,0x1b5f19db,0x1d221c8f,
0x1c7c1d0d,0x1a461b8c,0x17ee18fa,0x15dd16fa,0x132b148d,0x0fa91196,0x0b1a0d7c,0x05fe0897,
0x00300332,0xf9c8fd06,0xf2d5f66e,0xeabeeedf,0xe2c1e6b6,0xdac8debb,0xd40fd724,0xcf90d18a,
0xcdc1ce3f,0xce7acdf4,0xd035cf35,0xd372d1a4,0xd7fbd595,0xdd82da99,0xe479e0c5,0xec95e879,
0xf4f1f0b6,0xfe1cf973,0x079202c9,0x115e0c77,0x1b381640,0x24fb2030,0x2d9c297f,0x33e93128,
0x369535be,0x357c3675,0x314d33c0,0x2a252e13,0x20f225bf,0x16b71bdc,0x0c021174,0x00d0066d,
0xf640fb5e,0xeca7f162,0xe310e7de,0xd971de3e,0xd0a6d4d9,0xca07cd07,0xc55bc781,0xc257c3a1,
0xc152c186,0xc2d4c1c0,0xc70ec490,0xcde9ca33,0xd6b6d22d,0xe032db75,0xe9c1e4f2,0xf35fee9d,
0xfc8df7fc,0x05da0131,0x0f6d0a8d,0x1a1514a2,0x24e81f97,0x2e9029e2,0x370f32f9,0x3dee3ab9,
0x42ae4098,0x44bf4411,0x441b44bc,0x40f942d3,0x3bc73e9a,0x34313854,0x2a442f72,0x1fa624eb,
0x15c31a9a,0x0cea1134,0x04d908ca,0xfea5016f,0xfa85fc5b,0xf6e5f8c7,0xf2dbf4e7,0xef03f0e0,
0xeac8ed06,0xe607e873,0xe1fae3c9,0xdf64e08b,0xddc2de7b,0xdd87dd62,0xdef2de1e,0xe206e038,
0xe6e3e440,0xed80ea03,0xf48df11b,0xfa04f784,0xfec1fc5d,0x03b60139,0x089e0637,0x0d030ae5,
0x10ef0f0c,0x147812b0,0x17e91646,0x1a9f1956,0x1c631bb7,0x1c851c9e,0x1b701c1f,0x19c91a9c,
0x177b18e0,0x13401586,0x0e3c10c7,0x08750b80,0x01fe053d,0xfb0bfea0,0xf31bf731,0xeb12ef0b,
0xe2eae70c,0xdb75def8,0xd5d0d861,0xd264d3cc,0xd10bd18a,0xd0ebd0d1,0xd25ed16b,0xd516d3a0,
0xd8bed6c1,0xddebdb2a,0xe3fce0ef,0xea3ce70c,0xf195edb3,0xfa3cf5c5,0x03f0fefe,0x0db208d4,
0x1799129d,0x21671c8f,0x2a782614,0x31ab2e68,0x3598341c,0x354e35f9,0x318a33c9,0x2b1c2ea3,
0x22c4271c,0x19101e1b,0x0da51391,0x01c00792,0xf74bfc59,0xede9f28a,0xe480e93f,0xdb0bdfb6,
0xd2bcd6bb,0xcbaacf0e,0xc5d7c88e,0xc1dcc399,0xc01bc0b0,0xc106c02b,0xc566c2c5,0xcc79c8b3,
0xd4dcd093,0xddd8d93f,0xe798e2b2,0xf119ec65,0xfa7ef5c5,0x042aff4d,0x0e730936,0x198b13ef,
0x24531eff,0x2e94298a,0x37cc3362,0x3f343bcb,0x43e641ea,0x459e451e,0x4490456a,0x4112431d,
0x3afb3e67,0x325c36e6,0x28b52d87,0x1f3023e8,0x16281aa1,0x0d27119d,0x05c4091d,0x01450328,
0xfdfdffaf,0xfa59fc2c,0xf6f0f8a0,0xf325f51e,0xee8ff105,0xe997ebf9,0xe5c8e791,0xe212e3f7,
0xdebde040,0xdce9dda2,0xdce8dcac,0xded0dd96,0xe35de0b8,0xe9dee68a,0xefa8eceb,0xf51bf258,
0xfaf6f7f9,0x00fafdf8,0x068503d5,0x0b1108eb,0x0ee90d02,0x127510c8,0x150513d0,0x17551635,
0x19ce1878,0x1c381b29,0x1d2b1ccd,0x1d311d6a,0x1ad31c4f,0x169318e2,0x10fb13e7,0x0a760dca,
0x0384071e,0xfb43ff89,0xf295f6f1,0xe98cee1f,0xe11fe520,0xdaeeddb4,0xd750d8c4,0xd5d6d679,
0xd4cbd53a,0xd52ad4c0,0xd6e5d5f6,0xd8ccd7c7,0xdbceda22,0xdf9addb4,0xe30ae156,0xe76be4f5,
0xede2ea68,0xf5eef1c4,0xff35fa62,0x09bd0461,0x14a10f20,0x1fc41a31,0x2a772543,0x32aa2f00,
0x3689353c,0x35b036a0,0x31b633ff,0x2b962eda,0x2413280c,0x1a471f7b,0x0ee914b0,0x03a70935,
0xf905fe3a,0xef5ff414,0xe631eabe,0xdd8de1c1,0xd55bd975,0xcd8dd157,0xc6f4ca0e,0xc273c470,
0xc02bc10f,0xc097bff5,0xc443c20b,0xca34c709,0xd16fcdaf,0xd9e9d57b,0xe357de88,0xed4ee848,
0xf780f25d,0x0253fcd6,0x0d8807e9,0x18b41321,0x23aa1e37,0x2e372908,0x379d3327,0x3eb53b72,
0x436e415b,0x455044c3,0x44404522,0x401d429c,0x38f43cd4,0x309a34d5,0x28212c53,0x1fb423f3,
0x16cb1b4d,0x0e8d1275,0x08eb0b5b,0x051206f7,0x0132031f,0xfd8cff56,0xf9eefbc7,0xf604f807,
0xf1abf3d5,0xedadef9d,0xe94feba7,0xe44be6c4,0xdfa2e1de,0xdc9bdde1,0xdb46dbb3,0xdc8fdb86,
0xe05dde46,0xe4a1e27a,0xe98ae6f0,0xef71ec61,0xf60df2b4,0xfc97f95d,0x026aff9c,0x07cb051b,
0x0c8c0a4e,0x0ff00e65,0x12351139,0x143d1320,0x1714159d,0x1a4a1898,0x1df91c35,0x1fc71f3a,
0x1f1b1fc2,0x1b891db5,0x15e318d9,0x0f2b12a4,0x07310b5f,0xfe6e02d6,0xf48af9ab,0xeac8ef7f,
0xe288e66f,0xdd19df62,0xda9cdba6,0xd903d9b1,0xd8c7d8b7,0xd981d91b,0xda5cd9e8,0xdbf7db07,
0xde0ddd0f,0xdf82ded7,0xe153e043,0xe4f8e2d7,0xeabce79b,0xf20fee39,0xfb1cf65c,0x05c00044,
0x11b00b8f,0x1e671808,0x2a3b248f,0x326b2efc,0x35703484,0x34813567,0x305832bc,0x2a5a2d91,
0x221e268a,0x18161d36,0x0d7512df,0x023c07e0,0xf74dfca8,0xedcaf25b,0xe5a0e992,0xde0ae1cf,
0xd67ada4d,0xcf13d2b1,0xc8dccbbb,0xc48bc67c,0xc289c335,0xc340c294,0xc630c478,0xcb21c867,
0xd214ce67,0xda3fd603,0xe35adebb,0xed57e836,0xf80df2a2,0x030cfd89,0x0dec087e,0x18ce135d,
0x23b81e46,0x2dfa28ff,0x36c9329f,0x3dab3a79,0x42524053,0x440c4398,0x425a43a3,0x3d92404b,
0x36d33a56,0x2f113311,0x27192b0e,0x1ecc2309,0x16af1a9d,0x10151323,0x0af50d6d,0x06510895,
0x025d0441,0xfeb0008c,0xfae2fcc9,0xf72bf8fc,0xf39cf560,0xefbdf1ca,0xead8ed6b,0xe579e81d,
0xe0f9e314,0xddd1df40,0xdc57dcbd,0xdd2ddc90,0xdec2ddf2,0xe16cdfcd,0xe606e38d,0xebb6e8c0,
0xf211eed1,0xf89bf55b,0xff3dfbe2,0x061702b0,0x0bf0092e,0x10620e63,0x132f11ef,0x152a1443,
0x170115fc,0x1a55187f,0x1df31c2d,0x21331fb1,0x22062219,0x1f0520f9,0x197a1c7c,0x11b815d5,
0x08b60d51,0xfe7003cb,0xf387f8dd,0xe9aeee75,0xe1b1e560,0xdc6adeb8,0xd966daaa,0xd881d8ad,
0xd927d8c0,0xda3cd9a1,0xdbfcdb05,0xddfcdd02,0xdf0ddeb4,0xdf7bdf35,0xe0e5dffe,0xe41ee248,
0xe930e666,0xf056ec82,0xf957f49c,0x043bfe8a,0x11070a68,0x1ec917e9,0x2b1a2554,0x32f82fb5,
0x36533523,0x358d366f,0x319233e7,0x2af32e96,0x225226cf,0x18ba1d9a,0x0e6913b4,0x02d908c2,
0xf7a7fd10,0xee43f2b6,0xe5f6ea18,0xddbfe1dd,0xd5acd9a8,0xcea3d1ec,0xc948cbca,0xc5b3c72f,
0xc48fc4d7,0xc501c4a0,0xc6cdc5ac,0xcaddc887,0xd124cdc2,0xd8f3d4e6,0xe21add59,0xec89e72b,
0xf765f1f1,0x023dfcd2,0x0d2107ad,0x183312a1,0x23131dc0,0x2cc72815,0x34db310a,0x3b31383c,
0x3f863da2,0x40d940a6,0x3ead4024,0x3a8c3cc0,0x35463811,0x2f093234,0x27ec2bab,0x205d2412,
0x19d21ce8,0x1471171d,0x0eea11a6,0x0a030c69,0x057607b3,0x0137034a,0xfcfbff12,0xf991fb2c,
0xf5e7f7db,0xf16af3cc,0xebe9eeb8,0xe6c4e938,0xe266e478,0xdef2e085,0xdcf8ddcc,0xdb95dc46,
0xdb23db1a,0xdd41dbd4,0xe1c9df4d,0xe77ce489,0xedb5ea8f,0xf45ef0f7,0xfbdef806,0x0351ffa8,
0x0a3f06e9,0x0fc00d30,0x13c111fb,0x160e150f,0x18391718,0x1ab0196b,0x1dc61c1f,0x21521f93,
0x23d522d1,0x232c2400,0x1e7b2152,0x16661ac5,0x0bee116f,0x001d0607,0xf4befa52,0xeab1ef7a,
0xe2a2e66b,0xdc4cdf33,0xd8fbda38,0xd87fd88b,0xd901d89d,0xdacad9b7,0xdd22dbff,0xde93de08,
0xdeb1debd,0xdee2deb3,0xdfefdf48,0xe211e0d2,0xe642e3db,0xecefe94b,0xf5d9f119,0x014bfb45,
0x0e9f07cd,0x1c36158f,0x2830226e,0x31672d45,0x362b3460,0x365736cf,0x327534e4,0x2b952f38,
0x236827a5,0x1a321ee9,0x0fac1526,0x041a09e3,0xf965fe92,0xf004f492,0xe726eb99,0xdde9e290,
0xd52ad954,0xce52d17a,0xc989cbb2,0xc6cdc7ea,0xc5b5c620,0xc562c566,0xc6a0c5bf,0xca46c81f,
0xd037cd01,0xd809d3e4,0xe1acdca5,0xec85e703,0xf76df200,0x01f2fcb9,0x0cf90758,0x185712b0,
0x231b1dd0,0x2ccc2825,0x349b30f8,0x3a7337ca,0x3dd43c87,0x3dfc3e49,0x3c1f3d35,0x39143abe,
0x350c373b,0x2fd93293,0x29cf2cde,0x242126e0,0x1ecd217d,0x18d71be1,0x131215e7,0x0d82104e,
0x07e00aaa,0x02a8052f,0xfe620063,0xfa5bfc7b,0xf5b7f80a,0xf09df341,0xeb72edfc,0xe68be8ef,
0xe2a8e473,0xdf44e100,0xdb7ddd64,0xd8b8d9db,0xd801d80f,0xda3ad8c0,0xde91dc38,0xe3dfe122,
0xea47e6ec,0xf1a1ede2,0xf95bf56d,0x012ffd4b,0x08a804fd,0x0ee70c07,0x132d1142,0x160c14c4,
0x17c316fd,0x196e1882,0x1baf1a87,0x1eac1d0a,0x22292086,0x23832333,0x21842308,0x1a551e9e,
0x0f79151e,0x03ba09a8,0xf8a0fdf6,0xeef5f3b8,0xe61bea58,0xdf8de26c,0xdc1bdd82,0xdaa0db2a,
0xdafcda8e,0xdcd5dbdb,0xde7dddb0,0xdfaddf36,0xe030dfef,0xe086e068,0xe0bfe09a,0xe207e12b,
0xe539e35c,0xeb2be7d1,0xf3fcef34,0xff87f977,0x0c4e05e4,0x18da12a6,0x24fc1f00,0x2f062a71,
0x34a83277,0x34ff357b,0x30ec3359,0x2a8c2df8,0x228826bd,0x18f21df9,0x0de0137c,0x02f7085b,
0xf8b7fdb9,0xef4df3e8,0xe631eac6,0xdccbe172,0xd45bd865,0xce36d0f4,0xca9fcc1f,0xc887c97f,
0xc6edc79e,0xc640c679,0xc720c669,0xca58c874,0xd00cccdf,0xd83dd3e0,0xe204dcf7,0xecb8e75b,
0xf719f1fc,0x0162fc2c,0x0c4c06d0,0x174311c5,0x22451ccb,0x2c47277c,0x3443308d,0x39683740,
0x3b983ad2,0x3bec3bea,0x3ae73b98,0x389239e4,0x352e36ed,0x316d3361,0x2d712f6c,0x290c2b60,
0x2385266b,0x1d4e2075,0x16ad1a09,0x0fd91339,0x09740c89,0x049e06d1,0x0072028d,0xfbedfe43,
0xf733f98b,0xf257f4cd,0xed71efe1,0xe8c4eb06,0xe456e6a3,0xdef1e1b4,0xda27dc5d,0xd6ded850,
0xd5ded601,0xd793d669,0xdb4bd938,0xe0b8ddcc,0xe7a1e418,0xeefbeb42,0xf67ff2bc,0xfe57fa5a,
0x05f3024d,0x0c50093f,0x118f0f28,0x14b51363,0x16b215c3,0x18371781,0x19e118f9,0x1c671b0a,
0x1f351dda,0x211c205a,0x1fc920fb,0x1ab21dae,0x121316cb,0x07cb0cf2,0xfd8b02b0,0xf373f869,
0xeb10eeec,0xe4e5e7c1,0xe0c9e28c,0xdeeadf96,0xde93dea4,0xdee6dea9,0xe011df5c,0xe210e102,
0xe3fae323,0xe47de468,0xe44fe46b,0xe489e451,0xe639e514,0xeaede828,0xf2e7ee81,0xfd28f7e5,
0x085c02a1,0x14800e52,0x20b31ab1,0x2b212644,0x31102ec8,0x31ee3210,0x2f2430df,0x29982cb4,
0x21b125f5,0x17981cdb,0x0c811210,0x015406ef,0xf6b3fbe5,0xed0ff1bc,0xe47ce8a8,0xdc61e066,
0xd53dd892,0xd06bd27e,0xcd69cec8,0xcad4cc1c,0xc8dec9be,0xc7b6c825,0xc826c7b1,0xcac1c915,
0xd069cd3c,0xd81dd411,0xe150dc8c,0xeba2e668,0xf64df0ef,0x00fcfbae,0x0b500627,0x15fc109e,
0x20e91b70,0x2b33263a,0x33152f8b,0x37b435c7,0x39fe3903,0x3b0e3ab1,0x3ad93b24,0x38f83a15,
0x36a537c9,0x3448357d,0x30f332d2,0x2bed2ea0,0x259728eb,0x1e3421ff,0x16561a4d,0x0edd1277,
0x089d0b94,0x03ca0608,0xffa701ad,0xfb72fd97,0xf7e4f987,0xf433f623,0xf06ef24f,0xec7fee86,
0xe755ea22,0xe1a4e46e,0xdcccdf15,0xd945dada,0xd774d815,0xd801d769,0xdb28d940,0xe09eddb2,
0xe6f7e3ba,0xedb0ea4c,0xf4d0f12b,0xfc7bf8a7,0x03cb0028,0x0acc0765,0x104d0dc9,0x13f91259,
0x1611152f,0x173e16b6,0x187217cd,0x19e11921,0x1b8e1abb,0x1b701be4,0x18c21a4b,0x14cf16f5,
0x0f58123e,0x08370c18,0xff1b03c5,0xf639fa80,0xeeddf265,0xe8bfeb9c,0xe4e1e678,0xe2bce3c2,
0xe10ae1cf,0xe028e06e,0xe127e069,0xe3c2e254,0xe65ee528,0xe7aee737,0xe7d6e7dd,0xe824e7ea,
0xe9fbe8bf,0xee72ebde,0xf527f1a1,0xfd0af8eb,0x06cd01ae,0x12140c4a,0x1da617f5,0x277922e9,
0x2d752b03,0x2f9b2efb,0x2e242f47,0x29762c37,0x21bf25ec,0x18271d1c,0x0d6012e3,0x01fa07b4,
0xf67afc34,0xebd7f0f8,0xe2dfe72f,0xdad6deba,0xd47ed760,0xd046d234,0xcd1ece94,0xcab3cbda,
0xc8f4c9b6,0xc83ec87f,0xc8dac84c,0xcbebca08,0xd199ce81,0xd8f7d517,0xe186dd18,0xeb3be642,
0xf5a9f06f,0xffc9fac6,0x09d904cb,0x14410efd,0x1f1e19ad,0x28f0244f,0x30392ce7,0x35a53327,
0x393b37aa,0x3b223a69,0x3b2f3b60,0x3a223ab4,0x390f3991,0x377e3871,0x343c3615,0x2f1931e2,
0x27f72bc6,0x1fbd23f2,0x172a1b5e,0x0ff01357,0x099a0cc0,0x044006bb,0xffef020b,0xfc29fdf0,
0xf8f7fa87,0xf5b3f756,0xf206f3fc,0xecefefa0,0xe70dea15,0xe132e40d,0xdc2ede92,0xd80dd9fa,
0xd5a1d694,0xd5cbd54c,0xd92fd722,0xde74dbac,0xe497e176,0xeb1ce7c4,0xf21eee96,0xf973f5b3,
0x0185fd71,0x08ff0564,0x0f3b0c50,0x137d11a3,0x15d314d2,0x175116a4,0x183e17ce,0x196518cb,
0x19a319c5,0x17cb18f4,0x14941643,0x113712dd,0x0d8d0f84,0x08760b29,0x02b405a4,0xfca1ffb8,
0xf616f95f,0xf079f313,0xec3cee41,0xe834ea36,0xe4f7e66c,0xe357e3e2,0xe415e37d,0xe603e4ee,
0xe852e730,0xe9dae939,0xea7fea38,0xeb41ead2,0xed4bec02,0xf0deeef2,0xf555f2f7,0xfba8f83a,
0x0429ffaf,0x0dfe0900,0x17e81304,0x208d1c73,0x26eb241b,0x2a3228fa,0x29a72a66,0x258827f8,
0x1f402293,0x17081b6e,0x0cbb121a,0x00f80704,0xf49bfaa9,0xe9caeef3,0xe145e53d,0xdaadddc5,
0xd57dd7ee,0xd166d351,0xce76cfd1,0xcc14cd2b,0xcab5cb4b,0xca17ca43,0xcb92ca86,0xcf5bcd34,
0xd4ffd201,0xdc01d85a,0xe437dfee,0xed9be8cf,0xf743f272,0x00a2fc04,0x09ab051f,0x13120e55,
0x1c4d17bc,0x24bb20a1,0x2c7d28b1,0x33112ff7,0x37d535b7,0x3a603959,0x3b5c3aff,0x3ba53b90,
0x3b343b8a,0x397f3a88,0x35fd3803,0x303c3360,0x28862c9b,0x1fea243c,0x17d31bc5,0x10691406,
0x09dd0d02,0x04890706,0x00920265,0xfd75fee8,0xfaf3fc31,0xf7c2f986,0xf2e0f588,0xed41f018,
0xe72bea3b,0xe131e420,0xdbccde66,0xd72ad959,0xd498d582,0xd50ed472,0xd827d653,0xdce6da60,
0xe2bedfac,0xe934e5f7,0xefcaec6d,0xf775f38a,0xff83fb70,0x0769038b,0x0de30adb,0x12c9108b,
0x164714b1,0x185b177d,0x19ec192a,0x1a801a66,0x19891a38,0x16691840,0x121c1449,0x0dd60fff,
0x09240b7e,0x055e0716,0x02a903f2,0xffa60150,0xfba6fdb7,0xf708f974,0xf1acf465,0xec68eef6,
0xe85aea2b,0xe6aee72e,0xe721e6bd,0xe887e7bd,0xea25e95f,0xeb49eac4,0xec2bebbb,0xed52eca4,
0xef38ee2f,0xf16ff049,0xf489f2c8,0xf9abf6d6,0x00defd0a,0x0959050a,0x122d0dc8,0x1ab41676,
0x22211eae,0x269c24cf,0x27802785,0x251d26a2,0x206b231a,0x18db1cf9,0x0eae141c,0x029d08c2,
0xf65dfc6d,0xeb3af090,0xe247e67b,0xdb0dde7c,0xd509d7e5,0xd075d282,0xcd82ced7,0xcbbacc75,
0xcad3cb38,0xcb1dcac0,0xcd4bcbf6,0xd118cf04,0xd63fd38a,0xdc9ed945,0xe44be051,0xece2e87c,
0xf621f175,0xff4bfabd,0x085703d1,0x10e80cb2,0x19071500,0x21401d10,0x298a2578,0x31192d7a,
0x36993420,0x3a7338b6,0x3cec3bdf,0x3db83d88,0x3cff3d7b,0x3b4b3c4d,0x37e439d8,0x32843572,
0x2b5b2f19,0x23842780,0x1b2b1f63,0x12c916e9,0x0b320ed8,0x053907f7,0x00fb02f5,0xfe02ff5a,
0xfb45fcbe,0xf74df973,0xf25bf4e0,0xed1befce,0xe7baea67,0xe22ee4fe,0xdca7df65,0xd80cda19,
0xd619d6ba,0xd6b4d613,0xd965d7d6,0xdd76db48,0xe289dfea,0xe812e53c,0xee6deb28,0xf55cf1d2,
0xfd0cf920,0x04a400f4,0x0aea0804,0x0fa90d70,0x1330118a,0x162a14bb,0x17be1746,0x16f31790,
0x15531631,0x1317144c,0x0ff311ae,0x0b1e0dbd,0x05ed086a,0x029b03ee,0x013101c7,0x00df00e2,
0x009a00ef,0xfd97ff80,0xf847fb10,0xf316f58e,0xef27f0f2,0xed05eddd,0xec55ec7a,0xed0aec98,
0xee03ed87,0xeebcee70,0xef5aef01,0xf053efd2,0xf0c3f09a,0xf1f4f121,0xf527f351,0xfa54f789,
0x00c3fd70,0x0770041a,0x0e5e0ad2,0x15b5120f,0x1c3a1923,0x21001ee4,0x22e8224c,0x21fd22da,
0x1dc42044,0x16a21a8b,0x0cd4120b,0x0126071f,0xf501fb05,0xea53ef62,0xe20be5ed,0xdaedde6d,
0xd4dad7bd,0xcffcd240,0xcd37ce46,0xcc27cc91,0xcc08cbeb,0xcd4bcc8b,0xcf53ce31,0xd2a5d0cc,
0xd756d4d8,0xdd7eda34,0xe4c0e108,0xecf1e8b5,0xf5b8f14a,0xfea5fa37,0x067802c2,0x0d750a08,
0x14e710ff,0x1d641911,0x263221d1,0x2e042a48,0x34dc3187,0x3ad537fc,0x3ed03d30,0x40313fbd,
0x3fc84032,0x3da83ef3,0x39d13bf5,0x34453735,0x2df93129,0x26932a7e,0x1e0d225f,0x1541199f,
0x0d7c111e,0x07a10a5b,0x03820554,0x00bc0219,0xfd10ff09,0xf8aafafb,0xf3a6f629,0xee44f100,
0xe89eeb7a,0xe2cce5ba,0xdd00dfce,0xd8f5dab2,0xd6f4d7b5,0xd729d6be,0xd99cd81f,0xdd75db74,
0xe1ecdf94,0xe761e48f,0xed6dea5e,0xf40ff0a7,0xfb05f78b,0x0187fe62,0x0712046d,0x0b400953,
0x0f010d15,0x123410d0,0x135e1315,0x1296132c,0x117111eb,0x10b51120,0x0e440fce,0x0a350c4f,
0x062c0826,0x02e1046a,0x013b01b8,0x01e70164,0x02550257,0x00a801c3,0xfcefff05,0xf8ccfac8,
0xf538f6f3,0xf27af3b3,0xf118f190,0xf138f0fe,0xf242f1b3,0xf32ef2c4,0xf376f372,0xf2b1f338,
0xf181f205,0xf214f17c,0xf511f342,0xf9e1f756,0xff83fc9d,0x05b70280,0x0c76091a,0x12dc0fbd,
0x18bc15e2,0x1d5d1b3f,0x20301f20,0x1f812051,0x1b301dc4,0x13c917d6,0x0a1d0f30,0xfec50494,
0xf33af8e8,0xe902ede1,0xe0ace4a2,0xd9e8dd21,0xd3e4d6db,0xcefdd12c,0xcc40cd61,0xcb91cb9e,
0xcc95cbf0,0xce1ecd59,0xd00dcef8,0xd329d176,0xd7c1d537,0xdde1daa4,0xe517e161,0xed1ce8fb,
0xf621f188,0xfedbfaa9,0x061e029c,0x0ce2097c,0x1419106c,0x1c0717f8,0x24162022,0x2bf227fe,
0x33bc2fe8,0x3ab2376d,0x3f3e3d4b,0x417b40a1,0x417b41c4,0x3fba40d2,0x3c313e25,0x377339f5,
0x31403493,0x298d2d8c,0x20d6254b,0x17bc1c39,0x0ffe13a6,0x09ca0cb4,0x05770769,0x01b503aa,
0xfd8aff97,0xf947fb79,0xf4a3f6fe,0xef2ff208,0xe91fec36,0xe2d6e5f6,0xdd6fdfed,0xd992db59,
0xd779d83c,0xd7acd74a,0xd9edd89e,0xdd17db6a,0xe158df16,0xe63be3be,0xebe6e8f4,0xf203eef0,
0xf800f50a,0xfd91fad9,0x021f0005,0x060c0414,0x09c40806,0x0bf70b17,0x0cb80c7a,0x0ca30cb5,
0x0cad0c9c,0x0c920cbc,0x0b8e0c23,0x0a0f0ad8,0x08040932,0x05130687,0x0384040e,0x02f90341,
0x026702aa,0x01e3022d,0x011d017e,0x001100bb,0xfd82fef6,0xfa97fc05,0xf892f964,0xf819f821,
0xf8eff86e,0xfa03f986,0xf925f9f0,0xf63bf7cc,0xf3b7f4c4,0xf332f32f,0xf4f6f3d4,0xf842f67a,
0xfcebfa60,0x0341fff4,0x098d067e,0x0efd0c68,0x13d6116c,0x186c1638,0x1b0e1a1e,0x1ac71b4b,
0x170c1961,0x101613ec,0x06ea0bb3,0xfca501dc,0xf232f769,0xe848ed19,0xe007e3de,0xd9b6dcbb,
0xd441d6d6,0xcfc8d1ed,0xccd6ce07,0xcc75cc55,0xcd73cced,0xcec9ce0a,0xd0d1cfb9,0xd3edd232,
0xd8a3d614,0xdeacdb83,0xe5bbe215,0xedc8e9a1,0xf64df20e,0xfe71fa79,0x05e40237,0x0cda0972,
0x13be1044,0x1ace1741,0x22781e84,0x2aa12687,0x329e2ebc,0x392c361e,0x3ddf3bc6,0x40423f6c,
0x4052407e,0x3eaa3fb4,0x3bca3d53,0x37a539ee,0x31df34f4,0x2ad72e7a,0x22f526f9,0x1ac11ed5,
0x135016de,0x0d0a0fff,0x07dc0a71,0x026a0522,0xfd9effe8,0xf947fb6b,0xf4bef719,0xef59f22a,
0xe97dec65,0xe440e6c5,0xdfa9e1df,0xdbbbdd9d,0xd933da33,0xd90dd8d9,0xda7cd9a0,0xdd57dbba,
0xe0ffdf25,0xe575e312,0xead1e818,0xf0a3edad,0xf695f3a5,0xfbb7f94e,0x0018fdec,0x044e023e,
0x07c90631,0x09dc0903,0x0ac20a62,0x0b900b26,0x0c180bec,0x0bbf0c02,0x0ab50b50,0x090b09ef,
0x06a907f8,0x03ec053e,0x01a502c2,0xff770087,0xfdfefe97,0xfdbcfdab,0xff51fe4e,0x0156006d,
0x01fe01dc,0x010201af,0xffde0053,0xff57ff8e,0xff3fff47,0xfeceff28,0xfc44fdd7,0xf85bfa54,
0xf583f6b1,0xf4a9f4d1,0xf5dcf508,0xf8a1f715,0xfd14fa9a,0x030a0000,0x08b905f8,0x0dbf0b4d,
0x12531018,0x15ed1459,0x17a3170d,0x172f17af,0x13ab15d5,0x0d6b10dd,0x04da0951,0xfb3f002b,
0xf10ff633,0xe78dec1a,0xdfd4e374,0xd9b3dc9c,0xd49dd705,0xd035d255,0xcd38ce75,0xcc56cc85,
0xccd1cc81,0xce0acd53,0xd011ceef,0xd328d16a,0xd7f2d555,0xde4fdb04,0xe583e1cb,0xed4de964,
0xf53df139,0xfd7cf957,0x05a3019a,0x0d480983,0x149110fe,0x1bc61814,0x23b01faa,0x2bc827ce,
0x33132f94,0x39073635,0x3d2f3b64,0x3ef93e57,0x3f143f3a,0x3e1d3eac,0x3c243d50,0x388b3a91,
0x333f361b,0x2c692ff4,0x24922893,0x1cca209a,0x15a8192a,0x0eb51224,0x083d0b73,0x02700535,
0xfd55ffd0,0xf8f2fb13,0xf416f6a9,0xee88f159,0xe964ebd8,0xe4b1e705,0xe07be289,0xdcc9de84,
0xda8fdb72,0xda2ada29,0xdb7bda9d,0xde16dcac,0xe175dfae,0xe5ade37a,0xea80e7fc,0xf014ed3f,
0xf557f2d0,0xf9eff7ab,0xfe7efc40,0x02420082,0x049003a0,0x05a8052f,0x06d2062b,0x080d077b,
0x08680863,0x08d8087b,0x09a90952,0x099a09cc,0x07e908ee,0x04f20699,0x01660325,0xfe2cffbd,
0xfb9efcc0,0xfaf1faf4,0xfc99fb92,0xff23fdc2,0x024f00be,0x04f103b6,0x06b505f3,0x07910732,
0x080107db,0x06d007c8,0x02ce050c,0xfe2b006d,0xfaa3fc3e,0xf85ff94b,0xf7d0f7e8,0xf93ff831,
0xfd7ffb1a,0x02f9002e,0x086005c0,0x0ca20aa8,0x10030e79,0x11aa1102,0x126d122a,0x113d122f,
0x0d4d0f97,0x07650a8b,0xffcf03c3,0xf6effb8b,0xed60f22e,0xe43be8a6,0xdcf7e059,0xd815da30,
0xd493d65a,0xd11ed2c5,0xcecdcfc2,0xcdb7ce1d,0xcde6cdab,0xcf0ece59,0xd124d005,0xd44cd27d,
0xd954d699,0xdf64dc4c,0xe609e2a2,0xecd5e973,0xf480f076,0xfd8ef8ee,0x06ac0234,0x0eaf0ad8,
0x15981236,0x1cc41912,0x24782099,0x2bb72839,0x322e2f05,0x37b13520,0x3b7c39cf,0x3d873cbd,
0x3def3ddf,0x3d743dd3,0x3bad3cc2,0x386d3a46,0x33a8363b,0x2d7630b8,0x268429fe,0x1f9b2317,
0x18471c06,0x10b41479,0x095f0cf5,0x0327061d,0xfdde006a,0xf8cdfb65,0xf364f61e,0xee14f0ab,
0xe939eba1,0xe4b2e6e5,0xe069e28c,0xdd01de89,0xdaccdbbc,0xda45da4b,0xdb8bdab7,0xde18dcb1,
0xe18fdfbd,0xe577e371,0xea38e7bc,0xef4decc6,0xf409f1b6,0xf8cff667,0xfd2cfb1a,0x0047fef5,
0x01920116,0x02c80210,0x049903ac,0x06100579,0x06d8066a,0x08870794,0x0a47097f,0x0a430a90,
0x083b097c,0x04420674,0xffaa01f4,0xfbd0fd97,0xf977fa6e,0xf92ef90f,0xfa08f982,0xfc8efafc,
0x00edfe97,0x06320388,0x0afe08bb,0x0e680cdb,0x0fa90f62,0x0d790f14,0x08910b2c,0x038605f4,
0xff6a0157,0xfc3bfdab,0xfa37fb0d,0xfabefa1f,0xfd80fbe4,0x0204ff93,0x071f049b,0x0b850972,
0x0e570d3e,0x0f750eff,0x0f970fbd,0x0dbf0ee5,0x09d30c14,0x03ac0700,0xfbe1ffe4,0xf32ff7a5,
0xea17eeb1,0xe1bde5b2,0xdb66de3b,0xd7ded95f,0xd4fad673,0xd26dd3a9,0xd028d13d,0xce86cf38,
0xcdfece22,0xce5dce11,0xcfb4cee3,0xd2e7d109,0xd7e7d53b,0xdde9dad7,0xe445e112,0xeaf0e786,
0xf32aeece,0xfcd1f7e0,0x068c01cd,0x0ede0ae4,0x168012af,0x1e5d1a6c,0x25ff2245,0x2ca0296f,
0x325a2f9d,0x370434d1,0x3a6438df,0x3c753b90,0x3d873d1e,0x3d6e3da5,0x3c043cd5,0x39833aeb,
0x358a37bc,0x302932fa,0x2a222d3a,0x22f526c0,0x1a871ed0,0x12041641,0x0a3b0df9,0x03c906d7,
0xfe2100ef,0xf84cfb3a,0xf287f560,0xed8deff4,0xe915eb3d,0xe514e716,0xe154e313,0xde7ddfd9,
0xdc76dd4e,0xdbffdc0b,0xdd1bdc58,0xdf90de36,0xe2c2e119,0xe69fe498,0xeadee8bf,0xeecfecdc,
0xf2fdf0d6,0xf77ef541,0xfb5df998,0xfd38fc97,0xfdc3fd82,0xfeb1fe25,0x000eff5c,0x012d00af,
0x029401bb,0x059f03d9,0x0947079c,0x0acf0a5d,0x09960a8e,0x057b07e0,0x000602b7,0xfbf3fdc0,
0xfa2afac6,0xf9a5f9e3,0xf964f965,0xfab0f9c8,0xfe85fc44,0x043b0143,0x0a790751,0x10670d94,
0x1380128b,0x122c1342,0x0e88108f,0x09d70c42,0x04eb0757,0x006302a0,0xfcf5fe68,0xfc02fc2a,
0xfd76fc6e,0x0185ff35,0x069a0404,0x0b020911,0x0d0c0c4a,0x0da90d7b,0x0d210d8f,0x0b510c5f,
0x074c09ae,0x00e40458,0xf8b2fcf1,0xefd4f458,0xe685eb22,0xde42e229,0xd8bcdb09,0xd624d737,
0xd4d9d562,0xd3b1d458,0xd1b2d2c8,0xcfe8d0af,0xcf24cf6d,0xcf37cf06,0xd0a0cfb6,0xd3dbd20b,
0xd852d5f6,0xdd78dadd,0xe30ce02c,0xe9cee638,0xf26dede5,0xfc7ff75a,0x06500184,0x0f230ad2,
0x178e135d,0x1f811b9b,0x26bc2337,0x2ce72a00,0x31aa2f6e,0x355533a0,0x382e36df,0x3a3b3947,
0x3b993b03,0x3bcf3bdd,0x3af13b83,0x39133a25,0x35d237a9,0x31b533ce,0x2cac2f6c,0x255b294a,
0x1ce7212a,0x148a18ac,0x0d1310b1,0x067809ad,0x00380363,0xf9ecfd05,0xf3faf6eb,0xee50f116,
0xe985ebc6,0xe591e773,0xe295e3fe,0xe00ee138,0xde34df10,0xdd62dd95,0xde7eddb8,0xe0ccdf91,
0xe3a1e229,0xe699e523,0xe95ce7fb,0xec9ceae1,0xf0a0ee87,0xf4c9f2c8,0xf79bf679,0xf894f83b,
0xf938f8e1,0xfa0cf99d,0xfb28fa91,0xfcb3fbcf,0xff91fdf4,0x03ff019a,0x08b00673,0x0b670a69,
0x0aeb0b95,0x072b096c,0x0211048a,0xfebf001c,0xfd5ffde7,0xfc33fcd8,0xfb57fba0,0xfbb8fb57,
0xfe35fca7,0x02870038,0x0870053f,0x0ecb0bc7,0x130f1144,0x14c81436,0x13c414a5,0x0fed122b,
0x0ab50d5b,0x052807fc,0x00a402a4,0xfe22ff13,0xfea4fdf8,0x01ca0000,0x061403e2,0x095907f6,
0x0ad90a48,0x0aca0aff,0x0a000a75,0x082a0946,0x04180678,0xfdd4012d,0xf5bdf9fe,0xec66f12e,
0xe2eee793,0xdb02dea3,0xd63dd83d,0xd415d4e4,0xd3a1d3bd,0xd335d38c,0xd1e3d29e,0xd05cd116,
0xcfa9cfdf,0xd00ccfae,0xd21ad0df,0xd51ad390,0xd8ddd6e0,0xdd7bdb15,0xe2f0e00e,0xea22e648,
0xf31dee71,0xfd12f80c,0x0720021f,0x10ec0c1a,0x19c2157b,0x21981dc3,0x2883252d,0x2e0d2b7a,
0x321c3040,0x34df33a1,0x36d135f5,0x38113782,0x389b386a,0x389638aa,0x380f3866,0x36c1378f,
0x34c235cc,0x323833a6,0x2d7f303e,0x266c2a1e,0x1e76227f,0x16c61a89,0x0fef133c,0x09820cbf,
0x02a5061e,0xfbcdff31,0xf50ff867,0xeed0f1d3,0xe99dec11,0xe5c5e788,0xe2fae43e,0xe0f3e1ec,
0xdf14dfff,0xde2ade6a,0xdf20de69,0xe15ee022,0xe404e2b4,0xe61ce528,0xe81fe70c,0xeb0ce96d,
0xeeedecee,0xf290f0e2,0xf4baf3d2,0xf5ebf565,0xf6c8f65e,0xf7c5f748,0xf8b4f82f,0xfaf9f997,
0xff2efce1,0x041e019f,0x091f06a4,0x0c790b27,0x0c720cea,0x09300b24,0x047606dc,0x00f20272,
0xfeadffc5,0xfcb1fd98,0xfb97fc08,0xfb74fb5d,0xfcbefbeb,0xffd1fdff,0x04b20223,0x098f0730,
0x0e870beb,0x138a112e,0x16511563,0x14f11621,0x10a31307,0x0b3f0def,0x062808a4,0x02a4040d,
0x02180213,0x03e402ac,0x06c70562,0x08b807e9,0x0950093f,0x085408e8,0x072f07ce,0x0517064a,
0x010d035f,0xfae9fe38,0xf2a2f710,0xe8fbede1,0xdfa3e42a,0xd88cdbb4,0xd45dd624,0xd30fd353,
0xd388d338,0xd3c9d3c9,0xd33bd3a0,0xd212d2a2,0xd1add1b5,0xd2b8d200,0xd4ded3c3,0xd712d5f4,
0xd9d5d853,0xdd97db91,0xe2ffe00a,0xea54e66b,0xf327eea8,0xfcbcf7d6,0x073d01e1,0x11cd0c92,
0x1b0b169c,0x22e51f1f,0x29822659,0x2ed82c5d,0x32a830f2,0x35073405,0x362e35ba,0x3653365c,
0x35df3628,0x356d35a1,0x34f33536,0x343d349d,0x337133e4,0x314532b3,0x2c342f0a,0x25cc2913,
0x1ec8224d,0x18041b52,0x11c014d6,0x0b390e90,0x040e07b1,0xfc870052,0xf535f8c4,0xeeebf1e8,
0xea09ec50,0xe64de80c,0xe3a4e4d4,0xe17be292,0xdfa3e076,0xdf15df27,0xe045df73,0xe2c1e16f,
0xe534e417,0xe6d1e615,0xe861e787,0xeaf0e980,0xee29ec87,0xf0d9efab,0xf29af1c6,0xf3fcf359,
0xf541f49e,0xf6adf5fa,0xf8b2f781,0xfc7bfa60,0x0172fee5,0x068f03fc,0x0b660924,0x0dc40cfe,
0x0cbe0da8,0x09370b3b,0x049a06e6,0x00d30290,0xfdf4ff4f,0xfc00fcd7,0xfacafb4e,0xfa64fa80,
0xfb1ffa92,0xfda4fc2d,0x00d8ff3c,0x044e027a,0x098606a3,0x101b0cd2,0x151e12f5,0x16821656,
0x13bd158d,0x0f6611a3,0x0adc0d0a,0x07eb091e,0x06e90726,0x07fd0747,0x098608cf,0x0a4f0a10,
0x099e0a29,0x082b08df,0x06980775,0x0434058d,0x00220267,0xf9c8fd4b,0xf0d6f592,0xe6f5ebea,
0xddb3e21d,0xd71eda0a,0xd360d4d9,0xd29dd2b5,0xd318d2d9,0xd308d32a,0xd22fd2b8,0xd149d19a,
0xd1c6d161,0xd370d27f,0xd54bd461,0xd75ed644,0xda09d897,0xdddcdbc1,0xe331e056,0xea03e673,
0xf1e7edd3,0xfb0cf651,0x056a0020,0x0fa00aa4,0x18cc1451,0x212c1d11,0x28b8251a,0x2efc2c06,
0x33a2318e,0x363d352c,0x371936e5,0x369b36f9,0x3593361b,0x34ce3527,0x343a347e,0x34243414,
0x33df3435,0x313c32e9,0x2c282ee7,0x25e1292c,0x1f012265,0x18af1bc3,0x12f315ce,0x0c990fe8,
0x0541090b,0xfd46014c,0xf57ff949,0xef03f209,0xea0fec58,0xe6a9e833,0xe409e54c,0xe1d9e2e1,
0xe075e106,0xe063e03e,0xe1d2e0ec,0xe416e2ef,0xe5f4e518,0xe760e6b4,0xe8d7e808,0xeb2be9ed,
0xed86ec6a,0xeee5ee59,0xefc5ef50,0xf0f5f053,0xf28ff1b7,0xf468f36c,0xf791f5c3,0xfc6bf9cd,
0x0213ff3f,0x079c04d4,0x0c640a3f,0x0e820dda,0x0d9d0e67,0x0a760c3e,0x062e0855,0x02340427,
0xfed4005b,0xfcb7fda3,0xfb7ffbfd,0xfadcfb1e,0xfb56fae2,0xfd70fc46,0xffaafe97,0x026f00d7,
0x077f04ad,0x0d9d0a92,0x12a9105b,0x14e71447,0x142c14bc,0x11e91340,0x0ef8106a,0x0c860da4,
0x0b3d0baf,0x0b6e0b32,0x0b8f0b99,0x0ada0b51,0x08f50a16,0x066607a3,0x0407053e,0x019202d6,
0xfdd6fffb,0xf7acfb24,0xeef0f37d,0xe57bea3d,0xdcbde0e8,0xd5ded90a,0xd1b4d35d,0xd0add0e9,
0xd0b0d0b0,0xd036d08e,0xcf9dcfe0,0xcfe2cf96,0xd1b0d099,0xd43ed2fa,0xd687d562,0xd8fed7bf,
0xdc0fda64,0xe06fde11,0xe5bde30c,0xebc1e89e,0xf2f7ef36,0xfba1f717,0x0575007b,0x0ee70a56,
0x177d133e,0x20181bcc,0x2845243f,0x2f772c0e,0x34793254,0x36e335f1,0x37803766,0x36b93745,
0x354a3602,0x340c34a2,0x33473393,0x334d333c,0x3278331a,0x2f843150,0x2ab32d3a,0x249b27d9,
0x1e02213a,0x18591b0c,0x12fb15bb,0x0cc01003,0x05730933,0xfd820186,0xf5f4f995,0xf00bf2cb,
0xebe7edb8,0xe915ea71,0xe69ce7d1,0xe48be575,0xe3bbe3f4,0xe41ee3c4,0xe592e4c0,0xe720e669,
0xe832e7b6,0xe8e0e88f,0xe9dee94c,0xeb32ea94,0xebaceb91,0xeb6aeb89,0xebc1eb77,0xecceec37,
0xee15ed71,0xf002eed9,0xf3eaf1a9,0xf9a9f6b3,0xff9cfc9a,0x061002ca,0x0ba8091a,0x0eb00d92,
0x0ec60f12,0x0cd60e09,0x093e0b2d,0x0518072b,0x018e0335,0xfefd0025,0xfd69fe1f,0xfc62fcd4,
0xfca5fc4b,0xfda2fd29,0xfe8dfdff,0x0150ff98,0x065a03a1,0x0be50935,0x0fdb0e2b,0x11ae10e6,
0x12c51255,0x12c912f5,0x11a31258,0x0fca10b1,0x0eec0f33,0x0e780ebe,0x0d820e11,0x0b660caa,
0x07d409be,0x03ed05d5,0x00e30248,0xfebcffcd,0xfb92fd66,0xf5edf910,0xee4bf251,0xe5f1ea0d,
0xddf4e1f5,0xd6cfda19,0xd2a7d44d,0xd11fd1b6,0xd059d0af,0xcf6bcfef,0xcf1dcf20,0xd006cf65,
0xd227d0fb,0xd472d348,0xd715d5bb,0xd9fed87c,0xddfedbcd,0xe2f6e06f,0xe7c5e566,0xecadea23,
0xf2b9ef7e,0xfaa9f677,0x0392ff19,0x0c3d07f8,0x14dc1081,0x1de41957,0x270e227f,0x2f262b67,
0x34673226,0x37343610,0x382c37ed,0x37993800,0x364536f9,0x34e33589,0x341a346b,0x333833bd,
0x3146326d,0x2dc62fb3,0x292c2b9d,0x234c265e,0x1d512037,0x180f1a9f,0x12d61581,0x0cd50ff4,
0x05f8097f,0xfe6a0243,0xf71afa98,0xf168f40d,0xed79ef46,0xea8bebea,0xe841e953,0xe6dce76a,
0xe66fe688,0xe6cee686,0xe7c4e748,0xe8b7e840,0xe96de921,0xe9efe9aa,0xeab5ea54,0xeaceeae5,
0xe9c0ea5e,0xe8cde92f,0xe8fae8b4,0xe9fae973,0xeb38ea84,0xedbcec44,0xf22aefb3,0xf7c4f4d8,
0xfe66faf9,0x055301e4,0x0bba08ac,0x0fb80e25,0x10d61094,0x0fa71082,0x0c300e28,0x08020a16,
0x0422060b,0x00dc0262,0xfe51ff86,0xfc87fd49,0xfbecfc18,0xfbe5fbdf,0xfccafc1d,0x000afe16,
0x0504026d,0x09b1077f,0x0cbe0b79,0x0e9c0dba,0x103c0f71,0x11dd1106,0x12de1279,0x1316130b,
0x12d31304,0x12371290,0x110b11cc,0x0ddc0fb6,0x091d0ba1,0x03ee066d,0x001a01db,0xfd08fe83,
0xf91cfb4c,0xf398f690,0xec84f02e,0xe52fe8dc,0xdd6de15a,0xd69dd9c5,0xd221d416,0xcf86d0a0,
0xce23cebd,0xcd3fcd99,0xcd6ecd30,0xceeccdfd,0xd1a8d030,0xd4c4d32d,0xd7f4d65f,0xdb41d98d,
0xdfbddd55,0xe4cde247,0xe988e735,0xee72ebe6,0xf460f13f,0xfbb0f7e3,0x03adffa5,0x0ba507b3,
0x13e20faa,0x1cbb1840,0x262a2175,0x2e3c2a75,0x33b3315c,0x36b63575,0x37cd3774,0x37ce37ec,
0x36ff377a,0x35fe3679,0x3505358e,0x3372344c,0x30e6325b,0x2d0f2f17,0x28612ae0,0x22bf2594,
0x1d251ff1,0x17871a59,0x11bc14a2,0x0bad0eca,0x0513086e,0xfdf5018f,0xf784fa8b,0xf282f4db,
0xeec2f07f,0xec16ed4b,0xea5feb18,0xe989e9db,0xe94be95e,0xe970e951,0xe980e985,0xe9b4e98c,
0xea22e9eb,0xea87ea54,0xea19ea88,0xe7f5e931,0xe5bce6b7,0xe48de4f9,0xe4eee494,0xe60be566,
0xe87be70f,0xecc2ea5b,0xf21def66,0xf863f510,0xff6afbed,0x065e02d9,0x0d2909ec,0x11810fb2,
0x135712ba,0x12151322,0x0e261052,0x09d70bf0,0x061c07e9,0x02b4045d,0xffe60129,0xfe13fee9,
0xfcb2fd58,0xfc30fc41,0xfd99fc9f,0x00c7ff0d,0x046c029e,0x073205f5,0x091b0835,0x0a6c09df,
0x0bfe0b10,0x0e820d32,0x11cf1008,0x151613a1,0x16751606,0x161a1670,0x1391153b,0x0e75113f,
0x07d40b3e,0x021104b4,0xfdcfffc3,0xfa5ffc25,0xf631f857,0xf10bf3cc,0xeb2dee28,0xe472e7e7,
0xddb3e0fe,0xd7dedaa9,0xd321d551,0xd044d16f,0xcec0cf71,0xcdcfce28,0xcdf4cdb4,0xcf82ce90,
0xd25fd0c6,0xd5e0d41e,0xd948d79e,0xdce9db05,0xe141defc,0xe617e3a5,0xeab4e875,0xef56ecf3,
0xf4ccf1eb,0xfb6cf803,0x0291feef,0x0a2c0651,0x12520e2b,0x1b5416af,0x24b72018,0x2cce28fc,
0x32b3300e,0x362b34bd,0x37f63737,0x38613852,0x379c3814,0x3674370e,0x34e035b4,0x32be33e7,
0x2f753146,0x2b782d85,0x26aa292a,0x21a2241b,0x1c481f0e,0x16341952,0x1013131b,0x0a280d1b,
0x03dd071b,0xfda700a6,0xf83bfad0,0xf39af5d1,0xf031f1b7,0xee18eefd,0xecf4ed69,0xec7aecb1,
0xec2aec50,0xeba4ebf6,0xeaedeb41,0xeaa4eab2,0xeac4eab5,0xea69eab9,0xe883e9aa,0xe5c9e724,
0xe3a4e49d,0xe2b4e2ff,0xe2d7e2ad,0xe43ce354,0xe7a7e5aa,0xecabea0e,0xf282ef6e,0xf9bbf603,
0x0104fd73,0x082b048a,0x0f1d0bd1,0x13f911db,0x15d6155f,0x14281560,0x10371254,0x0c050e0c,
0x083b0a1d,0x04750656,0x012502bf,0xfde3ff85,0xfb6dfc73,0xfb45fb08,0xfd2cfc06,0x0028fe9f,
0x032601b1,0x05b00472,0x07b306d3,0x08820832,0x09b608f0,0x0c430ac8,0x10a20e4b,0x152612f6,
0x187c170f,0x19051938,0x15bc17d8,0x0f0512c6,0x06d50ae8,0xffa40306,0xfa35fcb9,0xf5cff7f1,
0xf147f39b,0xec9aeeea,0xe76dea2a,0xe1eae498,0xdcf9df65,0xd825da88,0xd40ed5ec,0xd18bd29b,
0xd018d0bb,0xcf35cf99,0xcf78cf1f,0xd147d035,0xd4c8d2d8,0xd8cad6c8,0xdd00dae2,0xe0f0df0d,
0xe4d7e2d3,0xe94ee70e,0xed8aeb7d,0xf1d5ef9e,0xf6bcf430,0xfc8df988,0x0311ffb5,0x0a7d06ad,
0x12690e5c,0x1b2a16bb,0x23da1f89,0x2bae27f3,0x31752ee4,0x34e63366,0x36d3360c,0x3735373a,
0x366c36e2,0x351735d1,0x33063427,0x305631cd,0x2ca02e8c,0x28872aa4,0x23ff2648,0x1f4b21ba,
0x19ed1ca7,0x140e170f,0x0e351115,0x08700b5e,0x02610569,0xfcdbff86,0xf803fa5a,0xf3f9f5df,
0xf166f27c,0xf010f09f,0xefa6efc3,0xef7fef8f,0xef24ef66,0xededee98,0xecebed59,0xeccfecc0,
0xecc6ecdf,0xeb5bec54,0xe859e9ee,0xe5b1e6e7,0xe407e4b4,0xe32fe397,0xe2d5e2d8,0xe446e34f,
0xe7ace5c0,0xec47e9d3,0xf277ef2a,0xf972f5f6,0x003ffce5,0x076703b3,0x0f200b43,0x158e12b4,
0x17fb1757,0x16df17c9,0x133b1541,0x0f3f1135,0x0b130d35,0x070308fa,0x0302051a,0xfe6600a8,
0xfb8efc93,0xfbcafb61,0xfd61fc81,0xffa0fe74,0x020400c9,0x04e2036a,0x06cc0611,0x0755071f,
0x07fb078e,0x0a3b08d9,0x0db90bdb,0x123a0fe8,0x163f147d,0x17981750,0x149516b4,0x0d8a116e,
0x050b0949,0xfd460102,0xf706f9f7,0xf245f47a,0xee0cf020,0xea63ec35,0xe5d6e834,0xe14ce38d,
0xdc9edf09,0xd790da0d,0xd39dd568,0xd167d240,0xd0a4d0ea,0xd084d080,0xd136d0ba,0xd340d206,
0xd70bd4f9,0xdb7bd936,0xe03fdde0,0xe48be279,0xe899e68b,0xecbceaaa,0xf0d0eecc,0xf4d1f2d3,
0xf908f6d8,0xfe2bfb7b,0x045b011b,0x0b3f07cb,0x129b0ed1,0x1a3f1671,0x22271e2a,0x29a7260b,
0x2f862cd6,0x337131b3,0x35b334c3,0x3650362d,0x35ce3633,0x34313520,0x31e23312,0x2f053090,
0x2b752d47,0x274c2978,0x228124ee,0x1d121fe7,0x16f21a12,0x10be13cc,0x0b0e0dd9,0x059d0850,
0x006f02f1,0xfbe9fe1d,0xf7e9f9d0,0xf500f651,0xf376f40f,0xf2faf31b,0xf31cf303,0xf315f326,
0xf249f2d7,0xf0a1f176,0xefa3effd,0xef8cef8a,0xeec6ef5c,0xebdced9c,0xe7ffe9dd,0xe542e672,
0xe3f7e480,0xe2d7e36d,0xe279e277,0xe3c7e2e6,0xe6a6e512,0xeb12e89b,0xf123edf3,0xf7e5f47c,
0xfed5fb58,0x0676027b,0x0f6f0ad5,0x16fa13b4,0x1a24190a,0x19e41a70,0x169c187a,0x1273149c,
0x0dfb102c,0x09c10be7,0x04a5075c,0xff0f01c1,0xfbebfd05,0xfbb5fb93,0xfcacfc16,0xfe25fd66,
0x005aff06,0x037f01f4,0x05a804c2,0x06970645,0x072206cd,0x088707bd,0x0ae80978,0x0eda0cc6,
0x12cb10f9,0x14eb1428,0x133f14b2,0x0d301097,0x04d9093a,0xfc9a0089,0xf593f8e6,0xf070f2d7,
0xec63ee40,0xe8dfeab3,0xe4b0e6d6,0xe02ee273,0xdb25ddba,0xd639d895,0xd29ed431,0xd131d19a,
0xd1ccd14e,0xd2e5d265,0xd403d35c,0xd658d4fb,0xd9efd7fb,0xdea3dc2f,0xe372e11c,0xe791e59f,
0xeb64e97c,0xeeefed25,0xf2aaf0c9,0xf627f475,0xf986f7c6,0xfe28fb9c,0x041b010e,0x0a830742,
0x113b0dde,0x1800148d,0x1f6f1ba4,0x26e3233e,0x2d242a35,0x31b42fa2,0x3490335b,0x3624357c,
0x3639366d,0x34a63599,0x323a338a,0x2f1830bd,0x2ba32d68,0x275529ac,0x222124dd,0x1c131f1b,
0x15bb18fb,0x0f3f126c,0x09270c24,0x038f0651,0xfec300fe,0xfab8fcaa,0xf786f8fd,0xf58df65c,
0xf4c1f4ff,0xf52df4d9,0xf612f59c,0xf655f661,0xf4fbf5d3,0xf33bf40d,0xf246f2a1,0xf1b3f20b,
0xefc9f10a,0xeb87edd6,0xe765e951,0xe4dee5e6,0xe376e42d,0xe209e2a8,0xe1dae1be,0xe33ae25f,
0xe5abe44e,0xe98fe76b,0xee82ebf2,0xf452f14b,0xfb3af7a8,0x033aff08,0x0ca407db,0x146f10f0,
0x1976173f,0x1b681ae1,0x19f81b18,0x166a184b,0x12d11494,0x0e8210e8,0x086a0b95,0x0266053e,
0xfe630011,0xfcb3fd5c,0xfc22fc59,0xfc10fbf8,0xfdd1fca7,0x00d6ff4a,0x04140279,0x066c0566,
0x0840075b,0x099108f3,0x0b720a5b,0x0e5d0cd8,0x11670fe4,0x138012b6,0x12c71390,0x0e3410fd,
0x06690a99,0xfd3701c6,0xf565f90d,0xefc1f241,0xec39eddc,0xe8a2ea76,0xe4a1e6ba,0xdf6be22c,
0xd99bdc85,0xd415d6c3,0xd028d1d2,0xcf08cf32,0xd0a9cf96,0xd30ed1eb,0xd593d436,0xd8a8d71b,
0xdc7fda5c,0xe19cdeff,0xe6c3e443,0xeb18e912,0xee60ecce,0xf17fefeb,0xf49df316,0xf740f600,
0xf9d8f879,0xfdb4fb8c,0x031a0044,0x09100611,0x0ee90c06,0x150a11e1,0x1c26187e,0x23a41fe2,
0x2a83273e,0x2fc82d67,0x332a319e,0x354f3472,0x35b535bb,0x34b13555,0x32cb33df,0x2fd63160,
0x2cb02e53,0x284b2ab0,0x22812599,0x1bf61f38,0x14fe1887,0x0e5211a0,0x08150b12,0x02d20553,
0xfed800b3,0xfba7fd25,0xf935fa51,0xf7b5f84d,0xf742f75f,0xf78ef757,0xf7eaf7cf,0xf73bf7bc,
0xf5aff67f,0xf412f4d9,0xf2bef363,0xf0fef1ff,0xedbfef91,0xe9aeebb6,0xe61be7c4,0xe3a9e4cb,
0xe193e291,0xe0a3e0e8,0xe153e0ca,0xe2d3e205,0xe546e3de,0xe8bae6e8,0xecf3eabb,0xf280ef7f,
0xf9edf5ff,0x02c4fe3b,0x0c120769,0x14881080,0x1b07181b,0x1e2a1d02,0x1db11e70,0x1a9b1c34,
0x1736190a,0x11d614cb,0x0b4b0e8c,0x055a083e,0x006202b3,0xfd41fe93,0xfb4bfc34,0xfaa2fab1,
0xfbaafaf8,0xfe4bfcc8,0x01fb0024,0x05240398,0x0732065d,0x085007c3,0x09cf0901,0x0c010acf,
0x0f0e0d7d,0x113d1056,0x1145119f,0x0dee1014,0x06b40ac2,0xfde10247,0xf5f3f9ae,0xf0c9f304,
0xed25eee6,0xe98ceb61,0xe555e79f,0xdf7ce28d,0xd906dc4b,0xd2efd5dc,0xcf0dd09a,0xce5fce42,
0xd06bcf35,0xd35ad1d5,0xd672d4df,0xd9c9d80f,0xde1bdbc2,0xe39ee0d0,0xe8e7e657,0xed03eb22,
0xefe5ee83,0xf2fff16d,0xf5fdf48b,0xf869f73d,0xfb00f9a1,0xfe87fc91,0x039300e5,0x08f7064f,
0x0e150b83,0x13ca10d2,0x1a2816e0,0x213b1da1,0x281624d0,0x2d5f2aee,0x31502f81,0x339b32b4,
0x34263409,0x339333f6,0x31c432e1,0x2ee33066,0x2b782d4e,0x27052958,0x2145244e,0x1ad41e21,
0x13dc174c,0x0d3e108c,0x07440a19,0x029a04bb,0xff2200cb,0xfc62fda7,0xfa68fb43,0xf99cf9e3,
0xf991f984,0xf9e6f9b9,0xf9a1f9ea,0xf891f92b,0xf74cf7e9,0xf5fef6ac,0xf44ff543,0xf140f2f4,
0xed61ef4f,0xe9feeba0,0xe703e873,0xe40ce593,0xe186e29a,0xe0b7e0da,0xe17be105,0xe2f8e212,
0xe547e417,0xe7dde683,0xeb86e97b,0xf145ee14,0xf98af527,0x028ffe19,0x0b8206fb,0x147e1020,
0x1b6e1851,0x1f4f1dc9,0x1f4c1fd9,0x1cc31e21,0x18c61b10,0x12d515f5,0x0cb80fb3,0x06d309cc,
0x00dc03c3,0xfc5afe64,0xf974fab1,0xf8c3f8d7,0xf9abf902,0xfcc5fafa,0x00fffecd,0x05270341,
0x07170660,0x0820079e,0x08dc0883,0x0a5c0977,0x0c8b0b70,0x0e0c0d6e,0x0e570e5f,0x0c1c0dae,
0x066c099e,0xfec502af,0xf81ffb28,0xf385f5a1,0xef81f18e,0xeb09ed50,0xe570e875,0xde80e219,
0xd717dac9,0xd0e0d3ae,0xcdc5cee0,0xce3ccd90,0xd133cf85,0xd533d32f,0xd88ad6f3,0xdbe4da22,
0xe005ddd1,0xe55ae29f,0xea9ee80d,0xeea0ecd2,0xf189f022,0xf455f2f9,0xf70af5ac,0xf9b0f851,
0xfca6fb24,0x0056fe51,0x051602a4,0x09e80784,0x0ecf0c4c,0x14501180,0x1a781747,0x21401de6,
0x2751246c,0x2c4b29ea,0x2ff22e5b,0x31c8311e,0x322d3217,0x318c31ff,0x2f7330ab,0x2c902e14,
0x28ba2ac1,0x240d268e,0x1e272123,0x17b21b09,0x10f6144f,0x0a720d99,0x0528079f,0x0176031a,
0xfebb000c,0xfc84fd8a,0xfb39fbb8,0xfafcfb05,0xfb27fb07,0xfb4afb4c,0xfa8ffafe,0xf996fa13,
0xf8bbf924,0xf794f83d,0xf50bf68d,0xf130f32d,0xedd3ef5a,0xeb6dec8f,0xe904ea55,0xe5f7e775,
0xe40ee4cd,0xe3e3e3cf,0xe481e41d,0xe5ede524,0xe733e6a2,0xe85ae7b0,0xeae4e958,0xf072ed3d,
0xf894f461,0x00c4fcb3,0x09b00503,0x13620e9a,0x1b3517a1,0x200a1e12,0x211d2108,0x1ed12057,
0x1a0a1cab,0x14421724,0x0e85116b,0x08300b7a,0x015904b2,0xfc05fe6c,0xf92ffa4c,0xf889f8a7,
0xf993f8ca,0xfc7dfad7,0x00e4fe92,0x042902dd,0x050904cc,0x051c0522,0x05420514,0x06a905cd,
0x08b007a4,0x0a6309a4,0x0afb0ada,0x08d80a56,0x03fd06b9,0xfd9300c3,0xf888fad6,0xf4a2f684,
0xf0e4f2d1,0xebd7ee90,0xe574e8cc,0xdde7e1c8,0xd645d9f3,0xd0a6d326,0xce1ecee3,0xcf23ce41,
0xd33cd0d4,0xd86ad5ec,0xdc83da91,0xe02bde5b,0xe454e20d,0xe991e6ec,0xee82ec1d,0xf28af0ad,
0xf563f412,0xf7d1f6a4,0xfa33f907,0xfccefb78,0xff80fe2b,0x02a900f5,0x0658047e,0x0a45083d,
0x0e640c50,0x12fb1098,0x18b115ac,0x1efb1bdb,0x24e52201,0x29dc278f,0x2d202bb8,0x2e9c2e0f,
0x2f042ee6,0x2e642ee6,0x2c6d2d80,0x29c82b38,0x261d280d,0x218123f5,0x1c1a1ede,0x15eb1920,
0x0f211291,0x08d70bca,0x04300646,0x017102ae,0xff380048,0xfd80fe4d,0xfc90fce7,0xfc35fc56,
0xfc0cfc20,0xfb71fbd5,0xfa46fae4,0xf94bf9b7,0xf8e9f914,0xf808f89e,0xf562f6f2,0xf1b5f387,
0xef3af042,0xedb8ee72,0xeb9eecd3,0xe904ea40,0xe760e800,0xe720e729,0xe78ee73a,0xe882e810,
0xe8dbe8ba,0xe992e912,0xec11ea7f,0xf1aaee78,0xf93ef569,0x00a4fcf3,0x08fe0494,0x12710dc7,
0x1a3e16a5,0x1f401d1e,0x20ae2082,0x1e331fdc,0x19281bdb,0x13e4166e,0x0ea11155,0x08a10bb8,
0x023c056d,0xfcedff55,0xf9d5fb24,0xf893f8f7,0xf96cf8b6,0xfc53faa4,0x009afe6e,0x0378025a,
0x042b03fe,0x03ff0423,0x03f203e5,0x04870438,0x055204e9,0x05cd059d,0x059505e0,0x036704b6,
0xffd301bf,0xfbcafdbf,0xf894fa24,0xf58cf701,0xf207f400,0xececefae,0xe5f1e9a0,0xde06e20e,
0xd691da14,0xd116d387,0xcee3cf89,0xd04fcf1a,0xd55fd274,0xdbabd89d,0xe0bade56,0xe4cee2db,
0xe8d9e6be,0xed74eb23,0xf1afefa5,0xf546f39a,0xf7c9f6a4,0xf9b5f8d0,0xfba9faa1,0xfdf8fcc8,
0x0095ff45,0x033c01e3,0x065404b8,0x09e4080a,0x0dc70bce,0x12470fe6,0x180214f7,0x1e681b2f,
0x24ad21a0,0x299a2763,0x2c952b50,0x2e182d7d,0x2e612e6e,0x2cdc2dd3,0x2a512b9e,0x26fa28ce,
0x22f024ff,0x1e5f20ba,0x19191bdb,0x132b162f,0x0ca00fed,0x06e30996,0x02eb049e,0x0089019d,
0xfec6ffa2,0xfd81fe07,0xfcd9fd25,0xfc99fcad,0xfc22fc79,0xfaebfb99,0xf98dfa30,0xf906f929,
0xf929f915,0xf874f90b,0xf5d1f753,0xf2d9f436,0xf15ef1ed,0xf05ef0e4,0xee71ef90,0xec03ed34,
0xea95eb15,0xea45ea60,0xea77ea4d,0xeab8eaa8,0xeaa7eab0,0xeb28eabe,0xed93ec15,0xf26befba,
0xf89cf577,0xfecefbb5,0x0651023a,0x0fa20af1,0x1807140d,0x1e111b63,0x20d42007,0x1ed12050,
0x1a661cb8,0x15c91822,0x105a1331,0x0a200d4e,0x033306ba,0xfda20009,0xfa87fbd9,0xf901f986,
0xf981f902,0xfbecfa7c,0xff49fda9,0x01550081,0x01d601c0,0x017901b8,0x012b014e,0x00e00105,
0x00bc00bc,0x00b700b6,0x005a00ae,0xfecfffb3,0xfc7efdbd,0xfa54fb57,0xf825f947,0xf5a9f6e5,
0xf2d7f46b,0xeddaf0a0,0xe710ea9e,0xdfa8e360,0xd901dc1e,0xd40fd644,0xd1dad28d,0xd2e4d1e2,
0xd7c6d4fa,0xde41daf8,0xe446e164,0xe938e6d9,0xed50eb54,0xf1a3ef76,0xf581f39f,0xf8caf73f,
0xfaf7fa07,0xfc3cfbae,0xfd89fcd6,0xfefafe32,0x00e6ffed,0x02c601d2,0x054203e5,0x089406d7,
0x0c2c0a5f,0x105c0e21,0x15e012f1,0x1c94191e,0x2359201e,0x28672620,0x2bc82a43,0x2e012d0c,
0x2e272e65,0x2c772d6a,0x29d22b52,0x25f727fd,0x215b23c5,0x1c541eed,0x16301952,0x0fce1311,
0x09530c7c,0x0421067a,0x00e70250,0xff1affdd,0xfdedfe74,0xfd1efd80,0xfc7dfcc9,0xfbdffc32,
0xfacdfb66,0xf96efa21,0xf830f8bc,0xf816f801,0xf8bbf86d,0xf82bf8b3,0xf616f73c,0xf431f4f7,
0xf376f3c1,0xf2adf32f,0xf0bef1d2,0xee8cef90,0xed4cedcd,0xecb9ecf1,0xec81ec98,0xec49ec69,
0xec21ec2a,0xeccbec4a,0xef4eedc9,0xf3d7f158,0xf967f69b,0xff2efc31,0x06cc02ae,0x10430b6e,
0x18d914d8,0x1ee91c34,0x213020ac,0x1e9a205a,0x1a761c8f,0x160d1859,0x10a51381,0x0a300d89,
0x02f60699,0xfda6ffe8,0xfab0fbf5,0xf951f9c1,0xf9d7f95f,0xfc0afac8,0xfe5cfd4e,0xffc3ff2b,
0x000a0011,0xff96ffcc,0xff4aff80,0xfe5ffedb,0xfd83fde7,0xfcecfd2c,0xfc0cfc8f,0xfabffb76,
0xf969fa01,0xf8bcf905,0xf80ef86e,0xf734f7a5,0xf4e7f663,0xefa5f2a4,0xe873ec30,0xe0a9e489,
0xd9f1dd1a,0xd4fad730,0xd298d367,0xd3fcd2bb,0xd934d638,0xe072dcb8,0xe75ce410,0xecc6ea43,
0xf0f7eefc,0xf4d5f2ed,0xf860f6a3,0xfb6afa02,0xfd2bfc78,0xfe6bfdc5,0xffa6ff0a,0x00fb004f,
0x027a01b6,0x03ef0330,0x05e604d6,0x08550713,0x0aeb0991,0x0e7b0c84,0x13ba10e2,0x1a5d16ed,
0x20fa1dd2,0x25ff23aa,0x29d1280e,0x2c522b42,0x2cb02cca,0x2b622c23,0x28da2a54,0x25072712,
0x202c22a5,0x1ad41db5,0x149417b7,0x0e001154,0x07d80ad1,0x03170535,0x000b015c,0xfe7fff21,
0xfdd1fe10,0xfd92fdb1,0xfd0efd64,0xfc06fca3,0xfa2dfb28,0xf837f92a,0xf701f775,0xf71ff6e3,
0xf776f768,0xf669f723,0xf49cf574,0xf3f8f421,0xf420f403,0xf373f400,0xf1b8f2aa,0xf052f0e0,
0xef8fefea,0xef14ef4c,0xeeafeede,0xee68ee88,0xee67ee53,0xef62eeb3,0xf227f08b,0xf628f418,
0xfa98f84d,0x0003fd24,0x07090342,0x101f0b6d,0x18851490,0x1ec21c01,0x20a4205f,0x1dd91f96,
0x1a471c12,0x1646186c,0x110813c8,0x0aad0e08,0x0396070b,0xfe7700b8,0xfb8efcc5,0xfa5efabf,
0xfad0fa5d,0xfc87fba5,0xfe09fd4d,0xff44feb6,0xffa2ff97,0xff62ff8b,0xfe32fefb,0xfbf8fd21,
0xf9b7fabf,0xf80af8e3,0xf683f73b,0xf501f5ce,0xf43ef474,0xf438f433,0xf49af44e,0xf5a2f525,
0xf4d5f5a4,0xf047f301,0xe96fed06,0xe21be5b7,0xdb7ddea2,0xd6b1d8e3,0xd439d504,0xd586d467,
0xda90d7a0,0xe227de25,0xe9bfe617,0xf010ed1e,0xf4abf287,0xf88ff6a5,0xfc13fa5e,0xfec6fd94,
0x0015ff9e,0x00b00061,0x013400f4,0x01bc0175,0x02d70237,0x04530384,0x067e0554,0x08da07b1,
0x0b720a11,0x0eee0d0a,0x14141145,0x1a92173f,0x20b71dcd,0x258c234b,0x29262786,0x2aeb2a51,
0x2a702ae5,0x289829b4,0x256a2721,0x213d2384,0x1c741ed4,0x172b19e2,0x11451458,0x0adc0e08,
0x051507cf,0x00e702d2,0xfe36ff5b,0xfd05fd6a,0xfcf9fcec,0xfd16fd12,0xfcb3fcfc,0xfb5efc1a,
0xf9affa97,0xf7f8f8be,0xf75af77e,0xf7caf783,0xf7fff7f9,0xf6f0f7b5,0xf553f5f4,0xf540f51e,
0xf5dbf594,0xf570f5db,0xf412f4c3,0xf322f385,0xf299f2e0,0xf1eff248,0xf148f195,0xf0dbf10a,
0xf0e9f0cf,0xf1abf12e,0xf3cbf281,0xf6cff549,0xfa43f863,0xff56fc9b,0x060e0267,0x0ec90a48,
0x1710131e,0x1d6f1a9a,0x1f601f1c,0x1ce21e76,0x19ab1b3d,0x15f217f1,0x113e13af,0x0b5c0e89,
0x04bf07f3,0xffcf0200,0xfd0cfe1e,0xfc60fc8f,0xfd00fc87,0xfe80fdb4,0x0004ff40,0x015000c3,
0x01850192,0x006d012c,0xfd82ff30,0xf952fb78,0xf55bf73d,0xf257f3c1,0xf049f123,0xef2befad,
0xeedceee1,0xef05eef1,0xefeaef40,0xf213f0f7,0xf2a7f2c4,0xefa5f197,0xe9f0ecfd,0xe359e6b2,
0xdd4fe021,0xd8b6dadb,0xd60dd701,0xd72dd624,0xdbeed919,0xe3ebdfa8,0xec43e838,0xf336efee,
0xf861f609,0xfc5ffa6f,0xffc2fe2b,0x0263013c,0x0352030f,0x035d0360,0x03390352,0x02f50310,
0x03460308,0x041b0399,0x05da04de,0x08370701,0x0abd096d,0x0e0f0c3e,0x12f0104b,0x192215f2,
0x1f3b1c41,0x2498220a,0x28c426ec,0x2a9029f4,0x2a8a2ac3,0x288829d2,0x24f326ec,0x1ff92294,
0x1a431d39,0x1445173f,0x0e111143,0x07c80adf,0x02ab0501,0xff1a00bb,0xfcacfdb7,0xfbcdfc05,
0xfc01fbe0,0xfc17fc1a,0xfb4afbdf,0xf964fa63,0xf71ff848,0xf572f617,0xf576f53d,0xf669f5ea,
0xf734f6e0,0xf672f711,0xf575f5c7,0xf617f59d,0xf731f6b3,0xf6faf74b,0xf5f2f679,0xf5c1f5a7,
0xf5d7f5e9,0xf554f598,0xf4e3f518,0xf4b0f4c0,0xf4d3f4b8,0xf54ff4fe,0xf74df612,0xf9c0f88f,
0xfce3fb16,0x01a8ff1b,0x07cd0486,0x0f650b80,0x169f1320,0x1c5519d3,0x1dc51db1,0x1b4c1cc6,
0x184219c6,0x14c7169e,0x106912bc,0x0a680da3,0x041f071f,0xff65018a,0xfcdafdc6,0xfc5ffc77,
0xfd10fc89,0xfee6fdeb,0x00aaffd2,0x01ad0156,0x00d70189,0xfe0fffae,0xf98cfbf8,0xf49af700,
0xf096f264,0xedb3ef1f,0xec1bec9e,0xeba6ebd7,0xebc5eba9,0xebdfebd5,0xed03ec2b,0xefa3ee52,
0xf0eff09d,0xef65f080,0xeb2bed99,0xe572e85f,0xe00ce29f,0xdbc4ddcd,0xd92eda1b,0xd9fdd928,
0xde89dbbc,0xe6bee25b,0xef3ceb1d,0xf68df310,0xfc41f9a4,0x0077fe71,0x03e40253,0x05f30520,
0x066b065b,0x06370654,0x05c20607,0x05180569,0x048d04d2,0x04bd0477,0x0676056e,0x08c607a0,
0x0b3309f1,0x0e3e0c91,0x12791037,0x17db1515,0x1d871ab4,0x22a7202f,0x264824c2,0x27ec274f,
0x27be2817,0x256626cd,0x215e239b,0x1c321eea,0x164b1945,0x10751361,0x0a840d84,0x04d1078c,
0x00960285,0xfd94fef3,0xfbc2fc81,0xfb76fb6a,0xfbf5fbaf,0xfc77fc49,0xfbb0fc4a,0xf9c1facf,
0xf772f898,0xf618f690,0xf625f600,0xf6bbf665,0xf71bf70a,0xf623f6c1,0xf574f59a,0xf63bf5b7,
0xf72ff6c8,0xf718f746,0xf66ff6bb,0xf6a7f66b,0xf6ecf6e3,0xf6d4f6df,0xf69ef6c3,0xf682f67f,
0xf6bcf69f,0xf70cf6cf,0xf88ef7af,0xfa96f97c,0xfdc8fc00,0x0258ffe7,0x07fb0510,0x0eb50b2d,
0x15f91266,0x1b861927,0x1cfb1cd1,0x1b271c4d,0x185119c6,0x151416c3,0x110c133f,0x0b880e64,
0x061c08bb,0x016d03ab,0xfec3ffbf,0xfe13fe4c,0xfe69fe19,0xff74feda,0x01140035,0x024001d3,
0x0162021d,0xfe0c000c,0xf86ffb6b,0xf233f553,0xecfaef66,0xe8ebeac2,0xe718e7b1,0xe72de6f6,
0xe816e7a5,0xe883e84d,0xe9ece902,0xec34eb12,0xed60ed0a,0xeccbed48,0xea14ebbb,0xe607e825,
0xe1a5e3c7,0xddf2dfb8,0xdba1dc89,0xdbd2db53,0xe01edd54,0xe885e40a,0xf1b9ed2c,0xf9d4f602,
0xffbcfd17,0x03e901ed,0x073c05c4,0x08c1082c,0x08ec08fe,0x087208b8,0x07a6081c,0x06b10730,
0x055a0607,0x05080504,0x06460573,0x08b90768,0x0bb50a25,0x0f2c0d6d,0x12cf10ec,0x174f14e7,
0x1cb319f5,0x21a91f5d,0x24cd236b,0x266e25e5,0x25ab265a,0x23102490,0x1efc212e,0x19601c5c,
0x131c1646,0x0cd30fe8,0x06bd09ce,0x017303db,0xfdafff6e,0xfb0efc40,0xf993fa24,0xf98af962,
0xfa8ff9fc,0xfb55fb12,0xfae2fb45,0xf966fa3f,0xf7c8f88b,0xf6f9f73a,0xf731f701,0xf7cef777,
0xf7ccf800,0xf6d4f74e,0xf6a1f699,0xf749f6e7,0xf7a1f796,0xf756f783,0xf753f734,0xf7f7f7a8,
0xf84df821,0xf8cdf88d,0xf8cef8e6,0xf8aaf8af,0xf881f8a3,0xf8b9f87c,0xf9a2f91d,0xfb66fa56,
0xfee5fcea,0x03cd013a,0x09030667,0x0f0e0bd1,0x163812b1,0x1aeb1907,0x1bbd1bbe,0x1a541b45,
0x177718fb,0x143a15e3,0x0fec1253,0x0ab20d3e,0x06260861,0x01f103e4,0x001400b4,0xff85ffb6,
0xffefff9d,0x00dd0059,0x028701a5,0x03760341,0x017002dd,0xfc05ff1c,0xf4eef88c,0xedb2f13e,
0xe7fceaa4,0xe3dfe5a3,0xe23ce2ca,0xe2d9e23c,0xe3ebe38f,0xe429e401,0xe5c5e4c0,0xe810e6ef,
0xea1ce920,0xeb5deae6,0xeb0aeb64,0xe90eea46,0xe5f1e799,0xe294e432,0xe024e13d,0xdfbcdf7e,
0xe3cae11f,0xebdfe77f,0xf538f09c,0xfd0cf965,0x029a001d,0x06c804c2,0x09d30892,0x0ad50a81,
0x0ad70aee,0x0a100a8b,0x092a0997,0x080c08b2,0x064f072b,0x05a005cd,0x066e05d1,0x089f0768,
0x0b850a03,0x0e6d0d0c,0x116d0fd7,0x156e1345,0x1a6217d3,0x1eee1cd9,0x221120a0,0x23942318,
0x23062391,0x207d21f5,0x1c361e92,0x162a1958,0x0fa412e8,0x09650c6f,0x0399066e,0xff3a0127,
0xfc5cfda7,0xfa71fb54,0xf973f9cd,0xf9abf967,0xfac1fa2f,0xfb90fb3f,0xfb50fb93,0xfa44fadb,
0xf947f9b5,0xf8c6f8f2,0xf8bef8b9,0xf8dff8d8,0xf816f8a2,0xf6fff76d,0xf708f6ec,0xf758f735,
0xf70af745,0xf6def6dd,0xf78af71f,0xf811f7e2,0xf885f836,0xf940f8ee,0xf93df958,0xf91ff928,
0xf90cf911,0xf97cf934,0xfa43f9d5,0xfc0cfaee,0x000bfdc4,0x054902a8,0x0a2807c2,0x0fcc0cb5,
0x169c1355,0x1a7f1907,0x1b611b2d,0x1a611b2b,0x179d191c,0x14641610,0x0fea1257,0x0b500d70,
0x077f096f,0x041f0595,0x02ae0346,0x02200241,0x02600231,0x03020299,0x047103b2,0x04bb04e5,
0x019e03b6,0xfa62fe62,0xf1a5f611,0xe951ed54,0xe2a0e5c3,0xde59e00e,0xdcbbdd3f,0xdda5dcf1,
0xdeb6de56,0xdf96df0e,0xe140e059,0xe34ce240,0xe5b6e474,0xe7f9e6ee,0xe933e8ba,0xe93fe968,
0xe7bae8a3,0xe597e6ae,0xe3c3e498,0xe3c2e355,0xe7eee54a,0xefd2eb82,0xf91af48a,0x00e3fd3e,
0x06b903fe,0x0b450922,0x0e530d15,0x0f300eea,0x0eef0f37,0x0da70e5a,0x0c840d0a,0x0b080bea,
0x090109f7,0x07a2083d,0x0768074c,0x08fb0800,0x0b6d0a22,0x0e200cc7,0x10f40f84,0x14461282,
0x185e1644,0x1c251a61,0x1ed71da3,0x20011f9e,0x1fa5200f,0x1db21ede,0x194e1be0,0x13431656,
0x0ccb100f,0x06a609b2,0x00e003a1,0xfcb1fe8c,0xfa4dfb58,0xf8d9f97b,0xf835f86e,0xf892f843,
0xf9a6f915,0xfa6bfa27,0xfa4cfa6c,0xfa0cfa30,0xf9aef9d8,0xf96df98c,0xf952f953,0xf99af974,
0xf8e2f96c,0xf7def842,0xf7bcf7c2,0xf7a3f7af,0xf74ef782,0xf768f743,0xf833f7ba,0xf907f8b1,
0xf987f945,0xfa1ef9d9,0xfa3ffa36,0xfa52fa47,0xfa1bfa3e,0xfa2cfa0e,0xfaaefa66,0xfc29fb2e,
0xfffcfdcd,0x04f10270,0x09940756,0x0ebf0bee,0x153e11fd,0x19cb17ea,0x1b861aef,0x1b451bb1,
0x18f51a3f,0x164217ac,0x123e147a,0x0ddd0fe6,0x0a620c19,0x076008b6,0x0610068f,0x055d059f,
0x05870553,0x062005ce,0x072506a1,0x06d40750,0x02770542,0xf9d7fe89,0xefadf4c8,0xe62eeac8,
0xde85e212,0xd982db8e,0xd7b0d848,0xd87cd7d6,0xd993d925,0xda58d9ed,0xdbc2daf6,0xddbadcb6,
0xe072def7,0xe3afe215,0xe648e514,0xe817e750,0xe874e882,0xe746e7f1,0xe5ffe69c,0xe665e5ca,
0xea38e7e4,0xf15aed62,0xfa6cf5d2,0x02acfec5,0x09580626,0x0ec30c47,0x122e10c5,0x134312f4,
0x12d31339,0x1164122d,0x100a10b0,0x0e3c0f3b,0x0be80d13,0x0a020ae1,0x0911095f,0x09c50939,
0x0bbe0aa9,0x0e1b0ce5,0x10d30f6b,0x1414125b,0x17e115f7,0x1b4b19a8,0x1db31cad,0x1e841e49,
0x1db01e54,0x1b541cb9,0x16461923,0x0fcb1323,0x09100c61,0x030c05f0,0xfe00005e,0xfa63fbfe,
0xf851f932,0xf71af79f,0xf66bf6b1,0xf680f65d,0xf76af6d8,0xf875f80d,0xf8d5f8a7,0xf92cf90f,
0xf957f938,0xf9a5f97e,0xfa1cf9d8,0xfa9ffa72,0xf9c2fa62,0xf8acf910,0xf871f88f,0xf831f854,
0xf790f7e5,0xf7a9f778,0xf8dff825,0xfa07f996,0xfaa4fa4c,0xfb55fb0a,0xfbb4fb86,0xfbe6fbdd,
0xfb8bfbc8,0xfb7bfb66,0xfba1fb93,0xfc8dfbd3,0xff7bfdce,0x03e00191,0x0869063a,0x0d4f0a9b,
0x144910b1,0x19d41774,0x1c911b7b,0x1d171d25,0x1b361c58,0x188119f7,0x1450169f,0x100711fe,
0x0cc30e61,0x09c90b21,0x084708d9,0x07ea07ec,0x08580819,0x08e6089c,0x099e094b,0x08b4098b,
0x03cb06d8,0xfa68ff91,0xef11f4c7,0xe437e978,0xdb2cdf65,0xd534d7b9,0xd2a8d391,0xd2f0d282,
0xd3b8d373,0xd491d3fd,0xd657d563,0xd886d760,0xdbd5d9f9,0xe00addf4,0xe3a9e1f3,0xe69ae537,
0xe828e7ae,0xe7cee80c,0xe779e79a,0xe866e79a,0xec71ea0e,0xf3a1ef9d,0xfd2af848,0x061401df,
0x0d2709cd,0x12731010,0x15c71456,0x16ed16a0,0x168116dc,0x152b15eb,0x139f1464,0x11db12cb,
0x0fa710c4,0x0dce0eaf,0x0c300ce5,0x0c010bda,0x0d7f0c9a,0x0f720e78,0x119e1080,0x13f812ce,
0x16531521,0x18b6178f,0x19e81981,0x19f21a14,0x18ed1980,0x16961812,0x11c51470,0x0b7e0eba,
0x05050839,0xff2b01fb,0xfa5cfc9f,0xf6f0f870,0xf53cf5eb,0xf443f4b8,0xf3b8f3e7,0xf3eaf3b1,
0xf53ff474,0xf6d0f616,0xf85cf78d,0xf9b4f926,0xfa60fa0c,0xfb19fac1,0xfbc0fb64,0xfc21fc16,
0xfafafbbb,0xf9b1fa37,0xf929f965,0xf8faf90b,0xf8a5f8d1,0xf8f6f8b0,0xfa78f98c,0xfc1ffb68,
0xfd3efcb6,0xfe11fdb0,0xfea1fe67,0xfe74fea9,0xfd9dfe0a,0xfda9fd82,0xfdb7fdc0,0xfe36fdce,
0x0025fefa,0x03b701c8,0x07c605c1,0x0c2f09cf,0x127f0f2c,0x183115a5,0x1ba21a1c,0x1d3e1cbd,
0x1c351d0a,0x19c81b11,0x15e91817,0x11b0139e,0x0ea8101f,0x0be10d25,0x0a600af6,0x0a430a28,
0x0abb0a8b,0x0ada0ad1,0x0a8a0ace,0x088409e4,0x03010645,0xf989feac,0xedf1f3d8,0xe2c7e82a,
0xd92fddc3,0xd28bd560,0xcf4ed08c,0xcef6ced9,0xcf9ccf4b,0xd0c1d005,0xd2b5d1b8,0xd479d39a,
0xd755d5a4,0xdb8cd965,0xdf8ddda6,0xe317e153,0xe5c3e4a4,0xe751e69b,0xe899e7fb,0xea73e959,
0xeeb3ec3c,0xf57af1bb,0xfe90f9dd,0x07af0344,0x0f7c0bc3,0x155912b9,0x18fa176b,0x1add1a24,
0x1b021b14,0x1a081aaa,0x186c193b,0x16ba17a7,0x149715a6,0x12711387,0x10511163,0x0f1e0f74,
0x0fab0f45,0x10ba102c,0x11f71153,0x136212aa,0x14d3140d,0x16ac15c5,0x17971740,0x173b1798,
0x161a16bb,0x135c150d,0x0e9f1132,0x089b0bac,0x023a056e,0xfc6bff35,0xf7a5f9da,0xf461f5d2,
0xf2b3f359,0xf1e8f244,0xf1a3f1b2,0xf21ff1c0,0xf39df2c3,0xf56bf48a,0xf743f652,0xf89ef815,
0xf969f902,0xfa58f9da,0xfb4efad2,0xfbc6fbb9,0xfa70fb4a,0xf929f9a9,0xf8b8f8e1,0xf8c8f8b6,
0xf8a9f8bd,0xf90df8bd,0xfaecf9c6,0xfd38fc27,0xfef7fe21,0x004dffae,0x010400c9,0x00ad00f8,
0x00000047,0x003a000b,0x0018003e,0x00390006,0x01a700bb,0x04e70319,0x08dc06d8,0x0d900b01,
0x147a10d0,0x1ac317f7,0x1e5e1ccf,0x1fbf1f65,0x1e021f39,0x1aa61c78,0x15d61875,0x10d4131f,
0x0d240eed,0x0a0e0b72,0x08e30934,0x09be0915,0x0b3c0a91,0x0bec0baa,0x0b930beb,0x09170aaf,
0x033b06b7,0xf97bfebd,0xed8ff3a2,0xe1ebe792,0xd78ddc89,0xd052d36d,0xccaace1b,0xcc02cc14,
0xcc60cc1c,0xcdb1cce0,0xcfb7ceb2,0xd160d08c,0xd43dd28b,0xd85ed64c,0xdc5bda71,0xe030de46,
0xe3a1e1fd,0xe67ce514,0xe92be7e4,0xebf7ea6e,0xf0dfee22,0xf814f42c,0x0147fc86,0x0a820609,
0x11ee0e79,0x175a14eb,0x1ac61934,0x1ce21c12,0x1d611d46,0x1cb11d2f,0x1b551c04,0x19ca1aa0,
0x181118f0,0x1634172e,0x13bc1505,0x11f0129e,0x11d111c1,0x123411f5,0x12c71285,0x133412fa,
0x1425138b,0x154314c7,0x158a1588,0x14aa1534,0x131a140f,0x0fce11a7,0x0af20d92,0x05470830,
0xff5a0241,0xf9dcfc90,0xf545f75f,0xf211f37f,0xf04af107,0xef7aefcb,0xef48ef52,0xefe9ef75,
0xf1b2f0af,0xf40af2d1,0xf657f535,0xf851f772,0xf9b2f907,0xfaf7fa53,0xfc34fba0,0xfc7efc93,
0xfafdfbe7,0xf997fa24,0xf95bf95e,0xf9a1f973,0xf9c8f9c1,0xfa26f9d5,0xfc13fae7,0xfe86fd5b,
0x007aff8d,0x021d0161,0x02e702a6,0x025c02c6,0x01df01fe,0x021701fe,0x01cb0200,0x019f0198,
0x02f3020b,0x060f0451,0x0a290813,0x0f460c6f,0x16d112dc,0x1d131a62,0x204f1efe,0x20f1210c,
0x1e561fe3,0x1aaf1c9e,0x15ce186a,0x10bf132a,0x0c960e9c,0x09440ab9,0x0891088c,0x0a0c0928,
0x0ba30af6,0x0bc70bef,0x0a350b30,0x06e008d7,0x003f0409,0xf640fba7,0xea8ff06a,0xdf0be4ba,
0xd4ebd9ba,0xcddfd0e0,0xca7ecbca,0xca0bc9fb,0xcaa4ca4b,0xcbe9cb31,0xcd9dccc2,0xcf46ce5e,
0xd27bd09f,0xd6cdd4a0,0xdacdd8da,0xdea4dcb4,0xe293e09b,0xe69be48b,0xeab1e8b4,0xeec0ec97,
0xf49df176,0xfc74f83f,0x05cb0116,0x0e610a4e,0x14cb11d6,0x19401748,0x1c821af1,0x1eaf1dc8,
0x1f981f49,0x1f1c1f82,0x1e121e9d,0x1cbd1d77,0x1b281bf8,0x19261a41,0x164217be,0x141114f1,
0x134e1399,0x12d91314,0x12211287,0x118b11bc,0x120811a7,0x12aa1268,0x12a212cb,0x116a1224,
0x0f421085,0x0bd70da9,0x074f09b2,0x024b04d9,0xfd2effb0,0xf850fabe,0xf418f612,0xf0f5f25b,
0xef20efea,0xee21ee8c,0xedd2ede2,0xee98ee0b,0xf0a4ef7e,0xf34df1f7,0xf5cbf48d,0xf7eaf6f1,
0xf9a1f8c9,0xfb4bfa80,0xfcd0fc11,0xfd69fd5c,0xfc06fcdf,0xfae4fb4b,0xfad4fac8,0xfb37faff,
0xfb17fb38,0xfb31fb04,0xfce7fbd7,0xff18fe11,0x011a0011,0x02fb021f,0x03df039b,0x034b03b6,
0x02e202f5,0x03170307,0x027702e7,0x01bf01fb,0x027501e5,0x04f90378,0x08da06c9,0x0e4e0b42,
0x167f1227,0x1dd31a8c,0x22762065,0x243123ce,0x223a2398,0x1e7e2086,0x18fd1bf5,0x136d160c,
0x0e8810f9,0x0aa00c45,0x09a209c7,0x0adf0a0f,0x0c1f0bae,0x0b830c14,0x08f80a6c,0x04c70722,
0xfe3c01dc,0xf4cbf9c9,0xe9cdef69,0xdec1e42f,0xd46dd967,0xccfbd046,0xc8d9ca85,0xc7b6c7f5,
0xc7ecc7c9,0xc8d9c83b,0xca49c99b,0xcbdacaf8,0xcf4ccd48,0xd3cad18e,0xd81cd605,0xdbf3da04,
0xdfceddde,0xe445e1e9,0xe942e6c4,0xee9eebcc,0xf58ff1e8,0xfe07f98d,0x08270301,0x113e0cfa,
0x17bf14d6,0x1c211a25,0x1f391dbd,0x21882096,0x22aa2237,0x228022c6,0x21772203,0x201f20cf,
0x1eb31f76,0x1ced1de5,0x1a0c1b9b,0x178c1899,0x166116e4,0x154715d8,0x13af1491,0x122412cb,
0x11be11d1,0x11ad11b8,0x11041182,0x0f35103f,0x0c1a0dce,0x08760a57,0x042d065a,0xffb401f1,
0xfb4dfd83,0xf699f901,0xf22af449,0xeeaaf045,0xec75ed68,0xeb5debc7,0xeb56eb35,0xeca7ebcd,
0xef5dedda,0xf275f0f9,0xf518f3d0,0xf731f63d,0xf8eaf810,0xfa80f9bf,0xfbe7fb37,0xfc88fc71,
0xfb1afc05,0xf9cbfa43,0xf9e4f9b4,0xfacbfa53,0xfb20fb0d,0xfbbffb4b,0xfdeefca1,0x007dff4b,
0x02ce019e,0x04ea03f4,0x061005ad,0x05b50600,0x058c0589,0x05b105a4,0x04c30567,0x037a03ff,
0x0376034b,0x05500426,0x08b506d9,0x0e2c0b08,0x16ef124d,0x1ed81b4d,0x23d521a4,0x25ca2548,
0x241d2556,0x2082227c,0x1b011dfb,0x15451803,0x101412ad,0x0c3b0dc4,0x0b730b81,0x0c720bd4,
0x0cd10ce6,0x0ab70c15,0x06c508e0,0x01b90466,0xfae1fea2,0xf1c3f68b,0xe744ec94,0xdd13e212,
0xd394d82a,0xcc47cf95,0xc7bec9b6,0xc609c690,0xc5e4c5f2,0xc65ec600,0xc755c6d1,0xc8c8c7e7,
0xcc5fca4e,0xd12ecebf,0xd5ead39d,0xda39d819,0xde46dc46,0xe2c7e064,0xe864e580,0xeebbeb64,
0xf6b4f292,0x0023fb2c,0x0b050582,0x146f1023,0x1af01800,0x1f391d50,0x227920e8,0x24c223c5,
0x260a2586,0x2600263a,0x24d82572,0x2374242d,0x220022b6,0x201e212e,0x1cf41ea9,0x1a1f1b5a,
0x1871193d,0x167b1791,0x13a9152f,0x1110123c,0x0f4a1017,0x0e7d0ec7,0x0da10e24,0x0bd10ce8,
0x08cb0a69,0x051e0707,0x0125032b,0xfd2cff1b,0xf93dfb41,0xf4b9f70a,0xf043f26d,0xec6fee3f,
0xe9efeb05,0xe8a7e927,0xe8a4e873,0xea4be945,0xeda0ebc9,0xf14aef87,0xf455f2db,0xf6f1f5bb,
0xf8f4f7fc,0xfab6f9e3,0xfc48fb7f,0xfd51fcf0,0xfc9efd2d,0xfb7ffbee,0xfbb8fb75,0xfcb6fc2a,
0xfd77fd2e,0xfe55fdca,0x0054ff2b,0x02c2019f,0x048603ae,0x060a0550,0x06cd0698,0x069406ba,
0x066d0677,0x069a068a,0x05be065a,0x044104f8,0x03ab03c2,0x0511041e,0x08280677,0x0d1b0a39,
0x1619112d,0x1f061afb,0x24752222,0x26a82604,0x251c264e,0x219a2382,0x1c781f3d,0x1690197a,
0x114913da,0x0d1c0ee3,0x0bed0c2b,0x0c5e0c1f,0x0c180c75,0x093e0b02,0x04b20713,0xff6c022d,
0xf8f5fc67,0xf05cf4f2,0xe653eb5d,0xdcb2e167,0xd3cdd829,0xcca9cfe4,0xc82eca20,0xc658c6e4,
0xc602c625,0xc5ddc5e3,0xc660c603,0xc7b3c6e0,0xcb07c919,0xcfefcd68,0xd4a1d25f,0xd8c0d6bf,
0xdca0daae,0xe0f2dea7,0xe6abe3a2,0xedace9fb,0xf682f1e6,0x00b8fb5a,0x0c260673,0x15e31162,
0x1c5f1981,0x20c81ed3,0x23f22263,0x26602550,0x27e12742,0x28012821,0x270e2796,0x25d32673,
0x2484252c,0x22e623d1,0x203121ac,0x1d8c1eb5,0x1bb21c9f,0x19081a85,0x1572174b,0x123113c3,
0x0f8c10b7,0x0e300eca,0x0cc10d8e,0x09f90b93,0x063c082f,0x01ea0419,0xfda8ffc1,0xf9e9fbae,
0xf683f83d,0xf2baf4ad,0xeeaef0b4,0xeadcecb0,0xe81fe951,0xe684e735,0xe647e629,0xe7f9e6e2,
0xeb9ae997,0xefabedb6,0xf318f16d,0xf610f4ab,0xf874f74f,0xfa7df980,0xfc86fb86,0xfdc9fd52,
0xfd51fdc4,0xfc74fcc0,0xfccbfc81,0xfdb7fd38,0xfe70fe20,0xff58fece,0x017f003a,0x03fc02df,
0x055304bc,0x069305ee,0x0767071e,0x077c077b,0x079f0780,0x07ec07cf,0x070107b1,0x051e060e,
0x040b045b,0x052c044e,0x081d067d,0x0d150a2a,0x1681114b,0x20851bdb,0x271e243e,0x2a3d2935,
0x28c72a04,0x24e026ff,0x1f552253,0x190f1c21,0x13c51656,0x0f6e115f,0x0d990e2f,0x0cff0d4b,
0x0b840c84,0x07a609db,0x021e04fd,0xfc44ff36,0xf5d6f935,0xed86f1f3,0xe3fce8c2,0xdb1cdf6f,
0xd2d9d6e7,0xcc39cf3b,0xc7fdc9d8,0xc60fc6bd,0xc54ec5ac,0xc4b3c4f8,0xc485c484,0xc53bc4b8,
0xc812c649,0xcd27ca7d,0xd232cfcd,0xd66bd460,0xda49d869,0xde57dc32,0xe3e8e0e8,0xeb38e746,
0xf4daefce,0x0048fa4d,0x0d1406ab,0x18481314,0x1fd11c7c,0x24562271,0x270a25c2,0x2928283b,
0x2a6c29e4,0x2ac32abe,0x2a322a8e,0x292429b2,0x27e72883,0x269b274c,0x246025a3,0x2226232a,
0x204f2146,0x1cec1ee9,0x18271a92,0x137315c7,0x0fb2115d,0x0d650e6b,0x0b830c84,0x08670a1c,
0x046c0687,0x000d023b,0xfbbefdde,0xf7e7f9bf,0xf462f622,0xf0a1f294,0xeca5eea8,0xe895ea91,
0xe5a0e6f0,0xe3e0e497,0xe3b7e395,0xe559e440,0xe90de700,0xed58eb47,0xf116ef41,0xf46cf2d5,
0xf6faf5c4,0xf933f81d,0xfb5afa49,0xfcb5fc2f,0xfc90fcd8,0xfc22fc39,0xfcb3fc4f,0xfdd4fd37,
0xfee2fe69,0x001fff64,0x028d0127,0x05260402,0x066a05e3,0x075806ea,0x080407bf,0x08250823,
0x08730835,0x08ef08c6,0x082b08bc,0x06710751,0x05ab05d2,0x06f70610,0x09c5083d,0x0ec70bd2,
0x187f131b,0x22bc1dfe,0x299e268d,0x2d182bea,0x2bec2d08,0x28352a39,0x22ba25c4,0x1c421f68,
0x16c01971,0x11ed1425,0x0f4a1057,0x0d6e0e6a,0x0a3d0c14,0x052f07ef,0xff1b021f,0xf8f0fc0d,
0xf24ff5c3,0xe9dcee56,0xe0b0e53f,0xd873dc6f,0xd138d4b2,0xcb9ace2c,0xc7e7c985,0xc5f7c6be,
0xc4a4c55a,0xc32ac3da,0xc28cc2b4,0xc2fbc2a3,0xc5c4c3f5,0xcb1ac84a,0xd00ccdba,0xd439d231,
0xd7f2d623,0xdbc7d9bc,0xe128de3f,0xe868e487,0xf257ed02,0xfeeef857,0x0cea05ef,0x18ec1354,
0x211b1d7f,0x262f23f7,0x29eb2812,0x2cc02b89,0x2e8a2db7,0x2f432f16,0x2ee22f24,0x2de82e76,
0x2c712d35,0x2af82bbe,0x28d429fd,0x26c727b8,0x24b925e8,0x204122d1,0x1a091d41,0x13c416cd,
0x0f021124,0x0bcc0d36,0x09860ab2,0x06440801,0x0240045d,0xfdaffffc,0xf939fb6c,0xf539f725,
0xf1dcf37b,0xee92f03d,0xeaedecd4,0xe6dae8dc,0xe3bfe522,0xe1dde2a9,0xe141e160,0xe2a8e1a3,
0xe664e44e,0xeae4e8ae,0xeefbecf3,0xf2b1f0f2,0xf57af42a,0xf7d1f6ac,0xfa3af904,0xfc48fb5e,
0xfcd2fcc1,0xfcd8fcc0,0xfde1fd40,0xff94fea4,0x0130007d,0x02c701e0,0x056803f4,0x080206e8,
0x091508ad,0x098b095e,0x09ad09a5,0x093f0986,0x08f50904,0x08b708e3,0x077f084b,0x0550066c,
0x040b0475,0x04960415,0x070f058b,0x0be30916,0x15300feb,0x20b41b17,0x29d525a0,0x2fa12d40,
0x30a330c2,0x2dc12f85,0x285b2b63,0x217e24e7,0x1b821e67,0x160818a3,0x11d613d5,0x0da40fd0,
0x09140b6b,0x03450656,0xfcbd0001,0xf666f991,0xefd2f32c,0xe7e1ec18,0xdeeae35d,0xd6cedab3,
0xcfb8d326,0xca01cc99,0xc682c80b,0xc4c2c564,0xc3e2c459,0xc2e3c359,0xc292c2a9,0xc2b9c291,
0xc4fdc369,0xca0fc74f,0xcf38ccc1,0xd351d158,0xd6fad534,0xda75d8a8,0xdf33dc96,0xe5c8e245,
0xef41ea1b,0xfb73f510,0x09b3026d,0x174710c4,0x21a21cfa,0x2851254d,0x2ced2ad0,0x306c2ed6,
0x329b31a5,0x33943348,0x33363384,0x31fc32c0,0x2fcc30f6,0x2d932ea6,0x2b512c7e,0x296b2a48,
0x2777289d,0x235d25b7,0x1d30208e,0x15d61975,0x0fa6128c,0x0b250d33,0x077c0952,0x0376058f,
0xfee30137,0xfa3afc8b,0xf5e7f7ff,0xf238f3f4,0xef5af0b7,0xec65edee,0xe8d3eab8,0xe4bce6c6,
0xe171e2e5,0xdfaee066,0xdf17df3a,0xe06edf78,0xe411e1ff,0xe8dbe672,0xed81eb34,0xf1d2efc3,
0xf51ff39a,0xf7c8f67f,0xfa4ff90a,0xfc68fb73,0xfd0efcf4,0xfd08fcfe,0xfdf5fd5a,0xffcffec7,
0x01d000e9,0x03a102a3,0x066704dd,0x0961080d,0x0a730a1f,0x0aa50a8e,0x0ad00ac6,0x0a6f0aab,
0x0a2c0a53,0x098509e3,0x080008f3,0x057006b5,0x03ea0481,0x040e03bd,0x068504fc,0x0b32088c,
0x13e80ee6,0x1ffb19db,0x2a78259c,0x31b62e8c,0x346633ae,0x326733da,0x2d983056,0x26d72a48,
0x209f23aa,0x1a4a1d7a,0x143c1743,0x0df11111,0x084e0b17,0x01fe0548,0xfb00fe8f,0xf45cf790,
0xee00f13a,0xe6adea89,0xde45e280,0xd616da17,0xcec7d261,0xc8b9cb70,0xc4ffc6a2,0xc30ec3cb,
0xc250c2a7,0xc17dc1f4,0xc0e5c123,0xc0a9c0b1,0xc284c131,0xc729c494,0xcc9ac9e7,0xd10ccefc,
0xd4c7d2f8,0xd818d66e,0xdc6ada08,0xe29fdf3f,0xeba5e6b8,0xf762f12f,0x0600fe5f,0x15800de5,
0x21eb1c47,0x2a712699,0x303a2da0,0x3472327a,0x371935f9,0x387037ee,0x38373883,0x370d37c3,
0x34c53604,0x32493387,0x2ff23116,0x2dca2ecf,0x2bc22ce3,0x27d32a1c,0x20f224c8,0x18611cb0,
0x1084144a,0x0aa30d52,0x05d00821,0x01260390,0xfc46feae,0xf768f9cd,0xf2e9f51f,0xef1ef0e1,
0xec1bed93,0xe91ceaa7,0xe5a2e765,0xe226e3dc,0xdf46e091,0xddb1de51,0xdd82dd69,0xdefcde06,
0xe26de076,0xe75ce4d1,0xec60e9e4,0xf0fceecd,0xf45bf2d0,0xf6d6f5a9,0xf936f802,0xfb2bfa4a,
0xfbb5fba9,0xfb83fb86,0xfcaefbe8,0xff3cfdcc,0x01e500b4,0x044c0304,0x079705c7,0x0b350992,
0x0c7b0c1f,0x0cb10c95,0x0cbe0cc8,0x0c330c82,0x0b600bd6,0x0a670ae9,0x085b099d,0x056906d3,
0x03e60471,0x046103d5,0x0741058e,0x0c450976,0x14ce0ffb,0x20bb1a91,0x2b9f2684,0x33b33019,
0x376c3623,0x3644376e,0x317f3437,0x2abd2e33,0x24062763,0x1cc12079,0x155c191c,0x0d741152,
0x06c80a05,0xffb90360,0xf888fc16,0xf1caf517,0xeb77ee9e,0xe45fe80f,0xdc5fe070,0xd46dd854,
0xcd57d0ce,0xc752ca06,0xc3c5c54f,0xc244c2be,0xc1f2c218,0xc1c6c1d6,0xc18ec1ae,0xc135c15b,
0xc295c18a,0xc672c44a,0xcb81c8ed,0xd038ce01,0xd3a9d213,0xd698d51b,0xda67d84d,0xdfd8dcdc,
0xe82be399,0xf34bed6e,0x0186f9fe,0x11b10995,0x1fce1939,0x2a452569,0x31a42e5f,0x36d5346b,
0x3a5538c7,0x3c4c3b86,0x3c893ca6,0x3b6f3c21,0x38f53a54,0x35f33778,0x32d6345c,0x30033163,
0x2d712ebb,0x29992bcb,0x231526b7,0x1a8f1ee2,0x123b1649,0x0ba00eb9,0x064708d7,0x00f303b6,
0xfb7afe2e,0xf644f8c7,0xf1aef3eb,0xede9efac,0xeae2ec53,0xe7e7e977,0xe47ae639,0xe11ee2c6,
0xde53df9d,0xdc95dd4a,0xdc43dc3a,0xdd63dca2,0xe03ade9a,0xe47ae23b,0xe927e6ce,0xedcceb91,
0xf122ef9d,0xf3a8f26f,0xf656f4f4,0xf8e2f7a4,0xfa75f9e9,0xfb1efabd,0xfd09fbe3,0x0038fe7c,
0x036d01ee,0x065204d2,0x09d007fd,0x0d840bcc,0x0f0f0e97,0x0f280f2f,0x0ed10f0e,0x0dd90e65,
0x0c790d2e,0x0af40bba,0x088f09f1,0x055706ec,0x0350041a,0x03710312,0x05cb0459,0x0ace07eb,
0x12ed0e70,0x1e1b1836,0x2a132431,0x344b2f8a,0x3a7237fb,0x3b7b3bb5,0x378239eb,0x3117347b,
0x29df2d98,0x218725cf,0x18d21d45,0x0efc13f8,0x06470a63,0xfe7b0267,0xf696fa78,0xef32f2d5,
0xe880ebcd,0xe1a1e518,0xda7dde21,0xd338d6ce,0xcc99cfd5,0xc673c961,0xc276c431,0xc0acc13d,
0xc086c081,0xc0ffc0b2,0xc19bc14e,0xc1b6c1c7,0xc236c1b0,0xc501c35c,0xc999c722,0xce78cc28,
0xd1edd061,0xd49bd349,0xd7fcd61f,0xdcecda37,0xe47de059,0xee72e933,0xfb25f45f,0x0b0c02ca,
0x1b61136b,0x292c22b0,0x335b2ebd,0x3a1c371b,0x3ec03ca5,0x41864066,0x426a422f,0x415b4222,
0x3ebd4039,0x3b423d10,0x375c3944,0x33e03591,0x30983238,0x2cd52ee2,0x26af2a26,0x1e2522a5,
0x14a5195d,0x0c291031,0x059008a4,0xffbf02aa,0xf9effccf,0xf485f721,0xefe3f220,0xec2aedee,
0xe8fdea79,0xe5f4e78b,0xe296e43f,0xdf77e0f5,0xdd13de2f,0xdb42dc0d,0xdafbdae9,0xdc10db5a,
0xdea9dd29,0xe276e070,0xe704e4a8,0xeb81e962,0xeed1ed48,0xf167f02e,0xf419f2b5,0xf694f574,
0xf793f743,0xf84ef7c8,0xfa9cf945,0xfe6cfc5f,0x02320067,0x05f903ff,0x0a7b0822,0x0ed20cd3,
0x1107102e,0x11c7118d,0x114611b2,0x0fef10a8,0x0e4c0f20,0x0cc40d91,0x0a280bad,0x067c084b,
0x0428050f,0x042003d6,0x066404fa,0x0b77087b,0x13ce0f53,0x1df218b5,0x29a3239a,0x351f2fad,
0x3cd4398c,0x3fb53efe,0x3c543eb8,0x3600394c,0x2e1f325a,0x24342946,0x19bc1f1b,0x0e971413,
0x04d70983,0xfc6d0089,0xf48bf865,0xed2ff0d5,0xe682e9c4,0xe030e34d,0xd9efdd18,0xd3b0d6ca,
0xcd4fd08f,0xc711ca1d,0xc22cc457,0xc008c0bc,0xbf98bfb6,0xc074bfce,0xc1fac14b,0xc235c24a,
0xc214c1f3,0xc3dac2bf,0xc78dc57c,0xcbe4c9cc,0xcf1bcdaa,0xd166d03b,0xd495d2e1,0xd932d6a2,
0xe06ddc87,0xe9aee4b9,0xf5ccef59,0x0566fd27,0x173b0e3f,0x27ea1fea,0x34d52ee3,0x3d7b39b6,
0x42da406d,0x45f944b7,0x46f446af,0x45cc46ad,0x42f24478,0x3f814147,0x3b533d85,0x3754393d,
0x33b73581,0x302031f4,0x2abf2dda,0x226a26e0,0x186f1d7a,0x0ec11382,0x069d0a66,0xfff20333,
0xf991fcc2,0xf3aaf67b,0xeeb3f117,0xeab2ec98,0xe760e8f8,0xe407e5c9,0xe05ae224,0xdd2bdeb1,
0xdaf3dbe8,0xd95dda14,0xd923d908,0xda1cd977,0xdc7cdb20,0xdfdede16,0xe3fce1cd,0xe877e652,
0xebcaea3f,0xee89ed3c,0xf12fefd2,0xf40bf2ad,0xf5bdf517,0xf6f9f640,0xf9b6f828,0xfddbfb9f,
0x026c003b,0x06d8048f,0x0b9c0934,0x10490e15,0x12ef11e7,0x13c7138a,0x1312139a,0x11631252,
0x0f201046,0x0cea0e04,0x0a3b0bb4,0x06d30887,0x04960570,0x04d30469,0x073d05bd,0x0c860971,
0x14fd1076,0x1ed819c8,0x2a4e2456,0x361d3077,0x3e583ac8,0x422340cc,0x401541e5,0x3a1c3d58,
0x32293678,0x279a2d20,0x1c3121f3,0x0fe2161e,0x048009e6,0xfb23ffac,0xf268f6b5,0xea7aee57,
0xe363e6d3,0xdd12e022,0xd734da1f,0xd13bd439,0xcb35ce3f,0xc54fc82b,0xc0d5c2cc,0xbeeebf79,
0xbf6abefd,0xc10bc018,0xc327c235,0xc3d5c3b8,0xc36dc395,0xc466c3b1,0xc72cc591,0xcaaec8fc,
0xcd46cc24,0xcf59ce3c,0xd268d0bb,0xd6c0d455,0xddbad9f6,0xe637e1c2,0xf15aeb5e,0x004df84c,
0x12900930,0x24d91bf5,0x33f22cd9,0x3ea239ed,0x459a425b,0x49c54816,0x4b8e4ae9,0x4aef4b9a,
0x486149c7,0x453a46d9,0x4141435c,0x3c823ef2,0x38163a31,0x338635ef,0x2d4b30b4,0x242f2918,
0x197d1ee9,0x0ee41411,0x06220a3c,0xff18027c,0xf87ffbc5,0xf269f568,0xecf5ef8d,0xe87bea9f,
0xe4a7e686,0xe0dee2cb,0xdd03dee5,0xd9f5db5e,0xd842d8f4,0xd74ed7ae,0xd783d73b,0xd8eed819,
0xdb82da0d,0xdef1dd31,0xe2d6e0cc,0xe6f5e4f2,0xea77e8c7,0xed8fec0e,0xf0a7ef09,0xf3fbf262,
0xf607f539,0xf762f6a1,0xfa10f885,0xfe4bfc00,0x033000bf,0x07e80587,0x0ce40a55,0x119a0f73,
0x1451132c,0x15381509,0x147214f5,0x12a313a9,0x10631183,0x0dda0f2c,0x0ad50c71,0x07670913,
0x05260607,0x053e04e5,0x07ea0635,0x0dc00a6d,0x168711e3,0x20661b64,0x2bdb25e2,0x371731ce,
0x3ebe3b6e,0x42554119,0x40654218,0x3a8c3db8,0x325c36d9,0x27472d0a,0x1b542169,0x0ea61502,
0x0335089c,0xf9f2fe71,0xf14df591,0xe91ded21,0xe1ede55d,0xdb90dea8,0xd578d880,0xcf5ed271,
0xc94bcc4e,0xc3dcc674,0xc00fc1ad,0xbf06bf23,0xc06ebf8c,0xc2ffc18e,0xc5cbc480,0xc6bcc696,
0xc639c676,0xc6a7c63e,0xc8cbc787,0xcb78ca35,0xcd24cc72,0xce7dcdba,0xd10dcf99,0xd528d2d5,
0xdba3d82a,0xe39edf6f,0xedfae867,0xfc41f48c,0x0dfa04d7,0x200d1729,0x301e2868,0x3ccf36ff,
0x45a541a0,0x4b1448c8,0x4dd34cc3,0x4dc14e24,0x4bad4cd5,0x49194a70,0x45464774,0x3fd5429e,
0x3ab63d2b,0x35af3833,0x2fc93309,0x26e82bb2,0x1bf42195,0x10f9164b,0x07c90c26,0x002103d1,
0xf924fc9c,0xf25ef5b6,0xec35ef2e,0xe707e97d,0xe292e4c0,0xde38e06f,0xda05dc00,0xd6dad843,
0xd555d5e2,0xd4f6d50a,0xd58bd521,0xd6f3d624,0xd965d80a,0xdce4db0a,0xe115deef,0xe57be344,
0xe951e789,0xec89eafb,0xefbaee0b,0xf35ef195,0xf642f503,0xf7d8f71f,0xfa17f8be,0xfe2bfbe5,
0x03ca00e7,0x08cb066b,0x0d5c0b18,0x11ff0fb3,0x156d13fd,0x16821632,0x163c1685,0x1479158d,
0x11de133b,0x0e881044,0x0b480cd9,0x080d09b1,0x05b3069e,0x05ab0563,0x081c068f,0x0d600a60,
0x15a51129,0x1ff41aa5,0x2b502585,0x36543104,0x3eb93af5,0x439f419b,0x43ae4468,0x3e60418a,
0x35e33a7c,0x2a4d3071,0x1d5f23e0,0x0fe916c0,0x02fd091a,0xf910fdc9,0xefbef45b,0xe741eb5d,
0xe017e380,0xd9dbdce5,0xd3f2d6e7,0xcdded0ef,0xc800cad1,0xc2ddc556,0xbf21c0b7,0xbde6be2e,
0xbfbbbe79,0xc2b5c12c,0xc603c45b,0xc7fbc74b,0xc7f7c813,0xc87ac818,0xca1fc92c,0xcc16cb25,
0xcd81cce3,0xce71cde9,0xd093cf4f,0xd446d23d,0xd987d6a7,0xe093dcdb,0xea16e4ee,0xf771f034,
0x089affb0,0x1a9011b0,0x2b6d2324,0x39ff3321,0x45373ff5,0x4ce1499c,0x50e64f45,0x51a251b1,
0x500d5103,0x4d744ed6,0x49824bc9,0x43be46b8,0x3e1540df,0x38773b50,0x32193570,0x29c12e31,
0x1f4024bb,0x144919ab,0x0a9b0f43,0x02190640,0xfa61fe25,0xf2f8f6ad,0xec28ef6d,0xe655e920,
0xe12be3b6,0xdc5cdeb6,0xd82cda27,0xd4f4d66d,0xd339d3e1,0xd2e6d2e9,0xd369d312,0xd4b6d3e9,
0xd732d5cb,0xdabcd8dc,0xdec8dcbc,0xe2f0e0df,0xe6a6e4df,0xe9fde85f,0xed60eb99,0xf138ef4f,
0xf460f2f9,0xf62cf55e,0xf8aff729,0xfd51fac2,0x03430043,0x087905fc,0x0d430ae6,0x12240faf,
0x15fe1457,0x179f170c,0x177817c3,0x158e16b3,0x12a8142e,0x0f4a10fb,0x0c650dbe,0x09860afd,
0x077f0849,0x07900740,0x0a2c0887,0x0fa40c88,0x18061376,0x22851d1b,0x2de1282c,0x3870335d,
0x40933cdf,0x45cd4395,0x463346c0,0x411c443d,0x38293d0e,0x2be73265,0x1df324f1,0x0ffb170f,
0x02bf08f9,0xf876fd5d,0xef05f3b4,0xe610ea72,0xde2ce1e5,0xd798dac7,0xd13fd46b,0xcaeece17,
0xc500c7e4,0xbfe5c25c,0xbc74bdda,0xbbc0bbbe,0xbe12bc94,0xc1eebfe4,0xc62bc425,0xc8ccc7cd,
0xc909c919,0xc91bc900,0xca0bc96c,0xcb88cac8,0xcc60cc17,0xcd09cc99,0xcf1bcdde,0xd2aed0bc,
0xd7d2d4fa,0xded1db22,0xe7ebe2fc,0xf4c4edd6,0x0514fcae,0x16140d9c,0x26e51e86,0x36772eeb,
0x443a3d97,0x4e9a49f9,0x54d3523a,0x57075659,0x568e5713,0x542a558e,0x4fab523a,0x497e4cb7,
0x427d4608,0x3b6a3efa,0x33ff37c7,0x2b262fda,0x20af2605,0x160e1b54,0x0c3110fe,0x034e07a1,
0xfae4ff18,0xf2a9f6ba,0xeb45eed7,0xe4a2e7dc,0xdec5e19a,0xd994dc1c,0xd53bd748,0xd1f3d36f,
0xd08ed0ee,0xd0b3d087,0xd1abd116,0xd36cd273,0xd626d4a8,0xd9d4d7e3,0xdde3dbd3,0xe20ddff8,
0xe5d4e40d,0xe8e2e768,0xec4eea76,0xf043ee50,0xf379f1fe,0xf572f49a,0xf7eef666,0xfcacfa10,
0x02b2ffa5,0x07ee0578,0x0c920a41,0x11c40f0b,0x16531450,0x18b517c9,0x18f0190f,0x1722184d,
0x141415aa,0x10b41267,0x0db20f22,0x0aa70c3b,0x0831093a,0x07c507ac,0x09dd087b,0x0ec80bf9,
0x16c01256,0x21381bd7,0x2c4c26b1,0x376331ec,0x40b23c5c,0x471e444f,0x48d148c3,0x4453473d,
0x3b614050,0x2ee1358e,0x207527ac,0x121a196b,0x03cd0aa8,0xf8a2fde5,0xeefef3c6,0xe5e1ea55,
0xddb6e1a1,0xd6d0da27,0xd072d388,0xca8acd81,0xc4adc78f,0xbf60c1f4,0xbb93bd25,0xba9bbac0,
0xbccebb50,0xc0e7beb9,0xc576c330,0xc8dbc76d,0xc996c980,0xc9a6c98f,0xca1bc9d2,0xcb0dca86,
0xcbcfcb81,0xcc76cc12,0xce36cd1e,0xd180cfac,0xd65fd3a9,0xdd35d99d,0xe612e141,0xf28cebce,
0x0294fa37,0x14160b48,0x25241cb3,0x350f2d59,0x432f3c52,0x4f274998,0x574053b1,0x5b4159c4,
0x5b265ba4,0x57dd59e4,0x52ac5574,0x4bb04f5a,0x444f47fb,0x3c9f408a,0x341a386b,0x2ab92f94,
0x207125a9,0x15b51b0d,0x0bcd109a,0x031b0763,0xfab3fedc,0xf29af694,0xeafaeec1,0xe3d9e74e,
0xdd85e095,0xd818daac,0xd3abd5bf,0xd08bd1e5,0xcf46cfae,0xcf52cf34,0xd028cf9f,0xd235d101,
0xd5a9d3ce,0xd9eed7c5,0xde50dc1e,0xe294e077,0xe663e48d,0xe9a9e817,0xed1beb4d,0xf0aeeefd,
0xf2fef211,0xf448f395,0xf72cf570,0xfc11f967,0x01befef7,0x06c60443,0x0c310960,0x124c0f49,
0x171a14e3,0x19d718d4,0x19c11a20,0x173118be,0x13671558,0x0fce1189,0x0c900e30,0x09360adb,
0x070907e1,0x06fb06b7,0x097707e7,0x0e8b0ba5,0x17221261,0x21a31c5c,0x2c4c26dd,0x37e73215,
0x41fb3d48,0x488d45c7,0x49f44a14,0x44d94800,0x3bec40d2,0x2f5f360d,0x215f2854,0x13131a59,
0x05840c14,0xf9f6ff6b,0xf095f51c,0xe77dec12,0xde9be2ee,0xd6eddaa9,0xd066d37a,0xcaddcd91,
0xc572c82f,0xbff0c28a,0xbc3cbde3,0xbb36bb44,0xbd1bbbeb,0xc08abe9b,0xc579c2e6,0xc95ec7bb,
0xcac8ca4f,0xcb02cafa,0xcb08cafe,0xcb87cb3b,0xcbc4cbbb,0xcb6dcb9d,0xcc41cb95,0xcef6cd67,
0xd3ecd112,0xdad8d737,0xe3a8deee,0xef52e90e,0xfe62f67c,0x0f8206d5,0x20831833,0x30542887,
0x3ef637dc,0x4c6045cb,0x57875260,0x5e7b5ba2,0x5fda5fe5,0x5d375edc,0x57935ad3,0x4fb753c7,
0x47694b87,0x3f044350,0x35d83a7d,0x2c003109,0x218326ca,0x17081c3f,0x0d5b120c,0x04a208e9,
0xfc460076,0xf40ff821,0xec18f00f,0xe491e840,0xde39e137,0xd8bbdb65,0xd3cfd626,0xd052d1dd,
0xce86cf30,0xce32ce3f,0xcecbce59,0xd0e0cfa6,0xd467d27d,0xd892d678,0xdc68da83,0xe08bde69,
0xe463e292,0xe784e5fe,0xeac7e91a,0xee2eec86,0xf083ef89,0xf210f13a,0xf548f364,0xfa4bf796,
0xfffdfd34,0x057302ab,0x0b8c0866,0x12310ede,0x179d1528,0x1ac1198a,0x1a9d1b14,0x18131996,
0x1405161d,0x10471209,0x0cde0e97,0x09800b12,0x07b40861,0x08030784,0x0ade092a,0x0ff10d13,
0x182713a4,0x22341d25,0x2ca32741,0x38e632a7,0x43ab3ebc,0x4a6b4795,0x4c034c0e,0x473a4a43,
0x3e8f4351,0x324538d6,0x24402b4e,0x15901cfb,0x07450e44,0xfb1b00d3,0xf12af605,0xe77fec58,
0xde1be2b9,0xd5a5d9bc,0xce9bd1ec,0xc8a9cb8d,0xc2eec5d1,0xbd5dbffc,0xb9d0bb55,0xb945b911,
0xbb8eba2b,0xbf46bd3f,0xc417c197,0xc866c67c,0xca58c9a5,0xcb21cacb,0xcb95cb5c,0xcc16cbdb,
0xcbcccc0f,0xcaefcb62,0xcb41cade,0xcd84cc20,0xd27bcfa3,0xd9a7d5ec,0xe275ddb5,0xee32e7e8,
0xfd2df54b,0x0e8605b9,0x1f621729,0x2e9e2732,0x3ca735bc,0x4a364387,0x564b507e,0x5f125b49,
0x61bd6128,0x5fdd6149,0x5a3e5d73,0x52505676,0x49cb4e0c,0x40d5456e,0x37093bf3,0x2c8f31f9,
0x21b8270a,0x17961c8f,0x0ea512f6,0x06b40a94,0xff1602e8,0xf746fb35,0xef0ff32e,0xe769eb21,
0xe097e3df,0xda90dd87,0xd52ed7c3,0xd0fbd2e9,0xce29cf5c,0xcce5cd5a,0xcceeccc0,0xcec2cd98,
0xd1f8d03b,0xd610d3f6,0xd9e9d809,0xde2ddbf4,0xe264e054,0xe636e45d,0xe9aee7fb,0xed1deb6b,
0xef84ee84,0xf111f036,0xf42cf26b,0xf8baf645,0xfe0dfb69,0x037700a8,0x09960670,0x10660cfc,
0x15c31359,0x18ff17b4,0x194f1984,0x175c1889,0x140b15d2,0x10a9124c,0x0d4d0f05,0x0a280b9d,
0x089e0921,0x094308a2,0x0c3e0a7c,0x11710e7f,0x19c5153a,0x23de1ec0,0x2ef42925,0x3c183574,
0x473d4226,0x4e144b45,0x4ecc4f64,0x49024c7e,0x3f8544ad,0x32b9397f,0x24892ba0,0x15b41d3f,
0x07410e46,0xfb1d00cc,0xf10cf5f9,0xe750ec2f,0xddfae290,0xd59ed9a8,0xce88d1e9,0xc851cb5d,
0xc212c53c,0xbc00bed8,0xb821b9c3,0xb7abb76a,0xba1bb8a5,0xbdf9bbdf,0xc309c05e,0xc7a3c58e,
0xca12c912,0xcb89cade,0xcc50cbf5,0xcd16ccc9,0xcc85cd07,0xcabacba8,0xca1eca28,0xcba2ca96,
0xd03dcd7c,0xd77ed3ae,0xe07edbad,0xec86e615,0xfbc0f3cb,0x0ce9043a,0x1d56155b,0x2bf424d4,
0x393532ad,0x46953fd9,0x53544d30,0x5d1d58b7,0x62246046,0x622462c2,0x5da86072,0x55d359fa,
0x4d2f518f,0x43cc489a,0x39fb3ee4,0x2f8034e6,0x249a2a03,0x1a811f63,0x116f15d4,0x09800d5b,
0x01ea05bd,0xf9d6fdfb,0xf0f3f57c,0xe870ec8e,0xe125e4aa,0xda99ddc4,0xd4cbd79d,0xd008d240,
0xcca1ce26,0xcafbcb9a,0xcafacac0,0xccd4cbae,0xcfffce48,0xd3a9d1cc,0xd7b8d5a2,0xdc48d9f1,
0xe0dade9d,0xe4c3e2e6,0xe82de681,0xeb88e9e2,0xedaaecd0,0xef65ee65,0xf27cf0c7,0xf6eef490,
0xfc36f97c,0x0206ff0f,0x08960524,0x0f9d0c2f,0x157912b7,0x193c17b5,0x1a221a01,0x18e419c2,
0x15f91788,0x12f21475,0x0f821150,0x0c240db4,0x0a360af2,0x0a960a0e,0x0d8a0bc1,0x12ce0fd9,
0x1ae21689,0x24441f89,0x2ee62943,0x3bfa354a,0x478a4238,0x4e804bb5,0x4f284fb7,0x49684ce9,
0x3fd64502,0x335239d1,0x25d92cae,0x17aa1eca,0x09961091,0xfd2b0314,0xf2c4f7d1,0xe87eeda7,
0xdec8e386,0xd5fada3c,0xce9ed215,0xc842cb64,0xc1abc50c,0xbb71be58,0xb772b91d,0xb6bfb6a6,
0xb8a8b76f,0xbca5ba69,0xc1c7bf2d,0xc62cc437,0xc8d5c7a9,0xcac4c9dc,0xcc21cb7b,0xccf2ccb0,
0xcc53ccd3,0xca35cb57,0xc8d9c94f,0xc9b6c8f3,0xcdddcb5e,0xd503d122,0xde7ed969,0xea92e435,
0xf9d0f1c2,0x0b520279,0x1bf413e3,0x2abe2392,0x37fb317e,0x44f93e70,0x51624b55,0x5b7056dd,
0x61795eff,0x630662cd,0x5fd1620e,0x58ea5ca7,0x506c54cc,0x46b24bc4,0x3c124176,0x30fb3691,
0x26482b89,0x1c772142,0x13dc17f5,0x0c62100b,0x054208d3,0xfd73017a,0xf484f914,0xeb98eff3,
0xe38ae770,0xdc5fdfe4,0xd5b6d8f1,0xd023d2ce,0xcba4cdb2,0xc8f7ca09,0xc85dc863,0xc9dcc8d9,
0xcd0ecb57,0xd0b7cedb,0xd4c6d2ab,0xd9aed718,0xdee5dc4f,0xe3bbe161,0xe7f0e5e4,0xeb7ee9e5,
0xed4bec96,0xef13ee07,0xf1d5f059,0xf592f394,0xfa56f7d5,0x002efd18,0x074f03ac,0x0dc30ab3,
0x134a109f,0x17091579,0x182c17e2,0x1770180c,0x158f1685,0x13b714af,0x10d3126c,0x0dcc0f2d,
0x0c230cc6,0x0c7b0bff,0x0f2a0d86,0x149c1179,0x1caa187a,0x255920fb,0x2fb92a1f,0x3d38363b,
0x497a43de,0x50894dd2,0x503a514f,0x49934d8d,0x3f1944b7,0x326c38dd,0x25312bf3,0x17af1e5f,
0x0a0710df,0xfdc3038c,0xf3a3f88a,0xe98eee9f,0xdfd0e4a6,0xd6eddb31,0xcf98d315,0xc95dcc63,
0xc2abc629,0xbc55bf55,0xb7f6b9cb,0xb6a3b6e8,0xb7d9b6f7,0xbbb9b971,0xc0f2be5d,0xc53cc347,
0xc833c6db,0xca66c964,0xcc19cb4a,0xcd38ccca,0xcc9dcd2b,0xca6bcb97,0xc890c953,0xc8e9c851,
0xcc98ca5d,0xd372cf9d,0xdcf6d7e3,0xe90ae2ad,0xf84df031,0x0a2a0121,0x1b2c12f7,0x2a0522d1,
0x372230c5,0x434e3d47,0x4e2648f8,0x571652de,0x5d435aa1,0x5ff85efb,0x5ea35fdc,0x59c55c9a,
0x520c562d,0x487c4d7c,0x3e13434e,0x335038b9,0x28e82e0a,0x1f3523f8,0x16891abc,0x0eec1299,
0x07d10b64,0x00340426,0xf767fbe0,0xee8df2f2,0xe66aea58,0xdee3e2a4,0xd7dbdb3e,0xd1afd4af,
0xcc7ecef0,0xc8f3ca7a,0xc77cc7f7,0xc874c7a2,0xcb75c9cf,0xcf0ecd3d,0xd322d0fc,0xd830d589,
0xdd96daf3,0xe253e00e,0xe658e464,0xe951e813,0xead2ea21,0xecceebab,0xef86ee25,0xf2ccf109,
0xf757f4df,0xfda5fa3f,0x04f40153,0x0ba10864,0x117c0eb9,0x157d13c7,0x1746169a,0x1768177e,
0x16e41723,0x1603169c,0x139714f7,0x1121123c,0x0fc91045,0x101e0fb7,0x12c61118,0x189b154f,
0x20511c63,0x285a243f,0x32ba2d16,0x3fd03930,0x4a8f45ca,0x4f994de7,0x4e054f92,0x46d14afb,
0x3bf641c4,0x2fce35e1,0x23132982,0x16531cc2,0x09310fb5,0xfd970319,0xf39bf884,0xe9e3eeb4,
0xe07be522,0xd824dc1c,0xd105d478,0xca52cdba,0xc2dfc69f,0xbc38bf5c,0xb7e3b9a9,0xb698b6e7,
0xb7efb6d9,0xbc5cb9e6,0xc159bef2,0xc51ec36c,0xc7d0c68f,0xc9fec8ee,0xcc32cb13,0xcdabcd23,
0xccddcd93,0xca85cbc6,0xc876c95f,0xc89ec82b,0xcbf9c9d5,0xd300cf17,0xdcf5d79c,0xe9d5e2ff,
0xfa16f18f,0x0bfc0311,0x1c4f146f,0x2aa923af,0x37513135,0x42873d1d,0x4bc34767,0x52d14f95,
0x57c35596,0x5a5a595f,0x5a775ac4,0x56f3592b,0x501853e8,0x47084bbe,0x3d33422b,0x3325382c,
0x29652e3f,0x203f24b7,0x180b1c01,0x10ce145c,0x09dc0d55,0x0212061b,0xf96afdcf,0xf0cff50b,
0xe8e3eccc,0xe113e4f6,0xd9f0dd5b,0xd3dfd6d4,0xce57d0fe,0xca6acc28,0xc864c920,0xc8c5c84a,
0xcb0ac9bc,0xce63cca3,0xd24bd046,0xd71ad497,0xdc54d9b2,0xe13ddee9,0xe50ee34e,0xe7ace681,
0xe9bbe8b4,0xec31eae3,0xeee5ed91,0xf1acf02e,0xf63cf3a5,0xfccbf956,0x0382003d,0x09b406a4,
0x0ef90c89,0x127510e8,0x148313a8,0x1582151e,0x165315ec,0x161a167a,0x1454154a,0x12c11377,
0x11f91243,0x125211ee,0x1531135c,0x1ad817c4,0x21c21e36,0x29d82591,0x346c2ece,0x40fa3aad,
0x4adc467e,0x4f184dc4,0x4d8a4eff,0x46364a8a,0x3ba7412e,0x2fc535cd,0x2390299a,0x17201d7a,
0x0a0d1082,0xfe5a03fb,0xf40df923,0xea2eef0e,0xe102e579,0xd940dced,0xd29ad5dc,0xcbadcf46,
0xc402c7d7,0xbd2fc05e,0xb8fabad0,0xb6e6b79f,0xb835b716,0xbc5eba26,0xc0c3be94,0xc492c2d0,
0xc74ec601,0xc99dc87c,0xcc2ccadf,0xcddacd42,0xcd2ecdc5,0xcad2cc25,0xc871c97f,0xc838c7fb,
0xcb0dc93c,0xd157cdc9,0xdadcd5b2,0xe7ede0e3,0xf8d2effa,0x0aea01ee,0x1ba61387,0x2a5c233b,
0x36c930ec,0x41323c29,0x497c45bb,0x4f204c8c,0x52da5143,0x5558541e,0x56845640,0x55295634,
0x50985343,0x495d4d45,0x40774508,0x37153bd6,0x2d4f3223,0x23fd2898,0x1b7d1f91,0x13fa179f,
0x0cd21072,0x05280916,0xfc8d00e5,0xf40ff842,0xeb9befd7,0xe33ee768,0xdbcddf55,0xd570d88b,
0xcf7ad268,0xcabfccdd,0xc7dcc913,0xc749c743,0xc8c2c7d2,0xcbaeca19,0xcf70cd7b,0xd408d197,
0xd9b3d6c7,0xdf16dc7c,0xe374e172,0xe653e506,0xe923e7a5,0xec35eaae,0xef27edc7,0xf1ddf067,
0xf61ff3c5,0xfbf4f8e9,0x01fcfeff,0x07ab04e2,0x0ca00a46,0x10360e9c,0x129f1189,0x1454137a,
0x16171547,0x167f1685,0x15e01639,0x15341583,0x14c714f3,0x155e14dd,0x18871690,0x1e4f1b3a,
0x24f7218e,0x2d0b28b9,0x378f31fe,0x42c23d59,0x4ac2475c,0x4d264ca0,0x4a184c56,0x42304692,
0x37fc3d42,0x2ca0326d,0x211d26d1,0x15231b45,0x08cb0eda,0xfde70323,0xf42df8fa,0xeafeef8f,
0xe261e684,0xdb1ade9d,0xd476d7c8,0xccc6d0cc,0xc4b7c8be,0xbdc8c0e7,0xb963bb53,0xb781b812,
0xb946b7f0,0xbd58bb2e,0xc1bcbf90,0xc579c3ba,0xc855c6fe,0xcb01c9a3,0xcde0cc71,0xcf81cefa,
0xceebcf7c,0xcc69cdd3,0xca14cb0f,0xc9cbc9b1,0xcc31ca8c,0xd217cebf,0xdb7cd658,0xe8d7e19a,
0xf99df0f8,0x0adc0262,0x1a7f12ea,0x2832219d,0x33632e1a,0x3c9d383d,0x436d4065,0x47ee45e3,
0x4aa3496c,0x4cd74bd3,0x4e2f4da7,0x4de94e51,0x4bc24d0c,0x474c49d6,0x40b84441,0x388d3ccc,
0x2fd43438,0x27642b7e,0x1fe92383,0x192c1c7c,0x125b15d4,0x0aa30eae,0x021e066f,0xf956fdb9,
0xf081f4f9,0xe7d1ec0e,0xe016e3cf,0xd932dc8e,0xd29cd5d8,0xcd35cfbc,0xc985cb1b,0xc81fc88e,
0xc8c5c83e,0xcae0c9ad,0xce5acc72,0xd30ad087,0xd8acd5d4,0xdd86db51,0xe0b4df4c,0xe369e1f8,
0xe711e524,0xeadde902,0xedb6ec6d,0xf0c6ef1b,0xf555f2da,0xfa80f7f3,0xff76fcfb,0x043d01ea,
0x0840065d,0x0b8409f0,0x0e540cf4,0x11690fce,0x140512e6,0x157a14cf,0x16731606,0x174016db,
0x17ee1799,0x19861875,0x1d421b2b,0x22111f96,0x284224e8,0x30542c13,0x3a7b3529,0x44a93fd8,
0x4ada4867,0x4c804c34,0x48b34b5c,0x40a444fb,0x36b03be5,0x2ba43133,0x2058261a,0x13f81a3a,
0x07ef0dd0,0xfd400266,0xf3c9f86f,0xeafaef50,0xe336e6e5,0xdcc6dfea,0xd5fed992,0xce02d21d,
0xc590c9c0,0xbedfc1e2,0xba0abc41,0xb86ab8b6,0xba75b921,0xbe03bc20,0xc203c006,0xc55ec3ca,
0xc803c6c3,0xcad2c963,0xcdb7cc53,0xcf9aced6,0xcf4bcfd0,0xccd7ce2b,0xcaffcbb9,0xcacacaad,
0xcceecb81,0xd1ffcf17,0xdac3d5d7,0xe84de0eb,0xf955f094,0x0a85020e,0x1a1a1293,0x275c2117,
0x31f92ce4,0x3aa836a7,0x408f3de8,0x443f42c0,0x460a452c,0x479e46e9,0x489d4832,0x48b748c2,
0x47ab4864,0x44ed4678,0x408242f2,0x3a613da5,0x32d936b5,0x2b4f2f12,0x243027a1,0x1d8220e2,
0x16711a09,0x0e711294,0x05d00a35,0xfcd2015f,0xf384f82d,0xea97eef6,0xe282e666,0xdb27decf,
0xd451d79f,0xce75d13b,0xca1acc0b,0xc7d3c8b2,0xc7acc777,0xc953c855,0xcc86cab3,0xd144ceb7,
0xd69bd3f7,0xdb21d90d,0xde21dccc,0xe162df8e,0xe5b8e381,0xea1ae7fb,0xed8aebe4,0xf127ef47,
0xf56ff32e,0xf9def7b3,0xfe12fbfc,0x01f30013,0x056803b2,0x08db072b,0x0c050a6f,0x0fc30dd6,
0x12f2117d,0x1545142a,0x173e164f,0x18f6182b,0x1a42199e,0x1c881b2c,0x20691e53,0x252922ae,
0x2b682801,0x339a2f53,0x3d4f3852,0x4656422f,0x4af1494a,0x4acf4b6d,0x45d448f5,0x3d5e41c6,
0x338038b1,0x28a12e0e,0x1d682325,0x1196177a,0x06490bc9,0xfcba0151,0xf40bf85c,0xebc0efc3,
0xe4aee80c,0xdea6e1a5,0xd7a1db5e,0xcf71d3a2,0xc700cb1d,0xc068c370,0xbb94bdaf,0xba26ba64,
0xbbf0babf,0xbf00bd61,0xc2a9c0d1,0xc609c462,0xc92cc79f,0xcc64cabd,0xcf68cdfe,0xd153d096,
0xd0b9d166,0xce4bcf89,0xcc91cd4f,0xcc12cc1c,0xcdf8ccac,0xd292cfe8,0xdb18d63a,0xe85de123,
0xf90df07d,0x0a3501c2,0x198b121f,0x26532050,0x30872ba9,0x385234d9,0x3d0c3aff,0x3f693e76,
0x40794014,0x40c640a7,0x40ba40cb,0x40c540a7,0x40d740f1,0x3ff7407c,0x3e423f4a,0x3acf3cc6,
0x3593386c,0x2f45326d,0x28be2c11,0x21eb255c,0x1a861e55,0x126a168f,0x09ea0e35,0x00ec0583,
0xf7bffc4a,0xef29f363,0xe70deb0b,0xdfa0e342,0xd8abdc16,0xd233d55b,0xccffcf68,0xc97fcb0b,
0xc78fc84a,0xc807c777,0xcafec92e,0xd004cd5f,0xd4f9d2ac,0xd84ed6d0,0xdb12d9a7,0xde9edcae,
0xe343e0e6,0xe782e57b,0xebdce9a4,0xf0a4ee2e,0xf502f2fa,0xf8a9f6da,0xfc0efa6b,0xfeeefd8c,
0x01d6004d,0x05870396,0x09f307ad,0x0e530c3a,0x12231046,0x159213ee,0x187a1713,0x1ac519b6,
0x1cf21bc6,0x1fea1e5f,0x22db2163,0x273724b3,0x2e182a71,0x35c631e4,0x3e0139c7,0x450d41f4,
0x48c3474b,0x487f4938,0x43f346bd,0x3c114051,0x32be3776,0x28ab2de5,0x1d802324,0x120f17d5,
0x06a60c46,0xfcfc0186,0xf48df8b9,0xeccff088,0xe642e95e,0xe030e34f,0xd941dcd0,0xd175d572,
0xc9e5cd97,0xc2f4c651,0xbdf8c018,0xbc23bcab,0xbcb1bc20,0xbf05bdb6,0xc220c080,0xc5c8c3ed,
0xc940c78d,0xcc54cadf,0xcef7cda9,0xd0d0d018,0xd0add100,0xcf35d000,0xcdc9ce6c,0xcd84cd79,
0xcf0bce07,0xd315d0a8,0xdb16d690,0xe73ae0a3,0xf6caeeaf,0x07ddff56,0x176f0ffb,0x24391e26,
0x2e2d2996,0x3536320f,0x395e379a,0x3b5e3a97,0x3bb13bb5,0x3b713ba5,0x3b183b31,0x3b8e3b3b,
0x3c263be5,0x3c7a3c5a,0x3c7a3c8f,0x3b0b3c02,0x37bc399f,0x32f33586,0x2d243023,0x266129db,
0x1f1422ce,0x175f1b3e,0x0ee71345,0x059f0a5a,0xfc5f00ea,0xf382f7e6,0xeae5ef34,0xe2ace6b8,
0xdafddec6,0xd3d0d754,0xcda5d08d,0xc90dcb1f,0xc671c771,0xc669c615,0xc942c777,0xce32cb98,
0xd2fed0b9,0xd67ad4e8,0xd9b5d7fe,0xdddbdbad,0xe254e021,0xe6c8e47d,0xeb99e92c,0xf081ee1f,
0xf45bf28f,0xf7a9f609,0xfa5ef919,0xfc81fb73,0xff6cfdd2,0x03640147,0x081605b9,0x0c860a58,
0x10e50ebb,0x150b12fd,0x18f21712,0x1c211aa2,0x1f6c1db1,0x22ed2142,0x264a247e,0x2ba428a1,
0x32d02f1f,0x3a2e3678,0x41f53e11,0x47b24548,0x4998492c,0x470a48d4,0x40d64451,0x38683cdd,
0x2ecb33af,0x245029b2,0x194b1ed8,0x0df613a9,0x038e0874,0xfb3aff38,0xf3e6f778,0xed72f09d,
0xe7c8ea81,0xe1fee501,0xdb35decd,0xd346d744,0xcb4ccf44,0xc411c77c,0xbf5bc14b,0xbdbcbe40,
0xbe80bdda,0xc0b7bf87,0xc36dc203,0xc6a7c4f6,0xca05c859,0xcd1dcb9b,0xd04cceb6,0xd22dd184,
0xd1d6d245,0xd064d131,0xced2cf84,0xce81ce73,0xd00dcf0c,0xd45dd1b9,0xdc9bd7ff,0xe8d7e23c,
0xf81bf033,0x08540049,0x16b40fdc,0x22801ce4,0x2bb7276c,0x31f32f40,0x351c33d6,0x366235fc,
0x36183650,0x353735ae,0x34ef34e8,0x35c83542,0x36db364a,0x385c378f,0x39943915,0x39c139d8,
0x384d3935,0x35813716,0x31263386,0x2b372e5c,0x23ed27b6,0x1bc61fef,0x12d21763,0x09300e04,
0xffe20476,0xf6bbfb50,0xeda5f21d,0xe52fe957,0xdd54e134,0xd5f7d996,0xcf70d28f,0xca05cc96,
0xc667c7e7,0xc5c2c5ae,0xc877c6bf,0xcd0acaa9,0xd11bcf3f,0xd463d2bc,0xd84fd640,0xdd05da96,
0xe176df56,0xe63ce3ba,0xebb8e8e3,0xf116ee9b,0xf4def326,0xf776f655,0xf90ff852,0xfa8cf9bb,
0xfd46fbb3,0x01b5ff50,0x06a50441,0x0b3608e3,0x10120da4,0x14b91271,0x18ed16ea,0x1ca41ac5,
0x21001ec5,0x24f3231c,0x290e26c4,0x2fd42c29,0x373e33a1,0x3e173aa1,0x449a418d,0x487c46f0,
0x4896491d,0x440c46d3,0x3cc340a8,0x34053877,0x2a982f76,0x2053257f,0x15e41b1b,0x0b51109c,
0x01f60663,0xfa61fdfe,0xf414f721,0xee5ef126,0xe922ebc3,0xe365e64d,0xdcace03b,0xd52cd8ea,
0xcd48d14d,0xc604c963,0xc163c353,0xbf7ec017,0xc03fbf96,0xc29dc152,0xc589c40b,0xc8dcc72b,
0xcc1cca8b,0xcf00cd8b,0xd1f3d097,0xd348d2db,0xd314d353,0xd1bfd281,0xd06cd0fd,0xd013d013,
0xd19cd08a,0xd63dd378,0xde4cd9db,0xe9d7e3a5,0xf82df0c1,0x06f8ffbb,0x13dc0dad,0x1ebd199b,
0x27242334,0x2d132a7c,0x30412ef1,0x31253104,0x309f30f4,0x2f843016,0x2f3e2f3a,0x30162f8d,
0x31cf30db,0x344e32f7,0x36d535aa,0x382f37ab,0x38ba3893,0x38033895,0x356d3706,0x30743327,
0x29c02d51,0x21bf25e5,0x18781d3e,0x0eb9139d,0x053409f2,0xfbad007b,0xf204f6c3,0xe8d6ed5b,
0xe00fe463,0xd7eddbe3,0xd0b9d431,0xcac1cd94,0xc6b0c864,0xc597c5ba,0xc7c5c655,0xcbdac9b7,
0xcf97cde0,0xd2bed119,0xd6e8d4b6,0xdbc0d950,0xe021ddfe,0xe4fee27c,0xea9de7b0,0xefe0ed79,
0xf361f1cc,0xf5c1f4b9,0xf726f68c,0xf8c8f7d3,0xfbddfa18,0x007afe09,0x055802f5,0x0a5907c6,
0x0f9f0cfa,0x14b71235,0x19421715,0x1d631b4f,0x220d1fb0,0x262f2437,0x2b02284e,0x32662e72,
0x3a263668,0x40c73d8b,0x464e43d4,0x48ea4804,0x47a448eb,0x42074530,0x39fa3e4a,0x30e73574,
0x272b2c27,0x1cdf2204,0x128717b2,0x084d0d56,0xff6e039e,0xf88dfbba,0xf332f5c1,0xee88f0d6,
0xe9d0ec3d,0xe4b9e741,0xded0e1f5,0xd843db94,0xd0e5d4ad,0xca13cd4e,0xc542c75a,0xc2c7c3b9,
0xc2bfc288,0xc495c379,0xc779c5f5,0xca9ac910,0xcd83cc1a,0xd03eced9,0xd2fcd1b7,0xd489d3ef,
0xd48dd4c7,0xd326d3ed,0xd1e6d263,0xd1c9d1b3,0xd367d248,0xd7fed54b,0xdf92db71,0xea57e48f,
0xf7fef0de,0x060bff35,0x12550c64,0x1c7c17c5,0x2400207b,0x290d26e9,0x2bc22aa9,0x2c1b2c39,
0x2b242bac,0x2a0a2a86,0x29b229cc,0x2a7229e3,0x2c9d2b55,0x2ff22e34,0x336f31c0,0x361534e1,
0x37eb3712,0x38ac3883,0x37853861,0x33b735e3,0x2dba30ff,0x25e62a0f,0x1c87214d,0x12db17b3,
0x09510e11,0xff7d0471,0xf574fa73,0xebc1f087,0xe2a7e722,0xda22de51,0xd297d62b,0xcc60cf55,
0xc802c9e1,0xc687c6dc,0xc841c70e,0xcbe5c9fc,0xcf42cda8,0xd2eed0f8,0xd740d501,0xdbe9d9a8,
0xdff8dded,0xe46ae227,0xe9cee6fb,0xee7dec5a,0xf1d9f04b,0xf411f31b,0xf557f4c0,0xf707f609,
0xfa43f866,0xfee7fc88,0x03790136,0x08a105ed,0x0e550b7b,0x13dc112a,0x18c61666,0x1d691b0d,
0x226e1ff2,0x270d24c5,0x2d0229af,0x352630f6,0x3cf13934,0x435c4058,0x47ba45d3,0x49a54912,
0x47274919,0x40ac443a,0x378e3c66,0x2ddc32ac,0x23f228ef,0x19dc1ee3,0x0ffd14ed,0x068f0b30,
0xfe470233,0xf815fae5,0xf358f597,0xef31f140,0xea9eecf7,0xe63ae865,0xe14de3e0,0xdba5dea4,
0xd499d835,0xce13d132,0xc8e4cb41,0xc59ac6ee,0xc51ec4fe,0xc711c5dc,0xca22c88b,0xcd4dcbc6,
0xcfd1ceaa,0xd220d0ec,0xd468d357,0xd5d8d53b,0xd5bdd60e,0xd414d4fa,0xd294d33e,0xd243d237,
0xd3e4d2be,0xd830d5b6,0xdf47db5f,0xe9ade401,0xf738f03a,0x04a2fe2a,0x104a0aaf,0x194f153a,
0x1fad1cb8,0x240c2214,0x262e257c,0x25fc2649,0x24af2566,0x23bd2415,0x23d823a3,0x2567246c,
0x288826c7,0x2cdd2a97,0x317a2f36,0x351f3371,0x37da3696,0x396d38d9,0x390b397e,0x36643808,
0x3155341c,0x29da2ded,0x20de2574,0x17821c34,0x0df612cc,0x03fe0907,0xf9cdfee4,0xefc1f4bf,
0xe654eaef,0xdd38e1b9,0xd547d912,0xce7dd1be,0xc9accbbd,0xc7d3c862,0xc8bfc7f3,0xcb67ca08,
0xce28ccb8,0xd215cff7,0xd6d3d461,0xdb46d931,0xdf33dd40,0xe38de142,0xe888e60d,0xeca0eab1,
0xeff3ee69,0xf21ef12b,0xf39cf2e1,0xf56bf472,0xf8e7f6d9,0xfdc6fb56,0x0251000e,0x078d04d4,
0x0d7a0a73,0x13731083,0x18d51635,0x1e5b1b85,0x23d0212e,0x29042655,0x30662c58,0x394934db,
0x40c53d43,0x46bd43f9,0x4a2148d6,0x49e94a8b,0x44dd47eb,0x3c81410d,0x3257376d,0x28982d76,
0x1ec523af,0x152f19ea,0x0bd9107d,0x03380756,0xfc2dff7d,0xf6c0f944,0xf2d1f4a4,0xef7ef122,
0xebdfedbb,0xe7ffea0f,0xe2f0e58f,0xdcb7e003,0xd5dad939,0xd033d2d6,0xcbe9cdf5,0xc932ca44,
0xc8fdc8c6,0xcae3c9c9,0xcd7acc23,0xcfd9cebc,0xd1ccd0d8,0xd419d2dc,0xd65ed54b,0xd7fbd750,
0xd7cad829,0xd65fd720,0xd50cd5a3,0xd4c3d4ba,0xd69bd55e,0xdb39d891,0xe2ccde9a,0xedb3e7e6,
0xfa14f3f0,0x04d6ffb1,0x0e0b09b4,0x14d811ab,0x1a0117b4,0x1d721be7,0x1ec91e67,0x1e731ec3,
0x1d851df7,0x1d101d3c,0x1d581d09,0x1f0e1e06,0x22a92096,0x27cf2522,0x2d232a83,0x31bd2f88,
0x35bb33cb,0x38e2377a,0x3a5b39e0,0x399b3a54,0x357e37fb,0x2e22322c,0x252529aa,0x1c0320a2,
0x12671743,0x08290d5e,0xfdaa02e9,0xf369f87d,0xe97cee73,0xe005e49c,0xd7e9dbcb,0xd115d450,
0xcc5dce63,0xca87cb15,0xcb47caa2,0xcceacc20,0xcef0cdc3,0xd2cbd0a2,0xd791d52a,0xdb87d9b1,
0xdeecdd3a,0xe2a4e0ab,0xe6d8e4db,0xea21e891,0xecdeeb94,0xeef8edf8,0xf103efea,0xf39df23a,
0xf790f55f,0xfc65f9ff,0x0128fec1,0x068503c2,0x0c79096d,0x12580f79,0x17c8150f,0x1de21ac2,
0x2413210b,0x2a57270a,0x32d92e51,0x3c1a378f,0x43e44031,0x49a34727,0x4bc04b27,0x4a0f4b72,
0x43864748,0x3a153f19,0x2f5e34b4,0x24fa2a24,0x1ab91fd6,0x10d315bb,0x07b00c1c,0xfff603a1,
0xf99dfc9a,0xf4b0f700,0xf145f2ce,0xeeafeff7,0xebcbed39,0xe88eea5b,0xe404e66c,0xde2fe14e,
0xd7f1daf3,0xd302d54b,0xcf3fd100,0xcce8cdd7,0xccdacc93,0xcea7cda3,0xd0cbcfc0,0xd29ad1b7,
0xd440d361,0xd689d553,0xd8a0d7a9,0xda15d97f,0xd9c1da22,0xd86ed923,0xd753d7c8,0xd747d71c,
0xd952d7fa,0xddf3db4a,0xe574e14f,0xefb5ea59,0xfa32f51e,0x0344fee4,0x0ad2074e,0x10570dbe,
0x14821295,0x171d161c,0x17961794,0x16de173f,0x16431682,0x16591639,0x174b16ac,0x19a21839,
0x1dff1b8c,0x23cf20d4,0x299e26c5,0x2ecf2c4f,0x33ae3147,0x37a535d2,0x3a4a3927,0x3b0d3afc,
0x388d3a49,0x325935da,0x2a3e2e67,0x215425e7,0x17951c91,0x0d141262,0x026807bd,0xf7fefd24,
0xede2f2f0,0xe418e8e1,0xdb85dfaa,0xd449d7ab,0xcf78d185,0xcd4ace10,0xcd8bcd2f,0xce20cde3,
0xcf5fce7a,0xd314d0f5,0xd78ed55b,0xdb45d98e,0xde50dcc9,0xe1cedff6,0xe58ee3c9,0xe85be70e,
0xeaafe995,0xecc5ebb0,0xef58ee04,0xf23df0bd,0xf62ef40a,0xfaeff88f,0xff9ffd38,0x04fc0238,
0x0ae907e7,0x10b90de2,0x16491377,0x1cd9196f,0x23972041,0x2ab326f0,0x33e62f1e,0x3d6f38c1,
0x45bc41c3,0x4b764915,0x4cd64ca7,0x4a0e4c13,0x429146b9,0x384c3dbd,0x2d0832a4,0x223a2793,
0x17bd1ced,0x0ddb12b3,0x052e094f,0xfe290174,0xf89dfb3f,0xf44ff64d,0xf166f2bb,0xef30f044,
0xece6edfe,0xea26ebba,0xe61ae83e,0xe09be395,0xda7add71,0xd5aad7d6,0xd208d3c7,0xcfc7d0a4,
0xcfd5cf88,0xd15ed07a,0xd334d24a,0xd4f0d41d,0xd650d59c,0xd84ad743,0xda1bd946,0xdb6cdae4,
0xdb20db79,0xd9a8da74,0xd85ed8ee,0xd816d803,0xda07d8be,0xde9fdbfc,0xe65de210,0xf098eb4e,
0xfa60f5b9,0x0298fea9,0x09160621,0x0db00b7e,0x115f0fac,0x1323129b,0x12df132f,0x11de1253,
0x11781192,0x11f01196,0x133c1279,0x15d91453,0x1a8e17ee,0x20a21d8a,0x26b923be,0x2c192982,
0x310e2e9e,0x355e3354,0x38783718,0x3a1f3988,0x391d3a0d,0x3482372f,0x2d8c313a,0x2547298f,
0x1c0320c6,0x11b516fd,0x06c00c49,0xfbb6012d,0xf100f658,0xe6b3ebbb,0xddc3e20f,0xd643d9c5,
0xd14dd370,0xcf19cfda,0xcf3bcf00,0xcf92cf71,0xd081cfc6,0xd3dfd1f3,0xd7fbd5ed,0xdb64d9d6,
0xddf7dcba,0xe0b5df3d,0xe3e2e254,0xe664e539,0xe893e77b,0xeb0ce9b9,0xee3bec91,0xf1daf005,
0xf62df3e5,0xfb09f89e,0xffc4fd5b,0x04ff024f,0x0aa707c9,0x101c0d73,0x157d12b8,0x1c2318a1,
0x23691fc6,0x2b082713,0x346a2f90,0x3de43942,0x46094232,0x4b374924,0x4bb84c0a,0x47ea4a64,
0x3fd74455,0x35643ac5,0x2a182fbe,0x1f4e24a1,0x14d51a0a,0x0b140fcb,0x02ee06cd,0xfc88ff87,
0xf763f9d0,0xf380f544,0xf100f21f,0xef40f01b,0xed8eee5d,0xeb53ec9e,0xe7a2e9a7,0xe281e544,
0xdcf8dfab,0xd8b3daa0,0xd566d6ee,0xd38bd42d,0xd3f1d385,0xd572d4ab,0xd6e5d62f,0xd849d79c,
0xd988d8e3,0xdb1bda48,0xdcbcdbf3,0xdddadd6e,0xdd63ddd9,0xdbdedcac,0xda8ddb1e,0xda41da34,
0xdc14dad5,0xe0b6de0c,0xe853e42a,0xf17fece0,0xfa05f5f1,0x00bffd9d,0x057e0366,0x09090742,
0x0bfe0ab9,0x0cf60cbb,0x0c270cb9,0x0b560ba9,0x0b380b2e,0x0be80b71,0x0dab0ca5,0x10ad0efc,
0x158112d8,0x1be11891,0x22781f3c,0x28ab259b,0x2e402b8e,0x332630c6,0x3738354c,0x39c338c0,
0x39f93a34,0x371e38f4,0x318d34a1,0x29cf2dea,0x208d255c,0x16261b70,0x0b2810b9,0x002e0594,
0xf57cfad8,0xeb11f02f,0xe1c0e644,0xda4bddae,0xd5add79e,0xd3cdd46a,0xd389d39e,0xd2b0d32f,
0xd30dd283,0xd5bed43a,0xd93bd77f,0xdba6da9d,0xdd5ddc88,0xdf95de51,0xe21be0f3,0xe410e319,
0xe61ae510,0xe889e73b,0xebcfea15,0xef98ed9d,0xf455f1d4,0xf913f6ce,0xfd7bfb3a,0x028dfff4,
0x07f00541,0x0d450a9d,0x131b1005,0x1a7716a7,0x22061e42,0x2a4425ef,0x345c2f2c,0x3e113965,
0x45e24248,0x4a61489d,0x4af84b1e,0x476749d7,0x3f6443ce,0x34b23a52,0x29602eee,0x1e9c23f9,
0x13ed1934,0x0a440ef1,0x020605fa,0xfbb6fe91,0xf70ff93b,0xf39ef52d,0xf198f276,0xf048f0eb,
0xef3defb0,0xed54ee86,0xe9e9ebd6,0xe481e76d,0xdf03e199,0xdae4dcc7,0xd764d90c,0xd5c4d648,
0xd641d5c3,0xd7dcd708,0xd938d892,0xda28d9c6,0xdaeada78,0xdc48db8e,0xdde8dd10,0xdf1adea6,
0xdeb2df0f,0xdd49de13,0xdbc7dc7d,0xdb52db53,0xdd13dbe0,0xe180deef,0xe8e4e4da,0xf1eced4b,
0xfa3ff665,0x002dfd72,0x03f40261,0x06c20543,0x08cf0804,0x091b0945,0x0792086e,0x067c06e0,
0x067a064f,0x077606e9,0x096f0842,0x0cc50af0,0x11d40f09,0x1882150b,0x1f681c04,0x25c222ab,
0x2b7028ae,0x30c62e24,0x358b333c,0x38e73781,0x39bc39b0,0x37f63921,0x33ad361f,0x2ce630a3,
0x242028b6,0x1a0c1f34,0x0f4714b9,0x045e09ce,0xf949fedd,0xee69f3bb,0xe4dae976,0xdd2ee0b1,
0xd852da62,0xd638d6ed,0xd5d0d5fd,0xd4f8d56e,0xd54ad4d1,0xd764d634,0xda15d8c8,0xdbe9db1f,
0xdd27dc92,0xdefcdde8,0xe147e02c,0xe332e243,0xe518e421,0xe787e62d,0xeab1e911,0xee99ec82,
0xf3b0f10d,0xf881f636,0xfcecfaab,0x01bdff43,0x06ed0453,0x0c1b0983,0x120e0ee7,0x1972159a,
0x21891d6b,0x2a7f25d0,0x34ef2fa5,0x3e8b39f8,0x464c42ae,0x4a854907,0x49b84ab2,0x44a647b6,
0x3bcb4092,0x31263690,0x263f2baf,0x1b9620ea,0x11211653,0x07990c2b,0xffef0385,0xfa7bfcee,
0xf66bf84d,0xf36ff4ca,0xf1c0f26c,0xf0dcf150,0xefbef053,0xedb0eee0,0xea44ec2d,0xe56be7ec,
0xe0f5e30a,0xdddcdf45,0xdb57dc83,0xda47da8d,0xdb07da80,0xdc0cdb95,0xdcb3dc69,0xdd32dcf0,
0xde19dd8e,0xdf82dec8,0xe0aee022,0xe148e11c,0xe0dae130,0xdfaee058,0xde3edeec,0xddddddd7,
0xdfbfde7c,0xe43ae1a2,0xeb15e77c,0xf2a5eeda,0xf8a5f5f7,0xfcdefae5,0xffb4fe70,0x023e0105,
0x03a40316,0x036203c9,0x01b9029b,0x00d7011b,0x015100eb,0x02a101e9,0x04b00384,0x081c0635,
0x0d430a79,0x13ae1057,0x1aa01728,0x21731e0e,0x282224c9,0x2e7e2b64,0x34083169,0x37d03629,
0x397d38f7,0x38be3968,0x35d13792,0x303b335e,0x28442c81,0x1ebd239e,0x1457199c,0x09970eff,
0xfe5d040e,0xf34bf8af,0xe95cee36,0xe174e504,0xdc7edea3,0xda22dafb,0xd95ad9ba,0xd81ad8c3,
0xd80bd7ca,0xd9a4d8b9,0xdba5daaa,0xdc7fdc42,0xdcc6dca0,0xde16dd34,0xe003df2c,0xe137e09b,
0xe2cbe1ef,0xe53de3e0,0xe87fe6ce,0xec7aea56,0xf1b7eef9,0xf6abf45b,0xfaf8f8d1,0xff89fd36,
0x045e01eb,0x097206dc,0x0f7a0c36,0x177b134c,0x1fdb1bb2,0x28f92428,0x338e2e40,0x3d263895,
0x44b4413a,0x48d4475b,0x4875491c,0x442d46e3,0x3c1a407d,0x3230374d,0x277a2cd6,0x1cfb2242,
0x12421796,0x08660d25,0x003b0419,0xfa4afcf4,0xf61af807,0xf31af471,0xf189f223,0xf0a2f127,
0xefd3f01f,0xee76ef58,0xebaced47,0xe714e98a,0xe29ce4b2,0xdf7fe0ee,0xdd08de25,0xdc58dc62,
0xdd86dcce,0xdefcde44,0xdfc7df82,0xdfd1dfdf,0xdffbdfc3,0xe11fe083,0xe226e19e,0xe2dfe2a5,
0xe259e2b5,0xe148e1e1,0xdfffe0a1,0xdf6bdf87,0xe0d6dfd1,0xe473e266,0xea64e727,0xf16dede4,
0xf702f47f,0xfaacf90e,0xfd55fc15,0xff67fe6b,0x00c00040,0x002900b4,0xfe45ff40,0xfd6bfda3,
0xfdd9fd74,0xff41fe86,0x01590023,0x04d402e6,0x0a3c0742,0x11050d88,0x18031487,0x1ebf1b66,
0x25422209,0x2b9f2879,0x31612e9d,0x35b833bd,0x37fa3727,0x37fd383f,0x35f6373a,0x3194341d,
0x2ac82e7b,0x22082697,0x182c1d35,0x0db41301,0x029c0842,0xf78dfcf3,0xed97f268,0xe5c6e95a,
0xe09ae2de,0xddefdef7,0xdcb7dd49,0xdb79dc17,0xdb57db2f,0xdc70dbd6,0xddb0dd1e,0xdde7ddfd,
0xdd55dd94,0xddf9dd70,0xdf2edea1,0xdff6df96,0xe110e066,0xe331e1ff,0xe622e490,0xea55e80c,
0xefbcecf1,0xf4f6f274,0xf9a9f74d,0xfe50fc00,0x034700c3,0x088a05dd,0x0ea50b67,0x165f1259,
0x1eb41a84,0x27d82307,0x32422d0f,0x3b8c372e,0x42ca3f6e,0x46eb4566,0x4684473c,0x422b44d8,
0x3a513e92,0x30dc35b1,0x26b82bdf,0x1c3e2181,0x11a116f0,0x07780c66,0xff0602f8,0xf914fbc1,
0xf52cf6ed,0xf276f3b0,0xf0c5f177,0xeff8f053,0xef99efbb,0xee99ef43,0xebf8ed82,0xe824ea19,
0xe496e645,0xe1e6e324,0xe006e0cf,0xdfeedfba,0xe19de0a6,0xe379e298,0xe446e40e,0xe3f5e434,
0xe3dce3c6,0xe49de42b,0xe594e51e,0xe5e9e5e5,0xe4fee597,0xe373e43e,0xe205e2a6,0xe179e198,
0xe246e1b1,0xe4cae33d,0xea12e72a,0xf058ed3f,0xf52ef30c,0xf821f6c7,0xf9d1f925,0xfb35fa7e,
0xfbd6fbaa,0xfafbfba4,0xf946fa11,0xf8ebf8e7,0xf9d9f93c,0xfb75fa96,0xfde6fc96,0x014fff6a,
0x06ce03c0,0x0e0d0a53,0x152f11b1,0x1c2918a7,0x23101fa8,0x2981265b,0x2f7f2c9a,0x33f531f7,
0x363f3561,0x369b36a9,0x350e3612,0x31683378,0x2c122ef7,0x251828c9,0x1c932106,0x12ee17e8,
0x081d0da2,0xfd1f0294,0xf2d2f7ca,0xeaaaee6c,0xe4f8e786,0xe1b5e306,0xe008e0d0,0xde8bdf40,
0xde26de28,0xdebcde58,0xdf5edf2e,0xdeabdf26,0xddbcde1e,0xde36ddce,0xdf03dea7,0xdf83df49,
0xe039dfc4,0xe1afe0d8,0xe427e2bf,0xe847e5fd,0xed96eadc,0xf2b2f03e,0xf76cf511,0xfc29f9c6,
0x0119fe97,0x068c03b6,0x0d020999,0x14c810cd,0x1cf918dd,0x262e215b,0x30282b37,0x38ea34c1,
0x3f433c7c,0x42ad4155,0x43014339,0x3fb641e7,0x39323cb5,0x30c1352b,0x27662c1a,0x1d9d2295,
0x138a188b,0x09eb0ea1,0x01580578,0xfacafdb9,0xf6aaf87b,0xf3c9f518,0xf22df2d9,0xf171f1b1,
0xf197f173,0xf149f199,0xef57f094,0xebb1ed9d,0xe80be9dd,0xe4b2e64d,0xe21de33c,0xe19be192,
0xe2fee220,0xe4e9e3f9,0xe5ebe592,0xe583e5e2,0xe4cee513,0xe4f4e4c4,0xe5d7e54f,0xe671e651,
0xe5b6e632,0xe47ce520,0xe34fe3d8,0xe2a7e2f1,0xe23be25c,0xe370e282,0xe797e530,0xeda6ea7f,
0xf2caf07e,0xf616f4ae,0xf731f6dd,0xf7eff782,0xf85af83e,0xf7cef833,0xf6c8f746,0xf6cdf69f,
0xf7d0f72b,0xf99df8a8,0xfbf9fab2,0xff6bfd89,0x04ea01da,0x0c100866,0x133e0fad,0x1a2b16bd,
0x20bd1d82,0x271b23ef,0x2d4e2a45,0x32182fef,0x348933a2,0x34eb34f3,0x336b3462,0x305b3219,
0x2c112e58,0x26b1298b,0x1fb12365,0x17151b9b,0x0cd31224,0x01f9075e,0xf7c5fcba,0xef4bf347,
0xe90febe8,0xe571e6e6,0xe318e440,0xe0f7e1ea,0xe048e079,0xe04ce03b,0xdffae04f,0xde37df32,
0xdcccdd50,0xdcefdcb8,0xdd73dd35,0xde3dddce,0xdf1bdeaa,0xe06bdfa5,0xe2b0e169,0xe6e8e483,
0xec6fe9a9,0xf167eefc,0xf647f3cc,0xfb53f8ca,0x00a2fdeb,0x068f0380,0x0d9709ef,0x155b1174,
0x1d4c1945,0x265d21a1,0x30042b41,0x38293469,0x3d4b3b20,0x3fce3ed7,0x3fc84026,0x3c153e6c,
0x35fc392f,0x2e133240,0x259929dd,0x1cac2135,0x136317fe,0x0a7c0eea,0x021f062d,0xfb8afe7b,
0xf75df940,0xf44ff5b0,0xf299f351,0xf206f226,0xf26ef226,0xf286f297,0xf0e6f208,0xed7bef3f,
0xea61ebdf,0xe762e8dd,0xe512e5fe,0xe4d4e4c3,0xe60ae545,0xe7ade6ec,0xe828e81f,0xe76ae7db,
0xe6a8e6f3,0xe6e3e6b4,0xe7e6e746,0xe87ee862,0xe7e1e84a,0xe696e745,0xe536e5df,0xe420e4a7,
0xe31ce385,0xe3d6e32e,0xe746e53a,0xec52e9bf,0xf078ee96,0xf2aaf1e4,0xf302f2f6,0xf34df30a,
0xf3b9f393,0xf3dbf3d7,0xf3b3f3d0,0xf45cf3e1,0xf587f4e1,0xf6f0f644,0xf8c1f7af,0xfc25fa32,
0x01cffeb0,0x09090551,0x107a0cc8,0x17ab141e,0x1e451b16,0x24e22176,0x2bb62864,0x30e22e93,
0x33a1329b,0x342a341f,0x32b633ab,0x2fae315d,0x2bd12dd3,0x275d29ad,0x21c124c1,0x1a791e57,
0x113a1614,0x07280c2d,0xfd66022c,0xf4e3f8ec,0xee49f151,0xea62ec0a,0xe772e8ef,0xe4b7e601,
0xe340e3cd,0xe282e2dd,0xe14ae20d,0xdf0be038,0xdd37ddfa,0xdce6dce6,0xdd02dced,0xdd71dd36,
0xddc8dda1,0xdea8de1c,0xe0abdf74,0xe4cae26e,0xea48e788,0xef38ecd8,0xf450f1af,0xf9d5f706,
0xffb2fcb7,0x061402c9,0x0d8909af,0x158e1190,0x1d471967,0x25ce215b,0x2ed72a5b,0x366632ee,
0x3af6390f,0x3d3e3c52,0x3d063d8a,0x39623ba2,0x33f636cb,0x2ca93084,0x24a728a8,0x1c5d2092,
0x13b01803,0x0b1c0f62,0x030306fc,0xfc52ff5b,0xf7b4f9d6,0xf43ef5cc,0xf281f32c,0xf203f217,
0xf295f238,0xf2e5f2db,0xf1a6f291,0xeeb4f046,0xebe0ed42,0xe951ea86,0xe7a1e843,0xe7d0e784,
0xe968e87a,0xeb3dea69,0xebefebbf,0xeb5cebbe,0xeab5eaf0,0xeabdeaa3,0xeba2eb1d,0xebecebfa,
0xeb00eb95,0xe969ea48,0xe736e857,0xe4f1e61c,0xe2ebe3c9,0xe2bbe28a,0xe539e3a0,0xe9aae75d,
0xed78ebc6,0xeee5ee75,0xeee3ef08,0xeeeceec6,0xef68ef21,0xf00defba,0xf089f054,0xf15ff0e0,
0xf2cef1f9,0xf485f3b4,0xf69bf56f,0xfa0ef819,0xff98fc92,0x068a02f9,0x0dde0a2b,0x1541119d,
0x1bf318b1,0x22e11f50,0x29f32680,0x2f692cf7,0x323f3134,0x32cc32c3,0x31483245,0x2e512fed,
0x2b1a2cb0,0x27c42982,0x23a525d4,0x1e262121,0x166a1a90,0x0d2611db,0x03df087d,0xfb80ff7b,
0xf4b0f7de,0xeff4f21a,0xebdcede8,0xe85de9f4,0xe669e73b,0xe4ede5af,0xe2bfe3f5,0xe02ce16c,
0xde7bdf26,0xddddde1d,0xdda2ddaa,0xdd9eddb6,0xdd28dd5b,0xdd7edd31,0xdf47de1f,0xe38ae123,
0xe8a3e625,0xed54eafe,0xf280efd7,0xf83cf54e,0xfe5ffb42,0x05160194,0x0c9b08c9,0x13e91056,
0x1b221770,0x23181f06,0x2b462743,0x32082ef5,0x35c43448,0x37f536f0,0x384b387d,0x35d3375f,
0x31a333e9,0x2b9c2ecc,0x24972832,0x1d0f20d0,0x157f1950,0x0d8b118c,0x05e409a3,0xff530262,
0xfa6afcb7,0xf696f853,0xf455f556,0xf37df3ac,0xf3e9f39f,0xf478f443,0xf334f42d,0xf07bf1dc,
0xedbfef23,0xeaf3ec4c,0xe915e9d8,0xe924e8e3,0xead8e9ca,0xed37ec12,0xee61ee09,0xedfdee47,
0xed70edb5,0xed60ed44,0xee48edc8,0xee84ee9b,0xed91ee2a,0xebcfeccb,0xe92bea95,0xe638e7a8,
0xe3bde4d8,0xe2b9e303,0xe3e2e303,0xe6dae532,0xe990e87b,0xea20ea12,0xe991e9df,0xe98be96d,
0xea48e9d7,0xeb70eadc,0xecadec0c,0xee30ed5d,0xeffcef13,0xf1a6f0d6,0xf3c1f288,0xf77df566,
0xfd17fa11,0x04590090,0x0c57084a,0x14131051,0x1aef1795,0x22131e63,0x295e25d4,0x2f222c89,
0x321c3100,0x32b332a5,0x311d3229,0x2dee2fa7,0x2a892c2d,0x27852904,0x244225f6,0x203c226b,
0x1a711d96,0x12df16d3,0x0a650ea8,0x024d063c,0xfb6ffeaa,0xf613f8a4,0xf0dff386,0xec52ee60,
0xe938eaae,0xe694e7e3,0xe36be51c,0xe029e1bb,0xddfcdedd,0xdd13dd70,0xdcdedce2,0xdcb2dcd9,
0xdc43dc6d,0xdc81dc48,0xddfddd00,0xe1fbdfb6,0xe69ae461,0xeaebe8b7,0xeff4ed4e,0xf5f3f2de,
0xfc42f913,0x0328ff8f,0x0b160714,0x128e0ef7,0x19c51610,0x21d81db8,0x29d825f3,0x2ff72d44,
0x329b31b6,0x33f63339,0x34b434a1,0x3324341d,0x303631e2,0x2add2ddd,0x245827ac,0x1d7a20ec,
0x168f1a09,0x0f9a1319,0x08460c00,0x0127048c,0xfb8efe2f,0xf71ef92b,0xf42cf583,0xf302f344,
0xf39df330,0xf4eff448,0xf48ff51a,0xf257f384,0xefe8f123,0xecf9ee73,0xeaf2ebbf,0xeafdeab1,
0xecefebc4,0xef89ee44,0xf10af086,0xf0cff10a,0xf01af07b,0xf009efe5,0xf128f08f,0xf195f18d,
0xf0d5f151,0xeee6f019,0xeb24ed2d,0xe70fe90e,0xe36de52e,0xe12ee207,0xe184e0f7,0xe43de2c0,
0xe678e58d,0xe6b8e6ef,0xe5bbe62e,0xe551e562,0xe63ce5a6,0xe7f4e703,0xea11e902,0xec20eb0e,
0xee2fed39,0xf00cef1f,0xf27bf11c,0xf638f431,0xfb9af8a7,0x02caff08,0x0ace06ca,0x12330ea7,
0x18e01596,0x1fe41c47,0x27212388,0x2cf42a5b,0x30082ed5,0x30bd30a9,0x2f43303f,0x2c912e02,
0x29b22b0e,0x272f2869,0x24ac25f5,0x21622330,0x1cb91f3b,0x16a319dd,0x0f811328,0x08360bd2,
0x017a04c1,0xfba5fe85,0xf5b6f8b1,0xf0d0f30a,0xed0eeed9,0xe96aeb4d,0xe565e763,0xe1e6e389,
0xdfbee0a0,0xde92df13,0xde1ede45,0xdda3dde8,0xdd07dd51,0xdceddcde,0xde3bdd48,0xe1cedfd4,
0xe570e3b0,0xe939e73b,0xee07eb7a,0xf404f0e8,0xfa96f73f,0x01f5fe1e,0x0a11060a,0x117a0de0,
0x18de1510,0x20cf1cd8,0x27ff249a,0x2cdc2ad6,0x2e7c2df4,0x2ffa2f17,0x30b530aa,0x2f6e303f,
0x2c6c2e2b,0x27962a3d,0x218124a1,0x1b7b1e70,0x155b1876,0x0f221248,0x08a60bf3,0x02140547,
0xfca6ff41,0xf82bfa4b,0xf4adf647,0xf34bf3aa,0xf3e4f35b,0xf56af4c2,0xf4fff57a,0xf35ef437,
0xf16bf278,0xeee0f01b,0xed71edfe,0xedc6ed5a,0xefe1eea3,0xf266f13a,0xf3adf33f,0xf3c7f3cd,
0xf38df3aa,0xf439f3ae,0xf5b1f4fc,0xf631f624,0xf550f5e5,0xf2a4f446,0xedfcf073,0xe90ceb79,
0xe475e6a9,0xe198e2ca,0xe13ee108,0xe28ae1d9,0xe342e314,0xe219e2e3,0xe0b3e14f,0xe03ce043,
0xe144e0a1,0xe36de23c,0xe61ee4c1,0xe901e780,0xebb8ea75,0xee2cecf2,0xf10cef7d,0xf4aff2c5,
0xf9d5f700,0x00dbfd26,0x08b304c5,0x100e0c7a,0x16c31374,0x1ddd1a38,0x25132188,0x2ab7283a,
0x2de52c96,0x2ee02ea0,0x2db22e85,0x2b522c98,0x28f82a11,0x26ea27ee,0x24c625e3,0x22222394,
0x1e6b2069,0x198a1c18,0x13e816cd,0x0de210f1,0x07a50abb,0x01ad04b5,0xfb27fe63,0xf5d6f854,
0xf155f388,0xecc0ef20,0xe7faea50,0xe3e2e5ce,0xe120e250,0xdf6fe02f,0xde67dee3,0xdd58dde2,
0xdc7bdcda,0xdc2edc3e,0xdda1dc94,0xe123df4b,0xe463e2d1,0xe7dce605,0xec7be9fc,0xf276ef60,
0xf91df5b2,0x00bbfcc7,0x08dc04d8,0x104e0ca3,0x185e142d,0x20d61cac,0x27e724a1,0x2c292a80,
0x2d882d01,0x2efd2e3f,0x2efa2f52,0x2ce12e20,0x291d2b3b,0x23a9268a,0x1da420a1,0x181c1ad3,
0x12e01576,0x0dbd1054,0x08270b07,0x02b2054f,0xfdf60045,0xf982fbae,0xf5ebf784,0xf48ff4fc,
0xf509f49b,0xf5c1f58a,0xf4adf56f,0xf2d9f3c4,0xf0ccf1e4,0xeeafefa4,0xee19ee19,0xef93ee9c,
0xf24af0da,0xf508f3c8,0xf683f5f5,0xf71af6d7,0xf79cf755,0xf8e9f81f,0xfa77f9cb,0xfabefac1,
0xf9c8fa75,0xf65cf86b,0xf0fef3c8,0xeb3bee22,0xe5e4e862,0xe292e3e1,0xe239e21f,0xe27ce263,
0xe163e240,0xde72dfff,0xdbdadd0a,0xdb35db3f,0xdc2cdb7f,0xde69dd23,0xe17ddff0,0xe4b7e318,
0xe7b5e63e,0xeadee93d,0xee79eca6,0xf275f056,0xf7e1f4ec,0xfee2fb41,0x067402a9,0x0d910a17,
0x146410f5,0x1bc31805,0x23041f7e,0x2886260a,0x2c132a8b,0x2dae2d21,0x2d422db4,0x2b762c6c,
0x29832a73,0x27cf28a8,0x25dc26e8,0x23172499,0x1f5e2159,0x1b301d4b,0x17461933,0x13061545,
0x0deb1092,0x07bd0af9,0x011c0464,0xfb53fe17,0xf5d2f89b,0xefc8f2de,0xe9f4ecc7,0xe545e760,
0xe238e398,0xe040e116,0xdf13df9b,0xddf9de8a,0xdd2fdd82,0xdcf0dcf0,0xde89dd71,0xe15fdfee,
0xe3dfe2a4,0xe6f6e549,0xeb3ce8ec,0xf09aedd2,0xf709f39e,0xff08faeb,0x07020320,0x0e6c0aab,
0x16771265,0x1e0f1a6f,0x23ee213f,0x26e925e6,0x27a02747,0x28e22831,0x29c72971,0x294729c8,
0x26ad2832,0x220f24a8,0x1c691f35,0x176b19d1,0x1311152a,0x0ef5110e,0x09ed0c8d,0x04bf0743,
0x005f027f,0xfc0cfe40,0xf85bf9fb,0xf6c3f742,0xf761f6dd,0xf811f7e3,0xf758f7d8,0xf5b0f6a0,
0xf33df48f,0xf0a5f1d5,0xefa8efe1,0xf0e4f005,0xf38cf221,0xf669f50b,0xf848f782,0xf945f8d8,
0xf9f4f997,0xfb9ffaa4,0xfd58fc96,0xfdeffdd9,0xfc91fd83,0xf8a2faed,0xf308f5ff,0xec90efdd,
0xe668e94c,0xe26ce41a,0xe0cfe167,0xdffee055,0xde6cdf7e,0xdb49dcea,0xd8bad9d9,0xd7e2d805,
0xd8f3d83e,0xdb56d9ff,0xdeb5dced,0xe250e086,0xe5cbe411,0xe9ace7a8,0xedb9ebb9,0xf1c4efb5,
0xf6d3f415,0xfd8cfa0b,0x04c9012b,0x0b990840,0x12100ecd,0x195e159e,0x209a1d1f,0x2626239e,
0x29de283a,0x2bbf2b04,0x2bda2c0a,0x2ac52b5d,0x29712a22,0x27f228ba,0x2612271b,0x233a24be,
0x1f982183,0x1bdd1da5,0x19051a51,0x166a17c9,0x12fa14dc,0x0d611076,0x06c70a02,0x00dd03d1,
0xfad4fdd7,0xf459f7af,0xedd5f0fe,0xe88eeafd,0xe4e5e698,0xe22ce369,0xe03be124,0xde96df5d,
0xdd88ddff,0xdd02dd2a,0xde4bdd5e,0xe0a1df78,0xe2c6e1ba,0xe558e3ec,0xe939e71a,0xee3feb9e,
0xf496f12f,0xfcb0f87f,0x04d700dd,0x0c8108a5,0x14c31095,0x1c6b18c6,0x22541fa4,0x2520243a,
0x25e4257a,0x27542694,0x282a27e5,0x27742817,0x249c263a,0x1fef2281,0x1a841d39,0x159617f2,
0x11c01393,0x0de80fe2,0x09390bac,0x047e06c2,0x0094027f,0xfc99fe9f,0xf936fab8,0xf7cff835,
0xf872f7f4,0xf90ff8eb,0xf867f8d8,0xf6ebf7c6,0xf46df5ca,0xf1fbf30c,0xf13df15e,0xf2c0f1bb,
0xf586f40f,0xf854f706,0xfa3cf965,0xfb87fae5,0xfcb8fc0f,0xff06fdb9,0x016d0054,0x029f0242,
0x0154025e,0xfce0ff71,0xf66ff9d8,0xeeaef2af,0xe73ceabe,0xe265e477,0xdfd3e0e5,0xde50df11,
0xdbd3dd4d,0xd7ebd9e5,0xd518d648,0xd432d45a,0xd53dd48d,0xd7c7d650,0xdb45d979,0xdedadd08,
0xe2a1e0b1,0xe716e4ce,0xeb6ee946,0xefceed91,0xf547f258,0xfc0ff88d,0x035affbb,0x0a1006ce,
0x109b0d40,0x17df142c,0x1ee01b87,0x244421c9,0x282a266c,0x2a66297a,0x2af12ade,0x2a8e2ad4,
0x29ee2a45,0x29042981,0x2772285c,0x24df264d,0x21472326,0x1de71f7d,0x1b841c9d,0x19671a73,
0x16731829,0x114f141e,0x0b220e2f,0x05430841,0xfee50221,0xf7bcfb6b,0xf0b3f421,0xeaf6ed96,
0xe6a1e8b7,0xe325e4c3,0xe068e1b8,0xde41df34,0xdd17dd95,0xdcb8dcbb,0xde11dd31,0xe032df26,
0xe25ce138,0xe50ee3a1,0xe8b5e6c1,0xed65eaeb,0xf3a2f03d,0xfb9af784,0x0373ffa0,0x0b2d073c,
0x130f0f39,0x19ac168f,0x1ecf1c7d,0x210d2051,0x21d32164,0x23862281,0x25d524c6,0x267e2671,
0x24a425d8,0x205022d8,0x1aad1d6d,0x15de1823,0x11fa13d5,0x0e4e103c,0x09b30c15,0x05000748,
0x01420304,0xfdb9ff88,0xfabbfc0c,0xf957f9cd,0xf9e9f978,0xfa52fa43,0xf9c4fa21,0xf802f91a,
0xf4fbf695,0xf22ef36a,0xf14bf17d,0xf2a7f1a6,0xf5b9f414,0xf911f77c,0xfba3fa68,0xfd8bfcb1,
0xff53fe58,0x023100a8,0x055503d5,0x06c10661,0x04cc0630,0x001002bb,0xf8d6fcbe,0xeff5f47c,
0xe7b9eb9b,0xe1d0e484,0xde16df9c,0xdc2fdd0f,0xd9cfdb39,0xd654d809,0xd3a1d4d7,0xd265d2cd,
0xd34dd29a,0xd57fd444,0xd85ad6df,0xdb75d9de,0xdf8edd5e,0xe484e1f8,0xe985e703,0xeea6ec0b,
0xf47df169,0xfb8ff7e6,0x02d2ff47,0x08f90612,0x0ec80bca,0x154f11f4,0x1bbe18a2,0x21231e93,
0x255a2366,0x280026e6,0x294728c7,0x29ee29a3,0x2a4c2a26,0x2a122a4c,0x28a02986,0x25f4276f,
0x22292421,0x1eec205b,0x1d0a1dd9,0x1b711c4f,0x18a71a4a,0x13f21677,0x0f24117f,0x09d20c9c,
0x034f06c4,0xfb69ff68,0xf3eaf78a,0xede4f0b4,0xe8fceb4f,0xe543e700,0xe204e39c,0xdf5fe088,
0xddc9de79,0xdd7bdd66,0xdf07de17,0xe0f3dffc,0xe32be205,0xe5a1e457,0xe8d0e721,0xed0deabc,
0xf35befe9,0xfac3f715,0x01defe4c,0x09bc05ac,0x11a50dd0,0x17fc150d,0x1c741a8e,0x1e141d84,
0x1f491e9b,0x21922046,0x23be22dc,0x238123f1,0x215f22a4,0x1cce1f6f,0x174719f4,0x12ac14da,
0x0ee510b3,0x0b150d0d,0x06ce08f3,0x030804ca,0x007001ab,0xfda6ff11,0xfba8fc87,0xfb1cfb1a,
0xfbe3fb8a,0xfbdcfbf7,0xfb4cfbae,0xf945fa83,0xf603f7b0,0xf36af480,0xf2f0f2e2,0xf4f9f3ab,
0xf867f698,0xfba7fa24,0xfe5afd0f,0x006eff76,0x030b018c,0x06e404da,0x0aa008f2,0x0bc20ba4,
0x09520aee,0x042e0716,0xfc300081,0xf26bf75c,0xe9b4edd3,0xe2c9e5fb,0xde5fe03c,0xdbbcdd02,
0xd81eda2c,0xd3b7d5d2,0xd06ad1e5,0xcf02cf69,0xcfd7cf2f,0xd20cd0d7,0xd4d7d369,0xd7e0d645,
0xdc3bd9e6,0xe1d2dee7,0xe79be4b4,0xed79ea89,0xf3ccf085,0xfb05f758,0x01a5fe86,0x0706046a,
0x0c9909b3,0x12c00fa8,0x188815bf,0x1da71b2b,0x21f71ff1,0x24ee239f,0x2708260e,0x28ed27fb,
0x2a8b29d2,0x2b232b03,0x2a2a2adc,0x27a22914,0x242e25e6,0x214a229d,0x1f682043,0x1d591e78,
0x1a0f1bf2,0x158717c8,0x11891381,0x0cca0f55,0x064f09cf,0xfea7028c,0xf757fad0,0xf112f425,
0xebaeee38,0xe761e97a,0xe359e555,0xe028e194,0xde3fdf0e,0xde17dddb,0xdfcaded9,0xe1ffe0d7,
0xe48be346,0xe74be5da,0xea80e8d5,0xee87ec53,0xf450f13c,0xfa9ef77c,0x0110fdb9,0x08c004c9,
0x10340caa,0x15f41340,0x19be183f,0x1b181a81,0x1cb91bc7,0x1fb01e16,0x220f2127,0x21ba2238,
0x1f4e20ce,0x1a421d09,0x14bb176c,0x0ff3123c,0x0bea0ddc,0x07f109f2,0x040c05f1,0x010a025c,
0xff0a000c,0xfcd9fde1,0xfb84fc12,0xfbcefb68,0xfc88fc4d,0xfc86fc92,0xfbd5fc59,0xf96afad2,
0xf618f7c1,0xf3c4f4b2,0xf39ef35c,0xf634f4ab,0xfa20f80d,0xfde4fc16,0x0125ff98,0x039f026c,
0x06eb0515,0x0b8e0924,0x0f990dd3,0x1073107f,0x0df20f8f,0x08890ba0,0xffdc049a,0xf5c5fac7,
0xec4ff0f3,0xe451e808,0xdef5e147,0xdb52dd17,0xd6c7d936,0xd1e1d448,0xcdd0cfb2,0xcbdfcc7c,
0xcc11cbd0,0xcd8dcca8,0xd01ecebb,0xd377d1a5,0xd828d5a0,0xde38db15,0xe4c1e17d,0xeb51e805,
0xf295eed2,0xfa1df670,0x0049fd6b,0x055c02df,0x0ab607f0,0x10c00db9,0x165a139e,0x1b9d190c,
0x1ffb1df4,0x234421b4,0x261524b0,0x29032791,0x2b602a51,0x2c582c08,0x2b652c29,0x28872a22,
0x252c26d8,0x229523b8,0x20a321a2,0x1de71f64,0x19ee1c17,0x15ee17c2,0x12d01462,0x0e8810e3,
0x08a40bbe,0x01fc0555,0xfb91fec9,0xf54cf859,0xefeaf27c,0xeb2aed80,0xe68ae8d2,0xe2dbe486,
0xe081e181,0xe00bdfff,0xe0ffe066,0xe31ee1ee,0xe5bbe466,0xe896e71f,0xebb3ea14,0xf00aeda8,
0xf559f2ae,0xfaaaf7f2,0x0121fdb5,0x088304ce,0x0e930bcd,0x12ed10f2,0x1538144c,0x16b51603,
0x18821769,0x1c141a25,0x1e5e1d92,0x1e431e96,0x1b5c1d35,0x163518ea,0x111b1399,0x0ca40ec1,
0x08fb0ac5,0x0568072d,0x026f03d1,0x007c0151,0xff18ffc9,0xfe04fe79,0xfdb3fdb3,0xfed3fe2d,
0xffb9ff59,0x0007fffd,0xfea2ff9d,0xfb81fd35,0xf7bcf99f,0xf538f62f,0xf551f4ea,0xf806f666,
0xfbf8f9f5,0xffeafdfe,0x030f019f,0x05ba0458,0x09850767,0x0ea10c0b,0x126210da,0x12c41307,
0x102811ce,0x0a840dba,0x01b4067a,0xf789fca7,0xed3ff24f,0xe45ce890,0xde6fe106,0xda0fdc2a,
0xd569d7d1,0xd055d2e4,0xcbd0cde0,0xc9a1ca58,0xc95dc959,0xca97c9c8,0xccf2cbb2,0xd026ce5f,
0xd502d24e,0xdb53d816,0xe21ddeb2,0xe90fe581,0xf10decf1,0xf8eff526,0xfef9fc31,0x03ec017a,
0x0957068a,0x0f240c3d,0x14dc11fd,0x1a4517ae,0x1e6f1c84,0x219d2012,0x24ec2336,0x285d26af,
0x2b2229dd,0x2c682c02,0x2bc32c4f,0x29a12ace,0x271e285c,0x254e261a,0x2342246e,0x1fe321c4,
0x1b3d1da6,0x1757191b,0x141515b9,0x10161241,0x0af20da3,0x05270812,0xff580248,0xf92ffc43,
0xf39bf658,0xee12f0dd,0xe8c9eb53,0xe4b9e69e,0xe1d6e309,0xe0a8e114,0xe0d9e08d,0xe2c3e1a3,
0xe552e3fe,0xe81de6b0,0xeb8ce9b2,0xf042edc4,0xf577f2e7,0xfab0f7fc,0x014afdce,0x084004e2,
0x0d700b1c,0x10b50f54,0x12501199,0x13c81309,0x161314b7,0x19e217e4,0x1c4e1b6f,0x1c511ca2,
0x197c1b3e,0x14a3172f,0x0fdd1232,0x0b840da1,0x0754096e,0x03700553,0x002b01b9,0xfdf2fee4,
0xfcb8fd3e,0xfc3efc5e,0xfd09fc6c,0xff08fe06,0x00a4ffea,0x01880143,0x0059013f,0xfd10fee0,
0xf94afb22,0xf6bbf7bb,0xf6aef65c,0xf929f7b6,0xfcd6fae6,0x00fafeeb,0x048902d9,0x0806062c,
0x0cac0a31,0x11eb0f58,0x15ad141b,0x1665167a,0x13e21582,0x0e1c1171,0x051c09e8,0xfa85fffc,
0xef87f4e3,0xe606ea82,0xdf41e252,0xda26dc90,0xd52cd7c1,0xcfe7d28e,0xcb16cd56,0xc843c95e,
0xc75ac79d,0xc806c775,0xca0dc8fd,0xcce1cb45,0xd193cf08,0xd799d47b,0xde36dade,0xe58ae1bd,
0xee04e9aa,0xf63df24d,0xfcbef9b7,0x01b7ff58,0x068e041d,0x0bbe091a,0x116a0e80,0x16fc1453,
0x1b6e1956,0x1f4f1d5d,0x23a92167,0x282825f6,0x2bc62a24,0x2d612cda,0x2ce12d59,0x2b1d2c17,
0x291b2a07,0x27a62860,0x258026bc,0x21b523d6,0x1d081f50,0x19861b26,0x162d17f4,0x12091428,
0x0d510fc3,0x08870ae4,0x032905fa,0xfd5d0044,0xf785fa69,0xf189f48d,0xebdfee94,0xe770e98b,
0xe44ee5ae,0xe289e348,0xe252e224,0xe40ee2fe,0xe698e54d,0xe95ee7f0,0xed00eafe,0xf1baef52,
0xf62df40b,0xfad7f856,0x0123fddb,0x070f0447,0x0b6b0973,0x0dcf0cd4,0x0f660e9f,0x10f81026,
0x13eb1225,0x17b415fd,0x192f18bf,0x180718f2,0x1428166d,0x0f5c11b6,0x0aea0d19,0x06e408d8,
0x030304f5,0xff500123,0xfc3afd97,0xfa8efb4d,0xf9eafa16,0xfa53f9f7,0xfc97fb33,0xffacfe2b,
0x02560115,0x038d033a,0x022d032f,0xff0a00bd,0xfb97fd37,0xf9aefa68,0xfa60f9a8,0xfd0ffb95,
0x00a0fec0,0x04610287,0x07e70624,0x0c1909e7,0x112e0e87,0x162013cd,0x190c17f2,0x1905195d,
0x16521812,0x102413ac,0x07170be8,0xfc0701be,0xf0d9f654,0xe784ebd4,0xe08de3d0,0xdabedda2,
0xd49bd7b8,0xce44d16c,0xc8b9cb3f,0xc586c6ea,0xc410c489,0xc4a4c420,0xc64fc557,0xc947c795,
0xce1dcb79,0xd439d106,0xdb0fd799,0xe307ded9,0xec23e78d,0xf481f07f,0xfafdf809,0xffe1fd81,
0x04b4023f,0x09ef0742,0x0fbd0ccf,0x154f129d,0x19f717b4,0x1e7f1c34,0x237420ee,0x287d25f8,
0x2c5c2aad,0x2e3c2d88,0x2e612e7c,0x2d342df1,0x2bc82c6e,0x2a302b1a,0x271628db,0x225b24e7,
0x1dba1fdf,0x1a4d1bea,0x16ad189c,0x12531481,0x0e45103c,0x0a630c5b,0x057e0817,0xfff502be,
0xfa13fd22,0xf3c3f6df,0xede5f0bb,0xe92aeb58,0xe5d0e750,0xe39fe48d,0xe361e336,0xe511e40c,
0xe796e644,0xeab5e90d,0xeedceca5,0xf363f12d,0xf74bf564,0xfc0af977,0x01bdfee0,0x06bb046e,
0x09bf0882,0x0b140a85,0x0c630bb0,0x0e1c0d21,0x11910f9b,0x156013ae,0x16de1673,0x15471678,
0x1156137d,0x0cf00f17,0x08e20adf,0x04fd06eb,0x01510320,0xfdc3ff80,0xfad5fc2d,0xf8f7f9c0,
0xf864f88a,0xf94ff893,0xfc20fa8e,0xff84fdd3,0x02be013d,0x03f603b6,0x025d0375,0xff4600e3,
0xfc62fdad,0xfb1efb85,0xfc39fb61,0xfee4fd6b,0x02610096,0x0616043b,0x0a2407fe,0x0f080c84,
0x145e11ae,0x191116e6,0x1b9d1aad,0x1b971be6,0x18ae1a8f,0x126915f3,0x08fe0e16,0xfd84035d,
0xf223f7aa,0xe89ded14,0xe111e4a6,0xda69ddc1,0xd37bd6f9,0xcce0d00e,0xc784c9fa,0xc42cc5a0,
0xc28ac31f,0xc299c267,0xc3e3c306,0xc716c549,0xcbe3c94b,0xd1d5cebf,0xd88dd516,0xe079dc52,
0xe960e4e5,0xf1c6edba,0xf88af56b,0xfdbafb3d,0x0293001f,0x07ef0527,0x0dbf0ad3,0x13431091,
0x184415c5,0x1d971ae7,0x233a2060,0x28cf2618,0x2ce62b16,0x2f082e3d,0x2fad2f7c,0x2f412f8f,
0x2e4b2ed8,0x2c662d88,0x28ca2ad6,0x23e5265f,0x1f9121a2,0x1bf81dbd,0x179419e4,0x12e81539,
0x0f1010d4,0x0b8b0d6c,0x070c095c,0x021504a6,0xfc51ff51,0xf5e6f924,0xefe6f2cc,0xeb0bed49,
0xe768e923,0xe4cde5e8,0xe468e444,0xe606e50e,0xe87ae72d,0xebbee9f5,0xf01eedde,0xf3f9f22f,
0xf798f5b0,0xfc94f9f5,0x016fff23,0x04c90358,0x060305ae,0x0677061e,0x07ca0716,0x09a30891,
0x0db90b5a,0x12c3105e,0x15531486,0x1426151b,0x1057128c,0x0b640dcc,0x0722093d,0x02ea0503,
0xff5400ff,0xfc0bfdaf,0xf8c7fa61,0xf6f5f792,0xf6daf6c7,0xf8a9f76d,0xfc1bfa40,0x0097fe35,
0x051e0309,0x07040683,0x05680695,0x01f103c0,0xfe8a0022,0xfcc6fd5f,0xfd91fce7,0x0021feaa,
0x040901f5,0x08400623,0x0d090a8a,0x121a0f90,0x170914a0,0x1b2a1943,0x1d421c92,0x1c831d35,
0x193c1b32,0x12db167d,0x09430e64,0xfd800395,0xf1d8f780,0xe809eca3,0xe0c5e41f,0xda9fddc1,
0xd3abd738,0xccbad02b,0xc698c96b,0xc2b9c465,0xc11fc1a7,0xc114c0f7,0xc230c16a,0xc55ec386,
0xca25c79f,0xcffdcce3,0xd6fed36c,0xdec0dab6,0xe77be30e,0xefb9ebbd,0xf658f341,0xfb79f90c,
0x007afde3,0x06560355,0x0c5d095e,0x12050f3e,0x17b214c9,0x1de61ac2,0x246b2123,0x2a312782,
0x2dd72c52,0x2fb32eed,0x308c303e,0x30a830b5,0x2f91304a,0x2c9a2e58,0x28382a7d,0x23a625ed,
0x1f96217d,0x1b601da3,0x169f18ef,0x12c3148b,0x0f791126,0x0bd00d9e,0x07ed09f4,0x030305a5,
0xfd050013,0xf70cf9fe,0xf1a6f439,0xed62ef66,0xe9cdeb7d,0xe798e87b,0xe77fe73d,0xe92be831,
0xebb4ea51,0xef52ed6c,0xf2c5f127,0xf5c2f43c,0xf9b3f78c,0xfe97fc2a,0x025700af,0x03ff037a,
0x03f00407,0x044e0407,0x052604ab,0x070e05ec,0x0af408b3,0x0fb60d88,0x11621102,0x0ff310fc,
0x0c010e3b,0x077809ab,0x03980571,0x003a01dc,0xfd5dfebb,0xfa9cfc0d,0xf791f902,0xf5f2f691,
0xf614f5c2,0xf7f8f6db,0xfb6ff96e,0x00cffdfa,0x05ba0388,0x07d3072f,0x06750785,0x035404f9,
0x005001b5,0xfeafff40,0xff2dfeac,0x017b0020,0x04e50316,0x093906f2,0x0e2f0bab,0x132f10ba,
0x17ab157f,0x1b5019a6,0x1d3b1c8f,0x1ce31d5a,0x19f61bc5,0x1386173c,0x0a1e0f26,0xfe67045f,
0xf307f892,0xe9d6ee0c,0xe33ae64d,0xdd05e041,0xd5d1d977,0xce6ad21d,0xc7decadd,0xc3f6c598,
0xc1f6c2d0,0xc119c15c,0xc1d3c13e,0xc47ec2ec,0xc8a7c666,0xce4acb3d,0xd4efd186,0xdc3dd87b,
0xe466e045,0xec5be878,0xf315eff0,0xf884f5e3,0xfe21fb39,0x045f0133,0x0a650772,0x102d0d48,
0x165a132d,0x1d2619b8,0x23e3209a,0x297426d8,0x2d3a2b91,0x2fb32e98,0x31493096,0x31d731c4,
0x306c3170,0x2c9b2ebd,0x27d52a31,0x23a125a6,0x1fc621be,0x1b441d98,0x16df18fa,0x137f150c,
0x105711f9,0x0ce30ea7,0x08e70afe,0x042d069f,0xff020197,0xf9dcfc6e,0xf53af774,0xf0e1f30c,
0xed25eee2,0xeb02ebd3,0xeae6eabb,0xec33eb6b,0xee86ed35,0xf1b5f019,0xf46af32a,0xf6eef593,
0xfac0f8b1,0xfef5fcf5,0x0159006e,0x018001b3,0x00a90107,0x00920086,0x017300de,0x0343023f,
0x06be04af,0x0b250919,0x0d500c92,0x0c9d0d4e,0x09750b48,0x0588077b,0x020203aa,0xff51009d,
0xfd22fe2a,0xfaa4fbfd,0xf7bff923,0xf62ff6b5,0xf6bef640,0xf8b6f78d,0xfc31fa37,0x0180feb2,
0x06890439,0x08fb082b,0x084e08ee,0x06180752,0x036304b6,0x01940251,0x018c0147,0x034f023b,
0x066504ae,0x0acf087f,0x0f790d29,0x13cd11b2,0x17c515d4,0x1b2d1999,0x1d151c66,0x1c5f1d08,
0x18d71b11,0x120a15bd,0x089d0da9,0xfd920333,0xf2caf803,0xe9faee0a,0xe3abe694,0xddd7e0e0,
0xd6e9da84,0xcf0dd30a,0xc80acb32,0xc452c5d3,0xc236c32d,0xc128c183,0xc175c113,0xc391c259,
0xc72dc524,0xcca9c9b6,0xd2e5cfc5,0xd9a0d626,0xe164dd68,0xe938e55c,0xf003ecca,0xf5f2f2fe,
0xfc53f908,0x032fffc8,0x09ea0694,0x10ae0d46,0x179e1419,0x1ebe1b38,0x253b221d,0x2a5427ff,
0x2de22c41,0x30802f4d,0x32873195,0x3302330b,0x30a43230,0x2c7b2ea9,0x28222a45,0x24442624,
0x1ff62240,0x1b381d91,0x17381911,0x141515a5,0x10c71277,0x0d1e0f08,0x08b30b00,0x03f80656,
0xff8101a5,0xfb96fd81,0xf785f99c,0xf328f551,0xef96f137,0xed78ee4e,0xed2fed19,0xee4bed8f,
0xf0beef64,0xf348f21f,0xf557f448,0xf856f6a4,0xfc4ffa4d,0xff71fe19,0x005c0037,0xff74ffff,
0xfed9ff14,0xfeeafeba,0x0050ff82,0x024f012c,0x060203f0,0x09ba0817,0x0b220ac0,0x09ab0abf,
0x06140811,0x01f703f5,0xfec70045,0xfc4cfd6c,0xfa6efb5b,0xf81ef957,0xf5c0f6e2,0xf50df515,
0xf5f5f572,0xf7c2f6a7,0xfba1f968,0x00eafe38,0x05d2038f,0x085e0772,0x088e08b5,0x075d080a,
0x05b30693,0x046704eb,0x04e10464,0x06f105ba,0x0aad089d,0x0f090ce0,0x12e61111,0x1626148d,
0x195917bf,0x1c1a1ad9,0x1d611d01,0x1c3f1d2a,0x18001a7d,0x10ff14d8,0x07b10c86,0xfd530296,
0xf36df837,0xeb9eef2c,0xe5c7e892,0xdfdee2fa,0xd82cdc39,0xcf7ad3d4,0xc865cb89,0xc464c61f,
0xc21cc314,0xc0f2c16b,0xc0f2c0c3,0xc266c185,0xc5afc3c5,0xcaccc817,0xd087cda4,0xd6c5d384,
0xddf6da49,0xe54ce1ab,0xebfbe8ba,0xf296ef3c,0xf9e8f623,0x019efdc6,0x092a056c,0x10b20ced,
0x18291470,0x1f221bc9,0x24fb222c,0x29e12789,0x2dab2be9,0x30ae2f44,0x32e531e8,0x33843386,
0x313432b0,0x2d392f46,0x29562b35,0x256c2768,0x20b82335,0x1bf01e41,0x17e519cd,0x14691627,
0x10b51295,0x0c9b0ebf,0x07bf0a38,0x032c0557,0xff720136,0xfc84fde7,0xf954fb0a,0xf59cf777,
0xf276f3ea,0xf0a5f15a,0xf010f037,0xf0b2f039,0xf2c5f196,0xf507f3fa,0xf6fdf5f2,0xfa12f85a,
0xfdebfc0b,0x0075ff6e,0x00cc00ed,0xff990038,0xfecaff23,0xfeb9fe95,0x0009ff46,0x01bc00cc,
0x04e60320,0x07d8069b,0x086d0878,0x067e07ba,0x02e704de,0xff0b00dd,0xfc03fd6d,0xf9c2facd,
0xf7ebf8d5,0xf5bbf6d7,0xf3eef4b5,0xf42cf3c1,0xf569f4d1,0xf75cf62d,0xfb36f909,0x0057fdbc,
0x050f02da,0x07c106b8,0x0875084a,0x081b085d,0x070107a1,0x061e066f,0x070a0652,0x09970813,
0x0dea0ba3,0x11dd1008,0x14b31367,0x174615fb,0x19c21880,0x1c181b03,0x1d221ce8,0x1b0d1c7d,
0x164818fe,0x0f2512f2,0x064e0ae7,0xfcc1018e,0xf3d8f81c,0xececf019,0xe7edea4d,0xe293e57c,
0xdb13df12,0xd244d6b9,0xcaccce34,0xc59fc7f0,0xc29dc3db,0xc10ec1b3,0xc0a5c0a9,0xc21cc124,
0xc564c386,0xc9e6c794,0xceedcc5f,0xd48ad19f,0xdaf3d7ac,0xe1bede5b,0xe843e505,0xef48eba6,
0xf740f330,0xffc5fb78,0x08670417,0x10eb0ca8,0x18f2150d,0x1fca1c8e,0x256122b9,0x2a1327c9,
0x2e302c40,0x31632feb,0x3374329b,0x32da3392,0x2faa3172,0x2c1e2dd2,0x28fe2a91,0x25122743,
0x1ff2227b,0x1b9f1da8,0x186c19f7,0x14fc16c4,0x11271319,0x0cd00f11,0x07c40a58,0x02f50541,
0xffaf0119,0xfd89fe97,0xfab5fc37,0xf7c3f92f,0xf574f680,0xf400f4a3,0xf373f39a,0xf460f3ab,
0xf61ef547,0xf72af6b9,0xf902f7d7,0xfc2efa87,0xfef9fdb6,0x001dffdc,0xfeedffb7,0xfda7fe33,
0xfcf5fd3d,0xfdaafd17,0xff55fe77,0x01ac0060,0x04ed0337,0x079e067f,0x07b10806,0x054306b1,
0x0143036d,0xfd35ff23,0xfa26fb86,0xf7d8f8fd,0xf562f6a5,0xf335f441,0xf1f4f251,0xf2c2f235,
0xf3e0f34c,0xf64ef4de,0xfa00f802,0xfe95fc35,0x03260101,0x062a04e3,0x07bb0710,0x08650837,
0x07c50830,0x076f0771,0x08cc07e8,0x0c590a3c,0x11270ec8,0x14ec133e,0x17391631,0x19031827,
0x1b1c19f5,0x1d491c41,0x1dc71df4,0x1b2b1cbb,0x16321902,0x0f1812df,0x066b0ae0,0xfd1701bb,
0xf507f8d5,0xef23f1cc,0xea90eccf,0xe504e816,0xdd06e14c,0xd413d887,0xcbf5cfc9,0xc5dec8a9,
0xc22fc3c7,0xc01cc102,0xbf7abf87,0xc102bffe,0xc419c26b,0xc811c5f6,0xcc7dca3c,0xd1b9cef4,
0xd800d4ce,0xdeaadb52,0xe575e1fe,0xed0ae91d,0xf5a0f12c,0xff12fa46,0x089803e8,0x11e60d4c,
0x1a0c1628,0x209d1d8a,0x25cc2347,0x2a95283c,0x2eae2cbd,0x31973055,0x3295326b,0x3101320d,
0x2e182fa1,0x2b272c94,0x282a29bc,0x23f12636,0x1fa821b2,0x1c7b1df6,0x197d1b0a,0x163317df,
0x12611469,0x0d82100c,0x08510ade,0x03d405f1,0x00ff022b,0xff4d0021,0xfd81fe67,0xfba6fc93,
0xf9fbfac3,0xf8bcf954,0xf810f846,0xf847f81d,0xf885f86d,0xf8d9f897,0xfa66f974,0xfc6ffb7b,
0xfd59fd10,0xfccafd41,0xfb4dfc0d,0xfa03fa9f,0xf97cf995,0xfa3bf9ba,0xfc18fb0a,0xfe17fd22,
0x009fff39,0x0377022a,0x0451042f,0x033603f9,0x0089020d,0xfd57fed6,0xfb04fc1a,0xf8caf9ea,
0xf686f7aa,0xf475f56d,0xf37ef3d2,0xf3e3f37e,0xf58df497,0xf7f7f6bd,0xfa89f926,0xfe2dfc41,
0x02280025,0x05da041e,0x083e0739,0x094e08f6,0x08cb092f,0x087e0886,0x09b408cb,0x0d6f0b52,
0x12030fc5,0x157613f6,0x17681696,0x18a41802,0x1a5d196d,0x1c401b66,0x1c301c92,0x19531b11,
0x14671715,0x0db01144,0x059609bd,0xfcf50143,0xf537f8e7,0xef45f1f4,0xeb30ed16,0xe6b1e92b,
0xe001e395,0xd81ddc29,0xcfe6d3ec,0xc99bcc7a,0xc5afc75a,0xc356c45b,0xc268c2a9,0xc34dc2ae,
0xc53dc426,0xc7fbc684,0xcb48c993,0xcf5fcd36,0xd495d1d0,0xdad4d799,0xe1bdde36,0xe933e566,
0xf1beed48,0xfbf5f6ac,0x070c0179,0x117d0c72,0x19fb15ff,0x20621d72,0x259b2308,0x2a8f2821,
0x2eec2cdf,0x316b3079,0x314131a5,0x2f49306a,0x2cbb2e0a,0x2a562b88,0x271d28e2,0x2311251b,
0x1f76211b,0x1ca11e0d,0x19b51b2c,0x16811835,0x122b147e,0x0d010fae,0x07bc0a54,0x03a4057d,
0x00e60220,0xff2affeb,0xfe3ffea0,0xfddbfe03,0xfd94fdbd,0xfd14fd50,0xfce9fcf6,0xfcaffcd6,
0xfc17fc62,0xfc88fc21,0xfe09fd36,0xfec8fe99,0xfe30feac,0xfc6cfd60,0xfa8bfb7d,0xf8cef993,
0xf82ef865,0xf893f82c,0xfa22f954,0xfb5cfac7,0xfd5ffc2c,0x000ffecf,0x014700e4,0x00720119,
0xfe4aff85,0xfb7afcd0,0xf90efa47,0xf6c2f7e0,0xf486f5a1,0xf34ef3be,0xf2dcf303,0xf3d8f31a,
0xf646f4fb,0xf88ef774,0xfb07f9ba,0xfe6cfc99,0x02ac007a,0x06b804cf,0x098c084e,0x0aa90a4b,
0x0a8a0ab4,0x0a7f0a66,0x0c670b20,0x10240e1c,0x1451124d,0x173915fe,0x184d17f4,0x18ac187c,
0x196718ef,0x1a0a19e0,0x18ff19c1,0x15cc17af,0x10ef1385,0x0ab90e04,0x03810733,0xfbe1ffbc,
0xf4d9f829,0xefc3f20b,0xec53edf2,0xe888ea97,0xe303e5fd,0xdbe6dfa2,0xd435d802,0xcdfed0e0,
0xc97fcb86,0xc682c7d3,0xc521c59e,0xc542c518,0xc5f0c584,0xc72dc678,0xc975c83a,0xcc90cae0,
0xd144ceac,0xd763d434,0xde8bdadc,0xe63be246,0xef18ea72,0xf9e3f44f,0x05c5ffce,0x10870b60,
0x1924151a,0x1fe71cba,0x258e22c8,0x2aae282b,0x2ee22cfb,0x30ff3047,0x30ac3116,0x2ed62fe4,
0x2c962db2,0x2a712b90,0x274128ff,0x23522558,0x1fd0216a,0x1cd31e5e,0x19861b2f,0x15e017c4,
0x11a513d6,0x0cf70f4c,0x08680aab,0x048b0654,0x01960303,0xff830060,0xfecdff03,0xff04fedb,
0xff45ff34,0xff01ff27,0xff02fef4,0xfec0fef9,0xfe2efe5f,0xfeaafe49,0xffc8ff4b,0xffd2fff2,
0xfe35ff48,0xfbbffceb,0xf97efaa3,0xf7c3f879,0xf757f772,0xf7d6f76d,0xf93df87a,0xfa8af9f1,
0xfc0dfb2b,0xfeb8fd5a,0x002effbc,0xff910013,0xfdb5febd,0xfb07fc65,0xf8baf9e1,0xf64af780,
0xf418f517,0xf338f37f,0xf2aaf2ef,0xf37bf2c4,0xf627f4bf,0xf857f756,0xfa8bf961,0xfdb4fbf5,
0x0228ffcf,0x06ed049a,0x0a6708f0,0x0bde0b51,0x0c560c36,0x0cdf0c6f,0x0f2f0dd9,0x126f10c2,
0x15dd1422,0x1864175f,0x190518de,0x19031905,0x1917191c,0x185418d0,0x16581793,0x12a214b2,
0x0dc61044,0x08130b13,0x017d04d7,0xfa8bfe09,0xf427f731,0xef69f188,0xec7dedcf,0xe9bfeb33,
0xe554e7e6,0xde79e221,0xd6ceda97,0xd0a6d377,0xcc0dce2d,0xc8faca4f,0xc77ac815,0xc6c9c70b,
0xc65dc688,0xc6a5c666,0xc826c738,0xcad1c951,0xcefeccad,0xd4d7d1c2,0xdbd2d839,0xe3a3df99,
0xecd5e7fd,0xf809f237,0x042afe1e,0x0f5009f7,0x186e141b,0x1fe01c56,0x260b2316,0x2b5028ce,
0x2f4b2d84,0x311e3080,0x3074311a,0x2e612f70,0x2c0b2d42,0x298e2ad3,0x2663281e,0x2288246f,
0x1f6e20cf,0x1cc81e2e,0x19721b35,0x15c917a5,0x11bb13d1,0x0d7d0f93,0x095e0b6b,0x059f0765,
0x025c03f2,0x0018010b,0xff38ff79,0xff90ff4d,0x0005ffd8,0x002d001c,0x00980057,0x00b400bf,
0x00780086,0x012200ba,0x01be0189,0x012101a5,0xfeeb0037,0xfbf5fd68,0xf944fa9d,0xf75af819,
0xf6bef6f3,0xf70ff6c1,0xf85df7a4,0xf9aaf90b,0xfb20fa46,0xfdccfc61,0xff85fef3,0xfed0ff73,
0xfca1fdde,0xf99bfb22,0xf6c3f82f,0xf43af569,0xf286f33f,0xf209f228,0xf1e9f1f0,0xf32ef23c,
0xf5f7f48f,0xf833f731,0xfa04f913,0xfd0cfb54,0x0167ff14,0x063003dc,0x09810822,0x0b060a62,
0x0be60b86,0x0d3f0c55,0x103d0e9a,0x13a711f6,0x17191560,0x197e1886,0x1a0c19f4,0x19ea1a00,
0x18ff1998,0x17531841,0x14dc1633,0x1142133d,0x0cce0f14,0x078d0a4f,0x018f049f,0xfb60fe6f,
0xf59af864,0xf13af32e,0xee87efbb,0xec19ed5d,0xe7caea53,0xe125e4b1,0xd9a7dd61,0xd35dd648,
0xcea1d0d1,0xcb56cccb,0xc94cca35,0xc7e7c893,0xc681c733,0xc5a8c5f9,0xc601c5a8,0xc7cdc6ba,
0xcb87c95d,0xd16ace44,0xd8b8d4f6,0xe103dcb1,0xeac6e5b5,0xf63bf053,0x02a7fc64,0x0e4b08ad,
0x18371387,0x20391c6c,0x269c239a,0x2bba2956,0x2f172daf,0x2fe32fd9,0x2e962f68,0x2cd42dc2,
0x2a8b2bb6,0x27f72954,0x24b82665,0x21ad2318,0x1f85209a,0x1cb11e2e,0x196a1b1a,0x159f179d,
0x11671383,0x0d460f4f,0x09840b60,0x060a07c0,0x02af044e,0x008d016e,0xffa6fff1,0x0007ffb2,
0x00f9007b,0x024a019a,0x032402dd,0x03330334,0x039b034d,0x0495041b,0x04a004bf,0x0331042c,
0xffeb01a2,0xfcddfe55,0xf9fdfb70,0xf7eff8cb,0xf6d2f740,0xf6eff6c0,0xf7cbf749,0xf90cf86b,
0xfa1af984,0xfc81fb1c,0xfe4efdb6,0xfe05fe69,0xfbf7fd25,0xf863fa60,0xf4d1f672,0xf244f373,
0xf0d8f159,0xf0baf0c2,0xf0baf09f,0xf28bf154,0xf59af415,0xf7aaf6c8,0xf955f873,0xfc27fa7e,
0x00c3fe49,0x05fa036e,0x09740804,0x0b3b0a79,0x0c370bc1,0x0de30cdb,0x10bb0f44,0x13fd1251,
0x175315ab,0x19ab18b6,0x1a921a4e,0x19e31a70,0x17c018ee,0x15281680,0x127b13d4,0x0f1610e6,
0x0b3e0d38,0x06c1091e,0x016f0422,0xfbc0feac,0xf629f8d9,0xf21ef3e7,0xefa7f0b2,0xee0aeee6,
0xea85eca9,0xe47de7b8,0xdd5fe102,0xd735d9fb,0xd2c8d4e6,0xcf75d0fc,0xccd7ce23,0xca4dcb91,
0xc79bc8f9,0xc58cc670,0xc4dbc507,0xc57dc4f3,0xc8acc6b2,0xce71cb4a,0xd5f4d20e,0xde8cda19,
0xe8a5e36b,0xf45cee4d,0x00d9fa9e,0x0ca306e4,0x171a120a,0x1fc91bb6,0x26882368,0x2b7d2944,
0x2e492d2b,0x2e8a2eb6,0x2d722e0b,0x2c212cd7,0x29f32b2f,0x26ec2879,0x23d82557,0x2180228a,
0x1f302071,0x1c761dd2,0x19851b13,0x15b617b7,0x11ac13ad,0x0df90fc3,0x0ae50c69,0x0772093e,
0x03f905a2,0x0172028f,0x0025009f,0xfffcfffd,0x00c0002f,0x0275019a,0x03670308,0x046f03d0,
0x06030533,0x071706bc,0x06870704,0x03e6057d,0x00490210,0xfce4fe95,0xf9e5fb48,0xf7b8f8be,
0xf65ff6e2,0xf5fff620,0xf67af61c,0xf796f706,0xf8b2f81c,0xfabff991,0xfcfffbfc,0xfde4fda9,
0xfd02fda5,0xfa0bfbd8,0xf643f806,0xf356f4ad,0xf1f6f272,0xf164f1a6,0xf166f147,0xf2b5f1dd,
0xf500f3d1,0xf6dbf609,0xf890f7a5,0xfb54f9b5,0x001cfd7c,0x055a02dc,0x0912076b,0x0b3f0a4e,
0x0cf00c19,0x0ec50dd6,0x11130fd9,0x13ec126c,0x16871553,0x1889179f,0x19c81948,0x191c19c4,
0x169317fa,0x137e14fa,0x10c81227,0x0df70f5f,0x0aa30c69,0x069208b2,0x019d0433,0xfbdefeca,
0xf65bf905,0xf215f404,0xef5bf07e,0xedc6ee89,0xeb2decbd,0xe645e8e9,0xe02de351,0xda95dd2d,
0xd680d870,0xd314d4b6,0xcffed193,0xcc2fce30,0xc873ca3a,0xc5bfc6f2,0xc464c4ea,0xc463c425,
0xc743c567,0xcd09c9d4,0xd4e6d0c9,0xdde8d945,0xe815e2d3,0xf384eda3,0xffa7f98b,0x0bbd05bb,
0x16d41171,0x1ff41ba8,0x272923cb,0x2c2429f2,0x2eb32dcb,0x2e552ecc,0x2d2c2dc0,0x2b9e2c7c,
0x28d52a6e,0x251c26f3,0x221e2377,0x202f2119,0x1dcc1f11,0x1b321c7a,0x185419e0,0x14881685,
0x10b41292,0x0d560ef2,0x0a590bdf,0x0683088a,0x02d40491,0x00450163,0xfed0ff70,0xfe28fe57,
0xff02fe5d,0x00cbffe4,0x025d0190,0x052e038b,0x089d06fb,0x0a4f09c1,0x09d50a5c,0x06e20896,
0x038b0529,0x004301f0,0xfd66febc,0xfaeafc20,0xf92ef9ee,0xf820f88f,0xf85ff815,0xf911f8ba,
0xf9e8f96b,0xfbcdfaba,0xfdcdfcec,0xfe04fe30,0xfc08fd48,0xf7c8fa2b,0xf35af568,0xf062f19c,
0xef51efab,0xef2fef2c,0xefd9ef69,0xf132f076,0xf353f233,0xf575f46c,0xf7a1f67e,0xfadef8fe,
0x0010fd57,0x053602c9,0x08cc0733,0x0af50a03,0x0c8a0bc6,0x0dd90d38,0x0ffe0ec3,0x12d11163,
0x158d1437,0x180416d6,0x193718e8,0x17ec18dc,0x14c5167d,0x1172130a,0x0eac0ff6,0x0c680d8d,
0x09a80b17,0x0664081b,0x02210469,0xfcfdff96,0xf816fa77,0xf45bf608,0xf258f31f,0xf161f1e1,
0xef0af089,0xea01ecc4,0xe3dfe6f5,0xde4be0eb,0xda0bdc19,0xd653d822,0xd242d467,0xcd6acfe5,
0xc90acb21,0xc5d5c740,0xc3abc4a0,0xc2ebc30a,0xc542c3a7,0xcb06c7c7,0xd30fcedb,0xdc4bd78f,
0xe68fe144,0xf200ec25,0xfe17f804,0x0a490448,0x15761010,0x1ebe1a58,0x25f222a3,0x2af128b2,
0x2d332c7d,0x2c7b2d19,0x2aee2bb7,0x29152a13,0x262c27cd,0x22ab245a,0x20332144,0x1e961f6a,
0x1c481d86,0x1a021b1f,0x173a18c4,0x13bb1573,0x10b01224,0x0e0e0f4f,0x0b5e0cce,0x07e309ac,
0x04e70642,0x02c703c0,0x00e501e3,0xff5cfffb,0xff79ff2d,0x008cfffd,0x02740145,0x067b0441,
0x0af308d3,0x0d730c88,0x0d050da8,0x09ea0bae,0x06140803,0x01fe040a,0xfea80037,0xfb75fd07,
0xf8fafa20,0xf72af7f3,0xf695f6b1,0xf72bf6c9,0xf830f7ab,0xf9d0f8cd,0xfcbafb46,0xfe45fdc5,
0xfd3efe2d,0xf93efb86,0xf41bf6a8,0xf0b4f217,0xef38efc7,0xeef3eef2,0xef98ef39,0xf03defe8,
0xf1b7f0d9,0xf405f2ca,0xf6b3f54d,0xfa9ff871,0xffd3fd23,0x04f4027b,0x0900072d,0x0b470a59,
0x0c6a0bec,0x0d130cc8,0x0e7d0d9b,0x10ed0f9c,0x13d71265,0x16bc1541,0x182617d7,0x16c217c7,
0x1342152b,0x0f8c1154,0x0d250e1f,0x0b950c62,0x094f0a97,0x067307ea,0x028904aa,0xfdb6002c,
0xf907fb4d,0xf52ff6ee,0xf2d5f3d6,0xf1a4f228,0xf007f107,0xec5cee85,0xe725e9d4,0xe1dde46a,
0xddaddfaf,0xd9b0dbbb,0xd4f5d778,0xcf1ad217,0xc99ecc3c,0xc594c766,0xc2d2c410,0xc1dfc205,
0xc3eec276,0xc9bac65f,0xd23fcdc3,0xdbccd6f4,0xe5f4e0c8,0xf0fbeb57,0xfd0df6e0,0x099a035a,
0x152f0f9c,0x1eab1a2b,0x260022a0,0x2b1028d4,0x2d1c2c8a,0x2c482cdc,0x2ab52b8d,0x287b29b4,
0x251926f8,0x21492318,0x1ef11fe2,0x1d6d1e43,0x1b261c55,0x190b1a13,0x168d17e9,0x13b01519,
0x10f5124d,0x0e580fa7,0x0b400ce8,0x078a0961,0x047f05e3,0x0230034b,0xffe7010d,0xfe15fedb,
0xfd9bfdaf,0xfe23fdc7,0x0028feda,0x04ed0244,0x0a8507cb,0x0e6a0cd2,0x0ed90f12,0x0c9c0df2,
0x09550b11,0x0562075c,0x020903ac,0xfe820040,0xfb82fcea,0xf910fa31,0xf7cff842,0xf7e3f7b0,
0xf8ebf85b,0xfaa4f99c,0xfda3fc0e,0xff7ffedd,0xfe58ff5a,0xfa42fc8e,0xf4a6f785,0xf0c2f256,
0xeeb3ef95,0xee24ee34,0xeec3ee6d,0xef1beef3,0xf030ef74,0xf28ef13f,0xf592f3f2,0xf9ecf79b,
0xff17fc6e,0x043e01be,0x08ae069f,0x0b3d0a3a,0x0c420be0,0x0cbf0c82,0x0d860d07,0x0f4e0e4e,
0x11d71079,0x14c9135f,0x15d915aa,0x142e1551,0x10a6128e,0x0d2f0eca,0x0b4a0c05,0x0a480ac8,
0x08ad0993,0x065c07a0,0x02d804c4,0xfe5a00ac,0xf9e4fc0e,0xf63bf7f1,0xf3e9f4e9,0xf2b6f329,
0xf181f242,0xee74f040,0xe9fcec4b,0xe563e7b0,0xe15be344,0xdd4ddf73,0xd821dadd,0xd1fcd51b,
0xcc1ccee3,0xc760c9a5,0xc3c6c567,0xc239c2a4,0xc3a4c27e,0xc900c5d4,0xd175ccff,0xdb10d637,
0xe4fcdff4,0xefc4ea3b,0xfbb8f597,0x08540209,0x13c10e4b,0x1d4518c5,0x24982137,0x2993276b,
0x2b622aec,0x2ad02b3d,0x29512a2f,0x26e3283f,0x236a253a,0x201121a0,0x1e211ee7,0x1c731d67,
0x1a6c1b65,0x1864197c,0x15d31721,0x135a1492,0x10dc1219,0x0e6d0fab,0x0b660d07,0x080009a9,
0x05390685,0x02d3040e,0x003e0184,0xfe4fff22,0xfd65fdcc,0xfcedfd0a,0xfebcfd63,0x03b800f1,
0x09a006b8,0x0e1f0c30,0x0f3f0f1f,0x0e390ee5,0x0bac0d27,0x081709ec,0x04980656,0x012702d3,
0xfe0eff9c,0xfb57fc92,0xf9d8fa68,0xf98cf998,0xf9fff9b1,0xfb56fa7d,0xfe10fc94,0x0022ff63,
0xff0d0009,0xfb42fd67,0xf5e5f8ad,0xf1a6f380,0xeeddf019,0xedfaee28,0xee57ee20,0xee40ee5b,
0xeedaee56,0xf116efcb,0xf48bf2a9,0xf910f6b3,0xfe1dfb91,0x034900b5,0x07ee05c9,0x0a7e097c,
0x0b2d0afd,0x0b370b3b,0x0b5c0b31,0x0cb60be7,0x0f130dc8,0x115c1050,0x123e121b,0x10a311af,
0x0d950f32,0x0aed0c14,0x09c00a26,0x0963099c,0x08b00917,0x07020800,0x042f05c1,0x00320248,
0xfc0ffe15,0xf88afa36,0xf616f734,0xf48ff52d,0xf388f41a,0xf130f29b,0xed62ef61,0xe91aeb43,
0xe50ee707,0xe0abe301,0xdaf8ddf9,0xd45ad7bd,0xcdedd105,0xc89dcb22,0xc4c5c66e,0xc30ec399,
0xc43fc33c,0xc95fc649,0xd196cd34,0xdb05d63c,0xe4e3dfe1,0xef84ea17,0xfb4bf537,0x07b1018f,
0x13010d94,0x1c3517de,0x234b2000,0x282f261d,0x29bc2969,0x29112985,0x27582857,0x24842613,
0x20a222a3,0x1d281ec2,0x1b281bfe,0x19b31a72,0x184e18f1,0x16cd17a3,0x150c15e7,0x135d143d,
0x1139124e,0x0f231039,0x0c190dcb,0x08b40a54,0x0601074a,0x035b04af,0x008d01f3,0xfe52ff50,
0xfcf5fd96,0xfc18fc67,0xfd91fc68,0x021aff88,0x07e304fa,0x0ceb0aa5,0x0f4d0e74,0x0fbc0fb1,
0x0e6b0f5d,0x0bd10d2c,0x08ae0a53,0x05580700,0x020103aa,0xfef70068,0xfcd4fdbf,0xfbe7fc39,
0xfbe6fbd4,0xfc9dfc1c,0xfec1fd8b,0x0099ffec,0xff59005e,0xfb81fdb3,0xf62df8ea,0xf16cf39d,
0xedf9ef83,0xec98ed08,0xec6eec76,0xec1aec4b,0xec94ec1d,0xef28ed9b,0xf378f122,0xf8a8f5ff,
0xfe4bfb77,0x04170132,0x08c406ba,0x0ae10a16,0x0b160b36,0x0a250aaa,0x093a09a0,0x09a90935,
0x0b620a6b,0x0d890c7a,0x0e460e2b,0x0d250ded,0x0ae60c12,0x08f709ce,0x08750882,0x089e0889,
0x088508a5,0x07720821,0x051c0671,0x01c80381,0xfe3b0007,0xfb00fc86,0xf884f9a7,0xf6d6f78d,
0xf605f661,0xf486f57a,0xf14ef31a,0xed15ef43,0xe888eada,0xe34de609,0xdcf2e036,0xd64dd9a0,
0xcfc3d2fe,0xca0fccc2,0xc5f0c7ba,0xc425c4b3,0xc551c456,0xca0dc732,0xd1d6cdb2,0xdad4d63f,
0xe495df9d,0xef15e9b9,0xfaaef4c3,0x06d300bf,0x11ff0ca5,0x1b3016db,0x22201ee6,0x26ae24ce,
0x27bd2799,0x26fd2775,0x252d263f,0x222823d5,0x1e352035,0x1adc1c5d,0x191219ce,0x17c81868,
0x1697172d,0x155715fe,0x143114b1,0x131e13ba,0x119a125b,0x0ff510e0,0x0d290eb2,0x0a2b0b9e,
0x074108bd,0x042b05bd,0x0123029b,0xfefdffe0,0xfd8bfe45,0xfc5afcd7,0xfd59fc71,0x012cfefd,
0x069403c9,0x0b8b094b,0x0e5a0d29,0x10200f5c,0x10161066,0x0e660f5d,0x0bbe0d2e,0x089f0a34,
0x054e06f5,0x022103af,0xff8900be,0xfe2cfea7,0xfdd1fdf4,0xfe16fdce,0x001cfedf,0x01de0147,
0x007d0197,0xfc7afebb,0xf6f5f9d1,0xf1bbf431,0xedafef7e,0xebbbec74,0xeaf0eb56,0xea0bea79,
0xea4ae9e2,0xed42eb79,0xf1f0ef7c,0xf761f496,0xfd05fa26,0x03050009,0x079705aa,0x098d08d0,
0x09a009cf,0x0875091f,0x077e07d8,0x0806079d,0x099208ac,0x0b5a0a88,0x0bbe0bc7,0x0a430b30,
0x084b0940,0x070f077f,0x077b0712,0x089f0811,0x09570918,0x08fa094e,0x071f0841,0x040c05af,
0x00820244,0xfd31fed3,0xfa98fbc9,0xf909f999,0xf8d0f8d8,0xf7e4f89b,0xf4cef695,0xf069f2c0,
0xeb43ede5,0xe566e878,0xdec8e21f,0xd80fdb71,0xd146d49d,0xcb2ace1f,0xc6e1c8bc,0xc4e9c597,
0xc5b0c4e9,0xc9d6c752,0xd106cd28,0xd9b8d53b,0xe38dde85,0xee49e8c6,0xfa11f40b,0x061a002a,
0x10fc0bc3,0x19ec15bd,0x209d1d82,0x249e2314,0x25722554,0x24dc253a,0x23242427,0x203f21e1,
0x1ca21e72,0x198b1afa,0x17bb187c,0x167e1715,0x153b15e2,0x14011496,0x13451390,0x129a12fb,
0x11d51234,0x107b115b,0x0dd60f40,0x0b090c6d,0x07fe0983,0x04f7067f,0x01fa036a,0x000500dc,
0xfec3ff5f,0xfdabfe1e,0xfe89fdc6,0x01e9fff5,0x06ad0437,0x0ae308fe,0x0da90c5d,0x0fd40edc,
0x1074105b,0x0fe01049,0x0e180f27,0x0b7e0cde,0x081b09df,0x04990656,0x015202de,0xff7a002f,
0xfeb1feff,0xfecbfe99,0x0085ff75,0x024801a7,0x013c021b,0xfdbfffc9,0xf8a7fb4d,0xf336f5e0,
0xeebaf0c4,0xec48ed46,0xeaa8eb79,0xe915e9d1,0xe8f8e8b3,0xebdeea16,0xf064ee0a,0xf5d0f300,
0xfb9bf8ab,0x01b2feb1,0x06220439,0x0845077a,0x08410884,0x070407b3,0x05d60658,0x05b005a6,
0x067f05f1,0x07960720,0x080007ea,0x074107be,0x063906bb,0x05c705d8,0x06c40618,0x08650792,
0x098c0913,0x098109b6,0x08350906,0x05cd0718,0x02e6045f,0xffc90165,0xfcbefe2f,0xfad1fb89,
0xfab8fa9f,0xfa5dfabf,0xf7ddf963,0xf37bf5dc,0xede6f0ca,0xe77fead0,0xe07be3f6,0xd9a1dd15,
0xd299d61a,0xcc53cf4c,0xc7f2c9d3,0xc61fc6ba,0xc6f1c630,0xcab8c862,0xd192cdd4,0xda3dd5c5,
0xe3dfdef9,0xee53e8fd,0xf98ff3dc,0x04fbff57,0x0fc20a7f,0x18af1489,0x1f431c44,0x22c02177,
0x233c233a,0x22ae2310,0x21102204,0x1e8c1feb,0x1b391ce5,0x184719a7,0x1684173f,0x154115e3,
0x13c11481,0x12841319,0x1208122b,0x11c611e8,0x118e11a7,0x10b81152,0x0e860fbf,0x0bd10d33,
0x08d80a5b,0x05ad074c,0x02910408,0x00ea0187,0x00250086,0xff87ffbf,0x0086ffbf,0x032b01af,
0x06f204fa,0x0a2c08c8,0x0bff0b26,0x0da00cdd,0x0e5c0e1e,0x0e850e77,0x0e180e6e,0x0cd50d8f,
0x0a7a0bc9,0x075d0908,0x044305b1,0x02490324,0x0117019e,0x00b400bc,0x01d20110,0x030902ac,
0x01fc02c4,0xfee700ac,0xfa51fcc4,0xf4eaf7a5,0xf028f257,0xed48ee82,0xeb3cec41,0xe929ea23,
0xe8c7e8a3,0xeb59e9b7,0xefbeed62,0xf53ff25d,0xfb33f833,0x00cbfe2f,0x04a202f2,0x066f05ca,
0x05ea0678,0x04410515,0x03090390,0x026302a6,0x02db0272,0x03a50340,0x044d0412,0x04560466,
0x03ea041f,0x040103cf,0x0562048e,0x07540650,0x09350857,0x0a0909c8,0x097d09f7,0x07aa08b2,
0x05490682,0x027603fa,0xff4a00db,0xfd19fdf7,0xfc9ffcbc,0xfc07fc7d,0xf989fb0a,0xf51ff784,
0xef5bf261,0xe895ec19,0xe18ee500,0xdadcde2a,0xd459d798,0xcea9d15b,0xcafbcc80,0xc961c9f2,
0xc9e8c95e,0xcd0ecb19,0xd32ecfc8,0xdb62d71a,0xe4cbdffe,0xeec7e9ae,0xf95af407,0x0426febe,
0x0eb6098d,0x176b1352,0x1da81aed,0x20671f7e,0x20df20bb,0x205f20c4,0x1ee41fbc,0x1c6d1dcd,
0x19661aec,0x16db17f7,0x156d1611,0x144914d7,0x131b13b8,0x12211291,0x119d11d9,0x114d1168,
0x116a1154,0x10ca114e,0x0eca0feb,0x0c0a0d76,0x09020a8d,0x05c00771,0x02a1040f,0x00e4019a,
0xffc8004e,0xff48ff61,0x005cff9f,0x02bb016e,0x060d0453,0x08b0078d,0x0a75099c,0x0bc00b34,
0x0ca80c37,0x0d5f0d06,0x0e320dc7,0x0e9e0e87,0x0da70e56,0x0b4d0c98,0x089909f1,0x06640769,
0x04a8057d,0x03a303fe,0x040e03ae,0x04750474,0x032903f9,0x005e01f7,0xfc4cfe83,0xf6edf9aa,
0xf24af470,0xef0ef087,0xec39eda6,0xe9bfead2,0xe92ce924,0xeb67e9ee,0xef9aed5d,0xf4acf20b,
0xf9e1f756,0xfe5cfc42,0x018e0018,0x031b02a0,0x027202fa,0x010801c0,0xff65003f,0xfe67febd,
0xfe57fe3f,0xfebdfe9c,0xff53fef5,0xffe2ffa1,0x0067001e,0x019e00df,0x03b50298,0x065c04f1,
0x092807d8,0x0ac50a27,0x0adc0afb,0x09c80a73,0x07d408e9,0x04e60677,0x01b00337,0xffbe0082,
0xff33ff64,0xfe8afefe,0xfc1dfd9d,0xf7edfa33,0xf248f548,0xeb73eef8,0xe446e7d1,0xdd83e0d7,
0xd715da49,0xd174d412,0xcddecf61,0xcc07cccd,0xcc04cbba,0xce9acce6,0xd463d129,0xdc59d82f,
0xe53ee0bb,0xeecfe9e9,0xf8f2f3d1,0x03b3fe3f,0x0e17090f,0x1687129b,0x1c0919c2,0x1dd81d50,
0x1e031dfa,0x1d681dd7,0x1bfa1ccd,0x19671ac9,0x167a17e8,0x1485154f,0x135513e8,0x128212d9,
0x11b51225,0x10df1142,0x104e1096,0x100d1019,0x10891047,0x102c108a,0x0e490f66,0x0b6f0cef,
0x084b09e3,0x04ed069b,0x02210359,0x00c10151,0xffe00047,0xffebffb4,0x01960098,0x043202dc,
0x070e059c,0x09030839,0x0a2d099a,0x0ad50a9c,0x0b320af3,0x0bff0b95,0x0d660c9c,0x0edd0e37,
0x0f080f24,0x0e090ea8,0x0c050d19,0x09ea0af1,0x082308f9,0x06a60758,0x06500641,0x0685068a,
0x05640621,0x02dc044b,0xfef70124,0xf93ffc2e,0xf47af6a9,0xf0c7f294,0xed27eef8,0xea4aeb88,
0xe93ae97d,0xeb20e9c8,0xef62ed0e,0xf422f1ce,0xf847f646,0xfc0efa40,0xfedafd91,0xffe7ffac,
0xff2effb6,0xfd45fe5b,0xfaf6fc10,0xf99afa16,0xf986f97b,0xf9f6f9a8,0xfb2bfa7e,0xfcadfbf7,
0xfdf8fd55,0xff77fea6,0x01980078,0x04e40306,0x08bc06e8,0x0b020a1d,0x0ba80b7c,0x0b330b90,
0x09710a79,0x06cb0835,0x03d20543,0x01cb02a5,0x01320155,0x00de0125,0xfea50010,0xfa53fcb3,
0xf457f78b,0xed3ef0dc,0xe5f9e98b,0xdf7ee29f,0xd972dc6e,0xd451d6a8,0xd11bd273,0xcf79d025,
0xcf77cf35,0xd230d064,0xd7f6d4bf,0xdf91dba4,0xe7bce3a2,0xf033ebe2,0xf97df4ba,0x03a0fe82,
0x0d7908b3,0x150f119b,0x196217b4,0x1a701a30,0x1a781a7b,0x19d61a48,0x18541931,0x15dd172f,
0x135d1485,0x12081295,0x110c1187,0x107510ae,0x0fbb1028,0x0ec80f37,0x0e2d0e73,0x0e3a0e0d,
0x0f370eb3,0x0f3b0f77,0x0daf0e9c,0x0b0d0c7d,0x07a6096a,0x041c05d4,0x01a202a9,0x007300ef,
0xffef0018,0x00c70024,0x02fc01c7,0x05aa044b,0x0878071f,0x0a310984,0x0b070aa4,0x0b040b29,
0x0aa90ac7,0x0ae10aaa,0x0c380b6c,0x0dfc0d19,0x0f770ec9,0x10570ffb,0x10c210a2,0x103e10a1,
0x0eed0fad,0x0d250e02,0x0c2f0c8a,0x0ade0bbb,0x07c6098e,0x035305a1,0xfe0400d7,0xf810faff,
0xf358f581,0xefacf177,0xec06edcf,0xe94eea78,0xe8b4e8af,0xeae5e978,0xeecdecd3,0xf243f0a7,
0xf54cf3c1,0xf821f6d4,0xf9eaf924,0xfa8cfa6d,0xf99ffa40,0xf7baf8be,0xf5d3f6b9,0xf522f541,
0xf5a3f54d,0xf6d9f624,0xf8a3f7b5,0xfa7ef989,0xfc83fb82,0xfecbfd97,0x01d0002e,0x05fb03c5,
0x0a1b0834,0x0ca90b8d,0x0dc70d6a,0x0d660dcb,0x0bb70ca7,0x09720a9c,0x07580857,0x06200697,
0x059605d0,0x04450536,0x008002ad,0xfafffde7,0xf48cf7dd,0xed79f114,0xe680e9e0,0xe06de360,
0xdacadd92,0xd652d84f,0xd3b7d4de,0xd217d2b8,0xd263d1ec,0xd5acd3a0,0xdbccd87b,0xe2f4df5b,
0xea1ee687,0xf1a1edc6,0xfa4ff5ce,0x03d6feff,0x0cb2088b,0x12d41028,0x159114a7,0x15fb15da,
0x1646162f,0x15bf161e,0x140b1511,0x11d112e4,0x104b10ed,0x0f940fec,0x0efd0f36,0x0ec90ee8,
0x0dfe0e7f,0x0cf70d72,0x0c450c8c,0x0cbc0c49,0x0de70d69,0x0df10e0b,0x0cf90d97,0x0ae40c14,
0x07b10965,0x04980600,0x02bf0387,0x01500203,0x00c900d4,0x01ff0136,0x04570313,0x072705b5,
0x099d0886,0x0b3b0a7b,0x0c2e0bd7,0x0bec0c2e,0x0b390b98,0x0ad80ae9,0x0b900b21,0x0c9c0c09,
0x0e260d57,0x0fb80ef0,0x112c107a,0x11fa11af,0x11cc120a,0x109a1146,0x0f610ffa,0x0da70ea7,
0x0a390c2c,0x05a60800,0xff8902d5,0xf96efc3c,0xf522f726,0xf154f33d,0xed93ef68,0xeab5ebfa,
0xe9dde9ed,0xebe6ea93,0xef15ed89,0xf14ef04d,0xf35ff246,0xf57ff47f,0xf714f667,0xf779f773,
0xf603f6fe,0xf372f4c1,0xf0e1f20b,0xf016f041,0xf0daf04d,0xf2e1f1b2,0xf5c4f452,0xf8bbf738,
0xfb87fa33,0xfe19fcd1,0x015aff8a,0x06050396,0x0a68085f,0x0d430c07,0x0eab0e24,0x0e570ec2,
0x0c7e0d91,0x09e70b33,0x07c808be,0x069b0714,0x06000645,0x04b00595,0x01050324,0xfbbefe87,
0xf595f8b9,0xef0ef261,0xe8a4ebc9,0xe2a3e59b,0xdcd5dfa4,0xd880da6e,0xd5b3d6f6,0xd3fdd4a2,
0xd44ed3d3,0xd7ced597,0xde27dabd,0xe549e1c0,0xebd2e894,0xf2d3ef37,0xfaf8f6c0,0x0418ff79,
0x0c31086d,0x117b0f3b,0x136f12d3,0x13d713a6,0x145b1424,0x1429145f,0x12d213a1,0x112511f5,
0x100d1080,0x0f4c0fb0,0x0eb50eef,0x0e4e0e8f,0x0d330dd8,0x0bf00c8e,0x0b1c0b64,0x0bb20b36,
0x0c7b0c36,0x0c6d0c85,0x0bbe0c34,0x0a0b0b0c,0x074808ba,0x049c05d6,0x02de03a7,0x01780225,
0x00fe00ff,0x0253017f,0x04900362,0x073405d2,0x09a10888,0x0b3f0a87,0x0bdb0bb8,0x0b190b9b,
0x09fb0a8c,0x093e0982,0x094c0933,0x09ab0974,0x0ad30a1a,0x0cd30bc0,0x0f4c0e0b,0x11a01082,
0x136a12a3,0x13b613bf,0x13421388,0x11fa12c7,0x0ef810b6,0x0a580cd8,0x03f20758,0xfd5c007c,
0xf840fab0,0xf3bdf5f1,0xefcaf1aa,0xed0dee36,0xec3dec59,0xee17ecee,0xf049ef52,0xf16df0ed,
0xf266f1ef,0xf320f2be,0xf441f3b1,0xf429f47a,0xf1edf340,0xeea2f060,0xeb88ecf0,0xea13ea8d,
0xeab0ea22,0xed42ebba,0xf12def17,0xf5a3f36f,0xf986f7aa,0xfcdafb3c,0x00bcfe9e,0x05cb0334,
0x0a97084c,0x0e160c87,0x0fdd0f3c,0x0f7f0fe8,0x0d8d0eb4,0x0ac10c33,0x086f097a,0x071d07a4,
0x06c006d9,0x05f1068c,0x02dc04af,0xfdb9007f,0xf767faa0,0xf123f43c,0xeb04ee11,0xe530e816,
0xdfbbe255,0xdb8cdd74,0xd8a5d9f4,0xd70ed7a2,0xd7a1d70a,0xdb11d8f5,0xe14bddec,0xe81de4c9,
0xedf5eb1e,0xf411f0e5,0xfb6ff78b,0x03c9ff98,0x0ae507a3,0x0f1d0d71,0x102b0fee,0x10a11056,
0x11681107,0x11631196,0x103410de,0x0f1c0f93,0x0e7c0ec7,0x0db90e1c,0x0d460d71,0x0cb10d11,
0x0b720c27,0x0a080ab6,0x095b0985,0x09ec098d,0x0a430a2a,0x0a4d0a4e,0x09fb0a39,0x08ec098c,
0x07200817,0x055d0632,0x03ab0489,0x024c02d6,0x02ce024c,0x04ae03a4,0x071005d1,0x09700854,
0x0b410a5c,0x0ca90c15,0x0c8c0cd4,0x0b250bf0,0x09970a4e,0x088c0901,0x07de0831,0x07b807ad,
0x086107f7,0x0a05090f,0x0c990b38,0x0fc10e1f,0x12db1167,0x148013f3,0x149914a6,0x13b41451,
0x113f12b2,0x0cf20f51,0x06f30a19,0x00eb03d0,0xfbe3fe4d,0xf77af99f,0xf3f4f58c,0xf19cf2a6,
0xf0d3f0ee,0xf1d6f13b,0xf278f252,0xf241f267,0xf17ff1f3,0xf16df14a,0xf1faf1bb,0xf159f1e9,
0xee9ef042,0xea94eca3,0xe6dde894,0xe4fae5a2,0xe556e4e2,0xe80ce667,0xecc4ea37,0xf204ef6b,
0xf6adf473,0xfab8f8b6,0xff7bfcf6,0x04f00233,0x09eb0791,0x0d6f0be2,0x0f2a0e88,0x0f070f51,
0x0d4e0e5a,0x0a9e0c00,0x08510959,0x06fb0780,0x06d806d3,0x066a06ce,0x03be0563,0xfee30192,
0xf8ddfbe4,0xf35ff60d,0xee16f0b1,0xe8c3eb77,0xe380e60d,0xdf40e138,0xdc47dda4,0xdb05db60,
0xdbf2db35,0xdf6fdd4c,0xe572e243,0xebc5e8aa,0xf13feeaa,0xf653f3b3,0xfc71f93d,0x0341ffd8,
0x092e066d,0x0c640b3e,0x0cd60ccb,0x0d500cf8,0x0e390dc2,0x0e910e8d,0x0e0f0e57,0x0da20dce,
0x0d4b0d82,0x0c7c0ce5,0x0bd40c28,0x0af30b73,0x09b60a5a,0x08630908,0x07de07f3,0x085d0816,
0x089f088a,0x08bb08b3,0x089408b3,0x07f8085a,0x06ae0760,0x058c0614,0x043904f8,0x031c0380,
0x03e0033c,0x05ff04db,0x08730737,0x0a9d099d,0x0c7c0b8b,0x0de70d5b,0x0d710ded,0x0bcf0ca9,
0x0a160af2,0x08b80956,0x07bb0835,0x072f075f,0x077a0735,0x08d007ff,0x0b2d09e1,0x0e870cb6,
0x1231106b,0x14f113b2,0x17091610,0x17441790,0x142d160d,0x0ecd11d0,0x077b0b35,0x01150411,
0xfbcafe55,0xf778f97b,0xf4abf5e1,0xf309f3bb,0xf2ddf2bd,0xf387f334,0xf37bf3a2,0xf29ef328,
0xf155f1e9,0xf103f10e,0xf055f0df,0xee11ef62,0xea39ec4f,0xe5ace7fe,0xe218e397,0xe0d0e12b,
0xe1e7e111,0xe569e354,0xeaa4e7f4,0xf016ed67,0xf537f2b0,0xfa3cf7b1,0xfffffcfd,0x05ed030a,
0x0aa4087a,0x0dca0c61,0x0f7c0ed7,0x0f520fa3,0x0d620e8b,0x0aac0c02,0x08b1098c,0x083b083d,
0x08e5088c,0x082308df,0x049306ae,0xfeeb01ee,0xf91afbe0,0xf42df693,0xef87f1db,0xea75ed0f,
0xe564e7d9,0xe126e320,0xde56df89,0xdd9addb0,0xdecdddf6,0xe28de054,0xe81be53a,0xedbaeafe,
0xf27ef036,0xf723f4bb,0xfd02f9e3,0x03610042,0x0858062e,0x0a7509c5,0x0ae20ab8,0x0b7d0b1f,
0x0c620bf8,0x0c8e0c97,0x0c3a0c5f,0x0c5f0c3b,0x0c750c80,0x0bd10c31,0x0b230b73,0x0a170ab6,
0x08ad0963,0x077a0807,0x072a0730,0x07350740,0x06c80702,0x065f068d,0x06070633,0x058805d8,
0x04d80524,0x049604b8,0x03fb0451,0x03d603b8,0x05760476,0x07ed06ac,0x0a6e0934,0x0c550b74,
0x0e3b0d35,0x0f6d0f13,0x0eb00f3c,0x0cfc0de8,0x0b1c0c0d,0x092d0a1f,0x07490836,0x0611068e,
0x05e105d2,0x06f4064b,0x08ab07b9,0x0b9309f0,0x0f710d84,0x127a1113,0x15cd140d,0x17b91729,
0x16321768,0x1122140c,0x0a060dad,0x037d0695,0xfdfe00a6,0xf9a1fb9b,0xf70af81c,0xf5a9f641,
0xf520f548,0xf4f6f50d,0xf449f4be,0xf2d4f3aa,0xf159f1f7,0xf104f11e,0xf018f0bb,0xed5feefd,
0xe8f8eb4d,0xe413e682,0xe017e1de,0xde27ded5,0xdf1dde3d,0xe2ebe0b1,0xe86ce596,0xee39eb54,
0xf38df0f1,0xf8fbf632,0xff37fbff,0x054f025d,0x0a0d07f0,0x0cd80baa,0x0e2f0dad,0x0e020e57,
0x0bf90d2c,0x09060a7b,0x06c807c0,0x0649064e,0x0713069c,0x06ca0743,0x03ad0591,0xfe76013c,
0xf96dfbc3,0xf582f765,0xf19bf39b,0xed58ef7f,0xe91deb33,0xe537e713,0xe2b1e3bd,0xe244e230,
0xe3d9e2ce,0xe7b3e585,0xecd7ea35,0xf1e0ef7a,0xf5eff3fa,0xf9c7f7d4,0xfe9dfc12,0x03540119,
0x064f051e,0x075506fb,0x081007ab,0x0907088a,0x097f0965,0x099a0983,0x0a0b09ba,0x0ad30a7c,
0x0b0f0b00,0x0ab90af8,0x09b10a4a,0x084208ff,0x06d30787,0x05e2063c,0x05c305c9,0x056905a4,
0x04cf0524,0x0446047f,0x0407041f,0x03f803f5,0x0451041d,0x04670472,0x04360442,0x05260478,
0x0741061d,0x0961085a,0x0aea0a47,0x0c120b69,0x0e0c0d0e,0x0f050eb8,0x0e9e0f02,0x0d1f0de2,
0x0b920c6b,0x09670a83,0x07640858,0x05fb069a,0x05660591,0x05b20573,0x07120635,0x0a0d085b,
0x0d8d0be5,0x10800ef3,0x14e81292,0x18b61717,0x18d0195d,0x14d41733,0x0e7811d8,0x07c80b16,
0x01ce04a2,0xfd4aff56,0xfab5fbc5,0xf904f9dd,0xf7a2f838,0xf68af71f,0xf4caf5ce,0xf24ff391,
0xf0daf157,0xf01ef082,0xeea7ef98,0xeb04ed23,0xe593e871,0xdfeee2af,0xdb6cdd6c,0xd948da03,
0xda96d971,0xdf0ddc80,0xe53ee20e,0xeba8e87e,0xf185eea0,0xf7a9f47e,0xfea6fb15,0x0578022a,
0x0a6c0846,0x0d4e0c0b,0x0edf0e47,0x0e830ef1,0x0c560da3,0x09010aad,0x067d0792,0x05e005e3,
0x0705065e,0x06ef0756,0x03c205b5,0xfec1015b,0xfa4efc4e,0xf6f6f89c,0xf39af550,0xeff8f1d4,
0xec33ee12,0xe8c7ea64,0xe6a5e77e,0xe685e656,0xe83ae72a,0xeba5e9bb,0xf035ede3,0xf47ef26e,
0xf82df669,0xfbb3f9e8,0xffa7fd9e,0x02ec0183,0x044803d2,0x04dd0494,0x05c5053e,0x06900642,
0x06ad06a8,0x071606cd,0x0845079d,0x095108dc,0x0a0c09b8,0x09de0a21,0x08a2095c,0x06f607cb,
0x0590062e,0x04d4051f,0x044f0499,0x03ae0407,0x02c00339,0x021d0260,0x01cc01e6,0x024c01ec,
0x032202c4,0x03870365,0x047603d1,0x0694056d,0x090807da,0x0afa0a15,0x0c310bab,0x0dac0cca,
0x0f900eb1,0x1065101f,0x0fda1053,0x0e5a0f20,0x0c4e0d78,0x09e20b11,0x07a908bb,0x062006c0,
0x057e05bd,0x05800566,0x06a905e2,0x093007d7,0x0b8f0a71,0x0e420cbc,0x12a61046,0x16f61501,
0x1861182a,0x162f17a5,0x110f13f0,0x0ae40dea,0x055d080c,0x013b0309,0xfeb7ffe2,0xfc64fd90,
0xf9fcfb28,0xf7cef8e7,0xf4c0f66d,0xf19ff30b,0xefdbf097,0xeeabef41,0xecdaedf9,0xe8ceeb18,
0xe334e618,0xddade069,0xd905db22,0xd6a6d770,0xd805d6dc,0xdc51d9e0,0xe28ddf4c,0xe935e5e9,
0xefa3ec70,0xf651f2ec,0xfd90f9de,0x04a7013c,0x09da0793,0x0d1b0b9f,0x0ecf0e3d,0x0e620edd,
0x0c0d0d6e,0x08a50a51,0x06160735,0x057f0580,0x068d05f9,0x066506d1,0x03940538,0xff7901a0,
0xfbedfd86,0xf91dfa7d,0xf64ff7bb,0xf320f4c9,0xefaaf165,0xecbfee1a,0xeb0febaf,0xeb28eae1,
0xecdaebdb,0xefc5ee25,0xf384f19e,0xf721f558,0xfa59f8ce,0xfd1ffbc3,0xff74fe6b,0x0096002d,
0x00dc00be,0x01970125,0x02f5023b,0x03e00384,0x04a40436,0x05da052c,0x075306a2,0x087a07f0,
0x091908eb,0x085808e1,0x06870786,0x049f0585,0x036603ed,0x027d02f5,0x01c8020e,0x0174019e,
0x01350149,0x01320131,0x015f0131,0x026101d4,0x032502d5,0x03f30377,0x063204dc,0x093e07bc,
0x0b8e0a86,0x0d1b0c6b,0x0e400da3,0x10000f16,0x116310c6,0x120b11e1,0x111d11c0,0x0f5c105a,
0x0cc00e1f,0x09df0b56,0x073d086e,0x057f064a,0x043004c7,0x03e203e2,0x04a30421,0x061f055c,
0x07bc06e1,0x09ba08ad,0x0d840b45,0x1284101f,0x15ad146a,0x16561656,0x13b41573,0x0f171182,
0x0a7b0ca8,0x071508ac,0x0429059d,0x010102a5,0xfd57ff38,0xf9a5fb7d,0xf5e4f7c2,0xf29df433,
0xefccf11a,0xedc4eebb,0xeb7aecbe,0xe7c7e9d5,0xe307e575,0xdddce076,0xd8f4db45,0xd62fd730,
0xd6d0d61b,0xda8bd84e,0xe091dd5e,0xe74fe3ea,0xee09eab0,0xf4c8f15f,0xfbc6f842,0x0298ff45,
0x07f9058e,0x0b8809f6,0x0d160c93,0x0c4c0cfe,0x09940b1d,0x061407da,0x0332047b,0x02470279,
0x02ed027d,0x0329033a,0x01be02aa,0xff490096,0xfcd0fdf8,0xfaf1fbd1,0xf947fa20,0xf745f856,
0xf510f626,0xf320f40d,0xf1f8f267,0xf21bf1ea,0xf31df27f,0xf51bf3fb,0xf7fff675,0xfb14f998,
0xfd8cfc65,0xff25fe7d,0xff4cff6c,0xfe5ffed7,0xfe22fe19,0xff48fe92,0x00bf0014,0x019e012f,
0x02d7022c,0x04a803b6,0x06460583,0x078e06f7,0x07f107e5,0x06d00795,0x04af05c4,0x030803c5,
0x01f9027b,0x00c40160,0x0002004d,0xffd0ffdd,0xffffffe5,0xfff40000,0x00510007,0x013000c3,
0x01bf0174,0x034e024f,0x069d04c9,0x0a22087e,0x0c730b74,0x0db20d24,0x0f370e64,0x10bb1007,
0x12191171,0x1298128b,0x11b31247,0x0f9f10d3,0x0cce0e3b,0x09d30b58,0x07110856,0x05110600,
0x038b043a,0x02f6031a,0x03790320,0x046203e8,0x05e5050d,0x07c406b9,0x0b9d0964,0x10a10e1e,
0x14a212df,0x160415b3,0x148a15a8,0x113312f4,0x0df20f7b,0x0b3c0c8a,0x088609fa,0x04ca06c6,
0x003c0293,0xfbc4fdf1,0xf7c7f9b7,0xf3ecf5de,0xf05ff1ff,0xedadef00,0xeafdec5c,0xe778e958,
0xe2ffe55c,0xddb6e067,0xd8c0db0c,0xd614d713,0xd694d5e7,0xda1bd7ff,0xdfc1dcc6,0xe5fbe2e2,
0xec21e910,0xf260ef30,0xf923f5b1,0xffb1fc8a,0x0548029c,0x09250786,0x0a720a1a,0x09600a28,
0x06d10838,0x03a10543,0x0139023b,0x006d00a0,0x00e50090,0x01770147,0x00ab0141,0xfed1ffd4,
0xfcbdfdb7,0xfb8afc07,0xfae4fb2c,0xf9e9fa78,0xf8c2f951,0xf7fff854,0xf7edf7d4,0xf855f81c,
0xf919f8af,0xfa11f986,0xfc08fae7,0xfe6ffd3a,0x0053ff7f,0x00bd00d3,0xff03000b,0xfd6dfe0e,
0xfd89fd4b,0xfee7fe2b,0xffc5ff6c,0x00e90042,0x02db01c3,0x04a203db,0x06030555,0x06d80690,
0x068d06dc,0x04e505df,0x02cd03cc,0x017f0214,0x001e00e3,0xfeb0ff50,0xfe0ffe47,0xfe67fe1e,
0xfef9fec0,0xff5bff1e,0x0009ffbe,0x000d0020,0x00820012,0x02ed017f,0x069804ac,0x09ea0867,
0x0bd00b0a,0x0d6a0c89,0x0f530e66,0x11201036,0x129411f7,0x133812ff,0x12471307,0x0fc51126,
0x0cad0e44,0x09360aed,0x067d07b4,0x048a0574,0x033f03cd,0x02ba02ec,0x027d029a,0x02b80278,
0x03fc0338,0x064f0513,0x098007aa,0x0f080c10,0x143511df,0x166315ac,0x164916af,0x13e6152a,
0x11f112d1,0x1054112e,0x0d7d0f26,0x08ec0b5b,0x035b0648,0xfdc60069,0xf9b5fba4,0xf5bdf7bb,
0xf1b8f3b0,0xee3eeff1,0xeb4cecb4,0xe80ee9ca,0xe36ae5f1,0xdda1e08b,0xd86cdae0,0xd592d6a2,
0xd5d3d542,0xd8f6d71e,0xde12db4d,0xe3ebe102,0xe96ae6ba,0xeedfec1b,0xf4aaf1c1,0xfab9f79d,
0x00ddfdee,0x04ca0329,0x064105cf,0x059d0627,0x038404aa,0x01250255,0xff80002b,0xfea1fef3,
0xff02fead,0x0047ffa5,0x00ae00ac,0xffa3004c,0xfdfdfecb,0xfd77fd93,0xfd87fd7a,0xfd97fd93,
0xfd97fd95,0xfe0ffdc3,0xfefdfe86,0xff9aff59,0xffcdffc8,0xffceffbd,0x00d00026,0x028101ad,
0x02f90309,0x00d20230,0xfde2ff38,0xfc54fce9,0xfcb3fc4b,0xfd76fd1c,0xfe7cfddc,0x0096ff71,
0x02a601b3,0x042b0368,0x056804e9,0x05580590,0x042104db,0x02300334,0x006f013b,0xff0bffc3,
0xfd59fe31,0xfc17fca6,0xfbadfbbd,0xfc53fbe5,0xfd5bfcd0,0xfe60fded,0xfe5afe86,0xfe20fe1d,
0xff63fe8e,0x02120094,0x055003b1,0x081706cb,0x0a91094b,0x0d280be6,0x0fa30e62,0x11f410e3,
0x13f412ee,0x152914d5,0x13e314c3,0x114112b8,0x0dd30f97,0x0a530c04,0x07b308e1,0x05eb06b6,
0x04bb0541,0x03c70446,0x02f90356,0x02d402c2,0x045a0364,0x06740571,0x09a907b3,0x0eed0c42,
0x129e111a,0x1411138f,0x13b21421,0x125412ee,0x12171215,0x11a21210,0x0f001091,0x0acc0d0c,
0x04e9080f,0xff9701f4,0xfb81fd95,0xf6b9f92d,0xf1d2f43f,0xedf5efaf,0xeb4dec8f,0xe849e9f0,
0xe39ee62b,0xde29e0e0,0xd972db9e,0xd6d0d7cf,0xd6f7d688,0xd98fd7ff,0xddfedb9b,0xe2e5e073,
0xe7d9e55a,0xed08ea69,0xf284efb2,0xf8ecf5a2,0xfeeffc24,0x0282010b,0x03e30376,0x032503c5,
0x01260233,0xff440026,0xfde9fe8a,0xfd09fd5f,0xfd73fd07,0xfef2fe30,0xff2aff4d,0xfe5afec7,
0xfd89fdeb,0xfde9fd8e,0xfecffe58,0x0019ff66,0x017b00ce,0x0304023c,0x045803bd,0x04e104bb,
0x049104d3,0x04290448,0x04b80452,0x05500524,0x040b0505,0x009f026f,0xfd81fee5,0xfc42fca0,
0xfc77fc48,0xfd29fcb7,0xfeddfddd,0x01590016,0x0360026f,0x04e6043c,0x05420542,0x046504ea,
0x02e703b8,0x01570219,0xffe500a8,0xfe12ff06,0xfc42fd1d,0xfac0fb70,0xfa23fa4e,0xfa66fa2d,
0xfb51face,0xfc00fbca,0xfbaffbed,0xfbf9fb9b,0xfdd4fcca,0x005dff06,0x033201c3,0x064504b5,
0x09bb07ee,0x0d1d0b77,0x103e0eb7,0x12c71199,0x14f213ec,0x1591158a,0x144c1521,0x1198131a,
0x0e260fe6,0x0aab0c5f,0x07fe0931,0x063106ff,0x04cc057e,0x03430409,0x01b10275,0x0131012c,
0x029101b9,0x04d90397,0x081c0661,0x0c6a0a1e,0x10f00ec5,0x13f312b5,0x156314c6,0x15bf15ae,
0x165615f1,0x163b1694,0x13d91541,0x0f991209,0x09350c89,0x02cf05df,0xfd7c0013,0xf800facc,
0xf270f534,0xedf0eff4,0xeaf7ec50,0xe82ce9ae,0xe3efe644,0xdeb6e155,0xda4cdc58,0xd790d8a6,
0xd728d70c,0xd94bd7f0,0xdd20db0f,0xe1e6df6f,0xe6dfe468,0xeb4fe933,0xefbaed60,0xf565f271,
0xfae7f84d,0xfe93fd07,0xffe7ff84,0xff41ffc8,0xfdabfe80,0xfc3bfce7,0xfac8fb87,0xf983fa13,
0xf999f94f,0xfb59fa51,0xfd38fc64,0xfe0afdbe,0xfe4cfe33,0xfeeffe76,0x00b5ffb7,0x033a01e7,
0x05de0494,0x0815070b,0x09a908f7,0x0a240a16,0x09b409f7,0x0912095e,0x08c108d9,0x08220898,
0x05ac072e,0x01f303d1,0xfebf003b,0xfd74fdcf,0xfd87fd62,0xfeb7fe00,0x00d8ffa7,0x02e501f6,
0x046b03af,0x05430505,0x04bd052e,0x031103ff,0x012b0217,0xffb10066,0xfda3fece,0xfb0afc42,
0xf92efa0b,0xf7e9f874,0xf727f777,0xf767f712,0xf8b9f80f,0xf93af91c,0xf98bf948,0xfb1efa27,
0xfd89fc4f,0x0003fec4,0x02890148,0x0602040e,0x0a72083f,0x0e9c0c88,0x123a1094,0x14dd1398,
0x168615e5,0x16b516ca,0x154d163d,0x124113ea,0x0ec21083,0x0b6e0d07,0x08c50a05,0x06e707c2,
0x05330614,0x03550447,0x018a025b,0x012d0122,0x0221018a,0x043a0306,0x06f7058b,0x0aa108a1,
0x0ebf0cc7,0x11861057,0x135d127e,0x14dc1431,0x15c6156b,0x154015b8,0x1366147f,0x0fb211d0,
0x0a540d30,0x04970760,0xff6801fd,0xf9b7fca5,0xf3bbf6ac,0xeef0f120,0xeb8eed1d,0xe84dea05,
0xe417e656,0xdf46e1a7,0xdb85dd30,0xd947da39,0xd945d8ed,0xdb9eda37,0xdf25dd4a,0xe351e12c,
0xe74fe564,0xea85e8f8,0xee51ec40,0xf303f097,0xf7a2f570,0xfac5f96d,0xfbfffba4,0xfbc2fc01,
0xfae9fb57,0xf9eefa73,0xf8b7f954,0xf7e9f834,0xf862f7e8,0xfa78f94b,0xfc8efb9f,0xfd87fd29,
0xfe16fdd5,0xff1efe73,0x01a0003c,0x0516033f,0x08d10705,0x0bc10a5d,0x0dd50cfd,0x0e890e4f,
0x0e6e0e8b,0x0df20e43,0x0cf20d79,0x0adf0c30,0x06cb08f8,0x028a049e,0xff4700af,0xfd98fe3e,
0xfd9dfd5d,0xff19fe38,0x01390034,0x025e01e6,0x036302e7,0x03a103ac,0x02bb0346,0x014c0212,
0xfff50089,0xfedeff7d,0xfc72fdd6,0xf9e6fb15,0xf81cf8e9,0xf6dbf774,0xf5f0f64d,0xf698f60c,
0xf799f734,0xf7baf7b1,0xf8f4f821,0xfb71fa1c,0xfdeffcc2,0xffc3fef4,0x01ae008c,0x056a035d,
0x09cd0797,0x0e750c23,0x12311078,0x14fb13bd,0x161715b9,0x16131633,0x14ad1596,0x11ea135e,
0x0edd106c,0x0bed0d53,0x095d0a9d,0x07390847,0x04d50607,0x02c303cb,0x016201dd,0x011e0136,
0x01930127,0x03c10281,0x061d04fa,0x0945076f,0x0dc70b82,0x11c40fdb,0x152f1380,0x17ab16ab,
0x17a117f1,0x164e1711,0x13df153e,0x1068123d,0x0c240e5f,0x06da099d,0x010e03f8,0xfadefe17,
0xf4b0f7a5,0xef71f1ed,0xeb81ed53,0xe843e9df,0xe4a1e688,0xe070e290,0xdce1de86,0xda64db72,
0xda32d9ef,0xdc41db08,0xdf7bddbb,0xe3a1e17b,0xe75ae5a0,0xea73e8e8,0xed7eec02,0xf0a1eefd,
0xf431f264,0xf6f5f5ca,0xf7f0f7a4,0xf7d5f7fc,0xf70cf782,0xf5c2f671,0xf463f50b,0xf3acf3e5,
0xf46df3d1,0xf6fbf57f,0xfa66f8b2,0xfcecfbd8,0xfe73fdbd,0x004aff38,0x03ca01da,0x083205f3,
0x0c820a73,0x0fa90e42,0x118f10bb,0x12a1122d,0x131112ea,0x12c41317,0x10e61207,0x0d800f69,
0x09440b5f,0x05530742,0x01f50388,0xffd400ad,0xffcdff8a,0x015a006f,0x03060250,0x03b2036c,
0x03ef03ec,0x034803b8,0x01dc029c,0x002f0108,0xfed3ff72,0xfd1efe1f,0xfa52fbc4,0xf797f8e9,
0xf5a0f680,0xf40ef4d4,0xf309f364,0xf345f30b,0xf3abf384,0xf44bf3d5,0xf6adf544,0xfa1af860,
0xfd0bfbab,0xff15fe2f,0x012ffffb,0x048b02bf,0x08a80680,0x0d660b0a,0x11940f93,0x1482134c,
0x15a51539,0x15c015d8,0x1487154f,0x1242137d,0x0f5a10de,0x0c730dd9,0x09eb0b22,0x079c08cd,
0x0540065a,0x03a7045d,0x031a0338,0x02ee0307,0x03bd031f,0x05d004b4,0x07f706ed,0x0af9092c,
0x10090d5e,0x150a12aa,0x1904172c,0x1ab61a5c,0x18bf1a02,0x15af1751,0x118413ad,0x0d910f6b,
0x09c30bd2,0x04b8075f,0xff6a020b,0xf9d1fcb2,0xf40ff6e2,0xeeeff15f,0xeafeecd2,0xe7f1e96e,
0xe4d1e676,0xe0f4e2f0,0xdd5bdf0d,0xdaf3dbec,0xdaf6daa3,0xdd25dbd2,0xe0c8ded1,0xe52be300,
0xe88fe701,0xeb52ea02,0xed66ec72,0xef8fee61,0xf261f0f3,0xf4b9f3b9,0xf564f537,0xf553f568,
0xf477f508,0xf2cef3ad,0xf15df209,0xf0e1f0ec,0xf230f145,0xf5a3f3ab,0xfa54f7fe,0xfd5afc23,
0xff2bfe4e,0x01540011,0x05570325,0x0a0b07ad,0x0e9e0c73,0x11a21053,0x137c129b,0x14ee1441,
0x15e41585,0x155c15ed,0x125d141e,0x0e191048,0x0a010bfb,0x06500825,0x02c80484,0x00950158,
0x01100083,0x0354021f,0x051a045d,0x05b3058d,0x05070584,0x03590446,0x0142024a,0xff930058,
0xfe25fee2,0xfbc5fd14,0xf909fa66,0xf682f7b1,0xf4c7f596,0xf33bf3f7,0xf27ef2be,0xf1fbf24c,
0xf161f19b,0xf251f197,0xf500f37b,0xf836f69d,0xfb0ff9c2,0xfcd1fc02,0xff57fde3,0x030a0114,
0x07d0054b,0x0d040a67,0x11f40f9b,0x150e13c8,0x167715e7,0x169c16ba,0x157c1632,0x13411483,
0x106211da,0x0da50eee,0x0b4e0c81,0x088009eb,0x06330740,0x05160576,0x04e004f4,0x04dd04d1,
0x05e90539,0x078006b5,0x08d4082b,0x0b6d09c8,0x10420dbd,0x152b12c1,0x18f81752,0x19a519d6,
0x174618a3,0x137d1596,0x0f431144,0x0bd70d7d,0x082c0a1b,0x03bb05fe,0xff560187,0xfa66fd02,
0xf4f7f7a3,0xefcdf253,0xebc6eda7,0xe89fea13,0xe578e72a,0xe1cde3a8,0xde4adfec,0xdc6ddd10,
0xdcc9dc61,0xdf28ddb6,0xe2ede0f1,0xe6d6e4fa,0xe9b7e863,0xeb91eace,0xec7aec15,0xedc7ed02,
0xefb7eebd,0xf14df09d,0xf1fef1c1,0xf22ef226,0xf14af1e9,0xef9bf078,0xee37eed3,0xee46edf8,
0xf06eef19,0xf4baf24e,0xf9c4f75d,0xfccafb89,0xff02fddf,0x0200004a,0x06c0043f,0x0beb094c,
0x10730e64,0x13b41231,0x162b14fe,0x1852174a,0x19911922,0x18b3197c,0x14f61725,0x1024128a,
0x0c040dfa,0x08480a1f,0x04d5067c,0x02ee038f,0x039902fb,0x05a204a3,0x06d90658,0x06d60711,
0x05540644,0x02e80429,0x005e019f,0xfe73ff4b,0xfc9bfda5,0xf9d8fb42,0xf704f86b,0xf4b0f5bf,
0xf2ebf3cb,0xf148f20e,0xf049f0b7,0xef4defdb,0xeec9eed5,0xf067ef55,0xf37df1d7,0xf6c2f524,
0xf9a7f854,0xfbcefab3,0xff0cfd48,0x030b00f4,0x08150576,0x0d800ac5,0x1266101f,0x1583142b,
0x17191676,0x17a1177c,0x170e1781,0x14f61631,0x12281392,0x0f9110cf,0x0cf60e5d,0x09d10b5c,
0x07760885,0x063d06ac,0x057f05e9,0x04a30501,0x049b0480,0x053104e3,0x061c0596,0x083c06db,
0x0d8b0a7d,0x14761102,0x19c21789,0x1b301afb,0x18971a5c,0x136b1628,0x0e7d10c6,0x0a870c7a,
0x069c0895,0x023c0485,0xfdb0ffdb,0xf9d1fbc0,0xf5a4f7c5,0xf10ef35f,0xed10eedb,0xea85ebb4,
0xe82ee963,0xe544e6d6,0xe1f1e38f,0xdfa9e0a5,0xdee3df00,0xe06edf68,0xe3c7e1ec,0xe7b2e5b1,
0xeb50e9a4,0xed09ec75,0xed0bed27,0xed21ed08,0xedd2ed5f,0xef02ee66,0xefaaef84,0xef28ef85,
0xed5fee6e,0xeafeec2b,0xe960ea0c,0xe94de911,0xeb29ea02,0xef78ecf0,0xf581f26e,0xfaecf86a,
0xff51fd2a,0x0388016e,0x086f05d1,0x0dcc0b34,0x12101012,0x154c13d0,0x17f716a3,0x1a731946,
0x1bc61b5f,0x1ab01b8b,0x16d61911,0x126d1478,0x0f5a10c1,0x0cb60e13,0x098c0b26,0x07520837,
0x07630709,0x08f00826,0x09d30989,0x093609b5,0x07190855,0x042f05a7,0x015602bb,0xff3c0030,
0xfcd4fe2e,0xf995fb3e,0xf69cf80f,0xf3e0f539,0xf15cf290,0xef34f038,0xed9dee61,0xebd2ecb9,
0xeb51eb3d,0xed51ec15,0xf06eeed1,0xf3bdf217,0xf674f53a,0xf947f7bf,0xfceafb07,0x0116fee4,
0x0633038f,0x0ba108e7,0x10a20e43,0x14241298,0x160c154d,0x16c3167e,0x16c716f3,0x1519161d,
0x12a413e0,0x1053116e,0x0de60f34,0x0b330c7b,0x09220a11,0x0828088c,0x073207b4,0x068206c4,
0x06880673,0x06e006ad,0x07a3072b,0x09f6087b,0x0f560c3f,0x168412f5,0x1b7a1976,0x1ca01c87,
0x19851ba4,0x134d1680,0x0dc41064,0x08920b27,0x03c2061f,0xfed70161,0xfa46fc60,0xf73ef89d,
0xf43df5d6,0xf0c1f284,0xedbeef1b,0xebd2ecaf,0xea2aeb05,0xe7e5e92e,0xe4eee662,0xe29de3ae,
0xe194e1dc,0xe28de1cb,0xe57ae3df,0xe933e742,0xecb9eb21,0xee1aedb8,0xedb8ee0c,0xece1ed49,
0xeca3eca7,0xed1deccf,0xed3bed50,0xec35ecde,0xe9daeb2f,0xe70de862,0xe56be60b,0xe579e53c,
0xe75ae622,0xebfae954,0xf29cef28,0xf92bf603,0xfecdfc12,0x03f1016e,0x09770693,0x0f030c5f,
0x13771156,0x17081562,0x19f01881,0x1c9d1b54,0x1dec1d92,0x1cc31db1,0x18ba1b0d,0x14751662,
0x11f71305,0x0fec1105,0x0d190e94,0x0ac00bc3,0x0a720a49,0x0b730ae5,0x0c0c0be6,0x0b110bcd,
0x086509ea,0x04d8069f,0x01960320,0xff1e0050,0xfc14fdb8,0xf883fa4a,0xf54cf6d3,0xf25ff3d1,
0xef89f0f1,0xed3fee47,0xeb8fec67,0xe9b4ea96,0xe99fe94e,0xebedea93,0xef1aed76,0xf27bf0d3,
0xf54df3f1,0xf8d3f6e5,0xfcf1fae8,0x0133fef7,0x062f03a5,0x0b3b08bd,0x0fb30d94,0x13341196,
0x154a146e,0x163115da,0x164e1668,0x14cc15b9,0x128313b1,0x104c1161,0x0dbb0f13,0x0b520c76,
0x096f0a43,0x084508d4,0x071307ae,0x066e069b,0x06aa0679,0x074d06ef,0x08c107db,0x0bb00a02,
0x11870e29,0x18cc154c,0x1d911ba5,0x1e811e81,0x1b201d6f,0x14c317f8,0x0ebe11be,0x089c0ba7,
0x02b405a6,0xfcb5ffae,0xf774f9d9,0xf478f5bd,0xf25cf366,0xf047f14f,0xee83ef55,0xed3aedd6,
0xec32ecb1,0xea59eb75,0xe7ace90c,0xe540e65e,0xe3e0e466,0xe46ae3e0,0xe6dce573,0xea2ce87c,
0xed13ebd4,0xee01edc2,0xed5eedda,0xebcceca0,0xeab1eb1f,0xea7aea86,0xea0fea5f,0xe849e95b,
0xe550e6ee,0xe231e3aa,0xe0b4e12c,0xe116e0b8,0xe386e1fb,0xe898e5ba,0xeff2ec13,0xf7dff3f6,
0xfef7fb7b,0x0591025c,0x0bd708b6,0x118e0ed8,0x163d13fa,0x19f51840,0x1cbe1b6e,0x1f071e01,
0x1fdf1fad,0x1e141f5e,0x19af1c14,0x15ce1771,0x141a14c4,0x12a1137a,0x1038117d,0x0e280f0b,
0x0dfb0dd8,0x0eb10e51,0x0f440f13,0x0e3e0f08,0x0b260ce8,0x06df0919,0x02d104b8,0xff5a0116,
0xfb64fd74,0xf762f95a,0xf3e9f58e,0xf0c6f25b,0xed8fef24,0xeb45ec47,0xe95aea5e,0xe765e846,
0xe79de724,0xea24e8b2,0xed4bebb0,0xf050eee6,0xf2e2f193,0xf6c1f49c,0xfb3af901,0x0012fd8a,
0x054f02ad,0x0a4a07e2,0x0e980c85,0x12071076,0x14281340,0x152e14c6,0x15371558,0x140314bc,
0x1239131e,0x10771160,0x0e430f5d,0x0c780d53,0x0b340bb9,0x0a730adb,0x096a09ed,0x09380928,
0x09ad0968,0x0a970a0e,0x0cc40b79,0x10680e65,0x16791322,0x1ceb19ed,0x200e1f0a,0x1ee41ff6,
0x19831cb3,0x126c15f4,0x0b280ed5,0x03e90787,0xfcc2004a,0xf5c9f944,0xf024f29f,0xed60ee69,
0xec23ecac,0xebf5ebec,0xec6fec20,0xed29eccc,0xedc0ed89,0xed0beda3,0xeb19ec1e,0xe92eea18,
0xe80be86f,0xe88ce812,0xeaf3e989,0xee42ec94,0xf0cdefbf,0xf164f157,0xf042f101,0xee3cef47,
0xecb5ed5b,0xebdeec41,0xea7aeb5d,0xe77ee933,0xe363e577,0xdfd3e172,0xde31deb9,0xde5bde12,
0xe0abdf2a,0xe5e8e2eb,0xed9ce989,0xf5edf1dc,0xfd2bf9ac,0x03dd008e,0x0a250702,0x0feb0d2d,
0x14c91275,0x188116d4,0x1b0a19da,0x1ce51c14,0x1dd51d87,0x1cc01da6,0x19651b32,0x16ce17d2,
0x160e1646,0x157915e0,0x13ca14bd,0x123112dd,0x12391202,0x12d71287,0x1319131d,0x11a212ad,
0x0e381017,0x09ac0c0b,0x04f5073e,0x00be02d6,0xfc3bfe86,0xf7ccf9f6,0xf3f7f5ce,0xf03bf22a,
0xec61ee3b,0xe99aead0,0xe7a5e893,0xe631e6d0,0xe695e60e,0xe8fce7a2,0xec09ea76,0xeef9ed98,
0xf192f033,0xf55ff355,0xf997f77a,0xfe8cfbf5,0x0397011c,0x088c0613,0x0d380af5,0x10e80f3c,
0x137d1254,0x14bc1444,0x14bb14e6,0x13a21446,0x120b12de,0x107c114a,0x0ecf0f9c,0x0d5d0e1a,
0x0c370cb1,0x0b670bdd,0x0a300ac1,0x09be09d5,0x0a0009d5,0x0b0c0a57,0x0db90c2d,0x11ac0f92,
0x16ea1416,0x1c9119e2,0x1f9c1e95,0x1e871f99,0x19e21c9e,0x1316168d,0x0bb90f74,0x04720818,
0xfd0400bd,0xf58cf948,0xeeebf204,0xead4ec83,0xe912e9ba,0xe919e8dd,0xea5ce9a0,0xec95eb59,
0xef12ede6,0xf01fefe4,0xef43efd7,0xedacee7c,0xec3aeceb,0xebe8ebd5,0xed5eec70,0xefb3ee87,
0xf199f0c1,0xf216f21b,0xf0cbf19b,0xee72efb2,0xec2bed3b,0xea6feb48,0xe855e982,0xe4aee6c2,
0xe007e25b,0xdc3adde9,0xda84db17,0xda98da67,0xdc8edb3f,0xe155de8d,0xe907e4dd,0xf229ed91,
0xfab6f690,0x026bfea9,0x096605f8,0x10170cdb,0x15ea131a,0x1a4a1859,0x1cf91bcd,0x1e811dd7,
0x1f4c1efb,0x1e671f2d,0x1b551d08,0x18f119dc,0x18551879,0x184f185f,0x171017e1,0x158c163a,
0x15691548,0x15f615b1,0x162f1628,0x14d215c5,0x11441343,0x0c5d0ef7,0x071209ae,0x023c049d,
0xfd27ffc3,0xf806fa8e,0xf32df58f,0xee30f0be,0xe933eb9f,0xe5e5e73b,0xe46ae507,0xe383e3e2,
0xe423e38b,0xe6bee53f,0xea42e873,0xed8eec02,0xf05ceeeb,0xf420f217,0xf879f648,0xfd6ffad4,
0x027d0007,0x076804f2,0x0c3709dd,0x10640e6a,0x13851222,0x14f6146f,0x15001529,0x13eb148e,
0x12651331,0x10d4119b,0x0f5b1012,0x0e2c0eba,0x0d5d0db7,0x0c9c0d0f,0x0b5b0c00,0x0aa30adc,
0x0af00ab0,0x0c6b0b75,0x0ff10df6,0x14421218,0x1905167f,0x1e551bca,0x20b92019,0x1ed82039,
0x19ff1ccd,0x129d167d,0x0ade0eba,0x02e406e5,0xfb04fefb,0xf2fbf6f7,0xeb9cef1c,0xe690e8bf,
0xe433e513,0xe3f0e3ce,0xe5a1e492,0xe945e734,0xede4eb9b,0xf118efcf,0xf211f1d1,0xf1b9f1fc,
0xf0abf147,0xf03ff046,0xf15cf0a2,0xf30df238,0xf460f3cf,0xf436f485,0xf25cf375,0xef99f105,
0xecffee3a,0xeaceebe7,0xe815e996,0xe3cee620,0xdee0e148,0xdae8dcb3,0xd8d8d99f,0xd871d87b,
0xd9cad8d2,0xde1fdb7f,0xe614e1b7,0xefd2eae7,0xf8f2f48a,0x0110fd15,0x08e404f8,0x10990cda,
0x172313ff,0x1bcd19be,0x1e421d4a,0x1f4d1ee9,0x1fd61f9d,0x1f0f1fb6,0x1c861dea,0x1a421b31,
0x19fd19e6,0x1a911a53,0x19d21a65,0x1857190b,0x17e817e9,0x18641828,0x187e1887,0x17301812,
0x13b615b9,0x0e6a113d,0x08570b5d,0x02a4056f,0xfcc4ffc6,0xf6c8f9c0,0xf0faf3dc,0xeb3bee1c,
0xe5c6e864,0xe247e3ac,0xe14ce18f,0xe152e13f,0xe26be1a2,0xe55ae3b2,0xe93ce743,0xece2eb20,
0xf009ee7f,0xf3c5f1c6,0xf818f5ee,0xfcdafa51,0x0244ff95,0x075204d2,0x0c4c09d9,0x105e0e80,
0x131f11e4,0x146e13f7,0x1484149c,0x13b71435,0x12551313,0x10e61192,0x0fa3104c,0x0e640ef6,
0x0d6e0ddf,0x0cb40d11,0x0bd70c4b,0x0b6c0b85,0x0c2c0ba3,0x0e340cf6,0x12270ffc,0x16781463,
0x1ac21884,0x1f811d3d,0x214e20f2,0x1f2c20a3,0x1a491d1c,0x12681685,0x0a770e72,0x026a066c,
0xfa45fe5e,0xf232f640,0xea49ee21,0xe462e6f8,0xe176e2a0,0xe098e0c2,0xe234e10f,0xe6bae427,
0xeca8e9a5,0xf1c5ef76,0xf491f373,0xf56ef53f,0xf4c0f52e,0xf468f471,0xf4eaf49a,0xf567f527,
0xf5c5f5a5,0xf4daf58e,0xf26ff3c4,0xef6bf0ee,0xec8dedfc,0xe9caeb29,0xe688e851,0xe1d6e45f,
0xdc96df2a,0xd858da43,0xd5ead6e2,0xd55fd56c,0xd67fd5a6,0xdaa9d81e,0xe29cde2f,0xecede7a6,
0xf6bef204,0xff73fb24,0x07ee03b5,0x10610c2d,0x17d8145c,0x1cfb1ab6,0x1f9c1e9d,0x20742024,
0x20b520ac,0x1f992065,0x1d3e1e77,0x1b661c21,0x1b8c1b3c,0x1c6b1c11,0x1c2b1c7a,0x1b1f1b9e,
0x1b061aee,0x1b8a1b44,0x1bc61bbb,0x1a781b69,0x16a918ed,0x10b513d6,0x0a370d76,0x03f40714,
0xfd7100c5,0xf6d8fa18,0xf066f39c,0xea18ed3d,0xe443e703,0xe0b9e21d,0xdf97dff1,0xdfa9df85,
0xe11fe025,0xe419e284,0xe775e5c8,0xea8de915,0xecffebcc,0xf02eee66,0xf420f222,0xf8d3f643,
0xfed1fbbb,0x04e101e2,0x0a9b07c4,0x0f830d46,0x12501139,0x13771304,0x13e813cd,0x138a13cd,
0x12bc1320,0x120c126f,0x1100118b,0x102a108f,0x0f700fcb,0x0eef0f30,0x0e730ea3,0x0ec60e6e,
0x10740f75,0x13a911db,0x17ca15b6,0x1b9319bd,0x1fa31d89,0x22f0219d,0x2252232e,0x1e2f209a,
0x16d01aed,0x0df2125b,0x058109a3,0xfd710174,0xf575f968,0xeda0f185,0xe659e9dc,0xe0dae34f,
0xdd55dee6,0xdbc9dc46,0xdd38dc0b,0xe20cdf47,0xe8abe54b,0xeeabebdd,0xf31af113,0xf5d1f4af,
0xf70df689,0xf84af79b,0xf9baf90b,0xfaadfa51,0xfa4efaaf,0xf85bf986,0xf501f6cd,0xf166f32b,
0xee30efba,0xeb22ecaf,0xe769e968,0xe2a5e524,0xdd7ee00b,0xd925db26,0xd652d782,0xd536d591,
0xd66fd574,0xdafdd83a,0xe2c4de8a,0xebfde765,0xf43cf047,0xfc12f819,0x04740025,0x0d3c08e5,
0x1523116c,0x1a6e1821,0x1d2f1c15,0x1e7c1de5,0x1f5b1f0c,0x1eda1f50,0x1cd11df5,0x1b591bd6,
0x1bba1b5d,0x1caa1c42,0x1c7a1cbc,0x1bcb1c14,0x1c681be0,0x1dc81d23,0x1e601e3f,0x1d4a1e18,
0x19a81bd9,0x138a16cc,0x0cc4102c,0x0602095d,0xff08028e,0xf7fcfb80,0xf10ff481,0xea52eda8,
0xe433e71d,0xe032e1d6,0xdec9df3a,0xdea1de98,0xe021df1a,0xe372e1a5,0xe71be547,0xea75e8df,
0xed12ebd0,0xf036ee87,0xf3a3f1f5,0xf824f59b,0xfe3dfb1a,0x04860158,0x0abf07b6,0x0f8d0d63,
0x12171112,0x132d12bf,0x136b136a,0x12d51338,0x11fa1265,0x113d11a1,0x101210b1,0x0f060f81,
0x0e5f0e9f,0x0e740e5e,0x0ecf0e99,0x102a0f4a,0x12fc116f,0x16b414b8,0x1ad618d3,0x1e371c9a,
0x21dd1ff4,0x24332376,0x22e62402,0x1e0220e5,0x15691a22,0x0b99106d,0x02a10706,0xfa33fe58,
0xf260f63d,0xeac8ee8f,0xe3b9e711,0xdeade0f4,0xdb22dcc3,0xd971d9e8,0xdb33d9dc,0xe056dd71,
0xe75fe3be,0xee04eade,0xf311f0bd,0xf6c9f50e,0xf95df830,0xfbabfa83,0xfdb1fcc1,0xfe71fe48,
0xfd62fe33,0xfa42fc04,0xf601f838,0xf1dff3d0,0xee8cf025,0xeb66ed00,0xe778e997,0xe248e4f3,
0xdd2edfb0,0xd88cdac3,0xd556d6b1,0xd3d1d45b,0xd53dd414,0xda3ad742,0xe286de0f,0xebbde742,
0xf3b5efd6,0xfb7cf790,0x0400ff97,0x0cea0887,0x147a10fe,0x19961755,0x1c6e1b3f,0x1e171d5b,
0x1ea61e8e,0x1d7f1e47,0x1b921c7d,0x1af71b08,0x1be31b4e,0x1cd51c7b,0x1cfa1cf6,0x1d8f1d1c,
0x1f501e58,0x210a203b,0x21e021a7,0x20a52192,0x1cca1f0a,0x16c219fc,0x0fce1359,0x084b0c21,
0x0075045f,0xf8cefca0,0xf15df50f,0xea26edbc,0xe3e6e6c8,0xe00fe1af,0xdddcdecc,0xdd39dd44,
0xdf3fddec,0xe2b9e0ef,0xe63be47d,0xe8bee7af,0xeaaae9a1,0xed88ec09,0xf0a2ef02,0xf560f2c0,
0xfbc1f861,0x02c2ff4c,0x092e0611,0x0e170be9,0x10a90fad,0x11e31150,0x12b6125b,0x12d912de,
0x12ed12d6,0x127312df,0x114a11d9,0x103610bb,0x0fad0fdc,0x0f850f99,0x100c0f97,0x122810f4,
0x15411398,0x1975173a,0x1d9e1bab,0x20ef1f4a,0x248422c3,0x25d3259f,0x23642518,0x1d4720d1,
0x139718b3,0x09900e73,0x008804ee,0xf852fc58,0xf08ff468,0xe8faecbb,0xe26ae571,0xdd7ddfd1,
0xd997db69,0xd788d839,0xd8dbd7bb,0xdd69dac7,0xe3dfe091,0xe9fae704,0xef47ecc4,0xf393f17e,
0xf7bbf59e,0xfc1ff9e7,0x001afe4c,0x021d0169,0x01340212,0xfdc0ffb5,0xf8defb68,0xf400f656,
0xf02af1fc,0xec8cee60,0xe836ea81,0xe31fe5b8,0xde0de086,0xd9badbc0,0xd6a9d80e,0xd50fd595,
0xd695d55f,0xdbb1d8b3,0xe370df54,0xeb68e78d,0xf28bef0f,0xf997f600,0x01cdfd8b,0x0a62061b,
0x11fb0e6c,0x173314ed,0x1a5218ef,0x1c5e1b6f,0x1d5f1d16,0x1c951d30,0x1b131bc6,0x1b171adf,
0x1c4d1b99,0x1d481ce2,0x1dae1d7f,0x1e9a1e05,0x20b11f8c,0x22fb21de,0x241423c7,0x230923da,
0x1f8e219f,0x19a81cd0,0x12a4163b,0x0ac60edd,0x0221067d,0xf998fdcf,0xf1c3f59d,0xea32edec,
0xe39de6b2,0xdf39e125,0xdc90ddbd,0xdba7dbcc,0xdd85dc47,0xe0f9df2a,0xe487e2c3,0xe72ae609,
0xe936e81f,0xebf7ea8d,0xef1aed68,0xf40ef150,0xfad7f748,0x0210fe7e,0x0898057d,0x0d320b28,
0x10040ec9,0x11af10f4,0x12c21247,0x132d1307,0x13381344,0x129712fc,0x118d1214,0x10a71110,
0x1067106c,0x10ae107b,0x11ec1122,0x14c11329,0x184b167b,0x1c101a2a,0x1fa61def,0x229b2128,
0x24f523ef,0x2529256b,0x21de2405,0x1ab11eaf,0x10ba15f7,0x06a30b8d,0xfd5001d7,0xf545f92e,
0xedd2f180,0xe6a6ea2a,0xe09ae370,0xdbcfde12,0xd812d9cc,0xd69bd6f6,0xd877d721,0xdd3dda8d,
0xe363e04b,0xe8e2e642,0xeda1eb52,0xf252eff9,0xf745f4b2,0xfd26fa16,0x02af0029,0x056f0478,
0x04a80580,0x00d4030b,0xfb4efe2a,0xf5e2f87e,0xf148f379,0xed2def3c,0xe8a1eafc,0xe38fe61e,
0xde9be10c,0xda3adc4c,0xd71cd87f,0xd5d7d623,0xd7a6d65b,0xdc9dd9bb,0xe3e2e01b,0xeb38e7a3,
0xf1e2ee99,0xf8b3f52d,0x008efc91,0x085c0487,0x0f4d0c00,0x1469121d,0x1810165e,0x1a82196d,
0x1b9c1b4b,0x1acc1b5f,0x19ce1a27,0x1a4019d8,0x1b881ae1,0x1c851c16,0x1d631ce4,0x1f4d1e32,
0x21c02086,0x242522fd,0x2574250c,0x244f2539,0x20ec22e2,0x1b7f1e6a,0x14da185b,0x0cc410f9,
0x03f5085c,0xfb73ff9f,0xf392f77b,0xebfdefb6,0xe5aae891,0xe114e333,0xddc6df41,0xdccbdce3,
0xde9bdd73,0xe1c7e017,0xe4ffe37e,0xe6d9e60d,0xe8aae7a9,0xeaf5e9c8,0xee2eec57,0xf353f08c,
0xfa18f68d,0x0128fdb2,0x07360461,0x0b610989,0x0e000cd9,0x0f700ed0,0x10500ff1,0x10ef10a2,
0x10f01108,0x104c10a6,0x0faa0ff9,0x0f650f6f,0x10000fa1,0x1115106f,0x13c5122d,0x17ed15c0,
0x1c251a13,0x20111e2c,0x232d21c3,0x25a22469,0x27e426e3,0x274a282a,0x21e62522,0x18e41dd1,
0x0deb1368,0x03a808b1,0xfa69fedf,0xf229f631,0xea68ee41,0xe360e6b8,0xddcde06a,0xd97fdb88,
0xd663d7b9,0xd599d59d,0xd833d67f,0xdd66da96,0xe2fce04a,0xe79fe56e,0xebcbe9b7,0xf004ede4,
0xf519f25d,0xfbf0f85c,0x02cfff84,0x07270574,0x076007c6,0x03ca05f7,0xfe680132,0xf8fffb99,
0xf4aff6c1,0xf083f2a2,0xebadee30,0xe642e903,0xe0dae38a,0xdc14de55,0xd8c3da32,0xd7c2d7eb,
0xd9eed863,0xdf80dc60,0xe6a3e30f,0xecc7e9e3,0xf1fcef71,0xf7a7f4a6,0xfe58fafa,0x051b01ac,
0x0b70086e,0x101c0dfe,0x137611e6,0x162d14e0,0x17f4173f,0x18141834,0x18521806,0x19cf18f8,
0x1b931ab7,0x1ca61c2b,0x1dd71d20,0x20461ee9,0x234921c6,0x260c24c6,0x271826db,0x25ff26d0,
0x22c224ac,0x1dac2062,0x17191a9d,0x0e9a1309,0x055609f7,0xfc7800d3,0xf465f855,0xecf3f098,
0xe6a2e995,0xe1a1e40a,0xdd90df6b,0xdc02dc5d,0xdd87dc79,0xe085deee,0xe39de221,0xe5ade4c9,
0xe74ee675,0xe96ce84a,0xecd8eae2,0xf220ef4a,0xf8e2f560,0xffc6fc60,0x05a102eb,0x09b807d2,
0x0cbf0b5f,0x0f070df4,0x10e41000,0x120c119e,0x12361231,0x11f51221,0x118111c5,0x11421144,
0x121e1189,0x140a12ed,0x17d215ad,0x1c971a36,0x20c01ec7,0x23e1227c,0x262d250b,0x28422746,
0x28f528f8,0x256027d1,0x1d6021ce,0x128f1834,0x077f0ce4,0xfd9b0268,0xf4ecf920,0xed48f108,
0xe637e9a7,0xe091e326,0xdc52de5c,0xd875da51,0xd5bed6d8,0xd5d0d55c,0xd903d719,0xddeddb61,
0xe2abe06a,0xe6c3e4c3,0xeacce8c2,0xef41ecf1,0xf4fff1dc,0xfc75f8a3,0x035b0025,0x079e05e5,
0x081b085d,0x050206eb,0x001402a3,0xfb4afd99,0xf6c7f90e,0xf210f472,0xecedef8f,0xe75fea2c,
0xe1d3e490,0xdd15df49,0xda0adb4d,0xd9bfd97a,0xdcebdae8,0xe297df90,0xe842e598,0xecbceaa1,
0xf0bfeeb3,0xf5b7f30b,0xfb4ef883,0x0128fe33,0x06bb040f,0x0b70092c,0x0f610d7b,0x12c01116,
0x15801453,0x167e1627,0x17e316fe,0x1a45190d,0x1c3c1b5f,0x1d881cde,0x1f921e63,0x22f92129,
0x262a24ae,0x283c2757,0x28bc28bb,0x275d2844,0x24312608,0x1f2121e4,0x18341bf1,0x0f4c13ee,
0x06000a98,0xfd52018f,0xf57cf953,0xee53f1cb,0xe844eb26,0xe304e58f,0xdebbe0b1,0xdcf9dd6f,
0xde04dd3c,0xe07bdf21,0xe340e1f1,0xe4dee432,0xe649e57f,0xe895e74e,0xecb8ea58,0xf2aaef89,
0xf970f601,0xffd4fcc8,0x04940269,0x083c0684,0x0b1609c0,0x0d6e0c4f,0x0f580e75,0x10570ff8,
0x10d7109f,0x109e10d1,0x10521073,0x1091104c,0x12351134,0x15091374,0x19791714,0x1e331beb,
0x220a2042,0x24892373,0x26032551,0x27e826eb,0x28112874,0x23912674,0x1b1b1fb6,0x105815dc,
0x06320b15,0xfd15018a,0xf4aef8d1,0xecb8f09f,0xe565e8fd,0xdf6ce220,0xdb3edd31,0xd7e2d974,
0xd60dd6b4,0xd723d62f,0xdacdd8bc,0xdfc3dd3c,0xe419e217,0xe7eee603,0xeba6e9d6,0xef51ed69,
0xf459f19b,0xfad2f783,0x0110fe11,0x050f0376,0x05b005c5,0x036004d8,0xffa2018a,0xfbbafdb3,
0xf7f0f9d5,0xf389f5d4,0xeeadf12b,0xe922ebf3,0xe3d0e668,0xdf39e162,0xdc08dd61,0xdb82db61,
0xdec7dca8,0xe478e17e,0xe9c6e753,0xedcaebe7,0xf136ef81,0xf55df321,0xfa14f7bc,0xff26fc8c,
0x041301b2,0x085e0646,0x0c150a44,0x0ffc0df9,0x135e11e0,0x14fb1451,0x171f15d9,0x1a15189d,
0x1c6b1b60,0x1dea1d31,0x1ff41ecb,0x2371218b,0x26d1254e,0x288927e2,0x28ed28dd,0x280228a4,
0x256626f6,0x20dc2363,0x1a2a1dcb,0x114315f5,0x079d0c64,0xfec10312,0xf6bffaa8,0xef97f30d,
0xe980ec64,0xe478e6dc,0xe05ae24b,0xde27dee5,0xde7cde1a,0xe03cdf35,0xe285e16b,0xe3d9e353,
0xe534e468,0xe7a9e643,0xec1de996,0xf2a0ef37,0xf989f617,0xffe0fcda,0x04830268,0x07fa0658,
0x0aa3095f,0x0d0c0be3,0x0edd0e0e,0x0fb10f60,0x10471006,0x10381057,0x10151014,0x10eb1050,
0x138011fe,0x1776154a,0x1c9d19f6,0x21a01f3b,0x24c72383,0x264425a3,0x278b26dd,0x28782830,
0x265827f5,0x200823b0,0x16371b6e,0x0bb810e5,0x023906c7,0xfa0cfe03,0xf251f62e,0xeb09eea1,
0xe467e797,0xdef2e180,0xdaaedcaf,0xd757d8e5,0xd604d651,0xd793d672,0xdb70d94b,0xe009ddc2,
0xe3f2e216,0xe7a9e5c8,0xeb90e993,0xefbbed8e,0xf513f23c,0xfb0df818,0x000dfdc0,0x02fd01d6,
0x03420372,0x01d202a5,0xfff200eb,0xfdadfee9,0xfa79fc2d,0xf6bdf8ac,0xf1f3f47d,0xec5fef34,
0xe6ede996,0xe21ee466,0xdedde03b,0xdeadde4b,0xe200dffc,0xe670e443,0xea3ae86c,0xed56ebdb,
0xf08beed6,0xf477f269,0xf8d9f6a3,0xfd32fb0e,0x0193ff5c,0x05fb03ca,0x0a18080e,0x0e680c3f,
0x11ae1046,0x13c312ba,0x1690150a,0x199d1820,0x1bc41ad1,0x1da11ca0,0x20c41efc,0x253622f4,
0x285c270f,0x29a42933,0x299429c7,0x28332909,0x256d2707,0x20de2363,0x1a3a1dd8,0x113e15f1,
0x07d10c6c,0xff68037f,0xf7fffb93,0xf17af4a1,0xec0ceea1,0xe733e995,0xe2e7e4ed,0xe078e164,
0xdffbe007,0xe0d9e045,0xe20fe189,0xe2dee273,0xe475e384,0xe73be5aa,0xec06e955,0xf23def0d,
0xf8c0f58b,0xfe31fba9,0x021a004b,0x051c03b2,0x07b00661,0x0a2108f6,0x0c370b37,0x0df50d19,
0x0f4e0ec3,0x0fa00f8e,0x0fc80fa6,0x1113102d,0x14541285,0x18f51672,0x1ec11bd0,0x23ed2191,
0x26d825a6,0x284427ac,0x298928dc,0x29ec2a07,0x268828cd,0x1f052347,0x149019f7,0x09f20f27,
0x00f10534,0xf921fcf5,0xf180f54f,0xea32edce,0xe39be6b9,0xdea2e0ee,0xdaf2dca8,0xd84bd975,
0xd7b3d7a9,0xd9c7d86c,0xddb4db98,0xe19ddfc7,0xe4c9e336,0xe800e65e,0xeb63e9ac,0xef56ed3d,
0xf434f1ac,0xf951f6d6,0xfd69fb8c,0xff57feb4,0xff2dff71,0xfdfcfea0,0xfd1ffd7c,0xfbfcfca7,
0xfa12fb2b,0xf725f8bb,0xf301f543,0xedf6f080,0xe8fdeb77,0xe4a9e6b3,0xe1bfe2e8,0xe229e17e,
0xe5b9e3af,0xe9c4e7c8,0xecfdeb78,0xef93ee52,0xf248f0e8,0xf556f3c1,0xf8a1f6f9,0xfbd8fa3f,
0xff44fd7f,0x03020121,0x06ca04dc,0x0aac08cf,0x0d690c2f,0x10290e9c,0x14171218,0x179a15f3,
0x1a0c18e4,0x1ccb1b48,0x21381ec8,0x266523df,0x2a2e2880,0x2c112b5f,0x2c2d2c51,0x2ab62bac,
0x27942952,0x23132593,0x1bea1fe1,0x12831759,0x090d0daf,0x00e304c4,0xf9a0fd2f,0xf335f641,
0xedccf073,0xe868eb1b,0xe3dde5ea,0xe14fe25f,0xe019e099,0xdfabdfcc,0xdf6cdf90,0xe010df89,
0xe233e0fb,0xe5aee3b6,0xeb0be82c,0xf1b3ee3e,0xf828f51a,0xfd42fadf,0x0134ff55,0x044002de,
0x06e5058e,0x0961082c,0x0bd60a99,0x0e480d09,0x0ffe0f5d,0x10a61059,0x111e10d0,0x132411e0,
0x16db14d6,0x1c31194f,0x22531f48,0x26f624f9,0x28d32833,0x2957290c,0x2a5829e8,0x29032a2c,
0x238b26c6,0x1a491f59,0x0f3a14bf,0x051209ee,0xfcc000bc,0xf54af8fa,0xedfdf1a3,0xe6ebea69,
0xe117e3bd,0xdd09dee8,0xd9d6db5c,0xd7b5d888,0xd7fad784,0xdab0d916,0xdeaedc9c,0xe253e0a2,
0xe55fe3d3,0xe8aee702,0xec1aea58,0xf05fee1f,0xf579f2df,0xfa75f803,0xfdd8fc7d,0xfe72fe7f,
0xfd6cfdf6,0xfcb5fcfb,0xfcb0fc9b,0xfce7fcd8,0xfbfdfc9c,0xf9e2fb17,0xf621f832,0xf17af3db,
0xecaeef0a,0xe851ea68,0xe5abe6a2,0xe6bae5b2,0xea42e869,0xed14ebe4,0xeebeedfe,0xf001ef52,
0xf1eaf0df,0xf431f30e,0xf68df550,0xf915f7d4,0xfbf0fa6a,0xff87fda8,0x036c0174,0x07440570,
0x0a2608c5,0x0d730ba0,0x11a80f8a,0x1539138b,0x182016be,0x1b7719a2,0x208b1dc1,0x260b236d,
0x29c02826,0x2ba02ae6,0x2bfd2bfb,0x2b112bbb,0x284729ea,0x23c6263e,0x1c9b2092,0x131917fc,
0x09e80e62,0x01e705be,0xfb0ffe64,0xf519f7ee,0xf06ff29f,0xec3aee56,0xe881ea3c,0xe5fbe71d,
0xe449e50c,0xe32fe3b0,0xe216e29d,0xe206e1d3,0xe3afe2b3,0xe6cee4fd,0xec0ae938,0xf1dfeef4,
0xf75ef4b3,0xfbc0f9c1,0xfee5fd6a,0x01bf0058,0x0465031f,0x0684056a,0x093e07d1,0x0c360abb,
0x0e7c0d88,0x0f9f0f18,0x1103103b,0x13dc1236,0x17fe15cd,0x1ced1a5e,0x224e1fac,0x26142480,
0x27542700,0x27ba2776,0x28422814,0x264427c3,0x205c23cf,0x16e61bfb,0x0bf5116e,0x023306d1,
0xfaa8fe35,0xf3c3f72b,0xed35f072,0xe6fbea06,0xe1dbe43a,0xde32dfe6,0xdb60dcb2,0xd9f5da67,
0xda88d9fa,0xdd3adba3,0xe105df15,0xe478e2df,0xe74ee5e5,0xea4de8c0,0xedb3ebfa,0xf194ef90,
0xf5e4f3ac,0xfa34f823,0xfcfafbe7,0xfd09fd56,0xfb72fc46,0xfa94fadc,0xfac5fa91,0xfb92fb24,
0xfbf3fbe2,0xfaeefb9c,0xf837f9cb,0xf477f65c,0xf040f26f,0xec12ee14,0xe94eea64,0xe9e0e925,
0xecb3eb37,0xef05edfc,0xf058efd4,0xf108f0b9,0xf21df178,0xf393f2e2,0xf4fbf43a,0xf6a2f5bc,
0xf90ef7b2,0xfcaafac1,0x007dfe90,0x03ff025c,0x06c90567,0x0aa0087c,0x0f590d01,0x13831189,
0x16ed1541,0x1ab118af,0x20161d30,0x259522fd,0x295927a9,0x2b662a9b,0x2bdc2bc5,0x2b352bb4,
0x28c82a37,0x248426ef,0x1d9e2172,0x14ce194a,0x0c0a1054,0x044a0804,0xfd9800d7,0xf800faa0,
0xf398f5b4,0xef7ff188,0xec06ed9e,0xe95eeaa7,0xe712e829,0xe4f8e612,0xe2dae3d3,0xe27de262,
0xe3d9e303,0xe6cfe508,0xeba2e916,0xf109ee55,0xf5dbf38b,0xf9a7f7eb,0xfc54fb12,0xfeeefd95,
0x01a1005c,0x03fa02bc,0x07120576,0x0a7c08c9,0x0d1d0bf1,0x0f080e14,0x117e1022,0x155d133e,
0x1a3f17b4,0x202f1d16,0x25cf2336,0x28cc27b9,0x295f2925,0x2a5a29dc,0x29b12a76,0x251c27db,
0x1cb9216d,0x11a71751,0x06cb0c12,0xfdad01f0,0xf6a0fa01,0xf04bf36b,0xea70ed43,0xe5c0e7f0,
0xe239e3dc,0xdf3ee0b5,0xdca3ddce,0xdbd8dbfb,0xdce1dc20,0xdf4ede00,0xe1f6e09c,0xe488e33f,
0xe742e5dc,0xeaa7e8e2,0xee8bec8f,0xf2bdf0a3,0xf6f6f4d8,0xfa3df8d1,0xfb31fb13,0xf9e5fab5,
0xf82cf8f5,0xf77bf7aa,0xf811f7a7,0xf917f894,0xfa18f993,0xfac7fa97,0xf9c7fa78,0xf7a5f8d8,
0xf4b5f637,0xf1aff328,0xf052f0ab,0xf14df09b,0xf285f210,0xf29ef2b1,0xf1fcf253,0xf1a1f1ba,
0xf19ef19b,0xf1bdf1ad,0xf251f1f4,0xf396f2cd,0xf640f4bb,0xfa09f813,0xfdeefc0c,0x00e9ff8b,
0x039f0225,0x079f057d,0x0be109c9,0x10050e00,0x142011ff,0x19481681,0x1f9b1c67,0x2553229c,
0x29cc27c0,0x2c442b47,0x2d462cea,0x2c982d3c,0x29f12b74,0x2596280a,0x1eb82274,0x163d1a9a,
0x0d7911c4,0x05f10990,0xff7b029a,0xfa28fca2,0xf5d7f7ef,0xf1d6f3d1,0xee57effb,0xeb83ece4,
0xe8baea22,0xe5fce762,0xe353e48a,0xe2a8e2ab,0xe3e3e318,0xe723e53b,0xebdce95f,0xf0f4ee74,
0xf53ff334,0xf87cf700,0xfb2cf9d8,0xfdd7fc7d,0x0032ff20,0x02d30159,0x06540487,0x0a0b083a,
0x0cdb0b92,0x0f4f0e14,0x126010b1,0x16b8146a,0x1bac1923,0x21291e63,0x25b923b0,0x27942703,
0x281c27ce,0x28e52890,0x2752289a,0x21f92516,0x190d1def,0x0de71391,0x03700870,0xfb09feea,
0xf490f7a8,0xef14f1c1,0xea3dec8a,0xe675e837,0xe3a2e4fd,0xe0f2e24e,0xdeaedfa4,0xde15de28,
0xdf37de79,0xe0f3e010,0xe2eee1e8,0xe503e3ee,0xe7cbe642,0xeb67e985,0xefa4ed79,0xf407f1d5,
0xf820f62d,0xfa6ff996,0xfa27fa97,0xf82cf94d,0xf627f70d,0xf54bf589,0xf5bbf567,0xf6c1f62f,
0xf81cf768,0xf934f8c6,0xf982f970,0xf8d6f953,0xf720f817,0xf4faf608,0xf3dff430,0xf478f40b,
0xf4c8f4c0,0xf420f496,0xf2dbf37b,0xf205f255,0xf194f1d0,0xf12af151,0xf188f13a,0xf335f225,
0xf673f4a6,0xfa81f875,0xfe6ffc89,0x00fcffea,0x03520202,0x0700050f,0x0ad908e7,0x0e8d0cc0,
0x12991073,0x17fb1513,0x1e751b38,0x24342174,0x28f726be,0x2bce2aa8,0x2d0b2c9b,0x2c6a2d09,
0x29c52b47,0x256a27e0,0x1e9b2247,0x16431a94,0x0d8d11d2,0x060a099a,0xffd102c5,0xfb3efd54,
0xf793f95f,0xf40ff5ca,0xf0fcf275,0xee27ef8e,0xeb4fecb8,0xe841e9dd,0xe572e6a6,0xe4b9e4d2,
0xe5c0e50d,0xe8c5e708,0xecd0eab9,0xf12bef05,0xf4c0f30f,0xf768f633,0xf9c0f886,0xfc34fafe,
0xfe3cfd45,0x00e5ff65,0x04a302a6,0x08bc06bb,0x0c3c0a86,0x0fad0df8,0x13c31193,0x18ae162b,
0x1dd01b30,0x2365209e,0x276425c3,0x28b0283f,0x29c5292b,0x29e02a26,0x267928a6,0x1f55235d,
0x14bb1a59,0x09660eff,0xff150407,0xf6ddfab3,0xf069f377,0xeb2aeda7,0xe756e903,0xe4e0e5fe,
0xe307e3e7,0xe12ee227,0xdfd0e053,0xe00ddfb8,0xe167e0ae,0xe28ee208,0xe3e8e328,0xe5eae4d3,
0xe8f2e743,0xed12eae8,0xf1b9ef64,0xf621f3f7,0xf9b0f81f,0xfb1ffab7,0xfa11fadd,0xf7a7f8e2,
0xf5d0f6a0,0xf4eaf53a,0xf4b8f4c9,0xf528f4c5,0xf680f5c7,0xf7b5f727,0xf8bcf83f,0xf979f92e,
0xf942f985,0xf8a3f8eb,0xf8abf888,0xf8cbf8da,0xf7c5f869,0xf5d6f6e0,0xf40af4d5,0xf2b5f35b,
0xf181f21f,0xf047f0da,0xf016effd,0xf1a9f0a1,0xf50ef331,0xf947f71a,0xfd4afb68,0xffc7febc,
0x01ef00ba,0x053b037a,0x08d00700,0x0c960aac,0x11480ec2,0x17691427,0x1e061ad1,0x23c320fc,
0x288f2656,0x2bb82a60,0x2d482cb7,0x2cd92d54,0x2a952be9,0x267028d1,0x1fe7236a,0x17b41bf7,
0x0f241359,0x07810b32,0x01110418,0xfc86fe8f,0xf8fffabe,0xf565f72d,0xf254f3d0,0xef53f0da,
0xec49edc4,0xe92eeacd,0xe670e794,0xe5c0e5d9,0xe6cee608,0xe9cde822,0xeda6eba9,0xf18defa9,
0xf4d7f354,0xf71bf610,0xf92cf822,0xfb14fa24,0xfcc7fbe9,0xff7afdf4,0x03560148,0x0791057f,
0x0bb00994,0x10600df1,0x15f3130c,0x1ba318e1,0x20fb1e47,0x25f623a5,0x285f27a3,0x28b22886,
0x29482913,0x279a28e0,0x229b257f,0x1a391ee1,0x0f4c14de,0x047909cd,0xfa9dff58,0xf2d8f670,
0xecf1efb8,0xe878ea85,0xe5aee6e3,0xe3efe4bc,0xe2b4e350,0xe171e208,0xe0e3e104,0xe1ade123,
0xe2e1e250,0xe3dae35d,0xe52de475,0xe72fe604,0xeac8e8d4,0xef4cecf0,0xf3fef1ad,0xf869f644,
0xfb3bfa17,0xfb85fbb6,0xf9b1faca,0xf756f871,0xf5a8f669,0xf4c3f524,0xf433f46f,0xf452f425,
0xf556f4c2,0xf6bdf600,0xf861f793,0xf9ecf923,0xfb5dfab6,0xfc43fbd9,0xfcf0fcae,0xfc59fcd1,
0xfa68fb8e,0xf7c3f91b,0xf534f672,0xf2def409,0xf062f1ab,0xee2cef1f,0xedbeedb8,0xefafee65,
0xf39df17a,0xf83af5f1,0xfc51fa6a,0xfeb7fdb6,0x00d2ffa3,0x03bc0234,0x07270564,0x0af808fb,
0x0ff90d4c,0x166b130d,0x1d1b19dd,0x22fc2020,0x27de259e,0x2b0629a9,0x2c6f2bf8,0x2bdd2c5f,
0x29e62b0b,0x261e284c,0x2022235d,0x18761c73,0x10611463,0x08f70c8b,0x031a05be,0xff3000f4,
0xfbe7fd96,0xf87afa25,0xf566f6ee,0xf1f9f3c0,0xeeb7f047,0xeb76ed1a,0xe902ea0b,0xe852e879,
0xe915e87f,0xeb47ea15,0xee24ec9e,0xf12fefb2,0xf3a9f285,0xf597f4a1,0xf762f68e,0xf8eaf827,
0xfaa8f9b2,0xfd74fbe7,0x017bff50,0x05f003bd,0x0abc083b,0x106c0d7c,0x16f813a0,0x1d1e1a2c,
0x22921feb,0x26ad24e8,0x27e3279f,0x280a27ee,0x27ac2813,0x24472665,0x1e1f218b,0x151519e9,
0x0a8c0fdc,0x00530555,0xf727fb92,0xeff6f34a,0xea8aed0d,0xe6f7e87c,0xe501e5d7,0xe3e8e45b,
0xe350e395,0xe312e328,0xe34be317,0xe45ee3c0,0xe533e4dd,0xe5d1e578,0xe6e2e649,0xe912e7c1,
0xece7eace,0xf1a6ef40,0xf662f406,0xfa83f89b,0xfc8efbe5,0xfbeefc87,0xf9a0fae1,0xf757f867,
0xf5adf671,0xf493f516,0xf3d2f428,0xf39ff39c,0xf438f3d4,0xf585f4ca,0xf778f66f,0xf9abf88a,
0xfc3dfaf7,0xfe7efd6d,0xffa7ff52,0xfee4ff7b,0xfc92fddb,0xf9c8fb2f,0xf718f86b,0xf465f5ca,
0xf11df2d5,0xee4fef85,0xed80ed9b,0xef2cee0b,0xf2c8f0d2,0xf70bf4dd,0xfb03f933,0xfd39fc4a,
0xff43fe28,0x02010089,0x056903a7,0x096b074a,0x0eb10bdf,0x150f11d2,0x1b391831,0x21121e35,
0x25de23ab,0x28ef279a,0x2a5b29e2,0x2a072a59,0x289a297b,0x25692745,0x200222f4,0x190d1cab,
0x11961552,0x0a970df6,0x055f07b5,0x01a5036a,0xfe47fff6,0xfb3ffca8,0xf857f9df,0xf4e3f69c,
0xf1caf34f,0xeec5f037,0xed03eda8,0xeca8ecb9,0xed2deccd,0xee54edb6,0xf01eef2a,0xf1cef101,
0xf339f28d,0xf461f3da,0xf538f4cf,0xf66df5bb,0xf842f73b,0xfb4df99c,0xffbdfd5a,0x04d9023a,
0x0ad307b8,0x11da0e2e,0x197e15bd,0x205e1d09,0x263b237c,0x29552834,0x2a4d29e7,0x2a422a7f,
0x27062933,0x20a5241a,0x17961c6d,0x0d20126d,0x02c707dc,0xf927fde3,0xf069f491,0xe998ecc5,
0xe4f2e6f0,0xe2f7e3a9,0xe263e2a0,0xe252e240,0xe314e299,0xe445e3aa,0xe591e4e9,0xe69ee62d,
0xe6f4e6d2,0xe7aae737,0xe917e838,0xec32ea66,0xf11eee7d,0xf68ff3e1,0xfb81f926,0xfedbfd74,
0xff85ff8a,0xfde2feed,0xfb68fca9,0xf91dfa3c,0xf6f2f808,0xf4eff5e2,0xf38cf429,0xf2d1f31b,
0xf2ebf2bf,0xf3e0f345,0xf61ff4d9,0xf9caf7c3,0xfe0ffbfd,0x0120ffd1,0x01ae01be,0xffe1010a,
0xfce1fe70,0xf9d3fb5b,0xf69af840,0xf2fdf4d8,0xeecef0ee,0xebb6ecfc,0xeaefeb04,0xecbdeb7e,
0xf074ee79,0xf511f2a4,0xf981f781,0xfbd0fae2,0xfd97fc9e,0x0075fede,0x04780259,0x093706b9,
0x0ed60bef,0x150411e8,0x1b101816,0x20de1e05,0x25a82371,0x28de2776,0x2a4329d3,0x2a342a57,
0x297a29fd,0x26d82877,0x223824ba,0x1c0c1f4e,0x14cf1883,0x0db8111c,0x087d0ad7,0x04a90686,
0x00ea02c5,0xfd9fff2c,0xfa36fc06,0xf64ef840,0xf2b1f478,0xef9af108,0xee37eeae,0xee04ee0d,
0xee53ee22,0xeec3ee82,0xef80ef1c,0xf06aeff2,0xf16cf0e8,0xf272f1fa,0xf2fef2b2,0xf435f380,
0xf663f52a,0xf992f7d7,0xfe1dfba7,0x03ce00d6,0x0aaf0714,0x12ed0ea5,0x1b981753,0x23181f8a,
0x28bd2630,0x2bf32aa2,0x2d102cc9,0x2b2f2c98,0x254528b0,0x1c6d2129,0x11fd1744,0x077a0cb6,
0xfdad0276,0xf4a4f914,0xec9ef06d,0xe6a9e949,0xe3bee4d8,0xe2ede32e,0xe2c5e2d5,0xe34de2e7,
0xe4b4e3ed,0xe63fe580,0xe74be6e4,0xe769e77a,0xe744e741,0xe7cbe769,0xe9ade882,0xedf0eb85,
0xf3b5f0bf,0xf956f6a0,0xfda7fbb6,0xff9afef7,0xff48ffa4,0xfd92fe8e,0xfb52fc7b,0xf8cafa1b,
0xf615f761,0xf40ef4fd,0xf2cdf353,0xf24cf277,0xf258f243,0xf370f2be,0xf621f485,0xfadef853,
0xff6cfd62,0x015200ba,0x00ac0143,0xfe9affb7,0xfc59fd7b,0xf9dafb25,0xf6e9f873,0xf315f51e,
0xeee5f0f8,0xebeaed2e,0xeb21eb2d,0xece9ebbf,0xf04eee75,0xf49cf26e,0xf7faf68e,0xf9caf8f7,
0xfbf3fabd,0xff80fd8e,0x03cb019e,0x08a7061f,0x0e4e0b56,0x14581156,0x1a4b174d,0x201e1d50,
0x24a2228e,0x27c3265e,0x293a28b1,0x29e02993,0x298029f0,0x2737288e,0x236c2586,0x1dea20e3,
0x170c1a94,0x1097139f,0x0bdd0e14,0x077209b1,0x034b0542,0xfffc01a4,0xfc20fe26,0xf7a0f9e2,
0xf349f565,0xf070f18e,0xefb9efe8,0xefe7efb5,0xf030f01f,0xf05af038,0xf076f077,0xf0c3f08c,
0xf177f113,0xf1cef1be,0xf1fbf1d0,0xf315f26b,0xf531f3fa,0xf872f6aa,0xfd1efa98,0x0387001b,
0x0b530742,0x14480fc3,0x1c831893,0x237a2023,0x289b2664,0x2b432a21,0x2c1b2c02,0x29382b40,
0x220d260a,0x18141d5f,0x0ce1127c,0x02600774,0xf92afda0,0xf0c1f4dc,0xe999ed06,0xe44de69e,
0xe1bde2b4,0xe103e139,0xe14fe106,0xe2bfe1dd,0xe510e3dd,0xe77ce650,0xe905e86c,0xe967e94d,
0xe9c6e985,0xea8dea18,0xecabeb54,0xf109ee9b,0xf666f3b1,0xfb95f90d,0xff79fdcc,0x00dd007c,
0x002500bf,0xfe17ff2e,0xfbf6fcfd,0xf9c3faf0,0xf758f885,0xf529f632,0xf382f440,0xf281f2f4,
0xf214f235,0xf2d7f23d,0xf5c5f3fc,0xfa88f813,0xfe99fccc,0x006effd3,0xffe50072,0xfe03fef5,
0xfc5afd31,0xfa79fb76,0xf7aaf942,0xf39af5b7,0xef3af159,0xec40ed82,0xeb45eb7b,0xec92eba9,
0xef7fede1,0xf358f164,0xf63cf4f9,0xf870f74c,0xfb42f9bb,0xfeecfcfd,0x0352010a,0x084005b6,
0x0de60b00,0x138a10be,0x1969166d,0x1eff1c52,0x236b2161,0x2690252e,0x28322787,0x293228c7,
0x28dd2940,0x26f32816,0x23ac2583,0x1ebb2169,0x186c1bac,0x1294154f,0x0dde102d,0x093e0b8d,
0x055f072a,0x022403c4,0xfe490052,0xf9cffc13,0xf592f795,0xf322f412,0xf282f2a9,0xf2f1f29e,
0xf348f335,0xf34df353,0xf299f30d,0xf1f1f22f,0xf1b2f1d1,0xf11ff17b,0xf0abf0c7,0xf13ef0d0,
0xf315f1ff,0xf638f47b,0xfae8f852,0x01c5fe1a,0x0a7a05df,0x14330f65,0x1cce18b4,0x23dd2089,
0x28bf269c,0x2b952a6c,0x2b662bfb,0x26d229a9,0x1e7c231c,0x13951924,0x08750dff,0xfe860342,
0xf5d1fa1a,0xedbbf1a9,0xe6f2ea28,0xe265e44f,0xe05be11c,0xe000e00a,0xe0a9e031,0xe288e176,
0xe503e3be,0xe788e657,0xe917e871,0xe9fee98f,0xeb1cea87,0xecadebcb,0xefc8edf1,0xf4a0f211,
0xf9f0f74b,0xfe9efc69,0x01a30068,0x02620246,0x01690219,0xff850083,0xfd70fe7e,0xfb14fc4d,
0xf899f9d9,0xf60af744,0xf403f4f1,0xf272f334,0xf193f1e2,0xf218f195,0xf50df34a,0xf93bf725,
0xfc18fae8,0xfd05fcc8,0xfc40fcd2,0xfb29fbb0,0xfa6ffab0,0xf9effa46,0xf806f92a,0xf49df683,
0xf0f0f2ad,0xee47ef6d,0xed74eda4,0xee78edbd,0xf108ef9a,0xf401f293,0xf663f53e,0xf8e7f793,
0xfc1ffa6e,0xffd6fdec,0x041801e7,0x08c7065a,0x0e080b64,0x133910a4,0x18a115e8,0x1db01b44,
0x21d11fd8,0x25092399,0x26fe261e,0x281227b2,0x27a0280b,0x260c26f7,0x232b24cc,0x1e9b2119,
0x18ce1bbe,0x13a01611,0x0eea114e,0x0a630c88,0x073108a6,0x041705bd,0x00140234,0xfb33fdbc,
0xf69ff8b6,0xf442f522,0xf3aef3d5,0xf412f3d2,0xf474f447,0xf47ef494,0xf387f416,0xf2a3f30c,
0xf197f223,0xf06af102,0xefeaf00c,0xf031efea,0xf1e0f0d9,0xf508f342,0xfa42f744,0x0250fdfe,
0x0c9c073e,0x171c120c,0x1fe51bba,0x26c8239b,0x2b5a295c,0x2d1d2caa,0x2a902c79,0x237b2782,
0x191b1e97,0x0d891362,0x022f07b5,0xf869fd14,0xeff3f418,0xe89dec19,0xe2f2e585,0xdf78e0ee,
0xde00de80,0xde0dddda,0xdfa8de9d,0xe28ae104,0xe593e417,0xe7fbe6e8,0xe966e8c3,0xeac9ea03,
0xeccaebbb,0xef88ee00,0xf3d8f17f,0xf923f671,0xfe2cfbc6,0x01d3003b,0x035d02d7,0x03680388,
0x02560302,0x007a0177,0xfe29ff5b,0xfba4fcf0,0xf8d2fa3a,0xf651f785,0xf459f548,0xf2bdf37d,
0xf1f6f22f,0xf344f24c,0xf6bff4d5,0xfa08f895,0xfb60fafa,0xfa99fb37,0xf8a8f9a9,0xf72ff7c4,
0xf6d2f6ef,0xf67ef6b3,0xf596f630,0xf3bef4b3,0xf1a6f2b0,0xf041f0d3,0xefe7efe8,0xf0fdf04f,
0xf2c8f1d3,0xf46bf3b0,0xf5e0f50e,0xf8aaf717,0xfc4cfa72,0x0022fe29,0x044e0231,0x08db0689,
0x0d6b0b2b,0x12230fb9,0x171114a0,0x1b6e1957,0x1f711d73,0x22d0213c,0x25802445,0x26c6265a,
0x269b26d7,0x256d262b,0x23092466,0x1f472153,0x1abf1d03,0x164a188d,0x114e13e2,0x0ce00ee4,
0x09b50b31,0x064d0817,0x0225045b,0xfd06ff9d,0xf8e1fab5,0xf6cef7a2,0xf64cf658,0xf6bff689,
0xf739f6fa,0xf6e7f73b,0xf5a7f64e,0xf407f4e6,0xf235f320,0xf0aaf160,0xefb0f014,0xefb4ef85,
0xf116f03a,0xf3eff245,0xf974f64f,0x021dfd67,0x0cca0759,0x16ee1215,0x1f551b59,0x25d722d7,
0x2a3c2857,0x2b092b32,0x270829a6,0x1ece2363,0x13b81978,0x07d30dcd,0xfca80209,0xf31df7b4,
0xeadaeed2,0xe445e755,0xdfb0e1b0,0xdd35de3d,0xdc68dca3,0xdd45dc9a,0xdfeade63,0xe369e1a2,
0xe6aee520,0xe8e6e7f0,0xea57e9a9,0xec23eb24,0xeec2ed57,0xf2a5f07e,0xf80df535,0xfde6fb03,
0x02a1007c,0x0545043f,0x05d905b7,0x053d05b0,0x03da049b,0x021102fc,0xfff20113,0xfd77febd,
0xfaa4fc15,0xf7def937,0xf58ff6ab,0xf3c4f48e,0xf356f34c,0xf55ef409,0xf8aef70e,0xfa91f9e9,
0xfa55fab2,0xf837f97b,0xf570f6d4,0xf348f431,0xf291f2c2,0xf271f281,0xf1fcf248,0xf160f1b6,
0xf093f0f4,0xefddf033,0xf002efc1,0xf149f090,0xf2d5f219,0xf3c3f35a,0xf545f450,0xf85df6ab,
0xfc65fa51,0x008afe78,0x04bf029f,0x09570702,0x0dec0ba9,0x129f1041,0x172414f6,0x1b041926,
0x1ea91cda,0x22122065,0x251d23b7,0x2681260a,0x26a226ae,0x25b02652,0x23a224cb,0x20662226,
0x1c961e81,0x18641a94,0x137b15fd,0x0f3d112c,0x0bee0d93,0x081b0a22,0x036205d0,0xfdf000b3,
0xf95efb6a,0xf6baf7d0,0xf5edf622,0xf617f5f4,0xf69ff65b,0xf66bf6a3,0xf57df606,0xf3fbf4c7,
0xf261f32c,0xf11df1ad,0xf04ff0a5,0xf050f02f,0xf199f0c9,0xf46ef2bc,0xfa4df6ee,0x03a6fe92,
0x0ef00943,0x18fe143f,0x214e1d4b,0x281324fc,0x2b722a50,0x2a292b62,0x244427d2,0x1a531fa7,
0x0ee014ac,0x032308ff,0xf835fd7f,0xeeaaf34a,0xe691ea58,0xe105e37a,0xddaddf21,0xdb9bdc7e,
0xdae4db0c,0xdc29db43,0xdf27dd7f,0xe294e0e7,0xe558e40f,0xe73de664,0xe8e8e80b,0xeb79ea11,
0xef4ced31,0xf4b3f1d4,0xfb19f7d5,0x0129fe4a,0x05a403b0,0x07c406f2,0x08370826,0x07ad080a,
0x064d0718,0x04520557,0x022b0341,0xffb70102,0xfce5fe55,0xfa24fb78,0xf79df8d9,0xf5adf67f,
0xf5acf565,0xf7daf690,0xf9e1f91c,0xf9ecfa1d,0xf832f942,0xf584f6f2,0xf27df3fe,0xf01ff12b,
0xeedcef59,0xeec2eeb6,0xef0ceeea,0xef5bef38,0xefb6ef90,0xefd8efb4,0xf0b1f037,0xf219f156,
0xf306f2ba,0xf31af308,0xf49bf38b,0xf82ef632,0xfc65fa5a,0x001dfe4b,0x03e301f4,0x0848060f,
0x0c9a0a6f,0x112d0edd,0x1599136f,0x19ab179e,0x1dd11bc3,0x22001fe3,0x25b72409,0x278d26dd,
0x280327ed,0x272d27c3,0x2517263f,0x220923aa,0x1e6f2047,0x1a161c6b,0x14e7177f,0x10e812ae,
0x0dbe0f5b,0x0a350c00,0x058c081b,0xffd302b6,0xfb28fd44,0xf7f0f965,0xf68ff6fe,0xf658f662,
0xf6c6f681,0xf6d8f6ef,0xf619f68a,0xf4caf582,0xf354f407,0xf1ccf291,0xf0adf126,0xf0a1f076,
0xf228f13a,0xf576f37b,0xfc30f865,0x05dc00aa,0x10d70b72,0x19e215a4,0x21821dc9,0x274c24cf,
0x28ee28af,0x25f12800,0x1ec822d8,0x14c719f7,0x09f80f65,0xfecd0466,0xf455f974,0xead8ef71,
0xe36be6c4,0xdebce0c7,0xdbebdd2a,0xda4cdaf3,0xda10d9f8,0xdbe5dab4,0xdf40dd7c,0xe298e100,
0xe53fe404,0xe794e663,0xea38e8d0,0xedb9ebd6,0xf276efed,0xf861f559,0xfebffb92,0x046401bb,
0x0827068d,0x09d40938,0x09f60a08,0x090409a0,0x07360834,0x050b0621,0x02e103ff,0x005301ab,
0xfd89feeb,0xfad1fc2c,0xf850f98c,0xf672f72f,0xf6a9f643,0xf83df775,0xf89df89e,0xf7a4f847,
0xf591f6b4,0xf2b5f443,0xef5bf103,0xec7fedd7,0xeaa9eb67,0xea55ea53,0xeb18ea93,0xec79ebc0,
0xee0fed3f,0xefe6eee9,0xf251f11a,0xf428f35e,0xf467f485,0xf409f418,0xf592f486,0xf8f4f71d,
0xfcaefae4,0xffeffe4c,0x03b801b2,0x08440601,0x0c980a72,0x11200ed4,0x15791361,0x198b1781,
0x1dd21ba4,0x22732017,0x267924a8,0x289227bf,0x291128fd,0x282428c3,0x26302746,0x237824e9,
0x201321e0,0x1b711df2,0x161918bb,0x120613e0,0x0e84104a,0x0aa00ca5,0x058d0849,0xfff202ad,
0xfb53fd7a,0xf7caf968,0xf62df6bd,0xf607f5f1,0xf6def66e,0xf742f727,0xf6cbf72a,0xf5aaf644,
0xf459f509,0xf2a7f38a,0xf151f1df,0xf165f124,0xf2ebf1ff,0xf6abf461,0xfdb7f9d6,0x07530238,
0x11960c9f,0x1a31160e,0x218a1e0b,0x266a2472,0x26c8272e,0x22a8253e,0x1afb1f39,0x10f21617,
0x06870bc4,0xfc12013d,0xf238f710,0xe926ed87,0xe223e556,0xdd5edf7f,0xda61dbb2,0xd8c9d968,
0xd8d2d88d,0xdb1bd9b2,0xde9bdcd3,0xe1d8e04b,0xe48ce33f,0xe73be5dc,0xea51e8b2,0xee3eec2b,
0xf366f0a8,0xf988f661,0xffc4fcb1,0x050c029d,0x0889070a,0x0a0e098a,0x0a340a41,0x095509de,
0x080408bb,0x06960748,0x051805df,0x03180429,0x00cc01f7,0xfe48ff91,0xfb96fced,0xf9bbfa72,
0xf991f96d,0xf9eff9d8,0xf946f9bb,0xf796f88f,0xf4dcf651,0xf14ff32e,0xed49ef4d,0xe9b7eb63,
0xe782e862,0xe6d4e705,0xe755e6f5,0xe8cee7f4,0xeae8e9c7,0xedf4ec3f,0xf1a4efdb,0xf434f32c,
0xf4c7f4a9,0xf595f505,0xf7bff67c,0xfacef939,0xfdb7fc4e,0x009aff22,0x0418023e,0x07f80604,
0x0c530a13,0x10c30e94,0x14c912d0,0x18b316c4,0x1ccb1aa8,0x21731f1e,0x25512394,0x27a126a7,
0x28812836,0x28442888,0x26f027ba,0x24dc25f7,0x21ba2384,0x1cc31f71,0x17ae1a12,0x13ac1591,
0x0fc611c2,0x0b710db4,0x05f408d3,0x00920326,0xfbecfe2c,0xf862f9ea,0xf680f737,0xf682f648,
0xf72bf6da,0xf784f76c,0xf725f76c,0xf638f6bc,0xf52af5c0,0xf38af460,0xf280f2e5,0xf2abf262,
0xf464f34e,0xf8c3f62e,0x0011fc0a,0x09ee04d5,0x135a0edc,0x1bb5179e,0x22731f63,0x25b624a3,
0x241c2586,0x1e202196,0x154119e8,0x0b841062,0x01d106ab,0xf85afd07,0xef11f3b5,0xe697ea9f,
0xe04ae323,0xdc2ede01,0xd995dab7,0xd840d8c8,0xd8add82d,0xdb3ad9c0,0xde66dce0,0xe0ffdfc3,
0xe366e22d,0xe63ee4bb,0xea1ce80b,0xef05ec68,0xf509f1e9,0xfb95f854,0x0195fead,0x064d042f,
0x095c0807,0x0ae10a43,0x0b670b4a,0x0ad70b3c,0x09940a41,0x080e08d7,0x0654073c,0x04490553,
0x02090336,0xff7800c9,0xfcdbfe19,0xfb94fc02,0xfba6fb87,0xfaebfb7d,0xf8e5fa07,0xf631f79f,
0xf2f2f4a9,0xef00f107,0xeabbece5,0xe6c3e8a2,0xe440e549,0xe36fe39d,0xe40fe399,0xe5b5e4c3,
0xe899e6f4,0xed1deab3,0xf1d5ef8d,0xf4f9f3ba,0xf64df5b2,0xf823f71c,0xfad6f969,0xfd44fc27,
0xff22fe38,0x0147001b,0x043902b0,0x07a605d5,0x0bf609b6,0x10490e2f,0x145b1256,0x18591653,
0x1cf61a87,0x21f51f84,0x25ce2406,0x2882275b,0x29ad2944,0x299029c6,0x28442902,0x26692770,
0x22a324df,0x1d101fee,0x18091a68,0x13b715d9,0x0f82119e,0x0ac90d47,0x0576080e,0x00ae030d,
0xfc31fe58,0xf8dffa65,0xf6e9f79c,0xf6b8f6b2,0xf735f6ee,0xf761f759,0xf72df75b,0xf6b3f6ef,
0xf5a7f64c,0xf45df4fb,0xf387f3d4,0xf3e3f392,0xf602f496,0xfb0df835,0x02ddfe95,0x0c3d0796,
0x1499108e,0x1c541885,0x224a1fb9,0x23fe23c9,0x20a422df,0x197d1d79,0x103914f5,0x06c30b7a,
0xfd770215,0xf478f8f0,0xebb5f005,0xe462e7c5,0xdf49e18f,0xdbf8dd7a,0xd9c7daba,0xd8b9d90d,
0xd9ced8fa,0xdc96db19,0xdf21ddfc,0xe0eee01a,0xe2f3e1d8,0xe5fae44b,0xea5ce804,0xefe5ecfe,
0xf667f313,0xfcf1f9bb,0x02a9fff0,0x06c104f3,0x0952082f,0x0afb0a3b,0x0bac0b7a,0x0b390b9b,
0x0a1d0aad,0x08d10981,0x073e080e,0x05aa0676,0x03cb04cc,0x017b02ad,0xff750052,0xff05ff0f,
0xfe99fefe,0xfc44fda9,0xf8c6fa94,0xf4f8f6d8,0xf108f30d,0xecafeeed,0xe808ea5e,0xe3eae5d0,
0xe16ce26f,0xe099e0d5,0xe145e0c5,0xe2f3e1fe,0xe5f6e43d,0xeac1e82f,0xefd9ed69,0xf33df1c7,
0xf5fdf48b,0xf9d8f7c6,0xfdd6fbf2,0x009bff65,0x025d018e,0x043d033b,0x066a0553,0x0905079b,
0x0c540aa3,0x0fa90e00,0x1352116d,0x1782155f,0x1c5919d6,0x21491ee8,0x2565236b,0x28612716,
0x29d6294a,0x29e12a05,0x28ec297b,0x270a282d,0x23072556,0x1d96204f,0x18a01b07,0x13db1640,
0x0f75119e,0x0a620d0c,0x056107c1,0x00f2032e,0xfc97fea9,0xf965fad6,0xf785f83f,0xf720f72e,
0xf7a8f753,0xf7cff7d6,0xf7ddf7c8,0xf7a7f7df,0xf69cf734,0xf57df5fb,0xf53ef540,0xf625f583,
0xf97df767,0xffc2fc4c,0x087603e3,0x11150cf1,0x19311518,0x20951d2d,0x23e522e7,0x21e9238b,
0x1b6c1f1f,0x1247170a,0x08d50d80,0xffa7043c,0xf698fb18,0xedd6f233,0xe5c8e98f,0xe065e2bf,
0xdce7de87,0xda27db71,0xd85bd91d,0xd7f2d7f4,0xd982d880,0xdbb7daa2,0xdd3adc92,0xdeadddd9,
0xe14adfd1,0xe5a2e33d,0xebb7e884,0xf2adef19,0xf9dcf650,0x0012fd1f,0x04cd02a5,0x0828069a,
0x0ad1098e,0x0cf60c04,0x0dcc0d8f,0x0d2c0d9d,0x0c450cb5,0x0b2e0bc6,0x09fa0a8d,0x08bd0968,
0x072007f8,0x057e0642,0x049d04e5,0x0431048a,0x0191033e,0xfcc2ff57,0xf778fa0d,0xf2f0f528,
0xee73f0bc,0xe99cec11,0xe4a3e720,0xe096e25d,0xde4edf40,0xdd93ddc1,0xde01ddbb,0xdf64de7f,
0xe2ace0cd,0xe70ee4d2,0xeb54e93f,0xef0aed3c,0xf387f101,0xf9bef68d,0xff28fcb1,0x025b010b,
0x04040337,0x05d604ee,0x07ae06bd,0x09c708ad,0x0c780b10,0x0f690de1,0x131f1123,0x1796154b,
0x1c921a03,0x21891f1f,0x261223e4,0x298a27fa,0x2b872ab7,0x2c2d2c02,0x2bad2c08,0x29a52aed,
0x255a27c5,0x1fef22aa,0x1a861d3b,0x151f17ce,0x0fe2127e,0x0a7c0d2c,0x05a807fc,0x01290369,
0xfd24ff07,0xfa35fb87,0xf8c6f94c,0xf899f88c,0xf8d3f8bd,0xf8cff8d6,0xf8eaf8d5,0xf88cf8db,
0xf768f80d,0xf673f6c9,0xf6a7f66d,0xf83af737,0xfc4bf9e4,0x02e7ff4c,0x0b3406ff,0x12e70f27,
0x1a7016b2,0x203e1dc2,0x21392179,0x1cdb1f98,0x14dc1939,0x0b701024,0x025e06d5,0xf9e2fe15,
0xf1adf5c4,0xe985ed8e,0xe2dfe5da,0xdecde091,0xdc09dd58,0xda10daf3,0xd906d966,0xd91fd8e3,
0xda80d9b8,0xdbd0db41,0xdc98dc33,0xde04dd25,0xe0dedf38,0xe5d4e311,0xec8ae910,0xf3f5f030,
0xfb33f7b7,0x0136fe63,0x0588038c,0x08e6074d,0x0bc60a5b,0x0de50cff,0x0eb50e79,0x0ea30eba,
0x0e260e75,0x0d3b0db7,0x0c3b0cb8,0x0b170baa,0x09cc0a7e,0x08ba0928,0x084e087d,0x06d707e0,
0x02a40508,0xfcccffcb,0xf71ff9d6,0xf1fef492,0xecf1ef7b,0xe76eea46,0xe1dae489,0xdd95df7e,
0xdb23dc24,0xda8bda9f,0xdb17dab6,0xdd0fdbd3,0xe0aedeb6,0xe4c8e2c5,0xe855e6a9,0xebc4e9e3,
0xf1a6ee5e,0xf8daf536,0xff3afc55,0x0310016b,0x056e045a,0x0777067d,0x08ec083d,0x0ad009c2,
0x0d110beb,0x0fc50e4f,0x1370117c,0x17f91597,0x1d3a1a98,0x22321fc3,0x26bf248a,0x2a9e28cd,
0x2d502c23,0x2e5a2e05,0x2e532e7a,0x2c712db3,0x281d2a81,0x22d22586,0x1d1f2009,0x16fd1a14,
0x10c813ec,0x0aa10d9b,0x059d07fe,0x00f20341,0xfd21fee4,0xfa5ffb94,0xf928f990,0xf925f913,
0xf952f945,0xf94af942,0xf957f95f,0xf87ef909,0xf726f7d5,0xf68df6b0,0xf763f6ca,0xfa07f867,
0xfef3fc40,0x05f90237,0x0da309e7,0x14da1136,0x1bf11889,0x1ff51e92,0x1e2e1fd1,0x17a01b5a,
0x0e891341,0x053e09d0,0xfc9000ca,0xf482f881,0xecbcf097,0xe581e8f5,0xe073e2a9,0xdd63deca,
0xdb44dc36,0xd9f2da84,0xd96ad993,0xd9f9d993,0xdaf8da7e,0xdb7bdb4d,0xdc1ddbaa,0xde1edced,
0xe1e6dfc2,0xe7f8e4b1,0xef2ceb80,0xf6b9f2f4,0xfd72fa36,0x0282003f,0x060f0462,0x090a0797,
0x0bc00a75,0x0d8c0ccb,0x0e630e0c,0x0ee90eb2,0x0f0b0f04,0x0ef90f01,0x0ec10eea,0x0e4e0e8a,
0x0d9a0df9,0x0d170d4b,0x0c440ce0,0x09160b07,0x03450679,0xfc8affd8,0xf66ff972,0xf0aaf384,
0xead4edca,0xe4cde7cf,0xdf64e1f3,0xdb82dd3d,0xd96cda39,0xd8ded905,0xd96cd8f8,0xdbc7da58,
0xdf34dd7a,0xe22de0c4,0xe47ae366,0xe7dce5cf,0xee68eacb,0xf67ef271,0xfd49fa2b,0x0248fff2,
0x06350458,0x092607df,0x0ae50a0f,0x0c9f0bc7,0x0e490d71,0x10890f44,0x13f21219,0x18b4161d,
0x1e111b74,0x22d0207e,0x2742250b,0x2b8d2979,0x2e9e2d4f,0x30072f78,0x3045305a,0x2e222f91,
0x29cc2c1b,0x24c62754,0x1f25220e,0x18dc1c0e,0x11c2156c,0x0b130e38,0x05900842,0x00a202f2,
0xfd34fec5,0xfb07fbee,0xfa4dfa85,0xfa64fa45,0xfac5fa97,0xfb04fae5,0xfaaafafb,0xf935fa08,
0xf77cf84d,0xf6def6ff,0xf7b4f719,0xfa91f8dc,0xff86fcc9,0x068a02db,0x0da80a3a,0x145e10f1,
0x1b3117f3,0x1e401d6c,0x1b761d8e,0x143d184a,0x0a680f73,0x00df058b,0xf834fc6b,0xf02ef420,
0xe8b3ec5e,0xe231e541,0xddf6dfbc,0xdbd6dcba,0xdabadb2b,0xda71da7c,0xdaf9da93,0xdc69dba0,
0xdd6ddd16,0xdd32dd69,0xdd58dd17,0xdeffddfe,0xe29de072,0xe8b1e56b,0xf018ec4b,0xf7faf415,
0xfec9fb9f,0x035a0157,0x066304f9,0x090d07b4,0x0bbc0a68,0x0de00cea,0x0f110e94,0x0fda0f7f,
0x10331015,0x1037103c,0x10001023,0x0f7c0fca,0x0eb70f1a,0x0ea30e99,0x0e2d0e9c,0x0ad90cf7,
0x048907f2,0xfd2a00db,0xf663f9ab,0xeff4f32a,0xe989ecc1,0xe320e64c,0xddade032,0xd9cedb87,
0xd799d873,0xd742d73c,0xd850d795,0xdb44d992,0xdecddd16,0xe196e053,0xe33be26e,0xe667e469,
0xecd5e950,0xf489f0ad,0xfb41f81c,0x00acfe13,0x05a40329,0x09a207d5,0x0c2c0b0d,0x0de30d13,
0x0f690eaa,0x11631047,0x144112ae,0x18c91656,0x1dc01b4a,0x2271201c,0x273c24d0,0x2c0429aa,
0x2fa52e13,0x31b630d2,0x32633249,0x308631d0,0x2c7e2ea6,0x27812a1e,0x2180249f,0x1a441e14,
0x12091631,0x0ac60e2f,0x04b807ad,0xffbc01f9,0xfc71fdef,0xfa79fb43,0xfa20fa24,0xfa87fa45,
0xfb32fad1,0xfbf2fba0,0xfb97fbf6,0xf9fefae2,0xf85af915,0xf804f7f4,0xf993f88c,0xfd82fb37,
0x039b0057,0x0ad90731,0x11d00e62,0x18d61557,0x1e2c1bf6,0x1e361eff,0x187f1bea,0x0f44142d,
0x05100a28,0xfb650013,0xf2aff6fd,0xea51ee6e,0xe2e7e675,0xdd63dfce,0xda68dbae,0xd8ded97a,
0xd865d881,0xd934d8a8,0xdae7d9f5,0xdcb2dbe8,0xdccadcfb,0xdbc7dc41,0xdbd4dba0,0xddb1dc7d,
0xe246df97,0xe92ce58f,0xf103ecff,0xf8d7f4fd,0xff28fc51,0x03480166,0x069304f7,0x09f1083f,
0x0d1d0b9a,0x0f360e4e,0x10d0100b,0x11ef116f,0x12a51259,0x130212de,0x133d131e,0x13451345,
0x13c4136d,0x1483143c,0x12f7142e,0x0e0010ef,0x06640a58,0xfea4027a,0xf70bfacb,0xef75f341,
0xe7daeba4,0xe0e4e443,0xdb46dde1,0xd722d8fd,0xd4ced5c0,0xd421d43c,0xd57bd48a,0xd8a6d6ef,
0xdbe3da5c,0xde35dd33,0xe013df01,0xe470e1d8,0xeb33e7ae,0xf215eeb5,0xf83ff53c,0xfe19fb31,
0x03e30109,0x08db0686,0x0c980ae8,0x0f0d0e00,0x10ba0fdf,0x12d311bd,0x15a7140d,0x1a0617b2,
0x1eae1c63,0x233920e8,0x284525aa,0x2d922af8,0x31a52fd6,0x342a3312,0x34ed34d6,0x33273455,
0x2fbb3195,0x2afd2d92,0x245e27ec,0x1c13206f,0x12e2176c,0x0b010ebe,0x04310780,0xff11015e,
0xfbdafd41,0xfab7fb04,0xfaccfaac,0xfbabfb24,0xfd28fc60,0xfe23fdc8,0xfda2fe1a,0xfbecfcdc,
0xfa89fb0c,0xfad7fa7f,0xfcf3fb9e,0x0135fed7,0x071003fd,0x0d650a46,0x138d106f,0x199016c4,
0x1c271b71,0x19391b63,0x11c415f1,0x08100d05,0xfe550321,0xf53cf9b4,0xec9af0eb,0xe471e864,
0xddeae0ec,0xd9e3db91,0xd7c8d8af,0xd6cad72c,0xd71ad6c1,0xd8d2d7d0,0xdb42da05,0xdcd0dc41,
0xdc43dcbf,0xdb7ddbc0,0xdc3edb9e,0xdf1edd56,0xe4e7e1b1,0xec42e87a,0xf42ff039,0xfb59f7f5,
0x007cfe30,0x03f10255,0x07270586,0x0a8d08dc,0x0d710c1f,0x0f8d0e92,0x116b1086,0x12e51233,
0x1429138b,0x154314b9,0x162f15bf,0x1721169e,0x188217cc,0x189e18ef,0x1564176b,0x0ec01274,
0x06900aad,0xfe700277,0xf646fa62,0xedf9f21f,0xe641ea01,0xdfb2e2c9,0xda65dce3,0xd675d843,
0xd40bd50e,0xd35dd374,0xd4b5d3c4,0xd789d612,0xda07d8e2,0xdb9ddaea,0xdde4dc76,0xe306e021,
0xe988e644,0xef83eca0,0xf52ef25d,0xfb06f805,0x0113fe1b,0x064d03c9,0x0adb08b1,0x0e100ca2,
0x109a0f58,0x131011d5,0x16551483,0x1acf1880,0x1f451d0c,0x24052191,0x298d26ae,0x2eeb2c5c,
0x33033124,0x35b8348e,0x3661365d,0x34e935d0,0x325f33c4,0x2e403096,0x27b52b48,0x1ed02391,
0x14e819ca,0x0c071056,0x046f0802,0xff040176,0xfbbdfd0c,0xfaccfb12,0xfab7faa8,0xfbd2fb1d,
0xfdc2fcc2,0xff40fea7,0xff35ff67,0xfe47fece,0xfe06fdf1,0xff43fe79,0x0255008e,0x06bd0474,
0x0bde0937,0x11730eaa,0x16d4142c,0x1a421903,0x18ff1a56,0x12d31660,0x09ff0e9e,0x009c054d,
0xf7a3fc0b,0xef15f354,0xe66feac0,0xdec3e259,0xd942dbb9,0xd5d5d74e,0xd3fdd4c0,0xd3b0d39e,
0xd520d42e,0xd7d6d65f,0xda94d950,0xdbbadb66,0xdb61dba0,0xdb7fdb40,0xdd62dc36,0xe1a1df2a,
0xe808e4ab,0xef31eb91,0xf634f2c8,0xfc06f951,0x0076fe67,0x0419024d,0x07bb05ed,0x0b39098b,
0x0e260cbe,0x10f90f8a,0x136a1245,0x157f147e,0x17441665,0x18f31823,0x1aa119c9,0x1c691b82,
0x1d691d27,0x1b681cd4,0x16301932,0x0e99128a,0x06820a8e,0xfe4c026f,0xf5b0fa0d,0xeceff13f,
0xe521e8db,0xdec0e1c9,0xd967dbf0,0xd4f3d714,0xd1e1d321,0xd147d14b,0xd2c6d1c8,0xd522d3f3,
0xd714d633,0xd8d3d7e3,0xdc55da3a,0xe220df0f,0xe815e537,0xed67eabe,0xf2e3f01e,0xf8daf5d4,
0xfe9afbc6,0x0437016f,0x093c06d9,0x0d3b0b53,0x10990efe,0x13be1223,0x1775157e,0x1b8e1983,
0x1fff1db3,0x25342273,0x2b59283a,0x311a2e56,0x35fd33a5,0x392537eb,0x39a439b0,0x38953935,
0x368637bf,0x323a34b7,0x2b2a2f11,0x215b2687,0x16e21c15,0x0d0611d4,0x04ec08ae,0xfef601b2,
0xfb7bfce1,0xfa10fa9b,0xf9c3f9c7,0xfae5fa23,0xfcbefbcf,0xfe5efdb0,0xfec5feb6,0xfe8dfea7,
0xff1bfeae,0x00a5ffbb,0x03d2020d,0x07f105cc,0x0cb50a41,0x11d80f3a,0x16e3147f,0x18f41877,
0x16571841,0x0f34133d,0x06080ab0,0xfcbf014f,0xf402f854,0xeb61efbd,0xe2bfe6fb,0xdb98dee9,
0xd6f3d8ee,0xd431d56c,0xd2e1d354,0xd34bd2d8,0xd577d433,0xd8d3d709,0xdbd4da8b,0xdc9edc87,
0xdc19dc65,0xdc59dc04,0xde68dd15,0xe31fe076,0xe953e615,0xf044ecc5,0xf6d3f3b4,0xfbdff987,
0xffdafdfc,0x03590198,0x07080528,0x0aa708e9,0x0de50c4e,0x10d00f68,0x1342121a,0x15811462,
0x17bd1697,0x1a1618ec,0x1ca01b4c,0x1f361dfa,0x20332018,0x1dbd1f5e,0x17e61b3b,0x10231413,
0x08040c1d,0xff9303df,0xf657fb0f,0xed38f1ac,0xe559e913,0xdee5e1ff,0xd953dbf9,0xd498d6db,
0xd182d2c0,0xd0d7d0e7,0xd233d159,0xd3fdd31e,0xd552d4b9,0xd733d604,0xdba6d915,0xe1aedea2,
0xe723e48f,0xec0de99a,0xf12eee88,0xf69ef3ef,0xfbc2f92c,0x0136fe70,0x065503e8,0x0abc088f,
0x0eff0cea,0x1332110d,0x1798156e,0x1bb8199e,0x204b1df5,0x25d522e6,0x2c2728f9,0x32202f32,
0x37a93508,0x3add39ac,0x3b633b56,0x3b393b5a,0x39b73ac7,0x357237ef,0x2e1d322d,0x24452967,
0x19901ef2,0x0f2f1432,0x06d90ac2,0x006d0353,0xfcbbfe4c,0xfa8efb83,0xf9daf9f8,0xfacafa2a,
0xfc8efb95,0xfe52fd89,0xff67feed,0x003dffc4,0x01dc00f7,0x044e02e8,0x07c60600,0x0b950999,
0x10490ddb,0x14f412b8,0x178a16b0,0x162b1760,0x104313c1,0x076f0c07,0xfe3802cc,0xf57bf9c7,
0xed58f15c,0xe522e941,0xddc4e137,0xd890dae4,0xd55cd6c9,0xd335d42d,0xd251d28e,0xd32bd28a,
0xd567d422,0xd85cd6e4,0xda6ed99d,0xdadddacf,0xdaf8dacc,0xdc76db88,0xe038ddfd,0xe623e304,
0xecc1e96a,0xf357f019,0xf8dbf64a,0xfd22fb1d,0x00b1fef5,0x04080265,0x075105ae,0x0a7e08ea,
0x0dcf0c1d,0x11370f89,0x146c12d8,0x176c15f6,0x1a7318ea,0x1d971bf4,0x21151f4c,0x23c022aa,
0x231d23e8,0x1f062180,0x17ea1bb9,0x0fe613f4,0x07a30bcb,0xfecc0355,0xf530f9ff,0xec5ff09d,
0xe4fee886,0xdee0e1ce,0xd94bdc0c,0xd48dd6c5,0xd176d2c0,0xd076d0b6,0xd10ed0a7,0xd22ad193,
0xd350d2ba,0xd575d41d,0xd9fdd777,0xdf8adcc4,0xe49de220,0xe9afe71e,0xef28ec62,0xf477f1e4,
0xf956f6e8,0xfe51fbd3,0x030f00b8,0x07bb0563,0x0ca80a1c,0x12340f62,0x176e14e7,0x1c3319cf,
0x218e1ec1,0x27bd2497,0x2df82ae3,0x340930fa,0x39ac370e,0x3cae3b9e,0x3d603d23,0x3d8d3d91,
0x3bf93d17,0x37c33a37,0x30703485,0x269f2bbf,0x1b84212b,0x10e915f5,0x084c0c6e,0x01880497,
0xfd47ff27,0xfa94fbbf,0xf9c1f9e0,0xfab8fa1e,0xfc9cfb8a,0xfeccfdc0,0x00a2ffb7,0x030001b4,
0x05ed0474,0x08fa0762,0x0c230a9a,0x0fcf0dcc,0x13f411fa,0x16921591,0x15e716ad,0x11691438,
0x09740db2,0x007504ee,0xf7fffc2a,0xefdcf3d7,0xe818ebfe,0xe059e41a,0xda46dd0e,0xd619d7fa,
0xd358d492,0xd1aed254,0xd1b5d17d,0xd33dd254,0xd589d455,0xd7bdd6b7,0xd8ecd882,0xd93ad915,
0xda80d9b0,0xdd88dbbd,0xe2dadfe7,0xe960e616,0xefa9ec94,0xf53ef297,0xf9b4f79d,0xfd56fb95,
0x00c5ff0e,0x041a0271,0x075305b1,0x0ad9090e,0x0ea00cbf,0x12661083,0x15ef1437,0x197117a5,
0x1d2e1b45,0x213c1f38,0x24dd2332,0x262525f5,0x23fe2575,0x1ec021b2,0x17781b4a,0x0f6b1377,
0x07010b4b,0xfdaf0274,0xf43ff8e6,0xec11eff7,0xe52fe878,0xdf32e224,0xd951dc3b,0xd446d69f,
0xd0fad263,0xcf73cffe,0xcf91cf64,0xd063cfe6,0xd1b9d0f9,0xd4a2d2e9,0xd94bd6cb,0xde64dbe8,
0xe34ae0d3,0xe882e5d9,0xee14eb4b,0xf2f6f09f,0xf75ef52e,0xfb8af97e,0xff97fd91,0x040d01bb,
0x098906a7,0x0fd50ca7,0x15de12eb,0x1bed18d7,0x22891f2e,0x296225f9,0x2fcc2ca7,0x368c331a,
0x3c6539c2,0x3f673e3c,0x4124404b,0x420541ce,0x405b418d,0x3bc73e75,0x3406383f,0x2a182f4f,
0x1eba2474,0x13fb192b,0x0a980f1e,0x036306a8,0xfe4300a1,0xfafcfc5d,0xf9e4fa2f,0xfa5bf9f5,
0xfc58fb2c,0xff02fdaa,0x02240076,0x06020409,0x09b407ea,0x0ce30b69,0x0f8d0e28,0x13491162,
0x15c714d0,0x152d15e5,0x112b13aa,0x097a0da8,0x00860505,0xf83afc4b,0xf076f449,0xe8efecad,
0xe140e51e,0xdac5ddb8,0xd658d859,0xd366d4b6,0xd1b2d26c,0xd16fd162,0xd282d1ce,0xd458d369,
0xd62dd549,0xd773d6ed,0xd7ebd7c3,0xd89bd81f,0xdb09d986,0xdfd2dd2a,0xe674e304,0xed14e9db,
0xf2afefff,0xf74bf51e,0xfb24f947,0xfeacfced,0x01da005c,0x0497033c,0x0797060a,0x0b200948,
0x0ef40d02,0x12d410e8,0x16ab14bc,0x1afe18c0,0x20151d77,0x251722b0,0x27f326ee,0x2743280c,
0x23bd25d2,0x1e0f211e,0x17091aa7,0x0f44133c,0x069c0b13,0xfd4701f4,0xf48af8be,0xed19f0b1,
0xe6b8e9ce,0xe0b5e3b7,0xdabcddaa,0xd59cd814,0xd184d361,0xcf1ad013,0xce0fce78,0xce0acde2,
0xcf93ce9b,0xd2a6d0ec,0xd6d4d4b1,0xdb06d8e1,0xe00bdd67,0xe60be2f9,0xebdce90b,0xf11cee82,
0xf5e2f39c,0xf9aff7df,0xfd35fb70,0x0186ff2e,0x0743043f,0x0d7c0a62,0x140c10a9,0x1b9c17ba,
0x23bf1fa4,0x2b7727bc,0x32ff2f29,0x3a5936d2,0x3f8d3d51,0x42a14139,0x451643f2,0x45db45d3,
0x436a450e,0x3db540ee,0x359e39e9,0x2b6330c0,0x206925d7,0x15fe1b22,0x0cd01121,0x056808f5,
0xff88023b,0xfbaffd56,0xf9b7fa7b,0xf9d3f980,0xfbeefab0,0xff5bfd80,0x03e50183,0x08970647,
0x0cac0ac5,0x0f6d0e29,0x128610d4,0x15611426,0x16011618,0x134d1511,0x0c931072,0x032b0810,
0xfa06fe63,0xf242f5fd,0xeb34eeb7,0xe407e7b1,0xdcfbe053,0xd7ebda37,0xd467d5fd,0xd230d324,
0xd16cd195,0xd206d195,0xd387d2bb,0xd541d464,0xd6b0d607,0xd73fd717,0xd757d742,0xd865d7a5,
0xdbb6d9be,0xe158de44,0xe853e4cb,0xeed9ebb4,0xf41df1ae,0xf843f643,0xfbfffa2c,0xff64fdc3,
0x023100d7,0x04cd037a,0x07b50633,0x0b370967,0x0f410d2c,0x138b1165,0x181815c0,0x1d501a94,
0x22fa202c,0x278f258c,0x290d28c6,0x27532888,0x23202573,0x1d3a2061,0x164919d7,0x0e5e127a,
0x053d09ea,0xfbff008c,0xf3ebf7ca,0xecfff050,0xe6dae9e0,0xe0dfe3d3,0xdb44de00,0xd620d8ad,
0xd1e5d3d0,0xcf58d06b,0xce4bcea8,0xce48ce28,0xcfddcedc,0xd2d9d12f,0xd685d4af,0xda76d867,
0xdf72dcd3,0xe533e24a,0xeaa8e7fc,0xefc2ed48,0xf403f1ff,0xf75df5ca,0xfa8ff8e7,0xfe97fc68,
0x03d9011d,0x09bf06b7,0x10b90d0c,0x193314c9,0x227c1ddf,0x2b1026d8,0x33a32f56,0x3b9237d6,
0x40df3e92,0x44da42e3,0x4804469e,0x48a648bf,0x461347d0,0x40054370,0x37a03c0c,0x2d5d32ac,
0x23012814,0x19041df7,0x102c1464,0x08840c3b,0x02310527,0xfddeffc8,0xfbaafc77,0xfbbafb70,
0xfdbffc8d,0x0146ff4f,0x063603a1,0x0ae708ad,0x0e690cdd,0x111a0fab,0x14a312e7,0x162415cb,
0x1448159b,0x0f591249,0x06b50b5d,0xfcbe01af,0xf434f843,0xed00f076,0xe651e9a5,0xdf24e2d0,
0xd8fbdbc7,0xd4add6a8,0xd1b6d302,0xd04ed0d0,0xd0b5d045,0xd25fd16a,0xd453d364,0xd5d1d525,
0xd6cfd65f,0xd709d704,0xd752d710,0xd945d7fe,0xdd75db16,0xe3bae064,0xea9ee73a,0xf0a3edc7,
0xf544f321,0xf91af73b,0xfc70fad8,0xff1dfde3,0x0156002f,0x040502a8,0x0717057b,0x0ad408d4,
0x0f5f0d11,0x142611ba,0x199d16bf,0x20111cc4,0x26162346,0x29952840,0x299e29fd,0x270f289b,
0x22e7252d,0x1d5b2044,0x16d21a3e,0x0ed01300,0x05bd0a57,0xfcec0135,0xf4fff8d7,0xee0af16f,
0xe787eac4,0xe140e454,0xdb71de51,0xd5e8d89a,0xd177d37e,0xcea2cfda,0xcd5fcdd4,0xcd95cd4a,
0xcf3cce3c,0xd214d098,0xd525d391,0xd944d707,0xdec1dbdf,0xe480e1b0,0xe9fde73c,0xef0eeca7,
0xf2c2f114,0xf582f42a,0xf885f6f1,0xfc44fa4b,0x009afe62,0x06020313,0x0d6f097b,0x16b111e5,
0x20811b94,0x2a8c257c,0x348d2fa0,0x3cbd38fc,0x42e63ff3,0x4815459c,0x4b754a19,0x4bc44c03,
0x486d4a8f,0x424345a3,0x39bc3e4b,0x2fb734c9,0x25862aa1,0x1bbd2080,0x13031742,0x0b2b0efb,
0x047407a7,0xff4b01a2,0xfc94fd98,0xfc73fc35,0xfecdfd54,0x034500cd,0x08c60604,0x0d930b58,
0x10ab0f4a,0x13f7122b,0x168115a0,0x15981676,0x118113f3,0x0a090e36,0x00490546,0xf6aefb53,
0xeed5f287,0xe877eb81,0xe244e579,0xdbe2deee,0xd6fcd948,0xd32ed4ed,0xd0d7d1d7,0xd03ad042,
0xd14ed0a0,0xd313d22a,0xd483d3e1,0xd55ad503,0xd5c6d5a8,0xd5d3d5be,0xd6ecd62b,0xda0ad83b,
0xdf0ddc4a,0xe558e224,0xeba4e892,0xf10eee7a,0xf58cf365,0xf9aff7a3,0xfd0bfb80,0xff4dfe45,
0x0184005a,0x043302cd,0x076205bb,0x0b6c0945,0x10190db4,0x157112a6,0x1c241898,0x237c1fe3,
0x28eb26a1,0x2acb2a4e,0x29752a6c,0x265f280d,0x22192462,0x1cf21fa1,0x168d19f4,0x0e8312ac,
0x05ed0a3a,0xfdd501cf,0xf658fa09,0xef50f2c9,0xe8c9ebef,0xe2c0e5be,0xdc86dfb0,0xd668d962,
0xd18cd3c4,0xce4ecfb8,0xcc89cd39,0xcc7acc4b,0xcddfcd06,0xd005ceec,0xd29cd12f,0xd6a5d46c,
0xdc11d93e,0xe1b1dee3,0xe791e4a1,0xecdaea5e,0xf0c7eef6,0xf43af282,0xf7ccf5f7,0xfb8af9a7,
0xff8afd73,0x04dd01f7,0x0c3e0846,0x158610b8,0x1f831a7b,0x2a1a24af,0x34d72f9e,0x3daf397d,
0x455941a3,0x4bc348c5,0x4f574e01,0x4f884fdf,0x4bd54e26,0x451c48c8,0x3c5040ec,0x328f377d,
0x28362d6d,0x1eb8234e,0x16051a4a,0x0e0c11f7,0x06cc0a50,0x012b03b0,0xfe36ff5b,0xfdf6fdb4,
0x00deff07,0x06230351,0x0b9c090a,0x0f880dcb,0x125f10e8,0x156f1402,0x160c162f,0x134f1505,
0x0d6410d9,0x0429090e,0xf9fbff0e,0xf0e5f53b,0xe9a4ed06,0xe3c8e69f,0xddd8e0d7,0xd8c9db20,
0xd4aed6b4,0xd129d2ca,0xcf2ecfef,0xcf45cef6,0xd10ed005,0xd30bd21d,0xd469d3cd,0xd541d4e4,
0xd595d575,0xd605d5b6,0xd80dd6c4,0xdc02d9d4,0xe15ade8d,0xe70ce437,0xec6be9cb,0xf12eeedb,
0xf599f36c,0xf9cef7c2,0xfd0ffb9a,0xff90fe51,0x020100ca,0x0498033c,0x07c3060e,0x0bd609b9,
0x10c40e2c,0x174213c7,0x1f391b23,0x26ad232f,0x2ae4294c,0x2b3b2b7f,0x29042a59,0x25a62772,
0x217b23a7,0x1c451f0a,0x1578190e,0x0dc911a6,0x064709ff,0xff0702a3,0xf7d3fb6d,0xf0b7f445,
0xe9dded38,0xe388e6b3,0xdcf5e046,0xd67dd9b0,0xd073d361,0xcc1ccdee,0xca97cb0e,0xcad3ca89,
0xcc19cb69,0xcdd8ccdc,0xd10acf38,0xd619d367,0xdb85d8d4,0xe15ede64,0xe710e44f,0xeb9ce985,
0xef39ed6e,0xf344f128,0xf795f577,0xfb52f986,0xff68fd3b,0x04fd01fa,0x0c540870,0x150c108c,
0x1f0b19dd,0x29cf2472,0x33bb2ee8,0x3da438a5,0x46ed427f,0x4d804aaa,0x50624f61,0x4fad5078,
0x4c264e3f,0x457f4930,0x3d004167,0x333a3848,0x29322e1d,0x1fd72472,0x17581b6f,0x0f7e1363,
0x08360bba,0x02dc052f,0x0059014a,0x00de002b,0x04a60270,0x0a1b0744,0x0f2b0cd3,0x12b91111,
0x1664147e,0x18b017f8,0x17171864,0x11c814e0,0x08bd0db8,0xfde20354,0xf3b3f899,0xeb47ef40,
0xe4cbe7d6,0xdf16e1f3,0xd99cdc30,0xd5a2d781,0xd20ad3cf,0xcf2bd071,0xce25ce55,0xcf1fce73,
0xd142d01d,0xd34bd259,0xd497d40a,0xd52dd4f5,0xd562d53d,0xd69fd5ce,0xd9d2d7f5,0xdebcdc20,
0xe436e17e,0xe958e6d6,0xedbeeba9,0xf1afefbd,0xf5ccf3bb,0xf991f7ca,0xfc73fb16,0xfef6fdb1,
0x017f003d,0x042802c8,0x079105bd,0x0bba0989,0x11620e4d,0x192114ff,0x21e41d89,0x28b925c8,
0x2b532a8b,0x2a822b44,0x27ac2930,0x245f2613,0x205b2279,0x1b521e06,0x14da1834,0x0e34117d,
0x07b00aef,0x00d20458,0xf94dfd21,0xf1d0f57a,0xeb13ee65,0xe44de7be,0xdd41e0cd,0xd645d9bf,
0xcfe4d2e8,0xcc14cd94,0xcad3cb38,0xcb13cad1,0xcbdecb6c,0xcda9cc98,0xd125cf30,0xd583d34c,
0xda4cd7ca,0xdfc4dd06,0xe4bae25b,0xe8e6e6e1,0xed0ceaea,0xf1b9ef62,0xf5cbf3e7,0xf936f77d,
0xfd7efb31,0x0357002c,0x0aa806db,0x132c0ebe,0x1d021801,0x2708220c,0x313a2c02,0x3c8936c5,
0x47404231,0x4e9c4b6a,0x523250e3,0x526d52aa,0x4f795169,0x49784cc2,0x415b45b1,0x376a3c7f,
0x2d1a3249,0x232727fb,0x1a701ea6,0x123d1651,0x0b070e63,0x06200845,0x03e604a3,0x04f30402,
0x08f806a8,0x0e1d0b9d,0x11d4102d,0x15331369,0x182016f9,0x179d185e,0x134815da,0x0bb10fee,
0x015e06b5,0xf6a5fbf0,0xed4af1b9,0xe5c5e954,0xdfd7e2a1,0xdaa2dd26,0xd6d0d888,0xd3a5d539,
0xd0b6d221,0xcea1cf7d,0xce5bce44,0xcf85cecf,0xd151d060,0xd314d23b,0xd44ed3c3,0xd4edd4ab,
0xd5d3d542,0xd83ad6cd,0xdc61da1a,0xe196def5,0xe673e417,0xea55e883,0xeda7ec02,0xf167ef6f,
0xf567f37a,0xf8a1f71b,0xfbbbfa25,0xfed9fd57,0x01800032,0x047402e5,0x07fa0624,0x0c830a0a,
0x13450f8e,0x1bff177f,0x2458206d,0x295c275f,0x2a942a5e,0x29212a10,0x26a027f5,0x239b252f,
0x1fcc21dd,0x1a851d4f,0x14791781,0x0ebd1191,0x091b0bf8,0x02b0060b,0xfb26ff07,0xf3b9f756,
0xecc6f03f,0xe5bae949,0xde48e210,0xd676da58,0xd026d2f3,0xccc3ce27,0xcb74cbe1,0xcb1ccb3b,
0xcbbdcb40,0xcde8cc9b,0xd13ecf8b,0xd4f9d300,0xd983d72b,0xddfedbca,0xe202e00f,0xe627e3f6,
0xeb7be8af,0xf0b4ee3f,0xf4c0f2d7,0xf8aff6a8,0xfdb3fb01,0x03fe00bf,0x0b2b0769,0x13a50f50,
0x1c2417ee,0x24fa206e,0x2f8c2a06,0x3b373561,0x457640b2,0x4c744966,0x507f4ec7,0x51c15190,
0x4f5b50f2,0x4a504d34,0x429846b5,0x39073e0f,0x2e9133bd,0x250b29aa,0x1c48209e,0x1426180f,
0x0db710af,0x09b10b60,0x087c08b6,0x09ff08f0,0x0e000bba,0x12451053,0x15b413fd,0x18eb174e,
0x1ad01a4a,0x18861a3e,0x124015d8,0x08c90de3,0xfd70032b,0xf296f7d9,0xe978edc6,0xe24ee5aa,
0xdc6cdf42,0xd7dcd9e6,0xd4e9d640,0xd263d3a8,0xcffdd11d,0xcebfcf2c,0xceb2ce9a,0xcf7acef9,
0xd0e1d02c,0xd1f0d17c,0xd278d245,0xd2d8d298,0xd452d35f,0xd789d5b7,0xdc54d9cd,0xe185def1,
0xe61ce3fb,0xe95be7d9,0xec6aead5,0xf013ee2e,0xf396f1ef,0xf6d8f52e,0xfa68f891,0xfe00fc3e,
0x0136ff9a,0x049c02e2,0x088b067a,0x0e280b08,0x167b1207,0x1fed1b38,0x27852426,0x2b4c29ea,
0x2b932bd2,0x29b52ac7,0x27402888,0x242525d1,0x1fde222e,0x1a671d3b,0x14ed1797,0x0fcf1264,
0x0a2e0d18,0x038b0704,0xfc2dffdc,0xf50af894,0xee05f18b,0xe6bfea71,0xded5e2e9,0xd6badaa6,
0xd0ccd36b,0xcd4ecec9,0xcb78cc41,0xcabacaf0,0xcb8dcaed,0xcdd6cc94,0xd09dcf35,0xd3e8d227,
0xd793d5c1,0xdb0fd953,0xde8cdcbc,0xe344e0b1,0xe92ce62d,0xee5aebea,0xf2ecf0a8,0xf792f52d,
0xfd23fa36,0x036f0037,0x0abf06f1,0x12a00eb3,0x1a971697,0x238f1ed4,0x2e4728be,0x398f33fc,
0x43343eb6,0x4a2846ff,0x4f334ce5,0x518950d0,0x50b65178,0x4cce4f2d,0x45c149a8,0x3bdc410a,
0x3172369c,0x27b52c75,0x1ed02325,0x17081ac9,0x110713ba,0x0d9e0efc,0x0d0e0cfc,0x0f430dcf,
0x13921152,0x17411587,0x1b1b191d,0x1e1e1ce8,0x1cee1e43,0x16b71a4b,0x0cdf1237,0x00da06ff,
0xf51efad0,0xeaefefc6,0xe2e7e6b2,0xdc62df7e,0xd746d994,0xd44ed58e,0xd25dd351,0xd057d158,
0xceb9cf6b,0xce64ce61,0xcf0bcea9,0xcffccf81,0xd0dbd072,0xd173d12a,0xd1e6d1ab,0xd31cd25b,
0xd5e1d44a,0xda47d7e7,0xdf68dcd7,0xe3fae1d0,0xe71ae5bc,0xe954e838,0xec27ea9f,0xefa5ede6,
0xf2dbf148,0xf635f477,0xf9fef814,0xfdb7fbdc,0x01afffa8,0x0581039e,0x0a050790,0x10b50d02,
0x19af1504,0x22951e5c,0x284d25ef,0x2a3429b1,0x29682a01,0x27b2289c,0x257726a7,0x2244240c,
0x1dd8202b,0x19071b70,0x148116b2,0x100c1255,0x0ad50d9b,0x044b07ae,0xfd9200e7,0xf6aafa2a,
0xef5df311,0xe74aeb75,0xde99e2ee,0xd712da97,0xd1b5d41b,0xce35cfc1,0xcc00ccf0,0xcb9acb91,
0xccc9cc04,0xce9fcdac,0xd0cccfa5,0xd337d204,0xd5b6d474,0xd852d702,0xdbcfd9d1,0xe143de54,
0xe721e443,0xec6be9d3,0xf1b5ef09,0xf75ff47a,0xfd7afa68,0x042d00b1,0x0bb407eb,0x13090f5e,
0x1ae316d3,0x24441f60,0x2ebf2974,0x38f033f9,0x41813d7b,0x48834523,0x4de24b80,0x50f34fae,
0x51605189,0x4e6d5058,0x47844b7b,0x3e1942ed,0x33f33911,0x29f72ee0,0x20e3254b,0x19121cc8,
0x136e15ef,0x107b119c,0x109a1024,0x13bf11dd,0x180315e9,0x1c701a1b,0x20b11ec2,0x21a121c6,
0x1cf92003,0x13b818d1,0x07970ddf,0xfac0011e,0xeed0f4a2,0xe4c1e979,0xdcb1e087,0xd63ed937,
0xd28cd40a,0xd0f1d196,0xcff6d072,0xcf24cf80,0xcf0fcefb,0xcfa3cf46,0xd070d00f,0xd0ded0b7,
0xd109d0fa,0xd104d10e,0xd192d123,0xd37cd245,0xd71bd51a,0xdbead974,0xe094de4d,0xe444e29a,
0xe6b4e590,0xe932e7db,0xec91eacb,0xefe4ee4f,0xf2cef157,0xf62ef467,0xfa1af81b,0xfe58fc26,
0x02b80098,0x06ff04c7,0x0c87097d,0x147d103f,0x1d6e18fe,0x2468214f,0x281326a7,0x28c728ba,
0x28232890,0x2698276f,0x2452259c,0x20a222a5,0x1c471e7d,0x17f71a17,0x13b615e2,0x0ee71168,
0x09340c26,0x03340633,0xfd210037,0xf69bf9f0,0xef8bf32a,0xe7aeebb8,0xdfc7e39b,0xd91cdc4a,
0xd3b3d63d,0xcf91d173,0xcd4cce23,0xcd2ccd02,0xce3acdaa,0xcf94ced9,0xd16ad075,0xd35dd262,
0xd551d459,0xd794d658,0xdb90d945,0xe110de44,0xe68ae3d0,0xec4ae95f,0xf23cef3f,0xf84df544,
0xfe6efb55,0x04f401a5,0x0b5d0839,0x11ca0e7d,0x199e1577,0x22f61e2a,0x2ceb27f1,0x361231aa,
0x3de33a26,0x448e4162,0x49d14751,0x4df54c19,0x4f764f14,0x4d944f00,0x47dd4b23,0x3fa843fb,
0x36403b00,0x2cc4317e,0x23ed283a,0x1c521fe8,0x16e2194e,0x13e8150c,0x140a1387,0x172c1560,
0x1b5f1937,0x20181daa,0x24092259,0x241f24c1,0x1e8c21e7,0x14871a1c,0x07340e16,0xf9b0004f,
0xed79f367,0xe326e80e,0xda7dde97,0xd3ccd6d5,0xcfd0d171,0xce36cec9,0xcd97cddd,0xcd50cd62,
0xcde4cd7e,0xcf4dce89,0xd0fed02f,0xd1c5d18c,0xd178d1b5,0xd0cbd123,0xd0abd09e,0xd23dd131,
0xd5c3d3d1,0xda87d806,0xdf6ddd06,0xe34be18a,0xe5dae4a6,0xe870e70f,0xebb6ea03,0xef42ed7f,
0xf288f0ed,0xf5bff41f,0xf999f791,0xfe1cfbd2,0x02900059,0x078d04f3,0x0dc00a73,0x15d0118e,
0x1e8c1a3e,0x25242246,0x284d272a,0x288b289f,0x27d7284c,0x2684273e,0x23f32576,0x2019221c,
0x1bf11e05,0x17f619ee,0x13a715db,0x0ec31153,0x091e0bf5,0x03d30666,0xfeb70149,0xf8fbfbf3,
0xf1ebf5b9,0xe93ceda0,0xe139e507,0xda93ddc1,0xd4f4d7ac,0xd068d270,0xce27cef5,0xcdf6cde0,
0xce97ce37,0xcf94cf09,0xd08fd017,0xd185d105,0xd2e0d225,0xd54cd3d8,0xd9cdd751,0xdf39dc7e,
0xe4f2e209,0xeafde7f6,0xf13bee19,0xf756f451,0xfdc4fa6e,0x0475012b,0x0a7c0786,0x11340da3,
0x198c1535,0x22951e0a,0x2bd3273b,0x3450302a,0x3bf63845,0x42043f34,0x46e04484,0x4a9148e9,
0x4c634bc9,0x4adf4c1e,0x466148e4,0x3fe7435f,0x38283c1d,0x30003418,0x28122bf9,0x21282473,
0x1c101e55,0x192a1a4f,0x198e18e6,0x1c941ad8,0x20b41e94,0x24e222d7,0x27cc26b2,0x25a42787,
0x1e0e2260,0x126918c0,0x04140b51,0xf65efd14,0xea0beff9,0xdf3ee47a,0xd667da88,0xcfbfd2c6,
0xcc53cd90,0xcb9bcbcf,0xcb98cb8c,0xcc0fcbb9,0xcd7eccab,0xcfc1ce86,0xd1f1d0f8,0xd2bbd28d,
0xd25dd2a0,0xd1b5d204,0xd1ddd19c,0xd3cdd298,0xd739d55c,0xdb95d958,0xdfaaddc2,0xe23de122,
0xe40ce31f,0xe656e518,0xe997e7d0,0xed5feb85,0xf0caef17,0xf481f294,0xf8e9f69e,0xfdb7fb4b,
0x02b00028,0x08550567,0x0f1e0b85,0x17741320,0x1f991bbd,0x24f722bc,0x27022658,0x272b272e,
0x26e52719,0x25d7267d,0x237f24de,0x200421d6,0x1c671e32,0x18b11a9b,0x143b168d,0x0ee311ad,
0x09490c02,0x048a06d4,0xffe50246,0xfa27fd3b,0xf29af69e,0xea2cee53,0xe2d5e655,0xdc57df82,
0xd63dd93b,0xd171d38c,0xcf4ad008,0xcf17cf0f,0xcf75cf38,0xd010cfc8,0xd061d03e,0xd0e8d090,
0xd221d169,0xd4d6d33a,0xd954d6f8,0xde64dbc3,0xe414e126,0xea67e727,0xf103edbd,0xf782f43c,
0xfe74faf7,0x04a901b4,0x0a580772,0x112a0d93,0x192e1511,0x21ab1d67,0x2a1a25eb,0x32482e37,
0x39ce3640,0x3f793cd7,0x440341df,0x473d45c6,0x48944843,0x46fd481b,0x4348455e,0x3e3840dd,
0x38743b6b,0x31ff354b,0x2b4b2e97,0x256c283f,0x20e122ed,0x1ea91f63,0x1fc51ed5,0x22c4212d,
0x2658247a,0x2a242854,0x2b542b52,0x26bb29c2,0x1d492289,0x0fcd16ea,0x012f0872,0xf386fa36,
0xe700ed1e,0xdba4e11d,0xd26ad6c1,0xcbf2ceb6,0xc941ca27,0xc8cfc8e4,0xc925c8e4,0xca8cc9aa,
0xcd21cbb6,0xd047cead,0xd296d1a1,0xd33ad313,0xd31bd33c,0xd2fcd2fa,0xd3c1d337,0xd5c3d49d,
0xd8e7d731,0xdc86dabd,0xdf37de0f,0xe0a0dffc,0xe22fe154,0xe49ce346,0xe828e647,0xebb4e9ff,
0xef3ced66,0xf374f13f,0xf874f5db,0xfdd3fb20,0x0392009c,0x0a1806b3,0x12380df2,0x1b3316c2,
0x22251f16,0x259b2450,0x2645262c,0x2651264e,0x25ed2633,0x24aa2570,0x22082381,0x1eca206e,
0x1ba31d30,0x18311a04,0x13cf1627,0x0e651121,0x09af0be3,0x05b507b0,0x013b039e,0xfb06fe63,
0xf36cf742,0xec4fefc3,0xe60be91b,0xdf84e2e5,0xd8f1dc1a,0xd424d641,0xd1a2d2a0,0xd074d0f3,
0xd006d02c,0xcf80cfd3,0xcee8cf28,0xcedccecf,0xcfefcf2b,0xd30ad13c,0xd777d52a,0xdca9d9f5,
0xe2a6df8a,0xe995e609,0xf06aed0a,0xf765f3d6,0xfe24fae9,0x03ee0116,0x0a2b06e6,0x11900dc2,
0x193f156a,0x20ea1d13,0x288a24b1,0x307f2c86,0x377a342d,0x3d023a65,0x412a3f3d,0x441242d1,
0x449a44b4,0x42de43ec,0x3fb3416e,0x3bbb3db8,0x37a939bb,0x3332357a,0x2e9f30e6,0x2a2e2c60,
0x26882829,0x25532586,0x270225e0,0x2a00286c,0x2dc92bbe,0x315b2fe2,0x2fec317b,0x28612ccd,
0x1c2b22d0,0x0d2514be,0xfe9305c0,0xf117f7b2,0xe487eab3,0xd926de9d,0xcffcd43d,0xca49cc9f,
0xc817c8e7,0xc795c7b1,0xc826c7ba,0xc9fec8e9,0xccdfcb5d,0xcfb5ce64,0xd12cd0a4,0xd18bd167,
0xd1f1d1b9,0xd2ded250,0xd49dd3a3,0xd6c6d5a4,0xd975d814,0xdbc1dab9,0xdccedc6b,0xdda4dd29,
0xdf57de59,0xe22be09e,0xe59de3e5,0xe914e74c,0xed3ceb10,0xf23fef9f,0xf836f524,0xfe7cfb4b,
0x056c01d4,0x0d6a093e,0x16c311ff,0x1f691b65,0x247a2276,0x25f82597,0x25d525ef,0x25c825d0,
0x2542259a,0x23a924a0,0x20f82264,0x1e191f87,0x1b361cb0,0x17971986,0x12d0155c,0x0da91023,
0x09b40b8b,0x061d07fb,0x016a03f3,0xfaf5fe63,0xf429f771,0xee58f12c,0xe89deb89,0xe1c8e54e,
0xdb30de54,0xd68fd88e,0xd404d51e,0xd26dd31c,0xd148d1e1,0xcfaad083,0xce2ccedb,0xcd5dcda6,
0xce4acd84,0xd156cf9d,0xd589d351,0xdabed7ff,0xe139ddd1,0xe866e4d1,0xef5aebde,0xf67ff2ef,
0xfcc5f9d0,0x0271ff89,0x093e05ad,0x10ca0cfa,0x18511493,0x1fa71c03,0x27252344,0x2f132b33,
0x35eb32a3,0x3bc43906,0x400a3e15,0x429241a4,0x424842be,0x40064158,0x3cc93e7b,0x396a3b0f,
0x363b37cf,0x334734b8,0x309431ed,0x2dae2f26,0x2b552c4f,0x2b232ae6,0x2d452c02,0x301f2ea3,
0x33c831e1,0x35cd3550,0x323c34d1,0x290f2e40,0x1ba222c6,0x0caa1433,0xfe450557,0xf0a8f762,
0xe3abea12,0xd81bdda5,0xced1d313,0xc90fcb84,0xc614c74e,0xc4f8c54e,0xc57cc501,0xc799c65c,
0xcad7c92a,0xcd99cc60,0xcf0fce75,0xd004cf88,0xd120d07f,0xd2e9d1ef,0xd55ad41b,0xd7d0d68a,
0xda52d920,0xdbdcdb40,0xdc2bdc1a,0xdc7fdc3e,0xdde1dd0e,0xe07bdf0a,0xe39ee206,0xe754e558,
0xec45e9a5,0xf229ef1c,0xf8d3f56f,0xffcffc48,0x07740389,0x103f0ba5,0x19e81518,0x21a51e3a,
0x25ab241b,0x26942665,0x26992693,0x264d268b,0x257325fb,0x234f248b,0x207d21ea,0x1d981f08,
0x1a761c1d,0x16571891,0x112c13ce,0x0c830eaf,0x08f40aa4,0x052c0732,0xffed02c3,0xf9abfccd,
0xf420f6bd,0xef62f1c0,0xe9faece1,0xe36ee6bb,0xdd43e039,0xd8a0dab8,0xd56cd6e6,0xd336d43a,
0xd135d242,0xcf16d01d,0xcd67ce2c,0xcc75ccc4,0xcd80ccaf,0xd05bcec2,0xd493d246,0xda3ed736,
0xe169ddb2,0xe8dbe527,0xf029ec86,0xf71ef3bd,0xfd2cfa3e,0x03550024,0x0a7e06d5,0x11b90e2a,
0x18a11532,0x1f531bff,0x268622d3,0x2de52a3d,0x34b5316b,0x3a5737b1,0x3ea93cb5,0x40913ff8,
0x3ff74085,0x3d973ef3,0x3a3d3bf9,0x36e63886,0x33f7355e,0x31c332c5,0x302930e5,0x2eba2f68,
0x2e452e4f,0x2f9f2ea8,0x324530eb,0x35213397,0x389836e8,0x393c3993,0x33ff375a,0x29622f51,
0x1b14227d,0x0be61374,0xfd870499,0xefcbf699,0xe2c8e927,0xd748dcd0,0xce6dd26b,0xc918cb5f,
0xc601c750,0xc4bac523,0xc553c4cb,0xc7b3c652,0xcabac941,0xccd6cbf4,0xcde1cd65,0xcefece69,
0xd0a3cfb6,0xd34cd1dd,0xd663d4d7,0xd978d7f2,0xdbc0daca,0xdc5bdc42,0xdbc0dc20,0xdb74db77,
0xdc73dbc4,0xde9cdd6f,0xe163dfe9,0xe54de327,0xeabbe7dd,0xf12eedd7,0xf875f4bf,0x0045fc4e,
0x088a044f,0x11fc0d12,0x1bd51712,0x22cb1fcb,0x25f824da,0x26792663,0x266e2679,0x25e1263c,
0x2494255d,0x22452386,0x1fa320f3,0x1ce11e44,0x19cd1b71,0x158017d3,0x10b11311,0x0cc80e95,
0x09830b30,0x0519078f,0xfebc0218,0xf884fb70,0xf3e1f602,0xeff6f1f0,0xeac8ed9b,0xe4a8e7bd,
0xdf15e1b9,0xdaa0dcb9,0xd75bd8d6,0xd4f9d622,0xd26dd3b8,0xd00fd133,0xce28cf0a,0xcd64cd8c,
0xce48cda3,0xd098cf3d,0xd4a5d262,0xdaa8d768,0xe1e1de36,0xe969e59b,0xf0b5ed2d,0xf6bcf3e4,
0xfc31f968,0x0298ff3c,0x09c80627,0x10980d43,0x16cc13c5,0x1d3b19e2,0x248920d9,0x2bfd2843,
0x330e2fa5,0x38cd3608,0x3d173b3a,0x3ebb3e3b,0x3e123ea1,0x3bc83d1a,0x38853a38,0x350936c0,
0x32443387,0x309e3146,0x2fd1302c,0x2fa92f96,0x30f13013,0x34393265,0x377635f5,0x3ae23906,
0x3e543cdf,0x3d5e3ea2,0x36a63a9a,0x2b183173,0x1c5023e9,0x0d0c1499,0xfe4405ac,0xeff3f6fe,
0xe281e91b,0xd67fdc36,0xcdf3d1ba,0xc87bcaed,0xc507c686,0xc385c403,0xc43cc39e,0xc6c3c553,
0xc994c842,0xcb55ca91,0xccb2cbfe,0xce41cd6f,0xd06fcf37,0xd387d1f1,0xd6cad521,0xd9ffd87e,
0xdbbbdb20,0xdba6dbe5,0xda91db22,0xda20da30,0xdb17da75,0xdce0dbe8,0xdfa0de0b,0xe423e1ab,
0xe9e9e6eb,0xf0a7ed24,0xf859f46a,0x009efc74,0x097e04e6,0x13aa0e73,0x1d5e18cc,0x23d22111,
0x26a6259a,0x27682723,0x275b2784,0x263e26ee,0x24022541,0x2108228d,0x1e031f84,0x1b001c8a,
0x17851959,0x134d1578,0x0f49112e,0x0c620db0,0x097f0b11,0x04bf076c,0xfe7101a4,0xf92bfb91,
0xf599f73f,0xf206f3f8,0xeceaef9f,0xe72fea07,0xe1ece477,0xdd48df80,0xd9badb60,0xd68fd827,
0xd333d4e4,0xd033d19b,0xcddbceed,0xccc2cd1d,0xcd16ccbe,0xcf05cdd7,0xd2e8d0af,0xd913d5c2,
0xe068dca8,0xe847e44f,0xef98ec19,0xf57bf2a2,0xfbadf871,0x02c3ff29,0x09ba0650,0x101a0d01,
0x15ea130b,0x1c5f18fd,0x23771fe2,0x2aec272b,0x31b12e7e,0x3745349e,0x3b22397d,0x3cac3c39,
0x3c273c98,0x3a433b58,0x375538e5,0x341635af,0x318c32ad,0x303830b7,0x2fec2fef,0x317b306c,
0x35253308,0x3a0d37a8,0x3e543c30,0x42e140ab,0x44d64475,0x40f243ac,0x37763cd6,0x29c43100,
0x1a3f2211,0x0ae01282,0xfbdf0355,0xed48f47f,0xdf9ce64a,0xd45ed988,0xccbad027,0xc77ac9db,
0xc40dc587,0xc2eec324,0xc424c349,0xc682c54d,0xc850c786,0xc978c8ec,0xcaedca1f,0xcd38cbeb,
0xd0a9cece,0xd4a3d2a8,0xd89dd6a9,0xdb82da4d,0xdc4fdc2c,0xdb6fdc03,0xda2ddabf,0xd9f8d9e1,
0xdad3da58,0xdbfedb53,0xdeb4dd11,0xe390e0f1,0xe9a9e681,0xf0d1ed13,0xf8fff4c9,0x01d3fd57,
0x0bd706a4,0x169a114d,0x1f4d1b5e,0x24702254,0x268f25c0,0x27902724,0x278027ad,0x2643270f,
0x239f2515,0x20662207,0x1d151ec1,0x198b1b5f,0x155a1788,0x10fe131a,0x0dad0f27,0x0b350c76,
0x07b109b5,0x022b0521,0xfca1ff38,0xf8e9fa8c,0xf64ef799,0xf2bdf4bb,0xedf9f06d,0xe925eb83,
0xe475e6d1,0xe008e229,0xdc2ade10,0xd81dda2f,0xd416d609,0xd0cfd25e,0xce51cf6c,0xcd06cd88,
0xcd24cce2,0xcf05cdd4,0xd362d0d8,0xd9fcd683,0xe1c0ddbd,0xe9d5e5de,0xf071ed5f,0xf652f353,
0xfd1ff99d,0x03f4009d,0x0a1e071a,0x0fc60d01,0x158e128c,0x1c1318c3,0x230b1f7c,0x2a3a26b2,
0x30872d80,0x35933346,0x38b9375d,0x3a2439a7,0x39ef3a32,0x38903964,0x3602376b,0x331e3485,
0x30e231e0,0x2fa1301e,0x2fc52f77,0x322130ab,0x37343463,0x3c9e3a0c,0x41c03f11,0x46c94482,
0x47a847f1,0x422345b1,0x37623d4f,0x28f2307b,0x1937211e,0x097d1160,0xf9e5019a,0xeaddf24e,
0xdd3ce3bb,0xd309d7a3,0xcc2ccf4b,0xc758c98d,0xc472c59d,0xc3fbc3df,0xc58fc4a3,0xc741c684,
0xc810c7b9,0xc8ccc85d,0xca33c968,0xccbecb47,0xd0bfce9f,0xd586d313,0xda2ed7f2,0xdd20dbf7,
0xdde9ddc3,0xdce8dd8e,0xdb98dc30,0xdb57db5d,0xdb65db60,0xdbeedb80,0xde82dce7,0xe318e098,
0xe919e5ef,0xf06eec9f,0xf8ddf489,0x025efd76,0x0d4407ab,0x17de12cd,0x1f7d1c25,0x23b121f5,
0x25b424d9,0x26e9266f,0x26fd2716,0x25d5269a,0x235d24b7,0x201821d6,0x1c401e37,0x17df1a28,
0x134a158a,0x0f50112d,0x0ca20dd2,0x09f20b71,0x054507e7,0xffb10260,0xfb91fd65,0xf944fa3d,
0xf711f84d,0xf3dcf593,0xf018f201,0xebdfee17,0xe71ee97c,0xe2a9e4db,0xde32e078,0xd979dbd8,
0xd542d73d,0xd234d395,0xcfead100,0xce3bceeb,0xce1ccdf1,0xcff1cebb,0xd453d1d4,0xdad7d75b,
0xe2a9deb5,0xe9a5e662,0xef50ec89,0xf570f242,0xfc4df8d7,0x0293ff93,0x081d0566,0x0dc10ad5,
0x142d10e5,0x1aff1784,0x225e1ea8,0x295225ec,0x2f602c8f,0x33b031b2,0x36c43567,0x386537ba,
0x38fd38d1,0x383a38ce,0x3656375f,0x34193537,0x324b3321,0x315331a9,0x31ef3161,0x3534332e,
0x3a5b37c3,0x3f3e3cc4,0x44f04208,0x48d7475d,0x47c9490e,0x40bc44ee,0x35373b6d,0x272c2e62,
0x18351fc2,0x08b61080,0xf9630104,0xea62f1cd,0xdd8ae38b,0xd420d869,0xcd39d074,0xc7d0ca52,
0xc4a2c5d7,0xc48fc439,0xc60fc546,0xc6f9c6ab,0xc74ac724,0xc7f0c78c,0xc97bc88d,0xcc86cace,
0xd100cea1,0xd5ebd375,0xda22d83c,0xdc60db7f,0xdccddccd,0xdbfedc7a,0xdb77db9c,0xdb29db5e,
0xda7bdad5,0xdae2da67,0xddc0dc05,0xe296dff3,0xe92fe5ad,0xf0d9ece9,0xf9a1f510,0x041cfea2,
0x0f9f09df,0x195c14f1,0x1f531cc3,0x2284212f,0x24b023a0,0x262c2596,0x267a2677,0x2563261f,
0x23022454,0x1f7c2167,0x1b201d63,0x160c189f,0x1142138c,0x0ded0f5d,0x0be10cd9,0x08eb0ab4,
0x03b8067d,0xfef6011a,0xfc3dfd56,0xfacafb7f,0xf89df9d8,0xf59bf72c,0xf24df3fa,0xee52f06a,
0xe9f0ec28,0xe527e798,0xe00de2a3,0xdaf1dd76,0xd699d89e,0xd352d4e0,0xd05fd1d6,0xce34cf1d,
0xcd94cda8,0xcf81ce2b,0xd3e7d174,0xda5fd6db,0xe20fde3d,0xe884e581,0xee68eb62,0xf551f1c7,
0xfc46f8de,0x0255ff68,0x07a50506,0x0d750a73,0x13cb109c,0x1ab9172b,0x21d01e51,0x2863252d,
0x2da52b3f,0x316d2fae,0x343732ec,0x3646354d,0x37a23718,0x379937cd,0x3634370e,0x344e353e,
0x32cd3376,0x326b326d,0x340b32e0,0x38683600,0x3cff3ad3,0x416f3f1a,0x465543f7,0x489247f9,
0x45f247ec,0x3e7642bc,0x32ee3924,0x252b2c25,0x16741df8,0x072b0ec8,0xf7f1ff93,0xe934f060,
0xdcfbe2ad,0xd40cd822,0xcd4bd07b,0xc807ca72,0xc594c650,0xc659c5ae,0xc7f5c72e,0xc8b0c876,
0xc8e7c8cc,0xc989c931,0xcafcca15,0xcde6cc42,0xd25acff3,0xd752d4da,0xdb3fd989,0xdd0fdc6c,
0xdccedd29,0xdbb5dc3b,0xdb58db77,0xdad6db25,0xda1cda71,0xdad2da28,0xddb0dc04,0xe29fdfe2,
0xe963e5df,0xf129ed24,0xfa44f57f,0x054dff95,0x10d30b32,0x19c115c3,0x1f081cc4,0x21d220a8,
0x23e622e5,0x255524ba,0x25e325bd,0x251c25af,0x22d8242d,0x1f012119,0x19b51c8a,0x13d516b8,
0x0ed6112a,0x0bb80d09,0x09300a89,0x0511075e,0x007702a4,0xfd5cfeb1,0xfc0afc8b,0xfaf1fb8e,
0xf961fa3a,0xf747f862,0xf474f602,0xf0adf29f,0xec4cee98,0xe721e9c6,0xe1d0e477,0xdcf9df4b,
0xd904daeb,0xd519d719,0xd164d31e,0xcf13d009,0xcebfce97,0xd119cf9c,0xd5e8d32f,0xdcbcd92e,
0xe375e03f,0xe964e674,0xefabec71,0xf63ff2fd,0xfc12f946,0x0102fea4,0x0622036c,0x0c15090f,
0x12840f31,0x19c6161a,0x20ec1d60,0x2744244e,0x2be729c0,0x2f7b2dd5,0x321830dd,0x344d3337,
0x3608354b,0x3678366c,0x35b1363e,0x342934fa,0x33173371,0x337a3318,0x36863498,0x3b5238f4,
0x3f6e3d6d,0x43f14198,0x47b6461f,0x48254880,0x44044699,0x3bf64072,0x30ad36a5,0x23a32a4b,
0x15371c93,0x06640ddb,0xf71efebb,0xe91eefda,0xddcfe312,0xd538d948,0xce0fd177,0xc8cfcb18,
0xc6f2c778,0xc786c712,0xc869c80f,0xc8a0c893,0xc8f0c8c0,0xc99fc931,0xcb54ca53,0xce8eccb3,
0xd338d0c6,0xd801d5b8,0xdb35d9e0,0xdc35dbfb,0xdba0dbfd,0xdb6adb68,0xdb81db7d,0xdb05db5e,
0xda96daa9,0xdbc1daf4,0xded0dd07,0xe40ee131,0xea74e72c,0xf1d6ee00,0xfb0ef620,0x0674009c,
0x114c0c2b,0x192715a5,0x1e001be9,0x20f91f95,0x2352223f,0x24fd2434,0x25da2593,0x253925c1,
0x22e9244b,0x1e962104,0x18bc1bc4,0x129e15a5,0x0dc30ff1,0x0a510bfe,0x063d0876,0x016803c6,
0xfdd0ff66,0xfc1ffcbb,0xfb37fba3,0xfa94fadd,0xf9d5fa3f,0xf821f92c,0xf54cf6c7,0xf1d6f3b6,
0xecf6ef91,0xe755ea27,0xe23be4a3,0xde65e030,0xdae9dcb9,0xd6d8d8e8,0xd337d4ea,0xd0c3d1cc,
0xd078d04f,0xd2d0d146,0xd7ccd512,0xdd9edab2,0xe38de08d,0xe9d0e6a7,0xf038ecfe,0xf618f34b,
0xfacef892,0xff69fcff,0x0521022a,0x0b22081d,0x11ca0e5f,0x18e01547,0x1ffe1c87,0x25b72307,
0x2a422825,0x2dce2c1e,0x31112f6f,0x343532b1,0x36c2359b,0x3809379a,0x37af381b,0x3695370d,
0x36a03666,0x38fe376c,0x3da83b32,0x42284000,0x4699444f,0x4a1e48b1,0x4a0d4a94,0x4586484f,
0x3d6941de,0x33183866,0x27af2d8c,0x1b312191,0x0de71499,0xfffb0707,0xf25ff8fc,0xe710ec5b,
0xddd2e24a,0xd5dfd9ac,0xcf4ad258,0xcb49ccef,0xc9e2ca59,0xc949c997,0xc868c8d9,0xc800c81c,
0xc894c820,0xca6cc95b,0xcdc4cbe0,0xd283d008,0xd780d514,0xdb46d998,0xdd10dc6d,0xdce9dd29,
0xdcaadcb5,0xdcafdcbb,0xdbf4dc6f,0xdab6db50,0xda69da66,0xdba2dac9,0xdf1bdd09,0xe4bce1bf,
0xebb9e80e,0xf48fefd4,0xffb0f9f0,0x0ab30576,0x12780f06,0x1768153b,0x1a84191d,0x1d1d1be2,
0x1f0c1e22,0x20a21fe3,0x21822133,0x2120217b,0x1f46206f,0x1b5e1d8a,0x164818f0,0x11181392,
0x0d000ef5,0x087e0aef,0x02e105b0,0xfe970071,0xfcbffd59,0xfc84fc9f,0xfc2bfc53,0xfc10fc16,
0xfbbbfbfc,0xfa3afb22,0xf812f93d,0xf462f679,0xef0cf1df,0xe95aec26,0xe4e5e6e6,0xe15ae323,
0xdd55df67,0xd941db42,0xd586d751,0xd316d412,0xd2cfd2a1,0xd574d3c6,0xd984d771,0xddf0dba1,
0xe388e093,0xe991e694,0xef04ec68,0xf3b2f178,0xf7d9f5c0,0xfcd1fa30,0x029bffa8,0x08e805b0,
0x0f960c2f,0x16ee1332,0x1dc71a81,0x237120c3,0x27d125c5,0x2bfa29da,0x30652e2b,0x34823287,
0x37cb3642,0x399f38fd,0x397a39b5,0x3953394d,0x3ad739bf,0x3ed03c96,0x439d413a,0x481745e4,
0x4beb4a35,0x4cc34cd8,0x49294b89,0x418f45c6,0x376e3cb8,0x2c7831f2,0x20eb26cb,0x152c1b0c,
0x09090f2d,0xfc9102cb,0xf0f5f691,0xe6d7ebc0,0xdda2e224,0xd56fd95b,0xcf80d225,0xcc3ccd90,
0xcaa1cb57,0xc941c9f2,0xc845c8ae,0xc81ac810,0xc964c88a,0xcc08ca8a,0xd051cdfc,0xd562d2db,
0xd9c2d7c2,0xdc99db66,0xdd63dd37,0xdd36dd48,0xdd60dd44,0xdd15dd5e,0xdbfedc8e,0xdb66db92,
0xdbc9db7c,0xdd8cdc71,0xe16fdf39,0xe6e1e3fe,0xee0bea2d,0xf793f287,0x0257fcf9,0x0b5f0739,
0x11960ec9,0x15d313e2,0x19091787,0x1b971a64,0x1db41cb4,0x1f6a1ea0,0x20532003,0x1ff0204a,
0x1db31f16,0x19ad1bd7,0x14d4174a,0x10451278,0x0b900e0d,0x055e08a1,0xffa20241,0xfc69fdab,
0xfba6fbd8,0xfb4dfb80,0xfb38fb2c,0xfb9cfb69,0xfb5dfba0,0xfa2dfada,0xf7f3f94a,0xf3e2f61f,
0xeea2f151,0xe9dbec12,0xe680e810,0xe316e4e3,0xdf5ce133,0xdbb0dd8a,0xd840d9e3,0xd5e2d6e2,
0xd5bdd56f,0xd7e7d69f,0xdb00d95f,0xdf83dcfc,0xe5bbe287,0xebabe8d4,0xf093ee39,0xf480f2a5,
0xf88ff664,0xfd7efaf8,0x02ea001f,0x08fe05e8,0x0fbd0c42,0x16b2134b,0x1cfd19f2,0x21f41fb1,
0x25dd23f0,0x2a4d27ff,0x2f032cb0,0x33473137,0x36ce3534,0x385d37e4,0x38773874,0x394438a7,
0x3caa3a9e,0x41df3f34,0x47164490,0x4bc34976,0x4efd4dc4,0x4dbd4f08,0x47aa4b37,0x3e1d4341,
0x32c0388a,0x26de2cdc,0x1ad420d8,0x0ee114df,0x02eb08db,0xf7b4fd23,0xee28f2bb,0xe597e9d5,
0xdd80e179,0xd66ed9c6,0xd194d3b1,0xcec4cffc,0xcc9acdaf,0xcab4cb97,0xc986ca01,0xc953c940,
0xca99c9d0,0xcdb3cbd8,0xd2a2d005,0xd802d55f,0xdc52da60,0xde8addbd,0xdec9ded0,0xded3debc,
0xdefbdef9,0xde1bdeb1,0xdd07dd7e,0xdcb8dccc,0xdd63dcdd,0xdfaede4d,0xe36de16f,0xe867e5ba,
0xefaceba9,0xf96af450,0x0399feab,0x0b6607d9,0x10cc0e5c,0x146a12b8,0x17891609,0x1a2618e6,
0x1c521b4c,0x1daa1d1c,0x1e321e0a,0x1d441df6,0x1ab01c24,0x170e18fd,0x131c150d,0x0f0b112e,
0x09730c7d,0x02d3061c,0xfdd40003,0xfb83fc55,0xfad8fb1a,0xfacdfab9,0xfb79fb13,0xfbfbfbd5,
0xfbe4fbf7,0xfaf8fb9e,0xf829f9d5,0xf3abf619,0xeea1f117,0xeabbec80,0xe793e92b,0xe42ce5df,
0xe112e296,0xde10df8f,0xdb42dc9d,0xd973da24,0xd982d94d,0xda60d9da,0xdca5db3b,0xe122dea6,
0xe6b2e3e3,0xeb92e94f,0xef58ed8c,0xf302f114,0xf788f536,0xfc6cf9ec,0x020fff24,0x08270513,
0x0e6d0b50,0x14a81186,0x1a8517be,0x1f031ce9,0x236d211f,0x28e2260b,0x2e972bc4,0x33f3315c,
0x37cb3625,0x394b38c9,0x39b83985,0x3b593a34,0x3fa63d38,0x454f4273,0x49fd47dc,0x4da64be6,
0x4f014ee1,0x4b9b4de3,0x44434853,0x3a653fa0,0x2ef934cb,0x22f428f4,0x171e1d0e,0x0b351129,
0xff9e054e,0xf57efa4a,0xed61f13c,0xe5ece9a9,0xdebbe23f,0xd8c6db82,0xd4a0d682,0xd1c6d323,
0xcf4cd082,0xcd30ce28,0xcbeccc6c,0xcb7ecb93,0xcc77cbc2,0xcf95cdc9,0xd42dd1c5,0xd912d6ab,
0xdcb9db1b,0xde69ddd0,0xdecbdeab,0xdee7dedb,0xdea7dee4,0xddb1de30,0xdcfbdd46,0xdd19dcf0,
0xde40dd81,0xe0bcdf5e,0xe419e24c,0xe911e64c,0xf088ec72,0xfa25f52a,0x03a3ff17,0x0b1407a3,
0x10450df5,0x13ec122a,0x170f159b,0x199a185b,0x1b791ab0,0x1c151be4,0x1bf91c29,0x1a7e1b6a,
0x17ea194e,0x14b7165a,0x11481301,0x0cf20f55,0x07000a1b,0x014003fb,0xfd48feff,0xfb43fc13,
0xfabafacf,0xfb73fafb,0xfc72fc04,0xfcc9fca9,0xfccbfce1,0xfb53fc4c,0xf816f9e8,0xf392f5e5,
0xef2af141,0xeba8ed52,0xe849e9fc,0xe52ee6a7,0xe287e3d6,0xdffbe13d,0xdd81deb3,0xdc05dc9a,
0xdb49dba1,0xdb3ddb09,0xdd95dc16,0xe20bdfa4,0xe731e4aa,0xeb4ce96b,0xeeceed06,0xf2e7f0c6,
0xf752f511,0xfc69f9c7,0x01c1ff0f,0x07670496,0x0c980a06,0x12020f3f,0x172714b1,0x1b98195d,
0x20aa1e02,0x26b3239e,0x2d1529e5,0x32d4301a,0x36da3517,0x39263832,0x3b213a00,0x3ec43cac,
0x44ad417d,0x4adb47f2,0x4f7c4d53,0x52d85169,0x521e5337,0x4c4e4fbe,0x43264813,0x37c73da9,
0x2b1b318d,0x1e8324bb,0x122a185b,0x05de0bf1,0xfaa80009,0xf1caf5ea,0xead2ee2c,0xe437e784,
0xde2fe114,0xd9a6dbbc,0xd635d7d0,0xd334d4b4,0xd051d1bb,0xcde0cefd,0xcc99cd25,0xcc3dcc3d,
0xcdc8ccb2,0xd15acf61,0xd5ded38a,0xda1dd824,0xdca3dba8,0xddd1dd50,0xde8fde39,0xdf13dee2,
0xdef4df10,0xdea3ded0,0xde9cde86,0xdf59dee5,0xe0bfdff7,0xe2dfe1b9,0xe600e436,0xeb54e85c,
0xf36def10,0xfd0ff82f,0x05ca01ae,0x0c45094f,0x109f0ea9,0x14471274,0x178215f7,0x19e318d7,
0x1ac41a86,0x1a8c1ac6,0x192719f9,0x16db1820,0x14051577,0x10c91276,0x0cd10ef4,0x07b20a5a,
0x027c0507,0xfe40002c,0xfb92fcc0,0xfa45fab9,0xfab0fa46,0xfbddfb4d,0xfc70fc39,0xfcf3fcb3,
0xfcaafd03,0xfa8bfbd0,0xf71af8f0,0xf35df52e,0xf00bf1af,0xecccee6e,0xe9c1eb35,0xe746e874,
0xe52de635,0xe305e41b,0xe143e20b,0xdfa1e083,0xddb1de97,0xdd87dd4a,0xdfc8de66,0xe372e182,
0xe74be56e,0xea94e8f6,0xee39ec57,0xf276f041,0xf76ef4e8,0xfc9cf9f7,0x021dff5e,0x06e004a0,
0x0b380904,0x0fea0d92,0x1466122b,0x194716bd,0x1f411c1d,0x265022ad,0x2d832a02,0x338e30be,
0x37f835ff,0x3b35399c,0x3ec33ce5,0x43e1410c,0x4aa14735,0x50084d99,0x5458524b,0x561b55d2,
0x523e54e2,0x4a034e8a,0x3eff44c3,0x328e38ec,0x25262be0,0x180d1e95,0x0b311192,0xfec104e2,
0xf46bf936,0xecc4f053,0xe698e98f,0xe15ee3d9,0xdd55df27,0xda7fdbd2,0xd7e9d93a,0xd4d3d668,
0xd189d328,0xcf18d028,0xcdb2ce41,0xcdf1cd92,0xd065cee8,0xd42cd22b,0xd865d654,0xdb74da22,
0xdd2bdc6e,0xde96dde2,0xdfe0df42,0xe08fe053,0xe06be08f,0xe030e03c,0xe0c9e066,0xe1e0e147,
0xe35ce28c,0xe545e43a,0xe8d8e6c5,0xef0beb90,0xf7b8f32a,0x00c1fc6b,0x07e50490,0x0d170abd,
0x10e50f08,0x149512d0,0x178f1630,0x18e31880,0x185d18ce,0x16ed17b6,0x14fd1608,0x12a513d5,
0x0fcf1155,0x0c210e0e,0x07d70a09,0x0360059b,0xff320138,0xfbcefd61,0xf9d4fa8c,0xfa0ef9b4,
0xfb6afabf,0xfc37fbdf,0xfcd5fc8a,0xfcdefcfc,0xfb82fc63,0xf8c6fa3f,0xf5abf738,0xf2aff42f,
0xef9af123,0xecb8ee18,0xeaa6eb94,0xe93be9e6,0xe807e898,0xe6f5e780,0xe545e645,0xe2a6e404,
0xe0c3e184,0xe0b1e07b,0xe21fe146,0xe45ee327,0xe753e5be,0xeadde90d,0xeeabecb3,0xf345f0e2,
0xf833f5b3,0xfd42fabe,0x01b7ff9f,0x057603a2,0x0907073e,0x0cc60ad6,0x114a0ee8,0x171b1403,
0x1e241a82,0x25a221e5,0x2cca2947,0x33123016,0x383635be,0x3cc93a90,0x41893f00,0x47db4484,
0x4e544b43,0x535c50fa,0x57135575,0x578157e3,0x52d655d1,0x49974eab,0x3d6a43cd,0x2fa1369c,
0x21d128a1,0x146a1b11,0x07600dd5,0xfb250119,0xf0b6f5a8,0xe8ecec80,0xe32fe5d2,0xdf07e0f5,
0xdc2cdd6c,0xda76db3b,0xd8eed9ba,0xd6b9d7f1,0xd401d55e,0xd1a0d2bf,0xd00fd0b1,0xd01ccfda,
0xd21ad0e1,0xd57ad3ad,0xd90bd75a,0xdbbdda86,0xdd97dcbf,0xdefede57,0xe016df95,0xe0bae076,
0xe0e7e0de,0xe13be0f5,0xe224e1a7,0xe326e2a3,0xe451e3b6,0xe639e511,0xe9fae7d1,0xf061eccc,
0xf93af4a2,0x01f0fdc5,0x08ca0596,0x0db30b7c,0x11d70fc0,0x15be13e3,0x1830173a,0x185e1890,
0x16a317ae,0x14041562,0x113d12a1,0x0e710fdd,0x0afd0cda,0x070a08fc,0x03870538,0x003401db,
0xfd15fe99,0xfac3fbbf,0xfa6efa50,0xfbd4fb0a,0xfcfdfc87,0xfdabfd60,0xfdaafdc9,0xfca9fd47,
0xfaa9fbc8,0xf83ff96e,0xf5c2f70d,0xf2bff452,0xef8bf11d,0xed09ee2a,0xeb9eec33,0xeae5eb31,
0xeaa0eabb,0xe9bbea5e,0xe77ee8ba,0xe514e635,0xe3a2e439,0xe313e344,0xe31ce304,0xe478e391,
0xe787e5d8,0xeb33e957,0xef40ed21,0xf3d7f180,0xf8a7f643,0xfcaefacf,0xffcdfe4d,0x0267012d,
0x050903a4,0x089a06b1,0x0d9e0ae5,0x146910d4,0x1c041832,0x23c21fde,0x2b57279a,0x328f2efd,
0x39653610,0x3fd93c99,0x46d2434a,0x4daa4a56,0x536650b5,0x581755d9,0x5af559f3,0x595c5ad7,
0x52705685,0x47314d4d,0x39564069,0x2aef3220,0x1d1723e9,0x0fb1165c,0x02ce092a,0xf708fcaf,
0xed3ff1e1,0xe5fee953,0xe0abe323,0xdcd5de8a,0xdae8dbad,0xda37da77,0xd982d9ef,0xd818d8e6,
0xd61dd71a,0xd433d51c,0xd309d37e,0xd354d2f8,0xd52dd41f,0xd7bbd666,0xda26d8fa,0xdc18db38,
0xdd9cdce4,0xdef2de45,0xe03edfa2,0xe115e0b5,0xe190e152,0xe2a0e204,0xe3eee34a,0xe535e48c,
0xe6c1e5ee,0xe90ce7c2,0xed2aeac2,0xf437f057,0xfcdbf889,0x044600cd,0x0a0e075e,0x0ea00c5e,
0x131a10f2,0x166414f3,0x178c174a,0x16531733,0x136814ff,0x100311ad,0x0cd40e67,0x09340b25,
0x053d0722,0x02180392,0xff8600c7,0xfcf0fe40,0xfac7fbb7,0xfa82fa55,0xfc12fb2c,0xfdb4fcf0,
0xfe8dfe42,0xfe49fe98,0xfceefdb4,0xfb0afc06,0xf911fa07,0xf75ff83a,0xf516f65a,0xf218f39b,
0xef66f0ae,0xed74ee4f,0xec7eecdb,0xec52ec57,0xebeeec3d,0xea97eb5e,0xe8ece9b9,0xe79be83a,
0xe676e706,0xe55be5e5,0xe515e508,0xe682e58e,0xe985e7da,0xed14eb4b,0xf0fceef6,0xf57bf331,
0xf993f7a8,0xfcddfb4c,0xff49fe34,0x00f6002a,0x031c01e1,0x06710496,0x0c1508fa,0x13100f88,
0x1a2b16a1,0x21791dc8,0x293a2547,0x31842d5d,0x39cf35a9,0x420d3df4,0x49b04600,0x50624d2b,
0x55a65331,0x59c857da,0x5c0c5b51,0x59815b74,0x5219565b,0x46654cbe,0x37da3f49,0x29313076,
0x1aed2209,0x0cf913e2,0xff9f062c,0xf38ff956,0xea41ee7c,0xe3b1e6bb,0xdeb3e106,0xdb5adcc8,
0xd9f2da69,0xd9e0d9d5,0xd9cfd9e6,0xd8e6d97e,0xd72ad80e,0xd55fd643,0xd460d4b1,0xd4c4d470,
0xd64ad566,0xd85cd752,0xda4fd95e,0xdbc3db20,0xdcc9dc49,0xddfedd56,0xdf86dec1,0xe0efe043,
0xe27ae1a1,0xe45ee36f,0xe5f9e52e,0xe78de6c6,0xe8f6e843,0xeae3e9c9,0xef23ec92,0xf6aef293,
0xff69fb1a,0x06c1035b,0x0c4b09b1,0x10f70eb3,0x14e11312,0x172d1641,0x174f178d,0x1502166e,
0x113c1334,0x0d8f0f56,0x09f30bce,0x05d807f2,0x023903de,0xffd400ee,0xfdb0fece,0xfb1afc67,
0xf9a8fa15,0xfa97f9d9,0xfcacfba0,0xfe57fd9b,0xfecffec8,0xfd8efe62,0xfb6afc8a,0xf959fa54,
0xf7caf881,0xf609f70c,0xf359f4bd,0xf0abf1f4,0xee7def81,0xece3ed97,0xec66ec76,0xecc0ec96,
0xec3beca7,0xeadaeb8e,0xe9c9ea41,0xe8c4e957,0xe72be802,0xe5b0e65c,0xe5ade569,0xe79ce677,
0xeae2e916,0xeef4ece7,0xf327f101,0xf78af55d,0xfb38f985,0xfdc5fc9d,0xff64feaf,0x00b0000e,
0x02760167,0x06460411,0x0c1c08f8,0x12c50f69,0x195b1616,0x204e1cb9,0x28b22452,0x31ce2d3a,
0x3b353674,0x44903ff6,0x4c9d48d3,0x52b84fe5,0x5735551a,0x5ad25923,0x5c225bf1,0x59365b33,
0x519d5602,0x45584c0f,0x36673df5,0x27602edd,0x18c2200a,0x0a7d1193,0xfcd20386,0xf0def684,
0xe7ffec0d,0xe15ce47d,0xdc17de8a,0xd8b8da1b,0xd7bed7f9,0xd880d7fa,0xd948d906,0xd8f4d945,
0xd7cfd86e,0xd6b6d72b,0xd677d67b,0xd718d6ab,0xd871d7b3,0xda4ed960,0xdbc5db25,0xdc52dc1f,
0xdcd2dc81,0xdde7dd48,0xdf93deab,0xe1d7e0a9,0xe41be302,0xe5ffe517,0xe7d1e6e7,0xe938e88f,
0xea44e9c0,0xec38eaff,0xf113ee38,0xf8e6f4ba,0x018ffd50,0x08a20559,0x0e200b82,0x12a11081,
0x15d41471,0x173a16cc,0x162d1702,0x12f014c8,0x0ed910e5,0x0ac20cd5,0x061d0885,0x018103b3,
0xfe53ffaf,0xfc84fd54,0xfa93fba6,0xf8bff97d,0xf8ecf88e,0xfadcf9c4,0xfd3efc07,0xff22fe62,
0xff04ff55,0xfd35fe42,0xfaf5fc0c,0xf96dfa1c,0xf7f7f8be,0xf58ef6e2,0xf2dcf432,0xf094f1ab,
0xeeb1ef99,0xed82edeb,0xed9ced74,0xed76edad,0xec6becf9,0xebbaec02,0xeb19eb79,0xe99bea76,
0xe769e890,0xe5d4e667,0xe64ee5d2,0xe839e717,0xeba0e9c4,0xefcfedad,0xf43cf20e,0xf82ef642,
0xfb49f9e8,0xfcddfc45,0xfdaefd41,0xfecbfe2c,0x00f7ffac,0x052002c7,0x0adb07e0,0x11210df5,
0x17ae1459,0x1f9c1b5e,0x296e2462,0x34062e9a,0x3f7539b7,0x4a384509,0x52bf4edf,0x585355d2,
0x5ca65a86,0x5f8f5e76,0x5e9d5f9e,0x58e95c5d,0x4e925452,0x407647cb,0x312738dc,0x21fd2984,
0x13491a9c,0x04aa0be2,0xf768fdc3,0xed0ff1e2,0xe4fee8d5,0xde3ce175,0xd934db70,0xd662d784,
0xd5c7d5cd,0xd68bd620,0xd701d6d5,0xd724d71c,0xd711d71b,0xd7aed742,0xd903d847,0xdaa7d9ca,
0xdc92db9a,0xddc2dd51,0xddb3dde7,0xdd1add62,0xdd3fdd0b,0xde61ddaf,0xe097df64,0xe353e1e6,
0xe618e4be,0xe8a4e767,0xeae6e9d8,0xec66ebc3,0xed7eecdf,0xf062ee93,0xf63ff2fe,0xfdd5f9fb,
0x04dd0183,0x0a8507dc,0x0f320cf1,0x12ed113e,0x152b143d,0x156d158d,0x138a14c0,0x102711f5,
0x0c2a0e37,0x076c09eb,0x021b04bd,0xfdf7ffcb,0xfb96fc97,0xf9cffaba,0xf7c1f8c1,0xf700f71d,
0xf856f772,0xfaa7f96a,0xfd53fc0b,0xfeb9fe45,0xfe3afeaf,0xfc7ffd70,0xfad6fb9b,0xf971fa27,
0xf766f88a,0xf4e2f624,0xf296f3b5,0xf079f184,0xeea7ef7b,0xedddee20,0xed77edb7,0xec91ed12,
0xebedec23,0xec02ebed,0xeba9ebf9,0xea0deafc,0xe828e908,0xe7c2e7bb,0xe8d8e822,0xeb7be9f2,
0xef76ed5e,0xf3e4f1b3,0xf788f5cf,0xfa82f925,0xfc22fb85,0xfc97fc71,0xfcdefcb8,0xfda5fd26,
0xffe2fe80,0x040001c0,0x093e0682,0x0f180c27,0x159c1229,0x1e3c19a4,0x28ad2343,0x34a72e83,
0x40ff3ade,0x4c3846d8,0x54c250e7,0x5a5b57d0,0x5ea35c93,0x6125604f,0x5f6160dd,0x59015cbe,
0x4dd05409,0x3efe469c,0x2f523733,0x1fe02788,0x10af1845,0x01f90932,0xf560fb4a,0xeb8bf02a,
0xe352e750,0xdc56dfa0,0xd793d9a5,0xd541d621,0xd4f7d4e6,0xd563d534,0xd580d57b,0xd574d575,
0xd5ccd584,0xd71bd657,0xd94fd821,0xdbe9da93,0xde35dd2d,0xdee3deca,0xde00de84,0xdd2edd87,
0xdd41dd0b,0xdeeadde3,0xe1abe03a,0xe48ce31c,0xe787e60a,0xea65e8ff,0xec84eb9a,0xed96ed24,
0xef09ee1f,0xf2c3f089,0xf91bf5aa,0x009dfcdd,0x077e0430,0x0d1c0a72,0x118a0f77,0x14dc1360,
0x162215cf,0x153d15f2,0x126b13fd,0x0eb710ae,0x09cc0c71,0x03cf06d8,0xfe9d00fb,0xfb42fcb6,
0xf94dfa32,0xf768f860,0xf62cf69e,0xf6a9f633,0xf84ef764,0xfacbf973,0xfd0cfc18,0xfd98fd8c,
0xfc99fd3a,0xfb2cfbd3,0xfa4cfab7,0xf8def9b8,0xf6c3f7cf,0xf4cdf5c4,0xf2fcf3e3,0xf10cf208,
0xef7ef027,0xee75ef02,0xecdaedb5,0xeb83ec0e,0xeb4aeb47,0xeb70eb67,0xea85eb2a,0xe8aae9a0,
0xe784e7e7,0xe7b0e779,0xe966e847,0xece2eafc,0xf188ef12,0xf65ff40d,0xfa23f866,0xfca3fb94,
0xfda4fd4b,0xfdd1fdc8,0xfde9fdcd,0xff02fe50,0x015f000c,0x04bd02ee,0x095f06e5,0x0f080c14,
0x163f126c,0x1f2c1a7c,0x2a1d2463,0x3665302a,0x42f63cac,0x4e6b48fe,0x56af52fd,0x5c5b59bd,
0x60925eaf,0x61a961a8,0x5e5b608b,0x56ba5b26,0x4a915116,0x3c19438c,0x2cbc3473,0x1d1a24f4,
0x0d6d1539,0xfedd05e5,0xf2e2f886,0xe933eddc,0xe0a2e4cb,0xd9badce8,0xd574d737,0xd3bcd450,
0xd376d389,0xd34dd360,0xd34ad349,0xd359d34d,0xd476d3b1,0xd6ffd591,0xdaa8d8b5,0xdebddcbe,
0xe165e058,0xe18ee1cb,0xe029e0f1,0xdebadf5d,0xdeb7de7b,0xe079df66,0xe30de1b2,0xe5f6e476,
0xe924e787,0xec1aeab3,0xee3fed54,0xefd3eeff,0xf244f0d8,0xf6e5f447,0xfd69f9fe,0x043300df,
0x0a4b0759,0x0f320cef,0x12f3112c,0x155e1465,0x159e15c7,0x138314d8,0x100711dd,0x0b620de8,
0x05470872,0xff7e0239,0xfb67fd36,0xf8f8fa04,0xf6fcf7fd,0xf574f616,0xf543f52a,0xf634f5a6,
0xf80af6f7,0xfa72f94c,0xfbb6fb45,0xfbb8fbda,0xfb25fb6b,0xfb0efb09,0xfa7ffaef,0xf8caf9bf,
0xf6e5f7ce,0xf52af603,0xf387f45d,0xf1e9f2af,0xf090f13e,0xee8befb0,0xec41ed4a,0xeb3feb98,
0xeb0deb1f,0xea74eae2,0xe8c5e9b1,0xe769e7f3,0xe72be72a,0xe822e779,0xeac4e93d,0xeee8eca9,
0xf3ecf168,0xf882f64d,0xfbe1fa6d,0xfd5bfcd6,0xfdc9fda0,0xfde8fde2,0xfe49fe00,0xff80fec9,
0x017b0072,0x041d02a8,0x07f705da,0x0dc30a9d,0x1572115e,0x1f0219f8,0x2a852494,0x371830b5,
0x43b43d7f,0x4ed54983,0x57935387,0x5d8b5add,0x61795fc1,0x62ba628c,0x600a61ed,0x58385cc6,
0x4bce527c,0x3cb8446e,0x2c9534c6,0x1c1f2453,0x0c71141a,0xfe500530,0xf1ecf7d8,0xe790ec87,
0xdeb8e2f3,0xd7e2dafc,0xd3c0d576,0xd218d2b1,0xd190d1c3,0xd0f8d151,0xd001d07d,0xcf87cfa5,
0xd05acfb4,0xd337d17a,0xd83bd585,0xddc2db1e,0xe162dfe8,0xe253e22e,0xe128e1f0,0xdf75e035,
0xdf9bdf35,0xe1cee08a,0xe4f2e352,0xe863e6a0,0xebd2ea2e,0xee66ed35,0xf042ef61,0xf235f126,
0xf527f38a,0xf9bbf726,0x0066fcdc,0x07c3041c,0x0e330b2c,0x129f10ad,0x154b1418,0x166e1616,
0x15c51655,0x132a14b2,0x0f4e115f,0x09cb0ccb,0x0311066f,0xfd9e0010,0xfa1efbae,0xf7d7f8df,
0xf636f6f1,0xf599f5c1,0xf5adf59c,0xf5dcf5bd,0xf6ecf63e,0xf835f7a2,0xf8ccf89c,0xf8a0f8c4,
0xf8c8f893,0xf979f928,0xf96af990,0xf88bf90d,0xf734f7eb,0xf58cf66d,0xf383f491,0xf18ef27e,
0xef7af097,0xecc1ee27,0xeaa3eb81,0xea1bea31,0xea69ea43,0xea07ea5c,0xe8fee988,0xe85ae896,
0xe83be834,0xe997e89e,0xecb4eafa,0xf11feec3,0xf62df3a8,0xfadaf8a1,0xfdd2fc9d,0xfec0fe81,
0xfe9efebf,0xfe43fe69,0xfe97fe4f,0xffb2ff0f,0x01470070,0x03ae0253,0x07be056d,0x0e290aa9,
0x1654120b,0x20451b0f,0x2be025df,0x38513216,0x44493e6f,0x4f1849df,0x57ab53be,0x5d775ae1,
0x618f5fb2,0x632362d3,0x5fdc623f,0x57665c31,0x4ab0518f,0x3b654336,0x2add333c,0x1a392279,
0x0ac51248,0xfcc5039f,0xf07ff65a,0xe644eb25,0xddd2e1d3,0xd739da3b,0xd351d4eb,0xd182d23b,
0xd07ad0f9,0xceeecfd2,0xccfacded,0xcbe8cc4d,0xcc79cbe7,0xcfddcdbf,0xd607d2bd,0xdc66d950,
0xe119df06,0xe343e28a,0xe2fae35c,0xe237e27a,0xe31de269,0xe57fe42e,0xe87ce6f8,0xebadea15,
0xee75ed2b,0xf078ef89,0xf258f15d,0xf4c5f372,0xf833f658,0xfd67fa89,0x046e00bf,0x0bae082b,
0x11400ec2,0x14971336,0x1608157c,0x16201643,0x14d215a5,0x11de1393,0x0d2d0fc1,0x06a40a1a,
0x000a032e,0xfb5efd6f,0xf840f9a9,0xf623f712,0xf531f585,0xf530f51b,0xf519f530,0xf50af503,
0xf5aff54a,0xf64ff60a,0xf652f665,0xf64ef638,0xf71ef69d,0xf816f7a7,0xf8a1f865,0xf86af8a5,
0xf764f7fa,0xf5d6f6ad,0xf41ef4f3,0xf274f356,0xefc6f145,0xec96ee22,0xea88eb5f,0xe9a0e9fb,
0xe92be963,0xe85ae8d8,0xe771e7d2,0xe70ee739,0xe74fe701,0xe95fe825,0xecceeae2,0xf1b8ef22,
0xf725f46b,0xfc07f9c0,0xff2bfddd,0x003dffea,0x0043004b,0x007a0054,0x015500cf,0x026a01e3,
0x03b302fb,0x05dd049b,0x0a0207a6,0x10370ce9,0x18771407,0x22e61d82,0x2e622890,0x3a313445,
0x45e34015,0x50634b6b,0x587254c3,0x5e6e5ba3,0x624f60bb,0x623a62e8,0x5cfd6030,0x539158c2,
0x46ed4d92,0x38083fb5,0x27e8300d,0x17c71fc4,0x088b1000,0xfab50169,0xeec3f473,0xe4e5e99d,
0xdcb2e095,0xd6b6d95e,0xd321d4ae,0xd101d1ef,0xcf35d02d,0xcc9fce05,0xca14cb35,0xc8d0c93a,
0xc9b6c8ea,0xcde8cb67,0xd45ed100,0xdb07d7c3,0xe05bddec,0xe326e21a,0xe3f4e3ac,0xe4c7e442,
0xe6b0e59f,0xe91ce7dc,0xebe3ea75,0xeea2ed4a,0xf0deefd8,0xf2abf1bd,0xf501f3c0,0xf813f679,
0xfc41f9f3,0x0223ff02,0x08d00575,0x0e9e0bec,0x12a310da,0x14b713ec,0x151e1519,0x146414df,
0x12ba13b2,0x0f9f115b,0x0aba0d6d,0x046907a2,0xfecf0165,0xfad0fc9c,0xf842f964,0xf6c2f761,
0xf612f65a,0xf5bff5e2,0xf545f588,0xf522f51c,0xf541f53d,0xf4e8f526,0xf44ef499,0xf443f427,
0xf525f49e,0xf62cf5b3,0xf700f6a3,0xf700f719,0xf691f6d8,0xf58ff620,0xf47bf502,0xf2c2f3ca,
0xef88f150,0xec34edbe,0xea06eaf5,0xe8d8e95d,0xe81ee878,0xe730e7ad,0xe69be6d3,0xe651e66a,
0xe724e67c,0xe98ee835,0xed95eb5c,0xf2a5f00b,0xf7f0f556,0xfc5efa4c,0xff50fe10,0x0061000c,
0x0091007a,0x013b00cd,0x026701cc,0x037202ee,0x050c0426,0x07b80628,0x0c4a09cb,0x12790f1f,
0x1b2e1678,0x25df2065,0x31022b6e,0x3c6336a7,0x47b0421c,0x51c84cf8,0x59b355f3,0x60075d17,
0x6391624a,0x61e0637d,0x5b315f06,0x50ad5662,0x43714a48,0x34583c14,0x24322c56,0x14201c14,
0x05030c6a,0xf7a1fe07,0xecc6f1e6,0xe407e82b,0xdd01e049,0xd7edda3d,0xd445d5f4,0xd172d2cb,
0xce24cfef,0xca14cc23,0xc69ec835,0xc4b7c567,0xc5b7c4bd,0xca31c799,0xd0c6cd4d,0xd7e9d468,
0xdde7db25,0xe1fce02e,0xe4dbe376,0xe7bbe644,0xea8ee930,0xed04ebcd,0xef60ee37,0xf19ff087,
0xf36ef294,0xf584f45f,0xf876f6df,0xfc6bfa50,0x01fbfeed,0x08e40561,0x0f730c61,0x13d811f1,
0x161d153c,0x166b1672,0x15a21623,0x142214f4,0x11961311,0x0d060f9e,0x068d09e6,0x008d0363,
0xfbd9fe04,0xf888fa13,0xf637f72d,0xf57bf5b0,0xf55af56f,0xf495f50d,0xf3e7f427,0xf3d7f3d4,
0xf38bf3c6,0xf2b5f32c,0xf20ef247,0xf247f20f,0xf2fef29c,0xf3fff372,0xf50cf48f,0xf5d6f578,
0xf62df61c,0xf648f631,0xf5c8f640,0xf336f4b6,0xeff7f18a,0xed50ee90,0xeb2eec33,0xe950ea35,
0xe7bce87b,0xe6c5e72b,0xe612e66a,0xe610e5e8,0xe744e684,0xea14e868,0xee5eec24,0xf369f0c6,
0xf8aff61d,0xfd0efb06,0xfff3feb8,0x013b00c1,0x01f00199,0x02ce0259,0x03750329,0x043b03cb,
0x05bb04cf,0x08e8071b,0x0d790b08,0x1418106f,0x1d3f1871,0x27a3225d,0x32312cf0,0x3cc9376c,
0x475f422b,0x50bc4c4a,0x585e54bd,0x5e8b5bad,0x617a609d,0x5f746107,0x59415cdc,0x4f6a54b8,
0x42ba4960,0x34243b98,0x24982c6a,0x14e41cbf,0x05920d1c,0xf81ffe83,0xed7ff275,0xe504e914,
0xde1de158,0xd8d3db51,0xd4cdd6a8,0xd156d319,0xcd11cf48,0xc885cac5,0xc482c663,0xc26dc31d,
0xc346c27b,0xc6c0c4b2,0xcc81c95f,0xd369cff3,0xd9bdd6b8,0xdee1dc6e,0xe39ee13c,0xe859e606,
0xec63ea7a,0xefc8ee28,0xf26cf131,0xf45bf37f,0xf5c4f50a,0xf7e4f6b5,0xfabef93f,0xfe8bfc74,
0x043f0127,0x0b7007bf,0x11ea0eed,0x16121444,0x17f31748,0x1826183b,0x172817c0,0x15671666,
0x121e13fd,0x0ce30fc8,0x069709b9,0x011203aa,0xfccafed0,0xf961faf9,0xf74df822,0xf67ef6cd,
0xf5c4f62f,0xf49df532,0xf3caf425,0xf33df38b,0xf240f2ce,0xf109f19f,0xf03ff089,0xf038f024,
0xf0cff072,0xf1eaf14f,0xf331f28c,0xf485f3e4,0xf556f4fc,0xf5e9f5ad,0xf52af5c8,0xf28af408,
0xef5ff0e6,0xecc2ee03,0xea3beb80,0xe810e90f,0xe673e730,0xe57ee5e2,0xe508e535,0xe583e51e,
0xe726e62b,0xea31e881,0xee4dec22,0xf32cf0ae,0xf836f5b2,0xfcd7faa6,0x0013fea4,0x022c013a,
0x03b002f8,0x04d70457,0x0567052c,0x060705a8,0x07c306af,0x0b34094e,0x10000d66,0x16e31324,
0x1fe91b31,0x29d824e0,0x33d62ed6,0x3e0338e4,0x481b4318,0x50f04cc0,0x582854af,0x5e075b62,
0x5ffa5f9e,0x5dad5f45,0x57865b18,0x4dc85307,0x41b447f0,0x33ed3b04,0x24f02c86,0x15411d27,
0x05b60d62,0xf857fe9b,0xee4bf2f9,0xe62dea0c,0xdf91e2af,0xda23dcb6,0xd5b2d7d3,0xd157d39a,
0xcc5eceeb,0xc712c9bb,0xc24bc488,0xbfacc09c,0xbf9abf55,0xc1ddc06b,0xc6fcc415,0xcddfca59,
0xd486d148,0xdabfd7a5,0xe112dde3,0xe749e437,0xed19ea41,0xf1d1efa8,0xf508f393,0xf742f63d,
0xf945f831,0xfbbefa7c,0xfe7afd08,0x026c0039,0x0874052b,0x10200c40,0x16af13af,0x1a9518fd,
0x1b791b5f,0x1abd1b3a,0x192d1a0a,0x16c6181c,0x126814ef,0x0bfa0f54,0x05c608b9,0x00cb031d,
0xfcdbfec3,0xf955faff,0xf743f818,0xf65ef6be,0xf547f5e1,0xf420f4ac,0xf30cf396,0xf1d1f27a,
0xf03ff10d,0xeeecef7d,0xee2aee7e,0xedb9edee,0xedd6edaa,0xeea8ee2b,0xf010ef52,0xf177f0c5,
0xf337f242,0xf4acf424,0xf3f5f49a,0xf1f7f2fe,0xefddf0ec,0xed67eeb7,0xea95ebff,0xe7f1e92f,
0xe68ce70f,0xe5d2e62d,0xe5b3e59e,0xe683e607,0xe86de742,0xeb8ae9e3,0xef72ed63,0xf3faf1a7,
0xf8bef65c,0xfd07fb00,0x0063fecf,0x02fe01ca,0x04d903fe,0x05e80573,0x06a50646,0x07a40706,
0x0a1008ad,0x0d9f0bb9,0x12cb0fec,0x1a121636,0x22a11e31,0x2bd92735,0x35733092,0x3f583a61,
0x4907444e,0x51264d52,0x57ed549f,0x5d055ae4,0x5dfa5e08,0x5ab15cd8,0x53bb57a6,0x49a84efd,
0x3dff43fa,0x30dd37a2,0x224329b3,0x12941a85,0x03470aad,0xf723fcb5,0xee0bf25b,0xe6a7ea28,
0xe05be364,0xdb20dd9d,0xd67dd8d5,0xd16dd40f,0xcb9ace94,0xc57ec882,0xc082c2c6,0xbdf6beec,
0xbdd0bd98,0xc054beb8,0xc57cc29c,0xcbefc8a6,0xd237cf1f,0xd8ccd569,0xdff0dc51,0xe773e3a9,
0xeeb6eb37,0xf455f1be,0xf82cf67a,0xfa85f97a,0xfca0fb8b,0xfeccfdba,0x01750000,0x05d60356,
0x0ceb090e,0x14df1102,0x1a681818,0x1c9e1be1,0x1c6c1cbe,0x1b251be1,0x19301a45,0x163817db,
0x11421409,0x0acf0e11,0x050a07c0,0x007e02a9,0xfcb9fe8c,0xf959faee,0xf74af825,0xf620f6ae,
0xf4a6f56f,0xf33df3e4,0xf218f2a9,0xf0e4f184,0xef85f03a,0xee0beec1,0xed10ed7d,0xec59ecad,
0xec3cec36,0xecb8ec63,0xedd6ed3d,0xef48ee80,0xf171f043,0xf32bf27e,0xf2fef34f,0xf1f3f27d,
0xf08cf156,0xee07ef71,0xeafaec7e,0xe836e97d,0xe6b5e750,0xe5cee631,0xe60ee5bf,0xe722e687,
0xe915e7fe,0xebcaea54,0xef21ed68,0xf325f10b,0xf783f556,0xfb80f997,0xff03fd47,0x0220009f,
0x04a4037c,0x0651058e,0x07b60704,0x099d0884,0x0ce30b19,0x11300eda,0x174f1401,0x1f111b0f,
0x275d232e,0x30402bb4,0x399b34e7,0x43233e6b,0x4ba24782,0x53294f7c,0x599a56a3,0x5cb25ba9,
0x5b425c89,0x55f65916,0x4d6351f2,0x43a84896,0x39033e8b,0x2cce331f,0x1eb32608,0x0f411703,
0x013607de,0xf651fb63,0xee07f1e0,0xe770ea94,0xe1d7e491,0xdca4df3e,0xd73bd9fb,0xd10ad43f,
0xca66cdb5,0xc440c73e,0xbf7ec198,0xbcc5bdde,0xbc6dbc42,0xbeefbd53,0xc394c112,0xc937c654,
0xcf6ccc36,0xd6a5d2de,0xdeb1da97,0xe725e2e9,0xeeb7eb21,0xf51df212,0xf9eaf7be,0xfd83fbc9,
0x008dff19,0x033c01d8,0x068f04c2,0x0c0008ea,0x13880fae,0x1a441736,0x1dd81c82,0x1e3c1e59,
0x1d551dd4,0x1bc81ca5,0x19941acf,0x15e417fd,0x1032133b,0x0a090d01,0x050d075e,0x013d0313,
0xfd82ff69,0xfa14fbae,0xf7a3f8b4,0xf5d5f6c1,0xf3dff4d2,0xf254f308,0xf112f1b9,0xef7af04b,
0xed97ee93,0xebe9eca7,0xead3eb5e,0xe9bfea40,0xe93ee964,0xe98be949,0xea6ce9ec,0xec51eb31,
0xef34edba,0xf149f073,0xf20ef1c2,0xf272f255,0xf17ef233,0xef18f063,0xebf9eda1,0xe8f7ea52,
0xe710e7e8,0xe5e2e656,0xe60ae5d5,0xe70be66c,0xe8e3e7e6,0xeb61ea0c,0xeeb3ecef,0xf2caf0ae,
0xf736f500,0xfb65f953,0xff5bfd6c,0x03090139,0x05fc04ac,0x07eb06fe,0x09c908d4,0x0c910b04,
0x10250e49,0x14b2123e,0x1ad81791,0x21ef1e50,0x29bf25bd,0x329b2e05,0x3c1c3753,0x457140e2,
0x4dbb49b2,0x55145182,0x5af85861,0x5cbc5c6e,0x59e75bd4,0x52f756e9,0x49914e69,0x3fd944b3,
0x358c3ade,0x29e02fea,0x1c182335,0x0d8f14c5,0x00bb06d3,0xf6a7fb64,0xee9cf263,0xe83deb49,
0xe2cee56e,0xddbce04e,0xd7dfdaf4,0xd0d2d472,0xc977cd18,0xc2bcc5f8,0xbd7dbfe8,0xba57bb9a,
0xba32b9db,0xbce4bb3e,0xc175bf00,0xc6c7c410,0xcce6c9b3,0xd426d066,0xdc48d81c,0xe4d4e091,
0xece0e8ee,0xf431f0aa,0xfa4af763,0xff81fd00,0x03a001b7,0x07140562,0x0b3d08f4,0x11920e1a,
0x1938156a,0x1f1a1c9a,0x215c20a7,0x20e52166,0x1f5a2029,0x1d5d1e6c,0x1a761c12,0x160b1874,
0x102a133d,0x0a660d1e,0x0614081b,0x0275043d,0xfe8e008b,0xfb2bfcbb,0xf8a1f9d0,0xf622f774,
0xf3a1f4c9,0xf1ccf2ab,0xf029f0fb,0xee73ef58,0xec73ed72,0xeadfeb98,0xe963ea28,0xe7e6e899,
0xe6c9e74a,0xe68fe685,0xe750e6ca,0xe96ae82e,0xec52eae3,0xee66ed87,0xefdcef1b,0xf10af09a,
0xf06ef100,0xee54ef83,0xeb29ecd5,0xe87be9a5,0xe6dce793,0xe63de658,0xe6f0e683,0xe848e786,
0xea01e91f,0xec2feb06,0xef21ed85,0xf2f7f0f9,0xf718f509,0xfb32f920,0xff5bfd4c,0x0329014f,
0x063b04d5,0x08a10770,0x0b4509d8,0x0efe0d01,0x132b1103,0x18a415af,0x1f9a1c03,0x26ca2337,
0x2e562a73,0x36f03284,0x3ffc3b81,0x480b4425,0x4f534bc9,0x55b752a9,0x5986581c,0x590359d6,
0x54925746,0x4ca750ea,0x439b4828,0x3a873f16,0x30aa35b8,0x25662b48,0x18991f21,0x0bbd1209,
0x00ba05f1,0xf794fbf5,0xf049f3ad,0xea61ed3f,0xe513e7ae,0xdf92e26d,0xd8d7dc67,0xd118d508,
0xc960cd30,0xc24ec5ae,0xbcb8bf4b,0xb95ebab1,0xb926b8de,0xbb7eba13,0xbf92bd67,0xc489c1ec,
0xcab4c775,0xd202ce46,0xda2bd5fc,0xe29ade72,0xeaf9e6c4,0xf31fef1e,0xfa94f6e7,0x0152fe17,
0x0697041a,0x0b1d08e4,0x10880d94,0x179013f0,0x1e761b36,0x227f20ea,0x2332232c,0x21e322ad,
0x1ff820fb,0x1da41ede,0x1a421c1b,0x15851814,0x0fdd12ae,0x0b4a0d5f,0x07ba096c,0x040b05fc,
0xffdd01f2,0xfc39fdef,0xf976facb,0xf68ef809,0xf403f52f,0xf20bf2fe,0xf007f10d,0xedc2eeec,
0xeb86ec97,0xe9aaea93,0xe794e8aa,0xe58ae684,0xe3f0e4a4,0xe363e385,0xe42ae399,0xe684e52c,
0xe948e7f7,0xeb75ea63,0xee02ecac,0xefdeef27,0xefd2f010,0xee30ef3a,0xeb1decb2,0xe881e9b5,
0xe6dae788,0xe6bae694,0xe7b9e722,0xe973e88c,0xeb51ea5e,0xed6bec4b,0xf041eeba,0xf3dbf1ff,
0xf79ff5c1,0xfb7ff98c,0xff6efd76,0x03460163,0x068b04f5,0x09b90820,0x0d900b76,0x12370fe5,
0x16f51485,0x1cdd19ba,0x23662025,0x29af268b,0x306a2cee,0x38423434,0x408a3c6c,0x485d4488,
0x4f374beb,0x55085253,0x5828571f,0x56cb5801,0x51575494,0x48fe4d6a,0x3f964446,0x363b3aed,
0x2c983180,0x21ce2759,0x15d91beb,0x0a4f0fe9,0x007a052c,0xf7f5fc0b,0xf113f44b,0xeb8eee35,
0xe6afe912,0xe177e439,0xdaacde45,0xd2b7d6bf,0xca9bceab,0xc306c6b0,0xbcdfbfba,0xb924ba98,
0xb88bb875,0xba79b93c,0xbe06bc1d,0xc2cec03d,0xc917c5cc,0xd073cca3,0xd886d476,0xe0c4dc9f,
0xe910e4e6,0xf14ced40,0xf928f540,0x007efcec,0x06ea03da,0x0caf09c3,0x139c0fed,0x1bba17a0,
0x22ab1f8d,0x25f924ca,0x261b2667,0x242b254a,0x21ad22ee,0x1ecf2055,0x1af41d01,0x160718a8,
0x10a5133c,0x0c9d0e76,0x09390ae8,0x05650769,0x013b0349,0xfdb9ff55,0xfaeefc4f,0xf7ccf963,
0xf4f6f653,0xf26cf3ab,0xf013f140,0xed6ceed7,0xeaaaebfe,0xe842e977,0xe5a9e6f9,0xe340e466,
0xe193e243,0xe146e146,0xe23fe195,0xe499e34f,0xe714e5ea,0xe93ee81d,0xec05ea99,0xee14ed39,
0xee87ee7d,0xed1aee17,0xea50ebbe,0xe7ede901,0xe6b4e723,0xe724e6c4,0xe868e7b1,0xea01e933,
0xeb8beac1,0xed82ec72,0xf04eeec7,0xf3cff201,0xf793f5af,0xfb75f97b,0xff87fd76,0x03820195,
0x0707054a,0x0aab08c9,0x0f770ce7,0x14cf1226,0x1a571775,0x20e31d86,0x27682437,0x2d5b2a67,
0x33d33079,0x3b643783,0x43473f47,0x4ad34736,0x50f54e0c,0x55b85398,0x56cd56df,0x53bf55bc,
0x4d3850db,0x446048fa,0x3b053fba,0x31783643,0x27c42caa,0x1d6122ad,0x12a31803,0x08be0d82,
0x0019044d,0xf863fc15,0xf24df521,0xed86efcc,0xe8fceb4d,0xe36de671,0xdbf0dfe8,0xd351d7b3,
0xca8ecee2,0xc2cec684,0xbcadbf76,0xb923ba95,0xb850b864,0xb9a2b8cb,0xbc58bac9,0xc10abe70,
0xc787c41c,0xcef7cb29,0xd69fd2ce,0xde72da7b,0xe6d2e294,0xef4beb1a,0xf7a2f372,0xffd2fbcc,
0x0738039c,0x0ec30ad9,0x1786130c,0x203d1c0a,0x262c23b1,0x285c27ac,0x278a2840,0x254a2681,
0x229423f7,0x1f7f211d,0x1b861da4,0x16b4192c,0x1251145e,0x0f0d1099,0x0bf20d94,0x07da0a00,
0x038705a4,0x000001a9,0xfcb7fe63,0xf95efafd,0xf677f7de,0xf3b8f51a,0xf0ecf257,0xeda1ef56,
0xea6febfb,0xe735e8e2,0xe3e0e585,0xe0efe250,0xdf1ddfd3,0xdeaddec3,0xdfaddeef,0xe202e0cb,
0xe410e315,0xe674e528,0xe935e7dc,0xeb54ea67,0xec0aebeb,0xeabceb9c,0xe885e9a4,0xe6b0e783,
0xe616e62d,0xe6e1e65e,0xe86be798,0xe9fbe93c,0xeb76eab2,0xed63ec53,0xf013eeaa,0xf350f1a8,
0xf6cdf506,0xfa98f8a5,0xfef4fcb1,0x0332011c,0x0774054f,0x0c2a09ac,0x12030eff,0x18091507,
0x1e9e1b33,0x25982227,0x2bd328d3,0x316d2ea3,0x37d03472,0x3f2d3b63,0x4739433e,0x4e434ae7,
0x540f514c,0x57885650,0x566f5782,0x516e545a,0x49574dbb,0x3fa64497,0x35913aa1,0x2b75307d,
0x2154266d,0x16e91c1f,0x0d1211d1,0x04a908b3,0xfd1200ce,0xf6a5f9a8,0xf1c7f405,0xee06efd2,
0xea1bec32,0xe461e78a,0xdc95e0ab,0xd3dfd849,0xcb66cf87,0xc3ccc771,0xbe16c0a9,0xbaa4bc10,
0xb971b9d7,0xb9c4b96c,0xbbebba8d,0xc0a9bdf6,0xc77bc3e3,0xcedccb31,0xd61fd27d,0xdd93d9c0,
0xe5b3e19b,0xedece9cc,0xf695f231,0xfefdfae1,0x071b0302,0x106c0b8a,0x1ae3159e,0x23d71fc4,
0x28ee26e1,0x2a5c2a0f,0x290b29ef,0x265f27d2,0x233e24d9,0x1f97217c,0x1b601d8f,0x16b01905,
0x12eb149f,0x0ffd116d,0x0ca60e70,0x08860aa6,0x0457065f,0x00b6027a,0xfcf1fed8,0xf9affb35,
0xf73cf867,0xf4d0f609,0xf1b4f367,0xedb4efb8,0xea19ebd9,0xe656e845,0xe26de461,0xdf2fe0a8,
0xdd56de11,0xdcb1dce0,0xddb0dcf4,0xdf90dea3,0xe147e069,0xe39ee258,0xe683e512,0xe8c6e7c7,
0xe9bbe971,0xe8fbe98a,0xe7bae855,0xe6e7e735,0xe74ee6ef,0xe881e7de,0xe9ebe931,0xeb4deaa4,
0xecb3ebf6,0xee97ed8e,0xf123efca,0xf40af293,0xf71ef58a,0xfab9f8d5,0xfed8fccd,0x02c600cc,
0x073e04e6,0x0cb709ce,0x13620ffa,0x1a8316e1,0x21f81e3a,0x2906259a,0x2f0c2c2a,0x34a531d3,
0x3ac5379c,0x41e23e3a,0x48f94583,0x4efb4c26,0x539f5191,0x54dc54bb,0x5274540b,0x4d1a502b,
0x451a4952,0x3bcb4090,0x31c136e0,0x276b2c8c,0x1d66225f,0x13b01878,0x0b150f37,0x03ab0742,
0xfd04003b,0xf7a4fa1c,0xf3baf58f,0xf057f206,0xec19ee71,0xe5ede943,0xdde9e212,0xd544d998,
0xccefd108,0xc5a5c91e,0xbffac29d,0xbc1cbdce,0xb9c4bac7,0xb8f1b922,0xba89b962,0xbf2abc77,
0xc5dec269,0xcccec954,0xd3f6d05e,0xdba5d7bd,0xe3a4dfa2,0xebc3e7a1,0xf465f00d,0xfd16f8c1,
0x0674019a,0x11140ba5,0x1bc81695,0x243c206b,0x29252724,0x2ab72a48,0x29eb2a92,0x279e28dd,
0x24b0263b,0x213c22fe,0x1d551f6d,0x19021b16,0x15db1741,0x132b1491,0x0f841181,0x0b0d0d50,
0x06cb08d8,0x02df04e2,0xfedc00ca,0xfbd6fd2f,0xf96afaa9,0xf67ff809,0xf276f4a8,0xede4f027,
0xe978ebbc,0xe47ee708,0xdfb2e1ff,0xdc16ddb2,0xd9fedade,0xd947d969,0xda7cd9ae,0xdc8bdb84,
0xdea5dd8a,0xe1a7e007,0xe4efe35d,0xe749e63f,0xe816e7f3,0xe74ce7c1,0xe6b8e6f4,0xe685e689,
0xe762e6d3,0xe8a4e7ff,0xea14e95a,0xeb72eac2,0xecfaec2b,0xef19edf0,0xf1c9f066,0xf4abf337,
0xf7eff638,0xfc04f9e1,0x0051fe34,0x0486025e,0x095b06db,0x0f520c2a,0x165212c1,0x1da819f3,
0x251e2168,0x2bde28a7,0x315f2eb8,0x367a33f2,0x3c54393c,0x43363fb4,0x49a04696,0x4f0d4c6e,
0x52c85145,0x530f5366,0x501851ea,0x49f84d78,0x419445ff,0x380e3ce3,0x2da432f0,0x2345285e,
0x19811e55,0x105d14ce,0x08a30c54,0x020a0543,0xfc5cff06,0xf81dfa13,0xf4f4f66d,0xf22ef39e,
0xede9f052,0xe73ceade,0xdee9e33a,0xd61cda84,0xcdc8d1d2,0xc6deca2a,0xc14dc3e1,0xbd40bf1a,
0xba63bba9,0xb8ffb978,0xba2cb92d,0xbeb1bc12,0xc4ffc1bf,0xcbb3c850,0xd2d7cf2a,0xda99d6a9,
0xe279de87,0xead1e69a,0xf374ef1b,0xfc7af7db,0x06bc0169,0x12150c5c,0x1cf117b9,0x252f2180,
0x29dd27f6,0x2b662af6,0x2a982b40,0x287e29ac,0x25842710,0x226123ed,0x1ea520a7,0x1ade1ca7,
0x18451974,0x15ab1712,0x11e013ea,0x0d4d0fa2,0x08be0afe,0x0423067a,0xffd701de,0xfcb8fe23,
0xfa04fb62,0xf6c4f885,0xf252f4ac,0xed5cefd6,0xe7fdeac6,0xe23fe51b,0xdd5cdfa3,0xda04db79,
0xd7ebd8d4,0xd741d758,0xd859d7a6,0xd9f5d929,0xdbd1dac6,0xdee1dd3d,0xe218e08b,0xe4bbe38b,
0xe5b2e575,0xe599e5a2,0xe5dfe5ae,0xe6b5e628,0xe870e790,0xe9ffe940,0xeb78eac6,0xeca7ec0d,
0xedfbed42,0xeffceee8,0xf255f120,0xf4ebf396,0xf818f669,0xfc24fa07,0x0052fe4a,0x04bd026b,
0x0a090745,0x10c70d34,0x187a1495,0x204f1c64,0x27d9242d,0x2e432b3b,0x33ae3116,0x38f2363b,
0x3eef3bd8,0x45794235,0x4baf4896,0x50d84e8a,0x53635283,0x52575348,0x4e3550a8,0x472b4af9,
0x3e5842eb,0x3476398d,0x29742f05,0x1ecd2400,0x152319dc,0x0cbb10b9,0x05e3092d,0xfffa02d7,
0xfb31fd5d,0xf7c7f95d,0xf538f66a,0xf284f407,0xeda3f068,0xe689ea4b,0xde3be27c,0xd5d4d9f5,
0xce59d1ee,0xc819cb09,0xc305c56f,0xbec4c0c9,0xbb7dbd01,0xb9b9ba5a,0xbad1b9d2,0xbf08bc9c,
0xc4f4c1e3,0xcb67c81e,0xd28acee2,0xda22d651,0xe1cdddee,0xe9f4e5d1,0xf29cee2a,0xfc3af746,
0x07300189,0x12d50d0d,0x1cfd1839,0x241d20fa,0x27eb265b,0x298428f6,0x294c29a5,0x27b928a5,
0x255a2693,0x22e7242b,0x1faa2168,0x1c7c1df2,0x1a401b4c,0x179f1908,0x13d315e5,0x0f40119c,
0x0a930ce2,0x0617084e,0x022503f6,0xff36009b,0xfc32fdc9,0xf85bfa66,0xf38df60f,0xee33f0ed,
0xe82feb47,0xe206e50b,0xdccadf3f,0xd8e7daaf,0xd641d76f,0xd52cd575,0xd5f3d567,0xd756d6a0,
0xd956d82f,0xdc8bdad7,0xdfc7de34,0xe24de130,0xe33ee2fa,0xe3a3e361,0xe4a4e410,0xe63de551,
0xe875e75a,0xea72e97d,0xebf9eb49,0xed41eca5,0xeea8ede6,0xf079ef8b,0xf280f175,0xf4fbf3a8,
0xf844f681,0xfc79fa4b,0x00d8fea9,0x05bd032c,0x0ba80888,0x13210f3d,0x1b141722,0x22cd1ef2,
0x2a0b2687,0x30332d46,0x358332e2,0x3b3a3848,0x418a3e5c,0x4777448a,0x4d4f4a74,0x51634fae,
0x524c5247,0x4fe35175,0x4a9e4d9c,0x43534723,0x3aa03f24,0x30b835d8,0x25e02b54,0x1b85208e,
0x125816c7,0x0ac10e5f,0x04570775,0xfec70172,0xfa73fc6b,0xf780f8d9,0xf511f643,0xf1d0f3a7,
0xec86ef75,0xe583e92a,0xddbce1a7,0xd645d9ee,0xcfd1d2e8,0xca50ccee,0xc57fc7d9,0xc107c333,
0xbd3cbf04,0xbb21bbe6,0xbc05bb25,0xbfd4bda8,0xc505c24c,0xcb22c7f7,0xd204ce80,0xd966d5ae,
0xe0fedd2d,0xe911e4ec,0xf22aed82,0xfca0f72a,0x085c0266,0x13b60e3d,0x1ccf1898,0x22d3203f,
0x265f24c5,0x2855279e,0x289b28a6,0x27a62841,0x263026e8,0x24772572,0x21742319,0x1e921fdf,
0x1c3e1d6e,0x19811af3,0x157d17ad,0x107c130e,0x0b8a0df0,0x06dd092e,0x033f04da,0x007e01dd,
0xfd49fefb,0xf94afb6c,0xf45ef6e6,0xeefff1c0,0xe8e0ec0a,0xe2a7e5b2,0xdd17dfbd,0xd8e7dad6,
0xd5cfd737,0xd488d4d9,0xd4fdd4ab,0xd5c3d559,0xd784d670,0xda7ed8f3,0xdd9cdc13,0xdfcbdeec,
0xe04ee029,0xe107e08d,0xe246e19f,0xe44fe325,0xe6c1e58e,0xe941e7fe,0xeb56ea65,0xece6ec26,
0xee7aeda8,0xf02eef50,0xf21ef119,0xf4c2f354,0xf891f680,0xfd5bfae6,0x0272ffe1,0x08360538,
0x0f020b6e,0x16c812e8,0x1e271a87,0x257b21cf,0x2c622915,0x320e2f5a,0x378534b7,0x3da93a83,
0x438140b8,0x4919463f,0x4e434be1,0x5155502d,0x5107519d,0x4da74fa7,0x47e84b0f,0x40824455,
0x37cc3c5d,0x2d8e32dc,0x229d280a,0x18611d61,0x0f7e13bb,0x08480bb0,0x02230516,0xfd19ff7d,
0xf9aefb2b,0xf75bf87b,0xf50ff64a,0xf175f389,0xebd5eedc,0xe4e3e872,0xddb3e146,0xd706da3b,
0xd146d40a,0xcc32cea7,0xc79ac9e1,0xc305c54f,0xbf12c0e4,0xbcddbdaf,0xbd60bcb8,0xc095bebc,
0xc539c2c3,0xcb2ec807,0xd21ace95,0xd93cd5aa,0xe092dce0,0xe89ee468,0xf228ed35,0xfd37f77c,
0x0919032f,0x13990ea8,0x1b5817d6,0x20261e15,0x232e21c9,0x250d2450,0x25a42574,0x25a325ba,
0x25512574,0x24a82527,0x228223b5,0x20832169,0x1e9e1f9c,0x1c1b1d7f,0x18221a55,0x130c159c,
0x0e111088,0x09750baa,0x05ed078e,0x02cb0465,0xff340114,0xfac2fd23,0xf581f82d,0xeff1f2c9,
0xe991ecdd,0xe307e641,0xdd0fdfeb,0xd860da94,0xd4ced670,0xd30fd3a9,0xd2e9d2de,0xd354d310,
0xd4c0d3d8,0xd775d5fd,0xda55d8f5,0xdc64db87,0xdd7add01,0xdecbde0e,0xe082df9c,0xe2f0e19c,
0xe5d9e45e,0xe8d6e75d,0xeb57ea2e,0xed40ec5a,0xeec7ee0b,0xf05aef8b,0xf22ff137,0xf4f4f366,
0xf91af6dd,0xfe2ffb94,0x039900d3,0x0a1206b1,0x11810db8,0x19101557,0x20461cad,0x279423f1,
0x2e382b02,0x34463145,0x3aba376a,0x41013dfe,0x466743bd,0x4c144934,0x50934ea6,0x51b651a1,
0x4f6850f3,0x4a914d2d,0x446847a5,0x3d0940e9,0x343138ca,0x29c42f29,0x1ebf2437,0x14ea1998,
0x0cbc10a4,0x05c90924,0xffc502a7,0xfb14fd2e,0xf816f971,0xf595f6d7,0xf29cf436,0xee81f0bf,
0xe906ebee,0xe2f2e5fa,0xdd26dffc,0xd7fbda75,0xd378d5aa,0xcf1ed154,0xca77ccd8,0xc57dc7f6,
0xc18dc35a,0xbf8ac040,0xc024bf8f,0xc294c12e,0xc69dc460,0xcc3cc947,0xd2cdcf6c,0xd9a7d63e,
0xe0c4dd1e,0xe901e4b9,0xf325edd1,0xfeccf8d9,0x0a1b04b3,0x12f00ed9,0x193b1664,0x1d7f1b8c,
0x20841f34,0x223d2184,0x231122bb,0x23722348,0x241523b2,0x24322455,0x232223b5,0x21fe2290,
0x20b0215f,0x1e4d1fba,0x19e21c51,0x14571721,0x0f5811c4,0x0b0e0d14,0x0781093d,0x040505ca,
0x00070219,0xfb3dfdbf,0xf617f8aa,0xf09bf37a,0xea24ed71,0xe37de6d0,0xdd7fe05e,0xd872dae3,
0xd43bd62b,0xd204d2d4,0xd141d18b,0xd13ad11b,0xd2a0d1b2,0xd534d3d6,0xd7ead691,0xd9e2d912,
0xdb34da84,0xdd07dc12,0xdf34de0a,0xe22be099,0xe5cde3e8,0xe9bee7cf,0xece7eb73,0xef0aee18,
0xf056efc4,0xf14cf0d0,0xf2cef1ea,0xf59ef40d,0xf9d8f78e,0xff2cfc65,0x057c022b,0x0c9108fb,
0x13dd1031,0x1aad1766,0x20fa1dcf,0x27672445,0x2d672a6a,0x33583051,0x39c1368b,0x3fd53ce3,
0x458542a5,0x4bbf48a2,0x503d4e65,0x514a5133,0x4f005084,0x4a2c4ce1,0x43c5471a,0x3bf0400d,
0x32a2377e,0x280a2d72,0x1d61229e,0x14131885,0x0c430ffb,0x058708cf,0xff98026f,0xfb28fd27,
0xf817f98d,0xf518f69f,0xf1b5f37f,0xed3cefa3,0xe7c9ea93,0xe20de4e7,0xdc9adf47,0xd7fdda2d,
0xd404d5f2,0xd04bd22d,0xcc07ce43,0xc76ec9ab,0xc3bec56c,0xc1fbc295,0xc258c1ee,0xc472c335,
0xc832c61a,0xcd40ca99,0xd31fd024,0xd93fd61f,0xe03bdc9a,0xe8b7e444,0xf307ed9d,0xfed4f8de,
0x09e2049e,0x12720e82,0x185615b1,0x1c611a8c,0x1edf1dc8,0x205e1fba,0x215520dc,0x222e21c1,
0x232522ac,0x235e2362,0x2328233d,0x22d6230a,0x21df227e,0x1f4a20d1,0x1afd1d4f,0x160b1881,
0x112c139c,0x0ced0eee,0x09290b0d,0x05330738,0x00c80314,0xfbc8fe4c,0xf714f95f,0xf1d3f49e,
0xebc3eed5,0xe584e8a1,0xdf99e27d,0xda21dcd0,0xd5c8d7be,0xd308d446,0xd110d1f0,0xd091d08c,
0xd1b1d104,0xd36bd282,0xd524d458,0xd643d5c2,0xd7c7d6e4,0xd9e6d8d2,0xdc84db19,0xdfcade17,
0xe427e1d3,0xe8b1e681,0xec52eaa7,0xeeacedab,0xefdeef64,0xf0bdf044,0xf266f166,0xf5b3f3d3,
0xfabaf80a,0x00d6fda2,0x08040459,0x0f980bc1,0x16fb1362,0x1d1b1a31,0x22d31ff7,0x287c25af,
0x2de42b37,0x339230ae,0x39d436a3,0x3fda3cef,0x462e42d9,0x4d2049c4,0x51b04fd6,0x524a5282,
0x4f56513e,0x49924cab,0x42b54640,0x3ab03edf,0x311b3618,0x26842bda,0x1c1f213b,0x1304175f,
0x0b610f09,0x04cf07fc,0xff0301cc,0xfaacfca2,0xf750f8f2,0xf3e7f5a6,0xefe7f1ff,0xeadded81,
0xe518e80e,0xdf85e23e,0xdaf7dd0b,0xd77ed924,0xd48dd5f7,0xd18fd31d,0xcd8bcfbe,0xc8e0cb2a,
0xc576c6f2,0xc405c47c,0xc448c3fd,0xc5f3c4ec,0xc94cc76b,0xcddecb79,0xd2fad061,0xd8add5b7,
0xdfb5dbf8,0xe87fe3d6,0xf36fedb7,0xff9cf987,0x0a460545,0x12290e8f,0x173d1502,0x1ac9192c,
0x1d111c0c,0x1ea21dea,0x1fea1f4a,0x2161209e,0x22f72238,0x23bb236a,0x24712418,0x24a424a7,
0x23bb2462,0x211d22ac,0x1cb41f17,0x17b71a34,0x12d9153c,0x0eb710b7,0x0ab00cc4,0x062b0877,
0x011a03b8,0xfc04fe7b,0xf79cf9cb,0xf29cf53a,0xecebefd5,0xe6dfe9e4,0xe0e9e3de,0xdb19ddf6,
0xd634d873,0xd2bbd45c,0xd012d148,0xcf2fcf59,0xcfefcf73,0xd132d081,0xd2a3d1f0,0xd3f3d343,
0xd5e0d4d0,0xd86ed71e,0xdb79d9e3,0xdeeedd20,0xe366e10f,0xe80be5cd,0xebaeea04,0xee23ed0f,
0xef83eee8,0xf09af00a,0xf282f162,0xf617f415,0xfb4df888,0x01f0fe74,0x097d05a3,0x114e0d5f,
0x185e1506,0x1df01b49,0x23662099,0x29372650,0x2ef52c15,0x34f131e5,0x3ae637ff,0x40783da6,
0x47034396,0x4d574a73,0x509e4f6c,0x502350dc,0x4c3f4e8b,0x46814981,0x400c435e,0x38813c6b,
0x2f7e3431,0x25812a83,0x1bf0209d,0x1361177d,0x0c020f94,0x057108a4,0xfff50282,0xfbddfdcd,
0xf7e3f9f4,0xf353f5af,0xee2af0cf,0xe89deb6b,0xe2fae5c2,0xde25e067,0xda98dc37,0xd7eed936,
0xd554d6b3,0xd20bd3ce,0xcda3cff4,0xc942cb57,0xc6b9c7b2,0xc60ac63d,0xc653c615,0xc7edc6ed,
0xcaf1c94a,0xcefdccdf,0xd389d137,0xd8fdd614,0xe008dc4b,0xe94ce461,0xf484eec0,0xffdbfa50,
0x091504cb,0x0ffb0cd3,0x14ce128e,0x184e16b7,0x1ac319aa,0x1cd01bcc,0x1eb01dc8,0x204c1f83,
0x218020ff,0x226221e3,0x23b22307,0x247e2439,0x23f72469,0x21ad230e,0x1dff1fea,0x19e11bfa,
0x15a717bf,0x11b813ae,0x0d3e0f9b,0x08010aaa,0x02a60554,0xfdd50021,0xf963fba8,0xf461f6f6,
0xeecef1a1,0xe90febf1,0xe31ee619,0xdd5ee030,0xd879dac9,0xd43ad650,0xd0d1d24a,0xcf8bcfef,
0xcf5ecf64,0xcfa9cf78,0xd000cfdf,0xd0c2d03d,0xd2afd198,0xd572d3f7,0xd8f0d724,0xdd25dae4,
0xe23fdfa6,0xe72ae4ce,0xeb05e93e,0xed81ec6b,0xeefbee56,0xf00def80,0xf20ff0d6,0xf5dcf3c1,
0xfb2ef85e,0x01ebfe61,0x09a305b5,0x11830d9e,0x18011505,0x1d271a98,0x22c81feb,0x288e25ae,
0x2e0a2b55,0x340d30f2,0x3a093722,0x40013cec,0x47654387,0x4e2a4b15,0x51f45082,0x51df526a,
0x4e09505a,0x486a4b5c,0x41cc453b,0x39db3e03,0x30883553,0x26702b83,0x1cb5216f,0x14231848,
0x0c9b1049,0x05a70909,0xfff4029e,0xfb22fd7e,0xf64df8bd,0xf116f3c7,0xeb7cee57,0xe5a3e897,
0xdff3e2b0,0xdb83dd83,0xd8c6d9fe,0xd6cbd7b8,0xd4e9d5f0,0xd1fcd39e,0xcdd1d002,0xc9eacba9,
0xc82bc8c0,0xc80ac7f9,0xc8a6c840,0xca3cc949,0xccc1cb68,0xcff7ce4b,0xd3cfd1c5,0xd8e8d62b,
0xdfd7dc1e,0xe931e42f,0xf4c2eec9,0x0038faa7,0x09ae0544,0x107c0d70,0x152a12ff,0x186316f0,
0x1aa31993,0x1cbb1bad,0x1ea41dbb,0x20031f6d,0x20922060,0x21ab20fb,0x23362279,0x242e23d1,
0x23e72439,0x22282335,0x1f2420c9,0x1b141d34,0x170018f8,0x12f6150d,0x0df11091,0x08700b35,
0x030a05a8,0xfe9f00b8,0xfa56fc8f,0xf5b0f80f,0xf0a5f331,0xeb32edfc,0xe56ee853,0xdfffe2aa,
0xdad4dd64,0xd5c4d844,0xd203d3a7,0xd001d0d6,0xcecacf59,0xcdfece5b,0xcd79cda9,0xce44cdb0,
0xd013cf13,0xd304d166,0xd6afd4ce,0xdb3dd8d3,0xe053ddc2,0xe52ae2d0,0xe906e739,0xebe2ea8f,
0xedfbed05,0xefe7eee6,0xf2e2f12b,0xf790f50d,0xfd35fa45,0x040a007a,0x0b9d07c4,0x130d0f7b,
0x18af1618,0x1df71b3e,0x23a220cf,0x28de2656,0x2e2b2b67,0x341b311f,0x3a153716,0x40be3d31,
0x489e44ba,0x4eae4c03,0x51315070,0x4fc850ed,0x4ba74dee,0x46744922,0x40454388,0x38b93cac,
0x2fd2346a,0x265c2b17,0x1d4d21be,0x153e1923,0x0dd91178,0x07230a60,0x015a0428,0xfbc9fe9c,
0xf5c1f8d3,0xef7df2a4,0xe92dec50,0xe2f8e607,0xdda3e020,0xda4cdbaf,0xd887d953,0xd752d7df,
0xd5a7d6a8,0xd282d445,0xce86d085,0xcb97ccca,0xca95caeb,0xca4bca60,0xca85ca51,0xcbe3cb10,
0xce44ccf5,0xd136cfac,0xd4edd2f3,0xd9efd73d,0xe0dedd19,0xea75e553,0xf5c8f011,0x0062fb53,
0x08cc04e7,0x0eb80c0a,0x12e210f8,0x16141491,0x18c61775,0x1b511a18,0x1d401c6c,0x1e0e1dbc,
0x1ed51e5c,0x209b1f9e,0x228321a2,0x2395232a,0x23d123d7,0x22e0237d,0x208c21e8,0x1d401eef,
0x19c61b8e,0x156017c3,0x0fbb12aa,0x09f60cc9,0x04cd0746,0x00290277,0xfb9efddf,0xf701f955,
0xf250f4b1,0xed44efe1,0xe7edea99,0xe297e54a,0xdcc4dfc3,0xd6ecd9b1,0xd2d9d4a0,0xd00cd167,
0xcd7eceb8,0xcb81cc70,0xca9ccad8,0xcb4ccacd,0xcd44cc19,0xd05eceba,0xd463d239,0xd930d6c0,
0xde49dbb3,0xe313e0c7,0xe702e526,0xea3fe8b9,0xeccdeb8e,0xef88ee11,0xf3b6f16a,0xf8b8f62f,
0xfe70fb74,0x04fc019c,0x0c53089c,0x12d80fd2,0x18481591,0x1dd31b08,0x233a2099,0x281b25b1,
0x2d4e2a9d,0x3343303d,0x392c3633,0x403e3c79,0x486a4451,0x4f1b4c24,0x52125115,0x51025207,
0x4d0f4f3a,0x47da4a98,0x417e44d4,0x39ca3dc6,0x31123595,0x275b2c46,0x1e30229e,0x16141a0b,
0x0e85123c,0x07760ae7,0x00f60432,0xfa8cfdbe,0xf416f75d,0xed2af0a7,0xe64de9b4,0xdfc0e2f9,
0xdaa7dce9,0xd80ed917,0xd6d8d753,0xd63bd68a,0xd4e7d5b5,0xd22ed3bc,0xcf04d082,0xcd38cde6,
0xccc7ccdb,0xccecccd3,0xcd57cd14,0xce9bcdd6,0xd0a1cf90,0xd31cd1ce,0xd645d496,0xdac2d84c,
0xe18addc1,0xeb4ce60d,0xf708f11d,0x01dcfcb8,0x0a12065c,0x0f3e0cf9,0x12b7111f,0x155e1421,
0x17941685,0x19331881,0x19a61984,0x1a0a19ca,0x1b441a81,0x1d7b1c54,0x1f711e86,0x21172042,
0x227021de,0x226622ab,0x20c821b8,0x1e671fab,0x1b421cfd,0x16bc192f,0x11341405,0x0bd60e71,
0x06e1094e,0x0266049c,0xfe1c003c,0xf9f2fc02,0xf586f7d1,0xf0a6f31e,0xeb89ee22,0xe584e8ae,
0xdf33e256,0xd9a4dc47,0xd532d74f,0xd0ead30f,0xccf9ced8,0xca25cb5c,0xc917c968,0xc98dc919,
0xcb75ca56,0xce9acce0,0xd2acd090,0xd724d4db,0xdc18d995,0xe0c5de80,0xe4ede2e9,0xe898e6d0,
0xec22ea58,0xf03fee0f,0xf540f2b9,0xfa24f7b3,0xff4dfca7,0x0543022c,0x0b900875,0x118b0e91,
0x175d147d,0x1cdb1a30,0x21f41f6f,0x26c72460,0x2c2a2955,0x32272f24,0x38783538,0x401f3c1a,
0x482e444c,0x4dc84b66,0x4fcc4f44,0x4e5f4f71,0x4b084cd9,0x46b048f7,0x416c442f,0x3ad93e56,
0x328236ea,0x29182dcb,0x20352489,0x18241c18,0x107c1449,0x094c0cd5,0x024b05d1,0xfb36fec6,
0xf3b6f782,0xec1cefda,0xe4e1e875,0xde5be172,0xda0ddbdc,0xd7ebd8cb,0xd704d758,0xd654d6b7,
0xd4d3d5b7,0xd22ad38e,0xcfe7d0e5,0xced9cf39,0xce9fceaa,0xcea2cea1,0xcee9cead,0xd011cf62,
0xd1f9d0f1,0xd47dd329,0xd7b0d5fe,0xdc26d9ae,0xe314df3e,0xecede7ad,0xf800f287,0x019dfd0a,
0x08c8058c,0x0d860b64,0x110c0f63,0x140d1294,0x16c6157a,0x183617b9,0x188c186e,0x191818b8,
0x1a8019a7,0x1c501b73,0x1dd31d0c,0x1f8a1eac,0x20f8205c,0x212a213a,0x206320df,0x1e911fa4,
0x1b561d21,0x16a41927,0x115413f9,0x0c480ec7,0x077409d8,0x03270539,0xff510131,0xfbc7fd8b,
0xf7e5f9e5,0xf3cdf5db,0xef10f195,0xe908ec2b,0xe328e5fe,0xddf6e082,0xd8d3db75,0xd34dd615,
0xce1cd09a,0xca7dcc0d,0xc8bfc967,0xc8cac887,0xca34c957,0xcce1cb66,0xd044ce7e,0xd452d236,
0xd8d8d689,0xdd99db3e,0xe215dfdd,0xe676e445,0xeb2be8b2,0xf080edd2,0xf588f317,0xfa2af7e3,
0xff18fc86,0x04cb01e5,0x0a8307a1,0x106c0d74,0x15c5133f,0x1a5c1813,0x1ed71ca7,0x23612102,
0x29352618,0x30222c97,0x375633b0,0x3fc73b4d,0x48b84472,0x4f074c3c,0x51c550e6,0x50df51c0,
0x4db84f6d,0x49b24bda,0x44af474a,0x3e4c41bf,0x35903a37,0x2ba8309a,0x22c92707,0x1ad51ecf,
0x12eb16d4,0x0b000ef6,0x03050704,0xfaeaff08,0xf238f6a1,0xe972edd2,0xe10ee527,0xda32dd54,
0xd605d7cc,0xd3fcd4ce,0xd331d36c,0xd337d32b,0xd294d305,0xd17ad20b,0xd09ad0ff,0xd033d04d,
0xd07ad044,0xd0dcd0af,0xd15cd10f,0xd270d1d3,0xd419d32f,0xd66dd529,0xd954d7c8,0xdd8cdb35,
0xe46ae08d,0xee96e926,0xf9d0f44d,0x033bfede,0x099d06d4,0x0d930bbb,0x10fc0f50,0x140f128e,
0x16251552,0x166f1672,0x1675166a,0x171b16ae,0x188717c2,0x1a0f1947,0x1c051af0,0x1e8a1d47,
0x20471f93,0x20dc20b7,0x201220aa,0x1de11f1a,0x1acc1c71,0x170518fd,0x129d14e0,0x0dcc1042,
0x09230b62,0x055f0729,0x022d03b4,0xfef2009c,0xfb5cfd2f,0xf750f976,0xf1f1f4cf,0xebcfeed3,
0xe649e901,0xe0b7e38c,0xda6addb4,0xd395d6f9,0xcdadd06b,0xc97dcb5e,0xc72ac810,0xc6b7c6bd,
0xc7b9c708,0xc9cdc8ab,0xccd0cb2f,0xd084ce94,0xd4f2d2a2,0xd9f6d76b,0xdf37dc95,0xe4d1e1f1,
0xeac4e7cb,0xf069eda9,0xf556f2f9,0xf9b6f780,0xfeb1fc22,0x03dc013c,0x09b406b3,0x0f9c0cc1,
0x1473121f,0x18f616b7,0x1d911b36,0x22fb2021,0x29a7261f,0x31112d65,0x38ba34c8,0x41b83d1b,
0x4a23462b,0x4fef4d74,0x5223517e,0x50e851df,0x4dfe4f91,0x4a744c4a,0x462a487a,0x3fe9435e,
0x371d3bce,0x2d6f3230,0x24c328f5,0x1cb420bb,0x148d18a6,0x0c28105e,0x038207e3,0xfa43fef7,
0xf07cf56b,0xe6edeb9d,0xde68e276,0xd80edaea,0xd425d5d1,0xd21cd2f0,0xd185d1ae,0xd176d182,
0xd124d156,0xd0b1d0e6,0xd063d081,0xd07ad057,0xd119d0c6,0xd1a6d16c,0xd248d1df,0xd392d2d0,
0xd587d477,0xd81bd6c4,0xdb52d99e,0xdffcdd67,0xe778e34c,0xf187ec4e,0xfba0f6bc,0x0388fff0,
0x08d80674,0x0c970ac8,0x101d0e64,0x12e711ae,0x140413af,0x14151409,0x147b1438,0x157214e7,
0x16b01609,0x18601770,0x1aaf1977,0x1cd81bdc,0x1e3c1d9f,0x1ea91e99,0x1dae1e5e,0x1bdb1cd4,
0x19971ac0,0x16ef185a,0x13541547,0x0ee51120,0x0ae90cca,0x07d4094e,0x0525067f,0x022e03b3,
0xfede009d,0xfa5dfcc7,0xf509f7c0,0xefc9f259,0xea80ed3b,0xe43be782,0xdce0e0a6,0xd5b8d933,
0xcf96d287,0xcaf8cd0b,0xc84cc968,0xc743c796,0xc775c743,0xc86cc7d0,0xca78c955,0xcd61cbd2,
0xd165cf39,0xd699d3e0,0xdcbbd989,0xe378e017,0xe997e6a8,0xeecdec4a,0xf32bf10d,0xf796f556,
0xfc8af9f3,0x0253ff54,0x08730570,0x0da50b2c,0x11e80fdc,0x162313f2,0x1b391891,0x218a1e2f,
0x293c253f,0x31402d48,0x39963548,0x42b73e1a,0x4b1d4728,0x50bd4e58,0x52e25248,0x51ed52aa,
0x4fe250f2,0x4d464ea3,0x49724b9c,0x432146ae,0x3a193edb,0x30563530,0x27572bbb,0x1e9722fb,
0x15921a1a,0x0c5e1100,0x02c0079f,0xf89bfdc0,0xee27f365,0xe43be907,0xdbfedfdd,0xd5bfd897,
0xd18fd35f,0xcf94d050,0xcf37cf3d,0xcf86cf5a,0xcffacfc2,0xd035d020,0xd066d044,0xd118d0a8,
0xd212d19e,0xd2bad273,0xd384d30a,0xd51bd435,0xd764d62c,0xda5bd8c5,0xde18dc13,0xe395e091,
0xeb9ae741,0xf55bf061,0xfe5efa24,0x04f901f7,0x0976076c,0x0d010b4a,0x0ff60e96,0x117f10ef,
0x11e511bf,0x12571214,0x12ef12a0,0x1389133f,0x148613ed,0x16651556,0x18bc1797,0x1a6419ab,
0x1b331aed,0x1aa21b1f,0x190d19e3,0x17a9184b,0x16ed173b,0x15b11676,0x1319148b,0x10101187,
0x0db10ec8,0x0bdc0cc3,0x09e10ae4,0x077c08d0,0x037805b9,0xfe2b00df,0xf8dcfb7b,0xf37ef632,
0xed66f09b,0xe5e1e9c9,0xde2ee1ea,0xd74adaa8,0xd13ad41f,0xcc8dceb2,0xc959cac1,0xc79ac857,
0xc680c6f9,0xc681c653,0xc7cdc6fb,0xca67c8e7,0xcebccc58,0xd4ebd19c,0xdc56d88f,0xe369dffe,
0xe977e690,0xee44ec03,0xf257f05e,0xf688f45d,0xfb86f8e8,0x011efe57,0x062403b7,0x0a870867,
0x0e490c6b,0x12d01060,0x18d4159e,0x20541c64,0x28ec248e,0x31ae2d54,0x3a863602,0x44323f57,
0x4cba48bf,0x52534ff7,0x541153b2,0x52e353b0,0x512b5205,0x4f04503b,0x4b474d6a,0x44bc4867,
0x3b924068,0x318a3680,0x284d2cd3,0x1f1423b6,0x15ab1a68,0x0bd710d1,0x01af06cd,0xf718fc73,
0xec35f19e,0xe221e6fb,0xd9d5ddc9,0xd344d651,0xcf16d0d4,0xcd48cdeb,0xcd10cd05,0xcdb6cd4f,
0xce9bce30,0xcf3fcef6,0xd017cf93,0xd1cdd0df,0xd38ad2bd,0xd4b6d430,0xd5efd543,0xd79dd6b6,
0xd9e5d8ab,0xdcc8db41,0xe0c7de93,0xe698e36e,0xee82ea4d,0xf796f308,0xff5cfbc1,0x050b026c,
0x093d0747,0x0cce0b16,0x0f620e42,0x108b101c,0x111410d2,0x11961152,0x122111dd,0x12971255,
0x139e1304,0x154a1464,0x17181639,0x184f17cf,0x18561878,0x174017e5,0x15d01684,0x1532155c,
0x1549153f,0x1477150d,0x12b0139d,0x10de11bc,0x0f98102c,0x0e540efc,0x0cc10d99,0x0a480bb8,
0x0609085c,0x00fe0380,0xfc1dfe8d,0xf6fcf9a2,0xf082f3f1,0xe8dbecc2,0xe146e500,0xda4addb3,
0xd40ad70a,0xcee5d159,0xcad3ccba,0xc796c920,0xc55bc64f,0xc499c4ca,0xc564c4cd,0xc7f7c673,
0xcc9fc9ff,0xd34ccfcb,0xda8cd6ec,0xe133de00,0xe686e404,0xeaeee8cd,0xeefaecf0,0xf388f126,
0xf910f631,0xfeb8fbf1,0x03ac014f,0x07c805d5,0x0b660994,0x101b0d8a,0x16651319,0x1df41a02,
0x26ae2236,0x2f952b28,0x38d8340e,0x43583e07,0x4d064873,0x53ea50e5,0x56fb55f3,0x56fc572f,
0x563356a9,0x54625578,0x508b52c6,0x49ce4d99,0x40024531,0x355b3a9a,0x2b463044,0x2145264c,
0x16d21c1a,0x0be31160,0x00f80664,0xf61dfb95,0xeb3ff09d,0xe145e61d,0xd808dc94,0xd035d3d5,
0xcb2acd47,0xc8d2c9b5,0xc8b1c87d,0xca2cc95a,0xcbcacb00,0xcd16cc6f,0xce92cdc4,0xd0c3cf98,
0xd2f5d1f1,0xd49fd3d1,0xd65dd577,0xd886d759,0xdb5dd9d5,0xdf09dd18,0xe3b2e135,0xe9b6e680,
0xf18ded6f,0xfa39f5e3,0x01d5fe3d,0x07c304f9,0x0c1d0a25,0x0f060dbf,0x102f0fd0,0x109e1065,
0x113710eb,0x11a71175,0x11a811b2,0x11db11aa,0x12d61247,0x14051370,0x1535149f,0x15c915a7,
0x14eb1583,0x1306140d,0x11401203,0x10e910ec,0x111f110c,0x10b210f4,0x10341070,0x1014100f,
0x10661037,0x10a1108b,0x101f108f,0x0daf0f2b,0x09b80bc9,0x059207ac,0x00e8035f,0xfb34fe30,
0xf434f7e2,0xec9df062,0xe54fe8ec,0xde72e1cc,0xd83edb42,0xd2e6d578,0xce24d079,0xc9d2cbdf,
0xc695c810,0xc4aec571,0xc45fc446,0xc67ec519,0xcb3ec88d,0xd1bfce66,0xd823d501,0xdda5db01,
0xe27ae025,0xe6b3e498,0xead1e8c7,0xef72ed04,0xf4abf209,0xf992f72f,0xfe40fbe8,0x029e007c,
0x072104c3,0x0ce109cc,0x141d1057,0x1ca41833,0x26422167,0x2ff42b21,0x3ac43516,0x469e40b8,
0x50b94bff,0x57405481,0x59b158ed,0x599d59c5,0x59005966,0x570a583f,0x52ea5548,0x4baa4fb7,
0x41ab46e3,0x37223c5c,0x2ce631fb,0x228227c6,0x17421cf9,0x0bb9117a,0x008d061c,0xf545faf6,
0xe9d4ef7e,0xded4e443,0xd4dad9ad,0xcd1dd09b,0xc8c4ca89,0xc739c7ab,0xc7f4c75c,0xc9a6c8c8,
0xcb4eca84,0xccd4cc14,0xcecfcdb2,0xd15ad016,0xd384d280,0xd568d476,0xd78cd669,0xd9ffd8bb,
0xdd5cdb87,0xe18fdf61,0xe6b3e3fb,0xed2ee9b6,0xf564f11b,0xfdd6f9c2,0x046c016a,0x091006f4,
0x0c2d0ac9,0x0e080d50,0x0e790e56,0x0ef60ea5,0x0f900f4e,0x10080fd7,0x1038101f,0x10ca1065,
0x11c5114e,0x12921229,0x1376130c,0x134c1395,0x11a8129f,0x0f791088,0x0e0d0e8d,0x0e110df6,
0x0e650e3c,0x0e970e80,0x0ef20eaf,0x10470f8a,0x11f7111b,0x136712be,0x137313be,0x11151281,
0x0da20f64,0x099d0bc0,0x04660724,0xfe3e016d,0xf706faba,0xefbaf359,0xe8b7ec34,0xe22be55c,
0xdc1fdf18,0xd649d92f,0xd07bd361,0xcb06cdac,0xc689c896,0xc3bac4e4,0xc358c333,0xc5bbc430,
0xca64c7dc,0xd008cd2f,0xd53dd2b7,0xd9f3d7ab,0xde4bdc12,0xe2d4e098,0xe73ce508,0xebe8e981,
0xf0efee65,0xf5f8f377,0xfae0f86f,0xffc8fd50,0x05020251,0x0b5a0808,0x12d40efd,0x1b7f16fe,
0x2523203f,0x2f222a16,0x3a393473,0x46614055,0x50ff4c09,0x5855551c,0x5c045a96,0x5d255cc2,
0x5cfa5d3d,0x5af25c42,0x563358f5,0x4e5152a9,0x43f34956,0x38dd3e63,0x2e1c3378,0x230828aa,
0x175f1d40,0x0bc41189,0x0099062b,0xf558fb06,0xe98cef78,0xddf3e3a9,0xd391d881,0xcb96cf3b,
0xc694c8b3,0xc47fc538,0xc4c9c45f,0xc66fc584,0xc892c777,0xcadbc9b5,0xcd5bcc0f,0xd01cceba,
0xd2c8d178,0xd58dd423,0xd852d6e7,0xdb7ed9d3,0xdf71dd56,0xe44de1c4,0xe9dbe702,0xf058ecf4,
0xf7e8f40d,0xff7ffbcc,0x05b702db,0x0a640838,0x0d5e0c18,0x0e8b0e2e,0x0eb60ea2,0x0f440eef,
0x0ffc0fa8,0x10261024,0x1045102f,0x10bd1071,0x11351103,0x11821155,0x11db11b8,0x115111bb,
0x0fa61097,0x0dc00ea6,0x0c980d0e,0x0c390c59,0x0c060c1e,0x0bf10bf0,0x0cc90c33,0x0eab0da4,
0x11460fe6,0x13c612a6,0x144d1460,0x12b313a7,0x102c118d,0x0c6b0e7d,0x070909e9,0x005303d9,
0xf90afcac,0xf201f579,0xeb4bee90,0xe535e838,0xdf2ee231,0xd928dc32,0xd2d9d60c,0xccaacfaf,
0xc773c9e3,0xc429c57a,0xc376c37e,0xc53cc40c,0xc906c6ee,0xcd56cb31,0xd183cf77,0xd571d370,
0xd9f5d7a3,0xde92dc5a,0xe2a4e09c,0xe6e7e4bc,0xebabe934,0xf0fbee40,0xf704f3e1,0xfdaefa54,
0x04b80119,0x0c4c0875,0x14701046,0x1db518f0,0x27b722a7,0x32652ce6,0x3e9f384d,0x4afc4503,
0x54b0503b,0x5b055846,0x5de85cd6,0x5ed15e86,0x5e435ec2,0x5ba05d39,0x56525959,0x4ddc526b,
0x435648bf,0x385d3dd9,0x2d7532f4,0x220827d0,0x16491c22,0x0ab71077,0xff540506,0xf35bf97b,
0xe6e0ed1d,0xdaeae0c2,0xd08bd57b,0xc8d3cc4c,0xc42fc625,0xc264c2ef,0xc2fbc272,0xc4cfc3d0,
0xc710c5e4,0xc999c84f,0xcc8dcaff,0xcfddce34,0xd31ed184,0xd67fd4c4,0xd9fdd840,0xddd4dbcc,
0xe2a8e01d,0xe82fe561,0xee54eb28,0xf54bf1ab,0xfcf5f914,0x040b00b4,0x095e06f0,0x0ce90b63,
0x0e6b0de9,0x0e5e0e85,0x0e530e3e,0x0ef20e99,0x0f880f47,0x0fa70f9d,0x0ff80fca,0x10421027,
0x0fd91026,0x0f730f9d,0x0ef50f47,0x0da20e67,0x0bc20cb8,0x0a320ae4,0x096609b8,0x08df0920,
0x086c089f,0x08790854,0x09c408f0,0x0c500ae8,0x0fda0dff,0x131c11a2,0x1476140d,0x14591486,
0x130913de,0x0fba11a6,0x0a920d56,0x041a0774,0xfd4600ab,0xf696f9e4,0xf070f373,0xea3fed66,
0xe3e2e711,0xdd4fe0a2,0xd685d9eb,0xcff0d32b,0xca5fccf5,0xc6cfc84d,0xc577c5db,0xc650c5a0,
0xc893c754,0xcb3ac9e6,0xcdf1cc8b,0xd136cf7a,0xd566d340,0xd93ed767,0xdd35db27,0xe1c7df62,
0xe6f5e451,0xecd6e9c6,0xf3b3f02b,0xfb28f765,0x02e7ff04,0x0aac06c2,0x12ee0ea9,0x1c57177e,
0x26a12162,0x31bd2c0b,0x3e8137e5,0x4bb84545,0x565a5170,0x5d985a73,0x61035fba,0x61f661b4,
0x613a61d1,0x5e586016,0x588f5bdd,0x4f825470,0x444a4a0c,0x38dc3e86,0x2d97333f,0x21e927c8,
0x16191c00,0x0a96104b,0xff3104f3,0xf2dbf938,0xe5a8ec3f,0xd940df4b,0xce84d39f,0xc679ca1e,
0xc1d6c3bb,0xc06ec0bc,0xc1b0c0d4,0xc409c2ca,0xc671c547,0xc89ec780,0xcb5cc9e6,0xceebcd0e,
0xd2ced0d8,0xd6d4d4cc,0xdb0bd8e9,0xdfdcdd58,0xe591e2a6,0xeb79e886,0xf18aee76,0xf82ff4c1,
0xffddfbf0,0x072903ad,0x0c9c0a2b,0x0f5b0e58,0x0f870fa9,0x0f200f46,0x0f7f0f36,0x10240fde,
0x100b1026,0x0ff90ff8,0x10391014,0x10131042,0x0f490fb7,0x0e5e0edc,0x0d0a0dc2,0x0b170c25,
0x08c809ec,0x072d07d3,0x064406a9,0x05ae05ef,0x05700587,0x05e30585,0x079d069a,0x0ab708fa,
0x0ee20cc0,0x125b10ce,0x147d138a,0x15b3153b,0x151f15b9,0x11ed13da,0x0caa0f78,0x067e09a0,
0x00050342,0xf9b8fccc,0xf3b5f6be,0xed80f097,0xe712ea5f,0xe02ce3a8,0xd944dcb2,0xd2d1d5f1,
0xcd8ed007,0xc9b9cb70,0xc79cc86f,0xc722c72f,0xc7bdc75c,0xc8a2c825,0xca59c963,0xcd2bcba6,
0xd051ceb7,0xd398d1f2,0xd753d560,0xdbfbd981,0xe1dfded2,0xe8e4e539,0xf12aecde,0xfa0cf59c,
0x02abfe63,0x0b4306e6,0x14790fcc,0x1e5f1952,0x294423b7,0x34d42ee5,0x41b63b1d,0x4e3f4836,
0x5849539f,0x5f185c22,0x62286115,0x62996295,0x61896249,0x5e336037,0x57fc5b83,0x4e8e53a6,
0x432e48f3,0x37e63d7a,0x2cd93263,0x21a72742,0x165a1bfb,0x0aee10ab,0xff1b051a,0xf1fff8ba,
0xe461eb1f,0xd7b6dde3,0xccb3d1ee,0xc478c828,0xbfeac1bd,0xbec2befa,0xc005bf20,0xc243c11d,
0xc472c35c,0xc6bac58a,0xca06c834,0xce7dcc23,0xd32fd0d5,0xd7ccd57f,0xdcd7da40,0xe2b3dfab,
0xe95de5f9,0xefebecad,0xf661f31f,0xfd4cf9c0,0x04eb0111,0x0ba50884,0x0fe90e26,0x110e10e6,
0x103810b1,0x0fcc0fea,0x10190fe0,0x10451049,0x0fde1018,0x0fb00fb7,0x0fa30fb7,0x0ed70f51,
0x0dab0e47,0x0c290cf9,0x0a4e0b42,0x080a0939,0x05b506d3,0x042804d8,0x033b03a2,0x02c302f0,
0x02d402b9,0x03970318,0x0554044b,0x08a606cd,0x0cb60ab6,0x10310e88,0x134711bc,0x15a414a4,
0x15c0160e,0x131714c1,0x0e7610e7,0x09210bdf,0x03760650,0xfdd200a2,0xf7f6faf0,0xf1d6f4f4,
0xeaf7ee76,0xe3cce765,0xdcf4e048,0xd6fbd9dd,0xd172d433,0xcc98cede,0xc91bcaab,0xc726c7fb,
0xc609c670,0xc635c5fc,0xc78cc6c1,0xc9a8c88a,0xcbffcaca,0xced1cd5a,0xd249d06b,0xd708d474,
0xdd4ed9fa,0xe51de101,0xee72e9a8,0xf81bf34d,0x0160fcc2,0x0acb0612,0x14880f96,0x1f1419ab,
0x2a4d24ac,0x35e63000,0x42833c18,0x4edd48e1,0x58e9543c,0x5f965cbc,0x622c615a,0x62756276,
0x618e6234,0x5e82605f,0x58715be4,0x4f225422,0x442149b4,0x39023e91,0x2ded337c,0x228b284a,
0x16b61ca9,0x0aff10d8,0xfeac04f8,0xf0fff7ff,0xe2e4e9de,0xd60bdc42,0xcb11d045,0xc33ec6a2,
0xbf6fc0e8,0xbed1beca,0xc04abf65,0xc244c142,0xc40bc329,0xc639c509,0xc9c4c7ca,0xce83cc0f,
0xd368d0fd,0xd877d5e1,0xde20db35,0xe4bee14d,0xebeae854,0xf2a5ef59,0xf8f8f5d6,0xfffdfc58,
0x07af03d7,0x0e280b37,0x114c1034,0x1130118f,0x103a10a5,0x10051004,0x10431029,0x101b1044,
0x0fb80fe5,0x0fa80fa4,0x0f540f99,0x0e700eec,0x0cdf0dc8,0x0a970bc8,0x081d095c,0x059806d9,
0x03340459,0x01640238,0x006c00c6,0x0077004f,0x012200c0,0x022e0195,0x0438030a,0x074305ac,
0x0a8d08e3,0x0e1d0c45,0x120a1015,0x151c13ca,0x15de15d2,0x1404153f,0x1097126b,0x0c330e83,
0x073009be,0x01d5048a,0xfc29ff09,0xf5d6f919,0xeef9f274,0xe824eb86,0xe1a7e4d7,0xdb65de84,
0xd530d846,0xcf63d232,0xcabdccec,0xc6f0c8be,0xc444c575,0xc2f0c36d,0xc2ebc2c3,0xc403c365,
0xc60cc4e0,0xc912c77d,0xccd2cacc,0xd23fcf53,0xd978d59a,0xe28eddca,0xecdce799,0xf74ff224,
0x01a1fc72,0x0c5406ec,0x177b11d2,0x23231d4b,0x2eb328f4,0x3a733479,0x46914091,0x518b4c40,
0x5a165639,0x5efe5d14,0x6086600b,0x608260a9,0x5f3c6016,0x5b915dbc,0x54f758a8,0x4bea50a9,
0x41dd46f3,0x377b3cba,0x2cec3239,0x21c82767,0x16741c1e,0x0ae710c2,0xfe0a04b5,0xef85f6f3,
0xe0fae817,0xd3efda33,0xc95ece3f,0xc2c4c58e,0xbfdcc0f2,0xbfbdbf7a,0xc0ffc04b,0xc273c1c0,
0xc3eec324,0xc63dc4e8,0xca3ac80f,0xcf2dcc9f,0xd47bd1c9,0xda6cd75a,0xe16cddc9,0xe922e532,
0xf0f3ed19,0xf80ef4a0,0xfedbfb63,0x06160275,0x0cce099d,0x10e60f4e,0x11461183,0x0fd8108b,
0x0f060f52,0x0f220efc,0x0f210f3e,0x0ea80edf,0x0e9b0e91,0x0ea00eb4,0x0e090e62,0x0d000da0,
0x0ae80c11,0x081b098d,0x053b06aa,0x027d03d3,0x00290147,0xfe76ff32,0xfdfefe14,0xfea4fe2f,
0xffd5ff34,0x018d0092,0x040302c3,0x0664053d,0x0908079c,0x0cbb0ac5,0x10c00ec6,0x13991269,
0x14441434,0x134413e5,0x114d1271,0x0e200fda,0x0a3d0c40,0x05a80806,0x002c0316,0xf9a4fcfa,
0xf2e7f63d,0xec66efa7,0xe5f8e92a,0xdf6ae2c0,0xd899dc00,0xd243d559,0xcc64cf46,0xc74cc9b1,
0xc37cc545,0xc0f2c202,0xbfc8c03d,0xbfffbfaa,0xc19ec0af,0xc41bc2b8,0xc80fc5dd,0xcde3cab3,
0xd621d1b9,0xe056db0a,0xebbfe5f4,0xf748f181,0x0323fd22,0x0f680939,0x1c3a15c4,0x28bf2290,
0x34af2ec6,0x40873aa4,0x4b2b461b,0x53e14fd3,0x59ec5753,0x5c755b8f,0x5d075cd7,0x5d005d1e,
0x5b935c83,0x57d95a16,0x515654db,0x494c4d78,0x3fec44c4,0x35a93ad8,0x2af5305b,0x201e2588,
0x15471abb,0x09580f85,0xfb5c029a,0xec2cf3cc,0xdd84e4ae,0xd0e4d6e0,0xc7a9cbc9,0xc265c48f,
0xc064c10b,0xc083c041,0xc152c0e5,0xc22fc1bb,0xc396c2be,0xc697c4dc,0xcb19c8b9,0xd04ccda5,
0xd61bd31b,0xdcd4d958,0xe494e097,0xecdbe8b4,0xf4d8f0f3,0xfc62f89d,0x044f004d,0x0c050846,
0x119b0f35,0x139e1316,0x1278134f,0x10be1181,0x10371053,0x10471046,0x0fca1020,0x0ec40f47,
0x0e0d0e58,0x0d780dcf,0x0c690d02,0x0a9b0b98,0x08400981,0x057d06e1,0x029b0410,0xffe60133,
0xfd9afeb2,0xfc3ffcc6,0xfc0dfc00,0xfcc6fc54,0xfe13fd57,0x0021feff,0x02a0015c,0x04db03c9,
0x076605fe,0x0b100922,0x0ef80d16,0x11bc108a,0x12cb1277,0x12c112d7,0x11e31281,0x0fd710f0,
0x0d300e9c,0x09460b6b,0x03e306c7,0xfd6d00b8,0xf6f5fa30,0xf08bf3bd,0xe9f3ed48,0xe294e658,
0xdaeddeb7,0xd392d733,0xcccbd01d,0xc6f3c9be,0xc20dc459,0xbecfc033,0xbd45bdd5,0xbd56bd1a,
0xbec6bdef,0xc168bfee,0xc59cc349,0xcbdfc874,0xd487cfe4,0xdf3dd9a3,0xeb3ee52d,0xf76ef14e,
0x0419fdb8,0x114c0aa0,0x1ec91811,0x2b832542,0x380031bf,0x43943e05,0x4cf14893,0x53e350b7,
0x57df5652,0x591a58bb,0x59685952,0x59275966,0x57a0589b,0x53d15609,0x4de25108,0x46cc4a8a,
0x3e4d42bc,0x34823980,0x2a4a2f67,0x1ff1251e,0x15441ab3,0x08dc0f61,0xfa4e01ca,0xeaeaf2a0,
0xdc3ae361,0xcffed5b2,0xc773cb35,0xc299c497,0xc0c2c160,0xc0a4c099,0xc11fc0dc,0xc1f7c17a,
0xc3dac2b7,0xc771c574,0xcc36c9b8,0xd1b6cede,0xd815d4c5,0xdf8fdbae,0xe7f9e3b1,0xf071ec49,
0xf85df475,0x004ffc3e,0x08b50480,0x10160cab,0x143912a4,0x149914dc,0x12c013bd,0x116111f1,
0x113a112d,0x110f1144,0x0ff71096,0x0ecb0f53,0x0e2a0e75,0x0d3a0dc7,0x0b920c79,0x096a0a8b,
0x06c00821,0x03f00559,0x01160284,0xfe6dffbc,0xfc01fd25,0xfa89fb1d,0xfa36fa3f,0xfabffa63,
0xfc20fb4d,0xfe6afd34,0x0089ff90,0x023a015c,0x04da035d,0x086e0696,0x0bd20a35,0x0e210d2b,
0x0f540ec9,0x104e0fe1,0x107a1081,0x10381069,0x0f150fce,0x0c8c0e09,0x08270a8a,0x02e40593,
0xfcf40007,0xf689f9c7,0xef57f312,0xe748eb6b,0xdebce301,0xd66fda8c,0xce9dd26c,0xc766caf1,
0xc158c42b,0xbd42bf08,0xbb56bc03,0xbb8abb3b,0xbce8bc15,0xbf77be07,0xc37cc145,0xc97bc632,
0xd218cd79,0xdd30d768,0xe983e347,0xf666efe6,0x0392fcef,0x11630a5e,0x1f52186e,0x2cb3261a,
0x39a23333,0x45523fce,0x4e594a30,0x549251ce,0x5786567d,0x581157f2,0x57b057f9,0x56cc574d,
0x54f4560d,0x51295347,0x4bea4eb7,0x454548c3,0x3cc14146,0x32e137e8,0x28ac2dc3,0x1ea023a3,
0x13fa1980,0x07550dec,0xf8d1004b,0xe98bf129,0xdb17e216,0xcf4ed4c1,0xc71ecac3,0xc274c463,
0xc0dcc15c,0xc0f0c0c6,0xc17fc12d,0xc260c1dc,0xc4a1c343,0xc8a4c678,0xcde2cb27,0xd3e6d0c0,
0xdaf6d74a,0xe338def4,0xec0ce7a6,0xf446f045,0xfbfff827,0x0409ffec,0x0c67083f,0x13701044,
0x16b815a0,0x162816ce,0x13ed150d,0x128a1314,0x12021243,0x11071199,0x0f831046,0x0e4c0ed8,
0x0d630ddd,0x0c160cce,0x09fe0b2d,0x072f089f,0x044505c0,0x014602c4,0xfea7ffef,0xfc0cfd5f,
0xf9b7facc,0xf844f8d7,0xf837f816,0xf92df89a,0xfb04f9f7,0xfd5ffc39,0xff31fe5c,0x0123000b,
0x04330289,0x07b905fe,0x0a990945,0x0c8d0bb0,0x0e240d59,0x0f8b0eda,0x10e0103b,0x11b21169,
0x118411c2,0x0fc310dc,0x0c590e3d,0x076f0a15,0x015b0483,0xfa5efdfb,0xf252f67f,0xe900edbc,
0xdfb6e44f,0xd6cedb3e,0xce37d26f,0xc679ca35,0xc05ac32c,0xbc08bdf0,0xba05babc,0xb9e2b9cf,
0xbaa4ba27,0xbc8fbb6f,0xc01ebe14,0xc642c2cf,0xcf89ca8a,0xdb3ad527,0xe85ce1ab,0xf605ef26,
0x03e8fce9,0x126a0b16,0x211119c8,0x2f182829,0x3c8835e2,0x485442c1,0x51284d25,0x56b3545d,
0x58da5830,0x588a58db,0x576f580c,0x55bf56a9,0x531b549a,0x4ef6513c,0x49684c55,0x4297462e,
0x3a623eac,0x30d335ba,0x26e12bd2,0x1cf321ff,0x11d11796,0x04be0b8d,0xf602fd88,0xe6f2ee70,
0xd8f9dfaf,0xcdc9d2fd,0xc5cbc95f,0xc159c327,0xc00ac061,0xc061c017,0xc13dc0cc,0xc2a3c1d3,
0xc5c1c3f6,0xca6cc7ed,0xd011cd23,0xd67ed32e,0xddf1da17,0xe636e201,0xeeadea78,0xf685f2ae,
0xfe24fa43,0x06820237,0x0f6d0aff,0x16721364,0x18db1843,0x17d61896,0x163116f1,0x154e15ae,
0x145c14e8,0x12d513ad,0x110f11e6,0x0f941052,0x0e140ed4,0x0c1f0d3b,0x09280ac0,0x05c3076f,
0x02ba042f,0x0021016b,0xfd58fecb,0xfa3ffbcf,0xf775f8c0,0xf5f3f67b,0xf5fff5d9,0xf71cf666,
0xf942f81c,0xfb36fa50,0xfd0afc15,0xffaefe38,0x03070156,0x05de0496,0x07c606ea,0x09420886,
0x0ada0a0b,0x0ce90bcd,0x0f270e0f,0x1129102c,0x125b11f0,0x122d1273,0x10061162,0x0bb90e1a,
0x05d108f3,0xfe8c025b,0xf5a2fa53,0xebc0f0b4,0xe1a4e6b8,0xd791dc93,0xce51d2cd,0xc6a3ca3d,
0xc081c36a,0xbc32be16,0xba1ebae4,0xb966b9a4,0xb9bfb972,0xbb40ba4f,0xbed5bcb8,0xc54fc1a9,
0xceebc9cf,0xdae7d4a8,0xe880e196,0xf675ef72,0x04f2fda3,0x13f00c65,0x22c91b77,0x30d229eb,
0x3e1a3792,0x497c442b,0x51594dde,0x55a753f1,0x56755674,0x5557560e,0x5395547a,0x51c752b7,
0x4f3850a3,0x4b784d7b,0x46504915,0x3fd24339,0x37ce3c0a,0x2e8a333e,0x252d29e0,0x1b5f205f,
0x10411610,0x034b0a01,0xf4defc32,0xe64ced87,0xd924df66,0xced7d3a1,0xc784cad0,0xc367c50e,
0xc1eac267,0xc1dfc1c6,0xc279c21e,0xc444c323,0xc801c5e9,0xcce0ca4d,0xd28dcfa1,0xd8f9d5a5,
0xe04adc90,0xe80ae420,0xefddebf7,0xf77bf3ac,0xff86fb65,0x088a03ec,0x117c0d2b,0x177e1510,
0x18d618ab,0x17c51874,0x16961712,0x15e5163d,0x14dc1572,0x1364142c,0x11da1299,0x1071112b,
0x0eb40fa6,0x0c390d8f,0x08ee0aa9,0x058f072e,0x02c40421,0xfff60163,0xfcc9fe67,0xf998fb2c,
0xf6faf827,0xf5c1f62b,0xf576f589,0xf5f2f592,0xf75af694,0xf8c1f818,0xfa77f97d,0xfd4bfbbd,
0x00a5fefe,0x037f0229,0x057f049c,0x071e0647,0x09380818,0x0bd70a75,0x0ed20d56,0x117b1035,
0x137f129e,0x13fd1403,0x122e1359,0x0e70108b,0x08dd0bde,0x016f0566,0xf82ffcfd,0xee20f338,
0xe366e8e0,0xd896dde8,0xceddd384,0xc73fcad2,0xc11bc409,0xbcc2be99,0xbabfbb8c,0xb9d7ba3a,
0xb9aab99e,0xbb07ba1a,0xbec6bc89,0xc5a2c1cd,0xcf75ca3a,0xdb8cd53f,0xe925e23b,0xf758f036,
0x0646feb5,0x15820deb,0x24231cea,0x32482b3d,0x3f3e3902,0x495944bb,0x4feb4d06,0x52fc51ed,
0x53425358,0x51db52b6,0x4fc850d8,0x4d994ebf,0x4a964c30,0x46c248cf,0x41e74475,0x3bde3f16,
0x343d3839,0x2beb3012,0x235a27bc,0x199b1eac,0x0e0b1413,0x00e307a0,0xf2e4f9e8,0xe52aebe0,
0xd97adf04,0xd04fd496,0xc9bbccaa,0xc5f0c78a,0xc413c4ca,0xc38cc3b6,0xc40dc39a,0xc681c503,
0xcaa0c863,0xcfa7cd10,0xd56cd26b,0xdc36d8ba,0xe398dfd5,0xeb37e763,0xf2bbeeff,0xfa5bf680,
0x02f7fe7a,0x0ca807c3,0x1537114b,0x19961805,0x19e51a15,0x18b11952,0x179b1823,0x1689171d,
0x14f415cc,0x133a140d,0x11aa1275,0x0fd710d4,0x0d600eae,0x0a200be3,0x06390828,0x02e3047c,
0xffe6015e,0xfcf6fe76,0xf9f1fb74,0xf75cf886,0xf5d1f66f,0xf541f577,0xf53cf530,0xf5d8f572,
0xf6eef667,0xf7fdf76c,0xf9c8f8bb,0xfcb0fb29,0xffdbfe40,0x02ac0163,0x048703a7,0x068b0576,
0x08f607bb,0x0c0c0a6c,0x0f660db7,0x12ec112c,0x15571460,0x15a115c7,0x136b14d7,0x0f331183,
0x09270c6f,0x01500572,0xf841fcdb,0xee23f35d,0xe307e8a5,0xd80bdd72,0xcea4d313,0xc73fcac3,
0xc15bc411,0xbdbbbf40,0xbbbebc98,0xba4abafa,0xb9a8b9c8,0xbb26ba18,0xbf4cbcd7,0xc680c288,
0xd057cb11,0xdc8ed637,0xe9eae325,0xf83cf0e5,0x07afffe2,0x172e0f8c,0x257b1e7a,0x335f2c6d,
0x40323a19,0x49f24580,0x50144d7d,0x527451b6,0x52245287,0x508e5177,0x4e5e4f82,0x4ba34d13,
0x480749f9,0x439e45e2,0x3ea2413c,0x386c3bbd,0x30d234c2,0x28ca2cd2,0x203b24a9,0x16571b7e,
0x0a9710b5,0xfd220403,0xef09f613,0xe1b8e82c,0xd6c7dbea,0xce9bd25b,0xc92fcb89,0xc682c78d,
0xc569c5da,0xc527c52c,0xc657c580,0xc99ec7b6,0xce63cbe7,0xd3cad10c,0xd9c1d6ae,0xe043dcf2,
0xe722e3a7,0xee21eaa5,0xf4eaf193,0xfc13f860,0x04c9002a,0x0ed809cb,0x1708136d,0x1aba1970,
0x1b0c1b27,0x1a691aba,0x19f81a33,0x18e5198f,0x17411820,0x154c1645,0x13681461,0x10ec123c,
0x0df10f7f,0x0a2d0c2b,0x0645082b,0x02de0487,0xff5f0124,0xfb9ffd91,0xf7bbf99f,0xf4dbf61f,
0xf35ff3eb,0xf2e3f312,0xf2e7f2ce,0xf3acf33a,0xf47df421,0xf564f4da,0xf76ff642,0xfa56f8d3,
0xfd94fbf3,0x0068ff15,0x02d40198,0x05950428,0x08ec072b,0x0cca0acf,0x10f60edc,0x148612ed,
0x166715bb,0x1602167e,0x139d1505,0x0f6c11ba,0x09b30cc2,0x0256063d,0xf91efdf1,0xee91f400,
0xe336e8e3,0xd887ddbe,0xcfb9d3d4,0xc89fcc07,0xc2ffc58e,0xbf89c106,0xbd13be47,0xbb11bbfd,
0xba93ba90,0xbc53bb23,0xc0b4be28,0xc7f4c3fe,0xd1a9cc82,0xdd65d75b,0xea56e3bd,0xf886f141,
0x07b1000e,0x165b0f27,0x24031d3e,0x31772ac1,0x3dfc3809,0x4757431c,0x4d694ac3,0x50244f31,
0x50915089,0x4fb15048,0x4e024ef5,0x4b364cc6,0x4742495c,0x42b24509,0x3d904039,0x37063a88,
0x2ef63321,0x26542aae,0x1d0421ca,0x12ef1818,0x076d0d66,0xfa530104,0xecc7f37d,0xe076e65a,
0xd698db34,0xcf57d2a5,0xcaa6ccab,0xc828c932,0xc6fec771,0xc6c6c6bc,0xc86dc74e,0xcc1dca0d,
0xd126ce82,0xd6e0d3fa,0xdd23d9e9,0xe3e3e07a,0xea84e739,0xf0d4edbe,0xf6bdf3cc,0xfd79f9ed,
0x06220186,0x0fc50b08,0x16f013e2,0x19e618d6,0x1a901a6e,0x1a6d1a78,0x1a241a66,0x192a19b5,
0x17ec188d,0x16a71752,0x14a815c1,0x1213136f,0x0ecd108e,0x0a890cc4,0x063c0846,0x02a10462,
0xfed400d5,0xfa5cfca0,0xf660f83f,0xf3dff4de,0xf2edf348,0xf295f2b1,0xf2f6f2b1,0xf350f33a,
0xf327f337,0xf410f369,0xf620f4ff,0xf898f75a,0xfb17f9d3,0xfdd0fc62,0x011aff6e,0x04bc02d9,
0x08f006c0,0x0d4d0b23,0x117a0f79,0x143d1313,0x153114fa,0x142514ec,0x112b12df,0x0d130f3f,
0x07f30aa3,0x013304d5,0xf885fd16,0xee29f378,0xe373e8cf,0xd9a6de50,0xd194d574,0xcabacdfc,
0xc5b7c7f0,0xc25bc3ea,0xbfbfc0f4,0xbdf0beb1,0xbdcdbd9d,0xbfe1be90,0xc473c1d9,0xcb57c7a2,
0xd49fcfb1,0xdfc3da00,0xec56e5d9,0xfa56f32d,0x08f401ab,0x16b21001,0x23a51d28,0x31182a5c,
0x3cec375f,0x45ad41ae,0x4b4e48dc,0x4dff4cff,0x4e9a4e83,0x4db04e4f,0x4b544cb9,0x47884998,
0x42b14538,0x3d834013,0x37f83ade,0x30ed349d,0x29482d1a,0x21492561,0x18b41d06,0x0f431426,
0x043209f7,0xf782fe07,0xeaaef0ff,0xdf6ee4c7,0xd664da9b,0xcff2d2d7,0xcc30cdbf,0xca7acb2d,
0xc9ccca03,0xca73c9e9,0xcd04cb7a,0xd170cf0f,0xd6ced40c,0xdc99d9a7,0xe2f2dfb5,0xe932e622,
0xeef8ec23,0xf46ff1be,0xf9def718,0x004bfce5,0x08860433,0x110b0cef,0x17121478,0x1a2118e4,
0x1b641af1,0x1bac1ba5,0x1b231b79,0x1a741acc,0x198e1a12,0x17c918c5,0x155c16a5,0x121613db,
0x0dbf1008,0x08b80b44,0x0423064c,0x00800249,0xfc4bfe8d,0xf7adf9e5,0xf43ff5c5,0xf28df334,
0xf20ef233,0xf20ef204,0xf231f222,0xf1fbf221,0xf1f8f1e2,0xf310f25f,0xf4b2f3e2,0xf632f570,
0xf838f714,0xfb9ff9c5,0xffaefd9d,0x046001f2,0x094f06d7,0x0df60bc1,0x11270fc3,0x12fa123d,
0x13521353,0x120a12ea,0x0f8910e5,0x0c040de1,0x078a09f7,0x014004a7,0xf8d8fd4c,0xef27f41b,
0xe547ea21,0xdc7ee0c1,0xd4b5d870,0xce61d157,0xc95bcbba,0xc57dc747,0xc2aec3f6,0xc110c1ae,
0xc130c0e3,0xc334c1ee,0xc729c4ef,0xcd57c9f6,0xd5e7d15c,0xe065daec,0xec8fe64c,0xf9f3f326,
0x07b600da,0x14c80e62,0x219b1b17,0x2f30286e,0x3b01357a,0x43ab3fb8,0x498a46f9,0x4c5c4b4c,
0x4d1d4ced,0x4c524cf6,0x49d94b47,0x45e64814,0x40db4370,0x3b983e3a,0x35be38d1,0x2e903244,
0x26e72ac6,0x1ed422ec,0x163d1a95,0x0cf711c8,0x01a80797,0xf4e2fb57,0xe864ee81,0xdd67e2a1,
0xd4cbd8c6,0xcf02d18b,0xcc1ecd3b,0xcb26cb79,0xcb53cb12,0xcce6cbea,0xd00ece4c,0xd4bbd23b,
0xda4ed76e,0xe058dd4c,0xe672e36e,0xec09e955,0xf0d3ee81,0xf566f319,0xfa6df7c9,0x00ecfd74,
0x093004e6,0x11800d82,0x17a914ea,0x1b7619cc,0x1d601ca5,0x1ddf1dbc,0x1dc01dd4,0x1d821da7,
0x1cb21d38,0x1ae21be6,0x182019a3,0x141e1644,0x0ef711aa,0x09710c2a,0x04e70703,0x00e702f9,
0xfbbffe74,0xf64ff8f6,0xf27df421,0xf08bf156,0xefd4f00b,0xefe0efcc,0xefdeefee,0xefb2efbc,
0xf03aefd6,0xf196f0dd,0xf2a5f231,0xf3c4f31e,0xf614f4b5,0xfa23f7f1,0xfef6fc75,0x04ae01bd,
0x0a3f0791,0x0e4f0c8b,0x10640f97,0x10d010c3,0x101310a1,0x0e170f24,0x0b670cd9,0x085109ee,
0x042c066a,0xfe570187,0xf6d0fab7,0xee5ef2a6,0xe635ea2b,0xdec1e26e,0xd7f0db3b,0xd213d4e9,
0xcceacf5e,0xc930cadd,0xc6b1c7cc,0xc599c5e9,0xc643c5b6,0xc88dc73e,0xcc23ca26,0xd1b0ce9a,
0xd9aad562,0xe3ebde7b,0xf00ce9da,0xfd17f684,0x0a0f03b0,0x161c1024,0x227b1c2f,0x2ec528d1,
0x383f33ea,0x3f213bf6,0x43dd41c7,0x467a455f,0x47b54745,0x472e47a8,0x4517465b,0x414d435b,
0x3cb93f0f,0x37c23a52,0x31ae34ed,0x2a952e29,0x232f26eb,0x1b5c1f5f,0x12de1730,0x09250e37,
0xfd90038c,0xf149f75d,0xe620eb8a,0xdcd7e133,0xd623d923,0xd200d3c0,0xd01bd0d4,0xcf6ccfae,
0xcfcfcf70,0xd1dad09e,0xd579d37a,0xda15d7b2,0xdf47dc9e,0xe4f1e215,0xea6ee7c2,0xeefaecd4,
0xf2def0f4,0xf6ebf4d1,0xfc03f942,0x02caff2a,0x0b1906e0,0x12930f1b,0x178c155f,0x1abf194e,
0x1c9c1bdc,0x1d5b1d17,0x1d9e1d80,0x1db31dab,0x1d221d94,0x1b611c61,0x18851a1b,0x1462169d,
0x0f4011e9,0x09fd0c8d,0x058707a9,0x00bb0347,0xfb05fdee,0xf5c1f83f,0xf237f3b4,0xf04ff121,
0xef58efb8,0xef1cef2b,0xeedcef05,0xeeb8eeb5,0xef8fef09,0xf08ff018,0xf152f0f5,0xf272f1c8,
0xf516f37b,0xf991f72b,0xff42fc3d,0x05c10288,0x0b04089f,0x0e0d0cd5,0x0ef10eb8,0x0e080eb9,
0x0c1d0d16,0x09c90b04,0x06e10870,0x0348051f,0xff240158,0xf9e3fca6,0xf3b9f6e0,0xed8af09b,
0xe79cea84,0xe19ce4a2,0xdbccdea9,0xd669d90a,0xd1a0d3e6,0xcdfccfa9,0xcbc4ccac,0xcb21cb3b,
0xcc21cb75,0xce21cd0c,0xd10fcf66,0xd605d347,0xdd43d954,0xe6cde1cf,0xf1c5ec23,0xfdadf7a3,
0x099c03b4,0x15010f52,0x210b1aee,0x2c902707,0x35cb317f,0x3cce398d,0x41913f76,0x445f432f,
0x458b4522,0x45384595,0x43334463,0x3f794190,0x3a7b3d12,0x34b737bf,0x2dbe3159,0x26412a03,
0x1e962276,0x169f1aa3,0x0e1d1284,0x04220956,0xf8b6fe85,0xed51f2f2,0xe2fde7f5,0xdadade9f,
0xd547d7c0,0xd22ed369,0xd113d176,0xd12ad0fa,0xd2a7d1b7,0xd5bdd401,0xd9f1d7b9,0xdee2dc5b,
0xe43fe18c,0xe9a0e6f9,0xee78ec23,0xf24af077,0xf5c8f406,0xf9aaf79f,0xfec6fc0e,0x056001e6,
0x0ca50905,0x13291013,0x185515e3,0x1c401a79,0x1e731d8e,0x1f741f09,0x20171fd1,0x2061204d,
0x1fa72028,0x1dcc1ee3,0x1a631c52,0x1573181b,0x0f77127f,0x09b80c82,0x04950720,0xfede01da,
0xf8bcfbc9,0xf384f5e7,0xf006f190,0xee1beee2,0xed78edae,0xed27ed58,0xeca4ecdd,0xecefeca5,
0xedc5ed5e,0xee3aee0b,0xee8fee66,0xef9ceedc,0xf2d3f0f5,0xf80ef52f,0xfefdfb61,0x05dc028b,
0x0b2608d4,0x0d920cad,0x0d9d0de6,0x0c110ceb,0x09e40b0c,0x074008b3,0x03f305a0,0x00980248,
0xfd0afee6,0xf89cfae2,0xf406f64f,0xef75f1b9,0xeaa5ed25,0xe52de7fc,0xdf9ee263,0xda48dce7,
0xd5b3d7d5,0xd248d3d2,0xd05cd118,0xd03fd01d,0xd14cd0ae,0xd2ccd202,0xd52ed3d4,0xd923d6ed,
0xdf3adbe3,0xe77de325,0xf11aec26,0xfbd8f65a,0x0722017e,0x12620cb9,0x1e5f1845,0x2a44247e,
0x34342f7c,0x3bff3860,0x41273efc,0x438a4296,0x44374413,0x43854402,0x417f42b8,0x3d643fac,
0x37f93acf,0x318d34e5,0x2a562e05,0x229d2689,0x1aea1ebc,0x131b1709,0x0aaa0f01,0x00be05f1,
0xf5adfb48,0xeaa4f013,0xe0dae580,0xd967dccd,0xd4b4d6b7,0xd2b3d364,0xd2bcd282,0xd430d350,
0xd6c8d55a,0xda39d868,0xde9bdc4f,0xe3d1e126,0xe93fe68a,0xee03ebbc,0xf1cbf00a,0xf4a6f34f,
0xf787f608,0xfaeaf91f,0xff55fcff,0x04b301e5,0x0b1f07bb,0x125f0ec0,0x18ba15bb,0x1d1d1b3c,
0x1f331e58,0x207d1fe1,0x219a2115,0x21e421e0,0x213321a8,0x1f402067,0x1baa1db1,0x16951945,
0x10c013bb,0x0b190dd9,0x05a1086e,0xff5a029b,0xf8c9fc05,0xf347f5d3,0xef60f11b,0xed89ee34,
0xec96ed14,0xeb5eebfe,0xeac5eaef,0xeb28eadf,0xeb90eb6e,0xeb73eb8b,0xeb80eb60,0xed25ec0b,
0xf10feecb,0xf773f401,0xfed5fb1c,0x05f5028a,0x0aa508b2,0x0cb40bfa,0x0c430cc0,0x0a7a0b79,
0x0802095c,0x0467064d,0x0098027c,0xfd18fecf,0xf94bfb42,0xf56ff75a,0xf1f2f39c,0xeecaf05d,
0xeb40ed1a,0xe73be948,0xe2cbe50e,0xde3ee07b,0xda49dc2b,0xd77bd8b4,0xd625d69e,0xd64dd611,
0xd720d6a7,0xd888d7c3,0xda9cd978,0xde1fdc23,0xe37de08f,0xeaaae6d8,0xf364eed5,0xfd8af857,
0x083902db,0x13510db3,0x1ef8191d,0x29b6248e,0x327f2e5f,0x3904360a,0x3cb03b43,0x3df23d79,
0x3e0a3e1e,0x3d603dda,0x3b1a3c7b,0x37373952,0x322834d0,0x2c4e2f48,0x25a1291a,0x1e522200,
0x16e11aa1,0x0f1a1310,0x06580ae8,0xfc1e0162,0xf13af6ac,0xe6f7ebf1,0xde95e277,0xd907db73,
0xd62cd744,0xd598d5a1,0xd6c4d604,0xd921d7cb,0xdc51daad,0xe049de2c,0xe53de2a2,0xeab5e7f6,
0xef96ed4c,0xf353f19b,0xf5e0f4bb,0xf802f6ea,0xfa94f939,0xfd9ffc0e,0x00e8ff42,0x04fa02bd,
0x0b1307ca,0x12310ea1,0x1814156b,0x1bc21a2e,0x1e0d1cf9,0x200f1f18,0x216520d9,0x21c621b4,
0x211b21a7,0x1ee42030,0x1b191d2f,0x162f18ba,0x10eb1395,0x0b6e0e30,0x0585088d,0xfef30250,
0xf870fb95,0xf31cf59b,0xefa8f11d,0xedafee93,0xebb0ecc1,0xea06eab0,0xe9d1e9c3,0xea29e9ff,
0xe9e5ea21,0xe94de990,0xe9cbe95e,0xec0ceaaa,0xf0c5ee0f,0xf76ff3f9,0xfeeefb1d,0x056c027a,
0x097407bf,0x0afd0a84,0x0a9e0afb,0x092509fe,0x066c07fa,0x02d704ad,0xfefc00e9,0xfb1ffd16,
0xf74ff934,0xf3d0f57a,0xf0f7f255,0xee3cef97,0xeb7eece4,0xe83ce9f7,0xe45ae657,0xe099e26a,
0xdd85def4,0xdbaddc6f,0xdb10db35,0xdb87db40,0xdc36dbdb,0xdd15dc9b,0xdeabddb9,0xe1aadffb,
0xe636e3b8,0xec62e91e,0xf435f00c,0xfdb2f8cb,0x080c02d3,0x12d30d5a,0x1e3f1883,0x28d023bb,
0x31642d5f,0x377134d1,0x3a51393f,0x3b1d3ae0,0x3aed3b1d,0x39be3a7b,0x374438a9,0x33623581,
0x2e753100,0x28f02bd1,0x225a25c6,0x1b131ec7,0x13821755,0x0b730f91,0x025f0712,0xf80ffd54,
0xed93f2ca,0xe405e897,0xdcc3e005,0xd840da28,0xd634d6f2,0xd67ed619,0xd89dd760,0xdbdcda28,
0xdfb1ddae,0xe46be1ec,0xea22e72c,0xefdded19,0xf449f247,0xf735f5e8,0xf8f9f832,0xfa89f9b8,
0xfc7ffb76,0xfeb0fd92,0x0136ffe0,0x056a02fe,0x0c19087d,0x13a80fed,0x19c91704,0x1da11bf5,
0x202f1efe,0x22302144,0x236622ee,0x23652394,0x220822d9,0x1f6520e2,0x1b701d8d,0x16a81923,
0x1141140a,0x0b530e4f,0x05000846,0xfe170191,0xf783fab7,0xf1fbf48e,0xee6fefed,0xec29ed46,
0xe9ffeb0a,0xe8bde92e,0xe8c6e8a4,0xe90ae8f4,0xe8c4e8f6,0xe8b8e8a5,0xea08e91e,0xed87eb7c,
0xf32af023,0xf99df65b,0xffd4fcd9,0x04930265,0x07140631,0x07be078d,0x07300797,0x0561067d,
0x024603ec,0xfea5007f,0xfaedfcc9,0xf735f913,0xf3d7f570,0xf14af271,0xef7df05e,0xed95ee8b,
0xeba5ec9f,0xe962ea96,0xe6b1e80f,0xe444e56b,0xe26de341,0xe12fe1b9,0xe0cfe0e0,0xe125e0f0,
0xe185e152,0xe223e1cc,0xe376e2a2,0xe60ae4a1,0xe9a8e7ad,0xeefcec17,0xf615f24c,0xfefbfa58,
0x08c003d1,0x13240dd1,0x1e3518af,0x28472375,0x303b2c93,0x35353328,0x36c7364d,0x36f136f0,
0x366e36c9,0x34ed35d3,0x31fe33ad,0x2d972fed,0x28e42b2d,0x24062693,0x1e182130,0x174b1ad0,
0x100d13b9,0x08170c2d,0xff0503b4,0xf4bef9ff,0xea23ef61,0xe124e554,0xdafcddaf,0xd7bfd900,
0xd73cd72b,0xd914d7e6,0xdc69da9f,0xe035de45,0xe466e23b,0xe986e6d6,0xef76ec75,0xf4eff258,
0xf8c6f715,0xfab7f9f8,0xfb8efb2f,0xfcb0fc08,0xfe0bfd67,0xfefdfe8e,0x0073ff81,0x04f30239,
0x0c86087e,0x144d1097,0x1a2a177c,0x1e1b1c53,0x21591fcc,0x23b322a3,0x25062485,0x24bc251f,
0x22cf23ed,0x1fe22176,0x1c2a1e16,0x17f11a26,0x12991562,0x0c960fa4,0x0600095b,0xff0f028f,
0xf84efb95,0xf2e2f55c,0xef21f0e3,0xec01ed82,0xe9a2eaa8,0xe863e8e2,0xe7dbe812,0xe74ae7a2,
0xe682e6df,0xe6dae676,0xe8ffe7ad,0xed28ead4,0xf291efcb,0xf846f56a,0xfd74fb06,0x00d8ff62,
0x02b401f1,0x03500327,0x02930323,0x009101b7,0xfdbeff33,0xfaa3fc39,0xf753f8fe,0xf414f5b0,
0xf161f295,0xefdcf087,0xee85ef32,0xed86edf4,0xec97ed21,0xeb15ebe0,0xe979ea3f,0xe869e8db,
0xe7b9e810,0xe729e767,0xe714e70e,0xe72fe720,0xe735e737,0xe74ae72c,0xe840e7a1,0xea24e917,
0xed1ceb7a,0xf160ef12,0xf788f42a,0xffa0fb5b,0x08c70420,0x129b0d93,0x1d3f17de,0x27142264,
0x2ebf2b42,0x33093161,0x340033d0,0x339333e7,0x323e3308,0x2fd13135,0x2c362e2a,0x27c62a0e,
0x23572586,0x1ed12123,0x19871c43,0x138316a2,0x0cb41037,0x050108f8,0xfc2d00bf,0xf220f744,
0xe831ed00,0xe04ee3ec,0xdaffdd54,0xd865d951,0xd8a0d82a,0xdb52d9b5,0xdf57dd40,0xe3dbe18f,
0xe8c2e63f,0xee54eb78,0xf424f141,0xf92cf6d6,0xfc4dfb07,0xfd81fd13,0xfe01fdc5,0xfe7efe3e,
0xfe89fea2,0xfde5fe34,0xfef5fe06,0x03fa00f6,0x0be607bd,0x13ec1012,0x1a80175f,0x1f871d3f,
0x2329217b,0x25a4248c,0x26a62663,0x25b62669,0x235e24ae,0x204721da,0x1cf61ea4,0x18dd1b16,
0x13621640,0x0d801076,0x071f0a62,0x005303c4,0xf9affce6,0xf3e7f6ac,0xef10f166,0xeb3becf6,
0xe8e8e9e7,0xe7b2e839,0xe6bee739,0xe5b9e635,0xe591e571,0xe727e62b,0xea12e874,0xee31ec03,
0xf2bcf06e,0xf747f516,0xfa7df90c,0xfcbffbc0,0xfdf6fd7a,0xfdf4fe1c,0xfcd1fd85,0xfaf9fbf0,
0xf8cdf9ed,0xf670f7a9,0xf3dbf529,0xf151f28c,0xef99f054,0xee4eeef3,0xed6dedc5,0xed2fed41,
0xece6ed1a,0xec4bec99,0xec1aec19,0xec74ec37,0xecf6ecbb,0xed59ed2b,0xed98ed7d,0xed9aeda7,
0xed19ed6c,0xec9fecc5,0xece5eca9,0xeddded50,0xefcdeea4,0xf374f164,0xf944f613,0x012ffd08,
0x0a190593,0x13e30eda,0x1e301912,0x27602302,0x2dfd2b18,0x31092ffc,0x30ba312f,0x2f28300d,
0x2cb42e0a,0x29872b32,0x259f27a9,0x215b237b,0x1d181f3c,0x18c51af1,0x1435168a,0x0ee511ad,
0x08cc0beb,0x01c80571,0xf90efdad,0xeef9f40f,0xe5b9ea1d,0xdea7e1e9,0xda0cdc02,0xd87ed8d4,
0xda26d8fc,0xddeedbd9,0xe288e02f,0xe780e4f9,0xecc2ea13,0xf2a1ef9f,0xf8b6f5b7,0xfd79fb56,
0x000cff04,0x012f00ba,0x01980176,0x0138018c,0xff95008c,0xfdf7fe8e,0xffa2fe42,0x0590021d,
0x0df109a3,0x15f7121b,0x1ca7197d,0x21ab1f66,0x2547239c,0x2796269c,0x2804280f,0x267d2772,
0x23dd2544,0x20f2226e,0x1d9d1f65,0x18e11b74,0x1322160e,0x0d63103f,0x07400a6c,0x006003db,
0xf984fceb,0xf2eaf628,0xed2aefdc,0xe96eeaff,0xe772e854,0xe5f1e6a6,0xe492e543,0xe3c6e402,
0xe490e3f7,0xe693e570,0xe9cbe80a,0xed7feba5,0xf19eef85,0xf50ff373,0xf7d0f68d,0xf9acf8db,
0xfa5dfa22,0xfa31fa69,0xf943f9c5,0xf814f8b4,0xf684f75c,0xf49df59c,0xf27cf38d,0xf09cf17b,
0xef24efd8,0xede3ee7a,0xed19ed6b,0xecb1ecdb,0xec61ec8d,0xec29ec3a,0xeccbec55,0xee51ed7d,
0xefffef2a,0xf131f0ae,0xf1ecf1a1,0xf201f20c,0xf18bf1c7,0xf159f160,0xf192f16c,0xf209f1c1,
0xf394f295,0xf74ef521,0xfd74fa1d,0x05270131,0x0d82093d,0x16da1208,0x20991bd2,0x288c24df,
0x2d9f2b83,0x2eb72eb7,0x2c9c2ddd,0x29952b2c,0x261327dd,0x22512445,0x1e00202f,0x19bf1bd3,
0x15f417c6,0x12a01445,0x0f3010f3,0x0b000d37,0x05d8088a,0xff4602cd,0xf685fb2b,0xecbef197,
0xe426e82c,0xddafe0a2,0xda04db70,0xd9e3d986,0xdcb5db04,0xe14ddedc,0xe655e3cb,0xeb8ce8e8,
0xf112ee43,0xf6f3f3f7,0xfcb5f9f9,0x00bcfeff,0x02e701ff,0x03d9037f,0x03cc03f8,0x023e0335,
0xff7a00ec,0xfe14fe64,0x00a0fec6,0x073f038e,0x0f7a0b55,0x1736137b,0x1d9c1a96,0x222c2020,
0x257a23f8,0x275426a5,0x27412786,0x25852689,0x23362458,0x20d82215,0x1d7b1f53,0x19031b5a,
0x13f71685,0x0eda116e,0x08f10c11,0x02010589,0xfad4fe78,0xf35ef711,0xed5bf007,0xe9e7eb64,
0xe7b1e8b8,0xe5aee6af,0xe3f8e4bf,0xe38be38a,0xe46ce3e2,0xe63ae52d,0xe8d6e788,0xebdcea3f,
0xeed2ed71,0xf17af024,0xf3caf2b8,0xf500f48f,0xf56af548,0xf559f565,0xf524f543,0xf4e6f508,
0xf44bf4a5,0xf34af3d6,0xf235f2ba,0xf147f1b6,0xf032f0c2,0xef1eef9f,0xee45eeae,0xeda8edeb,
0xed43ed72,0xed49ed29,0xee8fedbd,0xf0fcefac,0xf385f254,0xf539f476,0xf61af5ce,0xf5f8f625,
0xf562f5af,0xf4f9f52c,0xf478f4c2,0xf41ef431,0xf52df45c,0xf8c4f6a3,0xfeacfb7f,0x05e0022c,
0x0dca09c0,0x16a91216,0x1fd21b5b,0x274b23da,0x2bc32a00,0x2bfe2c63,0x297e2aee,0x262427e0,
0x22752458,0x1e5b206e,0x1a0d1c3c,0x157517c8,0x116a134f,0x0e420fc8,0x0b100cb6,0x07630947,
0x02d9054a,0xfc84fffd,0xf3e8f86e,0xeaafef32,0xe2e3e68c,0xdd23dfbb,0xda3edb4a,0xdae8da23,
0xde4ddc59,0xe335e0a0,0xe8b4e5ed,0xee59eb7c,0xf451f14e,0xfa6af75b,0x000afd60,0x0400023f,
0x0636054f,0x072206d2,0x06960716,0x04120590,0x00a2024e,0xff75ff92,0x0277006d,0x08cf0555,
0x108b0ca5,0x17ed1455,0x1e441b4d,0x22c720b5,0x26062496,0x275c26fb,0x26d62745,0x253e2618,
0x2348244a,0x20e02233,0x1d531f46,0x18d11b25,0x13fa165c,0x0f071197,0x08f40c2a,0x01fb058e,
0xfa36fe3b,0xf24ef61d,0xec81ef13,0xe900ea8a,0xe672e7a7,0xe447e549,0xe363e39d,0xe409e39a,
0xe543e496,0xe71fe61d,0xe95ee82d,0xeb98ea8f,0xed4dec77,0xef04ee23,0xf046efc6,0xf0ecf0a2,
0xf132f118,0xf14ff148,0xf179f15f,0xf19af18e,0xf177f18e,0xf152f162,0xf142f148,0xf117f13b,
0xf093f0df,0xefe8f040,0xef37ef8c,0xeeb0eeeb,0xee61ee7e,0xeedeee74,0xf0bbefa5,0xf398f219,
0xf638f4fc,0xf80ef740,0xf8e6f89a,0xf909f905,0xf8e1f8fd,0xf869f8af,0xf780f802,0xf6a8f6f7,
0xf79df6d1,0xfaf6f900,0x0067fd72,0x073303ba,0x0e8b0ac0,0x173212b3,0x206f1bea,0x27b2246f,
0x2b3529fd,0x2a4f2b44,0x26e128b5,0x22d024e8,0x1e6f20a2,0x19ed1c34,0x14cc177b,0x0f4611f6,
0x0b2f0cf8,0x08a709d1,0x066a078b,0x03ee0539,0x0092026d,0xfb4bfe3e,0xf3c1f7bc,0xeb7bef98,
0xe423e7a3,0xde5ce0fa,0xdb5ddc71,0xdbefdb36,0xdf5edd66,0xe476e1c3,0xea44e750,0xf039ed3f,
0xf622f331,0xfc03f917,0x0170fed3,0x057d03b0,0x07d506d2,0x08e5088c,0x07e708b4,0x04af0679,
0x016002e1,0x00890087,0x038b0189,0x09de065f,0x11e10dc8,0x199c15e6,0x1fe01cf4,0x244e2247,
0x272625f6,0x282327db,0x27be2814,0x2656271b,0x246b2576,0x21872325,0x1d8d1fa5,0x18f11b52,
0x1436168e,0x0f5b11e5,0x09b00c98,0x02f40680,0xfad6ff05,0xf330f6c3,0xede2f03e,0xea57ebfa,
0xe76ee8d1,0xe579e650,0xe4d2e4f5,0xe50de4e6,0xe58fe53f,0xe69fe606,0xe7c6e73c,0xe8aee844,
0xe96ae905,0xe9e4e9b6,0xea7bea2a,0xeaf3eab9,0xeb99eb42,0xec38ebe7,0xecfeec96,0xeda7ed5d,
0xee5aedf1,0xef1feebb,0xf010ef9a,0xf09cf06c,0xf0b6f0af,0xf09bf0b6,0xf057f077,0xf00af02e,
0xf017effd,0xf142f07f,0xf378f244,0xf63df4d9,0xf8aaf786,0xfa3ff991,0xfb3dfac9,0xfc32fbc0,
0xfc92fc79,0xfc2cfc7b,0xfb0ffba0,0xfa9dfaa7,0xfc18fb16,0xffa0fd9a,0x04e50215,0x0b500807,
0x123e0eaf,0x1a631623,0x226b1ea2,0x27d22583,0x2983292c,0x274b28dc,0x23132539,0x1e6f20cf,
0x19781bf4,0x141416e2,0x0dff111c,0x085f0af8,0x04d60652,0x02be03b4,0x010301e0,0xff380028,
0xfc98fe13,0xf803fa8e,0xf183f4f6,0xea3fede3,0xe3a9e6d6,0xde64e0bf,0xdc3fdcdd,0xdd7bdc7d,
0xe131df1b,0xe653e3ab,0xec21e929,0xf235ef2a,0xf826f534,0xfe3bfb29,0x03d4012f,0x07e10611,
0x0a550945,0x0b4c0b07,0x0a130b03,0x06d30895,0x03f90528,0x03e40384,0x075d052e,0x0d610a2d,
0x146310da,0x1b2317d6,0x20cb1e2a,0x24bd22ef,0x2759263e,0x28812816,0x2854289a,0x26fa27bc,
0x2508261c,0x21e823a6,0x1dcf1fe9,0x19211b87,0x144916b6,0x0f2e11d0,0x095f0c56,0x02c00639,
0xfb03fef7,0xf409f743,0xef65f174,0xec55edbf,0xe9eeeb16,0xe799e8be,0xe5eae6a7,0xe4c6e54a,
0xe46ae47b,0xe43ce451,0xe440e43b,0xe432e44c,0xe370e3d8,0xe2e2e318,0xe340e2f3,0xe415e39b,
0xe558e4a9,0xe6e3e615,0xe896e7bb,0xea22e968,0xebb3eae1,0xedadec99,0xf015eee1,0xf1d5f10b,
0xf328f288,0xf409f3ab,0xf472f44e,0xf495f480,0xf538f4d3,0xf68cf5c7,0xf864f76f,0xfa3bf95e,
0xfb8cfaf8,0xfc42fbef,0xfd2bfca2,0xfe52fdc4,0xfed4feb2,0xfe7efec0,0xfdaefe1b,0xfd64fd67,
0xfe8afdc7,0x0101ff94,0x056602ed,0x0b9e0855,0x12aa0f14,0x1ac71691,0x22cd1f05,0x27d725c6,
0x28f328e7,0x261427f8,0x20ff23a7,0x1b561e3a,0x15471852,0x0ed71222,0x07cb0b5d,0x019d046d,
0xfe3cff8d,0xfce3fd74,0xfc2cfc79,0xfb66fbdc,0xf9a5faaf,0xf682f84a,0xf1acf446,0xeb98eeba,
0xe559e871,0xe019e27e,0xddadde79,0xde7fddb8,0xe1ecdfea,0xe774e477,0xee08eab4,0xf484f14e,
0xfa90f79d,0x005dfd76,0x05e4033c,0x0a150831,0x0ca00b90,0x0d170d2c,0x0afa0c55,0x0795094b,
0x053f062a,0x057d04fd,0x089d06ad,0x0ea00b48,0x1670126c,0x1dd21a52,0x234420cd,0x26c12535,
0x28d027fa,0x296b2949,0x28e62947,0x27532839,0x24fd2649,0x218b2364,0x1d671f8b,0x18da1b2a,
0x13f31675,0x0ed21167,0x09260c1e,0x021e05d2,0xfa3ffe20,0xf3e1f6c7,0xefb5f18e,0xecd3ee2f,
0xe9f9eb6e,0xe743e885,0xe55de63b,0xe44be4b6,0xe3c6e3fc,0xe37be39a,0xe30ce361,0xe185e25a,
0xdfc4e0a9,0xde7ddefb,0xdeb8de6c,0xe00bdf4d,0xe1d4e0eb,0xe3f5e2d7,0xe619e511,0xe81de713,
0xea6ce938,0xed5febd2,0xf062eef0,0xf2e8f1ae,0xf50af40a,0xf658f5cc,0xf6e5f6b5,0xf73ef70d,
0xf7eaf787,0xf8f8f86a,0xfa17f98c,0xfb1dfa96,0xfc07fba0,0xfcb2fc56,0xfe06fd3d,0xffcdfeef,
0x0111008a,0x0148014c,0x00cf0118,0x00880090,0x011000b7,0x02c701b0,0x06b30470,0x0c730970,
0x12de0f91,0x1a481679,0x21431df9,0x25af23de,0x268c2699,0x23bb2588,0x1ece2169,0x18f81bf4,
0x129615d9,0x0b920f2d,0x043207dd,0xfe2f00de,0xfb1bfc4d,0xfa01fa6b,0xf9a9f9c8,0xf926f973,
0xf7e2f8a1,0xf595f6e8,0xf1acf3d8,0xec68ef2a,0xe699e97c,0xe1bae3f0,0xdf51e030,0xdfa9df26,
0xe2ace0cd,0xe824e524,0xeeeeeb7b,0xf58ef255,0xfb9ff8a3,0x0197fe9c,0x071a046f,0x0b5a096d,
0x0dbd0cd0,0x0dc90e1b,0x0b570cce,0x086d09c7,0x06f70777,0x079d06f9,0x0abd08dc,0x106f0d50,
0x17a913f7,0x1e6e1b36,0x23b52145,0x275d25b7,0x299728ab,0x2a622a29,0x29e52a4e,0x286d2943,
0x25da2747,0x22542434,0x1df42037,0x19221b9c,0x13de1688,0x0ea71139,0x09050bff,0x021d05ae,
0xfb28fe7c,0xf615f859,0xf29af441,0xef42f0f5,0xeb69ed6d,0xe778e958,0xe4a7e5f3,0xe2d2e386,
0xe201e265,0xe113e19d,0xdf6be050,0xdd21de57,0xdaf9dbf9,0xd9fcda46,0xdaa0da1b,0xdc40db60,
0xde5bdd40,0xe0c1df8c,0xe32ce1fa,0xe5bfe464,0xe8efe73f,0xecd0ead0,0xf07deebc,0xf3b4f221,
0xf674f52d,0xf85df77e,0xf98ff909,0xfa83fa09,0xfb4dfaf5,0xfbc5fb96,0xfbebfbe3,0xfbf3fbe2,
0xfc13fc07,0xfc5ffc22,0xfdc1fced,0x0001fecf,0x02120123,0x032e02c3,0x037e0363,0x03720376,
0x03ea0390,0x05cd0496,0x0a2507aa,0x0ff80cff,0x164012fe,0x1df519ec,0x252621dd,0x28db278a,
0x287b2927,0x243426d0,0x1dbc2112,0x16731a2b,0x0e911297,0x061e0a68,0xfdc401d1,0xf795fa36,
0xf519f5f9,0xf490f4b6,0xf4b9f49c,0xf48df4b9,0xf3f7f446,0xf2aaf382,0xefa6f161,0xeb2bed91,
0xe612e897,0xe1e0e3bf,0xdfd1e08d,0xe091dfd7,0xe430e1fe,0xea4de707,0xf13aedc8,0xf759f46a,
0xfcdffa21,0x02aeffbb,0x08400590,0x0c890a9e,0x0ec70ded,0x0e570ef3,0x0bd60d2c,0x09eb0ab2,
0x097d0981,0x0ac509f1,0x0e370c15,0x14ac111f,0x1c4f1894,0x22541f8e,0x2671249e,0x291427e2,
0x2a8529ff,0x2abc2ac3,0x29f52a75,0x280f292c,0x24df2699,0x20f522fb,0x1cad1ed3,0x17c21a5d,
0x127a150f,0x0dcf1018,0x08670b4d,0x01b60525,0xfbf4fe8e,0xf82df9e2,0xf4e6f690,0xf109f319,
0xec17eea5,0xe7afe9be,0xe3f7e5b1,0xe1cae2be,0xe02ee0f3,0xde2fdf48,0xdb5adce3,0xd868d9cd,
0xd61dd71c,0xd56cd587,0xd68ad5db,0xd86dd761,0xdb17d9ae,0xde3ddca5,0xe150dfbc,0xe4e2e307,
0xe923e6e1,0xede3eb89,0xf23ef01f,0xf64ef44f,0xf99ff818,0xfc0ffaeb,0xfdc2fd03,0xfed5fe5e,
0xff47ff24,0xfee3ff32,0xfd9efe4f,0xfc72fd05,0xfb69fbe7,0xfb29fb1c,0xfc7cfb9c,0xff29fdb9,
0x01c1008d,0x037702b8,0x046f0405,0x052404c9,0x06180585,0x08970712,0x0d0a0aa3,0x126a0fa4,
0x189b155a,0x1ff71c38,0x26552387,0x28c7281b,0x2710286b,0x21a824c2,0x1a581e1e,0x12b61691,
0x0a770eb1,0x01b90619,0xf980fd6f,0xf3e3f641,0xf18bf261,0xf14af13a,0xf1b6f178,0xf200f1e6,
0xf1eaf204,0xf12bf1b1,0xef05f04a,0xeb2aed42,0xe6cfe8ec,0xe361e4ec,0xe1b8e243,0xe2a4e1db,
0xe64de41c,0xec41e91d,0xf287ef78,0xf801f55a,0xfd56faa3,0x0300001d,0x088305da,0x0cb60ad8,
0x0ebb0e02,0x0e4f0ed0,0x0c8e0d6f,0x0bc70bf8,0x0c670bec,0x0e570d36,0x12490ffb,0x18af153d,
0x1f791c3c,0x245c2224,0x27b92639,0x297128c3,0x2a4129ee,0x2a152a58,0x28fc299a,0x26ef281d,
0x23c0256f,0x200d21f2,0x1bea1e0e,0x17011996,0x11c71454,0x0d400f74,0x080b0ad4,0x02510516,
0xfe14fffa,0xfabffc68,0xf6fdf8f4,0xf207f4af,0xec7aef3f,0xe748e9cd,0xe30ae4fd,0xe044e19b,
0xdd6dded2,0xda36dbef,0xd6e4d87c,0xd420d56b,0xd27bd31e,0xd28ad24a,0xd3fbd328,0xd602d4f7,
0xd8a4d73a,0xdbb4da26,0xdf46dd61,0xe3aee15c,0xe8fae63e,0xee3cebad,0xf32af0ba,0xf7c6f58a,
0xfb96f9d1,0xfe80fd23,0x00b1ffad,0x021f0185,0x029d0284,0x01d30262,0xffd700e8,0xfde3fed0,
0xfc4afd06,0xfc24fbf3,0xfdddfcc5,0x00d3ff49,0x03810244,0x053f0478,0x06a705fc,0x07bf073d,
0x08f3083f,0x0b5709f8,0x0f230d16,0x13d61167,0x19881682,0x20441cdf,0x25a72355,0x274626fb,
0x24de2687,0x1f142259,0x178e1b6d,0x0f75139b,0x06670b03,0xfd1d01b5,0xf51ff8d6,0xf00bf22a,
0xee17eebf,0xee05edec,0xee7aee3b,0xeeb0eea1,0xeed0eebc,0xeeaaeede,0xed3cee21,0xea34ebde,
0xe6dce872,0xe452e575,0xe327e37d,0xe463e36e,0xe880e618,0xee83eb66,0xf47af197,0xf9c4f72f,
0xfefbfc56,0x048901b8,0x0a080758,0x0e270c5a,0x10080f5e,0x0fb9101f,0x0e890f11,0x0eb30e72,
0x0ffe0f3d,0x122e10ec,0x166713f7,0x1ce11970,0x233a2044,0x278925a6,0x29ff28f8,0x2aec2a9b,
0x2afd2b0d,0x2a292ab0,0x28852974,0x25cc2749,0x222d2409,0x1e412040,0x1a161c3f,0x150017a9,
0x1007125f,0x0bcd0de8,0x0717098b,0x026604a0,0xfea10075,0xfaebfcd0,0xf67af8c9,0xf11ef3f3,
0xeb47ee25,0xe5d7e882,0xe141e36c,0xdd8adf4b,0xd9f2dbcf,0xd661d819,0xd365d4c1,0xd144d235,
0xd08ad0bb,0xd14ad0b1,0xd30ad21e,0xd55cd420,0xd84ed6bd,0xdbdada03,0xe035dddc,0xe591e2c5,
0xeb8be884,0xf135ee75,0xf685f3e4,0xfb32f8fc,0xfebffd1d,0x0173002d,0x03540286,0x042a03e0,
0x04010438,0x025c0369,0xff7800f3,0xfcb9fe0d,0xfad5fb95,0xfac8fa90,0xfc96fb79,0xff5cfdee,
0x01d800b6,0x03d702d7,0x05f904e8,0x07fb0700,0x09ff08f4,0x0cf10b4a,0x112b0eef,0x1639139c,
0x1bf91900,0x228e1f36,0x27b12590,0x28af28ba,0x25b727a7,0x1f1622cf,0x16b51af9,0x0dcb1254,
0x04480916,0xfaf8ff8e,0xf2e5f6b0,0xede3efed,0xec0aeca3,0xebe4ebd6,0xebf7ebfa,0xebe0ebe9,
0xec0cebf2,0xec0eec21,0xeaefebb5,0xe856e9c4,0xe5bce6f3,0xe3d9e4a8,0xe381e36b,0xe5aee442,
0xea57e7b9,0xf06ded59,0xf612f35f,0xfb01f895,0xffd3fd66,0x05090260,0x0a3207ba,0x0dea0c4d,
0x0f900f02,0x0f550f94,0x0f400f23,0x10670fb6,0x1224113a,0x14b2133e,0x197a16b7,0x20861cdf,
0x26dc23f7,0x2ae22926,0x2c952c04,0x2cb72cc0,0x2c202c80,0x2b022b9f,0x29162a2d,0x25f227a6,
0x221f240b,0x1e352027,0x1a141c3a,0x150d17a5,0x1065129e,0x0c480e59,0x07ba0a0d,0x034a056e,
0xff120138,0xfa41fcb7,0xf513f7c1,0xef4ff22f,0xe9dbec91,0xe4aee73c,0xdfece22f,0xdba1ddc1,
0xd7b5d9a8,0xd3e3d5b5,0xd0ead24d,0xcf0acfd8,0xce36ce73,0xceb0ce50,0xd034cf54,0xd2a0d14a,
0xd5f5d433,0xda1cd7e5,0xdf7edcab,0xe5bfe28a,0xec30e90a,0xf245ef36,0xf848f554,0xfd27fae2,
0x00d0ff21,0x037f0246,0x053f0480,0x062205cc,0x05ae062b,0x0319049c,0xff8d015a,0xfc5bfdd8,
0xfab3fb45,0xfadcfa97,0xfc75fb7b,0xfed5fda1,0x00fdfff5,0x033e0209,0x05f10497,0x0844072b,
0x0abc0968,0x0e070c42,0x127c1013,0x18241540,0x1dea1b08,0x2446210d,0x29032715,0x299329cc,
0x2659286e,0x1f47234a,0x15ec1ab9,0x0bde10f2,0x01a906b7,0xf845fcd2,0xf089f41b,0xeba7edab,
0xe9f2ea78,0xe9bae9c6,0xe9b4e9b6,0xe9b8e9ae,0xea35e9ea,0xea90ea75,0xe99cea55,0xe73ee880,
0xe501e60f,0xe355e40d,0xe361e314,0xe619e467,0xeb56e874,0xf1c1ee81,0xf772f4b9,0xfc79fa03,
0x0142fee0,0x062c03ae,0x0b1f08b1,0x0ef40d45,0x1080100b,0x1063107f,0x10da107b,0x125d117b,
0x144d1350,0x16fe1573,0x1bdb190e,0x230b1f56,0x294d2680,0x2cf22b6e,0x2e3f2de2,0x2d9f2e13,
0x2c6d2d1d,0x2ab32b95,0x286429ae,0x24a726a9,0x208d2294,0x1cb91ea4,0x18a41ac1,0x1409165f,
0x102f11e7,0x0ce60ea5,0x08680ac5,0x03d0061a,0xfeff017d,0xf9dcfc71,0xf46ff730,0xee92f17c,
0xe8f1ebc6,0xe332e606,0xde28e099,0xd9bfdbe3,0xd5ead7c0,0xd251d410,0xcf85d0ca,0xcdd7ce88,
0xccf2cd5a,0xcccfccbd,0xce00cd39,0xd094cf1e,0xd448d250,0xd90dd680,0xdf40dc07,0xe64ce2b0,
0xed74e9ee,0xf421f0db,0xfa52f74d,0xff1dfcf0,0x024f00dc,0x04990388,0x06410581,0x070c06cb,
0x062606d8,0x032e04e5,0xff5c0141,0xfc58fdaf,0xfaf0fb71,0xfad8fac0,0xfbf2fb3e,0xfe12fcec,
0x0058ff36,0x032601a5,0x062c04b4,0x08d90786,0x0bed0a47,0x100e0dd6,0x1547128a,0x1b171834,
0x20a31de4,0x26702394,0x29d328a6,0x28dd29d5,0x24742712,0x1ce22109,0x136c183f,0x09610e79,
0xff490448,0xf647fa99,0xef41f269,0xeb23eccf,0xe979ea15,0xe8c8e91d,0xe834e87e,0xe7fce804,
0xe856e81d,0xe88ae887,0xe75ae82a,0xe539e643,0xe38ee447,0xe2e6e311,0xe408e32c,0xe7a9e597,
0xed2eea40,0xf350f04e,0xf84af5f1,0xfc9afa7a,0x00ebfebc,0x05be0343,0x0aba0853,0x0e8d0cd4,
0x10720fc2,0x110810c2,0x12551188,0x14901361,0x170215c7,0x1a511878,0x1fca1cb8,0x26ce234c,
0x2c1d29c8,0x2ef42dd0,0x2f9c2f91,0x2eae2f3b,0x2cfb2dfe,0x2a872bc2,0x277a292e,0x235b2573,
0x1fac216f,0x1c431df2,0x18cd1a9a,0x150516df,0x1234137c,0x0ef710cc,0x0a2b0cb2,0x04c9078a,
0xff510206,0xf996fc7d,0xf337f688,0xecb6efe3,0xe675e98c,0xe08fe374,0xdb93ddee,0xd74ed959,
0xd36fd55c,0xcfe5d19a,0xcd2bce61,0xcb5bcc2c,0xca2ccab2,0xca0dc9e2,0xcba6ca9b,0xcf05cd26,
0xd3a2d139,0xd95dd64c,0xe05ddcc7,0xe7ece417,0xef75ebbd,0xf677f30a,0xfc94f9b9,0x00e6fefa,
0x03de027e,0x0619050f,0x07da070f,0x08990863,0x0757084b,0x03ef05d0,0x001c01f9,0xfd3afe85,
0xfbdffc5f,0xfb91fb9b,0xfc6afbd4,0xfe41fd45,0x005fff49,0x030401a2,0x05cb046f,0x086d0711,
0x0bb909fa,0x10290dcc,0x159212c2,0x1b61187f,0x20dc1e23,0x26292399,0x2906281c,0x27d428ea,
0x233525e9,0x1b851fb5,0x120716de,0x08060d15,0xfe1202f6,0xf531f967,0xee7af186,0xea58ec1d,
0xe861e925,0xe752e7d4,0xe653e6d1,0xe5c7e5ee,0xe60fe5d4,0xe6bae670,0xe654e6ba,0xe4e3e5a2,
0xe3e9e451,0xe3d3e3b7,0xe5a0e46b,0xe9cfe76e,0xefb6eca1,0xf5e4f2ec,0xfabef878,0xfeadfccc,
0x0257007a,0x0646043b,0x0aac0875,0x0e660cbc,0x10320f82,0x115f10b8,0x13671244,0x160c14af,
0x18c31762,0x1c6b1a63,0x21d61ee2,0x28452516,0x2da32b33,0x30692f5f,0x30d830e8,0x2f773046,
0x2d502e75,0x2aa92c0d,0x271d290e,0x22f62507,0x1f63210f,0x1c571dd6,0x194e1ad4,0x165217cf,
0x132a14d1,0x0efc1141,0x09630c4f,0x03560674,0xfc8afff6,0xf579f90f,0xee23f1d2,0xe74cea97,
0xe16ee448,0xdc65dec3,0xd86bda46,0xd524d6b7,0xd1f4d397,0xcef6d05e,0xcc9dcdb4,0xcadfcbb2,
0xc9d1ca37,0xca29c9c4,0xcc9fcb24,0xd0d5ce90,0xd5f7d34d,0xdc45d8f1,0xe38fdfce,0xeb58e772,
0xf2c0ef18,0xf981f642,0xfecbfc61,0x025100c3,0x04be0392,0x06cb05d3,0x086507ac,0x08d608d5,
0x075e085e,0x046905ff,0x011e02be,0xfe7cffaf,0xfcd6fd8a,0xfc58fc6d,0xfd03fc8a,0xfe93fdbd,
0x0075ff75,0x02e801a3,0x0574042f,0x084606c6,0x0c2e0a17,0x11440e97,0x172f142c,0x1cd71a15,
0x224e1f85,0x27352500,0x288d2872,0x25f627a6,0x2062238f,0x18401c87,0x0eda13aa,0x050009f4,
0xfb530014,0xf2aff6c4,0xec60ef33,0xe8abea3c,0xe6e1e79d,0xe5b5e642,0xe4a0e51f,0xe41be446,
0xe463e425,0xe4dee4b2,0xe479e4c4,0xe3ade415,0xe334e35a,0xe40ce363,0xe722e54a,0xec74e98b,
0xf2e5efa2,0xf89ff5f6,0xfcf4faef,0x006efec4,0x03ce0217,0x07a2059c,0x0bae09b2,0x0eb90d65,
0x104d0fa1,0x120a110a,0x14b0134b,0x17a5162f,0x1aa0190c,0x1f061c97,0x252921ef,0x2b6d286b,
0x2ff32e03,0x319c3121,0x30e9317d,0x2f04301a,0x2c492db0,0x29332adb,0x25342747,0x2131231c,
0x1e371f90,0x1c1b1d1a,0x19ff1b1b,0x174e18be,0x13ae15af,0x0e3f1121,0x08320b40,0x01b30503,
0xfa88fe35,0xf2dcf6c9,0xeac0eec2,0xe3a7e705,0xde07e0a4,0xd9e0dbc7,0xd6bbd82d,0xd448d577,
0xd1abd308,0xcee8d046,0xcc6fcda0,0xca99cb6e,0xc980c9e8,0xca65c9a4,0xcd92cbc5,0xd229cfbc,
0xd7d1d4d5,0xde96db15,0xe63fe250,0xee0fea35,0xf535f1b9,0xfb9af885,0x0080fe4b,0x03920231,
0x05b604bb,0x0743068f,0x083607d2,0x082d085f,0x06710782,0x03ac0520,0x00a90229,0xfdfcff3b,
0xfc6dfd0c,0xfc07fc13,0xfcbffc4d,0xfdcffd47,0xff6bfe7f,0x01d4008c,0x0491032c,0x07ec061f,
0x0c5a09ff,0x11fb0f05,0x1878152a,0x1e941ba6,0x24202163,0x28a126ae,0x29612990,0x26132825,
0x1fb52345,0x16ec1b7c,0x0d781243,0x03ab0894,0xfa22fed3,0xf19ff5b1,0xeb3cee1b,0xe794e910,
0xe5ece69f,0xe482e533,0xe354e3dd,0xe2d6e2f7,0xe32fe2f1,0xe360e363,0xe2a6e31d,0xe1a5e21f,
0xe154e15b,0xe2d3e1c2,0xe70fe498,0xed8eea1a,0xf4d0f136,0xfac2f811,0xfedafcf9,0x02030085,
0x04d10361,0x0834066a,0x0bb00a08,0x0dfb0d00,0x0ff50ee2,0x12ac1131,0x16011455,0x19201799,
0x1ca31abb,0x21b01ef4,0x280c24c3,0x2e842b67,0x32b2310c,0x335d336e,0x31a532b2,0x2f21306b,
0x2c372db5,0x28cb2aa2,0x246f26ac,0x20b82264,0x1e9d1f78,0x1d421df2,0x1b7a1c70,0x18a81a43,
0x1411168f,0x0e771153,0x085e0b85,0x011104e4,0xf89cfcf3,0xef94f41b,0xe729eb39,0xe034e36e,
0xdb3add7a,0xd7cdd964,0xd55cd673,0xd32cd449,0xd0b3d1fc,0xcdf6cf59,0xcb5acc99,0xc970ca49,
0xc8d1c8e7,0xca63c94d,0xce2bcc0f,0xd32ad08c,0xd94fd614,0xe093dcd0,0xe864e480,0xefa9ec29,
0xf648f30b,0xfc0cf954,0x003dfe54,0x031201cd,0x0503041d,0x069905d5,0x07e90756,0x07e10820,
0x060b0721,0x038104d8,0x009d0208,0xfe88ff72,0xfd63fdd7,0xfd43fd36,0xfdb1fd74,0xfe85fe03,
0x0067ff53,0x031601af,0x060f048a,0x09bd07c4,0x0ea30c0b,0x14b51187,0x1b0c17ee,0x21141e10,
0x26942405,0x29322862,0x279228e8,0x22522555,0x1a9a1eaf,0x11de1656,0x08b30d4b,0xffa10423,
0xf6abfb1b,0xeeeef286,0xe9a2ebee,0xe6c9e7fb,0xe506e5df,0xe333e420,0xe1e1e267,0xe1a7e1a5,
0xe1d2e1c0,0xe193e1c7,0xe0dee13e,0xe072e094,0xe137e099,0xe43ee268,0xe9fee6cf,0xf183eda9,
0xf8b4f546,0xfe25fba9,0x01d7002d,0x04a9034d,0x078e060b,0x0ad7092f,0x0da00c61,0x0f770e97,
0x11c11075,0x150b1350,0x186916c6,0x1b7019eb,0x1f3d1d20,0x250d21f3,0x2b28282c,0x2ff22dd3,
0x31cf3154,0x30ea3197,0x2eee3000,0x2c7f2dbe,0x29cf2b3b,0x2617281d,0x220023f9,0x1f2d205a,
0x1e071e7f,0x1ce91d8e,0x1b331c1d,0x182b19f3,0x132115da,0x0d0e101f,0x069009ef,0xff2d02fe,
0xf6a2fb0c,0xed79f20c,0xe52ee91f,0xdebce1af,0xda62dc51,0xd764d8cf,0xd4fcd623,0xd2bbd3e7,
0xd035d183,0xcd8dcedc,0xcb45cc57,0xc9b8ca5d,0xc9b9c97b,0xcbc1ca7b,0xcfbbcd86,0xd507d23f,
0xdb97d829,0xe313df39,0xeac8e705,0xf18cee4d,0xf78ef49e,0xfccffa53,0x00d4fefc,0x03950253,
0x05bc04b7,0x077306a4,0x087f081a,0x07e10877,0x05a806e1,0x02cd044b,0x00040151,0xfe40feff,
0xfd9bfdcc,0xfd78fd88,0xfd55fd68,0xfdaffd59,0xff4cfe5b,0x01c00077,0x048e0316,0x084e0649,
0x0d110a8b,0x13100fe9,0x199a1661,0x1fab1cb1,0x25552299,0x28692765,0x27562861,0x22992563,
0x1b131f12,0x125616c5,0x091a0dc7,0xffc0046a,0xf6c8fb31,0xef37f2c3,0xe9fdec40,0xe742e862,
0xe560e652,0xe38fe474,0xe264e2d8,0xe23ee231,0xe272e261,0xe1e5e247,0xe0d6e164,0xe011e05e,
0xe09ae00e,0xe3b4e1ca,0xe98be650,0xf11fed40,0xf867f4ea,0xfe09fb7a,0x01b2000a,0x04810322,
0x079405fa,0x0ad3093d,0x0d5a0c3b,0x0f470e4a,0x12391096,0x15e21408,0x1933179e,0x1c3c1aa4,
0x20a21e39,0x26892378,0x2cdc29b9,0x31cc2fb1,0x334532f7,0x31fb32e1,0x2fad30d5,0x2d762e90,
0x2abd2c38,0x272f290f,0x23d2255c,0x21e222b3,0x206f212c,0x1eb21f9a,0x1c1e1d8c,0x18291a61,
0x12961582,0x0c120f70,0x0462086b,0xfb57fffc,0xf1c6f694,0xe8caed1b,0xe180e4f2,0xdc02de7a,
0xd865da0a,0xd5aad6f8,0xd33ad46d,0xd0c3d202,0xce4ccf87,0xcbf7cd19,0xca42cafe,0xc947c9b6,
0xc9bac938,0xcc58cac5,0xd0c8ce5f,0xd6a4d384,0xddd9da15,0xe603e1e2,0xeda8e9fb,0xf444f10e,
0xfa2cf74d,0xff0ffccc,0x027500ec,0x04de03bd,0x06f305f1,0x08e407f4,0x09b3098f,0x0864094c,
0x05850716,0x023c03db,0xffc600d7,0xfe74ff03,0xfda5fe07,0xfce1fd48,0xfc3ffc7f,0xfc9ffc3e,
0xfe5dfd5f,0x00a5ff7d,0x037f01ee,0x078f0564,0x0cb909fd,0x12f10fc0,0x1937161c,0x1faf1c63,
0x258722e1,0x27a72727,0x25882718,0x1ff8231d,0x18821c5e,0x104a147a,0x07450bde,0xfdf80299,
0xf55cf986,0xee7af19e,0xea4aec0b,0xe7dee902,0xe5b3e6c5,0xe3f5e4bf,0xe33ee374,0xe353e342,
0xe308e346,0xe200e297,0xe0d0e15f,0xe038e064,0xe152e076,0xe55ae2f7,0xebaee84a,0xf348ef64,
0xfa55f707,0xff7afd24,0x03340176,0x066d04d1,0x09a1080b,0x0c4a0b19,0x0df40d2f,0x10010ed0,
0x1349118b,0x16c1150d,0x19eb185b,0x1db51bad,0x22fa2023,0x2966261d,0x2f662c9d,0x326a315f,
0x31ff328c,0x2fc63100,0x2d8e2e98,0x2b692c85,0x28da2a35,0x25be2749,0x23452468,0x2177224f,
0x1fcb20af,0x1d991ec9,0x1a5d1c25,0x15d41843,0x10041310,0x09240cbb,0x0103053a,0xf81dfc9a,
0xef52f3aa,0xe77ceb42,0xe0c2e3f0,0xdbc5ddff,0xd86fd9fc,0xd5ddd71b,0xd365d4a0,0xd106d235,
0xcedbcfee,0xccfdcdd9,0xcbb1cc46,0xcb1dcb45,0xcc40cb66,0xcf52cd98,0xd3ced169,0xd9a8d689,
0xe0e0dd1f,0xe8a9e4cf,0xefb7ec4b,0xf5faf2ef,0xfb73f8dc,0xff77fda5,0x024800fb,0x04af0382,
0x071e05e3,0x09000837,0x094d0965,0x0780089c,0x04830616,0x016e02e9,0xff170026,0xfd95fe3c,
0xfcb7fd1b,0xfc15fc5e,0xfbe5fbe4,0xfcd2fc32,0xfec0fdb6,0x011cffdf,0x046c0299,0x08eb068a,
0x0e840b9d,0x14681180,0x1a4f174a,0x20d81d8a,0x25ce23c5,0x267d26be,0x2315253f,0x1c832011,
0x14c218b1,0x0c5810a9,0x038907ef,0xfaa3ff18,0xf28ff663,0xed0bef65,0xea13eb59,0xe7d9e8f1,
0xe5bbe6bb,0xe455e4e8,0xe3d6e408,0xe366e3a8,0xe25de2f9,0xe0cbe19e,0xdf7ae00b,0xdf71df38,
0xe1f1e04b,0xe754e451,0xee90eac8,0xf64df27f,0xfcb3f9bc,0x0155ff38,0x04d70321,0x0835068a,
0x0b0f09c0,0x0ce80c15,0x0ea90daf,0x11910ff9,0x155e136b,0x18dd1732,0x1c691a8e,0x211e1e8f,
0x271e2404,0x2da32a6a,0x3242305f,0x3324332e,0x310c325b,0x2e2f2f8a,0x2bfe2d0a,0x2a202b16,
0x27dc290d,0x257a26a2,0x236a2463,0x21882281,0x1f182060,0x1c1d1db5,0x181c1a43,0x12eb15a9,
0x0c950fe7,0x04cc08e5,0xfbf00069,0xf310f76f,0xeb2ceef1,0xe478e7b3,0xded7e180,0xdaaedc9a,
0xd7a7d90b,0xd51ed660,0xd281d3c9,0xd04cd156,0xceb2cf66,0xcdccce35,0xcd44cd76,0xcda7cd49,
0xcfa5ce76,0xd306d12e,0xd7a2d524,0xdda3da7b,0xe4bbe119,0xebcee85d,0xf223ef0d,0xf7d3f519,
0xfc4dfa34,0xffa7fe1c,0x0266010d,0x054103cb,0x07ec06ab,0x097708e8,0x08d5096e,0x068307d2,
0x035804fa,0x006401d0,0xfde4ff12,0xfc27fcef,0xfb3bfb97,0xfb16fb15,0xfb76fb34,0xfca7fbef,
0xfea4fd90,0x0151ffdf,0x04fb0304,0x09d80743,0x0f520c97,0x14a411fa,0x1acb1786,0x21791e45,
0x254723e8,0x24bc2589,0x204422ed,0x19881d09,0x11fb15dc,0x09c70df7,0x010b0574,0xf816fc90,
0xf07ff3f4,0xec2fedee,0xe9cceae4,0xe7c9e8c6,0xe5f3e6d2,0xe4d1e543,0xe452e489,0xe3afe414,
0xe29ae332,0xe158e1fa,0xe079e0c7,0xe148e09a,0xe497e292,0xea5ee736,0xf198ede8,0xf889f531,
0xfe01fb7a,0x02660047,0x065f0468,0x0a210854,0x0c8d0b8d,0x0dda0d3e,0x0fcd0eac,0x12e1113e,
0x162c148f,0x197217cc,0x1d871b51,0x2337202c,0x29c2267a,0x2fa02ce4,0x321a3164,0x311a31ee,
0x2e722fd6,0x2c202d26,0x2ad22b61,0x29b42a49,0x280628fc,0x25d926ec,0x23b124d4,0x20e52256,
0x1df61f7a,0x1a371c35,0x154417e7,0x0f9a1287,0x088e0c4b,0x003e0489,0xf782fbd2,0xef8ff366,
0xe8d8ec0e,0xe2ede5c3,0xde26e064,0xda6cdc27,0xd795d8f0,0xd50ad650,0xd2b9d3dd,0xd0edd1b7,
0xcfc2d044,0xcefbcf5a,0xcec9cebc,0xcff8cf26,0xd287d128,0xd5d3d407,0xda3fd7e9,0xe005dcf4,
0xe6b0e354,0xed4cea02,0xf388f083,0xf8c4f648,0xfcd0faf0,0x0006fe7e,0x03350193,0x067404e1,
0x08f007dc,0x09ab0987,0x08d20971,0x069607d3,0x03af0533,0x0088021b,0xfd70fef4,0xfb2efc23,
0xfa1bfa7f,0xfa3afa07,0xfaecfa88,0xfc59fb85,0xfe77fd5b,0x0135ffb5,0x04ee02f8,0x098f0725,
0x0e790c0b,0x139610ee,0x1a2816b2,0x20ab1da5,0x23dc22d2,0x22cb23d3,0x1e2720d1,0x17591aec,
0x0fb5139a,0x07860baa,0xfee3034e,0xf60afa64,0xef08f228,0xeb49eccd,0xe921ea23,0xe759e833,
0xe5f5e693,0xe52de57a,0xe4cbe4f8,0xe452e49c,0xe352e3df,0xe233e2c0,0xe1bce1d3,0xe315e21a,
0xe733e4cb,0xed85ea27,0xf4baf121,0xfafbf811,0xff99fd74,0x0373018e,0x0753055f,0x0ae20934,
0x0d340c39,0x0efd0e08,0x11ab1039,0x14cd1334,0x17cb164e,0x1aeb194a,0x1f1a1ccf,0x24c621cc,
0x2b1d27ee,0x301e2dfb,0x317b3144,0x2fd930f6,0x2cfb2e61,0x2b3f2bf1,0x2a682ac1,0x296c2a0c,
0x27702881,0x252e265b,0x225c23d6,0x1f2920c7,0x1b9f1d84,0x16b31959,0x10f013dd,0x0a880ddf,
0x03320700,0xfb1bff28,0xf39bf73e,0xed4df048,0xe7ddea85,0xe2f7e553,0xdeb1e0c7,0xdb2adcd0,
0xd88fd9c6,0xd676d778,0xd498d57b,0xd322d3d3,0xd22dd2a0,0xd174d1c3,0xd1abd165,0xd35bd252,
0xd5ded491,0xd8d5d742,0xdcf1dab9,0xe289df97,0xe8c2e599,0xef10ebf5,0xf4d9f20a,0xf9a7f762,
0xfd7afbab,0x00c7ff23,0x0418026c,0x071805b3,0x08c30822,0x08e10901,0x07aa086c,0x054e069c,
0x025e03e3,0xfef600b8,0xfbbefd41,0xf993fa81,0xf8e0f902,0xf970f915,0xfa49f9cd,0xfbcefaf7,
0xfe00fccd,0x0125ff77,0x0532030a,0x09d80788,0x0e1d0c06,0x134e106d,0x1a2c16b5,0x1f521d32,
0x206e2063,0x1d9f1f79,0x18411b1f,0x11e31520,0x0b000e7b,0x03b5076e,0xfba4ffc3,0xf3c5f787,
0xeeabf0be,0xec89ed6b,0xeb32ebd0,0xea44eaaf,0xe99ce9e4,0xe921e966,0xe851e8cd,0xe70fe7b8,
0xe5a0e65b,0xe432e4e0,0xe3d6e3cc,0xe5dbe480,0xea7fe7e8,0xf0e8ed90,0xf730f431,0xfc22f9dc,
0xffe4fe1c,0x039f01b3,0x07a305a7,0x0aa30952,0x0cb10baf,0x0f3f0ddc,0x129910d7,0x16161466,
0x193b17a8,0x1cee1afe,0x21c61f2e,0x27ce24ac,0x2d9f2aea,0x305e2f87,0x2f913055,0x2cf12e4d,
0x2ae02bc0,0x2a002a56,0x294629b7,0x27c8289f,0x259826c1,0x22f72454,0x2014218b,0x1d091e9d,
0x18af1b13,0x12fb15f5,0x0cb20fdd,0x05f0096b,0xfe67023c,0xf735fab2,0xf13af405,0xec7beec9,
0xe7fdea34,0xe3dae5df,0xe017e1e3,0xdd11de84,0xda96dbbc,0xd8a1d995,0xd6c6d7ae,0xd52ad5ea,
0xd41bd495,0xd395d3c0,0xd459d3cc,0xd601d51c,0xd7dfd6e8,0xda48d8f9,0xde4cdc0a,0xe3bee0e9,
0xe9b7e6b1,0xefd3eccd,0xf53ff2a0,0xf9e9f7b3,0xfdc3fbeb,0x014cff8a,0x04900302,0x071405f3,
0x082707cf,0x08070838,0x06a90783,0x04550591,0x016502f6,0xfde7ffae,0xfab7fc34,0xf8b8f987,
0xf84cf84e,0xf8e9f88d,0xf9cff954,0xfb68fa7a,0xfe13fc98,0x0185ffb8,0x05b40387,0x0a0207eb,
0x0df20bf9,0x130a103b,0x1927162a,0x1d511ba2,0x1dd31e0f,0x1ad11cb8,0x15a7185f,0x0faa12bc,
0x09390c78,0x025605e4,0xfa7cfe7f,0xf378f6ae,0xef56f108,0xed41ee28,0xebf8ec8a,0xeb30eb87,
0xeaa8eaeb,0xea31ea71,0xe962e9d1,0xe85be8e5,0xe726e7c0,0xe639e695,0xe6b4e63a,0xe949e7bd,
0xedc2eb4e,0xf34ff07e,0xf870f5fe,0xfc6dfa93,0xffa5fe11,0x0312014f,0x066904d8,0x08c607a7,
0x0b5c09f7,0x0efb0d0c,0x13141108,0x16d71505,0x1a76189e,0x1e8f1c6e,0x235c20d6,0x29082627,
0x2dc12bae,0x2f522eff,0x2df82ee7,0x2bc82ccd,0x2ad02b20,0x2a8f2ab6,0x29ee2a4b,0x289b2967,
0x266a279a,0x23652509,0x1fe221aa,0x1b9a1de9,0x15dc18e3,0x0fa312bd,0x097d0c91,0x02ce0641,
0xfb9eff34,0xf4f8f81c,0xeffaf243,0xebeaedf0,0xe809e9f4,0xe430e622,0xe0a4e257,0xdd9cdf0e,
0xdb4edc56,0xd97ada65,0xd7a7d894,0xd619d6d0,0xd4fdd57f,0xd493d4ae,0xd526d4c1,0xd645d5af,
0xd7c7d6f7,0xda47d8d8,0xde8ddc2d,0xe41ce142,0xea46e71f,0xf07bed71,0xf5fdf34f,0xfac0f87a,
0xfed4fcd2,0x02a000ca,0x05d00450,0x07dd070f,0x0876084c,0x082d0872,0x06bd0793,0x049a05be,
0x01ca0348,0xfe480014,0xfadafc82,0xf873f972,0xf7b0f7e4,0xf7ebf7ba,0xf8a0f82e,0xfa8ff969,
0xfdbafc04,0x01cbffaa,0x063703ff,0x0a0f0847,0x0d700baa,0x12550fb5,0x175e14fa,0x1a491932,
0x19d11a83,0x16381848,0x114f13de,0x0be90ea1,0x0658092a,0xfffe034b,0xf8dffc73,0xf318f5a9,
0xefd8f12d,0xee21eedb,0xed3fed9d,0xecf7ed08,0xece1ecf3,0xec82ecbe,0xeba4ec24,0xea6ceb0c,
0xe95de9e0,0xe8fee902,0xea3de961,0xed4ceb95,0xf1adef5b,0xf685f429,0xfa91f8ac,0xfda0fc33,
0x0056fef4,0x033c01ce,0x05640471,0x07430646,0x0a5a0899,0x0eca0c73,0x13631127,0x17ab158d,
0x1be019bd,0x204d1e17,0x2537229f,0x2aaa27fe,0x2e132cce,0x2e392e7d,0x2c842d7e,0x2b452bb2,
0x2ae42b10,0x2a2c2a95,0x290a29b5,0x27332829,0x24ca2621,0x2190233f,0x1de91fd5,0x18d91b9c,
0x12af15cb,0x0ca50fa4,0x067d09a2,0xff8b031b,0xf854fbe4,0xf26df520,0xee22f028,0xea58ec2f,
0xe6f2e89a,0xe3a4e549,0xe09ee21b,0xddf6df34,0xdc23dcf9,0xda99db5c,0xd929d9da,0xd7efd882,
0xd73dd783,0xd749d72f,0xd7aed77f,0xd82fd7e0,0xd942d89e,0xdbdeda4e,0xe016dddc,0xe54ae293,
0xeb2fe831,0xf0f8ee1b,0xf663f3c2,0xfafcf8c4,0xff24fd19,0x02d80109,0x06120499,0x07d2071d,
0x086e083e,0x07f00856,0x06950754,0x04b605b7,0x02230383,0xfeee0098,0xfbb5fd41,0xf97afa66,
0xf8a3f8eb,0xf891f88e,0xf92af8c1,0xfb10f9e7,0xfe6dfc98,0x02bc0080,0x070e04f3,0x0a7c08e8,
0x0ddd0c0b,0x12661013,0x16301485,0x176b1732,0x156616cd,0x10fd1361,0x0bd10e73,0x067e0922,
0x013603e3,0xfb2bfe49,0xf500f7f8,0xf0a1f28c,0xee4bef40,0xed44eda4,0xed30ed22,0xede1ed78,
0xeed5ee5f,0xef50ef2e,0xeed5ef30,0xede9ee64,0xed00ed6b,0xed13ecda,0xeef5edcb,0xf22ef070,
0xf61df418,0xf9b6f803,0xfc63fb2b,0xfe85fd76,0x00e7ffa8,0x0349022d,0x04fd0433,0x070405d8,
0x0ab0089f,0x0fb10d1e,0x14d41243,0x19c71757,0x1e931c33,0x233420e5,0x282a25a1,0x2ca32aa2,
0x2e452de4,0x2d182ded,0x2b012c08,0x29c82a44,0x28b0294c,0x27562805,0x25732670,0x2390248a,
0x2124226f,0x1e321fb7,0x1a401c71,0x14981794,0x0e76117e,0x08cf0b9f,0x02ca05e2,0xfc5dff97,
0xf618f91c,0xf15cf37c,0xedd2ef88,0xea8eec29,0xe772e903,0xe45ae5e5,0xe173e2d7,0xdf20e036,
0xdd48de27,0xdbcfdc84,0xda8ddb25,0xd986da04,0xd8fcd92e,0xd8e2d8e7,0xd8b4d8d3,0xd8ecd8be,
0xda28d951,0xdd39db77,0xe18bdf42,0xe6dfe40a,0xed08e9ee,0xf313f015,0xf88bf5f0,0xfd37faf7,
0x0149ff50,0x05040335,0x07ce0696,0x09010893,0x08dc0918,0x07bb0860,0x06330703,0x04310540,
0x019702fc,0xfe5f0009,0xfb22fcb3,0xf8c9f9d1,0xf796f809,0xf787f76d,0xf85ef7cb,0xfad2f95b,
0xff04fcbd,0x03db0170,0x08250626,0x0b5209d2,0x0eb20cea,0x11f71076,0x13911302,0x130b139b,
0x0fe711ca,0x0b350da0,0x064708bd,0x01b203e9,0xfd3dff88,0xf853face,0xf403f606,0xf0def250,
0xeebfefa9,0xedcaee25,0xee02edbb,0xef30ee87,0xf086efdc,0xf141f0fe,0xf114f147,0xf0cdf0ec,
0xf0c6f0b9,0xf1e3f11e,0xf476f301,0xf7c4f616,0xfadff966,0xfd1bfc22,0xfea0fdf1,0x0005ff4a,
0x01a100d2,0x02e10251,0x03ee0358,0x064f04dc,0x0a86083e,0x0fab0d09,0x15221261,0x1a8817db,
0x1fca1d2a,0x25152270,0x2a2127b5,0x2d0f2c01,0x2ccc2d45,0x2ae82bf2,0x294129fc,0x27f2289f,
0x264e2728,0x243c2557,0x220e231c,0x202c211d,0x1de71f15,0x1acc1c88,0x15be1883,0x0fc212b4,
0x0a4f0cff,0x050007ae,0xff6e0240,0xf9b6fc90,0xf4bcf70d,0xf0f9f2c1,0xedd1ef59,0xeb00ec5b,
0xe864e9ac,0xe5e2e725,0xe37ee4a3,0xe17de275,0xdfdae0a2,0xde98df2c,0xdd96de17,0xdca5dd14,
0xdc1bdc5b,0xdb78dbd8,0xda87dafc,0xda4dda46,0xdba7dabc,0xde6fdce5,0xe276e046,0xe7d1e504,
0xee01eada,0xf43ff12c,0xf9b3f719,0xfe3ffc13,0x023e004d,0x05c70417,0x0832072a,0x090108d2,
0x083c08c5,0x06b90781,0x050805e8,0x02f50413,0x002c01a9,0xfcc8fe85,0xf99afb19,0xf720f841,
0xf5edf657,0xf621f5e3,0xf763f69b,0xfa70f89e,0xff49fcba,0x048101e6,0x091806f6,0x0c910ae6,
0x10050e4a,0x121a1160,0x11e8123e,0x0fd11124,0x0b320dcc,0x05c10867,0x00f9034a,0xfcaffec5,
0xf8e2fac0,0xf547f709,0xf288f3c5,0xf0a2f180,0xef4eefde,0xef11ef0a,0xefe3ef58,0xf19ff0b0,
0xf356f28e,0xf40df3d5,0xf415f417,0xf474f434,0xf598f4e7,0xf7c2f68f,0xfad5f933,0xfde5fc6c,
0x0031ff2e,0x016200e9,0x01cf01a9,0x01db01e2,0x017901b2,0x01670153,0x025601bc,0x04dd035f,
0x08da06b7,0x0e0e0b47,0x143b1114,0x1a551755,0x20661d58,0x2686237f,0x2b71294b,0x2d222cc5,
0x2be12cbc,0x29aa2ad4,0x2774288f,0x253a265d,0x22f12416,0x207f21b5,0x1e731f5e,0x1cdb1da9,
0x1abf1bef,0x16d2190e,0x113b1423,0x0bd20e6b,0x06fe0961,0x01d8047e,0xfc46ff0f,0xf745f9a0,
0xf36ef539,0xf07ff1e1,0xee29ef4a,0xebeaed05,0xe9e3eae8,0xe7a0e8c3,0xe588e684,0xe3cce49c,
0xe277e310,0xe1c0e20b,0xe146e181,0xe0bce106,0xe005e070,0xdecadf75,0xdd69de0c,0xdcecdcfe,
0xddd2dd3c,0xdfd8dea8,0xe379e171,0xe875e5d7,0xee7eeb5f,0xf48ff199,0xf9caf744,0xfe83fc39,
0x02ca00b4,0x065f04b4,0x08c907c2,0x095b0952,0x085d08fc,0x06be0795,0x04db05da,0x024a03b1,
0xfef700b1,0xfb87fd33,0xf89afa01,0xf65df75f,0xf577f5b6,0xf5f1f595,0xf76cf680,0xfac3f8d9,
0xff9dfd12,0x04cb024d,0x08b106e9,0x0c190a59,0x0ef60dbb,0x0f910f93,0x0e700f27,0x0b8b0d4a,
0x06c90947,0x01d4043d,0xfdaaffa7,0xfa17fbd4,0xf6cff864,0xf407f556,0xf208f2f4,0xf063f12c,
0xef59efc2,0xef67ef36,0xf097efe0,0xf29af18d,0xf46bf39c,0xf549f4f1,0xf5e4f58f,0xf70ef65e,
0xf943f807,0xfc17faa6,0xff1efd99,0x01cf0090,0x036002bd,0x03d903ba,0x03a203cf,0x02f5035a,
0x01dc026d,0x01a3018d,0x03090223,0x060d0465,0x0a0907eb,0x0f2f0c79,0x15111214,0x1b031811,
0x21191dfe,0x2734243d,0x2b8829bf,0x2cbf2c84,0x2bbf2c6e,0x29982ac1,0x27022860,0x23d42579,
0x207d2227,0x1d741eda,0x1b221c42,0x193c1a29,0x16cf1833,0x123814cb,0x0cb70f66,0x07fe0a47,
0x036005b2,0xfe3f00e2,0xf928fba3,0xf524f6f7,0xf227f38e,0xefe7f0ed,0xee19ef00,0xec69ed38,
0xeaa7eb95,0xe8b0e9b1,0xe6d9e7b5,0xe577e619,0xe491e4f7,0xe424e44b,0xe3d5e404,0xe342e38c,
0xe256e2e1,0xe0e7e1ad,0xdf71e017,0xdf02df1a,0xdf8bdf27,0xe136e032,0xe489e2a7,0xe98ce6dd,
0xefbeec8a,0xf5d0f2e1,0xfb49f8a3,0x002efdc7,0x048c027a,0x07bd0650,0x097508d5,0x09490992,
0x080208bc,0x064f0733,0x043e055c,0x015102e8,0xfdd5ff90,0xfa81fc24,0xf78cf8f6,0xf585f65e,
0xf505f510,0xf5c4f541,0xf78cf682,0xfabaf8f5,0xff4afce4,0x03ea01bb,0x075105ba,0x0a7d08e4,
0x0cd50bed,0x0d030d28,0x0bb80c95,0x08070a34,0x02ab056d,0xfda4000c,0xf9a5fb82,0xf675f7f9,
0xf3d8f51d,0xf1c1f2ac,0xf0a1f117,0xeff8f044,0xeff7efdb,0xf11cf05d,0xf365f21f,0xf637f4d0,
0xf863f772,0xf998f90d,0xfaccfa23,0xfcb9fba6,0xff57fdfc,0x01ff00b4,0x047f0353,0x06640584,
0x073406f8,0x06c60720,0x04fa060b,0x0229039f,0x003200f1,0x003ffffe,0x01ea00e6,0x04a6032a,
0x08be067a,0x0e750b7b,0x145f1179,0x1a5f174f,0x20c01d8b,0x26be23da,0x2ad32924,0x2c3e2bcb,
0x2ba72c39,0x29202a8c,0x257d276c,0x217e2372,0x1dd81faa,0x1a941c18,0x1830193f,0x164c1758,
0x12d114cb,0x0e0c1083,0x09930bb9,0x05650784,0x00e0032f,0xfbf2fe74,0xf79bf99a,0xf492f5f6,
0xf26ef365,0xf0dff19d,0xef77f029,0xee16eed1,0xec56ed3a,0xeab1eb83,0xe908e9da,0xe79ce843,
0xe6bbe718,0xe66be682,0xe613e655,0xe515e5a3,0xe3bbe471,0xe21fe2ee,0xe0e6e16e,0xe060e088,
0xe0d0e077,0xe24fe170,0xe52ee38a,0xe9cfe746,0xefb2ecad,0xf5c6f2bf,0xfb9bf8c3,0x00b7fe40,
0x050902fe,0x081a06c0,0x097c0905,0x097c099b,0x08760914,0x06bd07b3,0x042f0592,0x00ef029d,
0xfd8fff3b,0xfa49fbe7,0xf747f8b6,0xf562f621,0xf527f516,0xf61ef582,0xf7e8f6ed,0xfa9ef91e,
0xfe79fc7c,0x02280068,0x04ed03a4,0x07720628,0x098108a9,0x09ba09d3,0x080d092c,0x040b065c,
0xfe700141,0xf9a3fbeb,0xf60ff7ac,0xf392f4b9,0xf190f28d,0xefe9f0a1,0xef84ef8c,0xefc5efa4,
0xf07feffd,0xf284f156,0xf5daf40e,0xf991f7bf,0xfc5dfb25,0xfe33fd55,0x0038ff1b,0x02910163,
0x053303d7,0x07bf068a,0x09e608dd,0x0b710aca,0x0b880bb3,0x09990ada,0x05c107d4,0x01d603a0,
0x004300b9,0x00c40052,0x02480176,0x04ea0363,0x092f06d9,0x0e800bd0,0x13e4112b,0x19b516c3,
0x1f791c9d,0x252b225c,0x29c227b3,0x2bf32b36,0x2b442bf6,0x27cb29ce,0x22f52575,0x1e072070,
0x19c41bc9,0x164017de,0x13d414f3,0x1106128c,0x0d4e0f43,0x097f0b5c,0x05cb079d,0x020803fc,
0xfdb7ffec,0xf979fb8b,0xf622f7a9,0xf3ecf4e0,0xf300f355,0xf27cf2bb,0xf1dff239,0xf09df152,
0xef10efda,0xed84ee4a,0xec0cecc0,0xeaddeb6b,0xea43ea74,0xea25ea31,0xe97de9f5,0xe7f3e8c4,
0xe634e710,0xe484e560,0xe2d3e3a3,0xe1c9e22c,0xe1d7e1af,0xe2d6e237,0xe540e3d5,0xe962e722,
0xeed9ebf9,0xf4fdf1e7,0xfae2f7fd,0x000dfd95,0x044b0255,0x072105e2,0x088007fd,0x08a408ad,
0x07f60869,0x066e0749,0x040d0557,0x013d02b0,0xfe1effb4,0xfacefc7c,0xf7baf92b,0xf5ebf6a0,
0xf5caf5a5,0xf709f64e,0xf8d3f7dd,0xfb3cf9f3,0xfe4dfcba,0x0146ffdb,0x037e0270,0x05bf0491,
0x07b806e4,0x07e10815,0x05a00709,0x016703ba,0xfbfcfebd,0xf72bf969,0xf3c9f549,0xf152f284,
0xef28f02f,0xedb6ee4a,0xedaced8b,0xee44edf5,0xef86eeba,0xf28bf0c9,0xf70bf4ac,0xfbe0f982,
0xffb9fdfb,0x02850135,0x04f903c2,0x0763062e,0x09eb08a3,0x0c370b22,0x0e380d3a,0x0fa60f18,
0x0eef0f9c,0x0ba40da3,0x065e0915,0x023903f3,0x00de0139,0x01760101,0x02f0021a,0x059b041b,
0x09a4077a,0x0e540bed,0x138810e6,0x18b11624,0x1dff1b3f,0x23e120ec,0x297626ce,0x2c5e2b6e,
0x2b232c3e,0x267c291d,0x20b423a4,0x1b141dcf,0x161e1889,0x120813e6,0x0e911050,0x0b1e0cd8,
0x07f00973,0x05210687,0x022c03b2,0xfed80090,0xfb2efcfa,0xf7f1f981,0xf54cf683,0xf3f9f465,
0xf3eef3db,0xf446f41d,0xf41ef44f,0xf309f3aa,0xf17af249,0xeff3f0ab,0xeeb5ef4f,0xed95ee1c,
0xed00ed3b,0xec96ecd4,0xeb6fec22,0xe995ea8e,0xe7d7e8a4,0xe63fe715,0xe47ee55d,0xe333e3c2,
0xe2b8e2d7,0xe333e2d2,0xe513e3ec,0xe8afe6ad,0xee0deb2a,0xf446f122,0xfa78f76f,0xffd8fd4c,
0x03f80212,0x06c6057f,0x088407cf,0x092508f4,0x08a80908,0x071e0801,0x04db0610,0x01fb0386,
0xfe6a0041,0xfaa4fc7e,0xf781f8ee,0xf5b0f667,0xf5c9f57a,0xf75ef676,0xf988f866,0xfc04fab8,
0xfeeafd72,0x01740053,0x02ec0247,0x04e803c1,0x06c8060e,0x063306d8,0x032f04f1,0xfe6c0101,
0xf8f4fba7,0xf42af66d,0xf0c4f247,0xedfbef5f,0xeb95ecb0,0xea6feacc,0xeadbea7d,0xec13eb69,
0xee70ed08,0xf2c5f05a,0xf88cf58b,0xfe77fb94,0x0341010a,0x06cb0528,0x0981083b,0x0bc10a9e,
0x0e190ced,0x10750f45,0x12b611a2,0x13d6138c,0x11cb1348,0x0c9b0f7d,0x06ed0996,0x038704e3,
0x029f02d4,0x02fd02b8,0x046c0388,0x074505b0,0x0ae20902,0x0f1c0ce5,0x13c8117a,0x182815f7,
0x1d2e1a83,0x23a72043,0x296f26e0,0x2b852afe,0x297b2b04,0x24872731,0x1e8e21a9,0x18651b68,
0x131015a0,0x0e3310a5,0x09890bc9,0x05c7077d,0x03510479,0x00e20229,0xfdfaff6f,0xfaf0fc7e,
0xf826f976,0xf5d3f6f5,0xf430f4dd,0xf426f3ff,0xf502f483,0xf5aff56c,0xf572f5ac,0xf478f50a,
0xf30df3c5,0xf1ddf26c,0xf0caf154,0xefe5f04a,0xef5eef9b,0xee97ef13,0xecefede2,0xeb0aebee,
0xe998ea45,0xe804e8d9,0xe64de71d,0xe517e5a0,0xe49ce4c5,0xe4c1e495,0xe636e546,0xe97de792,
0xeebdebf2,0xf4b0f1b4,0xfa8bf7a4,0xffa0fd38,0x039201bf,0x0678051c,0x0872079b,0x090d08f1,
0x088608eb,0x072707e7,0x05320644,0x023c03d3,0xfe7e006d,0xfacdfc90,0xf809f948,0xf6c4f728,
0xf778f6e3,0xf97bf860,0xfbdcfab3,0xfe0dfcf7,0x0014ff21,0x011100b6,0x01c00157,0x02fe025f,
0x02e80345,0x005d01e4,0xfc5bfe79,0xf7d3fa1b,0xf39af5a4,0xf037f1c5,0xed85eecf,0xeb14ec49,
0xe955ea0b,0xe908e900,0xe9cee959,0xeb2bea59,0xee44ec71,0xf377f0a3,0xf9fbf6a4,0x0075fd4b,
0x06090367,0x0a580856,0x0db20c1c,0x10830f24,0x134911df,0x160914b4,0x18121731,0x17d61864,
0x13bb1641,0x0d9410b0,0x08820ac4,0x05da06e3,0x0512054b,0x05a70528,0x07b50687,0x0a63090e,
0x0d620bc9,0x110b0f34,0x147f12c9,0x183c163d,0x1d701a9f,0x238c2088,0x27a72603,0x28102854,
0x251426e7,0x205e22e6,0x1a791d7b,0x14691767,0x0ec91198,0x08d40bce,0x03c70616,0x00bc020d,
0xfea8ffaf,0xfc23fd77,0xf947fab9,0xf6c0f7eb,0xf4d2f5bc,0xf375f406,0xf36ef340,0xf4d9f3ff,
0xf699f5c9,0xf778f72c,0xf762f78d,0xf674f6fd,0xf55ef5df,0xf492f4f3,0xf3aef421,0xf2bbf336,
0xf1b3f241,0xf070f11d,0xeeeaefa8,0xeda4ee3e,0xec72ed11,0xeae3ebb6,0xe943ea11,0xe7e3e887,
0xe6f2e75b,0xe670e69b,0xe74be694,0xea9ae8aa,0xefa4ecfd,0xf545f26d,0xfad4f813,0xffc7fd69,
0x03db01ea,0x07110591,0x09370855,0x09d209b4,0x094709a3,0x082308c8,0x062a0745,0x030d04c6,
0xff080118,0xfb3efd0f,0xf863f9a7,0xf700f779,0xf76ef6fd,0xf947f847,0xfb22fa43,0xfccffbee,
0xfe73fdb6,0xff36feef,0xffe2ff76,0x00fa0080,0x001d00e9,0xfccbfead,0xf835fa97,0xf363f5ba,
0xef88f157,0xec4bedde,0xe971ead0,0xe72be837,0xe5cae652,0xe5d2e59c,0xe72ce663,0xe986e833,
0xed9beb4d,0xf3c7f06c,0xfb73f77d,0x0346ff78,0x099b06ab,0x0e290c10,0x118a1004,0x143712de,
0x174a15ac,0x1aa01900,0x1cd71bfb,0x1b971cc9,0x16a6196d,0x10d313a9,0x0c680e5d,0x0a0d0afe,
0x093d0972,0x09fd0974,0x0b9d0abd,0x0d550c72,0x0f910e67,0x11d910be,0x140a12e2,0x179c158c,
0x1d941a58,0x23c720e3,0x26b725c8,0x25882693,0x21a323d3,0x1c6d1f1b,0x16861993,0x10901390,
0x097e0d2e,0x027a05da,0xfdbfffb7,0xfb47fc58,0xf957fa5b,0xf6c2f823,0xf461f570,0xf2f3f39e,
0xf1d9f25d,0xf168f174,0xf267f1ae,0xf4e6f38f,0xf73bf62d,0xf865f802,0xf85af87b,0xf7abf80c,
0xf71ff75e,0xf6bbf6ec,0xf618f67b,0xf4edf58f,0xf37ff434,0xf232f2d2,0xf127f19d,0xf04ef0bd,
0xef66efe2,0xee0ceec7,0xec58ed34,0xeae7eb92,0xe9aeea49,0xe8b8e91a,0xe964e8c5,0xec57ea9a,
0xf0ecee7f,0xf619f37a,0xfb0df8a2,0xffb9fd6a,0x03ce01dd,0x073405a0,0x093d086c,0x09df09b6,
0x098509c8,0x08730919,0x062c077b,0x02c00495,0xfede00ca,0xfb3cfcfd,0xf85ef9ae,0xf6f3f771,
0xf76df6f9,0xf8fdf82b,0xfa4ff9b4,0xfb5afadb,0xfc25fbd1,0xfc92fc64,0xfd47fcd5,0xfdfffdc7,
0xfc71fd8f,0xf902fae7,0xf494f6dd,0xf028f249,0xec8fee45,0xe963eae1,0xe6dae80b,0xe4cfe5c7,
0xe39be40e,0xe41be39f,0xe618e4fa,0xe92ae775,0xee04eb4b,0xf558f15e,0xfe62f9c2,0x074102fb,
0x0e390b07,0x12e610d7,0x15c81478,0x188f171a,0x1c0a1a3b,0x1f371dc8,0x20352015,0x1de81f73,
0x19431bc6,0x13f4169a,0x0f9d1196,0x0d3b0e20,0x0cd40cd6,0x0d720d13,0x0e5d0ddc,0x0fb10f04,
0x10d1104b,0x1194113f,0x12b711f7,0x16661425,0x1c711950,0x21b01f5c,0x23ac2330,0x22272345,
0x1e0b205d,0x19181b9d,0x1332164a,0x0bd00fbe,0x039707a5,0xfccdffe4,0xf89bfa69,0xf635f74d,
0xf3f6f51d,0xf1d8f2cb,0xf0ecf140,0xf083f0a3,0xf08ff07f,0xf171f0d9,0xf3bdf26d,0xf6a4f52f,
0xf924f804,0xfa3ff9da,0xfa58fa59,0xfa4ffa55,0xfa55fa4f,0xfa39fa5a,0xf8f4f9c1,0xf6e6f7f5,
0xf4dbf5d8,0xf38ff41a,0xf2a7f319,0xf205f24a,0xf132f1b4,0xef81f070,0xeda0ee88,0xebf5ecc5,
0xea77eb2e,0xe990e9df,0xea52e9b7,0xed04eb6c,0xf10beef4,0xf56ff337,0xf9fcf7b4,0xfe9ffc46,
0x033200f8,0x06b5051f,0x08f007fc,0x0a0b099d,0x0a2f0a43,0x090f09c8,0x069e07fb,0x03370506,
0xff6e0153,0xfbd6fd98,0xf8d7fa32,0xf763f7e0,0xf789f748,0xf8a5f80d,0xf9b1f936,0xfab9fa2f,
0xfba1fb3b,0xfbfbfbd7,0xfc86fc36,0xfc77fcbc,0xf9f8fb87,0xf5b4f7fd,0xf0f4f353,0xece4eec6,
0xe9a6eb3c,0xe6e4e828,0xe4f2e5de,0xe30fe3fe,0xe1e7e24a,0xe2c4e219,0xe4f2e3c7,0xe7fae64b,
0xed1bea34,0xf4ddf0af,0xfe4af97a,0x072e02f3,0x0e240ae6,0x134e10f5,0x1700153f,0x1ad418ca,
0x1f531d19,0x22bb214d,0x238f2386,0x216f22d2,0x1d481f87,0x18761ad8,0x14cb166a,0x130613af,
0x127912aa,0x125a125c,0x1295126d,0x12a312ad,0x12611283,0x12421241,0x13791291,0x178a152e,
0x1cf21a35,0x21001f50,0x217a21b1,0x1f1120a2,0x1a5f1cdd,0x14ce17b3,0x0e3f11b6,0x06120a51,
0xfd9501b1,0xf743fa1c,0xf33af4f8,0xf0cbf1e2,0xeedaefd1,0xed7cee03,0xed38ed43,0xed74ed4e,
0xee31edbd,0xefe7eee1,0xf2bcf131,0xf60af465,0xf893f779,0xf9f0f961,0xfadafa64,0xfbcffb4e,
0xfcc5fc58,0xfc9efcea,0xfafefbf0,0xf8c0f9e5,0xf6d7f7ad,0xf5f9f64f,0xf599f5c0,0xf53bf578,
0xf434f4c9,0xf2bcf384,0xf0e8f1d5,0xef21f002,0xed79ee3f,0xecd3ecf9,0xed89ed03,0xefa9ee6c,
0xf2aaf11b,0xf5fdf449,0xf9c2f7ca,0xfe1bfbe2,0x027f0061,0x06260472,0x089f0788,0x09e30968,
0x09c50a00,0x08460930,0x05a30712,0x02600411,0xfef500a8,0xfb7ffd3c,0xf87ff9d9,0xf705f78d,
0xf70ff6df,0xf7fff782,0xf89cf85c,0xf92ef8dd,0xf9f5f999,0xfa23fa1f,0xfa5bfa2e,0xfa24fa70,
0xf7d4f943,0xf411f60c,0xefb5f1ea,0xeb98ed94,0xe815e9c8,0xe553e690,0xe344e43f,0xe188e25a,
0xe0d4e0f6,0xe23ce14b,0xe4e1e373,0xe898e68b,0xee56eb23,0xf6bef244,0x0058fb8b,0x08ea04d9,
0x0f820c77,0x14441217,0x18181631,0x1c811a34,0x20bc1ec4,0x23572242,0x241223f5,0x22a123a0,
0x1f3a211f,0x1b311d2d,0x186e1989,0x177217ce,0x16c61727,0x15fd1657,0x1515159f,0x139e1462,
0x124e12e8,0x122311f9,0x140b12d4,0x17ba15b4,0x1c7a1a0f,0x1ffd1e91,0x2051209e,0x1d201f14,
0x17bd1a95,0x11a614d8,0x0a130e06,0x01cb05f8,0xfa2dfdc9,0xf42cf6f8,0xefacf1be,0xecadee01,
0xeac8eb9b,0xe9f0ea37,0xea23e9f7,0xeaf7ea78,0xec67eb8f,0xeed3ed86,0xf205f055,0xf55ef3c0,
0xf7f3f6c8,0xf9c4f8ea,0xfb8bfa9f,0xfd82fc88,0xfe9afe40,0xfe00fe86,0xfc05fd1d,0xf9bbfad7,
0xf82ff8d3,0xf75ff7b6,0xf724f735,0xf6f6f714,0xf639f6ae,0xf4eaf5a0,0xf332f417,0xf13ff236,
0xefdcf071,0xef53ef76,0xefbcef66,0xf143f05f,0xf380f259,0xf64ff4cd,0xf9f0f804,0xfe3efc1a,
0x026a005b,0x0627045a,0x092607c8,0x0aab0a20,0x0a960acf,0x09380a0f,0x06c8081f,0x03d3054d,
0x00af024e,0xfd51fefe,0xfa82fbc7,0xf8f5f990,0xf875f89a,0xf876f872,0xf862f871,0xf897f86f,
0xf8b9f8bf,0xf853f881,0xf85ff84e,0xf772f82e,0xf460f625,0xf002f245,0xeafaed85,0xe674e897,
0xe2efe491,0xe09ee1a2,0xdf2adfd2,0xde4ddea3,0xdee2de58,0xe15bdfee,0xe4c0e2f8,0xe930e6c5,
0xefdbec37,0xf87ef402,0x0189fd0e,0x095c05b5,0x0f530c8a,0x144311dd,0x192c16a2,0x1ed11bf8,
0x2395216a,0x2680253a,0x27cf2766,0x26ee27a8,0x240325a8,0x20852231,0x1e6c1f49,0x1d011db6,
0x1b2c1c23,0x19781a4e,0x17811891,0x151b164b,0x1392142d,0x13a8135c,0x158c146b,0x18e9170f,
0x1cd41aec,0x1f311e58,0x1dfe1f10,0x19671c15,0x1345165f,0x0bda0fc6,0x036c07b4,0xfb42ff33,
0xf486f7b2,0xef4ef1c1,0xeb59ed2e,0xe8a2e9d0,0xe73de7ce,0xe6f3e6ed,0xe7c5e73e,0xe921e868,
0xeb12e9fe,0xedebec5f,0xf185efb0,0xf4faf34c,0xf7baf673,0xfa17f8eb,0xfcb2fb56,0xff32fe07,
0x004b0001,0xff6c0011,0xfd84fe82,0xfbb4fc8b,0xfa81fb0d,0xf9b9fa0f,0xf981f990,0xf929f963,
0xf840f8c2,0xf6e9f7ab,0xf52cf612,0xf37ff444,0xf264f2e4,0xf1bdf204,0xf1c2f1a5,0xf29bf21a,
0xf42ef346,0xf689f543,0xf9ddf817,0xfdc1fbc4,0x01c0ffc3,0x05ad03bf,0x08ef0774,0x0aac0a06,
0x0ade0aee,0x09ff0a8c,0x08320931,0x05be070e,0x028d043e,0xfefb00be,0xfbebfd5d,0xf9b4faad,
0xf85af8fc,0xf738f7c6,0xf699f6cc,0xf68ef68d,0xf63df675,0xf5c7f5f1,0xf5e1f5ce,0xf4f2f5ad,
0xf215f3ba,0xed65eff6,0xe79bea88,0xe258e4d4,0xde82e03b,0xdc6bdd3f,0xdbb5dbf4,0xdbd6dba7,
0xdd6fdc67,0xe0c1dee7,0xe525e2db,0xead6e7c4,0xf266ee63,0xfb5af6c9,0x0410ffe0,0x0ada07b5,
0x103f0da9,0x155212c1,0x1aca17fe,0x20241d8a,0x24ba228a,0x287f26ba,0x2ae529f5,0x2ac42b29,
0x287f29c9,0x263f273e,0x249d2568,0x22b623b6,0x207221a7,0x1d751f0c,0x19e81bbb,0x16c11829,
0x155715c9,0x15571540,0x1636159e,0x18611727,0x1bab19f6,0x1d271cda,0x1afd1c87,0x15b918a4,
0x0e081225,0x057809bf,0xfd4c0141,0xf60ff9a0,0xef97f2b4,0xea37ecbf,0xe66be810,0xe467e545,
0xe35be3bb,0xe3aae34d,0xe558e463,0xe7cae683,0xea75e911,0xedc2ec08,0xf15cef8e,0xf4eaf327,
0xf840f69d,0xfb8ef9e5,0xfed3fd3d,0x0104001d,0x01540168,0x002900db,0xfebbff6a,0xfd7cfe12,
0xfcaafd02,0xfc41fc6d,0xfbb2fc04,0xfaf7fb5c,0xf9c8fa6e,0xf854f91a,0xf6e0f789,0xf5e7f657,
0xf531f589,0xf486f4da,0xf44ef453,0xf50bf487,0xf692f5ba,0xf8dbf7a0,0xfb6cfa1b,0xfe87fce4,
0x020e0047,0x05b203e6,0x08870747,0x09d8095b,0x0a350a1b,0x09aa0a13,0x083b0913,0x05fc0731,
0x03090496,0xffa2015a,0xfc87fdfd,0xfa21fb3f,0xf843f921,0xf6ccf776,0xf60cf651,0xf5d4f5f0,
0xf52df58f,0xf4fbf4eb,0xf56df544,0xf43cf520,0xf0c9f2cc,0xeb06ee27,0xe43fe7a3,0xde5fe125,
0xda0adbf1,0xd7f4d8b3,0xd7d2d7b3,0xd910d844,0xdc01da50,0xe069de18,0xe596e2e0,0xec14e8a3,
0xf3ffefe4,0xfc8df844,0x0451009f,0x0a35077d,0x0f210cb2,0x14201193,0x199f16da,0x1f411c6b,
0x25152225,0x2a5e27e0,0x2dc62c5e,0x2e962e7d,0x2dc62e49,0x2cbf2d46,0x2b422c17,0x29312a4e,
0x25ff27c3,0x21dd2400,0x1d6d1f9e,0x1a121b88,0x188f1928,0x17be1814,0x182017b2,0x1a3018f1,
0x1cd71bb3,0x1ca01d2d,0x18c51b23,0x11a71596,0x089d0d3d,0xff6903eb,0xf773fb48,0xf044f3c2,
0xe9f5ecf7,0xe52ae75d,0xe246e37f,0xe0a5e154,0xe038e03b,0xe152e09e,0xe36be23e,0xe5c3e4a0,
0xe862e6f9,0xebabe9f0,0xef80ed8c,0xf38ef189,0xf789f58d,0xfb90f98b,0xff0ffd75,0x00fe0043,
0x012f014c,0x006700d0,0xffb10006,0xff2bff63,0xfef8ff0d,0xfea6fed7,0xfe29fe6e,0xfd35fdc4,
0xfbcafc7d,0xfa81fb24,0xf9b3fa04,0xf919f962,0xf866f8ce,0xf765f7e9,0xf6b9f6f1,0xf705f6bf,
0xf827f77b,0xf9dff8fc,0xfc18fae2,0xff19fd85,0x029300cd,0x05df0445,0x085f0743,0x09d00933,
0x0a8b0a4b,0x0a2a0a7c,0x08e009a0,0x06c607f0,0x03db0565,0x00770229,0xfd50fed1,0xfab1fbf2,
0xf8a9f998,0xf719f7d6,0xf5f5f675,0xf4eff577,0xf3e3f45b,0xf3e9f3bc,0xf436f436,0xf24df39a,
0xeda1f04b,0xe6c0ea66,0xdf7de306,0xd973dc4c,0xd577d725,0xd44fd48b,0xd541d498,0xd7c4d644,
0xdc29d9c1,0xe198decc,0xe7dbe496,0xef1beb5e,0xf707f30d,0xfe8dfae7,0x04a001d6,0x092306fb,
0x0d640b41,0x11d20f8d,0x172f1451,0x1e2f1a84,0x259c21f4,0x2c08290a,0x304b2e76,0x3254318a,
0x32d132b9,0x3244329e,0x311a31cb,0x2e943012,0x2a6e2ca5,0x257f2804,0x2114231e,0x1e371f7e,
0x1bec1d0f,0x1a521af9,0x1a461a09,0x1c451b23,0x1d951d2e,0x1b7a1d10,0x154918eb,0x0be310c1,
0x022f0700,0xf965fda1,0xf16cf55a,0xe9d4ed88,0xe3c1e687,0xdfe1e188,0xddb6de9b,0xdceadd2e,
0xdd7bdcfb,0xdfa8de6a,0xe250e0fd,0xe4f3e3a0,0xe7bfe64c,0xeb35e960,0xef7ded42,0xf444f1d9,
0xf916f6b4,0xfd31fb48,0xffebfebe,0x011700b0,0x00f7011d,0x007200ba,0x00070032,0xfff5fffb,
0xffd7ffea,0xff97ffb7,0xff25ff72,0xfe19feae,0xfce8fd77,0xfc69fc8b,0xfc6ffc63,0xfc59fc74,
0xfb92fc0f,0xfa6dfafe,0xf9bff9fb,0xf9fdf9c0,0xfae7fa6b,0xfc23fb73,0xfe39fd13,0x00d5ff79,
0x03840233,0x05e004bf,0x07bc06e6,0x092f087a,0x0a2609c5,0x09fb0a37,0x08e8098c,0x07100817,
0x043905c2,0x00ca0286,0xfd57ff09,0xfa72fbce,0xf869f956,0xf70df7a6,0xf616f694,0xf4bbf573,
0xf3d3f419,0xf45ef402,0xf3bef45e,0xf031f263,0xe9d8ed4f,0xe1e5e5ee,0xda4bddf8,0xd40dd6e9,
0xd088d1e5,0xcff3cfee,0xd17cd075,0xd581d329,0xdb8ed861,0xe22dded1,0xe91ae599,0xf0a4ecc4,
0xf883f49c,0xff75fc2f,0x04830234,0x086c068d,0x0c0a0a3e,0x10160de1,0x167012eb,0x1ebd1a6f,
0x271f2302,0x2e3b2ae3,0x337a3117,0x36f53575,0x38aa3805,0x38f938f5,0x378e3886,0x33ec3600,
0x2ef8317f,0x2a482c8b,0x267e2840,0x232224d6,0x1fcf2163,0x1d831e75,0x1d6d1d2c,0x1e421de1,
0x1d511e3c,0x18921b6c,0x0feb14a6,0x05e50af0,0xfc4500f6,0xf366f7c1,0xeaa4ef00,0xe304e691,
0xddaae002,0xdaa6dbee,0xd952d9cf,0xd95ed920,0xdb31da13,0xddf3dc8f,0xe09cdf4b,0xe305e1d9,
0xe5e5e452,0xea05e7d2,0xeeecec64,0xf432f18c,0xf910f6bf,0xfcd4fb22,0xff1afe25,0x002bffb9,
0x0090006a,0x00d000ae,0x013d0108,0x01960168,0x01e101c0,0x020401fa,0x01a101e9,0x0066011d,
0xff5cffc4,0xff1bff24,0xff40ff2d,0xff0fff3a,0xfe6afec7,0xfda5fe02,0xfd47fd65,0xfd7efd53,
0xfe1cfdbd,0xff83feb0,0x01ab0087,0x03eb02d5,0x05c604e6,0x0731068e,0x085907bb,0x09a908fe,
0x0a750a32,0x0a3b0a75,0x093509ce,0x07600868,0x04950617,0x011a02ea,0xfd60ff38,0xfa09fba8,
0xf6def870,0xf407f55a,0xf207f2ee,0xf05cf130,0xef7defb4,0xf095efe7,0xf07df0ec,0xed70ef45,
0xe7f8eb03,0xe04ce44e,0xd87bdc48,0xd235d50e,0xceffd027,0xceaace8e,0xd066cf3c,0xd4d7d23e,
0xdb72d802,0xe299df01,0xea22e64b,0xf21eee1f,0xf9d7f605,0x0072fd5f,0x05080302,0x083906bb,
0x0ab0097f,0x0e080c0c,0x146010d8,0x1cc91867,0x26072167,0x2ec42a8c,0x35e93291,0x3aab38a5,
0x3d1c3c1f,0x3dcc3db8,0x3bfe3d39,0x37f13a35,0x32e7356a,0x2ea230a9,0x2abe2caa,0x26a628ba,
0x227c2490,0x1f7820ad,0x1ea51ed7,0x1ee81ecd,0x1cd11e54,0x165f1a2e,0x0c9211ba,0x02100738,
0xf89afd44,0xefa8f417,0xe70ceb4e,0xdface310,0xdab7dce9,0xd7c3d8fb,0xd6afd702,0xd74ad6ca,
0xd9bad84b,0xdcefdb56,0xdfafde6b,0xe1c6e0c0,0xe47ee2f9,0xe8aae669,0xede9eb37,0xf350f0a8,
0xf7ccf5b9,0xfaf5f984,0xfd07fc1b,0xfea4fde0,0xffacff3c,0x006b0011,0x00f300ae,0x01480125,
0x01820163,0x01c801a4,0x01e701e7,0x017e01b8,0x0180016b,0x020101b3,0x02710249,0x0243026d,
0x01a201fb,0x00f30149,0x00ad00be,0x009f009d,0x013700cc,0x02b901e0,0x04ae03b4,0x065c0593,
0x075f06f5,0x07f007aa,0x08b2083f,0x09e90955,0x0a530a3e,0x09ec0a30,0x08f80986,0x072b0832,
0x045c05e5,0x00b10291,0xfd03fed6,0xf92efb25,0xf53cf734,0xf1d1f369,0xef3bf06f,0xed28ee18,
0xec75ec92,0xed2feccb,0xecb4ed39,0xea09eba9,0xe500e7d0,0xddc0e196,0xd63fd9db,0xd0a7d319,
0xce3acf0f,0xce6ece0a,0xd110cf73,0xd657d360,0xdd61d9c2,0xe4c6e107,0xec86e89f,0xf451f06e,
0xfbc4f823,0x01f5ff15,0x05c90436,0x076306c5,0x08e70801,0x0cbf0a6d,0x135d0fbc,0x1bd31765,
0x25d620a7,0x303f2b27,0x38ce34df,0x3e453be8,0x41123ff8,0x41394181,0x3ecb4041,0x3ac63ce8,
0x3677389a,0x321f3453,0x2d962fdf,0x29082b50,0x247726af,0x2133229f,0x1f9c2027,0x1eaf1f49,
0x1b371d75,0x13a817ce,0x09960ee3,0xfedc042c,0xf45bf98d,0xea79ef47,0xe1d4e603,0xdb20de2c,
0xd6c6d8af,0xd47bd562,0xd43cd416,0xd5c5d4c6,0xd8e6d72f,0xdc92dac9,0xdf5fde1d,0xe18ae070,
0xe458e2cb,0xe896e647,0xedf7eb35,0xf327f0a7,0xf731f55d,0xf9eff8af,0xfc1efb0b,0xfe0ffd24,
0xffa7fede,0x00ed0061,0x018f0149,0x01e901c4,0x01f501f6,0x02580215,0x02b2028e,0x02db02c8,
0x031102ec,0x03c0035e,0x0434040f,0x042c043b,0x03e6040d,0x038503ba,0x02fd034d,0x02b902ba,
0x03750301,0x04ad0404,0x05f00554,0x06e00678,0x0731071e,0x07400731,0x07dc0777,0x08e4085f,
0x09750948,0x0941096e,0x08a208fb,0x0768081f,0x051e0665,0x025303be,0xff0400cb,0xfab7fcf4,
0xf689f87f,0xf392f4e6,0xf166f271,0xefc8f073,0xef9fef8a,0xef69efb7,0xecddee72,0xe813eab8,
0xe0bbe4b8,0xd839dc78,0xd085d424,0xcb91cda3,0xc968ca31,0xc9a6c92d,0xcd0acaed,0xd346cfe3,
0xda6ad6cf,0xe218de27,0xeab4e654,0xf347ef10,0xfaf6f748,0x0048fe05,0x028601b8,0x03a70311,
0x060c048d,0x0b650853,0x13400f17,0x1cf917db,0x2851228b,0x33402dfb,0x3bf637e4,0x42833f85,
0x465044c9,0x46f94707,0x45014640,0x41ac4366,0x3df73fe8,0x39643bbf,0x347936f2,0x2f4731ee,
0x2a672caf,0x26d52871,0x247425a2,0x20a022e1,0x19781d78,0x0fbb14de,0x048d0a2f,0xf938fee9,
0xedf8f394,0xe3aae8a1,0xdb22df22,0xd4dcd7af,0xd0f1d29a,0xcf1ccfc7,0xcf44cef9,0xd18bd01d,
0xd5a6d37f,0xd998d7bf,0xdca2db31,0xdf9cde0d,0xe3aae179,0xe8d0e625,0xee02eb7f,0xf24df041,
0xf5b0f417,0xf879f71c,0xfb34f9de,0xfd91fc6e,0xffc1feb4,0x015400a2,0x026501e9,0x02bb02a9,
0x02de02bd,0x03710325,0x042003bf,0x04eb0483,0x05fc0568,0x070c0696,0x075d0748,0x07440756,
0x0722073a,0x06bd06fa,0x05f30659,0x05ce05bd,0x068a0618,0x077c0708,0x083907e1,0x089a0879,
0x08500887,0x08150823,0x087a0837,0x090508c1,0x09490932,0x09040932,0x083208b7,0x069f0785,
0x045b058b,0x019c0310,0xfde0ffe2,0xf95cfba6,0xf52af729,0xf240f37e,0xf09df156,0xef68eff6,
0xeefcef19,0xee16eec3,0xeb0becd8,0xe5a8e8ab,0xdd8ae1e2,0xd49dd8fd,0xcd3cd09f,0xc8c3ca95,
0xc765c7b7,0xc8e9c7cc,0xcd3bcab6,0xd3a1d049,0xda7fd70b,0xe21fde23,0xeab0e656,0xf35fef0d,
0xfac5f763,0xfed5fd46,0x0030ffaa,0x01ac00c8,0x051f0314,0x0b0607c5,0x13710ee8,0x1e8918b4,
0x2ac524af,0x35cc3086,0x3ea93a8a,0x44e54219,0x485646fa,0x49374907,0x487648fe,0x468f47ac,
0x430044ff,0x3e3540ad,0x39043baf,0x339e3648,0x2eca3125,0x2af22cc0,0x26c42904,0x2096240e,
0x17b41c6b,0x0c931266,0x0034066e,0xf3dcf9fc,0xe873edf3,0xdebbe367,0xd6bcda74,0xd0f7d38f,
0xcd2bced6,0xcb66cc08,0xcb74cb2a,0xce1ecc70,0xd284d03e,0xd6d0d4bd,0xda9fd8c6,0xde85dc7b,
0xe369e0d5,0xe8cee61c,0xed91eb49,0xf185efa4,0xf4e2f340,0xf80ff681,0xfaebf986,0xfd90fc4a,
0xff8dfe9e,0x0152006f,0x02ae0220,0x033c0308,0x03aa0369,0x04950407,0x05e0053f,0x074a0686,
0x08da0816,0x0a19098d,0x0aab0a78,0x0abd0ac2,0x0a540a95,0x098209f4,0x08cb0913,0x08b508b2,
0x08f308d2,0x093e0916,0x0976095f,0x0940096e,0x088308f2,0x07b3080d,0x07760784,0x0753076d,
0x07130736,0x06c606f4,0x0622067e,0x050b059d,0x03b6046e,0x019c02d6,0xfe06fffe,0xf9b0fbd9,
0xf613f7b4,0xf409f4e0,0xf2b4f359,0xf1bbf21d,0xf112f183,0xee83f018,0xe98bec54,0xe22fe628,
0xd919ddc0,0xd05bd48e,0xc9d5ccb3,0xc68ec7d2,0xc637c607,0xc8adc71a,0xcdbfcaf1,0xd43ad0ed,
0xdaccd77e,0xe23fde5a,0xeadae675,0xf360ef40,0xf999f6ec,0xfc60fb5a,0xfdadfd05,0xffb3fe86,
0x03b5015e,0x0a7106ba,0x144f0efc,0x206c1a32,0x2c802693,0x373c3219,0x3fb03bc5,0x45c942fe,
0x49e14816,0x4c014b23,0x4c9c4c81,0x4b3b4c33,0x47a149a2,0x42d64558,0x3d62402c,0x37dc3aa1,
0x32933524,0x2d853012,0x27682aab,0x1f0c2387,0x14711a04,0x080d0e6d,0xfb29018e,0xeeecf4ed,
0xe424e95c,0xdaa6df31,0xd2e9d681,0xcd4fcfdf,0xc9fecb5a,0xc865c901,0xc8dbc84d,0xcbe0ca12,
0xd05bce08,0xd52cd2c6,0xd9f2d785,0xdf4ddc8e,0xe4dee217,0xe9d0e778,0xedbeebe0,0xf128ef7a,
0xf49af2e0,0xf7edf64a,0xfac6f971,0xfcf8fbe8,0xff22fe09,0x0145003d,0x02d80229,0x03b60359,
0x04810410,0x05e00520,0x07a606b4,0x09b908b1,0x0b810aac,0x0cc10c33,0x0d5a0d22,0x0d590d6e,
0x0cda0d28,0x0c4c0c8b,0x0bf10c17,0x0bb30bd6,0x0b650b8a,0x0b2d0b48,0x0acf0b04,0x0a270a8d,
0x08f9099c,0x07e40863,0x071a0777,0x066406c6,0x05e1060f,0x059505c0,0x04f4054b,0x0434049a,
0x02e703b1,0x005a01ce,0xfc61fe83,0xf7cafa0e,0xf44cf5cf,0xf27df348,0xf0e8f1b8,0xef8cf028,
0xee47ef03,0xeb6bed16,0xe68be93e,0xdf5be33a,0xd696db07,0xce7cd252,0xc8d0cb3f,0xc69fc74c,
0xc74ec6ae,0xca13c875,0xced8cc3b,0xd492d1b2,0xdac7d787,0xe23ade55,0xeac9e66b,0xf309ef1c,
0xf8c4f648,0xfbf1fa9c,0xfe2efd0f,0x00f7ff6a,0x057102eb,0x0cc308b2,0x16ef1186,0x22d21cca,
0x2e9e28d7,0x38b333ef,0x405b3cd3,0x45ff4362,0x4a534849,0x4d824c1c,0x4eb74e6e,0x4d304e4b,
0x49ba4ba4,0x44ef4782,0x3f304225,0x39093c1e,0x32b035e7,0x2c5a2f7d,0x257b290f,0x1ccf217a,
0x11d1178b,0x05370baa,0xf89bfeca,0xed3df2c3,0xe31ee809,0xd9f5de65,0xd262d5f7,0xccddcf57,
0xc946cad8,0xc78ec828,0xc7f1c77b,0xcaabc907,0xcf10ccb3,0xd42cd195,0xd99ed6d9,0xdf48dc77,
0xe479e1f8,0xe8d3e6cc,0xec6feaa9,0xefe0ee29,0xf353f199,0xf696f508,0xf8fff7e4,0xfb10fa02,
0xfd59fc32,0xff8bfe78,0x01570085,0x026701f6,0x037f02e4,0x0538043f,0x07cd066f,0x0a9e0939,
0x0d230bec,0x0f210e38,0x103f0fd2,0x1058106a,0x0ffb1022,0x0fe60fec,0x0f880fbe,0x0f020f4f,
0x0e760eb9,0x0dfa0e3a,0x0d710db7,0x0c6d0d05,0x0afb0bba,0x099f0a46,0x085308fc,0x06ed079a,
0x05b20647,0x04de0542,0x0443048b,0x039c03fa,0x024e0311,0xffcd013a,0xfbe7fdfc,0xf7e6f9cf,
0xf516f651,0xf323f417,0xf169f239,0xf03df0c3,0xee3aef81,0xe9f9ec5f,0xe3bfe715,0xdb77dfd8,
0xd298d6f5,0xcb20ce9f,0xc67fc85e,0xc52ac57c,0xc646c572,0xc972c79a,0xce11cba1,0xd34bd09e,
0xd97fd63e,0xe100dd18,0xe900e50b,0xeff9ecab,0xf52df2d4,0xf8dbf721,0xfc05fa74,0xffddfdbf,
0x05ec0288,0x0ee80a19,0x19b61428,0x25361f71,0x2ff42acb,0x38c5349a,0x3fe33c7c,0x46014309,
0x4b4448c3,0x4f294d74,0x51025061,0x50a15114,0x4e4b4fb5,0x4a244c62,0x44d047a7,0x3e8141b4,
0x37ab3b23,0x30df3449,0x28fc2d2f,0x1e4e2400,0x1178181f,0x03e20a98,0xf73ffd69,0xebddf16c,
0xe17fe692,0xd822dca3,0xd05dd405,0xca64cd2a,0xc642c80f,0xc40ac4eb,0xc3fec3b1,0xc662c4e5,
0xcaa6c852,0xd035cd4f,0xd65bd33e,0xdc8ad97e,0xe1d6df54,0xe62ee41c,0xea15e829,0xeddaebf4,
0xf1a6efc6,0xf4d0f35f,0xf6d1f5ef,0xf8b7f7b5,0xfb0ff9d8,0xfdd1fc68,0x0061ff30,0x02360157,
0x04020318,0x064b0506,0x099f07e3,0x0d340b6c,0x107d0eea,0x130911e1,0x147313e3,0x14db14c1,
0x14f014e5,0x148914d7,0x13901417,0x127312fd,0x119b11fc,0x110a114f,0x102810ae,0x0e8b0f6a,
0x0c880d92,0x0a9e0b8b,0x08ad09ae,0x06bc07b0,0x053005ea,0x0424049a,0x033503b1,0x01bf0290,
0xffa600cb,0xfc74fe39,0xf86cfa73,0xf4e3f681,0xf288f391,0xf0f4f1b1,0xef89f039,0xee82eef8,
0xecc0ede1,0xe8cdeb03,0xe2e7e622,0xdac1df19,0xd200d63f,0xcb09ce30,0xc72cc8b2,0xc646c669,
0xc74dc697,0xc9e6c863,0xce27cbe0,0xd328d08c,0xd988d61f,0xe0eedd30,0xe829e4a4,0xee72eb6d,
0xf394f12f,0xf7b8f5b6,0xfb70f99b,0xfff9fd72,0x070b032e,0x106b0b81,0x1b3215ad,0x267420dc,
0x30782bb6,0x389734bd,0x3f5c3c0e,0x45e14299,0x4c0f491b,0x50754e89,0x529b51d0,0x528852dd,
0x4ff55189,0x4bdb4e0b,0x46514950,0x3f2a42ed,0x379c3b43,0x3125344f,0x29b42dd2,0x1f0c24b5,
0x11bc18a8,0x03dc0aa9,0xf781fd87,0xec24f1ab,0xe1efe6ed,0xd88ddd1e,0xd099d460,0xca22cd2a,
0xc589c799,0xc2cac3ed,0xc25bc23a,0xc496c32e,0xc8bbc674,0xce60cb6e,0xd48cd174,0xda64d788,
0xdf9fdd1d,0xe45ae1ff,0xe89de68f,0xec6aea8e,0xeffaee46,0xf282f164,0xf430f364,0xf5e3f501,
0xf824f6ea,0xfb05f98b,0xfdb6fc78,0xffebfed6,0x025a0111,0x058203cd,0x096c0760,0x0de10b9f,
0x123e1023,0x15961411,0x17b416cf,0x18e5185d,0x1991195a,0x190d1970,0x17cb1876,0x169a1727,
0x15c1162a,0x14f6155f,0x137c1456,0x11391271,0x0e990fee,0x0be80d43,0x091d0a83,0x068707c0,
0x04a40583,0x033c03e4,0x01d10293,0x001f00fa,0xfe02ff30,0xfad5fc82,0xf7a7f92c,0xf52cf653,
0xf325f41f,0xf19cf24a,0xf0a7f119,0xef57f024,0xec54ee16,0xe77fea21,0xe08fe452,0xd808dc69,
0xcf94d3a8,0xc95dcc17,0xc5f8c760,0xc4b4c513,0xc56dc4d6,0xc7cec666,0xcbd2c99d,0xd178ce71,
0xd86cd4dd,0xdf86dc03,0xe5f5e2ce,0xec08e907,0xf162eed4,0xf61ef3cf,0xfb03f873,0x017ffe07,
0x09d50576,0x134b0e72,0x1da51865,0x279f22c7,0x30712c24,0x38643488,0x40023c36,0x475343c1,
0x4daa4aad,0x524f503b,0x54e653db,0x55215553,0x53185452,0x4f4c517e,0x495e4c92,0x41f045b3,
0x3aa03e3d,0x33643712,0x29fb2f10,0x1ddb243c,0x1037171a,0x0303097c,0xf6adfcb6,0xeb63f0e8,
0xe0fbe613,0xd77fdc1b,0xcf44d341,0xc87acba7,0xc365c5ba,0xc05ac18c,0xc009bfe4,0xc20dc0c9,
0xc633c3e4,0xcbd6c8e5,0xd204cee8,0xd7f6d50a,0xdd8ddac8,0xe2f0e04f,0xe7a5e55b,0xebb8e9cc,
0xeeabed56,0xf0a1efbf,0xf234f165,0xf42ff31e,0xf6e2f570,0xf9fbf878,0xfc9efb54,0xff43fde8,
0x024600b4,0x060d040f,0x0a8c0831,0x0f940d12,0x14411203,0x182e1646,0x1b6319e1,0x1dae1caf,
0x1e6c1e47,0x1d7f1e21,0x1bd51cb1,0x1a3e1b01,0x18e1198a,0x17461826,0x15321649,0x129e13f5,
0x0fd5113e,0x0cd60e5d,0x09c20b4c,0x071a085a,0x050a0600,0x0325041c,0x01170222,0xfef6000c,
0xfc6cfdc7,0xf97cfaf1,0xf707f82b,0xf51ff605,0xf380f44b,0xf1edf2b6,0xf0aef143,0xeeb6eff2,
0xeabfecf4,0xe4e1e815,0xdcf8e129,0xd42ed889,0xcc7fd01f,0xc759c991,0xc45fc5a6,0xc31ec387,
0xc3d7c330,0xc67ec4f0,0xcac5c867,0xd0c7cd99,0xd74bd40d,0xdd88da6a,0xe40ae0c8,0xea2de73b,
0xef5dece0,0xf44cf1be,0xfabcf73e,0x033cfec6,0x0ca307de,0x16ed11ae,0x21491c32,0x2a7a2607,
0x32d22eba,0x3ad636ce,0x43153efa,0x4aa94701,0x50df4dfd,0x55065339,0x57105655,0x56cb572b,
0x54d65613,0x504f52de,0x497f4d23,0x421d45c2,0x3b123e91,0x32ee374d,0x281d2ddb,0x1b6f21eb,
0x0e4814c8,0x01ac07ef,0xf5c2fb96,0xea7df015,0xdfe1e510,0xd64edaf5,0xce17d1f4,0xc77bca9b,
0xc257c4b5,0xbf5fc085,0xbf19bef3,0xc10abfcd,0xc4c0c2b9,0xc9a9c718,0xcf3ccc6e,0xd531d227,
0xdb6fd84e,0xe15cde70,0xe6afe42a,0xeaaee8dc,0xed5fec31,0xef28ee57,0xf0d5eff1,0xf321f1e3,
0xf61df48f,0xf906f7a3,0xfbf1fa6d,0xff25fd85,0x02be00dd,0x071604d1,0x0c4c0996,0x11b50f0e,
0x16701429,0x1ab218a2,0x1e911cb1,0x213c2020,0x220921df,0x217421de,0x201c20d4,0x1e821f55,
0x1c991d9f,0x1a0c1b65,0x16f8188d,0x13931547,0x105d11f3,0x0d150ec4,0x09d80b63,0x073c0878,
0x04d70613,0x02290385,0xff9300d5,0xfcf0fe4c,0xfa09fb84,0xf714f88a,0xf478f5b1,0xf297f372,
0xf12ef1db,0xf001f08e,0xef47ef9c,0xedafeeb8,0xea3aec2a,0xe4a4e7ba,0xdcf3e10a,0xd49cd8ae,
0xcdcbd0f6,0xc8ddcb26,0xc52cc6e6,0xc2c4c3c0,0xc288c254,0xc4d3c35e,0xc94ac6d2,0xcf06cc1e,
0xd502d1f8,0xdbe3d850,0xe344df99,0xe9a0e6ae,0xeeaeec38,0xf47ff158,0xfc3ff821,0x053b00a8,
0x0ef809fa,0x19461428,0x22f51e3e,0x2ba6276e,0x33d72fbf,0x3c513808,0x44b34090,0x4c8248ba,
0x52c74fee,0x569954fc,0x57d45788,0x573557b4,0x544e5628,0x4ec851d4,0x48244b72,0x41b244e0,
0x3b063e81,0x322836ee,0x26bd2caf,0x1a6620a5,0x0e161428,0x0246082b,0xf6b5fc7e,0xeb3ff0f1,
0xe030e599,0xd653db13,0xce10d202,0xc729ca73,0xc1fac450,0xbf55c049,0xbf7abf1b,0xc162c042,
0xc468c2c6,0xc860c64e,0xcd34caac,0xd332d013,0xd99dd659,0xe006dce1,0xe528e2cb,0xe8ece72f,
0xeb81ea5f,0xed5cec78,0xef69ee54,0xf204f0a4,0xf4c5f36e,0xf755f607,0xfa71f8cc,0xfe36fc44,
0x025a0040,0x06f40493,0x0c180975,0x116d0ec9,0x16cb1416,0x1c3a1983,0x210f1ec7,0x243b22e2,
0x256f250d,0x2564258a,0x246f2503,0x22aa23a4,0x204b218a,0x1d371ed9,0x19861b68,0x15df17a5,
0x12621424,0x0eaa108b,0x0b270cd9,0x08010992,0x04b60664,0x01530300,0xfe04ffa7,0xfaf7fc7a,
0xf7fdf979,0xf52ef686,0xf2f9f3f6,0xf198f237,0xf045f0f4,0xef52efa7,0xef01ef3b,0xed0cee57,
0xe8caeb2f,0xe258e5d9,0xda32de55,0xd29ed63a,0xccadcf72,0xc803ca40,0xc431c608,0xc173c298,
0xc13dc0f1,0xc3bcc235,0xc7fbc5b7,0xcd49ca8a,0xd3ced05e,0xdb70d78a,0xe2d1df43,0xe8b9e5f9,
0xee2aeb58,0xf500f15f,0xfd59f8fe,0x06fb0205,0x11880c31,0x1bed16d1,0x256720d6,0x2dfc29c9,
0x364b321f,0x3e9a3a79,0x46c842ab,0x4e934ad3,0x547251d0,0x57ce567a,0x58785865,0x57255811,
0x53485584,0x4d775086,0x47824a75,0x41b3449c,0x3ae63e90,0x31503675,0x25f02bc3,0x19e71ff0,
0x0e70140b,0x035d08e7,0xf816fdca,0xebfdf224,0xe039e5f5,0xd5f5dae0,0xcd50d171,0xc650c999,
0xc11dc36a,0xbedebf9b,0xbef2beb8,0xc036bf77,0xc284c134,0xc612c421,0xcb20c86b,0xd159ce25,
0xd802d4aa,0xde6bdb55,0xe39be129,0xe7a3e5c0,0xea93e93a,0xed03ebcd,0xef72ee34,0xf223f0cb,
0xf480f35f,0xf6eef5a9,0xfa16f866,0xfde6fbf4,0x020cffe6,0x06a5044d,0x0bbf0925,0x11070e59,
0x16d013dd,0x1cd219d6,0x22261fa4,0x25e5243f,0x280c271f,0x291128b1,0x28c6291e,0x270a2813,
0x243725c1,0x2069226d,0x1c2e1e46,0x18541a34,0x14951678,0x10e112b2,0x0d600f23,0x099e0b8d,
0x059407a1,0x0193038c,0xfde8ffb0,0xfa80fc2f,0xf6fdf8c2,0xf3abf547,0xf123f244,0xef5bf039,
0xedcbee8d,0xed0fed42,0xeca7ecf2,0xea8aebdf,0xe645e8ad,0xdfb3e344,0xd7cedbc2,0xd0ded423,
0xcb81ce00,0xc743c954,0xc363c53c,0xc0f7c1ed,0xc0efc099,0xc354c1e8,0xc738c520,0xcc79c9aa,
0xd3a7cfce,0xdbc0d7bc,0xe2ffdf8a,0xe91fe628,0xef88ec34,0xf6f8f320,0xff6cfb13,0x08fc0404,
0x13410e1b,0x1d631862,0x26b82227,0x2f932b2a,0x382633f5,0x40483c37,0x4894446d,0x502a4c93,
0x55725327,0x579656e8,0x578c57c7,0x552656a5,0x50b85333,0x4b2d4dfd,0x45554843,0x3f2b425e,
0x37f53bba,0x2ef533ad,0x24bf29fa,0x19f61f63,0x0f9714ae,0x05820a9a,0xfaa3003a,0xee82f4ad,
0xe297e86f,0xd7eedd11,0xcee3d336,0xc78dcb05,0xc26ec4a2,0xc019c0f5,0xbf99bfb4,0xc002bfb0,
0xc18bc0a3,0xc4a0c2e3,0xc950c6ca,0xcf29cc17,0xd599d262,0xdb6ed89d,0xe08cde18,0xe4e8e2d6,
0xe89de6d2,0xec09ea5f,0xef2ceda4,0xf1baf089,0xf404f2da,0xf68ef537,0xf9f6f826,0xfdc9fbe0,
0x01d4ffc1,0x063503fd,0x0b39089e,0x11000e0b,0x16ff13fe,0x1cd819f7,0x21f71f89,0x25e22413,
0x28c5276b,0x2aa829e5,0x2ac52aee,0x29382a2c,0x264227e6,0x2243245c,0x1e302031,0x1a771c4d,
0x16df18a4,0x133c1516,0x0f4d1151,0x0b0c0d30,0x06ca08e9,0x02a404ab,0xfeee00bf,0xfb34fd19,
0xf790f953,0xf48df5eb,0xf26df36a,0xf088f177,0xef0fefa5,0xef02eef0,0xee44eeea,0xeafdecfc,
0xe4fee849,0xdd0fe128,0xd54ad90a,0xcea9d1d3,0xc94ccbd3,0xc4aec6f1,0xc0a7c28c,0xbe82bf41,
0xbeb1be5b,0xc060bf5d,0xc3cdc1d6,0xc9d9c67d,0xd1d9cdb7,0xd9dfd601,0xe0cddd68,0xe7cce43d,
0xef50eb85,0xf75ff336,0x009dfbd8,0x0ad5059e,0x15991035,0x200a1af3,0x29ae24ef,0x32a12e34,
0x3b1f36e8,0x43b33f56,0x4c38481e,0x53144ff0,0x57595595,0x58c1585e,0x57605875,0x538655a7,
0x4e9f511f,0x49954c2e,0x443d46e9,0x3e344166,0x367d3a9a,0x2d1431ec,0x22b727f7,0x18b11d96,
0x0f6513fe,0x06090ac9,0xfb3c00dd,0xef65f563,0xe3b8e977,0xd91dde39,0xd02ad46e,0xc90fcc57,
0xc479c66d,0xc1fdc30b,0xc076c124,0xbfebc003,0xc0fac031,0xc412c24e,0xc877c62a,0xcdaccafa,
0xd2e5d057,0xd7dad55f,0xdcabda52,0xe117dee3,0xe58de355,0xe9c9e7b9,0xed66ebb7,0xf03feedb,
0xf2f6f19b,0xf628f46a,0xfa24f819,0xfe24fc26,0x023c002f,0x06a10456,0x0c120937,0x120d0f0f,
0x17f21509,0x1d7f1ac2,0x22af202e,0x270e24f6,0x2acc2907,0x2d322c3d,0x2da62daf,0x2c232d24,
0x28e02aaa,0x24d126de,0x212322e9,0x1def1f7c,0x1acc1c6e,0x16fc18fb,0x12a514df,0x0dff105d,
0x09110b92,0x0446069a,0xff9301f6,0xfa8bfd10,0xf61df836,0xf294f43c,0xefb7f11f,0xed21ee58,
0xebf3ec48,0xebfdebf1,0xeb25ebcd,0xe7f7e9e0,0xe24de578,0xdadadea8,0xd3d5d73d,0xcda0d097,
0xc845cae9,0xc329c5a9,0xbf42c0ff,0xbd64be16,0xbd40bd24,0xbec3bdbb,0xc2fac07b,0xca05c634,
0xd248ce21,0xda2fd64d,0xe1d2ddff,0xe96de5a1,0xf0e9ed33,0xf8e1f4c8,0x01c8fd39,0x0bbb069c,
0x1695110a,0x21911c1e,0x2beb26db,0x352f30af,0x3e04399b,0x46f6427f,0x4f0b4b36,0x54fb5251,
0x582256f1,0x584d589c,0x55605723,0x50f05353,0x4bc74e62,0x46284905,0x404e4342,0x3a0c3d41,
0x32c83698,0x2a352e9b,0x214625be,0x18a31cde,0x1051147a,0x074f0bf9,0xfcc70232,0xf159f723,
0xe5ffeb9a,0xdbb6e0b2,0xd2e4d71c,0xcc16cf29,0xc790c995,0xc454c5d7,0xc202c313,0xc0cbc12d,
0xc1a4c0f7,0xc44fc2c7,0xc81bc620,0xcc12ca22,0xcfe7cdf2,0xd40bd1f6,0xd88bd634,0xddc9db18,
0xe370e099,0xe8a2e62c,0xec92eac2,0xefb5ee33,0xf27ff114,0xf5f2f421,0xf9a5f7ce,0xfd4afb7c,
0x0111ff20,0x05d90345,0x0bdf08c9,0x11fc0ef5,0x17d314eb,0x1dc51ac6,0x23a720c7,0x28fe2669,
0x2d522b57,0x30082ee6,0x30a1309f,0x2ee93010,0x2b762d58,0x278a297e,0x23f325aa,0x20a3224e,
0x1cd51ed7,0x18441aa0,0x136715d6,0x0e8510f9,0x09b60c1a,0x04c90750,0xff48021f,0xf97bfc60,
0xf427f6af,0xefc9f1e1,0xec32ede4,0xe966eaa5,0xe86ce89a,0xe94ae8c8,0xe989e997,0xe7f7e90f,
0xe353e610,0xdc29dfe0,0xd4f8d880,0xce54d193,0xc855cb47,0xc2d8c584,0xbe5cc070,0xbb73bcb1,
0xba93bab9,0xbcbebb37,0xc220bf10,0xc9f1c5d3,0xd2c2ce3f,0xdbfbd759,0xe4bae075,0xec69e8ae,
0xf3a6f00a,0xfabff73c,0x0263fe69,0x0bbb06d8,0x16e41116,0x22b61cde,0x2d752847,0x36e33245,
0x404e3b90,0x4990450a,0x51514db5,0x56635448,0x57f1579b,0x5625576e,0x52ae5485,0x4de65079,
0x47764ae2,0x402c43de,0x398d3ca3,0x344d36ea,0x2e6a317d,0x279f2b16,0x204c23fc,0x194c1cbc,
0x11bb15a5,0x09480da9,0xff550484,0xf480f9f0,0xe9f7ef28,0xe031e4f3,0xd7a0dbb9,0xd0a9d3f3,
0xcb6dcdd7,0xc774c951,0xc458c5c9,0xc267c32f,0xc252c216,0xc450c321,0xc726c5b6,0xc9e3c88b,
0xccb5cb47,0xcfecce34,0xd46bd1f8,0xda5fd745,0xe0abdd8a,0xe632e399,0xea99e87c,0xee3bec85,
0xf1b1efea,0xf5a9f3a8,0xf955f790,0xfcbbfb04,0x00c6fe97,0x06470354,0x0c5b0953,0x12410f5b,
0x1801151f,0x1df61af9,0x23e520f5,0x293526a9,0x2d4a2b6b,0x2fec2ed3,0x309e3088,0x2f74303f,
0x2cea2e46,0x2a242b87,0x279a28d9,0x24a8263e,0x208622ba,0x1b931e1b,0x165418ee,0x114213cb,
0x0c2c0eb9,0x06a10982,0x002d037d,0xf9d1fcea,0xf429f6e8,0xef46f19f,0xeb1aed18,0xe81ce95e,
0xe773e77d,0xe7eee7b8,0xe78ee7e4,0xe544e6bf,0xdff6e2ff,0xd902dc85,0xd23ad591,0xcc0acf14,
0xc615c90b,0xc05cc327,0xbbacbdda,0xb8c5b9f6,0xb890b843,0xbbf5b9d1,0xc252bed2,0xca95c64d,
0xd3bfcf10,0xdcefd870,0xe522e130,0xeca6e8ef,0xf3d8f048,0xfb0bf761,0x038cff13,0x0df9087c,
0x19e413de,0x25831fda,0x30062ae8,0x3a17350a,0x446b3f44,0x4dca4953,0x54b6519f,0x582456e8,
0x5823588d,0x556756fd,0x516f539f,0x4bbf4ecd,0x44444824,0x3cf54076,0x373e39e8,0x320d34b6,
0x2bd22f16,0x24d42864,0x1db42137,0x16d61a50,0x0faf1348,0x07bd0be1,0xfe9d0342,0xf534f9e8,
0xebe3f081,0xe310e76c,0xdac6ded4,0xd3a0d701,0xcde5d09b,0xc944cb6e,0xc5c6c761,0xc3aec481,
0xc39cc368,0xc50dc436,0xc6f1c603,0xc878c7bb,0xca30c947,0xccf0cb57,0xd1a2cf07,0xd7e9d4a5,
0xde96db3f,0xe4b5e1bb,0xe9f7e779,0xee2bec27,0xf246f034,0xf623f44e,0xf95cf7d3,0xfcb2faea,
0x0161fedc,0x072f0436,0x0d170a26,0x12e20fff,0x18c115c6,0x1eba1bc0,0x247521aa,0x2960270e,
0x2ce72b56,0x2f062e2a,0x2f922f80,0x2e9a2f45,0x2ccc2dbd,0x2b3c2bf6,0x29882a7d,0x267a2835,
0x2221246a,0x1d291fb2,0x18091a95,0x13021589,0x0daf106d,0x078b0abb,0x009d041a,0xf9f9fd3a,
0xf42ef6f5,0xef3af19c,0xeaeaecff,0xe7f5e927,0xe7a1e783,0xe7e1e7dd,0xe723e7ac,0xe41de607,
0xdde2e150,0xd6afda46,0xcfc5d328,0xc97acc8f,0xc363c66f,0xbd32c04a,0xb7ddba49,0xb560b631,
0xb67eb56c,0xbb5fb88c,0xc2bfbec5,0xcbf5c72e,0xd5fed101,0xded8daa3,0xe67de2be,0xedc7ea2e,
0xf496f12e,0xfc0af822,0x056e0075,0x11040aff,0x1d17172d,0x281922af,0x32cb2d6d,0x3dcd3841,
0x48914353,0x51be4d75,0x576e5526,0x58d45890,0x576d586c,0x54795620,0x4f655231,0x48354c16,
0x3ff5440b,0x38e83c26,0x33873623,0x2dd930d8,0x26e92a7a,0x1fd02355,0x19551c77,0x1347164b,
0x0d4b1054,0x063c09f2,0xfe660257,0xf69ffa84,0xeecff2b4,0xe6c7eadb,0xde9ce2aa,0xd778dae0,
0xd180d45f,0xcc77cee2,0xc85fca40,0xc615c6f7,0xc59ec5a9,0xc645c5dc,0xc6fac6b2,0xc759c72e,
0xc855c7ae,0xcb1ec974,0xcfedcd4e,0xd5f5d2d4,0xdc8dd93e,0xe335dfe4,0xe931e659,0xee30ebc4,
0xf295f079,0xf5fef46a,0xf8e5f769,0xfcaafaa0,0x017dfefa,0x06c20418,0x0c380978,0x12140f15,
0x185d1532,0x1e971b86,0x244b2183,0x293026e3,0x2cc52b2b,0x2ed92e05,0x2f2f2f33,0x2e652eda,
0x2da02ded,0x2d3a2d71,0x2bec2cc5,0x28de2a9a,0x249026d1,0x1fc2222e,0x1aed1d5d,0x15c51867,
0x101812fa,0x099c0cf3,0x0277060f,0xfbc3ff09,0xf5dcf8b6,0xf091f32c,0xec03ee20,0xe94cea65,
0xe7d8e883,0xe665e729,0xe417e56f,0xdf90e229,0xd932dc80,0xd2a3d5dd,0xccb0cfa1,0xc6bbc9b9,
0xc049c398,0xb9c0bce8,0xb4e4b700,0xb335b391,0xb59ab3ea,0xbb37b80e,0xc38ebf0d,0xcdc9c88b,
0xd749d2c9,0xdf47db6e,0xe69fe2ff,0xed80ea1d,0xf47ff0e9,0xfd02f87b,0x07ce0229,0x13cd0dc7,
0x1f5519ab,0x2a7c24e5,0x36063038,0x41b53bea,0x4c704745,0x54c9510d,0x58c25751,0x59815972,
0x580e5903,0x547756a5,0x4e1a5197,0x45b64a06,0x3daa417e,0x373b3a4a,0x31373441,0x2a612dee,
0x231c26c2,0x1c161f82,0x15c918dc,0x0ff112d7,0x09ee0cf8,0x03ae06ca,0xfdaf00ae,0xf7cafab8,
0xf184f4ca,0xea31edf5,0xe27de64b,0xdb61ded7,0xd4edd815,0xcf29d1ee,0xcae1cccf,0xc820c956,
0xc678c727,0xc5c2c611,0xc508c560,0xc4c2c4c9,0xc5adc503,0xc877c6d3,0xccfcca8b,0xd2f3cfcf,
0xd9dcd64e,0xe154dd96,0xe821e4d8,0xee03eb31,0xf282f075,0xf5c7f436,0xf929f75b,0xfd77fb36,
0x0241ffdd,0x073a04af,0x0c9f09db,0x12b30f92,0x190e15e8,0x1f0f1c1e,0x248e21e8,0x28f826ef,
0x2c052aa9,0x2dc62d0f,0x2e772e3f,0x2ecf2e98,0x2f862f1b,0x2fe22fd4,0x2ed72f92,0x2c3d2db7,
0x286e2a72,0x23f02643,0x1e8e2163,0x184f1b87,0x117114f2,0x09ef0dc6,0x02090600,0xfaa3fe32,
0xf460f764,0xeee2f18e,0xea55ec6d,0xe7a5e8ba,0xe659e6ed,0xe51ce5ce,0xe246e3fc,0xdcc8dfcf,
0xd63dd988,0xd02ed315,0xcab2cd7c,0xc44ac7a9,0xbd25c0b6,0xb6bab9bb,0xb2bab44f,0xb26cb21f,
0xb5ceb3a9,0xbce4b8de,0xc6d0c1a2,0xd160cc29,0xda93d635,0xe1bcde60,0xe7a6e4bf,0xed58ea79,
0xf46cf0a1,0xfe1af8e8,0x0a0a03de,0x16b11068,0x22e21cd5,0x2ea928ce,0x3a7d348c,0x46124065,
0x4fd94b55,0x560b536c,0x58db57c3,0x5928595f,0x56de5851,0x5144547d,0x48e94d56,0x401b446b,
0x38643c08,0x32a73555,0x2d7a301e,0x27842aa0,0x2043240b,0x18c91c65,0x1250157c,0x0c520f3c,
0x06c2097d,0x01f20437,0xfe09ffed,0xfa01fc1c,0xf4bff794,0xee21f193,0xe72bea9d,0xe077e3ca,
0xd9fcdd31,0xd3ded6dc,0xce67d107,0xca18cc0e,0xc774c896,0xc5b4c688,0xc452c4ee,0xc3b0c3e4,
0xc470c3d8,0xc700c57e,0xcb50c8f2,0xd123ce13,0xd810d472,0xdfbddbe4,0xe6e7e378,0xeccfea0f,
0xf138ef28,0xf502f321,0xf8d5f6e6,0xfd10fadd,0x0181ff45,0x065003e0,0x0bd608f2,0x12310ef2,
0x18a71579,0x1e6d1ba2,0x2378210f,0x27752599,0x2a67290e,0x2c8b2b8c,0x2e0d2d59,0x2f6d2eaf,
0x311f3049,0x325831db,0x3212326c,0x30173147,0x2cae2e8c,0x28062a81,0x2234253f,0x1b5f1ee3,
0x1396179d,0x0aeb0f54,0x02740698,0xfadffe8b,0xf452f780,0xee8cf159,0xe9e8ebf7,0xe770e87a,
0xe599e68a,0xe315e47c,0xde98e121,0xd80fdb83,0xd155d498,0xcb79ce45,0xc5dcc8c4,0xbf34c2a8,
0xb863bbac,0xb354b58a,0xb11fb1d8,0xb24bb13a,0xb757b453,0xc03dbb59,0xcb27c59a,0xd5d4d0ad,
0xde4bda6d,0xe41ce17c,0xe8e2e683,0xee63eb64,0xf65cf205,0x00e7fb57,0x0d4b06f3,0x1a1513b8,
0x26982064,0x324a2c87,0x3dd43816,0x48704356,0x508c4ce4,0x5578536a,0x57c656dc,0x577357f1,
0x541a5643,0x4d605107,0x44b14928,0x3c3e405a,0x35693889,0x307d32d0,0x2b742e1c,0x24df2868,
0x1cff2104,0x155d1912,0x0e9911de,0x08f50ba8,0x042b0676,0x00c30241,0xfe39ff7b,0xfb25fcd9,
0xf689f90a,0xf0a7f3ae,0xea9fed99,0xe4a6e7a8,0xde7de1a0,0xd7d6db37,0xd168d482,0xcc54cea5,
0xc8ddca70,0xc640c779,0xc45ac532,0xc36ec3ba,0xc419c38a,0xc676c511,0xca80c841,0xcff8cd18,
0xd6bed32d,0xde35da6f,0xe528e1d2,0xeb19e844,0xf036edba,0xf4a3f27e,0xf8adf6ac,0xfceffacc,
0x012bff07,0x05e50372,0x0b9f08a1,0x12160ecf,0x188c1564,0x1e171b6d,0x22d1208f,0x267f24c7,
0x295327fa,0x2bd62a9f,0x2dd02ce1,0x2f822ea9,0x31463063,0x32cb3220,0x33353327,0x323f32ea,
0x2f9d3126,0x2b292da2,0x253d2859,0x1e3221dd,0x15d91a2e,0x0cde1158,0x0484088c,0xfd2c00b3,
0xf6aff9da,0xf0d1f3a6,0xec58ee54,0xe91deabd,0xe556e759,0xe064e307,0xd9e2dd59,0xd28ad626,
0xcbdbcf15,0xc5f4c8d7,0xc02bc319,0xba2fbd2b,0xb4b8b755,0xb0f9b293,0xafc4affa,0xb250b086,
0xb90fb52f,0xc30cbdc1,0xce43c8a4,0xd83bd392,0xdf31dc1a,0xe417e1c0,0xe8e6e66a,0xef4eebd2,
0xf800f35c,0x0314fd43,0x100b0962,0x1d7e16cb,0x2a59240d,0x36593069,0x41533c0d,0x4a66461d,
0x515d4e2d,0x55ce53e3,0x57995719,0x5628573a,0x51915447,0x4a624e3d,0x41cd461e,0x39c63d9b,
0x33c03684,0x2efb3159,0x290e2c3c,0x2177256d,0x193e1d57,0x118a154f,0x0ade0e08,0x059f0812,
0x01c00378,0xff8a007c,0xfdc8feb1,0xfb48fcae,0xf763f97e,0xf2daf51e,0xee53f09c,0xe955ebed,
0xe30ae661,0xdba8df67,0xd48ad803,0xcea7d161,0xca27cc41,0xc69cc843,0xc41fc540,0xc2b4c33d,
0xc30dc2a3,0xc54ec3ed,0xc965c728,0xcefbcbfb,0xd609d268,0xdd6cd9c1,0xe46be0f9,0xeab7e7ac,
0xf016ed88,0xf49ff267,0xf8daf6bf,0xfd10fb01,0x0136ff19,0x05ec0379,0x0b9b08a5,0x11c60eab,
0x179c14c8,0x1ca21a3f,0x20be1eca,0x243d2286,0x276f25dc,0x2a6b28f7,0x2caa2ba1,0x2eb82da7,
0x31372fea,0x33b13287,0x356f34b4,0x35a535d2,0x338634e5,0x2f193193,0x28d42c2c,0x2114251d,
0x184e1cc6,0x0f6413c9,0x07720b45,0x00aa03f2,0xfa6dfd7f,0xf4fcf78c,0xf074f2b2,0xeb0fedf1,
0xe453e7d8,0xdc46e077,0xd365d7da,0xcb31cf29,0xc3c2c75d,0xbd77c070,0xb84ebac8,0xb40cb609,
0xb0b9b241,0xaef2af92,0xb00faf0e,0xb4c3b1f8,0xbcc1b85b,0xc6eac1b8,0xd113cc26,0xd8e9d55c,
0xde49dbcf,0xe30ae099,0xe8b6e5b2,0xf01aec20,0xf9d7f4ab,0x0616ffae,0x13de0ce8,0x21b01ad3,
0x2ee32867,0x3b003520,0x45144046,0x4d7b497c,0x53a550e8,0x570155a7,0x571d5780,0x54995628,
0x4fbf526c,0x48e14c8f,0x41324504,0x3a553d8b,0x34bf377b,0x2e6d31d9,0x26562a8c,0x1d1b21d2,
0x13d61865,0x0b700f79,0x04a007cd,0xffd701fb,0xfd25fe3a,0xfc14fc77,0xfb54fbba,0xfa09facf,
0xf7b8f8f9,0xf53af67c,0xf21df3d1,0xed40eff0,0xe693ea1c,0xdf06e2d2,0xd7a7db45,0xd13bd44b,
0xcbe1ce72,0xc7b6c9a3,0xc4adc60c,0xc313c3a8,0xc377c30d,0xc5b4c45a,0xc987c776,0xcee6cc00,
0xd569d20f,0xdc8ed8e8,0xe3e5e044,0xea73e74d,0xeff4ed52,0xf4c7f26c,0xf96bf719,0xfde0fbb2,
0x0229fffa,0x06f5047c,0x0c37098c,0x11a70ef5,0x16d11449,0x1b48191d,0x1f411d4e,0x2300212b,
0x264d24b3,0x291927c2,0x2b8f2a53,0x2e492ce2,0x31542fcd,0x345332d9,0x3672358b,0x36d636ea,
0x35053639,0x30ba3336,0x2a122d9e,0x21e22622,0x18b71d55,0x0ff31437,0x084a0bf9,0x01d304ee,
0xfc0afee6,0xf696f93e,0xf177f415,0xeae5ee65,0xe2eee70e,0xd9bede7a,0xd00dd4db,0xc748cb83,
0xbfd5c360,0xba2cbcc1,0xb5d3b7e0,0xb278b404,0xb034b131,0xaff3afc0,0xb2b6b0ee,0xb863b53e,
0xc08dbc32,0xca15c542,0xd2d7ceaf,0xd984d675,0xdeb8dc37,0xe3d6e143,0xe988e684,0xf139ed0d,
0xfbabf613,0x08ec01fe,0x171b100b,0x24ed1e18,0x31a12b72,0x3ca63769,0x45e24170,0x4d8049f4,
0x527a505d,0x547653de,0x53e35469,0x511252c9,0x4c1b4ee0,0x44fb48b2,0x3d354115,0x36b139c0,
0x312233e4,0x2aa22e0f,0x22a126db,0x19781e1a,0x107014dc,0x08820c4b,0x026a0538,0xfdfc0000,
0xfb56fc68,0xfa4ffaaa,0xf9f7fa18,0xf9bbf9e0,0xf929f977,0xf86bf8da,0xf637f798,0xf17ef42c,
0xeac3ee4f,0xe322e701,0xdb94df42,0xd4d8d81d,0xcf09d1cd,0xca80cc9b,0xc737c8ae,0xc5bcc631,
0xc627c5ba,0xc83fc701,0xcbbcc9d3,0xd08bce05,0xd639d345,0xdc92d954,0xe2f4dfd2,0xe8b1e5ee,
0xedb4eb38,0xf29ef020,0xf7b3f52b,0xfca0fa37,0x0133feea,0x05ec038c,0x0ad70855,0x0fde0d63,
0x143a1225,0x18431639,0x1c8e1a5f,0x20ba1eb2,0x242b228e,0x26eb2599,0x29a22839,0x2d022b3b,
0x30d72ee9,0x345c32b8,0x36c135bb,0x37b7376f,0x36803769,0x329c34e2,0x2c482fb4,0x24022858,
0x1adb1f6d,0x124c1672,0x0af90e73,0x04e807d5,0xff490211,0xfa0cfc9c,0xf44df762,0xec9af0b7,
0xe32ce81b,0xd85cddea,0xccebd29a,0xc2ddc7a4,0xbb1bbea3,0xb5afb82b,0xb1c9b393,0xaf40b055,
0xaebbaead,0xb103af86,0xb5c3b324,0xbc63b8d4,0xc4a7c05a,0xcd0ec8eb,0xd453d0e2,0xda4cd76d,
0xdfd8dd12,0xe533e28d,0xeb49e807,0xf3e0ef29,0xffc2f973,0x0dad0699,0x1baa14b3,0x28b62261,
0x34242e94,0x3e4a3961,0x472a42e6,0x4d994ac9,0x50b24f85,0x51325138,0x504250e1,0x4d5d4f17,
0x480d4b0c,0x40bf4481,0x39533cf1,0x3314360e,0x2d573047,0x26782a18,0x1df92261,0x14b61959,
0x0c01103b,0x0483080b,0xfea9016f,0xfa0bfc2b,0xf743f864,0xf667f6a0,0xf704f694,0xf81cf789,
0xf977f8c0,0xfa45fa0d,0xf8caf9d9,0xf490f701,0xee4bf19d,0xe716eac4,0xe020e383,0xd99bdcd6,
0xd387d678,0xceafd0ee,0xcb53ccc9,0xc9d5ca58,0xca23c9c3,0xcc0bcaf1,0xcf11cd62,0xd34dd10b,
0xd89cd5da,0xde74db7c,0xe438e164,0xe942e6da,0xee06eb9d,0xf30cf07c,0xf817f599,0xfcaffa77,
0x00c6feca,0x04a602b5,0x08cd06b5,0x0cd10ae1,0x10940eb0,0x148f1287,0x18bd16a3,0x1c851ab1,
0x1fac1e33,0x22672107,0x25c123f4,0x2a2527d9,0x2ec42c82,0x329f30cb,0x359c343a,0x374136aa,
0x36a83748,0x33623556,0x2dd530e0,0x265c2a49,0x1e742254,0x17661ac4,0x116a1450,0x0b9f0e85,
0x05d508b2,0xfffa0307,0xf7cbfc42,0xeceef2a7,0xe058e6c8,0xd2b5d998,0xc5e2cc0f,0xbbbfc067,
0xb4d5b7ea,0xb01eb246,0xad54ae6a,0xad50acee,0xafc5ae57,0xb3efb1a4,0xb9c1b6a9,0xc0ddbd2f,
0xc858c4a1,0xcf1acbd9,0xd501d21b,0xdab3d7d4,0xe08edd9d,0xe6e9e39d,0xeee6eaa2,0xf987f3dd,
0x0657ffb9,0x13a00d09,0x20171a03,0x2b4e25c9,0x362630c2,0x403c3b60,0x4813448b,0x4c4a4aa1,
0x4e024d62,0x4dea4e1e,0x4c974d79,0x496b4b4a,0x43f446e7,0x3d8e40cf,0x378b3a73,0x31b034a2,
0x2ac32e7d,0x21c4267e,0x17d41cc9,0x0e78130b,0x06320a2f,0xff37028b,0xf955fc1a,0xf525f6fb,
0xf359f3ec,0xf3ddf35b,0xf5d8f4bf,0xf869f70f,0xfb0af9ce,0xfc21fbde,0xfa6cfba8,0xf61df880,
0xf068f364,0xea3aed4f,0xe408e72e,0xdd64e0bf,0xd715da22,0xd20dd45b,0xcefbd045,0xcdadce1f,
0xcdd0cd92,0xcf0fce4a,0xd203d053,0xd64ad405,0xdb2ad8ae,0xe043ddbb,0xe512e2b8,0xe972e742,
0xee22ebb0,0xf379f0ce,0xf881f613,0xfc79fa9c,0xffe3fe3c,0x030c0170,0x064804a7,0x09a307ed,
0x0d750b7e,0x118e0f7f,0x158c1393,0x194e1778,0x1c761af4,0x1f981dec,0x23e92191,0x28fd2673,
0x2d902b62,0x31ab2faa,0x351a3389,0x36d23631,0x366f36ed,0x33e23565,0x2f7131e5,0x29a32ca4,
0x240126b8,0x1ed2216a,0x19171c0e,0x13321615,0x0d66106b,0x04f009a3,0xf8c4ff4c,0xe9eef19a,
0xd9b1e1e0,0xca2cd1c4,0xbcfdc328,0xb358b7bc,0xacdbafc2,0xa91baa9a,0xa93ba8a5,0xac44aa93,
0xb04eae2d,0xb5c7b2d0,0xbcaeb91f,0xc397c032,0xc9d3c6d2,0xcf5ccc9e,0xd4e4d215,0xdac6d7c8,
0xe191de02,0xea30e59f,0xf4e7ef48,0x0173fb05,0x0e4707fa,0x19cf1442,0x24221f09,0x2ee72961,
0x39dd347e,0x42d63eb4,0x484d460c,0x4afc49db,0x4c004bb5,0x4bf84c1f,0x4a2f4b50,0x46994899,
0x41fd445f,0x3cfa3f7b,0x375b3a53,0x2fe933f3,0x26722b56,0x1c022142,0x121216ed,0x09290d7b,
0x01390518,0xf9defd73,0xf404f6a9,0xf07ef1f6,0xef8cefb2,0xf0d0eff0,0xf393f20a,0xf710f54d,
0xf9c0f895,0xfa7dfa70,0xf8d9f9e7,0xf5def776,0xf1eaf405,0xed13ef95,0xe72dea43,0xe0c8e3f7,
0xdaf8ddc0,0xd6add895,0xd42ad539,0xd2e7d365,0xd28cd29f,0xd37cd2c7,0xd63cd4ae,0xda14d80f,
0xde51dc3a,0xe247e053,0xe5fbe42a,0xea07e7e5,0xeefbec63,0xf43df1a1,0xf8caf6a4,0xfc62faac,
0xff6afdf7,0x022500d0,0x04f80383,0x086606a1,0x0c3e0a49,0x0ff60e21,0x137e11c2,0x16df1537,
0x1a2a1879,0x1e3e1c13,0x2309209d,0x27b02566,0x2c0929d7,0x30302e2d,0x333f31e4,0x34ed343f,
0x351c3538,0x339b3492,0x308a3245,0x2c512e84,0x27ea2a21,0x22fa2594,0x1cfc2011,0x16e119f3,
0x0f4d137e,0x04320a32,0xf5c1fd58,0xe48aed68,0xd2e6db92,0xc369cac8,0xb774bced,0xaf2bb2f0,
0xa9b0ac0c,0xa7f8a843,0xaa1fa8ab,0xae06abfe,0xb2cab03f,0xb8c6b5a6,0xbf49bc0c,0xc56fc267,
0xcb2fc857,0xd0d4ce01,0xd671d3a0,0xdc89d957,0xe479e036,0xef02e973,0xfb33f4f1,0x083201ae,
0x14320e72,0x1e161956,0x27b222c4,0x32582cf4,0x3c1e377b,0x43384013,0x4773459f,0x49f748df,
0x4afd4a9e,0x4adc4b1f,0x48e14a1c,0x45374739,0x405f42e9,0x3ac03dab,0x33a3376d,0x2a782f46,
0x201e2561,0x15b71ad5,0x0c4210df,0x03aa07dc,0xfb8bff94,0xf416f7a2,0xeeb2f110,0xec1ced0f,
0xec06ebc0,0xee0becd4,0xf16fef9c,0xf50df349,0xf7d1f69a,0xf8c8f891,0xf834f89d,0xf6b8f792,
0xf419f597,0xf00cf244,0xeaafed7c,0xe4d4e7bf,0xdfb8e21c,0xdc32ddbd,0xda10db00,0xd8aed94f,
0xd7f3d82f,0xd8bad821,0xdac8d99c,0xde01dc4a,0xe158dfbc,0xe45ee2e0,0xe78ae5e5,0xeb72e961,
0xf019edbc,0xf49ef26d,0xf84bf691,0xfb4af9d5,0xfde5fca5,0x0073ff22,0x039701ec,0x074d0566,
0x0b190934,0x0e870ce4,0x116d1009,0x143312c5,0x17b715d3,0x1c3219dd,0x20ce1e8c,0x251f22fd,
0x29702746,0x2d522b7e,0x302b2ed9,0x3245314f,0x334232e7,0x3312334e,0x31c4328f,0x2fa230cd,
0x2c4e2e2b,0x272d29f2,0x215c243f,0x1aa01e45,0x10c3162f,0x03160a5d,0xf21dfafd,0xdf7ae8c8,
0xcde1d671,0xbf24c60f,0xb3eab916,0xac2eafa3,0xa80da995,0xa869a7b8,0xab9ca9cd,0xafbdad97,
0xb495b20d,0xba52b754,0xc08dbd6c,0xc681c398,0xcc38c963,0xd1fccf1c,0xd79dd4ba,0xdea2dae0,
0xe846e309,0xf44bee18,0x0124fab6,0x0da90783,0x184d134a,0x21851cf1,0x2b622650,0x359e309e,
0x3e013a1f,0x43bc4139,0x477645c1,0x49ee48e0,0x4b1b4aab,0x4a644b01,0x4805496a,0x44524644,
0x3f914219,0x39563cba,0x30923541,0x26042b76,0x1ab72054,0x1006154f,0x06170aeb,0xfcd40171,
0xf439f85f,0xed6cf084,0xe97deb0a,0xe87ee8b3,0xe98de8ca,0xec38eaac,0xefd8ee05,0xf33ff19e,
0xf5c9f4a5,0xf73cf6a4,0xf7f3f7a5,0xf810f827,0xf67cf785,0xf29ef4ce,0xed4df017,0xe7cdea6e,
0xe36ae572,0xe06ee1c1,0xde80df62,0xdd24ddbe,0xdcb7dcc3,0xdd5ddcf1,0xdf0ede06,0xe1a7e055,
0xe417e2e5,0xe676e545,0xe989e7dc,0xed60eb61,0xf16def68,0xf530f363,0xf832f6c8,0xfaabf97e,
0xfcaefbb4,0xff4dfddf,0x028b00e0,0x05f10441,0x09340794,0x0bfb0aaf,0x0e3f0d19,0x11740fa8,
0x15e2139a,0x1a7e1832,0x1f011cbb,0x2361213d,0x27792576,0x2afe2951,0x2def2c87,0x304e2f39,
0x31f33139,0x336332ad,0x346d33fe,0x3406347d,0x313a32e8,0x2ca02f16,0x265d29ce,0x1d182231,
0x101d1713,0xff9e084d,0xec79f62f,0xd970e2d0,0xc882d09a,0xbad2c141,0xb04ab523,0xa9c0ac70,
0xa80ca84f,0xaa0aa8b7,0xadacabbb,0xb203afcd,0xb6a9b44e,0xbbddb929,0xc17bbeaf,0xc735c453,
0xccedca12,0xd27ecfc2,0xd8e4d579,0xe198dce5,0xed20e711,0xfa1ef393,0x06da008e,0x121c0cc2,
0x1b8316ec,0x24ee2023,0x2f0529f5,0x37fd33c2,0x3ebe3ba3,0x4359413d,0x47024544,0x496f4866,
0x4a2c4a17,0x48fd49bc,0x468a47e4,0x42ef44ed,0x3d8b407e,0x359839e7,0x2b5130af,0x1ffd25af,
0x14e81a5f,0x0a850fa9,0x008e057d,0xf6f7fbaa,0xeeb2f290,0xe939eb8d,0xe6c1e7a6,0xe696e670,
0xe823e72a,0xeafde976,0xee40ec9e,0xf13befc7,0xf3f8f2a5,0xf656f52f,0xf866f76e,0xf92bf909,
0xf7cff8c7,0xf452f644,0xefb3f215,0xeb53ed6c,0xe7e6e977,0xe58be69f,0xe3dee49d,0xe2a1e334,
0xe20ae23e,0xe20ce1f2,0xe321e278,0xe4a9e3e6,0xe66ce57f,0xe8b5e778,0xebbeea27,0xef34ed75,
0xf28df0e5,0xf57ff41b,0xf7e6f6c7,0xf9b4f8d8,0xfbb2fa9a,0xfe79fd0a,0x016efff1,0x049a02fc,
0x079e0631,0x09e608d2,0x0c710b04,0x103a0e30,0x147e125a,0x18e016ad,0x1d5e1b1d,0x21781f83,
0x2513234c,0x289a26da,0x2be72a4e,0x2eae2d5a,0x31512ffb,0x344832c1,0x36b535b7,0x36a13700,
0x349535c3,0x30cd3303,0x29802da6,0x1dd9243b,0x0e0d1679,0xfa7e04a2,0xe5bcf005,0xd30ddc04,
0xc35ecad9,0xb640bc84,0xac6cb0c4,0xa84fa995,0xa918a843,0xac02aa67,0xb00fade6,0xb491b252,
0xb8e4b6b4,0xbd94bb27,0xc2cac024,0xc870c594,0xcdddcb34,0xd3ced0ac,0xdbb2d770,0xe61de091,
0xf2b9ec3c,0xffe6f95d,0x0bb20613,0x153f10ab,0x1ea319d7,0x28b82399,0x32442db7,0x3990362e,
0x3ee43c75,0x433d411c,0x46da4530,0x49274837,0x49484974,0x482248d3,0x45dd472e,0x41d84419,
0x3b203ee8,0x318d36a1,0x26512c0a,0x1aed208d,0x106b159b,0x06260b4a,0xfb8200d4,0xf1b2f66c,
0xea2ced88,0xe5efe7aa,0xe44ee4dd,0xe4d3e453,0xe6d9e5b8,0xe967e819,0xebfbeab9,0xeeaded46,
0xf1bef027,0xf510f366,0xf79af68b,0xf87bf841,0xf74bf82e,0xf461f5f7,0xf0f0f2a5,0xedd9ef4f,
0xeb70ec97,0xe99fea6b,0xe884e90a,0xe798e809,0xe6cce72c,0xe69ce698,0xe71de6cd,0xe7fbe77e,
0xe9a5e8b2,0xec10eace,0xeeceed68,0xf165f022,0xf3b6f299,0xf5c0f4bb,0xf763f6a8,0xf90df81c,
0xfb9bfa3f,0xfe44fcf7,0x00ceff86,0x0397022e,0x05d904ce,0x07fd06d7,0x0b18096c,0x0eed0cf5,
0x12f710ed,0x17431514,0x1ba1197a,0x1f711d9d,0x22db212b,0x267b24a1,0x2a212857,0x2dbb2bea,
0x31d52fb2,0x36333411,0x38cd37df,0x389a38f2,0x36fe37fb,0x328e3554,0x29402e89,0x1b3322ca,
0x088d1266,0xf357fe00,0xdf70e908,0xce61d692,0xbfb7c6cc,0xb375b924,0xac4eaf17,0xaaf8ab0e,
0xac73ab85,0xaf58adbd,0xb2ecb122,0xb638b4a1,0xb98ab7d0,0xbdb1bb76,0xc2f3c037,0xc87dc5c3,
0xce31cb38,0xd589d197,0xdf4cda1d,0xeb38e503,0xf881f1d6,0x04d2feef,0x0ecb0a07,0x1853137d,
0x22691d4c,0x2c5c2785,0x346930b3,0x3ac337bb,0x40183d8a,0x446b4260,0x47cb4635,0x498a48f9,
0x498d49aa,0x48614920,0x45a6474b,0x40164350,0x37313bf6,0x2c7a320e,0x213f26d5,0x165c1bbb,
0x0bfb1129,0x0110069e,0xf647fb91,0xed08f14d,0xe6f1e993,0xe3b3e4ff,0xe2bae2fd,0xe347e2db,
0xe4aee3e1,0xe671e590,0xe893e763,0xebcfea11,0xefe0edc6,0xf3e0f1f4,0xf6a7f575,0xf7c7f777,
0xf6d6f783,0xf4cef5e8,0xf27af39e,0xf063f16a,0xee86ef64,0xed99edf0,0xed0eed5c,0xec34eca9,
0xeb76ebc9,0xeb13eb3b,0xeb04eb02,0xeb90eb2c,0xed2dec40,0xef86ee52,0xf1bcf0b7,0xf368f29b,
0xf4d3f424,0xf634f58a,0xf76ef6c4,0xf970f853,0xfbfbfaaf,0xfe3dfd2a,0x0054ff4c,0x0234014b,
0x0413031b,0x06a5053f,0x0a0e0841,0x0dfd0bfc,0x1248101d,0x16961474,0x1a7e189e,0x1df01c3f,
0x21501f9a,0x24e72316,0x28cf26cd,0x2d602afa,0x32bc2fff,0x37643551,0x396938be,0x39c339b0,
0x38143953,0x323f35c6,0x27332d68,0x16921f93,0x01dd0c85,0xec9cf715,0xd9c3e2c6,0xc982d15d,
0xbb61c223,0xb11fb59b,0xac88ae24,0xac3aabfd,0xae61ad18,0xb17bafe0,0xb4c8b324,0xb7ebb663,
0xbb40b97e,0xbfc5bd5b,0xc4f9c263,0xca39c786,0xd0c1cd3f,0xd991d4d8,0xe4a9ded7,0xf16eeaef,
0xfe24f7e8,0x090103de,0x12890dcb,0x1c61175c,0x26a02184,0x2fc82b72,0x3708338f,0x3d683a5e,
0x424e4005,0x4614445a,0x489f477b,0x4989494c,0x493a4982,0x47cf48a9,0x440b465d,0x3c9840c1,
0x328b37d2,0x274a2cec,0x1c2621b7,0x114316a6,0x06490bd9,0xfaf7009f,0xf093f588,0xe89aec41,
0xe38ee5b6,0xe105e20f,0xe022e05a,0xe0aee04c,0xe1d1e139,0xe33ee279,0xe5b8e449,0xe9bde790,
0xee92ec25,0xf2f7f0ed,0xf5d5f499,0xf715f6ac,0xf6d4f711,0xf5c1f661,0xf461f512,0xf30ef3b4,
0xf22af288,0xf1ecf203,0xf154f1b3,0xf081f0ea,0xefd7f024,0xef74ef9a,0xef87ef68,0xf061efdb,
0xf1d1f107,0xf369f29f,0xf4bdf422,0xf5a6f53f,0xf64af5fb,0xf6fcf69d,0xf83ff77a,0xfa71f944,
0xfcbdfba5,0xfe99fdbe,0xffcdff46,0x00d00044,0x028e0187,0x054503d5,0x089f06db,0x0cb10a98,
0x10d90ecf,0x14a112c3,0x18371671,0x1bc219fa,0x1f7e1d96,0x239b217a,0x28b22601,0x2eff2bbf,
0x3516322f,0x39513778,0x3b863aa8,0x3ad73ba2,0x365d3921,0x2d61326f,0x1ffd273d,0x0ea017bd,
0xfac604d3,0xe765f0d9,0xd609de75,0xc6c0ce24,0xba40c003,0xb28cb5c0,0xaf81b085,0xaf83af39,
0xb187b052,0xb446b2e8,0xb6d1b59a,0xb926b7fe,0xbc38ba82,0xc0c4be5a,0xc5cfc33b,0xcbffc8ba,
0xd410cfba,0xde0cd8dd,0xe94ce390,0xf539ef31,0x00d4fb2e,0x0b10060d,0x155a101e,0x1fdb1aa2,
0x29b324ea,0x31fb2e10,0x3914359b,0x3f8e3c71,0x44a24246,0x485a46a2,0x4b1d49e5,0x4c524be2,
0x4baa4c4f,0x48664a74,0x41494554,0x373f3c8b,0x2c2e31b2,0x214026b2,0x168a1bda,0x0bbe1135,
0x0090062b,0xf5ebfb1e,0xecfff130,0xe652e963,0xe1aee3c3,0xdf05e01b,0xddd4de53,0xdd7ddd8c,
0xddebdd9c,0xdf82de7c,0xe340e118,0xe895e5d2,0xedb8eb47,0xf194efcd,0xf433f30e,0xf594f502,
0xf5faf5e9,0xf5aaf5db,0xf556f577,0xf54cf546,0xf599f56b,0xf5acf5b7,0xf54cf585,0xf49bf4fb,
0xf404f446,0xf3b7f3cc,0xf419f3d3,0xf4aaf45f,0xf570f507,0xf64bf5e5,0xf6ccf695,0xf6e3f6e6,
0xf6d4f6d1,0xf79df711,0xf96ef86f,0xfb8afa7d,0xfd68fc8b,0xfe92fe16,0xff21fedf,0x0056ff95,
0x02970160,0x055003e5,0x08c606e6,0x0d0e0ae4,0x110f0f22,0x149512df,0x1806164b,0x1b9219c8,
0x1f691d6a,0x242321a0,0x29f726ea,0x30542d2f,0x35cc333c,0x39db3809,0x3af23aec,0x37cf39dd,
0x30c634c2,0x25d72bd9,0x170f1ed5,0x05a40ea0,0xf32efc5c,0xe1f3ea5f,0xd256d9ed,0xc515cb54,
0xbb54bfba,0xb509b7c4,0xb23ab337,0xb26cb201,0xb46fb351,0xb6b9b59c,0xb8c3b7bf,0xbb0bb9d3,
0xbe73bc97,0xc2efc089,0xc8bfc5a7,0xd006cc31,0xd8f0d44a,0xe2e1ddd8,0xed3fe7fe,0xf7fcf29b,
0x0266fd3d,0x0cce0792,0x1775121b,0x21d41cba,0x2b7826c2,0x33db2fda,0x3b9337bd,0x42053f06,
0x46ce44a1,0x4a9148c3,0x4d144c0e,0x4da24dae,0x4b574ce4,0x455448d0,0x3c50411a,0x31c0371c,
0x26fa2c5b,0x1c6e21a3,0x12061747,0x070f0c97,0xfc53019d,0xf2b6f749,0xeb3deeb8,0xe56ee823,
0xe17fe334,0xdecce00f,0xdcddddb9,0xdbf5dc4a,0xdc62dbf0,0xded5dd51,0xe36be0ec,0xe8aae616,
0xed2beb07,0xf084ef02,0xf2a4f1b6,0xf3f1f363,0xf463f43e,0xf48af474,0xf526f4c4,0xf62ff5a1,
0xf740f6c4,0xf7bef791,0xf7c1f7d3,0xf74af78b,0xf6faf71b,0xf71bf6fa,0xf754f746,0xf76df759,
0xf7c7f792,0xf82cf800,0xf862f84c,0xf84ef861,0xf885f84b,0xf9a2f8fe,0xfb09fa50,0xfc79fbc8,
0xfda7fd1f,0xfe3efe05,0xff17fe8f,0x00e8ffe4,0x034e020f,0x061e04a2,0x09ef07e7,0x0e070c0a,
0x11400fc0,0x142212a7,0x177715bc,0x1b0b193d,0x1f0d1cf2,0x240f2161,0x2a712724,0x30dc2dc0,
0x366833b7,0x3a4938c1,0x39ce3ab0,0x347937b6,0x2b273048,0x1df024fd,0x0dd2162a,0xfc91052b,
0xec37f43d,0xdcd8e464,0xcf1dd5bc,0xc447c93a,0xbcc2c039,0xb7c9b9e6,0xb5e0b678,0xb6a0b5fa,
0xb888b781,0xba86b99a,0xbc05bb50,0xbe07bcdf,0xc11ebf6f,0xc5b3c32c,0xcc23c8ab,0xd441d001,
0xdd7ad8c6,0xe71ee247,0xf0efec0b,0xfa61f5b3,0x0414ff1c,0x0eab0948,0x199b1426,0x23da1ed7,
0x2d0f289d,0x35583141,0x3cdf394b,0x42d64003,0x47784548,0x4b3c497f,0x4d7a4c9c,0x4d064da4,
0x490f4b90,0x4172459b,0x37883cb5,0x2d073249,0x228527be,0x188b1d86,0x0dff1367,0x03070880,
0xf8c7fdb7,0xf06ff457,0xe9e5ecf7,0xe4f0e733,0xe167e316,0xde45dfc9,0xdbc2dceb,0xda5fdadb,
0xdb02da65,0xde13dc3d,0xe2eae05f,0xe7d8e573,0xebf3ea07,0xeee5ed90,0xf112f00d,0xf2a5f1f4,
0xf3d7f342,0xf4dff457,0xf654f587,0xf82cf73e,0xf979f8ee,0xfa22f9e2,0xfa43fa3c,0xfa63fa4b,
0xfaa4fa7e,0xfae8facf,0xfab7fadb,0xfa81fa97,0xfa62fa7b,0xfa07fa39,0xf9aaf9dc,0xf974f97d,
0xf9fdf9a4,0xfb00fa77,0xfc0efb8e,0xfcf6fc84,0xfd8ffd4e,0xfe3efdd8,0xff8ffed3,0x0172006c,
0x03c4028e,0x068f0514,0x09fc083a,0x0d530bb7,0x10170ec0,0x13111183,0x166414b4,0x1a151829,
0x1ead1c3e,0x24942177,0x2b3227e2,0x31852e67,0x37333490,0x39b03906,0x370f3911,0x2f7433cc,
0x237a2a04,0x13ea1c0b,0x03210b7a,0xf380fb28,0xe518ec25,0xd80fde5e,0xcd92d265,0xc63fc997,
0xc082c347,0xbc16be10,0xba46bace,0xbab3ba58,0xbc2cbb5f,0xbda8bceb,0xbf38be65,0xc133c02c,
0xc42ec279,0xc979c689,0xd106ccfa,0xd9e2d561,0xe2d8de61,0xebb1e750,0xf3b1efd7,0xfbadf785,
0x058f005e,0x106d0b01,0x1ab215b0,0x24401f88,0x2d4e28d7,0x35f331ad,0x3d7439e7,0x43bb40bc,
0x48dc4668,0x4d424b3d,0x4f434eab,0x4d434ed5,0x46b94a84,0x3d1d422c,0x326f37c7,0x27fc2d2f,
0x1e3122fa,0x144c195d,0x09c50f0f,0xff5c047c,0xf646fa97,0xeedaf263,0xe8e6ebab,0xe495e694,
0xe0d9e2b4,0xdd4ddf0a,0xda4ddbab,0xd900d959,0xda59d951,0xde25dc03,0xe2dee081,0xe74ae527,
0xeadfe932,0xedb9ec62,0xefe6eee9,0xf15ff0b1,0xf28af1fc,0xf3f0f322,0xf626f4fe,0xf860f74e,
0xf9e3f93f,0xfab2fa55,0xfb4cfaff,0xfc3afbaf,0xfd44fcd0,0xfd75fd74,0xfd09fd4d,0xfc5efcba,
0xfbb1fc04,0xfb31fb68,0xfaf6fb0c,0xfb78fb17,0xfcb8fc0b,0xfdecfd60,0xfea9fe5e,0xfee9fed1,
0xff1dfefd,0xffe0ff67,0x01480081,0x031f022b,0x055f042c,0x084406c1,0x0b7909dc,0x0e750d00,
0x114e0fde,0x147012d0,0x17de161e,0x1c0a19d5,0x21571e86,0x276e245d,0x2d752a72,0x3366307f,
0x371e35b5,0x363e3767,0x2fdc33aa,0x252e2aff,0x173e1e9b,0x07270f46,0xf778ff29,0xe93cf025,
0xdca3e2c1,0xd233d711,0xcb36ce45,0xc696c8c6,0xc219c45e,0xbec1c01d,0xbd9fbdf9,0xbe06bda9,
0xbf01be7e,0xc048bf99,0xc207c11d,0xc45ac30f,0xc86cc60c,0xcf29cb84,0xd7bbd34e,0xe07bdc31,
0xe88ce491,0xeffaec64,0xf6cbf35d,0xff06fa97,0x097d0419,0x13e90ecb,0x1d8018c4,0x26d42232,
0x2ff72b6d,0x38aa3475,0x40303c85,0x469f4394,0x4c3c4976,0x50124e92,0x501050a7,0x4b0d4e25,
0x421746f3,0x37883ce0,0x2ca63211,0x22612770,0x18601d5c,0x0e5b1368,0x042f0935,0xfb15ff72,
0xf399f728,0xed3cf046,0xe83dea95,0xe417e61f,0xe01de218,0xdc56de2d,0xd99fdabf,0xd954d91d,
0xdb9bda2f,0xdf42dd62,0xe2f7e11e,0xe6aee4da,0xe9d5e852,0xec64eb32,0xee39ed5f,0xefa8eefa,
0xf0f9f054,0xf2e7f1c8,0xf5a9f436,0xf88af730,0xfa7cf9a3,0xfbfcfb3b,0xfdbcfccd,0xff9dfeb5,
0x00a8004f,0x007a00aa,0xff93001b,0xfe6bfefd,0xfd9dfdf4,0xfd2bfd5a,0xfd34fd18,0xfe2bfd9a,
0xff0cfea9,0xff52ff44,0xff06ff34,0xfe92fed0,0xfea2fe79,0xffa3ff0f,0x00fd0045,0x02fc01e3,
0x05ad0440,0x08bc072d,0x0bcc0a4b,0x0ece0d4d,0x11f71057,0x157d13af,0x197e1768,0x1e4d1bca,
0x23c020ff,0x29912690,0x2fd02cba,0x34493278,0x34f63526,0x3110339d,0x28872d51,0x1c5822d8,
0x0d69152a,0xfda10573,0xef0df628,0xe209e855,0xd738dc43,0xcfa6d2fd,0xcb24cd12,0xc82ac9a2,
0xc533c6a5,0xc32ec406,0xc226c28e,0xc1ddc1ec,0xc290c211,0xc402c339,0xc5ccc4da,0xc888c6ef,
0xcdbfcad3,0xd51ed13e,0xdd60d942,0xe510e14e,0xec2ae8b2,0xf283ef69,0xf959f5ba,0x0244fd90,
0x0bff072b,0x154710b1,0x1e2e19bf,0x273922ac,0x305e2bd5,0x38e134bf,0x40c03cec,0x47c14459,
0x4d6a4aee,0x4f644ee6,0x4ced4ec8,0x461b49f5,0x3ced41a7,0x32e437fd,0x28df2dd4,0x1f0723f6,
0x15191a08,0x0b231016,0x01c1065a,0xf9b8fd8c,0xf2d4f62d,0xed2defce,0xe879eacc,0xe3bbe61b,
0xdf4be171,0xdbc6dd5d,0xda18daa4,0xdaa0da1c,0xdca4db8d,0xdf27ddd5,0xe253e0ac,0xe5a9e3fe,
0xe8dbe751,0xeb4bea26,0xed28ec4c,0xee9cede3,0xf049ef5f,0xf2d4f16e,0xf5f3f45d,0xf898f76b,
0xfa83f992,0xfc99fb7c,0xff51fdeb,0x018e009a,0x024b021b,0x01cd022d,0x00700131,0xff18ffb6,
0xfe4efe9d,0xfe36fe29,0xff22fe8e,0x0057ffcb,0x00d900b3,0x009700c9,0xfff60049,0xffa7ffb5,
0x004fffdf,0x017400dc,0x02e1021e,0x04f003d3,0x07910635,0x0a4408ea,0x0d160ba0,0x10550eab,
0x1424122b,0x18821645,0x1d571ade,0x22571fdb,0x274f24c8,0x2cbd29f6,0x313e2f46,0x325b3251,
0x2f263146,0x27cc2c00,0x1cef22bf,0x0f431669,0x003107c2,0xf192f8bb,0xe4a0eae0,0xd9a6ded9,
0xd19fd532,0xccf8cefe,0xca5fcb7e,0xc8bac972,0xc797c81f,0xc698c717,0xc5d2c62f,0xc5b5c59c,
0xc6ecc632,0xc8f2c7d7,0xcb66ca19,0xcf87cd30,0xd5c9d265,0xdd3ed978,0xe481e0f3,0xeb0fe7e3,
0xf0c9ee05,0xf676f388,0xfd91f9c5,0x061301b5,0x0ed80a7e,0x1750131d,0x1fed1b96,0x28c02456,
0x319d2d31,0x3a4135f3,0x42d73e98,0x4a3746c8,0x4de34cac,0x4cbc4de8,0x472a4a70,0x3eaf431c,
0x35373a09,0x2b9b305e,0x223226e0,0x18d41d84,0x0f79141b,0x068c0aef,0xfe970268,0xf79afb05,
0xf197f472,0xeca2ef07,0xe7d1ea47,0xe2e5e54d,0xdedbe0bb,0xdc93dd73,0xdc65dc42,0xdd65dcd2,
0xdec2de0a,0xe0b5df9e,0xe38be20f,0xe689e507,0xe94fe802,0xeb48ea61,0xecb3ec08,0xee1ded5d,
0xf004eef8,0xf2b5f14c,0xf564f421,0xf784f67c,0xf9bef894,0xfcb5fb1a,0x001cfe76,0x026e0174,
0x031902fb,0x025d02df,0x00e701a8,0xffa50030,0xff33ff4f,0xffcbff58,0x01400080,0x022301ce,
0x0221023e,0x017a01db,0x00db0122,0x00f800c8,0x01f30165,0x03190281,0x048d03bf,0x069e0583,
0x090307d2,0x0b5e0a2d,0x0e1c0caf,0x11730fb2,0x15331349,0x19871742,0x1e561be8,0x232020c8,
0x28102589,0x2d292ab4,0x30222f16,0x2f2b3021,0x2a722d4f,0x21d12694,0x15c41c36,0x06f80e94,
0xf7f7ff5b,0xea65f0f4,0xdef0e465,0xd5add9fe,0xcf7bd22d,0xcc00cd6b,0xca5bcb0b,0xc9adc9ec,
0xc96cc989,0xc937c94c,0xc935c927,0xc9f7c96e,0xcbcccac9,0xce15ccee,0xd104cf5c,0xd5b3d31b,
0xdc39d8cd,0xe304dfab,0xe966e644,0xeeebec4e,0xf349f131,0xf86cf596,0xffc5fbd9,0x081603ec,
0x10280c29,0x17e11406,0x20001bd9,0x28812443,0x31392cd1,0x3a2c35b1,0x42c63e95,0x49c346a5,
0x4c214ba1,0x49524b49,0x42c74674,0x3a093e8b,0x30ce3572,0x27c02c36,0x1ecb2349,0x159b1a42,
0x0cd61118,0x04d808b7,0xfdfc0149,0xf79bfac7,0xf212f4aa,0xed56efac,0xe843eade,0xe360e5b7,
0xdfe2e15c,0xdeb7df08,0xdf42deda,0xe03ddfcc,0xe120e0a6,0xe2b4e1d1,0xe4cae3b6,0xe72ee5f9,
0xe902e83d,0xea04e99c,0xea8dea4c,0xeb77eae0,0xed62ec4c,0xf006eead,0xf297f15a,0xf544f3e1,
0xf88af6d6,0xfc78fa6e,0x0031fe7d,0x02870186,0x03440320,0x024702ee,0x00b4017e,0xff830003,
0xff82ff55,0x00dd0011,0x025e01b3,0x030702cf,0x03020313,0x028602cb,0x023b024c,0x02f00275,
0x040c0382,0x052c0497,0x06c905e4,0x090407d3,0x0b9d0a54,0x0e580ce9,0x11a50feb,0x1552136e,
0x196e1752,0x1de81ba6,0x22522025,0x26b82479,0x2b442915,0x2de42ced,0x2d682e0e,0x29bf2bff,
0x230926b6,0x19611ea4,0x0c3e1330,0xfd9d04ec,0xef9ef676,0xe36be93b,0xd98bde38,0xd1fed575,
0xcccfcf19,0xc9f0cb1c,0xc904c94a,0xc92ac90a,0xc954c948,0xc997c95e,0xcb15ca21,0xcdd1cc56,
0xd13dcf87,0xd470d2cd,0xd83cd642,0xdd03da76,0xe292dfc9,0xe80de556,0xed2beab1,0xf161ef68,
0xf550f342,0xfaaef7c4,0x01a7fe00,0x09910593,0x11410d7b,0x193d1524,0x21a11d75,0x2a0f25c5,
0x32f22e71,0x3c323793,0x44614095,0x48d8473b,0x489f4948,0x441246d3,0x3d1240cb,0x34c738fd,
0x2c7e3095,0x247d2881,0x1c40206c,0x13d117fb,0x0bbe0fb8,0x049b080d,0xfe030149,0xf7effadf,
0xf256f519,0xeccbef97,0xe751ea04,0xe2e4e4e5,0xe0abe182,0xe056e051,0xe0c4e087,0xe124e0f3,
0xe1c1e16c,0xe2c1e22f,0xe463e37a,0xe684e573,0xe7ffe763,0xe8d0e870,0xe976e923,0xeae6ea09,
0xed30ebfe,0xef6cee5a,0xf1b8f081,0xf4d8f32c,0xf88ef6a4,0xfc91fa9c,0xfffefe5b,0x025f0159,
0x032702fa,0x027902f4,0x015c01eb,0x00b400e7,0x014400d7,0x028c01e1,0x036a0312,0x03c403a2,
0x03d003d6,0x03c503c3,0x045703f2,0x055e04d4,0x066a05eb,0x077006e7,0x08be080e,0x0a650984,
0x0c890b64,0x0f5f0dde,0x12c51103,0x16a014a5,0x1b3218cd,0x20431db8,0x250522b4,0x29c02758,
0x2dad2c02,0x2e6f2e7f,0x2ba22d74,0x25912902,0x1ca1216a,0x10871703,0x02310981,0xf3f4faf9,
0xe6d5ed34,0xdbcce0fd,0xd3c1d75b,0xce64d0d5,0xca9acc54,0xc8b8c95e,0xc8e2c8a0,0xc983c93d,
0xc9a2c999,0xca29c9c1,0xcc8bcb12,0xd0c5ce80,0xd57bd326,0xda33d7d7,0xdf0edc8e,0xe486e1bb,
0xe9ede74f,0xee97ec66,0xf1ebf069,0xf4aef346,0xf879f661,0xfda2faf0,0x03ab0090,0x0a2406db,
0x115d0d94,0x198e1563,0x21aa1d9a,0x2a2925e4,0x33352e81,0x3cf4382c,0x44ab4137,0x478446ce,
0x45584701,0x3f8b42ba,0x37fa3beb,0x302c3407,0x28c52c77,0x21362507,0x196b1d56,0x11ee15a0,
0x0ae80e4f,0x047407a9,0xfe450147,0xf892fb6d,0xf2b1f5a9,0xec97efab,0xe6cde98a,0xe2e6e482,
0xe1a7e202,0xe1b8e1a2,0xe1f5e1d2,0xe257e21e,0xe2e2e294,0xe407e361,0xe5a7e4cd,0xe730e67d,
0xe7e7e7ad,0xe83de80a,0xe8f0e885,0xea87e9a5,0xec61eb6c,0xee5fed5c,0xf0e4ef84,0xf460f291,
0xf850f64b,0xfc0bfa46,0xff3dfdb4,0x016a008a,0x022401f0,0x01c50210,0x00e60150,0x00ab00a6,
0x011700d8,0x01b50165,0x023001f7,0x02a8026d,0x02f302cc,0x03a5033a,0x04c6042d,0x05f80562,
0x07390693,0x08c407fb,0x0a760997,0x0c9c0b74,0x0f930df7,0x1389116e,0x184915d6,0x1dc21af1,
0x238d20a8,0x28b8263f,0x2d892b21,0x310f2fae,0x30993161,0x2c292ec4,0x250d28ea,0x1c2020c4,
0x11391700,0x040c0ad4,0xf640fd1b,0xe934ef90,0xde06e346,0xd5dbd98b,0xd04ed2da,0xcc2fce1b,
0xc95cca85,0xc8c1c8cd,0xc923c8fb,0xc8bbc913,0xc7cdc831,0xc8acc7ea,0xcc45ca22,0xd232cefc,
0xd98dd5cd,0xe082dd1f,0xe6bfe3b7,0xec1ae97f,0xf0bcee8f,0xf451f2a9,0xf6dff5a9,0xf989f81d,
0xfcc5fb1d,0x009afe90,0x055702dc,0x0b770831,0x13220f21,0x1b761747,0x243d1fc7,0x2d8828cb,
0x379d3293,0x3ff33c2c,0x443742c0,0x43684462,0x3ee04178,0x38723be3,0x311f34c1,0x2a092d90,
0x2319268c,0x1c311faa,0x158118ce,0x0f491255,0x09830c63,0x03ef06a9,0xfe79013f,0xf867fb85,
0xf1f7f537,0xebdeeecd,0xe733e944,0xe4dae5c5,0xe41be45b,0xe3f1e3fb,0xe436e405,0xe4afe474,
0xe56be503,0xe66ae5df,0xe777e6fc,0xe802e7ce,0xe7fbe808,0xe837e80e,0xe8fde881,0xea53e9a7,
0xebb3eafc,0xed74ec7f,0xf037eeb1,0xf3caf1f2,0xf750f59b,0xfa6ef8eb,0xfd2cfbe1,0xff40fe4c,
0x00960003,0x012600f7,0x016a0141,0x01e401a5,0x0243021b,0x024a0255,0x025e0249,0x02b30285,
0x035d02f8,0x045503cd,0x058004e8,0x06c40614,0x089407a0,0x0a780987,0x0c810b6f,0x0f220db9,
0x12ed10dc,0x17d41547,0x1d4e1a83,0x231d2032,0x28c825fb,0x2e212b83,0x32043067,0x322f32b2,
0x2d813063,0x258429c9,0x1c4920f0,0x128c178c,0x07590d2e,0xfab60128,0xee1bf452,0xe30ee84b,
0xda48de66,0xd36cd6aa,0xce08d090,0xc9d5cbc2,0xc778c866,0xc6e6c707,0xc695c6d3,0xc568c615,
0xc4b3c4d6,0xc6ccc54b,0xccbdc955,0xd584d0e0,0xdf3ada5e,0xe82ee3f5,0xeeb8ebb8,0xf3b5f15c,
0xf812f5ee,0xfbb4fa0b,0xfe6efd2b,0x00adff94,0x02fa01cc,0x05df0453,0x09f407b4,0x0fcb0ca1,
0x171e1353,0x1f3c1b19,0x285823aa,0x31be2d18,0x39df3621,0x3eb13cc1,0x3f293f85,0x3c083de4,
0x36c639a3,0x303b339c,0x294f2cc5,0x22aa25f3,0x1c3d1f6f,0x1624191d,0x109a134d,0x0b8c0e06,
0x06e30931,0x023d049a,0xfce8ffb6,0xf68ef9d4,0xf02bf342,0xeb2ded70,0xe829e96c,0xe6c9e74f,
0xe65ee685,0xe665e652,0xe6cde68f,0xe756e710,0xe82ce7b5,0xe938e8aa,0xe9e7e9a7,0xea17ea0f,
0xe99be9e5,0xe974e979,0xe9d5e996,0xea3aea0d,0xeaf1ea83,0xecbceba6,0xefa5ee11,0xf30af15a,
0xf627f4a1,0xf908f79c,0xfbcefa70,0xfe26fd0a,0x0003ff26,0x013d00b1,0x01f601a3,0x0259023d,
0x0234025a,0x01ca01fa,0x01a901ad,0x022101d0,0x035702ab,0x04e20418,0x067405a3,0x086e075e,
0x0a6e0972,0x0c710b6e,0x0eab0d81,0x11db1018,0x16951409,0x1c641965,0x228e1f7c,0x28a12598,
0x2ecf2bbe,0x3391318a,0x34c134b7,0x30e73377,0x28e72d51,0x1efd23fe,0x15141a07,0x0ab3100b,
0xfe5204c4,0xf168f7bc,0xe62beb88,0xdd42e179,0xd592d953,0xcf49d232,0xcab2cccb,0xc78cc8fa,
0xc5d2c677,0xc543c580,0xc45fc4ee,0xc308c3a8,0xc332c2c1,0xc6eec497,0xcdfcca19,0xd797d287,
0xe1f1dcdc,0xeacbe699,0xf1edee93,0xf86ff51c,0xfec5fbc8,0x032c013f,0x05db04a8,0x07e006e9,
0x097408a9,0x0b5e0a4d,0x0eab0cc8,0x143b112a,0x1b4d17a7,0x23b21f49,0x2cae284a,0x348130cc,
0x39903773,0x3b1f3ae1,0x38e33a5a,0x344b36d8,0x2e7f3175,0x282a2b63,0x22062501,0x1c8e1f31,
0x175a19ff,0x124514bf,0x0d930fe4,0x09850b76,0x056d0781,0x00fb0344,0xfba7fe76,0xf589f897,
0xf030f2b0,0xec76ee21,0xea76eb41,0xe999e9ec,0xe93de96a,0xe92ee929,0xe949e942,0xe962e94a,
0xea4ce9b6,0xeb72eaea,0xec37ebe0,0xec1dec58,0xeb7bebc1,0xeb3beb52,0xeb28eb32,0xeaf7eb0a,
0xeb6feb14,0xed0bec1a,0xef81ee35,0xf23cf0e1,0xf4bef37d,0xf75ef60f,0xf9def89f,0xfc64fb1a,
0xfeeafdb3,0x00dafff4,0x0223019f,0x026a0261,0x020c0246,0x01b001d8,0x01bf01a8,0x026601fd,
0x037802e8,0x04ca041d,0x06630585,0x08760767,0x0ac30999,0x0d290bf2,0x0fd60e6a,0x13a1118a,
0x18e31616,0x1f2e1bfa,0x256a225b,0x2ba82871,0x32162efd,0x35a23466,0x344635a2,0x2e2731c4,
0x243f2982,0x19481ec3,0x0e4013c3,0x02cd08a8,0xf6cefcc9,0xebdaf120,0xe2f1e71d,0xdb92df24,
0xd51cd831,0xd006d25c,0xcc2dce05,0xc939ca83,0xc7bfc85e,0xc65ec71e,0xc4a1c589,0xc34fc3d6,
0xc466c363,0xc923c659,0xd0b5cc9d,0xda60d55e,0xe47cdf7d,0xed1ce915,0xf425f0af,0xfb59f7bf,
0x0166fe91,0x05ed03e4,0x08e00790,0x0a7a09db,0x0b0f0ad5,0x0c280b64,0x0fae0d8b,0x157a1269,
0x1cb318d9,0x25bd211f,0x2ebd2a5a,0x3565328b,0x38583746,0x37bc3886,0x3426363c,0x2edc3197,
0x29342c10,0x23592648,0x1e042096,0x19151b8c,0x145716a5,0x0ff11217,0x0c1e0df1,0x08cf0a6b,
0x05880734,0x018503b3,0xfc10feea,0xf65ff92a,0xf199f3cf,0xee74efd2,0xec84ed5a,0xeb5bebe7,
0xea7eeade,0xea17ea3f,0xe9c8e9ed,0xe9ece9be,0xeaf4ea5a,0xec17eb8d,0xece9ec8d,0xecf7ed0e,
0xeccbecdc,0xec87ecb3,0xec1cec51,0xebeaebf5,0xec83ec11,0xedf9ed2c,0xefbceed4,0xf1a2f0b0,
0xf3b4f2a4,0xf5f0f4d0,0xf8aaf731,0xfbf0fa47,0xfec7fd70,0x00c7ffe8,0x01cd0166,0x01fa0201,
0x01ad01d0,0x01930195,0x01f001b0,0x02bc024b,0x03cb033c,0x051f0465,0x071a0605,0x09760844,
0x0bf00ab0,0x0ed50d4f,0x1286108b,0x179314dc,0x1de41a9c,0x248d2145,0x2b0b27c1,0x31b82e7e,
0x3606344d,0x357a367e,0x2fd2332d,0x26a22b8e,0x1c062174,0x10c11663,0x05090b01,0xf936ff0b,
0xee7ef3a5,0xe614e9f4,0xdf5be2a2,0xd947dc3c,0xd400d681,0xcff3d1d6,0xccb7ce3d,0xca5bcb76,
0xc828c947,0xc5a8c6ef,0xc387c478,0xc3a1c331,0xc6d8c4da,0xccf8c995,0xd55bd0ef,0xde8dd9f4,
0xe73be309,0xeedfeb1f,0xf6b7f2b6,0xfe85fac0,0x050f01f0,0x0a2107c4,0x0d720c18,0x0e750e2b,
0x0e4a0e61,0x0f900ea0,0x13a11140,0x19de167f,0x225c1dec,0x2ae326bb,0x31592e9b,0x34123318,
0x338f3435,0x30d03274,0x2bee2e81,0x26b22957,0x216c2406,0x1ced1f17,0x18fc1ae3,0x15301714,
0x11641353,0x0db70f79,0x0aa80c26,0x0794091f,0x03ef05e6,0xff5e01b3,0xfac0fd09,0xf68cf898,
0xf301f4a5,0xf06af197,0xeebcef7f,0xed9bee23,0xecbded25,0xebc3ec48,0xeaf5eb4f,0xeaeceacb,
0xec02eb54,0xed86ecd1,0xee55edf9,0xef12eeb7,0xef6eef4c,0xef27ef66,0xeec2eee8,0xeebbeeaf,
0xef59eef6,0xf05defd4,0xf179f0e5,0xf2a1f203,0xf3e4f34b,0xf59bf497,0xf845f6db,0xfb4ef9cb,
0xfddcfcad,0xff7bfed1,0x0000ffd4,0xfffe0007,0x000e0001,0x00490023,0x00f80097,0x01d5015f,
0x02f6025e,0x049503ac,0x072005c0,0x0a25089d,0x0d780bbb,0x119c0f6e,0x16a013ff,0x1c9a197c,
0x235c1fef,0x2a7126d8,0x317d2e1a,0x364e344c,0x36b23722,0x321034f9,0x29aa2e30,0x1f6924ba,
0x140419d1,0x07be0dfc,0xfb91018d,0xf0c1f5ef,0xe82fec26,0xe1a9e4cb,0xdbefdeb1,0xd724d968,
0xd379d535,0xd01bd1c9,0xccf0ce7c,0xc9bdcb60,0xc668c808,0xc3b9c4ea,0xc2f7c309,0xc4ebc38d,
0xc9d7c711,0xd0dfcd20,0xd92bd4f6,0xe1b5dd7a,0xe999e5bc,0xf12fed57,0xf937f527,0x00e0fd29,
0x081d047c,0x0ea90b9b,0x12901108,0x13541340,0x133c1330,0x150313c9,0x194216de,0x1fd31c48,
0x274a23a0,0x2d192a83,0x2fcd2ee2,0x2f872ffa,0x2cf92e86,0x28902aed,0x23602606,0x1e4e20c0,
0x1a531c26,0x175a18b8,0x14dc1610,0x126f13b6,0x0faa1108,0x0cf40e58,0x09df0b71,0x067b0846,
0x0265047d,0xfe6a005b,0xfad9fc9e,0xf744f908,0xf418f59a,0xf1ddf2d1,0xf097f133,0xef7cf002,
0xee2aeee1,0xecc2ed70,0xebc7ec2c,0xebdbebac,0xed0fec5c,0xee88edce,0xf01bef4e,0xf183f0db,
0xf267f20f,0xf257f274,0xf1ebf22d,0xf18df1a9,0xf192f18a,0xf1d0f1aa,0xf246f208,0xf2a7f277,
0xf358f2ea,0xf51df411,0xf7dbf667,0xfadcf95b,0xfd6bfc45,0xfea7fe3c,0xfee0fed9,0xff20feec,
0xff9cff5c,0x0043ffe0,0x015f00c9,0x027401ef,0x036702ec,0x050b041a,0x078c0636,0x0a8408fa,
0x0e660c54,0x132010ae,0x187615af,0x1e7a1b66,0x253521bc,0x2cb428eb,0x32e23025,0x355234b0,
0x32c834b1,0x2b932fa9,0x21e026e7,0x17561cb3,0x0c0211cf,0xffee0600,0xf4a8fa11,0xeb9befc7,
0xe519e810,0xe011e276,0xdbf1dde3,0xd8e5da42,0xd677d7b0,0xd3d5d52b,0xd06ad243,0xcc46ce5f,
0xc881ca41,0xc660c728,0xc68bc621,0xc980c7b1,0xceb9cbe1,0xd56bd1f4,0xdcc8d90c,0xe3f1e075,
0xeadde75d,0xf221ee79,0xf94ef5c3,0x0098fce5,0x0847046b,0x0efb0be0,0x132e1177,0x1503144c,
0x166f159b,0x198817c6,0x1e561bac,0x24a42173,0x2a19279f,0x2cde2bea,0x2c8f2d0a,0x2a192b94,
0x260d2835,0x212e23af,0x1c171e9c,0x180419db,0x15351675,0x13431431,0x1197126a,0x0fc510b2,
0x0dfa0edc,0x0bd60d01,0x090f0a85,0x05760756,0x01d70396,0xfef30053,0xfc33fd93,0xf970face,
0xf70ef825,0xf554f625,0xf3e1f48f,0xf253f32b,0xf041f156,0xee3aef32,0xecceed5e,0xec9aec8a,
0xed80ecf3,0xef05ee38,0xf10aeff9,0xf315f223,0xf464f3d8,0xf47cf496,0xf3e0f439,0xf326f378,
0xf2bdf2e9,0xf275f295,0xf23cf259,0xf1f0f211,0xf276f209,0xf43ef334,0xf6e3f582,0xf9b6f855,
0xfb93facd,0xfc7ffc23,0xfd29fcc7,0xfe00fd90,0xfee4fe72,0x0022ff73,0x01cd00ef,0x038202af,
0x0530044c,0x078f0646,0x0aab090a,0x0e770c79,0x133810bb,0x188b15de,0x1dae1b29,0x230a203b,
0x297a2624,0x2f202ca0,0x316030c5,0x2f9430fb,0x29e62d2e,0x21ac2604,0x18261cff,0x0e37133d,
0x038608fb,0xf85ffde4,0xef48f36f,0xe8d7ebd2,0xe3bae62b,0xdf7be186,0xdc43ddb2,0xd9e1db07,
0xd755d8af,0xd3ecd5c2,0xcfb8d1e0,0xcbe8cdac,0xc99fca82,0xc967c946,0xcb30ca0b,0xce97ccb7,
0xd33ed0cb,0xd8cdd5e7,0xdf10dbe6,0xe57ee23f,0xec56e8cf,0xf33cefd6,0xf9d5f68c,0x00f5fd3d,
0x09210508,0x10860d10,0x15991352,0x1930177d,0x1d021afa,0x21a11f47,0x267f240f,0x2a18289c,
0x2b6b2b01,0x2ab92b51,0x285d29bb,0x24442681,0x1f3021c6,0x19ee1c96,0x15341762,0x1216136d,
0x1097112f,0x0fc71027,0x0f250f71,0x0e8d0ede,0x0d6e0e1c,0x0b1a0c68,0x07d7098f,0x04710618,
0x01a302f5,0xff140064,0xfc17fd9e,0xf94afa9a,0xf74cf838,0xf5c3f679,0xf47bf51f,0xf2cbf3bc,
0xf0d6f1cc,0xef47efff,0xee59eeb6,0xee3fee32,0xef13ee85,0xf097efc9,0xf2cdf19e,0xf50df3fa,
0xf693f5fb,0xf6a0f6c3,0xf5bdf640,0xf4dff547,0xf43ef481,0xf3daf406,0xf374f3b1,0xf313f336,
0xf39af330,0xf532f44e,0xf728f623,0xf90ef834,0xfa0bf9a6,0xfa84fa45,0xfb37fada,0xfc02fb99,
0xfd36fc86,0xff13fe15,0x01380024,0x035d0249,0x05cb0484,0x08a8072a,0x0c290a4c,0x10a20e49,
0x161a1342,0x1b9f18f2,0x20861e19,0x264c2338,0x2c85298b,0x30362ecf,0x2fe1308c,0x2b332e1b,
0x23762788,0x1a901f18,0x114915fd,0x076d0c75,0xfc820210,0xf263f720,0xeb34ee77,0xe5dfe868,
0xe166e383,0xde41dfa3,0xdc92dd3f,0xdb9fdc23,0xd996dad1,0xd5dad7e4,0xd15dd39a,0xcdbbcf49,
0xcc5bccc3,0xcd40cc8b,0xcfc8ce57,0xd38bd18c,0xd7bcd59e,0xdc3ad9e9,0xe15cdeb8,0xe715e421,
0xed5aea3d,0xf34cf066,0xf967f633,0x00c4fced,0x088904ba,0x0f2e0c06,0x147911f9,0x19a316ef,
0x204b1ccd,0x276323de,0x2cf42a98,0x2edd2e4a,0x2dd02ebb,0x2a812c4d,0x25ad284c,0x1ffd22e3,
0x19d11ceb,0x142d16df,0x102611e8,0x0e4c0f02,0x0d890dd9,0x0d280d48,0x0d1e0d1f,0x0d020d23,
0x0bb40c92,0x09130a7e,0x05fe0784,0x035e0496,0x014b0252,0xfeee0029,0xfc4afd9b,0xf9ddfb03,
0xf802f8e1,0xf65bf72b,0xf4aff58b,0xf2b1f3b8,0xf0d9f1b3,0xef9df026,0xeeceef2b,0xeeb1eea3,
0xefa2ef03,0xf184f07c,0xf42cf2c1,0xf6d3f593,0xf86ff7d4,0xf87af897,0xf7e3f83f,0xf724f779,
0xf6aff6de,0xf661f686,0xf5e5f62c,0xf5a7f5a7,0xf663f5e9,0xf782f6f3,0xf87af80c,0xf8eaf8c4,
0xf905f8fa,0xf934f917,0xf998f962,0xfa32f9da,0xfb8cfabe,0xfdd2fc92,0x008aff25,0x038f0201,
0x06fb0540,0x0a9b08be,0x0efd0caa,0x1453118f,0x19e61729,0x1eb51c62,0x23a52112,0x28f92665,
0x2c9b2b2a,0x2cc22d22,0x29642b89,0x22f52673,0x1acc1f02,0x11fa166f,0x08ef0d7d,0xff4b0437,
0xf582fa47,0xee08f161,0xe8d0eb3c,0xe4c5e6b0,0xe1a2e30c,0xdfbfe08b,0xdefadf42,0xddc5de8b,
0xdb24dca2,0xd774d967,0xd3d5d587,0xd1e3d299,0xd200d1b4,0xd3add2ad,0xd658d4f2,0xd92bd7c3,
0xdc07da9a,0xdfa6ddb2,0xe40be1c7,0xe910e673,0xee6eebc7,0xf3a6f105,0xf9caf68a,0x0114fd5c,
0x083804c2,0x0e1b0b54,0x138010c0,0x1a8416ae,0x23091ec0,0x2ac32725,0x2ecb2d5f,0x2efd2f53,
0x2bd12db3,0x26f429a1,0x20b723e2,0x19db1d5e,0x13311667,0x0de01043,0x0b100c25,0x0a7a0a94,
0x0aba0a8d,0x0b7d0b06,0x0c6b0bf9,0x0ca10cb2,0x0b2c0c19,0x08f00a12,0x070207e4,0x05550631,
0x0322045c,0x004501b8,0xfd77fed7,0xfaf7fc27,0xf8cbf9dc,0xf6d4f7c5,0xf50af5f5,0xf344f419,
0xf1f5f28c,0xf135f186,0xf0eaf0f9,0xf11cf0f7,0xf22ff185,0xf438f313,0xf715f596,0xf9b1f882,
0xfaeafa81,0xfad8fafa,0xfa23fa8c,0xf94bf9b4,0xf846f8c7,0xf765f7e2,0xf667f6d7,0xf607f624,
0xf65bf624,0xf6b5f685,0xf6fcf6e9,0xf6def6f0,0xf6d9f6d2,0xf72af6fe,0xf77df74c,0xf84ef7cf,
0xf9f8f909,0xfc53fb12,0xff5ffdc3,0x0331012d,0x0783054d,0x0c3909d0,0x11750ebf,0x174f145c,
0x1c991a19,0x21201ee2,0x262f238a,0x2ac828ba,0x2c622c10,0x2a5f2bd1,0x24df2800,0x1d542140,
0x150e1938,0x0c9610ec,0x03400809,0xf94ffe44,0xf0b9f4b5,0xead2ed6f,0xe689e89d,0xe2e5e494,
0xe10ce1b8,0xe0b8e0ba,0xe0bbe0c6,0xdfb5e06a,0xdce7de89,0xd928db05,0xd642d77e,0xd569d584,
0xd685d5c8,0xd8a4d780,0xdb34d9ea,0xdd9fdc71,0xdff1debd,0xe2e4e158,0xe6b2e4aa,0xead8e8d2,
0xeeb7ecc0,0xf3b2f0fa,0xfa36f6ce,0x0112fdb3,0x06ef0423,0x0bef0976,0x11e00ea6,0x1a2515c4,
0x23d11ef1,0x2b5a281c,0x2ecc2d8c,0x2dff2eee,0x2a2a2c60,0x2417274a,0x1cec20a5,0x157f192b,
0x0ecb1202,0x0a3b0c23,0x08850915,0x084b084d,0x08e8087f,0x0a4d0984,0x0bc20b17,0x0c080c1b,
0x0af00b8d,0x09920a40,0x089c0904,0x07b50842,0x05b706da,0x03170471,0x007201be,0xfdc6ff22,
0xfb0bfc6a,0xf857f9af,0xf5d1f707,0xf3e6f4c7,0xf297f32e,0xf198f20e,0xf11ff14a,0xf196f12f,
0xf33ff24c,0xf591f45c,0xf830f6dd,0xfa3df95e,0xfae0fabb,0xfa96facd,0xfa03fa50,0xf96cf9bb,
0xf8aef916,0xf7b9f834,0xf724f759,0xf731f719,0xf771f753,0xf77df785,0xf71bf753,0xf69cf6d9,
0xf62cf661,0xf5a9f5ee,0xf547f56a,0xf5dbf565,0xf7caf6b1,0xfa83f914,0xfe39fc3c,0x02c60067,
0x07e10542,0x0d8e0aa9,0x13c91095,0x1a0516fe,0x1f461cc6,0x243321a8,0x298526ee,0x2ca92b8c,
0x2be22cc2,0x27c62a3b,0x20c4248c,0x18681ca2,0x0ffc1428,0x075b0bbf,0xfdcf02b0,0xf451f8e9,
0xed35f065,0xe873eaa7,0xe495e667,0xe21ae316,0xe1dee1b7,0xe2f4e256,0xe398e36e,0xe283e352,
0xdf71e130,0xdbeddd99,0xda03dab8,0xda17d9cf,0xdb77dab2,0xdd32dc4c,0xded9de0f,0xe01ddf89,
0xe18de0c6,0xe3bde284,0xe6cfe539,0xe9dbe853,0xed84eb82,0xf31ff00d,0xf9f4f680,0x006afd4a,
0x05e30345,0x0b130864,0x12050e3d,0x1b3f1669,0x24e02040,0x2b46289e,0x2d702cdb,0x2c272d1d,
0x28052a79,0x21ce2510,0x1a1a1e11,0x12271620,0x0b570e75,0x076c08f7,0x065c06a1,0x0698065c,
0x07af070b,0x098a0888,0x0b1e0a7b,0x0b240b53,0x0a4f0ac0,0x09b109f2,0x098d099b,0x08d30954,
0x07320816,0x04ff0623,0x029303d4,0xffbe0135,0xfc64fe20,0xf8e5faa4,0xf5ccf744,0xf380f482,
0xf24cf2cc,0xf1d8f1f7,0xf23af1ec,0xf3ccf2dc,0xf651f4ff,0xf8fbf7a6,0xfb53fa40,0xfc89fc13,
0xfc73fca5,0xfbc4fc20,0xfae0fb59,0xf9dafa62,0xf893f93b,0xf790f800,0xf71ef746,0xf70bf70c,
0xf6ecf709,0xf63ff6ab,0xf51ff5b4,0xf436f497,0xf385f3e8,0xf2acf317,0xf264f262,0xf384f2c2,
0xf5e2f48b,0xf97cf785,0xfe6cfbd1,0x047b0152,0x0b6607d7,0x12f50f20,0x1a8f16de,0x20c71dd7,
0x25f32370,0x2aa2286b,0x2d392c52,0x2be42d17,0x271a29dc,0x201323be,0x18041c2e,0x0fc613d5,
0x07e80bd1,0xff7a03db,0xf64cfad6,0xeed2f23e,0xe998ebf3,0xe5b6e790,0xe2b1e401,0xe1e9e200,
0xe323e25a,0xe486e3f5,0xe488e4be,0xe2dee3e7,0xe00ee183,0xde2cdee0,0xde92de0f,0xe0a3df82,
0xe29de1ba,0xe3a1e336,0xe43ee3f6,0xe4ffe48f,0xe666e59d,0xe84ee750,0xe9f0e934,0xeb75ea94,
0xef03ece4,0xf4f4f1c5,0xfb60f83c,0x0120fe58,0x066403bd,0x0c99093d,0x14d01087,0x1db8194b,
0x246b2198,0x27312632,0x2709276c,0x24fd263f,0x20b42311,0x1ad81dfb,0x13f91779,0x0cf9106a,
0x078109ee,0x04ce05ca,0x040e0450,0x04930427,0x063a0542,0x08640753,0x09b9093a,0x0a2b09fb,
0x0aa20a5b,0x0b9c0b11,0x0c470c11,0x0bb90c20,0x0a5c0b20,0x086f0974,0x05da0742,0x0241042c,
0xfdf1002a,0xf994fbaf,0xf623f7c0,0xf3cbf4ca,0xf293f315,0xf264f25c,0xf36ff2bc,0xf5cff47b,
0xf8cbf74b,0xfba5fa41,0xfda9fcd8,0xfe28fe14,0xfd81fdf6,0xfc54fced,0xfb18fbb6,0xf9d5fa7b,
0xf894f930,0xf7def820,0xf793f7b2,0xf742f771,0xf6b4f706,0xf593f633,0xf43cf4e6,0xf32df3ab,
0xf20ef2aa,0xf0f7f16f,0xf110f0d5,0xf253f194,0xf4c7f361,0xf8a9f688,0xfe13fb2e,0x04f30159,
0x0ce108d0,0x156c111b,0x1d4d198d,0x23a620a0,0x2955268e,0x2d8f2bc4,0x2e1a2e64,0x2a5c2cb7,
0x235c2724,0x1b031f41,0x126416b3,0x0a320e37,0x023c0641,0xf984fdfa,0xf137f521,0xeb61ee00,
0xe763e93e,0xe409e5a1,0xe234e2cb,0xe2e6e240,0xe512e3fb,0xe653e5e1,0xe5e7e655,0xe3dbe50d,
0xe191e296,0xe130e108,0xe342e201,0xe605e4aa,0xe7dee718,0xe8a7e860,0xe8cde8bf,0xe927e8ef,
0xe9bee964,0xea64ea2b,0xea23ea49,0xeaefea39,0xeed0ec7f,0xf4abf19e,0xfa90f7b5,0xffb6fd36,
0x0548024e,0x0d2e08e6,0x16bc11df,0x1f641b69,0x23e1223f,0x244b247d,0x226e2388,0x1f3f210b,
0x1ae51d26,0x15a91861,0x0fe012d1,0x0a4e0cf8,0x06460803,0x045c0520,0x038d03cf,0x0411039d,
0x060004e6,0x08270729,0x094f08d4,0x0a2509b9,0x0b640ab6,0x0cc00c1d,0x0d5e0d31,0x0d430d5f,
0x0ca80d09,0x0b4f0c1f,0x08890a1e,0x04530697,0xff1401c6,0xf9fcfc69,0xf600f7d5,0xf367f48c,
0xf246f2a4,0xf2bdf249,0xf4bcf391,0xf7dff638,0xfb46f998,0xfe43fcdd,0xffd7ff49,0xffc6fffb,
0xfe91ff3d,0xfd1bfdde,0xfb8efc4a,0xfa23fadc,0xf901f97b,0xf880f8b6,0xf83af85b,0xf7a8f803,
0xf677f723,0xf4d2f5ad,0xf368f408,0xf256f2df,0xf13cf1c7,0xf087f0c4,0xf0d8f092,0xf221f159,
0xf4d0f340,0xf920f6cc,0xff08fbdc,0x067d0296,0x0f250ab3,0x17ee13a0,0x1f9d1be9,0x26622316,
0x2bde2968,0x2e292d7f,0x2bfe2da2,0x25eb2962,0x1d8a21da,0x14c11927,0x0c4c1072,0x04740854,
0xfc72008b,0xf3fef82c,0xed01f035,0xe859ea6e,0xe4dde68b,0xe1f6e343,0xe123e138,0xe2c4e1b5,
0xe4e9e3ec,0xe617e5a6,0xe61be639,0xe50de5ae,0xe46ae487,0xe61ae4ed,0xe999e7c2,0xec9eeb4b,
0xee15ed89,0xee6cee5a,0xee5eee60,0xee3fee53,0xee02ee26,0xed18edae,0xeb97ec47,0xec48eb7d,
0xf075ee00,0xf63cf34c,0xfbc4f914,0x0121fe63,0x07de043a,0x109c0c17,0x1975151e,0x1fb21d2b,
0x212a20f6,0x1f15206f,0x1b9b1d7c,0x16ed195f,0x11f11475,0x0d000f6b,0x088b0ab8,0x04e70692,
0x02e903af,0x020f0268,0x01ee01e5,0x02db023e,0x04c303be,0x067305b3,0x07c8071a,0x0947087a,
0x0b630a4b,0x0d3a0c67,0x0e6c0dde,0x0f650ef2,0x0ffb0fc9,0x0f4e0fde,0x0c9b0e37,0x07ec0a87,
0x01c104e6,0xfbd3feae,0xf74ef95d,0xf454f59b,0xf313f37c,0xf3e6f334,0xf682f506,0xfa2af84c,
0xfdbdfbfc,0x009aff51,0x01c40168,0x018701d3,0x005400f4,0xfee2ffa6,0xfd56fe1f,0xfb81fc6b,
0xfa2afabf,0xf97cf9c4,0xf8eff93e,0xf7e9f884,0xf622f716,0xf412f518,0xf25df327,0xf0faf1a2,
0xefdef05d,0xef5eef86,0xefa2ef68,0xf0c5f00c,0xf36ef1df,0xf7ddf56e,0xfde9fab3,0x05800184,
0x0e5609ce,0x174c12ee,0x1f501b65,0x26c02319,0x2c902a05,0x2e432e07,0x2afa2d42,0x234f278b,
0x19e31eab,0x10961531,0x07f10c2a,0xffdb03e4,0xf78dfbc2,0xefc6f375,0xea53ecb7,0xe70ae885,
0xe478e5b2,0xe29ae356,0xe2eee273,0xe54fe3fb,0xe783e68f,0xe89ae831,0xe888e8b7,0xe7a2e819,
0xe7e7e782,0xea4de8df,0xedfeec16,0xf107efac,0xf268f1eb,0xf29ef29b,0xf245f27f,0xf193f1f9,
0xf058f10d,0xee01ef52,0xeba4ec97,0xec4feb7f,0xf058edfe,0xf5d6f313,0xfb23f888,0x00cdfdcc,
0x087a0456,0x11e80d17,0x1abe16a0,0x1f881dc8,0x1f5b2003,0x1be21ddf,0x16ba197a,0x10d113c7,
0x0b060ddb,0x0632087b,0x02a9043d,0x00f1018d,0x00a700b7,0x00b000a8,0x00fd00c3,0x024d0179,
0x044d034e,0x05fa052f,0x07bb06c8,0x0a2808d7,0x0cd80b89,0x0efc0e02,0x10ce0fe6,0x126b11a0,
0x13991322,0x131913a6,0x100b11e4,0x0a870d91,0x03ab0726,0xfd2a0049,0xf7fdfa66,0xf460f5f6,
0xf2cef34b,0xf3bdf2f6,0xf6a2f507,0xfa68f875,0xfe24fc59,0x011cffc1,0x02a00214,0x029302c6,
0x01880221,0xffe500cb,0xfde0fee7,0xfbf2fcda,0xfa8ffb2c,0xf9a5fa12,0xf8c8f935,0xf75ef82d,
0xf575f675,0xf36ef468,0xf1b9f284,0xf065f109,0xef8eefde,0xef7def74,0xefd7ef97,0xf13ef060,
0xf443f285,0xf959f68c,0x009bfcaf,0x09c404fd,0x138c0eb7,0x1c7e1814,0x252220e1,0x2c3b2909,
0x2f382e5d,0x2ccc2eb4,0x257629a2,0x1b5b2091,0x10f61614,0x07880c1b,0xfeef032b,0xf666faba,
0xee33f21f,0xe850eaeb,0xe4c9e64d,0xe2a8e3a4,0xe11fe1c9,0xe106e0d6,0xe2f2e1c6,0xe56fe43b,
0xe768e67b,0xe8c0e82e,0xe96ce922,0xea62e9cb,0xed29eb76,0xf1dcef5d,0xf674f456,0xf8d7f7ee,
0xf955f944,0xf951f953,0xf91cf948,0xf84ef8d0,0xf5c3f757,0xf14ff3a6,0xee25ef4d,0xeee1ee07,
0xf27af074,0xf716f4bc,0xfc20f978,0x0316ff4a,0x0bf70769,0x14dc108e,0x1ac21867,0x1c341c01,
0x19c51b5e,0x151117a9,0x0edd120d,0x07fa0b7e,0x01b604a8,0xfd21ff2b,0xfaf6fbc0,0xfafcfaba,
0xfc34fb87,0xfdd0fcf6,0xff8efead,0x0199008d,0x035a0287,0x057f0453,0x086906dc,0x0bac0a05,
0x0e980d46,0x10b90fac,0x12ee11d1,0x153b1413,0x16ad162d,0x161016a4,0x12e514cf,0x0d761067,
0x07030a4b,0x00c303c7,0xfb83fdfa,0xf794f95c,0xf5c9f65c,0xf68cf5e2,0xf938f7b9,0xfc6ffad4,
0xff73fdff,0x01da00c5,0x030a029a,0x02f50328,0x0205028c,0x00600149,0xfe22ff4a,0xfc08fd0b,
0xfa40fb1c,0xf8ccf97d,0xf756f81d,0xf575f66c,0xf380f47f,0xf18df280,0xefdaf0ab,0xeed1ef34,
0xeec3eeb0,0xef31eef4,0xeffaef79,0xf1e7f0c9,0xf54bf360,0xfa65f79a,0x0193fdb4,0x0ad60601,
0x14720fba,0x1d6018f4,0x262a21d1,0x2cec2a05,0x2ecb2e90,0x2b0a2d96,0x22612735,0x17a11d0e,
0x0d451252,0x04340899,0xfb98ffeb,0xf28af719,0xea92ee40,0xe598e7b8,0xe2c9e401,0xe109e1d6,
0xe039e076,0xe128e06c,0xe3bce25a,0xe66be525,0xe899e78f,0xea18e972,0xeb2dea99,0xed0febf3,
0xf0ddeeb1,0xf61af373,0xfa44f87c,0xfc22fb6f,0xfcaafc75,0xfce7fcd0,0xfca8fcdc,0xfb45fc2f,
0xf78af9c0,0xf268f4f0,0xef5df06d,0xf049ef62,0xf38ef1bd,0xf7a0f589,0xfce6fa07,0x0478005d,
0x0d7308f1,0x156b11bd,0x19a81817,0x197b1a25,0x160417fa,0x10641380,0x09230ce4,0x019c0553,
0xfb18fe25,0xf6e3f899,0xf5c1f5f6,0xf6edf62e,0xf904f7d9,0xfbb4fa4b,0xfeabfd2f,0x01670020,
0x03a80289,0x062904dd,0x095d07ac,0x0cc80b1c,0x0fbd0e57,0x12641116,0x151c13ba,0x17c41682,
0x193818b6,0x185f1921,0x14cc16e4,0x0f54123b,0x08f20c2e,0x028605b1,0xfcb2ff7e,0xf83bfa3b,
0xf637f6e0,0xf6d1f638,0xf938f7dd,0xfc36faba,0xff12fda2,0x017e0066,0x02f90255,0x037e035d,
0x032c036e,0x01bc0298,0xffb000bc,0xfdb7fea8,0xfc03fcda,0xfa58fb33,0xf843f95f,0xf5e0f70e,
0xf3d6f4cb,0xf1edf2e8,0xf041f102,0xef7befb4,0xefc3ef8b,0xf048f002,0xf164f0b7,0xf3b7f269,
0xf73cf54c,0xfc80f99a,0x04180002,0x0d5f08aa,0x165411ef,0x1efd1aa7,0x270a233f,0x2b9829ec,
0x2ae22bee,0x2531289d,0x1bbe20c7,0x113b1678,0x07680c3a,0xfe1002b6,0xf481f962,0xeb03ef99,
0xe416e71c,0xe05ee1e0,0xde9adf53,0xde0dde28,0xdef1de50,0xe157dff7,0xe45fe2d8,0xe725e5d6,
0xe94ae845,0xeb1eea40,0xed35ec12,0xf0b7eeb2,0xf64cf34b,0xfc4ff967,0x006afeb1,0x021e017e,
0x02f0028d,0x032f0327,0x02a50308,0x005701ca,0xfb67fe2f,0xf5f2f87e,0xf303f412,0xf347f2cc,
0xf5baf44f,0xf97af769,0xff5efc1a,0x07620337,0x0f9d0b9d,0x153a12eb,0x17151696,0x15331699,
0x1087132f,0x09800d3b,0x01750584,0xf9a6fd77,0xf364f638,0xeffcf14c,0xef57ef5f,0xf084efc2,
0xf302f19c,0xf6b2f4b9,0xfb27f8e7,0xfef3fd29,0x027600b1,0x06370443,0x0a62084b,0x0e960c82,
0x12961093,0x1673148d,0x1a3e185a,0x1d2e1be7,0x1e2e1dfb,0x1c9c1dba,0x18bb1ae0,0x13601635,
0x0d1e1055,0x066809c8,0x001a0324,0xfb3ffd6f,0xf8e1f9b4,0xf92af8be,0xfae9f9f2,0xfcf8fbef,
0xfefdfdf5,0x00e50009,0x021d0195,0x02770267,0x01f00256,0x005d013d,0xfe67ff68,0xfc83fd73,
0xfab3fb94,0xf8c8f9cf,0xf676f7a5,0xf430f54b,0xf257f339,0xf093f173,0xef34efc8,0xeeebeeef,
0xef50ef11,0xf03befb2,0xf1fcf0fc,0xf4bef340,0xf8d6f68d,0xff32fbb6,0x07c30340,0x10fc0c6d,
0x19bb155f,0x22461e14,0x28c625f7,0x2ab12a60,0x278f29b8,0x20152449,0x16461b4f,0x0c44112c,
0x02cd077f,0xf92cfe15,0xef1ef421,0xe6a0ea86,0xe13be389,0xde5adf93,0xdcefdd7a,0xdd34dcd3,
0xdf25de01,0xe214e08e,0xe4f2e391,0xe764e63c,0xe97ae875,0xeba0ea78,0xeecfed0d,0xf401f11c,
0xfac6f74f,0x0109fe1c,0x04f80351,0x06df0614,0x07e90774,0x08230827,0x06d507c2,0x02d30533,
0xfcdbfff0,0xf782f9f3,0xf4def5c4,0xf50ef4b1,0xf72df5e1,0xfb73f900,0x0231fe90,0x0a050618,
0x10b00dae,0x13fc12c3,0x13c4145b,0x10581255,0x0aa80dce,0x034d0724,0xfb46ff44,0xf408f779,
0xeef3f121,0xec98ed77,0xec39ec40,0xed22ec7f,0xef97ee28,0xf36cf15b,0xf7cff5a5,0xfc4ffa00,
0x0110fea8,0x060d038e,0x0b08088b,0x0fa40d69,0x140211d5,0x1861162a,0x1c551a77,0x1f091de5,
0x1fab1fa5,0x1dd71f0b,0x1a5d1c41,0x15cc1838,0x10181315,0x09a60ced,0x034d065b,0xfe8b00ab,
0xfc1ffd04,0xfbe8fbc9,0xfcf8fc5c,0xfe5cfda4,0x0021ff30,0x01c20103,0x02d60261,0x0316030c,
0x026c02e7,0x00f901b8,0xff2c0020,0xfd37fe33,0xfb25fc33,0xf885f9ee,0xf5b3f718,0xf349f46f,
0xf132f235,0xef68f03a,0xee73eecc,0xee56ee51,0xeea1ee69,0xefebef1f,0xf252f0fc,0xf5c7f3e9,
0xfafef815,0x02b9fe91,0x0bda073e,0x14fb106d,0x1df61984,0x2584221e,0x28e327d9,0x270d2899,
0x21062479,0x18781cf2,0x0f2213c8,0x060f0a95,0xfd05019a,0xf33af837,0xe9c4ee4f,0xe2bee5dc,
0xde6ae04f,0xdc0edd06,0xdb6cdb7f,0xdca4dbd9,0xdf1fddc9,0xe1cae07a,0xe444e30c,0xe6aae578,
0xe974e7f4,0xed47eb3c,0xf282efad,0xf973f5cf,0x0098fd24,0x0612039c,0x092407e3,0x0ae90a1b,
0x0c100b93,0x0c1e0c4b,0x09e10b5b,0x04f807af,0xff33020b,0xfa88fca7,0xf821f904,0xf826f7e2,
0xfaa2f905,0x002dfd06,0x077403ce,0x0dc40ad7,0x111a0fe8,0x1170118a,0x0f5910b7,0x0af70d75,
0x046207e7,0xfc5e007e,0xf452f844,0xed90f0a7,0xe957eb1f,0xe762e82a,0xe6bde6e2,0xe7b8e702,
0xea51e8d0,0xee3cec30,0xf29ff061,0xf812f52b,0xfec9fb4b,0x05c70252,0x0c23091a,0x11a10eea,
0x16c11444,0x1bb5193f,0x1fe11dfa,0x2229214a,0x2234227a,0x20202158,0x1ced1ea8,0x18b81af8,
0x13571628,0x0d1d1048,0x07190a00,0x02a904a3,0x00440134,0xffaeffce,0xfff4ffc2,0x0076002a,
0x017600f1,0x026901f5,0x030002cc,0x02a802ec,0x019c023b,0xfffe00d3,0xfe30ff24,0xfc2afd33,
0xf9fdfb1e,0xf77cf8bf,0xf4f1f634,0xf28ef3ba,0xf089f17d,0xef28efb5,0xeed3eee9,0xeef2eedb,
0xef80ef22,0xf0eff01a,0xf36ff20a,0xf73ff524,0xfd2bf9e7,0x05480103,0x0e2709ba,0x16e31285,
0x1f6b1b41,0x258422f4,0x26dd26dc,0x233d25a3,0x1bc41fd4,0x12f7176d,0x0a450e8b,0x01fc0622,
0xf8defd9f,0xee85f3b9,0xe568e9a7,0xdf06e1df,0xdafbdcbd,0xd8dbd9af,0xd91cd8a8,0xdb80da1b,
0xdeb5dd19,0xe193e030,0xe430e2e6,0xe694e565,0xe995e7e9,0xee24eba1,0xf4b1f12d,0xfc8bf88b,
0x042f007e,0x0a240773,0x0e1c0c53,0x10a80f8d,0x11ed116f,0x115c11f9,0x0dd70ff6,0x08660b40,
0x02aa057c,0xfddb0010,0xfaf5fc24,0xfa96fa64,0xfd8ffba3,0x03890047,0x0a3106ed,0x0f270d0e,
0x10c71057,0x0f8a108a,0x0bbf0de8,0x05c208fa,0xfe480231,0xf602fa26,0xee5af207,0xe8b0eb31,
0xe565e6c8,0xe36ae451,0xe28ee2ca,0xe364e2c1,0xe5cbe46b,0xe90ce751,0xedafeb22,0xf425f0b6,
0xfbd9f7e0,0x0405fff6,0x0ba007e2,0x12ae0f41,0x192315ec,0x1eec1c32,0x23222143,0x2534247a,
0x24ed2555,0x232a242f,0x206e21e9,0x1c5f1e97,0x16f019c9,0x10e213eb,0x0b620e00,0x07210917,
0x04710594,0x031a03a4,0x026b02b2,0x023f0241,0x02b70269,0x032102fb,0x030c0333,0x021102a1,
0x00b00174,0xfee0ffd2,0xfcbdfddd,0xfa79fb9e,0xf7f8f93e,0xf56cf6a9,0xf339f44d,0xf108f220,
0xef3df008,0xee6ceeb4,0xee62ee59,0xeeadee73,0xefbbef17,0xf1a2f090,0xf4e7f312,0xf9f3f72d,
0x0132fd4c,0x09e7057b,0x12f30e66,0x1c01178b,0x2389201f,0x26ea25e7,0x24cb267e,0x1e1621eb,
0x151e19b8,0x0beb1077,0x035f0792,0xfa78ff14,0xf031f56e,0xe6a0eb21,0xdf6fe2b8,0xda85dcbf,
0xd744d8af,0xd698d67f,0xd8c9d76b,0xdc58da85,0xdfc1de16,0xe2c4e158,0xe50de3fb,0xe773e61c,
0xeb95e941,0xf1c4ee6f,0xf983f586,0x01adfd99,0x0954059b,0x0f8f0ca9,0x13f011f5,0x16fb15a0,
0x181b17e4,0x16161780,0x1191140c,0x0c000ed9,0x0609090b,0x006f0318,0xfcd1fe47,0xfcd5fc4e,
0x0117fe81,0x07970434,0x0d630acc,0x0fbb0f0e,0x0e780f75,0x0abd0cd7,0x05310839,0xfe0d01c2,
0xf5d9fa0e,0xedaff1b4,0xe6ebe9fb,0xe2cce48f,0xe08fe188,0xdf4edfcf,0xdf37df10,0xe0aadfc5,
0xe2d3e1bb,0xe596e40b,0xea4fe7ae,0xf126ed72,0xf98df536,0x0267fdfa,0x0b6a06e6,0x14060fca,
0x1be51821,0x22331f45,0x2668249f,0x284e279e,0x28332877,0x26c6279e,0x242225a4,0x200c2242,
0x1ad81d8e,0x156e181c,0x108b12e5,0x0c810e67,0x09820ae2,0x0742084e,0x05880655,0x047904eb,
0x042a043d,0x03cb0411,0x02b00357,0x010301da,0xff300025,0xfd24fe2e,0xfaf7fc12,0xf891f9ca,
0xf605f748,0xf3caf4d9,0xf1ebf2d8,0xf029f100,0xef03ef7b,0xee86eeb3,0xee6fee74,0xeef1ee92,
0xf06def90,0xf2cbf178,0xf6b0f47c,0xfcddf981,0x04d900b1,0x0dae0931,0x17031247,0x20021bb7,
0x2593236a,0x257b2644,0x20212366,0x175a1bf7,0x0de9129d,0x04d7094d,0xfc0b0079,0xf246f74a,
0xe884ed34,0xe114e477,0xdbd4de40,0xd7c4d9ae,0xd596d647,0xd6c7d5c9,0xda1ad856,0xdd92dbe4,
0xe08bdf1f,0xe2c2e1bd,0xe4dae3be,0xe83de64d,0xee09ead7,0xf5bff1bd,0xfe1ff9ea,0x065d0248,
0x0dfe0a48,0x14451158,0x190216cd,0x1c321ae1,0x1c4a1cb6,0x194e1b14,0x14cb172a,0x0f53122f,
0x08df0c2e,0x02d305a6,0xffe000ca,0x014e000e,0x06240371,0x0ba10903,0x0e6e0d83,0x0d6f0e67,
0x09840bb9,0x04480710,0xfda0011b,0xf60ef9f0,0xee21f210,0xe6fcea5c,0xe1b4e415,0xde5fdfd4,
0xdc54dd37,0xdb81dbbf,0xdc75dbbd,0xde73dd6e,0xe078df73,0xe36fe1be,0xe874e5a3,0xefb5ebdd,
0xf838f3db,0x015ffcb2,0x0b190635,0x14e8100b,0x1dbc1984,0x249c2180,0x28c326fe,0x2aac29fb,
0x2ac92ae7,0x296b2a4f,0x2667281e,0x2216245f,0x1d351fab,0x183a1ab0,0x13b115e2,0x0ffa11c2,
0x0ccb0e54,0x09fe0b55,0x07e708da,0x06920722,0x05c70627,0x04ad054b,0x030d03e6,0x01440236,
0xff2e0041,0xfcf4fe11,0xfa6dfbbf,0xf7a6f907,0xf50ef64e,0xf2fdf3f8,0xf145f215,0xeff7f087,
0xef6aefa0,0xef08ef39,0xeea2eecc,0xeefceeac,0xf043ef83,0xf2b5f149,0xf70af49f,0xfd5cf9f4,
0x055c012d,0x0e6509c1,0x1830133f,0x20f31ceb,0x252e23c7,0x238d2514,0x1cee20c7,0x13b21872,
0x0a430eec,0x00ee05a1,0xf6e3fc0e,0xec55f18e,0xe32fe775,0xdc95df94,0xd7f6da18,0xd4f4d62b,
0xd4c6d46d,0xd79cd5f1,0xdbb0d991,0xdf8bddbe,0xe201e0f4,0xe37fe2ca,0xe563e44a,0xe97fe716,
0xf02fec96,0xf85cf42d,0x013cfcb7,0x0a4d05d0,0x12700e8a,0x190015ef,0x1df41bb3,0x20931fa8,
0x200c20ae,0x1d2d1ed7,0x188b1b12,0x11fa1581,0x0a3a0e21,0x03dc06ad,0x015c020c,0x035401cb,
0x086f05ac,0x0d460b23,0x0e790e6d,0x0bb70d80,0x06920956,0x00260383,0xf8c3fc93,0xf0a2f4b1,
0xe8abec93,0xe228e52d,0xdd88df9c,0xda9bdbe4,0xd8d9d996,0xd8a0d87f,0xda20d939,0xdc18db26,
0xddd0dcf5,0xe045ded3,0xe544e26c,0xec70e8a2,0xf4fbf090,0xfeaff9b6,0x092f03d6,0x13dd0e97,
0x1dd51903,0x25872208,0x2a77284f,0x2d1f2c06,0x2e302de1,0x2d302df1,0x2a312be1,0x261e2836,
0x217923e1,0x1c921f01,0x18221a45,0x14421625,0x10c21271,0x0ddc0f3b,0x0baf0caf,0x0a130adb,
0x082d0938,0x058806ed,0x0285040e,0xffaa0103,0xfd55fe7d,0xfadffc1c,0xf80cf989,0xf51cf689,
0xf2c9f3d9,0xf100f1d8,0xefb2f044,0xef1def59,0xeee5eef6,0xeebceed5,0xeeffeec3,0xf017ef6e,
0xf259f10b,0xf666f423,0xfc1ef911,0x0316ff7a,0x0afe06e8,0x143a0f73,0x1d59190b,0x22b020a9,
0x22a5235c,0x1d56209a,0x149f1930,0x0b430fec,0x022106b3,0xf883fd71,0xee33f360,0xe4c4e933,
0xddebe107,0xd91ddb4d,0xd5d7d747,0xd4bad4fa,0xd62ad523,0xd970d7a8,0xdd0edb53,0xdf5cde67,
0xe094e002,0xe22ae13f,0xe588e388,0xebcbe84c,0xf42eefdd,0xfd14f89d,0x06140192,0x0eee0a92,
0x16d5130c,0x1d4a1a45,0x21a01fca,0x231022b8,0x223c22d6,0x1fda2143,0x1b871df6,0x1520188c,
0x0e001181,0x09170b14,0x0851082f,0x0b3d0960,0x0f450d62,0x10ae107c,0x0de60fcc,0x081b0b39,
0x00fb04ad,0xf93cfd2b,0xf0dff51f,0xe8bdecb7,0xe18fe4f3,0xdc00de97,0xd818d9d6,0xd5bed6bb,
0xd50dd52b,0xd60fd565,0xd7fad6f9,0xd9aed8e7,0xdb57da6e,0xdeb9dcb1,0xe49ae169,0xebfee82c,
0xf472f01a,0xfde1f90a,0x082202f3,0x12a40d62,0x1c4d17ac,0x24262072,0x2a13275f,0x2e232c51,
0x30082f65,0x2fa9301b,0x2d6a2eae,0x2a232bef,0x25c9280b,0x21202375,0x1cb41edc,0x18971a9d,
0x14db16a8,0x11a3132c,0x0f321052,0x0d000e1f,0x0a2b0bb3,0x06c20884,0x034404fb,0x003501a5,
0xfd90fee7,0xfa8cfc21,0xf712f8d2,0xf407f570,0xf1c5f2d1,0xf02ef0e0,0xef83efbf,0xef53ef5d,
0xef46ef4a,0xef3aef38,0xefa8ef61,0xf0f8f02a,0xf3e9f234,0xf8acf615,0xfeb2fb93,0x056001fa,
0x0d000901,0x15d51159,0x1d4519f9,0x20301f65,0x1de51fab,0x17281af3,0x0e7212dc,0x05c40a17,
0xfc8f014e,0xf26bf790,0xe878ed54,0xe03be40f,0xda45dcfe,0xd619d7f7,0xd3ebd4b6,0xd469d3d3,
0xd6f7d576,0xdabfd8cf,0xddcedc83,0xdf12de99,0xe039df8e,0xe2b2e139,0xe774e4c1,0xeebeead7,
0xf767f2f8,0x006cfbe7,0x098004f9,0x12460df1,0x1a4b166f,0x20701dad,0x23e82282,0x254c24cc,
0x2527256b,0x2319246a,0x1ea2212a,0x18271b92,0x11a614b2,0x0dbb0f41,0x0da30d36,0x10520ec8,
0x127411b5,0x10f2123a,0x0bed0ec8,0x04da0895,0xfcc600d3,0xf4b4f8c8,0xec59f081,0xe47de851,
0xdd74e0da,0xd771da48,0xd2fdd501,0xd0b3d189,0xd0cbd075,0xd2a9d193,0xd518d3e4,0xd70ad623,
0xd952d804,0xdd7bdb22,0xe37ce04b,0xea98e6e9,0xf2cfee93,0xfc02f74d,0x05d200d5,0x0ffa0aea,
0x197914e0,0x21991db4,0x28722527,0x2dc92b5f,0x30e32fa2,0x31b9318e,0x30d5317a,0x2e1f2fb5,
0x2a042c30,0x256827bc,0x20de231a,0x1c921eb1,0x18a21a8f,0x154416df,0x128113d7,0x0fa31126,
0x0c0c0de8,0x08170a13,0x046e0637,0x012f02c9,0xfdcdff88,0xf9fdfbe9,0xf636f809,0xf332f49b,
0xf107f200,0xefd6f04f,0xef5bef87,0xef57ef4b,0xef96ef6c,0xf046efdc,0xf181f0cd,0xf437f299,
0xf905f662,0xff4bfc0f,0x05b0028c,0x0c2c08d6,0x13a20fcd,0x1a20173d,0x1c8c1bec,0x1a611c06,
0x142717ac,0x0be11028,0x03630796,0xfaf6ff33,0xf1cdf685,0xe856ecfb,0xe0a8e439,0xdaa0dd7a,
0xd5a0d7fe,0xd256d3aa,0xd1e2d1b8,0xd3d5d2a8,0xd6e3d547,0xda0fd889,0xdbe4db38,0xdcbedc4b,
0xdeffdd95,0xe3b0e102,0xeae4e704,0xf3d5ef36,0xfd32f894,0x061401af,0x0ef20a7e,0x17f7136d,
0x20311c4f,0x25962353,0x280b270e,0x296928d4,0x297129a3,0x278d28c4,0x236925be,0x1dbb20a1,
0x18bf1b06,0x16471725,0x164a1618,0x161c166a,0x1378152a,0x0dfa1105,0x06d90a90,0xfe5502b7,
0xf575f9e0,0xecd4f121,0xe48be89f,0xdd21e0b5,0xd6a2d9cc,0xd109d3af,0xcd2fcece,0xcbfdcc45,
0xcccccc38,0xcea8cda1,0xd0e9cfbc,0xd395d22f,0xd788d55c,0xdcddda0d,0xe340dff1,0xea93e6c8,
0xf2faeea5,0xfc20f775,0x05ec00f9,0x0f890ad1,0x186e140a,0x20bc1cad,0x283924a4,0x2e242b67,
0x324a3071,0x348733a8,0x34a234da,0x32c833e3,0x2f53313f,0x2ad82d30,0x25c22855,0x20bc2337,
0x1c331e60,0x18541a34,0x14ec1694,0x11581338,0x0d520f59,0x09370b3f,0x05a20759,0x020303e1,
0xfe07000a,0xfa03fbfd,0xf657f826,0xf33cf4b0,0xf129f210,0xefd6f06d,0xef17ef69,0xeeaeeed7,
0xeec7eea4,0xef9def1b,0xf18ef069,0xf559f334,0xfb09f7fa,0x01cdfe62,0x0888052b,0x0f4c0bdb,
0x160d12cc,0x1a5718aa,0x1a521ae4,0x160c18ad,0x0e961294,0x05ff0a59,0xfd250198,0xf3e7f893,
0xeaacef3a,0xe269e660,0xdbe8def2,0xd678d917,0xd268d42e,0xd0d6d147,0xd1e1d118,0xd4a0d30e,
0xd849d677,0xdb03d9d5,0xdc1fdbb6,0xdd33dc83,0xe089de89,0xe65de330,0xee59ea14,0xf7fcf308,
0x01c7fcf3,0x0b15067c,0x14680fba,0x1d2818f3,0x23bf20d9,0x276c25dc,0x297a2896,0x2a4c2a14,
0x29792a15,0x27382886,0x23c825a3,0x1f7f21ad,0x1beb1d77,0x1a5c1aec,0x19dc1a12,0x180d1953,
0x13641610,0x0c951034,0x042a0896,0xfacdff76,0xf1c3f641,0xe902ed48,0xe0fbe4ee,0xd9b8dd42,
0xd33ed65b,0xcdcbd05b,0xca94cbd5,0xc9e0c9f0,0xcb1dca4f,0xcd12cc0f,0xcf53ce21,0xd297d0cb,
0xd6fed4a6,0xdc8bd9a3,0xe317dfb2,0xea97e6bd,0xf2b4ee8f,0xfb9cf70a,0x051e005d,0x0e5409c7,
0x16e712b2,0x1ece1af8,0x25c52265,0x2bcb28df,0x30dc2e74,0x347932ea,0x36043581,0x358e3609,
0x33243496,0x2f01313e,0x29ef2c89,0x24a02747,0x1fc3221e,0x1b551d82,0x1725193d,0x12ec1505,
0x0ec310ca,0x0b0c0cd2,0x07a0095d,0x03cc05ca,0xff9f01b2,0xfba6fd9b,0xf817f9cd,0xf509f67b,
0xf28ef3b9,0xf0c3f18c,0xef86f017,0xeebeef12,0xeebfeea0,0xefe5ef26,0xf2c0f111,0xf7c9f4fd,
0xfe86fb05,0x05a3021d,0x0c810919,0x13330fde,0x18221619,0x18df1914,0x157117a3,0x0ea31266,
0x05de0a60,0xfc860132,0xf34ff7da,0xeabfeeec,0xe2fce6c2,0xdc81df8d,0xd759d9c7,0xd33bd532,
0xd09cd1ab,0xd05dd027,0xd277d128,0xd5efd421,0xd929d7a8,0xdb3ada61,0xdc70dbd8,0xde69dd32,
0xe2a4e036,0xe93be5a1,0xf216ed6c,0xfc07f70e,0x05c700ef,0x0f1f0a7e,0x180913a8,0x1fe91c25,
0x25d7232a,0x296527e8,0x2b2c2a76,0x2b8e2b86,0x2ad42b4b,0x296e2a2e,0x27022862,0x24022574,
0x221122e1,0x21282190,0x1efc206c,0x19a21cb3,0x11cd15ee,0x08850d46,0xfea80397,0xf557f9e5,
0xec94f0ea,0xe426e855,0xdc59e025,0xd538d8b4,0xcef6d1f2,0xca44cc5e,0xc7d0c8b9,0xc7d9c792,
0xc8f2c85c,0xca76c997,0xcd1bcba3,0xd107ceec,0xd5fdd362,0xdbf2d8d9,0xe2c3df45,0xea33e668,
0xf25eee2c,0xfb68f6ce,0x04b2000c,0x0db80942,0x15f211fb,0x1d17199f,0x238a2063,0x29ae26a3,
0x2f692ca5,0x340c31e4,0x374735db,0x38c43848,0x37d538aa,0x34553659,0x2f5d31f9,0x29b32c94,
0x23f326cd,0x1e7a212a,0x19481bd4,0x148616dc,0x1007123a,0x0c190e04,0x08060a17,0x03b105e3,
0xff7a018c,0xfba7fd7e,0xf856f9fb,0xf53df6c0,0xf280f3d0,0xf071f165,0xeeccef91,0xedb3ee22,
0xeddeed96,0xefa9ee93,0xf375f13e,0xf990f640,0x0136fd47,0x09310539,0x109e0d05,0x16de13f7,
0x19e618ee,0x183819a4,0x125f15bf,0x09b60e4c,0xffac04c4,0xf592fa92,0xec47f0c5,0xe42fe815,
0xdd46e08e,0xd822da74,0xd4bad649,0xd237d366,0xd0dcd158,0xd163d0df,0xd394d259,0xd623d4e0,
0xd85dd751,0xda09d938,0xdbcedadc,0xded0dd11,0xe40de127,0xebb4e78f,0xf538f04a,0xff46fa45,
0x08da0426,0x11c50d60,0x1a44161c,0x21d31e37,0x273524db,0x2a1128e7,0x2b2c2acf,0x2b442b45,
0x2b272b41,0x2a9d2af9,0x29492a0a,0x27ff288f,0x277327a8,0x264e271d,0x223124b5,0x1a611eb3,
0x10a815a7,0x060f0b69,0xfbab00ca,0xf227f6cf,0xe927ed9c,0xe085e4c1,0xd8b9dc83,0xd20cd53c,
0xcc94cf1d,0xc902ca8a,0xc768c7f9,0xc70ac723,0xc72cc70c,0xc85bc78e,0xcb4dc99c,0xcfdfcd64,
0xd5b9d2ab,0xdc76d903,0xe3a5e005,0xeaf5e74e,0xf2deeed2,0xfb7ff720,0x0456ffe6,0x0ce708b1,
0x14b110ed,0x1b5d1822,0x21351e60,0x268723e4,0x2ba52921,0x305c2e0d,0x3484328d,0x378b3636,
0x38813855,0x36b337ee,0x32bc34e9,0x2da03046,0x27ef2acc,0x221d2509,0x1cb21f4d,0x17d21a36,
0x13581581,0x0f2e114c,0x0a8d0cea,0x05af0823,0x01360357,0xfd4dff36,0xf9a3fb77,0xf621f7d4,
0xf337f496,0xf0a8f1eb,0xee79ef7a,0xed57edb8,0xedf5ed67,0xf0c3ef0d,0xf626f325,0xfdc7f9c1,
0x064e0200,0x0eb70a96,0x15ec1292,0x19d6186f,0x191c1a13,0x13ec1702,0x0b8e100b,0x0158069e,
0xf69cfbf6,0xec73f160,0xe371e7cd,0xdbeadf7a,0xd682d8eb,0xd34cd4ac,0xd138d233,0xcfb8d05c,
0xcf79cf66,0xd09ccfe7,0xd24ed176,0xd3ffd324,0xd60ad4eb,0xd8eed75e,0xdcbddab9,0xe219df20,
0xe99ce59a,0xf2d5ee16,0xfc67f7a8,0x057f010e,0x0dde09bf,0x161e11f3,0x1e851a5d,0x259c225f,
0x29be280f,0x2b832ad6,0x2c4c2beb,0x2d1b2cb4,0x2dea2d87,0x2ea72e4d,0x2f002edd,0x2f6a2f38,
0x2ed42f64,0x2abf2d57,0x22952718,0x17e61d67,0x0c861249,0x012406c0,0xf63cfba8,0xebdbf0ed,
0xe256e6fe,0xd9e5ddfa,0xd2bdd619,0xccf9cfb7,0xc8acca9b,0xc605c726,0xc46ec529,0xc357c3d0,
0xc353c31e,0xc56ec407,0xc9f3c76f,0xcfd5ccca,0xd67fd310,0xddb8da13,0xe521e165,0xece3e8f6,
0xf4fbf0e0,0xfd62f926,0x05bb0197,0x0da809c2,0x14e81168,0x1b39182e,0x207a1df9,0x251d22cf,
0x29ac2764,0x2e672bfd,0x333c30db,0x370e3558,0x38d13841,0x380338b7,0x352536c7,0x30aa331a,
0x2ac12ddd,0x245b2780,0x1eda217b,0x1a091c64,0x158217c9,0x10e81338,0x0c440e92,0x07ee0a0b,
0x042905fa,0x00780258,0xfcacfe90,0xf930fadb,0xf60df79b,0xf2f0f478,0xf080f192,0xef79efc9,
0xf066efaa,0xf3c8f1c8,0xf977f65e,0x00d9fcfc,0x090f04f3,0x10c70d0e,0x16641403,0x17b217a0,
0x148216a2,0x0d8e116d,0x040c090a,0xf953fec0,0xee99f3e9,0xe4d4e98e,0xdc66e06c,0xd5ced8ce,
0xd19ad35c,0xcf9ad071,0xce53ceeb,0xcd84cdcf,0xcde2cd8e,0xcf14ce6a,0xd098cfcf,0xd280d177,
0xd567d3c6,0xd980d753,0xdeeadc01,0xe63ae250,0xef1dea8e,0xf86ff3c9,0x0159fcf8,0x099c058f,
0x11640d86,0x197a1560,0x21971d9e,0x27ad2506,0x2ac5298b,0x2c252b8e,0x2d5b2cb8,0x2f312e34,
0x31083027,0x32b631e4,0x34033366,0x34903478,0x32c63417,0x2ca9304e,0x228c27fb,0x165b1c99,
0x09b91008,0xfde603a8,0xf2b5f83a,0xe851ed6a,0xdeb1e363,0xd650da51,0xcf88d2bd,0xca15cca2,
0xc610c7e7,0xc34fc48b,0xc141c23f,0xbfb8c05b,0xc003bf8d,0xc300c12c,0xc848c571,0xceafcb68,
0xd5a8d220,0xdcedd942,0xe470e0a2,0xec6fe862,0xf4b2f08d,0xfd0af8e3,0x0534012b,0x0d110930,
0x146810d2,0x1aae17b3,0x1fc31d57,0x24362208,0x28ab2664,0x2d872b11,0x32733009,0x36583497,
0x3861379b,0x3853389b,0x367a379e,0x328634c2,0x2ce32fd8,0x273b29f5,0x224224b8,0x1d631fd5,
0x18701ae4,0x13a21608,0x0f141154,0x0af50cf9,0x06f608f9,0x02b504d7,0xfeb0009e,0xfb26fce0,
0xf7baf96d,0xf4a5f61e,0xf272f364,0xf1d0f1e6,0xf35ef245,0xf799f52e,0xfdc3fa84,0x04db0134,
0x0c9908b7,0x13351037,0x161c1539,0x148015d8,0x0ed11221,0x06280acb,0xfbbd010d,0xf0f0f652,
0xe6cfebc4,0xddaee21c,0xd611d9a6,0xd0c8d315,0xce1ccf32,0xcc95cd4d,0xcba1cbfb,0xcb88cb84,
0xcbdbcba6,0xcc99cc26,0xce24cd42,0xd0f7cf5b,0xd549d2f3,0xdadcd7e4,0xe277de5c,0xec02e711,
0xf60df111,0xff51fad6,0x0718036f,0x0da80a6f,0x149c1103,0x1c691875,0x23642025,0x27e52600,
0x2a4a2943,0x2c3a2b33,0x2ec82d74,0x317b3022,0x343e32d5,0x36fe35a0,0x391a3842,0x38e33964,
0x34b9376a,0x2bca30c5,0x2012261b,0x132b19b3,0x068c0cbf,0xfa500064,0xeecdf474,0xe43ae95f,
0xdac6df64,0xd2d1d688,0xcc5fcf71,0xc760c9b2,0xc3a8c55a,0xc09ec21d,0xbe23bf4b,0xbcf2bd4a,
0xbe93bd5d,0xc320c08e,0xc934c617,0xcfc9cc6e,0xd6e6d34c,0xde61da9a,0xe642e23f,0xee3eea40,
0xf629f238,0xfde6fa11,0x05a001bf,0x0d4e097f,0x14761101,0x1a5a178f,0x1f3e1ce2,0x23a5216f,
0x287225fe,0x2d6c2aee,0x31ca2fbd,0x34e83382,0x368635ec,0x367c36b5,0x34e335dd,0x31a43377,
0x2d932f9e,0x29522b78,0x25062732,0x205822c7,0x1b511dda,0x168318d4,0x12651461,0x0e5d1073,
0x09e90c25,0x057807b1,0x01520354,0xfd53ff5e,0xf970fb51,0xf631f7b6,0xf406f4f3,0xf358f370,
0xf50ff3dc,0xf96af6f3,0xff7afc55,0x060902b4,0x0d040982,0x12c01041,0x14651426,0x11b91396,
0x0ae30ecb,0x00e40628,0xf647fb86,0xec34f12a,0xe2bfe76d,0xd9a7de1a,0xd27bd5b0,0xce95d026,
0xccbacd86,0xcb8ecc15,0xcaeccb2a,0xcac1cacb,0xcae9cacb,0xcb8ccb24,0xcd6fcc46,0xd0b0ceed,
0xd54bd2c9,0xdbcbd840,0xe504e011,0xf008ea6f,0xfaf4f592,0x0461fffd,0x0ae007f2,0x10350d7d,
0x16ba134f,0x1db21a43,0x234f20cd,0x266a2525,0x289b2774,0x2b8829fb,0x2f022d37,0x32b930e3,
0x36503483,0x397c3807,0x3b483a96,0x3a4d3b49,0x34c2382b,0x2ad63033,0x1eb424f1,0x11c5183a,
0x05210b71,0xf856feb9,0xec1ef210,0xe175e697,0xd880dcb9,0xd154d4bd,0xcbccce60,0xc73cc96b,
0xc370c53f,0xbff7c1ac,0xbcecbe57,0xbbb3bbf5,0xbde6bc60,0xc2fcc032,0xc92fc5fb,0xd026cc9b,
0xd760d3b7,0xdf10db29,0xe722e313,0xef0deb25,0xf669f2d1,0xfd86f9ef,0x052e0144,0x0caf0908,
0x1320100b,0x18a015f7,0x1d9a1b26,0x22a22013,0x28152553,0x2d422ac4,0x313c2f71,0x339b32a3,
0x348e3435,0x34523498,0x32df33bf,0x308031c3,0x2ddc2f32,0x2b1e2c82,0x282a29b2,0x24372654,
0x1f8321e3,0x1b291d42,0x172f1928,0x12bf1514,0x0dda1048,0x090f0b6e,0x046006bd,0xff8f01f1,
0xfb73fd61,0xf864f9ca,0xf6bef75c,0xf70df69e,0xf9e3f826,0xfe8dfc1d,0x03dc011d,0x09ef06ca,
0x0fa90d0d,0x11ca1143,0x0fb6113c,0x0a240d55,0x01a50633,0xf78bfcae,0xedc5f282,0xe4e1e941,
0xdc28e07f,0xd48bd819,0xcf89d1af,0xccb9cdf7,0xcab8cba8,0xc95ec9f2,0xc89bc8ef,0xc7fcc84a,
0xc78ac7b6,0xc827c79d,0xcaddc93f,0xcf71ccee,0xd635d282,0xdf93da96,0xeb1be528,0xf6eaf11c,
0x012ffc4e,0x08f40568,0x0e830be9,0x13da1120,0x19dd16ca,0x1f791cd1,0x239f21c0,0x26a52536,
0x2994280e,0x2d5b2b5d,0x31da2f84,0x36df3449,0x3c1c3983,0x40023e62,0x406940c8,0x3bfc3ecc,
0x33743829,0x28162dff,0x1b1621c5,0x0d7e1451,0xff8d0686,0xf205f8ac,0xe62eebd0,0xdcaae123,
0xd531d8bd,0xcefed1f0,0xc9eccc56,0xc54bc799,0xc0bec308,0xbc85be8f,0xb9bbbad8,0xba17b96f,
0xbdf4bba4,0xc3b3c0b3,0xca28c6db,0xd138cd99,0xd8f8d508,0xe113dd05,0xe90be516,0xf089ecdc,
0xf773f404,0xfe95faf4,0x060f0255,0x0cf409a4,0x12dc1001,0x18091586,0x1d0b1a7d,0x229c1fc4,
0x28492581,0x2cfa2aca,0x306c2ede,0x327d319e,0x333d330f,0x3276330e,0x30973193,0x2eb62fa2,
0x2ce72dc7,0x2b3f2c13,0x29282a52,0x25dc27ae,0x21f523e8,0x1e56201d,0x1a681c7a,0x15b1181d,
0x10d91340,0x0bfd0e76,0x06d40970,0x01b40431,0xfd97ff7e,0xfacafc04,0xf9acf9fe,0xfaa4f9da,
0xfdc7fbfe,0x0205ffd7,0x06a50447,0x0bcd0934,0x0fbb0e20,0x0fde1057,0x0c190e68,0x04f208f0,
0xfb4b0052,0xf152f636,0xe879eccc,0xe03fe457,0xd835dc28,0xd1d1d4af,0xcde6cf9b,0xcb32cc81,
0xc911ca0e,0xc796c841,0xc688c6fd,0xc5e5c62a,0xc58dc5a2,0xc698c5db,0xc9b9c7ef,0xcf24cc13,
0xd785d2fa,0xe26fdcb5,0xeee9e893,0xfb1ef52f,0x054b008c,0x0c850940,0x12030f5c,0x175014a2,
0x1c8c1a04,0x20df1ede,0x241d229d,0x26c4256c,0x2a0d2845,0x2e292bfd,0x330f308d,0x389735bc,
0x3e173b75,0x4187402d,0x40a141c6,0x3ac73e36,0x31643672,0x25cc2bcd,0x18db1f6b,0x0b63123b,
0xfd860467,0xf069f6cb,0xe579ea99,0xdcf3e0f7,0xd5c0d93e,0xcf85d27e,0xca4dccdb,0xc555c7ce,
0xc058c2d7,0xbbd3bdee,0xb973ba45,0xba8bb983,0xbee2bc70,0xc49dc1a2,0xcaeec7b5,0xd1e7ce4d,
0xd9ced5c4,0xe1e1dddd,0xe990e5cf,0xf0bded33,0xf7bcf436,0xfef8fb55,0x05e5028b,0x0bcf08f6,
0x11000e7c,0x15db136c,0x1b27186c,0x21091e0a,0x26c82401,0x2b91294c,0x2f132d86,0x3101303a,
0x31573166,0x300930db,0x2e3a2f1c,0x2c802d5a,0x2b222bbf,0x2a302aa4,0x28e929a4,0x26ee27f7,
0x24cf25e6,0x22082393,0x1e3a2040,0x19901bf6,0x149c171b,0x0f62120c,0x09e60ca1,0x04f80753,
0x013d02ea,0xff25fff7,0xff2efee2,0x01560003,0x04ad02f8,0x08380668,0x0bfe0a1a,0x0ee10db9,
0x0e730f28,0x0a6a0cd9,0x0334072f,0xf9ecfeba,0xf05cf50b,0xe7dcebf2,0xe06be40e,0xd932dcc4,
0xd398d60e,0xd071d1d1,0xce08cf40,0xcb96ccc7,0xc993ca87,0xc7b1c8a1,0xc5d4c6c0,0xc435c4f5,
0xc3a5c3ba,0xc4efc40a,0xc8b8c673,0xd02bcbf3,0xdb05d544,0xe7bde13e,0xf501ee60,0x00acfb3b,
0x092a053e,0x10030ca9,0x1631133c,0x1b4718e2,0x1efa1d4d,0x21c3206c,0x24b22332,0x27b52633,
0x2b3d295c,0x2feb2d6a,0x361e32cb,0x3d6c39c1,0x436640c1,0x45264504,0x407c4389,0x37d93c82,
0x2d3a32b4,0x21342761,0x140a1acf,0x05f20d02,0xf840fefd,0xec45f1f3,0xe313e753,0xdbbfdf50,
0xd52bd85f,0xcf5ad232,0xc9d5cc91,0xc434c716,0xbe85c147,0xba83bc36,0xb995b9a2,0xbbcfba5d,
0xc025bdc1,0xc5dac2ea,0xcc34c8ee,0xd390cfc3,0xdb8fd788,0xe350df80,0xea7de6f2,0xf18aedfa,
0xf8e2f534,0x000dfc8c,0x0644034b,0x0b8308fa,0x10570df6,0x157012c7,0x1b3f184a,0x21361e3f,
0x268b2406,0x2ad528d7,0x2dde2c80,0x2f922eee,0x2f872fc3,0x2e292ef2,0x2c3f2d42,0x2a5b2b3c,
0x28fb2998,0x280a2878,0x27002790,0x261d2683,0x250b25a8,0x2310242d,0x202921bc,0x1c7b1e6c,
0x181f1a6a,0x131515a2,0x0e48109b,0x0a510c2f,0x078308b6,0x069306c9,0x07b406e7,0x09fc08cf,
0x0c4d0b17,0x0f300db6,0x10d71051,0x0f8b10a1,0x0b0d0da4,0x03ea07ce,0xfab3ff83,0xf08ff597,
0xe790ebe2,0xdfcbe38a,0xd8bbdc3a,0xd2dad586,0xcf58d0cd,0xcd47ce4a,0xcad2cc21,0xc85fc987,
0xc633c750,0xc3b9c500,0xc12bc26a,0xbfafc037,0xc01bbfa6,0xc2ebc11e,0xc957c5a6,0xd3a0ce10,
0xe038d9c5,0xed66e6d5,0xf9f2f3d4,0x0461ff84,0x0c88089d,0x1407104d,0x1a871789,0x1ec31cef,
0x21732033,0x240d22af,0x270e2584,0x2a322892,0x2e592c21,0x33fc30f8,0x3b4d376d,0x42e03f47,
0x46f4458d,0x452a46d9,0x3e42422c,0x351239d4,0x2a672ff3,0x1e42247b,0x106c1797,0x02000923,
0xf49afb13,0xe9d5eed3,0xe1d8e594,0xdaf0de57,0xd45bd79e,0xcdfad12e,0xc7afcad9,0xc149c471,
0xbc2fbe7c,0xb993ba82,0xb9bfb95c,0xbbf1ba9c,0xc005bdbd,0xc571c29c,0xcc02c88f,0xd3b5cfc4,
0xdbbfd7bf,0xe35edf9f,0xeaa4e703,0xf206ee46,0xf98af5d0,0x0064fd1d,0x06020357,0x0ae50882,
0x0fb00d3c,0x15431260,0x1b421844,0x21351e48,0x268a23f3,0x2af428e2,0x2e142cae,0x2fa22f12,
0x2faf2fd5,0x2ea42f40,0x2cf22de0,0x2b1e2c01,0x29782a45,0x280528b5,0x26f3276c,0x26152687,
0x24df2587,0x232f241a,0x20c92217,0x1d821f41,0x193c1b7c,0x149016e7,0x10451259,0x0cad0e5c,
0x0a510b4c,0x09dc09d8,0x0b0a0a4f,0x0cbe0be2,0x0eb40da2,0x10c90fd9,0x10ce112b,0x0daa0fa6,
0x07ad0b04,0xff2803b2,0xf525fa37,0xeb98f032,0xe35de759,0xdbfbdf9e,0xd56fd887,0xd10fd2ef,
0xced6cfc6,0xcd23ce08,0xcae9cc10,0xc891c9b9,0xc654c777,0xc3c5c513,0xc170c284,0xc008c092,
0xc05abff3,0xc385c173,0xcadfc6a6,0xd623d022,0xe30fdc85,0xeff8e98d,0xfbf6f631,0x05a1011e,
0x0df109d7,0x15de1204,0x1c121945,0x1fd01e28,0x22882135,0x257523f0,0x2890270a,0x2b932a06,
0x2fa22d64,0x357c324d,0x3d1c3928,0x43f040e4,0x467045e7,0x42ef455c,0x3b7f3f90,0x324b3704,
0x27bd2d3e,0x1b5721cb,0x0cf61441,0xfea205b3,0xf23cf814,0xe8f1ed2f,0xe1efe549,0xdb76dea9,
0xd4e9d840,0xcdffd173,0xc702ca86,0xc079c395,0xbbfcbde8,0xba8bbadf,0xbb64bac3,0xbdadbc5a,
0xc1aebf7c,0xc70ac42f,0xce02ca5b,0xd5dfd1de,0xdd9ed9d3,0xe4a1e130,0xeb86e80c,0xf2d3ef20,
0xf9f8f67d,0x0038fd3b,0x058902f8,0x0a6d07ff,0x0fba0cf7,0x157c1295,0x1b451865,0x20a71e09,
0x2594232d,0x29bb27c5,0x2ce82b7e,0x2e6d2ddc,0x2e9e2eac,0x2dc62e4f,0x2c332d0a,0x2a6a2b57,
0x28c72991,0x277a2814,0x26dc271d,0x26242691,0x24f02597,0x234a2427,0x212b2251,0x1e431fd6,
0x1a661c6c,0x167d1864,0x12ce149d,0x0f9b1118,0x0dba0e7a,0x0d900d6a,0x0ea70e06,0x0fed0f47,
0x119910ba,0x12aa125c,0x10e31236,0x0c080ec8,0x04860899,0xfa89ffc9,0xeff8f528,0xe6e1eb38,
0xdf03e2d1,0xd7dedb5a,0xd1f5d4aa,0xceadd000,0xcd0ecdc9,0xcb6ccc4b,0xc996ca81,0xc7b4c8aa,
0xc5abc6b4,0xc362c494,0xc14fc245,0xc016c08f,0xc070bff5,0xc444c1cf,0xcc94c7e1,0xd879d22f,
0xe5c9df16,0xf2ebec70,0xfe59f8eb,0x07a3032f,0x10530bfc,0x183c1481,0x1de91b68,0x21351fc8,
0x23e72284,0x272e257f,0x2a6e28d4,0x2dd02c18,0x31e32fae,0x37dc34a1,0x3f333b7d,0x44ee4287,
0x45c24616,0x40fb43ea,0x38d53d34,0x2f39342e,0x244129e6,0x175d1e26,0x08d2101d,0xfafb01b1,
0xeff2f50f,0xe7e5eb9c,0xe196e49d,0xdbbfdeb4,0xd56ed8ab,0xce72d205,0xc70ccaba,0xc0a0c399,
0xbcd2be51,0xbbfabc1f,0xbcbfbc36,0xbed1bd92,0xc279c072,0xc7e0c4f5,0xced5cb31,0xd6a7d2bd,
0xde23da7c,0xe4e8e193,0xebcae849,0xf302ef6a,0xf98cf666,0xff36fc71,0x048301e5,0x09ef072e,
0x0fed0cdd,0x16131307,0x1bfa1917,0x21241ea8,0x25b0237a,0x29bd27c8,0x2cd12b72,0x2e4f2dbf,
0x2e582e80,0x2d462de9,0x2bde2c8c,0x2a682b26,0x290f29af,0x28152890,0x273327a3,0x262226b9,
0x24a82579,0x22cc23be,0x209221c2,0x1d891f29,0x1a261bd5,0x1718188f,0x143415a4,0x11e712e6,
0x1114114a,0x119b1133,0x128b121a,0x137e12f8,0x14731411,0x13a01466,0x0fb5120c,0x09190cba,
0x003104e5,0xf5bffb0f,0xec06f0ab,0xe402e7e0,0xdc9ce047,0xd5b2d902,0xd0d8d2ef,0xce4fcf5d,
0xccaacd7c,0xcaf0cbd1,0xc930ca14,0xc721c832,0xc4d6c604,0xc253c39b,0xc053c13d,0xbf5cbfaf,
0xc099bf8b,0xc5cdc2a2,0xcf3eca09,0xdb92d537,0xe88be219,0xf4a4eec6,0xfef6fa0e,0x082c0392,
0x111b0cb7,0x18b6152e,0x1daa1b86,0x20cf1f5b,0x240f2257,0x27e825eb,0x2be629e6,0x2fce2dde,
0x348331f3,0x3af83793,0x419b3e74,0x45554404,0x44164560,0x3e1e4196,0x357b39fd,0x2b9d30af,
0x20712640,0x13471a16,0x05530c42,0xf8d3fec7,0xef58f3b9,0xe82eeb8e,0xe269e52a,0xdcd8dfaf,
0xd654d9bc,0xcee0d2ad,0xc76acb0f,0xc1a4c435,0xbeb0bfcb,0xbdffbe23,0xbe75be1b,0xc040bf29,
0xc3b7c1ba,0xc915c630,0xcfcdcc54,0xd6fbd362,0xdde9da8b,0xe481e130,0xeb7fe7f5,0xf230eeed,
0xf80cf53c,0xfd6dfabe,0x02d7001d,0x08bc05b0,0x0f250bea,0x1581125f,0x1b551881,0x20761dfb,
0x252a22d7,0x2979276b,0x2cbb2b41,0x2ea32ddd,0x2ee32ef3,0x2df92e7f,0x2cd52d6a,0x2b8d2c3a,
0x2a442ae2,0x293d29bb,0x27fe28b0,0x26072718,0x23b024e4,0x2118226b,0x1e281fb1,0x1b111c97,
0x189e19b9,0x16fe17bd,0x15d01651,0x1596158e,0x168415e9,0x17cd1733,0x190c1866,0x1a3e19b0,
0x19d71a64,0x15e7185d,0x0e6e1285,0x04a209bf,0xf99fff34,0xeec5f412,0xe597e9fa,0xdddbe18f,
0xd6efda53,0xd17cd3e9,0xce2fcf9b,0xcc26cd1d,0xca73cb40,0xc931c9c6,0xc7edc89a,0xc620c71a,
0xc3c8c50b,0xc138c27b,0xbf95c035,0xbfbabf59,0xc2f5c0e3,0xca1dc604,0xd4c0cf1b,0xe103dad1,
0xed02e724,0xf787f277,0x0124fc58,0x0ad80603,0x13bd0f80,0x1a6e1769,0x1ebc1cd8,0x21c42043,
0x25742378,0x29d12790,0x2e782c2b,0x332630c2,0x392335fb,0x3fa43c76,0x4421424b,0x446544e3,
0x405742c9,0x395f3d2a,0x3074351e,0x25ed2b5a,0x19db2017,0x0c7b1341,0xff7905c2,0xf4eaf9d2,
0xecf5f0b1,0xe6aae99f,0xe1bbe41d,0xdc8bdf4b,0xd5f9d971,0xce4ed225,0xc7a7cabf,0xc35cc528,
0xc188c23a,0xc0d8c11f,0xc0f6c0c5,0xc281c17d,0xc663c429,0xcbf0c904,0xd24ccf15,0xd8c4d58e,
0xdf2fdbfb,0xe5bbe26c,0xec6ee91b,0xf29bef99,0xf821f56f,0xfd84face,0x0342004b,0x09cc0678,
0x105d0d22,0x16831385,0x1bdb1946,0x20b21e52,0x25542307,0x29462773,0x2c002ad0,0x2d482cd3,
0x2d582d72,0x2cca2d1f,0x2bbf2c53,0x2a7d2b20,0x297329ea,0x28972908,0x271627f6,0x24c725fd,
0x22292381,0x1f4020bb,0x1c051dac,0x191c1a72,0x176a1818,0x16c616ff,0x171116c8,0x187617a8,
0x1a6f1975,0x1bf01b3e,0x1d671c9f,0x1e2c1e10,0x1b751d4c,0x150f18b1,0x0be510c3,0x012806a6,
0xf5c8fb8a,0xeaecf01a,0xe22de649,0xdae7de6b,0xd4b9d7a7,0xd034d240,0xcd23ce83,0xcb0fcc01,
0xc9c0ca4d,0xc926c96a,0xc83fc8cb,0xc67bc775,0xc414c550,0xc1b1c2cf,0xc072c0e7,0xc11ec073,
0xc515c29d,0xccf5c892,0xd7a7d20f,0xe35edd7c,0xeeb4e92a,0xf8cef3df,0x029efdb0,0x0c9007a9,
0x15121113,0x1b601885,0x1f761db0,0x227620eb,0x266a2450,0x2b5f28c7,0x30ea2e1b,0x36d233c9,
0x3d8b3a1e,0x430540a4,0x4508448c,0x42e44474,0x3d64407e,0x354a39a0,0x2b453075,0x206025f4,
0x14361a67,0x07b10df1,0xfc4601c2,0xf329f766,0xebc8ef52,0xe5e8e89e,0xe163e393,0xdc0bdef1,
0xd518d8bd,0xce03d168,0xc89ecb08,0xc590c6d4,0xc411c4b0,0xc302c37c,0xc2e2c2cf,0xc468c35c,
0xc845c61e,0xcd6ecabf,0xd32ed03d,0xd941d62c,0xdf8adc64,0xe5ede2bf,0xec28e912,0xf203ef2c,
0xf76ff4bf,0xfce6fa20,0x02fcffd7,0x09910642,0x0fdf0cc1,0x15b712de,0x1b1f1874,0x204c1dbe,
0x252c22c9,0x29602762,0x2c4b2b07,0x2da12d26,0x2dd62dce,0x2d962dcc,0x2c912d29,0x2b382be5,
0x2a242aa7,0x28f629a1,0x26e4280b,0x24472597,0x216422e2,0x1e1f1fd0,0x1a851c4c,0x17cc18f8,
0x166e16f1,0x168c164b,0x18331732,0x1ae01981,0x1d6f1c3a,0x1f8a1e87,0x21182076,0x203c211d,
0x1b541e48,0x13021781,0x085f0de5,0xfceb02b4,0xf143f714,0xe6c4ebc4,0xde85e264,0xd7f3db0a,
0xd2f7d542,0xcf6dd107,0xcd05ce1e,0xcb32cc11,0xca2aca90,0xc99fc9e6,0xc886c931,0xc65dc786,
0xc3b8c50c,0xc1b7c296,0xc11ac132,0xc2b2c18a,0xc781c49f,0xcfefcb51,0xda7dd515,0xe5b5e00c,
0xf0afeb50,0xfacbf5d0,0x04d6ffc8,0x0e6409ca,0x16361291,0x1be71953,0x1f9c1df4,0x22e02128,
0x272f24e2,0x2caa29c5,0x33272fd6,0x3a1f3699,0x40ac3d96,0x4478430b,0x442a44d6,0x404f429b,
0x39fd3d64,0x31753602,0x271b2c71,0x1b9f2177,0x0f8d15a7,0x03b4097f,0xf934fe38,0xf0aaf4b4,
0xe9baecff,0xe4a3e6f2,0xe062e28e,0xdaf5dde2,0xd454d7a3,0xce80d136,0xca97cc47,0xc840c94c,
0xc67dc75e,0xc50ec5a9,0xc4c4c4bb,0xc65dc548,0xca0ec801,0xcebecc53,0xd41cd15a,0xda1cd708,
0xe047dd2a,0xe668e361,0xec1ee94e,0xf178eed4,0xf69ff40b,0xfc17f94c,0x023aff13,0x089a0570,
0x0eb70bb8,0x149111a7,0x1a7f1781,0x206f1d7c,0x25f9234a,0x2a822874,0x2d4e2c1c,0x2e9f2e1e,
0x2f252ef6,0x2ef82f2f,0x2de62e89,0x2c7d2d2c,0x2b282bd9,0x29492a58,0x268f2803,0x236e2504,
0x200e21c3,0x1c731e4b,0x18e21a94,0x16531772,0x152d158b,0x15f21550,0x185e16fe,0x1b9f19f9,
0x1ead1d34,0x217a2022,0x226b2254,0x1f90218a,0x18b51c92,0x0f0d1425,0x042409a3,0xf905fe97,
0xedebf36c,0xe41de8c3,0xdc9fe013,0xd749d9ba,0xd31dd51d,0xcfb0d14b,0xcd2bce50,0xcbb1cc41,
0xcb25cb50,0xcad0cb02,0xc99aca5f,0xc773c89b,0xc521c63e,0xc3cac44d,0xc414c3b6,0xc678c4f4,
0xcbcac8bd,0xd3c9cf8d,0xdd25d860,0xe76ce22c,0xf1f8ecb7,0xfc30f71e,0x0619012b,0x0ef00abc,
0x160712b8,0x1b3718de,0x1ebb1d1b,0x22172055,0x26812422,0x2c652943,0x33b02fdf,0x3b62379f,
0x415a3eb5,0x43b44311,0x42014349,0x3dab4015,0x37113aab,0x2dfe32d3,0x231128bc,0x17891d4a,
0x0bfa11bd,0x013c0677,0xf7e5fc5a,0xf022f3d8,0xe9c5ecc7,0xe4bfe724,0xe029e27c,0xda90dd88,
0xd4b5d78d,0xd023d23a,0xcd33ce7b,0xcb1dcc17,0xc93dca2d,0xc7bdc86e,0xc75ac756,0xc8a6c7c9,
0xcbb3c9ff,0xcfe3cdaa,0xd52ed262,0xdb38d82b,0xe130de40,0xe6dae40b,0xec26e990,0xf11beea3,
0xf616f38e,0xfb98f8c4,0x0191fe89,0x077c049b,0x0d0a0a3f,0x131c1000,0x19a2165a,0x202f1cee,
0x2626234c,0x2ad528b0,0x2dbc2c86,0x2f4a2e9c,0x2fe52fb9,0x2f902fd1,0x2ea92f26,0x2d7f2e1d,
0x2be12cc3,0x29862acf,0x265027fd,0x229c2484,0x1e8f2099,0x1a751c83,0x16c51881,0x1429154b,
0x13221367,0x143a1366,0x174d158e,0x1b5f194c,0x1f9a1d7a,0x236921ab,0x24902478,0x2104235e,
0x194d1d9d,0x0eb91445,0x031c08ec,0xf773fd56,0xebf4f18d,0xe286e6ec,0xdb78debd,0xd61ad89f,
0xd1b0d3cd,0xce26cfc4,0xcbe0ccd9,0xcadbcb38,0xcb0ecad7,0xcb31cb44,0xc9e3caba,0xc787c8c2,
0xc55dc659,0xc448c4a8,0xc51fc466,0xc881c67c,0xce98cb39,0xd6bed280,0xdfeedb37,0xea47e4f9,
0xf4bdef99,0xfea8f9bc,0x08660396,0x10ec0ceb,0x173c1453,0x1bd219bf,0x1eff1d7a,0x2269209c,
0x26f72481,0x2da029f7,0x362631c0,0x3e583a72,0x43a84186,0x44464487,0x41374321,0x3b9f3eac,
0x33be3801,0x29682ed5,0x1db923a0,0x122217e9,0x072a0c81,0xfd38020f,0xf47ff8b9,0xece7f08b,
0xe6bde99c,0xe226e44b,0xddc1e009,0xd8bbdb49,0xd411d642,0xd0f1d24a,0xcf4acffe,0xce24ceb7,
0xccd3cd83,0xcbc3cc36,0xcb5fcb76,0xcc27cb8c,0xce64cd1c,0xd1e4cffe,0xd68ad415,0xdc02d939,
0xe19fded8,0xe70ee45d,0xec2ae9a1,0xf123eea7,0xf646f3aa,0xfbcef8fc,0x0176feaa,0x06b7041d,
0x0c470966,0x12770f49,0x192415c9,0x1f9d1c71,0x257822a2,0x2a5d2815,0x2dd42c42,0x2ff92f15,
0x30be3080,0x307b30b2,0x2fb63028,0x2e4f2f14,0x2c332d5b,0x29312ad8,0x25732759,0x219b2384,
0x1dbc1fad,0x19ff1bd4,0x16cb1847,0x14b7159b,0x14441441,0x15d814d5,0x18c9172e,0x1cd41aaa,
0x216a1f2e,0x244b2335,0x236a2468,0x1df52140,0x150419cf,0x0a340fb8,0xff2504ac,0xf3b9f98d,
0xe864edde,0xdf92e39d,0xd981dc38,0xd502d724,0xd117d2f8,0xce01cf62,0xcc76cd0d,0xcc1dcc25,
0xcc6dcc43,0xcc04cc62,0xca47cb46,0xc7e7c915,0xc671c6f8,0xc6a6c654,0xc8bec769,0xcce7ca9b,
0xd2d0cfab,0xda07d64a,0xe26dde06,0xecafe75e,0xf733f207,0x00d0fc17,0x09dc0571,0x11690de5,
0x16e51461,0x1ad1190c,0x1dc11c4d,0x21661f69,0x26e423d0,0x2f482ac4,0x38a5340c,0x3fe93caf,
0x42f34208,0x41dd42d7,0x3e45404c,0x38553b9e,0x2fbb3463,0x24af2a6d,0x19011ed1,0x0df5135c,
0x03f508d0,0xfb0dff6b,0xf2e9f6dd,0xeba8ef26,0xe589e872,0xe0bfe303,0xdc4ade89,0xd811da17,
0xd4e7d64c,0xd2fed3d0,0xd1dfd25f,0xd0ded163,0xcfacd040,0xceb7cf28,0xcdf3ce4c,0xce4ecdef,
0xd03dcf10,0xd3b7d1c9,0xd854d5ed,0xdd61dad4,0xe287dffd,0xe750e4fa,0xebcbe996,0xf06fee0c,
0xf591f2f7,0xfaedf83e,0x003cfd9b,0x057502d1,0x0b5e084f,0x11f10e9a,0x18a31552,0x1ef01bdb,
0x24c721ea,0x29e72773,0x2df22c1d,0x305e2f5f,0x31903115,0x31dd31d4,0x312931a0,0x2f8d3075,
0x2d1b2e70,0x296a2b6d,0x250c2741,0x209522d2,0x1c281e5e,0x17ed19fb,0x14b21623,0x12d2138d,
0x12af1282,0x14661355,0x179015d7,0x1bca198f,0x207b1e2a,0x2351224d,0x222b234b,0x1cba1ff2,
0x13d81897,0x096f0eb6,0xfeaa0419,0xf341f90d,0xe844ed8e,0xdfa2e397,0xd9a4dc58,0xd51dd748,
0xd116d305,0xce3acf73,0xcd16cd73,0xcd3ccd09,0xcddbcd90,0xcda0cdee,0xcbf7ccf2,0xc9c9cad9,
0xc88cc8fc,0xc8cfc878,0xcb2fc9b5,0xcfabcd31,0xd5ddd29a,0xdcfed95b,0xe52de0e1,0xef0de9ef,
0xf914f42d,0x0244fdb9,0x0ad806b1,0x11ef0ea0,0x170c14b8,0x1a6e18ed,0x1d0a1bb3,0x20931e96,
0x26c62342,0x2fe12b15,0x392134b5,0x3f3e3cb8,0x411f40af,0x3f8040a9,0x3b8d3dd3,0x34db388c,
0x2b693079,0x202325e7,0x14c21a59,0x0aa30f84,0x01a00609,0xf92afd58,0xf10df50a,0xe9aaed40,
0xe38ce668,0xdecae108,0xdacbdcbe,0xd760d8f5,0xd553d62b,0xd47ed4cd,0xd425d44b,0xd3c6d3fd,
0xd332d37a,0xd279d2dc,0xd19cd206,0xd16dd15d,0xd2acd1dd,0xd570d3d7,0xd9a2d768,0xde65dbfa,
0xe34ce0d8,0xe7ffe5b2,0xec83ea3b,0xf158eee3,0xf666f3df,0xfb76f8f9,0x003efdde,0x053202a4,
0x0b1f0806,0x11740e4e,0x178d148b,0x1d451a70,0x231e2026,0x28ca260c,0x2d252b31,0x2fdb2eaa,
0x317330c4,0x31ec31d2,0x313631b4,0x2f54306b,0x2c7f2e0c,0x28ae2aae,0x248026a1,0x20322253,
0x1c0e1e1d,0x181b1a03,0x15101673,0x136b140a,0x1389133f,0x15391436,0x1841168c,0x1cac1a57,
0x20af1ee8,0x21d321b3,0x1f2420fd,0x18b61c50,0x0ff61488,0x063f0b2b,0xfc2e0147,0xf130f6c7,
0xe6a3ebac,0xdebae257,0xd943dbcb,0xd4ccd6fb,0xd0e8d2bc,0xce76cf73,0xcda6cde3,0xcdfdcdb7,
0xce81ce4f,0xce1bce73,0xcc8ecd6f,0xcabdcb94,0xca34ca42,0xcb63ca92,0xce62cca3,0xd31fd08d,
0xd926d609,0xdff8dc74,0xe824e3d2,0xf1d6ece4,0xfb4af6b0,0x03d2ff9a,0x0bfc07fd,0x12c10f9c,
0x17941566,0x1aa7194a,0x1d5a1bef,0x21921f26,0x28c024be,0x32362d5f,0x3a5036ac,0x3e2d3ccc,
0x3e523ea5,0x3be33d5c,0x374339dc,0x3073341e,0x274c2c29,0x1c7421fa,0x11d41708,0x082e0ce3,
0xff6203b4,0xf6c0fb0c,0xee90f295,0xe72feab8,0xe113e3f2,0xdc83dea1,0xd924daab,0xd729d7f7,
0xd686d6b0,0xd690d680,0xd6b5d6a6,0xd68fd6ae,0xd613d65c,0xd546d5bf,0xd444d4bf,0xd3ffd3fa,
0xd511d457,0xd797d628,0xdb56d95b,0xdfbfdd7a,0xe481e226,0xe8d6e6bb,0xed27eaed,0xf1d4ef75,
0xf691f436,0xfb16f8d9,0xff7efd48,0x045f01d0,0x0a240733,0x0fe90d11,0x159b12b7,0x1bc918a2,
0x224e1f0b,0x281c255c,0x2c692a77,0x2f5c2e04,0x3167307f,0x32783217,0x3212327a,0x30363149,
0x2d4a2ee1,0x29b32b8f,0x25a427ba,0x21582380,0x1d211f3a,0x19621b25,0x16da17f2,0x15bd1620,
0x15e715a7,0x175f1679,0x1a01188f,0x1d481ba4,0x1f241e8a,0x1e011efd,0x19871c26,0x12a61649,
0x0a930eb8,0x01e0063f,0xf881fd60,0xedf9f345,0xe4a8e8fe,0xddfbe104,0xd914db67,0xd4abd6cb,
0xd13ed2cc,0xcf5bd01d,0xce99cedd,0xcebfce94,0xcf01ceea,0xce66ced2,0xcd17cdce,0xcc06cc6a,
0xccbbcc21,0xcf0ecdbf,0xd2add0ae,0xd77ad4f3,0xdd00da2f,0xe354e000,0xeb7fe72b,0xf4a6f015,
0xfcf0f8ef,0x04e000de,0x0c9308d7,0x12dd0fef,0x173f154b,0x1a1f18c9,0x1d961ba4,0x23142008,
0x2b1526ce,0x33aa2f8a,0x399c3720,0x3b9d3b0d,0x3ada3b8b,0x37c2399b,0x329d356d,0x2b632f47,
0x223026fb,0x18501d36,0x0f2e139c,0x06c40aef,0xfe7902a6,0xf5fafa37,0xed8cf1be,0xe59de979,
0xdf35e226,0xdad5dcc2,0xd863d95d,0xd7a9d7dc,0xd7efd7b9,0xd879d835,0xd8f3d8b9,0xd920d917,
0xd8e3d911,0xd7f6d884,0xd6d2d756,0xd673d681,0xd769d6bd,0xd9cad877,0xdd20db56,0xe146df19,
0xe59fe379,0xe9a8e7aa,0xedbdebac,0xf1f3efdb,0xf5faf3ff,0xf9eef7f1,0xfe0dfbeb,0x02f20067,
0x0849059a,0x0d840ae8,0x13601049,0x1a6916cc,0x21b41e1b,0x27e524fb,0x2c8a2a6a,0x2fa62e41,
0x31a930c1,0x32a53253,0x32043288,0x30293138,0x2d6d2ee3,0x2a072bcc,0x25fe280c,0x21bb23e3,
0x1d6f1f96,0x19b21b6f,0x1749184b,0x164a16a1,0x16611637,0x175f16bb,0x19c1185e,0x1c8a1b46,
0x1d151d2d,0x1aad1c45,0x15871869,0x0ec7123e,0x076b0b28,0xffbf0399,0xf721fba5,0xed23f22a,
0xe47de87f,0xde35e11a,0xd958dbb2,0xd4dfd712,0xd175d2f4,0xcff2d081,0xcf97cfaa,0xcfc7cfa7,
0xcfefcfe6,0xcf5ecfc7,0xce09cebb,0xcd82cd8d,0xced7cdf3,0xd1bed01b,0xd5ded3ad,0xdac5d83f,
0xe029dd68,0xe661e31f,0xee52ea1a,0xf71df2c4,0xfefefb2b,0x068b02bd,0x0dee0a5b,0x13eb1123,
0x18161641,0x1b1b199b,0x1edb1cc8,0x24882163,0x2c6c284a,0x33c4306c,0x37c0363b,0x38853876,
0x36b937f4,0x3306350a,0x2dca309d,0x26b12a81,0x1dec2262,0x15241980,0x0d171107,0x05440930,
0xfcfb0132,0xf453f8a8,0xebfff022,0xe416e7e8,0xddd8e0b7,0xda17dba6,0xd88cd909,0xd8c4d881,
0xd9cbd93e,0xdacbda4e,0xdb83db32,0xdbc9dbb6,0xdb98dbc1,0xdab7db40,0xd9aada23,0xd977d964,
0xda85d9d9,0xdc84db6a,0xdf46ddca,0xe2dee0ff,0xe6b0e4ca,0xea3ae878,0xedc5ebfe,0xf14cef8d,
0xf4c3f300,0xf87af695,0xfc8afa78,0x0101feb6,0x05b00356,0x0ad50820,0x11440ddb,0x18fd1503,
0x20d21cf6,0x27b32474,0x2cda2a82,0x303a2eb5,0x32723180,0x33203307,0x323d32d1,0x309a317b,
0x2e742f9e,0x2b6d2d11,0x27a729a0,0x239c25a2,0x1f6d2186,0x1bd31d7a,0x198c1a83,0x186118d4,
0x17f2181b,0x186117f7,0x1a4e193d,0x1b641b26,0x19a51adf,0x154817c0,0x0efe1248,0x08630bac,
0x0202052f,0xfb3efeca,0xf2dbf742,0xea0cee57,0xe2dbe62d,0xddbce018,0xd941db7c,0xd534d724,
0xd287d39e,0xd178d1de,0xd134d13f,0xd138d133,0xd0e7d122,0xd024d094,0xcf39cfa0,0xcfa8cf34,
0xd1a7d07e,0xd4fed324,0xd977d727,0xde53dbda,0xe3abe0ee,0xea2ce6b0,0xf270ee27,0xfabaf6b5,
0x020dfe6f,0x097105c1,0x101a0ceb,0x156312ef,0x1904175c,0x1c531a9f,0x205c1e31,0x2646230b,
0x2d3629c8,0x323e301c,0x34223391,0x33553407,0x30d3323b,0x2cf62f17,0x27ce2a86,0x210b24a4,
0x196a1d3b,0x121d15ae,0x0b240e9c,0x03ec07a1,0xfbe2fffa,0xf3b0f7c7,0xeb4cef83,0xe370e731,
0xdd87e032,0xda21db7f,0xd931d961,0xd9e8d968,0xdb20da89,0xdc07dba4,0xdc8cdc55,0xdcbddca9,
0xdca2dcc3,0xdbd9dc4c,0xdb46db75,0xdbc4db63,0xdd09dc52,0xdf17ddf4,0xe1fae06c,0xe5b6e3c7,
0xe960e79a,0xeca4eb0a,0xefb3ee2f,0xf297f131,0xf595f406,0xf8d1f734,0xfc4afa7a,0x003afe3c,
0x0464023c,0x099606d3,0x10390cb9,0x17e313ff,0x1f4c1bac,0x25a422a1,0x2a6b283a,0x2dfc2c56,
0x30512f55,0x310e30e3,0x308c30e2,0x2fa63023,0x2e4e2f0f,0x2c2c2d55,0x29562ad3,0x25d027ad,
0x21c923ca,0x1e501fef,0x1bfa1d02,0x1a671b26,0x193e19b7,0x196a191f,0x1a8319fb,0x1a111a97,
0x16f018d9,0x11671472,0x0a890e06,0x03e5071f,0xfdfa00de,0xf7e0fb0c,0xf080f451,0xe91fecae,
0xe386e618,0xdf4be14c,0xdb31dd41,0xd72ad91c,0xd459d58a,0xd304d392,0xd23cd292,0xd1aad1ee,
0xd104d15b,0xd037d09f,0xcff6cff3,0xd146d06a,0xd3d6d26a,0xd794d593,0xdbefd9ba,0xe098de3a,
0xe5a8e307,0xebf5e899,0xf3cdefc6,0xfb7ff7c2,0x029aff0e,0x09ab062c,0x10090cfa,0x156112d7,
0x19b417aa,0x1d981b96,0x226b1fde,0x28782547,0x2e8f2bba,0x320830b7,0x32743295,0x306e31b2,
0x2d1d2ee4,0x28da2b15,0x237b265a,0x1d002053,0x164b199e,0x10261329,0x0a0b0d27,0x02fa06a6,
0xfb03ff08,0xf2e3f6fc,0xea5feeae,0xe25fe62f,0xdcbbdf35,0xd9d2daf3,0xd940d948,0xda3bd99c,
0xdb89dae9,0xdc6fdc09,0xdd38dcd9,0xddb9dd7f,0xddb3ddd3,0xdd10dd62,0xdce8dce1,0xdd82dd22,
0xdec7de0e,0xe0b4dfa9,0xe37de1f6,0xe6efe530,0xea3be89d,0xed37ebbf,0xf011eeab,0xf2cbf16c,
0xf5ebf44f,0xf8edf77a,0xfbc9fa58,0xfef6fd4d,0x030600d0,0x08890593,0x0f800bd9,0x176c1366,
0x1f021b5d,0x255b225e,0x2a5627fc,0x2e042c5c,0x30362f46,0x30fa30c7,0x309f30e1,0x2fd03044,
0x2e832f3a,0x2ca92da0,0x2a802ba1,0x27be2930,0x24ad2634,0x2222234f,0x202f211e,0x1e421f3b,
0x1ce91d6f,0x1ca31cb3,0x1b951c5c,0x17f81a21,0x11d51529,0x0a300e19,0x02cd0661,0xfc87ff84,
0xf70df9bf,0xf16ef452,0xeb40ee5f,0xe5f7e865,0xe226e3eb,0xdec1e07e,0xdae5dce0,0xd752d901,
0xd4f2d5f3,0xd346d41a,0xd1d9d27e,0xd0edd154,0xd076d0a4,0xd0d5d07c,0xd27dd17a,0xd571d3d4,
0xd8f8d72a,0xdcbcdad8,0xe073de98,0xe477e266,0xe93de6ba,0xef75ec1d,0xf6eaf326,0xfe09fa88,
0x05170187,0x0c04089e,0x12710f49,0x18311570,0x1ce21aa4,0x218e1f27,0x26c7241d,0x2bfc297f,
0x2f632dfb,0x30123021,0x2de12f3b,0x2a782c43,0x2655286d,0x21d62433,0x1c7f1f3c,0x16ca19a5,
0x115513fe,0x0c6f0edc,0x071709de,0x00a20405,0xf98ffd1f,0xf19ff5c1,0xe8deed40,0xe144e4c3,
0xdc6bde79,0xda65db14,0xda8eda47,0xdbbfdb1c,0xdd04dc64,0xde1add93,0xdec9de80,0xdef5deee,
0xde6fdec9,0xddfcde20,0xde53de0e,0xdf47debd,0xe0d6dff4,0xe335e1eb,0xe65be4b6,0xe993e802,
0xec4feb01,0xeecbed95,0xf109efe9,0xf3bbf24e,0xf6aef537,0xf952f812,0xfb93fa6c,0xfebafcf7,
0x033c00d3,0x09130600,0x0feb0c67,0x176313a5,0x1e5d1b07,0x242f2168,0x28cc26a6,0x2c252aa1,
0x2e552d64,0x2f932f0f,0x300c2fe5,0x2fd1300d,0x2e9a2f51,0x2cda2dbd,0x2acd2be6,0x284a2996,
0x258926e5,0x231b2445,0x20dd21f8,0x1eaf1fc3,0x1d111dbc,0x1c671cae,0x1aef1bf3,0x16d6193a,
0x0ff813bf,0x07510bb3,0xff3a0317,0xf876fbb4,0xf292f56d,0xecc0efbf,0xe6cee9ae,0xe2bbe474,
0xe064e170,0xde30df5e,0xdb6ddcd9,0xd8d4da0b,0xd70ed7d8,0xd591d64e,0xd433d4e6,0xd2f3d381,
0xd270d296,0xd2e0d27c,0xd4e9d3a7,0xd887d699,0xdca5da8f,0xe0d1dec6,0xe4a2e2c3,0xe86be67d,
0xecdaea79,0xf2fcefb2,0xf9c8f66e,0x001afcf9,0x06c9035e,0x0d850a36,0x13d510c0,0x19021699,
0x1d2b1b22,0x21461f33,0x25a72368,0x2a3427fe,0x2cf42bf4,0x2c3a2d07,0x28e92ac5,0x24e426e1,
0x20c922db,0x1c701eac,0x17aa1a15,0x12c01531,0x0e4c1073,0x0a0f0c33,0x053207b4,0xff8a027c,
0xf94ffc80,0xf1c8f5bd,0xe9a9eda7,0xe2ede610,0xde74e060,0xdca3dd3a,0xdcd8dc92,0xddc9dd47,
0xdeb1de47,0xdf5bdf0f,0xdfb5df91,0xdfc1dfc9,0xdf7adfa0,0xdf85df68,0xe032dfcd,0xe14be0b1,
0xe306e20b,0xe5b2e43d,0xe914e75e,0xebe2ea97,0xee0ced03,0xf01aef0f,0xf285f145,0xf530f3d8,
0xf7a5f688,0xf8fef866,0xfaa1f9af,0xfd8bfbe8,0x01ccff84,0x072b0458,0x0d8c0a3e,0x149c110e,
0x1b671816,0x214c1e75,0x261d23d9,0x29cf281a,0x2c902b44,0x2eb62db6,0x303b2f8c,0x30be30a7,
0x2fff307e,0x2e882f58,0x2ca62da3,0x2a6b2b88,0x289b296e,0x270527d4,0x250b261d,0x22cd23de,
0x215821f8,0x1fab20b3,0x1ba71e02,0x14ac188d,0x0b4d102b,0x01a10666,0xf907fd23,0xf1e4f554,
0xeb3bee8c,0xe4fde7fb,0xe08de274,0xde98df51,0xdda7de1a,0xdcb5dd2e,0xdbbcdc38,0xdaa2db3b,
0xd904d9e3,0xd71ed815,0xd51ed61d,0xd383d434,0xd33cd328,0xd4f5d3d5,0xd8c8d6a4,0xdd85db27,
0xe1e9dfc4,0xe5d8e3ed,0xe94ee7a0,0xeccfeafa,0xf18aeeff,0xf72cf459,0xfc92f9e6,0x027eff6a,
0x092405c5,0x0faf0c7c,0x156a12b0,0x1a6517f5,0x1ed71caf,0x22fd20ec,0x273d2522,0x2a58290e,
0x2ab32aeb,0x27fb29af,0x238925d1,0x1ef42144,0x1a9f1cb8,0x16641887,0x12101439,0x0ded0ff9,
0x0a020bf8,0x06120809,0x01fd0419,0xfd82ffc5,0xf82ffb0f,0xf13ef4d7,0xea25eda0,0xe43ce6f5,
0xe0c0e22e,0xdf66dfd9,0xdf57df45,0xdfc4df89,0xe01adff7,0xe01ee024,0xe021e01b,0xe037e02a,
0xe070e04b,0xe10fe0ab,0xe201e186,0xe311e27a,0xe50be3e7,0xe82fe680,0xeb73e9e3,0xedd4ecc4,
0xefa9eec3,0xf195f09a,0xf3adf299,0xf5e0f4cf,0xf746f6b1,0xf83af7be,0xf9d5f8e6,0xfc9cfb10,
0x0077fe6a,0x057002cc,0x0baf086a,0x129b0f18,0x193f15ff,0x1f2b1c4e,0x242421cc,0x28152637,
0x2b8c29d3,0x2ec72d35,0x311d301f,0x31de31b1,0x314131b3,0x2f9f308f,0x2d4e2e7c,0x2b422c34,
0x29f02a85,0x28dc296f,0x27572824,0x262126a3,0x252725bb,0x2221240b,0x1bd41f62,0x12811782,
0x07b60d24,0xfd630262,0xf473f8be,0xec4ff053,0xe4d6e872,0xdf1be1a9,0xdc42dd55,0xdb48dbad,
0xdb0ddb09,0xdbcfdb56,0xdc9ddc4a,0xdcacdcc1,0xdb7edc3f,0xd919da69,0xd64fd7ab,0xd480d53a,
0xd4a8d44b,0xd750d5af,0xdbe1d972,0xe0e1de6c,0xe553e32e,0xe916e749,0xec73eac5,0xf058ee43,
0xf500f29f,0xf9a8f75d,0xfe9efc05,0x04aa0188,0x0b1707e5,0x10ff0e26,0x163313a8,0x1afa18a0,
0x1f6d1d3e,0x23dc219f,0x27d22608,0x296328f4,0x27f1290a,0x24162632,0x1f7521d0,0x1af21d1e,
0x16cf18df,0x12a514bf,0x0ea910a1,0x0abf0cb1,0x06b608ba,0x02fd04cf,0xffad0142,0xfc77fe24,
0xf815fa83,0xf227f53e,0xebcdeeef,0xe6a4e8fb,0xe3a9e4e0,0xe24de2d7,0xe1aee1f1,0xe14ce17d,
0xe0c6e111,0xe00de069,0xdf7cdfba,0xdf70df64,0xdfefdf9c,0xe0dae05d,0xe1e5e15f,0xe344e27d,
0xe5bee455,0xe935e76d,0xec5ceaec,0xee7aed82,0xf04aef64,0xf211f12b,0xf410f30b,0xf5aff4f6,
0xf6c8f644,0xf803f757,0xfa1ff8e9,0xfd39fb8f,0x0126ff14,0x062c037e,0x0c6c092d,0x12eb0fb5,
0x19271611,0x1ef01c21,0x23cb217b,0x27eb25eb,0x2bc629da,0x2f502da2,0x31af30b4,0x32883248,
0x32113273,0x3055315c,0x2dd92f1e,0x2bd52cbc,0x2a7a2b1c,0x290229c9,0x27aa2835,0x27a72788,
0x271c27af,0x23172596,0x1b371f9c,0x10521602,0x04b60a7c,0xfa09ff2d,0xf093f53b,0xe78eebfe,
0xdf9de356,0xda66dc9b,0xd819d8f6,0xd751d798,0xd7b9d74a,0xd9cdd89b,0xdc4adb1b,0xdd91dd27,
0xdca7dd6c,0xd9dddb65,0xd6d0d841,0xd565d5d2,0xd66ed597,0xda17d7f5,0xdf49dc9a,0xe48be1fb,
0xe911e6ee,0xec98eaf1,0xf000ee33,0xf475f219,0xf938f6e6,0xfd95fb68,0x0290ffed,0x085f056f,
0x0e2c0b4f,0x136210dc,0x181715c5,0x1ca61a62,0x212b1ee1,0x25fe2398,0x28df27d7,0x286f2914,
0x24ec26fb,0x200f2293,0x1b081d77,0x16a318cd,0x126b1486,0x0e3d104d,0x0a280c36,0x05eb080e,
0x01db03cf,0xfeae0024,0xfc89fd85,0xfa62fb93,0xf69bf8ba,0xf169f420,0xec02eea5,0xe7eae9b6,
0xe598e692,0xe44ce4d9,0xe364e3d0,0xe292e2fc,0xe18de216,0xe09ae111,0xe008e03f,0xe026dffe,
0xe0e1e073,0xe1e3e160,0xe2fce26d,0xe4a5e3b2,0xe770e5e7,0xeaece92c,0xedceec7d,0xeff4eeeb,
0xf1daf0f1,0xf39ff2bb,0xf50ef468,0xf5fff595,0xf6cff65f,0xf827f75f,0xfa41f91f,0xfd3dfba5,
0x0128ff0a,0x0678039e,0x0ca9098d,0x12b60fb3,0x18a615b3,0x1e201b79,0x22b22085,0x270e24dc,
0x2b5d293c,0x2f112d4d,0x31d53096,0x337732cc,0x33a833c5,0x32553327,0x30873166,0x2f1b2fc8,
0x2d662e5d,0x2b422c4a,0x2a3e2a8e,0x29f52a33,0x27862922,0x217c24fd,0x17de1d0e,0x0c7d1244,
0x00e7069b,0xf647fb79,0xec2cf133,0xe2b5e745,0xdb79deb9,0xd71dd8f6,0xd4b0d5c0,0xd37ad3df,
0xd47fd3b1,0xd778d5d4,0xda7fd914,0xdc2cdb93,0xdbb0dc37,0xd9b4dac6,0xd7f2d8ab,0xd81fd7be,
0xda9ad90f,0xdef8dc9f,0xe429e18c,0xe8f8e6b0,0xecdbeb0d,0xf036ee84,0xf463f229,0xf937f6cd,
0xfd96fb75,0x0218ffc0,0x074f04a6,0x0cbc0a07,0x11cb0f55,0x16211412,0x1a24181c,0x1e331c2a,
0x22a2205e,0x25ab248b,0x25bd260b,0x22fb24ad,0x1ead20f0,0x19d21c42,0x15821791,0x11e613a7,
0x0e431019,0x0a760c66,0x06470869,0x01ac03ff,0xfda1ff80,0xfb13fc21,0xf9d0fa68,0xf7fff907,
0xf503f6a8,0xf126f325,0xed50ef22,0xea73ebc4,0xe893e968,0xe70be7cd,0xe59ee652,0xe409e4db,
0xe262e32b,0xe112e1a9,0xe095e0b3,0xe12fe0c1,0xe247e1b3,0xe384e2de,0xe527e447,0xe748e629,
0xe9ece887,0xecc3eb5f,0xef38ee06,0xf159f05a,0xf321f241,0xf489f3ea,0xf56bf507,0xf609f5bb,
0xf6f6f66c,0xf88af7ab,0xfab8f98c,0xfd93fc0d,0x0176ff57,0x06aa03f5,0x0c3b0973,0x11d90f02,
0x17a314c3,0x1ce71a60,0x21c91f55,0x26c7244a,0x2b382918,0x2ede2d29,0x319d3058,0x334b32a2,
0x3374338e,0x32883315,0x317131ec,0x30743101,0x2e972fa5,0x2cda2d8c,0x2c932c9c,0x2b822c59,
0x277129e2,0x1fb32414,0x15021a89,0x09800f4e,0xfe3903ce,0xf328f8b1,0xe82fed98,0xded8e32b,
0xd8a3db55,0xd4f6d69f,0xd22cd379,0xd105d149,0xd26ed16f,0xd598d3de,0xd8d4d75a,0xda59d9e2,
0xd9ddda4a,0xd897d93c,0xd821d828,0xd9b7d8a4,0xdd27db39,0xe225df80,0xe777e4db,0xebfbe9d8,
0xefb6ede9,0xf39bf18c,0xf870f5f9,0xfd10facf,0x019cff46,0x06c3041f,0x0bf6096a,0x10c00e5e,
0x14d812f2,0x18261687,0x1b5019b9,0x1f5e1d2a,0x236e21a0,0x24a3246c,0x22d82418,0x1f262120,
0x1aa01cf7,0x16131847,0x12681426,0x0f0110b0,0x0bbe0d61,0x08230a0a,0x039c05f4,0xfebf0130,
0xfacdfc88,0xf917f9b4,0xf81df8a0,0xf669f767,0xf3b8f526,0xf097f22a,0xeddaef22,0xebcaecbd,
0xea22eaf6,0xe861e942,0xe679e774,0xe47de575,0xe2bee395,0xe17de202,0xe173e14c,0xe27ae1e1,
0xe3b2e31c,0xe507e44d,0xe6e8e5ed,0xe913e7f1,0xeb68ea41,0xedb7ec8a,0xf00beeea,0xf220f11d,
0xf3ddf310,0xf50ef48d,0xf5a3f564,0xf62cf5db,0xf72bf698,0xf8b9f7df,0xfadcf9be,0xfdaafc21,
0x01cfff93,0x06c4043d,0x0c020957,0x11ce0ed6,0x179e14c4,0x1d031a5e,0x224e1fa6,0x277f24f6,
0x2be129cf,0x2f572db7,0x321e30d5,0x33c7331a,0x346d3438,0x347e347f,0x34483473,0x32f433c7,
0x30ed31ef,0x2fa2302d,0x2e1a2f0a,0x2a5b2c98,0x238d2757,0x19f71efc,0x0f4d14b4,0x047409dc,
0xf9a2ff13,0xee34f3fb,0xe3a5e8a4,0xdbdedf63,0xd6b0d905,0xd2ccd4aa,0xcfb9d114,0xcee2cef2,
0xd08bcf76,0xd3a1d1ff,0xd6a0d542,0xd839d7a2,0xd8b0d88b,0xd93fd8d9,0xdb23d9fd,0xde84dcae,
0xe2d2e08c,0xe7eae559,0xeca4ea62,0xf077eea7,0xf42df243,0xf881f63f,0xfcfbfaca,0x0134ff0e,
0x06320391,0x0b7f08eb,0x10150de1,0x13e8121a,0x16da1578,0x19601823,0x1ca31aca,0x20a51ebd,
0x226c21ee,0x2125222b,0x1dab1f8e,0x19891ba6,0x15301757,0x11741336,0x0e510fd6,0x0b8b0ce9,
0x08a90a28,0x051806fe,0x008d02ed,0xfbbbfe12,0xf8a3f9dd,0xf75df7df,0xf655f6e7,0xf4e3f5aa,
0xf329f40d,0xf165f242,0xefa3f086,0xede6eec5,0xec06ecfb,0xe9f0eaff,0xe7bae8d1,0xe5b0e6b3,
0xe3c0e4ac,0xe2a1e30d,0xe2d7e297,0xe3d6e348,0xe525e474,0xe6d4e5f4,0xe8c5e7c4,0xea94e9ba,
0xec67eb75,0xee98ed77,0xf0bbefad,0xf28ff1b4,0xf418f35b,0xf537f4b6,0xf5e0f592,0xf699f638,
0xf785f704,0xf8f7f82b,0xfacef9d0,0xfdd2fc20,0x01faffcc,0x069f043d,0x0beb092c,0x11d80ed9,
0x17da14d7,0x1de81adf,0x23c620e6,0x28f2267e,0x2ce52b10,0x30072e8e,0x32323141,0x336432e9,
0x33de33b5,0x340233f5,0x33a533ec,0x326b3322,0x312031b3,0x306e30c4,0x2e5b2fbb,0x29532c39,
0x214525a5,0x17391c66,0x0ca711ef,0x022c076e,0xf70bfcb3,0xebdaf156,0xe250e6d3,0xdb2fde6b,
0xd632d884,0xd216d40c,0xcf4cd079,0xceaaceb2,0xcffacf1f,0xd261d123,0xd454d378,0xd562d4f0,
0xd62cd5b9,0xd83ed6ff,0xdbd2d9e1,0xe075de08,0xe5f9e31f,0xeb81e8d2,0xf025edf5,0xf3d1f20a,
0xf789f5a4,0xfb98f98d,0xffebfdb2,0x04e20247,0x0a7107a5,0x0f3d0cfe,0x1300113f,0x15f71494,
0x18641740,0x1ac71979,0x1e511c75,0x211d1ffa,0x213c2191,0x1e742024,0x1a451c70,0x15d91810,
0x11dc13bd,0x0eab102f,0x0c1b0d53,0x09cb0af5,0x0725088b,0x03950580,0xfee3015c,0xfa66fc70,
0xf7eef8ee,0xf6bff73d,0xf59bf63c,0xf410f4dc,0xf2a1f351,0xf142f1f0,0xefd1f08d,0xee0feefd,
0xebe8ed02,0xe99eeac6,0xe768e87a,0xe550e658,0xe3afe462,0xe313e340,0xe3a4e33d,0xe4e1e435,
0xe680e5a2,0xe875e771,0xea47e96e,0xebb7eb04,0xed46ec77,0xef26ee2b,0xf105f024,0xf27ff1c7,
0xf395f319,0xf46bf404,0xf51ff4c9,0xf5ebf57b,0xf740f684,0xf907f819,0xfb97fa2b,0xff38fd4a,
0x034e013d,0x07cd0575,0x0d000a58,0x12770fb1,0x185e1561,0x1e5d1b5d,0x2439215d,0x291326d1,
0x2cc52b08,0x2fa02e4d,0x31b230c2,0x32f6326b,0x33de336b,0x346c343a,0x3417345b,0x337133ba,
0x33383349,0x322b32f9,0x2e6c30ad,0x27912b5b,0x1e442324,0x13ca1919,0x09640e88,0xff18044f,
0xf475f9c2,0xea96ef5e,0xe25de63d,0xdbd3dee9,0xd668d90c,0xd1aed3e4,0xce9bcfe2,0xcdbccde7,
0xce7acdf5,0xcfdfcf30,0xd0eed070,0xd1f5d16a,0xd3e0d2b9,0xd771d56a,0xdc85d9d4,0xe262df62,
0xe878e56f,0xee12eb61,0xf291f077,0xf651f474,0xfa4bf844,0xfe71fc5b,0x032800a9,0x08e005ed,
0x0ea10bdb,0x13061106,0x160e14a9,0x18671743,0x1a97197d,0x1d571bdd,0x201a1eda,0x211b20ed,
0x1f52208b,0x1b881d94,0x176b1970,0x139b1576,0x102911dc,0x0d280e96,0x0ac50be9,0x0866099a,
0x05ae0722,0x01eb03f1,0xfd47ff9d,0xf983fb2e,0xf736f83b,0xf58cf658,0xf3c8f4b2,0xf229f2f0,
0xf0c7f16f,0xef99f02b,0xee30eef2,0xec5aed51,0xea53eb5b,0xe84ee949,0xe66be75e,0xe4c1e584,
0xe3d9e42c,0xe3e6e3bd,0xe4fae455,0xe6bfe5ce,0xe8cae7bc,0xeaf2e9e5,0xeca6ebe3,0xedb5ed3b,
0xee9fee24,0xefb8ef2d,0xf0d3f043,0xf1e4f162,0xf2ecf262,0xf420f383,0xf53bf4b0,0xf666f5ca,
0xf7d5f717,0xf9c5f8b3,0xfca6fb14,0x002efe62,0x040f020b,0x08f4065f,0x0e690bad,0x142b1134,
0x1a691747,0x20801d7d,0x25f8235e,0x2a3f2843,0x2d682bf2,0x2fd22eae,0x31b130d6,0x331e326d,
0x345033c3,0x34c334a9,0x34bf34ba,0x353234ea,0x35023561,0x31e133d9,0x2b862f14,0x22c22758,
0x190b1df5,0x0f09140e,0x052a0a16,0xfafe0021,0xf13ff5fb,0xe904ece7,0xe293e59d,0xdcb1dfa4,
0xd713d9d1,0xd245d484,0xcf1fd07d,0xcd95ce2f,0xcd02cd35,0xcce8cce8,0xcd31cd00,0xce82cd9f,
0xd1c6cfe9,0xd701d427,0xdd72da23,0xe41ae0ca,0xea72e752,0xf023ed67,0xf513f2ac,0xf9b3f775,
0xfe03fbe1,0x025b0021,0x07c504e4,0x0dd10ace,0x132910a8,0x16a3152c,0x18b217be,0x1acc19b3,
0x1d831c08,0x209a1f25,0x21fa219c,0x208a219b,0x1cde1ee1,0x188e1ab4,0x149d1688,0x111612d3,
0x0da90f53,0x0aaa0c15,0x0859097a,0x061b073f,0x035104d1,0xff66017f,0xfb4bfd46,0xf828f994,
0xf5caf6e9,0xf3f0f4d2,0xf267f318,0xf17ff1e4,0xf0b9f11e,0xef89f039,0xedbfeeb1,0xeba7ecbd,
0xe977ea89,0xe786e87b,0xe5aae691,0xe46ae4f0,0xe438e430,0xe4f3e47b,0xe680e5a0,0xe889e77b,
0xeaebe9b2,0xecfbec08,0xee57edc2,0xef17eec4,0xefc3ef68,0xf065f013,0xf116f0bc,0xf1c4f16c,
0xf2abf229,0xf3cdf33f,0xf511f464,0xf68af5ce,0xf816f743,0xfa51f91e,0xfd24fbae,0x0033fe9e,
0x041201fb,0x09100679,0x0e950bc9,0x14d21192,0x1bd9184d,0x22b41f63,0x285725b1,0x2ca32aa7,
0x2f7b2e39,0x31b4309f,0x338332b1,0x34eb3445,0x35ba3572,0x35d935cf,0x365d3602,0x371736da,
0x35a736c3,0x30e233b9,0x29152d43,0x1fd0248a,0x16191b01,0x0c001115,0x016d06cc,0xf6bdfc00,
0xed5ef1d2,0xe620e980,0xe02ce317,0xdaa5dd5b,0xd58ad804,0xd110d334,0xcd9acf2a,0xcb6bcc60,
0xc9f6caa2,0xc936c976,0xc9a1c93a,0xcc25ca93,0xd0c0ce2e,0xd717d3c7,0xde2ada99,0xe50ee1ac,
0xebaae866,0xf1eceed2,0xf802f501,0xfd55facc,0x01e9ffa5,0x070a044f,0x0d400a15,0x1351105d,
0x181315f7,0x1aa01994,0x1c591b78,0x1e991d5b,0x21522001,0x22e12250,0x223e22ea,0x1eea20dd,
0x1a431c9c,0x15f8180a,0x125d1412,0x0eec10ae,0x0b7a0d28,0x08b509ff,0x0693079b,0x04400577,
0x013a02d7,0xfd9fff72,0xfa1efbd3,0xf6fbf875,0xf496f5b5,0xf2caf39e,0xf1a8f21f,0xf0f1f14d,
0xefd4f075,0xedf9eeff,0xeba1ecd8,0xe932ea66,0xe72ee822,0xe581e64c,0xe448e4cb,0xe3f9e406,
0xe4a6e430,0xe63ae556,0xe863e746,0xeadee998,0xed85ec35,0xef8aeea3,0xf09ff035,0xf0f8f0d4,
0xf11df110,0xf152f131,0xf19df177,0xf1e3f1c1,0xf27bf222,0xf384f2f1,0xf513f43e,0xf6bcf5eb,
0xf8a7f7a0,0xfb0cf9cf,0xfd96fc4c,0x00a9fefd,0x04e502a5,0x09ea0756,0x0f8f0ca8,0x15fd12a6,
0x1d2a1983,0x241020bc,0x29b5270b,0x2ddf2c00,0x30872f53,0x32b531a5,0x348633ac,0x359f3533,
0x35ce35cf,0x35bc35b2,0x36653601,0x360f3685,0x32d434da,0x2c5c2ffa,0x23dc2835,0x1b1a1f7a,
0x123716af,0x08d50daa,0xfe6d03b3,0xf46cf943,0xec34f001,0xe5d4e8e1,0xe010e2eb,0xdad5dd57,
0xd625d87d,0xd18fd3d2,0xcd7ecf71,0xca51cbc5,0xc802c909,0xc709c756,0xc807c732,0xcba7c98e,
0xd11fce37,0xd79ed445,0xde69db0b,0xe4f1e1ab,0xeb81e83e,0xf25deeda,0xf978f5f5,0xffa6fcbd,
0x0544026a,0x0b9a0853,0x12280eee,0x17ee1532,0x1bb91a27,0x1dae1cd5,0x1f6a1e7b,0x219f2077,
0x238422b9,0x236823cd,0x2096224f,0x1bfc1e6b,0x175f1996,0x13951561,0x105411ef,0x0cb80e91,
0x093f0ae1,0x06c007df,0x04ca05c5,0x029903bf,0xffef014f,0xfd2bfe90,0xf9f8fba7,0xf6ccf84e,
0xf43df56f,0xf288f345,0xf1b5f20c,0xf0b6f151,0xeedfefe9,0xec40ed9a,0xe980eae5,0xe6f8e827,
0xe500e5ec,0xe38ee434,0xe32fe332,0xe3eee36d,0xe5aae4b3,0xe7dbe6ba,0xea38e8fd,0xed08eb91,
0xefd7ee7c,0xf1d2f100,0xf2a6f25d,0xf295f2ba,0xf224f257,0xf1dff202,0xf1a7f1c2,0xf168f185,
0xf198f16a,0xf2c1f206,0xf4adf3b1,0xf6bff5ad,0xf948f7f6,0xfbe5fa9d,0xfe5afd15,0x0184ffd1,
0x058e0371,0x0a5907dc,0x10190d1b,0x16b3134c,0x1df71a4a,0x24c5217e,0x2a7e27c7,0x2ea82ccf,
0x3124300f,0x32d4320d,0x33f63377,0x3463344b,0x342d344d,0x344d3424,0x351934af,0x34d23543,
0x3177339a,0x2ab92e74,0x2252269c,0x19b61e01,0x112a1578,0x07b60c96,0xfd9b02a5,0xf441f8c6,
0xec89f02b,0xe62ce94a,0xe05ee32d,0xdb98ddda,0xd762d972,0xd32ad54a,0xcf21d11d,0xcb34cd23,
0xc7f9c976,0xc667c6e4,0xc781c697,0xcafbc8fe,0xd032cd69,0xd669d33b,0xdd10d9b8,0xe3b0e069,
0xea52e6f6,0xf19beddc,0xf943f56e,0x00a0fcfe,0x081d0452,0x0f920bf1,0x161012f4,0x1aea18c6,
0x1da91c82,0x1f2f1e82,0x204a1fc5,0x218b20d7,0x22d3224c,0x224622e5,0x1ef820e5,0x1a611cb5,
0x165a1837,0x131914aa,0x0fbd1179,0x0bd00ddc,0x085e09f0,0x05ef0709,0x03da04e6,0x01cf02d8,
0xff9800b4,0xfd21fe6f,0xfa2dfbb1,0xf75ef8b7,0xf4e8f619,0xf2fdf3db,0xf1b1f252,0xf001f0ec,
0xeda8eef0,0xeaccec3d,0xe7e3e957,0xe554e68c,0xe33ee430,0xe23ee290,0xe2e9e263,0xe4bce3b2,
0xe725e5ef,0xe95fe846,0xebb5ea78,0xee7fed13,0xf110efdd,0xf290f1fa,0xf307f2e8,0xf2bbf2f0,
0xf25df288,0xf203f22f,0xf19af1d4,0xf145f16a,0xf167f13a,0xf27bf1d7,0xf415f336,0xf662f525,
0xf943f7cc,0xfbf0fa9f,0xfed3fd4e,0x02480078,0x067a044c,0x0b8508d9,0x11ae0e78,0x18901510,
0x1fb51c26,0x268e2338,0x2c8129b3,0x30d02edb,0x33a63266,0x358334a4,0x36d43648,0x36ee370c,
0x366e36a5,0x36883673,0x35d83671,0x32b6349b,0x2caf300d,0x247328bc,0x1bc92015,0x1399179d,
0x0b9f0fad,0x02d10751,0xf9bbfe3a,0xf1d9f593,0xeb67ee7f,0xe57ce867,0xe03ce2ba,0xdbd5ddeb,
0xd7d8d9de,0xd379d5b8,0xce90d113,0xc9c2cc11,0xc655c7c9,0xc5bbc599,0xc849c6ac,0xccfcca6c,
0xd2cacfd2,0xd8b4d5c3,0xde7fdba2,0xe42be152,0xeab1e741,0xf261ee63,0xfaa3f688,0x02e1febb,
0x0b440710,0x13090f46,0x19521663,0x1dc41bcc,0x208a1f4d,0x224c218d,0x235322cb,0x248e2402,
0x246024bc,0x2185234b,0x1cbd1f46,0x17ab1a15,0x13de15a0,0x109b123c,0x0cf50ee1,0x09010aef,
0x05cd0741,0x03c104aa,0x024c02f8,0x00d7019c,0xff2e000f,0xfc99fe0b,0xf96bfaff,0xf6a4f7f2,
0xf482f57f,0xf301f3b5,0xf19bf260,0xef83f0a6,0xec97ee22,0xe969eb04,0xe647e7c7,0xe39be4e8,
0xe192e26e,0xe14de12f,0xe2e3e1ef,0xe587e41c,0xe85ce6f9,0xeb21e9ba,0xee0bec93,0xf0ddef7d,
0xf2ecf20a,0xf3f0f391,0xf40af413,0xf3a8f3e0,0xf312f369,0xf223f2a2,0xf136f1a6,0xf0b4f0e0,
0xf109f0c1,0xf1fcf174,0xf3b0f2b8,0xf62ff4d9,0xf8f9f797,0xfbc0fa53,0xff06fd4e,0x02d500dd,
0x073504eb,0x0ca909c7,0x13480fdd,0x1a3316c1,0x211e1da3,0x280a24a2,0x2df92b2a,0x329c306f,
0x3605347e,0x38803757,0x39b93959,0x396539aa,0x391a3930,0x383b38e2,0x34b436db,0x2e4531d2,
0x25b92a2c,0x1cd92139,0x149f1899,0x0d7110f2,0x063c09e9,0xfe67025f,0xf6e6fa7d,0xf0d4f3ba,
0xeb20edfe,0xe57ce840,0xe099e2ea,0xdc87de7e,0xd87bda90,0xd3b2d635,0xce53d10b,0xc963cbb4,
0xc6c6c7ac,0xc777c6b5,0xcb09c8f8,0xcfedcd64,0xd4fcd280,0xd9bed76a,0xde44dc02,0xe372e0ad,
0xea6ce6b1,0xf2e0ee86,0xfba1f744,0x04b3001e,0x0d72092c,0x14fe116c,0x1acf181c,0x1f171d1d,
0x226c20dc,0x248e23a2,0x260a2557,0x26262667,0x23ea2551,0x1f9721ed,0x1a821d11,0x15eb1815,
0x1284141d,0x0f4410f5,0x0b7f0d6b,0x07d70997,0x0522065b,0x035f0429,0x023a02bc,0x014f01c1,
0xffd000bb,0xfceffe8a,0xf98bfb33,0xf6d2f817,0xf4c0f5b8,0xf2f1f3db,0xf0b3f1e4,0xedd7ef5a,
0xea81ec29,0xe743e8e2,0xe425e5ab,0xe13de2a3,0xdf86e026,0xe00fdf80,0xe267e111,0xe587e3ec,
0xe8e5e731,0xec53eaa2,0xef7eedf5,0xf208f0e2,0xf3bef2ff,0xf47cf43d,0xf48bf48e,0xf446f474,
0xf360f3ef,0xf1ecf2ab,0xf0d8f148,0xf0a8f0a2,0xf142f0e1,0xf288f1c9,0xf4ccf38d,0xf7b1f636,
0xfaacf92e,0xfdfafc44,0x0180ffbc,0x050b033e,0x093006fc,0x0ea90bbd,0x152211e1,0x1b68184d,
0x21f71e97,0x28f42577,0x2f612c48,0x34c0323b,0x38da36f8,0x3b513a53,0x3be03bce,0x3b6f3bb6,
0x3a283b00,0x36a538c4,0x301d33b9,0x27a22c05,0x1eac2323,0x16431a5d,0x0edc1267,0x08560b8c,
0x02090537,0xfb35fea7,0xf4fbf7f2,0xef61f22a,0xe9dcec97,0xe4c6e743,0xe03fe26c,0xdc2fde35,
0xd7a7d9ff,0xd259d517,0xcd12cfa3,0xc911cacb,0xc812c82a,0xc9f7c8ac,0xce2bcbe4,0xd2a6d074,
0xd6c9d4c1,0xda9dd8b4,0xdedcdca2,0xe475e176,0xebbee7d9,0xf470f004,0xfdd7f90a,0x07b602cd,
0x10c80c6a,0x182114b1,0x1dc81b1c,0x226b2036,0x260b2460,0x28322757,0x2890289a,0x269627e6,
0x22c224d8,0x1df62069,0x18fa1b7d,0x14851695,0x10e312ae,0x0d530f1c,0x09a50b82,0x065507e8,
0x04080507,0x02b60345,0x02440263,0x01d60228,0x0010012a,0xfc9dfe7b,0xf93efac9,0xf6d2f7f7,
0xf491f5af,0xf23df374,0xef64f0e2,0xec1dedcc,0xe8bfea68,0xe571e71c,0xe21fe3c3,0xdf52e09a,
0xde27de70,0xdf67de8b,0xe20ae095,0xe584e3b3,0xe977e777,0xed47eb6a,0xf089ef05,0xf2d1f1cc,
0xf3fff38c,0xf45ff441,0xf490f477,0xf486f49b,0xf39bf430,0xf228f2df,0xf184f1b2,0xf1d9f19a,
0xf2cff244,0xf472f387,0xf6b5f582,0xf968f807,0xfc71fadb,0xfff7fe2f,0x036201b1,0x06f90523,
0x0b470901,0x10b60dd8,0x16bb13be,0x1c82199b,0x22ca1f8c,0x2990262d,0x2fb92cc9,0x34a53254,
0x384936aa,0x3a133971,0x3a003a34,0x396139b5,0x37d238d3,0x33fe363f,0x2d3130f4,0x248e28f9,
0x1bd12022,0x13f017bb,0x0d431077,0x07360a2e,0x013d0445,0xfacefe07,0xf4e9f7c0,0xef9af23c,
0xea4cecfb,0xe508e7a0,0xe05ae298,0xdc0ade34,0xd744d9c2,0xd1ddd497,0xccdacf3b,0xc98bcae2,
0xc8ecc8ed,0xcaebc98d,0xcecbccc4,0xd2f9d0e0,0xd6dbd4f9,0xda8cd8b3,0xdec0dc83,0xe44ee14b,
0xebfae7e3,0xf510f061,0xff32fa07,0x09910476,0x125b0e3c,0x195e160c,0x1ede1c4d,0x22d5210d,
0x2587244c,0x27522690,0x279127b4,0x25bb26ea,0x2248242b,0x1e072038,0x19641bbb,0x15181720,
0x1167133a,0x0da80f8f,0x09bb0bb1,0x067907f1,0x04a60566,0x0401042c,0x040303fd,0x03b603ff,
0x01bd02fb,0xfe4f0016,0xfaf6fc9c,0xf7a2f94e,0xf45cf5f5,0xf118f2c0,0xed86ef5b,0xe9c1eba7,
0xe609e7ea,0xe25ae426,0xdf0ae0a4,0xdcb1ddad,0xdc67dc3c,0xde1cdd15,0xe0f3df70,0xe4c5e2b8,
0xe925e6f6,0xed53eb4e,0xf066ef0e,0xf229f166,0xf327f2b6,0xf3fbf391,0xf4d0f46d,0xf519f516,
0xf423f4c2,0xf309f37e,0xf2e4f2d7,0xf380f31b,0xf4aff40b,0xf66af578,0xf8c3f783,0xfb7afa18,
0xfe99fcfb,0x0214005a,0x058203cf,0x091a073f,0x0d610b24,0x12840fdd,0x17ce1531,0x1cfd1a60,
0x22dc1fc7,0x29792626,0x2fba2caf,0x356732a1,0x39c637e1,0x3b7f3af0,0x3b8d3ba3,0x3a8a3b3d,
0x375f394b,0x315c34b6,0x288f2d40,0x1eff23b5,0x16331a7e,0x0e751229,0x07dc0b11,0x022004e1,
0xfceaff85,0xf7c5fa4a,0xf30af560,0xee57f0b5,0xe972ebf3,0xe459e6e1,0xdfb3e1f0,0xdb41dd88,
0xd643d8db,0xd107d39b,0xccd3ceb8,0xcae3cb8a,0xcb47cad3,0xcdebcc53,0xd20ccfec,0xd5dbd404,
0xd91ad784,0xdc75dab9,0xe0a9de63,0xe65be34c,0xedeee9f0,0xf6d9f237,0x00e8fbc8,0x0b160617,
0x13d40faf,0x1aca177c,0x20201db2,0x242f223c,0x276925ee,0x293b288f,0x289f2942,0x258c275b,
0x21612382,0x1cbf1f1a,0x17ec1a5d,0x13581596,0x0f521142,0x0b930d6f,0x07dc09b8,0x0501063e,
0x03aa042a,0x03a00381,0x044303fa,0x0424045f,0x0236036a,0xff3200be,0xfc00fd9b,0xf886fa4b,
0xf4b6f6af,0xf09df2aa,0xec53ee80,0xe829ea38,0xe405e60f,0xe03de218,0xdd10de88,0xdb35dbe8,
0xdb6adb13,0xdd6cdc43,0xe0a6dedd,0xe50be2bf,0xe9d4e775,0xee14ec11,0xf0f4efb6,0xf29cf1e5,
0xf38ef322,0xf468f3fa,0xf537f4da,0xf54bf568,0xf458f4e3,0xf3aaf3e2,0xf3f3f3b9,0xf4d0f457,
0xf5f9f556,0xf7a8f6bb,0xf9c9f8b6,0xfc32faeb,0xff2efda3,0x028600d0,0x0623044c,0x0a240811,
0x0ed70c69,0x14081169,0x1918169f,0x1dfe1b80,0x23b720b7,0x2a5626f8,0x30cd2da7,0x368233c7,
0x3a7f38d0,0x3bd03b6c,0x3bb03be4,0x39e73b18,0x355b3803,0x2de631f9,0x2435293b,0x1ac61f55,
0x128a1680,0x0b830ee2,0x056d085b,0x006802cb,0xfb99fe0e,0xf6d2f926,0xf27ff4a5,0xee37f058,
0xe9c9ec17,0xe4cae74a,0xe009e25d,0xdb45ddb2,0xd5efd8a7,0xd12ad368,0xcdfdcf51,0xcd26cd4b,
0xce61cd87,0xd151cfa2,0xd505d338,0xd7dad688,0xda60d91f,0xdd67dbc4,0xe1bedf60,0xe79fe47a,
0xef40eb3a,0xf83af39b,0x01d7fd00,0x0b6f06b5,0x13e60fd9,0x1ab11791,0x1f551d3c,0x23082136,
0x261624ae,0x278b2717,0x26af276c,0x23ee2575,0x205d2238,0x1c2f1e62,0x177c19dc,0x12e41520,
0x0ede10d1,0x0af00ced,0x072a08f0,0x04b805b9,0x03f1042a,0x04710408,0x057c0501,0x058d05b5,
0x03f504f5,0x016a02be,0xfe67fff6,0xfaa1fc9d,0xf631f87a,0xf16ef3d7,0xec76eeed,0xe7aaea18,
0xe31de551,0xdf0ee102,0xdbf2dd5e,0xda3fdae4,0xda50da0a,0xdc2bdb0d,0xdf9addac,0xe451e1e0,
0xe923e6ca,0xed1beb4c,0xef9eee83,0xf137f080,0xf25cf1d2,0xf368f2e0,0xf42cf3e1,0xf416f442,
0xf364f3b8,0xf370f34b,0xf45bf3cc,0xf582f4ef,0xf6f9f62d,0xf925f7fa,0xfb80fa56,0xfe0afcb8,
0x010aff79,0x046002aa,0x08100629,0x0c390a11,0x10f90e89,0x15e31377,0x1aa21842,0x1fb31d1b,
0x257b2272,0x2c6a28d7,0x33402fea,0x38fb364f,0x3c903b16,0x3d993d54,0x3cc43d78,0x393b3b67,
0x32b13647,0x29de2e88,0x1fc624d0,0x16991b01,0x0ebd1287,0x07f00b3b,0x023d04e8,0xfde4fff3,
0xf9bafbd8,0xf572f78e,0xf165f368,0xed89ef6e,0xe935eb89,0xe3dbe697,0xde58e112,0xd8f9dbb3,
0xd3bad63f,0xcfa9d17f,0xcdd0ce6f,0xce06cdb0,0xcfd6cebb,0xd341d163,0xd6bbd51c,0xd929d80a,
0xdb9bda51,0xdeefdd19,0xe370e10e,0xe940e629,0xf0afecb9,0xf97ef507,0x0284fdfc,0x0bed0733,
0x14a7107a,0x1b951863,0x20ce1e5b,0x24b222e7,0x2734262e,0x27a227b0,0x2623271b,0x233924ce,
0x1fa02181,0x1b401d8c,0x167a18de,0x120e142b,0x0e571023,0x0aca0c95,0x0796091a,0x0577065a,
0x04f10502,0x05a40530,0x066c0621,0x0627066d,0x04bb0596,0x025603a2,0xff2800dd,0xfad8fd2b,
0xf59bf847,0xf040f2f6,0xeaf2ed8e,0xe5dbe85c,0xe135e37e,0xdd28df0e,0xda34db83,0xd8a4d940,
0xd8b5d871,0xdabfd97a,0xdeb2dc81,0xe3c9e133,0xe8b5e656,0xec6deab9,0xeefcedd9,0xf0beefee,
0xf238f17d,0xf386f2ea,0xf453f400,0xf458f478,0xf3e4f40a,0xf470f405,0xf5cbf512,0xf740f686,
0xf920f816,0xfb90fa4d,0xfe3afce5,0x00dfff89,0x03aa0240,0x06c8052a,0x0a6e088d,0x0e490c5a,
0x126c104c,0x16ad1492,0x1ae018bf,0x1f8c1d23,0x24f02213,0x2b942829,0x322b2ef7,0x37b73520,
0x3b1d39bf,0x3c133bda,0x3b133bdd,0x371b397d,0x306e340c,0x277b2c3b,0x1d92227b,0x14c218fa,
0x0d4010d6,0x06f60a05,0x0194041e,0xfd79ff67,0xf9a1fb96,0xf593f79b,0xf197f392,0xedaaefa9,
0xe8faeb76,0xe32fe62b,0xdd1ee026,0xd782da43,0xd293d4e5,0xcf36d0aa,0xcdebce45,0xce44cded,
0xd043cf06,0xd3fdd200,0xd7b9d5fb,0xda8fd935,0xdd45dbdf,0xe0d9dee8,0xe5a4e315,0xeb59e866,
0xf230ee9e,0xfa06f610,0x026ffe20,0x0bab0708,0x13d40ff9,0x1a7d1755,0x1f9b1d3f,0x236721a2,
0x25df24dc,0x267e2670,0x25382612,0x226e23f4,0x1edf20ba,0x1a841cc5,0x15d81834,0x11831395,
0x0e200fb7,0x0b470cb3,0x089109df,0x06c3077d,0x068f067b,0x077006e8,0x083807eb,0x08210850,
0x06b7079e,0x0413057e,0x00cf028a,0xfc4cfec3,0xf6bef99a,0xf0c2f3ca,0xeaaeedb7,0xe50de7c6,
0xe029e288,0xdbffddfc,0xd8f8da51,0xd744d7ef,0xd744d702,0xd972d811,0xdd94db52,0xe284e008,
0xe6e9e4d9,0xea4fe8b6,0xeccaeba4,0xeed7edd8,0xf0b2efc7,0xf251f190,0xf37bf2fd,0xf394f3b3,
0xf355f35d,0xf433f39b,0xf5e4f501,0xf7c4f6cb,0xfa33f8e8,0xfd54fba9,0x0094ff05,0x0376020a,
0x065604e5,0x097e07d8,0x0d130b41,0x10ad0ede,0x14b4129e,0x18d216cb,0x1cec1ad3,0x21901f24,
0x2733243a,0x2db42a68,0x33bb30d6,0x38b53661,0x3bf63a9e,0x3c623c89,0x39e13b86,0x34583773,
0x2c6e30a2,0x22e827cd,0x19551e03,0x10e414fd,0x09a20d13,0x03b40689,0xff3f0138,0xfc4afdae,
0xf927facf,0xf54ff74b,0xf146f34d,0xed20ef41,0xe7f5eabb,0xe19ee4db,0xdb57de5c,0xd5ebd888,
0xd1e7d3a5,0xcfcbd0a0,0xcf7bcf74,0xd038cfbe,0xd241d10c,0xd57ed3cc,0xd8ccd72d,0xdbfada5e,
0xdf63dda6,0xe354e147,0xe809e599,0xed4bea9a,0xf35df030,0xfa7af6d0,0x0274fe51,0x0b5706df,
0x13a10f9e,0x1af71763,0x20fd1e3e,0x24ba231e,0x264925cd,0x25b1263b,0x23ca24d7,0x210e2284,
0x1da21f69,0x197f1ba3,0x15011741,0x111c12e2,0x0e900fb5,0x0c440d75,0x09c20aff,0x082e08c3,
0x07e507f0,0x082f0802,0x0875085b,0x0841086f,0x06fb07ca,0x04b505ee,0x01900349,0xfce1ff6c,
0xf6fdfa0c,0xf0acf3e1,0xea41ed6f,0xe45ce736,0xdf49e1bf,0xdafddd06,0xd7dbd94b,0xd5e4d6b1,
0xd5edd59c,0xd861d6dd,0xdca2da57,0xe1b8df25,0xe64ee424,0xe9c6e82d,0xec49eb1d,0xee61ed5c,
0xf05def62,0xf226f14a,0xf358f2d8,0xf37bf38a,0xf37bf363,0xf489f3e2,0xf65af565,0xf863f756,
0xfb0af997,0xfe8bfcb6,0x02180066,0x052a03aa,0x0802069b,0x0b16097b,0x0e8f0cd2,0x11dd1037,
0x158d13a7,0x196b1779,0x1da31b73,0x22b22006,0x28a7259a,0x2f072bd5,0x350f3221,0x3a1037c0,
0x3cf43be0,0x3c933d2e,0x38ec3b26,0x32793601,0x2a152e7d,0x20b2256f,0x17931c08,0x0f34134e,
0x07ef0b60,0x022004e1,0xfddeffc3,0xfac5fc40,0xf79df93f,0xf3fff5d7,0xf035f21b,0xec0bee3e,
0xe69be985,0xdfcde34f,0xd945dc67,0xd40bd672,0xd0dfd229,0xcff5d028,0xd0b7d036,0xd1f5d146,
0xd3fbd2db,0xd6acd543,0xd9a8d827,0xdd39db55,0xe142df36,0xe5a2e367,0xea54e7ef,0xef2eecc6,
0xf49df1bc,0xfb34f7d1,0x0293fec3,0x0aef06ac,0x13580f31,0x1b331767,0x21231e7f,0x246c2313,
0x25ae255a,0x24ba2565,0x22b323ce,0x1fed2167,0x1ca31e5d,0x18b01abb,0x14601686,0x111d128b,
0x0f090ffa,0x0d1e0e1d,0x0b230c10,0x0a0f0a77,0x099109c8,0x09540968,0x0939094c,0x08bc0915,
0x073e0818,0x0529064c,0x020303c6,0xfd53ffdf,0xf748fa69,0xf071f3f0,0xe992ecf5,0xe34ee64e,
0xddf4e08d,0xd97fdb90,0xd62bd7b0,0xd432d4fd,0xd440d3ec,0xd690d524,0xdaa9d86f,0xdfb6dd23,
0xe481e234,0xe853e688,0xeb3fe9e3,0xeda9ec81,0xefe1eecb,0xf1e4f0ec,0xf337f2b3,0xf3a3f37a,
0xf423f3d3,0xf569f4a5,0xf754f65a,0xf9a2f863,0xfd00fb29,0x0125ff0d,0x04e9031b,0x081c0692,
0x0abd097d,0x0d6f0c04,0x10610eec,0x135c11d5,0x169c14f6,0x1a19184e,0x1e6a1c1e,0x23c520fb,
0x298f26aa,0x2f502c6b,0x3502323b,0x3958376c,0x3b423aa7,0x3a363b26,0x35df386a,0x2f0232b2,
0x267c2ae9,0x1d9121f4,0x1548195b,0x0d691144,0x06cd09ea,0x016603f6,0xfd72ff3b,0xfa80fbe8,
0xf7c8f928,0xf477f63d,0xf054f27c,0xeb50edf2,0xe551e873,0xde4ce1db,0xd7dadaed,0xd310d52d,
0xd089d18a,0xd04ad016,0xd16bd0d8,0xd2b0d203,0xd4a8d390,0xd73bd5df,0xdab0d8cd,0xdf53dce6,
0xe456e1d3,0xe923e6cd,0xed6eeb60,0xf13cef53,0xf5b2f351,0xfb39f856,0x01c1fe57,0x09730576,
0x12060db2,0x1a251636,0x203b1d8e,0x237b2228,0x2440242f,0x22de23c0,0x20bb21d9,0x1e141f78,
0x1b091c99,0x1794195f,0x140115bd,0x118d129b,0x100410b8,0x0e6c0f4a,0x0cb30d82,0x0b900c14,
0x0ac10b20,0x0a170a67,0x099a09d1,0x08c00948,0x074e080e,0x05650675,0x0257040b,0xfdb20039,
0xf7a9fad1,0xf0bef440,0xe9d1ed3e,0xe36be684,0xddd9e084,0xd974db7d,0xd634d7af,0xd467d51b,
0xd476d426,0xd691d549,0xda57d846,0xdf27dcab,0xe3d8e19a,0xe77ee5d1,0xea61e8fc,0xece0eba8,
0xef45ee15,0xf177f06e,0xf2c8f243,0xf358f315,0xf423f3b1,0xf56bf4b4,0xf718f633,0xf996f830,
0xfd64fb56,0x01a1ff8a,0x05770398,0x08c80736,0x0b6d0a2d,0x0e060cb1,0x10ef0f6b,0x1436128f,
0x177f15dc,0x1b361939,0x204c1d91,0x26772355,0x2c622982,0x320b2f2a,0x37d13503,0x3b713a05,
0x3bb73bff,0x38903a96,0x325135c1,0x2a7a2e84,0x21d12632,0x198f1d8b,0x11ce15b1,0x0a7f0dfb,
0x04cc0778,0x00720274,0xfd2efeb6,0xfa68fbc1,0xf7f6f92a,0xf4e1f693,0xf07ff2dc,0xea83edb0,
0xe36de70f,0xdbf8dfab,0xd596d88f,0xd1b8d342,0xd06ed0cc,0xd156d0a8,0xd2f3d231,0xd43bd398,
0xd5d5d4f8,0xd85dd6f2,0xdc74da33,0xe1b2df00,0xe6e6e459,0xeb7de94c,0xef65ed7d,0xf327f142,
0xf74df529,0xfc49f9a5,0x0279ff36,0x0a530628,0x13670ed6,0x1b8417ba,0x20b51e84,0x22de2219,
0x22ea2326,0x212d2235,0x1ea51ff2,0x1b8d1d31,0x183f19de,0x154116b4,0x12c813e8,0x111f11e3,
0x0fe21078,0x0eba0f4f,0x0d950e21,0x0c9a0d16,0x0b7e0c15,0x0a5c0ae6,0x099309f1,0x08aa092d,
0x0783081b,0x05ca06be,0x0320049d,0xff17014e,0xf942fc67,0xf25ff5de,0xeb48eed6,0xe478e7cf,
0xde63e147,0xd97fdbcd,0xd5efd788,0xd3d7d4af,0xd35bd361,0xd4f3d3e1,0xd89ad68d,0xdd84dafd,
0xe234dff2,0xe60fe43c,0xe942e7b5,0xec21eac0,0xeed9ed7d,0xf189f037,0xf349f293,0xf436f3c4,
0xf534f4b2,0xf663f5ba,0xf823f734,0xfacdf94e,0xfec8fca6,0x03180101,0x06b104fa,0x09ab0840,
0x0c260af0,0x0e8b0d53,0x110f0fc7,0x13de1270,0x16d11552,0x1a73187e,0x1f951cd4,0x259a228f,
0x2b702899,0x31112e30,0x37053417,0x3b1c3974,0x3bab3bda,0x38a33a9c,0x324d35c4,0x2a952e87,
0x224d2679,0x1a611e39,0x12de16a4,0x0ba20f21,0x05e40893,0x0165037e,0xfe03ff92,0xfb23fc8e,
0xf88bf9d8,0xf54ff70f,0xf090f329,0xea07ed7e,0xe256e645,0xda62de53,0xd3dcd6d5,0xd01cd18f,
0xcf70cf79,0xd0ffd000,0xd30ad216,0xd483d3d4,0xd631d53f,0xd8ddd765,0xdd23dac7,0xe281dfce,
0xe75ce509,0xeba0e98a,0xef87eda8,0xf2aff12b,0xf5e1f436,0xf9e5f7b7,0xff70fc75,0x074702fb,
0x11290c21,0x1a2b15f5,0x20191d92,0x228821b7,0x229722cc,0x20dd21e5,0x1e6a1faf,0x1b6b1cff,
0x189b19ec,0x1639175c,0x144d1531,0x13011399,0x11f61279,0x1110117f,0x103d10a6,0x0f3e0fcb,
0x0dd50e94,0x0c310d02,0x0adb0b7a,0x09940a38,0x082e08ef,0x063d074a,0x037d04fd,0xff9001b4,
0xf9b5fcdd,0xf2a7f64c,0xeb02eeda,0xe3c7e743,0xdd9ee08d,0xd88cdaf4,0xd4a9d671,0xd20dd32e,
0xd10ad14c,0xd245d15c,0xd5e4d3cf,0xdad8d854,0xdfa6dd50,0xe3e5e1da,0xe7bae5d0,0xeb38e98a,
0xee71ecd6,0xf17cf00a,0xf36af29c,0xf4a9f406,0xf5ebf551,0xf748f690,0xf901f815,0xfbd4fa39,
0x0013fdcd,0x04780261,0x0819065b,0x0b2109b4,0x0dc30c75,0x103d0f0b,0x12941165,0x153f13d9,
0x182516ab,0x1bd119cc,0x20c41e2d,0x26772392,0x2bf22948,0x31522e8b,0x37023444,0x3a343912,
0x39ba3a65,0x360f3844,0x2ff33335,0x28e72c7b,0x2153252e,0x19b51d76,0x125f1608,0x0b8f0ecd,
0x063a08b8,0x021c0405,0xfec0005d,0xfbcefd3b,0xf90ffa7b,0xf56bf766,0xf02bf306,0xe908ecd3,
0xe0d5e4fd,0xd8e3dcb9,0xd2c5d583,0xcfafd0c9,0xcf7dcf49,0xd13bd033,0xd2fad237,0xd467d3a5,
0xd677d555,0xd98ed7d8,0xde1ddba7,0xe31ee0ae,0xe76fe559,0xeb95e97a,0xef70edaa,0xf231f0db,
0xf53af3a6,0xf938f704,0xff2cfbeb,0x07b1031c,0x11ab0cac,0x19fd1632,0x1f011ced,0x21142057,
0x2143215e,0x1fdc20b7,0x1d9d1ed0,0x1af31c4d,0x189619b3,0x16e217a9,0x15a11632,0x14d41533,
0x13d51457,0x12d91351,0x11e41262,0x10861146,0x0ecd0fb6,0x0cd10dd5,0x0aea0bda,0x093c0a0f,
0x074a0851,0x0525063d,0x02b203f4,0xff3f0139,0xf9b5fcb9,0xf29cf64a,0xeb04eecf,0xe3e7e75d,
0xddb0e0ad,0xd861dae6,0xd45fd639,0xd17cd2ca,0xd03bd091,0xd167d07d,0xd4f6d2f3,0xd99dd740,
0xde5ddc00,0xe2dfe0b0,0xe6eee4ef,0xeaade8d9,0xee22ec65,0xf155efd2,0xf37bf28d,0xf521f449,
0xf6caf5f9,0xf8aef7af,0xfacff9b3,0xfdd2fc2d,0x01faffc5,0x06420431,0x09de0828,0x0cb30b5b,
0x0f210df6,0x112c1034,0x13231219,0x15d81468,0x18c4174c,0x1c341a5a,0x20851e42,0x25ae2309,
0x2acb284c,0x2fe12d45,0x355432ac,0x38a1376d,0x385a38e3,0x35073710,0x2f323259,0x28702bd7,
0x211524e4,0x195c1d2b,0x122615b5,0x0b8f0eb1,0x067d08d4,0x02a90476,0xff640102,0xfc45fdcc,
0xf91cfabe,0xf536f74c,0xeffbf2d4,0xe8deeca0,0xe0ade4d3,0xd8eddc9f,0xd318d5b7,0xd04cd146,
0xd03ed000,0xd1f2d0f5,0xd3e2d2fa,0xd596d4b0,0xd7bbd69c,0xda7fd8fe,0xde55dc4c,0xe286e076,
0xe65ce47c,0xea54e851,0xedd7ec36,0xf09fef3f,0xf3d4f222,0xf7eaf5b7,0xfe1dfab1,0x06ef0231,
0x10f60c01,0x19261570,0x1dfc1bfb,0x201d1f54,0x2075207a,0x1f782020,0x1d881e8d,0x1b2e1c63,
0x18f419fd,0x177c1828,0x167816e6,0x15cc161c,0x151f1581,0x146314b9,0x13a41412,0x122a12fd,
0x101f1133,0x0dd90efb,0x0ba90cb6,0x09e30ac0,0x07f208f0,0x05c306e4,0x037c04a7,0xffd601f2,
0xfa09fd2c,0xf2d8f688,0xeb51ef10,0xe471e7c9,0xde2fe13c,0xd890db48,0xd40bd61b,0xd0ccd245,
0xcf57cfc7,0xd04ccf82,0xd367d1a2,0xd7a8d572,0xdc61d9fd,0xe10ddec2,0xe569e341,0xe996e783,
0xed9ceb9c,0xf136ef89,0xf383f286,0xf567f474,0xf749f656,0xf962f84d,0xfb99fa72,0xfe9afcf6,
0x02c50088,0x073c0510,0x0b14093d,0x0e320cbb,0x10990f7d,0x12851194,0x14a3137e,0x177e1603,
0x1a7918fa,0x1dfe1c23,0x223e2004,0x272824a9,0x2c3929a8,0x31862ed7,0x3685342f,0x38d73829,
0x37733888,0x334c35ac,0x2d10305b,0x260f29a1,0x1e3c2247,0x162f1a1c,0x0f001282,0x08ee0bc3,
0x04970692,0x017802eb,0xfec7001f,0xfc16fd6b,0xf901faa2,0xf4cdf712,0xef14f232,0xe79eeb83,
0xdf6be383,0xd827db91,0xd303d543,0xd10cd19e,0xd1a6d11d,0xd3c1d29f,0xd5cbd4d1,0xd7bdd6b7,
0xda03d8d7,0xdc65db2a,0xdf58ddc5,0xe2a2e100,0xe5fde453,0xe94ae7a5,0xec50eadd,0xef34edb2,
0xf2d9f0ea,0xf7b5f511,0xfef8fb01,0x085d037d,0x11c20d3e,0x18d615b1,0x1ca51b16,0x1e661db9,
0x1ea81eac,0x1deb1e6b,0x1c7e1d40,0x1aad1ba3,0x18f419bb,0x17ea185d,0x1762179c,0x17021732,
0x163d16b1,0x153215b8,0x13f614a6,0x1232131b,0x1032113c,0x0df80f13,0x0bf90cea,0x0a200b0c,
0x0838092f,0x063c0734,0x04080546,0xfffb0246,0xf9d7fd26,0xf2caf65f,0xebb4ef2d,0xe518e85a,
0xded8e1ec,0xd902dbd8,0xd42ed671,0xd0bdd245,0xcf28cfaf,0xcfcfcf35,0xd26dd0e5,0xd671d44b,
0xdb1fd8ba,0xe002dd96,0xe48fe255,0xe8e5e6b7,0xed3deb14,0xf101ef45,0xf38af266,0xf5b8f49e,
0xf808f6de,0xfa7bf93a,0xfd06fbc0,0xfffafe64,0x03f801da,0x083b0622,0x0bf90a32,0x0ef30d91,
0x1142102b,0x13221238,0x15811436,0x187716f8,0x1b8019f4,0x1ef91d26,0x232920fc,0x27fc257f,
0x2d252a95,0x320f2fa0,0x3650345d,0x37bb3784,0x35bb370d,0x318233e0,0x2b6e2e9b,0x24ab2824,
0x1cf620eb,0x151e18f6,0x0e261187,0x08650b11,0x046c0635,0x019302f0,0xfee0003e,0xfbe0fd74,
0xf808fa15,0xf31ff5b9,0xecccf026,0xe549e925,0xddcfe171,0xd771da6f,0xd345d508,0xd1f4d23c,
0xd2fed242,0xd543d40d,0xd778d669,0xd981d87d,0xdb6eda84,0xdd29dc43,0xdf9ade3e,0xe299e11a,
0xe542e3f7,0xe7e6e68a,0xeabde94d,0xee07ec3f,0xf2acf033,0xf8b8f578,0x00a4fc7f,0x09b2051b,
0x12340e25,0x1848159d,0x1b8d1a33,0x1cf41c76,0x1d5d1d3a,0x1d071d49,0x1c2d1caa,0x1ace1b87,
0x19901a1f,0x18d11929,0x1854188c,0x17d11822,0x16881740,0x14f415bb,0x1374143a,0x11cf12a4,
0x0fed10eb,0x0dce0ee0,0x0bd70cca,0x0a030ae6,0x08600935,0x06950784,0x0407057f,0xffbd0214,
0xf9d5fcf3,0xf35bf6a2,0xecccf00a,0xe66be99b,0xe02de347,0xda40dd1d,0xd562d7ad,0xd1c7d367,
0xcfdbd093,0xcff7cfa5,0xd21cd0ce,0xd5c3d3cf,0xda24d7dc,0xdedfdc83,0xe380e12e,0xe835e5db,
0xecf7ea94,0xf13eef45,0xf436f2d9,0xf6cef57f,0xf96ef81e,0xfc22fac3,0xfe9cfd69,0x0139ffdb,
0x04bd02dd,0x087406a9,0x0ba90a1a,0x0e670d15,0x10c10fa2,0x12cc11c7,0x156313fa,0x188c16f6,
0x1b8a1a0f,0x1eb41d0f,0x2269207b,0x26d92483,0x2bb42944,0x30642e11,0x349b32a5,0x364e35e7,
0x352c35fb,0x31ed33d7,0x2c882f75,0x25d22951,0x1df32200,0x160e19e7,0x0eff126d,0x09320bdf,
0x05310704,0x024303a1,0xff9400f7,0xfc34fe01,0xf7b3fa17,0xf233f511,0xebc8ef1a,0xe4b5e844,
0xdddfe138,0xd835dace,0xd471d609,0xd348d38a,0xd42fd38a,0xd649d527,0xd83fd758,0xd9d0d90f,
0xdb12da7c,0xdc45dba1,0xde83dd3d,0xe11cdfd5,0xe37de258,0xe5c2e496,0xe82ee6f3,0xeba1e9af,
0xf0cfee02,0xf7a6f404,0x002afbc2,0x093904ae,0x11bb0da9,0x17e51528,0x1b5d19f2,0x1d171c58,
0x1ddb1d93,0x1df81e04,0x1d791dca,0x1c631d00,0x1b201bb7,0x1a311a9c,0x198e19dd,0x18c7193e,
0x1721180c,0x153d1627,0x139d146b,0x120712cf,0x103b1133,0x0e110f27,0x0c0a0d02,0x0a6f0b2c,
0x090109c0,0x0726082c,0x03f305c4,0xff5401d0,0xf999fc86,0xf38ff696,0xed95f091,0xe771ea8d,
0xe12de44e,0xdb39de1a,0xd63ed89a,0xd264d426,0xd026d109,0xcfffcfce,0xd1efd0b6,0xd555d388,
0xd968d74a,0xdde1dba4,0xe277e028,0xe72ae4ce,0xec0de995,0xf094ee74,0xf3baf24f,0xf665f50e,
0xf93ff7c8,0xfc4ffacc,0xfef9fdb2,0x01b90049,0x05430361,0x08cd0720,0x0bd80a5a,0x0eaf0d4b,
0x1151100c,0x138e1275,0x163214cb,0x193417ac,0x1bf71aa2,0x1ecc1d4d,0x221b2064,0x2646240f,
0x2af528a6,0x2f552d29,0x337d3186,0x356234dc,0x349d353d,0x31e23386,0x2cf92fad,0x26a829f7,
0x1f0822fc,0x174e1b11,0x107c13ca,0x0ae20d76,0x06e908ba,0x03c50549,0x007e023a,0xfc08fe73,
0xf654f948,0xf005f336,0xe957ecc2,0xe272e5de,0xdc08df19,0xd754d969,0xd49cd5b3,0xd424d41d,
0xd550d499,0xd751d642,0xd8eed848,0xd9bbd961,0xda3bd9fb,0xdb18da90,0xdce0dbe5,0xdf22ddfe,
0xe16ee045,0xe3c4e29d,0xe634e4ed,0xe9dbe7c5,0xefa6ec87,0xf72ef330,0x0035fb99,0x097604d9,
0x12080dee,0x181a1578,0x1b9d1a18,0x1db61ccd,0x1ef41e6a,0x1f6d1f47,0x1f5c1f77,0x1ea51f1a,
0x1d881e0e,0x1cab1d16,0x1bd91c44,0x1a751b48,0x17fe1957,0x156e16a4,0x136b1461,0x11981281,
0x0f7a109c,0x0d120e4a,0x0ac00bdc,0x094909e7,0x082208bd,0x064f0760,0x02f604d4,0xfe4b00c3,
0xf8dcfba6,0xf33bf607,0xed9af071,0xe7a9eaac,0xe17ce494,0xdb7fde6e,0xd63dd8c4,0xd207d3fc,
0xcf6ad078,0xcf02ceeb,0xd0f7cfbb,0xd451d288,0xd88bd64f,0xdd6fdafa,0xe24adfdf,0xe72ce4be,
0xec1de9a0,0xf0d2ee8d,0xf447f2ba,0xf6ecf597,0xf9f2f863,0xfd3dfb91,0x005efeda,0x039b01ed,
0x073c0562,0x0a960904,0x0d310bf1,0x0fa20e66,0x11ee10d4,0x141312f8,0x168f1543,0x19951808,
0x1c651b0b,0x1f061db3,0x21fc2069,0x25fb23dc,0x2a3f2831,0x2dce2c0f,0x31ab2fb7,0x3408333d,
0x339f3417,0x314532b3,0x2c9e2f38,0x268729b3,0x1f482308,0x17c61b71,0x1148146f,0x0b8e0e45,
0x074d0941,0x03e10590,0x002a0224,0xfadefdbe,0xf44ff7ad,0xeda5f0ef,0xe743ea72,0xe0ebe416,
0xdb58ddeb,0xd7ccd94a,0xd626d6c9,0xd61ad5ea,0xd741d69b,0xd8d1d801,0xd9c9d96f,0xd9edd9ea,
0xda3bd9fe,0xdad4da7f,0xdc01db50,0xde0cdcf3,0xe045df2e,0xe26ae158,0xe4f0e38e,0xe904e6b7,
0xef3cebdf,0xf72ef2fe,0x005efbb8,0x096a04eb,0x119c0db6,0x178f14e5,0x1b4e19a7,0x1dd21cbc,
0x1f251e8d,0x1fdc1f99,0x1ff81ffb,0x1f541fc4,0x1e3d1ec3,0x1d511dc2,0x1c551cdf,0x1aba1ba7,
0x18171983,0x155f16a2,0x135a144f,0x116c1268,0x0f461062,0x0d0c0e2d,0x0b270bf9,0x0a3e0aa3,
0x093709ce,0x07030854,0x03500554,0xfe5900f6,0xf8cbfb99,0xf337f5f7,0xeddaf087,0xe862eb2b,
0xe280e57a,0xdc92df81,0xd721d9bf,0xd2acd4c3,0xcfc0d0f3,0xcf04cf18,0xd08dcf87,0xd398d1f1,
0xd7bfd587,0xdc98da2a,0xe174df04,0xe671e3e9,0xebc3e915,0xf0c3ee60,0xf471f2c9,0xf763f5e7,
0xfa93f8f5,0xfddbfc3a,0x00deff61,0x0417026d,0x07be05db,0x0b300992,0x0dae0c86,0x0fe80eca,
0x120b1102,0x1418130a,0x16911541,0x198b1805,0x1c431afd,0x1e8e1d68,0x21611fd3,0x256c2349,
0x29652788,0x2cb32b0d,0x30b12e9b,0x33ba3286,0x343b3441,0x32a833bf,0x2e3c30cb,0x28022b46,
0x2098246c,0x19131cb9,0x129b15c1,0x0caf0f8b,0x08110a2f,0x04340621,0xffee0238,0xf9edfd27,
0xf2b8f65b,0xebd4ef2e,0xe5a3e8ad,0xdfbfe2a4,0xdadedd14,0xd82fd945,0xd70ad77a,0xd723d6ed,
0xd813d798,0xd922d899,0xd9a0d983,0xd993d99c,0xd967d97e,0xd937d94b,0xd9e3d955,0xdbf7dad2,
0xde74dd3a,0xe0cfdf9d,0xe3c8e22f,0xe81de5ba,0xee75eb0b,0xf67cf240,0xffccfb15,0x0918047b,
0x11af0d8b,0x18851562,0x1d2a1b13,0x1fe91ecd,0x2127209c,0x21d02198,0x21a821d3,0x20dc2158,
0x1fa92047,0x1e661f06,0x1d021dbc,0x1b331c2f,0x188419f6,0x15eb1722,0x13fe14e7,0x11d512ff,
0x0f361089,0x0c950de0,0x0aa50b77,0x09a60a11,0x08ba0944,0x069007d3,0x02e704f0,0xfe0c0096,
0xf882fb56,0xf30cf5b6,0xee08f07f,0xe8e0eb89,0xe343e61d,0xdd4ee04d,0xd7eeda7e,0xd394d59e,
0xd0aad1eb,0xcfa3cfe2,0xd0bdcfef,0xd3a5d205,0xd7c2d593,0xdc6bda13,0xe0ffdeb5,0xe5cae35b,
0xeaf5e85a,0xefcaed76,0xf380f1d5,0xf68cf4fe,0xf9ecf832,0xfd57fba1,0x00abff08,0x0427025d,
0x0820060f,0x0bdf0a22,0x0e6a0d41,0x10740f75,0x126c1177,0x144a1358,0x16b61564,0x19bc1837,
0x1c541b22,0x1e7e1d65,0x217e1fd3,0x2574236e,0x2907275d,0x2c1c2a89,0x304b2e11,0x33b4324e,
0x34b73472,0x339d3484,0x2f8a31eb,0x29a12cb6,0x22942643,0x1b3c1ed1,0x149e17e1,0x0e55115e,
0x09430ba5,0x04ac06ff,0xff240218,0xf821fbcf,0xf08df448,0xe98aecf6,0xe35ce65b,0xddafe072,
0xd97cdb52,0xd78ad843,0xd713d72b,0xd78fd740,0xd844d7ea,0xd8eed8a1,0xd916d918,0xd8abd8ea,
0xd83ad86d,0xd7e5d808,0xd8aed811,0xdb0fd9bd,0xdd8bdc5d,0xdfffdebb,0xe312e167,0xe75ae502,
0xed86ea32,0xf555f143,0xfe60f9be,0x07e20320,0x11110c99,0x18811507,0x1db41b64,0x20d91f84,
0x22d121e1,0x23ea2389,0x2400240c,0x233323b9,0x21d12286,0x20562118,0x1e8e1f82,0x1c551d86,
0x197d1af2,0x17001826,0x15041607,0x125213c7,0x0ef610b3,0x0b9d0d38,0x09560a4a,0x083f08ac,
0x078b07f7,0x05af06cc,0x0250042f,0xfd960015,0xf835faf0,0xf2f4f582,0xee45f091,0xe978ebeb,
0xe411e6df,0xde13e115,0xd8a6db3f,0xd436d64e,0xd0f6d267,0xcf9acfff,0xd08dcfce,0xd36bd1cc,
0xd778d553,0xdc07d9bf,0xe082de41,0xe536e2ce,0xea5be7bf,0xef60ecf2,0xf342f17b,0xf689f4e0,
0xfa2ff850,0xfdeffc0d,0x0182ffc7,0x05350348,0x09770749,0x0d590b95,0x0fd50eb9,0x119410c7,
0x130f1256,0x145913b6,0x16201520,0x1867173b,0x1a711985,0x1c301b49,0x1ec91d56,0x22412075,
0x25c6240b,0x291a2769,0x2d992b27,0x324b301f,0x352533f7,0x35b235c9,0x330734c7,0x2d9d308d,
0x268f2a47,0x1ed122a2,0x17c81b3a,0x1113145e,0x0b030dfe,0x04e70806,0xfe6901b8,0xf6f2fac6,
0xef50f313,0xe86bebc3,0xe26ae54b,0xdd31dfb9,0xd942daf8,0xd75ad813,0xd6bed6f4,0xd695d69a,
0xd6e7d6ba,0xd786d720,0xd81dd7ef,0xd7ded80d,0xd769d7ac,0xd6d6d71d,0xd75fd6d5,0xd9e0d86f,
0xdce8db6a,0xdfb2de46,0xe2f4e145,0xe6eee4ca,0xec99e980,0xf3f7f023,0xfc92f825,0x05bb011e,
0x0f1b0a6d,0x17a4138b,0x1e391b44,0x225d2085,0x24f923d7,0x267425df,0x269726aa,0x25ae2643,
0x23ef24dd,0x21ee22fb,0x1f7620bf,0x1cc81e20,0x19f31b63,0x178218a1,0x1583168a,0x12eb1450,
0x0f7a1158,0x0b6c0d65,0x087809c3,0x07080796,0x062806a5,0x0450056d,0x00e702cb,0xfc4afeb1,
0xf756f9cf,0xf2abf4ef,0xee72f08b,0xe9d7ec38,0xe496e753,0xdebae1ae,0xd94adbe3,0xd4dfd6f7,
0xd183d309,0xcff0d078,0xd0add000,0xd39ed1f0,0xd7bbd591,0xdc5ada0b,0xe0dedea2,0xe58ae32e,
0xea7ae7f8,0xef32ece9,0xf2e9f135,0xf604f474,0xf97cf7b2,0xfd4cfb5c,0x010eff3a,0x04fd02ed,
0x0997073d,0x0dde0be5,0x108c0f63,0x12371171,0x139012f2,0x14a71419,0x1648156a,0x182e1736,
0x19e0191b,0x1b5d1a87,0x1dea1c8a,0x20f71f68,0x242f2292,0x274125b8,0x2b682913,0x30d02e1e,
0x34cc3314,0x367735f3,0x34f43628,0x304032e6,0x29de2d3f,0x2273262e,0x1b701ee7,0x144d17e9,
0x0d1410b9,0x0581094d,0xfe0301c8,0xf625fa20,0xee4ff230,0xe764eaaf,0xe1cce46c,0xdd56df74,
0xd9f6db79,0xd7f0d8ca,0xd6b9d754,0xd5bdd622,0xd573d586,0xd5e6d593,0xd680d649,0xd661d68a,
0xd5e5d62a,0xd535d586,0xd5c4d53b,0xd857d6d8,0xdbafd9fe,0xdedadd4c,0xe231e079,0xe617e405,
0xeb97e899,0xf273eee9,0xfa55f640,0x02f4fe90,0x0c9507a2,0x167211a1,0x1e4f1abd,0x239e2140,
0x26e62578,0x28c72803,0x290f291b,0x282c28bd,0x26582759,0x24372552,0x217422eb,0x1e6f1ff4,
0x1b8a1cf1,0x192d1a41,0x17601847,0x14f71650,0x10eb132e,0x0c060e72,0x081209df,0x05e506c8,
0x04680521,0x02600394,0xff0400d4,0xfab6fcea,0xf632f875,0xf1edf401,0xedd5efea,0xe966ebac,
0xe453e6ee,0xdf00e1aa,0xd9eddc5f,0xd5b5d7b1,0xd29dd400,0xd114d19b,0xd1c8d11c,0xd4c7d314,
0xd8bed6af,0xdd26daf1,0xe14ddf40,0xe57ee35c,0xe9fbe7b9,0xee46ec30,0xf1a9f01f,0xf482f30b,
0xf80ef631,0xfc48fa15,0x0086fe79,0x04e7029b,0x09ea0759,0x0eba0c77,0x11be1074,0x138e12bd,
0x14c5143a,0x15a81534,0x16c11629,0x1845177b,0x197a18f8,0x1aab19f6,0x1d0e1bbd,0x20141e82,
0x234621b1,0x266324cf,0x2a972842,0x30352d54,0x34c032bd,0x372d3648,0x36693737,0x323c34b3,
0x2bf62f47,0x24ad2859,0x1d822118,0x15de19c7,0x0dce11e9,0x051e0977,0xfcce00ec,0xf47cf8a7,
0xecb4f077,0xe614e93c,0xe0e5e34c,0xdcebdec6,0xd9ebdb4d,0xd7b9d8c2,0xd604d6dc,0xd487d525,
0xd42ed440,0xd4a1d44e,0xd54ad505,0xd599d57b,0xd565d590,0xd4dcd51c,0xd595d4f8,0xd812d6a8,
0xdb7bd9bd,0xdef7dd42,0xe238e098,0xe5f9e3f5,0xeb2de861,0xf16dee34,0xf8bef4ed,0x00d5fcbc,
0x0a220544,0x14780f4f,0x1d69193d,0x23f620f2,0x283f266d,0x2a8a2999,0x2b292b09,0x2a7a2afa,
0x28b029b4,0x2642278d,0x22ff24b3,0x1f732137,0x1c2d1db6,0x19bc1adb,0x17ee18cb,0x158716e7,
0x117d13b8,0x0c830efe,0x08370a3a,0x057606aa,0x0397047e,0x0108027f,0xfd85ff58,0xf9a4fb94,
0xf5d0f7ba,0xf213f3f1,0xee26f021,0xe9deec16,0xe4f2e77c,0xdfc2e25c,0xdabedd32,0xd678d87c,
0xd343d4b4,0xd18ad22b,0xd21ad185,0xd4b6d337,0xd850d66d,0xdc7dda65,0xe074de7d,0xe471e26e,
0xe8cae690,0xed23eafa,0xf0e6ef29,0xf40af276,0xf7cef5d0,0xfc5cfa00,0x00f9feb8,0x059c0338,
0x0abb0822,0x0fcc0d5f,0x132f11be,0x150d1444,0x15fa159a,0x16641638,0x16ce168f,0x178f1723,
0x183717f0,0x18e21879,0x1a961997,0x1d561bdd,0x20991ef1,0x243f2259,0x28b92653,0x2e5e2b70,
0x33f73148,0x3808364a,0x390738fd,0x365c3834,0x307d33ac,0x29402cf7,0x21a42584,0x192a1d83,
0x102c14c1,0x062a0b45,0xfc9b0137,0xf404f83e,0xec28eff3,0xe56ee8a5,0xe01ee29a,0xdc0adde9,
0xd902da75,0xd678d7a7,0xd48dd575,0xd2dad3a4,0xd200d255,0xd21ad1e3,0xd2f7d27f,0xd3e8d372,
0xd49ed450,0xd4c7d4c7,0xd54dd4d8,0xd763d62e,0xdaaed8e9,0xde54dc8e,0xe170dfed,0xe4d6e306,
0xe9aae708,0xefcdec9d,0xf6faf348,0xfe83fab9,0x070c028d,0x115d0c0b,0x1bb216ae,0x243b2045,
0x29fc277b,0x2cf62bc7,0x2e172db6,0x2dba2e1a,0x2c182d09,0x294d2ad7,0x25a6278f,0x21be23b1,
0x1e1a1fce,0x1b5b1ca5,0x18ff1a25,0x166517c9,0x128614a9,0x0d951022,0x08800afa,0x047c064f,
0x01b202fe,0xfee3005e,0xfb9bfd4a,0xf832f9e1,0xf4f0f692,0xf19cf353,0xedf7efc9,0xea05ec13,
0xe573e7c8,0xe097e307,0xdbf4de39,0xd7b7d9c3,0xd480d5f5,0xd2d4d36f,0xd354d2cc,0xd58ad446,
0xd8d3d710,0xdc9ddab8,0xe04fde75,0xe40fe230,0xe825e60c,0xec30ea3b,0xef55ede3,0xf237f0b0,
0xf619f408,0xfaf4f871,0xffc0fd65,0x04cd022d,0x0a870799,0x10180d73,0x13fb1246,0x16531559,
0x175316f5,0x17b8178a,0x184217f4,0x190c18a7,0x19701951,0x199e1976,0x1ad51a13,0x1cdc1bc9,
0x1f331e00,0x2230208b,0x26912439,0x2bcf291e,0x31ad2eae,0x36db3487,0x39113865,0x37dc38f3,
0x32ca35bb,0x2c0a2f7f,0x24352854,0x1ae71fa6,0x10f1160e,0x06030b7b,0xfbce00c5,0xf2dbf72d,
0xeb07eec6,0xe486e7a1,0xdfa8e1de,0xdc5eddd7,0xd9efdb1a,0xd7e2d8de,0xd5d4d6e7,0xd37ad4ad,
0xd195d25f,0xd16dd145,0xd24fd1d6,0xd393d2de,0xd4ecd453,0xd563d546,0xd5c3d573,0xd755d669,
0xda2ad89b,0xdd80dbdc,0xe095df0e,0xe405e227,0xe8bce648,0xee0deb51,0xf426f10b,0xfabdf74b,
0x02f5fe9c,0x0d3007d4,0x188812dc,0x22cd1def,0x2a3426e7,0x2e512cae,0x2fff2f5c,0x2ff23031,
0x2e5f2f4f,0x2b6f2d13,0x2799298d,0x23af259e,0x1ffe21cc,0x1d1c1e6e,0x1abd1bea,0x1852198e,
0x14d816cf,0x0fea1284,0x0a580d1e,0x054407ba,0x01350314,0xfdd1ff7b,0xfa7ffc2f,0xf73bf8d1,
0xf425f5b4,0xf0f4f293,0xed9fef4b,0xe9e0ebdc,0xe559e7aa,0xe0a0e2fa,0xdc5cde67,0xd86ada5c,
0xd563d6b9,0xd3dcd463,0xd44ad3d8,0xd61ad513,0xd8e3d759,0xdc70daa6,0xdfdbde28,0xe34ee195,
0xe6e7e50e,0xeab9e8db,0xedd8ec66,0xf0baef34,0xf4aef291,0xf9a5f70a,0xfefafc58,0x047201a0,
0x0a880770,0x10920da9,0x14ff1306,0x17a31687,0x18aa1851,0x18fb18da,0x191b190b,0x19531933,
0x19721970,0x1955195f,0x1a021985,0x1bd21ad1,0x1e121ce9,0x21281f6e,0x25b32348,0x2af52842,
0x310a2de4,0x36b93425,0x39813888,0x391139ae,0x34e13772,0x2e4d31be,0x266e2a94,0x1cd521ce,
0x125117b0,0x06bb0c9c,0xfba800fe,0xf243f6ca,0xea12ee01,0xe37de692,0xde9ee0d9,0xdb37dcc2,
0xd8cbd9ef,0xd6b4d7b5,0xd492d5b2,0xd1f8d347,0xd006d0d1,0xcfeccfae,0xd17dd09a,0xd385d278,
0xd58ad49f,0xd688d630,0xd6d4d6a5,0xd7ffd745,0xda6ed910,0xdd61dbed,0xe026dec5,0xe393e1b1,
0xe81ae5c2,0xecebea76,0xf27fefa6,0xf882f560,0x0034fc1b,0x0a1804da,0x15b70fd0,0x20cd1b78,
0x2973257a,0x2ed72c95,0x318a3064,0x321b321f,0x30e931b0,0x2e302fc2,0x2a872c61,0x26ef28af,
0x237b2534,0x200f21c4,0x1d1c1e81,0x1a151bac,0x162f1847,0x10be13a8,0x0a780da3,0x0471075c,
0xffb701e5,0xfc18fdd1,0xf8c1fa6b,0xf5a2f731,0xf290f413,0xef81f10c,0xec58edf4,0xe8b4ea9f,
0xe456e692,0xdfefe21a,0xdc37ddfe,0xd8c9da75,0xd623d74f,0xd4fed55c,0xd587d50c,0xd73dd64a,
0xd9cbd867,0xdcfbdb58,0xe060dea9,0xe3cce219,0xe75ee585,0xeb2ae94f,0xee38ecd0,0xf0f8ef88,
0xf4a6f2ab,0xf973f6ec,0xfee2fc23,0x048501a6,0x0ac2078c,0x10f00dfe,0x158a136e,0x185d1732,
0x1995191c,0x1a0d19e2,0x1a3e1a2a,0x1a281a3a,0x19eb1a15,0x196a19a8,0x19771950,0x1a9719ea,
0x1c811b6e,0x1fc21dee,0x24982205,0x2a262754,0x308b2d3b,0x362e33ad,0x38e337ec,0x38b0392c,
0x34d5373f,0x2e6231c5,0x26582aa1,0x1c4a217d,0x114816ea,0x05940b73,0xfac1ffef,0xf1baf614,
0xe9eaeda6,0xe39ae68e,0xdef4e114,0xdb83dd19,0xd8c9da15,0xd64ad78f,0xd37ed4ee,0xd0b9d20f,
0xcf07cfa8,0xcf6dceec,0xd19fd066,0xd476d2f5,0xd73ad5ed,0xd8b4d834,0xd90dd8e1,0xda12d96e,
0xdc33db04,0xdea5dd74,0xe109dfce,0xe40be26e,0xe7cbe5e0,0xebcce9ba,0xf096ee19,0xf64ef34c,
0xfda2f9b8,0x07460223,0x12830cca,0x1d751822,0x26ae2251,0x2d7c2a72,0x317d2fca,0x32e93285,
0x324832d5,0x2fcf313e,0x2c6d2e22,0x29352ac8,0x25c32797,0x21d123c4,0x1e582000,0x1b0a1caf,
0x1762195c,0x121514f3,0x0b770edd,0x04fd0819,0xffc50238,0xfbc4fda6,0xf84ffa06,0xf4fbf6a1,
0xf1b4f359,0xee85f017,0xeb5aecf7,0xe7b8e9a6,0xe370e597,0xdf4ee14e,0xdbe9dd83,0xd8f2da62,
0xd6afd7ae,0xd5aed602,0xd60fd5b6,0xd7abd6ba,0xda3bd8db,0xdd83dbc5,0xe103df4e,0xe44ae2ac,
0xe7a1e5e7,0xeb62e980,0xeed3ed38,0xf185f034,0xf4bef2fa,0xf94bf6d9,0xff11fc18,0x04c601f2,
0x0aa407a7,0x10c60dbb,0x15bc1381,0x18b6176b,0x1a6519b0,0x1b021ad1,0x1b0b1b14,0x1a871ad5,
0x1a111a44,0x196a19cf,0x18ea190c,0x19761911,0x1ae91a0f,0x1da71c17,0x22341fb3,0x2825250f,
0x2ead2b60,0x347231c6,0x37ed3684,0x38d438b1,0x365d381b,0x306133b4,0x284a2c91,0x1e0a236d,
0x12a71866,0x06ba0cc4,0xfb3200b8,0xf1edf656,0xe9cdedb6,0xe335e64e,0xde4ee086,0xdacadc6a,
0xd81fd966,0xd550d6c7,0xd258d3c9,0xcfa9d0f4,0xcdf7ce9a,0xce43cdd7,0xd0e9cf57,0xd44fd29a,
0xd7b4d609,0xd9fbd913,0xdab5da6b,0xdbc4db26,0xdd9adc9a,0xdfc2dea9,0xe22fe0f0,0xe4d3e373,
0xe7fae656,0xeb6be9ae,0xef40ed37,0xf447f19c,0xfb04f766,0x03f1ff2e,0x0eb4092f,0x19781437,
0x232c1e70,0x2b392781,0x30cc2e48,0x33a832a6,0x33e43409,0x32293341,0x2f4830cb,0x2c0c2dac,
0x286a2a5b,0x2430264c,0x20512234,0x1c9e1e7b,0x18a21ab0,0x13861640,0x0d191071,0x068e09bf,
0x010503a4,0xfc81feaa,0xf898fa7d,0xf4e2f6bf,0xf142f30d,0xedbeef78,0xea4cec0c,0xe690e878,
0xe2a2e498,0xded4e0ae,0xdbb3dd29,0xd928da5e,0xd724d80e,0xd621d678,0xd677d61f,0xd815d723,
0xda94d93e,0xddd0dc1d,0xe133df89,0xe44de2cb,0xe764e5c9,0xeaeae922,0xee2aeca5,0xf097ef6e,
0xf39ef1e7,0xf84bf5c3,0xfe22fb28,0x03dd0106,0x09c806c8,0x100c0ce6,0x155b12f3,0x18c61743,
0x1aa819e6,0x1b3a1b11,0x1b0c1b35,0x1a6e1ac0,0x1a021a2b,0x194619b8,0x18a318d9,0x18f318ad,
0x1a701987,0x1d6c1bb8,0x22401f97,0x28932548,0x2f612c00,0x35143272,0x38a73729,0x39ee3996,
0x37d33964,0x3208354f,0x29a12e1f,0x1ef0248a,0x130b18ff,0x07300d28,0xfbd90142,0xf2a1f70b,
0xea84ee73,0xe384e6d8,0xde08e088,0xda27dbef,0xd6dcd87d,0xd383d537,0xd045d1da,0xcd78ced1,
0xcbeecc70,0xcc93cbf8,0xcf8fcdcf,0xd3a9d18c,0xd7c7d5d2,0xda86d966,0xdb79db1f,0xdc57dbdc,
0xddcbdcf4,0xdff1dec9,0xe248e125,0xe4a2e369,0xe76be5f9,0xea71e8eb,0xee08ec11,0xf2eff056,
0xf948f5dc,0x01b9fd3e,0x0bd806af,0x15fb10fd,0x1fab1adf,0x28612434,0x2fa22c36,0x344a325d,
0x360f3583,0x357435fd,0x335c3493,0x304231e4,0x2c522e6c,0x27ce2a19,0x2306256f,0x1e5120aa,
0x19ad1c00,0x1455172d,0x0e05113d,0x07ad0acc,0x01f904b6,0xfd22ff75,0xf8b9faea,0xf47af693,
0xf071f26f,0xec86ee75,0xe8c9eaa3,0xe513e6f2,0xe15ae333,0xdde1df8e,0xdb47dc6c,0xd938da3b,
0xd79ed853,0xd6e5d724,0xd748d6ef,0xd8e3d7f3,0xdb4bd9fe,0xde7bdccc,0xe1c0e034,0xe462e31d,
0xe748e5bb,0xeab0e8fa,0xedbaec49,0xf00deef5,0xf2e7f142,0xf78bf506,0xfd60fa64,0x03080040,
0x08d305db,0x0f590c01,0x15351282,0x19471777,0x1b9a1aa2,0x1c5e1c2a,0x1c291c50,0x1baa1bef,
0x1b2f1b70,0x19f61ab7,0x1860191b,0x17bc17e5,0x187e17e9,0x1b041986,0x1f9c1d03,0x260d22b7,
0x2cc02969,0x32f02ff4,0x37933584,0x39f63911,0x38ef3a00,0x33b436c6,0x2b702fe3,0x20b3265f,
0x149e1aa8,0x08910eb0,0xfc96025c,0xf2f6f782,0xeaf3eed4,0xe421e761,0xdeaae133,0xda9cdc84,
0xd716d8cb,0xd3b3d56b,0xd047d1f6,0xcd4aceb7,0xcb95cc2c,0xcc22cb96,0xcf1ccd53,0xd36bd133,
0xd7cfd5a8,0xdb22d9b0,0xdc7ddc01,0xdd5bdce4,0xde91dde2,0xe091df76,0xe2bfe1b3,0xe493e3b0,
0xe683e578,0xe8e4e7a3,0xec30ea57,0xf0e2ee67,0xf6faf3b1,0xff0efac1,0x090703dc,0x139b0e55,
0x1da318b5,0x26c02262,0x2e6d2ac4,0x346431b9,0x379c3653,0x384e3847,0x367737a5,0x32e834e0,
0x2ea230d5,0x299d2c32,0x24772706,0x1f4621e4,0x19e91c92,0x143c172b,0x0e041130,0x077e0aba,
0x01af0474,0xfceeff40,0xf86ffaa3,0xf426f646,0xefdcf207,0xeba1edb4,0xe7a7e99b,0xe3f7e5c2,
0xe079e230,0xdd70dedb,0xdb3adc3e,0xd95dda4a,0xd7e9d889,0xd783d78c,0xd878d7d5,0xda89d969,
0xdd3cdbcd,0xe081ded2,0xe39ce21e,0xe63be4f9,0xe8f4e788,0xebedea7d,0xee20ed2d,0xefbceedf,
0xf29af0f2,0xf71ef4ac,0xfc7ff9d1,0x01d7ff1e,0x080704c7,0x0f200b94,0x152e1252,0x198b17a7,
0x1ba31adb,0x1bd11beb,0x1b121b7b,0x1a6f1ab7,0x19b41a27,0x181218fa,0x1675172c,0x15d915fe,
0x16b51614,0x194817bb,0x1e681b82,0x250c21b0,0x2ba52855,0x32762f18,0x37de3570,0x3a94399c,
0x398b3aa6,0x33ef3729,0x2b9f3013,0x20ee268a,0x15621b1d,0x09ae0fa0,0xfe7103ec,0xf4a3f94c,
0xecd1f085,0xe600e957,0xdff7e2d6,0xdb19dd6c,0xd728d900,0xd3e3d57d,0xd0bfd252,0xcdbacf1b,
0xcc2accc6,0xccadcc13,0xcf79cde1,0xd361d14c,0xd803d5ac,0xdba7da12,0xdd72dcb8,0xde74ddfc,
0xdf8edeee,0xe173e06f,0xe32fe269,0xe40ce3b4,0xe513e477,0xe6e2e5de,0xea27e845,0xeebeec53,
0xf49bf17d,0xfc11f818,0x056e008d,0x0fcf0a93,0x19ea1501,0x23131e95,0x2b57275c,0x329d2f1a,
0x383535b1,0x3b063a08,0x3a343b11,0x372b38d4,0x329c3521,0x2cd92fca,0x26d629d1,0x20f323e8,
0x1b0e1dfa,0x1512181d,0x0ea211e3,0x082f0b62,0x026f052c,0xfd89ffec,0xf8f4fb3c,0xf473f6b0,
0xefe3f231,0xeb69ed9c,0xe798e968,0xe419e5d5,0xe094e250,0xddaddf06,0xdb82dc7f,0xd9beda9c,
0xd85ed8f4,0xd816d815,0xd92cd876,0xdb42da23,0xdda2dc62,0xe0bbdf17,0xe3b7e24e,0xe61ee4f4,
0xe892e750,0xeb2de9e5,0xed1aec44,0xee93edc9,0xf16aefc4,0xf5d9f372,0xfb19f87a,0x0097fdc0,
0x072203b5,0x0e850acf,0x150511f7,0x19ba17aa,0x1bcd1b16,0x1be31c0a,0x1adf1b6a,0x1a1a1a6e,
0x191c19b7,0x17521841,0x15d71681,0x15641567,0x168e15c9,0x194b17ac,0x1e601b88,0x24c1218c,
0x2b2527df,0x32822ec7,0x388235dd,0x3b6c3a5c,0x3a953b9b,0x35213853,0x2d003152,0x229f2816,
0x17431cf7,0x0b71116a,0xffc60583,0xf5bafa75,0xedbaf18e,0xe696ea1a,0xe01ce340,0xda8add35,
0xd615d82b,0xd26ed42f,0xcf1ed0c1,0xcc2dcd83,0xcab9cb41,0xcb81cac1,0xce84cccf,0xd29cd075,
0xd73bd4e3,0xdb42d970,0xdd75dc8e,0xdee7de30,0xe07adfa0,0xe26ce175,0xe398e326,0xe3cae3c9,
0xe434e3e3,0xe5a1e4c2,0xe8cee6fb,0xed7beb09,0xf338f023,0xfabbf6bb,0x0417ff31,0x0eb20957,
0x18bd13e0,0x21881d46,0x29882598,0x31082d5f,0x37693463,0x3b8939df,0x3bba3c15,0x39613ad3,
0x34da3759,0x2eec3206,0x289a2bbd,0x22542579,0x1c101f25,0x159718ef,0x0edc122b,0x089e0baa,
0x035f05dc,0xfee90112,0xfab9fcd1,0xf64ff890,0xf15ef3e1,0xecb2eefa,0xe887ea89,0xe4cae6a6,
0xe135e2f5,0xde31dfa0,0xdba6dcda,0xd99eda8f,0xd82cd8cd,0xd7ead7dc,0xd8e8d841,0xdaf8d9da,
0xdd5cdc20,0xe07bded3,0xe3a2e218,0xe668e515,0xe8d0e7a2,0xeb42ea0a,0xed01ec46,0xee43ed8e,
0xf0ddef62,0xf4d0f2ac,0xf9abf735,0xff0afc37,0x05820221,0x0cf30932,0x136c1061,0x183c1619,
0x1aa019ba,0x1b0e1b04,0x1a851ada,0x19e11a33,0x18a81966,0x16bf17ba,0x154215e6,0x14f414e6,
0x16521572,0x194f178d,0x1e861bab,0x24d821a6,0x2bb4281b,0x33e82fc9,0x3a663788,0x3d9a3c74,
0x3c443da5,0x3625399d,0x2d91321b,0x22fe2887,0x17941d42,0x0bb011be,0x000005b0,0xf637fac7,
0xee63f22e,0xe71aeab3,0xe07fe3b2,0xdacbdd8a,0xd60fd84a,0xd23dd410,0xcebdd07c,0xcb7accfb,
0xc9b7ca61,0xca77c9ba,0xcd86cbcc,0xd1adcf7c,0xd67ed404,0xdacbd8d2,0xdd78dc4a,0xdf94de88,
0xe191e08f,0xe3a8e2b0,0xe458e43e,0xe381e406,0xe30ee323,0xe3d7e345,0xe6a5e4f0,0xeb4be8d7,
0xf122ee01,0xf8dcf4be,0x026bfd74,0x0cf707a5,0x16df1218,0x1f861b52,0x27352374,0x2ead2af4,
0x3590324a,0x3a65384f,0x3c5d3bbe,0x3b703c46,0x37ba39f0,0x31b834e5,0x2b462e7d,0x24ce280b,
0x1e8321a0,0x17eb1b4f,0x110d1477,0x0aca0dcb,0x056807fb,0x00d8030d,0xfc89feb6,0xf7c0fa40,
0xf226f50a,0xecbdef59,0xe835ea61,0xe426e61f,0xe075e243,0xdd4cdecc,0xdaa4dbea,0xd8b3d993,
0xd7a0d808,0xd7bfd786,0xd8fdd83c,0xdaf2d9e9,0xdd88dc24,0xe0cfdf1b,0xe418e27e,0xe6c8e588,
0xe902e7ea,0xeb40ea26,0xec9eec15,0xedceed16,0xf02ceeda,0xf3c6f1d5,0xf861f5f5,0xfddbfb05,
0x046f00f2,0x0bf00832,0x12c50f7b,0x17ec15a4,0x1abe1999,0x1b971b63,0x1b371b75,0x1aaa1afd,
0x19311a17,0x1702181b,0x15301603,0x14c214b8,0x1648154a,0x197217a9,0x1e611bba,0x241e213b,
0x2ab5272e,0x32fe2ec3,0x39fc36d7,0x3d763c3e,0x3c253d74,0x36293998,0x2db2322a,0x236228b0,
0x18881e08,0x0d1f12dd,0x01cb0765,0xf7f9fc9d,0xefebf3d1,0xe845ec0c,0xe188e4c7,0xdb7fde6c,
0xd690d8d9,0xd2acd487,0xcee9d0d5,0xcb75cd09,0xc988ca42,0xca09c972,0xccb1cb22,0xd0fcceab,
0xd5ecd376,0xda23d839,0xdd01dbaf,0xdf7dde3e,0xe1e3e0b1,0xe3e2e307,0xe447e44e,0xe2e8e3b7,
0xe1b9e230,0xe1ede19f,0xe44fe2d3,0xe8cde658,0xeeeeeba0,0xf6b4f2a2,0x0049fb3f,0x0b1805a5,
0x153c1057,0x1e3419da,0x260b223d,0x2d7229c0,0x344430f9,0x39713725,0x3c4a3b29,0x3c8f3cc3,
0x39b53b91,0x3447372f,0x2df63129,0x27462ab4,0x204423cf,0x19141cae,0x1249159c,0x0c370f26,
0x072e0987,0x02f70504,0xff0200fe,0xfa60fcd4,0xf4a5f799,0xeee2f1af,0xe9c1ec39,0xe53ee777,
0xe103e310,0xdd5fdf23,0xda14dba6,0xd7a0d8b5,0xd65ad6d4,0xd66fd633,0xd7e9d70d,0xd9fad8e4,
0xdca7db36,0xe038de55,0xe3f4e21c,0xe74de5b1,0xea19e8be,0xec67eb62,0xed6aed0d,0xee7dedd2,
0xf083ef64,0xf38df1e8,0xf7a6f577,0xfcf6fa1f,0x03d2003f,0x0ab5075b,0x10f30de9,0x15bb1397,
0x186a174f,0x197a1922,0x19b6199b,0x19cd19d7,0x188c195f,0x167d1780,0x14f1159c,0x14c614a1,
0x165c155c,0x19b817c9,0x1e9b1c13,0x23df213a,0x2a5726cd,0x330f2e8a,0x3abb374c,0x3e623d2f,
0x3c783e1d,0x360239ad,0x2d1d31ce,0x22de280a,0x18461dae,0x0d7512d1,0x02b80811,0xf93ffdb5,
0xf17cf539,0xea1cedc3,0xe346e6a9,0xdd0ae006,0xd815da67,0xd449d613,0xd053d265,0xcca3ce60,
0xca51cb37,0xca55ca03,0xcc67cb27,0xd07bce35,0xd555d2f5,0xd951d779,0xdc57dae8,0xdf12ddbd,
0xe19ce05b,0xe38fe2bc,0xe3abe3e2,0xe211e2f7,0xe07de12d,0xe049e01a,0xe269e112,0xe6d7e456,
0xed31e9cd,0xf518f0f8,0xfec4f9a5,0x09fd0450,0x149e0f80,0x1dc9195b,0x259921df,0x2c712916,
0x32222f7c,0x36923479,0x39b1385d,0x3ad43a7b,0x393d3a70,0x3540377e,0x2fa43295,0x291a2c80,
0x2220259e,0x1b1b1e9e,0x147517b9,0x0e73115f,0x09570bca,0x05110718,0x012d0329,0xfc94ff07,
0xf6eaf9d1,0xf120f401,0xebd0ee61,0xe6f1e95d,0xe272e49a,0xde57e062,0xda8edc61,0xd7b3d8fb,
0xd610d6bc,0xd607d5cf,0xd78ad6a9,0xd9a8d88c,0xdc78daf2,0xe026de38,0xe409e226,0xe740e5bb,
0xe9e5e8a0,0xeba0eaf3,0xec46ebfc,0xed4eecad,0xef0fee22,0xf18df02b,0xf565f346,0xfb01f7f5,
0x01f9fe6b,0x08f40582,0x0f620c50,0x14531214,0x17561610,0x18d11830,0x19ed195d,0x1a821a66,
0x19641a27,0x17a5187e,0x166416e5,0x16751639,0x1840171f,0x1bf619e4,0x20b11e4d,0x25942314,
0x2c30288c,0x34bb306a,0x3b5a3888,0x3d7f3d0c,0x3aa23ca1,0x33e4379f,0x2adb2f9c,0x210e25f0,
0x16ed1c09,0x0cd411e6,0x02a507b0,0xf99dfde9,0xf1ebf5aa,0xeae0ee52,0xe436e782,0xde53e11c,
0xd988dbcd,0xd55fd777,0xd0cbd319,0xccb8cea2,0xca49cb35,0xca34c9f9,0xcc3dcae6,0xd0acce46,
0xd552d31a,0xd8e7d741,0xdbc4da64,0xde7cdd1f,0xe151dfe3,0xe35ae28a,0xe31de38a,0xe145e24c,
0xdf65e047,0xdefbdeee,0xe0e6df99,0xe58be2e9,0xec5ae8b1,0xf4fdf071,0xff92fa0e,0x0b100558,
0x156f1074,0x1e6a1a12,0x2607226a,0x2c4f2956,0x30fa2eda,0x343632c0,0x36963588,0x37b8375a,
0x373637b7,0x3453360f,0x2f66321a,0x291c2c5f,0x225e25c2,0x1bad1eff,0x15531879,0x0f941258,
0x0ab80d07,0x06bd08a8,0x02ed04e1,0xfe2400ac,0xf87dfb63,0xf2bdf592,0xed6df00c,0xe837eacd,
0xe383e5c3,0xdf5ce16e,0xdb40dd40,0xd823d98e,0xd63dd702,0xd602d5e7,0xd747d681,0xd983d84f,
0xdc65dae2,0xdff7de1a,0xe3cae1e0,0xe742e5a1,0xe9c7e8a8,0xeb40eaa1,0xec42ebc1,0xed97ecdd,
0xef45ee6a,0xf141f024,0xf501f2d5,0xfab8f7ab,0x0122fde7,0x07ac0462,0x0dad0ad3,0x12411024,
0x155e1402,0x175c1674,0x1930184b,0x19ed19d2,0x18ec198d,0x1798183c,0x16bc1717,0x16e616a1,
0x18eb17a8,0x1c901a9d,0x20d41ea9,0x25ca2326,0x2cbb28fe,0x352530f3,0x3b3d38a9,0x3cdb3ca9,
0x3a1e3bf9,0x335d3730,0x2a832f17,0x20e125bd,0x17321bf8,0x0d901277,0x03780876,0xfa6afec4,
0xf2a0f66d,0xeb90ef02,0xe52de847,0xdfdbe25d,0xdb7bdd97,0xd70cd95a,0xd21cd496,0xcda9cfbc,
0xcb19cc2d,0xca30ca62,0xcc1ccac0,0xd06ace26,0xd4c6d2a1,0xd887d6c5,0xdb84da0f,0xde56dcec,
0xe14cdfd4,0xe33de284,0xe2d9e34d,0xe0cfe1f8,0xde8ddf9a,0xddd2ddee,0xdf5ede4a,0xe385e125,
0xea12e683,0xf2f9ee35,0xfe30f85a,0x0a010428,0x14c50f8f,0x1e1d199b,0x25a9222d,0x2b7f28bc,
0x2f8d2dd1,0x31ef30d7,0x339232e2,0x34b6341f,0x350a3516,0x33dd34aa,0x30b73288,0x2bbe2e6f,
0x25a628c4,0x1f572289,0x18d31c07,0x12c715bc,0x0d951006,0x09580b5d,0x0537075c,0x007602f0,
0xfacefdb0,0xf518f7ed,0xef5cf23d,0xe9baec86,0xe4aee717,0xe021e263,0xdbc0dde9,0xd82bd9cc,
0xd5c3d6d2,0xd4ffd527,0xd5d1d53d,0xd7edd6c0,0xdac5d94a,0xde38dc62,0xe26ce044,0xe64ee473,
0xe938e7ed,0xeae2ea27,0xec7beb9f,0xee48ed60,0xf01eef41,0xf1fbf0ef,0xf55ef376,0xfa62f7b8,
0x0011fd2c,0x06160310,0x0bce0907,0x10620e46,0x13ae122d,0x162914f1,0x1882176a,0x19781939,
0x19241961,0x187f18d3,0x17fd1831,0x18651807,0x1a92193c,0x1e511c57,0x22652057,0x277c24b2,
0x2ea32acf,0x3637329a,0x3b01391e,0x3b363ba2,0x375739cc,0x300c33fa,0x27572bc8,0x1e1922c2,
0x1524198a,0x0c0710b1,0x029b073d,0xfa4cfe49,0xf311f695,0xec98efc9,0xe6b1e981,0xe1d2e429,
0xdd80dfa8,0xd87bdb20,0xd323d5d3,0xce73d08f,0xcb8accce,0xca9ccac2,0xccd4cb54,0xd112ced8,
0xd576d34d,0xd93fd774,0xdc5adadc,0xdf6bddda,0xe279e0fd,0xe42be39b,0xe3a2e42d,0xe14de29b,
0xdef8e003,0xde29de5f,0xdf68de72,0xe354e110,0xe9dfe646,0xf31aee21,0xfe71f8a2,0x09be043b,
0x13c50eec,0x1c661847,0x23222002,0x283125e1,0x2b3a29fe,0x2ce62c23,0x2ddc2d6a,0x2eda2e64,
0x2f762f3a,0x2f3a2f80,0x2ded2eb5,0x2b022cb3,0x269828f8,0x211723f4,0x1b3f1e2e,0x15be1863,
0x11371355,0x0d7b0f4c,0x098a0b96,0x04b9074c,0xff1d01fd,0xf92cfc2a,0xf313f62e,0xed0feffd,
0xe79fea45,0xe289e509,0xdda0e009,0xd992db7c,0xd6aed7f1,0xd57fd5e3,0xd5ead587,0xd79fd6a4,
0xda5bd8e3,0xddeedc03,0xe22de00c,0xe5aee41e,0xe7bde6de,0xe952e879,0xeb9cea64,0xee0cecda,
0xefdeef0d,0xf208f0d0,0xf59cf3a2,0xf9fcf7c6,0xfec9fc4b,0x04010168,0x08b30675,0x0caa0ac4,
0x0fdc0e56,0x1314116c,0x15c4149c,0x172f1693,0x17eb179f,0x18631828,0x18db1899,0x1a1c1949,
0x1cc91b51,0x1ff11e57,0x23e521bc,0x295c266e,0x30782cc0,0x374b3424,0x3ab5398a,0x3a7d3b01,
0x363938e7,0x2f0432d2,0x26a62af8,0x1ddc2237,0x153b199c,0x0bd41097,0x02ac0724,0xfa9cfe7b,
0xf3b5f70d,0xed8cf08f,0xe83aeabe,0xe3eae600,0xdf67e1cc,0xd9fbdcc8,0xd419d70a,0xcf53d17a,
0xcbeccd77,0xcb38cb20,0xcdb9cc32,0xd175cf89,0xd552d36a,0xd8a0d70d,0xdb70da10,0xde7ddcf3,
0xe166e008,0xe319e274,0xe2a5e331,0xe051e192,0xde64df37,0xddb3ddde,0xdecfddfc,0xe231e032,
0xe868e4e9,0xf1f6ecc5,0xfdb1f7b5,0x09320390,0x13760e84,0x1c091805,0x22821f79,0x273a252a,
0x29bb28af,0x2afd2a8d,0x2b582b21,0x2be62ba5,0x2c512c1e,0x2c792c69,0x2c182c6b,0x2a7a2b6a,
0x27a62938,0x239525c5,0x1e732115,0x19761bea,0x15161725,0x1133132e,0x0ce10f1c,0x07b00a68,
0x01e104dd,0xfbadfed6,0xf518f865,0xeecdf1e2,0xe8fdebcf,0xe386e642,0xde75e0e5,0xda12dc29,
0xd6b8d839,0xd4ead59d,0xd4d4d49f,0xd654d572,0xd8f9d77e,0xdccddabf,0xe101def2,0xe45de2dd,
0xe648e57c,0xe841e71e,0xeb04e999,0xedebec82,0xf022ef12,0xf2a6f14d,0xf5fef433,0xf9b2f7d9,
0xfdc8fba5,0x02430009,0x0686046b,0x0a88089b,0x0de70c43,0x117e0fab,0x14691317,0x16501572,
0x17b61711,0x18db1855,0x19b71948,0x1b641a61,0x1e301cb3,0x216b1fc2,0x25a2234e,0x2b812869,
0x327d2eed,0x388f35dd,0x3acf3a37,0x394d3a7a,0x34273731,0x2c913078,0x2447288e,0x1bb91ff0,
0x132c1789,0x0a320eab,0x019a05ca,0xfa74fddb,0xf43ef749,0xee90f147,0xe9dbec16,0xe5dce7da,
0xe110e3a2,0xdb63de4e,0xd55bd851,0xd07ed2c0,0xccf7ce7a,0xcc5acc3e,0xce98cd34,0xd1f2d036,
0xd5a1d3cc,0xd8f2d756,0xdc11da80,0xdf53ddac,0xe235e0e1,0xe3cde33c,0xe311e3c3,0xe0b3e1ed,
0xdec7dfa5,0xddd3de22,0xdebede02,0xe1dde002,0xe802e47b,0xf189ec5f,0xfd2cf73e,0x08d60321,
0x131f0e26,0x1b751797,0x21961ebe,0x259b23f2,0x276826b5,0x27d327ba,0x27a927d0,0x273c276a,
0x26f52713,0x273526f9,0x27af2787,0x278727a8,0x26c42747,0x24a625e3,0x21352318,0x1d1d1f20,
0x191e1b22,0x14f41711,0x104912b8,0x0af60db4,0x05360823,0xfefb022e,0xf88bfbbb,0xf264f573,
0xec57ef58,0xe6c4e97d,0xe18be41c,0xdc8edf04,0xd865da59,0xd581d6c7,0xd420d495,0xd4d0d433,
0xd77ed5e4,0xdbc1d988,0xdfe9ddfd,0xe279e161,0xe44ce363,0xe69ae555,0xe9b7e81f,0xec8feb35,
0xef8cee00,0xf31af13b,0xf689f4ec,0xf986f801,0xfcf9fb2f,0x009afeca,0x04400266,0x082d062e,
0x0c520a40,0x100d0e4a,0x131111a0,0x15951467,0x179e16a3,0x1930187a,0x1aaa19d8,0x1cdb1bb5,
0x1ef21dee,0x21f42035,0x26f72443,0x2cc229d6,0x32c62fb7,0x3762357b,0x38f83883,0x3759389b,
0x32853550,0x2b6a2f2a,0x23ac2783,0x1bdd1fde,0x138517b5,0x0b000f4d,0x026606a5,0xfb38fe8f,
0xf539f828,0xefeef273,0xeb8feda3,0xe778e995,0xe2bfe52b,0xdd45e01b,0xd7c3da7b,0xd279d50e,
0xceb8d04a,0xcdb9cdde,0xcf08ce1c,0xd1e2d05a,0xd520d37a,0xd894d6da,0xdbd1da38,0xdeb9dd5c,
0xe10edfef,0xe26ee1f2,0xe1f9e26d,0xe051e136,0xdea6df6c,0xdde4de20,0xde9fde0d,0xe15ddfac,
0xe72de3e1,0xefebeb32,0xfae6f536,0x06c600dc,0x11790c61,0x19f115fb,0x1fee1d47,0x238d2203,
0x25352493,0x25872582,0x24ce2545,0x24012469,0x239623ae,0x242523c4,0x25072497,0x25ce2572,
0x264a261c,0x25ad262a,0x23b024d9,0x20bf2255,0x1d2a1f05,0x18eb1b1b,0x143b16a4,0x0f3211ba,
0x09740c73,0x0301064d,0xfc77ffb2,0xf5ebf933,0xef5ff2a7,0xe921ec35,0xe336e625,0xdd7be050,
0xd859dac9,0xd48ed63c,0xd2a9d356,0xd302d288,0xd5c9d419,0xda3ad7e7,0xde6adc75,0xe134dffe,
0xe371e247,0xe639e4c2,0xe93fe7c5,0xec35eaae,0xef8cedd7,0xf331f167,0xf617f4be,0xf8c2f765,
0xfb93fa23,0xfe88fd05,0x0221003e,0x064a0422,0x0aa70886,0x0e650c98,0x11d41029,0x14ea1366,
0x17bc1664,0x19e618ea,0x1c131aea,0x1e841d5a,0x20d11f98,0x24a42273,0x2a222747,0x2fd42cf8,
0x35aa32c8,0x397237fa,0x39c73a0e,0x36823889,0x307633c2,0x28e52cd3,0x20ea24e6,0x18b61ce1,
0x10671490,0x07f00c33,0x002c03cf,0xfa26fd02,0xf519f786,0xf0e1f2ef,0xed38eefc,0xe95aeb60,
0xe4bae735,0xdf09e1ed,0xd90adc10,0xd35cd611,0xcfafd12e,0xceb1cee6,0xd00fcf1d,0xd2bad157,
0xd587d41c,0xd895d703,0xdbadda20,0xde86dd26,0xe136dfe8,0xe294e228,0xe1ebe27b,0xe047e129,
0xde82df52,0xddc0ddf3,0xde8eddf9,0xe18fdfad,0xe79ce438,0xf093ebbf,0xfb98f5ea,0x0717016e,
0x11000c55,0x18af1519,0x1e241bac,0x21572009,0x22692212,0x223f227e,0x212721b4,0x200d2090,
0x1fd11fc3,0x20b52027,0x21fd214f,0x239b22c3,0x24f5245f,0x2589255e,0x24ff2562,0x238d2469,
0x20f12264,0x1d391f36,0x18731af2,0x12fd15cc,0x0ccf0ffa,0x06130974,0xff6002b5,0xf87dfbf5,
0xf19bf4fa,0xeb35ee5e,0xe50de822,0xdefee201,0xd971dc1b,0xd4f7d70e,0xd226d348,0xd1fed1b7,
0xd4add307,0xd8eed6ba,0xdca5daf5,0xdf66de0e,0xe249e0cd,0xe59fe3e7,0xe8a4e739,0xebe4ea29,
0xefc9edc0,0xf3b7f1e6,0xf67bf537,0xf88ef79b,0xfa66f96c,0xfcd5fb83,0x005ffe72,0x0515029e,
0x09b8078c,0x0d750b9b,0x11210f52,0x148d12e1,0x177d161c,0x19e918b3,0x1ccb1b50,0x1f6a1e32,
0x224420a2,0x276e2499,0x2d312a61,0x32882fd4,0x37833537,0x3a133928,0x39453a29,0x34a1375e,
0x2dbc3162,0x25d629ce,0x1ddc21e9,0x15b519bf,0x0ddc11be,0x060909f3,0xff37026b,0xf9d6fc60,
0xf593f79d,0xf1d8f3a5,0xee7af02e,0xeaa9ec98,0xe600e882,0xe088e34b,0xda76dd99,0xd4a8d75e,
0xd0ebd27a,0xcfa5cff1,0xd0e9d001,0xd3a5d232,0xd6acd529,0xd9dad841,0xdcd6db67,0xdf6cde23,
0xe1e1e0c4,0xe2d2e294,0xe250e2b4,0xe0c6e1a1,0xdf32dfea,0xde6edeab,0xdf2dde8f,0xe262e06a,
0xe84ee505,0xf0e6ec4a,0xfb6ff601,0x060000e2,0x0ec20aa0,0x15ac127b,0x1aa6185a,0x1ddf1c87,
0x1f1d1eb1,0x1eaa1f1c,0x1d791e10,0x1c531cdb,0x1c2d1c1a,0x1d201c88,0x1eea1df2,0x214a200d,
0x239e2286,0x2523247a,0x263625c0,0x26522670,0x250525e6,0x21f523a5,0x1d9e1ff3,0x18351b0b,
0x11be1514,0x0ada0e57,0x03d20760,0xfc94003d,0xf53ef8d8,0xee30f1b1,0xe71ceaa3,0xe038e39d,
0xda04dcfe,0xd4f9d75a,0xd1b9d309,0xd131d11a,0xd37ed208,0xd76ed564,0xdaf7d957,0xddbcdc57,
0xe0f9df4c,0xe490e2c5,0xe7a3e627,0xeb11e94b,0xef2bed03,0xf308f147,0xf5a6f471,0xf79cf6b8,
0xf955f874,0xfbcffa6c,0xff8efd82,0x044a01df,0x08ab069a,0x0c8a0a9a,0x10610e76,0x140a123e,
0x173015b4,0x19dd1887,0x1ceb1b5c,0x1fac1e5b,0x2336212d,0x290825e6,0x2f302c36,0x348131e8,
0x38d836eb,0x3a993a17,0x38f23a53,0x338c3690,0x2c0a3007,0x23e727f0,0x1ba91fd0,0x13791781,
0x0ba30f84,0x040b07c8,0xfd8c0098,0xf8abfae5,0xf516f6c3,0xf222f397,0xef24f0b0,0xebd4ed7d,
0xe7ade9ed,0xe2c9e54c,0xdd03e000,0xd787da26,0xd3add552,0xd1fcd28b,0xd292d20f,0xd4cfd388,
0xd7bdd640,0xdaa8d93e,0xdd37dbfe,0xdf8cde5d,0xe1d0e0c6,0xe2f4e28d,0xe2a7e303,0xe11ee1f3,
0xdfafe04a,0xdf25df4f,0xdff1df4c,0xe311e131,0xe89ee58e,0xf0b9ec5e,0xfaf1f5a1,0x05250041,
0x0d7c0986,0x14041106,0x189f167d,0x1b731a54,0x1c5d1c1f,0x1b8b1c22,0x1a211acf,0x190b197f,
0x18cd18d4,0x19a61911,0x1bad1a80,0x1e9d1d19,0x21a9202d,0x243e2304,0x26482550,0x27752709,
0x27412790,0x251a265f,0x214c236d,0x1bf81ed5,0x156718c3,0x0e5b11ec,0x07290ac3,0xffbe037a,
0xf821fbef,0xf089f451,0xe907ecc7,0xe1bce553,0xdb3ede55,0xd5e4d86d,0xd253d3d2,0xd166d17c,
0xd353d215,0xd6d9d502,0xda1fd890,0xdd66dbb4,0xe0eedf20,0xe489e2d3,0xe782e608,0xeabce91a,
0xeea8ec98,0xf202f07d,0xf47ff353,0xf671f589,0xf801f736,0xfa7bf90c,0xfe71fc45,0x032500d4,
0x073c0548,0x0b170921,0x0f310d24,0x132a113c,0x168d14f3,0x19851803,0x1ccc1b2e,0x1fd91e4f,
0x246521c9,0x2af22790,0x313d2e39,0x366f33ff,0x39fb386e,0x3b793b10,0x39103ae3,0x33083658,
0x2ab52f1b,0x220a264e,0x19941dc6,0x117a1577,0x09eb0da8,0x02f10659,0xfce1ffbe,0xf87afa71,
0xf546f6c4,0xf29df3e9,0xefc6f13b,0xecfaee63,0xe981eb5c,0xe53de788,0xdfa3e287,0xda60dce6,
0xd63dd81a,0xd3c8d4bc,0xd3dcd37e,0xd628d4cc,0xd94fd7b4,0xdc49dae0,0xde78dd7d,0xe06adf64,
0xe24fe16f,0xe364e2f6,0xe309e374,0xe152e23d,0xdfb6e074,0xdef6df2e,0xdfb4df13,0xe286e0d9,
0xe7b1e4cd,0xef9feb48,0xf9e6f4a1,0x0394fefe,0x0b8607bc,0x11740ecf,0x1577139c,0x17e816e0,
0x1880187e,0x177b181b,0x15ea16b6,0x14ec1545,0x151914dc,0x168a15a7,0x194617c0,0x1d001b0b,
0x210b1f0a,0x247222db,0x272125de,0x28f42831,0x29502952,0x280728e7,0x24e026a8,0x1fbd2297,
0x19341c96,0x122a15b5,0x0af50e9a,0x03650739,0xfb88ff7f,0xf377f785,0xeb9eef7b,0xe3e1e7b9,
0xdd03e04d,0xd728d9f4,0xd325d4d3,0xd1f0d235,0xd31dd23e,0xd5ced46a,0xd897d728,0xdc39da4d,
0xe056de3e,0xe402e250,0xe717e596,0xea54e8a4,0xedf0ec26,0xf0cfef75,0xf34ff21d,0xf52ff454,
0xf6ddf5f7,0xf968f807,0xfd54fb26,0x01feffb8,0x05dc0401,0x09be07c2,0x0e140bdb,0x12721050,
0x161d145b,0x19d717e9,0x1d821bc2,0x21211f31,0x270323bb,0x2e392aa2,0x344a3173,0x392c36e3,
0x3c1c3af4,0x3c0c3c88,0x37ad3a5b,0x30333447,0x27152ba7,0x1e6622b7,0x15f61a22,0x0e2311f1,
0x06e80a75,0x00710382,0xfb56fdb7,0xf78ef949,0xf500f628,0xf313f3fe,0xf0fcf214,0xee78efdd,
0xeabcecb3,0xe5d8e878,0xe049e305,0xdbc1dddc,0xd868d9fe,0xd66fd72c,0xd6b9d649,0xd8f7d7b4,
0xdb9cda4c,0xddc3dcc5,0xdf64de9e,0xe146e041,0xe323e245,0xe461e3e0,0xe402e472,0xe285e34e,
0xe101e1b7,0xe03ae07c,0xe119e069,0xe43be261,0xe9e9e6b7,0xf262eddf,0xfbcaf72d,0x036cffd7,
0x09aa06c2,0x0e0f0c06,0x11480fe4,0x130f1251,0x13321358,0x123212c8,0x10f21186,0x10601093,
0x10a01058,0x121a1136,0x1539136f,0x19b7175e,0x1e761c1d,0x229b209d,0x2648247a,0x296027f4,
0x2b412a7f,0x2b7a2ba4,0x29042a9a,0x23cf26bc,0x1d062077,0x160e1993,0x0ec91277,0x06e80af1,
0xfea102cd,0xf64dfa73,0xee07f230,0xe5f8e9e8,0xdeece24f,0xd8f2dbc6,0xd4f3d6a0,0xd39ad3f4,
0xd48fd3d6,0xd662d57d,0xd891d756,0xdc3cda3a,0xe085de63,0xe3f4e263,0xe6afe55b,0xe96be7fc,
0xec62eb03,0xee96ed87,0xf0a2efa3,0xf272f18b,0xf49bf369,0xf7a1f5ff,0xfbf4f99d,0x00cafe71,
0x050902f6,0x094c0729,0x0dc30b7b,0x12040ff9,0x15a113d7,0x19c317a3,0x1def1be6,0x225d1ff5,
0x29122572,0x309b2ce6,0x36f433f1,0x3bb639a1,0x3da43d09,0x3c7a3d86,0x37013a33,0x2ebc3328,
0x253b29fa,0x1bfe2092,0x130f177a,0x0ad10ed7,0x0397070a,0xfdcd0082,0xf940fb5d,0xf5d7f771,
0xf399f491,0xf239f2e2,0xf0a7f16f,0xee9cefd2,0xeb35ed0e,0xe68be911,0xe17ee3ea,0xdd9cdf64,
0xdab2dc0f,0xd8f0d99d,0xd93cd8ce,0xdb51da29,0xddaedc8b,0xdf81dea4,0xe0f1e036,0xe2c3e1cc,
0xe477e3ad,0xe5a7e52e,0xe53ae5a3,0xe3c9e491,0xe25de304,0xe1b2e1e3,0xe2abe1e9,0xe5d5e3f5,
0xeb79e84e,0xf370ef46,0xfb60f796,0x01d5fec1,0x06fc04a0,0x0a8b08df,0x0d180bf1,0x0e6c0dff,
0x0e140e6b,0x0cdb0d7a,0x0bdd0c48,0x0bb40bb0,0x0c650be9,0x0e570d29,0x12180ffb,0x173a1494,
0x1c5f19dc,0x20e81eb8,0x254a231b,0x2911274a,0x2beb2aa0,0x2d5b2cdf,0x2c372d31,0x27cd2a61,
0x219c24cd,0x1ad31e4e,0x13641737,0x0b310f5d,0x029c06f0,0xfa0ffe4b,0xf1abf5e4,0xe952ed6c,
0xe1e3e580,0xdb86de7f,0xd757d91d,0xd588d624,0xd5fcd58d,0xd6cbd66d,0xd840d748,0xdbd5d9d2,
0xdffeddf7,0xe35be1d0,0xe5e9e4a9,0xe88ee72d,0xeb3ce9fe,0xed30ec43,0xeef2ee18,0xf0c3efc8,
0xf350f1f8,0xf66af4c7,0xfa9cf85f,0xff3bfcf9,0x0360014f,0x07b80584,0x0c3909f4,0x105e0e64,
0x14191235,0x189c1640,0x1d501afa,0x228b1fb7,0x29ea2607,0x31c02de5,0x3898354f,0x3d713b65,
0x3ed43e88,0x3cc83e59,0x368d3a0c,0x2db2326a,0x23df28c5,0x1a631f17,0x114815bf,0x09060d05,
0x0218055a,0xfcc7ff3a,0xf8c3faaa,0xf5b4f71d,0xf3d6f4a6,0xf2aef33a,0xf176f209,0xefaef0c4,
0xec99ee43,0xe82fea97,0xe345e5a2,0xdf86e134,0xdcb3de11,0xdafadb9c,0xdb54dae6,0xdd1fdc1a,
0xdf20de26,0xe0cae008,0xe1ede15d,0xe371e2a6,0xe4e9e43a,0xe5fee591,0xe59fe5ff,0xe409e4e7,
0xe26fe330,0xe186e1d0,0xe26fe1b8,0xe5a8e3bf,0xeb94e83e,0xf397ef74,0xfafaf783,0x00ebfe1a,
0x056e0368,0x086d0702,0x0abf09b0,0x0b960b73,0x0ad10b57,0x09640a11,0x089c08e3,0x08c30892,
0x09b90921,0x0bf20aa2,0x101b0dc6,0x159712cc,0x1af9185d,0x1fab1d65,0x242721ee,0x28392645,
0x2b6629f1,0x2d962ca7,0x2d972dfa,0x2a4b2c4a,0x24f727c8,0x1ea921ee,0x177c1b32,0x0f421383,
0x06400ad3,0xfd2501a6,0xf428f8ac,0xeb59efaa,0xe38ae752,0xdce4dfff,0xd871da5e,0xd686d726,
0xd6ced681,0xd75bd71a,0xd88bd7b6,0xdbd8d9fc,0xdfb6ddcb,0xe2d8e16e,0xe501e402,0xe71ce5fe,
0xe976e84d,0xeb5bea78,0xed0cec2c,0xef49ee0c,0xf25bf0bf,0xf5f2f418,0xfa68f810,0xff33fcd9,
0x03900162,0x07f805c3,0x0c360a1f,0x0ff70e2a,0x138511b1,0x181915a4,0x1d5a1ab4,0x23172013,
0x2a9526aa,0x32602e8e,0x392835f0,0x3d9a3bcc,0x3e3b3e62,0x3b4f3d42,0x34a43864,0x2bb73056,
0x21e826d2,0x186f1d1f,0x0f4b13cf,0x070e0aff,0x006f038b,0xfb90fdce,0xf7d6f995,0xf51ff653,
0xf393f43d,0xf29ff315,0xf1baf222,0xf04ff131,0xed70ef09,0xe94deb88,0xe4e3e706,0xe192e30e,
0xdf04e035,0xdda2de12,0xde45ddbe,0xdffbdf17,0xe1afe0d9,0xe328e27a,0xe433e3b0,0xe55be4c1,
0xe6a0e5ff,0xe782e730,0xe6f1e771,0xe541e62b,0xe38be456,0xe29de2ea,0xe382e2c5,0xe6e0e4e3,
0xecc3e986,0xf3e7f052,0xfa62f74e,0xff50fd0c,0x02860128,0x04ba039c,0x069505cf,0x06e406f1,
0x05bb0676,0x0480050a,0x03f90422,0x043f03fd,0x059404c7,0x082706ae,0x0c7b0a15,0x12390f41,
0x18071531,0x1d7c1ac7,0x228c2014,0x272724e7,0x2b2a293a,0x2e182cd5,0x2f062edc,0x2d2e2e76,
0x290f2b5b,0x2323264d,0x1bd51fa7,0x136017b6,0x0a3a0ee0,0x010a0591,0xf7f0fc86,0xeeeff35f,
0xe6b9eab8,0xe00ae318,0xdbc9dd96,0xda15da9f,0xd9f2d9f4,0xd96ed9bd,0xda0ed96d,0xdcbedb40,
0xe019de70,0xe265e16b,0xe3e1e32e,0xe5b6e4ac,0xe7c5e6d3,0xe95ce894,0xeb16ea2d,0xed5fec21,
0xf080eeda,0xf42cf239,0xf8f0f66a,0xfdabfb6c,0x01cdffbe,0x060503f0,0x09e00806,0x0d6d0bac,
0x11420f36,0x167713ba,0x1c121942,0x225f1f05,0x2a872648,0x32a22eb6,0x39433630,0x3d313ba0,
0x3df03ded,0x3b3d3d26,0x34a73851,0x2b88305c,0x21b3268b,0x18401cf8,0x0ef01383,0x06b50aa8,
0xfff50328,0xfb1cfd41,0xf7baf94c,0xf55cf669,0xf422f4a4,0xf36ff3c5,0xf2fff326,0xf1c7f29c,
0xef18f0a4,0xeaafed10,0xe64ae858,0xe30ee487,0xe04ce19c,0xdf1ddf72,0xdfd3df3d,0xe1a4e0b1,
0xe354e284,0xe468e400,0xe4fde4ac,0xe5eee56e,0xe72ce682,0xe812e7c0,0xe779e7ec,0xe5c9e6be,
0xe3d0e4c6,0xe2bce314,0xe3a0e2e4,0xe6dde4f1,0xec8fe96d,0xf3a1effd,0xfa1ff724,0xfe8efc8c,
0x0116001c,0x02c901d5,0x040d0398,0x03fd0447,0x024d033e,0x00f3017d,0x00890097,0x010d00bb,
0x028f019f,0x057603d6,0x0a0c0783,0x100a0cf3,0x16271326,0x1bca190a,0x20f91e70,0x25f5237d,
0x2a9b2852,0x2e292ca0,0x2f772f24,0x2e8a2f3b,0x2b872d49,0x2653293d,0x1f4a22fe,0x16f21b3e,
0x0de71279,0x04b3094e,0xfb340001,0xf1baf662,0xe943ed5c,0xe248e581,0xddbedfae,0xdbc1dc6e,
0xdb6cdb8b,0xdad7db26,0xdb60dad3,0xdd8bdc55,0xe03edef1,0xe205e143,0xe32ee2a3,0xe4d2e3da,
0xe6dee5e1,0xe886e7b8,0xea3ae958,0xec83eb3f,0xef74edf3,0xf322f124,0xf81ef586,0xfcd6fa98,
0x00f1fee5,0x04e302ee,0x089f06ca,0x0c250a66,0x103b0e07,0x15b812d3,0x1bed18c1,0x22fd1f44,
0x2b942731,0x33b32fd1,0x3a5a373b,0x3e193cc0,0x3d9b3e55,0x39833c02,0x3215361f,0x28ea2d97,
0x1f602425,0x16041ab1,0x0ce9116d,0x04bf08a3,0xfe72015c,0xfa3bfc15,0xf73cf89b,0xf529f615,
0xf41bf480,0xf3b5f3ea,0xf320f36f,0xf1adf28d,0xeef9f081,0xeb0eed12,0xe787e92a,0xe52ce63b,
0xe341e425,0xe294e2b0,0xe38de2ed,0xe4d9e43a,0xe5dce566,0xe671e62f,0xe71be6b5,0xe81ce798,
0xe8fae892,0xe954e944,0xe8ade921,0xe727e800,0xe549e632,0xe452e49b,0xe560e491,0xe8b2e6bb,
0xedf9eb34,0xf3d6f0e2,0xf86ef665,0xfb82fa17,0xfd59fc91,0xfefdfe30,0xffd4ff83,0xff5bffd4,
0xfd9afe8a,0xfc7cfce6,0xfc8efc60,0xfd68fce9,0xff09fe13,0x020b0058,0x06bb0431,0x0c7c0980,
0x12ac0f94,0x18c415b9,0x1edc1bcc,0x24be21db,0x2a0d2783,0x2de42c2e,0x2fe32f28,0x2fe1301e,
0x2e0a2f37,0x29c72c39,0x234f26ca,0x1b4f1f6d,0x128416f9,0x09590dfa,0xffa20493,0xf5e1faa4,
0xecfdf15a,0xe5bce906,0xe114e319,0xdedfdfa9,0xde37de82,0xdd3dddc0,0xdd64dd0c,0xdf1ade22,
0xe128e02a,0xe209e1c8,0xe25ce230,0xe39ee2c9,0xe569e4a3,0xe674e5ee,0xe7dde716,0xea18e8db,
0xed12eb86,0xf0bfeec2,0xf5caf31e,0xfabbf86a,0xfedffcdc,0x02ba00d5,0x064c0489,0x09c20802,
0x0e0d0bab,0x143f10fb,0x1ad9178e,0x22311e47,0x2af6268a,0x33242f38,0x39bd36af,0x3d6f3c18,
0x3d443dbd,0x39d03c08,0x330636bc,0x2a7a2ee9,0x211225ca,0x17ce1c77,0x0e56130a,0x05c709e0,
0xfee90220,0xfa2cfc41,0xf711f878,0xf4ecf5e0,0xf3dff441,0xf354f3a9,0xf2e1f300,0xf1fff29d,
0xefdcf11d,0xec1dee21,0xe87eea2b,0xe609e727,0xe41ee4fa,0xe3bee3aa,0xe508e447,0xe69ee5d0,
0xe7b2e746,0xe7fbe7ef,0xe823e7f6,0xe8fee88c,0xe9aae950,0xea15ea02,0xe942e9c8,0xe7cfe89d,
0xe614e6f0,0xe4fde55e,0xe5b6e512,0xe857e6d1,0xecf2ea6c,0xf284efb4,0xf6f2f4f7,0xf9b9f888,
0xfb89fab7,0xfcd6fc37,0xfda6fd5f,0xfce5fd7b,0xfafcfbf8,0xf9f2fa4a,0xfa05f9d2,0xfafffa7a,
0xfcb2fbb0,0xffc7fe0c,0x04af01fe,0x0ac407a4,0x110b0de9,0x171f1417,0x1d121a1f,0x2300200d,
0x288725d9,0x2cd32ad9,0x2f532e53,0x30022fe2,0x2eea2fb1,0x2ba62d9b,0x26162928,0x1eac228b,
0x163f1a8d,0x0d2d11c9,0x036f0869,0xf994fe67,0xf089f4ef,0xe948eca0,0xe45de688,0xe1cbe2c8,
0xe0b3e131,0xdfb0e02e,0xdfbedf7f,0xe0fbe04e,0xe257e1b9,0xe2a9e2af,0xe245e26e,0xe2ffe26f,
0xe42be3a4,0xe4e3e48c,0xe5e9e54a,0xe7dee6c6,0xea94e921,0xee80ec5b,0xf3b7f0fe,0xf8ecf66b,
0xfd6afb37,0x0167ff7a,0x05340354,0x08ee070c,0x0d720b00,0x13831056,0x1a3416d3,0x21b11db7,
0x2a6b2608,0x32692e9f,0x38cb35d1,0x3c833b1f,0x3c503cd9,0x38c13af7,0x321b35bb,0x29f02e21,
0x2100258f,0x17b51c61,0x0e4712fe,0x055709a9,0xfe1d0176,0xf93efb66,0xf644f795,0xf442f52b,
0xf2fef380,0xf270f2ae,0xf24ff251,0xf1b6f225,0xefb4f0e9,0xec9eee33,0xe9c3eb1c,0xe7a3e89e,
0xe63ae6cd,0xe662e616,0xe819e722,0xea06e919,0xeb10eab4,0xeb03eb23,0xeaf9eae5,0xeb85eb33,
0xec27ebd9,0xec32ec52,0xeafcebba,0xe91cea15,0xe742e81c,0xe638e699,0xe66be62a,0xe81ee703,
0xec3ae9f3,0xf140eec1,0xf526f36f,0xf766f662,0xf86ef815,0xf92ef8c8,0xf963f963,0xf864f918,
0xf6a9f778,0xf621f639,0xf6bbf64c,0xf7f7f748,0xfa0ef8ea,0xfd25fb6a,0x022aff61,0x08bc0559,
0x0f390c0a,0x159c1265,0x1bfb18d4,0x22061f0d,0x27cb24fd,0x2c312a34,0x2eb92db0,0x2fae2f65,
0x2eec2f86,0x2c372dcc,0x27d72a40,0x21ea2510,0x1a921e6d,0x1216167d,0x08700d61,0xfe7d0371,
0xf500f99a,0xed5ff0e5,0xe7f9ea65,0xe4dde61d,0xe354e407,0xe20be2a6,0xe1d1e1bf,0xe28ce218,
0xe348e30c,0xe2c3e324,0xe208e250,0xe2a1e22c,0xe373e316,0xe3f7e3bb,0xe4aae439,0xe60ae541,
0xe858e706,0xec3dea13,0xf161eeb7,0xf67bf407,0xfb00f8cb,0xff20fd18,0x03060118,0x071404f7,
0x0c17096a,0x12540f1f,0x190715a7,0x20b81caa,0x293724fd,0x30df2d33,0x368e340d,0x39b0386e,
0x3a273a3e,0x37753949,0x31e734e7,0x2a8c2e6b,0x2240266e,0x197f1df2,0x107814f3,0x07ee0c18,
0x0077040a,0xfaedfd61,0xf79bf90c,0xf54df65c,0xf406f48e,0xf376f3a4,0xf3bcf386,0xf3b8f3dc,
0xf247f33d,0xef4af0e1,0xec44edc7,0xe97cead1,0xe765e848,0xe72ee708,0xe8a8e7c2,0xeaa5e9aa,
0xebd8eb62,0xebb4ebf1,0xeb1beb5a,0xeb20eb07,0xebb5eb59,0xebf9ec03,0xeaf0eb92,0xe962ea33,
0xe7d4e890,0xe6bee73f,0xe5dbe639,0xe669e5d9,0xe992e7b3,0xee8febee,0xf2e3f0f3,0xf594f476,
0xf62cf615,0xf66cf63c,0xf683f68a,0xf5d3f645,0xf4bef544,0xf49ff489,0xf55bf4de,0xf6d3f608,
0xf8e2f7c0,0xfc07fa4e,0x010cfe41,0x0795043a,0x0e290ae3,0x148e1162,0x1aa317a4,0x20a41da1,
0x269a23ae,0x2b4e2929,0x2dfa2ce8,0x2eec2ea4,0x2e262ebd,0x2bdf2d37,0x28572a3d,0x23c62634,
0x1db020ee,0x16071a11,0x0cbe1193,0x02c507be,0xf943fde5,0xf148f50a,0xeb5cee12,0xe7ece94f,
0xe5bee6d0,0xe3d3e4ab,0xe34fe36b,0xe37ee359,0xe354e394,0xe1d2e2aa,0xe0abe10f,0xe0f9e0b0,
0xe191e14c,0xe264e1f1,0xe346e2d5,0xe488e3cc,0xe6b6e57b,0xeac4e877,0xf026ed6d,0xf511f2af,
0xf9a5f75d,0xfe00fbdc,0x023b001b,0x06d90474,0x0c83098d,0x12e30fac,0x197f1620,0x213b1d2b,
0x29a42578,0x30e72d89,0x35943399,0x37f13705,0x38153854,0x34f136f5,0x2fae3272,0x28b62c69,
0x212024f4,0x19171d2c,0x10ba14df,0x08c80cb9,0x017104fa,0xfbd1fe4e,0xf85af9e8,0xf5c7f6f2,
0xf44ff4ef,0xf3d4f3eb,0xf451f3fb,0xf4a4f492,0xf372f456,0xf093f211,0xedf7ef39,0xeb76ecb2,
0xe996ea4f,0xe996e96d,0xeae0ea15,0xec96ebc9,0xed42ed1c,0xecc2ed18,0xec11ec5b,0xec23ec0c,
0xecd2ec60,0xed16ed23,0xec2cecbc,0xea93eb6b,0xe8d8e9b0,0xe765e81a,0xe605e69c,0xe63fe5de,
0xe8f0e74b,0xed2ceafd,0xf0baef1e,0xf27af1e8,0xf26ef294,0xf253f244,0xf278f26f,0xf273f280,
0xf232f25b,0xf2b1f24f,0xf39df319,0xf4caf43a,0xf660f56b,0xf97cf7b0,0xfeb4fbd5,0x056001f0,
0x0c4908d8,0x12fe0fae,0x1928162c,0x1f6c1c2a,0x25ff22ca,0x2b1628ca,0x2e082cdd,0x2f082ebb,
0x2e332ed5,0x2bd92d31,0x289e2a50,0x24d226cd,0x1fe2228c,0x19521cd1,0x10d2154d,0x076f0c1f,
0xfe4202c0,0xf632fa06,0xefebf2cd,0xec38edc9,0xe979eadc,0xe6f7e824,0xe5b2e627,0xe526e568,
0xe425e4cb,0xe22be335,0xe096e13b,0xe072e05e,0xe0a1e086,0xe119e0da,0xe175e14d,0xe246e1c3,
0xe436e30a,0xe82fe5e9,0xed80ead4,0xf257f005,0xf72ef4b8,0xfc1df9a4,0x0115fe93,0x065e03a2,
0x0ca40963,0x1376100e,0x1a0d16bc,0x217a1d95,0x297b257d,0x304e2d27,0x347f32bd,0x36aa35c6,
0x369736ff,0x33673562,0x2eaa3124,0x282c2b9e,0x20ee2490,0x19621d39,0x11781569,0x09ae0d8c,
0x027005fb,0xfc8fff38,0xf890fa69,0xf588f6e7,0xf3fcf495,0xf38df39d,0xf429f3c6,0xf4a4f47f,
0xf3bef476,0xf140f299,0xeed5f004,0xecabedaf,0xeb51ebcc,0xebaeeb52,0xed4cec5e,0xef23ee4b,
0xeff6efb3,0xef97efe0,0xef08ef3e,0xeef5eeee,0xef96ef37,0xef9befc9,0xee74ef26,0xeca1ed9e,
0xea2eeb6f,0xe7a8e8f3,0xe565e662,0xe4dbe4de,0xe6c8e57e,0xea95e897,0xede5ec6d,0xef03eeb7,
0xeeb6ef01,0xee6aee70,0xeea2ee79,0xef1aeedc,0xef75ef4e,0xf024efba,0xf15cf0a5,0xf2dcf225,
0xf4bbf3ab,0xf7f0f61c,0xfd1cfa4a,0x03970042,0x0a7506fc,0x11640df9,0x17ad149e,0x1e461add,
0x252621c7,0x2a91281f,0x2d952c6a,0x2e8a2e47,0x2d942e47,0x2b362c86,0x288329da,0x25aa272a,
0x220723f9,0x1d061fc1,0x15d019b3,0x0d0f1183,0x043d08a3,0xfc41000e,0xf5c3f8ca,0xf13ff34b,
0xed5fef4e,0xea17eb94,0xe851e90d,0xe704e7ad,0xe50fe628,0xe2bae3db,0xe13de1d0,0xe0c6e0f3,
0xe0a1e0a0,0xe0a7e0ba,0xe040e06c,0xe094e04a,0xe256e133,0xe679e426,0xeb6ae8fe,0xf005edb9,
0xf4f4f272,0xfa2bf789,0xff8dfcd6,0x0553024f,0x0bd90886,0x122d0f15,0x187c153d,0x1f901bec,
0x26f42351,0x2d272a51,0x30a42f3f,0x32bc31c1,0x33233346,0x30fb3256,0x2d4d2f4d,0x27e42ac5,
0x217d24ca,0x1a911e06,0x1399171e,0x0c480ff5,0x055408b8,0xff6e022c,0xfb0afd19,0xf795f929,
0xf582f670,0xf4b9f4e3,0xf52ff4de,0xf5dff595,0xf4e0f5b1,0xf282f3b7,0xf01ef155,0xedaaeed7,
0xec18ecb8,0xec4eebfe,0xee00ecf5,0xf053ef31,0xf192f12b,0xf15bf18e,0xf0e0f120,0xf0b6f0ad,
0xf161f101,0xf166f195,0xf040f0f1,0xee4aef60,0xeb73ecf7,0xe851e9d9,0xe5abe6dd,0xe470e4d8,
0xe53be490,0xe7c4e654,0xea21e932,0xea7eea86,0xe9bcea26,0xe96fe976,0xe9eee999,0xeaeaea69,
0xec03eb73,0xed5deca0,0xeefcee2a,0xf076efbd,0xf261f141,0xf5e3f3e9,0xfb2df852,0x0206fe73,
0x099705c2,0x10ed0d5e,0x17711441,0x1e4d1abe,0x257021f4,0x2b322896,0x2e562d1d,0x2f442f06,
0x2e272ef4,0x2b7a2cf4,0x288929f5,0x25e32734,0x22f82481,0x1f3c2146,0x19c41cc0,0x1283164f,
0x0a5e0e77,0x0294065d,0xfbf8ff15,0xf6d2f949,0xf1d9f461,0xed86ef78,0xea9cebfa,0xe82ae95f,
0xe53be6ce,0xe231e3a8,0xe031e0ff,0xdf6adfb6,0xdf4bdf45,0xdf29df49,0xdec8deec,0xdf0adecf,
0xe086df8a,0xe46de238,0xe8eee6c2,0xed2deb01,0xf206ef7f,0xf798f4c0,0xfd51fa70,0x03730041,
0x0a9106f5,0x11410e0c,0x17be1465,0x1f1f1b57,0x268122e8,0x2c3129ae,0x2eac2dd5,0x2ffa2f45,
0x30bc30a3,0x2f61303b,0x2ccb2e48,0x27eb2aab,0x21e124f8,0x1b7a1eb2,0x15001843,0x0e8311c4,
0x07ba0b2d,0x01230448,0xfbfcfe69,0xf7def9c7,0xf517f65d,0xf3fef43a,0xf4a0f42f,0xf602f550,
0xf5d1f640,0xf3dcf4e8,0xf1b1f2ca,0xef0df061,0xed43edf5,0xed6ced15,0xef58ee34,0xf1e5f0a5,
0xf36ff2e3,0xf354f37d,0xf2aff30b,0xf28af274,0xf375f2f8,0xf3b2f3c1,0xf2caf35a,0xf0b4f1fa,
0xecd6eeed,0xe8a6eab2,0xe4eee6b9,0xe28de37b,0xe2a6e23b,0xe50ce3b7,0xe708e638,0xe725e76b,
0xe606e68e,0xe56de597,0xe628e5a8,0xe7b8e6d9,0xe9b1e8b4,0xeb9cea9f,0xed81eca2,0xef32ee5d,
0xf176f02c,0xf506f316,0xfa2af758,0x0109fd71,0x08b704de,0x0fd20c6a,0x163f1312,0x1d0f1989,
0x243120a3,0x2a032767,0x2d3a2bf1,0x2e372dfc,0x2d162de3,0x2ac32c05,0x2833296a,0x25f2270b,
0x23a924d7,0x20902247,0x1c1e1e84,0x163f195d,0x0f5412df,0x083e0bc0,0x01b104e1,0xfc05fece,
0xf647f928,0xf193f3b5,0xedfeefb2,0xea8fec56,0xe6bfe8a3,0xe36de4fa,0xe167e23a,0xe057e0cb,
0xdff2e012,0xdf85dfc3,0xdef8df3a,0xdee9ded6,0xe037df47,0xe3b6e1c8,0xe743e58c,0xeafce907,
0xef98ed2a,0xf539f24f,0xfb48f837,0x020dfe86,0x098d05d2,0x10660d12,0x174313b8,0x1eb61afc,
0x2580224b,0x2a1d282f,0x2ba82b26,0x2d1a2c3e,0x2ddb2dca,0x2cbc2d75,0x29fe2b97,0x257b27f6,
0x1fbf22b3,0x1a0c1cd8,0x143d1730,0x0e5f1158,0x084a0b63,0x021f0520,0xfd04ff78,0xf8c1fac9,
0xf565f6f1,0xf410f46b,0xf4aff423,0xf640f591,0xf5f6f65d,0xf480f544,0xf2bbf3b1,0xf064f185,
0xef1def98,0xef81ef11,0xf198f05e,0xf416f2ec,0xf566f4f1,0xf58df58d,0xf54ff573,0xf5dff565,
0xf72af68b,0xf785f789,0xf689f72a,0xf3c5f570,0xef0df18b,0xea11ec83,0xe577e7ad,0xe289e3c6,
0xe20ae1ea,0xe325e28a,0xe3bbe39c,0xe282e352,0xe105e1af,0xe06de085,0xe155e0c0,0xe364e240,
0xe5fae4aa,0xe8bee74d,0xeb51ea21,0xeda1ec79,0xf05eeee0,0xf3e0f206,0xf8ddf61e,0xffadfc14,
0x074d037a,0x0e770afb,0x150211c7,0x1bfa1865,0x231e1f9a,0x28c52644,0x2c0c2aad,0x2d342cdb,
0x2c442cf7,0x2a222b49,0x27fc28fd,0x26162706,0x24152523,0x218b22ef,0x1df21fe1,0x192f1bae,
0x13ab1680,0x0dc110c2,0x079e0aa7,0x01c104ba,0xfb63fe8c,0xf636f8a3,0xf1daf3fb,0xed70efba,
0xe8d3eb15,0xe4dfe6ba,0xe236e35b,0xe09ae151,0xdfa1e017,0xdea2df23,0xddd2de2b,0xdd8fdd9b,
0xdf01ddf7,0xe274e0a4,0xe5a8e41a,0xe913e744,0xed8eeb24,0xf348f056,0xf993f65a,0x00c4fd07,
0x087b04ab,0x0f8e0c10,0x17441340,0x1f6b1b68,0x263c2313,0x2a5928be,0x2baf2b2b,0x2d1f2c62,
0x2d262d75,0x2b302c5c,0x27a029a2,0x2267252a,0x1c9b1f7d,0x174719e5,0x123a14b7,0x0d4c0fc7,
0x07f20ab4,0x02b80538,0xfe2f0066,0xf9ddfbf8,0xf65df7eb,0xf509f572,0xf589f518,0xf64df60f,
0xf54ff605,0xf396f473,0xf1a6f2ae,0xefa5f08c,0xef22ef1c,0xf0a0efa9,0xf351f1e4,0xf60af4cc,
0xf78bf6fa,0xf828f7e3,0xf8a2f861,0xf9d8f91b,0xfb49faac,0xfb7bfb89,0xfa72fb28,0xf6f7f90c,
0xf192f460,0xebcaeeb3,0xe673e8f1,0xe316e46c,0xe2a6e299,0xe2d2e2c3,0xe1aee28e,0xdebae049,
0xdc1add50,0xdb66db78,0xdc4fdba8,0xde7edd3f,0xe180dffc,0xe4a7e313,0xe78de624,0xea9ee90a,
0xee22ec59,0xf208eff4,0xf759f472,0xfe3cfaaa,0x05b001f3,0x0cb30945,0x1370100c,0x1abf1708,
0x21f51e73,0x277624f9,0x2b122982,0x2cc62c2b,0x2c792cdb,0x2acb2bb4,0x28f229d5,0x27512820,
0x25702674,0x22ba2434,0x1f142105,0x1af71d09,0x171718ff,0x12e0151b,0x0dcd1070,0x07ae0ae2,
0x0123045e,0xfb71fe2b,0xf609f8c4,0xf01ef325,0xea62ed2a,0xe5c8e7da,0xe2c9e423,0xe0dce1ae,
0xdfb5e03a,0xdea4df30,0xdde0de30,0xdda6dda3,0xdf3ede28,0xe20be09e,0xe488e34e,0xe798e5ef,
0xebc8e985,0xf104ee4f,0xf743f3f3,0xff0bfb0a,0x06d20309,0x0e0f0a65,0x15f111f3,0x1d6519d5,
0x232a2088,0x261a251a,0x26cd2675,0x280e275d,0x28f8289d,0x288628fe,0x2602277b,0x217d2409,
0x1bf21eb1,0x170a1965,0x12c414d2,0x0ebe10ca,0x09d00c63,0x04bc0733,0x00710287,0xfc2dfe5b,
0xf886fa23,0xf6f5f771,0xf794f70f,0xf84af818,0xf799f815,0xf5fbf6e6,0xf395f4e0,0xf109f232,
0xf014f048,0xf150f072,0xf3f6f28c,0xf6d0f573,0xf8b1f7e9,0xf9acf93f,0xfa55f9fd,0xfbf6fb01,
0xfda3fce6,0xfe2ffe1f,0xfccbfdbf,0xf8d7fb24,0xf33af631,0xecc1f00d,0xe699e97d,0xe29ae44a,
0xe0f6e192,0xe01fe079,0xde8adf9d,0xdb68dd09,0xd8d6d9f6,0xd7fad81f,0xd906d853,0xdb65da10,
0xdebddcf9,0xe252e08b,0xe5c5e40e,0xe99ce79d,0xeda1eba6,0xf1a6ef9a,0xf6aef3f4,0xfd60f9e2,
0x049500f9,0x0b5e0809,0x11d10e91,0x191c155e,0x20561cdc,0x25e4235a,0x29a027fa,0x2b882ac9,
0x2bab2bd7,0x2a9d2b32,0x295029fe,0x27d5289b,0x25fb2700,0x232624a8,0x1f892171,0x1bd21d97,
0x18fb1a46,0x166117bf,0x12f014d2,0x0d5b106f,0x06c409fe,0x00de03d0,0xfadafddb,0xf463f7b7,
0xede2f109,0xe89deb0b,0xe4f4e6a7,0xe23de379,0xe04ae133,0xdea5df6c,0xdd96de0e,0xdd10dd38,
0xde56dd6b,0xe0aadf83,0xe2cee1c2,0xe55de3f4,0xe93de71f,0xee40eba1,0xf497f130,0xfd6af880,
0xf2b5f7f4,0xe9a1edf4,0xe239e5b3,0xdc6adf21,0xd885da36,0xd656d749,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};
