#include "Ocarina_samples.h"
const AudioSynthWavetable::sample_data Ocarina_samples[3] = {
	{
		(int16_t*)sample_0_Ocarina_OcarinaF4,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		12,	//Number of bits needed to hold length
		(1048576*1.0227829387472833*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 1318.5102276514797 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)2847-1) << (32 - 12),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)2839-1) << (32 - 12),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)2839-1) << (32 - 12)) - (((uint32_t)1438-1) << (32 - 12)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-170/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(7*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(1730*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(321*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(4288/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(14 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(4288/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_Ocarina_OcarinaF4,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		12,	//Number of bits needed to hold length
		(1048576*1.023373891996775*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 1318.5102276514797 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)2847-1) << (32 - 12),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)2839-1) << (32 - 12),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)2839-1) << (32 - 12)) - (((uint32_t)1438-1) << (32 - 12)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-100/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(7*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(1730*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(321*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(4288/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(14 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(4288/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_Ocarina_OcarinaF6,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		9,	//Number of bits needed to hold length
		(8388608*1.0*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 4434.922095629953 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)349-1) << (32 - 9),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)341-1) << (32 - 9),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)341-1) << (32 - 9)) - (((uint32_t)331-1) << (32 - 9)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-170/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(10*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(1730*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(321*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(4288/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(14 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(4288/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_Ocarina_OcarinaF4[1536] = {
0x016601b0,0x01550152,0x0180014c,0x019a01b7,0x025c01d8,0x030a02b4,0x026c02e9,0x01900220,
0x012300de,0x00db0106,0x01a7016e,0x0089011f,0x005a0012,0x005a0051,0x01ac00e3,0x01b60199,
0x00cd0155,0x016d0152,0x01e901c8,0x012f01aa,0x014a0190,0x01b00166,0x025e028b,0x02920268,
0x018b021a,0x012d00f6,0x01ac01b7,0x028e01f1,0x029502f2,0x01d201fb,0x01590215,0x00fa011a,
0x005a005f,0x00150008,0x00d400cb,0x014e0045,0xff980081,0x0034fffd,0x011c0035,0x030a027f,
0x02c8028f,0x0304032e,0x0401038d,0x037d033b,0x020c0309,0x01ff01e5,0x024001d6,0x01db02e7,
0x00eb017a,0xffadffd7,0xfebeff9a,0xff2fff7e,0xffd3ff0a,0xff37ff34,0xff1affcc,0xffd9ff98,
0xff25febf,0x01b3003b,0x03c8036f,0x045b03c4,0x03fe0494,0x040303fd,0x063004ee,0x056a0647,
0x02ae0463,0xfff50108,0xff46003c,0xfec2ffd5,0xfdcdfe9e,0xfc88fd7d,0xfd76fced,0xfc19fcab,
0xfd91fc7c,0xfe8dfe14,0x00f90050,0x02a8011d,0x049703e7,0x05a80512,0x076606e0,0x06a206b9,
0x08d90764,0x07b307e8,0x0511074f,0x010802bc,0xfc98fea5,0xfa63fb08,0xf949fa25,0xf808f8ba,
0xf862f81c,0xf94df81b,0xfbf0fa9c,0xfed0fdb2,0x02cb00c8,0x05a003ed,0x07d306ab,0x0c6b09d3,
0x0db90cf0,0x0f050ef3,0x0c0d0d5b,0x07fa0ab6,0x0265055b,0xfc94ff74,0xf76ef9ea,0xf565f5d8,
0xf0e9f318,0xf2c9f1f4,0xf176f117,0xf4b5f345,0xfb1cf770,0x037ffe19,0x09f00791,0x0cda0c59,
0x104f0db1,0x1544134a,0x15d115c7,0x1447161d,0x0cf41161,0x051e0896,0xfda00180,0xf5c1f9ce,
0xee96f18a,0xe99febd1,0xe7cfe875,0xe80ae716,0xec7dea2b,0xf456f14a,0xfdc9f7e8,0x0839027b,
0x14190e64,0x1c0d1795,0x1e3c1e78,0x1f641fe4,0x1d101e99,0x189d1afd,0x0d9913b0,0xff1b0582,
0xf23cf882,0xe511ead8,0xdccae00f,0xdad9dc22,0xdcfedb6f,0xe3c5e054,0xeba4e7d7,0xf978f148,
0x07a3ff07,0x1848104a,0x255f1f6c,0x2c5f29ea,0x2ca42d56,0x27262a30,0x20cf24a6,0x13be1a51,
0x04c20cba,0xf13ffba5,0xde84e720,0xd29dd774,0xce28cfdd,0xd123ce19,0xd7c8d3ce,0xe216dc56,
0xf28cea79,0x05c5fb83,0x1a84102c,0x2e7f25e3,0x3877345b,0x39ed39f2,0x34863802,0x29742f8d,
0x1b022242,0x094712e1,0xf1a0fe0b,0xdb1de610,0xc900d0cb,0xc223c438,0xc35fc221,0xcbcbc69d,
0xd913d2b6,0xec91e22f,0x0200f634,0x1d080f06,0x33fb29b5,0x41d63bda,0x452844df,0x3e9b42c2,
0x342739b0,0x26642e40,0x0ed91ae5,0xf2d30142,0xd6bbe3fe,0xc1e6ca9b,0xb770bb9a,0xb891b7a1,
0xc1a7bbd1,0xd04ac8a6,0xe530da66,0xff61f085,0x1bcf0d77,0x364d2a35,0x47b040b5,0x4d374b8e,
0x49974c86,0x3f28455e,0x2d0036f2,0x14442124,0xf7380671,0xd813e70a,0xbed4ca3c,0xb013b660,
0xaf44adfc,0xb8f2b30c,0xc7ffbf8a,0xdcecd22d,0xf75fe9dc,0x1701068b,0x365a276d,0x4ccf436f,
0x563752b4,0x53635634,0x46ff4dad,0x35393ea9,0x1cf92a72,0xfd130d57,0xd999eaf3,0xbbb9c997,
0xaabdb160,0xa811a7b6,0xaee4aa81,0xbff5b62b,0xd761cb8c,0xf1aee308,0x127901d3,0x33c823b0,
0x4d7041fc,0x5bb4566b,0x5b955d9d,0x5088571d,0x3c4046ba,0x234c307a,0x048a1515,0xdebef1fe,
0xbcdfcc63,0xa7c2b099,0xa0b1a275,0xa610a1ab,0xb580acd9,0xcd71c098,0xeb49dbf5,0x0dcafb96,
0x32182019,0x4ff3427b,0x5fa259ea,0x6202624a,0x578f5e86,0x44e34ef2,0x2ac93891,0x09671b39,
0xe202f5ea,0xbdb4cec3,0xa56aafe5,0x9bbd9ed5,0xa02a9c68,0xafd6a68c,0xc79dbae5,0xe40ad4f5,
0x06c3f49d,0x2e8c1b7d,0x4f18405d,0x61d55a40,0x65e1659f,0x5d386331,0x4b1a552f,0x303e3ee9,
0x0fe520d4,0xe957fd4a,0xc238d51f,0xa52cb220,0x988c9d35,0x9a8a97a2,0xa8aca0a3,0xc00db367,
0xde01ce48,0x025aef4c,0x295d15a0,0x4d613c75,0x634c5a2d,0x69d268ef,0x62256786,0x50655a74,
0x37b344c3,0x167528e3,0xee570344,0xc43ed839,0xa530b2d6,0x962d9ba2,0x9799952b,0xa3899c08,
0xb9d9add9,0xd6bac75d,0xfb87e8bf,0x26001024,0x4bd33a49,0x646059b8,0x6c906a65,0x66de6b77,
0x56205f9c,0x3dba4af6,0x1d272eb6,0xf1bd079c,0xc6cedb89,0xa5e1b4f6,0x95a69bb8,0x93b492e7,
0x9ea597cb,0xb4e5a8a0,0xd31dc346,0xf649e342,0x20aa0b6f,0x48c93573,0x63ba57e5,0x6e6d6b79,
0x6a6f6e46,0x5b2363fd,0x41484f0b,0x207a3207,0xf81d0c9b,0xcbf0e1d8,0xa918b885,0x94999cb9,
0x90af90e8,0x9b5f9497,0xb0c5a50b,0xcee7bea6,0xf24ae028,0x1ae605eb,0x444830e3,0x6152546c,
0x6ddb6a23,0x6be16e26,0x5dcf6634,0x462552f9,0x26fd3753,0xfc77133f,0xcfe5e5eb,0xab2ebc33,
0x95b19e32,0x906f90e7,0x98d59350,0xac3aa15e,0xc986b997,0xed20dac9,0x17820179,0x413f2cb2,
0x602152de,0x6eaf6994,0x6d306fd8,0x5f5467c4,0x48ea54af,0x2a733abf,0x0239175c,0xd5aeec56,
0xaea5c0f8,0x9694a09c,0x8f0b907d,0x96e6917e,0xa9f19f20,0xc62ab6d9,0xe823d690,0x111efb97,
0x3c652724,0x5d6d4ea3,0x6e3d67a5,0x6f31707d,0x62356acc,0x4c1b57da,0x2db23e72,0x06f01aeb,
0xdad2f108,0xb365c5c4,0x996da44f,0x8fa19241,0x94db90d3,0xa71a9c4e,0xc194b34d,0xe3e4d1e0,
0x0c43f76b,0x379622af,0x5a134a7d,0x6cb86560,0x6ec26f32,0x640c6b2b,0x4f465a67,0x31a9413b,
0x0d06210c,0xe050f756,0xb727cae5,0x9ae0a6ab,0x8fc99364,0x942e9027,0xa4839a4a,0xbe9bb07d,
0xdf91cf19,0x0712f285,0x321a1c58,0x5614458d,0x6b5b62cf,0x70656fc7,0x66946d57,0x514c5d0c,
0x33ad437d,0x11112386,0xe610fb8f,0xbb8ccfa4,0x9d2aaa9d,0x90e2949d,0x92a79031,0xa1e298e8,
0xbc4bae2d,0xddebcc95,0x015ceeb3,0x2b7f15f0,0x51173f67,0x69175ef2,0x6f766ec3,0x67e56dea,
0x54845f5e,0x3a77484a,0x1463283c,0xe98aff0a,0xbfb3d472,0xa17aaedc,0x918397b0,0x92769036,
0xa0d1984a,0xb92cabd3,0xd796c7b7,0xfc69e925,0x26e21184,0x4e193b68,0x673a5cfd,0x6e256cd4,
0x67f66c8b,0x55716037,0x3cf349b1,0x1b112d7b,0xf1250711,0xc671dadb,0xa445b3c4,0x92c19961,
0x92ba90f8,0x9fa797bc,0xb55fa95c,0xd426c3e0,0xf6dde532,0x20430a85,0x47ac34b6,0x62ea57b0,
0x6e406aee,0x69486d74,0x58096193,0x40f84d44,0x216a31f2,0xf7e00ddd,0xcbbce173,0xa7ddb7fc,
0x95a29c7c,0x92949223,0x9d3895f5,0xb231a6df,0xce62bfe4,0xf14ddef6,0x198c04ed,0x42df2e8e,
0x608f53a8,0x6e4769d6,0x6a796dd9,0x5a9863cc,0x433c501a,0x25783595,0xfe411355,0xd108e70c,
0xabeabca6,0x95ee9e9e,0x90db9178,0x9afa948f,0xaecaa38f,0xcb2cbccb,0xed21db59,0x151fffd1,
0x3f332ab0,0x5e855101,0x6d476832,0x6c086e1f,0x5e8e6721,0x47225433,0x281b3871,0x01d815ac,
0xd5f3ec46,0xaf17c196,0x96aaa0b4,0x900a9185,0x9875926a,0xacd4a1bc,0xc7b8b8f8,0xe91cd7d3,
0x1145fc9f,0x3a8e26c3,0x5c164d01,0x6cf3661a,0x6c706e9c,0x6000683d,0x497f55ac,0x2bdc3b77,
0x06211a72,0xda59f001,0xb322c5ba,0x994aa3fb,0x90939346,0x96b991e7,0xa8d69e06,0xc452b581,
0xe619d4e3,0x0d3cf8a7,0x36de21b1,0x58e949e1,0x6c0064a6,0x6d746ebe,0x62286947,0x4cae58a3,
0x2ecd3ef1,0x0ad11d0f,0xde89f502,0xb5d9c8fe,0x9b93a65f,0x911b9484,0x963091ec,0xa75a9d7b,
0xc0d6b2a1,0xe131d084,0x07c1f3f5,0x32751ca8,0x567145a9,0x6a65628a,0x6ee36eb0,0x64da6bac,
0x4f665b5b,0x33044277,0x0e2621af,0xe252f89c,0xb941ccd4,0x9c88a952,0x915994bc,0x93da90aa,
0xa3fc9a61,0xbde6afdd,0xddddcd22,0x0362efda,0x2f241942,0x53ca42c1,0x69876155,0x6f286e5e,
0x668f6c6d,0x52815ddb,0x351c447a,0x12992544,0xe7d0fd8f,0xbcfad151,0x9e67ab8a,0x90b995bf,
0x92ab8fc6,0xa1da98bf,0xbb4dadd1,0xdb18caaf,0x002bec39,0x2b19150e,0x518f402b,0x68c45efd,
0x6f566e2c,0x66f56ca6,0x52d05de3,0x37d54601,0x16e5287a,0xed1e02c8,0xc129d6a4,0xa035aebd,
0x909c95fa,0x91908f61,0xa0269771,0xb892ab61,0xd6f0c6e1,0xfb67e7ff,0x26961074,0x4ef23c0e,
0x68065dcf,0x70ae6e83,0x697b6ea4,0x572d6174,0x3ca44b16,0x19e22bd9,0xefb90589,0xc342d8a4,
0xa1d0b0c5,0x901696e2,0x8f9a8df8,0x9cb99491,0xb47ba75f,0xd430c31b,0xf898e5c1,0x24250d82,
0x4d743a1b,0x681e5cf2,0x71816f34,0x6b8f7018,0x594463da,0x3ee94d0f,0x1c8f2ead,0xf1d3087e,
0xc4d1daaf,0xa1b7b1ae,0x8fc3966c,0x8f098d47,0x9b719387,0xb308a620,0xd2d7c1d1,0xf6e5e472,
0x20410b05,0x4a453600,0x67295b20,0x72c06edb,0x6d8071ca,0x5ba1660e,0x40fe4f54,0x1e833105,
0xf57a0aa3,0xc829de70,0xa395b3fd,0x8f75975a,0x8d228c46,0x9859913b,0xb00da2e7,0xcea0be55,
0xf478e0d0,0x1f8108b9,0x489e3589,0x66855960,0x72a66e9d,0x6eec72fe,0x5f0268e4,0x43ff5206,
0x21cf33a5,0xf7840d82,0xc993e03c,0xa509b5d9,0x8f7d97f1,0x8bdc8bca,0x96c68fa4,0xad2ca076,
0xcd17bc08,0xf1fbdf4d,0x1c60063d,0x475c325b,0x66035943,0x739f6ecb,0x7022736f,0x5f5b693f,
0x45785322,0x24ff36e3,0xfb0d10b4,0xcd48e41c,0xa6e6b8a9,0x901e98ab,0x8ad48b90,0x94068dda,
0xaaa59dc3,0xca46b996,0xee47db4d,0x192e038f,0x444d2f5d,0x6408564e,0x73c96dcc,0x72227490,
0x62e96c6e,0x49e2578c,0x268d39b7,0xfedb131e,0xd02de7a5,0xa7eeba40,0x8f3c9993,0x88a48a28,
0x927d8ba5,0xa7779b7b,0xc60bb566,0xec3bd873,0x177a0118,0x42212d5e,0x62f154f6,0x73966d27,
0x7324753c,0x64986dc0,0x4a2758b4,0x2a723b2e,0x0248175e,0xd42feb86,0xab56be69,0x90869b39,
0x89308aed,0x914a8b6f,0xa4fe99db,0xc3bfb323,0xe7fed5a6,0x10d1fbba,0x3d362713,0x61b751ea,
0x74fe6d3c,0x75347778,0x67036fca,0x4ed05b9e,0x2e563fae,0x05841abb,0xd738ef34,0xacb8c061,
0x91609cc2,0x87d08a5d,0x8e1d88ed,0xa235967d,0xc010b059,0xe5abd1b5,0x0f43f9be,0x3a2b251f,
0x5fb14ed6,0x74526c70,0x765b77cd,0x696e71d6,0x4fe65d91,0x30f04148,0x09dd1e4d,0xdc65f403,
0xb03bc52f,0x91fd9f12,0x869689bc,0x8d2487fe,0xa12095b2,0xbe05ae41,0xe0d6cf41,0x09b4f3d7,
0x370820ec,0x5dc94c4c,0x73d16aad,0x77a577f7,0x6b8873b7,0x52885fbe,0x33a243ea,0x0e802194,
0xe024f825,0xb1d4c87e,0x92409feb,0x85108901,0x8a4f860b,0x9d47929d,0xbb42ab73,0xdf67cc78,
0x06d3f1fe,0x32f61d11,0x5bd748f2,0x74566aa1,0x79357944,0x6d847501,0x55ee62d5,0x36a0471b,
0x10fb2505,0xe299fad5,0xb479cad5,0x9354a1dd,0x84b08975,0x88ea84ed,0x9bb690b1,0xb82aa8cb,
0xdc38c950,0x03b6ef46,0x318d1ad2,0x5a754739,0x728b68f7,0x7a3e792d,0x70967700,0x5953666e,
0x39a04a54,0x11aa265e,0xe5b0fc6a,0xb627ccc4,0x93d7a34c,0x854289a0,0x8840848f,0x99008f27,
0xb53da5fa,0xd972c6da,0x0259ed51,0x2ee91813,0x58464509,0x72e36813,0x7a7f7908,0x70b37743,
0x5a1266f0,0x3c394bdc,0x16f82b0c,0xe8a10093,0xb9ded077,0x96bda654,0x853b8b6e,0x86768377,
0x97a28daa,0xb22ca3b3,0xd550c32c,0xfc2de7ce,0x2ae912e4,0x567e4230,0x725b669c,0x7bc17922,
0x73ed7999,0x5e5d6acc,0x3e614f43,0x196b2d25,0xec60040f,0xbd18d401,0x979da7e4,0x85448c08,
0x85298326,0x94ee8b27,0xaf48a0e7,0xd26dc06c,0xfa7be566,0x27af1063,0x53373e84,0x6fcd639c,
0x7b81785e,0x751b79da,0x602a6c30,0x42305213,0x1da730ba,0xf05808e8,0xbf97d748,0x9992ab33,
0x851f8cb5,0x838b8230,0x91b9892e,0xacc59ded,0xd03abddc,0xf7a5e348,0x24c10d16,0x50f43bdf,
0x6fd1628a,0x7bbb7811,0x75347ae6,0x61e76d77,0x43e5547b,0x1fe93347,0xf44f0a41,0xc47bdc45,
0x9bffae99,0x86de8f29,0x83e48303,0x917588e1,0xaa199c4c,0xcd88bb21,0xf4b9dfbf,0x20f20bec,
0x4bc436ea,0x6b535d6b,0x79db7549,0x75fc79d1,0x636b6e44,0x47a75677,0x227235d1,0xf9040f53,
0xc94ee163,0xa104b35f,0x89009323,0x84728409,0x8f7287ee,0xa79699e6,0xc8cbb7db,0xef38db5e,
0x1bdf0491,0x49bd33cf,0x6ad65c30,0x7a4e7484,0x77367a86,0x645e6f4e,0x492d579d,0x271938d1,
0xfcc0137e,0xcdf3e4f3,0xa3e6b770,0x8a7c94b2,0x83b284d8,0x8f01877c,0xa5959917,0xc5b7b561,
0xebc9d84e,0x17390037,0x443e2eb1,0x67885813,0x78d7722b,0x77bd7a6a,0x67b5715d,0x4c745b30,
0x2a0a3bda,0x007816ae,0xd1b3e84e,0xa769bb88,0x8bb8974b,0x844285dc,0x8dc686da,0xa39f9713,
0xc3d6b385,0xe92bd658,0x1361fd2a,0x40302a13,0x64495465,0x779b6fec,0x77d2798d,0x68fd7289,
0x4de45c6f,0x2b543de4,0x04811939,0xd655eca8,0xabb2bfb8,0x8e859a72,0x84b28787,0x8cf386bb,
0xa1a49592,0xc09bb0f4,0xe67fd2d8,0x0f80f9d6,0x3c2f2601,0x61035077,0x75456d3c,0x77fb7874,
0x6a377330,0x515d5f7e,0x2fc84136,0x07851c59,0xda25f10e,0xaf10c32f,0x91419db0,0x864789e4,
0x8cb287a0,0x9fbc9495,0xbda5ad7d,0xe27dcf43,0x0b6df5fb,0x38262208,0x5e354ce0,0x74df6bc3,
0x77c57823,0x6aaf732b,0x530d5fe6,0x3364450d,0x0cf22084,0xdee1f6c9,0xb1cbc702,0x92d09fbe,
0x85c98a21,0x8ba08657,0x9dbe931f,0xbabcac1f,0xde88cbe4,0x06b1f1d9,0x341f1d88,0x5bb7492d,
0x72a46955,0x77c1775d,0x6c827467,0x552861bc,0x36b04722,0x0fba23fe,0xe344fa42,0xb588cb5a,
0x950aa312,0x86ff8b98,0x8aee873b,0x9c549255,0xb8b8a9a7,0xdb47c987,0x02edee6f,0x2f3a184c,
0x574b448a,0x70af663c,0x771b75b1,0x6e1a74a0,0x59316524,0x3a264ad4,0x131f2781,0xe70dfd59,
0xba82d003,0x982ea80f,0x88c08e5d,0x88f18643,0x99379011,0xb567a5a5,0xd81cc642,0x0063eb64,
0x2b1b1538,0x545f411b,0x6f1e63d2,0x778675a1,0x6fc27596,0x5a8366c3,0x3c4c4bf5,0x18ae2b8d,
0xec180323,0xbda4d43b,0x9a38a9e9,0x88558e86,0x891b86c4,0x97898f21,0xb1d4a31e,0xd408c217,
0xfb62e74e,0x26fd10a2,0x522c3de5,0x6de8626d,0x78227552,0x70e67647,0x5d4b68a7,0x3fe84f1b,
0x1b002e7a,0xef310636,0xc0c4d7ab,0x9ba6ac0f,0x89098fc1,0x879b8679,0x95db8d3a,0xb055a1ba,
0xd1dbc074,0xf8f3e4f9,0x23e40e53,0x4eb139cb,0x6c025f39,0x77ba7499,0x71aa764f,0x5f376a22,
0x429351b4,0x1f5631bc,0xf24409f3,0xc3b8da5a,0x9f2fafd7,0x89c4920f,0x86e68654,0x94f68c77,
0xae119fb0,0xced3bdfa,0xf4d9e187,0x1fcc0950,0x4ae43636,0x69a85c54,0x776f72d2,0x732a76df,
0x605c6b7a,0x44a052c3,0x22963458,0xf8e40f4f,0xca3ee1d8,0xa194b434,0x8a3492ae,0x85ef8689,
0x932d8ab8,0xab529d7c,0xcb2bba85,0xefb2dd42,0x1be00512,0x470a3182,0x67d159a9,0x77a47211,
0x751177f6,0x636d6e22,0x47e9569b,0x245f36ce,0xfd1211a1,0xcf7be6d2,0xa641b95a,0x8cb29723,
0x859a86e6,0x90588939,0xa7b29a73,0xc792b735,0xed39d9bf,0x163d00ce,0x41eb2c88,0x6477553f,
0x767b7013,0x75f977ee,0x66346fc8,0x4b34599d,0x29823ae8,0x012416c6,0xd362ea50,0xa9d8bd28,
0x8e9099dc,0x85d68843,0x8dd78830,0xa4729744,0xc3f1b2ba,0xe8e6d660,0x1194fc12,0x3dfb28a1,
0x61d551cc,0x757f6e0e,0x75b277d0,0x6817706f,0x4f585ca0,0x2e2d3fa6,0x07391be7,0xd78befc8,
0xac3ac077,0x8fde9b88,0x86158879,0x8da487c0,0xa33d9706,0xc06cb120,0xe423d235,0x0d43f779,
0x393a22fa,0x5e014d08,0x73f16bc7,0x7754778a,0x6b057344,0x51ce6012,0x311e4201,0x0ac21ef2,
0xdc36f3c6,0xb088c579,0x920c9ecd,0x857a895e,0x8b9386df,0xa0229483,0xbdc2ad3c,0xe10ccf4d,
0x09acf4f0,0x358e1f72,0x5ba14a97,0x721c68fd,0x77607709,0x6be17341,0x5463615f,0x341144cd,
0x0f0b22c3,0xe218f9e1,0xb4a6ca20,0x93b1a24b,0x86648a6b,0x8a8b866a,0x9d109245,0xba74aada,
0xdd05cb37,0x0465f05e,0x3110198d,0x595246fb,0x72956853,0x783d7789,0x6d8974e0,0x56fb63de,
0x387d486f,0x120b2690,0xe54cfc12,0xb7f8ccf2,0x95f1a563,0x87308c48,0x88f585c7,0x9ab99058,
0xb761a7e6,0xd9c0c7fd,0x0127ec7b,0x2d9b1783,0x55204268,0x6ff36484,0x777e7620,0x6f5d75dc,
0x598965e9,0x39d34a00,0x15b528c3,0xeaa700ea,0xbd4cd44d,0x9939a965,0x87118e1e,0x886184ef,
0x98a38f0c,0xb4daa5c3,0xd70ac560,0xfb67e889,0x28a81240,0x53833e54,0x6fa36393,0x785f768a,
0x70f97672,0x5c1867f0,0x3d894d8f,0x19df2cc5,0xee4705ce,0xbe74d5df,0x99a4aa4a,0x879f8e6b,
0x886185b9,0x97648e1e,0xb16da375,0xd308c1a2,0xf97fe579,0x24b10e15,0x513a3c4a,0x6e996225,
0x78907661,0x71e976cc,0x5df0690b,0x404b5081,0x1bfd2f6e,0xf1ab0749,0xc3e0da67,0x9cd2aeda,
0x88b09063,0x8677854b,0x949c8bf2,0xae7ca08e,0xd06ebe9c,0xf71be2eb,0x22f40ca2,0x4e1538ef,
0x6d0b5f4d,0x789b7538,0x72d8782b,0x60666afe,0x444a5332,0x20093314,0xf4160bb5,0xc48cdbd2,
0x9e4faf65,0x88589102,0x859f84db,0x92f68a89,0xac369de2,0xcd75bbf1,0xf3c7e0f1,0x1fff087e,
0x4bb33673,0x6b7e5e2a,0x78b4747b,0x74ff78cc,0x62f36da3,0x466455ec,0x21ec3578,0xf7900d4e,
0xc845dfd8,0xa075b283,0x89509283,0x84df84f7,0x912a8921,0xaa049c19,0xcaa8b9a0,0xf10bddb2,
0x1ca7058d,0x494d33cc,0x698f5be3,0x78d173b5,0x7593790f,0x64116e79,0x472956b5,0x253a3673,
0xfb8211bb,0xcbb4e3c5,0xa36cb5e3,0x8a959483,0x850d85ee,0x8fb4887a,0xa80e9a05,0xc82db73a,
0xed66dafd,0x18f80217,0x46272fc3,0x685d5920,0x7945736a,0x76b97992,0x65a96fe1,0x49e4589d,
0x284e3aab,0xff4f1477,0xd012e80f,0xa613b97f,0x8b93965b,0x83558520,0x8def86c1,0xa56e9846,
0xc652b523,0xeab0d89c,0x1476fe84,0x417a2c00,0x65c75618,0x77d87115,0x77c379b3,0x685571ac,
0x4d035b46,0x2b003d1b,0x02341782,0xd45eebfc,0xa944bdc0,0x8d3d98ad,0x83e0865b,0x8d40867c,
0xa3a99694,0xc212b285,0xe774d471,0x1096fb7a,0x3d8426f9,0x63595271,0x777f6ff7,0x77e47a36,
0x694c7232,0x4f9e5dd2,0x2e533f5e,0x05e51b6c,0xd70eeecb,0xab87c054,0x8e9c9b03,0x84b18789,
0x8c35868a,0xa08d945a,0xbfbbaefd,0xe4e3d1f1,0x0d69f8e3,0x3b2923bd,0x61b7506d,0x771a6ec9,
0x78c17a0e,0x6b2c738b,0x52216013,0x30a54221,0x08c31d68,0xdb85f370,0xae11c34a,0x8f089cc8,
0x842f876a,0x8b3885ae,0x9ed0939a,0xbc5aaca0,0xe1a6ce53,0x0b30f511,0x38c221cd,0x5f874dd5,
0x76046d69,0x79627988,0x6d3e759b,0x54806215,0x346d450c,0x0cef21a4,0xddf4f5d1,0xb01ec5f3,
0x90979e63,0x84ac87c3,0x89928592,0x9cb69180,0xba06aa3e,0xdfa7cc76,0x08d3f310,0x34571e94,
0x5be949a1,0x74126a2c,0x797d792b,0x6df075e2,0x571763d8,0x364f47d1,0x0f2323c3,0xe11ef82c,
0xb5e1cac6,0x941ea30f,0x848c89e8,0x87e883a3,0x9af18fa2,0xb88fa8f9,0xdd6acaa0,0x0431f07d,
0x30bc19b0,0x59164737,0x733d684b,0x7923787c,0x6f8e75e0,0x589e6590,0x384e48ff,0x118c2558,
0xe4a0fba3,0xb8a3cdf0,0x969ca5a4,0x86468c3d,0x88768540,0x99e78f52,0xb691a738,0xda70c7ea,
0x00daed3f,0x2cb716c1,0x54f141bf,0x711c6542,0x79c57813,0x702576dd,0x59a7665e,0x39d54a93,
0x149e27a1,0xea8d0134,0xbd73d349,0x9908a958,0x871f8e1a,0x87f984bd,0x98398e77,0xb47fa51d,
0xd6c9c51c,0xfcfdea18,0x297e12b7,0x53183ea6,0x6f9963b1,0x798776d1,0x70d276e7,0x5b656768,
0x3cd24d09,0x1a392cae,0xed4d0437,0xc070d674,0x9a7dabc4,0x86218eca,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_Ocarina_OcarinaF4[1536] = {
0x016601b0,0x01550152,0x0180014c,0x019a01b7,0x025c01d8,0x030a02b4,0x026c02e9,0x01900220,
0x012300de,0x00db0106,0x01a7016e,0x0089011f,0x005a0012,0x005a0051,0x01ac00e3,0x01b60199,
0x00cd0155,0x016d0152,0x01e901c8,0x012f01aa,0x014a0190,0x01b00166,0x025e028b,0x02920268,
0x018b021a,0x012d00f6,0x01ac01b7,0x028e01f1,0x029502f2,0x01d201fb,0x01590215,0x00fa011a,
0x005a005f,0x00150008,0x00d400cb,0x014e0045,0xff980081,0x0034fffd,0x011c0035,0x030a027f,
0x02c8028f,0x0304032e,0x0401038d,0x037d033b,0x020c0309,0x01ff01e5,0x024001d6,0x01db02e7,
0x00eb017a,0xffadffd7,0xfebeff9a,0xff2fff7e,0xffd3ff0a,0xff37ff34,0xff1affcc,0xffd9ff98,
0xff25febf,0x01b3003b,0x03c8036f,0x045b03c4,0x03fe0494,0x040303fd,0x063004ee,0x056a0647,
0x02ae0463,0xfff50108,0xff46003c,0xfec2ffd5,0xfdcdfe9e,0xfc88fd7d,0xfd76fced,0xfc19fcab,
0xfd91fc7c,0xfe8dfe14,0x00f90050,0x02a8011d,0x049703e7,0x05a80512,0x076606e0,0x06a206b9,
0x08d90764,0x07b307e8,0x0511074f,0x010802bc,0xfc98fea5,0xfa63fb08,0xf949fa25,0xf808f8ba,
0xf862f81c,0xf94df81b,0xfbf0fa9c,0xfed0fdb2,0x02cb00c8,0x05a003ed,0x07d306ab,0x0c6b09d3,
0x0db90cf0,0x0f050ef3,0x0c0d0d5b,0x07fa0ab6,0x0265055b,0xfc94ff74,0xf76ef9ea,0xf565f5d8,
0xf0e9f318,0xf2c9f1f4,0xf176f117,0xf4b5f345,0xfb1cf770,0x037ffe19,0x09f00791,0x0cda0c59,
0x104f0db1,0x1544134a,0x15d115c7,0x1447161d,0x0cf41161,0x051e0896,0xfda00180,0xf5c1f9ce,
0xee96f18a,0xe99febd1,0xe7cfe875,0xe80ae716,0xec7dea2b,0xf456f14a,0xfdc9f7e8,0x0839027b,
0x14190e64,0x1c0d1795,0x1e3c1e78,0x1f641fe4,0x1d101e99,0x189d1afd,0x0d9913b0,0xff1b0582,
0xf23cf882,0xe511ead8,0xdccae00f,0xdad9dc22,0xdcfedb6f,0xe3c5e054,0xeba4e7d7,0xf978f148,
0x07a3ff07,0x1848104a,0x255f1f6c,0x2c5f29ea,0x2ca42d56,0x27262a30,0x20cf24a6,0x13be1a51,
0x04c20cba,0xf13ffba5,0xde84e720,0xd29dd774,0xce28cfdd,0xd123ce19,0xd7c8d3ce,0xe216dc56,
0xf28cea79,0x05c5fb83,0x1a84102c,0x2e7f25e3,0x3877345b,0x39ed39f2,0x34863802,0x29742f8d,
0x1b022242,0x094712e1,0xf1a0fe0b,0xdb1de610,0xc900d0cb,0xc223c438,0xc35fc221,0xcbcbc69d,
0xd913d2b6,0xec91e22f,0x0200f634,0x1d080f06,0x33fb29b5,0x41d63bda,0x452844df,0x3e9b42c2,
0x342739b0,0x26642e40,0x0ed91ae5,0xf2d30142,0xd6bbe3fe,0xc1e6ca9b,0xb770bb9a,0xb891b7a1,
0xc1a7bbd1,0xd04ac8a6,0xe530da66,0xff61f085,0x1bcf0d77,0x364d2a35,0x47b040b5,0x4d374b8e,
0x49974c86,0x3f28455e,0x2d0036f2,0x14442124,0xf7380671,0xd813e70a,0xbed4ca3c,0xb013b660,
0xaf44adfc,0xb8f2b30c,0xc7ffbf8a,0xdcecd22d,0xf75fe9dc,0x1701068b,0x365a276d,0x4ccf436f,
0x563752b4,0x53635634,0x46ff4dad,0x35393ea9,0x1cf92a72,0xfd130d57,0xd999eaf3,0xbbb9c997,
0xaabdb160,0xa811a7b6,0xaee4aa81,0xbff5b62b,0xd761cb8c,0xf1aee308,0x127901d3,0x33c823b0,
0x4d7041fc,0x5bb4566b,0x5b955d9d,0x5088571d,0x3c4046ba,0x234c307a,0x048a1515,0xdebef1fe,
0xbcdfcc63,0xa7c2b099,0xa0b1a275,0xa610a1ab,0xb580acd9,0xcd71c098,0xeb49dbf5,0x0dcafb96,
0x32182019,0x4ff3427b,0x5fa259ea,0x6202624a,0x578f5e86,0x44e34ef2,0x2ac93891,0x09671b39,
0xe202f5ea,0xbdb4cec3,0xa56aafe5,0x9bbd9ed5,0xa02a9c68,0xafd6a68c,0xc79dbae5,0xe40ad4f5,
0x06c3f49d,0x2e8c1b7d,0x4f18405d,0x61d55a40,0x65e1659f,0x5d386331,0x4b1a552f,0x303e3ee9,
0x0fe520d4,0xe957fd4a,0xc238d51f,0xa52cb220,0x988c9d35,0x9a8a97a2,0xa8aca0a3,0xc00db367,
0xde01ce48,0x025aef4c,0x295d15a0,0x4d613c75,0x634c5a2d,0x69d268ef,0x62256786,0x50655a74,
0x37b344c3,0x167528e3,0xee570344,0xc43ed839,0xa530b2d6,0x962d9ba2,0x9799952b,0xa3899c08,
0xb9d9add9,0xd6bac75d,0xfb87e8bf,0x26001024,0x4bd33a49,0x646059b8,0x6c906a65,0x66de6b77,
0x56205f9c,0x3dba4af6,0x1d272eb6,0xf1bd079c,0xc6cedb89,0xa5e1b4f6,0x95a69bb8,0x93b492e7,
0x9ea597cb,0xb4e5a8a0,0xd31dc346,0xf649e342,0x20aa0b6f,0x48c93573,0x63ba57e5,0x6e6d6b79,
0x6a6f6e46,0x5b2363fd,0x41484f0b,0x207a3207,0xf81d0c9b,0xcbf0e1d8,0xa918b885,0x94999cb9,
0x90af90e8,0x9b5f9497,0xb0c5a50b,0xcee7bea6,0xf24ae028,0x1ae605eb,0x444830e3,0x6152546c,
0x6ddb6a23,0x6be16e26,0x5dcf6634,0x462552f9,0x26fd3753,0xfc77133f,0xcfe5e5eb,0xab2ebc33,
0x95b19e32,0x906f90e7,0x98d59350,0xac3aa15e,0xc986b997,0xed20dac9,0x17820179,0x413f2cb2,
0x602152de,0x6eaf6994,0x6d306fd8,0x5f5467c4,0x48ea54af,0x2a733abf,0x0239175c,0xd5aeec56,
0xaea5c0f8,0x9694a09c,0x8f0b907d,0x96e6917e,0xa9f19f20,0xc62ab6d9,0xe823d690,0x111efb97,
0x3c652724,0x5d6d4ea3,0x6e3d67a5,0x6f31707d,0x62356acc,0x4c1b57da,0x2db23e72,0x06f01aeb,
0xdad2f108,0xb365c5c4,0x996da44f,0x8fa19241,0x94db90d3,0xa71a9c4e,0xc194b34d,0xe3e4d1e0,
0x0c43f76b,0x379622af,0x5a134a7d,0x6cb86560,0x6ec26f32,0x640c6b2b,0x4f465a67,0x31a9413b,
0x0d06210c,0xe050f756,0xb727cae5,0x9ae0a6ab,0x8fc99364,0x942e9027,0xa4839a4a,0xbe9bb07d,
0xdf91cf19,0x0712f285,0x321a1c58,0x5614458d,0x6b5b62cf,0x70656fc7,0x66946d57,0x514c5d0c,
0x33ad437d,0x11112386,0xe610fb8f,0xbb8ccfa4,0x9d2aaa9d,0x90e2949d,0x92a79031,0xa1e298e8,
0xbc4bae2d,0xddebcc95,0x015ceeb3,0x2b7f15f0,0x51173f67,0x69175ef2,0x6f766ec3,0x67e56dea,
0x54845f5e,0x3a77484a,0x1463283c,0xe98aff0a,0xbfb3d472,0xa17aaedc,0x918397b0,0x92769036,
0xa0d1984a,0xb92cabd3,0xd796c7b7,0xfc69e925,0x26e21184,0x4e193b68,0x673a5cfd,0x6e256cd4,
0x67f66c8b,0x55716037,0x3cf349b1,0x1b112d7b,0xf1250711,0xc671dadb,0xa445b3c4,0x92c19961,
0x92ba90f8,0x9fa797bc,0xb55fa95c,0xd426c3e0,0xf6dde532,0x20430a85,0x47ac34b6,0x62ea57b0,
0x6e406aee,0x69486d74,0x58096193,0x40f84d44,0x216a31f2,0xf7e00ddd,0xcbbce173,0xa7ddb7fc,
0x95a29c7c,0x92949223,0x9d3895f5,0xb231a6df,0xce62bfe4,0xf14ddef6,0x198c04ed,0x42df2e8e,
0x608f53a8,0x6e4769d6,0x6a796dd9,0x5a9863cc,0x433c501a,0x25783595,0xfe411355,0xd108e70c,
0xabeabca6,0x95ee9e9e,0x90db9178,0x9afa948f,0xaecaa38f,0xcb2cbccb,0xed21db59,0x151fffd1,
0x3f332ab0,0x5e855101,0x6d476832,0x6c086e1f,0x5e8e6721,0x47225433,0x281b3871,0x01d815ac,
0xd5f3ec46,0xaf17c196,0x96aaa0b4,0x900a9185,0x9875926a,0xacd4a1bc,0xc7b8b8f8,0xe91cd7d3,
0x1145fc9f,0x3a8e26c3,0x5c164d01,0x6cf3661a,0x6c706e9c,0x6000683d,0x497f55ac,0x2bdc3b77,
0x06211a72,0xda59f001,0xb322c5ba,0x994aa3fb,0x90939346,0x96b991e7,0xa8d69e06,0xc452b581,
0xe619d4e3,0x0d3cf8a7,0x36de21b1,0x58e949e1,0x6c0064a6,0x6d746ebe,0x62286947,0x4cae58a3,
0x2ecd3ef1,0x0ad11d0f,0xde89f502,0xb5d9c8fe,0x9b93a65f,0x911b9484,0x963091ec,0xa75a9d7b,
0xc0d6b2a1,0xe131d084,0x07c1f3f5,0x32751ca8,0x567145a9,0x6a65628a,0x6ee36eb0,0x64da6bac,
0x4f665b5b,0x33044277,0x0e2621af,0xe252f89c,0xb941ccd4,0x9c88a952,0x915994bc,0x93da90aa,
0xa3fc9a61,0xbde6afdd,0xddddcd22,0x0362efda,0x2f241942,0x53ca42c1,0x69876155,0x6f286e5e,
0x668f6c6d,0x52815ddb,0x351c447a,0x12992544,0xe7d0fd8f,0xbcfad151,0x9e67ab8a,0x90b995bf,
0x92ab8fc6,0xa1da98bf,0xbb4dadd1,0xdb18caaf,0x002bec39,0x2b19150e,0x518f402b,0x68c45efd,
0x6f566e2c,0x66f56ca6,0x52d05de3,0x37d54601,0x16e5287a,0xed1e02c8,0xc129d6a4,0xa035aebd,
0x909c95fa,0x91908f61,0xa0269771,0xb892ab61,0xd6f0c6e1,0xfb67e7ff,0x26961074,0x4ef23c0e,
0x68065dcf,0x70ae6e83,0x697b6ea4,0x572d6174,0x3ca44b16,0x19e22bd9,0xefb90589,0xc342d8a4,
0xa1d0b0c5,0x901696e2,0x8f9a8df8,0x9cb99491,0xb47ba75f,0xd430c31b,0xf898e5c1,0x24250d82,
0x4d743a1b,0x681e5cf2,0x71816f34,0x6b8f7018,0x594463da,0x3ee94d0f,0x1c8f2ead,0xf1d3087e,
0xc4d1daaf,0xa1b7b1ae,0x8fc3966c,0x8f098d47,0x9b719387,0xb308a620,0xd2d7c1d1,0xf6e5e472,
0x20410b05,0x4a453600,0x67295b20,0x72c06edb,0x6d8071ca,0x5ba1660e,0x40fe4f54,0x1e833105,
0xf57a0aa3,0xc829de70,0xa395b3fd,0x8f75975a,0x8d228c46,0x9859913b,0xb00da2e7,0xcea0be55,
0xf478e0d0,0x1f8108b9,0x489e3589,0x66855960,0x72a66e9d,0x6eec72fe,0x5f0268e4,0x43ff5206,
0x21cf33a5,0xf7840d82,0xc993e03c,0xa509b5d9,0x8f7d97f1,0x8bdc8bca,0x96c68fa4,0xad2ca076,
0xcd17bc08,0xf1fbdf4d,0x1c60063d,0x475c325b,0x66035943,0x739f6ecb,0x7022736f,0x5f5b693f,
0x45785322,0x24ff36e3,0xfb0d10b4,0xcd48e41c,0xa6e6b8a9,0x901e98ab,0x8ad48b90,0x94068dda,
0xaaa59dc3,0xca46b996,0xee47db4d,0x192e038f,0x444d2f5d,0x6408564e,0x73c96dcc,0x72227490,
0x62e96c6e,0x49e2578c,0x268d39b7,0xfedb131e,0xd02de7a5,0xa7eeba40,0x8f3c9993,0x88a48a28,
0x927d8ba5,0xa7779b7b,0xc60bb566,0xec3bd873,0x177a0118,0x42212d5e,0x62f154f6,0x73966d27,
0x7324753c,0x64986dc0,0x4a2758b4,0x2a723b2e,0x0248175e,0xd42feb86,0xab56be69,0x90869b39,
0x89308aed,0x914a8b6f,0xa4fe99db,0xc3bfb323,0xe7fed5a6,0x10d1fbba,0x3d362713,0x61b751ea,
0x74fe6d3c,0x75347778,0x67036fca,0x4ed05b9e,0x2e563fae,0x05841abb,0xd738ef34,0xacb8c061,
0x91609cc2,0x87d08a5d,0x8e1d88ed,0xa235967d,0xc010b059,0xe5abd1b5,0x0f43f9be,0x3a2b251f,
0x5fb14ed6,0x74526c70,0x765b77cd,0x696e71d6,0x4fe65d91,0x30f04148,0x09dd1e4d,0xdc65f403,
0xb03bc52f,0x91fd9f12,0x869689bc,0x8d2487fe,0xa12095b2,0xbe05ae41,0xe0d6cf41,0x09b4f3d7,
0x370820ec,0x5dc94c4c,0x73d16aad,0x77a577f7,0x6b8873b7,0x52885fbe,0x33a243ea,0x0e802194,
0xe024f825,0xb1d4c87e,0x92409feb,0x85108901,0x8a4f860b,0x9d47929d,0xbb42ab73,0xdf67cc78,
0x06d3f1fe,0x32f61d11,0x5bd748f2,0x74566aa1,0x79357944,0x6d847501,0x55ee62d5,0x36a0471b,
0x10fb2505,0xe299fad5,0xb479cad5,0x9354a1dd,0x84b08975,0x88ea84ed,0x9bb690b1,0xb82aa8cb,
0xdc38c950,0x03b6ef46,0x318d1ad2,0x5a754739,0x728b68f7,0x7a3e792d,0x70967700,0x5953666e,
0x39a04a54,0x11aa265e,0xe5b0fc6a,0xb627ccc4,0x93d7a34c,0x854289a0,0x8840848f,0x99008f27,
0xb53da5fa,0xd972c6da,0x0259ed51,0x2ee91813,0x58464509,0x72e36813,0x7a7f7908,0x70b37743,
0x5a1266f0,0x3c394bdc,0x16f82b0c,0xe8a10093,0xb9ded077,0x96bda654,0x853b8b6e,0x86768377,
0x97a28daa,0xb22ca3b3,0xd550c32c,0xfc2de7ce,0x2ae912e4,0x567e4230,0x725b669c,0x7bc17922,
0x73ed7999,0x5e5d6acc,0x3e614f43,0x196b2d25,0xec60040f,0xbd18d401,0x979da7e4,0x85448c08,
0x85298326,0x94ee8b27,0xaf48a0e7,0xd26dc06c,0xfa7be566,0x27af1063,0x53373e84,0x6fcd639c,
0x7b81785e,0x751b79da,0x602a6c30,0x42305213,0x1da730ba,0xf05808e8,0xbf97d748,0x9992ab33,
0x851f8cb5,0x838b8230,0x91b9892e,0xacc59ded,0xd03abddc,0xf7a5e348,0x24c10d16,0x50f43bdf,
0x6fd1628a,0x7bbb7811,0x75347ae6,0x61e76d77,0x43e5547b,0x1fe93347,0xf44f0a41,0xc47bdc45,
0x9bffae99,0x86de8f29,0x83e48303,0x917588e1,0xaa199c4c,0xcd88bb21,0xf4b9dfbf,0x20f20bec,
0x4bc436ea,0x6b535d6b,0x79db7549,0x75fc79d1,0x636b6e44,0x47a75677,0x227235d1,0xf9040f53,
0xc94ee163,0xa104b35f,0x89009323,0x84728409,0x8f7287ee,0xa79699e6,0xc8cbb7db,0xef38db5e,
0x1bdf0491,0x49bd33cf,0x6ad65c30,0x7a4e7484,0x77367a86,0x645e6f4e,0x492d579d,0x271938d1,
0xfcc0137e,0xcdf3e4f3,0xa3e6b770,0x8a7c94b2,0x83b284d8,0x8f01877c,0xa5959917,0xc5b7b561,
0xebc9d84e,0x17390037,0x443e2eb1,0x67885813,0x78d7722b,0x77bd7a6a,0x67b5715d,0x4c745b30,
0x2a0a3bda,0x007816ae,0xd1b3e84e,0xa769bb88,0x8bb8974b,0x844285dc,0x8dc686da,0xa39f9713,
0xc3d6b385,0xe92bd658,0x1361fd2a,0x40302a13,0x64495465,0x779b6fec,0x77d2798d,0x68fd7289,
0x4de45c6f,0x2b543de4,0x04811939,0xd655eca8,0xabb2bfb8,0x8e859a72,0x84b28787,0x8cf386bb,
0xa1a49592,0xc09bb0f4,0xe67fd2d8,0x0f80f9d6,0x3c2f2601,0x61035077,0x75456d3c,0x77fb7874,
0x6a377330,0x515d5f7e,0x2fc84136,0x07851c59,0xda25f10e,0xaf10c32f,0x91419db0,0x864789e4,
0x8cb287a0,0x9fbc9495,0xbda5ad7d,0xe27dcf43,0x0b6df5fb,0x38262208,0x5e354ce0,0x74df6bc3,
0x77c57823,0x6aaf732b,0x530d5fe6,0x3364450d,0x0cf22084,0xdee1f6c9,0xb1cbc702,0x92d09fbe,
0x85c98a21,0x8ba08657,0x9dbe931f,0xbabcac1f,0xde88cbe4,0x06b1f1d9,0x341f1d88,0x5bb7492d,
0x72a46955,0x77c1775d,0x6c827467,0x552861bc,0x36b04722,0x0fba23fe,0xe344fa42,0xb588cb5a,
0x950aa312,0x86ff8b98,0x8aee873b,0x9c549255,0xb8b8a9a7,0xdb47c987,0x02edee6f,0x2f3a184c,
0x574b448a,0x70af663c,0x771b75b1,0x6e1a74a0,0x59316524,0x3a264ad4,0x131f2781,0xe70dfd59,
0xba82d003,0x982ea80f,0x88c08e5d,0x88f18643,0x99379011,0xb567a5a5,0xd81cc642,0x0063eb64,
0x2b1b1538,0x545f411b,0x6f1e63d2,0x778675a1,0x6fc27596,0x5a8366c3,0x3c4c4bf5,0x18ae2b8d,
0xec180323,0xbda4d43b,0x9a38a9e9,0x88558e86,0x891b86c4,0x97898f21,0xb1d4a31e,0xd408c217,
0xfb62e74e,0x26fd10a2,0x522c3de5,0x6de8626d,0x78227552,0x70e67647,0x5d4b68a7,0x3fe84f1b,
0x1b002e7a,0xef310636,0xc0c4d7ab,0x9ba6ac0f,0x89098fc1,0x879b8679,0x95db8d3a,0xb055a1ba,
0xd1dbc074,0xf8f3e4f9,0x23e40e53,0x4eb139cb,0x6c025f39,0x77ba7499,0x71aa764f,0x5f376a22,
0x429351b4,0x1f5631bc,0xf24409f3,0xc3b8da5a,0x9f2fafd7,0x89c4920f,0x86e68654,0x94f68c77,
0xae119fb0,0xced3bdfa,0xf4d9e187,0x1fcc0950,0x4ae43636,0x69a85c54,0x776f72d2,0x732a76df,
0x605c6b7a,0x44a052c3,0x22963458,0xf8e40f4f,0xca3ee1d8,0xa194b434,0x8a3492ae,0x85ef8689,
0x932d8ab8,0xab529d7c,0xcb2bba85,0xefb2dd42,0x1be00512,0x470a3182,0x67d159a9,0x77a47211,
0x751177f6,0x636d6e22,0x47e9569b,0x245f36ce,0xfd1211a1,0xcf7be6d2,0xa641b95a,0x8cb29723,
0x859a86e6,0x90588939,0xa7b29a73,0xc792b735,0xed39d9bf,0x163d00ce,0x41eb2c88,0x6477553f,
0x767b7013,0x75f977ee,0x66346fc8,0x4b34599d,0x29823ae8,0x012416c6,0xd362ea50,0xa9d8bd28,
0x8e9099dc,0x85d68843,0x8dd78830,0xa4729744,0xc3f1b2ba,0xe8e6d660,0x1194fc12,0x3dfb28a1,
0x61d551cc,0x757f6e0e,0x75b277d0,0x6817706f,0x4f585ca0,0x2e2d3fa6,0x07391be7,0xd78befc8,
0xac3ac077,0x8fde9b88,0x86158879,0x8da487c0,0xa33d9706,0xc06cb120,0xe423d235,0x0d43f779,
0x393a22fa,0x5e014d08,0x73f16bc7,0x7754778a,0x6b057344,0x51ce6012,0x311e4201,0x0ac21ef2,
0xdc36f3c6,0xb088c579,0x920c9ecd,0x857a895e,0x8b9386df,0xa0229483,0xbdc2ad3c,0xe10ccf4d,
0x09acf4f0,0x358e1f72,0x5ba14a97,0x721c68fd,0x77607709,0x6be17341,0x5463615f,0x341144cd,
0x0f0b22c3,0xe218f9e1,0xb4a6ca20,0x93b1a24b,0x86648a6b,0x8a8b866a,0x9d109245,0xba74aada,
0xdd05cb37,0x0465f05e,0x3110198d,0x595246fb,0x72956853,0x783d7789,0x6d8974e0,0x56fb63de,
0x387d486f,0x120b2690,0xe54cfc12,0xb7f8ccf2,0x95f1a563,0x87308c48,0x88f585c7,0x9ab99058,
0xb761a7e6,0xd9c0c7fd,0x0127ec7b,0x2d9b1783,0x55204268,0x6ff36484,0x777e7620,0x6f5d75dc,
0x598965e9,0x39d34a00,0x15b528c3,0xeaa700ea,0xbd4cd44d,0x9939a965,0x87118e1e,0x886184ef,
0x98a38f0c,0xb4daa5c3,0xd70ac560,0xfb67e889,0x28a81240,0x53833e54,0x6fa36393,0x785f768a,
0x70f97672,0x5c1867f0,0x3d894d8f,0x19df2cc5,0xee4705ce,0xbe74d5df,0x99a4aa4a,0x879f8e6b,
0x886185b9,0x97648e1e,0xb16da375,0xd308c1a2,0xf97fe579,0x24b10e15,0x513a3c4a,0x6e996225,
0x78907661,0x71e976cc,0x5df0690b,0x404b5081,0x1bfd2f6e,0xf1ab0749,0xc3e0da67,0x9cd2aeda,
0x88b09063,0x8677854b,0x949c8bf2,0xae7ca08e,0xd06ebe9c,0xf71be2eb,0x22f40ca2,0x4e1538ef,
0x6d0b5f4d,0x789b7538,0x72d8782b,0x60666afe,0x444a5332,0x20093314,0xf4160bb5,0xc48cdbd2,
0x9e4faf65,0x88589102,0x859f84db,0x92f68a89,0xac369de2,0xcd75bbf1,0xf3c7e0f1,0x1fff087e,
0x4bb33673,0x6b7e5e2a,0x78b4747b,0x74ff78cc,0x62f36da3,0x466455ec,0x21ec3578,0xf7900d4e,
0xc845dfd8,0xa075b283,0x89509283,0x84df84f7,0x912a8921,0xaa049c19,0xcaa8b9a0,0xf10bddb2,
0x1ca7058d,0x494d33cc,0x698f5be3,0x78d173b5,0x7593790f,0x64116e79,0x472956b5,0x253a3673,
0xfb8211bb,0xcbb4e3c5,0xa36cb5e3,0x8a959483,0x850d85ee,0x8fb4887a,0xa80e9a05,0xc82db73a,
0xed66dafd,0x18f80217,0x46272fc3,0x685d5920,0x7945736a,0x76b97992,0x65a96fe1,0x49e4589d,
0x284e3aab,0xff4f1477,0xd012e80f,0xa613b97f,0x8b93965b,0x83558520,0x8def86c1,0xa56e9846,
0xc652b523,0xeab0d89c,0x1476fe84,0x417a2c00,0x65c75618,0x77d87115,0x77c379b3,0x685571ac,
0x4d035b46,0x2b003d1b,0x02341782,0xd45eebfc,0xa944bdc0,0x8d3d98ad,0x83e0865b,0x8d40867c,
0xa3a99694,0xc212b285,0xe774d471,0x1096fb7a,0x3d8426f9,0x63595271,0x777f6ff7,0x77e47a36,
0x694c7232,0x4f9e5dd2,0x2e533f5e,0x05e51b6c,0xd70eeecb,0xab87c054,0x8e9c9b03,0x84b18789,
0x8c35868a,0xa08d945a,0xbfbbaefd,0xe4e3d1f1,0x0d69f8e3,0x3b2923bd,0x61b7506d,0x771a6ec9,
0x78c17a0e,0x6b2c738b,0x52216013,0x30a54221,0x08c31d68,0xdb85f370,0xae11c34a,0x8f089cc8,
0x842f876a,0x8b3885ae,0x9ed0939a,0xbc5aaca0,0xe1a6ce53,0x0b30f511,0x38c221cd,0x5f874dd5,
0x76046d69,0x79627988,0x6d3e759b,0x54806215,0x346d450c,0x0cef21a4,0xddf4f5d1,0xb01ec5f3,
0x90979e63,0x84ac87c3,0x89928592,0x9cb69180,0xba06aa3e,0xdfa7cc76,0x08d3f310,0x34571e94,
0x5be949a1,0x74126a2c,0x797d792b,0x6df075e2,0x571763d8,0x364f47d1,0x0f2323c3,0xe11ef82c,
0xb5e1cac6,0x941ea30f,0x848c89e8,0x87e883a3,0x9af18fa2,0xb88fa8f9,0xdd6acaa0,0x0431f07d,
0x30bc19b0,0x59164737,0x733d684b,0x7923787c,0x6f8e75e0,0x589e6590,0x384e48ff,0x118c2558,
0xe4a0fba3,0xb8a3cdf0,0x969ca5a4,0x86468c3d,0x88768540,0x99e78f52,0xb691a738,0xda70c7ea,
0x00daed3f,0x2cb716c1,0x54f141bf,0x711c6542,0x79c57813,0x702576dd,0x59a7665e,0x39d54a93,
0x149e27a1,0xea8d0134,0xbd73d349,0x9908a958,0x871f8e1a,0x87f984bd,0x98398e77,0xb47fa51d,
0xd6c9c51c,0xfcfdea18,0x297e12b7,0x53183ea6,0x6f9963b1,0x798776d1,0x70d276e7,0x5b656768,
0x3cd24d09,0x1a392cae,0xed4d0437,0xc070d674,0x9a7dabc4,0x86218eca,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_Ocarina_OcarinaF6[256] = {
0x00b90031,0x022700e5,0x00480184,0xff9d008d,0x009ffff5,0x00c400c9,0x018200b9,0x009e0172,
0x01f2015a,0xff9a0095,0xff9fffcb,0x00f6ff70,0x02d702aa,0x016c021a,0xff7f012e,0xfec5fdf9,
0xfe37fe93,0x03690167,0x050c03e5,0xfecd02c5,0xfc53fdc9,0xfcfdfb5d,0x038efff8,0x070405e0,
0x025e07a9,0xf816fb19,0xf8b1f6da,0x03cffe60,0x0e350956,0x05060d16,0xf345fac8,0xf076f052,
0x0719f989,0x14f50e43,0x0a061583,0xee8bfb84,0xe6fee5e1,0x0313f150,0x201c1646,0x151b1f50,
0xe5c9fe77,0xdb29d8d9,0xfedce84c,0x2daa1bdb,0x1dfb2ba8,0xe2280469,0xcd6fcc86,0xf92adcfa,
0x39bf1f06,0x281c3a00,0xe1480a61,0xbf50c1d9,0xf244d1a9,0x42821f9f,0x348f45c4,0xe06a1319,
0xb3a3b9ac,0xeaf3c674,0x46b21d6f,0x3fe75082,0xe5691ad1,0xa967b677,0xe0ffbc90,0x49a81622,
0x49be5a43,0xebbf253b,0xa126b45d,0xd8d2b268,0x47600f41,0x53b761a8,0xf4d02e54,0x9a6fb707,
0xcdbba6d9,0x463b07e3,0x5ce26665,0xfc183800,0x963cb985,0xc5179fda,0x41b9fed1,0x636568b7,
0x05c24003,0x948dc061,0xbc689800,0x3be7f63f,0x693b69fd,0x0f35484b,0x93a1c519,0xb3e09358,
0x3667ecf2,0x6e266a47,0x1724507c,0x949aca77,0xad608e7d,0x2f06e577,0x728e687e,0x1e4d55ef,
0x96d8d2f0,0xa7d88aad,0x2729dea1,0x738a645f,0x26e95b43,0x9a27da04,0xa2288972,0x2089d69d,
0x751a618c,0x2d305e7d,0x9e68e31a,0x9e4c87ef,0x177cd020,0x76465c47,0x332362fe,0xa4c4ead1,
0x9a0d8841,0x0fdac96c,0x752b568e,0x39e865c9,0xaa3ef3dd,0x96dd8880,0x076bc3f4,0x75204f99,
0x3e20698d,0xb10cfb41,0x94288969,0xffa9bf60,0x72a1473c,0x44b16c91,0xb75e0296,0x91d48c6d,
0xf72cb9a0,0x704c414a,0x49556cb4,0xc01d0c94,0x90508eb5,0xef19b4ab,0x6c7537a5,0x4eba6eb9,
0xc8af159f,0x8e889246,0xe646af3a,0x68ec2f42,0x52b47106,0xd13d1d45,0x8c249506,0xdff4aa3a,
0x654c2836,0x57ec7323,0xd89722f5,0x89ce98e3,0xd9f2a619,0x61292121,0x5b5e73bb,0xdfe2291c,
0x895a9e07,0xd437a10d,0x5c981a2c,0x5f52745d,0xe7072eea,0x89b3a253,0xcd6f9e47,0x57571244,
0x638974de,0xedd5350a,0x8916a6f5,0xc7f399db,0x52bb0b8c,0x668774af,0xf5ab3a38,0x88dbaba8,
0xc5919809,0x513c08f1,0x66a8748f,0xf6b03a38,0x89b9ad54,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};
