#include "nylonstrgtr_samples.h"
const AudioSynthWavetable::sample_data nylonstrgtr_samples[3] = {
	{
		(int16_t*)sample_0_nylonstrgtr_nguitrf2, // sample
		true, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(46) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(70) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3828 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3824 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3824 - 1) << (32 - 12)) - (((uint32_t)3727 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-7.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(100.02 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(21.8 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(120.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.5 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_nylonstrgtr_nguitb2, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(-1) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(77) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)5192 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)5188 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)5188 - 1) << (32 - 13)) - (((uint32_t)5125 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-7.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(100.02 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(21.8 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(120.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.5 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_nylonstrgtr_acgtrb3, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(32) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(76) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)6240 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)6236 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)6236 - 1) << (32 - 13)) - (((uint32_t)6168 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-7.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(100.02 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(21.8 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(120.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.5 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_nylonstrgtr_nguitrf2[1920] = {
0x00000000,0xff9dfef2,0xfebbff73,0x001bff86,0x00c00033,0x01c80171,0x016901a3,0x009c019d,
0xffd1ffd9,0x008fffeb,0x011700b1,0x01020190,0x005f00c3,0xffec000c,0x00acfff0,0xffebff92,
0x012301ba,0xfee90017,0x00a7ff2e,0x010d0156,0x019a00dd,0x02000263,0x01ad0208,0x014100e7,
0x01340220,0x00db00f4,0x0017ffc9,0x000dff41,0xffa1002e,0x025a0207,0xfcceffa5,0xffc5fe23,
0xfe6dff81,0x0024fc47,0xfe31007b,0xfde50059,0x028a0059,0xfd44fda8,0x00adfe10,0x05c30449,
0x090a0646,0x0b230a62,0x0d3e0b98,0x07e80a6d,0x0e570c22,0x11b30bd6,0x128d1182,0x18c71a3f,
0x14301811,0x0b600bba,0x02720939,0xfd140318,0xfbe2faf3,0xf770f760,0xf103f54f,0xec0ff0d5,
0xe6aee887,0xe2fae1c1,0xde46dfd4,0xe278e023,0xe4c2e2df,0xe90ce70d,0xe7e7e546,0xe846f043,
0xed21e6bd,0xeaefeab4,0xec96efb0,0xece4eb20,0xf024ef6c,0xeaa4ece7,0xe62eeb6d,0xe62ee4b4,
0xe4dfe5b1,0xea72e618,0xeae7eb7d,0xf336f288,0xf786f048,0xf209f42c,0xf102f539,0xfc7af6c9,
0x0540fcca,0x0c80073e,0x15a213c6,0x23061ed4,0x2fa426be,0x31933015,0x3da836a2,0x4ac046c5,
0x533f4fba,0x57e854c1,0x551b594e,0x532b54d3,0x52074f1d,0x48734c7e,0x4cd54d1b,0x49bc4afc,
0x402d4640,0x330038b0,0x233a2d17,0x19131d49,0x08d80fa9,0x01a404c7,0xfaec00b1,0xf1bdf6f9,
0xe498e900,0xdbede02b,0xd805d9a1,0xd254d78c,0xd262cdf4,0xc70ece52,0xc5a4c8a0,0xc4a0c42f,
0xbee0bf3d,0xbc92beed,0xb980bceb,0xbd5cba63,0xbb1dbbbd,0xb554b91b,0xb1e4b357,0xaebbb15e,
0xb0e5ab28,0xb0f0b251,0xbaf9b777,0xc999c021,0xd0efcda4,0xd674d333,0xdc3fdb42,0xed7de26b,
0xfb22f44a,0x02c50033,0x0f53098c,0x1f961610,0x2b622405,0x33ca30b2,0x3d813904,0x4a19446a,
0x4d8f4a10,0x4cc94eec,0x4c214eca,0x4e354b34,0x4d614d7d,0x4c7d4cea,0x4b944ef2,0x4e0f4d3d,
0x425046a9,0x37fe3ecf,0x2d04334c,0x1f05250a,0x106716cd,0x076e0b97,0xff4b0461,0xf540fa81,
0xebedef6d,0xdeb1e5a7,0xd8dbdd71,0xd099d1e8,0xcd93ce4b,0xcbd0cece,0xcc17cad9,0xc870c9cc,
0xc5f3c677,0xc1b9c597,0xc11fc040,0xc618c12e,0xc86cc786,0xc630c9c5,0xca7bc98f,0xcb17c6eb,
0xd0a1ce14,0xd8d2d5f2,0xe206dd15,0xf041e7e0,0xf712f40c,0xfdbefcb2,0x02bcff07,0x112b07c0,
0x1d401862,0x27552351,0x32962cba,0x3dd536f5,0x481d442d,0x4f8f4c83,0x5a5554c9,0x63175dde,
0x6625651e,0x6791689b,0x646865d4,0x627e6358,0x5bb05e90,0x56415a99,0x528353dd,0x49874de0,
0x3aca42fb,0x297032eb,0x16fb2047,0x04090d86,0xf19cf9e9,0xe213e99d,0xd5dedd08,0xc8cccd45,
0xba72c2c5,0xb0a2b595,0xa786ab32,0x9f29a27c,0x9f9da01c,0x9d159dd4,0x9e339d7a,0x9d629ca8,
0x9edf9f27,0x9eb89fd6,0x9f649d8d,0xa6c0a172,0xae8cac8b,0xb5dbb1f5,0xb9e7b7c8,0xbd54bb91,
0xc3f3bfdc,0xcb4fc892,0xd87fd04c,0xe5fedf4c,0xf262ec7d,0xfb61f844,0x0459fe24,0x16c10cc0,
0x265b1fae,0x33862d6a,0x3e7638cd,0x4b624438,0x55dd51b8,0x5e325a2c,0x693162eb,0x704f6d23,
0x758a7348,0x73827628,0x7081717b,0x6b566d8d,0x65d3699d,0x603462eb,0x598e5c9d,0x506d5584,
0x434549b4,0x34b93c66,0x24da2d0c,0x12901b65,0xff0f096f,0xf350f929,0xe6a9ebfe,0xdbcde1af,
0xcfafd613,0xc659ca2f,0xbbddc14e,0xb5fbb812,0xb2d5b514,0xb1ebb172,0xb1b4b15e,0xb150b157,
0xb319b313,0xb1adb22f,0xaff4af92,0xb6d0b3d5,0xbd8bba4e,0xc304bff9,0xc7cdc4dd,0xcacdc8e0,
0xd36dcf64,0xdb08d615,0xe6f5df25,0xf3b0ee61,0x0207fbe8,0x09790628,0x0ff30b37,0x1c2b15a2,
0x27c222dd,0x31552d40,0x37bf338b,0x41503c6e,0x479d4550,0x4c554958,0x53cf4fb8,0x57e7565e,
0x5b395b73,0x56d75935,0x513253a9,0x4a5f4dc0,0x42bc4698,0x3bbe3f19,0x34da385a,0x2b9a30c3,
0x1edc25f4,0x10e017ad,0x00500879,0xeedcf8a7,0xdea1e5c4,0xd199d797,0xc7f2cc4b,0xbf80c41d,
0xb666baba,0xb054b311,0xa827abf9,0xa674a70d,0xa59ea57f,0xa86aa678,0xab2aa9e4,0xaffdadee,
0xb59eb29e,0xb728b6d0,0xbb32b85b,0xc424bf90,0xce5dc999,0xd720d267,0xdceddaac,0xe214df0b,
0xea20e622,0xf158ecff,0xfd00f6e7,0x098a037c,0x165e10ac,0x1ba11992,0x227d1e0d,0x2dd62803,
0x3a0a3409,0x42163eae,0x49174538,0x53424e49,0x58d356b9,0x5df65a99,0x63676118,0x692c665a,
0x6b456b42,0x669a697e,0x5fc9632a,0x581b5c07,0x4f5453ba,0x48134b9c,0x400f4424,0x363e3bf6,
0x29262f97,0x19a921a3,0x0a711243,0xf83a0177,0xe73fef7b,0xd933dfac,0xcfafd40a,0xc60ecb4a,
0xbd9bc0fb,0xb5b1ba17,0xaebdb1b3,0xabbdad43,0xaadcaa6c,0xac8fabb0,0xaf73adf1,0xb304b0f0,
0xb7bbb5e1,0xb80cb7ea,0xba10b8b8,0xc0f2bd10,0xc7f3c469,0xcf5bcbd8,0xd288d164,0xd713d453,
0xdc35d9e2,0xe2b9df02,0xebaee6fb,0xf714f0e0,0x0212fd51,0x069a04df,0x0c760931,0x159c1089,
0x200a1ae0,0x267b23d2,0x2c5b2924,0x3547312f,0x3959372e,0x3e783bf3,0x43ef414c,0x4aa34759,
0x4d2e4c87,0x49d54bfb,0x44824738,0x3ea641dc,0x38d33b6a,0x33cf363b,0x2fe1320e,0x297d2ce1,
0x1fa4251b,0x14a11a25,0x089f0ef4,0xfa7a01b0,0xecccf382,0xe1bde679,0xdb6fde8a,0xd42dd7bd,
0xcf36d16d,0xc97fcca3,0xc589c71e,0xc2f8c3e5,0xc2c6c287,0xc4ffc3bf,0xc72bc647,0xcc34c94b,
0xd06dce9b,0xd1eed168,0xd4a3d2df,0xdae8d782,0xe22ade49,0xe949e642,0xecadeb09,0xf0c6eebe,
0xf43df282,0xf923f674,0xff7bfbf0,0x08a10392,0x11680de9,0x14ed138e,0x18691668,0x1f4a1b46,
0x27c923a3,0x2c662adf,0x31542e34,0x378034cc,0x3ba73993,0x3f3d3d77,0x43934145,0x494b465b,
0x4bd84b48,0x48df4ae4,0x43984680,0x3cbd403c,0x35db3934,0x307132f0,0x2b762e0b,0x250d288c,
0x1afc207c,0x0ff01572,0x03a90a19,0xf599fca4,0xe6edee68,0xdb59e060,0xd3a9d78e,0xcbebcf75,
0xc622c907,0xbfe5c2e5,0xbb15bd58,0xb813b968,0xb772b745,0xb96cb866,0xbb50ba10,0xc01abd80,
0xc447c299,0xc593c53e,0xc73ac5f6,0xcb3ac911,0xd1cace3d,0xd74cd51b,0xda4cd8e0,0xdcafdb7e,
0xdef0ddbc,0xe2d1e0cf,0xe82ce4ff,0xf210eca1,0xfb1cf722,0x0038fe23,0x04d10248,0x0c910804,
0x16a211f0,0x1cbb1a01,0x2440202a,0x2bf9283d,0x32882f57,0x383f3577,0x3f013b59,0x47914335,
0x4d014b09,0x4d204d86,0x4a384c0a,0x45dd482d,0x40e5432d,0x3d903f27,0x3ad13c10,0x36cd393f,
0x2ef3333e,0x26192ab5,0x1b4a20dc,0x0f441570,0x0199086e,0xf78dfbfb,0xef9ff393,0xe8bfebe8,
0xe2cde5dd,0xdcc1dfce,0xd7e8da0f,0xd3bfd5b4,0xd28dd2b2,0xd28dd2a5,0xd30ed293,0xd5e5d44c,
0xd7eed760,0xd6d4d770,0xd655d66b,0xd7d1d6bc,0xdc40d9e2,0xdf72de24,0xe0b8e01d,0xe0ede10a,
0xe1a5e11d,0xe2eee24d,0xe631e3ee,0xedf1e9a6,0xf534f21d,0xf8c9f760,0xfb0bf9cc,0x0168fd7f,
0x099f05ec,0x0ecb0c42,0x152e11c9,0x1bfd18a8,0x22181f2c,0x276624c2,0x2dc22a30,0x3671322a,
0x3c2a39ed,0x3d2e3d34,0x3b093c52,0x36e5393f,0x3292347e,0x2f8730ee,0x2dca2e90,0x2aa02cb0,
0x24062794,0x1bb1202c,0x118c1698,0x06070c3f,0xf8c9ff42,0xeeb0f363,0xe661ea56,0xdf9ce2c3,
0xd980dca1,0xd355d652,0xce33d0b8,0xc9d3cbae,0xc89dc8f1,0xc890c897,0xc94dc8a2,0xcc8fcab5,
0xcef5ce33,0xcef9cf03,0xcedacedd,0xd0e0cf69,0xd5ded348,0xd9c9d7f6,0xdc56db54,0xdd3cdcd1,
0xdebdddf3,0xe068df7a,0xe4dce205,0xedf4e902,0xf6b2f2bc,0xfc6af9ff,0xffebfded,0x080e036a,
0x11200cf0,0x186214c2,0x201e1c11,0x28732460,0x303b2c85,0x36643366,0x3dfa39bc,0x47af42d6,
0x4efc4bf1,0x515250b6,0x5024511d,0x4c554e73,0x48554a42,0x452e4684,0x4390445b,0x40454253,
0x39f63d75,0x30bf35a8,0x26482b8b,0x194f204a,0x0b771227,0xffe5055d,0xf609fad3,0xede0f1bc,
0xe5d9e9dd,0xde4be1fa,0xd722dac0,0xd11bd3dc,0xcd93cf07,0xcb12cc47,0xc999ca0f,0xcad8ca21,
0xcb0bcb33,0xc923ca21,0xc6a8c7db,0xc6d2c644,0xc996c823,0xcc1bcae9,0xcd26ccf2,0xccf6cd08,
0xcd76cd36,0xcddecd98,0xd160cedf,0xd98fd521,0xe288de35,0xe822e5f1,0xec01e9bf,0xf455efbe,
0xfd32f8d7,0x051d0141,0x0d82093b,0x1698120e,0x1f3d1b1c,0x263722ac,0x2ea42a22,0x394b33e7,
0x41e03e30,0x45fd4457,0x466446a3,0x43ba4540,0x404941f0,0x3ddd3ec4,0x3d4c3db3,0x3b313c6e,
0x364a3937,0x2e283258,0x24dc29c3,0x18c51f36,0x0c031238,0x010b065f,0xf7d6fc39,0xf06df3f4,
0xe8e5eca4,0xe209e56a,0xdb34dea2,0xd5e2d846,0xd300d412,0xd0e8d1fc,0xd060d042,0xd22dd144,
0xd352d2df,0xd283d31f,0xd0d0d19a,0xd1b3d0d5,0xd4c9d31c,0xd82bd69f,0xd9afd931,0xda3bd9e2,
0xdadcdaa4,0xdaf6dad6,0xde94dc0f,0xe683e22a,0xefffeb76,0xf591f36f,0xfa20f774,0x01ebfda4,
0x0a84065a,0x124c0e75,0x1a50164d,0x23471e95,0x2b1f2779,0x31732e5b,0x392734e8,0x43043dfa,
0x4b014778,0x4eda4d81,0x4ead4f3f,0x4b704d57,0x469148fc,0x430f446c,0x40e94216,0x3df03fa2,
0x380d3b67,0x2f1a33bb,0x24652a1f,0x16ea1de3,0x08c60fbd,0xfc44025f,0xf1c7f6a9,0xe8d5ed40,
0xe01ce466,0xd800dbff,0xcfe9d3ea,0xc986cc69,0xc5cac784,0xc2b8c42d,0xc1dac1d4,0xc290c217,
0xc341c326,0xc1f3c30c,0xbfe1c0ae,0xc06cbf9c,0xc326c173,0xc6bcc529,0xc8e1c821,0xca25c963,
0xcb34cae5,0xcbc9cb61,0xcfb5cd3b,0xd86ad378,0xe2cfddd2,0xe961e687,0xef4aec19,0xf837f368,
0x019efcde,0x0aa20637,0x138b0eef,0x1d9c188e,0x268a2251,0x2dc92a37,0x368431cd,0x41343bd8,
0x4a6f462a,0x500d4dac,0x51985157,0x4fd0512b,0x4beb4ded,0x49784a6f,0x481c48af,0x46584778,
0x41ac4476,0x3a333e27,0x30c335d7,0x245e2ad0,0x176f1dd8,0x0b56112e,0x019d062d,0xf8fdfd45,
0xf09af4c0,0xe89feca9,0xe068e46d,0xd9fadcdb,0xd5b9d7c6,0xd259d3ce,0xd134d16a,0xd17ad144,
0xd225d1fe,0xd055d19a,0xcd9bcec0,0xcce8ccf3,0xcee5cdab,0xd1cbd077,0xd305d28c,0xd3cbd35d,
0xd3cdd412,0xd322d34b,0xd56ad3b8,0xdcc2d871,0xe5c9e186,0xeb3de8ef,0xf04ded92,0xf77ef3a0,
0xffb7fb9b,0x079403b9,0x0f5d0b63,0x186413cd,0x20401c91,0x266a236a,0x2e0029e5,0x378532a2,
0x40383c24,0x45a14367,0x470446be,0x44e64686,0x406b429f,0x3d033e8b,0x3b2d3bdc,0x391c3a74,
0x34743731,0x2d50311a,0x23bc28f6,0x17331dad,0x09fd109c,0xfdb40391,0xf3f5f888,0xeb55ef99,
0xe393e773,0xdc20dfdb,0xd449d80b,0xce82d104,0xcaaacc90,0xc7d8c8f9,0xc77ac75c,0xc8b2c7cf,
0xca1fc99d,0xc95dca32,0xc7afc859,0xc7d0c760,0xcaa3c8d7,0xce48cc96,0xd08ccf73,0xd279d18f,
0xd31fd302,0xd32ed324,0xd5ded3f9,0xde0ed937,0xe810e338,0xeeb1eb9d,0xf4b5f1a7,0xfcbdf871,
0x05c4013c,0x0e7f0a31,0x171212a4,0x20f51bfd,0x29a925a5,0x308f2d38,0x38c23457,0x428a3d84,
0x4bfb4770,0x520f4f76,0x54c153cd,0x52ee5458,0x4eb250dd,0x4b104cb6,0x491749d1,0x46e7484d,
0x428d4512,0x3c1c3fa1,0x328337ca,0x261f2c99,0x18a81f6b,0x0be011ed,0x015f0638,0xf81efcbd,
0xefd8f406,0xe78eebd2,0xdecbe307,0xd804db20,0xd2cad563,0xcec9d096,0xcd1fcdb8,0xcd17ccc9,
0xcd36cd4c,0xcb39cc96,0xc81ac9aa,0xc690c6fc,0xc823c6e9,0xca55c95a,0xcba5cb15,0xcc75cc36,
0xcc0ecc75,0xca9dcb51,0xcb93ca7a,0xd275ce55,0xdb3ed704,0xe170de92,0xe6e3e40c,0xedfbea40,
0xf64bf206,0xfe29fa51,0x06590204,0x0fb50b06,0x1834143f,0x1ed21b93,0x26952272,0x30552b40,
0x3a083575,0x41283de5,0x44f54384,0x445b452f,0x412a42f1,0x3e493f97,0x3d1d3d77,0x3bfb3cbd,
0x391d3ac7,0x344b3702,0x2c4d30bc,0x21842737,0x15341b5f,0x09b20f44,0x003604af,0xf840fc13,
0xf153f4b1,0xe9ffedcf,0xe24ae60d,0xdc82df1c,0xd82dda2e,0xd526d666,0xd43dd47b,0xd550d4a8,
0xd678d616,0xd571d622,0xd2a9d41f,0xd168d1c7,0xd31dd1f2,0xd57fd450,0xd762d680,0xd88ad81a,
0xd883d8b5,0xd70bd7de,0xd77dd69a,0xddeada1c,0xe65be240,0xec77e9be,0xf1fbef16,0xf8b8f52f,
0x00b0fc9e,0x0853049b,0x107d0c3f,0x19a914fe,0x21ce1e01,0x28422529,0x2f752ba1,0x389433d4,
0x41933d44,0x48b04571,0x4c664b19,0x4be64cac,0x483f4a36,0x44504619,0x4229431a,0x3ff44135,
0x3c983e5e,0x37313a4e,0x2eb43366,0x2357294f,0x161a1cd3,0x09b80fa6,0xff190430,0xf644fa84,
0xee85f24a,0xe625ea82,0xddbae1d1,0xd6acda08,0xd11bd3a7,0xcce2ced3,0xcae9cb93,0xcb30cade,
0xcb91cb7e,0xc9f0cb0b,0xc66ec854,0xc44cc4f9,0xc4f8c458,0xc6bbc5ca,0xc866c7aa,0xc971c90e,
0xc947c986,0xc767c878,0xc78ec6d7,0xcddcca10,0xd642d214,0xdd32d9ff,0xe34de032,0xea90e6b3,
0xf32eeecc,0xfb9df770,0x049fffef,0x0f0109c7,0x186013df,0x20321c72,0x286c2411,0x328c2d52,
0x3cbf37c2,0x45794168,0x4b1948cb,0x4c6f4c47,0x4a454ba8,0x47b548cc,0x46ad471d,0x459c4638,
0x43b544c1,0x3fef4235,0x39263cec,0x2f303492,0x2314293a,0x174c1cf5,0x0d3a1219,0x04ed08cb,
0xfdcd0159,0xf5d4f9f9,0xeddcf1c9,0xe6b1ea17,0xe0dde39b,0xdc44de68,0xd9eddac4,0xd9efd9bb,
0xda12da16,0xd88ad9a6,0xd4b2d6c7,0xd1c6d2e8,0xd17ad15c,0xd27ed1da,0xd393d324,0xd3fdd3da,
0xd329d3ce,0xd033d1cc,0xcefaceff,0xd3aed0b3,0xdaf1d74d,0xe116de46,0xe634e394,0xec75e929,
0xf3b0f006,0xfaecf74e,0x02f1feaf,0x0c200786,0x149b109c,0x1b7c182d,0x22ff1efb,0x2bf5275b,
0x3537309c,0x3d7c39a2,0x42d94097,0x440e43ff,0x41764320,0x3e5e3fb8,0x3c793d61,0x3ac23b97,
0x387039b2,0x34cb36eb,0x2e1c31cd,0x245929b3,0x183f1e69,0x0c201216,0x01ae06b0,0xf946fd23,
0xf201f5a6,0xea51ee46,0xe27ae657,0xdb90ded1,0xd5bad885,0xd166d36a,0xcf5dcff6,0xcfb1cf5a,
0xd0acd037,0xcfe4d0ac,0xccd0ce82,0xca65cb44,0xca71ca25,0xcc3dcb41,0xce22cd45,0xcfa0cedf,
0xcfc7d001,0xcd7bcecd,0xccfdccc5,0xd1f6cec9,0xd9d8d5ce,0xe119dda1,0xe766e449,0xeec2eae7,
0xf6f6f2d6,0xff1bfb09,0x081e036a,0x12490d20,0x1bd91751,0x23a41fe1,0x2bcd2787,0x354e3078,
0x3f0f3a27,0x481343cf,0x4e754bac,0x50b75031,0x4f025046,0x4c504d7f,0x4a834b58,0x48b6499a,
0x467647ba,0x42fe4501,0x3cc74045,0x332c3867,0x27132d47,0x1ada20e5,0x0f7214e9,0x06480a93,
0xfe85026b,0xf648fa70,0xeddcf20e,0xe5ece9ca,0xdee6e256,0xd929dbcd,0xd5a9d712,0xd4d1d4ff,
0xd4d2d4d4,0xd318d45e,0xcee8d126,0xcb2accc0,0xc9b8ca39,0xc9dac99e,0xca90ca3b,0xcb41caeb,
0xca73cb34,0xc70ec8eb,0xc532c5a4,0xc893c630,0xcf4ccbc2,0xd5d0d2bb,0xdb90d8ab,0xe220deac,
0xe97ce5d6,0xf0e0ed17,0xf947f4e6,0x0321fe16,0x0c6c0801,0x141a1068,0x1c3317f4,0x257020b9,
0x2f3a2a47,0x388c3414,0x3fa93c6f,0x42f641f0,0x422942e7,0x40534137,0x3f1d3fab,0x3dd93e7d,
0x3c763d3d,0x39eb3b5e,0x351437df,0x2cf53177,0x223127bf,0x16d71c8b,0x0c3e1141,0x03e507cb,
0xfd020071,0xf5f6f980,0xeea2f240,0xe7b4eb1b,0xe199e494,0xdc83decc,0xd9d2dacf,0xd9afd97b,
0xdad4da42,0xda56db00,0xd76fd903,0xd451d5a8,0xd349d398,0xd407d38a,0xd565d498,0xd6fed63c,
0xd6d0d753,0xd3d9d59a,0xd20ed271,0xd50bd2d2,0xdb57d7f7,0xe1e2debb,0xe7cde4dc,0xee6deaf6,
0xf573f1f8,0xfc9bf8e9,0x04a40072,0x0e260952,0x172012d4,0x1e951af4,0x26172239,0x2e862a3d,
0x376a32e1,0x3ff73bcc,0x46ce43be,0x49bd48e7,0x488e497a,0x45fc4750,0x43ad44d3,0x416c4287,
0x3efb4058,0x3bc03d72,0x364b3963,0x2d9f3263,0x22662842,0x161f1c5f,0x0a861019,0x011f058d,
0xf937fd0f,0xf149f543,0xe94aed49,0xe1a9e56f,0xda9ade1f,0xd4a0d758,0xd0ced267,0xcffad004,
0xd0a1d052,0xcfefd09e,0xcca3ce70,0xc90ecab9,0xc77ac800,0xc7a8c76c,0xc8a4c800,0xca45c97e,
0xca31ca9f,0xc75dc903,0xc571c5fd,0xc7fdc609,0xce38cad6,0xd501d1b9,0xdb6ed834,0xe27cdedc,
0xea14e644,0xf183edc1,0xfa39f5ad,0x045bff2d,0x0dfd0961,0x165e123e,0x1ea81a70,0x27f5232a,
0x318b2cc9,0x3b08364f,0x43103f63,0x478045e9,0x47bf47f7,0x46804735,0x455d45e5,0x441f44cd,
0x42db437f,0x40db41f0,0x3cca3f3c,0x35c239b8,0x2c103128,0x20ea268c,0x16401b68,0x0d86119b,
0x065609d5,0xff3e02d4,0xf802fb9e,0xf114f481,0xea56ed9c,0xe47ce73b,0xe06fe23b,0xdf46df7a,
0xdfeedf9a,0xdf64dff5,0xdc3bde09,0xd863da39,0xd611d6f6,0xd546d591,0xd585d52b,0xd688d60c,
0xd5c6d69a,0xd20ad422,0xced1d01f,0xcfc4cebd,0xd451d1c2,0xd9a5d700,0xdee5dc31,0xe4d6e1cb,
0xeb05e7ee,0xf126ee06,0xf88cf4a7,0x0151fcda,0x09e905c3,0x112a0d9e,0x186514ba,0x207a1c57,
0x28ef24bc,0x318c2d3d,0x3904359e,0x3d2e3ba9,0x3d5f3d9f,0x3bd63cb8,0x3a3d3af0,0x38a33971,
0x36f637e2,0x34d535fd,0x30fd3348,0x2a322de4,0x20f825ef,0x162d1bb5,0x0b9810b0,0x02df06f0,
0xfbc5ff27,0xf4f5f85b,0xee3af192,0xe7bbeaf9,0xe16be47c,0xdbdfde7c,0xd810d9bd,0xd73fd742,
0xd865d7c0,0xd89dd8db,0xd666d7c0,0xd350d4bf,0xd18dd237,0xd0fdd12c,0xd1d1d130,0xd39dd2be,
0xd396d3f4,0xd096d253,0xcdfecf08,0xcf27ce00,0xd3e8d138,0xd9c8d6ce,0xdffadcd5,0xe6b6e343,
0xed91ea20,0xf444f0e0,0xfc2cf801,0x05b200d8,0x0f0f0a80,0x172e1339,0x1f1b1b15,0x27d0235b,
0x30d32c56,0x39dc3550,0x42053e41,0x46f444fb,0x480947dd,0x471d47b7,0x45e9467c,0x44ac4556,
0x432043dd,0x412a4242,0x3d8a3fb8,0x37183a9b,0x2e3e32fa,0x238128fc,0x18be1e09,0x0f7c13ed,
0x07ca0b6d,0x00770423,0xf93cfcd0,0xf223f5b1,0xeb27eea2,0xe4b0e7cc,0xdfbce1f0,0xdd9ade46,
0xdd83dd7d,0xdcd8dd6b,0xd9aedb86,0xd591d797,0xd253d3bf,0xd03ad133,0xcfcfcfc5,0xd06dd02b,
0xcf61d04c,0xcb91cdb8,0xc7a6c94e,0xc747c6fc,0xca70c87d,0xcf27ccbb,0xd463d1b9,0xda51d752,
0xe09edd6b,0xe6a5e38a,0xedd0e9ff,0xf6bbf219,0xffb5fb63,0x07b203c6,0x0f6f0b7f,0x180d13a9,
0x21131c8a,0x2a6225b8,0x331e2f0a,0x38cb365d,0x3aed3a38,0x3ae63b11,0x3a9d3ac2,0x3a2e3a66,
0x397d39ce,0x38cd394b,0x363b37d3,0x31483413,0x29de2de0,0x2085255f,0x16fa1ba3,0x0eaf129e,
0x07ec0b1c,0x019604c1,0xfb7bfe79,0xf573f87d,0xef8bf287,0xe9dceca0,0xe57ce758,0xe3d6e44c,
0xe472e3fe,0xe4a0e4c9,0xe265e3c9,0xdf19e0b3,0xdc50dd9f,0xda69db32,0xda1ad9fa,0xdb00da86,
0xda46db00,0xd6c0d8c9,0xd2c3d481,0xd21cd1eb,0xd499d30f,0xd8dbd6a7,0xddfedb4f,0xe3e1e0d9,
0xe9a2e6d0,0xef3dec6d,0xf609f266,0xfe83fa1f,0x071102d8,0x0eaf0afe,0x164f128a,0x1e661a3f,
0x26b52281,0x2f8c2b14,0x37e433ef,0x3d293af2,0x3f093e82,0x3ec73f05,0x3dfb3e61,0x3cf73d87,
0x3bde3c68,0x3a833b56,0x376a392e,0x3211350b,0x2a522e86,0x20a625b9,0x167c1b7a,0x0d7e11c9,
0x05d20979,0xfedb0250,0xf82cfb7d,0xf199f4e5,0xeb17ee46,0xe4aae7da,0xdf80e1d1,0xdce6ddd5,
0xdcacdca1,0xdc48dcaf,0xd9c0db4d,0xd62ad7e8,0xd2e5d48d,0xd057d174,0xcf81cfac,0xd03acfd1,
0xcf69d030,0xcbeccdee,0xc7d4c9be,0xc6b2c6ca,0xc8d7c778,0xccd5caa1,0xd231cf5f,0xd880d54b,
0xdebedbb5,0xe4f1e1cb,0xec30e846,0xf52df07b,0xfe77f9eb,0x070202d0,0x0f750b24,0x186013e3,
0x21a71cfc,0x2b872680,0x34fe3075,0x3bb638d0,0x3f113dd1,0x40273fb9,0x40844058,0x40954092,
0x408d4095,0x4049407c,0x3e543f91,0x3a453c91,0x33b73749,0x2b1f2fa6,0x21eb267a,0x19971da8,
0x124215d6,0x0bb60ee3,0x054f0879,0xff200231,0xf8d1fbf6,0xf26ff5a6,0xed02ef7d,0xe9ebeb20,
0xe94ee976,0xe898e91b,0xe5d2e784,0xe1e7e3e1,0xde11e004,0xdaa1dc30,0xd8dbd969,0xd8b2d8bf,
0xd72ad84b,0xd2e8d552,0xcde1d030,0xcb96cc45,0xcc84cbc2,0xcf34cdba,0xd368d10e,0xd8bcd60e,
0xddfedb68,0xe310e079,0xe940e5f0,0xf174ed27,0xf9e5f5bb,0x0199fdd7,0x0980057b,0x11ad0d8b,
0x1a4015ec,0x23821ecf,0x2c812825,0x3320303d,0x365d352c,0x37683703,0x3796378f,0x378a3799,
0x378d3781,0x37443782,0x357c36a2,0x318933ca,0x2b562ebe,0x23052763,0x1a021e73,0x11de15cf,
0x0a8f0e2a,0x04150737,0xfde500ef,0xf7eefaec,0xf1fcf4f8,0xebf7eef5,0xe6cee929,0xe3cee4fc,
0xe368e359,0xe33fe387,0xe136e271,0xddf4dfab,0xdaaddc51,0xd786d8fe,0xd618d67e,0xd698d646,
0xd5d8d694,0xd24ad457,0xcdf4d00b,0xcc01cc8b,0xcd1acc42,0xd008ce5a,0xd4a5d215,0xdab2d7a6,
0xe096ddab,0xe673e37f,0xed1ee996,0xf5a8f133,0xfebffa45,0x072f0304,0x0faf0b68,0x183413e8,
0x211f1c95,0x2abd25db,0x341f2f9d,0x3b553825,0x3f303da1,0x40a84016,0x411540fd,0x410e4118,
0x41114104,0x40de410b,0x3f134039,0x3b1e3d67,0x350f3861,0x2cba311f,0x23812825,0x1b101f20,
0x13471712,0x0c340fa5,0x056d08c2,0xff03023a,0xf884fbd0,0xf1c6f51a,0xeba7ee92,0xe7b8e95a,
0xe655e6c2,0xe530e5f0,0xe275e408,0xdeace0a9,0xda95dca5,0xd68dd871,0xd419d508,0xd393d3c4,
0xd22ad329,0xcdecd04f,0xc8dccb56,0xc5f3c706,0xc5ecc59d,0xc7e9c6b5,0xcbc8c99d,0xd134ce5a,
0xd69dd3e8,0xdbdfd93a,0xe219dee0,0xea3de5e7,0xf304eea9,0xfb66f740,0x03c1ff95,0x0c4c07fa,
0x154610aa,0x1f141a1e,0x28c52400,0x30bf2d2c,0x35493362,0x3764369a,0x38723810,0x391238b9,
0x39c93960,0x3a613a23,0x39ab3a55,0x36db3881,0x31d234a4,0x2a842e62,0x225b267a,0x1ab41e65,
0x13b71720,0x0d69107b,0x07930a7b,0x01e004aa,0xfc3fff1b,0xf682f963,0xf0fbf3a1,0xed79eee8,
0xec62ecb1,0xebaeec2e,0xe99deaca,0xe66de824,0xe2c3e49e,0xdf02e0d5,0xdcafdd90,0xdc79dc7a,
0xdb5adc3b,0xd730d98a,0xd22cd4a3,0xcef3d035,0xce5fce5f,0xcfbcced7,0xd357d144,0xd885d5d0,
0xdda5db20,0xe27de00d,0xe84fe532,0xefd3ebdd,0xf826f403,0x0039fc3a,0x0818041d,0x103e0c2d,
0x18c11461,0x21f11d47,0x2b3e26ae,0x32e92f70,0x37523586,0x39663886,0x39f939cb,0x3a203a16,
0x3a5e3a35,0x3a943a93,0x39a13a4f,0x367c385a,0x312d3418,0x29ba2db2,0x21542583,0x19351d2c,
0x11d9157a,0x0b100e67,0x049307c4,0xfe7e017b,0xf875fb7e,0xf228f554,0xec51ef1f,0xe832e9f4,
0xe68ae721,0xe595e62b,0xe361e4a3,0xe026e1df,0xdc2ede2b,0xd83bda23,0xd5b4d6ae,0xd530d556,
0xd423d4ea,0xd037d27f,0xcb55cdb8,0xc7f5c958,0xc714c733,0xc851c76c,0xcbcdc9c9,0xd11cce4b,
0xd68dd3f3,0xdbb2d925,0xe1c5de7a,0xe998e577,0xf253edf6,0xfaeef6a8,0x0375ff29,0x0c2a07ce,
0x152e10a1,0x1ec619da,0x28d923e7,0x31742d82,0x36e0348d,0x39ba388d,0x3b1f3a85,0x3bf83b90,
0x3cf03c71,0x3deb3d78,0x3dd33e12,0x3b9c3cf4,0x370839a4,0x307833fc,0x28ae2c9f,0x211024c2,
0x1a201d8b,0x13a916dd,0x0d991095,0x07c60aac,0x01f204de,0xfbd0fef9,0xf5e7f8c6,0xf1c6f382,
0xefd9f08f,0xeea9ef55,0xec61edb9,0xe8fbeac9,0xe4cee6f7,0xe06ae28e,0xdd6edeb9,0xdc61dcb4,
0xdac3dbd2,0xd67bd8ef,0xd0efd3ab,0xccacce92,0xcad3cb79,0xcb00caa1,0xcdabcc17,0xd205cfb2,
0xd6c4d47e,0xdb18d8e9,0xe050dd89,0xe72de385,0xef0deb10,0xf712f318,0xfeebfb04,0x070402dd,
0x0f4e0b24,0x185113b0,0x21d51d19,0x2a2c2641,0x2fb12d51,0x327c3160,0x33bc3348,0x34573401,
0x351e34a5,0x363535bd,0x36503663,0x347535b8,0x305d32b2,0x29fd2d60,0x228c2655,0x1b391ecb,
0x149617df,0x0e641176,0x08a00b6c,0x034c05df,0xfdcd008e,0xf821fb18,0xf288f539,0xee99f03e,
0xecf2ed95,0xec0dec83,0xea54eb5b,0xe781e905,0xe3b3e5b3,0xdfbee1bd,0xdcfade11,0xdc20dc57,
0xdb2ddbf4,0xd760d9b3,0xd203d4a7,0xcde5cfb1,0xcbf9ccaf,0xcc22cbcd,0xcececd31,0xd360d0dc,
0xd846d5de,0xdcafda86,0xe208df1c,0xe8eae534,0xf0d9ecc7,0xf925f508,0x015cfd4e,0x097d0551,
0x11cb0db1,0x1b061640,0x24a61fe4,0x2d6a2930,0x337330c5,0x36bc355a,0x384237b1,0x390538a1,
0x39f73963,0x3b1e3a96,0x3b923b77,0x3a223b23,0x36453896,0x3044337c,0x28ec2cac,0x219f254e,
0x1b0b1e35,0x14a617c1,0x0ed111ba,0x09360bf8,0x0391066d,0xfd9d00ac,0xf78dfa85,0xf2fcf4f9,
0xf0cbf1a9,0xef50f00e,0xed18ee65,0xe9a8eb79,0xe56ee7a5,0xe0bbe314,0xdd53ded3,0xdbcddc68,
0xda45db3c,0xd618d889,0xd03ed323,0xcb6acd9d,0xc854c9aa,0xc773c78e,0xc93dc800,0xcd34cb0e,
0xd1bfcf8f,0xd5c8d3bf,0xdaacd801,0xe0ffddb5,0xe8a5e4b4,0xf0abeca5,0xf8c8f4be,0x00d7fccc,
0x093e04fd,0x125a0da3,0x1c1c173e,0x251e20d1,0x2bd728d9,0x2fc62e17,0x31dc3103,0x331c3281,
0x348833c0,0x3645356b,0x375036e6,0x36b93756,0x33b2357e,0x2e86315b,0x280d2b59,0x215b24b8,
0x1b681e3e,0x15ad1884,0x106e1305,0x0b6b0df0,0x064c08e5,0x00d203a0,0xfb22fdde,0xf6fcf8d1,
0xf4f5f5c1,0xf3bcf458,0xf1edf2fc,0xeef4f08e,0xeac9ed05,0xe635e874,0xe2cde442,0xe153e1e3,
0xdfeee0dc,0xdbf6de4d,0xd600d902,0xd0f0d346,0xcd8dcf0d,0xcc33cc94,0xcd8bcc75,0xd12ccf2c,
0xd55ed34e,0xd94fd75a,0xdde7db5c,0xe3e6e0c8,0xeb1ce769,0xf2e0eefd,0xfaf0f6de,0x02bcfeda,
0x0a9c069e,0x13370ebc,0x1ca717ed,0x257a2132,0x2c512943,0x307c2ec1,0x329631b5,0x33903322,
0x34b93418,0x363d356e,0x375636ea,0x371c3785,0x347a3612,0x2f963247,0x29372c82,0x227925d2,
0x1c341f44,0x16781953,0x110913b0,0x0bfe0e76,0x06f80987,0x01850449,0xfbbffea0,0xf70ef930,
0xf462f576,0xf2f4f39d,0xf175f24a,0xeed8f047,0xeb0eed23,0xe683e8cc,0xe29be45f,0xe08ee157,
0xdf7ae00c,0xdc9fde67,0xd74fda34,0xd1d3d468,0xcdcdcf9a,0xcb96cc6d,0xcbc2cb57,0xceafccf6,
0xd2e5d0bb,0xd6f7d4f7,0xdb18d8f8,0xe09bddb3,0xe74fe3c4,0xeef0eb0e,0xf6daf2d9,0xfedbfaee,
0x064102a4,0x0000097b,0x00000000,0x00000000,
};

const uint32_t sample_1_nylonstrgtr_nguitb2[2688] = {
0x00000000,0x00e1005a,0x008801b8,0x00b4006c,0x009e0218,0xffefff5b,0x002fff75,0x01840199,
0x003c002d,0x0128001b,0x0045016c,0xffb6ff89,0x00e6fffb,0x012f01b8,0xfff300c9,0xffe40092,
0xff06fee1,0x0016ff05,0x0028ff8d,0xfed1fe94,0xff97ffe4,0xfe440027,0xfedbfe42,0xfe98ffd7,
0xff5ffe7c,0xffccfd13,0xfe42ff70,0xfb7bfc8c,0xfe4dfecc,0xfe05fdf4,0xfd84fdec,0xffb6fc79,
0xfd14fda1,0xfe19fd2b,0xfd14fd26,0x0141fddf,0xfde3ff17,0xfea9000c,0xfca5fd9f,0x0139fcb4,
0xf7f3fefd,0xfa9d0369,0x075402c6,0x12820899,0x13bc0e2a,0x11a21af8,0x28661f05,0x2a491de9,
0x294a253c,0x2401289b,0x238723c1,0x182f1d5a,0x11671a25,0x057b10b5,0xfed60894,0xf646f469,
0xe4cce54d,0xe919e38c,0xdfbce8af,0xd8d4e010,0xd945e807,0xe576ea1b,0xe85ce201,0xe0b5e21d,
0xd0dcce09,0xbd12d026,0xbe89c03d,0xa70db3b7,0xae07ad4f,0xaa28b2fa,0xaab5a26e,0xaad4a47b,
0xbe6fb44a,0xc02eba90,0xdc8ad089,0x029fe8ee,0x1a8d16ac,0x37392a36,0x3f293cb0,0x5c034e53,
0x652261f0,0x642668b0,0x5a8d5d6d,0x657260d9,0x580557ad,0x602360d7,0x69c1609e,0x5fd36941,
0x60755d47,0x5fcd5d12,0x5fb358c0,0x506655e4,0x48564c7e,0x43393cc9,0x3c994d84,0x19232615,
0xf4ce1335,0xe20ae5ab,0xbde7cf70,0xae79ad80,0x98bfa503,0x99559a75,0x8b1b91d8,0x97388be5,
0x9d9a9784,0xb6a3b403,0xc3d3ad7b,0xd24fcca1,0xd69bd1b2,0xd706d3df,0xe5bfdd5c,0xe911e913,
0xf34eee8f,0xeb48f01d,0x0717f79a,0x08a50225,0x180f175e,0x22a41584,0x2deb2a2e,0x2adc2e1a,
0x315138cc,0x4afa3d47,0x48304982,0x4a8b4867,0x396b3c7c,0x3fe242f0,0x177e2249,0xf4c51058,
0xe04ce7bd,0xc611de28,0xbd25baf6,0xaf63b84e,0xb6ccb309,0xa82fb034,0xb14ca79e,0xaa9cad4a,
0xbfa2c651,0xc2aabc47,0xcdc5cdb5,0xdc17d7fd,0xd655dd9b,0xe309d961,0xeb56e52f,0xf2f3ed7f,
0xe006ec75,0xf69bea78,0xfa72f582,0x0d290777,0x17f50d3b,0x28141f79,0x24ac2405,0x2bd62da8,
0x40c232db,0x4429468e,0x4c26466d,0x38f1424d,0x53154b25,0x3c3e40de,0x2c9e35d1,0x0fa11455,
0x03911278,0xf6b3f267,0xf00ef6b3,0xfdd9f3b3,0xf3b0016c,0xff20f026,0xf190efe6,0x07ca03ea,
0x03d0fd54,0x0da80b7b,0x1a1412ee,0x19c2222a,0x20fa19b8,0x27b6262b,0x37772c85,0x1c422f61,
0x235c1d99,0x1e0e1c7c,0x23b025f5,0x1e952382,0x26bf2211,0x20372015,0x16d31d17,0x13a91143,
0x0927124c,0x0b9c06fe,0xe8b4fbab,0xf9c9f3ea,0xec78f585,0xe498ed0b,0xc236cb66,0xbb9dc817,
0xab95ac86,0xa3dfa66a,0xa6519c7a,0xa1afb24c,0xacf2a204,0xa260a4db,0xbee3b37a,0xc455beed,
0xd376cd61,0xe672d590,0xf38ff1db,0xf90ff2df,0x0996081e,0x2beb15f9,0x22fc31bb,0x29142354,
0x29262461,0x34f82e00,0x2c873507,0x361132d8,0x3741355d,0x301c3746,0x2ba12a8b,0x291f3225,
0x32da2989,0x14302588,0x1d8b1313,0x12521bdb,0x11ce15f4,0xe69df977,0xddb5e971,0xca14d5d0,
0xc165c9ae,0xb5d8adfe,0xb7f3c2bb,0xbcb7b468,0xae8fb497,0xc8e8bc11,0xcfa1cee0,0xe4b2dc9e,
0xf663e6f7,0x0dbc02f3,0x10f40985,0x18db1b02,0x31fe1b51,0x35a03fa4,0x340735ec,0x31ab336a,
0x41a13458,0x3dd14229,0x433d3f76,0x4608420f,0x4936481d,0x44354059,0x3fc44a35,0x4f054212,
0x3c254c38,0x39173051,0x33343a3f,0x3a9d3643,0x123121ad,0xff4f0576,0xde81f186,0xd4b0dd95,
0xbed1be74,0xbd64c6dd,0xc15fb9c4,0xadd7bb87,0xb533aa9e,0xbb61b9c7,0xc78cc4d7,0xcd08ca08,
0xe5e5dc90,0xe099e105,0xe5efea24,0xf266df55,0xfe41fe3f,0xfa15fbcb,0xf2d4fb5b,0xf972f170,
0xfa47fdde,0xfc57fcd9,0xfc92fdea,0x080605b1,0x04f7fee9,0x03f40aa2,0x106603b0,0x12091b93,
0x0ed707f2,0x0bdd1476,0x1fb417e6,0x0bb719d4,0xfcb8fd7f,0xe163f0a4,0xe267e60f,0xcdb5cf10,
0xd02ad545,0xd738d089,0xd118db34,0xd4baccad,0xdef2d85b,0xef02e587,0xf03ef13a,0x09fdfbd8,
0x090008f1,0x13bb16f0,0x17770d97,0x2ebc24a2,0x2d722c5c,0x25002eee,0x23171dec,0x27292592,
0x276f246d,0x214f25f0,0x2fd72c54,0x288b2663,0x28e82df6,0x291821a6,0x31ec38f8,0x29aa23c2,
0x1ed026e2,0x280a2146,0x1dfa2c2f,0x0c160fa5,0xec77fe54,0xedabef2f,0xd5badabf,0xd362d63e,
0xd523cda4,0xd45ddbba,0xcea9cf2f,0xd4cdd259,0xe61bdb91,0xe5f9eaaf,0xfc0decf8,0xfd7efa11,
0x09a50847,0x0460042c,0x1c5910eb,0x215e1e3b,0x1e4a265a,0x12681673,0x17bd16b2,0x1c3d15d8,
0x116f164f,0x1db9180b,0x171a176e,0x1ac41cc4,0x0a500bdc,0x1a1e1ca7,0x11ba1015,0x05fd0cd7,
0x0532fec9,0x03f40e30,0xf405f66a,0xce6ae4b1,0xcc35cee0,0xb38cbff5,0xaddbb3bf,0xaa3ba40a,
0xae9caf4c,0xa6d5a90f,0xa962a837,0xb9f7acbc,0xbe7ac451,0xd582c7c7,0xdea7d878,0xf4f4ea60,
0xf283f56d,0x0b6cfe5a,0x1b2e116c,0x255022ff,0x18c11f10,0x1dc01ec2,0x294f20a3,0x23b829b4,
0x31592ab9,0x2e9b320a,0x3d9436cf,0x2a292e10,0x3c793993,0x38b639a7,0x353b39c1,0x2bea2968,
0x346d3913,0x2e0e2b3d,0x0c052020,0x022702ce,0xe964f6b2,0xdf39e7d4,0xd14cd42f,0xd809d6ca,
0xcee8d346,0xcbd2ceae,0xd5acc711,0xdb77de43,0xea9ee06e,0xf035ed34,0x05b4f802,0x02a007bb,
0x10340886,0x1eb4177c,0x2f5326cb,0x22af2872,0x1e7321fc,0x25c51d00,0x229426e3,0x29962356,
0x211f2a53,0x33f7297b,0x1d73260b,0x273021cf,0x22dd2628,0x253c266c,0x104114a5,0x180b1c0c,
0x148d12c7,0xf9ed0e89,0xeb6dec97,0xd37ddfb9,0xca26d01b,0xb5cabde8,0xbadbb790,0xb2d4b8d1,
0xafb7b62a,0xb254a830,0xbc7dbcd9,0xc935c08a,0xcf51d05c,0xe46dd4bf,0xe8dee908,0xf112eb24,
0xfd70f8c9,0x1566090b,0x12ec1593,0x0bde12b2,0x10dd0aab,0x14f7167d,0x1bbe119d,0x13c11e22,
0x27161b84,0x191722fc,0x1e221891,0x1d8320ce,0x2b762586,0x16461c38,0x1e2f1c79,0x1f05197f,
0x0fd620aa,0xfdcd027e,0xe85bf419,0xe161e4e1,0xcc19d7e0,0xce1dc840,0xc8f4ca8d,0xc99dce49,
0xc5d4c007,0xd3f8cf73,0xde71d649,0xe789e933,0xf82bebce,0x04c301bc,0x0c3f0628,0x14a112ec,
0x2c591e0e,0x34b331fc,0x2fa535b0,0x296329a0,0x31513141,0x34042ae0,0x2f52376d,0x38bd2f22,
0x367f3c4d,0x32c92f84,0x2efc3502,0x3cf534e4,0x2b9f35f1,0x2c4b2be7,0x292125ec,0x256c2e76,
0x0f6717e2,0xf6460383,0xe7efed02,0xd383e284,0xc868c91b,0xc05cc42f,0xc256c4d6,0xb471b8f3,
0xbef3b94f,0xc42abd67,0xcf25cd9c,0xd5ebcf12,0xe612e048,0xec23e66a,0xf25ff286,0x03e9f8b0,
0x125f0bb0,0x15db1686,0x06e60cc8,0x0f480eda,0x103109df,0x0ffd1654,0x12da0c7c,0x197b1bc3,
0x14e11179,0x112e168a,0x1f4f1414,0x164a1fb6,0x15ee166d,0x107b0f33,0x164f1922,0x07630e28,
0xf336fe3d,0xe25fe698,0xd4f7e074,0xc8b7ca3e,0xbf66c2ef,0xc60ec330,0xba58c269,0xc2ecbe27,
0xc846c213,0xda24d396,0xdeeddb8b,0xf261e9ff,0xfd19f573,0x04e10467,0x113208c1,0x23d11b93,
0x314d2b5d,0x211c2929,0x271726f5,0x25b920cc,0x2d382e7a,0x27602693,0x33283255,0x2f1f2cfa,
0x29793102,0x31b626e7,0x2f2d355c,0x2d5a2e51,0x21cd23fd,0x296f2795,0x1ca42402,0x0b1e166c,
0xf3e4fb39,0xe841f31d,0xd9bedeba,0xcbfcd26a,0xd0efcae3,0xc5cdcdc1,0xc841c5d7,0xc932c6d8,
0xdbbbd232,0xddf3ddba,0xef4ce770,0xf961f213,0x0314ff6e,0x089a03fa,0x1675115a,0x2c16204a,
0x1ea027ad,0x1f3a206c,0x1943193a,0x25542121,0x1a3c1cea,0x26432299,0x2080213a,0x1be223a6,
0x1c16156c,0x1bdc2147,0x1cb51ce7,0x0d7213de,0x11960e32,0x0afe100f,0xffe7084a,0xe4eeee3a,
0xd8cfe1c6,0xc9c8d06a,0xb96dc3e8,0xb9dab48f,0xb2e8b98c,0xb29eb190,0xaf7fb14b,0xc0ddb55b,
0xc657c558,0xd52bce38,0xe150da68,0xf05fe962,0xf666f149,0x0244fe71,0x1d900ca5,0x1b7a205f,
0x1e211c99,0x14de1983,0x25af1c41,0x1dc5226e,0x2a8323e4,0x285c2794,0x2b672f88,0x26b221ff,
0x2be72cb1,0x310b2e52,0x258f2ca3,0x28a42414,0x25e229e1,0x24ab286c,0x0b8716b4,0xfe4604fc,
0xef12f4c0,0xdeabea72,0xd6bcd498,0xd242d708,0xcec8cebe,0xc7facd41,0xd274c8f3,0xd9d7d703,
0xe4b8dedd,0xebf2e938,0xfa5df31f,0xff93fb32,0x04ee0613,0x1bdb0bf4,0x22d823a9,0x23d02238,
0x155c1e3a,0x21a9176f,0x1b2e21c0,0x236a1d2c,0x1f012054,0x25452726,0x1c021c3a,0x1e831eef,
0x255520a1,0x1e8d2554,0x1beb1878,0x19141c22,0x1d131c90,0x07bb140a,0xf8a9ffba,0xe728ed6b,
0xda62e4f5,0xcad7ce15,0xc7b7cb4f,0xc419c318,0xbcbec486,0xc041ba43,0xca21c61f,0xd40dcdba,
0xd9d3d878,0xe925e188,0xf07cea1b,0xf661f79e,0x05caf8cb,0x14f411f5,0x1b9216c9,0x0d9f1962,
0x1155096b,0x0fe915e0,0x16a40fd3,0x122213e8,0x1b8019d2,0x13bc15a2,0x14cb1492,0x1a0315b0,
0x1b5f1fd8,0x174215bd,0x135b1639,0x1a5315c5,0x0d0417b6,0xfe07054f,0xeb89f247,0xe346ea95,
0xd0a1d751,0xce99d07c,0xca1ac8d1,0xc7cbcc16,0xc635c433,0xd09ecc3b,0xde55d4ee,0xe552e4a1,
0xf5a6ed6e,0x0002f805,0x0a1408c6,0x129008cc,0x272520b1,0x30f52a1f,0x2b4b343b,0x25e521ce,
0x27e82c9e,0x2e56279e,0x28382b8e,0x31bb2df2,0x2b3b2e4f,0x295829e8,0x290e265e,0x2cd92fbb,
0x26162763,0x1ebf2374,0x21241c99,0x19132185,0x0a3511c9,0xf231fc7a,0xe91dee7a,0xd20bdda1,
0xcb27cf50,0xc1e6c39d,0xc102c32e,0xb87ebbbf,0xbe24bbd8,0xc993c040,0xd175d089,0xddbcd786,
0xe5c6e001,0xf4ecf0c8,0xf644f219,0x0c1b0348,0x18d9107f,0x1ef92225,0x132c12cc,0x1651195e,
0x1ddf167c,0x199c1d68,0x21c01d03,0x1f98224b,0x1e9f1f9b,0x1b10196f,0x232a2205,0x1ed01fff,
0x19ae1eb5,0x198015c0,0x17ff1c4f,0x0fe91470,0xf82d0457,0xeee3f175,0xda70e5b7,0xd060d567,
0xc492c8d9,0xc5f0c53b,0xbbf5c10c,0xbe7fbe35,0xc6a5be6d,0xd064cd89,0xdc73d59e,0xe157de65,
0xf40cebd2,0xf43ff33b,0x07bdfdc2,0x12f70c1c,0x2547216e,0x17991aba,0x18601ba3,0x1de71764,
0x1da52023,0x23a91e34,0x24d2269c,0x275a26bf,0x202e2168,0x298025d6,0x2887287c,0x26ea2acc,
0x228620de,0x249625ab,0x224c23a4,0x0da41acc,0x030f055f,0xf1e4fbe8,0xe65bec20,0xd86fdf39,
0xd7f6d60f,0xce8cd3fe,0xcd4acec3,0xd040cb61,0xda21d6eb,0xe622df5b,0xe74ee7ab,0xf947ef9d,
0xf9c2fb09,0x087dfe63,0x0e9b0b34,0x27131d5b,0x1ad51fe4,0x171f1b9a,0x166d136e,0x181c19f9,
0x1a0115ee,0x19021ba6,0x1bd71a72,0x120c1705,0x17761365,0x168b16ac,0x178b1a37,0x0f681089,
0x10ef110c,0x12200ff0,0x04600ffe,0xf6cffaea,0xe705f033,0xdb5ae032,0xcc08d593,0xc832c6fe,
0xc2a0c5a8,0xc18dc304,0xc0c3be65,0xcb55c709,0xda8dd138,0xde20de88,0xee9ee3e4,0xf475f539,
0x0258f7cb,0x06cf0633,0x237414c4,0x21ed241d,0x1ee72220,0x19f819c2,0x1f141f61,0x1f581c38,
0x1f852152,0x23f620db,0x1b5f21a3,0x1ddd1a49,0x1c331cc9,0x21ba20ef,0x18781c60,0x183418e9,
0x18f615d1,0x11d31ab8,0x011b0755,0xf2f3faab,0xe584ea43,0xd68fe0d9,0xce70cf5e,0xc7c0cb50,
0xc709c81c,0xc305c32d,0xc9aec720,0xd92ace9e,0xe037df9e,0xeb10e1f3,0xf597f48e,0x024cf76c,
0x063b078b,0x2037107f,0x28432716,0x29282a18,0x200622d6,0x25ca2483,0x26b52435,0x28002936,
0x2b1e279b,0x26412c35,0x25232348,0x220023c1,0x28cb2580,0x20e425e2,0x1df7205b,0x1ab61935,
0x1a611e96,0x09ac11da,0xfb18038c,0xeae8f034,0xdcb9e6a0,0xceead328,0xc55dca32,0xc447c4cc,
0xbc57bf3b,0xbd32bd93,0xc839bf4e,0xd38cd147,0xd848d217,0xe51ae31f,0xf04be5cb,0xf44bf67b,
0x06dcf980,0x16ab11cb,0x1d691aee,0x12f717e7,0x161a14da,0x17301549,0x1b151adf,0x1e531a11,
0x1ebc220f,0x1cfb1bca,0x19a01c34,0x209e1b46,0x1dde2111,0x1d0c1e6b,0x17d317c0,0x1d181bbf,
0x113a1839,0x05930cc9,0xf420fa8b,0xe946f13e,0xda7de033,0xce7ed528,0xcd71ccff,0xc60ac915,
0xc543c67d,0xc9f7c493,0xdafdd490,0xdc31d91a,0xe9e2e706,0xf2cfe9a8,0xfb1dfb3f,0x059bfbb8,
0x177310cd,0x24d91ecb,0x1c0821dc,0x1b811af2,0x1b451a67,0x20281f52,0x204e1db1,0x22cb245c,
0x1fac1fd2,0x1bcd1f88,0x20011ad2,0x200621b2,0x20a32196,0x189f1bd4,0x1e761a92,0x177b1ce7,
0x0ee4145c,0xfbec041f,0xf204f836,0xe31de927,0xd4d6dd40,0xd10dd122,0xcb20ce02,0xc97ecaef,
0xc657c635,0xda26d00b,0xdac4d9c3,0xe87ae46c,0xee0ce7bd,0xfaa6f817,0xff4ef94a,0x0fdd0936,
0x221c1890,0x1fea2407,0x1c571d4b,0x180f1935,0x1d6b1bca,0x1bcf1ae9,0x1fd81f8d,0x1c371cd3,
0x18821d18,0x18121505,0x1914196b,0x1bee1acd,0x130e1865,0x151811a2,0x11ec1592,0x0c79102e,
0xf97f033d,0xef78f4aa,0xe1f3e773,0xd295dbb8,0xca7fcc94,0xc4b5c7b1,0xc3e8c3c2,0xbbf7c089,
0xce40c26e,0xd180d072,0xe02fd9e2,0xe337dfee,0xf475ee00,0xf873f46e,0x070900ea,0x1acd0f27,
0x2202225a,0x201e209c,0x19cc1c5e,0x20921d31,0x1f0f1f55,0x2534229a,0x22dd22fe,0x219d252a,
0x1ee01d87,0x1f6d1fcc,0x23b720f4,0x1d642352,0x1b63197b,0x1a701c64,0x18e71980,0x084d1229,
0xfbde0227,0xeeeff3f9,0xe00be938,0xd363d84d,0xcbc5cf9e,0xcb38c98a,0xc030c8a7,0xcb00c126,
0xd09bcf85,0xdf16d76a,0xdfccdf81,0xf0d9e8b0,0xf526f258,0x0078fb3f,0x11c3069d,0x20691ccd,
0x221b2124,0x19dc1eb0,0x1e521a93,0x1d661ec6,0x245920b7,0x21a121e8,0x228a245e,0x1da31e66,
0x1d441e2a,0x214a1d56,0x20b9248a,0x1b671bd4,0x1a311c08,0x1b3c19bd,0x0f2c1752,0x019408d1,
0xf438f970,0xe735ef11,0xd7d6deb4,0xcd43d2f4,0xcb39c8ed,0xc1dfca99,0xc3c9bdc3,0xca2fc935,
0xd81fcf22,0xd8feda80,0xe700dec2,0xed97eab7,0xf783f2ff,0x03f8fb0b,0x168f0faa,0x1dd91a7b,
0x16bf1c5f,0x16f61426,0x1680185c,0x1d821983,0x1b201bdc,0x1db11dbd,0x19401b0d,0x187f197e,
0x197816b5,0x1e821e91,0x18831a06,0x16bf1900,0x18e915c4,0x12f11827,0x07380e0b,0xf903feeb,
0xef02f490,0xdf80e719,0xd3b8dacf,0xcea2ccf3,0xca87d11c,0xc57dc371,0xcb1aca65,0xd92dcf2f,
0xdd37de05,0xe775e041,0xefe6ec6e,0xfa73f5cf,0x02cbfc9b,0x16170d9f,0x226f1c94,0x20bb24e5,
0x1cc41b81,0x1b5f1dd0,0x21ac1d29,0x204f217b,0x22f521d8,0x1ea92112,0x1d7c1eba,0x1a0e1a14,
0x21a41ee1,0x1ca41ea1,0x197e1cb6,0x19231712,0x178b1a0c,0x0e9a147e,0xfef90654,0xf55ef9c9,
0xe5ffed98,0xd9b8e174,0xcdf9d002,0xce4ed153,0xc459c5ec,0xc7aec7e2,0xd258c94e,0xda8fd9a6,
0xe190dbfe,0xe98be65a,0xf523efc2,0xfb68f71e,0x0c250387,0x1b6d1392,0x218e2281,0x1b601bf9,
0x18e51b93,0x1d70196d,0x1dec1f11,0x20541e7a,0x1cc41f35,0x1c2e1c90,0x156c1865,0x1cb7185c,
0x1a841bdd,0x17811acc,0x143613c0,0x14bc1518,0x100d13b3,0x00ab098c,0xf683fa5b,0xe7eaef8d,
0xdd4ce3dc,0xcadcd192,0xcd54cd4f,0xc203c5e1,0xc286c37d,0xc80cc163,0xd4afd142,0xdad1d604,
0xe219df1f,0xee6be827,0xf45cf16e,0x02d6faa6,0x125109bd,0x20f81d39,0x1cef1de7,0x19881c8b,
0x1c04189a,0x1f531f3c,0x22121ffe,0x201a21fe,0x20ac1fd1,0x19521e0f,0x1da519cf,0x1ebc1e5b,
0x1e662068,0x190b1aa3,0x194d18d9,0x18cb196b,0x0cd41522,0x01d905db,0xf3b8fb72,0xebaef013,
0xd547e047,0xd54fd469,0xcac9cfd8,0xc920ca9c,0xc7d5c559,0xd5b1d05c,0xdc19d7cd,0xe1cadfbe,
0xed52e6ce,0xf412f1a7,0x003ef8c8,0x0c95056c,0x20271890,0x20452098,0x1cd41ff7,0x1afc19a4,
0x1f1f1e2b,0x21ab1fa6,0x204f2277,0x20e01ef8,0x1a721fd6,0x1aa71895,0x1c391b16,0x1e8e1eb9,
0x18b41b98,0x16821703,0x178c1669,0x105e1702,0x042708e8,0xf595fe11,0xef3cf11b,0xd895e5f0,
0xd372d343,0xca33cf9d,0xc794c8eb,0xc124c281,0xcd32c74e,0xd510d0b6,0xdabed8a2,0xe37edda4,
0xeb81e90b,0xf6b5ef9e,0xfffdfafb,0x153d0ae5,0x1ba619b7,0x1b241d51,0x15671680,0x196a17c2,
0x1c771a55,0x1d191ea4,0x1cfa1aed,0x19af1dda,0x16f816c0,0x179116c4,0x1c7c1a66,0x19291bd6,
0x157e1731,0x159213f2,0x145717af,0x09b90e1e,0xfbe104b8,0xf5faf62b,0xe3d6f0b2,0xd895dac1,
0xcfa5d547,0xcd9fcddc,0xc48fc89b,0xcbf7c730,0xd58cd072,0xdcf8da54,0xe3c4deb3,0xec7ae9eb,
0xf7c7f0a6,0xff03fbf2,0x12bd0781,0x1ea11a28,0x230622a8,0x1bc61f07,0x1da91c25,0x20751e48,
0x23982413,0x215e2056,0x20992319,0x1c431d7a,0x1a491ae0,0x1efe1bfd,0x1e791ffc,0x1a771d19,
0x1773172f,0x19a91a47,0x115b14e4,0x044e0d4e,0xfac5fbfb,0xee50f8c8,0xddb5e316,0xd36ad9e1,
0xd041d062,0xc6fccc2a,0xc800c5b9,0xd02bcb8f,0xd97cd5d9,0xde2dda80,0xe61fe3b1,0xf03ee95f,
0xf705f517,0x066dfc84,0x15370ee3,0x1ee81b7c,0x18ee1cfa,0x17f41772,0x1926179f,0x1ed91db1,
0x1baa1bde,0x1bee1d06,0x179a196f,0x13ad15f4,0x164c136a,0x18e818ad,0x16cf18c0,0x109e12d9,
0x145712e7,0x0f1e1177,0x05dc0d60,0xf854fbde,0xf21ef876,0xe020e6f7,0xd38adb25,0xcecbcf17,
0xc7d9ccbd,0xc446c46e,0xc961c605,0xd52bcfd2,0xda36d6f6,0xe212df72,0xeb51e499,0xf46cf1a9,
0x002af823,0x100708a0,0x1f3f1808,0x1e602160,0x1ba21be8,0x1ab61a75,0x22c51f67,0x2062213c,
0x21c0219a,0x1eda201e,0x1b061dac,0x1a63192c,0x1df11c9e,0x1f751f61,0x17261ba8,0x19a717b3,
0x16a717e7,0x12751749,0x01960813,0xfe5001a8,0xed8cf4ef,0xdf15e751,0xd631d867,0xd0b2d4be,
0xc9c5cbeb,0xc9d6c8e8,0xd560cf5f,0xdaa4d7d6,0xe27adfa8,0xe89ce3a2,0xf2fbef81,0xfbbcf5ab,
0x0a360365,0x1aee11e1,0x208820d8,0x1d9f1e67,0x18e81ae0,0x20511c25,0x202920f5,0x20842076,
0x1dcf1f1e,0x1a271ce1,0x16591707,0x182f174c,0x1ccf1a66,0x15531ace,0x14bc13b2,0x119f1318,
0x12ec139f,0x01130a27,0xfcfbff23,0xeedcf5cf,0xe021e898,0xd293d78d,0xcd7fd0d4,0xc679c91d,
0xc22ac3e4,0xcadbc547,0xd108ce04,0xda11d686,0xddd7da82,0xe928e473,0xf0f6ec44,0xfdf8f7a4,
0x0e4304ba,0x1af31773,0x1b681b42,0x155c18e3,0x1a88163c,0x1d781d2f,0x1ec11e2c,0x1cfc1de0,
0x1b5f1cd0,0x1693184d,0x16b7169a,0x1ce61882,0x1a001e17,0x1790174e,0x13ca1629,0x1959160b,
0x0ab61407,0x04e506c9,0xfa2dffd8,0xede0f4f5,0xdd18e489,0xd706da04,0xd081d31d,0xc96bcd3b,
0xce88c9d6,0xd4cdd1fe,0xdf17da6c,0xe1c7e006,0xec05e6f7,0xf38aef68,0xff6df9a0,0x0cba044e,
0x1d5016f5,0x22912080,0x1d002142,0x1d9a1b28,0x21862071,0x23362294,0x211a2235,0x201e20fa,
0x1ab91d40,0x180919c7,0x1bf917dc,0x1cf71f29,0x18e7199f,0x12ee1750,0x17d51304,0x0edc1681,
0x06590939,0xfc8d0203,0xf27cf824,0xe02fe93a,0xd6a9dafe,0xcf6bd22b,0xc745cc55,0xc782c506,
0xcbb1c9e5,0xd6b2d0c4,0xd9c9d8e1,0xe226dd45,0xe95ae5dc,0xf4c8ef2a,0xff05f876,0x10d108d9,
0x1b32167a,0x19131c9d,0x155d154a,0x197e179e,0x1d421b8a,0x1be51d0a,0x1b951bab,0x17721991,
0x13a4165d,0x13e01148,0x18f71872,0x16541691,0x10271592,0x12690df3,0x1058149d,0x07c00b03,
0xfe9e03c1,0xf74cfaec,0xe6e4efec,0xdab0e02b,0xd2ddd59f,0xcb89d091,0xc851c79b,0xcab0c9cb,
0xd51acec8,0xdaded940,0xe1eedd60,0xe8a1e58a,0xf47eee6c,0xfd67f83b,0x0e9105dc,0x1cfb15b8,
0x21ef224b,0x1c9b1e4f,0x1ec71d4b,0x23f72137,0x23e324fe,0x23b42386,0x206b221f,0x1d8b1fed,
0x1948199a,0x20021d8b,0x1f3a1ec8,0x1aa51fbe,0x17241586,0x19891aa0,0x1163151d,0x07f50d90,
0x012f03d5,0xf33afbab,0xe486eb87,0xd986dd86,0xd231d71e,0xcb5bcceb,0xca38cb2b,0xd0ebcbbf,
0xd83fd615,0xdda0d9fe,0xe273e06f,0xed7fe740,0xf51ef182,0x0357fbc6,0x12350a49,0x1d3e1a23,
0x18741b46,0x17201727,0x1bdb189e,0x1d8b1e18,0x1d661d31,0x1a231be7,0x18b919da,0x111d1439,
0x16f113dd,0x17821650,0x168619cb,0x0edb1062,0x12c211b2,0x0e181071,0x05f10b2d,0xff150168,
0xf4a8fb43,0xe661edb9,0xd884de1a,0xd1add5f2,0xc969cc12,0xc6fec8a7,0xc9e2c666,0xd30ecf8a,
0xd910d551,0xdda8dc27,0xe78de14c,0xf01aec82,0xfcaaf5b1,0x0a8a02f1,0x1ad31407,0x1b581ca2,
0x186e19b4,0x1b54186f,0x1f8f1e95,0x20c32022,0x1e081fe6,0x1e861e05,0x16481b02,0x194816be,
0x1a471907,0x1e511e3a,0x150118fb,0x17d31611,0x167f1755,0x10ba1500,0x08e30bc3,0x01110612,
0xf4f5fb93,0xe4a8ebf0,0xdce9e10a,0xd384d75c,0xcfded200,0xce65cd54,0xd705d33b,0xdd6fd9a6,
0xe1f6e0cb,0xe8efe3eb,0xf142edd7,0xfbd9f5d6,0x071d010c,0x18ee0fe4,0x1f231e0e,0x1c021e52,
0x1b1219df,0x1fa41df7,0x219a2099,0x1e582110,0x1e9c1d60,0x168a1c34,0x15f814e3,0x14c71518,
0x1b411877,0x127c17ec,0x114810b9,0x10ce10eb,0x0da91092,0x054508a4,0xfe1a026f,0xf499f9df,
0xe376ec0c,0xd9bbde36,0xcedad3e6,0xca82cc9c,0xc534c6e2,0xcb8bc7e3,0xd260ce74,0xd846d67d,
0xdd75d977,0xe63ae25b,0xf0bcead9,0xfb05f5f1,0x0c7702a0,0x18ec1458,0x19a61adb,0x163416d2,
0x1a93183f,0x1e791c5b,0x1d6d1fb6,0x1da31bab,0x18c81d55,0x165015e2,0x1381151e,0x1b4a1658,
0x17551b84,0x13611461,0x12cf12d0,0x12cf140e,0x0bfb0f01,0x05150927,0xfe6c01c4,0xef2cf7b4,
0xe3fde8ac,0xd7beddf7,0xd2eed4ac,0xcc34cf42,0xcf11ccb4,0xd55dd17c,0xdd5bda7a,0xe0edde58,
0xe8a5e4f8,0xf2a1ece4,0xfc51f7f6,0x0a8401f0,0x1a401336,0x20aa1f4f,0x1c961e97,0x1ee81d20,
0x23262066,0x246d25f7,0x22e421bf,0x200223a1,0x1ba61c64,0x172b1a49,0x1c20176b,0x1c951ec6,
0x1786198a,0x14281558,0x15571546,0x102912bc,0x090c0d4d,0x02d10566,0xf5b9fdde,0xe8a4ee27,
0xdb0be26c,0xd39dd622,0xcb4fcfc3,0xca2fc9a8,0xcd71cafb,0xd60fd25f,0xd937d774,0xdf01dc08,
0xe78ee261,0xf0d8ed15,0xfbbdf507,0x0bd403c0,0x17d31362,0x157717e7,0x15a614c7,0x18d3162f,
0x1d341ced,0x1ad61abb,0x1a491c4b,0x15b916b7,0x111014ba,0x121b0f1e,0x16fe1652,0x13c71551,
0x0f271130,0x10bb0fc2,0x0e5d0fc7,0x08d50c8a,0x03760544,0xfa620094,0xedc5f32e,0xe04de7e5,
0xd738da31,0xcfd8d420,0xcc8fcd2f,0xccd5cbeb,0xd5ded10f,0xdae3d8b5,0xe03adda8,0xe774e2b9,
0xf22ded74,0xfbd9f647,0x0a53028d,0x1a7112df,0x1cf11df1,0x1bd71bff,0x1c7c1b06,0x23f12172,
0x21b1223e,0x22a3236a,0x1dda1f61,0x1a361d69,0x16861646,0x1c801a58,0x1c1a1c93,0x167819ae,
0x15b5157a,0x14b41538,0x10fe13d2,0x0a970ce4,0x040b08b4,0xf7f3fd58,0xea93f27a,0xde04e2b5,
0xd5f5da67,0xd0aed279,0xcd93ceae,0xd41fcfc9,0xd9a2d765,0xde33dc26,0xe2cddf8e,0xeceee81a,
0xf569f0f6,0x00fefadd,0x11e608de,0x19cf184d,0x19c21a06,0x16e617a2,0x1ea91ad3,0x1d3e1e67,
0x1eaf1e82,0x19911bb0,0x17021943,0x0ff8123b,0x144111fd,0x169d15b4,0x11d51520,0x0ecf0fa1,
0x0db90e1c,0x0c440dcc,0x060b08aa,0x01a204ee,0xf679fbb5,0xeacaf1cc,0xdc7fe291,0xd391d846,
0xcd82cfc8,0xc8e5cb2f,0xcc19c8ed,0xd2c3cfc4,0xd8dbd62c,0xdc19d9ef,0xe5d8e09f,0xeef9ea60,
0xf968f427,0x0953ffd7,0x16d7122a,0x1b31197e,0x17a519cc,0x1e7e19df,0x1fd62007,0x225c213c,
0x1e2b209f,0x1dc21e43,0x162619bd,0x173515fe,0x1b5d191d,0x19cc1bd2,0x164617af,0x13d014c4,
0x1461146c,0x0ef711a2,0x0bf50de7,0x02410733,0xf945feb5,0xea12f146,0xdf1ee4a3,0xd723da23,
0xd146d4a3,0xd030cf16,0xd56cd2d7,0xdc62d908,0xdf01dde9,0xe65ae1f0,0xef60ead4,0xf8a6f47c,
0x04a0fcf1,0x147a0e01,0x1c8e18f0,0x19131c5a,0x1c8018d0,0x1f701f09,0x22bb20ba,0x1eb021b7,
0x1dfd1dff,0x16811adc,0x13a5143f,0x16ef1470,0x17d718a4,0x144515f0,0x0ff81208,0x107f1006,
0x0c120ecc,0x09ae0ad1,0x011605e2,0xf954fd7d,0xeac0f249,0xde02e453,0xd4a0d841,0xce49d1e6,
0xc9e2cac0,0xccfacb00,0xd3fbd051,0xd740d649,0xdc5fd8eb,0xe4a1e056,0xee80e9fd,0xf823f20e,
0x08a000dd,0x14de0ebf,0x159917c6,0x15e513b2,0x1a0018d1,0x1e2b1b48,0x1cba1efe,0x1c171baf,
0x170a1a6f,0x1234143f,0x13df11ce,0x17471694,0x15c9169d,0x113d13db,0x116d1078,0x0ec210ce,
0x0db70dae,0x07340b70,0x011a041c,0xf559fbf0,0xe86beee5,0xdcf3e1e7,0xd6c5da11,0xd0fdd311,
0xd0f7d069,0xd749d361,0xdc70daad,0xe072ddef,0xe6f0e341,0xf1e3ec8a,0xf97cf523,0x082f00ce,
0x16ce0ef4,0x1d5a1cef,0x1b121af7,0x1ea11d69,0x23191fcc,0x23e2255a,0x221c2216,0x1e832147,
0x187f1b81,0x15e715ea,0x19651808,0x19881979,0x14dc1835,0x1279125b,0x1040125e,0x0ef90eb4,
0x09e30d9c,0x03ec0681,0xf9cdffc0,0xed24f3c9,0xdf0de584,0xd738db04,0xcfe0d323,0xcc88cdab,
0xcff6cd18,0xd5f6d3a4,0xd981d78d,0xddf1db78,0xe859e2c6,0xef72ebf1,0xfbebf56e,0x09ea01f0,
0x163e1251,0x14c4156c,0x1730164c,0x1a9d17a7,0x1e961e2b,0x1cd91d3b,0x1ac51c80,0x15941865,
0x10a1124c,0x1304119d,0x14c913ca,0x12d014e3,0x0f0f0fe6,0x0d500f27,0x0c1b0b9d,0x09cc0c2e,
0x046606b2,0xfceb0168,0xf247f817,0xe397ead4,0xda58de5a,0xd310d685,0xce5fd089,0xcedccd69,
0xd567d259,0xda1ed7b1,0xdce9dbd3,0xe67ce0b3,0xee62ead7,0xf984f3ac,0x05d6fea4,0x17240f91,
0x193a1948,0x1b931a97,0x1dac1b6c,0x2390218e,0x22e72339,0x21d722e6,0x1dfb2042,0x17901a8a,
0x17da171c,0x19c91883,0x1a4e1b1c,0x15d31793,0x13e3158a,0x115b1187,0x113d1238,0x0c150e84,
0x05540949,0xfcbe0138,0xee22f605,0xe223e76c,0xd9daddbc,0xd366d699,0xcfe4d08c,0xd43ad1ce,
0xd957d686,0xdba0db41,0xe23fdd7b,0xe9b0e659,0xf3cdee66,0xfd14f7ff,0x0f2705c4,0x155d13f7,
0x17ca16fd,0x17b61705,0x1dbb1adc,0x1ede1e8d,0x1de91ebc,0x1b191cca,0x145017c9,0x12191274,
0x128611d8,0x15141482,0x10d712dd,0x0ecd104c,0x0ab90bfe,0x0bf80bc1,0x089e0a5d,0x03180668,
0xfc61ffc0,0xefe7f730,0xe287e8bf,0xd8e3dd57,0xd282d5a1,0xcc9bcef0,0xced3cd15,0xd403d0c3,
0xd7bed705,0xdc87d8d7,0xe403e0c6,0xee37e86a,0xf665f2a5,0x0742fd83,0x12aa0eb3,0x17de15ea,
0x176d178f,0x1d0d19c9,0x20641f11,0x208620f9,0x1f451ff3,0x197b1ccf,0x161f1712,0x14de1524,
0x18af16e2,0x169d182f,0x14ee1606,0x0fda121f,0x10b0100a,0x0f66104b,0x0afe0dd8,0x055d07ff,
0xfc2201b2,0xee32f508,0xe27ae7ed,0xdb9bde89,0xd418d7db,0xd30cd2d2,0xd6bdd3f5,0xdbadda5d,
0xde0edbeb,0xe48be188,0xedd0e83c,0xf58ef2ca,0x02c6fa40,0x10ef0b16,0x19091593,0x18e519a7,
0x1c6e19d0,0x20b91eb3,0x21d72208,0x20fb2168,0x1b941f11,0x1672184c,0x12ff14a4,0x160713df,
0x15371664,0x13fc147f,0x0e61117c,0x0cdf0d12,0x0c4d0ca8,0x09510b8a,0x038e064b,0xfca100f3,
0xefd2f692,0xe21ee8d2,0xd9badd14,0xd1d9d609,0xcdf7cf2f,0xcf08cd6f,0xd4b6d281,0xd6ddd56f,
0xdc57d9e5,0xe434deed,0xed47ea09,0xf739f077,0x0637ff86,0x11f00c5b,0x14b314a1,0x16a114f5,
0x1b8118e3,0x1eae1dca,0x1f151eba,0x1c0c1e9f,0x16fe18da,0x12d8152a,0x142c1261,0x14fc156d,
0x154a14d7,0x108913bc,0x0d820e4d,0x0d6f0d35,0x0d080de7,0x08650aab,0x03560637,0xf972fefd,
0xeb9ff2ea,0xe14ce565,0xd952dd8c,0xd418d631,0xd1fbd20b,0xd76ad48e,0xda34d8c9,0xdeeadcd1,
0xe4a8e084,0xeec2eaa7,0xf626f14e,0x043bfd57,0x11cd0b02,0x182716a2,0x197b1892,0x1d721b19,
0x21fe2031,0x23372278,0x21dc2390,0x1c601ec3,0x175c1a30,0x15e01561,0x16e11725,0x179016a7,
0x1489170e,0x0f8511a2,0x0e180e37,0x0e9c0ea8,0x0aae0cff,0x05fe087d,0xfe4602b7,0xf15ef8b9,
0xe4b1e9f8,0xdb79e025,0xd507d7ea,0xcfbad1cc,0xd30fd080,0xd5a4d488,0xd9f5d80a,0xdd37dabe,
0xe792e2b0,0xedd2ea2e,0xf9ddf39f,0x077c003d,0x12030e30,0x143f1383,0x16d31510,0x1bd7198e,
0x1e2a1d0d,0x1eb81f66,0x199c1c04,0x14f817bd,0x114b11ff,0x124e1257,0x13271200,0x13081409,
0x0e301088,0x0ab90bfb,0x0bef0b32,0x09f60b77,0x06410834,0x008603a9,0xf674fcaa,0xe903ef19,
0xdf17e407,0xd889db3f,0xd1c7d530,0xd2c3d0f7,0xd59fd46b,0xda51d805,0xdc14dade,0xe5bce06f,
0xecb6e955,0xf718f1a9,0x03effce7,0x11ac0ba7,0x16f5152d,0x18cd17c5,0x1e281b46,0x21591fdb,
0x240a2342,0x201b2272,0x1b921e22,0x164c1830,0x16b4169d,0x16d01646,0x182b17fa,0x143516b0,
0x0f05114d,0x0ef40e5c,0x0e910f45,0x0b640d03,0x069908f5,0xff500413,0xf1bdf85e,0xe5feebd7,
0xddd7e114,0xd63cda95,0xd396d375,0xd4c3d45e,0xd941d688,0xda60da0f,0xe1b9dd0b,0xe88de56d,
0xf179ecc3,0xfc39f63f,0x0a88039b,0x136c0fea,0x151614bd,0x197916eb,0x1ced1b4a,0x21351f4f,
0x1ea020a1,0x1aac1ced,0x141516eb,0x13211369,0x12031220,0x13f3130b,0x124c13c3,0x0c5e0f9c,
0x0a7b0a70,0x0b070b29,0x09490a66,0x04c206f9,0x0010032a,0xf40ffa64,0xe787ee06,0xddf2e1b3,
0xd69fdb00,0xd158d293,0xd131d166,0xd56fd265,0xd740d74f,0xdc81d8b3,0xe37fe02e,0xec27e78d,
0xf5a7f082,0x0387fc66,0x0f9c0a14,0x143512d3,0x183015b2,0x1bdd1a3b,0x21981e7e,0x2145227d,
0x1e731ffc,0x17f41b3c,0x160216a4,0x145314f2,0x15e214bd,0x16ba16b9,0x122a1522,0x0daf0f13,
0x0e1f0dca,0x0e210e65,0x0a400c5a,0x073c0918,0xfddb033b,0xf1aaf81f,0xe5bceade,0xde4be25b,
0xd6eed9b0,0xd4d8d5eb,0xd6f4d4a6,0xd9d8d980,0xdcccda5a,0xe32de035,0xeb35e6f2,0xf32eef1c,
0xff20f8a6,0x0c7c05ce,0x13c5116c,0x177c1558,0x1a981962,0x200a1cbb,0x221c2242,0x208e216c,
0x1a311dd5,0x167117b1,0x13d21514,0x13c61349,0x156c14b4,0x12c5151a,0x0c8a0f44,0x0b2d0b56,
0x0bea0b85,0x08f60af8,0x0673078d,0xffa203cb,0xf4f0fad4,0xe7a5edc3,0xdf7ce3ac,0xd6c6da81,
0xd2a8d4b4,0xd1ebd0f1,0xd591d46b,0xd77ad5ed,0xdca9da17,0xe40cdfd8,0xec34e837,0xf635f0d0,
0x03a8fc96,0x0e3a0a2d,0x12f1108d,0x16801545,0x1b5a1816,0x202c1eb5,0x2089207a,0x1b981f00,
0x16bf1878,0x140a1575,0x12ae12f1,0x143f132b,0x14941562,0x0eae11a7,0x0b6e0ca8,0x0c5a0b55,
0x0b4f0c90,0x093109f3,0x04bd07b3,0xfcb10142,0xef47f609,0xe60fea51,0xdcb6e0fb,0xd7bbda33,
0xd463d4fc,0xd7e9d637,0xd96cd85b,0xdd63db4f,0xe3d5e004,0xebf4e7df,0xf4bbf018,0x0086f9fa,
0x0d9507ba,0x14191118,0x185b16ef,0x1b891900,0x21a81f27,0x23c522d4,0x20802334,0x1aa81d22,
0x175918fb,0x149815b0,0x148a1432,0x16ba161a,0x1238151b,0x0cae0f4a,0x0c3d0b7f,0x0c690d0d,
0x0a6c0b29,0x06f00944,0x00ea0435,0xf414fb4f,0xe96cee31,0xdf28e416,0xd94fdc0c,0xd372d5b6,
0xd4f1d3a9,0xd661d591,0xd94bd7bc,0xde37db4a,0xe565e1cc,0xed90e97c,0xf766f1f0,0x054efe72,
0x0deb0a0c,0x13fd11ba,0x162914a2,0x1c331956,0x20051e2c,0x1fbb2107,0x197f1c8f,0x15d1177b,
0x12e21444,0x115e11bf,0x142d129b,0x12471414,0x0c8a0fb4,0x098c09d1,0x0ad00aa0,0x09b80a28,
0x075e0910,0x037a0563,0xf938ff8a,0xee38f322,0xe337e8a5,0xdca9df71,0xd5bad913,0xd512d479,
0xd637d599,0xd895d761,0xdc78da10,0xe31adf99,0xeb5ee719,0xf3f5ef59,0x016afa77,0x0ba40700,
0x144e1077,0x16de15c3,0x1c64197a,0x21761ef2,0x241e23b7,0x1ecf21f2,0x1a401c4c,0x173318a4,
0x145b1597,0x16101492,0x16a716f9,0x11fa14ef,0x0c4d0e3b,0x0ce80c8e,0x0c710c95,0x0b070c5a,
0x08040935,0x00730580,0xf565fa85,0xe95eef9f,0xe17de4aa,0xd9cadde8,0xd656d71c,0xd66fd625,
0xd852d765,0xdb42d97e,0xe045dd7e,0xe7d9e3bf,0xef47eba9,0xfacff442,0x05c200c9,0x10420b48,
0x140c12c2,0x186115ee,0x1d7c1ae0,0x2257205f,0x1f5721d8,0x19ae1c64,0x163217b1,0x127e1497,
0x12141179,0x13fb1334,0x11d313c1,0x0ae00e30,0x0a0009cb,0x0a0309d1,0x098a0a38,0x070c07e2,
0x029505f1,0xf851fd5e,0xec9cf2fd,0xe31fe6f0,0xdb6fdfb7,0xd608d7fd,0xd48ed4e9,0xd5d8d508,
0xd815d6c1,0xdc3ed9fc,0xe34ddf37,0xeab5e75a,0xf4ebef0d,0x0006fafd,0x0bac058e,0x12170fcc,
0x162a13f2,0x1af91878,0x217d1e45,0x21f122dd,0x1cc81fa9,0x18f81a7a,0x1545177d,0x13351398,
0x14e613c1,0x157115ef,0x0ef712b9,0x0bd60c96,0x0b6d0b71,0x0c050c0c,0x09c10ab1,0x07a3097d,
0xff24037f,0xf49dfa95,0xe999ee19,0xe1cce5ec,0xdac4ddc8,0xd775d8bf,0xd7a5d73f,0xd8f4d810,
0xdc2cda8d,0xe1a2de3a,0xe8a4e571,0xf16eec1b,0xfc39f73d,0x07c0016d,0x10af0d2f,0x151b1313,
0x18bd16e1,0x1f831bd2,0x2349226e,0x1f432220,0x1a5e1c43,0x16b718f0,0x131e1466,0x130512bc,
0x152d1432,0x107b13ee,0x0b860d5b,0x09be0a44,0x0b030a88,0x09370a37,0x07ff08db,0x01c30559,
0xf883fdf4,0xec31f1ce,0xe3b3e7ec,0xdbd2df8b,0xd6add8f1,0xd56cd591,0xd616d584,0xd8a1d74f,
0xdc8dd9f8,0xe3d6e06f,0xeb37e6d0,0xf57df0a9,0x002afa41,0x0b4c0664,0x114b0e9b,0x15501382,
0x1b1e17c4,0x217d1ee9,0x20a2223f,0x1b711dc5,0x180019e8,0x13f415bb,0x122212ce,0x148412c0,
0x12ee150b,0x0d440fc9,0x09af0b15,0x0aee09f9,0x0a250ae4,0x09ea0a24,0x057e081d,0xfe5a029f,
0xf260f876,0xe8eded7a,0xe0a9e490,0xda7cdd45,0xd787d89d,0xd6f1d6e8,0xd95dd801,0xdc19da54,
0xe271df4c,0xe8efe51c,0xf2edee13,0xfc78f749,0x089402bc,0x10ff0d29,0x15b913ed,0x19fc173e,
0x21341da5,0x23bc2389,0x1eaf217b,0x1b1a1cae,0x16c918dd,0x138d1518,0x14871304,0x15b81640,
0x10a21360,0x0b5b0df1,0x0aff0a5d,0x0a8f0b29,0x0aba0a7e,0x0790099b,0x0291058d,0xf7c1fdc3,
0xed4ef228,0xe463e8a6,0xdcf5e06f,0xd853da4b,0xd638d6e1,0xd791d6a0,0xd938d827,0xdec0dbbd,
0xe431e131,0xed76e898,0xf61bf1a4,0x01a3fb9f,0x0b870705,0x11f50f66,0x156d138e,0x1c371866,
0x222f2002,0x1f54218f,0x1b5a1d3a,0x17461940,0x136e158e,0x11ea11bc,0x1459139c,0x115b1356,
0x0b820ec5,0x0904092b,0x09350988,0x0a0b096b,0x082b0991,0x050c06ba,0xfca801b0,0xf1ecf71e,
0xe870ecee,0xe057e455,0xdabedd1a,0xd71ed8d7,0xd738d6b2,0xd837d7b8,0xdcc9da15,0xe168deff,
0xea25e568,0xf2c3ee8c,0xfd15f7a0,0x07fb02a2,0x10670ca4,0x146112a3,0x19be1682,0x21a61de2,
0x222b2339,0x1e2f202e,0x19bf1bdc,0x16251835,0x12a413c6,0x14de1398,0x143114ed,0x0f381266,
0x0a630bd4,0x0a490a7f,0x0ae50a40,0x0a130b11,0x07ff08f7,0x01b105c0,0xf781fcc1,0xed3af22d,
0xe4b6e8c9,0xde1be0f2,0xd95fdbae,0xd7cbd7f3,0xd7dfd7ee,0xdb3dd8e1,0xdf33dd66,0xe696e230,
0xeebfeac6,0xf7edf309,0x0278fd1f,0x0cda081d,0x12411041,0x161113e3,0x1e8d1a0e,0x229421c4,
0x1fa02191,0x1adf1d35,0x17b61965,0x127014df,0x131b1229,0x141a1400,0x10e01365,0x0a880d2a,
0x090f0988,0x095208c1,0x098309ee,0x07a40886,0x03c20660,0xfb0cffd8,0xf0fef5fa,0xe801ec6a,
0xe039e396,0xdadedd9b,0xd789d866,0xd6bfd73f,0xd903d714,0xdcb8db29,0xe21ddea1,0xea5be657,
0xf2fdee91,0xfcbdf792,0x084c0290,0x00000c43,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_nylonstrgtr_acgtrb3[3200] = {
0x00000000,0x008b009d,0x00f100b6,0x012a0118,0x01680141,0x0196018f,0x01c101a9,0x01fb01e2,
0x01e301e2,0x01f501f5,0x01dc01e5,0x01d201e8,0x01ae01c1,0x0176018f,0x01620165,0x01030132,
0x00bf00d3,0x007c009e,0x002d0045,0x00010006,0xffc3ffcd,0xff59ff90,0xff2cff3e,0xfefaff0c,
0xfed6fee8,0xfe98feb5,0xfeacfe9c,0xfe96fe93,0xfe5efe75,0xfe59fe57,0xfe3cfe55,0xfe3bfe46,
0xfe48fe53,0xfe44fe48,0xfe58fe6f,0xfd0efdef,0xf214fbf0,0x07d20672,0x089cff97,0xfe6702f8,
0xf96d009e,0xffb704b0,0xf481ec2e,0xefb2ed82,0xe875f10f,0xe860e602,0xf802fb98,0xf71009bd,
0xff860073,0x14ef0cc6,0x1e1e01f5,0x0d16066e,0x0e73fdb2,0x100816b7,0x20362050,0x1a052140,
0x1cf42707,0x281624c9,0x26ab207a,0x22990d9b,0x19b2073a,0x27f62083,0x188923a8,0x0e0e1a4b,
0xfeb41dae,0xf96f016e,0x01def6da,0xe261d5a3,0xe060de66,0xd6bbd8bd,0xfbc5ea62,0xe9a50241,
0xf1f0ea5d,0xe67b0323,0xcf4abfd7,0xe015e422,0xaee9c223,0xc05baad7,0x8648ada0,0xba51993c,
0xb48eda34,0x9abaa7dd,0xb55db597,0xaae2ac1e,0xd60fbc51,0xaa6cbd08,0xc14bb546,0xcf7ad063,
0xf010d7aa,0xff36f85b,0x08caf799,0x212511d9,0x1d881f26,0x3bc42f7a,0x43ed39a5,0x6a644f1e,
0x5fcc680f,0x742765f6,0x657069ba,0x6a8b4c90,0x67f67af2,0x52ca624b,0x59096ba1,0x525f6727,
0x5bdb662b,0x56b25a45,0x507b52af,0x4ab94c94,0x458a4717,0x40604239,0x13d63dbe,0x0e6728ee,
0xddc1043e,0x18920255,0x11ad21e5,0xf490f23e,0xfc55eb60,0xde1ad64c,0xeea6e627,0xa9e0cba8,
0xb045b7bc,0xb756c43a,0xc84db955,0xc682bd5c,0xbd22b370,0xce02bad7,0xcc75bba3,0xc777c2cd,
0xca2dd344,0xdf4aef41,0xeb56e99c,0xfa97e668,0xe29feb6f,0xf129eba8,0xf038f611,0xea5beeb3,
0xf2fff605,0xe9a3f04d,0x1a63ffe7,0x13b90c9d,0x33182945,0x154f126a,0x1198f7d8,0x09b41894,
0xe1a3eee5,0xd3a0edcc,0xbb0dc2ae,0xfa36dacc,0xf4aa03c3,0xdf89db8c,0xe849ef4e,0xea80dff4,
0xf57b02d5,0xcaa4ea36,0xe4f4d705,0xeaf6e6f5,0xedadeb11,0xf54f0191,0xf813ec5c,0x09d0f642,
0xfe660475,0x031e0b2e,0x1dcb129b,0x247f1510,0x275c16a3,0x255d2be1,0x1fea23e7,0x20ad2482,
0x203c271f,0x18001f3a,0x17601c99,0x0f80fbd7,0x215117f4,0x37cf11ea,0x31102cc4,0x0dcc20d3,
0x219f14da,0x0751242e,0xf17cfd9a,0xccffe720,0xc0b0bb3d,0xeec0ce0a,0xd70eef2a,0xd2b2d18f,
0xcd82dee1,0xd69adea1,0xe05ef74e,0xbe72c90b,0xce00bfba,0xd6d5dc09,0xf4acd617,0xf65cf150,
0xef60ecdb,0x03370675,0x06900b51,0x1b7bfb9a,0x2a8e1626,0x291e1f1a,0x3f763813,0x3b704227,
0x40a24896,0x3f444431,0x46805060,0x46304943,0x32c644c4,0x3fbf2d2b,0x463330e1,0x52514bf4,
0x4c4d59a0,0x32d33fc4,0x4b3c4413,0x32b445e9,0x20772be8,0xfca9021d,0xe62edb3d,0x129dfbce,
0xeaef0167,0xe475eaa3,0xdbe6ec57,0xec94d8ee,0xded1f55a,0xb587cdc1,0xde76c723,0xce24cc9a,
0xe813d3df,0xd164eb8c,0xdbf0d9ef,0xf03ce402,0xdad2db5c,0xed96dfbc,0xf39ff23d,0xfb9af2bd,
0x000c0882,0x051e06f5,0xffff102a,0x0e480756,0x0ae11519,0x09b4117c,0xfd0bfa4a,0xef1cf466,
0x04d0fb5c,0x15960af5,0x101e15e2,0x0260f778,0x150c0dc2,0x0c8c0756,0xefc5f7c8,0xc85bdbae,
0xc580b089,0xe5d7e545,0xcec9d8c6,0xd51fc319,0xbda0bf3e,0xd48ac892,0xca78e419,0xb502b2db,
0xcef2d157,0xc01fd944,0xeefef34f,0xefbbeba7,0xff56df9c,0x07f7fcb9,0xfa23f3dc,0x127e0621,
0x13061f0e,0x2bf025db,0x2d623ad8,0x3f933ef6,0x39bd3cb6,0x476b3f8a,0x527d3985,0x335c3982,
0x2bf432f3,0x190122bd,0x28422d5c,0x3c1c3b43,0x258039fb,0x32e61d5d,0x360228db,0x30842a93,
0x148e18e7,0xdbbafc0f,0xed0edd0d,0xfb10fec3,0xdf67ea5b,0xd175e0bf,0xc758cf89,0xe875cbda,
0xc5d7dbe6,0xb525b75b,0xc5c4da1b,0xcb6cc55e,0xe495dbda,0xd743de32,0xec6dd42c,0xeafded4c,
0xe251d9cc,0x050cf0b1,0x0256fca4,0x1e0612fa,0x207a22bb,0x31f131dd,0x39bf2fba,0x33e8322a,
0x3fc74cac,0x2f30306e,0x250b326a,0x1a1a1c95,0x2940257a,0x3d304268,0x27343088,0x325b331c,
0x3ace397a,0x36d740e2,0x22483376,0xf8b7fdd5,0x0bfaec36,0x07a50a15,0xf6edfcff,0xecdde6bd,
0xd61bd9a0,0xe919ecde,0xc573f3ee,0xd84fc626,0xdcc2d5d7,0xe026cd93,0xf3aae4bb,0xd944de02,
0xe86cdcdd,0xd9ffee14,0xd7b2cd00,0xe90aea7b,0xe97ce90f,0x01380045,0x0fddfde1,0x0e640097,
0x03901472,0x121d0362,0x03b91db2,0xf9b5005a,0xe8c3fdc6,0xdea1e8c3,0xfec2e9bf,0xfed1095b,
0xf94bf655,0xfcce009e,0x09d20d13,0x17ae0dcb,0xf62eff27,0xccadd36d,0xe5e8d69e,0xf04fdf66,
0xda10d214,0xc45ad03c,0xbc30c8a2,0xe012dcb6,0xc081cf36,0xcfdcc254,0xd931da80,0xea5ed49e,
0xfa26f86c,0xea5af07d,0x07e6fb2d,0xf19f083e,0x00fff564,0x0f2b13f2,0x24b40fd7,0x35882494,
0x33353c57,0x4e413d2a,0x37043fcd,0x4e083e1c,0x3896486b,0x2ebe32f7,0x1f2b2a32,0x06ec0f09,
0x2ead1ff4,0x1f942f35,0x1d862743,0x2bbb26ca,0x2eef24ea,0x32093330,0x044f23ee,0xf2f7ed4a,
0xfae0eb6c,0xf0aefbbf,0xdb5ef286,0xccaddfe6,0xd37dc695,0xdc39dc36,0xbf7bcc11,0xccaec108,
0xc9b9d582,0xe0ddd177,0xebc0ec47,0xdda8d9f3,0xf679ef66,0xdbf9ed2f,0xf9e4e0bc,0x01d8f2c5,
0x057c0137,0x2b4b1cec,0x2a061ecc,0x40b7385d,0x2f9d2c81,0x462937b8,0x365b3785,0x270f222a,
0x0e3929b5,0x002c04b5,0x1eae2d5d,0x1dc22b19,0x22651ca4,0x241a2992,0x2e902927,0x3d1836a6,
0x0718128d,0xee53f479,0xf2aefda8,0xf03202fe,0xe510f1aa,0xcda0d7f6,0xdc4ccdc1,0xe059d758,
0xc228c668,0xd1a2c492,0xc9cccdde,0xe0e1d0b5,0xd9b4ec57,0xd7ddd65f,0xecc1eb18,0xd65aceb9,
0xdea4d45e,0xe9ffe996,0xfb29e153,0x0c5b0888,0x16ff046f,0x1aeb2491,0x1866134e,0x28ff1de4,
0x100320b1,0x114c0778,0xe2490afe,0xf433e62f,0x0cd503e9,0xfb2d0aeb,0x065b0c27,0x10171275,
0x284907c0,0x1e0f2895,0xed3e0732,0xe6eee8c6,0xf3e3e77c,0xeed5ea4c,0xda45e9ee,0xcbffcccf,
0xd5c1d3b3,0xd849e14b,0xcb5fcb1b,0xdb41ce0f,0xd353d54a,0xf1ace5e0,0xe58cf7f7,0xf719e6ae,
0xef4f01dd,0xe3bff60a,0xfcadf02f,0xf7700424,0x1c3e02e9,0x23fc1ec3,0x3f4521e2,0x3b023231,
0x33b82fab,0x47123dae,0x1f663bd2,0x2ecc33fc,0x063814ba,0x1182fefc,0x23fb21e8,0x1c121ba3,
0x2f3c152e,0x1d951e88,0x34532c81,0x269a474d,0xfea91651,0xfb94fa23,0xfcc3fda6,0x05f9fa31,
0xe22ff45c,0xdb9ddc9e,0xe8c1e212,0xdd39e7a3,0xcfccdab2,0xd91be1f0,0xddb8db8f,0xfd7aebc4,
0xe265eec9,0xf315f87a,0xf7e8fb18,0xe402ea8b,0xfc56f327,0xf3e9f642,0x15d804a7,0x20c90fb0,
0x2ed61f7b,0x312d29fc,0x27dd2124,0x38183a69,0x24921f75,0x194f247e,0xee3a093c,0x0612f78c,
0x19db1054,0x075101f0,0x0f921440,0x07e31093,0x2e141a35,0x148c2b4f,0xe983fddf,0xec2eebc5,
0xe3cbe7dd,0xee67f6f0,0xd12ae0b8,0xd2e8c59e,0xd9a0d156,0xcbedd382,0xcb72c77f,0xd0b6c852,
0xd3fcc2e3,0xde24ec53,0xdec9dfdc,0xe722e8ed,0xe5eff5e1,0xe217dd1e,0xf0a6f00e,0xfb83e4ee,
0x0ab4fb6a,0x1a960fb5,0x23c620f5,0x1ff8327d,0x31471dca,0x2ad53353,0x1e7526c1,0x16072734,
0xf79bfb11,0x0e17edf1,0x07571645,0x06680902,0x0f2b1448,0x0b5f05d8,0x2f191e48,0x120826c9,
0xf0def510,0xe9daf17c,0xf04de53c,0xf4c7f5ec,0xd098dd6b,0xd764cf34,0xdf6bd7de,0xd98bce6c,
0xd0d0c8e4,0xc321d4cc,0xe24cd559,0xe060ed04,0xe36beddb,0xf4a0f197,0xe60dfbcd,0xf5e0e962,
0xf545f4ca,0x03a0fa5d,0x12e30a40,0x20ac2668,0x3ba93160,0x2e413533,0x3b2e3a97,0x3c4b4511,
0x407c326f,0x2e012beb,0x028b0c9e,0x21d01247,0x1a932540,0x220819db,0x1f2e2480,0x223d167c,
0x4251352d,0x17203980,0x08bb09e3,0xfbddfd93,0x02dcf5be,0xfcce0d49,0xdf62ec6f,0xee79db91,
0xe6ade2dd,0xda6ce09e,0xdc94decd,0xd149ce13,0xe48be42c,0xe666ed4e,0xe6dfec19,0xf936f50d,
0xe5d8eb1c,0xeb90ef7c,0xedf4ec86,0xf42ff92a,0x137cff9a,0x1e5d0b43,0x2264285a,0x23032604,
0x306825b4,0x2be5282b,0x2071246b,0x0b322344,0xf227f1fe,0x1028fce4,0x05c705d5,0x10ac0366,
0x05800b21,0x072a04e6,0x28e43023,0xff701e97,0xf0f5fc65,0xde89efd9,0xf968e769,0xf5c0f1c1,
0xd627c944,0xd97ed1e7,0xd14cdb55,0xd5e6cf1b,0xc31dd6d8,0xcd6ac567,0xde7ada45,0xe49ee0d2,
0xf0f4d8eb,0xef3cee0f,0xebd9e210,0xdfefeda0,0xf151efb5,0xf73af04b,0x01ae0858,0x1e2f1d9e,
0x2905245d,0x2fd61f06,0x2bc025c9,0x255f3251,0x26232971,0x05902071,0xf621f3d0,0x0aea0524,
0x05c70638,0x0cad0c37,0x02fb118a,0x1b6d0226,0x2a933066,0x00d31d30,0xf5e504de,0xeb04ecd3,
0x035fea40,0xebdffb96,0xd97ad6f4,0xebacd8f2,0xd46bda63,0xe3f5df03,0xccb8d71b,0xdca4cf93,
0xef68e122,0xe4d1e9d3,0xfdd4f055,0xedcafafd,0xfa75f961,0xf94cef01,0xf75ffbcd,0x03960a22,
0x1886111f,0x322a2ab8,0x30d83138,0x34553ee0,0x3d193c3c,0x3a643d1c,0x3d25386c,0x15df24e0,
0x0f16003e,0x135f136a,0x1104174c,0x1c731a29,0x04e31712,0x241a18e9,0x2e8d3eb4,0x15751ae6,
0x038dffd6,0xeb79eda8,0x0383fbc1,0xec4dfce0,0xd8bcd54f,0xe273eabb,0xd6dfd5f6,0xe0b8e57f,
0xcfd6cda8,0xd9b5caa6,0xe827e419,0xdea5dbca,0xf30ff49d,0xeeaee6bf,0xe5e0f0b8,0xe7bbf1aa,
0xf6ffecd3,0xfe54f469,0x1217fd78,0x1c6923da,0x27b12665,0x2ccf2d74,0x31ad2d4d,0x35e629d1,
0x323d2b17,0x03cf11a8,0x01defdfd,0x0a8a04d2,0x08a504d9,0x0743170e,0xf83e0b50,0x23fd1269,
0x2523283e,0x0470110e,0xeccbff0b,0xe6ece2b5,0xf7eff133,0xd2f7f71c,0xd564ceb8,0xd1a2e30a,
0xd993c915,0xd76cd68f,0xc270c71d,0xd6d7c415,0xd89fe1c7,0xeaf6ca7c,0xe64ee5de,0xe1d0e8db,
0xe8abe7f7,0xe656e20d,0xf3a4e585,0xed7df462,0x11da0317,0x1cb01b77,0x27aa216e,0x2fd72b07,
0x2e6c27c6,0x32c92c16,0x2518340b,0x08190f1e,0x03d5fcbd,0x01b10b1c,0x0e970ed5,0x0eaf17f1,
0x096e0109,0x269c1b4e,0x21bd36e5,0x102c1c7d,0xf3d00392,0xeebaf20b,0x0a530273,0xdd9ff6d9,
0xeec2df85,0xde02e612,0xe64ede54,0xe396e950,0xcc5bd75a,0xf4b4d91d,0xe1f3e46d,0xf39fe9d5,
0xfc90f5f0,0xfaefef0a,0xf8dcf501,0xeb3ef5ef,0xfa5405d2,0xfcdd0339,0x1e7a17af,0x2d8b27cc,
0x39d4269c,0x38de353b,0x3370323b,0x43133677,0x287932f7,0x03471883,0x029b0f28,0x08a50bc4,
0x1eaa0b38,0x09ee0e6e,0x0aeb02b7,0x2e7018a0,0x235725da,0x046b1b98,0xeb430165,0xec0ceb60,
0x01930429,0xdc86e410,0xe361e1c5,0xd764dff9,0xdef8d961,0xdfa8e385,0xca10c025,0xdccfe1d6,
0xdaabdf0c,0xeef7df16,0xefa2ed6e,0xecb2e9ee,0xec2ef618,0xeddce90f,0xf25dfb44,0xfc72f851,
0x1d360c82,0x204021bc,0x2fc32636,0x32ae31cf,0x33ff2134,0x38883401,0x1c602fbe,0x08b60c78,
0x079bfe4e,0x0463f89f,0x0f1f119d,0x00810923,0x0a4afaea,0x1f3c176f,0x1c71221b,0xff720f2b,
0xe1bbf58b,0xf028dec9,0xe8abfe94,0xd217e0b7,0xd4b2df0d,0xce2dda73,0xdf0bcb46,0xc265dffb,
0xcd48bc75,0xde29cd8e,0xd69acbc6,0xe412d7f1,0xdd57ed84,0xe7c0e87d,0xe11ff187,0xeeaae84b,
0xf513efc9,0xfcdff0ea,0x1ce80d7e,0x22d61dd4,0x385c2187,0x276b3440,0x2ea42f54,0x3c113fa6,
0x22dd2c5a,0x10c50dd3,0x03cf09c9,0x140900d8,0x1ac91604,0x03c30e10,0x13a10e48,0x2919234d,
0x260e30a2,0x11231b46,0xea28fcb1,0x01f4f993,0xf42908bb,0xe89cf1dd,0xefd6e6bf,0xd33ce64e,
0xf310ea9c,0xd773e00e,0xe068ccb3,0xe784df64,0xe006de65,0xf4d1eb71,0xe9fef4da,0xf5e0f78e,
0xf15bf3f2,0xf5dbf271,0xf717fd79,0x072bfa7b,0x279a1230,0x1e7b2077,0x32cf37d8,0x297a397a,
0x3b2f2c3d,0x3c173e84,0x182a2eb2,0x12c71656,0x03790138,0x12f5fef4,0x115e1626,0x037a028c,
0x11b206f5,0x299119d4,0x203c22d8,0x02ae1a63,0xe878ef17,0xfd0ef84b,0xf39bf65b,0xd9c2e786,
0xe235edee,0xdd09cf37,0xe975e084,0xccafd282,0xd291cc79,0xdb2edcf1,0xd8c6d526,0xeae1e8cb,
0xeb93e76e,0xecb8ed53,0xe62ef10e,0xef5df102,0xf524f2b7,0xfe23f284,0x13f719cc,0x1d041c60,
0x35c72bf0,0x24d72831,0x323d2917,0x33303cb0,0x17211cd4,0x07a50fd0,0xf613fcd4,0x10e1fba9,
0x08d00abf,0x041df4ef,0x1069f913,0x1a2916c6,0x1b501fef,0xf1e8155f,0xece0e6a9,0xee3bf44a,
0xe3f2fc9b,0xe728dcfb,0xda7fde48,0xdeeeca76,0xdc1ddfc8,0xc758d1d1,0xd085cd21,0xd13adec6,
0xdc5dd5f0,0xe821e5cd,0xea14eb8c,0xf357ebd7,0xf48de7ea,0xf3cbeaf0,0xec51fc3d,0x05b1ff3e,
0x1c83199d,0x25b41cbc,0x331837f1,0x27e231ff,0x43af2cac,0x347d3f3b,0x1d4424e5,0x0f4518cf,
0xfd69ff02,0x1ad70a9d,0x0b7810d1,0x02f70429,0x18c30cd4,0x22de1d64,0x2d302bc0,0xf4d31213,
0xf1f5fe23,0x036cfd62,0xef0af7fa,0xefeceed3,0xdc08e629,0xe75ae149,0xe51ae8e0,0xd3cdd950,
0xe5dcd4a6,0xdfc8dc88,0xe3ede254,0xf43af030,0xf879ee91,0xf887ef3c,0xee40f85b,0xfa26fad6,
0xfaa1f8b9,0x115bfd8e,0x19fc1d77,0x28d325fe,0x38313a64,0x23ee2e88,0x3e023d52,0x2e2a43c6,
0x2116259e,0x0e2b17ae,0x056cf4af,0x144f0bca,0x05a31081,0x01e2fe0e,0x14720c00,0x1eea133f,
0x184235ab,0xf9840830,0xf5b0ec23,0xfa51f868,0xeccae970,0xe4c5e9e1,0xd6e6d740,0xdbe3db3d,
0xd9dae0b8,0xcc20c9b6,0xd358d236,0xd823d513,0xe47cd142,0xec0adf23,0xe3b5e998,0xebe2ef6c,
0xed69e9b8,0xf1f6ed14,0xebe6ef95,0x04f2fe26,0x149b12bf,0x23db1a99,0x283338b3,0x2218247e,
0x3ab1364b,0x28033796,0x22741c43,0x00460f00,0x005af52e,0x12a00866,0x007208bc,0x0313f6c9,
0x00f5112d,0x29dc17bf,0x1d0c2576,0xf5db0171,0xfb41ee7e,0xf062facd,0xf1d1eea7,0xdec2ecbb,
0xdb8bdba3,0xe177dc1e,0xcff3e5e2,0xd00cd475,0xdcc3d0bf,0xdc8bd221,0xdf5ad9dd,0xebfbec81,
0xf0ebe7b1,0xf1c6ebe2,0xee61ef0d,0xf0b3f77a,0xf815f0ef,0x0c12fdb9,0x128b18c2,0x2f7a2282,
0x2b4637dc,0x2d472501,0x42a33a35,0x28b134f0,0x21d52b77,0x02f211a4,0x0741fbe1,0x18c70e67,
0xf92d0d35,0x0ddd082a,0x0f100579,0x2c3f2178,0x1d312deb,0xf546067d,0x0037ff9a,0xf185fdec,
0xf91ffbea,0xe812ecc5,0xddcfe35b,0xea08eb47,0xdf95e343,0xdbbad52d,0xd974dd91,0xdcf5e488,
0xf065e130,0xf839e9e2,0xf8dfecdf,0xf745f382,0xfe19f330,0xf713f55b,0xf73ff9d6,0x0d0d0b38,
0x14ed19ae,0x33f72aa6,0x2d2032e8,0x3374232c,0x3d3d3e61,0x30552ef9,0x1f7e2709,0xfeb10c37,
0xfa0dffcf,0x0cf11be5,0x0012fe01,0x01fb033a,0x0df7ffd9,0x27d7195e,0x12652716,0xf397f6ed,
0xf774fac4,0xed1fed44,0xe6f6f6a9,0xd725ebc2,0xdea5d586,0xe3ccdb5a,0xd0b5d5ca,0xcfc8d1f3,
0xd7eacf9c,0xd930cf9d,0xe156d9f3,0xe8cce5be,0xeff4e81c,0xefe5e57b,0xf04af0b0,0xedb7efcc,
0xf55def93,0x06cd0260,0x16fe0bf6,0x2d4b24e5,0x1e1c2f9b,0x32332721,0x36913883,0x2fbe2d96,
0x168a2597,0xf957108a,0x0dc5f5c0,0x061b11fd,0x0319fff6,0xff4eff3d,0x0b0f039a,0x2cfc1c82,
0x0b642467,0xfed5f574,0xf273fca6,0xf047f42d,0xf4a2f520,0xdb8be2f4,0xdb03df49,0xd9d7ee1a,
0xd83edd82,0xd9abd1f2,0xd87bd4a0,0xddedd893,0xeab4de72,0xf2c6e52d,0xec2cf084,0xf2d9f259,
0xf42cf95c,0xf038f5dd,0xff50f70a,0x0b3203a8,0x1d9c12f5,0x36112ca0,0x2ac928cb,0x3ac02d35,
0x36393d43,0x2e273f16,0x26782983,0xfc9b0ab0,0x15e106e7,0x0cf6104a,0x062808e9,0x074d03c1,
0x12310519,0x366d261a,0x063223b5,0xfeda0948,0xfa6302a5,0xfb09f190,0xf071fe02,0xd821ed89,
0xe708e829,0xe30fe7e4,0xd8a2de67,0xd84fdc82,0xdcb2d80c,0xe510d875,0xe69be0d8,0xf1c9ef9c,
0xed4cf085,0xf5cdf3c4,0xf721f893,0xf3d5eebd,0xfbeaf935,0x0a110226,0x24ba0c95,0x307b26ac,
0x25502457,0x2ea232bd,0x3a933804,0x2a852f83,0x17a32cf5,0xfc11ff56,0x0ac0065f,0x08f50962,
0x0112fe5e,0xff5efdab,0x0d68fa4b,0x25ff2ba8,0x06cf15ad,0xff66fbb6,0xea2afb24,0xef9cf3ef,
0xea94f94c,0xdb98d966,0xe00bdec8,0xd874e245,0xd5f6d6c4,0xd55ad287,0xd305d002,0xdac8da2e,
0xe498da01,0xec88ea11,0xeba4e810,0xf5f8ebc7,0xedb8f469,0xf1aceda4,0xfc12f48d,0x047dfbb1,
0x1eb911e3,0x23052c17,0x2ba82577,0x3374268f,0x326a3a47,0x31d32e0a,0x0bf12a80,0xfff1037a,
0x0c1304fe,0x0967090b,0x0342fd3b,0xf59a0243,0x1eabfd02,0x2bf921fb,0x055f1195,0xfc1107f5,
0xedcdfde7,0xfa7cf3a4,0xe63afa5f,0xdd4de24f,0xe930e458,0xe332de41,0xdc83d673,0xd55edb6e,
0xd9fcd6ac,0xdb29e1e1,0xe919e44e,0xefbbf0f1,0xeb4af084,0xfafdf944,0xf7c1f5e3,0xfbcdee4d,
0xfe30fbde,0x06060389,0x274e1e3b,0x2a10288c,0x2690311a,0x3c163308,0x33fc3a35,0x3a7c3ae0,
0x155323b8,0x0a9305c2,0x126f079b,0x05061038,0x0c680975,0xfe57f7e5,0x1f0b076d,0x21c92ed6,
0x0d4d16a4,0x07cc05b4,0xf269f71b,0xfbf7fc0d,0xe8d4f9f8,0xe38ee120,0xe5c9e7a8,0xdac3e60f,
0xdce2dce2,0xd2d7db3f,0xdbc1d906,0xde2cdbef,0xe691e31a,0xebe1f2ec,0xefc7eafe,0xfa59f396,
0xeeb4f49b,0xf59ff27a,0xfb27fc12,0x0f19f5a6,0x1f0c1936,0x295b2678,0x24452542,0x32333681,
0x35fe2fdd,0x31773997,0x0ea01c17,0xff0f063e,0x0f460992,0x0d7afd1c,0xff3d02e6,0xf388f4ad,
0x1c090a81,0x1d3b22e1,0x06460fa9,0xf9f708bb,0xf1dff2f6,0xfce5f451,0xe335eee9,0xdd74de9e,
0xe345e4a6,0xd680dc75,0xd8cfda9a,0xd1d3d243,0xd4afd4af,0xd78bdb8c,0xe9dbdd83,0xeb89e7ed,
0xece3e54f,0xf48af411,0xeb77f1fe,0xfba2ed0e,0xf003f6b5,0x0cc5fcc7,0x1d5c1500,0x1f7f29bd,
0x2cf12313,0x2d0c3147,0x391e3116,0x28473c99,0x0feb1fea,0x0e6cfdec,0x073d06ae,0x094509c8,
0xfae0091a,0xfe97f0eb,0x1ea50c9a,0x18362699,0x0d5715dc,0x00db066c,0xf952f32e,0xff42fb59,
0xe931f160,0xe720e054,0xe6adeabf,0xdf95de72,0xd93fe10f,0xd3b1ddd2,0xdf14da2c,0xe14bdb21,
0xee46e47b,0xec91f11d,0xf4beee16,0xffd8f7e2,0xee7ff239,0xfcc3fed0,0xf551f91a,0x0a690973,
0x27a51da9,0x244f24cd,0x328b2c38,0x2bbb32c7,0x3f533d86,0x34d537df,0x0d731c82,0x09900f8e,
0x08da0bfa,0x126f0d00,0xf9d30379,0xff67f613,0x229611a6,0x1eb51df7,0x0f5c133f,0xfc4507d8,
0xf935f75a,0xfd1cfdec,0xe4b4f1ac,0xec1ee0a7,0xe147e78b,0xdb82e155,0xdb2adf1b,0xd559d519,
0xd8fed873,0xd928dca8,0xea7be713,0xecd0ea2f,0xf385e672,0xf638fa1f,0xf38ae9a3,0xf328fbf6,
0xf716f4f4,0x0b95fdc4,0x1c411edc,0x1d68214c,0x2a0c30ce,0x35d12468,0x3b5931c6,0x276939af,
0x0dec1713,0x0abd0811,0x06ad00b4,0x057c1081,0xf0740231,0x00a1f0de,0x1c1a0e31,0x183f19f4,
0x0dc0101c,0xf9dc0076,0xf78cf383,0xfa24fcdb,0xde83ea14,0xe3cee802,0xdf16e56d,0xde1ddaf3,
0xd725da59,0xd2b4d415,0xd7f6d69e,0xe0b5d412,0xea70e001,0xe4acea53,0xf5f4e918,0xebeff835,
0xf7bef01f,0xf89af28d,0xf3f7f3a5,0x0ef3ff8d,0x18912039,0x2cbc1bf4,0x28e526e3,0x2c6c2dfd,
0x3e4439fb,0x283537c1,0x125515a0,0x03750f93,0x0b5a07d4,0x0cd2110d,0xf180fe01,0x03a6f888,
0x1b4215c9,0x1bd91cdd,0x108a14fc,0xff83020e,0xffd4f5c0,0xf6f6053c,0xe804ee13,0xec05ea1a,
0xe24de736,0xdf4ae416,0xdb11e133,0xdcf6d6aa,0xdd93d5e5,0xe284dbc9,0xf103e738,0xe807e992,
0xfadef450,0xf6acf2b5,0xf4f3f72b,0xf8f9fd41,0xf374f80b,0x1d030568,0x1b8215fa,0x254a2843,
0x2ac32e52,0x329a2b0d,0x41c83c51,0x2073388e,0x140e1eaa,0x06750d29,0x0f960780,0x098e14cd,
0xf266fb0b,0x07f7f9f2,0x19801427,0x1d1d1b68,0x0ef31322,0xf7b00393,0x0297fb80,0xf6cffe52,
0xe835ea23,0xe595ecb1,0xe01ae78b,0xe121e11f,0xdaf0d9b9,0xd691d6b5,0xda6ed58f,0xdf28d817,
0xe966e9b4,0xef01df64,0xef73effb,0xef03f590,0xef25f565,0xf84dfadb,0xf5f2e6e9,0x0c7809b8,
0x1a7f143b,0x28471c78,0x26f023e4,0x2c1d2575,0x3a053f91,0x1fb12df7,0x0f4b19dc,0xfe3d09e5,
0x0eee06ab,0x04f70f43,0xf1def0d5,0x0982f5be,0x16780bc5,0x147a1a32,0x07b6172c,0xf865fcc0,
0xfedafcfc,0xeeaefdd4,0xe888ec68,0xe91ee7e2,0xe402e0ab,0xdd0ae0cf,0xda4fdc0f,0xd407d6d8,
0xd563daaa,0xe796d97a,0xe3cee5ff,0xed86e9e9,0xf2d5ef6c,0xf7edf437,0xfdafea19,0xec6dfda8,
0xfb5bf10d,0x12c206ef,0x1c80132b,0x27b12167,0x239c2a47,0x3826256b,0x3b153eea,0x22ed2e05,
0x12a31dfa,0x018708b4,0x12c40d79,0x022f1282,0xf649f248,0x070cfd8c,0x17f51255,0x1f131899,
0x08db1465,0xfa0b0101,0xff020634,0xf33afee2,0xed71edcf,0xe7dfecf0,0xe57fe879,0xe100e38e,
0xdc77e0b1,0xe0d4d64e,0xd99cd418,0xe50ee504,0xe6b6e958,0xf0d2eef3,0xfc0eedca,0xed9df813,
0x0155fb18,0xf4e4f568,0x01def02a,0x11570943,0x1ad5177d,0x2c8624f3,0x21592598,0x37cc2e30,
0x36f14299,0x257c2f29,0x11ec1ef3,0x06fe0583,0x17ed0d13,0xfc5f0f0c,0xf477f6a7,0x0a72fd49,
0x14540e4c,0x19de1d58,0x030b14ee,0xff3cfec8,0x00eb0092,0xf0b0f91f,0xebd3ee3f,0xe616e950,
0xe1f0e779,0xe376dffa,0xda45d7c5,0xd270dc86,0xd94ad4e4,0xe2b5e16d,0xeac8dfc0,0xe4d2ea6c,
0xf2bcf7ad,0xf479ec08,0xfc0af61f,0xee7ef03d,0xfb5ef157,0x0ec3060d,0x191f0e89,0x230a25d8,
0x1dd5201a,0x36cd2ca0,0x31ff3c8b,0x261f2a83,0x0f5e17d0,0x0478ffe4,0x137e10d1,0xfcdd06f1,
0xf388ef34,0x0273001a,0x119a0d18,0x1b081bf9,0x04720a94,0xffe0fcd8,0xfd820141,0xf04cf769,
0xe975efd6,0xea31e8f2,0xe464e1a9,0xd8f2e646,0xdbc9dfc3,0xd41ad9aa,0xe196d3e9,0xde7fdf3b,
0xe60aec47,0xf336e637,0xf0b5f360,0xf657f0d3,0xf878fc82,0xf26af25b,0x01b2f069,0x0b510929,
0x1feb11c5,0x232a267b,0x22b61f06,0x3bf430e5,0x35f33927,0x26802e8c,0x0b0d1e13,0x0f0a0317,
0x17dc1088,0xfae80872,0xf8f8f40a,0x068e01e8,0x192b0b9d,0x18662022,0x02df1020,0x0357045b,
0xfe4b0621,0xf85bf9b6,0xf1a0ece7,0xe54fee4b,0xe8f3ec55,0xe081e396,0xe1dde1f1,0xd112da7c,
0xda3ce54b,0xeb22e295,0xe8e6e5d2,0xf6eeed4f,0xf173f235,0xfe03f43a,0xfb59f8da,0xee79f49b,
0x01b7f913,0x09340866,0x207516cf,0x21032564,0x28001bca,0x39fb3034,0x339b38a1,0x29052d6f,
0x090615bb,0x08c706c4,0x10c81677,0xf6170580,0xfbd5f122,0x010bfcbb,0x17540af9,0x143c1ce6,
0x004f09b4,0x04f40218,0xfe28fbea,0xedcff804,0xeb1af282,0xe819e620,0xe686e717,0xdd92dcd3,
0xd555e6f4,0xd91dd5cd,0xdac8d78b,0xe336e48e,0xe641e286,0xf244ef9c,0xf24dea63,0xf7e4f475,
0xf757f9fc,0xee20ef67,0xfe14fa03,0x094e0386,0x216d14e5,0x1a132106,0x23e21f67,0x391a3154,
0x3547323a,0x231a2e5b,0x05dd15c0,0x0cd0061f,0x11e314ab,0xf4afff06,0xf9a6f66b,0xffc5fb49,
0x197d0cca,0x15121ad3,0x0757025c,0x00060384,0xfc670292,0xf6d3f411,0xec5bee77,0xe8aae779,
0xdc4beef9,0xe6f2e305,0xdab5dcda,0xd659da75,0xe037d93c,0xe2b7e5a8,0xede3e19b,0xed87f1d8,
0xf329f048,0xfac5f69a,0xf469fdcf,0xf375f21a,0x00b2fb1b,0x0b620304,0x206b1c1d,0x1dec1fcd,
0x2b331d53,0x353433cc,0x35e23877,0x26363019,0x0b0611e0,0x13a8066e,0x0d4e191e,0xf74f00ba,
0xf930fbf4,0x0468fb8e,0x21ab0c5f,0x0fe11988,0x079b0b34,0x08d40331,0xff03fe8d,0xf65cf862,
0xe55af585,0xee9bf0cf,0xe489e591,0xe195e9a6,0xde50e1bd,0xd800d9e2,0xe7a6da73,0xe076e269,
0xee84e90b,0xedaef139,0xf03cf30b,0xfcd8fb0b,0xf590f9fe,0xf5edf120,0xfc67fc5f,0x10ab01b0,
0x227017d8,0x18f81b7b,0x27de22d3,0x3392323d,0x362d3638,0x21822de2,0x0483105e,0x13fd0a01,
0x079a14dc,0xf9e6fd02,0xf920f4e4,0xfe50f714,0x188c1485,0x10bf1440,0x072f03c6,0x0306034f,
0xf688ff62,0xf594fb7b,0xedbde7d1,0xe542ee6d,0xe4c7e710,0xdf32e459,0xdd06e134,0xd534d437,
0xe291df92,0xe21cdcad,0xec72e7bb,0xedbaeec7,0xf3efebc0,0xfa9cf953,0xefaff8ae,0xf6acf3f7,
0xfbb0f6cc,0x0e2701c4,0x1afe1cc2,0x1b93185f,0x2b581f37,0x33e72cd8,0x32b23782,0x1af0315c,
0x02b30fae,0x14cd0f80,0x087d0ef3,0xf78efc58,0xf36df9c4,0x0848f3d7,0x1bb60d79,0x0cba12df,
0x037a0851,0x01e009b5,0xffe6f99e,0xee35fb9b,0xf01ff042,0xeabfe961,0xe96fe6a8,0xe5d7df78,
0xda2ce44b,0xdb52d4d7,0xdea5e304,0xe3c6e1a4,0xf133e98b,0xecbbef4a,0xf5a1f05e,0xfcd3fe2b,
0xf773f4f7,0xf740f6b7,0xf9affaf8,0x144e0709,0x1c2e1b9e,0x1e47196c,0x29c423cd,0x343a3194,
0x36e73a81,0x1bce31c5,0x0c320c22,0x13af134c,0x04851550,0x0058ffaf,0xf81ef32d,0x083df75c,
0x17fa1537,0x0c9b16dd,0x0f9805da,0xfe4206d3,0x00fa03a8,0xf432f7a4,0xefa1f2f7,0xee13ea53,
0xe503ea1f,0xea5fe483,0xd6fae223,0xddadda72,0xe0efe071,0xe343e0f0,0xedf3ee83,0xebb0ef60,
0xfc09edfb,0xf854fb5e,0xf4a3f836,0xf78bf7c1,0xfcd6f417,0x14dc05bf,0x16d01909,0x1a0c1ad7,
0x272f239a,0x32c12ef1,0x39ae3726,0x14372aa5,0x089a0e9d,0x158612e8,0x06bc08cd,0xf8b2fee4,
0xeee1f46b,0x05ddf996,0x1a2a0f89,0x05b50d1d,0x07fc0dbe,0x014cff8f,0xfb7b010d,0xf3bcf4d1,
0xe8e0f06f,0xeb6fecca,0xe1bde492,0xe60ae8b3,0xd9eada62,0xdcc0d73f,0xdc23df06,0xe3a1e041,
0xef7feaf8,0xe7eae9f4,0xf742f3a5,0xf7c0fa48,0xf9cdf396,0xf75af3ac,0xfd32f15a,0x12a9083f,
0x15eb17f9,0x1a5d19c8,0x2794237d,0x30242d4c,0x34804016,0x1742280f,0x134e07df,0x113c126d,
0x049d0cb5,0xf7b60353,0xf424f163,0x057ff8d9,0x113819a5,0x0dda0c55,0x06260d26,0x06970230,
0xfcccff31,0xf775f826,0xeea5ed2d,0xe970f13b,0xe989e520,0xe410ea5d,0xd910e024,0xdf5edcb2,
0xe24dddb8,0xe7a1df0f,0xed6ef0fe,0xed9deaaf,0xfdeff36a,0xfa14f848,0xfb7bf762,0xf39ff8c1,
0xff58f66d,0x15460b82,0x194a1691,0x1d131879,0x22bd288d,0x389b2e69,0x38e93c5e,0x12702525,
0x114712b7,0x101b15e0,0x0b8b0bfa,0xf71cffcc,0xef19f6da,0x0e67fb20,0x0fb61322,0x104b0f16,
0x06d8096f,0x0443070e,0xfe72fe66,0xf273fb71,0xf4f8edee,0xe874ec0a,0xe8a9e8fe,0xe3aaeb02,
0xdc7cdd54,0xdd9bdbba,0xdad7e237,0xea21e260,0xee2bed92,0xefd4e64e,0xfbf1f48d,0xf6e7f78c,
0xfad6fa85,0xf23af5ac,0x00b0f532,0x11ad0b2e,0x114318a3,0x20c319f8,0x264a1d4b,0x377b2b16,
0x30473fdc,0x12442145,0x143710a8,0x0db20f3a,0x03a60fff,0xf8fdff28,0xeed0ed51,0x0b5afed7,
0x0e8b0cd9,0x0abd0f4f,0x07a906ec,0xfda905b2,0xffe0ff73,0xf05ef3f7,0xeee3f234,0xe736ea97,
0xeab0e6a2,0xe02de6ec,0xd5dddff3,0xdcaaded5,0xdc42dc5f,0xebe1e07c,0xea01eb4a,0xeec2e6ad,
0xf906f688,0xf936f408,0xfb65f9b9,0xf04bf273,0xfca6f93b,0x132c0ecb,0x187d0f4d,0x1efd18f3,
0x223e1f4b,0x3d3f2e36,0x31fc3ba1,0x15721c85,0x0e4e1765,0x10fe137e,0x070e0cbd,0xf507035d,
0xf524ecdd,0x08fb0213,0x129e0e13,0x0a840e37,0x0c600b20,0x02aa00b1,0xfb090629,0xf3e4f814,
0xf168f458,0xe90feb18,0xe8c8edae,0xe319eb8e,0xde84ddad,0xe080dea0,0xde97dc42,0xecdee6d8,
0xe980ee02,0xf4a5e92e,0xf984f725,0xfbeff5c0,0xf843ffa6,0xf52df45a,0x0888f3a9,0x10860c63,
0x159614d3,0x1dd01e01,0x24cb1c4d,0x3ed430d7,0x2a0e3d6a,0x19822002,0x130b11e2,0x0de9146d,
0x0b2c0d88,0xf01f0098,0xf705f056,0x067f00e2,0x10de10b7,0x0e6f0853,0x05050cef,0x06d201f0,
0xfc650055,0xf4b2f4fc,0xea1bf648,0xe736ee44,0xeaefec27,0xe1cee7ca,0xdf1fdcc6,0xdcf7deae,
0xdfc0daa3,0xee00e611,0xe8c1e841,0xf27ceab9,0xf143f915,0xfc49fa4c,0xfbf4fa23,0xf10ceff4,
0x0457fa67,0x0fd60bd7,0x1a470fea,0x1b3819ee,0x207a1bd4,0x3de236ec,0x2a3235df,0x147e2099,
0x14441471,0x0cc20f80,0x0a111116,0xefcefa63,0xf7d6f1b8,0x0ae2fb3f,0x08c10f15,0x0ec10cc4,
0x058a06f4,0x054702bb,0xf62c0069,0xf405f8f1,0xecf2f150,0xe935e95a,0xe9afeb64,0xde9be6b6,
0xde45def5,0xdb0edd5c,0xe098d935,0xe8e9e7f1,0xe37ae9eb,0xf248ef1b,0xf777f16b,0xfb27f63c,
0xf50eff0b,0xf245f017,0x0836f8fe,0x0ed7074d,0x17d21279,0x182a1c37,0x27ec16a8,0x39b43861,
0x2b1e3680,0x17511d18,0x11e2183f,0x11820e57,0x085713ab,0xf648f72f,0xf502f252,0x0cd00242,
0x0f1108da,0x0e4a0dfa,0x03d6099b,0x03e00ab8,0xfc48ffc8,0xf7eaf876,0xee5ff2df,0xeb2eec88,
0xeb56f017,0xe25fe76a,0xe244e1d6,0xda04df63,0xe19ddfe9,0xea9ded1c,0xee3ce643,0xf391edbc,
0xf4dff738,0x00c0fad4,0xf831fd54,0xf59def3e,0x04f4ff46,0x0ee10adf,0x1e3e1265,0x1454189b,
0x2c4a1b1e,0x3b943586,0x268b3781,0x1a811eaa,0x0ed4180a,0x17050ef1,0x03431142,0xf48afbf6,
0xfbfaecdd,0x08be002e,0x0c8c0923,0x08db105d,0x07520743,0x0227071d,0xf969ff15,0xf502f9b4,
0xec11f208,0xee2de9b8,0xebbfeb7b,0xe147e309,0xdd2fe450,0xd7abde49,0xe6aadcb8,0xe5a6e72a,
0xe721eb15,0xf29eef44,0xf735f0fe,0x01a9f7e2,0xf290fb32,0xf584f057,0x05cefc9b,0x0b100713,
0x19cc17fc,0x130f133b,0x278b1df1,0x3af937d3,0x24ac31f5,0x1d381ed4,0x0c37124d,0x150814d6,
0x08000bd9,0xf004f7c6,0xf851f304,0x031e028c,0x0fe609d2,0x09bd0989,0x084406f3,0x01a105b2,
0xfae8fdc7,0xf6ddf882,0xecf7ee6f,0xece0eb0c,0xe552ef46,0xe235e650,0xe13de222,0xd8cfd86a,
0xe1c4e2a9,0xe781e7fb,0xeb1fe75f,0xf1bdee44,0xf3acf2f9,0x009efdd4,0xf4b5f85d,0xf6baef62,
0x031400e5,0x10c50422,0x14af1990,0x13a314e5,0x2b071d1b,0x3a4f3a37,0x25cc2e63,0x19742611,
0x156b0fb4,0x15c712d1,0x055a10e2,0xf15ef8e3,0xfcedf62a,0x0759fd93,0x0e230d1d,0x0a5d0af5,
0x0a060a2a,0x04ba057e,0xff07fd21,0xf654fa64,0xead8f2ea,0xef7bf09d,0xeb1aecbc,0xe61ae447,
0xdb90e7ed,0xdc8cdcf8,0xe66be1b1,0xe8c6e760,0xeafdea5d,0xf107f278,0xf97af199,0x007ffe96,
0xf275fa7c,0xfcc7f06c,0xfe71ff8e,0x12c00930,0x14f316ca,0x125f1356,0x2d941d18,0x33843c25,
0x2e052bfa,0x182f1e7e,0x11c31308,0x157c147b,0x03a0101c,0xf4a3f3b8,0xf723f6c0,0x05bbfe93,
0x0a460ce6,0x0b2e08a4,0x0a7f06fb,0x02380305,0xfba4feae,0xf521faf0,0xeebaed40,0xee76ed23,
0xe2c1ee89,0xe60ee8e4,0xdca5e28e,0xdca8da1c,0xe3f0e1f5,0xe75ae71b,0xeefde74e,0xeee8edcf,
0xf873f2b7,0x00b2fea5,0xee37f6b6,0xfa58f758,0x0024fad7,0x123e09b0,0x13cc1536,0x0ed01168,
0x346a1f2d,0x32a43290,0x274c31dd,0x163320d8,0x113d1448,0x17d914f2,0xfe3c0f22,0xf5bef75a,
0xf730f512,0x092ffdc7,0x0b1f0852,0x097f0862,0x05f90b0b,0x01bc05ec,0x0069fcb6,0xf516f7b0,
0xeb09f00e,0xef2ff1f0,0xe84de903,0xe708e7c1,0xda9ee327,0xdcc0dc65,0xe624e219,0xe701e494,
0xee26eaf1,0xf14cebac,0xfa20f0a1,0xfcae02f5,0xf3bdf360,0xf786f890,0xffd7fbad,0x0fb60d01,
0x14e51709,0x13bb08db,0x2d27260b,0x33d03467,0x28283107,0x19711f15,0x10c312f1,0x16bb1ad2,
0xfde70d8d,0xf75afa19,0xfa25f2cf,0x08dbfeb3,0x096a09b4,0x0bdd0a16,0x0bb40825,0x02c702f1,
0xfcb80165,0xf3ccfd71,0xf1deedfb,0xeecbf17a,0xe8aeeae8,0xe7fceb69,0xde27e1eb,0xe071dae7,
0xe4d8e4e0,0xeb18e4ab,0xececec11,0xed8eefc0,0x000cf392,0xf99c012e,0xf62af6d3,0xf604f925,
0x0476fc6e,0x166e073a,0x0b90179a,0x16ed0cdc,0x2d9f23dd,0x35243330,0x26412f15,0x15a2228a,
0x141a11a9,0x16691af9,0x00a3083b,0xf4ebf940,0xf6d7f47b,0x07c10037,0x0b730568,0x0b1a05e6,
0x056b0a59,0x00540547,0x0081fea5,0xf090f870,0xefecefcf,0xeb87f129,0xea0be8de,0xe6b5e8ea,
0xda9ee081,0xe21eda69,0xe149e10d,0xe755e6e3,0xed3eeb98,0xebf9e9f5,0xfe0cf735,0xf79efd2a,
0xf834f6ce,0xfa40f10e,0xfd58fb1a,0x15710e12,0x0a5910be,0x17a20d05,0x2c2521fb,0x3050355c,
0x27ba2f27,0x1437200d,0x1953107c,0x134a199d,0xfe750a5d,0xf453fb59,0xfa6df304,0x06f1fed0,
0x05fe0899,0x0acb0a5d,0x0a1a0899,0x019501d5,0xfebe0393,0xf0d0f944,0xf2a3f283,0xec1cf0a8,
0xeac3ebc0,0xe90feb66,0xdc47deae,0xe1dddf97,0xe613e0a8,0xeba9e444,0xea38eefc,0xeeaeeae5,
0xfe59fb7c,0xfd4df991,0xf359f908,0xf97ef91b,0x04bdf6d1,0x158a0fb5,0x0b160ddb,0x151410e9,
0x2db924f3,0x30af33a3,0x295e30b6,0x120e1e14,0x1803172a,0x132c1af7,0x03f207ed,0xf660f76f,
0xf799f4f4,0x056d02d0,0x08c70660,0x0aa5088e,0x05230c91,0x02e8038d,0xff410415,0xf38af633,
0xf315f344,0xee84eebb,0xed44e94f,0xe55eedae,0xdf0cdf25,0xe1c1de9e,0xe112e38e,0xecfae859,
0xe9b3ed8c,0xf6b6e725,0xfa19f918,0xfbadff10,0xf99ef51a,0xf61af749,0x06edf815,0x0f3212a4,
0x0ae60f1f,0x170c0e54,0x2df6246a,0x31a22fc8,0x25053305,0x13d71bec,0x1b4015f9,0x12a01686,
0xfe910a05,0xf3e4fa7a,0xfad6f27f,0x04acfeb6,0x0485062d,0x0b1e08e3,0x041f08fd,0x04ac0186,
0xfbe602d9,0xf417f538,0xf1adf1c1,0xe988ef7a,0xeedfead3,0xe470e947,0xdafde003,0xe032e13d,
0xe186e00c,0xf030e708,0xe49de814,0xf34dee00,0xfe8af52a,0xf910fb1f,0xf9a8f734,0xf13ff597,
0x08bcfc69,0x10370eb0,0x0a810c63,0x186e0d13,0x28722668,0x345e314d,0x26512f5a,0x16d917f4,
0x17741960,0x11931a2c,0x025a08bd,0xf54ff7c7,0xf966f524,0x04eb012e,0x05b204a6,0x0b9f0af4,
0x03170932,0x066a0559,0xfc3d0214,0xf39bf81d,0xf469f472,0xecd5ec16,0xec87eef9,0xe475ed48,
0xdf67dfc2,0xe29ce156,0xe16fded7,0xeb54f062,0xeb83e661,0xf44eec11,0xfeebf8c7,0xf97efa0c,
0xf98afc50,0xf539f153,0x0995fe45,0x0f3b0f24,0x067b0d0a,0x1a2c1174,0x2b2421e0,0x36813069,
0x215b2ee4,0x18351b5f,0x1b891733,0x126a1707,0xfe5c0ada,0xf407fb08,0xf999f5b0,0x03030230,
0x062103c7,0x0be90b6b,0x0555054f,0x04d10668,0xfd5e021f,0xf65af4ef,0xeef9f68a,0xeb76f01c,
0xef05ef14,0xe54feaff,0xe048debd,0xdd37e523,0xea5bdd35,0xeb2deaad,0xe9f9e7e7,0xf44cec5d,
0xfad3fc26,0xfe6ff841,0xf682fbc4,0xf646f0cd,0x07f50038,0x0e6610e7,0x0b930722,0x1a130faf,
0x27d3215f,0x339e360d,0x23132ba4,0x18f31996,0x18cc18c2,0x11f118c7,0xffc5086e,0xf3d0f9b1,
0xfa80f4fa,0x01800102,0x079b0190,0x07e60b2a,0x06340571,0x06890339,0xf85401b2,0xf578f8ac,
0xf0a1f3a9,0xecd5ec7f,0xed5deee8,0xdf7fecda,0xe562e026,0xdceddd08,0xe86fe082,0xe9dfe9e4,
0xe6bce852,0xf87fec39,0xf7f7f809,0xfecdfad2,0xf1e6fb2d,0xf5d7f30e,0x0c3cfe7e,0x0b200dc0,
0x09700808,0x16ff129d,0x2d731df7,0x333a32dd,0x20832ae6,0x187f1bf3,0x1a711861,0x111c18d1,
0x009408d8,0xf46cf95f,0xfcaaf59c,0xff4a0077,0x09e8039f,0x0a7e0782,0x03c205f3,0x055908e3,
0xfba90041,0xf77ef84b,0xef31f50b,0xeb37f071,0xf183f251,0xe3a4e6bd,0xe208e5fb,0xde5dde5f,
0xe7d8e416,0xecfaebb5,0xe862e519,0xf7cbf1fa,0xf71cf80a,0xfec400dd,0xf625f8e3,0xf7b7f0dc,
0x0b5f0305,0x09450ee5,0x0f3b0787,0x17390ea5,0x2cf62077,0x31a234c8,0x219e29e5,0x18061c6e,
0x1ab31a9c,0x115f184a,0x017608d5,0xf433f861,0xfe05f795,0x01c1fb9a,0x063c03ff,0x06970bd3,
0x06f604c6,0x04e0075b,0xf9a00045,0xf51cfbd4,0xf11ff517,0xf0fbea3c,0xeba8f3a0,0xe5f6e7f8,
0xdec8e61f,0xe021deaf,0xe940e178,0xe837ed95,0xe976e46d,0xf4b5f40f,0xfcccf400,0xfe8dfd66,
0xf1e2f9be,0xf72bf220,0x0d7703ab,0x08ae0941,0x0bb109fe,0x15900ec5,0x2e952019,0x307732bf,
0x20f1290c,0x19101b32,0x19cd1ad1,0x10681818,0x005e09eb,0xf800f4d6,0xf9c2f7bb,0xff19fe4a,
0x09a002c4,0x06370711,0x05ff053d,0x014d093c,0xfc060045,0xf86cf7bd,0xeb41f45a,0xf279eec9,
0xea70f046,0xe929e8db,0xe0f9e063,0xdd88dec9,0xea0ce331,0xe42aed44,0xedefe449,0xf2bdf07b,
0xf94af718,0xfd66fff3,0xf2bbf7be,0xfb26ee16,0x0a1f0575,0x08f80834,0x0b4c09b5,0x14060d81,
0x2d3322e3,0x2f6232b7,0x1fef287e,0x19f31c33,0x1afe1adc,0x14fd15bd,0xfd570836,0xf764fa26,
0xfccff75f,0x00b0fb3c,0x0761055f,0x0414092d,0x094107b8,0x05b6052a,0xfac5000d,0xf922fccc,
0xedf7f148,0xf3b3f27d,0xee5ced34,0xe65cec3d,0xe0e8e4d6,0xdd4ae054,0xee74e6bf,0xe53de8d0,
0xec0de9c2,0xf322f31c,0xfd59f6d1,0x00a8fed8,0xef6ef7ea,0xfdfbf28d,0x09490647,0x098908a0,
0x09850ba8,0x15720d51,0x2d1423d1,0x2e823365,0x2179274e,0x1dbd1a80,0x19271915,0x11f91adf,
0x00470625,0xf89ff7d4,0xf8b8f8a6,0xff0bfcfb,0x07f2057f,0x07b30340,0x05fd06ac,0x02ff0811,
0xfd41fd49,0xf5e5fd34,0xf103ee58,0xee22f30e,0xece5f01a,0xe5aceb7d,0xe1b9e444,0xdffdda76,
0xe8a4e9ab,0xe4a0e8e5,0xed32e895,0xf35cef97,0xfb04f604,0xfea9019e,0xeeb4f3cb,0xfe53f3d3,
0x06ad0567,0x0a7507f0,0x07da0928,0x14be0ce8,0x2dcb233f,0x2ebd308e,0x1f3c2534,0x19d51f0a,
0x1da717d0,0x1287174c,0xfde7063e,0xf7aafb12,0xf966f873,0x02fef9b4,0x039a04b3,0x0533076f,
0x086f0662,0x016f072e,0x0242fd4d,0xf352fa98,0xf220f20b,0xefe0f163,0xeee3f01f,0xe8bfe953,
0xdb9fe6bc,0xe204df40,0xe9ede919,0xe7a6e677,0xed01e89c,0xf2eaf11c,0xff1cf4e2,0xfd5b0241,
0xef73f25f,0xff1ff6e1,0x05440505,0x090f0afe,0x08990899,0x178c0ab9,0x2d8a226a,0x2ae432ca,
0x23d12474,0x1a381ba8,0x1b2a1ad0,0x0f681b25,0xff780695,0xfacdf9df,0xf6a3f720,0x013cfe8a,
0x064302c1,0x058f04c6,0x0b2306a3,0x000003af,0xffde034c,0xf483f935,0xf2f6f2c5,0xf23def94,
0xeae5f111,0xe970ee74,0xde01e2b3,0xe562deac,0xe8b7e81c,0xe76be81e,0xef4fe8a0,0xf105f04c,
0x00b4f773,0xfab702e3,0xf07bf1f6,0xfdb4fa32,0x077e04ab,0x0a840998,0x06e507ed,0x15070dfc,
0x30f823da,0x2b162e0f,0x208f277d,0x18b81ed4,0x1e2d1bd1,0x11d71834,0xff020528,0xf84bfeb8,
0xf9c9f5d4,0x0130fd1f,0x067802ff,0x05d80233,0x06a10afe,0x0335024e,0xff7a0305,0xf680f75a,
0xef71f338,0xf0b8f417,0xef0aed8d,0xe91eee14,0xdd62e0e6,0xe43be1f5,0xe993e708,0xe691e6bf,
0xee49ea47,0xeff4ee30,0x00c4f94e,0xf686027c,0xf313f1b2,0xfeb0f764,0x05e5036b,0x06950b55,
0x07e80734,0x16ae0897,0x2c4c2597,0x29582e02,0x222625e6,0x1a981a52,0x1c131b6e,0x0c721b08,
0x01dd04e8,0xf739fc1d,0xfa03f577,0x012dfafa,0x0148044f,0x09870204,0x05c3072e,0x05c50139,
0xfbba0263,0xf3c1fbbd,0xf2dff1d8,0xef1ef2e2,0xf03cee74,0xe6f7ef94,0xe0b8df9c,0xe537e0e1,
0xe8f2e7d3,0xe805e61b,0xeca1ec39,0xefcdee30,0x030efc65,0xf79efe91,0xf377f29a,0xfdfef9d5,
0x0a20036b,0x09fe06fe,0x03b207f9,0x173d0c61,0x2d0025f0,0x2b592ba9,0x1fef267c,0x18891dfb,
0x1f921d8b,0x0d5f1770,0x035a06c8,0xf844fb1c,0xf72cf7ca,0x03bbfd75,0x0196004e,0x0a13045e,
0x032706a1,0x03c806cd,0x0012017d,0xf3f5f964,0xf433f3bf,0xee46f273,0xf3f5efd6,0xe696ed9f,
0xe129e119,0xe691e1c4,0xe6f2e86a,0xe919e7e2,0xece0ec75,0xf494ea75,0x015ffdd4,0xf5efff55,
0xf5f5f3e4,0x006bf720,0x06210540,0x08e90b21,0x050c0586,0x19f80ae2,0x2a2a2598,0x28ae2e76,
0x21692709,0x1a971ab0,0x1e5e1fb0,0x0d8a15dc,0xffe7093e,0xf90bfd32,0xf984f38a,0x01defe4d,
0x003bfe1a,0x0599086f,0x05df04e0,0x033e03c3,0xfe6202e3,0xf37bf7ef,0xf49bf461,0xeea2ee72,
0xf31cf183,0xe631ebc5,0xdfeae060,0xe585e33c,0xe66fe68a,0xeb10e688,0xe7c1eb34,0xf3fbed0d,
0x01bafdb5,0xf7d1fa24,0xf1e9f3da,0xfe8cfabc,0x089002a0,0x090b08ae,0x0296030f,0x172f0e56,
0x2a502527,0x29572b60,0x1e8d2751,0x1c4c1a86,0x1b3920aa,0x0f551690,0x03e80572,0xf753fcb3,
0xfa9af3e5,0xfd1500ea,0x0446fe54,0x056b0575,0x04440717,0x04a20482,0xfeb403f1,0xf6f0f64c,
0xf3c3f5e0,0xf14cee20,0xf276f3a9,0xe4f0ee55,0xe23be1b8,0xe742e440,0xe5d0e641,0xeaf3eba3,
0xea36e983,0xf935eba3,0xff2ffe6f,0xf757fdf4,0xf68af2b7,0xffc3f99e,0x080503f8,0x05280cb3,
0x04cd034e,0x19b00cd0,0x29432475,0x2ad22b7c,0x1c6825fc,0x1ea61cd4,0x1e4e1d0d,0x0d96155a,
0x03a607a8,0xf31efdb2,0xfd8bf698,0xfccffc01,0x0243fffd,0x060d0492,0x03c70576,0x0656039a,
0xfbea033a,0xf7dff761,0xf071f5c6,0xf078f065,0xf389f3f8,0xe56aebcd,0xe24ce12a,0xe4bae6bd,
0xe993e3f5,0xebf2e993,0xe68fe823,0xf77cf111,0x01a4fd09,0xf7aafa77,0xf61ff33e,0xfd6cfb02,
0x0ad804d9,0x0590091a,0x04390272,0x19920e31,0x275b2390,0x2a062e08,0x1f9e21f5,0x1db31cef,
0x1d221f44,0x0c4a158f,0x05540a6c,0xf572f8de,0xf9edfa54,0xfcc2fcd3,0x01950015,0x06ab04bd,
0x0331040b,0x0761052f,0xfb040162,0xf75ffa56,0xf195f46c,0xf258eeb0,0xf228f4b8,0xe27ded63,
0xe5c9e1e2,0xe44be3ef,0xe830e4be,0xe8afed56,0xeb02e4b4,0xf913edde,0xff70fd66,0xf54bfb2f,
0xf738f495,0xfec4f7a8,0x0953060e,0x0332096c,0x0337021d,0x180a100c,0x2b812005,0x27e32b7b,
0x1ecd2288,0x1ceb1d74,0x1c1c210e,0x0f45127c,0x001c0cae,0xf71bfa6c,0xf9caf953,0xfdb2fbf7,
0x023efe1d,0x060604f2,0x03be022f,0x054207f6,0xfd26007c,0xf7fdf9f8,0xefaaf4d2,0xf187f1bc,
0xf4b6f60d,0xe47ae949,0xe509e472,0xe26be62b,0xee28e4bf,0xe946e9aa,0xe9dce607,0xf848f15a,
0xff33ff92,0xf7a8f96c,0xf5d8f618,0xffb2f92a,0x09ac0799,0x02a00971,0x08310072,0x171c0dd5,
0x2ac422a5,0x26cf2b80,0x1f1f236f,0x201b1c85,0x19572112,0x110814f3,0x00e70adc,0xf89afaa9,
0xfab1f849,0xfd17fc04,0x0257fe3c,0x043b05e6,0x05200266,0x052f0735,0xfce200b7,0xf76efb08,
0xf084f48a,0xf292f0a6,0xf374f6b2,0xe42fe9d8,0xe5cee4ba,0xe290e503,0xed9ae582,0xe8d1e9f2,
0xe9f7e609,0xf8a4f11f,0xfefcff6c,0xf79ff985,0xf5c9f61b,0xffb0f931,0x09bf0798,0x0000094b,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};
