#include "piano_samples.h"
const AudioSynthWavetable::sample_data piano_samples[4] = {
	{
		(int16_t*)sample_0_piano_kpianob1, // sample
		true, // LOOP
		15, // LENGTH_BITS
		(1 << (32 - 15)) * WAVETABLE_CENTS_SHIFT(-43) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(75) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)17231 - 1) << (32 - 15), // MAX_PHASE
		((uint32_t)17227 - 1) << (32 - 15), // LOOP_PHASE_END
		(((uint32_t)17227 - 1) << (32 - 15)) - (((uint32_t)10655 - 1) << (32 - 15)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-15.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(630.32 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(12596.93 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_piano_kpianocx4, // sample
		true, // LOOP
		15, // LENGTH_BITS
		(1 << (32 - 15)) * WAVETABLE_CENTS_SHIFT(4) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(77) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)21573 - 1) << (32 - 15), // MAX_PHASE
		((uint32_t)21569 - 1) << (32 - 15), // LOOP_PHASE_END
		(((uint32_t)21569 - 1) << (32 - 15)) - (((uint32_t)21506 - 1) << (32 - 15)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-15.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(630.32 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(12596.93 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_piano_kpianodx5, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(29) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(106) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)6145 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)6141 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)6141 - 1) << (32 - 13)) - (((uint32_t)6093 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-15.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(630.32 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(12596.93 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_3_piano_kpianof502, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(30) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(111) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)4463 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)4202 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)4202 - 1) << (32 - 13)) - (((uint32_t)4148 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-15.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(630.32 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(12596.93 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_piano_kpianob1[8704] = {
0x00000000,0xff2cfe83,0x006fffd0,0x01b0008d,0x03ec01fd,0x060e06f1,0x080b057c,0x036a0618,
0x03fe02b7,0xffe30299,0x031601e9,0x02ca0252,0x02aefe06,0xf4fffa2f,0xfafcfdd6,0xfa0eff91,
0xfb320136,0xf2d9f597,0x0176f6be,0xfdaafbeb,0x1045fa37,0xfd460886,0xff85f155,0xdb9aef93,
0xecb1cec4,0x0dbd19bf,0xe8a3f8f1,0xf1b7dd57,0xf864f4cd,0xd777fd52,0xe036ebc9,0x0384eabf,
0x13eb306a,0x229bee8e,0x396e334b,0x5cfc4406,0x49ea59e2,0x296c36aa,0x2b983360,0x152e23bb,
0xf7a30a12,0xecb4fc65,0x07c9d148,0xf0a62714,0xcf67d21f,0xb82ebaf3,0xfcacedb3,0xfeeafa87,
0xbed6bead,0xf0eac99d,0x144c1237,0xfaf3fa51,0x078e1546,0x036a0839,0x094b033b,0xe53ae6ea,
0xe381d18b,0xc6bbf99d,0xab11ba19,0xcd13b70b,0xc968ceb1,0xe234e14d,0x075ef93d,0xece20f9c,
0xf8dee7f7,0x2eb9f537,0x52db5f66,0x414a47ce,0x1f6831e1,0x3ed52d0e,0x46573b4e,0x4ae5499e,
0x12e33fe9,0x27eb012f,0x25f4259b,0x063b28ac,0xff00d963,0x1d0f1b73,0xffbe2021,0xb803d098,
0xbb6cb475,0x0163ffd2,0xe385f65d,0xcf6ac5b2,0xf35bef5b,0xfe51e7e0,0xffa100ab,0xec71e6d8,
0xffa0f469,0xfa700ecd,0x197ffde6,0x187f21b4,0xcec1f1c0,0xcdc2cebc,0xbd13bc82,0xbf79c234,
0xe863cacd,0xfbcbf8b3,0xd4a4fd62,0xeb23ccc2,0x36741823,0x54ad3df9,0x34734827,0x25ff2794,
0x361438bf,0x4f823743,0x288f59c5,0x31a32e4c,0x2b322100,0x04013121,0xe82adf1a,0x211af9a5,
0x04163146,0xc45cf515,0x92b39737,0xd375b70c,0xf060e986,0xda5ebc38,0xf784e4c7,0xf5ebeef8,
0x0f7e1064,0xff011356,0x0de5f898,0x014615c2,0xf19ff4a0,0x26af1939,0xe8450716,0xd4dddd4e,
0xb6bab652,0xa695af30,0xd298c4ea,0x0db9ede6,0x00d122a0,0xe85bdad1,0x1cebfbd9,0x4eb2390b,
0x5192572e,0x242e332c,0x15772c4c,0x45502211,0x2a5141cf,0x29603bb6,0x237d0b2f,0x21f72d06,
0xef0c1a14,0x20abf6df,0x2cb134cc,0xf51e26ea,0xbc5fcea4,0xbc57969c,0xe004cd73,0xc500cf8e,
0xec44e288,0xec68e7d0,0x06cde9f8,0x09c9180b,0x075800f9,0x14841904,0xe306fcbe,0x249dfc8c,
0x05801151,0xde32f9dd,0xd44cdcb0,0xb30cbf82,0xd226c3d4,0xfffcd4ff,0x172e24db,0xee04f76a,
0x0151e610,0x2ace154d,0x44454c1d,0x259226b5,0x009c230a,0x3d6e18cd,0x3f2b37dc,0x287d47ab,
0x1ab321b2,0x335a1964,0xf3cf2774,0xf0b2e8c9,0x28edfb8f,0x05241ae5,0xb959e315,0x8c2a9b9f,
0xd5afbddc,0xda12d7b8,0xde23d0f8,0xde22ef8b,0xf01edd57,0x1e341450,0x081814d7,0x327816b3,
0xf35d1052,0x0e44f7d9,0x1d3016bf,0xeabe02c5,0xdda3df6f,0xb62ac6a2,0xb548b945,0xd795b790,
0x13def63c,0xf5a00a6b,0xfaa0eb09,0x13e0fbfd,0x410b4d1b,0x55874388,0x18863ca8,0x2669211d,
0x420d3219,0x3cca3b80,0x143e44ba,0x334e1b3b,0x1d3d2a9c,0xeda504a0,0x19f6fe7f,0x2bab328b,
0xfd451690,0xabb6c56a,0xc490abeb,0xd4c8dea1,0xcdfdcb5b,0xe7c8e89c,0xdedad71e,0x145df06b,
0xf8131571,0x23ba07b9,0x054719f8,0xef84ed70,0x15e005f4,0xeba10ef9,0xde3fe7b6,0xc5fac2b0,
0xa345b385,0xb6dca687,0xff88c6e5,0xfdf50f75,0xf0d604d2,0x041ce4f4,0x2ff53780,0x60f64b5a,
0x3ad44bf0,0x0eef1edd,0x33fd3195,0x47ab2ce8,0x20a03d1a,0x1af91f84,0x2bab3261,0x000c1362,
0x00c7e793,0x26501539,0x18f2309f,0xc8dffa0c,0xb1eeaeda,0xd477ce0e,0xcedec65e,0xe44bd792,
0xd10ae4b1,0x04edd849,0x07dc0e8f,0x16530488,0x19bb1f37,0xe42508a4,0x1296fa8d,0x0ae41824,
0xee6c0320,0xdc4fd753,0xb095c360,0x9ff8aa16,0xdd71b0a1,0x0055e8b1,0xf19d16ba,0xfa20dd6d,
0x20120958,0x4d1041db,0x64795fde,0x26432fc1,0x26702b13,0x3f183c0f,0x36ec4877,0x2fdf234a,
0x4131237a,0x10fc2aca,0xed8efe4d,0x11b2f7d6,0x321b3007,0xf6b31df1,0xb3ddc57e,0xc215c75e,
0xc1f6cfce,0xde5ac758,0xc979de0c,0xe39acc0e,0xf967f977,0x010e042d,0x21200f76,0xf58216ec,
0x07e4f493,0x243dfe93,0x00a708bf,0xe374e6f5,0xd06dcaef,0x8b19ae5e,0xadf9a5b6,0xe6b3b630,
0xf0540794,0xe860ee55,0x1547de81,0x2edb141a,0x5be05fd1,0x3d5d5840,0x26832ed4,0x44892e09,
0x481546df,0x2e7133eb,0x3eb83228,0x2cb73eef,0x00972092,0xfaf0f413,0x2f9519a6,0x1b403dde,
0xcfbfee11,0xcca1bd7c,0xc11ec02f,0xd1e6b90d,0xc4dcd83b,0xd23ac897,0xec46dda8,0xf120f97e,
0x1bec01c0,0x09fe117c,0xf55e0014,0x17a6f482,0x0d1b10ca,0xe21c0b8b,0xeecce74d,0xa6fdcb19,
0x9ce3afc8,0xd552a5c7,0x0a56e299,0xe43cfd82,0xee5cf244,0x151b057f,0x58673c08,0x5b615ab6,
0x2d79449b,0x34c824dc,0x51d145cb,0x2feb37b6,0x3bcf2fb3,0x39d83d04,0x16343834,0xf3c10302,
0x1ba9f00c,0x39e73761,0xec5d14cc,0xccb4d0e2,0xaf57cc5d,0xc3abbcc5,0xc0b2da71,0xc76dd15c,
0xea2acf1b,0xe6ece862,0x119dfa6e,0x16d30722,0xf5fa081c,0xf736f9d5,0x15080483,0xe21210fa,
0xec4ef31c,0xd428cfa1,0x94fbaace,0xa0fc9e80,0xebe2c795,0xee01f4e0,0xe951e9b5,0xfbefe716,
0x385d188f,0x5db44c1a,0x4711534c,0x2505249b,0x53673b44,0x314549fa,0x31bc3b29,0x45a93e6b,
0x37d53ee0,0x05b321a1,0xfa56f315,0x40d627be,0x12df3ebf,0xe2b7f036,0xb7dfe1ae,0xc1fabde8,
0xce16ccfb,0xbfa9d1e3,0xe9f3c6fa,0xdf65d75d,0xfeecf383,0x1a0a0e46,0x0dca0f2e,0xeb5811f1,
0x27d40106,0x0f810546,0xecaf0414,0xeb37f110,0xb55dcc86,0x97889a33,0xcd61ab5e,0xee06eb18,
0xe8cbfdc0,0xe725e6b3,0x181bf801,0x45c92b85,0x52de5334,0x0ea138f9,0x3a4722a4,0x3bac421e,
0x2e612748,0x40652966,0x40ea38e0,0x1e1b33a6,0xe80e038d,0x26d2fd9f,0x287c4c25,0xfceb0872,
0xccb8ed84,0xb973c1df,0xdd42b5cb,0xbca1c5eb,0xd84abd83,0xd729d1d5,0xe023da4b,0x050208f0,
0x1ebd0133,0xf0520659,0x010e0407,0x12021359,0x00430db0,0xf214f9bc,0xd6fef674,0x9887b94f,
0xb3a3a452,0xed52d110,0x0089f355,0xf089ea6d,0x0422e5f3,0x2dc31bf0,0x69c347e3,0x31a05385,
0x2dcc1d1f,0x48263dfe,0x30293394,0x30d2254e,0x3d273899,0x30344234,0xf71128ff,0x0a17e34d,
0x36d53ac7,0x1da8259b,0xf5dbfec5,0xbbaede12,0xd610bbf5,0xbf06d33c,0xbe2bc80d,0xde75da14,
0xdc24c20d,0xeabff5f7,0x13a308e9,0x010a0641,0xfa21f632,0x098a00ab,0x02150c51,0xe97dfdc3,
0xf400f582,0xae72ccbb,0x9b8594f7,0xc8e6aaca,0xec77dfbb,0xe65cfaa1,0xf021dcff,0x0e16fd21,
0x57e92adb,0x52225ef9,0x28702dd2,0x45d4323b,0x3a8246b3,0x244d304a,0x377838d7,0x3ce74089,
0x15ac48d0,0xf81de8c5,0x2ca71224,0x29dd38fa,0x129313bb,0xce6afba1,0xcd8ec547,0xe1f6c85c,
0xb70fb842,0xc9a9e11b,0xd97cccbd,0xe287d60c,0x0d3ef937,0x05270d1a,0xf7ae01f3,0xff0e038a,
0x0e3b1042,0xf8b307b2,0xff41f8c3,0xd5d5f5dc,0x9989b179,0xb24f9eac,0xe038c259,0xedb6f5c5,
0xe8bce3df,0xf337ec5d,0x33bd0a6a,0x5b86561c,0x2f7a49d1,0x32b52fc5,0x499947e5,0x26e93b8f,
0x34f3342c,0x4a3d2b89,0x348b56d5,0xfa4b0a24,0x16f7f28e,0x2b4731dd,0x2c2421e7,0xfc130752,
0xb9f7d46a,0xd1d8dec9,0xc18bbddf,0xc57cc6fd,0xd287c918,0xc9b7cd8e,0xf850e1b7,0x04a30d44,
0x01ca0041,0xf87dfc8a,0x0bbd0b94,0xfe5a1156,0xfa920397,0xffbd032b,0xaefbd5eb,0xa0a5a2f4,
0xc704a82a,0xed03df8c,0xed79e300,0xe8c3e451,0x0dd7e6f4,0x517a3923,0x463b53d3,0x28dc3979,
0x534439ae,0x36fc42b2,0x2c623fd2,0x3d4a27a1,0x4d2d5cf4,0x14343334,0x1051e778,0x1e3311f1,
0x1fa53429,0x1af4274c,0xd05ae587,0xd38cd98c,0xc9c2c42c,0xbeccc5a6,0xd0afc5c4,0xc5e6d37d,
0xe466c732,0x01cc01c2,0x02e303b5,0xf37700bf,0x0e060378,0x0b20067a,0xfd6e0276,0x123dff71,
0xd9b1f5e0,0xa594b692,0xad90999c,0xdcefc9f7,0xe7d0e31d,0xe1b7f19e,0xe2f4dc4f,0x34271a3c,
0x54334783,0x295a4730,0x440634b0,0x3ff840a2,0x2e7e4beb,0x324e1e03,0x64753520,0x1ed44ea7,
0xfd451083,0x1b70fac1,0x1bbb1b90,0x2d6e3581,0xe8ef0615,0xd7b6e2f9,0xd183c94e,0xc842c5c0,
0xcb9db7b7,0xc648d9d5,0xcacbc267,0xf6eeebfd,0x097a04ac,0xf69a0019,0x0547feb0,0x0e830a1f,
0x00a3029c,0x0c9100ea,0xfa0c0b9a,0xbc56e1b6,0x9d3fa2cb,0xc9b7b601,0xe07fd55e,0xf439f2a7,
0xd2b0d75c,0x07e8f826,0x4c2e3810,0x33e14c84,0x3d483931,0x4a432d8b,0x41d34697,0x133c33f4,
0x58f2260f,0x497451d3,0x03e02a72,0x0fdf0388,0x0f750a00,0x3c7a3199,0x0af61e78,0xed03f055,
0xd17dd20a,0xc594d3f1,0xbaa5c22b,0xcb08d9ea,0xc52dc3bc,0xdeb6cfc7,0x0b87fa53,0xfe640006,
0xff49f688,0x10e40764,0xfe300597,0x03df05b7,0x07880cc3,0xe37102ec,0x9f25ba6f,0xbaa0a14a,
0xc7dabd25,0xf0e3ebcd,0xcf28e560,0xe08ed984,0x448309f3,0x40593079,0x2ffd40d7,0x32b5361f,
0x59d039de,0x18ef3f73,0x2ead1ed5,0x5b0254bb,0x186e4a5a,0x18611498,0x080efe0f,0x3c7319fa,
0x1f6f359c,0xfe7c1014,0xd661e99e,0xd2ecdffc,0xc187c43b,0xce5dcfb0,0xd040c724,0xc96dbfa4,
0x0079e03e,0x00bf05ad,0xf736f8f6,0x0f870316,0x02a20de9,0x0c6500b2,0x10de02e7,0x0eb40cc6,
0xb256e918,0xb136ad0f,0xb14eb225,0xe94ed908,0xef22e751,0xc237cb80,0x0c37f510,0x3a782d24,
0x40d2322c,0x1de83f25,0x501e31c1,0x30de500e,0x0f9021c0,0x618032e1,0x3bca4d5b,0x251b1d49,
0xfb1e099d,0x23ec049b,0x29b337bd,0x14c725b3,0xe535fb99,0xdafcea9f,0xcdabc6f6,0xcb72c7fe,
0xd3dcc790,0xbda4c588,0xe1afc5d5,0x0023ffc2,0xf310fbd1,0x06dcf647,0x0b270a5e,0x0213f9a6,
0xfaf5093a,0x1a471019,0xd6ba0d33,0xbb6ebfe6,0xab35a2d0,0xc966c035,0xf57df0c1,0xd24dd533,
0xeb8ac894,0x200b2066,0x437f2f65,0x25e3494c,0x3ef52bdb,0x53934cb6,0x135330d0,0x46e519ae,
0x4c31549b,0x33953786,0x01772400,0x0e7ffd5a,0x295129c5,0x2ec036a3,0x000f0f31,0xebfaf888,
0xd5cdd755,0xcaa3d049,0xcf20cef3,0xc1acd61b,0xc880bc92,0x009ce577,0xfa11fc2c,0xf800f1f8,
0x0ba008a9,0x00520183,0xf8b7033a,0x1f60f9d0,0xf4661848,0xc12dea65,0xafb1ad3e,0xb6a39ada,
0xe49bd436,0xd47eee2f,0xc75dbda3,0xfdbaff6d,0x38f21907,0x3a12396c,0x28822683,0x59cf3ecb,
0x254c4775,0x280612b5,0x4b85467d,0x3e9c46b2,0x0f513e9b,0x039f0699,0x1ad50d64,0x391c311f,
0x12252167,0xfac106a4,0xd8f9eb04,0xcf2bd84a,0xd1f1cb29,0xd42dd153,0xbb76bf6d,0xe860cd8e,
0x0106fdb8,0xf5b2f6b6,0x0f79feb8,0x105c0580,0xefde0d9e,0x16d7016e,0x25570f18,0xe505000a,
0xb4d5d95f,0xa6c8a568,0xce66bb03,0xe2f6faaf,0xc8dfc7f5,0xe828d600,0x1db50186,0x3e65334a,
0x217c305f,0x4d1f2e46,0x3db35707,0x1ab81edb,0x3c2e3096,0x4f8941fc,0x2bbc496e,0x0d92148c,
0x0715fed4,0x329f1f65,0x1f7b307a,0x0a7c1527,0xea48f952,0xd447daf4,0xc5e5ce31,0xd17ad525,
0xbf9dc50f,0xcbbeb360,0xfcd4e052,0xeb91f1ee,0xf22cfef4,0x1b89febb,0xffa9002a,0xfa21f660,
0x1b541454,0xfef712cb,0xcb0ffbef,0xaa81bc88,0xb9c99a97,0xe857e33e,0xcff5d83c,0xd4cfc737,
0x00d5e0c5,0x3ab41a02,0x27293500,0x37e1226b,0x519c56a3,0x267b3247,0x28ef2c7d,0x4de3364f,
0x427956ff,0x1f7d34a6,0x01000d08,0x28080c91,0x30123149,0x19eb2706,0xfbdc14a0,0xe1b6f59e,
0xd0a9d642,0xde07d1cc,0xcaffcd78,0xb035c0e8,0xed1dd1b2,0xfca0e488,0xeb9ff4eb,0x0894f8c1,
0x0b970f07,0xe9eff4dc,0x0ee10bd0,0x18000f45,0xeeb1068b,0xba4cdfc8,0xa2eb970b,0xdc3bc1b9,
0xd678deb8,0xcbf1ca0a,0xd8b3c957,0x2076fa78,0x295630f7,0x21ca19a0,0x4fad47bc,0x32a73edf,
0x1fef3137,0x37eb24cb,0x4f054b51,0x35b64309,0x01862059,0x063f083c,0x2a172950,0x291c2bec,
0x10c31b10,0xf999010a,0xcfc9e075,0xd664da18,0xe2e7d3a5,0xbd30b770,0xc8b6c49f,0xf466e454,
0xf285f2d9,0xefddf2ee,0x1b2311b2,0xf2f5fccc,0xfee3ff1b,0x1898151c,0x0ed00dc1,0xe2a2016d,
0x9fc8b2d5,0xc978a8cc,0xd95fdc4c,0xd711d734,0xc5a2c83b,0x0008d757,0x2aca2a50,0x14e11bc2,
0x458b39fe,0x43db4858,0x30c739b4,0x2c0c1e71,0x49103a0c,0x439356cd,0x1da83ec0,0x091b083f,
0x248f108f,0x31ff2865,0x166d2cac,0x107216f1,0xeae2ee27,0xd26ad0a2,0xdb1ce662,0xc4efc99f,
0xb63dbfcb,0xde6ad336,0xfb04e9de,0xe119ea51,0x100e015e,0xfdc30eca,0xf4b9f1d1,0x10b907a6,
0x130d093e,0x03ed13f7,0xae52dc84,0xb3229c1b,0xd12cc60d,0xdafbd346,0xc379d206,0xd1a9b786,
0x25070c69,0x164711ea,0x38151c20,0x45413eca,0x35bb449b,0x1f012ead,0x36132a1a,0x4f5a4ab7,
0x3533501c,0x06962035,0x11b4100d,0x3ae3176a,0x2753288e,0x1643241e,0xfe2f131c,0xd696dbf3,
0xde3ee776,0xd2dfdbfa,0xc15fbdc7,0xc3d3c47d,0xf646e5e8,0xe53aeb5a,0xff23eedd,0x0fc51462,
0xf453f881,0x08c5ff1a,0x125f0722,0x25041322,0xd8e00791,0xa9c1af10,0xc44fb723,0xd230ce1b,
0xd4b2e39d,0xb722adf6,0x105cde71,0x0ab5126f,0x1b7d1750,0x3e90350b,0x3f1c44b3,0x26bd3730,
0x217a2432,0x406d3965,0x51665579,0x293e26da,0x04100b44,0x1f6c1534,0x2fb829fa,0x1aef2595,
0x13682979,0xe797f102,0xe0abda6e,0xd55febca,0xcad9ca4b,0xb5a8bc15,0xe48fd1a7,0xe8d2e97c,
0xeb0be2b4,0x11890779,0xfc3f04d7,0x0165f6fe,0x03a10422,0x20790e15,0x044328b3,0xb553d912,
0xbfcbafd2,0xca0db941,0xe787e0d9,0xaa18c1f4,0xe819bf70,0x0f000320,0x0eaf0abc,0x2cde248b,
0x40a746cf,0x35e744ba,0x2d8f26bb,0x376d1d6c,0x51814dfe,0x3c5f4aff,0x11521d0e,0x0c631044,
0x3179240a,0x256e200f,0x224e2f48,0xf93b159a,0xe408e00b,0xe01dec39,0xd1baddf3,0xb4d7c62f,
0xcf1ac05b,0xea60e49b,0xe3d4db7c,0x05a1f3a1,0x03520a26,0xf9c1fc21,0xf8d4029b,0x1415fdd9,
0x2e35203c,0xd43bfe21,0xba3dbf1f,0xb251afa9,0xe9b1d139,0xbb9ad2e0,0xbdaaabcb,0xf755e76c,
0xffc80b48,0x21d50c69,0x47892621,0x391a41e1,0x2c9b38e0,0x26021d21,0x46243396,0x4a715959,
0x2aac3390,0x04ce0fc4,0x209b1fa0,0x290920d8,0x2c5c2831,0x11af2cd9,0xebd0f67d,0xe3fbe756,
0xde98ed85,0xc5a6cfd3,0xbf7eb2ea,0xe2e7d841,0xdb51dc18,0xf2e5e829,0x03ac0592,0x02d1023a,
0xfe74fb4a,0xfb67f4c4,0x33681636,0xfc0b20e8,0xd2b9db99,0xa6dcb044,0xd8bcc0a9,0xc9eee6d7,
0xac86bc67,0xe8cec0c3,0xffb5f433,0x05eb056a,0x35f71748,0x3fdc3844,0x30e440b3,0x23fd2b44,
0x36e81a80,0x4a414d01,0x3fdf4e74,0x13cb1a1e,0x175e11e4,0x217a200f,0x2cd322ba,0x240d3751,
0xffe51515,0xe96fe9c5,0xeb88ef13,0xd165e3e2,0xb134c010,0xd7b4ccc0,0xd863dc3d,0xecfad91c,
0xfd1af4c6,0x020704ad,0x03f20226,0xef64f553,0x2ca9f7ce,0x12b62d5e,0xea21088c,0xa907cfa4,
0xcb37af30,0xe139da3a,0xb182cdbe,0xc4cab75a,0xfc03de9e,0xfbc5f94d,0x1a950a9a,0x42452a4e,
0x38c33f2e,0x26ec3da8,0x2a1b19ef,0x45d730a9,0x4f54540f,0x23f23674,0x12ea13f4,0x17732057,
0x2b9e1b0a,0x30cd3151,0x16d02c90,0xef79ffa7,0xebe2f044,0xe598f8a3,0xbbe3cecc,0xcfd1b9e3,
0xd17ddbaa,0xe08dd411,0xf61be721,0x01cdfaa7,0x0ffefd7e,0xe1510317,0x0a7dee5c,0x1f0927ea,
0x12bd17fe,0xc182efe9,0xb024b219,0xe0bfcbb7,0xc692d63c,0xae86b692,0xe5a5c43f,0xf71ae774,
0xfb67fdd1,0x2fa81878,0x43112f44,0x2ee03ee0,0x20b92448,0x31581dfa,0x5078461b,0x37b04d47,
0x1c1418ff,0x10311d90,0x1b0617b6,0x2d1128ac,0x2741383a,0x0502174f,0xed0fee94,0xf6f4f749,
0xc53deb2d,0xc827bb4b,0xd7e8cda9,0xd838ccc0,0xe9fbda98,0xef75fc02,0x1265fad3,0xf30a113a,
0xf910de53,0x12cf1375,0x22f02620,0xf237126c,0xae47c411,0xd0f5bc1a,0xdc39d94a,0xaf51c1bb,
0xc152bc2f,0xf11ddab6,0xf3fbece4,0x131b050c,0x3d792225,0x39f13f83,0x25f0335f,0x25d41bb5,
0x4a1f2a42,0x47e75903,0x24e13273,0x145c258c,0x152c1895,0x2a76193d,0x338732cd,0x19ab2d8c,
0xedf1088c,0x04f5efa7,0xe561fc37,0xc856c2e3,0xcd45ca7e,0xcf6ada11,0xe4e0ccc1,0xecd6f377,
0x06f4e95b,0x00822099,0xebeaec34,0x05a2fd09,0x20431a5f,0x1c092b65,0xc6a6e9ab,0xb88db8fa,
0xe0c5d75e,0xc32bcd29,0xb053b865,0xdc97c801,0xf012e12a,0xfd02f313,0x2a420b33,0x42d93234,
0x2d5d3a05,0x1e602b51,0x301a1a71,0x4eb9532e,0x394344c4,0x23922970,0x10281d95,0x19b71727,
0x35ec29ee,0x32103020,0x03e21fa3,0xfc60eb54,0xf5640e2e,0xd1afddd6,0xcc6fc0d8,0xd01dd773,
0xcf23c7e7,0xe668f266,0xf5a0db50,0x0f281602,0xec7cfd7a,0xfc80efe0,0x10370033,0x29fb3120,
0xf47c13af,0xb44cc315,0xd536ca6b,0xd128d848,0xb280bf67,0xc743b92d,0xeb5bd095,0xf2b9e296,
0x06b9fba2,0x389225f0,0x33563bc7,0x267b38b3,0x1fe31218,0x48643827,0x3f484f8c,0x2bc03c9a,
0x1fbc2408,0x14550dc9,0x2a371c91,0x35382fad,0x1bb53b11,0xfe20f75e,0x0b1e0380,0xe329f64c,
0xc3e8cc6f,0xd5f4d83b,0xc73fc0ed,0xe1c8e68d,0xe248d56d,0x1252fd28,0xf31a0b2a,0xf315f79a,
0x01afebe0,0x245b1bfe,0x18d934c0,0xc74de8d1,0xc949bfb0,0xdcd8d747,0xc451c6eb,0xb748b2bc,
0xd40fc6a7,0xe7c9de1d,0xeeedf026,0x280f0b19,0x38222e30,0x30cd42d1,0x143920db,0x39cf23dc,
0x4cd1443d,0x3b5f4305,0x299b30ff,0x0fe81b53,0x22f81511,0x385b19ab,0x32c2423c,0x02bc14ac,
0x078c029d,0xfde70c5c,0xc8fbdcfe,0xd7f3db68,0xc5adc33a,0xdcded953,0xcff2da6a,0x089be6f4,
0x020505ff,0xf17804c0,0xeef4ed99,0x12d9ff54,0x33863327,0xf2ab10b8,0xc628c46d,0xd74fd0eb,
0xce46d6e4,0xb3fabc67,0xc0d9bcf5,0xe2c1ccc9,0xde1ee2dd,0x046dfa17,0x2d361b6d,0x423a3ad8,
0x1a952945,0x238e1859,0x406337af,0x401d4c0c,0x3d41399c,0x1ac91fdb,0x14f21968,0x2308111e,
0x3eba3f11,0x17562a60,0x00120765,0x157b11dd,0xdba9ee2b,0xd98ee0f2,0xc54dcda9,0xe1e5cbe2,
0xc51fd921,0xf11bdd09,0x03c1faff,0xfc390bff,0xed99f790,0x012be72a,0x329317f6,0x14f83576,
0xd373e871,0xcf74cbf3,0xda63de36,0xbf95c53f,0xb151bde2,0xd112c796,0xdb6cda7b,0xf61ee3d5,
0x11fd008e,0x3f0b317c,0x24cf3b91,0x1b131ba4,0x39fb1f05,0x403e3f7a,0x439a446d,0x25bb2ed7,
0x19d5212e,0x0ffe08a2,0x3ce82d33,0x2fc037c5,0xffb713ff,0x19941129,0xf1c00448,0xe6fae226,
0xbbfbdbb2,0xdd5bcb6b,0xc4fcd94f,0xdcafd187,0xfc89e84d,0x07d201d5,0xf1e40130,0xe9f4e7f6,
0x1efff49f,0x2eec36a1,0xf1aa0d6f,0xc5e9d378,0xd899e0bb,0xcc39d28e,0xb783bf26,0xc877b6f0,
0xceced0ad,0xe4d4de7e,0xf7e4f079,0x396811e6,0x36793968,0x17ae2a36,0x2b3f19ab,0x39903304,
0x4ab1458a,0x30503afc,0x27ed2f65,0x091f0ccf,0x289d193a,0x42073e2b,0x11f82250,0x18660e2a,
0xfe991a49,0xf7e9f0f5,0xc513eb61,0xdc3bc79a,0xd36fd781,0xce65ca04,0xe99ede17,0x07b4f5f1,
0x01cc05b2,0xe824f511,0x0010da6b,0x2ad52576,0x12913374,0xd8adeb4f,0xda20d34d,0xd4dfd98d,
0xb98dcd28,0xbb4bb793,0xc7a1c734,0xe0b0cb75,0xe081e2b8,0x13f9f8b4,0x3d9c2de7,0x20e3351f,
0x21141914,0x2bb32623,0x4a763a52,0x372c4073,0x32fc3c4b,0x17321ac7,0x10e20472,0x40523357,
0x20363844,0x18da1116,0x0a2f2391,0x07d7fc47,0xdc7ff9fe,0xce13cd76,0xdb04dd08,0xcdbbc9fa,
0xd982cf20,0xfc6de5b5,0x06d1fefd,0xed3a0ceb,0xe6a0dce4,0x209efdc6,0x2c4634ef,0xed9b1273,
0xd582e02b,0xde2adba5,0xca13d619,0xbc75b886,0xbba5c379,0xd351c61a,0xdadfdb89,0xf1e7e2b9,
0x33c61089,0x2e9239e7,0x215c2032,0x1d1820a9,0x420f30a1,0x43623d64,0x38893fbe,0x23383852,
0x04060ce5,0x347e19b7,0x2f6d455b,0x21861536,0x12c627a3,0x0a610b3c,0xf8c00d46,0xd2e2d8c3,
0xe03ad8db,0xd3ccd272,0xc7d7cd60,0xea31e0ae,0x0730ee51,0x048e1017,0xdc47eca3,0xfe23e690,
0x34452535,0x13952870,0xe2a7f2d8,0xdd0adb17,0xd369e660,0xc15dc36f,0xb950c1bb,0xc50cbf61,
0xd7eed096,0xd94cd849,0x12e3ee1e,0x2fc03217,0x2ac827a8,0x173a1aaf,0x2d1f253b,0x419339b3,
0x3cfd3c6f,0x35b94392,0x0b171fd4,0x1c83ffd8,0x3447452c,0x23c02176,0x20552953,0x0f2c0e73,
0x100615a0,0xdd5aed17,0xd61addc5,0xe15adab4,0xc8cec7f6,0xd815d43e,0xf1cae245,0x0e580b79,
0xebf002a0,0xe83dd838,0x25060030,0x2491335b,0xf6681732,0xde93e0e0,0xde1fea9a,0xc9e6d0b3,
0xbef7c343,0xbbf1bbbe,0xd0f3c64a,0xd1e3d668,0xf61bcd98,0x216a1452,0x2d3131a3,0x1b882069,
0x1f5f1b20,0x3a772fbc,0x3dc13642,0x3f8d4276,0x18db4107,0x09adfe11,0x39262ada,0x252e28c1,
0x2c982b4e,0x0cb51804,0x1a481e8f,0xfac40169,0xd777e071,0xde40df35,0xca43d827,0xd0c3cd40,
0xe08dd08c,0x0b2af0ec,0xfffd0ecc,0xd865e88d,0x03d9e387,0x2b2b219c,0x12d12e21,0xe7baf508,
0xe67fe8b4,0xd371e005,0xc66acaf1,0xbca3be2a,0xcad8b725,0xc970d71e,0xd941c952,0x0a1cee0f,
0x2dee270a,0x26fa2918,0x17bb1898,0x2b6a281f,0x36df37b0,0x45863867,0x37c850e4,0x043711c9,
0x2c9d1526,0x237d3066,0x38f02c34,0x18051d7f,0x1c351dc7,0x0aa419c6,0xe1adf8e2,0xe378e06f,
0xd9f5db47,0xce77cdec,0xcda9ce51,0xf684dc55,0x0f420a41,0xe205ffd3,0xe651daef,0x1eae00f4,
0x260d3305,0xfabd1199,0xee36ea5d,0xe158e565,0xcbcdd2fa,0xb9e4cc69,0xc384b2af,0xc7e2cd72,
0xccd7c765,0xed2acd9f,0x19a60b96,0x293c302d,0x18a91ede,0x23351a88,0x30ba3092,0x3ab22cf2,
0x4c275482,0x0f27310e,0x263a07fe,0x20a323f9,0x325f3203,0x1faf2bb9,0x1dc61dd5,0x1e9d2099,
0xf8fd08b5,0xe4fbe8b3,0xdfabe259,0xd5e3d637,0xc783ce96,0xdb09cdcb,0x0dbbf774,0xf79c0e7e,
0xd82ce7dc,0x0470e3a5,0x31591eb2,0x120d21eb,0xef27fe2a,0xeafef22b,0xd98cda1f,0xc34cd859,
0xc142b429,0xc805c1a0,0xc151cb9f,0xd269c6b4,0x0285e656,0x27891ef7,0x1d8f2859,0x194514e3,
0x29ea2b7c,0x2d2b2366,0x5c5c3dbe,0x1d384929,0x193317ba,0x1bc518e1,0x31d927b9,0x2a9e2c7f,
0x1ba41dae,0x235a2319,0x0c111a68,0xeebef6a4,0xe10de73c,0xdc2cdf75,0xcb05d6fc,0xc460c835,
0xfb9bdf58,0x0d9e0926,0xe41ef88b,0xe49cd5cd,0x1e690707,0x264129ed,0xfe950cf4,0xf419fc2d,
0xe616df81,0xcd99e3de,0xbc48c3a1,0xc8b7bd95,0xc4ebc7dc,0xc4b2c3b0,0xe493ce89,0x17740309,
0x28622a8c,0x19ff1205,0x2980215b,0x17502757,0x51da2f1d,0x393957b7,0x22162702,0x1661164b,
0x28421efc,0x2fce31f4,0x1fff2362,0x25d2205b,0x1c5a266a,0xfdb00992,0xe46bf462,0xdcf5e6dd,
0xdbdde1c5,0xc175c693,0xdf82c854,0x0ab8f8c6,0xf7c20e37,0xd9c4ddb5,0x023de5fc,0x2f551fb5,
0x0f0316cf,0xf7710f03,0xed8fea49,0xe074e7e6,0xc06dd05f,0xc1f7bd23,0xc41fc773,0xbca7c6fb,
0xd0e4c1cd,0xfd3fdab5,0x21a31f48,0x11aa2142,0x2adf1818,0x126127a7,0x3cb51814,0x49ae5057,
0x2b1e3ae5,0x1994219e,0x1ee71111,0x30172d52,0x24302aea,0x22d11f9e,0x24aa2ce2,0x0c321daa,
0xf8c0010a,0xe104e74e,0xe59de88b,0xc59dd833,0xca8dc0de,0xfa98da9b,0x094e0fa0,0xe4daf268,
0xdfb7d5ca,0x1ff60f36,0x1e391b76,0x08a11a35,0xeed4f8fa,0xec64f051,0xcd0fe2dc,0xc0b6c447,
0xcd33bf98,0xbe27c2dd,0xbe46c4f5,0xdcb1c6ca,0x1b8bfc7b,0x135222b4,0x284c102b,0x151e2ce3,
0x229f0f7f,0x4e453c04,0x39fb451b,0x25963129,0x13b612b4,0x2a4423d7,0x27c53262,0x232e2187,
0x2e182568,0x1862287d,0x07ab13e5,0xe4bef892,0xf048e7e8,0xd63ee53b,0xc1b8c8fb,0xde71c247,
0x066a0178,0xfb6a097b,0xd3ffd7bd,0x0ac8ef3c,0x1d19158c,0x1acf20d7,0xf9160a0d,0xf9c2f1be,
0xe24eeae8,0xbf11d478,0xc7a7c499,0xc3d3c5b5,0xbfc0c1af,0xc159bd02,0x01c0d681,0x10c91ba3,
0x21180bec,0x22012a14,0x0ff810cc,0x3f8b24b6,0x4281460f,0x3286412a,0x146922a9,0x2640140d,
0x2b2a2cf7,0x1dc72a9c,0x2b692296,0x231f2e48,0x1b6a1c59,0xf45f0821,0xf344e86e,0xe3bded1c,
0xc67be0bd,0xcb6cb672,0xf67fdf87,0x0ca10f63,0xd623ee3d,0xefc3dc93,0x13d30420,0x29391806,
0x02e01833,0xf5fe01c4,0xf44cf6b1,0xcf48e209,0xc62dc67c,0xc71bc7a7,0xc309c2ed,0xb293c2c5,
0xe355b76f,0x08820357,0x13630827,0x2a16233d,0x08841b11,0x2894149f,0x449c3712,0x44354235,
0x1c5a3423,0x172f1856,0x2d64244c,0x237f2d40,0x29921b84,0x28f22cef,0x276a2345,0x00961c5b,
0xf38cfac8,0xf1b4ea33,0xd5b7f26f,0xc00dc3df,0xd9ddc5ab,0x1303feb5,0xed070263,0xe2a0d760,
0xf913f142,0x1fd71483,0x174f2071,0xfbc70aa4,0xfcacfbd3,0xe293f24e,0xc793d1f6,0xc854ca1d,
0xcbc0c152,0xb46dcb1e,0xc46baa0a,0xf8e3e615,0x049400d6,0x2c881697,0x13f821e0,0x17630b9a,
0x30c52818,0x47bb4372,0x2f1f42b7,0x17c021a9,0x28581641,0x27522f2d,0x227e1d7d,0x255a2da2,
0x3210268e,0x13d02567,0xf91b0f5a,0xf31def00,0xea55fadc,0xcc16d7d4,0xc3b0b72e,0x0113df2f,
0xfadd1302,0xe47be82d,0xe931e0de,0x10f1ff71,0x21ab1e09,0x087116b7,0xff580187,0xf6fefccc,
0xd2c5dedc,0xc629d18a,0xcbecbea8,0xbd20d41a,0xae0facb3,0xe779c4e3,0xf56eec0a,0x1a9c06af,
0x1aa12ab5,0x0fb20e70,0x1eb417e6,0x457e30a8,0x3f1544fd,0x20e63172,0x1a7b1440,0x2aff2dc1,
0x24351c77,0x1e4c2a1d,0x2fde289e,0x22d72ce3,0x0b201e99,0xfa70f4fe,0xf917f3cd,0xda18effc,
0xb697c7cb,0xe6b2bcaa,0x0367068c,0xed9bf9bd,0xdde6e213,0xfb24e9bc,0x1db81123,0x19651b05,
0xffc3088c,0x019d0737,0xe16dede3,0xcae6e196,0xca7bbd2a,0xd179d2dc,0xa7c5b594,0xc9e6b30f,
0xe270df90,0x0836ee8d,0x219f202c,0x12cc14a7,0x105710f4,0x336a1cff,0x44774191,0x362b3fb8,
0x16bc1725,0x23982b16,0x262522f1,0x1e46268e,0x2d9f224f,0x30ad28fe,0x1a9228ca,0xfbb00c5d,
0xfd28f79f,0xf303f7ab,0xbeb3e43c,0xc705b1a7,0xfdabeae4,0xfaac01f2,0xe34cee24,0xe943da1e,
0x0bb3fdf6,0x1fcd1b83,0x01da137f,0x0a700e5f,0xf5faf54d,0xdc7cee47,0xc0b7c52a,0xd890d322,
0xb1adca0a,0xb74ea803,0xd650ccce,0xf0a5d62b,0x19bd0cf5,0x18b51a24,0x0ce8128d,0x21270c43,
0x3a9c2eef,0x3eb24dd8,0x1c1b2967,0x20c7251f,0x2c1a1f92,0x20d7232d,0x216422ad,0x3065286c,
0x2c012e7d,0x08c71c11,0xfa2302ce,0xffdff940,0xda7cfd8b,0xb715bb83,0xeab5ca17,0xfe70f9d1,
0xee57fea3,0xde6adeaf,0xf3d1ec33,0x23530ed4,0x0fd3123e,0x0dd010aa,0xfa5a026e,0xf1a3fde5,
0xc2ffd5b9,0xd91ec913,0xc5aed8c1,0xabcdace6,0xc84fc03c,0xd7eac7fc,0x09cef151,0x1ad31331,
0x094f1c1a,0x11f20d19,0x29c81842,0x48e84709,0x2e4933f1,0x1dbf2530,0x25b72393,0x28602386,
0x1ec11fb5,0x266724a4,0x34623145,0x1b1829d5,0x010611cb,0x02c3f723,0xfca50724,0xb99cd7d7,
0xcefabc1c,0xf60de4ca,0xfa8c04ef,0xe856e8d7,0xe117dd2d,0x12affd6f,0x0fa216ab,0x154b16c1,
0x0023097d,0x04980433,0xd29eede2,0xcfc2c6ad,0xd840dfcc,0xb060bbb3,0xc261b3cc,0xc1e7bf12,
0xebdcdd00,0x1700028e,0x11ae1ba5,0x10cf0f29,0x147e0686,0x40f7356c,0x39d94129,0x2876289d,
0x2055206e,0x274f25d6,0x204d2269,0x1de42061,0x35552a8b,0x2c1530f4,0x10e82098,0xfa86009e,
0x0f960aa3,0xd1d3fa5c,0xc3d1c263,0xe6c8c6fb,0xfa9ffe86,0xf42bfa1d,0xd675e3aa,0x02f9e8c8,
0x0df30d10,0x1cf31593,0x05081161,0x0d340840,0xee9d0412,0xcc07cf75,0xe307da68,0xb7a1d1b9,
0xba80b94f,0xbbf6b91b,0xd405c72d,0x06f7e6ee,0x11bd1373,0x13111947,0x09420400,0x32ad1770,
0x3ded426d,0x30df369d,0x1f8f2661,0x24e026ad,0x268825df,0x1ba61f30,0x2b1421ca,0x320433f3,
0x234c2ed6,0xfb8d107e,0x19fb00ee,0xf2690b5e,0xc21adeb7,0xcefdbcb7,0xf286e91b,0x009cfb49,
0xda05f131,0xef72d9e0,0x0190ff09,0x1c960e89,0x0ee8152b,0x0d9f0400,0x036a1310,0xcd40e99e,
0xe3d5d4b2,0xc933dc96,0xbbcdc100,0xb7d6b54e,0xb995be58,0xecead0de,0x0c98f951,0x143017cc,
0x03120de8,0x199c02d8,0x392a31d3,0x38ad3c2f,0x27b32bd1,0x214f21d2,0x259c27c2,0x1c7c240c,
0x20141b2f,0x32132a97,0x378c3034,0x03d6227e,0x0f390308,0x0b8d1370,0xd9bdfc26,0xc2e2c239,
0xe052d1e2,0x0209f111,0xe8cf006d,0xe4acd924,0xf7d4ece8,0x128e0050,0x107b1d73,0x06ce0b78,
0x178d1508,0xe0b5017b,0xe08fd6ab,0xd672e0fb,0xc1dcd13b,0xbf2bb938,0xb3b5b5c5,0xcfe0c07a,
0xfab5e2ab,0x16660b27,0x09041749,0x0953fdbd,0x2ddb1981,0x3a4a39da,0x2da33905,0x22ad280a,
0x29122509,0x276a243d,0x1c4517fc,0x2386255e,0x3fcd2fd1,0x17f63563,0x09830bb9,0x163a1070,
0xf78714ce,0xc8f4da3c,0xcf22c75a,0xf9ebd9c6,0xf7e90420,0xe0bae69f,0xe886e83a,0x0463f287,
0x1a3d152a,0x05e90eaf,0x1edf0edb,0xf71f1771,0xe336e590,0xe2b3ddc7,0xcaaedb34,0xc172c6fc,
0xb55fb854,0xbc38b5fe,0xe239cc99,0x0e47f096,0x0fc718a1,0xfe630608,0x17f208e6,0x36492bf2,
0x37fa3b3a,0x2ba62979,0x22ec2202,0x26792c8d,0x1e301c75,0x167f20d1,0x3a242423,0x2d0e3f4e,
0x0b3a1b61,0x146e0a44,0x154b1b4d,0xe155f0c3,0xc323cf55,0xdfaec895,0xfdbcfcdc,0xe9fef0d4,
0xe3b4e64b,0xf074e481,0x15e0064f,0x0425169b,0x1ecb05aa,0x0e3c1d23,0xe83efca9,0xe7e5e2f2,
0xd5c3e054,0xc8d8d2b9,0xbc41bf3c,0xb3c4b167,0xc52fbef8,0xf0abda9f,0x13960ebf,0x02e40c15,
0x09d9fde2,0x29021288,0x36943772,0x31163393,0x23132231,0x261e2c90,0x232a20ce,0x135022aa,
0x29fd16de,0x3e3d3a9c,0x1b8b2c55,0x0ee40897,0x1d5b1c63,0xf8bd0e50,0xcf2ae71f,0xca20bd71,
0xf7f2e7d7,0xf056f72f,0xe63dee42,0xe016e092,0x0e6deeb1,0x04671511,0x0f0e0665,0x1de11bb9,
0xf5831025,0xed30edcf,0xe056e306,0xd1a7d921,0xc06bccee,0xb18fb933,0xb849b668,0xd665c05b,
0x0e89ef4e,0x065e0da6,0x00790381,0x164400d8,0x302126d3,0x34303934,0x23ca28a3,0x235b2da4,
0x2732246b,0x1dd4246c,0x19810e91,0x3bd92a6c,0x2bc53e56,0x0d08157a,0x1fcd15b1,0x0f1b1a7d,
0xe83e0393,0xbe33cc96,0xe980d291,0xf57cf20b,0xf2b0f263,0xd665e9ca,0xfcb6dfb7,0x0acb0bd8,
0x04b807be,0x27211031,0x099d1a37,0xf2a3fed6,0xe67aef26,0xda35e176,0xcdc1d7b4,0xbac7c1c9,
0xb640b4b5,0xba5ab634,0xf808d33d,0x0aa90388,0xff760a85,0x053afd9d,0x209d133c,0x34ed374c,
0x2b7d2e6e,0x294f2a59,0x28322299,0x252e2abe,0x10441826,0x2d4b176d,0x3d553f39,0x13ef2772,
0x1a311465,0x1a8c1dc5,0x0a21165a,0xcc0fe3b5,0xd49fc570,0xebccea27,0xfc4bf024,0xdc4ff569,
0xe858d7dd,0x0d2df823,0xfd0e06aa,0x17960930,0x15ca234b,0xff1e0c75,0xf0e4f70d,0xe215e5bd,
0xd7e1dd8f,0xc24fcfc6,0xbdb5b96c,0xad72b123,0xd4e8bc56,0x0121efa4,0x00ba0d11,0xfedf0191,
0x1096fec0,0x318e253e,0x2dac2f66,0x29952ded,0x26bb232f,0x2d1f27e6,0x143c2277,0x165c0cf6,
0x402b312e,0x235a37c8,0x19c616af,0x1af2176e,0x1a8d2151,0xe4ea0859,0xcc2fc952,0xdecedbbd,
0xfd0ae464,0xed23fb0a,0xd658de2e,0xfe45e978,0xfc010714,0x0a6afef5,0x1fd21a4f,0x0b9f1565,
0xf8ff0408,0xea98f013,0xe1cadfe9,0xcbe4db30,0xc3dcc3eb,0xab5cb890,0xb721b11a,0xef30d12f,
0x04a1fe1c,0x00120553,0xff0df8b4,0x238d123f,0x2f922afb,0x2e302e6f,0x22fe2792,0x2b95277c,
0x21d42e42,0x0c5d0f64,0x34c819ca,0x31be3e89,0x1c22266f,0x18b51820,0x25a11d6c,0x0809236a,
0xd944dbf8,0xd012d5a8,0xeb76de54,0xfb76fd06,0xd87becc1,0xf05bdae0,0xff85fea5,0xfe94faab,
0x1c070f8e,0x1b091974,0x05c30cc7,0xf2b8fe1e,0xe7fae890,0xd5ede5c3,0xcbabd10a,0xb841c2d8,
0xa935ae2a,0xd058ba9a,0xfb3be92b,0x050d04a6,0xf99df939,0x103a00cb,0x287f20b2,0x2f1a2e74,
0x26382d72,0x2a17217b,0x2d323121,0x0b092023,0x20c10d6f,0x3a6932f8,0x26b0324c,0x1b8c1e07,
0x25a81042,0x1ce532ea,0xeb4200ae,0xd130ded8,0xdc94d222,0xffd5eeb0,0xe59efa9f,0xe060d9b0,
0xfdd0f3f6,0xfb9df655,0x0ef1018d,0x1e5c1900,0x0f10166d,0xfb820d37,0xf13ef3a0,0xe1bdea68,
0xd2a6dbff,0xc6b5d093,0xaa69b7d3,0xba5eac70,0xe603caa8,0x01a7fcf1,0xf8b7007c,0x00e1f92f,
0x1e5b0e9e,0x2dbf2563,0x29723207,0x213724cc,0x35e92e43,0x19d02c37,0x13730b2d,0x36861d08,
0x2ee53542,0x1d272fe1,0x1a7f0ecb,0x2cea30d4,0x05541b36,0xdfaaf2f4,0xce66d390,0xf595de04,
0xf8cdfd3b,0xdb61e067,0xf500e833,0xf7bef572,0xff59f98b,0x18b31190,0x1925186e,0x05301553,
0xf71d0052,0xeaedf17e,0xd9e9e29d,0xd5dbd64d,0xb450c4ff,0xabb3adb7,0xc96ab369,0xf9efe48b,
0xfcecfd07,0xf5c4f7e9,0x0b5201a1,0x22d619db,0x2f2f2f18,0x1de5278c,0x37ca232b,0x2ad33034,
0x07c419aa,0x23c114b4,0x32332bb4,0x2a553a89,0x11961427,0x2e08246c,0x18e52cd0,0xfa0a09fe,
0xd1a6dd92,0xe032cdd4,0xfe6af6fc,0xde7dee6e,0xe913e1bf,0xf5dff170,0xf87af16c,0x0b8f03cc,
0x1bd815cc,0x12d8191e,0x009408e4,0xf694f92d,0xdea5eba8,0xde22deaa,0xc5e7d3b6,0xafaab702,
0xb0c8a771,0xdf01cbcd,0xf9aef840,0xf42afadf,0x001df81d,0x15b50860,0x33fa2115,0x1f2429cf,
0x275d210d,0x376732b0,0x0f0126e8,0x1623124f,0x27bf1beb,0x379e3c39,0x13262400,0x299b167f,
0x297a2cff,0x11ed1d9d,0xe393f958,0xced6cdba,0xfb09e6f0,0xec69f605,0xe202e163,0xefe5edc9,
0xf360ef76,0xff2ef8eb,0x15650b48,0x19a01970,0x06381542,0x0243015f,0xe881f47b,0xe489e240,
0xd3a1dddd,0xb7edcb1f,0xa53ead7c,0xc4dbb3b8,0xf493e04e,0xf871f597,0xfb28f145,0xfffdff0f,
0x293f14d1,0x27792a9d,0x1c1e2020,0x39dc2be1,0x1c4933c7,0x13f219b5,0x1a7c0fcd,0x3ea92ba0,
0x1db43375,0x1deb14ee,0x2c08274b,0x20be2a8e,0x012915c2,0xcc9ede5f,0xe952d7cf,0xf52af960,
0xe3cfe752,0xec0ee8ff,0xf07bed27,0xf5d5f311,0x0a3b01a3,0x1f3f103a,0x119b1945,0x09d107d1,
0xf0db0482,0xe6e3ec06,0xde66e533,0xcb39db44,0xad72b979,0xb2f4a49a,0xdf4dc224,0xf1ebf281,
0xfb0fef5b,0xf46ef7be,0x1581036a,0x2a93250f,0x14ee25a2,0x318d22bf,0x2d143754,0x1aed2210,
0x0c01125a,0x346e19b2,0x2b623b60,0x19801d51,0x29141d8d,0x28102a8f,0x1b19291c,0xdf7bfdff,
0xda76cf09,0xf64eefc1,0xe85fedb9,0xe745e8ee,0xef6bebd6,0xf37ceb75,0xff45f6c2,0x1658042d,
0x14511ed7,0x0dcd1038,0xff2a0e52,0xee99f4d3,0xe62ce66e,0xdd61e20c,0xb8c2cd3b,0xa7fdad9d,
0xc7aaa758,0xe60ddffb,0xf445ee24,0xeeeaf881,0xfe17f6ec,0x27bb1476,0x1a0b25ab,0x24491798,
0x32df325c,0x269d2a70,0x0a0e1c1c,0x21f80911,0x3497332a,0x1b6e2964,0x20a01b36,0x28c123cb,
0x2b042cd2,0xfd2e1f2d,0xd138dc23,0xeee9e3ee,0xf0c5ecb4,0xe78ee6d8,0xecc3e95c,0xecb1e91b,
0xf2cdf499,0x0644f8df,0x15131a4e,0x139212c8,0x0be91066,0xf716009b,0xe7a2eea3,0xea82e542,
0xcf11d9fb,0xab95bf4b,0xafc49f51,0xd37cc9bf,0xeda2e5ba,0xf546f332,0xef2bef3e,0x18c30036,
0x1f51249f,0x19d615f7,0x2ec3293a,0x32a02db0,0x14092a02,0x0ebe0898,0x33f8238b,0x25312ffd,
0x1d4220c1,0x226e1fd3,0x2d782a47,0x21323580,0xe17ff637,0xe60fdae2,0xf08cebc5,0xe72bed5e,
0xeae3ec55,0xe9efe9d9,0xeffcf304,0xfb3fee98,0x12820c39,0x14e214bd,0x15b114e3,0x08890755,
0xec9cf86e,0xec97ec5f,0xe01fe5cb,0xbb95d83f,0xa69da799,0xc2afb1c0,0xdfccd419,0xf562edcb,
0xe9c5f0c2,0x034bee91,0x20cc19e0,0x16ed1644,0x23e82009,0x34cd2a22,0x27093507,0x05721254,
0x25cb16bb,0x2b37301c,0x212c289d,0x21a91eb1,0x2a021cda,0x393a38f7,0xfb0c1a08,0xdeb6e70f,
0xecabe913,0xea37ef5f,0xecd6eccd,0xe9dee801,0xedbdf152,0xef89ec99,0x0dddfcf4,0x16230a1a,
0x15eb1762,0x11f81090,0xf5ca0688,0xeeaaf490,0xebcee844,0xd4eae960,0xa98dbc82,0xb329a9b4,
0xcd74bf4d,0xefb1e092,0xed7cf138,0xedeae55a,0x18230928,0x174d161f,0x1c66195a,0x29c21ff3,
0x359f3abc,0x0ab92380,0x19de0d38,0x2f322134,0x256329bd,0x22422496,0x1b85170a,0x3d6a3156,
0x1a4c352e,0xe7eafee7,0xe9f0e4b7,0xe96bed44,0xeccaefbe,0xea8be746,0xf221ec47,0xe8e9e902,
0x0000f3c1,0x0e4c0227,0x12af1716,0x17ac156b,0x03a70f66,0xf30cfef6,0xec1eebc3,0xebb8f12c,
0xba59d4b6,0xaf3aad50,0xbb3dada0,0xdfddcc0b,0xf13ced61,0xe2b1e308,0x06e9f4a4,0x1262117d,
0x18031874,0x19951819,0x40282faa,0x1e9d2eae,0x10360ecc,0x26fc16ba,0x252428f3,0x28882b1a,
0x12e21b0d,0x34e520a0,0x33523eb3,0xfb312028,0xe9a9f0f4,0xed7fe8bf,0xf10aebfb,0xe6d1ea42,
0xf328eca0,0xe67eead4,0xf3e3eee0,0x06abf849,0x0f920e04,0x183b1765,0x1073157e,0xffb20904,
0xec98f2d3,0xf8edf03c,0xd2a3ebe4,0xb4fdbf78,0xb0fcab31,0xcb20b5ca,0xecc9e379,0xde71e9a4,
0xf56be719,0x0c2b0500,0x1bae1222,0x0f281319,0x37a81eec,0x2fc438df,0x0e7d1dcb,0x1c7c125f,
0x21c62391,0x2df02ad7,0x1413272f,0x21a81677,0x40f937e4,0x1e0733ca,0xf4ba031a,0xeb29ec7f,
0xf2f5eb86,0xe5deeeb3,0xf3a1ebd0,0xe9a5ecc3,0xeb54ec8f,0xfbcdf289,0x08fe0464,0x16401296,
0x16ee1852,0x0dfa10ff,0xf096ffa4,0xfb00edaa,0xebc8f7e3,0xc336d5ce,0xad5eb878,0xb1bdad31,
0xe165d0c6,0xe360e98d,0xea37dc8d,0xfddaf5e2,0x19b109cd,0x0b101431,0x23fc1003,0x3bb6334a,
0x19852c3f,0x14b8129e,0x19541e82,0x2dca2421,0x22fa2d13,0x13ef1211,0x38a82605,0x349a3f13,
0x07fe1caa,0xebf4f918,0xf39bea27,0xe679f006,0xee98ebd7,0xed14ef61,0xe80feb6c,0xf18ded16,
0x008bfb2e,0x0fee07ea,0x17191771,0x19da1290,0xfa1a0d77,0xf320f220,0xf788fc9c,0xd5efec38,
0xb989c9a4,0xa920aaf6,0xd010b280,0xe378e13f,0xe3a6d8f6,0xed52e943,0x1095fba0,0x0e421379,
0x0fb5089e,0x34a223e6,0x25913b0f,0x17651a1d,0x1734175e,0x24581a3f,0x2d6f3027,0x11621c6d,
0x264c148d,0x3f0a3a6d,0x230b3008,0xf4af0d6b,0xf1b6effc,0xea03f1a6,0xe9d6ec31,0xef4eef42,
0xe9a9ecde,0xeb0ee8d1,0xfb70f24a,0x0a82f93d,0x12d710a4,0x19fe148e,0x08de1bc1,0xf349fc15,
0xfe98f8cf,0xec28f736,0xcc0edd36,0xab31bba8,0xb80ea290,0xdbb6d290,0xe134d7a1,0xe14ae0f1,
0xfdb9ec54,0x0e6f0fc5,0x04b90a4e,0x267c0e2f,0x31c6361b,0x1bf32546,0x17431a02,0x19b011e9,
0x305d28a1,0x1bd028ff,0x15410dbe,0x37c72b1f,0x37dd3a0e,0x09f724f5,0xf435fc19,0xefe3f434,
0xeb06ed08,0xf0e3ec50,0xeff0ed90,0xe8b9e6f9,0xf220ee3d,0xfcbbf4a7,0x0a670b42,0x15dc124f,
0x19851f37,0xf9f50850,0xfcddf98e,0xf9f7fbc6,0xe079ee28,0xbd49d2a0,0xaa48a205,0xccccbce7,
0xd983d5d7,0xdb51e19b,0xecaede17,0x0d5cffe4,0x03250cfc,0x114e02c0,0x33d226f7,0x24892d7a,
0x1dd42094,0x12fc0f12,0x293f1bc3,0x27ea304c,0x0f3f14c3,0x26021a04,0x3d3036d9,0x21cd38e8,
0xfd8f0eff,0xf734f887,0xef19ec53,0xec6ceb71,0xf07df14b,0xe72deb88,0xec59ed1b,0xf501ef2d,
0x04e10046,0x0c6b0ac8,0x21e41d14,0x077414e6,0xfcd9fe55,0x00bdfbf4,0xf1aff66b,0xd3b1ea83,
0xa6e0b73a,0xbc38af77,0xd4aac787,0xdbefdc74,0xdb9dd867,0x02a8ecba,0x07230b27,0x0140ffdc,
0x295d1319,0x2abd2bce,0x246c28f3,0x114b1779,0x1bc110f2,0x2c402f75,0x157a234e,0x15db123e,
0x37b72785,0x3a3f3dbd,0x11cf210c,0xfd29037b,0xf104f4ac,0xe961eef3,0xf138f14e,0xea96ee64,
0xea43ec8e,0xecd7ebeb,0xffd1f80f,0x03e70080,0x22571187,0x17821a30,0xfe6a0771,0xff0f0161,
0xf8d8faef,0xede1fab0,0xb727d045,0xaeb9ae9c,0xc590b9cb,0xdb53d522,0xd25ed86d,0xf065daa4,
0x0a8700b3,0xfa5a0114,0x17d603ff,0x2a0020c3,0x29582ba8,0x157a26ad,0x10840db9,0x2b4823b5,
0x245c2967,0x11ab13e2,0x26d11524,0x40c2382b,0x25c934de,0x077a14ad,0xf86dfeaf,0xeb68f193,
0xef3bf10d,0xedaff103,0xed8cecc5,0xe75fea42,0xfd81ef52,0xfbeaf7fb,0x135406af,0x1d9c1f6e,
0x072b1321,0x035b051a,0xf8effc55,0xff140148,0xd05dec76,0xb052bcfd,0xb51db04e,0xd7d8c633,
0xd319d6c9,0xdab0cf9a,0x049eef61,0xf96802f5,0x04f9fc84,0x1d911442,0x2a1d2663,0x22b82fc4,
0x0fef0fa8,0x23121297,0x2a7e2898,0x15911fd2,0x13dd0d48,0x38b12730,0x35e63c0a,0x14212704,
0xfefc0e8a,0xefd2f942,0xefe0f00f,0xf00cf012,0xf295eaf5,0xe393ebdf,0xf4a6eaa9,0xf5d9f6f0,
0x0593f925,0x1e8915a6,0x0ebc1c1b,0x08280d06,0xf8d30194,0x0577fe65,0xeb550167,0xc2fad260,
0xac9eb24d,0xcb1fb5ad,0xd630d1f8,0xca14ce6c,0xf2c4dd20,0xfc180054,0xfa9df871,0x111c07ac,
0x25471725,0x2cd5301b,0x12eb1eb0,0x17110d4c,0x2994216a,0x20df2933,0x0b811300,0x25c616f7,
0x3bc13913,0x265035c6,0x0f1e1ca0,0xfbf201d1,0xf335ef81,0xecc2f3f6,0xf406ee8e,0xe7abf033,
0xee83e5d6,0xf53af4c1,0xf70cf2c8,0x1711075f,0x16371d90,0x106f13f6,0xff4e08bf,0x0437f8b5,
0x00180a26,0xdbe6ebb9,0xb1fdc3b2,0xb707af78,0xd3a3cc34,0xc5fad35b,0xde02cdd6,0xfde7f3c1,
0xf620f671,0x05f5ffd8,0x17470980,0x313b2647,0x201829b7,0x109a0fb4,0x1f91173a,0x26ee2c96,
0x11081f02,0x13e30c47,0x38032856,0x36ba37fe,0x1db228c0,0x04b81403,0xf8eaf659,0xf018f455,
0xf387ed32,0xed1df465,0xe7e2e72e,0xf4d3f0f0,0xed29f355,0x08baf99d,0x192a1613,0x17371686,
0x082e12f3,0xff45fa13,0x0790085a,0xf15b0185,0xc568ddcf,0xabe5b3bb,0xccedbca9,0xcc86d14d,
0xcaa7c4ae,0xf50fe0f2,0xf3fbf3b2,0xfff9f8ce,0x07daff25,0x28471549,0x282b2f3b,0x10c91f39,
0x16ef0f6b,0x29b1239b,0x20742674,0x0aae0d69,0x26bf180b,0x39fc3573,0x2d1b3291,0x147d231c,
0xfe2d02f2,0xf2dbfade,0xef77ef9f,0xf206f722,0xe58bec87,0xf374eb52,0xede6f31f,0xfac1ed7f,
0x15c807ca,0x19ac129d,0x109c1c3e,0xfdf104aa,0x071e0356,0x023d0ab2,0xe256f653,0xb17ec634,
0xbdd1b2ae,0xd23fcd3a,0xc1f3c4c5,0xe5e1cd52,0xf022ec28,0xf9ecf509,0xfab5fc81,0x16290605,
0x2b7526d6,0x1be22ae6,0x10e80f27,0x1f011987,0x28a72c90,0x0f731932,0x17000ae8,0x3407276c,
0x365c3432,0x24733037,0x071c13e1,0xf96d040f,0xef4df3a5,0xf872f430,0xe94df087,0xf00de7bc,
0xf221f1bc,0xee0bea03,0x07fafc4a,0x14b00cb4,0x19401e78,0x03801027,0x04bb0094,0x080208c0,
0xfb370827,0xc729e1f8,0xb369b449,0xd20fc13d,0xbe56c9c5,0xd0d9c434,0xe603e221,0xf5ecef7f,
0xf64bf91d,0x0594f997,0x241e12ff,0x242a2fcb,0x13201af7,0x18e40d55,0x2c9522c4,0x1aef24aa,
0x0bfa0b72,0x254218fd,0x34312ed3,0x2fe4398a,0x155124a7,0x056e0d20,0xf30cfa26,0xfbadf155,
0xef08f53e,0xeafce9c5,0xf3bef1dd,0xe9deec8b,0xfacdf2e2,0x0b4f0339,0x1d591877,0x0b001c9b,
0x06130631,0x075b0357,0x0d320cf0,0xe679fc13,0xb445c7c7,0xc9e5b8d9,0xc328ce3b,0xc757be88,
0xdacad270,0xf187e4a7,0xf2c5f657,0xf7e6f844,0x153c005d,0x2a5a253f,0x1d5c25e1,0x117d0e16,
0x25c517b6,0x244a2c9e,0x0b1a178b,0x17171021,0x2c732226,0x37fa373e,0x24623121,0x13c317e8,
0xf8dd04a0,0xf8bff37c,0xf487f9c7,0xe91bed16,0xf2c3f081,0xeb7def3e,0xf0f4ed3c,0xfe44fac3,
0x1c2009df,0x17241d91,0x0cd70bb4,0x01f302ee,0x0f3a0a24,0x01b30ec5,0xc5b2e694,0xc219b76d,
0xc80acbf4,0xc152bf27,0xc93bcb89,0xe824d8d9,0xf2e0ece1,0xf32ff54a,0x0256f32d,0x233911d3,
0x25ce28dc,0x0dd91a52,0x17870f96,0x28ce2a28,0x1490227f,0x0eed0efc,0x205e144c,0x38152b06,
0x2f3437d9,0x217d23f3,0x04b71281,0xf757f8f0,0xf9edfc39,0xea95f162,0xf076ef8a,0xee19f1ed,
0xeeb9ea15,0xf46bf27b,0x1004f9e3,0x18b51a10,0x114e161c,0x027d0982,0x09740301,0x141e108b,
0xe2b40428,0xbdd3c57f,0xc599cbb0,0xc314c25a,0xc1b9c3d1,0xd94fcb33,0xee05e130,0xf19ff202,
0xf28befa6,0x10fbff79,0x272320d0,0x16da2657,0x0ce00d3d,0x28471d81,0x21c1259f,0x0fc214c7,
0x13200da5,0x2ddf1b87,0x33d6369f,0x2a202df3,0x131f2344,0xf84b0476,0xfc90ff4a,0xf143f69b,
0xf087ec2a,0xf07df29f,0xee1be9eb,0xec48f1bb,0xff7eef80,0x16300e3f,0x18b61846,0x092f10de,
0x006304c3,0x14890b62,0x02b71b60,0xcc62dda2,0xc707cb36,0xc823c3db,0xc250c03a,0xcaabc1de,
0xe201d4d5,0xefd9ece2,0xebd1f01d,0xfda0f1fc,0x1d2d0f95,0x23c429d7,0x0afd13d7,0x1eb611bd,
0x28342511,0x17741e3d,0x0c1510d5,0x1dce1015,0x33062dd6,0x2dc932de,0x24d23173,0x04ee1199,
0x00780053,0xf8effcff,0xee5eef41,0xf225f5cb,0xef11eb3d,0xedfef248,0xf3fae7e9,0x0b63fe36,
0x187f1555,0x107619df,0x04240b05,0x0bfffdc7,0x1ac020dc,0xe51bfa7d,0xcc1cd4a7,0xc90fc80b,
0xc2cec559,0xc16fc12b,0xd20bca12,0xeb86e289,0xeb5bf039,0xf196eb78,0x0b51fb46,0x293d20dd,
0x13941e41,0x13da0be0,0x264c1e67,0x1f222539,0x0d7a1a93,0x0e560bd1,0x2d401f7f,0x2f792ded,
0x32d93557,0x13e421b5,0x01b50827,0x010a028c,0xf0b7f2ac,0xf5ccf40d,0xee81ebf8,0xef8ff369,
0xe937eacf,0xfbe6f481,0x14aa08e2,0x151f19fc,0x0e54156b,0xffd3f8a4,0x217b1671,0xfe8713d3,
0xd82ce85b,0xca89ce12,0xc4b7ca2d,0xbf40c2eb,0xc43ac33c,0xe1e3d1a3,0xeaa8eb60,0xecceea16,
0xf78aeb73,0x20cb0cad,0x1db32368,0x0c231012,0x1c41156b,0x23b02551,0x1a17204d,0x06ff0c0c,
0x20da11b5,0x298b257d,0x358e3480,0x24df30e6,0x08c31374,0x080806a1,0xf2a3fa79,0xf445f732,
0xed26f114,0xf2fdf2a7,0xe8a1ed26,0xef84edb0,0x0c29fa35,0x156a0fe6,0x19181ce0,0xfa1601fd,
0x19210672,0x13391fdb,0xec0a012b,0xd07cdb78,0xca1eced8,0xc2d4c4fa,0xbec0c21a,0xd57bc0e4,
0xe70adf85,0xeca4e9c4,0xe874e6f6,0x0c66f7ab,0x209a1f53,0x0fae1aad,0x143b0d3f,0x200d1e98,
0x23df25ae,0x070e179a,0x15520ba9,0x227719df,0x33d52b29,0x3544356b,0x1221230c,0x0c04102d,
0xf94004ed,0xf78af98d,0xee17f3fa,0xf4dbf283,0xeef8eeaa,0xe816eb49,0xffaeeff2,0x0e1d023b,
0x20a31adb,0xff4c11ee,0x0a99fce6,0x1d601b74,0x041e153e,0xdd99ef3f,0xd147d785,0xc8d7c8c5,
0xbf7dc634,0xc6f2ba7d,0xdbecd332,0xeb6ae767,0xe332ea7d,0xf8d8e6a4,0x1bcf0cd7,0x176d2083,
0x0f260f50,0x17a117a0,0x2c05226d,0x130920b2,0x10210af8,0x186c10c8,0x286221c8,0x3aaf3436,
0x20473217,0x14251939,0x01980e83,0x0013fd8a,0xf244f543,0xf47ef429,0xf542f14a,0xe77bee75,
0xf4b2ebae,0xfedff8a8,0x1f41110d,0x0c272065,0x006aff25,0x19440e23,0x18ac1e31,0xf0c2034b,
0xda6fe498,0xce83ce0e,0xc34fcc4a,0xbdf5bc5c,0xcf79c520,0xe7d1da05,0xe3b4ec82,0xe637e10c,
0x0ab7f72e,0x1a411cde,0x138e1362,0x11480f48,0x2aa1174e,0x1d11277d,0x0df914ae,0x11240d72,
0x1b53170a,0x360429f5,0x2c8e3a45,0x1ee02211,0x085e176d,0x04a3050f,0xf69bf984,0xf1d6f526,
0xf647f33c,0xe9aef294,0xee50e9cc,0xf114f20f,0x132afe12,0x19e622a3,0x025207e8,0x0c490202,
0x21db19f6,0x046a14c1,0xe6cff827,0xd4a2d7ef,0xccb2d163,0xbeb7c010,0xc0c0bfb0,0xdb56cc2c,
0xe693e958,0xdf54e29f,0xf7fce1e1,0x15f90c7f,0x18881491,0x094c11f3,0x1d930f81,0x23a8270a,
0x116c1fe7,0x0e200fc8,0x112c0fac,0x2b3b19b5,0x331f3860,0x2ad32add,0x14b71eb7,0x08f80d59,
0xfd2b01d2,0xf189f8af,0xf6c6f4c7,0xeee1f69c,0xecb8eb0a,0xec72f0d2,0x00abec07,0x1f3f186f,
0x0bde13f1,0x004601e0,0x1e860ec1,0x16181c59,0xfaf709e3,0xdbd8e63b,0xd2f4dae6,0xc1b6ca7d,
0xba47c4ac,0xce0bbf1a,0xe70fdb49,0xe0f5e6c1,0xe53cd89d,0x0779faa9,0x1a330f64,0x0c181765,
0x108a0a99,0x259d1e5d,0x1c0124b0,0x10fa1465,0x0c5d0ffe,0x1e2b0aef,0x31622d3f,0x3127311f,
0x20182882,0x0d71182a,0x05040add,0xf508fee0,0xf72bf41b,0xf53af839,0xed30ec9f,0xedc2f292,
0xec3ae43d,0x150206ba,0x17961a92,0xffb107c0,0x11e602bd,0x1a5c1b70,0x0cfe1a22,0xe6eff9d9,
0xdc18e4de,0xccb7d166,0xc075c751,0xc164b80b,0xdc12c9cd,0xe4cce755,0xda39d80f,0xf400e900,
0x115d0322,0x13031858,0x08160b2e,0x1dbe1322,0x24e323f2,0x177e180f,0x0c4a1588,0x0fe60541,
0x27e01e5a,0x31543054,0x29d43067,0x15772309,0x0d3f120a,0xfd5b06ef,0xf545f63d,0xf961faea,
0xed04f058,0xf2cdf5d5,0xe54be504,0x04fcef36,0x1d251375,0x046d14a8,0x05fb01e4,0x16881248,
0x1db71f60,0xfa3f0ae7,0xe6fbefec,0xd68fdb5d,0xc887cf9d,0xbbe3be94,0xcaedbb53,0xe417e0e0,
0xd980dd38,0xe3ecdcd7,0x018cf276,0x1647119d,0x09fd0f10,0x1279080f,0x23d31f64,0x1cba1cff,
0x10ee1d76,0x06fb097b,0x1ba31020,0x2cc1278a,0x326c3118,0x213f2adc,0x143919b3,0x07f60ffa,
0xf584fd24,0xffa6fac1,0xeffbf18b,0xf789f525,0xe507ed2d,0xee03e53d,0x14bf03fe,0x0d961d2c,
0x053905cf,0x0ce505d9,0x22e71a39,0x0c1c18ee,0xf305ff3e,0xe067e642,0xd096d814,0xbf9bcbe2,
0xbbb9b5a0,0xdb99d1f0,0xdcb6e093,0xdc2cd931,0xf085e0aa,0x0fea0220,0x0f9a12d7,0x09990423,
0x1c851685,0x20541d21,0x1a5b20ef,0x0822117b,0x105105f9,0x22281af1,0x32352bff,0x28e43174,
0x1a9223ae,0x15bf1593,0xfae503e0,0x004bfb56,0xef9ef876,0xf7dff540,0xeb71f5db,0xe207e629,
0x058bed78,0x146717c4,0x09e40e0a,0x037f02da,0x1e0f0ef6,0x19941ec6,0x013b0fd1,0xeb95f4f0,
0xd95ee083,0xca77d96d,0xb711bbbe,0xd17dbef4,0xde9bd904,0xda76dba0,0xe09bd6fb,0x0008eecf,
0x11571035,0x05d30756,0x13a10dd6,0x1ea81866,0x212b209d,0x0e921ce6,0x08790724,0x15bb1061,
0x2d4c214f,0x326b2f84,0x2266297b,0x1e3d1d45,0x019111d6,0x00a600f3,0xf398ff2a,0xf862f3e6,
0xf561f8b9,0xe1a6ee74,0xf1a9dfd5,0x122206bb,0x12191271,0x009f06d2,0x11640520,0x1eff1b51,
0x0e5c1b79,0xf83a06c7,0xe39ee9aa,0xd987e1cd,0xbbb6c9c8,0xc3a7b794,0xd902cd34,0xdb45de24,
0xd805d7c3,0xed55dc80,0x0da003d7,0x080c09e6,0x0b6f0849,0x15f2139f,0x216c1dea,0x19af24f0,
0x0bfd0c9f,0x0d600789,0x20811551,0x32f629cd,0x26742fa2,0x24a724e3,0x0d6e1d6f,0x060905ed,
0xfa1c02ed,0xf66ff64b,0xfc44f7ad,0xeae2f85a,0xe437dea1,0x03c1f29b,0x155c1080,0x044e0faa,
0x03600473,0x1dd91235,0x1a051cc0,0x088115df,0xecd9f6d3,0xe69ae97f,0xc8bcda02,0xba30bddd,
0xcf00c0f4,0xdaa7d7c6,0xd809dc72,0xdb15d15b,0x007cf20c,0x081908e1,0x062107f3,0x10b60d9f,
0x20d6113c,0x22a4238d,0x1196173a,0x081b0943,0x119e0cfe,0x2c4e1ef5,0x2a233072,0x2a3d27af,
0x17ce27d4,0x0bc30f35,0x022706da,0xf6b6fb44,0xfc2df49c,0xf5c6ff43,0xe121e794,0xeee7e4a3,
0x0f34051a,0x0ef712b7,0xfe4305ef,0x13990895,0x1bdd185a,0x17ce1e5f,0xf6d70741,0xef8af131,
0xdb49e677,0xbda3cac8,0xc50db996,0xd317cb57,0xda5ddfa1,0xcf27d170,0xef15de4b,0x06cafdba,
0x063503dd,0x0a910947,0x156c0993,0x22f41f19,0x183c2163,0x0ad810ad,0x07dc08a5,0x203a10de,
0x29d92c8c,0x2cd027ca,0x246e2cf2,0x13781823,0x09a20c18,0xf9e503c3,0xf761f521,0xfd080193,
0xe94bf4e1,0xe3c1df7a,0x0044f23f,0x15210eea,0x016f0b57,0x0a3002fa,0x16731006,0x22a01d85,
0x060c165e,0xf680fb08,0xebdcefc6,0xc805dd9b,0xbd7dc22f,0xc799c2c5,0xdeafd9b9,0xd0e2d565,
0xdcebcf96,0xfd4cef5c,0x0466ffc2,0x071e081c,0x0af1066a,0x1ed11456,0x1e452438,0x121d19da,
0x05380cb4,0x138d04c4,0x268e217f,0x2bc4254e,0x2d482d2a,0x1a2b234c,0x0faa1393,0x02320d7c,
0xf7fbf757,0xffc9fb6f,0xf47e00dc,0xe2a9e61e,0xecf3e546,0x112d027c,0x074f115f,0x06be02be,
0x0c8e079d,0x22c41690,0x14981fef,0xfb1b0a6d,0xf66af890,0xd930ee60,0xc4b8ce21,0xbf48bb73,
0xd8cfccbe,0xd618da58,0xce98cc40,0xede3df07,0xff3cf6fe,0x062f0417,0x035a061c,0x14380a31,
0x21a41f84,0x1cf91c45,0x0adc1489,0x09120040,0x1d9e1452,0x25682298,0x2e842b4f,0x23582ddd,
0x17581847,0x09fb1629,0xfa440247,0xfc2ef668,0xfddd05d6,0xea13f22e,0xe09ce2b6,0x05c9ed9b,
0x0cf00e60,0x094204c1,0x014504d4,0x18580fa6,0x1fcc20ee,0x07181900,0x0021fdd2,0xeb8bf98b,
0xd2f4dfc1,0xbce8c1f2,0xcd95c0cc,0xdae6d8d7,0xcb4ed099,0xdd1ed196,0xf43beb72,0x0324fdec,
0x02370611,0x09b70148,0x1d4f1584,0x20ab1bdd,0x12701f6d,0x02e8070e,0x12f209b2,0x20411ab7,
0x2b652288,0x2ac4329d,0x1e2c1fda,0x12cc1b2b,0x02920f71,0xf9c8f678,0x043d01dc,0xf705fbde,
0xe01dea98,0xf3d2dde9,0x079b05b6,0x0afd0abc,0xff280715,0x0e2105da,0x2278161d,0x13ff228a,
0x059c074f,0xf8d600ae,0xe34ff00c,0xc40cd244,0xc073bbf2,0xd65fd19c,0xcdf0d7f1,0xd0bacba4,
0xe7e8dc00,0xfcb2f138,0x038e0355,0x0141fcf7,0x123b0bf8,0x1eda1741,0x1e6e2279,0x074a0ffb,
0x084903ef,0x17f3136f,0x238218f5,0x2bfb2fd7,0x234b293b,0x1a451dc8,0x0fd418e2,0xfaf0fc3a,
0x02a9fc11,0xff9000b8,0xe625fa80,0xe4a8db57,0xfd8cf5a9,0x0d02078e,0x02c209af,0x03ac032c,
0x1b1a0a21,0x1de02377,0x0cce13e6,0x02ce0650,0xf24efc09,0xd37ee838,0xbc53c3d5,0xd06cc642,
0xd543d6c8,0xcc0ecd33,0xdb5dd0f0,0xefabe374,0x020cff4f,0xfe39fcae,0x09bd03c7,0x180c0d91,
0x22052165,0x124e1d56,0x02fd0608,0x0fbc0f45,0x1b601093,0x2a1526eb,0x2b9d2d3c,0x200e203a,
0x1c691f6a,0xfe3a0b74,0xfe00ff97,0x04bbfeb1,0xf5060777,0xe14ae2cf,0xef96e81c,0x09b0fe32,
0x09d50976,0x008b0534,0x0f51ffe3,0x20231b86,0x13ba1ea1,0x08fe0f84,0xfe350386,0xe979f936,
0xc44fd3d2,0xc7c1c004,0xd656d104,0xcb8ad30c,0xd2ddcd83,0xe172d448,0xfd8df351,0xfbcbfb6e,
0x0238008b,0x0dfe040a,0x1bdc1989,0x1d992690,0x05ba0d35,0x0bb30ba1,0x13330882,0x235c1a5f,
0x2ec02a67,0x2011271c,0x25b3239c,0x09e417f0,0xff3c0687,0x025bf91b,0x033a0d71,0xe87ef0ed,
0xe522e2f7,0xff41f02e,0x0c6703da,0x020c0a14,0x00b6fea0,0x1afa0fe5,0x1b6d1ee4,0x1123175c,
0x052e07e5,0xfc200405,0xd49aea53,0xc17ac730,0xd4cbc8ea,0xcf6fd273,0xcfd2cf55,0xd208cc04,
0xf37ae4d5,0xf96cf6fa,0xfc8bfff9,0x0540ffbc,0x13490c23,0x26ee23a0,0x0fd514f6,0x0a8f0be6,
0x0a350746,0x177f112a,0x2d2d2239,0x21942aad,0x293824fd,0x15f12155,0x070c1287,0xfd94f7b0,
0x0bb10928,0xf59eff81,0xe2dbe7dd,0xeef6e6c6,0x0593fc18,0x08fe0bdb,0xfb5e0177,0x11a1031b,
0x1bf818a8,0x191b1e48,0x08520fe5,0x085109f7,0xedc3fc99,0xc632d6b7,0xcfffc4a9,0xcf7acf64,
0xd22ad219,0xc5f5cb27,0xe3b5d73c,0xf5a7ecdf,0xf954fbe6,0x0202fcbc,0x0773fe17,0x24001956,
0x16c31e9c,0x0d32122b,0x07f90828,0x0bb80a46,0x25f716ef,0x223829f3,0x2a21261a,0x200e24c6,
0x14401e12,0xfbf2ff81,0x09390214,0x00cf0bc1,0xea19f4c9,0xe534e402,0xfa8aeefe,0x0d130517,
0xfc6407bb,0x058ffd34,0x153e0fd2,0x215e1cb8,0x0ea3163a,0x0c5a0ce1,0x039f08d2,0xd5c0eda1,
0xccf8c953,0xc9b9cf37,0xd66ad410,0xc586cea2,0xd633ccd8,0xef7bde2b,0xf5a0f517,0xfff2fc70,
0xfb55fa4e,0x1aee0b13,0x1c0f1fbc,0x12181b2d,0x0a700cf6,0x039609f2,0x1ca20ab7,0x2188234d,
0x2b4124df,0x24e02465,0x1fd926da,0x019f10c0,0x04fdfd96,0x0a530bf8,0xf7490265,0xe4ddea8b,
0xebfde734,0x07e1fa80,0x02f20cf3,0x014afc06,0x0b600513,0x21541665,0x175d1bea,0x0cd51123,
0x102e0df3,0xea310657,0xd24fd862,0xc732cf06,0xd8becfdf,0xcbcad0fa,0xc944caa7,0xe276d241,
0xef43eb56,0xff24f771,0xf47ffa66,0x0c8cfd3d,0x1b5e17c5,0x18ce1fbf,0x11a01054,0x02fb0ccc,
0x119d00f0,0x1b7e19bd,0x27772322,0x248925b8,0x29a7278e,0x0eab2070,0x01b80192,0x09ec06ee,
0x02c10d34,0xecd5f6c7,0xe3eae703,0xfd0aeaca,0x06c909fc,0x027d003a,0x021dfcf0,0x17e40c85,
0x1bc61d8c,0x0e011965,0x14c10cb3,0x00781568,0xe2bdebb2,0xc98cd304,0xd404cd9b,0xd3c0d26e,
0xc67acd1d,0xd522c8ff,0xe4f3dfd7,0xfab0efe9,0xf37efc87,0xfe65f599,0x151c0946,0x1c601dac,
0x16e5146e,0x060514e2,0x073000b4,0x14c70e68,0x23301b58,0x233f24ec,0x2c0f2353,0x1bbb2cb7,
0x04820f9a,0x05c90328,0x0cac0d4b,0xf8bd01da,0xe4eaf099,0xf042df1a,0x0454fe0b,0x04a50457,
0xfa80feaf,0x0c450357,0x1ce91527,0x146a1efe,0x14b30a36,0x0edf1ac0,0xf5de01f0,0xd31de0a3,
0xcf6dce32,0xd58ed1d5,0xc88bd443,0xcb31c698,0xd8bed4dd,0xf351e39e,0xf67bf933,0xf5e6f387,
0x07fffa47,0x181c181e,0x1b1b1691,0x102318d6,0x0379052a,0x0c5c0631,0x1b09121f,0x1fab23dd,
0x278c1fac,0x28592f9e,0x107a1db2,0x02c70644,0x1096084f,0x053f07e0,0xee4efeb6,0xe4a3e0d2,
0xfa1cf1e7,0x06e20363,0xfb85034c,0x0386fd6b,0x164f0870,0x19af2290,0x13dc0d69,0x1688183d,
0x08711196,0xe35af575,0xcf1cd6fc,0xd4a5d094,0xd004d859,0xc9e4c7ca,0xcecacd2a,0xe6f8d67c,
0xf4aff2ad,0xf319f768,0xfcc4f024,0x12ea0ada,0x1bab133a,0x193a1bf7,0x05ac0fba,0x057a06d4,
0x12fa08cd,0x1dca1ebb,0x21081c8c,0x2dd52bb2,0x219d2827,0x05a60f1f,0x0b2507cf,0x0b3f0ae0,
0xfcc40bd3,0xe436ebb7,0xeec0e764,0x051afa15,0xff750591,0xfe37ff8e,0x0d67fab9,0x1c091c08,
0x13b513ed,0x16741548,0x14a6195d,0xf88b09f4,0xd845e760,0xd480d04d,0xd56fd906,0xcb75cdfb,
0xc83fcd2d,0xd9d8cbb0,0xf027e41a,0xf45af6a7,0xf2f6ec68,0x07a7fce1,0x127d0deb,0x1cfc1bba,
0x0ced16c2,0x03d50b89,0x08cd0124,0x1b30157a,0x1c6316ea,0x28d822ce,0x2c292df8,0x0e481d17,
0x089e0c13,0x0c1f072f,0x0ab4113e,0xeddffafe,0xe49ce714,0xfd8beee2,0x03e2ffb6,0xfd7e04da,
0x0052f4b5,0x16de10fb,0x14eb1875,0x145f1381,0x19f11801,0x0c331526,0xe75cfc98,0xd323d8a5,
0xd685da70,0xd221d1c9,0xc97fcd4b,0xcd85c6fc,0xe4bfd44a,0xf35cf215,0xed40ef6b,0xfd50f2ac,
0x07f804ef,0x1bc8161b,0x156f1a91,0x0c591151,0x00aeff53,0x13d90d1f,0x17971477,0x1f081b4c,
0x30a62b10,0x1ae5288e,0x0c4214ec,0x071306b4,0x12431098,0xff0e07aa,0xe3efeec1,0xf1cce806,
0x006af635,0x01240941,0xf77cf757,0x0ee402fa,0x16ca1585,0x12b1148d,0x17c416c0,0x17731a6f,
0xfda51177,0xdc42e67c,0xd8e9dae6,0xd736d47a,0xcd59d0e4,0xc62fcaf8,0xd5aac8cf,0xef44e651,
0xeb68f1b1,0xf4adee00,0xff6afa3f,0x16e108cc,0x178318b7,0x14ca1952,0xfed7065d,0x0b74058d,
0x14d410b4,0x164d151b,0x2c29224a,0x25ba2eff,0x17c41f4a,0x073e094e,0x101c0bbf,0x0da41158,
0xec97fd8b,0xe988ea2d,0xf812ebcb,0x076d0465,0xf744fd42,0x01f7f95d,0x12c3106c,0x134d1606,
0x170c144c,0x1b711691,0x12b01dc9,0xec4cfae7,0xdba1e144,0xd979d975,0xd2ead483,0xc803d12d,
0xc7d9c566,0xe753d639,0xecb3ed69,0xf054eb43,0xf58ff377,0x0c4dfe0d,0x150a11da,0x1c001c1f,
0x05ee112c,0x03790351,0x11540c72,0x10ed11e6,0x24cc16f9,0x2c072a49,0x21e02963,0x0d111404,
0x0928091d,0x16e912cf,0xfd2409a5,0xeb00f2e9,0xecc8e597,0x03a7fb1d,0xfb1705ee,0xf8dcf734,
0x0ea1042b,0x13a41143,0x163e144c,0x1802117d,0x1e3120f4,0x007a102c,0xe281ee27,0xda45e035,
0xd714d889,0xd177d4be,0xc283c765,0xd850c7f8,0xe927e607,0xee33e996,0xee38ef47,0x00abf46e,
0x0cd70692,0x1b7318c2,0x10bf1a45,0x022905fe,0x0d7d042d,0x0c530eb2,0x18a80f87,0x283b201d,
0x277f2e5a,0x19ab1f28,0x06670a10,0x16230d08,0x08f11292,0xf2bd02ad,0xe57ce8cb,0xfa9dee2b,
0x02680459,0xf501fa59,0x0642fa14,0x0eee09d7,0x15881579,0x12e80ec5,0x1f161c6c,0x12f41f06,
0xf0e90087,0xe111e6fa,0xd8b2db34,0xd7a5d8a1,0xc591cff0,0xca1fbfe6,0xe11dd93b,0xec02e502,
0xe967ed74,0xf528ef20,0x02d1fc55,0x173d0d24,0x19b31bd5,0x04f2105d,0x086901f3,0x0a350bf5,
0x0f9b0cb8,0x21e913b9,0x2ab128e3,0x2545284f,0x079d1657,0x0fa60c5a,0x120c142d,0x02ac0e92,
0xe864f3f2,0xef14e6ba,0x04fafb78,0xf72e0045,0xfeb7f689,0x078000c1,0x137a1451,0x10711074,
0x1bf813f2,0x202121c7,0x02ac1409,0xeb4ff4e3,0xdca7e239,0xdcd7da80,0xcf3bd9f0,0xc27ac2e0,
0xd4abce73,0xe7cbdf0d,0xea40eabf,0xef17ead4,0xf964f46a,0x0b9b01ae,0x1ce61729,0x0d231a51,
0x07eb053a,0x0abd059d,0x09910bc5,0x17140b79,0x23832001,0x2d402c1e,0x128621dd,0x0c500dd2,
0x132e0fef,0x10d71496,0xf5070315,0xe697e91a,0x0024efa4,0xfa69028f,0xf9b8fb3e,0x005bf951,
0x11bd0b4c,0x0f8f120a,0x143d0f6b,0x23a81c97,0x1471203b,0xf98c0519,0xe368ed4b,0xdda7dc83,
0xd858e227,0xc5dacb4a,0xca1cc4ee,0xde94d46a,0xe830e5e0,0xe9bee935,0xf1e1eea7,0xfd7af7fe,
0x1b8308d5,0x166d1a1e,0x09330e8a,0x082b0411,0x06a20d77,0x0fc406b5,0x18ec154a,0x2ed4269b,
0x1efc2bb5,0x10161579,0x0fa00c01,0x172e1445,0x05ad1034,0xe4e7f70a,0xf6bbe82d,0xfd20fcb5,
0xfb63fe53,0xf86af737,0x0ba20127,0x11610fcf,0x0e500dea,0x1f0313b5,0x1f3b23e2,0x08921578,
0xef0bfe00,0xe126e0b1,0xe063e466,0xcd7ed774,0xc381c73c,0xd31dcafc,0xe44addff,0xe841e734,
0xf04de7c6,0xf197f0ef,0x0e2efb30,0x17ae1624,0x0e92187b,0x07bc053d,0x05ba0cd5,0x0a7e0505,
0x0e770d37,0x28d41930,0x28972d3c,0x18a81f25,0x0ad50ece,0x13d812a1,0x16251505,0xf01a07a5,
0xede6e846,0xf945f4ff,0xff51fe2d,0xf592f95d,0x0231f881,0x1027099c,0x0b36101c,0x159f0d4f,
0x23d31f99,0x17951d4d,0xfec20f8c,0xe521ecee,0xe3e9e6d4,0xd76de30c,0xc750cf9c,0xcbc7c406,
0xddd4d151,0xe424e4b8,0xed6fe4fb,0xea87eefa,0xfeeff083,0x13a90931,0x143d1d14,0x0aab0ae0,
0x079b0c02,0x09420461,0x080309c3,0x1bd60c1a,0x295628a8,0x22ed2931,0x0fe51588,0x0dc410b5,
0x1c7313fa,0x035a17c1,0xedd3f18e,0xf346ef24,0x00bbf9a8,0xf7d4fe3f,0xf91df681,0x0bc300f6,
0x0eb70ef6,0x0c490922,0x1f95195f,0x1f011f7c,0x0f5f1e9a,0xef60ff20,0xe893e9cb,0xe46fe6cd,
0xcfc0d8d4,0xc64bc8d6,0xd487c740,0xdee4df19,0xeb07e0f1,0xe7dfed30,0xf185ec65,0x08c2f8d5,
0x18c1181b,0x0fe40f83,0x09950e29,0x0812058d,0x05330b68,0x0fdf03eb,0x23731abc,0x28b52cbd,
0x187b1f88,0x0bcf137a,0x198f0ca8,0x14e91ee6,0xf5cc017e,0xed29f021,0xfbf8f354,0xfdb1fee0,
0xf6a6f68b,0x0126f7d8,0x0f910bfa,0x05c109be,0x17a41270,0x1fd21af5,0x1f402367,0x00420ffb,
0xeb08f2f7,0xebcaeb22,0xda59e234,0xc92cd36a,0xcb67c1a3,0xd6e2d87b,0xe69edbcf,0xe7b6e924,
0xeb90ea7d,0xf881ea3e,0x14500b7f,0x10ec125b,0x0d281314,0x08df04ac,0x04870cb6,0x06b102f3,
0x177d0c5e,0x2a6c2627,0x222525b2,0x10a41c2d,0x109e0925,0x1e021e2a,0x06b911c8,0xf005f7d1,
0xf58aedf5,0xfebbfc4e,0xf89dfbf4,0xf4daf53f,0x0cdd063f,0x068409fb,0x11450afe,0x19e01430,
0x24dc225c,0x13a21e85,0xf30f0185,0xf03fefb2,0xe301e95c,0xd17ae203,0xc81ec401,0xd0a1cfa2,
0xe05ad4de,0xe617e3d3,0xea19eafa,0xe950e531,0x0b86fb05,0x103a0d3f,0x106117cc,0x0a080821,
0x07c30c72,0x041a04d6,0x0a0702f4,0x23971975,0x256326bb,0x1ae32686,0x0c210a9b,0x1dad144d,
0x14521b0a,0xf8450788,0xef81ef51,0xf926f782,0xfe4cfe94,0xf04df4d2,0x066cfb07,0x05e108ad,
0x0c3908cf,0x130c0cb3,0x21391b2b,0x227324b9,0xff521381,0xf456f95d,0xebf6ec3e,0xdeadebe9,
0xcacaccfd,0xca76cb89,0xd78ecf7b,0xe1b4dcc2,0xec36e7fd,0xdfebe569,0xfc1ded66,0x0b91025b,
0x134515ad,0x0b1b0cd5,0x09b70c74,0x04f70930,0x00880189,0x194b0b57,0x25c11e2b,0x27332a25,
0x0cd514fb,0x16b50e69,0x1b3c1cab,0x079118b1,0xf335f79b,0xf3a2f2b7,0x020bfc77,0xf0d1fb1d,
0xffd0f3c8,0x05350333,0x09e80847,0x0c8608e4,0x17e11453,0x2a9d21d0,0x108a20b9,0xfd22075e,
0xf0e9f066,0xea42f4d7,0xd3e6dbb1,0xca7acd3c,0xd107cae7,0xd882d6fd,0xed60e359,0xdfd8e747,
0xee73e54c,0x0117f4c9,0x11a10f37,0x0d021213,0x0bf20d40,0x0bc30a3b,0xfebb02c1,0x0d060235,
0x1c961271,0x2c7d27de,0x1324233c,0x117d0ef1,0x1c34140f,0x15b620e4,0xfc4f06be,0xef7ff41c,
0x017ff530,0xf4feffa1,0xf82af24f,0xff62fd32,0x07cf0742,0x0a6a0592,0x0d340cb7,0x277218ac,
0x1d41265d,0x09ad1796,0xf51ef82c,0xf490f74b,0xde25e8d5,0xcd50d6d6,0xcf0bc890,0xcf22d05f,
0xe8dcda64,0xe1a8e829,0xe496e3c9,0xf185ea23,0x0c0f028d,0x10e50ec2,0x0c280d45,0x0f630adc,
0xffdd07cc,0x038f0004,0x0dec082c,0x2b011c50,0x1ddb29d3,0x0f4d1734,0x15d70deb,0x1e821f60,
0x0b4c141f,0xf04bfe3b,0xfb92f044,0xf9770183,0xf652f581,0xfb07f5b5,0x03ff02df,0x09ef049f,
0x053c0999,0x1e2a0e7a,0x2425220c,0x18b7235f,0xfa61073d,0xfb01fa5f,0xeb69f1f1,0xd52ee2d9,
0xcf45cc6c,0xc758cf19,0xde2bd1d4,0xe389e5dc,0xe3e4e36e,0xe630e25e,0x00f9f2bf,0x0fae0789,
0x0ab70f1c,0x0f6c0c67,0x05280dab,0x0251007a,0x00b8030b,0x1fe00de9,0x26ad27b1,0x16e32049,
0x0f970c40,0x1cca199c,0x18851c51,0xfa120e2d,0xf72def76,0xfbd7fd57,0xf715fa60,0xf686f306,
0xfdacfdf4,0x0a98010f,0x021a078f,0x10ee0737,0x208a1950,0x26002638,0x067f164f,0xfe5bffaf,
0xf60af81c,0xde50f0f9,0xd2dad72c,0xc862d128,0xd446c8d5,0xe243ddc5,0xe5ade35d,0xe073e0f8,
0xf128e6ad,0x092bfd67,0x0c0d0cce,0x0dfd0aea,0x0991124a,0x05c503c7,0xfc5f0206,0x1007ffdd,
0x25241ce0,0x1fa62862,0x0d9c130a,0x17fc134b,0x208d19a1,0x09791d80,0xf67df8b5,0xfb0cf907,
0xfaa0fe49,0xf6acf397,0xf7b9fa0e,0x06cafe0a,0x049b07f4,0x09a501bd,0x16520ec3,0x2a9d21ed,
0x1488234d,0x01820ca2,0xfd7afd2b,0xecc5fb22,0xdbffe0b2,0xce77d6ec,0xccb7c67d,0xdb00d413,
0xe556e1e1,0xe11fe2c9,0xe47cdfff,0xfc6ff02d,0x09f508f0,0x0e130832,0x0e4e119b,0x09760823,
0xfdf60706,0x0182fb80,0x1b010d49,0x2859271a,0x12c51bd5,0x113e133d,0x1e6513aa,0x194c2572,
0xfdcd0846,0xf8f9f6c2,0xfb7cff94,0xf813f761,0xf5d9f71a,0x0186f6a2,0x05fd0599,0x050c012e,
0x0870081b,0x25021843,0x21902722,0x0bad197f,0x01a601c5,0xf9ac0269,0xe5a8ebe5,0xd627e10d,
0xcb28cc33,0xd297cb8a,0xe0eedba1,0xe27ae4d3,0xdeeae027,0xef50e1db,0x041afe14,0x0a1f047b,
0x0dcf10c0,0x0c470bad,0x04530ac4,0xfb6dfd47,0x0a03feec,0x26f01ce6,0x1b372264,0x105917ba,
0x173f0cb0,0x212e2268,0x0a5e1a8e,0xfb01fb31,0xfd09fd12,0xfb17f9c4,0xf61df88a,0xf9e5f301,
0x02670335,0x055c03e8,0x017d03bb,0x19120bac,0x26ea2263,0x191b2438,0x05480ae4,0x031c07a2,
0xf12ff6eb,0xe0fbea5a,0xcde5d811,0xcc64cb65,0xdb5fd1ce,0xe3e3e12f,0xdf6ee39e,0xe277db74,
0xfae5f223,0x061efe22,0x0e120c03,0x0dcd0c09,0x09e60ede,0xfef304aa,0xfbddf88b,0x1d390d10,
0x2193215a,0x138220f6,0x102e0e38,0x22a01768,0x19d82408,0x00eb0725,0xfd1ffdd1,0xfb89fbad,
0xf7c7fd9a,0xf662f24d,0xfe23fcd1,0x06b0035b,0xffeb03b1,0x0b8902d8,0x2226171b,0x24bb2875,
0x0d2f1599,0x07ef0bc3,0xf9fc026d,0xeda8f347,0xd8fae264,0xcbb2cffc,0xd255cc1a,0xe07fda01,
0xe318e59a,0xdbbadad6,0xefc6e53f,0xfd62f5b4,0x0a9906b1,0x0d590aa1,0x0d510f44,0x06d20c03,
0xf457fc4b,0x0c420035,0x21b6177d,0x1d1923d8,0x0e8b13c0,0x1ad40d08,0x22832484,0x09c91704,
0xff6a03dc,0xfc5bfb0d,0xfb050055,0xf585f4a9,0xf8e7f765,0x051eff2a,0x0227054e,0x038ffebf,
0x157508fe,0x27fb25a4,0x17952080,0x0e2810a6,0x02f8095a,0xf6c3fca6,0xe4a1efb5,0xd143db42,
0xcdbecce0,0xd9b9d007,0xe54de397,0xdac6df3a,0xe57dddc4,0xf45eeb22,0x0489fda4,0x0a20086b,
0x0b1a0ebd,0x0f4e1157,0xf9cb0305,0xfe18f868,0x187d08c6,0x22f21fb2,0x12561e4e,0x10480add,
0x254f1c8b,0x15f82047,0x05b60f11,0xfd7bfcde,0xfe130145,0xf77bf9eb,0xf5aaf5ae,0x00a7f8a3,
0x01ef05af,0xff7c02c5,0x081efe44,0x240717d2,0x1f29255c,0x12ff1854,0x094d0f7c,0xfe570451,
0xf211f8d9,0xdba1e5f8,0xce78d417,0xd05cc9f7,0xe3f2db92,0xdd9ce1f7,0xde40dc64,0xe90ce2e2,
0xf9cef4f6,0x09150315,0x09670862,0x13cd106e,0x04390b15,0xf678faba,0x08a3fd6c,0x1fe31448,
0x1c6e23d1,0x09750f30,0x1ea71340,0x1d992114,0x0ed61b36,0xffe702e2,0xfff8001a,0xfae1fdab,
0xf316f8c9,0xfba6f4fe,0x038eff09,0x01b9050b,0xfd2ffc3f,0x17ea092d,0x234f2327,0x1a311ed3,
0x10bf155a,0x04cf0adc,0xfd440176,0xe934f146,0xd784de99,0xc9f5cbfe,0xdc2bd2ea,0xdf0fe2d0,
0xdc6adf27,0xe28fdc52,0xeed1e981,0x04adfa7f,0x0519035e,0x10d40cd5,0x0e2511c2,0xf99902a0,
0xfc27f80c,0x130c0595,0x24a120d2,0x0aff1850,0x16360daf,0x20921a14,0x19d421b0,0x047f0e7c,
0x00950308,0x00aafecf,0xf5a4fbce,0xf6d2f48b,0xfe72f929,0x049705b4,0xfa24ff76,0x093ffc99,
0x20b81819,0x1e562166,0x18681aff,0x0b0b0fc9,0x05810712,0xf376fb7f,0xe147ecf2,0xca1ad78a,
0xd3fccc2a,0xe00cdba2,0xdd4ce118,0xdf89dafe,0xe409e099,0xfbb1f10a,0x0242fe7b,0x0b290530,
0x136111d2,0x024e0cd2,0xf871fab0,0x017ffa11,0x249d1418,0x13911f1c,0x0ea20ebe,0x19af13ab,
0x227b221d,0x0f941743,0x01aa08a8,0x02e50064,0xf9aa006b,0xf5a2f772,0xf83af505,0x05300117,
0xfca40505,0xfd08f94f,0x197f084a,0x1f6e1dac,0x1ed01eb4,0x0fa9174e,0x0a9d0e5c,0xfc830545,
0xf056f7d9,0xd4cee434,0xce0fcdd5,0xdcf1d213,0xdd16e141,0xdff3dd61,0xdcdfdba6,0xf060e63b,
0xfd72f83f,0x0385ff9c,0x12bf0b45,0x0bdf1353,0xfec801e4,0xf352f6ad,0x177303c2,0x1afa202d,
0x10681422,0x117d0c45,0x21841d11,0x19671ed9,0x062a123b,0x041502c9,0xfe8d02ff,0xf7d3fc42,
0xf2f2f4ff,0x0263f9c0,0x04880478,0xf828faff,0x0b58fb39,0x196116cf,0x21281f6e,0x15bc1d5e,
0x10801283,0x034c0ba9,0xfcb6fff8,0xe374f0ed,0xce07d929,0xd73fcb4f,0xdb68dc79,0xe0cbdeb5,
0xd99adc7b,0xe576dd66,0xf681eed6,0xfdccfaf7,0x0cb20095,0x0e9d150a,0x085a0c1f,0xf11bfca5,
0x075af41d,0x1ad315dd,0x16321b54,0x0bd20c0c,0x1b9f1519,0x20cd1edc,0x0e6e1bf2,0x05b508c7,
0x02090473,0xfe4cffc4,0xf341f6ba,0xfb1ff367,0x06a7009a,0xf82f02db,0xff0cf5e5,0x110f0a42,
0x1ffd19b4,0x1aec20e3,0x168016a3,0x08ad1185,0x04dd074e,0xf439fba9,0xd64ee927,0xd211ce12,
0xd87ad6a1,0xe143dccd,0xdb75dfc8,0xde9ad8f5,0xed1fe455,0xf710f805,0x04acf8b2,0x0fee0d75,
0x11c80ed0,0xf77a0974,0xf92defc3,0x114905bf,0x1c2b1bed,0x0b72110c,0x11fb0fcc,0x207f1a99,
0x197921c8,0x0c880eeb,0x0435064b,0x03840329,0xf644fd15,0xf40cf42e,0x0497f96c,0xfe2607cd,
0xf868f7e8,0x066b0033,0x1aa31018,0x1ce42110,0x1c981a96,0x0eea161e,0x08db0d9a,0x01620356,
0xe5fef8c7,0xd3c2d750,0xd4c0d238,0xde87d75c,0xdca6e244,0xda50db96,0xe4badaa7,0xf2c5ef9a,
0xfac4f205,0x0924059c,0x156f0ba0,0x0447148c,0xf430f635,0x0183f816,0x1b13144f,0x102a17b8,
0x0d120e4b,0x1bbe10e7,0x1f9021a8,0x132f17d7,0x058f0ca9,0x069b0567,0xfcf7023e,0xf1eff85f,
0xfd10f220,0x03e1068f,0xf890fc33,0xfd07fb0e,0x12a40273,0x1a3b1bc3,0x1f8f1cfe,0x158e1a1d,
0x0d0113d2,0x09a60785,0xf83c056f,0xdb4fe735,0xd11fd867,0xdbc2d2d9,0xdf9adec3,0xdbbfdfc7,
0xdbebd6a7,0xed5ae7e8,0xf397ebce,0x0067fd7d,0x10770374,0x0e4d19e9,0xf9470508,0xf516f267,
0x1385046b,0x162c171c,0x0c8011eb,0x13280a12,0x1fc61c8c,0x1bde1ccb,0x0aa3138f,0x07b30860,
0x03c10586,0xf61affd8,0xf42defc4,0x059f00b2,0xfcd8ff95,0xf6cffdbb,0x0799f8b8,0x15101208,
0x1f8c1b19,0x1b111bd7,0x12231925,0x09f20bc6,0x063d0ee0,0xeb2cf5d4,0xd4eee132,0xd637d198,
0xdd6ad997,0xe0a5e18b,0xd657d690,0xe722e080,0xec1de581,0xf700f836,0x06a3fa86,0x14dd1349,
0x07451019,0xf09af779,0x0569f75b,0x15b40f65,0x108f16fc,0x0c58087d,0x19791499,0x20051dc8,
0x11f91a77,0x09460dab,0x06df06cc,0xff550662,0xee94f2f7,0x00bafa04,0x0168ff40,0xf854011d,
0xfe05f3dc,0x0cb205a5,0x1a09165f,0x1bf11cf7,0x1a4d1de0,0x0b990eb5,0x0e2d1100,0xfab8041b,
0xe10cee7b,0xd5ffd527,0xd7e0d419,0xe3f2e021,0xd483dbe3,0xe1c6dde3,0xe738e0d7,0xf2fdf216,
0xfc62f38d,0x10ea0888,0x140f168d,0xf76705dc,0xfad0f3ab,0x0e56031e,0x15431791,0x0b7b0cf9,
0x124d0e51,0x1f5919ec,0x19691e64,0x0e40146e,0x061109b3,0x089a0a08,0xf0b3f994,0xfa2bf507,
0x02befa64,0xfbc7036b,0xf6d9f7b2,0x036ffd2f,0x15910c14,0x193f17e7,0x20262029,0x0f0c1569,
0x1104103e,0x07fb0ba7,0xeed9fce9,0xd9d3e15f,0xcfdfd52b,0xe3cbdb4a,0xd7afde42,0xde73dbdd,
0xe1d5dc8e,0xeeafebc2,0xf3e8efa3,0x0602fbfb,0x19ad1166,0x03da1333,0xf72df9e7,0x02def89a,
0x14c41066,0x0e8411c7,0x0cc50b68,0x19921375,0x1c8e1ebc,0x17391924,0x06c50d2f,0x0ea70a4c,
0xf75c0177,0xf386f611,0xfd23f671,0x003d032a,0xf78cfa7c,0xf904f92b,0x0e2f02d3,0x1397100f,
0x22a61bbb,0x14ab1b44,0x108111cc,0x0de30e6f,0xfba50a4b,0xe76aef4d,0xce80d9f8,0xdf6ed564,
0xda66de44,0xdd17dd09,0xdd9fdaa8,0xeaede540,0xf022ecc1,0xf962f362,0x15b6058f,0x112818df,
0xfce606f6,0xfa73f5ef,0x0e230554,0x116713a6,0x0b290e13,0x14700ccd,0x1b911a63,0x1eda1b57,
0x08e2144f,0x0ebc0ca0,0x008e093d,0xf49efa34,0xf619f24d,0x0023005a,0xfc5bfd94,0xf58cf83e,
0x06fdf968,0x0b8f08e8,0x1e7314ed,0x19eb1fcb,0x12b61766,0x11880de6,0x06451168,0xf756fd44,
0xd4a2e6ef,0xda35d365,0xdb1cdafe,0xdda8dd2b,0xdab7da89,0xe53edfb4,0xee21e91c,0xef18ef09,
0x08f6f854,0x16c813b8,0x06e613df,0xf835fd1e,0x0526fb7b,0x11f40dbb,0x0d331106,0x104208f3,
0x15181578,0x21821b97,0x10341ac3,0x0e4d0e89,0x07210edc,0xfa860277,0xf2c0f1e3,0xfe03f976,
0x0076fcf5,0xf4b7fb3a,0xfe0ef56e,0x03ad0358,0x17040a9b,0x1ce71bb2,0x161c1d1c,0x12080f37,
0x0bd213ef,0x04c307b1,0xe2ddf72d,0xd7a9d890,0xd907d890,0xde47dbf2,0xda76db69,0xdfb5dcbe,
0xec8ae468,0xeaaeede1,0xf955efef,0x13b607ff,0x13271800,0xfeab08e4,0xfe45f916,0x0d3f04bf,
0x0e791341,0x0f160991,0x100d1045,0x1e091764,0x168b20e3,0x11cc1250,0x0d930efc,0x036c0983,
0xf333f697,0xf7b6f5dc,0x0037fb93,0xf7c6ffe3,0xfa61f3d2,0xfd8bfea4,0x0c740385,0x1a90131a,
0x1a3920ee,0x14551317,0x0e671451,0x0d940ced,0xf52605d0,0xdcd6e455,0xd733d7f6,0xdcc6d9aa,
0xdb20dba6,0xda1edc17,0xe797dfc5,0xeb2eeb9d,0xee05ea74,0x0893f89d,0x185e116d,0x08831396,
0xfc33ffc3,0x068ffbcc,0x0d8a1002,0x0d050c77,0x0c060f98,0x19451050,0x1bf11f25,0x159f167d,
0x0ebe10a8,0x0a461070,0xf7bcff12,0xf410f562,0xfdb5f52a,0xfa960199,0xf8e6f513,0xf982fa7f,
0x02cbfed3,0x12d90727,0x1be71e2f,0x177916e7,0x103315b6,0x10f30d61,0x05060ef8,0xe89bf4dd,
0xd796dd41,0xd90ad94a,0xdcf9da5d,0xd8e4db72,0xe18cdb5f,0xec32e77a,0xe890e9d2,0xf953ee62,
0x14810535,0x124f1691,0xff670d1c,0xff92fb65,0x0c0909e7,0x0e090b8f,0x0c510f5a,0x13460af5,
0x1bb41aa1,0x19c91b7c,0x11641331,0x117712dd,0xff27080a,0xf454fb0a,0xf8bef0a5,0xfc170068,
0xf91ef87e,0xf7fbf7eb,0xfcc3fd0a,0x089ffd16,0x1a4e1520,0x1a0f1876,0x13b8191c,0x102c0e1f,
0x0e021339,0xf7b40654,0xdedae8dc,0xd72edb61,0xdca4d8e3,0xda0fdb3e,0xdb48d944,0xea71e232,
0xe9d0e90e,0xec2ae883,0x0636f991,0x160e112e,0x0acd1638,0xfdefff3b,0x084603f0,0x0c580894,
0x0c7d103c,0x0e480997,0x187812e4,0x1c961b9c,0x12a81748,0x155014d4,0x07a70e9a,0xf90d03bc,
0xf4a0f076,0xfb54fbaf,0xf9c4fc03,0xf7a8f68d,0xfa84fc7e,0xfe2bf7ac,0x12b609f2,0x1922168e,
0x17991ca2,0x0fdb117e,0x122d1128,0x05e51156,0xebf6f7c1,0xd9c3e12b,0xdac0d81c,0xdc97d97a,
0xd6fdd800,0xe2f9dd7d,0xea77e906,0xe673e7ea,0xf88eee51,0x106803d0,0x152a192a,0x012c092a,
0x056602ea,0x0a7104ab,0x0ddb0e9d,0x0bf20b15,0x11e60e37,0x1d7b18c7,0x142a1a71,0x172c1787,
0x0efb1269,0x00c30d5b,0xf448f600,0xf90af5e0,0xfb91fce4,0xf772f590,0xfb64fb9e,0xf6d3f6d8,
0x083c0041,0x15d20edb,0x1a821bbc,0x1216177c,0x12260ed6,0x0f9c15b0,0xfce00628,0xe35aeb93,
0xd809dbc8,0xdc13db4a,0xd71cd9a1,0xdcbfd888,0xea38e4c6,0xe61fe8d3,0xed59e8ea,0x0238f631,
0x19c612a7,0x095d10b2,0x04620633,0x068f02df,0x0d120b9a,0x0c5a0bfe,0x0b900bf1,0x1ba41319,
0x16111a37,0x18bf199f,0x14dc1373,0x0aa313cb,0xf8ebff8d,0xf5adf367,0xfc33fbd5,0xf5abf75c,
0xfcd3fab0,0xf502f891,0xfdfdfa58,0x0ee4055c,0x1a45157d,0x16d51c06,0x11f00ed6,0x136e1378,
0x080c1121,0xefe6fc31,0xdb6ce387,0xdb65daf5,0xd8addb1a,0xd6b3d663,0xe5b7df06,0xe716e860,
0xe9d5e779,0xf35dea5c,0x142504a4,0x111f1405,0x087c0c2a,0x0430040a,0x0a4708e2,0x0e5a0bcd,
0x07ec0ccb,0x16d80e20,0x171c16ac,0x195a19b9,0x16ba1467,0x11cf1642,0x00540aeb,0xf37ef653,
0xfbedf88a,0xf423f884,0xfbbcf948,0xf763fae8,0xf7caf7c0,0x05e9fceb,0x15bc0ade,0x19541cff,
0x11d314f2,0x142a112e,0x108d1426,0xff62099d,0xe435f0b5,0xdb31deec,0xdb5ddcf1,0xd4cad6ca,
0xe0cdd7f6,0xe5aae4c8,0xea0fe855,0xe82ee58b,0x0622f472,0x11d20faa,0x0d8e121d,0x055307ad,
0x0675078b,0x0f8908b1,0x07f30d16,0x116f0b1a,0x15b211c0,0x17d018c5,0x16df16b0,0x158c167a,
0x0a7413f1,0xf45ffebb,0xfadcf6a6,0xf48cf8b9,0xf953f6d1,0xfc2df9fd,0xf59cf70a,0xfbcaf9b5,
0x0cc30041,0x1a621605,0x149e192d,0x12c3112e,0x127b13ed,0x0b15128a,0xf1e70082,0xdf7ae67d,
0xde2cddcb,0xd4bcda53,0xdbcbd3bd,0xe1c8df3f,0xeaf2e6fe,0xe2c7e760,0xf63ce8cd,0x0bc4040c,
0x11b713bc,0x0b1e0bca,0x049f092e,0x0e80061b,0x09af0d1a,0x0d8b0b36,0x135e0e28,0x171515bd,
0x1742179b,0x15ec1718,0x15b0183e,0xfb5d0948,0xfabef7c5,0xf71ef835,0xf4f0f627,0xfcfbfa17,
0xf850f8c9,0xf809f84d,0x0152f91e,0x15710c10,0x17411ad6,0x131e14fc,0x12e712b3,0x12941442,
0x01490d40,0xe7e0f41e,0xe21de0e6,0xd764dec8,0xd783d451,0xdc98db29,0xe9e2e2ab,0xe391eaad,
0xeab1e3e2,0x015ef434,0x112c0e22,0x11950d8b,0x06570ce9,0x0b86058b,0x0b3e0b98,0x0b380bb5,
0x0f2a0cc7,0x140712f6,0x17a01651,0x147716e0,0x1c7b1748,0x04f91374,0xf9e5fe24,0xf9bff8c6,
0xf336f509,0xfab6f6e1,0xfa48f9a3,0xf741f992,0xf784f76e,0x0c1a004b,0x177a15c2,0x154817f3,
0x124a1367,0x14ca1317,0x0edf12a1,0xf3dd032d,0xe693e870,0xdbfae3a9,0xd600d6e7,0xd77ed880,
0xe57cdbeb,0xe62ce9ee,0xe4bae4e8,0xf46fe6d2,0x099c0315,0x135b0bd5,0x0a4210c7,0x083d089c,
0x0b140a87,0x0ae40bd6,0x0d7e0b76,0x11310fd4,0x17de1313,0x11ca17a3,0x1cc916b3,0x125d1990,
0xfd680684,0xfbdcfb43,0xf37df6a3,0xf6a4f4da,0xfa89f8c1,0xf9f2fa25,0xf41df868,0x001af719,
0x13920bc8,0x18361631,0x12d71533,0x130f129d,0x15641358,0x01b61050,0xec7cf450,0xe1d5eadd,
0xd84edb39,0xd46fd8bf,0xdfb7d60e,0xe761e46f,0xe4c0e87b,0xea53dfee,0xfdf0f64d,0x0e8306d2,
0x0f08126e,0x09a10c80,0x0aae0989,0x0b270b6b,0x0c6b0a60,0x0cb40f85,0x174f0fda,0x12c61576,
0x19461390,0x1bae1b16,0x047a1092,0xfdd0fffd,0xf5e2f9ac,0xf3cbf3cc,0xf77df6a0,0xfb7bf9c8,
0xf6b9facf,0xf73af271,0x09e00037,0x16fc117a,0x153a16d3,0x115c1412,0x156811a8,0x0ea217df,
0xf5e40115,0xe98cf37d,0xde2ae029,0xd4b5dabe,0xd97cd346,0xe3b7dc13,0xe5dbea7f,0xe3a7e00a,
0xf277eb61,0x0635fc01,0x10960daa,0x0cc70f77,0x09d90af8,0x0b0e0c42,0x0da8084a,0x0b1a0eb3,
0x14600d39,0x13a814a2,0x13a4127e,0x1f2219cd,0x0ec11944,0x016f0747,0xf9c4fe82,0xf414f514,
0xf512f485,0xfab3f644,0xfa4ffd55,0xf458f40f,0xfebbf6cc,0x10a8097f,0x16c715c3,0x1287174a,
0x12311042,0x176019a7,0x02a90bc1,0xf379fcfa,0xe647e78c,0xd86fdf30,0xd552d66f,0xddbed533,
0xe76ee791,0xe247e31f,0xe9b8e560,0xfa54f1e4,0x0b92067a,0x10b71044,0x0c710bca,0x0a650dfc,
0x0d6b07e9,0x0b0c0e4a,0x0fa50c0f,0x14e612fc,0x0f3811cf,0x1c1a15dc,0x17f81def,0x08050eb4,
0xfe780352,0xf52df888,0xf3abf4c2,0xf754f181,0xfccdfbb7,0xf534f82f,0xf59ef306,0x06c1ff57,
0x14450f62,0x16c31865,0x0f1a0f6f,0x1a0a16fc,0x0d5511ff,0xfbfd075a,0xed71f305,0xde97e4ba,
0xd546dc08,0xd644d1a8,0xe509e0d8,0xe261e57f,0xe4b6e3e0,0xf108e8a4,0x029cf9c0,0x0fa40cf0,
0x0ef90c93,0x0ac210b1,0x0c3b08bf,0x0c830d48,0x0bac0c0f,0x14e410ed,0x0edf129e,0x17531049,
0x1db21d52,0x1005168d,0x05a6095f,0xf92efcf2,0xf487f77c,0xf27af089,0xfb84f819,0xf7e6fcfb,
0xf242f599,0xfe1ff6af,0x0cf2054c,0x1a9c1644,0x0e1011e8,0x17e314d6,0x1505153d,0x06690f1d,
0xf71ffeb5,0xe5bcec75,0xda14e420,0xd12dd3e9,0xe0c2d900,0xe407e325,0xe2b5e40a,0xea50e4a5,
0xf7b2edc0,0x0a830517,0x10280a56,0x0dc3124e,0x0aae0b7b,0x0e5f0c5c,0x0a5d0c3c,0x12cc0de0,
0x102514a6,0x11270db8,0x1f43182f,0x161a1b8b,0x0c0a11a9,0xfd7003a2,0xf704fbea,0xefb5f2d8,
0xf789f286,0xfbb9fbc9,0xf3abf88a,0xf812f286,0x00e5fb35,0x19650f2d,0x109613a3,0x14391280,
0x17e9155d,0x0de713da,0x00b90a19,0xedf2f668,0xe49bea0d,0xd1d4d95c,0xda18d3bb,0xe3acddec,
0xe1a5e3a1,0xe686e46b,0xed30e5ab,0x0071fb35,0x0be20699,0x112c1121,0x0a470ea6,0x0e240c0b,
0x0a920d49,0x0fe20abb,0x13cd1351,0x0c470e12,0x1b8611e3,0x19c71ccb,0x12d518db,0x04040b42,
0xfc6f0041,0xf19bf704,0xf24bf002,0xfc69f756,0xf603fc43,0xf824f3c4,0xf769f2f8,0x118b03fa,
0x13671362,0x10ae12c4,0x173b1503,0x12be15b6,0x0af71101,0xf60f014d,0xedd2f19e,0xd864e27b,
0xd361d439,0xe03ed8c6,0xe01ae15c,0xe507e579,0xe6b8e232,0xf792efd3,0x0468ff14,0x11a00cc7,
0x0da81162,0x0ecf0b7b,0x0c6c0e20,0x0c2d0a7e,0x15d8110f,0x0ae611d8,0x14a60d7c,0x1b3019c3,
0x19521bcc,0x0ad412f7,0x022205cd,0xf62afc72,0xeeecf206,0xfa52f072,0xf796fb91,0xf95cf739,
0xefeff27b,0x03c8fa35,0x134f0e44,0x104212ad,0x15c31303,0x1422160d,0x13b113c9,0x00130a69,
0xf5f1f9ae,0xe3fcebfe,0xd149da44,0xdb97d54a,0xde7adc7b,0xe420e3f7,0xe230e2a3,0xef0ce7e5,
0xfbdbf5da,0x0dcd0335,0x0fd010d4,0x0e280d07,0x0e250e8d,0x08db0c02,0x14bb0d50,0x0df01499,
0x0e600b86,0x179c14ca,0x1c481c4a,0x118a1a28,0x08e80c19,0xfda5011f,0xef90f7ed,0xf587ed0e,
0xf697f897,0xfb73f9af,0xf0e4f59f,0xf802f1ba,0x0dab03fa,0x10ef111c,0x14dd1084,0x13631589,
0x18091424,0x09681161,0xfc3f034d,0xf0a2f522,0xd67ee3fc,0xd6b8d5d7,0xdb07d8a0,0xe39adfd9,
0xe169e29f,0xe93ce2b7,0xf2a0ee7a,0x04ddf96e,0x0ecd0cbb,0x0de6100b,0x109b0e87,0x08760e81,
0x10f009ff,0x11b11596,0x0be00db2,0x12720fba,0x1e70178d,0x18401c54,0x0e54137d,0x053b06a2,
0xf3d9001f,0xf276eea2,0xf431f3bb,0xfad0f8b9,0xf545fae1,0xf0f9f023,0x0482f803,0x0f470bd8,
0x147c0e62,0x11fe150f,0x18021410,0x11d2152e,0x01eb0c3d,0xf9b8ff58,0xe1e5f068,0xd7a2da21,
0xd7a1d5e0,0xe0b3db05,0xe0eae2cd,0xe572e069,0xeb86e9e5,0xfad3f091,0x0b9a02c9,0x0dc90f95,
0x11410eb8,0x0a9b1232,0x0ca40894,0x14601377,0x0ec01016,0x0cdf0d8a,0x1b05125d,0x1bfc1c0a,
0x13511aee,0x0c870bfd,0xfb600859,0xf270f4d2,0xf163f1a6,0xf87ff49e,0xfa90fc57,0xeffaf467,
0xfa2aef78,0x0876047a,0x12ed0bae,0x113a13fc,0x14761497,0x170a16a5,0x09b11253,0x03520599,
0xef83fa9d,0xdcd8e38c,0xd5a5d7da,0xdc45d656,0xe00ce154,0xe37dde6e,0xe7fee620,0xeff8eaab,
0x02a9f899,0x0bc60c21,0x11220d8c,0x102a13ba,0x09990894,0x13311078,0x1291121e,0x0a870f3a,
0x14880dd2,0x1c9517bd,0x16ee2037,0x110e1291,0x056e0f3f,0xf69ffc88,0xf0d7f34b,0xf48eefde,
0xfc90f8cb,0xf409fa63,0xf31feba0,0xfe55fbd5,0x0d8e0736,0x12021107,0x124212e1,0x18a5146c,
0x0f7a1638,0x09240adc,0xfb5f03d5,0xe61ceef9,0xd852ddcf,0xd84ad288,0xddaadddd,0xdfbfdd81,
0xe543e38c,0xe873e826,0xf85dedd8,0x084402df,0x0d4509d9,0x13ca14a7,0x08cc0ba2,0x0f5d0d58,
0x153a1166,0x0c3f1196,0x0d4a0cbd,0x194110e3,0x1b361fa4,0x14a216a3,0x0f2a1356,0xfdd20471,
0xf37bf830,0xf0aaeec4,0xf973f216,0xf773ff42,0xefd6f00c,0xf74cf408,0x0617fe93,0x116d0be8,
0x10b411d5,0x170d120e,0x1448183b,0x0cf60f42,0x06690ae6,0xf110f99e,0xde03e9e9,0xd4f1d5d2,
0xdb28da8b,0xdd32dc14,0xe3bcdf57,0xe64ee64c,0xed48e6c0,0x0287f8e7,0x086e0342,0x161c116c,
0x0c5b0f11,0x0afb0c32,0x14b41017,0x106a137d,0x0a9f0fa7,0x12700b90,0x1dec1b90,0x17ec19b4,
0x164216a6,0x06db0cf1,0xf7f3fff9,0xef1ef51e,0xf427ecc9,0xfaf7fd51,0xf14ff63f,0xf21bf112,
0xfc05f7e1,0x0cda0459,0x0fb71053,0x14050f9a,0x17e816c3,0x0edc1227,0x0d4d0ff1,0xfbdf03cb,
0xe9d0f56b,0xd806dc98,0xd9a8d706,0xdabfdacf,0xdfc9dc06,0xe6c3e458,0xe4d6e3ec,0xfae2eec6,
0x007afbd7,0x11c70c36,0x10ad128a,0x08eb0d7b,0x11810dc4,0x13a612ee,0x0d9f12ac,0x0bb70912,
0x1c95136a,0x18c11a86,0x16f61ad6,0x0f6f1588,0xff9706c9,0xf33dfcff,0xee8deba7,0xfa8ff6ec,
0xf56afaa9,0xf192f1b9,0xf5b8f2f9,0x0624f9b8,0x0ed90b6b,0x0fa90ea2,0x1863152b,0x109814e9,
0x118e1260,0x057f0b67,0xf5c9ffda,0xde18e99f,0xd900d8bb,0xd9f5d90d,0xdae2d932,0xe6d4dfe8,
0xe019e441,0xf184e780,0xf8dff4c6,0x09bb034e,0x137d11fd,0x0b62100f,0x0e480b8f,0x146910ba,
0x1375148b,0x07ad0c34,0x16380db4,0x1b33185f,0x19391a45,0x16ae1a4c,0x07e70e3d,0xfbbe057e,
0xec99f175,0xf698f01b,0xf93ffae6,0xf408f40c,0xf137f231,0xfa92f42e,0x0b6404aa,0x0c330d00,
0x176611b1,0x12a515b4,0x12e2136f,0x0c2310ce,0x01eb07df,0xe9c6f65b,0xdb2edf28,0xd9eed8a5,
0xd583d954,0xe3fbdab6,0xdf64e40e,0xe922e32c,0xf2adee09,0x00a6f820,0x12b80a52,0x103510d5,
0x0bad0b3c,0x10800e86,0x17ef149c,0x0a3910b7,0x0e4b0a11,0x18f114b0,0x183e19ab,0x19dc1dd3,
0x0f7e1503,0x06220c19,0xf19afb10,0xf17eec1b,0xf84cf7c9,0xf601f74d,0xf14ef403,0xf205f0f4,
0x0527fa8b,0x084d0982,0x13c20e17,0x13d6152d,0x14231338,0x104312c0,0x0b6a0d09,0xf705020b,
0xe109eb17,0xdc7dda81,0xd328daa0,0xded5d610,0xe051e1ab,0xe3b3e0f3,0xed70e8aa,0xf67eef8d,
0x09f500e7,0x12031120,0x0da10d4a,0x0bf60bd2,0x17b912d5,0x0ff115ca,0x090c0b70,0x14bf1073,
0x17cd167b,0x1db11cab,0x15fc1881,0x0e291223,0xfaf8081c,0xef4bf041,0xf624f37c,0xf7def77f,
0xf4f2f66b,0xed8af237,0xfcd5f337,0x05a202f3,0x0fef08cc,0x13f8133e,0x150412d9,0x11361476,
0x10a210ae,0x03370b7d,0xe977fa77,0xe079e188,0xd54dddcd,0xd923d381,0xe013dd7c,0xe084df38,
0xe824e5f2,0xefa7ea3b,0x00b9f43a,0x0f7d0a75,0x105a105e,0x08fd0cb8,0x13b30f4b,0x163b1835,
0x09ee0f1a,0x117e0c6b,0x15611174,0x1d581a34,0x19bc1c3d,0x15101519,0x071611cb,0xf225f9e0,
0xf2aef157,0xf576f60d,0xf857f7ed,0xee9bf4df,0xf4fdeeb0,0x0068fb79,0x09c70355,0x11cb10b8,
0x150511f1,0x11a715b0,0x11fa128c,0x0e211074,0xf6e00735,0xe73cea98,0xdb34e2c8,0xd433d548,
0xddb5da40,0xdfabdbe6,0xe532e263,0xea12e756,0xf5c0eb56,0x07790001,0x11c70f8e,0x0b210ecb,
0x0ea709e8,0x1a0515c0,0x0d5213af,0x0e140d3b,0x11c80e28,0x1b0414ea,0x1bdb1e06,0x174c17c0,
0x112219c7,0xfaa80751,0xf2e9f3c8,0xf312f327,0xfa1cf5c0,0xf2e2f7ef,0xeff2edfb,0xf9f6f574,
0x02c0fcaa,0x0d640c3e,0x13c31004,0x13531494,0x114a12fd,0x13c9109f,0x03ab1134,0xedd7f722,
0xe4bbe920,0xd4ffd7a9,0xd9add6b8,0xdc6fd943,0xe20ede7e,0xe4f9e619,0xebe3e74e,0xfcc4f40f,
0x0ea907f0,0x0eb110a1,0x08420988,0x191d1078,0x1277162f,0x0e400f5c,0x0e300cf7,0x14d60f96,
0x1c1d1d69,0x186a198c,0x1a231ac9,0x069c129a,0xf729fb99,0xf14ff34f,0xf791f29e,0xf7b7f9eb,
0xee0ef0aa,0xf473f2e6,0xfcb2f599,0x089a0494,0x111f0cde,0x1420128e,0x1052156d,0x13de106f,
0x114f1629,0xf75d0340,0xed2df2e3,0xd933e124,0xd621d7ba,0xd8acd905,0xdf8dda56,0xe3afe37d,
0xe6c7e4e6,0xf1bcea93,0x0627fd55,0x13470d95,0x07240b6f,0x13d00aa3,0x15aa1715,0x0ff51369,
0x0d320fda,0x0fbe0c02,0x1c1b177f,0x19181b34,0x1e9d191e,0x126b1b2c,0xffae0724,0xf342f867,
0xf2b0f16e,0xfb0cf92d,0xf04ff492,0xf1d1f27f,0xf5b6f211,0x00e7fdb0,0x0c4a09a8,0x14220f2b,
0x131914e0,0x10460fb8,0x19a61644,0x02220e8a,0xf54ffce2,0xe270ecaa,0xd7efdabd,0xd686d86f,
0xdb24d72d,0xe1aadfe7,0xe4b2e4a0,0xeadae3f4,0xfa77f0d6,0x116e053b,0x08b20f46,0x0c81085f,
0x16c413c8,0x13451522,0x0f5b12ba,0x0b8c0bd2,0x18801019,0x190f1b80,0x1d661773,0x1a1f1f8a,
0x094f1350,0xf9ea00d3,0xefb5f2e9,0xfa6bf53b,0xf364f760,0xf0d0f39d,0xf221f13b,0xfc18f438,
0x068b01af,0x0ff20b42,0x1599131b,0x0c3a112c,0x1a15130c,0x0db9166b,0xfe4f04d2,0xec62f78f,
0xdc49e2c3,0xd656d9f9,0xd85dd4e8,0xdeeed8c4,0xe357e327,0xe5cbe1d4,0xec85e907,0x0771fa24,
0x0c0e0f1b,0x079b08c6,0x137f0e30,0x158b14dc,0x135f145b,0x0aa80f0d,0x12bf0a1e,0x187618d6,
0x1b0516a9,0x1fdf1d35,0x13391b5b,0x04190ba1,0xf0b6f9d3,0xf690f335,0xf761f7b0,0xf323f3fc,
0xf05df211,0xf611efe8,0x004cfa03,0x0953066c,0x169d0faf,0x0d0612ee,0x156d0ed2,0x153f1a1f,
0x06140e85,0xf7600287,0xe606ec31,0xd88cde32,0xd5eed6ce,0xd912d48e,0xe0cfe07a,0xe3f6e186,
0xe461e48e,0xf9c1ec9c,0x0cbb07b7,0x08080977,0x0e4508d7,0x14fe11fa,0x161c1491,0x0d6714df,
0x0ddd0814,0x1698133c,0x17a01682,0x1eff1a79,0x198620ce,0x1041158e,0xf96d0350,0xf3eef3ba,
0xf7cef6b9,0xf5aef58e,0xf06df41c,0xf080f096,0xfae8f34f,0x0168ffb3,0x12110aba,0x0f391512,
0x0fcf0d09,0x19ad1795,0x0fee1357,0x020e0aac,0xf0f6f778,0xde0ee6cf,0xd74cdbac,0xd507d317,
0xddb5db57,0xe303e07d,0xe1f3e46c,0xebf5e271,0x0663fbf5,0x094509a9,0x09b107c3,0x12da0e28,
0x176d1206,0x130c193e,0x0ad70b4a,0x120c0f74,0x14651691,0x1d3a175e,0x1e1c1f82,0x18d31c96,
0x05371060,0xf58cf9cb,0xf5f8f6f0,0xf85bf66e,0xf486f4f9,0xef00f256,0xf5a3f032,0xfb2cfa3d,
0x0c60021c,0x138312b9,0x0c760ca4,0x17c31386,0x15d815ec,0x09fb126f,0xfb960294,0xe6cef084,
0xdb3ae2d0,0xd338d56b,0xd94cd61a,0xe04cdc28,0xe29ee509,0xe0cade6e,0xfa86eda5,0x093c03df,
0x07410657,0x0d170b97,0x13a10f0a,0x174b1b08,0x0c13116c,0x102d0b54,0x125d12bd,0x19b31436,
0x1f1e1b9c,0x1dc81e44,0x12261b03,0xfcc602fa,0xf56df81b,0xf6a5f670,0xf62ff6ab,0xef7cf54f,
0xf293ee6d,0xf720f475,0x01b4f8c4,0x137b0da5,0x0b3f0de5,0x12e8101f,0x17f01438,0x10ad16ef,
0x04f10c6c,0xf0fbfade,0xe29beb93,0xd431db6c,0xd53ed521,0xdb28d666,0xe4f8e2e3,0xdd8fde8c,
0xecb2e093,0x0382fa14,0x054604b8,0x09c40a94,0x0fa40964,0x1a1215f6,0x0fe0179e,0x0e870b8f,
0x0fbc1014,0x14ab1228,0x1d5918b4,0x1f811bea,0x1b3121a3,0x064511a0,0xf8ebfe41,0xf59af778,
0xf8f0f5c0,0xf2edf72e,0xf002efb1,0xf539f273,0xf648f2ef,0x0f9004e0,0x0c020e39,0x0ed20eb0,
0x1647112a,0x15f51785,0x0df4133b,0xfab505b7,0xed8af4f6,0xdaa2e338,0xd6cad686,0xd532d160,
0xe366dd89,0xde31e283,0xdf22dba1,0xf9bdee77,0x02c3fead,0x081d08d7,0x090a07d5,0x18160ede,
0x14971aac,0x0eae0f72,0x0ff00e14,0x10650e5d,0x182016bb,0x1c5b1a30,0x20cd2202,0x12b51c83,
0x00e4067a,0xf5d4fb80,0xf843f4d9,0xf6e5f870,0xef0ef23e,0xf5f0f0f5,0xee86efe9,0x06f4f946,
0x0cba0a90,0x0c590d2b,0x115f0e43,0x160115ec,0x147f16dd,0x04850ec3,0xf960fc9b,0xe277ed01,
0xd937dd2d,0xcfbbd2ee,0xdd1cd665,0xe24ee2e9,0xd87fdb14,0xed0de28f,0xfc9cf605,0x07410373,
0x04c30848,0x128a0708,0x185f17e6,0x0f8614d7,0x0f8a1038,0x0d3b0d75,0x154a12e7,0x1a1a167d,
0x22341cc1,0x1cc222fd,0x0b5b117e,0xfafb02df,0xf655f696,0xfab1f808,0xef68f60f,0xf6e8f14e,
0xec47f0fa,0xfa54f0f1,0x0988050f,0x0bbb0d13,0x0e9a0bed,0x14b211f5,0x19a915bc,0x0d211596,
0x024205f5,0xeceff8de,0xe007e654,0xd1acd859,0xd455d0f7,0xe3ebdfa7,0xd8f5de7d,0xe1b5daee,
0xf480eb97,0x0572f997,0x0407072d,0x087003ab,0x17f11296,0x13221741,0x1167128d,0x0cef0db2,
0x112a0f0b,0x15df1554,0x1e74179e,0x21f12484,0x16131bf1,0x04330c54,0xf660fcbd,0xfce2f64e,
0xf188f94c,0xf5c4f252,0xeda0f518,0xf0c1ed0d,0x03baf9e3,0x0c22093c,0x0c7009c7,0x100f0f4d,
0x193912ce,0x13b01988,0x0ab40d98,0xf85f01c1,0xe7a4f0ac,0xd933e14c,0xce46d001,0xe08ed7c8,
0xddd3e06a,0xdb4dd7ed,0xe87be261,0xfb88f185,0x04a704ec,0x017e02fb,0x13490a8a,0x158115c0,
0x13061612,0x0eba1074,0x0dec0c85,0x13471375,0x196c12ae,0x22762058,0x1ed321e3,0x0f5a15d7,
0xfa210714,0xfb80f79e,0xf4eefc5d,0xf575f2c6,0xf2daf6ca,0xed78ece4,0xf958efe3,0x096d0384,
0x0b35085f,0x0d2b0d39,0x15d30e36,0x170b19b5,0x106c1507,0x02da0b25,0xf09dfb15,0xe4e0eba0,
0xcf94d588,0xd832d095,0xdf48e075,0xd960dae8,0xdf95dc26,0xf056e691,0x03acfc5b,0xfe7002d2,
0x0b290464,0x14df10a3,0x14cc1725,0x11f0142c,0x0ca60c62,0x119c10fe,0x15320f63,0x1eee194e,
0x21532413,0x19fc1e6c,0x0469128c,0xfc70fb84,0xf979fd58,0xf515f3f1,0xf5bdf81a,0xee05f20e,
0xeff8eafa,0x030ff9d4,0x09040599,0x0a140c94,0x10310b44,0x178915db,0x14c71841,0x0e51112f,
0xfac301c5,0xeeb3f5d6,0xd628e309,0xd14dcf0b,0xde31da9e,0xdb1ddd28,0xdb60da25,0xe3aadde3,
0xfdcdf14b,0xfedc0042,0x03dc00c4,0x11800915,0x159613dd,0x15ca1714,0x0dee0e5e,0x0f050fc8,
0x0ffd1038,0x191d13da,0x20c1216d,0x21db2112,0x10d61d4d,0xff9b0471,0xfca80016,0xf610f737,
0xf87af6fd,0xf2faf6a8,0xeab3ebf2,0xf8c8f253,0x065a005e,0x099b0aaa,0x0c99097e,0x171d0f0f,
0x161217d3,0x157a1768,0x03760b50,0xf9cffda1,0xe3a7f088,0xd071d523,0xd9dbd3d3,0xdbaedd5b,
0xdc0edb46,0xd908d9bb,0xf2fbe5be,0xfe40fa4f,0xff41ff5d,0x0bad0279,0x11c30e66,0x17441956,
0x0fed1335,0x0ef20fa0,0x0e7f1014,0x14660e67,0x1d961b64,0x231a1fa7,0x1d37255c,0x077e0eee,
0x00a803cd,0xf7e8fb6b,0xf754f698,0xf70efa69,0xeb54f0b1,0xf025ed2a,0x0207f63b,0x092704cf,
0x07c909c8,0x129d0aa9,0x14e11490,0x1a0b1835,0x0b1113e3,0x00ed03f0,0xf0c1fce8,0xd592e350,
0xd4c0d149,0xd8e6da39,0xdeb7db48,0xd4a9d93b,0xe689da1b,0xfa47eed9,0xfb44fca2,0x03f3ff88,
0x0bf40768,0x1795148c,0x12f01682,0x101f0fcb,0x0db910b7,0x0f1d0c45,0x19d815a8,0x204219f2,
0x25b5264e,0x10321b0f,0x054d0afc,0xfb7f013a,0xf637f738,0xfa8bfa9a,0xf123f4fa,0xe9f6ecf7,
0xf6b2f0b8,0x06d5fe1b,0x05c408b8,0x0de2070a,0x11e2107e,0x1a641540,0x12a91a83,0x069f0a86,
0xfd800475,0xe23df3bf,0xd5cbd546,0xd5e8d602,0xdffed8d2,0xd671dbf3,0xd962d5b1,0xf143e424,
0xf902f711,0xff90fc94,0x06010131,0x138d0c7e,0x15ab183b,0x11a9118f,0x0ffc11f7,0x0c3f0b32,
0x1515113a,0x18c0162f,0x2650235c,0x1a53250f,0x0c8012d5,0x026307fa,0xf718f98e,0xf98ffa1e,
0xf780fa67,0xec06ef9a,0xeed8ec75,0x0190f3d8,0x04e50635,0x095904cc,0x0deb0d86,0x17271092,
0x180b1ca3,0x0bed12ce,0x07a9077a,0xf2ab01a6,0xdc2de017,0xd242d681,0xdc4bd629,0xdb75dd46,
0xd2abd649,0xe5b6d96a,0xf418ee68,0xfafcf99d,0x0049feae,0x0c8d03c7,0x1747146a,0x123d1379,
0x12ac148d,0x0aca0d6d,0x11480ed4,0x143e1291,0x235a1a80,0x24a726f0,0x12f01add,0x09a711da,
0xfbefffa8,0xf821f8cf,0xfc74fbf0,0xf0dcf483,0xea77edd9,0xf6c7ebd1,0x02d401bc,0x055d0300,
0x0a0b0b8c,0x12aa0b39,0x1aaf1867,0x12c1197c,0x0bdd09bc,0x00010cf3,0xe76bf11c,0xd477dcd1,
0xd6bcd3fb,0xde82dbde,0xd31cda4a,0xd9bcd38c,0xed52e3d3,0xf8a5f208,0xfe06fa6d,0x032bfcb6,
0x13d50d85,0x1221142c,0x1567159b,0x0c6f104a,0x0f720c87,0x10890f91,0x187d142e,0x28322533,
0x1b4e20a8,0x11cb18fa,0x03c5088f,0xf780fb06,0xfdd1fb42,0xf62df97f,0xebeff34c,0xeb9fe8b4,
0xfea3fa67,0x03a3ff4d,0x07ee0881,0x0d620764,0x175c117c,0x184d1da1,0x0e7e0dd2,0x0acf1037,
0xf5610057,0xdd25e84e,0xd292d5d7,0xdd99d795,0xd8dbdc6d,0xd2eed282,0xe38dd8f2,0xf10be9e0,
0xfac6f7d6,0xfaccf9e1,0x0db9046f,0x11e4101f,0x16b81481,0x0ead1411,0x0c710e16,0x100e0ec7,
0x10660dbd,0x25391d20,0x22752269,0x18321e82,0x0cf712c6,0xf9c60230,0xfc4afaf7,0xf986fc37,
0xf2f2f997,0xe77be8bd,0xf825f0df,0x009cf9cf,0x059d05b7,0x0946066a,0x11be0998,0x1b371bff,
0x110d1433,0x0fbf1190,0x01b20d00,0xec2ff74e,0xd5c2dd01,0xda07d403,0xdce3dc76,0xd1bed7a6,
0xd9ded316,0xe787e117,0xf976f14f,0xf6a6f72b,0x0510fcf2,0x0ce20b5f,0x163613a2,0x14501555,
0x0bc81042,0x11d50ee7,0x0bc20aaa,0x1da3148c,0x255a1ff3,0x1cf5232e,0x165d1b58,0x00fa0d5d,
0xfd3ffce0,0xfad2fb77,0xfb49fe80,0xe7f0eeb0,0xeff4ecb4,0xfc45f328,0x02d200a3,0x063e071e,
0x0a290466,0x198915d2,0x141c1957,0x13441203,0x0bfc1172,0xfb9c049c,0xddadebd7,0xd5b4d6eb,
0xdd86d9dd,0xd5aadc2a,0xd54dd13b,0xdcd3d7f3,0xf309e830,0xf2a0f67d,0xfed3f739,0x07510244,
0x12ab0eda,0x18de13f5,0x0ca412ed,0x13180f56,0x095c0baa,0x13cc0e69,0x21811ad6,0x20d224fa,
0x1ea11ee7,0x0b211886,0x014b0398,0xf904fbc5,0x0235004d,0xeee6f664,0xeb2decce,0xf4b0ee66,
0xfdf3faed,0x0503072a,0x04640294,0x15e10b9f,0x16c61950,0x152113fd,0x104713a6,0x089d0e7a,
0xed43fc37,0xd84adf26,0xdc20d5d0,0xd8b5deaf,0xd474d54a,0xd371d454,0xeaf8dccb,0xf02cf1fc,
0xf978f445,0x0214fa76,0x0bcd07e2,0x19ca1104,0x0eab15d9,0x12f51126,0x0ab30f5c,0x0d650ad0,
0x1b031263,0x212f2266,0x22d42046,0x155520e3,0x09ce0d28,0xf848fefa,0x037bfe74,0xf742fe38,
0xeac8f13b,0xee2eeccd,0xf9bdf1d9,0x053e00cc,0x00b00377,0x0dd30328,0x15dd1635,0x16cf15da,
0x12a2150b,0x120e113e,0xfda4094f,0xdf03f049,0xd974d7b9,0xda8ede32,0xd806d79a,0xce29d564,
0xe06ad241,0xecade837,0xf410f151,0xfcc3f436,0x016c014c,0x15a30b27,0x11581652,0x131a114b,
0x0deb1188,0x09c40b78,0x13510ae4,0x1ed01be2,0x254c1d28,0x1cc5244f,0x13a917b8,0xfc1d0791,
0xfff3fcfe,0xff8a02e9,0xf0c4f6b1,0xeb62ee0e,0xf18eec52,0x00ebf98e,0x00590584,0x05e5fd91,
0x133f0eb9,0x180113c8,0x12e91726,0x14081388,0x0b7611c9,0xeebb0260,0xda95df98,0xdb4ade85,
0xdcaad7bc,0xcff5d9fc,0xd6dbcdbb,0xe62ddd36,0xeee8eea1,0xf928f058,0xfb34fbcb,0x0ead01a3,
0x12f31447,0x13f71237,0x115c12fd,0x0b650f7b,0x0d0e0623,0x18461613,0x22ba1a2f,0x1fc9260a,
0x1cdf204c,0x07661309,0xfdeafe5d,0x03ea035c,0xf83bfe64,0xed54f3b9,0xec2cec16,0xfb59efa0,
0x03070300,0xff36fc8c,0x0c260880,0x166a10d0,0x14f817d5,0x141d14cf,0x13141428,0x028b117b,
0xe35cec96,0xdc07e120,0xde14d74f,0xd4ccddfb,0xd029d07d,0xdd56d2d6,0xe977e7d3,0xf365ec69,
0xf5f9f90e,0x03e8f94c,0x113a0dcc,0x14771162,0x128112a6,0x0f1a1443,0x087b060d,0x111410a6,
0x1e2114c7,0x222f21a1,0x21ba2243,0x13c41f1f,0xff2a0647,0x03550242,0x003e02e5,0xf431f8c7,
0xebe7eee6,0xf108e883,0x020bfe12,0xfd70fd6b,0x045b0206,0x11a20b13,0x156515e5,0x1542163f,
0x141f11dc,0x123a19d8,0xf0f4fde2,0xddf7ea64,0xdd58d99d,0xda89de33,0xcfc6d713,0xd432cd32,
0xe2b1deec,0xee4ae6c9,0xf4f0f476,0xfacbf288,0x0a9203cc,0x12f30f96,0x11d51174,0x13441754,
0x0932098b,0x0c8c0aaa,0x15b00f90,0x20121cf5,0x21aa2103,0x207c2634,0x082510c2,0x02a60297,
0x04940357,0xf99dffad,0xf0c3f652,0xe873e6ac,0xfc12f5d5,0xfd13fe01,0xfed1ff40,0x0bc5031f,
0x12fd10a4,0x17991711,0x112b1034,0x1a771b96,0x02ec0cd8,0xe6d4f70c,0xdcd1df6f,0xdd92dd4c,
0xd528dd31,0xcee8ccf5,0xdb82d5d9,0xe79adec8,0xf1eef006,0xf41df0a5,0x0080fa22,0x10eb0a50,
0x115f0d75,0x155d16d3,0x0b7e1044,0x093f09ff,0x0d430c58,0x1ce216b8,0x1f9e1bd6,0x27e82621,
0x13131d93,0x04220a1d,0x064e02f2,0xfed303f4,0xf8abfe8c,0xe62aec8e,0xf57ded09,0xfdc7f980,
0xfce6fef6,0x058dfda5,0x0d3a0a75,0x19ed164b,0x0fc210d3,0x1adf188c,0x110417e0,0xf5f60715,
0xe155ea37,0xdf39dcb8,0xdc51e087,0xce3ad274,0xd4b0d1a9,0xdec4d729,0xedceea2d,0xf2f2ee8e,
0xf6faf1c0,0x09a00396,0x0dd20bbb,0x15c014fe,0x103b15b9,0x0bb30c3e,0x090b08c5,0x17f9105b,
0x1a9d17ae,0x291b2197,0x1f232594,0x096415a3,0x06d00613,0x023604ef,0x01be03d0,0xeb13f5de,
0xedf1e982,0xfa70f2b0,0xfc25fe94,0x0171fb55,0x0526028b,0x17e1127a,0x0ff91339,0x1711146f,
0x19f61a6a,0x07cd12fe,0xeb51f9b8,0xdee7e140,0xe128e28a,0xd24ed98e,0xd200d1a4,0xd785cf88,
0xe6d9e007,0xefc5ed02,0xef04ee40,0x0040fa70,0x09e80684,0x14960dbf,0x12b91651,0x0f111053,
0x05c408e3,0x12dd0a1a,0x141012f7,0x224e1bb9,0x279126db,0x13621ff9,0x0a580c05,0x02a6057d,
0x07d005d4,0xf4cafff7,0xeadbed59,0xf578eab8,0xf955fb1a,0xff2ffd3b,0xfd87fcd2,0x12c20a66,
0x125d1336,0x1315114c,0x1b0f17b3,0x144f19b6,0xfb150b2a,0xe2caeaa1,0xe58de1fb,0xd8a7dd8d,
0xd11fd651,0xd103ceae,0xdcd1d606,0xec90e900,0xecbaebcb,0xf7fcf0f1,0x03e00052,0x1093070d,
0x13f8144e,0x13f812b5,0x053a0e15,0x0d7e0754,0x10050f4f,0x19fb14c5,0x2943213a,0x1dba279c,
0x115514f1,0x03a109a4,0x0a4904ae,0xffe606ae,0xec5af7b6,0xefb4e8f5,0xf556f4ad,0x0018fc6c,
0xf981fa69,0x0a2500dd,0x129410d1,0x1054116d,0x18061490,0x1b6b19cc,0x0f0216bc,0xeb09f9bc,
0xe65ae736,0xde3fe20c,0xd459dc1c,0xcfffd1bf,0xd39dcdd9,0xe6bddff7,0xea73eab2,0xf132eafc,
0xfce3f857,0x08880046,0x10d910f0,0x170612c6,0x09cf138a,0x098f06c8,0x0dad0c37,0x11c60ff5,
0x243f1860,0x25de287d,0x1a391d74,0x074011fd,0x07fc05f7,0x091d091e,0xf49b031b,0xee73eccb,
0xf03eee2f,0xfdfcf907,0xf883fd2d,0x0052fa5d,0x112509fd,0x10dd0fe2,0x153810eb,0x192b16d7,
0x1c481d95,0xf9860c66,0xe92ff13b,0xe436e5ba,0xd98ee06c,0xd2d9d7e9,0xcd85ccfd,0xdf50d444,
0xe883e6b8,0xeb38e7f2,0xf5baf2cd,0x0132f8df,0x0bfd0a06,0x16981025,0x10bd176c,0x081a0ac4,
0x0d240965,0x0d5b0d0e,0x1abd0f6e,0x25a524ba,0x224c2521,0x10a51a7f,0x06350aa6,0x0e0c0703,
0xff0a0b71,0xf12ef6f1,0xeaffed66,0xf959f38a,0xfcf3fcd4,0xf9adf6a2,0x0a9700d6,0x0e650ec8,
0x1359100a,0x1359130d,0x21ce1c58,0x0c91196f,0xf057fefd,0xe940eb46,0xdfa6e33b,0xd86adcc8,
0xcbfed1e6,0xd43acc92,0xe53adfa7,0xe757e490,0xef66eddd,0xf93bf20c,0x04df01be,0x12590a36,
0x16511601,0x0a1f1004,0x0aad07d2,0x09ff0d17,0x115d0969,0x20341a32,0x272f25ae,0x1b1f2055,
0x071f1481,0x0c4505dc,0x07640f39,0xfa1801cd,0xec6cefbd,0xf33fec18,0xfdc6f922,0xf62df98e,
0x0279f868,0x0a4f09db,0x137f0e36,0x0e4c1032,0x1e021758,0x1c271f69,0xfe8f0e22,0xee9bf3e0,
0xe37de8cd,0xde54e122,0xd111d8c3,0xcb8aca64,0xde60d625,0xe35de0d3,0xeacfea00,0xf2faec22,
0xfe49f8a1,0x0a0e02b9,0x166c11f9,0x0f081596,0x0a1d08ca,0x0a2f0c9c,0x0c1d073c,0x17120f45,
0x248a2286,0x23a724d3,0x0ffa1f5e,0x0c09079b,0x0d400d15,0x043c0a92,0xf148fa1a,0xed7bebe4,
0xfb08f2ec,0xf75afd42,0xfbe9f436,0x03a40305,0x125b0b8b,0x0da50f16,0x16c910c8,0x220b1e04,
0x0eb61c67,0xf7f600f2,0xe92ff016,0xe299e566,0xd9a9e0f3,0xc96acf72,0xd62dcec3,0xe078da88,
0xe7c8e53a,0xec71e94e,0xf7b8f262,0x019ffb96,0x12dc08e0,0x14091753,0x0c070c35,0x095c0c56,
0x085d0a51,0x0d5d08a1,0x1dc11a96,0x28d72135,0x1a6026b9,0x0c9c1007,0x0d5e0b6a,0x0c960e4b,
0xfb2e0532,0xec43f210,0xf516ec5b,0xf84ffe41,0xfa10f4a2,0xfd51fb0a,0x0d8d05a7,0x0e120f5d,
0x0fc40d5c,0x1fed1683,0x1bda226b,0x03b51025,0xf10ffabf,0xe5a8e9f5,0xe312e63b,0xce42d723,
0xce0ccc96,0xd9ddd39b,0xe3c1e008,0xe85de612,0xf237eb1f,0xf9d2f579,0x0987fd89,0x133315cf,
0x0f8d11a7,0x097d0cd5,0x0a810cc0,0x08750402,0x1472125b,0x26201a07,0x246929f3,0x13251a21,
0x0bb60d9e,0x106d0e3e,0x05b20d89,0xf17afef0,0xf145e894,0xf7f9f953,0xf9a0f6e1,0xf820f83e,
0x0683fd86,0x0e7f0c68,0x0b9e0d91,0x17af0ece,0x21e320de,0x119e1bbe,0xfd95071d,0xe917f0ee,
0xe8e8eb15,0xd76de102,0xccb1d040,0xd339cd4b,0xdfd0d8a4,0xe62be22d,0xeb19e589,0xf253f3aa,
0xfe9ef42d,0x0ffa0ce9,0x1426124f,0x0a1d0dba,0x0c1f0ef6,0x05f8042b,0x0d200b8c,0x1c540fd7,
0x281726d8,0x1ba222ea,0x0c4714c9,0x11210ce5,0x0e780e4b,0xfc3e0c57,0xee86ed6d,0xf5b4f3fb,
0xf9f4f62f,0xf5f5f90e,0xfdaef760,0x0bc605d2,0x0bbb0e4f,0x0f0909b5,0x210718c7,0x1a53213f,
0x0afc1612,0xf0d0fc89,0xede5edde,0xe2e4e848,0xd1aed7d0,0xcde8cc95,0xd7a4d228,0xe281e03f,
0xe5f8e137,0xef4df003,0xf59fed14,0x0708011c,0x15c410ac,0x0cbb0efd,0x0e9e105a,0x062b0713,
0x08f3096b,0x0f7308dd,0x25441e8a,0x259125bb,0x11ec1ce6,0x0fbd108a,0x11b00c96,0x0add1546,
0xf1c8f920,0xf2d7f242,0xf85bf471,0xf7e1fb1c,0xf7c4f555,0x0595fd59,0x0d170cb3,0x079d0a6c,
0x1ae31043,0x1e111f63,0x19891f31,0xfe0809f4,0xf17af341,0xeab3ee78,0xd87ee3b5,0xcebbd24d,
0xd00fcc37,0xdf53db23,0xe121dc5e,0xeb59ec5f,0xf079ea2d,0xfb66f471,0x12df097a,0x0dbc0ffe,
0x10be1212,0x07350b02,0x098e0a14,0x0787040c,0x1a42130c,0x29b7238e,0x1adf22e1,0x11ac16c9,
0x0ea40afb,0x155f1787,0xface07be,0xf277f567,0xf5bcf0fb,0xf9cbf98e,0xf3e8f7c4,0xfbc4f7ff,
0x0d3605e1,0x058d0be3,0x137d0894,0x1c4017c7,0x223f2066,0x0b4d18cb,0xf652ff4e,0xf1e0f1ac,
0xe1b5ecc2,0xd571db3d,0xc983cc10,0xdaebd5ca,0xdd8ed71c,0xe78ee608,0xed87e846,0xeeb7ece8,
0x0a67fde6,0x0cb20d9e,0x13e910bb,0x08360d3c,0x0a530ca8,0x052503ea,0x0e15086e,0x264f1a1b,
0x216f25db,0x18ae1f31,0x0b6d0db5,0x1a2313c9,0x08a21319,0xf6bbfefd,0xf1bff21f,0xf979f7fb,
0xf6cbf9de,0xf510f5e3,0x0a3afb34,0x06cf0b73,0x0bf90601,0x1511110d,0x23831c8d,0x1a20211b,
0xff8d0e3c,0xf6c0f730,0xe9bff3f2,0xe0fbe537,0xc9afd0ac,0xd54fd108,0xd8e3d34e,0xe1e2e049,
0xeb7ee6c3,0xe7fcea0b,0xffb6eff2,0x079a07f6,0x15290eba,0x0b2e0ed2,0x0c1a0de1,0x06050736,
0x04020470,0x1c630de4,0x23c721ca,0x224e2353,0x0b191505,0x164e0f98,0x126218a2,0x00300b3f,
0xf0e1f6d1,0xf761f4f5,0xfb3df791,0xf10ef7e6,0x007bf386,0x06f50837,0x08e5054c,0x0d710a78,
0x1d2e157c,0x227621cc,0x0c5a1d52,0xfe56ff5a,0xefb0f7a3,0xeb65ef4a,0xcf68db20,0xd0b0d0c3,
0xd4bfd02d,0xdcb8d963,0xe866e1d9,0xe43deb20,0xf48fe603,0x0028fcf8,0x11bc0a0a,0x0d7b0fdf,
0x0d270e6c,0x099e0ad1,0x017f04d4,0x107a02c9,0x1def1945,0x26fc2558,0x111f20b7,0x12360e56,
0x1759178e,0x0e911507,0xf69cffe1,0xf423f5f4,0xfbfff5b4,0xf40bfca0,0xf83eef22,0x03ca0227,
0x080a05b9,0x07cb07e2,0x153a0e87,0x24b31a11,0x1906269c,0x08210ccb,0xf415fde5,0xf54af6c6,
0xdb52e718,0xd113d578,0xd0dbcf76,0xd71cd5c1,0xe581da1c,0xe394eaf9,0xeb33e32c,0xf68ff1ef,
0x0bd801dd,0x0fc90dab,0x0e6a0e40,0x0d4e0c64,0x025509e4,0x05e6ffad,0x13780ed6,0x27231ed5,
0x1c2d281c,0x11871138,0x14c3136d,0x184b1a16,0x01390c27,0xf4edfa83,0xf954f1ab,0xf845ff6f,
0xf2c6f066,0xfe24fa2f,0x07f50203,0x051b05d0,0x0bee0a46,0x1e240fc5,0x2085276c,0x14ce194b,
0xfa790631,0xfa8efab2,0xe6f1f392,0xd756de1a,0xcf65cfc8,0xd188d41f,0xde8bd279,0xe36fe805,
0xe6e7e251,0xee45e7ed,0x02cbf511,0x0ccc0826,0x0d580f36,0x0e8e0cad,0x06510efd,0x01a900dc,
0x097105c1,0x200110fe,0x236d2992,0x15ab19f0,0x11271053,0x1c1e17c2,0x0d1e15fe,0xfa0405f2,
0xf521f18e,0xfce4fe4b,0xf38af3e4,0xf67ff4fe,0x0453fe0e,0x051503a7,0x06700938,0x14b20656,
0x210e1fc8,0x1f06220d,0x04fc1371,0xff36fd93,0xf180fc06,0xe0aceae0,0xd178d4f8,0xcf6ed4aa,
0xd6b6cc8b,0xe36de039,0xe515e123,0xe657e47c,0xf62beb14,0x0655ffc2,0x0c8c0d7e,0x0e870b32,
0x0c8510fa,0x01ba04a5,0x01ec0461,0x13bf03b0,0x25462189,0x1c852222,0x0e361453,0x19e7140f,
0x1698191b,0x06441247,0xf38bf5f5,0xfc82fb6e,0xf70df8db,0xf1dcf370,0xfefcf8db,0x0441fe38,
0x03b809c1,0x0a6801b2,0x1b78140e,0x24e620a9,0x10612056,0x023c067c,0xf9b600c6,0xecddf716,
0xd8fedcd7,0xd21ad6b7,0xcf21cb26,0xdeb1d7fb,0xe31ae051,0xe254e489,0xeaace522,0xfe35f3c5,
0x0a4307a8,0x0b7f0a6d,0x11461109,0x05fe085e,0x01130626,0x04eafcb2,0x1db914d7,0x241b2437,
0x11ad1aa9,0x16401103,0x18771738,0x14241caa,0xf8170191,0xfaa2f96e,0xfc8dfb4d,0xf182f537,
0xf919f711,0x01baf8c4,0x05af07ce,0x03260185,0x110c0b81,0x235f197d,0x1bcd2808,0x0af21297,
0x00bc0256,0xf8b3ffdb,0xe107e945,0xd7a3dd88,0xcbb6ceeb,0xd71ad145,0xe177dc38,0xe28ae300,
0xe2f4e333,0xf2e6e8ee,0x0752fdea,0x087406ae,0x11d70f7e,0x09940cf3,0x05220ae4,0xfdadfd11,
0x118e0581,0x261e1d53,0x177922ca,0x14c713c5,0x159d1278,0x1ec21edf,0x03891013,0xf802fc00,
0xff21fc81,0xf5c1f747,0xf527f5fd,0xf9cff543,0x0589045b,0x009b031b,0x078e05e7,0x1c3f0d5e,
0x237b24e9,0x15a61de2,0x046608e3,0x0263054d,0xead3f63d,0xe02de61c,0xcf0dd5a4,0xcfc4ce18,
0xdc07d6af,0xe319e08e,0xe23fe1ed,0xe64ee10f,0xfe98f35f,0x03a101b3,0x10320b71,0x0cbe0d36,
0x0a510d9b,0xfce002d4,0x0229fd7c,0x1f8d0ffc,0x1dcb2415,0x1725199b,0x10571018,0x200e1ad3,
0x137a1bf2,0xfb5c033b,0xfed2fcdb,0xf8c1fb0c,0xf541f92c,0xf3baf3eb,0x03e6fdc9,0x0346020f,
0x01f90405,0x10440462,0x22bc1b8b,0x1feb24ea,0x09f913d7,0x0962087a,0xf5c50114,0xe8b6f076,
0xd73ae05f,0xce9acfaf,0xd5a5d006,0xe019dc43,0xe2f9e32b,0xde0edffa,0xf508e80c,0xfde3fa00,
0x0bd2068a,0x0c8b0ce5,0x0ead0f7f,0x03b30943,0xf958fdab,0x12b3018a,0x1ee21ddd,0x1d842004,
0x1085113f,0x1a211340,0x1eef219b,0x038a10ba,0xfe87006c,0xfa9ffdb2,0xfa5dfbd3,0xf175f3a5,
0xfdc8f876,0x044cff87,0x011604e9,0x05a10021,0x1a2f0ed2,0x26782361,0x11991eb3,0x0c5f0e93,
0x0183087a,0xf276f894,0xe0e4ebb5,0xd100d829,0xcfffce6a,0xdad7d53c,0xe50de060,0xdbb3e0b8,
0xe965dfe0,0xf5fcf15a,0x06a3fea8,0x0a9b096a,0x0f8d0e6e,0x0b510e05,0xf8f7050d,0x05eef846,
0x1a3a0e78,0x20c720f0,0x1304197f,0x11490f44,0x22ed1e45,0x10281c86,0x02e806ec,0xfb46fed9,
0xfe62fe51,0xf2abf6dd,0xf766f557,0x0199fabc,0x033604dd,0xffdf001c,0x0c2a04f1,0x261c1ad0,
0x1ceb23c5,0x10ee1499,0x091a0e9d,0xfb90024e,0xed80f58d,0xd9e1e2bd,0xcff1d1ec,0xd2f5cff7,
0xe373dbee,0xdd98e310,0xe12ddcb5,0xecc8e84f,0xfe5df676,0x07a5046f,0x0dbe0b28,0x12a80d72,
0x00490c39,0xfb7af983,0x0de5010b,0x1e901a8b,0x1aa5210d,0x0ce81033,0x1fb31514,0x1a7722c2,
0x0bb811fd,0xfd090298,0x0108ffbf,0xf816fb46,0xf490f508,0xfb5ef61d,0x0410028d,0x01890139,
0x00c4fe22,0x1bc00d20,0x21e62412,0x160a1c36,0x0f5712ee,0x03e408d4,0xf7d8fd35,0xe354ef4a,
0xd4dedaae,0xcccbcf2c,0xddcad3ee,0xdf18e307,0xdcedde42,0xe4a9e15d,0xf679ec1a,0x0445fa7e,
0x07810808,0x13340b7e,0x098211ab,0xf9810214,0x01eff8cf,0x16c10c21,0x213e2073,0x0d191828,
0x18550d0e,0x1e661fca,0x168b1b67,0x018709bb,0x00a300d2,0xfbc7ffd4,0xf597f948,0xf766f1f7,
0xffe9fcf1,0x03a90417,0xfb7fff41,0x0dc700aa,0x22d61ba2,0x1ca02073,0x15001836,0x0a280ffe,
0x01490469,0xee7bfac6,0xdde9e6d4,0xcc5ed634,0xd5a0cddc,0xe05cdea9,0xdf58de5b,0xdf36dc29,
0xeb27e513,0xfd82f0d2,0x01ec03a4,0x0ece06f1,0x11a31185,0xffbe0b72,0xf9e6f977,0x0907ffc2,
0x21d616b8,0x130820fa,0x11fe0b57,0x1b77186f,0x1e642088,0x0a051516,0x032b03f7,0x0017ffec,
0xf803ff27,0xf4a0f406,0xfa42f781,0x05d200b9,0xfd080252,0x0031fa06,0x1b410dfd,0x1ffb2012,
0x1b2f1b6f,0x0eac163a,0x07250b02,0xf876045e,0xea4ff1e1,0xd4e3dfa5,0xcf8ecb86,0xdc83d6c2,
0xe030dfbd,0xdd25dbbf,0xe11fe133,0xf4d7e74f,0xfdfffc00,0x0678027a,0x132d0d50,0x09d21263,
0xfa89ffef,0xfc3bf9c9,0x19c5061c,0x19ab23df,0x0f641189,0x15fe10de,0x22831c36,0x13831e05,
0x062e0d16,0x01f60144,0xfd7c0313,0xf6abf776,0xf5a1f476,0x032bfa7c,0x024904ec,0xf9f0fa87,
0x0e65ffbc,0x1dab1af3,0x1de11e14,0x13a71e1a,0x0e251049,0x034b0a01,0xf639fab6,0xe070ed7e,
0xcf3dd35a,0xd572cf85,0xdf84dec6,0xdf3fdbbd,0xdb5cdf6f,0xe9c6dfd3,0xf921f294,0xffcbfd7c,
0x0df0053d,0x11de13ee,0x016a084f,0xf4a8fde3,0x0a8df7b6,0x1e9c1a9f,0x131f1778,0x0d8c0fb6,
0x1f3915b7,0x1c522067,0x0d9716f5,0x0399047f,0x0157050c,0xfaabfd4d,0xf442f5b9,0xfd12f398,
0x04450361,0xf90d01bb,0xffc6f829,0x171c102a,0x1f611a94,0x1a9b206d,0x12921479,0x0a07100b,
0xff9f01ce,0xecdef9e3,0xd70ce11c,0xcf58cce8,0xdba0da0b,0xe003db4b,0xdb73dfc3,0xe052da7b,
0xf125e842,0xfb35f793,0x0356fdad,0x13be108c,0x0bbc0d50,0xf92805d1,0xf9e8f0af,0x16d10d59,
0x199d1ae6,0x0ae9135e,0x18120f26,0x1f4b1ca9,0x16fc1fb3,0x07e50ba1,0x04ca0598,0x0036004b,
0xf4aefb4d,0xf4daf2e2,0x0204fd9f,0xff470685,0xf7f2f606,0x0c73032e,0x1b541353,0x1f3f206e,
0x16e2188c,0x0f731602,0x07c307a1,0xf9000261,0xe44ef1ee,0xcf8ed32d,0xd732d47b,0xde5ed90b,
0xde87e108,0xda21da74,0xe614e164,0xf88ff0b5,0xfb4cf5d0,0x0ecc0809,0x0fea0f2f,0x044010ee,
0xf221f3ca,0x08c7fdf1,0x1c9814d3,0x0dee1927,0x115c0cb6,0x1d111413,0x1f902154,0x0dff14f7,
0x06050a88,0x03b8039c,0xf9f0021e,0xf3c9f522,0xfc7df4f7,0x056b06df,0xf732fb06,0x0248faa5,
0x12ed090f,0x200c1d56,0x1b521aee,0x13321bd9,0x0d2d0ec5,0x027706f3,0xf3cfffef,0xd62ae0dd,
0xd338d3c5,0xd8fdd53f,0xe070e0bb,0xdc39db84,0xdd4fd975,0xf15be884,0xf31ff20b,0x074cfe60,
0x0e640938,0x107816f4,0xf4b0ff34,0xf990f60b,0x1816075d,0x15d419ac,0x0eac0e63,0x14260d79,
0x21a71e8c,0x15e21ce6,0x0a1d1176,0x061e0526,0xffa6063c,0xf5dffc22,0xf464f117,0x06df00f5,
0xfa3c014b,0xfbebf8f2,0x06ebfdba,0x1b5b16c3,0x1e7e1a1c,0x18491e2e,0x12e0151f,0x07bb0a9a,
0x020209ad,0xe2ebf31a,0xd695da8e,0xd5b5d08b,0xdefddd1b,0xdf56df96,0xd725d99a,0xeac4df92,
0xec93ecf9,0xfeebf712,0x06800096,0x1762150f,0x01630b81,0xf234f6b8,0x0a5bf896,0x16e3153c,
0x0ff2151c,0x0c520b34,0x1e751760,0x1c5d1eb6,0x0f4418e3,0x08320936,0x048206da,0xfb280250,
0xf148f230,0x0461fa99,0xfd75029d,0xf9eefd73,0x018cf70a,0x14120eb9,0x1e7f18b8,0x1af31d28,
0x14211a2e,0x0a2b0d8d,0x09200d7b,0xed4cf992,0xd751e363,0xd557d1e6,0xdcd5d90f,0xe0fce0f1,
0xd606d7cd,0xe6a0df98,0xeb90e5b9,0xf71df7af,0x067cfa64,0x151b1349,0x00330edb,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_piano_kpianocx4[10880] = {
0x00000000,0xff8eff67,0xfffcffc1,0x0236007a,0xff8b0282,0x0197feda,0x03b801a6,0x0435050d,
0x032905bb,0x0011fe2a,0x0a1a0451,0x00e4079f,0x0abb03d8,0x0ad60cb3,0x0a3205d4,0x13191386,
0x05b10b95,0x0f3908f2,0xfbcb07a3,0x1169fdca,0xfd67097a,0xe478f9b7,0x0de70002,0xef6cec13,
0x16b60b19,0x09af18a6,0xfefff3c7,0xb860e4f4,0xaacbada8,0xbeaabc91,0xd5ffb875,0xf7d2f778,
0x03c6067c,0xef34dbeb,0xfbb9087b,0x17fc05ff,0x04f7182d,0xf448e704,0x2f7a1a04,0x0c501f01,
0x0be8055c,0x0a8b0bbc,0xfad90459,0x0d7e0bb9,0xefa5fbbe,0x00d2fa7d,0xda84d94c,0xf4c8dc9b,
0xfaec1741,0x1ec00679,0x188e072a,0x1d4f374e,0x13780af0,0x2bb40f55,0x229f2e7b,0x22d82aff,
0x3fb428f4,0x178e3612,0xc3c8f959,0x9ca3b25b,0xae1f8245,0xd251e02a,0xf9c9e2e5,0xf67bf7a7,
0xdf99eaf3,0x0fd1ee40,0x2b08282c,0x23e62813,0x1e821e74,0x22231db8,0x2a6a3084,0xfa3d181d,
0x04120074,0xf050e865,0xfa4ef4c4,0xf98415d2,0xfaa8ecc6,0xe432e0fc,0xc5c6eefd,0xfd2dcd86,
0xcb01e99c,0xf132c64f,0x1ba8298e,0x06d2ed84,0x339926f1,0x1c082cf1,0x3ec42e2f,0x3086234a,
0x3dcc4ffd,0x1d353ac0,0xb303d6cb,0xc65cc17d,0xb95abb6c,0xd9c4c7fe,0xdc8be514,0xc1c3c13d,
0xcf57c9f8,0xe7d9d709,0x15b70edc,0xf96a0f53,0x18eae7ec,0x1b553025,0x22e924f4,0x2f2f21f9,
0x01371008,0x1e0f2904,0x374f29e9,0x1bf71570,0x1568315b,0xdeb3eda4,0x07f6eb2b,0xb07ee304,
0xf2bfc908,0x102a0b7f,0x0ae0f348,0x0dd9258d,0x1e9409fd,0x21491bb2,0x156026bb,0x5569269f,
0x37746146,0xf7180c84,0xc54ed8ec,0xb271b010,0xcc78c475,0xc6acd602,0xc02cbf27,0xba99abb8,
0xc95ec456,0x06c4f80b,0x06f4f447,0x07ca0629,0x23952f9f,0x4bb330c1,0x2b02334b,0x1c6b3bec,
0x285813bc,0x2dc42f77,0x23721c57,0x274c469a,0xec6af09d,0xf270f02c,0xb628e5dd,0xde4fbb0e,
0xef55df2d,0xfe4c0757,0x12b9ff25,0x0274169e,0x1a840bb2,0x08fe0e87,0x334313b1,0x4e744ffe,
0x150c3c40,0xeebff5de,0xc2a2cc79,0xbe5cc3cb,0xe677ddfc,0xdab3c79b,0xb849cca9,0xd130c8d5,
0x09d3e353,0xfb9efd1f,0x01161506,0x2b670b32,0x214a266c,0x2c452596,0x10b53250,0x29b604d9,
0x03b91e39,0x2c6f14b8,0x35bf405d,0xf418fbe7,0xf40b0bb2,0xc7dbd347,0xc54fccf9,0xec33d98c,
0xfa42e8e9,0x069f0a10,0x0bfb0564,0x158522de,0xfd8302af,0x1088fc87,0x362c3775,0x39904016,
0x014f071b,0xc6fae8ff,0xd1edd222,0xe70aca45,0xe24ae859,0xb4a0e092,0xd2b4a875,0xdeaad873,
0x00d9f3f9,0xff920c07,0x22970354,0x149f19a1,0x2fb7347e,0x141a128c,0x17f00fb2,0xedc30892,
0x2df9fd3e,0x0fa934d1,0x11ca0749,0xf749ff09,0xd02be917,0xcbddc7e9,0xd74ad5ae,0x0cace8b6,
0xfe740c39,0x19b614bf,0x347e3141,0x115112e4,0xfe9a1255,0x3e13223b,0x48313a28,0x05da2efa,
0xdca4fd73,0xcfc6c763,0xbfd8bfba,0xe72be5dc,0xc14cd82a,0xc210b6b6,0xcaf7c316,0xf1cdf3a7,
0x0bcdef72,0x05d31122,0x1abe0777,0x33e22f39,0x11e21bbd,0x30f12e12,0xe3d4f53b,0x19210245,
0x1b2a1fca,0x0a260c0b,0x150e0970,0xd57cf32e,0xd334e06d,0xd094c8a4,0xfcc4d58b,0xfaf01661,
0x246b05cd,0x4302287d,0x1d173b4f,0x1a5b1f44,0x3e0f18ba,0x50784846,0x3a255c46,0x094e1468,
0xe007f375,0xc60acade,0xe67ae86c,0xe1e1dddc,0xab9cc951,0xd3f6bc18,0xd21ed5fe,0xfcf1e9ea,
0xf7ff0bfa,0x11f2e730,0x1c6c3978,0x23a109ea,0x30863994,0xfc2b0aad,0x0ee0fcb9,0x20e333d5,
0x21f60d5a,0x1dee208a,0xf89819fa,0xf303f501,0xccb1c9ee,0xde9ee021,0xffe2fa74,0x03afee9f,
0x248f12f2,0x2069362e,0x0b7904a2,0x0b150172,0x354f2129,0x347f477f,0x21391eb4,0xdb4a0003,
0xd627d705,0xd010c5ee,0xdf78eb1b,0xb116c4a6,0xc240adf8,0xaf39c6ae,0xfd17d021,0xdc61f402,
0x0b60e34d,0x05101424,0x177b115f,0x3f0924fe,0xf5de1eb3,0x094f022a,0x26051c92,0x1bb71039,
0x18f332b8,0x22fc2093,0xfc7407d0,0xd11fe8f1,0xdcaadc5c,0xfaa0e229,0xeceff1bf,0x1e8004a4,
0x2db8342c,0x179e1bae,0xfba30040,0x2e11187d,0x35c72817,0x29f44231,0xfcc80ae0,0xd054e3d4,
0xcc43cca2,0xe92ee7d1,0xbd96c51d,0xbffac4c2,0xab78a71e,0xe61adacc,0xe1ead02c,0xf198e828,
0xff1a0b3a,0x16c7f303,0x2deb22f9,0xfe1729e9,0x137b00f7,0x0f2305b2,0x1aba20f4,0x1e612555,
0x34971efa,0x0b7928bb,0xec0b00b1,0xe285e71e,0xf2f0e691,0xed8ef10a,0x0fbefe7e,0x3a101d55,
0x16e33d8c,0x16a801f0,0x153d1a19,0x35f92872,0x446046c8,0x20d62ca6,0xe2f109cf,0xdf14d2c9,
0xe001f5c8,0xef87cfa7,0xafe6e1cd,0xc078b184,0xe430c991,0xce70d19b,0xf283ed4e,0xfef5fa28,
0x0528e8f5,0x20952929,0x18791d14,0x0b44080e,0x021bffc4,0x17531864,0x162e1401,0x2acd1e65,
0x1f592c62,0xf6d81251,0xe7cde23f,0xda1ee98f,0xf24cdcea,0xe8b0e577,0x34791a12,0x292b3407,
0x1d301b83,0x18921f3a,0x3a212810,0x43b046b4,0x555a4979,0xe7c325e3,0xfac8f7bf,0xdc48dba3,
0xe598df4b,0xbe62ec8d,0xb58e9ff5,0xc35cb953,0xaac4c1db,0xe8f7c491,0xd8cce160,0xeb4cd5a6,
0x11420d7e,0x14330d33,0x00460d4f,0xfb68f7ea,0x0aaf0a04,0x10ca08af,0x1a2e1549,0x41a92c74,
0x022f213e,0xf387023c,0xe9f9e26b,0xdeabe5d1,0xdeced7f3,0x1a4efe17,0x2b4026c4,0x253727c7,
0x0832133b,0x2fe530d6,0x42ec1a39,0x5106665d,0x185f3ad4,0x0b5e08c1,0xda10e9c6,0xef40efe2,
0xe359f408,0xb973b809,0xcdadcd0b,0xb43abf55,0xe4e0c471,0xd73fe55e,0xe323d863,0x066dfa51,
0x1ab21440,0x04b4145e,0x07eaffd1,0xff0efe58,0x0c0f163b,0x19d4008e,0x318b299c,0x28eb3591,
0xf9770d8c,0xfd1ff411,0xdc67ec3b,0xd30dd0a9,0xfcaef25e,0x2d95faaf,0x0cb0397d,0x20991064,
0x166a17be,0x2d561442,0x52f15afb,0x3e03450f,0x109d23c5,0xe583fd7c,0xf789e827,0xe916f8a9,
0xc2fbcad9,0xca5dce11,0xb10dbb20,0xce51bd32,0xd55cd709,0xd2c4d138,0xe9dfd7d8,0x09670e5b,
0x0c89ff4d,0xefc603c0,0x0125fa0b,0xfad6fef6,0x0804fdd6,0x218d0da5,0x2e1037ea,0x038f1a49,
0x0f59f3cc,0xcea802c0,0xe4bbd72d,0xdd44cac1,0x143cfe22,0x12b621e0,0x29fd1662,0x0426159b,
0x2439121a,0x4aed3995,0x4d72499a,0x2b4e42c8,0xee4606bf,0x0045f12d,0xe99afdf2,0xdc09db29,
0xc9d5d5aa,0xb4d8baf9,0xbeb0c196,0xde4cc26c,0xc0dfd8a6,0xe34dd062,0x03d6f240,0x0bac0e74,
0xfda9ffda,0xfe51081b,0x05dafeb7,0x06bafde1,0x0cfd0dd2,0x4cb33d8b,0x16781b87,0x14d122aa,
0xffc90ec4,0xe90ef303,0xdae3d4ca,0x09d502ed,0x22010fb3,0x310a2e3b,0x12cb22c9,0x23e21439,
0x404133aa,0x5a604a0b,0x516e6241,0x04761fec,0x0ca906db,0xf23d0752,0xf41de4b2,0xca78e4c2,
0xc5e0cd7b,0xba77b2bb,0xcfbdc9dd,0xc83fcc49,0xc86dcc27,0xfe3fdb1c,0x041affd9,0xf6c4096f,
0x06910166,0x02ebef02,0xe78409b4,0x13f6ee89,0x28fe22e5,0x20ab21ec,0x0c3a239b,0x15a209e6,
0xddcc0288,0xd79ccfae,0xee21ea5c,0x09a7f5f5,0x2cc523a4,0x129f23fb,0x197f0c11,0x21042708,
0x4f392f5d,0x61286230,0x0b8c343c,0x13ce1300,0xf963fda3,0xea8af3df,0xe3cee786,0xbdefd81f,
0xc53ab49c,0xc169be20,0xc508d40c,0xcae5c50c,0xe727c370,0xf5b1035a,0x11030046,0xf5d6f66e,
0x0cc707a1,0xe308fddf,0x0baeeb39,0x10c00e8f,0x2b12237c,0x0a981968,0x1e881372,0xee7e0f2b,
0xd887d8f4,0xdf02ddf3,0xf1ece554,0x29841379,0x16a61f81,0x176915c6,0x159c2119,0x4369153c,
0x5d73654f,0x36ea4d2e,0x13c22413,0x148f1111,0xed1cf974,0xf2fc0282,0xd9d9e522,0xbfcfbd88,
0xbf0ace8d,0xd63cc88d,0xbd87bccd,0xd10cd044,0xf4e2dd46,0x06090807,0xf386ec0e,0x120f12b2,
0xe984f5f0,0xfb2ff30a,0x0d9afdec,0x28ff2067,0x124d1cc1,0x23241c6b,0x0a821f41,0xe4a7ebe5,
0xd876e5fd,0xe47dd624,0x1ca9fb02,0x0dab1c9c,0x244f1ad2,0x034314d4,0x32990ad8,0x5349447b,
0x46e464d8,0x2f282d01,0x11341f54,0xf35e0d99,0x09affa68,0xdf01ef68,0xc05edaaa,0xce09bddf,
0xc71acf9e,0xc600bf1e,0xb93cc821,0xecaec512,0xf09400bf,0xf8c9e5ff,0x05820666,0xf812fd29,
0xe46bf179,0x0701eb29,0x17d514b8,0x0fa5176f,0x28e01ca7,0x15c21e28,0xf69609d9,0xdef3f205,
0xdb65cb8c,0x0ba7f712,0x0f5c032b,0x26262ee4,0x12a4104a,0x129608ab,0x4bc53d4d,0x5e9d5489,
0x39d74432,0x1fb23c09,0x0fb30f61,0xff330476,0xfd8f035f,0xc664e4b0,0xd445c735,0xbf72cd8d,
0xd1e2c7ef,0xacc2bd2e,0xdfc2c13b,0xe6ddeccb,0xf867ea62,0xfd76f956,0x071b0cc1,0xe7dbf670,
0xff77e2d0,0x0f2e17cf,0x151811bb,0x2aac1d12,0x1c3d2659,0x186217c8,0xe0ea0cab,0xe865cb59,
0xe6bbedf2,0x0897fc8f,0x2cc215d6,0x07131b4e,0x025a080c,0x3eae18b0,0x45ec43a0,0x4f6c50fc,
0x28dc3b6f,0x16672268,0x03000488,0x0a260fec,0xda23e985,0xcf52db58,0xc8f3c222,0xceadd4f6,
0xab7fb3df,0xcae7c0f3,0xe0f1d015,0xeb53e4c9,0xee43ef70,0x0f7d073b,0xe509fb9b,0xef70de7c,
0x09e207c2,0x04a3046e,0x308415cc,0x0c021de0,0x30b42c79,0xf9dc0db4,0xdcb7e42b,0xe384ed6a,
0xfc8ce186,0x1ed50c83,0x17a529ea,0xfdb6fce0,0x23c315a1,0x3de72da2,0x520850f1,0x415845c7,
0x1989361a,0x15e50b20,0x089416e2,0xf75efb84,0xce16ed30,0xdc0ac220,0xce42dbda,0xb6abc243,
0xc17abcf0,0xd8b7c49b,0xe26fe599,0xecfee2cd,0x111904f4,0xf6c70555,0xe56ce439,0x04090931,
0x0942ed99,0x12091bc3,0x176f1829,0x357921a9,0x06362228,0xed3cfab6,0xdfc3e072,0xddecdfe0,
0x1603f3e1,0x182d24f0,0x02090571,0x0bd70609,0x35cf20bf,0x40dd3974,0x57ba5774,0x202e3ff3,
0x2a2d1ba9,0x075b1697,0x0dcd10db,0xdcc3f869,0xd960cc26,0xd437e0a6,0xc0eecb46,0xb718b938,
0xd14fbb9c,0xd2b5d949,0xe5b6dca8,0x13f9eeb2,0xeb5b0ea1,0xf75df2ec,0xf546efab,0x00caf6ea,
0x0e9d10f8,0x178608b4,0x28ab2666,0x231e29e4,0xfb5f0e6f,0xec57f35d,0xd3d8dc4d,0x08d9e8da,
0x1b3c1683,0x08681dc1,0x067bfc98,0x28561c16,0x357020da,0x5ebf5ed9,0x387544d9,0x2c7931bd,
0x13261eda,0x1a421bc9,0xf1c007e4,0xde2be020,0xdb95e0f9,0xd10cde31,0xbb05b438,0xbdd7c098,
0xd575d843,0xd7cac076,0x01a5f7d5,0xfb0cff34,0xfd46fa0b,0xe553f114,0x05eef2b6,0xff510537,
0x10850593,0x232e17aa,0x29662b97,0x115f18eb,0xf2440d2e,0xd9e9de86,0xeb1fdc86,0x1a230092,
0x076423f4,0x0dc8fa47,0x0c51133a,0x2b231223,0x547b4a27,0x49744caa,0x30b4405b,0x1d302633,
0x22e423c9,0x07a80ca8,0xd7a8f6a6,0xe928e23d,0xda5dda8a,0xaeb9cc0e,0xc8cab37d,0xc076cc28,
0xc51fb9b6,0xf327e368,0xf1b3ed74,0xfdb301dc,0xe3d9e904,0xf67feaca,0xf986f87f,0xf72ffaad,
0x1e200661,0x1cfb205a,0x1e071cf6,0xfc1716fb,0xe266e9dc,0xcd2acc60,0x0bfcf0d1,0x02ad0aca,
0x0c5904e2,0xf67f0398,0x17c30458,0x3d2a2b1d,0x51fc4101,0x2e284e17,0x2ea82c8e,0x25ac2020,
0x0dfa258e,0xf83402ec,0xe24ee2da,0xece5f17b,0xbc1bd3e0,0xc9e5ba29,0xbe83d270,0xc5a1b428,
0xdf88d67e,0xf425e66c,0xfdf1027e,0xf0baf636,0xed84e621,0xfe77ff6e,0xf01ff499,0x187e01ae,
0x19c417bb,0x288328e9,0x1b3c1ddb,0xef420dd8,0xd18cd2ec,0xfe26ef86,0x099cfc30,0x17aa111f,
0xf40b0b8b,0x16e0036f,0x295a1377,0x4bf14702,0x4e4e5135,0x2ec93670,0x313d35c7,0x269628b0,
0x03141c5a,0xebbdf12f,0xfdf1f8a6,0xc8c8e250,0xd1d6c946,0xbf21ce17,0xc756bd07,0xcd81c4c6,
0xec1ce28d,0x000df701,0xf6e5008b,0xecf0e8f8,0xfc79ffc7,0xf53beef2,0x0011fbe2,0x1be00f39,
0x1b4d227c,0x34781fac,0xfc1d24d9,0xd6f9e1cc,0xefc4e71e,0xfa72e470,0x0ea8163a,0x036504a0,
0xfd8ef819,0x15310d01,0x40dc2333,0x49645038,0x383542d6,0x329d3198,0x313d308e,0x104b2b9d,
0xf53df751,0xffb10066,0xd7c1e592,0xcfe3d999,0xc68dc799,0xbfccc2e9,0xc0ccbc01,0xdaf1d078,
0xfec0e776,0xeea3fdce,0xf388f153,0xf534f56e,0xfab0f5fe,0xeed9ee90,0x16930c4b,0x122e116c,
0x38d71d94,0x0db83bb4,0xf509f54b,0xdcbae5da,0xf254e6e9,0x10e1fe69,0x00ce0ffd,0xfd9bfe92,
0x0716fc87,0x28a01514,0x47303e48,0x433b4962,0x2d9433bf,0x410a3457,0x16203981,0x08a50293,
0xfbb00695,0xe993f104,0xd771e307,0xce44cc1a,0xbc71c59e,0xbc0ac2a3,0xca1cb812,0xf474e19b,
0xee7df081,0xf506fb76,0xf9beec62,0xf335fc11,0xe97ded27,0x142d0218,0x001c0208,0x3504205b,
0x29db30f3,0xff10179a,0xe636f32d,0xe836dca2,0x027cf887,0x0a830cb2,0xfd580509,0xfa78f604,
0x14540600,0x364a2555,0x4c5d4ad6,0x263c3224,0x47ac3ba0,0x22bb3b47,0x11d410f3,0xfe2b0a4b,
0xf374fe31,0xe2d8e548,0xcdffd95e,0xc479c49e,0xb46bc80e,0xbe8ea6f3,0xda73d091,0xecd0ea78,
0xeefeeda7,0xf58dea4f,0xec2f00c9,0xf13ddbb9,0xf7e900c1,0x002ef67a,0x21fa0b92,0x2bb82e55,
0x1a0c27f3,0xeda602af,0xe4d2e018,0xf62ceda8,0x0b7c0262,0x03fd0e91,0xf4dff4ba,0x01980328,
0x2a940938,0x484844e5,0x2ae73533,0x48f43f2d,0x382641ce,0x182a26ef,0x117b1580,0xfc3f0ad0,
0xf8bbf2f0,0xd286e682,0xd66bd7d3,0xbf2ccb54,0xb1c1b1e3,0xcefac2a6,0xf23fdfa0,0xdd32e909,
0x0651f26f,0xe94ff780,0xf0bceae4,0xf7f0faac,0xf737f094,0x1379039b,0x2aea1fae,0x2d6b326f,
0x031819aa,0xe79cee9b,0xeb14eb71,0x0d58f50c,0x050a0e80,0xfe97011d,0xf240fcd7,0x1ebff968,
0x388237f7,0x339f3703,0x42c03913,0x47f346c8,0x203931dd,0x1cad25b1,0x086a0a75,0xf9b107a4,
0xe0abed4e,0xe04dddd3,0xc2fad41f,0xb602c04a,0xbd0da6d1,0xe188e0d0,0xdb92d82d,0xfdc0ed96,
0xeb7ef9bb,0xf0e1e807,0xf4cdf872,0xeec3ec63,0x0048f786,0x1c17101e,0x35ec2a59,0x12d72706,
0xf292058c,0xe4e7e41b,0x00b5ef05,0x0004016c,0x0b3f0f98,0xe80ef62a,0x0d95efa5,0x293e2079,
0x314e3343,0x41502e06,0x42b54b67,0x38583dcd,0x20f52b6d,0x11c4171c,0x08fd14db,0xeed0efe8,
0xdf6ff1f6,0xde2ed9fc,0xb353cde6,0xb8efa9bd,0xd7cbd016,0xd624d256,0xf7d3e666,0xee3bf9b0,
0xf050ed8c,0xf97ef47e,0xeb9df0a9,0xf5d5f3ee,0x1289fd28,0x2d3021e6,0x27292dbd,0x023220fb,
0xec13e8f1,0xf35bf3ca,0xfca8f011,0x141715db,0xeb80f958,0xf45bea7f,0x22911050,0x242e1fbd,
0x39333101,0x428f3f24,0x455a401e,0x1ff63b80,0x257b1c2f,0x0a8119a2,0xfd280612,0xe7eceef9,
0xeaa1ea1a,0xbe3fd7dc,0xb4a1b1e0,0xc9efc3df,0xd179c825,0xe7dfdcdd,0xf05ff532,0xf11dea95,
0xf4b2f0fb,0xef93f5ff,0xe9d3edd9,0x05e6f0d1,0x18da1083,0x372a2b4f,0x10662f5e,0xfb39f895,
0xe7caf9c3,0xfa46e8a0,0x15e70acb,0xf1600eaf,0xf11be32f,0x115402b6,0x15c115a7,0x384b287a,
0x362a31d9,0x4c854bf5,0x30963b13,0x28472cc9,0x1a831e22,0x064016ab,0xf08ff519,0xf7dbf423,
0xc8c6e65c,0xbbd1bff0,0xc350bb4a,0xc5e7c026,0xdf82d4f5,0xecb5e9ad,0xf0b2ed2d,0xefeced5b,
0xf73bfaad,0xe671e9d5,0xf915ed4e,0x036afb35,0x396f23dc,0x1ca22dab,0x072b14cb,0xf162fb02,
0xe96ee38b,0x13a00302,0x0061132f,0xe937e772,0x002dfdfa,0x12d600d0,0x21351fc1,0x35d32622,
0x447c43fc,0x3fcb4267,0x2a5934a9,0x229d2583,0x13092593,0xf83bf808,0xffbffd85,0xdb1cf5f6,
0xc5dbca51,0xbe91c250,0xbb3db825,0xd46ccb04,0xe6a1da1a,0xeb12ec83,0xee09e968,0xf70bfa06,
0xeac3e8ac,0xe882f2f9,0xf9f9e3b6,0x245b1283,0x26752d08,0x1ac81f38,0xf6490aba,0xe216e9ea,
0x0ef2f159,0x01a612c5,0xf468f76e,0xf0acefb3,0x0c60fd7a,0x10390c8c,0x2ae52062,0x3d6c37b2,
0x4ab94184,0x2c1a3f0f,0x2fac2c8b,0x20662f57,0xfd110753,0x0941031e,0xedc5046b,0xd642d94a,
0xc262cf9c,0xb99fba11,0xc9d8c167,0xe04dd245,0xe20ce7f0,0xf806e79e,0xed61f4df,0xf8adf398,
0xe7fbf0f5,0xe89fe00f,0x149b0390,0x274b1def,0x255927e4,0x0bb6226e,0xe3a9eb93,0x0439f2b2,
0x082b05a6,0xf9e70b2c,0xefeded7f,0x0559f833,0x03360366,0x207e147f,0x316b251e,0x489e3fd7,
0x32354296,0x351d2f90,0x2cb03669,0x01d31342,0x0d09064b,0xfa28086d,0xe129eaea,0xca08d930,
0xbdc0c1ee,0xb9afb45c,0xd8bdd040,0xd9edd1c7,0xee99e8b7,0xe923eded,0xfcf7eef1,0xe59df86a,
0xdf76de69,0x02a8eb28,0x13d1100a,0x2f161c1a,0x157a34f4,0xf128f8d2,0xf5d3ee69,0x05c2fdf4,
0x026d0de2,0xf0f4f0b1,0xf939f739,0xffecfc5f,0x10ff0940,0x25d115a2,0x43be3799,0x387843d3,
0x3b413271,0x35824030,0x11472285,0x11de0eb8,0x064f0cee,0xf1490230,0xdf21df26,0xbff8d7e3,
0xbbf9b493,0xcf96c7e9,0xcfdecdb0,0xecbbe409,0xe772e62a,0xf9f7ef70,0xf4b6fda9,0xd72ee56b,
0xfb29e46e,0xff3ffb70,0x2ba71484,0x297b3716,0x006b0efc,0xee83f498,0x053ef969,0x048c0975,
0xfa42fcde,0xf210f61a,0x0024f7ff,0x0464024a,0x14b2075a,0x3cad2c49,0x37ed3e68,0x3e55360c,
0x3d4046e6,0x25132a7b,0x0f221bd6,0x1629115b,0xfabb094a,0xecacf3ae,0xce8ee4ca,0xbf12ba82,
0xc452c40b,0xcdfbc615,0xdfb9dae5,0xe5c2e436,0xf366e38f,0xfa2f05e7,0xe00de646,0xee46e446,
0xee58edeb,0x1d3f045a,0x30ab2cc3,0x122226d1,0xf0c6fb73,0x02d4f8ef,0x03ab01ec,0x0104049b,
0xefbaf8cf,0xfc3bf1b5,0xfab001bc,0x0384f8e7,0x324b1a28,0x2d083598,0x41e3343c,0x3ee840f8,
0x2d683ce2,0x1a0b20fe,0x19691734,0x036f0eee,0xfe460298,0xd91def7e,0xc9cbcce5,0xbcc3bf42,
0xc531c3bb,0xde5cce6d,0xd835dc9b,0xee5ade78,0xfae1ff28,0xe97fec5a,0xe6aceb84,0xe4d1e24c,
0x05adf382,0x2def181e,0x21b833ab,0xfac108cc,0xfe57f9cc,0xfedcff51,0x082f0554,0xf3dffeaa,
0xf77cf0b5,0xfd000173,0xf3a7ec83,0x1e7f1009,0x2c0525f6,0x379f2e79,0x44d63f89,0x37be4575,
0x2470291f,0x1f0c2516,0x0c750ffa,0x0a5f147a,0xefc6f9dd,0xd3a4def0,0xc131cd47,0xbfb3b9f8,
0xd97fccc9,0xced4d730,0xea9ed836,0xf577f687,0xf3caf0b2,0xe880f236,0xe2ade1d8,0xef24e527,
0x1e8f051b,0x2c98305a,0x09271937,0xfd9501ea,0xffbefc3b,0x08190215,0xf52e07ee,0xfd9af0f1,
0xf836ff89,0xee79edec,0x0b8cfc90,0x229b18c6,0x29b22594,0x445f351d,0x390a4ab0,0x335d2d37,
0x1f672cb4,0x130c17d4,0x157f13f6,0xf954098e,0xe46aec95,0xca16de42,0xb87eb6b6,0xd534ca53,
0xc76bce6f,0xe26dd1a3,0xec5de904,0xf57bf23f,0xf10ef542,0xe2c5e9e1,0xdebfdcf4,0x0db2efee,
0x2a042224,0x176828b6,0x067e0c48,0xfbf1fa9a,0x0ad907b7,0xf999035d,0xffc6f935,0xfa6aff7e,
0xed99f354,0xfa6ff205,0x1c9d0c33,0x193618d9,0x3fa02ff6,0x3f424121,0x36ca38de,0x2a813431,
0x17461f40,0x1dab184a,0x052316d3,0xf67ef8c1,0xd997f0a8,0xbb35beba,0xcf6bc986,0xc749ca84,
0xd60fcc60,0xe6bbdf17,0xf200ebc7,0xf58ef38a,0xe9d8f80e,0xd97edb5e,0xf5fcdf4f,0x1ebc11a3,
0x26f224b8,0x0b901d39,0xffd7fc05,0x0ab10b14,0xfbba03d2,0x035dfce1,0xfc55fffc,0xf086fd9e,
0xf4bde612,0x0b0d04b2,0x129b0d78,0x312521c3,0x3e333aaa,0x3c063da7,0x346c3b72,0x1c65264f,
0x237f1d40,0x0c971dd3,0x0770059e,0xe811ffd7,0xc651d037,0xcb2ec5bb,0xc664ca33,0xca5ac907,
0xe0aed312,0xe574e380,0xf5a4ef53,0xf5ccfa0f,0xd49be2ac,0xe590d4db,0x069df7e6,0x29581b32,
0x1311246c,0xffb3018b,0x0a6f0c45,0x01180064,0xfaaafd8f,0x05b8019e,0xf001fde9,0xef05e89e,
0xfe33f907,0x089c01fb,0x234913f0,0x35242e87,0x3dcd3952,0x3bac4309,0x22662b99,0x29942723,
0x14681dbc,0x13a41368,0xf90b0dec,0xd78ce350,0xc91dcd01,0xc973ce4e,0xc7f3c4ee,0xd706cdc9,
0xdfa7dd03,0xeeaee42e,0xff1bfd89,0xdf0aeda6,0xd98dd95c,0xf254e4b3,0x24890885,0x18fb2873,
0x0ab60f65,0x0b5b07b0,0x05f10ce3,0xfb2bfc26,0x0c2a05f3,0xf77f0418,0xf087eec9,0xf879f5fe,
0xfdccfa23,0x181708b4,0x27da22fb,0x3f272d92,0x3e7648ca,0x2d523112,0x2fdb2fc5,0x16f82230,
0x1ee41d3c,0x0d0e18a3,0xe7e2f98e,0xd3b3db4b,0xcc23cfc5,0xc758c8b6,0xd242c87d,0xd61cd96d,
0xe7fedbcf,0xffc9f562,0xeb0df94e,0xdb0fe49e,0xdfa9d2f6,0x0f50f9c9,0x205e1ce1,0x0d751a0c,
0x0dda06ac,0x09fe11e6,0xf971fcf5,0x0c52049b,0xfc9b08e6,0xf225f37e,0xf610f43f,0xeffbf1f5,
0x0f1bfddb,0x150811de,0x352a20c9,0x3d29452c,0x33763101,0x319f367f,0x1c63269d,0x21161c02,
0x19c721a5,0xf91607f1,0xdcb7ebd6,0xd227d6a1,0xc63fc826,0xcc7ec906,0xcfd9d1f9,0xdd9ecf09,
0xf3c2ee19,0xfacbf915,0xddbef0a9,0xd6aad199,0xf801e40b,0x1c630e6d,0x11181c5a,0x10110bab,
0x0e1414ad,0xfa9c002b,0x09e60201,0x03bf0c40,0xf6bef61e,0xf580fb60,0xeb86ee0b,0x0542f69f,
0x03ad053c,0x29da13c7,0x38cf384b,0x36553459,0x37623839,0x20fc2f0c,0x22dc1dc0,0x23622398,
0x07361a36,0xefbbf9fc,0xda30e2d8,0xc5accf4d,0xd061c9ae,0xc746ccc2,0xd528cab5,0xe65fdbf2,
0xfdc0f548,0xea97f940,0xd24ddb82,0xe3e6d3e9,0x0f63fc23,0x0f9e1521,0x14370e97,0x124814c0,
0xfc77086a,0x0a440003,0x06290c5a,0xfc07fcb0,0xf8ae010a,0xec06ec70,0xfd1ef5ed,0xf9bafa2c,
0x18a40745,0x31bd296d,0x3520305c,0x39833bba,0x2d4a34d7,0x205f21a9,0x27912699,0x17e224fa,
0xfdde0792,0xe8fbf758,0xcdbfd4d1,0xd0bad0fa,0xc90ccba3,0xcb5dc9cb,0xdacdcfae,0xf6feea7d,
0xf8e0fd68,0xd999eae9,0xd57dcc27,0xfef9ed10,0x0b8208c6,0x14800c24,0x162919e4,0x01fd0cc1,
0x0b140275,0x03f60aeb,0x05880119,0xfa1a06e8,0xf173ef93,0xf892f5f2,0xf205f685,0x0c96fa81,
0x22bf17ab,0x30842cac,0x3c1937a2,0x33763a13,0x23c42b35,0x2cea2406,0x1fe42d93,0x10c81448,
0xf693088a,0xda88e4a1,0xd282d6d0,0xcea0d172,0xc86fcad9,0xd060c829,0xe877dd47,0x028af7d5,
0xe57af950,0xceddd26c,0xf110decb,0x0032fb2f,0x10030438,0x193f1b1f,0x05480df7,0x0e280899,
0x00400762,0x09b504bd,0x002b0817,0xf267f22c,0xf756f98a,0xef2ef1b5,0xfbd5f218,0x14160998,
0x274b1cbd,0x35ec3026,0x3a8f3b12,0x252e2e38,0x2cd326fa,0x24752bf1,0x1c312097,0x05f21317,
0xe788f597,0xd598de4d,0xd3f5d453,0xc7afccd5,0xc737c760,0xd7b8cc8e,0xfdeee9fb,0xf300013e,
0xd04ede14,0xe40ad54b,0xf249ef4c,0x0614f6cb,0x18431987,0x0b4e0cb3,0x0ea80cdc,0xff7c091a,
0x0d3c028e,0x02370d18,0xf74ff9c2,0xfaf6f947,0xedb6f5c4,0xf4afed04,0x06f0fbf9,0x19c41208,
0x308d22f9,0x3af63ca6,0x2cf1308a,0x2bf12cb6,0x28f12b21,0x2836297e,0x14971ea1,0xf8720991,
0xe18fea6b,0xd932dc08,0xce53d346,0xc6d7cb94,0xca28c401,0xf1fcda7c,0xfd8f01aa,0xd943ed5b,
0xe1bad560,0xe452e56a,0xfcfcecbb,0x15460ef2,0x0c7d0f12,0x135313ac,0x026b099c,0x0af00542,
0x098a0e32,0xfb6bfee4,0xfe35fdff,0xf39af9dd,0xecb2edf9,0x0024f31b,0x07db0584,0x274014c6,
0x38ab353f,0x31bb32af,0x2d8b3327,0x2a7c299c,0x2c062ba4,0x21b22836,0x09a31823,0xf04dfa4a,
0xde9ee5e5,0xd5c1da1b,0xcaa6d379,0xc088c071,0xdf7dc8f2,0x00acfa31,0xe643f347,0xe024dfcd,
0xdbf3e002,0xf069dfab,0x08aa027a,0x10940bb1,0x13e01461,0x051c0df7,0x09fe0438,0x0a590e0e,
0x008903b8,0xfecdfeb4,0xfb7801ca,0xeabfeeec,0xf7e6efa7,0xfa4bfb89,0x17820453,0x2f0026f6,
0x339e326f,0x310a3417,0x2a622bb2,0x2bd429b7,0x2a3d2e8d,0x17c52333,0x013c0adb,0xe65ff34e,
0xddf1e15c,0xd5efd9cc,0xb957c7eb,0xcfb8bb3e,0xf7fde935,0xed44f5ee,0xe9b0eaf3,0xd736df58,
0xe60bdb17,0xfb0af1db,0x0c3402e7,0x17161470,0x07d00fe0,0x09dd07d9,0x0d550abb,0x01a70944,
0x01bcff63,0x017b05f6,0xedf1f50f,0xf413f181,0xf2eaf343,0x076ef8f5,0x223315b2,0x300c2ce8,
0x33cb32f5,0x2c2a3055,0x28ff28c4,0x300f2fd6,0x23c02963,0x0e531a36,0xf476028c,0xe304e6d0,
0xe190e56a,0xbe0cd206,0xc11cb3e5,0xe89fda6c,0xef29ec20,0xefa2f2d5,0xd9ade401,0xde44d7cf,
0xecb2e7a0,0x0348f310,0x13080f6c,0x0b6310a3,0x083d071e,0x0de30b5a,0x02350af5,0x04f5ff52,
0x03740727,0xf3f9f9b0,0xf233f46b,0xee86ef4f,0xf837f04d,0x118d04d2,0x2891205e,0x32092c73,
0x2c703268,0x290d2963,0x2e802b08,0x29802f5d,0x1da2231b,0x017711e5,0xe876f1ec,0xef20eb70,
0xc745e19c,0xbb00b6a8,0xd70ecaab,0xe9b3e156,0xf5c8f184,0xdeabecb2,0xddafdac7,0xe20cdfd7,
0xf415e811,0x0f5c04c1,0x0e871224,0x080106da,0x10340dac,0x039c0bb6,0x0820021b,0x053708e0,
0xfbd80084,0xf6c0fa1f,0xee5ef043,0xeea8ed70,0x03d9f77f,0x1d5c1010,0x2d7f283d,0x31252ffc,
0x28642c19,0x2cff2a48,0x2ed52eec,0x28612b8f,0x144c236b,0xf02cfe4a,0xf9d8f4c9,0xd8eeeece,
0xbc62c403,0xcb8dc31d,0xe01ad2d6,0xf4ebef36,0xe7ddf22f,0xdf4ee0e2,0xde10ddf0,0xe648dff8,
0x07dff682,0x0ee31068,0x080a0755,0x115f1021,0x05f10bed,0x09490454,0x07240b61,0x0326050b,
0xfc3aff6f,0xf135f86e,0xece0ec0a,0xf585eeb3,0x0f77020f,0x27d41bd0,0x2fba2d80,0x2b222dfb,
0x2b02295a,0x2ccf2e31,0x32732bf6,0x22233234,0xfd760ba2,0x01e2fc18,0xe7b9fc72,0xc859d4cc,
0xc1efc2bd,0xd3ffc675,0xee74e4e2,0xeea3f1da,0xe418e7da,0xdcfbe0b1,0xda84da9e,0xfb94e6de,
0x0a70083d,0x077a076f,0x11ae0e44,0x07210cdb,0x06f706b6,0x0acf0961,0x0469080f,0x026704b8,
0xf898fdf5,0xebc6f0ca,0xee30eb46,0xfd7df3ee,0x1b800d4c,0x2c80256e,0x29782c63,0x2e912b42,
0x26502988,0x34312a74,0x30543ab6,0x0a101989,0x091406e6,0xf71a051a,0xdae6e86e,0xc17bcb8a,
0xc7c4bf81,0xe4bbd7fa,0xefbcec2c,0xea41ec98,0xe1a5e825,0xd596d938,0xec74dc06,0x01f3fc80,
0x0805038f,0x0eaf0c35,0x0b2a0fe3,0x07030676,0x0a2108cb,0x06f8095d,0x04e805b1,0xff76052f,
0xf0d0f6da,0xea20ece8,0xf193ec32,0x0a7af984,0x23481c9b,0x26e8248b,0x2f9f2bfe,0x206d297c,
0x318b23cf,0x37f13d0d,0x16492470,0x0ec8117d,0x02d50b5e,0xecabf80a,0xca0cdb1a,0xc01ec02f,
0xd922ca25,0xe7a0e276,0xede3eb31,0xe8dfedcf,0xd2cbdc0b,0xe17bd724,0xf6f8ec9e,0x022ffcc7,
0x0ce007ab,0x0cbd0ee5,0x069d09f6,0x0a6206f4,0x07150ad5,0x088c06ba,0x04a70689,0xf65a003d,
0xef0bf048,0xe862eb17,0xfb8becf4,0x18840f09,0x20e51aef,0x317c2ace,0x1d362ae9,0x2d101ec7,
0x3c283ac9,0x232530b6,0x16561c09,0x0cfb117d,0xfc7c060b,0xdbaeeee9,0xc197c955,0xce46c47b,
0xde96d9ee,0xed73e32a,0xef1bf2d9,0xd8d1e2f1,0xdac5d5a8,0xec2ae422,0xfb72f349,0x07cf02b6,
0x0e820d1a,0x07de09df,0x095609ee,0x0a390935,0x089307f7,0x09210a72,0xfe0104e9,0xf57ef831,
0xe5e2ed7c,0xf01ce5b3,0x0b920191,0x18760ea5,0x2f952780,0x1e832ae4,0x25281ac4,0x39b132f7,
0x2eeb37e2,0x1ed92502,0x12a018fc,0x09610fff,0xeeb5fe85,0xc832d947,0xc9cac3e6,0xd3cfd01a,
0xe562da7c,0xf2c6effa,0xdd79ea81,0xd878d735,0xe229dba7,0xf05feac6,0x040bf8c7,0x09e808b2,
0x09070a97,0x09440914,0x091e08b0,0x08f90753,0x0aff0c17,0x04210784,0xfdb40093,0xe692f3b8,
0xeae8e349,0xfbd6f524,0x0ce1012b,0x2add1ec6,0x212b28bd,0x1cfc1af8,0x33c4297d,0x359e3790,
0x261d2e0a,0x1a4a1fee,0x130d155c,0x016d0eb5,0xd792ebbc,0xc973cc65,0xcd44cb7d,0xdab2d015,
0xf14aeacf,0xe7a5eebd,0xd810dd31,0xdcdddb52,0xe66be04c,0xfb01efad,0x066d0234,0x08a90933,
0x0a2608ec,0x0768089d,0x07ee06b3,0x0c760c43,0x06d307d7,0x077809a8,0xedbcfbc3,0xea60e5f1,
0xeef3ef32,0xff8cf3f9,0x21c91105,0x22b22740,0x1afb1c89,0x2abc203d,0x36073351,0x2fa73395,
0x1fcf28b2,0x1b5a1a57,0x11da1a5e,0xeb580112,0xd4a0db12,0xc801cd5a,0xd1a6caf0,0xebfdde61,
0xed41f0ec,0xde79e4dc,0xdb70dd47,0xdfb0dbb4,0xefd3e5ea,0x011afaa8,0x0740054e,0x0aef0899,
0x06fc0b76,0x091e04a3,0x0be20c65,0x06de07d7,0x0fb70e6b,0xf6d10464,0xed81eea2,0xeb28ee77,
0xf0bfe90b,0x144a0215,0x215b1f65,0x19831d18,0x231a1bb8,0x300a2a1a,0x35dc3603,0x26702e62,
0x1dcc1e37,0x1e52234f,0xffe40fa3,0xe229efb2,0xcc80d650,0xc9b0c82f,0xe290d39b,0xed64eb1d,
0xe52aeadc,0xddf2e0bb,0xdb05dba9,0xe515dee9,0xfb03ef9a,0x01bdfeba,0x0b4b0761,0x074a0be7,
0x09b30451,0x09ea0dba,0x0791064d,0x129b0e8f,0x006b0d16,0xf4a2f744,0xec88f2d7,0xe6bae5ca,
0x04a8f2bc,0x1be215ad,0x1a0c1988,0x1bdd1a5a,0x28722255,0x394130db,0x2ab935c5,0x224922ee,
0x24a0261f,0x10b81c37,0xf48b0200,0xd80ae772,0xc7b6cb6b,0xd6b0ccc4,0xe87ae22b,0xea93ea8b,
0xe0f5e4b0,0xdbe6dfa3,0xde66da31,0xf12ee69a,0xf9dcf63b,0x0a4f02a5,0x05db09b7,0x0a01059c,
0x0aef0d41,0x06690649,0x12be0cf0,0x084f118c,0xfcfc0106,0xf455f910,0xe12ce9dd,0xf6b9e7df,
0x12e20648,0x16ea164c,0x19e81999,0x1e9819d6,0x36d22a91,0x30b837dd,0x266629bd,0x29ec279b,
0x1c612695,0x07d012b1,0xeacffa7f,0xcc01d818,0xcf33cb72,0xe1fbd7ad,0xea2be7a8,0xe5c8e8cc,
0xddeae34e,0xdad0d873,0xe6f0e1c4,0xf270ea9b,0x0575fd1c,0x0399063c,0x08e604e3,0x0a250c46,
0x05680426,0x0f250ae7,0x0da81230,0x047205fb,0xfa3301c8,0xe3f0efe0,0xe900e088,0x0525f800,
0x12a20c65,0x1619173e,0x15c1127b,0x2bbd2068,0x32a93411,0x27db2b6e,0x29e82808,0x235c2ab2,
0x15ee1b5c,0xfb620b58,0xd733e884,0xcb34cdc8,0xd826cf28,0xe426e006,0xea4ce7bb,0xde6ce635,
0xda7ed9af,0xddd5ddbd,0xe8ffe043,0xfddbf396,0xff010146,0x082e0280,0x097709c4,0x014f0448,
0x0d65071e,0x0d310f3c,0x09330a21,0x04630800,0xeb3df9ba,0xe376e18c,0xf407eb44,0x0cad0097,
0x13711232,0x0eb5100c,0x22d3175d,0x31492cb5,0x28b02ce8,0x2ac929a6,0x27da2acb,0x204c2406,
0x0d4f19a4,0xeb18fd6a,0xcdadd80f,0xd2adce7d,0xdc61d725,0xec6ce51c,0xe272e928,0xdd32dedc,
0xdcbddea3,0xe086d97b,0xf593ec7b,0xfca7fbbd,0x060dff00,0x0b1b0c6b,0x025c0503,0x0c3e0656,
0x0def0ecd,0x0bae0bb4,0x0f360fa3,0xf7d503ba,0xe68aedd0,0xea4ee630,0x0463f487,0x10d20dfc,
0x0c740f72,0x1b0e0ff5,0x2cd526b4,0x2b872d24,0x2d252bec,0x2a9d2b5e,0x26ff2ab8,0x1daa22fc,
0x009712b0,0xdad8e9da,0xd10fd5b3,0xd6bcd0c4,0xe8dfded7,0xe539eaae,0xe2fde2f7,0xdccfe13d,
0xda10d910,0xee15e329,0xf568f3f5,0x01ecf942,0x0a7e0a08,0x02fd069c,0x09220243,0x0a4b0e47,
0x0b220875,0x12ba0fab,0x02210c48,0xeebbf92e,0xe37be5dc,0xf59be91a,0x0c29043e,0x08210b34,
0x11a108a4,0x23401d67,0x2abe2727,0x2b9e2b6e,0x2a9f2a60,0x278e2b4f,0x288d2716,0x116a2018,
0xec6bfea9,0xd5c1df99,0xd00dce99,0xe090d8ac,0xe551e4b5,0xe499e46f,0xdf2ae41a,0xd607d8bb,
0xe65bdc88,0xed6dea2a,0xf8bef2e1,0x09e60394,0x01f805f7,0x069f01db,0x09260b4f,0x08cd05e3,
0x119b0e9a,0x0c59116f,0xfa2503b4,0xe476ee5d,0xe9e9e30a,0x065bf987,0x04c4074c,0x0a6c0543,
0x198b139d,0x27c820be,0x29f72858,0x2bbf2ced,0x28ba291c,0x2d5c2a1c,0x20272ae1,0x034f11df,
0xe11af1f8,0xd13cd564,0xdb65d54a,0xe2cedff0,0xe796e3a3,0xe22fe9cf,0xd902db5d,0xe043d9a0,
0xe699e56f,0xf2bcea5b,0x058afd71,0x01930580,0x06ed02cb,0x088e085c,0x06df06c2,0x0fd00b8f,
0x13991345,0x067e0d52,0xec5efc04,0xe402e364,0xfdb5f01a,0x025d01bc,0x053e0493,0x12f409ca,
0x1ed61a2b,0x28162368,0x2cc72c75,0x273f2889,0x2f4b2b9a,0x2a1d2efc,0x17e121d7,0xf26f064c,
0xd5c7e207,0xdab5d5e7,0xdc3cda37,0xe7a9e261,0xe75cea71,0xda50df63,0xdd39da72,0xe106e09f,
0xeb14e1a2,0xfe78f758,0x01410192,0x0633026e,0x07580613,0x04af074b,0x0c32076a,0x13d41052,
0x118c13c7,0xf81609e2,0xe555e8e5,0xf18fe943,0xffbffb0e,0x0020ffc5,0x0aff0395,0x161d12b5,
0x23361b04,0x2b01294c,0x257d26fa,0x2c4b2a25,0x2f392e7d,0x25c42a76,0x07531c63,0xe2bdf112,
0xd9a4dc0c,0xd6d5d819,0xe450dbc3,0xe9ace914,0xdc69e448,0xde4adc01,0xdc64ddc1,0xe27ddae5,
0xf568ee1e,0xfe98fb01,0x036effc7,0x069805fb,0x03b6064b,0x08bc0486,0x0d3c0a68,0x194b1502,
0x06821363,0xeb29f735,0xea7be772,0xfaccf317,0xfc16fb66,0x04b2ff29,0x0d310af1,0x1d8212de,
0x26c42378,0x254727c7,0x2b352647,0x2cfd2d04,0x302c2f80,0x1c7d2b09,0xf49906b7,0xdff1e98f,
0xd6e6db24,0xde6fd63d,0xea93e6ed,0xdfeae739,0xe19cdf2d,0xdb7ddef8,0xdc0bd991,0xeda8e4c0,
0xf953f447,0xffd0fbb8,0x06fc05d7,0x048d03cd,0x05a006ff,0x07d6050a,0x19b2109e,0x132d19b5,
0xf627061f,0xe9c6ec6f,0xf5d0ee8d,0xf83df6ad,0x002bfd95,0x071a0209,0x13730c42,0x226e1d09,
0x24ec2312,0x283b2618,0x290d29d0,0x339f2e2c,0x2b0a3279,0x08051afa,0xecb8f96f,0xda8ae2fb,
0xd8f9d456,0xe730e2d8,0xe2fde647,0xe2b1e189,0xdcd4e140,0xd86bd97d,0xe5d5dbe3,0xefaaedd6,
0xfc37f4b8,0x034a01a4,0x047e0214,0x03f106ee,0x025001de,0x1337081f,0x1a3f19fa,0x02ae1311,
0xef6bf408,0xee72ee4b,0xf5f1f252,0xfc6cf7fb,0xfeb7fd52,0x0b040472,0x1abd141d,0x21571caa,
0x254c253b,0x254e2555,0x313d2975,0x330e349a,0x19a429e9,0xfea20b46,0xe1a9efec,0xd78ed874,
0xe312dd81,0xe3c1e37c,0xe261e397,0xe1e2e407,0xd6c3da5f,0xdfd1d92c,0xe77de548,0xf6deeec7,
0xff07fb6b,0x036e0132,0x053206e4,0x00bf0185,0x088c023a,0x1e8a1696,0x0fde1974,0xf80a02d8,
0xefc4f393,0xf341efb1,0xfaa5f5fe,0xfa73fc1a,0x05a5fe7c,0x12ec0c75,0x1d0016fc,0x24b023a5,
0x234f23d0,0x2c7424ee,0x37b5359a,0x291331f5,0x129d1e26,0xef1102b0,0xdd5fe2ae,0xdff2db8a,
0xe365e32f,0xe4a3e35f,0xe541e770,0xda13dd22,0xdb80daba,0xe232de5a,0xf087e850,0xf89bf63a,
0x02d1febe,0x07060355,0xff1905ea,0x0186fd2e,0x19f70d2d,0x18191c8b,0x03310f27,0xf520fb95,
0xf071ef7d,0xf7e0f42d,0xf73ff94c,0xffaaf94d,0x098c04e4,0x15fe1002,0x23311cef,0x1f1022aa,
0x25931fd5,0x368f307d,0x30e53375,0x22f02cdc,0x01d01453,0xe531f0fb,0xe033de97,0xdeece11a,
0xe5e2e0a8,0xe5bfe7b4,0xdcb3e191,0xdb18dc65,0xdc86d7d8,0xe68be2f4,0xf380eda9,0xfc4cf6cf,
0x05ed0106,0x006e071f,0xfbd2fb28,0x0eea0212,0x1a5618a2,0x0e9c1686,0xfd2205dc,0xf069f452,
0xf574f33c,0xf65af58c,0xf8b9f6ae,0x022ffe84,0x0d7706b3,0x1e4a14ff,0x1d1c21f6,0x20471b99,
0x2fba28b5,0x34213216,0x2f753420,0x18d92733,0xf2b5039a,0xe5baeb2e,0xdf02e1b6,0xe437de0c,
0xe58ce8b1,0xe408e4ee,0xdcf3df9a,0xd9e6da76,0xe15edd59,0xed7de7b8,0xf4e9ef67,0x0448fd3b,
0x051a07df,0xfab2fe61,0x053ffc89,0x17d410f4,0x17d518a7,0x0671113a,0xf71ffdd7,0xf5d3f492,
0xf59ef553,0xf649f652,0xfd6dfa5e,0x03e3febc,0x18d70dc5,0x1b961dd1,0x1d391a30,0x27fa214b,
0x30f42f70,0x36e432d4,0x28e733bc,0x0389175a,0xf157f930,0xdfdde5a3,0xe183dfe4,0xe5dde501,
0xe5a8e64f,0xdff6e225,0xd918dd8a,0xdd15d8c1,0xe640e234,0xebfce870,0xfe5ff4a1,0x069d0479,
0xfa070165,0xfe2bf9d6,0x0f0a04ee,0x194015cb,0x0ea91769,0xfdf405e5,0xf650f7ff,0xf40af59b,
0xf50df370,0xf8e8f7ef,0xfa5af6db,0x0e9705a9,0x196214b1,0x179117c2,0x20eb1ca2,0x2aed265f,
0x35b32d4c,0x32e33aac,0x170f25cb,0xfce2097c,0xe6f7efd7,0xdffbe2a2,0xe54ee1d9,0xe58ae5fa,
0xe3b6e58f,0xdb6ce079,0xdaa1d7e2,0xe115df38,0xe5aee3df,0xf600e9e0,0x04ee007a,0xfdd60383,
0xfab3fab6,0x04e4fd41,0x16650f01,0x16a71997,0x061a0e9a,0xfb89ff52,0xf3d0f93e,0xf732f1f7,
0xf516f7de,0xf560f4f8,0x06b0fba1,0x13760d97,0x145a1597,0x1def187b,0x21c21f30,0x32172809,
0x38343947,0x28c13238,0x0bf51a7c,0xf2c9ff84,0xe3ace8be,0xe37ee1f7,0xe4dae50f,0xe7f6e7a5,
0xdf7be328,0xd922dafb,0xe006dcca,0xdfd9e08f,0xebc0e21c,0x0069f871,0x01c8032f,0xfa76fd74,
0xfce1fa00,0x0eed05b3,0x1a841671,0x0bc91471,0x042909ae,0xf7c6fc44,0xf638f465,0xf62ef91c,
0xf2c1f3ab,0xfcf5f42b,0x0cd9076e,0x11d10f01,0x1aa11703,0x1a58193e,0x2a7621d8,0x380d31f2,
0x332b3848,0x1c9b2a48,0x020e1008,0xeb8cf331,0xe308e6c7,0xe500e352,0xe8a0e6ae,0xe375e784,
0xdac7de51,0xdf7ddc2f,0xdc83de88,0xe268dd45,0xf84ded7c,0x0298fea8,0xfb8e0049,0xf8b7fb6b,
0x069afa2a,0x15ab1113,0x126e1655,0x0bf70fd4,0xfc090312,0xf723f8c2,0xf924f892,0xf087f57d,
0xf696ef99,0x049d0031,0x0e920758,0x16011429,0x15cb16a9,0x219119f9,0x325928f2,0x36cf37ea,
0x2cbd33fc,0x113a1f8d,0xf70f0337,0xe79cee48,0xe3e5e3f2,0xe89ce52d,0xe674eab7,0xde51e0e8,
0xdff5dd6c,0xdae1def2,0xdca4db95,0xeec7e16b,0xfcd0f819,0x009a01a6,0xf78afb9a,0xfe09f69a,
0x0ee608cc,0x15f21336,0x112814e9,0x04010b60,0xf993fd6c,0xfd27fa3f,0xf0c5f85d,0xf334f046,
0xfd63f844,0x08400117,0x125e0f90,0x14a0149d,0x18611385,0x29fa219c,0x3617313f,0x363e3830,
0x21032da2,0x05c21403,0xf226fa8d,0xe3e1e85d,0xe7d3e506,0xe9caec63,0xe23ee2c1,0xdf79e15b,
0xde70e0f5,0xd9cbd9ad,0xe34ddc95,0xf648ed2f,0x029dff1a,0xf7fbfdf5,0xf9a3f6df,0x06d1ffa4,
0x140e0d75,0x14b4157c,0x0be013dd,0xfecb01ff,0xfebefe83,0xf522fbaf,0xf303f297,0xf6bbf311,
0x00fbfc56,0x0f2107d7,0x123f1292,0x1243108a,0x20c71996,0x30e0284c,0x390b358b,0x2e39384d,
0x166422ce,0xff3408e2,0xe6b6f2a2,0xe9c5e67e,0xeb1dea68,0xe356e7b5,0xe2e8e2c8,0xe00be287,
0xd94cdb9b,0xdb13da28,0xece8e0f2,0xff80f88c,0xf9ebfe37,0xf6d5f8bb,0xff95f7d7,0x0b3a05ee,
0x169e1227,0x11c41735,0x03c60819,0x00ac035b,0xfa3bfd5c,0xf2b7f5a6,0xf2d4f235,0xf972f5e3,
0x09b00010,0x0eed0dda,0x0dc30f80,0x182a112d,0x26941d88,0x34e82f65,0x37b53a9c,0x24ae2cba,
0x0c4d1abe,0xf180fdfd,0xe90de9cf,0xeb8eeabd,0xe56cea43,0xe546e3ad,0xe1b3e435,0xdc06df0f,
0xd660d9f2,0xe2b5d78b,0xf6cfee44,0xfd12fd6a,0xf65bf8e2,0xf9def63f,0x01bdfe17,0x14b60a5a,
0x13a61751,0x09ac0eaf,0x04c8074a,0xfe640139,0xf54af8e6,0xf1b8f527,0xf477f094,0x015cf8ed,
0x0b210949,0x0de50d98,0x10830c15,0x1aea160c,0x306e250b,0x38783689,0x306335f7,0x1ca428ee,
0x000a0e1d,0xec91f2ad,0xecefed13,0xe8baebbc,0xe766e66a,0xe341e5c7,0xe1dee461,0xd74bdb69,
0xd90cd5b2,0xeddde263,0xfd0cf853,0xf6f7f9a5,0xf856f8bc,0xfafaf7db,0x0dcf02a2,0x143c13ac,
0x0e48134c,0x0b030aff,0x011f0637,0xfa2afeac,0xf582f864,0xefedef9c,0xf968f4a5,0x081d015b,
0x0b14096f,0x0c590cb4,0x124d0ddd,0x26441afe,0x33bc2e07,0x362b37a3,0x2b393247,0x0f0f1e14,
0xf4d4ffce,0xef35f20b,0xeb6ceb70,0xe684ea34,0xe5e5e547,0xe54ce64b,0xda77dff8,0xd383d722,
0xe38ed72f,0xf5e4ef05,0xf7a8f768,0xf75df9a1,0xf66cf3ea,0x02d9fa5c,0x11af0e44,0x112a11b1,
0x0d590e38,0x04b00b77,0x004a0138,0xf819fc04,0xef1ff42e,0xf475ef5a,0x0058fa68,0x080d041f,
0x0a320bb2,0x0bc408bd,0x1a4d10ed,0x2bc7246f,0x361132c7,0x35823652,0x1cce2ce8,0x03d80f09,
0xf2f1f95b,0xee08ef71,0xe88ced4a,0xe7b4e602,0xe6dae76b,0xe131e600,0xd38fda88,0xdc1ed283,
0xebdde4d2,0xf793f44c,0xf992f8ae,0xf2aaf566,0xfb5ff5dc,0x0e310531,0x106c0f9d,0x105d1253,
0x0b100ded,0x03c3066a,0xfe4a01b9,0xf276f980,0xf29bef58,0xf954f540,0x0434ff57,0x0a1608e9,
0x07e0079c,0x0fc20a98,0x240a1a74,0x305f2900,0x39d037d3,0x2b703621,0x13521f09,0xfac30549,
0xf2b8f6b1,0xecc4efc5,0xe8c0e92d,0xe79de72b,0xe80cebbc,0xd840de59,0xd532d422,0xe340dcba,
0xf3d9eaf6,0xf8cdf789,0xf2a5f80f,0xf64df114,0x0442fce4,0x0e230ab4,0x11981125,0x0ef01062,
0x06dc09eb,0x035c06c8,0xf848fdf5,0xf129f2a3,0xf3a6f247,0xffb3f93b,0x07d70331,0x05270914,
0x097704ba,0x189510a1,0x269b1e7c,0x37c23210,0x364e38f7,0x215f2d0d,0x069c1347,0xf8c3ffca,
0xf247f2a0,0xe7b4ee50,0xe960e743,0xecd9ec02,0xdcf6e5b3,0xd4ebd86b,0xdc1bd5f7,0xea0ce1f0,
0xf7e1f3b5,0xf452f7dc,0xf2c8f145,0xfbcef5dd,0x08a103dc,0x117b0ce4,0x0f7c11a2,0x0a7d0d64,
0x08b30a08,0xfe3e02d5,0xf2dcf977,0xf291f108,0xf867f3b0,0x04b8fef8,0x045c07df,0x069b02cc,
0x0e1409bd,0x1c9814c0,0x308427a5,0x3b4d3610,0x2c4237a8,0x16d422ac,0x01650966,0xf6f1fb7f,
0xec01f331,0xe9fae74d,0xee20ecc1,0xe527ecb2,0xd912ddab,0xd6e7d63f,0xe0e9d9a0,0xf389ec39,
0xf6a1f64e,0xf0f1f310,0xf6eff3cd,0x0235fbc0,0x0e16078f,0x0f7311c6,0x0f360e7b,0x0bb20cd6,
0x04c809c6,0xf987ffc8,0xf303f4ef,0xf287f033,0x0086fad8,0x042d03be,0x051502f3,0x061a05ea,
0x14260d22,0x251419d7,0x3673302a,0x36a839c5,0x24602e23,0x0b0d16b1,0xff37057f,0xf19bf854,
0xe8f2eafa,0xee2aeafa,0xeabdef77,0xdf9fe3d7,0xd4fad9ed,0xd91bd599,0xec0fe11f,0xf418f26c,
0xf0a4f379,0xf451f15f,0xf97bf49d,0x07f001db,0x0e900ca8,0x0eda0e44,0x0d4f0db7,0x08b40d74,
0x017d0423,0xf4eefb4c,0xeef6f00a,0xfbbef601,0x013cfd12,0x01da03fa,0x0489026d,0x0ac605ff,
0x183a102c,0x2de2248d,0x39c634c7,0x2e5c3733,0x179822cb,0x08c90fd0,0xf9d300f0,0xea45f0bf,
0xed9aeb6b,0xeebbee87,0xe513eafe,0xd957e060,0xd546d4a1,0xe2a3d8de,0xf03ced1d,0xf270f13e,
0xf178f198,0xf3e3f15b,0x00e6faf3,0x0ce706de,0x0d040d10,0x0f100ef9,0x0c560edb,0x07ee0839,
0xf9800453,0xf236f31b,0xf61ff220,0xfdadfaad,0x01870122,0x03520152,0x03da0330,0x0f5e08be,
0x22311807,0x36e42c8b,0x359a3a2a,0x241c2e3d,0x143f1a15,0x02290cbc,0xf194f99f,0xee27ed3e,
0xef27ee83,0xeb35ef97,0xe17fe6a2,0xd37ed8b4,0xdb17d4fb,0xea66e461,0xf251ee3a,0xeff6f172,
0xf09af0da,0xfa83f399,0x070e00bb,0x0a250ab1,0x117b0dea,0x0cc40e22,0x0c600df4,0x02570939,
0xf53ff9fe,0xf2c0f265,0xfaa3f785,0x0004fd04,0x02bd01a7,0x0098018d,0x07f303df,0x15710be9,
0x2c282131,0x397036c1,0x2d7f3421,0x1dd32535,0x0d9017d0,0xfa8402bc,0xeef4f262,0xef37efbc,
0xefebefef,0xe920eda8,0xd68bdf08,0xd635d533,0xe35adacb,0xedabe933,0xf023f137,0xefd2efcf,
0xf34aee08,0xff46fbc8,0x08b50345,0x0e0f0bec,0x0d220dba,0x0f4f0f8a,0x099a0d17,0xfa570252,
0xf2fff4ff,0xf77ff52f,0xfd61f8ae,0x008e00f6,0x0156015a,0x0281002c,0x09340509,0x20021397,
0x36592c62,0x32a036c4,0x275d2e63,0x1a042155,0x04130ec0,0xf477fa9e,0xef30f24f,0xf2d0ee70,
0xee79f32f,0xde9ae81d,0xd679d7fd,0xdb35d5ed,0xe743e336,0xf1b7eca6,0xed85efd8,0xf05bedc6,
0xf889f538,0x0476fd22,0x0a4c08d9,0x0ce50bfb,0x10940ee5,0x0f811033,0x01420ab2,0xf7b4fb52,
0xf4f4f408,0xf961f77f,0x0009fd99,0x01f80040,0x000d0110,0x019a0158,0x12df0704,0x2c3a1fba,
0x348833df,0x2e6f32ab,0x25fa29fc,0x0e881b8e,0xfe36069b,0xf1e4f613,0xf1a2ef61,0xf38ef5df,
0xe921eec2,0xd8f8df15,0xd7a1d7be,0xe11cdad8,0xeecbe8bf,0xecb3ee9f,0xef24ee1f,0xf359f037,
0xfe98f7b7,0x064a0456,0x0b8d094f,0x0eb60b71,0x1150127a,0x0a4a0f0b,0xfd120259,0xf45cf7c0,
0xf721f5e0,0xfd35f970,0xff96fe3f,0x008b0170,0xfe00ff4f,0x06b6fec7,0x1de511b7,0x310b2b75,
0x31d530b0,0x2bf8309b,0x1b862622,0x0a2611da,0xf5c9fe7a,0xf14af2b6,0xf642f343,0xef28f4c6,
0xe01be6e7,0xd755dc22,0xdba6d5dd,0xe8cde2ff,0xec2eebf5,0xee62ed84,0xeef0ece0,0xf758f3fd,
0x042dfdb5,0x079605aa,0x0ba9094e,0x126f10a3,0x0ff01149,0x03800a7d,0xf809fdd8,0xf703f5ce,
0xfa3df7e4,0xfd4dfbdb,0x023e0173,0xfe08ff08,0xfc52fc2e,0x123205e9,0x28ea1e50,0x30722d35,
0x30f033ac,0x277b2c3c,0x14eb1eec,0x00050a6b,0xf31af83d,0xf7ccf368,0xf3c8f7e4,0xe941ef57,
0xdb15e1fd,0xd7fcd605,0xe200de7e,0xec3de6fb,0xecc4ec6b,0xecb0ed74,0xf24aeed8,0xfe9cf729,
0x03ae0289,0x08c60675,0x10ce0c49,0x121211eb,0x0a661026,0xfda90450,0xf7eaf78b,0xf6cef871,
0xfbdff97a,0x0185fd83,0xfeb301cf,0xf7f2fb5b,0x06a1fb88,0x1b0c1110,0x2c57251d,0x315830a8,
0x2e4d302a,0x1fcf282b,0x0bb7174e,0xf861ff59,0xf667f5c0,0xf627f81c,0xf254f4bb,0xdfe2e8d6,
0xd75bdb14,0xdce4d87b,0xe744e176,0xeaf6ea82,0xebe3ec94,0xedcceb25,0xf725f1a1,0xffa5fd2e,
0x053001fd,0x0ca50769,0x10b41068,0x111812e7,0x03e70987,0xf934fe33,0xf764f872,0xf902f6f2,
0xfe80fab5,0x014702eb,0xf778fbdf,0xfcdef78c,0x0d90041a,0x23251973,0x2f332961,0x2f6830fc,
0x29db2e38,0x1891228a,0x00000a04,0xf736fbfb,0xf84af5a7,0xf6ddf8a9,0xe811f111,0xdb51e158,
0xd92dd77f,0xe09adc96,0xe975e666,0xeba8ead9,0xea8be9a0,0xf0d2ede9,0xfc2df73c,0x011afd32,
0x063b0495,0x10370b6f,0x138d128b,0x0a4b0fe4,0xfecf053e,0xf9b8fae0,0xf64bf815,0xfc16f764,
0x02d90200,0xfb0ffe8d,0xf6b3f7f9,0x0391fc0c,0x17620c12,0x287a20b0,0x2e3e2e35,0x31bd2f3f,
0x22c92c90,0x0c9317f9,0xfc2603af,0xf830f71d,0xf975fa42,0xf162f7a7,0xe27ae8ef,0xd8e3dbcb,
0xdb85da15,0xe6fde0f3,0xea69e870,0xe812ea65,0xee80ea71,0xf641f12e,0xfd4dfa60,0x01bf0023,
0x0bf105b3,0x1269105d,0x101112da,0x050e0ae0,0xfe51005f,0xf544fa76,0xf9e8f629,0x01defd77,
0xfddb0201,0xf697fa6f,0xfc89f6f8,0x0a040162,0x200116d6,0x2a36259a,0x32662e1e,0x2bcf3231,
0x1a8e24b0,0x05590e71,0xf993fd78,0xfb10faec,0xf8ddfb07,0xea29f107,0xdcabe447,0xdacbda20,
0xe1f6dc1a,0xe88ae722,0xe803e89c,0xeb0de8ae,0xf096ed10,0xfa3af64d,0xfe38fc07,0x065a0123,
0x0f4d0b7e,0x1331138c,0x0b390ddf,0x02f70874,0xf975febe,0xf82ff61e,0xfec7fabd,0x00f9030e,
0xfa33fc59,0xf6daf7a8,0x004df9cb,0x15710ba7,0x234f1b83,0x2e4929d9,0x318c326c,0x270f2d6a,
0x0ff91b45,0xfe760753,0xfd7efc2c,0xfc3bfcb4,0xf20ff91c,0xe4e6eb7c,0xdaa4de63,0xdde1da67,
0xe64de37f,0xe811e6f8,0xe7d9e7e6,0xec4ee973,0xf5f8f189,0xfb3ff78a,0xfed3fe05,0x0c4e0508,
0x1264106b,0x0e23108c,0x094f0d96,0xff190331,0xf64df973,0xfc9ef8d2,0x0169003c,0xfe35ff51,
0xf499fa33,0xfa1df54d,0x0a4500f8,0x19191152,0x27ac2246,0x32aa2da9,0x2eb531cc,0x1c4727f0,
0x081e113c,0xfe900137,0xfe7afea8,0xf93afd35,0xeda3f3a7,0xdde5e550,0xdbf9db54,0xe31cdf17,
0xe783e4e7,0xe55be7f8,0xea8fe738,0xf063ec1d,0xf776f535,0xfa7cf985,0x06aafe1f,0x0ea80c6d,
0x10b31113,0x0e5f0f7e,0x04d20a31,0xf7d4fded,0xfb3bf8af,0xffbdfbfd,0x00f801cc,0xf721fe19,
0xf65cf3e2,0xffa2f974,0x0efb07ef,0x1fc2171a,0x2cc72672,0x32e831ef,0x28182fc5,0x12a51d57,
0x02dd091e,0xffed0138,0xfe4dfea4,0xf5aefae0,0xe44bede4,0xddaedf82,0xded0dbba,0xe526e3e7,
0xe60de5f6,0xe770e599,0xeb6be8db,0xf4def1c4,0xf6f3f503,0xff0ef9bc,0x0a3805db,0x0ffa0e63,
0x11470f04,0x09df1053,0xfd310399,0xfa1ffa01,0xfbfef982,0x0232011a,0xfc0bffff,0xf42ef697,
0xf918f5d4,0x0532fe45,0x14bb0c95,0x24061cc7,0x31282bf7,0x310632bc,0x1d9328a7,0x0acb13bc,
0x02370548,0x000fff16,0xfb7200e4,0xee9ff4e6,0xe085e655,0xdcdedd61,0xe320e0c5,0xe5dce3a9,
0xe45ce59c,0xe8dce633,0xf1a3ed9f,0xf47af21a,0xf829f660,0x05a2ff1b,0x0c2d0917,0x113c0e1b,
0x0f69136e,0x04990949,0xfa93ff10,0xfa18f91b,0x01b2fd99,0xff520233,0xf659fae4,0xf5fcf542,
0xfdf3f855,0x0a1003a2,0x1a3c12d2,0x2b352202,0x33d5312b,0x27b43146,0x17481eca,0x055f0cc1,
0x01d402f4,0x007a022a,0xf74afbbb,0xe62fef6b,0xdeece1cc,0xe0e1de93,0xe501e262,0xe297e549,
0xe6a8e3f6,0xedb4e902,0xf16df0c4,0xf462f2b0,0x0006f950,0x0607036b,0x0f9e0af2,0x122711ca,
0x0aff0f5b,0xff3205d5,0xf965faa9,0xffbbfb2d,0x00d901ff,0xfaafff2f,0xf5a6f64e,0xf7fff5df,
0x01a4fd27,0x1094083a,0x203516cb,0x31182ba7,0x300e3228,0x21962962,0x0caa1734,0x04b6081b,
0x032a026a,0xfe04019a,0xee55f785,0xe366e853,0xdf66deb2,0xe312e1fc,0xe34ee422,0xe39fe26c,
0xe9d1e5ee,0xeee8ee04,0xf18bee76,0xf992f5c5,0x00d3fd58,0x0b4005c2,0x11820eb9,0x0fcf1223,
0x05b30c64,0xfb69fe33,0xfca8fb15,0x01e200ae,0xff1b00eb,0xf69cfa10,0xf54af693,0xfcedf71a,
0x05a400a3,0x158a0cdc,0x29b8214c,0x32ae2e68,0x2a2230dd,0x179421b7,0x09950fc0,0x04cd0486,
0x0251057f,0xf819fe3f,0xe8f3f033,0xe06de356,0xe248e10d,0xe3fbe31a,0xe0a3e259,0xe7a2e342,
0xec19eac5,0xeec5ec26,0xf4c2f27b,0xfbbff7fb,0x05e4ffb7,0x0d4c0a95,0x1357119f,0x0cbf110d,
0xfe9b0531,0xfbfcfcf5,0x023dfdb4,0x00dd023e,0xfae0ff6f,0xf5baf7a4,0xfa01f5fc,0xfd2dfb97,
0x0bed03cc,0x1f511544,0x2fde2798,0x30043347,0x23f42b27,0x10a619d0,0x07b60ad1,0x0686072a,
0x0088043d,0xf120f9ab,0xe558eab7,0xe26ee1d6,0xe4a7e430,0xe024e2c0,0xe5e7e1c3,0xe9cfe7e9,
0xec1aeb12,0xf20defa3,0xf6daf2dd,0xff54fb84,0x08b304ce,0x13350cfc,0x10e713cc,0x04ef0cec,
0xfd41ff16,0x0012fd5c,0x01ef0188,0xff3802f6,0xf7a5f9b2,0xf843f726,0xf859f88e,0x02e1fc56,
0x128c0957,0x27431dcc,0x31bb2e15,0x2c863104,0x19e7240c,0x0c77125a,0x088308a7,0x05a5085b,
0xfa38012b,0xeb8ef2ce,0xe40de535,0xe466e575,0xe128e2b1,0xe31ce036,0xe652e5ff,0xeafae8e1,
0xef0fec03,0xf1a4efde,0xf9c9f6ec,0x02defd25,0x0d9a07b0,0x13a81286,0x0b331231,0x008103ac,
0xfdaffe58,0x020cff87,0x021803e2,0xfa22fd00,0xf81df993,0xf733f6d6,0xfaa1f820,0x073fffc1,
0x1b73114f,0x2d4a2480,0x307831e4,0x240d2bf1,0x13301af6,0x0aa10d10,0x086f0a4e,0x0341068c,
0xf277fafa,0xe70dec0f,0xe64fe6cc,0xe20de2d2,0xe0e1e133,0xe442e368,0xe972e5b3,0xeb13ea38,
0xef0ced61,0xf4d3f252,0xfcd6f7b8,0x062600fe,0x13370def,0x104c13c3,0x056f0a82,0xfd950114,
0x01d9fe0d,0x02620370,0xfdf8008a,0xf999fb6c,0xf7cff80c,0xf601f6e7,0xfed6f947,0x0e870579,
0x238218d6,0x307d2c99,0x2ccd305a,0x1b572402,0x0e78152e,0x0b5e0b8e,0x090c09dd,0xf9fb03ca,
0xedc4f31a,0xe8d1e9de,0xe2e4e564,0xe14be2bc,0xe206e110,0xe734e408,0xe89ee82e,0xece0eb45,
0xf157ee3d,0xf6eef48d,0xff0df9ee,0x0ed90718,0x124f121f,0x0bc01107,0x0008046d,0x00d9ff01,
0x026e026c,0x011702a4,0xfbcffdaf,0xf8befab0,0xf57bf721,0xf8c6f583,0x02cafc52,0x16ec0d77,
0x2be721a3,0x30022fcd,0x23dc2c31,0x15ef1d38,0x0d530eb6,0x0ce90d3a,0x02ba0a91,0xf4e3fa85,
0xec65f016,0xe5b0e890,0xe2bee4da,0xe176e0a4,0xe473e31a,0xe814e662,0xea27e915,0xef0cebf2,
0xf2b2f242,0xf957f3b8,0x07290068,0x11bf0d2e,0x10f31408,0x046609ba,0x008a01f5,0x030f0194,
0x02d702ee,0xfe9900c2,0xfaddfe10,0xf81bf859,0xf4f6f57e,0xfacef7e2,0x0b2201dd,0x21ae14ea,
0x2ec22af7,0x2bfa2fce,0x1e25258b,0x106e157c,0x103a0faa,0x09da0f36,0xfd1502a0,0xf174f766,
0xea8ced75,0xe495e73e,0xe1bee2ec,0xe2e1e1f3,0xe7bee510,0xe732e78e,0xedd8ea0e,0xefbcefca,
0xf459f04f,0xfe7bf9bd,0x0e4e05f8,0x138b128d,0x09750fbe,0x023f0583,0x03bf0152,0x02790326,
0x016303a1,0xfe28ff90,0xf9fbfb2f,0xf4b6f7d4,0xf67cf539,0xffeef945,0x147308e9,0x28802027,
0x2f6f2de2,0x26292c8f,0x15681cf9,0x12eb12ed,0x0eac1166,0x04280a95,0xf815fdc6,0xef57f33d,
0xe774eae9,0xe337e5b9,0xe199e0d9,0xe5efe44b,0xe4dbe5a3,0xebe2e7e8,0xed60ec66,0xf006ef13,
0xf725f310,0x06ecfd08,0x11660da4,0x0e641338,0x05d408b2,0x03150319,0x02c0038c,0x033103a7,
0x005d0134,0xfc23fe8d,0xf74afa10,0xf49bf583,0xf7b8f4a7,0x0789fe24,0x1d7712bf,0x2d952641,
0x2bb83057,0x1cd323db,0x151617be,0x126c13a4,0x0aed1033,0xff5a0456,0xf45ffa3f,0xec68f00a,
0xe58ce94b,0xe1e5e17d,0xe400e4ac,0xe4d5e3c5,0xe90ee5e1,0xeb35ea69,0xee0cee2a,0xf19bedec,
0xfcf7f5a6,0x0d4a066a,0x116f11d6,0x09770d07,0x03e4063b,0x03cd03da,0x038203b7,0x027902f0,
0xfeff0138,0xfabffcb6,0xf5d2f824,0xf319f3f1,0xfde8f6a3,0x0f7005d0,0x26de1b65,0x2e5b2ddb,
0x244229e1,0x18c61e13,0x15e516f7,0x1051138a,0x06940b72,0xf9cd014b,0xf3bcf5e5,0xe878eda3,
0xe391e529,0xe39fe4d3,0xe489e24c,0xe5ebe535,0xea0ae88a,0xed47ec05,0xed78ecb2,0xf46cef92,
0x0628fd3f,0x104f0cdb,0x0d33101a,0x06330951,0x04d004f0,0x03860410,0x037903c4,0x01aa030a,
0xfd3fff06,0xf8f9fc2c,0xf297f49b,0xf6e5f388,0x0222fb3c,0x1b430e0f,0x2c1c2560,0x28f72cd8,
0x1dd823f7,0x198c1ada,0x13db1583,0x0ccf1292,0x00b4069c,0xfa14fc62,0xeca0f3be,0xe746e9c0,
0xe437e53d,0xe37fe2e9,0xe485e435,0xe7fae61e,0xec2eea12,0xeba9ecd0,0xee31eb4b,0xfd10f491,
0x0bcf051a,0x0eed0f98,0x09350c06,0x05c2070b,0x0402054a,0x04990383,0x028e0484,0x000800e4,
0xfc40ff65,0xf50bf728,0xf2faf410,0xf84ff4a7,0x0d5e00a1,0x23fc18cd,0x29eb2b4a,0x241c26f1,
0x1bf41f7f,0x16e91892,0x125a1710,0x07010b68,0xff51033d,0xf33ef9c9,0xeb16ee94,0xe5c8e7fa,
0xe361e452,0xe3e1e35c,0xe565e422,0xeab6e7cc,0xeb27ec3b,0xea22e98a,0xf3a7ed6d,0x04b1fc7f,
0x0e140ab0,0x0b2f0da6,0x07f609a7,0x04a20602,0x05600400,0x02c20525,0x02d802f0,0xff510127,
0xf877fb28,0xf328f741,0xf3a7f1af,0xfed6f65a,0x18be0be9,0x27472343,0x280f27f9,0x1edb2437,
0x1b061be9,0x16721a03,0x0ce3113c,0x05130963,0xfa840016,0xefe0f49e,0xe916ec32,0xe4dde67b,
0xe3dce417,0xe325e31a,0xe8d3e5b4,0xeb80eac2,0xe80dea28,0xeccee90a,0xfc3af34c,0x09ae03f1,
0x0bdf0c39,0x0a6d0c4e,0x060a0697,0x055e05bf,0x038a057b,0x054703ad,0x00be02c5,0xfc61ff9b,
0xf6b0f9c6,0xf1acf394,0xf435f06f,0x0b7dfee3,0x1f731671,0x287525f3,0x2211266d,0x1e5d1f55,
0x19c01cad,0x125a163b,0x0adb0ea0,0x012d0647,0xf5f8fb7e,0xed54f189,0xe7a3e979,0xe453e673,
0xe2c1e350,0xe65ce33b,0xeaf9e932,0xe89feb12,0xe809e783,0xf3ffeb2a,0x01e3fc59,0x0b4f07eb,
0x0c440c87,0x0708085f,0x0649081e,0x04c104cd,0x055c04ed,0x032f0465,0xff9c022e,0xfb5bfcd0,
0xf336f884,0xef18eec3,0xfde1f4fa,0x13f00836,0x24f21eed,0x240525af,0x20f62236,0x1d0d1f8a,
0x16d419ff,0x1017134b,0x070f0c56,0xfd8e0286,0xf241f727,0xeaf3ee18,0xe6bbe957,0xe30be4a9,
0xe463e1cd,0xe8e1e76e,0xeb0debbb,0xe612e73d,0xec4ce704,0xf9b1f424,0x07d70078,0x0b7c0b45,
0x09a50a7e,0x0774091c,0x058805bb,0x0501054e,0x05df059c,0x014103f1,0x000d001f,0xf784fd9f,
0xef0ef188,0xf35befc6,0x070bfb35,0x1d9213c7,0x235c2217,0x22a72393,0x2074220b,0x1a581cbf,
0x14721807,0x0cc81106,0x048f08cb,0xf887fe09,0xeec5f3b6,0xeadced4b,0xe491e65d,0xe218e2c0,
0xe735e49e,0xec18ea7d,0xe5a3e903,0xe7e5e5b0,0xf158ebb5,0x00fdf906,0x08ee0636,0x0af20ab0,
0x08560982,0x065e07c0,0x04b504ce,0x06f7065e,0x020b04a9,0x0314023c,0xfc94010d,0xf263f721,
0xedd1ef53,0xfac1f16d,0x123b0624,0x1ee61b06,0x2309218b,0x2263230b,0x1d791f87,0x17d81bba,
0x1219154d,0x0a810d33,0xfe8805b6,0xf4aef94a,0xeeb0f12e,0xe744eacf,0xe219e4c0,0xe503e1bc,
0xeafee932,0xe7d5e9cb,0xe570e676,0xea9ee5ff,0xf8c7f1dd,0x049efeed,0x09ff08b3,0x09ba09c3,
0x079609b1,0x052e04cb,0x074c0746,0x0375059c,0x04bd0381,0x0102035f,0xf81cfdcc,0xee56f2c9,
0xf121ec69,0x05d2fa3e,0x172f10c8,0x21121ce3,0x22fd21bc,0x1f96226d,0x1c6b1e6a,0x15eb18c2,
0x0fb712dd,0x05e50bf5,0xfac1ff8e,0xf2aaf690,0xecafef98,0xe3a1e85e,0xe3d4e199,0xe8e6e712,
0xea25e9e6,0xe526e83b,0xe674e429,0xf0c3eb04,0xfec8f74d,0x0673041d,0x0af00906,0x08570a7f,
0x05f00599,0x074b0810,0x053b05e8,0x05100459,0x03ca04e9,0xfe8a02ba,0xf2b7f920,0xec30ec19,
0xf9a6f1ef,0x0e100453,0x1b4e14ed,0x21531fb6,0x21b32213,0x1edb2093,0x18e71c08,0x148516ce,
0x0be010ae,0x014506c1,0xf6f3fb62,0xf21df4cb,0xe6a1eca7,0xe332e390,0xe6a3e448,0xeac5e923,
0xe663e9a1,0xe467e4d2,0xe9bae526,0xf71ef068,0x00aefcd8,0x0a9305dd,0x083e0a1a,0x066a06bc,
0x072d07d0,0x060b062d,0x04ec04bd,0x042d0568,0x048d04d6,0xf85eff63,0xebfdf121,0xf16cec4d,
0x0225f906,0x13650b68,0x1d9a19c2,0x21571fa4,0x20a2220d,0x1bed1df3,0x18111a8e,0x118f14b1,
0x07930dee,0xfc9a0099,0xf700fa33,0xec27f21b,0xe4a1e7cb,0xe514e2e1,0xe98fe83f,0xe8e9ea37,
0xe4cfe6ff,0xe4e6e23f,0xefedeb06,0xfa2ff4e2,0x076400eb,0x081808d3,0x06cc07cb,0x082d078f,
0x05f00652,0x05600673,0x04db046f,0x06f205de,0xfff6059f,0xf0abf7dd,0xed05eca7,0xf7a1f0eb,
0x0a0c0069,0x174411f8,0x1f5c1b6c,0x210e21ad,0x1ecd1f7f,0x19fa1cce,0x16be1868,0x0da81376,
0x029706ad,0xfb5bff96,0xf337f7f8,0xe7bfecff,0xe475e3f0,0xe786e6c8,0xeb0fe992,0xe614e971,
0xe2f6e295,0xe993e6f8,0xf35fed41,0x014bf9f7,0x0715068b,0x07dd06d5,0x077d0800,0x071b0752,
0x065706ec,0x043504f4,0x07e5056f,0x067b0900,0xf7dbfffd,0xeddaf180,0xefeeed16,0x0038f6f6,
0x0ebc0814,0x1b0015c2,0x205e1e10,0x207e20e5,0x1b5b1e5f,0x1aef1b61,0x13041760,0x08750d63,
0x001b0465,0xfa56fdb8,0xed08f378,0xe5afe833,0xe57de56b,0xebc1e838,0xe77eeac4,0xe39be52f,
0xe65be41e,0xeba0e815,0xfa7ff2cb,0x03cf0036,0x06f305cb,0x07b107ae,0x07b7075a,0x07520813,
0x041e05be,0x06b70441,0x09f609a2,0xffbb061e,0xf2aff983,0xed61ed62,0xf6a1f0b8,0x058cfe1a,
0x14360dfa,0x1d59181f,0x209920b2,0x1d581f22,0x1d991d90,0x180a1acf,0x0e111404,0x0564091c,
0x003d031c,0xf3ccfa00,0xe9d7ef49,0xe568e56e,0xea18e78d,0xe997eb72,0xe57ee6a1,0xe42ae511,
0xe6bfe424,0xf2f3ec03,0xfea2f985,0x055502a2,0x06a7066d,0x079406cf,0x0860088a,0x048c0720,
0x05e30337,0x09d10892,0x06d80a14,0xf977012a,0xeed6f1d7,0xefc0ee58,0xfd3bf59c,0x0b6104d6,
0x17e210db,0x1eba1d73,0x1e631ecb,0x1e2e1e0f,0x1c0e1d5b,0x13521973,0x0af20d65,0x03da0836,
0xfbb50018,0xef6af5da,0xe5bce941,0xe9b9e6bd,0xe9aeeab4,0xe79ee879,0xe499e689,0xe33ee2a2,
0xebd7e6a3,0xf7d2f1f3,0x0217fdc5,0x059c0402,0x0627059e,0x098c08dd,0x057f07c9,0x04c403ab,
0x081d068a,0x0b740b31,0x00dd0731,0xf3d9f9a6,0xed3cef77,0xf5e7f02c,0x01fdfb89,0x10860927,
0x1b181744,0x1e9c1d09,0x1d221dee,0x1f9d1efd,0x17da1c65,0x0faa13a1,0x08dd0c58,0x01d80516,
0xf6cefded,0xe92aee89,0xe92ce7e7,0xe973e9ff,0xe938e955,0xe683e8c1,0xe25ee31c,0xe5ece353,
0xf0b6eb61,0xfd39f675,0x02c8012d,0x0497036e,0x09b80822,0x06f40847,0x0414055a,0x0618043d,
0x0c4609ec,0x07540aab,0xfa8c021a,0xef5ff39b,0xf0f8ee96,0xf8e4f41c,0x083300b2,0x15090e2c,
0x1bf61a92,0x1cda1bc4,0x20001ecc,0x1bca1f2d,0x14cf17f4,0x0c6710be,0x075c0966,0xfe4704b2,
0xeef9f5dd,0xea54eae8,0xe8b6e9dc,0xea41e9a5,0xe90ae9c1,0xe2c9e5d6,0xe305e23f,0xe9c9e5e8,
0xf708ef3a,0xfecefcaa,0x02db0087,0x082905f6,0x087e0895,0x042d0725,0x04f80335,0x0a25075f,
0x0bba0bec,0x027f0917,0xf4cafa10,0xef18f1b6,0xf3a7ef87,0xfe7ef8c2,0x0e2a0628,0x1866147f,
0x1ad61982,0x1fa61da3,0x1e461fef,0x19a91c35,0x105a14d5,0x0bd60d89,0x05cd0ab2,0xf698fd5e,
0xed03f0f2,0xe99eeb45,0xea32e953,0xeb0bead2,0xe554e8c7,0xe2e1e3c6,0xe44be261,0xf069e944,
0xf9def68c,0x0031fcfb,0x05380264,0x09630858,0x05b2084b,0x03f00381,0x066c0522,0x0d970a08,
0x07bc0c93,0xfc260266,0xf19ff589,0xf00defd3,0xf649f259,0x0596fd28,0x12640d29,0x17ef14fa,
0x1d491b7f,0x1f7b1ed4,0x1da11eb8,0x13391912,0x0faa10a4,0x0b360e79,0xfe5004f9,0xf23df7e2,
0xeb60ee7a,0xe9dee954,0xeb13eb01,0xe82eea06,0xe42fe683,0xe10ee120,0xe9b2e4db,0xf490ef24,
0xfbb5f889,0x0129fe3c,0x08f205b3,0x069b0877,0x046e060c,0x043a0287,0x0b2b07f4,0x0c490d17,
0x033108e8,0xf71dfc5b,0xf0e5f343,0xf04eefdc,0xfdcef5a3,0x0b0b04b2,0x13670fb5,0x1a9817f6,
0x1ea11c0e,0x208320be,0x178b1ce9,0x12db143b,0x0fec11a7,0x05a50bce,0xfa08ffb1,0xef52f463,
0xeb25ebb5,0xeb38ebe5,0xeb53ead9,0xe6b6e9e5,0xe120e336,0xe512e1f7,0xeef4e979,0xf725f47a,
0xfe0df916,0x053902c7,0x08c10782,0x053b07cd,0x034002e5,0x083d0534,0x0d760bd8,0x09da0d49,
0xfdb402f6,0xf4abf99e,0xeea4f0cb,0xf684f044,0x0313fd62,0x0e7f08d5,0x165e1379,0x1bec1857,
0x21371fc8,0x1bc31fc2,0x153f1759,0x13771492,0x0b9d109b,0x022f06df,0xf433fb23,0xed88efde,
0xeb3eec16,0xec03eb4f,0xea03ec6b,0xe372e5f9,0xe0b0e159,0xea6fe4e2,0xf158ee1a,0xf9a0f51e,
0x00b8fd3f,0x0822054e,0x06fb0896,0x02ff03df,0x048d039a,0x0ca8084b,0x0d0d0e41,0x043a090f,
0xfb3f0045,0xefe3f4fb,0xf1a7eea3,0xfb2ff656,0x08500175,0x11130d71,0x179e13ff,0x202f1c8b,
0x1ebd2107,0x17a51a46,0x16201757,0x109f1359,0x08d80dac,0xfba90291,0xf1d3f580,0xeb9cee91,
0xecd9ebf3,0xec4aec72,0xe6a3eaaf,0xe042e1f3,0xe5afe2c8,0xeccbe89e,0xf45ff06f,0xfb84f829,
0x05e500da,0x07710780,0x04290653,0x028c0291,0x098e0505,0x0dbd0d10,0x099a0c23,0x023906de,
0xf4a9fafd,0xefecf11f,0xf4c9f166,0x014efa5d,0x0b4306fd,0x12420ec4,0x1d4a174c,0x1f5e208b,
0x1b191ce1,0x17f21946,0x13ed1640,0x0f2d1292,0x038308fb,0xf773fdd2,0xef17f22e,0xec31eda4,
0xeeacec7b,0xe9ccedcd,0xe218e583,0xe31ae1b2,0xe827e4a0,0xef4fec85,0xf697f239,0x00c2fbaa,
0x06b804a2,0x05de074b,0x017d032f,0x0649024a,0x0b900a3f,0x0cd90c58,0x07ff0bbc,0xfb3501b2,
0xf1d6f60e,0xf092ef99,0xf9d0f458,0x05990057,0x0ba00814,0x17c811c7,0x1e711caf,0x1cea1d5e,
0x18c81b7b,0x17011762,0x12a015e0,0x0b200ee6,0xfdaf049d,0xf3b4f8d8,0xece7ef25,0xeebfecc4,
0xeceaefb7,0xe5fee91b,0xe167e2fc,0xe52de273,0xeac7e853,0xf14aed42,0xfb0ff5eb,0x03ebfffe,
0x07a00731,0x01a60495,0x04090181,0x08a106f0,0x0d450aa0,0x0c550e6e,0x030c081f,0xf72ffcba,
0xef70f2f1,0xf514f03b,0xff98fa8b,0x05540289,0x12390b36,0x1af6178f,0x1e9b1d6c,0x1a3b1c7f,
0x18d01a05,0x168c1745,0x10461442,0x05e70b8c,0xfaaa0084,0xef20f3c9,0xef56ee88,0xef3cefca,
0xea28ed3a,0xe286e5bd,0xe360e21e,0xe767e587,0xec74e912,0xf4dcf0d9,0xff42f973,0x072604e0,
0x02af0588,0x033801e4,0x05770415,0x0b15087d,0x0f0d0dcf,0x08a10c74,0xfe87044f,0xf230f831,
0xf187ef52,0xfa9cf66f,0xffa4fc88,0x0ac20580,0x167d1008,0x1c461abc,0x1c2f1cdd,0x19d51adb,
0x188118da,0x144417c8,0x0cf4101c,0x01d90893,0xf3f5f9e8,0xefdbf123,0xf098efe8,0xedcef006,
0xe551e9bc,0xe337e325,0xe478e3e5,0xe902e618,0xef16ec17,0xf90cf2af,0x043d00b6,0x0432049b,
0x026b02c8,0x032202ec,0x081e04dd,0x0e170b99,0x0ca10e42,0x05e809d7,0xf70dffca,0xf1a6f140,
0xf581f3bf,0xfb94f877,0x0378fe99,0x0fbf0982,0x18fa1576,0x1cac1b55,0x19fa1b9d,0x1a5019bf,
0x16a1198c,0x12841423,0x094c0f14,0xfaa901e9,0xf1f2f548,0xf0e5f0aa,0xf0b7f1a7,0xe93eed20,
0xe491e647,0xe2f4e3d9,0xe724e407,0xe972e854,0xf2b2ed15,0xffaff9c9,0x039c029b,0x034503b4,
0x01c50260,0x04b202ba,0x0bfc0828,0x0d220d20,0x0cbe0e4b,0xfe610613,0xf3b5f7e5,0xf3d8f2e9,
0xf7d6f5a6,0xfd15f9a3,0x08e202ca,0x13bf0e84,0x1b7418b5,0x1a5e1b06,0x1b4f1afc,0x188b1a5f,
0x15e8171d,0x1040140d,0x030f09f4,0xf611fc21,0xf26ff324,0xf30bf2f4,0xecd1f01f,0xe792eac9,
0xe35be45a,0xe5b9e436,0xe6aae662,0xeccde85f,0xf96ef36d,0x01a4fe1b,0x033a031c,0x02020354,
0x02f80094,0x08030677,0x0cee09ef,0x0ff40f80,0x060e0c58,0xf8d5ff2a,0xf468f51b,0xf59bf52f,
0xf8d2f610,0x0182fd32,0x0d7b06d1,0x178313e4,0x1a1018f3,0x1bba1afd,0x19741b32,0x183e18ce,
0x152916eb,0x0b0f1106,0xfc260427,0xf520f67b,0xf3baf4d1,0xf0cff237,0xeafbee97,0xe490e734,
0xe583e45a,0xe474e577,0xe81fe55c,0xf2faec54,0xfc33f8cf,0x03a50052,0x015b0333,0x01c7008d,
0x04ac03b0,0x09be0645,0x106d0dd0,0x0cad1001,0xfee0064e,0xf770f9de,0xf464f5d5,0xf66af494,
0xfae3f828,0x0664fff3,0x123a0d55,0x17b414ce,0x1aed19fb,0x19fc1b29,0x195e192d,0x174b188d,
0x12d9161d,0x03340bc0,0xf8defcb0,0xf50df697,0xf2d8f3d5,0xeeebf1f0,0xe715e9f6,0xe56ae644,
0xe4f2e588,0xe3d9e2fa,0xec99e7ed,0xf633f12a,0x00dffc35,0x0141021e,0x018b00bd,0x022b0229,
0x05bf0341,0x0dee097e,0x10c2112e,0x059d0bac,0xfc1b00d7,0xf5faf845,0xf568f4f0,0xf5eff56b,
0xffbbf9d6,0x0bc30605,0x138b0fcc,0x19f11788,0x1a0f1a24,0x19761a2e,0x18af186b,0x17e01983,
0x0bbd12f5,0xfee2041b,0xf6e7faf8,0xf5d1f595,0xf1caf423,0xea5ceea5,0xe777e7bd,0xe551e750,
0xe2e8e303,0xe76ee4d5,0xefbeeaa6,0xfc30f6a1,0x0047ff0a,0x016700ef,0x01a9015b,0x01ec0209,
0x0a73048b,0x11480f5b,0x0b680f7c,0x01ed073d,0xf94ffc8e,0xf63ff79b,0xf3f1f4de,0xf9a8f522,
0x0499ff91,0x0e7d0940,0x163a1336,0x1a40187f,0x19201a0f,0x186c188e,0x1b351a43,0x12761798,
0x05d50ce7,0xfb48ff83,0xf6faf88c,0xf551f67f,0xed8cf1de,0xe9d8eacc,0xe6a2e90b,0xe386e435,
0xe3e4e397,0xe9dfe576,0xf5a9f041,0xfe3dfa5f,0x0016ff59,0x01f5016f,0xffa60124,0x059c00ad,
0x0eb50b40,0x0f901033,0x07890c6c,0xfdd70246,0xf952fb44,0xf38cf673,0xf5ebf340,0xfdb5f945,
0x0855036e,0x11e50d29,0x188d152d,0x18d21a6c,0x188f176e,0x1afa1a32,0x189e1ac5,0x0d7113b6,
0x00f00725,0xf9c7fc36,0xf86af956,0xf0fcf506,0xed27ee77,0xe8b0eb81,0xe611e6c3,0xe2cee42a,
0xe588e366,0xefb6e9cf,0xf9cbf581,0xfe98fc56,0x02bd015d,0xff3d013c,0x01ecff6d,0x0ae90630,
0x10ab0eb6,0x0ccd102c,0x0350076f,0xfd930121,0xf6acf981,0xf411f449,0xf88ef5fc,0x0303fd35,
0x0b400749,0x165c10f6,0x18681887,0x17cf17ef,0x1ad118fc,0x1b641bdd,0x14dd18df,0x07b80f2d,
0xfdd00158,0xfbb0fcd0,0xf487f7e9,0xf071f2c9,0xeb7ced94,0xe80ee9c0,0xe44be642,0xe28ae2c1,
0xea1be4d3,0xf401f01a,0xfb7bf73c,0x0193ff9a,0xffd20126,0xff42feb4,0x056701f9,0x0fb90a4e,
0x0ef3110f,0x08600bfc,0x0258055d,0xf9c4fde6,0xf502f73c,0xf511f367,0xfce7f943,0x04fa005c,
0x10b10ab2,0x16d314f1,0x165e16f2,0x195f176b,0x1bb41ae2,0x1a1c1b69,0x0e461613,0x02ee06db,
0xfdcd009a,0xf826fad8,0xf34ff5b4,0xee52f0ae,0xea21ec45,0xe6e4e8a1,0xe0f0e399,0xe5b5e19b,
0xed91ea1a,0xf65bf1a6,0xffc8fb7c,0xff6c005f,0xfe4aff47,0x006bfddb,0x0af0054b,0x0fce0f38,
0x0c420ddc,0x06510a45,0xff4b0266,0xf6e0fb2f,0xf419f413,0xf822f607,0xff0ffb1b,0x0a590407,
0x13e5101d,0x1515154d,0x17be15cf,0x19b218cb,0x1d7e1c17,0x14f81ad7,0x091d0e73,0x018f051b,
0xfbc4fe9b,0xf640f8a9,0xf187f430,0xecb8ee7f,0xea5eec70,0xe2ace608,0xe2a8e136,0xe893e62e,
0xf0b7eb4b,0xfb42f6b8,0xffedfe7f,0xfe9dffa2,0xfcaafd2c,0x067c005b,0x0d490ac8,0x0e8f0eaa,
0x0a060cbe,0x04c607b9,0xfafdfff4,0xf51cf71a,0xf5a9f50f,0xf9acf709,0x0334fd7d,0x0f7c0a4f,
0x138c11c7,0x15a0152f,0x17af15fd,0x1d8f1aed,0x1a171d24,0x0f99153f,0x068d0a7a,0xff75035e,
0xfa45fbd8,0xf433f801,0xefb5f159,0xedfaeeff,0xe545ea27,0xe325e31f,0xe4c5e38b,0xeaf0e765,
0xf627f063,0xfe04fa4c,0xff6f0053,0xfb8dfcc0,0x016dfda2,0x09fa056f,0x0e520d73,0x0c8e0dae,
0x09790b66,0x0019055d,0xf833fba7,0xf5dbf612,0xf5a3f5dd,0xfd4ff7f7,0x08cb0383,0x110c0d09,
0x13ad137f,0x152913a4,0x1ba2186a,0x1d4e1d4a,0x14ae19f7,0x0c561085,0x03580764,0xfdb70036,
0xf7d3fb76,0xf21bf3a6,0xf094f25a,0xe970ed27,0xe43de5f3,0xe2c9e381,0xe6dfe3be,0xef30eae9,
0xfac8f475,0xfed6fec7,0xfc11fd52,0xfd45fbd0,0x056800b2,0x0c890a14,0x0d710ce9,0x0c550db6,
0x05fb09ef,0xfbef0086,0xf817f972,0xf3f9f5f2,0xf87ff4fa,0x01ddfd09,0x0ce40730,0x116b1076,
0x12f6122d,0x18991491,0x1d741c70,0x19a71c31,0x11ef15fe,0x07850d0e,0x02b9043b,0xfadaff5c,
0xf4ecf724,0xf36ff450,0xeccff09b,0xe780e9b9,0xe26be4b3,0xe470e2c8,0xe8b1e5e3,0xf51eee43,
0xfd5afab1,0xfcb0fd73,0xfaa3fb6a,0x0153fce8,0x08ca056d,0x0c9e0b2f,0x0dee0d50,0x0a7a0dbe,
0x00b2051d,0xfb61fdd2,0xf4f1f820,0xf567f46e,0xfbaaf74d,0x067f0142,0x0f350b89,0x0fd40fe6,
0x14dc11a4,0x1c4e1928,0x1b7f1c40,0x17331aae,0x0c6a1199,0x06a108ea,0xff37039b,0xf7c9fa88,
0xf5e5f72f,0xf068f30c,0xead6ee35,0xe475e6e8,0xe31ce36a,0xe40be30f,0xeeb2e84d,0xf9aaf49c,
0xfcd3fcb2,0xf9c6faf8,0xfcfafaad,0x04f60084,0x09b407f9,0x0e110bbe,0x0d7d0f76,0x05b70928,
0xfeee02c6,0xf8a8fb76,0xf413f5a8,0xf718f513,0x007ffabb,0x0b040630,0x0d520d97,0x118d0dfb,
0x188615af,0x1c361a74,0x1b121cda,0x117716d2,0x0b400d74,0x03490868,0xfbe1fe69,0xf7c4f9fd,
0xf446f60a,0xeecef233,0xe7edea9e,0xe402e637,0xe1fee212,0xe7e5e418,0xf4ffedce,0xfbb0f9e1,
0xfa5efb9f,0xfa3cf987,0x0130fd12,0x05b90421,0x0d1608d5,0x0ea20f08,0x0a530d4d,0x040006d5,
0xfc730053,0xf61af931,0xf4c7f472,0xfa1df643,0x06d60098,0x0a9b09d3,0x0e900bf9,0x1481119e,
0x1a2b1747,0x1d9e1cec,0x15b31a62,0x105b12d5,0x083c0cc6,0x005a03bd,0xfa26fd49,0xf7a9f86e,
0xf20ef5b0,0xec6bee9d,0xe68de9a3,0xe281e467,0xe304e180,0xee1ee79c,0xf8b1f451,0xfacbfaf3,
0xf8aff8dc,0xfe1bfba3,0x0250ff99,0x0917057c,0x0e8e0ce3,0x0d2b0e4f,0x08070acc,0x01a3053a,
0xfa2afd7c,0xf4a4f78f,0xf594f333,0x0102fb32,0x078b0500,0x0ba7094a,0x108e0ea5,0x171e12c2,
0x1d1d1b64,0x190d1bd2,0x149116e9,0x0ccf10ec,0x059c0932,0xfd4500f8,0xfa91fbe0,0xf554f80d,
0xefb1f298,0xea68ecff,0xe4a3e7a9,0xe0c3e1a3,0xe75ee348,0xf479ed27,0xf89ef895,0xf852f829,
0xfb68f981,0xfe6cfccf,0x0527016b,0x0c5a08fe,0x0d970e0f,0x0b710c97,0x052c08f3,0xff7101e1,
0xf6d5fbc3,0xf326f381,0xfbb2f654,0x0273ffc0,0x08d90595,0x0c430b1b,0x12f10e64,0x1b011806,
0x1abe1b49,0x176a19ff,0x117913f8,0x09de0e8a,0x01bd0538,0xfd2aff21,0xf8c3fb19,0xf2def640,
0xeeb1f003,0xe777ebc0,0xe21fe49b,0xe23ee06a,0xee63e78c,0xf682f3fe,0xf778f6e5,0xf98ef8a4,
0xfbfafaaa,0x00a4fdac,0x0954051a,0x0c960b89,0x0d9a0dda,0x08a90b38,0x04020637,0xfbcc010d,
0xf33df60a,0xf7aff482,0xfda9faa2,0x05a6019d,0x0886080e,0x0ebc0a2c,0x16be1399,0x1b401969,
0x19371ae0,0x1556176f,0x0e9812b4,0x06860a02,0xffbb02d9,0xfc77fe87,0xf61bf8d3,0xf1caf412,
0xec59ef3a,0xe4d0e8d0,0xdfb4e127,0xe87ce297,0xf26eee42,0xf601f4d9,0xf84ef6e8,0xf9f8f9da,
0xfd22fa27,0x04a00129,0x0a9807c9,0x0df60cdf,0x0a840ce0,0x082d08cd,0x012e063c,0xf637face,
0xf5b6f4ee,0xf8dff6be,0x023afd92,0x0520041d,0x0a450758,0x12640e14,0x19661646,0x19c91a46,
0x186219bd,0x13121590,0x0aa70f97,0x042c0697,0xff3301e4,0xf9a5fc75,0xf4d3f72a,0xf0aaf28e,
0xe979ee0b,0xe06ce41a,0xe381e07c,0xee20e86f,0xf314f192,0xf7b8f548,0xf87df8a0,0xfa6cf8bb,
0x0077fd53,0x06f40387,0x0d5e0add,0x0b8d0d17,0x0b180ad1,0x06a60a86,0xfb4f003f,0xf5c4f887,
0xf681f48c,0xfdeffa1a,0x02730097,0x068b04c6,0x0d9308d6,0x15691269,0x19e117e7,0x19701a18,
0x171018d0,0x0f8913bb,0x08550b72,0x02890594,0xfd6bffdc,0xf761fa8f,0xf4a7f54a,0xee98f2d2,
0xe44ae98c,0xe0d8e085,0xe8ffe4a2,0xefa3ec87,0xf5aef2e1,0xf7cbf76a,0xf8f1f7d6,0xfcc4faf3,
0x0303ff21,0x0b290782,0x0af00c33,0x0d450b1d,0x0a500d24,0x01f20668,0xf874fd50,0xf565f523,
0xf97ef756,0x0033fcd8,0x02e301ac,0x090b05a4,0x113a0ce8,0x172214c0,0x1928186f,0x194819ce,
0x138416e9,0x0ce7100e,0x05f2094e,0x011403b7,0xf9d8fd24,0xf676f7d6,0xf3cbf57d,0xe8faef84,
0xe148e36f,0xe4afe23b,0xeaafe789,0xf28bee9f,0xf58af4ad,0xf7a4f69f,0xfa1ef8df,0xfdf4fac7,
0x07d303c8,0x08f108d0,0x0c980a41,0x0c1a0d63,0x08040ab2,0xfcf4029e,0xf636f919,0xf6f1f529,
0xfc30f9af,0x0029fe54,0x047a022c,0x0c5f07d0,0x13c110aa,0x177015ab,0x19fd1975,0x16a71874,
0x10791440,0x0a5f0ce7,0x048207b0,0xfdc00158,0xf7fdfa1c,0xf7c3f801,0xeed9f4b2,0xe420e85d,
0xe311e31a,0xe6dde3e3,0xee96ea93,0xf338f1f6,0xf709f480,0xf79cf839,0xfa55f779,0x0422ffdb,
0x06df0591,0x0aea0960,0x0d5a0be3,0x0b820d78,0x03890833,0xf973fe3d,0xf68df6a8,0xf997f7bf,
0xfdcdfbc7,0x00fcff85,0x07c60362,0x0f340c44,0x1551120d,0x18e21791,0x194319bd,0x13fc1702,
0x0e2b1124,0x08cc0b2d,0x01d50607,0xfa44fd78,0xfad0f9ae,0xf453f939,0xe979eed2,0xe3fde5bc,
0xe37fe2d2,0xeb1be6f2,0xeffaee05,0xf603f287,0xf61ef7b9,0xf812f547,0xff29fbea,0x04f60269,
0x0841069b,0x0ca80a6d,0x0daa0dc5,0x09380c74,0xfeba0434,0xf7e9fa3f,0xf7bcf74a,0xfc1ef9cd,
0xfdfbfd08,0x03ba0081,0x0ab80705,0x11950e79,0x16ef1413,0x1986191e,0x17541910,0x119f145a,
0x0c9c0eea,0x06a40acb,0xfd4300fc,0xfc34fbec,0xf97cfc32,0xefa4f492,0xe714eb3d,0xe27be3cf,
0xe7f0e489,0xeb84e99a,0xf446f007,0xf54bf5a2,0xf608f51b,0xfb52f818,0x01bcff09,0x05850382,
0x0a4c07ce,0x0df10c82,0x0d8d0eae,0x04ab09a3,0xfb44ffef,0xf7e8f820,0xfa18f924,0xfc57face,
0xffd6fe17,0x06ca02fe,0x0d2009c4,0x13501063,0x18841697,0x197f1947,0x13e51769,0x10b311c1,
0x0b5a0ee7,0x00c005f7,0xfdf3fe36,0xfcb7fe0d,0xf5aef954,0xec0ef1e1,0xe459e653,0xe52ee4d3,
0xe813e59f,0xf0bfec7b,0xf4a5f363,0xf45cf48b,0xf821f59e,0xfe2efb4b,0x027e0041,0x07060512,
0x0ca90970,0x0ecb0eb8,0x0aa80d6c,0xffc705ce,0xf9b5fb98,0xf92ef8b7,0xfa85fa11,0xfd60fbc6,
0x02b0ff7e,0x084b059a,0x0f9b0c0b,0x15531250,0x19c91863,0x162b18e2,0x134313dd,0x0feb1295,
0x04fe0afc,0x00680121,0xfdabff99,0xfb72fc88,0xf15bf7c3,0xe878eb8f,0xe48ee676,0xe518e3e9,
0xec7de82d,0xf2c3f059,0xf345f3a4,0xf615f3dc,0xfa71f845,0xffeefd47,0x0342019d,0x09c60651,
0x0e480bfd,0x0e2c0fa6,0x060e0ad7,0xfcb90091,0xf973fa7c,0xf9aef999,0xfb01f99f,0xff17fd3d,
0x04940164,0x0afd07ef,0x11340dc6,0x185e1569,0x175d18bd,0x144d1520,0x1437154b,0x09a20f50,
0x038805f7,0xfeae00a3,0xfec1feee,0xf6c9fbbe,0xed46f197,0xe6b4e9f1,0xe3bbe45a,0xe7fee4bf,
0xf004eca9,0xf1c5f149,0xf409f2ca,0xf79bf509,0xfc91fac7,0x00bdfe64,0x056c02bd,0x0bbf08ba,
0x0f950e77,0x0b0f0e2d,0x0125067e,0xfbe7fd80,0xf93dfa82,0xf9cdf8fe,0xfc48fb20,0x0117fdea,
0x066f042c,0x0cb7093b,0x15a110ec,0x1730182a,0x15701530,0x16591719,0x0f0412b7,0x07130b7a,
0x00ea0323,0x00f300ae,0xfbadff37,0xf2f3f793,0xeafceea3,0xe454e76f,0xe546e2fa,0xec5ae96d,
0xf123eee4,0xf1eff18f,0xf55df388,0xfa04f79f,0xfdf1fbeb,0x01f30006,0x08c204ec,0x0e6c0be4,
0x0ecb0ff7,0x06560b03,0xff660236,0xfa72fcb9,0xfa18f9f2,0xfaacfa02,0xfe0ffc1b,0x033400bd,
0x074e04f7,0x12640c1a,0x159715dd,0x1689155c,0x1755177b,0x139615c4,0x0b911088,0x03da06a9,
0x025c02b4,0xffef0192,0xf818fcc4,0xf118f45a,0xe6dfebdd,0xe402e478,0xe935e5bc,0xeeceec6a,
0xf0dff050,0xf39bf1ea,0xf748f536,0xfb88f9d4,0xff09fce8,0x0476017d,0x0bba07dd,0x10470f66,
0x0b100e04,0x037c07a4,0xfd37ffe2,0xfa85fb7b,0xf9fcfa18,0xfba2fa30,0x00bffecd,0x026a00a9,
0x0d830782,0x12ec1186,0x15ba1408,0x16da1693,0x16ae170d,0x0feb147d,0x077b0b2b,0x035d045e,
0x022403bb,0xfca9ff23,0xf5dcf9bc,0xebe0f14e,0xe482e722,0xe5e2e40a,0xebd5e93e,0xef39ed9f,
0xf10df01c,0xf4edf2ce,0xf8b0f71c,0xfc85fa27,0xffbbfe58,0x07e6030a,0x0e910c27,0x0e2a0f21,
0x07fa0bb3,0x00ab0453,0xfcb1fdac,0xf96ffba1,0xfaadf8c2,0xfe74fd74,0xfec7fda2,0x084e0325,
0x0f640c7f,0x142e1203,0x159b14c0,0x17eb1784,0x14e916e0,0x0b031070,0x063807af,0x03f90535,
0xfffe020e,0xfb2bfe17,0xf250f712,0xe794ec9a,0xe4f9e519,0xe932e6b0,0xeda3eb87,0xef32ee98,
0xf359f12d,0xf62ff494,0xfaa8f8a0,0xfc80fb98,0x036aff4b,0x0bc207a2,0x0ed70e54,0x0cb20e99,
0x04580892,0x004e01a3,0xfa51fdee,0xfaa8f8f7,0xfd2dfcc2,0xfc88fc18,0x031affb3,0x0bbf06f1,
0x10db0f0d,0x148912e0,0x177115a7,0x17f018d9,0x0fce149a,0x09600b9e,0x05cb079f,0x02a8045a,
0xff5a00ff,0xf89ffcb2,0xecd6f2e2,0xe621e89c,0xe72fe560,0xeb6be9e7,0xedcbec56,0xf11defbc,
0xf42ef1fc,0xf859f6cc,0xfa83f998,0xfec2fba8,0x07520325,0x0d3d0a8b,0x0f400f91,0x08020ba6,
0x042805f3,0xfc570105,0xfb31f9f7,0xfbabfc1e,0xfbbffbab,0xfe9dfc16,0x06a302b6,0x0dd20a72,
0x11a31001,0x153d1316,0x1905181d,0x13ce173c,0x0c920fce,0x08460a50,0x0483067c,0x020102ae,
0xfd6400cf,0xf390f8d3,0xe8e3edcf,0xe6dee658,0xe900e84a,0xec75ea8b,0xeea1ed7d,0xf1b8f007,
0xf683f41b,0xf884f818,0xfb88f8fa,0x0218ff0e,0x0a3505c7,0x0f8b0e1c,0x0ac40d58,0x08790a28,
0xffe50414,0xfbe8fd52,0xfc85fbf5,0xfb02fbdb,0xfbb6fab9,0x01e4fe75,0x0a0605d5,0x0e720ce0,
0x12a81033,0x185e15ee,0x16c41870,0x0fc91395,0x0b970d6c,0x063208c7,0x042204bb,0x010f0324,
0xfa47fe94,0xed97f38c,0xe7f1e9fa,0xe7c2e754,0xea93e901,0xecf9ebc3,0xef00edf3,0xf494f1b4,
0xf659f5dc,0xf903f72d,0xfd2dfb63,0x05ec0000,0x0cfc0b72,0x0d1c0ccc,0x0b0c0c9c,0x0406082f,
0xfdbf0033,0xfd0ffcdc,0xfb52fc77,0xfa6efab6,0xfd90fb29,0x05b0013f,0x0ab60913,0x0f6d0cb5,
0x15dc1260,0x181f1847,0x131515e1,0x0e9910f9,0x08c10b3b,0x050c0708,0x041a0423,0xff9c0307,
0xf41dfa02,0xeaf0ef13,0xe7dae8bc,0xe912e7b9,0xeb60eac5,0xed0eebd4,0xf288ef81,0xf40ff40a,
0xf862f5cd,0xf897f876,0x0121fbe8,0x09910636,0x0cc90b54,0x0d4e0d9a,0x08220bb9,0x00e403f7,
0xfe1ffeff,0xfc4efd7f,0xfa94fb7c,0xfa88f97c,0x0159fda3,0x079d04e9,0x0b73097e,0x12a80e3e,
0x17251658,0x160e16d7,0x113913e0,0x0c5f0eb8,0x068c098c,0x05b5056b,0x03a80552,0xfa790007,
0xf058f4f1,0xe967ec30,0xe894e855,0xead8ea18,0xeac4e9d3,0xf031ee30,0xf298f0e6,0xf6e8f51a,
0xf69bf6e3,0xfc74f88f,0x05770124,0x0a4a0839,0x0e280ca9,0x0bf50e26,0x04bb0804,0x00250258,
0xfe53fef7,0xfb7afd2e,0xf956f9a9,0xfd5bfac6,0x04de016b,0x077a060a,0x0eec0ac7,0x14e81280,
0x172516b3,0x13dd1596,0x0fc1124d,0x09730c8e,0x066606fa,0x06700711,0x0065041b,0xf654fb2c,
0xec87f1ce,0xea02e985,0xe96cea64,0xea2de8e8,0xed86ec5c,0xf0d1ee74,0xf551f37a,0xf583f605,
0xf8a5f5f7,0x00c2fc72,0x06bc044f,0x0d4509ef,0x0dfa0ea2,0x08b90bb1,0x029b059a,0x0072012e,
0xfd5afee0,0xf987fbbf,0xfad9f8d4,0x0174fe90,0x047a02be,0x0a4c074a,0x12140dfa,0x161514d8,
0x15b1166c,0x1343149c,0x0c521019,0x07830981,0x086f0789,0x041206fb,0xfd51015b,0xf102f725,
0xec83ed8d,0xe931eb05,0xe9b3e8f9,0xeb8beaa8,0xee47ec40,0xf39df163,0xf4e8f4cd,0xf5acf45d,
0xfc3bf8c1,0x025cff6d,0x0a36062c,0x0e5f0cd0,0x0bb60e3b,0x0612089d,0x022703e4,0x001d00f8,
0xfaa6fe0a,0xf9e9f8d7,0xfe07fbf4,0x01f6004d,0x06420381,0x0daa09aa,0x13dd11c9,0x161514e7,
0x153c1619,0x102013c0,0x09a30bd9,0x090b0959,0x06fb07d8,0x02d2065f,0xf716fcab,0xefdaf2ea,
0xeaa0ed3f,0xea0de994,0xea2eea1f,0xebbeea96,0xf189ee77,0xf3d9f380,0xf421f33e,0xf850f64b,
0xfe5bfb03,0x054201a5,0x0cb9095a,0x0d4c0e0a,0x094d0ba3,0x03ea060d,0x02ec03bd,0xfd190010,
0xf95cfa8e,0xfbc4fa48,0xffbefd93,0x021e00cb,0x09830589,0x10b60d43,0x140312d7,0x16ce1577,
0x12c71650,0x0d040ed9,0x092a0b47,0x09050886,0x07120923,0xfcfd0221,0xf496f8cd,0xed69f0b4,
0xeaa7eb55,0xea21ea66,0xe98de9a7,0xef70ebe1,0xf23df189,0xf337f2aa,0xf59cf412,0xfa42f7db,
0x006efccf,0x09290542,0x0dc80b91,0x0b4b0df2,0x06860872,0x052c0592,0xffb80307,0xfaf1fd41,
0xfaa0f99a,0xfd83fc4e,0xffa6fe83,0x04ad0199,0x0d1e08e6,0x108c0f14,0x16da1403,0x14fd16c3,
0x1025127f,0x0a5d0d89,0x09e80917,0x09860a90,0x028f0677,0xf9f0fe78,0xf187f5a2,0xec2bede3,
0xeadcebd8,0xe88be924,0xec9eea04,0xf0bfef11,0xf1fff1c4,0xf45cf27f,0xf65af5b8,0xfc79f8e0,
0x03fbffd3,0x0bcb084a,0x0cdf0de3,0x08b70a38,0x06c207db,0x036a0594,0xfced0036,0xfabdfae0,
0xfbf9fb28,0xfd9cfd63,0x011afdd5,0x08820566,0x0d210abb,0x148510f5,0x15bb15ca,0x13571516,
0x0c691022,0x0a9e0a7c,0x0ae40afb,0x06c309a6,0xffad032c,0xf601fb45,0xef6af1c7,0xec6bee22,
0xe914ea36,0xe9efe8fc,0xef3eecde,0xf07eef9f,0xf2f3f20b,0xf499f3d0,0xf8c4f60c,0xfe69fb5d,
0x087e0365,0x0c730b9b,0x0a640ba2,0x082008fc,0x068f081b,0x007c034f,0xfb0afd7b,0xfc2bfb28,
0xfbaafc56,0xfe36fbb6,0x043b01b9,0x096f0677,0x10c30d48,0x14e812ff,0x156a163c,0x0f4f1292,
0x0b120c6d,0x0bf20b77,0x09750b17,0x04cb075f,0xfae80090,0xf38ff6a1,0xeec5f08a,0xe9f2ecf0,
0xe963e896,0xecdaeafd,0xef0dee0b,0xf1e9f0c5,0xf324f230,0xf5ddf48a,0xf99df71e,0x038ffe65,
0x0b0707a0,0x0a9f0bdf,0x09d30a2d,0x08890921,0x042d071b,0xfd1a003b,0xfd21fcaa,0xfb0dfc77,
0xfc88fac8,0x0082fee3,0x05e60286,0x0c11093d,0x12b60f62,0x1662152d,0x12391543,0x0c9b0ee5,
0x0c7f0c6a,0x0af40b5b,0x085d0ab3,0x0121052e,0xf7abfbe1,0xf286f4f8,0xec70efc4,0xe980e9d1,
0xeacdea24,0xedc6ec0d,0xf058ef8a,0xf299f0c8,0xf3a7f3bc,0xf64af4a2,0xfdc9f8e1,0x076f0347,
0x0a8e09bd,0x0a160aa1,0x0a3309bb,0x078c0a05,0xffef035c,0xfea0fec5,0xfb39fd2d,0xfbc2faf2,
0xfddafc7b,0x0252ffd3,0x07ea0545,0x0ead0afb,0x1584122f,0x141516a1,0x0f7e1135,0x0caa0db1,
0x0bf50c75,0x0b3e0bb7,0x05f10959,0xfc670108,0xf6e8f983,0xefa1f378,0xeb53ec8a,0xe980ea59,
0xecc2eaee,0xee8bed6b,0xf14af00d,0xf358f287,0xf396f37d,0xf8fbf525,0x027efddf,0x092f067f,
0x097a09e5,0x0acd0985,0x0a4c0bf5,0x03740652,0x004601f0,0xfcc7fe87,0xfb79fbb0,0xfc1ffb4e,
0xff36fdbb,0x04c601cf,0x097b067a,0x12c70e8e,0x15391504,0x1163137c,0x0dff0f7e,0x0c4e0d2b,
0x0cbf0c1c,0x09de0c4b,0x00e9057b,0xfb6afe57,0xf39bf712,0xed97f0cd,0xea48eb40,0xeb0bea61,
0xed0eec0a,0xef6eedff,0xf2b4f16d,0xf22bf28e,0xf4d4f2d3,0xfce9f852,0x064c01d5,0x07910810,
0x0ac3086f,0x0b7a0c20,0x068e08ef,0x027404da,0xfef7006f,0xfbb2fce8,0xfb1dfba8,0xfd7afb62,
0x00f6ff6f,0x05070280,0x0e200957,0x1454120c,0x12ce141b,0x0fb8116f,0x0cbb0e4d,0x0d350bd2,
0x0bd40e08,0x05ef08c5,0xff07029c,0xf859fbb3,0xf108f4a8,0xebd2ee08,0xea7cea80,0xeb5deb15,
0xeda3ebf9,0xf17befb0,0xf179f1fe,0xf253f1c8,0xf752f36d,0x01fcfd1f,0x05150486,0x097a0693,
0x0b730b1b,0x09150b1d,0x058506ec,0x00c4032b,0xfdbcff3f,0xfadffc20,0xfc3ffac4,0xfe96fd98,
0x013bffcf,0x0925046d,0x11b60dc5,0x12e31365,0x124112c8,0x0d170fa7,0x0db70cc7,0x0d980e19,
0x09ab0c28,0x035d067e,0xfce30053,0xf5c8f94c,0xee8ef1c9,0xeb80ecae,0xeb06eb45,0xec3beac6,
0xefadee58,0xf1edf102,0xf129f1e6,0xf310f092,0xfd71f8c9,0x02b10044,0x06b10479,0x0b0e0990,
0x0aad0b2a,0x08190998,0x039105ba,0x003c0247,0xfc19fddf,0xfb94fb08,0xfd34fcc8,0xfedafde4,
0x03ee0025,0x0dbd098e,0x12371005,0x134913c9,0x0ef0111d,0x0d960dd0,0x0e890dfd,0x0c480ddc,
0x07310a3b,0x01800451,0xfa95fe0d,0xf22bf67e,0xee0eef96,0xeb10ec41,0xeb49eaa9,0xeda0ecb3,
0xf227ef64,0xf050f255,0xf083ef68,0xf8bef409,0xfedffc56,0x03ef011f,0x091a0737,0x0b570a44,
0x09a50af8,0x06100807,0x032e04b7,0xfdb60052,0xfb9bfc60,0xfd4efbf3,0xfc65fd69,0x0041fd0f,
0x081d046c,0x0fa90bb9,0x13301256,0x108b1294,0x0e440edc,0x0e5d0e00,0x0dcd0eae,0x0a7d0c8c,
0x052b0776,0xff5102d9,0xf6e6fb2f,0xf181f399,0xebf5ee80,0xeb58ebae,0xeb93eab0,0xf0ebee05,
0xf114f22f,0xeee4ef7e,0xf4e7f0f4,0xfa8ff803,0x0078fd9e,0x06630376,0x0a51087e,0x0adb0b7c,
0x089f0972,0x0548074a,0x00e30374,0xfc0efdb3,0xfdd8fcb0,0xfbb5fd17,0xfd88fc09,0x03700008,
0x0b3b06fd,0x11bd0f75,0x11f01282,0x0f021020,0x0e420ea2,0x0f050eaf,0x0cb20e29,0x08410a60,
0x03a506d8,0xfbebff39,0xf4e2f8a1,0xef30f180,0xec14edd5,0xea60ea66,0xeee3ebf4,0xf14ef18f,
0xeeb6ef7c,0xf18aef64,0xf70bf477,0xfd04f9b5,0x024effc0,0x089005ba,0x0a8309d3,0x09eb0aa0,
0x07d7089e,0x03dd0704,0xfdf8ffe2,0xfddffdaf,0xfc1ffd93,0xfc28fb7f,0xff2bfd1c,0x06480288,
0x0f010ade,0x11c0110b,0x0fb81122,0x0e5f0f01,0x0f750e56,0x0d950f38,0x0b690c73,0x06b10999,
0x00e503a3,0xf8cffd20,0xf2c7f588,0xee83f085,0xe9b8ebbc,0xed36ea83,0xf0e5efb0,0xeea9f00e,
0xefc6eedb,0xf3b1f11a,0xf912f69e,0xfebafb8b,0x0502024e,0x09da0771,0x09880a51,0x09f909bb,
0x06d1092b,0x004502f7,0xfec5ff71,0xfd51fe1d,0xfb90fbf5,0xfc63fbe1,0x01a3fe71,0x0a8c05a5,
0x0ff90e18,0x10c81134,0x0e5f0f39,0x0f780ec8,0x0e170ee7,0x0d730e32,0x09a60b8f,0x04d00778,
0xfd9e01b4,0xf6c0f95c,0xf197f4ac,0xeb05ee2d,0xeba1e9bb,0xef95ee48,0xef76efd0,0xee94eef4,
0xf1afef68,0xf54ef386,0xfb34f868,0x0138fda4,0x07b204f5,0x08d408f5,0x0b2d0984,0x092b0b07,
0x03420665,0x0073017b,0xfe93ff46,0xfc42fd88,0xfb83fbde,0xfddffbb3,0x05810165,0x0d65098b,
0x1074104a,0x0f2f0f44,0x0f1a0f6d,0x0ef50ef3,0x0eb50ebf,0x0bcb0dc9,0x08ec0a66,0x020e05ee,
0xfabefe01,0xf64df8d7,0xed9df218,0xeb8aeb31,0xee35eccd,0xeff1efeb,0xeeceeec9,0xefabef3a,
0xf331f12a,0xf7e6f57e,0xfd2ef9ce,0x051b01e6,0x078906a5,0x0aba088e,0x0af90bf9,0x06940915,
0x02a10419,0x001c0162,0xfe17ff16,0xfb74fd03,0xfbeafacd,0x002efda7,0x09f104c8,0x0ed70d25,
0x0f500f81,0x0f610f77,0x0ecb0e9c,0x0f130f60,0x0d740e6e,0x0b950c73,0x064c09b4,0xfebd01f7,
0xfaa1fd43,0xf1ecf615,0xeba0ee31,0xed87ebf1,0xef53eea7,0xeee7ef19,0xee96ef05,0xf170ef44,
0xf451f306,0xf8e1f60c,0x018bfd8d,0x05150394,0x08e606bc,0x0bd70b17,0x08c20ae0,0x04ef06a7,
0x01590302,0x000c00bd,0xfc97fe0a,0xfaf6fbf7,0xfcb0fae3,0x04cafffe,0x0ba70929,0x0ee90d90,
0x0f060f3e,0x0ed20eb4,0x0f3d0f3d,0x0ddf0ed9,0x0dc00d43,0x08e80c90,0x030b05a7,0xfe8a0081,
0xf6d2fb71,0xee05f214,0xed22ec7a,0xee15ed81,0xef0def0f,0xee19ee9f,0xf029ee62,0xf1c8f17c,
0xf54cf2b6,0xfd13f927,0x020e000a,0x061103c6,0x0b30091f,0x0a850b26,0x06d10968,0x03ae04a2,
0x0105025a,0xfe63ffda,0xfbe2fd45,0xfa3afa3d,0x0047fc92,0x07a40430,0x0d2a0ad9,0x0ead0e2d,
0x0e1a0e63,0x0fe10f55,0x0df20e77,0x0ebb0e82,0x0c0b0e3c,0x065108f9,0x01fb03b8,0xfc09002f,
0xf270f6e3,0xedd5ef40,0xeda9ed5f,0xef4ceed2,0xeda8ee79,0xef6dee16,0xf05df05a,0xf272f0c1,
0xf92ff53f,0xfe75fcb6,0x03860075,0x0875060b,0x0b4d0ace,0x08e30a6f,0x05aa0703,0x02c00468,
0x0081016c,0xfd7aff85,0xf9e6fae6,0xfc64fa98,0x0384ffd1,0x0a68069e,0x0d470d17,0x0e340d5f,
0x0f720f0d,0x0ddb0e81,0x0ef90e8d,0x0e810f2e,0x08f80bf5,0x056b06ca,0x00cf03e5,0xf79cfc36,
0xf02cf393,0xee06ee22,0xef71eefe,0xedd2ee84,0xeedcee43,0xf031efae,0xefceef64,0xf5acf2ae,
0xfb54f882,0xffeafd99,0x058c029b,0x0a9b089b,0x09fd0add,0x07d308c9,0x04060643,0x02b8030a,
0xffa6014d,0xfa9efd6a,0xfaeaf9ee,0xfeacfc11,0x06c90291,0x0b2a0a15,0x0d800bfe,0x0eca0e74,
0x0de40e9d,0x0e920dc0,0x0fb90f99,0x0b3e0e06,0x08180923,0x047906c4,0xfd400124,0xf3caf8d9,
0xef75f03d,0xef34ef4c,0xedf4ef1a,0xeee2ed8d,0xef8aefd1,0xeedceefd,0xf283f022,0xf80af540,
0xfc8dfa61,0x01d0feeb,0x08cf05a2,0x0a2c09af,0x093d0a86,0x064107bc,0x04180484,0x021203da,
0xfd0aff92,0xfac2fb7b,0xfb4afa2c,0x02d5fed2,0x08960626,0x0beb0a56,0x0e570d5a,0x0df70e93,
0x0ddc0d34,0x10460f7e,0x0d180f57,0x0a880b4e,0x070908e7,0x028305a3,0xf910fde3,0xf147f45a,
0xf071f0b7,0xee33ef68,0xeea7edd1,0xefa0ef7f,0xee62ef1c,0xf02feea8,0xf4fdf229,0xf901f7b8,
0xfea4fb22,0x050001bc,0x092607c2,0x0a610a31,0x077b093d,0x058705ea,0x040a057f,0xffff01d2,
0xfbb4fe09,0xf9bdf9e6,0xfeb8fb8c,0x050b0200,0x09580780,0x0d530b74,0x0dc00e11,0x0cd60ca4,
0x0fe40ef3,0x0ea10f3c,0x0ba00d55,0x096b0a8e,0x069f0829,0xfe620365,0xf50ff8f7,0xf1e3f32e,
0xeefdf057,0xee44edf6,0xef6cef6c,0xef07ef40,0xee1eedd8,0xf280f062,0xf62df471,0xfaa1f7ef,
0x012bfde1,0x06d3044d,0x0a950915,0x08590a0c,0x07040758,0x055e0669,0x02b10402,0xfe2300ea,
0xf9f9fb86,0xfbc0f9d6,0x0154fe98,0x06160412,0x0bd2087b,0x0ca20d45,0x0cb70c60,0x0ee90d91,
0x0f4a0f90,0x0d2e0e75,0x0a780bb7,0x09b809ea,0x035b0794,0xf9b0fe85,0xf4ecf691,0xf02cf258,
0xee57ef42,0xefa3ee8d,0xef2aefe2,0xeda4ee0b,0xf0a1eec8,0xf3dff260,0xf74df52d,0xfd4cfa69,
0x035fffe3,0x09560706,0x090709cb,0x084a088f,0x069b075e,0x04d705ec,0x014a03a7,0xfbc8fe22,
0xf9e6fa07,0xfec5fc5a,0x0276002a,0x093305e8,0x0bdf0b48,0x0bfd0bd2,0x0dcf0c96,0x0f2d0e9f,
0x0e6a0f9a,0x0bb20c8e,0x0b320b11,0x07a60aed,0xff080311,0xf7fdfb28,0xf2f7f57a,0xef00f0a0,
0xef98eebc,0xef90f015,0xed84ee7e,0xef2ded90,0xf187f0bf,0xf4d9f2c6,0xf985f746,0xff56fbba,
0x0681039a,0x08e50845,0x08ee08c9,0x07480860,0x06a00713,0x0454057e,0xfe2001f7,0xfa5ffb23,
0xfc4dfb31,0xff3ffd47,0x05d9024f,0x0a69091c,0x0b9f0ac5,0x0c230bce,0x0ea20d95,0x0f800f66,
0x0bf70dc4,0x0c890beb,0x0aea0c7a,0x03d907c8,0xfc45ffcf,0xf66df970,0xf0a4f30f,0xef97ef88,
0xf066f071,0xedebef1a,0xee63ed9b,0xefb3ef58,0xf2f9f0fb,0xf613f468,0xfb23f831,0x0326ff68,
0x07680565,0x0898089f,0x084b087e,0x06f6077a,0x06f30700,0x014f050a,0xfc19fe20,0xfb9efb4c,
0xfc3ffb8f,0x0255ff22,0x0834055f,0x0a4a098f,0x0b5a0b18,0x0d7b0bd5,0x0f950f3f,0x0cd50e56,
0x0ca40c3c,0x0cfc0d19,0x07c40b32,0x00f30444,0xfa8efdba,0xf31ef6d5,0xf04ff0ef,0xf104f0ef,
0xee92ef8c,0xee0bee67,0xeeb5ee1e,0xf141ef8e,0xf33af2a7,0xf7b7f4d8,0xfe85fae0,0x04da0219,
0x07a10695,0x087108a2,0x073f0749,0x080a07c5,0x048b077f,0xfed600e6,0xfb9afd28,0xfaf2faf4,
0xfec5fc04,0x04ca01f5,0x09180749,0x09ef09d8,0x0c080a59,0x0ee20dfe,0x0d950eb5,0x0c5c0c4c,
0x0dc60d45,0x0af80d45,0x050d07ea,0xff200209,0xf678fb61,0xf21df321,0xf159f1b5,0xef7cf099,
0xeebeef1a,0xed9beda4,0xf017eedb,0xf170f0dd,0xf472f2be,0xfa96f6c7,0x00eefe48,0x064403e3,
0x084d07a5,0x06c20782,0x090307d5,0x071108a6,0x01f6049e,0xfdceffcd,0xfab0fbcc,0xfc40fad3,
0x014afe87,0x076004a4,0x08c00858,0x0a600953,0x0e240c73,0x0e320eb0,0x0c580cd9,0x0dfc0d25,
0x0d920e68,0x085d0ad6,0x040906b7,0xfb740014,0xf4b0f708,0xf28af3b7,0xf0f7f184,0xef87f08e,
0xedfdee22,0xef12ee89,0xf0f7f055,0xf213f0f3,0xf6cbf422,0xfd5cfa3e,0x039f001a,0x075b068c,
0x06d106f1,0x08c5077f,0x08a80962,0x050b070f,0x00b30312,0xfc0efdde,0xfad8fb44,0xfe33fbdd,
0x04930157,0x07520680,0x08a607f3,0x0cde0a69,0x0e090e01,0x0c550d86,0x0ddf0c50,0x0e490eaf,
0x0ad70cc3,0x082d09b3,0x002904cc,0xf8a7fbb4,0xf3daf632,0xf294f30f,0xf096f172,0xee33ef8d,
0xeed5ee16,0xf056ef8e,0xf061f07e,0xf451f1bc,0xf8eff68c,0x001bfc33,0x05a803c1,0x06320610,
0x082906b6,0x09220955,0x07b0089f,0x039205d3,0xfe6400ed,0xfb0bfc91,0xfbcffa7e,0x014ffe34,
0x05a60467,0x071f0613,0x0a670858,0x0da60cca,0x0c390d2d,0x0d1f0bed,0x0e930e69,0x0c2b0d7a,
0x0b2c0c06,0x04b10831,0xfca000ed,0xf698f917,0xf3c8f4ae,0xf1d4f313,0xef49f08e,0xee21ee08,
0xefcfef52,0xef58ef87,0xf20ef047,0xf540f37e,0xfbd6f82a,0x03070004,0x04c60412,0x06e005c9,
0x08d6081b,0x0907090d,0x061007eb,0x017f042b,0xfcbdfeb8,0xfa1dfaca,0xfe57fbc4,0x03990145,
0x05200491,0x08280618,0x0c800ad6,0x0be10ccd,0x0c7a0b29,0x0dd70e0b,0x0d4d0d4f,0x0c890d0c,
0x08970b47,0x018f0537,0xf9aafd45,0xf57ef757,0xf3b3f471,0xf05ff251,0xee68eeab,0xef3fef2c,
0xef16ef07,0xf093ef7c,0xf24af196,0xf7d7f44a,0xff83fbdb,0x02e201a5,0x05830462,0x07fb0679,
0x092808e1,0x08260942,0x04a90679,0xff53022e,0xfabefc94,0xfbcefa88,0x0161fe90,0x037902c2,
0x05800427,0x0b6a088c,0x0afc0bb3,0x0c120b3c,0x0d9a0cfd,0x0d350d53,0x0d6d0d9d,0x0bba0cde,
0x05f6094c,0xfe3c0220,0xf7ddfab6,0xf612f6a9,0xf1eef443,0xef55f033,0xef74ef64,0xeee1eee8,
0xf00eef76,0xf0acf08c,0xf45df175,0xfb45f7e5,0x00bcfe9f,0x03de0235,0x066a0528,0x08ef07d0,
0x091a097b,0x0765086d,0x02b40547,0xfc9affd1,0xfad0fabc,0xfef7fc3b,0x01ec0182,0x038401bf,
0x0910066e,0x0a480a71,0x0b7a0a6f,0x0cb40c3e,0x0d2b0d05,0x0d770d59,0x0d920dc6,0x099f0bee,
0x02d106e7,0xfb26fe62,0xf849f946,0xf411f6b7,0xf0dcf1ee,0xefd6f026,0xee8fef1c,0xefedef59,
0xefc9efcc,0xf153f008,0xf785f41f,0xfda1fadc,0x01bdffe4,0x048f02fd,0x07a20660,0x097908b1,
0x08c50945,0x06250822,0x0038032b,0xfa8cfcd7,0xfd86fb41,0x006bff98,0x015e0049,0x06c80419,
0x092a0878,0x0a8f09b7,0x0c040b3a,0x0cb30cc1,0x0d640cad,0x0dc80dcf,0x0c880d8e,0x075e0ab1,
0xfedc02a8,0xfad4fc8f,0xf6b3f941,0xf2b4f403,0xf071f1b9,0xeeeeef70,0xefbaef2e,0xef93efea,
0xef95ef17,0xf3b1f15a,0xfa3ff6c9,0xfed1fcd5,0x027000da,0x061a03fa,0x083a0782,0x09770940,
0x08810905,0x03c906e4,0xfc32ffbc,0xfcabfb3c,0xff04fe5a,0xffb2fee8,0x040801cc,0x07b20600,
0x08f7086b,0x0b490a43,0x0c270bce,0x0cd80c37,0x0d280d57,0x0e260da9,0x0b020d4e,0x02de070a,
0xfe28002b,0xf958fbec,0xf503f6e0,0xf1e3f364,0xef48f073,0xefd0ef21,0xef8aeff3,0xeefbef47,
0xf100ef2c,0xf61bf370,0xfbf2f970,0xffd9fdb7,0x038901d9,0x070a056c,0x08c30839,0x098f0900,
0x0764097b,0xfed90346,0xfcfbfc97,0xfdc4fdaa,0xfe85fe1f,0x01b2ff81,0x058d03cb,0x077d06c4,
0x0a4e08f2,0x0b590ac4,0x0c560c08,0x0c950c96,0x0e540d0f,0x0dac0ef2,0x06fc0a85,0x01870415,
0xfc9bff09,0xf7a8f9f8,0xf42ef614,0xf0a3f1e7,0xef9cefec,0xf045f03e,0xef10ef7a,0xef2beee2,
0xf34bf0d7,0xf8b8f60e,0xfd5cfb19,0x011fff4d,0x0567033f,0x079706d6,0x09610814,0x0a6b0b2a,
0x02ab06b9,0xfe22ff8f,0xfdcdfe0a,0xfdb2fdb1,0xffc8fe0e,0x035201e6,0x063104c0,0x08cb0792,
0x0a7409aa,0x0c1f0b62,0x0ba60c19,0x0dd60c19,0x0eec0f2d,0x0a9a0d49,0x053f0792,0xff8402a6,
0xfb0dfd31,0xf6adf8a2,0xf22ff486,0xf05ff0dc,0xf07cf050,0xefb0f051,0xee91eee8,0xf0d6ef46,
0xf585f2da,0xfa6ef834,0xfe4ffc8c,0x0374006c,0x05840532,0x085b066d,0x0bb60acb,0x063e09a2,
0x003b02dc,0xfec1ff37,0xfd2efde3,0xfe7cfd5b,0x013fffe8,0x043902a5,0x072105e1,0x08ef07eb,
0x0baa0a9a,0x0b030b5b,0x0c420b43,0x0f610e50,0x0ce70e5d,0x08770b0c,0x032605df,0xfe010054,
0xf99dfbf1,0xf4a5f71c,0xf14bf29a,0xf0d0f0a8,0xf048f0eb,0xeedcef96,0xef49ee7c,0xf251f07e,
0xf7ccf55e,0xfb28f941,0x0106fddc,0x03760310,0x06800459,0x0b3b0925,0x094c0b6f,0x032205ea,
0x00400179,0xfda0fedd,0xfda9fd2d,0xff7efea1,0x02620075,0x05030449,0x07a2060c,0x0ac30922,
0x0a590b42,0x0b310a17,0x0e420cc6,0x0e350ed6,0x0b5e0cf7,0x065f091c,0x01240382,0xfc88ff02,
0xf789fa20,0xf2eff4c3,0xf11df1c6,0xf10bf160,0xefa0f021,0xee56eef9,0xf006ee88,0xf502f2c2,
0xf7eff62e,0xfe53fb13,0x016b0065,0x03c10234,0x098f0679,0x0abb0b51,0x061b087e,0x027a0411,
0xfea500c2,0xfde1fdd6,0xfde0fd86,0x007cff20,0x037c022f,0x0564041b,0x099607ae,0x0a280a5c,
0x09f4099e,0x0cd60b30,0x0e570e16,0x0d690e21,0x098f0ba8,0x04260701,0xfff3021b,0xfaccfd51,
0xf51af7e7,0xf26ef363,0xf16bf1e0,0xf0d8f102,0xee88f01b,0xeee1edb1,0xf270f0f3,0xf528f37f,
0xfb34f7e9,0xff90fdfe,0x012f0019,0x070803d9,0x0af809e0,0x087109d1,0x04ef0725,0x011202ba,
0xfe91ff93,0xfd8efe04,0xff71fdf5,0x01c200da,0x0382025a,0x07eb05b7,0x09d10969,0x094d0942,
0x0b2d0a35,0x0ddb0cb7,0x0e440e21,0x0be40d93,0x077109dd,0x03030511,0xfe6a00f0,0xf81dfb4a,
0xf466f5de,0xf1bef2dc,0xf237f1ea,0xef5af13b,0xee7eee21,0xf0aeef9a,0xf27cf1ab,0xf818f49f,
0xfd5cfb32,0xfea6fe57,0x046c00b3,0x092f0770,0x09e20a0c,0x075c08df,0x0331052c,0x004901b9,
0xfdaefedd,0xfeaffd8f,0x0065ffb1,0x016700ed,0x05f00351,0x08e707cb,0x08be090c,0x09f1091e,
0x0c5b0afb,0x0e240d89,0x0d7f0e26,0x0a150c20,0x05bb07af,0x01db043b,0xfb88fe7f,0xf6c8f92a,
0xf2a9f433,0xf307f2de,0xf0b6f23e,0xee74eefa,0xefc0ef3f,0xf0b5f018,0xf47df1c0,0xfb29f885,
0xfc91fbe8,0x00f5fe24,0x06b60432,0x09c3089f,0x092909f1,0x05830744,0x027a0451,0xfecd0086,
0xfe26fdae,0xff88ff2f,0x002affba,0x03810140,0x079405fa,0x0864083d,0x08cf0874,0x0aaa0982,
0x0d3b0c2d,0x0e600de1,0x0c070dc4,0x088c0a05,0x04a60734,0xff7101b5,0xf9b4fcd1,0xf478f6c1,
0xf416f3c6,0xf1dbf36b,0xef3ef069,0xefabeef3,0xef0cefae,0xf1c2ef7e,0xf848f54b,0xfa90f9b2,
0xfdc5fba8,0x033f00b6,0x085e05e6,0x09980985,0x076e08cd,0x04ff0657,0x005202b1,0xfe59fec7,
0xff49fecb,0xff09ff2e,0x0149ffa8,0x05ac03a2,0x07d006fc,0x07f907f2,0x096a088a,0x0b800a71,
0x0e760d0a,0x0cf10e35,0x0b050c1b,0x0744094f,0x02cf04e8,0xfd7a00c2,0xf70bf998,0xf4f0f592,
0xf3aef4cd,0xf038f1b6,0xf04defe4,0xee95efc9,0xef8dee54,0xf57ff257,0xf898f75e,0xfb4bf9ea,
0xfff3fd55,0x05b102b7,0x090b080f,0x08bb0909,0x0715081f,0x02c20549,0xff5a0088,0xff75ff30,
0xfe89ff21,0xff97feae,0x03810156,0x06e50588,0x07610729,0x08730839,0x09e80881,0x0d520bf0,
0x0d8c0dda,0x0ce90d22,0x093c0b84,0x062d07a8,0x01480424,0xfa16fd9b,0xf69cf79b,0xf544f679,
0xf1b2f328,0xf137f122,0xef16f0c0,0xee52edd8,0xf295f01b,0xf6b3f4f2,0xf96ef80c,0xfca2fac1,
0x02a2ff74,0x07520577,0x08c4082b,0x08a908fa,0x054a079d,0x00e002a6,0x0003002c,0xfebdff71,
0xfe62fe72,0x0173ff2d,0x04e203ae,0x07260605,0x078c0784,0x0828076b,0x0be20a46,0x0d180c79,
0x0dbd0db5,0x0b290cc7,0x086209c7,0x052e070b,0xfd62019e,0xf8dffa6e,0xf703f827,0xf2f5f4d0,
0xf26bf274,0xf051f1c2,0xedcbee8b,0xf051eead,0xf482f257,0xf7adf649,0xf9daf89e,0xff39fc3d,
0x04db0249,0x07ab0679,0x097408be,0x077a0946,0x031a04e9,0x00b401c4,0xffef005a,0xfde6fe98,
0xffabfe73,0x02ea016e,0x061f0454,0x06b50700,0x074e0695,0x0a0308ca,0x0c560b08,0x0dc00d47,
0x0c8c0dbe,0x09f60ae9,0x0841096e,0x01610587,0xfbbcfda3,0xf8dffa90,0xf49cf6b5,0xf37df392,
0xf1a2f2fd,0xee71efd3,0xeed1ee3c,0xf254f037,0xf5d5f453,0xf7a1f6cb,0xfbc2f93a,0x01dbfedc,
0x055103e4,0x0956076e,0x08f30995,0x05200789,0x02390337,0x00f501a0,0xfe32ff7f,0xfec4fe29,
0x00abff83,0x04eb02ac,0x05ce05d4,0x068a0614,0x0865073c,0x0a970983,0x0d5a0bfe,0x0d4f0ddb,
0x0ad20bdb,0x0ab20afc,0x050e0894,0xfedc0154,0xfb5afd48,0xf694f8fa,0xf4c2f523,0xf320f43a,
0xefe7f199,0xee39eea5,0xf06aeecb,0xf414f26e,0xf62cf562,0xf8cff6b2,0xfe6afc03,0x02df0090,
0x07650516,0x09b90926,0x07300921,0x03f1051d,0x0249034c,0xff4f0099,0xfe7ffef8,0xff07fe17,
0x03000107,0x05270470,0x05be0550,0x06f40658,0x08ab07c8,0x0c370a15,0x0d560d8d,0x0b6d0c3d,
0x0c250bc7,0x08320af6,0x020b04bb,0xfe31003c,0xf8e6fb7c,0xf617f711,0xf48cf578,0xf1d2f35d,
0xee7cefb1,0xeea8ee5f,0xf2aaf059,0xf453f3d5,0xf696f51e,0xfb3ef8e8,0xffb4fd7c,0x048801f5,
0x094b073f,0x086709c2,0x05f906bd,0x037a0515,0x01270214,0xfed9ffff,0xfe01fe04,0x0135ff56,
0x041102de,0x04e90483,0x064a05bb,0x06ce0683,0x0a8a0820,0x0cf30c7f,0x0b8f0c37,0x0ccd0bed,
0x0a8e0c7f,0x055a07d8,0x01420353,0xfba4fe5b,0xf7a9f995,0xf635f6a7,0xf36ef4e8,0xeff5f1f0,
0xee05ee5e,0xf0f8ef2a,0xf2e4f233,0xf4b4f3a1,0xf84ef64e,0xfcbafa8d,0x00d2fe81,0x0798045b,
0x086e08a9,0x074c080b,0x04e6063c,0x02bc039d,0x0004018b,0xfdcefeb5,0xff78fe0d,0x0281013c,
0x03d60321,0x05ca0509,0x05590596,0x0871063a,0x0c080afb,0x0b420b96,0x0cc10bab,0x0bfc0d3d,
0x08960a39,0x0422065a,0xfeec01ed,0xf9eefc04,0xf767f883,0xf589f65f,0xf1fef444,0xee79efab,
0xefc8eeb1,0xf1a2f0d3,0xf33cf280,0xf608f410,0xf9dff872,0xfd98fb21,0x0482010a,0x07c106b3,
0x081e0855,0x06390746,0x044a052f,0x01ef034c,0xfe830032,0xfe8dfdc0,0x00ebfff4,0x02b701b5,
0x05500418,0x046b0537,0x068a04d2,0x0ae00912,0x0a6c0ab3,0x0c480b55,0x0ce20ce7,0x0a830bf5,
0x074e08ee,0x0239051d,0xfce1ff57,0xf8f4faad,0xf76cf7fb,0xf46df675,0xefe5f1be,0xef1bef3c,
0xf131efee,0xf1bff199,0xf490f2b3,0xf77af673,0xfaa1f886,0x00dbfda3,0x062803d1,0x0837079c,
0x075807fc,0x0596066c,0x041c0514,0xfffa0212,0xfe89fea9,0xffe5ff69,0x01850045,0x0499031e,
0x0413050e,0x052c03ac,0x09070766,0x0a1d09cb,0x0b620a86,0x0cff0c79,0x0bc20c8f,0x09d00afe,
0x057f07df,0x003802e1,0xfaf9fd89,0xf944f9ac,0xf676f82d,0xf222f474,0xef59f028,0xf0c8eff5,
0xf09df0c6,0xf358f19d,0xf588f4b4,0xf7f8f667,0xfd13fa4e,0x035c0041,0x0761059f,0x07a6081e,
0x068b0708,0x05e50654,0x019e0406,0xff640024,0xff63ff45,0xffeaff45,0x03e401f3,0x039e044c,
0x04030340,0x074a0580,0x09190899,0x0a740966,0x0c620bb5,0x0c3c0c87,0x0b830c0c,0x082b09ea,
0x03a80668,0xfda7005a,0xfac1fbed,0xf8bef9bd,0xf489f737,0xf06ff1bc,0xf0acf085,0xeff8f04a,
0xf211f0a2,0xf41df32f,0xf5b9f4ec,0xf9bdf772,0xff80fc56,0x05250290,0x0744070e,0x06db06bf,
0x06f3072e,0x039d05cb,0x0098018b,0xff50003c,0xfeabfe4a,0x027d008b,0x03550358,0x02e102e1,
0x05a30410,0x07bf06ed,0x0935082e,0x0b320a85,0x0c550bb1,0x0bf70c84,0x0a760b2f,0x06a80926,
0x00e20396,0xfc4cfe64,0xfaedfb55,0xf728f9ae,0xf257f426,0xf119f1bf,0xf00af07d,0xf0fcf000,
0xf31bf23f,0xf46ef3dc,0xf746f579,0xfba1f933,0x028fff0b,0x061d0500,0x06910664,0x080d074c,
0x055d075f,0x02ae037a,0x002b01cc,0xfe4cfec1,0x0124ff44,0x02e7028b,0x025d02ad,0x048c031d,
0x06240587,0x08470723,0x09d5091f,0x0bed0ad9,0x0bf40c30,0x0bea0c0c,0x09630af3,0x045d0728,
0xfe5b0134,0xfcf2fd35,0xf980fbad,0xf4b4f6f7,0xf262f362,0xf078f146,0xf032effa,0xf23ef142,
0xf350f2b3,0xf537f44d,0xf845f65a,0xfee0fb33,0x044c0239,0x056f04eb,0x082606ff,0x069407cd,
0x045a0542,0x01e20383,0xfe9affef,0xffd6fe78,0x026b01ab,0x01e20203,0x03730290,0x04d00406,
0x0714061a,0x08a5079d,0x0ac209e7,0x0b970b55,0x0c370c0e,0x0b3b0bb0,0x07a00a47,0x01220427,
0xfeb7ff60,0xfbcdfdb6,0xf756f98a,0xf412f567,0xf15af2d1,0xf05af05f,0xf13bf0b4,0xf2a7f1d9,
0xf3def35b,0xf56bf490,0xfb42f76f,0x015bff1a,0x040702af,0x076b05d9,0x073407bf,0x05e4068a,
0x03f8051d,0xff9e01f0,0xff39fe7f,0x018800c1,0x01cf0177,0x02630237,0x03ed0301,0x05bb04f5,
0x07660649,0x095e08b7,0x0b2c0a30,0x0bb70b9d,0x0c3f0be2,0x0aa40c3a,0x04340768,0x00a60207,
0xfe43ffa4,0xf9d7fc0e,0xf681f816,0xf2ccf4a8,0xf0fef1ab,0xf0d2f09a,0xf1c7f137,0xf398f2dc,
0xf35ff36f,0xf7ebf4c3,0xfe1ffb8b,0x01dbffdf,0x05f30410,0x074a0718,0x06b206f4,0x061c0698,
0x012d0410,0xff7effa9,0x008fffe9,0x01a6012c,0x01a701cf,0x033d0240,0x043b03b3,0x06430542,
0x0806071e,0x0a35090c,0x0acc0adb,0x0c550b36,0x0c570cf8,0x073c0a3f,0x02d10482,0x004d01cc,
0xfc49fe22,0xf8c0faa0,0xf4dff6dd,0xf1e6f2fc,0xf0b1f156,0xf10df064,0xf34cf266,0xf217f2da,
0xf519f2c6,0xfa9ff800,0xfef6fcb6,0x03ba0158,0x069105d9,0x06b8064a,0x075b077b,0x034905c2,
0x00610173,0xfff7ffaf,0x015700f0,0x016f0132,0x025a01e5,0x033802bd,0x0529042d,0x068c05b1,
0x093907fa,0x09da09c4,0x0b720a5d,0x0d5c0cb0,0x09b80c51,0x05710743,0x025003d9,0xfea60097,
0xfb6afcf3,0xf726f973,0xf3baf513,0xf153f2c1,0xf091f031,0xf30ff209,0xf1c4f2c0,0xf305f1d3,
0xf7a6f508,0xfba0f9de,0x0151fe2f,0x050703ea,0x0631053e,0x07f907a2,0x05c0071c,0x01ae03c3,
0x004b007d,0x00f500a2,0x014d0100,0x01ce01b8,0x02b0020b,0x0419038b,0x05670476,0x07f706cd,
0x091308d5,0x0a1e090e,0x0d4d0c05,0x0be30d2d,0x07e209cc,0x04970642,0x00d702c3,0xfdf5ff48,
0xf97afbf4,0xf628f793,0xf2a7f4c0,0xf099f0b6,0xf27ef1b0,0xf213f2b9,0xf1a2f153,0xf542f330,
0xf869f6f1,0xfe85faf1,0x028b0129,0x051203bb,0x07810665,0x075307df,0x037605ad,0x011d01e3,
0x008e00b8,0x013b00c1,0x01240165,0x023e017b,0x031c02b6,0x040b0389,0x06e9053a,0x07ee07d9,
0x08ae07f2,0x0c330a66,0x0cc60d12,0x09e90b70,0x06c20890,0x02f004ac,0x005f019e,0xfbb2fe41,
0xf8dcfa13,0xf474f6e1,0xf12df250,0xf249f15b,0xf27ef2e1,0xf0fdf14d,0xf391f244,0xf593f440,
0xfb2af814,0x0023fe03,0x034301d4,0x064304a0,0x081307b3,0x053e070a,0x028903d2,0x00c0013f,
0x013b010f,0x012a012c,0x019e012b,0x029e0255,0x02e40299,0x05bf0406,0x073906ed,0x0771073f,
0x0acd08bb,0x0ca20c35,0x0b850c46,0x08f10aa7,0x0519069f,0x02af043a,0xfe3a0068,0xfb68fca8,
0xf71bf98e,0xf270f498,0xf281f19a,0xf29bf343,0xf169f1a1,0xf274f1ff,0xf39bf2b0,0xf7f6f571,
0xfd6cfacb,0x010fff96,0x0484026c,0x07a806b1,0x07010793,0x03f605ae,0x01890288,0x01600134,
0x0113015d,0x014700df,0x02500221,0x021b0205,0x045202d1,0x068c05e8,0x0664066e,0x091f073b,
0x0b7e0ac6,0x0c980c08,0x0a7b0c1e,0x072b088a,0x04bd064a,0x0093028b,0xfd73fee3,0xfa51fc4c,
0xf425f723,0xf31af2da,0xf2b6f345,0xf1d2f20f,0xf1f0f1ea,0xf24af1e2,0xf4edf34a,0xfaa9f797,
0xfe43fcc6,0x023a001f,0x062a044c,0x078b0749,0x059206ec,0x028e0409,0x01d401ce,0x0108019c,
0x00fb00c5,0x020c019c,0x015b01b5,0x02e201b6,0x05b90496,0x05510588,0x077b0628,0x09b008a8,
0x0c6d0b05,0x0b570c8d,0x09000a1c,0x06a107e1,0x02af04f2,0xff740089,0xfd1afeeb,0xf694f9cf,
0xf41af4af,0xf313f3ba,0xf25df28c,0xf1d7f209,0xf1bbf1f9,0xf2c7f19d,0xf78df504,0xfbb5f9ce,
0xffa4fdae,0x040b01c4,0x071105dc,0x06ea07a4,0x04010562,0x0299030f,0x01840239,0x011b00ff,
0x01f30178,0x012201e6,0x01ea00ca,0x04ae0399,0x04d104cb,0x065a05a2,0x07f406cf,0x0b6409d0,
0x0c020c19,0x0a290b4b,0x08c9094e,0x04d5075d,0x017b0287,0xffd6011a,0xf99afce3,0xf5c3f758,
0xf419f4a4,0xf2b6f374,0xf285f26c,0xf1a7f269,0xf17df104,0xf4d3f2e7,0xf912f71a,0xfd1bfaea,
0x011bff25,0x059b0367,0x075d0713,0x0513064e,0x03a50458,0x022f02df,0x00fd0156,0x0209016f,
0x01000200,0x01460062,0x035402a7,0x048603d0,0x053c051a,0x067a057e,0x098b07e8,0x0bda0b23,
0x0ac70b6b,0x0a5a0a86,0x06cc0943,0x035e0456,0x01bc02e4,0xfcf9ffbd,0xf7d8fa21,0xf57bf66e,
0xf337f442,0xf321f312,0xf229f2c6,0xf0c3f141,0xf2e6f17b,0xf678f48d,0xfa7bf873,0xfe40fc77,
0x03460072,0x06c00594,0x060106c6,0x04bd0544,0x03390424,0x012d01ed,0x029201c0,0x011b0239,
0x012700ad,0x023401aa,0x04130328,0x04c70481,0x052204f2,0x07e2061a,0x0b1009d5,0x0a9e0af5,
0x0ba20b36,0x08aa0aaa,0x054e06aa,0x039c0465,0x001d0282,0xfab9fd17,0xf740f8f2,0xf474f5b8,
0xf3bef3b8,0xf303f3b4,0xf129f20a,0xf1b4f0fd,0xf43ef2bd,0xf838f64b,0xfb8ff9e9,0x005dfda1,
0x05650337,0x064c0679,0x05aa05be,0x04670590,0x01b9028a,0x02cb024f,0x01a70248,0x01060152,
0x019d0121,0x03280245,0x047203f9,0x044c04a5,0x062c0477,0x09b20870,0x0a1d09d0,0x0beb0b30,
0x0a680b8d,0x06c30893,0x056d05dc,0x029a0466,0xfdab002c,0xf9b3fba7,0xf5e8f7a6,0xf46bf4d2,
0xf3cff467,0xf208f2da,0xf11ff165,0xf28bf174,0xf611f454,0xf910f78d,0xfd16fad1,0x030ffffe,
0x055d04f4,0x06480578,0x05300684,0x02cf0394,0x02ba029d,0x023202a5,0x013e01bd,0x013700ff,
0x02200192,0x04520341,0x03a60471,0x04e0036c,0x07e206c5,0x093e0890,0x0b680a19,0x0b950c35,
0x08600a0b,0x06c20741,0x04900604,0x009602b7,0xfc8cfe8d,0xf7e2fa2a,0xf594f652,0xf4b0f539,
0xf339f3f3,0xf14ef24b,0xf18df0f1,0xf448f2c5,0xf732f5d4,0xf9dcf845,0x0060fd02,0x03750248,
0x061104d2,0x05f90698,0x03d204c4,0x03030342,0x02c00305,0x01a30229,0x01350165,0x010900ce,
0x040a0297,0x035103f8,0x03c00334,0x06700514,0x07b70726,0x0a2d08b9,0x0c020bb4,0x09950b01,
0x07e7087c,0x06480769,0x02f304a9,0xff530148,0xfa32fcce,0xf714f84b,0xf572f61e,0xf46ff4f8,
0xf22ff375,0xf111f166,0xf2e4f15b,0xf55cf4b1,0xf778f5ca,0xfd2afa43,0x0118ff4f,0x050a0330,
0x063c0611,0x04bd05ad,0x038b03e8,0x0335038d,0x02690280,0x01620264,0x00b1006a,0x032101d0,
0x033d03ab,0x031902e2,0x05350401,0x065a05f7,0x08a5071a,0x0baa0a7d,0x0a760b85,0x08f9097a,
0x07a1088f,0x0503063e,0x020003c1,0xfd06ff9b,0xf8fafadf,0xf688f75f,0xf549f61b,0xf3d9f496,
0xf0eaf25c,0xf222f0d4,0xf3ecf386,0xf56cf41d,0xfa08f7a8,0xfe50fc2c,0x02f900b7,0x05da04b0,
0x05200605,0x04800483,0x032e03f0,0x032d0307,0x02030300,0x006900c0,0x02520123,0x0328032f,
0x02a302ae,0x04480348,0x052804f4,0x06da0595,0x0aa008cb,0x0ac80b3b,0x09d80a36,0x08940972,
0x06980770,0x041905c0,0x0033023e,0xfb2ffd9a,0xf811f97b,0xf62af6dc,0xf560f5f7,0xf191f388,
0xf1c0f0ff,0xf2d8f298,0xf3daf2f7,0xf727f574,0xfb6bf930,0xffd5fd6c,0x048802b9,0x051d050b,
0x04f00524,0x0371043f,0x039d034b,0x02ce0394,0x006d0172,0x018f0089,0x02d80297,0x02480270,
0x037a02b4,0x04230410,0x05140437,0x08d506da,0x0a4b0a17,0x0a6d0a61,0x091409d1,0x07c10889,
0x05e806cb,0x02b604a8,0xfe06003b,0xf9ddfc0e,0xf740f7f1,0xf6b5f744,0xf2def4ff,0xf205f1db,
0xf23ff221,0xf2d3f29e,0xf544f392,0xf871f6ff,0xfd03fa4c,0x025b0011,0x04920399,0x05660551,
0x03e104c2,0x03e30388,0x03c70431,0x0113027d,0x013f00ad,0x02a00226,0x021d0269,0x032a0281,
0x03ad03b8,0x03d00345,0x070f0578,0x098f0859,0x0a630a48,0x09e90a29,0x08820966,0x077607d6,
0x04c00686,0x013902fc,0xfc3bfef9,0xf8a1f9af,0xf80af8c3,0xf4bef65e,0xf262f34f,0xf261f247,
0xf21cf233,0xf3f5f2b0,0xf60af51a,0xfa08f794,0xff77fcf0,0x03160163,0x053e0484,0x04540516,
0x040703c2,0x048c0494,0x02050393,0x01270106,0x025701cc,0x01da0252,0x03100209,0x034003a2,
0x031e02d4,0x051a03f5,0x08190697,0x09b10919,0x0a430a41,0x091c099f,0x087008cf,0x063307a9,
0x04180504,0xfe8d01dd,0xfa8ffbf2,0xf933f9d9,0xf682f81d,0xf378f4b1,0xf2a5f310,0xf1c5f201,
0xf2fff233,0xf438f3a7,0xf755f55d,0xfc3bf9b9,0x00a6fe84,0x044c02cc,0x045604b9,0x03cc03b9,
0x04fa049c,0x032d0465,0x012e01bd,0x024101be,0x017801e7,0x02bc01de,0x03240335,0x02b902ff,
0x03c902cc,0x063a0523,0x08b8077c,0x0a1509b2,0x0940099f,0x095f0999,0x0741082a,0x065706f4,
0x01a40471,0xfc97fed9,0xfac5fb57,0xf838f9de,0xf532f677,0xf386f46d,0xf207f275,0xf2a5f249,
0xf30af2e4,0xf543f3ba,0xf92ef729,0xfde0fb78,0x02d50073,0x04060407,0x03b003b9,0x05010429,
0x04130529,0x01eb0290,0x02450238,0x01a301cf,0x021701c8,0x033d02cf,0x028502f7,0x02dd0264,
0x04b703eb,0x078005a8,0x09460900,0x097c0916,0x099109f3,0x081308a0,0x07b607ee,0x04b406d5,
0xff1701c5,0xfc76fd56,0xf9bbfb6a,0xf6fef827,0xf4bbf5ee,0xf286f363,0xf2c6f295,0xf283f29e,
0xf394f2b8,0xf6aaf512,0xfabbf84e,0x0059fda5,0x03590265,0x0323035e,0x04ee03b4,0x046c055b,
0x02e2036e,0x02650286,0x01ac022e,0x01cb018a,0x03190263,0x0274030f,0x02b10252,0x030c02d4,
0x0627043e,0x07f90772,0x0947088c,0x09b109c7,0x086a090b,0x08670843,0x0711085b,0x01b5046b,
0xfe59ffbc,0xfb6cfd0d,0xf8cff9e0,0xf62cf7b1,0xf389f4a5,0xf308f2fe,0xf259f2e7,0xf2ccf23d,
0xf4a8f3ad,0xf7baf5e4,0xfd36fa3b,0x020f0044,0x02470225,0x044f0341,0x04ce04f7,0x037a0410,
0x02c00313,0x0201027a,0x01690160,0x02d5023f,0x028902a4,0x02a602d4,0x02080203,0x0499031d,
0x069205c7,0x08940784,0x09ae0956,0x0889094d,0x08c4084a,0x08a6092f,0x046406cc,0x00c10265,
0xfd4afef3,0xfaa3fbe9,0xf811f979,0xf4ccf648,0xf3baf408,0xf2b7f350,0xf282f272,0xf393f2c2,
0xf517f476,0xfa35f6e5,0xffd1fd8e,0x013e00c7,0x038a0241,0x04bb0469,0x03f2048a,0x037a0384,
0x0238033c,0x01a60164,0x022a022a,0x02b30239,0x02c6031c,0x019201dc,0x03350232,0x05220443,
0x073a05fe,0x094a0887,0x08790928,0x08970814,0x09470960,0x06ad0841,0x02ff04d9,0xff290114,
0xfc64fd93,0xf9d5fb54,0xf666f7dc,0xf45ff566,0xf377f3d6,0xf235f2a3,0xf31cf298,0xf33df336,
0xf6e4f43f,0xfd05fa4e,0xffc1fea6,0x01fd00d7,0x045e0350,0x03ca0450,0x043b03f7,0x02a203b5,
0x020701f5,0x01bd0210,0x029301d7,0x02f8031a,0x01a0023f,0x027401b4,0x03ca032c,0x058c047f,
0x089d0739,0x083b08d0,0x084907f2,0x09750910,0x084e092b,0x056406ee,0x01060370,0xfe63ff56,
0xfb8efd12,0xf844fa0c,0xf5c9f6af,0xf433f519,0xf286f321,0xf31ef2bd,0xf245f2dd,0xf46ff295,
0xf9f7f720,0xfdeefc7a,0x006afee4,0x03700245,0x03ad039c,0x049f0444,0x03640419,0x02b102fc,
0x01d40241,0x025801c7,0x03380316,0x021902c2,0x022101c6,0x02fe02cb,0x04390341,0x07a905f7,
0x0820084c,0x07f907e0,0x098008b5,0x0921096a,0x07a008d5,0x03af05af,0x003b01c9,0xfddbff17,
0xfa42fc32,0xf79bf8a0,0xf59df6cd,0xf34cf41b,0xf3abf394,0xf273f31c,0xf28cf217,0xf74af467,
0xfb86f9e6,0xfed3fcd9,0x020100dc,0x0347028c,0x0474041a,0x03e10448,0x036d03a6,0x020e02c1,
0x023701e4,0x035e02e3,0x02650312,0x022c01f4,0x0265028e,0x03060241,0x06380467,0x07ab0794,
0x07c3076f,0x088b0839,0x097b0906,0x08fb098e,0x060307cd,0x023303ee,0xffdd00fd,0xfc2cfe59,
0xf986fa59,0xf6edf894,0xf477f553,0xf427f42e,0xf331f3f1,0xf177f207,0xf4f9f29d,0xf8adf71a,
0xfcd6fa8d,0x0035fed6,0x02530134,0x04080383,0x04260414,0x04100434,0x02940376,0x02110201,
0x038802cc,0x02b00347,0x028f0291,0x027d0292,0x01e70200,0x04e3031d,0x06cb0627,0x076f0736,
0x07f00793,0x08fc086f,0x09b0098b,0x07fb0930,0x040705f7,0x020102f4,0xfe200045,0xfb69fc7c,
0xf8b6fa3e,0xf587f70c,0xf4aff4ad,0xf41ef4ed,0xf166f266,0xf322f1d1,0xf60df49c,0xfa7bf80b,
0xfde6fc72,0x00c4ff51,0x0309022d,0x03cb0366,0x044b040f,0x03140428,0x02070200,0x02f10289,
0x02bf0314,0x02b30273,0x028b0301,0x016f01b2,0x03210211,0x05930475,0x06c60648,0x072506f3,
0x0826079f,0x099608b8,0x091909fa,0x05d4075a,0x03a504d4,0x001901f4,0xfd0ffe83,0xfab4fbd7,
0xf6bef8f7,0xf56bf56d,0xf4f9f5a9,0xf1fcf340,0xf226f1cf,0xf3d6f2c1,0xf7f4f5a5,0xfb83f9e1,
0xfedafd40,0x01d00069,0x02c80275,0x046d03a6,0x039d0469,0x020902a0,0x02eb024c,0x027002fd,
0x02f70273,0x02dc0331,0x01790213,0x0220018e,0x04510309,0x05fb0566,0x06d60669,0x070506f8,
0x092707ce,0x09b00a08,0x0798089d,0x054d0692,0x02610400,0xfee20068,0xfcf2fdea,0xf894fb1b,
0xf696f6df,0xf60ef6a6,0xf35af4a5,0xf22df2ad,0xf290f1eb,0xf5adf3e6,0xf97ef7c6,0xfce2faf6,
0x0049feea,0x01e9010f,0x03eb02eb,0x044d04a3,0x027d031b,0x030602b7,0x028502ec,0x02f8026e,
0x0333035f,0x020e02a8,0x0184018b,0x033d023d,0x0503041d,0x068505f8,0x06100651,0x084906e3,
0x09c3094c,0x08b80985,0x06fd07d9,0x045b05f7,0x008b0226,0xfefcffd3,0xfaaafd2e,0xf808f8b3,
0xf6ddf7a1,0xf4f5f605,0xf2c6f3bf,0xf1c0f214,0xf400f267,0xf70df5a3,0xfad4f8c9,0xfe78fcbf,
0x0051ff9f,0x031a017c,0x044a0430,0x02ff0394,0x0345030c,0x029b030b,0x02d40291,0x037f032f,
0x02aa0361,0x019201db,0x026701fd,0x040c02d5,0x06100577,0x05a605e1,0x070f0601,0x09540842,
0x093509b4,0x088a08c2,0x064c07dc,0x026a041a,0x011b01e4,0xfcf1ff32,0xf9b1fb16,0xf827f8c2,
0xf669f75e,0xf45bf589,0xf215f2de,0xf2dbf235,0xf547f3ff,0xf89df6a9,0xfccbfae2,0xfed3fdf4,
0x01ec0020,0x03f60379,0x037e03b0,0x037a038c,0x030b034d,0x02b802d0,0x03cb030b,0x033303f4,
0x0241028e,0x01bc01f7,0x031901f3,0x05600484,0x058005a5,0x05e60554,0x08850737,0x0900092b,
0x095c08e3,0x07c2094c,0x046505b1,0x02bc03ab,0xff50014d,0xfb9afd25,0xf925fa6f,0xf7e0f84c,
0xf5e4f71d,0xf2eef455,0xf27cf24c,0xf38ff302,0xf64cf48c,0xfaadf899,0xfcb9fbec,0x0038fe32,
0x02e501f4,0x037a0338,0x0352037e,0x034f036f,0x027502b4,0x037e02d9,0x036f03ba,0x02ee0335,
0x01910234,0x02020181,0x04650331,0x051f051b,0x04c304b9,0x077b05f3,0x080b0817,0x098c0898,
0x08d709b3,0x05b20746,0x045d04ee,0x012702fe,0xfdbfff71,0xfa8cfc10,0xf8cdf971,0xf772f85f,
0xf416f5cd,0xf2aef30c,0xf2a0f2b5,0xf450f2e0,0xf892f685,0xfab9f9d0,0xfe2cfc3e,0x0161ffd7,
0x02d00267,0x03680311,0x038203b8,0x029502cc,0x031402e6,0x0387034d,0x038003a1,0x021102ef,
0x0182017f,0x03640220,0x04d104a7,0x04280413,0x062c053b,0x072706b8,0x08fc07ce,0x098e09e6,
0x0715084c,0x0585064b,0x031f047b,0xffdd0184,0xfc3dfe25,0xf9f7fabf,0xf8eef98d,0xf5a2f77d,
0xf3a5f450,0xf263f323,0xf2d5f1e2,0xf660f4ac,0xf8f7f7c8,0xfbc6fa30,0xff96fda4,0x018900f3,
0x0333023f,0x036c03a3,0x02be02fe,0x02d402c6,0x032402dc,0x03d203ab,0x02e80373,0x010f020b,
0x02cf0151,0x041303e8,0x03bd03c6,0x05550471,0x05e605b7,0x083406bd,0x098d0950,0x08400919,
0x06bd077b,0x04bb05c5,0x02270396,0xfe530068,0xfb56fc77,0xfa6efad8,0xf757f92b,0xf55bf622,
0xf2f5f449,0xf248f21d,0xf4b0f351,0xf792f648,0xf9c3f874,0xfdd1fbd0,0x0044ff3b,0x0288015c,
0x03770350,0x0331033e,0x02d5031c,0x034102e4,0x03c80361,0x04100466,0x017d02be,0x02460152,
0x03c8036c,0x03910386,0x04de044c,0x051104f9,0x071805b8,0x09250872,0x09090945,0x07e20889,
0x060d06ee,0x04360544,0x009d02c5,0xfcfefe52,0xfbc5fc75,0xf90bfa84,0xf727f809,0xf43af5b9,
0xf240f303,0xf383f264,0xf5ecf4e4,0xf80cf6c3,0xfbb6f9ca,0xfe7afd49,0x0161ffe6,0x02de023d,
0x034c036e,0x031002fe,0x02d3031e,0x038902ca,0x04ae047b,0x020b03af,0x02150169,0x032d02e6,
0x03470314,0x047103f0,0x0452046c,0x05bb04a5,0x08150716,0x091408c1,0x08a20904,0x06ce07d4,
0x05f20653,0x02b004db,0xfecd0046,0xfce9fdfc,0xfa8ffba7,0xf899f997,0xf60df770,0xf2d3f44c,
0xf2d7f259,0xf49af3be,0xf64ef52b,0xf97bf80a,0xfcaefaeb,0xff77fe3d,0x022300d4,0x02e202c8,
0x03330306,0x02ab031a,0x02c70236,0x04f0042d,0x02e70452,0x022101f9,0x02bc029a,0x02e402b4,
0x0418038d,0x03d9040a,0x049f03fd,0x06e705c9,0x087707b9,0x091a090b,0x074e0855,0x0734070f,
0x04910668,0x00f40280,0xfe61ffaa,0xfbe7fd2e,0xfa20facf,0xf7dff935,0xf41df622,0xf311f2ff,
0xf385f353,0xf536f435,0xf779f639,0xfaa6f916,0xfd9efc0c,0x00b8ff39,0x022f01bc,0x035402b5,
0x02990351,0x022101d1,0x049c0388,0x03960488,0x027a02ab,0x026c029a,0x028f0255,0x03a30315,
0x038903c8,0x03c8036a,0x0575049e,0x0769063f,0x090c08a8,0x07a0085b,0x07c407a4,0x06300745,
0x02c6047a,0x000a0176,0xfd58fea4,0xfb30fc09,0xf9d0fad5,0xf5c7f7cf,0xf39af46f,0xf331f31a,
0xf3f6f37e,0xf5e4f4c3,0xf89ef742,0xfb6cf9da,0xfef2fd48,0x00c40008,0x031201dd,0x029a035c,
0x019b01b2,0x040702c0,0x03d3044c,0x02f30345,0x027302c3,0x023f022d,0x035102af,0x034f0390,
0x03670321,0x03ff03cc,0x062d0497,0x084707b2,0x07c6083b,0x07fa07b2,0x071e07d8,0x0489060d,
0x01c902ff,0xfeaa0078,0xfc84fd17,0xfb2bfc26,0xf7e8f9b2,0xf4acf61c,0xf34bf3af,0xf335f334,
0xf490f3a3,0xf6ccf5c1,0xf944f7bc,0xfcfffb59,0xff08fe12,0x022f006e,0x0297031c,0x01530198,
0x0322020f,0x03c203af,0x03660395,0x02b5032e,0x01f2022d,0x030c025c,0x02de031f,0x036f032d,
0x030a0338,0x04bb0379,0x0766066c,0x079f0792,0x07de07bf,0x080f0805,0x05e60736,0x03ec04f6,
0x006a024e,0xfde5fed4,0xfc96fd4d,0xfa11fb91,0xf679f834,0xf458f52c,0xf32af3c3,0xf3faf334,
0xf575f4d2,0xf788f631,0xfb4bf98b,0xfd32fc46,0x0112fed2,0x0297028b,0x016e01da,0x029401ce,
0x03990333,0x03dc03ba,0x03680408,0x0261027c,0x02f602c6,0x02f302ee,0x03bd035a,0x02d40379,
0x03da02c6,0x064d0530,0x076d0729,0x07d50764,0x0867085f,0x073407dd,0x05c806a3,0x027f044a,
0xff6e00c6,0xfdebfe97,0xfc39fd45,0xf890fa65,0xf60af738,0xf3d3f4dc,0xf3e6f378,0xf4a4f46a,
0xf622f4f9,0xf9b9f815,0xfb5ffa97,0xff59fcf4,0x0223015e,0x01940209,0x02490194,0x02ee02cf,
0x04390378,0x03dd0465,0x02d70319,0x03100301,0x02c802ca,0x03ef037d,0x030e039b,0x02d902b4,
0x055003e1,0x068d0647,0x078006ca,0x08460829,0x07d4080d,0x073107ab,0x04740603,0x011002ce,
0xff25ffbf,0xfdbbfea8,0xfaa3fc39,0xf7e9f94c,0xf4caf651,0xf42af410,0xf403f443,0xf4d8f402,
0xf819f696,0xf9a0f8d2,0xfd00faf3,0x011bff85,0x0149015e,0x01e0018a,0x024001ff,0x03d902ec,
0x0412046b,0x035a036a,0x02ff036b,0x02c202aa,0x03ab0333,0x038903e4,0x024c02b8,0x0441030b,
0x059c0529,0x06db060a,0x07d907a5,0x07e907cc,0x07db07fc,0x06410752,0x02b7049e,0x0065013c,
0xfef4ffcc,0xfc5bfdab,0xf9dafb48,0xf630f802,0xf4f4f51c,0xf3d3f4a6,0xf406f378,0xf69df53b,
0xf7e8f782,0xfaccf8c6,0xff17fd3d,0x00c8002e,0x018a0136,0x0150016a,0x033f0218,0x03ab03bf,
0x03a4039a,0x0314037e,0x028202c3,0x035f02af,0x03a203e2,0x022102c8,0x0336025d,0x045903d6,
0x05e60510,0x070a06a0,0x07840757,0x07dc079d,0x077b07fc,0x04410633,0x01b002a3,0xffef00da,
0xfdb3feca,0xfbd8fd09,0xf7b6f9b2,0xf5e8f689,0xf447f53b,0xf335f355,0xf594f43a,0xf667f62c,
0xf899f711,0xfcc0fad3,0xff88fe28,0x00f000af,0x00940092,0x02450162,0x033302d3,0x038d036f,
0x036c03a3,0x025102da,0x02ed0234,0x03a303b3,0x025902eb,0x028a025b,0x035002c5,0x04c70414,
0x06240589,0x06e3069f,0x074a06e0,0x08280805,0x05b6075a,0x030103fe,0x00d10225,0xfeecff88,
0xfd59fe74,0xf986fb8d,0xf738f7ee,0xf524f689,0xf307f3a6,0xf4a6f393,0xf530f53f,0xf6eff59a,
0xfa1df8a1,0xfdedfbcc,0x001aff90,0x001c0013,0x0156008a,0x02830207,0x033602dd,0x03d303b1,
0x025b0340,0x02c90213,0x03830388,0x02dd033a,0x02790298,0x02b30265,0x03db0356,0x057a0494,
0x0656060e,0x06c1066e,0x088607aa,0x06f70834,0x04dc05cc,0x0232039d,0x001200ec,0xff28ffc5,
0xfb6dfd85,0xf8fcf9e2,0xf6c4f833,0xf398f4de,0xf47bf3b9,0xf494f4b8,0xf5e0f501,0xf7f4f6c7,
0xfbdef9aa,0xff1cfde8,0xffadff89,0x00a0fff7,0x01e20163,0x02980222,0x04160393,0x02b30386,
0x02a6024e,0x03790343,0x035f037c,0x02b30302,0x027d0288,0x032d02b0,0x04b803d3,0x05e605a2,
0x062905b7,0x0832074f,0x0806086f,0x06770742,0x03d30569,0x0177024f,0x00c70135,0xfd9bff7d,
0xfb11fbef,0xf8e1fa72,0xf536f6aa,0xf4baf4c9,0xf4c1f4af,0xf588f522,0xf6a3f5e6,0xfa03f7fd,
0xfdeafc30,0xff54feff,0x0065ff95,0x01640127,0x024b01a2,0x044f0374,0x03740416,0x02f40307,
0x039e0331,0x03d503d8,0x035f03ab,0x02f6030e,0x02ad02d7,0x045f033a,0x054d0526,0x05a40551,
0x07a40696,0x0840082d,0x07e40827,0x0579070c,0x02ab03c6,0x02300251,0xff280117,0xfd0ffdb4,
0xfaacfc47,0xf712f8a9,0xf546f60c,0xf4c6f4d8,0xf541f516,0xf592f539,0xf7c0f654,0xfc1ff9fc,
0xfe36fd77,0xffc7fed4,0x00a50085,0x017e00bb,0x039102a4,0x03cc03fe,0x031d035f,0x0345031b,
0x040303b9,0x039203c7,0x035c039d,0x024f02bc,0x0394029d,0x04ae046c,0x04d30492,0x069b05ad,
0x07af0732,0x08570813,0x06d30824,0x039b04db,0x033e036b,0x005d0218,0xfe80ff2b,0xfc51fdba,
0xf900fa88,0xf60cf77c,0xf4edf53f,0xf516f4e9,0xf4ccf509,0xf5cbf4da,0xf9e3f7bc,0xfc57fb5b,
0xfec7fd8f,0xffb8ff7c,0x004bffdc,0x02820157,0x0375032b,0x0306036e,0x02ec02b9,0x0382034c,
0x0392037f,0x039803bf,0x021c02e5,0x02c901fb,0x03c80399,0x040803d1,0x057a04a0,0x06780611,
0x0842072d,0x07b608c7,0x04b005d9,0x04100459,0x01840308,0xffd80082,0xfdd9fee5,0xfadcfc7b,
0xf79bf937,0xf55df63b,0xf53bf517,0xf4abf543,0xf483f40a,0xf7bbf60d,0xfa79f927,0xfd64fbdb,
0xfed3fe80,0xff71feef,0x011f002e,0x02f80227,0x02e5032b,0x02d002ad,0x031202f1,0x035d0322,
0x03f203e8,0x02550331,0x025201f7,0x035502f9,0x034c0352,0x04b203da,0x051004ef,0x078d05fe,
0x0821089d,0x05b606a5,0x04c20554,0x02b803d4,0x00c501a1,0xff14ffff,0xfc96fdf8,0xf982fb15,
0xf620f7c9,0xf5bff587,0xf4d1f5a2,0xf3d8f3fa,0xf600f4b1,0xf84ff71d,0xfbcef9fb,0xfdc8fd11,
0xfe9cfe38,0xffd3fefe,0x02020102,0x02ab02a2,0x02c50295,0x02b002de,0x031302a8,0x041003d1,
0x02d703a3,0x022d0221,0x02f102c0,0x02e402c8,0x042d037a,0x03ed0423,0x069f04d4,0x07fb07de,
0x06a5075e,0x05a50629,0x03e704db,0x01dd02dd,0x00650127,0xfe46ff57,0xfbbbfd50,0xf7a0f987,
0xf66df69a,0xf58af657,0xf3faf471,0xf4ecf44a,0xf6a9f59d,0xf9e3f836,0xfcc3fb86,0xfde0fd7b,
0xfec1fe2a,0x0117fff1,0x022a01d8,0x02e20277,0x028502d8,0x02b50267,0x043f037f,0x0356041d,
0x029302a7,0x02d702e1,0x02a00265,0x03eb037f,0x033d038a,0x056603e4,0x078d06da,0x075507a2,
0x067706de,0x050505f8,0x033e03f2,0x0172027a,0xffe20082,0xfdf5ff3c,0xf997fbd7,0xf7b4f827,
0xf665f74f,0xf4c4f569,0xf482f475,0xf587f4dc,0xf824f6b5,0xfb7bf9d5,0xfd37fca4,0xfdecfd67,
0x0013ff0b,0x018b00d2,0x02ce022a,0x02c20319,0x02660247,0x04310331,0x03b90470,0x035a0328,
0x02dd0363,0x02c20271,0x03fa039d,0x02f90378,0x044c034c,0x06dc059a,0x076b0768,0x0766077a,
0x060206d6,0x049d0542,0x029203b7,0x0110018e,0x000500df,0xfbc9fdfd,0xf952fa42,0xf7a3f893,
0xf5daf6a9,0xf4c2f52b,0xf4e8f4a9,0xf68df59e,0xfa03f804,0xfc50fb88,0xfd51fcc9,0xff1bfe1f,
0x008bffe0,0x026c0177,0x0312031f,0x02170259,0x04190303,0x03e80452,0x03ff03b9,0x032303ef,
0x02d9027e,0x03eb038a,0x032103b6,0x036602cb,0x05b60493,0x06f70669,0x07a60782,0x06bb0756,
0x05d9062e,0x03980511,0x02060263,0x01870212,0xfdf4ffed,0xfaf9fc3a,0xf8def9f4,0xf712f7df,
0xf54cf61a,0xf4c8f4f9,0xf544f4be,0xf829f671,0xfb0ef9ee,0xfc67fbbe,0xfe00fd23,0xff57fece,
0x01940026,0x02e202cf,0x01dc022c,0x039a029c,0x03aa03cb,0x04630402,0x0381042f,0x02ba02d2,
0x03e50349,0x034203f9,0x02df02a3,0x047b0396,0x06170550,0x0798070a,0x06ff0768,0x06d306d6,
0x04a60625,0x02c2034d,0x02b502d5,0xffea0199,0xfcd5fe53,0xfa6ffb76,0xf842f969,0xf661f740,
0xf53bf5c1,0xf488f4ad,0xf68cf541,0xf98ef81f,0xfb3dfa7f,0xfd2efc33,0xfdf8fdaf,0x006ffecd,
0x02510202,0x01cc01cb,0x02d80259,0x03490313,0x044f03d3,0x03fb046d,0x02a60314,0x03b70312,
0x037003f0,0x029a02bf,0x035102e4,0x04db03e2,0x06e0061a,0x06c906e1,0x073f0701,0x059e06ea,
0x03770423,0x031f0355,0x0185029e,0xfe720000,0xfbd2fd08,0xf978fabc,0xf773f841,0xf5dbf6c3,
0xf45cf4fa,0xf523f450,0xf7cdf681,0xf9c6f8ca,0xfc48fb13,0xfc7afc8d,0xff21fd58,0x013000aa,
0x0182013f,0x022101d8,0x028b025c,0x03f2031e,0x04260460,0x02bd0355,0x036c02dc,0x036603b1,
0x02b802e5,0x027502a1,0x03af02bd,0x05dc04e7,0x06170613,0x075b06b6,0x064e0739,0x0423051d,
0x037f03b3,0x02b6033d,0xfff50184,0xfd70fe97,0xfac2fc21,0xf885f987,0xf6edf7bf,0xf4b8f5d6,
0xf456f40b,0xf64cf569,0xf821f6f3,0xfb35f9e3,0xfb45fb5a,0xfd90fc16,0x0009ff0e,0x00f3007d,
0x01c50179,0x01c401c5,0x03530249,0x043f0429,0x02f30398,0x03750309,0x0382038b,0x033f036e,
0x024802dc,0x02c20203,0x04db040b,0x0581052f,0x0726063a,0x070b0782,0x0526061c,0x03f8044c,
0x039303eb,0x01ab02c9,0xff360064,0xfc8cfdec,0xf9f2fb35,0xf87af91d,0xf5cbf763,0xf49bf4a3,
0xf550f526,0xf6fbf5a7,0xfa2ef8c9,0xfaa1fa9d,0xfc52fb24,0xfee1fdbd,0x0058ffa1,0x019d011f,
0x0164019e,0x02bc019e,0x043503ec,0x036e03d8,0x03950356,0x038303a5,0x040103c6,0x029b038a,
0x025d0206,0x041e0358,0x04cb0460,0x069a05a2,0x0796075e,0x06200712,0x04c80544,0x045604a0,
0x032403db,0x00f50215,0xfe92ffe0,0xfb8efd0a,0xfa59fad0,0xf752f912,0xf5b1f61a,0xf513f577,
0xf5f5f4fd,0xf928f7a7,0xfa29f9f4,0xfb62fa7b,0xfdb2fc94,0xff76fea3,0x01770093,0x01100178,
0x02200139,0x0410035c,0x03be03ec,0x03d803db,0x039b039a,0x047d0402,0x033f0441,0x02700263,
0x038602fd,0x041a03db,0x05aa04b7,0x078a06c4,0x06d40776,0x057a0614,0x04d60516,0x0416049c,
0x02620326,0x004501a6,0xfd13fe6e,0xfbc8fc6a,0xf8d3fa70,0xf6f5f7a9,0xf54cf631,0xf508f4b1,
0xf7d7f660,0xf966f8e2,0xfa66f9b0,0xfc52fb7b,0xfe4afd1e,0x00c2ffa5,0x00b40118,0x0169009a,
0x032f0280,0x03af037d,0x03ec03ef,0x0363037f,0x049e0400,0x03cd049b,0x029202ee,0x030802ad,
0x03650358,0x047b03ac,0x06d705b7,0x072b0746,0x05e806ae,0x05570560,0x0470051a,0x039603db,
0x01b20314,0xfeaeffe5,0xfd21fe00,0xfa44fbcc,0xf867f927,0xf61bf761,0xf49df502,0xf6aff557,
0xf84bf7b7,0xf98bf8d3,0xfb07fa58,0xfc9bfb8e,0xffccfe53,0x002f004b,0x00b20021,0x021e018e,
0x035902ae,0x03cf03dc,0x032b034b,0x046d03bf,0x045004b2,0x02e10380,0x02e502b1,0x02e60312,
0x037f02e3,0x058c046b,0x072706a6,0x062506ca,0x05d705db,0x0491055e,0x0466044a,0x02f00414,
0x001f0153,0xfe72ff75,0xfbb0fd0f,0xf9c6fa8f,0xf778f8e6,0xf4d3f5c5,0xf5b4f4e7,0xf730f69b,
0xf8bdf7c5,0xf9dff989,0xfb04fa26,0xfe81fcc7,0xff7bff58,0x0026ffa5,0x00f700a8,0x02b701a5,
0x0393037c,0x02f9032b,0x03fe0350,0x0499048d,0x033503eb,0x03020303,0x02b602e2,0x02ab0299,
0x04310322,0x068605b6,0x0633066e,0x061e0640,0x04c0058a,0x04da0488,0x03cb04b8,0x0173028f,
0xffd800a0,0xfce4fe83,0xfb23fbcd,0xf909fa59,0xf594f725,0xf553f51d,0xf61df5c0,0xf7e1f6c5,
0xf8fef8d2,0xf994f8f2,0xfcfafb36,0xfe89fdfd,0xffabff1d,0x0010ffee,0x01d500a4,0x034202d4,
0x02d20326,0x03a502dd,0x04950468,0x03cc043f,0x033a0384,0x03010305,0x023302b8,0x03360245,
0x05890492,0x062005dc,0x06840693,0x052705d4,0x051604f2,0x04af0534,0x02be03a3,0x014d0218,
0xfe770017,0xfc9ffd32,0xfaf0fc19,0xf730f90b,0xf5d1f636,0xf594f59b,0xf751f613,0xf889f865,
0xf8b4f848,0xfb6af9f4,0xfd80fc8e,0xff25fe86,0xff73ff51,0x00b1ffd5,0x02df01f5,0x02a00300,
0x03410295,0x044903ff,0x04470467,0x038a03d6,0x038c038c,0x023f0318,0x029101e4,0x04430393,
0x05ba04f5,0x0694065c,0x0564061b,0x05540530,0x05310576,0x03b10468,0x02a3033d,0xffe80184,
0xfdd0fe7a,0xfc92fd75,0xf918fae7,0xf6e6f7cb,0xf542f5f1,0xf6aaf58a,0xf7e6f7b3,0xf814f7c2,
0xf9d4f8d6,0xfc4cfb0f,0xfe65fd7c,0xfeedfed7,0xff99fef9,0x022900fb,0x026d0278,0x02d10279,
0x0403035c,0x047d0478,0x03ba0406,0x0437040b,0x02a60388,0x02540233,0x035402db,0x04ec03f4,
0x066e05e9,0x059d0638,0x0581055c,0x058a05b1,0x046604f1,0x03e70436,0x016302ec,0xff18ffe0,
0xfdf5febb,0xfb14fc8f,0xf8a1f9da,0xf5aff705,0xf65cf59c,0xf773f713,0xf7b7f791,0xf8bcf81e,
0xfae9f9b4,0xfd97fc37,0xfe66fe66,0xfeedfe51,0x011bffff,0x023001d5,0x0265025b,0x03a302b6,
0x046e047a,0x04060411,0x0497045d,0x03470425,0x028102af,0x02a40292,0x03f00302,0x0600051e,
0x05c7062d,0x05af0577,0x05c205ef,0x04c40539,0x04e404d6,0x02ab0422,0x0062013b,0xff1bfffa,
0xfcdffdd9,0xfa84fbfe,0xf6d1f887,0xf631f613,0xf714f69d,0xf758f743,0xf817f7a6,0xf937f878,
0xfc6bfab8,0xfdaafd73,0xfe1ffda1,0xffc4fef1,0x01ae00da,0x01b701d0,0x03030211,0x040703dc,
0x03ea03d2,0x04bb045c,0x03e50489,0x02f80359,0x026002a4,0x02e80253,0x053c041d,0x059405b7,
0x0595055b,0x05e105fe,0x04d9054e,0x057f050b,0x03ad0507,0x01bf0279,0xffff0106,0xfe4dfeed,
0xfc6afdb2,0xf881fa72,0xf677f70a,0xf6c2f69d,0xf71df6cd,0xf794f776,0xf7d8f788,0xfb04f93a,
0xfcd2fc32,0xfd65fd30,0xfe9ffdca,0x00d8ffe1,0x010b010d,0x02490169,0x03820328,0x03a40375,
0x0480041f,0x04460499,0x037d03d6,0x025d0308,0x020c01e5,0x04360307,0x04ff04e3,0x054404f2,
0x05e505e6,0x04bd0525,0x059b051c,0x0471055f,0x02f3038f,0x00be0203,0xff39ffd0,0xfe11fec8,
0xfa56fc7a,0xf765f882,0xf6a0f6f6,0xf6e0f670,0xf741f75e,0xf703f6e4,0xf93bf7ea,0xfbcffa9d,
0xfc88fc77,0xfd7dfcb3,0xffd2feb7,0x00430032,0x018000ad,0x02c5024a,0x032802ee,0x042103aa,
0x044f045a,0x04120429,0x02d003ac,0x01ae0201,0x03410223,0x0425040c,0x04e8043e,0x05a905a0,
0x04af0508,0x05690514,0x04ee0540,0x03da0478,0x01cc030c,0xfffe00a8,0xff6dffbc,0xfc4bfe45,
0xf915fa6f,0xf6daf7d8,0xf6e5f684,0xf717f73d,0xf6b0f6cb,0xf7bdf6e0,0xfaa5f92b,0xfbc9fb95,
0xfc7bfbce,0xfec2fdb5,0xff84ff50,0x00c0fff7,0x02150184,0x029d025d,0x03b50330,0x041c03e5,
0x04790452,0x03be0464,0x01b9028c,0x02cb01f0,0x035e0364,0x04920399,0x055d055b,0x04eb0512,
0x05560516,0x053f0554,0x04d20522,0x031f0440,0x00d001a5,0x009300b8,0xfe44ffb3,0xfb39fccd,
0xf7eaf96a,0xf731f744,0xf766f758,0xf6d4f72d,0xf6c4f68c,0xf984f7ef,0xfb1efab9,0xfbbcfb2d,
0xfdcafccd,0xfed9fe7a,0x0019ff45,0x016300e5,0x024001c4,0x035802cb,0x03e203ba,0x04ba042b,
0x04c00524,0x024c036a,0x02da0265,0x02db02ee,0x0428032f,0x05380501,0x051c051f,0x05570529,
0x054b0560,0x05ad0560,0x045e057a,0x01fe02dd,0x017501cc,0x001a00d4,0xfd83ff0d,0xf9cafb9a,
0xf7f1f890,0xf7e6f7c8,0xf768f7da,0xf671f6c0,0xf896f731,0xfa6ef9c4,0xfb0dfaa8,0xfd0ffbff,
0xfe1ffdb3,0xff65feb1,0x00cd0028,0x01ae0134,0x02f9024f,0x035e0373,0x049e0398,0x05480582,
0x032d0428,0x030702f3,0x028102bf,0x036c02be,0x04c4043e,0x04d404d2,0x055f051f,0x04d70537,
0x05e80527,0x051205fa,0x02fd03ec,0x01e90269,0x01190178,0xff52007e,0xfbbdfda2,0xf8bdfa0d,
0xf82ff818,0xf7daf84f,0xf657f6f5,0xf77cf67f,0xf961f8b7,0xfa3ff9ba,0xfbdefafe,0xfd2bfca2,
0xfe64fdbe,0xfff6ff2f,0x00ad0057,0x02750187,0x028802bf,0x03f602c6,0x054d0527,0x03fb04a2,
0x03530396,0x027702f0,0x02b3024e,0x041f0384,0x0462042e,0x052e0503,0x047704c8,0x058d04c4,
0x058805e9,0x03db04c4,0x02550300,0x01ae01e6,0x00900156,0xfddaff6d,0xf9f7fbd4,0xf8a0f8eb,
0xf870f8b2,0xf67cf777,0xf6caf649,0xf84ff7a8,0xf95ff8c9,0xfac2fa03,0xfc39fb9e,0xfd60fca1,
0xff0afe59,0xffb1ff45,0x01ca00b6,0x01b801fb,0x0323020a,0x04ee045c,0x047d04d7,0x03da041e,
0x02b0037a,0x02830236,0x03500310,0x040f0383,0x050204c7,0x045804a6,0x05110484,0x05c7059f,
0x04ce0579,0x030203d9,0x022e0298,0x01a501dc,0xffd00104,0xfbd0fdff,0xf971fa25,0xf930f967,
0xf724f843,0xf69ff697,0xf7a1f704,0xf887f820,0xf9fdf91f,0xfb47fac8,0xfc99fbaf,0xfe2afdae,
0xfed6fe47,0x01100008,0x01200149,0x022b0166,0x04510354,0x047a048d,0x04990499,0x031103fd,
0x02a6028f,0x02a702bc,0x039102d9,0x04c2045a,0x043a0490,0x049a0453,0x05ae0514,0x056405d1,
0x03eb04bd,0x02af0330,0x02350251,0x0189021d,0xfdf60022,0xfacafbe0,0xfa01fa6a,0xf844f947,
0xf6e6f753,0xf76df708,0xf7def7b1,0xf987f885,0xfa5afa26,0xfc00fae3,0xfd67fd19,0xfe2afd7d,
0x005fff4d,0x00e100f0,0x017f00d8,0x03a302b1,0x046203fe,0x053f0502,0x03ec04b2,0x0355037e,
0x02a5031d,0x03490293,0x04820410,0x048104b5,0x04600444,0x057304d0,0x05ea05e6,0x04e6058a,
0x036b0426,0x029202cb,0x02e702d8,0x001d01f0,0xfc87fe15,0xfb18fba7,0xf98bfa7f,0xf78ef853,
0xf78af781,0xf763f75f,0xf913f818,0xf97bf96b,0xfb45fa27,0xfcaafc3c,0xfd2afcc8,0xff8efe3a,
0x00450053,0x00e30032,0x028001db,0x03d50311,0x054104bb,0x046004f7,0x03f50431,0x02df0374,
0x02b9028a,0x04220366,0x04760480,0x04230431,0x04de0459,0x05ca0576,0x058b05bf,0x0412050b,
0x02c80323,0x03770314,0x01d4030f,0xfe48001d,0xfc44fcf7,0xfaabfbb4,0xf880f952,0xf7c6f838,
0xf725f729,0xf861f7c1,0xf8d2f8af,0xfa47f94d,0xfbf5fb54,0xfc1afbf7,0xfea6fd37,0xff8cff69,
0x0035ffad,0x017300ff,0x02ee01e9,0x04a4040c,0x04bf04cb,0x047a049f,0x035a040b,0x026f02ac,
0x039302d3,0x04540421,0x03dd042c,0x045a03f2,0x053804d1,0x05e50594,0x04c105bf,0x031003a1,
0x037d031d,0x032803ad,0xffe801be,0xfdbdfe73,0xfba3fcf0,0xf9cbfa83,0xf83df921,0xf743f779,
0xf7e6f785,0xf83ff83b,0xf972f86b,0xfb34fab2,0xfb59fb36,0xfd95fc3f,0xfeb4fe64,0xffccff28,
0x00730031,0x01f200fd,0x03e50307,0x049b045b,0x04d604bd,0x03ff04ac,0x02a5033d,0x03030282,
0x042203be,0x03ca0418,0x040a03c7,0x0471042d,0x05d4051d,0x056b0601,0x0387045f,0x0350031d,
0x040a03f8,0x015802e5,0xff46002c,0xfcc9fe23,0xfb1bfbd8,0xf934fa2e,0xf77bf834,0xf7eff78b,
0xf7a1f7e8,0xf8a5f7bd,0xfa72f9e0,0xfa97fa5e,0xfc6dfb6a,0xfdc5fd2a,0xff1dfe77,0xffa1ff6a,
0x00c2000e,0x02ec01e0,0x04030388,0x04db047e,0x04ae04ff,0x030f03ee,0x02ab027f,0x03c80355,
0x03cd03cb,0x03dc03df,0x03c603af,0x0555047b,0x05e405d5,0x0416054e,0x0350032f,0x04590418,
0x02af03a2,0x00a901c7,0xfe3fff80,0xfc54fd18,0xfa7afb9e,0xf829f91e,0xf837f7fa,0xf75ff802,
0xf815f745,0xf99ff91f,0xf9fdf9b2,0xfb52faaf,0xfcd5fc05,0xfe65fd9c,0xfef1fedc,0xffccff2d,
0x01b300b3,0x031e027a,0x046303c6,0x051904e4,0x03a20496,0x02a702db,0x033502eb,0x03b60364,
0x03a103e5,0x03740366,0x045003bf,0x05fe0530,0x04a405ce,0x036703a8,0x03e10396,0x039503f8,
0x01d102cb,0xff6200a2,0xfd45fe35,0xfb8cfc8b,0xf902fa21,0xf842f87a,0xf78af7f6,0xf7a4f765,
0xf8c1f817,0xf9d8f974,0xfa81fa15,0xfc05fb2a,0xfda7fcde,0xfebbfe4f,0xff48fef1,0x00a8ffd8,
0x028f01b0,0x03c80325,0x0501047b,0x04790507,0x031a03c0,0x02c302ac,0x03bb0347,0x03bf03cd,
0x03ad03c1,0x03a60371,0x05720489,0x05ac05d6,0x03f604f8,0x037f0358,0x043e0415,0x02cc03a2,
0x00b201e2,0xfe60ff84,0xfc80fd59,0xfa70fb99,0xf85df93b,0xf830f819,0xf765f7f0,0xf81ff75b,
0xf995f918,0xf9fdf9b0,0xfb4cfaa9,0xfcd3fc02,0xfe63fd9b,0xfeeffed9,0xffcaff2d,0x01b000b3,
0x03190274,0x046b03c8,0x051404e8,0x03aa0494,0x02b502e6,0x033f02f8,0x03c4036f,0x039d03ee,
0x03620354,0x047d03c9,0x05ed0555,0x049205a0,0x039503c6,0x03f103b9,0x03c6040b,0x01e60301,
0xffb600bb,0xfdbdfebc,0xfba8fcc0,0xf992fa7a,0xf881f8f8,0xf7a7f808,0xf7dff7a0,0xf8d0f83f,
0xf9baf962,0xfa57f9f8,0xfbf2fb0a,0xfd98fcd3,0xfe44fe0f,0xff2bfe8f,0x0080ffe4,0x0201011d,
0x03dc0302,0x051e049a,0x04700505,0x036c03dd,0x03190318,0x04040381,0x03d0042e,0x03030349,
0x042b0352,0x0590051e,0x0505056d,0x043704a6,0x03ca03b9,0x04a70465,0x02f5040a,0x016f0203,
0xffba00ca,0xfd2bfe68,0xfb88fc42,0xf9a0faa1,0xf852f8dc,0xf7f6f80f,0xf889f817,0xf929f8f4,
0xf996f95d,0xfac6f9fd,0xfcd9fbd9,0xfd0dfd2d,0xfe72fd76,0xff50ff0b,0x007effd6,0x028e0151,
0x04ac03d9,0x04ba04e6,0x040c0478,0x03150376,0x03f20348,0x04270472,0x02a10352,0x03780295,
0x04f80490,0x050c04f4,0x045604eb,0x038f039e,0x04c0043e,0x0396046d,0x026202d5,0x010f0200,
0xfe7fffbb,0xfcbffd88,0xfac7fbdf,0xf90bf9d3,0xf7edf856,0xf821f7e4,0xf8b4f86f,0xf8f1f8f0,
0xf982f8df,0xfbd0fae2,0xfc4bfc03,0xfd6efcde,0xfe7dfe01,0xff35fedb,0x00f6ffd2,0x03740251,
0x04840427,0x046f04a6,0x030603af,0x037302f4,0x04670426,0x029b03a4,0x02e40257,0x04010395,
0x0502046d,0x0471051e,0x036b03ad,0x048403e3,0x03ea0484,0x030a0359,0x021d02d2,0xffc600ea,
0xfdf3fed1,0xfc03fd02,0xfa14fb04,0xf876f925,0xf7f0f828,0xf8b7f814,0xf870f8ed,0xf8e8f848,
0xfab0f9e3,0xfba7fb38,0xfca3fc24,0xfddefd4d,0xfe59fe24,0xff95feb6,0x01f500d1,0x03f80300,
0x049c0489,0x03680435,0x032a02d5,0x047e040c,0x02fd03ef,0x02a8029e,0x032202cf,0x04b103d0,
0x04b60523,0x036c03e3,0x043003a4,0x04000453,0x037a039f,0x02da0353,0x00f501f4,0xff0d000a,
0xfd58fe1d,0xfb05fc46,0xf97cfa3f,0xf7d8f874,0xf8b4f827,0xf840f8b6,0xf856f80d,0xf9b7f8eb,
0xfad7fa5f,0xfbc3fb43,0xfd40fc77,0xfd92fd84,0xfe88fdf7,0x0074ff56,0x02b9019a,0x049303d6,
0x039f048d,0x030b02d1,0x043e03d0,0x03880416,0x02d7031f,0x0275027a,0x04110306,0x04c104d9,
0x038a040f,0x03eb0394,0x03f40421,0x03cb03c6,0x035003ae,0x021c02ed,0x001d00ef,0xfe86ff80,
0xfc71fd57,0xfaa1fbc2,0xf876f93d,0xf8b4f86e,0xf883f8cd,0xf81ff81e,0xf917f878,0xfa4bf9e1,
0xfb2dfa8e,0xfca1fbfe,0xfd47fd17,0xfdd5fd7c,0xff59fe72,0x01510035,0x045b02f6,0x041204b2,
0x034d0352,0x042d03cc,0x042c0440,0x039203f4,0x026002e1,0x039f02a3,0x04de048f,0x03f00472,
0x041f03f8,0x04230410,0x04060432,0x04290404,0x030903df,0x01a0022d,0xffbf00e2,0xfe2bfec5,
0xfc36fd61,0xf986fab6,0xf92af929,0xf90af91f,0xf833f8a2,0xf8eef860,0xf9daf97c,0xfab0fa29,
0xfc0ffb52,0xfd13fccb,0xfd7efd22,0xfe7efe0d,0xffd6fee1,0x037f019e,0x04350458,0x039603be,
0x041503d4,0x04680437,0x0443049a,0x02ad038b,0x032d026d,0x04840429,0x0465047e,0x04160434,
0x04430431,0x03f4040f,0x048b0446,0x03ab0430,0x02bf0343,0x00d601f5,0xff86fff2,0xfdadfee0,
0xfafbfc50,0xf9b4fa0b,0xf993f9b5,0xf887f90f,0xf8b6f877,0xf97ef909,0xfa0ef9ce,0xfb7ffaa0,
0xfc95fc3d,0xfd3ffcc5,0xfdcefdbb,0xfe69fdc6,0x01ff0004,0x03d40371,0x03cf03d5,0x03e503d5,
0x044c0408,0x04fe04d2,0x031f0439,0x02f602ab,0x04180380,0x046b047e,0x04300413,0x04220466,
0x03e403d3,0x0481043e,0x03fd044f,0x03a603f9,0x01b802c0,0x006800e8,0xff14ffef,0xfc42fdd0,
0xfa78fafc,0xf9ddfa39,0xf8fbf96f,0xf874f887,0xf916f8bd,0xf965f943,0xfab9f9e9,0xfbd7fb67,
0xfccbfc42,0xfd6ffd50,0xfd51fd30,0x000bfe5a,0x030e01d1,0x03a7037c,0x03b503c8,0x03f303a4,
0x04ec0481,0x040304c4,0x02a60315,0x039202f2,0x0449040f,0x04190441,0x0446043c,0x03c603f6,
0x043203e9,0x043c0462,0x03fa0404,0x02b50399,0x00e801b2,0xfff5006f,0xfdccff13,0xfafdfc41,
0xfa39fa78,0xfa06f9dd,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_piano_kpianodx5[3200] = {
0x00000000,0x00780121,0x00cf00f6,0x00c500ce,0x009c008b,0x007c005b,0x00690047,0x006b0042,
0x00660051,0x0037003e,0x000c0011,0xffeafff0,0xffe4ffde,0xffe6ffe4,0xffeeffe5,0xffd6ffde,
0xffb4ffc2,0xff83ff94,0xff6cff77,0xff7cff70,0xffbeff95,0xfffeffde,0x00420019,0x006d0072,
0x00840077,0x00b7009a,0x00dc00cf,0x010600f9,0x00f600f9,0x00e400eb,0x00f800e2,0x00c700e2,
0x004c002a,0x02e801c1,0x02e9fd3c,0xf722f678,0xf42cedb3,0x0fc8fef5,0x0510166f,0x0742128f,
0xf988072f,0xfb83fa34,0xd177e839,0x0708e438,0x2ebd1429,0x2ce12ef7,0x02031cad,0xe764024d,
0xa64ebbc1,0xf0eac896,0x35dafdd4,0x583e42c6,0xfacf221b,0xbc96d93f,0x9177956a,0x02c9df19,
0x50b53133,0x68e77050,0xfd2d282b,0xd609f2b8,0x97a3a1cb,0xfa1fe873,0x358935e6,0x4dbc534a,
0xf9cc139c,0xe23ee8b3,0xbe329ce8,0x013ddc3a,0x2f751a44,0x392852aa,0xeeac0373,0xe720fef7,
0xd686a271,0x1c93ed40,0x2bdd1ef9,0x1d094a2d,0xccece64b,0xbd82fff3,0xcb51b4db,0x2c85fe96,
0x48fb279a,0x2230524e,0xdcdde3db,0xb6b2fc04,0xcebebb3e,0x225a0971,0x453d19da,0x271f44d0,
0xfe37d201,0xc854f25f,0xc7f1b770,0x19b405a3,0x493c239b,0x131449da,0xff2fd71c,0xd0b5e79f,
0xd6a2bdad,0x23da2189,0x4d1b4810,0xf2af56c8,0xe353d8c6,0xbbacceb6,0xde24aad3,0x294d1c4f,
0x69a448e8,0xfa015ab3,0xdecce949,0xb810c777,0xecc99e9c,0x2760049f,0x764a3620,0x0c764b8d,
0xf0c300f0,0xb5d9e01d,0xdc5ba819,0x04fef92d,0x589527f4,0xf8e5266e,0xefe6ff68,0xbfbcfd05,
0xf2e4d4fa,0x092d130f,0x4e1338d5,0xf5711563,0xecbee7f2,0xb4cadc25,0xe7debf00,0x0690fe63,
0x640c4bce,0x1e022886,0x0157f68f,0xab8acd0a,0xdbb7acb9,0xff07e292,0x50ff50e9,0x15ec3541,
0x09ed0fa7,0xbfb7e20d,0xede7cf32,0xf81ae556,0x26d8432c,0xed87157c,0xf9acfe9d,0xc22de1a5,
0x059ce318,0x2c64f3a9,0x40f54e30,0xfb6115a2,0xeee8fbb0,0xaea9c2e8,0xeb26ce44,0x2ea5de85,
0x4fc74c27,0x13c82191,0xf9bb0dfb,0xa4ddc414,0xbec7cf3c,0x161cd665,0x475047e7,0x1e3b28d8,
0x04a72549,0xbabfd04f,0xc559de5c,0x1675e646,0x37464773,0x18331b75,0xfe791157,0xce96b735,
0xd64dd5a6,0x3aa6f643,0x4fa16071,0x22e829f3,0xe83014a0,0xbf37a600,0xbf62b857,0x2e69e28d,
0x418f5cab,0x1f4a333f,0xdf1e2b12,0xbcddbbff,0xba64bbae,0x2e9de834,0x3ad2517d,0x29b4281b,
0xe1722c07,0xd195d0d5,0xcdf7cb3d,0x45e0f3a2,0x43a14e43,0x2d561699,0xd0ab0c91,0xc89cc08e,
0xcae5c464,0x4770036f,0x3bd856a7,0x32e61d1c,0xcc2a04e5,0xbd40c234,0xbe5fc1ae,0x3dc50d0a,
0x254c59c8,0x25c21fd1,0xc7d5f76c,0xc83abfe6,0xca78bb3a,0x42250a33,0x200751e1,0x272f2424,
0xcd7fed65,0xcb8abc2b,0xd8b2af1a,0x55f0094e,0x252a4ba3,0x21822fe8,0xc795f14e,0xc35cc9f7,
0xd9c2b75a,0x5c8e1779,0x2bf94d60,0x20833f40,0xc54df6a0,0xb79ad4f8,0xd336bd80,0x584c1e45,
0x2f6b3af8,0x1d5731ce,0xc87ae107,0xb230c818,0xd366b467,0x5d422827,0x3a143a0c,0x1c1c30dc,
0xcf8ed66d,0xb21dbd66,0xcf0bad8b,0x4ebc331a,0x394041a4,0x18cc422b,0xd8a6e488,0xb8e9c826,
0xd6a3ad9a,0x42c436eb,0x2f2d3baf,0x08203e61,0xd324e458,0xb687c0f7,0xe992a0ba,0x4dbd3418,
0x42bf3975,0x0c303e6f,0xd186e698,0xaeb1c1cf,0xf3c29f7c,0x4f5f32e8,0x4ebd39d7,0x1151400d,
0xd722f5fd,0xa2e7d422,0xebf1a915,0x3ee93551,0x4ef93d2b,0x0ef83b0b,0xd77fee0e,0x9bb7cf0f,
0xefb4ad8b,0x3747359b,0x4e533c9e,0x11512e04,0xe1b6e19e,0x9c85c153,0xf703a9f8,0x33b52fda,
0x4d734358,0x11f134bf,0xe8f8e8e6,0x9643bb64,0xf78da6f6,0x2f062cf0,0x45754dc9,0x07f23da0,
0xe6a2f4be,0x97a4bfb5,0x0252b37e,0x3396264d,0x421846cd,0xfdbf329f,0xe481f34d,0x975cb940,
0x09e4b787,0x40511f89,0x527d4500,0x06d42f03,0xe86df9ac,0x8f7cb660,0xfdf8bedc,0x34cb1b43,
0x4f974212,0x07742b6a,0xe4b9feb1,0x8b71b23e,0xf597c8a5,0x30102234,0x4aff493b,0x07ba25ce,
0xe918fd2b,0x95bba736,0xf60cc799,0x2c341b80,0x47d34756,0x0b5f1f9e,0xe9aaff2d,0xa0069d1d,
0xfb4fc3dc,0x2ee71703,0x42a54c59,0x0921234c,0xe2340b7f,0xa3cba326,0xfbe4cbc2,0x32a817ce,
0x41065251,0x0aea251d,0xd68814b9,0xa4cea7dd,0xfd8bd12b,0x3b8014b4,0x42ec4cca,0x16031adb,
0xd4ff10af,0xa897a4f4,0xfc5ad29a,0x3ced13c2,0x3c34484d,0x19f10f10,0xce410637,0xa470a0f1,
0xef27d357,0x33b21655,0x31a84df1,0x20541779,0xd1200a18,0xb0c6a709,0xf417d9c5,0x39df1bb9,
0x2bc55282,0x23791e26,0xce1e0484,0xb81fa07d,0xf837d283,0x445d1682,0x2baf4de2,0x23d221f1,
0xc76102e9,0xb726a264,0xf5dbd003,0x466f1433,0x259d45f6,0x1f4025c5,0xbe740187,0xb3f8a9d8,
0xf2d4d7de,0x4e46201b,0x2ae6456e,0x26332a0b,0xc041003b,0xb6c0aea6,0xf27ad848,0x50c024e3,
0x2da83ce4,0x27fe2641,0xbef8f360,0xb678a52d,0xebcfcebd,0x478c2642,0x29323961,0x246c2937,
0xbe0aefdc,0xb635a7a3,0xeb54cc18,0x44052e3b,0x2afa3d39,0x24213672,0xbe7ff47a,0xb8e8aaff,
0xefc9c4f5,0x42222c80,0x2cf737a3,0x25e637d5,0xbfe0f323,0xb986acf7,0xf58ebfd3,0x43132a1f,
0x318f3160,0x25b43905,0xc13af4bb,0xb96db806,0xfb2bc72a,0x40733027,0x332b31a7,0x21163869,
0xbccaef68,0xb0ceba58,0xfb08c9fc,0x3b5f3351,0x37252f94,0x24c337bc,0xc488ea53,0xb29bb9df,
0xfde3c804,0x351d2f59,0x34092c87,0x20b733fc,0xc958e3e9,0xb0ecb4d5,0x005fc67d,0x31773041,
0x34e53217,0x1bc53c26,0xca1fe8d2,0xaeb9b752,0x039cc725,0x2eda2cca,0x34cb31bd,0x16863f38,
0xccf0eb9b,0xafc4b86b,0x09c3c998,0x308f2817,0x39702b86,0x15c03a4f,0xcf67eb74,0xb0b7ba41,
0x0b77d177,0x2ee427bf,0x3c5a29f8,0x11a83698,0xcc4eea26,0xa9d2b617,0x069cd3d0,0x282c2750,
0x3df02da4,0x102735ca,0xcdf7e936,0xaaa4b3ef,0x0796d727,0x2501273a,0x3dbe2cdd,0x0eca30c4,
0xd19ee940,0xaf4bae4a,0x0aebd5fe,0x23902375,0x3e452f5e,0x0c802fb6,0xd023ebef,0xafc4acfc,
0x0b85d7da,0x230021ba,0x403b3589,0x0a203238,0xcc66f19e,0xaf99adbc,0x0cbcda2e,0x23861d82,
0x43183703,0x0e9c3014,0xcf23f552,0xb4e5b113,0x10cae0a7,0x279e1c60,0x45343882,0x117b2b1c,
0xcdcdf476,0xb512b023,0x0e0be52d,0x272f1b0d,0x43bd3df6,0x12612a55,0xca98f3d9,0xb355acf8,
0x0895e60c,0x2389195e,0x3d7c3f3d,0x11022813,0xc72fef6d,0xb61ba7df,0x08c7e53b,0x2695141f,
0x3c2f3fd6,0x1348294e,0xc87df02a,0xbc11a6f0,0x0982e6a8,0x2ab012c7,0x3aef40e6,0x12e12b70,
0xc625f492,0xbef3ace2,0x066aeafe,0x2d1811f1,0x38523f3f,0x10c429cc,0xc2c6f2fb,0xc0bbadc8,
0x03f2ecaf,0x30ba1282,0x3a453d9f,0x14cd2813,0xc203f007,0xc281ab98,0xff3deac9,0x30921344,
0x37c53b86,0x13a0251a,0xbedbeb76,0xc4adaad2,0xfcffeaea,0x2f4d1668,0x35ba3df5,0x14c22966,
0xbeaceca3,0xc988ae35,0xfd6eea26,0x31741940,0x35d23f58,0x150a2bdc,0xbbddea3b,0xcbcdae55,
0xfecee626,0x33091726,0x34ce3b07,0x13c82af0,0xb915e7ff,0xcb1bb077,0xfc8be3c8,0x31fc164b,
0x33133826,0x12af2ab9,0xb704e7ca,0xc9beb5c8,0xfb1ce4bb,0x30e017a4,0x321c35db,0x129f29e1,
0xb927e2f6,0xcc07b823,0xfc4be57a,0x31bb1a44,0x323834e8,0x12b828ae,0xbad8ddfd,0xcdaeb8cc,
0xfcf6e4e4,0x31331bf6,0x340c35e1,0x143c2e3b,0xbf54e06f,0xcf66bd70,0xfe83e540,0x30ce1f6f,
0x32ca37ac,0x0f282fd5,0xbddfdc58,0xcfadbd5b,0x0019e466,0x32501fdb,0x33c83549,0x0cd42fd1,
0xbdb8da84,0xcfa3bca7,0x0222e187,0x31761d8c,0x36b133a5,0x0c043278,0xbf8bdc52,0xcfadc129,
0x0244e4cc,0x31501fbf,0x380e32d1,0x087c3187,0xbf95dbf7,0xce97c2d9,0x032be637,0x30f121d7,
0x3b87338c,0x06982deb,0xc139d7b2,0xcf66c2bc,0x0444e66a,0x2e542246,0x3c4b324e,0x06122c63,
0xc49cd734,0xced0c304,0x0342e3e8,0x2a542181,0x3abb34c4,0x01c92cb1,0xc4e1d79a,0xcd2cc28e,
0x0540e26e,0x29632221,0x3ad736d3,0xffe42d0e,0xc4fdd826,0xcd87c341,0x08d6e2a3,0x2b981e58,
0x3e103674,0xff472b8b,0xc85dda71,0xcd9cc571,0x0844e3f0,0x28b31aab,0x3da4349c,0xfd0a2788,
0xc6a2da3d,0xc9ccc598,0x06d0e7ff,0x26c01af9,0x3d263725,0xfbf4253c,0xca82da59,0xca21c425,
0x05dbe9f4,0x26ed19cf,0x3e533902,0xfd9c23e7,0xcd26daff,0xcdd5c21d,0x0749ea67,0x27b51840,
0x3cf13ab5,0xfa2b2248,0xcd1fdbe8,0xce67c186,0x0838ebf6,0x281e19a7,0x3aa13c09,0xf8172221,
0xca11de4e,0xcdd0c1c7,0x04e0eace,0x29db16ff,0x3a593bff,0xf8b41eaf,0xcac8df61,0xd0a2c125,
0x0626eb4b,0x2c17154a,0x3c8c3c5f,0xfb4d1d00,0xcaa7e0fe,0xd150c1f3,0x0507ed74,0x2cef1780,
0x38de3e22,0xfa991b45,0xc94be22b,0xd1b8c353,0x03daf051,0x2c371831,0x382b3f0f,0xfc2319f2,
0xc97fe19b,0xd339c1b9,0x01e3edfb,0x2c6414c4,0x35bb3e1e,0xfc29168b,0xc7f7de4f,0xd51bbf72,
0x021ded13,0x2d521506,0x33083ec7,0xfc6617b5,0xc721dfcc,0xd734c3ef,0x0225ee9d,0x306b16e8,
0x30893fb8,0xfd19195b,0xc71ee26a,0xd966c7c1,0x028aef36,0x348517d9,0x30983d66,0xff0c16b7,
0xc70ddf53,0xd8ebc72f,0x00c2eda4,0x34e91704,0x2f273b81,0xff8116d0,0xc6cbddbc,0xd86ac802,
0xfce2ee0c,0x3243191c,0x2bbf3b7c,0xfda81800,0xc6dedca3,0xd98dc91f,0xfe19ee6b,0x34231bcd,
0x2a253a4e,0xfcd617c2,0xc92ddae3,0xdd2cc966,0xfff3ec64,0x34971abf,0x2bfe3801,0xfc4c1906,
0xcab4db80,0xde7acbce,0x0143ec1d,0x34f01d5f,0x2b11372a,0xfb1f1a7f,0xc970dda9,0xdcb1cf49,
0x0071eb9a,0x3570201e,0x2b7c3617,0xfa63191f,0xc7f5dc03,0xdb9ece94,0x00dcea41,0x351d1efe,
0x2d3e332d,0xfb641617,0xcb52d9dd,0xdd0ed0d0,0x0101e9c4,0x337420fe,0x2b9e3402,0xfabb1737,
0xcb65d9af,0xda47d0e3,0x0064e954,0x30c022d0,0x28ca3466,0xf81217b2,0xcc0cd8dc,0xdb2ad107,
0x0389e810,0x31ec2248,0x29f23419,0xf6bc16b6,0xced1d7ea,0xdbe2d1bf,0x0755e6ec,0x32b821a8,
0x2abf332c,0xf58e16f4,0xceeed944,0xd897d36c,0x0718e821,0x3078220c,0x2a6631e3,0xf3f81786,
0xcd4dd9bf,0xd681d4db,0x0669ea62,0x30b12279,0x2b9e3160,0xf49d1440,0xd21dd8cb,0xd747d322,
0x0889ea9a,0x300c2283,0x2b80302f,0xf44e1212,0xd441d7c8,0xd73dd138,0x0835eb5a,0x2d3122d9,
0x28b4319d,0xf07e12d3,0xd434d9eb,0xd859d257,0x0928ed69,0x2c8c2200,0x27a731f6,0xef8d1253,
0xd58cdd08,0xd936d20f,0x0c95ecb6,0x2e392093,0x294930ca,0xef9c0ff3,0xd5a6dd1c,0xd8fed0dc,
0x0d0fedb5,0x2f442050,0x2a8f31c3,0xee450e84,0xd3fcdeab,0xd72fd2d7,0x0b87f099,0x2de32273,
0x283e3260,0xef410c9d,0xd470e0c8,0xd7a1d1a8,0x0bc9f221,0x2cf120f3,0x27fa31a9,0xf19e0971,
0xd654dded,0xd9edcebb,0x0c03f166,0x2d211fc6,0x259d31b2,0xf0bf0870,0xd4d3de99,0xd9b4cdd2,
0x0b2ef1c1,0x2bb91f80,0x21873322,0xef9d0961,0xd329e0b5,0xdaebcf63,0x0bfff39f,0x2d601ebe,
0x21f1324c,0xf1fe0a02,0xd54fe274,0xdd44d06a,0x0da9f360,0x31851e83,0x236631fe,0xf3f40951,
0xd529e2e8,0xdc8fd0a2,0x0d5af470,0x31a72070,0x21243070,0xf2e2099f,0xd25be292,0xdbd7d17a,
0x0a42f6bf,0x2fef215b,0x20393062,0xf3bf090b,0xd38ae17d,0xde0bcf94,0x0b7df6fb,0x304c2288,
0x20162e97,0xf56e07a2,0xd542e09f,0xe146ced2,0x0cc6f584,0x2fc322c6,0x1e582f13,0xf4560a46,
0xd419e324,0xe24dd0ec,0x0cb7f5ec,0x2fe023d9,0x1d4e3039,0xf3190a9e,0xd1e7e41e,0xe1f0d33a,
0x0e67f5c4,0x30d922d9,0x1da02cb5,0xf44007c5,0xd0f9e1b6,0xe0a1d1fc,0x0e31f48f,0x309721e5,
0x1d6429c3,0xf5a105d8,0xd15ae05c,0xe004d41e,0x0c4df641,0x2e7a2406,0x1b782b60,0xf5940790,
0xd1ade0bf,0xe026d428,0x0c7cf74a,0x2d5025a2,0x19432b40,0xf506070e,0xd244dd3c,0xe19fd0ba,
0x0e7af49e,0x2d45230f,0x1778284f,0xf38706a3,0xd28cdd73,0xe290d209,0x0f37f464,0x2d3822c2,
0x16a6281b,0xf31c0a0f,0xd1a3e129,0xe168d563,0x106bf791,0x2e862497,0x18cc275f,0xf3ae0a0f,
0xd1d8e091,0xe117d5e1,0x10b0f7a6,0x2eec2475,0x19f3245c,0xf47e0703,0xd398dd06,0xe144d486,
0x0ef2f710,0x2c7e2568,0x185822f6,0xf309066c,0xd2fddc6e,0xe037d40a,0x0e00f782,0x29022787,
0x15a823c2,0xf0e00849,0xd41ddd34,0xe321d496,0x1125f7a8,0x29662746,0x18312349,0xf2090940,
0xd60ade48,0xe604d4be,0x15c9f740,0x2aba2695,0x19c1225c,0xf2ec0a32,0xd597e1c5,0xe5c5d80a,
0x1663f9eb,0x295626de,0x19eb2327,0xf13d0991,0xd3c2e23d,0xe304da37,0x156bfb7b,0x27de264f,
0x1afa21a8,0xf26e0671,0xd5b4dffb,0xe344d91d,0x16adfb56,0x27e9269e,0x1bff2279,0xf45e0553,
0xd7ecddb0,0xe3f8d806,0x1735fccf,0x25da27cf,0x18cb24c8,0xf1bd069f,0xd76bde99,0xe456d7ec,
0x16defdd1,0x23f7270d,0x16232569,0xf028075e,0xd76bdf24,0xe4fcd687,0x19c3fc84,0x26cf2305,
0x176522c5,0xf00305e2,0xd7e5dfdb,0xe590d722,0x19e0fdc7,0x27d9211a,0x1858221b,0xee880527,
0xd5cde08b,0xe353d7f6,0x16c10174,0x25332241,0x16b0211f,0xef360321,0xd61be0b5,0xe30ed6e1,
0x151d0214,0x244a2216,0x17b220d3,0xf08a01a1,0xd81fdece,0xe703d477,0x15d30174,0x234921c0,
0x160620e2,0xefc301b7,0xd6f9df32,0xe818d408,0x15b400c5,0x222b21ff,0x134022ca,0xedba03ea,
0xd5ade234,0xeaccd6ee,0x1770023f,0x249b2199,0x14d22269,0xeffd03c3,0xd58ae38c,0xec50d880,
0x192d026e,0x26fd1f4d,0x16162010,0xf10c004e,0xd4d6e2d5,0xeae7d9d1,0x1681041d,0x24651f8f,
0x14a91fe4,0xf1d8ffa1,0xd38de177,0xe9d5da46,0x14370632,0x22cb215e,0x12872138,0xf2adff2c,
0xd594df16,0xed17d949,0x14820498,0x22c61fe1,0x10b420d1,0xf2f9ff4b,0xd6deddae,0xef9ad845,
0x1592032c,0x22df1e53,0x0f0920ee,0xf0e70252,0xd55fdfe9,0xefdcdbeb,0x15a303ee,0x242d1e96,
0x0e62201b,0xefc80470,0xd370e028,0xefbfdd9a,0x15670497,0x26801d44,0x0fc01bbb,0xf12b014f,
0xd3e4de74,0xefdcdd89,0x142d0544,0x25fe1d7d,0x10f41aa2,0xf1db0121,0xd663ddca,0xefe0df58,
0x11710778,0x23a0213e,0x10611c90,0xf0f102a0,0xd714dd1e,0xf1d3ded1,0x12350612,0x22b722df,
0x0f491c08,0xefc2025c,0xd790dc2c,0xf4f4ddaf,0x14cb02df,0x22df2117,0x0f881b06,0xeeae029e,
0xd7e2dd2b,0xf5bbe0d2,0x16400348,0x2218212d,0x109e1a8f,0xed61042e,0xd686df41,0xf424e508,
0x167104b5,0x21bd222b,0x11d719e8,0xee3d02f3,0xd728dd71,0xf400e5f0,0x170404cd,0x2182208a,
0x130918e5,0xeeea0054,0xd9a0daee,0xf33ce56c,0x15d30458,0x1e172016,0x10ff1952,0xed90003d,
0xda97daf3,0xf1aee5b0,0x1655057c,0x1c2620d3,0x0f551ad2,0xebab0147,0xdc64db34,0xf327e5a9,
0x1891055f,0x1d921eba,0x0fed1a91,0xeb78012b,0xddd0dbc2,0xf440e486,0x199a05c9,0x1e9c1c7b,
0x10121995,0xe9850046,0xdddbdd5b,0xf2c1e624,0x17d5079d,0x1dd51c47,0x108119b9,0xe7f5008a,
0xdd2bddae,0xf2d1e738,0x157108f5,0x1d9e1bc0,0x10f51857,0xe919fd5b,0xdea0dcf5,0xf368e488,
0x14a70849,0x1ce31b62,0x10e7187e,0xe930fc31,0xdf95dd02,0xf50de40b,0x142e08cd,0x1b561c7b,
0x0f151a2d,0xe81cfd7b,0xdf08df77,0xf6b3e48a,0x14a2082a,0x1b1f1ba3,0x0e4c1a08,0xe760fc8a,
0xde85e045,0xf805e524,0x15ce073a,0x1c8719d0,0x0f6618fb,0xe866fac1,0xddcfe0cb,0xf7a3e648,
0x160b07fc,0x1d221a05,0x0fbb198a,0xe92afa48,0xde06e245,0xf6a2e8ed,0x1455096a,0x1c271b21,
0x0f161a80,0xea9df9f0,0xde9be113,0xf79ee90f,0x13d20989,0x1c201a53,0x0e261aba,0xebacf809,
0xe0c4df4a,0xf8ebe804,0x1431088d,0x1c221a2d,0x0c131bdd,0xeaf0f9ae,0xe09fdff0,0xf8f1e873,
0x1428089f,0x1c9e1998,0x0a3d1c6f,0xe922faf5,0xe04ce11b,0xf9edea36,0x155c091e,0x1ef81874,
0x0a4a1a4b,0xe9d1fa0c,0xe102e1bc,0xf9c7ea5a,0x14880a02,0x201617a9,0x0b4817e7,0xea47f8fb,
0xe0dae15a,0xf87de9c8,0x12090b2d,0x1dae18fd,0x0a4616e6,0xe9bdf8be,0xe0d2e0c8,0xf955ea33,
0x0f460ab5,0x1d471a81,0x08d4175c,0xe9b3f7a9,0xe242e085,0xfc52e8ea,0x10cd0979,0x1d4c1a3d,
0x08ee174c,0xe9d0f810,0xe284e173,0xfdd5e970,0x111007d2,0x1ceb1a38,0x076f16ce,0xe8c2f875,
0xe037e345,0xfd12eb80,0x11090752,0x1db61a80,0x07741685,0xe878f783,0xdf68e2ea,0xfdcced9a,
0x11b107b6,0x1e2d1a30,0x094a1568,0xeb65f6a4,0xdfece1c4,0xfd39ee1f,0x11ec07b5,0x1da01b07,
0x097a159d,0xebc4f6bf,0xe155e0e8,0xfc90efde,0x10ce07a8,0x1c461c7e,0x073016ec,0xebe3f7aa,
0xe260e009,0xfcf7f017,0x11fb0776,0x1c8c1c8b,0x05ff16a7,0xec60f836,0xe53be026,0xfddcefd2,
0x133205dd,0x1d5d1b2a,0x056415d3,0xea71f8fe,0xe526e089,0xfd63f164,0x13ae06d8,0x1d791ac4,
0x058314da,0xe938fa6c,0xe54ae243,0xfbb5f2e2,0x136a078c,0x1e971bf6,0x06ba1388,0xe91df911,
0xe6b8e185,0xfc20f2ea,0x11de07ec,0x1dd41b39,0x0877123f,0xe908f804,0xe7b2e07d,0xfb1ff149,
0x11de0729,0x1bfa1d0d,0x07661227,0xe7fff827,0xe84fe138,0xfbb1f131,0x11600702,0x1a3d1de4,
0x070912aa,0xe7b6f896,0xe93ae2d5,0xfccef0da,0x139c05ef,0x19d21c9a,0x07211200,0xe6e1f716,
0xe969e357,0xfd62f16e,0x15070554,0x1a3f1c5b,0x076f11cb,0xe63cf673,0xe846e559,0xfb5bf2d0,
0x14f20619,0x19451c65,0x073e11d4,0xe678f470,0xe862e539,0xf968f326,0x140a05f4,0x17a71b41,
0x06ca1121,0xe79bf22f,0xe992e3da,0xf931f1c7,0x149d05ff,0x16b41a97,0x062f1283,0xe778f1fa,
0xeaf6e352,0xf9c7f212,0x157c06e0,0x16901a6b,0x04091450,0xe6f9f355,0xeb35e4d6,0xfa04f20d,
0x162d0830,0x177818aa,0x035d13c5,0xe695f2e2,0xebb3e631,0xf9fdf10f,0x162a0848,0x18f216b2,
0x03781280,0xe6aef19e,0xeba7e6e8,0xf957f103,0x14ee09c4,0x191d16cf,0x027311b8,0xe725f0e5,
0xeb56e7ee,0xf97af09d,0x13f30bc3,0x1948188c,0x026a11f4,0xe8a9f087,0xec6de89f,0xfbbbefe6,
0x13e40c3c,0x19a118c7,0x01d71230,0xea39f0c1,0xee22ea42,0xfd39efc3,0x141e0b16,0x19e4191c,
0x00b61211,0xe99ef166,0xec8feb64,0xfee8f0fc,0x13c10bd8,0x19fc198e,0xffd811de,0xea29f16d,
0xebadec86,0xff68f212,0x13f80c03,0x1a5418b1,0xffd61007,0xec13efd9,0xeb90ec88,0xfffdf242,
0x130a0b20,0x197a17ee,0xff360f04,0xed21efbe,0xea80ebd9,0xffb6f2e9,0x123b0bb6,0x18d51937,
0xfde70fcb,0xedd7f0a8,0xea31eb0c,0xffd4f328,0x128c0aaf,0x19581a0c,0xfcd80f31,0xeeaff127,
0xeae8ea1e,0x00c8f353,0x13960a1a,0x18fc1965,0xfb9f0d9f,0xef0cf232,0xeb61ea1c,0x0020f423,
0x138b0971,0x195c199c,0xfa710cdc,0xee0ef368,0xeabae9d0,0xff99f52d,0x12d009cd,0x18bd1974,
0xfa700ad3,0xed7df37a,0xea67e8d4,0xfee8f4bd,0x12730904,0x185718bd,0xfa92083b,0xeceef26e,
0xeaf8e72d,0xfec0f480,0x11b208d0,0x172b1998,0xfb0b0804,0xecc5f333,0xebb8e806,0xfe81f4dc,
0x11c5092c,0x15f51aee,0xfb320818,0xeca1f486,0xec8fe866,0xffb9f503,0x138e090e,0x15931b73,
0xfba50738,0xec49f486,0xed08e882,0x006df530,0x15cc08cf,0x14e61bb7,0xfb8305df,0xebb0f451,
0xec9ee8cc,0x0037f67b,0x15960949,0x13831b5a,0xfb9305cc,0xeb4bf3b6,0xed0ee99e,0xff54f778,
0x15e909bc,0x12911a98,0xfca305aa,0xec6bf326,0xeec4e9ca,0xff5af7b8,0x172b09c8,0x12571aca,
0xfd3c0625,0xed23f36f,0xef98e99c,0xff5ff7db,0x17e90b8d,0x11591ada,0xfc21069d,0xec94f3e3,
0xf08bea4c,0xff75f827,0x18210c20,0x107b19f2,0xfc4e0678,0xecfaf4dc,0xf15eeb6c,0xff4ef789,
0x191f0c51,0x107d18a3,0xfccf05a7,0xec99f523,0xf1e3eb69,0xff49f77e,0x18950ca9,0x103b17fb,
0xfc7004cb,0xec58f473,0xf1a2ec0f,0xfeb3f722,0x174e0d6f,0x0f26178d,0xfc290480,0xec49f3df,
0xf247ed5d,0xfe72f629,0x16cd0d1d,0x0e45169e,0xfd2a0484,0xec69f3b3,0xf295ed7f,0xfe7cf512,
0x168c0c73,0x0dd31632,0xfd820493,0xec65f36f,0xf215eea4,0xfecbf4ba,0x17210d73,0x0da5169f,
0xfd390557,0xec61f2c2,0xf19bef80,0xff88f4f5,0x17520ed1,0x0c9f1566,0xfd5c0557,0xed01f1d3,
0xf195efca,0xffebf489,0x17290e8d,0x0b8b13ec,0xfc88048a,0xee5ef12c,0xf0eaf024,0xffe1f3d9,
0x16eb0ec1,0x0b8a1398,0xfb550537,0xee7bf0bb,0xefbbf089,0x00a7f41a,0x16e21006,0x0bbe12ed,
0xfa72064d,0xef38f0ba,0xefadf080,0x0124f40f,0x16c31023,0x0cc9124c,0xf97f05f0,0xf001efe9,
0xf043f0a6,0x01cff484,0x162510cf,0x0d6f11b7,0xf8f405b9,0xf100f125,0xef7ff0a2,0x027ef495,
0x15b911d5,0x0e391217,0xf7dd0585,0xf129f111,0xf00bf11f,0x0354f4f3,0x1538125c,0x0e821244,
0xf7ab04b3,0xf1acf1b8,0xefd2f07b,0x052ff521,0x1463125c,0x0e5311e5,0xf7c50397,0xf2caf310,
0xef40f0b1,0x0626f577,0x132d11da,0x0ea5121d,0xf786034f,0xf2d6f3c6,0xeeabf16b,0x066ef650,
0x12811130,0x0ed712f0,0xf76902aa,0xf3b3f437,0xee61f16a,0x0735f6dc,0x12bd10fd,0x0e86133e,
0xf7ff013e,0xf45ef45e,0xee35f09d,0x0776f77e,0x120e0faa,0x0d6113d9,0xf6960007,0xf4d3f432,
0xee10f087,0x0713f82d,0x11b30ec8,0x0bca1375,0xf6e1ffad,0xf49df550,0xee0bef7c,0x06bef8fb,
0x11e50d7c,0x0b861375,0xf79aff86,0xf4cdf661,0xee98ee9c,0x0766fa63,0x12ce0d03,0x0b9413aa,
0xf837ff59,0xf52ef769,0xeee0ee2c,0x0739fb9d,0x13310d7d,0x0aa71387,0xf876fec3,0xf521f8da,
0xef20edde,0x0647fc5b,0x13080d1d,0x0b0213bc,0xf959ff19,0xf42ef8c8,0xefdeec5b,0x05cafc30,
0x13c60d07,0x0a5313ae,0xf9bbfdf2,0xf349f927,0xf08eeb73,0x05bdfc55,0x14980de2,0x096613db,
0xfa32fdc4,0xf24cf9e2,0xf220ec50,0x04b4fc9e,0x14e40d97,0x0877144e,0xfad1fd73,0xf160fa1e,
0xf2b7eca3,0x03ddfc14,0x157b0d66,0x078113b3,0xfbe7fcbd,0xf038f97f,0xf31dec3a,0x0435fbd2,
0x15b90d40,0x068a12e3,0xfc9cfcce,0xef4cf8d4,0xf32eece2,0x03b0fc06,0x15b60e0f,0x052e124e,
0xfd7bfd53,0xef06f890,0xf380ed9c,0x0391fb80,0x15e10ec5,0x04061187,0xfe1bfdd9,0xeec6f70a,
0xf46bedcf,0x0407fb55,0x162a0f15,0x03360fe4,0xfe59feed,0xef0af644,0xf4ddef01,0x03dffa98,
0x17051019,0x01d00f0a,0xfd7eff56,0xeee3f600,0xf4baeffd,0x03dbfa98,0x1718112b,0x01820d3f,
0xfd34ffef,0xeeb6f542,0xf488f059,0x03ccfa48,0x16d41160,0x02700ba6,0xfd6c003c,0xefd4f49e,
0xf4e2f118,0x045df9ed,0x15b912c0,0x02c10a8d,0xfd69013a,0xf013f467,0xf46bf161,0x04eff9c7,
0x14a11450,0x03060a5e,0xfc73020c,0xf087f43b,0xf455f199,0x0652f8f6,0x13cc14a2,0x03f609cb,
0xfc5502c1,0xf10ef436,0xf403f201,0x078cf835,0x13221467,0x0488088e,0xfc5c030f,0xf166f4b4,
0xf2e7f257,0x0852f853,0x120e14bd,0x05ad0895,0xfcdf03e8,0xf194f503,0xf1e6f2f3,0x08fbf8e8,
0x11e1155a,0x0634093c,0xfc61034e,0xf2fff4d6,0xf1c0f31a,0x09c3f906,0x10e91445,0x07380929,
0xfbe1034e,0xf38ef40f,0xf141f28b,0x0a88f989,0x0f7b1426,0x06ff0988,0xfb1a0356,0xf434f4b0,
0xf08ff234,0x0b6bfa2e,0x0ee413da,0x074c0a23,0xfa580393,0xf493f532,0xefd9f147,0x0cc2fb0c,
0x0ee0133d,0x07a209c3,0xf94c0296,0xf4c8f53b,0xeffff0ab,0x0da1fc35,0x0e7f1268,0x08000979,
0xf8d601e7,0xf4d1f5b9,0xf002f050,0x0d70fdf9,0x0db21233,0x0799097d,0xf8840108,0xf4aaf6b5,
0xefeaef2c,0x0d92ff1e,0x0d0c119a,0x07b809a1,0xf85cffc2,0xf4e6f6bb,0xf0adee2b,0x0da8ff75,
0x0d19111c,0x07ae0a68,0xf861fe9e,0xf4bff7a8,0xf173ed67,0x0dae0058,0x0c631070,0x072b0b5b,
0xf80cfe4a,0xf402f88e,0xf1d0ed39,0x0d7c00d9,0x0c3f0f55,0x06980b99,0xf827fd31,0xf331f928,
0xf258ece3,0x0d99010d,0x0cf10e71,0x067d0bc5,0xf889fbdf,0xf25ff8f2,0xf2bcec9c,0x0d79023c,
0x0c910de0,0x05a10bc6,0xf9e9fbcd,0xf19cf933,0xf368ecd8,0x0cb00357,0x0c990d8f,0x04a70c6a,
0xfb3afc11,0xf13df9b4,0xf41eec60,0x0c17039c,0x0d7a0d03,0x03420c66,0xfc33fb8b,0xf0ebf92c,
0xf564ebce,0x0b5f0384,0x0e400c04,0x02970c82,0xfcd4fc47,0xf01cf963,0xf643ec4b,0x0a4b03be,
0x0f460c4c,0x01950c9f,0xfd02fcd9,0xef4bf9b3,0xf6fcecc1,0x0a3803f4,0x10b20cdc,0x01240bbf,
0xfdcffd17,0xeea5f915,0xf817ed0b,0x09f40485,0x119f0dc5,0x00e10a98,0xfe6cfcf3,0xeea1f844,
0xf922edd7,0x08fc0480,0x11710ec7,0x00c00a66,0xfe96fe4f,0xed76f738,0xfa0fee96,0x08a9047b,
0x11390fee,0x001209bd,0xfea2ff29,0xecc2f5fb,0xfb95eee8,0x0932038d,0x114f1069,0xfff30873,
0xff15ffaf,0xec9ff5a4,0xfc1befcc,0x09db02b7,0x11ca1134,0xfff907f2,0xfeb8007f,0xec01f546,
0xfbcbf144,0x0a08028a,0x114c1205,0x000a06ea,0xfe5700ba,0xebd3f42a,0xfb54f271,0x0a700207,
0x107f12da,0xffe7053d,0xfe45003c,0xecaff28d,0xfb59f313,0x0ac5018f,0x0ee812ad,0xffff048e,
0xfdcf00f8,0xeda1f15e,0xfadcf3f2,0x0b4500f6,0x0d9b1319,0xfffd0457,0xfc92024d,0xee7bf129,
0xfa92f4fc,0x0c4c00d9,0x0c9f12d1,0x00c40365,0xfbc1032d,0xef25f063,0xfa6af55b,0x0d7700fe,
0x0c481233,0x01ce0282,0xfb120345,0xf01cf054,0xf99df5ae,0x0d830152,0x0b721203,0x026d02a7,
0xf97e02d5,0xf0c0f05e,0xf8e6f5d9,0x0dd80295,0x093f11a8,0x033901b5,0xf8ef02cc,0xf1aff034,
0xf8a1f537,0x0e9202d0,0x08491176,0x041f01f0,0xf80f0217,0xf2a5f042,0xf84ff410,0x0fbf02ee,
0x079d112f,0x047a0266,0xf71201cf,0xf30ff19b,0xf814f40f,0x104203b9,0x06de1076,0x05a703ae,
0xf62c01ab,0xf33ef25d,0xf856f449,0x10b9047f,0x068f0f2b,0x07210462,0xf6a700ec,0xf3b3f2cf,
0xf883f3e1,0x115a0572,0x06bb0ea6,0x076f0537,0xf6960010,0xf31ff33b,0xf836f337,0x111d06e7,
0x061c0de0,0x06c4066f,0xf60afe9d,0xf365f3c3,0xf889f2f1,0x10a207de,0x05a20c95,0x06ad074c,
0xf676fdf6,0xf3a4f419,0xf968f1e4,0x10d608bc,0x05b60b5a,0x060d07bf,0xf6fafd69,0xf3a4f4d1,
0xfa46f188,0x105a0962,0x061b0a06,0x059208c7,0xf705fd9a,0xf2d9f61a,0xfad2f182,0x0fe10aae,
0x07200966,0x05030958,0xf733fcdf,0xf2b2f68d,0xfc30f1af,0x0fa70bc3,0x080a08be,0x04440861,
0xf83ffb9d,0xf298f6ee,0xfd49f1d5,0x0ddd0c57,0x08430830,0x033a0865,0xf911fb5f,0xf1fbf742,
0xfe55f1ce,0x0c0e0cbf,0x0861085c,0x023d08e0,0xf94ffb44,0xf126f6ae,0x0051f1ed,0x0b370cb1,
0x088207c0,0x012f0834,0xf9d8fb27,0xf060f644,0x024df20d,0x0ab50c1b,0x08f1075b,0x00ac0781,
0xfa9efc14,0xef45f6a8,0x0297f31c,0x09a40b6c,0x09ac07c6,0x001f0754,0xfb18fc7a,0xee61f699,
0x029ef45d,0x08cf0abf,0x0a72086e,0x003d06f1,0xfb3afc06,0xedf1f47b,0x03e0f55a,0x08830a16,
0x0a76089b,0xffac05e9,0xfc35fc95,0xee7af422,0x041af698,0x07c00940,0x0a36094e,0xff4e0603,
0xfc47fde8,0xee5cf33e,0x0422f781,0x075c0877,0x09d20971,0xfec00519,0xfbf4fe8e,0xeeb3f232,
0x0410f834,0x073506de,0x0aa00998,0xfef30463,0xfb69ff56,0xeee9f111,0x0455f946,0x0763068b,
0x0a6809ef,0xff53038d,0xfaab002a,0xef1ef091,0x0410faad,0x0725069c,0x09c30aa0,0xffc402e8,
0xf9f2008b,0xf079f029,0x0384fbbf,0x074e05e4,0x09530b3c,0x00a001f0,0xf9bb00c9,0xf1c4ef92,
0x03b2fbe6,0x08140554,0x08b10bfa,0x013401a9,0xf85b010b,0xf29eef3b,0x03affceb,0x08bd0538,
0x07bb0ca9,0x012f0195,0xf6d800d1,0xf3d9efb7,0x030ffdb0,0x09430489,0x06c30c48,0x024b013c,
0xf65100d7,0xf423ef80,0x0294fd9d,0x09cc03fd,0x062f0b84,0x03cb015b,0xf5520068,0xf461ef14,
0x018afdd1,0x0a8a046f,0x05810bd8,0x03fd01d3,0xf456ff7a,0xf530ef63,0x0121fe2d,0x0b110568,
0x03cd0b3e,0x046301d9,0xf45cff1e,0xf6d7effd,0x0075fe07,0x0b2404ae,0x03740a19,0x05500336,
0xf3c6fea4,0xf7ecf062,0x000cfd8e,0x0b5a04e4,0x036f0928,0x062104cc,0xf335fec9,0xf7f5f126,
0xff76fd22,0x0c1f0604,0x035d08a3,0x061c0553,0xf2b2fe26,0xf88af230,0xff12fcbe,0x0bb00667,
0x03a60760,0x062d05bd,0xf281fcdf,0xf920f2e2,0xfee6fbef,0x0b3d0718,0x03f10691,0x064d0672,
0xf29cfbb5,0xf94ef3a1,0xff15fb22,0x0a4d0800,0x03dd05dd,0x062f07d0,0xf24cfb15,0xf95af470,
0xffe5fa9d,0x0a0508bd,0x043a054b,0x05a6089a,0xf283fa43,0xf905f537,0x0165fa1f,0x09b2090b,
0x05190468,0x051508fa,0xf316f949,0xf8c6f692,0x0199fa04,0x08ab0940,0x05e0041d,0x04d709f6,
0xf37af8d9,0xf7b4f71e,0x020af9fd,0x080b0987,0x06e70467,0x03cf0a46,0xf432f7c5,0xf6d1f6d3,
0x02a2f9da,0x07780976,0x07e30483,0x02820a36,0xf4ddf6ba,0xf654f629,0x03c8fa21,0x062a0923,
0x083603fb,0x01600a6d,0xf5cef708,0xf578f61b,0x0416fa26,0x055a08bb,0x0899042e,0x005f0a68,
0xf664f7d5,0xf4c7f5bb,0x045efa6d,0x04b707b8,0x0a4e0465,0xffaf0a25,0xf6e6f80e,0xf45ff523,
0x050cfb02,0x03fd0746,0x0b6e0492,0xff4b09b9,0xf6e6f866,0xf46cf4c2,0x0554fc4c,0x03280708,
0x0be30542,0xfef508f3,0xf727f922,0xf461f441,0x0562fcd3,0x02700642,0x0c3c0658,0xfef70855,
0xf7a8fa04,0xf4c8f384,0x059efd6b,0x0235050a,0x0c830770,0xfe9e0759,0xf7eefa95,0xf568f379,
0x05c0fe27,0x022903ee,0x0c710874,0xfe7906b7,0xf720fb13,0xf5b3f33c,0x05c0ff67,0x020902ec,
0x0bf608ea,0xff1505fe,0xf710fbfe,0xf5f6f310,0x05550025,0x02110182,0x0c1f0943,0xfff805a1,
0xf6b5fbda,0xf635f25c,0x047e0088,0x02fa011c,0x0b680a57,0x0008051b,0xf5cefbb1,0xf6baf1b2,
0x04060182,0x0416010c,0x0aaf0b5e,0xffd904de,0xf54dfb85,0xf86ff1b3,0x035b0257,0x04ee0054,
0x0a240b7f,0x006404c6,0xf525fbf7,0xf98bf1bd,0x021d0297,0x0551ff8b,0x0a080b51,0x0116050f,
0xf45efbdc,0xf9f2f15f,0x00d90249,0x0604ffb7,0x09620b50,0x01080510,0xf34dfbc0,0xfb08f1e4,
0x00050236,0x0690fffa,0x08f80aee,0x014004cc,0xf30afb65,0xfc3af290,0xff5501cb,0x06ef0023,
0x09100a98,0x020a0540,0xf298fb2b,0xfd4df35c,0xfe910140,0x07bd0103,0x09240b0c,0x024105bf,
0xf1a5fa59,0xfe2df42f,0xfe8700fa,0x07da01b8,0x082f0a8c,0x029105cd,0xf13ff9f3,0xfe87f4fc,
0xfe6a0006,0x083e01f6,0x08510a64,0x029a062b,0xf12af8bc,0xfef4f654,0xfe62ff64,0x086c0263,
0x07de09da,0x02960673,0xf1aaf82c,0xfea4f7dd,0xfdc3fe7f,0x08480286,0x07fb09a0,0x022c0713,
0xf199f6aa,0xfe62f887,0xfd79fdb2,0x081302ad,0x08360917,0x017b07b8,0xf1e9f51b,0xfe03f903,
0xfe15fd1d,0x088303b0,0x081108b2,0x007607f4,0xf2a6f462,0xfde3f9bd,0xfe6bfcf6,0x082d0433,
0x08640804,0xff970897,0xf37df434,0xfd6efa7f,0xfe67fc72,0x0813044f,0x09620800,0xfea708f6,
0xf486f414,0xfce7fab7,0xfe80fbcd,0x07de04a2,0x0a5207bb,0xfda808be,0xf4eef3d0,0xfc58fab0,
0xff1cfbd7,0x06ba04c9,0x0add072e,0xfcbc087a,0xf5b5f3fc,0xfbcbfae6,0xff12fb7e,0x05c404a2,
0x0baa078f,0xfc0c080e,0xf677f43c,0xfb41fad4,0xffaafb11,0x059404e1,0x0c560836,0xfb220730,
0xf6f4f417,0xfb18fad7,0x004cfb43,0x04fc0498,0x0cb608fa,0xf9fe067b,0xf76cf470,0xfb0bfb41,
0x00eafbac,0x04b803df,0x0cf709c6,0xf97a058a,0xf810f504,0xfa94fb57,0x0174fc27,0x045b033b,
0x0d0a0a4f,0xf9a504d0,0xf8c9f5c8,0xf9e1faff,0x0195fc7e,0x04cc028a,0x0d330b55,0xf99d0432,
0xf90df617,0xf99bfa7b,0x01fbfd7f,0x0555027e,0x0cdc0c7b,0xf9000328,0xf986f670,0xf9cefa26,
0x020efe81,0x05d8021d,0x0c6f0d1e,0xf8650247,0xf9d7f6ae,0xfa6af9ae,0x0190ff07,0x06520125,
0x0c520dbd,0xf8b40203,0xf9cdf7d3,0xfa8af90f,0x010eff7d,0x07690111,0x0c460e92,0xf8ab018c,
0xf969f82e,0xfb02f88a,0x00730010,0x080900f1,0x0b7f0eb9,0xf8cd00a1,0xf92ef8ce,0xfb8ef82c,
0xffa8fff5,0x08a000ba,0x0b3b0eee,0xf9270000,0xf8d4f92d,0xfc23f829,0xfe8cff7b,0x094a00b6,
0x0ac40f62,0xf9caffbc,0xf7c7f969,0xfcb9f7dd,0xfe09ff7d,0x09ac00d6,0x09d50f85,0xfa0bff2d,
0xf713f93d,0xfd12f817,0xfd95feef,0x0a4e0126,0x08880f00,0xfaadfe96,0xf6d7f953,0xfd93f876,
0xfd02fe30,0x0b1c0157,0x079b0ef7,0xfb05fe57,0xf67bf8f9,0xfdd5f95c,0xfc25fda2,0x0b7d015e,
0x06d90eb9,0xfb7efe7c,0xf65ef87a,0xfde8f9f7,0xfbc2fd0b,0x0c5f0202,0x06580e6a,0xfbfefef7,
0xf691f812,0xfdfbfa9a,0xfbc7fc7e,0x0d0502e4,0x05c40ddf,0xfc43ffb4,0xf676f756,0xfe52fb2f,
0xfbfffc47,0x0dae03db,0x052c0d48,0xfc050015,0xf738f744,0xfe18fbe1,0xfbc2fb78,0x0dfa04c8,
0x05240c59,0xfbeb00f5,0xf764f6d1,0xfdeffc35,0xfbfafacc,0x0e4405b4,0x05660bc6,0xfb3c0109,
0xf7d4f668,0xfd9dfcca,0xfc1bfa40,0x0df60671,0x05810ada,0xfacf0115,0xf87af685,0xfcfffd1e,
0xfc55f986,0x0d44073f,0x05ce0a2e,0xfaec015b,0xf8fef6c7,0xfc2cfd0e,0xfcebf8e1,0x0c8207dc,
0x064709d5,0xfa4b0174,0xf99bf6bf,0xfba5fd47,0xfdb3f81c,0x0c61087e,0x068909fb,0xf9ae00fe,
0xfa19f6b7,0xfb76fdcb,0xfea1f82e,0x0b73087e,0x06be09f8,0xf95700d4,0xfaa6f6f2,0xfa92fe1e,
0xff42f7fa,0x0b360849,0x070709e4,0xf8fb003c,0xfb57f717,0xf991fe11,0xffdef830,0x0aef084a,
0x06fe0a16,0xf8b7ffb5,0xfc58f74f,0xf8befddf,0x0093f883,0x0aa00853,0x06c00a59,0xf846ff3b,
0xfd1ef7c7,0xf859fd7b,0x0143f93c,0x0a93082c,0x06630a9d,0xf7b4feab,0xfdbaf834,0xf818fcdf,
0x01d5f9c4,0x0a9407eb,0x06230aa3,0xf733fe57,0xfe20f8f8,0xf7f6fc5f,0x021cfa60,0x0add0796,
0x06520ad0,0xf760fdd7,0xfe85fa23,0xf7a4fbb8,0x0246fb0b,0x0b1407e4,0x062a0adf,0xf787fd1e,
0xfe8dfafd,0xf772fb00,0x0211fb5e,0x0b5f07f6,0x05c00b0d,0xf799fbf9,0xfe8dfbae,0xf795fa4e,
0x01a1fb6f,0x0b6407cc,0x05770b7d,0xf7cdfb6d,0xfe40fc25,0xf7c5f9b1,0x01a7fb74,0x0b7307b6,
0x05110bd6,0xf831fb27,0xfd69fcac,0xf7a3f8cb,0x01f0fb74,0x0bca07d3,0x04230bcd,0xf888fa5f,
0xfcfcfd1f,0xf809f8e3,0x01bcfb88,0x0c0b0765,0x036f0b99,0xf9dffa1a,0xfcbefddf,0xf823f8d6,
0x01a8fbeb,0x0c520764,0x02c70bc6,0xfa40f9d5,0xfc2ffdca,0xf849f8c7,0x0154fc19,0x0c74074d,
0x020f0b70,0xfb16f9ff,0xfbcbfd86,0xf876f88a,0x0142fc1b,0x0d0007a5,0x00ca0b1f,0xfba5fa02,
0xfb8ffdad,0xf875f84a,0x012bfc16,0x0d9b0805,0xffe90a84,0xfbf1fa39,0xfb27fd82,0xf8e5f84b,
0x0171fc75,0x0e1a0883,0xff6909d4,0xfc5afa95,0xfb20fdad,0xf8fbf88a,0x0142fc43,0x0e9b0940,
0xff270922,0xfcddfb22,0xfae3fd7a,0xf9a2f8c1,0x014afc60,0x0ed909e4,0xff030883,0xfceefb6e,
0xfab5fd19,0xfa33f8f6,0x0157fc74,0x0e7b0a92,0xfef207e7,0xfd23fbe4,0xfabafd2f,0xfa38f94e,
0x01c1fc1d,0x0e190b60,0xfed00729,0xfd95fc7c,0xfa7bfd1c,0xfa20f959,0x0227fb5e,0x0df00bd7,
0xfec6066f,0xfd92fcb4,0xfa43fcbe,0xfa1cf9c3,0x02dafb73,0x0d990c74,0xfed805ef,0xfdb7fd04,
0xfa33fc86,0xf9d6fa37,0x0389fb6a,0x0cc20c9b,0xff140542,0xfdf3fd90,0xfa5efc14,0xf957fa78,
0x0418fb4f,0x0c110cc6,0xff4904c4,0xfe3ffe00,0xfaf8fbf9,0xf8e6fa93,0x04a5fb49,0x0bb20d08,
0xff200491,0xfdf6fe3d,0xfb85fbe8,0xf86afa8a,0x0550fb54,0x0b1b0cd0,0xff630462,0xfd3cfe8e,
0xfbcffbbc,0xf810fa84,0x05c2fb90,0x0a940c8a,0xff8e03cf,0xfcf1fe91,0xfbe1fbbd,0xf7c1fa0b,
0x068cfc53,0x09ef0c5e,0xffb60336,0xfc94fea1,0xfc0cfbef,0xf730f986,0x06a3fc9c,0x09710bf4,
0x002f0315,0xfc4dfe7e,0xfbf2fc08,0xf6d3f8c9,0x06fbfd10,0x08a00c32,0x005102ed,0xfc3bfe4d,
0xfc35fc56,0xf742f867,0x0761fdb0,0x07c50ba4,0x008002d3,0xfc50fe2e,0xfc17fcd5,0xf73af7cc,
0x0794fdf7,0x07470b37,0x00a80330,0xfc21fdca,0xfbc6fd5d,0xf6f0f735,0x07e9fe26,0x072b0afd,
0x009c0373,0xfc45fd5e,0xfb21fd7e,0xf721f6c9,0x085cff14,0x06cb0a63,0x00560344,0xfc91fc99,
0xfb35fdf1,0xf748f6c7,0x083aff88,0x067f09ab,0x0020039a,0xfd84fcd3,0xfae5fe71,0xf757f646,
0x083b002a,0x066f0918,0x001503f7,0xfdf9fd0d,0xfa76fe42,0xf7d3f5fa,0x080100bb,0x066f086f,
0xffbb0415,0xfe61fd40,0xf9f7fe28,0xf888f5c8,0x07d00168,0x066307ff,0xff1903a0,0xff01fd83,
0xf9eafeb3,0xf8def580,0x07c101e3,0x06d90806,0xfed50399,0xff4afda8,0xf9a0fed0,0xf974f5a1,
0x07160227,0x072007bd,0xfe960340,0xffaffdd6,0xf944fece,0xfa03f58c,0x06bc0260,0x072b07e4,
0xfea402dd,0x002afe48,0xf8a4fe8c,0xfad9f58e,0x069102aa,0x0726082d,0xfe5a028a,0x008afe7e,
0xf843fe81,0xfb63f5e8,0x0630025a,0x0708084a,0xfe94024d,0x011bff4c,0xf7edfe5a,0xfc01f642,
0x06090213,0x06db0857,0xfeef0214,0x01ad0010,0xf77dfe05,0xfc6df6ad,0x063801c4,0x06bc0887,
0xff1501e2,0x01a60086,0xf71bfd80,0xfc90f749,0x066801f1,0x062f089b,0xfef30145,0x01ca00cc,
0xf720fcff,0xfc94f7a0,0x064501a2,0x05bb0849,0xff420102,0x01f00156,0xf733fc90,0xfc3af7fd,
0x0634014b,0x057c085b,0xff6e00e7,0x01ad0196,0xf749fbdc,0xfbfaf826,0x065a012b,0x05110830,
0xff6e00a2,0x016a0204,0xf7c6fb95,0xfc34f8b2,0x061e0130,0x04a107a9,0xffcc0067,0x01040281,
0xf7f5fb5b,0xfc4df8d9,0x061f0148,0x042c0730,0x007f0031,0x00be02e9,0xf80ffb0d,0xfc57f8ce,
0x065f019f,0x03a6071b,0x00fb0005,0x0033032d,0xf817fad1,0xfc43f8f8,0x062a01bb,0x034406f4,
0x0171ffee,0xff9a02f1,0xf861fa9c,0xfc8ff908,0x064101fb,0x029d06a3,0x01d3fff3,0xff7002c2,
0xf8b0fae1,0xfc9cf8fb,0x062801e7,0x01eb0620,0x0274001c,0xff560325,0xf860fadc,0xfc77f8c9,
0x064701c5,0x019f05cd,0x02c2008d,0xff2c02eb,0xf856fb0c,0xfc60f8bd,0x064a01d7,0x01a40564,
0x03090108,0xfefc0288,0xf86ffb04,0xfca5f913,0x065f0235,0x016804c1,0x03760160,0xff170274,
0xf8bcfb2b,0xfc83f93a,0x05ad0250,0x01560430,0x03ec0243,0xff240296,0xf8aefb03,0xfca3f928,
0x05c202ac,0x015703cb,0x042202aa,0xff2002c7,0xf8a2facf,0xfd0ef8f7,0x05cc0320,0x0150033a,
0x040202d8,0xfedd029b,0xf8d5fadd,0xfd7bf937,0x05370337,0x0165028c,0x0431030e,0xff3d02fe,
0xf8bffb41,0xfd8df915,0x04b50356,0x01b0023f,0x045b0349,0xff2a0306,0xf885fb48,0xfe09f90d,
0x04460396,0x022101fd,0x047d0393,0xff0c02ad,0xf878fb34,0xfe72f935,0x03cc03b8,0x02440230,
0x048903b4,0xff21029f,0xf857fb32,0xff08f966,0x035d03d6,0x021f020a,0x046f03cc,0xff1f0283,
0xf839fb29,0xff4bf986,0x02c2031e,0x026101c1,0x048a0439,0xfef20270,0xf82cfaee,0xff8ff9f0,
0x028c02ad,0x02a501cf,0x04b50468,0xfefc029d,0xf7a3fa94,0x0002fa5d,0x025c02b7,0x02a0019f,
0x0484045c,0xff07027e,0xf784fa54,0x0029faee,0x020002a0,0x029f015b,0x04be0485,0xff8502e7,
0xf794fa2d,0xfffdfae0,0x0200025a,0x031b0190,0x04ef04ea,0xff560321,0xf7b9f9bd,0x0002fb41,
0x01980200,0x036c019a,0x04b10524,0xfeb602f5,0xf7dbf92c,0x0023fbc4,0x011b01ca,0x034a0151,
0x049d04dc,0xfe9c0328,0xf846f933,0x000cfc03,0x00d3014f,0x036c0121,0x050304b8,0xfe57036f,
0xf876f8f7,0xffb9fc27,0x004100c7,0x038e0139,0x053a04be,0xfdd2036c,0xf863f895,0xffbffc53,
0x000c00a1,0x03910173,0x055104b9,0xfd4e0323,0xf8c9f8b7,0xfff5fcdd,0xfff90055,0x038b0173,
0x05a004d1,0xfd0202e6,0xf936f875,0x0005fd06,0x00020019,0x036b019a,0x05f1050b,0xfcb202e4,
0xf95ef885,0xffe1fd44,0x0023ffe4,0x037501da,0x06210577,0xfc9202da,0xf98bf8ac,0xffccfd5c,
0x0081ffd9,0x037e01f5,0x06380594,0xfc40025c,0xfa17f8d9,0xff99fdad,0x00caffb1,0x03ec0233,
0x066e061c,0xfc200229,0xfac5f90d,0xff7dfe57,0x0093ff95,0x042d0207,0x06b506a8,0xfc160222,
0xfafdf933,0xff03fe38,0x0089ff7d,0x04620205,0x06bb0737,0xfb8a01a1,0xfb08f8ef,0xfeebfde9,
0x00a3ff9f,0x047101de,0x06550730,0xfb590139,0xfb64f900,0xfed8fdd4,0x0072ff9d,0x048401a3,
0x06230741,0xfb2e0101,0xfba8f974,0xfea5fdb3,0xfffbff73,0x04c6015c,0x061e077b,0xfafe00ca,
0xfb80f9a3,0xfe55fd43,0xffd9ff4f,0x05540195,0x060607bb,0xfab6001f,0xfba2f9a8,0xfea9fd35,
0xffd4ff83,0x05290195,0x05850751,0xfaecffcd,0xfb9dfa3e,0xfe91fd21,0xff5dff31,0x0555019d,
0x05400794,0xfafeff7f,0xfb8afa78,0xfe4ffce0,0xff45fed7,0x05a201e1,0x050307b8,0xfae8ff0d,
0xfb61fa58,0xfe75fcf3,0xff2dfe83,0x061a01f1,0x04ac07dc,0xfac4fe91,0xfb76fa4c,0xfeeffd9a,
0xff29feaf,0x063e020d,0x045007de,0xfae1fec6,0xfb5ffa53,0xff0ffddf,0xff63fee2,0x064d0244,
0x0407078a,0xfb63feb5,0xfbb1fa6d,0xfef2fdf3,0xff69fea4,0x06bc02a7,0x03fd0791,0xfb6ffedd,
0xfba7fa23,0xfef9fe05,0xff93fea4,0x06db0301,0x03ad076a,0xfb2bfecb,0xfbcffa17,0xfee9fe2b,
0xff9ffea5,0x06bb0325,0x03760721,0xfad9feb5,0xfc1ef9f3,0xfef5fe6d,0xffaafe6a,0x06ad032f,
0x036c06db,0xfad6fe94,0xfc57fa16,0xfeeafe7c,0xffa1fe59,0x06ad0330,0x038906f3,0xfad6fe97,
0xfc18fa19,0xfed8fe62,0xffb7fe7b,0x06c80351,0x036b0709,0xfac6fe7c,0xfc23fa1a,0xfed8fe61,
0xffbefe91,0x06b40345,0x036606ff,0xfac5fe94,0xfc2ff9fa,0xfef3fe72,0xffacfe6a,0x06990336,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_3_piano_kpianof502[2304] = {
0x00000000,0x00fd00d3,0x013c0124,0x015e014c,0x0171016d,0x01680169,0x01650168,0x0143015a,
0x011b012f,0x00d600f9,0x00b900c5,0x008f00a8,0x0064007a,0x0008002d,0xffc3ffe9,0xff9affa5,
0xffa6ffa3,0xffd1ffb9,0xfff9ffe7,0x00330019,0x0041002e,0x002c0047,0x001b0027,0x00310037,
0x003b0045,0x02cbff15,0x00330064,0xf738fe19,0xf762f2bb,0x14140aa0,0x00ca0d6d,0xfa600752,
0xff4ff607,0xe4c7eb5e,0x149607f2,0x1efd19f4,0x085111ca,0xe0bafb6c,0xf506d641,0x0bb7f02f,
0x29662112,0xdc5a0f1d,0xc394bf37,0x049ddf19,0x3fdd3685,0x194f423f,0xb15fe4e5,0xf58eccde,
0x2c850ad3,0x36fa382c,0xcf4605c8,0xca4aa2b2,0x158fea81,0x47203ac4,0xfa972fcb,0x93fdc8e0,
0xdd80ba56,0x4ca3226e,0x42e85d4c,0xd8a91d04,0xaf149669,0x02adc686,0x60e537cf,0x24194551,
0xafcede2b,0xd6bdc453,0x39d40756,0x431c5976,0xd73d26ab,0xb77fb103,0xfa92cbef,0x5a374168,
0x26e745ac,0xb438d2d4,0xd182b4a8,0x3dc6f8f6,0x3d574a6d,0xc86a17ae,0xbd58bbc6,0x0cc2dc50,
0x50f65084,0x06503dbc,0xa271b47a,0xcf1cac08,0x577c11d9,0x58825d26,0xc30b1199,0xaa1aa3e0,
0x135fca9e,0x4d344e00,0x05924d50,0xb817d113,0xdf31bfaa,0x4fea26b9,0x39fe44f2,0xb633e993,
0xb438a47b,0x34c6dff5,0x670c6203,0xfecc500b,0xa0acbb42,0xd442a5a6,0x4c812cd8,0x37a45e2b,
0xae1de961,0xb475a44a,0x47adeb48,0x67aa5ba1,0xdfb13104,0x95c4a18b,0xe3c1a454,0x5e7141bc,
0x46016f66,0xb9a3f651,0x9c29a834,0x1f33d7d6,0x5918454f,0xe7fb300f,0xb05bb82c,0x002daebd,
0x60923bf6,0x3b6d67c9,0xac78ebf4,0x97d99f56,0x233fe011,0x6f67572a,0x02e44bd9,0xa4e0ca43,
0xdc069af0,0x42bc1270,0x40ba5c7e,0xd0d7f946,0xa235a0ff,0x2274e637,0x6bd2596a,0xf82449f1,
0x964bcc08,0xd0b89d1e,0x54e6139c,0x55506fb6,0xefab1891,0xa571a81e,0x08bed8b5,0x61544173,
0x00d439ee,0x9af0da3b,0xdbc0a5d2,0x4e15164a,0x39cc71ec,0xd8280963,0xa10395d8,0x0c5acc00,
0x754446f1,0x1c423f06,0xa73ae745,0xd8a9b2b3,0x47080dde,0x2ac066f6,0xd2ae0a19,0xafce9e24,
0x0d3edd90,0x66915238,0x13833515,0x9cedcf7c,0xd84aa624,0x5388ff88,0x2db95ded,0xcd081328,
0xaf84a499,0x0a59e387,0x596f5ba6,0x0f8e2d26,0x9e74c56c,0xda6bb05e,0x60a30c2d,0x37505984,
0xcb9d1181,0xb4f39d14,0x0be2d19e,0x52095e75,0x12433c8a,0xa3f9d53c,0xd274be76,0x5ec71387,
0x3a774a15,0xc9200ba3,0xb2309ac5,0x1125c402,0x499a5974,0x111a39a5,0xa924cbd0,0xc41bb957,
0x507116c0,0x35ee4991,0xc75d114d,0xbd5bb0ab,0x2444c607,0x551254b3,0x18493e4c,0xb5bac9bd,
0xc191b9f0,0x4af0201f,0x3bcc4c17,0xc39b110d,0xb1d4b4e5,0x232fc840,0x4cbc4f2d,0x0cfb4198,
0xb822bfc4,0xcc14a6f7,0x503b2261,0x47724e4d,0xc46d0d8c,0xaa7fc3d0,0x2286d492,0x4b854bd3,
0x0b08489f,0xc37bca99,0xd74fa8f8,0x4a6b2555,0x496d4d65,0xcdee004f,0xa6b8bc2b,0x23f1d4fe,
0x49744342,0xf792485f,0xb7b2d29a,0xdb37a9af,0x429027a9,0x42f14b32,0xd666f11f,0xa80ab5f0,
0x264cdb8b,0x53093f4e,0xf71e4290,0xb66edadb,0xdb4ba728,0x338721bd,0x37a852f2,0xdcf0f93f,
0xacf6b8e5,0x2975e3a6,0x5ee53a0d,0xfce5347f,0xb1b8dc55,0xde96a686,0x33f31ea8,0x323b5d39,
0xde4800bb,0xa830b37f,0x1978e533,0x5b4038c5,0xff7d2d43,0xb1fcda33,0xeac1a700,0x3b93116a,
0x287f5527,0xd963fff9,0xa69ab0ac,0x0bc8ec7c,0x53ee3f76,0x04442a8a,0xb079de09,0xef78ae2b,
0x44a20cf7,0x297d5172,0xdf3e01dc,0xb3deaacf,0x0d39ecf2,0x516a471b,0x04452d73,0xa6e2e3cc,
0xe840b8b7,0x490e0e7d,0x2d4e4fbd,0xe3f90660,0xbe58a5f5,0x0c04e256,0x4b1445d3,0x07b8276b,
0xa26fdd69,0xdd9cbeb8,0x47720ebe,0x29b9511a,0xe12613d6,0xc819ad53,0x15d7dfc3,0x514b489a,
0x1561266d,0xad6ed712,0xdd56c719,0x489015c2,0x25cc4e4a,0xd17c17d9,0xc3c7b046,0x127edb32,
0x46e64a3b,0x14cd245d,0xb3abcab4,0xdccec01c,0x4f581265,0x2d3444ee,0xcc521874,0xc081ba7b,
0x13aaddf4,0x3fcc51b6,0x168a33e0,0xbcc3cd43,0xd7f0bef5,0x4a23114d,0x326e33db,0xcb0d0b99,
0xbed3ba8d,0x14efd458,0x3211477c,0x045835b1,0xb9f4cc6e,0xd6ffc25c,0x48221fc7,0x3a7f35ba,
0xcf220231,0xc0e3bafd,0x23ead4d1,0x3acd424c,0x01fb3bea,0xbdd0d01f,0xd46dbed6,0x3ae72778,
0x38a33e17,0xd0f90213,0xbeeec406,0x2adcda1b,0x42343639,0xfecb3467,0xc309cd6f,0xdce0b867,
0x34402918,0x329543d9,0xcee5fd65,0xb4cfc616,0x26cbe44a,0x4309345d,0xfb4c30c4,0xc674cf92,
0xeb34b212,0x3556229f,0x31f94405,0xd7e3fcf1,0xb4f1ca14,0x21daf2aa,0x449b37a4,0xf6d92fc8,
0xc51bd969,0xf4a5b4cf,0x382b2046,0x312e45d6,0xddedf5ab,0xb56ebebd,0x1b5af160,0x44483650,
0xf5072ec3,0xbb90e38c,0xf331baa4,0x35a61b86,0x29024494,0xe146f1a2,0xbb15b4fa,0x1a61f068,
0x49093658,0xf74f273a,0xb6a0e3e3,0xf1fcc059,0x34531a9c,0x20774995,0xe25ffac8,0xc217b5c0,
0x18a5f129,0x4b14341f,0xfe9d1cc8,0xb389dee8,0xefdcc271,0x351a147a,0x1b01490e,0xdf2d04d9,
0xc4fdb65a,0x11e7f22a,0x448237d5,0x05a817cb,0xb851dc38,0xf5b7c6cc,0x4041120e,0x1bad43de,
0xdb9d09b4,0xc66db936,0x0e3af3c9,0x3c21413a,0x07fa1b1e,0xb8a7d9db,0xf264ca11,0x42440d94,
0x1c343620,0xd8010624,0xcce7b68a,0x104bee1e,0x33674448,0x054f1e12,0xb683d8f7,0xea9ed295,
0x4392143f,0x20af3172,0xd99205df,0xd616b7d4,0x1952e781,0x319441c6,0x073521d4,0xbd21d834,
0xe577d82d,0x3e0f1cc5,0x213e31fe,0xd3d207aa,0xd787c12f,0x1f7ae51c,0x33ad3c34,0x0ac022fb,
0xc73dd1d4,0xe657d524,0x389a2075,0x23a0323b,0xcee90a70,0xcf12c932,0x1f0be629,0x2e4335fe,
0x074c2546,0xcc7ece84,0xe974cc5c,0x36c91ffc,0x28832cd2,0xd16e03cc,0xcaf1cebd,0x1f6cec06,
0x293935a6,0xff0c2a2e,0xceddd3db,0xec9bc998,0x340f1f04,0x2bbe29fd,0xd568fa1a,0xc7d8cc82,
0x1ed5eaad,0x2c342ee9,0xf8752c3a,0xcb60d96f,0xe9fac7a5,0x2a071f58,0x29192dfd,0xdbe6f5c3,
0xc836cc5d,0x220eece9,0x329028c3,0xf434268a,0xcaf8dc19,0xee48c642,0x2616209a,0x23dd3523,
0xdeaef587,0xc86acd0a,0x2042f309,0x3936264f,0xf7d9232f,0xcc29e122,0xf54dc74d,0x26981c73,
0x21403a3c,0xe368f8b2,0xc721cc0d,0x195ef93f,0x39bf269f,0xf9501f10,0xc9eae327,0xfcacc82f,
0x29fd17f0,0x1e593aba,0xe4e1fbb0,0xcab9c7de,0x138bfdbf,0x394e2acd,0xfc5d1b82,0xc5ece5a1,
0xfe52ce10,0x2cc6129f,0x178536cd,0xe616fc40,0xd03cc2d4,0x10d7fcc3,0x34622e22,0xfdee1783,
0xc1e1e6ee,0xfa50d348,0x2faf0f4a,0x16043194,0xe54ffee6,0xd5fec085,0x0deef77a,0x32123142,
0x023016a4,0xc230e3fb,0xf61bd9b9,0x300f0f74,0x15f4312d,0xe3a5065f,0xde13c42e,0x13faf638,
0x305a3173,0x056d1487,0xc384df03,0xf3afde05,0x3083139b,0x153c2cf5,0xdcc206ef,0xdc90c5fa,
0x124bf1a8,0x2b11318c,0x05d7157b,0xc84dd8fd,0xf28bdc5a,0x339e1313,0x18392a36,0xd98007a2,
0xddc6cd1c,0x154ef37a,0x2891344f,0x06bc19cf,0xcdd7d95e,0xf3d1de61,0x32ca17bf,0x1b7824de,
0xd80e03d2,0xdca0cd15,0x169aeed5,0x22b7306d,0x00441c07,0xce24d8b9,0xee3cdcac,0x2eda186b,
0x1d30213d,0xd863fecc,0xdbdccff8,0x1a4fee20,0x227a2cf0,0xfefd1e97,0xd248d795,0xef4bdbb5,
0x2a471cf4,0x1fd52563,0xd8bcff08,0xdbc9d54a,0x1f23f124,0x26212887,0xfc2b1fbe,0xd650d85b,
0xf16dd9c4,0x24701d91,0x1f652510,0xd96cf9da,0xd721d5c3,0x1d30f27c,0x2577230f,0xf9131fab,
0xd72ddbac,0xf5bbd73b,0x21991c72,0x207d2828,0xdec8f991,0xd6d3d830,0x1d00f8ee,0x2912218c,
0xf8431e13,0xd794df88,0xf9bfd55e,0x1f3d19db,0x1c17294d,0xe09df738,0xd4b1d641,0x1751fafd,
0x290f1da4,0xf6d31ab8,0xd467e1fe,0xfc7ed5a7,0x1f5f1579,0x1a942ab0,0xe367f7ab,0xd6f4d2b2,
0x14c3fe30,0x2bf92108,0xf7001936,0xd284e49d,0xfe68d9b0,0x222e1398,0x18e32cad,0xe624f879,
0xdc27d15e,0x1334fe91,0x2d42228f,0xf87b1765,0xd12ee5e5,0xfe11ded6,0x2274118b,0x143b2d17,
0xe45cf90b,0xdf6dd0ea,0x11c4fe16,0x2db72300,0xfcb812e4,0xd2a8e532,0xfef9e0f9,0x24a711de,
0x12e22e39,0xe43ffe9e,0xe104d2a4,0x1055fed3,0x2bad262f,0xfe0a10f5,0xd22fe296,0xfdede16f,
0x276e0ed1,0x11332958,0xe164fdea,0xe201d08b,0x0d31fd7f,0x2687289a,0xfe421179,0xd10ae1a2,
0xfc49e34a,0x28af0ce1,0x11fb2457,0xe098fe55,0xe5fed12f,0x0d05fabc,0x231927c5,0xfe4f122b,
0xd17edfb2,0xf80ae6ae,0x27c50f4e,0x11d321e0,0xdf15fe1a,0xe7bed237,0x0ffcf5e5,0x2046269a,
0xfdb71265,0xd380ddb8,0xf51be74f,0x262b10d8,0x13db1f7e,0xdda9ff07,0xe79fd84d,0x1291f519,
0x1f092580,0xffd91506,0xdb02dd89,0xf5d0e718,0x24e8149c,0x15681eda,0xdcbbff1a,0xe541dbd7,
0x1537f54f,0x1f3b23be,0xfe271694,0xdc77dd4d,0xf5cae3d0,0x2285150c,0x17851eb8,0xdd5dfb83,
0xe349de0c,0x1494f721,0x1eb72208,0xf96317c6,0xdefcde26,0xf851e286,0x214b13dd,0x183d1f22,
0xdfccf88e,0xe244dff8,0x141cf9b0,0x1f631fd0,0xf68717a2,0xdf49e0f9,0xf9f7e2a1,0x1e971485,
0x17a32010,0xe34ef59f,0xe391de7e,0x14c9f9d2,0x219a1ed1,0xf6731833,0xde79e54f,0xfb9ee516,
0x1e9715ad,0x170f230d,0xe670f6e9,0xe4dcde52,0x158efc77,0x23c21dc7,0xf7481511,0xddfee51b,
0xfcebe43d,0x1c5113a9,0x13a52441,0xe598f867,0xe44ade3f,0x12edfe2e,0x25321de7,0xf80e123f,
0xde74e550,0xff0de47c,0x1d491150,0x11482477,0xe523f78d,0xe4e2ddf2,0x101bff5b,0x23611e4d,
0xf68f10a8,0xdda2e659,0xfee6e5d6,0x1ef30db8,0x10552213,0xe720f66d,0xe665dc49,0x0c86fdf4,
0x20ba1e4f,0xf5e50f10,0xdb0be666,0xfcbee772,0x1dff0bac,0x0e7f20e5,0xe6acf733,0xe854db24,
0x0cf4fbfc,0x213e1e0f,0xf8a50e1d,0xdbd9e69e,0xfb98ea65,0x1eb20e2d,0x0dae20c4,0xe5baf9a8,
0xea2adbab,0x0e04faa3,0x1fe01ede,0xf9250c66,0xdca8e595,0xfb0eeacf,0x1f4e0e7f,0x0c911e9c,
0xe55df99d,0xebd4df62,0x0eb7fb87,0x1f1e20ba,0xfaf60d90,0xe179e4f8,0xfb6eeb8e,0x20880f33,
0x0d791e2b,0xe4bafad7,0xebdfe1c7,0x0eccfacc,0x1cd81fcb,0xf97e0d9e,0xe21ce4d4,0xfa28ebed,
0x1f980e7b,0x0e621c03,0xe567f879,0xec08e210,0x0e4cfa75,0x1ae21f66,0xf84b0f27,0xe3bfe67b,
0xf9d7ec39,0x1f940ed9,0x0f741b9e,0xe676f7ef,0xec91e41f,0x0fb1f9e7,0x1b581e75,0xf8fc0f1f,
0xe4d1e7b3,0xfa60edb0,0x1d5b10ee,0x0e911ba8,0xe7caf8b0,0xed91e57a,0x11fefa43,0x1bb11c9a,
0xf8bf0d8d,0xe54fe806,0xfabaec6a,0x1c071196,0x0dc61b98,0xe860f97a,0xeb56e6c4,0x1164fac4,
0x1b681c6c,0xf9ba0d72,0xe76ee8f6,0xfaf3ea68,0x1b851051,0x0d3e1ad7,0xe8b7f924,0xe955e6fc,
0x0f37fab4,0x19be1b4a,0xf71b0c6d,0xe6cae8c8,0xfb3ce991,0x1b2f0df3,0x0cd81952,0xe9e4f79c,
0xe9b0e6de,0x0e3bfbcb,0x197a1b1b,0xf6c90c1d,0xe64be9ef,0xfb16ea36,0x19b40dc7,0x0bc8189c,
0xeae8f692,0xeae1e50d,0x0dc2fac3,0x191c1952,0xf6bc0bf5,0xe50ceb5b,0xfba5ebf6,0x19c80e97,
0x0bab19b9,0xebfff6e7,0xec78e5d9,0x0e8dfc79,0x19701978,0xf7e80b5f,0xe6f1ebea,0xfcececf5,
0x19ac0f16,0x0adf1ad2,0xec20f964,0xed83e807,0x0ffefdd9,0x1b561952,0xf9d50aa3,0xe895ebf9,
0xfcfbed56,0x19450efd,0x0a6c1a85,0xec06f8e0,0xecece7cd,0x0e14fd15,0x190c19fe,0xf8000a07,
0xe880ec8d,0xfec7ed15,0x1afa0c9a,0x0a1117c5,0xed37f7ef,0xed0be94a,0x0c61fec8,0x16fd1ab3,
0xf7a90967,0xe90eedc5,0xfd39edf1,0x194e0c8c,0x09451743,0xee06f79c,0xf001e89a,0x0cecfc84,
0x16e718bd,0xf777086b,0xe781ef0a,0xfb91efcc,0x17f10d0a,0x07f91658,0xedcaf760,0xf02ee6fa,
0x0cb8fbeb,0x165d1752,0xf87e077b,0xe85ded8b,0xfcdbf03d,0x18880d4c,0x070216a4,0xed73fa16,
0xf047ea0f,0x0cebfd61,0x161f17fb,0xfa680620,0xeaf3ed15,0xfc61efd3,0x17850bde,0x05ab1488,
0xecf1f97f,0xf001eabb,0x0b39fcb1,0x134d1827,0xf96b06d2,0xeb7dee45,0xfcd3f0ec,0x18a50b62,
0x073e133b,0xeefdf91d,0xf0ecebed,0x0c39fc6f,0x123a18af,0xf9640737,0xebb0ef14,0xfc51f131,
0x17ce0cba,0x074311a8,0xefa2f8f6,0xf201eba0,0x0d45fb93,0x11091738,0xf8bc0651,0xebc6efad,
0xfbb1f2dd,0x167c0dae,0x067211dd,0xeff8f996,0xf306ec8c,0x0ed0fc55,0x127715dc,0xfa2106b4,
0xede3efc3,0xfd30f2d9,0x15b80fe1,0x06bf11a8,0xef11fb49,0xf28beec3,0x0e84fd2f,0x11b21547,
0xfb3306c6,0xef1eee99,0xfe27f180,0x15830e97,0x06811123,0xef7cfaf1,0xf03eefb9,0x0e7dfea5,
0x10681512,0xf9fa0779,0xeec6ef7d,0xfe7fefce,0x147b0d97,0x07e30f3d,0xf065f87e,0xf0a9ee91,
0x0de2fea7,0x0eec13f6,0xf74f07d0,0xee35f1a7,0xfe2bf133,0x12a50de8,0x072b0e8d,0xf183f6f4,
0xf0d7ed21,0x0e1cfd89,0x0f681139,0xf76705ec,0xed21f195,0xfd6ef150,0x0f990e88,0x04c4104b,
0xf203f851,0xf18fedc5,0x0ed0fe28,0x112a10ea,0xf8920413,0xef1af24d,0xffe7f12b,0x11dd0dda,
0x03df110c,0xf234f918,0xf0f4efb4,0x0c4101c5,0x100111f5,0xf9660388,0xef9df1bf,0x02daf0e5,
0x11fe0b72,0x03f20fa9,0xf2e2f95e,0xf1c6ee91,0x0b8402ed,0x0f20125f,0xf89a03c3,0xedcbf427,
0x02c4f3b6,0x128b0bcf,0x04210e65,0xf498f801,0xf4cfed54,0x0bc301f7,0x0d74125e,0xf84b0336,
0xed39f479,0x0126f5c1,0x10d70a93,0x021d0dda,0xf2c6f900,0xf63aed41,0x0b1c0081,0x0e641034,
0xf9ff0049,0xedb3f330,0xff4ef5f4,0x106d0b5a,0x00060e40,0xf307fb38,0xf668ee35,0x0b51ffab,
0x0d9011c0,0xfb42005a,0xef6ef27c,0xfff6f61b,0x12ed09aa,0x007b0c80,0xf1d5fb87,0xf5f1f0b3,
0x0a2500f1,0x0b7213d5,0xfb77ffee,0xf24af1ee,0x0069f69d,0x14070a89,0x01730b9a,0xf26efbbd,
0xf72cf1ed,0x0b2dff7f,0x0a5d1410,0xfb730313,0xf197f2e0,0xfebff83b,0x13880b5a,0x04480960,
0xf327fa8a,0xf845f1f6,0x0bf0fe4f,0x08d812df,0xfad4049f,0xf252f2f8,0xff17f800,0x11820e40,
0x0453095c,0xf2ddfaf9,0xf7b6f366,0x0f10fe5a,0x0a590f54,0xfba2040b,0xf3e8f286,0xfe6af74e,
0x0eab0f99,0x03b70ac0,0xf220fa4e,0xf744f511,0x0f0affe0,0x09c20d7e,0xf9ca03f2,0xf56ff2fc,
0x00cff4ff,0x0e1a0ea6,0x034e098e,0xf2d1f900,0xf3bef556,0x0de40285,0x09980d8d,0xf87b0365,
0xf573f3e8,0x02e4f3de,0x0d180cf7,0x032809ae,0xf599f7ff,0xf4a5f4e7,0x0d080280,0x09840cf2,
0xf71b0336,0xf2e5f65e,0x029bf552,0x0c9d0cd8,0x03d10a06,0xf6fbf6fe,0xf62af21d,0x0c1f030a,
0x0a460b98,0xf76e02ff,0xf1fff6a3,0x03a3f630,0x0b200b9a,0x01340af8,0xf5a9f83e,0xf5dbf210,
0x0aa703a8,0x0bc50ac0,0xf947ffb7,0xf254f574,0x040ff638,0x0a3b0a89,0xff7f0b67,0xf63cfa8b,
0xf6b2f1eb,0x0a1404bf,0x0b2f0b45,0xf9f5ffd9,0xf1aef692,0x0531f740,0x0c8a08de,0x001109b4,
0xf727fa56,0xf7abf114,0x077c05e1,0x09320daa,0xfb2fffde,0xf0e1f6d4,0x05c0f859,0x0e050796,
0xff630931,0xf676fbb0,0xf9caf0ea,0x084d041f,0x098e0d9c,0xfc1bffcf,0xf090f604,0x029ffc1e,
0x0da108b4,0x0042097f,0xf5b3fc7f,0xfce2f037,0x09b40255,0x08330edf,0xfc62ffa5,0xf15cf57c,
0x027efc44,0x0ea108fc,0x001c06e3,0xf3c2fd80,0xfba5f2f3,0x09750256,0x064b0e5d,0xfe91ffd6,
0xf466f365,0x0173fb2d,0x0d660a58,0x00940648,0xf3c1fe9e,0xfb34f4c7,0x0b1900a6,0x05ac0cf0,
0xfd3601ae,0xf49df422,0x013efb1f,0x0d6f0bb4,0x03530503,0xf43ffc87,0xfa43f53b,0x0b24016e,
0x04c70dcb,0xfbe1035d,0xf66bf44a,0x019ff9b3,0x0d680b89,0x0296057a,0xf46cfab4,0xf9c9f731,
0x0c5b0178,0x05b90b5b,0xfa930274,0xf6dcf543,0x0098f9b4,0x0ae50ca4,0x02810608,0xf5adf96f,
0xf9a1f660,0x0baa009e,0x057f0a53,0xf903026f,0xf64ef5d0,0x0121f8fe,0x09100a93,0x0222053a,
0xf597f93d,0xf859f6ad,0x0b020251,0x05e6083d,0xfa320244,0xf6faf599,0x0286f852,0x07590b23,
0x021f06a4,0xf663fa5d,0xf8def6e3,0x0ae20358,0x06520704,0xf9d501d9,0xf648f743,0x042df882,
0x083f0a6c,0x01480651,0xf7e2f89f,0xf819f631,0x09ef04d2,0x0652082b,0xf906010e,0xf5f5f815,
0x055ff8b9,0x07da0974,0x00160716,0xf8eff9c0,0xf94ff5b1,0x09750597,0x07eb07d3,0xfa32ffa7,
0xf53df9d2,0x05a2fa87,0x07c008d3,0xffca07bd,0xfa1afb46,0xfb00f468,0x073504e5,0x079f0814,
0xfbb3ff90,0xf3c1f95e,0x0516fab9,0x08e2068b,0xff9207c2,0xf813fc09,0xfb68f3de,0x06030507,
0x08220945,0xfcc3ff95,0xf41ef77a,0x0446fc62,0x09820603,0xff690782,0xf781fd54,0xfd3cf3ae,
0x061f03fd,0x06fa09d6,0xfcf8ffec,0xf434f75d,0x02f7fe0e,0x0a0a05d7,0x00620617,0xf736fda2,
0xfdf1f4c2,0x05f00314,0x05990a2d,0xfe23005f,0xf60af688,0x0314fe19,0x0a38066f,0x008605ad,
0xf63cfedd,0xfe32f71c,0x06be024e,0x05a709fe,0xff3c00e1,0xf691f589,0x0209fe7c,0x09750704,
0x018e0510,0xf50dfe13,0xfe2ef663,0x069400c8,0x042b0980,0xfcb60265,0xf6aaf4cf,0x0178fe0b,
0x091d06dc,0x02df0319,0xf428fc58,0xfe20f7b7,0x07a20205,0x0315086b,0xfc50026a,0xf844f3a1,
0x01a2fda2,0x07910855,0x02040397,0xf3bffb87,0xfe14f8e9,0x08d90121,0x03530691,0xfacc025c,
0xf98df4cf,0x00b4fdb2,0x068208c8,0x03310370,0xf54dfa50,0xfcccf991,0x091d01fe,0x037006c6,
0xfa32036c,0xfac1f5a1,0x02ccfc58,0x064f0816,0x033e0480,0xf5f6fa0d,0xfba2fb20,0x092703ca,
0x050205a7,0xf9dc0263,0xfabcf699,0x03b7fbc5,0x04fc0940,0x023505aa,0xf7b2f903,0xfc12fa19,
0x08ab0405,0x05fa04c8,0xf89502e4,0xf9c2f8a7,0x050cfc4b,0x04de0787,0x031e062a,0xf8f1f8c4,
0xfb8ff9ae,0x065b0588,0x062a04b5,0xf8e6019a,0xfa07f919,0x055efbdf,0x03f605bf,0x00890660,
0xf9abf9eb,0xfc6bf8db,0x052d0528,0x06b70327,0xfa0c002d,0xf86dfaaf,0x0506fd48,0x044904f3,
0x002a06fa,0xfb79fa62,0xfe27f85b,0x03c3054e,0x06f10511,0xfb33004b,0xf81ffb03,0x05dcfde4,
0x060d0364,0xff5f0702,0xf9f0fbcd,0xff21f882,0x036406b9,0x067305e2,0xfc57fe6f,0xf88cf9e6,
0x057c000a,0x06040337,0xfe100626,0xf9abfc3b,0x0195f82e,0x02f30518,0x052e069a,0xfc78fe94,
0xf82bf9fc,0x0455012e,0x078802bf,0xfebf0418,0xf95dfc92,0x00e2f8ac,0x024e0340,0x041d0836,
0xfceefe9c,0xf8cef7f8,0x029700f9,0x07ec030e,0xfe5f03d5,0xf760fd2f,0x015bf908,0x03aa016a,
0x03c307b1,0xfce8fe79,0xf98bf747,0x00d10224,0x07740453,0xff3202da,0xf6eefc65,0x01d7fa28,
0x04800051,0x020e07df,0xfc45ffef,0xfa75f648,0x00410116,0x07f7049a,0xfffb022e,0xf604fbcd,
0x00cafc12,0x0489ffb1,0x029a0700,0xfba4002d,0xfcfdf5bb,0xffb900e5,0x06030538,0x00ce029a,
0xf5c8fb15,0x00c4fd35,0x0592ff7f,0x026a05d7,0xfaac01b1,0xfdaaf6dc,0x000d0020,0x05ad05bd,
0x02830281,0xf775fa26,0xff47fdec,0x062f00ea,0x02e70576,0xf9880283,0xfe87f786,0x00d7fea9,
0x04c80620,0x01ca0383,0xf873f946,0xfe6bfee8,0x067800cc,0x03f303fc,0xf8760159,0xfefaf96f,
0x0160fed1,0x03690686,0x01180415,0xfa87f812,0xfeaefeeb,0x06c50297,0x04630360,0xf7b8009c,
0xffb7fb37,0x0315fee2,0x035d05ab,0x00200550,0xfb00f7e9,0xfe2bff49,0x05b103d6,0x059e037c,
0xf7fffeb9,0xfeb0fb30,0x040ffe02,0x032c0516,0xfe7405f0,0xfba3f7ff,0xfe89fe10,0x0462043c,
0x06230388,0xf7eafe5f,0xfd59fc52,0x0484fe8e,0x04bc03d5,0xfe1e066e,0xfc0cf7f7,0xfee8fc94,
0x03200533,0x063e0511,0xf8c6fd8b,0xfc06fc51,0x0532fed2,0x05b10356,0xfcc60634,0xfbf0f91b,
0xffd6fb61,0x033604e4,0x05b90568,0xf996fc3d,0xfab9fc30,0x03b40055,0x059c02ae,0xfb83051f,
0xfc7ff9d5,0x011afae3,0x020f0327,0x04e60655,0xfa78fb82,0xfaecfbe4,0x02f3017d,0x06ec01be,
0xfb3e0480,0xfb25fb5a,0x016cfb8f,0x01ab0222,0x03ed0720,0xfbf4fac9,0xfc06fa26,0x017f0182,
0x07d40227,0xfa7d03b4,0xf972fb98,0x0200fc5a,0x02790135,0x024607b3,0xfbe2fb27,0xfc8af9c0,
0x00fb021d,0x081d028f,0xfbf60117,0xfa15fbce,0x0209fd79,0x02830080,0x0033080a,0xfc2cfcf3,
0xfdb5f9af,0x006901be,0x07da0371,0xfd1cff97,0xf983fc17,0x01cffe52,0x0463fffd,0x00010727,
0xfbcefd8b,0xfec7f9b8,0xff4401e8,0x06b10598,0xfe030047,0xfa77fb98,0x020effaa,0x0651ff05,
0x001e0654,0xfb0cfe46,0x0070fa81,0xff78018b,0x05b00669,0xfe84ffbb,0xfa7cfafb,0x00070117,
0x0699ffe6,0x009305bb,0xfa09fe8c,0x01b5f9eb,0x0077ff4a,0x050506e5,0xfe8400ea,0xfa39f9ef,
0xfe6f011e,0x07700111,0x017704b7,0xf908fe91,0x012bfb32,0x014ffe58,0x04710717,0xff4e01c6,
0xfbeff858,0xfe1300a5,0x06870216,0x020d0446,0xf7f1ff8f,0x0027fc9a,0x02a8fd41,0x0402060e,
0xfefa0279,0xfd08f7fa,0xfc77ff51,0x05f302a8,0x02ed039e,0xf845fde7,0xfe29fda5,0x02d9fc7c,
0x036b0617,0xfd370397,0xfe42f87e,0xfd12fd6e,0x060602f6,0x03ae03b9,0xf950fcec,0xfd18ff53,
0x0375fd4f,0x044e057c,0xfc4203d6,0xff21f9a2,0xfdb2fd01,0x04980415,0x03b80454,0xfa82fb15,
0xfcedfef2,0x0401fdcf,0x04290388,0xfa9503c7,0xfdf3fb00,0xfe76fc84,0x03750410,0x03490516,
0xfacdf9c0,0xfc9cfde1,0x03b8ff7a,0x05b802c2,0xfa8202a9,0xfe02fb37,0x0006fc5c,0x027003b5,
0x01810608,0xfbe4fac1,0xfc70fe44,0x0337007a,0x070402a0,0xfa9e0137,0xfdc4fc11,0x01a1fc9a,
0x03060318,0x00e106a7,0xfcfafad4,0xfc3dfd6c,0x026d0203,0x069e042d,0xfa9c005a,0xfd34fd52,
0x028ffc51,0x04c8020e,0xff83061a,0xfdbafafb,0xfc72fc78,0x01ac0225,0x06340503,0xfaa6feda,
0xfc01fdcb,0x01bcfd8c,0x04ed0148,0xfe8005eb,0xfe6bfb22,0xfe46fb91,0x01260112,0x065205c3,
0xfb9afe59,0xfb4bfe62,0x0120ff31,0x061b010d,0xfe0e0647,0xfdb2fc5a,0xff78fb37,0x013800e2,
0x05c20678,0xfd24fd86,0xfb88fcf8,0x0040ffb0,0x06bb011e,0xfd590588,0xfc99fdf1,0xfff1fc29,
0x0085ff42,0x04ae0677,0xff01fdbe,0xfc0ffc60,0xfe9eff9e,0x06a9007a,0xfe8a03c3,0xfc31ff90,
0xff60fc5b,0x00bbfe27,0x0319075f,0xff41ff1f,0xfd1efb91,0xfe67ffaf,0x0752012f,0xffdc0248,
0xfb8bff7a,0xff4cfd90,0x026bfe5f,0x01e2079f,0xff120011,0xfe48fbe8,0xfdcaff8d,0x06a10291,
0x00ca01b6,0xfc1cfeb6,0xff70fe1d,0x0399fd98,0x016e0603,0xfe4800f8,0xfe8dfc77,0xfcc0ff1c,
0x05400375,0x0160019a,0xfc53fe13,0xfe3afe65,0x042bfce4,0x01f00500,0xfde10162,0xfebdfbed,
0xfd88fdb4,0x046804b0,0x0116024c,0xfb8bfdca,0xfd17fefa,0x048efda5,0x028c03c1,0xfdc300e7,
0xfedffbd8,0xfddafc0f,0x03de04dc,0x00dd0285,0xfc1dfd3e,0xfbd5feff,0x044ffe84,0x0249039e,
0xfcc2015e,0xfee6fcbe,0xff66fb35,0x03ae0432,0x0159023c,0xfd47fc3a,0xfb59ff0a,0x03e90027,
0x02570331,0xfbd40112,0xfebbfdd9,0x00bcfbb0,0x02d60428,0x010202d3,0xfed6fc0d,0xfbeffdef,
0x03f300bf,0x03790269,0xfc2700cf,0xfd3effa1,0x009efc26,0x0221034f,0x00640414,0xff81fc05,
0xfc5cfcd8,0x02cf0108,0x046a0243,0xfcb6ff9a,0xfc7fff51,0x015ffc44,0x0299024e,0xfe9e04e1,
0xfed5fd41,0xfccefc65,0x022001f1,0x04b802d4,0xfe0cfdf4,0xfc1dfeb3,0x0249fd63,0x030401ab,
0xfdca03d4,0xff2efe97,0xfdecfc5f,0x00a301b6,0x032a037a,0xff2efe42,0xfbe4ff29,0x01b7fe05,
0x040f004a,0xfe05020e,0xffafffb4,0xfe3afc26,0xffdd0116,0x01b3043c,0x0039fe77,0xfbeaff41,
0x00a2fee8,0x043a0055,0xfe330107,0xff230051,0xff38fbdf,0x00d2ff83,0x00dc045c,0x0037fe36,
0xfbf5febb,0xff15fff5,0x045e0154,0xfeb100c4,0xfe610084,0xff9ffc0a,0x01f1feae,0x00cc04ba,
0x00aafeed,0xfd05fdc1,0xfebbffd1,0x047b0220,0xff3e0098,0xfcfb0126,0xffdefdad,0x025bfecc,
0x00840445,0x012dff5b,0xfe91fcdd,0xfe5eff89,0x0406026f,0x0031003e,0xfce5013e,0xff19fee8,
0x0283fe52,0x001103e9,0x00a7012a,0xfef3fcb9,0xfe48fe92,0x039e027e,0x0227ff95,0xfcd9007d,
0xfde7fee2,0x02c4fe59,0xffab0370,0xffb70278,0xfec9fca4,0xfed2fdca,0x027e037f,0x0258ff5a,
0xfd39ff2e,0xfd7bfecb,0x044efee6,0xffa801ff,0xfea40242,0xfe99fd89,0xff4efd97,0x012f047b,
0x023a002e,0xfdc2fe1d,0xfd3efe8e,0x0475ff6c,0x00cf0112,0xfdec01cd,0xfed6fe2d,0xffeafcc9,
0x007d040b,0x01ce019f,0xfe09fe13,0xfc0dfe87,0x03b80053,0x01d20027,0xfe380134,0xfeabfe88,
0x00b1fbec,0xffd802f7,0x01260213,0xfeaffe1b,0xfc51fe77,0x028601a4,0x0211fff9,0xfe37011a,
0xfe0fff49,0x021bfc56,0x00ab022a,0x00ec023c,0xff85fe03,0xfcd8fda5,0x01ec02bd,0x024900e7,
0xfe0500f0,0xfce5ff51,0x0315fd97,0x00f5019a,0x00510285,0xff9efe05,0xfe66fcb4,0x015502c1,
0x028800d3,0xfe22ff9a,0xfc5fffbf,0x02aeff4e,0x009a00f3,0xff12022b,0xfffefec3,0xff66fc31,
0x00ba0251,0x022c00f1,0xff8bfee9,0xfc40ffac,0x01efff98,0x01200007,0xfeb80236,0xff080015,
0xff95fc4e,0xffcf019a,0x022701a1,0x006efe87,0xfca1fe91,0x01ab002a,0x0216ffdb,0xfef701da,
0xfdef00c0,0x009efc62,0xfffd01d7,0x01390279,0x00b6ff39,0xfd0afde0,0x017d013a,0x02d1ffd2,
0xff780098,0xfdd600bb,0x017cfd69,0xffc00107,0x002c02c1,0x00e7000b,0xfd98fd91,0x004f0165,
0x02e4003e,0x0010fff1,0xfd7300b9,0x0190fdd7,0x00eeffeb,0xffa50297,0x00af0053,0xfe29fd59,
0xff9d01be,0x02160176,0x00f8ff81,0xfd92010d,0x0137fe71,0x01f4ff42,0xff7b021b,0x008d00f0,
0xfec7fd04,0xff1c00a6,0x017201f9,0x0121ff4f,0xfc950081,0xffd8fefa,0x0275ff2e,0xffbb017d,
0x00190154,0xff6efc4b,0xff78ff8f,0x013302a0,0x01b1fffe,0xfc72ff95,0xff85fff1,0x0290ffd1,
0xffe900cc,0xff230200,0x0066fd32,0x0027ff5e,0x00a7026a,0x021dfff0,0xfd4cfe59,0xff2d0055,
0x024d008f,0xffcf0033,0xfe1f021d,0x0032fdf1,0x0072fe9d,0x00000226,0x02310093,0xfe0efdb2,
0xfe9effe0,0x022b008f,0x0139ff9f,0xfd9b0218,0xff6cfe7f,0x00e7fe9e,0xff58024d,0x01c0018f,
0xfec7fd80,0xfebfff25,0x01d70143,0x01b7fefa,0xfd98015b,0xfea2feb1,0x01b2fe87,0xfeea0182,
0x00db01d4,0xfec0fdd7,0xfe49fe6c,0x01420212,0x024bff4e,0xfdae0016,0xfe57feb9,0x026bfe8d,
0xff4600b0,0xff950227,0xff14fdf2,0xfee6fe1b,0x004902bb,0x0222ff98,0xfe59ffa5,0xfe2bff98,
0x0291ff7a,0x002dff8a,0xff9c022a,0x0003fec4,0x000dfe3b,0xff21027d,0x01ea0078,0xff29ff80,
0xfde9000d,0x0274005f,0x0118ff5b,0xff940227,0xffb2ff66,0x00f8fdbc,0xffa70231,0x026101a7,
0xffaaff76,0xfd95ff4e,0x01f401d5,0x01d5ffaa,0xff310227,0xff0bffc7,0x0224fdcb,0xff8a0169,
0x01d301ec,0xfffbff38,0xfdedfe6c,0x01300248,0x016eff5a,0xff62010d,0xfe0e0084,0x024dfe5d,
0xff07009e,0x00f10174,0x006dff8d,0xfeaefd71,0x004c0243,0x0178ff34,0xff890042,0xfd600098,
0x01a8feaf,0xffc2ffc8,0x00050202,0x0020ffba,0xff3efd3c,0xff5101ba,0x01bcff97,0x005bff99,
0xfd210006,0x014fff58,0xffe1ff06,0xff6701a7,0xffb200ab,0xffd1fd2c,0xfeb40128,0x01730025,
0x00f0ff88,0xfd5bff89,0x00ab0000,0x00c5fe81,0xff78010b,0xff6e012b,0x0025fd73,0xfeae008d,
0x00e2015c,0x0140ffc3,0xfd65fee4,0x00730073,0x015bfece,0xffe90050,0xfe9d015e,0x0117fdca,
0xfed8002a,0xffe50112,0x01be0066,0xfe13feb1,0xff950117,0x010bff41,0x0090ff6b,0xfe9701c1,
0x00fbfe36,0xffb2ff4b,0xff1700f3,0x01bf00ba,0xfe81fe91,0xfef000a7,0x00f3000a,0x0106ff5b,
0xfe2d015b,0x00acff1c,0x002dfebd,0xff490097,0x01510134,0xffa2fe2e,0xfe91004f,0x007b009a,
0x015cff5b,0xfe0c00f4,0x0051001c,0x0093fed0,0xff53ffdc,0x00bc01b8,0x0058fe2d,0xff15ffee,
0xff9000bb,0x01eaff51,0xfe650050,0xffba00a0,0x0081ff34,0xff58ff7a,0x005101d9,0x004afeac,
0xff5bff99,0xffaf008a,0x01c9ff83,0xfecb0054,0xffbc001f,0x0086ff66,0xffa1ffbc,0x008001c1,
0x0022fed7,0xff29ffcc,0xffbf0095,0x019fff9a,0xfeb10081,0x00000042,0x008bff27,0xff78ff83,
0x008d01ba,0x005dfe80,0xff31ffdc,0xff8300b6,0x01eaff56,0xfe7c004c,0xffb1009c,0x0078ff60,
0xff8eff45,0x003801bc,0x0047ff36,0xffd4ff85,0xff3e005d,0x0167000f,0xffba001b,0xff9f002a,
0x00030036,0x0071fef5,0x00380118,0xfff50024,0x0086ff93,0xfecbff97,0x009e00b0,0x00800032,
0xffefffe0,0xfec000ff,0x00a3fe68,0x00580045,0xff6d00dd,0x0163000c,0xfe83fe10,0xffbe00a2,
0x01200072,0x0044ff0b,0xfdb5014c,0x0069fec3,0x00b7ff9f,0xfeb30104,0x011e0093,0xfeaefd97,
0xff58ffd4,0x00f600f9,0x00cefe94,0xfd830099,0xffb0feed,0x0125ff2f,0xfeb300c5,0x002c015a,
0xfefdfd75,0xff34ff59,0x008b019a,0x015efe9e,0xfdbeffc0,0xff32ff58,0x01e6ff47,0xfeda0032,
0xffb0017d,0xffc5fe41,0xff8bff3e,0xffa50202,0x01c8ff68,0xfe96ff8f,0xff34fffe,0x0238fff9,
0xffc7ff56,0xff6301b0,0x001efee5,0x003efef8,0xff660253,0x01d30061,0xff05ff66,0xfebbffee,
0x023f00ca,0x00f5ff6d,0xff6601fb,0xffc7ff29,0x0181fe72,0xff6d0222,0x01ce0143,0xff4bff37,
0xfe6dffaf,0x01b101d7,0x0162ff58,0xff340194,0xff31ff92,0x0209fe4b,0xff4f0169,0x0115011a,
0x0019ff39,0xfe7bfedd,0x00e70239,0x011bff21,0xff510116,0xfe3a0033,0x024dfe9e,0xff40009d,
0x008b0121,0x007bff31,0xfea0fe0e,0x001b01c5,0x01bbffa5,0xff4f005f,0xfdae0039,0x01cfff1c,
0xff60ffc0,0xffea0198,0x004affdb,0xff3bfd63,0xff71015f,0x01aeff8a,0x0025ff98,0xfd4c0007,
0x0143ffab,0xffbaff12,0xff89019f,0xffd4008d,0xffc7fd67,0xfeb900e0,0x01600056,0x00f9ff50,
0xfd79ffb7,0x00ceffd8,0x00f8feb8,0xff830148,0xff2c0141,0x0015fd5c,0xfeb500c8,0x00ad0118,
0x0177ff9a,0xfda4fee6,0x009400c4,0x00fafea0,0x0033001e,0xffe5016c,0x00020020,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,
};
