#include "standard_DRUMS_samples.h"
const AudioSynthWavetable::sample_data standard_DRUMS_samples[48] = {
	{
		(int16_t*)sample_0_standard_DRUMS_filtersnap, // sample
		false, // LOOP
		9, // LENGTH_BITS
		(1 << (32 - 9)) * WAVETABLE_CENTS_SHIFT(-31) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(45) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)419 - 1) << (32 - 9), // MAX_PHASE
		((uint32_t)416 - 1) << (32 - 9), // LOOP_PHASE_END
		(((uint32_t)416 - 1) << (32 - 9)) - (((uint32_t)7 - 1) << (32 - 9)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-14.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(100.02 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_standard_DRUMS_whitenoisewave, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(19) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(51) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)8293 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)8289 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)8289 - 1) << (32 - 14)) - (((uint32_t)7 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-14.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(930.34 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(731.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_standard_DRUMS_verbclickwave, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-48) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(54) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1207 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1204 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1204 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-14.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_3_standard_DRUMS_scratch, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-48) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(57) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1660 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1657 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1657 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-11.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_4_standard_DRUMS_guitarfret, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-12) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(42) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3571 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3567 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3567 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-11.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_5_standard_DRUMS_stix, // sample
		false, // LOOP
		9, // LENGTH_BITS
		(1 << (32 - 9)) * WAVETABLE_CENTS_SHIFT(4) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(42) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)369 - 1) << (32 - 9), // MAX_PHASE
		((uint32_t)366 - 1) << (32 - 9), // LOOP_PHASE_END
		(((uint32_t)366 - 1) << (32 - 9)) - (((uint32_t)7 - 1) << (32 - 9)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-3.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(281.10 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_6_standard_DRUMS_sinetick, // sample
		false, // LOOP
		7, // LENGTH_BITS
		(1 << (32 - 7)) * WAVETABLE_CENTS_SHIFT(0) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(31) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)72 - 1) << (32 - 7), // MAX_PHASE
		((uint32_t)68 - 1) << (32 - 7), // LOOP_PHASE_END
		(((uint32_t)68 - 1) << (32 - 7)) - (((uint32_t)7 - 1) << (32 - 7)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-12.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(430.03 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(281.10 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_7_standard_DRUMS_verbclickwave, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-48) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(51) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1207 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1204 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1204 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-12.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(330.07 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(281.10 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_8_standard_DRUMS_coldglass12wave, // sample
		true, // LOOP
		7, // LENGTH_BITS
		(1 << (32 - 7)) * WAVETABLE_CENTS_SHIFT(-34) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(44) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)90 - 1) << (32 - 7), // MAX_PHASE
		((uint32_t)86 - 1) << (32 - 7), // LOOP_PHASE_END
		(((uint32_t)86 - 1) << (32 - 7)) - (((uint32_t)15 - 1) << (32 - 7)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-12.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2948.54 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(281.10 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_9_standard_DRUMS_bd15, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(24) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(48) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1602 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1599 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1599 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(340.13 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_10_standard_DRUMS_verbclickwave, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-48) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(56) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1207 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1204 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1204 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-13.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(400.07 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(451.15 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_11_standard_DRUMS_snare24, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-43) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(56) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3876 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3873 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3873 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-4.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1529.79 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1597.52 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_12_standard_DRUMS_snare24, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(8) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(52) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3876 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3873 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3873 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-11.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1239.71 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1130.92 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_13_standard_DRUMS_floortombrite, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(-25) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(67) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7171 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7167 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7167 - 1) << (32 - 13)) - (((uint32_t)5236 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-6.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2278.89 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1937.46 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_14_standard_DRUMS_hatopenms, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(-17) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(54) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)11709 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)11705 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)11705 - 1) << (32 - 14)) - (((uint32_t)5828 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-4.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(3559.48 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1937.46 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_15_standard_DRUMS_floortombrite, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(40) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(63) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7171 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7167 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7167 - 1) << (32 - 13)) - (((uint32_t)5236 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-6.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1937.46 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_16_standard_DRUMS_crash5, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(47) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(68) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)13533 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)13529 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)13529 - 1) << (32 - 14)) - (((uint32_t)8024 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(3138.34 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(2668.14 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_17_standard_DRUMS_chcrash, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(47) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(74) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)9699 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)9695 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)9695 - 1) << (32 - 14)) - (((uint32_t)6162 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-7.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(3138.34 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(2072.92 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_18_standard_DRUMS_tamborine, // sample
		true, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(35) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(70) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3603 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3585 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3585 - 1) << (32 - 12)) - (((uint32_t)2157 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-5.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(80.03 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(3874.92 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_19_standard_DRUMS_crash5, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(47) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(65) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)13533 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)13529 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)13529 - 1) << (32 - 14)) - (((uint32_t)8024 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-9.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2599.68 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(2208.91 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_20_standard_DRUMS_cowbell, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-14) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(72) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1759 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1756 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1756 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-20.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(80.03 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1429.82 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(3874.92 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_21_standard_DRUMS_crash5, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(47) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(74) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)13533 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)13529 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)13529 - 1) << (32 - 14)) - (((uint32_t)8024 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2599.68 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(2208.91 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_22_standard_DRUMS_vibraloop, // sample
		true, // LOOP
		10, // LENGTH_BITS
		(1 << (32 - 10)) * WAVETABLE_CENTS_SHIFT(0) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(82) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)787 - 1) << (32 - 10), // MAX_PHASE
		((uint32_t)783 - 1) << (32 - 10), // LOOP_PHASE_END
		(((uint32_t)783 - 1) << (32 - 10)) - (((uint32_t)9 - 1) << (32 - 10)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2599.68 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1597.52 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_23_standard_DRUMS_paisteping, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(18) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(66) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)13292 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)13288 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)13288 - 1) << (32 - 14)) - (((uint32_t)7459 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-16.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2768.62 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(2353.81 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_24_standard_DRUMS_mbongotone, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-18) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(77) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2723 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2720 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2720 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(536.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_25_standard_DRUMS_quintoslap, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(43) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(82) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2922 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2919 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2919 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(680.26 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_26_standard_DRUMS_quintotone, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-46) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(85) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3090 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3087 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3087 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(860.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(374.14 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_27_standard_DRUMS_lowtumba, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(21) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(83) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)4021 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)4018 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)4018 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(930.34 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(493.12 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_28_standard_DRUMS_timpani, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(50) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(95) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7698 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7695 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7695 - 1) << (32 - 13)) - (((uint32_t)7079 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1429.82 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(986.23 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_29_standard_DRUMS_agogolotone, // sample
		false, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(50) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(91) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)4466 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)4463 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)4463 - 1) << (32 - 13)) - (((uint32_t)7 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(860.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(680.26 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_30_standard_DRUMS_cabasastrk, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-14) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(85) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2678 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2675 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2675 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(493.12 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_31_standard_DRUMS_maracas, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(27) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(83) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3253 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3250 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3250 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-9.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1599.37 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(17.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_32_standard_DRUMS_sambawhistle, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(36) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(91) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1686 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1673 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1673 - 1) << (32 - 11)) - (((uint32_t)1121 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-15.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(550.32 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(17.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_33_standard_DRUMS_guirodown, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-25) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(90) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2647 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2644 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2644 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-18.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(306.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_34_standard_DRUMS_guiro2, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-46) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(102) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2763 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2759 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2759 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-9.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2139.84 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(493.12 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_35_standard_DRUMS_bockclave, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(40) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(100) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1773 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1770 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1770 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-4.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(800.14 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(578.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_36_standard_DRUMS_woodblock, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-45) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(111) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1163 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1160 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1160 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-3.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(230.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(17.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_37_standard_DRUMS_quicadown, // sample
		false, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(35) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(105) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1626 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1623 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1623 - 1) << (32 - 11)) - (((uint32_t)7 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-6.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(196.03 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_38_standard_DRUMS_triangle, // sample
		true, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-42) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(89) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2068 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2064 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2064 - 1) << (32 - 12)) - (((uint32_t)336 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-21.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1749.17 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1300.59 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_39_standard_DRUMS_cabasastrk, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-14) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(95) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2678 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2675 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2675 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(800.14 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(247.13 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_40_standard_DRUMS_tamborine, // sample
		true, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(4) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(104) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3603 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3585 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3585 - 1) << (32 - 12)) - (((uint32_t)2157 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(234.07 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1429.82 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1215.60 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_41_standard_DRUMS_chcrash, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(47) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(73) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)9699 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)9695 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)9695 - 1) << (32 - 14)) - (((uint32_t)6162 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(21.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1429.82 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_42_standard_DRUMS_belltree, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(-12) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(105) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7465 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7461 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7461 - 1) << (32 - 13)) - (((uint32_t)6263 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2000.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_43_standard_DRUMS_ebongostone, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(21) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(89) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)3203 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)3200 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)3200 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-28.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(400.07 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(578.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_44_standard_DRUMS_sinetick, // sample
		false, // LOOP
		7, // LENGTH_BITS
		(1 << (32 - 7)) * WAVETABLE_CENTS_SHIFT(0) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(71) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)72 - 1) << (32 - 7), // MAX_PHASE
		((uint32_t)68 - 1) << (32 - 7), // LOOP_PHASE_END
		(((uint32_t)68 - 1) << (32 - 7)) - (((uint32_t)7 - 1) << (32 - 7)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-28.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(400.07 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(578.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_45_standard_DRUMS_mbongotone, // sample
		false, // LOOP
		12, // LENGTH_BITS
		(1 << (32 - 12)) * WAVETABLE_CENTS_SHIFT(-18) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(104) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)2723 - 1) << (32 - 12), // MAX_PHASE
		((uint32_t)2720 - 1) << (32 - 12), // LOOP_PHASE_END
		(((uint32_t)2720 - 1) << (32 - 12)) - (((uint32_t)7 - 1) << (32 - 12)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-20.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(1599.37 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(680.26 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_46_standard_DRUMS_floortombrite, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(-25) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(113) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7171 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7167 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7167 - 1) << (32 - 13)) - (((uint32_t)5236 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-16.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2948.54 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1818.19 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_47_standard_DRUMS_timpani, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(50) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(125) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7698 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7695 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7695 - 1) << (32 - 13)) - (((uint32_t)7079 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-16.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(1.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(400.07 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(1818.19 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-38.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_standard_DRUMS_filtersnap[256] = {
0x00000000,0x4c33d835,0x366cb745,0xd14f021c,0xc90e4f3a,0x30e70b31,0x13c3c971,0xa68039c6,
0xfb9e4c5f,0x02dee3f4,0x9edc4c67,0x173d397d,0xe955e629,0x1a533386,0x63f8a0e9,0x026cecab,
0x1e6adb9b,0x88445064,0x2346361a,0x0a14f0ec,0x331bc565,0x8e255248,0x3021163c,0x170cf8ff,
0xcdb9e4ce,0x503c435b,0xee92997c,0xf7f438f1,0x0bf62015,0xd08cd68a,0x67c12f1f,0xaf97d495,
0x1edb1a0f,0x310ff2df,0xeb8312b3,0xf1dabcd4,0x653d3a15,0xaa99ec77,0x1656f4e8,0xef40110d,
0x2148400f,0xcf70f99b,0x0144b67d,0x656d2d4a,0xbe0238a5,0xe5b7c420,0x1e4e0940,0x1541eb4b,
0x3c1b3bde,0xef9efbb0,0xc50fa1d1,0x207eecb4,0x6ef153ab,0xe48835cd,0xc3d5ac22,0xfedfd9c5,
0x002f2a1a,0x22a4fa9f,0x4c4d2b01,0xedbf3f01,0x9eadf741,0xc0cf9cd7,0x1655e018,0x64cd4318,
0x65f279c3,0x01150bca,0x92d09c97,0xc64aae5a,0x1d47f8ba,0x3ed7438c,0x0b89fcf7,0x0eb907ae,
0x2dbc1cf7,0x48eb383d,0xd8e807c3,0xa342eeb9,0xae9e904e,0xe81fbfe7,0x2b1a0a8b,0x518d42cb,
0x55c1575e,0x44904eab,0xdede33da,0xd7edd75b,0xc3b9e0c9,0xc34d9cb1,0xed7cd130,0x1a6b0649,
0x2f6c286f,0x2e2c30d9,0x1daf28ba,0xc928d617,0xd650d239,0x00a5ecb9,0x26ae15f0,0x394532b2,
0x3a433b4b,0x3334372a,0x2ce72fca,0xfb952710,0xcd0ccdf6,0xd820cf86,0xa600ba33,0xc4b5bbbb,
0xe625d67e,0xfd7cf36a,0x06de03a9,0x08800815,0x0a19090d,0x0f6f0c45,0x17c9135c,0x209c1c4d,
0x273b2437,0x2b6029a5,0x2d2d2c7d,0x2d492d50,0x2cc02d3a,0x27952ca7,0xef510dd7,0xe414e17c,
0xf42de9d6,0x09acffbc,0x14f8110f,0x145415f6,0x074c115b,0xdf88f4ec,0xbcedcaec,0xbfccb88d,
0xda3eccab,0xf115e72b,0xfa4df76c,0xf8d8fa6a,0xf4c7f69e,0xf3f6f3cd,0xf76ff53d,0xfd43fa34,
0x02e0002f,0x06fa0524,0x09b50880,0x0bc40acb,0x0dd00cc5,0x10130eef,0x124d1136,0x144e1358,
0x15c81517,0x16ea165f,0x0e2c14dc,0xf8fb0471,0xe5d8ee12,0xe425e223,0xf398eb41,0x01fafb67,
0x08ab0656,0x08860924,0x06760786,0x060205dc,0x083606c4,0x0c250a14,0x10240e3d,0x136e11ed,
0x15db14b9,0x17c816dd,0x19c118bf,0x1bca1abf,0x1dd81cd3,0x1f9f1ec2,0x211e206b,0x223421ba,
0x22e0229b,0x23552325,0x238c2378,0x236b238e,0x22ee2349,0x221f2296,0x20e6218b,0x1f51202d,
0x1d1e1e35,0x1ade1c15,0x186f19b8,0x15ac1721,0x12a11434,0x0f3710ff,0x0ba00d77,0x07d909d1,
0x02ca05f7,0xf4b3fcc3,0xe10deb38,0xd018d79c,0xc719ca86,0xc715c62a,0xc71bc799,0xc227c533,
0xb997be11,0xb14ab516,0xac95ae64,0xac59abe0,0xafbaadc3,0xb62bb2ba,0xbe2fba2c,0xc51dc1c9,
0xca4ec7e4,0xcf12ccb4,0xd47bd1b3,0xdae8d79e,0xe229de89,0xe999e5dd,0xf0e0ed45,0x038df47d,
0x0000038d,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_standard_DRUMS_whitenoisewave[4224] = {
0x00000000,0xd75434be,0xf4d11508,0x3d13c826,0xd05510f7,0xd705fec9,0xf9640018,0xd6990f18,
0x06670727,0x09c7d30a,0x1bbf2372,0xe171ea0d,0x09acef55,0xce5dfbe5,0x040b2967,0x21e78b75,
0x3188fb99,0x1543cc81,0x24c3ff39,0x06b3e44d,0x20570dd0,0x1e1fd3e0,0xffbd1617,0xde211e11,
0xf44605df,0xf3cdebf5,0xd4323f60,0xea0017ef,0xe3a00268,0xea2dfe1a,0xfe05f569,0x15a80858,
0xf0e6fb05,0x17ef09e3,0x409fd375,0xf6fdf0a4,0xee6d257c,0x287500a9,0xfbfce781,0x07f1142f,
0x2d74e2ae,0xf386f04d,0x11202c77,0x000c151f,0x2dbcd020,0xd22af97d,0x0ff53093,0xd04e1734,
0x0784f191,0x1aefe89e,0xe0fdf225,0x275b1987,0x03c0ee71,0xe5de1dff,0x339b07c0,0x1a07c05a,
0xe8d01003,0x70dfd48d,0xf90cca09,0x0d971863,0x1414d079,0x20ff0a27,0xf74d0c3f,0x2bba12e3,
0xed7d028c,0x1a4bf372,0xf9cd13c0,0x0c21cf1d,0xf0fd59f0,0x374ff838,0xfff0052b,0x19c7f3b1,
0xd42df9b0,0x0aa4231b,0x1c4cb61b,0xcd65f245,0x262e15c0,0xf5f0fa1d,0x3ce8e32c,0x1313b9c8,
0x07c2f964,0x26400028,0xef8cf369,0xf2183a23,0x3148efb9,0x1418e48d,0xc38e0307,0x24ec0110,
0x19ebe649,0xf6faedba,0xe7200e78,0x1885fae5,0xd68e023b,0x1310de96,0x0fb7fee0,0xf48513e7,
0x0037fff0,0xfe212ee9,0x1df8f7fe,0x2b2cde3d,0xce40e241,0xe9f61595,0xda35ed16,0x0653f3d8,
0x031cfd41,0xdf3a017b,0x0b221fc7,0x0397f009,0xf51ce52a,0xee5a22eb,0x3edb0d94,0x0eb3fdd5,
0xf0190b3f,0x2677ea94,0x0ff5e278,0xd958097c,0x06c7059f,0x00b0dc89,0xb36d26fb,0xf5b55a37,
0x1b86da02,0xf235e19a,0x029f2a08,0x01efd305,0xf4f5324b,0xfc790073,0x2237feee,0x1424e215,
0xff1502c1,0xd12d048d,0x0ab4160c,0xfe01d9d5,0x0a64029c,0xf15af6a8,0x38c01ad8,0x161cccda,
0xf721f934,0xf999010b,0x1cf0f565,0xee01f889,0xeac42ca0,0x5983db84,0xe50dd710,0x03530c70,
0x03e00787,0xe8b11310,0xf1b1d3d9,0xe7aaed86,0xe761fb51,0x358dfe05,0x0f5cf386,0x19f4fd74,
0x1d54e7dd,0xd5a1e29c,0x1e11e706,0x0e8be1fc,0xfcc42f37,0x02441748,0xf5b92ddf,0xd0d20293,
0x0d131feb,0x1dbbf676,0xfca61a34,0x1ab8eb7e,0x13fb1f20,0x2db4f4f8,0xf56c1265,0xe909e665,
0x1e331090,0x0dc4d99c,0xc5642650,0x01541abb,0xfb411887,0xfc39e804,0xe3220cfc,0x050b24af,
0x0c70f31d,0x0d4cf969,0x1226ec9e,0xdd32fa84,0x033c2823,0xfa54fc10,0xe8d5fdea,0xe7a4113f,
0xdf57f559,0x25a32f87,0xe71408d5,0xf7ea2223,0x0abbed20,0x2a28e774,0xdf61fed9,0xe5b12d02,
0xf7ecbf64,0xfd113362,0x4e6ee186,0x0bdc2c8e,0xe8d0f615,0xfc690d0b,0xedbdf8c9,0x04b418ac,
0xfec5191c,0xfd110c8c,0xe4fce915,0xc1024d73,0x2617e62b,0x04a80134,0xec252a44,0xdf6e260b,
0x466a008c,0x0037d305,0x0bb329db,0x1339d99c,0x173defdd,0x14ffee2a,0xf9c9f5c9,0x19e0dd40,
0xffc4e285,0xf3801350,0x15ec292e,0x1d78fce6,0x15bc005c,0xe0a6d9ae,0xf9f94440,0xe2f21a6d,
0xcf8129ab,0xdfd22bd7,0x1eaf2e18,0x0dd0e1ad,0xd97e3b30,0xd66a25d7,0x42dff795,0x09a023cf,
0xd7490e14,0x0908b229,0x33140679,0x255af798,0xfb3cd911,0x30dcd991,0x2947de7d,0x1fddf994,
0x2317e7a4,0xe51d02fc,0xf6422672,0x0274fe8e,0x155527b5,0xf4ec2823,0x16b42bc0,0xd75dddf8,
0x01e841a4,0x0e91c762,0x205b242b,0x00ccfd51,0x031315a3,0x0cf7e935,0x1ed3e271,0x059ff50c,
0x1ebfd8bd,0xe7c1e85a,0xf8592f44,0x1cb40160,0x09f7eee8,0xf889ff94,0xe3351690,0x0fe708c3,
0xf65d0ab7,0x13271fe0,0xb361194c,0xf9692354,0x02783ec2,0xf956100c,0x1070e8e1,0xe83dedad,
0x0960e87e,0xe6ddfa1a,0xe72d0ef5,0xff2c1044,0x2863100c,0x2e4ff416,0x2708dbc8,0xe86ecf06,
0x1b480d13,0x0e3fd476,0x09180c65,0xef60ec99,0xdaf2d4ad,0xdc2e2850,0x1aef09e7,0x25c0d7e1,
0xf49e1428,0xc4c03ea7,0xe27e1620,0x31a7f138,0xfcd8da1c,0x0067173d,0xe1fa073b,0x32c7e08d,
0xe6f60aeb,0xe3fdb415,0x0447ebe1,0x1aeb07df,0x112407b7,0xe96e0201,0xff690edc,0x06bcd2ee,
0xf6f41c03,0xfb11f8d5,0xee112307,0xf2301205,0x0591078d,0x03a92b28,0xbc19fb7c,0xd1b152c8,
0xfc4915ac,0xd1a6113b,0xfe050de8,0x2b9301b4,0x0c21f6b6,0xe4c43054,0xcd111af8,0x2d5bea19,
0x13b0fe75,0xc769e939,0x1c80ffb6,0x29d8d359,0xee65e0d9,0x09ece9d0,0xeb1d11df,0xf4e528f4,
0x0c3cfc9d,0xe3dd0aa7,0xd5c128fc,0xe945fff0,0xef950dd4,0x121f226c,0x1343fc90,0xe1b40a60,
0x06351c9e,0xf882fd24,0x0f65f53c,0x4aced7e9,0x41c4ca39,0xe128f855,0xdddd1a54,0x3607dfe5,
0xd454dfc5,0xd0a50fd3,0x1b280cb7,0xf2851c67,0xf949080f,0xebb1f660,0xd4590ffa,0xd50de751,
0x03ab4bef,0x1a64cfba,0x0f9005d8,0xfd611174,0xd58127cf,0x00d7d628,0x06f7d7bd,0xf5e212bc,
0x0d770637,0xeaadf87c,0x217fe3f9,0x1973e909,0x140deae6,0xf47d16a7,0x19200097,0xe8183bf0,
0x3f3ffdb5,0xf5c9fa21,0xb81c32c7,0x25f01494,0xd945135b,0x0828fe80,0xeda2ece2,0x15561734,
0x0b0ff9bd,0x0b7b1e4f,0x0043f0b6,0x2d68eb14,0xf9cd01af,0x19f7d2b5,0x211fe888,0xe9f9d9be,
0xf5652a6f,0x3938f8ac,0x03a3f879,0xeea50bd8,0x181125f4,0x179fe52a,0xfaa8fd81,0xd31e1565,
0xdd65594f,0xe9094834,0xeede0464,0xc31d07bd,0x30a4b771,0xff50010b,0xe764fce9,0x31061c29,
0x26e4f1b5,0xe11ddf15,0x1a840b5b,0x0ba8ccba,0x187c0224,0x0b68d389,0xeac117ff,0x08f8faac,
0x304b188c,0xf0120083,0x169412d9,0x0a94dc1e,0xcf365764,0xe0250a3b,0xf70805ec,0x302bdad0,
0xc5d813fb,0xf619339b,0x1dd21ae1,0x1bdcf8f9,0xf074002c,0xfc40f855,0x1d24f646,0x47d4e295,
0x0fe3d04e,0xd08ef565,0x190cf118,0x14a81482,0xf5ac2040,0xeb81e49d,0x19ddcacd,0xdf7e14d8,
0x0918db51,0xf17d0a90,0xe2852057,0xe69e2c27,0x0e28e248,0xcb70ff09,0x0f4f04b4,0x11743074,
0x083bce76,0x03a9ff25,0xf2dc0137,0x1d580dc4,0xf920da89,0xf235f41d,0x2c2cf116,0x1033d6be,
0xfe50081b,0xda62048d,0x12a3f9c9,0xebb10013,0x11bfd9f9,0x061311b8,0x1a20f3ad,0xed81170d,
0xf2c9fc15,0xef691fb4,0x08a8f7d1,0x10700fe7,0xf4ce0238,0xd1620119,0xeb24118f,0xfb8ef535,
0xe4daefbc,0xfeee3008,0x0801f798,0xf70dfcfd,0xfc09e9d6,0x1c941144,0x34ecd665,0xd54d211b,
0x09430c65,0xf7c50680,0x1fc01448,0x119fd4f4,0x0343f5e9,0xd40dfc45,0xfac8394f,0xf02924bc,
0x074de89a,0xf438119b,0x139bef72,0xf751feee,0x1ff70bcf,0xec3efcf9,0x0fd01504,0x3ef0bd25,
0x2f24edc1,0x27afc8cd,0x0ddf04d0,0xef250c57,0xf0b1037a,0x090503d9,0x06b30ac4,0x2124f84a,
0xd965f08d,0x2cd0166c,0xef7ceba5,0xe8d5fe99,0xdf6af882,0xf61213c4,0x0d50e730,0xea2633d4,
0xf79de8f9,0xf5790dd0,0xfc09f4ce,0x0522f23e,0x034c208f,0xf24cfdac,0x0000e082,0xf8f9150c,
0x2573c1e6,0xf00de3f6,0xef521b78,0xef5cfa4b,0x103bfecc,0xfe4cd454,0xf67008df,0x22ac08a8,
0x0754ec3e,0x0a3bfc2d,0x0928f4b5,0xe17afd1b,0x16f038a4,0x25891b1c,0xf4ece36e,0xdaf63106,
0x180ce5d1,0x0979e744,0x15ac3267,0xea860d5b,0xe67047fe,0x07270690,0x12fa0794,0x10d0e8d5,
0xfd9dfb85,0xe7740fec,0x07770965,0x488fe622,0x0b22c046,0x372cc4a2,0x0f7318b3,0xc6f5ddfd,
0x39c3f0fd,0x11b1d3e5,0x08dc33cf,0x0883f4d1,0xdfbcd318,0xe325f394,0xfa4a1a8b,0x33bcf7f1,
0xed165faf,0x116119fe,0xfc491ee7,0xf9f10330,0xf191e2ec,0xea42f334,0xf63420b8,0x321eeb2c,
0x11f5d719,0xe46d351e,0xe9d9023b,0x10a009e0,0x0ad0f70d,0xdfdeff34,0x035cf9b9,0x1ce4ffa9,
0x2583e412,0xca4a1aeb,0xf50c0874,0x1cac094c,0xf9c9f501,0x1f5ac68a,0xd4960e21,0x2237f934,
0x1900e912,0x26bf1a8f,0xf454005c,0x3833d21a,0x0aa7ea42,0xf36d1868,0xf2180040,0x07f2e9b5,
0xf8b906e0,0xf8b51454,0x0fe011b3,0x1468f5f0,0xe5c1ec9e,0xee0427f3,0xf08012f0,0x3b7008bc,
0xdf45fe58,0xe0c936c1,0x0184ca21,0xe4b8120f,0x1b13dddd,0x03a0157f,0xee01eb75,0x0d741310,
0xf612d50a,0x1933f5a5,0xd84defed,0x2d141afb,0xd680197c,0x265e019b,0xe51dc129,0x09b72f27,
0xd492fab1,0x1687f970,0x02cff9a6,0xe01512d3,0x0cd92577,0xedadf890,0x0efc0444,0xe53e092f,
0x08831c90,0xd1b1318c,0xef8c28aa,0x1da2ff10,0x27e5ffd0,0xcfe5ec75,0xe37d28bb,0x2f37e6f0,
0xf84ccf8a,0x15caf4ec,0x17fffcb0,0xdde9fc9d,0x029cff86,0x4038e76d,0xeea5d83a,0xfb211cb7,
0xdfe9fdea,0x51e2fe9c,0x0740f6a8,0xe8c1fa4a,0x97742523,0x199e147b,0xe80af394,0x0bfc1c90,
0x110dc4d2,0xf9560360,0x0c0f1094,0x07e822f4,0xf585d184,0x2b3c1633,0xeed8ca82,0x391b1374,
0xd91ede4d,0xf215f60d,0x0a47026f,0xc25dee61,0x2111ff3d,0x0640ff19,0x1205f7f1,0xf491218f,
0xc28af330,0x13e40e28,0xf69dfc99,0x226715c3,0x129013de,0x20b8e865,0xee85dee8,0xf96d31b3,
0x0637f1bc,0x1218d675,0x1bf3efdd,0x0f08bcb4,0x0ca3056f,0x121cd6e5,0xd9b00a64,0x140f127f,
0x161c06c0,0x10d4f319,0xdccc2b5c,0x00a90630,0xfbf91720,0xec5c323b,0xdeed2b45,0x0d6b0558,
0xd46d0b01,0x2067cefd,0xf101e47a,0xe13d33ff,0x3a5cf8d9,0x29870640,0x11dfe211,0xe6c0c6ee,
0x0b582607,0x0107018d,0x2fdff69d,0xdc3ef910,0x3106ce39,0xe6391377,0xe0d9381e,0x19a7e278,
0xe8f10648,0xc065326b,0xf7242670,0x0063dc91,0x06e0303f,0xea00e855,0x193c2830,0xede12c47,
0x25701627,0x301fe38d,0x012d08df,0x2917ba5e,0x22cec935,0xfb4ceae6,0x0ef6ee78,0x11340957,
0x17abf1d1,0xe7ed0350,0x32a40bc8,0x44de02f3,0xf85e0f9c,0xc2f43870,0xc67e5268,0xf84cfdea,
0xfe05e2de,0xea641407,0x1f5ad8f8,0xe3e219ad,0x28bbf1de,0xf8d50af8,0x17c8eae1,0x26b0d3fc,
0xe669ecac,0x06c7257c,0xf3add176,0x1d07d5ee,0x295ee66e,0xf3c4f8fc,0x0a200a44,0xe53effa6,
0xe0992d14,0x0f18e515,0xf6fa35f7,0x12bcd705,0xe2110bc8,0xc479633a,0x1754dc48,0xe6790187,
0xdef82042,0x3c3ffb75,0xe788c59a,0x044d02c3,0x205f0127,0x1d44c45e,0x09e7f2e9,0x1a98f481,
0xfd2ae949,0xec6520f4,0x0c1307ab,0xfe1519e4,0xf255eeba,0xe8fcfddc,0x0ce7d87a,0x16ff08b8,
0x04ed14f6,0xfa6d1aa8,0xd6110d13,0x171b1384,0x2927f9e9,0xf2a20eff,0x08582bb3,0xfe11085b,
0xfa0dbb3c,0x1ac8f62d,0xf302baf9,0xfb1505df,0x3cdf0187,0x57f4e78d,0xf79ded09,0x0f352a7f,
0xeec5e5c5,0xe2bcf699,0x0a27fb1a,0x0598f069,0xdc4eefe5,0xfaac1fbb,0xfe3cdcc5,0x245cdd22,
0xe5c507bd,0xd1bd2ad6,0x23473cdb,0x04070ef6,0x0340de4a,0xfad5ff3d,0x057cf776,0xd0e020a2,
0x2ad61eaf,0x299baa51,0x3de0d6a2,0x1999f704,0xff29c172,0xf8f03234,0xcd55f8e9,0x1a202ab8,
0xfca7cdc2,0x10aef3e1,0xc4990dfb,0xf6903533,0xd5611c03,0xe7daff09,0xf94df59c,0x0db7031c,
0xf16d1044,0xfe9cfeb9,0x1208f259,0x0d17fd08,0x1aeb2697,0x0f7cf579,0xdc5515ca,0x347fc172,
0xff69060f,0xf81af208,0xf0a2ec69,0x036cf3ad,0xfed5d6be,0x25280154,0xf2ed24ef,0x197c0c73,
0xc9a1df0a,0xf986fdfe,0xfcade881,0xe05d20c8,0xf178317a,0x08a8f9b9,0xf0991b2c,0x28450370,
0x2bf0cec2,0x4386d692,0x3fb2d6f9,0x0365c668,0x00ee3e7c,0x142006f4,0xfe50f1c1,0x0127c4d9,
0xeec13dc7,0xede1fb75,0x01edf8f9,0xf03924b5,0x03e91fd7,0x0e96c341,0xe7f4ff6d,0x20400a14,
0xf4ce0683,0x0107e022,0x177bfa41,0xeff52304,0x0000025c,0x0d39ff09,0x207bede8,0x0d840c05,
0xee04eb2c,0xf73453c0,0x1973f5b5,0x0ab7f141,0x0100d1c9,0xff020f95,0xf030e955,0x26e410f0,
0xd1ea0b51,0x042d15c8,0x09531d6d,0x2260f6b9,0x0b58de36,0x0bc41f83,0x0a97e7b1,0x084f3062,
0xe43613b7,0x1ecfe4fc,0x0d1306d9,0x00c00b78,0x04170db7,0x0b0bdc51,0xff4506b7,0xefb5be4c,
0xc6710204,0x17fc1d7b,0x05a8ffad,0x2e1ff369,0x2deaeadd,0xf8dc0ad8,0x03970704,0xfb35fbee,
0xc9d50921,0x2828288a,0xe56edeb1,0x371c342f,0x03fc015d,0xf831febe,0x08610ffa,0xf2dccd31,
0x0157099c,0xfd7407ed,0x0dd713c9,0xfbac10ad,0x00a0e0c6,0xfd54d699,0x093822b3,0xfdeaf77d,
0xf41d1960,0xefbc0130,0xfcd83038,0xdc480dd7,0xea2913d7,0x3362c204,0x12b7d921,0x033c1f83,
0x1f8314b3,0x1b2f1394,0xfed5dea1,0xf9a6126f,0xe915f78d,0x1468e258,0xfca7fecc,0xfd3d2ee9,
0xe972fc64,0xbe090307,0x00d4f9b9,0xe40d1da2,0x000cf92d,0x0c9cfa2a,0xb6dc1161,0x167016a4,
0x1da2d105,0xf656e215,0x0390f7a1,0x0f7c2863,0x1b081030,0x21cff046,0xfe35f1f1,0xf0640484,
0x1a041578,0xc55d074d,0x16800f1f,0xacddfed2,0xed864110,0x07a00474,0x0b0ff221,0xf7fe211b,
0xf1bcdff2,0x1f30e32c,0xb395f6a6,0x2e28fe68,0xd35511a8,0xd01a2207,0xcd7542af,0x1181ce99,
0xe5c521fc,0x217128c0,0x0628088c,0xf525f67d,0xe96e198b,0x04a02c67,0xfeb90821,0x0c9c209f,
0xeaf11fbb,0x1609d9b9,0xdc48ea56,0x02ff03bc,0xe7ca1acb,0xe7202141,0x1e5cefcd,0xfb69f9ad,
0x3c78da66,0xfdf5cdb0,0xf5bc053f,0xedcaee21,0xf0561303,0xf02017d8,0xed94d811,0xd305f249,
0x1010ee24,0xe8b11b3c,0xf6771f90,0xc0d50f38,0xffc02b73,0x37fce04c,0xf165fba5,0xdeb121e5,
0x36ab09a9,0xfcb6c542,0x13540389,0xdb74e86e,0xf471041e,0x0db4f2f9,0xda92074e,0x1d1b1f83,
0x000cda76,0x4d5713ad,0xfb28e609,0x222843e7,0x0bfce9ed,0xe0b2f421,0x206705c8,0x1b86e26a,
0xd3612627,0xfcc4120f,0x09e3ffe4,0x08830318,0xe7560ab7,0x22a707ab,0x01c4f919,0x0689206d,
0x0f08b9ec,0x0a101fa3,0x1c030ed4,0xdb280383,0x111804d4,0x2bf09f89,0x4147ebfe,0x38abf7ec,
0x15a8e9d6,0xf68df977,0xfc800231,0xe682fa38,0xf549fdf8,0xd59d148f,0xfba2294b,0xd04eda92,
0xef2e33bc,0x0948fc70,0x214c0a00,0xd84419b7,0xf865255a,0xeaa4e4ed,0x284ce2e5,0x2304f334,
0x069006a3,0xfff00023,0xf03d1387,0x37c0e3b4,0x3458b14c,0xfe41da9d,0x0a34116f,0x08280730,
0xf0fd2828,0xe235d6b0,0xe1a13d86,0xeb3a111b,0x0a47f431,0xdb3a303b,0x13a0faa1,0xd90a0359,
0xf4de19e4,0xdb7afd98,0x388ce359,0x14b8cd31,0xe8ca1c1c,0x03d311e8,0xd23df134,0x2f87c894,
0x123cf910,0xfde1fe05,0x2877f838,0xcabeee5c,0x2c30f69d,0xee9e1efa,0x0018ecb9,0xf7ecf805,
0xe2782b7a,0x1ccefbac,0xf4e11e11,0xeb552875,0x1e8ceef5,0xe7940d10,0x1f0ce8c5,0xf572037a,
0xe50dfc59,0x10dd0fb3,0x2974ce4f,0x0c7cfbe9,0xe27817d4,0x05f3d97e,0xf22121c3,0x314f024f,
0x116806a0,0x09701943,0xcec201ed,0x21d70c35,0xf925c3fe,0xe649087b,0xcf9812ac,0xfff4e3fd,
0x07f22a2f,0x100ce5e9,0x00e92020,0xfc2d0278,0xf6641eb5,0xe8cae04c,0xf73df879,0xe389fc49,
0x3297fc55,0x2260977d,0xf3d8d90a,0x0059dac6,0xbc4b0b58,0xf72d1eaf,0x1b85f71a,0xe4cced34,
0xf5302a08,0xf34227a6,0x14542eb3,0xf5f0da05,0xd41e16bb,0x1c803219,0x31180204,0x07c824c8,
0xfc2def45,0xd166fabd,0x1fa3e188,0x25f7bf44,0xfd64da96,0x36b8d345,0x1198ddf0,0x2e28e3c9,
0x0060f7ea,0xfafe0c70,0x1dbb0350,0xe9f6dd19,0xe7144598,0x1f90fe28,0xc4a91c33,0x0b7b0adf,
0x0e31c698,0xe909fe75,0xf1413763,0xd2c815b3,0xf2f50f95,0x1c47e891,0x0dd4fb69,0xd44e0b04,
0x2adfea26,0xe52ac661,0x116f017b,0x0d0b08c3,0xf3edda1c,0x112008d8,0x2c4ba5b5,0xd9410a70,
0x0b2b0883,0x12a30244,0xe399fc34,0x022bf171,0x0ed4de5d,0x1b931131,0x1707e2ec,0xf4852ddf,
0xfbe9e44d,0xc98136ff,0x00cc0053,0x4427f121,0x08acf185,0xe7edf8ec,0xdd35bc21,0x03700edc,
0x064c2c8d,0x16f4ef0e,0x1e5c2289,0xf2a2eb6a,0x209bf441,0x02cce225,0x08b304ed,0xf15a1af8,
0x04042dff,0x0501e319,0x0943157c,0xd6113300,0x03300db4,0x02d8e3ed,0xd8f805a8,0x04fbf9a8,
0x30bfd6c5,0xe831eff9,0x15e0fc62,0x0b6418ac,0xfa51e339,0x314ae9d6,0xf825f5c9,0x11640908,
0x2547fa4a,0xf4a8d566,0xed002e2f,0x01140487,0x101ceb41,0x1788f96d,0x08af1120,0xee0d0c7c,
0xfb81faf1,0xe80af468,0x0ff7ff29,0x0198e045,0xe8de3433,0x0d6be395,0x0d94f582,0x180806ec,
0x1e3cf08d,0x0878f9a8,0xee4db570,0x376cd7c6,0x1a3fdcec,0x357be942,0x11ab00db,0x01d112f5,
0x0b34fc59,0xf31dfe38,0xf2821784,0xff4924b8,0x17dbea0d,0xee65ebfe,0xe0d60134,0x11df0c9c,
0xf3a2f990,0xf5952934,0x1f30042d,0x11d8e3f9,0xdbd10390,0x0f6c1774,0x1d2b2c19,0x1cf7e972,
0x207bfb4c,0xec2cf7dc,0xdd09b115,0xf7d113eb,0xf7211c7c,0x1578ed91,0xf801146f,0xd025febe,
0x08e3da22,0xc5ca09c0,0xdeed4018,0x214c05cf,0x0d3416e0,0x06530b21,0xefb20c18,0x0d74be69,
0xe02c204b,0x08b8fdc5,0x3a87e0bd,0xc54210f7,0x2537fc34,0xd06ce23e,0x089f0dfb,0x3190d735,
0xf6f1dfec,0xf3ead71e,0xfb2e148b,0xfadcb9dc,0x0eec0204,0x0e8bdf3e,0xe2251f37,0xf7012be0,
0xd96108f1,0xceb12c84,0x3106f515,0xea561478,0xfed2f734,0xe4d1f046,0x274b2d84,0x1482e619,
0xecb2238b,0xf9092e70,0x15d004f4,0xf00dd948,0xf329fe05,0x0343f859,0x0d300c60,0x0e51ecb9,
0xfa4aed19,0xede1fb69,0x43a8d46d,0xf81cf4d5,0xd948fec9,0xe4daffb9,0x124f040b,0xd005effd,
0xfc7d0d90,0x0858fdf5,0x1d84e461,0xedfd0868,0xd3b01508,0x34d3ee2a,0xdbe5f8b2,0xe26e07af,
0xf70d0397,0x37dacaf0,0xfa84f3bd,0x133926cb,0xea00d21d,0x17e3e585,0xca69e395,0xf7511f30,
0xe48df946,0xf0b10b31,0x0a39ef1c,0x186cec59,0x2b77e6c9,0xe9ed04c0,0xefbce158,0x12c9ffdd,
0x1a34e3a6,0x10d0f6f4,0x203df108,0xcf68e821,0x2fc41b63,0xec7cb914,0x241b0f95,0xf056f438,
0x05e8c5c4,0xe0a9f8c0,0xf7d83b3a,0x3523c482,0xf51c1a50,0xfc39007a,0x07ed06c3,0x334bef69,
0x09fcff76,0xff3df042,0xee950224,0xe4660318,0x129c181c,0x12b0dd02,0x062ce2a1,0x2270f677,
0x077e03d0,0xc8d60a3b,0x1d94dc1e,0xe515090f,0xe7cd17ef,0x38900231,0xfd1b11d8,0x27f3e55c,
0xdc6a12bc,0xf5d92837,0xe54ed1a6,0xf8a500d4,0x0c3f0f0f,0xe3ad2fdf,0xe9c91a2b,0x0f570c21,
0xee34ffa0,0xddcddd09,0xf0460f87,0xebb11c63,0xf81af079,0xc62138d4,0x1c53cf41,0x17ef1920,
0xeada277c,0xf8990f2f,0x2f03f869,0xe6d01826,0xfcd8054f,0x1f67f029,0xf36d2d24,0xef992788,
0x18252454,0xfbbe0089,0xf6c92a88,0x0fbc36d6,0xdf5800e4,0x101cc59d,0xf67df2cc,0xffa9e8b1,
0xecddf63d,0x1d341e2c,0x1598d7c9,0xdeb10b83,0xfe2e07db,0xf178d9c2,0xfabaf7a8,0x19090a60,
0xfef0cde0,0xd824069c,0x25202320,0x1f9cd6f5,0x156cf940,0x2b93ff0c,0xe439cb2d,0x22f4113b,
0x1a8be436,0xfa81e2de,0x008015d3,0xfae5e144,0x07f8279c,0xe21e093c,0x1d8801a4,0xeee5d9d2,
0x37d31750,0x06cc0b48,0xe82cf551,0xc109f8cc,0xed16144b,0xe700f05d,0xdf1e22cc,0xea6017cb,
0x279fedd4,0xf8a5fb4c,0x410af694,0x1273e2e9,0x022bfb45,0x1ba8d9a9,0xed99db71,0xf4b50891,
0x05e81999,0xe6591c9c,0xdd19f9bd,0x18dc1b5f,0x0c9cee98,0xde263b67,0xf8ace5a1,0xdffc0f23,
0x153cfcb9,0x01afde1d,0x00c71fe0,0xf091f3fa,0xf8ac1094,0xea6d11c4,0x3d530db4,0x3f9bc115,
0x1a6fc4ee,0xdc45ef8c,0xc6c8e739,0x1dab1b8f,0xfc45d6d2,0xf3b928a0,0x4a83fd3d,0xf734e86e,
0xe16a19a7,0xd0c2392b,0x306bd0c9,0x1c9e0643,0xda5dee11,0xf1f8221c,0xe6a50380,0x28a3cda2,
0x0f43c965,0x307fe24e,0xfb31f6d8,0xe0450f8c,0x2910e19d,0xf285c665,0x21582890,0x0d44fed5,
0x28dbee65,0xbf7ae151,0xd73d2ac8,0xef150e1b,0xf3a8fc94,0x01870d6b,0xd54136a8,0xed090a9b,
0xe3a0079b,0xf6690434,0x2d241a48,0xe60e1bfa,0xff55052b,0x1c60ea50,0x0cd9dfec,0xfaac07f1,
0x1c9edc71,0x0b4bff62,0x2abf001c,0x0fa9cf2a,0xd615e29c,0xd6b50e91,0x45940818,0x05c3f71a,
0xc7724713,0xc5641c17,0xfe28ca05,0xc8f14120,0xf5c9d7bd,0xd5f108ac,0x0ab73618,0x2af80a7e,
0x03fc2914,0xd69cf7c1,0xc0a80a90,0x2d0bef8c,0x1be70a24,0x13a4eded,0x2072e7fa,0x43faed09,
0x1e48de4a,0x0f05f84a,0x047fdea1,0xef520cf0,0xe5cc0c35,0xf85109ac,0xe6591a5b,0x05af0c5c,
0x09e7dc89,0xf034194c,0xe302127f,0x10dff01d,0xf45401f4,0xdc110d40,0x14bbd34e,0x1973e188,
0xfc8916bb,0x0daef8e9,0x3560b678,0xf249fed2,0x29a7e3f6,0x2dc81690,0x2627e48d,0xf6dd1482,
0x0e0805e3,0xd39cd1dd,0xdf1e3eac,0xe7cd1313,0x0828f27c,0xe3e405af,0x152c1f07,0x1148068c,
0x09b00f80,0xf06d146b,0x05c3f3b1,0x1650fab5,0xc77bf828,0x0653c9ce,0xe1a41b18,0x18980838,
0x33a6dae9,0x3b92f195,0xee1d0d87,0xf2ed20e8,0x2670e531,0xfce9f694,0xfcc919cb,0xf8251788,
0xf9400ab7,0xdd700170,0xd469311a,0xfe2524c3,0xfc1cef00,0xdf6508f1,0xdc181764,0xddc9f32d,
0x30dfef99,0x1940f7a8,0xeec8ec8c,0x39070f5c,0x3d9fdfb5,0xd206e935,0x174b0b2b,0x158cdb19,
0x392be221,0xf0862498,0xfbf914e1,0xfd38072d,0x1fa7ea2d,0x0dc7d4e9,0xf2cc0744,0xf84a13b7,
0x275bf78d,0x1fb0d841,0xdde4ebb8,0xd4094668,0x393fdf0e,0xe1f1fdac,0x07bdee38,0x0734e75d,
0xd86dfa94,0x0c97f2c5,0x3530e035,0x2970ae25,0x1fb70e14,0x17efe02c,0x0d17dfd2,0x0e880558,
0xe86a2d6b,0xeb1d197c,0xf9c4ff5d,0xf64dfdcd,0xeca9123c,0xf902153c,0x1b48eb8c,0x03a912ec,
0xf85eef55,0xe9252347,0x189ff677,0x10dfdfe5,0xf5820ad0,0x0fe308f8,0x1b7809c7,0xe744ed16,
0xf7f5131c,0x2171e109,0xfce6fdd5,0x11cc16e7,0xde19fdcd,0xd241f454,0xeab62304,0x3b00f0cd,
0xe66ef582,0xea142f44,0x17fcf8dc,0xfe89ee41,0xdcb5eae1,0x11ffe8e1,0xd36127c3,0x38fbf285,
0xff29f3fa,0x17e302b3,0x01edf508,0x14bff9c0,0x2553c840,0x1d0df650,0xd10d0950,0xf4c5fd44,
0x2feff7ec,0x1054ccb1,0xedca0e8b,0xd93a15ca,0x0f2fd6a9,0xcf44da05,0xa926205f,0xaa043a8c,
0xfdd8f37d,0x25a702b8,0xf33002f8,0xe1ede985,0xf16d27f8,0x1d3de451,0x1a5406b7,0x3cf30670,
0xf5dcf376,0xf1813d48,0x155f0b08,0x12ece3c6,0x22cce4ca,0xfb4ceef5,0x1f8b09a9,0xe14d0990,
0x24682fa7,0xfe21f694,0xc0e224ac,0xb5ad3f22,0x03ab2314,0xf96d0a09,0xedcd0da0,0xf3dd2042,
0xd50df551,0x030cd884,0x085803c0,0x17cfd011,0x27a30254,0xe16a1db4,0xed491e13,0xe4612124,
0x3463d651,0x153fc729,0xd81132bd,0xf90c0528,0xf52802b3,0xf1ae0588,0x1ab10acb,0x187c314a,
0x0578f808,0x07c8ed60,0xfc2d121f,0xf4c123bf,0x08b3235f,0x0c60fd31,0x13100323,0x1633e9b5,
0x056cfa81,0xe929c0f5,0x1428fd16,0x2a74f1ae,0x23bbe069,0xeef8266b,0xef2e10d7,0xf4951e68,
0x0608fe1a,0xf7d8f4e1,0x05c3da05,0xe0b91ae3,0x083f1e1f,0x14ff01b8,0xd085139b,0x01f42e70,
0xe7f40650,0xfd5dd8bd,0xe6223044,0x03c33048,0x28e9f3a2,0x0110fc0c,0xe2a80177,0x2807df45,
0x0be8d871,0xf0991257,0xf4fe20db,0xfad5f895,0xfc4d1778,0xfbac083f,0xf2411a9d,0x1bbcdbe5,
0xeb141fac,0xc3550d7e,0xd44914b3,0xf69dd591,0x1ff0ec45,0x001c2357,0xe895fa1d,0x0a24fdcd,
0x12a3124f,0x150c1fb7,0x308fec72,0xf3c9f560,0x1360dc2e,0x2b90c1ad,0xce0df646,0xc68e1a17,
0x09b3f6ed,0x1188d799,0x1eec0c05,0xfe6c02bc,0xf50132ab,0x10f416d7,0x1508ca85,0x4608c0a7,
0x1e58ca8e,0xfbc0ef2e,0xe14137c7,0xeccee13d,0x1e8c0407,0x29ebd925,0xe94502ac,0x0bb8f2a3,
0xdc9a2210,0x42f6d446,0xf5dcf364,0xe53a3358,0x3bd0f85e,0x2141c01f,0xebc8ff59,0x05dc2263,
0x2cd0ef6e,0xdd92f5ec,0x3a66dffc,0x2647ecf6,0x26f8f565,0x0460e4d4,0x350af1f1,0xd00a0400,
0xfdd51a3f,0x17ebee1d,0xf639f5f0,0xe07d1d1b,0x16a0bf28,0xd65e2559,0x11cc0abb,0xdcc521f3,
0x2589ecf9,0x0d03e62c,0xf3e6e082,0x05011a44,0xfd44fc59,0x1835d5e8,0xe19123b4,0x1208de4d,
0xdeb82ef0,0x2370d596,0x08f8ed79,0x18ecfac5,0xd9f504af,0x19cbf99d,0x0487fcb9,0xe62b07e8,
0x0e810eef,0xfc8025db,0x0a1cfb65,0xcb94c2cd,0x2feb0ab7,0xf97deb9f,0x0cf0146f,0x033c1481,
0xfe581a7b,0x1a7bef55,0xebc8f85e,0x2ec0d66a,0xd4cd04cb,0xe7140f5f,0xd72427d6,0x20500447,
0x28a70a39,0x1b1ff091,0x26a0fb55,0xe049eaa1,0xfce6e3b4,0xf1f50023,0xe4dd015d,0xfc700ac4,
0xe8f50fec,0x0035e8e5,0x4133e679,0x24e5db3d,0x1bec2007,0xde840dc4,0xe555f88e,0x1da2f154,
0xecbddc51,0x22e0146f,0x1fb0f551,0x117811bf,0xfd440e2b,0x2a16d4fd,0x208f030c,0x480ef18a,
0xd7c2e360,0x06730140,0x1987fbe5,0xf4b528fc,0x1e8602c8,0xf575e8d9,0xec720f4f,0xfc64d8e1,
0xdfc51ecc,0xfee0cc41,0x253018e0,0x0170187c,0x14540cc5,0x0365ec25,0xf40ded5d,0x2dcf069c,
0x2b8cd679,0xf41de9d9,0x059ff6e1,0xddf6d759,0x1843f990,0x008308cf,0xfc69ef7c,0x08581c9e,
0xdf410980,0xb0182e1f,0x16b41a98,0xf4a8c532,0xba713ad3,0xdafd2828,0xe8e5346c,0xef9925c7,
0x12c5cfb5,0x14e8dcbc,0x32cb02f8,0xeca20b1b,0xf66936b8,0x0a2cf560,0xf1c8f491,0x1f700ecc,
0x02ace441,0x030cebec,0x0e9f0380,0x02a52870,0x1c57f8d5,0x0918cf5a,0xb3e53354,0xea342080,
0xf9c9f919,0xc6e53c04,0x075d1248,0x1313fca0,0xe84ef805,0x1c0c1a2f,0xedf1f8ec,0xfeb5e4b8,
0x0f5c2098,0x1e43f6dd,0xf88ec65a,0xcf680ef6,0x2a682a9f,0xff20e61c,0x0d0bfda8,0x00071ba3,
0x1669fe15,0xfdcdd5aa,0xbeb43718,0xe66932a7,0x0e910a7d,0x2d93e982,0x0ad003c3,0xc0ea40a8,
0x1d6d0e88,0xf3b9073b,0xda8dfe01,0xf060faea,0x2380d47f,0x158cd2a5,0xf9690544,0x1e73fb31,
0x40a3a225,0x0d7eeac1,0xfbf0fd84,0x1da8f069,0xf3c1ea94,0xe86e1fdd,0x0c23e76d,0x0ff0efd9,
0xf5f01f13,0xe7740de8,0x037a154c,0xfd0815b0,0xdcd226db,0xffade251,0x06fcfc6d,0xed091369,
0x0e6b04a0,0xdb4d0757,0x4d5af304,0xcc2a2741,0x2bc3fed2,0x104cd3b0,0x050ff785,0xeed80119,
0xfc62d099,0xeda90f4f,0xee68fc2d,0xe291f5b9,0xc7a529a7,0xba7c1017,0xf6b6175b,0xe1741b78,
0xece2272f,0x1e032042,0xf7eaff29,0xfb6102d5,0x0690311a,0x00d0dc18,0x068c2b33,0x17140093,
0x3203c50d,0x191cfdea,0xf3e6e990,0xd28df091,0xfe8910df,0x04700cfc,0xef49f4d5,0xfafef418,
0x2847fb4c,0xffc9da84,0x2a2b1039,0xff490df0,0xe8150335,0xf9690f13,0xeb04149b,0xfd94e419,
0xedfd06d3,0x08081d2f,0xf30dd26d,0xf235f424,0x3d4ffeaa,0x146fe0c0,0x0ebceae1,0xc455db7d,
0x04541f6c,0x3405d238,0xf634d6f9,0xd3752563,0x3ad03b00,0x07dfecf6,0xe01c333f,0x0cf516b7,
0x2b5cebbc,0xe3ad157f,0xf6d83c0b,0xfa64e48d,0xc8edf042,0xf6022acc,0x347afe71,0xd18dec39,
0x1f5a0c65,0x28e3d189,0xf88e03c0,0x2d8408c8,0x01571074,0xf118e9b2,0x0c08251c,0x1017e75d,
0xfb28e21e,0xec900083,0x011df9a6,0x1c4ce5d1,0xe9120767,0x0eb33197,0xd5dafc40,0xfcfd1482,
0xeb6e05ec,0x05c1fd2a,0xf36d0d60,0xd47010ae,0x0e3114fc,0x008c038c,0x1e78ce89,0xfdac1bbf,
0x32e7fac1,0x122cf795,0x22800040,0x21f8daa6,0xf5d9f141,0xf10d232e,0x137015e0,0x00000697,
0xe8011ddb,0x29e8e144,0xb0f5fe99,0xce7d3c34,0xe8480583,0xf82e0330,0xecf006c3,0xf1d80514,
0x0bdff6ed,0x1278d7d0,0x040709b0,0x2dfcf31d,0x3cd8c72e,0xdb09efa2,0x1c2a152c,0xd8da0df8,
0x2d2423ff,0x0c48d596,0xe7fc0d30,0xfea10b2b,0xe949014d,0x00130018,0xe42d0083,0xecce1fce,
0x0970ff99,0x09e7ffe4,0xee01e302,0xdc15f15d,0x019b01d4,0x1788c8ad,0xec6e0cbc,0x27a31e63,
0x2163f3e6,0x1dabf569,0x0598fc34,0x23b0fb35,0x17c8ec42,0x038905dc,0x043be2e2,0xec0911df,
0x2342f3a4,0xf9ad0254,0x00cc038c,0x02efb8bd,0xeabd20b1,0x1360cfa5,0xdfec2d58,0x1b3cfe5e,
0x0af00254,0xec1c0d44,0x0f081d3d,0xffd8f1bc,0xed043922,0x2893e312,0xe255f6e9,0x2168170d,
0x08fffb7a,0x0da0f181,0x14abe426,0xb8100a1c,0x2c8efe35,0x03ab050b,0xd13de355,0xfc4538ed,
0xf0a4ecbd,0x07df21e7,0xee45e600,0x3570b081,0xe486d9be,0xe8d531f3,0x004af659,0x194c072d,
0xe1e810e4,0x0d842520,0xbda51313,0x0c9c496f,0x029fe8fc,0xe251fbdc,0x0c1817bb,0xf495ba1c,
0xc7012ae5,0x183518dc,0x05cffa04,0xe9c0041e,0xffa92593,0xf326fe31,0xe8d91b9f,0xdc0a32a4,
0x1acf05f3,0xe642040b,0x16c9114b,0xf1b5efa2,0x03fc1377,0x11b8c422,0xe9001298,0x0404002c,
0xec55048d,0x2d63dfcc,0xfaa1ef99,0xe444e471,0xfa7623e8,0x1d80e0c0,0x0373017b,0xf45a0fc5,
0xd4801027,0x047ddfa9,0xfc15e3fd,0x18a802b3,0x0eef1074,0xec6e1eaf,0x42cff134,0x0c68df9a,
0xc8e62014,0xfad51c73,0x1a480170,0xd8830dc7,0x05dc0ddd,0x0c7cea29,0xf9c00fe0,0xdad61310,
0x0b511ae1,0xfaf5e052,0xe0bd1ffd,0xeb2cfd4a,0xef3ef399,0xf6f1fe11,0x08c8eb1d,0x2e53fba2,
0xfbe9059f,0xc97102b3,0xfb411d37,0x0ac0f4d8,0xd3cc0035,0x0b7b155f,0x121cf198,0xe1ede955,
0xf2f028f4,0x17a80079,0xee61df7e,0xd64109b3,0x3158ee85,0x0598da0e,0xe682f7a8,0x23471d84,
0x0a940ac4,0xe332f677,0xec651a24,0x19a7f2b2,0x178be340,0xe46dfe89,0x13840283,0xfe0508cc,
0x3758074e,0x0c780a03,0x01900e5b,0x01bd0b68,0x0774f716,0x09e0ec8c,0xf93d1e9c,0x12650648,
0xe8d00359,0xe821717b,0xd76df481,0x0035f838,0xe4dd250c,0xec090aa4,0xfc09153f,0x3e77de61,
0x0814e695,0x0709dc6a,0x2398eef1,0x1900ebc1,0xdd5221d7,0x265d0980,0xf61df75a,0x1687ede8,
0x10690f4c,0x13a006bc,0x06670c2c,0x2560dbf8,0x07c8e7a1,0x06371758,0xf4341168,0x0e88fa04,
0xf8011603,0xf3ea1b2c,0x01342934,0x212ff808,0x0680f28c,0x0938039c,0x4417e369,0xfbdcfb90,
0xfb38f069,0x2897e6ce,0xf855d281,0x07edece6,0xfdead8e1,0x01a8f2b2,0xee65269b,0x0ab4cac2,
0xf946fb11,0x10a04cf8,0x0b5b04d8,0xde31e2ca,0xfab5fb3c,0xd844354e,0x1c3c1538,0xd0fdce92,
0x11b3f8ec,0xfd711660,0xf5c012b7,0xffb60553,0xd635fa5a,0x1268f6c1,0x20e1ba3c,0xe0b9feb0,
0x0ed40e74,0x0a3bd86a,0x2bb02203,0xe14dfc59,0xff70f7f1,0xdca9f505,0xee243767,0xe7cd0bec,
0xe389f7c8,0xc29406ec,0x274f146f,0x23421340,0xe1bdfcd6,0x2e33eae6,0xd2ceee1d,0x25fc153f,
0x0fd3f882,0x39abe9a5,0x3630d45d,0x02f8fd7a,0x1680044d,0x25e0db58,0x0410faba,0xf45427f3,
0xeacdfbd9,0xc291c9dc,0x0a0bf785,0xb3080335,0x0ec13e53,0xcfba038c,0xfaf11b85,0xe1210fc5,
0x1eec143d,0x1b7ced0d,0xf9ade922,0xd42d1cfb,0x2042f2d4,0x1257c9dc,0xff1ef54c,0x391707d0,
0x3002f316,0xe49d1161,0xf1fefafe,0x1fc4dcbc,0xd8d111e3,0xead41ae1,0xfda8e7fa,0xdae021b6,
0xd1494326,0x049701e8,0x09cc339f,0x12f5ffbd,0xcdc91c23,0xf2183dfc,0x1198efd2,0xf372011d,
0x1dd81084,0x161c0184,0x1855eeae,0xf647f3d1,0x2a7fe30e,0x26d2ca9c,0xefbc0c0f,0x1b68f064,
0xe781d80d,0x288a0228,0xf346f7ac,0xeffdece9,0x489f1c60,0x238ffca6,0xf3f10190,0xc27d2e2c,
0xcd8e514b,0xcb0645eb,0x3eeb1b5f,0x0740e92c,0x3acce909,0xe2fcccc8,0xeacd1d5b,0x3682b49c,
0x1f97f964,0x105bcac9,0xf1cefea1,0x1ee5e0e4,0xe139dd96,0xef110fe0,0x27020913,0xdd39c899,
0xfaf51c53,0xe821382c,0xd4323d23,0x074401b4,0xc35a2a3f,0x009712f7,0x12a8f19e,0xe6551eec,
0x00ab1efa,0x2fdf09f3,0x327bcb56,0xfaa51268,0xee3811cc,0x3018de41,0x2af3e24e,0xd16df738,
0x023f28f0,0x1f13daa0,0xf7680908,0x11520f90,0x02bcfa61,0x06db1164,0xed9de5ae,0xdd700b61,
0xe0750474,0xcdf53260,0x1c102d08,0x28970ec1,0x006c0921,0xf39416f9,0x36c3feb5,0x2a8ce10d,
0xf549c04e,0x24140564,0x1ba8fc20,0x1f50fa2a,0xf51cee95,0x023ff6ed,0xfce0e15d,0xec6ed671,
0xe3f91fdd,0x1e08f320,0x080fe3f9,0xc96e28d0,0x081b12c5,0x1e63edf4,0xe2bc25bb,0xc9ba1df8,
0xd4bd14f6,0xf3c111cc,0x1040ff29,0xffa6f9a8,0x3bcbea3d,0xe3221680,0x319c1a6d,0x3b33dd4d,
0xf0d8fcf1,0x00f70cb0,0xf93d0f8c,0xf950de31,0x1a0ddbf8,0xf26cf4a1,0x1e9800ab,0xf60408dc,
0x01a02580,0xe786137c,0xe6adf349,0x088331b3,0xdac92d58,0x154f040b,0xf7710c53,0x0470e3d9,
0x098cfc76,0x0d47f1e5,0xd35ed8da,0x26c8f326,0x1acfe6ce,0xff25de14,0x164311e3,0x3517d799,
0x0894f4f5,0x0d0b04ab,0x2463d184,0xee2d0a9b,0xd499371f,0x0fccfbf5,0x00b3f84c,0xeb31eef5,
0x12b7f932,0xb0ac0e28,0x0fcc1347,0xc9f9f879,0xf989e919,0x240817a8,0x16fb1144,0x17bfffb0,
0x2a3fff19,0xeae110b7,0xc2ba3830,0x042df2cc,0x1cb7fa98,0x0ddfdc3a,0x122f104c,0xfb35ee98,
0x06970b52,0xec29d60a,0xf99d25cc,0xea600f7c,0xc445f7f1,0xe835311a,0x2657f205,0xdf260b21,
0xda32111b,0x02ec1e24,0xcb2d0fc5,0x1e9c049b,0x26efd223,0xef9c05d8,0x0548211b,0x279fe2ae,
0xe990de4d,0xf0c1f45a,0x2af8fb69,0xfa4a0a40,0xe7861db8,0xf994fbfc,0xc89423b0,0xf218fc6d,
0xe5811b56,0xe959fa4b,0xffb91e1b,0x4cacdde0,0x1bf3edba,0x189806db,0xc8c106d0,0x14efe0b4,
0x114bd25a,0xe5051627,0xe3b43767,0x4120f471,0x18acec09,0xce562dbc,0xf69d0504,0x1704ecb9,
0x279f0367,0x039c06e7,0x2c40e6ad,0xf6cd05a8,0xfffd281c,0xe6e9fe35,0x2367f451,0xdff9e2bc,
0x04f83622,0x07371fe4,0xdee50b7f,0x28cce7dd,0xb3ce2476,0x257318af,0x1c8305f8,0x19ced050,
0xfc2dd8f1,0xf0000ec4,0x29e41e85,0x22a71818,0x283ce002,0x06b32314,0x13a7f4b5,0x2dfcf579,
0xf0910548,0xe8f50eac,0xf22e25b9,0xf929f295,0x1b13f7ea,0x23abcfbe,0xffd61868,0xfcf92604,
0xf559f2d4,0x3d43fef0,0xf252fe05,0xf79123bb,0x1070fd34,0xd536d4e1,0xc2ba311a,0x0fa910c7,
0xd792e74d,0x12a808e8,0xf95df326,0x07bddc65,0xff89f14d,0x223c1b13,0x0623fbbe,0xef39ca0c,
0xf821389b,0x0060fce0,0x05bcf9e9,0x3e27f12a,0x0c9ccbf4,0xef0001cb,0x25b3fb4c,0x16700618,
0x2ba706fc,0x0bb8e9f9,0x2f13d60a,0x2850e1f6,0xfc45cfe5,0x223cf6d1,0xf851fe11,0xf10d0c5c,
0x12f0fa08,0x0dcb09a3,0xf4f503f7,0xe1514430,0xba582ec0,0x2a84112b,0xeb5cbd28,0xd7963b7c,
0x10a7f3e1,0xf241d769,0x213c1013,0xd50af80c,0x103bf38d,0xe20d1508,0x369202c1,0xf612dfe5,
0x17241910,0xeb244e57,0x199cf920,0x07c8eba5,0xeec5d9ae,0xe1813244,0x1abbcb1f,0xefc007db,
0xf980da29,0xea142290,0x2e7aef55,0xeae8070b,0x03650fb7,0x0447ec75,0x0660fa24,0xed19e149,
0x0ff53170,0x04ab1a27,0xecbdfda1,0xfbb92c1b,0xb58908a4,0xbef92d14,0xfb81fd44,0x0aebf146,
0xdea112b3,0x222034bc,0x1bf0f8b9,0x08cf0f87,0x07f80921,0x25232c54,0xdd84d0d9,0x06bc1990,
0x34a3ddb9,0x0b7fd454,0xf6420228,0x1ad80b0b,0xf9b9c4ad,0xf1912510,0x1aa80083,0xdcf2f12a,
0x0390414c,0xe6d9f7f1,0xe06e2beb,0xd6ae1aa8,0xbafc5aa7,0xe2880921,0x0f5c1b2c,0xeb45f012,
0x0c781ff7,0x1674e83a,0x0a74e19d,0x0c97f168,0xd766f7e5,0xe0b43d21,0x39640591,0x000ce841,
0x012dcf5a,0xf642030f,0xecb90a00,0xfaf8f52e,0xe67936a8,0x08a4f9c4,0x04c00cdc,0xd389d615,
0xfc453d97,0xf5dcc44b,0xf9e6223c,0xe4e415c8,0xfc59ef69,0x1124e5e1,0x2ed320fb,0xe13de121,
0x5810fe3c,0x3fefa0da,0x07401a10,0xc0f905e3,0x1a37fbac,0x26d8dcec,0xd099f582,0x284c05f1,
0xf26cf1e1,0x22c0106b,0xfb992610,0x03c31c80,0xd7c207df,0xf7781adb,0x1dd2fc29,0x0b48d598,
0x0f0f21ef,0xf094f2f0,0xecc50970,0x0fd9e4fc,0x16531939,0x39fce5f5,0x2a54e665,0xf875e8de,
0xfbe9dcf2,0x19090df0,0x155fc976,0xf5fdf35d,0x0c8321c3,0xfe913ad0,0xeada18c8,0xd22de3dd,
0xc65a5006,0xe1282c34,0x15dce16a,0xe999f798,0x25a706e3,0x147b0853,0x10d431e3,0x0ec10cd9,
0x29b40dcb,0x07f80fb7,0xf30de01c,0x3eebd6d2,0xeee8ef3e,0xe9f00757,0x19733308,0x0a5dea60,
0x0023fbd9,0xbb20fa9d,0x26bf24a1,0xdc11fa2a,0xfc02fbf0,0xd97918e7,0xf4511e7c,0x13e7e395,
0xe1ad09d0,0xed160167,0xf34912d9,0x209f04c8,0xf7110d39,0x1e983267,0xd3410ca9,0x2f27df51,
0x13b0d1bd,0xf64ded20,0x10d4fee0,0x0ba8f498,0xf61d0380,0x02efec25,0xfd98167c,0x12fafbb9,
0x0f05d896,0xd52229e4,0xf0b62947,0x0bb819fb,0x06481394,0xe7000957,0xe756116f,0xfb3cfe58,
0x2df3c22d,0xff02fa9d,0x43b6fe25,0xdbf8f6b6,0xff5504c4,0xe379164c,0x4e8b2dbc,0xf619fa2a,
0x15d9fbc5,0xfcf1f255,0xf330c73c,0x1ef805ec,0xfcfdd301,0x02240b7f,0xa94d1060,0xea040ddd,
0x1633f146,0x1010ff50,0xd1763e30,0x2837b6cd,0xf92011dc,0xf7b12553,0x0b9fd4d6,0xf89c17cb,
0x21dc034c,0xed44edb6,0x1a5818c0,0xd66a074e,0x4ddcfc02,0xdeedefb2,0x0c180dad,0x127f1310,
0xfd5d09ec,0xebc5c651,0xd9b50030,0x06353991,0xe325fe35,0xf1783a9f,0xea791ff4,0x0c7c0dae,
0xfbd9113f,0xf4c514ef,0x12fadcd2,0x016bfd61,0xeb2aecf9,0xd501e29a,0x17e3eb6e,0x1a48c8bd,
0xe7b126c4,0x0fdc1e7c,0x2a08ab95,0xeb1df350,0x3be722fe,0xed6dc591,0x06fc1848,0xfd06fb6c,
0xf84a13c0,0xe22c21d3,0x0648eebc,0xecd40e9f,0xdb4a3173,0xf7a8e52a,0xf8e91b24,0x0e14f451,
0xf260f6b6,0x25f0e851,0xf99de3dd,0x07c20883,0x05a51f3c,0x3840c6c8,0xf0e8f394,0x113806a9,
0x2154ea4d,0xf4a500b0,0xebf90d54,0x32a7ff02,0xc2562beb,0x2dc812f0,0x11b8ce06,0xe9551b6f,
0xf42af4ae,0xd2fe03b9,0x1754fa46,0xfd2ae7a1,0x02911ac4,0xe8011a4b,0x03931f29,0x0d1ce458,
0xdf51e7ed,0x0ae4442a,0x1094bb09,0x1acbe749,0x0d091131,0x0dddf21c,0xf831f4a8,0xff501960,
0xd15d0261,0xf9a013c4,0xd04e1d40,0x1598309f,0xfe31ed09,0xd7961940,0xdd2c3358,0xd995074e,
0x2c94ecf0,0xe5b1ee4d,0x09d3116b,0x3c27b908,0xdfd5ebb1,0x1aebe8de,0x095c0e83,0x2d1ba1d9,
0xf380fc10,0xe49d1a64,0xed91f84c,0x037a1e33,0x01a8e771,0xda4d25b9,0x1ad41885,0xe40039cf,
0x105408e8,0xefa91407,0x0ae4e6ad,0x1cfbf825,0x17a8e565,0x0edc1dbf,0xf0500923,0x261412f0,
0xc38eed8d,0xfdd1ed64,0xf4f5ef7c,0xde41e541,0x12fa0ddf,0x2637dded,0x0db7f5c9,0xf694f579,
0xfbe517b8,0x0b74d60a,0x11c42b90,0xe69e0da0,0xf339ea86,0x2f8dd531,0xea5037d3,0xef2112fa,
0xf6ddf7f8,0x104405a8,0x1794351e,0x06f4f4ce,0xe39ed77d,0x284503d3,0x1fe4e3b4,0x1100e4c4,
0xc745064c,0x583ffb38,0xd8c8e9f6,0xec3e2f30,0x0c3ff781,0x18a8ef8c,0xe6220d24,0x16901e48,
0x1508d211,0x05ec0f65,0xe6050deb,0x0f6c0bcf,0xfc90a947,0x056f0fa3,0x076412a3,0x10c40134,
0xf37d13a4,0xc8640f6c,0x245fed19,0x0f26f7f1,0x1e85f09d,0x1714d2f1,0x0114feb5,0x054411d8,
0x2d31fa98,0xf3f400ec,0xf8ac06a0,0xd115fbd5,0x193cb23d,0xf04d09a0,0xc85625e0,0xf4913b00,
0xfdd1257c,0x222ae0d9,0xf3a4dafd,0x0864ca11,0x113ffeb9,0xeef5d275,0xeb3d1c4c,0x1f5a10d4,
0x3032dc6c,0x1ffeefdd,0x2fabd1fa,0xf572174b,0xe0844e27,0xe1bdf85e,0xe5e91909,0x3ee7e16a,
0xcd3908c3,0xf82e15a8,0xf4010757,0xca92ccac,0x11cf0258,0xe86e0305,0xf5990a8d,0x2dd6f2e9,
0xe581b318,0xd3801c33,0x0e080bd8,0xf030c94a,0xff861000,0xfa38060f,0xfbbe20f4,0xdcec0ad0,
0xad852c74,0xf7481de4,0xed5906bc,0x0d770167,0xe56ed4cd,0xc68e0fc0,0x1f03d2b1,0x1226ed81,
0x0d0bf4d1,0xe58101e4,0x28301094,0xf6dddb66,0x41270710,0xe4f4ec45,0xdb3dfa61,0xf97725c7,
0xffb6ca32,0x10740cc5,0x0637fa91,0x27f8ec65,0x213cdcd9,0x0b9c16b4,0xea3ddccc,0xdd994f26,
0xf134fb25,0x00630abb,0xf0040a27,0x1138e8b1,0x1d80f215,0xfbacf3a2,0x1f2a0f0c,0x050119ce,
0x0e441151,0xe7e6d8c8,0xef4c1690,0x034cf62d,0xe379ff3d,0xf87c003c,0xe9e604c4,0xf738e096,
0x0d200534,0x01d8ff92,0xcb3df165,0xeb481684,0xdd4d27ec,0x170f1e41,0x0330f9b6,0x0f8716e0,
0x0050ffed,0x14e8fbcc,0x2672eb45,0x1fe0e69e,0xfd4af235,0x0ce7f8c0,0xe1210b9c,0xebe8e032,
0xf761da29,0x3044ebc8,0xf2a312fa,0x1dbf1669,0xf505dcc9,0xf4ce2c3b,0xe248e9bd,0x00b335ab,
0xdd8910a0,0xf0561e7c,0x1da8b38a,0xfda425f0,0x021f053b,0x05b80c2f,0x0cf7083f,0x0e68da45,
0x339bc95d,0x2289edba,0x06280821,0xf6a02a08,0xcf1dfc15,0x0c6c0477,0x1efaebd5,0xe2411f29,
0x072d0bc1,0xf438fc76,0x1556eada,0xddd016a0,0xe7cd35fb,0xe91510b4,0x0dc40aa7,0x1d68e09d,
0xfb4af342,0x1124dad0,0x250cf3ed,0xdd35f731,0xff76071c,0x02680228,0x0ddf0a47,0x0de8e82a,
0x02dc1287,0xfe05049b,0xf08de578,0x048d12c0,0xf724f741,0xf2b22530,0xfaa10254,0xe34cff59,
0xd31e081b,0xd90130e8,0x011d25e7,0x054f0037,0xf6b9d166,0xd80d03cc,0xee1d2418,0x150ff929,
0x231b0c3f,0x1f1ce558,0x17fce4bd,0x2657e781,0x03a0d424,0xd5eeff09,0x20a80b44,0xf56cddc6,
0xf32df86c,0xf111d61e,0xaba94a60,0x2defe1a4,0x2547e9c0,0xf48adc6c,0xcf8afd34,0xcfb520db,
0x15d904b4,0x0e9fe548,0xcb8610f7,0x03b928d3,0x3810e7b8,0x0b3408fc,0xea3d15b7,0x3436d45d,
0xcd110bff,0x432fef39,0x18dccb5d,0xf5bc0794,0x003c31b0,0x01cbbc00,0x01902f4b,0xe3e40bb3,
0x0fa3e761,0xbf812728,0x0a34fcd8,0xcbed3a97,0xd1293c68,0x079b1727,0xe749f7c1,0x02dfe779,
0x004a0844,0x0d50e258,0x1d10e5e5,0x1481d0a9,0x2237f009,0xcd39d7d6,0x636bc159,0xfd640894,
0x31f7154c,0xedbae6f0,0x09fc1aab,0xe9ad086f,0xf8c9dd49,0xdde91dd2,0x02ff194c,0xc931054f,
0x0995fc79,0xe80a003c,0xc36126e8,0x0e9be215,0xe1c1f48a,0xf75af48d,0x151c1cd7,0x421be370,
0x014ed705,0xe1e8f7c5,0x217f129c,0x26ebd3a5,0x13871340,0xf619001c,0xeb14ffc0,0x084bdac9,
0xe69e13b4,0xdea101a8,0xe6b9f71a,0xd2ea31e0,0x1b8feddd,0xed0d30c8,0xde28e85a,0xf45afc4d,
0xd001113f,0xf3b61a5f,0xf615f45a,0xf94601ab,0x0a60e63e,0xeee5d991,0x08830d09,0x2ff8c25d,
0x5218d6a5,0x0a39cdac,0xf3462024,0x242be332,0xdac61010,0xf8cc13f4,0x00cc2240,0x082825b9,
0x0e810cd0,0x2cd2cee4,0xc8792977,0xa48849dc,0xee5c281f,0x01440960,0x0b38f3bd,0x0689f45a,
0xbb0916b7,0x1bc3f831,0x0c68084b,0x186cf67d,0x04470b5b,0xf131bd90,0x43affdb5,0xf282cde0,
0x0bff0174,0xe7f411c4,0xe90ee65c,0x17bb0c87,0x0e0bdc6a,0xfb510ff5,0xfae1fc15,0x00c74480,
0x04bd2c80,0xc61a1b86,0xff5de7e1,0xcfc8ffa6,0xe831fd4a,0x241106db,0x1cd4d628,0x0e8bfd81,
0x242bfcd8,0xf9561980,0x0640e315,0x049b251c,0x078df8e5,0x166000fd,0x122cf5d2,0x11dcf9e1,
0xe21ef35d,0xfd98d28a,0x06a3fa16,0xb0b522fe,0xfb4c1b0c,0xf4cefc94,0x026fd665,0xdd4d1c40,
0x25ace736,0xfc62bc00,0x11282c44,0xdecd0bcc,0x021f3817,0xe1e1f3d4,0x1c5ae0fd,0x2850c812,
0xf0caeafa,0x06f02bf7,0xe96909e3,0xec55ca5e,0xed302327,0x13431d98,0xff49deda,0xd7bd451b,
0x08ff0104,0xbe321903,0x153c11df,0xf8251ef8,0xe8cafec5,0xdd6d1057,0x3537fa4b,0x093ce9ad,
0x020f11b8,0x1abbebbc,0x0154e3ad,0xe915f670,0xff39c4b9,0x109bea04,0x066009ac,0xfb85199e,
0xf619e261,0xe2a8ed04,0xfc64d566,0xd3652d3f,0x02630777,0x01c1e1dd,0xfe45f30d,0xd325fe11,
0x06e00049,0xe679fd84,0xf7b51643,0xf4780905,0xf309178b,0x022804a8,0x26500da4,0x1640d792,
0x20bb165b,0x175bb48e,0x0d241420,0x1ed3ff62,0x0e61f771,0x0a90ce09,0xadec1164,0x0337eb65,
0x091cf131,0x2e73d9ec,0xed42f708,0xc06e242b,0x035cf42a,0xfba9dea1,0xe461f6d8,0x08dc2a93,
0x07a00404,0xf31d0e68,0x0028023b,0xddc9048d,0x0154ef1c,0x13d0f66d,0xf3d4e5b8,0xf378057f,
0x195becb9,0x0848daad,0xf4d8ef25,0x2dd3e8f5,0xcefaffe0,0x1a58d5e5,0xfb1c30ef,0xee480124,
0xdfc10edc,0x478a16a7,0xfcb6f6d8,0x0dfbca3c,0xd1c228bb,0x2b801b03,0xd8842d84,0x0d84f7d5,
0x05e3e7e6,0x0680e591,0x05c8fa94,0x3dfcc3ce,0x2dbcdd89,0xf539faa1,0x0359f634,0x03b30ce7,
0xddcd1568,0xf13d1a7b,0x08ecf302,0xf7ac0119,0x122ff9d6,0xfc3d08fc,0xf225d5ad,0x0730f7c1,
0xf44106cc,0x11c413dd,0x0770dcc9,0x2e53fd8d,0x2e700b28,0xec00f0e6,0x17efe8ce,0xf15dd4c6,
0x357bf04d,0xea861a6d,0xfa41dda9,0xe915287a,0x1878ff6d,0x2370e4ed,0xee6508b3,0xf4241418,
0x192a0023,0x0258f9a0,0x1c63c36e,0x146bdde4,0x03070f95,0xee4812c9,0x1317079b,0xe712c519,
0x1b110650,0xff4912dc,0xfaeefa91,0xf46d2694,0xeea100a0,0x166cd63c,0x1af4f4a1,0xfa31f0c1,
0xe7b6d692,0xfe450043,0xee61e685,0xf7313dc3,0x0e4bf019,0xf2851094,0x00f71583,0x0231e436,
0xf4c1bea6,0x048715ec,0xe571e875,0xcff5175f,0xfc322ca7,0xfbb9f225,0xeb14e990,0xeb21380a,
0x34aa01ed,0xe42df369,0x3fcb1f63,0x2bebd888,0x0ca0e5a1,0xf855e385,0xf84c13d4,0xe03e1ab8,
0x146f0f26,0xffe9db14,0x41aece6d,0x0fb3d331,0xeae1f1de,0x118210d7,0x083410eb,0xf8b2e025,
0xcf080b58,0x00e41208,0x124c0e21,0x16c9efac,0xe6ddfef9,0x128ce91c,0xcb59e54e,0xe8f1267b,
0xf48df1ba,0xfe913dc3,0xf8e2febe,0xe52ce952,0x1504e652,0xf3760ecf,0x0948ee85,0xf3c4ecbd,
0xd0050a94,0xf3b114c8,0xfcf9e2fa,0xf0ca461f,0x0d27e751,0xf146212b,0xf5820cb3,0x1707e871,
0x1044ede8,0xf65619bb,0xe955304f,0xfd24dc51,0xde51e399,0xcefd2eeb,0x02381c9e,0x02c8f1ea,
0x104c1768,0xe4361420,0x011e1f73,0x205fecb2,0x0a90f40d,0xe171f6fa,0x014ee345,0x3cfbcd4e,
0xf612ff9d,0xd389ffed,0x05380cfc,0xc935df1e,0xdcf90460,0xeb912e3c,0xeffddaed,0xfae5d95e,
0xddbdf4d8,0x2a080f35,0xecf0db3d,0xfe2513c4,0xfd38156c,0x1134eab6,0x22a0bdc3,0x01c8254c,
0x1d4b0cb7,0x2b15e281,0x13fbe126,0xe515f57c,0xe8f12084,0x2711d921,0x15b31099,0xe9c510df,
0xf22ee6a9,0xf1b5c405,0xde5d0ba4,0xf8f91754,0xdd52283c,0xfcb62f07,0x25171108,0xdb66c3f5,
0xd0b51c47,0xf53508dc,0x158cf9b0,0x0804f265,0xeee50440,0xdd54ed6d,0x07cb2910,0x2c67ee71,
0x170dd84a,0xefbce689,0x360b126f,0x1047f5b5,0xf1751151,0xda99e19d,0xf2cc0c87,0x22fdd35e,
0x11e8d476,0x23ebfbac,0xd88323ab,0xe052d1b1,0xc4151edc,0xf7242b2c,0x307ff590,0x1cce01a4,
0xf089fb4a,0xe8d01808,0xf2f009c7,0x310cd24d,0x39fca5fd,0xdab0f934,0x107df416,0x0979c2e1,
0xf7e1278c,0xf5a5f629,0x0d39fad1,0xe191120f,0xf0a42597,0xf4810228,0xd858d628,0x1287faa1,
0x41c4ca21,0xd4192e60,0xdcae2d74,0x2beb0228,0x0ec10e52,0x1e9fe37d,0xe03ee5cc,0x1120f8d2,
0x19eb1182,0xfc8de5a8,0xf1f10ba8,0xf5e5f326,0x11dc071c,0xd789d9b0,0x34e3d801,0x0005ea26,
0xec8242af,0x198415f7,0xe27523c4,0x19691ca4,0xd350f495,0x0470fb71,0xf50c0d94,0xe71d2070,
0x0aebe17a,0xe2780df8,0x1e68d729,0x094c24bc,0xe9edfa1d,0xedf40ce7,0x0cb3df21,0x0bcce109,
0x37fcdeb8,0xfc0cfd9d,0xf4760a47,0x0337183c,0xe19af342,0xfc341077,0xfa3d5772,0xf30dee3d,
0xbd900b68,0xdfe90e7b,0x030f0f2f,0xd1091f33,0xd1691309,0x2657f7e1,0x0c08205b,0xef89ed64,
0x29543ccf,0xeafade96,0xfac8efb2,0x119b0e5b,0xf046cd7c,0x271be5d5,0x11cf0b88,0xf9b9f634,
0xe5a8ff32,0x090ffb89,0xee01d55d,0xdd152433,0xf7a61838,0xf0c40b8b,0xff39250c,0xed49211b,
0xec42f441,0x05a81556,0x02e80bfc,0x16ddf5e5,0x0e280e68,0x13ebe6dd,0x05bce2ae,0xf970ff49,
0xe3bd10f0,0x02611e11,0x142fdd96,0xfb9ce228,0x1930dddd,0xdce91278,0xfa7cdd40,0xfcadf094,
0x1e78ff8d,0xf579ee5a,0xe53edb58,0xee8c2863,0xd3b001ed,0xe8d901ef,0x1999ff15,0xea501764,
0x180cebfe,0xf316f21c,0xdbcd0114,0x0c68e665,0xeefe02b8,0xfe21d9b0,0xf5ec37fc,0x1b2fc775,
0x0ad4004a,0xf004f5cc,0xfeeee139,0x03e4e4f4,0xf8b22163,0xf3300248,0x1f00e80d,0xc4223038,
0x0d20f195,0x0a2c0bff,0xedc401c4,0xe89a1999,0x19c0d1a6,0xc6b1e3b9,0x12e303e4,0x0467ebd5,
0xf0890858,0x2bbacb02,0x1287d8e1,0xe62be989,0xff49073b,0x4880e4ca,0x0667cc7a,0xf7c8fb3c,
0x09f31835,0x172bff55,0xffd61798,0xf0ad21c3,0xebce15a0,0xee95dff5,0xf699172f,0xee851db1,
0x185cf421,0xf656e265,0xd799186f,0x2f30eb55,0x0f53ca0c,0x10c4f75d,0x5ad2e1fa,0x24f3ee8a,
0xe791e3a0,0x17c827b8,0x3d08ddd9,0x047feda2,0xe0dde804,0x14b8fbb5,0x1609c085,0x08cf07d0,
0xbcfd08a8,0xe2951357,0x1ffe0b34,0xe9251d5f,0x2614c199,0x007a0878,0x11f5f4ea,0xe77402d5,
0x105beb51,0x17effaba,0xe409f1ba,0x1ef8f81c,0xf1c5e779,0xe5e92154,0x2293d4ad,0xf2e9eb11,
0x02cf18dc,0x29efe5ec,0xdbbd1377,0xfbac0700,0xd4191b13,0xf5491481,0x0ef5fcf9,0xf0040853,
0xe94212b0,0xca321478,0x1ea327ac,0xf66df17d,0x3fe22d3f,0x13e7dc78,0xf101e065,0x0447f18a,
0xe3fdfefc,0x1387033c,0xea392fbd,0x33dfd5d1,0xfeee02bc,0x14e10db7,0xe888f5b5,0x1094c725,
0xf99d09c7,0xdd15d54a,0x41c4fc49,0xea04e9dd,0x0d60f0c4,0xf66d07c8,0x02a5c10e,0x079041b4,
0x19a708e8,0x08dc0278,0x2ab50ddf,0x1cd405b3,0xe13116bb,0x0a841f59,0x18ece8ae,0xfbd5c92a,
0xefc912ec,0xf6a009c7,0xf10dfd21,0xffd6146b,0xce59257c,0xeff5d566,0x08ec0390,0x02540e88,
0xb6c80757,0xf2b91c7c,0x2f19f885,0xd91ee885,0x0e6b2124,0xdd920bb8,0x3488205b,0x13f0e3a0,
0x21dcfed5,0xe5eceea5,0xee1d2138,0xdb4df4bc,0xbb4502d8,0x38c0ffa0,0xf9bdf378,0x026ff6d8,
0x05df26c4,0x1f00dc6c,0xdb44ec25,0xc73c3ac7,0xff4d2040,0x0c21e4d4,0x191cf7c5,0x1d2bcfc5,
0xfaa5d42d,0xbef9422b,0xe751f471,0xefcdf3b1,0xf3940274,0x0be3f559,0x2a1fd62e,0xc9760d57,
0x00500af0,0x064300c7,0xfab1ee38,0x07df110d,0x0acbfb90,0xfc55fa2a,0xf8e904df,0x1c60db36,
0xcc7afe99,0xe2de1e24,0xedd40aaf,0xf66424ec,0xe6fd3c3f,0x1020f441,0x12ece93e,0xf6f117a4,
0x09fc0720,0x271bde4a,0xdde00b98,0xea72fed2,0xf042e191,0xd93a0323,0x00b31d54,0x4750f252,
0xea69f629,0xda76495f,0x0119f976,0xf7d8e188,0x265d0089,0xe75de409,0x083f13de,0xf9b0002c,
0xd931f3fa,0x09ac1c9e,0x00b30d6b,0xf3d81aa4,0xd0b5fb71,0x1ebf0248,0x0ed8e6d6,0xd0f2f4b5,
0xf1541320,0xfbc91adb,0xf6cd10ad,0xcb9d1548,0xfc05f029,0xff09cfb1,0x02f32b80,0xed34dd8d,
0x046bf5d2,0x0040fc05,0x1c97fda8,0x1a6dfcf9,0xe67c04d0,0xcc85fdea,0x0b6f0f8c,0x04af0689,
0x0fb3f66d,0x17cf1144,0x09bc1ae3,0xe196e699,0xdc48fb35,0x221503bc,0x110d04cb,0xf1e1124f,
0xd476353b,0x01c10d7d,0xef90eb5a,0xe99e262e,0x041d02ec,0x0fc71390,0xf71a0b44,0x06fcc88d,
0xf165f50c,0x4b5009c7,0x0059f5d2,0x02dc0400,0xe4da18fa,0xee85fb89,0x309fd311,0x08530dd4,
0x0ac0e419,0xe85a3748,0xe900fc59,0xe3853d8c,0xe12127d6,0xd3c51b03,0x15e01044,0xe8c500cc,
0x16c01290,0xf5c0ea79,0x173df761,0xcce1103b,0x386bfc55,0xe38510f4,0x485be201,0xf5acd615,
0x15e710b7,0xcb16ff70,0x02a8ef15,0x2dd3ddcd,0xfe8006a0,0xeec523d2,0x07b42af3,0x01f8faf1,
0xf154fe31,0xb9ba4882,0x07f8e4b8,0xffe0fc09,0xd45412dc,0xff59065c,0x0174fe3c,0x19690777,
0x096c08cf,0x22f0f701,0x1677e89e,0x12a0cf66,0x140de19d,0xf5080797,0xfab50291,0x00db02ff,
0xf7d8fbd9,0xdba41343,0x0edcef25,0xef353974,0xe6600cbc,0x1b55f178,0x158febc5,0x0548d1f2,
0x0bc4293b,0xe3022b40,0xf5150067,0xe771fb2e,0xf020f9d6,0x0c23f851,0x06f0e64c,0xe8cafb38,
0x11480dc7,0xecc9f2d2,0xeb3532b4,0xd524fecc,0x11e8e23a,0xd81ded89,0x187ffd19,0xd52d0bcc,
0xe8910e08,0xf4ea10f7,0xcfe50b14,0x14e31a48,0xf416ee8a,0xe0b920c4,0xef2e2b40,0x2be0cfbe,
0x08e300a0,0x18870853,0xee71fd91,0xd45d1f9e,0xf899f3c1,0xfcb62798,0x24d6d739,0x11eff019,
0xfb9ce3e4,0x06d309a0,0xfdac13fb,0x0c4ff059,0xf33d12d0,0xc850f572,0xf7780baf,0x2533fb2e,
0x25b3ce59,0xe1511377,0xfe411c7c,0x1556f2f9,0x0cc531a0,0xfb15e251,0xdfc1ffd8,0x17e8dce9,
0x12e0f835,0xf920d7dd,0xfe952ae8,0xfb99f2e5,0xc5e10ae4,0x02b8ed7d,0x08afe3f0,0x17fcd241,
0x00f7ef21,0x1b4f26c8,0xff05ee34,0x13a0ecf6,0xeb140c48,0x07903048,0x1663e9d9,0xc6c825f4,
0xdcb53ed0,0x1c03f9e9,0x0c1cf690,0x04b81017,0xcf410e28,0x2ba7f4f8,0x097ceb75,0x167407d4,
0x0000e909,0x1a44ded5,0x2c6be756,0xefc0dd52,0xfdd8f1c8,0x12f7fb0c,0xe66e309f,0xd979e979,
0x00d7224c,0xd27d10df,0xeaa117b1,0xcf8a0464,0xeba51600,0xcf98f372,0x17c8f49e,0x0714eda9,
0x054f0cc0,0xf579e360,0xe7ca2d1b,0xe588110d,0x2610f986,0x414c8a24,0x366fd8f1,0x1278f602,
0x2d6f08c3,0x1213ec7c,0xda192d8f,0x03730790,0x0a5dfdc1,0x1d370a00,0xd96533ef,0xc9911a3d,
0x2304f118,0xca0504f8,0x1138ddb2,0xec1cf87c,0x043421f3,0x0a8403b3,0x08c1e960,0x0ce3ea42,
0xfc3dd8c8,0xf555154f,0x0c87efbc,0x2520229c,0x0d84024f,0xe545fc20,0x068c0cb7,0x12251518,
0x060f20ab,0x0f9cf9ed,0xd858377f,0xca951ed8,0xffd624ac,0xda240ebc,0xdaa9ef52,0xfcddfe58,
0xefc53d08,0x2f70e3a0,0xf708fb38,0x24e5f8d9,0xea1df9cd,0x11cce655,0xd90e2547,0xfe3c059c,
0x0d940137,0x0b6bf84a,0x1a68c93d,0x1d6f0f87,0xef82075d,0x0a7dfe21,0xde8db525,0x195b1ef8,
0xe0520bd5,0x0184238f,0xf4640864,0xf7a1e08d,0xceedf821,0x21e73028,0x2adff925,0xe6ad0f26,
0x35a4e68d,0xdf11d139,0xde881b73,0x3904e496,0x1099fe68,0xeeecee34,0xe215334b,0xfaf8167c,
0x117b16e7,0x09a9e275,0xffd8343c,0x32870149,0xfcc4ef0e,0xf1ec25f7,0xdd450119,0xeb4d0d3b,
0xfc391a3f,0xf225070b,0xc1a90dc7,0x298d02ac,0x03b3e022,0x1e03e679,0xcb69ee21,0x1dcf0a8d,
0x0838bae5,0x25b0e7aa,0xefc917b8,0xfc55fe7a,0x30ecf418,0x056c0e96,0xe4fc1e2f,0x10990c4f,
0x02631295,0x069cff80,0xda8d2fe8,0xafd1131c,0xed4402cf,0x25c72014,0xd162d84d,0x0bf1401f,
0xec30e325,0x0c35f929,0x0cb001b4,0x0538fe15,0x18c3e558,0x1633f0f1,0xd3d50b31,0xff6417c8,
0x400bcf6d,0xf2e2c735,0xe3691087,0xf1a5112b,0x17bf0923,0x1c090a9b,0xe67c071c,0xe63902bc,
0x0f5ffd5d,0xb3d81960,0xeded2fa0,0xfe8e1023,0xe945e1c1,0xc7be2a54,0x0b612664,0xffb0e1f1,
0xfed2fab1,0x1f5afb71,0xedbaec45,0x0891f2c0,0x1cd7fdee,0xf801d901,0x09651dcd,0xed04f029,
0x08880531,0x032ce3cd,0x09db1080,0x009700b9,0xfc0cfe3c,0xe1312314,0xf7760d74,0xefe21468,
0xdd19ea4d,0xe128f42a,0x172be128,0x056fef79,0xd84d1943,0xd7451d68,0x1253d979,0x015decbd,
0x3274d82a,0x03e4e515,0xd7f61c94,0x2148da24,0xc346e5d9,0xf6b9fb85,0x1887245c,0x26bbea59,
0xfd4ae17a,0xe6fde578,0x14ec491b,0x0f78126f,0x27c81c60,0xdd150724,0x1cc4fa91,0xec550894,
0xf23008bc,0x00c30f3f,0xec95ee95,0x2168da3d,0xf9f4f108,0x1a8812a0,0xf6a6fbdc,0xdf95e3f0,
0xe1a10a7e,0x103bf350,0xfab1f5dc,0xfc2d0760,0x0bcce339,0x1630fbbe,0xc864f4e5,0x4086e005,
0x0637cc4a,0x0d2c08e8,0x3473fc3d,0xfb41ebb5,0x1a3d0853,0xdd92042d,0x10571748,0xd476c3a1,
0xfa111e6c,0x080b2200,0x1c73d476,0xe18d00bc,0x49c3d501,0xcaab0710,0x310f06e0,0x09ac0320,
0x01af130c,0xf191e201,0xf2cc241f,0xf5c9e0c0,0x13431158,0x2034ebe8,0xf3040d2c,0x423ff530,
0xead1d735,0x27080ed8,0x11b1f4c1,0x0110c4c9,0xddddf3fa,0xfd91f7d8,0xefd4b2b6,0x2bf03393,
0xff15e46d,0xfaeada39,0x0e1bd7c2,0x004a1555,0x268b04fb,0xfa4a077e,0xe4faf83c,0x1a0d085b,
0x053f0b28,0x494fee5c,0x18c0c78e,0xf41d1087,0xcd8e1627,0xef002228,0xe744f46d,0x1dbff71d,
0xe7a4eb04,0xf9c4fa6d,0xf3bd0e18,0x119424e7,0xd69905ff,0x1c9e2b93,0xed81d571,0x05cc3c4f,
0xe08d07e4,0x1afbea04,0xf461eb11,0x165709a9,0x0a50fe50,0x049bf6c4,0x32470e38,0x29d8c3e5,
0xc256d1c2,0x0000c294,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_standard_DRUMS_verbclickwave[640] = {
0x00000000,0x0006002c,0x004f003b,0x002effa1,0xffa00074,0x00210041,0xffebffa0,0x00ce0032,
0x006aff03,0xff240139,0x0106004f,0xffb4ffc8,0x00150107,0x00caffe1,0xffcfffe7,0xffc800eb,
0xfcde0067,0x00a6ffbf,0x0047fc94,0xfde2005f,0x005e0133,0x00e6fb4a,0xfba001f4,0x010201f9,
0x02ebfbf2,0xfceffd56,0xfcfb02c9,0xf3420450,0xfe0d1109,0x1c94e66d,0x139802dc,0xb76dd3d6,
0xc58c7231,0x26a18e24,0xb1ae7231,0xd5e77231,0x72318e24,0x8e248e24,0x72317231,0x72318e24,
0x8e24584b,0x485e7231,0xb85602a5,0x8e247231,0x55fc1459,0x72318e24,0xe2197231,0x72318e24,
0xe8fca135,0x30b16aea,0x352ba972,0xacc4d13a,0x0b9afef6,0xadc2435f,0xe82bae47,0x2820cfad,
0xe3230450,0xab797231,0xf23df59c,0x47b2b572,0xcb66b893,0x228f22b5,0x3d60e5f2,0xb65b47b2,
0x534fd0c7,0xa86edb46,0xdd8b5d2a,0x72318e24,0xbbd14907,0x103bd40b,0x9b61478e,0x6eb5ce45,
0xf1c5f6a4,0x1380f19d,0xd7e0d940,0xe9233c53,0x4a8d0f86,0x8e243634,0x7231fc94,0xc6caaccf,
0xa66265ec,0x7231921c,0x8e24ecfe,0x0dc66e5c,0x618fb6a6,0x8e24f8ba,0x2a7f287c,0x35f3c898,
0xd0ccd544,0xd3157231,0x517fd21b,0xcc6d1eaa,0x35450893,0x0ee4e6c6,0xfcea0343,0x8efa20dd,
0x48881554,0x31b0e798,0xe5b4f03d,0xf5aa2c39,0x4602aa40,0xaf6d2ae3,0xf4fb32c5,0x1d89b832,
0xdd88f573,0x4aa04012,0xca3fd185,0x396c5239,0xf650cc07,0xf81934a4,0x29f50818,0xdfa6c311,
0x0aa84519,0x1ee4f5a6,0xfb9a2377,0x0982c72b,0xe4a7ebb7,0xe951f062,0x02520582,0xc4faf823,
0x1837098d,0xd4c505f3,0x34efe2f8,0xbd630065,0x1864216d,0x3541c9f4,0xd73ffba6,0x324906e0,
0x1639c7e7,0xef81479d,0xdbd720e6,0x2f9eecac,0xf26109db,0xf663fc1d,0x065e45d0,0x0f30eb51,
0xf5380842,0x11abefcc,0xff70ecc0,0x0e0fe78e,0x15f503fc,0xeba9f0c3,0xc9db383a,0x0f0b11e2,
0xce1cd0f8,0xf1792913,0x4fd7c035,0xd33204c6,0x20781d4b,0x3bb6bcb5,0xb28b0f50,0x06291797,
0x01bcc476,0xddfb1c11,0x0c7a2a66,0x2123c87a,0xd8ef11c5,0x1d1104bf,0xfbd104bf,0x072604c0,
0x04f4000f,0xf3fde4ba,0xfca12987,0x0f1219f0,0xded3ef06,0x10681dfc,0x1a0aceef,0x08580b5c,
0x218100e6,0xd97e0653,0x0bef10df,0xff4bf060,0xef5defdb,0x010bfe0c,0x1a2208f8,0xe1d81fd4,
0x25e408d1,0x0aa3cfde,0xc61416fe,0x35ad0a85,0xf9b7d0e7,0xcce22979,0x3c4be24d,0xd0bee018,
0xdd872c0c,0x1695e579,0xedb61402,0x0f41e955,0xfe2a03ca,0x01d9021a,0xf7a607cb,0x2c74e297,
0xacc42e0f,0x72318e24,0xb6a35828,0x8e247231,0x455a1356,0xdef19562,0x084d7231,0x72318e24,
0x8e24c267,0x180b7231,0x3aefae9f,0xdbead9b6,0xc59239bb,0x3b411133,0xd0d51415,0x0beb09b9,
0x1aa5c059,0xfdb01ffb,0x0856f987,0x0129d1d5,0x1f48f3f6,0xc73116f2,0x0738ed79,0x05d904ef,
0x1603f9bf,0xe95516c6,0xd20208d4,0x0bb91116,0x046ed304,0xfce7106b,0x2ae90f7b,0xc2680000,
0x2bbb16ac,0x0d2bba1a,0xcffe2b9e,0x4cd9dcc8,0xe8f5e7d1,0xf94d1349,0xc5d818a3,0x25a6ff76,
0xd0e20a42,0x2f950106,0x1524bb8b,0xeca7109b,0x14331e9b,0xca90ec0c,0x31cd1b9e,0xe5e2d9ef,
0xcbb32c35,0x445cf162,0xda01d844,0xf44c3541,0x2846e622,0xc9c3ec1e,0x3bbe1334,0xf324d544,
0xffab07f5,0x0876f936,0x05370eda,0xeb5e0a9d,0x001e1d4b,0x2082fafa,0xf748f7f0,0xc56421a5,
0x3e330f58,0xbeabd682,0x381a49ca,0x361cdccf,0x1704a728,0xc234247a,0x2630e890,0xc384ff7b,
0xf3d52a02,0x507ae6a0,0xd7190ff2,0xf9ee4006,0x2538c3bc,0xda7306ae,0x27f029c3,0x095dc4a8,
0xe8351c8a,0x065c1b1c,0xfb4c0ea1,0x0b13ddb2,0xe2dd00ab,0x0bc00407,0x029ce8f7,0xe897ece6,
0xf95b2003,0x03bb0653,0x0f82f03b,0x0841edd2,0xbfc00088,0x2a55170e,0x0f4ceb6f,0x0807fbea,
0x01bdf340,0xf60d191c,0xf8e8fd93,0x0752f755,0x126afff1,0xe9640ee0,0xffc8210b,0x0eb2e00e,
0x031703bf,0xfed9fe0c,0xdfec03fe,0x0b450395,0xfc88e9f7,0x0ae8295f,0x0e07dfce,0xefea0386,
0xf90af6e3,0xf456eab5,0xef4a1e1b,0x0789f8b6,0x278ffbd1,0x019500d5,0xf4fbfa78,0x168afc4d,
0xd910f010,0xfc4427fa,0x11760b5c,0x282fdabd,0xe794087f,0x1e4f085d,0xf362efdc,0xd7562c27,
0x12ebe50c,0xfa24f4d6,0x088009c2,0xfdb2083e,0xf60df116,0x02c506ca,0x0fe2e661,0xe4f2f8d8,
0x0f9e12c5,0x0ae0f0f6,0xf2b31e4f,0xfeebf03d,0xfa19071f,0x119f0088,0xf6eeffef,0xf59416d4,
0x1443017f,0x06fef284,0xf2c300d0,0x12f404e0,0x0cd3f261,0xdfecfe2a,0x02090cd3,0x088801a6,
0xec7cfaa8,0x125cfe7e,0xeba5f9e5,0x17870e7c,0xf797f123,0xfddd0d79,0x0a61f78e,0xfcd9004f,
0x03e40627,0xfcb1f8ee,0x02d70a7e,0xee56f5df,0xfe2f14e2,0x0801f66a,0x058e0408,0x09da0458,
0xff57e9f1,0xe9401093,0x009e0c28,0x0ce5dcfd,0xf9b111ec,0x092f0485,0xf1160723,0xfcfdfa82,
0x0fe7f376,0xf523f844,0x10630563,0xfd26ee17,0xfdbb089a,0x001706e8,0xfc05069d,0x0154fb4c,
0xf21705d4,0x0a9b067e,0xfb7cf4b2,0xfd3805e5,0x0e2bf9a6,0xf49c0bad,0x15c4009a,0xf38df0fb,
0xefa5154c,0x122afd0d,0xed21e674,0x04ca2761,0x1d4dea1f,0xfbdbe6e5,0xe62c1784,0x1b74fa3a,
0xe7a2fb70,0x01dd13fd,0x1658efa4,0xea471122,0x0cd505d3,0xf501e6d0,0x0a0e166b,0x1863e68d,
0xe604093e,0x054a0dfd,0x020c079a,0xf776f9a6,0xf7a10b76,0x078cf127,0xff5e0bde,0x0852fb36,
0xfaaff506,0x06100a1d,0x1014f847,0xfaaaf1ed,0xf9360cf0,0x09c2fdc2,0xf46e02cc,0x02e80fc4,
0x0b0ef87b,0xed4c0798,0x0c5b00f3,0xf13cf720,0xfdac0a57,0x1208f5aa,0x014feb27,0xf08c10a9,
0x130efca6,0xee0af4a3,0xfb610a31,0x06f0fcd2,0xf67203a4,0x03e90ae5,0x084bf1e9,0xf92efb4e,
0x022807c4,0xfdb1f87a,0xf8a30722,0x08e4039f,0x0223f92c,0xf76107da,0x0056004a,0x0dfaf9a2,
0xfac7fdf7,0xf9bb0aed,0x0862f6a6,0xfcf706e4,0x07c1016f,0xf86af836,0xfc8a09ea,0x068ef7fe,
0xfac8026e,0x00b200df,0x0598fed0,0xf6d902ad,0x05f2fda8,0xfc7dfe21,0xfa300520,0xfea205c0,
0x0eecfd65,0xfdb4f4a3,0x02240487,0xf90dfe7c,0x0752091a,0xfdd0fe2f,0x02f90011,0xff060139,
0xfe5efc13,0x042c03fc,0x0016fc0f,0xfcb40381,0xff0ffebd,0x04d9fe98,0xff5df84a,0xf7b90a08,
0x08d0f68a,0xf80f020d,0xfd6913e5,0x0c1ef35c,0xf865faac,0x013f0fcd,0x0e8df2f5,0xeab3004c,
0x0b480f84,0x0b46f476,0xf3250841,0x003e01d5,0x0589f858,0xfb0303e9,0x0221fccb,0x01f3fa2d,
0xff270423,0x084601ec,0xf501fd07,0xff5d02cb,0x03740347,0x0429f714,0xf9ab07f6,0x07ba002a,
0xf9edff8c,0xf9bb096c,0x08d4f2f4,0xf93dff38,0x045f08ef,0x008ff604,0xfebd0ae9,0x0530f9d0,
0xfb94f850,0xf9a007ed,0x0a5dfe07,0xffaafe95,0xf9ac0878,0x07f9fd06,0xfd6ffcb1,0xfe670279,
0x0101fea6,0xfb400216,0x01eb01a1,0x00ce01a7,0xff8efef4,0x054afc0c,0xfafcff0f,0xfe9e038a,
0x059efb70,0xf6b50127,0x004c0627,0x0622fdfa,0xfffffeaf,0x02b7fd3c,0x00a1fc6f,0xfc930369,
0x019a0244,0xfecbff9a,0xfd780282,0xffd10413,0x0229fc8a,0xfb80026a,0x02e502f5,0x0377f85b,
0xfb7c071c,0x03d0fd86,0x0196fd10,0x005d010b,0x024e01bb,0xfbad027a,0x00d0013f,0x038ffc9f,
0xfeaaffbf,0x00390386,0x034cfbb3,0xfa85048d,0x056a03c1,0xffc4f6b7,0xfa9703c7,0x0310008b,
0x0164ff99,0xfd540254,0x023cfbd1,0xfc2101b5,0x056200ca,0xfffcfc9d,0xfe0d00fd,0x03bdffaf,
0xfe440004,0xfefd0349,0x01f4fe88,0xfd4501e8,0x02d30047,0xffaffe79,0xfd6b02ad,0x03cc0025,
0xfed3fe5a,0xff7d02ea,0x02d1ff1a,0x0022fe0f,0xfd69022e,0x025f0095,0xff74ff66,0xff3e0086,
0x0117ffc4,0x0106ff90,0x012f01fb,0xfd69fe91,0x00280124,0x017e00df,0x00c5ffde,0xfece0117,
0x0071feb6,0xfed7ff95,0xffd00317,0x0170fdaa,0x0047ff35,0xfeebff91,0xff4b01c8,0xfef4fe73,
0xff7efeac,0x01440268,0x0017fefe,0xfef500a0,0x0164ff53,0x01baffa6,0xfeeb0041,0x002a0071,
0x01720037,0xfec70138,0x00f80095,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_3_standard_DRUMS_scratch[896] = {
0x00000000,0xffe10020,0xff4100ff,0x051efff1,0xe6b20ac2,0xf2cc3238,0x0e21fc00,0x228b1332,
0x13e80555,0x0795fe66,0xebb61c8b,0x1b091620,0x28f6dc5a,0x1700eec6,0x1e130be5,0x0df50d34,
0x2b54d9f2,0xf1770ee9,0xd82d2b4a,0x0b600e3b,0x538ecf69,0x2efccbd3,0x0e8ede80,0xf17214cd,
0xdf5f388d,0x0dc61244,0x1907f617,0xdb4c0067,0xbbc94002,0x07c12814,0x06dd0fd1,0x14aae57c,
0x1856e8cf,0xc7e71a42,0xe922276e,0x0c37fdec,0x364cf4e5,0x01adec16,0x069ee7de,0x2aa3e4a3,
0x4d69c589,0x405e9291,0xfaf0f24a,0xbf05153b,0xa1a0416a,0x89115ae7,0xb20857ae,0xd5d31515,
0x16c3080f,0x2286d540,0x1173c75f,0x599dba50,0x1d18ae0f,0xf669e677,0xda941744,0xeba023e8,
0xdefaeee6,0xde4d2381,0xfd8c0dbd,0x01ddfe6c,0xce301882,0x0f071991,0x0f93b392,0xf405efe5,
0xc1dc0e60,0x04011c0e,0xfd9cfefd,0x0f4f05d3,0xe2eedea0,0xff90facf,0xe3362431,0xd3b628bc,
0x14baf46e,0x2cdfd631,0xe041c2ff,0xe1d5d554,0x2e241b3b,0x1537c638,0x1c77cb4b,0x3acaf723,
0x0a99dcda,0x0f53b695,0xdfdc2b6a,0xc7360de8,0xd2fa18a9,0xf1a5fcdb,0x2ae00c21,0xedfbf77f,
0xdb8cff8a,0x2568f099,0xe6c9faf1,0x257fc5e5,0x34bc2561,0xdfd914db,0xf56fd59f,0xfb73faec,
0xe779d295,0xe0ed2ad5,0x149b593b,0xe07424f4,0x00e9c98c,0x1be3f919,0xfcee049a,0xd17531b0,
0x17613a59,0x079ae80b,0x157fb1fc,0x16b2215c,0xc8a430e1,0x00ac2312,0x03ee03a4,0xd563fe30,
0xfcc2f34b,0xfe3232b9,0xd795dc92,0x2e3af56a,0x3c2510d6,0xe86ceb59,0x05eef5ed,0xc6aff003,
0x0874d8be,0x12223813,0xfab6fd5b,0xd8d4f90c,0xc58a0c7c,0x2282021d,0x4beee6bd,0x3851e9f2,
0x0cf5a826,0xdaebd387,0xfa121d34,0xe14e1477,0xe100015e,0xf2c20080,0xf4ab0d04,0xfc01ec45,
0x101b0bd3,0xd4861878,0x1125e616,0x02820465,0x15efd75f,0x2beeece2,0xfa95cefd,0x42f1d73b,
0x07411baa,0xd295c611,0x204f3769,0xb2171f0e,0xec210ba8,0xfb6e4575,0xcb5409a7,0x17733300,
0xf70a170a,0xf9bde3fc,0x106ef8f7,0x00ce0374,0x053c2e01,0xd69f38a0,0xe1aae23a,0x2d173a52,
0xe026009d,0x07170ff7,0xc67b2941,0xefbed8a7,0x652feff6,0xf9061229,0x1e1ce2ab,0x1c6cfa17,
0xdd92e1c5,0x2cdd141e,0xde740beb,0x0ef7fee1,0xe5b01235,0x0764d442,0x0d042bfe,0xdca1fb17,
0x21b6fe85,0xe4670f6b,0xe64cdca4,0x3772037d,0x0e841742,0xce43dfef,0xde2ef467,0xf2cd354f,
0x17fc0037,0xf3fe184a,0xdeeed7e5,0x1549f635,0xe1da12cf,0x2c83f99e,0x1cd43fa0,0xd345a4c5,
0x27f4c5a4,0xf14c38c1,0xfa93cb20,0x3cde3909,0xbf7ffb63,0xf8a1e175,0x02cc37d1,0xda7be1b9,
0x2edc1d22,0xe02e0ce6,0xf95fc81f,0x2a0710d6,0xf7fbf56f,0x37ed09e0,0xf17e215b,0xea1cccf3,
0x1ae7ff5d,0xf05cf0e0,0x1ccb16ba,0xfdc215e1,0x0694de7b,0x0818fbd4,0xf495f01b,0x124b0dbd,
0x14a11cd3,0xf9080a99,0xeefee463,0x35eb08ca,0xfbddeea4,0x0a61f4c2,0x07901ecf,0xe4e1e455,
0x30ea1629,0xfce9fdb9,0x123f0bd1,0xff190b80,0xf3f90104,0x228a075c,0xfa21f75d,0x0111f3a5,
0xfbece1ee,0x020af933,0x0910f400,0x0e00ee23,0x362035e9,0xa3ac0988,0x0150fd9f,0xe3ed3cbb,
0xc1c0d232,0x3d6d0e6c,0xb7dd1cff,0xe8b4d539,0x36334842,0xe981c7d6,0x36f5fb66,0xc86c2926,
0xea43ca70,0x2c7c2934,0xbcf5f3af,0x4b81fe2e,0xce102515,0xe239e826,0x25340bd7,0xdcc60319,
0x2daafda6,0xf0da21c5,0xf1f5033a,0xfb6e03a0,0xf164fd59,0x270913ed,0xe591f4b4,0xf6aa0a3b,
0x0872eb96,0x0c9a0080,0x1fb0ef07,0x186a26f4,0xe6d3e6b8,0xf91af51b,0x08db01c8,0x301ce2cb,
0xfbcb0bfd,0xe666f113,0x16a2f467,0xf983fe97,0x4a750a1a,0xeda52aa1,0xdf07c74c,0x14540488,
0xc913dc0d,0x20363faf,0xe7e31f1a,0xe3c3f10e,0xea70dba4,0x24b01aa2,0xfd3408b1,0xf31117a5,
0xe95f0033,0xe495c35b,0x3a0f00d3,0xf0f1f4ea,0x22781233,0xc2eafd61,0xf31dcd41,0xfc9e5667,
0xfe99b5ae,0x32cb30f0,0xd5aedac8,0x01ecec6d,0x09ea3f71,0xcdd5e2b2,0x2c741090,0xd39d0e86,
0x0743076b,0x1e1923e4,0x0287d786,0x2873efef,0x0800fc7f,0x0467e001,0x059d3dbe,0xe6dfeea4,
0x18521531,0xdaa4f92e,0x22b90dc1,0x0ae7d0ae,0x07dc0ba7,0x2d5c0df5,0xe2030137,0xe2470a61,
0x05f3013d,0xd1c7eb7d,0x3f5710ab,0x0d3bfbb8,0xe3f91e3a,0xfbd0dbcb,0x39cbf02f,0xd4eb11f7,
0x319de792,0x9e93399b,0xf7e3dd58,0x2b0f41ea,0xaceef27c,0x4fce16f0,0xba87e565,0x0ef6f565,
0x2bd70b08,0xf4060297,0x1b2df581,0x2c86fb80,0xd90be0a7,0x20bafb39,0xcbfedf6c,0x1d5127d4,
0xf8891e90,0xd8173a08,0xf599ee87,0xd2adedc8,0x3208ff67,0x314228f2,0xbc8cfff8,0x1a4dfa51,
0x00bfc519,0x2e0923f7,0xff11eff1,0x1a50e9fd,0xe9dd1544,0x3ada07d5,0xf028edb5,0xf90514f8,
0xda9ec414,0x205435a8,0xe1a7125c,0x41e10bc0,0xb2c8d2da,0x4ac02bc3,0xb2c0e846,0x28e00027,
0xd0a9f29e,0x265a352a,0xbefc0d2b,0x39c9047a,0xe46cc5d4,0x3720ebc7,0xf06d0e74,0xe6e2192c,
0x07fef078,0x0aeaff6d,0x09d6fcd4,0xf2d511d2,0xe4b8dc8d,0x263c1f22,0x099bea59,0xf46e01a9,
0xf0c0109d,0xfbc0e489,0x2d390d33,0xbb9f16a7,0x1fd60287,0xf928f83f,0xfe6f0ac8,0xfd5eea0c,
0xe5041fcc,0x2939f213,0xef9d2d68,0xfd5ee050,0xfc6a100f,0x02a3ce0e,0xfe992ce7,0x2907d772,
0xbd6c1c16,0x3ecaee67,0xdaf5243a,0x2247dfcf,0xdc72e888,0x2c85ebe1,0x2428eb78,0x018b0593,
0xa5fb15f4,0x16322680,0x031dbe84,0x006b32c6,0xd02bf940,0x11cd19da,0xf88d21e1,0xd293de9e,
0xfdc71c25,0xe984f120,0x39b72d25,0xc5b00bf4,0xd5d0d89a,0x53ffff8e,0x14c4e93c,0x01ec151d,
0x00a2c26b,0x2b58010d,0xff511ca7,0xdd71de77,0x15a2ee09,0x0a9411d3,0x41fbfd86,0xac2f02d3,
0x1768de87,0x11472aa5,0xc94414d6,0xf15addc1,0x088b0c86,0x201e0c51,0xc0641cf7,0xdb9eea7f,
0x36d8090f,0xf438eba0,0xed341a66,0xcf9c1730,0x1b2eeb8e,0x1e9b05da,0x107fcf27,0xf93ffee4,
0xe6fcf302,0x37f5e4e4,0xfb7bfbb5,0xee70f7c2,0xd3d516d6,0x0cc6f42d,0xfca80860,0xcb0c1054,
0x11fa14b9,0x0212fba9,0x234db5be,0x1ac2294d,0xe3acdfbf,0x1c4afcde,0x11a2ef0a,0x0651dcd9,
0xdd2f3d6e,0xdb8e232a,0x084a1d75,0xc70804ee,0x0914f9d5,0x1acd2cc9,0x1804d363,0x0b110fc9,
0xdf14e919,0x01b20764,0xeb470cbb,0x02f01cbb,0x09f62d01,0xe5b0c9cc,0x47a7f47e,0x1685e54c,
0xf0ded3c6,0xf3c819af,0x1a07dd58,0x233f06a3,0xd8d7e301,0xc76538b8,0xc43142e1,0x2ca2e040,
0xfd6efff5,0xdcc7f802,0x20ca1d2e,0xcc011f2c,0x22e9f8f4,0xe27fd8fd,0x3776eb90,0xff851475,
0x129af79c,0xe61dfd88,0xee001a4e,0xefd1fbbc,0x0b071698,0x2a25ed0b,0xe3480bfd,0xfedcecaa,
0x3d6aed45,0x33e7b257,0xdce83dc7,0xe789e888,0x089c0836,0xfff1ea0f,0x12fb2129,0xd44b1381,
0xfc5af18d,0xd4a60bf6,0xe47f25c5,0x183135ee,0xb5e52da8,0xfb32f03a,0xf60aec62,0x22a9df7d,
0xdff53bc8,0xd9fa1b1a,0xef7d1fc2,0xff95bb4f,0x19da3045,0xe16608d6,0x0c7df293,0xe1e10492,
0x374ef5c1,0x08f20241,0x07b2de59,0x2204fcdd,0x2856b13a,0x625fd16f,0xd637f57d,0xe2482241,
0x10010b2e,0x12f0ea42,0x016e0da9,0x08f7fa95,0xed9802de,0x2b33f12c,0x17510b75,0x3476dbd2,
0x2534e597,0xe954d096,0xfb352646,0x36ad00b6,0x0c64f63f,0xd8f9ea10,0xe04a2803,0xfae02630,
0x08db2027,0xbd73ec83,0x3bc82256,0x0041cf63,0x3f9602aa,0xb1f51a68,0xf7fdeec8,0xf3e63ce4,
0x1f50d119,0xfd832af7,0xd160ffb0,0x111126a8,0xedbfdcce,0x36020800,0x10c5de3b,0x2af8fb0d,
0xcd05fb20,0xff7b08fb,0xeb7422d4,0x0eb312c1,0xc5931342,0x04c40865,0xe52a23f4,0x1d8f1ab3,
0xc93114a9,0xc8c10cce,0x28e3079f,0x35bef53d,0x377ccbe1,0x148fb40a,0xfc3bf890,0x1a660571,
0xf66a1a7a,0xca3d0c98,0xcbd909e5,0x23341a22,0xdf95245c,0x0d3bf8ce,0xc937074e,0x31a4dfa1,
0x072530ea,0x0059dd0e,0xd33e130e,0x27f4ddc5,0xd03e329c,0x015c16fe,0xd0e81f1e,0x1020c4a3,
0x22c43345,0x20fac288,0xd0621902,0xef5be644,0x25012a2a,0xf289efea,0xd99c1bc4,0xf01af613,
0x11e8250d,0x1668e66d,0x0f00eed1,0x1665bdd2,0x255401a8,0x11b6f76b,0xdd6a0c00,0xdf05e82e,
0x175920f9,0x16b1f53b,0xe020fdb5,0x0e6bee62,0x160cf65a,0x0b5efc91,0xbf9a131b,0x121c1638,
0x0209dd58,0x1be11077,0xe55de10f,0xf223275f,0xefa3ef17,0x114634cd,0x0466be77,0xf957187c,
0xcb32f77e,0x06945d16,0xecb2bdec,0xdc9050a5,0xed12d929,0xf2ed3f02,0xd6560f46,0xeb442ffe,
0x11e0d41d,0x0db70aa1,0x0f3cff53,0xe48b09af,0x1c5ada60,0xf8650075,0xf30c1e36,0x0e7607a4,
0xf2a3cc62,0x263605c5,0x04751011,0x1abfd319,0xdfa5f56a,0x467ff5bc,0x01a4faf6,0xc9e4fff3,
0xfc17f6e9,0x38210715,0x0fd6f6cc,0xdc57f42e,0x105acc27,0x24f81ce3,0x3c76dd6e,0xee7ac55a,
0x3c6dcf66,0x14a7f5f2,0xfa9d0d26,0xc889ec9c,0x152c1c72,0x2279ff5d,0xfee6f2e5,0xe7b6c8a5,
0x055c2c3a,0xf2701629,0xc1241e65,0xc1f1177c,0x008f44d0,0xffdcf5a4,0x12d0ebb1,0xef5f01ac,
0xe4b218d1,0x032505cd,0xfc581b64,0xdfc50c21,0xf1ece36b,0x00f01948,0x03d225ec,0x1195ed22,
0x35b5b75d,0x2071e315,0x017cf9fc,0x01c0f9eb,0x2313d0d2,0x1f9cf341,0xfd0efcfa,0xf283e961,
0x043bfdf6,0xf9641668,0xf7660694,0x2427dfa6,0x0aefefb2,0x0a76efe1,0xd2f81482,0xf9271f3b,
0x1891ea5e,0x244dde7a,0xd4a715ad,0xfd2d1abb,0x33ffc71d,0x32b7db0c,0xc8df09bc,0xdc622808,
0x191c0e14,0x239ef240,0x3693a9e5,0xf4b2ea1b,0xdd9040a1,0xdf3208e2,0x0e6a07d4,0xd0fd223a,
0xf81a0be9,0x1b86ed41,0x07160ca4,0xf2aee485,0x143c0033,0xf670055d,0xe39c18ea,0x31f1d88a,
0x0daaef7c,0xfe8afbf7,0x240aef51,0x2169d247,0xea9ff283,0x118b00e9,0xeb15115b,0xfee508b2,
0xec6ff9b5,0x28140270,0x1cc5cefa,0xf21eebb3,0xc51330e1,0x26eb145e,0xfe75d861,0xd3411d5b,
0xf8460b5a,0x0c9e0ab1,0x092ceb87,0xf3541571,0x130ae253,0x1d00f84e,0xe26b0344,0xde7216e7,
0x1b8e0f14,0xe2e8f438,0xc7a549e4,0xf9cd05e4,0xe4531011,0x12790d00,0x16fd05e5,0x3141c558,
0xeab2fc2f,0xb1333781,0xca694499,0x3393ec61,0xef40f447,0xd2692537,0x0df71519,0x0414e3f7,
0xf3f01f57,0xdb4b2f36,0xe445fad9,0x06cf0fa2,0x29e4fc00,0x0b77fdef,0x2cb3c11f,0x1395e2b7,
0xcb6c0bbf,0xd79e4088,0xe0231fc9,0x0fb4fb12,0x030fe8b2,0xe87635b6,0x4221d55d,0x226eb913,
0xccf50a11,0xd5153f6f,0x21410063,0x2e9bd17d,0x5083c2bc,0x2dd9a14b,0x0fc20185,0xdf69faef,
0xddb524c3,0xe2ca173c,0xdc1d2f97,0xed3c1e5c,0xf9bbef90,0xe14129ed,0xf0021112,0x0475059e,
0xea9a0ca4,0x03361ac8,0x494db99b,0x2cdfd5ab,0x05e2e4ca,0xe3d71506,0x1e410ea0,0x4599bc3a,
0x1482bd57,0xe7672d70,0x0655e7ae,0xde5f1aca,0xdc953772,0xea3b0bd8,0x040b0724,0xefdb26fe,
0x27b2023e,0x2104aea0,0x3856e170,0xdeb8fd7e,0x19cc236a,0x1a4fc177,0xe92803dd,0x1a7509d1,
0x209df007,0x12f6e16d,0xdcd10212,0x2493f479,0x0919da93,0x000000b5,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_4_standard_DRUMS_guitarfret[1792] = {
0x00000000,0x17361ac6,0x05fc120d,0xf4f8fbfb,0xe107e5e6,0xd813dbd6,0xe0d8dbb5,0xf0c6e800,
0x03ecf998,0x0f8009da,0x028e07ce,0xf023fadc,0xe4cee648,0xe44fe293,0xf052e7b2,0xf67cecb6,
0x00c3fc27,0x07a80679,0xffff014f,0xe81bf287,0xd576dc6d,0xcb5dd0c8,0xd051cb98,0xd7d7da76,
0xe91be2fd,0x01fff780,0x062f0d2f,0xf6090361,0xe2e8e9e6,0xd64adbd0,0xddcfd702,0xe8fade40,
0xf649ec79,0xfbb4fd81,0xe923f4ff,0xd17edb04,0xcb40cafe,0xd17ccab6,0xe39cd773,0xf956eca4,
0x076b036e,0x064f0ea3,0xf42efbf7,0xda84e271,0xc606cc6c,0xc67fc4a9,0xd591cb5b,0xf5c5e073,
0x05f501f1,0x03570992,0xf119fbfa,0xd74ae49b,0xcea9d105,0xd162d1b7,0xe0c3d984,0xe470e50a,
0xe455df9d,0xe68dde90,0xe8aae6dc,0xf0aced52,0x076c0035,0x09ff0c80,0xf1df036c,0xd252e308,
0xc043c71a,0xb8aeb864,0xc999bcf4,0xebecd79a,0x0a3400e3,0x0ae40fbe,0xf9c5071d,0xdfa3ed7b,
0xcbc2d3cd,0xd2fed155,0xec08defd,0xecb0edd9,0xe1dde6d7,0xd9bcded3,0xd769d7d0,0xe648dd21,
0xf99bf05e,0xfae6fd1e,0xeb53fb39,0xdbc9e43a,0xcd4ad4e7,0xd605cd58,0xec1cdb6d,0xf769f380,
0xfdf5f9ca,0xf153f617,0xd340e6b9,0xcf61ce91,0xdf04d5c5,0xe8f2eb83,0xded7e3ca,0xe184e0d3,
0xdf45dd43,0xf0dce4b8,0x0864fa3c,0xf349ff68,0xd8f2e9b3,0xcd87d2ce,0xb85dbd5d,0xc7e7bbca,
0xeabcdcde,0xfe7cf9b6,0xff51fe1b,0xf02afddf,0xdb51e0ab,0xd7d0d2f1,0xe110dcda,0xd67be300,
0xd30cd825,0xd176ce66,0xec93de75,0xf919f81e,0xf63ff8d9,0xe894f224,0xd138e19d,0xcb81ca01,
0xdc7bd04a,0xf0e2e5af,0x01e7f08c,0xf4c003d1,0xd4c2e382,0xd925d532,0xe32adb7b,0xe623e814,
0xf9f5fa84,0xec0cf575,0xf5ace6a7,0xf6b9f8dc,0xe08df02b,0xe2c3deb9,0xe106de10,0xd66ad817,
0xed8ee170,0x044cfdd5,0x0c5a095f,0xf97202dc,0xe931ecba,0xdfcfdebe,0xe077ddae,0xe50debca,
0xdcd4e6bd,0xeb53dedd,0xfee6f612,0x08340494,0x0b470cbf,0xe80df6fa,0xdbcacd20,0xe874e912,
0x02e7f5db,0x131411d3,0xf5540847,0xe281e153,0xf07fe774,0xf613e9ae,0x06c003e9,0xf5f00517,
0xe541ecd9,0xf0b2e927,0xf7a2f17c,0xee26fcea,0xded8ee24,0xed1deaa5,0x093ff591,0x07fc0753,
0xe941fa0c,0xde28e059,0xe5a5e72f,0xfc16ec2d,0xf8ac01fb,0xf2b0f2f1,0xfb8bf1e3,0xfcc4f64f,
0x0cc9fd4c,0xe044f328,0xdb85d8ff,0xe9c4ec0f,0x0030fdad,0x0edf0add,0xe9cbf986,0xebb6eeb3,
0xec4fec20,0x0202f762,0xfa02fa3f,0xe49be1b5,0xf23ee8b1,0xfbf5f9af,0xeee0fe24,0xe49debd1,
0xe94ee796,0x037af949,0x007ffe51,0xf3f4f33b,0xe17ced1b,0x0039f420,0xffc80e9f,0xf2f7ef87,
0xecbfe942,0xf839e4fe,0x04230420,0xd937ed01,0xfc5aed11,0xf2acf226,0x090c02f6,0xebb60e06,
0xe394de09,0xf4fef142,0x099ef679,0xfa8808a5,0xdc97e4d4,0x0265eec1,0x054f0c1b,0xfbb10e8d,
0xf691f413,0xe7e8e511,0xf7f1ff9f,0xf6a20198,0xeedfee71,0xf356e8dc,0x1985064a,0xf1ce0e0c,
0xe6e5e6f2,0xf573ee37,0x0b8f0898,0xf6490fc4,0xf8a8f626,0xec66ed6f,0x056bf943,0xfec40b36,
0xf5e2f1d6,0x0643f92d,0x09c1097a,0xe6c3f504,0xee57e45a,0x1458076e,0x08e90d06,0xfb8f0aba,
0xebf0fd42,0x03c0f509,0x05c40db7,0xec78ffb1,0xf621eeac,0x14c61261,0xf1870719,0xeeceed07,
0xfedff8d6,0x05fb0b87,0xf7ec0071,0xde06f5f3,0xfef9ed57,0x1a0e1c9e,0xea6405f4,0xf461f3bd,
0x15c308a3,0xf6dc084d,0xedaff3d4,0x05b20a17,0x00430b4d,0xf3890e6f,0xdc45e589,0x1172f35a,
0x07d60d05,0xec0aff51,0x001fe6ef,0x05c7160e,0xfaa9f195,0xfca6012d,0x0e20f3d8,0x07f30b62,
0xfc69fac8,0xef76f582,0x18410ada,0xe41f026a,0xfee4d88b,0x0910074d,0x11031851,0xedae0289,
0x076fff87,0x059b0ac9,0x095527ce,0xf5cfebb8,0x2b720ae3,0x00840a17,0xe5e2ec20,0x11eefbd5,
0x1559264e,0xf849033c,0xd9b7ed7e,0x05cff44d,0x0835240f,0xfd02fe8b,0x070bf783,0x0ae013e0,
0xdb40dfc6,0x1196fc77,0x2cc80d3c,0xf92729e3,0xf002e58d,0xe5cce69a,0x222a20ef,0xf6340512,
0x11171b62,0x053ef8bb,0xdd43f7a5,0x1d92def2,0x1f5620ae,0x261523fe,0xc601e7ec,0x0684eb42,
0x0d4d0ec6,0x101a225d,0x034a0623,0xf3f40b3c,0xf8cbce28,0xfdea0031,0x38080bdc,0xe91b10cd,
0xf587ea0e,0xf31addc2,0x14222477,0x12550116,0xed8e211e,0xfd8fe6f2,0xe94ef99b,0x218610a3,
0x03b90e32,0xfc1b0e57,0xeb6ddd92,0xff50fc38,0x21df07d5,0xf4a91b95,0xf68af1a2,0xed37f8cc,
0x0db007dc,0x0f94052f,0xfc701910,0x03d1ef2b,0xef20f286,0x25f60921,0x0913107d,0xef1300bd,
0x0dfff789,0x03e50706,0x194e10e8,0x07b90353,0x09cb0434,0x01d4ff13,0x193c0962,0x1bc617a6,
0x00cb12cf,0x162e0c68,0x1db10cee,0x13f92607,0x1f0101ea,0x0c1b0e4a,0x0aa9202a,0x342a181f,
0x13a429fd,0x0ae01898,0x1ed00543,0x2bc13242,0x172d23d1,0x250b2486,0x1d4b321a,0x1c17162c,
0x36b739e9,0x2c013a62,0x05bb15a2,0x36682926,0x352b3491,0x16f21bf1,0x3cf23c49,0x26d00617,
0x23fa1fb6,0x3b364fe1,0x289723ab,0x198b2353,0x3a284dc6,0x230e2e7d,0x3a8b41c2,0x1d0e44fd,
0x2ba91939,0x3b28409d,0x27973d14,0x225a1cc6,0x462d3a1d,0x1f602b50,0x393f2429,0x1d0e3b4e,
0x27300a42,0x4970331a,0x1fa439d6,0x18ee1af1,0x443c226e,0x1a1726c9,0x32b22092,0x2a9a2f21,
0x0fde01bc,0x312337d1,0x2172389f,0x0f43fe20,0x2ca50d9e,0x1d582b30,0x335a1d58,0x1b9a30c0,
0x0554fd06,0x35e31daf,0x115b3549,0x073e01c5,0x220b0372,0xfcbb214b,0x29861cfa,0x1d6d17b4,
0xf21fe8f2,0x1e2a313c,0x1bab30b6,0x06e6f275,0x114409df,0x06750e57,0x22ac016a,0xfddf26a1,
0xff33f7af,0x2e16180a,0xfe6b2667,0x001a03ab,0x2133feba,0x054008f5,0x0e1a2848,0x0a101591,
0x120ada7f,0x18ea1de5,0x03fd1d18,0x167df57c,0x0fef0ec1,0x09cc2637,0x22b62352,0xf6af09f2,
0x14f2fb64,0x315b283d,0x0c0c0962,0x01481355,0x19281de9,0x36a10699,0x23ab11c4,0xeb9a1341,
0x2d7f18bb,0x3327238f,0xfe4d090c,0x018e25ef,0x1f7e2548,0x3bda0b75,0x10bf1bd7,0xfe79127e,
0x35723750,0x193d2f05,0x1ba61785,0x245a212a,0x21901e06,0x2be02831,0x1a841a85,0x326e04be,
0x2eb33cd0,0x0de622d3,0x31ea1d00,0x31492622,0x29262938,0x24f22475,0x23eb175f,0x426637b9,
0x1f04368b,0x137314ef,0x33fa3f92,0x2fdf4ae5,0x2dfd2345,0x243b0ff1,0x3c3c319b,0x3eba549e,
0x0ff8152c,0x37500ab1,0x44fd477e,0x2c3140fb,0x09df1b93,0x2bd82cd1,0x60f74b64,0x2c3f32f7,
0x00a2f3ea,0x3ff44448,0x44b8684c,0x221428db,0x1e5fffc4,0x53033ceb,0x421065b9,0xf3131cda,
0x37c10ad5,0x67105f75,0x3f403adf,0x08aa0573,0x31db2474,0x64617e23,0x250341cf,0x24b1e5b8,
0x5a233908,0x30ba7154,0x0842382c,0x20c0124e,0x744d42f1,0x388a6284,0x10d9fd8f,0x4bcc2450,
0x4d7a6c44,0x202545cd,0x2a270adc,0x6fb11e2f,0x522c6f80,0xf1f32436,0x384e2efa,0x62ec5b9f,
0x41504481,0x15301533,0x47992158,0x5b717728,0xfd1a3a28,0x31ca1cd6,0x60d64be8,0x533b4316,
0x168f2572,0x327c129c,0x653b6d24,0x12a63f38,0x31461070,0x4e483f6d,0x52444740,0x17f6357f,
0x2a12099b,0x655357ed,0x27293b3d,0x2ec013d0,0x42cc36dd,0x48cc455b,0x1d9e3f2c,0x269014e8,
0x5d675293,0x26dc36c7,0x320b20f3,0x300b3a09,0x4193464a,0x1da83f74,0x2e9d1ce5,0x504550bd,
0x1c932fe9,0x383b21ec,0x32fe30df,0x421b3ae3,0x1526326e,0x301f1fda,0x4230578a,0x18f12330,
0x3b5f23f7,0x3272304f,0x3a6f4032,0x008c2aa7,0x3de0220b,0x393c540b,0x153319d4,0x2e1f290a,
0x307d26a7,0x3ec43afb,0x04ec1726,0x3c0c2352,0x22005563,0x1bef1718,0x329a253f,0x34a21997,
0x33973950,0x00540dc9,0x46b2239b,0x1f114755,0x1be40f7c,0x225d31d5,0x2e6e227c,0x2f343b51,
0x06be01fb,0x477b264c,0x050b4125,0x19ab15da,0x1cfa304d,0x328b1a70,0x20633813,0x085e01c3,
0x43702fa9,0x05062677,0x20e80953,0x12b12b9e,0x21c722e1,0x0e803367,0x120c0213,0x39b73320,
0xff621b07,0x1ed6107d,0x12092835,0x23f321c7,0x064f2125,0x17dd080c,0x2b783392,0x02d60cd8,
0x22961105,0x121e2572,0x179623c2,0xfbed155e,0x1b9315ae,0x1ed83027,0x0639ffea,0x27f20fc4,
0x12cb1bdd,0x138b1a5f,0xff0a0b79,0x21b21cde,0x0b613072,0xfeb802a8,0x21a01df6,0x16d31b4c,
0x0aea0e0a,0x06380b36,0x218f24f9,0x013425b1,0xff2f02a2,0x1ec921b2,0x12161f88,0x01e90b65,
0x14740bc4,0x24862933,0xf7ff151f,0x08a50178,0x20221fd0,0x0cff1f7c,0x078e042d,0x20a50894,
0x1b602145,0xf53208fc,0x0e5f0699,0x189526c2,0xfa17197f,0x06b3fa2b,0x25110e51,0x17761d04,
0xf4e7fed6,0x18ad0e09,0x1a592c34,0xf6bb0f87,0x0fb8fd4c,0x1e1c1d1e,0x0a271d3d,0xf92df87a,
0x25e30a7e,0x132b27c6,0xefde0368,0x109c0ab7,0x13732144,0xf8901bcd,0xfb21fc94,0x2eb517f5,
0x0fcb15ab,0xfb0fe972,0x169807ea,0x02152591,0xef631ef5,0xff7df97a,0x2a192475,0xff2e1316,
0x0346eeea,0x17ef1416,0x157816a0,0xf4ce0187,0x11e3f209,0x18c92de9,0xe8640f51,0x0824fb6e,
0x215c0b33,0x167d081c,0xed78eea9,0x1f36f7d2,0x11a723b1,0xf1a8ee48,0x0dd5fa17,0x07af1665,
0xfb4d1ead,0xe7b2f332,0x314c048a,0x0aa50bc7,0x0657e222,0x109dfcd3,0x10700fc8,0xeb341146,
0xe8ebe358,0x18222271,0xec7b0dbb,0xfafcf4df,0x0965010e,0x13b1042e,0xeda8f14f,0x0286e200,
0x051727e3,0xd8c50354,0xe82d084d,0x051206e0,0x06b30a31,0xedf0e6fc,0x1cd1e864,0x07060c57,
0xfb2bdf56,0xf549f334,0xfdf50bcf,0xe0e113c1,0xe0a3f4c4,0x1f1efc28,0x0375f849,0x1263d3c2,
0x05b0e618,0x07afff51,0xe147fc16,0xeb34eeb7,0x02401582,0xe285fcf4,0xf9a1f8c7,0x0373f4a8,
0x106600ca,0xf30ee4b6,0x083debd4,0xfaa01029,0xe282f9d8,0xef7f0d0d,0xfbf0021f,0xfb340b19,
0xebc7eae6,0x0e1bfea3,0xf968ffac,0xff3beafd,0xf5480221,0x0050fb5d,0xe4e10aba,0xf227ee63,
0x04131273,0xf121f892,0x028df0a8,0xfc6ff41f,0x0db4f8c4,0xedd0f01a,0x03fbee6b,0xfc4d08c8,
0xf372f51d,0xf231ff85,0xf85df482,0x002b09b3,0xf2d9ec52,0x0f9cfa38,0xf4b0facc,0xf7cff845,
0xed1d003f,0xf8b4fedf,0xe2100da3,0xe83eea6b,0xfe7c0681,0xeb91fa54,0xfcccf204,0xf9f3e703,
0x0579f0fe,0xe27bfd88,0xecf2f060,0xed9d09d8,0xf16cf6c7,0xf3f4f95f,0xfac0f34c,0x067ff3ec,
0xf2dee549,0x0632dcb8,0xfb77eb97,0xef5df694,0xe36df8b4,0xf1edfd5b,0xf67df7cf,0xf000ea5c,
0xf84dec42,0xf5d9f093,0xeed7ee6f,0xeb8ce614,0xea08fc3c,0xdecdf851,0xdc56fc8a,0xf3edf4a6,
0x0264e978,0xefd8e4c9,0xfe61d430,0xf182fcad,0xe925e827,0xe0f9f773,0xddf1f5c7,0xeabdfffe,
0xd0cced89,0x085ae45a,0xf35aef87,0xf4c1d7f1,0xeb67e267,0xe9e1e997,0xe5e5fa31,0xcc03e582,
0xf89ef402,0xdceaef09,0xef09d874,0xea9ee4f7,0xf265deb2,0xe3e1ec53,0xdefac88e,0xf9f3f2fa,
0xd9b1de4a,0xe3d5dc5d,0xdfc3e397,0xf7d3e2af,0xd44ae4f3,0xe145d042,0xef5eff65,0xdf3bdb06,
0xf2efcfac,0xeaa7d8b5,0xf03ce91d,0xc3fee245,0xebb6dcd1,0xe700f9d5,0xda62d614,0xe425df1b,
0xe90bdfef,0xf180e93d,0xdabec9be,0xf82edbfd,0xd826f654,0xd225e431,0xe693e6e4,0xf9c7e28d,
0xe6a8e517,0xd64ad306,0xf819e9fd,0xe4deece9,0xe0bcd383,0xe32ae06d,0xeea4edde,0xe2cdeb53,
0xe2a0ce95,0x0208e803,0xddffe59b,0xe426e037,0xe4c3ed34,0xf779ed01,0xe53de650,0xec74c318,
0xfd4af0d5,0xd974ef29,0xed7fde77,0xf724e6bc,0xf49ce481,0xe145eff0,0xf310ce7a,0x0dd3e7d0,
0xe407e26d,0xe431ddfc,0xe4060124,0xf517f724,0xeefbf1a2,0xf980d79d,0xfa6ff578,0xe1ffef6f,
0xe3d5ea97,0xf380f4a8,0xfacff45a,0xe23ef1e3,0xf36bea38,0x0665fe65,0xf559f090,0xed93f45b,
0xe6a00290,0xf4d4fdb8,0xea6efc4d,0xf9bedf2f,0x07adf656,0xe82a01c7,0xef0e042b,0xf3b0fe25,
0x05f1f9a8,0xf412fbbb,0xf579f02b,0x0c6dfdfe,0xfeadf4f1,0xf73bf650,0xee7ffe38,0x0cfb0813,
0x006ffdaf,0xff81e347,0x0c1bf78a,0xfc3105d1,0xf6f3f64a,0xff55f04c,0x0c55ffc4,0xf6970a76,
0xfbdaf510,0x13e8f459,0x07bd0853,0xe633fecb,0xf2de0819,0x110a14a0,0xfd2501ff,0xf78bee38,
0x00de0502,0x04be0c8b,0xee15fa75,0xf9caf057,0x117e16aa,0xf8c70ffb,0x0595e69a,0x0f46f7c5,
0x024c06cb,0xe2420b16,0xfb7df4ba,0x2544073c,0xfe0afaa2,0xf36cebd1,0x0aa70d27,0x147a091e,
0xf66bf8ee,0xf20eefd2,0x110f0f5b,0xfceb05e4,0xf5e9e39c,0x046403c5,0xf8f71763,0xfab106a5,
0xfc39ea4e,0x0bd60428,0xebba1865,0xe593ee7b,0x0e3afb9e,0x06a901a8,0xf4d2fc31,0xf0d4f063,
0x122cfac2,0xff5808c5,0xe19aec72,0xfeafff40,0x025a0b1b,0x0220f412,0xec7ee868,0xf50ffd0f,
0x01a20d73,0xf326e526,0x075be03b,0xfb6f0ae7,0xf05701c4,0xf146ed7e,0xf5ace8f9,0xfbdf07aa,
0xe3a3fccc,0xfa50df00,0xfec9fae6,0xe766fef0,0xf0bcf550,0x003fe40b,0x00e3f8ed,0xddef0498,
0xed31e504,0x0c36ee0f,0xec76f0ca,0xe09df7c1,0xed6ff154,0x01a1ec8a,0xeb59fc83,0xdc1bf0ef,
0x04cff24a,0x013fee86,0xddccf3de,0xde2cf958,0x06a5e7b1,0xfcc8e536,0xd474e964,0xe0a3ff65,
0xfd25f857,0xfbdfeb79,0xe2b9eb6b,0xf121ec26,0x0626f435,0xf3a2e62f,0xe6dce511,0xf39be93a,
0x0720e8f2,0xe5e2eb19,0xd6c5ed72,0xf8dffcd5,0xfbe6f260,0xe458e488,0xd917f1f1,0xfe49feac,
0xfe25f7ed,0xe03adc9d,0xe83fe60b,0xfc7703d9,0xeac3ef35,0xe952dc97,0xfde9e4fe,0x0635fcda,
0xdf15f03e,0xdf4fe082,0xffd7f090,0xf4b205d5,0xd6d2ec1c,0xe329ea12,0x03a102cb,0xee5d09d3,
0xd7ece4b6,0xf3dee9ef,0x107b08c1,0xe83fff88,0xd83ddede,0xf854f4c0,0x087d1276,0xe1a7edc3,
0xe32adba6,0xfdd8f6f7,0x0fb80d25,0xe375e8d7,0xe7abccf0,0x0d830324,0xf81c1398,0xe9d5d939,
0xfa64d6fb,0x0078f6f3,0xf33b1a84,0xd61fe388,0x0523cb16,0x16f50a16,0xd33d0e10,0xe7dedcb7,
0x076ce697,0x0cdfeeea,0xeb8c1917,0xd183dbc5,0x166ce130,0x10b80b36,0xd37dedb7,0xe5f2dbdd,
0xf8c8f924,0x14e4f260,0xe96effd9,0xcd01dbff,0x0a42f427,0x0a0b0390,0xd3efe141,0xee3ee9e9,
0xf67afcb6,0x0ddaf272,0xebb8f7bd,0xda13d739,0xfe4cf0fb,0x09470775,0xdd2ce1c5,0xec44e09a,
0xea64f96c,0x047cec9e,0xf0b9fdd9,0xdb85e186,0xfd65dea3,0x05040437,0xd96cf0b0,0xf25bdada,
0xf03ce6ec,0xfaf4f067,0xf749086e,0xd6abd9f1,0xee19d313,0x0c1e0ae0,0xddc9f3cd,0xe09ecf21,
0xea6de1f6,0xf9a6f5be,0xf5370319,0xd444d546,0xe826c889,0x07690ec4,0xe1750579,0xd376c9af,
0xe517e3bb,0xf1efffee,0xec8f0a21,0xc100e37c,0xdab0cf2f,0x0a640187,0xe3230535,0xcc66d5e0,
0xf298d6d6,0xfecee747,0xfb68fd83,0xc6dce94b,0xdc9fca1a,0x0734f2b5,0xe17f0eb6,0xc2c7e6e2,
0xe4c2d9db,0xeb85ed2d,0x041dffc7,0xe382f2b0,0xd3d6c79a,0x051de2ff,0x06420380,0xd87de093,
0xe78ad50d,0xef72e6bd,0xfdb4ecb9,0xf297fb02,0xd296dc81,0xeba0d3fc,0x07940502,0xe1a104cf,
0xdbffdd4c,0xebe9eaba,0xf37ffab6,0xfaaffe88,0xea64fc65,0xde36d546,0xfbade57e,0x03671065,
0xe7abe39c,0xeb04d2ac,0x0118f749,0xfc13f362,0x0391f4b0,0xeedfef16,0xdc34d9eb,0x0deaf9ed,
0xff2b0794,0xd811e701,0xf9eae701,0xfe09f802,0xf44af87d,0x07df004a,0xe3c0f78a,0xebd2dbf5,
0x156cff3f,0x03800e31,0xe985dd37,0xfbfae4ec,0x0073fc9e,0x040eef85,0x01ba03fd,0xe0adef76,
0xedc4dba3,0x1c230a2b,0xfb281279,0xdf21e794,0x038be80b,0x033c0068,0x06e70413,0x0812ff6c,
0xdf5cea42,0xf681e6dc,0x224809e6,0xf894126d,0xe175e614,0x101de5e9,0x0d24ff3b,0x04c503d4,
0x06f1fadc,0xee8aec2c,0xf648eb33,0x230d0816,0x004f155f,0xe173e70b,0x09b6e464,0x1889085d,
0x069f074e,0x03d6f9f8,0xf995ecbc,0xf3f1ef16,0x17cc0351,0x0ad51ccc,0xe0c6f88d,0xfd08e27b,
0x0e920f3d,0x05ec11f2,0xf4e7ff28,0xf6bbfa6c,0xef60f708,0x060b05d9,0x188715a4,0xe0e10a4a,
0xf06bed07,0x0d50ffb4,0x0ad91824,0x060cfcea,0xf4edf953,0xfe510135,0xfdc4f28c,0x19e50ed6,
0x09090bc9,0xe959e4bc,0x0843eef6,0x152f0d20,0x00ec0a4c,0xf1cefe70,0x008c01d8,0xf527ff62,
0x047f0a51,0x16da1061,0xe7890268,0xfdd3ef7b,0x0ba5fd1e,0x0f5b1c7b,0x066bf498,0xf8f3f60f,
0x10befa91,0xffe8f972,0x0aa30d4b,0xf7950dd9,0xe4fa0ad9,0x036c0215,0x0d130a58,0x042d0a94,
0xfbc8fa16,0x017bfb03,0x04ce071a,0x0dd9f8aa,0x034c048a,0xfec70b94,0xeff0fe92,0x00430fe7,
0x0e8d0592,0xfbea05d1,0x0a76fb5e,0x0186fd9f,0x0a0d0a8d,0x081cf8fc,0xfdfb0ae0,0x03230750,
0xf1fa0516,0x064f0a94,0x07f1fd92,0x004dff3c,0x0c95ffb4,0x03a1016e,0x012b0273,0x08b101ed,
0xfbfb0838,0x036109c0,0xff25faa8,0x0a470eb8,0x06a2f54a,0xf6480554,0x15030669,0xedce0cb1,
0x03b903f0,0x00d1fb5d,0x09f517e3,0xfe8ff6af,0x007b008c,0x0ff20361,0xfb620aa5,0xff6ffd83,
0x106c0a42,0x053c08b1,0xfb2ef86b,0x0794f7b0,0x0e4b13f1,0x0018facf,0xf5c7fe83,0x1344fe62,
0x03090d16,0x058afc9c,0x03faff2f,0x12680a09,0xf853ff27,0x04dcfc4d,0x0c830595,0x0c3d0731,
0xf76ffa43,0x067a00ca,0x05bb0a76,0x029a09a5,0x00e2f881,0x09e6047a,0x055e03ed,0x023400f7,
0x0757fdea,0x090b0191,0x05270a7d,0x05a2fead,0xfffe0107,0x0649030e,0xfc020643,0x085bfeaa,
0xfec10172,0x0a4e047f,0xfe660580,0x039ffb36,0x00c1fea3,0x0a0b0d98,0xf6c10690,0x03fffcfe,
0x0121fef5,0x082a0ae6,0xfc83ff54,0x0505ffa3,0x0673047d,0x03a506f1,0xfb06fb12,0x02e7ff4e,
0x071706fe,0x024302cb,0xff2bfdb3,0x009ffe91,0x02970335,0x0032026a,0x06ac0643,0xff61fe85,
0x045e0308,0xfd0cfc83,0x031dfed3,0x0380faeb,0x09aa0936,0xfd6102d2,0xfd16ff53,0xfb0bff77,
0x06a90afb,0xf8940416,0xfd9500ab,0x02510368,0x02a6042b,0xf7540284,0xfab6fdd8,0x09d803d8,
0x04d508d3,0x03ab03e2,0xfc75fbf7,0x02bcfb7f,0xfb7d032d,0x02b0ff17,0xfdac05b0,0x0464fc8d,
0x010b0579,0xf9dafa6b,0xfd36007d,0x02050121,0x05620a06,0xff8d0146,0xff2efad9,0xfedcfc25,
0x00e9050d,0xff31000f,0xffeefafc,0x06e9ff1e,0x00ba0775,0xfa04fee4,0xf5a2f9d2,0x00c1f770,
0x095804dc,0xfc03fe8d,0xf5edfda7,0xf77afdcf,0x07360123,0xfccfff96,0xf972fa0d,0xfddfffa0,
0x076e034a,0x01bd05e7,0xf602f6e4,0xfa13f7ac,0x014ffe99,0x050c03e7,0xfba30086,0xf80ff836,
0xff49fef1,0xfe5cfebf,0xf74ffc42,0xf3acf8ad,0xfe16faa5,0x01e200a4,0xfc270434,0xf52bfdc2,
0xf416f2c8,0xff2ff634,0x05400761,0xfce40550,0xfb68f954,0xfcc1f57a,0x014900b5,0xf96e0435,
0xf44df4d6,0xfb20f680,0xff54ffe8,0x053f02ce,0xfc0805e3,0xeda4f4a1,0xf6e7f1c1,0xfdd6f728,
0x0219fec9,0xf5ac00a5,0xf471f04b,0xff3df246,0xfa4afed8,0xf7a6fc4a,0xf839f797,0xf8dff4e2,
0xfe99fe49,0xfbd50305,0xfe360139,0xf3c8f797,0xf19fec20,0xfb45f200,0xffd30184,0xfe640524,
0xf494eee8,0xf0a1edc7,0xf6cafe9c,0xfc20f95a,0xf7b2f70c,0xf012f0ba,0xf673f727,0xfdaffa7f,
0xfc97f5ac,0xfafafdd8,0xf495f8a9,0xee94e96e,0xfceaf6c4,0x005401fa,0xf756fe5b,0xf6edef6f,
0xee35f427,0xfd01fb3f,0x0053fdd0,0xf126f8d2,0xf5d4f143,0xf3cdf95e,0xf42af387,0xfe0af609,
0xfed6036b,0xf42af7f7,0xef72f52a,0xf0a9eb79,0xf9fcf113,0x060205d9,0xf551fdf9,0xf346f276,
0xfaf0f72d,0xfd20ff4e,0xfa39fab7,0xf6faf3ce,0xf7bbf709,0xf569f97d,0xf77df4e7,0xfe9cf9ac,
0xff3302cc,0xfbb3003e,0xf07cf4c8,0xec22ea57,0x0187f43c,0x049b0272,0xf69cfc21,0xf689f36f,
0xf809f735,0xf815f69f,0xfebefcea,0xfcc1ffd9,0xf6ecf872,0xf6d8f7fc,0xf5cbf95d,0xf857f3d8,
0xffe3fbc5,0xffc702bd,0xfa32febe,0xf56ff7fa,0xf3fdf3cb,0xf758f2de,0xfcb4fc35,0xfdeafe50,
0xf824f961,0xf5e9f65a,0xf5caf4cd,0xfb6ef89e,0x022dfe91,0xf705fbb4,0xf12bf41c,0xf648f016,
0xf8b4f880,0xfcfaf8c8,0x0030fc83,0xfe5a02cc,0xf8edf9b0,0xf2e0f504,0xf2f1f364,0xeeceef2e,
0xfcf2f738,0x043b017b,0xf8ed0175,0xf243f4e9,0xf786f487,0xfb2afac7,0xfa68f6a3,0xfc9ffc0d,
0xf79ffd47,0xeb5cf060,0xecf6e966,0xfd51f590,0xfef1ff83,0x020102c4,0x02530550,0xf98a00f3,
0xed98f24a,0xeb9aebc7,0xf443f25b,0xf82df54f,0x017bfccc,0x04f402c1,0xfbcb01ed,0xf7a2f5b7,
0xf82bf46a,0xfb95fb6c,0xfdadfa2d,0x0090ff6d,0xf72dfca9,0xede5f120,0xefc6e8ce,0xfc69f46f,
0x074d03e7,0x0c9b0813,0x0cfb0c0f,0x00ac0843,0xedfef8b9,0xed9fece2,0xf430efa4,0xfa1cf7c7,
0x00a6fefb,0x0b010676,0x0a3b0bc5,0xff380617,0xfa4efe2c,0xfe20faa3,0x00deffce,0x02a103a6,
0x0005036c,0xfc3bfe12,0xf5cff6dd,0xf775f637,0xffdffb0d,0x09d30350,0x11140f2c,0x103211eb,
0x0ab10da7,0xffa304b3,0xf7a6fbc0,0xf384f3b3,0xf8dff4dd,0x022efd5d,0x09e6065d,0x0c050b19,
0x0f510e1e,0x0bce0e17,0x05bd07ac,0x024c03e5,0x018000c8,0xffe7ffcf,0xfe68ff16,0x00a1fed9,
0x0443026f,0x05ff05aa,0x066f05e7,0x097a086f,0x088709f5,0x06fc0898,0x090c07a5,0x053705fa,
0x043905dc,0x036505bd,0xff1a02a6,0x000cfe8f,0x03f7024c,0x05980527,0x06280609,0x08140669,
0x0c9b0983,0x09270a09,0x06d1079f,0x04d2058a,0x035101d9,0x032b028a,0xff1a0212,0x0087ffcf,
0x04e301cd,0x05b605b6,0x07ea07d5,0x073908d5,0x065606c8,0x05730550,0x00e90413,0x00e200b7,
0x0295012d,0x038e01ee,0x078104c4,0x06db092b,0x03dd03f1,0x05790471,0x02d10575,0x008effc4,
0x03f7022e,0x027a03a3,0xff050021,0x00be0048,0x01ac00cf,0x048b02b2,0x04130481,0x047f0413,
0x077505a5,0x033905c0,0x00e301f4,0xffa6009f,0xfc94fe36,0xfb68fb47,0xfd1efbf4,0x00c5fedc,
0x025d01e7,0x02bc02a3,0x030f02cf,0x01fe0439,0xfff40121,0x011f009b,0x005201ba,0xfedfffba,
0xfe77fedf,0xfd6dfd96,0xfccbfc6e,0xfe68fce6,0xff65fe72,0xff2aff12,0xff1afec9,0xffd6ff65,
0xff44fffc,0xfd62fec1,0xfd20fd76,0xfc6bfca9,0xfb2cfc32,0xfb32fb36,0xfc3ffbf4,0xfd9bfcf8,
0xff8dff08,0x00f800d4,0x011c00af,0x008400fe,0xff3d0002,0xfd83fe94,0xfb1afc45,0xf943f9a1,
0xf81af87a,0xf71af770,0xf8e6f87d,0xfb69f9e7,0xfd51fbea,0xfe96fe84,0xffadff66,0xff8dff39,
0xfe70ff16,0xfd51fe32,0xfcdafdd0,0xfc64fcfb,0xfbc7fc6f,0xfb0ffbfc,0xfaebfacf,0xfbedfaeb,
0xfb88fb9e,0xfb2afbcb,0xfc0cfb40,0xfbcbfbc1,0xfbfbfbf7,0xfb77fbf1,0xfb42fb4d,0xfc8afbda,
0xfd84fd3c,0xfd0cfd73,0xfc39fc54,0xfaa3fba6,0xfa13fa8a,0xfa58fadd,0xfa5afa7a,0xfaeefa77,
0xfd36fc80,0xff05fe1b,0x0004ffb1,0xfffeffad,0xffa9ff8f,0xfef5ff5f,0xfddafe66,0xfc9efd42,
0xfac0fb91,0xf90cf9e9,0xf93bf920,0xf94df94e,0xf92ef931,0xfa5ef96f,0xfc0dfb0f,0xfd47fca9,
0xfe35fdb8,0xfe57fe61,0xff27febe,0xff72ff39,0xff80ff16,0xff38ff4e,0xfe4cfead,0xfe03fdcf,
0xfe66fe06,0xfe24fe43,0xfd98fe1b,0xfcc9fd3c,0xfc6efca6,0xfc2efc45,0xfbdafc35,0xfbf7fbda,
0xfc6efc58,0xfc79fc66,0xfce4fc79,0xfd39fd27,0xfd92fd43,0xfdb6fd92,0xfde6fd9f,0xfde6fe05,
0xfdcbfde7,0xfd69fd8e,0xfd83fd9e,0xfdd9fdf9,0xfe1bfdf5,0xfe51fe27,0xfe24fe77,0xfe1bfe3f,
0xfe20fdff,0xfdaffdaf,0xfd3cfd64,0xfd38fd47,0xfd2bfd31,0xfd2ffd3c,0xfd27fd25,0xfd3bfd47,
0xfd79fd66,0xfd99fd8e,0xfda5fdb7,0xfda7fdb1,0xfdaffda9,0xfde1fdb8,0xfddcfde6,0xfdb6fdc9,
0xfd9efda0,0xfda0fda3,0xfda9fda3,0xfd98fda2,0xfd9bfd99,0xfd6cfd66,0xfd5ffd57,0xfd4afd54,
0xfd32fd4e,0xfd2efd25,0xfd31fd2a,0xfd4dfd44,0xfd38fd47,0xfd3dfd3b,0xfd4afd3c,0xfd39fd40,
0xfd43fd3d,0xfd44fd40,0xfd43fd42,0xfd39fd3c,0xfd38fd42,0xfd36fd44,0xfd28fd32,0xfd28fd23,
0xfd25fd21,0xfd12fd17,0xfd09fd10,0xfd05fd08,0xfcfbfcfe,0xfd3cfcd2,0xfc42fc0d,0xfac1fc49,
0x0000fb05,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_5_standard_DRUMS_stix[256] = {
0x00000000,0xe5dbcd2a,0xbea4614b,0xf4d92f0d,0xd97fdeed,0x69683969,0x40a28ca5,0x3e5dc7e9,
0x195eb52c,0xe6920d7e,0x00cf3ab3,0xc813db4b,0x52d10657,0xc3101129,0xe5bc0d68,0xae7b26ee,
0x0c5c426e,0x2fcaed21,0xa14110a3,0x39f7e878,0xe74a138f,0x3cbce4c6,0xfc0ee3ba,0xf9da28eb,
0xf4f1dd46,0xfab92d93,0x00cfc2b5,0x3d6c0a10,0xf982e71f,0x0e6bda81,0xeb912969,0xb5330c0b,
0xe51b5a08,0x203118a4,0x0cba917b,0x280f1524,0x0ad7e563,0xa03101c2,0xd5d670b2,0x4749db82,
0xe628de71,0x028d145c,0x0c78e18f,0x0f59357a,0x0c6d97c9,0x28601b80,0x47779894,0xa3881c88,
0xfa366e66,0xf121b442,0x3ba220d1,0xee02e128,0x9a5f41f3,0x2660fc14,0xd1ad22c5,0x380ae177,
0x95531e97,0x18e14d0a,0x1a97dfbd,0x06dbe9e7,0x70b2ba94,0xc167da45,0x1bf02780,0x57afd050,
0x384b8ca5,0xedca020f,0xa20657d8,0xc0b03e28,0xd0b843ab,0x4767eacd,0xde48e4bc,0x306cf14b,
0x04e6f2c0,0x4429d683,0x4528c74d,0xb5800288,0xfc8139aa,0xd7f9037e,0xd5f52fd9,0xb9822906,
0xf36e377f,0x604ebe86,0x137edaa6,0xf3cfe0e6,0xb25e4f69,0xf368282e,0x1d42f498,0x070ee095,
0xf621fa04,0x344f07cd,0xda6ae7dc,0x2faa148e,0xa6570be8,0x4c37fcef,0x2ab6c6ae,0xe1f100a5,
0x2c1fe170,0xb0563dc8,0xeceaee7a,0xe4fd5db7,0xeca5f472,0x2abdd229,0x20cd1e55,0xcdaac3c0,
0xf5e255e7,0x18c0e950,0x2b8dd3d3,0x2a19ed4c,0xd6dae64a,0x11a82bf2,0xe086f5ae,0x304cec1b,
0xfd4f0111,0xee7af54e,0x350fd5aa,0xfef42200,0x353ba388,0x034f1b9d,0x02aada1a,0xea261174,
0xd50f3eac,0x0312c9d8,0x2a4e4263,0xe218d58d,0xc3232492,0xedf33b89,0xd93c0f86,0x19082173,
0xef67b85f,0x23032fc7,0xe220fe93,0xe297ee81,0x70b2f146,0xb6e80903,0xf742dec5,0xf8a1438a,
0x0ce0f34f,0x2d9fed2c,0xff32fbaf,0x2aa2b235,0x05cf1980,0xe00ffaa0,0xf05d20ca,0xfba60712,
0x288fdcad,0x18caf582,0xe79db429,0xf5dd542f,0xdc0c20ac,0xe9e50608,0xf7062459,0xf21ef606,
0x1c99102c,0xf1dff601,0x290ac965,0x14b92248,0xea49ebe6,0x158fee6e,0xe16f0c47,0x08530f0f,
0x0ce9e76d,0x2bb9d6fa,0x46e8cd83,0xefa10d35,0xf1e0d7b4,0xfbf20781,0xf6622737,0xb822304b,
0x0188126e,0x0570ea2b,0xf8af3267,0xb7330458,0x0a102a8f,0x5813ce78,0xfe48e805,0x2007d050,
0xcf1cf907,0x23df461d,0xe339c492,0x06fe0f60,0xfe9cf264,0xfbe822d7,0xfb5100f6,0xfe850101,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_6_standard_DRUMS_sinetick[128] = {
0x00000000,0x78bc7a66,0x723075f8,0x676e6d4c,0x590760a7,0x4751508b,0x33203d8a,0x1cfa283a,
0x05e51191,0xee80fa2b,0xd7d7e316,0xc29bccf0,0xaf84b8bc,0x9f67a704,0x92bb9899,0x8a098ddb,
0x85968746,0x85988505,0x8a068740,0x92b18dce,0x9f579891,0xaf73a6f6,0xc274b8ac,0xd7c4ccdc,
0xee6be304,0x05d2fa17,0x1ce8117e,0x330c2827,0x47423d63,0x58f7507a,0x67656097,0x72236d43,
0x78b875f5,0x7aff7a68,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_7_standard_DRUMS_verbclickwave[640] = {
0x00000000,0x0006002c,0x004f003b,0x002effa1,0xffa00074,0x00210041,0xffebffa0,0x00ce0032,
0x006aff03,0xff240139,0x0106004f,0xffb4ffc8,0x00150107,0x00caffe1,0xffcfffe7,0xffc800eb,
0xfcde0067,0x00a6ffbf,0x0047fc94,0xfde2005f,0x005e0133,0x00e6fb4a,0xfba001f4,0x010201f9,
0x02ebfbf2,0xfceffd56,0xfcfb02c9,0xf3420450,0xfe0d1109,0x1c94e66d,0x139802dc,0xb76dd3d6,
0xc58c7231,0x26a18e24,0xb1ae7231,0xd5e77231,0x72318e24,0x8e248e24,0x72317231,0x72318e24,
0x8e24584b,0x485e7231,0xb85602a5,0x8e247231,0x55fc1459,0x72318e24,0xe2197231,0x72318e24,
0xe8fca135,0x30b16aea,0x352ba972,0xacc4d13a,0x0b9afef6,0xadc2435f,0xe82bae47,0x2820cfad,
0xe3230450,0xab797231,0xf23df59c,0x47b2b572,0xcb66b893,0x228f22b5,0x3d60e5f2,0xb65b47b2,
0x534fd0c7,0xa86edb46,0xdd8b5d2a,0x72318e24,0xbbd14907,0x103bd40b,0x9b61478e,0x6eb5ce45,
0xf1c5f6a4,0x1380f19d,0xd7e0d940,0xe9233c53,0x4a8d0f86,0x8e243634,0x7231fc94,0xc6caaccf,
0xa66265ec,0x7231921c,0x8e24ecfe,0x0dc66e5c,0x618fb6a6,0x8e24f8ba,0x2a7f287c,0x35f3c898,
0xd0ccd544,0xd3157231,0x517fd21b,0xcc6d1eaa,0x35450893,0x0ee4e6c6,0xfcea0343,0x8efa20dd,
0x48881554,0x31b0e798,0xe5b4f03d,0xf5aa2c39,0x4602aa40,0xaf6d2ae3,0xf4fb32c5,0x1d89b832,
0xdd88f573,0x4aa04012,0xca3fd185,0x396c5239,0xf650cc07,0xf81934a4,0x29f50818,0xdfa6c311,
0x0aa84519,0x1ee4f5a6,0xfb9a2377,0x0982c72b,0xe4a7ebb7,0xe951f062,0x02520582,0xc4faf823,
0x1837098d,0xd4c505f3,0x34efe2f8,0xbd630065,0x1864216d,0x3541c9f4,0xd73ffba6,0x324906e0,
0x1639c7e7,0xef81479d,0xdbd720e6,0x2f9eecac,0xf26109db,0xf663fc1d,0x065e45d0,0x0f30eb51,
0xf5380842,0x11abefcc,0xff70ecc0,0x0e0fe78e,0x15f503fc,0xeba9f0c3,0xc9db383a,0x0f0b11e2,
0xce1cd0f8,0xf1792913,0x4fd7c035,0xd33204c6,0x20781d4b,0x3bb6bcb5,0xb28b0f50,0x06291797,
0x01bcc476,0xddfb1c11,0x0c7a2a66,0x2123c87a,0xd8ef11c5,0x1d1104bf,0xfbd104bf,0x072604c0,
0x04f4000f,0xf3fde4ba,0xfca12987,0x0f1219f0,0xded3ef06,0x10681dfc,0x1a0aceef,0x08580b5c,
0x218100e6,0xd97e0653,0x0bef10df,0xff4bf060,0xef5defdb,0x010bfe0c,0x1a2208f8,0xe1d81fd4,
0x25e408d1,0x0aa3cfde,0xc61416fe,0x35ad0a85,0xf9b7d0e7,0xcce22979,0x3c4be24d,0xd0bee018,
0xdd872c0c,0x1695e579,0xedb61402,0x0f41e955,0xfe2a03ca,0x01d9021a,0xf7a607cb,0x2c74e297,
0xacc42e0f,0x72318e24,0xb6a35828,0x8e247231,0x455a1356,0xdef19562,0x084d7231,0x72318e24,
0x8e24c267,0x180b7231,0x3aefae9f,0xdbead9b6,0xc59239bb,0x3b411133,0xd0d51415,0x0beb09b9,
0x1aa5c059,0xfdb01ffb,0x0856f987,0x0129d1d5,0x1f48f3f6,0xc73116f2,0x0738ed79,0x05d904ef,
0x1603f9bf,0xe95516c6,0xd20208d4,0x0bb91116,0x046ed304,0xfce7106b,0x2ae90f7b,0xc2680000,
0x2bbb16ac,0x0d2bba1a,0xcffe2b9e,0x4cd9dcc8,0xe8f5e7d1,0xf94d1349,0xc5d818a3,0x25a6ff76,
0xd0e20a42,0x2f950106,0x1524bb8b,0xeca7109b,0x14331e9b,0xca90ec0c,0x31cd1b9e,0xe5e2d9ef,
0xcbb32c35,0x445cf162,0xda01d844,0xf44c3541,0x2846e622,0xc9c3ec1e,0x3bbe1334,0xf324d544,
0xffab07f5,0x0876f936,0x05370eda,0xeb5e0a9d,0x001e1d4b,0x2082fafa,0xf748f7f0,0xc56421a5,
0x3e330f58,0xbeabd682,0x381a49ca,0x361cdccf,0x1704a728,0xc234247a,0x2630e890,0xc384ff7b,
0xf3d52a02,0x507ae6a0,0xd7190ff2,0xf9ee4006,0x2538c3bc,0xda7306ae,0x27f029c3,0x095dc4a8,
0xe8351c8a,0x065c1b1c,0xfb4c0ea1,0x0b13ddb2,0xe2dd00ab,0x0bc00407,0x029ce8f7,0xe897ece6,
0xf95b2003,0x03bb0653,0x0f82f03b,0x0841edd2,0xbfc00088,0x2a55170e,0x0f4ceb6f,0x0807fbea,
0x01bdf340,0xf60d191c,0xf8e8fd93,0x0752f755,0x126afff1,0xe9640ee0,0xffc8210b,0x0eb2e00e,
0x031703bf,0xfed9fe0c,0xdfec03fe,0x0b450395,0xfc88e9f7,0x0ae8295f,0x0e07dfce,0xefea0386,
0xf90af6e3,0xf456eab5,0xef4a1e1b,0x0789f8b6,0x278ffbd1,0x019500d5,0xf4fbfa78,0x168afc4d,
0xd910f010,0xfc4427fa,0x11760b5c,0x282fdabd,0xe794087f,0x1e4f085d,0xf362efdc,0xd7562c27,
0x12ebe50c,0xfa24f4d6,0x088009c2,0xfdb2083e,0xf60df116,0x02c506ca,0x0fe2e661,0xe4f2f8d8,
0x0f9e12c5,0x0ae0f0f6,0xf2b31e4f,0xfeebf03d,0xfa19071f,0x119f0088,0xf6eeffef,0xf59416d4,
0x1443017f,0x06fef284,0xf2c300d0,0x12f404e0,0x0cd3f261,0xdfecfe2a,0x02090cd3,0x088801a6,
0xec7cfaa8,0x125cfe7e,0xeba5f9e5,0x17870e7c,0xf797f123,0xfddd0d79,0x0a61f78e,0xfcd9004f,
0x03e40627,0xfcb1f8ee,0x02d70a7e,0xee56f5df,0xfe2f14e2,0x0801f66a,0x058e0408,0x09da0458,
0xff57e9f1,0xe9401093,0x009e0c28,0x0ce5dcfd,0xf9b111ec,0x092f0485,0xf1160723,0xfcfdfa82,
0x0fe7f376,0xf523f844,0x10630563,0xfd26ee17,0xfdbb089a,0x001706e8,0xfc05069d,0x0154fb4c,
0xf21705d4,0x0a9b067e,0xfb7cf4b2,0xfd3805e5,0x0e2bf9a6,0xf49c0bad,0x15c4009a,0xf38df0fb,
0xefa5154c,0x122afd0d,0xed21e674,0x04ca2761,0x1d4dea1f,0xfbdbe6e5,0xe62c1784,0x1b74fa3a,
0xe7a2fb70,0x01dd13fd,0x1658efa4,0xea471122,0x0cd505d3,0xf501e6d0,0x0a0e166b,0x1863e68d,
0xe604093e,0x054a0dfd,0x020c079a,0xf776f9a6,0xf7a10b76,0x078cf127,0xff5e0bde,0x0852fb36,
0xfaaff506,0x06100a1d,0x1014f847,0xfaaaf1ed,0xf9360cf0,0x09c2fdc2,0xf46e02cc,0x02e80fc4,
0x0b0ef87b,0xed4c0798,0x0c5b00f3,0xf13cf720,0xfdac0a57,0x1208f5aa,0x014feb27,0xf08c10a9,
0x130efca6,0xee0af4a3,0xfb610a31,0x06f0fcd2,0xf67203a4,0x03e90ae5,0x084bf1e9,0xf92efb4e,
0x022807c4,0xfdb1f87a,0xf8a30722,0x08e4039f,0x0223f92c,0xf76107da,0x0056004a,0x0dfaf9a2,
0xfac7fdf7,0xf9bb0aed,0x0862f6a6,0xfcf706e4,0x07c1016f,0xf86af836,0xfc8a09ea,0x068ef7fe,
0xfac8026e,0x00b200df,0x0598fed0,0xf6d902ad,0x05f2fda8,0xfc7dfe21,0xfa300520,0xfea205c0,
0x0eecfd65,0xfdb4f4a3,0x02240487,0xf90dfe7c,0x0752091a,0xfdd0fe2f,0x02f90011,0xff060139,
0xfe5efc13,0x042c03fc,0x0016fc0f,0xfcb40381,0xff0ffebd,0x04d9fe98,0xff5df84a,0xf7b90a08,
0x08d0f68a,0xf80f020d,0xfd6913e5,0x0c1ef35c,0xf865faac,0x013f0fcd,0x0e8df2f5,0xeab3004c,
0x0b480f84,0x0b46f476,0xf3250841,0x003e01d5,0x0589f858,0xfb0303e9,0x0221fccb,0x01f3fa2d,
0xff270423,0x084601ec,0xf501fd07,0xff5d02cb,0x03740347,0x0429f714,0xf9ab07f6,0x07ba002a,
0xf9edff8c,0xf9bb096c,0x08d4f2f4,0xf93dff38,0x045f08ef,0x008ff604,0xfebd0ae9,0x0530f9d0,
0xfb94f850,0xf9a007ed,0x0a5dfe07,0xffaafe95,0xf9ac0878,0x07f9fd06,0xfd6ffcb1,0xfe670279,
0x0101fea6,0xfb400216,0x01eb01a1,0x00ce01a7,0xff8efef4,0x054afc0c,0xfafcff0f,0xfe9e038a,
0x059efb70,0xf6b50127,0x004c0627,0x0622fdfa,0xfffffeaf,0x02b7fd3c,0x00a1fc6f,0xfc930369,
0x019a0244,0xfecbff9a,0xfd780282,0xffd10413,0x0229fc8a,0xfb80026a,0x02e502f5,0x0377f85b,
0xfb7c071c,0x03d0fd86,0x0196fd10,0x005d010b,0x024e01bb,0xfbad027a,0x00d0013f,0x038ffc9f,
0xfeaaffbf,0x00390386,0x034cfbb3,0xfa85048d,0x056a03c1,0xffc4f6b7,0xfa9703c7,0x0310008b,
0x0164ff99,0xfd540254,0x023cfbd1,0xfc2101b5,0x056200ca,0xfffcfc9d,0xfe0d00fd,0x03bdffaf,
0xfe440004,0xfefd0349,0x01f4fe88,0xfd4501e8,0x02d30047,0xffaffe79,0xfd6b02ad,0x03cc0025,
0xfed3fe5a,0xff7d02ea,0x02d1ff1a,0x0022fe0f,0xfd69022e,0x025f0095,0xff74ff66,0xff3e0086,
0x0117ffc4,0x0106ff90,0x012f01fb,0xfd69fe91,0x00280124,0x017e00df,0x00c5ffde,0xfece0117,
0x0071feb6,0xfed7ff95,0xffd00317,0x0170fdaa,0x0047ff35,0xfeebff91,0xff4b01c8,0xfef4fe73,
0xff7efeac,0x01440268,0x0017fefe,0xfef500a0,0x0164ff53,0x01baffa6,0xfeeb0041,0x002a0071,
0x01720037,0xfec70138,0x00f80095,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_8_standard_DRUMS_coldglass12wave[128] = {
0x00000000,0x089f1af5,0x08b228cf,0xf4621916,0xe2fffa09,0xeac3e810,0x09e9f078,0x23d005e2,
0x23610ccb,0x0ab7fbdc,0xf2abe31a,0xf18cdd3d,0x0490f3fe,0x12cc14d9,0x084d2329,0xebf414fd,
0xd8b0fc79,0xe203f3d8,0x006e028e,0x1921166c,0x17fe1690,0x0315fd6a,0xf415dfab,0xfca4d895,
0x156dee4c,0x211a0abb,0x1151144e,0xf0b405d8,0xdb54f327,0xe2e9f461,0xfd220c3b,0x0e5c23bc,
0x069c21e0,0xf1e805d2,0xea80e81c,0xfd03e1c5,0x1af5f409,0x28cf089f,0x191608b2,0xfa09f462,
0xe810e2ff,0xf078eac3,0x05e209e9,0x0ccb23d0,0x00002361,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,
};

const uint32_t sample_9_standard_DRUMS_bd15[896] = {
0x00000000,0xffcd0022,0x0b3dff46,0xf56409c0,0xf36304c1,0x2517faa1,0xe000e44d,0xfc002250,
0xfeafcc6c,0xecd03b1a,0xda1199ca,0x41e4442d,0xc417fa60,0xd435a73b,0xbc1b03b4,0xd0278def,
0x171c3141,0x8fe3acba,0xbed5adb5,0x038acd7f,0xe3091ac6,0xd521c121,0xd3fbcdca,0x3d22157f,
0x9a7cf59e,0xd4e4a220,0xff26f2fb,0x2fea1311,0xca581715,0xf515b7d7,0x05ea1dfc,0xffe6f2ce,
0xe776f7ab,0x0e8ff3f8,0x2cc7263f,0xf0b20c1c,0x1c2e027c,0x1dec2198,0x390c29fe,0x0bae28e6,
0x2f541e45,0x30e933bc,0x2c642a1d,0x355434ee,0x32e23398,0x386033d1,0x392d3c64,0x37fd33f7,
0x419f3e66,0x37623df0,0x3f733740,0x36003d80,0x3cb938a8,0x3cd83c9d,0x35ba3a24,0x421a39db,
0x2f463ea8,0x38162f7f,0x36113a1d,0x33563378,0x302931be,0x3be5363a,0x247f3144,0x2bb52374,
0x32033413,0x2bb12baa,0x29dc2c83,0x280325af,0x24682874,0x1cae2022,0x205d1c2c,0x226324e1,
0x0bb517c3,0x245511f3,0x0e012320,0x0031fa38,0x0de30d0a,0x09350bc9,0x066b07ad,0xf750fb6e,
0x013b00d9,0xee93f6ae,0xf156ef9a,0xe4eded77,0xd5a4dabb,0xdeacd714,0xe702e67c,0xd9f1e142,
0xceabd2aa,0xced3ccbd,0xcaead0a6,0xbb7bc0b7,0xc1febcaa,0xc505c6c6,0xbd87bf49,0xbe12bf38,
0xb755b993,0xbb9db986,0xba05baa0,0xb944b9b6,0xba0db96f,0xb922b990,0xb982b96d,0xb9bdb9e4,
0xb9f4b9dc,0xb971b998,0xbbc4baaf,0xbba1bbea,0xbc04bb70,0xbc95bbc4,0xbe19bde3,0xbcf1bd2b,
0xbf2dbd46,0xc110c125,0xc132c0f7,0xc07fc0e4,0xc3fbc1e1,0xc5a9c55f,0xc598c542,0xc870c74f,
0xca93c8f2,0xcc8ccc18,0xce1fcd0b,0xd1c6cfe5,0xd04ad192,0xd4bcd1a2,0xd8e5d657,0xd8cbdabb,
0xd8f3d74e,0xde07dc3a,0xdeddde59,0xdf81dfd0,0xe3f4e0a2,0xe564e5be,0xe7b2e605,0xec0de9b6,
0xf1b7efd3,0xe8eced24,0xf3e5ec8b,0xf872f865,0xf34cf425,0xfcb1f815,0x0323ffbc,0x026c0422,
0x01bb009e,0x0a1f05ed,0x08a30abc,0x11990a31,0x166f16c2,0x15671570,0x14701433,0x196e16a2,
0x20031d86,0x1ff11f82,0x266e22c4,0x2b5b2991,0x298e2ab1,0x2e0c2a6b,0x34323327,0x2f7f313d,
0x35d1315d,0x397d39b2,0x37dd378b,0x3cba3a7c,0x3c5b3d30,0x38e43a2f,0x3c273997,0x3f433e4c,
0x40e6404a,0x414f413c,0x404f4115,0x400a4025,0x40183f58,0x420941bb,0x416e41b8,0x41c94155,
0x419741bc,0x41ce41c1,0x40a74119,0x409740bd,0x41e4412e,0x40e941e6,0x4025404f,0x3f3d4007,
0x3ee73e83,0x417b409c,0x3f0b4029,0x3dd03ecb,0x3cd23cf7,0x3e463d73,0x3ce83de4,0x3c1b3c53,
0x3ae33b6f,0x39733a18,0x391738b9,0x38bd3974,0x363c377e,0x35a635bb,0x32cc347b,0x31f4323a,
0x30cf317d,0x2f1b2fd8,0x2eed2f20,0x2b3c2d2e,0x2a292aad,0x25c0280b,0x27b2262a,0x24ac26c3,
0x22cd23aa,0x1d7d20c6,0x1b371af6,0x1b131be6,0x19931a4f,0x164d1863,0x0e4e12ac,0x0cc50c59,
0x0c340d50,0x0b5e0b41,0x06fc0a2d,0x00a00336,0xfec0ffa9,0xfaf4fdba,0xf698f772,0xf852f7c6,
0xf49df719,0xf10af25d,0xea28ee48,0xe648e775,0xe536e547,0xe7e9e7d9,0xdf84e348,0xdd3ade09,
0xd9b7dbb3,0xd89fd89e,0xd634d7e4,0xd651d612,0xd155d3df,0xd13ed109,0xd09dd0cc,0xcf8dd0c0,
0xcdaecdef,0xcf2bcea6,0xcdf1cf22,0xc9facb8a,0xca73c99b,0xcb56cbb3,0xc955c9ff,0xc7b3c892,
0xc6a9c76d,0xc55bc52c,0xc77dc72e,0xc6ffc706,0xc7abc737,0xc4c7c6e3,0xc4cdc463,0xc472c4be,
0xc77ec623,0xc4b8c66c,0xc3dac3d7,0xc3c2c41e,0xc5bfc3e0,0xc4efc5c6,0xc373c3b7,0xc47ec3eb,
0xc391c449,0xc438c360,0xc577c581,0xc63cc596,0xc685c63c,0xc585c6fb,0xc301c2ec,0xc7c5c580,
0xc7d1c823,0xc7a2c807,0xc6bfc710,0xc566c665,0xc7c3c57d,0xcc56ca8b,0xc9b0cbc7,0xc86ec7fd,
0xcaa1c9ad,0xcda2cbc6,0xcda7ce17,0xcf95ce94,0xcc2ece61,0xcf08cc78,0xd257d0bf,0xd48bd43c,
0xd1b4d29b,0xd5b3d32a,0xd807d788,0xd859d7c6,0xdb14d9d9,0xdbd3db83,0xdc72dc12,0xdf35ddb8,
0xe035dfe5,0xe240e0ac,0xe684e4de,0xe70ee68b,0xe9e4e8c2,0xeafbea2f,0xeea6ecb9,0xef12eed5,
0xf4e1f11b,0xf679f722,0xf63df55b,0xf8cbf796,0xfd7efb71,0xfd94fdd6,0x00bfff19,0x03230195,
0x065b0473,0x0a2f0969,0x0ade099d,0x0e740cdc,0x0f4b0ee2,0x122b10ce,0x13a01259,0x17cd1671,
0x180a17c1,0x1b5a1989,0x1d761d13,0x1e951d68,0x210f20af,0x2106203b,0x260823aa,0x25ae267f,
0x26712573,0x2992280b,0x2a8929ff,0x2bcf2b9d,0x2cb52bc7,0x2d4a2d15,0x2e852e0b,0x30bb2fc6,
0x313230fb,0x335b32b2,0x30ce31ee,0x35643265,0x357036f5,0x322a3334,0x35c2333d,0x341f359d,
0x38743553,0x35ac37ed,0x363434ba,0x35c3371c,0x34b633f1,0x390237ce,0x33273653,0x352f3377,
0x34da35db,0x360434bf,0x34773625,0x33413326,0x348c344c,0x31e332ce,0x348b32f1,0x32b2342a,
0x331532c0,0x303d31e6,0x30c92fc3,0x3133317d,0x303430e3,0x2edf2f1e,0x2f872fd6,0x2cf32e02,
0x2e3b2d65,0x2d3c2dc9,0x2d342d4a,0x2b9a2c72,0x2c682c0f,0x2a802b76,0x29942a59,0x27eb284d,
0x28e0288a,0x299b292b,0x269e28e2,0x264d255a,0x277427ba,0x25dc2687,0x24ca25c8,0x24bd23f0,
0x24e82584,0x232a23bb,0x21cf220a,0x22a62313,0x20142074,0x20c920d7,0x205b209a,0x1e5b1fd1,
0x1e651dc5,0x1ee41eb2,0x1e171f06,0x1c7e1d34,0x1c181c05,0x1c191c14,0x1bf51c01,0x1aa51bab,
0x19ea1a30,0x19db199d,0x19da1a10,0x19461994,0x1829185b,0x182318ad,0x1784173d,0x18731802,
0x15bb1781,0x161f15aa,0x1654161e,0x1563163c,0x16611596,0x14fd162e,0x138a1426,0x145313b8,
0x1233136c,0x11f411ca,0x139b1328,0x1062121e,0x118310ab,0x0fb410fd,0x0f130f60,0x0e310ed8,
0x0d820da2,0x0cd10d01,0x0c6a0d75,0x0b8d0a95,0x0afd0caa,0x08f40905,0x08880912,0x08830873,
0x05cb06f2,0x05f60679,0x053904fe,0x03e30520,0x0244027a,0x02b302d7,0xffc80153,0xfda1feb5,
0xfe3ffdaa,0xfd04fe21,0xfb5cfbf2,0xfabafb23,0xf8edf9e9,0xf8c2f89c,0xf6e7f7c3,0xf732f6e6,
0xf430f643,0xf27af25f,0xf423f3a8,0xf0f9f2df,0xf18df0bf,0xeec1f0d8,0xeebdee4b,0xeda7edb9,
0xec82edd7,0xeb9bebd7,0xea9ceafb,0xea15ea97,0xe7b3e8ab,0xe719e757,0xe61be6bc,0xe452e533,
0xe516e443,0xe30fe4ab,0xe155e1d5,0xe0f0e166,0xe003e01a,0xdd4adf13,0xdf3ddd63,0xdad7de1f,
0xdad5d9b1,0xdc3fdc3f,0xd874da6e,0xd863d859,0xd6fcd7ab,0xd6ddd704,0xd4fed61a,0xd45ad408,
0xd429d508,0xd2c2d2e7,0xd16dd262,0xd114d16a,0xcfffd014,0xd012d0f4,0xcd7fcdc2,0xcf29cf29,
0xcb5ecd1f,0xcd18cb69,0xcc6ecd86,0xcc15cbd2,0xcadecbc4,0xca83ca25,0xcb9fcbca,0xc94aca41,
0xca3dc986,0xcaa6cada,0xca20ca5c,0xc9d6c9fa,0xcab4ca57,0xcb1ccb31,0xca9cca6e,0xcc7ccb65,
0xcc1dcce8,0xcb97caf5,0xce71cd9b,0xccbfcd63,0xcf26ce1d,0xcf11ceff,0xd0a5cfe2,0xcfecd04c,
0xd27ed0b5,0xd306d359,0xd31dd2e5,0xd581d42c,0xd603d631,0xd6e2d5fd,0xd81fd7f6,0xd8fad810,
0xdac2da04,0xdbc9db7c,0xdb66db8e,0xdd08dbcf,0xdf8fde96,0xdf71dfd0,0xe0c3dfa8,0xe22ae1b7,
0xe3d1e2e3,0xe3b1e3e2,0xe5b1e468,0xe668e699,0xe7b6e690,0xe971e90a,0xe9f9e978,0xeabdea8f,
0xec27eb0a,0xeddeed54,0xee1bede3,0xefbfeedc,0xf11ef0a2,0xf16ef15a,0xf2a2f1eb,0xf4c4f38a,
0xf572f5a9,0xf534f4eb,0xf7c1f67f,0xf8a0f853,0xf9b4f914,0xfaeefa3f,0xfbbffb77,0xfd32fc59,
0xfcfbfd4f,0xff87fdca,0x00bd00b2,0x009f007f,0x01b20111,0x03f202b3,0x047d049d,0x04dd042f,
0x06f90631,0x0738070d,0x085107bd,0x09dd08e8,0x0b1c0aed,0x0ade0ac1,0x0d480bf0,0x0d5a0dc4,
0x0e230d3d,0x0f990f32,0x10160f9e,0x12a2115f,0x123612d5,0x12c611ea,0x15311433,0x15221542,
0x15e8151b,0x1673165d,0x17cc16db,0x190518a8,0x193d190d,0x1a3619cb,0x1a331a49,0x1c191aca,
0x1d291d39,0x1c7d1ca5,0x1d581cc9,0x1de81da4,0x1ed61e66,0x1ef51efa,0x1eed1ee1,0x1ffc1f1f,
0x2071209d,0x20be2044,0x208620a6,0x21b1211f,0x20e22151,0x2162210c,0x20db215a,0x211d20cf,
0x222721a8,0x212121d9,0x20b220c1,0x20fc20c6,0x21272110,0x2048210e,0x1ef51f44,0x20901fc0,
0x1f98205a,0x1ee71f3c,0x1e4f1e65,0x1df61e46,0x1d571d75,0x1d331d91,0x1c3c1c71,0x1bad1c36,
0x1b721b58,0x1aab1b54,0x1a101a34,0x193919c0,0x18f5190a,0x183a1883,0x176017e8,0x167d16da,
0x16891683,0x158f162d,0x14a81502,0x13c31441,0x141513ce,0x133813df,0x123012ae,0x11a811d3,
0x115111ab,0x0ff6109b,0x0fc80feb,0x0ef50f4b,0x0e6e0eca,0x0ddf0e0b,0x0cfc0d7f,0x0c130c85,
0x0bba0bce,0x0bdb0bed,0x0a990b64,0x095509c0,0x096e0952,0x08b9093a,0x087b0878,0x0794082f,
0x07000709,0x06830703,0x058005d6,0x05a6058b,0x04ad0549,0x047c045a,0x044104a5,0x02a6035d,
0x037402c3,0x026d038f,0x014a0151,0x017b01b2,0x01a3014d,0x007e0188,0xff8bff7f,0x00520022,
0xff42ffe5,0xff41ff33,0xfe4dfede,0xfe7dfe35,0xfe03fe67,0xfd93fda5,0xfd79fd9c,0xfc92fd06,
0xfcd6fc81,0xfc6dfcf5,0xfbc3fbe0,0xfb93fbb5,0xfb5afb76,0xfb6cfb4a,0xfaf6fb69,0xfad3fac7,
0xfa0cfaaa,0xf9e5f9be,0xfa26fa0f,0xf9ddfa39,0xf93ff955,0xf976f98c,0xf8f8f918,0xf95cf92a,
0xf8b2f915,0xf8daf8aa,0xf8d9f8e4,0xf87df8b1,0xf8e2f884,0xf88ff8f2,0xf8bdf888,0xf8c6f8be,
0xf8e7f8fb,0xf86cf890,0xf8f6f8ab,0xf8a0f8f9,0xf88df862,0xf916f8d9,0xf94df944,0xf879f8e6,
0xf90cf880,0xf9c4f9a7,0xf948f965,0xf92bf94e,0xf983f923,0xf9c1f9da,0xf9bff991,0xf9c8f9fc,
0xf98bf969,0xf9fdf9ea,0xfa09f9f8,0xfa78fa48,0xfa36fa60,0xfaadfa58,0xfa6ffaac,0xfa98fa60,
0xfabffac4,0xfabbfaac,0xfafbfaee,0xfadcfaec,0xfb24fafb,0xfb1ffb36,0xfb3bfb2a,0xfb11fb25,
0xfb7cfb42,0xfb4afb76,0xfb5efb3e,0xfb5efb66,0xfb80fb64,0xfb67fb75,0xfba2fb81,0xfb6ffb96,
0xfbadfb7f,0xfb41fb94,0xfb91fb4c,0xfb60fb94,0xfb24fb37,0xfb6afb3a,0xfb6efb7e,0xfb31fb43,
0xfb48fb3d,0xfb1dfb38,0xfb1efb1d,0xfac3fafa,0xfaebfac9,0xfae4faf0,0xfad5fada,0xfac2facf,
0xfa7efa9b,0xfa92fa83,0xfa6afa81,0xfa9efa7a,0xfa44fa97,0xfa21fa0b,0xfa84fa67,0xfa4afa66,
0xfa17fa37,0xfa17fa01,0xfa5ffa4a,0xfa14fa40,0xfa21fa06,0xfa53fa4d,0xfa1cfa32,0xfa48fa28,
0xfa20fa43,0xfa41fa1b,0xfa6cfa6c,0xfa59fa53,0xfa78fa6f,0xfa69fa6d,0xfaaafa7a,0xfad4fac3,
0xfb2dfafe,0xfb60fb49,0xfbb0fb8c,0xfbebfbcf,0xfc37fc16,0xfc6bfc4e,0xfcb0fc90,0xfce3fcc7,
0xfd2dfd06,0xfd61fd4d,0xfd94fd77,0xfdd2fdb6,0xfdfefde6,0xfe34fe19,0xfe63fe4c,0xfe91fe7b,
0xfebffea8,0xfeebfed5,0xff16ff01,0xff41ff2b,0xff6aff55,0xff93ff7e,0xffbbffa7,0xffe3ffce,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_10_standard_DRUMS_verbclickwave[640] = {
0x00000000,0x0006002c,0x004f003b,0x002effa1,0xffa00074,0x00210041,0xffebffa0,0x00ce0032,
0x006aff03,0xff240139,0x0106004f,0xffb4ffc8,0x00150107,0x00caffe1,0xffcfffe7,0xffc800eb,
0xfcde0067,0x00a6ffbf,0x0047fc94,0xfde2005f,0x005e0133,0x00e6fb4a,0xfba001f4,0x010201f9,
0x02ebfbf2,0xfceffd56,0xfcfb02c9,0xf3420450,0xfe0d1109,0x1c94e66d,0x139802dc,0xb76dd3d6,
0xc58c7231,0x26a18e24,0xb1ae7231,0xd5e77231,0x72318e24,0x8e248e24,0x72317231,0x72318e24,
0x8e24584b,0x485e7231,0xb85602a5,0x8e247231,0x55fc1459,0x72318e24,0xe2197231,0x72318e24,
0xe8fca135,0x30b16aea,0x352ba972,0xacc4d13a,0x0b9afef6,0xadc2435f,0xe82bae47,0x2820cfad,
0xe3230450,0xab797231,0xf23df59c,0x47b2b572,0xcb66b893,0x228f22b5,0x3d60e5f2,0xb65b47b2,
0x534fd0c7,0xa86edb46,0xdd8b5d2a,0x72318e24,0xbbd14907,0x103bd40b,0x9b61478e,0x6eb5ce45,
0xf1c5f6a4,0x1380f19d,0xd7e0d940,0xe9233c53,0x4a8d0f86,0x8e243634,0x7231fc94,0xc6caaccf,
0xa66265ec,0x7231921c,0x8e24ecfe,0x0dc66e5c,0x618fb6a6,0x8e24f8ba,0x2a7f287c,0x35f3c898,
0xd0ccd544,0xd3157231,0x517fd21b,0xcc6d1eaa,0x35450893,0x0ee4e6c6,0xfcea0343,0x8efa20dd,
0x48881554,0x31b0e798,0xe5b4f03d,0xf5aa2c39,0x4602aa40,0xaf6d2ae3,0xf4fb32c5,0x1d89b832,
0xdd88f573,0x4aa04012,0xca3fd185,0x396c5239,0xf650cc07,0xf81934a4,0x29f50818,0xdfa6c311,
0x0aa84519,0x1ee4f5a6,0xfb9a2377,0x0982c72b,0xe4a7ebb7,0xe951f062,0x02520582,0xc4faf823,
0x1837098d,0xd4c505f3,0x34efe2f8,0xbd630065,0x1864216d,0x3541c9f4,0xd73ffba6,0x324906e0,
0x1639c7e7,0xef81479d,0xdbd720e6,0x2f9eecac,0xf26109db,0xf663fc1d,0x065e45d0,0x0f30eb51,
0xf5380842,0x11abefcc,0xff70ecc0,0x0e0fe78e,0x15f503fc,0xeba9f0c3,0xc9db383a,0x0f0b11e2,
0xce1cd0f8,0xf1792913,0x4fd7c035,0xd33204c6,0x20781d4b,0x3bb6bcb5,0xb28b0f50,0x06291797,
0x01bcc476,0xddfb1c11,0x0c7a2a66,0x2123c87a,0xd8ef11c5,0x1d1104bf,0xfbd104bf,0x072604c0,
0x04f4000f,0xf3fde4ba,0xfca12987,0x0f1219f0,0xded3ef06,0x10681dfc,0x1a0aceef,0x08580b5c,
0x218100e6,0xd97e0653,0x0bef10df,0xff4bf060,0xef5defdb,0x010bfe0c,0x1a2208f8,0xe1d81fd4,
0x25e408d1,0x0aa3cfde,0xc61416fe,0x35ad0a85,0xf9b7d0e7,0xcce22979,0x3c4be24d,0xd0bee018,
0xdd872c0c,0x1695e579,0xedb61402,0x0f41e955,0xfe2a03ca,0x01d9021a,0xf7a607cb,0x2c74e297,
0xacc42e0f,0x72318e24,0xb6a35828,0x8e247231,0x455a1356,0xdef19562,0x084d7231,0x72318e24,
0x8e24c267,0x180b7231,0x3aefae9f,0xdbead9b6,0xc59239bb,0x3b411133,0xd0d51415,0x0beb09b9,
0x1aa5c059,0xfdb01ffb,0x0856f987,0x0129d1d5,0x1f48f3f6,0xc73116f2,0x0738ed79,0x05d904ef,
0x1603f9bf,0xe95516c6,0xd20208d4,0x0bb91116,0x046ed304,0xfce7106b,0x2ae90f7b,0xc2680000,
0x2bbb16ac,0x0d2bba1a,0xcffe2b9e,0x4cd9dcc8,0xe8f5e7d1,0xf94d1349,0xc5d818a3,0x25a6ff76,
0xd0e20a42,0x2f950106,0x1524bb8b,0xeca7109b,0x14331e9b,0xca90ec0c,0x31cd1b9e,0xe5e2d9ef,
0xcbb32c35,0x445cf162,0xda01d844,0xf44c3541,0x2846e622,0xc9c3ec1e,0x3bbe1334,0xf324d544,
0xffab07f5,0x0876f936,0x05370eda,0xeb5e0a9d,0x001e1d4b,0x2082fafa,0xf748f7f0,0xc56421a5,
0x3e330f58,0xbeabd682,0x381a49ca,0x361cdccf,0x1704a728,0xc234247a,0x2630e890,0xc384ff7b,
0xf3d52a02,0x507ae6a0,0xd7190ff2,0xf9ee4006,0x2538c3bc,0xda7306ae,0x27f029c3,0x095dc4a8,
0xe8351c8a,0x065c1b1c,0xfb4c0ea1,0x0b13ddb2,0xe2dd00ab,0x0bc00407,0x029ce8f7,0xe897ece6,
0xf95b2003,0x03bb0653,0x0f82f03b,0x0841edd2,0xbfc00088,0x2a55170e,0x0f4ceb6f,0x0807fbea,
0x01bdf340,0xf60d191c,0xf8e8fd93,0x0752f755,0x126afff1,0xe9640ee0,0xffc8210b,0x0eb2e00e,
0x031703bf,0xfed9fe0c,0xdfec03fe,0x0b450395,0xfc88e9f7,0x0ae8295f,0x0e07dfce,0xefea0386,
0xf90af6e3,0xf456eab5,0xef4a1e1b,0x0789f8b6,0x278ffbd1,0x019500d5,0xf4fbfa78,0x168afc4d,
0xd910f010,0xfc4427fa,0x11760b5c,0x282fdabd,0xe794087f,0x1e4f085d,0xf362efdc,0xd7562c27,
0x12ebe50c,0xfa24f4d6,0x088009c2,0xfdb2083e,0xf60df116,0x02c506ca,0x0fe2e661,0xe4f2f8d8,
0x0f9e12c5,0x0ae0f0f6,0xf2b31e4f,0xfeebf03d,0xfa19071f,0x119f0088,0xf6eeffef,0xf59416d4,
0x1443017f,0x06fef284,0xf2c300d0,0x12f404e0,0x0cd3f261,0xdfecfe2a,0x02090cd3,0x088801a6,
0xec7cfaa8,0x125cfe7e,0xeba5f9e5,0x17870e7c,0xf797f123,0xfddd0d79,0x0a61f78e,0xfcd9004f,
0x03e40627,0xfcb1f8ee,0x02d70a7e,0xee56f5df,0xfe2f14e2,0x0801f66a,0x058e0408,0x09da0458,
0xff57e9f1,0xe9401093,0x009e0c28,0x0ce5dcfd,0xf9b111ec,0x092f0485,0xf1160723,0xfcfdfa82,
0x0fe7f376,0xf523f844,0x10630563,0xfd26ee17,0xfdbb089a,0x001706e8,0xfc05069d,0x0154fb4c,
0xf21705d4,0x0a9b067e,0xfb7cf4b2,0xfd3805e5,0x0e2bf9a6,0xf49c0bad,0x15c4009a,0xf38df0fb,
0xefa5154c,0x122afd0d,0xed21e674,0x04ca2761,0x1d4dea1f,0xfbdbe6e5,0xe62c1784,0x1b74fa3a,
0xe7a2fb70,0x01dd13fd,0x1658efa4,0xea471122,0x0cd505d3,0xf501e6d0,0x0a0e166b,0x1863e68d,
0xe604093e,0x054a0dfd,0x020c079a,0xf776f9a6,0xf7a10b76,0x078cf127,0xff5e0bde,0x0852fb36,
0xfaaff506,0x06100a1d,0x1014f847,0xfaaaf1ed,0xf9360cf0,0x09c2fdc2,0xf46e02cc,0x02e80fc4,
0x0b0ef87b,0xed4c0798,0x0c5b00f3,0xf13cf720,0xfdac0a57,0x1208f5aa,0x014feb27,0xf08c10a9,
0x130efca6,0xee0af4a3,0xfb610a31,0x06f0fcd2,0xf67203a4,0x03e90ae5,0x084bf1e9,0xf92efb4e,
0x022807c4,0xfdb1f87a,0xf8a30722,0x08e4039f,0x0223f92c,0xf76107da,0x0056004a,0x0dfaf9a2,
0xfac7fdf7,0xf9bb0aed,0x0862f6a6,0xfcf706e4,0x07c1016f,0xf86af836,0xfc8a09ea,0x068ef7fe,
0xfac8026e,0x00b200df,0x0598fed0,0xf6d902ad,0x05f2fda8,0xfc7dfe21,0xfa300520,0xfea205c0,
0x0eecfd65,0xfdb4f4a3,0x02240487,0xf90dfe7c,0x0752091a,0xfdd0fe2f,0x02f90011,0xff060139,
0xfe5efc13,0x042c03fc,0x0016fc0f,0xfcb40381,0xff0ffebd,0x04d9fe98,0xff5df84a,0xf7b90a08,
0x08d0f68a,0xf80f020d,0xfd6913e5,0x0c1ef35c,0xf865faac,0x013f0fcd,0x0e8df2f5,0xeab3004c,
0x0b480f84,0x0b46f476,0xf3250841,0x003e01d5,0x0589f858,0xfb0303e9,0x0221fccb,0x01f3fa2d,
0xff270423,0x084601ec,0xf501fd07,0xff5d02cb,0x03740347,0x0429f714,0xf9ab07f6,0x07ba002a,
0xf9edff8c,0xf9bb096c,0x08d4f2f4,0xf93dff38,0x045f08ef,0x008ff604,0xfebd0ae9,0x0530f9d0,
0xfb94f850,0xf9a007ed,0x0a5dfe07,0xffaafe95,0xf9ac0878,0x07f9fd06,0xfd6ffcb1,0xfe670279,
0x0101fea6,0xfb400216,0x01eb01a1,0x00ce01a7,0xff8efef4,0x054afc0c,0xfafcff0f,0xfe9e038a,
0x059efb70,0xf6b50127,0x004c0627,0x0622fdfa,0xfffffeaf,0x02b7fd3c,0x00a1fc6f,0xfc930369,
0x019a0244,0xfecbff9a,0xfd780282,0xffd10413,0x0229fc8a,0xfb80026a,0x02e502f5,0x0377f85b,
0xfb7c071c,0x03d0fd86,0x0196fd10,0x005d010b,0x024e01bb,0xfbad027a,0x00d0013f,0x038ffc9f,
0xfeaaffbf,0x00390386,0x034cfbb3,0xfa85048d,0x056a03c1,0xffc4f6b7,0xfa9703c7,0x0310008b,
0x0164ff99,0xfd540254,0x023cfbd1,0xfc2101b5,0x056200ca,0xfffcfc9d,0xfe0d00fd,0x03bdffaf,
0xfe440004,0xfefd0349,0x01f4fe88,0xfd4501e8,0x02d30047,0xffaffe79,0xfd6b02ad,0x03cc0025,
0xfed3fe5a,0xff7d02ea,0x02d1ff1a,0x0022fe0f,0xfd69022e,0x025f0095,0xff74ff66,0xff3e0086,
0x0117ffc4,0x0106ff90,0x012f01fb,0xfd69fe91,0x00280124,0x017e00df,0x00c5ffde,0xfece0117,
0x0071feb6,0xfed7ff95,0xffd00317,0x0170fdaa,0x0047ff35,0xfeebff91,0xff4b01c8,0xfef4fe73,
0xff7efeac,0x01440268,0x0017fefe,0xfef500a0,0x0164ff53,0x01baffa6,0xfeeb0041,0x002a0071,
0x01720037,0xfec70138,0x00f80095,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_11_standard_DRUMS_snare24[2048] = {
0x00000000,0x05cd02da,0x050106c7,0x21e7f357,0x113ad93b,0xf54a045c,0xcecf1bae,0xe7b42800,
0xfbcdf755,0xdb48d314,0xe75ff986,0xfdb0eee0,0xd688d543,0xcd4801b2,0xfd1ef4dd,0x19f1e2f2,
0xff330084,0xfda7fe30,0x08be424e,0x3149c252,0x44b021b0,0x0043e159,0x1afa5624,0x363efdc0,
0xfa1d0efe,0x0fac18f8,0x0d210025,0x085cf69a,0x94d35370,0x4ea31b09,0xdd1bdcbf,0x1d14e198,
0xac5df8d2,0xe71cf6ca,0x11181d11,0xf0b794d3,0x9adb0b3c,0xc7ac0a65,0xe951cec4,0xf1bc2af6,
0xf54694d3,0x2c69f9b5,0xcd9aa1ad,0xc7e1f9f7,0x1e49e8c7,0xd80f94d3,0xe3a6e129,0xc84bdcf9,
0xe63c0da8,0xc921b3d3,0x245e00d0,0xb948b333,0xfc900535,0xd5d9eac0,0xfd46cabe,0x16a0f557,
0xd978ca61,0xeb282cb0,0x1603f2a2,0x01b016ec,0x05062164,0x184e33ff,0x202d346f,0x3cb535c3,
0x4209335a,0x44ca3a23,0x188e5719,0x438d5536,0x5183521c,0x3bd84dd3,0x488652cd,0x1f934a53,
0x78e02a9b,0x3a532bdd,0x50c54223,0x3cb03e4f,0x34ef4d28,0x24115d58,0x673b41ca,0x48582501,
0x36643aa0,0x59673387,0x3da61775,0x4b482275,0x3013056a,0x09e41424,0x0a70229a,0x06d2f957,
0xea82e752,0xeeaef35a,0xeadac8c3,0xf04ecfb1,0xbf62be9e,0xd41bdd15,0xd2e2b5f3,0xa57bcfca,
0xb3dedba6,0xbac3ccec,0xab6bc69d,0x9c8bd417,0xbf0fda20,0xc5bba5db,0xae97c1a9,0xb84ac040,
0xbbf7b4d5,0xa0a8c8db,0xba32c75c,0xae2dbf27,0xe58fb58a,0xd6f694d3,0xa809cf2e,0xc325c566,
0xc2dae084,0xfed6bf4f,0x16c1ae87,0xd395dd60,0xfb21018d,0xeea7f64b,0x15110f42,0xf3f5f8d8,
0xfaf05683,0x231131ac,0x5a3014af,0x57a9140a,0x333a1b54,0x4f0e56a0,0x615e22b1,0x46973c92,
0x3b1f5a85,0x556a55ea,0x556a4875,0x4bff3e4e,0x6119487b,0x42c8443a,0x31e944e3,0x5f6f5daa,
0x5585069b,0x3e21203d,0x0184294f,0xd798783b,0x171a15af,0x43e10a71,0xfb6ae249,0xf762fc9f,
0xd1c426cd,0xeaefe9dd,0xfefbfb1b,0xef33caaa,0xf19dd97a,0xd28ad30c,0xd922dcbe,0xe03bcab4,
0xcee6c14c,0xd150d110,0xc244bfe5,0xccc8c83c,0xc460bd5b,0xb862ca0d,0xc3dbc9ab,0xa7c3dab8,
0xb6e8d708,0xd522bd9c,0xa8d6c400,0xbd2edb80,0xc065daf4,0xffc4a1af,0xac14d1d4,0xf8dfeaed,
0x038eb80c,0x12c0c3f5,0xe6050f15,0x03e60bcd,0xf3571bc6,0x19381ca7,0x3b1ee8f4,0x031b05c4,
0xfeb02ff9,0xfc14418c,0x242d3b83,0x610d0ef2,0x30ff0391,0x30aa315d,0x2a4e3deb,0x3c314773,
0x441e4108,0x43431494,0x217f5ba2,0x37c85652,0x4c58425b,0x4b2b27cf,0x39d15258,0x51902399,
0x5d562f5a,0x26041a98,0x450d3632,0x0cce29ba,0x4f1f17f0,0x042afb33,0x38e82323,0x1a8bd5ac,
0xd0b82724,0xfc853256,0x00c5c883,0x01eb0117,0xd2f3ef90,0xddb6eb95,0xf004da98,0xc046d6c7,
0xc479f2f4,0xbad8e015,0xd4a2d4a5,0xdb47b2ef,0xb958c852,0xa9f9cc18,0xbae1d809,0xd1cab54d,
0xb70fc135,0xbbe7d34a,0xd513dd7e,0xdb2ab164,0xf640e9eb,0xa533c167,0xc78e4069,0xddb1e488,
0x0deaf4e2,0xd0d3f8ec,0xddcb2145,0x0298eb32,0xca672439,0xdd93236c,0x2ccefa72,0x2898e6c0,
0x51dbc814,0x1144e978,0xf9a212dd,0xfd40461a,0x18f02274,0x5a960336,0x21a6090c,0x42a7283b,
0x19912a14,0x19e84824,0x4b594014,0x43b8151b,0x2bc937c3,0x17bb4187,0x38553058,0x36ec235d,
0x14f11a12,0xffc7374d,0x2351049d,0xfce5ff19,0xea6b2983,0xf5f3eee1,0x18c3f162,0x06ccc0a1,
0xe6fdd490,0xe027d669,0xd90ce747,0xdb78cef3,0x0865bb83,0xc613bd94,0xbc63d4f2,0xd2cedf6e,
0xd246bf4c,0xb729c05a,0xb3e0d639,0xc2b7dc39,0xbd52acff,0xaab3df04,0xa464f640,0xd5debc8f,
0xcbcedd28,0xbe44d055,0xfd94cb72,0xd855b9dd,0xcb60022b,0x191fbf27,0xdb40d52f,0xce530c25,
0xd3d20bed,0x202806f0,0x0a55e11c,0x412de4a8,0xfbdfe54c,0x15e82b42,0xf08d03c6,0x38742353,
0x383cc9b1,0xf408283c,0xe6813af3,0x3eff1fb6,0x4634e835,0x11c0efb2,0xfa4c3f8c,0x1dd11848,
0x25ae063e,0xf4f829e2,0x2698226d,0x58b7e756,0x28de0ba9,0x0bf615bf,0x21893181,0x196521c9,
0x14ca234f,0xfb8b2f9d,0xefae41af,0x01d931b5,0x23a2f849,0xff5720ee,0x0aceed4f,0xf0b80390,
0xf4b417e0,0x05cdc9ea,0xe39dfa33,0xd6c6e78e,0x001fe4fd,0xdcffacc6,0xc897f384,0xb5fae55e,
0xe5b1d30b,0xa938d3ae,0xbf79eb72,0xc30ad042,0x991ff5e0,0xcca2e518,0xafead168,0xccc8fac0,
0xd510be77,0x23e1b025,0xd27694d3,0xb9b82251,0x3a10a16b,0xbb37d11b,0xcd1a04a1,0xcd1a1705,
0x189ad12c,0xa4d105e9,0xd9c83cd8,0x0690f2f0,0x10fff01f,0xef45ef60,0xdfe112e0,0x23ca13a9,
0x1a0cd77d,0x27f2e793,0x2576f405,0xede517e9,0x38291ba7,0xf5f4f770,0x21e036cd,0x3aa4f06c,
0x2f2bfa95,0x06151c7b,0xe7ea319f,0x1e3e360f,0xffce3661,0x083f0dd1,0xf5ad5ad1,0x16b81dcf,
0x0b79332c,0x2b8def81,0xeff34556,0x1b2e14ef,0x5250f02f,0xf4f1e5e2,0xcedc2dc1,0xff922f23,
0xf003e75c,0xbf3c3324,0xdac4163a,0x3e8bdea3,0xface94d3,0x0a7eec15,0x07fbabdd,0xbc5ae1c3,
0xc723eca8,0xcfcbe65c,0x94d3ff28,0xeb0cf488,0xcff2c2eb,0xdc4fc8cd,0xdd91cde7,0xe835cc3d,
0xea76bdf1,0xc63dd2e6,0xc87ff02a,0xe65eee26,0xce95c722,0xe137f53f,0xd70ecbee,0xf040fc5f,
0xc77be628,0x0572f3b9,0x156cd2ed,0xe5dedd79,0xf6f2115f,0x153cddd4,0xe8e4fd80,0xf0ea0891,
0x2529f4be,0xec0cfe15,0xf5c7006a,0xb0216560,0x3e5bfafc,0x145cdcc3,0xfd2d1d87,0x1a451028,
0x371d024e,0x101ff94f,0x063c3f3d,0x4c41e052,0x168f2a94,0x3af1021a,0x314f22bc,0x51891101,
0x1d34ff62,0x3bcf3612,0x42d1ffb4,0x1bc81e44,0x19573479,0xe88b326d,0x1cc53daa,0x165b05bf,
0xe4171a5e,0x05793949,0x0097fc03,0x24c8fcce,0xdf0ee3c5,0xdb741bf5,0xd4490259,0xcf8af979,
0xc96702fe,0xfb6ed480,0x0b4ab25b,0xcf22c904,0xea37c946,0x9d85f029,0xe744df0b,0xd68fc54b,
0xc3afe1ba,0xe9f9b49d,0xccdbbf83,0xc20fe9a6,0xb3e3f731,0xc5a5dfb5,0xf065e3f3,0xcc05d678,
0xfec4d662,0xd157e508,0xe620e80d,0xe71afa0b,0xaae7fd87,0xe2162fe5,0xd56cfdca,0xe4b62f87,
0xf67eff46,0x23ecfc05,0xf17e09ed,0x240df8f6,0x2096f91c,0xf5ad0733,0x1c3a1e96,0x4354cf6c,
0x006a1aca,0xfa7010b4,0x01d63ec8,0x156d02f6,0xf5282a4f,0x2cda1d06,0x0a09ff91,0x33a50cdb,
0xf590245b,0x210721dc,0x184919d5,0x1c1a1351,0xe6b842f1,0x366e204e,0x2663f677,0x2e3f0d9c,
0x17aef927,0x04191e20,0x2aec04ce,0xe1a50c29,0x17781f99,0xe1a41178,0x4a54e4aa,0xe072f377,
0x088a15ea,0xc0a60a52,0xcbfe40c0,0x2f1df4c5,0x2387b49a,0x07ecc8c3,0xeebacec4,0xaf630b1b,
0xc95efe2c,0xe37bf5b7,0xda18dd86,0xe32ad242,0xca44e90b,0xc61be1e8,0xc9d1f35b,0xdd28e196,
0xe432d9fc,0xc387d4d5,0xf90cfafc,0x0754afc1,0x1820cebc,0xe704bb3f,0x13d2da5c,0xd678fd1f,
0xed63fafc,0xef83fa49,0x05dd06b0,0x18a9bd33,0xdbc71937,0xea7ffe8b,0xef38fb82,0xd7e140c1,
0x170ce58b,0x03ba03e1,0x10faf58b,0x131aee7c,0x028ffdaf,0xecfe18bc,0xebf81cbf,0x3f64076f,
0x164bdc61,0xf2011a4c,0x12e53138,0x1ec7eb27,0x056a2ef9,0x4dd1f3aa,0x1455fc06,0x33b2130b,
0x06640df7,0x070b1b90,0x13fb3fcd,0x3baeeb8a,0x02610b9e,0x067a23b9,0xfc3a21d5,0x0d9d16d4,
0x1af3f36a,0xe71c1e36,0x2060f38d,0x0289e6e3,0xe1c10550,0xe99c090e,0x04a1f453,0xcf25d9b6,
0xef2d12f5,0xe229ccf9,0xdcc9f39a,0xf9d3d0d9,0xadbfe269,0xd1b7f4e0,0xd63cfa0c,0xf389c33c,
0xd3f8db35,0xf0bfe743,0x1775b078,0xbd3cdc41,0xefe0f03e,0xc4a4ff6b,0xe8a9fad2,0x0ff5e070,
0xd306da56,0xe9de2c5f,0x0071dd6e,0x049decd9,0x020cd6be,0xb13e2965,0x01381c6a,0x228ec39e,
0xf369eeb2,0xe359f94a,0x30a5eed3,0x25b0aa58,0x0c83d15d,0xdce41024,0x0a64f5bd,0xda81150c,
0x278bfde6,0x1264e873,0xeb530025,0xf9812996,0x0a801030,0x091209ec,0x079efa1a,0x00d9258b,
0xf66702ae,0x1c251e85,0xecef03c8,0x120d1f83,0xec642cdf,0x2c8d025b,0x0a0d1820,0x037ffea8,
0xfcd82315,0xf5c21b39,0xe99a14d1,0x19881771,0xf1f8f144,0xfc0f1d4d,0x4cc2cb4d,0xd8aceba3,
0xdee01d0c,0x153c05de,0x0594dc70,0xff8fdddb,0xf4fff9e7,0xe0f10367,0x1a2ece75,0xf71ce88e,
0xc086e885,0x0c1d0247,0xef58c65d,0xdf4cecc0,0x066beb81,0xd2c0d113,0xec71f41a,0x0834cabc,
0xd80cd0a5,0xd1b607a2,0x06bcd857,0xfbadcf70,0xdc2ee701,0xe58305b6,0x21c0b4e4,0xd0fff410,
0xebcdf8a5,0xdebafed0,0xdf780577,0xf86a0115,0xf2c4f7a1,0xf099f18e,0xee691ac4,0xfff6fb1c,
0x205ce8ea,0x2288e3ab,0xe963f57d,0xe6a93154,0x096d10e0,0x1337ebbe,0xfc4326a4,0x2754fd13,
0x2599f369,0xff4a0561,0xe8653cec,0x16f71dbc,0x1a9e12e2,0x0536faa4,0x025f2e3b,0x0468131c,
0x212a1cc3,0x1445fbfc,0x1ee310f3,0x0a37fd30,0x03e60d53,0x1b8514d1,0x1bc5e7db,0x02d30466,
0x14a4edc8,0xeef00383,0xf8500c21,0xeaa1fa7e,0xe96d164d,0xf0b80b1c,0xe056f8b1,0xf11611b3,
0xf78cd85b,0xd6bd05ac,0xe037fe2e,0xe298f903,0xd4a2fb07,0xf4cdefb2,0xf670d5ce,0xfdf7dfb6,
0xf73fd2fc,0xe906cef6,0xcf1506a5,0xfd8add39,0xe1f4dc80,0xe0aee714,0xdbbdfbef,0xf2fbdaed,
0xe82cf058,0xeed9dc7c,0xdcc604ff,0xf16cda3f,0xf347eb8f,0xe198fd60,0x0a23d4fc,0xed9ce7ef,
0xd04e0283,0xe1380212,0xfcb9fa92,0x04b2d9f3,0xe9b9f652,0xfb820488,0x0adbedcc,0x1e0be00c,
0xef2a0392,0xfb11130e,0x0876f9e0,0xf621204a,0x15a601de,0xeb5324cb,0x2b89087b,0x0db0fd14,
0x06a92140,0x241213bf,0x03e006ed,0x09022dd1,0x26c5036c,0x09d015e4,0x1b5cfd7e,0xfa0c24e7,
0x1b5011e1,0x0fa4012f,0x0ea010e5,0x03e20ff5,0x04680da5,0xe991301b,0x047415be,0x0cf4fec5,
0xea401b56,0xf481fbcc,0xf1822258,0x022df509,0x2efbd4c0,0x01ded0e9,0xdfc302b7,0x0708eebf,
0xea13de70,0xe05104b8,0xebb8eecf,0xfa3cdcc7,0xcc77eed3,0xe3e8fc02,0xd895e2f0,0xe2f3e8aa,
0xdfaaed9c,0xede8ee80,0xfdeecfed,0xf920df41,0xdfd8df35,0xe32ffbbd,0xecd6e958,0xec00ea2e,
0xe7e3ebee,0xe52bf710,0x10e1de6e,0xf4eee509,0x0a04d0cd,0xfcb2df09,0xe873f162,0xf3defda3,
0xf0cff9b7,0x0367f642,0x038fe11d,0xe76608d6,0xd6f2251f,0xefd809ab,0xf4891cce,0x1056fd8d,
0x0f02fc37,0xfd0601ea,0x04492604,0x1971f46c,0xfa5f1f35,0x0c19144e,0x26c914d8,0x26eafaaa,
0x102c101f,0x15270e19,0x15371a87,0xfcea11fd,0x14642191,0x25190096,0xf30e0b3b,0x159b28fa,
0x202dedd5,0x03331080,0x084403b5,0x0cf80d3e,0x0906f45a,0x06130b21,0xfb71fe41,0x070a043e,
0x0f69eedb,0xe826fc55,0xebc10e6d,0xf1c7042b,0xf5cffb1c,0xe992edb1,0xe4b9030c,0xf52b00f6,
0xe719df15,0xfe15ea73,0xdc19eb32,0x0504e221,0xf485d81f,0xe4b6dd64,0xe38ceb9b,0xe943f3c9,
0xec03da99,0xd302fede,0xce75fc4e,0x01dd00eb,0x0c4dc78a,0xec36df6d,0xef83fc1c,0xf043f741,
0xf29bf060,0xf0d6fb37,0xd1d50cf8,0x04b803ab,0x0a4cebf4,0xfa73fb3c,0xf5f9064e,0x1624fd85,
0x0105f1a9,0x01b00bb9,0xfcce1062,0xd11a28f3,0xe61c46c8,0x195811e3,0x213dfec5,0x19a8fff0,
0x07ee160f,0x1e25085e,0x2a26fe9c,0x1556fefb,0x046020dd,0x15340d0c,0x1af110e7,0xf786fe8f,
0x17281dea,0x0ed5f5b3,0x129cfc32,0x0e9901b1,0x1729ee91,0xec810dee,0x03591464,0x00f2f87a,
0xe74d0cd6,0xeb322815,0x12d6e8ee,0x0d97f358,0xec9df619,0x0d17f91b,0xefe6ef73,0xfac2f7d8,
0xf04dfe31,0xe9ecedf4,0xd2a40a2c,0xf6300395,0x0613dfe5,0xfaf9d99f,0xd8dcf9a3,0xe5900908,
0x0f06e47a,0x05fdc0f6,0xd89bfdc4,0xf42ef27a,0xdb6df263,0xfdd2fac1,0xe622df79,0xfa15fa27,
0x025edf01,0x0099de28,0xf127f0c5,0xd117071d,0x007b0387,0xfb84ee1d,0xeb11fb08,0x11b7f289,
0xf158efbc,0xfffcfd26,0xf233fc4c,0x01620a70,0x0727f181,0xe3e20ab3,0x055f189c,0x2247e448,
0x2737d340,0xe873fae8,0xf4f8242c,0x01e60630,0x0e7af0b4,0xee0909d7,0x03581fc9,0x05a2fa1a,
0xfb7a13ea,0x00ea1644,0x07800811,0x193c0b0e,0x0ac1fb2a,0x050a148b,0x1b95048b,0x0b23f886,
0x066f0bb6,0xf43b0f5a,0x117c10c0,0xfdc9ffef,0xf42b12a2,0xfbf21a19,0x11e5fc09,0xf07500ad,
0xfb701333,0x028f00c3,0x1189f83a,0x0f7ae46d,0xf198f540,0xeca40915,0x03d2f30f,0xf2f9edcc,
0xdeb90441,0xf05ef955,0xeb5df420,0xf7afe832,0xf4f1e8fd,0xe21fe781,0xf2f5f4ad,0xf15fe4a6,
0xf3c6f0d6,0xe466e6ce,0xf12ff976,0xe36af3d3,0xf89fef29,0xe88aee38,0xf06ef99f,0xff69ea5d,
0xe310ed4b,0xef270f6a,0xfbf6e99e,0xed1dfca9,0xeede0c1e,0x1b29e918,0x0316e04b,0xf4aef7ef,
0x0ea7fe56,0x0af9e26c,0x09b9fbad,0xeecaf49b,0xfa9c1802,0x01a3fb9b,0x05ff053e,0xfcaa00d1,
0x0bb80c44,0x0048fbfa,0x0c700b39,0x027d01af,0xfc5e18ec,0x0a680524,0x0d400608,0x01880af2,
0x0e08048b,0x08840b5b,0x02b500ad,0xfd441794,0x0de504d9,0x0c3305a3,0x185af81a,0x10caf16c,
0x02cdffd8,0x09cb05af,0xf8d1f77a,0xfaf1082b,0xfe3d0446,0xf99e099d,0xfe21ffa1,0x03defdc1,
0xf2fe014c,0xffb902a9,0xfa79f455,0xfdebfaaf,0xf9a0f142,0x0459f6a6,0x0069ef2a,0x03a9ec7c,
0xf9cbeb24,0xdb2200e3,0xdda01359,0x007601a9,0xecefef78,0x0cb5f09f,0xf6dde1c0,0xf9b9eca3,
0xf05ff275,0xf9edf251,0xf239e9b9,0xe81904ce,0x00a5f7a2,0x03b6dd83,0xfbe3f82e,0xe328fd8a,
0x05cfffb9,0xf8d3f7ca,0xf712fb32,0xf96d0217,0xf6970aee,0x122ff002,0xf32d0706,0xfcb30b63,
0x016a0385,0x1b4404bf,0x11cfec30,0x045a0537,0xf055144e,0x0821195a,0x009801c8,0xf9bf1966,
0x10720d78,0x1390fd5f,0x020e062e,0x210b037a,0x05f8f435,0xfdec1625,0x05480cdb,0xf7b411ca,
0x0e2e1338,0xfb810775,0x14450f2a,0xfc740bd8,0x223d0a24,0x2402ecf6,0x0edafda0,0x020f0a48,
0x0d6e1311,0x0f73f7cb,0x0b3406be,0xf1cbfcef,0xef1d2635,0x0fb20033,0x0288f7ac,0x0252fa3b,
0x0bdefd10,0x0ae5e35d,0xed8a0a42,0xf2bd05dd,0xf35e0944,0xf58103cc,0x0234fcce,0xfdc5f776,
0xf837fb24,0xe8d8099f,0xfed60c21,0xfff0f35b,0x02f3f46e,0xfb46fc06,0xf9ed0082,0x0031f8cc,
0x0189fa53,0xfd99fd57,0x089b0244,0xfb85f391,0x06c50c71,0x0405f8ba,0x04cafe5f,0xf32e0694,
0x076e0645,0xfb9bf7b7,0xfaed0e8f,0xebc808c8,0x0043166e,0x0e32eddb,0xfb1c08e7,0x005e067e,
0x0bcbfb84,0x10fb06c6,0x1167e7b6,0x095fffa9,0xfa110e01,0x0b01027a,0xff410445,0xfce11045,
0x02450b29,0x0fb6fb00,0xf3500e5c,0x06de125b,0x0a0b05f2,0x02650be5,0x1b25fbdf,0xf9b90d4b,
0x02491055,0x176c07d5,0x0981f8ec,0xff140dc2,0x08e90ee3,0x0dd9ff88,0x1056f831,0x04220e18,
0x0676ef28,0xf41f1436,0xed940bc1,0xfe5f1175,0xf5eff98c,0x00e40b28,0xf589f7bf,0xff5708d1,
0x02a1f85b,0xf222fe0d,0x03430d96,0x059eed44,0xfaa60710,0x09bef5a8,0xeef30490,0x189bfd25,
0x0661e460,0x0aaefe87,0x0037ecd0,0xffac0a84,0x1440e859,0xec5b0008,0xe8fb190a,0x0bbd0533,
0x1033eef6,0x0316f06b,0x03c5fd70,0xf0410abc,0x0eeff617,0xf173013a,0x03f505cb,0x0880f30b,
0x1198f02c,0xfdb9f949,0xfd2e0191,0x0219ffea,0xfb8c05d0,0x04ef01d0,0x0aacf68a,0xf4e40451,
0xf0290e93,0x000e1221,0x0722f62a,0xf03d0df2,0x0bc20fe8,0x1203efa5,0x04680073,0xf4ac136e,
0x0b780374,0x079008dd,0x04d60139,0x112006af,0xfa4a0b7d,0x1043ff5a,0x05cd10cf,0x1a4af92e,
0x08780367,0x033a0804,0xf727180b,0x16540802,0x063ff612,0xfa3a14e2,0x072c081c,0x081dfdcc,
0x088c03d7,0xfda2015e,0xffa80762,0x0376f9f2,0xf9240d58,0x03dcf7d3,0xfb0f0643,0xf8ab0538,
0x07d3fba0,0xf72b02ba,0x0dc2f468,0xf538054b,0x03c0fb67,0xfe94f55b,0xea5007af,0xf2bf0b1d,
0x02a0fb66,0xf46dfb08,0x0245f86c,0x063bec79,0xeaccf730,0xfdac0569,0xf75ef32b,0x0859f003,
0x0099ee3b,0xfeedf6a3,0xf989f514,0xf26206ba,0x075cf8c4,0xf5e0f637,0x02920561,0xf538061a,
0x08e9fd73,0x0f85faee,0x0197f7b3,0xf6871287,0x077c09bb,0x05ef06b3,0x0658049c,0xf6e512ab,
0x0f96116b,0x0d7bfecf,0x11bf0227,0x0f04ffef,0x07ad0dd1,0xff3d1217,0x0fbc117c,0x141c086b,
0x015b1334,0x1efe051b,0x086c071e,0xfe781083,0xfe861c31,0x0e8f0c9d,0x136b0618,0x13bef61e,
0x0038085d,0xff2c0e54,0x05380bf8,0xfb35062a,0xfe8508b5,0x08c10693,0x0412f397,0x15f4f9c8,
0x07cfec88,0xffecf4e4,0xe0961171,0x02bf0f2f,0x1062ef15,0x00fbecee,0xfa8a01d8,0xf2670435,
0x05f202aa,0xf956f5c6,0x03370453,0xf559fd1f,0x0116fe85,0xf59ffefa,0x0c6ffb54,0x060ae76f,
0xea62fdfb,0xf0c30e2f,0xfe1af967,0xf298fcb1,0xfe95036c,0xfa72f6a2,0xfca5f7ac,0xfae90176,
0xfae0fbe5,0x095df400,0xfa59fcee,0x0226fe31,0x0324fa6c,0xfb35fec3,0x04a3055c,0xfa5dfe2f,
0x03cc094d,0x0091fd34,0xf2711052,0x05620d7c,0x0c4bfe44,0x17dff512,0xff0d003a,0x03150cb5,
0x04af083a,0x159c025f,0xf8050246,0xface2224,0x14b3ffd9,0x0d33057f,0x05750171,0x05ad0f07,
0x15c9fd35,0xfa380068,0xf8d2120d,0xf94413fc,0xfda3076a,0xfc8d0629,0x06a20634,0x0197f930,
0xfc90055d,0xff91fff5,0x0404ff88,0xf2d50425,0xff9e099d,0xfcb4021d,0x152bfa27,0x0361ea22,
0xf2a609da,0xff0e03b1,0xffeb06d7,0x099bf08c,0x0f10fc3c,0x0101f1a8,0xf87506d9,0x05cb040d,
0xf83dfa7a,0xf77d0e2a,0x0cfe00a7,0x10b2eb9f,0xfdd7f6bf,0x00abfe42,0xfcf3fea9,0xf9260581,
0x030701df,0x0283fa9d,0xf96900fe,0xeaf013de,0xf36a0c9b,0x04100b5d,0x1058f488,0xfc2df81d,
0x0a8408ff,0x0472fa1d,0x07df02ff,0x01e60781,0x0efa01b0,0x01160035,0xfe2a14d8,0xff6b098b,
0x085806f8,0x0e1600a2,0x01b902fb,0x10edfdd9,0xf541084f,0x046310eb,0x06920a11,0x0c55f813,
0x08590a3a,0x04ce0086,0x04410af5,0x0feb016d,0x0826fff6,0x081f059b,0x0768fc36,0xf2430e94,
0xfda1149a,0x04f302cf,0x0777fea3,0x00abfefc,0xfedf03bd,0x01a60574,0x086dfb12,0x0396fbca,
0x04fdfab2,0xf6e30629,0xf4b40826,0x00a50e74,0xf6d70147,0x06ed09f0,0x0984f992,0x0c77f956,
0x0964fd30,0x0652fca5,0x0e4c0188,0x0701fc7b,0xff75074f,0xfccc08eb,0x031106da,0x05cd010e,
0x045403aa,0xfc730041,0x022e0b9c,0x01bafe42,0x06ec01c2,0x0393f8d0,0xf8cc07db,0xfdf3090e,
0x0893fff3,0xf61004bd,0xfd420ecd,0x062504dd,0x0774ffa7,0xf50809c4,0x07800f4c,0x074efb3f,
0xf37310d5,0x076f0b1f,0x0aaf03e4,0x02a10380,0x09ec0754,0x0c6efd69,0x00f00534,0x0c6a03df,
0xff4803c6,0x0d470679,0xfcbc0156,0x07810a92,0x03b8fda3,0x087b0185,0x0dc3fa2d,0xfce90249,
0x0554067c,0x03bd0405,0x069b0132,0x078605aa,0xfbb0096c,0x01b0125f,0x1a1bfd28,0xfdb4fed3,
0x0cab0f9e,0x0ba5fea2,0x058406a6,0xfed31043,0x0b530b63,0x0d54ff50,0x0c0604e6,0x0670035e,
0x0e4d03e6,0x0bcc0105,0x0a15016f,0x0130081f,0x04580099,0xfffb085a,0xfb760827,0x095e0582,
0x0025003c,0x063cff97,0x02b10118,0xfe7e03ee,0x05a301a2,0xfca90312,0x010502b2,0xff92037c,
0x031cfff0,0xfdd20069,0xfdb805bf,0xff6004c4,0x01bffe00,0x034f0445,0x04e0fdc1,0x022afe55,
0xf8940eaf,0x09d7085b,0x08bbfe75,0x08060687,0x0a240535,0x0171072b,0x0e0606cb,0x01840a7a,
0x122f033a,0x04940129,0x03b40bcf,0x08f408b2,0x044e0497,0xfc3b0748,0xffc70e58,0x02bd02e2,
0x049105c4,0x01190082,0x012302ae,0x06bffdec,0xfc4a0029,0x032e0592,0x0a2ffea8,0x05d3f83c,
0xfbb20750,0x019205e4,0x035b04c2,0x07f1ffc3,0x03030026,0xfec505b4,0xf6660b81,0x02d20ad6,
0x008bffc8,0x08890176,0xffaffba1,0xfb8c0c3f,0x08fe00e8,0x053ef97f,0xfff60494,0x06e30351,
0x054ef7d4,0xfd4209db,0x061dfffb,0xfc5c00bf,0x0c70034c,0x000df733,0x0741003c,0x040c008f,
0xfc82fd61,0x03db083b,0x0392f9de,0xfee60223,0x0b08fdec,0x042ff900,0x01e30131,0xf91c0761,
0xfc1f0bbf,0x061e00bb,0x036800d1,0xfad50b27,0x0a110202,0xff88044c,0x08780279,0x02b70553,
0x005c03fd,0x05320a73,0x102efb64,0x04c8fb57,0x05b30832,0x022301b6,0x00420a84,0x03e30766,
0x0957ffe4,0xfc220883,0x062a0a91,0x1079fc37,0x002b0469,0x068b0a02,0x0755058f,0x0a3cffbd,
0xfecf09f6,0x0c270894,0x09c401bd,0x08800331,0x0ec804cb,0xfdfe035f,0x03da0dbb,0x04a909ed,
0x07ea06bc,0x050404c2,0x07010614,0x08cbfed0,0x07cf0575,0xffc405c1,0x02d20b29,0x070e0783,
0x045d0481,0x0675066a,0x064b0215,0x07ff04da,0x07f90099,0x001e0131,0x03fd0581,0x035e01e4,
0x032e010a,0xf99705ad,0x024c0837,0x06770032,0x03e6fea6,0xfb76067c,0x03600745,0x047e00b9,
0x03090519,0xffcf072b,0x058f0743,0x0888ffd8,0x0b5e0346,0xffc202c2,0x08c20c3b,0x06790560,
0x108f02ea,0x07b30043,0x060f06ef,0x0b0c05dc,0x0987037f,0x00c10778,0x0a0a07ba,0xfe9f0634,
0x06910cb4,0x0542ff51,0x0550077c,0x0566010c,0x00e004a0,0xffd40633,0x05f3083b,0x0841fdca,
0x06a702a3,0x058601dd,0x020207b7,0x07f70519,0x04c40355,0x07e8058b,0x03d30420,0x066f07e7,
0xfc890a94,0x05af0de3,0x0a8802bd,0xfcab0976,0x05c40b00,0x062707e4,0x05130563,0x04d30759,
0x0584066d,0x0b490119,0x0826feb4,0x0800fef0,0xfebc06b3,0x088104c7,0x01910351,0x0718057e,
0x02c90408,0x079203d2,0x02970346,0x082c019d,0x00380335,0x052204b5,0x018701e0,0x039801e1,
0xff410636,0x0334051a,0xff98022b,0xfff408da,0x03f40520,0x02ea0210,0x03510680,0x04d603d2,
0x0947029f,0x018d0304,0xff710acf,0x096008b6,0x0bfafedd,0x044405ce,0x05800943,0x09a00558,
0x0c24046a,0x06c101ef,0x08b90819,0x076101f4,0x028309d9,0x0602078b,0x09090597,0x053d01a8,
0xff1c0a6f,0x032a092d,0x09680588,0x075cfefa,0x0311064b,0x02000859,0x08080460,0x092eff61,
0x06f50305,0x041c06e4,0x0b1b01e6,0x05aa013f,0x01260b7d,0x04b10952,0x046606f8,0x04320a2f,
0x063f0733,0x03fc073f,0x08240809,0x06ff0205,0x07a204f8,0x036204e4,0x020407f7,0x04d607f1,
0x033f036d,0x063f02d7,0x0472045a,0x034a0280,0x0381053f,0x040e02a1,0x04e10468,0x078f017d,
0x037a029a,0x02cf0528,0x0665048a,0x04640676,0x0517055d,0x06780551,0x03bf0815,0x0842055b,
0x057f05b2,0x07b0069c,0x042606db,0x080807cc,0x07800561,0x07cb06da,0x08ab04ac,0x06060717,
0x077d069e,0x05240703,0x03c0092e,0x0630070b,0x08dd05b6,0x068e01f5,0x0270092e,0x04900846,
0x0a4a0222,0x0210058b,0x04840693,0x05840709,0x086d0451,0x079c03a2,0x063d03cf,0x034c0592,
0x0537083b,0x054904a4,0x0787038e,0x05d00333,0x0476046a,0x021505ee,0x0196092f,0x055206eb,
0x07b90377,0x04ac0488,0x06770444,0x03990570,0x038c0622,0x046a0507,0x033e065c,0x03c7069b,
0x05f40345,0x0387053d,0x05600561,0x05e50212,0x046404a9,0x04480324,0x058a042f,0x0624024d,
0x049701b2,0x01f4085f,0x08ac02c0,0x0359031f,0x02c4077c,0x02d3085b,0x027c087f,0x07a2078c,
0x08e30480,0x08a90421,0x077f0673,0x02fd0a8c,0x09c1082d,0x08db06fd,0x08c40828,0x0a5804bd,
0x066708eb,0x0a1d080c,0x07b1075f,0x07460826,0x04160a4d,0x067f0a43,0x07fe0816,0x0b5a03f2,
0x05f804d2,0x06a70876,0x0818041d,0x056a0706,0x062c04f9,0x04240a37,0x077803a9,0x05bc05a4,
0x052c065c,0x06140437,0x071d0556,0x03530513,0x04d20658,0x0694051b,0x04aa02de,0x038906cc,
0x05ab0349,0x05250492,0x03d1045f,0x042105a0,0x03c30418,0x049904ee,0x02bf047a,0x03850593,
0x067503a7,0x0435021e,0x01e60678,0x0579056b,0x04ab0279,0x04dd0570,0x042f046a,0x05be0573,
0x05c60422,0x06240505,0x04b30525,0x05c905b7,0x06790560,0x0564055a,0x071c067d,0x061304a2,
0x060e070b,0x06da064e,0x058607f0,0x07430686,0x064b079d,0x050e0831,0x08f00775,0x072406a4,
0x085f06ec,0x0766071b,0x087606a6,0x083b06ca,0x07ac06a1,0x067507fd,0x074708ee,0x07860722,
0x076d0785,0x06e507da,0x06f30727,0x0647085c,0x07460712,0x07270700,0x06bf0738,0x0750060f,
0x064e072c,0x06f00675,0x071205e9,0x065e05fe,0x06380666,0x059a060e,0x05f70700,0x06a90530,
0x05ef05a3,0x05fe0670,0x063b05aa,0x060705eb,0x067d05ed,0x0588060e,0x05e3060e,0x06070637,
0x056705bb,0x05d706aa,0x06480563,0x060a061d,0x06410599,0x062b05b3,0x05ec05c5,0x059d067d,
0x05b8064e,0x065b066f,0x07110559,0x063e05a3,0x05d10681,0x061106c9,0x066c0680,0x066a0639,
0x06ba0686,0x068f0664,0x06ad06ab,0x066806b5,0x0703068c,0x06970668,0x067506c7,0x06c0069b,
0x06bd0652,0x06c5063f,0x069c069c,0x065b064a,0x066206b2,0x06150662,0x06ac0649,0x06290606,
0x06130669,0x062a061e,0x060a0619,0x062205f1,0x05cd05d9,0x05c0061a,0x05dd05ce,0x05aa05a0,
0x054b05e0,0x058605e0,0x051805a5,0x055b05d5,0x05ac053f,0x0562051d,0x052c054d,0x05830548,
0x054a04a3,0x04d30546,0x04d4052d,0x04f404f7,0x051504cb,0x04a5049a,0x04b304f9,0x04d70498,
0x04950490,0x048c0499,0x046104a5,0x04910482,0x04630463,0x04560471,0x0455045d,0x044f0445,
0x042d0447,0x04310436,0x04260426,0x04210406,0x03fc0415,0x03f6040c,0x03f403f5,0x03da03ee,
0x03ce03da,0x03bf03da,0x03c003c2,0x03ac03ae,0x039e03a5,0x03960394,0x03740390,0x0374038c,
0x036d0371,0x035d035c,0x034b035f,0x0346034c,0x03370335,0x032d032f,0x031b031b,0x030e0310,
0x02fd0303,0x02ef02f7,0x02e102e7,0x02d202df,0x02c702c6,0x02b702c0,0x02aa02b1,0x029c02a3,
0x02890295,0x027f028a,0x02740274,0x0263026b,0x02570259,0x0248024e,0x023a023e,0x022c0232,
0x021c0223,0x020f0218,0x02010209,0x01f401fb,0x01e701ea,0x01d801dd,0x01c901d0,0x01bb01c3,
0x01ad01b5,0x019f01a6,0x01910198,0x0183018a,0x0175017c,0x0167016e,0x01590160,0x014b0152,
0x013d0144,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_12_standard_DRUMS_snare24[2048] = {
0x00000000,0x05cd02da,0x050106c7,0x21e7f357,0x113ad93b,0xf54a045c,0xcecf1bae,0xe7b42800,
0xfbcdf755,0xdb48d314,0xe75ff986,0xfdb0eee0,0xd688d543,0xcd4801b2,0xfd1ef4dd,0x19f1e2f2,
0xff330084,0xfda7fe30,0x08be424e,0x3149c252,0x44b021b0,0x0043e159,0x1afa5624,0x363efdc0,
0xfa1d0efe,0x0fac18f8,0x0d210025,0x085cf69a,0x94d35370,0x4ea31b09,0xdd1bdcbf,0x1d14e198,
0xac5df8d2,0xe71cf6ca,0x11181d11,0xf0b794d3,0x9adb0b3c,0xc7ac0a65,0xe951cec4,0xf1bc2af6,
0xf54694d3,0x2c69f9b5,0xcd9aa1ad,0xc7e1f9f7,0x1e49e8c7,0xd80f94d3,0xe3a6e129,0xc84bdcf9,
0xe63c0da8,0xc921b3d3,0x245e00d0,0xb948b333,0xfc900535,0xd5d9eac0,0xfd46cabe,0x16a0f557,
0xd978ca61,0xeb282cb0,0x1603f2a2,0x01b016ec,0x05062164,0x184e33ff,0x202d346f,0x3cb535c3,
0x4209335a,0x44ca3a23,0x188e5719,0x438d5536,0x5183521c,0x3bd84dd3,0x488652cd,0x1f934a53,
0x78e02a9b,0x3a532bdd,0x50c54223,0x3cb03e4f,0x34ef4d28,0x24115d58,0x673b41ca,0x48582501,
0x36643aa0,0x59673387,0x3da61775,0x4b482275,0x3013056a,0x09e41424,0x0a70229a,0x06d2f957,
0xea82e752,0xeeaef35a,0xeadac8c3,0xf04ecfb1,0xbf62be9e,0xd41bdd15,0xd2e2b5f3,0xa57bcfca,
0xb3dedba6,0xbac3ccec,0xab6bc69d,0x9c8bd417,0xbf0fda20,0xc5bba5db,0xae97c1a9,0xb84ac040,
0xbbf7b4d5,0xa0a8c8db,0xba32c75c,0xae2dbf27,0xe58fb58a,0xd6f694d3,0xa809cf2e,0xc325c566,
0xc2dae084,0xfed6bf4f,0x16c1ae87,0xd395dd60,0xfb21018d,0xeea7f64b,0x15110f42,0xf3f5f8d8,
0xfaf05683,0x231131ac,0x5a3014af,0x57a9140a,0x333a1b54,0x4f0e56a0,0x615e22b1,0x46973c92,
0x3b1f5a85,0x556a55ea,0x556a4875,0x4bff3e4e,0x6119487b,0x42c8443a,0x31e944e3,0x5f6f5daa,
0x5585069b,0x3e21203d,0x0184294f,0xd798783b,0x171a15af,0x43e10a71,0xfb6ae249,0xf762fc9f,
0xd1c426cd,0xeaefe9dd,0xfefbfb1b,0xef33caaa,0xf19dd97a,0xd28ad30c,0xd922dcbe,0xe03bcab4,
0xcee6c14c,0xd150d110,0xc244bfe5,0xccc8c83c,0xc460bd5b,0xb862ca0d,0xc3dbc9ab,0xa7c3dab8,
0xb6e8d708,0xd522bd9c,0xa8d6c400,0xbd2edb80,0xc065daf4,0xffc4a1af,0xac14d1d4,0xf8dfeaed,
0x038eb80c,0x12c0c3f5,0xe6050f15,0x03e60bcd,0xf3571bc6,0x19381ca7,0x3b1ee8f4,0x031b05c4,
0xfeb02ff9,0xfc14418c,0x242d3b83,0x610d0ef2,0x30ff0391,0x30aa315d,0x2a4e3deb,0x3c314773,
0x441e4108,0x43431494,0x217f5ba2,0x37c85652,0x4c58425b,0x4b2b27cf,0x39d15258,0x51902399,
0x5d562f5a,0x26041a98,0x450d3632,0x0cce29ba,0x4f1f17f0,0x042afb33,0x38e82323,0x1a8bd5ac,
0xd0b82724,0xfc853256,0x00c5c883,0x01eb0117,0xd2f3ef90,0xddb6eb95,0xf004da98,0xc046d6c7,
0xc479f2f4,0xbad8e015,0xd4a2d4a5,0xdb47b2ef,0xb958c852,0xa9f9cc18,0xbae1d809,0xd1cab54d,
0xb70fc135,0xbbe7d34a,0xd513dd7e,0xdb2ab164,0xf640e9eb,0xa533c167,0xc78e4069,0xddb1e488,
0x0deaf4e2,0xd0d3f8ec,0xddcb2145,0x0298eb32,0xca672439,0xdd93236c,0x2ccefa72,0x2898e6c0,
0x51dbc814,0x1144e978,0xf9a212dd,0xfd40461a,0x18f02274,0x5a960336,0x21a6090c,0x42a7283b,
0x19912a14,0x19e84824,0x4b594014,0x43b8151b,0x2bc937c3,0x17bb4187,0x38553058,0x36ec235d,
0x14f11a12,0xffc7374d,0x2351049d,0xfce5ff19,0xea6b2983,0xf5f3eee1,0x18c3f162,0x06ccc0a1,
0xe6fdd490,0xe027d669,0xd90ce747,0xdb78cef3,0x0865bb83,0xc613bd94,0xbc63d4f2,0xd2cedf6e,
0xd246bf4c,0xb729c05a,0xb3e0d639,0xc2b7dc39,0xbd52acff,0xaab3df04,0xa464f640,0xd5debc8f,
0xcbcedd28,0xbe44d055,0xfd94cb72,0xd855b9dd,0xcb60022b,0x191fbf27,0xdb40d52f,0xce530c25,
0xd3d20bed,0x202806f0,0x0a55e11c,0x412de4a8,0xfbdfe54c,0x15e82b42,0xf08d03c6,0x38742353,
0x383cc9b1,0xf408283c,0xe6813af3,0x3eff1fb6,0x4634e835,0x11c0efb2,0xfa4c3f8c,0x1dd11848,
0x25ae063e,0xf4f829e2,0x2698226d,0x58b7e756,0x28de0ba9,0x0bf615bf,0x21893181,0x196521c9,
0x14ca234f,0xfb8b2f9d,0xefae41af,0x01d931b5,0x23a2f849,0xff5720ee,0x0aceed4f,0xf0b80390,
0xf4b417e0,0x05cdc9ea,0xe39dfa33,0xd6c6e78e,0x001fe4fd,0xdcffacc6,0xc897f384,0xb5fae55e,
0xe5b1d30b,0xa938d3ae,0xbf79eb72,0xc30ad042,0x991ff5e0,0xcca2e518,0xafead168,0xccc8fac0,
0xd510be77,0x23e1b025,0xd27694d3,0xb9b82251,0x3a10a16b,0xbb37d11b,0xcd1a04a1,0xcd1a1705,
0x189ad12c,0xa4d105e9,0xd9c83cd8,0x0690f2f0,0x10fff01f,0xef45ef60,0xdfe112e0,0x23ca13a9,
0x1a0cd77d,0x27f2e793,0x2576f405,0xede517e9,0x38291ba7,0xf5f4f770,0x21e036cd,0x3aa4f06c,
0x2f2bfa95,0x06151c7b,0xe7ea319f,0x1e3e360f,0xffce3661,0x083f0dd1,0xf5ad5ad1,0x16b81dcf,
0x0b79332c,0x2b8def81,0xeff34556,0x1b2e14ef,0x5250f02f,0xf4f1e5e2,0xcedc2dc1,0xff922f23,
0xf003e75c,0xbf3c3324,0xdac4163a,0x3e8bdea3,0xface94d3,0x0a7eec15,0x07fbabdd,0xbc5ae1c3,
0xc723eca8,0xcfcbe65c,0x94d3ff28,0xeb0cf488,0xcff2c2eb,0xdc4fc8cd,0xdd91cde7,0xe835cc3d,
0xea76bdf1,0xc63dd2e6,0xc87ff02a,0xe65eee26,0xce95c722,0xe137f53f,0xd70ecbee,0xf040fc5f,
0xc77be628,0x0572f3b9,0x156cd2ed,0xe5dedd79,0xf6f2115f,0x153cddd4,0xe8e4fd80,0xf0ea0891,
0x2529f4be,0xec0cfe15,0xf5c7006a,0xb0216560,0x3e5bfafc,0x145cdcc3,0xfd2d1d87,0x1a451028,
0x371d024e,0x101ff94f,0x063c3f3d,0x4c41e052,0x168f2a94,0x3af1021a,0x314f22bc,0x51891101,
0x1d34ff62,0x3bcf3612,0x42d1ffb4,0x1bc81e44,0x19573479,0xe88b326d,0x1cc53daa,0x165b05bf,
0xe4171a5e,0x05793949,0x0097fc03,0x24c8fcce,0xdf0ee3c5,0xdb741bf5,0xd4490259,0xcf8af979,
0xc96702fe,0xfb6ed480,0x0b4ab25b,0xcf22c904,0xea37c946,0x9d85f029,0xe744df0b,0xd68fc54b,
0xc3afe1ba,0xe9f9b49d,0xccdbbf83,0xc20fe9a6,0xb3e3f731,0xc5a5dfb5,0xf065e3f3,0xcc05d678,
0xfec4d662,0xd157e508,0xe620e80d,0xe71afa0b,0xaae7fd87,0xe2162fe5,0xd56cfdca,0xe4b62f87,
0xf67eff46,0x23ecfc05,0xf17e09ed,0x240df8f6,0x2096f91c,0xf5ad0733,0x1c3a1e96,0x4354cf6c,
0x006a1aca,0xfa7010b4,0x01d63ec8,0x156d02f6,0xf5282a4f,0x2cda1d06,0x0a09ff91,0x33a50cdb,
0xf590245b,0x210721dc,0x184919d5,0x1c1a1351,0xe6b842f1,0x366e204e,0x2663f677,0x2e3f0d9c,
0x17aef927,0x04191e20,0x2aec04ce,0xe1a50c29,0x17781f99,0xe1a41178,0x4a54e4aa,0xe072f377,
0x088a15ea,0xc0a60a52,0xcbfe40c0,0x2f1df4c5,0x2387b49a,0x07ecc8c3,0xeebacec4,0xaf630b1b,
0xc95efe2c,0xe37bf5b7,0xda18dd86,0xe32ad242,0xca44e90b,0xc61be1e8,0xc9d1f35b,0xdd28e196,
0xe432d9fc,0xc387d4d5,0xf90cfafc,0x0754afc1,0x1820cebc,0xe704bb3f,0x13d2da5c,0xd678fd1f,
0xed63fafc,0xef83fa49,0x05dd06b0,0x18a9bd33,0xdbc71937,0xea7ffe8b,0xef38fb82,0xd7e140c1,
0x170ce58b,0x03ba03e1,0x10faf58b,0x131aee7c,0x028ffdaf,0xecfe18bc,0xebf81cbf,0x3f64076f,
0x164bdc61,0xf2011a4c,0x12e53138,0x1ec7eb27,0x056a2ef9,0x4dd1f3aa,0x1455fc06,0x33b2130b,
0x06640df7,0x070b1b90,0x13fb3fcd,0x3baeeb8a,0x02610b9e,0x067a23b9,0xfc3a21d5,0x0d9d16d4,
0x1af3f36a,0xe71c1e36,0x2060f38d,0x0289e6e3,0xe1c10550,0xe99c090e,0x04a1f453,0xcf25d9b6,
0xef2d12f5,0xe229ccf9,0xdcc9f39a,0xf9d3d0d9,0xadbfe269,0xd1b7f4e0,0xd63cfa0c,0xf389c33c,
0xd3f8db35,0xf0bfe743,0x1775b078,0xbd3cdc41,0xefe0f03e,0xc4a4ff6b,0xe8a9fad2,0x0ff5e070,
0xd306da56,0xe9de2c5f,0x0071dd6e,0x049decd9,0x020cd6be,0xb13e2965,0x01381c6a,0x228ec39e,
0xf369eeb2,0xe359f94a,0x30a5eed3,0x25b0aa58,0x0c83d15d,0xdce41024,0x0a64f5bd,0xda81150c,
0x278bfde6,0x1264e873,0xeb530025,0xf9812996,0x0a801030,0x091209ec,0x079efa1a,0x00d9258b,
0xf66702ae,0x1c251e85,0xecef03c8,0x120d1f83,0xec642cdf,0x2c8d025b,0x0a0d1820,0x037ffea8,
0xfcd82315,0xf5c21b39,0xe99a14d1,0x19881771,0xf1f8f144,0xfc0f1d4d,0x4cc2cb4d,0xd8aceba3,
0xdee01d0c,0x153c05de,0x0594dc70,0xff8fdddb,0xf4fff9e7,0xe0f10367,0x1a2ece75,0xf71ce88e,
0xc086e885,0x0c1d0247,0xef58c65d,0xdf4cecc0,0x066beb81,0xd2c0d113,0xec71f41a,0x0834cabc,
0xd80cd0a5,0xd1b607a2,0x06bcd857,0xfbadcf70,0xdc2ee701,0xe58305b6,0x21c0b4e4,0xd0fff410,
0xebcdf8a5,0xdebafed0,0xdf780577,0xf86a0115,0xf2c4f7a1,0xf099f18e,0xee691ac4,0xfff6fb1c,
0x205ce8ea,0x2288e3ab,0xe963f57d,0xe6a93154,0x096d10e0,0x1337ebbe,0xfc4326a4,0x2754fd13,
0x2599f369,0xff4a0561,0xe8653cec,0x16f71dbc,0x1a9e12e2,0x0536faa4,0x025f2e3b,0x0468131c,
0x212a1cc3,0x1445fbfc,0x1ee310f3,0x0a37fd30,0x03e60d53,0x1b8514d1,0x1bc5e7db,0x02d30466,
0x14a4edc8,0xeef00383,0xf8500c21,0xeaa1fa7e,0xe96d164d,0xf0b80b1c,0xe056f8b1,0xf11611b3,
0xf78cd85b,0xd6bd05ac,0xe037fe2e,0xe298f903,0xd4a2fb07,0xf4cdefb2,0xf670d5ce,0xfdf7dfb6,
0xf73fd2fc,0xe906cef6,0xcf1506a5,0xfd8add39,0xe1f4dc80,0xe0aee714,0xdbbdfbef,0xf2fbdaed,
0xe82cf058,0xeed9dc7c,0xdcc604ff,0xf16cda3f,0xf347eb8f,0xe198fd60,0x0a23d4fc,0xed9ce7ef,
0xd04e0283,0xe1380212,0xfcb9fa92,0x04b2d9f3,0xe9b9f652,0xfb820488,0x0adbedcc,0x1e0be00c,
0xef2a0392,0xfb11130e,0x0876f9e0,0xf621204a,0x15a601de,0xeb5324cb,0x2b89087b,0x0db0fd14,
0x06a92140,0x241213bf,0x03e006ed,0x09022dd1,0x26c5036c,0x09d015e4,0x1b5cfd7e,0xfa0c24e7,
0x1b5011e1,0x0fa4012f,0x0ea010e5,0x03e20ff5,0x04680da5,0xe991301b,0x047415be,0x0cf4fec5,
0xea401b56,0xf481fbcc,0xf1822258,0x022df509,0x2efbd4c0,0x01ded0e9,0xdfc302b7,0x0708eebf,
0xea13de70,0xe05104b8,0xebb8eecf,0xfa3cdcc7,0xcc77eed3,0xe3e8fc02,0xd895e2f0,0xe2f3e8aa,
0xdfaaed9c,0xede8ee80,0xfdeecfed,0xf920df41,0xdfd8df35,0xe32ffbbd,0xecd6e958,0xec00ea2e,
0xe7e3ebee,0xe52bf710,0x10e1de6e,0xf4eee509,0x0a04d0cd,0xfcb2df09,0xe873f162,0xf3defda3,
0xf0cff9b7,0x0367f642,0x038fe11d,0xe76608d6,0xd6f2251f,0xefd809ab,0xf4891cce,0x1056fd8d,
0x0f02fc37,0xfd0601ea,0x04492604,0x1971f46c,0xfa5f1f35,0x0c19144e,0x26c914d8,0x26eafaaa,
0x102c101f,0x15270e19,0x15371a87,0xfcea11fd,0x14642191,0x25190096,0xf30e0b3b,0x159b28fa,
0x202dedd5,0x03331080,0x084403b5,0x0cf80d3e,0x0906f45a,0x06130b21,0xfb71fe41,0x070a043e,
0x0f69eedb,0xe826fc55,0xebc10e6d,0xf1c7042b,0xf5cffb1c,0xe992edb1,0xe4b9030c,0xf52b00f6,
0xe719df15,0xfe15ea73,0xdc19eb32,0x0504e221,0xf485d81f,0xe4b6dd64,0xe38ceb9b,0xe943f3c9,
0xec03da99,0xd302fede,0xce75fc4e,0x01dd00eb,0x0c4dc78a,0xec36df6d,0xef83fc1c,0xf043f741,
0xf29bf060,0xf0d6fb37,0xd1d50cf8,0x04b803ab,0x0a4cebf4,0xfa73fb3c,0xf5f9064e,0x1624fd85,
0x0105f1a9,0x01b00bb9,0xfcce1062,0xd11a28f3,0xe61c46c8,0x195811e3,0x213dfec5,0x19a8fff0,
0x07ee160f,0x1e25085e,0x2a26fe9c,0x1556fefb,0x046020dd,0x15340d0c,0x1af110e7,0xf786fe8f,
0x17281dea,0x0ed5f5b3,0x129cfc32,0x0e9901b1,0x1729ee91,0xec810dee,0x03591464,0x00f2f87a,
0xe74d0cd6,0xeb322815,0x12d6e8ee,0x0d97f358,0xec9df619,0x0d17f91b,0xefe6ef73,0xfac2f7d8,
0xf04dfe31,0xe9ecedf4,0xd2a40a2c,0xf6300395,0x0613dfe5,0xfaf9d99f,0xd8dcf9a3,0xe5900908,
0x0f06e47a,0x05fdc0f6,0xd89bfdc4,0xf42ef27a,0xdb6df263,0xfdd2fac1,0xe622df79,0xfa15fa27,
0x025edf01,0x0099de28,0xf127f0c5,0xd117071d,0x007b0387,0xfb84ee1d,0xeb11fb08,0x11b7f289,
0xf158efbc,0xfffcfd26,0xf233fc4c,0x01620a70,0x0727f181,0xe3e20ab3,0x055f189c,0x2247e448,
0x2737d340,0xe873fae8,0xf4f8242c,0x01e60630,0x0e7af0b4,0xee0909d7,0x03581fc9,0x05a2fa1a,
0xfb7a13ea,0x00ea1644,0x07800811,0x193c0b0e,0x0ac1fb2a,0x050a148b,0x1b95048b,0x0b23f886,
0x066f0bb6,0xf43b0f5a,0x117c10c0,0xfdc9ffef,0xf42b12a2,0xfbf21a19,0x11e5fc09,0xf07500ad,
0xfb701333,0x028f00c3,0x1189f83a,0x0f7ae46d,0xf198f540,0xeca40915,0x03d2f30f,0xf2f9edcc,
0xdeb90441,0xf05ef955,0xeb5df420,0xf7afe832,0xf4f1e8fd,0xe21fe781,0xf2f5f4ad,0xf15fe4a6,
0xf3c6f0d6,0xe466e6ce,0xf12ff976,0xe36af3d3,0xf89fef29,0xe88aee38,0xf06ef99f,0xff69ea5d,
0xe310ed4b,0xef270f6a,0xfbf6e99e,0xed1dfca9,0xeede0c1e,0x1b29e918,0x0316e04b,0xf4aef7ef,
0x0ea7fe56,0x0af9e26c,0x09b9fbad,0xeecaf49b,0xfa9c1802,0x01a3fb9b,0x05ff053e,0xfcaa00d1,
0x0bb80c44,0x0048fbfa,0x0c700b39,0x027d01af,0xfc5e18ec,0x0a680524,0x0d400608,0x01880af2,
0x0e08048b,0x08840b5b,0x02b500ad,0xfd441794,0x0de504d9,0x0c3305a3,0x185af81a,0x10caf16c,
0x02cdffd8,0x09cb05af,0xf8d1f77a,0xfaf1082b,0xfe3d0446,0xf99e099d,0xfe21ffa1,0x03defdc1,
0xf2fe014c,0xffb902a9,0xfa79f455,0xfdebfaaf,0xf9a0f142,0x0459f6a6,0x0069ef2a,0x03a9ec7c,
0xf9cbeb24,0xdb2200e3,0xdda01359,0x007601a9,0xecefef78,0x0cb5f09f,0xf6dde1c0,0xf9b9eca3,
0xf05ff275,0xf9edf251,0xf239e9b9,0xe81904ce,0x00a5f7a2,0x03b6dd83,0xfbe3f82e,0xe328fd8a,
0x05cfffb9,0xf8d3f7ca,0xf712fb32,0xf96d0217,0xf6970aee,0x122ff002,0xf32d0706,0xfcb30b63,
0x016a0385,0x1b4404bf,0x11cfec30,0x045a0537,0xf055144e,0x0821195a,0x009801c8,0xf9bf1966,
0x10720d78,0x1390fd5f,0x020e062e,0x210b037a,0x05f8f435,0xfdec1625,0x05480cdb,0xf7b411ca,
0x0e2e1338,0xfb810775,0x14450f2a,0xfc740bd8,0x223d0a24,0x2402ecf6,0x0edafda0,0x020f0a48,
0x0d6e1311,0x0f73f7cb,0x0b3406be,0xf1cbfcef,0xef1d2635,0x0fb20033,0x0288f7ac,0x0252fa3b,
0x0bdefd10,0x0ae5e35d,0xed8a0a42,0xf2bd05dd,0xf35e0944,0xf58103cc,0x0234fcce,0xfdc5f776,
0xf837fb24,0xe8d8099f,0xfed60c21,0xfff0f35b,0x02f3f46e,0xfb46fc06,0xf9ed0082,0x0031f8cc,
0x0189fa53,0xfd99fd57,0x089b0244,0xfb85f391,0x06c50c71,0x0405f8ba,0x04cafe5f,0xf32e0694,
0x076e0645,0xfb9bf7b7,0xfaed0e8f,0xebc808c8,0x0043166e,0x0e32eddb,0xfb1c08e7,0x005e067e,
0x0bcbfb84,0x10fb06c6,0x1167e7b6,0x095fffa9,0xfa110e01,0x0b01027a,0xff410445,0xfce11045,
0x02450b29,0x0fb6fb00,0xf3500e5c,0x06de125b,0x0a0b05f2,0x02650be5,0x1b25fbdf,0xf9b90d4b,
0x02491055,0x176c07d5,0x0981f8ec,0xff140dc2,0x08e90ee3,0x0dd9ff88,0x1056f831,0x04220e18,
0x0676ef28,0xf41f1436,0xed940bc1,0xfe5f1175,0xf5eff98c,0x00e40b28,0xf589f7bf,0xff5708d1,
0x02a1f85b,0xf222fe0d,0x03430d96,0x059eed44,0xfaa60710,0x09bef5a8,0xeef30490,0x189bfd25,
0x0661e460,0x0aaefe87,0x0037ecd0,0xffac0a84,0x1440e859,0xec5b0008,0xe8fb190a,0x0bbd0533,
0x1033eef6,0x0316f06b,0x03c5fd70,0xf0410abc,0x0eeff617,0xf173013a,0x03f505cb,0x0880f30b,
0x1198f02c,0xfdb9f949,0xfd2e0191,0x0219ffea,0xfb8c05d0,0x04ef01d0,0x0aacf68a,0xf4e40451,
0xf0290e93,0x000e1221,0x0722f62a,0xf03d0df2,0x0bc20fe8,0x1203efa5,0x04680073,0xf4ac136e,
0x0b780374,0x079008dd,0x04d60139,0x112006af,0xfa4a0b7d,0x1043ff5a,0x05cd10cf,0x1a4af92e,
0x08780367,0x033a0804,0xf727180b,0x16540802,0x063ff612,0xfa3a14e2,0x072c081c,0x081dfdcc,
0x088c03d7,0xfda2015e,0xffa80762,0x0376f9f2,0xf9240d58,0x03dcf7d3,0xfb0f0643,0xf8ab0538,
0x07d3fba0,0xf72b02ba,0x0dc2f468,0xf538054b,0x03c0fb67,0xfe94f55b,0xea5007af,0xf2bf0b1d,
0x02a0fb66,0xf46dfb08,0x0245f86c,0x063bec79,0xeaccf730,0xfdac0569,0xf75ef32b,0x0859f003,
0x0099ee3b,0xfeedf6a3,0xf989f514,0xf26206ba,0x075cf8c4,0xf5e0f637,0x02920561,0xf538061a,
0x08e9fd73,0x0f85faee,0x0197f7b3,0xf6871287,0x077c09bb,0x05ef06b3,0x0658049c,0xf6e512ab,
0x0f96116b,0x0d7bfecf,0x11bf0227,0x0f04ffef,0x07ad0dd1,0xff3d1217,0x0fbc117c,0x141c086b,
0x015b1334,0x1efe051b,0x086c071e,0xfe781083,0xfe861c31,0x0e8f0c9d,0x136b0618,0x13bef61e,
0x0038085d,0xff2c0e54,0x05380bf8,0xfb35062a,0xfe8508b5,0x08c10693,0x0412f397,0x15f4f9c8,
0x07cfec88,0xffecf4e4,0xe0961171,0x02bf0f2f,0x1062ef15,0x00fbecee,0xfa8a01d8,0xf2670435,
0x05f202aa,0xf956f5c6,0x03370453,0xf559fd1f,0x0116fe85,0xf59ffefa,0x0c6ffb54,0x060ae76f,
0xea62fdfb,0xf0c30e2f,0xfe1af967,0xf298fcb1,0xfe95036c,0xfa72f6a2,0xfca5f7ac,0xfae90176,
0xfae0fbe5,0x095df400,0xfa59fcee,0x0226fe31,0x0324fa6c,0xfb35fec3,0x04a3055c,0xfa5dfe2f,
0x03cc094d,0x0091fd34,0xf2711052,0x05620d7c,0x0c4bfe44,0x17dff512,0xff0d003a,0x03150cb5,
0x04af083a,0x159c025f,0xf8050246,0xface2224,0x14b3ffd9,0x0d33057f,0x05750171,0x05ad0f07,
0x15c9fd35,0xfa380068,0xf8d2120d,0xf94413fc,0xfda3076a,0xfc8d0629,0x06a20634,0x0197f930,
0xfc90055d,0xff91fff5,0x0404ff88,0xf2d50425,0xff9e099d,0xfcb4021d,0x152bfa27,0x0361ea22,
0xf2a609da,0xff0e03b1,0xffeb06d7,0x099bf08c,0x0f10fc3c,0x0101f1a8,0xf87506d9,0x05cb040d,
0xf83dfa7a,0xf77d0e2a,0x0cfe00a7,0x10b2eb9f,0xfdd7f6bf,0x00abfe42,0xfcf3fea9,0xf9260581,
0x030701df,0x0283fa9d,0xf96900fe,0xeaf013de,0xf36a0c9b,0x04100b5d,0x1058f488,0xfc2df81d,
0x0a8408ff,0x0472fa1d,0x07df02ff,0x01e60781,0x0efa01b0,0x01160035,0xfe2a14d8,0xff6b098b,
0x085806f8,0x0e1600a2,0x01b902fb,0x10edfdd9,0xf541084f,0x046310eb,0x06920a11,0x0c55f813,
0x08590a3a,0x04ce0086,0x04410af5,0x0feb016d,0x0826fff6,0x081f059b,0x0768fc36,0xf2430e94,
0xfda1149a,0x04f302cf,0x0777fea3,0x00abfefc,0xfedf03bd,0x01a60574,0x086dfb12,0x0396fbca,
0x04fdfab2,0xf6e30629,0xf4b40826,0x00a50e74,0xf6d70147,0x06ed09f0,0x0984f992,0x0c77f956,
0x0964fd30,0x0652fca5,0x0e4c0188,0x0701fc7b,0xff75074f,0xfccc08eb,0x031106da,0x05cd010e,
0x045403aa,0xfc730041,0x022e0b9c,0x01bafe42,0x06ec01c2,0x0393f8d0,0xf8cc07db,0xfdf3090e,
0x0893fff3,0xf61004bd,0xfd420ecd,0x062504dd,0x0774ffa7,0xf50809c4,0x07800f4c,0x074efb3f,
0xf37310d5,0x076f0b1f,0x0aaf03e4,0x02a10380,0x09ec0754,0x0c6efd69,0x00f00534,0x0c6a03df,
0xff4803c6,0x0d470679,0xfcbc0156,0x07810a92,0x03b8fda3,0x087b0185,0x0dc3fa2d,0xfce90249,
0x0554067c,0x03bd0405,0x069b0132,0x078605aa,0xfbb0096c,0x01b0125f,0x1a1bfd28,0xfdb4fed3,
0x0cab0f9e,0x0ba5fea2,0x058406a6,0xfed31043,0x0b530b63,0x0d54ff50,0x0c0604e6,0x0670035e,
0x0e4d03e6,0x0bcc0105,0x0a15016f,0x0130081f,0x04580099,0xfffb085a,0xfb760827,0x095e0582,
0x0025003c,0x063cff97,0x02b10118,0xfe7e03ee,0x05a301a2,0xfca90312,0x010502b2,0xff92037c,
0x031cfff0,0xfdd20069,0xfdb805bf,0xff6004c4,0x01bffe00,0x034f0445,0x04e0fdc1,0x022afe55,
0xf8940eaf,0x09d7085b,0x08bbfe75,0x08060687,0x0a240535,0x0171072b,0x0e0606cb,0x01840a7a,
0x122f033a,0x04940129,0x03b40bcf,0x08f408b2,0x044e0497,0xfc3b0748,0xffc70e58,0x02bd02e2,
0x049105c4,0x01190082,0x012302ae,0x06bffdec,0xfc4a0029,0x032e0592,0x0a2ffea8,0x05d3f83c,
0xfbb20750,0x019205e4,0x035b04c2,0x07f1ffc3,0x03030026,0xfec505b4,0xf6660b81,0x02d20ad6,
0x008bffc8,0x08890176,0xffaffba1,0xfb8c0c3f,0x08fe00e8,0x053ef97f,0xfff60494,0x06e30351,
0x054ef7d4,0xfd4209db,0x061dfffb,0xfc5c00bf,0x0c70034c,0x000df733,0x0741003c,0x040c008f,
0xfc82fd61,0x03db083b,0x0392f9de,0xfee60223,0x0b08fdec,0x042ff900,0x01e30131,0xf91c0761,
0xfc1f0bbf,0x061e00bb,0x036800d1,0xfad50b27,0x0a110202,0xff88044c,0x08780279,0x02b70553,
0x005c03fd,0x05320a73,0x102efb64,0x04c8fb57,0x05b30832,0x022301b6,0x00420a84,0x03e30766,
0x0957ffe4,0xfc220883,0x062a0a91,0x1079fc37,0x002b0469,0x068b0a02,0x0755058f,0x0a3cffbd,
0xfecf09f6,0x0c270894,0x09c401bd,0x08800331,0x0ec804cb,0xfdfe035f,0x03da0dbb,0x04a909ed,
0x07ea06bc,0x050404c2,0x07010614,0x08cbfed0,0x07cf0575,0xffc405c1,0x02d20b29,0x070e0783,
0x045d0481,0x0675066a,0x064b0215,0x07ff04da,0x07f90099,0x001e0131,0x03fd0581,0x035e01e4,
0x032e010a,0xf99705ad,0x024c0837,0x06770032,0x03e6fea6,0xfb76067c,0x03600745,0x047e00b9,
0x03090519,0xffcf072b,0x058f0743,0x0888ffd8,0x0b5e0346,0xffc202c2,0x08c20c3b,0x06790560,
0x108f02ea,0x07b30043,0x060f06ef,0x0b0c05dc,0x0987037f,0x00c10778,0x0a0a07ba,0xfe9f0634,
0x06910cb4,0x0542ff51,0x0550077c,0x0566010c,0x00e004a0,0xffd40633,0x05f3083b,0x0841fdca,
0x06a702a3,0x058601dd,0x020207b7,0x07f70519,0x04c40355,0x07e8058b,0x03d30420,0x066f07e7,
0xfc890a94,0x05af0de3,0x0a8802bd,0xfcab0976,0x05c40b00,0x062707e4,0x05130563,0x04d30759,
0x0584066d,0x0b490119,0x0826feb4,0x0800fef0,0xfebc06b3,0x088104c7,0x01910351,0x0718057e,
0x02c90408,0x079203d2,0x02970346,0x082c019d,0x00380335,0x052204b5,0x018701e0,0x039801e1,
0xff410636,0x0334051a,0xff98022b,0xfff408da,0x03f40520,0x02ea0210,0x03510680,0x04d603d2,
0x0947029f,0x018d0304,0xff710acf,0x096008b6,0x0bfafedd,0x044405ce,0x05800943,0x09a00558,
0x0c24046a,0x06c101ef,0x08b90819,0x076101f4,0x028309d9,0x0602078b,0x09090597,0x053d01a8,
0xff1c0a6f,0x032a092d,0x09680588,0x075cfefa,0x0311064b,0x02000859,0x08080460,0x092eff61,
0x06f50305,0x041c06e4,0x0b1b01e6,0x05aa013f,0x01260b7d,0x04b10952,0x046606f8,0x04320a2f,
0x063f0733,0x03fc073f,0x08240809,0x06ff0205,0x07a204f8,0x036204e4,0x020407f7,0x04d607f1,
0x033f036d,0x063f02d7,0x0472045a,0x034a0280,0x0381053f,0x040e02a1,0x04e10468,0x078f017d,
0x037a029a,0x02cf0528,0x0665048a,0x04640676,0x0517055d,0x06780551,0x03bf0815,0x0842055b,
0x057f05b2,0x07b0069c,0x042606db,0x080807cc,0x07800561,0x07cb06da,0x08ab04ac,0x06060717,
0x077d069e,0x05240703,0x03c0092e,0x0630070b,0x08dd05b6,0x068e01f5,0x0270092e,0x04900846,
0x0a4a0222,0x0210058b,0x04840693,0x05840709,0x086d0451,0x079c03a2,0x063d03cf,0x034c0592,
0x0537083b,0x054904a4,0x0787038e,0x05d00333,0x0476046a,0x021505ee,0x0196092f,0x055206eb,
0x07b90377,0x04ac0488,0x06770444,0x03990570,0x038c0622,0x046a0507,0x033e065c,0x03c7069b,
0x05f40345,0x0387053d,0x05600561,0x05e50212,0x046404a9,0x04480324,0x058a042f,0x0624024d,
0x049701b2,0x01f4085f,0x08ac02c0,0x0359031f,0x02c4077c,0x02d3085b,0x027c087f,0x07a2078c,
0x08e30480,0x08a90421,0x077f0673,0x02fd0a8c,0x09c1082d,0x08db06fd,0x08c40828,0x0a5804bd,
0x066708eb,0x0a1d080c,0x07b1075f,0x07460826,0x04160a4d,0x067f0a43,0x07fe0816,0x0b5a03f2,
0x05f804d2,0x06a70876,0x0818041d,0x056a0706,0x062c04f9,0x04240a37,0x077803a9,0x05bc05a4,
0x052c065c,0x06140437,0x071d0556,0x03530513,0x04d20658,0x0694051b,0x04aa02de,0x038906cc,
0x05ab0349,0x05250492,0x03d1045f,0x042105a0,0x03c30418,0x049904ee,0x02bf047a,0x03850593,
0x067503a7,0x0435021e,0x01e60678,0x0579056b,0x04ab0279,0x04dd0570,0x042f046a,0x05be0573,
0x05c60422,0x06240505,0x04b30525,0x05c905b7,0x06790560,0x0564055a,0x071c067d,0x061304a2,
0x060e070b,0x06da064e,0x058607f0,0x07430686,0x064b079d,0x050e0831,0x08f00775,0x072406a4,
0x085f06ec,0x0766071b,0x087606a6,0x083b06ca,0x07ac06a1,0x067507fd,0x074708ee,0x07860722,
0x076d0785,0x06e507da,0x06f30727,0x0647085c,0x07460712,0x07270700,0x06bf0738,0x0750060f,
0x064e072c,0x06f00675,0x071205e9,0x065e05fe,0x06380666,0x059a060e,0x05f70700,0x06a90530,
0x05ef05a3,0x05fe0670,0x063b05aa,0x060705eb,0x067d05ed,0x0588060e,0x05e3060e,0x06070637,
0x056705bb,0x05d706aa,0x06480563,0x060a061d,0x06410599,0x062b05b3,0x05ec05c5,0x059d067d,
0x05b8064e,0x065b066f,0x07110559,0x063e05a3,0x05d10681,0x061106c9,0x066c0680,0x066a0639,
0x06ba0686,0x068f0664,0x06ad06ab,0x066806b5,0x0703068c,0x06970668,0x067506c7,0x06c0069b,
0x06bd0652,0x06c5063f,0x069c069c,0x065b064a,0x066206b2,0x06150662,0x06ac0649,0x06290606,
0x06130669,0x062a061e,0x060a0619,0x062205f1,0x05cd05d9,0x05c0061a,0x05dd05ce,0x05aa05a0,
0x054b05e0,0x058605e0,0x051805a5,0x055b05d5,0x05ac053f,0x0562051d,0x052c054d,0x05830548,
0x054a04a3,0x04d30546,0x04d4052d,0x04f404f7,0x051504cb,0x04a5049a,0x04b304f9,0x04d70498,
0x04950490,0x048c0499,0x046104a5,0x04910482,0x04630463,0x04560471,0x0455045d,0x044f0445,
0x042d0447,0x04310436,0x04260426,0x04210406,0x03fc0415,0x03f6040c,0x03f403f5,0x03da03ee,
0x03ce03da,0x03bf03da,0x03c003c2,0x03ac03ae,0x039e03a5,0x03960394,0x03740390,0x0374038c,
0x036d0371,0x035d035c,0x034b035f,0x0346034c,0x03370335,0x032d032f,0x031b031b,0x030e0310,
0x02fd0303,0x02ef02f7,0x02e102e7,0x02d202df,0x02c702c6,0x02b702c0,0x02aa02b1,0x029c02a3,
0x02890295,0x027f028a,0x02740274,0x0263026b,0x02570259,0x0248024e,0x023a023e,0x022c0232,
0x021c0223,0x020f0218,0x02010209,0x01f401fb,0x01e701ea,0x01d801dd,0x01c901d0,0x01bb01c3,
0x01ad01b5,0x019f01a6,0x01910198,0x0183018a,0x0175017c,0x0167016e,0x01590160,0x014b0152,
0x013d0144,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_13_standard_DRUMS_floortombrite[3712] = {
0x00000000,0x69b65991,0x53a9421d,0x3b7a5455,0x0ec158c6,0xb5dd7259,0x432aa760,0xdc2be746,
0x06deba7f,0xaa5b8e4c,0x8e4c18dd,0x8e4cfc66,0x96fec8df,0xc339ad67,0xe96b9deb,0xf2ff8e4c,
0xdf88c134,0x2174b335,0xedd8e0e6,0x28cd1d5e,0x36c70c73,0x3a1ce304,0x6cc4145c,0xeced36be,
0x33425de8,0x4bc54535,0x1a682f17,0x54303f93,0xddca43ab,0x3ff06e2a,0x3a03ede1,0xe99a36bd,
0xfaf3fd0f,0x3e45ecb0,0xf03be098,0x18e432c3,0x20b419ba,0x1fff4e3b,0x4d9bdbf9,0xcb2531e5,
0xfcd86101,0x5136e25a,0x0bf1971a,0x207816ba,0xd79a26ad,0x57cfbf36,0xe5f9e4e4,0xcb7b1bc4,
0xe1aadfbb,0xd8499f70,0x8e4cc3ea,0xc997d6b9,0xa94ba34e,0xbff48e7b,0xadd0915d,0xb51cd54d,
0xac03c039,0xc492ead9,0xd513c609,0xd5dfd93c,0xe030e21f,0xfceacf66,0x20a903ae,0x35e5079b,
0x206b2828,0x34911f5b,0x0c05670c,0x3fca322e,0x2c0844e2,0x3dc027ba,0x26cd43f1,0x2e773d3f,
0x4e5afd6b,0x3136f1fe,0x19ff18ba,0x29ab06ae,0x07cf2426,0x1f9f1519,0x161b24e8,0xf59b38bb,
0x3e9c252b,0xe9c80601,0x19bb1518,0x10bf03b5,0x0155e16e,0xd910eef9,0xd25f0792,0xf9f7f7d2,
0xd014de89,0xd912f0d0,0xda540247,0xdcb5d59c,0xe0b9d2a7,0xc136cdf5,0xcf65da17,0xb734b4ec,
0x8e4c142d,0xe470e1c9,0xe9efc790,0xc3e7bb64,0xf360df64,0xe575c0d2,0xdc7cd1bb,0xf6ffed2f,
0xd599c131,0xe51a15b1,0x27ed0b60,0x1d7bf02f,0x1b8e0d02,0x280540b7,0x30eb3668,0x25414334,
0x59e732db,0x4630223e,0x3de035f8,0x2ec11c3e,0x10ae3105,0x374c2f4f,0x20ce0d7a,0xf0933255,
0x070b2bf1,0x04d11632,0xfaaf3bff,0x31fd0cc7,0x1c1624a3,0x15d00b0c,0x0b550c70,0xfbb40796,
0x0d2e08d9,0xe466eb8d,0xdd5d1cac,0xfdd8e01b,0xd071e1db,0xd676fa00,0xdfd7d0b8,0xe120c860,
0xd64cc847,0xc52be857,0xecdddcc0,0xb359dab7,0xe967e946,0xfa52b054,0xdb5eb98a,0xc077e805,
0xd16afdc9,0xe44fcdce,0xca9be529,0xe043dd0c,0xdb61c196,0xe785ff85,0xe2fbded4,0x1243f8d4,
0xf4f1f879,0x195411f6,0x37e90b46,0x275b1672,0x4da925c8,0x2d1538bd,0x2ffc5cde,0x3e5947fc,
0x3f36431d,0x47583001,0x3ff126ba,0x348f2564,0x2a992e5f,0x36af2fc6,0x031a1fbf,0x18f71f4f,
0x38f4ff3a,0x1a33ee83,0xd90f12cb,0x14592346,0xf1c50408,0xee3c1985,0x01c4f6e7,0xf588df57,
0xe552f0fb,0xf391dcca,0xbc04e62c,0xe387e9a2,0xd0a8d1d3,0xdadadb76,0xd4d8c058,0xdea5c56d,
0xe321d05c,0xd0c2c27e,0xad57f4c1,0xe23ee26c,0xaeced8c0,0xea83e271,0xed43bd71,0xd3d3eb63,
0xf096e00d,0xdebcfe54,0xe233f687,0x39dbc405,0xde7ee279,0xfaee142c,0x0ac4f233,0x030d21cc,
0x176c30de,0x2e0d05a6,0x1f072717,0x48b52fa4,0x3a061c3d,0x32d94668,0x44713b15,0x38d25b79,
0x4d28245f,0x2d6c5086,0x40d2248d,0x28062d7b,0x109c4c54,0x25d52806,0x17d52643,0x291e0ca2,
0x023401a4,0x01f611ea,0x05eaf0d5,0xec16f5c8,0xe450fc66,0xf252ecfc,0xec67ea9e,0xdc34edcc,
0xe5accabf,0xef94d7e1,0xd94ecafd,0xd5ade6e4,0xd8c4e072,0xd0b6dfca,0xd5f2d981,0xc080db12,
0xc520cce2,0xcaecd447,0xdd0cbdf5,0xbfa0ae37,0xcdacd47d,0xbf85e6f2,0xf74fc9ff,0xd9cdc63c,
0xd32d0008,0xf2e1ed79,0xf5eafa25,0x04041a40,0x2288fdc6,0x17241219,0x17771cd2,0x232e1da9,
0x228126d5,0x46053463,0x32fc3a24,0x436630e5,0x48e332e8,0x2ccf47a1,0x31563e9a,0x41dc2e37,
0x23dc58d4,0x467b26b9,0x1fa12705,0x30d1459d,0x311f119c,0x08872934,0x13a9224f,0x07f8fd90,
0xf7551552,0x15fbf535,0xfdf9e329,0xd434f7e1,0xfa1be334,0xdc22e077,0xd58cea1a,0xebafe2fd,
0xde7ae391,0xe69adfdc,0xe134df49,0xd465ec37,0xe6c4d3d0,0xdba0e4c3,0xda13e58b,0xe0cac6ac,
0xd365d041,0xd5ced976,0xd21dbf29,0xc7e4c253,0xbd05ce66,0xd0b3d80d,0xd1b1b563,0xd83fd164,
0xe9f5ebae,0xdaa5e04b,0xf01910b3,0x00bf03b2,0x2fa204be,0x17f51719,0x20192ddb,0x38461b7a,
0x29c64297,0x419340c0,0x4ab03835,0x4a6f4105,0x41a34780,0x39e33c12,0x3c2034bf,0x24683622,
0x32472d7c,0x247a1c07,0x29ea0929,0x06e01d7c,0x1c8a1265,0xfe2c1b35,0x0ead1fd9,0x0e7b17af,
0x0f3dfeea,0x0456043c,0xf61aee43,0x0dcd05d9,0xf475ee20,0xfc9dfae6,0xf1a3e74e,0xe9a3f589,
0xea2bebaf,0xe6aae8f5,0xe2cfe232,0xe5c7dd3b,0xd857e402,0xe80edd31,0xdc08d29c,0xd883ec94,
0xd25bd650,0xd7d9d758,0xd87ad29a,0xda30db4e,0xcb98d452,0xd6a0d001,0xc7f5ddbd,0xce91d08a,
0xce7fca97,0xdda6d980,0xe056db7e,0xf114f086,0xfed7f428,0x17f3fd69,0x1193f93b,0x109e3984,
0x266f1f5b,0x2f8532f5,0x33fc3640,0x48984349,0x51d5347c,0x3bb7386c,0x3c474726,0x313e36b3,
0x2ad6307f,0x308a347f,0x285834bf,0x29012609,0x135113f5,0x0bbd13cc,0x119c117a,0x12ddffa4,
0x078afe27,0x05940fa7,0x182720d6,0x0871fa17,0x02470dc6,0x084c073e,0x06d10160,0xf6daf118,
0xf881fce4,0xfb5eec3f,0xebcafc0f,0xf2dfeb93,0xdc4ce888,0xdb38e4db,0xd5b9e1d6,0xdc53d317,
0xd954d535,0xd9ddce8c,0xd730d82b,0xc6f1c2e6,0xc5c4c860,0xbcfcd51e,0xcf26c7f5,0xc943c3d5,
0xd48ae3a2,0xeb01cdf0,0xe685f019,0xe455f4f5,0xf146ebfd,0xfb7af635,0x0056efe5,0x0383ffb9,
0x0e700ab5,0x14b615da,0x1f6f306f,0x2c5615f2,0x2da92b73,0x31b435a8,0x46c43b68,0x40b536e7,
0x35243ec3,0x469a334d,0x2ead3a3a,0x349730b3,0x2bdf2a81,0x2ac23105,0x272e263e,0x10ac2025,
0x186d1625,0x0bf00685,0xff730d86,0x03130c89,0x03c7056a,0xed13f9ef,0x0378fe8a,0xf642f95e,
0xeb63f063,0xefd9002a,0xf8faf1ce,0xf298f31f,0xf9d1f733,0xff5ff5f6,0xf19ff665,0xe4edf13b,
0xe9d4db0c,0xde27e64a,0xe368e027,0xd525d7a7,0xdea9df2a,0xd74cd548,0xd60bd556,0xcc2dcf43,
0xcf65d0c3,0xd76acdec,0xd6d7da8b,0xd0d9e186,0xead8d7c7,0xe687e33b,0xfb04e8cc,0xedffe5ee,
0xf606efe8,0x055d0db1,0x0f340257,0x10051031,0x31261a86,0x11bc1d90,0x27fb264e,0x1e441e4d,
0x2121220c,0x208b2f07,0x20771f17,0x215229b1,0x2a9b258e,0x1f6b2400,0x31862c61,0x2a5626f1,
0x255226ca,0x29f12f7f,0x21f5231d,0x224a1fec,0x140b1cd6,0x0f511fd0,0x13471c2d,0x15d40d65,
0x0ccb0dae,0x0b550b5b,0xf9e504ce,0x0b97fc8c,0xf29ff12d,0xf61df629,0xf04afd3e,0xfa20f320,
0xe8fbf83c,0xe71ae991,0xeb4ff1fe,0xe960d8e9,0xdd59ed63,0xed5be556,0xec3ee436,0xdf47eafe,
0xde5ce57d,0xd5ffd584,0xd3ecde70,0xd3dccfa0,0xcdb8c844,0xd534d532,0xcf2ad2ce,0xdc06cfec,
0xce89d8f6,0xdf12e279,0xe4bfe447,0xe7c0e596,0x006af0a2,0xfd0aeee0,0x05d810fa,0x16190a48,
0x0a381973,0x20921454,0x1fdc1e82,0x25b628b3,0x2a1e23ba,0x29dc24b5,0x2b832d18,0x32022aa1,
0x1fd6255f,0x2b6226dd,0x24c0279e,0x1b4a14d1,0x1fb22ac2,0x21fe139c,0x19342422,0x1efc1744,
0x271a2802,0x1acf1d70,0x1ecf2382,0x21a2288f,0x2051217c,0x10f0184a,0x1a160ff5,0x013d0e05,
0x043ffd18,0xfefaff4e,0xfd42f9da,0xe6a0f079,0xec1ff093,0xe652e82e,0xdb9ae5bf,0xdf38dc9e,
0xdaecd53c,0xdb3ae45d,0xdb1addef,0xddf0de6e,0xd6b3ddb1,0xe112d6b3,0xd99cd79b,0xd79cd71a,
0xde51dd3a,0xce7dd876,0xe4d6e50b,0xdc5bdd9e,0xdd58d57e,0xe435e266,0xe169daa9,0xdeb6df63,
0xed2aed6c,0xf733ec23,0xf8f9f727,0x047dfefe,0x0c930256,0x0ce513d4,0x1914102b,0x180317d2,
0x291f27ce,0x2c702959,0x307a28ee,0x2f602c67,0x2dfb2dc4,0x2bfd2ef2,0x25ce2c45,0x1dd52b46,
0x23a31de5,0x231c28c9,0x1e9514f8,0x1f34253b,0x20081e29,0x1c2f24e8,0x25301942,0x14801ed6,
0x16af15d2,0x0c971efc,0x1cbe1146,0x11571683,0x0ee8129d,0x12691228,0x02020c46,0x022d03da,
0xfba9003f,0xf3a3f434,0xe9fae841,0xe83be7ce,0xe93ee6be,0xd990e2d8,0xdc66d700,0xd457d544,
0xd94dcff5,0xc962d28d,0xd2b9d404,0xd64dd65f,0xd688d7e3,0xd8dcd699,0xd7c5d0a8,0xd2fdd536,
0xd3f4d820,0xe69fd9b4,0xd1f3d148,0xe18bddc9,0xe63ae3bc,0xe7d4e6e2,0xf48fec39,0xf960f544,
0xfcd9f821,0x057800e1,0x037106a1,0x0ef310f3,0x15911521,0x1c2a1a3c,0x20761fbe,0x28fd258a,
0x2ecb2bc5,0x3a622fda,0x33873423,0x38222ff8,0x358d3b8e,0x357c33f9,0x2ce739f3,0x2e723255,
0x2a152f59,0x29372987,0x24be2528,0x21382019,0x1b5722cb,0x13631621,0x1229118f,0x0f74124b,
0x12a60dd6,0x041204ed,0x03a404d8,0x05ab0c0f,0xfce1fc42,0xf5b2f91f,0xf4fbf9e0,0xf088f198,
0xe6b6f04c,0xe693ebe7,0xe808debf,0xdf17e86b,0xde26de63,0xdc71d933,0xca9ed0c5,0xd0d9ca6e,
0xc4f8cd04,0xc65dca78,0xcf6cc944,0xc905d07a,0xd482cb69,0xcb12cd09,0xd6c2d238,0xdd4ad596,
0xda27dafc,0xe58ee616,0xed39e6e1,0xe802ea6c,0xfb7df916,0xfe57f8cf,0x02f70745,0x0c1d046c,
0x0c2a0c33,0x149012dd,0x2278156e,0x225d22d1,0x2e932282,0x231f2a7e,0x33a82c14,0x2aeb2a7b,
0x37843464,0x2f5930ba,0x362e31e2,0x38b13efe,0x3fc83a62,0x35803a58,0x305b34c3,0x2fb03122,
0x2c142d6d,0x25872645,0x222021ed,0x1d262009,0x09c41aa7,0x0ea20de9,0x09fb08dd,0x0185068c,
0xfbe5fdb7,0xefdef029,0xf1bdf422,0xef4ff30e,0xe7f5eb0b,0xe77be4bb,0xe63ce9d2,0xe2afe342,
0xdec4e19c,0xd634de30,0xe31cdb3c,0xdfb9da4b,0xd6d1db70,0xd8fedac7,0xd35dd359,0xcb3fd74b,
0xd045ca11,0xcb21cbb1,0xcde3c960,0xc950c84c,0xd1c0cf42,0xcf7bcdc1,0xd85fd6a3,0xe13adc5b,
0xe45bde99,0xeb0bea6e,0xf1abf05f,0x0091f42b,0x0985ff64,0x0f9a10ae,0x11581655,0x1da713b4,
0x1d341c68,0x28e726c2,0x2f732b42,0x33e631e6,0x2f7b3501,0x31733007,0x32a2300a,0x34ee33e6,
0x3051358d,0x34ee3263,0x35c634b4,0x3255390c,0x35f631aa,0x2f063290,0x33af3198,0x2a3c2fe2,
0x2744294e,0x18d4239f,0x1dce1c01,0x16c11ad5,0x113e1435,0x023f0a25,0x01b9fd2d,0xf751fe72,
0xedb9f3f1,0xea0eedb5,0xe68ce82c,0xe5bbed1c,0xde24dc95,0xddffdb87,0xd8c9d914,0xd547d7c4,
0xd13cd8b1,0xcf61cb35,0xd172d0ed,0xcea7ceca,0xd1f5d245,0xce47ce92,0xcfe8ce9e,0xcf69ce24,
0xd064cb96,0xcf5dcf38,0xd5e0d442,0xd420d6cf,0xdaa4d9d6,0xdd46dbb6,0xe458e3b3,0xef05e8ec,
0xf20cf229,0xf941f027,0x0156fc36,0x087effd1,0x16c910b2,0x19bc1a0a,0x21441e9f,0x22b02490,
0x2986268a,0x336e310b,0x38c536f3,0x3d2139bd,0x3d343c56,0x3c683e5c,0x37683a53,0x3c9f3b69,
0x2ffc3505,0x2fc93275,0x28262986,0x27662cce,0x29052487,0x1b3d20ac,0x20af1ef1,0x19d91c8d,
0x124d17ef,0x142e137c,0x0ec20f62,0x0e200bd8,0x0acd0e1a,0x02ff063e,0xfc4aff9d,0xf2c9f5b3,
0xeebcf29a,0xe678ec92,0xec5ee66f,0xdf93e94a,0xe026dd14,0xd811da65,0xd49dd71d,0xcfeed412,
0xc9feca6c,0xccc4caa5,0xcbbecf47,0xce71caa3,0xcedbcbc8,0xcdbdd000,0xcdcfcc1d,0xcdaacf12,
0xd4e0d144,0xd3d0d2a4,0xdea0d709,0xe08ae00b,0xe020e47a,0xe908e729,0xf258ef2b,0xfb21f610,
0xfd9bfd8b,0x0672ffb0,0x071b0876,0x13bb0ce6,0x18e715e1,0x22d81e29,0x254c251d,0x2b4826b8,
0x30f330a6,0x30bc2e63,0x380e33bf,0x3887392a,0x38d13a9e,0x3b813b1a,0x3c413cae,0x3afc3a07,
0x326c379f,0x2ef83118,0x29752d6c,0x20e82762,0x258e21f8,0x1a861e5c,0x1989187b,0x0fbd1668,
0x0a2f0b96,0x0203061a,0x005401d7,0xfc2ffc5d,0xf9d9f97d,0xf9ebf978,0xf42ffa63,0xfb8ef89e,
0xeff4f3a9,0xecccee03,0xec25eae4,0xe25ee7b5,0xdf4ee032,0xda38dddf,0xd9d7d7de,0xd10bd664,
0xcb64d039,0xcad1ca7b,0xc928c7d6,0xc8cec836,0xc770c684,0xca08c969,0xcb1dccae,0xd1e7cba4,
0xd333d562,0xd672d11f,0xdf39daa4,0xe219e0a9,0xeecce7df,0xf07df053,0xfca0f1b8,0x043a0284,
0x044c068e,0x0dda0832,0x0f47103a,0x1b3917ea,0x21591d44,0x26b0256b,0x2ad125e3,0x2db82d3b,
0x2f332e41,0x30332f8b,0x37fc34f0,0x3a6e3909,0x378f3a86,0x36f838d5,0x36333417,0x371f39a9,
0x2df62f0d,0x2fe63006,0x2d232fd7,0x24402778,0x1c1424b7,0x1fcc1953,0x13651bf5,0x0c5c110a,
0x085b0947,0x01e1020b,0xfecbff76,0xf98bfc43,0xf538f586,0xf2abf658,0xef36f20c,0xee71ef02,
0xe84be6c6,0xe7efe9e1,0xe558e4cd,0xdfdbe284,0xdacade70,0xdaf0da94,0xd9e9db55,0xd897d9b4,
0xd525d6be,0xcfefd229,0xcf18cd4a,0xc9c8cc8e,0xcb46cb84,0xc748c97f,0xc949c79e,0xcdffd08d,
0xd285d027,0xd952d48f,0xdd19dc08,0xe28cdda2,0xe8c2e579,0xf1fbed39,0xfaaef893,0x05c4fe17,
0x088c06e8,0x142210ff,0x15ee14d9,0x1baf1996,0x23ed1e0e,0x2a0525e7,0x2fe72cc9,0x31a8303e,
0x329732fe,0x350933f0,0x349d338e,0x337a3564,0x36b93672,0x303e30b5,0x32803309,0x327531e3,
0x2ea32ce7,0x2e9f310a,0x2bbe2bad,0x25cb27ed,0x241d240f,0x1fd423b8,0x18711b1a,0x13141587,
0x0eff12dc,0x092b0d1b,0x02f40749,0xfed7ffc9,0xf7a1fba9,0xf054f4a5,0xec2cecb5,0xe5a9ea18,
0xe304e37c,0xde1fdf67,0xdad3db6d,0xdbeddcf9,0xd413d8a0,0xd508d566,0xd0bad24b,0xccc9cdf8,
0xcd7ece53,0xcd62ccec,0xcdd9cf64,0xcd1acc8f,0xd049cfa6,0xcdddcf47,0xcf02cce5,0xd267d0c4,
0xd4e1d225,0xdd67d78c,0xe030df1a,0xe447e3b3,0xecb7e98f,0xf13aed49,0xfaf7f685,0x027ffe87,
0x0a2c05bf,0x117d0da0,0x1971152b,0x1ddf1bc8,0x26582164,0x2a9e283a,0x2e262c34,0x31933030,
0x33ef31be,0x384d3868,0x350035bf,0x376735b3,0x36433747,0x33703460,0x33ce36a2,0x2d36316e,
0x2d812b6b,0x253e2ae8,0x2283239d,0x1ec51fd1,0x1e7c1ec7,0x1bcc1d9a,0x1524174c,0x140814c9,
0x112212e1,0x0c940f31,0x0560082b,0x055b05be,0x001f030d,0xf9eefe6f,0xf27bf723,0xeefdf020,
0xea2becea,0xe198e634,0xdb47de39,0xd81ad9fd,0xd2c6d358,0xcee5d113,0xca5fccf7,0xc9c5c8bb,
0xc549c763,0xc485c505,0xc4abc50e,0xc841c6cd,0xca5ac9b0,0xd016ce74,0xd056cd61,0xd46ad2b3,
0xd836d7ae,0xdbf0d9c6,0xe2ccdfa8,0xebeee686,0xeef6edda,0xf478f228,0xf85ff585,0x0168fc8a,
0x09d605b8,0x0f600aa5,0x16c114b4,0x1ee21ae7,0x233c21c0,0x26a8254b,0x2c1829ea,0x2f5b2de9,
0x335c3088,0x35fd35d3,0x37c734a4,0x381e376f,0x3a0d3ab5,0x363736f3,0x3260345f,0x341c3393,
0x2cb53202,0x283e2a16,0x27ce27b6,0x201d24cd,0x1c661dcc,0x1a0b1b01,0x170819d3,0x114d13fc,
0x0efb0fdf,0x05f809c1,0x03f804c6,0x01260385,0xfa49fc7b,0xf6b8f81e,0xf3fef5bc,0xf286f3a5,
0xed9bf226,0xe6f6e958,0xe384e535,0xdd1de102,0xd73bd95f,0xd4a1d60b,0xd164d37d,0xcd82ce0c,
0xc82dcba9,0xc406c4e8,0xc34dc55c,0xc417c2d3,0xc622c42a,0xc8c0c6a1,0xcbe6ca06,0xcf40ce6a,
0xd23fd0b6,0xd728d482,0xdf6ddaf8,0xe7ace447,0xf014eb19,0xf611f2bc,0xfddaf992,0x05a2021e,
0x07940667,0x0e3b0b30,0x148a118f,0x1be71915,0x20001ec1,0x264122a5,0x2cb729eb,0x2e8e2c9f,
0x2df22db8,0x316c3078,0x36cc33f2,0x3867379f,0x36da381e,0x392b37c7,0x38b53a80,0x349436fd,
0x3444347c,0x2eca30f4,0x29e12c31,0x281e28d9,0x1f2f24e8,0x1d8c1ddd,0x18271bc4,0x0dce11ee,
0x0c770d62,0x07360aee,0x0159052a,0xfa76fd3d,0xf895f969,0xf69df849,0xf228f4a2,0xecefedf2,
0xebf8ec2f,0xe8c8eab8,0xe452e587,0xde14e245,0xda35db60,0xda16da3d,0xd37ed70d,0xd170d2f1,
0xcf06cff6,0xcf14cf3d,0xcb21ccc4,0xc7a3c9a0,0xc63bc6b2,0xc8e3c6be,0xc9a1c8b6,0xce99cb6e,
0xd1cbd0dc,0xd4a7d2f1,0xd96ad66c,0xdfefdc2e,0xe62de2c1,0xf08feb3e,0xf821f53f,0xfbbffa8e,
0x057400be,0x0dcc08f8,0x10731044,0x17ea142a,0x208d1b8b,0x250922b4,0x29de2776,0x2c502b87,
0x312e2f3d,0x30d43194,0x319f3149,0x32633186,0x32ac32fe,0x343132d4,0x320333b6,0x2f69300c,
0x30682f4a,0x3005319a,0x2d112dd4,0x2e682de5,0x2c532e59,0x26072960,0x21182314,0x1e322081,
0x177c1a30,0x0f801365,0x0b290dfe,0x07800985,0x00680450,0xfad3fc54,0xf435f7c2,0xeedbf0bc,
0xea14ed04,0xe2ebe7ca,0xdc3edf4f,0xd772d8b7,0xd58fd709,0xd20bd42b,0xd3a6d224,0xd177d237,
0xd0c7d08d,0xcea2cf27,0xce5ace73,0xcbf2cdfe,0xca2eca31,0xcc29cbce,0xccfdcc1d,0xcf5cce52,
0xd03bcfef,0xd55cd22e,0xda12d7b2,0xdde7db79,0xe411e0db,0xe9e7e720,0xf178ed3a,0xf7fff556,
0xfc96fab5,0x02daff2f,0x0b4d0735,0x0fc60e2b,0x145e12a1,0x1b7117dc,0x21ea1f8a,0x280024df,
0x2a0a288e,0x2d002c31,0x30882eab,0x333131e2,0x35aa349a,0x3533356e,0x350234dc,0x351b35c1,
0x32963479,0x32f4324c,0x31cb333a,0x2b592f06,0x28f92a53,0x25fa27e9,0x222e237d,0x1b011de3,
0x18d619e0,0x165816fb,0x144f15c2,0x0db71254,0x085b097b,0x056d0779,0x00ff038e,0xfcc2ff0a,
0xf518f8bd,0xee30f0e8,0xe806eb77,0xe177e43b,0xd9a3dd36,0xd548d700,0xd08bd255,0xd0e0d0a9,
0xcda0cf91,0xca97cb5c,0xc805c96c,0xc520c6a5,0xc5b3c554,0xc6c7c61e,0xc79ec6f8,0xccfbca24,
0xd16ccf04,0xd277d21d,0xd724d5cb,0xdc7ed8cd,0xe1fadf6c,0xe64ce458,0xebe3e999,0xf24ceed8,
0xf6bff476,0xfb7cf8e4,0x0212fe8d,0x07830562,0x0cc709ef,0x134b1029,0x196a162e,0x208b1ca6,
0x2671247a,0x2a7c288f,0x2f732cae,0x32e031be,0x34093369,0x34fa34ed,0x37463629,0x38c63870,
0x37a9383c,0x36203775,0x332434c4,0x2f4a30c3,0x2bfe2d4c,0x282629f6,0x2255255f,0x1e681f7e,
0x1ca61de4,0x16f119ff,0x12ed1422,0x11bb124b,0x0cf210c0,0x066108db,0x02330383,0xfe220091,
0xfa53fc09,0xf626f886,0xf3a0f417,0xee7df11a,0xe872ebaf,0xe203e598,0xdd6be026,0xd908db94,
0xd2dcd604,0xcc91cf9a,0xc973c9f7,0xc8afc943,0xc593c6c4,0xc41dc47f,0xc4b8c378,0xc6a9c5dd,
0xc92dc866,0xcd0ecada,0xd0c0cf2c,0xd5f9d479,0xdaf7d840,0xdf45dd31,0xe3b3e159,0xe946e640,
0xedf9eb9d,0xf404f0cc,0xfb70f7ea,0x01d7fe7f,0x06fc046d,0x0d310a3a,0x12ab0fb2,0x1980165c,
0x1dd91b75,0x22e82004,0x280a263f,0x2ae7295a,0x2e7c2d1a,0x30e52f20,0x348f3216,0x3886376e,
0x3a0838e4,0x3ad83a6d,0x3a533ae7,0x3735384f,0x33a435d3,0x2ecb3187,0x2ba82c9a,0x2a862b5e,
0x24ca27c3,0x212b231a,0x1a691de3,0x140e1745,0x0e8610e7,0x09240b7a,0x059c078f,0x0127038c,
0xfa60fda5,0xf6a5f81f,0xf2e1f4fe,0xeffcf148,0xebf2ee51,0xe6a0e949,0xe333e52b,0xde76e0ab,
0xd9fbdc74,0xd75ed89e,0xd561d64d,0xd18dd35d,0xcd63cfae,0xcbf8cd24,0xca3ccad9,0xc868c935,
0xc7d9c807,0xc9cec900,0xca90ca81,0xcc74ca9c,0xd163ceff,0xd46ed2d8,0xd7a1d5b4,0xddc3db07,
0xe43fe11e,0xea33e74f,0xf18deddc,0xf822f538,0xfffafbea,0x054602e7,0x0a41072b,0x10110d0a,
0x1537129a,0x1c461924,0x21511e23,0x27492416,0x2de12b0d,0x308b2f74,0x318c30f4,0x34a132ff,
0x3680361b,0x372e36bc,0x363d36cc,0x366436a7,0x35113598,0x3173333f,0x2ec4301a,0x2d282e0b,
0x2be32c3f,0x29ae2abc,0x256427bb,0x20f822d1,0x1d7c1fa6,0x17f51b6c,0x11641406,0x0c580f1f,
0x07d20a5c,0x009e04cf,0xfb78fdec,0xf5d2f896,0xeea1f1e8,0xe8b3eb46,0xe424e65a,0xdfcde241,
0xdac4dd31,0xd53bd7de,0xd1fdd3c9,0xd0f6d149,0xd135d154,0xcfafd0be,0xcf54cf58,0xd065cfaf,
0xcec6cfe7,0xcd4ccdbe,0xcd05cc97,0xce7fcdcf,0xceabce23,0xd022cf62,0xd260d135,0xd4c4d34d,
0xd72ed667,0xdcccd98a,0xe3d7e0a0,0xe9eae664,0xf126ed12,0xf77ff49b,0xfe45faec,0x059c01cc,
0x0de2098a,0x156f11bd,0x1c661938,0x227e1f59,0x2767257b,0x2a8a28d2,0x2f2d2c28,0x31823100,
0x323e31d8,0x32843274,0x332e32cb,0x343c337f,0x33283409,0x31b73251,0x313d3186,0x2fb230d2,
0x2e102e97,0x2ce52d8a,0x2b1b2c29,0x289629dc,0x24a926e7,0x1fb62246,0x1ba81dab,0x1736194d,
0x1164148f,0x0d900f44,0x094a0b54,0x036e06eb,0xfe1400c4,0xf8d4fb41,0xf311f666,0xeb54ef66,
0xe4dee830,0xdf97e230,0xda3cdc93,0xd5b6d7e1,0xd24ad3e2,0xced1d08e,0xcc05cd4b,0xc95dcacc,
0xc7bac83d,0xc718c746,0xc82fc7c1,0xca08c91b,0xccbdcb75,0xce42cd98,0xce90ce14,0xd047cfcd,
0xd3c5d141,0xd9b9d645,0xde6cdbea,0xe3b2e113,0xe8eee66c,0xed49eb0b,0xf262efd9,0xf8aef5bf,
0xfdc3fb20,0x04730133,0x0bc90856,0x12ff0f08,0x1a02164b,0x1f5f1c8d,0x256022d9,0x29882733,
0x2e012bb1,0x32ac30d4,0x35d533fc,0x383c37a1,0x38b238af,0x36da37cb,0x35e93678,0x3455351a,
0x339b343f,0x3195329a,0x2e052fee,0x2ad22c8f,0x269c28dd,0x238124ed,0x20902224,0x1c7e1e93,
0x18491a31,0x14121694,0x100b122e,0x0b880d85,0x060008d6,0x017303ea,0xfcd2ff04,0xf74afa0e,
0xf377f522,0xee99f126,0xe84eeb5d,0xe345e575,0xdf44e176,0xdb1cdd36,0xd5b0d865,0xd1f8d3b7,
0xcf37d090,0xcbd2cdb3,0xc83bc9b9,0xc616c6bd,0xc601c5cf,0xc678c638,0xc785c710,0xc928c7aa,
0xcc92caf8,0xcfa0ce6c,0xd2cdd0da,0xd7c3d522,0xde2cdb1a,0xe356e0a7,0xe8ece649,0xee69ebb1,
0xf44ef12a,0xf88df670,0xfdc9fa91,0x055d01b5,0x0c6b0924,0x130f1006,0x183e15c7,0x1de11b19,
0x24c721d3,0x28642714,0x2ac52987,0x2f742cb4,0x33e131ac,0x37e73606,0x398b38cd,0x3a693a24,
0x3b7f3b07,0x39883ae3,0x35f63802,0x341b34cc,0x324c3360,0x2ec13098,0x2ae82d05,0x26cd28f9,
0x21e7245a,0x1bba1efd,0x164c18d6,0x11cd13d3,0x0d720fda,0x07ed0a9c,0x02ea0562,0xfe2b0039,
0xf92cfb9a,0xf4bbf75b,0xf00ff22b,0xec25ee0d,0xe7feea40,0xe38ae58f,0xe07ae21f,0xdcd8de9c,
0xd950dad7,0xd453d6ab,0xcf9cd1f0,0xccdbcde4,0xca95cb6d,0xc8f5c9d5,0xc79ac86c,0xc70dc729,
0xc79ac742,0xc90cc883,0xcabcc9e7,0xcde8cbdf,0xd1d2cfe7,0xd6e7d44f,0xdc46d940,0xe1f5dedd,
0xe85be572,0xee24eb41,0xf44af156,0xfa30f754,0xffd0fd06,0x05a0027c,0x0c610907,0x12ce0fdd,
0x1835154d,0x1d611adf,0x224a1fa9,0x26392483,0x29a22829,0x2c3f2af2,0x2ff32e33,0x33d531f9,
0x369435a0,0x37873727,0x387b37af,0x38c838e0,0x38703899,0x378c3819,0x349d363a,0x30fd32d5,
0x2d202ee9,0x296c2b6c,0x257a276d,0x210f2391,0x1b461dff,0x15fe1893,0x11af13da,0x0c930f5d,
0x06ae09c0,0x00df0372,0xfb3cfe47,0xf566f80c,0xf053f2a2,0xec4eee65,0xe5b9e919,0xdec4e241,
0xda38dc89,0xd66bd801,0xd433d53a,0xd252d379,0xd074d161,0xcda0cefb,0xcb3fcc78,0xc9a0ca49,
0xc8d6c8e1,0xc8dac8ad,0xca9ac9c8,0xcc39cb8e,0xccf2cc89,0xceddcdc2,0xd0c7d012,0xd3b8d208,
0xd8c1d618,0xde5cdbbe,0xe3e4e105,0xe998e6da,0xefa2eca3,0xf68bf2bf,0xfd59f9d1,0x046500d6,
0x0cc6089e,0x145b10ae,0x1b1a17f6,0x20241e08,0x2318219b,0x27282542,0x2ad7291a,0x2e252c51,
0x31812fbf,0x33ce32d1,0x342a3424,0x341233fc,0x34043423,0x3494345d,0x3476348b,0x336e3404,
0x320132fc,0x2f353068,0x2c522d7e,0x29bb2b0f,0x275d2882,0x24682627,0x20182253,0x1bbd1df6,
0x1669191d,0x100f135c,0x0a380cc1,0x05170778,0xffe20284,0xfb2cfdbb,0xf57cf890,0xef00f239,
0xe8aeebc8,0xe351e60d,0xdd79e036,0xd874daee,0xd4bad684,0xd166d2eb,0xcd87cf7e,0xcb2acc3d,
0xc918ca45,0xc726c823,0xc601c67d,0xc5cbc5c9,0xc687c60f,0xc87bc785,0xcb2ec9d8,0xce22cc8b,
0xd185cffd,0xd4f7d302,0xd9c8d725,0xded0dc37,0xe423e178,0xe9f4e72b,0xee14ec1b,0xf250f034,
0xf8dbf576,0x0028fc2e,0x077803b1,0x0e080b02,0x141210cd,0x1a69170d,0x20731d88,0x26492374,
0x2b2628c9,0x2f2d2d65,0x33453163,0x35bb347a,0x37f836ec,0x3a133959,0x39a73a3f,0x37ed38ab,
0x35883695,0x334a347c,0x310231f9,0x2e142fbc,0x2b5e2cd3,0x283629b2,0x24962682,0x21b3230e,
0x1ecd2071,0x1a951cb9,0x15ec188e,0x101e12e4,0x0aec0d4f,0x065a08cb,0x01ff0422,0xfdc9ffa1,
0xf91cfb9d,0xf3aef67d,0xee32f0fc,0xe8c8eb7b,0xe3c3e62b,0xded3e173,0xd9fddc76,0xd4b3d74b,
0xd070d25d,0xccf5ce96,0xca61cbc5,0xc84cc955,0xc6b8c74a,0xc6b0c67d,0xc786c70d,0xc904c83e,
0xca3fc95a,0xcc5fcb7d,0xcf22cd78,0xd26ad097,0xd6a9d49c,0xdb1cd8f7,0xdf1adce1,0xe4b2e193,
0xeb14e824,0xf0bbee2d,0xf5f7f31a,0xfbdbf8a3,0x0291ff3e,0x09e6060f,0x10860d57,0x16a713b2,
0x1c111962,0x21051e72,0x25d02379,0x2acb2850,0x302a2d36,0x34543282,0x372735fd,0x386337dc,
0x39083910,0x39263921,0x38cf390d,0x388438ad,0x37b23827,0x357c36d6,0x31ed3388,0x2e003034,
0x294f2ba8,0x245b26c1,0x1f55220e,0x1a4b1cd2,0x15c417e8,0x11121388,0x0b770e9d,0x066908df,
0x02510411,0xfe7f0076,0xf982fc3d,0xf42df6c3,0xeefcf1be,0xe957ec1f,0xe394e63b,0xdf2de137,
0xdb8add37,0xd8acda08,0xd5e6d729,0xd2c9d480,0xcf84d148,0xcc0acdb6,0xc994caca,0xc85fc8c7,
0xc817c7fd,0xc8d5c836,0xc9c2c99b,0xca6eca25,0xcbd6cac4,0xcef9cd85,0xd395d11e,0xd8c7d5f1,
0xde12db90,0xe37ae0ad,0xe87ce5e1,0xee05eb3b,0xf3e1f103,0xf9ecf6fa,0x004ffd03,0x06a2036e,
0x0ca509af,0x12980fab,0x179d1541,0x1bb4198d,0x205b1ddb,0x25af22f7,0x2ae32870,0x2f872d75,
0x325c3116,0x347f3390,0x3630356b,0x36da3671,0x37f33797,0x38c63869,0x38a838ac,0x37723863,
0x34d43675,0x31783310,0x2d8a2f82,0x29332b73,0x2588274f,0x21b423b1,0x1cd51f7d,0x173f1a14,
0x1185143e,0x0b960eb2,0x059008a7,0x009302fc,0xfc48fe5e,0xf794fa24,0xf233f4f4,0xeb94eed5,
0xe5e9e8be,0xe16ae381,0xdcf6df2a,0xd8b6dab5,0xd56cd717,0xd241d3cc,0xcef9d056,0xcd09cdf5,
0xcb63cc3c,0xc980ca5e,0xc84cc8cb,0xc7fec81a,0xc908c87f,0xcac4c9db,0xccb7cbb6,0xcef1cdb1,
0xd1a6d012,0xd581d36f,0xdabcd816,0xdf81dd07,0xe3d3e1d9,0xe890e604,0xedfdeb13,0xf4a9f141,
0xfc2ef85d,0x0330ffd7,0x09fc06a3,0x0ff50d2b,0x158a12be,0x1aa71807,0x20781d98,0x25ed2345,
0x2a2f282b,0x2d582bd7,0x2fa62ea3,0x317b30a1,0x321631df,0x326b3278,0x338732f0,0x346833ec,
0x34cc34e5,0x348434d6,0x32fe33b1,0x30b731e7,0x2e7e2fce,0x2b8b2d2c,0x281829f2,0x24622666,
0x203c2239,0x1bcc1ddb,0x180119d2,0x1457161d,0x0f481200,0x093b0c5c,0x03690641,0xfdd70075,
0xf7d8fabc,0xf1f9f520,0xec62ef19,0xe6ade94b,0xe13fe40e,0xdbcade7c,0xd789d974,0xd412d5bd,
0xd063d253,0xccf9ce9e,0xca33cb61,0xc928c99f,0xc8b0c8c5,0xc820c83d,0xc892c852,0xc98fc8f5,
0xcb04ca34,0xcd40cc2d,0xcfbece85,0xd28cd128,0xd55ed412,0xd8d0d709,0xddc9dad1,0xe42fe0c2,
0xea31e777,0xf04ced37,0xf691f36a,0xfd16f9d1,0x030f0053,0x096c063c,0x100f0cce,0x1643136a,
0x1b7818ba,0x203c1db6,0x255f22f8,0x2a3327d9,0x2e6a2c61,0x320b3053,0x355e33ea,0x3757368b,
0x378a3775,0x3728378c,0x367236d7,0x351535b1,0x333f3448,0x30d331ff,0x2e0b2f7d,0x2b012c85,
0x28372994,0x251726bb,0x2121233e,0x1d191f25,0x18e51af8,0x140b168d,0x0f9111db,0x0b780d60,
0x07210940,0x02ce04f5,0xfe190079,0xf896fb67,0xf2fff5dc,0xedb1f05d,0xe864eb02,0xe306e5c2,
0xde35e0ab,0xd9d2dbdb,0xd636d7e5,0xd2fcd48f,0xcf7dd144,0xcc2ccdcc,0xc9e7cae4,0xc867c920,
0xc774c7c2,0xc722c72c,0xc87cc7f1,0xcaa0c96b,0xcd24cbaf,0xd04cceaf,0xd40fd225,0xd815d614,
0xdbebd9f8,0xdff9de22,0xe449e200,0xe8d3e645,0xeee2ebc9,0xf5a8f22d,0xfc14f8d3,0x020bff32,
0x08140506,0x0e4b0b38,0x13dc1131,0x19a116e4,0x1fc71ca2,0x25af22ba,0x2acd2870,0x2eb52cc7,
0x315e3006,0x33ef32ae,0x35fd350d,0x374f36d2,0x3768376b,0x37713742,0x37a13787,0x365b3705,
0x34353571,0x312b3289,0x2d712f5b,0x29d02bce,0x25f827dd,0x21d923dd,0x1d7b1fd4,0x18811b28,
0x135d15c1,0x0e2310d3,0x08f90bba,0x03ae0645,0xfed00122,0xfa0afca6,0xf513f786,0xf031f28e,
0xeb94edcf,0xe7a6e9ad,0xe378e575,0xdf08e146,0xdaebdd26,0xd780d918,0xd404d5b9,0xd0c4d27b,
0xce2ecf56,0xcc3dcd05,0xcaa8cb6a,0xc9d5ca4e,0xc951c980,0xc946c945,0xcaecca0c,0xcd7ecc06,
0xd07fcef1,0xd378d1ee,0xd728d523,0xdbb7d94d,0xe077de0a,0xe5c8e30e,0xebd2e8cc,0xf131ee81,
0xf6d1f40d,0xfcbaf9be,0x0243ff8b,0x08240523,0x0e140b0c,0x13a610d3,0x18a91652,0x1d3d1afb,
0x21ff1fa4,0x2623244a,0x29da281d,0x2d322b70,0x30822ed4,0x34183263,0x37213599,0x389f3804,
0x38f2390e,0x382838c2,0x36e1374b,0x3589363e,0x333634ae,0x301c31bf,0x2c062e20,0x278c29e6,
0x22692513,0x1d361fc3,0x18df1b05,0x149b16e6,0x0fcc1251,0x0a4a0d1e,0x048d0778,0xff1a019e,
0xfa48fcd0,0xf58df7f9,0xf0b5f30b,0xec03ee67,0xe6f2e9ac,0xe1c4e449,0xdd16df52,0xd907db08,
0xd563d739,0xd282d3f1,0xcffbd12c,0xcde2ceec,0xcc2eccfb,0xcb2acb71,0xcab7cac8,0xcafdcac1,
0xcbcdcb44,0xcd0acc58,0xcf51ce07,0xd240d0ac,0xd4dcd39e,0xd7eed660,0xdbd7d9c0,0xe00fddf7,
0xe4a1e267,0xe9d2e714,0xefe9eca6,0xf627f2ff,0xfbd7f91a,0x0127fe7c,0x0666037b,0x0c5b0962,
0x126e0f62,0x1801153d,0x1d881ad0,0x231a2065,0x27ea257f,0x2bf12a04,0x2f6d2de0,0x322630d0,
0x33c432fe,0x34ad347b,0x352f34fa,0x3509350c,0x342d34ac,0x32e333aa,0x31303216,0x2f2c304a,
0x2cb02dfd,0x2a1a2b5e,0x274928ba,0x241425d1,0x20602241,0x1c2b1e51,0x178a19ef,0x130f1540,
0x0e4110b5,0x08c10b98,0x034e0602,0xfe270076,0xf838fb1e,0xf2cdf591,0xed8ff035,0xe816eae3,
0xe27be559,0xdd3ddfcb,0xd8e6dadb,0xd58bd739,0xd2b8d41b,0xcfe7d125,0xcda0cea6,0xcc61ccd5,
0xcb76cbd6,0xcabacb22,0xcb1bcaee,0xcc29cb92,0xcd49cca1,0xce92cddb,0xd0f1cfbf,0xd398d234,
0xd683d4fc,0xda7cd867,0xdf97dcd2,0xe4bde230,0xe97ae72b,0xee99ec13,0xf3f4f13f,0xf9b6f6c5,
0xffd9fccf,0x05870273,0x0b560877,0x115e0e6c,0x1767145b,0x1d1a1a47,0x22411fd2,0x26e124ad,
0x2ae928fe,0x2de12c75,0x30662f42,0x329a319c,0x34013369,0x34a83485,0x34d834cb,0x348634a0,
0x33b13430,0x3244331a,0x30103136,0x2d3f2ecd,0x2a592bcd,0x270028a2,0x2307251f,0x1ecf20f6,
0x1a9e1ca7,0x16481861,0x12191432,0x0dcf0fdb,0x094a0b6b,0x046d06d9,0xff9f0220,0xfac5fd84,
0xf586f830,0xf03ef2d4,0xeb2eed8e,0xe64ce8bd,0xe17ee3db,0xdce3df2c,0xd8c6dac4,0xd50dd6df,
0xd1d5d378,0xcee7d03d,0xcc73cd9a,0xcb03cb97,0xca4dca74,0xc9ffca08,0xcad3ca59,0xccf3cbc0,
0xcf51ce0f,0xd15ed055,0xd419d2a0,0xd787d5b0,0xdb39d96a,0xdf44dd3e,0xe351e131,0xe7eee587,
0xecd1ea71,0xf1cfef5b,0xf734f473,0xfce8fa16,0x02e10013,0x091705f3,0x0eaa0bde,0x142d1168,
0x199616df,0x1ee31c4a,0x23e22162,0x284a2639,0x2c622a67,0x2fed2e52,0x327f314d,0x34653364,
0x3596352f,0x360f35fa,0x358935d3,0x340e34e9,0x3290336e,0x30f731c1,0x2e422f91,0x2aba2ca2,
0x27332905,0x238a2547,0x1f7121a4,0x1ad71d40,0x16791876,0x12bd1490,0x0f431105,0x0b380d42,
0x0694090b,0x011503eb,0xfbadfe74,0xf59bf876,0xf022f2e3,0xeb9ceddc,0xe72ae94a,0xe2f2e514,
0xdf5ae131,0xdbf7dda2,0xd8adda4d,0xd57ad6fe,0xd26fd3f3,0xcfd0d10d,0xcdb9cea5,0xcc82cd20,
0xcbf1cc29,0xcbaccbcb,0xcbfccbb2,0xcd27cc51,0xcf6ece39,0xd1ffd0c3,0xd4fcd367,0xd888d68d,
0xdccadac4,0xe194df30,0xe68ee3f6,0xebdee92b,0xf168ee89,0xf706f434,0xfc92f9cd,0x0221ff69,
0x080404fc,0x0d9f0acf,0x12f91070,0x180e15b1,0x1d021a8e,0x214d1f3b,0x2503232d,0x2841269b,
0x2b5529b9,0x2e002cc8,0x309f2f7c,0x32ac31aa,0x33e63375,0x3465345f,0x33d2340c,0x32a93335,
0x310531f1,0x2f1a3024,0x2d0d2e17,0x2a4d2ba7,0x270528a4,0x23612536,0x1f2f217f,0x1a411cf4,
0x14a1176d,0x0f3811dd,0x0af20cf4,0x06ec08f5,0x025b04c4,0xfd90ffea,0xf833fac4,0xf30df581,
0xee49f0a1,0xea1dec35,0xe5c0e7f9,0xe128e365,0xdc9bded4,0xd878da7b,0xd526d6bb,0xd296d3d0,
0xd09fd185,0xcf81cffd,0xcef7cf11,0xce7aceb7,0xce11ce40,0xce13ce37,0xce8fce34,0xcf9ecede,
0xd188d06e,0xd406d2bc,0xd74fd59c,0xdaf4d903,0xdf1bdd02,0xe38ae13a,0xe870e5e7,0xedc1eb29,
0xf370f0bd,0xf94df642,0xff56fc28,0x04f30229,0x0ac007ed,0x104c0d7e,0x15c71308,0x1b331882,
0x205d1db3,0x24c122a0,0x288426d8,0x2b4c29f4,0x2d5c2c49,0x2f272e50,0x30c83002,0x31e93156,
0x323d322c,0x321e3242,0x31c831ff,0x309d3151,0x2ecd2fd7,0x2c632da8,0x298e2aff,0x26a12843,
0x234724e4,0x1f98216b,0x1c101de3,0x18491a45,0x13d51614,0x0edd117b,0x0a160c80,0x057907c7,
0x00a90341,0xfbaafe6c,0xf617f8d9,0xf09af34f,0xebaeee20,0xe745e97d,0xe31ee524,0xdf44e128,
0xdb8fdd5f,0xd844d9d4,0xd545d6c5,0xd2e2d412,0xd11bd1dd,0xd001d081,0xcf6dcfd0,0xcf2ecf47,
0xcef4cef1,0xcf04cef5,0xcfb5cf48,0xd11cd036,0xd377d223,0xd684d4eb,0xd9fcd81e,0xdd8bdbad,
0xe18edf8a,0xe61ee3da,0xeadbe872,0xefbced4b,0xf4e0f25d,0xfa31f782,0xffd1fcf4,0x058d0273,
0x0ba7088c,0x117c0e7e,0x1709145a,0x1c8a19ea,0x21a91f41,0x261b23eb,0x2a032821,0x2d112ba6,
0x2f732e71,0x3139305a,0x323f31cd,0x32a0328a,0x32403270,0x314231c0,0x301e30bf,0x2f022f98,
0x2d742e3d,0x2b402c65,0x285829ec,0x24ec26c2,0x21592324,0x1d821f6c,0x19a01b9d,0x157617a3,
0x10d11335,0x0bff0e76,0x06da0963,0x01e6045d,0xfd80ff7a,0xf8fffb1e,0xf488f6cb,0xefdcf238,
0xeb50edb9,0xe718e938,0xe2dae4f0,0xdf04e0dd,0xdba8dd47,0xd88dda0b,0xd56bd6ee,0xd27fd410,
0xd041d14b,0xce85cf35,0xcdb8ce1a,0xcdf7cdca,0xcecfce3c,0xd059cf88,0xd23cd140,0xd477d33c,
0xd71ad5c1,0xda72d8b8,0xde01dc26,0xe14cdfa8,0xe4d6e30a,0xe8c8e6b5,0xed3eeaeb,0xf23aefde,
0xf776f4ef,0xfc7cf9dc,0x016cff01,0x06ba03df,0x0c4d0967,0x11910ee7,0x16bd1435,0x1ba1192e,
0x1fee1dce,0x23e12209,0x27c825ea,0x2b6f299d,0x2e6e2cfc,0x30f72fea,0x32e73208,0x33ba3362,
0x33b133f0,0x32eb3360,0x3156322e,0x2f2a306a,0x2c982de2,0x29f32b55,0x26d5288d,0x231e2515,
0x1f3e2112,0x1b711d4f,0x17781973,0x135a156f,0x0ef2112e,0x0a350cc5,0x058007eb,0x00e90335,
0xfcc4feed,0xf854fa73,0xf382f5e3,0xee69f0ef,0xe960ebd5,0xe4bfe71c,0xe086e29f,0xdcdade9b,
0xda20db3e,0xd7c4d8ec,0xd5ded6eb,0xd3fcd4cf,0xd236d317,0xd07cd144,0xcf7dcfe7,0xcf98cf64,
0xd03ecfc4,0xd14ad0cb,0xd2d4d20d,0xd4a9d3aa,0xd6ebd5bb,0xd9f9d852,0xdde8dbc2,0xe283e023,
0xe725e4e8,0xebcee988,0xf022edea,0xf4a2f261,0xf9e8f746,0xff8bfcb1,0x04c80222,0x09fc076b,
0x0ee20c62,0x1380113e,0x17fa15e4,0x1c291a19,0x20281e15,0x2401221e,0x27b225ed,0x2aa82942,
0x2cd82be1,0x2e612dbb,0x2fa02f16,0x30a6301c,0x311030ec,0x30d430fc,0x2fd9306e,0x2e1f2f1e,
0x2b8f2cc5,0x28792a14,0x256e2724,0x222723cf,0x1e59201c,0x1aaa1c8d,0x16c618cb,0x12a014c6,
0x0e25106d,0x09690be2,0x049f06fa,0xffdd023a,0xfbaffdfe,0xf7b4f99a,0xf33ef577,0xee65f0eb,
0xe9b8ebf4,0xe587e784,0xe1abe391,0xde24dfdf,0xdafbdc7e,0xd813d965,0xd58dd6e3,0xd365d471,
0xd172d243,0xcfdad090,0xceebcf62,0xcf14cee4,0xcfdecf3e,0xd15fd09d,0xd38cd27d,0xd619d4df,
0xd8eed798,0xdbf7da61,0xdf1ddd65,0xe2eee0de,0xe780e51d,0xec53e9d4,0xf11aeea6,0xf5e5f387,
0xfb13f86e,0x007dfdcb,0x05d30302,0x0b2d088c,0x10340d99,0x153812b9,0x1a161796,0x1e711c58,
0x225c2084,0x25ea2429,0x28f82783,0x2b552a4a,0x2d312c6a,0x2e7e2dd1,0x2f112edb,0x2f2d2f44,
0x2eeb2f10,0x2e2f2e7d,0x2cf42d93,0x2b8b2c61,0x29ea2add,0x278328b3,0x24a8262c,0x21892315,
0x1dd21f9a,0x19a41bb0,0x1564177f,0x11831375,0x0dae0fb0,0x09880bb0,0x049a0718,0xff5b01f7,
0xfa75fd0a,0xf602f826,0xf1ecf3df,0xedcbefcb,0xe985eba7,0xe544e75d,0xe12ee332,0xdd90df57,
0xda58dbee,0xd77ad8c9,0xd505d636,0xd364d43c,0xd227d2b9,0xd14ed1ac,0xd0edd10e,0xd0dfd0e0,
0xd15fd11f,0xd292d1d7,0xd438d344,0xd643d546,0xd892d76c,0xdaf0d9be,0xdd97dc2a,0xe0cadf09,
0xe4ece2b2,0xe9a3e73b,0xeef6ec4e,0xf492f1ce,0xfa76f767,0x0072fd60,0x06410334,0x0c010932,
0x11600ed5,0x16801401,0x1b6818fd,0x1fd41d94,0x23df21fd,0x27bd25ea,0x2b21297b,0x2d9f2c7f,
0x2f6a2eb3,0x30662ff6,0x30bf309d,0x309430c8,0x30153062,0x2f3f2f99,0x2df62ea2,0x2c442d21,
0x2a0c2b44,0x279b28d6,0x24c42618,0x218d234f,0x1e242004,0x1a021c29,0x157d17c7,0x10d2132f,
0x0c760e94,0x08520a52,0x03bc0613,0xfed50141,0xf972fc40,0xf47af6de,0xefdcf229,0xebaeedb7,
0xe7c5e9a8,0xe402e5e0,0xe078e245,0xdd0bdec0,0xda24db8c,0xd77ad8d1,0xd521d641,0xd31dd40c,
0xd193d254,0xd0b6d126,0xd042d070,0xd01dd030,0xd07ed05d,0xd19dd0fb,0xd334d255,0xd58fd44a,
0xd8a4d70b,0xdc4cda69,0xdff1de02,0xe3a9e1ce,0xe7f4e5c8,0xec70ea24,0xf14eeed7,0xf613f39c,
0xfaf1f862,0xff8cfd3a,0x03e501bd,0x08d60659,0x0e290b61,0x13cc1100,0x196f16ba,0x1ea71c15,
0x231b20fe,0x2718253a,0x2a6f28b3,0x2d162bc9,0x2f602e49,0x31313068,0x329331f2,0x332c32dc,
0x32ee3320,0x321932ac,0x30873183,0x2e7f2f9c,0x2bd72d1f,0x28c92a63,0x252c26fd,0x2135233d,
0x1d9d1f5b,0x1a0f1bdc,0x166b1851,0x12091438,0x0d370fb6,0x08920aea,0x03ba060c,0xfefb014e,
0xfa0cfcb3,0xf4edf77d,0xeff4f275,0xeb5fedaa,0xe737e92e,0xe342e51b,0xdf32e14f,0xdb5bdd42,
0xd7e1d97c,0xd4e6d666,0xd2a2d3b7,0xd0f1d19e,0xcfdad050,0xcf59cfa9,0xcf2dcf40,0xcfb4cf61,
0xd0c5d01f,0xd241d16f,0xd3e2d2f3,0xd5f5d4df,0xd897d727,0xdba0da0a,0xdef5dd3b,0xe2dde0c0,
0xe772e523,0xec7aea05,0xf16aeee0,0xf677f3ca,0xfbaff8ff,0x011bfe7c,0x067903a1,0x0bcd091c,
0x11190e7a,0x163e13c6,0x1adf18a5,0x1ede1cf0,0x2258209b,0x255323ee,0x282926ce,0x2ac82991,
0x2d342c02,0x2f2a2e22,0x30c6301a,0x31d4317b,0x3240320c,0x31db3201,0x30ee318a,0x2f4e3040,
0x2ce02e2b,0x29dd2b77,0x2686285d,0x22e624c0,0x1edb20ce,0x1ae71cde,0x171318e6,0x1310152b,
0x0ec210f6,0x09e40c58,0x048a072e,0xff3201d7,0xfa5efceb,0xf594f7f5,0xf0e9f33a,0xec64eeab,
0xe7d1ea12,0xe3cbe5a5,0xdfe9e1b5,0xdc3cde24,0xd8b1da7d,0xd55ed6e8,0xd292d405,0xd068d16c,
0xcebdcf7f,0xcdd1ce40,0xcd55cd95,0xcd5dcd52,0xcde1cd93,0xcf0dce5e,0xd0d1cfd2,0xd345d1ed,
0xd650d4be,0xd9c9d7eb,0xdd8fdb9b,0xe1e9dfbf,0xe6fce472,0xec57e9aa,0xf1dfef1f,0xf760f49b,
0xfcdbfa12,0x01fdff8c,0x07470486,0x0c4a09c4,0x11230ea9,0x15f0138d,0x1aa6184e,0x1f1b1cea,
0x232f212a,0x26fb2508,0x2a6628c0,0x2d5b2c07,0x2f9e2ea1,0x31273087,0x31ec31b7,0x32233223,
0x317931d3,0x307730f4,0x2f602fe9,0x2df72ec4,0x2c172d12,0x29a92add,0x26d42845,0x23812553,
0x1f7621a6,0x1ac31d20,0x1602184a,0x11a213cc,0x0d570f7c,0x09040b2f,0x047706c6,0xffab01f4,
0xfae5fd81,0xf672f8a2,0xf244f447,0xee76f05d,0xea74ec64,0xe624e839,0xe1cfe3f1,0xdd95df8c,
0xd973db73,0xd5c4d78c,0xd2dbd430,0xd081d1a3,0xcedacfa9,0xce0bce66,0xcdd4cdd0,0xcdbccdc5,
0xce06cdfa,0xcef5ce5e,0xd079cf91,0xd2b2d18a,0xd585d406,0xd8ddd700,0xdc76da8b,0xe049de5a,
0xe47fe267,0xe91de6ca,0xee4ceb8d,0xf3b5f103,0xf97df6b2,0xff29fc59,0x047a01da,0x0a4b0775,
0x0ff90d43,0x159112e5,0x1b1f1869,0x202d1da3,0x247a2257,0x280d2654,0x2b4c29ae,0x2e3d2cca,
0x30ce2faf,0x32de31e8,0x33cc3360,0x33dd33e3,0x334b33a0,0x323732f8,0x310631b6,0x2f36300a,
0x2ce52e09,0x2a162b87,0x26ff2893,0x23b42566,0x202221fc,0x1c201e2a,0x17ba19f3,0x12ed156b,
0x0e031095,0x09130b92,0x0449069e,0xffc201f1,0xfb4dfdaa,0xf669f8af,0xf1b3f3ff,0xed58ef77,
0xe8f9eb30,0xe48be6bf,0xe03be25d,0xdc8fde56,0xd950dad5,0xd684d7ea,0xd449d569,0xd261d342,
0xd0d4d19f,0xcf9fd031,0xceaecf18,0xce6bce75,0xce9ace6b,0xcf5dcf11,0xd0e4d025,0xd2bbd1b6,
0xd51ad3f5,0xd844d6a4,0xdc10da00,0xe041de15,0xe47ee26e,0xe8c8e6ba,0xed54eb0a,0xf204efb7,
0xf745f489,0xfcbaf9f0,0x022cff8c,0x07d404e3,0x0d6b0aa3,0x12921010,0x17c91543,0x1d041a74,
0x22201f84,0x26b5246b,0x2ab828cb,0x2e202c84,0x30c82f80,0x32e431f6,0x345333c9,0x350634db,
0x34ea34f4,0x344034a1,0x331d33cc,0x31833252,0x2f463067,0x2c5a2ddf,0x28ba2aa0,0x24e426d3,
0x20d222cc,0x1cac1ec0,0x18891ab2,0x14461686,0x0fa711fe,0x0af20d4e,0x0625088c,0x017103cd,
0xfd30ff33,0xf85afa9c,0xf37cf5f0,0xeea2f102,0xe9c1ec34,0xe4e9e72f,0xe02ee27a,0xdbe7dded,
0xd827d9f9,0xd538d6ab,0xd2c6d3fa,0xd0bcd1b1,0xcf52cfeb,0xce53cea3,0xcdabcdeb,0xcdbccdab,
0xce3acdf4,0xcf39ce90,0xd0dfcfdb,0xd2e4d1b8,0xd57ed42b,0xd862d6fd,0xdbafda05,0xdf4fdd88,
0xe3b9e186,0xe865e60c,0xed1cead6,0xf1d5ef79,0xf68cf415,0xfb85f913,0x00fbfe4b,0x06750377,
0x0c390972,0x12190f48,0x17a614d8,0x1c9b1a41,0x21441efc,0x25202338,0x28992706,0x2bc22a70,
0x2ebd2d41,0x30ed2fb2,0x32ad31e6,0x33d53362,0x34043408,0x33a533e4,0x32b53350,0x3194325d,
0x2feb30b6,0x2d8e2edc,0x2a9f2c2d,0x272f28ef,0x23562554,0x1f252146,0x1aaa1cff,0x16271864,
0x118f13d5,0x0d060f50,0x08a20ad1,0x0403065c,0xff4801b0,0xfa42fcf4,0xf4d1f779,0xefb3f232,
0xeacded16,0xe5ece84b,0xe165e3a0,0xdd23df52,0xd976db4f,0xd66ad7de,0xd3dfd501,0xd1b5d2ab,
0xcfc3d0a5,0xce82cf0c,0xcd76cde0,0xccd9cd30,0xccc1ccc8,0xcd0bcccb,0xce07cd64,0xcffdcee4,
0xd2d2d150,0xd636d46f,0xd9dfd81f,0xdda5dbc8,0xe1bbdf9b,0xe62ae3d4,0xeb12e88d,0xf04eedc3,
0xf5c2f317,0xfb15f862,0x008cfdd3,0x05e502e1,0x0b6308a7,0x10ec0e2f,0x163a1395,0x1b4a18df,
0x20431de2,0x24ad2290,0x28b326c9,0x2bd72a66,0x2eb52d64,0x30eb2fd1,0x32b531d3,0x33ec3354,
0x34763456,0x34413492,0x335633e5,0x31b032ae,0x2fa430ae,0x2cfb2e58,0x2a302b87,0x2738289d,
0x23f5259d,0x207b224c,0x1ca01e9e,0x18531a8b,0x13ad1613,0x0ea0110c,0x09630beb,0x049306f7,
0xffe80232,0xfb3afde5,0xf66ef8d3,0xf185f3de,0xece1ef36,0xe86eeaa4,0xe43ee65f,0xe024e218,
0xdc27de1f,0xd892da49,0xd559d6dd,0xd253d3c6,0xcfc4d104,0xcde1cecf,0xcccbcd35,0xcc76cc92,
0xccc9cc94,0xcd6bcd0b,0xce93cdf4,0xd01dcf3b,0xd214d111,0xd4e9d371,0xd868d67f,0xdc34da52,
0xe01ade22,0xe426e20d,0xe85de636,0xed36eab9,0xf25defa7,0xf79af4f8,0xfd17fa64,0x02580003,
0x08770577,0x0e690b5b,0x1400112a,0x195c16c4,0x1e821bf4,0x234d20f4,0x27bf25b9,0x2ba129b5,
0x2ea22d2c,0x30ed2fcf,0x328431d8,0x33903300,0x33e333c0,0x33ec3401,0x33af33e3,0x32ae3336,
0x31563214,0x2f4a306b,0x2cc52e3c,0x29cd2b50,0x2682280f,0x22d3249a,0x1f1320f4,0x1ace1ce4,
0x162d188c,0x112713bf,0x0bee0ead,0x06a4095c,0x0189040e,0xfcedff08,0xf7b1fa48,0xf295f53e,
0xed7ff018,0xe897eb24,0xe3e4e611,0xdf7ce186,0xdba4dd67,0xd883da01,0xd5bcd70d,0xd35bd47e,
0xd138d22d,0xcf88d059,0xce70cefb,0xcdf0ce2e,0xcdeecdbe,0xce11cdfa,0xced3ce96,0xd012cf4b,
0xd191d0c5,0xd3add2a8,0xd655d4d7,0xd98fd7c2,0xdd68db6c,0xe1e6df97,0xe6cae447,0xec1fe978,
0xf166eeb8,0xf6d5f428,0xfc36f987,0x0160fecd,0x069703d0,0x0c14096b,0x11720ed4,0x1696141e,
0x1b7d1931,0x1fea1ddb,0x241621fd,0x27cc25ef,0x2b3e2998,0x2e442ccc,0x30cf2fb7,0x328931e5,
0x33b53340,0x344e33f6,0x345d3475,0x3401342e,0x32eb3365,0x31423235,0x2efe3038,0x2be32d90,
0x282e2a0a,0x2408261b,0x1fe1220a,0x1bef1de1,0x17c219d8,0x138b15b5,0x0f3a1175,0x0a890ce1,
0x05910839,0x005d0311,0xfba6fe39,0xf669f8e2,0xf116f3ae,0xebb2ee58,0xe65be907,0xe158e3e3,
0xdd02df2c,0xd951db11,0xd67fd7ea,0xd3ebd538,0xd1afd2d7,0xcfb9d087,0xcdd8cebe,0xcc5acd26,
0xcb69cbce,0xcb00cb0a,0xcb9acb48,0xcd15cc50,0xcf8ace26,0xd271d0cb,0xd5b5d403,0xd94bd791,
0xdd21db29,0xe10adf11,0xe53de32f,0xe9eee771,0xeef6ec47,0xf46df1b2,0xfa04f72f,0xff88fcca,
0x04970200,0x0a23076f,0x0f8d0cc7,0x14fc123c,0x1a34179e,0x1f241cab,0x23712163,0x2748255e,
0x2ab828f4,0x2d7e2c15,0x2fda2ebd,0x319030a2,0x3292320c,0x331b32f0,0x33083324,0x329e32e2,
0x31b73232,0x3061310a,0x2e852f8a,0x2c4b2d7c,0x29852b12,0x261d27c4,0x21ee23f6,0x1daa1fe9,
0x19951b9a,0x1552177a,0x1101133b,0x0c820ed7,0x07e10a4c,0x02fd055f,0xfe3a0046,0xf8dffb7a,
0xf3eef694,0xef31f1b9,0xea9becfc,0xe637e876,0xe22be428,0xde00e00f,0xd9fddc07,0xd679d82c,
0xd36bd4e8,0xd0dad221,0xcebecfaf,0xcd27cdc7,0xcbd7cc60,0xcb51cb91,0xcb6bcb1f,0xcc1dcbb7,
0xcd9accbf,0xcfa8ce92,0xd267d0fa,0xd584d3fb,0xd8d5d724,0xdc89dab2,0xe0abde85,0xe55be30a,
0xea95e7e3,0xf01aed4d,0xf611f314,0xfc49f93b,0x0229ff66,0x07e304cf,0x0d540a93,0x12e21043,
0x185d15a8,0x1d841b01,0x222c1fd4,0x26452459,0x29d52824,0x2cf12b8b,0x2fc22e6d,0x320b30df,
0x33ba32e3,0x34953453,0x34fd34b1,0x347634a8,0x339a3420,0x322232e8,0x301b3112,0x2d602ead,
0x2a1e2bbd,0x26b02883,0x22eb24f0,0x1edb2111,0x1aaf1cea,0x16371876,0x11ad13ff,0x0d130f78,
0x08820ae1,0x03bc0620,0xfeff0157,0xfa80fcf3,0xf5c8f80d,0xf155f374,0xecdeef05,0xe8bdeabe,
0xe4bae6b6,0xe0fbe2d5,0xdd31df10,0xd99bdb5a,0xd632d7c0,0xd327d4a0,0xd0ced1d1,0xcf06cfd4,
0xcdd4ce5a,0xcd3dcda2,0xcd1dcd17,0xcd7fcd40,0xce6ecde1,0xcfe7cf0c,0xd201d0e8,0xd4abd334,
0xd7a1d605,0xdb14d962,0xdedfdcee,0xe2eee0dc,0xe729e507,0xebb4e978,0xf093ee21,0xf622f35c,
0xfbebf8f9,0x01acfed0,0x075b0456,0x0d0e0a3f,0x12ca0ff6,0x185f1588,0x1dc81b26,0x23002072,
0x27aa2560,0x2bd229b9,0x2f252d8f,0x31ed30a7,0x3412332d,0x357834ed,0x361935de,0x36063603,
0x352f3589,0x341434c1,0x32783365,0x30253161,0x2d4c2ecb,0x2a1c2bb7,0x269f2875,0x22da24ca,
0x1ed920e1,0x1a8b1cd2,0x15fa1853,0x112a1399,0x0c140e79,0x06d9096d,0x0181042e,0xfca5fef0,
0xf726f9c7,0xf1def489,0xed0bef60,0xe87eeab9,0xe461e66c,0xe088e244,0xdcdbde95,0xd97cdb34,
0xd6a2d7f3,0xd3e7d52e,0xd19fd2b6,0xcfffd0b1,0xcef1cf61,0xce9bcebc,0xce73ce81,0xced6ceb1,
0xcfa8cf34,0xd0f6d04d,0xd2b3d1bc,0xd4ded39e,0xd75ad5e8,0xda1bd8a4,0xdd6ddbb7,0xe113df17,
0xe517e30c,0xe9d1e777,0xeec1ec49,0xf42ff198,0xf9abf6e3,0xff0cfc4c,0x03d901a7,0x094906d9,
0x0eb90c18,0x13ea1133,0x18fa1669,0x1de91b7b,0x2267202f,0x26a82496,0x2a792899,0x2da12c1b,
0x30642f13,0x32743186,0x34033362,0x3515349f,0x3548351e,0x34bb34f4,0x33823423,0x31d132e2,
0x2fa930c7,0x2ce22e5b,0x29f22b82,0x26922847,0x22b024b5,0x1e6a209b,0x19e51c36,0x154d17ad,
0x10b512f9,0x0bee0e5f,0x06dc0995,0x01cd047b,0xfd06ff42,0xf779fa11,0xf21bf4b2,0xecf1ef64,
0xe814ea90,0xe388e5de,0xdf04e124,0xda9ddce6,0xd6a4d8a0,0xd320d4bc,0xd062d198,0xce76cf5a,
0xcd6bcde1,0xccd0ccf3,0xcc9dccaf,0xccc2cc9d,0xcd54ccef,0xce59cdce,0xcfddcef7,0xd1fcd0ea,
0xd4ccd360,0xd829d676,0xdbeeda1b,0xe025de23,0xe48de267,0xe92ae6df,0xedddeb7f,0xf2a9f031,
0xf78ff51d,0xfca5fa1a,0x0181ff22,0x069903c3,0x0bb9092b,0x11360e70,0x169513d8,0x1ba1193c,
0x206b1e45,0x24bb22aa,0x2854269b,0x2b6129f0,0x2e142ce1,0x30422f29,0x31b9310c,0x32b83232,
0x32f832e2,0x32c832fe,0x32103289,0x30cc3187,0x2f07300a,0x2ceb2dfb,0x2a412ba3,0x278a28fc,
0x24862625,0x210722b3,0x1d0c1f13,0x18971ae9,0x13ee1655,0x0f5511ac,0x0aba0d13,0x0624085f,
0x015a03c8,0xfce7ff15,0xf7a2fa2c,0xf250f4ed,0xed47efa1,0xe829ea92,0xe3b1e5e5,0xdf9ae195,
0xdb9edda4,0xd7e5d9c1,0xd47dd626,0xd169d30f,0xcf51d052,0xce22cea8,0xcd64cd9e,0xccf7cd0c,
0xccf0ccd5,0xcd61cd15,0xce5ecdba,0xd011cf1f,0xd277d132,0xd57ed3df,0xd8cad70d,0xdc50da8e,
0xe029de43,0xe49ee25e,0xe96be708,0xee61ebfa,0xf369f0e6,0xf868f5d7,0xfdcdfb15,0x0311007d,
0x08950604,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,
};

const uint32_t sample_14_standard_DRUMS_hatopenms[5888] = {
0x00000000,0x228cd73e,0xf372fe5c,0x1b591553,0x2d2ee4e0,0x4a71de7a,0xeceede65,0x0abd28ee,
0x37a0e0c1,0x0f4ed5e7,0xeae20766,0xe2e92585,0xd962168c,0xdd7b3179,0x1c6dd4bf,0xc4dff603,
0xbdcc2577,0x1036091f,0x433e9976,0xf0f5c90e,0xb94b206c,0x1f672beb,0x296bd41d,0x14d1eb8b,
0x1c2603bd,0x4072d9e1,0xef12fcaf,0xf92c24e5,0x00cc0d00,0x0b480033,0x0766ec84,0xfd600b09,
0x3971e99c,0x7a058ec7,0x26cd9c22,0xcafb0d14,0xf9882d0a,0x09e1f0ba,0xd88312c5,0xd5e62306,
0xbaa735b0,0xf64e4049,0x3fdde7a8,0x15fcd331,0xeaac0946,0xdc212001,0xfde31296,0xef4209cb,
0x0bcf0195,0xfdfe038e,0xee6c0b9a,0xf37622fa,0xdb940e02,0xa1d35404,0xd6b73d26,0xb4284907,
0xc7433cde,0x06cf0a55,0x1edcd47a,0xf431edcd,0xd2821047,0xd0ae388d,0xe9b1126d,0x0680fc81,
0x175ee677,0x04abeb86,0xe127059d,0xd63d36b6,0x01820b90,0x3946f315,0x4e8ebab2,0x1cacc2a5,
0xe9cc0cf2,0x21900d5a,0x3fefbaf9,0x09dcdb38,0xe9b10f1b,0x2b2502b8,0x2248d1b6,0x1feadea0,
0xf313ee3b,0xe8301e30,0x3dbdf172,0x5cbc9ef9,0xf96fcbd9,0xf4831793,0x13e5f757,0xdf14f068,
0xd44c3b7f,0xff0c174e,0xf2aa0402,0xd91029f8,0xfa282690,0x199ff8a9,0x1f67ed88,0xe8f2f690,
0xe9bd25c2,0x171bffc7,0x5992c4f5,0x2cffaac9,0xf4f3ebb0,0xe8371704,0x0caefade,0xda2308f2,
0xf7310b37,0xf45803e5,0xfa9efe7c,0xe65f113a,0xe58e2b0d,0xf9a30e91,0x2783f8e1,0x3282c6a3,
0xe322f0f4,0xff5a310b,0x455ed7b7,0xfab0d3a1,0xf24f1a74,0xffa209bf,0x1abff53b,0x325cea85,
0x1685d68b,0xc7661431,0xe3822fb1,0x01290c18,0x0708e650,0x03cb0ba3,0x6852c831,0x403799d6,
0xef56fa76,0x01f202f3,0xf8d9f1ff,0xe40a11ce,0x0bec0304,0x15d2e09b,0x0be2ed4d,0xca671b8b,
0xd3e9397a,0x066a1974,0x0744f60f,0x15dbf4df,0xf155f0e6,0xfe1b12d6,0xf94ff387,0xb37f278a,
0xc33b5331,0xee4a2115,0x0cec062f,0x0d81eac1,0xd5780ace,0xe68f276a,0xf7cc0a0b,0x08e9fe37,
0xfb5e0693,0xd5b620ac,0x1fab1796,0x3304cbff,0xe68cfa60,0xf7b00c3a,0x2193f7d8,0x099de6d5,
0x0b29f761,0x03210285,0x04d3fe9c,0x1e00f31e,0x1c3ce15c,0xe857f7cf,0xe4932765,0xf81c110c,
0xef46079d,0x0d3fe699,0xfe80fe61,0xde0efdcd,0x1da113b9,0x0ccfd38a,0xe17c0e91,0x007f15df,
0x0a66f302,0xe1d80503,0xfa2b2e76,0x02c1071f,0x03bd0bf5,0xc2f324e8,0xf8053741,0x0c2deb52,
0x1aebfc86,0x06b1e73e,0x3e0ad851,0x484faa5a,0x2d66c09f,0x0c64dd8b,0x13f6e6b6,0xf18004c7,
0xcd232266,0xe99e2fd5,0x4270ecfa,0x58499891,0x3932bc44,0xfc5ae992,0xf11c1173,0x104a104f,
0x2525e2cd,0x1809df5b,0xff9cec82,0x135d0cb8,0x169ad876,0xfff8faf1,0xef271857,0xfc5ff600,
0xe2532112,0x1fe3f5eb,0x113edb9a,0xf97ffc55,0xeafd007b,0xd41e139a,0xde3a28d5,0x1a2d086b,
0x3fe4c5f0,0x1cc6e59e,0x0436031e,0x30c5e742,0x2538e731,0xfe92e55b,0xd0b81669,0xf4141b65,
0xf7090e3a,0xfa01f0eb,0xec5014df,0x24e5ef67,0xf784da70,0xdd5c20a8,0xc254322a,0xf8463034,
0x0dec0022,0xfcfcf509,0xfcb80be5,0x13b7f769,0x1406f57b,0xf8b7f545,0x03871d6e,0x03adf58a,
0xfd43f174,0x15a3fb99,0x082fec5c,0xfc1bfe96,0xfc700830,0x0450fdae,0x103df720,0x22d3cf29,
0xda59fd71,0xf5451c79,0xee0f0bf6,0x0cb2039c,0x09bedd66,0xb1cb3b72,0xe572371f,0x2195007f,
0x1b90e22c,0xda6c093a,0xb62e49f1,0xf4b22e75,0xd0021b12,0xd6703ac8,0x1180069d,0x039fe2c6,
0xd91e14f7,0xee571360,0xfd41f9be,0x11eafa45,0x1df3d45f,0xf80efecd,0xd64c199b,0xc5db4242,
0xedcd1df5,0x0892fe35,0xc7aa1c15,0xf9d732c2,0x2444e453,0x2151dcfa,0xf485e9f3,0xf1571cd0,
0x116aee7e,0x24bde3ba,0x288bd6b6,0x140fe419,0xf61dfde0,0x08140f5f,0xd6b10afa,0x126b1845,
0x3afad27a,0x5194b75f,0x21f7c169,0x1b48e62b,0x0207e96f,0xe6e30721,0xe7b215c3,0xff02120a,
0x1dfcfa7a,0x32e6d248,0x138be41a,0x0766eef0,0xfc770838,0x1decf037,0x028df4b4,0xf1b80664,
0xdb7211bc,0xb5982f3a,0xe4733172,0x001c0968,0x157fea65,0xfc9ff2c8,0xd7872783,0x1a6d04c6,
0x0c72de4d,0x1d1bef8b,0x19e8db81,0xfddaf5bc,0x2fe0ed43,0x21fbccad,0x0234f43b,0x1805fbb5,
0x0f02e959,0xff1209e4,0x003bfc8a,0xee111ec7,0x2aaeec65,0x2265d07b,0xe411f7af,0xf59d2404,
0x2d8fef62,0x1ac0dee8,0x0954e366,0xff8309dc,0x2a1eeb34,0xeb74e676,0xdb962314,0xdec8318f,
0xe84b21a1,0x22a0ec69,0xf1f1e792,0xd9081ea6,0xebec0934,0xf1ee1f6d,0xff8fea26,0xc8cb22ce,
0xe34b29bc,0x110effce,0xf444f287,0xc1053f19,0xc3273ce2,0xcca43da1,0xe8de2fce,0xf48b10c7,
0x2b99e8c4,0x0773ef0f,0x03e500ef,0x2231f234,0x0f8fed78,0xf95afb71,0x0416fa41,0x049c0571,
0x1b87ec6f,0x4093e3bf,0x47c1a839,0x046fd118,0xeb4b05ca,0xd5d820ee,0x041a0328,0x0349fca3,
0x09590df8,0x46d0cf05,0x564ba52f,0x20ffc922,0x2541ed74,0x3817d192,0xfd84ebd5,0xc31c2369,
0xf3fe2d4d,0x2f93e10c,0x0f30d9c3,0x01c9fef2,0xffe0f330,0xdb430e23,0xfb1f0d9b,0xe2d6fbe6,
0xdd491d39,0xd287231c,0x0d122cbc,0xfe36ee6b,0x2046fcce,0xed5bf87d,0xda641597,0xc1b341c1,
0x10fe1f18,0x3709d3fd,0x1207e0c9,0xe02e0b40,0x1c990944,0x2fb5d3c7,0x0f2ed89c,0xceee1e86,
0xed9f2e1d,0x09c9fc99,0x09efebb0,0xe164083e,0x1ac20003,0xfeafdeac,0xf9ac0230,0x2466ef42,
0x31e2bf4e,0x0ab8cca7,0xf3e1102d,0x0555fe91,0xed6f14e0,0xfd092a98,0x3252e4bf,0xf6caee0f,
0xe0a61d90,0x0912182c,0x2ee9dfc8,0x1978e388,0x14c7ea28,0xfccaf297,0xd55522da,0xd7391774,
0x01ed20dc,0xd8cc00c8,0xdf47303b,0xccdf15c4,0xc19d30b2,0xdd3e2a2e,0xf57208cb,0xf9030367,
0x05e0f7a6,0x0681fb00,0x3c33dc05,0x3fcdab87,0x0ab3f00c,0x18a9f2b8,0x1f02fa78,0xe6af11ed,
0xe66d2f23,0xf7b624ed,0x412ad60d,0xe96de545,0xf3c32a68,0xff7dea8e,0xffd60c2e,0xff20e621,
0xef12105e,0x37ced72c,0xef5be82d,0xf63c0cae,0x085dfab9,0x05acf0b8,0x0a7eed6f,0xeb930bc4,
0xf8fd089c,0x2ffcfcf5,0x33ffc275,0xe353f3f8,0xef94359d,0xe23f0e01,0xe35c27d7,0xd38824c8,
0xe44031f7,0x1d2a0247,0x3929d458,0x129bcec2,0xf2a90d9b,0xe2fa13ca,0xe3571602,0xd3cc15c7,
0xc8a43ec4,0x2008f01a,0x0c6ad8fc,0xe76efee5,0xf8ed1247,0xeeab1d6e,0x223df17c,0x10d4f892,
0x202aed6a,0xf964ec61,0x1b09079f,0xfcffef8b,0xfadc0f1f,0x0e3ffef7,0x15c7ef28,0x5496bc64,
0x38b3abea,0x2bc3d314,0x0efce3f8,0xf6810470,0xd8130f45,0xf77d10b2,0x0cb8fb8a,0x0f50e70b,
0xe9100e14,0x0fe60b16,0xfce2ee29,0xd06f1690,0xde052919,0x111a0686,0x18afe072,0xfb5afc8f,
0xe2e318be,0xdb9f2cf2,0xf0851edb,0x178df852,0xf800ff66,0x1b39f53e,0x0ba7ef85,0x1312ee6a,
0x06adef10,0xee23009a,0xeb1d0de6,0xe15b1d79,0xf5801c90,0xf4c90672,0x0e820555,0x0056e8f4,
0xd99b12f7,0xebca1ae9,0xe46e1b0b,0x017618cc,0x365ad3c7,0x19c6d598,0xe494fa3b,0x0f8019ea,
0x240ce403,0x2831dbe6,0x01e2eed8,0xfa651d3e,0x1757eb63,0x00fdf650,0x0a0a01c6,0x207be3da,
0xfb76ebad,0xe1161d05,0xf4680f10,0x1799ee62,0x16fad7c6,0x0bf4efbf,0x02aff27c,0x03f100e2,
0xd62e1001,0x00e2128d,0x0756f069,0x115bf5a4,0xe7720039,0xead82586,0x26d9ea9c,0xebe6fa60,
0xc9712a74,0xde894047,0x1ac20c83,0x1913f2fd,0xeb480b42,0xdeab2034,0xd00c2667,0xf88c241e,
0x15c5e7ad,0x1654ef1e,0x23bdd7ec,0x3628c98e,0xf164cfdc,0xe7251e0d,0xf111011e,0xfd79069f,
0xf7a0f927,0x21a403e4,0x2997bd2f,0x0b21ef06,0x1c41f032,0xe680078f,0xb55d4029,0xc4b65927,
0xfa3e16bf,0x184701ff,0xf11bfc56,0x12950a68,0x16defd7f,0x1d65ecec,0xe063f98d,0xece227c6,
0xf4a20610,0x057ce9da,0xf97ff311,0x1373f071,0x08edd371,0xdd970ad7,0xec131dad,0x042702e2,
0x09eef569,0xf1dd156c,0xf3f810f6,0xe78d1ed5,0x09821599,0xef16ffe7,0xe5ce26ce,0xfdf22173,
0xed5c0d50,0xf4ff1b71,0xf0ce0927,0xfad803bb,0x2813d349,0x031befd3,0x0f29ed7f,0x1ecfe6c7,
0x0f62e68f,0xe2620b80,0x22edf230,0x28b7d75b,0x2b33ba85,0x1274eb7e,0x0d58fa5b,0x0858efc9,
0x08310129,0xee221389,0x10d109f9,0x440bdf67,0x0e4cdfd2,0xd4d813d6,0x01ed151d,0x1d6bf3b6,
0xfcd1df88,0xef060a11,0xc24d2e71,0xc6bb3cf4,0x06a910ad,0x010eea1b,0xf3abfa47,0x0d20fab7,
0x16a3f5dc,0xfdb3e589,0xdb8a1a9d,0xdf582dfc,0xe89b1459,0xeb27181b,0xdedc2d1d,0x04290d19,
0x1f81f0ea,0x0f87f6f6,0xf10cfe7a,0xcc3a2e1e,0xfa9e3413,0x09f1f7e2,0x2528f147,0x03fce1b3,
0xd6ca0296,0xed4e2a3f,0xfffaf5d2,0xf52802a0,0x1139fc73,0xf694e5c9,0xe48b1d4e,0x0ca503c2,
0xfea7f3c2,0xe7ee01a3,0xf44a1a1f,0x03841586,0x2cbbdbba,0x0344ee99,0x2a40f2b3,0x0867e464,
0xf2530cd0,0x0962f840,0x02a20214,0x0ac0fd22,0x10abfb13,0xef8df230,0xd4e725a2,0xc134357c,
0xd74c45db,0x1482008f,0xfc6aeb33,0xf0e206de,0xff2e08ff,0x0bf6ef54,0xe66506b1,0xce192d5f,
0xfebb1efc,0x0a71e9fc,0x08c3f9b5,0xfb2ef868,0x16a90326,0x06baf071,0x0c2eec08,0xf1cc0663,
0xf23e1270,0xf925023d,0xf3b81ccb,0x0adf016c,0x06f9fffe,0x15e2def4,0xed0e01c6,0x0252183b,
0x17cbf51c,0x1374e578,0xecc5fbe2,0xe47f233d,0x1299f657,0x0318ed40,0x0786fafe,0xfb6301fe,
0x0f06050b,0x214bd5ca,0xe36501a4,0xe4e518f5,0x0db40fa7,0x1049ea54,0xdf810bac,0xf9451870,
0xff5e021c,0xe0e101ed,0xdd523da9,0x112ffdec,0x1733e4af,0x0e64f2e3,0xf6dcfdf6,0x0007fc50,
0xf1940dfc,0xd9471651,0x0b9e10cd,0xf9cdfdb7,0x2200fc90,0x1485d63c,0xf58e0547,0x0691f9c0,
0x00d9fd04,0x0184fc83,0x10f3f4d6,0x14feffe4,0xfed5f7cd,0x0524fe9e,0xf61b0946,0x010e0fdc,
0x21e2fa50,0x2cf2d42d,0xfca1eb78,0xd7720e36,0xf2f41c34,0x02cafb20,0x0592f5fe,0xf1b8f117,
0xc97f2904,0x172e0cc8,0x0d77d428,0xf20dffd1,0xee230ebc,0xf4d81b56,0xd29824f4,0xcdda2eca,
0xf9bd2e15,0x14e1f3e6,0x0562ed4d,0xfe6f04a2,0xfa190c6e,0x0f8a0135,0x19e3f4c9,0x1d57e436,
0x0c5ced53,0x0b08f981,0x03befd7d,0xf720f5b5,0x0aef0cc0,0x0b82d5b6,0xfa7cf7fa,0xffe205ee,
0xf6baf1d3,0x07f7f8ef,0xe9f7fb44,0xd638242d,0xf0931949,0x18450b47,0x4611d13d,0x295bbc82,
0xee0a141d,0x0a240924,0xf6980700,0xf4b00f97,0x2e82f282,0x43debbf7,0x0accc8ed,0x086bfffe,
0xf68cfa5d,0x0bc80a44,0xf516f830,0x06e3fe83,0xe4700a46,0xcfc82d9b,0xed952037,0x047df80b,
0xeb650598,0xdfe11bbc,0xce592261,0xf4fa2a0c,0x1905edc1,0x14aeefff,0x0a33e8f7,0xece200b7,
0xdecd36f4,0x0860032d,0xef620e8d,0xd103290c,0xdf013963,0x1dbb01ae,0x1337d89c,0xedd4f540,
0xea370ec8,0x17410430,0x2eaabba5,0x0029dfdb,0xe1720bd2,0xddf3214f,0xf80e21fe,0xfc2cfac6,
0x008b1049,0x2f48ef67,0x1d40ce83,0x07650195,0xf329065b,0xf9b12dff,0x15bff086,0x1f37eb27,
0x04cced73,0xf5fe0b7a,0x11e6ff62,0x10b0e524,0xee6ae9f5,0xea5d12e9,0xd2910ef4,0x02750d01,
0x2909d5ac,0xdbe3ee13,0xe1991102,0x00850eb0,0xed9d02f1,0x01d31047,0x2378fb2e,0xf388fa9c,
0xde2d26ed,0xfc8f2d62,0x0c6f04bd,0x0eaefbd2,0xee930126,0xea7c2624,0x02dd0511,0x0817fc9b,
0xf51cf28b,0xf53212c4,0x1a1febda,0xf744e424,0xfd0a0405,0x15e4ed88,0x2156ddfb,0xfd43ded6,
0xddbd127a,0x126e1115,0x1817cd0d,0xfc2cfdfb,0x0744fda2,0xeeb40ec8,0xfbf61589,0xf3491301,
0xed210f2e,0xf0bf2340,0xf5711579,0xeeac1072,0xce192e31,0xfe4f1c95,0x191edcd1,0xf29af9da,
0xed220d8d,0x00be09c9,0x185ff01d,0xf2a8f093,0xe7c20ff8,0xf33f126a,0x1c8af791,0x1894e7e3,
0x0a1ae779,0x17ddf260,0xfde3f93a,0xd6f21f1f,0xe3371fae,0xe6992831,0x0aa301bf,0xf863fcb7,
0x10720174,0xe345f970,0xf5b2212f,0x162f0014,0x20e2d405,0xf401fb10,0xe5e52071,0x02a50676,
0x1748e6dc,0x1392e9db,0x0a99dd3f,0x03860ba2,0x32afe23f,0x077ee4af,0x1500ff14,0x0cbaf9ab,
0x0d11f568,0x0f88f554,0x16faec83,0x11ffe6da,0xf1d8f90f,0xdffd1afe,0xf453144f,0xf8b40573,
0x02ce014b,0xfcf500a5,0x19ebeda5,0x0b1bec36,0xe96902c9,0x04e60370,0xec080e6c,0xee9110b0,
0xe9f01883,0x0a6b1564,0x0f55e710,0x0cdde164,0x0a8600c7,0xcd8c0b60,0xff662305,0x14d9f32b,
0x0484f1ec,0x0562057a,0xe5a2196b,0xfda90621,0x2301f23b,0xf957ed18,0xccf51318,0xfc561dce,
0x260eeb16,0x05fae7d6,0xfbf90e78,0xf9b50b64,0xf7330840,0xda871ad1,0xef0f2f8e,0x104eefaf,
0xe9550480,0xed281475,0xf02d0888,0xfc1801e6,0xf332f947,0xd6350a58,0x0eaa1370,0x0384e190,
0xf493fedd,0x08a40317,0x052e0297,0x29d7eb29,0x1491f251,0x03d50388,0x04960cc8,0x2aa5f12e,
0x0b99e971,0xf852fcd9,0xe918209a,0xfc120344,0x0a32086b,0xf438fa84,0xda391f77,0x06e6fa7a,
0x025cf06d,0xf77cf6cf,0xe3750121,0xe8f80f6a,0xda2d0ffe,0xec841d53,0x0fc3019d,0x0707e681,
0x00d70778,0x08f207d3,0x1c39fd63,0x09e8ebef,0xf6f0168b,0x074d09ea,0x100b05a7,0x09ef04be,
0x08eeefdb,0x0cddf534,0x046df94e,0xedc1efee,0xd1b414f2,0xcef8228c,0xef191949,0xf0fe0c5e,
0xf0990c4f,0xf1e403fd,0xdde81bc5,0x112b0fb1,0x226de2de,0x0ca0e226,0xdbef158f,0xed661f06,
0xfc3111ca,0xfdb3f784,0xed31206e,0xfae51435,0x11c10910,0x0c39eacd,0xf247fbd7,0x07020cf7,
0x01cbee00,0x04800177,0xf8010319,0x00d8f8e5,0x05c4f3bd,0xe8f3f7b7,0xed7d1485,0x0e9af586,
0x0edced3a,0x051be59d,0x1f06094b,0x2290e687,0x0407f328,0x04d21213,0x0327fafb,0xf8740f2e,
0xfee8029f,0x0b9ff79e,0xfc0ff3cb,0x0f8200ce,0x1842db9b,0xff31eac5,0xe4f8129d,0x05530d6e,
0x1cb2e1d5,0x0441e6fa,0xfd98f700,0xf10e0f2d,0x14a20d23,0x2109dc1b,0xed4cf8ef,0xed45133d,
0xfa1013ea,0x0b84f756,0x1b03f5ba,0x022af0e0,0xd79b1aed,0xe31638bc,0xf2391aa2,0x208ff720,
0x03d9f120,0x052ffbc0,0x1216da0b,0x0537efaf,0xf545f7b2,0x053bee30,0xf31f114a,0x01f7faf3,
0x187ef22b,0x0fe6f04b,0xf696fa36,0xf13e1d33,0x09410a2d,0xe91a0975,0xf5981ec7,0xec1721bb,
0x0946048a,0x3e24d661,0xf012d93f,0xc3b52c30,0x08aa1921,0x1482ed08,0xf111e70d,0xf7c717da,
0xff7304d6,0x17a4f9c7,0x0923e655,0xeea00bb9,0x073ef9cc,0x01e2fb1f,0xf922fc60,0x05eefd23,
0x0027fef2,0x1598056d,0xee87f45a,0xd6fa29b2,0x05dd13f3,0xe7ab08f7,0xf34a0949,0xfcf00c1f,
0x019801d7,0x139fe9ff,0xfa6803c7,0x0da8fa15,0xf974f13b,0xfbad04fb,0xd8d518c7,0xded6253d,
0xfbe61e80,0x1462fadb,0x008aee5f,0xe9db254b,0x093c01e5,0x186bf887,0x0b90e3a5,0xd30c10d6,
0xea2a1249,0x055cfc9c,0xfda4ed9f,0xef1b07ce,0x0b780058,0x0508f8f6,0x030bf841,0x102cf090,
0x0e06eda9,0xef060366,0xfb340e71,0x06e00cb0,0xf3eff057,0x028713a6,0xf5ce0709,0x0d920d6a,
0x1b4be5ef,0xe9350db4,0xfa4a0423,0xf7db1a70,0x0799f849,0xedd0057a,0xfdc308a9,0xf5c90112,
0xfa3cfc18,0x0f94ee0c,0x0718e5d2,0xfe5cf9f3,0x0f0eea93,0x1034dc9e,0xdb981200,0xedfc1cae,
0x06c61415,0x0c4800d9,0x0e2bedcc,0xf7d41af0,0xfb5e0c8e,0xff66ff01,0xeb4d12f6,0xeb541ce1,
0x005f045c,0xf20f1551,0x09700125,0x1905dd65,0x0bc5faa3,0xe5a6013e,0x09e608e0,0x10e1f450,
0xffe1f23b,0xf07e08f6,0x07c002e4,0x11bae3c8,0xe7bbf4dc,0xe48f1d87,0xeade0124,0xed950b8a,
0xec401647,0x067709a2,0x1bafe637,0xdba51cb1,0xe5762cfa,0xf8be0d96,0x1d910436,0x05b8e88c,
0xdeda003e,0xfbb6290f,0x1996ea9c,0x0dc5e271,0xee321d74,0xf9b4ff2f,0x0b16f962,0xf23706e7,
0x02ed0ccb,0x2dc3dc6f,0x08a6eaf4,0xd4d113d0,0x0685184a,0x15c9f58e,0xfca4eb2b,0x050cf169,
0x002a03f8,0xef45f5c8,0x0a0bfeee,0xf7adf8f9,0x0d2600ab,0x1246ef7d,0xf8010e8e,0xff930662,
0x21d4ed6c,0x070def54,0xf16af199,0x04071542,0x11b8ed62,0x0b64f5d0,0x0c94fd5b,0xdbe10f9b,
0xeb952af4,0x1b7dfb44,0x1c3ee6eb,0xee66f93f,0xeab90e12,0xf6220f33,0xf2080f45,0xfd0d0963,
0xea37106b,0x0246080f,0x075fe860,0x0901f726,0xe92cf37b,0xe4421609,0xfaa31f24,0xf1bb0659,
0xfbba16f6,0x1374f983,0xfafff946,0xff75fceb,0xef67068f,0xcc0c1f9c,0x0db91980,0x05dfe3ed,
0xf97909a5,0x144aeeac,0x14b4fa46,0x1820dc6b,0xe04c1177,0xeed01ffa,0x0422ffbc,0xfffd02e3,
0xf9d212c7,0x1a4bf52f,0x156eea2d,0xeb320bf5,0x034f02cb,0xffdbf419,0xf15e0596,0xe4c90d1e,
0xe8911fbd,0x06a600a3,0x18a4f414,0x114aec86,0x0d97f65b,0x1cb5dec6,0x0ea9db17,0x0d77efd3,
0x07c0f208,0xf78205bb,0xe9051474,0x2e3efc21,0x1d61d1d9,0x0083f6c5,0xe72a0bf6,0xf83e1286,
0x06290288,0xefb1fa6a,0xf2ff12f1,0x02bcfdec,0x0af50daa,0xfeaafb54,0xfcfa0e08,0x0a16ed45,
0xe9630966,0x01371343,0x2944e360,0x2d60d9df,0xee79ffe6,0xf01d10e7,0x075a0cd9,0x080ae1fe,
0xf2050440,0x032bfe94,0x0879e848,0xc8590ad3,0xf5542630,0x138eee3c,0x12e8eee8,0x02c6f6eb,
0xd5071443,0xf3fc250a,0x1980f095,0x0219e568,0xf3eb1a3a,0x06cf0a44,0x009efd26,0x1a61017c,
0x1e66ddd0,0x014704db,0xec531086,0xed6a1ec3,0x1567f875,0x0a62ef69,0xf095f920,0xef590d4c,
0xf1fa1643,0x0599f151,0xec4c03c3,0xeee8fd4c,0x056202ee,0x15cce91b,0x0d60e223,0x1b37f393,
0xf483ed9f,0x0387144d,0x024d0671,0x06b6fdf1,0x11bbf618,0x0b14f069,0x01ab0497,0xfc5dfe3f,
0xfb2107ee,0xe8d00806,0x0b4e0e66,0xf97cfc11,0x22f1edb5,0xf3d9f004,0xe0b12b31,0x0dd902e9,
0x005deee9,0xf3630cb8,0xf980092d,0x1ea6f76b,0x196cd492,0x01c6fc0a,0xf7cb0034,0x044d07b3,
0x10e5e396,0xf7b7f5eb,0x04b702df,0xff230b2f,0xf717f953,0xe3df1b4f,0xe6f51984,0xf0c801e8,
0xf1161621,0x0e15ff42,0x1d83db07,0x037afcf0,0xd7ca0b9e,0x14fc0bfb,0x1453ebd4,0x06060735,
0xeda4007a,0xf0022783,0x0e7dfad4,0x0628f43b,0xeb290429,0xe54c1c86,0x08170992,0x14b8eedc,
0x1e63df7d,0xed58e6bf,0xcf9920db,0xc5d43818,0xf84a21a8,0x15c7edf7,0x03b900b4,0x1f6cf0b3,
0x1aa6e39d,0x09def8a0,0xf709f7ed,0x13c3fe35,0x0611ecca,0xf09e0120,0x0249ffd9,0x0dee0b0f,
0x2279dc3b,0x0193f2e8,0xf5ad0f8a,0xf2d0053a,0x1ea10242,0xf8f2f554,0xf554f91e,0xfbb00ace,
0xcde016c6,0xf37120a3,0x1fcbec16,0x10caeadc,0xea58f6e9,0x0a451623,0x1519e270,0x08cdefab,
0x0b47ffb1,0xf1030936,0xea7117c4,0xf0461691,0x075104b1,0x06e5f2b7,0xec7c0812,0xf07616c5,
0xf49507e7,0x0219086f,0x034ff47a,0xe2dd057f,0x0bcf0fbf,0xfd2af8a2,0xf6c40198,0xfe220314,
0xfe05fa1c,0x10f9fde7,0x1319e116,0xf94e095e,0x1791f0c3,0x018c0196,0x22fcf1e9,0x073add69,
0xfb0b1bdd,0xe6f717a4,0x01350931,0xfe7e0280,0xfabef8d6,0x01c1fc50,0xffe9fa36,0x1336f73f,
0x00e7d9f9,0xef2f1086,0x03a1f63f,0x17e3f75a,0x329adbab,0x1c2fe43b,0x0770f35b,0x039afcc7,
0x031902a5,0x0589f5a9,0xe2a01888,0xfa6919fd,0x193ce8da,0x0b70ec2b,0xd7b41505,0xf08a1571,
0x03d7088b,0x0c82f105,0xfe6dfa02,0xfb56013a,0xf8cc0da3,0x10f3fc97,0x0471fa0c,0xfea7f5cb,
0x020af4b6,0xf5f40eba,0x33c7ea84,0x1542cdb3,0x0d7ff7a1,0xe9b9f8be,0xff6b191e,0x113cf045,
0xeab5104c,0xe4d315bf,0xf970242d,0x09bef48d,0x0538ec7c,0x02e9f897,0xf71d0407,0xf9080f5a,
0x0ee9f256,0xfd10f7d9,0x10a2ee10,0xef1c0608,0x00f81067,0x0a81f5c5,0x08130a9e,0x07cbfb9d,
0x1f0fe2ed,0xf8f3f52f,0xed8b0a4b,0xf32c0d20,0xf83a13a4,0x079bf3c8,0x02a3f466,0xf819ff37,
0xd7cf10a3,0xfaf41f7e,0x0a28fdad,0x04d5ecf6,0x0bf50288,0xffa8f878,0x0db6f554,0x0cacf253,
0xf47f0118,0xe9941252,0x03730f10,0xfce40343,0x199cf8ba,0x2bd9d5d7,0x11e3eef0,0x094ff1b8,
0xfcbb0690,0x0e7df535,0xee8a023d,0xdb9b2616,0x06b002d4,0x1bd4e893,0x13eaddd4,0xf94bfa40,
0x07e6f78c,0x0c73ec4d,0xf096016c,0xdea71df2,0x035a102e,0x1099eae6,0x03a5fea9,0x0901f764,
0xf33a0527,0xed900f94,0xe93c184d,0xf12b16c6,0xf0ef1339,0xf9e90a7c,0xef0a1389,0x18c7fd87,
0xffc2f93f,0xeedb0900,0xec0d2050,0x0690ff2f,0xfeddfefd,0xed820150,0xff2e0393,0xfe84f8ce,
0xffbffe10,0x03f1edd4,0xe75705be,0xf92a0803,0x05a3012b,0x105ff056,0x1611fffd,0x0f6aeaa4,
0xf848fb10,0xfba206e3,0xf7ee0993,0xf821102d,0x0de9fd13,0x0fbefdc8,0x19f2e69d,0xfd7fe832,
0x09b7076f,0x2157ddef,0x1c4fe856,0x127ef3ac,0x0655ef19,0xfa63fee4,0xf45f0e9a,0x0e86f6b7,
0xffa5f32c,0xf10c167d,0xef6c0366,0x066e0423,0x04c2fa32,0x0c59e9f9,0xf206fe19,0x003d16fb,
0x0c85f35d,0xfbc2001a,0xef2e0c9a,0xfdcc0319,0xfa800147,0x0e4af7b0,0x0716f26a,0x0b8bf0d0,
0xf5900310,0xf212093a,0xed80174c,0x0304096c,0x0125fd61,0x064c021d,0xf38e0dc7,0xfb0c11e1,
0x0101fcc0,0x06120239,0x01bff71b,0x04f3f67d,0xf73dfd05,0xe79a11ca,0x0ca809d6,0x1879ddfd,
0x074dee7a,0xf54607a2,0x03fd04e5,0x05330724,0x04e1fc1b,0x0288f471,0xfa92f93c,0xf91a0347,
0xf04d0226,0xf7d61805,0x0337f6eb,0xf045ff31,0x034d15f5,0x0b4ef7f1,0x0f7ee1dd,0x01bc1139,
0xf1ebfe8e,0x0f7bff92,0x0819f7c2,0xe7880746,0x08fa16c9,0x1ab4eb99,0xf72af33f,0xf91d021c,
0xf3b5112b,0x0f53fa2d,0x0f30edb9,0xe2a10cff,0x00000b29,0x03dbfbb1,0xfa21feda,0x0af9fe8d,
0x03a8ecd5,0x07fefdf3,0xff83f6cf,0x091fef28,0x28a6e6c1,0xfe57e659,0xfdfb0b5d,0xfcce1078,
0x1422f60c,0x04f0f2c8,0x0e3bf727,0x0bc4f7bb,0x03b5ebb1,0x003d0b2f,0xecb408a1,0xf5720f28,
0xf0851907,0xd9ca1af5,0x042e0715,0xfb7b0e7d,0x04bdf4b9,0xfa2d000d,0x0a4206d9,0x138df333,
0x1155e48e,0x07d0f6a8,0xf696f986,0xf55404d9,0xf0e20ff5,0xebac0654,0x15dcfeb8,0x14d2d7c0,
0xedd2f9dc,0xf1df1e5d,0x05ddffbe,0xf1c514f3,0x0449ffcc,0x1227ff33,0x045efabc,0x0428f242,
0xf5d215da,0xff8d11e5,0x1315f6f9,0x0867f28d,0xf79107d9,0x038efa39,0x2abee818,0xfaa1e33a,
0x0e14ed80,0x01e00143,0xe2b306a9,0xf6c003ae,0xf38410fb,0x0437f95c,0x1647e7ef,0xfdcf0d60,
0x0306f3f7,0x02270005,0xfcdf0813,0xea37106b,0x046d0a1f,0x07170a3d,0x075efabe,0x02610616,
0xfabbfc2e,0xfda4f4a5,0xf168089c,0xfb370e5c,0x1fb4e483,0xf14bffac,0xf5a60f9d,0xfc75046d,
0xf0effe4b,0x00b908aa,0x0d70f4af,0xfd5bf5a6,0xefea123d,0x0e9500fd,0xfcaef8c1,0x0f55febf,
0x1738ee8c,0xfae7f7a4,0x0bf504cc,0xe9a8fceb,0xf52e1770,0x11f4fe1f,0x0d81eae6,0x00c5ff97,
0xfa8a0414,0xffa2025e,0xf0820012,0xeb090eb0,0xe41e115f,0x035d059e,0x0d97f2c7,0x004afa28,
0xf038091a,0xfd451462,0x0ba8faf4,0xfb5b00b0,0xfbd50549,0x1190f415,0x079e00dc,0x12f3eaf1,
0x0d3bf42c,0x124d002a,0x0e26eb59,0xef4010d8,0x05ec0118,0xfe5af45e,0xecae0c83,0x1878f813,
0xfe85ec4c,0x036f00b4,0xf725fcc9,0xfc26fe52,0x12edfae1,0x0874dc8f,0x0261048f,0x0270ecf0,
0x04b1fda2,0xf88cfa39,0x073805ff,0x0364024e,0x12d404c7,0x131ef7b4,0x08ccfa12,0x1421ffff,
0x0910f0e6,0x0ecbef4c,0x05dffbf4,0xfe2bfb9f,0xf84a06a3,0xd77d17d2,0xeb8027cb,0xf89002bb,
0xfa36f6ba,0xfdaef961,0x0472fd9b,0xf92cf9f3,0xf5b609e6,0xec1b0984,0xf9890d8d,0x13fceb83,
0xf7cff2fb,0xf5ba1460,0x0516084e,0x023001bb,0x0b2af2bc,0x1831f7b4,0x07adeff5,0x02f10b07,
0xf90b1200,0x0711090c,0xfe00f50c,0x098afa2a,0xf75ff99b,0xf4bffdd9,0x0bf01757,0x0aa5e0dc,
0x069afbb0,0xf8c60045,0xf8f9fc47,0x150cf3cc,0xfb27f397,0xf0850bce,0xf4af0f63,0x06f40326,
0xec780315,0x0f28f938,0xfc6a04fb,0xf29ffc50,0x17260482,0xffb9eaab,0xfa060df5,0x013e04bf,
0x15a0f292,0xfa9e01be,0xf9ef13be,0x0cb602a3,0x061bf740,0x1319e843,0xeb240416,0xea620db2,
0xf2430997,0x0ad6fe57,0x0d20ef1e,0xeb0c02e9,0xf25315a8,0xf96b0a68,0xfa98fbfa,0xf9fc09f7,
0xf94e0568,0x0755fdf7,0xedbe0d57,0xef5f12cc,0xf89a1337,0xf6e608c0,0x1a9dfda8,0x1bade453,
0x0ad2ec34,0xfe83f11c,0xf0bd0610,0xfcdb0e23,0xfbe3f4db,0xe9531858,0xe8f91ed5,0x2b1bed4c,
0x0786d8cb,0xe48b029f,0xfec72140,0xf977fb93,0x14b8f8c7,0x0ea4ee68,0xf25b05ad,0xefc71df2,
0x0aac04c2,0x0995ff39,0xf9d80056,0x01ba003c,0xff99f120,0x22cbefcc,0x2821df17,0x2ddad099,
0x0fffe508,0xfbc9f327,0xf1430402,0xe2f71295,0xf89a0ec8,0x0e78fe16,0x1a6fec4b,0x0093eefc,
0xfabf0584,0xff3c0155,0xf9ea01a2,0x1bdd0b73,0x00ade220,0xec010498,0x0f160c5f,0x1126e345,
0x0a2ced7a,0x11620485,0xed14f94c,0xf48a2511,0x0c0cff5b,0xf252eae7,0xe83e23db,0xf8a009fe,
0x06fff3c4,0x0e6cf9a0,0x15d4f080,0x0042f046,0xe8450975,0xe5711bc1,0x02440397,0x0ba8ffd6,
0xfdcafbce,0xf64704fb,0xe8bc16b0,0xfd09131c,0x0ae6f5b2,0x02eefa86,0x0643ff68,0xffb902ce,
0x0a4bfa20,0xe6feff4c,0xee591077,0xfbcb037d,0xea420fdc,0xdc561c8a,0x02411205,0x0d74fcdb,
0x0520e66a,0xfe2bf61f,0xe4d10e89,0x0dc313c0,0x12e9ea80,0x02a5064b,0xf371012d,0x04321545,
0x03250361,0x2583e69d,0x1073ec4c,0xd9d50c96,0xf1dd1db8,0x08dbf8f6,0x09b4eab0,0xf510faa2,
0xea891075,0xe9c81b0d,0x126bf2bc,0x05cdf576,0x0007f970,0x160cef9d,0x07feec84,0xf02d047b,
0xe8912047,0x005f12df,0x0e34f040,0xf3a00304,0x0960071d,0xf8bffca4,0x011f078d,0x1008fd78,
0x1461f542,0x136feee4,0x0099ee11,0xf296148e,0x1873ff1a,0xee6ae6eb,0xbffe2c88,0xefee29e5,
0x22aedf2a,0x0484ea3e,0xfdfef806,0x098e00b9,0x1306f72a,0x1285e99c,0x1150f041,0xfd73f0e8,
0xf1781244,0xf5cb1081,0x05f707fa,0x1056f3b8,0x1620f466,0xfb1cf98f,0xf7890409,0xf7670a2e,
0x0791fbb1,0x06560597,0x02c6f8ce,0x1016f3e8,0xf2a8fff9,0xf8a4102c,0x0a770111,0x0766f63c,
0x0a9cf663,0xf76ef015,0xe94405c0,0xf7210f98,0x15b5ee5c,0xff94f9e4,0xf1a50e2d,0xf2470aea,
0xfce801e5,0x1497f405,0x103be911,0xeafe0e41,0x0bc91315,0x0e32ef78,0xf6e100bb,0xf24f1727,
0x0478fd76,0x092304cd,0x193af7a9,0x2842d391,0xfc29e81e,0xfebdfd17,0xf53c06c1,0xf0c0125a,
0xfc861193,0x1249f4e1,0x05b2ebc0,0x03a0ee4e,0xfed2ef20,0x07cbfd8c,0xeb600301,0xf61d1064,
0x084a0a99,0x0eecef5d,0xe86b0a85,0xf42e162b,0xf87f0fb8,0xf77408f3,0xf62e0eb2,0xff6203ed,
0x0f06faff,0x0073f5c9,0xd6d817bd,0xefa62054,0x094b034c,0x0910ebf5,0xfb2001a7,0xfa7f0639,
0xf055ffe6,0xfd190d0c,0x174bfbe6,0x1095df7f,0xe6fe0954,0xde8d1f6c,0xf72507f7,0x02bff8de,
0x0279ff38,0xff7d03ee,0xf7ca0fb9,0xf69a0b90,0xf98609c8,0x2537ee6d,0x1202e2e8,0xdd1912b8,
0x094415e4,0x1343eea1,0xf826ec0a,0xf540fbfc,0xf71b17d8,0x0b11fee5,0x1a92f087,0x13bee062,
0xfedaf3ac,0xfe10fca8,0xf04a0efc,0xfbfa093b,0x1c420538,0x19dce03c,0xe7b7f650,0xe9e620dc,
0x06fd0179,0x0eeef206,0x0de2f30e,0xf4e4ff53,0xecfb0bb5,0x02301248,0xff36f72d,0xfca5ffd4,
0xfb370747,0xee9c0b90,0xe41e1743,0xd9051765,0xfd690c7d,0x03aefab1,0xf3f808e8,0x12f7f5be,
0xf3e402a5,0xfb11105a,0xfc6708b6,0x0667ffd4,0x0e2af444,0x0af50303,0x07cff70f,0xfb86fc8c,
0xfaab0d7e,0x04530216,0x0625f67b,0x1501ea95,0x1a61e273,0x06f5e6e1,0xfc0d04ed,0x0362f8be,
0xefd60236,0xf5811639,0x0fa5fd52,0x0d03f1e6,0xfb930244,0x0bacec60,0xf25605f7,0xf69201e1,
0x080ef8de,0x1165fbab,0x0f72f8e3,0x1f71ea5f,0x0fdbe8dc,0x0607f2a4,0x1772f742,0xd79c09e6,
0xd756326f,0xfcd51c9a,0x01890242,0x0d72ed6a,0xf4eff7c0,0xfe0b08fa,0x13c2f2cf,0xf867ffcf,
0xe0e10d20,0xf3051cac,0xfccc0046,0x07c2fccb,0x0937f6b6,0xf3bc054b,0xe8e810c0,0xe0c018d6,
0xf1750f4b,0x176eebd3,0x1795e26a,0xf6f7fe44,0xef0b1370,0xebef1ac7,0xfd950b2e,0x0a1a0a0e,
0xf376005f,0xf75a1690,0x09f40b5f,0x1234ee0e,0x0b58ea4f,0x04b1f1f1,0xf27500d8,0xf4fd12e4,
0xfb9b0510,0x0285f8ed,0x1a68f1d9,0xed75f185,0xe2701629,0xf76120ac,0x0941fa02,0xf8c8fce3,
0xe61b1dcc,0xf6dc094f,0xfdcafbc9,0x2134f440,0x064dd1e7,0xf2ff11d2,0xf4880e22,0xf8c10d4d,
0x0dc501c6,0x125bfcd8,0x0ae5ee2b,0xfa8dfd73,0x08b3083e,0x1f30e78b,0x1454e0ac,0xfe81f728,
0xf5450617,0xec5d0e32,0x06360ed6,0x1936f309,0x0bece688,0x025b037f,0x073ff1d4,0xfedaf8b7,
0xf63a029f,0x040e1044,0x13cdf28b,0x1ba7e72c,0x182bdd95,0xff97e67d,0x027dfcb4,0xe98506ea,
0x0686fd2f,0xf6721081,0x0637fc65,0x09c3ef46,0xf2e2184d,0xf9f41561,0x09f8057c,0xfccbf286,
0xe3fd0853,0xf1ee225f,0xf27908b4,0x05160858,0x16d2f032,0xf8d4030a,0xf0430c8f,0xfe7904a6,
0x0ea0f516,0xff37fcdd,0xf78b0a5c,0xf0f4feff,0xff8d03ca,0x0d91f778,0x0461f313,0x044df783,
0xf059f37e,0xdec71e9a,0x03150e69,0x1be0ed65,0xff14e781,0x02bc0fa2,0x05d30c24,0x155ef37e,
0x027ef90c,0xfc130680,0x0812043a,0xf55af977,0x185bf3bd,0x0beaef0a,0x129ff098,0x0778f843,
0xf10a0d81,0xf1ac0b16,0xf6f514a1,0xfb02f63f,0xf357048d,0xf7de1135,0x03a5fbd9,0xffe2f38e,
0xf8f8ff8f,0xf663043c,0x0d9af5b5,0xfcd5fff3,0x078bf92c,0xf4f003bd,0xf9310e31,0xecfa119a,
0x06ae1239,0x0796ff36,0x03900203,0x11d0fb54,0xecc9f8f7,0xe2bc11e6,0xfdfe0532,0xed9508ed,
0xf6c4032d,0xffe40b0f,0xf7be09dc,0x10faffbe,0xed5d0310,0xf97a0aeb,0xfdef028d,0x02fb012b,
0x04f2fe1e,0x021cf843,0x0b5df8b7,0xfaf9fb8c,0x1d9ef722,0x047ee8bc,0xf1c20d74,0x099302b9,
0xfcfaf7a4,0xfd2101e5,0xe8bd0602,0x076b12dd,0x0e06feeb,0x02bff0ca,0x029900d4,0xf3dff883,
0xf8cbfceb,0xe18c0e1e,0xff8d0eb2,0x1d58eee8,0x0a58f83e,0xf02a04ba,0xef121667,0x106709c8,
0x0b03f73f,0x02cceffd,0xfb08095b,0x03710001,0xff53fb3c,0x0924f5e6,0x050df791,0xf4cffd82,
0xf3711b7f,0x07cb02af,0x1159eb3d,0x260ee136,0xff2cec84,0xee9e0c27,0xfab9144f,0xfe2bfd92,
0x0cd80162,0x189ce082,0x05f5e254,0xf081fc25,0x06a40b9a,0x201ce91a,0xfdb2ee18,0x085afef2,
0xf45d0ae0,0x10dc03da,0x0a8efbdf,0x0f74f1dd,0xf6bc0069,0xd6ed13b4,0xd7092ef9,0x10dd0882,
0x3014df9c,0xf925e919,0xe7a32062,0xfdcf0fd5,0x06d4f85d,0xf9a5fb68,0xf71709e0,0xeccc0a92,
0xeecb0e7e,0xf9370bde,0xf74300a0,0x0039f2e7,0xeb3f01ea,0xef670ac0,0x02220d60,0x00cdfe76,
0x07e6f851,0x136702d8,0xf39b04bc,0xf7b30da3,0xf9181a86,0x0516052f,0xfda4fee0,0x04e1fa4f,
0x0063f30e,0x0292faac,0x1133f97f,0x18dfe5f5,0xe8c1fc3f,0xf8b91ac8,0xe37e159c,0xfdb207e2,
0xfde9fff8,0xed1309f7,0xe93a1384,0xf08e12fe,0xfd8b096f,0x0935eded,0x100bee30,0xee15fc69,
0x04bc09ef,0x0e76f86f,0x0389fdae,0xf9acff38,0xfcd90a79,0x08df056c,0x0c38fb9f,0xfb3c0ba8,
0xfad6085a,0x0470f840,0xeb03008d,0xdfb612a8,0x073efe4e,0x0ba802d6,0xf244f7c6,0xf42011ac,
0xff4e0aee,0x03f4fcf8,0x01e3fc72,0xe8560f04,0x00850d27,0x0b0df94a,0x0566f63f,0x128bf111,
0x2dedd884,0x0498e77d,0xe01f10f9,0x07551029,0x0739f568,0x0f94f65f,0xf2f2ff2c,0x012e098a,
0x011cffd6,0x07f9048f,0x0f77f50b,0x0080f1c9,0xf59a006d,0xeda208f1,0x07aefd87,0x1919e769,
0x0bc0edd0,0x0a23ff44,0xfd23007f,0x0e9000d8,0x0dd5f361,0x01fbf5e3,0x10fe0e60,0x0b6ee450,
0xff0afd60,0x016e067d,0xff6cead1,0xfa20ff58,0xfccb0dc2,0xfb7c0025,0xf0800342,0xf6eb1011,
0x1856e51a,0xfe87f846,0xf5eb0e7f,0xfc340179,0x15c00358,0x067af3b9,0x022bec64,0xf3961115,
0x093bfbd2,0x180afc7d,0xf940eecd,0xff470580,0xef160954,0xf9e7186f,0xfbca0a9c,0xf06a08c3,
0x00ea1424,0x02acf5b7,0xfa08fa2d,0xe19d0cdd,0xee2d0e23,0x014f0b6d,0x12b1f502,0x06b5ec7c,
0xf40504d1,0x13eff665,0xfea9fcad,0xfa2bfd34,0xf1d30ef4,0xec691c9f,0x01720246,0xfdf90354,
0x0313fc58,0xf5d70209,0x01641095,0xfc8bfea1,0xf7b9f858,0xfeb11a27,0x001bf080,0xfeb305eb,
0x08dd0b1f,0xf15bf756,0x0e88092c,0xf9bbfe01,0xf7edfa36,0x0b5901d9,0x064fea6c,0x09e1f4c0,
0x0e5ef157,0x0173ff19,0x026bf9ca,0x023c054e,0xe5280a1b,0xf7610f63,0x0a9c055e,0xf0dc0536,
0x04b1080f,0x0c4df58c,0x0814f69e,0xfcf2017d,0x093bfe07,0x0927f239,0x07d7fb2e,0x0171f08e,
0xed1302f0,0xfd210806,0xfbd5ff94,0xfa730249,0xef161910,0x00c707f5,0x0073fdf7,0xe9b00c42,
0x1b1cfc5f,0x1971dc9c,0xfeebf637,0xf40811d4,0xf533132d,0xf89b0919,0xfea003d7,0xf72b0494,
0xf9aa09a5,0xe86b0bdd,0x01ab0bc5,0x162de896,0xfffdf361,0xf9e10061,0x1a03f31c,0x04e6f56f,
0xeabe0594,0xef921185,0xf7d509e4,0xf6990894,0x1165fba2,0xef440502,0x0bfd0a8e,0x218cef60,
0x0093f32c,0xfacc0625,0x095df70d,0xf437ff67,0x0450fcbd,0x172bebac,0xf5cdfc2e,0x13c8f7c3,
0x05b0f5a1,0xf66afc3b,0xfd79048a,0x18e3f2a5,0x1348eb04,0xf91dfe72,0x0c1dffdd,0x024ef032,
0xff5f0847,0xfda80525,0x0d9b05c9,0x09abf0ad,0x0e30f7ca,0x075af85d,0x0258ec70,0x09eaf630,
0x063e028b,0xfd7df804,0xf4be03a8,0xf9ee0915,0xe9ab006e,0xe83a1f30,0x03fd08f2,0xfbbcf565,
0x09020340,0x0a3703c7,0xfae1e9db,0xd7741efb,0xef451fcd,0xf45312b3,0x08e5045d,0xf643f832,
0x033200c5,0x0eabfcfb,0xed56004c,0xe88e1532,0xfc2f1a1a,0x0d2effcd,0x09a1e98e,0x07fbf244,
0xebbffed5,0xf54216cd,0xe9e019c4,0xf4880997,0xf9010497,0xee9612d3,0x06780148,0x0f07f0c8,
0x1c77ed9a,0x0454e863,0xe15712cf,0x0bf60fba,0xfdc2edcb,0x06ab0d0a,0x00e9fa7b,0xf36a0145,
0xf3a917ad,0x0a38f757,0xfb0cfb0c,0xf8c80315,0x02a8fe6f,0x0e2bf7bb,0x0ab3f976,0x064cf747,
0xffacf05a,0xea0f1093,0xf6bd12e2,0xfb9a0202,0x09b0fe58,0x06e5fe44,0xe9db1038,0x0a6902cb,
0x0c95fb93,0x08daf4df,0x0a03fd9f,0x007d03a0,0xfbd5f12c,0xfa620c15,0xea5d0392,0xf4d40cf0,
0xff5a02f1,0xf4ef0744,0x068702d3,0x0f66f2e8,0xfe1df5ef,0x0c7ef70e,0x0f61f261,0xfea0f8de,
0xfd9d0849,0x06fffec2,0xf933f674,0x0337feff,0x0137fd1e,0x0993f88e,0x1231fceb,0x19eaea89,
0x0189f5d7,0xf704ffb5,0x0ca909bd,0x0f0eec1b,0x05cffdb2,0xf7660462,0xf72a0ab1,0xfa4e14c8,
0x168be7ed,0x0250fc5d,0xeb5f0321,0x0cdafe48,0xf1f3fdfb,0xdab70dcc,0xf6881bac,0x0c8f0932,
0x1533d919,0x0e3efb2a,0xffc5f52d,0xf9dafb0e,0x087c07bd,0xf305fc2e,0x0564ef2d,0xf5ff0c42,
0xf3d11007,0x0b4afc20,0xf7f606e7,0x07bd0165,0x04070266,0x045b0dad,0xf9fcfc12,0x0c1b0160,
0x009a02c4,0x1624f643,0x1afadc74,0xfbe4fecd,0xf87bfcff,0xfebb0752,0x0572f8a9,0x0741ec81,
0x0086f93d,0xfeeef9da,0x05bef8b5,0xefc9fdc1,0xece7139f,0xf5d712e4,0xf5900995,0x0935faa8,
0x0842f5e7,0xf37602b8,0xe3e82421,0xfbcf104a,0xf8a40799,0x0c980e2d,0x0427f25c,0xf4b90cfa,
0xeee11d33,0xfbf409f4,0x0af5f79e,0xf86cfbe7,0x1dfbe2b4,0xfc48faef,0xfd2df98f,0xf633f65f,
0xf21218e3,0x04e8fdb2,0xf0c4fc19,0xfea518e8,0x09eaf49c,0x20d4e8be,0x11d4ec42,0xea7dfe06,
0x042d072c,0x098dfbea,0xec56fe18,0x07e908cc,0x11d7f63f,0x0f72ec20,0xfc4701fb,0xf4e011c8,
0x165ff4bd,0x1038f40f,0x030b015e,0x086bf397,0xf52a069e,0xfb7608b3,0x02f1fa63,0xf6acfe71,
0xebf90a2c,0xf26009c4,0x0e670241,0x2572d80b,0x0609f003,0xf6a40138,0x0163055f,0xf93c0865,
0xfac103d2,0x01e709e8,0x0508fb5e,0xe7f3005f,0xf3a018cf,0xedf606d3,0xf5dd08ab,0x0d750c94,
0x05ddeda2,0xfa9a056c,0xfccf0deb,0x0d9efc14,0x06e1f459,0xfaff0a54,0xf5630296,0xfc500d73,
0x102df9d6,0x1471d819,0xed4802e9,0xfa780853,0x1838efe4,0x14ebec94,0xf9bbf7d6,0xfd5b09fb,
0x09bf002d,0x0520f1e7,0x0faffba5,0x0978f18f,0xf441039c,0xfe200856,0xf8c6ff12,0x0c21fd0d,
0x10ecef7b,0x0485f282,0x011f0224,0x0422fdf1,0x079bfe53,0x0a6ff7d4,0xff77f7e8,0xf9d702eb,
0xe8fb200c,0xf0010b16,0xfff80a27,0x012bf87e,0xfa210012,0x08d3fae5,0x03f8f011,0xffb0f7d1,
0xfdaa0d0f,0xf5ab077e,0xf7e90a22,0x01400efd,0x04fe0000,0xf82b046b,0xf57709db,0xed9f0e2c,
0x0a50f993,0x0594f832,0xfda4f787,0x15b4e830,0xef6200ca,0xe4a61705,0x0ab4080a,0xfeedf968,
0x06c0fb77,0x040c0007,0xf39b08fb,0xf6780aac,0x03050e15,0x141af12f,0x0881f1f8,0x00ba03a5,
0xfc170566,0xfdfc0214,0x020f0199,0xf5cffac5,0xf9dc13cc,0x0cc1f629,0xf641ff85,0xf37e0a8d,
0x07a50246,0xfedfe814,0xedae0211,0xeb2e1488,0xfb0c08f0,0x1484ee15,0xfd18fa28,0xfb850540,
0x05800585,0x00290764,0x152cfcf7,0x0ce7f67d,0x16f1f4fa,0xf08b01c5,0xf60709bf,0x071a0113,
0x04d5f4d6,0xff7bf71b,0xe5111716,0x0d9b07ed,0x1046e102,0xff1cfc70,0x0ca5f769,0x0073ebd7,
0xf52a11f0,0xeb781326,0x0954ff17,0x14c9ec75,0x028bed0a,0x0094fe52,0xf6ce04fe,0xfc8a0a46,
0x006c071f,0xfcd50274,0x20bcf6bc,0x1c81d594,0x03f401d3,0xf1fe0853,0xfcce0ede,0xe66814be,
0xef7210c4,0x2263efee,0x0ac0d96c,0xffd700e1,0x04e1f50b,0xfe9dfde8,0xffc20059,0x154bf247,
0x01c8f0ea,0xea1715bb,0x07f70bcd,0x1288f30c,0x0e43eb24,0x053ff3d5,0xf983fcce,0xe9f81089,
0xf8521125,0x20f9f7de,0x017ce810,0x01ddffb2,0x053604b4,0xf98f0306,0x01d7fbda,0xea7716eb,
0xdd961be7,0x00b218b2,0x0555f9d5,0x0264eb8a,0xf3c60b2d,0x025708b4,0x0407e04d,0x04a60186,
0x0ae6fd4a,0x101ce524,0x0919f6e7,0xf826073c,0xec080f15,0xf37017fc,0xfb020e26,0xfc2efbd8,
0x08f20126,0x036002aa,0x014df38e,0x1575f88c,0x0bacebae,0xf87affbe,0xfbf20e4d,0xfb2efbcb,
0xf7060d25,0xf4e00e26,0xfcb806a2,0xf889fa1e,0xef840a50,0xeb821516,0xf9a509c9,0x0773feb1,
0x0dc5f4e2,0x07ccf2ff,0x05d8f7fa,0xfc7cfda2,0xfcbe0c7e,0x0ccb0594,0xfd1df43b,0xf641099f,
0xfff50faf,0x0069f372,0xff2dfe06,0xff2d0468,0xfbdcff4a,0x104ffa1e,0xfcc2f230,0xed3f0a6b,
0x069a04a5,0xf6bf05a5,0xf7ae06b6,0xfe48060e,0xfeeb0558,0x0554f2c0,0xfdfef9f3,0xe3740ce6,
0xea6e108a,0x06021fb9,0xfca1ffc7,0x0cb5f374,0x18dbfa21,0xf6f5f647,0x0ff90936,0x0ee5f7db,
0xe95002b7,0xe860258b,0x13f2ff9c,0x09fde0dd,0x00f1f8d4,0xfec20222,0xfef8f2fb,0x0460faa1,
0xffa2edf2,0xf874fde0,0x04eefae8,0x16c9eced,0x0b0cf6e8,0x0275f5cd,0xf38d030e,0xeadb15cd,
0xfa87138c,0x0ca5f876,0x0ccdfbbc,0x14c8f9da,0x18a1ed48,0x00bf0283,0xf3d31040,0x104205b6,
0x10d1f6af,0x055af362,0xfc720b55,0x0185f582,0x01e8ef69,0xf4630cd5,0xebaefee8,0xf8730331,
0xfd9cf617,0x085af292,0x0ac8f0f4,0xf007fe05,0xfa4e049a,0xfd06033f,0xf9381008,0xfdc1fcff,
0x00640a54,0xf85204f3,0x01180550,0x00dd08fb,0xf897000d,0xfdcf110d,0x1187fef2,0x07b8f4b8,
0xfb5f0f44,0x130df4a5,0x144ff742,0x0668f770,0xebb10d0a,0xe7951441,0xfffbfe66,0xf9b302df,
0x064ff970,0xf9aaf734,0xfe41f562,0x05fefbf2,0x03a5e6bb,0x043cfe5c,0xff020749,0x0c76f332,
0x093bfca8,0xfb80ff59,0xf22d0336,0xf102137a,0x05830a01,0x020ff9b4,0x05cd0637,0xf8d20331,
0x0367f4f7,0xf8890acb,0xfbfc10f6,0x143af09d,0xfd56fd83,0xeae71085,0x02da0757,0xf2f60643,
0xf2ee0e2f,0x0889fec2,0xf73bfce2,0x013a0261,0xeb7b04a6,0xf7bc0a99,0x0f76f172,0x027efd87,
0xf6040ee4,0xed820a85,0xe14323b2,0xf4951b47,0x00c9ff59,0xebc90a99,0x02f00022,0xf99d00c4,
0xfef9fc34,0xf89d075c,0x02b4f8fd,0x0e1cf40f,0xfc53f58c,0x04f5fe8f,0xf1a203c3,0x1608f700,
0x091ff30f,0xe7090e89,0x0f9813ee,0x1182ebd2,0x04d7fe48,0x136afb29,0xf5bff515,0xf2421433,
0x0ced049c,0xf6fbfc6a,0x0115063c,0x0b43f9fc,0xff7d02a5,0x1a4bf551,0x104ae09f,0x018cf0c4,
0xf916049f,0xfa99fa92,0xfcd5f9d1,0x05c5fc53,0x0125f8d9,0x0487f84d,0x06d3f15a,0xfff3fb24,
0xf93103e0,0xfd83036c,0xfa2f02e4,0x08d00a38,0x0799f6f6,0xf96b0b25,0xfa70127e,0x00ba0135,
0xfcf00700,0xf8261ad3,0x0db1f8d6,0x1f16e2ec,0xf985f58f,0x0319fef0,0x015f01ab,0x0638f393,
0x0266fa3b,0xf234053a,0xedcb0597,0xef0b0369,0xfdb30ac3,0xf8f1ffee,0x085cfb63,0xfc4bfdcc,
0xf4140320,0x0c430f20,0x0b58f2ed,0x1ae7e9fc,0x0190fc50,0x0286fbf7,0x0a5cf945,0xf90f0014,
0xef8a1dbc,0x03d6f9fd,0xf7250a53,0xf5560fe5,0x1485eea2,0x00d4f972,0xff5bfb1a,0xfa85fe92,
0xf3870b56,0xf523057c,0xf2cf06fe,0xefb91c7d,0x08e2fc61,0x04f9f823,0x03fd0020,0xf24f078c,
0x005b0b2a,0xfc6d0bfb,0x0189fa89,0x10eef654,0xfb94fa70,0x08c601a2,0x16c3e559,0xed4ef852,
0xea100ea4,0xe4e5126f,0x09f90278,0x0a19f5a9,0x0beaf3df,0x0abffeb4,0xfd9af9c7,0x0aef003e,
0x13c5f45d,0xfbf4fc9e,0xeddf190b,0x0cc60953,0x0594f18f,0xf12ffae1,0xfa121769,0x0467fc4b,
0xf23403f1,0x01590883,0xfe27f4b9,0x01ef066c,0x0967f365,0xf992fd49,0xe94e1461,0xe74d1831,
0xffac01a4,0xffa101ba,0x023df745,0x086bf306,0xfaef03a6,0x0fe1f520,0x1f80de30,0xfc04fd19,
0x0209009d,0x0a3d017d,0xf20606fb,0x0eabfc2a,0x04fe08a8,0xfe4e044e,0x0d64fa92,0xfd63ffc4,
0xfce70400,0x02340397,0xfc19fc87,0x0b5ef9f0,0x092fefcc,0xf788f83a,0xf52e0636,0xfa5f02e2,
0xf9150571,0x0c93f67e,0xfb77fe4d,0xf9eefb04,0x0ed6ff14,0x0044f7db,0x0abff88e,0x0051ff6d,
0xfcd9fe24,0xf3c70c41,0xf93815eb,0xff80082b,0x1092f370,0x073d02ae,0xe9690d16,0xff7b0982,
0x0b20fe66,0xfe00f5e0,0x0b8afc52,0xfcd5fa24,0xfa9cff67,0xfa7a05e5,0xf604046b,0xfb04ff25,
0x01b1fd45,0x0339fed2,0x0993f61b,0x0d2aeff3,0xffc9f8f1,0xf804071d,0xfe94006c,0xea0f1154,
0x00ac0a42,0x0f02f9b5,0xf6ebfac8,0xfa8f0ec8,0x012501e1,0x05540162,0x01350429,0x0c21f9bb,
0xef660a77,0x073c04d6,0x05eef3fe,0xf1f0ffac,0x001609a4,0x0669f7c5,0x0e96fd5e,0x00d9ee91,
0xf616fae1,0xeb331419,0xeda208f6,0x044d09a1,0xfcd400be,0xf278011a,0xfe660ef4,0xf45f039c,
0x07f4ffa2,0x0a20f436,0xfec70819,0xfd48fa17,0x06b70c48,0xff83fea5,0x0682f4a6,0x000d0c80,
0x0c09f8ed,0x0cc8f61d,0xf12e0b4f,0xfdcd0992,0x0b42f1c4,0xed79f8bc,0xefc204b7,0xfcd40b70,
0xfea0020f,0x0358f709,0xff4cfdc4,0x0b64f95a,0x00c0fc27,0xfed0069f,0xf6b1033b,0x04f709f9,
0xff5bfe09,0xfc16fd6e,0x090f0c50,0x12e8eba7,0x0d35f65c,0x0a06f54f,0x055cedbc,0x0058fde0,
0xff53fcb9,0xf9b4013d,0x029b05fc,0x05bafe03,0xfd2a0182,0xefc00fd2,0xfd83109d,0x056cf0f7,
0x0067fcd5,0x0297f45f,0x0ed2f801,0x10f5eef3,0xf431fc5a,0xfd220b1c,0xfff1fd86,0xefba0d75,
0xeeb61689,0x0ed20134,0x1028e3ba,0x1461f19e,0x0fb1efef,0x066aefb9,0xfb1d054c,0xf3ae0f33,
0xfa7a0a10,0x0850f256,0xffdef7b9,0xf593064f,0xff0a0783,0x009e07e4,0x04d2fb80,0xfbb301e0,
0x043b098e,0x1682f2e5,0x0061f057,0xfc77002f,0xeda402e1,0xf3180f3c,0xffeb04b8,0xf2ab020e,
0x080a0a85,0x12c2fb93,0xfef7f4f9,0xfabcfd27,0xf5350b87,0xfe84ff2c,0x071d0184,0xe97b05d8,
0xff5f1749,0x10c5ecd1,0xfba705b8,0x0461f8bd,0x0ee9e75d,0xef67038e,0xf33c0612,0xf75a1777,
0xff7a00d9,0x0429f720,0x09e40155,0xffd301ba,0xf40f07e9,0xf9bd0a06,0xf1ac06fb,0x00000ae2,
0x0c1df884,0x0602ee6b,0x04afff24,0xf7c3095b,0xf03d051b,0x1231090b,0xfc92e795,0xee9c0ea8,
0x05460aea,0x0853f670,0x000dfe65,0xfdf7024e,0xe3cd0efd,0xff5619ac,0xfb41fb4d,0xf2ca0735,
0x1064f79a,0x0b64ebeb,0xfff3ff53,0xf94efaf4,0xeb900ddd,0x01fb06bb,0x08eeffb4,0x14d0ea3c,
0x00acfa9c,0x0afa0340,0x141aec60,0x0174fafe,0xfed702ce,0x0d1c02d3,0x0d29fa3b,0x04570025,
0x0857f59f,0xf337fa92,0xf09d08b7,0x0aa6fba0,0xfc1bf986,0xf7ddfb96,0xfb980e13,0xff67fb1f,
0x0606f5d2,0x02a8fd4d,0x0003f781,0xf4e506fd,0xf19a1383,0x03060817,0x09d5fb6c,0x1094fbc2,
0x0715f3fb,0x0a2c0219,0x11aef5cd,0x03dbedbd,0xe8bd102f,0xe7261b06,0x03490269,0xe4c20e98,
0xf4101923,0x035a02fa,0x0c99fb42,0x0915eb89,0xf09d05e9,0x01e30489,0x041af2e8,0xfc040275,
0x007dff28,0xfc690308,0x0664f659,0x0580fe13,0x081cf501,0xea4809d1,0xfbb00ab5,0x001e04f8,
0xf970fe1d,0x159efab1,0x12f7efec,0x014bf10c,0xff270881,0x04520349,0x0ab9ed73,0xfac900b5,
0x0957022e,0x0a3bf788,0x0e7eedd1,0xf9d20a8e,0xfb60002f,0x096b0b81,0xfeb0f2c3,0xee6b0ab1,
0x0d1803ae,0x058bf47a,0xee61ffe9,0xf8c1142b,0x0b04f7e8,0xf434f5a7,0xea621699,0xfc0c06b7,
0x063c000d,0x07defbca,0x0493f270,0x1cdee857,0xefcffc56,0xfcb91081,0x0750fa12,0xee7c0493,
0x04680654,0x00fdf3fd,0x0e21fae6,0xfdd2fb82,0xf5ab0689,0xf64117cc,0x1731ff94,0x1a99e966,
0x0b02f374,0xfc22fd90,0xfbb006f6,0x01ed01de,0xe96c0253,0xd2322320,0xf46b2222,0xf1fa051a,
0xfe68ff41,0xfdf70db4,0x0770ef6e,0x0f3bf61a,0xeed6f848,0xe0bc15d8,0x05df0cd2,0x0343fd15,
0x0a89f72d,0x020efc65,0xfbc60755,0xf47bf72a,0x029010f9,0x0738ef70,0x03f8f31c,0xf361118f,
0x04d90796,0x1588f492,0x0626ffbb,0x0c1af758,0xeb4b0967,0xfc8b154b,0x1827f54b,0xfff1f974,
0x0bf3eb93,0xff62f555,0x0cdeffce,0xffc9eb6f,0xe12e19ee,0xf5db14b4,0x0402ff28,0x04d2f71b,
0xf79cf733,0x09000115,0x2489e91a,0xf637f379,0xf4ea0aed,0xfbcd0664,0x060efbba,0x1033f827,
0x029ef273,0xfeefff93,0xf89f04e5,0xf3d510a5,0xf2b2092f,0xf1f6137d,0x11b80bbc,0x2416e74d,
0x087ae9e9,0xe2600a44,0xe5d81c79,0xfbf607e3,0xf65a04c9,0xf569065a,0x04b005fa,0x135df1f0,
0x0152ee6d,0xf5db07ae,0x0b9001c6,0xf581ff1e,0x03c80d7d,0x109ef2f8,0x06c0edcb,0xfbc90143,
0x03a6fd39,0x03ccf69f,0xf4f30ba8,0xff4ff9c5,0xf0ae0e01,0x020901f2,0x0f5ef98a,0x1484e337,
0x0593f76f,0xfe6a0704,0x0d5fefdb,0xf7ec04e3,0xf9be03f8,0x045e012a,0x0a10f76a,0x01f200ad,
0xfe41014d,0x04d2091a,0x1187f59f,0x1608e700,0x1d36ef0f,0x0005f1ce,0xfa2b0134,0xf3c4125e,
0xf70b09f4,0xfd54fb16,0xe13d13b2,0xf9be1064,0xf892ffbe,0x06a2fd19,0xec61fac1,0xfb960926,
0x06c3fb87,0x011bf6ed,0x02df0584,0x0d50f9ed,0xfe4df814,0xf06c13da,0xf34e0c87,0x04c8fdd2,
0xea7d100b,0xfbeb0ed0,0xfb021327,0x0806f296,0x0f18fd9a,0x010ef79e,0xf9a0097a,0x05f0fd9f,
0xff0dfb8f,0xe7600f96,0x01230b47,0x0d6ff1dd,0xeff9fc14,0x0288120c,0x052c00a2,0x1422e968,
0x1b11e534,0xffcce073,0xe20012e7,0x095b075f,0xfbd7fb59,0xe7350a86,0xfa891adf,0x0e76f87d,
0xff2cf9c7,0x01870093,0x02f3034f,0x0573fa39,0xe71c0b6e,0xf25b176f,0x0e76fe98,0x075fff90,
0x0e71fb4b,0x1295f011,0xff84f59d,0x073ffb2a,0xfd26ffe7,0x0c47f740,0xfaddf9ff,0xf4700697,
0xf7ca0cd2,0x0ae7f41a,0x0844f037,0xf6fefc86,0xf5f10836,0xfb74003b,0xe8260ed7,0x01bc161a,
0x1897edb2,0x05e9f8bc,0xfec00275,0x07cb0016,0xfba90482,0x05bff813,0xf07e0778,0xff4c13e3,
0x06baf532,0x06e3f5bc,0xff0802c2,0x1387f824,0x0314f708,0x04bef6ed,0xf997f97b,0x04800847,
0xf86cffa5,0xf3a20243,0xfad60bd8,0x0ebf0047,0x0af5de9b,0xe9f90a38,0xe7640cda,0x064a07a8,
0x05d302b6,0x0b95f546,0x08edff85,0x174dfa26,0x112bf445,0xfd13fa36,0xebf7137c,0x0b7dfe52,
0x0f18f01f,0xee10040c,0xf4d603be,0x08d60511,0x1e66e622,0x1c46e635,0xfd76f117,0xeccf0c03,
0x0a6808d1,0xfe14eca1,0xed510cc6,0xecad1410,0x08060da5,0x1814eb34,0x1099eeda,0x012beee4,
0x05d7fddf,0x029df6ce,0xe9f30638,0xfa8510fa,0xeee40d1d,0x0a330b11,0x18d1f166,0xf1a000a1,
0xf9740f67,0x0d8207c0,0x0b11e5a7,0x0480f9da,0xffb2f48a,0xfbff01f7,0xf2a30620,0xf9dd0b6c,
0x1e44f907,0xfd71efa8,0xf19e17bd,0x0795fa53,0x0b5df1fb,0x007ff9e1,0xf83705f5,0x011f027c,
0x0d84edaa,0xe6f2149a,0xef491068,0xff72040a,0xfa0bfe10,0xed7a1139,0xf61d09b8,0x026606ce,
0x0fdbea97,0x0e37f480,0x144ffa8b,0xfe1becce,0xfd780a58,0xf54f088d,0x02800718,0x0309f99e,
0x060ef725,0x19eaf55d,0x0ea6eefc,0xe5e309a5,0xf8171a4b,0x1d08f584,0x0f3ce1c9,0xee3a039c,
0xe975101b,0x02cc0685,0x0485fd5e,0xf322fd90,0x00770541,0x066903d0,0x016ff73e,0xf3e80870,
0xfac50930,0xfb47f964,0x07fc0448,0xfc51fd4d,0x066e0296,0x13dbf548,0xfd53ee70,0xe5f80f92,
0x05990349,0xf6690291,0x06f4fa08,0x02b803f8,0xf74e0b9f,0x0c63fbce,0x0b37fc1d,0xfb430047,
0x07730b92,0x06f1f032,0xe7560f29,0x056c0606,0x24efeab5,0xfca3e867,0xf374068b,0xf7e410fd,
0x0020fc11,0x0b2dfab9,0x1624e209,0x021bf322,0x0c94f253,0xfaee00c4,0xfa9f0261,0xedae0f1b,
0x0a96104c,0xfefaf33f,0xfd7800b4,0x03d0ffb5,0x0045f844,0x09f9fae6,0xfff90312,0xf7670489,
0x08210e9f,0x01da0118,0xfd74ff7b,0xf9d507c6,0xeb8a17b8,0xf9790e98,0x2033dea7,0xf51ff848,
0x0953fa0b,0x0064f937,0x03d0ffd6,0xffc7f6bf,0xf40a1117,0xfb44020e,0x0739fa9d,0x090eedf9,
0xf3a01357,0x1ac8f79e,0x1aa5e4a1,0xf979f25c,0xfc2501d0,0xfe0e04ee,0xff20f405,0x03b7ffe9,
0xf8afff6d,0xfe260b45,0xfbd7068f,0xfa6c0196,0x00f60ac7,0xf9330bb1,0x033404d5,0xf08a0bab,
0x05a807b3,0x01d4f24c,0xfc5b06f8,0x0046f38a,0xf6950538,0x13e9fa9e,0x099feefc,0x07daf186,
0xeca80cd3,0xdd5c18ff,0x02ee18c7,0xfd00038c,0xfb0907aa,0x0c86fc42,0x0744e575,0xdc720c44,
0xe36b1f8a,0xfd54052c,0x0076ffb7,0xf6e1fb0c,0xe59a19a9,0xf1f60d1b,0x08e410d9,0x2415e819,
0x1042e60e,0xf5970877,0x043106cb,0x0f80fc94,0x1be8e6e9,0x19bfe5d2,0xf784fc4e,0xf9a60a85,
0xef1103df,0x059409e4,0x19c8ec2f,0xeffdf4fd,0xff191059,0x256eedaa,0x1d56d944,0xff19f578,
0xfbb50266,0xfaddfb6d,0xfea404f5,0x05ddf1c2,0xeaadfe74,0xfa6c09fe,0x0888fbdc,0x01c3fba9,
0x08d1fee9,0x144bf509,0x186bf025,0xf0680078,0xe4272279,0x04960edf,0x0f11f928,0x1ba8eeba,
0xe9fa03a3,0xf336118b,0xf1e117bb,0x01d7fd17,0xfb2efe4f,0xfccb02c7,0xfc26fb4f,0x1ef6ef4a,
0x129ddacd,0xf45eef0b,0xf0bf0a11,0xf9ea0d82,0x0ccdf502,0x103df1a0,0x08a3eff0,0x1998e571,
0x0890efd1,0xee030c3e,0x0eef10c5,0x1df6ee27,0x045ef4c7,0x09800695,0x0641fb96,0x0ec5f314,
0x0407058b,0x04fbfa31,0xf846fbb0,0x0a490378,0xfed7eb50,0xed050b20,0x00b90917,0xfed6f3e4,
0xeabe026b,0xe83f1818,0x00e102ec,0x07a4f38d,0xf6b104af,0x10b1f415,0xf6da0049,0xf5430cf5,
0x046d08e5,0x04fc0256,0x01d5fc86,0x1393fc84,0x0694f4e4,0x082f0358,0x0a2af94c,0xfe3ffef8,
0xebeb0687,0xf0d3184e,0x1067f664,0x1016e6bb,0xfb33f6a7,0xf8270bc8,0x009cf844,0xfd6ffdb3,
0xefbe0708,0xf1c90e9a,0xf75f0ecd,0x11f1f21a,0xf5c1039c,0x02791027,0x12d5f563,0x2633e358,
0xfc1df4be,0xfd8e0c4c,0xf90f0629,0x10dd0167,0x091fe2b7,0xf3f705fa,0xe516138d,0x00620d19,
0x0c63fdd9,0x086fee5f,0xf89bfcc2,0xf41affb9,0xf3f40811,0x085dfb8c,0xdfe20429,0xfcdb1e2a,
0xff72f679,0xe9f2170d,0xf9db1519,0xfeaf04f4,0x01210f5c,0xf968051f,0xfb1b06d3,0x08a504d9,
0x22c1e3fe,0x0c26e7a8,0x057efd19,0x0129fe9e,0xe87a07a9,0xf2761baa,0x03cd019b,0x0032e927,
0xfc840985,0x0003f86d,0x1336f00b,0x05eaf0ba,0xf3edff05,0xf48b07cb,0xfb6e082a,0x01c90998,
0x06e6e7f7,0xf5e20b8b,0x0274fece,0x0687011c,0x198a020a,0x1244e16f,0x060405af,0xfde1099f,
0x118efdbc,0x141ee681,0xf3d0f929,0xef8f191a,0x07f90389,0x0f29f391,0x055aedc2,0x1830f957,
0x1b17dc94,0xf03df670,0x024e0922,0x0f2bec6e,0x00b2f66a,0xf72ffac1,0x0cf7f7ca,0x064bee7a,
0x075bf2c6,0xf9df095e,0x0205fbd5,0xf8520484,0x019a0b1b,0xf905fa6c,0xf89613de,0x00ca088d,
0x028d08af,0xfa800680,0xf93a1330,0xf0c00c2f,0x072106ed,0xf6ec03d7,0x06adff21,0x0b750094,
0x137de9fd,0xf890eaf9,0xf3c60756,0x02410012,0x0727f63a,0x08dfec58,0x0763fc2e,0x1511e24f,
0xfd1cf4d1,0xeebe0b31,0xf3b90843,0xf6761866,0xfb480b23,0xfab60bd3,0x14cdf3da,0x0645f910,
0x0ea8fabb,0xf4a10525,0xe9461bbe,0xf6ba08fd,0x0c6c05ef,0xfe8df555,0x1844f22a,0x133ee16e,
0x1042ec90,0x02ecf556,0x0b58f396,0xf887fe3d,0x039303d6,0x0b7af086,0xeff405f9,0xe9df1243,
0xf91b11e1,0x0bcdfd8c,0x0608f1c9,0xf2730492,0x134503e4,0x1367ed90,0x0db8f21d,0xeafb0f72,
0xfbbb085c,0xf595050d,0xf16e0cc8,0x0becf80e,0x00e9ff71,0x053af9ae,0xf3b0ffb6,0xee070f40,
0x0f16f84e,0xf301faa6,0xe751137f,0xf2e70e44,0x0d60fb51,0xee190fa9,0xfcf50c52,0x0e4304af,
0xffc5fea0,0x1d96f7a3,0xff8dfc8c,0xf3cdf9fc,0x01ea0a47,0x0269f4be,0xee960566,0xf1f20bd1,
0x07a402eb,0x0557f199,0xe8400651,0xe5e31efe,0x0b4cfbb5,0x1973e88d,0xfc2cf805,0xe2c11684,
0xf3d91703,0x0e18f96f,0x0e9cf3d9,0x0238f31e,0x00320508,0xf461106b,0x1e3af8bd,0x20a6e24d,
0x0aa5eb7c,0x056df515,0xf9e70fd3,0x0f40fc66,0xfe05f604,0xf7e90125,0xf180053a,0xee3a0875,
0x04680725,0xffc4f959,0x046dfa86,0xf77203ef,0x01f0fc49,0x015cfcdf,0x00360373,0x0f07ff07,
0x093bf53b,0x1466f93a,0x02c4f5ea,0xf22bfe3f,0xf0071b8e,0x13dbf6f7,0x07c7ec29,0xf23d08af,
0xf348106e,0x1ce8e9a5,0xfedff120,0xef220ef4,0xeb1317bd,0x04a50d21,0xf31afa81,0xf75c11ec,
0x058b0172,0x014df891,0x0776f95f,0x02b10015,0xf9b80b60,0x13e5f6ae,0x06ade84d,0x0b86fc2f,
0x0fbae75a,0x0bb0f0e6,0xfe05f835,0xefc201d0,0xf75713cd,0xf84afffb,0xfe000411,0x0afdfc57,
0x0a2afc12,0x072cfaea,0x05a70148,0xff08f979,0xf55d1081,0x155a007f,0x08f8f0c5,0x0705f8db,
0xe33c132c,0x0b0d0d65,0x17cbdd7d,0xf208f4d7,0xf1860da5,0x07b3fd3f,0xeca8fc7c,0x00f10e4a,
0x09c7f5e5,0xf475f62e,0xe72a18f3,0xfaf30daa,0x08e9fc5f,0x087cf9bd,0x063beee5,0xf9e2f86c,
0xfd3608e2,0x1636fa3c,0xf627fb7e,0xff4b10b9,0x013e0431,0x0f32ff5d,0x005dfa31,0x06a8035c,
0x0222fc0e,0xf9da0340,0x002efffe,0xe5010358,0xedcf10e2,0x03870d47,0xef51f2dd,0xe727106d,
0x05360a5f,0x14c1e5a2,0x0dfaf1ff,0xf81300c5,0xef840c41,0x1e58071f,0x1616ee8d,0xfea4f181,
0x078aff17,0x0638fb05,0x00bff6c9,0x14130005,0x0511ed93,0xfff0fc39,0xf90c0a1a,0xfb4d0c6d,
0x0b07f405,0x0083fb41,0xf054129d,0x051e09e5,0x07daecf5,0xee7c058d,0xffaa0772,0x1610ec88,
0xf251f5d9,0xffc0fd4c,0x1189f480,0x0a0ff055,0xecd402fc,0x101a0a1b,0x168ff1e3,0xffccf605,
0x02700205,0xf1220f5a,0x0b42fec7,0x1577e569,0xe64e02ed,0xeff91258,0x164ffd87,0xf97cf8f1,
0xf12407bf,0x0f520659,0x12e6ee54,0xea4bf9b3,0xef342528,0x0b2307c4,0x11d7ea54,0xf6770561,
0xf11410fa,0xf93afcb8,0xfff50662,0xfea90143,0xf9bef42c,0xf1990af8,0xf79501e6,0xf31f0910,
0x0d5307ed,0x03cbf6bd,0xf81c0437,0xfd83152e,0xf4e7fe83,0xfef9ff44,0xf8300808,0x01d5040c,
0x0819fd8b,0x0e1df957,0x1954e7f8,0xfae7f25b,0xf4401540,0xf9f00ac2,0x0a22f3f2,0x07f2f705,
0x038cfb5f,0xf740ff83,0x0dc0036b,0x0beaed88,0xebeb034a,0xfbf20f33,0xf0800817,0x07f4fd6e,
0x1aaef307,0x068fefc9,0x1296f45c,0xf8170145,0xf86c0f15,0x00f90094,0x08a3ff7a,0x18eee9e2,
0x0d40e0c0,0xf24d0764,0x0be5f71b,0xec23fed6,0xfa5a0aff,0xea3b04a0,0x027414a5,0x167aef46,
0x0482eedb,0x00aa05dc,0x1621f644,0xf57ff868,0xe5ec1e4f,0x09cc0b78,0x11f4f26e,0x00aaf800,
0x08e9fc9e,0x0533fa93,0x2226eb2e,0x019fe7d9,0xfd9f056e,0xf16b0d61,0xf7311006,0xf0850d75,
0xf54106c1,0xf3c1ff05,0xedd70d07,0xffb90cea,0x0cfcf63f,0xf85df1a9,0xed0417c7,0xf37b088b,
0x0407035f,0x076ef326,0xfe6ff9c7,0xf1e20fc3,0x0eeefb98,0xf900f15c,0x09d209f4,0x0df3ffff,
0x0c90efe6,0xe4f91358,0xff511664,0x0135f9eb,0xeebd0e73,0xeaf914c6,0x0a9915fa,0x1437f5b2,
0x01beedaa,0xe81c0af0,0x0c42ff3c,0x026feaf4,0xebc6ff9f,0x01460835,0x19c7db54,0xf29bf36c,
0xff6b08aa,0xf39d0235,0x13fa0286,0x1cede074,0xf9fff1fc,0xf6790dcc,0x11a2fc7c,0x04d601f4,
0x01f90668,0xfbce017b,0xe5d317f2,0x09c31261,0x0f55fff4,0x0fb6f2df,0x03f1f322,0xef550a50,
0xff010bc3,0x08aff5c1,0x0b9fee83,0xf2bd0340,0x01e1fe79,0xfcc5efe4,0xf721f633,0xf27d022c,
0xe9f91078,0xf6a70eb0,0xfd560886,0x0b3df120,0xf8f60d82,0xf1720b17,0xfa4a10c0,0x06470621,
0x0858f5ea,0xf8dc0da0,0x013504e5,0x07a8f7cf,0x104ff43a,0xfb8e0419,0xf4bafb64,0xeace1b47,
0x1a62fa06,0x0251e6fa,0xeea40d88,0x091305b4,0x050bf326,0xf3a406e3,0xe6000e04,0x043c0856,
0xf953fe7b,0x04b1faeb,0xea680982,0xfe6f0aa1,0x184ef37a,0x0a62efa3,0xfc14045b,0x12ff00eb,
0x15fce659,0xfa24fc7f,0x0a9ef467,0xfed0f993,0xed9a0694,0xfe980984,0xf9aa0941,0x0a1dedc6,
0xf42505e2,0x04530689,0xfff802b3,0x1454ee66,0xffff0002,0xfefc04ce,0xfe5a0112,0x0e080042,
0x0703ef78,0x03befe2b,0xf226022b,0xef500e73,0x193cf602,0x25bbde22,0x1471dc45,0xf4dff979,
0xfc1114ba,0xfe9b005d,0xf82b024e,0xf58416c6,0xf01c0af9,0xf86f007b,0xef4e182f,0x1426f29a,
0x02c1ec75,0x0affff38,0xf15f0645,0xf0240f37,0x05dc08ae,0xfd74f6d1,0xfdf7f8e1,0x1062179e,
0x0d64ded3,0x02b8f580,0x0b5501e6,0x16fde065,0xf35ef49b,0xeeef1334,0xece51978,0x12bdf769,
0xf8970561,0xf8520343,0xfdec0791,0x048c0d6e,0x1401f92e,0x02bdf41e,0x02c7f935,0xf4ec0224,
0x05da0291,0x199be67b,0xf87af819,0x0596fa09,0xfd45020a,0x0238fe24,0x0a08e79a,0x003301f7,
0xfd1a0068,0x0e23f7dd,0xf9e7fa64,0xf52f0759,0xee4e1163,0x071608e0,0x00b4fdf7,0x10c7fedd,
0xf48afe01,0xe7cc1e70,0x17d0023e,0x0361ff05,0x0480fd30,0x01780345,0xf751fc43,0x014303b4,
0xfb13f41e,0xf6f6fd27,0xe11911cb,0x0a8cfadd,0xe8c1fd1c,0x04b9068c,0xf0a2fd65,0xeb801df7,
0xf6301615,0xf9e60612,0xfe49090b,0xf4450c80,0x1ffffd2b,0x14a2ea4f,0xf4f9fb68,0xf81c0ac9,
0x0f440899,0x0c9bdfd1,0xf7cf002e,0xecdb1353,0xff42076a,0x074cfcc0,0x0055fe93,0x0421f8c4,
0xf9630c17,0xf3c20843,0xf419026a,0x01a90617,0xf1e7f475,0xe5451730,0xf425136c,0x02d8086e,
0x2025de0a,0xeb7704fc,0x0f0207da,0x109af223,0x1730efca,0x02d6f7d0,0xec7c0976,0xf2510f53,
0x1107fd2d,0x1568e970,0xf57ffeb9,0x0049053d,0xf30efcee,0x03300c3e,0x16d8e57d,0xf470fd2b,
0xfe140df6,0xf89c0cc0,0xefa506c9,0xfcf6106c,0x116cf669,0x0c78e751,0x0399f9c3,0xec1207e2,
0xf65b0a5f,0x06e201cd,0x0c64f753,0x1393e8da,0xfb73feef,0xf3570a62,0x0049fef4,0xf7440d5c,
0xf4c70148,0xfc95070e,0x03a603dd,0x0b86ecbd,0x0a6df254,0xfd820818,0xf913fffa,0xe0071d19,
0xf5f8194d,0xf2740f6d,0x086703f8,0xf6d0fc6f,0xf67b11b7,0x17950020,0xfadbec87,0xec480472,
0xe73918be,0xfd390a1b,0xfaa1fa53,0xf4170a01,0x0362fed3,0x07fb01a9,0x10ffeaf1,0xf4b6fdfb,
0x01570bc8,0x0508fa28,0xff67fd00,0x07cafc9f,0x1770e9f4,0x10a8e874,0x0321016e,0x0e6cf304,
0x0d84fdb2,0xfa24f8be,0x02260c7c,0xf6c6082c,0x0990007d,0x02b9fb13,0xffc204d0,0x01a6fd60,
0x02ebf4cc,0xf813fe24,0x0336f9ee,0xf8c1f7ef,0xfffd0002,0x0872f0ef,0x0de7f297,0xeac80450,
0xffe41291,0x04880c4a,0x03f8fa53,0x0705f747,0x012bfda9,0x051ef841,0xfe74fbb1,0xf9a5081d,
0xef400cca,0xfda40f5e,0x1593ee5d,0xe43302d5,0xf53c1918,0xf2691234,0xfb3c0d14,0x04d50086,
0x0336fc0d,0xfe7afe1f,0xfaf902c7,0x0d94016e,0xfc03f9ba,0x0042ef84,0xf06f0e30,0xf58a07f6,
0x0cb8f492,0x091df529,0xf87006de,0xfe6a0b5b,0x051b079d,0x0125f51e,0x00c2f9c3,0xf0770621,
0xf70b051b,0xf3c7fdda,0x01cf0897,0x08a1f6fb,0x10a8f969,0xfd69fa42,0x037107b6,0x061cfb63,
0x026a0928,0x095dfd53,0xfd9ffe97,0xffac03ee,0xf83209d9,0xffbefe06,0x0af7f4df,0x07f0f3bd,
0xfca4f8bc,0xe2c10d44,0xfd880cbf,0x0e4ff911,0x084df0b5,0x0799feb6,0x02f002ec,0xfe52fe8e,
0xf6b8ffaf,0xfcf80263,0xffcdf7e4,0x0963f821,0xf420006b,0x0186002d,0x0b51fad2,0xf68d0c9f,
0xec510ad3,0x048a0e98,0xfe140a50,0xffdcf27d,0xe9c81471,0xf9b91a18,0x0e1cf04b,0xeaba0b3c,
0xf63115c4,0x02c1f458,0x0445fbbb,0x02aefa47,0xf6bb00a7,0x07660823,0x06a8ec40,0xf9890186,
0xfcff09e5,0x0056ff8f,0xfaa30445,0xfaf8fe22,0xf9180b1a,0xed86ffea,0xedd20269,0xefb9204a,
0x03a3fe99,0x04070729,0xf7390935,0xfea00353,0xf9b8039c,0x009506ce,0xea12069f,0x0c8705f1,
0x0748f9d0,0x0165f56c,0x10d7fc05,0x1705f61c,0xff29e7a0,0x0bd10805,0xfb1afc83,0x045dfa65,
0x05fef638,0xf5280bfd,0xf18f10b0,0x035605e7,0xfcff035d,0x00fdf873,0x0b6ef665,0xfeb1f3de,
0xf757f4bd,0xef0c0c16,0xff4e0063,0x1512f0a1,0xfc33f9d7,0x0f370514,0xf9b9017f,0x0897006c,
0x00940a5d,0xf73402c2,0x13d4feb6,0x0480f8d0,0xf6810a55,0xfcf807ae,0x008f06b2,0xfec6ff50,
0xf843f9fc,0xf6571221,0xedd0fac0,0x06a4043f,0x081e00b9,0x03e2e7e7,0x08fdfc11,0xf62afb02,
0xeb8e06c4,0x03d2112d,0xf7ed02bd,0x017bfe18,0x03bb0036,0xfcdd0872,0x05d8f878,0x0c96fbd2,
0xf89c0540,0x02d80ce2,0xfe1e0882,0xfb9af63d,0x0643fdb2,0xfe7bf60f,0xe9a50299,0x034416b4,
0x076ff7d4,0x0812fa5f,0xfb5efcee,0x0454f5e5,0x01fffeb8,0xf8c3009c,0x039a05ec,0x0128fcaa,
0xfd360a6f,0xf663fd21,0xf4a3108e,0xf6830f76,0x0120ff0c,0x0498046b,0x055df0e3,0xffc8fcb6,
0xf3af0897,0x02ac0888,0x093afad1,0x0888f5b9,0xff93fe05,0x0603f65a,0x0f29f139,0xfc21ea0d,
0xf1990983,0xfccf0873,0x0da5fef8,0x0d77f450,0xfb2b031b,0xfe110ff7,0x0399fcd8,0xf604fecb,
0xfcff1078,0xf35307f2,0xf98f0953,0xfd180ed1,0xeeaa112b,0x103303bc,0xf890f80e,0xf7f20326,
0x0988f9c2,0xefebf98e,0xf01f138b,0xf9e00002,0x00d1044f,0xfefcf4c4,0xfb8efe50,0xe88812bd,
0x085d00e4,0xf1fffc45,0xf9e7064d,0xfc64040c,0x04dcf64b,0x089707ba,0x010b02ad,0x02240f4d,
0x087a043c,0xfeb4005f,0xf69f0e90,0xf64708d8,0x00310449,0xfec9ffac,0x0436fc8c,0x057afd31,
0x180fed36,0xfe8cf834,0xfe07f8bc,0xf88cfab0,0xfe1dffd1,0xff7afd74,0x0997f537,0x0275fd3a,
0x0946f345,0xf376fbe7,0xfa80078c,0x0c20f463,0x073afbe8,0x076b00ad,0xf3ebfefc,0xf5850f76,
0xf54b127a,0x078d0527,0x144f005a,0x0c51f7c2,0xfb9903cd,0x02cafaa4,0xfdbd0141,0xfeb0f767,
0x0c1df2a8,0xe6991181,0xfa9e069f,0x02140601,0xfbfcfab4,0xf8e3f8db,0xf4ef10de,0x07560036,
0x0b11f293,0x037dfa7f,0x0601ff42,0xf796eef7,0x03aa0c96,0xf95afdad,0x01b2f8f6,0xf3a61208,
0x044d005e,0x018f02a0,0xf475044b,0x016811dc,0x1083fa36,0x038ef9b0,0xf5040d81,0xee4f0a5f,
0x08740ac9,0x06e3ee37,0xffa5f2ae,0xf5d4f9bf,0xf0d30af9,0x02270a31,0x0f57f17c,0x0700f863,
0xfe8ffb1b,0x0819f7b8,0x0774fc82,0x072ff5b0,0x0c9fff76,0x0c0ef57f,0x0b7ff47c,0x07cafa10,
0xfce3fb1a,0xf7cd1143,0xf66809d7,0xf7f3093c,0x0a9bf5ab,0x0a0ff227,0xf770fd92,0x13eef646,
0x0ec6f647,0xef47f7d9,0xec9417c5,0x0283ff44,0x1112eba2,0xf7f805bb,0xf806fe3d,0xf53b0ddf,
0x047d08b9,0x1744fac4,0xff62f727,0xfd820e67,0xfb9e0db7,0x0557faf8,0xfa4efb64,0xf2edfbbb,
0xeb661695,0xe0a41ac4,0xedcf1d18,0xf2de1012,0x0405fe10,0x073df330,0x031ef163,0xfa7000ac,
0xf3890864,0xf368114d,0xfe8c01a9,0xffc70244,0xff8303f4,0x0b12fdad,0xf4ce10c8,0x08b8f4ab,
0x013af029,0xe7b114b6,0xee500d7a,0x074b07cc,0x03e50b87,0x1e92ebc5,0x0135f9fd,0xf3e805d8,
0x1424f38f,0x0174f65b,0xf29efd31,0xf7b2020d,0xfe0e0700,0x013d01ad,0x098df80c,0x0f3bf012,
0xff1ef1db,0xfdd4013d,0xf48d10c0,0x067d01a7,0x1e4cef58,0x15cae3bf,0xf781ff69,0xfb900c13,
0xff8b0480,0x01e6057c,0xfc6d03c3,0xfc7209c1,0x0aa8eea9,0x06d9f1a2,0x09eef2da,0x12cff55f,
0x0c73e3c7,0xf7340639,0xf0450be9,0xf699002f,0x0794faef,0x049df39b,0xec9e11b5,0x090b0c26,
0x06db008d,0x0c72f595,0x07a80733,0xf045fd6e,0xf09d1c69,0x124c082d,0x1148e2f2,0xf501fb59,
0xea3208db,0xfbd209e3,0x0d30f528,0x14d7f18b,0xeec6f2a6,0xfc490e89,0xf90f055d,0xf0dc06b2,
0xebac1151,0x02aa0912,0x1746f5a6,0x0cbdf077,0xf66d01c6,0x022702cc,0x036af7aa,0x00240527,
0x0076fa92,0xfeafff1a,0xfa860db3,0xf6d80f82,0xf4100e34,0x14b8fb3c,0xfa1bf752,0xf32c1471,
0x19e5ef29,0x1344ddaf,0xe415fa39,0xf3be199c,0xfe8cfeb6,0x0218f7e4,0xfe3504f9,0xf0430e3b,
0xf7420c35,0xf64e087f,0x0e86fc55,0x041ff888,0xfe71026f,0xf9880892,0xfca8065b,0xf9320fa7,
0xfe4d036e,0x07d5f4df,0xf775f9f7,0x08b408da,0xfb9801c1,0xf3eb057a,0xfc651142,0x0d6af72a,
0xfd78fe0f,0xf7dd08b4,0xf20f0899,0xef950de9,0x06cff879,0x049ceca3,0xf5b6fbdd,0x02c70682,
0x0ddffe31,0xff5af8e8,0xfaf1fdf4,0xf212025e,0xe8041265,0x0a46129f,0x078ff3b6,0xf6e80c43,
0x03f70954,0x0d8af914,0xfbbaf9fe,0x068201de,0xfadb083e,0xe37e10d8,0xf68516c4,0xf74efb80,
0x049b015a,0x117bf89d,0x115bee19,0xf683fbc0,0xf5370d7d,0xf22aff94,0xf348ffe7,0xffc2f94e,
0x065e02c7,0x0d0aeaee,0x031efb5f,0xf60c09ef,0x0cab08c5,0x1436ebb6,0x06bafa53,0x061ffe68,
0x07d9fca6,0x01f0fde1,0xfc94000f,0xfc860621,0x1a6dfb4f,0x1518dcb1,0xfe52fb1b,0xf4000836,
0x068ffefd,0x029ffe89,0xfcf0004b,0x0774f289,0xfaadfd05,0xec171273,0x0a0a04df,0x1498ea67,
0xff31ed61,0xfa9df45c,0x053400f3,0x0397fc2b,0x0cdfff9a,0x06feffc7,0x087ffd59,0xf274fba0,
0xed6218be,0x10e20d70,0x0d75e567,0xed8210fe,0xeef011a2,0xfda2f76a,0x0eeef6f0,0xfab0ff03,
0xef1a0c98,0xe6591960,0xf7e00d1d,0xf9e701a4,0x0b90fe0a,0x0958f0d2,0x0732fa14,0xefe7120c,
0xfe630c27,0x121de9a0,0xfc27f821,0xf1bb06d4,0xf4aa0d1d,0x0a18045e,0x0a44f042,0x0c17f466,
0xf7f60796,0x0323fe79,0x05c8fac6,0x0a8aff98,0x0c78f322,0x0ceaef71,0x050ce586,0xfa42fe84,
0x0aea0159,0xf3baf48b,0x04ba0fd5,0x0ce7fa1a,0x1016f8b2,0x01c4f6c1,0xf7bd04bf,0xff840ae9,
0xf73d0b92,0x003305e0,0x0985f8b8,0x032bfeaf,0xf98301f6,0xec5101b0,0xe22b1489,0xf0cb188d,
0xff90ffc2,0xf5ca0489,0x06c601a4,0x1113ef97,0x003bfb10,0xf7720a44,0x0309070e,0xeb6a01ed,
0x036b08e4,0xf837f9d1,0xf92cfac8,0x00a3015b,0xf3051142,0xec771375,0xf2e3188b,0xfad30801,
0xfc7f0264,0x0d4c0ef7,0x200ce1a3,0x1411e53e,0x03d9006b,0xeb6002c9,0xf7440db1,0x02aaf86d,
0xf8d900dd,0x08620580,0x08abf8b0,0x0e22ec01,0x01d5f9b8,0xfebafa09,0xf58e0409,0x04c10817,
0x0c5ff6bc,0x1387ecec,0x04efe99d,0xe996fb88,0xed6e1121,0x094307ee,0x09b0f907,0x1584fb25,
0x0ca0eed0,0x0621ffe9,0x04460b34,0x1069f3e6,0x02d3fd9a,0xeed211c0,0xf761098e,0xfe22fe3c,
0xff93fc0d,0x0d5af578,0x01baf7a8,0xfb6dfc81,0xf0ec00bb,0xf6f61849,0x0ed2eee8,0x175fe9f7,
0xf7c3fd4d,0x0123060e,0x1c7cf775,0x043ceb54,0xf4abfeaa,0xef400300,0xe09f1c87,0x0f55fb1f,
0x07cffb77,0x0c6ef9ba,0x047df8c9,0xfecc0ce8,0xf7640e8b,0x001701ed,0x019affab,0xed1c0a5c,
0xe7281576,0xf9fe0ede,0x00c2fe44,0x0258fe3a,0x0642f93c,0xf54106cb,0xedf11270,0x002209fd,
0xf2f704f9,0xf87b052f,0x0205ffd2,0x0cb6f66d,0xf631041a,0xee460f5f,0xe5a713fa,0xed7d1330,
0xfaf1fffd,0x0a03fdf2,0xf4bfeda8,0x0c8c0c78,0x0075f848,0xf4a50252,0x1a4f0243,0x1277f4b2,
0x0308fdd6,0xf8f107fc,0x0b4af668,0x193ce7ea,0x07d9f7d8,0x037ef1da,0xef450818,0x0749134d,
0x0ac0f958,0xfb0ef8fb,0xfa58025b,0x03990487,0x076dff14,0xffbff865,0xfffeefd7,0xf6c1017d,
0xf8cc0996,0xf48803d6,0xf56c0633,0x18ffef58,0x0990e717,0xea4c09ae,0xf4ba1537,0x1213f64c,
0x0cab0229,0xf9230493,0xfa720fd2,0x046304ac,0x013aff88,0xfc0c0959,0xf380f3a9,0xf2ad131e,
0xed750b51,0xfeb41099,0x0c9b0371,0x04bcf7ee,0x1389f5b3,0xf3a7f8c7,0xfd9cfc6d,0x0967f97c,
0xf4b90110,0xf19408b3,0xfeefff9d,0xfd75fbfe,0xf755fc88,0x087204d7,0xf93cfb66,0x085b0446,
0x0a9ef787,0x0c43fd58,0x0cbcf545,0x02d40335,0x033207d5,0xfd6902c2,0xfe230ae6,0x0b8eee57,
0x03fbe655,0x0897fb2e,0x00c7f0e8,0x07aef6b3,0x0da50099,0x0102f9b6,0x0ae70a41,0x0691ecac,
0x0001fe29,0x00c8fc2a,0x020800fa,0xfdad015f,0xff2af898,0xfc200a1b,0xf5f9fd30,0xf043167c,
0x0b50029d,0x0304f58b,0xfd730637,0xff97fc57,0x0432ff1c,0x0e62eb63,0xfe4409be,0xf38a0e8b,
0xfec602d1,0xf8f10575,0xfc05f219,0x064afa6e,0x041eeb79,0xf47600aa,0xfce316a8,0x04da0971,
0x0ff5f407,0x0328f603,0xfb05113a,0xf0fe06ef,0x041603bd,0xfb4301ff,0xfd3503d0,0xf47effde,
0xfd8707ce,0x0518fe35,0x1654f3a4,0x00dff9a7,0xec190923,0xe213107c,0xf660205d,0x1130f5db,
0x1225ed7e,0x008bfac6,0x00bbfaea,0xe3210d12,0xecb20f45,0xf9fc0152,0x052ff524,0xef7c08c0,
0xfa2513ef,0xff0bf9a0,0x09c409a6,0x0040f7e4,0xfbff11d9,0xf5ae0b3c,0x083b0715,0x12f2f239,
0x2373dcb1,0x061be0c4,0xe5400e4c,0xf4ac252e,0x1b8bf5d7,0x0d4bef31,0xfe30fcaf,0xff6e004a,
0x06a2fa53,0x0b0df6b1,0x0a08efaf,0x0602f245,0xfe0bfc95,0xf02bfb7d,0x0199fe13,0x0660edbf,
0x0845f3d5,0xff6402b4,0xf981019e,0x01d00806,0x07a51360,0x0861f740,0x124bfe5e,0x01d50116,
0x001006c3,0xf8fbfe07,0xf6610401,0xf889fd47,0xfad9027e,0xea8d0e51,0xfd2f14d3,0x1415ed7e,
0x1598fb82,0x0227e7cb,0xff70fdc7,0x0a20fc4d,0x0c8eee22,0x0ec8f028,0x0851f361,0xf138fc74,
0xf11404ea,0xfd7d0e31,0x05f1f1ac,0xfcd004d7,0xfc730daf,0xfbfb0946,0x0974fcf2,0x05fefd5b,
0xfc6b07b8,0x0e0a0a52,0x0576fd00,0xf5befe26,0x014b02c7,0x0c22ec2c,0xf8a4e65f,0x03300418,
0xf89f0b9c,0x10ddf37e,0x0c96f31e,0xfd0efffa,0xfe1b0300,0x0f65fea6,0x070aed32,0xf8f204ae,
0xfcbc06d2,0xf4e001fb,0xe2520ba2,0xedb72260,0x0d34050c,0x0aa0e6c4,0xf6290910,0xf84e0816,
0x04540954,0x043bf5cd,0xfe1d04c8,0x032802d6,0xf5ab0813,0xf3320f35,0x03c3fdb7,0x060cf464,
0xfb8cf0a2,0xf0340268,0xf0d91190,0x01370a58,0x026607f0,0xfd18ffd2,0xf6350fb5,0xfb5e08b3,
0x0cd0fd5d,0xec350f43,0xfe4a054c,0x0177026d,0xe98d05df,0x004efde7,0x0b9ff927,0x0168feb9,
0x0243facd,0x0be5f3c2,0xe7b7fa4b,0xfbb11148,0x0d25febb,0xffeaf8a2,0x066efc5d,0xfaa61073,
0xee2003e0,0x0e0bff5d,0xf929fa07,0xfe4b0836,0xf4701476,0x0549f888,0x0971fe22,0x1295f275,
0x0a74fd10,0x07ddfb94,0x0e9bf2f6,0xf6cb04b9,0xfbfbfdb7,0x0a5df8bc,0x0978e513,0x0760f267,
0xf5730258,0xf2e40fce,0x067c019f,0xf7a3f530,0x00ec0f36,0xfa46ffd6,0x0bdbfdcd,0x18c1f668,
0x00a8f0a8,0x043900e4,0xfb6cff38,0x014d0358,0x0a3cf92a,0xfeed050b,0xf812fc47,0x16f6f7cb,
0xf11d036e,0x0594fd0f,0x0d39fef2,0xfd3903cf,0x055ff062,0xfea40f1d,0xf8dafad1,0x023af756,
0xeed708b6,0xf6480191,0xf2c7075c,0xff750cf2,0xf6420529,0x0328055a,0x0cd4038e,0x0ac4e5e1,
0x0292fb95,0x05cd0bd2,0x053ff2b0,0xf578066e,0xf58e0de9,0x006c08b9,0xfe0afcff,0xf6790735,
0xfdb40452,0xf4f70531,0x0358feda,0x0369eefa,0x00d6fec3,0x0463f9cc,0x151ef822,0x0344f76e,
0x004b012f,0x0c07fe89,0xf84ded39,0xe1bc193e,0xfa251343,0x10cffd0d,0x0fcdf7c3,0x0779f8ed,
0x04a9f9f2,0x04b0fd4c,0x065bf96b,0x0ae5fa5d,0x056eecf2,0xe8de060e,0xf91f10ec,0x0037fd35,
0xf27efa64,0xfacd1599,0x05b502af,0x0f76ec8c,0x0954f0f4,0x0638f947,0xfc66f89f,0x09540c27,
0x069ff0f9,0xf1b30e02,0xf8b41dc2,0x04a4ff53,0xf74cfd09,0x01d0064f,0xfce7f3ae,0xef42023a,
0xff47120f,0xf383f7bb,0xf77c13a6,0xfdcd0384,0x016df5f4,0xf1940086,0xef4214c8,0xfd7010ff,
0xfd35fb35,0xf22f0c11,0x052d0182,0x05b40198,0x0875fd73,0xf7af0998,0xfbb504e6,0xfa5e0c1c,
0xed6f08f3,0xf935ff49,0x03fb082b,0xfa8704b5,0x03e0fbb1,0x067ff620,0x00b9fac3,0x1a50e9e4,
0x0493eded,0xf6fb0492,0x02e7fa5f,0x034f0835,0xeb440b47,0x1a7af91d,0x1836dea0,0x0f23f450,
0x0001f884,0xfa5a09e8,0x0078f60c,0xfe1d0145,0x031d0c71,0x119dee72,0x1684ec2f,0xffeffffd,
0xee9e0bad,0xf3b00572,0xfe5207a7,0x11acf02a,0x184ef7d8,0x07aaedcc,0x026df5c5,0x0fe5fa5d,
0xff9cf236,0xf3480422,0xf1eb0aee,0xece817da,0x11330231,0x0a68e644,0xeedc0dc1,0x0b26fc65,
0xfa6e08d1,0x006e008e,0x1402f4c7,0xf6bbf81d,0xfcbe07c0,0x0182fae6,0xfc97fb0d,0xf7e802e2,
0xfbdd0c22,0xf9440a4e,0xf15f04df,0x1025fe45,0x0e8cee41,0x0256f8e0,0xfe2dfba5,0xfe2209d0,
0x0fbe076e,0x00f5eccf,0xfc810979,0xf5b10b86,0xff98072a,0x0485085d,0xf20d00ba,0x091efc0d,
0x00c5fd3f,0x09b4ed9d,0x01f2f63f,0x0761ff17,0x0236f548,0xf5470561,0xf9940c26,0xf867fb65,
0xf4f809bf,0xfb2a0ccd,0x07d3fe1d,0x0090fe0e,0xfb33037a,0x002ef57f,0xfbac037f,0xf93002f7,
0xfd6e07b2,0xec9912ca,0xfaba1678,0x00d4fed2,0x0843f6bc,0xf0410c39,0xfe550a20,0x03f80711,
0x0959f83e,0x138df751,0xe7ddfe61,0x002f123f,0x03210063,0xfc0ded96,0x00730b58,0x0b4cf1d8,
0x1639df58,0x0709f93c,0xde0c0cd5,0xfdb50f8a,0xf69e0cc1,0xfa31ffee,0x059bfa5f,0xfd9a0915,
0xee45f2db,0x0c2102eb,0x0e44f82d,0xfc67f5d3,0x08a0096e,0xffdcf900,0x020a08aa,0x0cc903c3,
0xfbc40662,0x0062fb69,0x05a00a11,0xf821fff8,0xdf8e13aa,0x0204169c,0xfd3afc0c,0x0628f8c9,
0xf986ffa7,0xeeb40426,0xfa3403c8,0xfa4affcf,0xf773fe80,0xff0a0524,0x11deef4a,0x0f88effd,
0x0a33f6fb,0xfc06f408,0xf75206d4,0x0446069f,0x233af29f,0x0c41e717,0x054bff8f,0x0b34fbf6,
0xf5230d60,0x0d1d024e,0x1ac0f622,0x08caf278,0xf751fd05,0xfc9e09b4,0xe2fdf94e,0xfd861a55,
0xf723fdc4,0xf685fe94,0x173ff5ea,0xfc6ef470,0xfd1d04f7,0x1534f07c,0xf43101ed,0xea6208b6,
0xef661ce2,0xff1a1027,0x05feea87,0xfc2603e4,0xfe5f0963,0x0567edf9,0xf70108af,0xed6f116e,
0x01820e8e,0x0fbffe3f,0xf31cf83a,0xf625150b,0x034d0e3f,0xf47502e7,0x068c0726,0x076df6bf,
0xfa8ffc94,0xfefc014f,0x08f3f6dc,0x05ceef70,0x0125f4f3,0xdc4b0cfc,0xf2a0204f,0x008f0590,
0x04bff77f,0x08700135,0x03c8f91f,0x0987fb4b,0xfbf501ec,0x00d403f4,0x1616e958,0x0680f4f3,
0x06c8ef25,0x0980f7cf,0xf01f0efe,0x06bc0290,0x0ccefb41,0xfc9ffdd1,0xf6ac0bdb,0x0a5e0596,
0x0331fb60,0x0d57f4c0,0xf9e4fc4c,0xdc490eab,0x0345104c,0x05f0ef14,0xf0ddfb95,0xef341607,
0xfaf91199,0x0a52f82b,0x0041fd1f,0xf3630954,0xfca803ef,0xf2c00e15,0x042708db,0x066cf584,
0xfe8effd1,0xfd44f8c9,0xf1250b33,0xf3700f4f,0x01ad044a,0xfd95015b,0xfd82042c,0xf8880826,
0xf9cc089c,0x02b3fe8e,0x1e76fa59,0x0a31eb38,0x07dff116,0xf7cb016f,0xff88013c,0xf9b1fb48,
0xf1780904,0xf77c02f8,0x0bb200d7,0x079dfee1,0x0a46f56e,0x0dc5f893,0xfff901d8,0x03e905a2,
0x07acf9f0,0x0d81f6bf,0xf878eec9,0xf8f609ab,0xf805053b,0xe8bdfd7d,0x02a212dd,0x143fefeb,
0x0592e7ca,0xfaa10a47,0xfc16fde3,0x00b205fe,0x0a380332,0x090af41d,0x0c0ef875,0xf29103d2,
0xf336122e,0x045207e3,0x05ba00d1,0x020ffc5a,0x01aefe0e,0xfc11019b,0x1294f54a,0xf6bbfb46,
0x00cf0aeb,0x0907f680,0x0056f548,0xe93f07e2,0x00c3fdd9,0x1342ee70,0x081cecd6,0xee02fb2e,
0xfba0133d,0x0463fd06,0x048cfc14,0x07220650,0xfceb00cd,0xf78c148f,0xf5b10c78,0x02c21664,
0x08c5f12c,0x01f5f611,0xf5bb0626,0xf6d4044f,0x15f9ffe9,0x062ee736,0xe2cf0d5b,0xfd000e52,
0xf7f1ff25,0xedb40b31,0x11c6feb9,0x11acf691,0xfe44ece2,0xed3a08d3,0xeddb13ea,0xff31015b,
0x0593ff88,0x0924f761,0x0739fd90,0x0325ffb7,0xf664fcf8,0xd7641ff9,0x03321a6d,0x08aa036c,
0x0d00f346,0x13b0fe58,0x0fa7e823,0xf0bfefa7,0xdbce1ff9,0x00d40968,0xf5c3ffb9,0xfec203de,
0x012bfdad,0xf321fecc,0xf23f13d9,0x1561016e,0x0abfeb3c,0xf34508a9,0xed3f1143,0xf5330c21,
0xfcb904a4,0x0f76f9da,0x1038eb59,0xf7d4f8f6,0xea5d1fdc,0x0053ffdb,0x048f0159,0x02e10559,
0xfb87fa19,0x16bb0178,0x1afaeb6c,0x177cdecc,0xfa02010e,0xec640542,0x0b0b0137,0x080ff4b9,
0xe12e02b1,0x015b02b1,0xfd18050b,0xe5b50af4,0xf7a00f16,0x074608af,0x0e7af8ef,0x16f6ecbb,
0x0da0f46b,0xfba2fb73,0x009cfc27,0x029d0960,0xf34d03cf,0xf89a0117,0xecc614ed,0xfff80ad3,
0x0daaf8af,0xfbe3fc90,0x0cb8faf4,0x0d5df790,0x0619f5d7,0xfa2dfcd3,0x0a2ef868,0x148aefe4,
0x0973ec0e,0xfe6cf9df,0xf5be0744,0xf4170cae,0xf8440713,0xfda105c7,0x0beefcbb,0x0569fd32,
0xf5040ca9,0x099dfca0,0x0f38f672,0xf3830089,0xfdd40008,0x0446ff6b,0xff7dff1e,0xf9f8fbf4,
0xf2b21017,0x0a32fc6d,0x0390edf7,0x0561071f,0x069cf706,0x0608f7aa,0x055ffe35,0xf2e3ff01,
0xfa5e04d5,0x0cf1fd9d,0x0ff3e3e6,0x1f5eead7,0x00530606,0xf391fc67,0xfa330c87,0xf6de189e,
0x0905f6b7,0xf8300ffc,0x02ee0eb0,0x24f3e988,0xff7ce8f3,0xe13913a9,0xf8df09a7,0x022c00f1,
0xf328fe9c,0xfa78fee0,0xedfd0483,0xfde4ff86,0xfab4f876,0xed1504ef,0xf755165b,0xf6020ac3,
0x02f00266,0x1562f3c6,0x133beb3d,0xf880fac0,0xfbc50c85,0xf9eb0cd9,0xedae14a1,0x02c91831,
0x102200c5,0x059cf405,0xf6cb1031,0xf39110bf,0x0b5a0538,0xf598fc74,0xef880163,0x0cc801cb,
0xfedaf47c,0x0323ebb5,0xf61df86b,0xf28bfd98,0xf0fa0856,0xfe0e0aba,0x048ff00b,0x033dfa51,
0x1007fd06,0xfcfff93b,0x0a53fdc1,0x04f30064,0x054ef852,0x08f3011c,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,

};

const uint32_t sample_15_standard_DRUMS_floortombrite[3712] = {
0x00000000,0x69b65991,0x53a9421d,0x3b7a5455,0x0ec158c6,0xb5dd7259,0x432aa760,0xdc2be746,
0x06deba7f,0xaa5b8e4c,0x8e4c18dd,0x8e4cfc66,0x96fec8df,0xc339ad67,0xe96b9deb,0xf2ff8e4c,
0xdf88c134,0x2174b335,0xedd8e0e6,0x28cd1d5e,0x36c70c73,0x3a1ce304,0x6cc4145c,0xeced36be,
0x33425de8,0x4bc54535,0x1a682f17,0x54303f93,0xddca43ab,0x3ff06e2a,0x3a03ede1,0xe99a36bd,
0xfaf3fd0f,0x3e45ecb0,0xf03be098,0x18e432c3,0x20b419ba,0x1fff4e3b,0x4d9bdbf9,0xcb2531e5,
0xfcd86101,0x5136e25a,0x0bf1971a,0x207816ba,0xd79a26ad,0x57cfbf36,0xe5f9e4e4,0xcb7b1bc4,
0xe1aadfbb,0xd8499f70,0x8e4cc3ea,0xc997d6b9,0xa94ba34e,0xbff48e7b,0xadd0915d,0xb51cd54d,
0xac03c039,0xc492ead9,0xd513c609,0xd5dfd93c,0xe030e21f,0xfceacf66,0x20a903ae,0x35e5079b,
0x206b2828,0x34911f5b,0x0c05670c,0x3fca322e,0x2c0844e2,0x3dc027ba,0x26cd43f1,0x2e773d3f,
0x4e5afd6b,0x3136f1fe,0x19ff18ba,0x29ab06ae,0x07cf2426,0x1f9f1519,0x161b24e8,0xf59b38bb,
0x3e9c252b,0xe9c80601,0x19bb1518,0x10bf03b5,0x0155e16e,0xd910eef9,0xd25f0792,0xf9f7f7d2,
0xd014de89,0xd912f0d0,0xda540247,0xdcb5d59c,0xe0b9d2a7,0xc136cdf5,0xcf65da17,0xb734b4ec,
0x8e4c142d,0xe470e1c9,0xe9efc790,0xc3e7bb64,0xf360df64,0xe575c0d2,0xdc7cd1bb,0xf6ffed2f,
0xd599c131,0xe51a15b1,0x27ed0b60,0x1d7bf02f,0x1b8e0d02,0x280540b7,0x30eb3668,0x25414334,
0x59e732db,0x4630223e,0x3de035f8,0x2ec11c3e,0x10ae3105,0x374c2f4f,0x20ce0d7a,0xf0933255,
0x070b2bf1,0x04d11632,0xfaaf3bff,0x31fd0cc7,0x1c1624a3,0x15d00b0c,0x0b550c70,0xfbb40796,
0x0d2e08d9,0xe466eb8d,0xdd5d1cac,0xfdd8e01b,0xd071e1db,0xd676fa00,0xdfd7d0b8,0xe120c860,
0xd64cc847,0xc52be857,0xecdddcc0,0xb359dab7,0xe967e946,0xfa52b054,0xdb5eb98a,0xc077e805,
0xd16afdc9,0xe44fcdce,0xca9be529,0xe043dd0c,0xdb61c196,0xe785ff85,0xe2fbded4,0x1243f8d4,
0xf4f1f879,0x195411f6,0x37e90b46,0x275b1672,0x4da925c8,0x2d1538bd,0x2ffc5cde,0x3e5947fc,
0x3f36431d,0x47583001,0x3ff126ba,0x348f2564,0x2a992e5f,0x36af2fc6,0x031a1fbf,0x18f71f4f,
0x38f4ff3a,0x1a33ee83,0xd90f12cb,0x14592346,0xf1c50408,0xee3c1985,0x01c4f6e7,0xf588df57,
0xe552f0fb,0xf391dcca,0xbc04e62c,0xe387e9a2,0xd0a8d1d3,0xdadadb76,0xd4d8c058,0xdea5c56d,
0xe321d05c,0xd0c2c27e,0xad57f4c1,0xe23ee26c,0xaeced8c0,0xea83e271,0xed43bd71,0xd3d3eb63,
0xf096e00d,0xdebcfe54,0xe233f687,0x39dbc405,0xde7ee279,0xfaee142c,0x0ac4f233,0x030d21cc,
0x176c30de,0x2e0d05a6,0x1f072717,0x48b52fa4,0x3a061c3d,0x32d94668,0x44713b15,0x38d25b79,
0x4d28245f,0x2d6c5086,0x40d2248d,0x28062d7b,0x109c4c54,0x25d52806,0x17d52643,0x291e0ca2,
0x023401a4,0x01f611ea,0x05eaf0d5,0xec16f5c8,0xe450fc66,0xf252ecfc,0xec67ea9e,0xdc34edcc,
0xe5accabf,0xef94d7e1,0xd94ecafd,0xd5ade6e4,0xd8c4e072,0xd0b6dfca,0xd5f2d981,0xc080db12,
0xc520cce2,0xcaecd447,0xdd0cbdf5,0xbfa0ae37,0xcdacd47d,0xbf85e6f2,0xf74fc9ff,0xd9cdc63c,
0xd32d0008,0xf2e1ed79,0xf5eafa25,0x04041a40,0x2288fdc6,0x17241219,0x17771cd2,0x232e1da9,
0x228126d5,0x46053463,0x32fc3a24,0x436630e5,0x48e332e8,0x2ccf47a1,0x31563e9a,0x41dc2e37,
0x23dc58d4,0x467b26b9,0x1fa12705,0x30d1459d,0x311f119c,0x08872934,0x13a9224f,0x07f8fd90,
0xf7551552,0x15fbf535,0xfdf9e329,0xd434f7e1,0xfa1be334,0xdc22e077,0xd58cea1a,0xebafe2fd,
0xde7ae391,0xe69adfdc,0xe134df49,0xd465ec37,0xe6c4d3d0,0xdba0e4c3,0xda13e58b,0xe0cac6ac,
0xd365d041,0xd5ced976,0xd21dbf29,0xc7e4c253,0xbd05ce66,0xd0b3d80d,0xd1b1b563,0xd83fd164,
0xe9f5ebae,0xdaa5e04b,0xf01910b3,0x00bf03b2,0x2fa204be,0x17f51719,0x20192ddb,0x38461b7a,
0x29c64297,0x419340c0,0x4ab03835,0x4a6f4105,0x41a34780,0x39e33c12,0x3c2034bf,0x24683622,
0x32472d7c,0x247a1c07,0x29ea0929,0x06e01d7c,0x1c8a1265,0xfe2c1b35,0x0ead1fd9,0x0e7b17af,
0x0f3dfeea,0x0456043c,0xf61aee43,0x0dcd05d9,0xf475ee20,0xfc9dfae6,0xf1a3e74e,0xe9a3f589,
0xea2bebaf,0xe6aae8f5,0xe2cfe232,0xe5c7dd3b,0xd857e402,0xe80edd31,0xdc08d29c,0xd883ec94,
0xd25bd650,0xd7d9d758,0xd87ad29a,0xda30db4e,0xcb98d452,0xd6a0d001,0xc7f5ddbd,0xce91d08a,
0xce7fca97,0xdda6d980,0xe056db7e,0xf114f086,0xfed7f428,0x17f3fd69,0x1193f93b,0x109e3984,
0x266f1f5b,0x2f8532f5,0x33fc3640,0x48984349,0x51d5347c,0x3bb7386c,0x3c474726,0x313e36b3,
0x2ad6307f,0x308a347f,0x285834bf,0x29012609,0x135113f5,0x0bbd13cc,0x119c117a,0x12ddffa4,
0x078afe27,0x05940fa7,0x182720d6,0x0871fa17,0x02470dc6,0x084c073e,0x06d10160,0xf6daf118,
0xf881fce4,0xfb5eec3f,0xebcafc0f,0xf2dfeb93,0xdc4ce888,0xdb38e4db,0xd5b9e1d6,0xdc53d317,
0xd954d535,0xd9ddce8c,0xd730d82b,0xc6f1c2e6,0xc5c4c860,0xbcfcd51e,0xcf26c7f5,0xc943c3d5,
0xd48ae3a2,0xeb01cdf0,0xe685f019,0xe455f4f5,0xf146ebfd,0xfb7af635,0x0056efe5,0x0383ffb9,
0x0e700ab5,0x14b615da,0x1f6f306f,0x2c5615f2,0x2da92b73,0x31b435a8,0x46c43b68,0x40b536e7,
0x35243ec3,0x469a334d,0x2ead3a3a,0x349730b3,0x2bdf2a81,0x2ac23105,0x272e263e,0x10ac2025,
0x186d1625,0x0bf00685,0xff730d86,0x03130c89,0x03c7056a,0xed13f9ef,0x0378fe8a,0xf642f95e,
0xeb63f063,0xefd9002a,0xf8faf1ce,0xf298f31f,0xf9d1f733,0xff5ff5f6,0xf19ff665,0xe4edf13b,
0xe9d4db0c,0xde27e64a,0xe368e027,0xd525d7a7,0xdea9df2a,0xd74cd548,0xd60bd556,0xcc2dcf43,
0xcf65d0c3,0xd76acdec,0xd6d7da8b,0xd0d9e186,0xead8d7c7,0xe687e33b,0xfb04e8cc,0xedffe5ee,
0xf606efe8,0x055d0db1,0x0f340257,0x10051031,0x31261a86,0x11bc1d90,0x27fb264e,0x1e441e4d,
0x2121220c,0x208b2f07,0x20771f17,0x215229b1,0x2a9b258e,0x1f6b2400,0x31862c61,0x2a5626f1,
0x255226ca,0x29f12f7f,0x21f5231d,0x224a1fec,0x140b1cd6,0x0f511fd0,0x13471c2d,0x15d40d65,
0x0ccb0dae,0x0b550b5b,0xf9e504ce,0x0b97fc8c,0xf29ff12d,0xf61df629,0xf04afd3e,0xfa20f320,
0xe8fbf83c,0xe71ae991,0xeb4ff1fe,0xe960d8e9,0xdd59ed63,0xed5be556,0xec3ee436,0xdf47eafe,
0xde5ce57d,0xd5ffd584,0xd3ecde70,0xd3dccfa0,0xcdb8c844,0xd534d532,0xcf2ad2ce,0xdc06cfec,
0xce89d8f6,0xdf12e279,0xe4bfe447,0xe7c0e596,0x006af0a2,0xfd0aeee0,0x05d810fa,0x16190a48,
0x0a381973,0x20921454,0x1fdc1e82,0x25b628b3,0x2a1e23ba,0x29dc24b5,0x2b832d18,0x32022aa1,
0x1fd6255f,0x2b6226dd,0x24c0279e,0x1b4a14d1,0x1fb22ac2,0x21fe139c,0x19342422,0x1efc1744,
0x271a2802,0x1acf1d70,0x1ecf2382,0x21a2288f,0x2051217c,0x10f0184a,0x1a160ff5,0x013d0e05,
0x043ffd18,0xfefaff4e,0xfd42f9da,0xe6a0f079,0xec1ff093,0xe652e82e,0xdb9ae5bf,0xdf38dc9e,
0xdaecd53c,0xdb3ae45d,0xdb1addef,0xddf0de6e,0xd6b3ddb1,0xe112d6b3,0xd99cd79b,0xd79cd71a,
0xde51dd3a,0xce7dd876,0xe4d6e50b,0xdc5bdd9e,0xdd58d57e,0xe435e266,0xe169daa9,0xdeb6df63,
0xed2aed6c,0xf733ec23,0xf8f9f727,0x047dfefe,0x0c930256,0x0ce513d4,0x1914102b,0x180317d2,
0x291f27ce,0x2c702959,0x307a28ee,0x2f602c67,0x2dfb2dc4,0x2bfd2ef2,0x25ce2c45,0x1dd52b46,
0x23a31de5,0x231c28c9,0x1e9514f8,0x1f34253b,0x20081e29,0x1c2f24e8,0x25301942,0x14801ed6,
0x16af15d2,0x0c971efc,0x1cbe1146,0x11571683,0x0ee8129d,0x12691228,0x02020c46,0x022d03da,
0xfba9003f,0xf3a3f434,0xe9fae841,0xe83be7ce,0xe93ee6be,0xd990e2d8,0xdc66d700,0xd457d544,
0xd94dcff5,0xc962d28d,0xd2b9d404,0xd64dd65f,0xd688d7e3,0xd8dcd699,0xd7c5d0a8,0xd2fdd536,
0xd3f4d820,0xe69fd9b4,0xd1f3d148,0xe18bddc9,0xe63ae3bc,0xe7d4e6e2,0xf48fec39,0xf960f544,
0xfcd9f821,0x057800e1,0x037106a1,0x0ef310f3,0x15911521,0x1c2a1a3c,0x20761fbe,0x28fd258a,
0x2ecb2bc5,0x3a622fda,0x33873423,0x38222ff8,0x358d3b8e,0x357c33f9,0x2ce739f3,0x2e723255,
0x2a152f59,0x29372987,0x24be2528,0x21382019,0x1b5722cb,0x13631621,0x1229118f,0x0f74124b,
0x12a60dd6,0x041204ed,0x03a404d8,0x05ab0c0f,0xfce1fc42,0xf5b2f91f,0xf4fbf9e0,0xf088f198,
0xe6b6f04c,0xe693ebe7,0xe808debf,0xdf17e86b,0xde26de63,0xdc71d933,0xca9ed0c5,0xd0d9ca6e,
0xc4f8cd04,0xc65dca78,0xcf6cc944,0xc905d07a,0xd482cb69,0xcb12cd09,0xd6c2d238,0xdd4ad596,
0xda27dafc,0xe58ee616,0xed39e6e1,0xe802ea6c,0xfb7df916,0xfe57f8cf,0x02f70745,0x0c1d046c,
0x0c2a0c33,0x149012dd,0x2278156e,0x225d22d1,0x2e932282,0x231f2a7e,0x33a82c14,0x2aeb2a7b,
0x37843464,0x2f5930ba,0x362e31e2,0x38b13efe,0x3fc83a62,0x35803a58,0x305b34c3,0x2fb03122,
0x2c142d6d,0x25872645,0x222021ed,0x1d262009,0x09c41aa7,0x0ea20de9,0x09fb08dd,0x0185068c,
0xfbe5fdb7,0xefdef029,0xf1bdf422,0xef4ff30e,0xe7f5eb0b,0xe77be4bb,0xe63ce9d2,0xe2afe342,
0xdec4e19c,0xd634de30,0xe31cdb3c,0xdfb9da4b,0xd6d1db70,0xd8fedac7,0xd35dd359,0xcb3fd74b,
0xd045ca11,0xcb21cbb1,0xcde3c960,0xc950c84c,0xd1c0cf42,0xcf7bcdc1,0xd85fd6a3,0xe13adc5b,
0xe45bde99,0xeb0bea6e,0xf1abf05f,0x0091f42b,0x0985ff64,0x0f9a10ae,0x11581655,0x1da713b4,
0x1d341c68,0x28e726c2,0x2f732b42,0x33e631e6,0x2f7b3501,0x31733007,0x32a2300a,0x34ee33e6,
0x3051358d,0x34ee3263,0x35c634b4,0x3255390c,0x35f631aa,0x2f063290,0x33af3198,0x2a3c2fe2,
0x2744294e,0x18d4239f,0x1dce1c01,0x16c11ad5,0x113e1435,0x023f0a25,0x01b9fd2d,0xf751fe72,
0xedb9f3f1,0xea0eedb5,0xe68ce82c,0xe5bbed1c,0xde24dc95,0xddffdb87,0xd8c9d914,0xd547d7c4,
0xd13cd8b1,0xcf61cb35,0xd172d0ed,0xcea7ceca,0xd1f5d245,0xce47ce92,0xcfe8ce9e,0xcf69ce24,
0xd064cb96,0xcf5dcf38,0xd5e0d442,0xd420d6cf,0xdaa4d9d6,0xdd46dbb6,0xe458e3b3,0xef05e8ec,
0xf20cf229,0xf941f027,0x0156fc36,0x087effd1,0x16c910b2,0x19bc1a0a,0x21441e9f,0x22b02490,
0x2986268a,0x336e310b,0x38c536f3,0x3d2139bd,0x3d343c56,0x3c683e5c,0x37683a53,0x3c9f3b69,
0x2ffc3505,0x2fc93275,0x28262986,0x27662cce,0x29052487,0x1b3d20ac,0x20af1ef1,0x19d91c8d,
0x124d17ef,0x142e137c,0x0ec20f62,0x0e200bd8,0x0acd0e1a,0x02ff063e,0xfc4aff9d,0xf2c9f5b3,
0xeebcf29a,0xe678ec92,0xec5ee66f,0xdf93e94a,0xe026dd14,0xd811da65,0xd49dd71d,0xcfeed412,
0xc9feca6c,0xccc4caa5,0xcbbecf47,0xce71caa3,0xcedbcbc8,0xcdbdd000,0xcdcfcc1d,0xcdaacf12,
0xd4e0d144,0xd3d0d2a4,0xdea0d709,0xe08ae00b,0xe020e47a,0xe908e729,0xf258ef2b,0xfb21f610,
0xfd9bfd8b,0x0672ffb0,0x071b0876,0x13bb0ce6,0x18e715e1,0x22d81e29,0x254c251d,0x2b4826b8,
0x30f330a6,0x30bc2e63,0x380e33bf,0x3887392a,0x38d13a9e,0x3b813b1a,0x3c413cae,0x3afc3a07,
0x326c379f,0x2ef83118,0x29752d6c,0x20e82762,0x258e21f8,0x1a861e5c,0x1989187b,0x0fbd1668,
0x0a2f0b96,0x0203061a,0x005401d7,0xfc2ffc5d,0xf9d9f97d,0xf9ebf978,0xf42ffa63,0xfb8ef89e,
0xeff4f3a9,0xecccee03,0xec25eae4,0xe25ee7b5,0xdf4ee032,0xda38dddf,0xd9d7d7de,0xd10bd664,
0xcb64d039,0xcad1ca7b,0xc928c7d6,0xc8cec836,0xc770c684,0xca08c969,0xcb1dccae,0xd1e7cba4,
0xd333d562,0xd672d11f,0xdf39daa4,0xe219e0a9,0xeecce7df,0xf07df053,0xfca0f1b8,0x043a0284,
0x044c068e,0x0dda0832,0x0f47103a,0x1b3917ea,0x21591d44,0x26b0256b,0x2ad125e3,0x2db82d3b,
0x2f332e41,0x30332f8b,0x37fc34f0,0x3a6e3909,0x378f3a86,0x36f838d5,0x36333417,0x371f39a9,
0x2df62f0d,0x2fe63006,0x2d232fd7,0x24402778,0x1c1424b7,0x1fcc1953,0x13651bf5,0x0c5c110a,
0x085b0947,0x01e1020b,0xfecbff76,0xf98bfc43,0xf538f586,0xf2abf658,0xef36f20c,0xee71ef02,
0xe84be6c6,0xe7efe9e1,0xe558e4cd,0xdfdbe284,0xdacade70,0xdaf0da94,0xd9e9db55,0xd897d9b4,
0xd525d6be,0xcfefd229,0xcf18cd4a,0xc9c8cc8e,0xcb46cb84,0xc748c97f,0xc949c79e,0xcdffd08d,
0xd285d027,0xd952d48f,0xdd19dc08,0xe28cdda2,0xe8c2e579,0xf1fbed39,0xfaaef893,0x05c4fe17,
0x088c06e8,0x142210ff,0x15ee14d9,0x1baf1996,0x23ed1e0e,0x2a0525e7,0x2fe72cc9,0x31a8303e,
0x329732fe,0x350933f0,0x349d338e,0x337a3564,0x36b93672,0x303e30b5,0x32803309,0x327531e3,
0x2ea32ce7,0x2e9f310a,0x2bbe2bad,0x25cb27ed,0x241d240f,0x1fd423b8,0x18711b1a,0x13141587,
0x0eff12dc,0x092b0d1b,0x02f40749,0xfed7ffc9,0xf7a1fba9,0xf054f4a5,0xec2cecb5,0xe5a9ea18,
0xe304e37c,0xde1fdf67,0xdad3db6d,0xdbeddcf9,0xd413d8a0,0xd508d566,0xd0bad24b,0xccc9cdf8,
0xcd7ece53,0xcd62ccec,0xcdd9cf64,0xcd1acc8f,0xd049cfa6,0xcdddcf47,0xcf02cce5,0xd267d0c4,
0xd4e1d225,0xdd67d78c,0xe030df1a,0xe447e3b3,0xecb7e98f,0xf13aed49,0xfaf7f685,0x027ffe87,
0x0a2c05bf,0x117d0da0,0x1971152b,0x1ddf1bc8,0x26582164,0x2a9e283a,0x2e262c34,0x31933030,
0x33ef31be,0x384d3868,0x350035bf,0x376735b3,0x36433747,0x33703460,0x33ce36a2,0x2d36316e,
0x2d812b6b,0x253e2ae8,0x2283239d,0x1ec51fd1,0x1e7c1ec7,0x1bcc1d9a,0x1524174c,0x140814c9,
0x112212e1,0x0c940f31,0x0560082b,0x055b05be,0x001f030d,0xf9eefe6f,0xf27bf723,0xeefdf020,
0xea2becea,0xe198e634,0xdb47de39,0xd81ad9fd,0xd2c6d358,0xcee5d113,0xca5fccf7,0xc9c5c8bb,
0xc549c763,0xc485c505,0xc4abc50e,0xc841c6cd,0xca5ac9b0,0xd016ce74,0xd056cd61,0xd46ad2b3,
0xd836d7ae,0xdbf0d9c6,0xe2ccdfa8,0xebeee686,0xeef6edda,0xf478f228,0xf85ff585,0x0168fc8a,
0x09d605b8,0x0f600aa5,0x16c114b4,0x1ee21ae7,0x233c21c0,0x26a8254b,0x2c1829ea,0x2f5b2de9,
0x335c3088,0x35fd35d3,0x37c734a4,0x381e376f,0x3a0d3ab5,0x363736f3,0x3260345f,0x341c3393,
0x2cb53202,0x283e2a16,0x27ce27b6,0x201d24cd,0x1c661dcc,0x1a0b1b01,0x170819d3,0x114d13fc,
0x0efb0fdf,0x05f809c1,0x03f804c6,0x01260385,0xfa49fc7b,0xf6b8f81e,0xf3fef5bc,0xf286f3a5,
0xed9bf226,0xe6f6e958,0xe384e535,0xdd1de102,0xd73bd95f,0xd4a1d60b,0xd164d37d,0xcd82ce0c,
0xc82dcba9,0xc406c4e8,0xc34dc55c,0xc417c2d3,0xc622c42a,0xc8c0c6a1,0xcbe6ca06,0xcf40ce6a,
0xd23fd0b6,0xd728d482,0xdf6ddaf8,0xe7ace447,0xf014eb19,0xf611f2bc,0xfddaf992,0x05a2021e,
0x07940667,0x0e3b0b30,0x148a118f,0x1be71915,0x20001ec1,0x264122a5,0x2cb729eb,0x2e8e2c9f,
0x2df22db8,0x316c3078,0x36cc33f2,0x3867379f,0x36da381e,0x392b37c7,0x38b53a80,0x349436fd,
0x3444347c,0x2eca30f4,0x29e12c31,0x281e28d9,0x1f2f24e8,0x1d8c1ddd,0x18271bc4,0x0dce11ee,
0x0c770d62,0x07360aee,0x0159052a,0xfa76fd3d,0xf895f969,0xf69df849,0xf228f4a2,0xecefedf2,
0xebf8ec2f,0xe8c8eab8,0xe452e587,0xde14e245,0xda35db60,0xda16da3d,0xd37ed70d,0xd170d2f1,
0xcf06cff6,0xcf14cf3d,0xcb21ccc4,0xc7a3c9a0,0xc63bc6b2,0xc8e3c6be,0xc9a1c8b6,0xce99cb6e,
0xd1cbd0dc,0xd4a7d2f1,0xd96ad66c,0xdfefdc2e,0xe62de2c1,0xf08feb3e,0xf821f53f,0xfbbffa8e,
0x057400be,0x0dcc08f8,0x10731044,0x17ea142a,0x208d1b8b,0x250922b4,0x29de2776,0x2c502b87,
0x312e2f3d,0x30d43194,0x319f3149,0x32633186,0x32ac32fe,0x343132d4,0x320333b6,0x2f69300c,
0x30682f4a,0x3005319a,0x2d112dd4,0x2e682de5,0x2c532e59,0x26072960,0x21182314,0x1e322081,
0x177c1a30,0x0f801365,0x0b290dfe,0x07800985,0x00680450,0xfad3fc54,0xf435f7c2,0xeedbf0bc,
0xea14ed04,0xe2ebe7ca,0xdc3edf4f,0xd772d8b7,0xd58fd709,0xd20bd42b,0xd3a6d224,0xd177d237,
0xd0c7d08d,0xcea2cf27,0xce5ace73,0xcbf2cdfe,0xca2eca31,0xcc29cbce,0xccfdcc1d,0xcf5cce52,
0xd03bcfef,0xd55cd22e,0xda12d7b2,0xdde7db79,0xe411e0db,0xe9e7e720,0xf178ed3a,0xf7fff556,
0xfc96fab5,0x02daff2f,0x0b4d0735,0x0fc60e2b,0x145e12a1,0x1b7117dc,0x21ea1f8a,0x280024df,
0x2a0a288e,0x2d002c31,0x30882eab,0x333131e2,0x35aa349a,0x3533356e,0x350234dc,0x351b35c1,
0x32963479,0x32f4324c,0x31cb333a,0x2b592f06,0x28f92a53,0x25fa27e9,0x222e237d,0x1b011de3,
0x18d619e0,0x165816fb,0x144f15c2,0x0db71254,0x085b097b,0x056d0779,0x00ff038e,0xfcc2ff0a,
0xf518f8bd,0xee30f0e8,0xe806eb77,0xe177e43b,0xd9a3dd36,0xd548d700,0xd08bd255,0xd0e0d0a9,
0xcda0cf91,0xca97cb5c,0xc805c96c,0xc520c6a5,0xc5b3c554,0xc6c7c61e,0xc79ec6f8,0xccfbca24,
0xd16ccf04,0xd277d21d,0xd724d5cb,0xdc7ed8cd,0xe1fadf6c,0xe64ce458,0xebe3e999,0xf24ceed8,
0xf6bff476,0xfb7cf8e4,0x0212fe8d,0x07830562,0x0cc709ef,0x134b1029,0x196a162e,0x208b1ca6,
0x2671247a,0x2a7c288f,0x2f732cae,0x32e031be,0x34093369,0x34fa34ed,0x37463629,0x38c63870,
0x37a9383c,0x36203775,0x332434c4,0x2f4a30c3,0x2bfe2d4c,0x282629f6,0x2255255f,0x1e681f7e,
0x1ca61de4,0x16f119ff,0x12ed1422,0x11bb124b,0x0cf210c0,0x066108db,0x02330383,0xfe220091,
0xfa53fc09,0xf626f886,0xf3a0f417,0xee7df11a,0xe872ebaf,0xe203e598,0xdd6be026,0xd908db94,
0xd2dcd604,0xcc91cf9a,0xc973c9f7,0xc8afc943,0xc593c6c4,0xc41dc47f,0xc4b8c378,0xc6a9c5dd,
0xc92dc866,0xcd0ecada,0xd0c0cf2c,0xd5f9d479,0xdaf7d840,0xdf45dd31,0xe3b3e159,0xe946e640,
0xedf9eb9d,0xf404f0cc,0xfb70f7ea,0x01d7fe7f,0x06fc046d,0x0d310a3a,0x12ab0fb2,0x1980165c,
0x1dd91b75,0x22e82004,0x280a263f,0x2ae7295a,0x2e7c2d1a,0x30e52f20,0x348f3216,0x3886376e,
0x3a0838e4,0x3ad83a6d,0x3a533ae7,0x3735384f,0x33a435d3,0x2ecb3187,0x2ba82c9a,0x2a862b5e,
0x24ca27c3,0x212b231a,0x1a691de3,0x140e1745,0x0e8610e7,0x09240b7a,0x059c078f,0x0127038c,
0xfa60fda5,0xf6a5f81f,0xf2e1f4fe,0xeffcf148,0xebf2ee51,0xe6a0e949,0xe333e52b,0xde76e0ab,
0xd9fbdc74,0xd75ed89e,0xd561d64d,0xd18dd35d,0xcd63cfae,0xcbf8cd24,0xca3ccad9,0xc868c935,
0xc7d9c807,0xc9cec900,0xca90ca81,0xcc74ca9c,0xd163ceff,0xd46ed2d8,0xd7a1d5b4,0xddc3db07,
0xe43fe11e,0xea33e74f,0xf18deddc,0xf822f538,0xfffafbea,0x054602e7,0x0a41072b,0x10110d0a,
0x1537129a,0x1c461924,0x21511e23,0x27492416,0x2de12b0d,0x308b2f74,0x318c30f4,0x34a132ff,
0x3680361b,0x372e36bc,0x363d36cc,0x366436a7,0x35113598,0x3173333f,0x2ec4301a,0x2d282e0b,
0x2be32c3f,0x29ae2abc,0x256427bb,0x20f822d1,0x1d7c1fa6,0x17f51b6c,0x11641406,0x0c580f1f,
0x07d20a5c,0x009e04cf,0xfb78fdec,0xf5d2f896,0xeea1f1e8,0xe8b3eb46,0xe424e65a,0xdfcde241,
0xdac4dd31,0xd53bd7de,0xd1fdd3c9,0xd0f6d149,0xd135d154,0xcfafd0be,0xcf54cf58,0xd065cfaf,
0xcec6cfe7,0xcd4ccdbe,0xcd05cc97,0xce7fcdcf,0xceabce23,0xd022cf62,0xd260d135,0xd4c4d34d,
0xd72ed667,0xdcccd98a,0xe3d7e0a0,0xe9eae664,0xf126ed12,0xf77ff49b,0xfe45faec,0x059c01cc,
0x0de2098a,0x156f11bd,0x1c661938,0x227e1f59,0x2767257b,0x2a8a28d2,0x2f2d2c28,0x31823100,
0x323e31d8,0x32843274,0x332e32cb,0x343c337f,0x33283409,0x31b73251,0x313d3186,0x2fb230d2,
0x2e102e97,0x2ce52d8a,0x2b1b2c29,0x289629dc,0x24a926e7,0x1fb62246,0x1ba81dab,0x1736194d,
0x1164148f,0x0d900f44,0x094a0b54,0x036e06eb,0xfe1400c4,0xf8d4fb41,0xf311f666,0xeb54ef66,
0xe4dee830,0xdf97e230,0xda3cdc93,0xd5b6d7e1,0xd24ad3e2,0xced1d08e,0xcc05cd4b,0xc95dcacc,
0xc7bac83d,0xc718c746,0xc82fc7c1,0xca08c91b,0xccbdcb75,0xce42cd98,0xce90ce14,0xd047cfcd,
0xd3c5d141,0xd9b9d645,0xde6cdbea,0xe3b2e113,0xe8eee66c,0xed49eb0b,0xf262efd9,0xf8aef5bf,
0xfdc3fb20,0x04730133,0x0bc90856,0x12ff0f08,0x1a02164b,0x1f5f1c8d,0x256022d9,0x29882733,
0x2e012bb1,0x32ac30d4,0x35d533fc,0x383c37a1,0x38b238af,0x36da37cb,0x35e93678,0x3455351a,
0x339b343f,0x3195329a,0x2e052fee,0x2ad22c8f,0x269c28dd,0x238124ed,0x20902224,0x1c7e1e93,
0x18491a31,0x14121694,0x100b122e,0x0b880d85,0x060008d6,0x017303ea,0xfcd2ff04,0xf74afa0e,
0xf377f522,0xee99f126,0xe84eeb5d,0xe345e575,0xdf44e176,0xdb1cdd36,0xd5b0d865,0xd1f8d3b7,
0xcf37d090,0xcbd2cdb3,0xc83bc9b9,0xc616c6bd,0xc601c5cf,0xc678c638,0xc785c710,0xc928c7aa,
0xcc92caf8,0xcfa0ce6c,0xd2cdd0da,0xd7c3d522,0xde2cdb1a,0xe356e0a7,0xe8ece649,0xee69ebb1,
0xf44ef12a,0xf88df670,0xfdc9fa91,0x055d01b5,0x0c6b0924,0x130f1006,0x183e15c7,0x1de11b19,
0x24c721d3,0x28642714,0x2ac52987,0x2f742cb4,0x33e131ac,0x37e73606,0x398b38cd,0x3a693a24,
0x3b7f3b07,0x39883ae3,0x35f63802,0x341b34cc,0x324c3360,0x2ec13098,0x2ae82d05,0x26cd28f9,
0x21e7245a,0x1bba1efd,0x164c18d6,0x11cd13d3,0x0d720fda,0x07ed0a9c,0x02ea0562,0xfe2b0039,
0xf92cfb9a,0xf4bbf75b,0xf00ff22b,0xec25ee0d,0xe7feea40,0xe38ae58f,0xe07ae21f,0xdcd8de9c,
0xd950dad7,0xd453d6ab,0xcf9cd1f0,0xccdbcde4,0xca95cb6d,0xc8f5c9d5,0xc79ac86c,0xc70dc729,
0xc79ac742,0xc90cc883,0xcabcc9e7,0xcde8cbdf,0xd1d2cfe7,0xd6e7d44f,0xdc46d940,0xe1f5dedd,
0xe85be572,0xee24eb41,0xf44af156,0xfa30f754,0xffd0fd06,0x05a0027c,0x0c610907,0x12ce0fdd,
0x1835154d,0x1d611adf,0x224a1fa9,0x26392483,0x29a22829,0x2c3f2af2,0x2ff32e33,0x33d531f9,
0x369435a0,0x37873727,0x387b37af,0x38c838e0,0x38703899,0x378c3819,0x349d363a,0x30fd32d5,
0x2d202ee9,0x296c2b6c,0x257a276d,0x210f2391,0x1b461dff,0x15fe1893,0x11af13da,0x0c930f5d,
0x06ae09c0,0x00df0372,0xfb3cfe47,0xf566f80c,0xf053f2a2,0xec4eee65,0xe5b9e919,0xdec4e241,
0xda38dc89,0xd66bd801,0xd433d53a,0xd252d379,0xd074d161,0xcda0cefb,0xcb3fcc78,0xc9a0ca49,
0xc8d6c8e1,0xc8dac8ad,0xca9ac9c8,0xcc39cb8e,0xccf2cc89,0xceddcdc2,0xd0c7d012,0xd3b8d208,
0xd8c1d618,0xde5cdbbe,0xe3e4e105,0xe998e6da,0xefa2eca3,0xf68bf2bf,0xfd59f9d1,0x046500d6,
0x0cc6089e,0x145b10ae,0x1b1a17f6,0x20241e08,0x2318219b,0x27282542,0x2ad7291a,0x2e252c51,
0x31812fbf,0x33ce32d1,0x342a3424,0x341233fc,0x34043423,0x3494345d,0x3476348b,0x336e3404,
0x320132fc,0x2f353068,0x2c522d7e,0x29bb2b0f,0x275d2882,0x24682627,0x20182253,0x1bbd1df6,
0x1669191d,0x100f135c,0x0a380cc1,0x05170778,0xffe20284,0xfb2cfdbb,0xf57cf890,0xef00f239,
0xe8aeebc8,0xe351e60d,0xdd79e036,0xd874daee,0xd4bad684,0xd166d2eb,0xcd87cf7e,0xcb2acc3d,
0xc918ca45,0xc726c823,0xc601c67d,0xc5cbc5c9,0xc687c60f,0xc87bc785,0xcb2ec9d8,0xce22cc8b,
0xd185cffd,0xd4f7d302,0xd9c8d725,0xded0dc37,0xe423e178,0xe9f4e72b,0xee14ec1b,0xf250f034,
0xf8dbf576,0x0028fc2e,0x077803b1,0x0e080b02,0x141210cd,0x1a69170d,0x20731d88,0x26492374,
0x2b2628c9,0x2f2d2d65,0x33453163,0x35bb347a,0x37f836ec,0x3a133959,0x39a73a3f,0x37ed38ab,
0x35883695,0x334a347c,0x310231f9,0x2e142fbc,0x2b5e2cd3,0x283629b2,0x24962682,0x21b3230e,
0x1ecd2071,0x1a951cb9,0x15ec188e,0x101e12e4,0x0aec0d4f,0x065a08cb,0x01ff0422,0xfdc9ffa1,
0xf91cfb9d,0xf3aef67d,0xee32f0fc,0xe8c8eb7b,0xe3c3e62b,0xded3e173,0xd9fddc76,0xd4b3d74b,
0xd070d25d,0xccf5ce96,0xca61cbc5,0xc84cc955,0xc6b8c74a,0xc6b0c67d,0xc786c70d,0xc904c83e,
0xca3fc95a,0xcc5fcb7d,0xcf22cd78,0xd26ad097,0xd6a9d49c,0xdb1cd8f7,0xdf1adce1,0xe4b2e193,
0xeb14e824,0xf0bbee2d,0xf5f7f31a,0xfbdbf8a3,0x0291ff3e,0x09e6060f,0x10860d57,0x16a713b2,
0x1c111962,0x21051e72,0x25d02379,0x2acb2850,0x302a2d36,0x34543282,0x372735fd,0x386337dc,
0x39083910,0x39263921,0x38cf390d,0x388438ad,0x37b23827,0x357c36d6,0x31ed3388,0x2e003034,
0x294f2ba8,0x245b26c1,0x1f55220e,0x1a4b1cd2,0x15c417e8,0x11121388,0x0b770e9d,0x066908df,
0x02510411,0xfe7f0076,0xf982fc3d,0xf42df6c3,0xeefcf1be,0xe957ec1f,0xe394e63b,0xdf2de137,
0xdb8add37,0xd8acda08,0xd5e6d729,0xd2c9d480,0xcf84d148,0xcc0acdb6,0xc994caca,0xc85fc8c7,
0xc817c7fd,0xc8d5c836,0xc9c2c99b,0xca6eca25,0xcbd6cac4,0xcef9cd85,0xd395d11e,0xd8c7d5f1,
0xde12db90,0xe37ae0ad,0xe87ce5e1,0xee05eb3b,0xf3e1f103,0xf9ecf6fa,0x004ffd03,0x06a2036e,
0x0ca509af,0x12980fab,0x179d1541,0x1bb4198d,0x205b1ddb,0x25af22f7,0x2ae32870,0x2f872d75,
0x325c3116,0x347f3390,0x3630356b,0x36da3671,0x37f33797,0x38c63869,0x38a838ac,0x37723863,
0x34d43675,0x31783310,0x2d8a2f82,0x29332b73,0x2588274f,0x21b423b1,0x1cd51f7d,0x173f1a14,
0x1185143e,0x0b960eb2,0x059008a7,0x009302fc,0xfc48fe5e,0xf794fa24,0xf233f4f4,0xeb94eed5,
0xe5e9e8be,0xe16ae381,0xdcf6df2a,0xd8b6dab5,0xd56cd717,0xd241d3cc,0xcef9d056,0xcd09cdf5,
0xcb63cc3c,0xc980ca5e,0xc84cc8cb,0xc7fec81a,0xc908c87f,0xcac4c9db,0xccb7cbb6,0xcef1cdb1,
0xd1a6d012,0xd581d36f,0xdabcd816,0xdf81dd07,0xe3d3e1d9,0xe890e604,0xedfdeb13,0xf4a9f141,
0xfc2ef85d,0x0330ffd7,0x09fc06a3,0x0ff50d2b,0x158a12be,0x1aa71807,0x20781d98,0x25ed2345,
0x2a2f282b,0x2d582bd7,0x2fa62ea3,0x317b30a1,0x321631df,0x326b3278,0x338732f0,0x346833ec,
0x34cc34e5,0x348434d6,0x32fe33b1,0x30b731e7,0x2e7e2fce,0x2b8b2d2c,0x281829f2,0x24622666,
0x203c2239,0x1bcc1ddb,0x180119d2,0x1457161d,0x0f481200,0x093b0c5c,0x03690641,0xfdd70075,
0xf7d8fabc,0xf1f9f520,0xec62ef19,0xe6ade94b,0xe13fe40e,0xdbcade7c,0xd789d974,0xd412d5bd,
0xd063d253,0xccf9ce9e,0xca33cb61,0xc928c99f,0xc8b0c8c5,0xc820c83d,0xc892c852,0xc98fc8f5,
0xcb04ca34,0xcd40cc2d,0xcfbece85,0xd28cd128,0xd55ed412,0xd8d0d709,0xddc9dad1,0xe42fe0c2,
0xea31e777,0xf04ced37,0xf691f36a,0xfd16f9d1,0x030f0053,0x096c063c,0x100f0cce,0x1643136a,
0x1b7818ba,0x203c1db6,0x255f22f8,0x2a3327d9,0x2e6a2c61,0x320b3053,0x355e33ea,0x3757368b,
0x378a3775,0x3728378c,0x367236d7,0x351535b1,0x333f3448,0x30d331ff,0x2e0b2f7d,0x2b012c85,
0x28372994,0x251726bb,0x2121233e,0x1d191f25,0x18e51af8,0x140b168d,0x0f9111db,0x0b780d60,
0x07210940,0x02ce04f5,0xfe190079,0xf896fb67,0xf2fff5dc,0xedb1f05d,0xe864eb02,0xe306e5c2,
0xde35e0ab,0xd9d2dbdb,0xd636d7e5,0xd2fcd48f,0xcf7dd144,0xcc2ccdcc,0xc9e7cae4,0xc867c920,
0xc774c7c2,0xc722c72c,0xc87cc7f1,0xcaa0c96b,0xcd24cbaf,0xd04cceaf,0xd40fd225,0xd815d614,
0xdbebd9f8,0xdff9de22,0xe449e200,0xe8d3e645,0xeee2ebc9,0xf5a8f22d,0xfc14f8d3,0x020bff32,
0x08140506,0x0e4b0b38,0x13dc1131,0x19a116e4,0x1fc71ca2,0x25af22ba,0x2acd2870,0x2eb52cc7,
0x315e3006,0x33ef32ae,0x35fd350d,0x374f36d2,0x3768376b,0x37713742,0x37a13787,0x365b3705,
0x34353571,0x312b3289,0x2d712f5b,0x29d02bce,0x25f827dd,0x21d923dd,0x1d7b1fd4,0x18811b28,
0x135d15c1,0x0e2310d3,0x08f90bba,0x03ae0645,0xfed00122,0xfa0afca6,0xf513f786,0xf031f28e,
0xeb94edcf,0xe7a6e9ad,0xe378e575,0xdf08e146,0xdaebdd26,0xd780d918,0xd404d5b9,0xd0c4d27b,
0xce2ecf56,0xcc3dcd05,0xcaa8cb6a,0xc9d5ca4e,0xc951c980,0xc946c945,0xcaecca0c,0xcd7ecc06,
0xd07fcef1,0xd378d1ee,0xd728d523,0xdbb7d94d,0xe077de0a,0xe5c8e30e,0xebd2e8cc,0xf131ee81,
0xf6d1f40d,0xfcbaf9be,0x0243ff8b,0x08240523,0x0e140b0c,0x13a610d3,0x18a91652,0x1d3d1afb,
0x21ff1fa4,0x2623244a,0x29da281d,0x2d322b70,0x30822ed4,0x34183263,0x37213599,0x389f3804,
0x38f2390e,0x382838c2,0x36e1374b,0x3589363e,0x333634ae,0x301c31bf,0x2c062e20,0x278c29e6,
0x22692513,0x1d361fc3,0x18df1b05,0x149b16e6,0x0fcc1251,0x0a4a0d1e,0x048d0778,0xff1a019e,
0xfa48fcd0,0xf58df7f9,0xf0b5f30b,0xec03ee67,0xe6f2e9ac,0xe1c4e449,0xdd16df52,0xd907db08,
0xd563d739,0xd282d3f1,0xcffbd12c,0xcde2ceec,0xcc2eccfb,0xcb2acb71,0xcab7cac8,0xcafdcac1,
0xcbcdcb44,0xcd0acc58,0xcf51ce07,0xd240d0ac,0xd4dcd39e,0xd7eed660,0xdbd7d9c0,0xe00fddf7,
0xe4a1e267,0xe9d2e714,0xefe9eca6,0xf627f2ff,0xfbd7f91a,0x0127fe7c,0x0666037b,0x0c5b0962,
0x126e0f62,0x1801153d,0x1d881ad0,0x231a2065,0x27ea257f,0x2bf12a04,0x2f6d2de0,0x322630d0,
0x33c432fe,0x34ad347b,0x352f34fa,0x3509350c,0x342d34ac,0x32e333aa,0x31303216,0x2f2c304a,
0x2cb02dfd,0x2a1a2b5e,0x274928ba,0x241425d1,0x20602241,0x1c2b1e51,0x178a19ef,0x130f1540,
0x0e4110b5,0x08c10b98,0x034e0602,0xfe270076,0xf838fb1e,0xf2cdf591,0xed8ff035,0xe816eae3,
0xe27be559,0xdd3ddfcb,0xd8e6dadb,0xd58bd739,0xd2b8d41b,0xcfe7d125,0xcda0cea6,0xcc61ccd5,
0xcb76cbd6,0xcabacb22,0xcb1bcaee,0xcc29cb92,0xcd49cca1,0xce92cddb,0xd0f1cfbf,0xd398d234,
0xd683d4fc,0xda7cd867,0xdf97dcd2,0xe4bde230,0xe97ae72b,0xee99ec13,0xf3f4f13f,0xf9b6f6c5,
0xffd9fccf,0x05870273,0x0b560877,0x115e0e6c,0x1767145b,0x1d1a1a47,0x22411fd2,0x26e124ad,
0x2ae928fe,0x2de12c75,0x30662f42,0x329a319c,0x34013369,0x34a83485,0x34d834cb,0x348634a0,
0x33b13430,0x3244331a,0x30103136,0x2d3f2ecd,0x2a592bcd,0x270028a2,0x2307251f,0x1ecf20f6,
0x1a9e1ca7,0x16481861,0x12191432,0x0dcf0fdb,0x094a0b6b,0x046d06d9,0xff9f0220,0xfac5fd84,
0xf586f830,0xf03ef2d4,0xeb2eed8e,0xe64ce8bd,0xe17ee3db,0xdce3df2c,0xd8c6dac4,0xd50dd6df,
0xd1d5d378,0xcee7d03d,0xcc73cd9a,0xcb03cb97,0xca4dca74,0xc9ffca08,0xcad3ca59,0xccf3cbc0,
0xcf51ce0f,0xd15ed055,0xd419d2a0,0xd787d5b0,0xdb39d96a,0xdf44dd3e,0xe351e131,0xe7eee587,
0xecd1ea71,0xf1cfef5b,0xf734f473,0xfce8fa16,0x02e10013,0x091705f3,0x0eaa0bde,0x142d1168,
0x199616df,0x1ee31c4a,0x23e22162,0x284a2639,0x2c622a67,0x2fed2e52,0x327f314d,0x34653364,
0x3596352f,0x360f35fa,0x358935d3,0x340e34e9,0x3290336e,0x30f731c1,0x2e422f91,0x2aba2ca2,
0x27332905,0x238a2547,0x1f7121a4,0x1ad71d40,0x16791876,0x12bd1490,0x0f431105,0x0b380d42,
0x0694090b,0x011503eb,0xfbadfe74,0xf59bf876,0xf022f2e3,0xeb9ceddc,0xe72ae94a,0xe2f2e514,
0xdf5ae131,0xdbf7dda2,0xd8adda4d,0xd57ad6fe,0xd26fd3f3,0xcfd0d10d,0xcdb9cea5,0xcc82cd20,
0xcbf1cc29,0xcbaccbcb,0xcbfccbb2,0xcd27cc51,0xcf6ece39,0xd1ffd0c3,0xd4fcd367,0xd888d68d,
0xdccadac4,0xe194df30,0xe68ee3f6,0xebdee92b,0xf168ee89,0xf706f434,0xfc92f9cd,0x0221ff69,
0x080404fc,0x0d9f0acf,0x12f91070,0x180e15b1,0x1d021a8e,0x214d1f3b,0x2503232d,0x2841269b,
0x2b5529b9,0x2e002cc8,0x309f2f7c,0x32ac31aa,0x33e63375,0x3465345f,0x33d2340c,0x32a93335,
0x310531f1,0x2f1a3024,0x2d0d2e17,0x2a4d2ba7,0x270528a4,0x23612536,0x1f2f217f,0x1a411cf4,
0x14a1176d,0x0f3811dd,0x0af20cf4,0x06ec08f5,0x025b04c4,0xfd90ffea,0xf833fac4,0xf30df581,
0xee49f0a1,0xea1dec35,0xe5c0e7f9,0xe128e365,0xdc9bded4,0xd878da7b,0xd526d6bb,0xd296d3d0,
0xd09fd185,0xcf81cffd,0xcef7cf11,0xce7aceb7,0xce11ce40,0xce13ce37,0xce8fce34,0xcf9ecede,
0xd188d06e,0xd406d2bc,0xd74fd59c,0xdaf4d903,0xdf1bdd02,0xe38ae13a,0xe870e5e7,0xedc1eb29,
0xf370f0bd,0xf94df642,0xff56fc28,0x04f30229,0x0ac007ed,0x104c0d7e,0x15c71308,0x1b331882,
0x205d1db3,0x24c122a0,0x288426d8,0x2b4c29f4,0x2d5c2c49,0x2f272e50,0x30c83002,0x31e93156,
0x323d322c,0x321e3242,0x31c831ff,0x309d3151,0x2ecd2fd7,0x2c632da8,0x298e2aff,0x26a12843,
0x234724e4,0x1f98216b,0x1c101de3,0x18491a45,0x13d51614,0x0edd117b,0x0a160c80,0x057907c7,
0x00a90341,0xfbaafe6c,0xf617f8d9,0xf09af34f,0xebaeee20,0xe745e97d,0xe31ee524,0xdf44e128,
0xdb8fdd5f,0xd844d9d4,0xd545d6c5,0xd2e2d412,0xd11bd1dd,0xd001d081,0xcf6dcfd0,0xcf2ecf47,
0xcef4cef1,0xcf04cef5,0xcfb5cf48,0xd11cd036,0xd377d223,0xd684d4eb,0xd9fcd81e,0xdd8bdbad,
0xe18edf8a,0xe61ee3da,0xeadbe872,0xefbced4b,0xf4e0f25d,0xfa31f782,0xffd1fcf4,0x058d0273,
0x0ba7088c,0x117c0e7e,0x1709145a,0x1c8a19ea,0x21a91f41,0x261b23eb,0x2a032821,0x2d112ba6,
0x2f732e71,0x3139305a,0x323f31cd,0x32a0328a,0x32403270,0x314231c0,0x301e30bf,0x2f022f98,
0x2d742e3d,0x2b402c65,0x285829ec,0x24ec26c2,0x21592324,0x1d821f6c,0x19a01b9d,0x157617a3,
0x10d11335,0x0bff0e76,0x06da0963,0x01e6045d,0xfd80ff7a,0xf8fffb1e,0xf488f6cb,0xefdcf238,
0xeb50edb9,0xe718e938,0xe2dae4f0,0xdf04e0dd,0xdba8dd47,0xd88dda0b,0xd56bd6ee,0xd27fd410,
0xd041d14b,0xce85cf35,0xcdb8ce1a,0xcdf7cdca,0xcecfce3c,0xd059cf88,0xd23cd140,0xd477d33c,
0xd71ad5c1,0xda72d8b8,0xde01dc26,0xe14cdfa8,0xe4d6e30a,0xe8c8e6b5,0xed3eeaeb,0xf23aefde,
0xf776f4ef,0xfc7cf9dc,0x016cff01,0x06ba03df,0x0c4d0967,0x11910ee7,0x16bd1435,0x1ba1192e,
0x1fee1dce,0x23e12209,0x27c825ea,0x2b6f299d,0x2e6e2cfc,0x30f72fea,0x32e73208,0x33ba3362,
0x33b133f0,0x32eb3360,0x3156322e,0x2f2a306a,0x2c982de2,0x29f32b55,0x26d5288d,0x231e2515,
0x1f3e2112,0x1b711d4f,0x17781973,0x135a156f,0x0ef2112e,0x0a350cc5,0x058007eb,0x00e90335,
0xfcc4feed,0xf854fa73,0xf382f5e3,0xee69f0ef,0xe960ebd5,0xe4bfe71c,0xe086e29f,0xdcdade9b,
0xda20db3e,0xd7c4d8ec,0xd5ded6eb,0xd3fcd4cf,0xd236d317,0xd07cd144,0xcf7dcfe7,0xcf98cf64,
0xd03ecfc4,0xd14ad0cb,0xd2d4d20d,0xd4a9d3aa,0xd6ebd5bb,0xd9f9d852,0xdde8dbc2,0xe283e023,
0xe725e4e8,0xebcee988,0xf022edea,0xf4a2f261,0xf9e8f746,0xff8bfcb1,0x04c80222,0x09fc076b,
0x0ee20c62,0x1380113e,0x17fa15e4,0x1c291a19,0x20281e15,0x2401221e,0x27b225ed,0x2aa82942,
0x2cd82be1,0x2e612dbb,0x2fa02f16,0x30a6301c,0x311030ec,0x30d430fc,0x2fd9306e,0x2e1f2f1e,
0x2b8f2cc5,0x28792a14,0x256e2724,0x222723cf,0x1e59201c,0x1aaa1c8d,0x16c618cb,0x12a014c6,
0x0e25106d,0x09690be2,0x049f06fa,0xffdd023a,0xfbaffdfe,0xf7b4f99a,0xf33ef577,0xee65f0eb,
0xe9b8ebf4,0xe587e784,0xe1abe391,0xde24dfdf,0xdafbdc7e,0xd813d965,0xd58dd6e3,0xd365d471,
0xd172d243,0xcfdad090,0xceebcf62,0xcf14cee4,0xcfdecf3e,0xd15fd09d,0xd38cd27d,0xd619d4df,
0xd8eed798,0xdbf7da61,0xdf1ddd65,0xe2eee0de,0xe780e51d,0xec53e9d4,0xf11aeea6,0xf5e5f387,
0xfb13f86e,0x007dfdcb,0x05d30302,0x0b2d088c,0x10340d99,0x153812b9,0x1a161796,0x1e711c58,
0x225c2084,0x25ea2429,0x28f82783,0x2b552a4a,0x2d312c6a,0x2e7e2dd1,0x2f112edb,0x2f2d2f44,
0x2eeb2f10,0x2e2f2e7d,0x2cf42d93,0x2b8b2c61,0x29ea2add,0x278328b3,0x24a8262c,0x21892315,
0x1dd21f9a,0x19a41bb0,0x1564177f,0x11831375,0x0dae0fb0,0x09880bb0,0x049a0718,0xff5b01f7,
0xfa75fd0a,0xf602f826,0xf1ecf3df,0xedcbefcb,0xe985eba7,0xe544e75d,0xe12ee332,0xdd90df57,
0xda58dbee,0xd77ad8c9,0xd505d636,0xd364d43c,0xd227d2b9,0xd14ed1ac,0xd0edd10e,0xd0dfd0e0,
0xd15fd11f,0xd292d1d7,0xd438d344,0xd643d546,0xd892d76c,0xdaf0d9be,0xdd97dc2a,0xe0cadf09,
0xe4ece2b2,0xe9a3e73b,0xeef6ec4e,0xf492f1ce,0xfa76f767,0x0072fd60,0x06410334,0x0c010932,
0x11600ed5,0x16801401,0x1b6818fd,0x1fd41d94,0x23df21fd,0x27bd25ea,0x2b21297b,0x2d9f2c7f,
0x2f6a2eb3,0x30662ff6,0x30bf309d,0x309430c8,0x30153062,0x2f3f2f99,0x2df62ea2,0x2c442d21,
0x2a0c2b44,0x279b28d6,0x24c42618,0x218d234f,0x1e242004,0x1a021c29,0x157d17c7,0x10d2132f,
0x0c760e94,0x08520a52,0x03bc0613,0xfed50141,0xf972fc40,0xf47af6de,0xefdcf229,0xebaeedb7,
0xe7c5e9a8,0xe402e5e0,0xe078e245,0xdd0bdec0,0xda24db8c,0xd77ad8d1,0xd521d641,0xd31dd40c,
0xd193d254,0xd0b6d126,0xd042d070,0xd01dd030,0xd07ed05d,0xd19dd0fb,0xd334d255,0xd58fd44a,
0xd8a4d70b,0xdc4cda69,0xdff1de02,0xe3a9e1ce,0xe7f4e5c8,0xec70ea24,0xf14eeed7,0xf613f39c,
0xfaf1f862,0xff8cfd3a,0x03e501bd,0x08d60659,0x0e290b61,0x13cc1100,0x196f16ba,0x1ea71c15,
0x231b20fe,0x2718253a,0x2a6f28b3,0x2d162bc9,0x2f602e49,0x31313068,0x329331f2,0x332c32dc,
0x32ee3320,0x321932ac,0x30873183,0x2e7f2f9c,0x2bd72d1f,0x28c92a63,0x252c26fd,0x2135233d,
0x1d9d1f5b,0x1a0f1bdc,0x166b1851,0x12091438,0x0d370fb6,0x08920aea,0x03ba060c,0xfefb014e,
0xfa0cfcb3,0xf4edf77d,0xeff4f275,0xeb5fedaa,0xe737e92e,0xe342e51b,0xdf32e14f,0xdb5bdd42,
0xd7e1d97c,0xd4e6d666,0xd2a2d3b7,0xd0f1d19e,0xcfdad050,0xcf59cfa9,0xcf2dcf40,0xcfb4cf61,
0xd0c5d01f,0xd241d16f,0xd3e2d2f3,0xd5f5d4df,0xd897d727,0xdba0da0a,0xdef5dd3b,0xe2dde0c0,
0xe772e523,0xec7aea05,0xf16aeee0,0xf677f3ca,0xfbaff8ff,0x011bfe7c,0x067903a1,0x0bcd091c,
0x11190e7a,0x163e13c6,0x1adf18a5,0x1ede1cf0,0x2258209b,0x255323ee,0x282926ce,0x2ac82991,
0x2d342c02,0x2f2a2e22,0x30c6301a,0x31d4317b,0x3240320c,0x31db3201,0x30ee318a,0x2f4e3040,
0x2ce02e2b,0x29dd2b77,0x2686285d,0x22e624c0,0x1edb20ce,0x1ae71cde,0x171318e6,0x1310152b,
0x0ec210f6,0x09e40c58,0x048a072e,0xff3201d7,0xfa5efceb,0xf594f7f5,0xf0e9f33a,0xec64eeab,
0xe7d1ea12,0xe3cbe5a5,0xdfe9e1b5,0xdc3cde24,0xd8b1da7d,0xd55ed6e8,0xd292d405,0xd068d16c,
0xcebdcf7f,0xcdd1ce40,0xcd55cd95,0xcd5dcd52,0xcde1cd93,0xcf0dce5e,0xd0d1cfd2,0xd345d1ed,
0xd650d4be,0xd9c9d7eb,0xdd8fdb9b,0xe1e9dfbf,0xe6fce472,0xec57e9aa,0xf1dfef1f,0xf760f49b,
0xfcdbfa12,0x01fdff8c,0x07470486,0x0c4a09c4,0x11230ea9,0x15f0138d,0x1aa6184e,0x1f1b1cea,
0x232f212a,0x26fb2508,0x2a6628c0,0x2d5b2c07,0x2f9e2ea1,0x31273087,0x31ec31b7,0x32233223,
0x317931d3,0x307730f4,0x2f602fe9,0x2df72ec4,0x2c172d12,0x29a92add,0x26d42845,0x23812553,
0x1f7621a6,0x1ac31d20,0x1602184a,0x11a213cc,0x0d570f7c,0x09040b2f,0x047706c6,0xffab01f4,
0xfae5fd81,0xf672f8a2,0xf244f447,0xee76f05d,0xea74ec64,0xe624e839,0xe1cfe3f1,0xdd95df8c,
0xd973db73,0xd5c4d78c,0xd2dbd430,0xd081d1a3,0xcedacfa9,0xce0bce66,0xcdd4cdd0,0xcdbccdc5,
0xce06cdfa,0xcef5ce5e,0xd079cf91,0xd2b2d18a,0xd585d406,0xd8ddd700,0xdc76da8b,0xe049de5a,
0xe47fe267,0xe91de6ca,0xee4ceb8d,0xf3b5f103,0xf97df6b2,0xff29fc59,0x047a01da,0x0a4b0775,
0x0ff90d43,0x159112e5,0x1b1f1869,0x202d1da3,0x247a2257,0x280d2654,0x2b4c29ae,0x2e3d2cca,
0x30ce2faf,0x32de31e8,0x33cc3360,0x33dd33e3,0x334b33a0,0x323732f8,0x310631b6,0x2f36300a,
0x2ce52e09,0x2a162b87,0x26ff2893,0x23b42566,0x202221fc,0x1c201e2a,0x17ba19f3,0x12ed156b,
0x0e031095,0x09130b92,0x0449069e,0xffc201f1,0xfb4dfdaa,0xf669f8af,0xf1b3f3ff,0xed58ef77,
0xe8f9eb30,0xe48be6bf,0xe03be25d,0xdc8fde56,0xd950dad5,0xd684d7ea,0xd449d569,0xd261d342,
0xd0d4d19f,0xcf9fd031,0xceaecf18,0xce6bce75,0xce9ace6b,0xcf5dcf11,0xd0e4d025,0xd2bbd1b6,
0xd51ad3f5,0xd844d6a4,0xdc10da00,0xe041de15,0xe47ee26e,0xe8c8e6ba,0xed54eb0a,0xf204efb7,
0xf745f489,0xfcbaf9f0,0x022cff8c,0x07d404e3,0x0d6b0aa3,0x12921010,0x17c91543,0x1d041a74,
0x22201f84,0x26b5246b,0x2ab828cb,0x2e202c84,0x30c82f80,0x32e431f6,0x345333c9,0x350634db,
0x34ea34f4,0x344034a1,0x331d33cc,0x31833252,0x2f463067,0x2c5a2ddf,0x28ba2aa0,0x24e426d3,
0x20d222cc,0x1cac1ec0,0x18891ab2,0x14461686,0x0fa711fe,0x0af20d4e,0x0625088c,0x017103cd,
0xfd30ff33,0xf85afa9c,0xf37cf5f0,0xeea2f102,0xe9c1ec34,0xe4e9e72f,0xe02ee27a,0xdbe7dded,
0xd827d9f9,0xd538d6ab,0xd2c6d3fa,0xd0bcd1b1,0xcf52cfeb,0xce53cea3,0xcdabcdeb,0xcdbccdab,
0xce3acdf4,0xcf39ce90,0xd0dfcfdb,0xd2e4d1b8,0xd57ed42b,0xd862d6fd,0xdbafda05,0xdf4fdd88,
0xe3b9e186,0xe865e60c,0xed1cead6,0xf1d5ef79,0xf68cf415,0xfb85f913,0x00fbfe4b,0x06750377,
0x0c390972,0x12190f48,0x17a614d8,0x1c9b1a41,0x21441efc,0x25202338,0x28992706,0x2bc22a70,
0x2ebd2d41,0x30ed2fb2,0x32ad31e6,0x33d53362,0x34043408,0x33a533e4,0x32b53350,0x3194325d,
0x2feb30b6,0x2d8e2edc,0x2a9f2c2d,0x272f28ef,0x23562554,0x1f252146,0x1aaa1cff,0x16271864,
0x118f13d5,0x0d060f50,0x08a20ad1,0x0403065c,0xff4801b0,0xfa42fcf4,0xf4d1f779,0xefb3f232,
0xeacded16,0xe5ece84b,0xe165e3a0,0xdd23df52,0xd976db4f,0xd66ad7de,0xd3dfd501,0xd1b5d2ab,
0xcfc3d0a5,0xce82cf0c,0xcd76cde0,0xccd9cd30,0xccc1ccc8,0xcd0bcccb,0xce07cd64,0xcffdcee4,
0xd2d2d150,0xd636d46f,0xd9dfd81f,0xdda5dbc8,0xe1bbdf9b,0xe62ae3d4,0xeb12e88d,0xf04eedc3,
0xf5c2f317,0xfb15f862,0x008cfdd3,0x05e502e1,0x0b6308a7,0x10ec0e2f,0x163a1395,0x1b4a18df,
0x20431de2,0x24ad2290,0x28b326c9,0x2bd72a66,0x2eb52d64,0x30eb2fd1,0x32b531d3,0x33ec3354,
0x34763456,0x34413492,0x335633e5,0x31b032ae,0x2fa430ae,0x2cfb2e58,0x2a302b87,0x2738289d,
0x23f5259d,0x207b224c,0x1ca01e9e,0x18531a8b,0x13ad1613,0x0ea0110c,0x09630beb,0x049306f7,
0xffe80232,0xfb3afde5,0xf66ef8d3,0xf185f3de,0xece1ef36,0xe86eeaa4,0xe43ee65f,0xe024e218,
0xdc27de1f,0xd892da49,0xd559d6dd,0xd253d3c6,0xcfc4d104,0xcde1cecf,0xcccbcd35,0xcc76cc92,
0xccc9cc94,0xcd6bcd0b,0xce93cdf4,0xd01dcf3b,0xd214d111,0xd4e9d371,0xd868d67f,0xdc34da52,
0xe01ade22,0xe426e20d,0xe85de636,0xed36eab9,0xf25defa7,0xf79af4f8,0xfd17fa64,0x02580003,
0x08770577,0x0e690b5b,0x1400112a,0x195c16c4,0x1e821bf4,0x234d20f4,0x27bf25b9,0x2ba129b5,
0x2ea22d2c,0x30ed2fcf,0x328431d8,0x33903300,0x33e333c0,0x33ec3401,0x33af33e3,0x32ae3336,
0x31563214,0x2f4a306b,0x2cc52e3c,0x29cd2b50,0x2682280f,0x22d3249a,0x1f1320f4,0x1ace1ce4,
0x162d188c,0x112713bf,0x0bee0ead,0x06a4095c,0x0189040e,0xfcedff08,0xf7b1fa48,0xf295f53e,
0xed7ff018,0xe897eb24,0xe3e4e611,0xdf7ce186,0xdba4dd67,0xd883da01,0xd5bcd70d,0xd35bd47e,
0xd138d22d,0xcf88d059,0xce70cefb,0xcdf0ce2e,0xcdeecdbe,0xce11cdfa,0xced3ce96,0xd012cf4b,
0xd191d0c5,0xd3add2a8,0xd655d4d7,0xd98fd7c2,0xdd68db6c,0xe1e6df97,0xe6cae447,0xec1fe978,
0xf166eeb8,0xf6d5f428,0xfc36f987,0x0160fecd,0x069703d0,0x0c14096b,0x11720ed4,0x1696141e,
0x1b7d1931,0x1fea1ddb,0x241621fd,0x27cc25ef,0x2b3e2998,0x2e442ccc,0x30cf2fb7,0x328931e5,
0x33b53340,0x344e33f6,0x345d3475,0x3401342e,0x32eb3365,0x31423235,0x2efe3038,0x2be32d90,
0x282e2a0a,0x2408261b,0x1fe1220a,0x1bef1de1,0x17c219d8,0x138b15b5,0x0f3a1175,0x0a890ce1,
0x05910839,0x005d0311,0xfba6fe39,0xf669f8e2,0xf116f3ae,0xebb2ee58,0xe65be907,0xe158e3e3,
0xdd02df2c,0xd951db11,0xd67fd7ea,0xd3ebd538,0xd1afd2d7,0xcfb9d087,0xcdd8cebe,0xcc5acd26,
0xcb69cbce,0xcb00cb0a,0xcb9acb48,0xcd15cc50,0xcf8ace26,0xd271d0cb,0xd5b5d403,0xd94bd791,
0xdd21db29,0xe10adf11,0xe53de32f,0xe9eee771,0xeef6ec47,0xf46df1b2,0xfa04f72f,0xff88fcca,
0x04970200,0x0a23076f,0x0f8d0cc7,0x14fc123c,0x1a34179e,0x1f241cab,0x23712163,0x2748255e,
0x2ab828f4,0x2d7e2c15,0x2fda2ebd,0x319030a2,0x3292320c,0x331b32f0,0x33083324,0x329e32e2,
0x31b73232,0x3061310a,0x2e852f8a,0x2c4b2d7c,0x29852b12,0x261d27c4,0x21ee23f6,0x1daa1fe9,
0x19951b9a,0x1552177a,0x1101133b,0x0c820ed7,0x07e10a4c,0x02fd055f,0xfe3a0046,0xf8dffb7a,
0xf3eef694,0xef31f1b9,0xea9becfc,0xe637e876,0xe22be428,0xde00e00f,0xd9fddc07,0xd679d82c,
0xd36bd4e8,0xd0dad221,0xcebecfaf,0xcd27cdc7,0xcbd7cc60,0xcb51cb91,0xcb6bcb1f,0xcc1dcbb7,
0xcd9accbf,0xcfa8ce92,0xd267d0fa,0xd584d3fb,0xd8d5d724,0xdc89dab2,0xe0abde85,0xe55be30a,
0xea95e7e3,0xf01aed4d,0xf611f314,0xfc49f93b,0x0229ff66,0x07e304cf,0x0d540a93,0x12e21043,
0x185d15a8,0x1d841b01,0x222c1fd4,0x26452459,0x29d52824,0x2cf12b8b,0x2fc22e6d,0x320b30df,
0x33ba32e3,0x34953453,0x34fd34b1,0x347634a8,0x339a3420,0x322232e8,0x301b3112,0x2d602ead,
0x2a1e2bbd,0x26b02883,0x22eb24f0,0x1edb2111,0x1aaf1cea,0x16371876,0x11ad13ff,0x0d130f78,
0x08820ae1,0x03bc0620,0xfeff0157,0xfa80fcf3,0xf5c8f80d,0xf155f374,0xecdeef05,0xe8bdeabe,
0xe4bae6b6,0xe0fbe2d5,0xdd31df10,0xd99bdb5a,0xd632d7c0,0xd327d4a0,0xd0ced1d1,0xcf06cfd4,
0xcdd4ce5a,0xcd3dcda2,0xcd1dcd17,0xcd7fcd40,0xce6ecde1,0xcfe7cf0c,0xd201d0e8,0xd4abd334,
0xd7a1d605,0xdb14d962,0xdedfdcee,0xe2eee0dc,0xe729e507,0xebb4e978,0xf093ee21,0xf622f35c,
0xfbebf8f9,0x01acfed0,0x075b0456,0x0d0e0a3f,0x12ca0ff6,0x185f1588,0x1dc81b26,0x23002072,
0x27aa2560,0x2bd229b9,0x2f252d8f,0x31ed30a7,0x3412332d,0x357834ed,0x361935de,0x36063603,
0x352f3589,0x341434c1,0x32783365,0x30253161,0x2d4c2ecb,0x2a1c2bb7,0x269f2875,0x22da24ca,
0x1ed920e1,0x1a8b1cd2,0x15fa1853,0x112a1399,0x0c140e79,0x06d9096d,0x0181042e,0xfca5fef0,
0xf726f9c7,0xf1def489,0xed0bef60,0xe87eeab9,0xe461e66c,0xe088e244,0xdcdbde95,0xd97cdb34,
0xd6a2d7f3,0xd3e7d52e,0xd19fd2b6,0xcfffd0b1,0xcef1cf61,0xce9bcebc,0xce73ce81,0xced6ceb1,
0xcfa8cf34,0xd0f6d04d,0xd2b3d1bc,0xd4ded39e,0xd75ad5e8,0xda1bd8a4,0xdd6ddbb7,0xe113df17,
0xe517e30c,0xe9d1e777,0xeec1ec49,0xf42ff198,0xf9abf6e3,0xff0cfc4c,0x03d901a7,0x094906d9,
0x0eb90c18,0x13ea1133,0x18fa1669,0x1de91b7b,0x2267202f,0x26a82496,0x2a792899,0x2da12c1b,
0x30642f13,0x32743186,0x34033362,0x3515349f,0x3548351e,0x34bb34f4,0x33823423,0x31d132e2,
0x2fa930c7,0x2ce22e5b,0x29f22b82,0x26922847,0x22b024b5,0x1e6a209b,0x19e51c36,0x154d17ad,
0x10b512f9,0x0bee0e5f,0x06dc0995,0x01cd047b,0xfd06ff42,0xf779fa11,0xf21bf4b2,0xecf1ef64,
0xe814ea90,0xe388e5de,0xdf04e124,0xda9ddce6,0xd6a4d8a0,0xd320d4bc,0xd062d198,0xce76cf5a,
0xcd6bcde1,0xccd0ccf3,0xcc9dccaf,0xccc2cc9d,0xcd54ccef,0xce59cdce,0xcfddcef7,0xd1fcd0ea,
0xd4ccd360,0xd829d676,0xdbeeda1b,0xe025de23,0xe48de267,0xe92ae6df,0xedddeb7f,0xf2a9f031,
0xf78ff51d,0xfca5fa1a,0x0181ff22,0x069903c3,0x0bb9092b,0x11360e70,0x169513d8,0x1ba1193c,
0x206b1e45,0x24bb22aa,0x2854269b,0x2b6129f0,0x2e142ce1,0x30422f29,0x31b9310c,0x32b83232,
0x32f832e2,0x32c832fe,0x32103289,0x30cc3187,0x2f07300a,0x2ceb2dfb,0x2a412ba3,0x278a28fc,
0x24862625,0x210722b3,0x1d0c1f13,0x18971ae9,0x13ee1655,0x0f5511ac,0x0aba0d13,0x0624085f,
0x015a03c8,0xfce7ff15,0xf7a2fa2c,0xf250f4ed,0xed47efa1,0xe829ea92,0xe3b1e5e5,0xdf9ae195,
0xdb9edda4,0xd7e5d9c1,0xd47dd626,0xd169d30f,0xcf51d052,0xce22cea8,0xcd64cd9e,0xccf7cd0c,
0xccf0ccd5,0xcd61cd15,0xce5ecdba,0xd011cf1f,0xd277d132,0xd57ed3df,0xd8cad70d,0xdc50da8e,
0xe029de43,0xe49ee25e,0xe96be708,0xee61ebfa,0xf369f0e6,0xf868f5d7,0xfdcdfb15,0x0311007d,
0x08950604,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,
};

const uint32_t sample_16_standard_DRUMS_crash5[6784] = {
0x00000000,0xfda9fe05,0xff1d0155,0x01f30ae5,0x05c9fa87,0x003c108e,0xfb01fe3c,0x0a54f331,
0xffd0f941,0xfd35f983,0xf9f00b94,0x013b138b,0x0bdc0a84,0xff67fcf0,0x03fafc6f,0xff07f746,
0xf85ffc57,0xf78a0e0b,0x1103fc6b,0x09dee8bd,0x0436f065,0xed110329,0x00e00fe1,0xf61cf5d9,
0x0035014a,0xf8bb0866,0xfe2bfb97,0x080601f5,0x1336fb5b,0x0570fb07,0xf5240821,0xfd960015,
0xff151442,0xfda30aaf,0xfe22f3b7,0x1b8de705,0x0ef3f0c3,0x07d31a00,0xfa840e85,0xf2fbf3ec,
0xdae2e96c,0xe97cf26b,0x0b9300ac,0x2026080c,0x12d31833,0xf8371d3b,0xf64f038c,0xe4ce0186,
0xef3af9f7,0xed6ce5b2,0xfbc6e889,0xffc204be,0x11281fac,0x191109f7,0x16fe1539,0x1a3609e7,
0x0e0d0245,0x10b711d6,0xfa42f352,0xfc6ffe04,0xce9dd946,0xcedae03c,0xe95eca56,0xf094df05,
0x1aa8f28b,0x0c431b97,0x2ef40e8a,0x21350e34,0x1e32218d,0x0e7c2437,0x243e044f,0xe56df334,
0xe446ffdd,0xe275ecec,0x0068e92d,0xfa45cf5d,0xef15142d,0x0f32e9f3,0xfa2d0289,0x076b1aa2,
0xf3e10874,0x283b090c,0x3c7d11c6,0x12db154d,0x04a207b1,0xf455edfa,0xc064dade,0xd515f5d2,
0xdc5bedd2,0xf6abee70,0xfdefe1ad,0xe66216fd,0x21541d2c,0x425d1d08,0x2f821b67,0x160a0ecc,
0xf4dd1493,0x042ad9fc,0xdaefea79,0xf3e3f5a0,0xfa01ec26,0x1354dfdc,0xec5dff1e,0xfc9e0284,
0x13770878,0xe3c611bf,0xf4a4132a,0x10da0288,0x0048fa26,0xe2232a22,0xf68b0983,0xefd7f90b,
0x0577d2fd,0xfb9c01e6,0x1579f201,0x1ba509af,0x26252cf1,0x11c01683,0x07190a1d,0xfffee40c,
0xf93d04ba,0xfcf9d3fc,0xd87bed30,0xca0ff1a6,0xd454f55b,0x01b9ecfa,0x21c2f3a7,0x23240aa1,
0x126a10c4,0x04a4312a,0x11c82f84,0x04a21dbf,0x11b2e370,0x1ce2f159,0xe2ffe3ab,0xdc0cf3d8,
0xe8f2f19e,0xf9d6ce74,0xe104ebb6,0x0df309d1,0x1921fbd4,0x22d30312,0x23e73b85,0xfa6e39cc,
0x0fd11fad,0xfece05f2,0x1e76fe5e,0xe039d69e,0xe72adb20,0xc06edc58,0xeac2e1b7,0xf1c1c7b4,
0x13a7e616,0xf8390fe6,0xf49a41b1,0x36582318,0x21da260b,0x00930e69,0xf50ff81f,0xf92efb1c,
0xec8a22a6,0xee881430,0xeee831ee,0x1e47db8f,0xf410e9dd,0xf437e47b,0xf8c0d73d,0x032c0445,
0x06c3ec31,0x07a4efb7,0x3f34cd48,0x1058ec76,0x0bb7f24d,0xea671c1a,0xf1b11b0e,0xdf811a65,
0x0c6f05f4,0x117ee9bd,0xf2290e0a,0xe3bb2436,0xf06f3992,0x2a1606ef,0x18a9d65d,0x0566f88d,
0xdd690cdc,0xdd50185f,0xce88004b,0xf672e5f4,0x0b85ea55,0x0ce1ed04,0xfb5af71d,0x0903393d,
0x0422223c,0x0903117a,0x149de339,0xdc0c03c3,0xede00d7d,0xd27906ed,0xffa80b69,0x1fe5ea66,
0x2693fbe4,0x1f16e695,0x1d8ddefe,0xcca4f8e2,0xcac944c5,0xf6e021ec,0x1933e659,0x0e22da29,
0xe2461c63,0x016c1089,0xf5ef1882,0x157c0a5b,0x1030cbdc,0x1556f6b4,0x10f6c9ba,0xc43219f9,
0xf83d22c1,0xe16a2396,0x2d8ff19b,0x1bc7e633,0xf6eaeb56,0xddb91696,0xd02b2782,0xf0671993,
0x03a20d89,0x4761e009,0x053bdbad,0xe9412387,0xde00223e,0x07d40695,0xd8fcf8c0,0xe7a30746,
0x116d130f,0xf31013bd,0xcbd7fec5,0xb4a44b49,0x193004df,0x0dcfed4e,0x16a6fc3b,0xeae4fb42,
0x01d9125b,0xee3f01e4,0x2adf107a,0x3abad25b,0xff87da51,0xeed004c8,0xe0081e39,0xe1571373,
0xe59a2278,0xfe4b0163,0xf38f08fe,0x2fb2e97e,0x3135f9d9,0x5915a7d8,0xe926d115,0xe26a28c2,
0x0ab6eb2e,0xf1f8fa60,0xe50303b4,0xa3553989,0xe4c534fa,0xfd721799,0x272ef629,0x15451fb7,
0x2e0fe85c,0x1054f77c,0xe8761602,0xeb5d1305,0x5825d6da,0x11569105,0xbdb3f82f,0xe876eee1,
0xf0a00bca,0xfb54082a,0xd28f5d3f,0x2bbe15e5,0xfb00f980,0xe7e41fc3,0xf7ae1b2a,0x10d80282,
0xf923e567,0xb7d23418,0x08d60d13,0xe5e02a4b,0x07d300d8,0xec32db98,0xee5ef504,0x148cfde7,
0x3570c166,0x0f0df18c,0xf25d27b9,0xe9a11580,0xf80813bc,0xdcc218db,0x22142916,0x186eb04a,
0xec490b40,0xfb840b8f,0x1e490407,0x2685ca8e,0xf918ee0e,0x01ab0476,0xe103f0b1,0x18e50374,
0xea92013b,0x080c223d,0xe842e83e,0xfe711fb2,0xf833f592,0xf12021b3,0x3856eeed,0x04cfdd80,
0x25f81449,0x1e1edc84,0xf2de0158,0xca041beb,0xe6742529,0x05eeddb4,0x20a8e96e,0xf43bdf0e,
0xef2ffd4b,0xf649f53b,0x186e1037,0x45d9baec,0xf33d082a,0xe7774b59,0xd3fa530a,0x2a010c79,
0xebf2f198,0x09ba106e,0xff07bdd0,0x01f6d89e,0xcea7e5e9,0xdef74f41,0x075beb43,0xd5111f95,
0x047a0b40,0xf90f2854,0x2fecee7f,0xe4b504aa,0x0cfa286d,0xf0cc0f71,0x27cf0157,0xf813e850,
0xeee70975,0xe271fbc6,0xf5b6e751,0x1a95c312,0x09fe1490,0x33b8cedb,0x1018e845,0x088df78c,
0xd3cd3d37,0xffcb1476,0x1337ddc9,0xff60f569,0x07be078b,0x02021725,0x25e1f989,0xee5b13dc,
0x1cdd123b,0x4e32c9c8,0x119ca559,0xde450c7b,0xecd3ec82,0xf438e4f9,0xf247f2c5,0xe6d9f5f5,
0xee1a10ad,0x3881fcd5,0x085a146d,0x1e6907d5,0x22430e4c,0x2219fe6c,0x1a90f178,0xfb63ff9e,
0x0cc5cfd3,0xaa26f92c,0xab855012,0xe2381b31,0x2c51e5ca,0xf557f5e3,0x1e1be20e,0xffdafbad,
0xdd432536,0xeb153240,0x1a290176,0xddf50ab2,0xc4083c8b,0xf0052c71,0x0963059e,0x2560dae3,
0xcd890f91,0xc4173099,0xb61d3bea,0xe97c148a,0xe88e17dd,0xbe4b1c8a,0x12841691,0x1123e802,
0x0cd60ffb,0xefd20562,0x1eb4eaa3,0xefb8085d,0x03431249,0x3cc2dcb7,0x2f51b730,0xf5030713,
0xc8e32572,0xfc422e7e,0xde50e24f,0xe69b3e21,0xda88fc14,0xf4dc0526,0xfae3f950,0xccb73512,
0x0ac62f7f,0xf90df1b0,0xd08e325b,0xec30046c,0x1e5ef8d0,0xeda4e2b5,0xfda33aba,0x01aae623,
0xfd062a85,0x0a77e0f2,0xcd0918f0,0xfc32002b,0xf959ee55,0xf26b366f,0x19e9fa76,0x203cec48,
0x0a6dceef,0xded309b8,0xf60f100b,0xdba131eb,0xd2480f42,0xe1964398,0xc1132021,0xe14b3e96,
0x1cb2f1b4,0xf79001f5,0x2db1cf98,0xd166daf9,0xc9e234bf,0xacbf5a7e,0xfd214917,0x0daeda44,
0xf6a730bc,0xe04d0b25,0xe569304c,0x1d94f544,0x3333cf75,0x4989ac6b,0x0706cacf,0x281bf849,
0x439ecfb9,0x2825bf15,0xee80ed3b,0x0079198c,0xf824ea58,0x0f47f0cb,0x059ce6c0,0x0dcf0276,
0x21c0f2da,0xed682159,0x0bdf0ede,0x175ce2a0,0xf8efef52,0xe3ed043b,0xf6c81243,0xf3a00849,
0xf654ef46,0xa7243871,0xca705783,0x0aa60115,0x1289ecd7,0x1dec052b,0x35fcdf1a,0x0889e790,
0xca36113a,0xeb40266d,0x41a6f2c8,0x2879a1be,0xcf10f7c7,0xfe723e5c,0x0ce2dde7,0xf4500422,
0xecb20547,0xf5d029b8,0x0908e053,0xcb222590,0x01221c22,0x085af6dd,0xfca90ab6,0x043fe19e,
0x175e15a1,0x59f7c911,0x5aa8a04e,0x143dd5f3,0x162d0dfd,0xfaf2c17a,0xc9372c83,0xefd0fab8,
0xe1fc14e7,0x038f0a1e,0x0e3ae807,0xdaf93559,0xd45d13b9,0xe0b43e64,0xf3c026f7,0xe6a425ad,
0xe927eedf,0xcf641d6c,0xcfa81aeb,0xf2f14003,0x3601f05a,0x1bcbc09f,0xee390fb5,0xf6601100,
0xfb3300d3,0xe499f53b,0x02da137c,0xf9f9f3a1,0xb81b24fb,0xe2b45959,0x146efd31,0xfd8cf37a,
0xcdc20296,0xfac03588,0x4eb9d332,0x0facdadc,0xfdeafa7f,0x06481d01,0x1751eadf,0xcb7fe957,
0x0e98fc69,0xd92802a1,0xebae1f4d,0xb2093828,0x1da7322c,0x5688be1c,0xf86ae512,0xc9051fb1,
0xe2573fe3,0x0fadee2e,0xb19a1d27,0x4f8af2ae,0x35d6bbc5,0x1de0c337,0xd4e81a93,0xf20633da,
0xf92b1351,0x3231e18f,0x1b98c50b,0xce082645,0x14f3fe2b,0xbbbf1ec4,0xee171ccc,0xd92f3f76,
0x3f21e8c9,0xfc24cb4a,0xb40b1e0b,0xa09e544f,0xe1053be6,0x11da077f,0xc91126c9,0x18dd1727,
0x02dce2f7,0x1894063d,0x1cf2d77b,0xdbfd0388,0xc3f5471e,0xb61e21b8,0x0059200f,0xfaee00e4,
0xf7ebf4a9,0xe2c6325f,0x326ef585,0x0f7fe860,0x2d4af420,0x1251e9d0,0x1a74dffb,0x18b0e723,
0xfd7adc5d,0x3302c97a,0xd07a085f,0xbd6e25a8,0x0de019fa,0x4ee8c719,0x1138f025,0x4266eb01,
0x1d98f490,0x0c83e4c8,0xfd2a118d,0x0cdd0ab1,0xefd8d271,0xa119361b,0xe520131f,0x1da3ebb1,
0xdf15ea48,0xe88b389b,0x1868fb5f,0x0a1a2cdb,0xed14f623,0xc50a4209,0xfdc93762,0x1e21c5fa,
0xf1dde77a,0xe268f519,0x21ce1c01,0x6054b1f3,0x5836a29d,0xe77bd4c7,0xf84d38e4,0xef820e8f,
0x011006eb,0x4042dd3f,0x108fddbe,0xe4fe099d,0x9f242da3,0xe5755cba,0x0ee9e430,0x23a7e1d0,
0xce5fdfee,0x39ce2489,0x70889783,0x19b1c518,0xbedd2257,0xf3d9377a,0xfe7404ab,0xce031969,
0x04152d6b,0x37e6cd87,0x3bdcc424,0xd4cfed4d,0xec2b4d2e,0xe97ff1b9,0x0eb5fc6f,0xde92ea5e,
0xdd131f95,0xedee1712,0xd60f296a,0x545b1063,0x1fa8bc4d,0x2edd06ae,0x2072ce2d,0x12100aa7,
0xf449da50,0xd14eed93,0xba97543b,0x3182c704,0x02e8d517,0x02ebedbd,0x330013cb,0x1be5e0de,
0x1da71946,0x13f6ec9f,0x1c1404ef,0xd53013f5,0xfba0fd77,0x17310e48,0xee3fdcb5,0xe9d41062,
0xedc6edb5,0x30f303e4,0x16b4a375,0x11fffade,0xe7a4e2d1,0x5790ec20,0xf1c3f23b,0x1e8cff5e,
0xd5fc2726,0x1c061360,0x142beff8,0xef07ea89,0x2e5102da,0x36c4ab0b,0x4e03cf62,0xcd3deeb4,
0x3efc1e70,0x0eb8cabe,0x1c7fece3,0xa1650aa5,0x25f0020b,0xe04c0554,0xbd621e7f,0x27e835b6,
0x0c73e395,0xe812fe4c,0xa46b24e8,0xadf46a57,0xbe2042fa,0xf26c2cbb,0xbfd937d7,0x3e06eb3e,
0x024e21ea,0x0234e531,0x4c51eb14,0x42309893,0xb35ee850,0x8dfa7207,0xe31f6982,0x0f6dec20,
0x0e750d2f,0xf6f90efd,0x18debff1,0x40991a0e,0x3259aa41,0x35d9dab4,0x1d32ba0e,0xea3a0adb,
0xf8b41028,0x3e68d806,0xdfa6eeea,0x1057f823,0xf8f01799,0x0446c3b1,0xf44125d7,0xd3d717a6,
0xfb813ca4,0xf36bf8a3,0xe32c3a13,0xd97630fc,0xfde700a0,0xdf12fcdc,0xec651090,0xdd002c9b,
0xd86302f9,0xe8722443,0xd75b1e37,0x14cc1382,0xa6f7fdbd,0x05ce413a,0x03cc051b,0x1b9509e5,
0x157ee5ac,0xe72a0bce,0xdf931e15,0x17fae9df,0x2290ef98,0xe68edfb0,0xef6659f0,0xef20f2e3,
0x08afecc8,0x943c2933,0xd99b4c2f,0x393bf2d1,0x5547baf4,0x2cb2ca27,0x1d0bbeaa,0x09881259,
0xecc4f271,0x17dc18b0,0x1690c765,0x9d69331c,0xb4366b50,0xb12d351b,0xb3305a01,0xc5b83121,
0xe7593e2c,0x51fdaf66,0x143a0186,0x3494b828,0x03ccf965,0xf6100a4c,0x20eb1704,0x2538d060,
0x4b8aba5e,0xcd19e6f6,0x08991287,0xbcce1f46,0x127d05d7,0x255efccf,0xf98adbf0,0x19db17d9,
0xd93bcb72,0xd11a59bc,0x1314f458,0x4d75c18c,0xccece24c,0xe43e60ee,0xed321a56,0x3307dae6,
0xf98c096c,0xe421fa1b,0x06582c98,0xf685c67d,0x10292a62,0xe4bbeb39,0x08511be7,0x210ad763,
0x3f38cf9c,0x24a0d04b,0x2302b611,0xd3d6079d,0x0e0f00b5,0xf6b73e68,0x3618c5a5,0xf68bf3d7,
0xe69b2d03,0x303ceeb6,0x3fb8b510,0x1d23bd06,0xe59c1ac9,0x69e3b0ab,0xe53bdf9b,0xf40c2ace,
0xe870352b,0x04a4027f,0xcc9d1c76,0xc1131d32,0xf1d1270a,0xc69309e7,0x081327b1,0x01c0f56a,
0xd77e096c,0xcd5a4bda,0xca1815aa,0xbc3b7207,0x2cb7d5e4,0x2004080c,0x241ebc2b,0x1257f041,
0xc6cf16a7,0xdf8026e4,0xde3f07dc,0x34bbe48d,0xb4900acc,0xf574422a,0x04882810,0x1b16c061,
0x0a02321c,0x0315caf6,0x1ec60b44,0x1739ceca,0x3b76db3a,0x3814ac67,0x1f64cb36,0xdf0018bc,
0x2700dc3c,0xe2b31909,0xf5e6eb9d,0xfd1647f6,0x1d3cd3de,0x346f0573,0x0197b8cf,0x02e0245b,
0xda5e0999,0x0ed101a4,0xbe99fa14,0xf11d203b,0x1cc7fee9,0x434daee0,0xe2de1169,0xd5851759,
0xfba334cc,0xe497d5fd,0x2594293b,0x1eb1dd1d,0x2455e608,0xe200ed95,0xdeca40ce,0x10fc075b,
0x1100cc01,0xe9f92539,0xc906eeff,0x27b6222b,0xf0cdbd50,0x2dbc1487,0xc6be0fdd,0xea084adb,
0xc796fedd,0xf72c4d07,0x14941237,0x2c36bade,0x21fcf298,0xc048f43f,0x45fe0ffa,0xe225c380,
0x02291602,0xef7af7cf,0xda982652,0x8dfa51aa,0xbf867207,0xf33d3c45,0x396ec4ef,0x09690016,
0x0c7df09a,0x3064d529,0x062def01,0x1083d214,0xf317fe3b,0x6c74c522,0xd082ea24,0x0492124b,
0xddd62341,0xcfa34554,0xa65c2d05,0x8dfa7207,0x1fd83e34,0xf880d5a1,0x0288197f,0xfac1e4c8,
0x00d6f33e,0xd79834ba,0x2d84caf6,0x2d32ee1a,0x41b6b3a9,0xf36bfd57,0xfc6b176f,0x3fd0e6cc,
0xfebadc22,0x2744ecbe,0xc6fb188f,0x1f61ea99,0xb4d231ad,0xcbc12694,0x4159f868,0x1810c095,
0x3dc0f9de,0x31099826,0x319be918,0x05f4e887,0x18a9dada,0xfd673464,0x10f7df8a,0xcea73159,
0xcc6321c6,0xf89c441d,0x2b27b19c,0x0bcb09b9,0xe929bcdb,0x218e147a,0xe0b7feff,0xe1201e3c,
0xe6e91f83,0x0103ea3f,0x34d1ef13,0xfaefe3de,0xc4cc64c7,0xe59c1502,0xce5d417c,0xd6892251,
0x4a9be95d,0x0206c007,0x8dfa36c0,0x93077207,0xd11168d9,0xf1c40b1a,0xe8f9ff0d,0x2e911c36,
0x371da039,0x4bbdd763,0x4490a43d,0xc4d51273,0xb44c471b,0xc08b4ed3,0xf8fd0081,0xf2501901,
0x0105f920,0x0e0cfd9d,0x121901cb,0x1851e8b8,0x3177d821,0x0dddd4b2,0xdbad2a2c,0xc7f507c4,
0xcab546bc,0xf86b0ca2,0x0dc11aa5,0x322ec9a2,0xcb490d70,0x093a1fbb,0xe8c6f56e,0xe6eb4845,
0x2d16c40a,0x37c5004c,0x67f88dfa,0x26c5be17,0xf715e372,0xec07158f,0xeb021313,0x21650d14,
0x294bc9fb,0x2207d01c,0xad3a291d,0x8dfa5519,0xe9305f38,0xf5f9f672,0xe0d53183,0xee1cfae7,
0x108d11a3,0xe4d4f37a,0xf36931f4,0xc40f180d,0x1da20dd6,0xfe4fe6a5,0xd2181bae,0x3abd0b4c,
0xf3b2d4a1,0x1d571076,0xf022cd9d,0x45c113d7,0x26bfa63a,0x287aeecc,0xf936de6f,0xf18e0f59,
0xc90939b3,0x003c0173,0x2e1c0734,0x0dfca9ae,0xb142431c,0xcf632eb0,0x47d905a2,0x0f02d028,
0x071aee66,0xbcb11bd0,0xef841a8c,0xb453315c,0xf9e83045,0x02b9260d,0x1f57f0a1,0x2e6fe764,
0xffcdd3aa,0x1d89f7ce,0xed2cfa56,0x43d0cab5,0xd9b8e690,0x3f49fbe5,0xd7fbeefd,0x18560e94,
0xaa472410,0xf43b33fc,0x0d72f462,0xe13b2153,0x48b5f9cd,0xa351f836,0x0f8e40e6,0xd4e6ed1f,
0x18360e25,0xd2f8f6e5,0xbc862c5c,0x8ff07207,0xb2315023,0xad497207,0x2627f989,0x0cd0ec0d,
0xed7bf3c1,0x46a7e847,0x0dcbdd77,0x1de9d542,0xac9e3661,0x3efc0a5c,0xf90def07,0x30aae08d,
0xe7f3f051,0xd4eb02e9,0x1fb72047,0xe387cf91,0xc7fd41c9,0x00e61904,0x4115e4a4,0x089be8a7,
0xdf5402aa,0xa3607207,0x13380dd3,0xdb8926d6,0xf9f4fce1,0x1cddeb81,0xe9ecf910,0xfb37f5c1,
0xe6aa16be,0x304aea74,0xe57c0437,0x3339d81a,0xd62018e0,0xeb2d0ef1,0x045f1eae,0xd3f30ca1,
0x04202419,0xcf430804,0xebc022dd,0xcf4c16fb,0x4de5faae,0x19e7c6dd,0xe8e6fabb,0xef9f0f8b,
0xd06d1b38,0x214508ab,0xe093e40f,0xcd5d5dc9,0xab3d30b6,0xe8ef54cf,0xd0d313ce,0xe2e123c9,
0xf1e92478,0xd345f292,0x136323f1,0xf90ccf7e,0x1870205a,0x17deccd5,0x27b0028c,0x11d0bd23,
0xf8baf507,0xf929231b,0xc1591282,0x98967207,0xe65141d3,0x088707be,0xe888e27d,0xe6403e63,
0x1a14d1e0,0x1c6aebee,0x1487e692,0x43add172,0x6783b7af,0x3c9b9312,0xe3ef08a3,0x0b49f823,
0xe2751b09,0xf5e70859,0xd2a21ef2,0x8dfa7207,0xfbfb4177,0xbbcc0a97,0xedd74b36,0xfec3efb0,
0x32d10071,0x2843aaea,0xd2f6132d,0x49e1f115,0xe475c7e4,0xfd72248f,0x09eaf6cb,0xf9b8f566,
0x03b20e31,0x13a6fa7f,0xf6d800fb,0x1a95fdb5,0x2fecde97,0xfe61d9ae,0x181df45f,0xcb9d0ee6,
0x4987f43a,0xb82bec66,0x1d6d3164,0x03eddee7,0xf2620f59,0xe8842154,0xf3e5fa31,0xfa5a1630,
0xbbbd0806,0xf240454a,0x2b68c0c8,0xe98e02a5,0xf1551e4c,0x16a40544,0xdb090ce6,0x1b6f0eb5,
0x2294ee09,0x3968b98f,0xf014ec3e,0xf3720a25,0xf8550cf7,0x0b38edf2,0x48efee2b,0x1971b4fc,
0x392fee86,0xe6bee31e,0xf22b037e,0xe29427cd,0x2338fa70,0xe67df2be,0xfe601fd9,0x0a6cf6a4,
0x0ccdec2f,0x0504094e,0xd0af1a15,0x2ecb03d1,0xf9c8d7be,0x40cbdf6e,0x1583bf07,0x00be0e88,
0x01ecea59,0xca0413b9,0xf09c41ba,0x011fe5a1,0x3e0cf087,0xde3ef645,0x2b03fb28,0xea680313,
0x222902c0,0xd6bdfdc4,0xf2d81160,0xe3fe1d20,0xf17e013c,0x0fc413f5,0xffc8dc2b,0x195d00e3,
0xf0abea14,0x386df119,0x0c72c861,0x0f45f888,0xa7b23d9b,0xefe23317,0x08af2c11,0x41c4c24e,
0xf5b7de6e,0xc4b32508,0xdacf201a,0xefc92009,0x52f2d3cf,0x392bb1d0,0x5c19b45f,0xee4ee7ec,
0xf4531130,0xe9691bc4,0xe5bb1186,0xd7ee0da6,0xd76046a9,0xfa3f11a5,0xee6f1cc2,0x0e79ec57,
0xe268160a,0x493fd255,0x35edc6a6,0x3b49a833,0xf1a8feac,0xf694132e,0x0954fb75,0xeabf20d3,
0x3068e378,0xf5c1f3a5,0xc976079f,0xd9b1551f,0x45bfcf76,0x398bd230,0x2df2aba3,0xfb331c6c,
0x2de9d069,0x443be450,0x34b6a61e,0xc54b165a,0xcca94b91,0x0429ec47,0xe35109ee,0xf852ffc1,
0xda303601,0x2191dc8d,0x02c91405,0x191bc44a,0xccbc35b4,0xe3ed2a45,0xd4912972,0x1e2d1fa3,
0xfd32e06b,0xe72c0bbf,0xb9411772,0xd05c5f20,0x0288d6ce,0x0412107f,0x0e9edd24,0xeab9378e,
0xf635019e,0xeec51dc2,0x0740fdc4,0xcd411fc4,0xc9714283,0xf4dc04eb,0x103e20b5,0x08b0bf4a,
0xe9d92bd2,0xf364e5d9,0x0b8e3730,0x3e53aaae,0x13b4eb9a,0x1608d338,0xd39317c9,0x1956188b,
0x15c8cfa7,0xf5e71a84,0xeff40a82,0x08cf0b8b,0x252dde2d,0x11c3ea4d,0xab910dd9,0xed564947,
0x0f6cf045,0x1f7ffdef,0x0dbdd630,0xd85a134b,0x1a8410e7,0xfae3c0be,0x238919af,0xf39cc28a,
0xef1c3b2a,0xeee20475,0x23d10f88,0x2998cde0,0xfba1f76d,0xddef1e1e,0xfb241103,0xf5b00a53,
0xfaefebbf,0xf0122676,0xed3feb40,0x44d30b9e,0x52928dfa,0x2c6acc1d,0xdd96f1cc,0x3d610670,
0xd7b5eec9,0x176e11f3,0xbc7d3379,0x1f31f659,0xb7fc2c84,0xf18323ab,0x2d1af05a,0xeee1c8c3,
0x0fac22d0,0x0268ca27,0x4bb7f5c1,0xdf23d8c8,0x375d217c,0xcc29f571,0x14a21610,0xfee8ef31,
0xfac8fd8c,0xe2910d22,0xf0791a4a,0x334be3db,0x1a47b492,0x44eeed75,0x001fd810,0x3131df6d,
0xcc471cb2,0x0d23092f,0xe91a12d7,0xf6d10d3a,0x13bf174d,0x403ab191,0xfdbaef75,0xda99123c,
0x319dfaec,0xdf8f00d3,0x45e9d78c,0xef33d7a0,0xfb71eca8,0xa4f0545f,0x19801ce6,0xdbbf147d,
0xdac4394e,0xde3a1570,0x98744e53,0x0dde1c06,0xb5a42acd,0x3846eb83,0xda2afa1b,0x2998ef68,
0xf72c1a03,0xe4a7f1bc,0xcfe74f39,0xd9f3083b,0xd8fc3b83,0xd27b26a6,0x10870a1d,0x0b8af60f,
0x1ec3cde6,0xf56d27a6,0x65f7a631,0xd594057d,0x26badf7a,0xef8c045f,0xf9be0c55,0xfd7a0d0f,
0xe62d06ed,0x194f0065,0x16b6f94f,0x1fadb740,0xe6811df2,0xfb17ed86,0x079b2db4,0x0c57c33c,
0x10f0397f,0x137dc379,0xde8d166b,0xe8c81a5c,0xeecd0405,0x39f5ff68,0x2b769865,0xdd2926d5,
0xf040e142,0x01f24868,0x125fbd51,0xf9062c35,0xe4f9ecb6,0xf1bd4684,0x1e2de76b,0xe8fe0332,
0xf45e2f2e,0xe452e890,0xf9964881,0x02e5aabe,0x16741420,0x226dae84,0xfb091115,0xe478ee89,
0xe393435b,0xe7bd0e20,0xee082c5f,0xb4245d63,0xd6062564,0x138f27cb,0xefc0cf1b,0x0346100e,
0xfe2ce256,0x14010f3a,0xe3e4cb73,0xf9ed4334,0xc7c7f709,0xf90b36d2,0x29e5fe11,0xf1b5d522,
0x12b817aa,0xc2551233,0xdc5f563c,0x160cee0b,0x5deae745,0x010795b6,0xe15d388b,0xd9960ad4,
0xda571f93,0xd19e1d71,0x8dfa463c,0x3aab3174,0x0cb1c24a,0x28cd051c,0xff44cada,0x00fa2d32,
0xf1590cb3,0xfb651f2c,0x4159d34f,0x0a8bbb54,0xd1d32756,0xec6c0fbc,0xf5ff0840,0xfb4403f8,
0x3b91e8de,0x9d700246,0xec26667c,0xe3fc0e58,0xedf41782,0xd37b1a5c,0x0f871040,0x207ddb98,
0xf150f8fb,0xfb60021b,0xba331945,0xe74d3df0,0xdf352a98,0x4706f9a6,0xe874e203,0x12d81929,
0xf497d8a8,0x0b3a1848,0xd9c7f5da,0xfde02524,0x2d16beed,0xf97aeb54,0x112a07e3,0xd3aa202a,
0xdc7832fb,0x029efc5b,0xfa7510a5,0xf104ecef,0x0f0f165a,0x0844fc6f,0xeea40f78,0x1f83e216,
0x2e2cedfd,0x308cb13d,0x04e0fc28,0x16b1da57,0xed83f950,0x20c90384,0x0558f8f5,0x1baf080c,
0xfb85e91a,0xf06e1420,0xe9c7e7fd,0x038a3b94,0x3a13ac03,0x1972d678,0x03f8e777,0xd9dd236d,
0x1c0afe37,0xf0091bab,0x3331f007,0x2e5aba39,0x3349ed63,0xf65cc3d2,0xf23f2a99,0xcfcd14b1,
0xe1ae2553,0x149afcf0,0x2c73e4db,0x1f9ccb11,0x1325efd6,0xe0200359,0xd6ea1db9,0x29fb1ba3,
0xfc1dd5b0,0x286bec67,0xa42a0329,0xd0c96d46,0xcec919d4,0x257f1bac,0x18fad897,0xdf542215,
0x2479fa4e,0x1835d334,0xfad303c4,0xc2bf0891,0xdfa4347d,0xff97f102,0x06c3137d,0x0ca5ed09,
0xc8e90cd3,0xb1624e9e,0xcd8940f9,0x075d1a8f,0x2e6eeeee,0xf6bff208,0xe6e91d87,0xfa900762,
0x0a0b18a9,0x3209bae4,0xe9b10db8,0xffc3deae,0x176fe558,0x1b2fd5b8,0xc88e16ed,0xf42f37a6,
0x20ea0124,0x0cee086f,0x4a2ad6b0,0xe0d2ed25,0xf4d719a8,0xc8731b56,0xc9861c3d,0xf72e228f,
0x0c71df38,0xe9ca0dd5,0xcad90aef,0xe2124de9,0xfae60a0d,0xf8bd1475,0xfc7a0c84,0x1c63f3d2,
0x121d0ad1,0xfac4d471,0x9fbf5595,0xd0bf2d69,0xebc32aa0,0xebf0f1cc,0xf9d2199b,0x080fed85,
0xe1fc072a,0x00471f6a,0x3c2fdefa,0x5e2fc7fc,0x38be9129,0xe6402059,0xf90b066c,0xfc211c04,
0x0a24eaae,0x4344eb81,0x37a5a75b,0x2510b2d6,0xcfb8159f,0xfc990129,0x025d25b5,0x1a72ea8f,
0xe62c0c55,0x0474020b,0x21a2fe47,0xf21de1d0,0x3291032c,0xfb5bc640,0x072c0581,0xea930569,
0x01ab0cb3,0x09bb0eb8,0xcf23feb1,0xecd14a75,0x393ec4d6,0x12bb013a,0x0e53cdf6,0xdc4826bf,
0xbbda29b7,0x0b9f1148,0x2d7de723,0x19efcc66,0xcfc9ff55,0xfc6e0f9a,0xf36900a1,0x04a208d1,
0x27a917a4,0x32fed410,0x43f1d1ba,0xbc9af954,0x940d5d50,0xa2a8711a,0xd7212f8a,0xe281ffe3,
0x0e0d0b74,0x36afe39a,0x48bbaf91,0x51e0dc49,0xf044c643,0x2bc51277,0xe229e611,0xcbae274f,
0xf02a256b,0xede7faf6,0xbc3e2d41,0xef502145,0x15ff1567,0x3c2fc21c,0x1da3f7d0,0xf9c5eb6f,
0x07a515ac,0xeb37ead5,0xf922027d,0x8dfa40ca,0xd96e6135,0xd13725e8,0xf81d212a,0xefea1356,
0x374eeb9f,0x6244c35c,0xf9ccaeb2,0xdf3a32be,0xb90c1fd0,0xeec43dbc,0xcee11105,0x07c41d28,
0xf3f0f368,0xe9b61731,0x0557fb6a,0xe79cf88a,0xcc494a5b,0xde940f07,0x3a131005,0x0eedc266,
0x0b410d2c,0xecc9022d,0xca7a3862,0x05d32614,0x14d5df41,0x1b4fe4d7,0x1224ca43,0xf5ec2836,
0x0582cfcf,0x2349f13f,0x04cde390,0xec01fc36,0xc7554853,0x1fbf0b2f,0xf6dcf170,0x0b2a0637,
0xf5c9037f,0x2ca9f6ab,0x1a12ddd4,0xc86f0328,0xf17c2679,0xc4a123b0,0xff151e69,0xed67fdc7,
0x19f9097b,0xfdd2c8bd,0xea6b2819,0x21ed0588,0x1c74d0b3,0x37bbe7c6,0xe847ec7f,0x16e90239,
0x14ede2d1,0x162ef2ee,0xfee6ef46,0x1c22f339,0x381ac0c1,0x0210e3c6,0xedf11c9b,0xf39104f8,
0x17570916,0xd7a414cf,0x1144fa44,0x2403dee8,0x00b3ee09,0xc228268b,0xe86f26c6,0x0dc0f8d8,
0x0130efc9,0xe66c2feb,0xfc29fdcb,0x105cf504,0xceb50874,0xeea134ff,0x1aaf0328,0x416ecc78,
0x0b21d3ee,0x036df334,0xf8e6070e,0x080ceee1,0xbde81fa3,0xe06f3288,0xf8d60335,0xe2272111,
0xf4310fa7,0xd1af2904,0x482dfffe,0x3c49af0a,0x26eec988,0xd74ffc73,0x0f7c1a5d,0xf51304b6,
0xa3cb3344,0xd22d4aaa,0x11c81528,0x29b4b462,0xb95f0c14,0xf1a237ae,0x07f611dc,0x2b7fd26f,
0xed7cec3f,0x2595f9a2,0xfa2b0741,0x059df654,0xdf7009fc,0xef652636,0x0d2f10ad,0xe40707b0,
0xe06b2049,0xf36013e7,0x5c41bb18,0x0258b5f2,0xef401b0a,0xf00a0d6b,0x33bae4bf,0x1aa1ead4,
0xfa28f500,0xdd483581,0x0cc50d56,0xfe45eb95,0x0d050312,0x0ba5e0d6,0x013bf562,0x05dbe406,
0xbb902cd0,0x05281622,0xd1b71144,0xd47831f2,0xd9e9347f,0x306612f0,0xff15d938,0x0f9209c2,
0x37a3d437,0x33b7cd4b,0x1aacbb69,0xcb6f272b,0xdedb16dd,0xe11c1b05,0x0c79071c,0x13d1f408,
0x06ebfa5b,0xf99d001f,0x274dead3,0x5366c9e3,0x280fcce4,0xf2b7e47b,0xccbd2946,0xdd4f1dc9,
0x077009a8,0xf13af965,0x299006dd,0x1bb1c975,0x0d70fef1,0xfe55ef60,0xf43625de,0x16180420,
0xdb08f2b7,0x115b1dbc,0x0bc4cdca,0x117500ad,0x13ebb289,0xe5d019a7,0xf780080c,0x01f61a0b,
0x0920fd68,0x1684f0df,0x1879ffe4,0xcd8202c3,0xf5932f35,0x1129eccc,0x1678f351,0xffd2e9da,
0x0f850e1e,0x042fde04,0xfedeff8a,0xa9540855,0xdb224a0b,0xd91931c8,0x0b691561,0x1c38ef31,
0x09a4ef43,0x1405fd58,0xde38fe0f,0x36dd0b5f,0xccafd065,0xc0035aab,0xc03a1f5c,0xfca43cd1,
0x003be376,0xea0b06b3,0xc3b738e6,0x13f01c83,0x5569d14d,0x1830b495,0x197d0824,0xfed4d959,
0x108c106a,0xbfff00cf,0xefb84858,0xc5a112bc,0xe8d82949,0xe9291ba1,0xf9410925,0x0b23ea26,
0xf9affb53,0xff571312,0xe91bf65b,0x1eb718f2,0xd482e585,0x00452f86,0xf04902da,0x14b6ff59,
0x169de485,0x130df948,0x15c4f0d9,0x18dde8b0,0xf6d20412,0xe5c30032,0xe8f236e3,0xf6aaf754,
0x14caf18d,0xe4b3fa10,0xd52a102a,0xeadc2a7f,0x6166cf8c,0x0308d248,0x468cf3da,0x42a5ca75,
0xff45d6d7,0xfa141471,0xef62ffac,0x3ae3efc1,0xf7ccda74,0x3cf2e34d,0x0452b713,0x20b6f98d,
0xeb300103,0xfb920ccc,0x04fe1849,0x4d81d46e,0x3661ba98,0xf7e6f365,0x039c14ba,0xe5460ad6,
0x1a98f724,0xf14fd71e,0x05b40d85,0xcf380162,0xd46e273b,0x296b1fd0,0x3d3bb56e,0x1652eda5,
0xfc04f78c,0xff8510c2,0x190bf099,0x230ce120,0x0d66efaa,0x3085d782,0xecd1f4cf,0x042ae8a2,
0xd86126a9,0x7207d1c2,0x6d448dfa,0x40caabc8,0x4483c9cb,0x1a12e082,0x28a2d49d,0xd966fbaa,
0x099e1046,0xc76c1061,0xff1118c2,0x114001c7,0x6ecebbe7,0x324faeb8,0xf61be6ae,0x17dc019e,
0x0659ed14,0x2fb4e45d,0xcceada6b,0xb7ce6dca,0xc987460f,0x30e4f167,0xfdb1fc71,0x0e8afb02,
0x001e16ed,0x1ed0c1ae,0xedd8f83c,0xf0121307,0xbc2831a8,0xfe090bf1,0xf7980587,0xc24c2767,
0xef6e1c86,0x8dfa4990,0xb0b37207,0xd3e6403d,0x2cb30a5a,0x6ab2b123,0x311fb8e3,0xfee3f1fb,
0xf34bfbe9,0xfde91357,0xe68af08a,0x8dfa4ee0,0x8dfa7207,0xcb8b6220,0x08f01608,0x12f9ed35,
0x1ac3f4c0,0x6604c4a4,0x5070a238,0x1311dad1,0x08c6fdac,0xc34c14f7,0xb2965bcb,0xddef2b05,
0xf15902c4,0x184cf3f8,0xe38bf3fa,0x01111f96,0x5e7fc385,0x4a8dbcaa,0x3b85c1d6,0x0889e1be,
0x0c68073d,0x136ee1e2,0xe0440194,0xd1b725d1,0xfca515a5,0xfd2aff7d,0x0ae9f5e1,0x0979fd15,
0x10f9f104,0x063eeae4,0x2647e824,0x01f9f42f,0xfa2c0915,0xff14f8a3,0xbaf9278e,0xee743b16,
0x027ff45b,0x2facf2f0,0x3c4eb465,0x0551e845,0x19d9fb4d,0x194fe8c5,0x0d3aefc0,0xe8a305e2,
0xf3291bf3,0x0a55f32c,0xf9fc01fe,0xffa1e1c0,0xf7ed139b,0x290ede96,0x1da7dfa7,0x1e46f1b3,
0x078bf46f,0xffa3053b,0xfa220375,0x2a2af119,0x5032ae77,0x08bec687,0xd9361ee7,0xe9272312,
0x0c8dfdf9,0xe2340a7e,0xe70428b3,0x01e213b8,0x3a50d462,0x1924ccb0,0x018efdf1,0xe754f5c4,
0x02311984,0xf214020f,0xed3c0b41,0x2147faa0,0xf7b1f54e,0xec871814,0xeedf0c0b,0x00940920,
0xf6dbfe91,0x0d8a0400,0x0103e744,0xf7d413f8,0xc01f31ab,0xe36c2e5f,0x0ccb0f11,0xf765f68c,
0xedd20727,0xf31ef3b6,0x02f411d0,0x1b3ae8da,0x1c8fed10,0x1f71dd47,0x1728e43a,0xe8bc10aa,
0xe6690ca7,0xd1793482,0x19dffd24,0xfe17fd40,0xf81bfae0,0x0e5f0976,0xf59af2e9,0x0e7903ff,
0x0a89d9d7,0x36abeb21,0x3546c715,0x1fa1d52a,0x0ae0fb11,0x297de178,0x0bb9f5fe,0x1a83de57,
0x35fedfbd,0x353dc184,0x1ef2eeb4,0x46b8b3fb,0x5049a063,0xee69e51a,0x011e0683,0xf724029b,
0xf99002b5,0xf6761c04,0x059df19a,0x05eb0461,0x28b3f463,0x03fff5ce,0x111fde87,0x1eaef11c,
0x07b7ebb1,0x12fcf30c,0x063de8b8,0xf5d2f61a,0xab93468a,0xecaa39e0,0xfcb80d85,0x0449f715,
0xceb11646,0x29a800da,0x6534a005,0x48049fbb,0xf61bebda,0x06b70fa7,0x58a7c45e,0x0b45dc58,
0x2644ecde,0xf88aef1d,0x0e2e0372,0xf658f2f0,0xd5012541,0xdd042d89,0xfd31056a,0xff2a1035,
0xf387f0c6,0x27cee65f,0x2d3fd491,0x2918cf2a,0x1828ee68,0x27d9eb9b,0xfdfce64e,0x13e6fcc5,
0x2726e2e9,0x12d8c6b1,0xebe31559,0x3265f3bc,0x6188a342,0x1b9dd1cf,0xe9430840,0xe5b2032a,
0xd4ee2b54,0xad923458,0xd1393fdb,0xd1cc40e0,0xd6cc3505,0x07dc231e,0x2752d7e4,0x02bdea03,
0x00cd04c9,0x23c0d401,0x42fcbbd0,0x61a6a81c,0x052ebaf5,0xf8360ebe,0xea3816f9,0xdcdb2eed,
0xeb0d1f5e,0x029b14f7,0xeb5d15a3,0xdfb61c48,0xf004193b,0x158fef6f,0xf7efef66,0xf4ab019f,
0xed8e0290,0xd9e60dec,0xed412bcb,0x1323f6e0,0x24d2eeeb,0x347ddb0e,0x1f5ed837,0x14cafcf1,
0xf5e7f469,0x928637d1,0xed6348c5,0x0861fc04,0x1e29de00,0x01a8ef1d,0xe7f006eb,0xfc7211ab,
0x0b80f273,0x16b7f49f,0x2134f7e1,0x536ec7c6,0x15fdbce2,0x158fe86e,0xe81d13bc,0xfab3fd68,
0xef0f0cf4,0xfb241465,0x2c85e5aa,0x1bd0cdf5,0x3bbee32f,0x1c16d2ad,0x4cd5c6f3,0x2552b88d,
0xfa8af68f,0xe6d92712,0xfc1dfbf6,0x00b918fc,0x2f6acf86,0x22dcd64f,0x2b8dd87c,0xf7aef914,
0xf2fd1759,0x1bb5f270,0xe751ff28,0xda3214fd,0xe91c290a,0xfd60e57e,0xbd5f27ff,0xf3aa1b3c,
0x0e5610e7,0xfb63fef9,0xf42e2554,0x32c7f0c6,0x28f0db0b,0xfa55fb23,0x14fddf45,0x21b8e867,
0x40dfa660,0x1658e24c,0x3a8dc3c1,0x2de1d068,0x1debd6c5,0xfc92ff4d,0xda0f1f17,0x262c0ffa,
0x0b16edb1,0x02bbf388,0xe42f1e14,0xefee057c,0x041d03c5,0xfe84ee04,0xfa9c07e3,0x0b66dcb1,
0xf7c7116e,0xc10211db,0xbcae5b80,0x01cf25d0,0x0096f72d,0xe1d32df7,0x09affc7c,0x102efa90,
0x0370f01f,0xfa6cfe1c,0x1392d853,0xcf4b2261,0xb7d33db8,0xf43733e5,0x18e9eda8,0xddf9182d,
0x0d9510df,0x0e46e601,0x1b70e62b,0xdca2f24e,0xf61c1d3d,0x0d3ae473,0xe27517a4,0x0eb5157f,
0xeb2304fd,0xdf1e2081,0xdc762d5b,0x00fd197b,0xc5991809,0xf58922c8,0x1674eb7b,0x279ee34c,
0x124de399,0x040ff210,0x474bd3db,0x2866b24f,0x2092e318,0x1736e410,0xf0cd138d,0xf5c01b61,
0x2d53ddb8,0x215bdf68,0x2e3cc466,0xdfd3fe1f,0xf22818ae,0xf63d0a4e,0xc68135e0,0xf48e1c85,
0xe4cc0ab2,0xeca92310,0xd48d1566,0x16abff51,0xfc0cf9b0,0x03da0edd,0x1aa7edc6,0x06a3e2ee,
0x12510694,0x11d8f3eb,0x247bcdcb,0xe525fc26,0x178508f1,0x052ae5f9,0xfecb04fc,0xdea41412,
0xf9cd1911,0x0460f54b,0xd92113ac,0x22f3f962,0x05a6f057,0x1b7bf41e,0x041de98f,0x18f0f9eb,
0x0316f9db,0x2ee0f721,0x2260c6fb,0x31bdd618,0x0472e8d3,0xdc9a0ab8,0x02c0149a,0x05d8f24e,
0xff67f24f,0x1320ebc3,0x3b7ad769,0x0457e1fa,0xf92b0949,0xcf21298c,0x02461d4b,0xe38e2377,
0x11f50eaa,0x208dcf8d,0x1cc7e754,0x392fce01,0x42f2a98c,0x3699b617,0x0bdce760,0x0658eb26,
0xec1a0e1a,0x0d2b0674,0xe5bb1176,0x26300364,0x0468e542,0x1411136b,0x13f5dfad,0xfdb2042f,
0x079af129,0xe8befeb2,0x0a53ed15,0xf830ff8e,0x1251f830,0xeab1f36c,0xd1333584,0xccea349c,
0x074e1882,0x270fe774,0xf23d0837,0x04b2090c,0xdf4e1155,0xe039201f,0xe05512c9,0xfcd6010c,
0x00840002,0xea1bfa0d,0xe1672cb7,0x0122fab9,0xeafb23c2,0x02021469,0x28b7e1cd,0x2758ddf4,
0x1f90d423,0xe3570947,0x0a4dff69,0xf06c041c,0x020dfd77,0xf0b90ad3,0xf372fe58,0xeaef1f0c,
0xf6a60a98,0xff670674,0xf53f07b6,0x3869fced,0x22b7cd4e,0x1451e66c,0xdd84180d,0xf0741080,
0xfaf1f6ef,0xeb0bf72c,0xddd21725,0xdeea05fd,0xff912850,0xfa940fcc,0x016b15ea,0xfb550aba,
0x01330646,0xce1715e4,0xe5ab2460,0xcbd123ea,0xf6e71658,0x05abf6eb,0xf938fd4b,0xf204150e,
0xf82b03dc,0x3647eb83,0xe92feaaf,0xd867246c,0xec150bba,0xf0ae186a,0xba5d373d,0xec6d24c9,
0xd6951ac7,0xd35d414c,0x1abb0c3f,0x2880dcf8,0xeeedede5,0xbd2f36f9,0x0b631419,0x19bbd86c,
0x1260e24c,0x1298eb67,0x111ee575,0x09e7f311,0x127c0524,0x2d12eadd,0x1c7adf67,0x1219f722,
0x14dcef42,0x196edbea,0x1ffee3e9,0x1ac0c81d,0xdd670312,0xe91219f7,0xf6b005e7,0x06b91222,
0x07c8ed14,0xe33620e2,0xfc140d7d,0xeb3410c8,0x18c5005f,0x1de3ea95,0x06a9d435,0xee9c0e0a,
0xfa7517b6,0xf7c9fdab,0x016dff8c,0xb02221c0,0xba4d64da,0xfc140b37,0xf10b015d,0xe4180dca,
0xd63f3cd1,0x1e86f9da,0xf5cdf7d6,0xe98122d5,0xfc7109a7,0x151a00ef,0xfb32e1fc,0xf43b0acc,
0x24d0e2bc,0x1c74d61f,0x1b91eab3,0x0da1ec1b,0xd8b6198a,0x0127261b,0xfaddf886,0xfb7906a5,
0xf73504be,0xf7b60535,0x0e2904d8,0x06a6faef,0x11a4e179,0xe70cf8db,0xea8920be,0x1b10f715,
0x221bdc89,0xdd68ff01,0xcd6c36f4,0xd9964324,0xfe7c0227,0x01160257,0xfa6c0188,0x1309e77d,
0x0900e726,0xfe311391,0x0707fbe1,0xfc140288,0x2928ea1f,0x1278d69a,0xe892199d,0xf4e00954,
0xefbe1211,0x16ce01f5,0x15c7ddc4,0x0bf7ea39,0xd42310c8,0xeeae1a32,0xeeaa10eb,0xe165120d,
0xf6491469,0x1e7b01f5,0x1a20d59c,0xe8720f20,0x17e0fc4d,0x15bbedaf,0x1286f0ba,0xffd7f37e,
0x057bfbe6,0xff1e0a23,0xea5a0265,0x20f8f19b,0x14d1dee5,0x00beed5f,0x01b1fdc1,0x1622f260,
0x03eb063d,0x2d83e230,0x3a29cf9f,0x473bbef8,0x2517cc75,0xda1bfcaa,0xfb921421,0xfcd202f4,
0x18adf74b,0xe3c3fe5a,0x0a7914ef,0x1ebbed00,0x12fed93b,0xf522f43b,0xe90b0ec1,0xf80a0ec8,
0x079aff04,0x1d68f8d5,0xfb63e4af,0x05be1680,0xfa82fe6c,0x0a6f0179,0x12dbf880,0x21c9d0ca,
0xe5100708,0x035707b5,0xdcb61689,0x0c20fe2e,0x0da8f10b,0x07b3e616,0x186df167,0xda33114f,
0xfb3107e1,0xd80931ca,0x27d90eac,0xf30fe99d,0x1294f4af,0xde390e60,0xed8a1dd2,0xffda025d,
0xea0efc33,0x01e0133f,0x107df4db,0x1e6ad49c,0xc1660fde,0xcd3d5371,0xfb5a1dea,0x267ce34c,
0xf2edffd6,0xe6b812d9,0x1651fe98,0x1cc8dfa1,0xed37ef6a,0xf1811ab3,0x141ef1e0,0x07b8f469,
0xf9930dc4,0xf9881300,0x06d4faf0,0x13f80011,0x0931d5c5,0xfa17f931,0x1549f358,0xf7cef058,
0x0dfc04dc,0x0518fe0d,0xf4430ea9,0xffbe0983,0x02f01410,0x0b1ae7c5,0x052aff8a,0xe733fa9c,
0xe7ff1da3,0x00f6f724,0xdd10052c,0xe7b42545,0xf6f711a2,0xf3340ee9,0xffe6fc25,0xf9951ea3,
0xfbf6f7a5,0x0c580ccc,0x09abf02b,0xfb9302c4,0x0723ec83,0x02950b9d,0x3208ddd6,0x1b02e169,
0x0a0dec77,0xfa12f54e,0x0f8d03ff,0x2c14d01b,0x1430d103,0xfeb5fbb7,0x163aee53,0x2110e813,
0x08fdf69d,0xdec2159c,0xfb9f2490,0x1d0be802,0xf9cdf892,0x26b2f2f7,0x060ee8da,0x08e4faff,
0xeb7ef954,0xe7661088,0xee960c57,0x0e7c06b0,0x0822dfe1,0xef1c0ee4,0xf5280e44,0xed0e23c2,
0x1ad5004a,0x01edf4a9,0x2a79f105,0xfd82cf69,0xeaf71c0b,0xe8bc0903,0xd1bc2219,0xc8cd3714,
0x03c71d3d,0x1480ddd1,0xf38ff374,0xbe4f3416,0xb8a84d6b,0xeee231d0,0x05910701,0x1933047b,
0xffb3f128,0xe5f10544,0xc23433b6,0xf3de1967,0xe2c70a9a,0xeb9e101f,0xee920ff6,0x0967ff66,
0x11ffebe8,0x09cd078f,0x2e4de1f3,0xf419f581,0x03bc0375,0xe12412e4,0xe9571a86,0xfb251354,
0xf0d80351,0xebaf0ce0,0xed850d7e,0x1513ffed,0xfca7f2be,0x120a0285,0xedc4ffdf,0x0b780e88,
0x074bede1,0x0de9eca0,0xe9ca0230,0xd8892f90,0x1471fa75,0x00e4efdc,0x010b08fe,0x042bf90d,
0x37e2df94,0x015fde2f,0xf1c21443,0xf3ba1427,0x03500337,0xec7f0e5a,0xe40413c4,0xf87b0565,
0xf07b0eea,0x0899fa28,0x003ff6fc,0x2935f243,0x1a41e946,0x1b91d822,0x080afd20,0x16a0eb8b,
0x05acf6c5,0xdcdf02bb,0xe582300c,0xef54106a,0xea880b71,0xe8be1ec8,0x0c38f9f1,0xfd95fd0b,
0xf94def77,0xed1528f8,0x1d03ea88,0x0798ee96,0xecec12d7,0xe8aa203e,0xf3c116d2,0x0419f1d6,
0xf46c113a,0xeacb02e1,0xd3e41ef3,0x1753ffde,0x0da6ef75,0x0753ecb6,0xdce81614,0x00931cf2,
0x1a2ef058,0x0a1ef26b,0xf899f60a,0xe70c1a2a,0x0f7a0ac6,0x2fe6d0ed,0xebcb00b2,0x07c7fd9d,
0x01e3f50f,0x130bf12d,0xfd2fee99,0x1ab8f1f9,0xfd780297,0xed670fab,0x17e60432,0x0aa5e58f,
0x05800887,0xfdf30582,0x1a2ee771,0x04f9e0f3,0x0acd0130,0x06b0db83,0x19e1eed6,0xec680a9c,
0xedf60b52,0xf84c1701,0xfac2066f,0xe0bb2814,0xeaa71eb1,0x0c0c0c0a,0x36d0ca4e,0x0336dfa7,
0xf57ef3f5,0xfe8600be,0x08910115,0xfdb1f31b,0x1940052a,0x2392e03b,0x09b3fa71,0x130efbb1,
0xf808f970,0x1d9ae920,0xeedfe83f,0x0f7e0f3d,0x228bd618,0x0fd1ef92,0xe67cfd59,0xec2e1c56,
0xec5416e8,0xdd37174e,0xefe124a9,0xf0140b6b,0x1cedec35,0x0a39eb5a,0x03471475,0xecf20076,
0x209400d4,0x05bce923,0x14f9f46c,0x044aea0b,0x0010fa6d,0xe65007cf,0xda811912,0xe69b1847,
0xf6181cd4,0x087b0b69,0xfc76ecae,0xff19ff9d,0xeb1e1da0,0x1293047f,0x17fbdde7,0xf3ba0d63,
0x065cf6e2,0xef490af7,0xe0f2151e,0xd9432ad4,0x09a212b8,0x1a3defa0,0x2ee0c7ef,0x0cb3e0d6,
0x1e7de3fb,0x21b9d875,0x0eb2f2d1,0x1c3be28a,0x056efc48,0x084df969,0xebde042a,0xfa7012a4,
0x061b02c8,0xfceef835,0xf12a0cb1,0xf2d10c6a,0x3161eddf,0x0601d434,0xfa5f040d,0xff8d078a,
0x0d58fd67,0x09b3f5c5,0x047404ed,0x3cb4ef07,0x62dd97cb,0x368dabed,0xe756f053,0x01700c5b,
0xeaeafbd4,0x026206da,0xe24410f5,0xe2842494,0xf63e20bb,0x0525095f,0xee72ff74,0xe9191d6f,
0x0a970781,0xfffff03d,0x1180eaf9,0xe9910053,0xe4d91214,0xf3931515,0x03a40095,0x07ff0a26,
0xf889004f,0xf7f30eb1,0xeff01730,0xe8e11c05,0xf8950008,0xf5dbfaf9,0xd978191d,0xfb1f0a10,
0xfb2110be,0x0a8ff661,0xf8c1fe31,0x0f660786,0xfbd7f134,0xf88d123f,0xf57dfa56,0x0b0c04bf,
0x175be8db,0xdab90ed9,0xecd62059,0x0235143e,0xfcbafca2,0xf343092c,0xffa7ff7a,0xf8330023,
0x0cf5fa92,0xf3cff79c,0x0963029e,0x1ddef6f2,0x23fada42,0x010ce3a8,0x0e5f0337,0x0f1de2c8,
0x0c78efb9,0x13bff710,0xe6a90c6f,0xdfc9272a,0xe73c27ef,0x1d3602b3,0xff4fe16a,0xf7a1ff4d,
0xde1717ed,0x1b1303e5,0x1b65d4c5,0x035fea19,0x02f909f3,0x10f4f029,0x2129eb52,0xecf3ee32,
0xf1ca1ec8,0xed0509ab,0x18610df9,0xeee1f383,0xef8a157e,0x0e1ef336,0xf474fdba,0x003b0ab5,
0x040cf65b,0xfde30f48,0xf09309ae,0x14db062c,0x18dce3ef,0x0a41f1d2,0xfa24fccb,0x13e6ee29,
0x02a1ea63,0x0a2d0742,0x1a25e9be,0x240dd65e,0x1565e3a6,0xe8f2001e,0xf3c60ff1,0xfc9f0483,
0xf6bb0e65,0xdfb7179a,0xf4922d3f,0x1345f721,0x0440f521,0x1360eb6d,0xfda5faff,0xfd57f676,
0xf1e802f1,0x10be0426,0x3f1ecdfa,0x07fde485,0xf0e5075a,0xffb90bfc,0xfd61fa09,0xdf530a39,
0x0c9e115e,0x1138f375,0x0c70dfe8,0xf11a03c1,0xe52921d5,0xea33131c,0x22f801db,0xf62bf094,
0xf5ab1386,0x1c7aeef0,0xf544f6dd,0xf36017d1,0xffac137e,0x3ac8d11a,0x28e5b913,0x0e02f4ea,
0xfa9be057,0xd99c13d7,0xdd47267f,0x08be1059,0x03fff78e,0xd9b72c0f,0xf8f5299c,0x10d301d9,
0xf343fb1b,0xf41c0065,0xf6610c0f,0xf190f0fb,0x0fb6f91c,0xf8b0eb38,0xef2011cd,0xfa280a94,
0x12d605da,0xf6daff02,0xee511bf3,0xec001d98,0x0a130082,0xe987102e,0xf25d0ce1,0xd9901d8e,
0xfb55fd1e,0x1c1efc79,0x1f37cba3,0xdbb4041d,0xf7181c85,0x10a00cc1,0x1d15ecf2,0x0f67dedf,
0x1c0cf47d,0x3beaccbd,0x0e67e106,0x1c41dc81,0xf020fb1b,0x07c6067f,0xe48cfa12,0x0ba80ffa,
0xfcbcf9e5,0x085905ee,0x1470f6d7,0x06a4f79a,0x11b2f3b2,0x0a49f0e5,0x0b52f836,0xf854fdc4,
0x1a7df937,0x0513e4d1,0x0951ffdb,0x09eaf071,0x0c24ee82,0xef60fca5,0xfb52064f,0x07940312,
0x0abaf68b,0x04d3047a,0x0a5efd5b,0x10c8ef4e,0xfd34fa82,0xf9960097,0xe86d0b8f,0x024d0928,
0xf144088a,0x1b23f0e7,0xf47ff727,0x0a53177a,0x188eea8c,0xfb2af0bb,0xf7c2042b,0xda8828fc,
0xf4ae170c,0xec1606a9,0xf03903d8,0xe03d0ec6,0xe45d121d,0xffc61b88,0x0c1ef0cd,0x04c0fc5b,
0xf6fa111a,0x2794056f,0x0473eb59,0x08a403a4,0xf918fa91,0xf580fe50,0xeebbf53e,0xe76510a4,
0xf00d17a7,0xf75ef93d,0x14d20814,0x1a4be982,0x06c7f5f2,0xfba11141,0x09c001c2,0x169ef11c,
0xffb0e606,0xd5c31d61,0x11301080,0x1d73e2c5,0x2746cb44,0xfc4bf37d,0x02c40223,0x01b0ea39,
0x07cc1203,0xfc0dee04,0xfda712f9,0xf6cffa4a,0xc8132915,0x0e161fea,0xfc04fd0d,0x1096f763,
0xf133fae1,0xed412012,0xeb8b0232,0x01b81fb1,0x11f2e291,0x0db0eab6,0x17c9ed82,0xf416f533,
0xf62b0a69,0x0c18f685,0xf80102fa,0xfc6aff56,0xfb8d0710,0x0ba1f376,0x03f40ceb,0xddd60dd5,
0xee323976,0xfd770333,0xf7ba113e,0x0110f6fa,0xe47b0403,0xe9401579,0xdae20334,0xea6526e5,
0x1077f822,0x03a9f57f,0x2902efcc,0x486bdaef,0x2b22b779,0xf60a001f,0xfa6613e9,0xffd4ff60,
0x00b2f799,0xd86b1366,0xf13c1970,0xde1c0cf8,0xe3b92838,0xf77dff0c,0x089c0e68,0x1480e510,
0x08c7fc69,0x1c04ef93,0xf9b50489,0x244ff36a,0xff10f56d,0x02dcf871,0xe1040911,0x02d7036c,
0xeac6f2c8,0xd0cd22ce,0xfdc110a8,0xdbd01708,0x0312257a,0xeb9712c1,0x13e407f9,0xec3e0682,
0x01a31958,0x07b6ec30,0x1245ede3,0x06d1e5ff,0x08c7eacc,0x1e95f0bc,0x04e1e863,0xf17407b9,
0x0a210535,0x1197fce5,0x0511e818,0x0690f8c1,0xecb20e53,0xfa4710d3,0x09fe0310,0x0a5ef5b4,
0xfec70c55,0xff1dfce4,0x0ee9f462,0x20dfdf9b,0xff08ee6a,0xf7eaf76b,0x091ffcf2,0xf0d6019f,
0x0176fba3,0x07b10290,0x0eb2fabf,0xf211094b,0x01c20ea2,0x0f3dfb51,0x03a1f93e,0xfd3a0774,
0x053bf29e,0x029ef910,0xf7b6054b,0xf72208f2,0x0c36f0cf,0xcf6e0e71,0xee7b32e8,0xebb5075b,
0x0a9c04a3,0x0ff6eac6,0xeb91fdfc,0xec112307,0xff2807bc,0x04bef3d8,0x0530f309,0x066b0d0e,
0x06d2f8bb,0x0fc7068e,0xf4ba00a1,0xedc41ac4,0xf82f0867,0xf6d3ff01,0xf52300e0,0xf4960412,
0xf74aec72,0xf4e608be,0x14050f55,0x26f6d395,0x29d1e842,0x0844ee99,0x007300c6,0x0c810450,
0xeaa41274,0x0bf7f68f,0x3654dab8,0x2176c3e9,0xf399e8b0,0xfd9e14c9,0x1765e6b5,0x008202f2,
0xf98b060f,0xe77317ad,0x030c08de,0x05b9fc8b,0x0d98f1e9,0x2f09e4fe,0x0dfacecc,0x0646f902,
0x1ac2edf4,0x072ff2df,0xe0820562,0xf4e02581,0x177bf5c0,0x0185f77f,0x0508fc9e,0xfe090669,
0x0bfafe17,0xe761facc,0xd9ec2980,0x01b30575,0xfd860185,0xf329f6d9,0xd8520e0f,0xf9b4283e,
0x05c502bf,0x17b7ee7b,0x0155f951,0xfa870fda,0x1071ee13,0x01c4fe94,0xeaba061a,0xe4a91bb7,
0xf2500f59,0xea2e1600,0xea3c17ad,0xfcd20538,0x04d0f71a,0x0bad000d,0x10eaf424,0x1b1cd886,
0x056bf623,0xf2a8fd96,0x0c6b06d1,0x29f8e5f3,0x0424ec34,0x06f7fa9c,0x0a470bdd,0x1fe1e66f,
0xec48f32e,0xe24f1b5a,0x0b0efdf5,0x009fef28,0xf387f507,0xde4720ed,0xee641bce,0xf5c51b4f,
0x02280893,0xf4b211cc,0xf35b09fb,0x02a90db0,0xf16deb62,0xf5ac0ad1,0xe0a00a1b,0x11c5054a,
0xfb60f91f,0x012003df,0xf50414bc,0x168afab7,0xf79c162c,0x3a22da24,0x167ed32d,0xf480ea22,
0xea511207,0xf948f232,0x0c01f9c4,0xec240830,0x2a61fb6c,0x1d7ce976,0x1c17f0b3,0xfc7a0456,
0x0514f4f8,0xfdfc02a9,0xfa7cfa9c,0x0779f4e4,0x1ef5e28b,0x228ee428,0x0defd169,0x0bb1f4c3,
0xea9a15f6,0xf9960bbf,0x1bab0830,0x2cb5d7a5,0xfed9f247,0xee0d07d4,0xfcdb0c18,0x0b15e4af,
0x04dbf99a,0x0ee8e587,0xf814faa6,0x113f14bd,0x2fa6d803,0x351fe421,0x2240d873,0x142de4c4,
0x056ae703,0xefde09ae,0x01d1fdcf,0x1e23e169,0x058deafe,0xf229f819,0xfc7a1c38,0xfafff5bd,
0x10ce0bf6,0x179cea6e,0x119bf10c,0xdb000536,0xf2903803,0xfe75f7ee,0xffe4febe,0xfb9300da,
0xfb0cf9d6,0x1727f8fb,0xfcbfe656,0xebc0111c,0xe04315dc,0x0726154b,0xfbb1fb92,0xf2670836,
0xf56611c7,0x004d0cd9,0x0762f2bd,0xffff0179,0x1febf89b,0x1418df67,0x1017e921,0xff2cf256,
0x0f240967,0xf972f1b5,0x1346f4ff,0x06430055,0x00c80d8b,0xfee1edff,0x08dafcea,0x0e20e974,
0xfe9af8e4,0x14f5de97,0xeb43fb8a,0xfadd1ed8,0xf2cb06ee,0xfad6101b,0xf74511df,0x0a731198,
0x0270e7b7,0xf93b06b4,0x0c0cf709,0x0960ff46,0x0b06eedf,0xfae9099a,0x1249ed6c,0xe43c0925,
0x18cff93d,0x0a2cdfa4,0x031bf507,0xeafe0fe1,0x196400ea,0x027cec41,0xee31185a,0xf29e0f91,
0xed671801,0x2090e30f,0xe8dd0bf9,0x1c16ffe1,0x1495e72b,0x1de9ece7,0xf02cf7f3,0x0ea40d82,
0xf9ace28a,0xf9200224,0xdc8f0b8e,0xe5461bfb,0xfee60202,0x007e1b67,0x11f8e97d,0x0f8d05de,
0x1183efd4,0xe10214c8,0x2341ffc6,0x141bdb38,0x1583eabd,0xe23effb6,0x132001c9,0x0979d6ff,
0x0c0b0273,0xfaa5f4ca,0x0bbc0c08,0x1841e3e8,0xdc401ab9,0x07010a01,0xe0a913f9,0xf72111fa,
0xf604fe11,0x10df1068,0xfc80e0fd,0xf03710b3,0xecf7117d,0xf9ec0d01,0xff67ef6e,0xf2d415ae,
0x05ed0243,0xf93a1265,0xdc3c1545,0xdf3225c0,0x02681176,0xf17df059,0xe9f31778,0xf0391004,
0x0ee40e19,0x2226d2ba,0xfdf703bc,0xf3a3fbfb,0xdf481b0d,0x0715040e,0xeb990550,0x06910cc7,
0x0251fce9,0xf8e60ea8,0x071e08a7,0x2035f558,0xfca8d6d5,0xee08188f,0x04dff8bb,0xfd77ec89,
0xe4291bbf,0xe14e270c,0x0c560d2e,0x01affbb1,0xf92c09de,0xed090337,0x1439013d,0x126bdac8,
0xf342fcde,0xed761526,0x0ae30c97,0xfadb0198,0xe986070a,0xf1731766,0xfc8001a7,0x0988fdb7,
0xf7a5f7be,0x174714fd,0x0725ed14,0xf48a061e,0xf9b40c25,0x0ef0f566,0xe77ef746,0xf25dff34,
0xef4d1f29,0xf3c00269,0xd6df2899,0xf2b01886,0xfc731bef,0xf5b4013f,0xf56c06f6,0xfa7509ce,
0x1046f938,0xf53bfd1f,0x1f07ed3b,0xe3b10793,0x01fe1f69,0xee39045b,0x01f7fa4e,0xf8180649,
0xf2e00160,0x0c17f963,0xfe53fbae,0x1580eedd,0xf76ffcdf,0x036d1461,0x17bbe8b7,0x0c1dff4b,
0xf4ee00a9,0xf28b0a94,0x0306090d,0xf677f825,0xe7e91a60,0xfe4506e4,0xfd92ff2f,0xfb5405a5,
0xf7ff0fc3,0x1b60e1ee,0x17e3e82e,0xfc7cf90a,0x02f6ee84,0xfc640185,0x18380a4b,0xfaeaf417,
0x11e80176,0x13ebeb0b,0x045cf608,0x023403fb,0x0e15e986,0x003bf90b,0xf6370efa,0xfb6d056b,
0xfdfc0093,0x00ca0218,0xeeeef55f,0x04710c20,0x254ae791,0x1742e3ca,0x105af646,0x025700e7,
0x0f96f29d,0xe8220364,0xf8be1435,0xefe800cc,0xf02b045a,0xe3b61966,0x10e80a88,0x1454e52a,
0xf90201ec,0x025d0ad8,0x13a9f44c,0xf75efd42,0xf5f50dba,0x2969f66a,0xf94be554,0xf8b9fbde,
0xf0941954,0xee91084b,0xf6ce0350,0x06dbfb63,0xfdf8fda1,0x12cef907,0x0c54f513,0x1413fd06,
0x1e84eed5,0x03f2f3bb,0xe8c4fad8,0xe3fa2346,0x06d3fa4a,0xfae0f920,0x0774f6db,0xf95d11e5,
0x2edbea5a,0xf538e6fb,0xcca23a9b,0x02480ba8,0xf8210a88,0x0bd3fa71,0xfbc4e876,0x271af4d7,
0x1860d38e,0x0891f6a5,0x1173eec1,0x1359fb20,0x0a91e1a8,0xda6922b5,0x01430f82,0x024c0bc2,
0x062ef955,0xf938f47c,0x0b8a0855,0x069de75a,0xe105fc0f,0xe9821a49,0x0e8a0d97,0x0fe4e9e1,
0xf6cc0b1f,0x2aaa0020,0x2ab6da4d,0x02ace003,0xeeb806ae,0x1f9bec83,0x0749e980,0x0ce1edda,
0x0107ef12,0x09a5123f,0x00e9ee48,0xf9e6084a,0xf41609a6,0x0468038f,0x0779f4c5,0x03c30240,
0x11c7f7fc,0x15b1f2cd,0x140ee8cf,0xee1c04e0,0x00f208b8,0xe86ef900,0xf3241b58,0xfc40f942,
0xf74efef1,0xf76a0c25,0xf4601861,0x1d09f7d2,0x0f64ee17,0x1765f045,0xe91bf49d,0x11e80372,
0xf991ede5,0xe25d20a5,0xdb071185,0xf9532034,0xf1260f45,0xea1413c9,0x007610cd,0xf02f0121,
0xfd46157f,0xee43fb2f,0xfcfe0be0,0xf0aef9d6,0xd8bb21cc,0x05190a60,0xfeda0228,0xf3b60eab,
0xf18c1916,0x0296031c,0xe6cd085a,0xdac02144,0xf89c135d,0xeee406e5,0xefec134b,0x0ea8f698,
0x001afdeb,0x197cf669,0xf620f4ea,0x084c0dd1,0x073aee7c,0x0216053b,0x13bde6ab,0x0ecff4e5,
0x1c7ce50e,0xff01e623,0x099905eb,0x1b81e8ed,0x26e6e57d,0x0a66e510,0xfcdb1058,0x0d4bfe73,
0x03eaf5e6,0xe7df008e,0xee462400,0x0023e712,0xf08f04e9,0xf797138f,0x0b8cfb97,0x2102e7e2,
0x0703e819,0xfbda0411,0x02c705c5,0x0754fd86,0x0e680717,0x1483ef1d,0xf8bffb8d,0xf56609d3,
0xf26704fc,0x1708ee0a,0x028fe09e,0xd8231839,0xfe511430,0x0e10fa53,0xfe19031e,0xd5b6336f,
0x06c00b5b,0xff3ffcd5,0x0f89f057,0xeb69f780,0x0fe306f3,0x036bdd02,0xf4fb08f0,0x07bdfe56,
0xee5f07f9,0x00b10c37,0xe4e01997,0x12f60a4e,0x19abf5d4,0x00daec0e,0xf3df1420,0x00970a44,
0xfcbffea9,0xcd5b008b,0xecbb1cf6,0xfac3005c,0x00cff2b1,0xd8a5192f,0x07fe1864,0x1802febf,
0x13f0ec76,0xee7a0f78,0xf5330daa,0xe9a51a6d,0xfc84fa8d,0xed631316,0x068905be,0xfa37e86a,
0xfd790af5,0xfac3f568,0x0aaa060a,0x034ae88f,0xe6161fdf,0x069d0270,0xf5f6165f,0xfc5c06b1,
0xecc71c78,0x12800162,0xf4b8daeb,0xdd392270,0xf67ff9f5,0x078a0f73,0xf1790551,0xf24317aa,
0x0b33fb5c,0x1dfffe20,0x0c7ddf44,0xed8e094e,0x056ef5bd,0xf3b60d9d,0x2624f4f2,0x0185dd63,
0x07980cae,0xfe9ff826,0x1018ffe3,0x1789e404,0x1ea1e62b,0xf1c2f0e7,0xe44317d4,0x1029062d,
0x1464e63c,0xffdaf861,0xfa6d076c,0x2855f3cd,0xf4acef15,0x0abc0619,0x0447f386,0x08ec065a,
0x0324f400,0xed0c0e2b,0xf7ce058d,0xea2716d2,0x0f49eecc,0xe9980423,0x13e6f7e5,0xf4a10702,
0x076a0919,0xeb5005fe,0xe8b51b0c,0xf3590d75,0xdd831a85,0x0c3804e8,0xf146f56d,0x0230149a,
0xe39e1326,0x202bfb0f,0xf6e3f85e,0xfadd1a9d,0x0ae5f877,0x0224ea7d,0xee5e05ea,0xd97c147d,
0x0b81014f,0xf75aff7b,0x1879f167,0xfaaafb4a,0xef900778,0xd9c53385,0xf1e421b9,0xe69e16ad,
0xf6b80fe7,0x02df175d,0xff66eb5d,0x1349ebcc,0xf99df56d,0x0f10ef01,0x02c7fec2,0x1970e374,
0xefb405dd,0x115f01ce,0xe8a10641,0x0ab60823,0xf8110255,0xdaf72047,0xf9820ce7,0xf3e512e3,
0x0dbdef18,0x01af024f,0xfb77f8a6,0xdbee1f6f,0xf45e1341,0xffce0d90,0xe3d0fee6,0xfa1e115e,
0xfba7f6da,0x0db3f30e,0x0133f563,0xf58609b5,0x06aa1d96,0x1af0e320,0xd1b61fb5,0xed40184d,
0xfd021ebd,0xf233ee00,0xe9052427,0x2036f93a,0x00a5e2c7,0xfc98f3c4,0xf34b0c6b,0xe98f11f1,
0xfcca03d5,0x0e86fa56,0x10c4e90f,0x239af126,0x00cdf1c6,0x026a0b57,0x03fc008e,0x003ffd7a,
0xe520fc26,0xf351222f,0x044f047d,0x1beadf1c,0x0480fca1,0xe966f9b1,0x08770c24,0x045fefe7,
0xf3460913,0x0cb3fad1,0x07df08cf,0xf8dff5c5,0x027a1206,0xf87efff3,0xed4106d3,0x02f90c8e,
0xe15809c8,0xf02207f9,0xe75f13a6,0xf6760aee,0xff14fa42,0x05c113ec,0x08dff4ab,0x0ad5081b,
0x11170339,0x111ceacb,0xf07cf582,0xd6d91a25,0x08820e3c,0x0b7ce94f,0xffe8eca9,0xf22d041c,
0x149705a2,0xf99fecf9,0xef9d145d,0xdb7d1bbb,0xebcb3596,0xee3d0475,0x11001740,0x0a67dea9,
0xfa30063d,0x02acfcd8,0x13b4f46b,0x13bcda8b,0x10cef1bc,0x15f0e221,0xf9edf7d4,0xfa4c0781,
0xede1113f,0xf3fd14ec,0xfb2c0b94,0x1655ffff,0x12f5e44c,0xffc4ff30,0x297ae5c0,0x1499df8c,
0x0ffdeaca,0xea5af34f,0xf48c15b6,0xf5860532,0xff2c05d7,0x059af816,0x086b05b3,0x05abf878,
0x00a100f4,0xec2905cb,0xf1931f1a,0xd8462094,0xe9ee13ef,0xf0ef1211,0x05b80aa6,0xfda6f248,
0xfde6f816,0xec9307a3,0xf3930caf,0xfeab143e,0xf925fb2d,0x026a0ea2,0xe83501ea,0xf03d1e35,
0x07880951,0xf8b1fc69,0xf935fe15,0xf69b0569,0xed470e54,0xffdb014d,0x0bd6fb49,0xedfffd0f,
0x04bb1065,0xfa9903ff,0x078a0a9b,0xffbbfa23,0x062c0087,0x0312fe45,0x15e5eb96,0xff1df17b,
0x057ffc38,0x099b00e1,0x06a2e37e,0xf8440349,0x1136fd93,0x153aeb76,0xf6e0f0cb,0x048effd6,
0xf97ffe68,0x04600b29,0x07c1fd77,0x0f9ffac0,0x08a3037d,0xec09087e,0xfbaa082e,0x06b8f291,
0x0090f06a,0xe9d8135e,0x0d32fad8,0x04aefe71,0x1174f266,0x01010955,0x0c41e70f,0xfe63ff7b,
0x0a5ce757,0x189ff116,0xf7a7f606,0x12fbfffb,0x03b7f580,0xfc7b03d8,0xf39609dd,0x1d6dfffb,
0xf249fd6e,0x071a0be5,0x115bf047,0xf315031a,0x09f3051c,0xf416ece7,0xf99b0429,0xee24ff55,
0xff9f0195,0x05e0ef6e,0x008a0446,0x02701214,0xff4cfa8d,0x16d40ba7,0x13c4eab1,0x0accfcef,
0x0c44e948,0x0557fbc4,0x1c0edd32,0x03aaf3eb,0xffbdf090,0xfe3ef910,0x076d00e4,0xff69f84c,
0x01bd06b5,0xf81d04c9,0xdfb1299a,0x09da0dfd,0xf03d07e3,0xde7e0e7e,0x09200dde,0x00d7e6b7,
0xf03506f3,0x04210317,0xf39f04ac,0x090a02cc,0xf9dd04d2,0x03af0a13,0xf02606b9,0x0a530bff,
0x0707ee76,0x011bfbc4,0xe056081d,0xfd8c1583,0xf433f238,0xe8b321ef,0xee7904e4,0x00990f75,
0x14b000cb,0xff17f262,0x06430403,0x085ef6d1,0xf61308eb,0x1c0ce627,0xf14800c6,0x06fa0518,
0x142cfac5,0x11cce708,0x038efe59,0x188be7a2,0xf4d3f90c,0xff78f7d9,0xf11907eb,0xf3421473,
0xf81efd18,0xe7782654,0x054b06c9,0xf138ffc8,0xfae1122a,0xf4350aa6,0x04b50649,0x00fd0099,
0xe91e0265,0xf4881b7e,0x0e630091,0x0e82dae2,0xfc99f53f,0xfea70605,0xfb02fc2e,0xf9e30812,
0xf1a21a2f,0x0826fcc5,0x04d0124d,0x09dce3b9,0xfed7081d,0xfbdbf604,0xf35b18d4,0x1994e6b8,
0x00bff419,0x047f051d,0x0766f7cf,0xef9505a3,0xfc0fff26,0xfd020e06,0xf5f9007b,0xdf631ea8,
0xfb401725,0x1134fd83,0xe045f105,0xe7c82ca9,0x0b37fe79,0x0b36edd7,0x0914fcc5,0x005cfd14,
0x0e2301c0,0xf8aeeddb,0xfd3e1623,0xf6afed01,0x139a0ed8,0x080add7a,0x0d6907d0,0x0cf9f285,
0x025104b6,0x0770f9a6,0x04fff719,0x0ad5f87e,0xff66f2ad,0x0364038e,0xf9e4ecc2,0x1180056a,
0xf1c7f08f,0xfb9821b2,0x0f51ef2b,0x1055f47a,0x1e47eb30,0x0cabebac,0x239eef78,0xea49ecae,
0xfa8a261a,0xe219fea5,0x08931c67,0xf1dee8e7,0xea681c58,0xe6ed07b6,0x0d050be5,0xf5effcdb,
0x0da6041d,0x1106f196,0xe882021b,0xfd781b8f,0xfac7f665,0x15cd0b25,0xf306e5f6,0xf69a1bfa,
0x0b9bf4e0,0x1418f014,0xf611fd89,0xf60a0f23,0xf8400c6d,0x0258f6da,0xe7220960,0xe57e1c11,
0x08c4002b,0xed04f9cd,0x10061029,0xf7def5ec,0x11df08b5,0x0d72f3ea,0x1350fdd5,0x129cecef,
0x0890f3d6,0x040df3ea,0xf626f9da,0xf65200dd,0xe46b052c,0xf9102033,0xf84404bf,0x10b5fc18,
0xf7a1fbb1,0x003d0e36,0x05c0ef8f,0x08d5fd43,0x1534f1a7,0x0456f819,0xf73e070e,0x153a0411,
0x01bde398,0xefe01a86,0x1999e27e,0xeaf10a0a,0x0aeffffd,0xe45b0313,0xfa8a17a6,0xe62010d6,
0xf6e10ca7,0xfbd304f4,0xf27a0fec,0xf4b20346,0xf56414a7,0xf88f02a5,0xeca9191e,0x070507e8,
0x02e3f879,0x0c60ec1a,0xe8cf01c4,0xe78012e9,0xf5a311fc,0x06900f1d,0x09ffeaf1,0xf85f1425,
0x027503dc,0x01c6fde0,0x1019f6d7,0x07e4fa6d,0x0cdde91c,0xfb7afef4,0x0a20f575,0x126ae5bd,
0xef8ffe6c,0xeeaa0999,0xfb2f0ce9,0xf8630942,0xefd21926,0x098d03e4,0xf3de13aa,0x02090532,
0xf9b00b40,0x1a03fcf0,0xfab0e105,0xfd6a0a87,0x0792e7c1,0x0be8ef31,0x0d6ce696,0xef590243,
0x06cf0141,0xfb17ff9f,0xf60b1339,0x1cc705af,0x0a4aedb7,0xfa63065a,0x10fd04f7,0xf1d8fb07,
0xf15f11af,0xf846ffcc,0xefc40e68,0xf081fe58,0xedb60fc8,0xf8cc0b2f,0xf70907be,0x0df9f6de,
0xfb3cf248,0xf3a112bf,0xfbf707d3,0xfd8411c1,0xf7ee020b,0xf56c19f3,0xf89107f3,0xfdfd02c4,
0xfcfa05ab,0x0647f939,0xfe5ef924,0x033ff577,0xd5ba0f6c,0x00d71395,0xfe47fa01,0xfa3e0061,
0xfc40086f,0xeaae1dd1,0x0a811422,0xf8fdf596,0xfe831434,0x286edf33,0x0451e0ab,0xfe57f742,
0xf64ef992,0x12c4fb29,0xf31bfb13,0xf2121111,0x075f0814,0x0b2afac7,0xe6dd0a76,0x092216e7,
0x00f0fc26,0x01a3fae0,0xfb680651,0xe7490b13,0xfc810f38,0xdc78ff3c,0xec871a39,0xf5bef78c,
0x190bfc36,0x0814e58b,0x1f9ffc65,0x0284009c,0xff200261,0xd816255a,0xed2f234f,0xf09d0e86,
0x118ef5fd,0x030ef138,0xfa2cf437,0x25caecd1,0xef6bf20c,0x0793fda6,0xfc5e0685,0x1df9f1b0,
0xebc1f3f7,0xfb88152d,0xfa490636,0xfe51058d,0x026b0c57,0xdbe603ee,0x2c370c9e,0xf655dcea,
0xfa2d0fd6,0xf7cefc99,0x10c4fa53,0xe689fce8,0xfed4220c,0xfd20fd6b,0x005a019a,0x04f90397,
0x0316f328,0x10b2f5a3,0xf03df422,0x069c082e,0x03f6f133,0x1f3bf058,0x1307e049,0xfb6602ff,
0xfbcf1871,0xe7440424,0xff871713,0xf35005ee,0x05f30f5d,0xff1eed9b,0x05f6fbd5,0xf2b5fefe,
0xf481038f,0xf86d0a55,0xfbb9f243,0xfe130e45,0x011afa1b,0xf5d71411,0xfb75111f,0xf3d51111,
0xe7ad124a,0x1b72fc7a,0xf7b8eedb,0x0cf3f951,0xecbf002b,0xf1fc13b3,0xfa0c0903,0xf4310e35,
0x0d0df29e,0xfbb6f703,0x2740fa5a,0xf65de269,0xfaa408fd,0x0a5610ec,0x22d5e1de,0xfc34fda6,
0x16d7eeb1,0xfe26e8a5,0xed1a13fe,0xe37a17e5,0xf649093f,0x12df02f2,0xf508fbb4,0x04350c4e,
0x0a49f7c5,0xf596f638,0xef130f39,0x0a63046f,0x1d0ce586,0x0e61e41d,0x0a29faa7,0x0ffaf47b,
0xf40efeef,0xf61013a3,0x00c3fce2,0x0d10fe22,0xe736fc9e,0xff4c0e51,0x0c1df292,0x185af49b,
0xe76af513,0xff9e1c7d,0x1565f0a9,0xf22af823,0x016a1c6f,0xff56f5e2,0xff8c0337,0xebc703f5,
0xf5541011,0x017902e8,0x151ae775,0x0139eddc,0xfe01053b,0xe1f82199,0xf0f5095a,0xe8622003,
0xe5e51879,0xfcb81937,0x004ef8d8,0x02defa1d,0xf13300a6,0x0331ff94,0xe38a0570,0xe3a81d0f,
0x01c31ed8,0x1e09e0d1,0xf708ff05,0x02190b4e,0x19c8f323,0x055df9af,0xf7200529,0xec940f7b,
0x285fec35,0xf071eb99,0x0d81fafe,0xfb81f4ff,0x0086f757,0xfff0fbac,0xf75709ec,0x2cfbec52,
0x09bce92d,0x046b0a8e,0xfa9f07c2,0x205bf376,0xfaf80016,0x092df755,0x05ea0373,0x0c5ddd14,
0xd42609e7,0xfc6609a4,0xfeb9fdaf,0xf35c06bf,0x056f009e,0xfe690f9a,0x26c0f115,0xfd8702ff,
0x0be8f8cb,0xfe5803d2,0x11bfebf4,0xff56f926,0x0110e9b6,0xf4060cfe,0x02e0ff19,0x0975f018,
0xe8460ab1,0x098efa5f,0xf89b0d50,0x17f0f785,0xe8c115fd,0x2664f641,0xf91cf2ff,0x02e30151,
0xfff007e6,0x0532f15d,0xf4a4ffd4,0xe7e9122f,0x1357ffa8,0xef6ff7cc,0x0daaf3b4,0xf87b07d6,
0x26aedebb,0xeb5ffc82,0x00381115,0x020c0abe,0x099f0284,0xfddd02ae,0xfc0afe32,0x0dbefd38,
0xe87509c2,0xf9f6021b,0xe38e10fa,0xfbee00e9,0xe95b1307,0xf8a11056,0xfa200a49,0x07abf04f,
0x0c3c0643,0x1089f00c,0x1231f37a,0xdaa71136,0xea1b1c6a,0xe66e159b,0xf0410750,0xf4cafdcb,
0x03270590,0xfc8b0df8,0xf82b027f,0x05c80c2e,0xeded0c7b,0xf8e40cfc,0x01680e1f,0xfcaef1c5,
0xfd4e0d22,0x0799f5d2,0x0734f9fc,0x1b72de76,0xed2607e7,0xfbc4f9f5,0x0a2ff7ba,0xe5c30105,
0xf1511760,0xfa121861,0x084406b8,0xf9ae0519,0x189dfd4b,0x15a2f3d0,0x02d9edaf,0x11ee03d0,
0xfd80e379,0xec810abe,0xf50301ec,0xf18e0996,0x0e6ff20c,0x01e9f488,0x058dfedd,0x0d65f20f,
0xfd4b0ef1,0xec4a175d,0x1a3d094d,0xf074fd1e,0xeab016da,0x01adf731,0xf4df04b1,0xe27d0992,
0xf62c15b1,0x1aaaf2fd,0xf889e9b9,0x101a0f6b,0x0ee8e8ae,0x121ceda4,0xfd54f77e,0xeea71491,
0xf6870ca9,0xee2111ea,0xf3fe1bda,0x0d4def01,0x1726f57c,0xed64efc4,0x02f50c13,0xfee10534,
0xfaa50421,0xe4a00dfc,0xf1271a46,0xf78508d1,0x0128ff8e,0xf1e400a0,0xeefb0773,0x0d4307b0,
0xe47d02e2,0x07dd16dd,0x110ff549,0x2041e969,0xe463f480,0xeb5b1f90,0xe84a15bd,0x06a403f4,
0x28f8ea7f,0x1044e424,0x2088f0ca,0x1c1eded9,0x0cdfe693,0xf4520713,0x1664f6f7,0x003deea2,
0x1421e63c,0xeaaa1275,0xf2db08f0,0xe141175f,0xe92c1a5d,0x09130e2b,0x115ef081,0x0df3ee18,
0xf801fcb3,0x1ce8f7ee,0xded10118,0xdbcf1cf8,0x0fb31e56,0x0b88de8d,0xf68f0eac,0xf5ff0243,
0x02371155,0x08e5f2d8,0xf51f023e,0xeec103dc,0xf38afda1,0xd9f72965,0xf84906ca,0xfd491c06,
0x0534fb43,0xf1d0165c,0x085dfd14,0x05bcf888,0xf0c7f9cb,0x02bcfdf3,0xfe53f3fc,0xffaff408,
0xf0961acd,0xfeb9fd50,0xf5812af4,0x1748f352,0x0e63003a,0x0556f0c5,0xf3720eed,0x01040039,
0x0391f2e3,0xf146f9ce,0x03e1e836,0xe48d1099,0xfd9efdef,0xeece19e2,0xfae808e3,0x03ae1a8c,
0x0ce4f49b,0x130d005f,0x0c85eb02,0x1281f544,0xe05cfc7b,0xe2ae195c,0xf4921f1a,0x095ff599,
0x1a73fafb,0x070bd709,0xec161457,0xf2ce04d3,0x082c12b7,0x159ee1c4,0x05a6f1eb,0xfbc509d6,
0x0313f90d,0x06af0440,0xfe1ff0f4,0x045b0eb6,0x13c1e085,0xf8e3139d,0xfe7df3c8,0xfb2e11e3,
0xe05a0bf6,0xff31130f,0x0e5cf21d,0x18d8df72,0x0589f9e3,0xfdc2fab8,0x04ce1217,0x0fb9df11,
0x06d105eb,0xf7b4f145,0x0e93091f,0x0f73e021,0x075bf5e2,0xfbfc0160,0x1389059e,0x0368f853,
0x1183faa9,0xfbfdfbf8,0xf733fe79,0x098afcee,0xf005f419,0x0ee4091c,0xe1f8f368,0x1285119a,
0xfe01e606,0x0a9f0d58,0xff14f9a3,0x02210c7b,0x16d3f37e,0xfbbcfc34,0x058d0eb3,0x01f5f2e4,
0x069405a4,0xfa16e6fe,0xeb4008f5,0xe5621639,0x0a6405d3,0x171eeb12,0x19dcf18a,0x0c2be4c2,
0xfe6a043b,0x0936f6b2,0xfd8df51f,0xfe9910f1,0xd4ea1176,0x0d3919c1,0x08bef684,0x104d043a,
0x0f6be558,0xf4ed03c4,0xfb56f51d,0xf215fc05,0xe9070ee4,0xd84d199f,0x149711d0,0xefdd02a7,
0xfb370fd1,0xf2b00fd2,0x10241132,0x09a5dfdc,0x065c0d38,0x1c61dff6,0x07bee6c8,0x09f8f001,
0xef1c0433,0x1941ef65,0xd6fc0bc4,0xf2e21b84,0xf2c00fd5,0xf54517d6,0xdb1e17e6,0x05e4124f,
0x100ef491,0xf441020f,0x1151f1e4,0xed550566,0x067a03ce,0xfb69021e,0xfc57065a,0xfc5e0078,
0x14ccf95d,0x0bccf150,0x06f1ee38,0x0ff3f1b9,0xf5620154,0x0e93efa6,0xf2b30c2a,0x00b1fcd0,
0xed090c9b,0x098e0931,0xf6470258,0x036305ca,0x1968000c,0x097fe6e8,0x0e84f7a8,0xecce03a3,
0xf6120a67,0xfde20a35,0x03c7f444,0x0711f47a,0xfa6eed88,0xfce524b1,0x049be598,0xf39f1e67,
0xe55c09b0,0xfc8008d1,0x06b0fdb7,0xfb61fcba,0xebc31671,0x0268f9c0,0xefb01e7b,0x1397e80a,
0x208e0a04,0x0614cd9c,0x03c91736,0xf32af3b4,0xfdc20eba,0xf7c9f939,0xf13016b5,0xedcf1034,
0x1312ed9b,0xfb80fd5b,0xf4a5ebde,0xfd622595,0xfedff03c,0xffb61644,0xfeddfc13,0x01061308,
0xfa53fa64,0x11490942,0xea93fc36,0xec1a083b,0x00fc17c1,0xeec5e8da,0xf25d1bb7,0xe518ff44,
0xfd272356,0xfaf2e88e,0xf4e923ee,0xe9e80522,0x07d022d7,0xfcaa0540,0xf87afa50,0xfd0c0def,
0xf2adf798,0x04d209d3,0x166fe3b0,0x186aebef,0x073dd9f7,0xf6a217ac,0x022af993,0x151afaf5,
0xf0d404c7,0xebbb0d83,0xfcbc1c97,0x3155e216,0x17a9e14d,0xf26cf229,0xee9622d7,0xe82d0162,
0x005d178c,0xed10fe02,0x0688ff38,0xfef5f9ca,0x1dd2ee37,0x0d96e29f,0x167df107,0x075cfcb0,
0x13b5f055,0xef1e0896,0x089e0097,0x17f3f7cb,0x0413f5a3,0xf76402a2,0xead90e29,0xfd7e11b3,
0xea4d0566,0xffbd08e4,0xfaf20208,0xfe1efa2e,0x0539f571,0x1180e53e,0x20e5e801,0x00fbf75c,
0x06980692,0x0ef1f9e8,0x03e1f9f0,0xf837147e,0x01fc0111,0xfb8f0f3e,0x0aa8f4bf,0xefa6f79c,
0x01a30045,0xf661f5c0,0xf6490edd,0x0f17f896,0xf501f0a7,0x047b07c2,0xef991058,0x056209a7,
0xf0cc0e88,0xfc921769,0x114cf2e3,0x1420f422,0x0d9ce31e,0xfd2ffdd4,0xfd59f56e,0xf6f70d72,
0x0411edad,0xea351175,0xf67d1052,0xef150e1a,0xf6480bd3,0xe0fb160d,0xf47d1926,0xfdd9058f,
0xf826087a,0x0c13fcd7,0x1792f3f7,0x074cf154,0xff290422,0xfce007df,0x05b4f4b1,0x00e9fbae,
0x03a1f994,0x0848f0ae,0x0cc2f146,0xe8990d0e,0xf9090d98,0x17e6f9e2,0xf99df28d,0x033305d3,
0xf57b07da,0x0bde0055,0xf701f145,0xefef1772,0xfd950d80,0x1c0befbb,0x1f44f0ac,0x17f6dcc0,
0x0f69edd4,0xff7bf751,0x00e0f61c,0xf0d80611,0xedbc100f,0xea79106e,0xee2e0e44,0xe725270e,
0x0c8f051a,0x1131010e,0xe8c9f3df,0x1a6602fb,0x1707e2c8,0x16a3e546,0x045df08a,0x116cf197,
0xf0cb0589,0x00e9faa6,0xe3f6232a,0x0ffef62e,0x0992fd54,0x0defec97,0x0a49f0e7,0xf6aefbfb,
0x0d6f04bb,0xee2608e8,0x180cf98e,0xfbbfff88,0x1ae7f359,0x01fff770,0xfec3f516,0x03b8fe14,
0xfb0df206,0x1934ffd0,0xf76ee7ce,0x11330fea,0xdc33031e,0x02d319a5,0xe69210e3,0x138401ea,
0xfa11f40d,0xf9a8ff85,0xe0a41879,0xf37f0942,0x09591065,0xe938f05d,0x11dc14e4,0xfd79f125,
0x12b105c7,0x051beba9,0x09d1068f,0xecf0fdb2,0xf1e01240,0x007c0c7e,0xe4d1f23e,0x05481d39,
0xeceaf80d,0x08e601f9,0xfbc3fd14,0x083e0810,0xfe07ffcc,0x23def4df,0x12fbe304,0x149de8a3,
0xf7fd0c3b,0xeaa3f37e,0xfd2e1b31,0xf16c0169,0x00ed09bf,0x0adef384,0x0bf7fb66,0xd8710b08,
0x272605e3,0xf154f2ad,0xf8cb03bc,0xeec012cf,0xdb931579,0xe76b182a,0xd52a2892,0x0770185b,
0xe8b9fb57,0x0b8915c9,0xe166070a,0x3493f653,0x327fcc9d,0x033fda52,0xf6fe0f9a,0xfc3cfe22,
0xff73fcb3,0xdd8afec8,0xf1e4301a,0xebb1f951,0x23eb0f57,0xeca9fb04,0x045d1659,0x08abf6b0,
0xfc6af9ed,0xf7140875,0x183fefef,0x0773e909,0xe535f962,0xe6782dd9,0x0d9500fc,0x1696e233,
0x0ba0011b,0xfd99f5cb,0x100df949,0x1d85e8ef,0xf40a0279,0x1016ff1e,0x0c65f747,0xed47fbdd,
0xf94c150b,0x0056ffab,0x0079ebef,0xeeed0b0e,0xfcea01d7,0x09b3f384,0x3237dd51,0xfc6aece6,
0x02060cd5,0xf8301373,0xf8620e83,0xea0f0e8b,0xfdfe21d7,0xfd39f057,0xe1a512fc,0xf1d70e0e,
0xf4ac06c3,0x1722eb43,0x0990ec8a,0x1347f6e1,0x0dfeddc0,0xe93d140c,0xe2710ef8,0xf94336cc,
0x1f78eb7b,0xf7ae01b9,0x0f96f8a6,0xf31b0434,0xfd0df23c,0xf7300a8e,0xefd00486,0xfd78fa81,
0xfb970ef2,0x01240058,0x1a05fc9f,0xfab3f8f4,0x02700f05,0xf807fbdc,0x165401db,0xf37adb12,
0x06d70d4f,0xf94bfbf8,0x0624f74b,0x0dcefac8,0xf8e4ff43,0x1e05fc4c,0xfeceec9c,0xf6bf1e6a,
0xe22501cf,0xfe002e90,0xe489f032,0xf173211f,0xfa94fc9e,0xf87ffc92,0x0775f5af,0xf3860048,
0x03e90d95,0xf1db0539,0xf5a22a57,0x00bbf640,0x1eadfd17,0xfa2ced78,0xfd24f7ad,0x023e020b,
0x0b38f2ee,0xeb6012a3,0x09bffe39,0xf8861145,0x1a47ed5f,0xf7940295,0xe3a0fb15,0x01db0bf7,
0xcfb70e51,0x1061198c,0xe590fb6c,0x10110af3,0xe28e07dc,0x0dd51196,0x057cffaf,0x00f6f7a1,
0xf9340e63,0xf4e402d1,0x04d202c0,0xe50706d9,0x091e10da,0xf84af6de,0x1055f64b,0xe1af0156,
0x14befe8b,0x0031fa30,0xfef6f7fd,0x07d90819,0xfbe0fb98,0x233702da,0x054fe480,0x1c4e04b6,
0xf9e8e92b,0x1362f46e,0xdc5f01f1,0x0a570b4d,0x0a9feee4,0x00d5eec3,0xebf01d62,0x2211f8c3,
0x1c2ddcf9,0xe80df910,0xe4d02658,0xff1e11a9,0x19ade838,0xf2bd026e,0xfd890475,0x005a08d9,
0x0010f7ff,0xf13c0bea,0x18e6e7b1,0x2816db9d,0xe556fb56,0x05021795,0xef280915,0x0dd400b6,
0xd4e61c70,0x00221021,0xd9881541,0x00ac0948,0xe620104d,0x0f99fbb3,0x163eeea9,0xf3a0fe9a,
0xf2a21370,0xee2f0a36,0xfb2a0765,0xe790ffea,0xfbff1a8a,0xfc140d38,0x1cedf58f,0x02f0ef28,
0xf9870cc2,0x1586f130,0xf4aaf6ae,0xfb5b0649,0x0a82f413,0x1ab4e957,0xdf97ffc6,0xfd331fc9,
0x13a6fe5e,0xf5f2fd0e,0xe5861c58,0xf0dc1297,0xfe280133,0xffd5f6d1,0xe2e9147e,0x15dcf16b,
0x131ae522,0xf64efa16,0xeeb717a6,0xf8810ab3,0xf32e1249,0xfc780bc9,0x03fb13ff,0xff030076,
0x1071ff3d,0xed930198,0x0a9a04c1,0x127cd773,0x16daeb9f,0xef3ce32f,0x0cb909df,0xeb2cf907,
0xe3ad212b,0x0b560b00,0x1116fb8a,0x195ef071,0x0d33f107,0x1c96eeb4,0x023af285,0x1074023a,
0xfd3df20b,0x01a20481,0x035bfe14,0xf4acf47d,0xeaac07ae,0xea2e0be7,0xfeba0902,0x022df61e,
0x1d3bffcb,0x062cecca,0x23fff8db,0xf491fb3c,0x0723118e,0xfa16f6c6,0x090101fd,0xf47df45f,
0x07f60557,0x0053f1cb,0xe3acffc6,0x055a0e26,0x0175f787,0x1594f35a,0x2179efc7,0x0c84ee25,
0xfb30017c,0x0a4b0460,0xf6bdfca6,0xf43607d6,0x0dd90c0f,0xf273f14b,0x0954007b,0xedfbf676,
0xf4fb0dcc,0xf033117d,0x0f87013c,0xdfcb06c6,0x103413cc,0xfd600110,0xee78f82b,0xed422612,
0xf81908bd,0x161ff64f,0x0c14df4d,0xf6990dde,0xfbfbfaa7,0x138a0469,0xfac7ed04,0x0537f7cb,
0x09cdfb6f,0x033df4d9,0xf50b11c6,0x178400f5,0x008afaba,0xf5360971,0x03561a95,0x0638e202,
0x13dae73a,0xea81f449,0x0334f357,0x10a2f770,0x19dce72b,0xf8670b6b,0x19d8ff4e,0xeb901448,
0xfc71f618,0xeaea22a7,0x041d0103,0xfc0103d0,0x0793fcc1,0x1272ebd2,0x0b08e6ba,0x0d62f561,
0x0143ea03,0x1c1ce42d,0x05b404cf,0x0f19ec5b,0x08620221,0x1e57fb5a,0x2257dc47,0xea6bffd7,
0xf4ed0b25,0x06f7fb3a,0x0535e29d,0xe1a21b97,0x085efecf,0x1c6c0190,0x060fde7f,0xe4551d22,
0xe4a31fb6,0xf7980d3d,0xf138014b,0x02900a8f,0x0721f1ca,0x0025ee8d,0xd0b532b9,0xfa091240,
0xde751cce,0xe69c1ad9,0xd60f2635,0xeeb01e75,0x13b9fe73,0xf73ff4a6,0xe8a50de0,0xf925150f,
0x14fce6c4,0xec540bed,0xef3809fc,0x0a70047d,0x04b2fac0,0x10feff67,0x1de3d72e,0x241fe9c2,
0x176edd5a,0x05d9f0e9,0xfb1207b0,0x23eceb5a,0x0588ecb1,0x011d02c8,0xf01a0728,0x15c3f9d5,
0x1344eb48,0x13ffe619,0xfbb9f88c,0xeda11528,0xdf5d12ac,0xfb2c1e1b,0xf9f0fa29,0x08d4f52e,
0xf374ff3c,0xed38111c,0xfa820904,0xf4b30a47,0x07330c06,0x0155f4ca,0xe791205d,0x0222ff98,
0xf85e07fb,0x009306e6,0xfdecf5fc,0xffb2107a,0xf4e6f67e,0x06ad0584,0x2012e706,0xfefff6c0,
0x0d46ec97,0x07c6ffea,0xf59dff59,0x0592fd1e,0xecb609e7,0xf41a0f50,0xf49311e4,0x0357f844,
0xf56b0cfd,0x1148fb15,0xf705086d,0xf525ff91,0xe3cb1783,0xe77c1206,0xff15ff03,0x1904f8ec,
0x12f3f4f4,0x18a3eaba,0x0254fdcd,0xfc730a7b,0x21a7ee60,0x09b2df3e,0xdd5c0835,0x0239071d,
0x0f59ebfd,0xfd0bf04b,0x04c60895,0xfc740c2e,0xf40f1293,0x1064f855,0x052aff78,0xf98afdfb,
0x0981049a,0xe3e309a7,0xf5f010ba,0xfcf2f844,0xe91905b6,0xdcd50d4a,0x0d371390,0xfeccf3d1,
0x024309d4,0xfb380d0d,0x14f80114,0x0b83fd17,0xf9150637,0xdd290f2f,0xf1fd0917,0xec4e051f,
0xe6c60a70,0x09680ac8,0x08b8f713,0x0ac3ec65,0xfcd20475,0x0f3ffcb3,0x02f5fa93,0x1bdaef9c,
0xf980fafb,0x0c3d0746,0x1c79e4df,0xfe9eeecc,0x04c4148b,0x0c54eaa6,0x0c4ef4d9,0xc69909d5,
0x05ae29aa,0x000de663,0x0143044e,0xf0c4f968,0xe78217b6,0xfbf70bcf,0xfd0b0521,0xff2118ac,
0x0665f243,0x2754fef2,0xfbe5e564,0xea3c1ba2,0xfa0cff4a,0xea190c1d,0x078600da,0x07c3ed9b,
0xebc4fa20,0x08f507fa,0x08f001c9,0xedfa09e9,0x26a0fa12,0x0dece842,0x07a6f93f,0xf66d07a4,
0x073effc2,0x0b32eac2,0x1941e197,0x038df755,0x02baf690,0x1afbf80b,0xee8efae8,0x088b0a57,
0x0a4bfe8c,0xf5ac001c,0xedfd1689,0xf4ca0a79,0xd4c70c1d,0xec281b4c,0x01f103cc,0xf22bf975,
0x07c30ec6,0x01f9009e,0xfb48f799,0xf7651ba9,0x151c042a,0xfc12fda5,0x063bf6da,0xf18e1541,
0x0251f127,0xf65b05c6,0x12fee88b,0x1b81dc4d,0xfcc0f2dd,0xef2d0124,0x03410a4e,0x18cbff21,
0x037bfb9d,0x1baef501,0x1547f458,0xfafaf2b3,0xf05d1119,0x089e0362,0xf806f0c1,0xf6d30ea9,
0xf2c30648,0x0810fa77,0x01b6f82b,0xf46806aa,0xce031476,0x0d1f24eb,0xefefef3e,0xe85b1deb,
0xf9c71e1b,0x0742fe16,0x01ebf58a,0xf4da0309,0x2007f2b7,0x10f9d900,0x13f60142,0x07c9e6a4,
0x05f803d9,0xfb3f0643,0xf9d2fdc6,0x0893071a,0x1325e95c,0x0d46f387,0x0647f2ae,0x136af457,
0xf97bedc0,0x099f0e82,0x027aed45,0x0b26f71e,0xfe86fed9,0x0404faaa,0xf6a9039c,0x1b03fc9f,
0xfe6be99b,0xde4715e2,0x04b11a06,0x1432e8da,0xfa05fa7b,0xf3960e44,0x1424fd46,0x0619eecd,
0xf5df0aad,0xeea80d31,0x01e00bc0,0xfd74f4fe,0xf92dfe35,0xf98e090c,0x155af5ec,0x1321dc15,
0x00310643,0x158af31a,0xf8a6f73c,0xfe6e1104,0xf53210b6,0x1a75ec67,0xf632fd69,0x06c8f667,
0xf82f00c8,0x03200136,0xfcb4e9f6,0xfd3c0f26,0xfa2c0cca,0x0309027f,0xf96c0e36,0xfb67113d,
0xe9f6faa0,0xd2fc28bc,0xfe5a0ccc,0xfb670205,0x046bf8ac,0x01bcf566,0x2200f2b2,0x0660ee79,
0xf5fd0914,0xff4f05b0,0xf55b12f7,0x17e7e5e5,0xf25006d5,0x059b0254,0x1cc6ed1a,0x2b6dd29f,
0xf513f1a9,0x091efce1,0x0caff721,0x1ba2f150,0x118ce32f,0xdfac1276,0xf3a01d1b,0xe8d1177c,
0xfb2006ee,0xec5f07dd,0x0646f974,0xf3ac01b0,0xfd9d05f2,0xff070b69,0x05520226,0xfbe5f931,
0x0a5309c1,0x0289f2ad,0xfcb009a3,0xe9c0f691,0x02a9222d,0x169ed8e2,0xfec7ff46,0x0770f3ee,
0x1d9feee6,0x232fdea7,0x08b9e54d,0x10d2f9cc,0xf4aafb00,0xe95528f9,0x0daffbf3,0x0bc905bc,
0xf26cf104,0x11170c06,0x1440e11c,0x0698e546,0xf978f757,0xf0b10904,0x06ff11fb,0xf5a0f1d1,
0xf8e41708,0xe470010c,0x079b1714,0xeaf6f2ab,0x15731584,0xf229fa7f,0xfb5615c7,0xede90bd5,
0x03a91131,0xf97b04be,0x040df95c,0x0985f191,0xe6bef521,0xf7090d68,0xe3cdfc49,0x10d21ec5,
0x0bffeacf,0x10ae07d3,0xfba4ff33,0x2438fb23,0x0fe3ddd5,0xe3690700,0xef460aee,0xe6ba1275,
0x1ce1f249,0xfbf6e0db,0xf4ad1593,0xe1a91dec,0x0cc41153,0xf5250282,0xf0730e9f,0x06e60e4a,
0xe75404d3,0xfba60fe2,0x09e0f282,0x0709f2b0,0xfb9eeeae,0xeafd184c,0xf6641ca6,0x0d1bf6ed,
0xf26305c2,0xee1b0b32,0x1c9b066f,0x0bb7e5a2,0x039cf14d,0x193beebd,0x2527e0ca,0x0b0adeef,
0x006cfa1b,0xedb71f2e,0x0063fd62,0xfa910804,0xf3580377,0xfdf3199b,0x163af3e3,0x0c74e975,
0x1299ed9d,0x190eec32,0xec83eb9e,0xfd850920,0xeb800c82,0xe4f91bf6,0xea8216ce,0xefb91e2b,
0xefd8114d,0xfbd7167d,0xf741ff9d,0xe7bd0a4e,0x084f0eac,0xfd0bf537,0xe12209ac,0x02aa1282,
0xfe34fd19,0x093ff028,0xdb0019ab,0xf6872526,0x0659fa94,0x046303e9,0xfb85f63e,0x04f60bcb,
0x133bf098,0xf1acf852,0x0fc6ff94,0xfa48f5d9,0xdf120461,0xdb2b280f,0x012a1bf8,0x0309f718,
0x083f00d3,0x08eef60a,0x055403a1,0x268bee6a,0xf045ea1f,0xf39c1238,0x011a19b3,0x1050dc27,
0xef87fab3,0x028c0a47,0x06acf2bc,0x07bef333,0x0a9ef95e,0xf70c02e2,0xfdf3170c,0x0f7cfde6,
0xff4ff838,0xf7640586,0xe50d0bdc,0x098c03a5,0x0501f4df,0x04c4fe77,0xeb3ffb68,0xfbad192a,
0xf910002b,0xf3d90d82,0xfaed118e,0x016f017b,0xfaf5fe45,0x151bf681,0x0a54ec47,0x00cbf2ad,
0x0add125a,0x12fedc46,0xf798fe8f,0xfd15078f,0xee6a102b,0xf5d00b8f,0xf8770ca7,0x0062edc1,
0x073c0145,0x0489fce9,0x2b08e36b,0x1226ee1d,0x068e06b5,0xfdbbf60a,0xf3b20a02,0x032b08c1,
0xea3aefd3,0xf5801dd2,0xeb29ee4c,0xfb891635,0xfb4907d0,0x125904e1,0x214fe015,0xf28b02d0,
0xf3421003,0xe2790e3c,0xf51b2dbe,0x014fe68a,0xffa81738,0xf4bdf075,0xd7872774,0xfdc70911,
0x0f440259,0xfa07e7ab,0xe8ef15b5,0xe9ab1aab,0x01acfde5,0xe061183f,0xf1960e28,0xe4821db4,
0x12ef01a2,0x15abf23a,0x29d3e192,0x232ce6fb,0x187eda69,0xfc51f23b,0xf4c9153c,0xff84faa0,
0xeb130474,0xfba71268,0x13fdfa0e,0xfc14e938,0xf733102e,0x078df805,0x13ccf653,0xeb77f821,
0x01f20cdf,0x0f0af322,0xfcdf0fe0,0x04a80003,0xfcaf03b4,0xfd500258,0xfa12f658,0x03760443,
0xfb3cf632,0x15e1ff1f,0x17a5e711,0x0609f45a,0x041ff3cd,0xfdd30abb,0x0df5fa40,0xebdcff60,
0xf3641198,0x0236004b,0xff70fb23,0xf0d90cb1,0x205afeb8,0x0b7fdcd1,0x0425ffa0,0x112aeb6e,
0x1d6de72d,0xf7c5fc73,0xfd4006fc,0xfe22fe3d,0x1379fe02,0x080cece5,0xf13effda,0xf45620ae,
0xff2ffba5,0xe4d11027,0xd5662b77,0xfac31bec,0xeb7009b2,0xf9120f79,0xee0eec1b,0x01961388,
0xfe02f2ec,0xf808087f,0x1171f6c8,0xf5fefa9c,0x12eb0afb,0x105bf9c8,0x2762ea94,0xf932ee24,
0x0cbc1962,0x0381dbff,0xfcea0429,0xeb2dff4e,0xf3ad0752,0xe5fc0cdf,0xf6e00995,0x105efc6b,
0xf590000d,0x11f30be9,0x1b88e540,0x1c48f601,0xfa71ec32,0x1570056f,0xf9edee6d,0x11ad0447,
0x0617e1fa,0x020cfbb9,0xf5760148,0x01080caf,0x1618e6fd,0x157aea74,0xf801f7f3,0xda9c1634,
0x0dd70bfa,0xf7fcff74,0xf5051666,0xd1812837,0x071817a6,0xffadecf5,0x00a80c97,0x06bfe5c9,
0xf9bbfe1f,0x0faaf7f4,0x000bfc2a,0x18cdf4ff,0x15f1e000,0xf8ecfce0,0xe482166d,0x013a184e,
0xe3d00106,0x02ec1e91,0xff07f795,0xe78d10bb,0xedbf11e6,0x0be8026d,0xff8de775,0x0682fb79,
0xf6e208eb,0xef550c1e,0x019a15ee,0x0bc6fdb4,0x0bb9f525,0xf43500fc,0xfb640868,0x0284f1d8,
0x1d52ef18,0xe938ebfb,0xfc321961,0xf2c51274,0xf72513ce,0x15daf7a1,0x17a5e549,0x28d2deac,
0x08c1e02f,0x2adbf78a,0x092dcd82,0x2d6ff09e,0x0b44d4c3,0x15c6f80c,0x07e1f1e2,0x05adf694,
0x0b49ff8e,0x022af58a,0xe5ea25fe,0x071ff929,0x090707a5,0xf3edf308,0xe7fc11c1,0x0c3bf85a,
0x16b5e4e8,0xf099fb18,0x1d27f93a,0x18a5e9e4,0x13d7e966,0x0e2204ae,0x11b5efc0,0x0aeef133,
0xefef0b66,0x0fbdfd6f,0xedcdeffe,0xe644186e,0xd345184e,0x0df311ed,0x0e6af738,0xe6d70169,
0x08b91594,0x06390171,0x1029eaec,0xf053019f,0xfe110aac,0xf7c3ee80,0xfe0a1003,0xf1fb09e8,
0x0a3ff874,0x08f4023c,0xfe5cf559,0x077ef9ce,0x00e909d1,0xfa120090,0xf18111f3,0xfdf81111,
0xea9b05b8,0xfbce0181,0xf5a213a9,0x0846e4a4,0x0969f9ca,0x0d75e909,0x04fdfed6,0x28f0f8ca,
0x2b45e321,0xf091eff3,0x03ef10a9,0xfeb2fd2e,0x05f5ec1b,0xe7f00b51,0x05b4024f,0x151ee974,
0x0be5e9ae,0xf5dc02e9,0x11a9f9b0,0x0e110288,0xe57a09bb,0xf6da18cf,0x228bf390,0xf54af2e3,
0xe5bf1af1,0x07a707fa,0x09a0e953,0x0088efb7,0xf6bc01f0,0x0945f850,0x013bf723,0xf2511181,
0xe2e01c79,0x02d61176,0xfc760eb5,0xdea9155e,0xfda81f3b,0x028cf50a,0xf948f852,0xf2a00167,
0xff33ffd7,0x025df154,0x0a8bf912,0x0cfd0026,0x23d3dba4,0x10e2fe50,0x1029f3b7,0xf5790bed,
0x01dd0846,0xf31e0332,0xfb23fa83,0xf705fac8,0xee4b0415,0xf9e208d9,0xfa641274,0x0975f7a1,
0x11daf7b3,0x1893f39a,0xf1ebfb8a,0xf5bd08df,0x00260715,0xf3f3fbbd,0xf8221672,0x068e0056,
0x0ffbf4e9,0xf93a0264,0x03e0ff4f,0x08acf3f1,0x0c26f9b5,0xfe9dfa0a,0x0330eba6,0xeb0b133b,
0xfb8efcdb,0x11050480,0x0aecf23b,0x05c8033d,0x0ab00196,0x2a35e30c,0xfc31e476,0xee8b1125,
0xe9d2152f,0x00fef6ce,0xe5f60913,0xf1661050,0xf5c512bb,0xf5d813ab,0x0b490494,0x05a10229,
0x1101f8d0,0xf7d4f79e,0x0df401c9,0x1d5dea96,0x1249d01b,0xd43007b9,0xf9b40acf,0x1123fa99,
0xf55403e1,0xf9f00dd5,0x01dd1120,0x132ef930,0xff20fa89,0x140afad3,0xfcb7f60a,0x15f1f460,
0xeb9af491,0xfe4aff1d,0x0577fd0e,0x01a80306,0xf9fcfe6c,0x02220e11,0x0bd2f5db,0x031af9e7,
0x1417fb1e,0xe81dfdd4,0xeb340e87,0xdcf81c7d,0xed941039,0x03080b6f,0xf8080487,0xf0fe13e1,
0xf67d0e3c,0x09d1f7b1,0xfce7018b,0xe2fa0892,0xdcf432ad,0xe8950ba8,0xcf2d325e,0xfce40df8,
0xf5a00a9a,0xfa3a0662,0xff3805c9,0x082af098,0xfae4fb21,0xfcfd1390,0xf4ed0014,0x0c530d72,
0x0b1de993,0xf34b0b9c,0x1772ef32,0x1318ed24,0xfd0bef9f,0x00300437,0x0e76f393,0x1d58e491,
0x052ef3bb,0xe10113f4,0xffec1648,0x1268f03c,0xf760fb3f,0x0359fa8c,0x20acfa68,0x1909da74,
0x0903f52a,0x2664e91a,0x19cee762,0x0bc3e77f,0xf33109c9,0xf1340c5f,0xf47d07ea,0xec1c004b,
0xf5640697,0x08a70189,0x1382ec1c,0x037af56e,0x1024fb92,0x170af122,0x125cf131,0xea140780,
0xecfa1dfc,0xf6e20f04,0xfa94f850,0xd51921de,0xf64113ae,0x21f6ec3a,0x1a8be0ce,0xfb97eb3a,
0x095e0411,0x148bf741,0xf94bfae1,0x1637f948,0xe79305f0,0x033dfadd,0xfd370677,0x064eef4b,
0xfe270698,0x190af33b,0x04c6f203,0xfc25f84f,0x0ac3172f,0xd92a08f4,0xf7de1c9a,0xf9f2034f,
0x01def5bd,0xf771f8e8,0x0a7bfb36,0x0d29f64f,0x1662e3e3,0xf01a0f5e,0xf6ad0841,0x07741801,
0xf504005f,0xf760ff1e,0xfc3803fb,0xeb7b0312,0xf08607a5,0x057b09ef,0xe54502b6,0xfb521140,
0x130d0c89,0x03c7efa9,0x0d4f00d4,0x002bfe71,0xfbff00a0,0xf686ffb9,0xfaa903d2,0xe6c10726,
0xf544127d,0xf04a0788,0xf2510752,0x0bcf0874,0xfb0301e1,0x019f04ff,0xea580a79,0xe8fb1c58,
0xe9ee0e56,0x04d710cd,0xf1910749,0xfc4304db,0x028d01af,0xf96df78b,0x0a32f90b,0xfd17034e,
0x051bf808,0xe6f4077f,0x12c60c32,0x0a53edb9,0x2b44e66f,0x042bf6ec,0xf827f894,0xee5a0da3,
0xf4320ea0,0xf7d0fed4,0xfac8127d,0x17f7f519,0x0c16e604,0x176ced2c,0xe77c0974,0xf920096c,
0xffc603d2,0x02d002c4,0xe9a101af,0xfc261570,0x0161fb0c,0xebf7095e,0xeed519cb,0x06f7f9de,
0x17d3ec1b,0xf1261072,0xeb0305e9,0xece02407,0xffe11380,0xe9b50550,0xed760e25,0xe3bd10f4,
0xf72f082c,0xf319fd6b,0xf3a4050b,0x1f7efb97,0x1a03ec87,0x1061efba,0xf27b0840,0xfa7e129c,
0xe7431435,0xfec1023e,0xf5ff0a36,0x0cf5f874,0xf44c0287,0xf6540b04,0xf7ab095a,0x096cfe4d,
0x012bea52,0xe94c06d4,0x05eb0a39,0x149cfdbb,0x1109e88d,0xf6180c43,0x213cf262,0x1f78dc5b,
0x1219df3c,0xf436ee6f,0x06650e1e,0x0e6af856,0xf17c007d,0x0501105f,0xf56b08a9,0x0de20218,
0xe29c089a,0xf31c0c2e,0x0ee4fbdc,0x1be0d9b1,0x1810e4cb,0x1f53e226,0xf47602e4,0xff54fcdf,
0xe6e021e2,0x02900936,0xe1ee0f2d,0xda7f2293,0xd8722a08,0xfd001a7b,0x091de0dc,0xe2ee0c8f,
0xfbc808c1,0xf5251266,0x00c8fe1a,0xe95c1c71,0x27830189,0x14acdfa8,0x20cbe8b9,0x19b9e1ab,
0x14acdf9f,0x0774eba2,0xe91b0c1e,0xf0bd0ceb,0xff3111d6,0x0d49f21d,0xf35904e9,0x0c21fc74,
0xffebfc83,0x0923fbb8,0x069709f8,0x2549dd86,0x0a29ec7a,0xff62fa64,0x0942fdd2,0x06a7f6a7,
0x0420f3b7,0xdeff0f3e,0xf85e1389,0xf2030c10,0x18b1f60a,0xffadf2ab,0x0e90fc55,0x0086fc40,
0x0991ffdd,0xff0c02ae,0x0b0f00f6,0xf4bef855,0xe7471e11,0x0cb7eeb8,0xf6890629,0x0ccdebc0,
0x1d4ffadf,0x35d8d291,0x0b1ae06f,0xfb390d6e,0xf1320843,0x03de09ae,0x0ba0e560,0xdf450d26,
0x00ff0ac2,0x0e91febd,0x1a20e2cf,0xfa6f0f1e,0x0c37f705,0x1359efc4,0xf459fdb8,0xf0560874,
0xf8790645,0x0911fca0,0xe5821b28,0x0da0057e,0x0de2f232,0xfe22effc,0x03b60a21,0xfcf7e433,
0x1e10f7f1,0x0a41ea68,0x1ba6f9a4,0x09b6e1ce,0x07b40d40,0xf6670acc,0xfc9900e8,0x0be2f981,
0xf74af4b5,0x08650c94,0xf71ee6e1,0x073d14be,0x1b0be7b4,0x011d08f8,0xee2fed5f,0x0341160a,
0x1050f2c5,0x081fea12,0x10b2f398,0xe8d1f528,0xf2422022,0x02240549,0xf1f9024b,0xf6f9140b,
0x008b1724,0xfe7afb1b,0x11f2f713,0xff3df89f,0x099d01de,0x0b30eae4,0x0e41f1f1,0xfd4ff7f6,
0x16a9ff01,0xfde6e4da,0xe18b14d9,0xfd8a1b57,0x0489f273,0x0e3ee9eb,0xf987fc60,0xf79c23dd,
0xf645f203,0xf57e2046,0x0cd7fc7a,0x101dfd50,0x04dbeac0,0xfdaa024b,0x1482f34c,0x069df61b,
0xff84fa31,0x04e4f325,0xe5991883,0xfa4efd6e,0xf1ca12ec,0x071300f8,0xfc45088d,0x04d20027,
0xeebcfd38,0xeb5d1538,0x1237f852,0xf6600524,0x0e2ff297,0x1710fa01,0x0c80e692,0xdc051a31,
0xfea91d7c,0x0542fd30,0xe5350391,0x01c5143c,0xf37cedb5,0xf1d80e28,0xe4422277,0x0cbdf65c,
0x11d0f674,0x0895f9cd,0x0da8ea59,0xf60ff8f4,0xfcbd11ae,0xf6b6f79e,0xf520202b,0xff74ffd1,
0xf40517f0,0xfbc614c7,0xf2e104f6,0x1958ee64,0xe743ebde,0xe6b81967,0xef3409a2,0x0e3f07e8,
0xe6c6fd2d,0xeca23184,0x3b5cea51,0x130bce7d,0x162ffb95,0xfd75f5c4,0xfa94ffdf,0xfacdf95d,
0xe0b31cd8,0xfe180fa3,0xef95061a,0xfb9a101e,0xe8c401ab,0x1cb90ea8,0x1739d3c3,0x0fcbf58d,
0xeeb8036a,0xf9c00625,0xfcf8fa4b,0xdf451490,0xeada19b6,0x2462e852,0x07bef19f,0xef420c43,
0x0e8b171a,0x0535f896,0xf11519d8,0xf0ae1057,0xfab9001a,0xeb3af466,0xede81214,0xe353099f,
0xf510ff28,0x02830959,0xff9e0502,0x08c9009c,0x16580105,0x0689ef92,0x00390d6a,0x0159ff79,
0xf2090625,0x04a30008,0xe9270d4c,0x0d0e0141,0x035aedc8,0xec9b10ee,0x14a3f044,0xfea5f8dd,
0xf5e7faf0,0x07a205c4,0x0d14f474,0xf9e401ab,0x03ad05b5,0xed0b11f8,0xf8c61061,0x139ce67f,
0xecf20ae1,0x1680fcc7,0x08e5ef7c,0x1c08df12,0xfa7707b1,0x128ef4f2,0x0b4ff18c,0xf23803a7,
0x19d70261,0xfebaf201,0x0ec5ecfe,0xf30ff891,0x096d07dc,0x035ae709,0x0a05087f,0x1bfef34f,
0x15a5e412,0x0738fc7d,0x02d8fad4,0x268deda4,0x1b20cf4b,0x0d75f14e,0x165ae261,0xecf5fef9,
0xf34b15d3,0xf67902a5,0xe00b2a1e,0xd7b41a79,0xe3d42ff8,0xfb690a65,0xee1c0837,0x0011057f,
0xe4b60a57,0xec251527,0x101afe8b,0xee310103,0xe6fb1054,0xf1c228ee,0x0f57ff30,0x0296fb3f,
0xfd090a13,0x01d7fccb,0x11a3ec39,0xf000f68e,0xfb80fbdc,0x15ebf943,0xf7eef72b,0xe7241250,
0xe681218f,0xefe71869,0x03290726,0xfb8802a1,0x09ee02bd,0xef4b0943,0x0aea0ba4,0xfecff0b5,
0x0cdffbee,0xeeb2e47d,0xd2c42970,0xfd150f55,0x03ea0096,0xf9b20103,0xe76e1f21,0x371d066e,
0x0d6ed3cd,0x1492fd8d,0x03d3e299,0xf45e1061,0xf951ee66,0xe7ed173e,0x038ff232,0x0115fcce,
0x1b1df4f2,0x0b39e4e8,0x1c88fce4,0x026af33a,0xf5e61501,0xe9861764,0x1ba1047e,0x0ea8e6e4,
0x08bdfe30,0xf536fba4,0x1395e76a,0x062decf6,0xdf690483,0x028510e0,0x1222e4e3,0xfb0cff2c,
0xeef212a5,0x1a1307ee,0x013cf2df,0x2a86fa7b,0xf94bef18,0x1211f7de,0x0276f687,0x0058fe0b,
0x01fdf046,0xf2f50766,0x0832fc32,0xd4001525,0x132e0e81,0xef7df5bc,0x2615002b,0xfeb1f374,
0x240bf57f,0x017de8da,0xefaf0cb9,0x0731faa9,0xfe42e7e5,0x10e2f3bb,0xfa230a85,0x1c8ff232,
0xfbb3f4df,0x10aa0081,0xe3231bac,0x1b7a00fb,0xee51e8db,0x0b3c0623,0xe42406d9,0xe19f1d66,
0x03aa046d,0xf6480ac3,0xff8eff88,0xf4e40ae5,0xeb6b0547,0xeda822fe,0x1c39ed97,0x0214eeb8,
0xf18a046b,0xeacc255c,0x1402ff48,0xf1d0f855,0xf9771f5a,0x00d6f0bb,0xfc1506ce,0x05bbef13,
0xf844097a,0x0472fb66,0x07580133,0x23f6e60d,0xe813f718,0x022c192b,0xf436f1bd,0x08f114c8,
0xfa79f7b3,0x01ab0cb2,0x179de05a,0x0334f629,0x01b4f982,0x061cf363,0xf40d074a,0x0d8dfea5,
0x145d08c9,0x0e58de76,0xfe390f94,0x19d2f95e,0x1109e92c,0xf8d2eda4,0x0efefe53,0x0d3bdfe6,
0x0a9ce4bb,0xf9e7069a,0xf551fd1c,0xf8d617bb,0x1208fd46,0x2d1ae557,0x1883e470,0x105ff4b5,
0x08f4e846,0x1d12f9ed,0xe2a9fa94,0xe76e09db,0xde142797,0xf27a0ac4,0x001f0a27,0xeeb00c6b,
0x091605b2,0x0433f5af,0x0be80563,0x000fe42b,0x097b0bd3,0x006ffb21,0xff4df91d,0x08cc01b8,
0xf115f7ea,0x007d1281,0xfbbc070e,0x24d2f664,0x124ddc5e,0x06c5fccb,0xfc65fea0,0x22e2dd52,
0xf1bdf376,0xfa38f9c0,0xf45a0206,0xfa490b9b,0x19fdfdd0,0xfdd7f68c,0x22cf0f96,0x1babd2b0,
0x1d1defc2,0xf874f8e8,0x2ef9e884,0x0650ded3,0xedee0ce7,0xe4d90279,0x08b606eb,0x106df80c,
0x1d27daf2,0xfcb2f06c,0xed5b0f8f,0x08260514,0x04a20c20,0x0ea6f4e0,0x0675fbfb,0xfa14024c,
0xef9800b5,0x213fe8c0,0xfd39f3b6,0xef1e0405,0xfc4013ff,0xff330bc9,0x1389e7e0,0xf4d709f8,
0x080404ca,0x05f3ed95,0x0bb20001,0xec68042a,0x168bf325,0xfcc1fb69,0x073efd1b,0x103cee3c,
0x0fab0015,0x0d01df38,0x0ffaf157,0x07f6e924,0xeebfff88,0x15cc073d,0xe8170578,0x02b012f9,
0xfa3a0d58,0xf14d1237,0xff6d06b6,0x1e93ecdb,0x137cd783,0xed94033c,0xed9f0d38,0xfdc700a1,
0x1117f0c7,0xecf905a1,0x07b10252,0x0f29f580,0x35fae013,0xf6b5f604,0x04be00ec,0xe42d1ad2,
0x0b030292,0xf947fcce,0xf52102de,0xec27085a,0xf7e307bc,0xe18918c9,0xf274160a,0x1769f837,
0x07a4f13d,0x1135f495,0x0ea9ec69,0x0181f457,0xdb54183f,0x00a71a75,0xe73a0074,0xde192a5f,
0xf22b1dbd,0xf3b50629,0x1366f370,0x00f6f6d8,0xfd80fcbf,0xf4e0fa5f,0xf44914b5,0xee0c0c7c,
0xfba40e43,0x06250316,0x20dfea74,0x2de1eac6,0x1e3ecf8a,0x135de480,0x18e6ed64,0xf195fabc,
0xed4a0896,0x032b05fe,0x0d55eaaa,0x14f9f880,0x02c9f957,0x12d8f107,0x0c6af84c,0x296ce6a8,
0x0daee237,0xffc603ef,0xf60ffa75,0x09b9fb11,0x106aeb1d,0x0074ede6,0xff55002e,0x058d0398,
0x126fecde,0xff6a045a,0x13a400bb,0xf4640066,0xf4910fc3,0xf4370a6d,0xf70f05e3,0xeffc0635,
0xf3aa064e,0xfc4109ef,0xe96f09ec,0x063908c9,0x066af387,0xfedd096c,0xf65805ec,0xf881f9ee,
0xf59b0840,0x0ec8fce8,0xfb9df90b,0xf1b00e3e,0xf666176e,0xf96c1902,0xf914ff88,0xe79a0c03,
0xf2840bd3,0x127d01d7,0xfde7eb9c,0xf06209e6,0xea51177c,0x021d159b,0xec30fd35,0xf7e10871,
0xf1530499,0xf7eaff0c,0xfd321737,0x09f6ec27,0xf6d51046,0x0d6bff0c,0xffcdf9be,0x0004fc14,
0xf9c51938,0x1095ef2d,0xecdb0756,0x0a9710b7,0x0580e8af,0xebee104c,0x0770f358,0xfe16f960,
0x05b0f3f8,0xebc40376,0x1056fff8,0x1319fa48,0x0f95f5b6,0x0de9eda4,0xf4220fe7,0xf2df0e26,
0xe10b1337,0xf72d1b28,0xe4b00357,0xef0c1da3,0xf47307d5,0x0029f67b,0xf962fcd5,0xf2210c2e,
0xf7c60780,0x00f2093d,0x0abc0514,0x0762f819,0x03db10de,0x14b0f2e5,0x0591e3a3,0xe4cb1435,
0x0388016c,0x005ef2d6,0x01ef0424,0xfef2f21e,0x0c56ffd9,0x020ffb63,0x0a6f0023,0x06a1f793,
0xfaa90bbd,0xf88f0456,0x08c406aa,0x11e0e69b,0xf74cfe3e,0x21d2ed4d,0x050be70e,0x16c6e862,
0xfb76fbb6,0xe9111acd,0xfe7008cf,0xf1720e1e,0x00f10e4e,0xe698f665,0xf42f264a,0x0a08f360,
0x0638fb41,0xe7631169,0xf8a71014,0xebd60be6,0xf7671577,0xfedff89a,0x119af4bc,0x1358f239,
0x0086ed3b,0x2703f5e3,0x04b1e458,0x08d1fbfa,0x136ae920,0x064cfb4d,0x0295fb6c,0xfaf30f27,
0x04720765,0x1dcee761,0xf901fd25,0xdf5f0e7e,0xf3450814,0xf21a0963,0xfa9103b8,0x0cf4f8c3,
0x153ef700,0xfe4df54f,0x12fe0c78,0xeaa60122,0x037e0404,0xfcb70163,0x105bfd72,0xeac8f0a0,
0xe7a31db1,0xf5481065,0xf6d10e45,0x003f07f1,0xf579f99d,0x054b0540,0x080302f0,0x1bb5f0c7,
0x1b05dae2,0xfa47fd45,0xf66b0aed,0x24cae286,0xfbc3eb5a,0xf21a0f48,0xfbcb09ca,0x04560cd8,
0xfb8cfe37,0xf59815bd,0x04ecfa4b,0xed4ffe61,0x0283fc66,0xe10d1403,0x033905e7,0xf5a20d09,
0xfb0a11c8,0xf59306f3,0xf77f0d8b,0xea1c0a53,0xf66513b4,0x01e3fd55,0xefaf0440,0x087bf52c,
0xf62611c3,0x2097ee5c,0xedd6fecd,0xf2da1152,0xe6ca11fa,0xe9b82215,0xec540cfc,0xea242584,
0x27d3ea11,0xfef2f9ff,0x1ee9dfc2,0xe7ce088d,0x1e75f0c2,0x089ee90e,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_17_standard_DRUMS_chcrash[4864] = {
0x00000000,0xdaf42044,0xf8a107a5,0x0145ebc0,0x3269f787,0xfce0b9f5,0x0d993252,0xc646ef37,
0xe3e2f58a,0xf017c1bd,0xe9a6f19f,0xf3f7ee32,0x195bfd4c,0xe423f879,0x00f02ef6,0x02580688,
0x0585056f,0xe5980b25,0x1a50dc5f,0xdeb00f54,0x15821b67,0x17a4e157,0xebede909,0xf01ff29e,
0xe3621c5e,0x1aca13d0,0x0b2f039b,0xf8a30e01,0xe7e3f474,0xe195d6c0,0x1acafa43,0x01fbdab9,
0x2db6161d,0x0d8cf03d,0x08f5226d,0xe73c3a72,0xff6dfffc,0xfe78eda1,0xcfdbf0a9,0xdb6411ba,
0x0c76119c,0x422416be,0x4c30ef0b,0x16e7eb34,0xe0c1ef95,0x10ecd31b,0x13c9cda5,0x16f50878,
0x05b42f06,0xced60d8c,0xf331fb32,0x175fcff8,0x091a2966,0x0bb144c6,0x1d73d857,0xd745d4d4,
0xc9b2e173,0xeee61ed1,0x0bcf3a62,0x256326a9,0xd4e1e611,0xd7891b88,0xfdc503a3,0x2b0bdd5b,
0x27830590,0x1637dc5a,0xfc95c340,0x1985002b,0x01d40d1b,0xecce1b77,0x06fc1e79,0xea0fe923,
0xec2e0807,0xde9d2df3,0xf8a71275,0x2ee1100f,0x2451d2b2,0x1d1fdd89,0xfed4fd8b,0x0390f52d,
0x0f230832,0x00a9f05d,0xcb3a17af,0xdcc109af,0x1c6aff47,0x064af317,0x00c81fb2,0x20b32121,
0xe1f3fa13,0xc088ce05,0xf6fee762,0x19fcff8a,0x18c33b4a,0x0e674ae9,0xc8bf19fa,0xf752ca6c,
0x16af9d43,0x17aee6c8,0x3e7d11c7,0x12261570,0xc49a0770,0xc60b0639,0xd88a1790,0x0062f3f7,
0x27d7fcf4,0x30f80f5b,0xefe8f32d,0xd07ef290,0xf00dfd2a,0x0910e89e,0x16b715df,0x10a11107,
0xecf3084c,0xf56f321c,0xda8b017a,0x023fceb1,0xba782ec4,0xed9d0e5f,0x4fb80ae4,0x08de0513,
0xf4ff15f9,0xc03fef0b,0xdc22fa38,0x228bfe33,0x1de5d318,0x0bea0b24,0xf22a1ca1,0x20f0ee14,
0xf554e9ff,0xf1f9f750,0xfe4e0667,0xee93f4ba,0x32bd19cf,0x2702dc81,0x03f6ff0e,0xe79c04e0,
0xe17a0247,0x07c8feea,0xf9a22685,0xe88d47ab,0xe233274c,0xa5eee644,0x0891f69a,0x2b7fa925,
0x5ada113d,0x3f092286,0xf25908b0,0xd41ddb7e,0xdd81aa96,0x007ae751,0x187a00a0,0x19662a90,
0x299d2bb0,0xfc592316,0xc028f642,0xf4b305f5,0xf1d7ca17,0x07abe72e,0x29fc1f53,0x1d192fc9,
0xf8affc1b,0x2130009d,0x00c6a709,0xf925f1de,0xdf773f90,0x03450672,0x100f19c6,0xf5b909b8,
0xbbe2138d,0x9e323bdf,0xc8c745b3,0x101631dd,0xec152338,0xd2333c6e,0xe408ef72,0x491bc91d,
0x20c4c744,0x216ebef9,0x3178f355,0x1ebfd0a2,0x0f0ffd43,0x2ac5fa29,0xcfabd7a8,0xa8782be3,
0xc84a0977,0xd4701811,0xff9a720c,0xe87f3c0d,0xc2c401ce,0xf92cf6fd,0x4718ea16,0x0e68dac0,
0x073801b9,0x17f801b1,0x1ed5d531,0x3468cc20,0x30c6eb3f,0x0a00fcd2,0xe09e03b1,0x053d1407,
0xf4781263,0xcc233d6e,0xca274cd8,0x01dbc945,0xc276f1b2,0xe96443ee,0x2d2a581d,0xf2544a6b,
0xcaa3f425,0xbf93b5e9,0xe598d0ce,0x5b46fd41,0x53650103,0x2bdb05db,0xce3005b5,0xbc57aa80,
0x1a56dc0f,0x3f2e1886,0x34ebdea4,0xf2fcdd12,0xea74fc3d,0xbb6b1886,0xe5603491,0x0d6f2afb,
0xd4451b42,0xe304fe61,0xf44713e1,0xebab287b,0x47ecfe4a,0xfb6dd53f,0xeab9bf72,0x0b68e87e,
0x27c50d9d,0x657d0980,0xee32273a,0xb5a3d034,0xce7ddbd7,0xe54ff298,0xf2144e72,0x06503c6b,
0xfbaf59c1,0xdc191ad2,0x0045ddf7,0xcb9bde67,0xed820d4f,0x183111b1,0x0b650f51,0x280b0637,
0x30a6e7fc,0xdd6bd6fb,0x1665eaa6,0x4975c1ae,0x2af0dfdf,0xd22af2d8,0xe80e19af,0xd6364a97,
0xd2f11703,0xde790bf0,0xba9a14b5,0x23f5218b,0x0d4f390d,0x10cf2596,0xe906c8fe,0x0d7ecc24,
0x41389bae,0x2c77e40e,0x184217a0,0x313f0358,0xe8c50344,0xc6f71429,0xa7fafb0b,0xde363f67,
0xde50624c,0xdb9110fb,0xe3791fcd,0xf2f41858,0x195fed9f,0xf925dde7,0x1df21257,0xf411247d,
0xfbbb033d,0xfdeec821,0x0512ea4f,0x07ff1a59,0x1cb5e365,0x3c63b970,0x45b91613,0x1bf2bdd2,
0xeb771b3e,0x8dff2365,0xa7fc37fa,0xde6520aa,0xdd4a08df,0x45603923,0x3053465a,0x026502ed,
0xe384bdb4,0xecf19333,0xdfe8001e,0x3e6f1d67,0x4b9c1c19,0x042f1551,0xee30126f,0x131fa0c7,
0xfec1ea94,0xe0f7e447,0xe8b35655,0xe0784a6d,0xc45614cc,0xc2131e57,0x1a791031,0xe627e46c,
0xec952cc8,0xf4381611,0x46befe48,0x07c9aa5c,0xf14add86,0x035800ad,0x02c5f1b1,0x159c0019,
0x55bfec27,0xd2a513ab,0xf51619fa,0xbf3301a4,0xe5c8e981,0x196bde26,0x02e81bb4,0x2234270c,
0x15530005,0xcefe3f2e,0xbdf73106,0xb160b4e6,0xe6c1fc65,0x40752da9,0x30ef44e2,0xf5aa24df,
0xe75dcfe7,0x0b0e9ef8,0xf8e50dda,0x3abc3819,0xf8a81491,0xcb24ee78,0xeec109f2,0xdc6cd9ac,
0xfcc23c80,0x2a271074,0x02672577,0xea45ee44,0xf114c0be,0x387ae65b,0x2b3ce927,0xf680cb89,
0x42bded38,0x155d0ef3,0xe7c6ecf8,0xff43093f,0x98b44445,0xd95b2c2e,0xf564ea5d,0xe72a0c6f,
0xfdd91c5f,0x1c974ec9,0xeb7a170e,0xd044fd64,0xeb90ccea,0x1137ef72,0x3931fe5f,0x56d2dff3,
0x016f0c83,0xe3ba02a1,0x0ceeb6fa,0x1800d49c,0x42f9feea,0x14dae35e,0xd3d4262a,0xf44711b6,
0x1024f904,0xe530deb0,0xfa6e0c3b,0xdb7521f0,0xe4f0082e,0x1e8415b9,0x0ff12076,0xf342e26b,
0xe897e6a3,0x15faea1d,0xe379da81,0x345c3165,0xfae152e8,0xff19c5d8,0x957e18dd,0xccacff69,
0x1f230a0b,0x2ae130b5,0x15e13243,0x1cbccd3b,0xeca9cf69,0xd05cf09d,0x33eae104,0xf16030cc,
0x417203c0,0x05690f1b,0xb5da3dce,0x0154e3bb,0xd5b2e01f,0x430103d3,0x15e41ea9,0xd40d31a2,
0xcf14074f,0xeeb8fe62,0x42cef518,0x3418cc94,0x15a4d423,0xe57e09d0,0xa8780cbb,0x2541fc29,
0x2da6022c,0xe4b706bc,0xc401f709,0xcc3cf246,0x2eed21ed,0xf2730bd2,0x4a9035a5,0xc9a1a2cf,
0xcd200514,0x1c67fd31,0x099ccd5e,0xfb465e7c,0x1b9ce418,0xf3ee22cc,0x1ec70899,0xde42e89b,
0xee54be4f,0x4337fb3a,0x199b0573,0x4989f295,0xc982fbaf,0xd99d2e92,0x11c5f7e3,0xfd07eaaf,
0xebbd164c,0x1d01038e,0xdb5b3e93,0x1e3ef60f,0x0118f7f0,0xeb07abfa,0x0206ec07,0x1eaa477f,
0x40cd03be,0xcea7da3e,0xe0a22b18,0xec51b803,0xf87b0b6b,0xd0fc3134,0x191506f3,0x001417ac,
0x39a7d4fa,0xb447127d,0xf19deb59,0xc94213ea,0xef0e10b6,0x399133ac,0xf0d8d7f3,0xf5491f31,
0xf79fd1cf,0x07d10b5b,0x1d7cff9e,0x3391c9b2,0x128e0be1,0x0e9ac5de,0x0b9e1047,0xe4e805d4,
0xde8b158d,0x19c110de,0x1befcc8d,0xffc123ab,0x15cd2059,0xe6bed7ea,0x1224fdcb,0xdcecf629,
0xd7ebfc4e,0xe98f32df,0x1c623c37,0xe7da49a8,0xeddbe2ba,0xc0ee0f50,0x235ec58f,0xf73a08f1,
0x0c9f0e3e,0x4ccbee92,0xdabefad2,0xe8ea2b69,0x0ad89f35,0x24ac2dba,0xd64ff28c,0x3b0019ed,
0xef77de4b,0xfc6ab57c,0xf02e07d5,0xf3fd01cb,0xfd614b3d,0x37702491,0xf6b6fa55,0x9edf066c,
0xc08f34e8,0xf34bd518,0x41830c96,0x08f121a6,0x08d206e2,0xe1251b6b,0x04e2144b,0x31f5dd22,
0xff62d5a3,0xccb80bb3,0x2b2fe574,0xefd5ce1f,0x48e1fddc,0x1f1801d1,0x360b130b,0x0eade476,
0xcec8b993,0xd44906a2,0xe6050ffe,0x04ff0ef3,0x16bd320c,0x96271f07,0xeae837e6,0x01a31619,
0x1fb8fe3c,0x0a67cb9a,0x4885f83e,0xf8378dff,0x0d95e25c,0x24dd0bff,0x2611ed13,0x0a8d297a,
0x2233f655,0xcaaae958,0xa80c2cd2,0xd4453c8a,0x02e0f89a,0xfe1d3f58,0xaf780efa,0xf83c2f58,
0x11095ea2,0x00bce95b,0xf7d4ed57,0x2d50a816,0x0c4dd4b2,0x3d7c0619,0x4edff6cf,0x0d608dff,
0x3606e773,0x23f5b975,0x2a26feaf,0xe81139f3,0xb556057c,0x9891facd,0xebde05ac,0x0a450fd1,
0x1a074e62,0xc13632b5,0xf4a409b1,0x086fbe49,0x2310d5af,0xfa80f250,0x186f01b0,0x1119fcf6,
0x09eaec72,0x1677d8b5,0x16a3e959,0x10f20539,0x25490cbc,0xe9411d59,0xe223be54,0x1509f60a,
0xe8764113,0xd529027f,0xfe235e67,0x09e6df36,0xf68f0b9b,0x03d9fc1f,0x0a60229e,0xe14df653,
0x2dab1900,0xe5b2b9c3,0x5ae4bd38,0x34f0d8ac,0x4c61df95,0x32c1082b,0xd554ed2d,0xac1501fa,
0xeba6daeb,0xd6e81b45,0x1f001fbe,0xf7ae43c2,0x972f1b63,0xf44a0c99,0xe94bf97b,0x1c54f855,
0x102d28d0,0x0a0e0bb9,0xd585c37e,0x1762df8b,0xe509ff35,0x213efe3a,0x17205fb4,0x14bed3c9,
0x2306ebe9,0x186ec969,0xe57df04e,0x09b007d5,0x03f7c60d,0xd462004a,0x4a562d31,0x1a941efe,
0xccc84766,0xdaaed98d,0xb325e671,0x129618d6,0x0851fa1c,0x3ac82034,0x21b6078a,0xee3ad6c0,
0xfdc6ec04,0xed7ae0c2,0x3ce010e0,0x3994117c,0xd732e242,0xffa9fe9f,0xd675b16c,0xf1d1317e,
0x1d2f201d,0xe9a52c05,0xedae3387,0xd90c14e1,0xc793fb9d,0x399bdf11,0xd38a11ff,0xeb2efde5,
0xebabec0d,0x12c86227,0x5ce6df2c,0xe18c2b03,0xcf69ce40,0xf938a3e1,0xfed42a9b,0x31bff00d,
0xd6fe243b,0xe6fb5712,0xf252f07a,0xf0ea3c3e,0xdcedc943,0x1e27f51b,0x5b4de40e,0x1875e120,
0x047ece2d,0x2223ef70,0xbdb303f1,0x66b4f35b,0x1037de68,0xb1441207,0xfea157e3,0xb2a30a1a,
0xe05c020b,0x23a4f8ae,0x0d18fcb6,0x22e60994,0xfe44edb2,0xf8112a57,0xf984fbda,0xf462f922,
0xf272ed55,0xc1f5ef75,0xe5ee3090,0x521830d5,0x1f6be4e3,0x14e5f4e9,0xc860aa83,0xf209dc61,
0x1a6f1222,0x3dae2ad2,0x33f0f03d,0xe306eb14,0xa999e69a,0x0944c43c,0x08d05142,0x0d9c3dec,
0x3c6a1023,0x9d5ffcf7,0xc5beec1b,0x03a7fd77,0x02080dec,0x48a2355e,0x2ab2f053,0xbc8ae052,
0xd7ffdff7,0x0be947e3,0xe66a2210,0x26c8e6fb,0xf680e89d,0xe4cde9c3,0x0d232b19,0x40780af7,
0xbe72c908,0x2322eb5f,0xee9ff223,0x1148e417,0x10eb44a1,0xbcc12064,0xd73139b4,0xcbc1f229,
0x1055dada,0xf236daeb,0x34933cd3,0x0834266a,0xe0c5335b,0x0737c753,0xe81baf57,0xe202329d,
0x00440651,0x00054e02,0xe9ed0e6a,0x1cc2f849,0xfd69fab3,0x28e8d7ae,0xe6f6fb64,0x2023e789,
0x058a01fd,0xf37af458,0x05623cdc,0xe90ee853,0xf4493134,0xc0f4fcb2,0x20860962,0xfa3b5b1a,
0xe3acce88,0xde1f2492,0xd9c2d1e4,0x28951812,0x09a90b63,0xe1573d82,0x1b83ef89,0x1ba0ce0c,
0xbfcb0096,0x28d8bab8,0x0b7acbbd,0x60da2408,0x109e0610,0xe8f2d89c,0xfd21c948,0x054d096b,
0x314d0250,0xd981f217,0xb16939ed,0xcb1f4faa,0xf43f12a9,0xc7f9293a,0x07c40f05,0x12bc0b34,
0x1490e7e2,0x5b84bebd,0x21a5dd11,0x2fe4e1b3,0x058db9a7,0x45d9e647,0x0be9c5bb,0xfa620950,
0xecff1bcc,0xd8ca5c63,0xb0266585,0xad03fdc3,0xb9471674,0x053ffb15,0x258c3b0e,0x720c1425,
0xd81af5c6,0xcc8fd26f,0x56aebf22,0x1686a00f,0x51433412,0x0057d302,0x2c3de04c,0xf41f1795,
0xcc37fd53,0xdec2ce26,0xc5b3581d,0x0a615dde,0xd8740e8b,0xa9a9161e,0x086f4b4f,0xefe2ccf3,
0xd969f91b,0x0960152c,0x28cd0447,0xe4c0f597,0x21fe13c0,0xb87a158f,0xe8731979,0x163fda32,
0x4aedf00f,0x39e58dff,0x0914e6e3,0x200837de,0xde72e374,0xd81f2ba1,0x0e45d79c,0xf7931f0a,
0x08f12645,0xde32f075,0xbd0338fc,0xedbae125,0xfa7f2cc4,0x2fe2fd71,0x1b96158a,0x1f15f384,
0xad6000c6,0xd793e9c5,0x38e6fba0,0x2ca0dd0a,0x0aafe592,0x16312f6e,0x29fbdf21,0xf7facac1,
0x3cb5e03d,0x2b9dce7e,0xb5152444,0xc93c2ea8,0xbe0e1449,0x2c95f25b,0x04fc3de5,0x3c9c04a5,
0xc2b9087d,0xf37adc2a,0xfee8c600,0x0beb1029,0x6e401b49,0xdbe1f547,0xc128f7dd,0x1ab89c50,
0xf65e4459,0x2e601bec,0x18690ce8,0xe4b325f9,0xbf82c554,0x0224ca16,0x07fad2c6,0x59ed0e9c,
0x30ae390e,0xe030eab8,0xc29110b7,0xcf71fdf3,0xd2e9ffb9,0x20fb132a,0xd2d60c53,0xf2a7435f,
0xe8803fb4,0xea0efbcb,0x45e2d6b3,0x28b3bc4e,0x05bf0fa2,0x17bcfb76,0xf1679ccd,0x0c1f3b05,
0x33c9e66b,0x1b13f609,0x026a14a2,0xec27f61b,0xd7473ade,0xdbe5fa8e,0xe80a0aa5,0xfff1348f,
0x1200f812,0xd7462215,0xf792ef32,0x15ee3488,0x361bcfc1,0x0a42bd48,0xf7d60aa5,0x43febc89,
0xdf2ade8b,0x684fddb2,0xe113e725,0xe1282e31,0xcb7a202b,0xd153f9ab,0xf49846bf,0xc8a712dd,
0x000c2acb,0xbb310062,0xfe0b21c0,0xe47a3403,0xd63b179c,0x00a51ea3,0x1894d654,0x2cd1f782,
0x34c1ebe8,0x0116e3cf,0xe52505f3,0x2f5ed619,0xf478f5e0,0x322d2630,0x0caefa0e,0x04d30f11,
0xf86cb14a,0xcf2e15eb,0x06dc1c38,0x0b432842,0xd8902c40,0x0447f408,0xd432eb4c,0xda5430ce,
0xe57625f1,0x293b1217,0x1063e323,0xf19811b7,0xdcedd913,0x02fdd872,0xeeab576b,0x4ce8d360,
0xca3ffcd3,0xfff11f07,0x2271bcbb,0xfc2adf52,0x5962f28d,0xaf1e0ad2,0xe30e3e68,0xc424f0dd,
0xb0f628f0,0x1f153638,0xe06f234f,0x09e357c4,0xddc6ad24,0x0d3130dd,0x1278e900,0x11c8af23,
0x2fa21152,0x35fcd55f,0xfbcb0832,0x130ddabd,0xd1c1315f,0x2aed050e,0xfac5c6f4,0xfab0fb71,
0x147ce6b6,0xd355fc0f,0xe5b24ab0,0x07fde942,0x1fe1367e,0xb6ce2a6f,0xb4d1f8e4,0xb5ed112c,
0x00a11423,0x3d5d35c6,0x1e2bdcb3,0x0550d243,0x00f8f81d,0x08b2d232,0x0ffa003f,0x10fb1bba,
0x193807da,0xeaf1bd9f,0x027bc16d,0x3bb52400,0x52b5d482,0x0a3ef387,0xf9ffe219,0xe909e952,
0xb1a16aa7,0xe2e54a6c,0xb9990bd3,0xcbdd446f,0x33ef00cd,0x1135e53a,0xe7affcf7,0x1faa3f25,
0x1bfee61e,0x1828e4c8,0x0e068dff,0x17690be2,0x34ac0661,0x1d0b12ca,0xe671d996,0xdacccebd,
0xded22686,0x0cb011b1,0xec805408,0xeb1a2ec5,0xa17ee03b,0xeacafe31,0xf650dcaf,0x34c66a55,
0xf5412136,0xca49ed2c,0xe5980318,0x111f9df3,0x1fcc33f1,0x1f03181e,0xc8aa0d01,0xea11f916,
0x236fd531,0xebb61df1,0x0e9807d0,0xf4a90d91,0x0680167a,0x024eef7d,0xd25b272f,0xf16a1281,
0xf9cef3fc,0xc8a351f8,0x421fd712,0xd82d192a,0xdfca0c89,0x3b2e0977,0x0ef1028d,0x5952f0cc,
0xa56bd253,0xf760b944,0x078dff67,0x25483a9b,0x374a2c5b,0x1152cbfe,0xd0f3d8bf,0xb1f009bc,
0x1d290ead,0xe67a0be9,0x02241833,0xd3e72d44,0xfeb1e394,0x02211399,0x203aece1,0x2eb90178,
0xb6c2138a,0xfb4e1391,0xdecaac0b,0x18c9eefb,0x2c35356b,0xd3392cc3,0xfc5129a2,0x3105a9e4,
0xfbcafd13,0x312edf44,0x0e30df78,0xc0df1ad0,0xdc49ee11,0xfb6c20d3,0x41563a91,0x01191c47,
0xfc44dfcf,0x0707d04c,0xf6adc242,0x1f411a8b,0x097a24a7,0x3522c441,0xc5b60a77,0x1ad7e271,
0xd07b6608,0xf47600a3,0xf4b410f9,0xdf3c05d5,0xef01df21,0x1e84d41f,0x379c1891,0xf9d20d83,
0x1293fac3,0xd8851490,0xca91ef64,0x0a731baf,0x052d0361,0x0ab505c0,0xebfbd81c,0x0af01c82,
0x30b0ce3c,0x5929e195,0x1186f714,0xc8bcf07d,0xb9d9eade,0x1ba20aca,0x2ab9f66a,0xe02a3e9d,
0xe7a2ef2d,0xf6731fea,0xdb411d01,0x1a6ddc4a,0xeab7077a,0x3a92cfd2,0x23eac88e,0x1dba1f62,
0xf738047e,0xd6bd067a,0xb929fd64,0xe4fc1ec8,0xe66a2c0c,0x16b73dc9,0xade26ff5,0xeca8a85d,
0x2698fdac,0x28bdc710,0x1760046e,0x0b9f158a,0x1de8f0f2,0x110dd985,0x2cc0f721,0xd05ce8a1,
0xfc3b0b28,0x24961ccf,0x1e00e2b9,0xfabfe3cc,0xc85b00fb,0x18d85e28,0xdbfcf12f,0xdb870d56,
0xeec5da98,0x0f7e39c7,0xd3463363,0x1c66df6e,0xf5daee01,0x0e7ad92b,0x0d0eed64,0x13541265,
0x18c50730,0xd4cc142e,0xcceb09a8,0xc4fce321,0x06fd1e27,0x218d3817,0xff9ff85a,0x02e0fbba,
0x0deac5dd,0x21c629ce,0x1043d925,0xb0efce33,0x19553ab7,0x12cfe341,0x08222618,0xffcb1196,
0x2e22eddf,0xb25d0ab7,0xe908cca2,0x054b464c,0x2b67107b,0xeb2df3b6,0xe73b30f3,0x3412ba94,
0xe7161211,0xfa70004c,0x2692fe0c,0x0e831493,0x16e4eeef,0xf52efd90,0xe7b88dff,0xf36015d9,
0x24b0627a,0x1cf616c6,0xc4270361,0x3b81c9e3,0xd181d2a9,0xded14bf7,0x164fb9bf,0xd35e1e8d,
0xfeda395e,0x3dcef305,0xe86d00be,0xe1a12b3a,0xca632585,0xc515ce1e,0x0126f314,0x2b5518f7,
0x3eb30ea0,0xf47f2175,0x52e7ed1b,0xb6dbb3fd,0xdc2ef387,0x3b5beb04,0x160700dd,0x0d6c54cd,
0x1b54a595,0xdcd8179d,0xd662eaef,0x18571222,0x51b611ff,0xd6c90b7c,0xd7fcf538,0xff3f0fc5,
0xba61fb18,0xfdf9e0d9,0x08393baf,0x154d319c,0xf1aadaa3,0xe56319bd,0xfa0d0502,0xea9bde24,
0x00d0f74c,0x578393f4,0x23c0e647,0x31be13b6,0x0ee70d7c,0xfc08ef40,0xea54b5de,0xcf0ded04,
0xf984469f,0x03c31121,0x0e144ab5,0x4353d08b,0xc78be6f6,0x03e8ee94,0x15ade3dd,0xbee151a5,
0xe9fc3ce6,0xdfe02058,0xf0651d3f,0x1649e216,0xee740861,0x3fc8d305,0x0a24ffe3,0xd89f559f,
0x2bb6a711,0xf999f586,0x045b0a98,0x153ad0d9,0xf337ffe9,0xeead3327,0xfad0fdde,0xeef3e446,
0xf7a33fe6,0xed1ff075,0xfa4ed828,0xac61f9f9,0x2cdaf978,0x1e163848,0x3b524eab,0xf5c98dff,
0xa0c5dc0e,0xf393d744,0x43a81be1,0x0d8e538b,0x41bafc62,0x0214c3a8,0xc22de876,0xce5a04c2,
0xe41e1d46,0x4a461653,0x06594205,0xe22320ec,0x9cec083b,0xd0e24632,0x1458b2c6,0x0054665f,
0x3a7b0327,0x3cf2d655,0x2020c7fa,0x3bebc8f2,0xc2dae303,0x23d0020e,0xdc5a1bef,0x1b77f3cc,
0x33bc206d,0xc353e3f6,0xd17b3922,0xecd9b92c,0xd8da18ae,0x312e13cb,0x1a0f072c,0xb2e430eb,
0xeb31ed57,0xc9f7fdf5,0x0039080d,0x18ea235b,0x144f0935,0x1c35c30d,0x0420088a,0x5558ca8f,
0xbce0f0dd,0x27ee09cd,0x4e8d8dff,0xd48f243a,0x36742bf2,0xc04e28e3,0xe8471cc7,0x155cb614,
0xf743eab7,0x14601ff3,0xf4be2d77,0xaf3351e8,0x1525e8f8,0xe4b943b3,0xcf6ff99e,0x0042e170,
0x2a272172,0x3420d5f4,0xd2b61473,0x0fbdffe9,0xfa65cd05,0x0cb001e4,0x2ce9e793,0xcd26fb94,
0x045f5936,0xeb4af576,0xa359f81d,0x47e0e632,0x002ee706,0x36d6f6d8,0xfdf81da6,0xdbc50855,
0x1349e5c6,0xe25705a5,0xaff50793,0x26242d04,0xdbe7e187,0x062d2313,0xf3c62a82,0x31493dbd,
0xe71dc264,0x2fb9c3b8,0xe5caa0cf,0xf359193c,0x36e736e8,0x40345292,0xcde1fdbe,0xebfa9d59,
0xaaf4ee24,0x29e3244a,0x720cd54a,0xf7fd1231,0x01151bf2,0x06e18dff,0x941419b1,0x280b20af,
0x140a315b,0xa7202b92,0xd4b20d95,0x241df30d,0x21d5d9f0,0x01e0f7d8,0x17b3eefa,0x0bb8c85e,
0x30a520e3,0x2af6da48,0x0822e32c,0xe280fcce,0xb7dffb27,0xe9f72c02,0x3c0104e4,0x0a8228cc,
0x2f8ce08b,0x0e44fa7e,0xbaa4fd54,0x2054de84,0xf99feec0,0x07ac2e4a,0x3428f8df,0xaad9438b,
0xd085451a,0xf2cfd624,0xbd631632,0x41a1111b,0x2893e33d,0x35e7c4f9,0xd78ce3ed,0x353c252f,
0xe72dbf98,0xf525163b,0x0af1ec9a,0xf2c60dd9,0xe81d35e2,0xea30d0bb,0xde092fc5,0xfe88c4bc,
0x2004ead9,0x3f3e26d1,0x1b2904ea,0xda06fffd,0xaa31edd2,0xdaeb0d57,0x2cbf02df,0xd4442203,
0x0bf4f4df,0x12083c6d,0xfa480b8f,0xeb75516a,0xf80fc3d3,0x1ac1b372,0x2a19d30f,0x229a1aea,
0x18161568,0x1dce001a,0xfb56eaf7,0xe210133f,0xd9320f05,0x1f88ea9f,0xf588ffe1,0xd9142797,
0xc79158d2,0xedec0af2,0x178befaa,0xd96ee87b,0xd4f82567,0x27622e96,0xed710753,0x3c3dbd01,
0xfd5dc67a,0xd8e00419,0xfe7511a5,0x1ea7df54,0x4dc2f4b7,0x00dffb28,0x0b95e8e2,0xcd36fe9d,
0x18d1a12d,0x14d5027c,0x0a7633f7,0xe7873378,0x0e93ee2d,0xd8ddf7b4,0x05d4eee6,0xc99f720c,
0xccd31155,0x07ebfcee,0x014fe9ea,0x355b25e4,0x2672e14b,0xf931fe6f,0x0dc1f888,0x14abc0e5,
0xd57f2176,0x4ee5de3e,0xce4b1811,0x4933c9a5,0xe5c21a9d,0xd69bff26,0x0c69f445,0xf00cd0e2,
0x720c224a,0x05e4dee6,0xc21ccf66,0xd84910dc,0x06181bd0,0xf20416a5,0x276fe3a8,0xab952aab,
0x11c80951,0xf0d3124e,0xe444e219,0x0be2003d,0x2c7f06c8,0xde401e61,0xec100752,0xe2fb1649,
0xfd09b4dd,0x2f333705,0x537d0306,0x1a04ca6d,0xd88ed731,0x3911c655,0xc8793cb8,0x432f0251,
0xf8d2e82b,0xc70dfd87,0xefde3035,0xed972965,0xf9513cd0,0x077cf98c,0xbb8fea89,0xfa6dee1a,
0x178bfec4,0x5e3dde4c,0x6739c4ea,0xdfb81515,0xb406edec,0x111fee70,0x2a3db20b,0x43cfd5cb,
0xed7afe62,0x064b282e,0xa6fc2972,0xf25025b6,0xf1d0fdd8,0x96c727e2,0xdc513980,0xe146199b,
0x19321cff,0x2bbed4be,0x10a81bf3,0x0d6fdc19,0x3656ed4a,0x108dd37b,0x1135c821,0x4509f752,
0xdbe10116,0x462d0e05,0xfa87ea37,0xebffd449,0xe268583c,0xef50220f,0x13d8eed6,0xefd91953,
0xa7890d42,0xfbf12133,0xd5251ef4,0x178c1b77,0xedb21ac5,0xdfc90453,0xdbd1f508,0xeead0e56,
0x6219e53d,0x14a2b236,0x2230d415,0x0ec5cacf,0x458ed3b9,0x4356cf72,0x202bd313,0xa60a4b1c,
0x94c22e3b,0xd924f8eb,0x070b023c,0xf9f457dd,0xe41f1a07,0x07124bd0,0xe0a0fcd9,0x346cd2df,
0xdefadebf,0x162b1317,0x21a6fe54,0x2cf4cbcd,0x45edd570,0x1d50ffbc,0xf4a31219,0x3b93f3ae,
0xa525f1a7,0x3783ecce,0xe4fef471,0xe5d032c9,0x1d762e97,0x0aded40d,0x15ff15da,0xf6efd8e4,
0xd3702658,0x476ec4f9,0x0d25f45f,0xd1eee6ba,0x19f713ab,0xff59f96e,0x1552e7f5,0xdb23063f,
0xf52f215d,0xcbd7e04a,0x50fceeb1,0x452be836,0x018ec84d,0xc3be194d,0xc4e80ef2,0x0cc52c67,
0x0a2002d0,0xf93615cd,0xa559443b,0x107218ff,0xe882bf0e,0x4ea41cb9,0x13e9bac7,0xd953346e,
0x306c037f,0x2954a8b4,0x32acf774,0xfc601024,0x901519d6,0x131c0aba,0x2741d4cc,0xf390f1a2,
0xbccf4af3,0xd9843be5,0x1f3d0e6a,0x1390dd2b,0x219ece3c,0xdd9c0492,0xe345e25e,0x3f8dd694,
0x1ac6dd6d,0x27b11d3b,0xfb49042b,0xd99717ce,0xde7ad4ec,0x1c63da1b,0xd4d81952,0x2089266d,
0xd70e27bd,0x27e4116d,0x0c33a12f,0xbdf1294b,0xde0a26cd,0x458834de,0x1f19cde5,0x30efade7,
0xd8980755,0xe3aff35e,0x28472ef9,0x351b0a1d,0xcff09844,0x2ab1319f,0xf8c91860,0x200fd4ac,
0x0bccfe1a,0xf07cd4c8,0xe3271a38,0xdd361b05,0x4239e6ee,0xdec4206c,0xf3a227e9,0xfd14013a,
0xc876f486,0x2957fb15,0x32d68dff,0xf8761c54,0x2746ff8a,0x25561fd7,0x0ae4c97f,0x0e85d2ee,
0xca89ed64,0x16ac48e1,0x16e3e2d3,0xcf38f637,0xdf081158,0x1e28f0d1,0x0a243302,0x227a3465,
0xf463b1b0,0xb6cc2d36,0xb798fff6,0x11d21b83,0x2f2efda1,0x246021bd,0xff8b026d,0xd188ec88,
0x227a1204,0x0206cd9b,0x1525d618,0x398d1a38,0xe6f5e279,0x28f4249c,0xe3d9cd0a,0xabc81f9b,
0x20d8195e,0x11ab0119,0x1af1f57c,0x2e54dfac,0xcdb9f765,0xcf592738,0xf85fc9c0,0x27e5e073,
0x13f21350,0x0f9a3a1b,0xef000ed5,0xb36f2de4,0xfe7de3d7,0xe82bc187,0xe9d225e0,0x156f494c,
0x07860593,0xfce91637,0x26d6aa12,0xb1b92982,0xfae6429a,0x1bf3ea47,0xf01fdfa4,0x0b32dabe,
0x0a5008ca,0x1fe55ad8,0x32afbad5,0x2c67ec2e,0xe731b290,0xd389ee72,0xeeb65b6b,0x4bcfdc81,
0x150efbf0,0xc3f2f3f7,0xd7cf18b8,0xf3174a0f,0xf7b11abd,0x255ef669,0x0e75b80c,0xbb89e15d,
0x312c2875,0x0fd8d7e2,0x1fce264b,0x0cec13ea,0xbb7af6ef,0xb9951b5f,0x344ba07c,0x166cff66,
0x0fa8409f,0xdce32075,0x0b36e362,0x0776d0c8,0x4c09b042,0x1008f688,0xbcea2ab5,0x1c881c32,
0xdf8be5ae,0x062324e6,0x0b86eaf1,0x1567e57c,0xf1472121,0x3e49c418,0x03c7df5b,0xfa64387b,
0x0be0ced8,0xd1203585,0x4417edb2,0xc2ccb911,0xcee850f0,0x389be2d1,0x1dd03922,0x1359f9e9,
0xf00da944,0xaa301298,0x156bd8c3,0x34f76123,0x28d8e569,0xd40d1275,0xfe74d961,0xfa43e73f,
0xe611086b,0x1d86040e,0x2517fa22,0x1d70ee4b,0x04f9ed70,0x02940e0f,0xdf97f80c,0xfcf9f154,
0xeeb1246b,0x05c2f69a,0xf400fd8f,0xed3f4888,0x0c1e0f38,0x07191198,0x1222c545,0x2e3ad088,
0xeaadd19c,0x4221ffe9,0x3cafe4a4,0x1495de0a,0xaf331e57,0x0ea0dc65,0xc65746fc,0xfda036b8,
0xfc46dc23,0xa814302b,0xded30319,0x129ff46a,0x188f3381,0xe38a1394,0xde601c35,0xc02b1696,
0x1fed15c2,0x6639bf2e,0x0b5495ea,0x41a6f899,0x20ece008,0x0517009e,0x11c0038a,0xed75b387,
0xcf9946b0,0x2a66f89b,0xf14c1c6a,0xe02e1b98,0xd747f549,0xfcef1b42,0x00270b69,0x28180765,
0xfcc1dac9,0xfe7dfdd5,0xe90b137d,0xd42638ce,0x222d1021,0x21d1ccae,0xfd2bd42f,0x1e2bd28e,
0xf53b0011,0x279142e3,0xfa7b177f,0xe025cf24,0xa4d816e9,0xd7ea370a,0x045c1684,0x087844a5,
0x1f63d2d2,0xd1ade858,0x1970206c,0x3727c11b,0xfd96f3b7,0x298ae63b,0x0685ddf4,0x14c90ebc,
0x1f00d705,0xfff2ef1b,0xc7cfec91,0x06802664,0xaf9b5ba8,0xe40f4bc9,0x033c254a,0xc8ead571,
0xc20c2fa9,0xf1593272,0xf6f4f105,0xe19b37a1,0x5f1ee3c6,0x38fd047a,0xd364f7f9,0x227db119,
0xed6dec35,0xd8222064,0x13ae195c,0xf5b0f3ac,0x1e59039c,0x0a3cfc2e,0x2771e438,0xc7b9495a,
0xe4fefae1,0x2167b7db,0xccda0638,0x2a5fd96b,0x45c8f94c,0xed822f6f,0x1d1ef58e,0xc3b21158,
0xbd660d62,0xd3de044f,0x05bd18aa,0xe8eb089f,0x07c8ffc1,0xf7ff4356,0x181fdac0,0x388bf658,
0x1042c6ca,0xfa8a19d9,0xc8a7c986,0xf10af5a3,0x3d8bef84,0xf8fa110a,0xf4764c3c,0xeda7183b,
0xcd7a122a,0xd39c01d5,0x2df6c3ba,0x351af8df,0x2d41ffe2,0x23eecc72,0xebd4e826,0x1805e96e,
0x12b81453,0x12c61a7b,0x1ef3d296,0xbf08dd84,0xc1a32bf7,0x3e6a06a5,0x1df3de03,0xf9ab4de3,
0xc3f5003e,0xc8f50332,0xe6d02534,0x720cbf2d,0x2f10f43c,0xd6661c85,0x0658a1f4,0xed2c03d9,
0x53cdf5ac,0x1d26def2,0xbe6b4d14,0xcede4af3,0x1b23ca24,0xe13fe282,0x0a96fea3,0x1d2323bd,
0xe798159f,0x107a265b,0x2e5695d7,0x158fddf2,0xf8430c5d,0xe8a62885,0xdaeb01db,0x2990d8ae,
0x3d46f56d,0xfbb2eaf6,0xe42d244f,0x0d62024b,0x0026a379,0xedee12c7,0xe6a02b84,0x33171b85,
0xefa1eb04,0xbc1a1fab,0xf300de0b,0xd81324ee,0xe39d4a50,0x40dded96,0x13a0c9eb,0xf8d3433d,
0xf268e50d,0xfa54aefb,0x44801469,0x2e47fe0a,0xe3f6eba8,0x00822915,0xf788d0ea,0x04810edb,
0xdf433d52,0x00051aa7,0xe4eb00f6,0x0f43f77c,0x0b4aea80,0xdf47febd,0x17f61795,0x2b07fc62,
0x0c7be26e,0x0ee1de41,0xb2b03242,0xe706f794,0x01661749,0x04f8fa29,0x03e2092d,0xd1281dc5,
0xfd452f39,0xe5bb0962,0xf0bd0521,0xdefc06ea,0xcd5cf0d4,0x30dc097e,0x63c5f377,0xfc73eaa5,
0xf3921095,0xcd07c2eb,0x0b890bdb,0x43390335,0x1914b679,0xe81a2966,0xc73954d1,0x5fd9d9b5,
0xe841c821,0x0d66d041,0x4465eea0,0xed38ff3c,0x2a91f67b,0x179dfd75,0xd8572d9f,0xa23f22e5,
0xc552fada,0x2f2b2f7c,0xec84d8fa,0xdda640ac,0xdde659ef,0xc8660c89,0x12e1e669,0x240fb580,
0x047debbb,0xf1f512fb,0x57252287,0xfac8be48,0xef33ce53,0x17ece06f,0xeb690b97,0xe4e338c7,
0x5509d9cd,0xd3f4ea9d,0xec0c2da5,0x1b750472,0xeacdd313,0x3df6fb23,0x24afbdfe,0xa9b825ea,
0x1b4e6f0e,0x2c21e645,0xd513b704,0xefe220d2,0xadc81326,0xb32a720c,0x1c3b3409,0x2899e53d,
0xe1650284,0xf1c704fb,0xf948f491,0x1c22356b,0x3ca78dff,0xead61b9d,0xe6ebdfba,0x1d9927c5,
0x1ac60be8,0x0b660086,0x8dff0c1d,0xf3312185,0x2ac504aa,0x122e00c6,0xdf9fdea5,0xda3f0d05,
0xf0dc0090,0x0b392e40,0x599c0d46,0xf8b4f3f6,0xb4dee927,0x06bcdb37,0x0cf2d1fb,0x294c11b6,
0x105203f8,0x18175838,0x0c98cdff,0xf577ea4b,0xcdf7e489,0xe789004a,0x1d3f3643,0x009c14f8,
0x0ada0f17,0xdf89f68a,0xdb5b0741,0xd8f55856,0x28a20138,0x1c41fa8c,0xcb20cd30,0xf4161e80,
0x139e1c74,0x0bbb0f60,0xf08dd5a3,0xeb5d0827,0xfaf51e0f,0x495dee42,0xfb6f004f,0x3e45e701,
0xc9e4a882,0xa8bb03d5,0x32261981,0x198ebfbc,0x28b0393c,0xe5273588,0xd5f607b0,0xd6e40a51,
0x063dd26f,0xe14fdfa1,0xc6282df1,0x3d1e1a29,0x17f707c4,0xfe1e3879,0x1e1e05ea,0xab682235,
0xb384e131,0x3d88d0d3,0x36bce47d,0x481b235b,0xdc881f3a,0xe5211135,0x55d9d833,0xcc8ed44e,
0xe7033bc4,0x2a8f061a,0xb2d51178,0x112efb7a,0x1bbed024,0xa629396a,0x1c084c7a,0x3d73c02c,
0xfdb9ee5d,0xf63cf20d,0xff62c008,0x1abef630,0x2a85f2ec,0x1336afe1,0xe9ff10da,0xf3321b61,
0xf1c71743,0xdb780034,0x04453e53,0x8dff1683,0xdee1177b,0x145108cb,0x24c1e3cf,0xfd391386,
0x393eeaf6,0xd4f3224c,0x25931af9,0x232cb5af,0xe85ed900,0x0cf4eec5,0xf91b152d,0xddb5366c,
0x5f59e5a9,0x1291016b,0xf7751089,0x0f0cd933,0xf8fb020d,0xc2ab00c4,0x0c3601d2,0xe34a28ec,
0x122cf81f,0x17b2092f,0x10e3eb56,0xe88a2e24,0xbcbf2d12,0xdee9f8c7,0xcd09d4b5,0x09a7f239,
0xe51e4fc4,0x47bd0c9e,0x0bcf1944,0xc1ece613,0x0bc1a299,0x2312000f,0x1b1cea26,0x2bd5ef9c,
0x290ef548,0xa2a81409,0xe16207ef,0x1f98e9fe,0x2cbee467,0x14065d71,0xe49fd72c,0xc7b42d95,
0xe43b2509,0x2794da1d,0xd93cf35b,0x19a420e9,0x187e0489,0xf0c712b9,0x55c6de39,0xfb6c03a1,
0xd457f7a7,0x068ede55,0x0423d70c,0xf60df6c7,0x239a2e97,0xfcb93541,0xef2f0b66,0x1a9fed3a,
0xe8c6b336,0x032be0a1,0xeba303d0,0xf3f832e8,0x3f2ce74d,0x24e8cf2e,0xe5ab234d,0x0501f8df,
0xe414f403,0xb77825d3,0x0dccfd1c,0xe892090c,0x0d2a1940,0x4606dd9f,0x05b6c7c2,0xfbdc3017,
0x0a4afbee,0x06902032,0xfd7df51d,0x0b9bd465,0xc974d31e,0x120a49bb,0x0efa2ac4,0x3be1d55d,
0xf3d53e75,0xfb8cde08,0xe36be9b1,0x080be30a,0x542cffbc,0xed970252,0xe39eea3a,0x0ea0f573,
0x02550346,0x4b27f5c9,0x1e8e0347,0xafbe0f99,0xf0d4e680,0xedb6d489,0x2d1ffc0f,0x219aef57,
0xe05814eb,0x1f331185,0xf59deda6,0x165fed26,0xfddcebeb,0xf98cdd02,0xd7cc2a31,0xd811f974,
0x4eb0d603,0xd4ba0a56,0x4180720c,0xe3ac1028,0xbb0ef994,0xce1dd7d3,0x23d0bd5d,0x462131b6,
0x2c0e176e,0x3988ef54,0xff79d326,0xbe101525,0xf3640f1f,0xfd3bf709,0xe8bf29fd,0x2322de1e,
0x0b291ec5,0xe660144b,0xe24207cf,0x021101f1,0xe9450143,0xd7f3125a,0x37b6d9e1,0x22a7dd0f,
0x07d60386,0xd1400d6b,0x031705d2,0xe9e6dd5b,0xf7e407a5,0x317de761,0xd7bfec65,0xf02f5492,
0xee25df3c,0xccd217e1,0x07560abf,0x085eea39,0xd9c92c91,0xfe310f3b,0xe4941c6d,0xe429fd62,
0x2972ee4d,0x2d881dec,0x0693d99d,0x1470fbcb,0x1ec3ce08,0x0e01e82d,0x106e0223,0x44560157,
0xe7e4080c,0xee3ff312,0x0cf40847,0xefc21dff,0xdc940d71,0xb4a8337b,0xdcbb186c,0x100035c6,
0xf678faea,0x0b4ef269,0x1eb9caf3,0xf6a00c31,0x37e8e2a3,0x20ced39e,0xdef9fc12,0x1913cf1d,
0x30aeb135,0x138e1131,0x14eef5c0,0xf1070d6b,0xb0681c31,0xe6491f0e,0xb9cf440f,0xd83a241f,
0xfb61f3ab,0x1d47f1f3,0x266c1b2c,0x1326e889,0xf5142b5e,0x07f7daa2,0x186fe837,0xc982238f,
0xfcd7d945,0xf4a31b8c,0x00ca13de,0x720cf74c,0xe0781abb,0xf04b159a,0xd107c9c7,0xe4dbd99a,
0xe359520b,0x17e007f0,0x1469175b,0xc6462d2f,0xfb67e3ca,0x0435e6a6,0xd837398e,0x1a59dffb,
0x074bfa8a,0xdbe50034,0x4025e701,0xf33ef481,0x107be909,0x25430943,0xff26080d,0xc2c1e0d4,
0xeb872177,0x12d13613,0x1d74fb98,0xeafbfe34,0xe665f429,0xeeaff617,0x28c1134d,0x1bf81c9d,
0x2b84e6ea,0xd4e1ebaf,0xe76f1d9f,0x2752ef3c,0x18f9e2d0,0x115a101f,0x0216d688,0xccde2350,
0x126c136d,0x4569e2e7,0xf0f2eda0,0xfbf607f1,0x0837fe2b,0xc224185d,0x1ce9dc01,0xea35dd56,
0x13f434b2,0xfb3b03e4,0xed332148,0x1055e0d6,0xe8f8edfa,0xf83706a4,0xe8c8e485,0x2a5af6ac,
0x0defd481,0xfd592e08,0x1b3df3d1,0xcc9dff01,0x3603187c,0x1fa5ad08,0xd05ee735,0x280310fd,
0x1c1ce4ed,0xe8911904,0x0ad8fa6a,0xfb7f00f4,0xe9571bba,0x5802fb55,0x1100deae,0xe47c04ee,
0xf886bb4b,0x1bc41505,0x00bdf4fa,0x55ced302,0xf6a3056c,0x04f424a6,0x19c217e7,0xf056b597,
0xd733f8ae,0xe017fa47,0xb87728cd,0x30dd0c31,0x31a41876,0x06040422,0x0687ea4c,0xddf50652,
0xf552d3f7,0xf999d685,0x3313c7b8,0xec392215,0x36992a0e,0x017ed4cd,0xe6ca27a1,0x147fd24c,
0xbbdc0862,0xec9246f3,0x2b03dd2f,0xf27f0c9f,0xfacaf865,0x1ee7f09e,0xf01a0bc4,0x3d27092c,
0x3b380d6c,0xd629b7f7,0xde50243b,0x2a50d9bc,0xe28bf3a2,0x012227d9,0x0e1a0658,0x1fdb0b32,
0x4276f85a,0xfbe5b6a4,0xb3772078,0xdd290e4a,0xb44342ac,0xbd8e3cfe,0x2c6a0c68,0xfab218cc,
0xcc393ffe,0x0bbbf2d1,0x1cadb6d5,0xde32f674,0x4d6ee809,0xf4ac09e3,0x004ef3be,0x3c9ab5ec,
0xefa6c485,0x08304657,0x1fb3095b,0xd4580b95,0xe4180189,0xe9d0d0c1,0xf06c0a42,0xe74845e7,
0x17260b0f,0xe7a61a9d,0x2a5e31d0,0xb7bbec4e,0xf8fd1050,0xedf30c30,0x2031c98b,0x07270748,
0x48b3dc48,0x37b805ca,0x07b61a4e,0xebece28b,0xc269e14d,0xeebc0f51,0x031806e8,0xdb2f4e94,
0x0cb40892,0xb1023d15,0xffa80eb1,0x1e70044e,0x2451b86e,0x006eb922,0x1eeb1ed1,0x471fd46f,
0x0680f91d,0xfa7ae55c,0xf523d5af,0xfe8d2f7c,0xef06dca6,0xe0ba3de7,0xfa992265,0xdaa72cd1,
0xdf4109fa,0xffe9ebe7,0x0f75031c,0xee8cf0b1,0x0a274011,0x1b5c2860,0xef17d284,0xd92ee8fd,
0xfe0c1b17,0x176d024c,0x221dfd96,0x2dfcfe43,0x0d9a9b36,0xfc7b203a,0xf193faf9,0xf22c010c,
0xfd651ef8,0x065ed103,0xf1ea3164,0x01bfedfb,0xf062ed5f,0xf4080762,0xf9a211ad,0xff81fd2d,
0xfd0c2cc5,0x10acf6b6,0x0727aa9b,0x1c30d2e6,0xf9e61080,0x22d3ed6f,0x23b119cf,0xedf00892,
0xeeb3b855,0xee261339,0xe5bf1067,0x03bb160c,0xeaee20ae,0x39dbee20,0x0822f625,0x0f48f997,
0xe184dade,0x15d0f738,0x2b7ae24f,0x2e6ffc5c,0x40cbfd02,0xf835c139,0xe5edfc46,0x03aefcb0,
0xf734088d,0xe327203f,0x10eb2fed,0x44440de5,0xc451b865,0xeb280767,0x1b69e1c4,0x0cbed996,
0xf959409c,0x559aeda7,0x10c2cda0,0xd9ff02a9,0xfd37e531,0xbe1c1583,0x06ef145d,0x0371d142,
0xe8212fc7,0x3315181e,0xfe3e02fe,0xf19a271a,0xb801d39b,0xed57e0f7,0x32142549,0xfc92f340,
0x51dcfa39,0x01daf9c2,0xb7950025,0xf40a31be,0x0af304c6,0x3f6dd09c,0xefcee12b,0xe6ed22e2,
0xfe06293a,0xe98cefce,0x27ab1178,0x0835d81f,0x17482109,0xeecc0beb,0x289dc19a,0xef44efe5,
0x080ccc32,0xf0a21ee9,0xfc685761,0xf54f0413,0x12b1df03,0xc47f141d,0xf5ffe367,0x04b8225e,
0xf361df55,0x427cf060,0x0061da52,0xcd8f4443,0x04b40697,0xe83012f7,0xde3ff1cc,0x134ddeda,
0xe6d31f8f,0x224b1944,0xed01fc17,0xfe53e4db,0x2b8026f3,0xdedfee62,0x1d871257,0x079fe2d7,
0x1169d0f6,0xd77f4016,0xe8fbefeb,0x19b2f620,0x0cfc2cd1,0x0a9e091d,0x16da026a,0xc8e802c8,
0x0e1901e3,0xf012e78b,0xdd54db61,0x29330521,0x0c5b25a5,0x3754310c,0x082ff920,0x8dff0c16,
0xb9f50cdf,0x03f6cf66,0xfb3b0b85,0x1c8b26a0,0x4a9c2b0e,0xddfd069c,0xda34f9f0,0x099aca39,
0xeecef407,0xe6970eb9,0x2213158b,0xe8840e4f,0x210bf416,0xf9f209f8,0xec4b346e,0x2958e38e,
0xfd46c01e,0x0061e46f,0x2c8ff874,0xe3d7205f,0x112826d4,0xf1deec12,0xce9be933,0x18b71d03,
0x0ead0be5,0x0da80ba5,0x1f8fdc34,0xd24bef4a,0x939212be,0x2418066a,0x427dffef,0x0c8d0727,
0x12c1fe38,0xcf92f6cc,0xe227e8fe,0x39c2d6da,0x0162cfa9,0xfa272fd2,0x1c8bf6aa,0xf372ea50,
0x270018cd,0x0affb900,0xe2750de8,0xe27b1a29,0x165df429,0x0b97faa3,0xf434dbea,0x089a3930,
0xaaeb405a,0x226cf929,0x298bdc05,0xf61bfc7c,0x087d14ea,0xdfe50e28,0xfec7f907,0x31ffc9db,
0x1e06050b,0xfd9df7cb,0x18dd2d60,0x0c03c9c5,0x18aedae3,0xf80f00b1,0xd2cc07e7,0x20a81519,
0x0dcae5d6,0x1b43ec9d,0xde471dcd,0xd47023bb,0x030e02ce,0x094bb4df,0x2f3b1f72,0xcf30e235,
0x12564251,0x0a3fe22a,0x0dccc085,0x21b3e03d,0xe957efee,0xf4123df8,0x176006fa,0xf64dfe28,
0xf0a61486,0xb0650e0d,0xd9af06b6,0x15420e4a,0x1bae09d4,0x17c82ce3,0xdf5c0f51,0x0cd80982,
0xfbd2d9dd,0x0990ce56,0xed3f059b,0x1333162b,0x16c20554,0x411cee64,0x134df870,0xc8210486,
0xfae0f116,0xe8e0c9e7,0x2c7f180b,0xf2f4026e,0x0c322caa,0xe32c252b,0xee01d2cb,0xfb65f952,
0xe01e3403,0xfb2d11bc,0xfccff480,0x4af3e063,0x004fc0f9,0xdc6f032e,0x17aa219a,0xe995189f,
0x2b800a92,0xf56ef524,0x8dfffea7,0xe7742843,0xf9d21ec0,0x35a8ffff,0x14c81365,0xdf04f5e9,
0x0e11191c,0xf9d210f9,0xfb94dc22,0xda0b136e,0xecb1f66f,0x0cee1fff,0x4170097e,0x3675e42d,
0xc162e8e2,0xd7742dc3,0x26f6e798,0x4c92c55e,0x324fd5e0,0xbad8eb52,0xcc453e2b,0x04b8ee0c,
0xe9ec0b5b,0x080f234d,0x15800075,0xddc43055,0xefe3fe71,0x053bc586,0xc85dc668,0xeb21260a,
0x274231a3,0x593f105c,0x09d3f042,0xbbebf0e6,0xdc2afdf0,0xb72a102c,0x2fec0aa9,0x31f7d467,
0x25b70c8f,0xf1541b8d,0xe7000af0,0x0ecf1f59,0x0e63d888,0xd2c9c309,0x068b29be,0xef0b15d3,
0x517f176d,0xeacd0699,0xca87f201,0xfaad0546,0xff29e10e,0x3eaa1aca,0x121ffbe0,0xe29cd9e3,
0xb67828ef,0x1499e5d2,0x01220277,0x0572ecad,0x0ba61465,0xcc2041f0,0xf8befca4,0xe9ffebd1,
0xde48d0e5,0x2d5811ca,0xe36b3806,0xf0a9fa5d,0x128e11ab,0xf69ee643,0x17e9f585,0x286d0ccf,
0x1373d4b7,0x1dfec921,0x0be5da42,0xe64133b3,0x3cf4ffb5,0xfc26fdd3,0x07d8f984,0xe6750a6a,
0xabb928d9,0x1df225ec,0xf0720869,0xedfcf114,0xfb730fe1,0x1536f412,0x20bb0b67,0x1ba2f61b,
0x15e5c39f,0xeabe2e82,0xdf23bbda,0x3c57f08b,0xfcedf3a1,0x1f10da21,0x079833cd,0xd455156b,
0x1264f29e,0xe38edcad,0xb9e80f1e,0xdc36365b,0x12051be0,0x0c211a64,0xe8c100f2,0x0328f21e,
0xf77900e1,0x1ef5d90c,0x3586e0e2,0x340adbbf,0x1613f52e,0xc0d43a28,0x1fe8e744,0x0cbbd8c6,
0xe5620964,0xf033192f,0x0fa42966,0x32dcfbed,0x04eceda8,0xf56ef650,0xe935ddde,0xf7a10441,
0x12481a6f,0x1060faca,0xffaa0fe3,0xa02a2180,0xebd93ecf,0x38d7e564,0x0e8eaffe,0x1ba0eaee,
0x0d66f1f5,0x02360dfa,0x10da00eb,0xf0eed85b,0xf0742ba0,0xdf02fecc,0xddaf1d4d,0xf0750cf8,
0x15a5e345,0xf2152daa,0x1cfa138d,0x1b6cdd54,0x3b469dd3,0xff0dc934,0x02c328ab,0x31cb0aae,
0xdc750c77,0x1824dfc2,0xf6e4ef80,0xd61d390b,0x0bba08d6,0xd78b2301,0xf49208e8,0x1c22e7c6,
0xcc1c29ec,0xf71b203e,0x327dfb86,0xd644dd2e,0x1be61812,0xc60af05a,0x21371418,0x3319e3f0,
0x2d7bcf3f,0xeb13d8f6,0xede7f8b4,0xebe32836,0x2cc5e421,0x0e36f6c6,0x032ccfe7,0xcfcb36c2,
0xe4680877,0xfb131475,0xff9b10a4,0xfc68dddd,0xadf22b4f,0x0eb00c49,0x17f1fbcc,0x06b823d9,
0x20cafdbb,0xfb77ec6e,0xf684cdaf,0x1552d8ef,0x331f055d,0x15410203,0x01172b2c,0x0fcbf4af,
0xf32bd921,0x2f87ddfe,0xe537f867,0xb84b4777,0x40d3d934,0xf9252c17,0xe1361b6e,0x07af165e,
0xb8030ae1,0xe3d4fd2e,0xd978f331,0x1549223d,0x1284126f,0x46a9f2a2,0x06b7ee51,0xf0f2b86c,
0xec96cef0,0xe6e5f2cc,0x366136f8,0x3c3be743,0xd242deb1,0xe0f81e37,0xdb640606,0xf12a12b9,
0x17ef17c3,0xed64fe62,0x00d7fad0,0xf88df980,0x0dbb2672,0x0b7ddd12,0x1326123a,0xf56d00ac,
0x00c3ee26,0x2cb9f5b4,0x28e8e9ee,0xdbee22e6,0xd99f1e69,0x0573f55f,0x0901ec0e,0x17590699,
0xd1ba405e,0xe16912f3,0xe3cf0878,0xedfc13d3,0x043cf909,0xf6b2045a,0xadfc1f76,0x4be3050b,
0x2a56f33d,0xccaaec29,0x2972e0ca,0xde26cacf,0x22c01a52,0x40c8d3de,0xdacc038a,0xd5e7175a,
0x125ff0b7,0x0522efe6,0x1007135c,0xccc5342c,0xd4ef0e65,0xfb982a38,0x0bf6df5b,0xf9fbd769,
0x25011983,0x1ea90cad,0x0fb436f8,0x2788c9c4,0xe0b8c7cf,0xd5b8f158,0x0bf71e0f,0x26d40d82,
0x2895117e,0xcf9f1695,0xe2093405,0xf232f74a,0x0426e58e,0x0566dfbd,0xfc24f522,0xf7353b5f,
0xed850bf1,0x14b72a28,0x4572a776,0xcf70d2f7,0xd30d1db4,0x26f7ebbb,0x1817f77d,0x202c0472,
0xfccefa70,0xe162008e,0xe86ac2d5,0xf2680d27,0x392722b7,0xf9b720ee,0xe1591fb2,0xd8fb0f45,
0x0d32e250,0xf5d2d3a9,0xf3d7075f,0x15d65447,0x22b0e11f,0x25631415,0xf8cadbf5,0xbc9ee99e,
0x28470079,0x24cdd6cd,0xda980617,0x349d014c,0xf33a00de,0xdeaa3caf,0xfe7800ce,0xdacadd52,
0xfa051034,0xfa53fe90,0x3017ed41,0x1957e644,0xdc03f7f1,0xe5720309,0x0c2a100b,0x1479103f,
0x2cd8b302,0x07d00779,0xdcb0eba8,0x0496f588,0xde05f7de,0x518eef65,0x17aafe3d,0xe0cf297d,
0x015ef1be,0xdc13ffec,0xe4b9141b,0x072f0ed3,0xcca53645,0x2e3d16c9,0x0c7ab4f3,0x0ec71a9d,
0x0da60c89,0xfd4c0a09,0x1bbbd656,0x3cf5df53,0xfd30cf74,0xf4cffd35,0x03d83a5a,0xe663f7c2,
0x21cee438,0xfd32e193,0x0bf10604,0xf6113288,0x048d0ec3,0xcb1bf0d5,0xbd7bd3be,0xf87d0807,
0x26d33d66,0x29350f27,0xf0befb18,0x18dd1635,0xdf73c87e,0xecb1ca84,0xfd2adde4,0x328deac2,
0x11fd2c0c,0xfc8d45e6,0xebe6321d,0xfd77a0c6,0xe7c70cbb,0xc587eb22,0x01fb37c3,0xfde11b7a,
0x274906c9,0xf7640680,0xdde21c4a,0x06bcf305,0x2f0ee78e,0xfce5fefa,0x420ac54e,0xd7a31c93,
0x0b131a1d,0x09dade03,0x1540ce37,0x029cfabf,0xd4a04822,0x152c1a89,0x00fbe2f9,0xf7b9fd93,
0xcde8e3d7,0xfe710af2,0x152c13b7,0x000c0c34,0x1012f7f3,0x0d77f4d0,0x06a2008f,0x0533d12f,
0xf506db33,0x0661279b,0x01fc03de,0x0acdfc9b,0x34d7ee1f,0x1336d173,0xedb10e91,0xd7681417,
0xebcc21fd,0x0baa03c7,0x37c4d9d2,0xf630f856,0xea5e3500,0xc86ffac7,0x391bffe0,0x09df22fe,
0x0412f30e,0x2390eaa2,0xc36c0d8f,0x221bc7f5,0x22c3cef9,0x237e1948,0x0dd92aca,0xf39518e7,
0xf6e6d890,0xe6f1b8a9,0xd52801ec,0x16761a4b,0x08c21f9b,0x04ea1801,0xe6f206e3,0xd759dab0,
0xf2b1105e,0xf5a20097,0x020904c7,0xe92f1e17,0x1483f9a7,0x1ae5ef69,0x296ad721,0xef4edda4,
0xf91e01de,0x00b30339,0x3989fc22,0x15eeed73,0xf8240ff5,0xcc0a1f86,0xf03ef32a,0xfe26fc1b,
0x151ff705,0x1f570912,0xf3a33cb4,0xad6925f0,0xf8fe0075,0x116dfd8c,0x17aebdc0,0x0baaf990,
0xe5bb0d77,0x238618a9,0xdd9f1218,0xf486107f,0x162fcc88,0xdb24fd7e,0x165ee0c1,0x09a00057,
0x16ce08fd,0xfc6a0754,0xf0220612,0x0358e506,0xf573e8ae,0xf6461866,0x02841219,0x0dbb121f,
0x028cdc43,0xd43512b8,0x1fbbf624,0x3884f78b,0xe8e20fd0,0x2995f5f9,0xde03fa76,0xe2f70597,
0x1dfef9f9,0xf9070214,0x037d275c,0xf40c0938,0xeb362ac6,0x0c1010a8,0xdd3ebe6e,0x0cdd0a33,
0xfb6532a3,0xeb27f8cd,0x0a381421,0x0038e1e5,0x1729f514,0xf6e602e2,0x0b70e608,0xf964e3e9,
0x07a50f89,0x174bf56d,0x1938024f,0xea3deadc,0xee65cc33,0xd69d2020,0x1c4808e7,0x04c61f29,
0xffc81f64,0x111ae2d5,0xd117d9f4,0xe0a203f7,0x1de728e8,0x0c33fe33,0x08500c18,0x1e2513c9,
0x0800de1e,0xfa71de11,0xe33ce066,0x2e36250c,0x07050255,0x1882f75e,0x2c8dfedd,0xbc46e34c,
0xe5543aca,0xd4b81e67,0xff3d1cd1,0x1edae18d,0x0bb9d08e,0x187e2f88,0xf2b7fbcd,0x028805e2,
0x0c0fdbf5,0xf6e2d298,0x13da0154,0x0d4b1be6,0x08560156,0xe361ec68,0xcf09162f,0x1e0ff9be,
0xe69f274c,0x26b6eadd,0x13f9dfcb,0xdd021121,0xc670094a,0x1b251442,0x16fe09f8,0x1bcddffb,
0x034ffcdb,0xff970520,0xe401092e,0xfffee08b,0x043a2206,0x110903ca,0x03ad2d62,0xefafd6fd,
0xf87bef13,0xed40155a,0xeb322ab5,0x28410cb3,0x13e2e3f8,0xdeb7d73c,0xfff9f787,0xbc413a09,
0x3091155f,0x20c8d9f7,0x18bdf4cf,0x0988119f,0xc0f1cfa7,0x10021ad2,0x0202f271,0x00ffec47,
0x104b02e1,0x10b3f71d,0x0bc31558,0xf2d527cf,0xf9efce56,0xdcdf13ed,0xf6aab67c,0x2baafd69,
0x02952873,0xbd3a2b75,0xf82534e6,0x0e71db35,0x0b09f7d0,0xfb32dde5,0x11d3d9dc,0x08102a28,
0xfaa3ec78,0x073d14e4,0x07b7f90a,0x07520625,0x09a70a94,0xfab2e47f,0x11e1da24,0xf379ecd9,
0xe06b3594,0x1ef43cca,0xe8f5f28d,0xef87e121,0xfbc10882,0xcd5426f9,0x0b6709a2,0x08baefcd,
0x154909f9,0x11bdef10,0xd876e165,0x0fe721de,0x18d3cc30,0x02bee3d5,0x128a291d,0xe0310144,
0x2bb4e68e,0xd55af9a3,0xf4e40d61,0xeb9b2a84,0xef810392,0xfa270637,0x12be1478,0xfc7212cf,
0xe9451473,0xf8cc0023,0x4550cfaf,0x0475c480,0x1d0c098e,0xf0133538,0xf977f581,0x46a9f1c8,
0x0f8eb997,0x14efea1d,0xfecc3151,0xf7ced31c,0xed6c0913,0x0f680218,0xf82be85b,0xbe6153bc,
0x02361e3e,0x0390da6a,0xe0d9f208,0xefc61873,0xeefb0ba6,0x2a8e0b6a,0x32c4d271,0xfbe8d0f5,
0xe572e657,0x0eb6ffb1,0x0eb6fc77,0x39ba1b90,0xc59603fa,0xeb34e06a,0xf8d33d41,0xf956ef2f,
0xfaef0e6b,0x0d590f49,0xe085f70f,0x0eb83451,0x195f03de,0xf1d7f7f6,0xf82c0f7c,0x045cd0da,
0x17bb0bc9,0x4263cfc8,0xf72ffd2d,0xf8c01d30,0xf236106c,0xdc87195e,0xfa82ee9e,0x002a14c9,
0xe80a10f0,0xe28ae856,0x00d329cc,0x09a0fa50,0x0b7010ad,0xeb002a69,0xf5ead312,0xe80ac710,
0x0d6fdb2c,0x2f2231a5,0x18282c00,0x0465dcee,0x11e8b99c,0x0983da62,0xe2cc1d75,0xf830fd59,
0x17dc1da1,0x2f3be5f4,0xe18cf611,0xd74c43b4,0xd8320c85,0x0879fd52,0x20e5fc33,0x04f4e2fd,
0xfda0133b,0x1d0427bd,0x1824cca4,0xe7f9eab7,0xc9c80167,0xffba0f05,0x48a0fd0e,0x1e42ef8c,
0x09c3f2b4,0xc3c00864,0xd996fd86,0x19bff97f,0x3e07d188,0xd13614d5,0xc96928b5,0xec3a2298,
0x03602700,0xeaf0d9b8,0xe6990de7,0xfac4d5fa,0x3afd0135,0x15210dd0,0x1be0e445,0xe4260111,
0xbb831c15,0x17adf91d,0x1d33f452,0x0b3ae669,0xe314385e,0xc42a3027,0x03d91858,0x0730e42a,
0x12180057,0xf85817c3,0xf81df46d,0x1b1deb66,0x227df067,0xfd8ce221,0x074a0826,0xf6211109,
0x139703fc,0x041105b9,0xfae3bd97,0xe80f19f6,0x00af02c9,0x227ff1ca,0xfc2f1ec9,0xf7570cfa,
0x98901f98,0xe94c1749,0xff4de87d,0x1ee91168,0xf8d919de,0xdcd0249a,0x01380b6b,0x1f6fb499,
0x08bd06aa,0x34aec83f,0x0e63e08d,0xde6d144c,0x3465f5b0,0xf28dfec8,0xec751656,0x23dd1032,
0xe5add246,0xf765e2f5,0xe6881c29,0x03b44036,0x26e41435,0xf0e60297,0xdf8ce439,0xf1a20703,
0xe3c8ede9,0x115c2943,0x14ba39cf,0xed1af2e3,0xc70a3064,0x01a4ec57,0x0810d554,0xf7e51f56,
0x0aa9fdf9,0xdb64372e,0x1b7e13f4,0x2983d37d,0xca06d386,0x0f73f2ed,0xfb2c141b,0x1da408ad,
0x2e16fc77,0x04490e5f,0xe187ce05,0xd7300a0d,0xec3cfa76,0x39ab0e5f,0x0b4e000e,0x030ef1e0,
0xc59d0ad4,0x173f0c06,0x2c0bdbda,0xd5572eb0,0xfce6f405,0xd23bf2eb,0xf99e1ca1,0x3ad5081f,
0xce47156a,0xfd9b3551,0xdcb419b8,0xe47aece4,0x4393cedd,0x2136ee04,0xeeb72454,0x25f7ee40,
0x0b41db62,0x2e4edce3,0x0aa4ff10,0xe8e6f7dd,0xeb9c29b7,0xdc52f847,0x008cdf64,0x0b081bd1,
0x130f12a2,0xdd8911c7,0x0494060f,0xffb1d77c,0xc866f294,0xee3f21b6,0x20480499,0x2ad415fe,
0xf730e552,0xd7cc12ea,0xf45ad9fb,0xf980f7a4,0x1e991391,0x1a1fe366,0xfd8d1bf3,0xf249f578,
0x07d1091a,0xdbd50789,0xf849ebba,0xf54dea26,0x1ecc3b66,0x1442196b,0xd76005e0,0x1413def9,
0xd7a2013f,0xdebf24cb,0x4089d863,0xed75f6aa,0x18d136d9,0xf8260791,0xd37d0222,0xe861146a,
0xfb72b038,0x33df0af6,0x0d141773,0xf2ec1a39,0xed81edcb,0x063eeb37,0xedd20344,0xee94046f,
0x12930550,0xf1db1253,0x02970819,0x2653f2ee,0x0781f118,0xff0ff34d,0x09f80a80,0xea05e818,
0x07d80fa9,0x0874fdd9,0x26b00923,0xf72f2269,0xbfeb01f2,0xe662f2d1,0x066a2f5a,0xf5d9f657,
0xf05f153e,0xfbc2119a,0x2b91ee66,0xf063dd0f,0x2494ffdb,0x1776dbb7,0xf382f544,0x0ef4febd,
0xfe0ad9ef,0xf431dd26,0x3b8d0ca7,0xfd1d11a3,0x0e8f0869,0x01add7c8,0xfd6ebe90,0xfde3263b,
0xc8e436fa,0xdf3f14c7,0x07932d41,0xeffeef0e,0x0ead0db8,0xdf7c10ff,0x1a87f2ab,0xeb5ad8e9,
0x10c71926,0x16e7199b,0xfa1910be,0xf0ecd85f,0x042ffba6,0x1b54fdaf,0xdf2311d5,0xf90b1ccb,
0xfe4b0216,0x2429f47f,0x1129ccf0,0xf4f51fca,0xf2470b29,0xe8e2e9f9,0xfc771309,0x48cdebaf,
0x281edae6,0xd41424e4,0xf38cf170,0x2e78ba73,0xf7e5e99c,0x362808d2,0xe0971a89,0xcf7a247e,
0xfdc40912,0xc681232a,0xc5ce2e16,0xfe4ef11f,0x0756268c,0x15a2062d,0xf35510ac,0xf9b60374,
0xfa3ef7ee,0x04b5c7f6,0x459a0dc0,0x222db880,0x2996ecec,0xfd45255c,0x2bd8bd13,0x1065f346,
0xd27cd06b,0x2ee5ff51,0xf782ee2e,0xfe235c26,0xee541155,0xcbbdff5e,0xe59c0d3e,0x15fffa89,
0x014f1128,0xedc50158,0xf08df429,0xec392b19,0xfe3d075f,0x3da9ff06,0x0f80e6f4,0xe2fbd702,
0x0da60e1f,0xcfd6ed10,0xfefc0419,0x1cb91672,0x00dd1b9d,0xf70aff41,0x0af6e2f4,0xfbb9f440,
0x1430d6b1,0x036114b5,0xe117ef9d,0x30400b69,0xd395012a,0x08f51848,0xec3f06af,0x015e13d4,
0xf690ea5f,0xffefd468,0xf68814c5,0xfe7812c1,0x0e79fd54,0x13411064,0xfaa0f9fa,0x01eceaa2,
0xe892e6be,0xec57fb68,0x174b317f,0xfe1d13db,0xe00c1aa7,0xf4cfee8d,0x111af5bf,0xfefaead8,
0x005a32e2,0xe8d51020,0x30eee71d,0x18aec93c,0xd40a2572,0x27e9f4eb,0x0894f2df,0x0ef4da2a,
0x1211fa6e,0xcfc1fa24,0x01733061,0xe3793628,0xd4d0f2d5,0x0ab1f151,0xf3dc0fe9,0xd0011a3e,
0x351109fb,0x4eb7db3d,0xc668fbc0,0xeaf815d3,0x111ee3d6,0xfc170f8b,0x215105d7,0x12e4d824,
0xd57020a6,0xfc111871,0xfaa90dab,0x20c4e751,0x1879e82e,0xd9a9df4c,0xf73d3baa,0xeed52d7a,
0x0a6f0164,0xf094e42b,0xdfe90597,0x067cfb1d,0x13bff23e,0x24a30095,0xe8370f7a,0x078a02a2,
0xee01c110,0x0e790f60,0x306de886,0xf6d5d666,0xbcfd311a,0x28141956,0x005509e3,0xcd94fcf3,
0x0ce6ec17,0xf2b42791,0xf7030956,0x3b9ff0cc,0xde2ff833,0x0767f3b7,0x31360b37,0xfd77e5c0,
0x0c321809,0xf840004d,0xe588fbd2,0x103af4c0,0x1f0eea2f,0xffec1c1c,0xe8970acc,0xdc8c2977,
0x11a118ee,0x10f4ca19,0xdd2f021d,0x01e411e6,0x09310127,0xf6f00e5a,0x2ce5eaaa,0x0ffef95d,
0xfe83ddfd,0x140bf42b,0xfc96cceb,0xfe8b013a,0x037c093f,0xf8dc3bff,0x0a5df9f5,0xe979efb8,
0x03fcd103,0xee78029a,0xda9226d4,0x32951926,0x354f1015,0xd370d911,0xc64518c5,0xd11502f4,
0xfb0d2209,0xfd2a39c3,0xe5c6fca6,0x02f30774,0x2d1f0bf0,0x1c05ec35,0x08dbc488,0x0da1de69,
0xc83f0695,0x47fde195,0x3e23ff19,0x12b6eb66,0xd467db15,0xc85f31bd,0x060405f7,0x06cbf010,
0x202be68f,0xe2353274,0xe4750812,0xe98af70a,0x1c3b13f6,0x1738d49c,0xe44cea5b,0x0c4e3cb4,
0x0b86d652,0x108ef009,0xd7231f64,0xf997f7cc,0xd35b2e69,0x190b0a1b,0x4bbecb73,0xd94719b1,
0xcdbc2114,0x08dff0e0,0x180a0e1c,0x4fe7b6e8,0x242ed176,0x046ef712,0xfaae00cf,0x1dfaff42,
0x143de663,0x15bee43d,0x9b572195,0x146017f3,0xeaa7f221,0x029805b4,0x02b318f7,0x034a0e62,
0x07d01fa5,0x142498ef,0xf4e60887,0xe721218d,0xef931b20,0x024dd952,0x0d670258,0x23bee5fc,
0x052b1fb4,0xf4dc3dbe,0x0377dd52,0xeb1fb7f5,0x032cfe07,0x01540cd2,0x1d800ada,0x4037f735,
0xc3a52209,0x0b00f37a,0xe8350b91,0xf74fcfa7,0x1b37f918,0xfddd2098,0xf85a0272,0xf4fb1626,
0x3075e83d,0x32e0f458,0xe341df75,0xe25707e4,0xee771131,0x1b94f347,0x10dc0a0c,0xfed3145b,
0xe5761046,0xffffd9cf,0x1df9edfa,0x08f0fe7b,0xebcd208a,0xea5c1df7,0xcd4a1ca0,0x186ad4ff,
0x1cf4c50b,0xc1e80f36,0x28be1f5e,0x1f741e0c,0x0a43e280,0x00f1f2b7,0xeaededef,0xe8060406,
0x2a53ddfd,0x13f7c803,0x05f81e3a,0x26ba236c,0xf1790044,0x1e823320,0xd1f2b186,0xd4caddf6,
0xfe0a1f46,0x120d2b5d,0x1968308b,0x0ef0f344,0xc879fb1c,0xe51a358b,0x2be8c93e,0x1bacf53b,
0xf12c22cc,0x0061c667,0xfab9107d,0x2dbf0f24,0x3435bb43,0xd9650904,0xecdc3657,0xf46af395,
0xe6a9e552,0x080aeab0,0x094728eb,0xce8c2f6e,0x0884f943,0x1040d143,0xfb0ff351,0xf5160095,
0x2b4b136a,0x00b01719,0x015d91ce,0xf9fc087d,0xebec01e8,0x120f299d,0x001febae,0x18cf0d90,
0x176ed7f2,0xdb7c0d2c,0x0454249e,0xf86eecf3,0xfa35fe3a,0x16b5efd6,0xdba0ec13,0x08ca57a9,
0x1bda0cb8,0xdd93fe6f,0xfbd21644,0x0573f210,0xff96c2b4,0x27f606fa,0xf980e3a3,0xf8861f4a,
0xe8fd2723,0x1c78f750,0x2fc00be5,0xf5eec4a3,0xc4b8eea8,0xfb6ce411,0x3d39fb3f,0x069aea37,
0x25474935,0xe1431538,0xb384bcfa,0xec69ecf1,0x05e02188,0x03cf1c30,0xf99542d8,0xf1411d4f,
0x1561a50b,0xddf5d9e3,0xee601b17,0x4dd033f1,0xf7f70459,0x11eddd29,0x1d24e8f4,0xe156f23d,
0xde55239c,0x0ef1f60f,0x01560a98,0x0e820b03,0xfd2dfa99,0x0c413b1f,0x09fcf31c,0xd989cc39,
0xe71605e7,0x0681ffa9,0x1d29ffa9,0x28030cd6,0x15fffd43,0xdd54f7d4,0xdbd50ed6,0xe143d597,
0x137505de,0x31b0f5ec,0xec54fe7b,0xcab831ec,0x0b4102cc,0xed08f4c3,0x0a601ddb,0x10ab0808,
0xf6e1c2b5,0xeb13052e,0x1c11ee1d,0xf8c717ee,0xbf30429d,0x40dbeab5,0xfd4df624,0x2a93fed0,
0xf83ef164,0xce2b1c43,0xdd19f63c,0x3a23d25d,0x20e424f6,0xf8270743,0x226b2fae,0xd2b0de1b,
0xf6bdf6c1,0xf04af8fb,0xf79d02ee,0x2e4e3236,0xf6b7f9d4,0xedbdf9e4,0xeee2f980,0xe24ef1b5,
0x10553d26,0x2db2103c,0xe1eade1f,0xd09313ab,0xef92ec05,0xe9cb199e,0x19771344,0x0a43dcd8,
0xeca22e97,0x0b0aeaf5,0xe9c21fae,0xde90fbcb,0x242de684,0xfadcdd3a,0xd75eeae2,0x257f34b9,
0x54c7cea5,0x17ca3417,0x0970e044,0xcf3ec3b7,0xce0cd6f6,0x2a5707ff,0x11bf461f,0xff6426b1,
0xc8d63e82,0x0305185a,0xfda1b974,0x0209e17c,0x1da405f8,0xf7c2ea0a,0x30211bac,0x059e20b1,
0x055bea7f,0x0249d0fc,0x0755f218,0x0a7aee05,0xdb1cf1ec,0xec853e1b,0x09a62400,0x08c20410,
0xf6c5c171,0xe4bd0a01,0x03d801cb,0xeabf03c4,0xfbee2b8d,0x1724d6b0,0xd346fcce,0x147d01db,
0x0b93e99e,0xfef10abf,0x08f1ecf6,0xf4e1f2f4,0x32060580,0xfa1eccbd,0xf26de74d,0x2d082195,
0xdcf016a4,0xfea2018c,0xe47c1417,0xd91418d6,0xf79111f6,0xfdd5107b,0x04892f32,0xfcb0f2ec,
0x089efafa,0x104c10b5,0x0d3df9a6,0x314cbacb,0x0ad7c23b,0x30670215,0x01b515f6,0xf5b6f364,
0xe7c9f823,0xfa2d0eb2,0xe333fd17,0xe15837af,0x06762343,0xea6fdebf,0xd0f30bcc,0x01141ad4,
0xe4b609e3,0x0d1d0d6f,0x3123efd2,0x166ecb4c,0x44e0faad,0x0510c3e6,0xf5aad3c9,0xfa43e3e4,
0xff6b0a5c,0x06f63153,0x2fbd1487,0xda600a60,0xf221f42e,0x0a2d067e,0xc574dde7,0x276efc31,
0xf9950d02,0x0cb111a9,0x11bb6865,0xf2bce3a1,0xe1d7ec59,0xf029d60b,0x3d0ee344,0x153eeed6,
0x0ff51d66,0x140c030e,0xf434df1f,0xe6a4f32c,0x256b021d,0xf58fea22,0xf3f803af,0x05b81dbf,
0xf3a5d05d,0xdfcf430c,0xefe1f66b,0x1109ff36,0x02ab1af5,0xe9190a98,0xfb3ad890,0x352704a8,
0xfbfffb32,0xfbca1d54,0xf511fd29,0xf2cfe1f4,0x0d20f5a2,0x2fac1582,0xe2861ea8,0xe7c11d0d,
0x0437e19d,0x0529ea4c,0xf21f2e4f,0x01f51032,0xdf4f2133,0x03c3faa3,0x123fd29e,0xf4be04ac,
0xec355120,0x0bb00259,0x0117f6f5,0x08dcf6eb,0xf17dcdeb,0xdfbd0e1a,0x2579e8e1,0x13491bfb,
0x1b07066a,0xe8cce439,0xf496030d,0xf9afe94a,0xe170f37f,0x0fe0f1ce,0xd4ba3251,0x20e80fbb,
0xeece02d2,0x09b9f8a5,0x1124d371,0xb0e62e86,0xf2bb265b,0x0e23dc3a,0xfb5f2afe,0x1abd0167,
0xff7ad9aa,0xf7c6fc09,0x0e34fc99,0x0aa1fca1,0xe65e535c,0x06ebfdf1,0xbbdffb33,0x0d17f678,
0x036c04db,0xb64b0b1e,0x1891431a,0x23f2f1c4,0x150f21a4,0xc2de1e3b,0xe80ee5d6,0xf73dcf7b,
0x23c2e6f8,0x086bd469,0x2c8c2394,0xfdd9317f,0xef20f93d,0x07770303,0xd56bdd65,0xe893ec05,
0xde31faf7,0x190b2ebe,0x1e7dfebd,0xd03a3058,0x03b3ff34,0xdad1fb1b,0xfc001831,0x357dcb76,
0xefe10722,0x07221e4c,0xe6a2e5d6,0xe95e0d77,0x238007cb,0x1d22f3bf,0x0b7a2295,0xc2d635e4,
0x0ae4e2ef,0xe106d6a6,0xfc061ea8,0x2837f82f,0xfa2804ed,0x141d0952,0xeb521b60,0xc0864499,
0x114ceb72,0x0699c352,0x49d9e4c0,0x3c9fbd07,0x0259dc40,0x0eec2c55,0x223501d6,0xe8e9c3ee,
0xceb80811,0xf3581a15,0xf13aed3c,0x1ed74c28,0xe9cbecd6,0xb8c3fe10,0xc9832b56,0x3bffeea7,
0x0c6011f3,0x0ce91ce4,0x0980d708,0xd310e180,0xf9c4f465,0x2ff5f8b0,0x189eea03,0x1db017c0,
0x1f2df54b,0xe5de2bcb,0x0bc4b81b,0x0858f7c2,0xcd04e6b8,0x12b72827,0xdfc31546,0x074b419f,
0x19e534ee,0xdee0fdf7,0xd78ee2a3,0x0647bf8a,0x17a50ab2,0x536bfd9d,0x052ee70a,0x29870fda,
0x0e4fb959,0x0651ecba,0xbaf21aa5,0xd1c317be,0x133307fa,0xdcd317c1,0x09ec4707,0xdc9a024e,
0xd8dbeab6,0x1b7bfd38,0xd7850b3a,0x4e2ef8bf,0x176ed460,0x2af5f620,0x037ee8e0,0xf24fdb51,
0x089b0329,0xfa3207e6,0x35b2edb7,0x17b01216,0xd75122f9,0xe5f3ee2a,0x0e7ee3b8,0x0727f9b1,
0x023518e4,0x06422192,0xbacd1f6b,0x208806ed,0xf0ddfa91,0xfb0edd1d,0x22c0fefb,0xdcd60246,
0x35c50364,0xe43bf851,0xe751fe7e,0x011af130,0x1090f85f,0x025d00e4,0x337afdf5,0xee8401b9,
0xa2490034,0xd88407a3,0x108c19b9,0xf16401e1,0x1b3a24a2,0x063e2582,0xc252d9ca,0x023bf909,
0x05bbf053,0x1f83eac0,0x159803a5,0x0ab6e348,0xf70e3325,0xfc550b82,0xe65e09de,0xeb6ddb90,
0xe9750c3b,0xffb9236c,0xf7f43bf8,0xd03647fe,0xffc6f0b5,0xf909e13d,0x0449ffed,0x1958f64a,
0x3022eb9f,0x160c111f,0xbd05468e,0x0308c9ff,0xd606e5d7,0xdf9c13a9,0x4444051c,0xf91002c8,
0xccad4ae0,0x048e1beb,0xe81dcc16,0x1427eccd,0x132ac3be,0xd3360d49,0x2d210aea,0x19e7eba3,
0xf49d2d87,0x26e6054f,0xca07f4c3,0xe649b56c,0x2da5f015,0xeee6325f,0xef69043c,0xfa33545a,
0xff6cf8e8,0x3973bd0a,0x063df93e,0xc41f0392,0xe66b465e,0x20acf012,0x3a27e04b,0xe794fc6d,
0x0855f0fb,0xe7e21ce9,0x20280143,0x11ee21a9,0xc33ce4cd,0xe1bb32db,0xcb1be716,0x1d26090c,
0x5e26eeb3,0xfed50070,0xdca40195,0x0ef00895,0xec19c0df,0x2a46f69c,0xd397fbb1,0xef4ff887,
0xed563775,0x46c50688,0xfb37d7c3,0x0b73f4be,0xe957f5ab,0xe28de94a,0x2bc41439,0x1248e6fb,
0xfdf2249d,0xdbbde294,0x29bb0360,0xf4f6242f,0x11d9eb1b,0xdfd31fea,0xd90306c1,0x4c4e0e94,
0xe2f0cb59,0xeecdf3e7,0x26111b10,0x07750dde,0x12230846,0x03781ace,0xf768d0e7,0xdfd10f57,
0xd0eef280,0x14d8db82,0x20122092,0x2c7b1196,0xff2937bb,0x0bd805e4,0x03da9709,0xcc05b835,
0x07791759,0x17b0f7af,0x334515cb,0x00614ea2,0xfb2ee318,0xca15da3b,0xed2709d5,0x18d8edc0,
0x13b4ebac,0x04091a6a,0xf722f8e5,0x071e1e59,0x3438ec24,0xe55af51a,0xc3cf29e8,0xeb63f2b1,
0x00a700b1,0x18b22b62,0x1d7aed6f,0xe37314ac,0xe9d9f659,0x2241d44b,0x114a1023,0x07701211,
0xd43d136e,0xf43318c4,0x168fc860,0x116f9612,0x043c2b2f,0xfbdc4125,0xfd4a0027,0x01870e86,
0xe7e1c3bf,0xd752eb02,0xd7e341cb,0x2cc8f9b7,0xfe70f705,0xee0e1536,0x1439ea1b,0xb7f92d2f,
0x068706b3,0x1c8bf013,0xeddae65c,0xf5d22240,0xd8220a23,0x3c2cf0f6,0x3cde03a5,0xff97aa34,
0xe05e24a6,0x06db1e73,0x1623f1db,0x12860d6e,0xf5e3d6d1,0xc9fffcb0,0x0005350a,0xfb05245a,
0x2f1a0525,0xc24b1972,0xd87d0361,0x07751797,0x03b4f2d0,0x1ac2d6eb,0xe6c1297e,0xed760a0b,
0x24d61407,0x2649d8c7,0x0219c95b,0xafc3ff7c,0x231810f9,0xe73b2c3e,0x4590ce65,0xe96b1767,
0xbd1100c8,0xd6781195,0xeb6e2382,0x3a50ea86,0x06e8f964,0xfa6522e6,0x15bef6fd,0x0a2cf323,
0x067ab08f,0x16abdaf4,0x084810bc,0x328318e9,0x0a6614ff,0x061bdc77,0xe4690f64,0xd4c2f768,
0x02a418a4,0x0c59e6ce,0x0ac10b81,0xea4515ec,0xfb7d411a,0x072515a4,0xee1ec95d,0xc1c9fbfb,
0x1609eb01,0x00e33439,0x2468f6b9,0x1e361494,0xce6de257,0x0548e5fb,0x3acaf685,0x1b29d872,
0xfce5eee1,0xd77cf95f,0xc2e64f02,0x0b7dfe6c,0x2013dc83,0x15e710f3,0x041dead2,0xee3f3562,
0xfca4fb5a,0x255a8dff,0x2391ecb2,0x0094f3f3,0x15bf3a75,0xf4d612b9,0x182cdf54,0x0d941274,
0xda2cfb02,0x11dd0237,0xf99fda7c,0x22ebec7b,0x12120b6b,0xe0c2445d,0xe57f383f,0x2c4cb533,
0xeb68d2cc,0xc9892718,0xddfd4e78,0xe9073a56,0x3834b43f,0xe8f4cbc9,0x067a0509,0x2a76e600,
0xff810c42,0x39700f46,0xfb81d947,0xc16ff45a,0xcb4d0606,0x25d5c3b9,0x351ae577,0x04eb2532,
0xe7ca67ac,0xf6650c96,0xff8abad7,0x0d6ade94,0x053cba0f,0xd0903272,0x06cf2e49,0x1d22298d,
0x132af1be,0x2875eaca,0xd3a71049,0xc013051f,0x2b11c939,0x200100cd,0x1d67edd4,0x0ceb5d5b,
0xf400e356,0xff88c6ef,0xdc47f910,0x1c3ffbc4,0xfce4469f,0xd6ec0e74,0x2972e5f9,0xe40bbab2,
0xff141067,0xebf809c7,0x1608ff7c,0x409b0aaa,0xf72ccd0c,0xed39f85e,0xd7d7e960,0x16b5da37,
0x390c2dc0,0xf735e28b,0x147ced92,0xe75711ee,0xf42df310,0x0964213e,0xd0682de5,0xc6c01541,
0xd6551e37,0x3b2c0a1d,0xfde8e534,0xfb60438e,0xfb2efbd1,0x096005e3,0x2b6ce4fd,0x2404a2b7,
0x0bfa25df,0xf5c6ecb7,0x0faaebbe,0xf1cbfc04,0x0d9014bf,0xf3f61e7f,0xc93e17e5,0x2cd116d3,
0xbaa2edda,0xef57e21d,0xed8b3fd4,0xd31bfd5b,0x35c92230,0x10da060a,0xf4fbde01,0xddda12b9,
0x117eda26,0x37e9b23a,0x1d26d98e,0x1d5b1130,0x06701205,0xf3dce545,0xfbde0147,0xd493fa77,
0xe70519fc,0xd2943b41,0xf75a3541,0x39cf19b3,0xe542c4d4,0xd84d2931,0x04170a8e,0x1830e077,
0x254bef13,0xfe2615d8,0xf4253572,0xfcea02e0,0xdf04ef6a,0x0393e192,0x1d4ef20b,0x00630c73,
0x10fc1494,0x228fffa7,0x435c9d97,0xde4bedfa,0xa9fc3c80,0xe73e0aae,0xefd2217f,0x0a2c12a2,
0xfd850858,0xdc531418,0x2a7dee96,0xf92def3d,0x1d2ade4a,0x0832dfea,0xe7cef03d,0x335314ec,
0x1979efaf,0xde991928,0x9956197b,0xc99b35fe,0x322ffd17,0x0d6f00d0,0x0b813426,0xdebbe0b0,
0xea371551,0x3b06f55d,0x05abda25,0x24d50c1f,0x05eedd04,0xe65af622,0x2aeb1e03,0x20e0c694,
0xfd6ff978,0xe0f92d75,0x1c64d442,0xeced1f09,0x1740c20f,0xdd132056,0xcdf735a6,0xdcb6302d,
0xf624e721,0x28a2f35f,0xe1f9e7db,0xf7093138,0xcad50e13,0x3861ff63,0x0570d459,0x1adde21c,
0x1220fbba,0xdf44fff0,0x2a19f844,0x0d55a7a9,0xfc5f105e,0x29a91340,0x00710743,0xeaa12452,
0xc7d6fedf,0xd263f884,0x055614d9,0x003034df,0x2e181923,0xf46d01a3,0xd6b51127,0xdc75f318,
0xf73030e2,0x4b0ae28a,0xd65fb58b,0x31c74352,0x1beef7ff,0x17b8e181,0x0a7f0823,0xfbefb3d6,
0xf419e001,0x25cad405,0x106e1b4c,0xf1e41640,0xef784779,0xb6b20658,0xc733eefc,0xefbcec32,
0x371ce86a,0xe6c43aaa,0xe08241ef,0x1ec8d15a,0x0331df76,0x1545d59e,0x1be0edf0,0x01cd15ba,
0xfadfed4d,0xf7d003d9,0x2bdbf929,0xdb870bcb,0x13ff082b,0xfcf61655,0xec09f629,0xf72a0336,
0xe7ce2d40,0x26f22ca2,0x1e12da44,0xf411d808,0xeac103ed,0x05ab091b,0x450619d3,0x1393cfee,
0x0770e0ab,0x18b8e06b,0xf9c2e876,0x03f7038f,0x2220f786,0x05bda9f8,0xf298501b,0xe8782cda,
0xdbe4c9b1,0xc5b82e2f,0x1da3de15,0xd2cd2352,0x039345d7,0x1727d9b9,0xefd6d1f3,0xeff313c4,
0x18000155,0x36921085,0x1076cad9,0x2becd39c,0xdda7fc22,0xd69f0a2c,0x189ef91c,0x0c7129bb,
0x3b97208e,0xc77911ea,0xc4cd28d0,0xede8de8b,0x1c8bd57c,0x0d5f0f73,0x128e28fb,0x193a2bf5,
0x3703cbfe,0xf597e169,0xe3a3f15a,0xded9023a,0xf5b503aa,0x3fbafae4,0x0cfbf800,0x2edcea84,
0xa247159c,0xcf2a4964,0x1ddfcc09,0xe937d172,0xf8d829cf,0x053319a8,0xfabf21f4,0xff3dfd84,
0xbeabde94,0x0f21e6c7,0x2463f133,0x21f03d97,0x21ecfa52,0x10ebdf7e,0xe1d0d62f,0xd0bf0d42,
0x0627f4d3,0x59c1f321,0xdfc1170a,0x17bc24bd,0xd9412830,0xe722f7e6,0xff0ab809,0xd4282a56,
0x080b27e9,0x00d4d7c9,0x007d39f3,0x3fb4f23a,0x0103dc25,0xdc2ffd61,0x113fd746,0xfe86fa2d,
0xeceafa37,0xe3bb3350,0xf85f1a3a,0x0346d8f2,0x10cde3cc,0x11c40d45,0xae0615b8,0x08033007,
0xe9ef07fb,0xf45cdac2,0xf7f804d7,0xee85dbb6,0xfe155717,0x2ae91970,0xf002e001,0x011e013f,
0x14b6d9f7,0x0fa4e35c,0x39c8072f,0x1876c8d0,0xb15d3097,0x1d6b0cbb,0x0d830f70,0x09e40e6c,
0xd39ffd4a,0xdda01cbd,0xcbd14114,0xfc9dfd52,0x3e0af473,0xf6c204ee,0xe2a8e43b,0xdf4b2426,
0x057ffd09,0x35740d28,0x107af5b6,0xf07104a9,0xd074c722,0x088ab919,0x417ef7a7,0x10212960,
0xfba12c06,0x17e6ef39,0xc4c21ad6,0xc711dce4,0xdb81eb23,0xe982fcf1,0x2eb435ea,0x4a8613af,
0x3584fc99,0x9a21eaa5,0x0d95fd58,0xe939e643,0x3b52c20a,0x1d750202,0x0771fdb3,0x070a29f3,
0x1e0ff6a9,0xf218dbbc,0xe60e06f6,0xff083212,0xc154fc90,0x1e554696,0x1bd0d52f,0xdbbd0bd1,
0xcae80a57,0xfa4216a7,0x4cc502d3,0x1c3ad1c4,0xe12716ae,0xfd7200ff,0xe1f8f736,0x0ba9ca9a,
0x14fcfe40,0x0d171665,0xf7730002,0xf40e1150,0x00990e5f,0xce010717,0xd8db058e,0x2a39f427,
0x041906dd,0xfc5c0232,0xecf30b85,0xce58385a,0x0f641476,0x1574ec7e,0x2432d4c6,0x040dea80,
0xd7600c67,0xf7ca3b69,0x3870f58e,0xfa6ee8ef,0xffeac4c5,0x25523cc5,0xf2390a7b,0xe93d045a,
0x0e7625de,0xc455bf76,0xcbce2454,0x1ade2505,0x2d8625c5,0x1a800ebc,0xd60df2c9,0xb416f654,
0x0209e556,0x1bf4d26a,0x21a017e3,0x198a094e,0x07530537,0xd84ee558,0x1165d4c4,0x00a0f1da,
0x0514f4fb,0x1ffc0229,0xf942e7bc,0xee5e15cc,0xd48f1c95,0xdb792c06,0x01f6ee46,0x036cf8b5,
0xfb8c00ec,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_18_standard_DRUMS_tamborine[1920] = {
0x00000000,0x012dff8d,0xfe94ff3d,0xfccb035c,0x02ed00ab,0x0041fc12,0xfc16045b,0x0569fe9d,
0xfed3fc41,0xff580393,0x04bcfbd6,0xfc80ff78,0xff67034a,0xff6cff94,0xf9cc0270,0xfaff0894,
0x0615fda1,0xe985037c,0xf33b1f85,0x1ce6ee31,0xf03cf84b,0x27280577,0x2d69b880,0xb4c31bee,
0x16762d62,0xe60fd933,0x99576a20,0x72050018,0x23018df8,0xaeaa45cb,0x44f003df,0xfc98c13e,
0xce403817,0x1eed040a,0x0f82e133,0x0ecff649,0x0198f11f,0xd69217c9,0xfd4022b8,0x1388e580,
0xd6681507,0x438802a0,0x1316a7ef,0x93d850db,0x391f21a2,0xef6bc3cc,0xd961486c,0x518bd36e,
0xe922dae2,0x166d1a86,0x0537cfa6,0xbd9b3bcb,0x1f030dc4,0x01dde552,0x0aca00d3,0xe1670158,
0x15431ce9,0x29fbbdc7,0xbcd020a9,0x43560da1,0xf8e6b448,0xa6ff5e37,0x490000a5,0xf2a9c52d,
0xfcb1317d,0x4a9bbc72,0xb74afbb3,0xe27853c8,0x1fece4ac,0xde720724,0x251c0988,0x0750ceb6,
0xc42c2e82,0x0de718b0,0xf286f480,0x31480564,0x4225a2c1,0xc3cd0b15,0xf7c92bbd,0xd1d10bfc,
0x05543201,0x5424b7c5,0xf72fd9c2,0xffde0e22,0xcd760c21,0xd76945e0,0x357bef8e,0x14e4cf6e,
0xf8f50116,0xf62e0451,0xd8fb1b62,0x16c41511,0x367cc42f,0xd963f7c9,0xf7ae2ad9,0xfdb0eeee,
0xdb872645,0x3ffdf123,0x06dec4e6,0xe30322c6,0x0e2efb39,0xcb581287,0x10f225b8,0x2238c929,
0xd770123c,0x26d606fd,0xfce5d6c4,0xe0522954,0x18a4f86a,0xe7f8fd49,0x11fa0f1f,0x0f58dfb3,
0x0bd4ffcb,0x03c6e667,0xbc312cc7,0x161f2175,0x0956d96b,0x0a8a0b6a,0x20d1d4e7,0xc6271448,
0x0842250b,0xefa2f084,0x1fa517b0,0x4d2ea344,0xb789093d,0x14232f18,0xe206ded6,0xcb3155c3,
0x53e1d8ee,0xdc66db48,0x0ce42a5d,0x0557d260,0xbf543a70,0x3b0300f0,0xf777ce30,0xf7662691,
0x1cacde0a,0xd1de11d1,0x1c9513fd,0x1599d171,0xfd9b0563,0x06d7f1fc,0xd7e31763,0x0e7f12fc,
0xf83eebd7,0xf0fb1ec4,0x2434e894,0xde4afa3b,0x0942223d,0x3060cbe9,0xdd69fbe8,0xfaf7209f,
0xf6f6f72e,0xda762538,0x3aabfb02,0x245cb577,0xdda31197,0x0bf007fe,0xc2390e4b,0xff2b404f,
0x3431c076,0xc9361271,0x4812044a,0xf478b62f,0xc64c55e4,0x5bfdd5fe,0xbf1cdfd7,0xf2a7555b,
0x1e6ccb00,0xbd772b32,0x44400516,0xfd6ebde1,0xe81031e5,0x2509e281,0xd450094b,0x26561163,
0x10bec818,0xe4451c6f,0x0a25fc0f,0xc3731ab5,0x09d22b4f,0x1a61d66c,0xf8c803b8,0x2e17eb7f,
0x08bad675,0xe04217e5,0x09700da2,0x0292ef36,0xe81b126a,0x10a80565,0xf0d3f117,0xd2e02e23,
0x241406f6,0x0438d4dc,0xde76277d,0x48b4e6eb,0xe884cdd5,0xf1783db6,0x4191c2c9,0xa54d1103,
0x19bb4175,0x1392b8e7,0xcff73637,0x5fd8dbeb,0xdecdc511,0xd2b25018,0x10b4f4e2,0xd138187a,
0x355f0968,0x28f7b399,0xebd206dc,0xf92e06e5,0xd0901f6f,0x16bd16ca,0x0ba9d7f5,0xf1831683,
0x296ae532,0xcee3ff5f,0x0cf72b7e,0x1580ce00,0xd15121e5,0x22330449,0xe6bfed0b,0x0d572091,
0x2884c75c,0xd01b1219,0x251e0d4c,0xf642da09,0xf07a2959,0x1b98e27b,0xbf591933,0x14f92723,
0x0c65d420,0x0759102c,0x354ccb06,0xd0bf00f9,0x062123dc,0xedecef12,0xe63a2fcb,0x2f61e59b,
0xe4d7eff9,0xf79e228c,0x0b58f229,0x0060003b,0x0782f6f6,0xf76003da,0x068f0096,0xfa71fed4,
0x23d5f88b,0x1346d15e,0xd2f4190a,0xfac11cfd,0xe8e00484,0xfcf01d1f,0x33efdbd3,0xfcc1e174,
0xfac41047,0xf36bfd77,0xd64e24f0,0x0cce1225,0x17ace542,0x10beede1,0x0b25f042,0xf8d4fc8a,
0xe1361493,0xf1ca1d14,0x0cabfc5f,0x1121f1e1,0x100eea8d,0xe8b2036a,0xfce21740,0x00d9f476,
0xef5c1399,0x2a71f0dc,0xfca9debc,0xf14d1b14,0x0b94f4a4,0xd756122f,0x0b8319f3,0x1e1cdcd5,
0x0f31f000,0x0b6feb31,0xd73310a7,0xe9052812,0xf1de0d09,0x14760788,0x39f7cb85,0xfc64e185,
0xf3251111,0xde1d0fa8,0xdfb12f32,0x2520fa10,0x1087da36,0x09cafccd,0xf748f25a,0xc4962f00,
0x1a8e1851,0x0dd5d610,0x04ca0c2b,0x3a0bd14c,0xdb4aef1e,0xeb7831f2,0x062af7fc,0xf5120a51,
0x0ea6fa2d,0xf3e8fe0c,0x0994056c,0xe941fbef,0xef0126f4,0x317fe44c,0xf441e53c,0x031315d1,
0x09d2e73d,0xd51c1af8,0x0ed01426,0x0e25e521,0x071efdab,0x085ff022,0xe56b0d33,0xff0612a0,
0x0001f984,0x051904cb,0x1130ec84,0xe86f0484,0x01b51304,0x07c8f1bf,0xfd3c041f,0x13d9f47f,
0xf6e6f55f,0xe72e1844,0x01fc0caa,0x0eb3f43f,0x051ff53a,0x09cbfacc,0xf99ff7bf,0xead51752,
0x10e8ff15,0xf47bf78e,0x05970ed1,0x164ce574,0xe8e40432,0x03c90f52,0xfd56f6e3,0xfaed0c36,
0x0d8ef663,0xfb23fbca,0x03490355,0xf81cfd59,0xf57b10f4,0x16d2f731,0x0458ecc5,0xfe9c04ed,
0xfe7cfbd1,0xe00d1261,0xf8621c0b,0x11a0f388,0x068ef517,0x11edf48e,0xffc3f1f5,0xf0c70d99,
0x07c20499,0x027cf5db,0xfe4504a3,0x0bf8f7ba,0xea250098,0xef261ef7,0x0ed6f9e0,0xf651fc27,
0x091906fd,0x0cfeece4,0xff2afed3,0x081df949,0xf4050313,0x099a0493,0xf4cdf7ba,0xf50e180b,
0x1326f277,0xf033ff38,0x09000949,0x0056f29b,0xfe010971,0x054bf6ac,0xf3cd0952,0x1029fd47,
0xf95cf5f3,0x041f09e9,0x01abf2ad,0xea301237,0x053606fd,0xf899fef4,0x0e9f0203,0x09d6ea5b,
0xf8a805d8,0x004bfede,0xeba80ddf,0x154a0411,0x116fe1c2,0x038cfd66,0xffb9f609,0xcf8f1cbc,
0xfcde2460,0x1099ece3,0x0e76f8eb,0x2655dd63,0xdb98f8e9,0xe6c83342,0x0e60f6c5,0xf3ec05ee,
0x308bf0a2,0x01acd3ad,0xe13222c0,0x00a304f5,0xdcee15ee,0x1fd609f3,0x1229d34d,0xf5450c16,
0x132ff2fe,0xd75108c6,0xfd0c262e,0x15cde5eb,0xf680011b,0x16bdfa2f,0xfdb9ed98,0xf2e11075,
0xfe7a035c,0xf940068e,0x0e1afd4d,0x0cd9edd4,0xf562febc,0xecc111d9,0xf4c410bb,0x089b02a8,
0x193decc0,0x12bfe752,0xfc39f6b6,0xdbba152b,0xe8f626aa,0x12effe41,0x1027eb8b,0x1a6bed1c,
0xfe28e9b9,0xd4fb201f,0xffd41a2b,0x03def5ac,0x0ca1ffa6,0x1dabe2ca,0xf0c7f692,0xebb819e6,
0xfba909fa,0x04240171,0x0af2f5d7,0x02fef937,0xffdbfe3a,0xf54e057b,0xfcb90a19,0x0673fbc4,
0xff05fd7a,0x0bb7fd15,0x02c3f1cc,0xe8b00fa1,0x0a190af3,0x041dee2a,0xf6380cb4,0x15d1f5e2,
0xefddf754,0xf7231873,0x076ff73c,0xf55706b5,0x11c3fc42,0xfa8df3de,0x03f70ae8,0x0ad7ed4f,
0xed5c0b46,0x1063016f,0xf10ef717,0xfd4c1687,0x080ceed8,0xe7f01308,0x23baf9de,0xf4e2e5d6,
0xfa311cc1,0x12a1e7a5,0xd83f12b6,0x1b4a0f43,0x0865d9bd,0xf3f614ab,0x1aabed58,0xd8a50429,
0xfb8c263a,0x12f3e8d1,0xf3480332,0x11070027,0x02eaed8e,0xf35c0c4a,0x03ef0297,0xfd71fe21,
0x06bd00df,0x04eaf571,0xf2d105bf,0xf9e00ce4,0x0a2efd18,0x03aff4dc,0xf7c50675,0x0d26fdfa,
0xfaaaf53b,0xee1413eb,0x0c80017b,0xfdb1f54f,0xfbac0a5d,0x0ccaf7f9,0xfdb0f963,0xf865070f,
0xfaec06ab,0x033f020d,0x0ee2f618,0x0952f147,0xfdcbfd81,0xf51205dc,0xeedd106c,0x014b0a04,
0x0dcff5d0,0x06c5f33c,0xf2ae0456,0x01690a49,0xfbb9fa10,0xf6890fdb,0x19c9f389,0xf6e6f1d0,
0x021f0f99,0x0ac8ed0a,0xeacc0cd4,0x130e0300,0xfd96eda7,0xf48811a4,0x07f4fb95,0xed7f057b,
0xfda10fe7,0x05c8f967,0x087efc27,0x0f51f0c6,0xfee2f882,0xfb080487,0xf6f90742,0x067d0434,
0x05aef399,0xf3a70759,0x03a204eb,0xf43eff53,0xf97a11c5,0x17fcf296,0x02bfeec3,0xfaea05bc,
0xfd57023b,0xfa350519,0x014d036a,0x0926f964,0x0060f9be,0xfd6802f6,0xf9b902e0,0xfcbd080d,
0x0592fbea,0xfb21003a,0x0640013d,0x0101f883,0x00cb038a,0x05b9f855,0xf3c7052f,0x039506d7,
0xffc6f9eb,0x02fa03af,0x089cf4c8,0xf1870454,0xfb7b0cc3,0xfb8b0151,0x06ac039c,0x13b5eda1,
0xfd2bf711,0xfc0e05f2,0xf24c064f,0xf77a10e2,0x0cf0fa84,0x073ef550,0x0d4ef649,0xf96cf837,
0xee0d11f7,0xfb700ad1,0x03580142,0x0f30f558,0x029ef41f,0xf7b605e9,0xf83e06d5,0xf5c40b84,
0x11f1fe25,0x0e36e85c,0xf9fa0020,0xfe2502e5,0xedbb0981,0xfdc6102e,0x0d1df4a2,0xfef0faed,
0x03b3ff99,0xfb02fe8e,0xfd6807a2,0x0758faf5,0xffaafcd5,0x0313ff16,0xf9eeff98,0xfc7d0898,
0x02a4fd33,0xf8f6034d,0x06340291,0x0053f73d,0xf3df0b02,0x0e0e0021,0x095bee7a,0x002fffb2,
0x08e9f8dd,0xecfa0277,0xf32118ac,0x0d73fa7c,0xfa71fa16,0x05610639,0x0801f147,0xe4a70c0e,
0xffc81636,0x1626ec68,0x02aaf565,0x1454f6b3,0xf891f007,0xe1811e5f,0x0a190941,0xfde3f5aa,
0x02f60755,0x0d2ff074,0xed7703df,0xfa781184,0x0320fcc9,0x0651fea2,0x0d89f18c,0xf06a00c8,
0xfde50f74,0x0297f870,0xf80a07fe,0x126afac5,0x06eeeda1,0xfc4e02c2,0xf9080289,0xf1480df7,
0xff0507c7,0x0162ff4f,0x0cc3f9db,0x0738f1f3,0xfc950190,0x081bfcf7,0xf821fd4e,0xff7409f7,
0x02e0f822,0xec6e0bb6,0x00f00c17,0xfe28fb64,0x07000454,0x1857e953,0xf685f7be,0xfd350c7b,
0xfbd2fce1,0xec5010c0,0x097407ac,0x0ef6ed98,0xfca5fb3c,0xfe0f0511,0xfc3affcd,0xf33b0b36,
0x0b3a0337,0x0cb7eda6,0xfe14fdf5,0x0654fd3c,0xf47afff6,0xf7ea100e,0x0951fb7b,0xfba6fcd3,
0x0847023e,0x04eff229,0xea510c2f,0xfff30f31,0x04a2f714,0xf6da05d4,0x0e67ff83,0x075eedef,
0xf7bc062e,0x0b63fdfa,0xfc01f7e3,0xfeaf09d0,0x09fff4e0,0xe8ca0750,0xfd4d144c,0x02cdf739,
0xf51d09c1,0x0ffafd9b,0x0771ef3a,0x0333fef8,0x019ff9e5,0xf8150661,0x050f0121,0xf9fffd8b,
0xfad80a0b,0x03eefda9,0xfc0500b3,0x069c0060,0x0557f682,0xf81f0256,0xfa1b0874,0xfc9d03e3,
0x021e0200,0x0ab7f84a,0x056ff6ff,0x03edfc20,0xf960fef4,0xf0880e3a,0xfb090a73,0x03de0163,
0x0de5f4a0,0xfb14fa15,0x06a604d8,0x04d1f219,0xee4f0c6d,0x0d670406,0x0507ef99,0xfa6205a9,
0xffc60050,0xf69b05f2,0xfede0645,0xfffdff5b,0x0447ff0e,0x03ccf99d,0xf5810370,0xfd9d0aca,
0x0c45f7a2,0xfffff93f,0x082ffed5,0xffc4f66b,0xf2e30c41,0x03fb0345,0xf986ff8f,0x02ff054a,
0xffbff979,0xf9e50858,0x0b4dfaf0,0xf9f6fb64,0x04b80691,0x0cf2f0c2,0xf53a0031,0x0066094a,
0x040ef8e2,0xf4af0540,0x025a07b4,0x037ff77c,0xf1170872,0x04a00866,0x0461f53f,0xf96305cf,
0x0ea6fbcf,0x004df38a,0xff0806fd,0x0840f6bd,0xf05c0556,0x05c6097c,0x0095f4d9,0xf8580b12,
0x0cfaf907,0xef58ffa4,0xff8c113f,0x097ef245,0xf725051a,0x1554fa9e,0x004eecde,0xf4d80ea9,
0x089cfcc2,0xee110306,0xfcd611e9,0x04b4f75d,0xf5c50777,0x0e2afe9c,0x0348f1f5,0x013003cd,
0x0ac9f55b,0xf2c20111,0xfd770d52,0x0511f953,0xf8bf0395,0x0a69000f,0xff9df4c3,0xf22b0d10,
0x066c02fa,0xfd00fb28,0xffbd05db,0x065af99b,0xfe66fedc,0x047bfecc,0xfe7ffd12,0x008e02a2,
0xfd12fe1a,0xf7130959,0x05e100d5,0xfabafcc1,0x01ab079a,0x0cb5f31b,0xf808febb,0x045d054a,
0x03c5f72f,0xfccd02fa,0x0259feef,0xfda200b3,0x024effdb,0xfc29000d,0xff6603ab,0xfa2900ab,
0xfa2309d0,0x080bfcc7,0xfd21fc0e,0x04a502d0,0x0601f608,0xf9a802ec,0x03e80142,0xfb31fe7b,
0x01ba0563,0x03b6f8be,0xfc0d03a2,0x086cfc2b,0xf2eaff69,0xfba310a1,0x0cd4f51c,0xf79efece,
0x090a03cc,0x03cff231,0xf3e309f5,0x09540139,0xff17f7b4,0xfdf10658,0x0692fa79,0xf56b010c,
0xf7a20da3,0x04c40029,0x0232fb3e,0x010aff85,0x0364fd49,0xff0afe2c,0xfe3b02b6,0x06ddfdcf,
0x0407f7dd,0xfa690256,0xff0503d3,0xfa4d01e4,0xfd4c06cc,0x023cfd9d,0xf88c0367,0x047803e1,
0x07d6f676,0x044afba7,0x0334fa60,0xf8c802e4,0xfc820673,0x005801b3,0x09a3fb09,0xffe3f799,
0xf459095a,0xfd5e072d,0xfb7802ad,0x04220261,0x080bf6db,0xffe2fd0b,0x0328fec3,0xfcd4fec5,
0xffe30468,0x0393fb29,0xf7ae036d,0x020e054a,0x019ffab2,0xfc41033a,0x00a700e8,0xfea2008c,
0x0395ff4b,0x0233fc0a,0x025dfeb1,0xffd7fd47,0xfa0d047f,0x013a0308,0x0258fcdc,0x0118fea8,
0xfd75ffc1,0xf88b0622,0xfeff0542,0x05d8fccf,0x063cf970,0x03f6fa73,0xfcd7ff0e,0xf89c06a2,
0xfdf50546,0x00f0ffd4,0x04f4fdce,0x04d1f931,0xfb840038,0xfcb80519,0xfcba025f,0xfeec03ac,
0x0660fc58,0x00ccfb49,0x016100fc,0x0328fb88,0xfa7b0204,0x012c0380,0xfdc6fdd3,0xfb7f066c,
0x05a1fe03,0xfd10fd9d,0x02a302fc,0x059ef8a5,0xf9ec0102,0xff0e0560,0x0220fd85,0xfd7000ab,
0x006701fc,0x025dfd82,0x007fff17,0x014ffea9,0xfd5c00ac,0x00f801b0,0xfcd5ff17,0xf9ed072d,
0x05c6ffdd,0x021efa28,0x03f3ff6d,0x0791f7c5,0xfbc4fe57,0xfb7805fb,0xfa050406,0xfbd10734,
0x0547fe5e,0x016ffbd1,0x045afe57,0x001cfb2d,0xf57d0728,0x00f90692,0x04edfa69,0x033ffd64,
0x08e9f91e,0xfeb4fa4c,0xf88206fe,0xfeac0417,0xfc4201a0,0xfd5e04a0,0x027dff4f,0xfc68ff53,
0xfed40573,0x0a7ef970,0xfef5f969,0xffc4044f,0x0549fa9a,0xfb6a0062,0x02740270,0xff6cfc90,
0xfa6f04dd,0xfc62040d,0xfd890413,0x04abfe46,0xffd6fcf8,0x05beff30,0x02c2f841,0xfaba045b,
0x0779fe9a,0xfd69facc,0xfd99064c,0xfdeafe4a,0xf3800a9a,0x06d003af,0x00faf7d3,0x005803fb,
0x0b94f6dc,0xf9e9fbf9,0xfc89090a,0x0307fd15,0xfd130176,0x0762fe0f,0xfd10fa6e,0xfa2b08fa,
0x055dfdd3,0xfb0bff4e,0x0017046c,0xfdb2feb5,0xfea804ad,0x04c0fc01,0xffabfef4,0x093dfba4,
0xfbcffa0d,0xfaa00a63,0x09e5faa7,0xf816fcc9,0xfa310c41,0x0894fb5d,0xf93efd70,0xfb370a2d,
0x0864fbe9,0xfde5fb1d,0xfec50553,0x0aacf96c,0xffa0f8d4,0xfda604a1,0x004dfe38,0xf2f50761,
0x0257090c,0x0a55f4e9,0xfed6fca1,0x0312ffa1,0xf90dff8c,0xf66e0c27,0x05d00139,0x0490f8bd,
0x01e3fe0b,0x02fafcce,0xfccaffc4,0xfdf20487,0x04e2fd61,0xfc46fe26,0xfe3505c8,0x01e2fcdb,
0xf76104cd,0x03550463,0x02ecf9ac,0xfffd00c6,0x0396fcf7,0x00f9fe66,0x02a0fd4c,0xf98b01cc,
0xfffb058f,0x01bdfc69,0xff71017b,0x05fffc12,0xfb11fe03,0xf8b908b6,0xfdb203fd,0xffbb01f1,
0x0747fc6b,0x0558f81b,0x01cdfd70,0x00cbfdf1,0xfb01026c,0xfeb9044f,0xfefdff8f,0xfd7a0329,
0x0179ff9d,0xfa5001b1,0x01f104ac,0x07c9f7de,0xfda1fe0f,0x03f500ba,0x028dfa38,0xfb0d0267,
0xfe61042e,0x02a1feda,0xfd78feac,0xfc31058b,0x04bbfe5c,0xfb46fe87,0xfde806a5,0x047cfc76,
0xff11febb,0x048eff18,0x04aef9e6,0xff6cfde7,0xfaff033b,0xfd6004a1,0xfd930168,0xfe4b037d,
0x0558fd97,0x00f4fb8e,0xff7f0139,0x0046ff15,0xfbf30237,0xffb20333,0x0396fd7c,0x0072fd85,
0x01050048,0x0156fd7e,0xfa9a0289,0xfffa040e,0x00f9fda8,0xff680166,0x05c5fca6,0xfe54fcbc,
0xfedf038f,0xffdbfeb3,0xfc790367,0x0280ffef,0xfc2bffd9,0x01bb0375,0x045dfa22,0xfef90005,
0x053efd64,0xfae8fe1a,0xfa8d08a0,0x02c5ffa0,0xfe73ff60,0x050aff71,0x0127fa35,0xfd04039c,
0x046bfe1c,0xfc34fed7,0x00590431,0x0176fc18,0xf8950490,0x018b040a,0x0131fc76,0xff4a014a,
0x029bfe71,0x01eafdec,0x0152fd89,0xfb8b0223,0x02e30233,0x00e9fb1b,0xfcb30434,0x088bfc43,
0xf9dbfbf0,0xf8870b96,0x01e10002,0xfad50274,0x0a57ffc9,0x0bddf022,0xfac2fdc0,0xfa1d0735,
0xfa440514,0xfcef05b7,0x0557fe7f,0x049af98e,0xfd81ff07,0xfd5703e0,0x01560034,0x01a8fe8a,
0x0472fced,0xfe9dfcf0,0xf98d05ad,0xff1e03cd,0x00ccffc1,0x0535fd49,0x0223fa9a,0xfc270211,
0xfed702b5,0xfdf10130,0x009501a2,0x032efd3e,0x028dfd60,0x01bbfd40,0xfc6900cc,0xfb240513,
0xfc490415,0x005002ba,0x080ffb24,0x038cf89d,0xfdfc003d,0xfc71027d,0xfa510564,0x03500256,
0x0731f8b8,0x020efb7f,0xfe7bff7d,0xf86f04c5,0xfd6f0703,0x04dcfd54,0x00f0fcb2,0x02c8ff22,
0xff8dfccc,0xf6d20655,0x00c805d0,0x03aefb49,0x01c9fec6,0x0798faa0,0xfe4afb3f,0xf8a506e8,
0xff7503f8,0x004bff69,0x0334ff27,0x0486fa9e,0xfb9dffab,0xfae0065a,0xfdb50310,0xffcc020f,
0x076ffc2f,0x0493f85f,0x006bfe77,0xfb5e00bc,0xf67b0983,0x06480249,0x023af801,0xff6002e2,
0x06a3fa66,0xf6eb0094,0xfd8509df,0x0566fb1d,0xfed1fefe,0x0750fdb9,0x0013f8f5,0xf66e07c0,
0x00d104aa,0xfde7fecd,0x01fa02c6,0x06b7f88c,0xf9990053,0xffff057e,0xffcefd40,0xfdec03bc,
0x06c5fc81,0xff72fba8,0xfe2e02d1,0xffa0008c,0x020bffd5,0x0102fce4,0xfc560292,0x00bf015b,
0xfc4100a2,0x00ef0396,0x04c8fab5,0xfd6aff9d,0x022d0118,0x0051fd24,0xfe8c0205,0x0173ff51,
0xff28ff9a,0xff2a0119,0xff2600de,0xffac006c,0xfe5e0118,0x01bc0073,0x0096fda6,0xffff00f9,
0x0145fe06,0xfb200279,0x037c0219,0x01f9fa60,0xfd8202c6,0x04adfdb1,0xf9d3ff83,0xfd8107c0,
0x04eefc54,0xfff4fdeb,0x019fff69,0xff16ff4b,0xff07014f,0xfe4e0157,0x03ceffcc,0x00adfb3a,
0xfa1904da,0x02910197,0xfe61fe21,0x01bb022b,0x051afa4c,0xfc05ff94,0xfccc04fb,0xfffd010c,
0x0028ffe3,0x0175ff64,0x0151fdfb,0xfe5e006c,0x010a00f4,0x01fdfd92,0xffecff58,0x004bfff5,
0xfeaf0025,0xfd430271,0x000c01c3,0x014bfe8c,0xff020010,0x01290046,0xff79fec6,0xff8c01c8,
0x032afdab,0xfdfaff3a,0x01b4018f,0x0124fc7a,0xfbe802f2,0x02920110,0xffadfd34,0xfe0302e2,
0x02a8fefc,0xfd96fef1,0xfd31045f,0x0344ff27,0x001cfd86,0x01f20061,0x0317fbb6,0xfa8d018f,
0xff4b04cd,0x0171fdaf,0xfce601ac,0x0168015b,0x011afd8e,0xfefe00bd,0x0260ff73,0x0274fcf7,
0x00aafe62,0xfc3f0128,0xfbf80544,0x011800e4,0xfff9ff53,0x0494fe73,0x01a0fac5,0xfb720337,
0x01d00191,0xffadfe07,0x008c0152,0x01bbfd6a,0xfc5f016a,0xfe610321,0xfec10128,0x01f4003a,
0x02fffc8b,0x01b2fe28,0x0150fdd8,0xfc7c013e,0xfe6c0361,0xff760062,0x004300ac,0x011efea5,
0xffdefff2,0x0143ff36,0xfe03ffff,0xffd9023f,0x02fafda2,0xff2cfea6,0xfeb801cc,0xffbd005a,
0xfe180127,0x0098013a,0x0249fddc,0x016bfe6c,0x01d2fdf9,0xfd33001c,0xfd1e0406,0xff4f00fc,
0xfe0301f3,0x0554fedf,0x0248f9e3,0xfd7c020d,0x0171ffbf,0xfaa70194,0x01110487,0x0547fa05,
0xfd95ff69,0x017e011f,0xfe2afea8,0xfc280489,0x0288007c,0x01fbfcab,0xfecd0003,0x00030102,
0xfff3ff57,0xfdfc018c,0x02680060,0x033ffbf2,0xff24ff04,0xfe580186,0xfddc01f4,0xff9d017e,
0xffc7ffea,0x01d5ffff,0x0306fc39,0xfbf400af,0xffbe03a4,0x00d6fdf3,0xfe6201a9,0x0476fe77,
0x008bfc08,0xfd16027e,0x00010159,0xfec8001c,0xff7b01a9,0x02a0fe73,0xff3bfe8c,0x00100189,
0x0282fdb7,0xfe9eff83,0xffd0014f,0xfdfd0037,0xfcbf03b8,0x01ea00a8,0x029bfd14,0x020dfdcb,
0xffb4feb0,0xfe0501bd,0xfeb50160,0xfe5001e1,0x02d9ffbb,0x0169fc76,0xfe0b0157,0x0120004c,
0xff26ff63,0x005c0110,0x0157fe57,0xff20fffd,0xfecc00ff,0xfe0401cc,0x008e00fc,0x01bdfe77,
0x02b3fdfa,0x01e6fd0b,0xfe57000c,0xfdec0230,0xfda1021e,0xff420206,0x015eff47,0x00defed3,
0x00b3ff29,0xff88ffd2,0xffaa00af,0x00f3ffba,0x01a9fe84,0x0095feab,0xfef9003a,0xfd4001db,
0xfcd4035c,0xffba01fa,0x024efebc,0x02d6fd33,0x01c4fd8a,0x006bfef4,0xff630017,0xfeb6010e,
0xff2c012b,0xff790087,0xff4f00c2,0x00e2fffa,0xff75ff3c,0xfed001b8,0x01deff51,0xff90fee5,
0x01a40073,0x0282fc80,0xfce700ba,0xffef0269,0xffc6ff07,0xfef501a6,0x0265fed0,0xfe55ff02,
0xfdfe02f1,0xff700093,0xff5b0156,0x0472fdf3,0x01c5fbce,0x0032ffff,0xffa4ff4f,0xfce40268,
0x00230195,0xfea9fff8,0x000f0198,0x0156fe37,0xfe8400b0,0x029cffc2,0x00a2fd38,0xff610115,
0x00d6ff39,0xfe6200a2,0x006100cc,0xfdd80025,0xfe730330,0x032afe72,0x000afdf9,0x01f40014,
0x01e0fc8b,0xfc2601b5,0x004e028c,0xffabfeb3,0xff0501d8,0x014ffef5,0xfe3b0099,0x024e0020,
0xff4efdd6,0xff1602ac,0x0320fd74,0xfbd80063,0x00ba039f,0x02b5fc00,0xfd190128,0x02a0009e,
0xff60fd52,0xfd750373,0x032afef4,0xfe13fe84,0xfec3033f,0x021efe6f,0xfeedff99,0x01f70054,
0x029afc8d,0xfe87ffad,0xfe6101eb,0xfe150191,0xfed701f4,0x0161ffc1,0x00ebfe75,0x0047ffb9,
0x0169ff13,0x0008fef0,0xff2700cf,0xff710071,0xfe03015e,0xffaa0189,0x0018ff9e,0x000b005a,
0x02fbfe6b,0x0076fd5b,0xfd8e01e8,0x020f0084,0x005dfd5f,0xfcf3029e,0x03670005,0xff7efca9,
0xfc53043d,0x033cff8d,0xfd92fe84,0x00e40325,0x0420fae5,0xfb070142,0x026802c2,0xff69fc29,
0xfab005be,0x053bff7c,0xfeedfc21,0xffdb0332,0x039bfc1f,0xfc960087,0x01c901cc,0xff54fd7c,
0xfdb9038f,0x0428fe18,0xfdb0fe26,0xff360387,0x01f1fdb1,0xfc32017e,0x017a022a,0x020efca5,
0xffd90011,0x02a0fe56,0xfdd7ff07,0xfd0c03f5,0x009e0091,0xfe5d003a,0x00f30158,0x02a4fcf0,
0xfdac0008,0x00fc01b6,0x01d9fd43,0xffb60010,0x02d2fe6e,0xfdccfece,0xfd000429,0x0023008e,
0xfdc2013d,0x024500c4,0x025efc2b,0xfec50039,0x00fc0029,0xfe96ffad,0xffa601e8,0x0219fe54,
0xff76ff41,0x0073005d,0xfe94ffc3,0xfd340309,0x010800cf,0x0096fe9c,0x00b2ffed,0x023cfe26,
0xffb4fea9,0xfeaf017e,0x00eb000d,0xff29ff82,0xfff1014f,0x01affe5a,0xfdf90038,0xffc701ce,
0xff31ff9d,0xfe970211,0x023cff3b,0x00b3fe2e,0x013dff7a,0x0017fea6,0xfe410172,0xfff800d6,
0xff510028,0x0029009d,0x00aaff20,0xfee8004d,0x007300c3,0x0118fe94,0xff420018,0x01560000,
0xfffcfe7d,0xfdec01cc,0x009900bd,0x000bff42,0x00720031,0x0168feb3,0xffd6ff4c,0xff1800ab,
0xfebf010d,0xfeb90166,0x001c00bc,0x0183fef2,0x00fefeab,0x0151fef5,0xffcffef0,0xfdc901b5,
0xffef015b,0x0003ff97,0x000b0048,0x00daff59,0x003bff6b,0xffadfffe,0xff2c00c3,0x003a0055,
0x0035ff99,0x0015fff3,0x0096ffb4,0x0094ff33,0xff16001d,0xff4b011e,0xff4e0069,0xff5b010a,
0x0176ff7b,0x0095feaf,0x0116ff8f,0x007bfe9a,0xfe8400f9,0x004c00a7,0xff04ffde,0xff580183,
0x00f5ff53,0xfed60018,0x00cb00c8,0x0183fe0c,0xfee9fffb,0xffe400f4,0xffdaffaa,0xff0b00f9,
0x01f1ffaa,0x0131fd9e,0xfef10072,0xfff3007c,0xfdd600cb,0xfef20280,0x01edff05,0x008efe95,
0x0151ff70,0x00bcfe61,0xfe4100c8,0xff6a0171,0xff1f0050,0xff5b0152,0x022aff01,0x00affe2c,
0x009effcc,0xffd6ff32,0xfd9301b2,0xff2901e1,0x0002002a,0x0093ffcb,0x0110ff19,0x00f3fed9,
0xff74ffb6,0x003a00aa,0x00bdfedf,0xfe8400a8,0x009100ba,0xff68ff56,0xff760171,0x016afedf,
0xfe970005,0x00a200ff,0x008bfe84,0xfece00ec,0x00e3001f,0xffe3ff3d,0x0060006b,0x01b9fe7f,
0xff58ff3e,0xfe4d0197,0xfeb40160,0xfe3c01a1,0x00a500f0,0x0290fde2,0x0174fde7,0x008dff02,
0xff61fffe,0xfeab0121,0xff940115,0x003affc8,0xfebc007f,0x003200fa,0x00cbfeec,0xfff3fffc,
0x01ceff1c,0x0088fe5c,0xff0e008b,0xffb400ac,0xffb3002e,0xff79007b,0xffc10062,0xffa9003d,
0xffef0053,0x0023ffd5,0x004bffea,0x00cfff4b,0xffffff98,0x00c8ffd2,0x0033ff0e,0xfe7d00ec,
0xff76012f,0xff9e003f,0x00350061,0x01bbfecf,0x007cfe9c,0xff990032,0xfecd009a,0xfe7501c4,
0x00c2005e,0x006fff0e,0x0119ffac,0x0146fe26,0xfe2e0073,0xffb20194,0xffd5ff9a,0xff6400f4,
0x0183ff44,0xff97ff2a,0x0063009e,0x00b8fec8,0xfeff0082,0x0076004d,0xff21ffc7,0xfee1018f,
0x00290033,0x0000ffff,0x016cff5f,0x013bfe51,0x005aff60,0x0030ff99,0xfe4f00a2,0xfe220232,
0xff1d0131,0xff8d00df,0x01bdff61,0x016afdfb,0x010eff11,0x0093fecd,0xfef2008a,0x007a006b,
0xffbbff78,0xff1100fe,0xffc60066,0xfea600af,0xff230183,0x013affb8,0x00a8feb1,0x0074ffd9,
0x0152fec7,0xff8aff8c,0x00340075,0xff69ff9d,0xfe0501d5,0x006700d0,0x0002ff62,0x00670035,
0x014ffec3,0xff7bff83,0xff7c0101,0x0248ff17,0x000afdea,0xfe020216,0x0176ffd4,0xfc820045,
0xfe0b0472,0x022afec4,0x008afee0,0x02e9fe7b,0x02e4fcae,0x008cfdd7,0xfbbb0222,0xfe5f03e6,
0xfe61004d,0xfdeb0349,0x04aafe47,0x00cdfc00,0xff580147,0x0037ff4e,0xfc5401fe,0xffb002f4,
0x0388fda0,0x0094fd6b,0x00d1004a,0x013efdc2,0xfb08024e,0xfffc03bc,0x00f0fdd3,0xff57013f,
0x04b5fd52,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,

};

const uint32_t sample_19_standard_DRUMS_crash5[6784] = {
0x00000000,0xfda9fe05,0xff1d0155,0x01f30ae5,0x05c9fa87,0x003c108e,0xfb01fe3c,0x0a54f331,
0xffd0f941,0xfd35f983,0xf9f00b94,0x013b138b,0x0bdc0a84,0xff67fcf0,0x03fafc6f,0xff07f746,
0xf85ffc57,0xf78a0e0b,0x1103fc6b,0x09dee8bd,0x0436f065,0xed110329,0x00e00fe1,0xf61cf5d9,
0x0035014a,0xf8bb0866,0xfe2bfb97,0x080601f5,0x1336fb5b,0x0570fb07,0xf5240821,0xfd960015,
0xff151442,0xfda30aaf,0xfe22f3b7,0x1b8de705,0x0ef3f0c3,0x07d31a00,0xfa840e85,0xf2fbf3ec,
0xdae2e96c,0xe97cf26b,0x0b9300ac,0x2026080c,0x12d31833,0xf8371d3b,0xf64f038c,0xe4ce0186,
0xef3af9f7,0xed6ce5b2,0xfbc6e889,0xffc204be,0x11281fac,0x191109f7,0x16fe1539,0x1a3609e7,
0x0e0d0245,0x10b711d6,0xfa42f352,0xfc6ffe04,0xce9dd946,0xcedae03c,0xe95eca56,0xf094df05,
0x1aa8f28b,0x0c431b97,0x2ef40e8a,0x21350e34,0x1e32218d,0x0e7c2437,0x243e044f,0xe56df334,
0xe446ffdd,0xe275ecec,0x0068e92d,0xfa45cf5d,0xef15142d,0x0f32e9f3,0xfa2d0289,0x076b1aa2,
0xf3e10874,0x283b090c,0x3c7d11c6,0x12db154d,0x04a207b1,0xf455edfa,0xc064dade,0xd515f5d2,
0xdc5bedd2,0xf6abee70,0xfdefe1ad,0xe66216fd,0x21541d2c,0x425d1d08,0x2f821b67,0x160a0ecc,
0xf4dd1493,0x042ad9fc,0xdaefea79,0xf3e3f5a0,0xfa01ec26,0x1354dfdc,0xec5dff1e,0xfc9e0284,
0x13770878,0xe3c611bf,0xf4a4132a,0x10da0288,0x0048fa26,0xe2232a22,0xf68b0983,0xefd7f90b,
0x0577d2fd,0xfb9c01e6,0x1579f201,0x1ba509af,0x26252cf1,0x11c01683,0x07190a1d,0xfffee40c,
0xf93d04ba,0xfcf9d3fc,0xd87bed30,0xca0ff1a6,0xd454f55b,0x01b9ecfa,0x21c2f3a7,0x23240aa1,
0x126a10c4,0x04a4312a,0x11c82f84,0x04a21dbf,0x11b2e370,0x1ce2f159,0xe2ffe3ab,0xdc0cf3d8,
0xe8f2f19e,0xf9d6ce74,0xe104ebb6,0x0df309d1,0x1921fbd4,0x22d30312,0x23e73b85,0xfa6e39cc,
0x0fd11fad,0xfece05f2,0x1e76fe5e,0xe039d69e,0xe72adb20,0xc06edc58,0xeac2e1b7,0xf1c1c7b4,
0x13a7e616,0xf8390fe6,0xf49a41b1,0x36582318,0x21da260b,0x00930e69,0xf50ff81f,0xf92efb1c,
0xec8a22a6,0xee881430,0xeee831ee,0x1e47db8f,0xf410e9dd,0xf437e47b,0xf8c0d73d,0x032c0445,
0x06c3ec31,0x07a4efb7,0x3f34cd48,0x1058ec76,0x0bb7f24d,0xea671c1a,0xf1b11b0e,0xdf811a65,
0x0c6f05f4,0x117ee9bd,0xf2290e0a,0xe3bb2436,0xf06f3992,0x2a1606ef,0x18a9d65d,0x0566f88d,
0xdd690cdc,0xdd50185f,0xce88004b,0xf672e5f4,0x0b85ea55,0x0ce1ed04,0xfb5af71d,0x0903393d,
0x0422223c,0x0903117a,0x149de339,0xdc0c03c3,0xede00d7d,0xd27906ed,0xffa80b69,0x1fe5ea66,
0x2693fbe4,0x1f16e695,0x1d8ddefe,0xcca4f8e2,0xcac944c5,0xf6e021ec,0x1933e659,0x0e22da29,
0xe2461c63,0x016c1089,0xf5ef1882,0x157c0a5b,0x1030cbdc,0x1556f6b4,0x10f6c9ba,0xc43219f9,
0xf83d22c1,0xe16a2396,0x2d8ff19b,0x1bc7e633,0xf6eaeb56,0xddb91696,0xd02b2782,0xf0671993,
0x03a20d89,0x4761e009,0x053bdbad,0xe9412387,0xde00223e,0x07d40695,0xd8fcf8c0,0xe7a30746,
0x116d130f,0xf31013bd,0xcbd7fec5,0xb4a44b49,0x193004df,0x0dcfed4e,0x16a6fc3b,0xeae4fb42,
0x01d9125b,0xee3f01e4,0x2adf107a,0x3abad25b,0xff87da51,0xeed004c8,0xe0081e39,0xe1571373,
0xe59a2278,0xfe4b0163,0xf38f08fe,0x2fb2e97e,0x3135f9d9,0x5915a7d8,0xe926d115,0xe26a28c2,
0x0ab6eb2e,0xf1f8fa60,0xe50303b4,0xa3553989,0xe4c534fa,0xfd721799,0x272ef629,0x15451fb7,
0x2e0fe85c,0x1054f77c,0xe8761602,0xeb5d1305,0x5825d6da,0x11569105,0xbdb3f82f,0xe876eee1,
0xf0a00bca,0xfb54082a,0xd28f5d3f,0x2bbe15e5,0xfb00f980,0xe7e41fc3,0xf7ae1b2a,0x10d80282,
0xf923e567,0xb7d23418,0x08d60d13,0xe5e02a4b,0x07d300d8,0xec32db98,0xee5ef504,0x148cfde7,
0x3570c166,0x0f0df18c,0xf25d27b9,0xe9a11580,0xf80813bc,0xdcc218db,0x22142916,0x186eb04a,
0xec490b40,0xfb840b8f,0x1e490407,0x2685ca8e,0xf918ee0e,0x01ab0476,0xe103f0b1,0x18e50374,
0xea92013b,0x080c223d,0xe842e83e,0xfe711fb2,0xf833f592,0xf12021b3,0x3856eeed,0x04cfdd80,
0x25f81449,0x1e1edc84,0xf2de0158,0xca041beb,0xe6742529,0x05eeddb4,0x20a8e96e,0xf43bdf0e,
0xef2ffd4b,0xf649f53b,0x186e1037,0x45d9baec,0xf33d082a,0xe7774b59,0xd3fa530a,0x2a010c79,
0xebf2f198,0x09ba106e,0xff07bdd0,0x01f6d89e,0xcea7e5e9,0xdef74f41,0x075beb43,0xd5111f95,
0x047a0b40,0xf90f2854,0x2fecee7f,0xe4b504aa,0x0cfa286d,0xf0cc0f71,0x27cf0157,0xf813e850,
0xeee70975,0xe271fbc6,0xf5b6e751,0x1a95c312,0x09fe1490,0x33b8cedb,0x1018e845,0x088df78c,
0xd3cd3d37,0xffcb1476,0x1337ddc9,0xff60f569,0x07be078b,0x02021725,0x25e1f989,0xee5b13dc,
0x1cdd123b,0x4e32c9c8,0x119ca559,0xde450c7b,0xecd3ec82,0xf438e4f9,0xf247f2c5,0xe6d9f5f5,
0xee1a10ad,0x3881fcd5,0x085a146d,0x1e6907d5,0x22430e4c,0x2219fe6c,0x1a90f178,0xfb63ff9e,
0x0cc5cfd3,0xaa26f92c,0xab855012,0xe2381b31,0x2c51e5ca,0xf557f5e3,0x1e1be20e,0xffdafbad,
0xdd432536,0xeb153240,0x1a290176,0xddf50ab2,0xc4083c8b,0xf0052c71,0x0963059e,0x2560dae3,
0xcd890f91,0xc4173099,0xb61d3bea,0xe97c148a,0xe88e17dd,0xbe4b1c8a,0x12841691,0x1123e802,
0x0cd60ffb,0xefd20562,0x1eb4eaa3,0xefb8085d,0x03431249,0x3cc2dcb7,0x2f51b730,0xf5030713,
0xc8e32572,0xfc422e7e,0xde50e24f,0xe69b3e21,0xda88fc14,0xf4dc0526,0xfae3f950,0xccb73512,
0x0ac62f7f,0xf90df1b0,0xd08e325b,0xec30046c,0x1e5ef8d0,0xeda4e2b5,0xfda33aba,0x01aae623,
0xfd062a85,0x0a77e0f2,0xcd0918f0,0xfc32002b,0xf959ee55,0xf26b366f,0x19e9fa76,0x203cec48,
0x0a6dceef,0xded309b8,0xf60f100b,0xdba131eb,0xd2480f42,0xe1964398,0xc1132021,0xe14b3e96,
0x1cb2f1b4,0xf79001f5,0x2db1cf98,0xd166daf9,0xc9e234bf,0xacbf5a7e,0xfd214917,0x0daeda44,
0xf6a730bc,0xe04d0b25,0xe569304c,0x1d94f544,0x3333cf75,0x4989ac6b,0x0706cacf,0x281bf849,
0x439ecfb9,0x2825bf15,0xee80ed3b,0x0079198c,0xf824ea58,0x0f47f0cb,0x059ce6c0,0x0dcf0276,
0x21c0f2da,0xed682159,0x0bdf0ede,0x175ce2a0,0xf8efef52,0xe3ed043b,0xf6c81243,0xf3a00849,
0xf654ef46,0xa7243871,0xca705783,0x0aa60115,0x1289ecd7,0x1dec052b,0x35fcdf1a,0x0889e790,
0xca36113a,0xeb40266d,0x41a6f2c8,0x2879a1be,0xcf10f7c7,0xfe723e5c,0x0ce2dde7,0xf4500422,
0xecb20547,0xf5d029b8,0x0908e053,0xcb222590,0x01221c22,0x085af6dd,0xfca90ab6,0x043fe19e,
0x175e15a1,0x59f7c911,0x5aa8a04e,0x143dd5f3,0x162d0dfd,0xfaf2c17a,0xc9372c83,0xefd0fab8,
0xe1fc14e7,0x038f0a1e,0x0e3ae807,0xdaf93559,0xd45d13b9,0xe0b43e64,0xf3c026f7,0xe6a425ad,
0xe927eedf,0xcf641d6c,0xcfa81aeb,0xf2f14003,0x3601f05a,0x1bcbc09f,0xee390fb5,0xf6601100,
0xfb3300d3,0xe499f53b,0x02da137c,0xf9f9f3a1,0xb81b24fb,0xe2b45959,0x146efd31,0xfd8cf37a,
0xcdc20296,0xfac03588,0x4eb9d332,0x0facdadc,0xfdeafa7f,0x06481d01,0x1751eadf,0xcb7fe957,
0x0e98fc69,0xd92802a1,0xebae1f4d,0xb2093828,0x1da7322c,0x5688be1c,0xf86ae512,0xc9051fb1,
0xe2573fe3,0x0fadee2e,0xb19a1d27,0x4f8af2ae,0x35d6bbc5,0x1de0c337,0xd4e81a93,0xf20633da,
0xf92b1351,0x3231e18f,0x1b98c50b,0xce082645,0x14f3fe2b,0xbbbf1ec4,0xee171ccc,0xd92f3f76,
0x3f21e8c9,0xfc24cb4a,0xb40b1e0b,0xa09e544f,0xe1053be6,0x11da077f,0xc91126c9,0x18dd1727,
0x02dce2f7,0x1894063d,0x1cf2d77b,0xdbfd0388,0xc3f5471e,0xb61e21b8,0x0059200f,0xfaee00e4,
0xf7ebf4a9,0xe2c6325f,0x326ef585,0x0f7fe860,0x2d4af420,0x1251e9d0,0x1a74dffb,0x18b0e723,
0xfd7adc5d,0x3302c97a,0xd07a085f,0xbd6e25a8,0x0de019fa,0x4ee8c719,0x1138f025,0x4266eb01,
0x1d98f490,0x0c83e4c8,0xfd2a118d,0x0cdd0ab1,0xefd8d271,0xa119361b,0xe520131f,0x1da3ebb1,
0xdf15ea48,0xe88b389b,0x1868fb5f,0x0a1a2cdb,0xed14f623,0xc50a4209,0xfdc93762,0x1e21c5fa,
0xf1dde77a,0xe268f519,0x21ce1c01,0x6054b1f3,0x5836a29d,0xe77bd4c7,0xf84d38e4,0xef820e8f,
0x011006eb,0x4042dd3f,0x108fddbe,0xe4fe099d,0x9f242da3,0xe5755cba,0x0ee9e430,0x23a7e1d0,
0xce5fdfee,0x39ce2489,0x70889783,0x19b1c518,0xbedd2257,0xf3d9377a,0xfe7404ab,0xce031969,
0x04152d6b,0x37e6cd87,0x3bdcc424,0xd4cfed4d,0xec2b4d2e,0xe97ff1b9,0x0eb5fc6f,0xde92ea5e,
0xdd131f95,0xedee1712,0xd60f296a,0x545b1063,0x1fa8bc4d,0x2edd06ae,0x2072ce2d,0x12100aa7,
0xf449da50,0xd14eed93,0xba97543b,0x3182c704,0x02e8d517,0x02ebedbd,0x330013cb,0x1be5e0de,
0x1da71946,0x13f6ec9f,0x1c1404ef,0xd53013f5,0xfba0fd77,0x17310e48,0xee3fdcb5,0xe9d41062,
0xedc6edb5,0x30f303e4,0x16b4a375,0x11fffade,0xe7a4e2d1,0x5790ec20,0xf1c3f23b,0x1e8cff5e,
0xd5fc2726,0x1c061360,0x142beff8,0xef07ea89,0x2e5102da,0x36c4ab0b,0x4e03cf62,0xcd3deeb4,
0x3efc1e70,0x0eb8cabe,0x1c7fece3,0xa1650aa5,0x25f0020b,0xe04c0554,0xbd621e7f,0x27e835b6,
0x0c73e395,0xe812fe4c,0xa46b24e8,0xadf46a57,0xbe2042fa,0xf26c2cbb,0xbfd937d7,0x3e06eb3e,
0x024e21ea,0x0234e531,0x4c51eb14,0x42309893,0xb35ee850,0x8dfa7207,0xe31f6982,0x0f6dec20,
0x0e750d2f,0xf6f90efd,0x18debff1,0x40991a0e,0x3259aa41,0x35d9dab4,0x1d32ba0e,0xea3a0adb,
0xf8b41028,0x3e68d806,0xdfa6eeea,0x1057f823,0xf8f01799,0x0446c3b1,0xf44125d7,0xd3d717a6,
0xfb813ca4,0xf36bf8a3,0xe32c3a13,0xd97630fc,0xfde700a0,0xdf12fcdc,0xec651090,0xdd002c9b,
0xd86302f9,0xe8722443,0xd75b1e37,0x14cc1382,0xa6f7fdbd,0x05ce413a,0x03cc051b,0x1b9509e5,
0x157ee5ac,0xe72a0bce,0xdf931e15,0x17fae9df,0x2290ef98,0xe68edfb0,0xef6659f0,0xef20f2e3,
0x08afecc8,0x943c2933,0xd99b4c2f,0x393bf2d1,0x5547baf4,0x2cb2ca27,0x1d0bbeaa,0x09881259,
0xecc4f271,0x17dc18b0,0x1690c765,0x9d69331c,0xb4366b50,0xb12d351b,0xb3305a01,0xc5b83121,
0xe7593e2c,0x51fdaf66,0x143a0186,0x3494b828,0x03ccf965,0xf6100a4c,0x20eb1704,0x2538d060,
0x4b8aba5e,0xcd19e6f6,0x08991287,0xbcce1f46,0x127d05d7,0x255efccf,0xf98adbf0,0x19db17d9,
0xd93bcb72,0xd11a59bc,0x1314f458,0x4d75c18c,0xccece24c,0xe43e60ee,0xed321a56,0x3307dae6,
0xf98c096c,0xe421fa1b,0x06582c98,0xf685c67d,0x10292a62,0xe4bbeb39,0x08511be7,0x210ad763,
0x3f38cf9c,0x24a0d04b,0x2302b611,0xd3d6079d,0x0e0f00b5,0xf6b73e68,0x3618c5a5,0xf68bf3d7,
0xe69b2d03,0x303ceeb6,0x3fb8b510,0x1d23bd06,0xe59c1ac9,0x69e3b0ab,0xe53bdf9b,0xf40c2ace,
0xe870352b,0x04a4027f,0xcc9d1c76,0xc1131d32,0xf1d1270a,0xc69309e7,0x081327b1,0x01c0f56a,
0xd77e096c,0xcd5a4bda,0xca1815aa,0xbc3b7207,0x2cb7d5e4,0x2004080c,0x241ebc2b,0x1257f041,
0xc6cf16a7,0xdf8026e4,0xde3f07dc,0x34bbe48d,0xb4900acc,0xf574422a,0x04882810,0x1b16c061,
0x0a02321c,0x0315caf6,0x1ec60b44,0x1739ceca,0x3b76db3a,0x3814ac67,0x1f64cb36,0xdf0018bc,
0x2700dc3c,0xe2b31909,0xf5e6eb9d,0xfd1647f6,0x1d3cd3de,0x346f0573,0x0197b8cf,0x02e0245b,
0xda5e0999,0x0ed101a4,0xbe99fa14,0xf11d203b,0x1cc7fee9,0x434daee0,0xe2de1169,0xd5851759,
0xfba334cc,0xe497d5fd,0x2594293b,0x1eb1dd1d,0x2455e608,0xe200ed95,0xdeca40ce,0x10fc075b,
0x1100cc01,0xe9f92539,0xc906eeff,0x27b6222b,0xf0cdbd50,0x2dbc1487,0xc6be0fdd,0xea084adb,
0xc796fedd,0xf72c4d07,0x14941237,0x2c36bade,0x21fcf298,0xc048f43f,0x45fe0ffa,0xe225c380,
0x02291602,0xef7af7cf,0xda982652,0x8dfa51aa,0xbf867207,0xf33d3c45,0x396ec4ef,0x09690016,
0x0c7df09a,0x3064d529,0x062def01,0x1083d214,0xf317fe3b,0x6c74c522,0xd082ea24,0x0492124b,
0xddd62341,0xcfa34554,0xa65c2d05,0x8dfa7207,0x1fd83e34,0xf880d5a1,0x0288197f,0xfac1e4c8,
0x00d6f33e,0xd79834ba,0x2d84caf6,0x2d32ee1a,0x41b6b3a9,0xf36bfd57,0xfc6b176f,0x3fd0e6cc,
0xfebadc22,0x2744ecbe,0xc6fb188f,0x1f61ea99,0xb4d231ad,0xcbc12694,0x4159f868,0x1810c095,
0x3dc0f9de,0x31099826,0x319be918,0x05f4e887,0x18a9dada,0xfd673464,0x10f7df8a,0xcea73159,
0xcc6321c6,0xf89c441d,0x2b27b19c,0x0bcb09b9,0xe929bcdb,0x218e147a,0xe0b7feff,0xe1201e3c,
0xe6e91f83,0x0103ea3f,0x34d1ef13,0xfaefe3de,0xc4cc64c7,0xe59c1502,0xce5d417c,0xd6892251,
0x4a9be95d,0x0206c007,0x8dfa36c0,0x93077207,0xd11168d9,0xf1c40b1a,0xe8f9ff0d,0x2e911c36,
0x371da039,0x4bbdd763,0x4490a43d,0xc4d51273,0xb44c471b,0xc08b4ed3,0xf8fd0081,0xf2501901,
0x0105f920,0x0e0cfd9d,0x121901cb,0x1851e8b8,0x3177d821,0x0dddd4b2,0xdbad2a2c,0xc7f507c4,
0xcab546bc,0xf86b0ca2,0x0dc11aa5,0x322ec9a2,0xcb490d70,0x093a1fbb,0xe8c6f56e,0xe6eb4845,
0x2d16c40a,0x37c5004c,0x67f88dfa,0x26c5be17,0xf715e372,0xec07158f,0xeb021313,0x21650d14,
0x294bc9fb,0x2207d01c,0xad3a291d,0x8dfa5519,0xe9305f38,0xf5f9f672,0xe0d53183,0xee1cfae7,
0x108d11a3,0xe4d4f37a,0xf36931f4,0xc40f180d,0x1da20dd6,0xfe4fe6a5,0xd2181bae,0x3abd0b4c,
0xf3b2d4a1,0x1d571076,0xf022cd9d,0x45c113d7,0x26bfa63a,0x287aeecc,0xf936de6f,0xf18e0f59,
0xc90939b3,0x003c0173,0x2e1c0734,0x0dfca9ae,0xb142431c,0xcf632eb0,0x47d905a2,0x0f02d028,
0x071aee66,0xbcb11bd0,0xef841a8c,0xb453315c,0xf9e83045,0x02b9260d,0x1f57f0a1,0x2e6fe764,
0xffcdd3aa,0x1d89f7ce,0xed2cfa56,0x43d0cab5,0xd9b8e690,0x3f49fbe5,0xd7fbeefd,0x18560e94,
0xaa472410,0xf43b33fc,0x0d72f462,0xe13b2153,0x48b5f9cd,0xa351f836,0x0f8e40e6,0xd4e6ed1f,
0x18360e25,0xd2f8f6e5,0xbc862c5c,0x8ff07207,0xb2315023,0xad497207,0x2627f989,0x0cd0ec0d,
0xed7bf3c1,0x46a7e847,0x0dcbdd77,0x1de9d542,0xac9e3661,0x3efc0a5c,0xf90def07,0x30aae08d,
0xe7f3f051,0xd4eb02e9,0x1fb72047,0xe387cf91,0xc7fd41c9,0x00e61904,0x4115e4a4,0x089be8a7,
0xdf5402aa,0xa3607207,0x13380dd3,0xdb8926d6,0xf9f4fce1,0x1cddeb81,0xe9ecf910,0xfb37f5c1,
0xe6aa16be,0x304aea74,0xe57c0437,0x3339d81a,0xd62018e0,0xeb2d0ef1,0x045f1eae,0xd3f30ca1,
0x04202419,0xcf430804,0xebc022dd,0xcf4c16fb,0x4de5faae,0x19e7c6dd,0xe8e6fabb,0xef9f0f8b,
0xd06d1b38,0x214508ab,0xe093e40f,0xcd5d5dc9,0xab3d30b6,0xe8ef54cf,0xd0d313ce,0xe2e123c9,
0xf1e92478,0xd345f292,0x136323f1,0xf90ccf7e,0x1870205a,0x17deccd5,0x27b0028c,0x11d0bd23,
0xf8baf507,0xf929231b,0xc1591282,0x98967207,0xe65141d3,0x088707be,0xe888e27d,0xe6403e63,
0x1a14d1e0,0x1c6aebee,0x1487e692,0x43add172,0x6783b7af,0x3c9b9312,0xe3ef08a3,0x0b49f823,
0xe2751b09,0xf5e70859,0xd2a21ef2,0x8dfa7207,0xfbfb4177,0xbbcc0a97,0xedd74b36,0xfec3efb0,
0x32d10071,0x2843aaea,0xd2f6132d,0x49e1f115,0xe475c7e4,0xfd72248f,0x09eaf6cb,0xf9b8f566,
0x03b20e31,0x13a6fa7f,0xf6d800fb,0x1a95fdb5,0x2fecde97,0xfe61d9ae,0x181df45f,0xcb9d0ee6,
0x4987f43a,0xb82bec66,0x1d6d3164,0x03eddee7,0xf2620f59,0xe8842154,0xf3e5fa31,0xfa5a1630,
0xbbbd0806,0xf240454a,0x2b68c0c8,0xe98e02a5,0xf1551e4c,0x16a40544,0xdb090ce6,0x1b6f0eb5,
0x2294ee09,0x3968b98f,0xf014ec3e,0xf3720a25,0xf8550cf7,0x0b38edf2,0x48efee2b,0x1971b4fc,
0x392fee86,0xe6bee31e,0xf22b037e,0xe29427cd,0x2338fa70,0xe67df2be,0xfe601fd9,0x0a6cf6a4,
0x0ccdec2f,0x0504094e,0xd0af1a15,0x2ecb03d1,0xf9c8d7be,0x40cbdf6e,0x1583bf07,0x00be0e88,
0x01ecea59,0xca0413b9,0xf09c41ba,0x011fe5a1,0x3e0cf087,0xde3ef645,0x2b03fb28,0xea680313,
0x222902c0,0xd6bdfdc4,0xf2d81160,0xe3fe1d20,0xf17e013c,0x0fc413f5,0xffc8dc2b,0x195d00e3,
0xf0abea14,0x386df119,0x0c72c861,0x0f45f888,0xa7b23d9b,0xefe23317,0x08af2c11,0x41c4c24e,
0xf5b7de6e,0xc4b32508,0xdacf201a,0xefc92009,0x52f2d3cf,0x392bb1d0,0x5c19b45f,0xee4ee7ec,
0xf4531130,0xe9691bc4,0xe5bb1186,0xd7ee0da6,0xd76046a9,0xfa3f11a5,0xee6f1cc2,0x0e79ec57,
0xe268160a,0x493fd255,0x35edc6a6,0x3b49a833,0xf1a8feac,0xf694132e,0x0954fb75,0xeabf20d3,
0x3068e378,0xf5c1f3a5,0xc976079f,0xd9b1551f,0x45bfcf76,0x398bd230,0x2df2aba3,0xfb331c6c,
0x2de9d069,0x443be450,0x34b6a61e,0xc54b165a,0xcca94b91,0x0429ec47,0xe35109ee,0xf852ffc1,
0xda303601,0x2191dc8d,0x02c91405,0x191bc44a,0xccbc35b4,0xe3ed2a45,0xd4912972,0x1e2d1fa3,
0xfd32e06b,0xe72c0bbf,0xb9411772,0xd05c5f20,0x0288d6ce,0x0412107f,0x0e9edd24,0xeab9378e,
0xf635019e,0xeec51dc2,0x0740fdc4,0xcd411fc4,0xc9714283,0xf4dc04eb,0x103e20b5,0x08b0bf4a,
0xe9d92bd2,0xf364e5d9,0x0b8e3730,0x3e53aaae,0x13b4eb9a,0x1608d338,0xd39317c9,0x1956188b,
0x15c8cfa7,0xf5e71a84,0xeff40a82,0x08cf0b8b,0x252dde2d,0x11c3ea4d,0xab910dd9,0xed564947,
0x0f6cf045,0x1f7ffdef,0x0dbdd630,0xd85a134b,0x1a8410e7,0xfae3c0be,0x238919af,0xf39cc28a,
0xef1c3b2a,0xeee20475,0x23d10f88,0x2998cde0,0xfba1f76d,0xddef1e1e,0xfb241103,0xf5b00a53,
0xfaefebbf,0xf0122676,0xed3feb40,0x44d30b9e,0x52928dfa,0x2c6acc1d,0xdd96f1cc,0x3d610670,
0xd7b5eec9,0x176e11f3,0xbc7d3379,0x1f31f659,0xb7fc2c84,0xf18323ab,0x2d1af05a,0xeee1c8c3,
0x0fac22d0,0x0268ca27,0x4bb7f5c1,0xdf23d8c8,0x375d217c,0xcc29f571,0x14a21610,0xfee8ef31,
0xfac8fd8c,0xe2910d22,0xf0791a4a,0x334be3db,0x1a47b492,0x44eeed75,0x001fd810,0x3131df6d,
0xcc471cb2,0x0d23092f,0xe91a12d7,0xf6d10d3a,0x13bf174d,0x403ab191,0xfdbaef75,0xda99123c,
0x319dfaec,0xdf8f00d3,0x45e9d78c,0xef33d7a0,0xfb71eca8,0xa4f0545f,0x19801ce6,0xdbbf147d,
0xdac4394e,0xde3a1570,0x98744e53,0x0dde1c06,0xb5a42acd,0x3846eb83,0xda2afa1b,0x2998ef68,
0xf72c1a03,0xe4a7f1bc,0xcfe74f39,0xd9f3083b,0xd8fc3b83,0xd27b26a6,0x10870a1d,0x0b8af60f,
0x1ec3cde6,0xf56d27a6,0x65f7a631,0xd594057d,0x26badf7a,0xef8c045f,0xf9be0c55,0xfd7a0d0f,
0xe62d06ed,0x194f0065,0x16b6f94f,0x1fadb740,0xe6811df2,0xfb17ed86,0x079b2db4,0x0c57c33c,
0x10f0397f,0x137dc379,0xde8d166b,0xe8c81a5c,0xeecd0405,0x39f5ff68,0x2b769865,0xdd2926d5,
0xf040e142,0x01f24868,0x125fbd51,0xf9062c35,0xe4f9ecb6,0xf1bd4684,0x1e2de76b,0xe8fe0332,
0xf45e2f2e,0xe452e890,0xf9964881,0x02e5aabe,0x16741420,0x226dae84,0xfb091115,0xe478ee89,
0xe393435b,0xe7bd0e20,0xee082c5f,0xb4245d63,0xd6062564,0x138f27cb,0xefc0cf1b,0x0346100e,
0xfe2ce256,0x14010f3a,0xe3e4cb73,0xf9ed4334,0xc7c7f709,0xf90b36d2,0x29e5fe11,0xf1b5d522,
0x12b817aa,0xc2551233,0xdc5f563c,0x160cee0b,0x5deae745,0x010795b6,0xe15d388b,0xd9960ad4,
0xda571f93,0xd19e1d71,0x8dfa463c,0x3aab3174,0x0cb1c24a,0x28cd051c,0xff44cada,0x00fa2d32,
0xf1590cb3,0xfb651f2c,0x4159d34f,0x0a8bbb54,0xd1d32756,0xec6c0fbc,0xf5ff0840,0xfb4403f8,
0x3b91e8de,0x9d700246,0xec26667c,0xe3fc0e58,0xedf41782,0xd37b1a5c,0x0f871040,0x207ddb98,
0xf150f8fb,0xfb60021b,0xba331945,0xe74d3df0,0xdf352a98,0x4706f9a6,0xe874e203,0x12d81929,
0xf497d8a8,0x0b3a1848,0xd9c7f5da,0xfde02524,0x2d16beed,0xf97aeb54,0x112a07e3,0xd3aa202a,
0xdc7832fb,0x029efc5b,0xfa7510a5,0xf104ecef,0x0f0f165a,0x0844fc6f,0xeea40f78,0x1f83e216,
0x2e2cedfd,0x308cb13d,0x04e0fc28,0x16b1da57,0xed83f950,0x20c90384,0x0558f8f5,0x1baf080c,
0xfb85e91a,0xf06e1420,0xe9c7e7fd,0x038a3b94,0x3a13ac03,0x1972d678,0x03f8e777,0xd9dd236d,
0x1c0afe37,0xf0091bab,0x3331f007,0x2e5aba39,0x3349ed63,0xf65cc3d2,0xf23f2a99,0xcfcd14b1,
0xe1ae2553,0x149afcf0,0x2c73e4db,0x1f9ccb11,0x1325efd6,0xe0200359,0xd6ea1db9,0x29fb1ba3,
0xfc1dd5b0,0x286bec67,0xa42a0329,0xd0c96d46,0xcec919d4,0x257f1bac,0x18fad897,0xdf542215,
0x2479fa4e,0x1835d334,0xfad303c4,0xc2bf0891,0xdfa4347d,0xff97f102,0x06c3137d,0x0ca5ed09,
0xc8e90cd3,0xb1624e9e,0xcd8940f9,0x075d1a8f,0x2e6eeeee,0xf6bff208,0xe6e91d87,0xfa900762,
0x0a0b18a9,0x3209bae4,0xe9b10db8,0xffc3deae,0x176fe558,0x1b2fd5b8,0xc88e16ed,0xf42f37a6,
0x20ea0124,0x0cee086f,0x4a2ad6b0,0xe0d2ed25,0xf4d719a8,0xc8731b56,0xc9861c3d,0xf72e228f,
0x0c71df38,0xe9ca0dd5,0xcad90aef,0xe2124de9,0xfae60a0d,0xf8bd1475,0xfc7a0c84,0x1c63f3d2,
0x121d0ad1,0xfac4d471,0x9fbf5595,0xd0bf2d69,0xebc32aa0,0xebf0f1cc,0xf9d2199b,0x080fed85,
0xe1fc072a,0x00471f6a,0x3c2fdefa,0x5e2fc7fc,0x38be9129,0xe6402059,0xf90b066c,0xfc211c04,
0x0a24eaae,0x4344eb81,0x37a5a75b,0x2510b2d6,0xcfb8159f,0xfc990129,0x025d25b5,0x1a72ea8f,
0xe62c0c55,0x0474020b,0x21a2fe47,0xf21de1d0,0x3291032c,0xfb5bc640,0x072c0581,0xea930569,
0x01ab0cb3,0x09bb0eb8,0xcf23feb1,0xecd14a75,0x393ec4d6,0x12bb013a,0x0e53cdf6,0xdc4826bf,
0xbbda29b7,0x0b9f1148,0x2d7de723,0x19efcc66,0xcfc9ff55,0xfc6e0f9a,0xf36900a1,0x04a208d1,
0x27a917a4,0x32fed410,0x43f1d1ba,0xbc9af954,0x940d5d50,0xa2a8711a,0xd7212f8a,0xe281ffe3,
0x0e0d0b74,0x36afe39a,0x48bbaf91,0x51e0dc49,0xf044c643,0x2bc51277,0xe229e611,0xcbae274f,
0xf02a256b,0xede7faf6,0xbc3e2d41,0xef502145,0x15ff1567,0x3c2fc21c,0x1da3f7d0,0xf9c5eb6f,
0x07a515ac,0xeb37ead5,0xf922027d,0x8dfa40ca,0xd96e6135,0xd13725e8,0xf81d212a,0xefea1356,
0x374eeb9f,0x6244c35c,0xf9ccaeb2,0xdf3a32be,0xb90c1fd0,0xeec43dbc,0xcee11105,0x07c41d28,
0xf3f0f368,0xe9b61731,0x0557fb6a,0xe79cf88a,0xcc494a5b,0xde940f07,0x3a131005,0x0eedc266,
0x0b410d2c,0xecc9022d,0xca7a3862,0x05d32614,0x14d5df41,0x1b4fe4d7,0x1224ca43,0xf5ec2836,
0x0582cfcf,0x2349f13f,0x04cde390,0xec01fc36,0xc7554853,0x1fbf0b2f,0xf6dcf170,0x0b2a0637,
0xf5c9037f,0x2ca9f6ab,0x1a12ddd4,0xc86f0328,0xf17c2679,0xc4a123b0,0xff151e69,0xed67fdc7,
0x19f9097b,0xfdd2c8bd,0xea6b2819,0x21ed0588,0x1c74d0b3,0x37bbe7c6,0xe847ec7f,0x16e90239,
0x14ede2d1,0x162ef2ee,0xfee6ef46,0x1c22f339,0x381ac0c1,0x0210e3c6,0xedf11c9b,0xf39104f8,
0x17570916,0xd7a414cf,0x1144fa44,0x2403dee8,0x00b3ee09,0xc228268b,0xe86f26c6,0x0dc0f8d8,
0x0130efc9,0xe66c2feb,0xfc29fdcb,0x105cf504,0xceb50874,0xeea134ff,0x1aaf0328,0x416ecc78,
0x0b21d3ee,0x036df334,0xf8e6070e,0x080ceee1,0xbde81fa3,0xe06f3288,0xf8d60335,0xe2272111,
0xf4310fa7,0xd1af2904,0x482dfffe,0x3c49af0a,0x26eec988,0xd74ffc73,0x0f7c1a5d,0xf51304b6,
0xa3cb3344,0xd22d4aaa,0x11c81528,0x29b4b462,0xb95f0c14,0xf1a237ae,0x07f611dc,0x2b7fd26f,
0xed7cec3f,0x2595f9a2,0xfa2b0741,0x059df654,0xdf7009fc,0xef652636,0x0d2f10ad,0xe40707b0,
0xe06b2049,0xf36013e7,0x5c41bb18,0x0258b5f2,0xef401b0a,0xf00a0d6b,0x33bae4bf,0x1aa1ead4,
0xfa28f500,0xdd483581,0x0cc50d56,0xfe45eb95,0x0d050312,0x0ba5e0d6,0x013bf562,0x05dbe406,
0xbb902cd0,0x05281622,0xd1b71144,0xd47831f2,0xd9e9347f,0x306612f0,0xff15d938,0x0f9209c2,
0x37a3d437,0x33b7cd4b,0x1aacbb69,0xcb6f272b,0xdedb16dd,0xe11c1b05,0x0c79071c,0x13d1f408,
0x06ebfa5b,0xf99d001f,0x274dead3,0x5366c9e3,0x280fcce4,0xf2b7e47b,0xccbd2946,0xdd4f1dc9,
0x077009a8,0xf13af965,0x299006dd,0x1bb1c975,0x0d70fef1,0xfe55ef60,0xf43625de,0x16180420,
0xdb08f2b7,0x115b1dbc,0x0bc4cdca,0x117500ad,0x13ebb289,0xe5d019a7,0xf780080c,0x01f61a0b,
0x0920fd68,0x1684f0df,0x1879ffe4,0xcd8202c3,0xf5932f35,0x1129eccc,0x1678f351,0xffd2e9da,
0x0f850e1e,0x042fde04,0xfedeff8a,0xa9540855,0xdb224a0b,0xd91931c8,0x0b691561,0x1c38ef31,
0x09a4ef43,0x1405fd58,0xde38fe0f,0x36dd0b5f,0xccafd065,0xc0035aab,0xc03a1f5c,0xfca43cd1,
0x003be376,0xea0b06b3,0xc3b738e6,0x13f01c83,0x5569d14d,0x1830b495,0x197d0824,0xfed4d959,
0x108c106a,0xbfff00cf,0xefb84858,0xc5a112bc,0xe8d82949,0xe9291ba1,0xf9410925,0x0b23ea26,
0xf9affb53,0xff571312,0xe91bf65b,0x1eb718f2,0xd482e585,0x00452f86,0xf04902da,0x14b6ff59,
0x169de485,0x130df948,0x15c4f0d9,0x18dde8b0,0xf6d20412,0xe5c30032,0xe8f236e3,0xf6aaf754,
0x14caf18d,0xe4b3fa10,0xd52a102a,0xeadc2a7f,0x6166cf8c,0x0308d248,0x468cf3da,0x42a5ca75,
0xff45d6d7,0xfa141471,0xef62ffac,0x3ae3efc1,0xf7ccda74,0x3cf2e34d,0x0452b713,0x20b6f98d,
0xeb300103,0xfb920ccc,0x04fe1849,0x4d81d46e,0x3661ba98,0xf7e6f365,0x039c14ba,0xe5460ad6,
0x1a98f724,0xf14fd71e,0x05b40d85,0xcf380162,0xd46e273b,0x296b1fd0,0x3d3bb56e,0x1652eda5,
0xfc04f78c,0xff8510c2,0x190bf099,0x230ce120,0x0d66efaa,0x3085d782,0xecd1f4cf,0x042ae8a2,
0xd86126a9,0x7207d1c2,0x6d448dfa,0x40caabc8,0x4483c9cb,0x1a12e082,0x28a2d49d,0xd966fbaa,
0x099e1046,0xc76c1061,0xff1118c2,0x114001c7,0x6ecebbe7,0x324faeb8,0xf61be6ae,0x17dc019e,
0x0659ed14,0x2fb4e45d,0xcceada6b,0xb7ce6dca,0xc987460f,0x30e4f167,0xfdb1fc71,0x0e8afb02,
0x001e16ed,0x1ed0c1ae,0xedd8f83c,0xf0121307,0xbc2831a8,0xfe090bf1,0xf7980587,0xc24c2767,
0xef6e1c86,0x8dfa4990,0xb0b37207,0xd3e6403d,0x2cb30a5a,0x6ab2b123,0x311fb8e3,0xfee3f1fb,
0xf34bfbe9,0xfde91357,0xe68af08a,0x8dfa4ee0,0x8dfa7207,0xcb8b6220,0x08f01608,0x12f9ed35,
0x1ac3f4c0,0x6604c4a4,0x5070a238,0x1311dad1,0x08c6fdac,0xc34c14f7,0xb2965bcb,0xddef2b05,
0xf15902c4,0x184cf3f8,0xe38bf3fa,0x01111f96,0x5e7fc385,0x4a8dbcaa,0x3b85c1d6,0x0889e1be,
0x0c68073d,0x136ee1e2,0xe0440194,0xd1b725d1,0xfca515a5,0xfd2aff7d,0x0ae9f5e1,0x0979fd15,
0x10f9f104,0x063eeae4,0x2647e824,0x01f9f42f,0xfa2c0915,0xff14f8a3,0xbaf9278e,0xee743b16,
0x027ff45b,0x2facf2f0,0x3c4eb465,0x0551e845,0x19d9fb4d,0x194fe8c5,0x0d3aefc0,0xe8a305e2,
0xf3291bf3,0x0a55f32c,0xf9fc01fe,0xffa1e1c0,0xf7ed139b,0x290ede96,0x1da7dfa7,0x1e46f1b3,
0x078bf46f,0xffa3053b,0xfa220375,0x2a2af119,0x5032ae77,0x08bec687,0xd9361ee7,0xe9272312,
0x0c8dfdf9,0xe2340a7e,0xe70428b3,0x01e213b8,0x3a50d462,0x1924ccb0,0x018efdf1,0xe754f5c4,
0x02311984,0xf214020f,0xed3c0b41,0x2147faa0,0xf7b1f54e,0xec871814,0xeedf0c0b,0x00940920,
0xf6dbfe91,0x0d8a0400,0x0103e744,0xf7d413f8,0xc01f31ab,0xe36c2e5f,0x0ccb0f11,0xf765f68c,
0xedd20727,0xf31ef3b6,0x02f411d0,0x1b3ae8da,0x1c8fed10,0x1f71dd47,0x1728e43a,0xe8bc10aa,
0xe6690ca7,0xd1793482,0x19dffd24,0xfe17fd40,0xf81bfae0,0x0e5f0976,0xf59af2e9,0x0e7903ff,
0x0a89d9d7,0x36abeb21,0x3546c715,0x1fa1d52a,0x0ae0fb11,0x297de178,0x0bb9f5fe,0x1a83de57,
0x35fedfbd,0x353dc184,0x1ef2eeb4,0x46b8b3fb,0x5049a063,0xee69e51a,0x011e0683,0xf724029b,
0xf99002b5,0xf6761c04,0x059df19a,0x05eb0461,0x28b3f463,0x03fff5ce,0x111fde87,0x1eaef11c,
0x07b7ebb1,0x12fcf30c,0x063de8b8,0xf5d2f61a,0xab93468a,0xecaa39e0,0xfcb80d85,0x0449f715,
0xceb11646,0x29a800da,0x6534a005,0x48049fbb,0xf61bebda,0x06b70fa7,0x58a7c45e,0x0b45dc58,
0x2644ecde,0xf88aef1d,0x0e2e0372,0xf658f2f0,0xd5012541,0xdd042d89,0xfd31056a,0xff2a1035,
0xf387f0c6,0x27cee65f,0x2d3fd491,0x2918cf2a,0x1828ee68,0x27d9eb9b,0xfdfce64e,0x13e6fcc5,
0x2726e2e9,0x12d8c6b1,0xebe31559,0x3265f3bc,0x6188a342,0x1b9dd1cf,0xe9430840,0xe5b2032a,
0xd4ee2b54,0xad923458,0xd1393fdb,0xd1cc40e0,0xd6cc3505,0x07dc231e,0x2752d7e4,0x02bdea03,
0x00cd04c9,0x23c0d401,0x42fcbbd0,0x61a6a81c,0x052ebaf5,0xf8360ebe,0xea3816f9,0xdcdb2eed,
0xeb0d1f5e,0x029b14f7,0xeb5d15a3,0xdfb61c48,0xf004193b,0x158fef6f,0xf7efef66,0xf4ab019f,
0xed8e0290,0xd9e60dec,0xed412bcb,0x1323f6e0,0x24d2eeeb,0x347ddb0e,0x1f5ed837,0x14cafcf1,
0xf5e7f469,0x928637d1,0xed6348c5,0x0861fc04,0x1e29de00,0x01a8ef1d,0xe7f006eb,0xfc7211ab,
0x0b80f273,0x16b7f49f,0x2134f7e1,0x536ec7c6,0x15fdbce2,0x158fe86e,0xe81d13bc,0xfab3fd68,
0xef0f0cf4,0xfb241465,0x2c85e5aa,0x1bd0cdf5,0x3bbee32f,0x1c16d2ad,0x4cd5c6f3,0x2552b88d,
0xfa8af68f,0xe6d92712,0xfc1dfbf6,0x00b918fc,0x2f6acf86,0x22dcd64f,0x2b8dd87c,0xf7aef914,
0xf2fd1759,0x1bb5f270,0xe751ff28,0xda3214fd,0xe91c290a,0xfd60e57e,0xbd5f27ff,0xf3aa1b3c,
0x0e5610e7,0xfb63fef9,0xf42e2554,0x32c7f0c6,0x28f0db0b,0xfa55fb23,0x14fddf45,0x21b8e867,
0x40dfa660,0x1658e24c,0x3a8dc3c1,0x2de1d068,0x1debd6c5,0xfc92ff4d,0xda0f1f17,0x262c0ffa,
0x0b16edb1,0x02bbf388,0xe42f1e14,0xefee057c,0x041d03c5,0xfe84ee04,0xfa9c07e3,0x0b66dcb1,
0xf7c7116e,0xc10211db,0xbcae5b80,0x01cf25d0,0x0096f72d,0xe1d32df7,0x09affc7c,0x102efa90,
0x0370f01f,0xfa6cfe1c,0x1392d853,0xcf4b2261,0xb7d33db8,0xf43733e5,0x18e9eda8,0xddf9182d,
0x0d9510df,0x0e46e601,0x1b70e62b,0xdca2f24e,0xf61c1d3d,0x0d3ae473,0xe27517a4,0x0eb5157f,
0xeb2304fd,0xdf1e2081,0xdc762d5b,0x00fd197b,0xc5991809,0xf58922c8,0x1674eb7b,0x279ee34c,
0x124de399,0x040ff210,0x474bd3db,0x2866b24f,0x2092e318,0x1736e410,0xf0cd138d,0xf5c01b61,
0x2d53ddb8,0x215bdf68,0x2e3cc466,0xdfd3fe1f,0xf22818ae,0xf63d0a4e,0xc68135e0,0xf48e1c85,
0xe4cc0ab2,0xeca92310,0xd48d1566,0x16abff51,0xfc0cf9b0,0x03da0edd,0x1aa7edc6,0x06a3e2ee,
0x12510694,0x11d8f3eb,0x247bcdcb,0xe525fc26,0x178508f1,0x052ae5f9,0xfecb04fc,0xdea41412,
0xf9cd1911,0x0460f54b,0xd92113ac,0x22f3f962,0x05a6f057,0x1b7bf41e,0x041de98f,0x18f0f9eb,
0x0316f9db,0x2ee0f721,0x2260c6fb,0x31bdd618,0x0472e8d3,0xdc9a0ab8,0x02c0149a,0x05d8f24e,
0xff67f24f,0x1320ebc3,0x3b7ad769,0x0457e1fa,0xf92b0949,0xcf21298c,0x02461d4b,0xe38e2377,
0x11f50eaa,0x208dcf8d,0x1cc7e754,0x392fce01,0x42f2a98c,0x3699b617,0x0bdce760,0x0658eb26,
0xec1a0e1a,0x0d2b0674,0xe5bb1176,0x26300364,0x0468e542,0x1411136b,0x13f5dfad,0xfdb2042f,
0x079af129,0xe8befeb2,0x0a53ed15,0xf830ff8e,0x1251f830,0xeab1f36c,0xd1333584,0xccea349c,
0x074e1882,0x270fe774,0xf23d0837,0x04b2090c,0xdf4e1155,0xe039201f,0xe05512c9,0xfcd6010c,
0x00840002,0xea1bfa0d,0xe1672cb7,0x0122fab9,0xeafb23c2,0x02021469,0x28b7e1cd,0x2758ddf4,
0x1f90d423,0xe3570947,0x0a4dff69,0xf06c041c,0x020dfd77,0xf0b90ad3,0xf372fe58,0xeaef1f0c,
0xf6a60a98,0xff670674,0xf53f07b6,0x3869fced,0x22b7cd4e,0x1451e66c,0xdd84180d,0xf0741080,
0xfaf1f6ef,0xeb0bf72c,0xddd21725,0xdeea05fd,0xff912850,0xfa940fcc,0x016b15ea,0xfb550aba,
0x01330646,0xce1715e4,0xe5ab2460,0xcbd123ea,0xf6e71658,0x05abf6eb,0xf938fd4b,0xf204150e,
0xf82b03dc,0x3647eb83,0xe92feaaf,0xd867246c,0xec150bba,0xf0ae186a,0xba5d373d,0xec6d24c9,
0xd6951ac7,0xd35d414c,0x1abb0c3f,0x2880dcf8,0xeeedede5,0xbd2f36f9,0x0b631419,0x19bbd86c,
0x1260e24c,0x1298eb67,0x111ee575,0x09e7f311,0x127c0524,0x2d12eadd,0x1c7adf67,0x1219f722,
0x14dcef42,0x196edbea,0x1ffee3e9,0x1ac0c81d,0xdd670312,0xe91219f7,0xf6b005e7,0x06b91222,
0x07c8ed14,0xe33620e2,0xfc140d7d,0xeb3410c8,0x18c5005f,0x1de3ea95,0x06a9d435,0xee9c0e0a,
0xfa7517b6,0xf7c9fdab,0x016dff8c,0xb02221c0,0xba4d64da,0xfc140b37,0xf10b015d,0xe4180dca,
0xd63f3cd1,0x1e86f9da,0xf5cdf7d6,0xe98122d5,0xfc7109a7,0x151a00ef,0xfb32e1fc,0xf43b0acc,
0x24d0e2bc,0x1c74d61f,0x1b91eab3,0x0da1ec1b,0xd8b6198a,0x0127261b,0xfaddf886,0xfb7906a5,
0xf73504be,0xf7b60535,0x0e2904d8,0x06a6faef,0x11a4e179,0xe70cf8db,0xea8920be,0x1b10f715,
0x221bdc89,0xdd68ff01,0xcd6c36f4,0xd9964324,0xfe7c0227,0x01160257,0xfa6c0188,0x1309e77d,
0x0900e726,0xfe311391,0x0707fbe1,0xfc140288,0x2928ea1f,0x1278d69a,0xe892199d,0xf4e00954,
0xefbe1211,0x16ce01f5,0x15c7ddc4,0x0bf7ea39,0xd42310c8,0xeeae1a32,0xeeaa10eb,0xe165120d,
0xf6491469,0x1e7b01f5,0x1a20d59c,0xe8720f20,0x17e0fc4d,0x15bbedaf,0x1286f0ba,0xffd7f37e,
0x057bfbe6,0xff1e0a23,0xea5a0265,0x20f8f19b,0x14d1dee5,0x00beed5f,0x01b1fdc1,0x1622f260,
0x03eb063d,0x2d83e230,0x3a29cf9f,0x473bbef8,0x2517cc75,0xda1bfcaa,0xfb921421,0xfcd202f4,
0x18adf74b,0xe3c3fe5a,0x0a7914ef,0x1ebbed00,0x12fed93b,0xf522f43b,0xe90b0ec1,0xf80a0ec8,
0x079aff04,0x1d68f8d5,0xfb63e4af,0x05be1680,0xfa82fe6c,0x0a6f0179,0x12dbf880,0x21c9d0ca,
0xe5100708,0x035707b5,0xdcb61689,0x0c20fe2e,0x0da8f10b,0x07b3e616,0x186df167,0xda33114f,
0xfb3107e1,0xd80931ca,0x27d90eac,0xf30fe99d,0x1294f4af,0xde390e60,0xed8a1dd2,0xffda025d,
0xea0efc33,0x01e0133f,0x107df4db,0x1e6ad49c,0xc1660fde,0xcd3d5371,0xfb5a1dea,0x267ce34c,
0xf2edffd6,0xe6b812d9,0x1651fe98,0x1cc8dfa1,0xed37ef6a,0xf1811ab3,0x141ef1e0,0x07b8f469,
0xf9930dc4,0xf9881300,0x06d4faf0,0x13f80011,0x0931d5c5,0xfa17f931,0x1549f358,0xf7cef058,
0x0dfc04dc,0x0518fe0d,0xf4430ea9,0xffbe0983,0x02f01410,0x0b1ae7c5,0x052aff8a,0xe733fa9c,
0xe7ff1da3,0x00f6f724,0xdd10052c,0xe7b42545,0xf6f711a2,0xf3340ee9,0xffe6fc25,0xf9951ea3,
0xfbf6f7a5,0x0c580ccc,0x09abf02b,0xfb9302c4,0x0723ec83,0x02950b9d,0x3208ddd6,0x1b02e169,
0x0a0dec77,0xfa12f54e,0x0f8d03ff,0x2c14d01b,0x1430d103,0xfeb5fbb7,0x163aee53,0x2110e813,
0x08fdf69d,0xdec2159c,0xfb9f2490,0x1d0be802,0xf9cdf892,0x26b2f2f7,0x060ee8da,0x08e4faff,
0xeb7ef954,0xe7661088,0xee960c57,0x0e7c06b0,0x0822dfe1,0xef1c0ee4,0xf5280e44,0xed0e23c2,
0x1ad5004a,0x01edf4a9,0x2a79f105,0xfd82cf69,0xeaf71c0b,0xe8bc0903,0xd1bc2219,0xc8cd3714,
0x03c71d3d,0x1480ddd1,0xf38ff374,0xbe4f3416,0xb8a84d6b,0xeee231d0,0x05910701,0x1933047b,
0xffb3f128,0xe5f10544,0xc23433b6,0xf3de1967,0xe2c70a9a,0xeb9e101f,0xee920ff6,0x0967ff66,
0x11ffebe8,0x09cd078f,0x2e4de1f3,0xf419f581,0x03bc0375,0xe12412e4,0xe9571a86,0xfb251354,
0xf0d80351,0xebaf0ce0,0xed850d7e,0x1513ffed,0xfca7f2be,0x120a0285,0xedc4ffdf,0x0b780e88,
0x074bede1,0x0de9eca0,0xe9ca0230,0xd8892f90,0x1471fa75,0x00e4efdc,0x010b08fe,0x042bf90d,
0x37e2df94,0x015fde2f,0xf1c21443,0xf3ba1427,0x03500337,0xec7f0e5a,0xe40413c4,0xf87b0565,
0xf07b0eea,0x0899fa28,0x003ff6fc,0x2935f243,0x1a41e946,0x1b91d822,0x080afd20,0x16a0eb8b,
0x05acf6c5,0xdcdf02bb,0xe582300c,0xef54106a,0xea880b71,0xe8be1ec8,0x0c38f9f1,0xfd95fd0b,
0xf94def77,0xed1528f8,0x1d03ea88,0x0798ee96,0xecec12d7,0xe8aa203e,0xf3c116d2,0x0419f1d6,
0xf46c113a,0xeacb02e1,0xd3e41ef3,0x1753ffde,0x0da6ef75,0x0753ecb6,0xdce81614,0x00931cf2,
0x1a2ef058,0x0a1ef26b,0xf899f60a,0xe70c1a2a,0x0f7a0ac6,0x2fe6d0ed,0xebcb00b2,0x07c7fd9d,
0x01e3f50f,0x130bf12d,0xfd2fee99,0x1ab8f1f9,0xfd780297,0xed670fab,0x17e60432,0x0aa5e58f,
0x05800887,0xfdf30582,0x1a2ee771,0x04f9e0f3,0x0acd0130,0x06b0db83,0x19e1eed6,0xec680a9c,
0xedf60b52,0xf84c1701,0xfac2066f,0xe0bb2814,0xeaa71eb1,0x0c0c0c0a,0x36d0ca4e,0x0336dfa7,
0xf57ef3f5,0xfe8600be,0x08910115,0xfdb1f31b,0x1940052a,0x2392e03b,0x09b3fa71,0x130efbb1,
0xf808f970,0x1d9ae920,0xeedfe83f,0x0f7e0f3d,0x228bd618,0x0fd1ef92,0xe67cfd59,0xec2e1c56,
0xec5416e8,0xdd37174e,0xefe124a9,0xf0140b6b,0x1cedec35,0x0a39eb5a,0x03471475,0xecf20076,
0x209400d4,0x05bce923,0x14f9f46c,0x044aea0b,0x0010fa6d,0xe65007cf,0xda811912,0xe69b1847,
0xf6181cd4,0x087b0b69,0xfc76ecae,0xff19ff9d,0xeb1e1da0,0x1293047f,0x17fbdde7,0xf3ba0d63,
0x065cf6e2,0xef490af7,0xe0f2151e,0xd9432ad4,0x09a212b8,0x1a3defa0,0x2ee0c7ef,0x0cb3e0d6,
0x1e7de3fb,0x21b9d875,0x0eb2f2d1,0x1c3be28a,0x056efc48,0x084df969,0xebde042a,0xfa7012a4,
0x061b02c8,0xfceef835,0xf12a0cb1,0xf2d10c6a,0x3161eddf,0x0601d434,0xfa5f040d,0xff8d078a,
0x0d58fd67,0x09b3f5c5,0x047404ed,0x3cb4ef07,0x62dd97cb,0x368dabed,0xe756f053,0x01700c5b,
0xeaeafbd4,0x026206da,0xe24410f5,0xe2842494,0xf63e20bb,0x0525095f,0xee72ff74,0xe9191d6f,
0x0a970781,0xfffff03d,0x1180eaf9,0xe9910053,0xe4d91214,0xf3931515,0x03a40095,0x07ff0a26,
0xf889004f,0xf7f30eb1,0xeff01730,0xe8e11c05,0xf8950008,0xf5dbfaf9,0xd978191d,0xfb1f0a10,
0xfb2110be,0x0a8ff661,0xf8c1fe31,0x0f660786,0xfbd7f134,0xf88d123f,0xf57dfa56,0x0b0c04bf,
0x175be8db,0xdab90ed9,0xecd62059,0x0235143e,0xfcbafca2,0xf343092c,0xffa7ff7a,0xf8330023,
0x0cf5fa92,0xf3cff79c,0x0963029e,0x1ddef6f2,0x23fada42,0x010ce3a8,0x0e5f0337,0x0f1de2c8,
0x0c78efb9,0x13bff710,0xe6a90c6f,0xdfc9272a,0xe73c27ef,0x1d3602b3,0xff4fe16a,0xf7a1ff4d,
0xde1717ed,0x1b1303e5,0x1b65d4c5,0x035fea19,0x02f909f3,0x10f4f029,0x2129eb52,0xecf3ee32,
0xf1ca1ec8,0xed0509ab,0x18610df9,0xeee1f383,0xef8a157e,0x0e1ef336,0xf474fdba,0x003b0ab5,
0x040cf65b,0xfde30f48,0xf09309ae,0x14db062c,0x18dce3ef,0x0a41f1d2,0xfa24fccb,0x13e6ee29,
0x02a1ea63,0x0a2d0742,0x1a25e9be,0x240dd65e,0x1565e3a6,0xe8f2001e,0xf3c60ff1,0xfc9f0483,
0xf6bb0e65,0xdfb7179a,0xf4922d3f,0x1345f721,0x0440f521,0x1360eb6d,0xfda5faff,0xfd57f676,
0xf1e802f1,0x10be0426,0x3f1ecdfa,0x07fde485,0xf0e5075a,0xffb90bfc,0xfd61fa09,0xdf530a39,
0x0c9e115e,0x1138f375,0x0c70dfe8,0xf11a03c1,0xe52921d5,0xea33131c,0x22f801db,0xf62bf094,
0xf5ab1386,0x1c7aeef0,0xf544f6dd,0xf36017d1,0xffac137e,0x3ac8d11a,0x28e5b913,0x0e02f4ea,
0xfa9be057,0xd99c13d7,0xdd47267f,0x08be1059,0x03fff78e,0xd9b72c0f,0xf8f5299c,0x10d301d9,
0xf343fb1b,0xf41c0065,0xf6610c0f,0xf190f0fb,0x0fb6f91c,0xf8b0eb38,0xef2011cd,0xfa280a94,
0x12d605da,0xf6daff02,0xee511bf3,0xec001d98,0x0a130082,0xe987102e,0xf25d0ce1,0xd9901d8e,
0xfb55fd1e,0x1c1efc79,0x1f37cba3,0xdbb4041d,0xf7181c85,0x10a00cc1,0x1d15ecf2,0x0f67dedf,
0x1c0cf47d,0x3beaccbd,0x0e67e106,0x1c41dc81,0xf020fb1b,0x07c6067f,0xe48cfa12,0x0ba80ffa,
0xfcbcf9e5,0x085905ee,0x1470f6d7,0x06a4f79a,0x11b2f3b2,0x0a49f0e5,0x0b52f836,0xf854fdc4,
0x1a7df937,0x0513e4d1,0x0951ffdb,0x09eaf071,0x0c24ee82,0xef60fca5,0xfb52064f,0x07940312,
0x0abaf68b,0x04d3047a,0x0a5efd5b,0x10c8ef4e,0xfd34fa82,0xf9960097,0xe86d0b8f,0x024d0928,
0xf144088a,0x1b23f0e7,0xf47ff727,0x0a53177a,0x188eea8c,0xfb2af0bb,0xf7c2042b,0xda8828fc,
0xf4ae170c,0xec1606a9,0xf03903d8,0xe03d0ec6,0xe45d121d,0xffc61b88,0x0c1ef0cd,0x04c0fc5b,
0xf6fa111a,0x2794056f,0x0473eb59,0x08a403a4,0xf918fa91,0xf580fe50,0xeebbf53e,0xe76510a4,
0xf00d17a7,0xf75ef93d,0x14d20814,0x1a4be982,0x06c7f5f2,0xfba11141,0x09c001c2,0x169ef11c,
0xffb0e606,0xd5c31d61,0x11301080,0x1d73e2c5,0x2746cb44,0xfc4bf37d,0x02c40223,0x01b0ea39,
0x07cc1203,0xfc0dee04,0xfda712f9,0xf6cffa4a,0xc8132915,0x0e161fea,0xfc04fd0d,0x1096f763,
0xf133fae1,0xed412012,0xeb8b0232,0x01b81fb1,0x11f2e291,0x0db0eab6,0x17c9ed82,0xf416f533,
0xf62b0a69,0x0c18f685,0xf80102fa,0xfc6aff56,0xfb8d0710,0x0ba1f376,0x03f40ceb,0xddd60dd5,
0xee323976,0xfd770333,0xf7ba113e,0x0110f6fa,0xe47b0403,0xe9401579,0xdae20334,0xea6526e5,
0x1077f822,0x03a9f57f,0x2902efcc,0x486bdaef,0x2b22b779,0xf60a001f,0xfa6613e9,0xffd4ff60,
0x00b2f799,0xd86b1366,0xf13c1970,0xde1c0cf8,0xe3b92838,0xf77dff0c,0x089c0e68,0x1480e510,
0x08c7fc69,0x1c04ef93,0xf9b50489,0x244ff36a,0xff10f56d,0x02dcf871,0xe1040911,0x02d7036c,
0xeac6f2c8,0xd0cd22ce,0xfdc110a8,0xdbd01708,0x0312257a,0xeb9712c1,0x13e407f9,0xec3e0682,
0x01a31958,0x07b6ec30,0x1245ede3,0x06d1e5ff,0x08c7eacc,0x1e95f0bc,0x04e1e863,0xf17407b9,
0x0a210535,0x1197fce5,0x0511e818,0x0690f8c1,0xecb20e53,0xfa4710d3,0x09fe0310,0x0a5ef5b4,
0xfec70c55,0xff1dfce4,0x0ee9f462,0x20dfdf9b,0xff08ee6a,0xf7eaf76b,0x091ffcf2,0xf0d6019f,
0x0176fba3,0x07b10290,0x0eb2fabf,0xf211094b,0x01c20ea2,0x0f3dfb51,0x03a1f93e,0xfd3a0774,
0x053bf29e,0x029ef910,0xf7b6054b,0xf72208f2,0x0c36f0cf,0xcf6e0e71,0xee7b32e8,0xebb5075b,
0x0a9c04a3,0x0ff6eac6,0xeb91fdfc,0xec112307,0xff2807bc,0x04bef3d8,0x0530f309,0x066b0d0e,
0x06d2f8bb,0x0fc7068e,0xf4ba00a1,0xedc41ac4,0xf82f0867,0xf6d3ff01,0xf52300e0,0xf4960412,
0xf74aec72,0xf4e608be,0x14050f55,0x26f6d395,0x29d1e842,0x0844ee99,0x007300c6,0x0c810450,
0xeaa41274,0x0bf7f68f,0x3654dab8,0x2176c3e9,0xf399e8b0,0xfd9e14c9,0x1765e6b5,0x008202f2,
0xf98b060f,0xe77317ad,0x030c08de,0x05b9fc8b,0x0d98f1e9,0x2f09e4fe,0x0dfacecc,0x0646f902,
0x1ac2edf4,0x072ff2df,0xe0820562,0xf4e02581,0x177bf5c0,0x0185f77f,0x0508fc9e,0xfe090669,
0x0bfafe17,0xe761facc,0xd9ec2980,0x01b30575,0xfd860185,0xf329f6d9,0xd8520e0f,0xf9b4283e,
0x05c502bf,0x17b7ee7b,0x0155f951,0xfa870fda,0x1071ee13,0x01c4fe94,0xeaba061a,0xe4a91bb7,
0xf2500f59,0xea2e1600,0xea3c17ad,0xfcd20538,0x04d0f71a,0x0bad000d,0x10eaf424,0x1b1cd886,
0x056bf623,0xf2a8fd96,0x0c6b06d1,0x29f8e5f3,0x0424ec34,0x06f7fa9c,0x0a470bdd,0x1fe1e66f,
0xec48f32e,0xe24f1b5a,0x0b0efdf5,0x009fef28,0xf387f507,0xde4720ed,0xee641bce,0xf5c51b4f,
0x02280893,0xf4b211cc,0xf35b09fb,0x02a90db0,0xf16deb62,0xf5ac0ad1,0xe0a00a1b,0x11c5054a,
0xfb60f91f,0x012003df,0xf50414bc,0x168afab7,0xf79c162c,0x3a22da24,0x167ed32d,0xf480ea22,
0xea511207,0xf948f232,0x0c01f9c4,0xec240830,0x2a61fb6c,0x1d7ce976,0x1c17f0b3,0xfc7a0456,
0x0514f4f8,0xfdfc02a9,0xfa7cfa9c,0x0779f4e4,0x1ef5e28b,0x228ee428,0x0defd169,0x0bb1f4c3,
0xea9a15f6,0xf9960bbf,0x1bab0830,0x2cb5d7a5,0xfed9f247,0xee0d07d4,0xfcdb0c18,0x0b15e4af,
0x04dbf99a,0x0ee8e587,0xf814faa6,0x113f14bd,0x2fa6d803,0x351fe421,0x2240d873,0x142de4c4,
0x056ae703,0xefde09ae,0x01d1fdcf,0x1e23e169,0x058deafe,0xf229f819,0xfc7a1c38,0xfafff5bd,
0x10ce0bf6,0x179cea6e,0x119bf10c,0xdb000536,0xf2903803,0xfe75f7ee,0xffe4febe,0xfb9300da,
0xfb0cf9d6,0x1727f8fb,0xfcbfe656,0xebc0111c,0xe04315dc,0x0726154b,0xfbb1fb92,0xf2670836,
0xf56611c7,0x004d0cd9,0x0762f2bd,0xffff0179,0x1febf89b,0x1418df67,0x1017e921,0xff2cf256,
0x0f240967,0xf972f1b5,0x1346f4ff,0x06430055,0x00c80d8b,0xfee1edff,0x08dafcea,0x0e20e974,
0xfe9af8e4,0x14f5de97,0xeb43fb8a,0xfadd1ed8,0xf2cb06ee,0xfad6101b,0xf74511df,0x0a731198,
0x0270e7b7,0xf93b06b4,0x0c0cf709,0x0960ff46,0x0b06eedf,0xfae9099a,0x1249ed6c,0xe43c0925,
0x18cff93d,0x0a2cdfa4,0x031bf507,0xeafe0fe1,0x196400ea,0x027cec41,0xee31185a,0xf29e0f91,
0xed671801,0x2090e30f,0xe8dd0bf9,0x1c16ffe1,0x1495e72b,0x1de9ece7,0xf02cf7f3,0x0ea40d82,
0xf9ace28a,0xf9200224,0xdc8f0b8e,0xe5461bfb,0xfee60202,0x007e1b67,0x11f8e97d,0x0f8d05de,
0x1183efd4,0xe10214c8,0x2341ffc6,0x141bdb38,0x1583eabd,0xe23effb6,0x132001c9,0x0979d6ff,
0x0c0b0273,0xfaa5f4ca,0x0bbc0c08,0x1841e3e8,0xdc401ab9,0x07010a01,0xe0a913f9,0xf72111fa,
0xf604fe11,0x10df1068,0xfc80e0fd,0xf03710b3,0xecf7117d,0xf9ec0d01,0xff67ef6e,0xf2d415ae,
0x05ed0243,0xf93a1265,0xdc3c1545,0xdf3225c0,0x02681176,0xf17df059,0xe9f31778,0xf0391004,
0x0ee40e19,0x2226d2ba,0xfdf703bc,0xf3a3fbfb,0xdf481b0d,0x0715040e,0xeb990550,0x06910cc7,
0x0251fce9,0xf8e60ea8,0x071e08a7,0x2035f558,0xfca8d6d5,0xee08188f,0x04dff8bb,0xfd77ec89,
0xe4291bbf,0xe14e270c,0x0c560d2e,0x01affbb1,0xf92c09de,0xed090337,0x1439013d,0x126bdac8,
0xf342fcde,0xed761526,0x0ae30c97,0xfadb0198,0xe986070a,0xf1731766,0xfc8001a7,0x0988fdb7,
0xf7a5f7be,0x174714fd,0x0725ed14,0xf48a061e,0xf9b40c25,0x0ef0f566,0xe77ef746,0xf25dff34,
0xef4d1f29,0xf3c00269,0xd6df2899,0xf2b01886,0xfc731bef,0xf5b4013f,0xf56c06f6,0xfa7509ce,
0x1046f938,0xf53bfd1f,0x1f07ed3b,0xe3b10793,0x01fe1f69,0xee39045b,0x01f7fa4e,0xf8180649,
0xf2e00160,0x0c17f963,0xfe53fbae,0x1580eedd,0xf76ffcdf,0x036d1461,0x17bbe8b7,0x0c1dff4b,
0xf4ee00a9,0xf28b0a94,0x0306090d,0xf677f825,0xe7e91a60,0xfe4506e4,0xfd92ff2f,0xfb5405a5,
0xf7ff0fc3,0x1b60e1ee,0x17e3e82e,0xfc7cf90a,0x02f6ee84,0xfc640185,0x18380a4b,0xfaeaf417,
0x11e80176,0x13ebeb0b,0x045cf608,0x023403fb,0x0e15e986,0x003bf90b,0xf6370efa,0xfb6d056b,
0xfdfc0093,0x00ca0218,0xeeeef55f,0x04710c20,0x254ae791,0x1742e3ca,0x105af646,0x025700e7,
0x0f96f29d,0xe8220364,0xf8be1435,0xefe800cc,0xf02b045a,0xe3b61966,0x10e80a88,0x1454e52a,
0xf90201ec,0x025d0ad8,0x13a9f44c,0xf75efd42,0xf5f50dba,0x2969f66a,0xf94be554,0xf8b9fbde,
0xf0941954,0xee91084b,0xf6ce0350,0x06dbfb63,0xfdf8fda1,0x12cef907,0x0c54f513,0x1413fd06,
0x1e84eed5,0x03f2f3bb,0xe8c4fad8,0xe3fa2346,0x06d3fa4a,0xfae0f920,0x0774f6db,0xf95d11e5,
0x2edbea5a,0xf538e6fb,0xcca23a9b,0x02480ba8,0xf8210a88,0x0bd3fa71,0xfbc4e876,0x271af4d7,
0x1860d38e,0x0891f6a5,0x1173eec1,0x1359fb20,0x0a91e1a8,0xda6922b5,0x01430f82,0x024c0bc2,
0x062ef955,0xf938f47c,0x0b8a0855,0x069de75a,0xe105fc0f,0xe9821a49,0x0e8a0d97,0x0fe4e9e1,
0xf6cc0b1f,0x2aaa0020,0x2ab6da4d,0x02ace003,0xeeb806ae,0x1f9bec83,0x0749e980,0x0ce1edda,
0x0107ef12,0x09a5123f,0x00e9ee48,0xf9e6084a,0xf41609a6,0x0468038f,0x0779f4c5,0x03c30240,
0x11c7f7fc,0x15b1f2cd,0x140ee8cf,0xee1c04e0,0x00f208b8,0xe86ef900,0xf3241b58,0xfc40f942,
0xf74efef1,0xf76a0c25,0xf4601861,0x1d09f7d2,0x0f64ee17,0x1765f045,0xe91bf49d,0x11e80372,
0xf991ede5,0xe25d20a5,0xdb071185,0xf9532034,0xf1260f45,0xea1413c9,0x007610cd,0xf02f0121,
0xfd46157f,0xee43fb2f,0xfcfe0be0,0xf0aef9d6,0xd8bb21cc,0x05190a60,0xfeda0228,0xf3b60eab,
0xf18c1916,0x0296031c,0xe6cd085a,0xdac02144,0xf89c135d,0xeee406e5,0xefec134b,0x0ea8f698,
0x001afdeb,0x197cf669,0xf620f4ea,0x084c0dd1,0x073aee7c,0x0216053b,0x13bde6ab,0x0ecff4e5,
0x1c7ce50e,0xff01e623,0x099905eb,0x1b81e8ed,0x26e6e57d,0x0a66e510,0xfcdb1058,0x0d4bfe73,
0x03eaf5e6,0xe7df008e,0xee462400,0x0023e712,0xf08f04e9,0xf797138f,0x0b8cfb97,0x2102e7e2,
0x0703e819,0xfbda0411,0x02c705c5,0x0754fd86,0x0e680717,0x1483ef1d,0xf8bffb8d,0xf56609d3,
0xf26704fc,0x1708ee0a,0x028fe09e,0xd8231839,0xfe511430,0x0e10fa53,0xfe19031e,0xd5b6336f,
0x06c00b5b,0xff3ffcd5,0x0f89f057,0xeb69f780,0x0fe306f3,0x036bdd02,0xf4fb08f0,0x07bdfe56,
0xee5f07f9,0x00b10c37,0xe4e01997,0x12f60a4e,0x19abf5d4,0x00daec0e,0xf3df1420,0x00970a44,
0xfcbffea9,0xcd5b008b,0xecbb1cf6,0xfac3005c,0x00cff2b1,0xd8a5192f,0x07fe1864,0x1802febf,
0x13f0ec76,0xee7a0f78,0xf5330daa,0xe9a51a6d,0xfc84fa8d,0xed631316,0x068905be,0xfa37e86a,
0xfd790af5,0xfac3f568,0x0aaa060a,0x034ae88f,0xe6161fdf,0x069d0270,0xf5f6165f,0xfc5c06b1,
0xecc71c78,0x12800162,0xf4b8daeb,0xdd392270,0xf67ff9f5,0x078a0f73,0xf1790551,0xf24317aa,
0x0b33fb5c,0x1dfffe20,0x0c7ddf44,0xed8e094e,0x056ef5bd,0xf3b60d9d,0x2624f4f2,0x0185dd63,
0x07980cae,0xfe9ff826,0x1018ffe3,0x1789e404,0x1ea1e62b,0xf1c2f0e7,0xe44317d4,0x1029062d,
0x1464e63c,0xffdaf861,0xfa6d076c,0x2855f3cd,0xf4acef15,0x0abc0619,0x0447f386,0x08ec065a,
0x0324f400,0xed0c0e2b,0xf7ce058d,0xea2716d2,0x0f49eecc,0xe9980423,0x13e6f7e5,0xf4a10702,
0x076a0919,0xeb5005fe,0xe8b51b0c,0xf3590d75,0xdd831a85,0x0c3804e8,0xf146f56d,0x0230149a,
0xe39e1326,0x202bfb0f,0xf6e3f85e,0xfadd1a9d,0x0ae5f877,0x0224ea7d,0xee5e05ea,0xd97c147d,
0x0b81014f,0xf75aff7b,0x1879f167,0xfaaafb4a,0xef900778,0xd9c53385,0xf1e421b9,0xe69e16ad,
0xf6b80fe7,0x02df175d,0xff66eb5d,0x1349ebcc,0xf99df56d,0x0f10ef01,0x02c7fec2,0x1970e374,
0xefb405dd,0x115f01ce,0xe8a10641,0x0ab60823,0xf8110255,0xdaf72047,0xf9820ce7,0xf3e512e3,
0x0dbdef18,0x01af024f,0xfb77f8a6,0xdbee1f6f,0xf45e1341,0xffce0d90,0xe3d0fee6,0xfa1e115e,
0xfba7f6da,0x0db3f30e,0x0133f563,0xf58609b5,0x06aa1d96,0x1af0e320,0xd1b61fb5,0xed40184d,
0xfd021ebd,0xf233ee00,0xe9052427,0x2036f93a,0x00a5e2c7,0xfc98f3c4,0xf34b0c6b,0xe98f11f1,
0xfcca03d5,0x0e86fa56,0x10c4e90f,0x239af126,0x00cdf1c6,0x026a0b57,0x03fc008e,0x003ffd7a,
0xe520fc26,0xf351222f,0x044f047d,0x1beadf1c,0x0480fca1,0xe966f9b1,0x08770c24,0x045fefe7,
0xf3460913,0x0cb3fad1,0x07df08cf,0xf8dff5c5,0x027a1206,0xf87efff3,0xed4106d3,0x02f90c8e,
0xe15809c8,0xf02207f9,0xe75f13a6,0xf6760aee,0xff14fa42,0x05c113ec,0x08dff4ab,0x0ad5081b,
0x11170339,0x111ceacb,0xf07cf582,0xd6d91a25,0x08820e3c,0x0b7ce94f,0xffe8eca9,0xf22d041c,
0x149705a2,0xf99fecf9,0xef9d145d,0xdb7d1bbb,0xebcb3596,0xee3d0475,0x11001740,0x0a67dea9,
0xfa30063d,0x02acfcd8,0x13b4f46b,0x13bcda8b,0x10cef1bc,0x15f0e221,0xf9edf7d4,0xfa4c0781,
0xede1113f,0xf3fd14ec,0xfb2c0b94,0x1655ffff,0x12f5e44c,0xffc4ff30,0x297ae5c0,0x1499df8c,
0x0ffdeaca,0xea5af34f,0xf48c15b6,0xf5860532,0xff2c05d7,0x059af816,0x086b05b3,0x05abf878,
0x00a100f4,0xec2905cb,0xf1931f1a,0xd8462094,0xe9ee13ef,0xf0ef1211,0x05b80aa6,0xfda6f248,
0xfde6f816,0xec9307a3,0xf3930caf,0xfeab143e,0xf925fb2d,0x026a0ea2,0xe83501ea,0xf03d1e35,
0x07880951,0xf8b1fc69,0xf935fe15,0xf69b0569,0xed470e54,0xffdb014d,0x0bd6fb49,0xedfffd0f,
0x04bb1065,0xfa9903ff,0x078a0a9b,0xffbbfa23,0x062c0087,0x0312fe45,0x15e5eb96,0xff1df17b,
0x057ffc38,0x099b00e1,0x06a2e37e,0xf8440349,0x1136fd93,0x153aeb76,0xf6e0f0cb,0x048effd6,
0xf97ffe68,0x04600b29,0x07c1fd77,0x0f9ffac0,0x08a3037d,0xec09087e,0xfbaa082e,0x06b8f291,
0x0090f06a,0xe9d8135e,0x0d32fad8,0x04aefe71,0x1174f266,0x01010955,0x0c41e70f,0xfe63ff7b,
0x0a5ce757,0x189ff116,0xf7a7f606,0x12fbfffb,0x03b7f580,0xfc7b03d8,0xf39609dd,0x1d6dfffb,
0xf249fd6e,0x071a0be5,0x115bf047,0xf315031a,0x09f3051c,0xf416ece7,0xf99b0429,0xee24ff55,
0xff9f0195,0x05e0ef6e,0x008a0446,0x02701214,0xff4cfa8d,0x16d40ba7,0x13c4eab1,0x0accfcef,
0x0c44e948,0x0557fbc4,0x1c0edd32,0x03aaf3eb,0xffbdf090,0xfe3ef910,0x076d00e4,0xff69f84c,
0x01bd06b5,0xf81d04c9,0xdfb1299a,0x09da0dfd,0xf03d07e3,0xde7e0e7e,0x09200dde,0x00d7e6b7,
0xf03506f3,0x04210317,0xf39f04ac,0x090a02cc,0xf9dd04d2,0x03af0a13,0xf02606b9,0x0a530bff,
0x0707ee76,0x011bfbc4,0xe056081d,0xfd8c1583,0xf433f238,0xe8b321ef,0xee7904e4,0x00990f75,
0x14b000cb,0xff17f262,0x06430403,0x085ef6d1,0xf61308eb,0x1c0ce627,0xf14800c6,0x06fa0518,
0x142cfac5,0x11cce708,0x038efe59,0x188be7a2,0xf4d3f90c,0xff78f7d9,0xf11907eb,0xf3421473,
0xf81efd18,0xe7782654,0x054b06c9,0xf138ffc8,0xfae1122a,0xf4350aa6,0x04b50649,0x00fd0099,
0xe91e0265,0xf4881b7e,0x0e630091,0x0e82dae2,0xfc99f53f,0xfea70605,0xfb02fc2e,0xf9e30812,
0xf1a21a2f,0x0826fcc5,0x04d0124d,0x09dce3b9,0xfed7081d,0xfbdbf604,0xf35b18d4,0x1994e6b8,
0x00bff419,0x047f051d,0x0766f7cf,0xef9505a3,0xfc0fff26,0xfd020e06,0xf5f9007b,0xdf631ea8,
0xfb401725,0x1134fd83,0xe045f105,0xe7c82ca9,0x0b37fe79,0x0b36edd7,0x0914fcc5,0x005cfd14,
0x0e2301c0,0xf8aeeddb,0xfd3e1623,0xf6afed01,0x139a0ed8,0x080add7a,0x0d6907d0,0x0cf9f285,
0x025104b6,0x0770f9a6,0x04fff719,0x0ad5f87e,0xff66f2ad,0x0364038e,0xf9e4ecc2,0x1180056a,
0xf1c7f08f,0xfb9821b2,0x0f51ef2b,0x1055f47a,0x1e47eb30,0x0cabebac,0x239eef78,0xea49ecae,
0xfa8a261a,0xe219fea5,0x08931c67,0xf1dee8e7,0xea681c58,0xe6ed07b6,0x0d050be5,0xf5effcdb,
0x0da6041d,0x1106f196,0xe882021b,0xfd781b8f,0xfac7f665,0x15cd0b25,0xf306e5f6,0xf69a1bfa,
0x0b9bf4e0,0x1418f014,0xf611fd89,0xf60a0f23,0xf8400c6d,0x0258f6da,0xe7220960,0xe57e1c11,
0x08c4002b,0xed04f9cd,0x10061029,0xf7def5ec,0x11df08b5,0x0d72f3ea,0x1350fdd5,0x129cecef,
0x0890f3d6,0x040df3ea,0xf626f9da,0xf65200dd,0xe46b052c,0xf9102033,0xf84404bf,0x10b5fc18,
0xf7a1fbb1,0x003d0e36,0x05c0ef8f,0x08d5fd43,0x1534f1a7,0x0456f819,0xf73e070e,0x153a0411,
0x01bde398,0xefe01a86,0x1999e27e,0xeaf10a0a,0x0aeffffd,0xe45b0313,0xfa8a17a6,0xe62010d6,
0xf6e10ca7,0xfbd304f4,0xf27a0fec,0xf4b20346,0xf56414a7,0xf88f02a5,0xeca9191e,0x070507e8,
0x02e3f879,0x0c60ec1a,0xe8cf01c4,0xe78012e9,0xf5a311fc,0x06900f1d,0x09ffeaf1,0xf85f1425,
0x027503dc,0x01c6fde0,0x1019f6d7,0x07e4fa6d,0x0cdde91c,0xfb7afef4,0x0a20f575,0x126ae5bd,
0xef8ffe6c,0xeeaa0999,0xfb2f0ce9,0xf8630942,0xefd21926,0x098d03e4,0xf3de13aa,0x02090532,
0xf9b00b40,0x1a03fcf0,0xfab0e105,0xfd6a0a87,0x0792e7c1,0x0be8ef31,0x0d6ce696,0xef590243,
0x06cf0141,0xfb17ff9f,0xf60b1339,0x1cc705af,0x0a4aedb7,0xfa63065a,0x10fd04f7,0xf1d8fb07,
0xf15f11af,0xf846ffcc,0xefc40e68,0xf081fe58,0xedb60fc8,0xf8cc0b2f,0xf70907be,0x0df9f6de,
0xfb3cf248,0xf3a112bf,0xfbf707d3,0xfd8411c1,0xf7ee020b,0xf56c19f3,0xf89107f3,0xfdfd02c4,
0xfcfa05ab,0x0647f939,0xfe5ef924,0x033ff577,0xd5ba0f6c,0x00d71395,0xfe47fa01,0xfa3e0061,
0xfc40086f,0xeaae1dd1,0x0a811422,0xf8fdf596,0xfe831434,0x286edf33,0x0451e0ab,0xfe57f742,
0xf64ef992,0x12c4fb29,0xf31bfb13,0xf2121111,0x075f0814,0x0b2afac7,0xe6dd0a76,0x092216e7,
0x00f0fc26,0x01a3fae0,0xfb680651,0xe7490b13,0xfc810f38,0xdc78ff3c,0xec871a39,0xf5bef78c,
0x190bfc36,0x0814e58b,0x1f9ffc65,0x0284009c,0xff200261,0xd816255a,0xed2f234f,0xf09d0e86,
0x118ef5fd,0x030ef138,0xfa2cf437,0x25caecd1,0xef6bf20c,0x0793fda6,0xfc5e0685,0x1df9f1b0,
0xebc1f3f7,0xfb88152d,0xfa490636,0xfe51058d,0x026b0c57,0xdbe603ee,0x2c370c9e,0xf655dcea,
0xfa2d0fd6,0xf7cefc99,0x10c4fa53,0xe689fce8,0xfed4220c,0xfd20fd6b,0x005a019a,0x04f90397,
0x0316f328,0x10b2f5a3,0xf03df422,0x069c082e,0x03f6f133,0x1f3bf058,0x1307e049,0xfb6602ff,
0xfbcf1871,0xe7440424,0xff871713,0xf35005ee,0x05f30f5d,0xff1eed9b,0x05f6fbd5,0xf2b5fefe,
0xf481038f,0xf86d0a55,0xfbb9f243,0xfe130e45,0x011afa1b,0xf5d71411,0xfb75111f,0xf3d51111,
0xe7ad124a,0x1b72fc7a,0xf7b8eedb,0x0cf3f951,0xecbf002b,0xf1fc13b3,0xfa0c0903,0xf4310e35,
0x0d0df29e,0xfbb6f703,0x2740fa5a,0xf65de269,0xfaa408fd,0x0a5610ec,0x22d5e1de,0xfc34fda6,
0x16d7eeb1,0xfe26e8a5,0xed1a13fe,0xe37a17e5,0xf649093f,0x12df02f2,0xf508fbb4,0x04350c4e,
0x0a49f7c5,0xf596f638,0xef130f39,0x0a63046f,0x1d0ce586,0x0e61e41d,0x0a29faa7,0x0ffaf47b,
0xf40efeef,0xf61013a3,0x00c3fce2,0x0d10fe22,0xe736fc9e,0xff4c0e51,0x0c1df292,0x185af49b,
0xe76af513,0xff9e1c7d,0x1565f0a9,0xf22af823,0x016a1c6f,0xff56f5e2,0xff8c0337,0xebc703f5,
0xf5541011,0x017902e8,0x151ae775,0x0139eddc,0xfe01053b,0xe1f82199,0xf0f5095a,0xe8622003,
0xe5e51879,0xfcb81937,0x004ef8d8,0x02defa1d,0xf13300a6,0x0331ff94,0xe38a0570,0xe3a81d0f,
0x01c31ed8,0x1e09e0d1,0xf708ff05,0x02190b4e,0x19c8f323,0x055df9af,0xf7200529,0xec940f7b,
0x285fec35,0xf071eb99,0x0d81fafe,0xfb81f4ff,0x0086f757,0xfff0fbac,0xf75709ec,0x2cfbec52,
0x09bce92d,0x046b0a8e,0xfa9f07c2,0x205bf376,0xfaf80016,0x092df755,0x05ea0373,0x0c5ddd14,
0xd42609e7,0xfc6609a4,0xfeb9fdaf,0xf35c06bf,0x056f009e,0xfe690f9a,0x26c0f115,0xfd8702ff,
0x0be8f8cb,0xfe5803d2,0x11bfebf4,0xff56f926,0x0110e9b6,0xf4060cfe,0x02e0ff19,0x0975f018,
0xe8460ab1,0x098efa5f,0xf89b0d50,0x17f0f785,0xe8c115fd,0x2664f641,0xf91cf2ff,0x02e30151,
0xfff007e6,0x0532f15d,0xf4a4ffd4,0xe7e9122f,0x1357ffa8,0xef6ff7cc,0x0daaf3b4,0xf87b07d6,
0x26aedebb,0xeb5ffc82,0x00381115,0x020c0abe,0x099f0284,0xfddd02ae,0xfc0afe32,0x0dbefd38,
0xe87509c2,0xf9f6021b,0xe38e10fa,0xfbee00e9,0xe95b1307,0xf8a11056,0xfa200a49,0x07abf04f,
0x0c3c0643,0x1089f00c,0x1231f37a,0xdaa71136,0xea1b1c6a,0xe66e159b,0xf0410750,0xf4cafdcb,
0x03270590,0xfc8b0df8,0xf82b027f,0x05c80c2e,0xeded0c7b,0xf8e40cfc,0x01680e1f,0xfcaef1c5,
0xfd4e0d22,0x0799f5d2,0x0734f9fc,0x1b72de76,0xed2607e7,0xfbc4f9f5,0x0a2ff7ba,0xe5c30105,
0xf1511760,0xfa121861,0x084406b8,0xf9ae0519,0x189dfd4b,0x15a2f3d0,0x02d9edaf,0x11ee03d0,
0xfd80e379,0xec810abe,0xf50301ec,0xf18e0996,0x0e6ff20c,0x01e9f488,0x058dfedd,0x0d65f20f,
0xfd4b0ef1,0xec4a175d,0x1a3d094d,0xf074fd1e,0xeab016da,0x01adf731,0xf4df04b1,0xe27d0992,
0xf62c15b1,0x1aaaf2fd,0xf889e9b9,0x101a0f6b,0x0ee8e8ae,0x121ceda4,0xfd54f77e,0xeea71491,
0xf6870ca9,0xee2111ea,0xf3fe1bda,0x0d4def01,0x1726f57c,0xed64efc4,0x02f50c13,0xfee10534,
0xfaa50421,0xe4a00dfc,0xf1271a46,0xf78508d1,0x0128ff8e,0xf1e400a0,0xeefb0773,0x0d4307b0,
0xe47d02e2,0x07dd16dd,0x110ff549,0x2041e969,0xe463f480,0xeb5b1f90,0xe84a15bd,0x06a403f4,
0x28f8ea7f,0x1044e424,0x2088f0ca,0x1c1eded9,0x0cdfe693,0xf4520713,0x1664f6f7,0x003deea2,
0x1421e63c,0xeaaa1275,0xf2db08f0,0xe141175f,0xe92c1a5d,0x09130e2b,0x115ef081,0x0df3ee18,
0xf801fcb3,0x1ce8f7ee,0xded10118,0xdbcf1cf8,0x0fb31e56,0x0b88de8d,0xf68f0eac,0xf5ff0243,
0x02371155,0x08e5f2d8,0xf51f023e,0xeec103dc,0xf38afda1,0xd9f72965,0xf84906ca,0xfd491c06,
0x0534fb43,0xf1d0165c,0x085dfd14,0x05bcf888,0xf0c7f9cb,0x02bcfdf3,0xfe53f3fc,0xffaff408,
0xf0961acd,0xfeb9fd50,0xf5812af4,0x1748f352,0x0e63003a,0x0556f0c5,0xf3720eed,0x01040039,
0x0391f2e3,0xf146f9ce,0x03e1e836,0xe48d1099,0xfd9efdef,0xeece19e2,0xfae808e3,0x03ae1a8c,
0x0ce4f49b,0x130d005f,0x0c85eb02,0x1281f544,0xe05cfc7b,0xe2ae195c,0xf4921f1a,0x095ff599,
0x1a73fafb,0x070bd709,0xec161457,0xf2ce04d3,0x082c12b7,0x159ee1c4,0x05a6f1eb,0xfbc509d6,
0x0313f90d,0x06af0440,0xfe1ff0f4,0x045b0eb6,0x13c1e085,0xf8e3139d,0xfe7df3c8,0xfb2e11e3,
0xe05a0bf6,0xff31130f,0x0e5cf21d,0x18d8df72,0x0589f9e3,0xfdc2fab8,0x04ce1217,0x0fb9df11,
0x06d105eb,0xf7b4f145,0x0e93091f,0x0f73e021,0x075bf5e2,0xfbfc0160,0x1389059e,0x0368f853,
0x1183faa9,0xfbfdfbf8,0xf733fe79,0x098afcee,0xf005f419,0x0ee4091c,0xe1f8f368,0x1285119a,
0xfe01e606,0x0a9f0d58,0xff14f9a3,0x02210c7b,0x16d3f37e,0xfbbcfc34,0x058d0eb3,0x01f5f2e4,
0x069405a4,0xfa16e6fe,0xeb4008f5,0xe5621639,0x0a6405d3,0x171eeb12,0x19dcf18a,0x0c2be4c2,
0xfe6a043b,0x0936f6b2,0xfd8df51f,0xfe9910f1,0xd4ea1176,0x0d3919c1,0x08bef684,0x104d043a,
0x0f6be558,0xf4ed03c4,0xfb56f51d,0xf215fc05,0xe9070ee4,0xd84d199f,0x149711d0,0xefdd02a7,
0xfb370fd1,0xf2b00fd2,0x10241132,0x09a5dfdc,0x065c0d38,0x1c61dff6,0x07bee6c8,0x09f8f001,
0xef1c0433,0x1941ef65,0xd6fc0bc4,0xf2e21b84,0xf2c00fd5,0xf54517d6,0xdb1e17e6,0x05e4124f,
0x100ef491,0xf441020f,0x1151f1e4,0xed550566,0x067a03ce,0xfb69021e,0xfc57065a,0xfc5e0078,
0x14ccf95d,0x0bccf150,0x06f1ee38,0x0ff3f1b9,0xf5620154,0x0e93efa6,0xf2b30c2a,0x00b1fcd0,
0xed090c9b,0x098e0931,0xf6470258,0x036305ca,0x1968000c,0x097fe6e8,0x0e84f7a8,0xecce03a3,
0xf6120a67,0xfde20a35,0x03c7f444,0x0711f47a,0xfa6eed88,0xfce524b1,0x049be598,0xf39f1e67,
0xe55c09b0,0xfc8008d1,0x06b0fdb7,0xfb61fcba,0xebc31671,0x0268f9c0,0xefb01e7b,0x1397e80a,
0x208e0a04,0x0614cd9c,0x03c91736,0xf32af3b4,0xfdc20eba,0xf7c9f939,0xf13016b5,0xedcf1034,
0x1312ed9b,0xfb80fd5b,0xf4a5ebde,0xfd622595,0xfedff03c,0xffb61644,0xfeddfc13,0x01061308,
0xfa53fa64,0x11490942,0xea93fc36,0xec1a083b,0x00fc17c1,0xeec5e8da,0xf25d1bb7,0xe518ff44,
0xfd272356,0xfaf2e88e,0xf4e923ee,0xe9e80522,0x07d022d7,0xfcaa0540,0xf87afa50,0xfd0c0def,
0xf2adf798,0x04d209d3,0x166fe3b0,0x186aebef,0x073dd9f7,0xf6a217ac,0x022af993,0x151afaf5,
0xf0d404c7,0xebbb0d83,0xfcbc1c97,0x3155e216,0x17a9e14d,0xf26cf229,0xee9622d7,0xe82d0162,
0x005d178c,0xed10fe02,0x0688ff38,0xfef5f9ca,0x1dd2ee37,0x0d96e29f,0x167df107,0x075cfcb0,
0x13b5f055,0xef1e0896,0x089e0097,0x17f3f7cb,0x0413f5a3,0xf76402a2,0xead90e29,0xfd7e11b3,
0xea4d0566,0xffbd08e4,0xfaf20208,0xfe1efa2e,0x0539f571,0x1180e53e,0x20e5e801,0x00fbf75c,
0x06980692,0x0ef1f9e8,0x03e1f9f0,0xf837147e,0x01fc0111,0xfb8f0f3e,0x0aa8f4bf,0xefa6f79c,
0x01a30045,0xf661f5c0,0xf6490edd,0x0f17f896,0xf501f0a7,0x047b07c2,0xef991058,0x056209a7,
0xf0cc0e88,0xfc921769,0x114cf2e3,0x1420f422,0x0d9ce31e,0xfd2ffdd4,0xfd59f56e,0xf6f70d72,
0x0411edad,0xea351175,0xf67d1052,0xef150e1a,0xf6480bd3,0xe0fb160d,0xf47d1926,0xfdd9058f,
0xf826087a,0x0c13fcd7,0x1792f3f7,0x074cf154,0xff290422,0xfce007df,0x05b4f4b1,0x00e9fbae,
0x03a1f994,0x0848f0ae,0x0cc2f146,0xe8990d0e,0xf9090d98,0x17e6f9e2,0xf99df28d,0x033305d3,
0xf57b07da,0x0bde0055,0xf701f145,0xefef1772,0xfd950d80,0x1c0befbb,0x1f44f0ac,0x17f6dcc0,
0x0f69edd4,0xff7bf751,0x00e0f61c,0xf0d80611,0xedbc100f,0xea79106e,0xee2e0e44,0xe725270e,
0x0c8f051a,0x1131010e,0xe8c9f3df,0x1a6602fb,0x1707e2c8,0x16a3e546,0x045df08a,0x116cf197,
0xf0cb0589,0x00e9faa6,0xe3f6232a,0x0ffef62e,0x0992fd54,0x0defec97,0x0a49f0e7,0xf6aefbfb,
0x0d6f04bb,0xee2608e8,0x180cf98e,0xfbbfff88,0x1ae7f359,0x01fff770,0xfec3f516,0x03b8fe14,
0xfb0df206,0x1934ffd0,0xf76ee7ce,0x11330fea,0xdc33031e,0x02d319a5,0xe69210e3,0x138401ea,
0xfa11f40d,0xf9a8ff85,0xe0a41879,0xf37f0942,0x09591065,0xe938f05d,0x11dc14e4,0xfd79f125,
0x12b105c7,0x051beba9,0x09d1068f,0xecf0fdb2,0xf1e01240,0x007c0c7e,0xe4d1f23e,0x05481d39,
0xeceaf80d,0x08e601f9,0xfbc3fd14,0x083e0810,0xfe07ffcc,0x23def4df,0x12fbe304,0x149de8a3,
0xf7fd0c3b,0xeaa3f37e,0xfd2e1b31,0xf16c0169,0x00ed09bf,0x0adef384,0x0bf7fb66,0xd8710b08,
0x272605e3,0xf154f2ad,0xf8cb03bc,0xeec012cf,0xdb931579,0xe76b182a,0xd52a2892,0x0770185b,
0xe8b9fb57,0x0b8915c9,0xe166070a,0x3493f653,0x327fcc9d,0x033fda52,0xf6fe0f9a,0xfc3cfe22,
0xff73fcb3,0xdd8afec8,0xf1e4301a,0xebb1f951,0x23eb0f57,0xeca9fb04,0x045d1659,0x08abf6b0,
0xfc6af9ed,0xf7140875,0x183fefef,0x0773e909,0xe535f962,0xe6782dd9,0x0d9500fc,0x1696e233,
0x0ba0011b,0xfd99f5cb,0x100df949,0x1d85e8ef,0xf40a0279,0x1016ff1e,0x0c65f747,0xed47fbdd,
0xf94c150b,0x0056ffab,0x0079ebef,0xeeed0b0e,0xfcea01d7,0x09b3f384,0x3237dd51,0xfc6aece6,
0x02060cd5,0xf8301373,0xf8620e83,0xea0f0e8b,0xfdfe21d7,0xfd39f057,0xe1a512fc,0xf1d70e0e,
0xf4ac06c3,0x1722eb43,0x0990ec8a,0x1347f6e1,0x0dfeddc0,0xe93d140c,0xe2710ef8,0xf94336cc,
0x1f78eb7b,0xf7ae01b9,0x0f96f8a6,0xf31b0434,0xfd0df23c,0xf7300a8e,0xefd00486,0xfd78fa81,
0xfb970ef2,0x01240058,0x1a05fc9f,0xfab3f8f4,0x02700f05,0xf807fbdc,0x165401db,0xf37adb12,
0x06d70d4f,0xf94bfbf8,0x0624f74b,0x0dcefac8,0xf8e4ff43,0x1e05fc4c,0xfeceec9c,0xf6bf1e6a,
0xe22501cf,0xfe002e90,0xe489f032,0xf173211f,0xfa94fc9e,0xf87ffc92,0x0775f5af,0xf3860048,
0x03e90d95,0xf1db0539,0xf5a22a57,0x00bbf640,0x1eadfd17,0xfa2ced78,0xfd24f7ad,0x023e020b,
0x0b38f2ee,0xeb6012a3,0x09bffe39,0xf8861145,0x1a47ed5f,0xf7940295,0xe3a0fb15,0x01db0bf7,
0xcfb70e51,0x1061198c,0xe590fb6c,0x10110af3,0xe28e07dc,0x0dd51196,0x057cffaf,0x00f6f7a1,
0xf9340e63,0xf4e402d1,0x04d202c0,0xe50706d9,0x091e10da,0xf84af6de,0x1055f64b,0xe1af0156,
0x14befe8b,0x0031fa30,0xfef6f7fd,0x07d90819,0xfbe0fb98,0x233702da,0x054fe480,0x1c4e04b6,
0xf9e8e92b,0x1362f46e,0xdc5f01f1,0x0a570b4d,0x0a9feee4,0x00d5eec3,0xebf01d62,0x2211f8c3,
0x1c2ddcf9,0xe80df910,0xe4d02658,0xff1e11a9,0x19ade838,0xf2bd026e,0xfd890475,0x005a08d9,
0x0010f7ff,0xf13c0bea,0x18e6e7b1,0x2816db9d,0xe556fb56,0x05021795,0xef280915,0x0dd400b6,
0xd4e61c70,0x00221021,0xd9881541,0x00ac0948,0xe620104d,0x0f99fbb3,0x163eeea9,0xf3a0fe9a,
0xf2a21370,0xee2f0a36,0xfb2a0765,0xe790ffea,0xfbff1a8a,0xfc140d38,0x1cedf58f,0x02f0ef28,
0xf9870cc2,0x1586f130,0xf4aaf6ae,0xfb5b0649,0x0a82f413,0x1ab4e957,0xdf97ffc6,0xfd331fc9,
0x13a6fe5e,0xf5f2fd0e,0xe5861c58,0xf0dc1297,0xfe280133,0xffd5f6d1,0xe2e9147e,0x15dcf16b,
0x131ae522,0xf64efa16,0xeeb717a6,0xf8810ab3,0xf32e1249,0xfc780bc9,0x03fb13ff,0xff030076,
0x1071ff3d,0xed930198,0x0a9a04c1,0x127cd773,0x16daeb9f,0xef3ce32f,0x0cb909df,0xeb2cf907,
0xe3ad212b,0x0b560b00,0x1116fb8a,0x195ef071,0x0d33f107,0x1c96eeb4,0x023af285,0x1074023a,
0xfd3df20b,0x01a20481,0x035bfe14,0xf4acf47d,0xeaac07ae,0xea2e0be7,0xfeba0902,0x022df61e,
0x1d3bffcb,0x062cecca,0x23fff8db,0xf491fb3c,0x0723118e,0xfa16f6c6,0x090101fd,0xf47df45f,
0x07f60557,0x0053f1cb,0xe3acffc6,0x055a0e26,0x0175f787,0x1594f35a,0x2179efc7,0x0c84ee25,
0xfb30017c,0x0a4b0460,0xf6bdfca6,0xf43607d6,0x0dd90c0f,0xf273f14b,0x0954007b,0xedfbf676,
0xf4fb0dcc,0xf033117d,0x0f87013c,0xdfcb06c6,0x103413cc,0xfd600110,0xee78f82b,0xed422612,
0xf81908bd,0x161ff64f,0x0c14df4d,0xf6990dde,0xfbfbfaa7,0x138a0469,0xfac7ed04,0x0537f7cb,
0x09cdfb6f,0x033df4d9,0xf50b11c6,0x178400f5,0x008afaba,0xf5360971,0x03561a95,0x0638e202,
0x13dae73a,0xea81f449,0x0334f357,0x10a2f770,0x19dce72b,0xf8670b6b,0x19d8ff4e,0xeb901448,
0xfc71f618,0xeaea22a7,0x041d0103,0xfc0103d0,0x0793fcc1,0x1272ebd2,0x0b08e6ba,0x0d62f561,
0x0143ea03,0x1c1ce42d,0x05b404cf,0x0f19ec5b,0x08620221,0x1e57fb5a,0x2257dc47,0xea6bffd7,
0xf4ed0b25,0x06f7fb3a,0x0535e29d,0xe1a21b97,0x085efecf,0x1c6c0190,0x060fde7f,0xe4551d22,
0xe4a31fb6,0xf7980d3d,0xf138014b,0x02900a8f,0x0721f1ca,0x0025ee8d,0xd0b532b9,0xfa091240,
0xde751cce,0xe69c1ad9,0xd60f2635,0xeeb01e75,0x13b9fe73,0xf73ff4a6,0xe8a50de0,0xf925150f,
0x14fce6c4,0xec540bed,0xef3809fc,0x0a70047d,0x04b2fac0,0x10feff67,0x1de3d72e,0x241fe9c2,
0x176edd5a,0x05d9f0e9,0xfb1207b0,0x23eceb5a,0x0588ecb1,0x011d02c8,0xf01a0728,0x15c3f9d5,
0x1344eb48,0x13ffe619,0xfbb9f88c,0xeda11528,0xdf5d12ac,0xfb2c1e1b,0xf9f0fa29,0x08d4f52e,
0xf374ff3c,0xed38111c,0xfa820904,0xf4b30a47,0x07330c06,0x0155f4ca,0xe791205d,0x0222ff98,
0xf85e07fb,0x009306e6,0xfdecf5fc,0xffb2107a,0xf4e6f67e,0x06ad0584,0x2012e706,0xfefff6c0,
0x0d46ec97,0x07c6ffea,0xf59dff59,0x0592fd1e,0xecb609e7,0xf41a0f50,0xf49311e4,0x0357f844,
0xf56b0cfd,0x1148fb15,0xf705086d,0xf525ff91,0xe3cb1783,0xe77c1206,0xff15ff03,0x1904f8ec,
0x12f3f4f4,0x18a3eaba,0x0254fdcd,0xfc730a7b,0x21a7ee60,0x09b2df3e,0xdd5c0835,0x0239071d,
0x0f59ebfd,0xfd0bf04b,0x04c60895,0xfc740c2e,0xf40f1293,0x1064f855,0x052aff78,0xf98afdfb,
0x0981049a,0xe3e309a7,0xf5f010ba,0xfcf2f844,0xe91905b6,0xdcd50d4a,0x0d371390,0xfeccf3d1,
0x024309d4,0xfb380d0d,0x14f80114,0x0b83fd17,0xf9150637,0xdd290f2f,0xf1fd0917,0xec4e051f,
0xe6c60a70,0x09680ac8,0x08b8f713,0x0ac3ec65,0xfcd20475,0x0f3ffcb3,0x02f5fa93,0x1bdaef9c,
0xf980fafb,0x0c3d0746,0x1c79e4df,0xfe9eeecc,0x04c4148b,0x0c54eaa6,0x0c4ef4d9,0xc69909d5,
0x05ae29aa,0x000de663,0x0143044e,0xf0c4f968,0xe78217b6,0xfbf70bcf,0xfd0b0521,0xff2118ac,
0x0665f243,0x2754fef2,0xfbe5e564,0xea3c1ba2,0xfa0cff4a,0xea190c1d,0x078600da,0x07c3ed9b,
0xebc4fa20,0x08f507fa,0x08f001c9,0xedfa09e9,0x26a0fa12,0x0dece842,0x07a6f93f,0xf66d07a4,
0x073effc2,0x0b32eac2,0x1941e197,0x038df755,0x02baf690,0x1afbf80b,0xee8efae8,0x088b0a57,
0x0a4bfe8c,0xf5ac001c,0xedfd1689,0xf4ca0a79,0xd4c70c1d,0xec281b4c,0x01f103cc,0xf22bf975,
0x07c30ec6,0x01f9009e,0xfb48f799,0xf7651ba9,0x151c042a,0xfc12fda5,0x063bf6da,0xf18e1541,
0x0251f127,0xf65b05c6,0x12fee88b,0x1b81dc4d,0xfcc0f2dd,0xef2d0124,0x03410a4e,0x18cbff21,
0x037bfb9d,0x1baef501,0x1547f458,0xfafaf2b3,0xf05d1119,0x089e0362,0xf806f0c1,0xf6d30ea9,
0xf2c30648,0x0810fa77,0x01b6f82b,0xf46806aa,0xce031476,0x0d1f24eb,0xefefef3e,0xe85b1deb,
0xf9c71e1b,0x0742fe16,0x01ebf58a,0xf4da0309,0x2007f2b7,0x10f9d900,0x13f60142,0x07c9e6a4,
0x05f803d9,0xfb3f0643,0xf9d2fdc6,0x0893071a,0x1325e95c,0x0d46f387,0x0647f2ae,0x136af457,
0xf97bedc0,0x099f0e82,0x027aed45,0x0b26f71e,0xfe86fed9,0x0404faaa,0xf6a9039c,0x1b03fc9f,
0xfe6be99b,0xde4715e2,0x04b11a06,0x1432e8da,0xfa05fa7b,0xf3960e44,0x1424fd46,0x0619eecd,
0xf5df0aad,0xeea80d31,0x01e00bc0,0xfd74f4fe,0xf92dfe35,0xf98e090c,0x155af5ec,0x1321dc15,
0x00310643,0x158af31a,0xf8a6f73c,0xfe6e1104,0xf53210b6,0x1a75ec67,0xf632fd69,0x06c8f667,
0xf82f00c8,0x03200136,0xfcb4e9f6,0xfd3c0f26,0xfa2c0cca,0x0309027f,0xf96c0e36,0xfb67113d,
0xe9f6faa0,0xd2fc28bc,0xfe5a0ccc,0xfb670205,0x046bf8ac,0x01bcf566,0x2200f2b2,0x0660ee79,
0xf5fd0914,0xff4f05b0,0xf55b12f7,0x17e7e5e5,0xf25006d5,0x059b0254,0x1cc6ed1a,0x2b6dd29f,
0xf513f1a9,0x091efce1,0x0caff721,0x1ba2f150,0x118ce32f,0xdfac1276,0xf3a01d1b,0xe8d1177c,
0xfb2006ee,0xec5f07dd,0x0646f974,0xf3ac01b0,0xfd9d05f2,0xff070b69,0x05520226,0xfbe5f931,
0x0a5309c1,0x0289f2ad,0xfcb009a3,0xe9c0f691,0x02a9222d,0x169ed8e2,0xfec7ff46,0x0770f3ee,
0x1d9feee6,0x232fdea7,0x08b9e54d,0x10d2f9cc,0xf4aafb00,0xe95528f9,0x0daffbf3,0x0bc905bc,
0xf26cf104,0x11170c06,0x1440e11c,0x0698e546,0xf978f757,0xf0b10904,0x06ff11fb,0xf5a0f1d1,
0xf8e41708,0xe470010c,0x079b1714,0xeaf6f2ab,0x15731584,0xf229fa7f,0xfb5615c7,0xede90bd5,
0x03a91131,0xf97b04be,0x040df95c,0x0985f191,0xe6bef521,0xf7090d68,0xe3cdfc49,0x10d21ec5,
0x0bffeacf,0x10ae07d3,0xfba4ff33,0x2438fb23,0x0fe3ddd5,0xe3690700,0xef460aee,0xe6ba1275,
0x1ce1f249,0xfbf6e0db,0xf4ad1593,0xe1a91dec,0x0cc41153,0xf5250282,0xf0730e9f,0x06e60e4a,
0xe75404d3,0xfba60fe2,0x09e0f282,0x0709f2b0,0xfb9eeeae,0xeafd184c,0xf6641ca6,0x0d1bf6ed,
0xf26305c2,0xee1b0b32,0x1c9b066f,0x0bb7e5a2,0x039cf14d,0x193beebd,0x2527e0ca,0x0b0adeef,
0x006cfa1b,0xedb71f2e,0x0063fd62,0xfa910804,0xf3580377,0xfdf3199b,0x163af3e3,0x0c74e975,
0x1299ed9d,0x190eec32,0xec83eb9e,0xfd850920,0xeb800c82,0xe4f91bf6,0xea8216ce,0xefb91e2b,
0xefd8114d,0xfbd7167d,0xf741ff9d,0xe7bd0a4e,0x084f0eac,0xfd0bf537,0xe12209ac,0x02aa1282,
0xfe34fd19,0x093ff028,0xdb0019ab,0xf6872526,0x0659fa94,0x046303e9,0xfb85f63e,0x04f60bcb,
0x133bf098,0xf1acf852,0x0fc6ff94,0xfa48f5d9,0xdf120461,0xdb2b280f,0x012a1bf8,0x0309f718,
0x083f00d3,0x08eef60a,0x055403a1,0x268bee6a,0xf045ea1f,0xf39c1238,0x011a19b3,0x1050dc27,
0xef87fab3,0x028c0a47,0x06acf2bc,0x07bef333,0x0a9ef95e,0xf70c02e2,0xfdf3170c,0x0f7cfde6,
0xff4ff838,0xf7640586,0xe50d0bdc,0x098c03a5,0x0501f4df,0x04c4fe77,0xeb3ffb68,0xfbad192a,
0xf910002b,0xf3d90d82,0xfaed118e,0x016f017b,0xfaf5fe45,0x151bf681,0x0a54ec47,0x00cbf2ad,
0x0add125a,0x12fedc46,0xf798fe8f,0xfd15078f,0xee6a102b,0xf5d00b8f,0xf8770ca7,0x0062edc1,
0x073c0145,0x0489fce9,0x2b08e36b,0x1226ee1d,0x068e06b5,0xfdbbf60a,0xf3b20a02,0x032b08c1,
0xea3aefd3,0xf5801dd2,0xeb29ee4c,0xfb891635,0xfb4907d0,0x125904e1,0x214fe015,0xf28b02d0,
0xf3421003,0xe2790e3c,0xf51b2dbe,0x014fe68a,0xffa81738,0xf4bdf075,0xd7872774,0xfdc70911,
0x0f440259,0xfa07e7ab,0xe8ef15b5,0xe9ab1aab,0x01acfde5,0xe061183f,0xf1960e28,0xe4821db4,
0x12ef01a2,0x15abf23a,0x29d3e192,0x232ce6fb,0x187eda69,0xfc51f23b,0xf4c9153c,0xff84faa0,
0xeb130474,0xfba71268,0x13fdfa0e,0xfc14e938,0xf733102e,0x078df805,0x13ccf653,0xeb77f821,
0x01f20cdf,0x0f0af322,0xfcdf0fe0,0x04a80003,0xfcaf03b4,0xfd500258,0xfa12f658,0x03760443,
0xfb3cf632,0x15e1ff1f,0x17a5e711,0x0609f45a,0x041ff3cd,0xfdd30abb,0x0df5fa40,0xebdcff60,
0xf3641198,0x0236004b,0xff70fb23,0xf0d90cb1,0x205afeb8,0x0b7fdcd1,0x0425ffa0,0x112aeb6e,
0x1d6de72d,0xf7c5fc73,0xfd4006fc,0xfe22fe3d,0x1379fe02,0x080cece5,0xf13effda,0xf45620ae,
0xff2ffba5,0xe4d11027,0xd5662b77,0xfac31bec,0xeb7009b2,0xf9120f79,0xee0eec1b,0x01961388,
0xfe02f2ec,0xf808087f,0x1171f6c8,0xf5fefa9c,0x12eb0afb,0x105bf9c8,0x2762ea94,0xf932ee24,
0x0cbc1962,0x0381dbff,0xfcea0429,0xeb2dff4e,0xf3ad0752,0xe5fc0cdf,0xf6e00995,0x105efc6b,
0xf590000d,0x11f30be9,0x1b88e540,0x1c48f601,0xfa71ec32,0x1570056f,0xf9edee6d,0x11ad0447,
0x0617e1fa,0x020cfbb9,0xf5760148,0x01080caf,0x1618e6fd,0x157aea74,0xf801f7f3,0xda9c1634,
0x0dd70bfa,0xf7fcff74,0xf5051666,0xd1812837,0x071817a6,0xffadecf5,0x00a80c97,0x06bfe5c9,
0xf9bbfe1f,0x0faaf7f4,0x000bfc2a,0x18cdf4ff,0x15f1e000,0xf8ecfce0,0xe482166d,0x013a184e,
0xe3d00106,0x02ec1e91,0xff07f795,0xe78d10bb,0xedbf11e6,0x0be8026d,0xff8de775,0x0682fb79,
0xf6e208eb,0xef550c1e,0x019a15ee,0x0bc6fdb4,0x0bb9f525,0xf43500fc,0xfb640868,0x0284f1d8,
0x1d52ef18,0xe938ebfb,0xfc321961,0xf2c51274,0xf72513ce,0x15daf7a1,0x17a5e549,0x28d2deac,
0x08c1e02f,0x2adbf78a,0x092dcd82,0x2d6ff09e,0x0b44d4c3,0x15c6f80c,0x07e1f1e2,0x05adf694,
0x0b49ff8e,0x022af58a,0xe5ea25fe,0x071ff929,0x090707a5,0xf3edf308,0xe7fc11c1,0x0c3bf85a,
0x16b5e4e8,0xf099fb18,0x1d27f93a,0x18a5e9e4,0x13d7e966,0x0e2204ae,0x11b5efc0,0x0aeef133,
0xefef0b66,0x0fbdfd6f,0xedcdeffe,0xe644186e,0xd345184e,0x0df311ed,0x0e6af738,0xe6d70169,
0x08b91594,0x06390171,0x1029eaec,0xf053019f,0xfe110aac,0xf7c3ee80,0xfe0a1003,0xf1fb09e8,
0x0a3ff874,0x08f4023c,0xfe5cf559,0x077ef9ce,0x00e909d1,0xfa120090,0xf18111f3,0xfdf81111,
0xea9b05b8,0xfbce0181,0xf5a213a9,0x0846e4a4,0x0969f9ca,0x0d75e909,0x04fdfed6,0x28f0f8ca,
0x2b45e321,0xf091eff3,0x03ef10a9,0xfeb2fd2e,0x05f5ec1b,0xe7f00b51,0x05b4024f,0x151ee974,
0x0be5e9ae,0xf5dc02e9,0x11a9f9b0,0x0e110288,0xe57a09bb,0xf6da18cf,0x228bf390,0xf54af2e3,
0xe5bf1af1,0x07a707fa,0x09a0e953,0x0088efb7,0xf6bc01f0,0x0945f850,0x013bf723,0xf2511181,
0xe2e01c79,0x02d61176,0xfc760eb5,0xdea9155e,0xfda81f3b,0x028cf50a,0xf948f852,0xf2a00167,
0xff33ffd7,0x025df154,0x0a8bf912,0x0cfd0026,0x23d3dba4,0x10e2fe50,0x1029f3b7,0xf5790bed,
0x01dd0846,0xf31e0332,0xfb23fa83,0xf705fac8,0xee4b0415,0xf9e208d9,0xfa641274,0x0975f7a1,
0x11daf7b3,0x1893f39a,0xf1ebfb8a,0xf5bd08df,0x00260715,0xf3f3fbbd,0xf8221672,0x068e0056,
0x0ffbf4e9,0xf93a0264,0x03e0ff4f,0x08acf3f1,0x0c26f9b5,0xfe9dfa0a,0x0330eba6,0xeb0b133b,
0xfb8efcdb,0x11050480,0x0aecf23b,0x05c8033d,0x0ab00196,0x2a35e30c,0xfc31e476,0xee8b1125,
0xe9d2152f,0x00fef6ce,0xe5f60913,0xf1661050,0xf5c512bb,0xf5d813ab,0x0b490494,0x05a10229,
0x1101f8d0,0xf7d4f79e,0x0df401c9,0x1d5dea96,0x1249d01b,0xd43007b9,0xf9b40acf,0x1123fa99,
0xf55403e1,0xf9f00dd5,0x01dd1120,0x132ef930,0xff20fa89,0x140afad3,0xfcb7f60a,0x15f1f460,
0xeb9af491,0xfe4aff1d,0x0577fd0e,0x01a80306,0xf9fcfe6c,0x02220e11,0x0bd2f5db,0x031af9e7,
0x1417fb1e,0xe81dfdd4,0xeb340e87,0xdcf81c7d,0xed941039,0x03080b6f,0xf8080487,0xf0fe13e1,
0xf67d0e3c,0x09d1f7b1,0xfce7018b,0xe2fa0892,0xdcf432ad,0xe8950ba8,0xcf2d325e,0xfce40df8,
0xf5a00a9a,0xfa3a0662,0xff3805c9,0x082af098,0xfae4fb21,0xfcfd1390,0xf4ed0014,0x0c530d72,
0x0b1de993,0xf34b0b9c,0x1772ef32,0x1318ed24,0xfd0bef9f,0x00300437,0x0e76f393,0x1d58e491,
0x052ef3bb,0xe10113f4,0xffec1648,0x1268f03c,0xf760fb3f,0x0359fa8c,0x20acfa68,0x1909da74,
0x0903f52a,0x2664e91a,0x19cee762,0x0bc3e77f,0xf33109c9,0xf1340c5f,0xf47d07ea,0xec1c004b,
0xf5640697,0x08a70189,0x1382ec1c,0x037af56e,0x1024fb92,0x170af122,0x125cf131,0xea140780,
0xecfa1dfc,0xf6e20f04,0xfa94f850,0xd51921de,0xf64113ae,0x21f6ec3a,0x1a8be0ce,0xfb97eb3a,
0x095e0411,0x148bf741,0xf94bfae1,0x1637f948,0xe79305f0,0x033dfadd,0xfd370677,0x064eef4b,
0xfe270698,0x190af33b,0x04c6f203,0xfc25f84f,0x0ac3172f,0xd92a08f4,0xf7de1c9a,0xf9f2034f,
0x01def5bd,0xf771f8e8,0x0a7bfb36,0x0d29f64f,0x1662e3e3,0xf01a0f5e,0xf6ad0841,0x07741801,
0xf504005f,0xf760ff1e,0xfc3803fb,0xeb7b0312,0xf08607a5,0x057b09ef,0xe54502b6,0xfb521140,
0x130d0c89,0x03c7efa9,0x0d4f00d4,0x002bfe71,0xfbff00a0,0xf686ffb9,0xfaa903d2,0xe6c10726,
0xf544127d,0xf04a0788,0xf2510752,0x0bcf0874,0xfb0301e1,0x019f04ff,0xea580a79,0xe8fb1c58,
0xe9ee0e56,0x04d710cd,0xf1910749,0xfc4304db,0x028d01af,0xf96df78b,0x0a32f90b,0xfd17034e,
0x051bf808,0xe6f4077f,0x12c60c32,0x0a53edb9,0x2b44e66f,0x042bf6ec,0xf827f894,0xee5a0da3,
0xf4320ea0,0xf7d0fed4,0xfac8127d,0x17f7f519,0x0c16e604,0x176ced2c,0xe77c0974,0xf920096c,
0xffc603d2,0x02d002c4,0xe9a101af,0xfc261570,0x0161fb0c,0xebf7095e,0xeed519cb,0x06f7f9de,
0x17d3ec1b,0xf1261072,0xeb0305e9,0xece02407,0xffe11380,0xe9b50550,0xed760e25,0xe3bd10f4,
0xf72f082c,0xf319fd6b,0xf3a4050b,0x1f7efb97,0x1a03ec87,0x1061efba,0xf27b0840,0xfa7e129c,
0xe7431435,0xfec1023e,0xf5ff0a36,0x0cf5f874,0xf44c0287,0xf6540b04,0xf7ab095a,0x096cfe4d,
0x012bea52,0xe94c06d4,0x05eb0a39,0x149cfdbb,0x1109e88d,0xf6180c43,0x213cf262,0x1f78dc5b,
0x1219df3c,0xf436ee6f,0x06650e1e,0x0e6af856,0xf17c007d,0x0501105f,0xf56b08a9,0x0de20218,
0xe29c089a,0xf31c0c2e,0x0ee4fbdc,0x1be0d9b1,0x1810e4cb,0x1f53e226,0xf47602e4,0xff54fcdf,
0xe6e021e2,0x02900936,0xe1ee0f2d,0xda7f2293,0xd8722a08,0xfd001a7b,0x091de0dc,0xe2ee0c8f,
0xfbc808c1,0xf5251266,0x00c8fe1a,0xe95c1c71,0x27830189,0x14acdfa8,0x20cbe8b9,0x19b9e1ab,
0x14acdf9f,0x0774eba2,0xe91b0c1e,0xf0bd0ceb,0xff3111d6,0x0d49f21d,0xf35904e9,0x0c21fc74,
0xffebfc83,0x0923fbb8,0x069709f8,0x2549dd86,0x0a29ec7a,0xff62fa64,0x0942fdd2,0x06a7f6a7,
0x0420f3b7,0xdeff0f3e,0xf85e1389,0xf2030c10,0x18b1f60a,0xffadf2ab,0x0e90fc55,0x0086fc40,
0x0991ffdd,0xff0c02ae,0x0b0f00f6,0xf4bef855,0xe7471e11,0x0cb7eeb8,0xf6890629,0x0ccdebc0,
0x1d4ffadf,0x35d8d291,0x0b1ae06f,0xfb390d6e,0xf1320843,0x03de09ae,0x0ba0e560,0xdf450d26,
0x00ff0ac2,0x0e91febd,0x1a20e2cf,0xfa6f0f1e,0x0c37f705,0x1359efc4,0xf459fdb8,0xf0560874,
0xf8790645,0x0911fca0,0xe5821b28,0x0da0057e,0x0de2f232,0xfe22effc,0x03b60a21,0xfcf7e433,
0x1e10f7f1,0x0a41ea68,0x1ba6f9a4,0x09b6e1ce,0x07b40d40,0xf6670acc,0xfc9900e8,0x0be2f981,
0xf74af4b5,0x08650c94,0xf71ee6e1,0x073d14be,0x1b0be7b4,0x011d08f8,0xee2fed5f,0x0341160a,
0x1050f2c5,0x081fea12,0x10b2f398,0xe8d1f528,0xf2422022,0x02240549,0xf1f9024b,0xf6f9140b,
0x008b1724,0xfe7afb1b,0x11f2f713,0xff3df89f,0x099d01de,0x0b30eae4,0x0e41f1f1,0xfd4ff7f6,
0x16a9ff01,0xfde6e4da,0xe18b14d9,0xfd8a1b57,0x0489f273,0x0e3ee9eb,0xf987fc60,0xf79c23dd,
0xf645f203,0xf57e2046,0x0cd7fc7a,0x101dfd50,0x04dbeac0,0xfdaa024b,0x1482f34c,0x069df61b,
0xff84fa31,0x04e4f325,0xe5991883,0xfa4efd6e,0xf1ca12ec,0x071300f8,0xfc45088d,0x04d20027,
0xeebcfd38,0xeb5d1538,0x1237f852,0xf6600524,0x0e2ff297,0x1710fa01,0x0c80e692,0xdc051a31,
0xfea91d7c,0x0542fd30,0xe5350391,0x01c5143c,0xf37cedb5,0xf1d80e28,0xe4422277,0x0cbdf65c,
0x11d0f674,0x0895f9cd,0x0da8ea59,0xf60ff8f4,0xfcbd11ae,0xf6b6f79e,0xf520202b,0xff74ffd1,
0xf40517f0,0xfbc614c7,0xf2e104f6,0x1958ee64,0xe743ebde,0xe6b81967,0xef3409a2,0x0e3f07e8,
0xe6c6fd2d,0xeca23184,0x3b5cea51,0x130bce7d,0x162ffb95,0xfd75f5c4,0xfa94ffdf,0xfacdf95d,
0xe0b31cd8,0xfe180fa3,0xef95061a,0xfb9a101e,0xe8c401ab,0x1cb90ea8,0x1739d3c3,0x0fcbf58d,
0xeeb8036a,0xf9c00625,0xfcf8fa4b,0xdf451490,0xeada19b6,0x2462e852,0x07bef19f,0xef420c43,
0x0e8b171a,0x0535f896,0xf11519d8,0xf0ae1057,0xfab9001a,0xeb3af466,0xede81214,0xe353099f,
0xf510ff28,0x02830959,0xff9e0502,0x08c9009c,0x16580105,0x0689ef92,0x00390d6a,0x0159ff79,
0xf2090625,0x04a30008,0xe9270d4c,0x0d0e0141,0x035aedc8,0xec9b10ee,0x14a3f044,0xfea5f8dd,
0xf5e7faf0,0x07a205c4,0x0d14f474,0xf9e401ab,0x03ad05b5,0xed0b11f8,0xf8c61061,0x139ce67f,
0xecf20ae1,0x1680fcc7,0x08e5ef7c,0x1c08df12,0xfa7707b1,0x128ef4f2,0x0b4ff18c,0xf23803a7,
0x19d70261,0xfebaf201,0x0ec5ecfe,0xf30ff891,0x096d07dc,0x035ae709,0x0a05087f,0x1bfef34f,
0x15a5e412,0x0738fc7d,0x02d8fad4,0x268deda4,0x1b20cf4b,0x0d75f14e,0x165ae261,0xecf5fef9,
0xf34b15d3,0xf67902a5,0xe00b2a1e,0xd7b41a79,0xe3d42ff8,0xfb690a65,0xee1c0837,0x0011057f,
0xe4b60a57,0xec251527,0x101afe8b,0xee310103,0xe6fb1054,0xf1c228ee,0x0f57ff30,0x0296fb3f,
0xfd090a13,0x01d7fccb,0x11a3ec39,0xf000f68e,0xfb80fbdc,0x15ebf943,0xf7eef72b,0xe7241250,
0xe681218f,0xefe71869,0x03290726,0xfb8802a1,0x09ee02bd,0xef4b0943,0x0aea0ba4,0xfecff0b5,
0x0cdffbee,0xeeb2e47d,0xd2c42970,0xfd150f55,0x03ea0096,0xf9b20103,0xe76e1f21,0x371d066e,
0x0d6ed3cd,0x1492fd8d,0x03d3e299,0xf45e1061,0xf951ee66,0xe7ed173e,0x038ff232,0x0115fcce,
0x1b1df4f2,0x0b39e4e8,0x1c88fce4,0x026af33a,0xf5e61501,0xe9861764,0x1ba1047e,0x0ea8e6e4,
0x08bdfe30,0xf536fba4,0x1395e76a,0x062decf6,0xdf690483,0x028510e0,0x1222e4e3,0xfb0cff2c,
0xeef212a5,0x1a1307ee,0x013cf2df,0x2a86fa7b,0xf94bef18,0x1211f7de,0x0276f687,0x0058fe0b,
0x01fdf046,0xf2f50766,0x0832fc32,0xd4001525,0x132e0e81,0xef7df5bc,0x2615002b,0xfeb1f374,
0x240bf57f,0x017de8da,0xefaf0cb9,0x0731faa9,0xfe42e7e5,0x10e2f3bb,0xfa230a85,0x1c8ff232,
0xfbb3f4df,0x10aa0081,0xe3231bac,0x1b7a00fb,0xee51e8db,0x0b3c0623,0xe42406d9,0xe19f1d66,
0x03aa046d,0xf6480ac3,0xff8eff88,0xf4e40ae5,0xeb6b0547,0xeda822fe,0x1c39ed97,0x0214eeb8,
0xf18a046b,0xeacc255c,0x1402ff48,0xf1d0f855,0xf9771f5a,0x00d6f0bb,0xfc1506ce,0x05bbef13,
0xf844097a,0x0472fb66,0x07580133,0x23f6e60d,0xe813f718,0x022c192b,0xf436f1bd,0x08f114c8,
0xfa79f7b3,0x01ab0cb2,0x179de05a,0x0334f629,0x01b4f982,0x061cf363,0xf40d074a,0x0d8dfea5,
0x145d08c9,0x0e58de76,0xfe390f94,0x19d2f95e,0x1109e92c,0xf8d2eda4,0x0efefe53,0x0d3bdfe6,
0x0a9ce4bb,0xf9e7069a,0xf551fd1c,0xf8d617bb,0x1208fd46,0x2d1ae557,0x1883e470,0x105ff4b5,
0x08f4e846,0x1d12f9ed,0xe2a9fa94,0xe76e09db,0xde142797,0xf27a0ac4,0x001f0a27,0xeeb00c6b,
0x091605b2,0x0433f5af,0x0be80563,0x000fe42b,0x097b0bd3,0x006ffb21,0xff4df91d,0x08cc01b8,
0xf115f7ea,0x007d1281,0xfbbc070e,0x24d2f664,0x124ddc5e,0x06c5fccb,0xfc65fea0,0x22e2dd52,
0xf1bdf376,0xfa38f9c0,0xf45a0206,0xfa490b9b,0x19fdfdd0,0xfdd7f68c,0x22cf0f96,0x1babd2b0,
0x1d1defc2,0xf874f8e8,0x2ef9e884,0x0650ded3,0xedee0ce7,0xe4d90279,0x08b606eb,0x106df80c,
0x1d27daf2,0xfcb2f06c,0xed5b0f8f,0x08260514,0x04a20c20,0x0ea6f4e0,0x0675fbfb,0xfa14024c,
0xef9800b5,0x213fe8c0,0xfd39f3b6,0xef1e0405,0xfc4013ff,0xff330bc9,0x1389e7e0,0xf4d709f8,
0x080404ca,0x05f3ed95,0x0bb20001,0xec68042a,0x168bf325,0xfcc1fb69,0x073efd1b,0x103cee3c,
0x0fab0015,0x0d01df38,0x0ffaf157,0x07f6e924,0xeebfff88,0x15cc073d,0xe8170578,0x02b012f9,
0xfa3a0d58,0xf14d1237,0xff6d06b6,0x1e93ecdb,0x137cd783,0xed94033c,0xed9f0d38,0xfdc700a1,
0x1117f0c7,0xecf905a1,0x07b10252,0x0f29f580,0x35fae013,0xf6b5f604,0x04be00ec,0xe42d1ad2,
0x0b030292,0xf947fcce,0xf52102de,0xec27085a,0xf7e307bc,0xe18918c9,0xf274160a,0x1769f837,
0x07a4f13d,0x1135f495,0x0ea9ec69,0x0181f457,0xdb54183f,0x00a71a75,0xe73a0074,0xde192a5f,
0xf22b1dbd,0xf3b50629,0x1366f370,0x00f6f6d8,0xfd80fcbf,0xf4e0fa5f,0xf44914b5,0xee0c0c7c,
0xfba40e43,0x06250316,0x20dfea74,0x2de1eac6,0x1e3ecf8a,0x135de480,0x18e6ed64,0xf195fabc,
0xed4a0896,0x032b05fe,0x0d55eaaa,0x14f9f880,0x02c9f957,0x12d8f107,0x0c6af84c,0x296ce6a8,
0x0daee237,0xffc603ef,0xf60ffa75,0x09b9fb11,0x106aeb1d,0x0074ede6,0xff55002e,0x058d0398,
0x126fecde,0xff6a045a,0x13a400bb,0xf4640066,0xf4910fc3,0xf4370a6d,0xf70f05e3,0xeffc0635,
0xf3aa064e,0xfc4109ef,0xe96f09ec,0x063908c9,0x066af387,0xfedd096c,0xf65805ec,0xf881f9ee,
0xf59b0840,0x0ec8fce8,0xfb9df90b,0xf1b00e3e,0xf666176e,0xf96c1902,0xf914ff88,0xe79a0c03,
0xf2840bd3,0x127d01d7,0xfde7eb9c,0xf06209e6,0xea51177c,0x021d159b,0xec30fd35,0xf7e10871,
0xf1530499,0xf7eaff0c,0xfd321737,0x09f6ec27,0xf6d51046,0x0d6bff0c,0xffcdf9be,0x0004fc14,
0xf9c51938,0x1095ef2d,0xecdb0756,0x0a9710b7,0x0580e8af,0xebee104c,0x0770f358,0xfe16f960,
0x05b0f3f8,0xebc40376,0x1056fff8,0x1319fa48,0x0f95f5b6,0x0de9eda4,0xf4220fe7,0xf2df0e26,
0xe10b1337,0xf72d1b28,0xe4b00357,0xef0c1da3,0xf47307d5,0x0029f67b,0xf962fcd5,0xf2210c2e,
0xf7c60780,0x00f2093d,0x0abc0514,0x0762f819,0x03db10de,0x14b0f2e5,0x0591e3a3,0xe4cb1435,
0x0388016c,0x005ef2d6,0x01ef0424,0xfef2f21e,0x0c56ffd9,0x020ffb63,0x0a6f0023,0x06a1f793,
0xfaa90bbd,0xf88f0456,0x08c406aa,0x11e0e69b,0xf74cfe3e,0x21d2ed4d,0x050be70e,0x16c6e862,
0xfb76fbb6,0xe9111acd,0xfe7008cf,0xf1720e1e,0x00f10e4e,0xe698f665,0xf42f264a,0x0a08f360,
0x0638fb41,0xe7631169,0xf8a71014,0xebd60be6,0xf7671577,0xfedff89a,0x119af4bc,0x1358f239,
0x0086ed3b,0x2703f5e3,0x04b1e458,0x08d1fbfa,0x136ae920,0x064cfb4d,0x0295fb6c,0xfaf30f27,
0x04720765,0x1dcee761,0xf901fd25,0xdf5f0e7e,0xf3450814,0xf21a0963,0xfa9103b8,0x0cf4f8c3,
0x153ef700,0xfe4df54f,0x12fe0c78,0xeaa60122,0x037e0404,0xfcb70163,0x105bfd72,0xeac8f0a0,
0xe7a31db1,0xf5481065,0xf6d10e45,0x003f07f1,0xf579f99d,0x054b0540,0x080302f0,0x1bb5f0c7,
0x1b05dae2,0xfa47fd45,0xf66b0aed,0x24cae286,0xfbc3eb5a,0xf21a0f48,0xfbcb09ca,0x04560cd8,
0xfb8cfe37,0xf59815bd,0x04ecfa4b,0xed4ffe61,0x0283fc66,0xe10d1403,0x033905e7,0xf5a20d09,
0xfb0a11c8,0xf59306f3,0xf77f0d8b,0xea1c0a53,0xf66513b4,0x01e3fd55,0xefaf0440,0x087bf52c,
0xf62611c3,0x2097ee5c,0xedd6fecd,0xf2da1152,0xe6ca11fa,0xe9b82215,0xec540cfc,0xea242584,
0x27d3ea11,0xfef2f9ff,0x1ee9dfc2,0xe7ce088d,0x1e75f0c2,0x089ee90e,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_20_standard_DRUMS_cowbell[896] = {
0x00000000,0x00bfff9f,0x03a3fe65,0xf926fdca,0xf7ed0f1d,0x1f61f5e7,0x62c0da0b,0x8df3cfd2,
0xb7e87200,0x7200e49a,0x94090b0c,0x7200d9e6,0x0ed0c296,0xd1b04a94,0xac9e1814,0x2b140493,
0x96418df3,0x03d1197c,0xe3598df3,0x67e1d96f,0xcb6aafcf,0x0e8b7200,0x711b090a,0xdb38c7b2,
0xf0cc7200,0x3c497200,0x7200f32a,0x37310c2e,0xd8741e35,0x8df37200,0x12afb66a,0xe48d8df3,
0xbf99ba19,0xa561edcc,0x30818df3,0x8df3d22d,0x8df33673,0x49f1be4d,0x72008df3,0x8df348d6,
0x1b0d7200,0x720010ae,0x71d8e7e8,0xefa85f39,0x2fdd7200,0x557c17c7,0x1c78e4fc,0x8df33360,
0x1e92ab4e,0xbc698df3,0x8df3e419,0x9c5ff638,0x0777ae70,0xdcd48df3,0x8df330ae,0x6664a195,
0x4f9dfe3c,0xe0dd18d5,0x18cd7200,0x72000dbb,0x4a930392,0x10925e52,0xf8e47200,0x698d3bac,
0xeffe8df3,0x8df31169,0xbc04e23d,0xf18b9a0b,0xd0848df3,0xaf97cb90,0xe321d61b,0xe819be5f,
0xd8e8d266,0xeaeb5b46,0x7200dd29,0x1abc44b5,0x30d96534,0x55db3937,0x5edb26e6,0xe2e7216c,
0x07885e26,0x02510fdd,0x36dcbe26,0x99b1b476,0xb720ee0b,0xc972a72e,0xc8f2b41b,0xfe06b2c0,
0xbc03e56d,0xf227e3e1,0x0d33114a,0x15992e36,0x720030ac,0x5a6210b0,0x1f134de5,0x26ec6690,
0x32d50076,0x2b991cf4,0xdce5f334,0xf4fb1627,0xd3000533,0xb8b3cd53,0xd66cd710,0xd30c98c0,
0xae4fb9d7,0xc18f06ac,0x2be2ca0a,0x29b0e4f3,0xfa40fb2c,0x312a6e7b,0x41bb349a,0x56ac1345,
0x05614f73,0x003a3a69,0x31711164,0x074bea6d,0xdd72102b,0xe19919a2,0x1075d12c,0xd249d9b7,
0xbf46c046,0xd183c8f2,0xbf50d36b,0xf4ece071,0x03e31004,0x4192f13c,0x2ad4fc1f,0xefe55707,
0x3c944d65,0x30f3045f,0x31140295,0xed722d89,0xe71c1d36,0x2d50f89e,0xf96de632,0xef07eff5,
0xe9e701c3,0xcac7e660,0xd040f101,0xebffba91,0xf6c7d5b6,0xf1010076,0xfd81f9e9,0x2c512a54,
0x1df60d20,0x215e03f7,0x0b6836e6,0x17ef069c,0x0bb91ade,0x007212dd,0x028e0e2b,0x017df4e9,
0xffbce85e,0xe1e02122,0xf0a9e668,0x098aec6f,0xe589dd4b,0xe89adc16,0x0000ebb8,0xe511faf1,
0x0d75159e,0x035203b8,0x39a30425,0xf2d8ff28,0x096416b1,0x0f192bc3,0x1c07f614,0x0b300908,
0xf0f416fb,0x0232fab3,0x04e10007,0xf9e5e731,0xfff814ac,0xeabbe9a4,0x00fcfe20,0xd8daef9b,
0xff9fe78b,0xfb84f058,0xddb603c8,0x1892f5be,0x0b7602db,0x0d0df760,0xfd2221e9,0x0f470fb3,
0x2bb61df5,0x0ccdf396,0xf76b1b3b,0x04881082,0xf9d0eafd,0x192a0ad5,0xf5350711,0xfb69f356,
0xe70606f0,0xed30e721,0xf1bdeb02,0xf8d6c6ee,0xdb60e9c0,0xef2119f9,0x195cea4d,0x162310f4,
0xf1a70bb0,0x2f4b27fa,0x188e1a79,0x1561112a,0xf5801530,0x11bd0f7e,0x1e2af232,0xedcafc4b,
0x08be0fb2,0xf395ff46,0xea9cda01,0xe41efd2a,0xd6f5d36d,0xf046d94b,0xe63fe250,0xf12f0801,
0x174411ca,0x21d4e396,0x1aea26bc,0x012c240c,0x372f25e8,0x14461525,0x07cb08ba,0x0cfe1561,
0xf935039c,0xfe10fbd6,0xf1a90911,0xfee6e411,0xe410ea5e,0xce31dbde,0xf06feb29,0xe4d2d838,
0xfc86db9e,0xfc180c30,0xfa2d14dd,0x3008111a,0x12d9167f,0x20201e50,0x16ab2d61,0x1efe159f,
0x12f219b3,0xfd03f70b,0x006e0458,0xf529f9c4,0xeb34e404,0xeea0f984,0xe209de83,0xf025de7a,
0xd7fdf0df,0xf795e726,0xfb80f0e3,0x0d22f329,0x11171dbb,0x0bc011f7,0x2e891212,0x191f2c83,
0x117c184b,0x215c24fb,0x0697ffb2,0xfbb901de,0xebbffd92,0xf598eb14,0xe981f383,0xe4fadfcc,
0x024ef240,0xde37e7f3,0xeee5e80a,0xf47f0311,0xfd4aecba,0x132c03d9,0x030a0a88,0x1af7175c,
0x19361ed3,0x26c90f60,0x149c2679,0xffe60f19,0x0fd11309,0xf4be0045,0xf133e0f6,0xee76f76a,
0xe4d2ed03,0xff17ecdd,0xe971eda8,0xf641f73e,0xf657f572,0xf9fbeb97,0x02ff0545,0xfee90289,
0x167102b1,0x0ff321c7,0x11c40ce6,0x1fa21fdd,0x117a093a,0x09681334,0xf66f0915,0x03fcf6e9,
0xf405eb9b,0xe5e0e9ba,0xf861faba,0xeb2bf7fd,0x0347e7d4,0xf6d20493,0xf4d8eebd,0x005801d2,
0xfc7df757,0x07940813,0x06800ac3,0x119a0518,0x16501e5b,0x048708d1,0x1e8c1381,0xfac5100b,
0x023ffc1c,0xf7cc0812,0xf571eea9,0xf899eeea,0xeceef22b,0xfa08f893,0xf7ac004b,0xf904eb6c,
0x0187046d,0xf125f786,0x0bb3fda3,0x005f079b,0x0188010f,0x0fcd1027,0x0e020ab8,0x167e0a58,
0x00fc0ad5,0x0c700fb4,0x02e00d09,0xfb3ef347,0xfedcfda8,0xec14f411,0xf6c1f057,0xf63c0287,
0xfb03f05a,0x00b4f8f4,0xf3d7f811,0x00950617,0xfe7cfe68,0x08a9f61e,0x05d30df0,0xfb7501bf,
0x1a120d2e,0x042c0a11,0x0d4b09d0,0x0a5814bd,0x0ab0001e,0xffe6ff4e,0xedf8fe42,0xfb88f667,
0xf20bf7b6,0xf4c4e8f7,0xffd604ec,0xece4f828,0x08dffaea,0xfa48ff6b,0x01a9fb0d,0x042a02cb,
0xffb1fffe,0x0bfc0632,0x027c0a1f,0x13ad082c,0x0d0315c1,0x0832ffcb,0x0a801357,0xf9260364,
0xf9cbf92b,0xf324f867,0xf277eefc,0xfbe6f4e5,0xf271f47e,0xff1dfcfc,0xf663fe43,0x0742f5df,
0xfd7a0843,0xfc8bfce6,0x0b8c036c,0x0541081e,0x0a8c056b,0x0bad13fb,0x105a05ca,0x0df90f16,
0xfcea0755,0x06b80702,0xf771f782,0xf1dfed3a,0xf56cfac1,0xebb5f359,0xffddf2bb,0xf5abfd29,
0xff5bf6cb,0x01200522,0x00f3f879,0x056c098a,0x012f04d9,0x10490377,0x086b0ecd,0x046b0666,
0x179211a1,0x01b105e5,0x04c00853,0xfa56068c,0xfcd4f62d,0xf519f405,0xed3beede,0xf5f3f68c,
0xf268f7e2,0xff94f35b,0xfed60401,0xff3ffa6f,0x0b5a06d9,0x051902c4,0x053f097e,0x09670a81,
0x0b1f043f,0x0b300a0b,0xff460995,0x0ee608e3,0xfe3e057d,0xfecbfad6,0xf80b00fc,0xf348efa4,
0xf3b7f18f,0xf07ef8ed,0xfa5bf312,0xffadfa4e,0xfe30fb28,0x09a60a0b,0x0157026c,0x0e070613,
0x024d0d5f,0x064c04d7,0x0ac609b1,0x01ad034a,0x05bb061d,0x038409d7,0x0419fd8a,0xfc44021d,
0xf552f622,0xfa88fbe8,0xf059f1b2,0xf996f120,0xf80afc1b,0xfb9af925,0x07a703a0,0x01f1052a,
0x097c04f1,0x05f60acd,0x097f0337,0x05160a79,0x003cff21,0x088d0512,0xfe72054f,0x03290190,
0x06c50330,0xf8c8fa9f,0xfc4cff13,0xf5aff967,0xf871f5f4,0xf619f73a,0xf91bf786,0x01e6027b,
0x00b1fe29,0x0ac002d2,0x03f40979,0x050f04c4,0x088c0a2a,0x01840247,0x03970250,0xff3e0443,
0x04fbff74,0x009d04f4,0xfe7bfd4e,0x010d0528,0xf810fc34,0xfeb0f6a1,0xf8aafb49,0xf4cff635,
0xfeaafd78,0xfd98fcc0,0x072efde3,0x006706dc,0x07c2033b,0x07800970,0x01f300ff,0x06bf07c1,
0xfe97045c,0x021ffc83,0x022705e3,0xfe60ff1a,0x054e00d6,0xfc03fecd,0xfdbbfea2,0xf8f2fee8,
0xfcf0f652,0xf9f8fc0a,0xf693fad3,0x03fffc0b,0x013901a4,0x0154ffb0,0x06b80949,0x05380323,
0x0780057f,0x00b8048d,0x033b0372,0x00dc017e,0xff95fc76,0x035e03ce,0xfc1f0085,0x02cffe20,
0xfd190277,0xfb85fb2e,0xfceffd2e,0xf903f8c8,0xfc43fb42,0xfc99fe29,0x032bfc01,0x039f05a0,
0x01460078,0x0a930848,0x028e04eb,0x04870237,0x018705a9,0xfe99ff7a,0x01c30113,0xfd85005e,
0x03e1ff8e,0xfef100b3,0xffa3fbbc,0xfc8903a9,0xf8bffb43,0x004cf8d0,0xf9d0fbc0,0xfbfcfaed,
0x02bf0160,0x0061ff6d,0x062e059a,0x02ea05de,0x09c80365,0x0116056d,0xffd501ab,0x03ea0374,
0xfd90fd84,0x000dfe74,0xff7f0457,0x00a3fc53,0x01100045,0xf9e5fd67,0xfe97ffe4,0xfb28f8dd,
0xfd6cfa04,0xfbea0056,0xfe8ffd50,0x07650175,0x015003a2,0x05f603c8,0x0411091b,0x04bb013e,
0x027d044d,0xffc2ff16,0x00650020,0xfbfc00c8,0xffe4fd99,0x025401ad,0xfb3bfc65,0x00fdff54,
0xfaaffed5,0xfd4dfb0b,0xfca5fe61,0xfca4fcfa,0x02a8ff5e,0x00bcffd9,0x054402d2,0x035e0839,
0x058b0126,0x066b0676,0xff05022e,0x013900d8,0xfef6006e,0xfd02fc6d,0xffa4004a,0xfdc2fd2e,
0x011afef3,0xfad3ff59,0x001cfd07,0xfda6ffda,0xfccdfa35,0x00a0ffad,0xfe2fff1d,0x0219fff4,
0x036c059d,0x050901ce,0x06de05aa,0x0110026e,0x03d905af,0xfde80143,0xffadfcbc,0xfe4effab,
0xfabbfc64,0x0106feb3,0xfd1cff7e,0x001ffcb7,0xfde800e6,0xfedffc7b,0xfedd0035,0xfd04fe31,
0x027cff78,0x017f01f4,0x025efff5,0x05ee0699,0x01a1035c,0x060c0392,0x008f0355,0xfff8ffe7,
0xfe33ffa2,0xfc2afbe9,0xfd9ffec5,0xfc33fea9,0x0130fcba,0x000a0110,0xfd60fd15,0x017001e6,
0xfdfcfe4c,0xffd0ff0c,0xfff0012f,0x01ccff21,0x03a20310,0x016c0261,0x05d50462,0x00eb03b6,
0x02360037,0xff6f0335,0xfc9cfd59,0xff56fd3d,0xfbccfd5c,0xfef4fcc7,0xfea2008d,0x0045fd80,
0x01890142,0xfe05fed0,0x02220095,0xfe0b010e,0xff9bfec7,0x02ee0284,0x0072ffd1,0x0468028e,
0x011f039a,0x02d801d7,0x01540336,0xff57fe0d,0xff690079,0xfb60fcd2,0xfef8fc97,0xfe20ff75,
0xfdbafd44,0x01a1018d,0xff30fffe,0x0287ff7a,0xff06016a,0x00afffb6,0x004f01a6,0x0017ff39,
0x0304016d,0x00660209,0x02d8007c,0x01ff0434,0xff83005e,0x01bd00f8,0xfd35fea0,0xfdfcfe55,
0xfd37fdf7,0xfeaffc60,0xfffdffcf,0xfea9ff2c,0x03390043,0xff3d01ea,0x00e2ff87,0x011a02c9,
0xff73fef0,0x01740051,0xffc900c1,0x021e005a,0x00e402ec,0x0171fffc,0x02de0244,0xfdfeffb1,
0x004cff4b,0xfd2f000d,0xfd3cfbe1,0xff68ff96,0xfe4afdf5,0x0128ffc3,0xffe60168,0x01d7fffb,
0x00ab02fe,0xff9fff4e,0x021d013b,0xfe47ffd6,0x00ebff64,0x0105023b,0x00e1ff4f,0x028701ac,
0xff82017a,0x01a100bf,0xfe6f002a,0xfee2fd9f,0xfe16ffab,0xfd2bfd33,0x0068ff36,0xff010083,
0x011fff71,0x02150216,0x0022ffcb,0x0131018e,0xff700002,0x009dfff9,0xffbb0088,0x0062fee8,
0x01e401bb,0xff6400ba,0x026400de,0xffb601b2,0xff83fefa,0xff940027,0xfdb4fdda,0xff31fe99,
0xfe18ff32,0x00a5ff01,0x00d10184,0x0063ff35,0x02270215,0xff1f00b0,0x0102ffe7,0xffbf0116,
0xff5dfeff,0x00ec0090,0xfff2ffd7,0x01c3006a,0xff9a018e,0x011affd0,0x004e0135,0xfe55fe51,
0xffa1ff7e,0xfdc1ff53,0xff7afe07,0x001d004b,0xffd7ff8f,0x01ad0159,0x0035005c,0x016c00e0,
0xff9d0134,0x0060ff3d,0x00660076,0xfec4ff92,0x0123000a,0x005d00bf,0x007bff98,0x00610186,
0xffa9ffb0,0x00060004,0xfe47ff07,0xff86fec5,0xff4bff64,0xff20fea7,0x00e20123,0x002c00a6,
0x01de0003,0x002a019e,0x00560035,0x005d00bf,0xff6cff64,0x000e0003,0xff750029,0x00c5ff2c,
0x005e011d,0xff6affea,0x012f0076,0xff04ffc2,0xff94ff0a,0xfeedffde,0xff35feac,0x0029ffe9,
0xffcfffd0,0x013e0076,0x00730145,0x00c1ffe9,0x00bc018f,0xff60ffbd,0x007efff4,0xff4effc9,
0xffc7ff6f,0x003e006c,0x0018ff69,0x0099008f,0xff6b0025,0x0067ffef,0xff730017,0xff04fecd,
0xfffb0014,0xff3eff31,0x00b3ffd8,0xfff800ad,0x00c1006f,0x00ea00e2,0x0018fffb,0x004500a0,
0xff5efff5,0xffffff48,0xffbf0046,0xff98ff4d,0x00ca0037,0xffb20005,0x003f002f,0xffcd0088,
0xfff0ff6f,0xffd5ffd5,0xff0fff5f,0x0029ffb6,0xff98001c,0x004cffcc,0x00ce00ff,0x002bfff5,
0x00df0070,0xff8c005d,0x0006fff8,0xffd8ffe9,0xff7eff5f,0x0027001f,0xffaaffd9,0x0094ffef,
0xffd700a2,0x0005ffb4,0x0044004d,0xff53ff7b,0xffd6ffcb,0xff97ffce,0x000bff7b,0x002b005d,
0x0017fff8,0x00c60090,0xffe30050,0x00550014,0xffe60072,0xffb8ff69,0xfffeffef,0xff75ffd4,
0x0046ffd9,0x00020013,0x000dffec,0x001a0081,0xffc6ffc6,0x001fffe9,0xff66ffde,0xffe3ff75,
0x00020005,0xffd1ffc8,0x007a0054,0x00130053,0x00750029,0x000d0057,0xfff8ffd8,0x0001000f,
0xff79ffb8,0x0006ffc6,0xffcf000b,0x0003ffa8,0x00410045,0xffccffea,0x0020001e,0xffbbfffb,
0xffe7ffb2,0xffd4fff4,0xffcbffa4,0x003f0010,0xffde001f,0x006a0016,0x002c006f,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_21_standard_DRUMS_crash5[6784] = {
0x00000000,0xfda9fe05,0xff1d0155,0x01f30ae5,0x05c9fa87,0x003c108e,0xfb01fe3c,0x0a54f331,
0xffd0f941,0xfd35f983,0xf9f00b94,0x013b138b,0x0bdc0a84,0xff67fcf0,0x03fafc6f,0xff07f746,
0xf85ffc57,0xf78a0e0b,0x1103fc6b,0x09dee8bd,0x0436f065,0xed110329,0x00e00fe1,0xf61cf5d9,
0x0035014a,0xf8bb0866,0xfe2bfb97,0x080601f5,0x1336fb5b,0x0570fb07,0xf5240821,0xfd960015,
0xff151442,0xfda30aaf,0xfe22f3b7,0x1b8de705,0x0ef3f0c3,0x07d31a00,0xfa840e85,0xf2fbf3ec,
0xdae2e96c,0xe97cf26b,0x0b9300ac,0x2026080c,0x12d31833,0xf8371d3b,0xf64f038c,0xe4ce0186,
0xef3af9f7,0xed6ce5b2,0xfbc6e889,0xffc204be,0x11281fac,0x191109f7,0x16fe1539,0x1a3609e7,
0x0e0d0245,0x10b711d6,0xfa42f352,0xfc6ffe04,0xce9dd946,0xcedae03c,0xe95eca56,0xf094df05,
0x1aa8f28b,0x0c431b97,0x2ef40e8a,0x21350e34,0x1e32218d,0x0e7c2437,0x243e044f,0xe56df334,
0xe446ffdd,0xe275ecec,0x0068e92d,0xfa45cf5d,0xef15142d,0x0f32e9f3,0xfa2d0289,0x076b1aa2,
0xf3e10874,0x283b090c,0x3c7d11c6,0x12db154d,0x04a207b1,0xf455edfa,0xc064dade,0xd515f5d2,
0xdc5bedd2,0xf6abee70,0xfdefe1ad,0xe66216fd,0x21541d2c,0x425d1d08,0x2f821b67,0x160a0ecc,
0xf4dd1493,0x042ad9fc,0xdaefea79,0xf3e3f5a0,0xfa01ec26,0x1354dfdc,0xec5dff1e,0xfc9e0284,
0x13770878,0xe3c611bf,0xf4a4132a,0x10da0288,0x0048fa26,0xe2232a22,0xf68b0983,0xefd7f90b,
0x0577d2fd,0xfb9c01e6,0x1579f201,0x1ba509af,0x26252cf1,0x11c01683,0x07190a1d,0xfffee40c,
0xf93d04ba,0xfcf9d3fc,0xd87bed30,0xca0ff1a6,0xd454f55b,0x01b9ecfa,0x21c2f3a7,0x23240aa1,
0x126a10c4,0x04a4312a,0x11c82f84,0x04a21dbf,0x11b2e370,0x1ce2f159,0xe2ffe3ab,0xdc0cf3d8,
0xe8f2f19e,0xf9d6ce74,0xe104ebb6,0x0df309d1,0x1921fbd4,0x22d30312,0x23e73b85,0xfa6e39cc,
0x0fd11fad,0xfece05f2,0x1e76fe5e,0xe039d69e,0xe72adb20,0xc06edc58,0xeac2e1b7,0xf1c1c7b4,
0x13a7e616,0xf8390fe6,0xf49a41b1,0x36582318,0x21da260b,0x00930e69,0xf50ff81f,0xf92efb1c,
0xec8a22a6,0xee881430,0xeee831ee,0x1e47db8f,0xf410e9dd,0xf437e47b,0xf8c0d73d,0x032c0445,
0x06c3ec31,0x07a4efb7,0x3f34cd48,0x1058ec76,0x0bb7f24d,0xea671c1a,0xf1b11b0e,0xdf811a65,
0x0c6f05f4,0x117ee9bd,0xf2290e0a,0xe3bb2436,0xf06f3992,0x2a1606ef,0x18a9d65d,0x0566f88d,
0xdd690cdc,0xdd50185f,0xce88004b,0xf672e5f4,0x0b85ea55,0x0ce1ed04,0xfb5af71d,0x0903393d,
0x0422223c,0x0903117a,0x149de339,0xdc0c03c3,0xede00d7d,0xd27906ed,0xffa80b69,0x1fe5ea66,
0x2693fbe4,0x1f16e695,0x1d8ddefe,0xcca4f8e2,0xcac944c5,0xf6e021ec,0x1933e659,0x0e22da29,
0xe2461c63,0x016c1089,0xf5ef1882,0x157c0a5b,0x1030cbdc,0x1556f6b4,0x10f6c9ba,0xc43219f9,
0xf83d22c1,0xe16a2396,0x2d8ff19b,0x1bc7e633,0xf6eaeb56,0xddb91696,0xd02b2782,0xf0671993,
0x03a20d89,0x4761e009,0x053bdbad,0xe9412387,0xde00223e,0x07d40695,0xd8fcf8c0,0xe7a30746,
0x116d130f,0xf31013bd,0xcbd7fec5,0xb4a44b49,0x193004df,0x0dcfed4e,0x16a6fc3b,0xeae4fb42,
0x01d9125b,0xee3f01e4,0x2adf107a,0x3abad25b,0xff87da51,0xeed004c8,0xe0081e39,0xe1571373,
0xe59a2278,0xfe4b0163,0xf38f08fe,0x2fb2e97e,0x3135f9d9,0x5915a7d8,0xe926d115,0xe26a28c2,
0x0ab6eb2e,0xf1f8fa60,0xe50303b4,0xa3553989,0xe4c534fa,0xfd721799,0x272ef629,0x15451fb7,
0x2e0fe85c,0x1054f77c,0xe8761602,0xeb5d1305,0x5825d6da,0x11569105,0xbdb3f82f,0xe876eee1,
0xf0a00bca,0xfb54082a,0xd28f5d3f,0x2bbe15e5,0xfb00f980,0xe7e41fc3,0xf7ae1b2a,0x10d80282,
0xf923e567,0xb7d23418,0x08d60d13,0xe5e02a4b,0x07d300d8,0xec32db98,0xee5ef504,0x148cfde7,
0x3570c166,0x0f0df18c,0xf25d27b9,0xe9a11580,0xf80813bc,0xdcc218db,0x22142916,0x186eb04a,
0xec490b40,0xfb840b8f,0x1e490407,0x2685ca8e,0xf918ee0e,0x01ab0476,0xe103f0b1,0x18e50374,
0xea92013b,0x080c223d,0xe842e83e,0xfe711fb2,0xf833f592,0xf12021b3,0x3856eeed,0x04cfdd80,
0x25f81449,0x1e1edc84,0xf2de0158,0xca041beb,0xe6742529,0x05eeddb4,0x20a8e96e,0xf43bdf0e,
0xef2ffd4b,0xf649f53b,0x186e1037,0x45d9baec,0xf33d082a,0xe7774b59,0xd3fa530a,0x2a010c79,
0xebf2f198,0x09ba106e,0xff07bdd0,0x01f6d89e,0xcea7e5e9,0xdef74f41,0x075beb43,0xd5111f95,
0x047a0b40,0xf90f2854,0x2fecee7f,0xe4b504aa,0x0cfa286d,0xf0cc0f71,0x27cf0157,0xf813e850,
0xeee70975,0xe271fbc6,0xf5b6e751,0x1a95c312,0x09fe1490,0x33b8cedb,0x1018e845,0x088df78c,
0xd3cd3d37,0xffcb1476,0x1337ddc9,0xff60f569,0x07be078b,0x02021725,0x25e1f989,0xee5b13dc,
0x1cdd123b,0x4e32c9c8,0x119ca559,0xde450c7b,0xecd3ec82,0xf438e4f9,0xf247f2c5,0xe6d9f5f5,
0xee1a10ad,0x3881fcd5,0x085a146d,0x1e6907d5,0x22430e4c,0x2219fe6c,0x1a90f178,0xfb63ff9e,
0x0cc5cfd3,0xaa26f92c,0xab855012,0xe2381b31,0x2c51e5ca,0xf557f5e3,0x1e1be20e,0xffdafbad,
0xdd432536,0xeb153240,0x1a290176,0xddf50ab2,0xc4083c8b,0xf0052c71,0x0963059e,0x2560dae3,
0xcd890f91,0xc4173099,0xb61d3bea,0xe97c148a,0xe88e17dd,0xbe4b1c8a,0x12841691,0x1123e802,
0x0cd60ffb,0xefd20562,0x1eb4eaa3,0xefb8085d,0x03431249,0x3cc2dcb7,0x2f51b730,0xf5030713,
0xc8e32572,0xfc422e7e,0xde50e24f,0xe69b3e21,0xda88fc14,0xf4dc0526,0xfae3f950,0xccb73512,
0x0ac62f7f,0xf90df1b0,0xd08e325b,0xec30046c,0x1e5ef8d0,0xeda4e2b5,0xfda33aba,0x01aae623,
0xfd062a85,0x0a77e0f2,0xcd0918f0,0xfc32002b,0xf959ee55,0xf26b366f,0x19e9fa76,0x203cec48,
0x0a6dceef,0xded309b8,0xf60f100b,0xdba131eb,0xd2480f42,0xe1964398,0xc1132021,0xe14b3e96,
0x1cb2f1b4,0xf79001f5,0x2db1cf98,0xd166daf9,0xc9e234bf,0xacbf5a7e,0xfd214917,0x0daeda44,
0xf6a730bc,0xe04d0b25,0xe569304c,0x1d94f544,0x3333cf75,0x4989ac6b,0x0706cacf,0x281bf849,
0x439ecfb9,0x2825bf15,0xee80ed3b,0x0079198c,0xf824ea58,0x0f47f0cb,0x059ce6c0,0x0dcf0276,
0x21c0f2da,0xed682159,0x0bdf0ede,0x175ce2a0,0xf8efef52,0xe3ed043b,0xf6c81243,0xf3a00849,
0xf654ef46,0xa7243871,0xca705783,0x0aa60115,0x1289ecd7,0x1dec052b,0x35fcdf1a,0x0889e790,
0xca36113a,0xeb40266d,0x41a6f2c8,0x2879a1be,0xcf10f7c7,0xfe723e5c,0x0ce2dde7,0xf4500422,
0xecb20547,0xf5d029b8,0x0908e053,0xcb222590,0x01221c22,0x085af6dd,0xfca90ab6,0x043fe19e,
0x175e15a1,0x59f7c911,0x5aa8a04e,0x143dd5f3,0x162d0dfd,0xfaf2c17a,0xc9372c83,0xefd0fab8,
0xe1fc14e7,0x038f0a1e,0x0e3ae807,0xdaf93559,0xd45d13b9,0xe0b43e64,0xf3c026f7,0xe6a425ad,
0xe927eedf,0xcf641d6c,0xcfa81aeb,0xf2f14003,0x3601f05a,0x1bcbc09f,0xee390fb5,0xf6601100,
0xfb3300d3,0xe499f53b,0x02da137c,0xf9f9f3a1,0xb81b24fb,0xe2b45959,0x146efd31,0xfd8cf37a,
0xcdc20296,0xfac03588,0x4eb9d332,0x0facdadc,0xfdeafa7f,0x06481d01,0x1751eadf,0xcb7fe957,
0x0e98fc69,0xd92802a1,0xebae1f4d,0xb2093828,0x1da7322c,0x5688be1c,0xf86ae512,0xc9051fb1,
0xe2573fe3,0x0fadee2e,0xb19a1d27,0x4f8af2ae,0x35d6bbc5,0x1de0c337,0xd4e81a93,0xf20633da,
0xf92b1351,0x3231e18f,0x1b98c50b,0xce082645,0x14f3fe2b,0xbbbf1ec4,0xee171ccc,0xd92f3f76,
0x3f21e8c9,0xfc24cb4a,0xb40b1e0b,0xa09e544f,0xe1053be6,0x11da077f,0xc91126c9,0x18dd1727,
0x02dce2f7,0x1894063d,0x1cf2d77b,0xdbfd0388,0xc3f5471e,0xb61e21b8,0x0059200f,0xfaee00e4,
0xf7ebf4a9,0xe2c6325f,0x326ef585,0x0f7fe860,0x2d4af420,0x1251e9d0,0x1a74dffb,0x18b0e723,
0xfd7adc5d,0x3302c97a,0xd07a085f,0xbd6e25a8,0x0de019fa,0x4ee8c719,0x1138f025,0x4266eb01,
0x1d98f490,0x0c83e4c8,0xfd2a118d,0x0cdd0ab1,0xefd8d271,0xa119361b,0xe520131f,0x1da3ebb1,
0xdf15ea48,0xe88b389b,0x1868fb5f,0x0a1a2cdb,0xed14f623,0xc50a4209,0xfdc93762,0x1e21c5fa,
0xf1dde77a,0xe268f519,0x21ce1c01,0x6054b1f3,0x5836a29d,0xe77bd4c7,0xf84d38e4,0xef820e8f,
0x011006eb,0x4042dd3f,0x108fddbe,0xe4fe099d,0x9f242da3,0xe5755cba,0x0ee9e430,0x23a7e1d0,
0xce5fdfee,0x39ce2489,0x70889783,0x19b1c518,0xbedd2257,0xf3d9377a,0xfe7404ab,0xce031969,
0x04152d6b,0x37e6cd87,0x3bdcc424,0xd4cfed4d,0xec2b4d2e,0xe97ff1b9,0x0eb5fc6f,0xde92ea5e,
0xdd131f95,0xedee1712,0xd60f296a,0x545b1063,0x1fa8bc4d,0x2edd06ae,0x2072ce2d,0x12100aa7,
0xf449da50,0xd14eed93,0xba97543b,0x3182c704,0x02e8d517,0x02ebedbd,0x330013cb,0x1be5e0de,
0x1da71946,0x13f6ec9f,0x1c1404ef,0xd53013f5,0xfba0fd77,0x17310e48,0xee3fdcb5,0xe9d41062,
0xedc6edb5,0x30f303e4,0x16b4a375,0x11fffade,0xe7a4e2d1,0x5790ec20,0xf1c3f23b,0x1e8cff5e,
0xd5fc2726,0x1c061360,0x142beff8,0xef07ea89,0x2e5102da,0x36c4ab0b,0x4e03cf62,0xcd3deeb4,
0x3efc1e70,0x0eb8cabe,0x1c7fece3,0xa1650aa5,0x25f0020b,0xe04c0554,0xbd621e7f,0x27e835b6,
0x0c73e395,0xe812fe4c,0xa46b24e8,0xadf46a57,0xbe2042fa,0xf26c2cbb,0xbfd937d7,0x3e06eb3e,
0x024e21ea,0x0234e531,0x4c51eb14,0x42309893,0xb35ee850,0x8dfa7207,0xe31f6982,0x0f6dec20,
0x0e750d2f,0xf6f90efd,0x18debff1,0x40991a0e,0x3259aa41,0x35d9dab4,0x1d32ba0e,0xea3a0adb,
0xf8b41028,0x3e68d806,0xdfa6eeea,0x1057f823,0xf8f01799,0x0446c3b1,0xf44125d7,0xd3d717a6,
0xfb813ca4,0xf36bf8a3,0xe32c3a13,0xd97630fc,0xfde700a0,0xdf12fcdc,0xec651090,0xdd002c9b,
0xd86302f9,0xe8722443,0xd75b1e37,0x14cc1382,0xa6f7fdbd,0x05ce413a,0x03cc051b,0x1b9509e5,
0x157ee5ac,0xe72a0bce,0xdf931e15,0x17fae9df,0x2290ef98,0xe68edfb0,0xef6659f0,0xef20f2e3,
0x08afecc8,0x943c2933,0xd99b4c2f,0x393bf2d1,0x5547baf4,0x2cb2ca27,0x1d0bbeaa,0x09881259,
0xecc4f271,0x17dc18b0,0x1690c765,0x9d69331c,0xb4366b50,0xb12d351b,0xb3305a01,0xc5b83121,
0xe7593e2c,0x51fdaf66,0x143a0186,0x3494b828,0x03ccf965,0xf6100a4c,0x20eb1704,0x2538d060,
0x4b8aba5e,0xcd19e6f6,0x08991287,0xbcce1f46,0x127d05d7,0x255efccf,0xf98adbf0,0x19db17d9,
0xd93bcb72,0xd11a59bc,0x1314f458,0x4d75c18c,0xccece24c,0xe43e60ee,0xed321a56,0x3307dae6,
0xf98c096c,0xe421fa1b,0x06582c98,0xf685c67d,0x10292a62,0xe4bbeb39,0x08511be7,0x210ad763,
0x3f38cf9c,0x24a0d04b,0x2302b611,0xd3d6079d,0x0e0f00b5,0xf6b73e68,0x3618c5a5,0xf68bf3d7,
0xe69b2d03,0x303ceeb6,0x3fb8b510,0x1d23bd06,0xe59c1ac9,0x69e3b0ab,0xe53bdf9b,0xf40c2ace,
0xe870352b,0x04a4027f,0xcc9d1c76,0xc1131d32,0xf1d1270a,0xc69309e7,0x081327b1,0x01c0f56a,
0xd77e096c,0xcd5a4bda,0xca1815aa,0xbc3b7207,0x2cb7d5e4,0x2004080c,0x241ebc2b,0x1257f041,
0xc6cf16a7,0xdf8026e4,0xde3f07dc,0x34bbe48d,0xb4900acc,0xf574422a,0x04882810,0x1b16c061,
0x0a02321c,0x0315caf6,0x1ec60b44,0x1739ceca,0x3b76db3a,0x3814ac67,0x1f64cb36,0xdf0018bc,
0x2700dc3c,0xe2b31909,0xf5e6eb9d,0xfd1647f6,0x1d3cd3de,0x346f0573,0x0197b8cf,0x02e0245b,
0xda5e0999,0x0ed101a4,0xbe99fa14,0xf11d203b,0x1cc7fee9,0x434daee0,0xe2de1169,0xd5851759,
0xfba334cc,0xe497d5fd,0x2594293b,0x1eb1dd1d,0x2455e608,0xe200ed95,0xdeca40ce,0x10fc075b,
0x1100cc01,0xe9f92539,0xc906eeff,0x27b6222b,0xf0cdbd50,0x2dbc1487,0xc6be0fdd,0xea084adb,
0xc796fedd,0xf72c4d07,0x14941237,0x2c36bade,0x21fcf298,0xc048f43f,0x45fe0ffa,0xe225c380,
0x02291602,0xef7af7cf,0xda982652,0x8dfa51aa,0xbf867207,0xf33d3c45,0x396ec4ef,0x09690016,
0x0c7df09a,0x3064d529,0x062def01,0x1083d214,0xf317fe3b,0x6c74c522,0xd082ea24,0x0492124b,
0xddd62341,0xcfa34554,0xa65c2d05,0x8dfa7207,0x1fd83e34,0xf880d5a1,0x0288197f,0xfac1e4c8,
0x00d6f33e,0xd79834ba,0x2d84caf6,0x2d32ee1a,0x41b6b3a9,0xf36bfd57,0xfc6b176f,0x3fd0e6cc,
0xfebadc22,0x2744ecbe,0xc6fb188f,0x1f61ea99,0xb4d231ad,0xcbc12694,0x4159f868,0x1810c095,
0x3dc0f9de,0x31099826,0x319be918,0x05f4e887,0x18a9dada,0xfd673464,0x10f7df8a,0xcea73159,
0xcc6321c6,0xf89c441d,0x2b27b19c,0x0bcb09b9,0xe929bcdb,0x218e147a,0xe0b7feff,0xe1201e3c,
0xe6e91f83,0x0103ea3f,0x34d1ef13,0xfaefe3de,0xc4cc64c7,0xe59c1502,0xce5d417c,0xd6892251,
0x4a9be95d,0x0206c007,0x8dfa36c0,0x93077207,0xd11168d9,0xf1c40b1a,0xe8f9ff0d,0x2e911c36,
0x371da039,0x4bbdd763,0x4490a43d,0xc4d51273,0xb44c471b,0xc08b4ed3,0xf8fd0081,0xf2501901,
0x0105f920,0x0e0cfd9d,0x121901cb,0x1851e8b8,0x3177d821,0x0dddd4b2,0xdbad2a2c,0xc7f507c4,
0xcab546bc,0xf86b0ca2,0x0dc11aa5,0x322ec9a2,0xcb490d70,0x093a1fbb,0xe8c6f56e,0xe6eb4845,
0x2d16c40a,0x37c5004c,0x67f88dfa,0x26c5be17,0xf715e372,0xec07158f,0xeb021313,0x21650d14,
0x294bc9fb,0x2207d01c,0xad3a291d,0x8dfa5519,0xe9305f38,0xf5f9f672,0xe0d53183,0xee1cfae7,
0x108d11a3,0xe4d4f37a,0xf36931f4,0xc40f180d,0x1da20dd6,0xfe4fe6a5,0xd2181bae,0x3abd0b4c,
0xf3b2d4a1,0x1d571076,0xf022cd9d,0x45c113d7,0x26bfa63a,0x287aeecc,0xf936de6f,0xf18e0f59,
0xc90939b3,0x003c0173,0x2e1c0734,0x0dfca9ae,0xb142431c,0xcf632eb0,0x47d905a2,0x0f02d028,
0x071aee66,0xbcb11bd0,0xef841a8c,0xb453315c,0xf9e83045,0x02b9260d,0x1f57f0a1,0x2e6fe764,
0xffcdd3aa,0x1d89f7ce,0xed2cfa56,0x43d0cab5,0xd9b8e690,0x3f49fbe5,0xd7fbeefd,0x18560e94,
0xaa472410,0xf43b33fc,0x0d72f462,0xe13b2153,0x48b5f9cd,0xa351f836,0x0f8e40e6,0xd4e6ed1f,
0x18360e25,0xd2f8f6e5,0xbc862c5c,0x8ff07207,0xb2315023,0xad497207,0x2627f989,0x0cd0ec0d,
0xed7bf3c1,0x46a7e847,0x0dcbdd77,0x1de9d542,0xac9e3661,0x3efc0a5c,0xf90def07,0x30aae08d,
0xe7f3f051,0xd4eb02e9,0x1fb72047,0xe387cf91,0xc7fd41c9,0x00e61904,0x4115e4a4,0x089be8a7,
0xdf5402aa,0xa3607207,0x13380dd3,0xdb8926d6,0xf9f4fce1,0x1cddeb81,0xe9ecf910,0xfb37f5c1,
0xe6aa16be,0x304aea74,0xe57c0437,0x3339d81a,0xd62018e0,0xeb2d0ef1,0x045f1eae,0xd3f30ca1,
0x04202419,0xcf430804,0xebc022dd,0xcf4c16fb,0x4de5faae,0x19e7c6dd,0xe8e6fabb,0xef9f0f8b,
0xd06d1b38,0x214508ab,0xe093e40f,0xcd5d5dc9,0xab3d30b6,0xe8ef54cf,0xd0d313ce,0xe2e123c9,
0xf1e92478,0xd345f292,0x136323f1,0xf90ccf7e,0x1870205a,0x17deccd5,0x27b0028c,0x11d0bd23,
0xf8baf507,0xf929231b,0xc1591282,0x98967207,0xe65141d3,0x088707be,0xe888e27d,0xe6403e63,
0x1a14d1e0,0x1c6aebee,0x1487e692,0x43add172,0x6783b7af,0x3c9b9312,0xe3ef08a3,0x0b49f823,
0xe2751b09,0xf5e70859,0xd2a21ef2,0x8dfa7207,0xfbfb4177,0xbbcc0a97,0xedd74b36,0xfec3efb0,
0x32d10071,0x2843aaea,0xd2f6132d,0x49e1f115,0xe475c7e4,0xfd72248f,0x09eaf6cb,0xf9b8f566,
0x03b20e31,0x13a6fa7f,0xf6d800fb,0x1a95fdb5,0x2fecde97,0xfe61d9ae,0x181df45f,0xcb9d0ee6,
0x4987f43a,0xb82bec66,0x1d6d3164,0x03eddee7,0xf2620f59,0xe8842154,0xf3e5fa31,0xfa5a1630,
0xbbbd0806,0xf240454a,0x2b68c0c8,0xe98e02a5,0xf1551e4c,0x16a40544,0xdb090ce6,0x1b6f0eb5,
0x2294ee09,0x3968b98f,0xf014ec3e,0xf3720a25,0xf8550cf7,0x0b38edf2,0x48efee2b,0x1971b4fc,
0x392fee86,0xe6bee31e,0xf22b037e,0xe29427cd,0x2338fa70,0xe67df2be,0xfe601fd9,0x0a6cf6a4,
0x0ccdec2f,0x0504094e,0xd0af1a15,0x2ecb03d1,0xf9c8d7be,0x40cbdf6e,0x1583bf07,0x00be0e88,
0x01ecea59,0xca0413b9,0xf09c41ba,0x011fe5a1,0x3e0cf087,0xde3ef645,0x2b03fb28,0xea680313,
0x222902c0,0xd6bdfdc4,0xf2d81160,0xe3fe1d20,0xf17e013c,0x0fc413f5,0xffc8dc2b,0x195d00e3,
0xf0abea14,0x386df119,0x0c72c861,0x0f45f888,0xa7b23d9b,0xefe23317,0x08af2c11,0x41c4c24e,
0xf5b7de6e,0xc4b32508,0xdacf201a,0xefc92009,0x52f2d3cf,0x392bb1d0,0x5c19b45f,0xee4ee7ec,
0xf4531130,0xe9691bc4,0xe5bb1186,0xd7ee0da6,0xd76046a9,0xfa3f11a5,0xee6f1cc2,0x0e79ec57,
0xe268160a,0x493fd255,0x35edc6a6,0x3b49a833,0xf1a8feac,0xf694132e,0x0954fb75,0xeabf20d3,
0x3068e378,0xf5c1f3a5,0xc976079f,0xd9b1551f,0x45bfcf76,0x398bd230,0x2df2aba3,0xfb331c6c,
0x2de9d069,0x443be450,0x34b6a61e,0xc54b165a,0xcca94b91,0x0429ec47,0xe35109ee,0xf852ffc1,
0xda303601,0x2191dc8d,0x02c91405,0x191bc44a,0xccbc35b4,0xe3ed2a45,0xd4912972,0x1e2d1fa3,
0xfd32e06b,0xe72c0bbf,0xb9411772,0xd05c5f20,0x0288d6ce,0x0412107f,0x0e9edd24,0xeab9378e,
0xf635019e,0xeec51dc2,0x0740fdc4,0xcd411fc4,0xc9714283,0xf4dc04eb,0x103e20b5,0x08b0bf4a,
0xe9d92bd2,0xf364e5d9,0x0b8e3730,0x3e53aaae,0x13b4eb9a,0x1608d338,0xd39317c9,0x1956188b,
0x15c8cfa7,0xf5e71a84,0xeff40a82,0x08cf0b8b,0x252dde2d,0x11c3ea4d,0xab910dd9,0xed564947,
0x0f6cf045,0x1f7ffdef,0x0dbdd630,0xd85a134b,0x1a8410e7,0xfae3c0be,0x238919af,0xf39cc28a,
0xef1c3b2a,0xeee20475,0x23d10f88,0x2998cde0,0xfba1f76d,0xddef1e1e,0xfb241103,0xf5b00a53,
0xfaefebbf,0xf0122676,0xed3feb40,0x44d30b9e,0x52928dfa,0x2c6acc1d,0xdd96f1cc,0x3d610670,
0xd7b5eec9,0x176e11f3,0xbc7d3379,0x1f31f659,0xb7fc2c84,0xf18323ab,0x2d1af05a,0xeee1c8c3,
0x0fac22d0,0x0268ca27,0x4bb7f5c1,0xdf23d8c8,0x375d217c,0xcc29f571,0x14a21610,0xfee8ef31,
0xfac8fd8c,0xe2910d22,0xf0791a4a,0x334be3db,0x1a47b492,0x44eeed75,0x001fd810,0x3131df6d,
0xcc471cb2,0x0d23092f,0xe91a12d7,0xf6d10d3a,0x13bf174d,0x403ab191,0xfdbaef75,0xda99123c,
0x319dfaec,0xdf8f00d3,0x45e9d78c,0xef33d7a0,0xfb71eca8,0xa4f0545f,0x19801ce6,0xdbbf147d,
0xdac4394e,0xde3a1570,0x98744e53,0x0dde1c06,0xb5a42acd,0x3846eb83,0xda2afa1b,0x2998ef68,
0xf72c1a03,0xe4a7f1bc,0xcfe74f39,0xd9f3083b,0xd8fc3b83,0xd27b26a6,0x10870a1d,0x0b8af60f,
0x1ec3cde6,0xf56d27a6,0x65f7a631,0xd594057d,0x26badf7a,0xef8c045f,0xf9be0c55,0xfd7a0d0f,
0xe62d06ed,0x194f0065,0x16b6f94f,0x1fadb740,0xe6811df2,0xfb17ed86,0x079b2db4,0x0c57c33c,
0x10f0397f,0x137dc379,0xde8d166b,0xe8c81a5c,0xeecd0405,0x39f5ff68,0x2b769865,0xdd2926d5,
0xf040e142,0x01f24868,0x125fbd51,0xf9062c35,0xe4f9ecb6,0xf1bd4684,0x1e2de76b,0xe8fe0332,
0xf45e2f2e,0xe452e890,0xf9964881,0x02e5aabe,0x16741420,0x226dae84,0xfb091115,0xe478ee89,
0xe393435b,0xe7bd0e20,0xee082c5f,0xb4245d63,0xd6062564,0x138f27cb,0xefc0cf1b,0x0346100e,
0xfe2ce256,0x14010f3a,0xe3e4cb73,0xf9ed4334,0xc7c7f709,0xf90b36d2,0x29e5fe11,0xf1b5d522,
0x12b817aa,0xc2551233,0xdc5f563c,0x160cee0b,0x5deae745,0x010795b6,0xe15d388b,0xd9960ad4,
0xda571f93,0xd19e1d71,0x8dfa463c,0x3aab3174,0x0cb1c24a,0x28cd051c,0xff44cada,0x00fa2d32,
0xf1590cb3,0xfb651f2c,0x4159d34f,0x0a8bbb54,0xd1d32756,0xec6c0fbc,0xf5ff0840,0xfb4403f8,
0x3b91e8de,0x9d700246,0xec26667c,0xe3fc0e58,0xedf41782,0xd37b1a5c,0x0f871040,0x207ddb98,
0xf150f8fb,0xfb60021b,0xba331945,0xe74d3df0,0xdf352a98,0x4706f9a6,0xe874e203,0x12d81929,
0xf497d8a8,0x0b3a1848,0xd9c7f5da,0xfde02524,0x2d16beed,0xf97aeb54,0x112a07e3,0xd3aa202a,
0xdc7832fb,0x029efc5b,0xfa7510a5,0xf104ecef,0x0f0f165a,0x0844fc6f,0xeea40f78,0x1f83e216,
0x2e2cedfd,0x308cb13d,0x04e0fc28,0x16b1da57,0xed83f950,0x20c90384,0x0558f8f5,0x1baf080c,
0xfb85e91a,0xf06e1420,0xe9c7e7fd,0x038a3b94,0x3a13ac03,0x1972d678,0x03f8e777,0xd9dd236d,
0x1c0afe37,0xf0091bab,0x3331f007,0x2e5aba39,0x3349ed63,0xf65cc3d2,0xf23f2a99,0xcfcd14b1,
0xe1ae2553,0x149afcf0,0x2c73e4db,0x1f9ccb11,0x1325efd6,0xe0200359,0xd6ea1db9,0x29fb1ba3,
0xfc1dd5b0,0x286bec67,0xa42a0329,0xd0c96d46,0xcec919d4,0x257f1bac,0x18fad897,0xdf542215,
0x2479fa4e,0x1835d334,0xfad303c4,0xc2bf0891,0xdfa4347d,0xff97f102,0x06c3137d,0x0ca5ed09,
0xc8e90cd3,0xb1624e9e,0xcd8940f9,0x075d1a8f,0x2e6eeeee,0xf6bff208,0xe6e91d87,0xfa900762,
0x0a0b18a9,0x3209bae4,0xe9b10db8,0xffc3deae,0x176fe558,0x1b2fd5b8,0xc88e16ed,0xf42f37a6,
0x20ea0124,0x0cee086f,0x4a2ad6b0,0xe0d2ed25,0xf4d719a8,0xc8731b56,0xc9861c3d,0xf72e228f,
0x0c71df38,0xe9ca0dd5,0xcad90aef,0xe2124de9,0xfae60a0d,0xf8bd1475,0xfc7a0c84,0x1c63f3d2,
0x121d0ad1,0xfac4d471,0x9fbf5595,0xd0bf2d69,0xebc32aa0,0xebf0f1cc,0xf9d2199b,0x080fed85,
0xe1fc072a,0x00471f6a,0x3c2fdefa,0x5e2fc7fc,0x38be9129,0xe6402059,0xf90b066c,0xfc211c04,
0x0a24eaae,0x4344eb81,0x37a5a75b,0x2510b2d6,0xcfb8159f,0xfc990129,0x025d25b5,0x1a72ea8f,
0xe62c0c55,0x0474020b,0x21a2fe47,0xf21de1d0,0x3291032c,0xfb5bc640,0x072c0581,0xea930569,
0x01ab0cb3,0x09bb0eb8,0xcf23feb1,0xecd14a75,0x393ec4d6,0x12bb013a,0x0e53cdf6,0xdc4826bf,
0xbbda29b7,0x0b9f1148,0x2d7de723,0x19efcc66,0xcfc9ff55,0xfc6e0f9a,0xf36900a1,0x04a208d1,
0x27a917a4,0x32fed410,0x43f1d1ba,0xbc9af954,0x940d5d50,0xa2a8711a,0xd7212f8a,0xe281ffe3,
0x0e0d0b74,0x36afe39a,0x48bbaf91,0x51e0dc49,0xf044c643,0x2bc51277,0xe229e611,0xcbae274f,
0xf02a256b,0xede7faf6,0xbc3e2d41,0xef502145,0x15ff1567,0x3c2fc21c,0x1da3f7d0,0xf9c5eb6f,
0x07a515ac,0xeb37ead5,0xf922027d,0x8dfa40ca,0xd96e6135,0xd13725e8,0xf81d212a,0xefea1356,
0x374eeb9f,0x6244c35c,0xf9ccaeb2,0xdf3a32be,0xb90c1fd0,0xeec43dbc,0xcee11105,0x07c41d28,
0xf3f0f368,0xe9b61731,0x0557fb6a,0xe79cf88a,0xcc494a5b,0xde940f07,0x3a131005,0x0eedc266,
0x0b410d2c,0xecc9022d,0xca7a3862,0x05d32614,0x14d5df41,0x1b4fe4d7,0x1224ca43,0xf5ec2836,
0x0582cfcf,0x2349f13f,0x04cde390,0xec01fc36,0xc7554853,0x1fbf0b2f,0xf6dcf170,0x0b2a0637,
0xf5c9037f,0x2ca9f6ab,0x1a12ddd4,0xc86f0328,0xf17c2679,0xc4a123b0,0xff151e69,0xed67fdc7,
0x19f9097b,0xfdd2c8bd,0xea6b2819,0x21ed0588,0x1c74d0b3,0x37bbe7c6,0xe847ec7f,0x16e90239,
0x14ede2d1,0x162ef2ee,0xfee6ef46,0x1c22f339,0x381ac0c1,0x0210e3c6,0xedf11c9b,0xf39104f8,
0x17570916,0xd7a414cf,0x1144fa44,0x2403dee8,0x00b3ee09,0xc228268b,0xe86f26c6,0x0dc0f8d8,
0x0130efc9,0xe66c2feb,0xfc29fdcb,0x105cf504,0xceb50874,0xeea134ff,0x1aaf0328,0x416ecc78,
0x0b21d3ee,0x036df334,0xf8e6070e,0x080ceee1,0xbde81fa3,0xe06f3288,0xf8d60335,0xe2272111,
0xf4310fa7,0xd1af2904,0x482dfffe,0x3c49af0a,0x26eec988,0xd74ffc73,0x0f7c1a5d,0xf51304b6,
0xa3cb3344,0xd22d4aaa,0x11c81528,0x29b4b462,0xb95f0c14,0xf1a237ae,0x07f611dc,0x2b7fd26f,
0xed7cec3f,0x2595f9a2,0xfa2b0741,0x059df654,0xdf7009fc,0xef652636,0x0d2f10ad,0xe40707b0,
0xe06b2049,0xf36013e7,0x5c41bb18,0x0258b5f2,0xef401b0a,0xf00a0d6b,0x33bae4bf,0x1aa1ead4,
0xfa28f500,0xdd483581,0x0cc50d56,0xfe45eb95,0x0d050312,0x0ba5e0d6,0x013bf562,0x05dbe406,
0xbb902cd0,0x05281622,0xd1b71144,0xd47831f2,0xd9e9347f,0x306612f0,0xff15d938,0x0f9209c2,
0x37a3d437,0x33b7cd4b,0x1aacbb69,0xcb6f272b,0xdedb16dd,0xe11c1b05,0x0c79071c,0x13d1f408,
0x06ebfa5b,0xf99d001f,0x274dead3,0x5366c9e3,0x280fcce4,0xf2b7e47b,0xccbd2946,0xdd4f1dc9,
0x077009a8,0xf13af965,0x299006dd,0x1bb1c975,0x0d70fef1,0xfe55ef60,0xf43625de,0x16180420,
0xdb08f2b7,0x115b1dbc,0x0bc4cdca,0x117500ad,0x13ebb289,0xe5d019a7,0xf780080c,0x01f61a0b,
0x0920fd68,0x1684f0df,0x1879ffe4,0xcd8202c3,0xf5932f35,0x1129eccc,0x1678f351,0xffd2e9da,
0x0f850e1e,0x042fde04,0xfedeff8a,0xa9540855,0xdb224a0b,0xd91931c8,0x0b691561,0x1c38ef31,
0x09a4ef43,0x1405fd58,0xde38fe0f,0x36dd0b5f,0xccafd065,0xc0035aab,0xc03a1f5c,0xfca43cd1,
0x003be376,0xea0b06b3,0xc3b738e6,0x13f01c83,0x5569d14d,0x1830b495,0x197d0824,0xfed4d959,
0x108c106a,0xbfff00cf,0xefb84858,0xc5a112bc,0xe8d82949,0xe9291ba1,0xf9410925,0x0b23ea26,
0xf9affb53,0xff571312,0xe91bf65b,0x1eb718f2,0xd482e585,0x00452f86,0xf04902da,0x14b6ff59,
0x169de485,0x130df948,0x15c4f0d9,0x18dde8b0,0xf6d20412,0xe5c30032,0xe8f236e3,0xf6aaf754,
0x14caf18d,0xe4b3fa10,0xd52a102a,0xeadc2a7f,0x6166cf8c,0x0308d248,0x468cf3da,0x42a5ca75,
0xff45d6d7,0xfa141471,0xef62ffac,0x3ae3efc1,0xf7ccda74,0x3cf2e34d,0x0452b713,0x20b6f98d,
0xeb300103,0xfb920ccc,0x04fe1849,0x4d81d46e,0x3661ba98,0xf7e6f365,0x039c14ba,0xe5460ad6,
0x1a98f724,0xf14fd71e,0x05b40d85,0xcf380162,0xd46e273b,0x296b1fd0,0x3d3bb56e,0x1652eda5,
0xfc04f78c,0xff8510c2,0x190bf099,0x230ce120,0x0d66efaa,0x3085d782,0xecd1f4cf,0x042ae8a2,
0xd86126a9,0x7207d1c2,0x6d448dfa,0x40caabc8,0x4483c9cb,0x1a12e082,0x28a2d49d,0xd966fbaa,
0x099e1046,0xc76c1061,0xff1118c2,0x114001c7,0x6ecebbe7,0x324faeb8,0xf61be6ae,0x17dc019e,
0x0659ed14,0x2fb4e45d,0xcceada6b,0xb7ce6dca,0xc987460f,0x30e4f167,0xfdb1fc71,0x0e8afb02,
0x001e16ed,0x1ed0c1ae,0xedd8f83c,0xf0121307,0xbc2831a8,0xfe090bf1,0xf7980587,0xc24c2767,
0xef6e1c86,0x8dfa4990,0xb0b37207,0xd3e6403d,0x2cb30a5a,0x6ab2b123,0x311fb8e3,0xfee3f1fb,
0xf34bfbe9,0xfde91357,0xe68af08a,0x8dfa4ee0,0x8dfa7207,0xcb8b6220,0x08f01608,0x12f9ed35,
0x1ac3f4c0,0x6604c4a4,0x5070a238,0x1311dad1,0x08c6fdac,0xc34c14f7,0xb2965bcb,0xddef2b05,
0xf15902c4,0x184cf3f8,0xe38bf3fa,0x01111f96,0x5e7fc385,0x4a8dbcaa,0x3b85c1d6,0x0889e1be,
0x0c68073d,0x136ee1e2,0xe0440194,0xd1b725d1,0xfca515a5,0xfd2aff7d,0x0ae9f5e1,0x0979fd15,
0x10f9f104,0x063eeae4,0x2647e824,0x01f9f42f,0xfa2c0915,0xff14f8a3,0xbaf9278e,0xee743b16,
0x027ff45b,0x2facf2f0,0x3c4eb465,0x0551e845,0x19d9fb4d,0x194fe8c5,0x0d3aefc0,0xe8a305e2,
0xf3291bf3,0x0a55f32c,0xf9fc01fe,0xffa1e1c0,0xf7ed139b,0x290ede96,0x1da7dfa7,0x1e46f1b3,
0x078bf46f,0xffa3053b,0xfa220375,0x2a2af119,0x5032ae77,0x08bec687,0xd9361ee7,0xe9272312,
0x0c8dfdf9,0xe2340a7e,0xe70428b3,0x01e213b8,0x3a50d462,0x1924ccb0,0x018efdf1,0xe754f5c4,
0x02311984,0xf214020f,0xed3c0b41,0x2147faa0,0xf7b1f54e,0xec871814,0xeedf0c0b,0x00940920,
0xf6dbfe91,0x0d8a0400,0x0103e744,0xf7d413f8,0xc01f31ab,0xe36c2e5f,0x0ccb0f11,0xf765f68c,
0xedd20727,0xf31ef3b6,0x02f411d0,0x1b3ae8da,0x1c8fed10,0x1f71dd47,0x1728e43a,0xe8bc10aa,
0xe6690ca7,0xd1793482,0x19dffd24,0xfe17fd40,0xf81bfae0,0x0e5f0976,0xf59af2e9,0x0e7903ff,
0x0a89d9d7,0x36abeb21,0x3546c715,0x1fa1d52a,0x0ae0fb11,0x297de178,0x0bb9f5fe,0x1a83de57,
0x35fedfbd,0x353dc184,0x1ef2eeb4,0x46b8b3fb,0x5049a063,0xee69e51a,0x011e0683,0xf724029b,
0xf99002b5,0xf6761c04,0x059df19a,0x05eb0461,0x28b3f463,0x03fff5ce,0x111fde87,0x1eaef11c,
0x07b7ebb1,0x12fcf30c,0x063de8b8,0xf5d2f61a,0xab93468a,0xecaa39e0,0xfcb80d85,0x0449f715,
0xceb11646,0x29a800da,0x6534a005,0x48049fbb,0xf61bebda,0x06b70fa7,0x58a7c45e,0x0b45dc58,
0x2644ecde,0xf88aef1d,0x0e2e0372,0xf658f2f0,0xd5012541,0xdd042d89,0xfd31056a,0xff2a1035,
0xf387f0c6,0x27cee65f,0x2d3fd491,0x2918cf2a,0x1828ee68,0x27d9eb9b,0xfdfce64e,0x13e6fcc5,
0x2726e2e9,0x12d8c6b1,0xebe31559,0x3265f3bc,0x6188a342,0x1b9dd1cf,0xe9430840,0xe5b2032a,
0xd4ee2b54,0xad923458,0xd1393fdb,0xd1cc40e0,0xd6cc3505,0x07dc231e,0x2752d7e4,0x02bdea03,
0x00cd04c9,0x23c0d401,0x42fcbbd0,0x61a6a81c,0x052ebaf5,0xf8360ebe,0xea3816f9,0xdcdb2eed,
0xeb0d1f5e,0x029b14f7,0xeb5d15a3,0xdfb61c48,0xf004193b,0x158fef6f,0xf7efef66,0xf4ab019f,
0xed8e0290,0xd9e60dec,0xed412bcb,0x1323f6e0,0x24d2eeeb,0x347ddb0e,0x1f5ed837,0x14cafcf1,
0xf5e7f469,0x928637d1,0xed6348c5,0x0861fc04,0x1e29de00,0x01a8ef1d,0xe7f006eb,0xfc7211ab,
0x0b80f273,0x16b7f49f,0x2134f7e1,0x536ec7c6,0x15fdbce2,0x158fe86e,0xe81d13bc,0xfab3fd68,
0xef0f0cf4,0xfb241465,0x2c85e5aa,0x1bd0cdf5,0x3bbee32f,0x1c16d2ad,0x4cd5c6f3,0x2552b88d,
0xfa8af68f,0xe6d92712,0xfc1dfbf6,0x00b918fc,0x2f6acf86,0x22dcd64f,0x2b8dd87c,0xf7aef914,
0xf2fd1759,0x1bb5f270,0xe751ff28,0xda3214fd,0xe91c290a,0xfd60e57e,0xbd5f27ff,0xf3aa1b3c,
0x0e5610e7,0xfb63fef9,0xf42e2554,0x32c7f0c6,0x28f0db0b,0xfa55fb23,0x14fddf45,0x21b8e867,
0x40dfa660,0x1658e24c,0x3a8dc3c1,0x2de1d068,0x1debd6c5,0xfc92ff4d,0xda0f1f17,0x262c0ffa,
0x0b16edb1,0x02bbf388,0xe42f1e14,0xefee057c,0x041d03c5,0xfe84ee04,0xfa9c07e3,0x0b66dcb1,
0xf7c7116e,0xc10211db,0xbcae5b80,0x01cf25d0,0x0096f72d,0xe1d32df7,0x09affc7c,0x102efa90,
0x0370f01f,0xfa6cfe1c,0x1392d853,0xcf4b2261,0xb7d33db8,0xf43733e5,0x18e9eda8,0xddf9182d,
0x0d9510df,0x0e46e601,0x1b70e62b,0xdca2f24e,0xf61c1d3d,0x0d3ae473,0xe27517a4,0x0eb5157f,
0xeb2304fd,0xdf1e2081,0xdc762d5b,0x00fd197b,0xc5991809,0xf58922c8,0x1674eb7b,0x279ee34c,
0x124de399,0x040ff210,0x474bd3db,0x2866b24f,0x2092e318,0x1736e410,0xf0cd138d,0xf5c01b61,
0x2d53ddb8,0x215bdf68,0x2e3cc466,0xdfd3fe1f,0xf22818ae,0xf63d0a4e,0xc68135e0,0xf48e1c85,
0xe4cc0ab2,0xeca92310,0xd48d1566,0x16abff51,0xfc0cf9b0,0x03da0edd,0x1aa7edc6,0x06a3e2ee,
0x12510694,0x11d8f3eb,0x247bcdcb,0xe525fc26,0x178508f1,0x052ae5f9,0xfecb04fc,0xdea41412,
0xf9cd1911,0x0460f54b,0xd92113ac,0x22f3f962,0x05a6f057,0x1b7bf41e,0x041de98f,0x18f0f9eb,
0x0316f9db,0x2ee0f721,0x2260c6fb,0x31bdd618,0x0472e8d3,0xdc9a0ab8,0x02c0149a,0x05d8f24e,
0xff67f24f,0x1320ebc3,0x3b7ad769,0x0457e1fa,0xf92b0949,0xcf21298c,0x02461d4b,0xe38e2377,
0x11f50eaa,0x208dcf8d,0x1cc7e754,0x392fce01,0x42f2a98c,0x3699b617,0x0bdce760,0x0658eb26,
0xec1a0e1a,0x0d2b0674,0xe5bb1176,0x26300364,0x0468e542,0x1411136b,0x13f5dfad,0xfdb2042f,
0x079af129,0xe8befeb2,0x0a53ed15,0xf830ff8e,0x1251f830,0xeab1f36c,0xd1333584,0xccea349c,
0x074e1882,0x270fe774,0xf23d0837,0x04b2090c,0xdf4e1155,0xe039201f,0xe05512c9,0xfcd6010c,
0x00840002,0xea1bfa0d,0xe1672cb7,0x0122fab9,0xeafb23c2,0x02021469,0x28b7e1cd,0x2758ddf4,
0x1f90d423,0xe3570947,0x0a4dff69,0xf06c041c,0x020dfd77,0xf0b90ad3,0xf372fe58,0xeaef1f0c,
0xf6a60a98,0xff670674,0xf53f07b6,0x3869fced,0x22b7cd4e,0x1451e66c,0xdd84180d,0xf0741080,
0xfaf1f6ef,0xeb0bf72c,0xddd21725,0xdeea05fd,0xff912850,0xfa940fcc,0x016b15ea,0xfb550aba,
0x01330646,0xce1715e4,0xe5ab2460,0xcbd123ea,0xf6e71658,0x05abf6eb,0xf938fd4b,0xf204150e,
0xf82b03dc,0x3647eb83,0xe92feaaf,0xd867246c,0xec150bba,0xf0ae186a,0xba5d373d,0xec6d24c9,
0xd6951ac7,0xd35d414c,0x1abb0c3f,0x2880dcf8,0xeeedede5,0xbd2f36f9,0x0b631419,0x19bbd86c,
0x1260e24c,0x1298eb67,0x111ee575,0x09e7f311,0x127c0524,0x2d12eadd,0x1c7adf67,0x1219f722,
0x14dcef42,0x196edbea,0x1ffee3e9,0x1ac0c81d,0xdd670312,0xe91219f7,0xf6b005e7,0x06b91222,
0x07c8ed14,0xe33620e2,0xfc140d7d,0xeb3410c8,0x18c5005f,0x1de3ea95,0x06a9d435,0xee9c0e0a,
0xfa7517b6,0xf7c9fdab,0x016dff8c,0xb02221c0,0xba4d64da,0xfc140b37,0xf10b015d,0xe4180dca,
0xd63f3cd1,0x1e86f9da,0xf5cdf7d6,0xe98122d5,0xfc7109a7,0x151a00ef,0xfb32e1fc,0xf43b0acc,
0x24d0e2bc,0x1c74d61f,0x1b91eab3,0x0da1ec1b,0xd8b6198a,0x0127261b,0xfaddf886,0xfb7906a5,
0xf73504be,0xf7b60535,0x0e2904d8,0x06a6faef,0x11a4e179,0xe70cf8db,0xea8920be,0x1b10f715,
0x221bdc89,0xdd68ff01,0xcd6c36f4,0xd9964324,0xfe7c0227,0x01160257,0xfa6c0188,0x1309e77d,
0x0900e726,0xfe311391,0x0707fbe1,0xfc140288,0x2928ea1f,0x1278d69a,0xe892199d,0xf4e00954,
0xefbe1211,0x16ce01f5,0x15c7ddc4,0x0bf7ea39,0xd42310c8,0xeeae1a32,0xeeaa10eb,0xe165120d,
0xf6491469,0x1e7b01f5,0x1a20d59c,0xe8720f20,0x17e0fc4d,0x15bbedaf,0x1286f0ba,0xffd7f37e,
0x057bfbe6,0xff1e0a23,0xea5a0265,0x20f8f19b,0x14d1dee5,0x00beed5f,0x01b1fdc1,0x1622f260,
0x03eb063d,0x2d83e230,0x3a29cf9f,0x473bbef8,0x2517cc75,0xda1bfcaa,0xfb921421,0xfcd202f4,
0x18adf74b,0xe3c3fe5a,0x0a7914ef,0x1ebbed00,0x12fed93b,0xf522f43b,0xe90b0ec1,0xf80a0ec8,
0x079aff04,0x1d68f8d5,0xfb63e4af,0x05be1680,0xfa82fe6c,0x0a6f0179,0x12dbf880,0x21c9d0ca,
0xe5100708,0x035707b5,0xdcb61689,0x0c20fe2e,0x0da8f10b,0x07b3e616,0x186df167,0xda33114f,
0xfb3107e1,0xd80931ca,0x27d90eac,0xf30fe99d,0x1294f4af,0xde390e60,0xed8a1dd2,0xffda025d,
0xea0efc33,0x01e0133f,0x107df4db,0x1e6ad49c,0xc1660fde,0xcd3d5371,0xfb5a1dea,0x267ce34c,
0xf2edffd6,0xe6b812d9,0x1651fe98,0x1cc8dfa1,0xed37ef6a,0xf1811ab3,0x141ef1e0,0x07b8f469,
0xf9930dc4,0xf9881300,0x06d4faf0,0x13f80011,0x0931d5c5,0xfa17f931,0x1549f358,0xf7cef058,
0x0dfc04dc,0x0518fe0d,0xf4430ea9,0xffbe0983,0x02f01410,0x0b1ae7c5,0x052aff8a,0xe733fa9c,
0xe7ff1da3,0x00f6f724,0xdd10052c,0xe7b42545,0xf6f711a2,0xf3340ee9,0xffe6fc25,0xf9951ea3,
0xfbf6f7a5,0x0c580ccc,0x09abf02b,0xfb9302c4,0x0723ec83,0x02950b9d,0x3208ddd6,0x1b02e169,
0x0a0dec77,0xfa12f54e,0x0f8d03ff,0x2c14d01b,0x1430d103,0xfeb5fbb7,0x163aee53,0x2110e813,
0x08fdf69d,0xdec2159c,0xfb9f2490,0x1d0be802,0xf9cdf892,0x26b2f2f7,0x060ee8da,0x08e4faff,
0xeb7ef954,0xe7661088,0xee960c57,0x0e7c06b0,0x0822dfe1,0xef1c0ee4,0xf5280e44,0xed0e23c2,
0x1ad5004a,0x01edf4a9,0x2a79f105,0xfd82cf69,0xeaf71c0b,0xe8bc0903,0xd1bc2219,0xc8cd3714,
0x03c71d3d,0x1480ddd1,0xf38ff374,0xbe4f3416,0xb8a84d6b,0xeee231d0,0x05910701,0x1933047b,
0xffb3f128,0xe5f10544,0xc23433b6,0xf3de1967,0xe2c70a9a,0xeb9e101f,0xee920ff6,0x0967ff66,
0x11ffebe8,0x09cd078f,0x2e4de1f3,0xf419f581,0x03bc0375,0xe12412e4,0xe9571a86,0xfb251354,
0xf0d80351,0xebaf0ce0,0xed850d7e,0x1513ffed,0xfca7f2be,0x120a0285,0xedc4ffdf,0x0b780e88,
0x074bede1,0x0de9eca0,0xe9ca0230,0xd8892f90,0x1471fa75,0x00e4efdc,0x010b08fe,0x042bf90d,
0x37e2df94,0x015fde2f,0xf1c21443,0xf3ba1427,0x03500337,0xec7f0e5a,0xe40413c4,0xf87b0565,
0xf07b0eea,0x0899fa28,0x003ff6fc,0x2935f243,0x1a41e946,0x1b91d822,0x080afd20,0x16a0eb8b,
0x05acf6c5,0xdcdf02bb,0xe582300c,0xef54106a,0xea880b71,0xe8be1ec8,0x0c38f9f1,0xfd95fd0b,
0xf94def77,0xed1528f8,0x1d03ea88,0x0798ee96,0xecec12d7,0xe8aa203e,0xf3c116d2,0x0419f1d6,
0xf46c113a,0xeacb02e1,0xd3e41ef3,0x1753ffde,0x0da6ef75,0x0753ecb6,0xdce81614,0x00931cf2,
0x1a2ef058,0x0a1ef26b,0xf899f60a,0xe70c1a2a,0x0f7a0ac6,0x2fe6d0ed,0xebcb00b2,0x07c7fd9d,
0x01e3f50f,0x130bf12d,0xfd2fee99,0x1ab8f1f9,0xfd780297,0xed670fab,0x17e60432,0x0aa5e58f,
0x05800887,0xfdf30582,0x1a2ee771,0x04f9e0f3,0x0acd0130,0x06b0db83,0x19e1eed6,0xec680a9c,
0xedf60b52,0xf84c1701,0xfac2066f,0xe0bb2814,0xeaa71eb1,0x0c0c0c0a,0x36d0ca4e,0x0336dfa7,
0xf57ef3f5,0xfe8600be,0x08910115,0xfdb1f31b,0x1940052a,0x2392e03b,0x09b3fa71,0x130efbb1,
0xf808f970,0x1d9ae920,0xeedfe83f,0x0f7e0f3d,0x228bd618,0x0fd1ef92,0xe67cfd59,0xec2e1c56,
0xec5416e8,0xdd37174e,0xefe124a9,0xf0140b6b,0x1cedec35,0x0a39eb5a,0x03471475,0xecf20076,
0x209400d4,0x05bce923,0x14f9f46c,0x044aea0b,0x0010fa6d,0xe65007cf,0xda811912,0xe69b1847,
0xf6181cd4,0x087b0b69,0xfc76ecae,0xff19ff9d,0xeb1e1da0,0x1293047f,0x17fbdde7,0xf3ba0d63,
0x065cf6e2,0xef490af7,0xe0f2151e,0xd9432ad4,0x09a212b8,0x1a3defa0,0x2ee0c7ef,0x0cb3e0d6,
0x1e7de3fb,0x21b9d875,0x0eb2f2d1,0x1c3be28a,0x056efc48,0x084df969,0xebde042a,0xfa7012a4,
0x061b02c8,0xfceef835,0xf12a0cb1,0xf2d10c6a,0x3161eddf,0x0601d434,0xfa5f040d,0xff8d078a,
0x0d58fd67,0x09b3f5c5,0x047404ed,0x3cb4ef07,0x62dd97cb,0x368dabed,0xe756f053,0x01700c5b,
0xeaeafbd4,0x026206da,0xe24410f5,0xe2842494,0xf63e20bb,0x0525095f,0xee72ff74,0xe9191d6f,
0x0a970781,0xfffff03d,0x1180eaf9,0xe9910053,0xe4d91214,0xf3931515,0x03a40095,0x07ff0a26,
0xf889004f,0xf7f30eb1,0xeff01730,0xe8e11c05,0xf8950008,0xf5dbfaf9,0xd978191d,0xfb1f0a10,
0xfb2110be,0x0a8ff661,0xf8c1fe31,0x0f660786,0xfbd7f134,0xf88d123f,0xf57dfa56,0x0b0c04bf,
0x175be8db,0xdab90ed9,0xecd62059,0x0235143e,0xfcbafca2,0xf343092c,0xffa7ff7a,0xf8330023,
0x0cf5fa92,0xf3cff79c,0x0963029e,0x1ddef6f2,0x23fada42,0x010ce3a8,0x0e5f0337,0x0f1de2c8,
0x0c78efb9,0x13bff710,0xe6a90c6f,0xdfc9272a,0xe73c27ef,0x1d3602b3,0xff4fe16a,0xf7a1ff4d,
0xde1717ed,0x1b1303e5,0x1b65d4c5,0x035fea19,0x02f909f3,0x10f4f029,0x2129eb52,0xecf3ee32,
0xf1ca1ec8,0xed0509ab,0x18610df9,0xeee1f383,0xef8a157e,0x0e1ef336,0xf474fdba,0x003b0ab5,
0x040cf65b,0xfde30f48,0xf09309ae,0x14db062c,0x18dce3ef,0x0a41f1d2,0xfa24fccb,0x13e6ee29,
0x02a1ea63,0x0a2d0742,0x1a25e9be,0x240dd65e,0x1565e3a6,0xe8f2001e,0xf3c60ff1,0xfc9f0483,
0xf6bb0e65,0xdfb7179a,0xf4922d3f,0x1345f721,0x0440f521,0x1360eb6d,0xfda5faff,0xfd57f676,
0xf1e802f1,0x10be0426,0x3f1ecdfa,0x07fde485,0xf0e5075a,0xffb90bfc,0xfd61fa09,0xdf530a39,
0x0c9e115e,0x1138f375,0x0c70dfe8,0xf11a03c1,0xe52921d5,0xea33131c,0x22f801db,0xf62bf094,
0xf5ab1386,0x1c7aeef0,0xf544f6dd,0xf36017d1,0xffac137e,0x3ac8d11a,0x28e5b913,0x0e02f4ea,
0xfa9be057,0xd99c13d7,0xdd47267f,0x08be1059,0x03fff78e,0xd9b72c0f,0xf8f5299c,0x10d301d9,
0xf343fb1b,0xf41c0065,0xf6610c0f,0xf190f0fb,0x0fb6f91c,0xf8b0eb38,0xef2011cd,0xfa280a94,
0x12d605da,0xf6daff02,0xee511bf3,0xec001d98,0x0a130082,0xe987102e,0xf25d0ce1,0xd9901d8e,
0xfb55fd1e,0x1c1efc79,0x1f37cba3,0xdbb4041d,0xf7181c85,0x10a00cc1,0x1d15ecf2,0x0f67dedf,
0x1c0cf47d,0x3beaccbd,0x0e67e106,0x1c41dc81,0xf020fb1b,0x07c6067f,0xe48cfa12,0x0ba80ffa,
0xfcbcf9e5,0x085905ee,0x1470f6d7,0x06a4f79a,0x11b2f3b2,0x0a49f0e5,0x0b52f836,0xf854fdc4,
0x1a7df937,0x0513e4d1,0x0951ffdb,0x09eaf071,0x0c24ee82,0xef60fca5,0xfb52064f,0x07940312,
0x0abaf68b,0x04d3047a,0x0a5efd5b,0x10c8ef4e,0xfd34fa82,0xf9960097,0xe86d0b8f,0x024d0928,
0xf144088a,0x1b23f0e7,0xf47ff727,0x0a53177a,0x188eea8c,0xfb2af0bb,0xf7c2042b,0xda8828fc,
0xf4ae170c,0xec1606a9,0xf03903d8,0xe03d0ec6,0xe45d121d,0xffc61b88,0x0c1ef0cd,0x04c0fc5b,
0xf6fa111a,0x2794056f,0x0473eb59,0x08a403a4,0xf918fa91,0xf580fe50,0xeebbf53e,0xe76510a4,
0xf00d17a7,0xf75ef93d,0x14d20814,0x1a4be982,0x06c7f5f2,0xfba11141,0x09c001c2,0x169ef11c,
0xffb0e606,0xd5c31d61,0x11301080,0x1d73e2c5,0x2746cb44,0xfc4bf37d,0x02c40223,0x01b0ea39,
0x07cc1203,0xfc0dee04,0xfda712f9,0xf6cffa4a,0xc8132915,0x0e161fea,0xfc04fd0d,0x1096f763,
0xf133fae1,0xed412012,0xeb8b0232,0x01b81fb1,0x11f2e291,0x0db0eab6,0x17c9ed82,0xf416f533,
0xf62b0a69,0x0c18f685,0xf80102fa,0xfc6aff56,0xfb8d0710,0x0ba1f376,0x03f40ceb,0xddd60dd5,
0xee323976,0xfd770333,0xf7ba113e,0x0110f6fa,0xe47b0403,0xe9401579,0xdae20334,0xea6526e5,
0x1077f822,0x03a9f57f,0x2902efcc,0x486bdaef,0x2b22b779,0xf60a001f,0xfa6613e9,0xffd4ff60,
0x00b2f799,0xd86b1366,0xf13c1970,0xde1c0cf8,0xe3b92838,0xf77dff0c,0x089c0e68,0x1480e510,
0x08c7fc69,0x1c04ef93,0xf9b50489,0x244ff36a,0xff10f56d,0x02dcf871,0xe1040911,0x02d7036c,
0xeac6f2c8,0xd0cd22ce,0xfdc110a8,0xdbd01708,0x0312257a,0xeb9712c1,0x13e407f9,0xec3e0682,
0x01a31958,0x07b6ec30,0x1245ede3,0x06d1e5ff,0x08c7eacc,0x1e95f0bc,0x04e1e863,0xf17407b9,
0x0a210535,0x1197fce5,0x0511e818,0x0690f8c1,0xecb20e53,0xfa4710d3,0x09fe0310,0x0a5ef5b4,
0xfec70c55,0xff1dfce4,0x0ee9f462,0x20dfdf9b,0xff08ee6a,0xf7eaf76b,0x091ffcf2,0xf0d6019f,
0x0176fba3,0x07b10290,0x0eb2fabf,0xf211094b,0x01c20ea2,0x0f3dfb51,0x03a1f93e,0xfd3a0774,
0x053bf29e,0x029ef910,0xf7b6054b,0xf72208f2,0x0c36f0cf,0xcf6e0e71,0xee7b32e8,0xebb5075b,
0x0a9c04a3,0x0ff6eac6,0xeb91fdfc,0xec112307,0xff2807bc,0x04bef3d8,0x0530f309,0x066b0d0e,
0x06d2f8bb,0x0fc7068e,0xf4ba00a1,0xedc41ac4,0xf82f0867,0xf6d3ff01,0xf52300e0,0xf4960412,
0xf74aec72,0xf4e608be,0x14050f55,0x26f6d395,0x29d1e842,0x0844ee99,0x007300c6,0x0c810450,
0xeaa41274,0x0bf7f68f,0x3654dab8,0x2176c3e9,0xf399e8b0,0xfd9e14c9,0x1765e6b5,0x008202f2,
0xf98b060f,0xe77317ad,0x030c08de,0x05b9fc8b,0x0d98f1e9,0x2f09e4fe,0x0dfacecc,0x0646f902,
0x1ac2edf4,0x072ff2df,0xe0820562,0xf4e02581,0x177bf5c0,0x0185f77f,0x0508fc9e,0xfe090669,
0x0bfafe17,0xe761facc,0xd9ec2980,0x01b30575,0xfd860185,0xf329f6d9,0xd8520e0f,0xf9b4283e,
0x05c502bf,0x17b7ee7b,0x0155f951,0xfa870fda,0x1071ee13,0x01c4fe94,0xeaba061a,0xe4a91bb7,
0xf2500f59,0xea2e1600,0xea3c17ad,0xfcd20538,0x04d0f71a,0x0bad000d,0x10eaf424,0x1b1cd886,
0x056bf623,0xf2a8fd96,0x0c6b06d1,0x29f8e5f3,0x0424ec34,0x06f7fa9c,0x0a470bdd,0x1fe1e66f,
0xec48f32e,0xe24f1b5a,0x0b0efdf5,0x009fef28,0xf387f507,0xde4720ed,0xee641bce,0xf5c51b4f,
0x02280893,0xf4b211cc,0xf35b09fb,0x02a90db0,0xf16deb62,0xf5ac0ad1,0xe0a00a1b,0x11c5054a,
0xfb60f91f,0x012003df,0xf50414bc,0x168afab7,0xf79c162c,0x3a22da24,0x167ed32d,0xf480ea22,
0xea511207,0xf948f232,0x0c01f9c4,0xec240830,0x2a61fb6c,0x1d7ce976,0x1c17f0b3,0xfc7a0456,
0x0514f4f8,0xfdfc02a9,0xfa7cfa9c,0x0779f4e4,0x1ef5e28b,0x228ee428,0x0defd169,0x0bb1f4c3,
0xea9a15f6,0xf9960bbf,0x1bab0830,0x2cb5d7a5,0xfed9f247,0xee0d07d4,0xfcdb0c18,0x0b15e4af,
0x04dbf99a,0x0ee8e587,0xf814faa6,0x113f14bd,0x2fa6d803,0x351fe421,0x2240d873,0x142de4c4,
0x056ae703,0xefde09ae,0x01d1fdcf,0x1e23e169,0x058deafe,0xf229f819,0xfc7a1c38,0xfafff5bd,
0x10ce0bf6,0x179cea6e,0x119bf10c,0xdb000536,0xf2903803,0xfe75f7ee,0xffe4febe,0xfb9300da,
0xfb0cf9d6,0x1727f8fb,0xfcbfe656,0xebc0111c,0xe04315dc,0x0726154b,0xfbb1fb92,0xf2670836,
0xf56611c7,0x004d0cd9,0x0762f2bd,0xffff0179,0x1febf89b,0x1418df67,0x1017e921,0xff2cf256,
0x0f240967,0xf972f1b5,0x1346f4ff,0x06430055,0x00c80d8b,0xfee1edff,0x08dafcea,0x0e20e974,
0xfe9af8e4,0x14f5de97,0xeb43fb8a,0xfadd1ed8,0xf2cb06ee,0xfad6101b,0xf74511df,0x0a731198,
0x0270e7b7,0xf93b06b4,0x0c0cf709,0x0960ff46,0x0b06eedf,0xfae9099a,0x1249ed6c,0xe43c0925,
0x18cff93d,0x0a2cdfa4,0x031bf507,0xeafe0fe1,0x196400ea,0x027cec41,0xee31185a,0xf29e0f91,
0xed671801,0x2090e30f,0xe8dd0bf9,0x1c16ffe1,0x1495e72b,0x1de9ece7,0xf02cf7f3,0x0ea40d82,
0xf9ace28a,0xf9200224,0xdc8f0b8e,0xe5461bfb,0xfee60202,0x007e1b67,0x11f8e97d,0x0f8d05de,
0x1183efd4,0xe10214c8,0x2341ffc6,0x141bdb38,0x1583eabd,0xe23effb6,0x132001c9,0x0979d6ff,
0x0c0b0273,0xfaa5f4ca,0x0bbc0c08,0x1841e3e8,0xdc401ab9,0x07010a01,0xe0a913f9,0xf72111fa,
0xf604fe11,0x10df1068,0xfc80e0fd,0xf03710b3,0xecf7117d,0xf9ec0d01,0xff67ef6e,0xf2d415ae,
0x05ed0243,0xf93a1265,0xdc3c1545,0xdf3225c0,0x02681176,0xf17df059,0xe9f31778,0xf0391004,
0x0ee40e19,0x2226d2ba,0xfdf703bc,0xf3a3fbfb,0xdf481b0d,0x0715040e,0xeb990550,0x06910cc7,
0x0251fce9,0xf8e60ea8,0x071e08a7,0x2035f558,0xfca8d6d5,0xee08188f,0x04dff8bb,0xfd77ec89,
0xe4291bbf,0xe14e270c,0x0c560d2e,0x01affbb1,0xf92c09de,0xed090337,0x1439013d,0x126bdac8,
0xf342fcde,0xed761526,0x0ae30c97,0xfadb0198,0xe986070a,0xf1731766,0xfc8001a7,0x0988fdb7,
0xf7a5f7be,0x174714fd,0x0725ed14,0xf48a061e,0xf9b40c25,0x0ef0f566,0xe77ef746,0xf25dff34,
0xef4d1f29,0xf3c00269,0xd6df2899,0xf2b01886,0xfc731bef,0xf5b4013f,0xf56c06f6,0xfa7509ce,
0x1046f938,0xf53bfd1f,0x1f07ed3b,0xe3b10793,0x01fe1f69,0xee39045b,0x01f7fa4e,0xf8180649,
0xf2e00160,0x0c17f963,0xfe53fbae,0x1580eedd,0xf76ffcdf,0x036d1461,0x17bbe8b7,0x0c1dff4b,
0xf4ee00a9,0xf28b0a94,0x0306090d,0xf677f825,0xe7e91a60,0xfe4506e4,0xfd92ff2f,0xfb5405a5,
0xf7ff0fc3,0x1b60e1ee,0x17e3e82e,0xfc7cf90a,0x02f6ee84,0xfc640185,0x18380a4b,0xfaeaf417,
0x11e80176,0x13ebeb0b,0x045cf608,0x023403fb,0x0e15e986,0x003bf90b,0xf6370efa,0xfb6d056b,
0xfdfc0093,0x00ca0218,0xeeeef55f,0x04710c20,0x254ae791,0x1742e3ca,0x105af646,0x025700e7,
0x0f96f29d,0xe8220364,0xf8be1435,0xefe800cc,0xf02b045a,0xe3b61966,0x10e80a88,0x1454e52a,
0xf90201ec,0x025d0ad8,0x13a9f44c,0xf75efd42,0xf5f50dba,0x2969f66a,0xf94be554,0xf8b9fbde,
0xf0941954,0xee91084b,0xf6ce0350,0x06dbfb63,0xfdf8fda1,0x12cef907,0x0c54f513,0x1413fd06,
0x1e84eed5,0x03f2f3bb,0xe8c4fad8,0xe3fa2346,0x06d3fa4a,0xfae0f920,0x0774f6db,0xf95d11e5,
0x2edbea5a,0xf538e6fb,0xcca23a9b,0x02480ba8,0xf8210a88,0x0bd3fa71,0xfbc4e876,0x271af4d7,
0x1860d38e,0x0891f6a5,0x1173eec1,0x1359fb20,0x0a91e1a8,0xda6922b5,0x01430f82,0x024c0bc2,
0x062ef955,0xf938f47c,0x0b8a0855,0x069de75a,0xe105fc0f,0xe9821a49,0x0e8a0d97,0x0fe4e9e1,
0xf6cc0b1f,0x2aaa0020,0x2ab6da4d,0x02ace003,0xeeb806ae,0x1f9bec83,0x0749e980,0x0ce1edda,
0x0107ef12,0x09a5123f,0x00e9ee48,0xf9e6084a,0xf41609a6,0x0468038f,0x0779f4c5,0x03c30240,
0x11c7f7fc,0x15b1f2cd,0x140ee8cf,0xee1c04e0,0x00f208b8,0xe86ef900,0xf3241b58,0xfc40f942,
0xf74efef1,0xf76a0c25,0xf4601861,0x1d09f7d2,0x0f64ee17,0x1765f045,0xe91bf49d,0x11e80372,
0xf991ede5,0xe25d20a5,0xdb071185,0xf9532034,0xf1260f45,0xea1413c9,0x007610cd,0xf02f0121,
0xfd46157f,0xee43fb2f,0xfcfe0be0,0xf0aef9d6,0xd8bb21cc,0x05190a60,0xfeda0228,0xf3b60eab,
0xf18c1916,0x0296031c,0xe6cd085a,0xdac02144,0xf89c135d,0xeee406e5,0xefec134b,0x0ea8f698,
0x001afdeb,0x197cf669,0xf620f4ea,0x084c0dd1,0x073aee7c,0x0216053b,0x13bde6ab,0x0ecff4e5,
0x1c7ce50e,0xff01e623,0x099905eb,0x1b81e8ed,0x26e6e57d,0x0a66e510,0xfcdb1058,0x0d4bfe73,
0x03eaf5e6,0xe7df008e,0xee462400,0x0023e712,0xf08f04e9,0xf797138f,0x0b8cfb97,0x2102e7e2,
0x0703e819,0xfbda0411,0x02c705c5,0x0754fd86,0x0e680717,0x1483ef1d,0xf8bffb8d,0xf56609d3,
0xf26704fc,0x1708ee0a,0x028fe09e,0xd8231839,0xfe511430,0x0e10fa53,0xfe19031e,0xd5b6336f,
0x06c00b5b,0xff3ffcd5,0x0f89f057,0xeb69f780,0x0fe306f3,0x036bdd02,0xf4fb08f0,0x07bdfe56,
0xee5f07f9,0x00b10c37,0xe4e01997,0x12f60a4e,0x19abf5d4,0x00daec0e,0xf3df1420,0x00970a44,
0xfcbffea9,0xcd5b008b,0xecbb1cf6,0xfac3005c,0x00cff2b1,0xd8a5192f,0x07fe1864,0x1802febf,
0x13f0ec76,0xee7a0f78,0xf5330daa,0xe9a51a6d,0xfc84fa8d,0xed631316,0x068905be,0xfa37e86a,
0xfd790af5,0xfac3f568,0x0aaa060a,0x034ae88f,0xe6161fdf,0x069d0270,0xf5f6165f,0xfc5c06b1,
0xecc71c78,0x12800162,0xf4b8daeb,0xdd392270,0xf67ff9f5,0x078a0f73,0xf1790551,0xf24317aa,
0x0b33fb5c,0x1dfffe20,0x0c7ddf44,0xed8e094e,0x056ef5bd,0xf3b60d9d,0x2624f4f2,0x0185dd63,
0x07980cae,0xfe9ff826,0x1018ffe3,0x1789e404,0x1ea1e62b,0xf1c2f0e7,0xe44317d4,0x1029062d,
0x1464e63c,0xffdaf861,0xfa6d076c,0x2855f3cd,0xf4acef15,0x0abc0619,0x0447f386,0x08ec065a,
0x0324f400,0xed0c0e2b,0xf7ce058d,0xea2716d2,0x0f49eecc,0xe9980423,0x13e6f7e5,0xf4a10702,
0x076a0919,0xeb5005fe,0xe8b51b0c,0xf3590d75,0xdd831a85,0x0c3804e8,0xf146f56d,0x0230149a,
0xe39e1326,0x202bfb0f,0xf6e3f85e,0xfadd1a9d,0x0ae5f877,0x0224ea7d,0xee5e05ea,0xd97c147d,
0x0b81014f,0xf75aff7b,0x1879f167,0xfaaafb4a,0xef900778,0xd9c53385,0xf1e421b9,0xe69e16ad,
0xf6b80fe7,0x02df175d,0xff66eb5d,0x1349ebcc,0xf99df56d,0x0f10ef01,0x02c7fec2,0x1970e374,
0xefb405dd,0x115f01ce,0xe8a10641,0x0ab60823,0xf8110255,0xdaf72047,0xf9820ce7,0xf3e512e3,
0x0dbdef18,0x01af024f,0xfb77f8a6,0xdbee1f6f,0xf45e1341,0xffce0d90,0xe3d0fee6,0xfa1e115e,
0xfba7f6da,0x0db3f30e,0x0133f563,0xf58609b5,0x06aa1d96,0x1af0e320,0xd1b61fb5,0xed40184d,
0xfd021ebd,0xf233ee00,0xe9052427,0x2036f93a,0x00a5e2c7,0xfc98f3c4,0xf34b0c6b,0xe98f11f1,
0xfcca03d5,0x0e86fa56,0x10c4e90f,0x239af126,0x00cdf1c6,0x026a0b57,0x03fc008e,0x003ffd7a,
0xe520fc26,0xf351222f,0x044f047d,0x1beadf1c,0x0480fca1,0xe966f9b1,0x08770c24,0x045fefe7,
0xf3460913,0x0cb3fad1,0x07df08cf,0xf8dff5c5,0x027a1206,0xf87efff3,0xed4106d3,0x02f90c8e,
0xe15809c8,0xf02207f9,0xe75f13a6,0xf6760aee,0xff14fa42,0x05c113ec,0x08dff4ab,0x0ad5081b,
0x11170339,0x111ceacb,0xf07cf582,0xd6d91a25,0x08820e3c,0x0b7ce94f,0xffe8eca9,0xf22d041c,
0x149705a2,0xf99fecf9,0xef9d145d,0xdb7d1bbb,0xebcb3596,0xee3d0475,0x11001740,0x0a67dea9,
0xfa30063d,0x02acfcd8,0x13b4f46b,0x13bcda8b,0x10cef1bc,0x15f0e221,0xf9edf7d4,0xfa4c0781,
0xede1113f,0xf3fd14ec,0xfb2c0b94,0x1655ffff,0x12f5e44c,0xffc4ff30,0x297ae5c0,0x1499df8c,
0x0ffdeaca,0xea5af34f,0xf48c15b6,0xf5860532,0xff2c05d7,0x059af816,0x086b05b3,0x05abf878,
0x00a100f4,0xec2905cb,0xf1931f1a,0xd8462094,0xe9ee13ef,0xf0ef1211,0x05b80aa6,0xfda6f248,
0xfde6f816,0xec9307a3,0xf3930caf,0xfeab143e,0xf925fb2d,0x026a0ea2,0xe83501ea,0xf03d1e35,
0x07880951,0xf8b1fc69,0xf935fe15,0xf69b0569,0xed470e54,0xffdb014d,0x0bd6fb49,0xedfffd0f,
0x04bb1065,0xfa9903ff,0x078a0a9b,0xffbbfa23,0x062c0087,0x0312fe45,0x15e5eb96,0xff1df17b,
0x057ffc38,0x099b00e1,0x06a2e37e,0xf8440349,0x1136fd93,0x153aeb76,0xf6e0f0cb,0x048effd6,
0xf97ffe68,0x04600b29,0x07c1fd77,0x0f9ffac0,0x08a3037d,0xec09087e,0xfbaa082e,0x06b8f291,
0x0090f06a,0xe9d8135e,0x0d32fad8,0x04aefe71,0x1174f266,0x01010955,0x0c41e70f,0xfe63ff7b,
0x0a5ce757,0x189ff116,0xf7a7f606,0x12fbfffb,0x03b7f580,0xfc7b03d8,0xf39609dd,0x1d6dfffb,
0xf249fd6e,0x071a0be5,0x115bf047,0xf315031a,0x09f3051c,0xf416ece7,0xf99b0429,0xee24ff55,
0xff9f0195,0x05e0ef6e,0x008a0446,0x02701214,0xff4cfa8d,0x16d40ba7,0x13c4eab1,0x0accfcef,
0x0c44e948,0x0557fbc4,0x1c0edd32,0x03aaf3eb,0xffbdf090,0xfe3ef910,0x076d00e4,0xff69f84c,
0x01bd06b5,0xf81d04c9,0xdfb1299a,0x09da0dfd,0xf03d07e3,0xde7e0e7e,0x09200dde,0x00d7e6b7,
0xf03506f3,0x04210317,0xf39f04ac,0x090a02cc,0xf9dd04d2,0x03af0a13,0xf02606b9,0x0a530bff,
0x0707ee76,0x011bfbc4,0xe056081d,0xfd8c1583,0xf433f238,0xe8b321ef,0xee7904e4,0x00990f75,
0x14b000cb,0xff17f262,0x06430403,0x085ef6d1,0xf61308eb,0x1c0ce627,0xf14800c6,0x06fa0518,
0x142cfac5,0x11cce708,0x038efe59,0x188be7a2,0xf4d3f90c,0xff78f7d9,0xf11907eb,0xf3421473,
0xf81efd18,0xe7782654,0x054b06c9,0xf138ffc8,0xfae1122a,0xf4350aa6,0x04b50649,0x00fd0099,
0xe91e0265,0xf4881b7e,0x0e630091,0x0e82dae2,0xfc99f53f,0xfea70605,0xfb02fc2e,0xf9e30812,
0xf1a21a2f,0x0826fcc5,0x04d0124d,0x09dce3b9,0xfed7081d,0xfbdbf604,0xf35b18d4,0x1994e6b8,
0x00bff419,0x047f051d,0x0766f7cf,0xef9505a3,0xfc0fff26,0xfd020e06,0xf5f9007b,0xdf631ea8,
0xfb401725,0x1134fd83,0xe045f105,0xe7c82ca9,0x0b37fe79,0x0b36edd7,0x0914fcc5,0x005cfd14,
0x0e2301c0,0xf8aeeddb,0xfd3e1623,0xf6afed01,0x139a0ed8,0x080add7a,0x0d6907d0,0x0cf9f285,
0x025104b6,0x0770f9a6,0x04fff719,0x0ad5f87e,0xff66f2ad,0x0364038e,0xf9e4ecc2,0x1180056a,
0xf1c7f08f,0xfb9821b2,0x0f51ef2b,0x1055f47a,0x1e47eb30,0x0cabebac,0x239eef78,0xea49ecae,
0xfa8a261a,0xe219fea5,0x08931c67,0xf1dee8e7,0xea681c58,0xe6ed07b6,0x0d050be5,0xf5effcdb,
0x0da6041d,0x1106f196,0xe882021b,0xfd781b8f,0xfac7f665,0x15cd0b25,0xf306e5f6,0xf69a1bfa,
0x0b9bf4e0,0x1418f014,0xf611fd89,0xf60a0f23,0xf8400c6d,0x0258f6da,0xe7220960,0xe57e1c11,
0x08c4002b,0xed04f9cd,0x10061029,0xf7def5ec,0x11df08b5,0x0d72f3ea,0x1350fdd5,0x129cecef,
0x0890f3d6,0x040df3ea,0xf626f9da,0xf65200dd,0xe46b052c,0xf9102033,0xf84404bf,0x10b5fc18,
0xf7a1fbb1,0x003d0e36,0x05c0ef8f,0x08d5fd43,0x1534f1a7,0x0456f819,0xf73e070e,0x153a0411,
0x01bde398,0xefe01a86,0x1999e27e,0xeaf10a0a,0x0aeffffd,0xe45b0313,0xfa8a17a6,0xe62010d6,
0xf6e10ca7,0xfbd304f4,0xf27a0fec,0xf4b20346,0xf56414a7,0xf88f02a5,0xeca9191e,0x070507e8,
0x02e3f879,0x0c60ec1a,0xe8cf01c4,0xe78012e9,0xf5a311fc,0x06900f1d,0x09ffeaf1,0xf85f1425,
0x027503dc,0x01c6fde0,0x1019f6d7,0x07e4fa6d,0x0cdde91c,0xfb7afef4,0x0a20f575,0x126ae5bd,
0xef8ffe6c,0xeeaa0999,0xfb2f0ce9,0xf8630942,0xefd21926,0x098d03e4,0xf3de13aa,0x02090532,
0xf9b00b40,0x1a03fcf0,0xfab0e105,0xfd6a0a87,0x0792e7c1,0x0be8ef31,0x0d6ce696,0xef590243,
0x06cf0141,0xfb17ff9f,0xf60b1339,0x1cc705af,0x0a4aedb7,0xfa63065a,0x10fd04f7,0xf1d8fb07,
0xf15f11af,0xf846ffcc,0xefc40e68,0xf081fe58,0xedb60fc8,0xf8cc0b2f,0xf70907be,0x0df9f6de,
0xfb3cf248,0xf3a112bf,0xfbf707d3,0xfd8411c1,0xf7ee020b,0xf56c19f3,0xf89107f3,0xfdfd02c4,
0xfcfa05ab,0x0647f939,0xfe5ef924,0x033ff577,0xd5ba0f6c,0x00d71395,0xfe47fa01,0xfa3e0061,
0xfc40086f,0xeaae1dd1,0x0a811422,0xf8fdf596,0xfe831434,0x286edf33,0x0451e0ab,0xfe57f742,
0xf64ef992,0x12c4fb29,0xf31bfb13,0xf2121111,0x075f0814,0x0b2afac7,0xe6dd0a76,0x092216e7,
0x00f0fc26,0x01a3fae0,0xfb680651,0xe7490b13,0xfc810f38,0xdc78ff3c,0xec871a39,0xf5bef78c,
0x190bfc36,0x0814e58b,0x1f9ffc65,0x0284009c,0xff200261,0xd816255a,0xed2f234f,0xf09d0e86,
0x118ef5fd,0x030ef138,0xfa2cf437,0x25caecd1,0xef6bf20c,0x0793fda6,0xfc5e0685,0x1df9f1b0,
0xebc1f3f7,0xfb88152d,0xfa490636,0xfe51058d,0x026b0c57,0xdbe603ee,0x2c370c9e,0xf655dcea,
0xfa2d0fd6,0xf7cefc99,0x10c4fa53,0xe689fce8,0xfed4220c,0xfd20fd6b,0x005a019a,0x04f90397,
0x0316f328,0x10b2f5a3,0xf03df422,0x069c082e,0x03f6f133,0x1f3bf058,0x1307e049,0xfb6602ff,
0xfbcf1871,0xe7440424,0xff871713,0xf35005ee,0x05f30f5d,0xff1eed9b,0x05f6fbd5,0xf2b5fefe,
0xf481038f,0xf86d0a55,0xfbb9f243,0xfe130e45,0x011afa1b,0xf5d71411,0xfb75111f,0xf3d51111,
0xe7ad124a,0x1b72fc7a,0xf7b8eedb,0x0cf3f951,0xecbf002b,0xf1fc13b3,0xfa0c0903,0xf4310e35,
0x0d0df29e,0xfbb6f703,0x2740fa5a,0xf65de269,0xfaa408fd,0x0a5610ec,0x22d5e1de,0xfc34fda6,
0x16d7eeb1,0xfe26e8a5,0xed1a13fe,0xe37a17e5,0xf649093f,0x12df02f2,0xf508fbb4,0x04350c4e,
0x0a49f7c5,0xf596f638,0xef130f39,0x0a63046f,0x1d0ce586,0x0e61e41d,0x0a29faa7,0x0ffaf47b,
0xf40efeef,0xf61013a3,0x00c3fce2,0x0d10fe22,0xe736fc9e,0xff4c0e51,0x0c1df292,0x185af49b,
0xe76af513,0xff9e1c7d,0x1565f0a9,0xf22af823,0x016a1c6f,0xff56f5e2,0xff8c0337,0xebc703f5,
0xf5541011,0x017902e8,0x151ae775,0x0139eddc,0xfe01053b,0xe1f82199,0xf0f5095a,0xe8622003,
0xe5e51879,0xfcb81937,0x004ef8d8,0x02defa1d,0xf13300a6,0x0331ff94,0xe38a0570,0xe3a81d0f,
0x01c31ed8,0x1e09e0d1,0xf708ff05,0x02190b4e,0x19c8f323,0x055df9af,0xf7200529,0xec940f7b,
0x285fec35,0xf071eb99,0x0d81fafe,0xfb81f4ff,0x0086f757,0xfff0fbac,0xf75709ec,0x2cfbec52,
0x09bce92d,0x046b0a8e,0xfa9f07c2,0x205bf376,0xfaf80016,0x092df755,0x05ea0373,0x0c5ddd14,
0xd42609e7,0xfc6609a4,0xfeb9fdaf,0xf35c06bf,0x056f009e,0xfe690f9a,0x26c0f115,0xfd8702ff,
0x0be8f8cb,0xfe5803d2,0x11bfebf4,0xff56f926,0x0110e9b6,0xf4060cfe,0x02e0ff19,0x0975f018,
0xe8460ab1,0x098efa5f,0xf89b0d50,0x17f0f785,0xe8c115fd,0x2664f641,0xf91cf2ff,0x02e30151,
0xfff007e6,0x0532f15d,0xf4a4ffd4,0xe7e9122f,0x1357ffa8,0xef6ff7cc,0x0daaf3b4,0xf87b07d6,
0x26aedebb,0xeb5ffc82,0x00381115,0x020c0abe,0x099f0284,0xfddd02ae,0xfc0afe32,0x0dbefd38,
0xe87509c2,0xf9f6021b,0xe38e10fa,0xfbee00e9,0xe95b1307,0xf8a11056,0xfa200a49,0x07abf04f,
0x0c3c0643,0x1089f00c,0x1231f37a,0xdaa71136,0xea1b1c6a,0xe66e159b,0xf0410750,0xf4cafdcb,
0x03270590,0xfc8b0df8,0xf82b027f,0x05c80c2e,0xeded0c7b,0xf8e40cfc,0x01680e1f,0xfcaef1c5,
0xfd4e0d22,0x0799f5d2,0x0734f9fc,0x1b72de76,0xed2607e7,0xfbc4f9f5,0x0a2ff7ba,0xe5c30105,
0xf1511760,0xfa121861,0x084406b8,0xf9ae0519,0x189dfd4b,0x15a2f3d0,0x02d9edaf,0x11ee03d0,
0xfd80e379,0xec810abe,0xf50301ec,0xf18e0996,0x0e6ff20c,0x01e9f488,0x058dfedd,0x0d65f20f,
0xfd4b0ef1,0xec4a175d,0x1a3d094d,0xf074fd1e,0xeab016da,0x01adf731,0xf4df04b1,0xe27d0992,
0xf62c15b1,0x1aaaf2fd,0xf889e9b9,0x101a0f6b,0x0ee8e8ae,0x121ceda4,0xfd54f77e,0xeea71491,
0xf6870ca9,0xee2111ea,0xf3fe1bda,0x0d4def01,0x1726f57c,0xed64efc4,0x02f50c13,0xfee10534,
0xfaa50421,0xe4a00dfc,0xf1271a46,0xf78508d1,0x0128ff8e,0xf1e400a0,0xeefb0773,0x0d4307b0,
0xe47d02e2,0x07dd16dd,0x110ff549,0x2041e969,0xe463f480,0xeb5b1f90,0xe84a15bd,0x06a403f4,
0x28f8ea7f,0x1044e424,0x2088f0ca,0x1c1eded9,0x0cdfe693,0xf4520713,0x1664f6f7,0x003deea2,
0x1421e63c,0xeaaa1275,0xf2db08f0,0xe141175f,0xe92c1a5d,0x09130e2b,0x115ef081,0x0df3ee18,
0xf801fcb3,0x1ce8f7ee,0xded10118,0xdbcf1cf8,0x0fb31e56,0x0b88de8d,0xf68f0eac,0xf5ff0243,
0x02371155,0x08e5f2d8,0xf51f023e,0xeec103dc,0xf38afda1,0xd9f72965,0xf84906ca,0xfd491c06,
0x0534fb43,0xf1d0165c,0x085dfd14,0x05bcf888,0xf0c7f9cb,0x02bcfdf3,0xfe53f3fc,0xffaff408,
0xf0961acd,0xfeb9fd50,0xf5812af4,0x1748f352,0x0e63003a,0x0556f0c5,0xf3720eed,0x01040039,
0x0391f2e3,0xf146f9ce,0x03e1e836,0xe48d1099,0xfd9efdef,0xeece19e2,0xfae808e3,0x03ae1a8c,
0x0ce4f49b,0x130d005f,0x0c85eb02,0x1281f544,0xe05cfc7b,0xe2ae195c,0xf4921f1a,0x095ff599,
0x1a73fafb,0x070bd709,0xec161457,0xf2ce04d3,0x082c12b7,0x159ee1c4,0x05a6f1eb,0xfbc509d6,
0x0313f90d,0x06af0440,0xfe1ff0f4,0x045b0eb6,0x13c1e085,0xf8e3139d,0xfe7df3c8,0xfb2e11e3,
0xe05a0bf6,0xff31130f,0x0e5cf21d,0x18d8df72,0x0589f9e3,0xfdc2fab8,0x04ce1217,0x0fb9df11,
0x06d105eb,0xf7b4f145,0x0e93091f,0x0f73e021,0x075bf5e2,0xfbfc0160,0x1389059e,0x0368f853,
0x1183faa9,0xfbfdfbf8,0xf733fe79,0x098afcee,0xf005f419,0x0ee4091c,0xe1f8f368,0x1285119a,
0xfe01e606,0x0a9f0d58,0xff14f9a3,0x02210c7b,0x16d3f37e,0xfbbcfc34,0x058d0eb3,0x01f5f2e4,
0x069405a4,0xfa16e6fe,0xeb4008f5,0xe5621639,0x0a6405d3,0x171eeb12,0x19dcf18a,0x0c2be4c2,
0xfe6a043b,0x0936f6b2,0xfd8df51f,0xfe9910f1,0xd4ea1176,0x0d3919c1,0x08bef684,0x104d043a,
0x0f6be558,0xf4ed03c4,0xfb56f51d,0xf215fc05,0xe9070ee4,0xd84d199f,0x149711d0,0xefdd02a7,
0xfb370fd1,0xf2b00fd2,0x10241132,0x09a5dfdc,0x065c0d38,0x1c61dff6,0x07bee6c8,0x09f8f001,
0xef1c0433,0x1941ef65,0xd6fc0bc4,0xf2e21b84,0xf2c00fd5,0xf54517d6,0xdb1e17e6,0x05e4124f,
0x100ef491,0xf441020f,0x1151f1e4,0xed550566,0x067a03ce,0xfb69021e,0xfc57065a,0xfc5e0078,
0x14ccf95d,0x0bccf150,0x06f1ee38,0x0ff3f1b9,0xf5620154,0x0e93efa6,0xf2b30c2a,0x00b1fcd0,
0xed090c9b,0x098e0931,0xf6470258,0x036305ca,0x1968000c,0x097fe6e8,0x0e84f7a8,0xecce03a3,
0xf6120a67,0xfde20a35,0x03c7f444,0x0711f47a,0xfa6eed88,0xfce524b1,0x049be598,0xf39f1e67,
0xe55c09b0,0xfc8008d1,0x06b0fdb7,0xfb61fcba,0xebc31671,0x0268f9c0,0xefb01e7b,0x1397e80a,
0x208e0a04,0x0614cd9c,0x03c91736,0xf32af3b4,0xfdc20eba,0xf7c9f939,0xf13016b5,0xedcf1034,
0x1312ed9b,0xfb80fd5b,0xf4a5ebde,0xfd622595,0xfedff03c,0xffb61644,0xfeddfc13,0x01061308,
0xfa53fa64,0x11490942,0xea93fc36,0xec1a083b,0x00fc17c1,0xeec5e8da,0xf25d1bb7,0xe518ff44,
0xfd272356,0xfaf2e88e,0xf4e923ee,0xe9e80522,0x07d022d7,0xfcaa0540,0xf87afa50,0xfd0c0def,
0xf2adf798,0x04d209d3,0x166fe3b0,0x186aebef,0x073dd9f7,0xf6a217ac,0x022af993,0x151afaf5,
0xf0d404c7,0xebbb0d83,0xfcbc1c97,0x3155e216,0x17a9e14d,0xf26cf229,0xee9622d7,0xe82d0162,
0x005d178c,0xed10fe02,0x0688ff38,0xfef5f9ca,0x1dd2ee37,0x0d96e29f,0x167df107,0x075cfcb0,
0x13b5f055,0xef1e0896,0x089e0097,0x17f3f7cb,0x0413f5a3,0xf76402a2,0xead90e29,0xfd7e11b3,
0xea4d0566,0xffbd08e4,0xfaf20208,0xfe1efa2e,0x0539f571,0x1180e53e,0x20e5e801,0x00fbf75c,
0x06980692,0x0ef1f9e8,0x03e1f9f0,0xf837147e,0x01fc0111,0xfb8f0f3e,0x0aa8f4bf,0xefa6f79c,
0x01a30045,0xf661f5c0,0xf6490edd,0x0f17f896,0xf501f0a7,0x047b07c2,0xef991058,0x056209a7,
0xf0cc0e88,0xfc921769,0x114cf2e3,0x1420f422,0x0d9ce31e,0xfd2ffdd4,0xfd59f56e,0xf6f70d72,
0x0411edad,0xea351175,0xf67d1052,0xef150e1a,0xf6480bd3,0xe0fb160d,0xf47d1926,0xfdd9058f,
0xf826087a,0x0c13fcd7,0x1792f3f7,0x074cf154,0xff290422,0xfce007df,0x05b4f4b1,0x00e9fbae,
0x03a1f994,0x0848f0ae,0x0cc2f146,0xe8990d0e,0xf9090d98,0x17e6f9e2,0xf99df28d,0x033305d3,
0xf57b07da,0x0bde0055,0xf701f145,0xefef1772,0xfd950d80,0x1c0befbb,0x1f44f0ac,0x17f6dcc0,
0x0f69edd4,0xff7bf751,0x00e0f61c,0xf0d80611,0xedbc100f,0xea79106e,0xee2e0e44,0xe725270e,
0x0c8f051a,0x1131010e,0xe8c9f3df,0x1a6602fb,0x1707e2c8,0x16a3e546,0x045df08a,0x116cf197,
0xf0cb0589,0x00e9faa6,0xe3f6232a,0x0ffef62e,0x0992fd54,0x0defec97,0x0a49f0e7,0xf6aefbfb,
0x0d6f04bb,0xee2608e8,0x180cf98e,0xfbbfff88,0x1ae7f359,0x01fff770,0xfec3f516,0x03b8fe14,
0xfb0df206,0x1934ffd0,0xf76ee7ce,0x11330fea,0xdc33031e,0x02d319a5,0xe69210e3,0x138401ea,
0xfa11f40d,0xf9a8ff85,0xe0a41879,0xf37f0942,0x09591065,0xe938f05d,0x11dc14e4,0xfd79f125,
0x12b105c7,0x051beba9,0x09d1068f,0xecf0fdb2,0xf1e01240,0x007c0c7e,0xe4d1f23e,0x05481d39,
0xeceaf80d,0x08e601f9,0xfbc3fd14,0x083e0810,0xfe07ffcc,0x23def4df,0x12fbe304,0x149de8a3,
0xf7fd0c3b,0xeaa3f37e,0xfd2e1b31,0xf16c0169,0x00ed09bf,0x0adef384,0x0bf7fb66,0xd8710b08,
0x272605e3,0xf154f2ad,0xf8cb03bc,0xeec012cf,0xdb931579,0xe76b182a,0xd52a2892,0x0770185b,
0xe8b9fb57,0x0b8915c9,0xe166070a,0x3493f653,0x327fcc9d,0x033fda52,0xf6fe0f9a,0xfc3cfe22,
0xff73fcb3,0xdd8afec8,0xf1e4301a,0xebb1f951,0x23eb0f57,0xeca9fb04,0x045d1659,0x08abf6b0,
0xfc6af9ed,0xf7140875,0x183fefef,0x0773e909,0xe535f962,0xe6782dd9,0x0d9500fc,0x1696e233,
0x0ba0011b,0xfd99f5cb,0x100df949,0x1d85e8ef,0xf40a0279,0x1016ff1e,0x0c65f747,0xed47fbdd,
0xf94c150b,0x0056ffab,0x0079ebef,0xeeed0b0e,0xfcea01d7,0x09b3f384,0x3237dd51,0xfc6aece6,
0x02060cd5,0xf8301373,0xf8620e83,0xea0f0e8b,0xfdfe21d7,0xfd39f057,0xe1a512fc,0xf1d70e0e,
0xf4ac06c3,0x1722eb43,0x0990ec8a,0x1347f6e1,0x0dfeddc0,0xe93d140c,0xe2710ef8,0xf94336cc,
0x1f78eb7b,0xf7ae01b9,0x0f96f8a6,0xf31b0434,0xfd0df23c,0xf7300a8e,0xefd00486,0xfd78fa81,
0xfb970ef2,0x01240058,0x1a05fc9f,0xfab3f8f4,0x02700f05,0xf807fbdc,0x165401db,0xf37adb12,
0x06d70d4f,0xf94bfbf8,0x0624f74b,0x0dcefac8,0xf8e4ff43,0x1e05fc4c,0xfeceec9c,0xf6bf1e6a,
0xe22501cf,0xfe002e90,0xe489f032,0xf173211f,0xfa94fc9e,0xf87ffc92,0x0775f5af,0xf3860048,
0x03e90d95,0xf1db0539,0xf5a22a57,0x00bbf640,0x1eadfd17,0xfa2ced78,0xfd24f7ad,0x023e020b,
0x0b38f2ee,0xeb6012a3,0x09bffe39,0xf8861145,0x1a47ed5f,0xf7940295,0xe3a0fb15,0x01db0bf7,
0xcfb70e51,0x1061198c,0xe590fb6c,0x10110af3,0xe28e07dc,0x0dd51196,0x057cffaf,0x00f6f7a1,
0xf9340e63,0xf4e402d1,0x04d202c0,0xe50706d9,0x091e10da,0xf84af6de,0x1055f64b,0xe1af0156,
0x14befe8b,0x0031fa30,0xfef6f7fd,0x07d90819,0xfbe0fb98,0x233702da,0x054fe480,0x1c4e04b6,
0xf9e8e92b,0x1362f46e,0xdc5f01f1,0x0a570b4d,0x0a9feee4,0x00d5eec3,0xebf01d62,0x2211f8c3,
0x1c2ddcf9,0xe80df910,0xe4d02658,0xff1e11a9,0x19ade838,0xf2bd026e,0xfd890475,0x005a08d9,
0x0010f7ff,0xf13c0bea,0x18e6e7b1,0x2816db9d,0xe556fb56,0x05021795,0xef280915,0x0dd400b6,
0xd4e61c70,0x00221021,0xd9881541,0x00ac0948,0xe620104d,0x0f99fbb3,0x163eeea9,0xf3a0fe9a,
0xf2a21370,0xee2f0a36,0xfb2a0765,0xe790ffea,0xfbff1a8a,0xfc140d38,0x1cedf58f,0x02f0ef28,
0xf9870cc2,0x1586f130,0xf4aaf6ae,0xfb5b0649,0x0a82f413,0x1ab4e957,0xdf97ffc6,0xfd331fc9,
0x13a6fe5e,0xf5f2fd0e,0xe5861c58,0xf0dc1297,0xfe280133,0xffd5f6d1,0xe2e9147e,0x15dcf16b,
0x131ae522,0xf64efa16,0xeeb717a6,0xf8810ab3,0xf32e1249,0xfc780bc9,0x03fb13ff,0xff030076,
0x1071ff3d,0xed930198,0x0a9a04c1,0x127cd773,0x16daeb9f,0xef3ce32f,0x0cb909df,0xeb2cf907,
0xe3ad212b,0x0b560b00,0x1116fb8a,0x195ef071,0x0d33f107,0x1c96eeb4,0x023af285,0x1074023a,
0xfd3df20b,0x01a20481,0x035bfe14,0xf4acf47d,0xeaac07ae,0xea2e0be7,0xfeba0902,0x022df61e,
0x1d3bffcb,0x062cecca,0x23fff8db,0xf491fb3c,0x0723118e,0xfa16f6c6,0x090101fd,0xf47df45f,
0x07f60557,0x0053f1cb,0xe3acffc6,0x055a0e26,0x0175f787,0x1594f35a,0x2179efc7,0x0c84ee25,
0xfb30017c,0x0a4b0460,0xf6bdfca6,0xf43607d6,0x0dd90c0f,0xf273f14b,0x0954007b,0xedfbf676,
0xf4fb0dcc,0xf033117d,0x0f87013c,0xdfcb06c6,0x103413cc,0xfd600110,0xee78f82b,0xed422612,
0xf81908bd,0x161ff64f,0x0c14df4d,0xf6990dde,0xfbfbfaa7,0x138a0469,0xfac7ed04,0x0537f7cb,
0x09cdfb6f,0x033df4d9,0xf50b11c6,0x178400f5,0x008afaba,0xf5360971,0x03561a95,0x0638e202,
0x13dae73a,0xea81f449,0x0334f357,0x10a2f770,0x19dce72b,0xf8670b6b,0x19d8ff4e,0xeb901448,
0xfc71f618,0xeaea22a7,0x041d0103,0xfc0103d0,0x0793fcc1,0x1272ebd2,0x0b08e6ba,0x0d62f561,
0x0143ea03,0x1c1ce42d,0x05b404cf,0x0f19ec5b,0x08620221,0x1e57fb5a,0x2257dc47,0xea6bffd7,
0xf4ed0b25,0x06f7fb3a,0x0535e29d,0xe1a21b97,0x085efecf,0x1c6c0190,0x060fde7f,0xe4551d22,
0xe4a31fb6,0xf7980d3d,0xf138014b,0x02900a8f,0x0721f1ca,0x0025ee8d,0xd0b532b9,0xfa091240,
0xde751cce,0xe69c1ad9,0xd60f2635,0xeeb01e75,0x13b9fe73,0xf73ff4a6,0xe8a50de0,0xf925150f,
0x14fce6c4,0xec540bed,0xef3809fc,0x0a70047d,0x04b2fac0,0x10feff67,0x1de3d72e,0x241fe9c2,
0x176edd5a,0x05d9f0e9,0xfb1207b0,0x23eceb5a,0x0588ecb1,0x011d02c8,0xf01a0728,0x15c3f9d5,
0x1344eb48,0x13ffe619,0xfbb9f88c,0xeda11528,0xdf5d12ac,0xfb2c1e1b,0xf9f0fa29,0x08d4f52e,
0xf374ff3c,0xed38111c,0xfa820904,0xf4b30a47,0x07330c06,0x0155f4ca,0xe791205d,0x0222ff98,
0xf85e07fb,0x009306e6,0xfdecf5fc,0xffb2107a,0xf4e6f67e,0x06ad0584,0x2012e706,0xfefff6c0,
0x0d46ec97,0x07c6ffea,0xf59dff59,0x0592fd1e,0xecb609e7,0xf41a0f50,0xf49311e4,0x0357f844,
0xf56b0cfd,0x1148fb15,0xf705086d,0xf525ff91,0xe3cb1783,0xe77c1206,0xff15ff03,0x1904f8ec,
0x12f3f4f4,0x18a3eaba,0x0254fdcd,0xfc730a7b,0x21a7ee60,0x09b2df3e,0xdd5c0835,0x0239071d,
0x0f59ebfd,0xfd0bf04b,0x04c60895,0xfc740c2e,0xf40f1293,0x1064f855,0x052aff78,0xf98afdfb,
0x0981049a,0xe3e309a7,0xf5f010ba,0xfcf2f844,0xe91905b6,0xdcd50d4a,0x0d371390,0xfeccf3d1,
0x024309d4,0xfb380d0d,0x14f80114,0x0b83fd17,0xf9150637,0xdd290f2f,0xf1fd0917,0xec4e051f,
0xe6c60a70,0x09680ac8,0x08b8f713,0x0ac3ec65,0xfcd20475,0x0f3ffcb3,0x02f5fa93,0x1bdaef9c,
0xf980fafb,0x0c3d0746,0x1c79e4df,0xfe9eeecc,0x04c4148b,0x0c54eaa6,0x0c4ef4d9,0xc69909d5,
0x05ae29aa,0x000de663,0x0143044e,0xf0c4f968,0xe78217b6,0xfbf70bcf,0xfd0b0521,0xff2118ac,
0x0665f243,0x2754fef2,0xfbe5e564,0xea3c1ba2,0xfa0cff4a,0xea190c1d,0x078600da,0x07c3ed9b,
0xebc4fa20,0x08f507fa,0x08f001c9,0xedfa09e9,0x26a0fa12,0x0dece842,0x07a6f93f,0xf66d07a4,
0x073effc2,0x0b32eac2,0x1941e197,0x038df755,0x02baf690,0x1afbf80b,0xee8efae8,0x088b0a57,
0x0a4bfe8c,0xf5ac001c,0xedfd1689,0xf4ca0a79,0xd4c70c1d,0xec281b4c,0x01f103cc,0xf22bf975,
0x07c30ec6,0x01f9009e,0xfb48f799,0xf7651ba9,0x151c042a,0xfc12fda5,0x063bf6da,0xf18e1541,
0x0251f127,0xf65b05c6,0x12fee88b,0x1b81dc4d,0xfcc0f2dd,0xef2d0124,0x03410a4e,0x18cbff21,
0x037bfb9d,0x1baef501,0x1547f458,0xfafaf2b3,0xf05d1119,0x089e0362,0xf806f0c1,0xf6d30ea9,
0xf2c30648,0x0810fa77,0x01b6f82b,0xf46806aa,0xce031476,0x0d1f24eb,0xefefef3e,0xe85b1deb,
0xf9c71e1b,0x0742fe16,0x01ebf58a,0xf4da0309,0x2007f2b7,0x10f9d900,0x13f60142,0x07c9e6a4,
0x05f803d9,0xfb3f0643,0xf9d2fdc6,0x0893071a,0x1325e95c,0x0d46f387,0x0647f2ae,0x136af457,
0xf97bedc0,0x099f0e82,0x027aed45,0x0b26f71e,0xfe86fed9,0x0404faaa,0xf6a9039c,0x1b03fc9f,
0xfe6be99b,0xde4715e2,0x04b11a06,0x1432e8da,0xfa05fa7b,0xf3960e44,0x1424fd46,0x0619eecd,
0xf5df0aad,0xeea80d31,0x01e00bc0,0xfd74f4fe,0xf92dfe35,0xf98e090c,0x155af5ec,0x1321dc15,
0x00310643,0x158af31a,0xf8a6f73c,0xfe6e1104,0xf53210b6,0x1a75ec67,0xf632fd69,0x06c8f667,
0xf82f00c8,0x03200136,0xfcb4e9f6,0xfd3c0f26,0xfa2c0cca,0x0309027f,0xf96c0e36,0xfb67113d,
0xe9f6faa0,0xd2fc28bc,0xfe5a0ccc,0xfb670205,0x046bf8ac,0x01bcf566,0x2200f2b2,0x0660ee79,
0xf5fd0914,0xff4f05b0,0xf55b12f7,0x17e7e5e5,0xf25006d5,0x059b0254,0x1cc6ed1a,0x2b6dd29f,
0xf513f1a9,0x091efce1,0x0caff721,0x1ba2f150,0x118ce32f,0xdfac1276,0xf3a01d1b,0xe8d1177c,
0xfb2006ee,0xec5f07dd,0x0646f974,0xf3ac01b0,0xfd9d05f2,0xff070b69,0x05520226,0xfbe5f931,
0x0a5309c1,0x0289f2ad,0xfcb009a3,0xe9c0f691,0x02a9222d,0x169ed8e2,0xfec7ff46,0x0770f3ee,
0x1d9feee6,0x232fdea7,0x08b9e54d,0x10d2f9cc,0xf4aafb00,0xe95528f9,0x0daffbf3,0x0bc905bc,
0xf26cf104,0x11170c06,0x1440e11c,0x0698e546,0xf978f757,0xf0b10904,0x06ff11fb,0xf5a0f1d1,
0xf8e41708,0xe470010c,0x079b1714,0xeaf6f2ab,0x15731584,0xf229fa7f,0xfb5615c7,0xede90bd5,
0x03a91131,0xf97b04be,0x040df95c,0x0985f191,0xe6bef521,0xf7090d68,0xe3cdfc49,0x10d21ec5,
0x0bffeacf,0x10ae07d3,0xfba4ff33,0x2438fb23,0x0fe3ddd5,0xe3690700,0xef460aee,0xe6ba1275,
0x1ce1f249,0xfbf6e0db,0xf4ad1593,0xe1a91dec,0x0cc41153,0xf5250282,0xf0730e9f,0x06e60e4a,
0xe75404d3,0xfba60fe2,0x09e0f282,0x0709f2b0,0xfb9eeeae,0xeafd184c,0xf6641ca6,0x0d1bf6ed,
0xf26305c2,0xee1b0b32,0x1c9b066f,0x0bb7e5a2,0x039cf14d,0x193beebd,0x2527e0ca,0x0b0adeef,
0x006cfa1b,0xedb71f2e,0x0063fd62,0xfa910804,0xf3580377,0xfdf3199b,0x163af3e3,0x0c74e975,
0x1299ed9d,0x190eec32,0xec83eb9e,0xfd850920,0xeb800c82,0xe4f91bf6,0xea8216ce,0xefb91e2b,
0xefd8114d,0xfbd7167d,0xf741ff9d,0xe7bd0a4e,0x084f0eac,0xfd0bf537,0xe12209ac,0x02aa1282,
0xfe34fd19,0x093ff028,0xdb0019ab,0xf6872526,0x0659fa94,0x046303e9,0xfb85f63e,0x04f60bcb,
0x133bf098,0xf1acf852,0x0fc6ff94,0xfa48f5d9,0xdf120461,0xdb2b280f,0x012a1bf8,0x0309f718,
0x083f00d3,0x08eef60a,0x055403a1,0x268bee6a,0xf045ea1f,0xf39c1238,0x011a19b3,0x1050dc27,
0xef87fab3,0x028c0a47,0x06acf2bc,0x07bef333,0x0a9ef95e,0xf70c02e2,0xfdf3170c,0x0f7cfde6,
0xff4ff838,0xf7640586,0xe50d0bdc,0x098c03a5,0x0501f4df,0x04c4fe77,0xeb3ffb68,0xfbad192a,
0xf910002b,0xf3d90d82,0xfaed118e,0x016f017b,0xfaf5fe45,0x151bf681,0x0a54ec47,0x00cbf2ad,
0x0add125a,0x12fedc46,0xf798fe8f,0xfd15078f,0xee6a102b,0xf5d00b8f,0xf8770ca7,0x0062edc1,
0x073c0145,0x0489fce9,0x2b08e36b,0x1226ee1d,0x068e06b5,0xfdbbf60a,0xf3b20a02,0x032b08c1,
0xea3aefd3,0xf5801dd2,0xeb29ee4c,0xfb891635,0xfb4907d0,0x125904e1,0x214fe015,0xf28b02d0,
0xf3421003,0xe2790e3c,0xf51b2dbe,0x014fe68a,0xffa81738,0xf4bdf075,0xd7872774,0xfdc70911,
0x0f440259,0xfa07e7ab,0xe8ef15b5,0xe9ab1aab,0x01acfde5,0xe061183f,0xf1960e28,0xe4821db4,
0x12ef01a2,0x15abf23a,0x29d3e192,0x232ce6fb,0x187eda69,0xfc51f23b,0xf4c9153c,0xff84faa0,
0xeb130474,0xfba71268,0x13fdfa0e,0xfc14e938,0xf733102e,0x078df805,0x13ccf653,0xeb77f821,
0x01f20cdf,0x0f0af322,0xfcdf0fe0,0x04a80003,0xfcaf03b4,0xfd500258,0xfa12f658,0x03760443,
0xfb3cf632,0x15e1ff1f,0x17a5e711,0x0609f45a,0x041ff3cd,0xfdd30abb,0x0df5fa40,0xebdcff60,
0xf3641198,0x0236004b,0xff70fb23,0xf0d90cb1,0x205afeb8,0x0b7fdcd1,0x0425ffa0,0x112aeb6e,
0x1d6de72d,0xf7c5fc73,0xfd4006fc,0xfe22fe3d,0x1379fe02,0x080cece5,0xf13effda,0xf45620ae,
0xff2ffba5,0xe4d11027,0xd5662b77,0xfac31bec,0xeb7009b2,0xf9120f79,0xee0eec1b,0x01961388,
0xfe02f2ec,0xf808087f,0x1171f6c8,0xf5fefa9c,0x12eb0afb,0x105bf9c8,0x2762ea94,0xf932ee24,
0x0cbc1962,0x0381dbff,0xfcea0429,0xeb2dff4e,0xf3ad0752,0xe5fc0cdf,0xf6e00995,0x105efc6b,
0xf590000d,0x11f30be9,0x1b88e540,0x1c48f601,0xfa71ec32,0x1570056f,0xf9edee6d,0x11ad0447,
0x0617e1fa,0x020cfbb9,0xf5760148,0x01080caf,0x1618e6fd,0x157aea74,0xf801f7f3,0xda9c1634,
0x0dd70bfa,0xf7fcff74,0xf5051666,0xd1812837,0x071817a6,0xffadecf5,0x00a80c97,0x06bfe5c9,
0xf9bbfe1f,0x0faaf7f4,0x000bfc2a,0x18cdf4ff,0x15f1e000,0xf8ecfce0,0xe482166d,0x013a184e,
0xe3d00106,0x02ec1e91,0xff07f795,0xe78d10bb,0xedbf11e6,0x0be8026d,0xff8de775,0x0682fb79,
0xf6e208eb,0xef550c1e,0x019a15ee,0x0bc6fdb4,0x0bb9f525,0xf43500fc,0xfb640868,0x0284f1d8,
0x1d52ef18,0xe938ebfb,0xfc321961,0xf2c51274,0xf72513ce,0x15daf7a1,0x17a5e549,0x28d2deac,
0x08c1e02f,0x2adbf78a,0x092dcd82,0x2d6ff09e,0x0b44d4c3,0x15c6f80c,0x07e1f1e2,0x05adf694,
0x0b49ff8e,0x022af58a,0xe5ea25fe,0x071ff929,0x090707a5,0xf3edf308,0xe7fc11c1,0x0c3bf85a,
0x16b5e4e8,0xf099fb18,0x1d27f93a,0x18a5e9e4,0x13d7e966,0x0e2204ae,0x11b5efc0,0x0aeef133,
0xefef0b66,0x0fbdfd6f,0xedcdeffe,0xe644186e,0xd345184e,0x0df311ed,0x0e6af738,0xe6d70169,
0x08b91594,0x06390171,0x1029eaec,0xf053019f,0xfe110aac,0xf7c3ee80,0xfe0a1003,0xf1fb09e8,
0x0a3ff874,0x08f4023c,0xfe5cf559,0x077ef9ce,0x00e909d1,0xfa120090,0xf18111f3,0xfdf81111,
0xea9b05b8,0xfbce0181,0xf5a213a9,0x0846e4a4,0x0969f9ca,0x0d75e909,0x04fdfed6,0x28f0f8ca,
0x2b45e321,0xf091eff3,0x03ef10a9,0xfeb2fd2e,0x05f5ec1b,0xe7f00b51,0x05b4024f,0x151ee974,
0x0be5e9ae,0xf5dc02e9,0x11a9f9b0,0x0e110288,0xe57a09bb,0xf6da18cf,0x228bf390,0xf54af2e3,
0xe5bf1af1,0x07a707fa,0x09a0e953,0x0088efb7,0xf6bc01f0,0x0945f850,0x013bf723,0xf2511181,
0xe2e01c79,0x02d61176,0xfc760eb5,0xdea9155e,0xfda81f3b,0x028cf50a,0xf948f852,0xf2a00167,
0xff33ffd7,0x025df154,0x0a8bf912,0x0cfd0026,0x23d3dba4,0x10e2fe50,0x1029f3b7,0xf5790bed,
0x01dd0846,0xf31e0332,0xfb23fa83,0xf705fac8,0xee4b0415,0xf9e208d9,0xfa641274,0x0975f7a1,
0x11daf7b3,0x1893f39a,0xf1ebfb8a,0xf5bd08df,0x00260715,0xf3f3fbbd,0xf8221672,0x068e0056,
0x0ffbf4e9,0xf93a0264,0x03e0ff4f,0x08acf3f1,0x0c26f9b5,0xfe9dfa0a,0x0330eba6,0xeb0b133b,
0xfb8efcdb,0x11050480,0x0aecf23b,0x05c8033d,0x0ab00196,0x2a35e30c,0xfc31e476,0xee8b1125,
0xe9d2152f,0x00fef6ce,0xe5f60913,0xf1661050,0xf5c512bb,0xf5d813ab,0x0b490494,0x05a10229,
0x1101f8d0,0xf7d4f79e,0x0df401c9,0x1d5dea96,0x1249d01b,0xd43007b9,0xf9b40acf,0x1123fa99,
0xf55403e1,0xf9f00dd5,0x01dd1120,0x132ef930,0xff20fa89,0x140afad3,0xfcb7f60a,0x15f1f460,
0xeb9af491,0xfe4aff1d,0x0577fd0e,0x01a80306,0xf9fcfe6c,0x02220e11,0x0bd2f5db,0x031af9e7,
0x1417fb1e,0xe81dfdd4,0xeb340e87,0xdcf81c7d,0xed941039,0x03080b6f,0xf8080487,0xf0fe13e1,
0xf67d0e3c,0x09d1f7b1,0xfce7018b,0xe2fa0892,0xdcf432ad,0xe8950ba8,0xcf2d325e,0xfce40df8,
0xf5a00a9a,0xfa3a0662,0xff3805c9,0x082af098,0xfae4fb21,0xfcfd1390,0xf4ed0014,0x0c530d72,
0x0b1de993,0xf34b0b9c,0x1772ef32,0x1318ed24,0xfd0bef9f,0x00300437,0x0e76f393,0x1d58e491,
0x052ef3bb,0xe10113f4,0xffec1648,0x1268f03c,0xf760fb3f,0x0359fa8c,0x20acfa68,0x1909da74,
0x0903f52a,0x2664e91a,0x19cee762,0x0bc3e77f,0xf33109c9,0xf1340c5f,0xf47d07ea,0xec1c004b,
0xf5640697,0x08a70189,0x1382ec1c,0x037af56e,0x1024fb92,0x170af122,0x125cf131,0xea140780,
0xecfa1dfc,0xf6e20f04,0xfa94f850,0xd51921de,0xf64113ae,0x21f6ec3a,0x1a8be0ce,0xfb97eb3a,
0x095e0411,0x148bf741,0xf94bfae1,0x1637f948,0xe79305f0,0x033dfadd,0xfd370677,0x064eef4b,
0xfe270698,0x190af33b,0x04c6f203,0xfc25f84f,0x0ac3172f,0xd92a08f4,0xf7de1c9a,0xf9f2034f,
0x01def5bd,0xf771f8e8,0x0a7bfb36,0x0d29f64f,0x1662e3e3,0xf01a0f5e,0xf6ad0841,0x07741801,
0xf504005f,0xf760ff1e,0xfc3803fb,0xeb7b0312,0xf08607a5,0x057b09ef,0xe54502b6,0xfb521140,
0x130d0c89,0x03c7efa9,0x0d4f00d4,0x002bfe71,0xfbff00a0,0xf686ffb9,0xfaa903d2,0xe6c10726,
0xf544127d,0xf04a0788,0xf2510752,0x0bcf0874,0xfb0301e1,0x019f04ff,0xea580a79,0xe8fb1c58,
0xe9ee0e56,0x04d710cd,0xf1910749,0xfc4304db,0x028d01af,0xf96df78b,0x0a32f90b,0xfd17034e,
0x051bf808,0xe6f4077f,0x12c60c32,0x0a53edb9,0x2b44e66f,0x042bf6ec,0xf827f894,0xee5a0da3,
0xf4320ea0,0xf7d0fed4,0xfac8127d,0x17f7f519,0x0c16e604,0x176ced2c,0xe77c0974,0xf920096c,
0xffc603d2,0x02d002c4,0xe9a101af,0xfc261570,0x0161fb0c,0xebf7095e,0xeed519cb,0x06f7f9de,
0x17d3ec1b,0xf1261072,0xeb0305e9,0xece02407,0xffe11380,0xe9b50550,0xed760e25,0xe3bd10f4,
0xf72f082c,0xf319fd6b,0xf3a4050b,0x1f7efb97,0x1a03ec87,0x1061efba,0xf27b0840,0xfa7e129c,
0xe7431435,0xfec1023e,0xf5ff0a36,0x0cf5f874,0xf44c0287,0xf6540b04,0xf7ab095a,0x096cfe4d,
0x012bea52,0xe94c06d4,0x05eb0a39,0x149cfdbb,0x1109e88d,0xf6180c43,0x213cf262,0x1f78dc5b,
0x1219df3c,0xf436ee6f,0x06650e1e,0x0e6af856,0xf17c007d,0x0501105f,0xf56b08a9,0x0de20218,
0xe29c089a,0xf31c0c2e,0x0ee4fbdc,0x1be0d9b1,0x1810e4cb,0x1f53e226,0xf47602e4,0xff54fcdf,
0xe6e021e2,0x02900936,0xe1ee0f2d,0xda7f2293,0xd8722a08,0xfd001a7b,0x091de0dc,0xe2ee0c8f,
0xfbc808c1,0xf5251266,0x00c8fe1a,0xe95c1c71,0x27830189,0x14acdfa8,0x20cbe8b9,0x19b9e1ab,
0x14acdf9f,0x0774eba2,0xe91b0c1e,0xf0bd0ceb,0xff3111d6,0x0d49f21d,0xf35904e9,0x0c21fc74,
0xffebfc83,0x0923fbb8,0x069709f8,0x2549dd86,0x0a29ec7a,0xff62fa64,0x0942fdd2,0x06a7f6a7,
0x0420f3b7,0xdeff0f3e,0xf85e1389,0xf2030c10,0x18b1f60a,0xffadf2ab,0x0e90fc55,0x0086fc40,
0x0991ffdd,0xff0c02ae,0x0b0f00f6,0xf4bef855,0xe7471e11,0x0cb7eeb8,0xf6890629,0x0ccdebc0,
0x1d4ffadf,0x35d8d291,0x0b1ae06f,0xfb390d6e,0xf1320843,0x03de09ae,0x0ba0e560,0xdf450d26,
0x00ff0ac2,0x0e91febd,0x1a20e2cf,0xfa6f0f1e,0x0c37f705,0x1359efc4,0xf459fdb8,0xf0560874,
0xf8790645,0x0911fca0,0xe5821b28,0x0da0057e,0x0de2f232,0xfe22effc,0x03b60a21,0xfcf7e433,
0x1e10f7f1,0x0a41ea68,0x1ba6f9a4,0x09b6e1ce,0x07b40d40,0xf6670acc,0xfc9900e8,0x0be2f981,
0xf74af4b5,0x08650c94,0xf71ee6e1,0x073d14be,0x1b0be7b4,0x011d08f8,0xee2fed5f,0x0341160a,
0x1050f2c5,0x081fea12,0x10b2f398,0xe8d1f528,0xf2422022,0x02240549,0xf1f9024b,0xf6f9140b,
0x008b1724,0xfe7afb1b,0x11f2f713,0xff3df89f,0x099d01de,0x0b30eae4,0x0e41f1f1,0xfd4ff7f6,
0x16a9ff01,0xfde6e4da,0xe18b14d9,0xfd8a1b57,0x0489f273,0x0e3ee9eb,0xf987fc60,0xf79c23dd,
0xf645f203,0xf57e2046,0x0cd7fc7a,0x101dfd50,0x04dbeac0,0xfdaa024b,0x1482f34c,0x069df61b,
0xff84fa31,0x04e4f325,0xe5991883,0xfa4efd6e,0xf1ca12ec,0x071300f8,0xfc45088d,0x04d20027,
0xeebcfd38,0xeb5d1538,0x1237f852,0xf6600524,0x0e2ff297,0x1710fa01,0x0c80e692,0xdc051a31,
0xfea91d7c,0x0542fd30,0xe5350391,0x01c5143c,0xf37cedb5,0xf1d80e28,0xe4422277,0x0cbdf65c,
0x11d0f674,0x0895f9cd,0x0da8ea59,0xf60ff8f4,0xfcbd11ae,0xf6b6f79e,0xf520202b,0xff74ffd1,
0xf40517f0,0xfbc614c7,0xf2e104f6,0x1958ee64,0xe743ebde,0xe6b81967,0xef3409a2,0x0e3f07e8,
0xe6c6fd2d,0xeca23184,0x3b5cea51,0x130bce7d,0x162ffb95,0xfd75f5c4,0xfa94ffdf,0xfacdf95d,
0xe0b31cd8,0xfe180fa3,0xef95061a,0xfb9a101e,0xe8c401ab,0x1cb90ea8,0x1739d3c3,0x0fcbf58d,
0xeeb8036a,0xf9c00625,0xfcf8fa4b,0xdf451490,0xeada19b6,0x2462e852,0x07bef19f,0xef420c43,
0x0e8b171a,0x0535f896,0xf11519d8,0xf0ae1057,0xfab9001a,0xeb3af466,0xede81214,0xe353099f,
0xf510ff28,0x02830959,0xff9e0502,0x08c9009c,0x16580105,0x0689ef92,0x00390d6a,0x0159ff79,
0xf2090625,0x04a30008,0xe9270d4c,0x0d0e0141,0x035aedc8,0xec9b10ee,0x14a3f044,0xfea5f8dd,
0xf5e7faf0,0x07a205c4,0x0d14f474,0xf9e401ab,0x03ad05b5,0xed0b11f8,0xf8c61061,0x139ce67f,
0xecf20ae1,0x1680fcc7,0x08e5ef7c,0x1c08df12,0xfa7707b1,0x128ef4f2,0x0b4ff18c,0xf23803a7,
0x19d70261,0xfebaf201,0x0ec5ecfe,0xf30ff891,0x096d07dc,0x035ae709,0x0a05087f,0x1bfef34f,
0x15a5e412,0x0738fc7d,0x02d8fad4,0x268deda4,0x1b20cf4b,0x0d75f14e,0x165ae261,0xecf5fef9,
0xf34b15d3,0xf67902a5,0xe00b2a1e,0xd7b41a79,0xe3d42ff8,0xfb690a65,0xee1c0837,0x0011057f,
0xe4b60a57,0xec251527,0x101afe8b,0xee310103,0xe6fb1054,0xf1c228ee,0x0f57ff30,0x0296fb3f,
0xfd090a13,0x01d7fccb,0x11a3ec39,0xf000f68e,0xfb80fbdc,0x15ebf943,0xf7eef72b,0xe7241250,
0xe681218f,0xefe71869,0x03290726,0xfb8802a1,0x09ee02bd,0xef4b0943,0x0aea0ba4,0xfecff0b5,
0x0cdffbee,0xeeb2e47d,0xd2c42970,0xfd150f55,0x03ea0096,0xf9b20103,0xe76e1f21,0x371d066e,
0x0d6ed3cd,0x1492fd8d,0x03d3e299,0xf45e1061,0xf951ee66,0xe7ed173e,0x038ff232,0x0115fcce,
0x1b1df4f2,0x0b39e4e8,0x1c88fce4,0x026af33a,0xf5e61501,0xe9861764,0x1ba1047e,0x0ea8e6e4,
0x08bdfe30,0xf536fba4,0x1395e76a,0x062decf6,0xdf690483,0x028510e0,0x1222e4e3,0xfb0cff2c,
0xeef212a5,0x1a1307ee,0x013cf2df,0x2a86fa7b,0xf94bef18,0x1211f7de,0x0276f687,0x0058fe0b,
0x01fdf046,0xf2f50766,0x0832fc32,0xd4001525,0x132e0e81,0xef7df5bc,0x2615002b,0xfeb1f374,
0x240bf57f,0x017de8da,0xefaf0cb9,0x0731faa9,0xfe42e7e5,0x10e2f3bb,0xfa230a85,0x1c8ff232,
0xfbb3f4df,0x10aa0081,0xe3231bac,0x1b7a00fb,0xee51e8db,0x0b3c0623,0xe42406d9,0xe19f1d66,
0x03aa046d,0xf6480ac3,0xff8eff88,0xf4e40ae5,0xeb6b0547,0xeda822fe,0x1c39ed97,0x0214eeb8,
0xf18a046b,0xeacc255c,0x1402ff48,0xf1d0f855,0xf9771f5a,0x00d6f0bb,0xfc1506ce,0x05bbef13,
0xf844097a,0x0472fb66,0x07580133,0x23f6e60d,0xe813f718,0x022c192b,0xf436f1bd,0x08f114c8,
0xfa79f7b3,0x01ab0cb2,0x179de05a,0x0334f629,0x01b4f982,0x061cf363,0xf40d074a,0x0d8dfea5,
0x145d08c9,0x0e58de76,0xfe390f94,0x19d2f95e,0x1109e92c,0xf8d2eda4,0x0efefe53,0x0d3bdfe6,
0x0a9ce4bb,0xf9e7069a,0xf551fd1c,0xf8d617bb,0x1208fd46,0x2d1ae557,0x1883e470,0x105ff4b5,
0x08f4e846,0x1d12f9ed,0xe2a9fa94,0xe76e09db,0xde142797,0xf27a0ac4,0x001f0a27,0xeeb00c6b,
0x091605b2,0x0433f5af,0x0be80563,0x000fe42b,0x097b0bd3,0x006ffb21,0xff4df91d,0x08cc01b8,
0xf115f7ea,0x007d1281,0xfbbc070e,0x24d2f664,0x124ddc5e,0x06c5fccb,0xfc65fea0,0x22e2dd52,
0xf1bdf376,0xfa38f9c0,0xf45a0206,0xfa490b9b,0x19fdfdd0,0xfdd7f68c,0x22cf0f96,0x1babd2b0,
0x1d1defc2,0xf874f8e8,0x2ef9e884,0x0650ded3,0xedee0ce7,0xe4d90279,0x08b606eb,0x106df80c,
0x1d27daf2,0xfcb2f06c,0xed5b0f8f,0x08260514,0x04a20c20,0x0ea6f4e0,0x0675fbfb,0xfa14024c,
0xef9800b5,0x213fe8c0,0xfd39f3b6,0xef1e0405,0xfc4013ff,0xff330bc9,0x1389e7e0,0xf4d709f8,
0x080404ca,0x05f3ed95,0x0bb20001,0xec68042a,0x168bf325,0xfcc1fb69,0x073efd1b,0x103cee3c,
0x0fab0015,0x0d01df38,0x0ffaf157,0x07f6e924,0xeebfff88,0x15cc073d,0xe8170578,0x02b012f9,
0xfa3a0d58,0xf14d1237,0xff6d06b6,0x1e93ecdb,0x137cd783,0xed94033c,0xed9f0d38,0xfdc700a1,
0x1117f0c7,0xecf905a1,0x07b10252,0x0f29f580,0x35fae013,0xf6b5f604,0x04be00ec,0xe42d1ad2,
0x0b030292,0xf947fcce,0xf52102de,0xec27085a,0xf7e307bc,0xe18918c9,0xf274160a,0x1769f837,
0x07a4f13d,0x1135f495,0x0ea9ec69,0x0181f457,0xdb54183f,0x00a71a75,0xe73a0074,0xde192a5f,
0xf22b1dbd,0xf3b50629,0x1366f370,0x00f6f6d8,0xfd80fcbf,0xf4e0fa5f,0xf44914b5,0xee0c0c7c,
0xfba40e43,0x06250316,0x20dfea74,0x2de1eac6,0x1e3ecf8a,0x135de480,0x18e6ed64,0xf195fabc,
0xed4a0896,0x032b05fe,0x0d55eaaa,0x14f9f880,0x02c9f957,0x12d8f107,0x0c6af84c,0x296ce6a8,
0x0daee237,0xffc603ef,0xf60ffa75,0x09b9fb11,0x106aeb1d,0x0074ede6,0xff55002e,0x058d0398,
0x126fecde,0xff6a045a,0x13a400bb,0xf4640066,0xf4910fc3,0xf4370a6d,0xf70f05e3,0xeffc0635,
0xf3aa064e,0xfc4109ef,0xe96f09ec,0x063908c9,0x066af387,0xfedd096c,0xf65805ec,0xf881f9ee,
0xf59b0840,0x0ec8fce8,0xfb9df90b,0xf1b00e3e,0xf666176e,0xf96c1902,0xf914ff88,0xe79a0c03,
0xf2840bd3,0x127d01d7,0xfde7eb9c,0xf06209e6,0xea51177c,0x021d159b,0xec30fd35,0xf7e10871,
0xf1530499,0xf7eaff0c,0xfd321737,0x09f6ec27,0xf6d51046,0x0d6bff0c,0xffcdf9be,0x0004fc14,
0xf9c51938,0x1095ef2d,0xecdb0756,0x0a9710b7,0x0580e8af,0xebee104c,0x0770f358,0xfe16f960,
0x05b0f3f8,0xebc40376,0x1056fff8,0x1319fa48,0x0f95f5b6,0x0de9eda4,0xf4220fe7,0xf2df0e26,
0xe10b1337,0xf72d1b28,0xe4b00357,0xef0c1da3,0xf47307d5,0x0029f67b,0xf962fcd5,0xf2210c2e,
0xf7c60780,0x00f2093d,0x0abc0514,0x0762f819,0x03db10de,0x14b0f2e5,0x0591e3a3,0xe4cb1435,
0x0388016c,0x005ef2d6,0x01ef0424,0xfef2f21e,0x0c56ffd9,0x020ffb63,0x0a6f0023,0x06a1f793,
0xfaa90bbd,0xf88f0456,0x08c406aa,0x11e0e69b,0xf74cfe3e,0x21d2ed4d,0x050be70e,0x16c6e862,
0xfb76fbb6,0xe9111acd,0xfe7008cf,0xf1720e1e,0x00f10e4e,0xe698f665,0xf42f264a,0x0a08f360,
0x0638fb41,0xe7631169,0xf8a71014,0xebd60be6,0xf7671577,0xfedff89a,0x119af4bc,0x1358f239,
0x0086ed3b,0x2703f5e3,0x04b1e458,0x08d1fbfa,0x136ae920,0x064cfb4d,0x0295fb6c,0xfaf30f27,
0x04720765,0x1dcee761,0xf901fd25,0xdf5f0e7e,0xf3450814,0xf21a0963,0xfa9103b8,0x0cf4f8c3,
0x153ef700,0xfe4df54f,0x12fe0c78,0xeaa60122,0x037e0404,0xfcb70163,0x105bfd72,0xeac8f0a0,
0xe7a31db1,0xf5481065,0xf6d10e45,0x003f07f1,0xf579f99d,0x054b0540,0x080302f0,0x1bb5f0c7,
0x1b05dae2,0xfa47fd45,0xf66b0aed,0x24cae286,0xfbc3eb5a,0xf21a0f48,0xfbcb09ca,0x04560cd8,
0xfb8cfe37,0xf59815bd,0x04ecfa4b,0xed4ffe61,0x0283fc66,0xe10d1403,0x033905e7,0xf5a20d09,
0xfb0a11c8,0xf59306f3,0xf77f0d8b,0xea1c0a53,0xf66513b4,0x01e3fd55,0xefaf0440,0x087bf52c,
0xf62611c3,0x2097ee5c,0xedd6fecd,0xf2da1152,0xe6ca11fa,0xe9b82215,0xec540cfc,0xea242584,
0x27d3ea11,0xfef2f9ff,0x1ee9dfc2,0xe7ce088d,0x1e75f0c2,0x089ee90e,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_22_standard_DRUMS_vibraloop[512] = {
0x00000000,0xf82c100b,0x065b0002,0x19c7f87b,0x01c8e1a9,0xdb0d13da,0x0c7c1011,0xfd87fbfc,
0xf4560068,0xdf120fb1,0x04191c38,0x1db8eaea,0x1776df58,0x1086e28b,0x08c0fce8,0xf25bfbcb,
0xcc29217b,0xf5cd210e,0x00970550,0x0b84f7ad,0x0406edc1,0x028a03cb,0x0315fd4a,0xffc4f929,
0x0068fa11,0x04580681,0x0ae9f753,0xf7e5f495,0x027304b5,0x04f2fcf2,0xfac30382,0xff3bfbd7,
0x0178fc2a,0xfd800395,0xf4e907ac,0xfd15047b,0xfda4fdf8,0x007b047f,0xfccffe2c,0x00a700e1,
0x0ac5f929,0x032ff9ee,0x076ff534,0x001bfa34,0x075a009a,0xf6a2ffa7,0xf67206fa,0x0528fd08,
0x038b0280,0x170df411,0xfb87e8b5,0xef670d40,0xf11d1265,0x003b1050,0x0eb3edae,0x1e14e90e,
0x1a0cdaa1,0xb2bc224c,0xe4313c37,0x0eb0f714,0x2cceeff0,0x04c4da65,0xe1c211ab,0x1bb6fa20,
0xe892000f,0xefc32370,0xf79af76c,0x08810361,0x08b9fbe1,0xfbb3061f,0xfb16f068,0xe36810f3,
0x242814be,0x3c8ec6d7,0x3b2db893,0x4424b47f,0x053bea0c,0xfb950382,0xdd9b0a96,0x097513e9,
0x12d1e8a2,0x0e740123,0x4c1abf62,0x02a9d7fd,0xf3db0472,0xbd792bf3,0xf9502c64,0x073ffaf6,
0x063cf888,0x0bd1f3c1,0x1db2ecc3,0x0c76eb05,0x03e9faf3,0x005af5e3,0xee9e07a5,0xec231765,
0xde722086,0x08550a67,0xf35cf652,0xe9141aeb,0xf4a61273,0xe39a0e65,0xeb95244e,0x1752f630,
0x0f3ceaca,0x1995ecd9,0xe841fa2e,0xe1ec2a5c,0x1071f6e4,0xef3b02c6,0x12ec0956,0x09a7e91a,
0x065bf85e,0xfb32f7d3,0xeaa913c3,0xf39217c1,0xf47a0567,0xff9d0881,0x1318ef2e,0x0186fc0a,
0x0743fc43,0xf85bfb3c,0xfee504b5,0xfc8301ce,0x03bb06b7,0x0dbcf1db,0x0432f646,0x09bdf731,
0xff7bfcfb,0x045500e4,0xf4b6fdf6,0xf6590dd9,0x03b0feeb,0x014b07cf,0x15e2f062,0x02c0e9bf,
0x0ae5fd4e,0x0f53f9ce,0x0305f1fb,0xecad0812,0x138700d7,0x3291e21c,0x304fc1d4,0xfc99ec40,
0xf6fb0cce,0xdca71453,0xbfbb29ed,0xb747468b,0xe74e4b36,0x199bef2e,0x22d4e38f,0x4da6b5bf,
0xf63ce633,0xe07f1dee,0xc3ed240f,0xed7b31fc,0x1084fd2d,0x01b500b4,0x3441da65,0x077cd1e1,
0xee3616f6,0xbefd2514,0xc8734ba7,0xf99608f0,0xe90a138d,0xf05f174c,0xd7e423c2,0x0dc20bab,
0x1615dafd,0x07aefd12,0x1185fde3,0x0b68eac1,0xfbcef192,0xf76c0930,0x03b30fb5,0x0709fcb2,
0xedd4f806,0xf8d408d0,0x0d700651,0xfb82010c,0xe44a0aac,0xef8613fc,0x028002f6,0xec1113ad,
0xfb570e8b,0xf5ec00be,0x07340178,0x0606f548,0x00a70851,0x09dafa60,0x0966edf4,0x0378f822,
0xfaa705fd,0xf27e10d6,0x00110322,0xfa77fa37,0x03310afe,0x11c0f4df,0x01a2f77d,0x017cf949,
0xf3540612,0x003e0ee7,0xfd35fa9f,0xf4e20bb4,0x03d0ffb0,0x0172009d,0x0b5ef888,0xfafffbc4,
0x02a70694,0x01daf7ff,0x01a40146,0x0395fc90,0x041402e3,0x11caf062,0xfcdff3e4,0xf710092c,
0xfbfa0a1a,0x04320378,0xfde0f727,0xf86d07cb,0x175ffa71,0xfde0f264,0xee3d0d0a,0xf33809d5,
0x056109d7,0xf49c0260,0xef841133,0x09f7f888,0x1725f76a,0xfa34fbc6,0xb14c20b5,0xae5c4c54,
0xebc24038,0x29a9ff11,0xe98fe69f,0xdce0196f,0x0cfe0d00,0xfd670aa0,0xff54f8ed,0xfea9ff6b,
0x58c3db46,0x14f0b7a3,0x1a5507cf,0x35f0b1b4,0xe63706b5,0x03820427,0xbff126e6,0x00cd2c80,
0x0d11dece,0x04cc0685,0x0022f24e,0xe802216d,0x078cf38f,0xe4140e18,0x155f09da,0xe4670243,
0x009a1703,0xe767f0ea,0xec082b6c,0xff150401,0xe59a1c18,0x26d9ee92,0xf52fe696,0x150d1044,
0xfd97e9b9,0xeb0017fa,0x009afaf3,0xf3e112e2,0x2334f107,0xf66bef08,0x009d0ab3,0xefc50097,
0xf2bd15fe,0xf1490bcd,0xf2841781,0x0adff900,0x0773f3ae,0x0445fb03,0xfd5b0694,0x0b1ff9ac,
0xe708ff64,0x005117ac,0x0fb1f082,0xfb4c025a,0x0344fcc2,0xf4d80022,0x078805b2,0xfe93fc53,
0xfca308b9,0x0213f996,0x0520005a,0x0aacf5e3,0xf0ab05a3,0xfc990b04,0xfeb5fd63,0x02b90401,
0x0855f736,0x03f7fea9,0x06b1f80b,0xf3920234,0xfab209c4,0xfbea0763,0xf63908a6,0xf4f50cb7,
0x0fc2f649,0x091df2ca,0x1e18f7bd,0x0827e72d,0xfa01fe8d,0xf8b7fb8b,0xd6172575,0xf75d271b,
0x0fd5f2a0,0x26c9d8f8,0x201ee225,0x162ef01c,0xfb4ceca0,0xa6501f05,0xeb9b5612,0x1b37fed2,
0x004ee59a,0xf639f672,0x04af0ce2,0xc6052777,0xd21c3aae,0x1778f8f9,0x770cc3cc,0x693589ef,
0x1a23b79f,0xa97c12c9,0xa51f6b0f,0xa9d860d9,0xd82d4126,0x00dc0c25,0x1da8f3b1,0x49e1d084,
0x3c1ab192,0x2317d0fe,0xf66bee85,0xbb6e2eec,0xd09941bf,0xce18284f,0x0dfb2310,0x40eac7ab,
0x12a3d8a7,0x27d4e633,0x266dcff1,0x0e61eacd,0xed5bfea9,0xd12b284c,0xff6d1735,0x0709ff58,
0x08a4f21e,0xfc900251,0x20b2eb82,0x089aee42,0x1331f69f,0xfa97ee36,0xf9c80bb6,0xf62905a6,
0xe4ec1a14,0xf15611d8,0x068f0181,0x193bf34b,0x0c3de94c,0x0236f8ed,0xfa67ff97,0xfa280bd7,
0xfd9a0148,0xffec023e,0x0ecdf773,0x09d5f371,0x02c2f6d1,0x01030150,0x044ffbb3,0xfd54ff4e,
0xfad3023e,0xf8e40939,0x02700204,0xfdeaffa3,0xfc8600ea,0xfd0b040c,0xfc9b0711,0x1c68f4ce,
0x1200de27,0xf3de02e8,0xec7a1301,0xdf581a10,0xf7cc1067,0x049c0283,0x19f7f88a,0x037ae1a9,
0xe2cb1076,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,

};

const uint32_t sample_23_standard_DRUMS_paisteping[6656] = {
0x00000000,0x1799247f,0x25161d67,0x2c830f4c,0x6472dd0b,0xe662f969,0x06c2174d,0x04b30fd8,
0x097e0690,0x0c70f528,0xdfed1787,0xdc0b1305,0x1a2d2402,0xfb8be665,0xf33ce3c4,0xf803e808,
0x07bff28b,0xf47ce23b,0xe6fa0b80,0x46590114,0x3359d8fe,0x3fb0f133,0xf87bf3e7,0xf3172dba,
0x3e5f1c01,0x2adbdb02,0xdb77e664,0x9b273cee,0xd27b6c3f,0x031af31a,0xcae62cf8,0x4901ebd7,
0x4e0d8e03,0xec301c99,0x13cf0ac3,0x0781e381,0xfb140649,0xfe691642,0xd75f24a3,0x2ecf0eec,
0xc4afe2e5,0x1681376b,0x0cd0cd5a,0xb8794037,0x2ac6110e,0x1c6bca2a,0xeaf6f6a1,0x0c0c057f,
0xebbdf04d,0xf2432091,0x21f3da17,0xf4f8dcdf,0xf094fe3c,0xd7f609da,0xd27d26cb,0x0066d349,
0xdcf51296,0xd6a3efee,0xe1f2018f,0xddfb22b0,0x3dc8d09d,0x2bf6a6d2,0x1412d7ad,0xafce0dde,
0xe3b9441e,0xe9ff0597,0x147601cf,0x2e0d9d3a,0xe9f53a02,0x04e8d0c7,0xe9e20a92,0x38b5f4b4,
0xea03dab0,0xf8313133,0xfd4202d1,0x0db90110,0x2395f084,0x0c93fbe1,0x1af10fb7,0x1452d0fa,
0xe03c1fc5,0x0f59fd30,0x013b0ff1,0x08a414bc,0x1f2eaf3e,0x1042ef71,0x22b3cb88,0xcb171838,
0x0565010a,0xf491d8fc,0xd30bebe0,0x006f135c,0xd8eff325,0xf2a3fdd8,0x197bc27d,0xb83bede6,
0x0bad09b9,0x1768c1f8,0xc23d1065,0xb4b9171b,0xfe481b05,0xef75f398,0xf6c319cf,0xf3f4ff78,
0x1a3cfc5b,0xfc02e209,0x1efb1cfd,0x1b8fed00,0xedd6fc31,0xf86a1bba,0x28980be5,0xfdf7f55f,
0xf66926d5,0x2078f33e,0x03fcf8b8,0x2f77f1f3,0xc1bb003c,0xf3ea4d39,0x1681ed81,0xfb2eff6f,
0xff980d49,0x14e3d892,0xef7a2ed7,0xe442f13b,0xe700ffe2,0x000b1e64,0xe4bff206,0xa5cc2f3c,
0x190500cb,0xdd9f0625,0x14dfcfb2,0x4292da48,0xb5c2e80b,0xfbd61060,0xe013cf1f,0xea7d3851,
0x12abcead,0xbd712333,0xeea21916,0xfb9fd87f,0x0fa2104e,0x2265f4f5,0xc518e97c,0x0cf920c0,
0xed8c058b,0xe919083d,0x17d50163,0x09481afd,0x1a40db92,0x2146d06c,0x14e40ef8,0x1ef3f74f,
0xf6c3fa2e,0xf1cb2e76,0x0beef272,0x0b2e06aa,0x0796195a,0xfb96fb0e,0xf4a600ed,0xfb761089,
0xfd9e01ab,0x34bd074c,0xee2bd8bd,0xe92e081b,0xf5e6f774,0xe63c14a8,0xfa350ba0,0xdc86f129,
0xe23905aa,0x00de009d,0x2a3ad66f,0xd20009ca,0xf5360ceb,0xc9ee0446,0xedd715ba,0xfc77250d,
0x0252026e,0x0462ec52,0x1979cf72,0x1460f028,0x09a30520,0xc96c0ca1,0xdf3114a0,0x0dd107ef,
0xed181f1e,0x3ef9ec83,0xfd14e2c1,0xff95098c,0xf330f1c1,0xf52f21ab,0x4ab606ea,0x0330a75f,
0xdded26b9,0x00f1146c,0x0a510373,0x0fee0202,0xd63a071a,0x05d30a2f,0xef55ea12,0x050e2d2d,
0x2051b623,0xd82e0ce8,0xfa070d9c,0x06c9d5b3,0x27d6f788,0xd88a0e55,0xed481a72,0x35ede8a1,
0xd813f8f5,0xf29b2447,0x36f9f062,0xd3260ad5,0xf81c01c2,0x316fe044,0x07f3f797,0xf340e428,
0x0abe1b73,0xea33f1b4,0xeca903bc,0x1285221a,0x11e2e6e1,0xe25aeafa,0x0f210f9e,0x0aa4ec36,
0xf82b121c,0x0cd4ef8c,0x11560288,0xf488da6d,0xfbe42798,0x0330fe8d,0xf8c60ce9,0xf191f959,
0x01a6f054,0xfd0bfe5e,0xf8230851,0xf122fb32,0xf758ecd7,0xfcf8f56d,0xf5b6f319,0x0209159b,
0x1f97e70f,0xdef6f4e5,0xff6a0e93,0xe7d60a48,0x095d2153,0x05290255,0x0491df60,0xe0c41867,
0x0de819c3,0x2cc4f1df,0x0f17d20c,0xd9811878,0xecb01477,0x01b815ae,0x12071ba1,0xfcc4e267,
0x04cfed71,0xfadd057c,0x03ae1bb7,0x2bbefd01,0xf810d181,0xb730204d,0x4329140e,0xed2fe59f,
0x078d04aa,0xfc9ee8f4,0xf9900806,0xe43cdfd4,0xf9a53788,0x1bf2dc1e,0xe210f419,0x0711f8e3,
0x190cf853,0xff6fdfd3,0xea400ec6,0xe0db12a3,0xf031041c,0x027c0afd,0x1d91fdee,0x1464c50c,
0xe4ff0ee6,0x06f4f1f9,0xf4750a26,0x1e6af80b,0xe1fbfe78,0x088af41f,0x0a540171,0x08770b29,
0xf2f70dc3,0x132ef947,0xe40d21f6,0x2e290cf1,0x1080ddb6,0x014718d2,0xf4c31336,0x1453fe50,
0x0d2ef827,0xe1950822,0x28150bb8,0xf939f1cb,0xf15a0065,0x1302f4fe,0x12ecd422,0xc0c52a32,
0xfe2b0dfc,0xf166da7c,0xf89017a6,0x1d2fc009,0xde872887,0x1b6ce9ff,0xbe2cecfe,0x181f0b14,
0x09a50154,0xe2f0fe77,0x2107e951,0xfeb1e6dc,0xe607177f,0xfe3b1124,0xfd4e0446,0x11b8f8af,
0x03bef53a,0xfecb09b7,0x0a50067e,0x1123f863,0xe7321326,0x2132ef50,0x032c0bb4,0xee951ed8,
0x14d4f38d,0x0d0be703,0xeac40ffb,0x044f04d0,0x0e0c0acc,0xff26fba8,0xf4f50349,0x1e93ee8e,
0xd6120adc,0x0f6a2389,0x2081e649,0xd357f32c,0x064c1168,0x01eb0270,0xdfc1110c,0x0dccf83c,
0x0ef3f17c,0x2aeddad4,0xca03f702,0x0eca2028,0xf298f5cf,0xfde8f565,0x1f61ebcc,0xf2f7e83d,
0xd18a1c05,0x0a410b9e,0xee53e134,0x13f412c5,0x34a4e0b3,0xc79e042a,0x00c625f2,0x269fe455,
0xe9e81815,0x24a7f7f3,0xd8d3216d,0x00ac170e,0x2ed1db37,0x031b0256,0x06f1127f,0xedf001be,
0xfbe72116,0x29ffedff,0xed76034e,0x0da010ed,0x076ef16a,0x020810a1,0xf866030a,0x03880053,
0xdfd80259,0xf7aa0e8a,0x0bb0f1a2,0xfcf0ec01,0x09010085,0x00a7cf1b,0xe6a31df0,0xdbbcf1c8,
0xee7b24d9,0x2cade1d6,0xe6d3e15d,0x1a200786,0xda33ee83,0x0cd8131d,0x16b8e108,0xfe7c1dc7,
0xe8051054,0xee200777,0x3866fa55,0x1636e979,0xebcb1004,0x10960a9f,0xf790eeae,0xf9681487,
0xfb6e1057,0x21eb0c09,0x04dce624,0x087e0dee,0x0426feb2,0xf7fe1efd,0xf5200a71,0x0d05040c,
0x35aee70d,0xe2c203bb,0x004d1bd0,0x0a9dfc38,0xcefefd3d,0x25fc0c95,0x06e1f977,0xe45813c8,
0xfadcf1b0,0xe9edf34d,0x14f9ff7f,0xf5e1f569,0xedfd26ad,0x1020d353,0xfab6f205,0xf4e80cae,
0xf3fa05d7,0x1e98e1a9,0xeaca0d26,0x0675f416,0xfc0cf0f1,0xe6f61f03,0x10a5f5cf,0x143ed8fe,
0x0cf4ffdf,0xe12e057f,0xf8cc1d6f,0xf66cef5b,0x0189087b,0x34f2f136,0x0277f95c,0xeea2209a,
0x0969f840,0x0c9d15b9,0x0031025d,0x0748165d,0x264400fa,0x06c0f5a5,0xdf5a0ae8,0x2a4b1254,
0xddce04c6,0x22232278,0x0d94e2f1,0xfe5a0e76,0xeb92f612,0xe6e31e33,0x3555e8c8,0xe9ace638,
0xf1a0135c,0xfb2afc04,0xf80ff661,0xe8c603be,0x06fdf20e,0xf8bee2b8,0xd02c241e,0x21eb0c97,
0xe8d0c34d,0xf7ed1387,0x18e5e718,0xeef4efab,0x0d7919d8,0xd40f149e,0x2021fadc,0xf8c1d8ee,
0xf07b3775,0x2cb7f77d,0x2113eb5c,0xe7c0fed6,0xee65170b,0xfe19191b,0xfae111a1,0x30ffe37f,
0x00dcf5a5,0xe2b21d8f,0x0627eca4,0x0ac3070a,0xfeb81326,0xedd1e8a0,0x016a2085,0x27c5093b,
0xf740dde6,0x09f11221,0xf259f7fa,0x10f70b42,0xe7a10d6e,0x082a2c90,0x0ccdcedb,0xecfef6e2,
0x0e410e48,0x0a84f4ec,0xec7112f5,0xfe04ffb6,0x04c6ce12,0xeb6b0d90,0xfb5d29de,0x120af2f4,
0x0418cd00,0xe3f526d7,0x0fbaf781,0xfc4bf9a9,0xe0a115cc,0x2044e77f,0x1361e036,0xcf2e212d,
0x1cc213a7,0x0a12d1fb,0xe31e09ea,0x03be213f,0x1e80f19e,0xff6a04c1,0xfae8ef58,0x00bdeff0,
0x11880cf4,0xf2881261,0xfecd1b5a,0x161ff546,0xf2d00637,0x0e32fba3,0x188df843,0xe45d1ac7,
0x04bff456,0xe9ad0c60,0x00b90145,0x0612f1c1,0x0085ecbf,0xf7460370,0xdf671168,0x0acf0061,
0x0cc0f266,0xfad0d5b8,0xe94e397e,0x0db2e78d,0x09a0ee58,0xf1912163,0xff780369,0x04e0f592,
0x05ea0ae8,0x03f21028,0x2a27f797,0xe28c11a3,0xfdea1210,0x0e45ea84,0x0d150d4d,0x068809e0,
0xf9a3086c,0x05b7eb09,0xf65cf669,0xf3350cc6,0x2806f889,0xca8607d2,0x0a89fdc0,0xfc61fea9,
0x0f76f382,0xeba2f015,0x1c810ad2,0xdda6f9e4,0xf4650539,0x0f07f9ee,0x0bce084a,0xeb93e5bd,
0xf5450396,0x1dd60a5c,0xf3c0f305,0xd848210a,0x1d6afcbf,0xf5d1d806,0x04940c8c,0x0fe8fa64,
0xf682ff55,0xdc890287,0xfd371cfa,0x10aee511,0x0b980d6c,0x109b0330,0x01b00334,0xef2df6c8,
0x143f2641,0x1823f2dd,0x006bfa1f,0xf4612ac7,0x05c70cb7,0x18c2ec24,0x2c32ffb5,0xdb8e0fc6,
0xf72a14f8,0x0e7efe93,0x02ea0a7c,0x0ad6f3b5,0xea47121a,0xf4c6f2bc,0x0d90e6b8,0xfd980c9d,
0x04dfee62,0xccfb0287,0x11010caa,0x0535cbb3,0xdd81101d,0x2cad0dc3,0xdc78e112,0xd51a0b2e,
0x28d8ea98,0xe3c40327,0xff0304d2,0xecdef837,0x09edfcd4,0x019bf4a1,0xfad810fc,0x1175f386,
0xf1a20c82,0x0faf1236,0x0ffdee43,0x13f8f965,0xfba91d2c,0xf19b0f50,0x22f0f33f,0x006b0ccd,
0x0a480f94,0x0632004f,0x0fed0f33,0xf01ff3fb,0x1b050971,0x0a24fc09,0xe3b922f0,0x00f1fb5d,
0x15b9e120,0xee7607fd,0x097f07d1,0xf2e90e33,0x0945f025,0x00fdea77,0x07741b42,0x0d01d0de,
0xc2fb3afd,0x3592e28c,0xed2fe633,0xf838fd2d,0x023a0700,0xf60bfff4,0xe7a8f22f,0x1563ec90,
0x05cbf7c6,0xeca702c9,0xe6180762,0x12e0fb2d,0xff47eedc,0xf8d60843,0x18e90333,0x0610ea10,
0xcb0617ea,0x354602ba,0xf2a1f181,0x103b2305,0xf612f36d,0x02c20e5f,0x268ef0df,0xf9270cc9,
0xf142250a,0x11e9fc0b,0x0c64036c,0xf5f0128d,0x1b57f651,0x08b6ff59,0xe5721e83,0x08490513,
0x0f03e115,0xe41111d1,0x14331b30,0x1240cb2e,0xceb7fd1b,0x07ac1071,0x12bcfd17,0xe8e1e73e,
0xe4430791,0x1aebf069,0xe1e6f022,0xfb7a1a06,0x1adef37d,0xf1cadef3,0xf132077d,0xf1df0f0b,
0x12be05b4,0x09c5fa54,0xf819f641,0x13cbe30c,0xe97c1bb7,0x056f12ed,0x017bf0cf,0xffc10d5c,
0xf40ff49d,0xf82c1bea,0x238c002a,0x10d0f743,0xe31fe7a8,0x0971227e,0x002f1576,0x08e40ef8,
0x1475dece,0xf8c40898,0x001efe69,0x002a1c4e,0x059df8d5,0xf234f7dd,0xffa2fc80,0x0b45ff6c,
0xfaecfbca,0xf0b903ab,0x127af524,0xe960f6e5,0xf14c086d,0x11e901f9,0x00b1e7c0,0xe5860bb8,
0x0ee3fed6,0x018cedbd,0xf22407cd,0x02f70f48,0x1257d76a,0xda5413e2,0x0b490453,0x0c66f622,
0xf950f6a5,0xf802013b,0x0159ff48,0xf9fefcf3,0x0248fede,0x082806dc,0xf618f20e,0x053601af,
0xfeac0e3e,0x04fe1312,0x2781f599,0xde7009ca,0x047f1454,0x32ab02b6,0xe903feef,0x18ea1875,
0x0440ed45,0xf0b01a8b,0x13b70e88,0x1282ef55,0xfaddf777,0xe89c05ab,0x02b309f6,0x0108f155,
0xecc4fd44,0x10090978,0xe812d022,0xea5b1ebb,0x1482ed4d,0xf6f8eaaf,0xec6bf202,0xeb6925ec,
0x052fe24f,0x06dbef79,0x000bf7a1,0xef01fd53,0xff6ff440,0xe9a40a64,0x0cd2f786,0x0463fd24,
0xfd53ef8a,0xe27a1d91,0x2794f82e,0x04100356,0xfa680055,0x05e904db,0x0e8d09fb,0xf3c70d84,
0x0fb00d90,0x277b0d39,0x0028f37f,0xe36904c6,0x24482342,0x1035f576,0xefd00e96,0x01c70ea8,
0x1906f3c5,0xfd46fe74,0x00c6067e,0xfb970250,0xf4d702b6,0xf2790a9f,0x1537f2b6,0xec75f497,
0x00ffffcf,0xfbe0fa77,0xf39afca7,0xf7bc0a43,0x0367f09e,0xecd7e3b5,0xf16dff06,0x07b8ffce,
0xf939e20e,0xefc1fd62,0xe908078d,0x05f4ea78,0xfb14eab3,0xf6b40ea8,0x0bd8f355,0xf0fff5cd,
0xf5fd10fa,0x00eff8f1,0x1bf2f884,0xec7105dd,0xf08123da,0x398efb15,0x0044f453,0xef85158f,
0x12af1254,0x1c5c0f12,0x011b0927,0x13a20efe,0x0d6ffcfb,0xed5b071f,0x1af1172e,0x053dfffd,
0x0828fb02,0xf5e10a73,0x05b80ee6,0x0203fcef,0xfdefe398,0xffc911fb,0x0a3af889,0xee5d068b,
0xf81e00fe,0xf46bde19,0x0ce5f971,0xf2e204a3,0xf13ff5bc,0xf425eba2,0xed8d08e7,0x08c4ea7f,
0xf8abe2f3,0xe71813c8,0x02b3fe95,0x02aaecdf,0xefa5f6bf,0xfa020ab3,0xf3f6fb30,0x11a0f13b,
0xfd4a0691,0x03b2fd17,0x02e5fd75,0xdfdc0762,0x15400d78,0x3034e7b1,0xe72e177b,0xffa413f8,
0x1210f647,0x05d80d4d,0x091bfc69,0x0e991c81,0xfe1e0157,0xfcc90ed0,0x1d83f9c1,0x04cb05fc,
0xee5305b8,0x0fd504f6,0x16ca0a2c,0xef32f375,0xf9a90542,0xed110c3d,0x0621f0f5,0x0d30fb89,
0xf9f1ec5b,0xf422fb5b,0xd92f0a30,0x0fb3fba3,0xf4e5e2cb,0xfea1097f,0xfcaff532,0x01b500d4,
0xf3d7e708,0xe28a0ebf,0x1130fcb3,0x1165f15c,0xdc23134e,0x1104044d,0x1976de4a,0xe0f0064e,
0xfbaa231d,0x2439e552,0xe92b0c82,0x07a3fdc9,0x0f41ffd6,0xf63dfa44,0xf4effaba,0x06141f60,
0x1405ea42,0xf04dfe6c,0xf71b15ca,0x0e74f7ca,0xfdddf707,0x0adf0a49,0xfe930701,0xfe1d0025,
0xf4ef0a0e,0x0c52f665,0x04bcfae9,0xf54f0fe4,0x03e50d2e,0x0d16ecd4,0xf596fdce,0xf69e0634,
0xfd37f77d,0x03e3117a,0xfc60f148,0x088bfd05,0xf3a3eb41,0xf0e617a4,0xf51908d5,0x23a6f358,
0xeec3ed9f,0xf8251a83,0x1079e84b,0xef860aae,0xfd3d0b30,0x11d8ea42,0x0051fec5,0xf4cf1260,
0xf770054e,0x16a5e848,0xefeaf6aa,0xf7d81e71,0x1c07fd65,0xfa9ef5cd,0xf7e407df,0x0710f4e0,
0xfec3084d,0xfe301518,0x14ffee9e,0xe7e60348,0xfef5f3ea,0x0646fdd3,0x05d11411,0xf1f0ee6b,
0xeecefec1,0x0f7601c2,0xfc69053e,0xffe8f6c7,0xed03fdd6,0x06aaf0b4,0xf3970c95,0x14f70363,
0xede9e937,0xf7f60cbb,0x06f7f72e,0x148b035e,0xf41c0a2c,0xf939126f,0x0ff0ed1a,0x08d5fe37,
0xf5051074,0x1030057f,0xfcd9f4cf,0xf9e60a7b,0xff3ffad7,0x1dc30a8c,0xe6f4ec64,0x04a324e3,
0x0e3df21b,0xfca8f3c7,0xe9fe1d40,0x21d40274,0x0072eb28,0xf74202ad,0x098c0f4c,0xf891033c,
0xfc4bfcaf,0x038dfc8f,0x0779f2c6,0xf460ff59,0xe4560664,0x16db0fb5,0x112ed563,0xdfe70de1,
0xfbc504dc,0x132efd38,0xf355051d,0x0a48fa3f,0xf853ef0f,0xf70a0a76,0x02170a09,0x13080300,
0xf5bcf4d0,0xf66f0545,0x024401da,0x0e73f315,0xf30d0334,0xfa0e02f3,0x0310e954,0xf7da0edb,
0xf97f0eaa,0x170cf3ca,0xff79f11d,0xf5c2190e,0x075b0401,0x1766fa27,0xeef118c2,0x178d00f5,
0xff91f5cb,0x066a1289,0xfd0a025b,0x18e707f9,0xe58ef465,0xf659095b,0x15220375,0x12c4f33f,
0xf408fb40,0xee881238,0x0558f2c4,0xff3d052e,0x14300589,0x08c3ee69,0xd7f90a47,0x0fa20f84,
0x0847eb9d,0x02d20cfd,0xfd0ef437,0xf224fc44,0xff4afdf7,0x04db0f43,0xfa9cfc06,0x0d63eb7d,
0xe17203d7,0xfb020822,0x1f7df08e,0xf4c60517,0xe1890176,0x14cbfa70,0xfa310136,0x13b80c4a,
0xfff2f95c,0xfba30a00,0xf466f1a7,0x02ad1753,0x164800c2,0xfddaea12,0xeb430caf,0x15ac1801,
0xfa8eeb6d,0x020e081e,0x0872fbd5,0xfc15ff3d,0xf498ff14,0x0e911610,0x08dfe0c2,0xeead1689,
0x0928021b,0x0c13fe50,0x02b005e2,0xfcea02f3,0x0e601213,0xf657ef86,0xfb400a50,0x0c2e0d90,
0x0da0e988,0xf20b097f,0x02bf1130,0xf9eef243,0x01f5fd74,0x08f204cf,0xf99dfd1f,0x0a1c09a2,
0xe5dbf7a1,0x0a92f878,0x0f07fd56,0xf2b30e9a,0xfa48086e,0x0726e908,0x0d5c00b4,0xdef81603,
0x101a02de,0x061ee9ca,0xea27fa99,0x19230fb3,0xfe73fa0c,0xe4bf0cc7,0xfe17ede0,0x180900a2,
0xfc24f43d,0xef6017bf,0xfe04f7f6,0xfbd5f437,0x0c4fefe9,0xebe40ec3,0x0a8a0b9e,0xf6d7f368,
0x0b33febe,0x0bd7eeae,0xed4c0a03,0x03be1c9b,0x05fff90f,0x07acf711,0x126b0d49,0xf460eef7,
0xfbf71f81,0x05e9fd01,0x121cfa6d,0x061e04ec,0xeed60dda,0x0eeb0e22,0x0e8feb6d,0xfb4c071c,
0xf61609de,0x1b320294,0xfe8f06f8,0xf736ff3a,0xf6e5fd68,0x0fc6f487,0xf8f61c02,0xfe67f49d,
0x0ddcf53a,0xea53fa12,0xf65101f3,0x18e00b9b,0xe98cf76b,0xfdb5fa72,0x0202ed36,0x0348fe7a,
0xe09dfd7a,0xfdf1149e,0x0f6fe569,0xf270e69a,0x01292435,0x01e7f045,0xe844f40d,0x0a950274,
0x07b5ff07,0xec4affac,0x1753fd6c,0xf69afdb5,0xf0d903dc,0x13a6f902,0xf6161100,0x0f47f0c3,
0xfd90097f,0xfc130386,0x1164031b,0x0927fe93,0xfefd22dd,0x06190173,0x219ce703,0xe3cc217d,
0x0d520a48,0x1020f8ba,0x00330f08,0xfcc1f976,0xfef20ece,0x15fef7e1,0xdb200551,0x1ee20250,
0x003ff4f8,0xe63df9cd,0x0672198c,0x1006ef26,0xf15cf201,0xee91035a,0x0576023c,0x02a5f119,
0xefc20c9e,0x0939ec78,0xecd5f758,0xf889fd4c,0x046611ba,0xff2de298,0xe430f396,0xfce7fc56,
0x00970070,0x014cee2a,0xe7ec0bf0,0x0850f1dd,0x08c6fc90,0xfdf70a7e,0x0021f92d,0x0f47032a,
0xf59f0d83,0x10dffcc4,0x04d80f80,0x16b80a67,0xf473ff57,0x0809048d,0x0f1409a5,0xf4d00ed9,
0x1204fd42,0x0a9bf91b,0xe62c0b8d,0x19ab0675,0xff72fe26,0xfe51fe06,0xf36d04e0,0x212c0037,
0xe128fb61,0x0df4106d,0x0b1aeb1a,0xee5f0288,0xfc060f0b,0x08d6eb79,0xed890363,0x08c9ee4a,
0xf3340b39,0xfc96fe51,0xf0bfeae1,0x0c760fe8,0x0126f0cd,0xedd3f307,0xfcd00e7f,0x054ffbee,
0x01c2f6ad,0xfcd70b21,0xfdf803a9,0x02bfefdb,0x00ef08a6,0x047808f1,0x0728f424,0xf33c0411,
0xf43404c2,0x0c7e01b8,0x09feebdf,0xf3840e34,0xf78eff53,0x1c84f5ec,0xe607121c,0x155affef,
0x0069f231,0xfcdf07e4,0xfd4e10c8,0x1a65ff97,0xfd8bffa3,0xf7faf90a,0x034c132d,0x1541002a,
0xe9a0fde2,0x099a0d20,0xf9a8e449,0xf5b30a28,0xfa96fbed,0x082af0cf,0xedacf71d,0xf95c0987,
0xf62d07d4,0x0c2ae573,0xf4ecf838,0x01f30b37,0xfd9bf9ef,0xf96c0eb4,0x07edf208,0xffa90b92,
0x1006f5a1,0xf24702bd,0xf844113c,0x13dafaaf,0xfefbfd3c,0x00110a9f,0x0b33f2fc,0xf05810aa,
0x124e0eb9,0x0869f3d1,0xf657feca,0xf43f06cb,0x0c9bf66d,0x0aee0557,0xe512f767,0x081bfbbc,
0xfbf003e5,0xf017f9bd,0x091ef17a,0xfcbcf962,0xe98f1318,0x0669eb2b,0x040c04d0,0xf7fef42a,
0xf3c5fe83,0x08500028,0xf0fef9d4,0x0ccc0751,0xf50dfb78,0x04db0237,0xfb0df118,0x0afa1a1c,
0xfffaf5b2,0xffccfe00,0xfff4065c,0xf971040c,0x09adf295,0xfde80f6b,0x00e2f890,0xfd9e03c9,
0x07fb02ee,0xf6a10bf7,0x0ee3ef28,0x040c061b,0xfaec12e3,0x1467fa9f,0xfcbd010a,0x01b00dd5,
0x1175f8f5,0xe7c21514,0x14edee15,0xf36a0082,0x195e0b70,0xdc5df287,0x0c541069,0x0be4f059,
0xe9e5fe63,0x085f04e4,0xf79deff9,0xef30fafb,0xfa1604f6,0xfd3ded08,0xf58af34b,0xf161fe4b,
0xfd12ffb5,0xf4c0edcf,0x0497f53a,0xfa2900f3,0xf3680565,0x080afa3c,0xf3b9f79f,0x07510bed,
0x078cf6c8,0xf8fa0796,0xfa32ff91,0x0e81fd59,0x14000075,0xeba71535,0x03a303c7,0x10e1f5ee,
0x073503a8,0x01f60f14,0x081c0011,0xfaa10370,0xfd030b5e,0x1d310443,0xf3da00aa,0x04590410,
0x0ae90011,0xf2a111fe,0x16bde6bf,0xee061499,0x0f41003d,0xea08f8cc,0x13e7ff84,0x03d7f940,
0xe2190714,0x0424fc89,0x0547ffba,0xfe97e7e6,0xedcdfd57,0xfeae16a3,0xf62be88d,0xff63f693,
0x0406f7f9,0xecc7f492,0xffe10fcb,0xf86af76f,0x01d6e97d,0xf915fcd4,0xfacb0529,0x0037fdae,
0x01d0f5fb,0xf36c0a53,0x0ce9fa51,0x0903f650,0xfc5e1992,0xfa790056,0x11d1fc58,0x0533fbf8,
0xfb511687,0x10891002,0x02a2f333,0xfc8c0fa6,0x24120147,0xef3c06fd,0x0437061e,0xf4ca0120,
0x17e504d2,0xf71bed2c,0x00e80f06,0xfbd3ff18,0xfaf0fccf,0xfe4df4e3,0x090a0110,0xef640cc0,
0x06d3fb63,0x02e2f64e,0xfa12f78a,0xff130183,0xf84f15d5,0x054bf5f3,0x0894f191,0xf142053b,
0x04210472,0x04aff907,0xf2cf0eef,0x04bdeeab,0xfbe3fef9,0x0216fb1a,0xf16f0965,0x0157f988,
0x0814e9c1,0xe64819cd,0x1763e7ee,0xf05d0242,0xf44111e4,0x0638e134,0xff6308ec,0x0b960de6,
0x052dfb4c,0xfb7d077d,0xfaf2f61b,0xfc85134e,0x2212f812,0xe8e7045d,0x0459f62f,0xf571ffdf,
0x12a40f60,0xf2e8ee4f,0x10ba1046,0xf518f904,0xfc1d0147,0x095efb8d,0x0375062d,0xe8b6f2e9,
0x13fd0340,0xf078043c,0xfeca0370,0x009af1c8,0x09b20872,0xf6c6f170,0xef800288,0x137b06e5,
0x0caa0433,0xf51cfa92,0xfa8e0b6f,0x10e2f47c,0x07381159,0x063003ea,0xf1be0539,0x09bbeeef,
0xfd9916c1,0xfc00f260,0x11f7ff02,0xf1d01157,0xfcd2f00b,0x02da05f5,0xfc9df2bb,0xfe7909a8,
0x01abfaff,0xf4abf8c1,0xf9dbfc9e,0xff0c0050,0x0248f1b9,0xeff5f9c8,0xff4b0384,0xfd69fd2e,
0x0566febd,0xf86c0421,0x0a98f737,0xe3dfee9e,0x07a20850,0x05ed0ae5,0xfa35f0ba,0xef16f1f9,
0xfd290cba,0x09e5f3f4,0x089e033b,0xee9efe70,0x0cc00e6d,0xf66de9ae,0x025d1603,0x1980f398,
0xf4410847,0x08991502,0xfa52f61b,0x11c70101,0x037418bb,0xfff4f8a4,0x049cffd5,0x10e90761,
0xf9c4202a,0x11b6e5d6,0xfdf21400,0x0584f635,0xfa3b0d93,0x0d0a1133,0xfcdcedb9,0xfc29fd94,
0xf277f31c,0x099011e8,0xf1e7efe0,0x01a4fdea,0xfaaffe22,0xef9dee72,0xfdc3fafa,0xf153016f,
0x04cfe620,0xf6000c56,0xea14f7dd,0xf564e5a4,0x08d3fdc9,0xfb0201df,0xf5cef270,0xf8fd0332,
0x0081fc4b,0xff68f939,0xfa26faba,0x049103b2,0xffab03ff,0x01f0fe81,0x0f3c0dfd,0xfcf9f50a,
0x031311d1,0x011905f4,0x129202e8,0x0dff0ac0,0xfe7f0511,0x086c0b39,0x01c60207,0x05200465,
0x106319a7,0x1423ef95,0xe6f1189c,0x117eef22,0xfd7c0b81,0x12930a05,0xf7db05aa,0xfad0fccd,
0x06baed92,0xf0b91321,0x0b32f28d,0xf9f7066d,0xf389f489,0x05d0fcd7,0xf3b500ce,0xfad1f456,
0xf42afed7,0xfecbf7c8,0xfb84ecd2,0xf1d504b1,0xff03fbf0,0xee4dec4d,0xefbef4ef,0x0bad05dc,
0xf929f9db,0xfe4cf1fd,0xf10dfc90,0x01920bdb,0x096ded9a,0x00971321,0x02cc0343,0x095ffc1c,
0x023a04aa,0xf750fdef,0x0a8c048b,0x083d0f24,0xfc8cf8a3,0x03dcff91,0x08580a71,0x00acff99,
0xfcfe09ea,0x168c0a3e,0xf81efadf,0x0910045d,0x033c0d61,0x070707b9,0xf862f364,0x13c61515,
0xff97eca3,0xf0f422d9,0x1873ee55,0xec36fce0,0x0dce02a9,0xfcf806e7,0xf43bf750,0xfe8401bd,
0xf9a9f276,0x01c6faac,0xf202f69c,0xfc7d0dd5,0x00a2f40f,0xfa4bef77,0xef2df943,0x01b50669,
0x038afacc,0xf779049f,0x0577f3bb,0xf7f100dc,0x03d6ff03,0x02eb0a17,0x0227f7fa,0xf84a0610,
0x021bfd00,0x05fcfd7e,0xfe650b64,0xfe2bf037,0x05470cfc,0x07cbff84,0xf5d102c8,0x05890317,
0xf82bf5b7,0xff430c87,0x0c42eb39,0xf85a09a9,0xf66f0a88,0x060901c5,0x07c7e5f9,0xf7d215e8,
0x0a0502eb,0x020708df,0x0606f477,0xefa100ea,0x13f90aa1,0x03cf08fe,0xfd42f38d,0xfcd70edd,
0x09fefdce,0xfe560033,0x082ef8d6,0xf86a13a2,0x0294f030,0x02d50aee,0x050f0c5d,0xfaeef249,
0x0254f513,0xfd4c1268,0x068afce9,0xfc24f6d3,0xf8ec06f7,0xed57f6ce,0x1820fb6a,0xed31f4e3,
0xfa230478,0x0952035a,0xf85dfa09,0xf2a6f496,0x08de09ac,0x0866fcfc,0xe7befe45,0x0f6ff2a3,
0xfa8707d6,0xfb15019d,0xfbb9eedb,0x01a10fcc,0x061ef736,0xfb0b0698,0x0957f6e3,0xec9effd6,
0x06b9fcc7,0xfde8fb3c,0xf01efe73,0x0a530638,0x025bedcb,0xf5bc041a,0x056b08ee,0xfe69fee3,
0x0584f775,0x032211e8,0x05b8fd24,0xfb320541,0x0c8bf519,0x024f15fe,0x09da021e,0x01a10bbc,
0x0d6bfa79,0xf7b805f5,0x0e8e117a,0xf9a4f339,0x11f1093b,0xf0a3fd18,0x06be037f,0xfff4017a,
0x0530fcf4,0xf1d405da,0x07bcfc66,0xfc3cef2b,0x04771545,0xf513f09e,0xf1470026,0x0f80fed1,
0x03160075,0xf838f9bf,0x0041003c,0xee9df8af,0xfe65ff7d,0x07b5fb4f,0xf5befb75,0xf340f720,
0x0a49f950,0xf3480491,0xfe01ff95,0x038ff997,0xf5d4fa1d,0x014efe6c,0x052007bc,0x00bb010f,
0xf5aaeb91,0x07d614f5,0x03d807a3,0x0368f43f,0x07da050a,0xfde10f7f,0xfbe4f6d3,0x0f3a0d39,
0x0ea2fc7c,0xf15107d0,0x0e3302b5,0xfbce08e5,0x05fdfda2,0x0776017c,0x04ab0cca,0xfe10f879,
0x0b0f0f90,0xf83ff451,0xfbc503f6,0x16950c28,0xee66fc86,0x0410f532,0x0b430657,0xf1ab0490,
0x014701e7,0x0a3ceca7,0xeef20d12,0x06abff74,0xfd15fa6c,0xfc88fe34,0x0777fb4f,0xf7e4fef6,
0x024f0a10,0x003c03ad,0x007af447,0xee12fbf1,0x0a07fea6,0xfcf9f302,0xeac4057e,0x04b6f7ed,
0x01410236,0xfb51f977,0xf7a6f754,0x03b2073f,0x0468faf9,0xf5ce0a17,0x0121f044,0x06de00ca,
0xfbdb09d6,0x0bf90a38,0x0871fe2a,0xfbdcff8b,0x04a30a15,0x08e7fde1,0x00d71033,0xfefaf3b0,
0x06300b89,0x030904e0,0x0399fd8f,0x0349009f,0xf3ea0282,0x1494fe43,0xfd560f6f,0xff6b02d1,
0xfb2af915,0x1eda068b,0xf410fd56,0xf1f908f2,0x209a0b01,0xf7b00627,0xf9bbf136,0x07ba05eb,
0x046908d9,0xfa0efc2e,0x0a520b0a,0xef39ee6f,0xfeb10046,0x0dbe09c8,0xf25701c0,0x09bef19e,
0xfb2ffe63,0xf7810dfc,0x0685f19e,0xfd9401dd,0xf1dafdfe,0xf87bef8a,0x0e34ff75,0xf1a705e6,
0xef9cf31e,0x02aaf3e1,0xf6ea03e9,0x04e0f571,0xf3f10655,0xfffeefa6,0xfa12fa1d,0xfe48fe82,
0xfd0209e6,0x0a91f43e,0x00f110e9,0xfaf5f469,0x04c607f3,0x18b20a88,0xf6630158,0x0b1b10f6,
0x00bff8c6,0x13f71789,0xf9cef3e3,0x017b0ebf,0x11e107e8,0x00c8fd53,0x00e20647,0xfff00542,
0x0c3d082b,0xff750285,0xfe58002a,0x132d0297,0xf9060336,0x036d0c78,0x0509fa1f,0xfc1f0096,
0xfc9e0334,0x09fa036a,0xfa31f4aa,0x061007c3,0xed85f7eb,0xfcdcfa4a,0x105a08f2,0xed35f355,
0xfaecf5d4,0xf52afda9,0xf2faf220,0x0230f2e0,0xebe60659,0xfa1ee8c6,0xf1d4f75a,0x0375f53b,
0xe77d0341,0x0b2defec,0xf8f90434,0xf98efb21,0x078df53d,0x0ada0dec,0xec2b0924,0x101dfa32,
0x131b0572,0xfef5118f,0x0d16fe6e,0x0e4718f9,0xf947fe63,0x106a04d2,0x07f61817,0x1beeff79,
0xf9b60505,0xfeed0fea,0x0349ff18,0x199b03d3,0x00910f07,0x000b08b1,0xff55f04c,0x06ec11e1,
0x0171fd7b,0x0155ffa1,0x0104008e,0xf7ce04d8,0x0384f250,0x04e30cd3,0xec68f206,0xf7f6f3c8,
0xf4adf545,0xfcebff48,0x06b6f6f2,0xe130fad8,0xfd92f5da,0x0847f87d,0xf228fd92,0x0688ff63,
0xed26f99c,0xfedafd4c,0xf6aef2c9,0x01f30333,0x0d5ffb4f,0xf69c055c,0xf5f900da,0x0858044d,
0x0cd9f701,0xf707ff78,0x02720bdf,0x0758084b,0xffc3f86f,0x02cc04ec,0x0c54fd65,0x01540fe3,
0xff170634,0x109f0547,0x05d0033e,0x0b0a055a,0xfb0f0831,0xfcabfc2e,0x0f100a73,0x04f70a7e,
0xfa38f7fa,0xfb18042a,0x07fefba7,0xf5e4f932,0x06d50691,0x01290cc6,0xf6d3eaee,0xf86f0106,
0x05a702d0,0x064cf8c4,0xfe2301ab,0xf8ae0b08,0xfe97fc89,0x091bf1c6,0xf96c0c16,0xf8bdfc48,
0x0db8f76c,0xf6c90d9f,0xf6e3f26f,0x0627fb5e,0x04b3082c,0xf019fee9,0x02eef651,0x02b305d1,
0xffd6f4d2,0xf48e02e2,0x04f20005,0xf46af8c1,0x151a059d,0xf73008c4,0x0939ff56,0xf178f2f5,
0x01d106fe,0x0c4f0872,0x0182f7d3,0xf1dd0acb,0xf982f02f,0x05a3fe6b,0x0426038c,0xf787fdd3,
0x038001c2,0xff4a00ac,0x0364fa9e,0xf1cdff7e,0x0e130990,0x033bfa88,0xff460045,0xfbbb01c6,
0xfceb0090,0xffaaffe6,0x0409fb92,0xfd1802c8,0x035aff10,0x0015fcaa,0x04c80f86,0x0328f8f1,
0x03f50e8d,0x0576f8ca,0x0a430ffd,0x09f70991,0xf487f765,0x04d8054f,0x1390058f,0xff1f0f95,
0x00b6f957,0xff0807fe,0x0be8fed4,0xe9a2f334,0x0a4d1162,0xf72ef03c,0xfa9efa3c,0xf0fef6e5,
0xf994ff23,0xf803eec3,0x081e02a9,0xf0ecfcb2,0xfbe0f075,0x047b0733,0xf157fa97,0xfd1bf75e,
0x132b08b6,0xedc1f69b,0xfdc6ffd8,0x0300fbcf,0xfd8b0693,0xecdee9a1,0x10440b1d,0xf31afc6a,
0x08cf0002,0xfb30f68f,0xfbf11312,0x020ee33a,0x04fe1acf,0x0b08fc80,0xf9a903ee,0x12a1063d,
0xfe500134,0x00bf0675,0x15f41858,0x096efd01,0xfd820014,0x01ff0848,0x12d3165a,0x0593f9bd,
0x00bc0807,0x0b1a06af,0xfdd3ff26,0xfea609d4,0x016607d2,0x0831ea36,0xf4ad09ca,0xfd38fc86,
0x043a0228,0xf82efb72,0xf851f6de,0xf752f4d2,0xf95c0249,0xfee0f5b6,0xee6df9db,0xffe4ee98,
0xef68f8ef,0xf3fafa41,0xfbb6f9b0,0xfb4cf3e1,0xfb40f7f4,0xec77f6ea,0x083801cb,0xf3a0f33d,
0xff5303a9,0x031ff3fa,0xf5500b55,0x0418f408,0x08721090,0x0971f481,0xf7e40a0d,0x140009ed,
0xff9e0f72,0x0c1708c9,0x18fb022b,0xf42a0759,0x0c4a08d6,0x0a911156,0xfdba01e8,0x0868f831,
0x089e1531,0xf770f1ab,0x01500789,0x0cba076f,0xfa820145,0x0573f61c,0xfa070bd6,0x0205fdef,
0x03dcfbc1,0x043d0118,0xf39808d6,0x094ef3d3,0x00b20452,0xf6be0345,0xfe38f08a,0xfd7e0a13,
0xec91f566,0x02d9eb2c,0xfbe802f7,0xe2a5ed8c,0xf640fd9d,0x0a3eef0a,0xec8efc3f,0xf88bf88d,
0xfc06f550,0xfb9ef86f,0xf97e04c6,0x135800c8,0xfb08ff34,0xf9fc04e0,0x0a97082e,0x071df558,
0xfbb00e34,0x0b0f01f9,0x05b202b2,0xfad0072a,0x0fbc0f8d,0x0b5ef57d,0xf7e1083a,0x055d0e6c,
0x129a024d,0x07480211,0xf65b08f5,0x0d7509be,0x0af804e5,0x00480122,0x0881093b,0xfc06f7e8,
0xf5ed085c,0x08e4ff4d,0xf621f895,0x0b0dfc76,0xf1fafeca,0xf1a90179,0x0476f05f,0xf7a8feb1,
0xf5cbf3e4,0xff97fb36,0xfb020240,0xf11df43d,0x03b5fe5f,0x09bef6f3,0xf2360c80,0x0976f65a,
0xfdd0074b,0x00500726,0x0587f363,0xff8207cd,0xf40fff02,0x0b65fdd3,0x0265028e,0xf1acfa4d,
0xff7b01c0,0x0b36079f,0xfe27f7d8,0x0b2e052d,0xfda206d2,0xef86fcb3,0x0c17fed4,0x046006d7,
0xfd2df2e2,0xfa160263,0x069d0c54,0xfccbf883,0xfc4bf727,0x02e90a50,0xf96ef600,0xfeb2025b,
0xff0afcb1,0xfc2200a8,0x0a1ef8f5,0xfcc309f0,0xf56b0062,0x0ebaf875,0x05200a79,0xf5eb0199,
0x0838ff05,0x02bf0580,0x0fcc04cb,0xfada0135,0x02800a8e,0x01ff02fb,0x049300b2,0x094bfbfd,
0xfb110ad5,0xff0e0186,0xffd6fb75,0xff4bfda6,0x05a90b0c,0x0491f91b,0xf8bd0199,0x00ef05f8,
0x0ab5ffb3,0xfa53fdd2,0xfe1cfd61,0xfcb3030f,0x000ff780,0xf52f02ba,0xff6cf601,0xff08fa07,
0xf78cfdbd,0xeff3f779,0x05d1fffe,0xf61bf508,0xf8d6f3da,0xf3b502f3,0x01c7f549,0xfe0af895,
0xf5b2fe7a,0x00f10827,0x05c4f126,0xf82b08e6,0x025bfa0d,0x0c43047c,0xfbd704eb,0xfdeb0572,
0x135a0263,0x03f80621,0x01f607e4,0xfda2fe61,0x13411277,0xf8effa1c,0x0e5a04a3,0x0bce0cd6,
0xfbe506b1,0x0f3a07ca,0x01840662,0x0a3b0520,0x069e0450,0x029905de,0xfb400345,0x06f10095,
0x0721052c,0xf26bfa66,0x08250307,0xf4bafcaf,0xfdc5f15f,0xf575fe26,0xfc800272,0xf72cf4a1,
0xf4c4f0f8,0xf736f421,0xeeadf83a,0xf9daf0bd,0xfbca053f,0xf2ebe9ae,0xff96fbe5,0xfe4005d1,
0xfe4af878,0xf86c02fb,0x021eed65,0xf9500ade,0x0c0c0316,0xfc3ffd98,0xffc501db,0x0863040e,
0x09740910,0x0679fea8,0xf9da0f1a,0x0936fd5c,0x0ae107c3,0x01d9fef1,0x0bee0f76,0x07dc0d9d,
0x0928032c,0xfba7007d,0x11cc06f4,0xfdf70914,0xfcf800d5,0x0db20762,0xfd3cfc02,0xfeab007e,
0x026e0456,0xfbfdffa3,0x0306fe7c,0xf538fa9e,0x045cfa7e,0xf20ffef0,0x05930460,0xf6bdf0e5,
0x03cef8c1,0xf3a40c38,0xff17f827,0x0074f3e1,0xf4f109b9,0x076feff0,0x0034ffc6,0xf0850cb7,
0x055df3b2,0xf6b3f7d4,0xfb81f679,0xf575024f,0x0e79fe8e,0xeea4ff0e,0x02b0f687,0xfc3bfa9e,
0x01ff0d09,0xfee6f63b,0x090408bd,0x04c1fbd4,0xf1b00410,0x13f0090a,0x0c50085d,0xfa5bfb8b,
0x0caa0ea8,0xf8f601ab,0x0c970097,0xfc320345,0x0987046c,0xf61cfadc,0x06e10332,0xf9040485,
0x0361f9d2,0xfe40fbce,0xfb2f05f5,0x0254f43f,0x04590cf3,0xfa70ff5f,0x0679fa41,0xf942fb9b,
0x01af082e,0x03ad02a5,0x0b83fc24,0xf23300c2,0xfab50157,0x048af7ce,0x0323073c,0xfb91fc00,
0xfe93fc83,0xf645f7da,0x0248061d,0x02defd03,0x084402d6,0xf8c8ffda,0xf9750230,0x08e6f834,
0xfef30a69,0x01b1fc51,0x034af948,0xf1f008ad,0x0c4d0627,0x0068f5e6,0xfccbfd21,0xf72cfcfe,
0xf92d0876,0x0c46f0d7,0xf8cf07db,0xfb85fafc,0x0025ffd2,0xfaaff8cf,0x0baf0d62,0xfd7efbaf,
0x0042f74f,0xf27f0949,0x0aaefe84,0x0678f90a,0xfa350d37,0x040cf77c,0xf2560141,0x0767fc89,
0x01bc01da,0xfc3ffbee,0x03040399,0xf88b02b2,0x0a53fc82,0x03ac0222,0xfb1c04a6,0x0547ffaa,
0x0ead0dcc,0xfc480048,0x03d906af,0x0e100014,0x00e80983,0xfd4c00aa,0xff6102b6,0x0a1ffe10,
0xfbb705bc,0x0502014b,0xfc51fe55,0xfa7cfbfc,0x0a75060e,0xf65df867,0xf3d0fc99,0xf93df75a,
0x06e20079,0xf996f046,0xf7450974,0xfdeaf9d5,0xf3b9f492,0x07f9fa8a,0xfb450424,0xf2a6f3f8,
0xfe34ff78,0xfc17fbe7,0xfcdff5db,0xff08f9b6,0xf8c80449,0xf6fffe04,0x0520f6ee,0xfe0bfaba,
0xfba9055b,0x0abefbad,0xf74b0f36,0x0a44f902,0x09300370,0x038f0994,0xfb8406b9,0x120c0476,
0x02d106af,0x07f90218,0x044408cd,0x02740855,0x02c80345,0x08bafee5,0x097f0609,0x01bc0afb,
0x002008d6,0x0e3df8f1,0xf48c0609,0x0b73031e,0xfc320645,0xfd50f556,0xff74005a,0x03fc0426,
0xfbb3fbf8,0xfe930320,0xfb9c02c6,0xf9a4eb91,0xf7a8feb5,0xf807f8db,0xf053f23a,0xfeeafc8c,
0xf571f52d,0xf505fac7,0xfbeeedbd,0xf9500135,0xf275fa1f,0x0269f80c,0xff74f9f4,0xf9e6ff5d,
0xfe8f008b,0x0dfb0669,0xf5a2fb36,0x03860437,0x06c90199,0x02a502a1,0xfa4e0033,0x0f540a02,
0xfb53fb88,0x066e0f3b,0x0d30fcd4,0xfca80786,0x07260542,0x0ec707f9,0x02820aa8,0x011405ff,
0x17e106f4,0xfce408c7,0x04c6ffc3,0x09101131,0x053b058f,0x06f7f96d,0xf810030f,0x01b408c0,
0x03e9f94b,0xfe9806fa,0xf977f50a,0xf740f777,0xf69cfacb,0xfad30269,0x0215f5a9,0xf5dbf11d,
0xf5b30497,0xf87bfce2,0x0173e8c2,0xf3090535,0xf2b3f6ae,0x0916fa00,0xf3e4fbf7,0xfbc0fc20,
0xffccf9e4,0xffb0fdf0,0xf821ff8d,0x0ac607eb,0xff78f858,0xfdaa069d,0x06ccfc0f,0x03190a3b,
0x095106cb,0x00b9047e,0x08a5000c,0xfb260449,0x094b045f,0x0b460be4,0xfa3bfc0d,0x08f208ab,
0x06e4001e,0xf312fe7d,0x04b30639,0xfa82f983,0x0d7dfadc,0xf86308c3,0xfdcc038a,0xff9df51b,
0x0532fd86,0xfd240f1a,0x048efa83,0x045c01e6,0xfdd801d0,0x00450558,0x0c18f987,0xf80f0573,
0xfd420b45,0x0f8ef7be,0xfeb4023c,0xf04ffd2b,0x0cf8fe71,0xf95f069a,0xfae4fadc,0x0b7affb6,
0xf42ef7a1,0xf67f00cc,0xfef20097,0x01f9f3ad,0xf9eefab7,0xfc17067e,0x0368fd3a,0xf592fb75,
0x0228f9b2,0x03c4ff0c,0xfef0071d,0xf9d5fbcc,0x08f1019d,0xfa55fbb3,0xff9e00bc,0xfe8e05af,
0xfee7f42e,0xfd7b04aa,0xfb0bfacb,0x014bf819,0xfcb10579,0xf9a6fd6c,0x0a890830,0xff1ced9b,
0xfc620d79,0xffb604c6,0x0593f638,0x027008fb,0x06b904a8,0x02720370,0x07a3011d,0xff3c0fa7,
0x0a68fdc3,0x04a6fdfe,0x00da0e6c,0x088d0351,0x0c2e0a2a,0xff3b043a,0x06f301de,0x0222049f,
0x07590565,0xfee30a64,0x00ecf883,0xfd0cf9f8,0xf7d405b7,0x112cfe93,0xf183fe37,0xf5fbf9fb,
0x02d5f809,0xf799fd57,0xf701fb93,0xf7b9f3e7,0xf5c2f97a,0xf948ed82,0xf96707f1,0xf413f3fd,
0xfee5ec64,0xf0e50143,0xfed4fb8d,0x040cfe40,0xf736fbb0,0x0252ff07,0xfb82fa8e,0x067f0150,
0xfe95135e,0x0e62f3b2,0x01f20783,0xf8790789,0x0e730106,0x0cfd0aba,0x038c01d6,0xfa8b0f4c,
0x1321fa67,0x00a00d79,0x0b780b2a,0x0ba8ffb9,0x00f60b45,0x06b1090a,0x0bd80481,0x025d0570,
0x00c703c7,0x03860090,0x06ff031f,0xfac00675,0x034fffab,0x038ffa36,0xf1d7ff48,0x02bd0291,
0xfe10fc9f,0xfaf5f387,0xf48ef980,0xf17ffc85,0x0108f3c7,0xf3b5f5c7,0xfcba0660,0xf571e45b,
0xf4c0051c,0xf23aee06,0x03adfeda,0xf711f4ab,0xfaeefd24,0xfb24009a,0xfc20f4c9,0x00ff008e,
0x0114003a,0x081c0376,0xfde10612,0xfabbf9fe,0x0be806ad,0x04eb0223,0x02bf084a,0x0085fe7f,
0x0af20b17,0x0a4b0a93,0x053600c8,0x0154052d,0x05990aaa,0x11b209c4,0x03fa0761,0x040c0347,
0xfd0f0099,0x03d30541,0x016900da,0x06880328,0x00330288,0xf8d3f7b9,0xfb3b00b6,0x00d5fe7f,
0x0154ff5d,0xfddefafa,0xf9360608,0xfe95f675,0xf6dbf3b3,0x001e05d1,0x01a8007a,0xf86ff536,
0xfb300155,0xfffdfbe3,0x052a00f5,0xf6d2f7c1,0xfd570b98,0x03d9f59f,0x0781ffa2,0xed7305fd,
0xffa7efb7,0x00dc06ad,0x029cfea2,0x012bfe98,0x0670054f,0xf4d0fdd0,0xff70ff73,0x07abfdfe,
0x07b00a82,0xfcddfe48,0x024804a4,0xfa93f96d,0x0396037c,0x020eff7f,0xfd2402e5,0x0297fc01,
0xfa3b02f2,0x0703fe79,0xfa66fa30,0x019e0a93,0x03e2fa5b,0x00330485,0xff59006b,0xfdf8f9b2,
0x01f60594,0x02f2fae5,0x012613a7,0x09b2eea0,0xf1b80666,0x075d06ea,0x0319f940,0xfcd60520,
0x01b4f6b5,0x03970f32,0x0780feff,0xf58afd61,0x027405ab,0x0754f8a4,0x01c80728,0xf7ac0380,
0x01d2fbee,0xfe8af7cf,0x03bb03d9,0xfec20542,0x077a0294,0xf833fcb6,0xf7cbfb63,0x088af9e5,
0xf7e401ec,0xff730355,0x03befb01,0xf7dafc4b,0xfe8effa7,0x0025f9de,0xfacc03b7,0xfa19f6dd,
0x02ad014d,0xff4af947,0xf66d0489,0x08c00090,0xef0af2bf,0x056afd2b,0xfd1b05bf,0xfa5bfba8,
0xf8dff413,0x01ab0004,0xffb1033c,0x0361f91f,0xfcbc0f86,0x0576f669,0xfdb9ff46,0x07260501,
0x03d70c80,0x0d830421,0x06ea06ca,0x00580673,0x0ab30523,0x0b6b0b29,0xfb0b0513,0x07370345,
0x09cb0041,0xfdce0927,0x002fff50,0x072f0776,0x079501c6,0xfab5003f,0xff210588,0x00caf768,
0xf7bffd9e,0x02c5037a,0xfb3ef46a,0xfa4e069b,0xfc95f36a,0xfccffe29,0xf4b1f8d5,0xf45ff898,
0x0236f867,0xfaf6f96f,0xf79d0577,0xfc5ded69,0xef75fafc,0x0203fddc,0xfcf3fd97,0xfdd2f791,
0xf03cf72f,0x04bf0392,0x02e2fcf3,0xfbd8fe15,0x024007c8,0x040cfa64,0x02f70444,0x02a30341,
0x01540bb0,0x0cc4f645,0xfc0c0cde,0x06870836,0x0c3b0175,0x017002fe,0x00560767,0x07d603ca,
0x059e0310,0x03290c76,0x0c0afd59,0x081b0e95,0xf6f7fdb9,0x0d160b2d,0x092800b5,0xff360947,
0x00fafd9e,0xfd40feb4,0xfb370167,0x01f6f9d7,0xf87dfd17,0xfd5ffc8a,0xf55cf5b6,0xfda20000,
0xf4baf20d,0xfd0c005e,0xfc29f589,0xf0fbf9f8,0xfcf0f6c6,0x040e0510,0xee95efa2,0xf561f409,
0xfec60364,0x0006f976,0xffcefae3,0xf77dfe22,0xfacb0093,0x07dafa9b,0x0355046c,0x005609e4,
0x0363f934,0x088007a2,0xfeb90520,0x07210903,0x0dc2ffcf,0x008e0cd3,0x125909e5,0x049109a6,
0x019503ca,0x0026023d,0x133706bc,0xfc7a07d3,0xf9ccfb12,0x0ab30993,0x04bffa03,0xf7940c12,
0x043af40c,0xfd1702f7,0x074506b7,0xf842f8c9,0xfbaa003f,0x0294fad4,0xfd5cff0f,0x040506a1,
0xfa23f803,0xf981013b,0xfad5f43b,0xf250fa26,0x068ffa51,0xf2fcfafc,0xfd44fd56,0x003afae0,
0xf407fb6f,0x09f7fff1,0xf7b0fd0e,0x073c05f6,0x044d0129,0xf895f9fc,0x036d068f,0x003c029e,
0x076afbf1,0xf71a016a,0x063d04fe,0x023affd2,0xfa1af9b2,0xfe0a0866,0x0afbf8d6,0xfdd2091e,
0x04bcffec,0xf93e0545,0x0ab1fe84,0xf848f8c6,0x06f309bf,0x03ff04d8,0x040900bb,0xf67e00e4,
0x0536fac7,0x035c060f,0xfa85fbdb,0xfcb80320,0x0312fa4b,0xfcf0fab7,0xfcbc08ad,0xfa5bf787,
0x0465faf0,0xfe2f054e,0xfe90ff60,0xfda7f806,0xfe5d0868,0x0390f547,0x0b96111b,0x03ea0216,
0xfdc904d2,0x0ae00031,0x0001047c,0x07820fed,0xffa4f38d,0x06f8097c,0x01f60ce9,0x009af5cb,
0x0061037d,0xf45afb1d,0x0b3203a9,0xfac3fb8d,0xfbea0048,0xf7a8f8f6,0x0957fccb,0xf3120261,
0x01c0f755,0xf8100307,0xfed4f2e4,0xf4e5fed4,0xf924f7c6,0x00cbf87b,0xf825fd03,0x01c70163,
0x020eff82,0xf3daf714,0x0097ffaa,0xfc130144,0x0676f81b,0xf78600af,0x01f005bc,0x013ef4f1,
0xfd7407ef,0x0476ffc1,0x03c1036c,0x0802fe82,0x00550e0c,0x0aae02f7,0x01fe03dc,0x03130505,
0x10830b94,0x04400319,0x05360f9a,0x02b2fec6,0x06dcff3d,0x079b1124,0x022afd4e,0x0c9b09d1,
0xfbe80827,0x0630fbbd,0x01d00ba6,0xfb52f1f9,0xfc2806c0,0x041bfc32,0x0050019f,0xf1d2fab8,
0xf65df69c,0xfa56f48e,0xfce0f76e,0xf275013e,0xf44deeeb,0xf50af2a7,0xf50af621,0x030d02d1,
0xea9dece0,0x02e9f8a1,0xfb880604,0xfc70f5e1,0xf60ffc28,0xfaaafa93,0x0cd3fe98,0x01060440,
0xfdc90c4a,0x076bf8e7,0x01340309,0x070508fa,0x03a4039c,0x0ef9075b,0x03cf0e06,0x066904d4,
0x09710263,0x07900a94,0x0ac6108d,0x08fffed6,0x081311a9,0x007c0004,0x05ac020f,0x07c40951,
0x0058fe9f,0x07580d02,0x0507fd57,0xfdba05c9,0xf5cfff47,0x08d0f319,0xf8980600,0xfea9fcd6,
0xfc8a00e8,0xf644f325,0xf797f79f,0xf84c0176,0x03a2f062,0xf252ffa7,0xffedfef9,0xf8c1f9c5,
0xf4e4ef9d,0xfd9d0132,0xf816f974,0x067af9d5,0xe789fdaa,0x06fef667,0xf6defb25,0xfcf0fd68,
0x02bcfd42,0x071f05b8,0xffe1067e,0x05990298,0x067cff8b,0x05e1083f,0x08c00e5f,0x08a70381,
0x027e0477,0x0a450987,0x079006e7,0x098007ab,0xfc730397,0x0a350520,0x05330660,0x03b802ee,
0xf93f0033,0x012c0113,0x0ddafb5a,0xf7a30ebb,0x0034f930,0xf4fbf809,0xfe33fa53,0x03fb0490,
0xfdc2fba7,0xf873f81c,0xf7360307,0x093ffb43,0xfd9dfd43,0xf71d01b8,0x04c8fd1e,0xf53dfad1,
0x0506fd07,0xfd5901bb,0xfaf9f9e8,0x0390fff4,0xf6ce003a,0x05b7fe9f,0xf7cef967,0x04bd0161,
0xf6adfd28,0x0463fcdd,0xfe15065b,0x02fdf807,0x01ba0779,0x02610132,0xfdbe026d,0x0b1bffdf,
0x05ac09d7,0xfd7104e8,0x05f9fbc0,0x052d0dab,0x02d9fdcf,0x09350928,0xfdb1fd4c,0xfab804dc,
0xfb2df993,0x0b1eff66,0xfa7c01dd,0xf57b0246,0x0179f18c,0xf501fb85,0x08780485,0xf791ff63,
0x0325f3ff,0xfd750690,0x046a0730,0x05d8fdea,0xf6f6fcf4,0x062a03ba,0xfd42fd6e,0xff1fffcd,
0x017004db,0xfc26f8e5,0x0093fde1,0xff050529,0x051cff82,0xfe10fede,0xfd8f00a8,0x086c05e6,
0x010a03a1,0x06d2ff94,0xfc85064c,0x112d03e9,0xfadd0a3e,0x023afa57,0xf61bff02,0x0dee0066,
0xf4ae0108,0xf362f87d,0x066ff4ac,0xf26b020e,0x008bf9f7,0xfbf4ff3a,0xfa95f441,0xf5250124,
0xfed0f433,0xff85fe23,0xf5e2fea1,0x07daffb8,0xf373f726,0x05630078,0x03cf061e,0xfd65022d,
0x006bf90f,0xff9e038f,0x0876023d,0xf7f400b9,0x0369014d,0xff88fe04,0xfc88fa42,0x0a970735,
0xfdd30714,0xfe3bfce7,0x08e8fd01,0xff8b099f,0x09f309a0,0x04bc002c,0x030d075e,0x05740215,
0x05f904d8,0x09900ac2,0x02ed09bf,0x06faff28,0xf9910069,0x027bfede,0x040e03ce,0xff1d0308,
0xf427f96b,0x04b8f9e2,0x042b019b,0xef3efef6,0x0106fbf7,0xf74ff1c5,0x0507025b,0xf074fc82,
0xfab1f476,0xf1c7f767,0xfb30f5f7,0x0243fc64,0xf142fb05,0xfb5df9c0,0xfbf7f734,0xfeb8fdbe,
0xfa92ff44,0x009afce8,0x02bffef5,0x02c8083e,0x059c0022,0xf738fc4e,0x0a50050f,0x0408080f,
0x04850621,0x02c4fc29,0x02610735,0x06390485,0x061b050d,0x062c07ba,0x036c052d,0x0a4a02c4,
0xff79064a,0x00bd06b6,0x097f0015,0x070501e9,0xf85807b3,0x0ba00409,0x095d068a,0xf914ffc1,
0x0779041f,0x0207003a,0xfdd80599,0x01bdfbb9,0xf767fe7f,0xf6d4f4ca,0xf8dcfcd4,0xfeaef612,
0xf50afe50,0xf5fdf164,0xfa41fbc0,0xf50df663,0xfcc3f554,0xfd8a019f,0xf752fa4d,0xffbdf957,
0xfbedfc9b,0xfe350349,0xfbdbf5fd,0x03610489,0xfb8a00d1,0x02c4f9e8,0x039b0587,0x050203ca,
0xf92900ff,0x028cfbbc,0x0abc0aba,0x058000a6,0x01cb08ef,0xfec503ce,0x06cffd24,0x0b8a05f5,
0x00b20ebd,0xfeb6f9ef,0x022800ca,0x066a0552,0xfd3505ef,0x07effa0c,0xfd5c0500,0xfd4900be,
0x05f601f0,0xf926fa3f,0xfc99038d,0xfceaf07e,0xffb00764,0xfbf9f9fc,0xfd81fc09,0x01890179,
0xfb1cfe47,0x0176fc6f,0x011902ba,0xfcfeff3f,0x02f1fcb2,0xfdee009a,0xfcf400b3,0x022afd46,
0x04b104bd,0xfb7afbdb,0x00b4003d,0x02d90576,0xf95cfb78,0x0b48fe73,0xfc82063d,0x06ec027a,
0x01fe0685,0x032aff4c,0xfef003de,0x09bffb17,0xfe5410fe,0xf9e8f56a,0x00a80028,0x02bbfedd,
0xf7d3fecf,0x02f2f911,0xf71d03c3,0x03c7f9d1,0xfffe0227,0x01d4fea9,0xf4ad01ea,0x0541f5a0,
0xf9d9053d,0xfc0ff55a,0xfaf6feed,0xfb44f9b8,0xf6eefb81,0x0046f59c,0xffc80774,0x00e0fe34,
0xfc0ffb91,0xfdf8ff08,0x028b0161,0x0a7605c9,0xff18060f,0x06aa0216,0x0588037d,0x0e9f0caa,
0xfe1706de,0x07400044,0x05c70970,0x080f05b7,0x00a203de,0x004f01e3,0x065d0265,0x055804f9,
0x00940332,0x03ca0209,0xf6bbfe7a,0x0487fbd7,0x00840664,0xfda9f79a,0xfc7203ba,0x051bfc60,
0xf70f031f,0xffd6f889,0xfa3efcc9,0xfbaafa73,0xf758fa12,0xf6e2f9d5,0xfb78f607,0xf733f3f1,
0xf2f101f5,0xfcafef98,0xfa00faf9,0x01be01d4,0xf81ef7dc,0xfdcffc02,0xffa403ea,0x054b0058,
0x03e600fd,0x01de0363,0x0004045f,0x094e03c5,0x07360ab8,0x07cd02cf,0x048a02f1,0x05bf10be,
0xffc1fa89,0x0f3c0d1f,0x0006feed,0x05da0730,0x0bc10af1,0x039c0730,0x074f05ef,0x0ca805f5,
0xfc9d0b43,0x0288f8e9,0x0610097a,0x09a20579,0xf51bfdb7,0x0038fe6c,0xfdeafe13,0xfe88fde7,
0xfa5efb1b,0xf2d6f8da,0xf435eff3,0xf8b0fa3f,0xf224f75c,0xf711ed04,0xf8affc4b,0xf75cf6dc,
0xf95cfcfc,0xf501ef19,0xf788fe77,0x012bf54b,0xf988fd7a,0x040f074c,0xfd60fb4e,0x084b0124,
0x070007e3,0x05c40705,0x0122058d,0x0bb90328,0x06430cbc,0x06600586,0x0119fcb8,0x065b0b0e,
0x0ed306e5,0x02940d5e,0x07a2002a,0x05b40b02,0x0449022d,0x08cf050e,0xfb55070e,0x125902da,
0xf3020468,0xfc0af9e4,0x0868fdbc,0x0426068a,0xf6db0034,0xff32fdb2,0x0627fd4a,0xf413fc2f,
0xfffdff90,0xf81cfad6,0xfc4bf4bd,0xf6e3016f,0xffbcf65c,0xf8a1fdef,0xf77cf682,0xf74ff8ec,
0x040cfcd6,0xfbee009e,0xfc710256,0xf460eaed,0x08af0836,0xf922fb86,0x03610368,0x058d05cd,
0xfd25fb8f,0x03920437,0x0056f92d,0x052912a3,0x0ab9fc6f,0xfdca08de,0x08480205,0x06b303d1,
0x09f01248,0x0014fbe8,0x084708cf,0x085d05ed,0x00140643,0xfd16feab,0x0118fdea,0x061205c9,
0xfb44fa4e,0x05b70a4b,0xfb4cf8e6,0xfd66fed6,0x019a0192,0xfd4ffb6c,0x034a024f,0xf5a0fce9,
0x0761033f,0xf53df1b4,0x00210090,0xfc2902f1,0x09ca01d6,0xf352faa8,0xffa7f962,0xfcc7fffd,
0x02b6fd6c,0xfd010308,0x0176ff4a,0xfce4faec,0x05f802c2,0xf67efbb2,0x034c0713,0x05f8f906,
0x039206f4,0xfba30258,0x077a0145,0x00450880,0x0901fc36,0xffbf06cc,0xffe2ff57,0x03c30405,
0x00df02de,0xfcf7fb63,0x003c027b,0x0199f602,0xfc250d94,0xfdb7f8bb,0x0443f8c9,0xef65fbb3,
0x025b0078,0x01a1fdcc,0xfb6ffba8,0xf8b8fb9c,0xfd82fc3a,0xfcc4fa97,0xfdfdfff0,0x0005fe81,
0xff170154,0xf7f7f287,0x00b307d8,0xfd7cf9a2,0x0ee007f9,0xef61f9eb,0x02eefd05,0x055a0410,
0x08150838,0xfd160173,0x0277fd5c,0x0b240739,0x01f5074c,0x0327068a,0x048a037a,0xfefaf8ec,
0x0bed0c5f,0x02d5090a,0x03c7024d,0x019afcf3,0x056109fa,0xfbd50186,0x0863fe65,0xfa320268,
0xfdc2fc66,0xfde6fef3,0xfd53fa9e,0xfd4ffec3,0xf5e1fd61,0x034ef72e,0xf663fd7a,0xf254f787,
0x0432fdb3,0xfa93f483,0xf49d0062,0xf9acf6e2,0x0158ff88,0xfb9bf7cb,0xfa8b0116,0xfe78f9b8,
0x001afd58,0xf7befe96,0xff2d0046,0xfd3af7ed,0x024cff5e,0xfa12fe2f,0x0236072d,0x04cef47c,
0x07b50f54,0xfd9b041f,0x089501b8,0x06bd025b,0x03d80b0a,0x0806031c,0x053608d9,0x05ec044d,
0x0a600745,0x068807c8,0x07cd0b68,0x03ea00de,0xfe19081e,0x0939fc8a,0x026c059e,0xfe5e02bd,
0xfcd0003c,0xf959f763,0x075a028d,0xf908ff2a,0xfe2ff996,0xf7b6fad6,0xefe2fb7b,0x07a2f283,
0xf49103ba,0xfceaf7de,0xf216f2e7,0xfb37fac7,0xfbb0f908,0xf55cf778,0xf78efd92,0xfe1ef11d,
0x042103ba,0xf5eefe0a,0x01b5fe2a,0x01c6fe07,0x047703ac,0xfffe0437,0x0a71032e,0x02df0415,
0xfdb708e5,0x0de7ff0e,0x059c0b8a,0x036301d4,0xffd605b3,0x0c690853,0xffd0ffc3,0xfd9404a9,
0x0e950093,0x014e0a88,0xff98008a,0x0081019e,0xff47fd8b,0x030d0062,0xfcba024b,0x087201af,
0xf15efee9,0x0da0f64a,0xf3620b04,0xf994f5c5,0x0858fb30,0xf3ea0258,0xfbfcf54f,0x0161fffb,
0xf571fc9c,0xfd0cf9a9,0xf500f49a,0x090a0405,0xefb5f935,0xfe4efaa4,0xfeb1fad1,0xff94fd18,
0x053d04bd,0xfc0c010d,0x04f7055a,0x048efb86,0x03510a76,0xf767fac1,0x0a0cfda0,0x04371160,
0x0056fbd8,0x083403e5,0xf82bfe48,0x072304c9,0x012f02d8,0x04060367,0xfcd2f840,0x02d607cd,
0x04bd04d2,0xfc65fbf1,0x0198ff4b,0x02db0597,0x069afe0a,0xfc9d07c1,0xfbf1fe70,0x0496f8d1,
0xf97600dc,0x038803e1,0xf5c5f7b9,0x03e3ff08,0xf33af90a,0xfeb1f5ef,0xfc3203cf,0xf908fb84,
0x0411f8dc,0xfd1204b5,0xf623f3a0,0xfee200da,0x0415fcb8,0x06c30d10,0x0176fe15,0x01befe42,
0x07a30d1e,0x01790411,0x05bf01cd,0x02a7fb2f,0x01690ee3,0x0c6b0612,0xfb73fbbb,0xfc99028f,
0x09d7ff61,0x05660cb0,0xfa23f561,0xfe2b091c,0x07cdfb67,0xfa4702e1,0xfa27f68f,0x086206e2,
0xfba7015d,0xffbff797,0xfd150184,0xf9d50343,0xf90ded45,0x025906b6,0xfff2fce7,0xf8ccfb09,
0xf808f9f5,0xfca7ffd5,0xfc4bf3a4,0x052c04c9,0xfbcaff27,0xff03006e,0x03b8fc7a,0xfee207c1,
0x0518fa53,0x03dc08f0,0x00700339,0x05a2ff28,0x09f60cc5,0xfdfd04a3,0x03e5f927,0x04fe07c7,
0x076407ea,0x02ce080a,0x0465fc2e,0xf9040520,0x0d49ff02,0x076a0af1,0xfabaff3a,0xffb1026d,
0x01cdfe35,0xffe10222,0xfbdef7b1,0xfbca04c6,0x08a5f7f3,0xf5c706aa,0xff3dfc1f,0xf5c7f759,
0xfc49f054,0xfe000c25,0xfce6f349,0xf82a00eb,0xfbfcf1a8,0xfe09064a,0xffa7fa15,0xfb7bfb09,
0xf81cfdd3,0x024ffc7b,0x02e204d2,0xf8bafa57,0x000df9b9,0xf9cd0325,0x0d29ffa1,0xf98c091b,
0x06cafb0e,0xf97802a7,0x08fffd40,0x08530898,0x04d20e34,0x038a021b,0x04240190,0x091602c4,
0x01240d6f,0x0323fc67,0x0dc30a00,0xf6d007d0,0x1426fb78,0xf8ca0e18,0x02b2fd42,0xfe54000b,
0x078101a9,0xfc290011,0xfb5eff03,0x064c03a1,0xf4a6f7fa,0xfd30fadd,0x03000405,0xf5a6f768,
0xf7d1f605,0xf8cf022b,0xff41ef5b,0xf475fe51,0x02f1fcd6,0x00080726,0xfaa4f2f7,0xf9eefdfb,
0xfa6afb20,0x0454fc70,0xfcc70a5f,0x02bff474,0x014b04fe,0xfd43fe8c,0x048a0505,0xfb5dffa9,
0x113101d1,0xfb8f07ef,0x05e4fe04,0x03e20e3f,0x072b0027,0x08ee04d9,0x00ef052f,0x075e05ed,
0x08070ba9,0x00bdfdd3,0xfc4d0358,0x0866fbf4,0x0af10f2c,0xf6befd28,0x01e0ffd2,0xfb9dfdfb,
0xf8a1f435,0x00bf03c0,0x00b9fd27,0xfc73fee6,0xf5a2f792,0xfe79fc61,0xf9ebf9e6,0xff55fd24,
0xfa38ff46,0xffaaf599,0x00aa04f7,0xfd0200e9,0xfd4af9ad,0xff06fcfc,0x06e0020c,0xfd3c0862,
0x0000f9fc,0xffe201bb,0xfb04fb5c,0x051dfd94,0x07420ca5,0xfe97fe62,0xfb8d0310,0x05d3f936,
0x0558084b,0xfaff0164,0x0fcf0261,0xfc2b0a7c,0x0a680119,0xfa000209,0x0625ffa4,0x03a4040f,
0x0ea40cf5,0x04ee063d,0xf4db014f,0x0736f813,0x023a0bf0,0x0093f8fb,0xf75e024b,0xfffbfab5,
0xfcb8fd42,0xfd1bfe32,0xf513f5c0,0xf2c9f361,0x016aff6c,0x025b029c,0xf304f7cf,0xf422ee36,
0x02e70145,0x07d1062c,0xf8e90027,0xffc6fbd5,0xf96dfe1e,0x07aefbb9,0xf6c304b4,0x0ae0fe67,
0x008a07e7,0x08ba041f,0xfe5a0428,0x033cffbc,0xfbb0fd4e,0x06c7038d,0x09420a6c,0x05970381,
0xf9770357,0x07f0fa6c,0x05500ab0,0x082e07ff,0x005106f7,0x008efae6,0x032200eb,0x0214054e,
0xfa0700ed,0x00c7fa29,0x01ab017b,0xfdee01f5,0xf6bdf5e6,0xfc9dfb8d,0xf451f8c9,0x0176fc0a,
0xfb91fd12,0x01a9ff56,0xeb11f619,0xfc51f147,0x009afd53,0xff910709,0xfde7fb75,0xf9e4f902,
0x036c00e9,0x03070296,0xf8eefe75,0x050d006f,0xfb76fc0a,0x0c850911,0xf5d4fe6b,0x0cb800d1,
0xfbfc0363,0x0b0d0831,0x018c0328,0x09cd0297,0xfdf407db,0xfbf1fc39,0x0e6b0477,0x07a20b57,
0x0316076e,0x0553fffa,0xfe2f047c,0x03f601eb,0x00880170,0x0737035f,0xfb7bffcc,0x02c601c8,
0xfccb0130,0xf988f6de,0xfbeefd1e,0xfd58fecf,0xf84af574,0xf819fe2f,0xf8b5f68b,0xf4bdf558,
0xf6eff3a4,0x045c04ec,0xf646f5d3,0xfbb9fd4d,0xf419f4ac,0x0a2303c1,0xfab300a3,0xfee3fa97,
0x0006018c,0x03ab00c5,0xfd900357,0x02940072,0x01fcfbf0,0x0a640b3f,0x025202e5,0x09030d6c,
0xfe69fb4a,0x075107be,0x01420456,0x0acb0053,0x01af0ed6,0x0600ff3d,0xfec603ac,0x05fdff31,
0x07870bc4,0xff8c01f4,0xfee0fbc8,0x03f605d0,0x03040360,0xfe04fbde,0xfdaf00d1,0x04890440,
0xfeacfb9e,0xfbc0ffd6,0xf588fc92,0xfc54f580,0xfb56f67b,0xff1e04e5,0xf5b2f75b,0xfa60f947,
0xf9aff8cd,0xfd33fe51,0xf33dee53,0x0158046e,0xf978fd17,0x025bf97a,0xf6cafe2b,0x0019fcf7,
0xfbb0f663,0x087f0d0c,0xf8f2fd78,0x04bdfba3,0x02bf0085,0x01320980,0x0565015d,0x04c104f5,
0xfdd5ffa9,0x0dd80646,0x02f1076d,0x01c8067e,0xfcf0fb45,0x100709d6,0x0209072c,0x00a80294,
0xfecbff3c,0x0269fe45,0x04ba0421,0x02870b46,0x05dcfc8c,0xf72dfce7,0x05f30657,0x0113fc79,
0xfc1c01a1,0xfc4bfdbd,0x0059fc71,0xfb39ff8c,0xfd5ff637,0xf8360320,0xf7b5f343,0xf97ff861,
0x0062ff7e,0xfdc7fd9b,0xf155f4ae,0xfe7dfa79,0x0310036c,0x0275033c,0xf778f8a2,0x0163fa66,
0x021b04d8,0x03af063d,0x023400c6,0x032801c2,0x0110fde6,0x07cf0aaa,0xfdd501c0,0x02e8fb2d,
0xf82806bd,0x114ffea1,0xfbd8049f,0x01e303be,0x0294ff44,0x02bf0570,0x049a0196,0x00eb047c,
0x037f00d8,0xfebafe03,0x04ec070e,0x02f404af,0xf5c2f5e6,0x00b4fdd2,0xff4f0405,0xf934f6a2,
0xfb93fa4b,0xfda70246,0x01adfaee,0xf5a2f9ed,0x058d02a0,0xf93bfb9f,0x01d2fb52,0xfc58062c,
0x00f5f934,0x02bf0426,0x02aeffdb,0xfe6b016a,0xfe1c000c,0x0a110599,0xff78031c,0x02acfdbb,
0x00150529,0x02c3ff97,0x05840944,0xff47fccb,0xfb93ff90,0x016cfee3,0x02350070,0x0195041a,
0xf7dcfe6e,0x08dafcaf,0xf616feb1,0x01cd0015,0x023a015a,0xfb37fcd3,0xfeac0074,0x0256fcdd,
0x086d06d9,0xf45afccf,0x0536032c,0x0625ff02,0xfeaf0287,0xfdd503be,0x00cafb21,0xfe5100c8,
0xfcb6f97f,0x021e07d8,0xfd81f8e6,0xf8a4fda3,0x055a012d,0xfa5efb40,0x00b1fcf8,0xfc72068f,
0x09bffce6,0xf89b00f8,0xfe5afb8f,0x019002e9,0x05240198,0x03b204f9,0xfd69ff99,0x0a310151,
0xf9c0064c,0x104b0485,0xfe9906ad,0xfb20fb69,0x088402d5,0x05f70599,0x02aa086c,0xf1e7f610,
0x09f7ffd9,0x0258038c,0xf9630006,0xfe67fbe7,0xf7baf99d,0x002af6b0,0x01230aea,0x000ef9ad,
0xf6befc5e,0xfa82f609,0x01880485,0xf53ff435,0x03ad0091,0xfac0fad0,0xfd7eff31,0x0023fe3c,
0x044a03c0,0xfcd6fea8,0x0376fdd8,0x0630079f,0x00080349,0x07260182,0xfcd9049a,0x07b1ffe8,
0x087f0a8c,0x02680101,0xfc980380,0x036afeae,0x08a607e7,0xfc3fffd8,0x04d20231,0x0694009a,
0xf7d8074e,0x0e2a0277,0xf717f9bd,0x02dc0530,0xfc0afdb0,0x0a10ff99,0xfc8808df,0xf72ff8d9,
0x0710febd,0xf9b5faaf,0x040608e6,0xf7d8f6f4,0xf848faf5,0x0008fa1e,0xfccf0459,0xff59f797,
0xf0dcf873,0x015dfcf3,0xfdfb010d,0xfc98fa89,0xfe77fdd5,0xfe5efe5e,0x035203ce,0xf988f75e,
0x05290a45,0x0223fd17,0xfb9d0234,0x0242fa03,0x03c505ce,0x09240a51,0xfe77ff84,0x038401b3,
0x017b061d,0x0b1afef3,0xfde50a97,0x0bbf0265,0xfb690786,0x1185027c,0x0a790c1c,0xfdf2067e,
0x00ac032b,0x0724ff7e,0x01f904f9,0x004801e7,0xf6c1fd0b,0x046ffb12,0xedd7f675,0x05c40011,
0xf07dfafb,0xf81cec96,0xfd9d0403,0xf9b0f3e8,0xf45ff7ff,0xfe8efd4c,0x02a9018f,0xfbdbfada,
0xfeedfb39,0xfe3c04f4,0x057d00cc,0x043d0097,0x023a0564,0x023a0434,0x03840020,0x00be010f,
0xfcbd046f,0x08b1faf2,0x00a20721,0xf9f5ff18,0x0ad4027e,0xfb04ffcc,0x049a0171,0xfc020108,
0x03a40108,0x085d0136,0xfbcc0524,0x04b6fefc,0xfbbb0539,0x0e22fea6,0xf9c406eb,0x076201db,
0xf6effc88,0x015efccf,0x019e0403,0xfcf6f9a2,0xff7f057e,0xff72f9e8,0xf520ff23,0x0343fa09,
0xf3d9f6a4,0x06090434,0xf18cf9b7,0x0532fba6,0xf2e0f812,0xfab6fb96,0x0351016d,0xfa3af675,
0xf6b0fc0d,0x02e2ff4d,0x013b010c,0xfd43feda,0x00a30002,0x07710176,0x073005ce,0x04f90dba,
0x0323feb8,0x07af0623,0xfea5ff2a,0x12541296,0x08340563,0xf9a6017d,0x030f02f5,0x0786ff4f,
0x05fc096e,0x01b50440,0xfcbb01bd,0xfe34fa80,0xfea1fbce,0x08bd0884,0xf080f703,0x088102bf,
0xfe630128,0xff7cfe2a,0xf80ffbd3,0x01b0fea2,0xf59cf981,0xfed7f741,0x005907a3,0xf792f78a,
0xf6a2f1f2,0xf9a2013e,0x00f4f859,0xfe7f00f3,0xf4e8f3e0,0xf89901da,0xfd20f6d0,0xfcbaf43d,
0xfcb3068a,0x092f00c5,0xfe0bff6c,0xff7504b7,0x06020023,0x05870459,0x05ac0319,0x01320e0c,
0x12b7012c,0xfe0d091f,0x043d0104,0x063b08df,0x09c3023a,0x04500d41,0x02fd01cb,0x091604b6,
0xffc5043b,0x04d70028,0x045609ea,0x02c803a5,0xfd74fc5d,0xffab0005,0xfd90fc18,0xf5edff0c,
0xfdeaf774,0x0143fc39,0xf6f4fe00,0xf8f1ffc2,0xf161e814,0xf8b8faf6,0x05360428,0xfa79f4ca,
0xf9af0363,0xfa5ff72f,0x04c9fdea,0xfa79ff18,0xffe8015e,0xff66ffcf,0x0746fc36,0xfca1074b,
0x000bfd8b,0x05ae01b2,0xfd44013b,0x01cf03c0,0x0f680539,0xfaca01c9,0xfa35fd25,0x030d02e5,
0x0bbb0274,0xfd4a0456,0x0c41090d,0xfe5700e8,0xffdbfef9,0x07c305fc,0x074907e8,0x01470453,
0x03cf004e,0x08bd07e4,0xf84ffea1,0x03a3043c,0xfe38fbbb,0x05bdfe3c,0xfa5e0415,0xfb18fe0a,
0xfaa8f48e,0xfe79fdb0,0xfe040294,0xf72cf673,0xfd70f7d8,0xf81e017c,0xfdcffab8,0xf1c2ef94,
0xf5e3fa5b,0x04f8fd0c,0xfa87fc43,0xf617f8c9,0xf95cff50,0xffebf508,0x04d2fd8d,0xfdca101d,
0x074ff92e,0xf876fec3,0x0fb707a5,0xfe2f08c4,0x0a49004e,0xfef101fb,0x0b940e5d,0x09b607cd,
0x015e0039,0xf8e801b3,0x0e8504ba,0x043f05ea,0x024f0570,0xfcf80123,0x023300a7,0xfe6cfa75,
0x001e042e,0x0274fffd,0x00e40139,0xfcf20536,0xfffaf676,0xfd2b0059,0xfed90242,0xfeb5f968,
0xf8c1ff36,0x0339fdf7,0xfdc30375,0xf7f9ef40,0xff1009ea,0xfb82f5f7,0xfe90fffd,0xfc3cf7ae,
0xf47500ff,0xf9e8f17f,0xfff8fab3,0xfc1303b5,0x0093fd3c,0xfea5fd90,0xf6e3fa64,0x015dfee9,
0x078c0398,0xfb2e002e,0x031102ad,0x0a5c031f,0x0349061d,0xf808ffe1,0x1391080c,0x042a0577,
0xff72070b,0x0aee05b8,0x0179027c,0x03320612,0x0510fd29,0x03960e08,0x07b1ffb1,0xfd9700ac,
0x017304f1,0xfdacf912,0xfea80462,0xfea8fb84,0xfae4fa7b,0xfb55fb97,0x00c30186,0xf221f647,
0xfdc3f7d4,0x09bf042e,0xfa3a031a,0x0221f863,0xf6a60872,0x0608f327,0xfa2c01b4,0x000d0066,
0x04f104c1,0xf78ef665,0x090a0235,0xff6b0740,0x01290227,0xfee2fab7,0x034c0497,0x030a0205,
0xfe38fda9,0xfa1000b1,0xff66fcb2,0x0884030f,0xfdaffc8c,0xfd5f0526,0x061a015e,0xf577f939,
0x00860099,0x01e2fc04,0x06f10590,0xfb630386,0x0033fd8d,0xfc98ff3c,0x04e0fa3a,0x000c0c4f,
0x0309f89a,0xfb8102f7,0x053901d4,0xfb05fe34,0x03a80269,0x0a17016d,0xf81906a1,0xfe2ff81e,
0x079204e8,0xf5a5fea5,0xfb01f843,0x01fbfd94,0xf9a8fd16,0x0443fff1,0xfcc10161,0xf988fd21,
0xfbb9fa13,0x04bdf85d,0x07510fc2,0xff28ff91,0x05a50681,0xf8d5fa16,0x10cd0584,0x095d0d7e,
0xfcde0740,0x03a9fd7a,0x09b7058b,0xfc730557,0xfa4af673,0x04d00748,0xfe7afda0,0xfd82fc82,
0xfab1ff44,0xfc77f9d5,0xf8b9f9d5,0x007efbc1,0x032c05ce,0xf851f8b0,0xf8aefdaa,0x01bafbbf,
0xfeaefbf1,0xfbe7fe84,0x008102a4,0x05ab0115,0xfd09fe73,0x01e3032e,0xf568f777,0x07a2ff7e,
0x00620785,0xfff2fd50,0xff2d002f,0xfa53f682,0x01850799,0x06aafe9f,0x07610a11,0x01f9021e,
0xf89efe2b,0x0743fce7,0xff18069c,0x098c081b,0x02f1fede,0xfdbe03a8,0x0bf906e1,0xfbb0fe70,
0x01a402f7,0x020e00a0,0x06b60520,0xfb36fe19,0x072c042a,0xfd0f038c,0xfdc2f6e2,0x0a2c09f3,
0xfea1016a,0x004d03a9,0xf84cf65d,0xfd8ffec2,0xf348f6b3,0x039bfa63,0x013c0698,0xf8b5f994,
0xf437f606,0xfe7dfb7a,0xfd5cfd65,0x069b04a8,0xfb42fb82,0xf0eff94c,0x09d1febd,0x040c0510,
0xf60dfdaa,0x0951fe54,0x004e06a1,0x04f9044d,0xfa4efe43,0x04c6fc60,0x012b0673,0x029c01c6,
0x05330711,0x0233fd85,0x00030161,0x050a091e,0xfe22fbd6,0x03a30622,0x107e0449,0xfebd091d,
0xff1e022a,0x01950048,0x060f017c,0x0726044d,0x00bb0932,0xfabbfc62,0xf8c6f792,0x06ea0530,
0x053c00b0,0xf342fce4,0xf952f43b,0x04fe09c8,0xf440ef13,0xfe5d00aa,0xf711f645,0x00590235,
0x0094fa56,0xfcdd022d,0xfe58fc15,0xfc17fd21,0x01c800f4,0xfd07ff74,0x06650074,0xf82efc77,
0x019a0373,0x0062fbc8,0xf911ffa7,0x03f3fed1,0xff3cfbc3,0x02c605fc,0xf7c2fd8e,0x08980478,
0x04f9fc7a,0x04ab0594,0x066f0eb3,0xf85afc1c,0x031bfcdc,0x042a022b,0x00e4016d,0xfc9e0102,
0x02b60008,0xfc4e0221,0x05fcfae9,0x019905dc,0xf61b0106,0x01f0f554,0xff69ff82,0x07f00e13,
0xf8f5f50e,0xfeac0345,0xfddef82c,0x01c8099c,0x0c64f90d,0xf4870d1e,0x008df61e,0x06c9024c,
0xfdf000e9,0xfd9b04fd,0x046ff963,0xfc540426,0xfc06fd33,0x07dbfca8,0xfa19059e,0xffbcfb49,
0x008e02bb,0x0317fe60,0xfaf0fe65,0xfe8500f5,0x068afce7,0xf6ca045b,0x06d2f9c4,0x077d0aff,
0xfe090205,0x0005fcc4,0xfbaf004d,0x01b2fba7,0x01a7060f,0xfebbfdc6,0xfb9cfb2d,0xfbbbfd2a,
0x03ee00dc,0xf6c6fd0f,0x0017f77a,0xfc0c019d,0xfc13fab3,0xfbdbfd1d,0xfc54f840,0x00de0451,
0xfe1df81b,0x06d00a92,0xfdd0f91d,0xfa31047c,0x048af89e,0xff460a4b,0x0cfcfcd0,0xfdf7073d,
0x035c052e,0x0722035a,0x076a04a3,0x057605c9,0x09320d71,0x0b1604b1,0xffe20361,0x08b00b9d,
0x05520203,0xfe260051,0x00ed01a2,0x0a7909b9,0x03920248,0xf2c6f94c,0x087603f1,0xf51bfa4e,
0x0566ff4b,0xf692fffd,0xf5f4f1c8,0xf79af72c,0xfcbb00b4,0xf98af485,0xfd58fa1e,0xfd2e0051,
0xf67fff78,0xf928ef4e,0xfe4cfd5d,0xf932006f,0xf9eef447,0xfd0effa4,0x0121feec,0xf794fb4a,
0x004ef7b1,0xf63b0443,0x02e8f72d,0x03990277,0xfb930121,0x02ce01d1,0x0169fc1f,0x06e208b0,
0x085d065d,0x0ac1096b,0x00a907cb,0x08a500f8,0x04cb0774,0x080208fb,0x07480500,0x049d0822,
0x09a90609,0xfecf0541,0x049702c6,0x06b10270,0xff60022c,0x01230485,0x0456023d,0xfc36ff72,
0xfa79f774,0xfc1cfc3f,0x096e069b,0xf75a005a,0x002ef8a7,0xf929fce8,0x02eefd43,0xf81b0163,
0xf562f4eb,0x0093f770,0xfd5f01ec,0xfcd2fcd3,0xf2f4f67c,0xfa2cf93f,0xfc7df7d8,0x0039fffe,
0xf7f9fad0,0xed70f6ee,0xfee5f17d,0x01d4fc92,0x02cf09d1,0xfd680215,0xfd96f5dd,0x053b06d9,
0x0a660123,0xffb00abc,0xfba6ffd2,0x15f90446,0x07370eb9,0x03f604a6,0x071509f3,0x0738041c,
0x049d06fe,0x0606039b,0x0cb40b32,0xf9c8056a,0x03b2f90d,0x003f08cc,0xfe50fb88,0x0397ff62,
0x010f0647,0xf538f8dc,0xfe86fad0,0xfd3afbb6,0xfd0f0250,0xfcf0f559,0xfc310451,0xf63ef586,
0x0361faee,0xfa2e0118,0xf6fafaba,0x0151fa35,0x0182fe9f,0xfc060254,0xf1cdf7a3,0x033cf726,
0xfcd20327,0x048dfec2,0xff24ffea,0x064c05e1,0xfd3d0237,0x03290014,0x048d0062,0xfc8a03e6,
0x03800048,0x021a018e,0xfff400dc,0x01a102da,0xfd49fcd4,0x0542ffab,0xfa2c07e7,0x0d0afcd9,
0xed7afdf8,0x052cf863,0x0246050a,0x05240683,0x0418ff11,0xf7ca02c6,0x05a6fbd6,0xff1302ea,
0x08f106b4,0xfae3fddd,0xfc48fd69,0x095200b5,0xff620b68,0xfe19f783,0xf57efc4b,0x068afbd8,
0x05eb0aa1,0xfa51fd79,0xf67ef89c,0x039bfae3,0xfbb90034,0xfc9e0363,0x01eff31a,0xff6807d8,
0xfd02fc9f,0x038c00aa,0x02030126,0x06180736,0x0604031a,0xfdfc04b1,0x0004fce6,0x079d027e,
0x01ab09a0,0x055afd5c,0x00f407a2,0x018402c8,0x0188fb44,0x018e0762,0xfd8bfee6,0xf231f55f,
0x03a2f8cf,0x03860b64,0xf243f5f8,0xf711ef82,0xf9a802e8,0xfaeff307,0xfe39fc15,0xf37dfbf8,
0xfcaffa26,0xfaedf429,0x024f0640,0xfdb7fc7a,0x0566017c,0x00060071,0xfdf3039b,0x0b4402e5,
0x006b0652,0x0a600250,0xfdf20743,0x0f4805e4,0xf8020401,0x0228ffb4,0x0818fdce,0xff790991,
0x030a00c5,0x02bf0444,0x05fdfe45,0xfc8006d4,0x0243fe4d,0x0409001e,0x04bc0a1e,0x06fa01b3,
0x001500d5,0x093d0a3b,0xfaf20452,0x0c1efb21,0xfba30601,0x03d602fc,0xfd6f0231,0xf107f212,
0x06b0fc36,0xfa6003d6,0x025ffa94,0xeefbf9a4,0xf2f3f836,0xfdddee97,0xf3c7fc20,0xf987f5d1,
0xf360fc45,0xfba3ed44,0xf86d03ba,0xffbcf730,0xfbaffd2b,0xfbd3fdb1,0x0309ff2a,0x08ab02e8,
0xfbc10666,0xfd82fe16,0x05c7fa09,0x09040eda,0x041202fd,0x111b0b61,0xf8d6083f,0x06d4f99c,
0x0c450d9a,0x0d420c1e,0x08770913,0x044d0a88,0x06de03ce,0x03680279,0x0ccd0b7f,0x09340a3b,
0xfd3700dc,0x059b07d2,0x016f00da,0xf9c3f828,0xfdee00dc,0x0a19059d,0xf130f866,0x0792fee0,
0xf6e204b4,0xeb35e8ee,0xfdd8f558,0xf5b4ff17,0x04bafac0,0xf1a6f843,0xf700f9c9,0xfed4f8e2,
0xfd16fd20,0x0588ff0c,0xf58e04bf,0x07a8f927,0xf889ffea,0xf645f91a,0x0103fb0c,0x07ea013b,
0xffb90b40,0xfecefca1,0xfb7cf6eb,0x012603ff,0x05a301cb,0x082e071f,0x003c0726,0x02bdfe9f,
0xfcc0febd,0x08ee0250,0xf9e7075d,0x0c8ffea2,0x06f40882,0x027e09d6,0xff30ff0e,0xfc22fc82,
0x0741ff78,0x056f0888,0x01470588,0xfd25fad7,0xff07013e,0x0228011f,0xfdb2f991,0x03c7080b,
0xfecdff44,0xfd97fbd4,0xf670fbce,0xfa79f96d,0x0945ff54,0xfd7b01a2,0x0a8e0cc0,0xf918f7ed,
0xfe2bff9d,0xffa3fe81,0x0270ff3a,0x07db08fe,0xf8c6fbb9,0x00ebff90,0x04d60361,0xfc6eff13,
0xfbb0fbc5,0x052d0108,0xf965028d,0x024bf8ec,0xfa0c0041,0xf888fd25,0xff59f01e,0x08c00ee9,
0x01900136,0xf455fda6,0x035cfb56,0xfda3fa16,0xfed604e9,0x0a17067f,0xf9c4fa27,0xf91ffced,
0x016100d7,0x00caff56,0xfb3af82f,0x046603fc,0x00f805d5,0xf754f876,0x012dfb2f,0xf3f6006b,
0x04d2f6b0,0xfbccfe9f,0x00af049a,0xf844fa30,0x014ffa8b,0x044301c5,0x021408a3,0x044dfcca,
0x09a50bf3,0x035e05f3,0x0c900743,0xfed4018f,0x0b2a0b1b,0x10d00b3a,0x04510c13,0x03d103ef,
0x0254007c,0x070b0b17,0xfcf4fabb,0x06ee0411,0x00fb049a,0xfd4603f6,0xf93ef5fb,0xf88df95b,
0xfe70fb68,0xf853fb4c,0xfb11fafb,0xefaaf2cd,0xfe7afbe7,0xfabef7da,0xf7c5f8cd,0xfab1fbce,
0xfce7fc79,0xf82bf8c9,0xfd0af7cf,0xfa700590,0xf9bbf023,0xfc0afaba,0x08e80cdf,0xf49ff413,
0x01deffd8,0xf726f867,0x06cc075e,0x0132fc9d,0x0b730550,0xf58603f8,0x090e0558,0x0777fcb6,
0x025b0b48,0x0d1202ed,0x06271643,0x0749f957,0x063d0cdd,0x0aac067c,0x01760767,0x06c702fc,
0x0b8908da,0x029a0ac1,0x042dfc41,0x04890884,0xffba0329,0x04310155,0x07010347,0xfe5d012f,
0xf2c7ffec,0x00d7f3c7,0xf65cfcd6,0xffa7fcd6,0x004cfb7f,0xf18dfb14,0xf67df780,0xf47af0b9,
0x0274ffa0,0xf02af254,0xf786f96f,0xf50df932,0xf895ecec,0xf242fadc,0xf9d1f79a,0xfc2bf930,
0x00fafe33,0xf9d4fb25,0xfe14063b,0xffe2ef65,0x071d0f03,0x014101ec,0x0e10080b,0x07e405b7,
0x04b40c77,0x0d30063b,0x0c3f0eaf,0x0f7308d6,0x02fb0ea2,0x12b409ea,0x0074046c,0x069408d7,
0x01b407f3,0x04d0f8b1,0x074a0888,0xf99d07ac,0xfa3bf5c5,0xfecbfa38,0xfc62ffdf,0x01b8fe93,
0xf89eff59,0x02d9f9eb,0xf10dfb6e,0x08fa01cb,0xfebdfd34,0xfaad00a6,0x0240fcd9,0xfaa000e7,
0xfbbbfa36,0xffc4f889,0xf1170328,0xf4d7e98b,0x040cfe06,0xf18600fd,0xf97ef00e,0xf602f689,
0xff66fb82,0xf819ff53,0xff7ffcb8,0x016af956,0xf88903b5,0x091efcbf,0x09960be7,0xfd8d02ea,
0x0d0a04c8,0x04fd0b5e,0x06e1037a,0xff2801ea,0x0ee20c7e,0x044a055b,0x09890446,0x00e80927,
0x03a20756,0x0d390037,0xffc90789,0x02c605e0,0x02cc0129,0x072f03e6,0xfff8054f,0xfd8bfd9b,
0xfea5fc72,0xfd560088,0xfcb1ff4d,0x0304fc3f,0xf50afbb6,0xfa9cf62f,0xfb080124,0xfde6faa3,
0xf3d3f2f7,0xfddeff31,0xfb0cf89e,0xf8d9fc30,0xfba3fa0e,0xfb5efbb9,0x01d60048,0xfa1df53c,
0x018308cf,0xfe45ff91,0x0a02fc2b,0x00de0974,0xff8500bc,0x098d071d,0x019000fe,0x01f50188,
0x010a060c,0x04dbfed4,0x034301ff,0x03490b20,0x0b210371,0x0191fea5,0x01a80cb4,0xfb33fc0f,
0x021bfc93,0x02d0ff79,0xf4d3feb2,0xfc8afc16,0xfce6f68b,0xfcd40205,0xf739f6bb,0x049cfdb2,
0xf2e2fc22,0xfb92f9e6,0xfeb1fafa,0x01ddfe78,0xfd18fed7,0x017d0209,0xffce06aa,0x00cff3c7,
0x0570066d,0xfbbd0759,0x0163f7f5,0x0a7209c8,0x03ca023a,0xfb110830,0x082ef9b9,0x036c0619,
0x026507cf,0x06630290,0x0ca80942,0xf8d30106,0x074c0309,0xfde1024f,0x0dea0298,0xfba3059b,
0x00af01af,0x0608fe56,0xfce60189,0x06fd08eb,0xfc06f9a5,0xfc1cff4a,0xfff2febd,0xf8a5fd66,
0xfd07f778,0xf40cf74f,0x01ff0459,0xf8f8f37b,0xf91ef8ec,0xf90403ba,0xfaa5f116,0xfd3cfce2,
0xf69cf6d2,0xfbb00256,0x0128f8ec,0xfdebff4a,0xf670f8f9,0x01b5ff8d,0xffef0166,0x007df8ee,
0xfc57077d,0x02ebfd33,0x061500b2,0xff820498,0x0d0708e2,0xf93d0450,0x1033fc29,0xfe830e13,
0x0a79056b,0x09d10813,0x0751099d,0x069e019e,0x0c6d1301,0x035e016f,0x07f607e1,0x04d60724,
0x0bc506a1,0xff0502c5,0x08c20a30,0xfd860381,0x056df882,0xfd7206ff,0xf0cdf8bd,0xfe6ef5d6,
0xfec5ff15,0xf3f4f7e1,0xf562f6d5,0xf2d6f07c,0xf073f65d,0xf8c9f084,0xfd96fc30,0xeca7f81f,
0xf93eed89,0x044401c5,0xfcd900b4,0xf98bfd15,0xfbc5f5cb,0x06e702e5,0x012305a2,0x056e0662,
0xfe06fb7d,0x099005b5,0x0f550c84,0xfccd06cc,0x08a907b9,0xfddef752,0x0e040ee0,0xf7d30192,
0x12bd0561,0x0345076e,0x032a0621,0xff30035e,0x0cdf0227,0x04460916,0xfd99034a,0x06fd0199,
0x0911056a,0xf4bffd27,0x08030871,0xffa0f9f1,0x00da0106,0xf9faffd9,0xfd8bfd8b,0xfa6af89e,
0x0185fd1b,0xfbb00290,0xfb31f726,0x00b9023f,0xf7d8fb7c,0xf79ff3be,0x040c01ab,0xfb9cfd55,
0xfb36fd84,0x048700a7,0xf93ffbeb,0xf92efb43,0xfc45fa73,0xfc70fd46,0x0697fc85,0xf83e0672,
0xfd86f748,0xfa31fd7e,0x083e017d,0x039b0218,0x01d90652,0x02d80287,0x00e203ac,0x0434fd75,
0x0bb80d9a,0x00fd0208,0x0d2e0670,0xf7550aa8,0x0880f619,0xfe0707ae,0x09e001fe,0xf9b204df,
0x0261fce7,0x01ff0270,0xf8a3fa23,0x00f8fcfc,0xfbac036a,0xfe09f993,0x08120202,0xfae40159,
0xf5d1fd4c,0xfeb2f7ac,0x027afd6b,0xfe0a0630,0x05fffd5c,0xfaf50246,0xffa00141,0xfd50f93e,
0x081c04dc,0x00a60237,0xfdd302d6,0xfebbfef5,0xff21fbc8,0xfdb5fe83,0x0bce057c,0xffed0454,
0x03060ad2,0xf8a7f106,0x07a80652,0xfee20262,0xf9adfd30,0x05090340,0xff7ef761,0xfd2e087b,
0xfcc1fa48,0xf43df5ec,0x047c00df,0xfeb1fae4,0x04030869,0xf6e7fa0e,0x0691fe04,0xf90b004a,
0x0345fb82,0xffa707a2,0xfef5fbdb,0x008801dd,0xfccaf8e8,0xfdfe0339,0xff3dfdce,0x0397fe39,
0xfdc307b8,0xfd37f476,0xfdf400dc,0xfe9f00c3,0x030dfd4a,0x03710783,0x046ffd75,0xf86f046b,
0x09befdf3,0xfa930199,0x0e8d09ef,0x018e007c,0x056606f8,0x083a067f,0x05d1090a,0x06120468,
0xf749fe0a,0x0608fd2e,0x08f00aee,0xfe2c0157,0xfee600a8,0xf556f809,0x07a8fbc9,0xfe1f0912,
0xfc65f8e3,0xf6a4fb81,0xfc06f561,0xf8cffbdb,0xfefd025b,0xfc77f79b,0xf404f8ba,0xfc4ef500,
0xfc310480,0xf5b6f6b0,0xf9e2f29b,0xfc60fffb,0xfae6f8c7,0xfa67fca7,0xfcd6fd70,0xfecbfcd2,
0xf752f4da,0x04720419,0xffac0128,0x023101ef,0x0a630557,0xfe4b01c0,0x06790412,0x07050793,
0x0c220b91,0x0855042d,0x07030f14,0x04e50233,0x08fd07f1,0x07850934,0x07bf049a,0xfb610501,
0x03befc73,0x06cf0be8,0x030ffb8d,0xfbf00450,0x04ac0440,0xfd3cf8e8,0x00d80868,0xf935f577,
0xfd3afc60,0xfde8fea1,0xfea8ffb0,0xfae0fff4,0x0802f799,0xee6a00ca,0xffe1fa6a,0xf741f513,
0xf7edfed4,0xffabf6f4,0xf548fad5,0xfc06f848,0xf0c5f6dd,0x0307f9a5,0xfe6a007d,0xf87ffc9d,
0xfb5af8a7,0xfce2fef5,0x03abfbcf,0x069206ad,0xfba30211,0xfe19fd62,0x043b03bb,0x05cefe75,
0xfec70491,0x07e40405,0xfe2c0698,0x0db5ffc8,0x033b09a5,0x040907d0,0x085d002f,0x06970adf,
0x0bcc09b7,0x03ba09fa,0x0ef3fd7c,0x012c16a2,0x00c3f870,0x099509d9,0x067e02d5,0xfe79060c,
0xf963ffc2,0xff7cf451,0xff810269,0x02a503af,0xf90dfb53,0xef99f763,0x0214f5dd,0xf950f95e,
0xfcf8ffc4,0xf4e2fa95,0x009af7cf,0xfc62ff0c,0xf2fcf5e6,0x0655009e,0xf4a3f873,0xfbe5fbcf,
0x006e003d,0xfd82f888,0xf988007b,0xffd5fb27,0x01af0424,0x0280fe38,0x028f0008,0x062708b4,
0xfe3300ec,0x08820630,0x0c3d0410,0x00be0b86,0x045c0288,0x08f504f1,0xf9b9ffd6,0x0a7e05eb,
0xff360669,0xff1af892,0x05dd064e,0xf79405de,0x029eed82,0xeeeb0381,0x0811f698,0x01610ebd,
0x002af400,0xf69b0079,0x01fefdb9,0x0a0303ce,0xfb6c0505,0xfeaffb0f,0x06450312,0x007a00f3,
0x058b05e2,0xf9c903e9,0x083afb12,0xfe9300c2,0x05b306fa,0xf749ffce,0xfe7df9db,0x030f042a,
0xfd43f549,0xfe69043c,0x00b104d6,0xfa41f720,0x0523016d,0xf65cfaac,0xff940050,0x0538fd37,
0x01540803,0xfa33fd56,0xff6bf6ec,0xfe26030d,0x063b0525,0xf955fd69,0xff26f9d2,0x010a05b4,
0x010dfaac,0xfef904b4,0xf815faaf,0x0070fbeb,0x045b00a3,0xf455fd1b,0x081803fc,0xf3baf5f0,
0x08dffb5e,0xf2a40928,0x0bdff92e,0xfde20304,0xf6d3fdbc,0x0589fb67,0x016a036c,0x0424024d,
0x000c061b,0x0be002e1,0xfeb405a3,0xfee3fe42,0x0c2e0638,0xffa4059c,0x094e0623,0x06a90690,
0x029c039b,0x045b056b,0x090804b8,0x034f0886,0x00fe03ae,0x02a7fc2b,0xff70062b,0xfdd5f634,
0xfdca0e1f,0x022bf1ac,0xf5eb0061,0x067500da,0xfb6efbf6,0xf0acf7ea,0xfd84f670,0xf216fb5f,
0x0703fa07,0xf46cfb3b,0xf09af4eb,0xfc0af963,0xf70af24f,0xff1000d8,0xfce7fcfc,0xf6fef5e2,
0xfce800e4,0xfd30f720,0x0d230574,0xf59fff98,0x08d908a3,0x0370ff5f,0xfde2fd71,0x0acb0a27,
0x03f1060f,0x099006bc,0xfbcfffd1,0x0f940caa,0x071800a3,0x01080a28,0x0425066c,0x08e60322,
0x0cb20980,0x04f90802,0x020e0779,0xfef6fbf4,0x05f709d1,0x0aa9043b,0x00dc019f,0x017b03e1,
0xf8e30392,0x0b16faaa,0xfd0101d0,0xfdd805d4,0xf5bef55b,0xfc69fb27,0xfb58f8b8,0xf30ef8ee,
0x01f9f681,0xe8fcfd07,0x04e9f3ba,0xef81f7d4,0xfaaef3ea,0xf474ffe8,0xfa93ed81,0xfc67019a,
0xf650f7a8,0xfc26f879,0xfeb4fd0c,0xfc98ff05,0x02bf0371,0xfb6afa23,0x058bfdfa,0x007506f1,
0x05a2054b,0xfe5a0323,0x07abfcab,0x0f740cb1,0x01170a30,0x065706db,0x08ab02e7,0x0c440ac4,
0x093e0ce7,0x05770390,0x01ef0ad5,0x0708fbc5,0x01ba0b01,0x075dff21,0xffc60675,0xfe010094,
0x0142ff6f,0xfe8afcde,0x009ffdf2,0xfe9f0549,0xff7cfbce,0xfc89fe3c,0xfa1cfbfa,0x04a0fbb4,
0xfaae0277,0xf940ff60,0x0014f58d,0xf550f77c,0x04f5012b,0xf504045b,0x02c3f217,0xf3befcfb,
0x0485fbd7,0xffec0630,0xf071f136,0x053f026b,0x01cffaef,0xfe34037d,0xffd50261,0x03480339,
0xfdb9f60e,0xfc4b02a5,0x09dd058f,0xfd4602e5,0x0465fbeb,0xf8150541,0x063dfbf9,0x0418030d,
0xfe580451,0x024ffe69,0xfc6700b2,0x061efffe,0x007d06a5,0x082afe5a,0xfd120627,0x07e10316,
0xfce20164,0x0027ffb8,0x04c8015e,0xfecd0030,0x0a570523,0xf65b0408,0x0453fdea,0x042afa9e,
0xf7dc04b8,0x022a023f,0xf726f05f,0x083609e9,0xfddefc99,0xfd6802ea,0x0875fe10,0xf8f50218,
0x075900ac,0x012906a3,0xf72ff7af,0xfdc9ff3c,0x078afd46,0xfe700787,0xffd8fc5e,0x01b204df,
0xf89ef8b8,0xfdfbfd4d,0xff99012b,0x0485ff28,0xfddffc8c,0xfb3306bc,0x00daf9db,0xfaeffc7c,
0x081b042a,0xf837fd14,0xfb18fabe,0xfd02fe9c,0x0312011b,0x04bcfb56,0xf4f705b8,0xfd66f36c,
0xfd9d0195,0xffdffe5a,0xf736f84b,0xfce2fa66,0xfd37ff32,0x02ad0085,0x09440277,0xf228feb5,
0x0520ffd1,0x0041fe26,0x0cc005a9,0x04540b7d,0x076704ac,0x052c07b8,0x02b602a1,0x0ec10c4f,
0x02690313,0x000effd1,0xff8206c0,0x08de0493,0x0161fce4,0x049f0660,0x04c80526,0x00fa0738,
0x0283fa55,0xf8f100ff,0xfd60fcef,0x020efd3d,0xf838fc06,0x00d600c5,0xf37ff552,0xfb7ffb53,
0xfa79faae,0xf5edf31e,0xf91afaec,0xfab6fa6a,0x000dfcba,0xf592f90b,0xf9a9fd0e,0xfe7df355,
0xff41ffdf,0xfcd0050a,0xfb0bfa02,0x03fcfb3c,0xfe570192,0x021504a4,0x0608fe51,0xfd3a0630,
0x017b0066,0x033200ac,0x0ae50316,0xf41e029c,0x11950824,0x013500bf,0x010603d8,0x065308ab,
0x042efd28,0x044d0a6f,0x014f00e4,0x0ce207b3,0xfdf0ffc9,0x08b60c80,0xfe3b026b,0x06c3f996,
0xff9e07b5,0x03bb0774,0x04f1fda6,0xf86b01b4,0x00b2fb08,0xf833fb55,0x00c80086,0xfab1fa11,
0xf807fdc7,0xfec3f6b3,0xf3bbfb56,0x03aef813,0xf4d6027a,0xffbcfaae,0xf800f2e2,0xffb00043,
0xf6f80106,0xf9e6f4fa,0x0209f790,0xf49d025d,0x0434fd68,0xfd84fee2,0xffeafb39,0xfb5dffd0,
0x04a903be,0x0b0c033c,0xfdd603d0,0x0659054b,0x05d50818,0x02fdfdce,0x05a70742,0x09a80b7f,
0x0b46ff43,0xfe4e11ea,0x0619fe27,0x02620227,0x06ff00a3,0x03be10ae,0xf746f8a1,0x06c0f912,
0xfeb8096b,0x0740048d,0xf6bef68e,0xff44025b,0x05450138,0xfa16ff0f,0xfe7dfb86,0xfa57f9d9,
0xfca100e1,0x08b1fe93,0xfa0904d4,0xffe6fa00,0xf6f2fa85,0x013e0307,0xf79cf0d4,0xffa0049f,
0xfba6fba8,0x027efe40,0xfda3017a,0xffe3fa6d,0x018f06fe,0x05e0fc1f,0x0310099e,0xf7f003e3,
0x0847f65b,0x018e026c,0xfa9c045b,0x049703a0,0xfc06f424,0xfb970586,0xffa2fcb4,0x0717fbf0,
0xf749004a,0xffba04e1,0x0847fe70,0x046c0330,0xfc51fd56,0xfae909a3,0x0894f5da,0x00b906b1,
0x01df025d,0x02370483,0xf834f80f,0x04f10043,0xfb7f0345,0x01b0fa82,0xf8d2ff1c,0xffa0fd4a,
0x01bc0081,0xffeffc4d,0xfc4bfe47,0x00f305e9,0x020efd82,0xf8fafc0d,0x07daff75,0xf7430055,
0x0fb205dc,0x037a07ca,0xff3f020c,0x060f00b1,0x046e09d1,0x0d7100d4,0xf4080810,0x0917fd29,
0x0e5404e1,0xf6d409fe,0x06750091,0xfc21fc65,0x0078fa4b,0xffea0ae5,0x02d6fb91,0xf6a2fe15,
0xfcabf53a,0x01eb0898,0xf879f63e,0xff66fce7,0xf1fdfa42,0xff69f7f7,0xf40df71b,0xfab1fbfd,
0xfad1fad0,0xffcdf8e6,0x01a4023a,0xf635013b,0xfe33f437,0x05480159,0xf6170091,0x02a5ff14,
0x01b8fcaf,0xfd20027a,0x00ecffde,0x01b2feb1,0x02990418,0x00acffda,0x09dd0a1c,0x04a10246,
0x03ca05b3,0x021e0351,0x08310370,0x05c90bd1,0x0ba20185,0x00060886,0xfc3401ab,0x109504e9,
0xfc880378,0x0c2205dd,0x079c0d71,0xfe75fa5a,0x04620703,0xf8a3023a,0x080cfbca,0xfeffffe2,
0xffa10491,0xfef001b5,0xfa3bf46a,0xf791fe75,0xf9fef726,0x00fdff6a,0xf015f634,0xfab7f587,
0xf307f926,0xff75f224,0xeb7efd8e,0xfb81ef7a,0x042a0050,0xf3b7fc85,0xf7cef5e1,0xf53ff3ea,
0x0033fb5a,0x05250657,0x03ca0113,0xf9f9fdb1,0xff3800bd,0x09b501bb,0xffd0055f,0x06ca022d,
0x0bd80a8b,0x065d079a,0x041507bf,0x08fd05b3,0x102407cb,0x01430f84,0x1562078a,0x017f0d41,
0x005fffd6,0x0ad20588,0x005606e0,0x0b8f0522,0xff9104f2,0x09ae0710,0xfbc3ff8a,0xf6e7f69a,
0x052508cc,0xfefbf9eb,0x017bfec4,0xf60402b0,0xf761f1c5,0xfa3cf612,0xf816fadd,0xff440473,
0xfb94f246,0xfdf2006e,0xedbaf873,0xffa4f2e4,0xfb9200ea,0xfa5ef6c0,0xf8f5045b,0xfdd5ecd0,
0xf82a026e,0xf9f4f7dc,0xfa26fa27,0x083e02bc,0x044d0480,0x0202ff78,0xfe9c04f6,0x04a1062a,
0x0d15007e,0x063b0c19,0x03220818,0x0a10010a,0x05540ba6,0x07c1075e,0x03b80755,0x07d0ff7b,
0x06e709d9,0x04bd0b0f,0x02ccffd6,0xff70ff18,0xff84fe22,0x0eda12ab,0xfce9f971,0xf7fa00b4,
0xfb81f73c,0x03dcfd30,0xfae403b5,0xfa4eff6a,0x01c6f7fd,0xfb9ef777,0xfe7d0808,0xfc83fec5,
0xfe78f4a1,0xf71100fb,0x0026f899,0x00900134,0xf4e9fe19,0x0008f81c,0xfeb8019b,0x00b3f7ce,
0xf92403fb,0x0038faf7,0xfd8602b1,0xfddaf759,0x05aa04b7,0xfc5dfe71,0x04bf0617,0x03120056,
0x032203c0,0xfdacfdf4,0x0cf108ab,0x028508ae,0xfb5dfac4,0x0fe0089e,0xfdd604ec,0x05bd010f,
0xfced06d2,0x089500be,0xf9fefa35,0xfdfe00a3,0x06500653,0xfc5dfbc1,0xf663f534,0xfc8a05b8,
0x055df434,0xfb8d081e,0xf907f85f,0x022801e6,0x0703fcbc,0xfe930392,0xfa070573,0x0536f5d1,
0xfae405a0,0xfeaffaed,0x03a0fe96,0xfabe0048,0xff61005c,0x037ffdfd,0xff3f0062,0xfde7049c,
0x02e9fb96,0x06120051,0x0184091c,0x000600ef,0x05aa037d,0x04c1fdc0,0x062711c0,0xfff8f7aa,
0xfbd505d5,0x0237f723,0x00a90b6e,0xf70af56e,0xf8c1f3c8,0xff2306d4,0xfdc7f478,0xfde10261,
0xf336f84c,0x02dafbb0,0xf481f71d,0xfef6ff95,0xff66ff0e,0xfe16f666,0xf8ee0796,0xfe45f51b,
0x06b60116,0x007004f5,0xfeca0161,0x0018fe67,0x0123ff6f,0x00ac06a6,0x026ef87b,0x00df0573,
0xf79aff88,0x0624fc5d,0x0707072c,0xfbe8fdca,0xfdee0186,0x085003c3,0x08be031b,0xfe8d0584,
0x082705af,0xfde10186,0x053c01cf,0x0cb007d8,0x08ab0b1d,0xfe38028c,0x011703a1,0xff2bfc22,
0x01fd036c,0x063601af,0xf81600eb,0xf98af37b,0x01b8058a,0xfd2a0160,0xfcafeffb,0xf228019d,
0x0570f80f,0xf82c04ac,0xf653efaa,0xfa13fcd2,0xf3cdf1cb,0x00eafdc5,0xfd6c0384,0xf7b5f216,
0xf7f7fb0f,0xfe9cfd12,0x033901d1,0xfc66fa31,0xff66021b,0x0a8103c5,0xffd902ba,0xfa54067e,
0x07d8f815,0x06c807e3,0x04e503e6,0xfca10685,0x032eff75,0x03bbff66,0x033206bf,0x07ac01fc,
0x03c90786,0xffc3019d,0x043707cb,0x05a2fc1c,0x017902cc,0xfeef0782,0x079904fe,0x02d2fa3b,
0x04a308ec,0xffd60660,0x051afc4d,0x00e70792,0x05e201ff,0xfc60fe22,0xff06040f,0xf7a3f807,
0xfcfcf79f,0xf657f98b,0x02d501cd,0xf06cf52f,0xfdb2f7ca,0xf6abfbc9,0xf72df4f7,0x0322fc9c,
0xfc1801df,0xf914f901,0xfd17fe26,0x0370fc09,0xf912ffbc,0x0283fc26,0x0257067e,0xf8eef8e5,
0x052002eb,0x04c60252,0xff2106f8,0xfc64f5e0,0x0a9f0659,0xffc40899,0x072d01df,0x04e30392,
0xfa66fdf2,0x06270436,0x0d370da5,0xf96cfd5c,0xffd8fdf8,0x03cafffd,0x0320083a,0xfba3f94c,
0x04ad087b,0xff10fd68,0x0159fd35,0xfaa8034c,0x004df87b,0xf32afda3,0x062efd82,0xfc04fff2,
0xf8d6f8ff,0x02e8fefe,0x00480299,0xfd85fd1f,0x0407027e,0xfff1017c,0xfec60003,0xff50ffef,
0x02da0113,0xff60ff99,0x03c3013b,0xff780796,0x000dfae9,0x064e017d,0xfb5204bd,0x0096fa75,
0x05c90b1a,0x03f3fbc8,0x046e0971,0xffc3fef5,0x023c03e0,0xfbdefd75,0x108709d9,0xf682ffb6,
0xfde1f915,0xfd15fda9,0xff260231,0xfc22fae0,0x00750212,0xf9e0f4d6,0xff2d03b8,0x002cfcaf,
0x00ac047c,0xf646f3c7,0x03af0485,0xf634f9bf,0xfe9cfb3c,0xf890fad4,0xfb5bfbb6,0xf5a6f6b6,
0x070bfd7a,0xffbf0485,0xf996fd6e,0xff0cfcc7,0x016dfd64,0x04bf0296,0x08660b0e,0x01d6ff44,
0x01f40795,0x0d8c03dc,0x09b51031,0x001effd6,0x098906fa,0x0733085c,0x02350529,0x02ed01a4,
0x03000175,0x05a60542,0x03090719,0x0386019f,0xfd4a02ed,0xfc24f637,0x07cd0627,0xf8c90132,
0x02dafe55,0xfc4bfc04,0x049d0627,0xf8eff6e9,0xfbea00de,0xfb8bf9a9,0xf89bfb8f,0xfd1ff859,
0xf36df758,0xf536fae9,0xfffdf5d1,0xeff8f33f,0xfaa8fc98,0xff4af92b,0xf74bfdc2,0xf8a8f895,
0x0409fb75,0x004effb0,0xfecd02c5,0x023d0405,0x033b0116,0x04b8ff66,0x0850064e,0x06140ae1,
0x01df072d,0x0ecd046f,0xfe750570,0x0c8b024f,0xffac0daf,0x0709018e,0x0a1a054b,0x09690e06,
0x077d0270,0x06860983,0x09420ba6,0xfb0bff30,0x0ac30196,0x05bc0743,0xfed40a00,0xfc02f52f,
0x0018ffcf,0x003401e0,0xfbc5fce2,0xf7aafb6a,0xf1e8f477,0xf955f2d8,0xf7b0fa76,0xee3ff242,
0xfb29f4ce,0xf5b6fac7,0xfd3df580,0xee37f884,0xfe3ef4a3,0xf3f3f790,0xfb73fec4,0x0770f8dd,
0xfcbf0466,0xfce0fc77,0x092d0593,0x05880838,0x056f051c,0x03a00037,0x0c5d0bc9,0x0358061d,
0xfdea048a,0x0a4d031a,0x076a0488,0x0d211004,0x01be01a2,0x07850849,0x051d0634,0x0651051b,
0x073308e7,0x035efcd6,0x050711d6,0xf997f50a,0x001afc01,0x054f08ab,0x02690533,0xfd43f703,
0xff290045,0xfba906a6,0xffacf4a2,0xfb31ff3b,0xf5e3f85d,0x0086fdb5,0xf69ef55a,0xfcf4000f,
0xf75bf976,0xf7c5f576,0xfde8f8e8,0xfee601fe,0x018cfc21,0xebcdfc70,0x04f6f2d9,0xfcfc07c3,
0x03def90f,0x036c0465,0xfdba042f,0x0263fd83,0xf9fe0304,0x12c9016f,0xfec105d0,0x07860b14,
0x024dfd7b,0x04910935,0x12440722,0xfbc00980,0x094e0008,0x048107fd,0x07ac088a,0xfe0400ed,
0xfcf6fc06,0x067e0122,0xfacd0550,0x097ffd0e,0xfb9605d4,0xfcaffaef,0x0234fdf2,0xfd3901d2,
0x035ffefe,0xfb0801ef,0x0520f7d8,0xf166066a,0xff63f459,0x04aa007a,0x0103fd97,0xf940085a,
0xfa64f2df,0xfe99fe77,0xfd16fd86,0x026900ff,0xfe8ffcd6,0xfa2c00dc,0x053cfda0,0xfb080652,
0x061bf66d,0xfa320383,0x075d0589,0x027e04f5,0x02bcfc93,0x05f70651,0xfe3c0041,0x064609ad,
0x0093002e,0x0322ffcd,0x02a70388,0xfc8e0108,0x0288fd94,0xf4d0ff18,0x0e4a02d5,0xfa0cfcf0,
0xf9cefd34,0xfa7b047b,0x014df0c6,0xfdc301c8,0xfd16021f,0xfc11fc38,0xfbebf950,0xfad7fd39,
0x0143fdd5,0xfd4afd33,0x01cd0121,0xf329fdbb,0x0634f9d1,0xfa79fdf8,0x0642fe70,0xf93f0d10,
0xfbcfeeaa,0x0392030d,0x0779031c,0x00340790,0xfc4ffc95,0x06360159,0x06f109cd,0x063d01a9,
0x0298037d,0xf9370348,0x0b3ffed1,0x094b0bd5,0x03af03b8,0xfdb20421,0x098a0228,0x02c6061a,
0xff87fd30,0x03580948,0xfdd8fa69,0xff44ff9e,0xfbcefe93,0x003ffe7d,0xfb65fd61,0xf990f5ac,
0xfdea03a2,0xf5d8f738,0xff21f291,0xf4c603ea,0x0022fa90,0xf653f444,0x0028fa77,0xf80b011d,
0x00e1fc29,0xf9fbfa07,0xfc98ff03,0xff60ff33,0x00dcf8d6,0xf809fffd,0xfdeefc04,0xfe8101a8,
0x0651fac0,0xf4930106,0x0e7c0375,0x02750778,0x01e3fd56,0x012907f6,0x0a9b0500,0x01950282,
0x08470831,0x053204cf,0x04d90599,0x084d0904,0x0af10665,0x00cb0795,0x078703ea,0xfd68fe95,
0x057308e3,0x02750268,0x0120fecb,0xf873fda2,0x02c5f980,0xffc508ef,0xfa3af908,0xfc48ff07,
0xfbbcf82c,0xf39ff1ac,0x047607be,0xfa05f62f,0xf39afee2,0xfa8cf218,0xfa79fbca,0xf7d5fbfa,
0xfdbdf5f0,0xf206f8ec,0x022cfd55,0xfdfd0395,0xfdd8f4ab,0xfd1201e6,0x02a000eb,0x029c02bf,
0x01e3fecd,0x040c0975,0x078a0205,0xfdaefcc9,0x0b8f0d6f,0x016104f6,0x057d02d8,0x0741ffab,
0xff470bd2,0x048bff54,0x013efd5d,0x0aa70f62,0xff69015e,0x02c6fea6,0xfc9000e9,0x0132ff97,
0x0252026b,0x01dafde8,0xfee90849,0xf771f1c6,0x0aae0d3e,0xf581f461,0xfc06f98b,0x02ee091b,
0xf54bf38a,0x0044fcd7,0xfd8a01cd,0xfa26f663,0xf52dfcdd,0x0573f6c0,0xf8b4093f,0xfbd6eff0,
0xfaf2ff1e,0xfdd0ff26,0x04f1ffb5,0x013805d8,0x05a9fc15,0xfb0f04f6,0x0a4403de,0xf9d20334,
0xfd59f6cb,0x11000944,0xfb9f0434,0x02e5ff6a,0xfca10765,0x052ef71d,0x017d06e4,0x03510095,
0xf85d0396,0x067ffc29,0x051002ba,0xfc6f05cd,0xff4bfb6f,0x058a016f,0xfe1903c9,0x085006d5,
0xfe14fc18,0xf982fca6,0x00bf0485,0x047cf9bd,0xf78c03c3,0xff28f691,0xf94302bd,0xf63bf3f0,
0x034afe82,0xfc26fcaa,0xf9d4f95c,0x04a004eb,0xf40cfc8c,0x0038f6d9,0xfd0ffe95,0x0df30468,
0xfdd506f7,0xfdea0166,0x0c82017b,0x04e10785,0x01af01cd,0xfad00557,0x0e7a020e,0x060601ea,
0xfc560c47,0x020bfbdb,0xff29fb0d,0x0c590aca,0xf62505d4,0x093bf9b0,0xfadffe23,0x03300825,
0xf651f9e2,0x0786faa4,0x00fe08b4,0xf7cafb37,0x01b4ff7c,0x0246fd7e,0xed7ff957,0x06caf8ef,
0xfcd4023a,0xfb1400c3,0xf9a6f79d,0xff79f833,0xf413fc8c,0x04a3fcd9,0xfefc04d0,0x00b3fba0,
0xfc70ff0e,0x07b50406,0xfa2cfe9c,0x08a304e1,0x0415042a,0xfea80095,0x0c8c0533,0x047c09de,
0xf988fe4a,0x076703d9,0x081e04a4,0x0836079d,0xfbca0309,0x056303de,0xfea9f971,0x0aa70cd4,
0x004e07a3,0x021bfb32,0xfdb9ff41,0x01f501cf,0xf856ffba,0x0491fc0d,0xf840fc16,0x070e08f0,
0xfbccf587,0xf7d2ff78,0xf0dcf670,0x0c19fc69,0xf363fdea,0x013bfd82,0xf1f9f7f9,0x0657fc0d,
0xf9bffe7f,0xfaf6ff5e,0xfe19fb0f,0xfc58f85f,0x043f01db,0xfa230304,0xf987f7f9,0x02c8fffd,
0x0062f9a9,0x08250d5f,0xfae4f93d,0x0297062a,0xfd27f9b6,0x08a208c0,0x0e0a0871,0x021a04ba,
0x014d035a,0x02ee045c,0x0d8e08ad,0xfc1c017c,0x0a56032c,0x07be0dba,0xfb8bf6ad,0x0e031466,
0xfd9ef8f1,0xfff9027e,0x01e6fedd,0x000d075e,0xff3afc1f,0x03a1fba3,0xf8360688,0xfb0df4c4,
0x041bfd12,0xf79d0386,0xf5fff5aa,0x01f4f799,0xef4cf8a1,0xfe57ff57,0xfceaf46f,0x06eb02fb,
0xf2baffd9,0xfde2fa4e,0xfb2af9f0,0xfc59fa48,0x0a21045b,0xf483fcaf,0x050202b0,0xfe60012f,
0x054bfd57,0xff8a04b7,0x01ebfb4e,0x07dd1115,0xfe0dfbd2,0x0e310596,0x00450419,0x04dc0737,
0x051008d2,0x061e00ea,0x0b96077e,0xfd9b07f4,0x03a500ac,0xfbc1fc31,0x0f3908a2,0xfd460ae9,
0xffd8f6d0,0xfdda01a8,0xf44dfbc0,0x03d0f8b1,0xfd4600d7,0xfee700af,0xf78efc8c,0xfc6af586,
0xf9f4fea1,0xfd38f9f4,0xff3dff5e,0xf5a1fa2c,0x04e5ffb8,0x00fe00a3,0xf9a6fd07,0xfcf6fd4a,
0x0208fefa,0x086106eb,0xf9eefd2e,0x01bafff4,0xfb4affdf,0xfd8afaef,0x0c980520,0xfe60072f,
0x02f5fe95,0xf926fb71,0x083e05c9,0x01610552,0x025bfaf8,0x0a760fc6,0x0110fc28,0x02050a64,
0xffa7fa02,0x040f0624,0x0cf503a4,0x06400ea4,0x015104f1,0x0000f4d6,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_24_standard_DRUMS_mbongotone[1408] = {
0x00000000,0x0151ff5a,0x0415fdb5,0xd889f1aa,0xe1500a01,0xdb30e7c5,0x1f7ce935,0xe348dacd,
0xd42cfc52,0xf02d0712,0x14920a1b,0x29b50008,0x1a5d1e0d,0x28493cce,0x4a9e3d09,0x50013b42,
0x44625322,0x46234763,0x2c432883,0x07221fff,0x00f60e09,0xe96bf1ad,0xcd12cd54,0xa8d1bb8e,
0x998eb33f,0xac999a4c,0x901c858f,0x8a46948f,0xa0b5a21b,0xc054a5f0,0xd33bc2f1,0xf4f7e61a,
0x16d70afe,0x3d952fba,0x5c21458a,0x66cf6032,0x6e24734c,0x6e4c6b56,0x66de67d9,0x51bb58ee,
0x3b9a4803,0x232d3567,0x0a49116e,0xed51f7df,0xdc5ce58b,0xd9f9e02a,0xd00cd208,0xd0cdcfb5,
0xd09acf1a,0xd22ad258,0xd256d61a,0xd462d0d4,0xe067d9fc,0xe2b2e376,0xe39fea3d,0xe178e563,
0xe8e4dec6,0xed8de920,0xfa5beeba,0x013e001e,0x0f280d4c,0x19301632,0x27311b67,0x36dc2fc4,
0x422b3e05,0x4aa6472e,0x45ca4909,0x3e574325,0x3bad3f00,0x2ca53301,0x1d3d283b,0x048a14e5,
0xeb44f7ed,0xca36d5be,0xae83bd7a,0x9fe1a647,0x942898f7,0x91b197cf,0x9ee99454,0xaa419f19,
0xbaf9b4ac,0xdec2cdd9,0x01efeb98,0x24851665,0x41523559,0x57444a62,0x61c65ed5,0x678168d8,
0x67ff6b09,0x5f2760f1,0x458d5422,0x2c7e3c38,0x11a81db2,0xfaef062a,0xea7ff548,0xdb3ae1ca,
0xcac3d012,0xbd96c5db,0xbca8c0bf,0xc1ccbc91,0xc56cc0b5,0xd290cda9,0xdf9fd9b8,0xedf6e37b,
0xf3e9f1a5,0xfe06fcca,0x090103b4,0x15510b98,0x1626147b,0x12cf16fd,0x133f1566,0x11741017,
0x11d40fe6,0x10e91241,0x10b9103c,0x101b105e,0x122710e4,0x16fb1491,0x1c1016ac,0x176e1cf6,
0x14e819db,0x0d510e90,0x01e00598,0xf97fff6d,0xefa8f5a4,0xe4c4e75f,0xdcd3deda,0xd2d7da47,
0xd3bcd96c,0xda90d27e,0xdf75d6ca,0xe50ee4b6,0xf4a5f029,0xff93f8bf,0x09c105ac,0x14190e8c,
0x1a111566,0x1f941e3e,0x240f264b,0x2576245b,0x21fb2220,0x18a01f67,0x14b617a4,0x09920f15,
0x00ec06f0,0xf815fd0d,0xed69f02d,0xe428eaa8,0xe2a4e158,0xe1f7e0a1,0xe462e345,0xe80ce6df,
0xf0bcea67,0xf408f0d5,0xf9b3f976,0x035b0177,0x10fd06f4,0x10920d72,0x0de31392,0x0e691103,
0x0edf0aea,0x0c9f0d56,0x0f4010c9,0x0f6c0ea2,0x0ebd0d29,0x07d00b51,0x05ff09f1,0x064506c3,
0x038b04af,0xfe5400ec,0xf861f890,0xf242f503,0xee10f1d5,0xef55ee2d,0xef78ebc1,0xec23ef6b,
0xee94f030,0xefaaed21,0xf18cefb5,0xf75af5cb,0x0046fb0b,0x046c0108,0x05ee0761,0x08fc09c1,
0x0c630651,0x0b8e0c10,0x10ec1047,0x14f31497,0x1433124d,0x0f24116f,0x0bbe0f79,0x0a4a0c35,
0x0749078c,0x00c303a9,0xf9d5fd47,0xf2f3f6de,0xf0c9f366,0xf0e1f047,0xf59df0da,0xf464f242,
0xf49bf817,0xf649f895,0xfacaf4ba,0xfa87f6f6,0xfbd0fcc6,0x0029018c,0x0247016e,0x00590102,
0x00a1fec4,0x01deffa8,0x02d504d7,0x09d4091e,0x0ccb09c7,0x0a9e09dc,0x09800cd9,0x0c090aba,
0x0cb20adb,0x0aa20bc4,0x08e90a88,0x025a05c3,0xfe7f0148,0xfc05fbf2,0xf9c0f96f,0xf65ef84b,
0xf29ef615,0xf0e2f2f3,0xee20ee75,0xee52ed7a,0xed6cecc6,0xf079f028,0xf3ccf1a4,0xf8eaf62f,
0xfd6cf9ab,0x035a0176,0x0b380857,0x12b20e14,0x18341423,0x1b9f1ab5,0x19d41bb9,0x17081904,
0x116f13a3,0x0c29108a,0x0711096a,0xffdc02e4,0xf878fb27,0xf152f68b,0xef29ee96,0xeb66eb5c,
0xeb6aecac,0xee1bee52,0xf1ffef17,0xf275ef46,0xf394f2e5,0xf668f70f,0xfd78faca,0x0229fcaf,
0x02a50218,0x03fb065a,0x0a1b08a5,0x0dde08b1,0x0e750e19,0x103312b9,0x0f990fe3,0x0d330b71,
0x06510b99,0x05e90b3e,0x0cc80601,0x05d3040b,0xfeac062a,0xfe0b0195,0xfc97fa2e,0xf841f92e,
0xf8dbfa71,0xf8c4f8f1,0xf4e7f7be,0xf27cf405,0xf1a0f1cc,0xf1aff045,0xf298f151,0xf29cf3d0,
0xf5caf483,0xf7eaf5f4,0xfde8f969,0x02180053,0x09c60715,0x10d70d87,0x14cc1274,0x161114d3,
0x1310147a,0x10e41458,0x0edb0f79,0x0b630bec,0x04830776,0xfec803aa,0xfbf0fc3b,0xf6e9f7db,
0xf27df50c,0xf017f286,0xf04cef73,0xedecedda,0xed7eef1a,0xf131efaa,0xf5fdf20b,0xf913f6e7,
0xfe11fcce,0x03a101a7,0x08a004df,0x0ba109e0,0x0f5e0e54,0x1219105d,0x128f1233,0x111a11d4,
0x0c0e0ea1,0x077e0b87,0x04930699,0x01330151,0xfc7cff1a,0xf8bffba4,0xf721f72d,0xf4d7f3de,
0xf274f54d,0xf42ff4ec,0xf668f44a,0xf608f498,0xf618f650,0xf804f834,0xfd0ff989,0xffd7fd28,
0x03650173,0x070a0522,0x09af083a,0x0b4b0c20,0x0df60bef,0x0d130bee,0x0a910c9f,0x08c30b40,
0x06510672,0x018b02da,0xfdfc00b7,0xfc25fdae,0xfac0fb2d,0xf810f933,0xf6e3f7b7,0xf560f5f9,
0xf4ccf551,0xf5f0f5b3,0xf895f647,0xf93df889,0xfbb1fb25,0xfe29fd02,0xffe5feff,0x03300169,
0x05eb043b,0x08560703,0x09e00983,0x0b010a46,0x0a450a46,0x08b20940,0x062f087e,0x0472053a,
0x016502a2,0xfde0ffa7,0xfbf0fcc9,0xfab4fa3e,0xfae3fa76,0xfac9fbb8,0xfbeffc2e,0xfc50fabc,
0xfac5fae6,0xfba3fccf,0xfea9fc57,0xff85fe5c,0xffa10085,0x0117008f,0x013e0027,0x015e01c3,
0x02c00257,0x030a024b,0x023002f7,0x00f40287,0x0135012f,0x00c9ffb9,0xff94ffdd,0xff0d0024,
0xff31ff73,0xfe70fe5a,0xfe13fd69,0xfe9eff12,0x00b60072,0x02c601e8,0x0362028c,0x020002c9,
0x01070171,0x001e00f0,0xffe40023,0xff1aff0d,0xfde9ff27,0xfe33fe94,0xfe81fd82,0xfe42fe1a,
0xff6dffe4,0x00ce0040,0x018c0068,0x004c0118,0x00b100f4,0x00000083,0x0088fffb,0xff45ffc5,
0xff3dffa3,0xfebdfefc,0xfe72fe4b,0xfdd4fe3a,0xfef3fe98,0xfed1fe72,0xfecdff12,0xfec6feab,
0xfe5ffeba,0xff08fe9e,0xff98ff01,0x005e0003,0x015a0147,0x031201d3,0x043f03a3,0x05850544,
0x064705f0,0x064c05f1,0x04c9065f,0x03f304ea,0x01ff0279,0xfebafff3,0xfc31fdf4,0xf9ddfb26,
0xf924f977,0xf920f8d9,0xf966f938,0xfb71fa8a,0xfbcefb88,0xfd69fc61,0xfe07fdbf,0xffc5ff27,
0x00a5ffc4,0x0173010d,0x026a0282,0x03660294,0x03af037d,0x03b50400,0x0460042e,0x03cf0389,
0x029b03a0,0x020c02c6,0x01510111,0x00c000d7,0xffab001b,0xff78ffc9,0xfe27fe20,0xfd1afe2d,
0xfdf7fdcf,0xff64fe67,0x005affe5,0x00eb00d8,0x008100fd,0xfff1006d,0xfeebff56,0xfe29fe65,
0xfc7afd37,0xfaf3fbca,0xf9f8fa9f,0xfa01f9f3,0xfb93fa48,0xfd4ffc91,0x0022febe,0x01f10115,
0x034e02b4,0x055104cd,0x076b05c7,0x08d107bc,0x084d0937,0x08130929,0x064806a6,0x03cc0497,
0x01a3033a,0x00d40112,0xfedaffa6,0xfca5fe0c,0xfa28fb54,0xf878f8f1,0xf719f836,0xf75df745,
0xf76cf717,0xf790f775,0xf8d9f8a9,0xfae8f9a2,0xfe05fc5d,0x0154ffcf,0x04fd02f2,0x06a40562,
0x06e70732,0x07550800,0x07a4071d,0x06ac06a3,0x05370642,0x04050488,0x01c002ad,0x002c00ff,
0xff9c0023,0xffeffff4,0x0000ff95,0xff3bffad,0xfeefff34,0xfe05fe6a,0xfd8bfdef,0xfd02fd37,
0xfce8fd17,0xfc39fc7f,0xfb96fbef,0xfb55fafa,0xfb4ffb9a,0xfccbfc31,0xfdaefd35,0xfefffe0e,
0xff93ff1e,0x00660038,0x01c00159,0x02b40218,0x03c7031d,0x040003cc,0x0440040e,0x04460462,
0x04f404a7,0x052304cd,0x045b04b4,0x02e3043e,0x0198023d,0xff1fffe7,0xfca8fdbf,0xfad1fc17,
0xfa02fa73,0xf977f9a6,0xf949f946,0xfa59f9b1,0xfb88fab2,0xfdb5fd06,0x000dfec4,0x022200cc,
0x033102c6,0x051504d0,0x0621052c,0x060605af,0x05570625,0x051e05b8,0x04410424,0x028a02f8,
0x00e40220,0x001900ce,0xfefeff08,0xfd71fe4d,0xfc96fd49,0xfb4bfb90,0xf9bbfa54,0xf8f7f993,
0xf988f945,0xfa1ff958,0xfb3afad7,0xfcecfc20,0xfe6dfdca,0x0042ff69,0x01a800cf,0x03190257,
0x040903a0,0x048f04a0,0x051f0533,0x050504c6,0x04c4048a,0x043704b5,0x04190487,0x03c103ef,
0x02c902e8,0x01eb026e,0x011601c6,0x006800b7,0xff3bff90,0xfdbffe5f,0xfc50fd3f,0xfb65fbce,
0xfa80fa77,0xf9c0fa14,0xfa1afa5b,0xfb55fae8,0xfcb6fb7b,0xfd63fced,0xfed3fe8c,0x0045ffe2,
0x01ea00bf,0x025e01c8,0x031c030d,0x03310356,0x04060389,0x040103a3,0x04360407,0x03c7048a,
0x03af0426,0x02b7031e,0x01e601ec,0x009900be,0xff0b0038,0xfe26fee5,0xfd36fdb0,0xfc31fc3b,
0xfba3fbec,0xfbbbfbf2,0xfcd5fc14,0xfd0efcbb,0xfdf4fdd1,0xfe2cfe59,0xff86fecc,0x004eff77,
0x0109006c,0x0154019b,0x01e501e7,0x0213019b,0x01790171,0x018f01d0,0x01cf0213,0x02a20234,
0x028c0242,0x023e0260,0x01670247,0x01670178,0x00a500e7,0x00070054,0xff1aff66,0xfe37fec2,
0xfdeffe0a,0xfdccfd98,0xfdf8fde3,0xfe13fdfb,0xfe5afe30,0xfdd9fdf8,0xfddbfe48,0xfe24fde5,
0xfe9efe1d,0xfee8fed5,0xffd8ffa7,0x00410001,0x00c40090,0x018b00ff,0x01e501c6,0x02e2029f,
0x039b0349,0x03cc036b,0x034c03bc,0x02eb0348,0x024b0296,0x016a018b,0x002500e1,0xff24ffd4,
0xfe3dfee5,0xfdd5fd95,0xfd67fd76,0xfd60fda2,0xfddefdaa,0xfd9afd86,0xfd87fd9c,0xfde1fdbf,
0xfe45fdb7,0xfec8fea4,0xff7dff3c,0x0029ffca,0x002d0016,0x009c0084,0x014a0126,0x01ca015f,
0x01cb01f0,0x01760187,0x00dd014b,0x009a00ec,0x00b200a5,0x0099001a,0x00660099,0x00230097,
0x005f0024,0x0041fff0,0x00bc009d,0x014b00f9,0x012f0135,0x00ee0125,0x006c00be,0xffdc0020,
0xff34ff75,0xfec9feeb,0xfe1dfe87,0xfde3fe15,0xfd73fd69,0xfd6afd70,0xfe20fdfb,0xff16fe62,
0xff6eff0b,0xffa5ffc7,0x00340036,0x00dc0029,0x00eb00ca,0x015b0195,0x025801d9,0x02a801f1,
0x0258025b,0x020302a5,0x02050257,0x01ca0186,0x00d60111,0xffd1007a,0xff07ffdb,0xfe9bfe9e,
0xfe03fe1b,0xfdbffde8,0xfdc2fdd5,0xfdbffdb2,0xfe48fdb8,0xfe4bfe50,0xff14ff0d,0xfffbffc8,
0x00bbfff9,0x007f0071,0x009d00ef,0x00dd00bb,0x00c4009a,0x008500aa,0x00d400f3,0x013900d1,
0x01180123,0x015f016a,0x018e018b,0x014c0117,0x0093013e,0x00420080,0xffd2fffe,0xff60ff5b,
0xfee4ff1c,0xfea4fec6,0xfe8ffe7c,0xfeabfea6,0xfeaefe9e,0xfefafef0,0xfeeefedd,0xff66ff3b,
0xffbcff68,0xffddfff4,0x00460038,0x00d6005e,0x00ca0094,0x00ff010b,0x014c0133,0x01ec0186,
0x01dc020f,0x01f50257,0x021701ae,0x015b0132,0x004b0134,0xfff80080,0xff6bff5e,0xfe54fef9,
0xfdd0fe24,0xfd90fda4,0xfd93fd75,0xfe02fdee,0xfea2fe09,0xfee5fea9,0xff17ff1f,0xff51ff5b,
0xffc4ff77,0xffecffce,0x004b002e,0x00dc00a3,0x00d300ac,0x00d80112,0x01730160,0x01ff0157,
0x01e801ed,0x01ff0244,0x01f101dd,0x01790177,0x00ad0130,0x004a00a2,0x003c005f,0xffb9ffaf,
0xfef0ff39,0xfe29fec9,0xfea0fe8f,0xfea9fe4e,0xfe8efebb,0xfed3fec4,0xfedbfece,0xfecefec9,
0xfec6fedd,0xfefffece,0xff12ff05,0xff8bff69,0xffefff81,0x0024fff6,0x00ec00ab,0x01a8013e,
0x02510204,0x02520274,0x026a0275,0x01e50203,0x011c0178,0x00c7011f,0x007f0071,0xffcf0034,
0xff56ffd7,0xff08ff20,0xfeb9fea1,0xfed7fec7,0xfed7fec8,0xfecefed6,0xfe98fec7,0xfecefecc,
0xfefafec6,0xff38ff07,0xff6bff5b,0xffb2ff9f,0xffebffbf,0x00170007,0x00af0061,0x014300f1,
0x0194016e,0x01ba01dd,0x01c801a6,0x0138015c,0x00850121,0x00770072,0x003d0046,0x0010fff1,
0xffb20017,0xff90ffbc,0xffb5ff86,0xff7dff73,0xff8fffd2,0xff90ff63,0xfef5ff14,0xfe85feea,
0xfeccfeb0,0xfeb1fe7e,0xfe99feae,0xfeebfef5,0xff44ff19,0xffc5ff56,0x000dffc5,0x00b6007d,
0x01460117,0x01cd017b,0x01d501d5,0x021b01e2,0x018e01ef,0x018f0195,0x0115014c,0x00f000fd,
0x009900dd,0x00630045,0xffd9001c,0xff95fff6,0xff7affa8,0xff4cff41,0xfec8fee9,0xfe29fe9e,
0xfe13fe26,0xfe31fe01,0xfe30fe10,0xfe92fe94,0xff27fece,0xffa6ff32,0xffe4ffca,0x006d0038,
0x00a20092,0x00f300e1,0x010800ef,0x00fa00f0,0x00e000fa,0x00dd00e1,0x00d800ce,0x00bc00c4,
0x00c700cc,0x00b600bb,0x009d00c0,0x009a0083,0x00750061,0x0044006e,0xffef004a,0xff92ffd4,
0xff38ff3b,0xfe9dfee2,0xfe83feb5,0xfeacfe8d,0xfebbfea1,0xff15feeb,0xff44ff3e,0xffa7ff78,
0xfff0ffc7,0x004c000a,0x00660068,0x00b700b4,0x00d600c4,0x011800b9,0x00ff011e,0x012b014f,
0x01780156,0x01480137,0x00ce0108,0x005f00bc,0xffde000a,0xff89ffa3,0xfee1ff21,0xfe87fedd,
0xfe5ffe5a,0xfe2bfe29,0xfdfbfdfe,0xfe5dfe74,0xff2afe99,0xffa6ff3e,0x00140017,0x00bb0078,
0x013d00c4,0x013a014c,0x01800198,0x01a8017b,0x01680151,0x0109015c,0x0115012b,0x00e100e9,
0x00d400df,0x008100b2,0x002d002f,0xffc90016,0xff50ff95,0xff12ff31,0xfec8fec3,0xfe91fe93,
0xfe89feba,0xfeb9feb3,0xfeddfea4,0xff07feed,0xff7aff60,0xffb6ff85,0xffe1ffcd,0xfffafff0,
0x001c0014,0x002e0032,0x004c004b,0x00730063,0x00900070,0x009a0098,0x00af00c7,0x00ea00db,
0x010800d9,0x01290121,0x010b010e,0x00c000f9,0x00510095,0xfff00016,0xff83ffbf,0xff5aff71,
0xff4aff39,0xff08ff36,0xff1cff29,0xff49ff1a,0xff73ff5a,0xffc2ffa2,0xffe5ffce,0xffe1ffef,
0x0006ffeb,0xffe1fff3,0x00200010,0x004b0049,0x00b00076,0x00b6007a,0x007c00c0,0x008d00ac,
0x00890068,0x003b0042,0x0019005a,0x00010003,0xff84ffbc,0xff3bff72,0xff51ff2e,0xff3cff36,
0xff8dff69,0xffa2ff78,0xffd9ffbf,0x0001ffec,0x003d0017,0x006c005b,0x009d008d,0x007d0083,
0x003e0067,0xfff10024,0xfff0ffe5,0xfff8ffc2,0xffccffec,0xfff30011,0x0016fffd,0x0017fff5,
0x0003001b,0x00030003,0x0001000c,0xffe5ffe7,0xffbcffd3,0xffa7ffd9,0xfff6ffad,0xfff6ffbe,
0xffeb0020,0x00460047,0x00630022,0x002f0020,0x000c0033,0x001a002e,0x00360022,0xfffb0012,
0xffe70006,0xffc5ffac,0xffa5ffc0,0xffb9ffd4,0x0032ffe4,0x00380000,0x004a005f,0x00560073,
0x007d004c,0x003d0042,0x00230044,0xffdc000c,0xffc2ffc2,0xff68ff88,0xff49ff71,0xff60ff60,
0xffb5ff58,0xffc2ffbe,0x0001000d,0x002cfffb,0x000f0012,0x00030024,0x00420020,0x003d0016,
0x001e003d,0x00360050,0x004b003d,0x005d0046,0x00530046,0x00710063,0x006d0075,0x005b0067,
0x001a001c,0xffde000a,0xffa5ffdc,0xffadff99,0xff6bff51,0xff28ff68,0xff67ff7c,0xff8dff45,
0xffa1ff75,0xffe9ffe6,0x004e002e,0x007c004e,0x005f005a,0x003c007a,0x00530047,0x002d001f,
0xfffa0036,0x000f0029,0x003dffeb,0x00030015,0x00380050,0x00670047,0x005f005a,0x00320064,
0x000c0029,0xffe4ffe2,0xffb2ffcf,0xff8effa8,0xff95ff95,0xff90ff7d,0xff83ff7d,0xff86ff9d,
0xffc4ffa7,0x000affcf,0x00160007,0x00510034,0x002e0054,0x0031003b,0x003d0029,0x0024001b,
0x00190032,0x0025002d,0x004f0024,0x00250044,0x00590050,0x007c004c,0x004e005e,0x00390062,
0xfff60033,0xffc2ffca,0xff5eff6e,0xff34ff50,0xff2aff39,0xff5eff34,0xff83ff73,0xffadff8f,
0xffdcffc7,0x000f0000,0x00420034,0x0064005f,0x00a20070,0x005f007a,0x0055006d,0x004e005d,
0x005a003c,0x00420038,0x0046004f,0x0038003d,0x002e0031,0x001f0027,0x000d001b,0x00030019,
0xffddffe6,0xffafffc8,0xff69ff9a,0xff78ff54,0xff67ff53,0xff78ff8e,0xffc2ffbe,0x0000ffc9,
0x00110000,0x002e0024,0x004c004a,0x004c0050,0x003d004c,0x0029002c,0x00190007,0xfff40008,
0x0000000d,0x00330011,0x003b0015,0x0036003c,0x00330049,0x00250010,0x0016001b,0x00000003,
0xffec0006,0xffb1ffcc,0xff90ffaa,0xff7fff7d,0xff7dff68,0xff94ff8d,0xffb0ffbc,0xffdbffce,
0x000cffd8,0x000d0003,0x0029001c,0x004b0034,0x003c005b,0x004c0064,0x0047000c,0x0010002f,
0x000f0047,0x0066003c,0x0069002f,0x0049005f,0x002a0067,0x00290024,0xfffffff5,0xffb2ffd2,
0xffa8ffd4,0xff88ff95,0xff73ff6b,0xff53ff60,0xff7fff8e,0xffb7ff85,0xffd8ffb9,0xffffffe5,
0x00030012,0x002a002a,0x00390012,0x00470031,0x002c004b,0x00420047,0x00280020,0x00160019,
0x000d0022,0x00270024,0x00330017,0x002e0049,0x00380040,0x002f001f,0xfffb000a,0xfff9000f,
0xffddfff6,0xffcfffe0,0xffc5ffb9,0xffbcffc9,0xffd8ffb5,0xffd2ffd7,0x0007fff4,0x0000fff9,
0xfff40000,0xffe70006,0xfff0ffd6,0xffcfffc5,0xffcfffd8,0xffe1ffde,0xffe2ffea,0xffffffde,
0x0000fffb,0x00140011,0x0037002c,0x00460036,0x003b0040,0x00370034,0x001a0036,0x00030010,
0xfffaffff,0xffe4ffec,0xffdeffde,0xffd9ffd2,0xffc5ffcd,0xffdeffd8,0xffeffff0,0x000dfff6,
0x00080016,0x001b000a,0x00030014,0x0003000c,0x00070000,0x00030005,0x00270020,0x002c002e,
0x004a0040,0x00410031,0x00390044,0x001f0051,0x00360016,0x0005fff9,0xffcafffa,0xffb2ffe6,
0xffb9ffa1,0xffc5ffad,0xffacffb7,0xffcfffe4,0xffe7ffdd,0x0007ffd9,0xfffe0000,0x0003000c,
0x001b0017,0x0019001f,0x00270020,0x00030005,0xfffa0008,0x00050006,0x000afffe,0x00070000,
0x00070011,0x0016001b,0x0033001c,0x001f001f,0x00070010,0x00000011,0xffeafff6,0xffd9ffd9,
0xffcfffc4,0xffd3ffd6,0xfff6fff6,0x0005ffff,0x00110003,0x0016000c,0x00100011,0x0007002d,
0x000dfffe,0x00020000,0xffeafff8,0xffe6fffb,0xfff9ffd4,0xffefffe0,0xfff10007,0x00070007,
0x00150003,0x0000000d,0x0008001b,0x0017fffd,0x00000000,0xffea0000,0xffd3ffee,0xffd4ffd3,
0xffc2ffbb,0xffd8ffce,0xfff6ffeb,0x0014fffd,0x00170011,0x0036002f,0x0023002e,0x00270029,
0x001b0012,0xffff0012,0xfff10005,0x0000ffdc,0xffe1ffe4,0xffdefffd,0x0000fff6,0x00070001,
0x00100007,0x0003000a,0x00000003,0xfff9fff8,0xffe1ffe9,0xffd4ffec,0xffd4ffc0,0xffcfffdb,
0xfff4ffd8,0xffecffe9,0x00030007,0x00310016,0x00290016,0x0029003d,0x002e003e,0x0022000d,
0x00030011,0xfff00000,0xffdcfff6,0xffdeffd4,0xffd8ffc5,0xffd6ffdd,0xffe2ffe7,0x000b0001,
0x0006fffb,0x00010008,0xfff90003,0xffe9fff3,0xffe2ffe4,0xffdcffd4,0xffcfffd2,0xffe7fff0,
0x000bfff5,0x002effff,0x0036002a,0x005f0062,0x00690055,0x006e0071,0x004b0063,0x00400046,
0x001c0036,0x000b0012,0xfffdffff,0xffe5ffec,0xffd2ffde,0xffc2ffcd,0xffcaffcd,0xffe6ffd3,
0xffd4ffcd,0xffb7ffd8,0xffcaffc2,0xffb2ffb7,0xffb4ff9f,0xffa6ffb7,0xffc0ffbc,0xffe4ffd3,
0x0008ffea,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_25_standard_DRUMS_quintoslap[1536] = {
0x00000000,0xfffb0005,0xffd6001d,0xff870056,0xfe6100e6,0xf63b035f,0xea9bfaba,0xf20e0298,
0x02dae633,0xf7e5f545,0x06f3f734,0xf6770a0a,0x09b21dc0,0x2b7d1e0e,0x31081310,0x1ed52862,
0xef1bea18,0xce48fec6,0xd5d6bef0,0xab37aa8e,0xd923d659,0x2ea9136a,0x4d5dc0a2,0x324a5b91,
0x4b38720a,0x720a3e23,0xc7dcd317,0x8dfd6481,0xc0e3ce55,0xfd418dfd,0xd39f9d6f,0xb973ea91,
0x720ac0e2,0x4f380d02,0x44ec5750,0x3fcf720a,0x1b7a6181,0x10f3fe4e,0xc4f991e0,0x8dfd97e2,
0xdb11ce34,0xfad48dfd,0xfc651039,0x3b3f540e,0x720a37fd,0x48174848,0x015f21a0,0xd20b0dd9,
0xfaccc6a5,0xe433b2cd,0xb82ff9eb,0xf288f69c,0x13c5e077,0xeacbe2c2,0xde020e4f,0xf08ae941,
0x0449ee45,0x06a7fd70,0xf9ab0b11,0x29720ecb,0x11400360,0xfaec0cd0,0xe076fac1,0xf5c503e1,
0xfd3be0b3,0xf3fef79a,0xf22ff92c,0x01c7ed49,0x0233fc52,0x1a9b0b3a,0x1a4017b6,0x173511c8,
0x10e21f8c,0xfcf30b1d,0x0935ee82,0xe422ed9f,0xe00f0ee6,0x0ad8f5ef,0x038ceb3e,0xf6fd0ca7,
0xfe0313eb,0x17d90524,0x01a6008c,0x0d320dbe,0x0dd40fdf,0x01fbfad7,0xfd18f7a7,0xee20f9c0,
0xf425f4c1,0xff74ef4b,0x00b5f827,0x03ea0a53,0x071d108f,0x111e0d49,0x05c40a2a,0x00a8070b,
0xf90afc83,0xeeaeed81,0xec7beab9,0xfeb0e5c2,0x0556fe1e,0x0f290ffd,0x1f5f1d88,0x0c1c10e7,
0xfe590388,0xf406f239,0xecc0f166,0xee5aed6c,0xfc09f5b6,0xfee5f904,0x06ee0e4d,0x117c14d7,
0x0e2a0b0a,0x054f080a,0xf9c70373,0xf7d1f2d9,0xfa62f5fe,0xf5f6f6ce,0x032afe9e,0x07a7015d,
0x0538074c,0x00670dd0,0x0b800697,0x04a302a0,0xf87500cc,0xff05f8c4,0xf809fa3b,0x0094fd5c,
0x0c08fee0,0x0240011d,0x0f7f0726,0xff4c011e,0xfa780d07,0xfc690406,0xfe41fe23,0xff74f4b6,
0xf4aafa44,0xfa33fa4d,0x0932fb1d,0x04dbfaba,0x008a0b1b,0x040d081a,0x04dc013e,0x03aff2e8,
0xf6aefeb9,0xf9c4ff67,0xff8cf7d1,0x007cfcf8,0x00650065,0x03c103a9,0x02140d79,0x06a10799,
0x07070108,0x0037fed3,0xf8180263,0xfe2ffd21,0xfef1f54b,0xfd8cf85d,0xfdeafda0,0x02b60373,
0x09d102a0,0x03ff0a78,0x06820329,0x052b03a1,0xff1cf9c0,0xfd0dfe5a,0xfbe5facc,0x011afce7,
0x02f1fb65,0x03a8ff32,0x0535059b,0x052d03be,0x022907bd,0xfc43fceb,0xfb4ffabb,0xf10af3da,
0xf316fc2d,0x0150fb08,0x0ef8fb0d,0x0b7bfe19,0x0c060b74,0x05670ac5,0x023507fa,0x00ecfb56,
0xf852f88d,0xf3b1fa04,0xf88afc01,0x0217fbf0,0x060001c0,0x0b93008f,0x088c086e,0x01e30426,
0xffeb0bf0,0xfff3fa95,0xfdb0fa29,0xf73efde3,0xf9a9fdef,0xfeb0fac8,0x028df641,0xfe9ffda5,
0xfd1f0415,0x06cb0267,0x02b60378,0x070908fd,0x05de0661,0x003d0364,0xfa1bfb00,0xf429f600,
0xf47cfa81,0x0403f36b,0x0403ff14,0x03610942,0x0abe0c24,0x062a0611,0xfeba0226,0xfbd80601,
0xff73fd54,0xff4cfb65,0xff0afd9c,0xfd77023c,0x0368046e,0x01e10477,0x06a9ff15,0x0166fe62,
0xff1a00b6,0xfb9e0004,0xff340228,0x0275fd05,0x00edff8a,0x0014004a,0x02f106d9,0x050afbfd,
0x0121fed3,0xfbac0179,0x0007fce2,0xffc1fac5,0xf8d00034,0xfcb8fd79,0xfdfcfd62,0x0106fd3d,
0x020f01ad,0x04070371,0x03be0462,0x025f01db,0xf70800ec,0xf6bfff8f,0xfc73f7b9,0xfcc4fb2d,
0x033402d9,0x086e064a,0x057205b2,0x00ce04fc,0xfdb0fd7d,0xf7effcab,0x0114fd9b,0x00d8fd60,
0x00740223,0x02d70434,0x02c201de,0x01fe0094,0xfe13ff98,0xfe6a0076,0xfd1bfc84,0xfdef0152,
0xfd4400e9,0x0030034e,0x036cfda0,0xfeb1fcdd,0xfadafe48,0xfc60fcb3,0xfcc2fdef,0x02e90166,
0x013600eb,0x05580020,0xff220119,0xfb0201a6,0xfb98fb33,0xf8d5f75b,0xfb8df693,0xfb17fa1e,
0x03c60161,0x08ef04d4,0x051c06fc,0xffa906ae,0x00d001bc,0xff63f9e5,0xfbc5f97e,0xfa91fc74,
0xf9a5fe43,0xfe60fe06,0x0010fe2f,0x018802d2,0x04f20368,0x06f40549,0x02fc00ef,0x00df031c,
0xfe60019d,0x0123fe41,0xfd0afd9f,0xfd26ffff,0xff41fe8e,0xfe7cfff8,0xfdcc0223,0x03080272,
0x04290205,0x06a5029b,0x052d02db,0x01a204d3,0xff5f0095,0xfb94fce2,0xfb20fd16,0xfbb6fb4e,
0xfe1cfd9d,0xff0bffaa,0x02d00053,0x02bf0150,0x03d9013f,0x0200039b,0x03340188,0xfcf4ff2c,
0xfd53fe59,0xfe3bfa1e,0xfab6fbfa,0xfd53febe,0x0198fede,0x02d50171,0x033c03d8,0x02ea0283,
0xfecb00b5,0xfd71014d,0x00a8fb3b,0xfe56fc8a,0xff64feff,0xfef601ab,0x015f01ac,0x0323fe7d,
0xff6ffd27,0xfd6200b0,0xff6400a1,0x007e0059,0x00a3ff26,0x004dfec1,0xffed012b,0x034e0184,
0x00a1028f,0x00d40098,0xfe3afea9,0xfd7afafa,0xfb78fdb4,0x0098ff44,0x03be00f3,0x038a0194,
0x01cd026b,0x018702f7,0xfffe0033,0xfd820132,0xffc8fef1,0x01a201bd,0xfefcfe51,0xff14019d,
0xfeceff0f,0xfcc9fc58,0xfdd6ff45,0xfe8affaf,0x019702bd,0x04180476,0x05fd0287,0x00a801c9,
0xfb9d00cf,0xfde2fce1,0xfbbcf91f,0xfc00f8ee,0xfc05fc3d,0xffe60188,0x042d013f,0x036103e3,
0x03340460,0xfff80286,0xfc5800af,0xfd35fb1e,0xfd12f9b8,0x0000fca4,0xffccff3e,0xff9104c9,
0x02b4042d,0x02eb0004,0x0090fef5,0xfc990013,0xfbe301a3,0x0096fed1,0x00a5fd89,0xff6fff0b,
0x00d702ab,0x032002f6,0x050200e7,0x009a009e,0xfe780280,0xfdd4ffc7,0xfd58fcd4,0xfefefcb3,
0xfe1cfd30,0x008b0131,0x01d50488,0x054f031c,0x03ed017c,0xfebf0090,0xfddaffd8,0xfdb9fd17,
0xfbe0fca5,0xfef4fe93,0x00bcfd68,0x01a40113,0x014bfed4,0xfeaf0206,0x005102b6,0xff140011,
0xffa3fdf2,0xfe93ff5a,0xff45ff21,0x0051feca,0x00ec0231,0x030d00a1,0x000a0047,0xffd2ffc3,
0xfd6cfe4e,0xfea3fe14,0xff58005a,0x027301aa,0x031301c7,0x01880249,0x00c60205,0xff0bffd4,
0x00a2fec4,0x0038fdaf,0xff99fff9,0x00ef00cc,0x013d00f2,0x0160028f,0x01a600c6,0x00060198,
0xfebdfeff,0xffb8ff26,0x0115fd8a,0x00cefec5,0x02820228,0x023b038f,0x03220242,0xffb0015d,
0xfdc60199,0xfbf8fc70,0xfd45fd06,0xff55fd58,0x015bfeeb,0x029402db,0x043103aa,0x0138007d,
0xfdb70021,0xfd6affb1,0xfbbcfe34,0xff73fd56,0xff07fecc,0x00590277,0x01f2ffce,0x00abffab,
0xfebc0124,0x0160ff3c,0xffd8fe97,0x0072fe2a,0xfe3c0155,0xfff900aa,0xffe10038,0xff99ff46,
0x00320141,0x0001ff9e,0x0091ff66,0xff010081,0xffd5013d,0x012d019b,0x0244ff21,0xfe310121,
0xfe070069,0xfdc7ff15,0xff51fd5f,0xffbafdd4,0x007c00bd,0x008d0129,0x023301ab,0x00c600a2,
0xff660198,0xfeb0fe5c,0xfc57fe6b,0xfcdbff56,0xff71fd1e,0xff30fdf5,0xff690019,0x01660106,
0x0172002f,0x01280136,0x010c0025,0xfdf7ffcd,0xfd4cfeac,0xfda1fd14,0xfee5fcf6,0xffa6fdc6,
0x002c00e8,0x012201bc,0x028200d8,0xffa8fffd,0xff610081,0xfe9cfe62,0xfedafe0e,0xfe79fde7,
0x003b0056,0x00daffb4,0x01cd0136,0x00d701e0,0x013a01fd,0x01030096,0xff1ffdb7,0xfdb5fe73,
0xfd17ff72,0x0027ff4a,0x01a2fec2,0x025901f5,0x02460243,0x02aa00d9,0x0018010b,0xff32005e,
0xfdd4ff88,0xfe28fe79,0xff67fe6f,0xfef1ff07,0x007f003b,0x013e00ac,0x01990091,0x00860290,
0x01a10004,0xff7c0028,0xfe7f00a3,0xfef10074,0xffc9ff1a,0xffeaff03,0xfe9cfeeb,0x00040018,
0x0046ffd8,0x009a0047,0x013300b2,0x00530144,0x00cc00be,0xfee8010c,0x0068ffad,0xfdc7fea8,
0xfe17fe9a,0xfeccfe85,0x00850062,0x0195010b,0x025201fd,0x017b0172,0xff28010e,0xff38fff9,
0xfecdfe9a,0xfdfafe69,0xffde002f,0x0212ffa2,0x00b001af,0x0114020e,0x009502b6,0x023500ca,
0xff47fed6,0xfe8effdb,0xfe73fe79,0xff5fffe1,0x0186febb,0x00b0fffc,0x009101f0,0x01e7019e,
0x01290079,0x00930085,0xfef50105,0x0035ffbf,0xff70fe9d,0xffb9fefe,0xfefb0043,0xffa2002e,
0x0184ff21,0x011dff27,0xff72002e,0x00820280,0x0130005e,0x006cffc9,0xff970090,0xff01fece,
0xfedcfe58,0xfe56feef,0xffdeffe8,0x0046ff78,0x00bbff35,0xff0b00fa,0xff7e0151,0x00d70014,
0x007cff44,0xff88001a,0xfe4b0056,0xff62fef5,0xff6cfdd5,0xfef4ff4d,0xffe7009a,0xffdf0071,
0x00be0132,0x010400ab,0x005c0067,0xff71ffeb,0xfeb20050,0xffa4feb9,0xff91ff5b,0xff3dffb8,
0xffe3018e,0x01d900d0,0x0150ffe6,0xffe700d3,0xfef50027,0xff7fffaf,0xff60fe37,0xffcbff4b,
0x004aff36,0x00e3ffbf,0x008c008d,0x001500e3,0xffbd0020,0xff47ffb3,0xfef5ff64,0xfedafef9,
0xffc5ff07,0xffabffc5,0xffe80017,0x002affd9,0x000cffe7,0x00150003,0x00690056,0xffbf0139,
0xfffeffb0,0xff53ff48,0xff08ff2b,0xfef9ff7d,0x0081ffcd,0x0056ffe2,0x009d0017,0x01020056,
0x005f00c2,0x011a011b,0x008c0083,0xffe10081,0xffb90088,0xff8bff4d,0xffdbff1d,0x001cffe1,
0x0102008a,0x01ea012d,0x01a80169,0x01e301f9,0x013c00ce,0xff4600eb,0x0001fef6,0xff29fe32,
0xfe54ffc9,0xffb400fb,0x023100a2,0x016c00ac,0x01160154,0x0015016f,0x010e001f,0xff68ff07,
0xfef8ff01,0xfe77ff5a,0x000bffd8,0x0088ffb4,0x00bd00fe,0x00d5017d,0xffd70138,0xffb90051,
0xff43fef1,0xffa6fe5a,0x0015fe56,0xff1ffeea,0xff3600bd,0x00c800d9,0x00cd0136,0x00f8fffe,
0xffab00a2,0xffc5007e,0xff6affa9,0xff98ff14,0xff2afe2f,0xffd1feb9,0x0037ffab,0x009f00e0,
0x010e012d,0x004501a3,0x0033010c,0x000f005e,0x0015ff7d,0x006bfefc,0xfeefffaf,0xffd60019,
0x0023ffff,0x0051ff96,0x000700b3,0x013e004c,0x00a9000c,0xffc80114,0xffcf00f1,0x0043fff0,
0xffabffd4,0xff0aff7c,0xfeabfff4,0x0008ff7d,0xffe3ff39,0xffad000e,0xfffb00cf,0x010b0014,
0x00daff96,0xffea0050,0xff760066,0xfeedfed3,0xff4bfea9,0xfe2efecf,0xff6fff66,0x004cfff4,
0x0098003c,0x01140076,0xffe70061,0xfef0ffea,0xff2fffb4,0xffacfea5,0xff7bfece,0xff24ffb0,
0x002f0016,0x00e2ff70,0xffe8ffd5,0xff350110,0x004d0021,0x0062ffea,0xffd8ff73,0xff9aff6a,
0xfe93002e,0x00340050,0x00aa0016,0x00b90007,0x009afff9,0x0057006e,0x003400af,0xffab0114,
0x00750023,0xff85ff88,0xffbc0055,0xffe7001f,0x00d5ff67,0x0010006c,0x00040160,0x00a20044,
0x00dcfff8,0x004efff4,0xff320035,0xff5dffe3,0xff0dfefa,0xffc3ff84,0xffb90083,0x007c009c,
0x00c600a5,0x0039009e,0x00210075,0x000dffe8,0xffe3ffa7,0xff08ff11,0xff06ff48,0x0015ff24,
0x0102ffa7,0x00950104,0x014a01ce,0x012a012a,0x0070003d,0xff55ffa2,0xff18ff5f,0xff6cff0c,
0x00a2ff31,0x0032ffc3,0x007500de,0x01ab00df,0x01240096,0x00f10066,0xffac0097,0xfff80084,
0x00b1fff4,0xff86ffaf,0xffc5006b,0x0054ffea,0x012fffc1,0x004f008c,0x0093017b,0x00d700ba,
0x00470029,0xffd9008b,0xff4c0043,0x004b005e,0x0007ff4d,0x00510004,0xffcb00b1,0x005e00b6,
0x00320007,0xffe20048,0xffa2000c,0x0027ffc1,0xfff0ffac,0xff59ffe6,0xffef001a,0x00ccff7b,
0xffd1ff60,0xff6f004f,0xff550034,0xff7fff99,0x0062ffb8,0x003aff46,0xfff0ffc1,0xffe600ba,
0xffd6fff9,0xff39ff95,0xff78ff60,0xff6aff78,0x0015ff7f,0x004bffcc,0x00feffbd,0xffa70029,
0xffef006b,0x0016ffe2,0x0037ff87,0xff7fffb9,0xffbe0087,0xffc1ff96,0x002a0019,0x0031ffad,
0xff9ffffd,0xffeb0011,0x00870030,0xffe8ffd6,0xfffa0091,0x0078ffcc,0xffc30008,0xffe4000f,
0xffd1002e,0xfffa0006,0xff47ff55,0xff8fffa8,0xfff5ff94,0x0072fef3,0x0046fffb,0x001cfff9,
0xffdd0086,0x0034001c,0x0004ffe6,0xff7bffac,0xff75ff84,0xff55ff61,0xff69ffac,0xffdfffc9,
0x007cff92,0x004aff86,0x004b00e4,0x00ba0062,0x0081001e,0xff3b0047,0xffb8ffe1,0xff5aff70,
0xff87ffa9,0xffcd0011,0x00b20055,0x00b60050,0x00740068,0x0033003b,0x000c0046,0x001a006c,
0x0005ffbc,0xff9e0019,0xffbaff85,0xffe3001f,0x002e00d0,0x011efffd,0x00bc0057,0x002c0028,
0x000500a8,0xffd8ffed,0x002bffb5,0xffe0ffdf,0x000c0048,0x00a6ffe4,0x00380090,0x003e0062,
0x001cffff,0xfffc0004,0xffcdffe9,0xfffe000c,0x0067ffbc,0xffd00015,0x000700de,0x00aa000c,
0x001effc5,0xff9b0021,0xfff20020,0x0008ffd8,0xffda0011,0x00050005,0x0067000c,0x004d0044,
0x008c0076,0x00050004,0xff8b005a,0xffac0008,0x0034ff90,0x0018ffd4,0x00bc001e,0x0025003f,
0x002a00aa,0x000c0033,0x00540065,0x0000ffda,0xffe6000a,0x001affe2,0xffbaffdb,0x00380004,
0xff8b002c,0x00870019,0x00620034,0x002c0068,0x001f008a,0xfffc0066,0xffffff88,0xffe7ff9d,
0x002fff35,0xff3fffd6,0xffcb0028,0x0032005e,0x0011ffe8,0x00470031,0xffa30085,0xffebffec,
0xffd5ffe7,0xffbeff7c,0xff50001e,0xffbcffcd,0x000cff6a,0xff7b0004,0x0038fff4,0x0017ffd8,
0xffc5002b,0xfffffff9,0xff95ffe3,0xffe4ffb1,0xffc9ffe4,0x002fff58,0xff4b000a,0xffa80001,
0x00270020,0x006fffd9,0xffefffdf,0x002a008e,0x0033ffa3,0xff78ffdf,0xff8cffec,0xffcdffb2,
0xffd8ffea,0xffda0047,0x0038008a,0x00c5ffab,0xffe9ffe2,0xffd4007c,0xfff0000c,0xfffc003f,
0x0041ff84,0xffbbffd6,0xffcb0005,0x001c0030,0x000ffff0,0xfff60004,0x0002003d,0x000dffff,
0x00190022,0x000dfff9,0xfffb002f,0xffc9000f,0x0023000c,0x0001ffda,0x0007ffcd,0xffea0022,
0xff78ffda,0x0020fff9,0x0010ffd0,0x0038fff6,0x0015fff0,0xfffa0008,0x0005000b,0x00320003,
0x000c0044,0x00310002,0xff97ffe8,0x0022fff0,0xffddff8f,0x00200004,0x00160050,0x00d5001e,
0x00810046,0x001e0062,0x005d0055,0xfffd0016,0x0039fffd,0x0028ffeb,0x00020067,0x0054008a,
0x00810051,0x00a30001,0x00080026,0x001e0051,0x00050068,0x00ad0010,0x0041ffd6,0xffaf0081,
0x00510071,0x00300022,0x0078fff9,0xfffe001e,0x0010003c,0x001e000d,0x0003002a,0xfff9000f,
0x0002ff96,0xfff30010,0xffed0002,0x0008001c,0x001afff0,0x0007fff5,0x00050001,0xffe10018,
0xffdf0025,0xffc40023,0xffd1ffd6,0xffa7ffbf,0x0006ffd1,0xffe9ffe3,0x004cfffd,0x001fffd1,
0xffc50033,0xffdd002a,0x000afff9,0x0006ffc5,0xff99004b,0xffe60001,0x0014ffc9,0xffe4fff1,
0x000a0025,0x0022fff9,0xffe4fff0,0x0004fff2,0xfff3ffeb,0xfffa0032,0xffdeffdd,0x00030010,
0x000c002e,0x0027ffdf,0x0017ffe8,0xffaaffbb,0xff92ffdf,0xffebffff,0x0010ffb3,0x00010002,
0x0017fffe,0xffbe002b,0xffe9000c,0x003fffcc,0xffddffbd,0xffb0ffa1,0xff910010,0xfffbffe0,
0x0043ff9e,0xffdfffcf,0xffb80029,0x0017ffef,0x000dff7b,0xffcbffe6,0xffa70008,0x00210001,
0xfff1ffb2,0xffc50000,0xffe60037,0xffffffdb,0xfff6ffd2,0xffa8ffa2,0x0021ffbd,0xffc5ffc5,
0x0025002a,0x001c003c,0x00440006,0x0038ffcf,0xffcf0001,0xfff9ffec,0x0017ffd2,0xffc6ffd5,
0xffc60044,0x001e000e,0x0022fffd,0x0059002a,0x004d0019,0x0029000c,0xffeb001e,0x002a0003,
0xfffdffe2,0x0019ffde,0xffcb0025,0xffed0053,0x0066005e,0x00a2ff91,0xffd6fffc,0xffcf004a,
0x0014000b,0x0057ffde,0xffd70015,0xfff80058,0x0062fff0,0x0006fff0,0xffd10025,0xffd9007c,
0x0057ffdb,0xfffbffcb,0x0004000e,0xffda0028,0xfffb0053,0x0044fff4,0x0025ffe3,0xfff30026,
0x0019004d,0x0026fff8,0xfffaffde,0xffd40013,0xfffd0006,0x002e002f,0x00450025,0x00200029,
0xffe40060,0x000a0004,0x00540018,0x0020ffd6,0xffdd003f,0xfff90014,0x00070008,0x0059fff8,
0x001d001c,0x000800a6,0x0021002e,0x00560002,0xffd0fff1,0xffc7003e,0x00200013,0x0033ffde,
0xfff30006,0xffe30047,0x00440019,0x0030000f,0x0029ffd7,0xffdb0001,0xffea0027,0xffffffe6,
0xfffcfff2,0xffc3001c,0x000effcb,0xffe8ffe2,0xfff80008,0x000d0005,0x0015ffdf,0xffaa0004,
0xffb20016,0xffebfff4,0xfff9ffb0,0xffe4fffd,0xffe1ffb6,0xffcd0011,0xffe4ffea,0xfff3ffdf,
0xffdbffe0,0xffcf0031,0xfff10005,0xffffffef,0xffddffa9,0xffabffe8,0x0041ff99,0xffd7ffdf,
0xffe6001a,0xffda004d,0x0029fff9,0x001affe1,0xffb8fffb,0xff9f0019,0x00260004,0x0018ff4c,
0xffe1ffc8,0xffc60020,0x00330014,0x0022ffdf,0xffd10067,0x0001002a,0x0017ffc1,0xffdbffa6,
0xffb6ffe0,0xffdbffbf,0xffffffea,0x00030001,0x0007000e,0x0026ffff,0xffff0013,0xffd5000a,
0xffd2fffe,0xfffcffe2,0x0003ffc8,0xffbdfff1,0xffd80026,0x000e000f,0x000efff1,0x00040011,
0xfffc0017,0x00020026,0x0013ffd1,0x00080001,0xffeb0008,0xffeb002c,0x003c0015,0x0001fff4,
0x000fffea,0x0014001e,0x0015ffd1,0x00370025,0x001d0023,0x003c0041,0x00450005,0xffe1000d,
0xfff0003b,0x0003fff3,0x002e0004,0x00100001,0x003c002a,0x000b0038,0x00550030,0x00420014,
0x00220037,0x001afff4,0xfff90007,0xfffcffff,0xffde000b,0x00440017,0x002f0010,0x001f0055,
0x000c0033,0x002a001d,0x00130020,0x0013fff0,0xfffcfffe,0xffe40005,0x00010015,0x0032ffe3,
0x0014000f,0xfff00015,0x001e0026,0x0002002a,0x0026000e,0x0011fff8,0xffe80011,0xffcc0001,
0xffd1000f,0x00290008,0xfffdfff0,0x0010000f,0x00080030,0x0021fffd,0x001d000a,0x0007fff8,
0xfff9000c,0xffef000c,0x0004fffe,0xffd4ffd8,0xffdffff4,0xffff000c,0x00190004,0x00390016,
0x0007fff3,0xffe80021,0xfffcffe8,0xffe9ffa6,0xffa7ffc6,0xffd10019,0x0013ffe3,0x0022ffd0,
0xffe0fffd,0xfff40031,0x000afff3,0xfff90001,0xffcfffd2,0xffb5ffcc,0xffb4ffc9,0xffe6ff97,
0xffe8ffcb,0x000dffeb,0xfffdffff,0x001cffec,0x0002fff9,0xffc7fffe,0xffaf0001,0xffdaffe0,
0xffd1ffa8,0xffbcffd1,0xffd2ffce,0xfff8fff0,0x0025ffce,0x00070001,0x00040004,0x00030004,
0xffef0004,0xffe9ffeb,0xffbfffce,0xffdaffcd,0xfff2ffd1,0x000bffea,0x000a0002,0x00220001,
0x0038000a,0xfffe0003,0xfff10031,0x000f0015,0xfff8ffe0,0xffd7fff3,0xffeaffe9,0x000bfffd,
0x001e000d,0x000d002a,0x004d0043,0x0035ffef,0xfff30011,0xffe20033,0xffe8000c,0x0023ffe0,
0xffedffcf,0x00060027,0xfffb000c,0x001d0043,0x00230011,0x0011002a,0xfff4002b,0x0015000a,
0x0003ffbd,0xffdafff0,0xffed000d,0x00070010,0x00130013,0x0021003f,0x00130028,0x0015002c,
0x001f0004,0xffeffff4,0xfff8001a,0x0010fff6,0x00040023,0x00340001,0x0010000f,0x003b0026,
0x0015001d,0x00220034,0x0022001f,0x00160029,0xfffd0019,0x00010015,0x000e0001,0x00380015,
0x000e001a,0x0021005e,0x002a0010,0x001a0021,0x0027002f,0x00100021,0x00080033,0x001e000c,
0x0018ffeb,0x0002fffa,0xfffb000c,0x00020008,0x00330007,0x0014000c,0x00160018,0x00050023,
0x00070006,0xfff6ffc5,0xffd4fff4,0xffc2fffc,0xfff00004,0x0002fff9,0xfffd0001,0x0004fff8,
0xfffb000f,0xfff9000c,0x00100003,0xfffcffbc,0xffe0ffda,0xffbbffd1,0xffd2ffe0,0xfffcfff0,
0x000bfff4,0x00040005,0x0008000f,0x000c0000,0x000cffe1,0xffc5fffe,0xffe1ffd9,0x0013ffc1,
0xffd9ffdf,0x00010004,0x0007fff9,0x00010007,0x001f0019,0xfffb0005,0x0002002c,0xfff1fff8,
0x000cffcc,0xffd8ffc2,0xffe7000c,0xfffd0010,0x0015ffeb,0x0005ffea,0xfffe0001,0xfffc000b,
0xfffa0008,0x0006ffed,0xffe8ffe3,0xffd0ffef,0xffd7ffd6,0xffdaffd8,0xffe6ffd0,0x0015ffd5,
0xffeb0007,0xfffd000f,0xfffe000c,0xffe0fff4,0xffdaffd0,0xffbcffd5,0xffcdffe6,0xffe3ffd8,
0x0005fff6,0x0003fff4,0x00010007,0x0011000b,0x0007000c,0xfffc0002,0xfffdffdb,0xffd7ffea,
0xffe0ffe9,0xffff0001,0x00040005,0x00040004,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,

};

const uint32_t sample_26_standard_DRUMS_quintotone[1664] = {
0x00000000,0xfff00002,0xff7a0037,0xf8530117,0xeea507ca,0xec40fde9,0x0f00e6a4,0x0225ca87,
0xd26cf9dd,0xc4451eae,0xd27606ff,0x12cef026,0x2107e020,0x2c10e90c,0x00412590,0x184a30b5,
0x350f3663,0x49243671,0x4cfa3d70,0x48004a4a,0x3e8e4a11,0x2a4e3b53,0x116d19e3,0xeaecf747,
0xccf8d7ea,0xa1fcb858,0x85ed9d8e,0x8d288955,0x900c88c6,0xa3748de4,0xc287aedb,0xe61dd672,
0x1aa60677,0x3ef12f5f,0x5e8e4f75,0x69466487,0x62d06b2a,0x55c55b97,0x34014531,0x109322bb,
0xf6aa0440,0xde06ea60,0xd0e1d387,0xcb8ccdd9,0xca7dc9ae,0xcd14ccc9,0xcee6cf77,0xe04cd72c,
0xf038e77c,0x0501f5a3,0x1d0013e8,0x2d6425d1,0x35f73353,0x399a3a0c,0x35ac38b7,0x31213496,
0x1e8827c2,0x01f1101e,0xe660f3a5,0xcbb5d5d4,0xb47fbdd6,0xaa72b0f7,0xb321af54,0xca2dbc2b,
0xe5aed802,0x06baf84b,0x278d150c,0x469333d7,0x552f4e93,0x4cef5422,0x410b4963,0x31713cd7,
0x1c162960,0x02a30dbe,0xe6fef0f1,0xd1c1da9a,0xbf1cc7cd,0xb2afb9cd,0xb63cb477,0xc727be06,
0xd6d7cc0f,0xe2a5db9f,0xf469ec7e,0x0add0148,0x2247171b,0x35492a96,0x465b3e5d,0x51bb4cbd,
0x54065578,0x45104f4d,0x2a77367f,0x0e511d17,0xeba2fdc1,0xc99edbcb,0xb1fbbcd4,0xa488a5bf,
0xa279a0c4,0xacf0a927,0xc565b7f2,0xe2dbd316,0xfe06f064,0x1a660c9e,0x33db27cb,0x49304250,
0x52534f2d,0x4e634fce,0x410b4725,0x33843bba,0x214b2a88,0x0b9d16ab,0xf6b8015a,0xe401ede5,
0xd19edb47,0xc095c6f0,0xb4dfb95a,0xb153b1a3,0xbaf0b5e3,0xcdc1c481,0xe774d949,0x05c9f695,
0x21ec1601,0x391a2e0d,0x43dd3e4f,0x46914419,0x3e414354,0x2fd1394b,0x1a3c272b,0x01430e98,
0xe9edf46b,0xd851dfa7,0xcd69d24d,0xccf3cb74,0xd5d8cf03,0xe520db8c,0xf54cee0a,0x0439ff32,
0x0e1d0996,0x13661090,0x166e15db,0x19151759,0x1c6e19a9,0x1b471b6e,0x15d618de,0x0d3a1312,
0x043309df,0xf73ffd97,0xe98defd4,0xdc40e346,0xd488d907,0xd6bdd437,0xdb44d677,0xe423de1e,
0xf666ed53,0x0c0702dd,0x233117f5,0x36a92d14,0x43583ead,0x47c44599,0x3ae44260,0x242630e9,
0x0aa7171c,0xf09bfdad,0xd8c6e481,0xc511cee3,0xbc62c0a2,0xbacebac6,0xc03dbc2c,0xcaacc345,
0xdaabd1af,0xf0fee4bf,0x082cfcbd,0x1bea144b,0x2d7027e1,0x3c6133e7,0x44e33d72,0x45764556,
0x41e54619,0x37693ffc,0x25682fe3,0x0c6e18a1,0xf158fd9d,0xd83fe37e,0xc362cd1e,0xb3c7bb07,
0xaf61af9c,0xb63ab172,0xc879bdcb,0xe1dfd45f,0xfd54f01a,0x15ec0a23,0x2aa02090,0x38813312,
0x3f5f3cba,0x3d653eb8,0x333f3989,0x23a82c9d,0x12de1be8,0x02dc09a9,0xf1fbf90c,0xe7a1ed2a,
0xe074e3d5,0xdbdddda6,0xda71da3c,0xda06d9d1,0xdcb1dac4,0xe5cde0e0,0xf2d5eb83,0x00eafa6e,
0x0fee0882,0x1c24168e,0x24622092,0x28062707,0x241d261b,0x193f1ead,0x0b26133e,0xfa8a040f,
0xec14f354,0xe1dee4fc,0xdc9cde22,0xde20ddb0,0xe69ae158,0xf2b4ebab,0x022afa6e,0x13c50b0f,
0x1e2c19c6,0x2218213a,0x2146223d,0x1c3a1f59,0x135617a3,0x08740e1d,0xfd0003fc,0xf275f89a,
0xe9a6ee13,0xe3f7e551,0xdee6e08c,0xdcfddd84,0xdd80dd63,0xe1d9debb,0xebbde6d0,0xf6b8f125,
0x04f0fe67,0x139f0bce,0x20921971,0x2ab3260b,0x31d82fbd,0x33433306,0x2e15317d,0x21e22948,
0x0eb8191e,0xf80f030b,0xe25becc2,0xd041d8ef,0xc53cc97a,0xc2f4c278,0xc8bfc4f7,0xd50dcf25,
0xe58ede57,0xf883ee98,0x0a49ff6b,0x1991116e,0x25f020c3,0x2d722aca,0x30a1303c,0x2fd530b5,
0x29ed2cd2,0x1fc82585,0x125b1980,0x03640ad3,0xf61ffc7a,0xe8d2ef6e,0xdecbe3f4,0xd748dab5,
0xd28bd47b,0xd340d1d6,0xdad2d604,0xe788e039,0xf92cf050,0x0ab802e2,0x1912123d,0x216a1d7e,
0x24c123d5,0x21f523f2,0x1b621f28,0x123d175f,0x07a30d8f,0xfd9601fa,0xf447f861,0xecfbf016,
0xea5aeb11,0xebaceaeb,0xef62ed45,0xf534f2ec,0xfd6efa23,0x02dfff1a,0x065d046b,0x09590835,
0x0b940a6c,0x0c180ba1,0x0ba30c41,0x09400a71,0x06090843,0x00d20409,0xfaacfdcd,0xf31af66f,
0xebd2ee6d,0xe79ee967,0xe7f3e7d0,0xed58ea3d,0xf5caf13a,0x002ffaef,0x0c2105a6,0x17ac11ca,
0x219d1ce3,0x2766255f,0x268e27b1,0x206723d0,0x15881b71,0x07440f07,0xf8930095,0xeaf1f1c1,
0xe057e4dd,0xda9cdbd0,0xd8e1d8cb,0xda6dd9d2,0xe0e1de50,0xe97ae4ff,0xf428ee72,0xffe2f980,
0x0a8d04d6,0x14ea1003,0x1e391a08,0x242e21c3,0x267f2550,0x25892652,0x1f6b2337,0x169d1bc4,
0x0ac51097,0xfbe302da,0xedb0f54d,0xe28be84a,0xd9b1dd3b,0xd62bd74a,0xd844d625,0xdf76db72,
0xeb08e521,0xf86af16d,0x066affdd,0x12610c5e,0x1b4b1711,0x20af1e73,0x209c215f,0x1d661f59,
0x16f41a07,0x0e911351,0x06930b28,0xfe5402ad,0xf5fbf9a3,0xf007f20d,0xed44ee59,0xecd1ecf7,
0xede3ecb6,0xefefee9c,0xf29cf15a,0xf7edf59a,0xfeb3fb17,0x05d70217,0x0bc90927,0x0f670e57,
0x0fae0f9c,0x0d9f0e64,0x084a0afe,0x01710581,0xfa2bfe5f,0xf451f6b8,0xf093f1a3,0xef98ef9d,
0xf19ff04a,0xf6c5f39b,0xfd44f9fc,0x0528014a,0x0cda0913,0x12a81025,0x16fa1529,0x1707177b,
0x137615af,0x0d8b10f4,0x05400978,0xfc6b00ad,0xf4f7f8ba,0xeefff1c2,0xeb30ed0b,0xe8abea01,
0xe7fde80c,0xe8c3e7f1,0xec42ea14,0xf2f3ef2e,0xfc31f725,0x061700f1,0x0f790b26,0x180e13dd,
0x1e321b84,0x20bc1f97,0x1fd8213c,0x1a771dd3,0x128b16c8,0x08280d08,0xfc3501be,0xefb6f5f9,
0xe51feaa2,0xddd7e166,0xda77db99,0xdcfadb0e,0xe3fbe018,0xedcde865,0xf8c3f337,0x0349fe01,
0x0cff0847,0x14a11107,0x19e11761,0x1c771b82,0x1c6a1d25,0x1a161bbe,0x1470176b,0x0cf01102,
0x04a0090e,0xfbf0ffd3,0xf360f6d1,0xeccbf01a,0xe930eb52,0xe7bee7fd,0xe841e799,0xec27e9c9,
0xf2b3ef3c,0xfb16f695,0x025cfe46,0x098c065e,0x0f4b0d16,0x12951168,0x128a1269,0x0eb910ba,
0x09270c55,0x02ec06b0,0xfde5006b,0xf9a2fb51,0xf68cf77a,0xf547f56a,0xf605f58c,0xf8cef7d8,
0xfd31fb27,0x012aff07,0x047f02a9,0x070a0596,0x08190777,0x082208f5,0x075b0851,0x05b90698,
0x025603f7,0xfe000015,0xf976fb71,0xf4cef6ee,0xf197f383,0xf024f0c9,0xf012ef94,0xf236f0a7,
0xf679f431,0xfc52f979,0x039fffe2,0x0b2e075e,0x12d10ede,0x17af1555,0x1a311990,0x199b1a94,
0x158917d0,0x0e3f1212,0x057e09df,0xfaec0045,0xf130f66a,0xe9dced57,0xe52ee6e3,0xe416e3f4,
0xe58be43d,0xe98ae74a,0xef42ec62,0xf6b7f2bd,0xff08faef,0x07f0034e,0x0fd20c15,0x15fa1321,
0x19791845,0x1aca1ab1,0x197f1a19,0x1551176f,0x0ee5125f,0x06c40b45,0xfe3702b6,0xf647fa2d,
0xeeb9f251,0xe8c3eb83,0xe5e5e6c5,0xe58fe512,0xe93be71d,0xefdbec5c,0xf85df3f4,0x012ffcee,
0x08f1055d,0x0eec0c39,0x11fd108e,0x12d61242,0x111d1214,0x0e2b0fee,0x0a200c34,0x05aa0860,
0x00d7036f,0xfcccfee8,0xf9a2faf8,0xf78df817,0xf6f0f6d0,0xf837f789,0xf9cef927,0xfc21fb30,
0xfe70fcf2,0x007bff29,0x02350190,0x03730308,0x04b0043a,0x050f0502,0x044304c2,0x0203034c,
0xfe850066,0xfa55fcbd,0xf70ff8c4,0xf556f5dd,0xf5edf501,0xf81af654,0xfbe3f9b4,0x0098fe67,
0x05eb0373,0x0b170894,0x0ec50d56,0x10ab1051,0x1097112f,0x0e910f6b,0x0a700c3a,0x041a070d,
0xfcce00bf,0xf64dfa01,0xf0bff376,0xecffee5f,0xeb7bebcb,0xec3eebca,0xef0beda1,0xf310f0d7,
0xf854f56e,0xfe94faeb,0x04fc0193,0x0b7608a9,0x118a0f40,0x16a3146f,0x1927182d,0x187c18d9,
0x14ce16ba,0x0ef11208,0x06d70b10,0xfdf20285,0xf51ef998,0xed56f113,0xe7e9ea39,0xe591e659,
0xe65fe569,0xe9fae7b6,0xefb6ec92,0xf72cf3aa,0xfefafb56,0x068a02d0,0x0d3509eb,0x11820fc0,
0x13b412d6,0x137c139b,0x112e1285,0x0dce0fc9,0x09e60bef,0x04d5075a,0xffac022b,0xfaf1fd6a,
0xf6c9f8b7,0xf38ff4f9,0xf1daf292,0xf1b6f194,0xf367f24c,0xf6b1f49b,0xfb1af8be,0x000ffdb9,
0x04a0028b,0x08210681,0x0a0e0934,0x0a140a4a,0x085b0946,0x055d071d,0x020d03d0,0xfee1005b,
0xfc13fd3a,0xfa39fb26,0xf9cef9fa,0xfb09fa50,0xfdd6fc09,0x008fff0f,0x03af024c,0x05ef0503,
0x071f06e1,0x06eb0730,0x05b80642,0x03a9046b,0x00c0022f,0xfddcffb2,0xfba5fd10,0xf994fa70,
0xf769f85c,0xf5a2f65c,0xf45af503,0xf476f454,0xf5fff4ee,0xf910f758,0xfd9cfb1d,0x0306002c,
0x08c805fc,0x0e140ba3,0x119f1012,0x1395130b,0x135213ab,0x107811c0,0x0b540e04,0x04ab0866,
0xfd470118,0xf5fdf9d3,0xeffbf2db,0xebe8ed67,0xea58ea6e,0xeb5aea59,0xeeb1ed1e,0xf3f5f192,
0xfa20f6da,0xfffefcac,0x054b0292,0x0a410836,0x0e910ca2,0x11d31032,0x134d128d,0x12b81354,
0x104411e8,0x0bfb0e82,0x06800953,0x005a0325,0xf9f7fd0b,0xf44af725,0xeff5f223,0xed9aee8a,
0xed3becda,0xeee1edb3,0xf2bcf0a1,0xf81af57c,0xfe42fb29,0x04220125,0x08ca068e,0x0b8e0a5a,
0x0c760c6e,0x0b540c2f,0x08e80a41,0x06100755,0x0320047b,0x00d70202,0xff3c0032,0xfe16fe8a,
0xfd30fd43,0xfca5fcae,0xfc8ffc87,0xfcd6fcdf,0xfd76fd60,0xfe97fe18,0xffd3ff0c,0x00d3002d,
0x01f10160,0x02920239,0x02720294,0x01bf0243,0x00100110,0xfdf1ff29,0xfbaefcdf,0xf9c2fabc,
0xf8aaf8fd,0xf89cf873,0xfa2bf929,0xfd0afb65,0x00faff28,0x0590035d,0x09910773,0x0c290af8,
0x0d470d26,0x0ca90d26,0x0a400b71,0x06710870,0x01d5044e,0xfd37ffac,0xf8eafb00,0xf57df6f1,
0xf315f405,0xf1e8f258,0xf214f1ed,0xf37bf2a4,0xf600f484,0xf95af792,0xfda9fb77,0x02520011,
0x074904d5,0x0bba0984,0x0f660da0,0x11811088,0x11d711e0,0x10531198,0x0ce10ee9,0x07c40a63,
0x01400487,0xfac1fe09,0xf4cef7a6,0xf081f262,0xee30ef25,0xee5fedfd,0xf0a4ef27,0xf4cdf27f,
0xf9a6f72d,0xfe7bfc5c,0x030d0107,0x06a604b8,0x08e507ad,0x0a4e09d7,0x0a9e0abd,0x0a9b0ab6,
0x09910a16,0x078b08a4,0x0536068a,0x024403b7,0xff070098,0xfbd4fd62,0xf949fa71,0xf749f839,
0xf6aaf6fc,0xf723f6da,0xf8e4f7f2,0xfb80f9f0,0xfe7afcc6,0x015a0015,0x03cd02d9,0x052304a6,
0x053f0566,0x043f04dc,0x022a0300,0xffdd00d8,0xfdd1fee0,0xfcb3fd45,0xfcedfce9,0xfdedfd47,
0xffb0feae,0x017c0092,0x034c024c,0x047803b8,0x051404f3,0x05220555,0x04970501,0x03730400,
0x01bc0295,0xffc200b5,0xfda6fec3,0xfbf9fce5,0xfa6afb33,0xf92ef9b9,0xf835f892,0xf792f7c0,
0xf797f787,0xf87ef809,0xfa34f945,0xfd40fb8b,0x0135ff0b,0x05ba036b,0x09f407fb,0x0d5c0bd9,
0x0f000e7f,0x0eca0f30,0x0c940dca,0x08600aaa,0x036505ef,0xfe4100c8,0xf945fba7,0xf58ff73a,
0xf31df403,0xf21af262,0xf297f245,0xf476f391,0xf73ff5de,0xfa8af8bf,0xfdf8fc30,0x0163ff9e,
0x04d502f8,0x07ce062e,0x0a24092c,0x0be30b67,0x0cb10c77,0x0c480cbf,0x0a710b87,0x076d090f,
0x035b0558,0xfecd00f9,0xfa46fc84,0xf6b6f876,0xf4a5f590,0xf422f416,0xf512f467,0xf766f613,
0xfa8bf8b9,0xfddcfc49,0x012effdb,0x0382028f,0x0501043f,0x0562051e,0x04e90529,0x042c04af,
0x035203d4,0x026902da,0x01b60219,0x012b0167,0x00b900dc,0x006c009d,0x001a0041,0xffb10008,
0xff55ff77,0xfef8ff14,0xfeb0fed5,0xfeeffeab,0xff56ff12,0xffecffc7,0x0085005e,0x00c900b5,
0x00540073,0xff60ffee,0xfdd0fea5,0xfbedfcf8,0xfa9ffb60,0xfa15fa38,0xfaa6fa06,0xfc5cfb24,
0xfef9fd9d,0x026500d4,0x05c3042c,0x083e070e,0x098a0918,0x099809de,0x08990948,0x068507b5,
0x039f04fd,0x005901cf,0xfd45fedc,0xfa99fc12,0xf8b3f99b,0xf761f7de,0xf6b6f6b2,0xf6a3f686,
0xf722f6eb,0xf84ef7f8,0xfa54f974,0xfcfafb5f,0x0015fe32,0x038c01b2,0x0734057a,0x0a6208ff,
0x0c720b93,0x0d080cfa,0x0c040ca4,0x09740ad7,0x05a10795,0x011c037d,0xfccaff14,0xf92efacc,
0xf67cf79b,0xf502f593,0xf50df4e7,0xf66af591,0xf874f770,0xfb2ff9ca,0xfe15fc97,0x00a1ff55,
0x02a401a7,0x040a037c,0x052304c8,0x05fa0593,0x06680624,0x06770676,0x061f064b,0x056205ea,
0x03e804c7,0x01f602fb,0xff8600b0,0xfd08fe4e,0xfb3ffc11,0xfa2bfa78,0xfa03f9fc,0xfae5fa73,
0xfc8afbb0,0xfe5cfd75,0x002eff2f,0x016c00be,0x01ea01b8,0x017801d0,0x00890150,0xff9f003e,
0xfec8ff19,0xfe4bfe4f,0xfe59fe2b,0xff2ffebf,0x0093ffd9,0x02180163,0x038b02ca,0x047e040c,
0x04c804b1,0x046804ac,0x039a042b,0x0297032b,0x018e01fe,0x007800df,0xff8ffffa,0xfea0ff27,
0xfd79fe2d,0xfc4bfcf6,0xfafbfba9,0xf9f7fa75,0xf944f972,0xf919f8f8,0xf9a5f93d,0xfb1cfa67,
0xfdb4fc74,0x00eaff3d,0x046602ae,0x079905eb,0x09b808b6,0x0aa70a6b,0x0a460aaf,0x08af0997,
0x05dc0750,0x02780454,0xfef800ba,0xfbcffd58,0xf967fa7b,0xf7f2f88a,0xf76af778,0xf792f745,
0xf857f7ea,0xf969f907,0xfaf6fa43,0xfcd0fbde,0xfeccfda5,0x00efffd6,0x0345020e,0x059e0475,
0x079a06a2,0x08d4085f,0x09270949,0x086a0900,0x06890777,0x03ab0512,0x00540209,0xfd3ffee4,
0xfabbfbf6,0xf944f9da,0xf8e0f8d4,0xf963f902,0xfab2f9f0,0xfc70fb82,0xfe24fd73,0xff8eff05,
0x00920028,0x00f900b5,0x00fe0101,0x00fe0110,0x012600f5,0x01600115,0x01b20198,0x02270216,
0x02a0027c,0x02b902a2,0x02730286,0x01b1020d,0x00cd0139,0x00080080,0xff85ffe0,0xff46ff72,
0xff64ff47,0xffa8ff72,0xffe9ffb0,0x0001ffde,0xffa5ffeb,0xfef5ff6e,0xfdf2fe8f,0xfcc9fd52,
0xfbc2fc2b,0xfb25fb54,0xfb4dfb2b,0xfc50fbc9,0xfe26fd23,0x0098ff46,0x032101c3,0x05610455,
0x07030664,0x07ba0777,0x0754079a,0x060806cb,0x043f0536,0x02430349,0x003d0146,0xfe88ff64,
0xfd06fda1,0xfbb6fc43,0xfaa4fb1f,0xf9bffa2f,0xf944f993,0xf93cf93b,0xf9acf96d,0xfac8fa25,
0xfc86fb85,0xff06fd90,0x01c4004f,0x04aa034f,0x0735062e,0x08f60845,0x09840959,0x08c10935,
0x06e107e7,0x043f0598,0x012802b6,0xfe45ffaf,0xfbeafd18,0xfa77fb21,0xf9d3f9fa,0xf9edf9bf,
0xfa64fa16,0xfb34facf,0xfc35fbbc,0xfd41fcc6,0xfe5efdcc,0xff86fee0,0x00900003,0x01c40150,
0x03130278,0x04270386,0x04d3047e,0x0510051e,0x04dc0519,0x0400047b,0x028f0344,0x00d401b6,
0xff2efff5,0xfdcbfe68,0xfcf7fd51,0xfcd3fcde,0xfd4efd00,0xfe07fda6,0xfee6fe7b,0xff85ff2f,
0xffbcffb9,0xff81ffad,0xfeeaff3d,0xfe38fe93,0xfdaefdee,0xfd9dfd95,0xfdfefdaf,0xfecdfe4a,
0xfff0ff58,0x014a00a6,0x02800208,0x03910320,0x040e03c6,0x03fb0400,0x037803c2,0x02bd0327,
0x01f1025e,0x013a0196,0x009800e5,0x00020047,0xff55ffac,0xfe63fed8,0xfd45fddb,0xfc00fcbc,
0xfadefb68,0xfa1ffa69,0xf9fef9e4,0xfa9cfa2a,0xfc27fb4d,0xfe6cfd41,0x00feffba,0x03a40269,
0x05d104ce,0x07470693,0x07b10782,0x07260788,0x05e5069a,0x03ff04f7,0x01dc0304,0xffe100ef,
0xfe20ff01,0xfcccfd60,0xfbc7fc1d,0xfb00fb47,0xfa97fae1,0xfa86fa99,0xfad7faa9,0xfb60fafd,
0xfc40fbbb,0xfd8dfcd3,0xff62fe68,0x01640067,0x037e0283,0x0544047d,0x066805f0,0x06c8069e,
0x062b0681,0x04c70593,0x02ec03fa,0x00e50203,0xff17fff1,0xfd98fe24,0xfca5fcf0,0xfc5afc7f,
0xfc96fc7f,0xfd19fcda,0xfdbafd75,0xfe4efe07,0xfeb1fe6d,0xfed6fec0,0xfee5fee9,0xff10ff08,
0xff67ff3d,0xffe1ff8e,0x0093001b,0x015e00f9,0x021f01dd,0x02ae0278,0x02c502b7,0x0277029f,
0x01ef0229,0x011e0181,0x007b00d8,0x00270054,0x0015000c,0x001a001b,0x004b003c,0x00540054,
0x000b0027,0xff4bffb9,0xfe46fed8,0xfd2afdc6,0xfc36fca4,0xfb96fbd4,0xfb93fb85,0xfc35fbc5,
0xfd61fcaf,0xff0cfe2d,0x00dbfff1,0x02ac01e7,0x0436038d,0x052404ae,0x054a053a,0x04eb0532,
0x0427049b,0x03090396,0x01ea0278,0x00ce014f,0xffd30044,0xfec8ff46,0xfd92fe3c,0xfc7cfd28,
0xfb9afc09,0xfacdfb1d,0xfa55fa73,0xfa81fa58,0xfb64fae1,0xfcedfc14,0xfee9fde0,0x010dfff8,
0x03360229,0x04ef041c,0x05fd0590,0x064b0648,0x05d3062b,0x04a70558,0x030d03e0,0x0146021c,
0xff9e0058,0xfe2efee1,0xfd45fdc8,0xfccafd0f,0xfca5fca0,0xfca0fc8d,0xfcaefca9,0xfcccfcb6,
0xfcf7fcda,0xfd69fd30,0xfe0bfdb5,0xff01fe81,0x0037ff9a,0x018f00d7,0x02b40222,0x03810326,
0x03da03c8,0x03bc03d6,0x03230379,0x023002b4,0x011f01b2,0x003e00b4,0xff88ffd8,0xff21ff4a,
0xff19ff0c,0xff49ff1f,0xff81ff63,0xff97ff90,0xff72ff95,0xff17ff5b,0xfe91fedb,0xfdecfe32,
0xfd62fd9b,0xfd30fd3f,0xfd87fd4e,0xfe3ffdc8,0xff42feb5,0x004fffe1,0x017400f4,0x024701d8,
0x02bf028d,0x02ec02e3,0x02e702f2,0x02aa02d0,0x02690291,0x021c0239,0x01b101eb,0x01460180,
0x009d00f4,0xffd40041,0xfed8ff5b,0xfda5fe41,0xfc88fd0b,0xfb96fc01,0xfb21fb48,0xfb2efb0b,
0xfbdefb7d,0xfd2ffc86,0xfef9fe13,0x00ebffec,0x02c201d2,0x043a0381,0x050b04ba,0x0549054a,
0x04ee052e,0x04130485,0x02f60381,0x01c40263,0x00a1013d,0xffa60023,0xfeacff1b,0xfdc2fe24,
0xfcf0fd5d,0xfc49fca0,0xfbcffc0d,0xfba0fba8,0xfbcafb9b,0xfc64fbfe,0xfd71fcee,0xfee0fe35,
0x007affb0,0x020d0139,0x035702a8,0x041d03cc,0x04650459,0x04110453,0x034803b8,0x022f02c5,
0x00fe0194,0xfffb006e,0xff3dff9c,0xfedaff02,0xfeb5feb3,0xfea5fea2,0xfe97feaa,0xfe7efe9d,
0xfe48fe6c,0xfe1afe30,0xfdedfdf6,0xfdf3fdde,0xfe3dfe02,0xfeb1fe74,0xff73ff16,0x0037ffe6,
0x00f800a5,0x01990150,0x01f001c5,0x020901fa,0x01f101f7,0x01a101d3,0x0162018f,0x012e0140,
0x01090112,0x00fd00fb,0x00e900f4,0x00ca00dd,0x006c00a6,0xffe2002c,0xff0cff72,0xfe05fe93,
0xfd18fd9c,0xfc6dfcbd,0xfc27fc3a,0xfc5dfc26,0xfd15fca0,0xfe32fd91,0xff84fece,0x00ca002e,
0x01fa0180,0x02eb0288,0x037d033b,0x03ae038d,0x038c03a9,0x03300371,0x02bb0301,0x0219025f,
0x016801ab,0x008e00fa,0xffaf002a,0xfeafff3c,0xfda5fe35,0xfcb8fd27,0xfbf2fc45,0xfb91fbb0,
0xfbb2fb95,0xfc52fbf2,0xfd80fcda,0xff03fe33,0x0099ffd6,0x0221016e,0x035b02cc,0x040c03c1,
0x04310431,0x03da0418,0x03340388,0x025c02bb,0x017201e2,0x009c0113,0xfff0004a,0xff50ff9f,
0xfec2ff0d,0xfe3ffe80,0xfdcbfe05,0xfd69fd8b,0xfd1ffd30,0xfd14fd0f,0xfd4efd28,0xfdccfd92,
0xfea6fe44,0xffa7ff1a,0x0098001a,0x01720106,0x020d01cb,0x025f0244,0x025f026e,0x0220024b,
0x01b501eb,0x01390176,0x00d200fb,0x008600a7,0x00660075,0x005a005f,0x00420051,0x001a0037,
0xffd4fffa,0xff51ff9d,0xfebdff0c,0xfe31fe66,0xfdaafde0,0xfd6bfd8b,0xfd7efd7d,0xfde5fdaa,
0xfe8efe2b,0xff5dfeea,0x001fffc7,0x00e20090,0x017d0135,0x01e701b6,0x02290205,0x023f0234,
0x023a0236,0x021c0226,0x01f7020f,0x01b601e1,0x01630199,0x00ce0113,0x00030072,0xff12ff9c,
0xfe01fe89,0xfd06fd74,0xfc45fc90,0xfbedfc0e,0xfc1cfc04,0xfcd1fc78,0xfdeefd53,0xff40fe89,
0x0080ffe1,0x01a90123,0x028a0229,0x032102dd,0x034d033f,0x0339034f,0x02fc0321,0x028b02c2,
0x01fd023f,0x014f01a4,0x008e00f8,0xffd4003b,0xfefeff6e,0xfe38fe94,0xfd79fdcb,0xfce8fd2f,
0xfca1fcc3,0xfcaffc9f,0xfd1ffcd9,0xfde0fd75,0xfee1fe58,0xfffbff78,0x010e0088,0x01e60177,
0x0277023a,0x02a802a2,0x028a02ae,0x0242026e,0x01d301fe,0x01540186,0x00db011b,0x007c00b2,
0x002e004f,0xffe9000b,0xff97ffc9,0xff4fff7a,0xfef4ff14,0xfe92feba,0xfe3afe6b,0xfe01fe24,
0xfe05fe02,0xfe33fe0f,0xfea2fe54,0xff27fedb,0xffccff89,0x0068001c,0x00ea00b0,0x01460124,
0x016f015c,0x016c016e,0x0167015f,0x0162015a,0x01690163,0x01770171,0x01770182,0x01640181,
0x011e0143,0x008b00d6,0xffdd0036,0xfefcff6e,0xfe29fe8f,0xfd7ffdca,0xfd0dfd3b,0xfcf7fcfc,
0xfd3cfd0f,0xfdcffd79,0xfe91fe2e,0xff72ff06,0x0049ffe5,0x010d00b0,0x01b00165,0x022e01f0,
0x02790249,0x02860279,0x027a0287,0x024c026e,0x01f70234,0x018501ca,0x00e60138,0x001a0077,
0xff32ffb0,0xfe4afec8,0xfd7dfdd6,0xfcecfd21,0xfca5fcbd,0xfcc3fcb1,0xfd3bfd00,0xfe07fd96,
0xfef9fe77,0xffffff77,0x00eb0069,0x01ab0156,0x02390205,0x02860264,0x028c0283,0x024c0270,
0x01ef022f,0x018001c4,0x0111014d,0x00a200cd,0x00240059,0xffb9fff3,0xff36ff77,0xfeacfefc,
0xfe3afe77,0xfddafdfe,0xfda1fdaf,0xfdabfd98,0xfdfdfdd4,0xfe93fe48,0xff46feef,0xffffffa3,
0x00990041,0x010b00ce,0x01400132,0x015e015e,0x015b015b,0x01470146,0x0135013a,0x01230129,
0x01180126,0x01090124,0x00f5010e,0x00c300d4,0x00670083,0xfff0001e,0xff56ffb7,0xfed7ff25,
0xfe63fe97,0xfe05fe27,0xfde5fde9,0xfe02fdf2,0xfe59fe22,0xfed0fe8a,0xff5dff1b,0xfff6ffaa,
0x00000003,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_27_standard_DRUMS_lowtumba[2048] = {
0x00000000,0xf2a3f498,0xecd3f98d,0xf0e0f226,0xd95ee383,0xd993f44a,0xe29be4b4,0xefc3d50d,
0xeba4dde8,0xf5b2f556,0xfe810bac,0x087c08b7,0x11420a8d,0x149d1396,0x1c7217df,0x250c19a5,
0x286b2251,0x2cb629e3,0x32d43005,0x389e3597,0x3c553a50,0x3b973bd8,0x3a8e3bb1,0x3a923a8a,
0x37ad38c3,0x32e3354e,0x2c542fbf,0x21572766,0x161c1cc1,0x07f1106d,0xf880fff8,0xe6a8f009,
0xd1e7dcdb,0xbcc6c834,0xa6ecb199,0x96b59e41,0x88238fb1,0x8b5a8879,0x8ddb8b4d,0x908a8ece,
0x937191a0,0x9616947f,0xa0359769,0xb0d4a889,0xc37dbb98,0xd67dcded,0xec1be1d3,0x0205f65b,
0x16e60c98,0x2b2420b0,0x3d4b3471,0x4d28461c,0x5c0a543b,0x66b260f3,0x6fd66b16,0x739d74e4,
0x710471e1,0x6dd16f1d,0x6b256c6b,0x6857698e,0x6594670c,0x622f6462,0x4fe55832,0x3ae14507,
0x231930a1,0x0adf19c7,0xf3f7008e,0xded2e879,0xcb3ed53e,0xbc57c3cb,0xb047b4f3,0xa468a882,
0x9bef9ffd,0x968299b3,0x9576964b,0x96bb95a8,0x993397b3,0x9d229ac4,0xa214a037,0xa97ca665,
0xb18aad83,0xbabbb50b,0xc525beba,0xd457cce8,0xe76edd28,0xfe16f239,0x15b40a0c,0x2d3d215f,
0x439638a9,0x57704dc9,0x683f6049,0x747b6e6f,0x735375ee,0x70d172c6,0x6e0b6f83,0x6b326cbf,
0x689769ef,0x63d76750,0x53705ae2,0x41504a59,0x2e5b37bd,0x1b03249f,0x087a1269,0xf76b005f,
0xe804f020,0xd8c7dfcd,0xc9c8d190,0xbaccc2cb,0xacfdb447,0xa13fa5e2,0x96bf9c07,0x90bb9362,
0x8e308e50,0x91619063,0x947992e4,0x972c95a3,0xa20f9bff,0xb0e0a8ad,0xc388b942,0xd929cd83,
0xefe5e46b,0x08b7fcd1,0x1f0c1360,0x32652835,0x41a83ac3,0x4ec24975,0x58df53b8,0x5ded5b9a,
0x626860d2,0x63a8633e,0x63c763a8,0x618b628b,0x5ce75fc2,0x56bb5aa6,0x4ee352f2,0x445d4904,
0x37d93e0f,0x2a963226,0x1cc12431,0x0d9c14a1,0xfc5d0516,0xeb13f41e,0xd9cce22d,0xc971d155,
0xbb0cc186,0xaea7b464,0xa56aaa50,0x9f54a212,0x9b4d9c7c,0x99d09abe,0x9cbc9b4c,0xa1ff9f90,
0xaa50a690,0xb52aaffe,0xc2e8bbfa,0xd16dc8fe,0xe0bfd942,0xf0b1e8e3,0x0164f8a7,0x11820910,
0x212419a4,0x30e22a25,0x3f303805,0x4b1f457f,0x5586505b,0x5cff5896,0x61c95f9b,0x644e637e,
0x642c64a4,0x61686373,0x5c5e5f98,0x543f587d,0x49f24fa1,0x3c9d4358,0x2cf53506,0x1b1c2475,
0x08b4129a,0xf604ff21,0xe311ebd8,0xd173d9d1,0xc15cc91e,0xb3d7ba24,0xa86eada1,0xa02fa3cb,
0x9ab79d43,0x9a119a9a,0x9de09b8b,0xa4cfa057,0xae63a8e6,0xb9f9b41f,0xc7d1c0d8,0xd607cefa,
0xe502dd91,0xf3cbec7d,0x0236fb2f,0x10340963,0x1cbf1655,0x27c72287,0x312d2c87,0x390b34e0,
0x3f353c44,0x45124282,0x4968470a,0x4cb54bc5,0x4ef44e7b,0x4fb94f6b,0x4e884ee9,0x4a1e4c6c,
0x432d46eb,0x39933ee8,0x2dce340a,0x202c2709,0x10fa191c,0x02530a02,0xf2fffaa8,0xe48aeb0c,
0xd6a3dcf6,0xcae3d07f,0xc0e1c582,0xb94ebcb1,0xb37bb63a,0xb01bb248,0xaf7baf95,0xafc7af02,
0xb0e8b001,0xb362b25d,0xb7f1b56d,0xbe14ba80,0xc695c1f0,0xd169cbdd,0xde49d7c3,0xed40e599,
0xfdb7f503,0x0efe0609,0x206417cb,0x30f028f8,0x403e38ef,0x4cfb46f5,0x56655238,0x5c5e59da,
0x5e225dbc,0x5bd75d83,0x560859a9,0x4db652a9,0x42e94869,0x36953c81,0x28f22f76,0x1b2821f6,
0x0dbb1471,0x00d70738,0xf4fffaeb,0xe9aaef24,0xdf94e49d,0xd669db33,0xceaad2b2,0xc812cb20,
0xc26fc4f5,0xbe14c042,0xbb8bbca3,0xba06ba85,0xbabfba36,0xbd5cbba8,0xc1e1bfb5,0xc93bc584,
0xd1ffcd3c,0xdc0dd6fa,0xe772e1cb,0xf3a7ed63,0x003ef9c0,0x0c8b0667,0x17cb1242,0x21ea1d0a,
0x2a35267b,0x31062de7,0x35eb3348,0x391c3791,0x3b673a7b,0x3c733c38,0x3ced3cfa,0x3be73ce7,
0x39d73b3e,0x35f53812,0x30cd338c,0x29c32d84,0x21ec261b,0x18781cf9,0x0d991354,0x025607fa,
0xf602fc00,0xe9aff002,0xddd5e3bd,0xd2f4d830,0xc936cdb4,0xc155c51e,0xbb94be1e,0xb897b9e1,
0xb848b7b4,0xba21b8b9,0xbe7abc1c,0xc533c1af,0xcd90c901,0xd6fad218,0xe213dc9a,0xee2de7ee,
0xfabef42c,0x06d00148,0x135d0dbe,0x1ed91960,0x28aa2409,0x30bb2cc1,0x36ce33c2,0x3ab938e7,
0x3cb33c12,0x3ca73cea,0x3a803bbf,0x368e38b8,0x313a341c,0x2a972de4,0x23402734,0x1b691f9d,
0x13661782,0x0b160f23,0x02b206b5,0xfa4bfe68,0xf258f615,0xeab6ee46,0xe3dae75c,0xde14e0cf,
0xd925db68,0xd4ebd6b6,0xd1ded37e,0xd050d0eb,0xcfe7d01c,0xd0e5d078,0xd35cd219,0xd71cd4da,
0xdb9fd91e,0xe104de8c,0xe7b7e44f,0xee85eaf0,0xf591f222,0xfcdef955,0x04070056,0x0b09075e,
0x11dc0e73,0x1875154a,0x1ed21bd9,0x24d6222e,0x29f22772,0x2e352c4d,0x30fe2fcc,0x32b1320f,
0x32e632f2,0x31693264,0x2e5c300c,0x294a2c04,0x225625e9,0x197b1e10,0x0f5e149a,0x047209fc,
0xf96cff02,0xeeb5f3f2,0xe4e5e9b5,0xdc66e099,0xd5d6d8ed,0xd13ed327,0xce91cfa2,0xce3dce32,
0xcf92cebe,0xd2a4d0e6,0xd6d5d489,0xdbead938,0xe188ded6,0xe7b3e4ba,0xee36eb02,0xf4a6f14b,
0xfb3cf7fc,0x019dfe57,0x07f904da,0x0e250b10,0x140e1139,0x19dc1725,0x1ee91c72,0x22fb20fa,
0x25df2493,0x278726e7,0x27ec27f7,0x26ff2796,0x24cd2610,0x21562336,0x1cd81f54,0x179b1a5e,
0x11bf14bf,0x0bac0eb0,0x0594088c,0xffd802ac,0xfa62fd21,0xf584f805,0xf0fef31d,0xecbeeeaf,
0xe8cbeaa1,0xe538e6ec,0xe21ce3a0,0xdf88e09d,0xdd67de96,0xdc34dcd1,0xdbebdbf9,0xdc7fdc29,
0xdea5dd59,0xe18bdff3,0xe5e1e3c8,0xeb1fe88c,0xf16dee57,0xf84af4a6,0xff84fb93,0x06b402f7,
0x0de90a64,0x147b1147,0x1a461793,0x1ef21cd5,0x228d20e2,0x24af23db,0x25c5256c,0x25be25e1,
0x24502536,0x222b23a1,0x1ed0209c,0x1aa71ce7,0x1572180b,0x0fb41291,0x09850c87,0x02ed062b,
0xfc5dffba,0xf5ddf92e,0xf007f2b2,0xea84ece7,0xe5a9e7fd,0xe217e3da,0xdf62e093,0xddc5de75,
0xdd36dd5b,0xde1bdd92,0xdffddecc,0xe2d7e124,0xe6a2e4a1,0xeb11e8d5,0xf01feda1,0xf573f2d9,
0xfb1af856,0x0080fdc1,0x05c9032a,0x0aeb087e,0x0f960d4c,0x138311a4,0x16be1561,0x196a1831,
0x1b1f1a38,0x1bf41bad,0x1c4a1c4f,0x1b861c13,0x1a3a1b0b,0x17f21910,0x15291694,0x11e31379,
0x0e59102a,0x0a8a0c68,0x069f0889,0x028a048d,0xfe630095,0xfa6afc7f,0xf652f867,0xf283f47f,
0xeed7f09d,0xeb8bed1d,0xe88ae9f3,0xe60ae72b,0xe436e4fa,0xe2f6e38c,0xe2d5e2da,0xe3b6e311,
0xe59de45d,0xe861e6ec,0xec58ea4a,0xf10eeeb4,0xf6a2f3d0,0xfca5f983,0x02afff94,0x087f0593,
0x0de30b4f,0x12911061,0x16731491,0x196c17f7,0x1b8a1aae,0x1ca51c37,0x1d051cf7,0x1c5b1cc0,
0x1afe1ba2,0x189a19ba,0x1599173f,0x122f13f1,0x0e2b1050,0x09a20c05,0x04fe0759,0xffe50272,
0xfad9fd6f,0xf5acf83f,0xf112f348,0xece2eec2,0xe931ead8,0xe65ee7f1,0xe492e554,0xe3ace3e5,
0xe3c7e3a5,0xe51fe453,0xe735e5f8,0xea32e891,0xedb2ebf7,0xf1d0efc0,0xf62af407,0xfa8bf85b,
0xfed5fcb3,0x02cf00e1,0x068504bf,0x09d7084a,0x0cdc0b54,0x0f370e1a,0x11871071,0x1366126e,
0x14d2140c,0x15bf1564,0x164c1638,0x163e1660,0x158e15e2,0x143614eb,0x1252135c,0x0fc0111f,
0x0ca40e3c,0x08ea0aee,0x04e606ec,0x008b02e1,0xfc81fe66,0xf83bfa40,0xf449f65c,0xf0fef2a5,
0xee3aef75,0xebdaecc1,0xea2ceadc,0xe92ae9b4,0xe8f3e8f3,0xe93ae8fc,0xea28e993,0xebb0eaea,
0xedc8eca8,0xf064ef0b,0xf3b9f1f0,0xf764f569,0xfb83f975,0xfff3fdcc,0x0471023d,0x08f506be,
0x0d480b36,0x11380f5a,0x14e6132d,0x17b6165a,0x19cd18d0,0x1af41a86,0x1b281b1c,0x1a3d1acd,
0x1861199d,0x15d8173d,0x12691415,0x0e251051,0x099f0bef,0x049d0708,0xff9d0208,0xfa8efd09,
0xf5e5f835,0xf1a5f3b5,0xedf9efb6,0xeaf6ec5d,0xe8b5e9a6,0xe72ce7df,0xe6ade6ce,0xe6fbe6bc,
0xe819e788,0xea02e90f,0xec99eb3d,0xef9cedf6,0xf300f14d,0xf6a2f4d7,0xfa7df891,0xfe2bfc5a,
0x01c10003,0x05290383,0x084806b4,0x0b0f09b5,0x0da80c72,0x0fed0ec8,0x11be10f1,0x1367129d,
0x147113ef,0x151114c4,0x15451569,0x14f01525,0x14261492,0x12a5136a,0x108d11b3,0x0dfd0f5a,
0x0ac00c57,0x070a08f7,0x0303050d,0xfedb00f1,0xfaa8fcc3,0xf67cf87e,0xf292f475,0xef08f0bc,
0xebeded82,0xe97aeaa6,0xe79be871,0xe66ae6e7,0xe600e61b,0xe65ae603,0xe757e6b8,0xe927e843,
0xebd3ea6e,0xef28ed62,0xf33ff11b,0xf7fff580,0xfd0ffa5d,0x0258ffa6,0x07c5051a,0x0cfc0a7a,
0x11eb0f8e,0x1623141a,0x198917e1,0x1be31af4,0x1d4e1cc0,0x1d8c1d8f,0x1cbc1d3e,0x1ada1bec,
0x181b19ab,0x14961663,0x1073128a,0x0be60e32,0x073c09a2,0x029604e4,0xfe320069,0xfa0cfc04,
0xf630f804,0xf2c2f479,0xefd1f141,0xed39ee70,0xeb35ec27,0xe9b4ea69,0xe8c2e91d,0xe84de879,
0xe883e861,0xe92ee8cc,0xea93e9d6,0xec70eb7b,0xef08edb9,0xf21af063,0xf593f3c7,0xf96bf773,
0xfd91fb72,0x01b3ff97,0x05dd03bb,0x09ab07d9,0x0d4d0b98,0x108d0f07,0x134c11f1,0x157e146d,
0x17301663,0x183117c0,0x18b9188d,0x189018c1,0x17e4184e,0x167a173d,0x1477158f,0x11d9134f,
0x0ea11053,0x0adc0cc8,0x068208b7,0x01ce0429,0xfccaff5d,0xf7c0fa45,0xf2ddf540,0xee48f087,
0xea3cec38,0xe6d3e878,0xe43be571,0xe28de332,0xe1bde1fb,0xe1fae1cf,0xe366e296,0xe5a8e462,
0xe8f3e739,0xed01ead7,0xf199ef2d,0xf698f41e,0xfbf7f953,0x0148fea5,0x068203f1,0x0b6e08fd,
0x0fe00db4,0x13a911d9,0x16d71555,0x1914180e,0x1aa319f7,0x1b401b08,0x1b011b42,0x1a0a1aa5,
0x18401945,0x15e21730,0x12f81471,0x0f8a1143,0x0bc50dbe,0x07da09d2,0x03bc05d1,0xffad01be,
0xfbb5fda4,0xf7d4f9af,0xf42cf602,0xf0fef29f,0xee2bef8d,0xebd0ece9,0xe9f2ead2,0xe8a5e938,
0xe7f5e839,0xe7d9e7da,0xe87fe81c,0xe9a5e8f9,0xeb7dea81,0xedd5ec86,0xf0bdef37,0xf428f276,
0xf80ff609,0xfc2cfa02,0x006efe44,0x04c90292,0x08fd06e3,0x0d190b21,0x10d20f0c,0x143c12a5,
0x172215cd,0x1979186a,0x1b171a5e,0x1bee1b95,0x1bd91bf5,0x1ac91b8e,0x19051a15,0x165a17c0,
0x12c9149f,0x0e8310bb,0x09af0c35,0x04750724,0xff1401ba,0xf9a2fc52,0xf483f70f,0xefd1f225,
0xebdaedc6,0xe896ea1b,0xe62fe73e,0xe4b5e55d,0xe433e451,0xe492e43d,0xe5b7e4fe,0xe797e699,
0xea36e8e3,0xed56ebb3,0xf0e6ef14,0xf4c7f2cd,0xf8e1f6df,0xfd22fb08,0x016aff3e,0x058a0374,
0x097a0790,0x0d490b8a,0x10b50efd,0x13971234,0x15f014e9,0x17a916dc,0x18961840,0x18ee18c1,
0x185d18a9,0x172717e4,0x155f1651,0x12f2143e,0x0ffe1182,0x0c940e58,0x08dd0abd,0x04ee06e1,
0x00d102e3,0xfce2fee9,0xf90dfaf3,0xf565f728,0xf209f3a0,0xef01f076,0xec49eda8,0xea45eb33,
0xe88ce93a,0xe770e7f7,0xe709e749,0xe75de72d,0xe868e7c1,0xea1ae911,0xec75eb2a,0xef89edfc,
0xf33ef168,0xf778f551,0xfc03f9b4,0x00bffe5f,0x05920314,0x0a2a07da,0x0e6f0c54,0x1235106e,
0x157113e4,0x17e316b1,0x199618d5,0x1a7e1a32,0x1a9e1ab3,0x19fc1a63,0x18741956,0x1665178a,
0x137f14ed,0x101711e6,0x0c480e3a,0x08160a2a,0x03a605e1,0xff330163,0xfaabfcf3,0xf650f890,
0xf264f45e,0xeed1f08b,0xebe2ed34,0xe979ea93,0xe7dde892,0xe6f6e752,0xe6e7e6d7,0xe78ce71b,
0xe8e8e826,0xeaeae9dc,0xed9bec2c,0xf0ceef1b,0xf462f28b,0xf84bf654,0xfc6afa5d,0x0093fe81,
0x04aa0292,0x087f0695,0x0c090a55,0x0f2d0da8,0x11e11095,0x140212f6,0x159414e5,0x168e1637,
0x170516f5,0x16db1700,0x1610167d,0x14bc1572,0x12d013d7,0x107311b3,0x0da40f1b,0x0a6d0c11,
0x06d908a0,0x030404f2,0xff14010c,0xfb1ffd1c,0xf736f91d,0xf387f552,0xf025f1df,0xed41eeb3,
0xeacfebf1,0xe8e8e9ce,0xe7c3e844,0xe74ee76a,0xe79ae756,0xe8b5e805,0xea77e984,0xecf8ebb2,
0xf013ee71,0xf3abf1c9,0xf79cf591,0xfbcef9b6,0x0024fe06,0x04780247,0x0895067f,0x0c650a80,
0x0fc30e1f,0x129a1154,0x14f713ed,0x169f15dc,0x1799172e,0x17da17cb,0x176117ba,0x164b16ed,
0x1477156d,0x120c1352,0x0f15109d,0x0ba10d6d,0x07de09c7,0x03d905ce,0xffaf01be,0xfb98fdbc,
0xf7c0f9af,0xf434f5e2,0xf10ff282,0xee65efa5,0xec5aed58,0xeafbeba3,0xea4cea8e,0xea3bea29,
0xeac9ea72,0xebefeb50,0xeda9ecae,0xefb9ee98,0xf23af0fc,0xf51ff3ab,0xf845f69f,0xfb8cf9e2,
0xfefcfd40,0x025200a3,0x05ad0409,0x08d90744,0x0bc30a53,0x0e6f0d29,0x10c00f98,0x129011b7,
0x13f11354,0x14b01472,0x14eb14f4,0x149214c8,0x137f140f,0x11ea12c7,0x0fd110ec,0x0d2f0e89,
0x0a380bc3,0x06ec08a6,0x03790537,0xffe2019f,0xfc50fe0e,0xf8c7fa84,0xf586f72b,0xf298f407,
0xf00cf135,0xededeee5,0xec51ed0a,0xeb42ebc6,0xeaddeb04,0xeb08eae2,0xebe7eb60,0xed51ec7f,
0xef60ee45,0xf1fff091,0xf503f375,0xf882f6b2,0xfc38fa4a,0x0005fe1a,0x03de01fa,0x079e05c9,
0x0b0f0962,0x0e230ca5,0x10a50f6f,0x129411b3,0x13de134d,0x14741436,0x14671483,0x13b31424,
0x126f1326,0x10a3119e,0x0e5b0f8c,0x0bbb0d12,0x08bc0a40,0x058f0738,0x025e0404,0xff3d00be,
0xfc16fd9c,0xf929fa97,0xf67ef7cd,0xf428f54b,0xf228f315,0xf07ef148,0xef4fefdc,0xee94eee5,
0xee54ee5c,0xee79ee5c,0xef33eecc,0xf04befac,0xf1d3f0f9,0xf3a7f2a8,0xf5d8f4c0,0xf84df71b,
0xfb0cf9af,0xfde3fc72,0x00d3ff5e,0x03be023d,0x06950534,0x094b07f9,0x0bb90a8a,0x0ddb0cd5,
0x0fa50ec7,0x10f61051,0x11d21179,0x122c120d,0x11f61224,0x113d11a9,0x0ff510a0,0x0e300f1b,
0x0bef0d19,0x094e0abb,0x066307ee,0x034204e1,0xfff90191,0xfc9efe4d,0xf961fb02,0xf661f7d6,
0xf3b4f4f3,0xf163f274,0xefa5f06d,0xee5eeeea,0xedbeedfd,0xedaaed9f,0xee3deddc,0xef56eeb3,
0xf0fbf01c,0xf321f209,0xf5b5f462,0xf896f718,0xfba3fa14,0xfecefd34,0x01d90053,0x04ce0360,
0x07870636,0x09ef08c6,0x0bff0b03,0x0d9e0ce3,0x0ed40e4f,0x0f9d0f4b,0x0fe80fce,0x0fc90fe3,
0x0f3b0f85,0x0e410ec1,0x0ced0da0,0x0b540c2f,0x09730a6c,0x0755086c,0x05120636,0x029d03d4,
0x001c0167,0xfdaafef2,0xfb43fc6a,0xf8fcfa10,0xf6d5f7d9,0xf4f5f5e8,0xf36af427,0xf226f2b7,
0xf14bf1ac,0xf0d2f104,0xf0cff0cf,0xf142f0f9,0xf213f19e,0xf353f2ad,0xf4e7f411,0xf6cef5d4,
0xf902f7db,0xfb6cfa28,0xfdfcfcb1,0x00a8ff56,0x035b01fd,0x05f504ac,0x086c073a,0x0aa00993,
0x0c870ba4,0x0e0b0d56,0x0f200ea2,0x0fba0f7f,0x0fd10fe4,0x0f720fb6,0x0e830f07,0x0d200ddf,
0x0b430c38,0x08fb0a25,0x066c07b8,0x03a10507,0x00be0236,0xfdf4ff60,0xfb37fc8b,0xf8b3f9eb,
0xf674f786,0xf48df578,0xf313f3cb,0xf204f27e,0xf170f1b3,0xf152f151,0xf1a4f165,0xf264f1ee,
0xf37af2e3,0xf4f0f428,0xf6acf5cd,0xf8abf7b3,0xfadef9c3,0xfd26fbff,0xff7afe4a,0x01b5008b,
0x03e802d3,0x05ee04ef,0x07c406e6,0x095e089c,0x0ab90a10,0x0bbb0b3d,0x0c6a0c18,0x0cbf0ca9,
0x0cc10ccf,0x0c6c0c9d,0x0bb40c15,0x0ab90b4e,0x09840a29,0x080b08cc,0x065e072c,0x04750569,
0x02750379,0x0059016e,0xfe45ff59,0xfc26fd37,0xfa25fb20,0xf84af92d,0xf6a2f769,0xf53df5e7,
0xf425f4af,0xf36ff3c3,0xf30ef330,0xf314f307,0xf387f33f,0xf458f3e0,0xf590f4eb,0xf725f654,
0xf90df80e,0xfb2afa0f,0xfd75fc48,0xffd9fea6,0x023300fb,0x0483035c,0x06a205a3,0x088907af,
0x0a370971,0x0b7b0add,0x0c5f0bf8,0x0cd50cac,0x0ce60ce8,0x0c8a0cc4,0x0bc80c33,0x0aa60b46,
0x093209f8,0x0777085b,0x057f0681,0x0362047a,0x013c0253,0xff2c002c,0xfd17fe13,0xfb29fc14,
0xf966fa43,0xf7e7f89f,0xf6a4f743,0xf5b0f624,0xf50df554,0xf4b5f4cd,0xf4b1f4a5,0xf4fff4d1,
0xf59ff54c,0xf685f607,0xf7a8f712,0xf900f84d,0xfa89f9be,0xfc33fb51,0xfdf1fd0d,0xffcafedf,
0x019300a8,0x035c0279,0x05030436,0x068605d2,0x07d50739,0x08e50867,0x09b7095b,0x0a420a03,
0x0a7e0a64,0x0a6d0a81,0x0a130a4b,0x097109cc,0x088c08ff,0x075a07f7,0x05fe06b2,0x04680533,
0x02af0393,0x00df01cf,0xff14fffd,0xfd40fe1d,0xfb73fc4c,0xf9d0fa9d,0xf85ef916,0xf72af7bc,
0xf637f6a9,0xf590f5de,0xf545f567,0xf552f542,0xf5b5f571,0xf668f602,0xf773f6e6,0xf8c9f80e,
0xfa59f988,0xfc20fb2e,0xfdf7fd09,0xffe6fefc,0x01ca00cf,0x039c02b3,0x054c0480,0x06d40617,
0x08230782,0x092c08af,0x09f40998,0x0a640a33,0x0a7c0a83,0x0a500a70,0x09c20a0e,0x08ea0962,
0x07d9086b,0x06870738,0x050f05cf,0x036b043e,0x01ae0292,0xfff600d3,0xfe3aff20,0xfc90fd6e,
0xfb11fbce,0xf9b8fa54,0xf891f918,0xf7aaf817,0xf70af753,0xf6acf6d7,0xf69bf695,0xf6c9f6aa,
0xf742f6ff,0xf7f6f78b,0xf8d9f85b,0xf9e5f961,0xfb30fa8e,0xfc90fbda,0xfe0cfd49,0xff92fec6,
0x01080045,0x028501d0,0x03f60344,0x0544049d,0x066a05dd,0x075c06ea,0x081907c5,0x08a10867,
0x08e508cb,0x08e908f3,0x08aa08d8,0x08310875,0x076d07d5,0x067306fa,0x053d05da,0x03d40491,
0x02500319,0x00b40181,0xff19ffe4,0xfd78fe3b,0xfbe8fca5,0xfa71fb25,0xf928f9cc,0xf813f892,
0xf730f79e,0xf6a2f6e2,0xf659f66e,0xf65ff650,0xf6b7f680,0xf756f6fe,0xf843f7ca,0xf96bf8cd,
0xfac8fa15,0xfc4efb85,0xfdf1fd1a,0xffa5fecb,0x01500073,0x02f20226,0x048303c3,0x05e4053b,
0x0716068b,0x080a079f,0x08be0874,0x092d08ff,0x094a0941,0x091c093f,0x08ab08ea,0x07f60856,
0x07030780,0x05e20673,0x0494053b,0x032c03e5,0x01b2026f,0x002a00e7,0xfeb1ff75,0xfd3efdfb,
0xfbf0fc94,0xfabefb4b,0xf9bdfa36,0xf8edf94e,0xf85bf8a4,0xf800f826,0xf7e2f7ec,0xf7fdf7e7,
0xf849f819,0xf8cbf883,0xf97bf91b,0xfa5df9e9,0xfb6cfade,0xfc9cfbfa,0xfde8fd39,0xff40fe8e,
0x008ffff3,0x01f2014d,0x034f02a2,0x048503ee,0x05af0520,0x06ae062e,0x077c0711,0x081207ca,
0x086c084e,0x088c0888,0x0867087f,0x07f70838,0x075007af,0x066c06e8,0x055705e7,0x040e04ae,
0x02a0035b,0x011f01e3,0xff9d0056,0xfe0afed5,0xfc88fd49,0xfb1ffbd5,0xf9dcfa7a,0xf8cbf94b,
0xf7f1f856,0xf758f79b,0xf703f728,0xf701f6fa,0xf747f717,0xf7d0f783,0xf8a2f832,0xf9aff91d,
0xfae6fa43,0xfc4bfb99,0xfdccfd0d,0xff5bfe93,0x00df001e,0x026401a3,0x03cd031b,0x05100472,
0x0620059b,0x06f50691,0x078b074b,0x07e607bf,0x07ff07f6,0x07d507f1,0x077907af,0x06e70738,
0x062b068e,0x054405b6,0x043604ba,0x030e03a4,0x01d2027a,0x00930137,0xff62fff4,0xfe23febb,
0xfcfafd8d,0xfbebfc6f,0xfaf4fb6c,0xfa1ffa89,0xf97af9c5,0xf8f2f931,0xf8a4f8cb,0xf889f890,
0xf89ff891,0xf8edf8c4,0xf972f925,0xfa23f9bd,0xfb03fa90,0xfc0ffb85,0xfd3cfca3,0xfe85fddc,
0xffdcff32,0x01320080,0x028c01e3,0x03da0335,0x050f0476,0x061c059b,0x06fe0697,0x07b20763,
0x082507f2,0x085b0848,0x08470855,0x07ee0822,0x075107a9,0x067c06f9,0x05720604,0x044304da,
0x02e3038e,0x0172022a,0xfff300ad,0xfe72ff37,0xfcfffdbc,0xfbacfc4c,0xfa7afb07,0xf97bf9f3,
0xf8baf914,0xf83af874,0xf7fff813,0xf802f7f7,0xf849f818,0xf8c7f87e,0xf97ef922,0xfa68f9ef,
0xfb78fae6,0xfca6fc0d,0xfdeefd48,0xff3efe96,0x007dffe5,0x01c40126,0x02f3025e,0x0405037c,
0x04ee047e,0x05b1055a,0x06500609,0x06bf068e,0x06fe06e2,0x070a0708,0x06e806fa,0x069406c1,
0x0613065e,0x056905c4,0x049b0508,0x03a80428,0x02970328,0x0179020d,0x004700dd,0xff1effb6,
0xfde8fe81,0xfcc0fd54,0xfbb2fc34,0xfab5fb2d,0xf9e4fa4a,0xf938f984,0xf8b8f8f4,0xf874f892,
0xf86cf867,0xf89df879,0xf901f8c7,0xf9a0f94c,0xfa75fa03,0xfb72faec,0xfc92fc00,0xfdd5fd32,
0xff2efe7e,0x0083ffde,0x01e70137,0x033f0292,0x047a03e3,0x0597050d,0x067b060e,0x073206de,
0x07a30773,0x07da07ca,0x07d007dc,0x078707af,0x06fd0748,0x064106a6,0x054c05cd,0x043004c6,
0x02f80399,0x01a60250,0x004c00f6,0xff01ffac,0xfdbcfe59,0xfc8bfd1c,0xfb81fbfc,0xfa9cfb04,
0xf9e2fa37,0xf95ff99e,0xf90ff937,0xf8f8f8fc,0xf910f8fc,0xf958f92d,0xf9d6f994,0xfa7afa1c,
0xfb41fadb,0xfc2ffbba,0xfd39fcb4,0xfe53fdc6,0xff7bfee5,0x00950007,0x01bc0128,0x02cc0247,
0x03cc0352,0x04b10445,0x05770516,0x061a05ca,0x068f0656,0x06db06ba,0x06ed06e8,0x06cf06e3,
0x068106b2,0x06040646,0x055c05b2,0x048704f4,0x03930415,0x02830312,0x016001f7,0x002f00c8,
0xfefcffa1,0xfdc7fe65,0xfc9efd2c,0xfb8ffc0f,0xfaa1fb0c,0xf9d6fa34,0xf940f981,0xf8def906,
0xf8b7f8c2,0xf8c6f8b7,0xf90af8e3,0xf98bf94a,0xfa3df9e0,0xfb22faac,0xfc30fba3,0xfd56fcbc,
0xfe91fdf9,0xffe0ff3b,0x011e0075,0x025e01bc,0x038202e9,0x047e0407,0x055c04fd,0x060905ba,
0x06850652,0x06cd06b2,0x06e006d9,0x06b406cb,0x065b068e,0x05d5061c,0x05220580,0x044604b4,
0x034a03c8,0x023a02c2,0x011701ab,0xfff60086,0xfedaff70,0xfdccfe4f,0xfcc9fd43,0xfbe3fc51,
0xfb1ffb77,0xfa75fac5,0xf9f8fa34,0xf9a5f9ce,0xf984f996,0xf998f98b,0xf9d7f9b5,0xfa48fa06,
0xfadcfa87,0xfb94fb32,0xfc6efbfc,0xfd61fce2,0xfe62fdde,0xff75feeb,0x0078ffff,0x018f010e,
0x029d021f,0x0399031b,0x04720402,0x052f04ce,0x05c00577,0x062a05fd,0x06690651,0x067b0672,
0x06540668,0x05ff0630,0x058405ca,0x04dc053a,0x040e0480,0x032503a5,0x022202a3,0x010b0191,
0xffea0071,0xfec8ff5e,0xfdb0fe3d,0xfcacfd26,0xfbbcfc2f,0xfaf8fb59,0xfa5dfaa6,0xf9eafa1b,
0xf9acf9c7,0xf9a1f99e,0xf9c5f9ac,0xfa1ef9eb,0xfa9efa5b,0xfb4ffaf9,0xfc23fbb5,0xfd1afc9b,
0xfe27fd9f,0xff42feac,0x004effcc,0x016700e1,0x026f01ef,0x036202e9,0x043a03cc,0x04eb0497,
0x057e053a,0x05e405b6,0x06190609,0x06200625,0x05f50610,0x059d05ce,0x0519055f,0x047104c4,
0x03a9040e,0x02c90336,0x01d40249,0x00cf014d,0xffd70050,0xfed0ff5a,0xfdd9fe5a,0xfcf6fd6a,
0xfc2cfc8d,0xfb7cfbcf,0xfaeffb2e,0xfa89fab6,0xfa4afa60,0xfa33fa33,0xfa40fa36,0xfa7ffa5e,
0xfae5faad,0xfb66fb20,0xfc0dfbb5,0xfccffc6a,0xfda1fd39,0xfe91fe1b,0xff8aff0b,0x00750003,
0x017400f8,0x026401eb,0x034202d0,0x040003a3,0x04a50459,0x052704eb,0x05830557,0x05b4059e,
0x05b405bd,0x059005ab,0x053f0569,0x04c40508,0x0426047a,0x035d03c5,0x027d02f5,0x01890205,
0x00860109,0xff920006,0xfe8dff0b,0xfd9afe0f,0xfcb7fd26,0xfbf0fc53,0xfb49fb9a,0xfac8fb02,
0xfa70fa97,0xfa46fa51,0xfa4afa3d,0xfa7afa62,0xfae0faac,0xfb69fb1f,0xfc13fbba,0xfce2fc74,
0xfdbefd4d,0xfeb0fe38,0xffafff31,0x009a0025,0x0191011a,0x027a0203,0x034402df,0x03f803a5,
0x048c0446,0x04f904c9,0x05400528,0x05640558,0x055d055d,0x05270547,0x04d30500,0x0459049b,
0x03c70419,0x031e0373,0x025c02bd,0x019101f5,0x00b60120,0xffe40047,0xff06ff77,0xfe33fe9e,
0xfd6ffdd0,0xfcbdfd13,0xfc25fc6e,0xfba5fbe4,0xfb4bfb7c,0xfb13fb29,0xfafafafb,0xfb07faf9,
0xfb32fb15,0xfb7efb59,0xfbf7fbb8,0xfc8bfc3d,0xfd37fcdf,0xfe02fd9f,0xfedafe6d,0xffbeff4c,
0x00920020,0x01710103,0x024901da,0x030b02a9,0x03b50366,0x04480407,0x04b90488,0x050804e3,
0x05270516,0x051d0525,0x04e80506,0x048c04bf,0x040b0452,0x036b03c1,0x02ad030e,0x01dc0242,
0x00f40165,0x0008007d,0xff27ffa5,0xfe44febb,0xfd75fdde,0xfcbbfd13,0xfc1bfc61,0xfb98fbce,
0xfb38fb63,0xfb02fb16,0xfaeffafa,0xfb13fb00,0xfb59fb2e,0xfbbafb83,0xfc3dfbfe,0xfcdbfc8c,
0xfd8dfd34,0xfe4dfde9,0xff16feb3,0xffe7ff7a,0x00a8003b,0x016c010c,0x022201c9,0x02c4027a,
0x03530312,0x03c30393,0x041a03f6,0x0453043c,0x046f0463,0x04680471,0x0448045e,0x040a042c,
0x03b003df,0x033a0376,0x02aa02f5,0x020d025e,0x015f01b3,0x00a300fb,0xffeb0044,0xff2eff92,
0xfe74fed5,0xfdc6fe1d,0xfd2bfd79,0xfca1fce0,0xfc2efc64,0xfbd7fc03,0xfba4fbbb,0xfb91fb95,
0xfba3fb93,0xfbd7fbb6,0xfc2afbfa,0xfc9afc61,0xfd30fce4,0xfdd9fd80,0xfe96fe37,0xff60fefc,
0x0024ffcc,0x00f40090,0x01bb015a,0x02750219,0x031e02c9,0x03aa0362,0x041603e5,0x04650441,
0x048d0480,0x0492048f,0x0468047e,0x041e044d,0x03b703f1,0x03360376,0x029602e6,0x01ed0242,
0x01320190,0x007000cf,0xffb60010,0xfef5ff55,0xfe44fe9b,0xfda2fded,0xfd12fd54,0xfc9efcd6,
0xfc49fc6e,0xfc0cfc25,0xfbecfbfc,0xfbebfbef,0xfc0dfbfe,0xfc49fc25,0xfc99fc6b,0xfd00fcca,
0xfd7dfd3e,0xfe0bfdc2,0xfea5fe54,0xff47fef8,0xffefff9c,0x008a0034,0x012600db,0x01c00179,
0x024d020a,0x02c9028a,0x032c02fa,0x03760354,0x03ab039a,0x03c803c0,0x03c503cd,0x03a503bb,
0x036e038c,0x031b0345,0x02af02e4,0x02260269,0x018e01dd,0x00e7013d,0x003d0093,0xff9dffee,
0xfeedff3d,0xfe45fe9b,0xfdadfdf9,0xfd21fd66,0xfcb3fce7,0xfc55fc7d,0xfc1bfc35,0xfbfefc09,
0xfc09fc01,0xfc30fc16,0xfc78fc51,0xfcddfca8,0xfd56fd18,0xfde9fd9f,0xfe8efe36,0xff36fedf,
0xffe9ff93,0x00950037,0x014100ec,0x01e50199,0x02750233,0x02f302b8,0x03540323,0x039b037a,
0x03c503b2,0x03d003cd,0x03be03c8,0x038c03a8,0x03450371,0x02e4031d,0x027502ad,0x01f00233,
0x015e01a9,0x00c90113,0x002a0078,0xff9effea,0xff07ff4f,0xfe79febb,0xfdf7fe36,0xfd89fdc1,
0xfd2ffd5b,0xfce8fd08,0xfcbbfcd3,0xfca8fcad,0xfca8fc9f,0xfcbcfcb1,0xfcf0fcd8,0xfd37fd0e,
0xfd95fd67,0xfe02fdca,0xfe83fe3f,0xff0ffec7,0xff9eff55,0x0025ffeb,0x00bb0072,0x014b0101,
0x01cf018b,0x0249020a,0x02af0279,0x030102d8,0x03420327,0x03650357,0x036b036e,0x03540367,
0x03280348,0x02e40306,0x028802b2,0x02120248,0x019001d3,0x00fd0148,0x006400b9,0xffd30017,
0xff31ff81,0xfe99fee9,0xfe10fe52,0xfd90fdcd,0xfd2cfd5e,0xfcd9fcfb,0xfc9efcb8,0xfc81fc91,
0xfc81fc81,0xfc9ffc8b,0xfcd5fcb3,0xfd1ffcf3,0xfd80fd4f,0xfdf8fdb8,0xfe7bfe35,0xff06fec2,
0xff9eff51,0x0024ffe7,0x00ba0073,0x014a0101,0x01c60185,0x02330203,0x02920266,0x02d602b7,
0x030802f2,0x03200315,0x031e0328,0x030b031b,0x02dd02f7,0x029f02c1,0x02490275,0x01e20214,
0x016e01a9,0x00ef0130,0x006b00b0,0xfff30028,0xff6effb0,0xfeefff31,0xfe7efeb5,0xfe10fe45,
0xfdb5fde3,0xfd69fd8d,0xfd2ffd4c,0xfd0ffd23,0xfd06fd0d,0xfd14fd0a,0xfd39fd1e,0xfd6ffd51,
0xfdb9fd95,0xfe18fde5,0xfe83fe4a,0xfefcfebf,0xff7dff3b,0x0001ffc0,0x007b0036,0x00f000b7,
0x015e012e,0x01b5018f,0x01ff01de,0x0231021b,0x02530247,0x025e0258,0x02530257,0x02390246,
0x02050222,0x01cd01ef,0x018a01ad,0x01410163,0x00f10118,0x00a100c8,0x0054007a,0x000b002f,
0xffd1fff3,0xff9cffb4,0xff6cff7f,0xff4aff59,0xff34ff3d,0xff2cff2e,0xff2fff2a,0xff3bff31,
0xff4aff41,0xff62ff58,0xff7fff72,0xff9cff8d,0xffb9ffab,0xffd4ffc5,0xffeaffde,0xfffbfff3,
0x00050000,0x00000005,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_28_standard_DRUMS_timpani[3968] = {
0x00000000,0xfff9fff5,0xfff9fff5,0x0004fff5,0x004fffd7,0x010dff91,0x0f21fd95,0x4fbb460b,
0x598a625b,0x40225439,0x1dc43113,0xcebe1dfc,0xa00faa38,0x8dee95d9,0xa37e9a5c,0xc251ae3d,
0xce93bae0,0x0511d76d,0x3eb12a28,0x4c583de2,0x57c249d3,0x71fb4441,0x23dd71fb,0xe630f1b5,
0xe648e7ed,0xeec9ef46,0xcda5dd06,0xb7a1c669,0x8ede8dee,0x8dee8dee,0x8dee8dee,0xc0548ff3,
0x0a45edec,0x71fb5de5,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x63ea65a4,0x1d0f436b,
0xee5d0f5a,0xe57305f9,0xb625c17f,0x8deeaa98,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xc0a68dee,0xfbd5dff8,0x3d3529ab,0x55755d07,0x67ae6ddf,0x71fb71fb,0x4f7e71fb,0x13161b8c,
0x1d472442,0xfa441de7,0xcf52e857,0xd173e353,0xe3c8e00a,0x0295e5f9,0x0f271317,0x2b7b286d,
0x22d1246c,0xa55de909,0xd89caf6a,0x38f2130d,0x53b04e5a,0x3fcc54bc,0x0adb2513,0xf0652688,
0xd155e5e1,0xfba9dd25,0xf8551268,0x9d19b5bf,0x9acea20f,0xad5bb3e4,0xed96daf5,0xf3e2f0de,
0x10511045,0x4bf33ede,0x2b5b3d9b,0x29bb3343,0xffc50b15,0x0027ebe8,0xfec7f3a9,0x10b60585,
0x2b5f16fb,0x11ff1190,0xdf53f16d,0xeca9de8c,0xd533d6a4,0xcb59bbe0,0x0a3cd75a,0x2ffe10b0,
0x51a051c1,0x4d464a90,0x71fb558f,0x4c346c85,0xe693195c,0xc947d26b,0xb29bcfe6,0xd9cfc45b,
0x05d9e1d2,0xf35a17dc,0xe47fe2b5,0x9e06a4c7,0xc216b13e,0x004bdab5,0x14061d0b,0x00cafd35,
0xff13ef19,0x288f131d,0x3ce019c6,0x2b4f3101,0x04c10d54,0xc8fbea58,0xa9669f86,0x8deeb3ed,
0xc2fba7ce,0xf0a8ce3f,0x0d69f6ef,0x41e33da6,0x48ae4ae9,0x5d2c3a27,0x65f8634d,0x4b764493,
0x5810406f,0x4a9b649b,0x4343455f,0x2c0c4275,0xe114030a,0xb1e6cd24,0xc151b261,0xa540ac33,
0x8dee8fcc,0x8dee8dee,0x8dee8dee,0x91fb8dee,0xe178bead,0x15e3f073,0x063211a2,0x20a40606,
0x4ae02a5e,0x662c5d72,0x4da64ee4,0x3b7d34a9,0x29b54196,0x42eb351b,0x491b4bf0,0x599d6206,
0x2c094a20,0xed231a6f,0xcd85ea5b,0xe852d9a6,0xf8adfc73,0x1b280bb1,0x22ad224f,0x1562130a,
0x0ecc125f,0xf0b70311,0xbec9f2c8,0x909eaec4,0x8dee8dee,0x8dee8dee,0xc16f9eb2,0xa6ffb95f,
0xdb97b77b,0xf408db2f,0xf6abfaf8,0x058501cb,0xfbd80c9c,0x0ea10add,0x36792da4,0x67ac4ba2,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4ca36dc4,0x3e9f3f5b,0x067e1bcb,0x085afcfa,0x01461670,
0xe891fff2,0xe74aecef,0xfc92f08b,0xf4d7f80c,0x987dc84c,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xb84c9a36,0xbb70c776,0xc9b5cbaa,0xc9ebd25d,0xfaa7d65b,0x31b420a0,0x36262852,0x3a6e340e,
0x37cd3a0b,0x5a4b49e5,0x71fb6b6a,0x71fb71fb,0x71fb71fb,0x6bf96d27,0x34275100,0x2c1831b4,
0xeb3d2305,0xe341e747,0xd083cb12,0xe01dc9e5,0xea3adc7d,0xcc09dcd0,0xc3c9cab1,0x93e4a51c,
0x8dee8dee,0x8dee8dee,0x9c468dee,0xaef2a646,0xc838b98a,0x1a70ef95,0x11b4ffec,0x28fe19ea,
0x0a971634,0xff680f97,0xff8602d1,0x18930661,0x3bc82224,0x650c6590,0x5b8162af,0x66bf59b8,
0x71fb71fb,0x715f71fb,0x5a586b92,0x282e37d9,0x09631b2b,0x0930fe19,0x05541030,0xf2a0f255,
0xce93eefc,0x943d9f37,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xabd58ecb,
0xf6e2ccf0,0x14d40bb6,0x308c1fd4,0x3cc83642,0x4d1441cb,0x58a454ef,0x54f55933,0x6aab5d25,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4dff6b8e,0x273825fc,0x1d5131ad,0xe9ae0de2,0xcb9ddd3e,
0xc6e9c6dd,0x9e7eab38,0xcb85af2d,0xc1a3bb94,0xad7db412,0x9b3daf10,0x93f193cf,0x900b938e,
0x8dee8f27,0xb6319605,0x17e8f839,0x23232783,0x1f56235e,0xfdc91211,0x0a31f343,0x103f09a2,
0x23d41d97,0x1fcd26b7,0x43003222,0x603e588b,0x6e406635,0x6c526a3b,0x6ee871fb,0x613c68f3,
0x44e551be,0x1c9d290b,0x0b85134a,0x11270d1c,0x09ad1dc6,0xf4bb03c8,0xa06ecc52,0x8dee92a4,
0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xa2ac8dee,0xcb33c27f,0xdbfcd848,0xe91edd0b,
0x19bb024c,0x5a023657,0x627b61be,0x4ac44f22,0x71fb4e69,0x71fb71fb,0x71fb71fb,0x71fb71fb,
0x4bac646a,0x3460374a,0x15141ac5,0xf4c108e7,0xe3b6fd3b,0xdc99dba0,0xae51b249,0xb0cab142,
0xdc46c25a,0xe4b0e258,0xca7ddfcb,0xc81dc1bf,0xc85ed0b7,0x9c7e9bdf,0xa5719cdd,0xbcf2a722,
0xe7a6e365,0xf0c3fc49,0xf5cbf135,0xf9f7fb00,0xef710010,0xff91f2d9,0x054ef957,0x34e02252,
0x53354cae,0x5ad14d72,0x71fb71fb,0x71fb71fb,0x6f3871fb,0x39a058a2,0x29e3309e,0x121f1c60,
0x113b1e47,0x1d881a32,0x0f9a1928,0xfcd4febe,0xc87ce08b,0x8f00a429,0x98c38dee,0x8dee8dee,
0x8e178dee,0x8dee8dee,0x90c88dee,0xc201b78f,0xc9f5c20d,0xf88ae686,0xfb42f39e,0x17da1b73,
0x17ed1155,0x2a750ca7,0x71fb45f3,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4e0871fb,0x28a93e22,
0x0e341dfe,0x18280ebe,0x18301cc3,0x039015b6,0xdb97e75b,0xcb0fd9c7,0xcb33c14c,0xccafcb4f,
0xb0b8cb7a,0xb53eb409,0xafecb29b,0x91d6a409,0xcf3db0ae,0xe1d2ec38,0xdcedd1ca,0xd951e49f,
0xef96e106,0xfa88fb3c,0xea75e9f4,0xfda2f975,0x1a3a0203,0x35f92d77,0x2be02f48,0x4b9a3949,
0x58a151eb,0x71fb6f95,0x650667d0,0x42355a2f,0x40443b7b,0x40d134c8,0x2d564336,0x408939cf,
0x2d9a3875,0xef4106b1,0xc38edeea,0x95d7ab99,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0x8dee8dee,0xc804aa74,0xc589c984,0xe8f4dd31,0x0e73f788,0x01540a20,0x2de20e8f,0x4c283918,
0x67d35439,0x71fb7038,0x71fb71fb,0x71fb71fb,0x6ae471fb,0x2d433cae,0x10ed19eb,0x1c3e1a8e,
0x0a5d1401,0xe8b5fbd8,0xe63be7ac,0x093f02ae,0xdc35facc,0xc536ca7a,0xaab8c1b6,0xa2519cb2,
0xa7a4ad63,0xbdf7ad7f,0xcae8c7cb,0xd885ce7c,0xc219cc6c,0xf091d575,0xf232f7bf,0x099ef61e,
0xe0c5f447,0xe92ae38e,0x0a69f805,0x30071977,0x367133b3,0x64ee4ad7,0x71fb71fb,0x641971fb,
0x414e4b25,0x35e03489,0x374134ff,0x44c13c88,0x3bcf4669,0x31503829,0x16fa31d5,0xe45a02da,
0xcbfdd5b2,0xaa30c075,0x94f799c7,0x8dee8dee,0x8dee8dee,0x943e8dee,0xb4fba87b,0xb038b474,
0xbe6bb283,0xd2e6c6c9,0xff87e844,0x0a1406d0,0x258314c9,0x46db2963,0x4af25722,0x71fb5275,
0x71fb71fb,0x71fb71fb,0x53aa71fb,0x35ce396c,0x2ab23295,0x1eb02bfb,0xf9a80b3f,0xee36ee36,
0xf4a5f487,0xede9fc15,0xdee4e4f9,0xb698ca86,0xbf37bc59,0xb69db8ae,0xcdedb760,0xd733d7d2,
0xb98ac90f,0xd349c196,0xd264ceff,0xdb7cdd82,0xf2b5e40f,0xf686ee56,0xf633f816,0xf169ecdf,
0x0c40fbaa,0x0e940d16,0x30a21e62,0x3fd93ce0,0x6314519c,0x546361a1,0x513a4a63,0x64d15f52,
0x32355255,0x2206225d,0x16212090,0x2bc2229d,0x1b4b291c,0x059e10df,0xeed5059e,0xc3b7d989,
0x8dee9c7e,0x8dee8dee,0x95898dee,0xb1a1a4f8,0xaacba7a6,0xadc5aa68,0xc15ab142,0xd545cf62,
0xe7a0d904,0x0874f0dc,0x1e87151d,0x41592fff,0x4a2543f2,0x5f2954da,0x61266823,0x5f7b5e92,
0x71fb678b,0x592f6f74,0x25c142ce,0x03761141,0xffcbfc45,0x111b0957,0x190820b9,0xe699f7bf,
0xd2d1e2a0,0xc669c88e,0xaf97c3b8,0xc0edb1d2,0xc6febcf2,0xf229e9e2,0xe975e9b3,0xd2b9e13f,
0xb88fc0cb,0xd635c866,0xf8d9eac0,0xddd0ea3d,0xeceae827,0xf7aaef85,0x12570078,0x1c212356,
0x1b471658,0x26162538,0x2d6f2987,0x425f3122,0x525c4c83,0x60055e8f,0x40c559c2,0x34792cc5,
0x461a453d,0x1b8c3816,0xfe9d0a92,0xf5d6f1e0,0x02a30ace,0xe190ef72,0xb9cfcdd0,0x8dee93b8,
0x919992d7,0x9d4192ea,0xba17b0a6,0xb167b97a,0xb606af81,0xbe84be14,0xd530c5cc,0x02e0e7bc,
0x2aba15dd,0x2b263246,0x3f272f39,0x48373db3,0x580b52ee,0x63e45b8a,0x6ac16f06,0x3a8e552a,
0x1e9e264c,0x24e81ed6,0x1f9220d6,0x0afb1682,0x017d0468,0xe8c2fa63,0xe7dce3d8,0xecf8f513,
0xc975d71e,0xafd3b7e2,0xcf6fc276,0xde94d472,0xec44ea02,0xd37edb4a,0xe072dcc9,0xdce2dff7,
0xdd19e21f,0xbb50cbfe,0xcbcbc024,0xf84bdc24,0x116702c5,0x2d6127d3,0x2b5b30dc,0x240f2677,
0x18fb20a0,0x24ca1a9f,0x4f653cc0,0x41cb4bad,0x5d4a4c6d,0x50a861e9,0x37543d77,0x110e2ac1,
0x152d047c,0x20fb27b3,0xfbff0e5e,0xe0dbf390,0xa6d4bbcd,0xa911a405,0xb858b109,0xbe30bf04,
0xb988c035,0x9cb2ab27,0x96c5958b,0xbdeba69d,0xdd77cec4,0xf702e607,0x0ab20256,0x2c4d1632,
0x46433df5,0x53ed4692,0x4c4b5690,0x3df53c75,0x4b944548,0x54e756fe,0x3e0c4681,0x280c33b3,
0x23452400,0x083714ef,0x07930af7,0x04a30565,0xeb51fad6,0xd97cde70,0xd246d2d9,0xd354cce9,
0xdceadc22,0xcb65d743,0xc3e9c397,0xccc6c4d2,0xef84deea,0xe7f4f2e3,0xd610d7e5,0xd728ded1,
0xcefacdc1,0xe820dc15,0xf46cecaf,0x1aac04af,0x1b2820e8,0x24931f19,0x363b2eea,0x275f2c8d,
0x34352bc7,0x41203baa,0x442b463d,0x4e97491e,0x3d744977,0x3a183580,0x1f4a328a,0x108c14ed,
0xf0a7055a,0xeb5bea1b,0xd2dce595,0xa58cb79e,0xa207a039,0xaca4a6af,0xacc1abbf,0xbe40b236,
0xcbe1cc7f,0xc531c4b7,0xc8f9c807,0xd3cace23,0xf3a5e044,0x16a0061c,0x4cb3326d,0x45384e67,
0x54d04b49,0x47314f13,0x40cb4176,0x40154410,0x27e930de,0x38382ae8,0x3f344294,0x2883356d,
0x0c221c8f,0xed29f960,0xe20ce954,0xe488dcea,0xe888e7b5,0xd164e0ce,0xb9b4c228,0xce4ebf72,
0xe571d76d,0xed4df1f5,0xce6cdc2b,0xdc03d3df,0xe906e5bc,0xe5cfead2,0xcc97d669,0xdc7dce63,
0xfcbaedd7,0x080002c6,0x1f1c1582,0x0fd7192b,0x23f712b7,0x377f33d4,0x31013322,0x4af73cac,
0x3d104a01,0x47913bf6,0x47754bff,0x30984204,0x119e1993,0x07590cb8,0x08700777,0xf7bf0492,
0xd4a3e4d2,0xc7cecd00,0xb541bd13,0xb7fcb39b,0xa91fb346,0xadcca73a,0xc3b6b815,0xd998cc11,
0xdc40de8e,0xd8cedbfd,0xe06bd98a,0xfba5ef80,0x15db0768,0x3c052973,0x4ab0456e,0x62ef57c4,
0x4f375cae,0x3cb3453c,0x3f9d3722,0x32fc3fcb,0x1ab525ac,0x05330df9,0x0f4208cf,0x0f7514fd,
0xf5a80474,0xe879eb08,0xd86ce2d4,0xd442d332,0xd8eed47e,0xe3f4dfb8,0xe184e7ab,0xcdeed7e1,
0xce4ecbcf,0xe3c6d579,0xea00eb3d,0xdc34e195,0xdc8cdae0,0xee27e733,0xe5daebb2,0xebc0e330,
0x0787f802,0x298318b1,0x365331e8,0x39443988,0x262f314a,0x18641b15,0x33a62212,0x547148c5,
0x51c35433,0x34724abf,0x0c961b41,0x01f50611,0x07d30660,0x0068017b,0xf06efe32,0xdf89e428,
0xd4b4dd64,0xc04fc699,0xa856b55d,0x9fa7a0fd,0xb6dca861,0xcd8bc393,0xd0ccd3d0,0xd3c7cf43,
0xf571e246,0x09e70107,0x1b0614af,0x28421d76,0x394c34d1,0x326d32e0,0x43a13bb1,0x48ec46bd,
0x5234502a,0x31c7447a,0x1810243a,0x12a2120d,0x0f4e13d2,0x0ace0bbd,0x0370077a,0xf3b5fe97,
0xe75dede0,0xd6faddb1,0xe298dbe2,0xe49fe5a4,0xd830dfa0,0xd3ccd3f4,0xd28ed239,0xd29bd5b2,
0xd25dcf35,0xe48ddaf3,0x0096f46d,0xef40fdf9,0xe667e5b7,0xe8b0e6fb,0x0806f478,0x20491a21,
0x17e91d4e,0x1c4613c9,0x25942709,0x2b9725fa,0x34942fd2,0x338334ed,0x3bdd384a,0x3ccb39a3,
0x39313d65,0x2917344b,0x0b5219b3,0xee91fbb0,0xe780e8e3,0xd837dfac,0xda21d7ad,0xc3ddd376,
0xbb54b9dc,0xbea6bf22,0xc0f4bdcf,0xb41abd3c,0xbc8ab395,0xe1a9cd24,0xf2c7ed68,0x07b1fa6c,
0x16971272,0x1f9c1a66,0x1e961ebd,0x2341232c,0x34ad26e4,0x495141a9,0x432b49bd,0x2e3f3a18,
0x30e129af,0x2e2b34ba,0x20a52414,0x190f1e6b,0xfeff0ca5,0xeccaf9a3,0xce78da18,0xdb19cee3,
0xe260e2a1,0xeb8ce45b,0xe9abed09,0xdee9e38c,0xd54bdab3,0xce85d249,0xd3a6d031,0xe43adb17,
0xf74aeb81,0xf788fcba,0xe8c5ee92,0xf2b5ebac,0x01fcf8cb,0xfc2702a7,0x0951004a,0x1b6111b6,
0x2a8f25fb,0x26ef2b1f,0x2d20265b,0x3c2c3492,0x508046ff,0x425a501a,0x1fd02e4b,0x15a41956,
0x109812c0,0x036c0b94,0xf826fed7,0xdd74eb6e,0xc1eece9d,0xca5fc19c,0xdaced49d,0xdcb9de22,
0xc275d187,0xbb29b94b,0xc21fbec4,0xcf2ac65e,0xd61bd546,0xe747daee,0x0b00f851,0x1ec81883,
0x23a61f96,0x2b0d291a,0x364e2e2b,0x3ce03a4e,0x47744428,0x38244383,0x25fc2b12,0x1efa22ca,
0x282d227f,0x1ba02434,0x10211925,0xf71200e0,0xe01aee72,0xcdced15e,0xcfa7cf10,0xd901d200,
0xed86e2b1,0xfc5ef82b,0xf690fa8d,0xe370ed5f,0xd8e3dceb,0xcd47d44d,0xcf36c8bc,0xde51d9e0,
0xeac4e28f,0xfda9f1d0,0x0f330af0,0x091907e4,0x12911214,0x17291077,0x18281c7d,0x1c34172d,
0x33b62440,0x44b443b1,0x2318339c,0x23be206c,0x2f1d28e6,0x2ea030fa,0x24682c5b,0x01561436,
0xef77f566,0xec5cecf6,0xe8a7eca9,0xdcb0e10b,0xd9bbdbc1,0xc92dd25d,0xb80fbe7e,0xc384bbad,
0xccb5c9e2,0xc265c741,0xd26ec67c,0xee88e318,0xf9c1f2e9,0x161406dc,0x29eb2356,0x26ae2902,
0x2bdf26ae,0x367e3427,0x41c13b57,0x3dde4172,0x27203534,0x175d1a9c,0x1ed91ca0,0x1c901cd4,
0x0e161a10,0xf9e901ba,0xf708f54d,0xfca4fc1e,0xeab4f52e,0xd1c9dff6,0xc33cc406,0xde12ce31,
0xf53cebd2,0xf0a8f425,0xe02feb63,0xd6d9d66b,0xdd7ddc99,0xdfc5dc5f,0xe8ede71d,0xf136e75a,
0x0870000e,0x13840d02,0x1b491af8,0x0f6b15da,0x0d160cd6,0x17bf1244,0x169b1634,0x1a141814,
0x27fd2132,0x34ed2cb2,0x47144120,0x2f453e8a,0x1acb2305,0x0e2a1356,0x0b1f0beb,0x023b0a0e,
0xdb17f0f9,0xc9d6cc05,0xca00ca68,0xd1b3cd38,0xd32dd381,0xcfa2d390,0xc3bfc7d9,0xcbcdc7b8,
0xd261cd61,0xe365dafb,0xef5fe9a7,0x0eedfd0a,0x280c1ef7,0x1ea52580,0x18951a5b,0x27891c48,
0x36c432b9,0x30d53522,0x319c2f88,0x346933c0,0x27672f8f,0x1caf2368,0x09b80fe9,0x0e850ceb,
0x05a30a9a,0xf48efeda,0xd811e68e,0xcf1dcfdf,0xd6c9d292,0xdf40da38,0xe550e2ff,0xe543e629,
0xe26fe2af,0xedeae83f,0xf33ceef7,0xfa90fa11,0xe9c6f30b,0xe7c4e5ed,0xee36ea0c,0xfb28f63e,
0xff81fbc9,0x0a2d045b,0x18ea115a,0x24e520c2,0x1d4721e6,0x1adb1b6a,0x2a621fd9,0x36843451,
0x2a4a309c,0x2b3d2991,0x219d279c,0x16dc1c8b,0x0a301003,0xfcee054e,0xeca0f382,0xe181e590,
0xdd74e16f,0xc7f0d487,0xc49ec12a,0xd4cbccc2,0xdb17d96f,0xe06ade1b,0xd52cdced,0xc9d2cc0e,
0xdac7cffa,0xfc8beacf,0x14130a6d,0x18b21861,0x145c1579,0x2a0d1d9a,0x368d3163,0x3ad63a70,
0x38dd39b5,0x35e937ed,0x2e363237,0x20bd29f2,0x0cdf15e6,0x01a80653,0xf826fe0a,0xe5c3ed8d,
0xe7abe4da,0xe34ce713,0xded2e029,0xe817e1c7,0xef77ec13,0xed20f1c8,0xe008e571,0xe3dadfac,
0xe51ee609,0xe3f9e3a4,0xf03ae936,0xed69efd5,0xf903f1dd,0xfeb6fe32,0x015dfdb5,0x075305fb,
0x0ead09ea,0x12a91225,0x14061207,0x203d197d,0x33d22969,0x30ee3758,0x29302a13,0x21f92a31,
0x0fd115dd,0x08a40c9c,0x0dd807f1,0x107f1372,0x0dd80cd3,0xf8cd07db,0xe720ec13,0xd671e2e1,
0xc3dec87e,0xcde2c83f,0xccdbcebc,0xcd7dcbfe,0xc8b5cd24,0xcdc1c788,0xeab9da0d,0x035ffa2d,
0x0162046c,0x01c2ffd9,0x1c9a0b7d,0x359c2cbd,0x38cf381c,0x365e38cf,0x2ed7328a,0x2415291a,
0x21ad22e6,0x1e7e203d,0x1bae1d2f,0x10761825,0x026a07be,0xf9b5fd5b,0xef12f56d,0xe5f3ea3a,
0xdc6ee051,0xe660de9b,0xf1e9eee5,0xe5c3edcf,0xd3eadb45,0xdc9ed419,0xef1ce862,0xeccbef5f,
0xecbbeb29,0xf174ef0f,0xf709f353,0x08dfffc4,0x0d1c0d5f,0x09570ad5,0x07dc0927,0x04aa0472,
0x02e00502,0x0ce50472,0x173a14f9,0x21a319e0,0x39f92d17,0x429f443b,0x228e34fb,0x0a5e1247,
0x092d0926,0x0d1c0a24,0x01db0a9d,0xf908faf8,0xf951f9f8,0xf37ef6ee,0xd69fe9f0,0xbf60c61b,
0xb95cbc30,0xbad2b8f7,0xcdc2c10d,0xe3d4db37,0xec1be79a,0xfc9ef483,0x02c80107,0x0aa6057c,
0x184d12a5,0x10b315a1,0x14a20f6c,0x28f71e8d,0x32cb307a,0x347d32a8,0x36bc3774,0x284530a8,
0x1ebb21cb,0x115c1984,0x0a270c81,0xffe804e9,0xf26bfb7c,0xdd25e61f,0xd951d94a,0xdf5adb7a,
0xe43be28c,0xe1d0e3c6,0xe946e341,0xf071ee33,0xeefdf04e,0xed16ee3b,0xeb5deac0,0xf94cf08a,
0xfdb8ff50,0xf971f89b,0x03530013,0xfb43ffcf,0x01a2fc31,0x054004e6,0x0b970674,0x0c3f0f9a,
0x09880842,0x1c031091,0x3384294f,0x35a2385b,0x2f1d3130,0x25c02b66,0x1e8d2258,0x06f41555,
0xec47f767,0xeafae971,0xf518ef46,0xf38cf75a,0xe9cbede6,0xe239e584,0xdeeae1d2,0xcb4fd6fd,
0xbd3cc068,0xcc5fc254,0xda10d4f3,0xe65bdf57,0xf758ef95,0x05acfd42,0x150e0f75,0x148815a1,
0x19fa1551,0x2c84222a,0x321c337b,0x2dbd2e4a,0x33802ff5,0x30da34f6,0x220628c2,0x1ac91e4c,
0x0a1e1406,0xf3c7fea5,0xea50ed51,0xe5fce807,0xe393e2ff,0xe990e7bc,0xe126e65b,0xe405df2f,
0xf3d9ec9a,0xf58ff6eb,0xe84ef022,0xe45ae2c4,0xf353ebc6,0xfb0ef8f1,0xf4bdf8bb,0xedc2efd2,
0xfab5f238,0x07f40309,0xfdfb04b1,0x0328fd4f,0x0ca208f0,0x10c50ec5,0x13f51365,0x175f1447,
0x1a5e1a7d,0x21b81c2a,0x295d270a,0x26332939,0x17ed2037,0x04920d54,0x06b70317,0x0fdb0c6f,
0x023b0be2,0xef2ff7ac,0xe842ea8c,0xe39ee529,0xdef3e32b,0xcc6cd6bb,0xc0b1c2ef,0xce68c63e,
0xd69dd560,0xcf10d1fd,0xe491d530,0x02eaf42b,0x1ba1125a,0x1fae1f1b,0x1f0d1f74,0x231b1f99,
0x2d282883,0x2dfc2ed0,0x30ab2e3c,0x281c306a,0x13c11c8f,0x0f0a0eb0,0x161213a5,0x0b6712da,
0xfafb0207,0xf519f752,0xe722efce,0xd9c1df23,0xdba3d8c7,0xeca6e2aa,0xf5d8f3d0,0xedddf3ce,
0xe53de6dc,0xe7cae7af,0xe967e625,0xf5dbf0da,0xfb80f847,0x0196feb5,0x04e10397,0x03c50524,
0xfb23ffc5,0x0181fb09,0x0e0a0a82,0x0095088c,0x01c2fe8e,0x083105bd,0x126c0ba5,0x25411c16,
0x28d229a1,0x25b82764,0x1c9b2133,0x1b471b0f,0x19ba1b35,0x11f816e0,0xff540a0e,0xeeebf568,
0xefc9edd4,0xe71fee9c,0xd170dc92,0xc39ec8fd,0xc999c34c,0xda8ad2ce,0xda60dd6b,0xda24d75f,
0xeb64e0e6,0x00fbf753,0x024c04db,0x0449003d,0x10f90aa7,0x1ff7186c,0x2dc326df,0x37fe3417,
0x340e3846,0x25322da3,0x18a81d22,0x17fc1724,0x1320181f,0x05480b5c,0xff8e0216,0xfde6fd55,
0xf814fe57,0xe232ecd1,0xdbc8dc62,0xdc56dcde,0xd8d0da0a,0xe2ccdbf3,0xef18e936,0xfd49f5fc,
0xff100076,0xfd52fbc6,0x01660218,0xf7ccfae5,0xfaecf988,0xfc31faee,0xfddefddd,0xfeb5fd29,
0xfcdbff97,0xf6fdf944,0xfb08f739,0x1027044e,0x1a1317ed,0x1a0919c0,0x267e1e7e,0x301d2e1d,
0x232a2bdf,0x14791afd,0x111010ec,0x0ab50fc8,0x018904c6,0x001f00fe,0xf727fc1e,0xef0bf3b5,
0xdbb1e605,0xd65ed63e,0xd5dbd704,0xd1f7d3e4,0xcd72d03d,0xd0e4cc73,0xe63cd9bb,0xfe42f4ad,
0x027f015f,0x01cb0291,0x03760195,0x0fea08dc,0x2121175d,0x35c72c5c,0x3bb23acc,0x38f33ac5,
0x30933505,0x23b92b79,0x0ac3188d,0xf25afd0c,0xef34ecf1,0xfe07f794,0xf6bdfc92,0xe99bf0a8,
0xe393e346,0xeb3fe818,0xed63ec42,0xea0ced84,0xe374e5a2,0xe6ffe3b4,0xf94dee77,0x08e0030a,
0x068909b0,0xff5602d5,0xf7eafb40,0xf662f6a7,0xf26bf4ec,0xf4dcf20d,0xff90f9e6,0x06e5041d,
0x0b7b09d2,0x0c020b93,0x08000bd4,0x08d00478,0x1fa21495,0x266c25d2,0x19a12118,0x158b157d,
0x1ba617a4,0x1dde1f28,0x0c28165b,0xfc73028f,0xfe23fc27,0xf8a7fd03,0xef61f3c9,0xdd39e7e6,
0xcb6bd30d,0xc957c82a,0xd0b3cd30,0xd22dd1de,0xd788d381,0xe748de68,0xfe35f27c,0x0718055f,
0x0e730919,0x17d01455,0x21901be0,0x2a91262f,0x2c402d04,0x299529ec,0x2ce82b1f,0x2c312daa,
0x1b7026c3,0xfcb60ba8,0xef8af2e7,0xf587f1ea,0xf468f712,0xe87fed88,0xeec9ea30,0xf47af1bc,
0xf712f79c,0xe818f073,0xe246e2f7,0xe8dee4f9,0xee6beb8a,0xf8d1f379,0xfd18fc7c,0xfb6cfb49,
0x071e003a,0x10580cd9,0x098b101a,0xf13cfd69,0xf1a8ed29,0xf6c9f630,0xfb0ef801,0xff51fcf7,
0x07d40395,0x0f150b8d,0x1869131c,0x19441b9a,0x1af11708,0x2266205c,0x27ba249f,0x1b702510,
0x0ec812d6,0x08e20b7d,0x08fa08f6,0xfefb05af,0xe813f480,0xd4e2dcca,0xd36ed1c3,0xd920d7bb,
0xcefbd4c5,0xca49cb19,0xd8b2cf3f,0xe8abe120,0xf995f160,0x0521ffc3,0x0ea00a7c,0x0c3a0e75,
0x14500d53,0x25f51e47,0x2b31295d,0x28172b40,0x251c24ca,0x299f2859,0x1e892676,0x08b01300,
0x070a0589,0x0107060a,0xf881fbeb,0xeb88f343,0xdf40e3cf,0xe146ded7,0xe64ee3e8,0xef3aea63,
0xf260f1a6,0xf3b9f2c5,0xf561f4ec,0xf88ff658,0xffecfc2f,0x010401c6,0x03cd0113,0x05bb0678,
0xfc79014d,0xf95df9e5,0xf790f8a5,0xf808f76d,0xf737f823,0xfaa1f764,0xfb23fc80,0xff10fb4d,
0x0eb40572,0x23f71a3b,0x29c42965,0x236326fc,0x1f9920e0,0x1b1e1e6c,0x0df1145c,0x0eab0c9c,
0x0a890e96,0xfbe903f7,0xeb29f319,0xe6cce6d6,0xe76ae801,0xdabee334,0xc84ed028,0xcbdbc6e3,
0xdd74d454,0xe6eae418,0xe586e5ed,0xf359e9e7,0x060afdd6,0x0f910b65,0x16671389,0x1b8c18bb,
0x21a71ec6,0x2add24e3,0x37783244,0x316437a5,0x1bf126c3,0x0c0d1301,0x01c006f4,0xfac1fd35,
0xf3eef830,0xf046f0fa,0xebd6eefd,0xe85be955,0xe486e6e5,0xe6e3e455,0xee61ea2e,0xf674f314,
0xfeb0f98a,0x07ac0454,0x04c406f4,0xfea90288,0xf580f951,0xfba7f698,0x0001004b,0xf6f7fb28,
0xf50df5ed,0xf441f356,0x0084f9c1,0x05e60513,0x0004031b,0xfbe9fe5c,0xffd9fb2f,0x106d0882,
0x1adc1664,0x1e9e1d40,0x24262132,0x252b25c9,0x212f23bf,0x11d01b25,0x05bb0995,0x022d04bb,
0xf566fbd4,0xf3aef32c,0xeacff09e,0xddb8e4aa,0xd142d60c,0xd107d0e3,0xcc4ecea5,0xce7ccc11,
0xdee7d478,0xfa53ec91,0x08c903e6,0x0cdc0b00,0x12f20f15,0x1c69183e,0x20f61e4e,0x2a4d25c9,
0x2e862d1f,0x27df2cc4,0x1d6322bd,0x124e179a,0x07300cf7,0x007e02c0,0xf5c9fcf7,0xeb54ee95,
0xecb9eb4c,0xf2e3f01e,0xeed7f1c2,0xebf5ed08,0xec41eb00,0xf2fff054,0xf11cf25e,0xf798f277,
0x041bfebb,0x07be06d3,0x0724079c,0x0553069d,0xfe8702e0,0xef22f739,0xecacea64,0xfdb0f561,
0xfc5eff3d,0xfb53fabc,0xfa22fafe,0xfd1efa76,0x0681018f,0x0b1e09d1,0x0c440bba,0x103f0d4f,
0x1c7c159b,0x291d2393,0x2bb62c6e,0x22fd2731,0x1be7202e,0x0bc41542,0xf3a20038,0xe2f0e88f,
0xe649e3fa,0xe108e517,0xd72edbfa,0xd5bbd439,0xda85d9c8,0xd1cbd5e6,0xd948d350,0xebcbe19e,
0xfbcff577,0x06550044,0x183f0ee4,0x20441e9b,0x1c4c1ec0,0x1be51a40,0x27972221,0x254a27ba,
0x221e23cc,0x18a51deb,0x11301450,0x086d0de6,0xf8130076,0xf083f2b9,0xf244f0bf,0xf0ccf30b,
0xe884ec76,0xe51be5ba,0xea19e726,0xf136ed0b,0xfbb4f6eb,0xfea0fda7,0x035500ef,0x03340386,
0x05fb0435,0x04b5062c,0x01fd02ae,0x01c6024c,0xf7d1fe1a,0xedc6f1c7,0xe850eaa8,0xed8fe895,
0xfe2ff670,0xff7400cd,0xfed7fe1d,0x078601c4,0x16860f30,0x1b771ab9,0x184a19b6,0x1ab118fa,
0x1ec71c8b,0x226420e2,0x208d22b8,0x12ae1b29,0x017d08d7,0xfc30fe5c,0xeed0f737,0xda7fe509,
0xca49d070,0xd3b3cbe0,0xe184dc74,0xdef0e1ba,0xdabfdbf3,0xe2aedcab,0xf232eac2,0xfeb5f8b9,
0x093f0497,0x0def0bab,0x1c4513c5,0x286a233d,0x2d152c17,0x26fd2b2f,0x1d1821c1,0x1c211b73,
0x16141b16,0x06ef0ece,0xf7acfee0,0xf1d4f37b,0xf13af15a,0xf05af131,0xeb7bee16,0xea08e9fc,
0xee9febd2,0xf343f17d,0xf42cf3b0,0xfba1f6f9,0x04a10034,0x0ce208ff,0x0b5a0e08,0x03860737,
0xfd280050,0xf694f9f1,0xf43cf4bb,0xf0c3f2da,0xf437f0d9,0xf86ff7f5,0xf5eef6ee,0xf460f551,
0xf574f367,0x05affc21,0x16580f3f,0x175f18e1,0x159e1598,0x1a211732,0x247b1f0f,0x22d1265b,
0x16de1cd8,0x0fcb128a,0x0cf10e76,0x09b70b3d,0x00f40713,0xe488f4b7,0xd177d758,0xd834d2d2,
0xd95fdbaa,0xcc41d2bb,0xcd23c989,0xe3a3d6e3,0xf8b8ef61,0x01baff04,0x03860272,0x0bdc069c,
0x185d11fb,0x23681ee8,0x237f245a,0x22ff22f8,0x22c022dd,0x22a222e1,0x1d6a2147,0x06c714cb,
0xf1a1f901,0xf168f0b0,0xf43af20f,0xf808f758,0xf1fef56e,0xec41eefa,0xec96ead8,0xf57df0cb,
0xf8c2f889,0xf76df788,0xfdd5f9bb,0x0597024d,0x067706b5,0x07cc067a,0x09850936,0x00ac06ec,
0xf47af96c,0xef6bf1b6,0xeb5becd1,0xef2eec4a,0xf5f6f282,0xfc4ef9d6,0xfa0afbe5,0xfb6df9ac,
0x0189fe7b,0x09130490,0x1a5510c7,0x25ec222a,0x24a8264f,0x21082288,0x1cb61f72,0x172019ae,
0x100613f8,0x08520bdc,0xff8704b5,0xee8cf808,0xdc86e483,0xd9f2d8dc,0xdd07dcab,0xd1cbd8f8,
0xc9aacadf,0xdb89d05b,0xed68e641,0xf420f0ff,0x0376fa4b,0x15e70dd1,0x1a3319d4,0x1bf51a84,
0x1c821ce4,0x19d31b3c,0x1b1a1977,0x20241e1c,0x1e322029,0x14b01aa2,0x04d30cc4,0xfa3bfef3,
0xf1c2f5b0,0xec69eeea,0xe8f0ea2b,0xedb9ea1a,0xf3b0f136,0xf9a0f621,0xfca5fca1,0xf6d7f9da,
0xf806f5a5,0x0355fdcf,0x07f90674,0x0ac8099e,0x0a1a0b13,0x034f073a,0xf9ecff4b,0xf016f393,
0xf16df098,0xec0aef18,0xede6ebd3,0xf098efa2,0xf4acf204,0xfc4ef871,0x04cb000e,0x0f0c0a4e,
0x14071234,0x17df1592,0x1cdd1a82,0x252b1fa2,0x2e692c04,0x1e3628f9,0x0a391256,0x077e0755,
0x033406f5,0xf41ffc1d,0xe75ced6d,0xddc0e1af,0xddbddd08,0xdae0dd67,0xd2add676,0xd616d23a,
0xe46fdd21,0xeec0e9d8,0xf9a0f42f,0x03b8fe94,0x0f55093f,0x1d5515dd,0x2cb225f5,0x268d2d09,
0x17da1de7,0x16db15cf,0x1a411944,0x12811826,0x025e0a9e,0xfb3cfc83,0x01ebfe8d,0xfc64018f,
0xeb26f463,0xe048e388,0xe995e299,0xf93bf29a,0xf9c8fb16,0xfd6cf9d1,0x05650258,0x05dc05c8,
0x05c1064a,0x02a203b5,0x050f03d1,0x019903c5,0xfee70044,0xf93bfc7d,0xefeef489,0xedecede6,
0xeb30ece0,0xecb9eacf,0xf3caf012,0xf7eff646,0xff63fab3,0x08360417,0x0f270bc3,0x17141272,
0x23391d30,0x27fd270f,0x1f86256f,0x142018d1,0x14cc12d3,0x19d918b5,0x0cb215d4,0xf50800ea,
0xe891ec66,0xe90be863,0xe221e7c7,0xd0b7d926,0xcf5acd58,0xdb5cd4d9,0xe5c4e13a,0xea43e86c,
0xf121ecb5,0x0066f82f,0x0df007e2,0x17ed1332,0x1e6b1bcb,0x1efa1f43,0x1e791e79,0x21131f4a,
0x239a233f,0x13801ed3,0xfb3005a3,0xf88df72b,0xff74fc31,0xfa92ff38,0xeefdf3d3,0xf09eee23,
0xf66af3f0,0xf5abf718,0xf18af344,0xf18cf0c2,0xfcb6f58b,0x093d0400,0x0e760c62,0x0e620f3f,
0x08940bfd,0xff130405,0xf69efa4c,0xf449f4c1,0xf443f47a,0xf1dbf337,0xeffaf0cf,0xedbfeea1,
0xf32eef5e,0xf72cf667,0xf7a1f6cc,0xfe1dfa15,0x081502df,0x11640cfd,0x1c391619,0x29b023ed,
0x27852a67,0x22112468,0x1d3b1fd9,0x12e519b3,0x00d00972,0xf823faee,0xf928f811,0xf3bdf863,
0xe346ec34,0xd360da50,0xd2add099,0xdceed7c0,0xe12de011,0xe2a0e166,0xee3ce687,0x0026f7f3,
0x086c0558,0x0d840ad1,0x17431190,0x1f991cbf,0x1eb01fa5,0x1e9f1e29,0x1f4d1f78,0x18031d03,
0x0a361117,0x02700576,0xfbcefffe,0xefbcf5e4,0xec9bec1b,0xf650f0f1,0xf733f8d3,0xf1a9f392,
0xfa02f456,0x00ddfee7,0xfbfcff75,0xfa63f95f,0x02aafe60,0x099b066b,0x0bd70b7d,0x0a550b6d,
0x049207cc,0xfcc300df,0xf2c9f7b0,0xe618eca3,0xe296e1bb,0xeea4e7e6,0xf7adf463,0xf71bf840,
0xf7dff67f,0xff69fb51,0x05730324,0x095406ef,0x15870e6a,0x20491c33,0x236d2224,0x251c24b8,
0x238b24b8,0x1b3520c9,0x0b60139e,0xfe8e03e6,0xfa49fc15,0xedb8f5b0,0xdf4ee4fa,0xe18dde71,
0xe434e478,0xdb87e084,0xd6f4d7ba,0xddd6d960,0xe95ee321,0xf7ddf0a9,0x04fefe6c,0x10600b23,
0x16bf145c,0x185717d2,0x17691830,0x1b6a1823,0x21d71fe0,0x1ac01ffb,0x0d8313f0,0x05e50913,
0xffc502fc,0xf5edfb37,0xef8cf119,0xf2ecf0e8,0xf145f302,0xf1edf012,0xfb42f658,0x0087ff05,
0xfce8ffb5,0xfc97fb18,0x065c00cb,0x0e210b73,0x08700ca8,0xff990340,0xff81fe31,0x01fe015b,
0xfc2e001a,0xf1c6f700,0xe77cec56,0xe722e586,0xed0dea7d,0xf0c2eecc,0xf80df3d3,0x0019fc9b,
0x04c8025a,0x0c620867,0x11040f27,0x148b12b1,0x197d16b9,0x24651e68,0x27c0282a,0x1fe2246e,
0x14641a95,0x085a0dde,0xfebc03b5,0xf285f8d0,0xe4a9ebb2,0xda29de1f,0xda23d929,0xddfedbee,
0xe391e0ab,0xe7d3e611,0xe9bde91b,0xed8feab0,0xf938f2c8,0x0680ffdd,0x11330c9c,0x14fd13a4,
0x1a16170d,0x1df21ca3,0x1e8d1e9e,0x18831caf,0x0e2812e5,0x0bf00be8,0x08430bb6,0xf92f0178,
0xee6ef220,0xf176eeb0,0xf27cf31a,0xf14af0e0,0xf9f7f4d0,0xfe53fd98,0xfda9fd83,0x0195ff42,
0x050f03a1,0x05c605af,0x074a0611,0x08e40899,0x06370849,0xffa90305,0xf823fc4c,0xf0dcf3a5,
0xefa2f02b,0xe9f3ed48,0xeb83e8bc,0xf393f025,0xf399f4a5,0xf169f1d4,0xfac5f45a,0x0c22030e,
0x18691412,0x181618d3,0x1ab818cc,0x1f2c1cf9,0x217920f9,0x1b9a1fb7,0x11481655,0x0d210df7,
0x0ada0d16,0xfdf90576,0xed1df594,0xe096e5d1,0xdd0fdded,0xdededdbf,0xde1edf0e,0xdcf9dce2,
0xe32aded2,0xf2e8e9ee,0x0385fc46,0x05a5069c,0x03d103d5,0x0a6f062c,0x15620fa3,0x1dd91a8a,
0x1a841d97,0x17021788,0x188d1810,0x14181777,0x06e80e44,0xf8a6ff4a,0xf342f480,0xf4c6f3fb,
0xf2acf47a,0xee69eff4,0xf5eaf071,0x012ffc97,0xffa301df,0xfdb0fd44,0x043500e8,0x05e70594,
0x0a49073a,0x0df40d58,0x05560ad7,0xfd5e0050,0xfb49fbf9,0xf7aafa3a,0xececf2d0,0xe4e7e7ef,
0xe832e4cf,0xf424ee51,0xf774f737,0xf600f64f,0xfe67f8ad,0x081c0492,0x07130838,0x09510727,
0x139e0d58,0x23f11bb0,0x2c242a46,0x217f28db,0x10bf1883,0x0adb0c2b,0x0bff0ba2,0x04470a0b,
0xf226fb79,0xe793eb3a,0xe600e64e,0xe306e52d,0xdc5edfc4,0xd9c1d9f5,0xe05adc13,0xed4ae636,
0xf98bf46e,0xfda1fc11,0x05900082,0x14250c83,0x1ba619eb,0x140018e6,0x0e150fa0,0x112a0f2a,
0x15931313,0x15ea173a,0x0cc11165,0x074a09bf,0xfd6a034a,0xf1cff6f9,0xeb67eddf,0xec7aead3,
0xf62df07a,0x0086fc39,0x01bb0250,0xfedafff5,0x0478004d,0x0b2008f2,0x068a09f3,0x008f02e3,
0x00ccfff5,0x05350317,0x049905d7,0xfbb70151,0xee7cf4b6,0xe897ea64,0xec11e938,0xf02eef06,
0xef4ceff4,0xf0c7ef34,0xfb83f55a,0x04e900f4,0x076f0709,0x09940787,0x12fe0e0e,0x1bbf17aa,
0x20241ee0,0x1fb6200d,0x1ee01f72,0x19661d1d,0x0c7c135b,0x0066063b,0xf4c3fa6e,0xeb58efc6,
0xe6a5e80d,0xe774e6fb,0xe585e732,0xdf32e26c,0xdfd2ddd5,0xe918e46d,0xeff8ecb2,0xf763f3aa,
0x0159fb9c,0x0e53085c,0x15541253,0x183e179a,0x15f91708,0x14d415c4,0x0e21120d,0x0a0e0b6d,
0x07e20930,0x064306d1,0x05f70667,0x01380435,0xf9b2fd80,0xf335f664,0xeef3f072,0xf1b6ef67,
0xf7ccf4c6,0xfeddfb27,0x046c021a,0x08b7066c,0x0ad70a8f,0x092f0a0c,0x07550886,0x020f04ff,
0xff320002,0xfc77fe54,0xf5c2f960,0xedecf1a3,0xeaa2eb9a,0xea9bea77,0xeb12eab4,0xf034ec69,
0xfb8ef5c4,0x03bc0039,0x05db057e,0x078b062c,0x0e530a49,0x188313a4,0x1d4c1baa,0x1f321e73,
0x1d101f04,0x15aa198e,0x0f481231,0x097b0c66,0x00fd0629,0xf15df972,0xe690eac0,0xe5dce4e7,
0xe6d9e741,0xe2f1e4ba,0xe37fe284,0xea03e605,0xf1faee8a,0xf472f3be,0xf69ef540,0xfe4ef965,
0x0dfd0594,0x1a6f1548,0x1a831c30,0x127b1670,0x11241098,0x12f2125b,0x0fc5124d,0x03950a83,
0xfad4fdaa,0xfcf4fb37,0xfeb2fe7a,0xfa8dfd1d,0xf5dbf7fc,0xf577f4d0,0xf9ccf7cc,0xf910fa05,
0xfb8ef91a,0x0448ffcb,0x0bd70882,0x0e650e03,0x0a940d10,0x05210799,0x012f0331,0xfbbafed5,
0xf3a9f816,0xeca6ef90,0xebb2eb83,0xee33ecc7,0xf054ef96,0xf04ff058,0xf571f1d4,0xff79fa90,
0x03e302b0,0x054d0438,0x09f90735,0x12190dbb,0x19e81656,0x1da31c70,0x1ad31cd1,0x18121911,
0x16fd17d3,0x0eea1424,0x004b07db,0xf3a9f91f,0xf118f125,0xf1acf220,0xe8e4ee56,0xdf80e35a,
0xe096de62,0xe781e45b,0xec4be9b1,0xf215ef1c,0xf8cdf513,0x009cfcc0,0x07f4043f,0x0ef60bc6,
0x121c10b5,0x16bd1442,0x18321832,0x146e170a,0x0bab106c,0x04c207ac,0xff870251,0xfc00fd33,
0xfb11fbb0,0xf764f95f,0xf76bf65e,0xfe59fa77,0x01f50129,0xfe4e00ba,0xfb37fbd8,0xff38fc97,
0x01b9011b,0x019f017f,0x050d02f3,0x0a1707d0,0x09fb0b1a,0x034f071e,0xfc27ff8b,0xf40ef863,
0xeccbefc3,0xe94aeabe,0xe8efe895,0xebdee9f4,0xf52eef7d,0x00fefba3,0x03aa03bc,0x01b50222,
0x07d403c5,0x0ee60c13,0x11201030,0x161212fe,0x1d3919ea,0x1e341ec4,0x19df1c66,0x128a16dc,
0x06470cf1,0xfb2c003e,0xf3aef72f,0xed79f093,0xe78eea52,0xe4aae595,0xe75be534,0xebebea34,
0xea4beb92,0xeb59e9a1,0xf526ef7d,0xff63facc,0x058e02c2,0x0b740855,0x11090e96,0x11d6121d,
0x108b1141,0x0cfa0f28,0x0b8a0b5e,0x0df20cf4,0x0c200db8,0x024c0831,0xf9bffce7,0xf92cf8f5,
0xfb24fa11,0xf9a7fb24,0xf6a1f7d2,0xf9f0f742,0x0291fe60,0x057c0519,0x032a04d3,0x000a010f,
0x04170127,0x05db0629,0x01f103da,0x00c600eb,0x023b012f,0x005d025d,0xf74ffc65,0xee16f277,
0xe7edeaad,0xe6a9e673,0xec1ce8bc,0xf45af00e,0xfcc9f878,0x0613014d,0x0dd30a32,0x13351130,
0x112912f4,0x10700fe0,0x158f12a5,0x1984181a,0x185c1974,0x13c4168d,0x0bb9100e,0x02bf072e,
0xfa78fe90,0xf1e6f64f,0xebdaee25,0xe9b1ea7d,0xe84ee8e3,0xe7b2e7b7,0xebc6e912,0xf197eee5,
0xf4dcf39a,0xf48df4f1,0xf800f510,0x03ccfd4c,0x0edf0a0e,0x13951225,0x121d1325,0x11ce11ad,
0x104c1147,0x0cea0f0e,0x05a50995,0x01e702f3,0x00fe01b5,0xff04ffef,0xfca9fe79,0xf650f977,
0xf558f4be,0xfb11f7b3,0x0078fe42,0x01950176,0x001600b2,0x04e9012d,0x0c840952,0x0a920cea,
0xff8d057e,0xf9a9fafb,0xfd09fb35,0xfcc3fda2,0xf8fffb37,0xf47af66a,0xf2e3f392,0xf086f1c2,
0xee04ef4d,0xed9aed28,0xf260ef83,0xfd03f6e6,0x091103a7,0x0e2c0c53,0x119e0fde,0x15c913ab,
0x185c1775,0x155417a4,0x0fba123b,0x0ef40ede,0x0eff0f52,0x0a760d72,0x0234066e,0xfb2ffe53,
0xf508f86a,0xec31f093,0xe75ae8f7,0xe72ce6e0,0xe859e7c4,0xeb44e96b,0xef47ed6d,0xf307f0e6,
0xfb53f676,0x058b00ba,0x0ac008c8,0x0d160c0e,0x0e4e0dd6,0x0fec0f1e,0x107f109a,0x0dab0f5f,
0x09e70bf6,0x02f60699,0xffd4008f,0xfe1eff54,0xfc39fcab,0xfe39fd05,0xfd06fe47,0xfaf3fb8f,
0xfb8efb21,0xfdcffc70,0x00caff8e,0x03aa021b,0x074c05b8,0x06ae07a3,0x033a04e6,0x01b1024d,
0xfe91008d,0xf9f7fc52,0xf5f5f782,0xf58ff5ad,0xf3b7f4a9,0xf535f401,0xf679f614,0xf6c9f6c9,
0xf34bf556,0xf22cf1c6,0xf9f0f4bf,0x04a9ffec,0x0907076f,0x0fd70bb8,0x1a7c153d,0x20bb1ee2,
0x1b341f61,0x117715f2,0x0bc30e2f,0x06870920,0x018603de,0xfcc9ff26,0xf753fa38,0xf266f478,
0xeffaf12a,0xebecee3c,0xe8b7e9e7,0xe918e86e,0xee32ead5,0xf4dcf1f5,0xf6eff627,0xfc70f8d1,
0x04c700c1,0x0b490822,0x10ea0e41,0x104611c1,0x0a3f0d06,0x097208ed,0x0b5e0aa5,0x088d0ab9,
0x023b0551,0x01fe0104,0x03f303ba,0xfe5001c0,0xf8a5fb09,0xf89df7b8,0x0002fbd8,0x021402b9,
0xfa4cfe69,0xfa65f893,0x0317fea0,0x093906fd,0x087909bc,0x02fd0607,0xfdf9001c,0xfdd4fd3b,
0xffa0ff14,0xf9a6fdd6,0xefc3f458,0xee11ed4a,0xf51bf160,0xf5bff6a5,0xf331f406,0xf630f400,
0xfde2f9af,0x04e6020d,0x04210585,0x02ea0270,0x0eb90717,0x1d1616f6,0x1ec61f7b,0x181f1bd1,
0x12c714f4,0x0d4c1088,0x039808c8,0xf8ddfe59,0xf206f468,0xf3d0f238,0xf6dbf5d7,0xf3dcf64b,
0xeec3f0cf,0xef2fee6e,0xf07ef037,0xed9def83,0xecbfec36,0xf359ef25,0xff47f8b5,0x0a8305d7,
0x0bc40c31,0x0ae40ac0,0x0f550c76,0x13e0123b,0x0e151290,0x03a3084f,0x01290170,0x03a40230,
0x054804f3,0x0116040f,0xfa4bfd3a,0xfb9cf9c4,0xfefbfe0c,0xfb30fdde,0xf782f87e,0xfe31f975,
0x07c7039b,0x0830092b,0x03ef0605,0x025802ba,0x02df028c,0x016202d1,0xfb9cfeb8,0xf62df8d8,
0xf320f42b,0xf457f35c,0xf64ff576,0xf4bef626,0xf1faf320,0xf600f2f0,0xfe3dfa57,0x024000c1,
0x033a02d2,0x055803bc,0x0bdc0830,0x10bf0f0c,0x109110fb,0x12ab10f9,0x170a1530,0x16621780,
0x0fb913c2,0x05bb0a97,0xfd52018d,0xf3d3f896,0xee96f04f,0xed9cedf1,0xed54ed83,0xef3eedd5,
0xf400f193,0xf55bf53e,0xf2b5f456,0xf12bf155,0xf42bf222,0xfc6ef792,0x06f401f5,0x0c720a5c,
0x113c0e9a,0x14b713c9,0x0f8c1329,0x07a50b28,0x055405c8,0x045d0526,0x00060280,0xfc28fdb7,
0xfbcffb7d,0x0094fd80,0x05a10408,0xff9703b1,0xf948fb58,0xfc25f9c8,0x006efeca,0xffa90050,
0x01d4ffc9,0x072404ec,0x044906db,0xff320158,0xfc24fdb7,0xf95ffa92,0xf8ddf8e1,0xf8bff8dd,
0xf7fdf881,0xf589f6d9,0xf2eef40e,0xf3d9f2a9,0xf9e8f680,0xfe05fcca,0xfd86fdd2,0x01e7feec,
0x096f05e7,0x0d900c13,0x10450ecc,0x146d1259,0x160f15ed,0x11591460,0x0cfb0e78,0x0c200ca5,
0x06aa0a24,0xfd99025f,0xf4cff8d8,0xef9bf1db,0xeb58ed8a,0xe7fee946,0xea0ce802,0xf279edea,
0xf870f632,0xf9caf984,0xfb71fa54,0xfdc7fcfa,0xfe42fdfc,0x00f4ff56,0x04380271,0x0a6f06ca,
0x11760e4d,0x12a31319,0x0ca6102e,0x080009bf,0x053b06e2,0xfffd02d1,0xfc40fd95,0xfcb4fc1c,
0xff14fdda,0xffc3ffdd,0xfdbefeb5,0xfe98fdc3,0xfe84ff07,0xfd33fd84,0xfffbfe30,0x0236018e,
0x013801e0,0x01df0127,0x056c03b3,0x012d04ee,0xf764fbd5,0xf5dff587,0xf956f7aa,0xf965fa15,
0xf4a8f77c,0xf1f8f262,0xf59bf367,0xf98df7c1,0xfd73fb53,0x01b8ff75,0x0743044e,0x0cfa0a5d,
0x10c70f22,0x1185117a,0x107c1111,0x0f710fcf,0x0fb00f85,0x0db40f4d,0x070c0ad7,0x0074035b,
0xfd13fe98,0xf8a5fb55,0xf269f599,0xed23ef8c,0xeb52ebad,0xed0bebdf,0xeef8ee01,0xf0a8efb4,
0xf6e2f2d7,0x008ffc09,0x039a0327,0x02de0303,0x04b3039c,0x04e50507,0x0649050f,0x09bc07f9,
0x0dbd0ba6,0x10b50fa9,0x0f8510c8,0x09290cdf,0x002c04b1,0xf9b8fc55,0xf82df88a,0xf981f896,
0xfc60fb04,0xfd1dfd1c,0xfe34fd29,0x013dffc2,0x042c02e8,0x03530473,0x0056014d,0x00fd0071,
0x001f00e2,0xfcfefed5,0xf9dafb4c,0xfb4ef9db,0xfda2fd1e,0xf935fc45,0xf24df55a,0xf387f193,
0xf9f0f6d2,0xfb4afb97,0xf881f9cd,0xfbb3f910,0x0336ff7e,0x085e0637,0x0c160a4b,0x0f3c0df1,
0x0ff00ff3,0x0fd80fdb,0x0f880fde,0x0d100e95,0x09700b56,0x061c07ae,0x039e04e1,0xfee901ac,
0xf6a1fafc,0xef5ff26d,0xed54edcd,0xecdeed3b,0xea80ebcd,0xec72ea58,0xf3d9f00e,0xf815f65d,
0xfc4ef9b8,0x0403ffa9,0x0b650839,0x0ca70cf1,0x08b20b04,0x062f06b7,0x07ee06f1,0x095008d7,
0x08860948,0x078d079f,0x0a3908b2,0x09fb0afb,0x024706de,0xf80dfce1,0xf506f550,0xf8dff68e,
0xfca5fb2a,0xfe11fd8c,0x000efeca,0x043301ed,0x062905d4,0x036704ff,0xffbe0195,0xfb6cfd78,
0xfa2bfa54,0xfad6fa83,0xfb35faf9,0xfc5bfbae,0xfd6ffcfa,0xfce0fd7c,0xf8b1fb28,0xf33bf5c6,
0xf2d1f20c,0xf95af587,0x008dfd8f,0x0358027c,0x07b104e4,0x0ef10b70,0x1191110e,0x103a10f2,
0x0f9a0fc5,0x0ebf0f4c,0x0d3e0df9,0x0a360c0e,0x03bf071e,0xfe8200bd,0xfaa1fca7,0xf5edf871,
0xf086f32e,0xebf9ee20,0xeb03eab9,0xef3aeccc,0xf1bcf10f,0xf18af1aa,0xf602f2b9,0x01d4fb9e,
0x08870693,0x06e0082b,0x075f0654,0x0bc10999,0x0c810ce6,0x097a0b26,0x069e07c1,0x056105da,
0x063e0572,0x07ee077a,0x04cb06de,0x022802fd,0x017801eb,0xfdc90028,0xf6abfa7b,0xf17ff34b,
0xf4b1f1ea,0xfe39f947,0x05b80288,0x06ef0738,0x0458058b,0x03e603eb,0x01f10367,0xfd3dffe9,
0xf76afa47,0xf55cf586,0xf951f6f5,0xfc5efb6d,0xfaa8fc11,0xf89ff938,0xf9f5f90a,0xfa6ffa9e,
0xf7b9f956,0xf8aff702,0x031afd0c,0x0e080944,0x11b410de,0x110e1164,0x10ec1105,0x0ed1102e,
0x0b820d40,0x083809bc,0x06920718,0x04f8060a,0xffec02c8,0xf920fc9e,0xf28df5b4,0xeeeaf03a,
0xee85ee72,0xef4feed7,0xef0aef6a,0xeeb4ee7c,0xf39af079,0xfb35f76f,0x0057fe26,0x032101e9,
0x07d3050b,0x0d690ae6,0x0f4b0ed3,0x0d890eb9,0x0a0e0bba,0x08c8090e,0x08e608df,0x066e081d,
0x01ba0424,0xfe1affac,0xfe60fdbc,0xff22ff1f,0xfde6fe97,0xfc78fd67,0xf8edfabf,0xf7d1f7c8,
0xfabff8df,0xff7cfd33,0x03360186,0x062504a1,0x07610731,0x03550605,0xfd4e0019,0xfa24fb5e,
0xf78ef901,0xf659f69b,0xf75cf6cc,0xf8bbf808,0xf9dff94b,0xfc06fab8,0xfe3dfd46,0xfe99fea3,
0xfe8bfe7a,0x0086ff19,0x05c102b4,0x0cab092d,0x11b40f83,0x133e130b,0x10cc125c,0x0ddd0f70,
0x09320bb6,0x052b070a,0x01af0376,0xfd6affd7,0xf7d8fac0,0xf24df508,0xeebaf00b,0xede5ee1c,
0xecd3ed5a,0xecbbec84,0xf0a5edfa,0xf7fcf460,0xfc40faa5,0x0002fdd5,0x06770333,0x0b310949,
0x0cfd0c44,0x0f330e0a,0x0f350ff6,0x0abb0d38,0x079208a5,0x065006f8,0x027d04da,0xfdb8ffe3,
0xfcf9fcb9,0x0034fe53,0x00a00122,0xfba5fe67,0xf85ff975,0xfaf1f8e6,0xffe2fde0,0xfe48fff9,
0xfa38fbcc,0xfc5efa5f,0x0200ff47,0x05a30452,0x057f0619,0x02cd0445,0xff8d0127,0xfbd8fdb0,
0xf73ef9ae,0xf350f4e9,0xf2f4f294,0xf6bdf456,0xfc98f9b2,0xfed0fe72,0xfe17fe48,0x0172ff10,
0x081304e5,0x0aad0a31,0x09140a12,0x095408ac,0x0ed30b88,0x14731222,0x133714e5,0x0bbd0fc8,
0x060c0855,0x00e603da,0xf7dbfcb4,0xef85f329,0xed39ed78,0xf00bee6e,0xf130f13a,0xeed5f025,
0xef04ee48,0xf4fbf17d,0xfafef887,0xfce4fc34,0xfff9fdf9,0x05f802c5,0x0c380957,0x0ee70e34,
0x0e230eba,0x0ca60d5f,0x0cc40c62,0x0ce80d4c,0x06d50ac4,0xfe3101fe,0xfcabfc58,0xfea2fdce,
0xfce1fe2c,0xf960fb11,0xf8cdf87d,0xfc64fa4b,0xfebbfe14,0xfd44fe55,0xfc03fc28,0x0002fd80,
0x03a4027d,0x01a20316,0xff1d0013,0xff41fea5,0x02ba007d,0x063204ec,0x01b40526,0xf78ffcd3,
0xf14af377,0xf1ccf106,0xf42bf2d5,0xf670f55a,0xfa49f7ea,0x0264fddd,0x0aac0723,0x0c810c66,
0x0a9b0ba0,0x0a690a08,0x0cef0b85,0x0d830dcc,0x0abb0c38,0x0ad10a14,0x0e0a0c7b,0x0bae0e16,
0x01220703,0xf627fb3b,0xefeef27b,0xec42eddf,0xea94eb1e,0xebfeeadc,0xf0c6ee01,0xf614f3aa,
0xf875f7c1,0xf92ff8c4,0xfbc3fa1c,0x016afe44,0x08b2052f,0x0db40b9b,0x0ef00ed8,0x0f350ebf,
0x11fb1088,0x1055123b,0x07670c86,0xfe82024c,0xfd35fcc7,0xff1ffe6c,0xfc33fe4e,0xf7e6f9be,
0xf7fcf745,0xfb1cf968,0xfcfafc67,0xfd15fd02,0xfea9fd89,0x00e8ffe9,0x01df019f,0x02110215,
0x026a0233,0x01c6027d,0xff7000a2,0xfe8dfea2,0x001fff62,0xfee20019,0xfb41fcf3,0xf868f9b4,
0xf64bf745,0xf36cf4f6,0xf289f23e,0xf7e6f44a,0x019dfc8b,0x0a1e0672,0x0dfd0c9b,0x0f8b0eeb,
0x0f2f0fb5,0x0beb0dd1,0x09f90a70,0x0b9b0aa4,0x0c2d0c3f,0x09670b41,0x055f074e,0x016203a1,
0xf9f5fe23,0xf0dcf56b,0xe9f9ecde,0xe825e875,0xe925e863,0xed53ead3,0xf3e9f08c,0xfb4df771,
0x0211ff11,0x044103bc,0x0492044e,0x07050574,0x0b74093d,0x0ead0d65,0x10640fa1,0x10b410da,
0x0ca80f2c,0x074a09e3,0x020304d1,0xfc7dff50,0xf863fa35,0xf6e2f727,0xf8edf789,0xfb0cfa44,
0xfb0ffb28,0xfbf2fb42,0xfd83fca7,0x0028feb2,0x02ea0199,0x045f03c8,0x03550436,0x000f019d,
0xff27ff1e,0x01d80046,0x02e30309,0xfe910138,0xf953fb84,0xf91af87e,0xfa1cf9e8,0xf86cf981,
0xf55cf6fd,0xf37ff3f5,0xf7a7f4b8,0x000efbd8,0x06ae03b8,0x0be90954,0x11110ea0,0x142012ff,
0x13a41458,0x0f5811f6,0x09390c3f,0x05d206fd,0x0517055f,0x02bc0473,0xfb4cff92,0xf3acf6de,
0xf10df1fe,0xef77f03d,0xed65ee8a,0xeb10ebfd,0xed10eb5d,0xf273ef85,0xf932f5bd,0xffcffc97,
0x06ae0327,0x0ceb0a30,0x0dbb0e06,0x0cd30d16,0x0d960d2e,0x0d5d0dc4,0x0c0e0cc1,0x09f50b49,
0x06050815,0x014403b1,0xfc67febc,0xf8b5fa6f,0xf658f74f,0xf63df612,0xf758f6b7,0xf9c8f85c,
0xfcdcfb57,0xff4efe23,0x020c007a,0x051603a4,0x05c105e0,0x03a404db,0x028802b4,0x034302c4,
0x015102f6,0xfbe1fec1,0xfa1cfa3a,0xfc9ffb46,0xfb43fcc0,0xf568f870,0xf2b6f33e,0xf5d8f3cd,
0xfa69f848,0xfdb2fc2e,0x0164ff59,0x06c103ec,0x0c4109a7,0x0f670e26,0x110c1058,0x125611c1,
0x11bc1262,0x0e5f105e,0x089c0bb4,0x015f0504,0xfa9afdcc,0xf550f7d6,0xf1c4f323,0xeff9f0da,
0xee14eeeb,0xee8aedf6,0xf001ef58,0xf1b6f0c2,0xf3d3f2d4,0xf811f53d,0xffddfbdc,0x06610367,
0x0c530955,0x12460f67,0x15b11499,0x122f14e2,0x0b260e9a,0x079408ba,0x058e06d3,0x01410395,
0xfe17ff92,0xfbc0fcfa,0xf9aefab3,0xf833f8dd,0xf66ef776,0xf4bff54d,0xf7aaf587,0xfddefaa5,
0x028e0069,0x05ca0445,0x076306ef,0x06900741,0x04b5058b,0x03aa0417,0x00f502ac,0xfd1cfeff,
0xfb68fc06,0xfa47fb01,0xf920f989,0xf89af8e3,0xf813f85f,0xf763f7ca,0xf65df6c6,0xf78ef65d,
0xfdc9fa2f,0x04d10150,0x09c4078d,0x0d040b6f,0x0ffc0e8f,0x11841110,0x10b01155,0x0f780ffe,
0x0def0ee4,0x0a1a0c62,0x033e072b,0xf896fe60,0xee04f2e9,0xe9f9eaef,0xec63ead8,0xee7ced9d,
0xf04eef5c,0xf1e3f10b,0xf5ebf37b,0xfad3f8a3,0xfc4cfbfd,0xfd1cfc65,0x03e1ff68,0x0f8b09d2,
0x1523137e,0x143d1506,0x12fb1377,0x10881222,0x09890dba,0xfef3045b,0xf77dfa47,0xf792f6d7,
0xfa78f903,0xfc37fbce,0xf9fefb7c,0xf782f888,0xf81df768,0xfadff98d,0xfc1efbb3,0xfeeffcfe,
0x049901a6,0x08cf0700,0x0ac40a17,0x08e90a76,0x03970669,0xfece00de,0xfc00fd12,0xfa31fb16,
0xf81df914,0xf798f785,0xf813f80d,0xf60ff75e,0xf4d7f4ee,0xf8d6f646,0xfe8bfbcc,0x01780056,
0x02ec0214,0x08cb0511,0x11440d43,0x13db1393,0x10bb128d,0x0e580f33,0x0e0f0e19,0x0ca80dd9,
0x070e0a60,0xfe9e030f,0xf630fa1c,0xf108f34b,0xec7feee4,0xe7a4e9de,0xe766e699,0xee1dea0c,
0xf687f26b,0xfd1efa17,0xfef2fec1,0xfe6cfe60,0x02c0ffed,0x09e20662,0x0dfb0cb2,0x0e6a0e42,
0x117e0f63,0x14c913af,0x10f213db,0x07c30cb1,0xfed002e4,0xf916fb83,0xf613f75e,0xf4c1f531,
0xf4b7f49b,0xf69df549,0xfb1ff8af,0xfe1afd18,0xfe30fe5a,0xfe8dfe2c,0x0059ff4a,0x044e0221,
0x086e0690,0x09760951,0x07e208d2,0x059c06e0,0x01c80408,0xfb35fed0,0xf50df7b8,0xf2d1f36c,
0xf493f345,0xf7b1f640,0xf826f853,0xf76df797,0xf9baf823,0xfe7efc03,0x036a00dd,0x088005f9,
0x0cae0ac0,0x0ec80e0a,0x0f700f0a,0x112e102d,0x11171188,0x0e530fe4,0x09cb0c41,0x02850687,
0xf9bbfe2c,0xf35cf61c,0xef37f14c,0xeb07ed08,0xe912e9ba,0xeb12e992,0xf023ed70,0xf55af2d4,
0xfa77f7d0,0xff9ffd05,0x05a3025f,0x0b2808e8,0x0bfa0c08,0x0ceb0c26,0x100f0e71,0x122911a5,
0x0ffc11c3,0x0aca0da8,0x043a07b5,0xfd02007a,0xf8f1fa65,0xf7bff835,0xf5acf6ea,0xf2a9f420,
0xf226f1c2,0xf87df486,0x0028fce5,0x02a201f7,0x032202c9,0x059d041f,0x08380735,0x075f0843,
0x047805e0,0x037c03af,0x035a037e,0x01c002cc,0xfdd50028,0xf7b1fac1,0xf310f4f4,0xf219f20c,
0xf31af2a3,0xf3ebf345,0xf884f594,0xffb0fc2a,0x0449027d,0x0637054d,0x09a20799,0x0e0d0bcf,
0x11350fd5,0x114611d5,0x0df40fdb,0x0be50c66,0x0c930c32,0x09af0bf4,0x009005aa,0xf680fb1b,
0xf1b5f37b,0xeda1f00b,0xe7c9ea99,0xe699e647,0xecaee8e7,0xf510f122,0xf94cf7cb,0xfb3cfa2b,
0x003dfd37,0x08b5045a,0x0e6f0c65,0x0ec10eea,0x0fcb0efd,0x10e5109e,0x0fcb1097,0x0c0a0e67,
0x04c108b9,0xfe47011f,0xfbb6fc85,0xfa8bfb58,0xf709f925,0xf3f7f51d,0xf4c1f3ec,0xf73ff5e1,
0xf972f87b,0xfa8dfa0d,0xfe60fbce,0x06ae0229,0x0d310aa9,0x0cc70dc5,0x08690ab7,0x046e0636,
0x01e00329,0xfee3007d,0xfb33fcf6,0xf7eef943,0xf75df740,0xf7a8f7d0,0xf4b5f6b5,0xf0dcf273,
0xf257f0bf,0xf7c1f4e2,0xfd53fa93,0x0473008b,0x0c92089a,0x11500f8e,0x1091116d,0x0e600f5e,
0x0d4e0db7,0x0d780d41,0x0d650db3,0x09950c18,0x029c0629,0xfd54ffa8,0xf91bfb65,0xf264f61e,
0xeb78ee99,0xe9f7e9d0,0xedc0eb87,0xf1deeffc,0xf5a3f3b4,0xfa59f7b6,0x0157fd99,0x079904fc,
0x09670902,0x09530962,0x0b0009cb,0x0f0e0cdb,0x10691084,0x0af30e70,0x031806de,0xfe5c003a,
0xfbc6fcfb,0xf8abfa4e,0xf596f6ec,0xf4e0f4d6,0xf746f5c7,0xfa83f910,0xfbdffb68,0xfd75fc73,
0x01a3ff39,0x06ce043f,0x0a8908ed,0x0c9d0bb2,0x0dd10d5e,0x0ce10dcb,0x084c0b08,0x016204ed,
0xfb03fe09,0xf647f879,0xf35af47f,0xf2f4f2f0,0xf34ff331,0xf387f373,0xf3edf3a4,0xf568f47a,
0xf798f678,0xfb68f906,0x0299fea0,0x0a10068b,0x0ff00d29,0x1436125a,0x14dc1531,0x1017131b,
0x09b80cc6,0x065007a1,0x044d0567,0x012302e2,0xfd0bff45,0xf7defa90,0xf397f574,0xf186f256,
0xeff2f0c1,0xef4cef58,0xf2bff06a,0xf9ecf614,0x0072fd6f,0x051602f0,0x081b06d0,0x09bc0912,
0x0a580a24,0x0a020a41,0x08750966,0x05bd0741,0x029e0434,0xff46010a,0xfc2ffda7,0xf959fac5,
0xf6a6f7f3,0xf508f5a9,0xf519f4c4,0xf7ebf613,0xfd24fa76,0x00f6ff3c,0x0389023f,0x06d90500,
0x0b1a08f4,0x0df70cdf,0x0e2c0e5f,0x0d470dc2,0x0c080cc5,0x09230ae6,0x031806a6,0xf98bfeae,
0xf0b7f4ba,0xed43ee2f,0xeeceedc3,0xf039efa2,0xf1b1f0d3,0xf42af2c5,0xf849f606,0xfc74fa96,
0xfea3fdc9,0x00c2ff7f,0x069302fa,0x0fb40b2e,0x14971310,0x13d514a2,0x121912ee,0x0f611111,
0x08980ca2,0xfe71039b,0xf74af9ff,0xf6d5f674,0xf864f7ad,0xf875f8c0,0xf607f764,0xf451f4e4,
0xf578f48c,0xf8a7f709,0xfb09fa00,0xfe88fc58,0x04ca0174,0x09e807ac,0x0c370b65,0x0b140c21,
0x0756094e,0x03d9056b,0x00900229,0xfd18fed4,0xfa05fb61,0xf8c8f919,0xf851f8b5,0xf602f75c,
0xf4a9f4e5,0xf7b1f5af,0xfca0fa2c,0xffc8fe79,0x0190009f,0x06de0390,0x0e750ada,0x112d10ae,
0x0eeb104c,0x0d190db8,0x0d270d0d,0x0c0d0d15,0x06ae09ea,0xfe7502be,0xf6a4fa31,0xf223f416,
0xee01f039,0xe971eb89,0xe927e873,0xef43eb93,0xf6ebf335,0xfcf6fa25,0xff7dfec7,0x0033ffa7,
0x047401d7,0x0ac307ad,0x0e850d4b,0x0ed10ec8,0x10e20f68,0x13451281,0x0fcb1263,0x07790bff,
0xfee902e3,0xf8e1fb86,0xf541f6dd,0xf393f425,0xf3a0f372,0xf573f438,0xf997f758,0xfcb4fb8a,
0xfd72fd3c,0xfe5cfdc2,0x005cff34,0x0466022d,0x089e06af,0x0a1f09af,0x095909ea,0x0754088c,
0x035b05ac,0xfcdb005d,0xf6bdf974,0xf3f4f4e8,0xf4bef3f1,0xf736f602,0xf7b9f7cc,0xf74ef753,
0xf9acf819,0xfe1efbd4,0x029e0047,0x076d0502,0x0bae09ae,0x0e1d0d33,0x0efb0e85,0x10a70fb6,
0x109110fd,0x0de70f6c,0x09710be0,0x025a063e,0xf9e0fe2a,0xf3acf65e,0xef95f1a1,0xeb89ed75,
0xe9baea51,0xeb9fea37,0xf06eedda,0xf58ef30b,0xfabcf80c,0xffedfd54,0x05d102a5,0x0b490904,
0x0c580c43,0x0d470c90,0x10070e9e,0x11d51169,0x0fa81164,0x0a8c0d5e,0x0412077e,0xfcf10060,
0xf8d5fa53,0xf78af80c,0xf56ff6af,0xf267f3e2,0xf1d2f176,0xf81ff42b,0xffe9fc8e,0x028801cb,
0x031702bc,0x058e0410,0x0839072a,0x07860858,0x04b80614,0x03c703f6,0x03ab03cd,0x021b0323,
0xfe260082,0xf7e8fb07,0xf32df51d,0xf227f221,0xf31bf2ab,0xf3e0f340,0xf86df582,0xff92fc11,
0x042f0261,0x06210536,0x09830780,0x0de50bad,0x110d0fac,0x112a11b2,0x0dea0fc8,0x0be10c61,
0x0c8a0c2f,0x09a30be9,0x008b05a0,0xf684fb1b,0xf1b9f37f,0xedaaf00f,0xe7dceaa7,0xe6abe65b,
0xecb7e8f5,0xf514f128,0xf951f7ce,0xfb41fa2e,0x003ffd3a,0x08b6045b,0x0e710c67,0x0ec30eec,
0x0fcb0eff,0x10e3109e,0x0fcb1096,0x0c080e65,0x04bf08b6,0xfe46011e,0xfbb6fc84,0xfa8afb57,
0xf708f925,0xf3f7f51d,0xf4c0f3eb,0xf73ef5e0,0xf971f87a,0xfa8dfa0c,0xfe60fbcd,0x071e0229,
0x00000513,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_29_standard_DRUMS_agogolotone[2304] = {
0x00000000,0xf704fc13,0x1d81f48f,0xfde9e2c8,0x018a156d,0xf90504e4,0xd42f1d97,0x9291465a,
0xbc5761ec,0x4d96f0ce,0x2ef7b114,0x1ee804a2,0x1720dbfb,0x3fc2bbf5,0xbca9f337,0x98706592,
0x24262ab3,0x5761d6b1,0x1c4bcc1b,0xd7d9e691,0x145cf9ac,0xdcddf174,0x97df602d,0xed066620,
0x3607da5a,0x262db2a0,0xdc49e85c,0x13881cad,0x1f24e2e7,0xacf5372b,0xee3c3de5,0x4337cee9,
0x5012952b,0xffb1c853,0xeabb4567,0x0cce0db2,0xb8220567,0xdcf22990,0x280df57b,0x59b7cbb8,
0x11b6cad6,0xa80d3e5b,0xfc8d252a,0xf761e7ed,0x17e9f343,0x3e6ee27f,0x4ad7d575,0x16eaba1e,
0xa08b1e73,0xddc3407c,0x07a801d8,0x21e30944,0x0ab9f1af,0xf4a5fae3,0x0665e3eb,0xb5b61d8b,
0xdcf554f0,0x238d095e,0x3f49d521,0x2eb8af2c,0xe977ec47,0x05e1fda6,0xd9a81720,0xc5d25991,
0xf0c121fe,0x2768dda8,0x39c8af25,0xd853ffad,0xe48b472c,0xe47c1f8c,0xcd321f4e,0xfa9d0e60,
0x3dc1e02a,0x7296a02d,0xffe6d0e8,0xb82343a3,0xcd3c2e52,0xda5814c9,0xffdd0ab4,0x2e8e0050,
0x64e1ca6c,0x04bdb671,0x9f842943,0xba2d4dd4,0xf13a2eed,0x20c0088d,0x24b3efc0,0x4e57c365,
0x32259553,0xbcacfebb,0xbc685835,0xff8f3e6e,0x1e45fb9f,0x0d20d84b,0x20ced5e8,0x34a2bbb1,
0xcf8b0bdc,0xa8c46735,0xdf4c4862,0x1baae77f,0x2bbec2fb,0x2906da5b,0x4c7bd143,0xfdcde42f,
0xa0153ac5,0xc7fd44c6,0x1680fae3,0x35a2d249,0x0da3f6d3,0x0ea20afc,0xf20fe884,0xad2d1798,
0xcfa3473c,0x1b8918d6,0x4aced93d,0x1476ce38,0xf2e7f648,0x0443ee2e,0xe2c60492,0xedf62ecf,
0x0d661bdb,0x277de58b,0x0ad7c304,0xdb8e0010,0xfb3f1db3,0xf93a184c,0xf78e1e04,0xf9befc0a,
0x171ce13d,0x285fca1a,0xeb7c0036,0xf00b3357,0xf84114ef,0x0492f564,0x1393d573,0x0a8deeba,
0x27cff0f6,0xe7a30b1b,0xba6740ee,0xce192465,0x0aaf02cc,0x3c6ed2a8,0x11a1eec9,0x199d03a4,
0xee42ea6e,0xc37f180f,0xe16b22e8,0x1b500f7b,0x6128ca68,0x1247cec0,0xe4b00441,0xdfbbfd86,
0xc33a299d,0xd8f74083,0xfed737af,0x54cdd860,0x25b49a97,0xec86edda,0xf5720e6f,0xe32124bd,
0xe3f430a1,0xdf3b2536,0x40efde58,0x49e1955d,0xf564e7e4,0xed5826be,0xd9e530a6,0xd8e61cfb,
0xd627114a,0x286f04ac,0x5da8b300,0x059ce074,0xd498243a,0xc734227d,0xf6de12ad,0x0160f9b1,
0x22940881,0x60bcc720,0x0b64c072,0xc75007ec,0xbfe0325f,0xf42530f6,0x0f610280,0xfb4d1884,
0x32f0de7c,0x195cb37d,0xe58bfc8c,0xd4143120,0xfdee35df,0x1f0aef8f,0xf70fe46c,0x218ce7fd,
0x1fa0d17e,0xf91f0088,0xd5d02ce2,0xd7813a58,0x13f4ee3c,0x06dedab7,0x0ba8015a,0x13edfae2,
0xf8cb0eb3,0xd9ac0a70,0xd7601cb5,0x2575fa31,0x2c16d165,0x0f33f896,0xf890062a,0xdd930c26,
0xeaea0411,0xe0d91a4d,0x1e31113e,0x3b09dc4e,0x03afe288,0xe017fb69,0xd2611dff,0xfc731a20,
0xfe050c43,0x0e7b1416,0x2a40d8f6,0x12a7c858,0xf090f410,0xd04629c6,0xfd013049,0x08820110,
0xf95df950,0x1c68e3cc,0x1efed644,0x0281f3ba,0xd1d12b06,0xddb33a96,0x11bff182,0x13cbdc00,
0x1d2ae84b,0x25dbe758,0x0ce6f39b,0xcb1d104f,0xbdf138fd,0x0c7d10fd,0x226fe07d,0x198af191,
0x1008f9d7,0xfcfcf0ae,0xe060fb26,0xc1312f5a,0x074d2b28,0x37a7e655,0x14f8de72,0xfd87ec08,
0xfa9ef801,0xfebefb49,0xd9a11bb5,0xf121393b,0x2b40ee8d,0x1901c726,0xfbf2e8c8,0xeca40f3b,
0x08841461,0xec270c17,0xd3cb2834,0x1c2df955,0x28d4c941,0x1006e49e,0xeb2014d5,0xf7d621b5,
0xfddbf203,0xdaa60804,0x0bd60df1,0x281ce488,0x15b9eeb8,0xdd3f0a9c,0xd51c273c,0x0e8efa9a,
0xfae2f1cb,0x0c461084,0x1c6df613,0x0bcaeb1d,0xe957f048,0xcbe723d1,0x11c91620,0x1870ec22,
0x09780345,0x0623efd1,0xfd76f16b,0xfdf3f1a9,0xd51b1ead,0x07492d8b,0x1debe9aa,0x07fbe76c,
0x06bbe488,0xf548014a,0x0c1a0501,0xe19b13ff,0xea9f2d64,0x1739e9db,0x15d1dc18,0x16c3e1ff,
0xefbe0ab3,0x014f1b6c,0xe357026e,0xd7c720db,0x1023fde5,0x1faae95f,0x2746e493,0xea200015,
0xe8c91cb3,0xf494f6b8,0xe33c14d0,0x0e1a0d69,0x1d99f7fd,0x2819e1f5,0xec91e174,0xda731d05,
0x0229087d,0xf6830dc0,0x080a11f9,0x02d4fbd3,0x1ed2e30f,0x0914d1dc,0xdd8c190b,0x01a61e01,
0xfff009a9,0xff99fe30,0xf4b0f2b4,0x1436fb95,0x214adb59,0xea0b0c4d,0xefaf25a7,0xf70e00cc,
0x0b06ef47,0xfd78ef81,0x055c11a2,0x25b0f2b7,0xed87f7bc,0xdda115a7,0xf2de093b,0x168efb0e,
0x1044ecbc,0xf47916c4,0x0b2f01dc,0xf88ae54a,0xe97b0877,0xf42e137f,0x18280cbf,0x18c1eb78,
0xe33cfdf3,0xf3dc0b32,0x0416f504,0xfe0f0475,0xfc0c1462,0x05e50e4d,0x1608e12b,0xf3e5e64d,
0xeff81137,0x0a9608a9,0x0ae90626,0xf54503f7,0xf5fbff8b,0x18b4ea0d,0x0a67e3cc,0xf2af1458,
0xfb991d03,0xfdecfe4a,0xfb0bf188,0xf8effd00,0x178afc6b,0x1f22ed23,0xf01c05b4,0xe1d01536,
0xf8ea01d7,0x0a5ff3f5,0x08dbfb10,0x0e9b0b2a,0x13c6f3e8,0xf2d1e8e9,0xde180f19,0xf37a15b4,
0x14800690,0x13def9a3,0xf959fa87,0x0507f57a,0x068ce64b,0xed2a079b,0xf3232381,0x01bf160e,
0x0d9aefc8,0xfc14e59a,0xfc7c0162,0x12c2f913,0xfdd007d8,0xe7de1a45,0xe8410d9e,0x0db2f8e0,
0x115ae100,0x006c0655,0x10760b4a,0xfa0bf8aa,0xeb820128,0xe73808cd,0x0ac00cde,0x268aeca1,
0xfb80ff16,0xf7aa0808,0xf862f26b,0xfb78fe40,0xf5e606c3,0xfffd2109,0x1f0ef6dc,0xf7b4e363,
0xf188031b,0xfcf1fe4e,0x0d97080e,0x07bb010e,0xe6fc14ba,0x0e40f8da,0x0593dd1d,0xfb21030f,
0x02990dec,0x078511b1,0x0b47ed28,0xe3bcf876,0x06cf0713,0x1528e9cd,0x055408f8,0xf73e0d13,
0xf07809df,0x1235ea23,0xf563ecc6,0x02801781,0x137100a0,0xf8140318,0xedb0fe1a,0xe6d10b12,
0x1a44fd79,0x11dceafa,0xf916161a,0xfed100e7,0xf2f8f84f,0xfa3dfa2a,0xed610e74,0x18ca15a5,
0x1bbae6f5,0xf180f7bd,0xf4d4fc2f,0xf49902d8,0x0b4a069a,0xf56c0dc6,0xfb3d1af7,0x1406e424,
0xfd91e66d,0xfdc8fdfe,0xf73d12b9,0x09731482,0xf5fbfa94,0xec7208bc,0x13f3eea5,0x12cae93b,
0x0bf400c9,0xee421145,0xf36c11ed,0xfba7ef72,0xf2c0025a,0x139e0440,0x1979f77f,0x089ff89c,
0xe542fc74,0xe9421045,0x0a7bfb37,0x053b01ea,0x0a450d3a,0x08f8f8cd,0x053aea2f,0xf262f025,
0xeccf16b5,0x0eda1154,0x0a5efe49,0xf8f4fe87,0xf90cf669,0x09f4f34a,0x093af5ca,0xf4341514,
0xfd9117ca,0x052ff239,0xfcfcec7e,0xfb85fd01,0x0b0408c7,0x10840045,0xf1e40330,0xe9f90b64,
0x0567f755,0x0e37f060,0x027c04c6,0xfcdd1326,0xff550281,0xf61df146,0xf0e102a8,0x0a16086e,
0x188bf9f4,0xffabff86,0xea9706ca,0xf4550253,0x07fcf69d,0x01fb0163,0x05ac1193,0x0e19fb12,
0xf92eef17,0xecd5fd36,0xf4970fbd,0x12740952,0x0dd9f94f,0xf8e3039b,0x0281f28c,0x0352ed7a,
0xfdb400cd,0xf2e71768,0x043e17b1,0x09eaedc8,0xf828efdd,0x060cf8be,0x099ffd14,0x077706fe,
0xecde0cbc,0xec6212cf,0x0d3fee03,0x09bfee02,0x0cf9005e,0x031d05ce,0xfe40063e,0xebeff7a6,
0xe8a90f98,0x12c7026b,0x15e2f35e,0x0c9efdd7,0xf27efc0e,0xf2b903aa,0xfd06f802,0xef2e1281,
0x0d741381,0x1061f5d6,0x05d6eeff,0xf4b0ee71,0xf4a60d5b,0x0ded036a,0xf81809d7,0xfd31110d,
0x02feef33,0x0b02ed5c,0x0409f170,0xf1b71650,0x0b101050,0xf5d8f9f0,0xf4b6023d,0x0435f59a,
0x103bfc26,0x122ff50e,0xea6a0f74,0xf79c0f61,0xfbdaf081,0xfee10075,0x07d30022,0x08b1095c,
0x0e87f730,0xe4a5fa16,0xf1791027,0x0796fbcb,0x0b2e018f,0x0996ffb6,0xf5900655,0x0752f463,
0xf53ef0da,0xf47e14b5,0x0bd70892,0x0c110044,0x041cf120,0xed82fb04,0x05b90373,0x06aef6eb,
0xf8cd11e6,0x01730b1f,0x0154f7a9,0x0c43e927,0xf625f946,0xff3c134f,0x0a7702fa,0xf509058a,
0xf7fbffa3,0x01a6f930,0x160df2f7,0x0470f701,0xf3f51650,0xfbab059c,0xf6a0fa11,0xff4ffdca,
0x03e90124,0x152f004f,0x073df4ba,0xe7d306e5,0xf31f0856,0xff250141,0x0a7e0012,0x06bf028c,
0x068f01d9,0x04c7ecb4,0xefdefb3c,0xf286105d,0x02d40db8,0x0cda0314,0x01b3f731,0xfd09f89f,
0x084df375,0xfee0fad8,0xf50312b4,0xfa1c145c,0x0301fdaf,0x05f0ed6b,0x0015f78d,0x07e60184,
0x08ad001e,0xf1a2099d,0xed7f0cac,0x00b5ff14,0x1006f264,0x0a2cf678,0x007f0915,0x017400ff,
0xf302fa94,0xefb5089a,0x0022084e,0x1351ff17,0x0f5ff423,0xf3e8fe71,0xfa0301fe,0xfdeef9ba,
0xfb430754,0x01a30bcc,0x083104aa,0x0d86ecd1,0xf6c1f186,0xf7f809a6,0x05d302dc,0x01ce07d3,
0xfcf203d0,0xf9630003,0x0e2df292,0x030eef5d,0xf92d0f29,0x029d0aba,0xfbe301ef,0xfdf7f8be,
0xf722fded,0x0cd80256,0x0c94f4ff,0xf42a0c63,0xf81907c5,0xfa42fd31,0x095df7d1,0xff64fba9,
0x06360e08,0x09cdf76a,0xef20ffc2,0xf57805d1,0xfb900396,0x11fb00ea,0x0662f777,0xf74e0ae6,
0x0399f76f,0xf584f9c2,0xfd630843,0xfe0e08cf,0x0eb3071f,0x08deebdf,0xf0ecfe5f,0x018c001f,
0xfd69ffe7,0x03b80bb5,0xfaa304f3,0x010d04e6,0x0f91e743,0xf9f5f691,0x01f6098c,0xfc74080b,
0xfe700b23,0xf8edf94f,0xfa2a02dd,0x1676f273,0x05a6f516,0xffab0acb,0xf26a0628,0xf6b607ff,
0x0251f680,0xfc33041d,0x156700b0,0x0842f438,0xf8f60130,0xee760007,0xf4a00e40,0x0cddfee2,
0x00d701ce,0x0a840443,0x0453ee9d,0xfc8df83e,0xf7aaffaf,0xf3f4149b,0x0da408a8,0xffcef8ae,
0xfecefd06,0x047df252,0x0397fced,0x01e601c1,0xefb9134f,0x008b0ad1,0x02aaefaf,0x01d8f962,
0x077cfb6a,0x0598041e,0x039a00e5,0xea850515,0xf7830a22,0x0a22f692,0x08adfb04,0x07770121,
0xfc0004cc,0xff27fafb,0xf3b4fa9d,0xf81e0d04,0x0df101ea,0x0b69fbdf,0xff38fb76,0xf33bfe9d,
0xffad006c,0x0182fc48,0xfb9b0cde,0x068908f0,0x0532f5a4,0xff59f244,0xf719ff4b,0xffa60ad7,
0x0a7f0286,0xfb24033e,0xf9f901c9,0x046bf594,0x06c8f5bf,0xff8a0190,0xfac81088,0x023304b4,
0xfddef442,0xfc14fc18,0x06bafdc6,0x0a1efecd,0x0094038c,0xeed2082c,0xf7fd0544,0x06ebf6a9,
0x04b4fbed,0x090a0413,0x02340173,0xfa6afcae,0xf1d4fdec,0xf6e80b09,0x0ea900ac,0x0b9efbeb,
0x025bfe81,0xf905f8c3,0xfa59fedc,0xfcb7ff7c,0xf8b00fd2,0x0a5d0abe,0x0673f450,0x0142f324,
0xfce4f699,0xfc0907af,0x0680068b,0xf5010b31,0xfba30788,0x0602f0bc,0x08d4f3dc,0x06cef88e,
0xf9880e9f,0x00760918,0xf32bfb90,0xf8a604af,0x0961f896,0x0efbfc36,0x0c54fa07,0xee030563,
0xf6b3081c,0xfb6cf92a,0xfe4106e5,0x0cbd01e2,0x07cb00d9,0x081cf310,0xeefff73d,0xf51c0ddb,
0x056e0130,0x03000996,0x05080107,0xfaadfa4c,0x089ef494,0xfbaef3dc,0xf7cf13d0,0x06e809a0,
0xfd8b00f0,0x019ef67d,0xf9b5f79b,0x0aa70099,0x0953f857,0xf38d10f4,0xfb5106f0,0xfb69f94c,
0x08e7f65e,0x00f1f9ba,0x05fd0dec,0x07c7faea,0xeeb100ea,0xf80603c8,0xff4ffda9,0x114aff40,
0x067afa32,0xf5680bac,0xff53fae0,0xf4ebfa5f,0xff60068b,0x048c04d0,0x0d03053c,0x04eaf087,
0xef0afee1,0xfe360207,0xffb5fff3,0x06160ad1,0x00a0022c,0xffb5ff40,0x0750ed04,0xf655fabb,
0xffee0d90,0x01a6086f,0x00400639,0xfd2df690,0xfc60fb4d,0x0e8cf617,0x0217fccb,0xfa4010bc,
0xf6d306f9,0xfac3ff60,0x050bf3e1,0x0200fdd1,0x0f440332,0x0381fb81,0xf215047f,0xf1a002e4,
0xfcd403ea,0x0fdcfc3d,0x0699fe2d,0x023c043a,0xfdb8f688,0xf513fc35,0xf86605e5,0xffb10d1c,
0x0ec603d0,0x04bcf486,0xf93af9dd,0xfec4f9a7,0xff46007d,0xffc40a71,0xfa5a0cf5,0x01ab01c4,
0x0636ed8d,0xfea2f626,0x02dd0423,0x03620709,0xfd620623,0xf47700fd,0xfba3ff42,0x0de2f520,
0x086cf902,0xff2f08f3,0xfa7c0626,0xf83bfe1d,0xfa92fb74,0xfe4e044a,0x0f3102fe,0x0a40f8df,
0xf5f20027,0xf403017d,0xfc31009d,0x07370015,0x01d304cb,0x03c10748,0x04bef3a6,0xf718f6bc,
0xf9380488,0xffc20a01,0x0b140567,0x0142fa75,0xf7fdfec3,0x0524f5f1,0x00c9fa15,0xff770961,
0xfb570c35,0x00a30487,0x034cefbb,0xfa8efa99,0x07c501c9,0x04db00e5,0xfd790812,0xf40c0243,
0xf9ed01ff,0x0d8ff3b8,0x034ffb43,0x04be089b,0xfd76015a,0xf6b10115,0xf89dfbd4,0xfb8c0750,
0x12f1ff25,0x07d5f884,0xfbab0286,0xf6eefb57,0xf8be02bf,0x03d9002c,0xfcdf09a6,0x0b360650,
0x044ef0c1,0xf9b5f963,0xfb98fdaf,0xfb3e0b71,0x09a505d6,0xfa9901b1,0xfe7601e2,0x06e5eed7,
0x01a3faa8,0x02360234,0xf72b0ef7,0x01ff070d,0xfa90f517,0xfcee007b,0x0b80f8b2,0x06c1ff49,
0x036a01d3,0xee7c05e4,0xfaab0626,0x04b4f4f8,0x0182027c,0x0a940150,0x00be008e,0xfee6fb50,
0xf12bfc33,0xf9d30ceb,0x0cb1fd90,0x050800a6,0x029aff1e,0xf87afab4,0x0142fcc1,0xfd37fb99,
0xfa10103b,0x09e604e5,0x0101f8ba,0xffbaf76b,0xfa33fb46,0x02f606ac,0x06bffeab,0xf70e0a3d,
0xff39026d,0x01b3f45c,0x05adf8ef,0xff4bfecd,0xfe1b0e3e,0x037d0062,0xf4f7fd40,0xfd40015c,
0x062bfa64,0x0b16fdea,0x01e2febe,0xf30a09a5,0xfe33ffd8,0xfd6ef91b,0x016a036c,0x07a70146,
0x06cf00a1,0xfeb5f83e,0xf03e0190,0xfd08074d,0x067dfe10,0x05a80304,0x0257ffe2,0xfe80fbae,
0x01a8f6b6,0xf783ff95,0xfbfb0e96,0x06d0054c,0x0290fcac,0xff21f818,0xfdc4fb3e,0x05a2fe2d,
0x00f40073,0xf7a60d82,0xfdca04f7,0x0248f755,0x0492f6ae,0x0163fdf3,0x03ef06a3,0x014f007b,
0xf35902b3,0xf968044e,0x0558fbf7,0x0b54faa7,0x047bfe3d,0xfa360589,0xfd62fea5,0xf8a1fc91,
0xfb6606a6,0x06c303ca,0x09f8fe93,0x02e6f7e2,0xf56efdf8,0xfcb60339,0x01e7feab,0xff94073d,
0x023d0500,0x01a3fc0e,0x048df4a7,0xfa36fabf,0xfc920a8e,0x054f0488,0xfdca0244,0xfd89fe9d,
0xfe1efb39,0x0840fa9f,0x0301fb5a,0xf9320c4b,0xff990506,0xfcacfb47,0x00a7fb7d,0x0006fe07,
0x07a00429,0x05a2fbd3,0xf362046d,0xfaf103f7,0x0063fbce,0x07edfdad,0x031cfee2,0xfeb10702,
0x0319f9d8,0xf51ffc7e,0xfbc406b5,0x03c1021b,0x09c8013d,0x02d4f915,0xf5b001f2,0x01fefd9b,
0xfd91fc38,0xff620923,0x01ef0485,0x0354ffe2,0x0512f26a,0xf664fd62,0x017306d4,0x0281013a,
0xfe28075e,0xfd5eff3d,0xfe2cfdd6,0x0b43f4ca,0xfe1ffbcf,0xfe6c0c3d,0xff1002ce,0xfa550189,
0xff27fad1,0xfe83001e,0x0e25fdda,0x030afa68,0xf71908a1,0xf9d700fd,0xfb83009e,0x066afce3,
0x00bc01b5,0x08ca03c7,0x02b2f5bc,0xf4e60049,0xfa8502e9,0xfe2c062b,0x0aaa0194,0x004efd4d,
0xfe8701b2,0x03a3f4c4,0xfb57fddb,0xfe9d065f,0xfcf709e5,0x05d20318,0x0075f4a1,0xfb42fea6,
0x05bafc7e,0x015f00cc,0xffc806bf,0xf7340558,0xfeee01b1,0x06a8f39c,0xff93fe62,0x056c040b,
0x00400238,0xfc7c0104,0xf731fde5,0xfd7804a0,0x0c16fae7,0x03b8fe24,0xfeb60493,0xfa32ff2e,
0xfd6bfe75,0xff17fce5,0xfee1076f,0x0aa6022a,0x025bf955,0xf98dfdc6,0xf98fffe2,0x006903d4,
0x06bbfffd,0xfdfd04d5,0x00c801e0,0x0207f578,0xfdadfb73,0xfd4003a5,0x006d09b8,0x05e7014b,
0xfc74fa63,0xfc27fecc,0x049afad1,0x0391feb0,0xff3805fa,0xf93c0825,0xfff0ff3e,0x0248f58b,
0xff77fea1,0x06240280,0x034701ac,0xfaff0184,0xf563016d,0xfe330278,0x09e5fa1c,0x048dfee1,
0x01160496,0xfcf2fe15,0xfadefd3c,0xfa900024,0xff3d07b1,0x0c24016a,0x03cbf9e1,0xfad7fdc8,
0xfb8efd44,0xfe970121,0x026b0304,0xfd6008bc,0x039a0294,0x0392f33f,0xfd91f9e2,0xff12010c,
0x004607d9,0x032d04b8,0xf8f8ffaa,0xfcff00ab,0x0725f67b,0x044afbf4,0x0244045b,0xf98d07c9,
0xfdd101ce,0xfc9bf8da,0xfde101fe,0x0a89fee1,0x05f1fefe,0xff120012,0xf4540045,0xfbfb03cd,
0x04e6fb56,0x0194042d,0x067703a5,0xff73fb95,0xfe46face,0xf8affd2c,0xfd59099b,0x0a2701dc,
0xffd40017,0xfeb9fef9,0xfca4f9a6,0x01d5fe0f,0x01a9ff2f,0xfba40c6d,0x04a00306,0xfe41f765,
0xff0dfb85,0xffb4fd4a,0x042c0611,0x04f80076,0xf59d0455,0xfe630111,0x020ff709,0x04d1fe28,
0x02da01c4,0xfcc608ea,0x0138fd5e,0xf6e2fb83,0xff020306,0x07a9fd7a,0x06fe01b1,0xfffbfe74,
0xf41f0347,0xffd9ff25,0xff71fb47,0x029b06d7,0x068c01b5,0x0104fe3b,0xff11f7cc,0xf4f5ffcc,
0x016a0712,0x068c002c,0x009c049a,0x0019fd3b,0xfd48fa99,0x03f7f930,0xfc3e0116,0xfece0dd3,
0x032b017f,0xfd23fc5c,0x0008f924,0xffc0fd3c,0x0870012b,0x002c0112,0xf68509a0,0xfd2cffb0,
0xffabfa5a,0x069afb9e,0x03010142,0x0386055e,0xfe4bfbd0,0xf4500111,0xfda50202,0x04f70028,
0x0a0afff0,0x00a1fe32,0xfa69016d,0xfe71fa73,0xfad8ffc8,0x00e20794,0x042704eb,0x04d2fe7b,
0xfef8f6a0,0xf957fe53,0x02690101,0x021602df,0xff5d075e,0xfd6b0177,0xfffefb3d,0x040af627,
0xfec90032,0x02120856,0x012902bc,0xfb73ff99,0xfbc4fcb3,0x012efe7c,0x099ffd5d,0x01ec0090,
0xfa730716,0xfc0effaf,0xfdaefbc7,0x01c4fe3f,0x02e903ab,0x069d02d9,0xfff9fb83,0xf62bffbe,
0xfcb70134,0x03ad0037,0x06ba013d,0x004501bb,0xfd4a0102,0xffd3f8b0,0xfb3dfe14,0xfff306e7,
0x04a0049f,0x043eff77,0xfdc8f969,0xfa2dfe6d,0x039ffee5,0x019900f3,0xfec9086f,0xfe8e0285,
0xfff0fb6a,0x02e1f6b8,0xfde1004a,0x03be06ea,0x017f0179,0xf9fe0278,0xfbf6fde9,0x015ffd97,
0x09dafbb6,0x00d40038,0xfcbd0819,0xfcb3fe5d,0xfa80fe28,0x00cdff9e,0x031302a4,0x0a250085,
0xffe7fa6a,0xf6a501f4,0xfd3bff5d,0xff85017c,0x057a02f7,0x00850278,0x026ffffd,0x00c0f4f0,
0xf96fffb0,0x000f0568,0x00e405b8,0x040602b2,0xfcd1fb24,0xfe3cfe66,0x065bf89f,0xff2e00b1,
0xfff8081c,0xfb870482,0xff92ff46,0x00b5f739,0xff4f012e,0x089f003c,0x00940046,0xfbc1039a,
0xf82cff70,0xffb0016e,0x07c0fab2,0x009c023c,0x039003c1,0xfcd1fc4e,0xfbc7fee0,0xfc96ff54,
0x00560686,0x0a3bff5d,0xfebefda0,0xfce80028,0xfd41fba7,0x000a013d,0x026b0129,0xfde00768,
0x04aeffeb,0xfe62f71c,0xfd5dff07,0x001f008e,0x01eb0571,0x03b800cc,0xf95700a2,0x0085fef3,
0x0331f839,0x00d200ec,0x00c4044b,0xfcfc05f0,0x012afd58,0xfbacfadc,0x008e0207,0x06c4fde0,
0x01e501a2,0xfd0901d3,0xf7f80204,0x0208fec2,0x02e2faf4,0x019e03d4,0x045d016d,0xfe20fe35,
0xfc36fd7b,0xf95501b6,0x02c004ae,0x07dcfdb3,0x00060069,0xfecefeab,0xfd6afc79,0xfffbfece,
0xfdb7030f,0x00200884,0x0523fe68,0xff0df9a7,0xfea2fce9,0xff81ffcd,0x02b70304,0xffa502c5,
0xfa5904f5,0x0184fdc8,0x02fcf87d,0x0234fdf3,0x00c30317,0xff5804f7,0xfdfbff37,0xf9a3ffdd,
0x00cd00fe,0x0711fcad,0x048aff02,0xfe4f013e,0xfa3801fb,0xfebbfedd,0xfe91feed,0x01450465,
0x061c00c8,0x01e1fca9,0xfd3ffc92,0xfa2d00ac,0x007a034c,0x03cb0090,0xff76036a,0x00f1ffc9,
0x0076fa60,0x007bfc1c,0xfdef0172,0xffa2078c,0x033d00e1,0xfd3ffda5,0xfeaefe83,0x018afd0f,
0x03eeffd1,0x0090016d,0xfaa305e2,0x0062ffc2,0xffccfa5f,0x00b5ff98,0x027a013d,0x020902ff,
0x0006fe40,0xf858008f,0xffb401be,0x0487fc6a,0x034800d7,0x00710129,0xfc5001cd,0x0071fcf2,
0xfc22fdef,0x0075055d,0x05d6ffea,0x01a2ff28,0xfe58fd1a,0xf98b0077,0x020d014d,0x01c8feb6,
0xff8605ce,0x0287ff77,0xff81fbc6,0x00b2fb61,0xfba4010c,0x018c0725,0x0323ff62,0xfc91014d,
0x0023fd93,0x0064fc25,0x04e3fe41,0xfe4f012d,0xfc7e089a,0x00eefe52,0xfd12fcce,0x0211fe6f,
0x021cff54,0x054001b2,0xfe70fe07,0xf73f04e4,0x0005ffe6,0x0124fd79,0x051b0080,0x0165fff9,
0x00760189,0xff3cfa54,0xf82d01a2,0x00a704ae,0x033e00c8,0x04890098,0xff16fbf2,0xfc96ffce,
0x029efc43,0xfd0f0123,0x003d0764,0x008b0163,0x013cfdef,0x00bef8c8,0xfd220083,0x048201dc,
0xffca0107,0xfce304df,0xfd1efef4,0x00a2fe07,0x0575fad6,0xff2e015a,0x01b50532,0xfe76fe83,
0xfbe4ffc9,0xfe8afed5,0x017c01a2,0x07cefeee,0xfef7ff1b,0xfbd902f1,0xfe07fdaf,0xff5fff5f,
0x0263008e,0x009903c5,0x03ef0063,0xfe6dfa42,0xfb04003e,0xffce0150,0x02860225,0x03c6010d,
0xfd050045,0xff05ff3e,0x0139fa94,0xfe7700a1,0x00f404ed,0x00f10344,0x016dfdba,0xfd65fb3c,
0xfe5d0070,0x0409ffa3,0x010901d5,0xfdc80432,0xfcc10089,0x016afc72,0x0272fb02,0x00100235,
0x02af040a,0xff05ffca,0xfb6aff77,0xfcedffe7,0x02f7fffd,0x06f4fdef,0xffb400eb,0xfc8a02b7,
0xfda5fdee,0xfe1dfe93,0x006701bc,0x02fe039f,0x0542ff17,0xfe98fad2,0xfa72ffca,0xff070101,
0x01c001a7,0x023d032a,0xfeab01a1,0x00c0fd7f,0x019af8c3,0xfd9cffa2,0x0098055d,0x00ad03fd,
0xff8f0037,0xfd23fcb1,0xffc3fec0,0x05f0fc90,0x012400ab,0xfddb0592,0xfc090147,0xfeb1fe54,
0x0110fc0e,0x012a01be,0x066d017c,0xffe5fe29,0xfad1009a,0xfb7dffcd,0x00550163,0x0616ff1a,
0x0039020a,0x00940162,0xfeb9fab1,0xfcf2feaf,0xff380165,0x00fe05a6,0x056800a6,0xfda1fc4c,
0xfcffff7c,0x009efcaa,0x01470135,0x022402ff,0xfca00453,0x011fff15,0xff98f8b5,0xfeb40042,
0x0321019f,0x013203b3,0x00730000,0xfa06fe85,0xffcc002c,0x0484fb48,0x0159026b,0x00be036e,
0xfc350155,0xffe2fd67,0xfdbdfc1d,0x013403d9,0x0691ffee,0xff780080,0xfcd5ffc0,0xfa45ff77,
0x02200062,0x03eafdd0,0x00310508,0x022a000f,0xfd47fc25,0xfe03fde7,0xfd280109,0x032605f0,
0x055efe98,0xfd06ff53,0xfec6fde5,0xfee0fc74,0x024200df,0xffb90309,0xfe1f06d3,0x0239fcd6,
0xfddafa4f,0x009efebe,0x01ce0099,0x02af0402,0xfe590038,0xf954023d,0x0156fdc2,0x02d4fb63,
0x03bc015c,0x00880222,0xfdde0241,0xfdbafc96,0xfaadfff4,0x02e302b2,0x05c3ff38,0x02690036,
0xfd0afe30,0xfb1fffe7,0x00f1fe66,0xffac013a,0x01ac05db,0x0253ffa2,0xffc9fbed,0xfe27fb4d,
0xfd3e015a,0x036a03ae,0x01770150,0xfd6f0233,0xfe74fda4,0x00d6fbc5,0x030bfd8e,0xff6b0352,
0xffd9058f,0xff3dfe85,0xfcc1fd23,0xffb2fea4,0x0335004a,0x04ce00b1,0xfe540098,0xfac401eb,
0xfee9fdf6,0x011bfd90,0x0265019e,0x01a802e9,0x00ac0022,0xfd84fc30,0xfb6dff77,0x01390212,
0x04780099,0x01bb0102,0xfd70ffe6,0xfd44fe59,0x00c4fd0f,0xffe200a2,0x0120054a,0x027200cc,
0xff33fc9c,0xfd5bfcbc,0xfe500064,0x036f0234,0x01f00104,0xfd4a02cf,0xfeeafe76,0x0063fb4c,
0x01acfe4a,0xffb20304,0x00a30528,0x0015fe7b,0xfbcdfdd6,0xfff5ff23,0x0352fecc,0x043c00a5,
0xfe710135,0xfad90305,0xffbefd89,0xffa5fd6f,0x02730202,0x02f6015a,0x017f0011,0xfd57fc50,
0xf9c40110,0x01a101e7,0x0335ffd8,0x02340229,0xff38ff08,0xfe50fdf3,0x00d4fbba,0xfcdf01ce,
0x01540633,0x02020098,0xff81fe76,0xfec8fb96,0xfef3ff83,0x048effac,0xff4a017d,0xfd530576,
0xfe76fe98,0xffcefd05,0x02aafca0,0xfff401f5,0x038202ed,0xfe5ffe48,0xfaca011f,0xff01fef8,
0x01d7001f,0x05afff15,0xfec200dc,0xfe620204,0xfea7fbcf,0xfd560033,0x014a01b3,0x018a02ed,
0x03eeff86,0xfd32fc00,0xfc8400bc,0x0160fe85,0x00bc0194,0x01de0275,0xfdba015c,0x00bcfe3d,
0xfffafa47,0xfe0901ff,0x02770290,0x00a201e7,0xffebff5a,0xfc3dfdb3,0x00530042,0x03d6fd12,
0xff9c026f,0xff9e034c,0xfda6ff9a,0x007afd56,0xff7cfd21,0x0080034c,0x0436007b,0xfe5efff8,
0xfccb004b,0xfd7eff3c,0x02c0ffc5,0x0373fe1a,0xff02033a,0x001b00a1,0xfdd1fd1d,0xfe4fff8f,
0xff620134,0x032002ee,0x03cbfe13,0xfcf3feae,0xfdd2ffdd,0xffa3feae,0x0132012a,0x005a024c,
0xff9902c7,0x01f5fc8d,0xfec8fb99,0xfebf00ef,0x00e9022a,0x0169026e,0xfee5fffd,0xfcfcffe6,
0x01e1fddc,0x02affc84,0x006701b5,0xfef3036f,0xfe800107,0xfefefdbe,0xfe5eff11,0x0243012b,
0x0476ff1a,0xffd2ffc5,0xfc2f00ea,0xfd580067,0x0118ff37,0x018cffd2,0x00fe02a8,0x01d8ff99,
0xff5afc81,0xfcf6ff40,0xfe7001fe,0x0239025f,0x027afffa,0xfe65ffbe,0xff3dff11,0x010cfcac,
0x0017ffc0,0xff890345,0xff930348,0x00f3fe9d,0xfeabfc88,0xff190029,0x02a8fff4,0x018700d1,
0xfebb0165,0xfc8d00ec,0x0075ff0c,0x01f2fc83,0x00330177,0x016d0244,0xff94ffde,0xfea2fe97,
0xfd1aff29,0x00d401de,0x0457fedb,0xffb5008b,0xfe6d0116,0xfde0fedc,0x0090feea,0x0069ff42,
0x002f03be,0x0308ffcc,0xfe8ffd6b,0xfdb4ff92,0xfe760019,0x022a01e0,0x027aff63,0xfda901c4,
0x0070ff47,0xff9dfc2c,0xffe10012,0xff8801f9,0x006703d2,0x0213fdf7,0xfce9fdd6,0xffeefff8,
0x01aefe5f,0x017f0179,0xfefe014f,0xfc8702a4,0x01befda9,0xffe2fc49,0x00fe018e,0x01c400bf,
0xfffd013a,0xfe52fe81,0xfb2e00f1,0x023e00ad,0x032bfda6,0x0111017d,0xff780000,0xfdaaffca,
0x0022fdc4,0xfd6500c5,0x01d703f7,0x0353febd,0xffa3febf,0xfe70fdc4,0xfd9a004b,0x02780071,
0xffab00d8,0xfef50421,0x00e2fe32,0xffd3fcb8,0x00bcfdb3,0xfec401e6,0x02310321,0xffc4ff1a,
0xfc8800e4,0x0007fe8e,0x0198fe62,0x0348ff49,0xfe9d01b6,0xfe8302ee,0xff8bfd48,0xfe01ff11,
0x010700a1,0x02190121,0x02d1ffe6,0xfd8dfe65,0xfc4d014c,0x00e0fef0,0x0125ffcf,0x01a401b6,
0xff8f0132,0x0027fed2,0xff0dfc56,0xfda20143,0x01dc0234,0x021b00c4,0x0006ffb6,0xfd53fec0,
0xff6dff7c,0x0200fe22,0xffe701b3,0x000b034f,0xffebff8d,0xffcafd0f,0xfed7fe09,0x000201dc,
0x02f6012f,0xffd8004e,0xfd3a009a,0xfee1fef2,0x01b5fe02,0x01c4ff29,0xff8a02e4,0xffa801e2,
0xff25fde7,0xfe0ffe94,0x00000085,0x031700b5,0x0257ffb2,0xfdb2ffff,0xfcd0009e,0x0017feda,
0x0107ff4b,0x010d01fa,0x010e015e,0x0046fe2c,0xfe62fd31,0xfd6b00bc,0x01410214,0x026f00a6,
0xffa8007b,0xfe92ff1a,0xffc0fe0e,0x0138fdfd,0xff680199,0xffe00414,0x0071ffca,0xfeeafdbc,
0xff50fe37,0x00ab001f,0x031c008e,0xff850086,0xfcac021c,0xff20ff11,0x0084fe05,0x01eaff64,
0x00a601b7,0x00f00148,0xfef8fd93,0xfc7f0000,0xffe600a8,0x02310086,0x02c00047,0xfeacff9e,
0xfe28003b,0x0039fd67,0xff1f001a,0x00f602a4,0x00a5019b,0x00dbff14,0xfea4fcc5,0xfe1e006e,
0x0222001f,0x00e40108,0xffbf01d8,0xfe0bffac,0xfffefec7,0x0133fd02,0xff93019f,0x01a70272,
0xffa7ffd6,0xfec9ff2a,0xfe4ffe74,0x009800c4,0x036fff60,0xff550123,0xfec4017c,0xfe89fe84,
0x001efee1,0x00d2ff3b,0x006402bb,0x021d0064,0xfe54fe59,0xfde3fff5,0xff78ff84,0x01f100f0,
0x0247ffde,0xfe460130,0xffa2ffb9,0xff29fd70,0xffb1005e,0x00be016f,0x00ef0225,0x014dfe8c,
0xfd9cfe3c,0xff4b0014,0x0115ff6e,0x0108019a,0xffe70132,0xfe5900b0,0x00d2fddc,0xffc5fd98,
0x005b0194,0x0133016d,0xffc800e7,0xfed2ff0c,0xfdd0ff99,0x01bbffb1,0x023dfef3,0x00100193,
0xff0200d2,0xfe6fff94,0xffebfe89,0xff9c0031,0x01c401f4,0x01faff76,0xfefcff2c,0xfe11ff58,
0xfef20032,0x01b8005e,0x00bf00b1,0xffa70194,0x0023fec6,0xff7cfdd7,0xffa7ff8e,0xffeb01d7,
0x014b01b8,0x0022ff62,0xfe54ff64,0xffddff06,0x0133ff32,0x011f0086,0xff4c01b1,0xff0b00f4,
0xffc0fe59,0xff95fecb,0x00ac0095,0x018600e2,0x00840011,0xfe52ffa8,0xfe4d0001,0x00b6ff88,
0x016fffcf,0x006e0116,0xffc700aa,0xff72fee8,0xff37feb9,0xff8f0083,0x01180163,0x017b0027,
0xff49ff7b,0xfe91ff99,0xffd4ff64,0x00efffe5,0x008400ec,0xffac016a,0x001aff73,0xff75fe26,
0xff75ffd6,0x008500f4,0x010e00f9,0x002cffdd,0xfe63ffba,0xffd9ff76,0x00effef3,0x0084009d,
0xfffb0154,0xff6000a1,0xffecfebf,0xff42fef8,0x006b00ba,0x0180003e,0x002e005e,0xfeeefff8,
0xfe7bfffe,0x00c7ff8b,0x00e5ff76,0x00510141,0x005d0044,0xff4bff51,0xff63ff21,0xff2d006c,
0x011f012b,0x0150ffb1,0xff69001a,0xff68ff68,0xff8fff66,0x00adffee,0xffd900cd,0x000201ae,
0x007bff27,0xff5efed7,0x0002ff88,0x00240069,0x010c00ce,0xffaf0006,0xfea500ab,0x0045ff25,
0x0063ff2a,0x00db002d,0xffeb00c2,0xffea00bb,0xff8dfeef,0xfed60014,0x00ab003d,0x00f60002,
0x00c80031,0xff28ffc3,0xff1a0040,0x0062ff31,0xffd40040,0x00990101,0x003e0025,0x0012ff85,
0xff6efeeb,0xff560092,0x00fa004c,0x0049003d,0xffdb007b,0xff6dff90,0x0014ff92,0x007cff42,
0xffb400d9,0x007800e9,0xffddffab,0xffa1ff95,0xffb2ff8a,0x004f0062,0x010bffef,0xff8f005a,
0xff7c006e,0xffc4ff68,0x0038ffaa,0x0054ffec,0x000800d8,0x00710016,0xff69ff6e,0xff70000b,
0x001ffff5,0x00b2002d,0x0080fffa,0xff56004b,0xffcdfff0,0xffefff5f,0xfffd002d,0x0049007a,
0x00500059,0x0029ff81,0xff4eff9e,0xffc4003b,0x00690005,0x00500049,0xffea0041,0xffb7fff9,
0x0037ff64,0xfff6ff97,0xfff0008e,0x003d0086,0x00060000,0xffb5ffaf,0xffb7ffe2,0x006cffe7,
0x007bffe4,0xffd20063,0xff9e0059,0xffe2ffc9,0x000dff9a,0x0011000c,0x00560055,0x0051fff9,
0xffacffca,0xff700015,0x00020016,0x006dfff3,0x0040001b,0xffe60028,0xfff6ffd8,0xfff3ff94,
0xffbf0015,0x0016007a,0x004b0029,0x0015ffd8,0xffbfffc4,0xffe2fff9,0x004effe4,0x00080022,
0xffe50070,0xffec0005,0x000affb5,0x0007ffb0,0xfff9002e,0x004f0039,0xfffffffa,0xffb70011,
0xffd3fff3,0x001ffff4,0x0058ffe2,0xffef002e,0xffff0034,0xffeeffc9,0xffddffeb,0x00020006,
0x001f0036,0x0050fffe,0xffd4ffe7,0xffcd0015,0x0002ffe1,0x00170002,0x00230014,0xffeb002e,
0x0019fff5,0xffebffbb,0xffe10014,0x00190016,0x001b001f,0x0019fff9,0xffcdfffa,0x00020002,
0x001affd7,0x0002001e,0x000a0023,0xfff50010,0x0010ffe2,0xffebffe0,0x0002001c,0x00240002,
0xffff0010,0xfff50006,0xffe60001,0x0016fff6,0x0010ffec,0x0001001f,0x000a0008,0xfff5fffe,
0xfffbfff9,0xfff60002,0x0014000f,0x0015fff9,0xfffa0006,0xfffd0002,0xfffbffff,0x00060002,
0x00020005,0x0003000d,0x0007fffd,0xfffffffe,0x00020002,0x00020002,0x00020002,0x00020002,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_30_standard_DRUMS_cabasastrk[1408] = {
0x00000000,0xfff1ffcd,0xfd0e01a7,0xff31022b,0xffd40051,0xfff5000b,0x004c0000,0x0306fea5,
0x0340fc1d,0x00fffe02,0x0157ff08,0xfd91ffb9,0xfd6b03fb,0xfd5c00dc,0xfa030612,0xff9002a2,
0xfca3012a,0xfd6b0468,0x0375fef8,0x03f4fbf2,0x00f8fd48,0x0512fe8a,0x09c4f6f2,0x0062fa2e,
0x029700e9,0xfe5efc50,0xf72f07cb,0xfd8b0573,0xfa230328,0xfedb0588,0x0000fe36,0xfa9c0397,
0x04c802d8,0x0c50f3e0,0xff60f9cd,0xfd5203e0,0x00560059,0x01fdff36,0xfc97fef5,0xf8a207d5,
0x07bc0042,0x0879f508,0xfc1dfe63,0x02aa01b1,0xfa01ffeb,0xf94b0897,0x023d0154,0xfc3e0047,
0x09430054,0x089af120,0xf72703a6,0xffb4042b,0xf86b0335,0xf4330a69,0xfeac08a8,0x061bfb3c,
0x0205fc19,0x0798fcaa,0x081ef507,0xfdf1ff58,0x0d3bfb6e,0x0476f2b2,0xf95c049d,0x057a00a8,
0xf3daff14,0xf1e21328,0x00830472,0xf96d022c,0xff1a0623,0x0b65f9be,0x0949f3b3,0x023afb18,
0xf5cd0222,0xf9880e0b,0x0698fb24,0xfb030083,0x04920221,0x03a5f888,0x01e8004f,0x07c6fa07,
0x02cef8c8,0x01720137,0x002efba9,0xf8580613,0xf7b907bf,0x025f0472,0xfa7afd48,0xf0f00e7a,
0x087204e5,0x04d1f3f2,0x039700b9,0x10bff327,0x03fcf498,0x01c1ff17,0xf786fe66,0xe0f5199f,
0xf6a314a2,0xf9310619,0x04aa046d,0x1793edfd,0xfaa8f485,0x10fb040c,0x2523db3d,0xfc19edd5,
0x0261090b,0xf576f96d,0xd08023b2,0xf14224df,0xfbe600fb,0xe3a51143,0x05d5164a,0x325bda92,
0x2137d406,0x1982e34d,0xff1ef0ed,0xf6cb0ac9,0xe2ab0a1f,0xb6033acd,0xf3c8377d,0x1516ebd9,
0x0d75f650,0x3bf0db7b,0x234cc33f,0xf103fc81,0xe5801352,0xc1ca2e45,0xee143459,0x145cf1db,
0xff0af80a,0x1c96fa06,0x27dad003,0xf747f5b0,0x111a025a,0x13f3e260,0xdf390928,0x070f19d6,
0x0c1ce40b,0xc1cf1ad5,0xd69e46dd,0x1db8fab0,0x07a5e94f,0x0825ff3c,0x34a6e05e,0x1799d03c,
0x0755f761,0xe90a0159,0xcab02b5d,0xdd133246,0xfcdf1137,0x124df65a,0xfc23f2af,0xe698123e,
0xfa7b1861,0x1cfeeaf3,0x07fff057,0x2235eb8c,0x09d7e3cc,0x0555ffc4,0x0d31efdb,0xe54609e0,
0x11390e41,0x2ae1d564,0xf5e8ed5c,0xeebf1787,0xf9cc0511,0xd74c18c5,0xfaf41f24,0xea14fef7,
0xe415297d,0x3116f256,0xfc26d595,0xdb982ba6,0x2c08f538,0xcd30f01f,0xd58251fa,0x47e2e234,
0xfda0ced2,0x2c3509d0,0x6a58965b,0xd5e7dbae,0xdcec4438,0x14abf40a,0xd1a30d84,0x0bad2159,
0x0864deb9,0xc4cc263e,0x13311cf0,0xfde8df05,0xc0e036ff,0x5877fd57,0x41028796,0x9a1426ce,
0x11f6422c,0x2a2ac31d,0xf468fa8a,0x01520667,0xda840987,0xd8b936f8,0xef7d0d73,0xcd602856,
0xe8db2915,0x2755fa15,0x3c2bc901,0x503eb605,0x24abc319,0x2f54dc01,0xf27ddd8d,0xa46c447f,
0xec3f4246,0x05cff944,0xe94008ab,0x0a1a11b0,0x16e2df0f,0xf83c0111,0xe7420a83,0xe4c82139,
0xf7ef11bb,0x1477fa40,0x3107dd13,0x1b95cf0d,0xf29800c9,0x0e7a01c4,0x1011ecc3,0x0437f694,
0x00ecfa03,0xdb32162e,0xee16190b,0xb8732949,0xceaf4b43,0x250104b4,0x1c26cff8,0x06e3f843,
0x03a6f380,0xee0c0cf0,0x18c503b9,0x3685cef4,0x264cd15f,0x261cdb47,0x0d25e2c5,0x04f9fbf5,
0x0cdcf33c,0xdab2080a,0xca243704,0xe3e3290b,0xd8401a38,0xc52e375f,0xdf623012,0x01421337,
0x3945e138,0x32e7bd61,0x06c1e944,0x1c11f2b8,0x14dce04f,0x023af7cc,0xfb2e00a3,0xf72b0926,
0xf0ce0604,0xba4c2c2b,0xec213a9d,0x08c7f970,0x12a2f72b,0x27f0e1bf,0x1e95d540,0x0e61ee9d,
0xfacdf92e,0xf24c0a61,0xe9b413d4,0xfee00ed7,0x0751f883,0x0e1af8c3,0x012bf007,0x08fd0957,
0x3049d953,0x108bdbb6,0xe89f05bd,0xe4941cde,0xe4bb1c61,0xed691453,0xdc041a29,0xd4a12cc0,
0xe70a1fe5,0xef8d1794,0x24fdfaa6,0x3743c374,0x0a19e6fe,0x2765e42d,0xe590f1e2,0xec872aac,
0x38f2e81a,0x14d7c758,0xe4b4126b,0xf4b91178,0xfe2b0611,0x076d0084,0x054ceecd,0xf7d41073,
0x2987e686,0xfbf6e6e7,0xe1c51a36,0x1a6d0825,0x01b2ddfb,0xccd922b8,0xc29e3ad8,0xf0d02f5e,
0x20e7eece,0x20f5de46,0x2e59d901,0x2df1cf19,0xeb17e88d,0xadc23f98,0xda7545c3,0x15c90277,
0xfabbef01,0x0ec308a4,0x26f6d8a6,0xfea9ef34,0x044a040e,0x125ff016,0xf188fb5c,0xf5c814ea,
0x1695f931,0x1b76df11,0xe046fcc6,0xbd693ded,0xf5cb2b03,0x131bf2e8,0x0d03f348,0x3260dfe1,
0x1782d03d,0xdb850d3d,0x0b2418df,0x2df1d4ef,0xe546f10d,0xd383320a,0xf54f16f9,0xfd5109b0,
0x027df8f1,0xcbbb1634,0xd3053fce,0x1ed404f7,0x32b6d074,0x357ccc4c,0x15efd35b,0xf949fdb0,
0xf03d0bb7,0xeb4d11ed,0xe4e11b0c,0x0da007c2,0x09f2efd6,0x0a86f85b,0x08eef30b,0xfe3cfeb8,
0x1ae6f63c,0xede9ed1a,0xc98c33c7,0xfa4f1f2b,0xf4f5fcff,0xddb32038,0xf8481139,0xf2560d8d,
0x1b01fed1,0x57f9c0bb,0x11fbb954,0xe871184e,0x008900a3,0xc05f1ebe,0xdf9c3ee4,0xf8db0735,
0xf3b3116f,0x227cf48f,0x1c0ed906,0x0f07ee8e,0x023df1f7,0xf9e70c6e,0x2cabeb85,0x158bd423,
0x0e09f945,0x343bdc34,0xf6fbdb05,0xc5e7333a,0xf8792132,0xf42000d1,0xe8351b69,0x0c66fffe,
0xd3280894,0xedbc35b1,0x32c4e2bb,0x0137dccc,0xef38134e,0xf78106de,0xdd0d1869,0xeab91e49,
0x028c0bba,0x1801eebb,0x266ae3df,0x17cbd655,0xf0590331,0x2211ffd3,0x2b86c94a,0xf0baf5e3,
0x081b09c3,0xe1bbfd9a,0xc19f3e1d,0x015f1d9e,0xea23fd43,0xcf15307c,0x174610b2,0x2fe4d1e3,
0x30acd444,0x2c82c8f9,0xefe0f0eb,0xe9031d38,0xedcd0d29,0xdec02152,0x1b50093a,0x2ed5cbb5,
0x0015e983,0xe3d90dd1,0xcd002dd0,0xe44229bc,0x02d80a07,0x073afbdc,0x1fd2ebad,0x137fe28d,
0x02a9f4e4,0x0b6e0078,0x1e19e244,0xe2c7fc77,0xcfcd2fbf,0xebc22390,0x006e0aa5,0x39bce44f,
0x0f48c773,0xce62207f,0xffcd2176,0x2afce14c,0x2700d5f0,0x190bdb12,0xdb2a06e7,0xe4ec295c,
0xfdcd0a3b,0xebeb066a,0xe22b1ff2,0xf2bc1457,0x0a530306,0x0cd7f03c,0x0157f844,0xf453067b,
0x0db404b9,0x0f85e861,0x02f3fc00,0x04dcf8ef,0xf2fd032a,0xf17a1351,0x13b8fe2b,0x1628e584,
0x1b8aead4,0x0c0ee47c,0xebff07e9,0xf86b1382,0xf9fefcd1,0xdcc71d0f,0x0a9e0c95,0xeae3fa5d,
0xd4942cac,0x263407f7,0x191ccb95,0xf85c0634,0x269eefa3,0xe6bbe5a9,0xb05a4a6c,0xf5ae2e22,
0x0656fc49,0x35beea8e,0x4319b1aa,0xe57beb6a,0xfbd22308,0x0eb9e919,0xedf10a96,0x15c30000,
0x0294ea41,0x01ba0928,0x0c43edc2,0xee740b0b,0x1a4efc4b,0x132ae2f1,0xfab0f787,0xd39a1a57,
0xe19e2db2,0x155a0472,0x0813e47f,0xe1cf1151,0xe1f01f72,0xe3521ebe,0x08450f6b,0x20dee3a5,
0x0c46e764,0x1331f873,0x247bdd21,0x104be5f9,0x1263f29e,0x0690e85d,0xcb111f85,0xf105279f,
0xe8ed07a5,0xd6e72997,0x11bc10c7,0x219fda0d,0x16b7ea8f,0x1ba4df7a,0xe6fffbe6,0xd08e2ec5,
0x0a721673,0x018bebc7,0xf8510e45,0x271ff24c,0x28daca37,0xe6d9f9c3,0xd9012842,0xfc221746,
0xfad1fcca,0xf0680ff3,0x03a9068c,0x14c7f3d3,0x1d99e32c,0x07c2ec08,0x04cefe09,0x0337f809,
0xf3280551,0xe08b1609,0xd851258e,0xefea2216,0x13c5f841,0xf944f65b,0x0ee9049d,0x1cd0e1b6,
0xff6cf1f2,0x04dc02df,0x1137f340,0x1700ecac,0x13e0e567,0xf567fc25,0xf15110b4,0xdfa110e4,
0xe0f22c52,0x0bf602b4,0xec3dfec7,0xfb2a1878,0x057bf236,0xf1500f65,0x235cf5ce,0x1f65d453,
0xed90fbff,0xfe8e10d3,0xf2ccfea2,0xebb5191e,0x1cb30010,0x1dbcd327,0x01bcfb3c,0x0b82f4a8,
0x09e1f731,0xf8bffa77,0xdf2f1606,0xd42328e5,0xf548205e,0x0df5f986,0x1120ef98,0x0ffef06c,
0x2283e6ca,0x11a9e19e,0xff9af874,0xeba80a3d,0xeed51761,0x020f06fb,0xf8c3fb4d,0xcf411fc8,
0xf8bc26e6,0x248ee953,0x1107dea5,0xfc82ff4e,0x012a000f,0x0cf6fd74,0x1febe424,0xf571ef8d,
0xd8a6209d,0xec751f2d,0xe5b0129f,0x095713f8,0x1e0adcf3,0xf90ff9f9,0x16ecfd84,0x1759dd34,
0xf24c029b,0x1cd3fbfe,0xff0ce33c,0xd7c22076,0xf5ce19d5,0xee6709d9,0x08120dbb,0x194ae2f1,
0xeb0cfff4,0xf5a31647,0xf9c502ad,0xf80e0b67,0x130ffb43,0x15f4e65a,0x028bf480,0x01b8ff9d,
0x09cffb52,0x0139f5cf,0xef550ae0,0xfae70e62,0x1308f743,0x0c37ec19,0xf5d8013a,0x00d406c6,
0xf227ffb2,0xdc882063,0xfb1d1498,0x04a7fdfd,0x1a08f419,0x2500da45,0x0652e7ef,0xf8900612,
0xf5f50515,0xf0de111b,0xf5110a1b,0xfa150b64,0x0191ffbe,0x00ebffc8,0xfea4fe8f,0xf7c10472,
0xf5e50d44,0x14f9fa95,0x0e54e83a,0xfe96fdbe,0x0cdefa23,0xf6b1f9b3,0xf63810b4,0x0193000d,
0xf032062d,0xf97f1066,0x0819fca3,0x1354f346,0x0f1fe9f5,0xf795ff2f,0x05da0423,0xfb32f941,
0xf4400fac,0x0eb8fcad,0xfd58f423,0xf90d0c8e,0x0a2efaa1,0xf28bfe97,0xf4881308,0xffbb01bc,
0xf89a05e6,0x09b5ff62,0x043bf55d,0xfe1001d5,0x046dfdb7,0xfcbeff51,0x0b0bfeee,0x078df0e5,
0xf20805c7,0xfc110bde,0xfb76ffd8,0xfcc20991,0x0ecdf625,0x0101f74c,0x026600fe,0x0c41f792,
0xfbe6f849,0xf2710d27,0xf5520a5d,0xf1690dc7,0xfad70b40,0x058dfe7b,0x0805f9a3,0x0fc3f348,
0x0467f3f8,0x0450ff19,0x0a5df638,0xfb68fc11,0xfb0e083d,0xfb9300f9,0xf0b50cba,0xfd65090b,
0xf4b603cd,0xf0a21124,0x020d06c1,0x0651fa75,0x14d3f4c5,0x1a11e412,0x064aef71,0x038efe4e,
0x019efad2,0xf92a0402,0xfa1e066f,0xf5e007a2,0xf5e30aef,0xf9760890,0xfdf80457,0x039bff55,
0x0709fa0f,0x08c2f82b,0x0410f85b,0xfdb2ffff,0x0165015a,0xfcc7feae,0xf7160870,0xfe630506,
0xfe4d0118,0x00080152,0x0080ff60,0x01edff62,0x066afb68,0x0168fb0c,0x0205002d,0x0226fbcd,
0xf696038e,0xf89b0b73,0x018b00e9,0xfde500a6,0x05e7ff36,0x0520f7da,0xfad200ff,0x011703cd,
0x0281fbd9,0xfb7801e5,0x01cf02d1,0x0675fa16,0x0226fbc4,0xfebdffc3,0x023a0056,0x0159fcfb,
0xfb8c0117,0xf7db080e,0xfe7e046f,0xfbce0224,0x005003a5,0x08f3fa85,0x0476f7ab,0x0220fe71,
0x03a1fc0f,0xfc40ff4e,0xf8af0761,0xff3b03db,0xfd5d00c5,0xffd202dd,0x0381fd12,0x00c8fe0e,
0x00ceff01,0xfe8100a1,0x00f0007f,0xfe4fff70,0xfd540360,0x00e00064,0xfe300031,0x03db00a7,
0x0754f81d,0xfe20fd80,0x00f501ef,0x0112fd5d,0xfb3d0270,0xfe020419,0xfdf800f1,0xfb030430,
0xff27036e,0x0205fec9,0x038efd9a,0x046dfb5a,0x02a5fc90,0x00f1fdef,0xfded00ab,0xfc8d0306,
0xfd6a0335,0xff3c01c4,0xffd70016,0x009e0040,0x01edfe2c,0x00e7fed1,0x0356fe16,0x019ffca8,
0xfed30053,0xff7c0101,0xff5d005b,0xff2c00e1,0xfeea00d1,0xfd5101be,0xfd43034a,0x0008014d,
0x0165ff19,0x010cfea7,0x0115fefd,0x006dff27,0xfff0ffeb,0xff580056,0x01110041,0x0268fd98,
0xff27ff34,0xff90013a,0x00bbff64,0xfe8c0078,0x012e00ab,0x00ecfdfe,0xfe9600d7,0x00a50081,
0xfeefff64,0xfd0802f7,0x00c500ff,0xff55ff60,0xff950152,0x036ffe3d,0x0059fd4c,0x00b700c2,
0x00e1fdc6,0xfb930277,0xffb60335,0x01b6fe41,0xfe79001b,0x020d007f,0x01d4fcae,0xfdd200f3,
0x010600fd,0x00b4fe2b,0xfd830157,0x004c01b5,0x0163fe52,0x0029ff97,0x00acff6c,0xff7fffe6,
0xff9e00bb,0x006bffb7,0xff060039,0xffaf0101,0xffa5ffee,0xfee80116,0x00720042,0x00d1ff60,
0x0163fece,0x0070fef0,0x000dfff8,0xffbfffe5,0xfe6a010c,0x0000012b,0x00b6ff23,0xffeefff3,
0x0081ffaa,0x0016ffbf,0xff970000,0xffd300b9,0x01bcff12,0x00b2fe5d,0xfff30019,0xffe6ffe5,
0xfedc009a,0xfd8301b2,0xfcb70354,0xffc90205,0x0099ff24,0x00780003,0x03d2fde4,0x023cfbff,
0xff69ffec,0x00f6ffd8,0xff6dff5b,0xfebe0185,0xff7a008e,0xff4200dd,0x0039003e,0x0097ff80,
0xffc3ffa1,0xfecb0109,0x00dd0064,0x00bafe9b,0xff4e0051,0x009a001c,0xfdeffffe,0xfc9903d7,
0x014d00fb,0x016dfe10,0x025ffeac,0x03dffc50,0x010bfd5e,0x0025ffcd,0xfee20012,0xfdca0225,
0xff23016d,0xfe220145,0xffd1017c,0x00c7ff1e,0xfe32004a,0xfe5c029d,0x00caffdb,0xfed00007,
0xff3b018c,0x01f9ff4f,0x018cfdb7,0x0123ff27,0x02cffdd1,0x005afdee,0xff2300e7,0x00c0ffe0,
0xfe660002,0xfdfb0277,0xfff300e7,0xffc5ffe4,0x001e0071,0x0174fedb,0xff64ff69,0xff19012e,
0x00070034,0xfe6600bb,0x00950120,0x01cbfe05,0xffa8ff7a,0x0062002e,0x002cff70,0xffb90047,
0x00e7ffc8,0x01b1fe74,0xffe5ff0a,0xff1c00c3,0xfe8700d9,0xfd970277,0x004c00fe,0xffb6ffa1,
0x0081005e,0x0198fe7f,0xffccff4a,0x00810038,0x00b9feed,0xfe980061,0xff490187,0x0061ffb9,
0xffe00037,0x0261fee5,0x01bffd5c,0xfffbff76,0x001cffe0,0xfd5c00fa,0xfd49034a,0xff4f01b0,
0x0097ffe7,0x00a2ff53,0x00bcff45,0x008bff66,0x00ebff4f,0x012bfed2,0xffdeff6c,0xffe70056,
0xff470025,0xfee1012a,0xff8500d4,0x000c0022,0x001ffff8,0x00feff71,0x0051ff25,0x001e0002,
0x00fbff75,0x007cfef3,0xff29005f,0xffe100a5,0xffa2fff4,0xff6000d1,0xff9f0025,0xfd4a018c,
0xfeda02ac,0x0000ffc5,0xff710102,0x045efe16,0x02ccfb5f,0xffa6ff5d,0xff84005f,0xfda80147,
0xfe1a02b4,0xff9c00ce,0xff850090,0x00ddffdb,0x00cafefe,0x01c6fefd,0x0231fda1,0x0032febd,
0xffb9005e,0xff6b002a,0xfeef011b,0xffc00099,0xff3d0050,0xff23012d,0x0061000f,0xffaaffe1,
0xfff8006d,0x0042ffbc,0x0012ffe1,0x00a1ffc9,0x00f1ff02,0x0047ff78,0x00a7ff92,0x0000ff83,
0xff14009c,0xffb900b2,0xffad0037,0x0022002e,0xffa7ffe4,0xfe910112,0xffe900ff,0x003eff9e,
0x0055fff3,0x00dbff4a,0x00bfff31,0x006cff60,0xffadfff1,0xffc30076,0xff81001b,0xfec00123,
0x0089007f,0x0049ff2c,0x00050038,0x00d7ff54,0xff4effc5,0xff770118,0x00cdff9a,0xfff3ff8e,
0x0034001c,0x009aff70,0xffe5ffbc,0xfff6002f,0xfffeffee,0xffa3003e,0xfff90039,0x0003fff5,
0xffb70012,0xffb90069,0x0015000d,0x0031ffcc,0xffd8fff9,0x00380012,0x0070ff89,0x0029ffc2,
0x008fff99,0xffe5ffaf,0xffbc0056,0xff980029,0xff2700c4,0xffb70097,0xfffb0015,0x0025fffd,
0x0067ffa5,0x002fffb4,0x0036ffcd,0xffa6fff4,0xff6600a1,0x0027003d,0x0059ff9f,0x001affc7,
0x0007fff1,0x0001fff9,0x00010000,0x0002fff5,0xffc00017,0xffe00047,0x005bffd9,0x0008ffb4,
0xfff8001a,0x006effbc,0x0008ffb7,0xfff3000c,0xffe2000b,0xfff1002c,0x0017ffd4,0xff4f0061,
0x00120062,0xfff8ffcc,0xffe00042,0x0090ffac,0xffe2ffaa,0xffe4004f,0x0049ffd1,0xffd1ffe1,
0xff93006d,0x003b0020,0x002cff9f,0xffcf0023,0x0076ffe4,0x003eff7d,0xffc70017,0xfffd0019,
0xffb40027,0xfff80041,0x005bffc2,0xfff9ffd6,0x0067fff0,0x0024ff83,0xff38006e,0xff9e00b1,
0xffc3002d,0xff930073,0x00530017,0x0073ff75,0x0039ffbb,0x0064ffb6,0x006cff8d,0xfff6ffc7,
0xff930055,0xffc90054,0xfff60028,0x0050ffd4,0x0002ffc9,0xff5d004f,0xffb600ab,0x001cfff3,
0xffe50008,0x0062fff6,0x0051ff72,0xffe7000d,0x0078ffd1,0xffddffb1,0xffbf006c,0x0037ffe5,
0xff850016,0xffb70095,0x003effe2,0xffcffff9,0x00400022,0x00ccff58,0x0003ff78,0xffd1004f,
0x0036ffe4,0xff5d0015,0xff0b010e,0x00120070,0xffd1ffde,0xffdb0067,0x00c8ff97,0x0017ff6d,
0x00100027,0x00d4ff70,0x0000ff73,0xfff30047,0x0034ffb7,0xff84003e,0x0027003e,0xfff0ffc7,
0xffc70058,0x0031ffe9,0xff940006,0xff7a00ad,0x0029001b,0xffeeffee,0x001f000d,0x006bffb0,
0x0047ff9f,0x001fffd3,0x0002fff1,0xfff30007,0xffea000d,0x00030012,0xfffdfff3,0xffcc0020,
0xffd70040,0x0005fffe,0xff70004b,0x004e0054,0x007bff4a,0xffe10000,0x009affc2,0xffd6ff8b,
0xff5f00b2,0x003e001e,0xffe9ffcd,0xffd6004c,0x005affd4,0xfff6ffcf,0x0017000d,0x001fffc7,
0xffb70025,0x00080025,0xffeefff5,0xfff1001c,0xffff0005,0x0006fffe,0x000dfff8,0x0008ffef,
0xffe6000b,0x00250007,0x0012ffc3,0xff880041,0xfffd0056,0x0033ffcc,0x0007ffea,0x0047ffdb,
0x000fffc2,0xfff80012,0x0020ffe5,0xffeefffa,0x001a0002,0xffd6ffee,0xff8d006e,0x0000002d,
0xffaa0027,0x0003003b,0xffd3ffef,0xffe7004c,0x008bffb7,0x004eff80,0x0054ffc3,0x0042ff9f,
0xffecfff3,0xffc70020,0xff89005a,0xffb50076,0x00010019,0xffcf0007,0xffe90045,0x005effcc,
0x001effc0,0x0029ffe2,0xfff6ffe0,0xffe4002f,0x0051ffdd,0x0019ffbe,0x001afff6,0x0040ffce,
0xffceffe4,0xffaf0067,0xffe00025,0xff88004c,0x0012005a,0x00a8ff71,0xffd8ffbc,0x0028002e,
0x0036ff9e,0xff900034,0x00030045,0xffefffee,0xffcc0036,0x002a000a,0xfffeffcd,0xffde0038,
0x002fffec,0xfff5ffe6,0x00000016,0x0020ffe6,0x0000fff6,0x0008fffb,0xfff3fffe,0xffcf0020,
0xffe10039,0x0020ffff,0x000dffdc,0xffff0002,0x004bffe1,0xfff3ffc4,0xffad005d,0x0064fff8,
0xfffdffa6,0xffbb0056,0x0066ffea,0x000dffa8,0xffdd002c,0x0040ffe5,0xff690000,0xff5100f6,
0x0053000a,0xffd1ffd8,0x0025003d,0x0089ff72,0xffd7ffde,0x002c001c,0x0046ffa2,0xffdbfffd,
0x0003001c,0xfff9fff8,0xffee0019,0xfffb0003,0x00060003,0x0011ffec,0xfff80000,0xfffd0008,
0xfff30003,0xffd60028,0x000a000d,0x0007fff3,0xfff80000,0x00170000,0x0003ffe9,0xfffb0008,
0x0012fffe,0x0003ffec,0x00000007,0x0005fff6,0xffca0014,0xffee0039,0x0017ffe6,0xffd70014,
0x00390000,0x002cffb4,0x0006fff8,0x0028ffe5,0xffcafff0,0xffcf005e,0x003dffe1,0xffe0ffec,
0x00000025,0x0000ffe6,0xffb40033,0x000d002a,0x0012ffdb,0xffff0008,0x0040ffd6,0xffecffdd,
0xfffb0029,0x0049ffc7,0xffd4ffea,0xfff40038,0x001bffe0,0xffaf001b,0xffee0046,0xfff1fffd,
0xffdb002c,0x00240001,0x0041ffba,0x0000ffe4,0x0027fff8,0x0008ffd4,0xffd10025,0x001f0008,
0xfffdffe9,0x001e0006,0x0014ffcf,0xffd2001a,0x00030017,0xfff8fff4,0xffbf0032,0x000f0020,
0x0008ffdb,0xffe90019,0x0000fff6,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_31_standard_DRUMS_maracas[1664] = {
0x00000000,0xff4201c6,0x008fff61,0xff28fffb,0x052bfed4,0x03ebf9d7,0xffa6feae,0xfe9e00c7,
0xf66f04c0,0xf8c20ab8,0x07310090,0x0736f546,0xfbe1ffd7,0x053f015b,0x052ef7a5,0xfae900b4,
0xfb6e062f,0xfb6c02cc,0xf0470a81,0xf7910f28,0x01c4014b,0x010bfdd6,0x07f4fde8,0x1327f0f5,
0x0645efb3,0xf9a2035b,0x0207036e,0x0b14f844,0x0847f52e,0x04a2fa10,0xfceafd5e,0xf2200ab2,
0xf7e20b89,0xf9a8064a,0x002a051c,0x08f6f994,0x0525f801,0xffbbfe22,0x001300e9,0x078dfc4a,
0x01f9f908,0xf6120434,0xee140ebd,0xf0d4113f,0xf45b0f34,0x1462fe32,0x1c7fdf3b,0xf6e0f721,
0x07af093d,0x1fbde53f,0xfecaed58,0xf2230d69,0xf0420aea,0xdc2f1c20,0xf7531c4d,0x187ef535,
0x0b01e644,0xf92c0348,0x05de00e9,0xfaa5fd5e,0x07650538,0x203ae76f,0xf95dec0e,0xdb671b23,
0xd8ef2824,0xee67218f,0x22f9f63d,0x1e49d4d6,0x0d16f1d1,0x203de819,0x0443e72e,0xd5e21429,
0xdfec2d9d,0xe5911731,0xf2691ce9,0x1adcf31c,0x0305eac0,0xf86d0bc8,0x2a88ef73,0x15d1d312,
0xfbaa00e4,0x0ff9f9d4,0x0461f014,0xeb560a1d,0xd6ac1f35,0xd5b22d5a,0xfd491b7b,0x1ddeeadb,
0xfcddefcc,0x057f087d,0x2572e1fb,0xeceaf191,0xf3f120fc,0x2401e7ce,0xee51f396,0xe9481c39,
0xefb70f94,0xe3ce1940,0x12130b0d,0x1d03dc03,0x0e9af3b2,0x3037db80,0x0baddd0d,0x00310124,
0xe6bd05bb,0xda2f260d,0xfafb1892,0xf3dcfeb2,0xdbcf1fa2,0x039e136a,0xeaa1fc57,0xdd1024c2,
0xfbc51863,0x0f64f367,0xf420f9fb,0xe0d11cd4,0x0fd40c0c,0xff2fe894,0xc3e02333,0xd36d441b,
0x5497f1ce,0x66248df8,0xfed1d3d5,0x1e1e0453,0x5e9eb6ef,0x3c3ea8e0,0x059ce40d,0xef2a048d,
0xca55223d,0xa5994c8c,0xcfac4f44,0x09520e4f,0x0217eebf,0xcc401fab,0x10b52016,0x5292bed9,
0xfdabcbbb,0xf4e92116,0x6903cd32,0x232a9aac,0xcbe1274f,0x31fafc4a,0xe1e4e34f,0xcf74426d,
0x39e0f665,0xdb03d6ed,0xc3a55bc0,0x4c49eca5,0x66ca9fd5,0x43e79f71,0x00b1e229,0xd3a9155a,
0xd6743748,0xe46b19a7,0xd986238f,0xdc892621,0x0b8913a4,0x100be37e,0xb8e711ea,0x8df87205,
0xfa8149ae,0xedd6f51c,0xee332543,0x53b9e1b1,0x5fef90bf,0xfceacbe9,0x9a0b3cef,0xb3026e8f,
0x1dc40e8c,0x261ad9ea,0x44b4cce9,0x3c34b83e,0xfe95dca8,0xd6011e43,0xd18f30d3,0x3b350a3b,
0x72058df8,0xe743cd26,0xdcfd3910,0xf57e00f1,0xaaa9389e,0xe91a44d4,0x08d5f333,0xdb611579,
0x01381460,0xe33a04c4,0xfd1623a3,0x61e0c661,0x31a2a851,0x2497e737,0x4fcebb2e,0xf10fd2fa,
0xb9ed3b25,0xe4a63703,0xf9fc06a3,0xee1410fe,0x058104cd,0xf544ff02,0xfac50e74,0x09b8f9bd,
0x08fffa1d,0x24d9e787,0x1494dda6,0x0635f73f,0xf87ffbf3,0xd5591a8f,0xd4ae2f9d,0xdfec252f,
0xfb6915b0,0x0852f78c,0xf85fffcf,0x00230839,0x006afa26,0xfd9706c6,0x0c7af6db,0x0567f8d5,
0x07dbf79a,0xeff50172,0xf35917a4,0x222af238,0x0481e2e3,0xfcca0b56,0x072ff56c,0xe2990b78,
0xf7d01e8c,0x1391ecd6,0xe0c30975,0x14691099,0x249bd34e,0xe7a3fcce,0x16c80e7d,0x17e6d4e9,
0xe7e608be,0xeffe16d9,0xef560b2f,0xe0121cf2,0x05991189,0x2496e507,0xf416e89e,0xe68c2713,
0x24e2f0e0,0xf6deea58,0xfc3017b5,0x436dd8a0,0x0513cc7f,0xe2251f36,0x14d300cc,0xed47f461,
0xdf9f2736,0x02b109c7,0xf1e204e0,0x078707bd,0x1634eca3,0x0f71edac,0x1a69ecb6,0x13d9e3d4,
0xea2efec7,0xee641fc8,0x156bf811,0xe76df7e7,0xe12a2d2b,0x125dfcb0,0xe02e016c,0xefe326b3,
0x1289f3f5,0xf3c8fd3a,0x1022067c,0x0a1de42f,0xe8a21200,0x1aba0038,0x0e7cdfaa,0xf87f053d,
0x0dacfb75,0xfb89f672,0xf5e10ebe,0x0e23fb58,0x002ef5b2,0x015d0332,0x0d37f7ff,0x05a9f329,
0xfbad0168,0xfa1c05c7,0x05040185,0xf406fcdc,0xec691952,0x0c26ffb3,0xed3afcb0,0xe1ee22b4,
0x090108ed,0xfa8df82b,0x03ec09af,0x2025e7af,0x000febf8,0x00fe0901,0x16a9edc0,0xf404f842,
0xfd22104d,0x0b0ef3ab,0xe462083f,0xeaf11df3,0xeb7a1137,0xf08a1577,0x068004f4,0x147df02e,
0x11c3ebad,0x1280ef4b,0x0ab3ed9a,0xf67d018d,0xfecd07f0,0xffdefda3,0x017e029a,0x0d26f58b,
0xf519fc30,0xe8c614f9,0xfbcd11e6,0x0ed6f4f5,0xf9d7fa8d,0xfd4908f7,0x0645fb46,0xfc4ffef1,
0x056a01bf,0x0940f4ec,0x00cbfcb3,0x08c0fb57,0xfc28fad2,0xfd52079f,0x01c5fda3,0xfe4100a6,
0x017b00f2,0xffd0fd44,0xff7f0308,0x03f8fc2e,0xfa480066,0xf9b60773,0xffaa0535,0x0f73f5f7,
0xfffaf6e9,0x06620175,0x15f2ee1d,0xff79f309,0xfb880702,0x0697fdb7,0x0054fadd,0xf967040e,
0xfbf60657,0xfe7f0216,0x003700ed,0xf7f5010c,0xf0461030,0x074e0508,0x07abf304,0xf05305cb,
0xfd7c0ca8,0xfdcbfd8d,0xed5c0c93,0xfdf90cd4,0xfb12fedc,0xfd9808ac,0x0eedf7f8,0x078bf17e,
0x00b8fee9,0x0126fca2,0xf457060c,0xfaf00b54,0x051bfde7,0x0322fb41,0x0245fe34,0xfe74fd8a,
0xfcfc05e1,0x0391fcc7,0xfb56011b,0xfd9d0464,0x015f00e8,0x0bd4f95a,0x0509f4da,0xfd8e012c,
0x0b94fce8,0x10a5eee4,0x01f2f4d7,0xf3a207bc,0xfc9909d2,0x0003feaa,0xf5fb057d,0xf6c10b12,
0xfa400707,0x02ac0306,0x02adf928,0xf1f30847,0x095e065b,0x156deb0f,0x04d1f25a,0x0385fe8d,
0xfc79fc7b,0xf4450bb7,0x00ca03e9,0xef0b04fd,0xec5a182e,0x0761059d,0xff70f6c1,0xf7fc0a6a,
0x1103fa75,0xffe6f17e,0xf5980c95,0x1418facc,0x075ceb00,0xf5850785,0x039502d0,0xfe34fcc7,
0xf7bf0700,0xff660535,0x047afd42,0x0ab8f8b9,0x0431f5ce,0xfdf801ec,0x036efd73,0xf73f024b,
0xfc0008e5,0xfd7900bb,0xf4c80796,0x024207c3,0x0904f59f,0xf8ffff7e,0xffec0767,0x0a05f7af,
0xfbe3fc12,0x007b0580,0x0290fb38,0x02adfff1,0x08c2f88a,0x01e0f9dc,0x00530135,0x0956fa31,
0xfc0ffa5b,0xf77c0afa,0x07e7fe9f,0xfa32fb83,0xf1580ebe,0xfdce06f8,0xf5120586,0xfb570b00,
0x0592fcf7,0xfdc9fda3,0x04c70204,0x049af684,0xf7f80454,0x02c303df,0x0359fa7e,0xfd8b0091,
0x0646ffc4,0x0189f750,0xf29b09b3,0x07c604fb,0x0cc7f183,0x0302f8d1,0x0639fccf,0x028ef944,
0x020d0033,0x03f1fb1c,0xf8df00d8,0xfa550a1a,0x0725fcf1,0xf8a2fe1c,0xf6470bdc,0xf98b0614,
0xf8ef08b2,0x01230217,0x0222fe7f,0x04b6fc3d,0x01b0fb4b,0xfd3b0360,0x0c26fa92,0x020df5ac,
0xf8bb062f,0x0abbff2b,0xff3ff505,0xf21a0d4b,0x0ad501f5,0x002ff3e9,0xefcf0dc8,0x098304c0,
0x0835f161,0xfc1d0104,0x07a6ff30,0x07fef5e7,0x042efa44,0xfff4fd8e,0xfb1d0308,0xfacd0541,
0xfd1e049c,0x01d00041,0x00ecfdb9,0xfe900131,0xfc010148,0xfe060548,0xfe0effd1,0x01f10240,
0x0677fa59,0x0575f9ca,0x03bafbaa,0xfecafd16,0xf1f408c2,0xfaa00c2a,0xfc5f0131,0xf312099b,
0xfbfc0a61,0x0a89fc64,0x0a43f305,0x03aef952,0x0071ff79,0x0b31f9c9,0xfbb7f8ed,0xf87f0b85,
0x059cfe3a,0xf6f9fff4,0xf73a0ccf,0x029a019f,0x003dfdca,0x08dcfde6,0x0b81f23b,0x0517f99a,
0x0cc4f762,0x02b1f41b,0xf04c0a3a,0xfd8a0a00,0xf80c020b,0xf4600ceb,0x018e04ee,0xfea3fda3,
0xff2d03cf,0x09e2f9b6,0xfd70fa8e,0xfcc10688,0x0d72fab6,0x0156f334,0xf2d50b27,0x07df03bb,
0x0636f457,0xf5ea02cd,0xff1409fa,0x078cf787,0xeedc0435,0xf6f013ec,0x0f4ff8a2,0xfeebf6f3,
0x073601ed,0x0e3eefb3,0xf4c7fede,0xf8dd0e14,0x058bfd15,0xf4ae01d5,0xf5b80e50,0xf9290689,
0xf9cd07c0,0x035f022e,0x08dff7e3,0x056af964,0x08a3f8fd,0x01c4f902,0xfa730392,0x02e40288,
0x0205fb65,0x00b2ffad,0x0401fde0,0x0412fac7,0xf87100d7,0xf3340c7d,0x02a30706,0x0b93f4ff,
0xf825fd79,0xfb6409ef,0x0050ff75,0xfb24032a,0xff6403c5,0x08d9fbbd,0x093ef591,0x0a1ef73f,
0xffdff795,0xf65309ad,0x0d44fe7b,0x03c3f17e,0xf24709d7,0x038805b2,0xfc81fbfc,0xf75e09e2,
0x008f0247,0xf4cd0476,0xfb360b51,0x0058ffbe,0x09e0fdab,0x0713f1e3,0xf11f05f9,0x01440cc7,
0x10faef99,0xf157fe7c,0xfabf118d,0x11bbf3fc,0xf6a3f980,0x02850bd1,0x0ee8ef9f,0xfe1cfbc9,
0x027d00d1,0x082cfabc,0x0560f614,0xf1bd066d,0x0718080d,0x1100ecd2,0xed4500cb,0xff501282,
0x0685f252,0xe2100f3d,0xfe63187c,0x13ebecca,0xfbe9f968,0x056403af,0x1022f1a6,0x0312f532,
0x0866ff98,0x0f5fec93,0xe39a06f9,0xf2ea1ddf,0xfda9feef,0xef790e45,0x04e405f2,0xf43ffd01,
0xeb1a18cb,0x0eb801cb,0x0920efa4,0x04ebfba8,0x0c12f75a,0xf952f806,0xeff213be,0x0c94ff9a,
0x0678f1dd,0xf20806b8,0x05a60719,0x00f8f6a9,0xf31609ca,0x096604d3,0x0e75ed85,0x0157fb5c,
0x0a64fa6c,0x032bf5c5,0xea61091f,0xebd01abb,0xff350743,0xf34d060f,0x04ae0893,0x10cdf14d,
0x0a11f11e,0x0179fc6f,0x0d73f956,0x0e82effe,0x0a38f3a8,0xfe94fad8,0xfc860431,0xfe2101a9,
0xf56b05ea,0xf0ef0d2c,0xef5d1069,0xf6ec0f84,0x068afea5,0xff9dfc93,0x102cfb68,0x0c5feaf7,
0xfc1200b9,0x098afb78,0xef9bfff9,0xf03c17ec,0x0c37ff51,0xfba1f678,0xeee1108f,0x079b0608,
0x0835f21a,0xfba0022d,0x0ecffc04,0x1327eb90,0xfd07f5b2,0xf24f0c9e,0x068f0630,0x0d65f025,
0xfea8fc34,0x07f8fde8,0xf83cf9b6,0xea1a15f9,0xfd4a0ba2,0xfc86ffd2,0xf18c0b86,0x12060163,
0x04bfea25,0xed15104f,0x0eec01c7,0x073cee94,0xf3740751,0x0cf4027d,0x0cb7eb74,0xef0c03da,
0xf3701403,0x065100a2,0xf644fe6f,0xfcf80d0b,0x0d50f658,0x0276f7cc,0x0f58fac7,0x02a7ee42,
0xe8a0121f,0x0ba10759,0xfedff35a,0xfbfa09d9,0x060cf9b0,0xeb700774,0xfaad1387,0x0b89f73f,
0xffccfb70,0x1016f9e5,0x0bffeec4,0x088af6cf,0x055af828,0xf0d102ae,0xe7911881,0x00ff0e16,
0x0819f5b5,0xf41501f7,0xfcdf0d0d,0x0f39f5a9,0x015af799,0x1324facd,0x1bd1e10c,0xf41ff6e2,
0xf7991380,0x1b80f317,0xf745ec3b,0xda5822b9,0x04f6126a,0x0450f205,0xe9860d74,0x0daf0b18,
0x1394e451,0xf201feb9,0xf0f01450,0x03910376,0xffb6fd21,0xfe6f01d6,0x0910fd75,0xff38f684,
0xdf9311f4,0xeda8212f,0x0912ff21,0x00e4fb58,0x104ef949,0x0beeecbc,0xf85800cd,0x0d2a00a2,
0x0e06eca2,0xfab5fc99,0x000c0745,0x0774f62d,0xea0a07e7,0xe93a1a39,0xfd940d55,0xf8bd000d,
0xff350b20,0x1b2eee7f,0x0410eba2,0x01f70619,0x2019ea6e,0xfea2ea6b,0xfc4b0d58,0x0ec3f383,
0xe6d50336,0xf1631cec,0x02f7ffd1,0xf42a0460,0xfa0b0bb3,0xfa08030d,0xf91308b8,0x03980236,
0x126df51f,0x0652eda1,0xfb3705c2,0x0d73fa27,0xfcaef5fb,0xeeb10fde,0x01880874,0x009afad2,
0xf0610987,0x06540912,0x0911f04f,0xf56104dd,0x0bb2025a,0x0c5cee65,0x01e9fb92,0x0da3f86a,
0xfac5f6ff,0xeeb31149,0x09370500,0x0121f392,0xe9df0f14,0xfd670fb5,0x045cf943,0xf3d50648,
0x10f002a0,0x09a8e71a,0xe7050e3c,0x08e70dd5,0x0494ec47,0xe3d01516,0x165e06e2,0x0c71e0de,
0xe6090f11,0x139309f2,0x18d3dc55,0xf53ffe4c,0x06100558,0x0150f6e4,0xf8da0747,0x069bffd1,
0x002ef94b,0xf640078d,0x01e604ed,0xfe93fc3d,0xfddc0614,0x0a23f966,0xf9dcfb97,0xf4ef0d20,
0x04f40230,0xfe09fb98,0xf6f307c0,0x07470413,0x1192edcd,0xf2cdfc98,0xfca010f1,0x1349f0e6,
0xf078fc14,0xf5fd1507,0x0a32fb5d,0xf9f5fb6f,0xf56e0d5f,0x10b5fd0c,0x0385ee93,0xf0290c0f,
0x061105f2,0xfbcef8fa,0xf2180f5a,0x073001d9,0xfe3afaaf,0xff83043f,0x06ecfbae,0x071df84a,
0x0593f9e2,0x03ecfb23,0xff9dfd40,0xf79505a3,0x01500508,0x058afa66,0xfea7fdc2,0xff710240,
0x0042fef2,0xfeeb01d9,0xfed4ff3d,0xffe10362,0x0a2af941,0xfdf5f9a5,0xf85d0871,0x02320160,
0xf2d402d3,0xf9bb1046,0x0d16f858,0xffc4f81e,0xff1c0321,0xfed3ff5b,0x010e024e,0x098cf960,
0x00a7f8cf,0xfee70385,0x0608fb7c,0xf70fffd5,0xf86e0d19,0x0c90fbd1,0x0086f5a9,0xfba60633,
0x0614fdbb,0xfe51fc88,0xffd40336,0x0620fbae,0xf91afdea,0xf51f0d5e,0x0362024f,0xfe68fd8b,
0xfcdb0400,0xfe9e0103,0xf74b0556,0xff7b0682,0x02b3fca1,0xfd50007f,0x03f50107,0x072df7c2,
0xfcd2fe29,0xfe5604d4,0x0844fb88,0x02f4f902,0x0321fede,0x05bdfa08,0xf844ffb9,0xfcd50a3c,
0x0c8df864,0xfe4ff85b,0x00c70523,0x099ff736,0xfb7bfd07,0xfb4e06c3,0xfbac03de,0x038d0196,
0x01c5fabc,0xf99d034d,0xfc0905cb,0xfbf2037c,0xf95f0552,0x003a04c4,0x03b1fc21,0xff83fe99,
0x02c0ffa6,0x0322fc27,0x0356fdb9,0x044cface,0xffedfeab,0x01ddff02,0x0076fe79,0xfbb601d1,
0xffd0039b,0xff7dfe72,0xfc450391,0xfdb001c3,0xf76d05f9,0xff170664,0x04a5fc68,0xff8ffd83,
0x022a0099,0x016dfc12,0xf7ab03f1,0xfb2308f5,0x0584fe4d,0x03a5fb4f,0x0bcef956,0x09d4f21b,
0xf6d8ff48,0xf7660d5e,0x06cfff1f,0xff08fada,0xfd8104ea,0x055cfc82,0xf98effa9,0xfa750894,
0x01b4010e,0xffecfe85,0x02baffef,0x05e1f9e5,0xfc5eff4b,0x01d101fd,0xffb2fdf3,0x00310121,
0xff51ff1f,0xff60020f,0x0224fe0d,0xfea2ffd7,0xff630148,0xfe5100b9,0xfe55027b,0x069efdc6,
0x01ccf939,0xf9d703e8,0xfdeb04b6,0xff39004c,0xfc1b02fe,0x000401db,0xfe0600e1,0x00ea00ca,
0xffeaff1c,0x037fff62,0x0666f9c3,0x0164fc02,0x05dcfe2f,0x06ebf68e,0xfb60004e,0x01ed0283,
0xfe90fd28,0xf7730739,0x043b02c8,0xfdf5fbc6,0xfaa606a2,0x0499ffd5,0xfe55fc6e,0xfc620534,
0x039aff50,0xfe8bfd6b,0xfec603f5,0x056cfbcd,0xfbc9ff4a,0xfe60047d,0x01cefef1,0xfdd3ff9f,
0xfb380469,0x0101026d,0xffb2fd68,0xf62d068e,0x02200591,0x04aff99a,0xf913016b,0x00610648,
0x098cf85e,0x0025fa99,0x022e00dd,0x0351fb2d,0xfb5f0164,0x00b80355,0x0393fc4a,0xff64feaf,
0x009e00a8,0x0148fe6b,0x0134fefb,0xff6cff58,0x00b800bb,0x017dfe1d,0xfed1ffb6,0xfc97029b,
0xfcdd0373,0xffb601f5,0xff70ffe2,0x0019009c,0x017cff18,0x031cfdef,0x03fbfbc0,0x006afdfe,
0x02bafedc,0x009afd4d,0xfd2701c8,0xff330255,0x0022ffa1,0xfb7c018d,0xfb69066c,0x02e4002b,
0xffc2fd8a,0xff1301fd,0x0297fe7d,0xfe68ff0e,0x017d014a,0x00e6fd77,0x000b007b,0x01e1fe84,
0xfdd7ffa1,0xff380304,0x04aafd09,0xfea8fd8a,0xfe140318,0x027dff70,0xff6ffde1,0xfbd1036c,
0x0032024e,0xfbf10032,0xfa6706e5,0x019401b0,0x0042fdd7,0x000a0150,0x04ecfcab,0x0105fc9f,
0x01a2ff81,0x0295fd82,0x0541fc6b,0xffa4fb8c,0xf96f05bc,0x043701c7,0xff2dfae8,0xf6ad080d,
0x05ea026d,0x003bf8fe,0xfad4064f,0x0818fdc5,0xfedff99f,0xfb44067f,0x04effebe,0xfd46fd1d,
0xfbcb062f,0x0364ff6d,0xfdb0fe06,0xfab105dc,0x056f0047,0x02e4f909,0xfa9b02fd,0x02b50270,
0x03c7fa54,0xfa0801b6,0x015a04a2,0x05eaf99b,0xfcd3ff10,0x02b60214,0x0408f9d6,0xf7ef02b9,
0xff8406ce,0x0453fb3b,0xfadb00af,0xff8304ae,0x02e2fd33,0xff94fecf,0x014600ab,0x05dbfb81,
0xfd52fcf7,0xf9440713,0x024e0203,0xfd70fe32,0xfa230637,0x04610132,0x02adf9d2,0xfb410286,
0x029b0258,0x071ff924,0xfbe1fdde,0x006c04be,0x045cfb32,0xfc94ff69,0xfd3304d8,0x0094ffea,
0xfda5010f,0xfe50023d,0x01cc006a,0xffa7fd8b,0xfc1303d8,0x02e0008c,0x0268fc12,0xffaaffdb,
0x0142ff42,0x0006ff31,0xff5000ad,0x00baffd1,0xffabffd8,0x013fffc8,0x02d1fd9f,0x00eafdf5,
0xfec1ffff,0xff0a01fe,0x0157ff0d,0xfca200b8,0xffb8034a,0x0131fdd6,0xfdd40169,0x02e40023,
0x00defc04,0xfab603dc,0x029e020e,0x0218fb7f,0xfdcf0154,0x010500af,0x01e6fdfe,0xfe58ff9a,
0xff2a0243,0x0198fee2,0xff3dff62,0xfe7101cd,0x0285ff82,0xff36fdfe,0xfd22030c,0x01df008c,
0x008efdb4,0xff3d0118,0x01f6ff1d,0xffe1fe43,0xfd2b0297,0x02b50026,0x0170fcb8,0xfe7c00e6,
0x02c9ffa9,0xff4ffd35,0xfab604bc,0x0113021e,0xfe8cfeef,0xfe5102f4,0x0110ff82,0xfdb20057,
0xffa6028f,0x03e5fd3c,0xff34fe32,0x025a0062,0x04e8fb3a,0xfe6afddd,0xfebc030d,0x02c3fe5d,
0xfe74fed8,0xfd030320,0xff1c01d0,0xfecc00df,0xffa0010e,0x01e8ff48,0x0297fd33,0xfe8cff29,
0xfeb20275,0x028efed8,0xfe21fed1,0xff46030d,0x05a0fca2,0xff31fc46,0xfdbb039c,0x0228feda,
0xfc8e009a,0x00f00295,0x018cfcdd,0xfbf4022e,0x00e20222,0xff98fe8d,0xff7c0188,0x0073ff31,
0xff1600cb,0x02a3ff3d,0x0099fd54,0xfdfa01d2,0x04e5fecf,0x00b0fb45,0xfd8e02a2,0x018b0029,
0x0041fe7f,0xfeba00e9,0xfee8012c,0x002a00c4,0x00e4feb8,0xfc7c0178,0xff2802fa,0x0054ff5f,
0xfd440146,0xff69027e,0x0013ff39,0xffe900f4,0x043afd9b,0x019dfc54,0xff92ffdd,0x0198fff3,
0x010efdac,0xfc92014d,0xfd6103ff,0x00960095,0xffd6ff70,0xffa100b0,0x0027ffc8,0xff920056,
0x0123ffce,0x01a4fe18,0xff47ffce,0x0359ff2a,0x00d8fc98,0xfdf9015e,0xfe6001ed,0xff1d0127,
0xfee0010c,0x00b20068,0x00c8fee3,0xffd5ff91,0xfe320157,0x0219004c,0x02befc96,0xff15ff4f,
0x008f00c1,0x014afe4c,0xfd0600da,0xfdee0350,0x00c80060,0x0042ff08,0xff7500a5,0x02e8feca,
0x011ffd19,0xfd0e0164,0x019f01c3,0x03d7fbce,0xfe06fec4,0xfd8203b4,0x0154ffd1,0xfdbcffe7,
0xfccb03f4,0x0258003c,0x00d4fd84,0x005d0026,0xff69ff59,0xfdaf0203,0xffbd01a9,0x01fefe93,
0xfec2ff45,0xff6001c7,0xffc8ffc1,0xffd700c5,0x022bfeb6,0xff84fe8e,0xff0501b1,0x00f5ff98,
0xffccff62,0xff5400dc,0x00efffd4,0x00a3fee1,0xff3e003a,0x00f0002a,0x0136fe8d,0x00c1ff10,
0xff54ffb2,0xfe4e0199,0x002700c4,0xff55ffed,0xfff300cc,0x0164ff0e,0x002cfefa,0xfeaf00a6,
0xfeff0179,0x007a0023,0x0071ff63,0x01b2ff4e,0x0236fd71,0xfeabff54,0xfee2023a,0x01d6ff02,
0xfe84ff72,0xfe970263,0x0209ff55,0xff31fe90,0xfd4f02cf,0x014b00b3,0x00e4fdfe,0xfe580105,
0x01620058,0x009ffe3e,0x00150033,0x008cff50,0xff420032,0xffd100a0,0xff61ffff,0xfd9b01b8,
0xfe8f0249,0x018fffe6,0x0151fde7,0xff830005,0x0082ffe2,0xff05ffff,0xfef80178,0x01b2ffb6,
0x011afe11,0x008aff88,0x020dfeb1,0x00b5fe09,0xfdb00128,0x001601a6,0x00a1feb9,0xfc7d01a8,
0xffaf02e9,0x01cbfe03,0xfd65009e,0x014201b2,0x01d5fcf0,0xfdb000c8,0x0063019d,0x020dfe11,
0xff88ff0f,0xfec2012c,0xffcc00d1,0x00d6ffad,0x0162fec1,0x00e0feaf,0x0003ffad,0xffa40001,
0xfe17014d,0xffd1014c,0xff46ffe8,0xff720142,0x014bff3a,0xff02ff91,0xff0e019d,0x004bffdf,
0xff730058,0x0289ff56,0x0206fca0,0xfddc00af,0x01a100ac,0xffc5fe2e,0xfdfc0227,0x0245ffe2,
0xfff0fdc6,0xfe6901f7,0x017affd4,0x0108fe46,0xfdfa0053,0xfea302ab,0x01c9ff35,0x00c1fe95,
0x001fffce,0x01a7ff1a,0x0038fe9f,0xff2100a5,0xff3a00df,0xfff8007a,0x0034ffb6,0xfee0003a,
0xfd780224,0xff9701ea,0x00a2ff08,0xfe870105,0x0289ffbe,0x01c3fcb3,0xfd8900e3,0x00cf0181,
0x0194fdd7,0xfea7000c,0x00050148,0x0185fe8d,0xfe6ffff5,0xff3d01c9,0x0088ffa8,0xfed9003e,
0xff9f012a,0x00d8ff9f,0x011afec4,0xff81ffbd,0x008e005f,0x01d0fe6e,0x00a8feae,0x0131ff7a,
0x0130fe43,0xfe9c0029,0xff640183,0x0054ffbb,0xff050054,0xffe100dc,0xff75ffd6,0xfe84015b,
0xfff400e2,0x00acff75,0xff98ffb6,0xffd40095,0x002affc8,0xff240043,0xff5a011a,0x01a6ff6d,
0xff9dfea9,0xfe070205,0x0142005c,0x0139fe31,0xffacffbf,0x00510025,0xffefffb2,0x00500008,
0x0022ffa2,0x004cffe7,0x00dcff61,0x007aff2b,0xffffffd0,0xfebc00a6,0x00aa0085,0xff0cff94,
0xfecc01c3,0x00af0004,0x001aff5b,0xff73006f,0x00f9fff8,0x00f4fea7,0x002eff95,0x00afffa1,
0x00a0ff29,0xff3cfff9,0xfde0016d,0xfe5f0274,0x007f0018,0xfeb00050,0x00000123,0x00f4fef6,
0xff58ffe0,0xfef30124,0x00cd0018,0x007bff31,0x00b3ff7b,0x0082ff47,0x00c6ff94,0x00e9febe,
0xff230038,0x01760005,0x00f4fdfe,0xfe6500be,0x004100f1,0x00acff1e,0xfee10025,0xfe99019a,
0xffe400c4,0x0066ff9e,0xff780003,0x00150091,0x00e6ff2c,0x0008ff7d,0x00760018,0x011ffeb6,
0xfed10019,0xfff80108,0x0043ff5b,0xfe8300c6,0xffaa0152,0x00f6ff30,0xff75ffe0,0xff0a00b8,
0x003500bc,0x007fff1e,0xffa90038,0x00f0ffbd,0x0047ff05,0xfea500bb,0x007d00df,0x0172fe60,
0xfea2fffb,0x008b011f,0x01b3fe0e,0xff1cffbc,0xff9a00f4,0xff600026,0xff4c0103,0x0088fff8,
0xffefff8f,0xffef0058,0x003bffa2,0xff0d007b,0x007b006c,0x0073ff2f,0xff8f0018,0x00900021,
0x007eff13,0xfebc0068,0xff6b016c,0x015bff26,0xfeffffb1,0xfffc010d,0x007cff3e,0xfede0059,
0x00430102,0x019bfe4a,0xfefaffeb,0x003300b8,0x00fcfefd,0xff75ffda,0x00d6003d,0x00e7fe78,
0xfee8004f,0xfff400df,0x0010ff8b,0xfeab00cc,0x008500c1,0x0053fef8,0xff5e0076,0x001f0048,
0x003dffad,0xff660005,0xff9200e2,0x00beffa3,0xffecff7d,0xfec500cd,0x005000ca,0x0119feb8,
0xff30fffd,0x00900076,0x00b8fed6,0xfee1004c,0xff3f0142,0x00600004,0xfff0ffa9,0xffe20066,
0x012dff3a,0xff57ff8c,0xffb100f4,0x00cfff83,0xffc9ff7b,0xff8d00ad,0x010effad,0x00f2feb8,
0xffadffad,0xffa10085,0xfffd0032,0x00e4ff87,0xffe7ff4d,0xff6f00b8,0x001e0008,0xffb60003,
0xfef100b2,0xffef00cd,0x0014ff9a,0xff2f0091,0x00c7003e,0x012dfe82,0xff53ffdd,0x00370083,
0xffbcff8c,0xfea9012d,0x000c00b0,0x002aff97,0xffb50044,0x008cffdd,0x00bdff33,0xff19ffe4,
0xff42014f,0x0160ff95,0x0093fe7f,0xff4b008b,0x00c7ffe2,0xff99ff60,0xfe970166,0x00820084,
0x0076feff,0xff870060,0x0088ffd9,0x001eff9b,0xff720029,0xffe00084,0x00a6ffac,0x004aff6c,
0xfff3ffdf,0xff6f0055,0x0020005a,0x008cff74,0xffe1ffcc,0x00100023,0x0042ffa4,0xff3b003e,
0xfef60113,0x00540071,0x00c5ff3c,0x001aff6b,0x003a0027,0x00f8ff2f,0x003eff3f,0xff9b003b,
0xffde0038,0xff550047,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_32_standard_DRUMS_sambawhistle[896] = {
0x00000000,0x0883bad3,0xf2193a4c,0xf485378f,0x0d33c48b,0x15a6ca09,0xf63e3feb,0xdf342833,
0x0777c6b3,0x2da0dd8d,0x0182317e,0xc93811d7,0xf3d6da0f,0x3c3500c2,0x0e6e1ffc,0xc626ea95,
0xe4b0ed35,0x394127b1,0x180912b6,0xd494c2db,0xe4e6ef37,0x2d4e48d9,0x06d01343,0xe3edb073,
0x0308e78d,0x24c64c32,0xe2ee1163,0xe288c673,0x2b7be458,0x1e343ae2,0xc5870be5,0xdf4fdc14,
0x4167f617,0x19d6288e,0xc254f3e4,0xdff8e7e9,0x3da116d8,0x15b41bd6,0xd546d2bc,0xea25e488,
0x298c3af3,0x01f01c25,0xeac5bc8f,0x0785dd05,0x1ad54427,0xe0722006,0xebf7c49d,0x2a0cdcb8,
0x1c023c16,0xc4a61242,0xe1dfd82d,0x3ef9f230,0x216527de,0xc01bfb42,0xd6e6e4d2,0x40ba10b0,
0x237c1e97,0xcb13d929,0xd831e942,0x360e307a,0x16e31acc,0xdea5c213,0xe9d8e19e,0x216d4731,
0xffbb204e,0xf0fbb60a,0x0514da97,0x15494ae4,0xe1b72421,0xf4a1bdfe,0x2b7bd382,0x0e754156,
0xc3442200,0xeaa2d5c0,0x4a24db7c,0x1afc252f,0xace41505,0xde77effa,0x547bec96,0x228b14ae,
0xb646fb3f,0xcf66f9bb,0x47610e8e,0x2e3409cb,0xce41d9a3,0xc95ffce2,0x2a662b87,0x2fb40dac,
0xe6cbc322,0xcd37f4a3,0x0de24523,0x28301313,0x059cb331,0xd49dea43,0xf9064d91,0x1eb01c7b,
0x15f0ac60,0xe3a6e23b,0xe8ee5012,0x0d3522c4,0x2814b1eb,0xf0bdd586,0xd9934dc3,0xfcda2f87,
0x3233b980,0x0a6dc6b3,0xcd373fbb,0xe6e83ecd,0x3cacca8f,0x1ec5b4ea,0xcbe42cf6,0xd25d4849,
0x3b2ee288,0x3051ad1f,0xcbac1568,0xc3ba53e0,0x3a47f5ab,0x36c0a5ef,0xd9b502fa,0xbeba50e4,
0x2746091c,0x373ab125,0xebcaeebe,0xc00448b2,0x13bb1a42,0x37bfba4b,0xfc03df24,0xc3cc3ffa,
0x03c32556,0x39f7beb1,0x0612d554,0xc2ef41ec,0xfadd2a88,0x3b45b62c,0x1176da5a,0xc00441f4,
0xea82281b,0x3520c300,0x24d2de3c,0xc70a30ff,0xd45e2483,0x3517d508,0x36bee319,0xcbfe181b,
0xc3541cc1,0x2b37f64e,0x3fbbebe3,0xdc5bfb10,0xbedd0b03,0x1dff1305,0x355c0319,0xefa6dfd1,
0xd28cee7a,0x0ec72bef,0x183f167a,0xfba8d7c6,0xfa21d425,0x0a8d2fae,0xf64e1cbb,0xea94e2ad,
0x1e31de93,0x11e024de,0xe02009fe,0xda86edde,0x29f802ae,0x194d188b,0xe72ce6eb,0xe0dde379,
0x1b872f1e,0x0c5e19f8,0xf5c5c7cd,0x036bd9d3,0x0ac43f59,0xe9621dc9,0xef34cc3f,0x2d8ae41f,
0x13172d65,0xc68c0d94,0xd8abe428,0x4b9f0708,0x207a10ca,0xc07de6c4,0xd8f7ed67,0x46382f40,
0x0f1d10b9,0xcdd4c7b2,0xfda2e2bb,0x3658437f,0xe919126d,0xcdc3c878,0x2b89e71b,0x2b6a3f5c,
0xcba70514,0xca12d2fa,0x41860563,0x28aa2ff8,0xc9f5e53d,0xd18ad300,0x3ba22ead,0x176e2e47,
0xd7f6c2f8,0xf29bc916,0x2bec4afe,0xf4362e1f,0xdddfb868,0x2138cd71,0x209949db,0xcadb239b,
0xd93bc952,0x4356e5a3,0x21bd3b09,0xbdb8f98b,0xd7b7da45,0x46b3120c,0x17542e1a,0xc8a0d648,
0xef34d042,0x3c2d3697,0xf51b2ed4,0xd65cc425,0x1973c9f0,0x30663e3b,0xc9d32d01,0xd387d1a4,
0x454cd0e1,0x30852d0d,0xaa5621e0,0xce07dffe,0x5733e7cd,0x35d6268e,0xac6bf903,0xc48be6a7,
0x4f6c1395,0x354224f7,0xbe10cf9e,0xc719e3f8,0x434838aa,0x23052667,0xd20ab78b,0xe161d787,
0x32304bff,0x04e92ada,0xe394b289,0x0092cbde,0x22035042,0xe8f7319d,0xe9d2b5f9,0x1b7acb11,
0x1dbb489e,0xd12a2d26,0xe9c4c8bf,0x3422ca5b,0x1c323460,0xbba72fd6,0xebcddbba,0x47bcc77a,
0x1e911bb4,0xaeac3370,0xe8fcf008,0x4dfcc4a6,0x189c108d,0xad8637a3,0xf12ff997,0x4d36bf9e,
0x0c9a05ce,0xb0b343ae,0x064ff766,0x3f2cb90c,0xf51b0d60,0xc433493f,0x1b5ff011,0x2f76addc,
0xd93516c1,0xd4dd5b1a,0x3436e266,0x1612aa21,0xc32b1f09,0xf041626f,0x4aecd1e8,0xf677ab20,
0xb5872af7,0x15ee59ee,0x4ac3c6c2,0xd28ebe77,0xc72229ef,0x328543e5,0x3162cc8c,0xc254d2b5,
0xdccf21b1,0x44b12ed7,0x14d9d9e5,0xb1f7e564,0xeeda1d9e,0x576921d0,0x0a23d5c3,0xa807e81f,
0xf6512428,0x5e481fac,0x0103d275,0xa39fe8c8,0xfe9d2773,0x58cb27bc,0xfe74cb05,0xab72df16,
0x02bc304f,0x4a682fa9,0xffb1c5d7,0xbe0cd067,0x0216333d,0x2e9f4312,0x0782c2f8,0xd9f3b8d2,
0xfb103c0e,0x146f4fb3,0x0bbebf44,0xf8bfac79,0x002c37c7,0xef4e5806,0x0585c907,0x1dd1a5f4,
0x02fe3154,0xcf5553cc,0xf5fddc39,0x41e8acf0,0x0c8c236b,0xb4863fef,0xe087f225,0x5275ceeb,
0x1fe410f8,0xb7741317,0xd15cf7be,0x4aca01c6,0x21c80d9e,0xd0c6e4c4,0xde5ee5d8,0x32822dd6,
0x05db1aa8,0xdfd8d059,0x0f19d379,0x1fd0346b,0xd6d528b3,0xdb08dcaf,0x3c35d526,0x2527270f,
0xc0b81354,0xca7be67d,0x46f000d2,0x29ef1d4c,0xcc72e5b7,0xd253dfc8,0x315c2e7f,0x1a452480,
0xe1dfc6bc,0xf756c8eb,0x1eca4476,0xf19f2fb4,0xe143c595,0x2184d042,0x218e3862,0xcf361db1,
0xd206ddea,0x3953eef4,0x2d2f24fc,0xcbb2f2fc,0xcccae44c,0x3496216d,0x21ed1fed,0xde61caa3,
0xebecd885,0x25073b3e,0xf7662785,0xe6bdc5bb,0x1bf0d25d,0x1d113bc6,0xce5c1c80,0xd782daf4,
0x3ac9f276,0x2b5f2294,0xc477f2bb,0xc643ee41,0x39122544,0x34cc1413,0xdb38bd74,0xd111e97e,
0x26e34917,0x15511d4e,0xec40afbb,0xfb1dd88c,0x171f4ce7,0xe4282c60,0xf274bf1a,0x25e4cf85,
0x17543d34,0xc34424a4,0xeaffd598,0x3f59de58,0x1d572940,0xbae30b4a,0xdc42ebca,0x42d4f9c2,
0x24c61b06,0xc52deafb,0xcf49f706,0x36691ed2,0x2c7d0e43,0xd85bcc64,0xccd5fb81,0x23a637aa,
0x27de0bba,0xf1dabaa3,0xd5b5f651,0x0aa54184,0x19f314db,0x0ba1b8ae,0xdbfeed18,0xf20b437f,
0x19271da3,0x1f98b815,0xd9cee5fe,0xe0e84564,0x21101c42,0x29c8bcae,0xd354e58a,0xd1a44402,
0x35ca1962,0x315cb813,0xbef2efbb,0xd0ca4189,0x48890bf9,0x2877c13c,0xab480941,0xe1d92c4f,
0x5c10f136,0x14c1d64d,0xa55e21fb,0xf6410e59,0x614fd7a5,0xfb30fbca,0xb1dd2e6c,0x0beee472,
0x4d39d2a1,0xe26f2bb4,0xd0342e06,0x1538b68f,0x2bc5e0ad,0xde9e56dc,0xea99172f,0x0e0fa57b,
0x14d9ef05,0xe9ea6a72,0x0256ff3e,0x036e99b6,0xff80ffad,0xf87a76a8,0x0f7cea28,0xf336994b,
0xff550de2,0x013d7313,0x0b5de1fb,0xed409c82,0x048c1705,0x04836e3f,0x0790db71,0xee8899c2,
0x0b4f2247,0xfea468e0,0x0020d69a,0xfad19ceb,0x15d124fc,0xef375f9e,0xf503daff,0x0d879f12,
0x204a29e6,0xdb9e4faa,0xdaf1e765,0x2f45b134,0x2f3d19e8,0xc730376a,0xbe62fa28,0x411dd7df,
0x44dc0577,0xc5f00e97,0xaaf3fd58,0x38601042,0x473109cb,0xe33bd5b5,0xb895e72a,0x236b3ef3,
0x274b19dc,0xf43dc002,0xea6ec98d,0x19194e4c,0xeec627de,0xe907c9fc,0x2636cd60,0x1c033db3,
0xcd3214e9,0xce72df92,0x449df4b0,0x2d11250d,0xc2deeb26,0xca01e372,0x3b372f2c,0x21682118,
0xdb71c18b,0xef9dcc8c,0x25cd4b50,0xf1aa2fdd,0xdff5bed6,0x2d95c46d,0x20773f94,0xbf472c7e,
0xd113d4c4,0x5117dec0,0x2bfd300f,0xb582feea,0xc040e074,0x4dda1abe,0x2e66272f,0xcecdc94f,
0xd4a5cc4b,0x348d47aa,0x081e3c9e,0xe4e0b032,0x09fcb3cc,0x25515180,0xd467456e,0xdbf0bfc3,
0x3737bb25,0x30ff40a1,0xb9932ca7,0xc1dfd4a5,0x509ee14c,0x3cd72b29,0xb5c401d2,0xb9c4e58c,
0x4a920985,0x38ed255f,0xc98add31,0xc289dacd,0x332c3460,0x28992d6a,0xe6c9bca0,0xdbb3ca62,
0x18094a13,0x0ed23a7f,0xf795b3fc,0xf9efbebf,0x118e4a0d,0xebf13ced,0xf625c3eb,0x19d6befa,
0x1bce3707,0xcfb53140,0xe035e2ee,0x394ec9f5,0x29431bba,0xbbda224b,0xd5c3fb61,0x40c0d9c4,
0x34e50993,0xc4e70d8d,0xbeeb04d3,0x3783f9a7,0x42e4ff6d,0xd7d4f102,0xaf580a01,0x22f8166f,
0x4c24fc2a,0xebacde8a,0xae3b04f7,0x10af21ae,0x484f0686,0xfc92d5f6,0xb12efce8,0x041e260e,
0x43f70b46,0x072ad7df,0xb6eef454,0xf94e277e,0x400d10cd,0x0efdd818,0xbc05edfd,0xeceb2960,
0x3f831809,0x1a8bd51c,0xbdd7e516,0xe4a2293e,0x3ab521f7,0x246ad69a,0xbf33db9a,0xda3828cc,
0x38582d3a,0x2d06d6a4,0xbfb2d6d2,0xd3b82253,0x3c823466,0x30b2d757,0xb5c1d648,0xcf0b289c,
0x56162825,0x2a28cf51,0xa074ea82,0xdc2b2721,0x69f6143c,0x1962d1b2,0x924cfb7d,0xedcc231a,
0x6c220b9e,0x0d3ed907,0x947af937,0xf7732092,0x68610f41,0x01d7dad8,0xa1faf148,0xf9532337,
0x5a4b19e8,0xfe59d6e8,0xb0d9e795,0x01f42787,0x497d204e,0xf7d0d108,0xc44bdff8,0x06892f6a,
0x2b4828f5,0xff5ecd7b,0xe5bacd1c,0x027330cf,0x05a73a05,0x02f2ce50,0x0e2bbeef,0xfe522ef6,
0xe0723cdf,0xfe30dbf2,0x2c00c5cb,0x04ae2294,0xcbf92a18,0xeb56ef20,0x3b8fe52b,0x1286101a,
0xccf702c2,0xe0fafa5a,0x33ec10f4,0x152703af,0xe25bdc78,0xf22bf336,0x19732f26,0xfdc70b25,
0xf0adcfa7,0x143fee7a,0x094d3077,0xd9420dfb,0xf454df81,0x2eecf858,0x08f71dd6,0xcbe4fabc,
0xf1a9efb4,0x35151656,0x0b3e06a1,0xd7dfdbdc,0xff67f279,0x21e732bb,0xf5dd0388,0xeae7cd30,
0x1a64f2d4,0x0c4b39c2,0xda150462,0xeed3d3e8,0x3589ffc7,0x05fd2a93,0xcd47f375,0xf107dfa8,
0x3a081a94,0x01b81ca2,0xcf16ddd4,0x03aaded2,0x32da2f40,0xeeb515bd,0xcf27d804,0x1da0e6ff,
0x333d2a25,0xd6d50c0b,0xc823e372,0x328bf73d,0x373a1e21,0xcfdef5c8,0xbf4fecda,0x32a4146f,
0x38e516f4,0xd9d8db54,0xc174ee8e,0x24b829bf,0x31ec1b87,0xed05c762,0xc924e6c9,0x0fac3f15,
0x2cdf1b92,0xfd92bc97,0xd0c1e3bf,0xfc874857,0x2d7a1c89,0x0cc8b150,0xd256e67d,0xf1ec4aec,
0x26b91939,0x1457b930,0xd618ed0f,0xf28b3a57,0x22c41092,0x11f0cc8c,0xde4df4b5,0xf76a225e,
0x1e780465,0x06b6ead2,0xeb95f962,0x003701b0,0x0f440483,0xf7830fc7,0xfec6fa28,0x0645dc34,
0xfd920cae,0xf76c2ff8,0x0caeeae2,0xff4ec9c0,0xf10219fb,0x0430429e,0x15dad6e8,0xeec8bfa7,
0xecd12c4d,0x154f4709,0x0f27ca37,0xdc94c577,0xfe2d32c0,0x1fc23cf9,0xfd36ca09,0xd626cd32,
0x125b31a1,0x222533a0,0xeef9cc70,0xd994ccca,0x1df5341c,0x17463392,0xe642cd49,0xe8fccb3e,
0x26ed31a8,0x044332cf,0xdf4bd349,0xfd34c7a1,0x2d2c3419,0xf3d92917,0xd037d77c,0x17b7d5c5,
0x32602be1,0xe0801984,0xc577e064,0x2918ee91,0x36d42181,0xd957009d,0xc346df54,0x298913fb,
0x2e1a2337,0xe45edd3e,0xd6cad459,0x238c30b2,0x10e62677,0xe63ed21d,0xffdbca25,0x22d6389e,
0xe7012551,0xdaeed6f4,0x2ad0da03,0x21b730c7,0xd2140cfa,0xd16edd7b,0x3c88fef8,0x24882669,
0xcb13e871,0xd95ddc7f,0x33922ed7,0x1226246f,0xdaa4c867,0xfe52cfa1,0x248043cf,0xec1e28b1,
0xdd3ec2db,0x2e00d3ed,0x209f3b3d,0xc5e51dbd,0xd58cd0c6,0x4780efc4,0x25123134,0xbd41f603,
0xceabda64,0x45cf2012,0x21322902,0xce15cc53,0xe497cdc6,0x346b424e,0xfe6b35df,0xde5eb884,
0x11f9bfad,0x289f4989,0xd3e83840,0xd8b3c352,0x36c0ca17,0x2f5f3dbe,0xbe07207a,0xc5f0d337,
0x4c43ec79,0x36742b8f,0xb9cefbab,0xc201e244,0x47220ede,0x31402625,0xca7bdb98,0xcadbda80,
0x32eb3416,0x21c32c22,0xe4c7bf69,0xe249cbda,0x1a2546e5,0x09bd384f,0xf46db80a,0xfeccc0d3,
0x142145cd,0xe8933b23,0xf313c7ea,0x1c86c0d3,0x1e833353,0xce2c2fb1,0xdd92e5ce,0x39ebcbb8,
0x2ba61976,0xbbdf20b6,0xd3e8fcc0,0x4054db38,0x360808f0,0xc59e0c8c,0xbea90528,0x36aef989,
0x431dfeaf,0xd7c2f2df,0x000009e1,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_33_standard_DRUMS_guirodown[1408] = {
0x00000000,0xff49ff7c,0xf3fe0601,0xefbf103d,0x15e60310,0x1a91daef,0xe033041a,0x1765185a,
0x366fbdf4,0xb32809f9,0xdfe058aa,0x4ae0d469,0xf243d314,0xcc0e369e,0x17f2128d,0x6165b9df,
0xeb51bf8b,0x94ec5f00,0x399a2cb2,0x5497887e,0xa7f20c71,0xc3eb63c5,0x35ffff4f,0x4721af9e,
0xce9ce938,0xb7945fa3,0x3e57ffc3,0x2184b704,0xda761133,0x0cce1599,0x391dd122,0x0285dd9b,
0xd8a01621,0xfdbc20ac,0x0cb2efb5,0x05c3f769,0x033dff2d,0xfbfafbf4,0xeaec0ba4,0xf2261cc1,
0x15b6f010,0xc7960af5,0xd11d4b7b,0x3ab0f517,0x0be1c384,0xca24299c,0x10ec18aa,0x2c73d537,
0x1c33da5e,0xe37fff8d,0x052d18c0,0x1ce1dfb5,0xca340a5a,0xd669426a,0x1f81fbdf,0xc5ce019e,
0xf54f3bb1,0x2423e114,0xd99bfa21,0xe29738c7,0x3bfdeaca,0x2077c1bb,0xdea404ee,0xff6221f1,
0x1f00dfce,0xefbef86f,0xd7732511,0x0836122b,0xfeb8f19f,0xef171200,0x10ddff85,0x0752ed27,
0xf22307fa,0x06b00665,0x026bf2a4,0xe17d110d,0xda282866,0x25a705a8,0x16e7cdbf,0xce401422,
0x18472337,0x56bfaea6,0xeb95da01,0xec2a2b11,0x2a93e896,0xec77ede7,0xf9531c46,0x0f23f0cb,
0xe00e083f,0x03101c30,0x24aadda9,0xe65ef925,0xff1719e8,0x126ff182,0x180fe789,0x0839f313,
0x09efef59,0xdcc914da,0x26d607f0,0x3e76b996,0xb44afd22,0xd93c6348,0x4b23d08a,0xdac1e4c4,
0xdec83c08,0x24f9f313,0xe8f6ef55,0xedb227ac,0x379de58c,0xde6ce10d,0xb7f84ed2,0x10ac1ea6,
0x151dd861,0xd5f9100c,0xef372aee,0x1a71f186,0xf1bdefb1,0xdcac2df2,0x56c6e55e,0x000cb19b,
0xb73947de,0x388e0cb8,0x31abab59,0xd7ed0e1d,0x339f017c,0xfc95cbd4,0xbed53cd3,0x24880f57,
0x0273d585,0xd19029cc,0x4bb6fc75,0x1ecd9f2d,0xa9d53ca3,0x1c2b2314,0x2611cb64,0xeaf6f81f,
0xe28226c6,0x4667ee84,0x00a7bd18,0xbdd03d4d,0x14c11a23,0x2a20ce4e,0xcc1c0308,0xf3ab3bbb,
0x7071c157,0xfb5ea862,0x93df5d26,0x1f722f4f,0x2779bbad,0xba54178c,0xe9ee481d,0x557aca9d,
0xd23eddb2,0xd7ec4821,0x2032fc1e,0x0384ddbc,0xc1bc28e4,0xfb132dc6,0x1b82e2fd,0xe71004e8,
0x1362077d,0x24ccded0,0x0b69e492,0x165af687,0x1b01e114,0x0825eece,0xefe9019f,0xf4921a05,
0x1f5ee958,0xd76e057b,0xef4e2541,0x111afc99,0xc5fb03e5,0xde4f5145,0x42a9d8f9,0xf3badc9a,
0xeb942195,0x0940fdf8,0x0e5cf67c,0x1a2eed3b,0x24dfda8b,0xee4af215,0xfbde1b82,0x0d70ec03,
0xe3960a71,0xf61b1c86,0xfcf3fb64,0xe19e14c4,0xf3df1b4e,0x0922fa7c,0x1a57f4c0,0x0735e38e,
0xdfea0fb0,0xf9a0234a,0x2f84d906,0xe228f6d9,0x049d1fb5,0x2f19d0d8,0xb9320b39,0xeaf44633,
0x38d3e161,0x050dcfaf,0xab3c35bb,0x0cd53749,0x1887ce30,0xe5c60e4f,0x014d15ac,0x5e27c9e0,
0xef75c287,0xd38f3877,0xf18b1a0c,0x2b23f52e,0x2c5cc9b6,0xdf7ced93,0xb7d65195,0x36ab03b9,
0x0532ca3b,0xc8af2f96,0x2e7d067b,0xfa82d432,0xe1dd2a00,0x436cea32,0x0ba8c49d,0xe78618bc,
0x1843fee8,0xf511ece2,0xe0fc20e2,0xf81311ae,0xf2090831,0x0b190a5c,0x17ffe0da,0xf4b401ff,
0x0774fec3,0x0971fb71,0x0143f258,0xf13f0eef,0x035a0375,0x074efb30,0x00f4f91f,0x0446fee9,
0xeb9805bf,0xf48115e2,0x163cfb37,0xfffee883,0xe4e01a5c,0x292dfa20,0xfc8cdd30,0xeeab19b3,
0x116cff2a,0x16e2e330,0xe8c100fa,0xf4941b76,0x1407f5ba,0x0375f03e,0xe4f30dcc,0x100b1180,
0x22c7d4e5,0xd91103d6,0xf5102901,0x2686e75a,0xf8d4e975,0xe5b51b02,0x0ada096e,0x0d49ea92,
0xe8180809,0xf89f15fd,0x15d3f713,0x0fe3e5a3,0xe8f70673,0x053c11dc,0x1884e713,0xf86bf74a,
0xfe830c96,0x1590f003,0xfa84f502,0xeba91299,0x06200852,0xff9ef733,0xf0d90b5b,0x00aa09a2,
0x08e4f773,0xfbe1fd93,0x02d103be,0x0827f74d,0xfa14fefe,0xfe4406fb,0x0bfaf94b,0xfc4bf8a0,
0xf7810a35,0x07c50132,0x048ff48f,0xeeac08bd,0xf8910ed7,0x02aa026d,0x096af5f4,0xf1f503ea,
0x005509f2,0x0939f908,0x0181f7e8,0xf82b0673,0x071c0103,0x0620f708,0xff5dfcd8,0xf3d00749,
0xff0809c1,0x13abf581,0x021dee63,0xef750e32,0x08480551,0x0eb7f018,0xf78dfa4c,0xed2a147b,
0x0c480332,0x0814f051,0xf1070462,0xfdba0ed9,0x0f5ef396,0xf5effc05,0xf9b80de7,0x0d48fa4a,
0xff32f5b1,0xf8f8090b,0x086bfefc,0x06a4f4e5,0xf920019f,0xfcce0700,0x0764fce9,0x0107fa12,
0xfc3802df,0x02b40171,0x01c1fbdf,0xff2500fb,0x04a1fdbf,0xf7d8ff3e,0xf7c00d1b,0x0691fef4,
0x00dff9ef,0xf9c80547,0x08cdff92,0x062af513,0xfc55ffe0,0xf7dd06c6,0x055e0361,0x04cef685,
0xf59003ea,0xfe7009b5,0x082cf8f2,0xf664ff72,0xf8e00d94,0x0c82fb81,0x04baf3b3,0xf515058d,
0x027506ff,0x08bdf6ed,0xfe7afc0a,0xfb490542,0x0678ff19,0xfef4fad3,0xfc570512,0x008b006e,
0xfdd0006e,0xfd0d0397,0xfd1301e8,0xfd2a03f1,0x012600c5,0x01e3fd7a,0xfe440055,0xffcc017d,
0xfecbffa8,0xfdec031d,0x03f6fe44,0xff66fda6,0x00780173,0x0187fd82,0xfc9a019e,0x00930253,
0x0112fd83,0xfc9e023e,0x00db0155,0xfd73ffe4,0xffe40357,0x0511fbde,0xff1efd9f,0xff120258,
0x04defd6e,0xfee4fd1c,0xfedb02f5,0x02aafe11,0xfdabff6c,0xff39032c,0x041ffd43,0xff84fe0b,
0x0121ffe4,0x00a8ff50,0x02d6fe0e,0xfdadfea4,0xfb820572,0x03840017,0x02c5fb99,0xfdbcfff4,
0xfcb40396,0x01600129,0x00fbfdf3,0xfc660109,0xff9203d2,0x0483fcbd,0x0002fd19,0xfd75026b,
0x05dcfee4,0x00b5f9e4,0xf9ae0520,0x01090362,0x01dcfc5a,0xfaca0275,0xfdbf04a7,0x00550064,
0x0222fed6,0xfd30fedf,0xfb6f05ff,0x03f7ff99,0x00a6fcf2,0x01faff7f,0xfec7fe2b,0xfbbd046c,
0x05b6ffd8,0x0387f8a5,0xf8e802d5,0xff720617,0x0749fa64,0xfc7dfd1e,0xfbb306a6,0x0430ff64,
0x0243fb50,0xfd190107,0xffe0027d,0x0397fd41,0xfd13ff39,0xfdb703ff,0x0218ff7a,0xfdc8ff4e,
0xfd2703b0,0xff3c014c,0xfd7a019d,0xfefe01d0,0xfe14018a,0x002f00d9,0xff6b0017,0x00a7006d,
0x0315fd4c,0xfc47fff9,0xffe0040b,0x069dfb38,0xfdbdfc78,0xfb040625,0x0361001c,0xfec9fdcf,
0xfdf4030f,0x0185ffe5,0xff86fed8,0xfeee0154,0xffc300ec,0x0095ff14,0xfe800130,0x00050066,
0x00ecffcf,0x0117fe4f,0xfdb2011a,0x016200e0,0x00a1fe0a,0xff8f0094,0x0227ff23,0x007cfdf1,
0xfe7b0112,0x000d0118,0x02c2fe16,0xfec9fec6,0xfe150264,0x00b400af,0x0233fe18,0xfed1ff23,
0xfeed01de,0xfffb0077,0x0130ff3d,0xffaaff64,0xfe44015a,0x008600c9,0xff1eff92,0xfce80272,
0x006401cb,0x0162fe63,0xfe30fff9,0xfed602a4,0x032dfe76,0x013dfd12,0xfe5400c4,0x00ad00fa,
0x0354fd7a,0xff16fe03,0xfcf3031e,0x00900165,0x01f6fe26,0xffc9fee4,0xfe880154,0xff7c00ff,
0x00c2ffe0,0xff14ffb4,0xffc90121,0x0039ffaf,0x005bffd6,0xffbbffc0,0xff6d00c9,0x00ddffe1,
0x0235fe3f,0xfe05ff4e,0xfece02f3,0x027dfe9b,0xfeabfebf,0xfe0c02e4,0x0288ff58,0xff70fe2b,
0xff2c01f1,0x01effeb0,0xfedaff6b,0xfe48020f,0x00ca0042,0xff9eff83,0xff2400dd,0x000b0086,
0x002eff9c,0xfe4400a2,0x005b01a1,0x0199fded,0xfe520053,0x006b0151,0x0256fdfb,0xff45fec6,
0xfe5f0225,0x0092001b,0xffbcffc8,0xff5d009d,0xff580078,0xff5b00e5,0x00810017,0x00fbfeed,
0xfee40017,0x00cd00a1,0x01c4fe29,0xffcaff47,0xffe9002f,0xff690094,0x0165ff8e,0xff80fefa,
0xfdad0217,0x016500bb,0x01d4fd8d,0xfeaafff1,0x00120139,0x01a6fea6,0x0064fef0,0xffcc000d,
0x00170016,0xffb90003,0xffd80041,0xffad004a,0x00610003,0x006eff76,0xfeb10029,0xff1e01d0,
0x0143ff58,0xfe98ffb6,0xfe8c024e,0x01beff9a,0x00e2fe1a,0xfec40092,0x00e0005f,0x00a3fee4,
0x00a8ff7f,0x0071ff67,0x0097ff68,0xfeda0028,0xffdc013e,0x012afef2,0xff31ffc3,0xff50013e,
0x012fff9f,0x0010fefd,0xfeb30102,0x01410064,0x017bfdcf,0xfe9e002f,0x00ca0104,0x023ffd95,
0xfe0bffcc,0xff600249,0x01fffe9b,0xff32ff14,0xfdf30207,0x00a700f5,0x0261fde9,0xfea9ff21,
0xfeb80248,0x01d0ff7b,0x013dfdfd,0xfeda0012,0xffe20133,0x00d9fefc,0xfeb0005d,0xff150185,
0x0171ffaa,0xff05ff0a,0xfe050273,0x010e0056,0x00a1fea7,0xff620055,0x000c0045,0xffd8fff4,
0xffa10069,0x0019001f,0x00baff8f,0xffd8ff83,0xff2c00c7,0x0112001c,0x01d5fe13,0xff25ff3b,
0xfeaf01f2,0x018aff99,0x0005fecc,0xfefd00f0,0x008e004a,0x0069ff23,0xff1e007d,0x00d40039,
0x00affecc,0x0000fff4,0x009eff9c,0xffa8ffc3,0xffd70090,0x0138ff63,0x0032fef7,0xfef700b1,
0x0069009c,0x00b4fed6,0xfe74009e,0xffd20157,0x00e2ff0a,0xfe7b0073,0x00460110,0x00c4feeb,
0xff070033,0xff3d0120,0x00c90001,0x0089fef7,0xfef20050,0xff460151,0x01d3ff55,0x0005fe7a,
0xfe960159,0x0133003c,0x015afe23,0xff0fffee,0x002800cd,0x00a6ff2d,0xfff3ffde,0x001f0005,
0x0039ffbf,0xffe4ffec,0xfff60031,0xffc7ffec,0xff7500af,0x00bcffe1,0x004aff31,0xff360075,
0x00320066,0x001cff9c,0xffe9002a,0x00e1ff9c,0x0064ff1e,0xffb1001e,0x002e0025,0xffd3ffca,
0x00030053,0x0061ff8e,0xfebd0055,0xff25018c,0x007dffe9,0xff3dffee,0xff280138,0x00990017,
0x0134fee4,0x0036ff36,0xffb70039,0x00450000,0x002dffb5,0x0036ffe5,0x009aff80,0xff98ffc9,
0xff2d00c2,0xffdb009d,0x0054ffb7,0xff49001c,0xff5f00ff,0x008fffec,0x0007ff8d,0xfffb0028,
0x008affb6,0x0001ff95,0x00240037,0x0167ff1a,0x0033feee,0xff370081,0x000f008b,0x0083ff7d,
0x0022ffb5,0xffba0001,0xfee800ca,0x004f009c,0x008fff2c,0xfedf0050,0xffb00118,0x005fffb2,
0xffe5ffd6,0xffb40054,0x0005000d,0xfff60016,0x009cffac,0x0012ff8e,0x0062fffd,0x0000ff7f,
0xff77009a,0x0140ffb1,0xffd6fedf,0xfe99016a,0x0072006e,0x0066ff45,0xff9a0031,0x005b0014,
0x000dff90,0xffc20051,0x00a2ffd6,0x0098ff23,0xfeed0044,0xff970115,0x00cdffac,0xfffdff62,
0xff4900a1,0x00270054,0x0039ff9c,0xff56004c,0x00420067,0x002fff6e,0xff72005f,0x0042004c,
0x00ecff31,0xffeeff89,0xffe50037,0x00320003,0x00a5ff75,0xffeeffa5,0xffbf0056,0xffd6002d,
0x00340005,0x000fffc2,0xffbc0024,0xffe10049,0x0027ffec,0xffcafff3,0xff62008f,0x00a60025,
0x0080fefd,0xfed2007b,0xffdb0110,0x0117ff21,0xff86ff9e,0xffc300b0,0x009cffaa,0xfff8ff97,
0xffc00069,0x00caff9e,0xffd2ff7f,0xff4500af,0x0000006e,0x0058ffa5,0xffc5fffd,0xfffb002f,
0xffd60000,0xffdb004a,0x007affc7,0x005fff7f,0xffd2ffe7,0xffb40064,0x00b2ffd1,0x00b7ff2d,
0xffc7ff98,0xff3e00d6,0x004f0029,0x0046ff97,0xffa10003,0xff6000a6,0xfff30051,0x000dfff9,
0xfffffff3,0xffd30012,0xffe10039,0x005bffe0,0x0015ffac,0xffde001c,0x0033fffd,0xffe5ffdb,
0xfff40031,0xfff3fff6,0xffb10033,0xfff30045,0xffffffea,0xffa5004b,0x00e6ffe4,0x000dff07,
0xfee400f6,0x0097005d,0x00bbfefe,0xff85fff1,0x00000077,0x002fffad,0xfff90007,0x004cffd2,
0xffb4ffeb,0xffbc0078,0x0099ffce,0x0002ff75,0xff40009e,0x00400042,0xffe5ffbc,0xffd80055,
0x004effd2,0xffb2fff3,0xffc7006d,0x006dffd8,0x0003ffb1,0xffd7002f,0xfffa000a,0x0014000b,
0x002fffcc,0xffeefff4,0xffe10032,0x0036fff0,0x0012ffc8,0xffce0025,0x00310007,0x0012ffba,
0xff3b0078,0x006e005b,0x007dff29,0xfedb0064,0xffc50118,0x0134ff2c,0xff7aff7a,0xff7700f6,
0x008dffd9,0x004fff7f,0xffeeffe4,0xffe1002e,0x0050fff3,0x0017ffa5,0xffbf0032,0x002a001b,
0x0028ffb2,0xffc4001f,0xffbf0047,0x00100015,0x0010ffe9,0xffd2000f,0x00060019,0xffc70003,
0x00000047,0x0083ff98,0xffe2ffc4,0xffd6004c,0x005fffe5,0x0028ff8e,0xff980042,0x0040001c,
0x000dffb2,0xff770056,0x00450042,0x0010ff8d,0xff89006d,0x0058000d,0x0017ff9a,0xffb20039,
0x00460016,0x0085ff76,0xffc8ffce,0xff98007d,0x005f000d,0x0077ff68,0xff88fff5,0xff2c00dd,
0x00610042,0x0059ff66,0xff830020,0x0003006b,0x006dff97,0xffd7ffde,0xffad005b,0x0034000d,
0x0024ffb7,0xffc30014,0xffe90037,0x0017fff4,0xffa1000f,0xfff3006b,0x0083ff9c,0xfffaffb9,
0xffc90033,0x0014001b,0x0036ffbe,0xffe4fffd,0x00010014,0x0003fff8,0x0000fffd,0xffc00028,
0x0050000d,0x001cff92,0xff7b005d,0x00270042,0x0041ff99,0xffaa001b,0x0015003c,0x0050ffaa,
0x0001ffd7,0xfff50014,0x00a6ffb6,0x000dff75,0xffaa0053,0x00420012,0x0003ffac,0xff720067,
0x00170047,0x0028ffc2,0xffceffff,0xff8d0070,0x00170036,0x0034ffbf,0xffeefff9,0xfff80017,
0x000ffff8,0x001cfff3,0x0024ffd6,0xfff3fff5,0x0003000f,0x0007fff1,0xffee0005,0xfffa0012,
0x0003fff9,0xffe20012,0xffdc001f,0x0032000c,0x0032ffa3,0xffcd001b,0x003b0003,0x0041ffa7,
0xffeafff3,0xffcf0031,0x001b0008,0xfff3ffe7,0xffdb002f,0x000c0008,0x0002ffee,0xffd6001f,
0x002a0007,0x0022ffc7,0x0000fffd,0x0024fffe,0x0059ffa2,0xff9e0005,0x0017004e,0x005bff90,
0xffa50001,0xff980083,0x0047000b,0x000affb9,0xffc70022,0xffd2004a,0x00200000,0x0000ffe9,
0xffe00012,0xffd3002e,0x002a000b,0x0017ffc2,0xffaf0032,0x0051000d,0x0039ff8b,0xffb40025,
0x00140028,0x0024ffca,0xffd60007,0xfffe0022,0x0032ffd9,0xffd1fff8,0xfffa003e,0x0081ffaa,
0xffecffba,0xffde003b,0x0027fff5,0x0000ffe4,0xffe70015,0x0000000d,0x0003fff8,0xffe70006,
0xffde0022,0x00070012,0x0005ffe9,0xffe90019,0x003cffeb,0x000affd1,0xffd10019,0x001f001e,
0x0068ff98,0xffb6ffec,0xffd8005f,0x0039ffe1,0xfff3ffe1,0xffba0042,0x001e0014,0x0000ffd9,
0xffcf002e,0x00400000,0x0016ffb2,0xffbe0037,0x003d0005,0x0019ffb4,0xffc2002a,0x0038000b,
0x0025ffac,0xff920038,0x00070044,0x0037ffc7,0xffe9ffee,0xffcf0027,0xfffd0024,0x0022ffe7,
0xfff6fff3,0xfff1001b,0x0029fff3,0x0007ffdb,0xffe9000f,0xfffd0012,0x000dfff8,0xfff3fffd,
0xffd80025,0x0017000f,0x001effcf,0xffd6000b,0x000b001f,0x0032ffc8,0xffd9ffff,0x00000020,
0x001effeb,0xfff5fff0,0xfff30019,0x000c0000,0x0000fff8,0xfff6000b,0xfffd0002,0xffff0003,
0x00000001,0xffe1000a,0xfffd001c,0x000bfff6,0xfffbfffd,0x00000007,0x0015ffe9,0xfff00003,
0x0027fff9,0x0005ffe0,0xffe70012,0x000b000d,0x002fffcf,0xffe7fff6,0xffd1002f,0x000f0012,
0x001fffde,0x0001ffec,0xfff90005,0x00010003,0x0000fffd,0xfffd0005,0x001cffee,0xffe2fff3,
0xffe40032,0x00120000,0x0000fff5,0x000dfffb,0xfffdfff9,0xfff6000f,0x00070001,0x0000fffa,
0xfffa0003,0xffe00016,0x00120012,0x000dffe4,0xfff40005,0x00060006,0x000afff1,0xfff50003,
0x00000007,0x0003fffd,0xfffd0000,0x00000003,0x00000000,0xffe9000a,0x0002000f,0x0000fff6,
0xffe50014,0x0000000d,0x0002fff9,0xfffb0003,0x00000003,0x0000fffe,0x00030000,0x0003fffa,
0xfffd0000,0x0019fffe,0x000bffe1,0xffe50012,0xfffd000f,0x00000000,0xfffd0001,0xffee0008,
0xfff80014,0x0005fffe,0xfffffffe,0x00020000,0x0003fffb,0xfffd0002,0x000d0000,0x0002fff6,
0xfffd0002,0x000a0002,0x000affee,0xfff40002,0x0000000a,0x0003fffd,0xfffd0000,0xfffb000a,
0x000cfffb,0x0000fffa,0xfffd0006,0x0015fffa,0xfff4fff1,0xffc9002f,0x000d0017,0x000dffe4,
0xfff30003,0x00000007,0x00000000,0x00000000,0x00060000,0x000cfff1,0x0003fffb,0x0000fffd,
0x00000000,0x0003fffd,0x00000000,0x00000000,0xfff60001,0xfff9000d,0x00000003,0x0003fffd,
0x00000000,0x00000000,0x0000ffff,0x000bfffe,0x0005fff4,0xfffb0000,0xfffe0007,0x000bfffb,
0x0000fffb,0xffff0003,0x00020000,0x0000ffff,0xfff80003,0x00000003,0x0000ffff,0x00000000,
0xfffe0003,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x000bfff8,0xfffafffd,
0xfff50012,0x00050000,0x0000fffd,0xfffe0003,0x00000001,0x0000ffff,0x00000000,0x00000000,
0x00000000,0x00000000,0x0008fffe,0x0002fff9,0xfffe0000,0xfffd0007,0x0008fffe,0x0000fffd,
0xfffb0003,0x00000002,0x0000fffe,0x00000000,0xfffd0003,0x00020000,0xfffe0000,0xffff0003,
0x00030000,0x0003fffa,0xfff90003,0x00030003,0x000cfff3,0xfffefffd,0x00000003,0x0003fffe,
0x0000fffe,0x00000000,0x00000000,0x00000000,0x00030001,0x0008fff6,0xffffffff,0xfffb0005,
0x00000003,0x0003fffd,0xfffd0000,0xfffd0006,0x00010000,0x00000000,0x00000000,0x00000000,
0x00000000,0xffff0002,0x000cfffb,0xfffffffa,0x00030006,0x0014ffe9,0xffd1000c,0xfff5002a,
0x0016ffee,0xfff1fffd,0xfff40019,0x000afffe,0xfffefffb,0xfffb0008,0x00020000,0x0000fffe,
0x00000001,0x00000000,0x00000000,0x00000000,0x00070000,0x0014ffe9,0xfff6fffa,0xfff80010,
0x00080000,0x0000fffa,0xfffb0003,0x00010001,0x0001fffd,0x00000000,0x00000000,0x0000ffff,
0x00000000,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0xfffe0000,0xffff0003,0x00000000,0x00000000,0xfffd0000,0xffff0003,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0xffff0000,0xfffe0005,0x00000000,0x00000000,0xffff0000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_34_standard_DRUMS_guiro2[1408] = {
0x00000000,0xfb0cfce0,0xf3d0075f,0xedf60cd3,0xddb417a9,0xc8ed29a6,0xbdda423f,0xe0a42fcb,
0xf625134a,0x0d74fc19,0x10caec86,0x1744ed91,0x1383e3ce,0x02f6f534,0xf19002f8,0xf1c51160,
0x015a0468,0x0474f9c9,0xfdd5fbd4,0xd7f6124e,0xe4732a8d,0xfc4709e8,0x0ae4fd09,0x10f6ee72,
0x11eced52,0x1700ea23,0x119aea37,0x1278eb43,0x11d9f0f2,0x1ea1e3c2,0x1c21e2d9,0x11a2e621,
0xfc8ff73d,0xf1d60b7f,0xef680ea4,0xfaab0b86,0xfba80241,0xfc5502d8,0xf87d04e1,0x05d60313,
0x1b7fed13,0x2146de52,0x0ddae703,0x01c8f90b,0xf669036e,0xec210ed2,0xef201371,0xf8020c95,
0x04010110,0x0750f6e4,0x170df48f,0x3ad7d9bb,0x7480a3bc,0x42ed96d7,0x1124dcad,0xdfbaff90,
0x8efa501a,0x923a6f49,0x86c27b10,0xa41065fc,0xc213511a,0xe6832944,0xee2e104a,0x092d0b73,
0x0ea8eba5,0x1a4beef9,0x1e2be396,0x1611e2ae,0x0f01ef6b,0x094ff50b,0x12bdf041,0x08ecf2f8,
0x0b53f431,0xfd44fa39,0xf76e0620,0xe8920fbf,0xe98019ee,0xf4340cba,0xe1a01306,0x99c83c18,
0x954b7b1c,0xc6b5508f,0xfc0a1ba6,0x11f0fa56,0x1b6ee1cf,0x2b9fe0ba,0x16aed945,0x10faec70,
0x0e7ff537,0x0d4ded26,0x14acf24c,0x1347ed5e,0x187ee744,0x09b2eeb3,0xf4e001ac,0xea901095,
0xef7c16ca,0xeef80c9a,0xeb7b137f,0xef9c1562,0xfe680816,0x06fbfc77,0x17e9f104,0x2ee9e0a4,
0x3e4ec2d1,0x1886d5d3,0x07d5eee6,0xe1ff09f6,0xe7f12580,0xe35c0b6e,0xd4d432d8,0xf78b1489,
0x00200491,0x1146f748,0x14aaeca4,0x1bb0e806,0x0ef2e7f5,0x0478f96c,0xff1cfc3e,0xfab00732,
0xfa0c025e,0x016a0544,0x1351f504,0x0e90ec50,0x0b17f2c6,0xf4c70069,0xef400f4e,0xf7d40f14,
0xfceb073e,0xffb5fb30,0xff6407e9,0x0e9af5e5,0x3361e313,0x32edc633,0x2227d3e9,0x16ece6da,
0x0510ef36,0xfed500d6,0xf2c805cc,0xf40b0fc9,0xf994091c,0xff810258,0xfb0202b8,0xf17808e0,
0xf5710e93,0xf3fb09f4,0xf4d80a18,0xf1690ff3,0xf6480add,0xfabe079b,0xf936074c,0x02480230,
0x0b78facd,0x0fdcf098,0x0d38efdb,0x0568f85e,0x006cfc60,0x012affe9,0xff93ff49,0xfcb20108,
0xfcd4046c,0xfda402b6,0x01c6006c,0x05f0fc5a,0x027dfb1f,0x01f2feef,0xfd4afebb,0xf648075b,
0xf3df0af5,0xf8a00add,0xfc7c052a,0x004500ea,0xfe4d00d4,0xfbc403d4,0xfa750270,0xf1a30d8d,
0xf1b40c12,0xfe0c0db8,0x033afa12,0x0423fdb7,0x0a36fac4,0x0ab1f12a,0x0fa4f680,0x0901ef56,
0x140cf586,0x141ee8fc,0x0455f3a2,0x05ccfd54,0xf4f9006c,0xf4060d2e,0xec550f36,0xf06e130b,
0xf5520ccd,0xf95c08e5,0xfb7b03b0,0xf9240796,0xfc84047a,0x00e40294,0x04f0fc66,0x05e4fb02,
0x0852f9df,0x076bf7aa,0x073af93c,0x03fdfa6c,0x0590fbe8,0x02b6fba8,0xfed3fefa,0xfe5701f2,
0xfc660344,0x012101cb,0x0508fc3e,0xfedffd43,0xf82e028c,0xe9e910f1,0xe2fc179d,0xe33c20a3,
0xee321750,0xf8a00b9e,0x02460547,0x0776f624,0x0992fa16,0x0a54f476,0x0a00f752,0x0ef2f201,
0x072cf446,0x0599fac8,0xfe28fd5c,0xfd12044b,0xfc560090,0xfc7005f1,0xfd320337,0xfb2901ea,
0xfade0606,0xf976048a,0xfbce05e2,0xf6fc076a,0xfa7a0534,0xfb46058a,0xfef903be,0xff9fffa5,
0x0354fee0,0x0590f9f7,0x05a2fa4f,0x038cfc16,0xffa3fdee,0x04d1fd17,0xfe8efec6,0xffe901c4,
0x04f4fd48,0x05bff99e,0x066cf922,0x031efc94,0xff85fe16,0xfb8801c0,0xfbc405ec,0xfd6a03c0,
0xfd35026b,0xffff01c0,0x0292fe68,0x05b2fbb0,0x02b8fc26,0x00e4fd02,0x0104ff97,0xffc90014,
0x006effe2,0xff5100c2,0xff29ffea,0xffc501a9,0x00390029,0xff23ffde,0x012effef,0x0216fe1d,
0x021cfe02,0xfe3c0000,0xfd600113,0x0648001a,0x1748f25b,0x2b16dccf,0x1564ddb8,0x0d92f0fa,
0x1393f1a3,0x0e84ea80,0x0ac0f3e4,0x04a6faa4,0x007df9c0,0xf3c20912,0xf0eb0bf6,0xeebd1156,
0xf5521102,0xf6d306fe,0xf7d00a24,0xfa1007c9,0xfda604e0,0xffe900d7,0xff780012,0xff2f0040,
0xfea5028a,0x016c0022,0x02b2fc6e,0x04f9fd44,0x03a4fb78,0x019afe84,0x00fffdd9,0xfec70072,
0xff8600d7,0x04a2fecb,0xfedffe1b,0x01befe0a,0x00df013e,0x001efd60,0xfcbe00fe,0xf2b207f4,
0xeed10eab,0x02820e54,0x1525ef76,0x1536eaea,0x149beb77,0x114cebc2,0x1120efb2,0x03bef47a,
0xfa8201d8,0xf7e206c8,0xf88207c4,0xf908076b,0xf7200907,0xf9cc0830,0xfd92034e,0xfbde0399,
0xf8e90716,0xfa5405ce,0xfc780468,0xfc8b02b6,0xfb4403d7,0xfafe0610,0xfe520221,0x0459fefa,
0x041cfc16,0x020cfcdd,0x0034ff3e,0x00a0ffe1,0x0064ff75,0xfeb600b6,0xfb7d032a,0xfb6803c7,
0xfcc7