#include "steelstrgtr_samples.h"
const AudioSynthWavetable::sample_data steelstrgtr_samples[2] = {
	{
		(int16_t*)sample_0_steelstrgtr_acgtrg2, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(47) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(74) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)4881 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)4877 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)4877 - 1) << (32 - 13)) - (((uint32_t)4800 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-13.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(7197.52 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(100.02 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(21.8 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(120.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.5 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_steelstrgtr_acgtrb3, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(32) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(76) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)6240 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)6236 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)6236 - 1) << (32 - 13)) - (((uint32_t)6168 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-13.5)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(7197.52 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(100.02 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(21.8 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(120.05 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.5 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_steelstrgtr_acgtrg2[2560] = {
0x00000000,0x004e005b,0x004c0040,0x004c0054,0x009c0064,0x01b100e0,0xfc43fec8,0x011fff16,
0x0101fbe3,0x004ffe6c,0x0094fdcc,0x09520c4f,0x0bd307c5,0x17391001,0x06c01171,0x0a5a04f3,
0xfbde0306,0xf812f607,0xf58601e8,0xf64cf319,0xf7e0feae,0xe892f095,0xe9fee13a,0xea39f35d,
0xe0b2dfa1,0xe4ecd4dd,0xecc3eced,0xdf71ee8e,0xe44ee2fd,0xeb2eec49,0xe95cf060,0x0303f7da,
0xfdeff38f,0x0eef0194,0x0e180e6e,0x122c0e31,0x0ea415af,0x1f0e159c,0x2a2a29ee,0x23e92809,
0x1e632680,0x231723df,0x265a2441,0x178217e8,0x1ad51965,0x120917c4,0x1c8a0c68,0x1a6b26ed,
0x101c1e15,0x30122f3f,0x38353207,0x497e436e,0x33233fc0,0x39542c05,0x3f623af7,0x11ed193a,
0x1f631b58,0x07e61948,0x03830929,0xfb1ff800,0xe93af1fa,0xf055f370,0xd61ddaa6,0xb8eebdf8,
0xc139befa,0xa59dbecb,0xa685a5ac,0xa99da907,0xa8d6b10f,0xb903adcf,0x9f1aacd5,0xb0fea6bf,
0xc603b365,0xc2bbc6c2,0xc6b6ca50,0xc59ac4bb,0xddb4cb78,0xdcf3d5b0,0xd5a1e4e5,0xe043df4f,
0xebbadeb1,0xdc6be71d,0xdb0dd3b0,0xe21cdf46,0xee96e37d,0x033df6f6,0xfdfd0cfe,0x276d1339,
0x358e3132,0x55f84877,0x61635bf4,0x56ae561e,0x748e5f3b,0x4fda6549,0x5a8f4ff2,0x531d6196,
0x45ea5561,0x44604907,0x2e564199,0x3b7d30bc,0x32da289e,0x071a14ee,0x0654fbd4,0xfa0c0533,
0xe152f07d,0xdfc5e530,0xeb0bee93,0xf7d3ef33,0xee66fce2,0xe4d4e630,0xef0ddd54,0xecaeebbb,
0xec6eed92,0xe3c6e817,0xed35e298,0xe97bee66,0xe146ec78,0xe08ce4a5,0xe58fe251,0xe5d9e824,
0xd6d3d5c6,0xdd8ece41,0xdd71d32e,0xe93ada64,0xf0d2f9f2,0x044af366,0x19931869,0x3af2338c,
0x4fbb4dce,0x4b39527a,0x632f45af,0x581d68c2,0x42e144b1,0x48c249d4,0x3cfc4637,0x30a23aaf,
0x24c33b6d,0x22bf1ee8,0x23cd1d43,0x060b1366,0xf59cf306,0xf700f3a2,0xd97be7dd,0xd028d649,
0xdde3d7fb,0xde9edafd,0xe72cea42,0xdac9dfcf,0xd9b8d60a,0xdc73e009,0xd713dacf,0xcdc8d2da,
0xc7cac372,0xcb2bcc78,0xc81dcc0e,0xbf0fc375,0xc119c260,0xc587c762,0xb4a7c01e,0xb4e9ab61,
0xb698b090,0xb706b6f2,0xd264cc96,0xd3a0cdbd,0xede8e416,0x0bbe0069,0x2c1f2299,0x3fed363c,
0x39172750,0x536f4967,0x2fa63aba,0x36133037,0x3319353f,0x1c8131b6,0x233d3378,0x1bbe20be,
0x23961ba3,0x2006207c,0x02d3092d,0x096afe84,0xfa620121,0xeb56f1d0,0xf6c9ede9,0xf678fd17,
0x0b6c0768,0x0ea00e8d,0x01b104b5,0x0bcd0ad6,0x0ceb0cfa,0x08c70693,0xf8a6f8ed,0xf5ecf83b,
0xf5e0fb38,0xf108f7a5,0xecfff39a,0xf341f69a,0xf0d3fb73,0xe420e37a,0xe90bdee6,0xe2e8e331,
0xfd01e7fc,0xfaecf6a4,0x0637fdb4,0x18d3147b,0x362430af,0x536645a2,0x41234b04,0x62034b2b,
0x4b4a5b90,0x3fd33982,0x3bde3741,0x228a39f6,0x25792a3b,0x149c21e3,0x0f6c1231,0x17f0142c,
0xfd130eed,0xf227ef38,0xee50f2dd,0xdd23e477,0xd6e9d11b,0xd699de4a,0xe712dd3b,0xf26eea51,
0xe292eb6e,0xe504e4cd,0xe927ebcf,0xebc1e6e7,0xdb26df83,0xd420d5d2,0xd784d534,0xd3a7d52e,
0xcb95d093,0xccbdcfec,0xd8dcd7f8,0xcb24cfa3,0xc9b9c1ff,0xc984cc78,0xd8f4c76e,0xe2eee0a2,
0xe911e70f,0xfb3af9f4,0x190412e6,0x39212881,0x39e042c9,0x45032ff4,0x52925187,0x3a7137a8,
0x30892c71,0x26e536fd,0x1d7c22c6,0x1301221c,0x05060f3b,0x0c27068a,0x09f30f94,0xecfcf323,
0xeffaf06f,0xe865eb94,0xd353d784,0xd981db5c,0xdf77d8c1,0xee5de425,0xeab2f249,0xe27ce5c5,
0xeb9fea15,0xef2ee8ab,0xe6b2e93a,0xde1ddd3a,0xe003d82b,0xdf4edf4c,0xd9ffdfdb,0xd713dd96,
0xe6cae240,0xe4b4eab1,0xd83cdf6c,0xe64be53d,0xebe8ded6,0x032ff464,0x0922030f,0x13df1108,
0x3145266f,0x4a033e08,0x6165616f,0x55ac5945,0x72b667dd,0x68176a23,0x54d8550a,0x573a5886,
0x44914d04,0x3fd344ee,0x2dc6393b,0x262b27f6,0x2f552afd,0x0de62229,0x095909b4,0x05be04b3,
0xe9eefa9d,0xe8cfea07,0xe5cae63d,0xec8fe669,0xf28df4ac,0xe0adeea4,0xe2f8e1ca,0xe0cee0fa,
0xdd79e266,0xd0e1d560,0xc883c70b,0xca5bc82c,0xc440c7e2,0xbd86c53c,0xc4bbbe5c,0xca3bc9a5,
0xb8e5c7be,0xc58fba16,0xc0dcbaf4,0xd669c2d2,0xdebed932,0xe8b4e8ac,0x0231f4a7,0x148f0fd1,
0x397a2f8d,0x30ad41cd,0x4f333764,0x523b4e6c,0x39a141d5,0x3eda3882,0x335d39c6,0x2d7d2ee3,
0x245e2d25,0x16761ebc,0x1ff2177e,0x14652458,0x042c0597,0x006cfde4,0xef7cff76,0xe4cee7ca,
0xe403e2d2,0xe39adef0,0xee76eb78,0xe69ef3dc,0xe0d5e30a,0xdfcce2be,0xe279e336,0xda8fde72,
0xcff4cfec,0xd126c84b,0xcd4ece1d,0xcad9ce8e,0xc857c530,0xd1c7cef9,0xcaf8da58,0xc900c4d5,
0xc92dcab2,0xd376c372,0xe20fd9f7,0xf0c0e884,0xff24f07e,0x12810e7d,0x349a24c6,0x438e4ef8,
0x4b4b3f91,0x61265748,0x52315dc5,0x4db9488b,0x4c3e4ed9,0x42f84741,0x424744ed,0x355f3c8b,
0x2f8c2c86,0x3a983c6c,0x24432c48,0x1a5f1b77,0x162e1d6e,0x03b40a19,0xffe2fc65,0xf6cbf72c,
0xff76f9c9,0x0501075f,0xf691fda1,0xf37af796,0xf447f4b1,0xf0edf4a8,0xe3c4e7f3,0xda60da5d,
0xda33dd3c,0xdb7cda7d,0xd056d3c1,0xd261d329,0xd907e0f6,0xc7d0d153,0xccc1cb6f,0xc556c0d5,
0xd4e2cab6,0xe2ddd5ae,0xe5c5deab,0xfb38f180,0x0b71036c,0x33a82ccd,0x2c722dcb,0x42b6356b,
0x474e4a7f,0x342437af,0x363c3568,0x2c56327a,0x2af02aa0,0x244827e1,0x0ef918fc,0x21b2186b,
0x14ac1bb9,0x009c0890,0x026b03e4,0xf1c6fb5a,0xe906e809,0xe011e3b4,0xe1b8dd62,0xefd7e87a,
0xe6eeeeed,0xe07ce5f8,0xe0aee376,0xe445e512,0xdbd5dfce,0xcf25d44a,0xd1b4cf17,0xd51ecdba,
0xcc6acf90,0xc69acb96,0xd7aed556,0xcafdd7ad,0xccdec871,0xc2b7c8f6,0xd02dc6d2,0xdfacd1ae,
0xe603defe,0xf709e801,0x004502b3,0x32db1aba,0x340a38fd,0x3f2e36a9,0x583a4e69,0x47095060,
0x461e4207,0x415445a8,0x3cce3db6,0x3cbd3c94,0x272939c8,0x2f292579,0x3196327a,0x1b092b3b,
0x17b2199f,0x10a11839,0x015f0466,0xf9fefc20,0xf226f343,0xfea5f47c,0x00f102ad,0xf722fd22,
0xf2c1f6d9,0xf6a9f535,0xf36cf558,0xe591ec96,0xe223e152,0xe3c7dd1a,0xe082dfa7,0xd45cdc7e,
0xdf53d8af,0xde50e82d,0xd440d7be,0xcd80d892,0xcffaccc5,0xdd75d1d1,0xe7a3de9d,0xeca5e3b4,
0xfaacfcae,0x1ceb024d,0x339b3123,0x31573234,0x4b6a3c83,0x49be50ea,0x3d143f4b,0x3c8f3fc9,
0x36ba3921,0x3303325e,0x2b1c3711,0x1e091b8e,0x25fe2224,0x19d627d1,0x0a7210a8,0x0a470c00,
0xf81affc4,0xee7bf165,0xe41de88e,0xe654de80,0xf05aec8f,0xe9b9ef2c,0xe1c7e786,0xe1d4e1b3,
0xe2e4e415,0xd88ce19d,0xd1e3d358,0xd179ca26,0xd179cce9,0xc9efd006,0xc5fbc48a,0xd3a7d455,
0xc558ceae,0xc348cb17,0xbe49c0c4,0xc758bd9f,0xd66fca3d,0xd70ed4a5,0xee41e607,0xf963ec19,
0x24c21448,0x27542a07,0x366f29ba,0x4a5e4553,0x3b144370,0x3e223b89,0x3b02393c,0x32cb3613,
0x3b9938a9,0x24d62acc,0x28be236e,0x2d833027,0x182b254e,0x16d91752,0x09f71559,0xfed7054e,
0xf8a6fb7c,0xefb6eed6,0xfd92f4b5,0xff5a008d,0xf874fd34,0xf3e8f537,0xf4c5f6e3,0xf230fb08,
0xebb2edcb,0xe4c9e25c,0xe4f4e25d,0xe6e1e5b2,0xd8a6dd43,0xe9badd12,0xde37e7c0,0xda1fe081,
0xd2d4d94d,0xd16bcf36,0xdf16d2cf,0xdf95e3a7,0xf5c0e840,0xf687f713,0x1dee071f,0x31b22e98,
0x31b52e41,0x4c333e08,0x47144f2e,0x4269402f,0x3df63f4e,0x34c13ecc,0x3e4535ff,0x2d8c375e,
0x2251232a,0x2c682849,0x1ee82c42,0x11f2150f,0x0c0e12e2,0xfcb40474,0xf533f6de,0xe65becf2,
0xec21e420,0xf4b2f244,0xf259f4b1,0xe9c4ed5d,0xe664eb1c,0xea51eec7,0xe2d0e666,0xd830db55,
0xd58bd470,0xda29d38a,0xcf41d587,0xd2a9c6bc,0xd270dae8,0xcd62d3f5,0xc7f3cdd0,0xc253c36a,
0xc61cbd8c,0xcfd1d136,0xdd4acef5,0xe51fe512,0xf814e7bc,0x1ef2105f,0x1ef12299,0x318424bc,
0x411f416c,0x37683b4e,0x338e378a,0x31ac37d7,0x31b82a66,0x31ef3356,0x1d74249a,0x22ed1c2e,
0x271c2806,0x11801a35,0x0ee511a7,0x01f10ba4,0xf83efc08,0xee63f530,0xe7b9e586,0xf607ee37,
0xfb6df6a4,0xf3c8f65b,0xee11f3c3,0xf47bf41f,0xf117f5f6,0xe7a5edae,0xe1f8e3e5,0xe2c8dfec,
0xe52de5ad,0xd760d6ee,0xe39ae27f,0xdef8e2ea,0xdbb3defc,0xd5e6d5ec,0xcbd0ce6a,0xdff0d8a9,
0xe0c9da77,0xf28ded58,0xf5c6f1e6,0x1e6e0711,0x2e532ce4,0x31872c6d,0x4e4a41c9,0x49394c6c,
0x411b4647,0x438e44ae,0x38fd3a85,0x3ff53ba7,0x2f763ab1,0x266c262e,0x31572b17,0x1ff72d61,
0x16c01aff,0x0ffd1772,0x01f50756,0xfaacfe00,0xe8c4f08f,0xf242e8d2,0xfaa1f2a3,0xf630f802,
0xee61f629,0xef5af034,0xf181f392,0xe819ef64,0xdeb5e4f8,0xda06db8b,0xe3fdda8e,0xcff8d775,
0xd79cd114,0xd605db6d,0xd502d75c,0xcdbdcf83,0xbfa5cb09,0xcfd4c29a,0xcd06cf95,0xe07dd534,
0xe239e314,0xf8bce525,0x1c320dec,0x1a921cda,0x347d21e6,0x3bdd3b4f,0x32cc3cba,0x3699362f,
0x2c02340f,0x2f5f2ada,0x2d813239,0x1a922135,0x21541886,0x20c5257e,0x0ff816cd,0x0d330fdf,
0xfecd07e6,0xf84ffc42,0xea9ef5ca,0xe7eee3b0,0xf348e97b,0xf603f3e4,0xf1daf597,0xee5eee7c,
0xf2bcefe2,0xee63f484,0xe66aece4,0xdf22e318,0xe569daa4,0xdc26e490,0xd705d635,0xdebae067,
0xdfecddd9,0xd7f3db33,0xd112d99e,0xd00ec7f0,0xd7a1d90c,0xe14dd6a9,0xec78ea9a,0xefc7eace,
0x17e102ad,0x252f25da,0x2ff7221b,0x432d3d5a,0x42db4939,0x41213e63,0x3cb1421b,0x356435fc,
0x3cbd3a68,0x2c853604,0x243821d5,0x2e512a24,0x200d2991,0x19b31bfd,0x0f911944,0x04e50b5a,
0xfe380592,0xf057f37d,0xf655ed53,0xfcdff8b4,0xfddafdbd,0xf683f8df,0xf56af562,0xf7aefaa8,
0xefc7f698,0xe8d1edfe,0xe31ddfb4,0xe76ee895,0xd80cdf08,0xe13edbd5,0xe11cded7,0xd9dbe01c,
0xd97edc23,0xc7e7cdfe,0xd59ad0de,0xd3bfd31a,0xe64cde9c,0xe3c2e604,0xfa8fe938,0x1dda1028,
0x1b321672,0x30a625da,0x3cef3a49,0x330d3617,0x351f36c9,0x273c2f97,0x2d36293e,0x29742df7,
0x13f11b55,0x1bea1519,0x19b01e09,0x0d5b1113,0x08b70c5a,0xf998036c,0xf725fb65,0xe954f0b0,
0xe3a2e161,0xedcde972,0xf4bbf0e2,0xf0ecf275,0xebf6ed19,0xf02bef32,0xec4ef316,0xea42eaef,
0xdc3fdfc0,0xe540de94,0xd9e0e2ff,0xdb93d6de,0xdf0cdd37,0xdd40e264,0xdfe2dc69,0xceb3da32,
0xd47acd4a,0xd4e2d824,0xe41bd898,0xe974eac0,0xed52e975,0x19910005,0x1db71e48,0x2b8b2220,
0x41ea37e1,0x3c76433b,0x3f423cb0,0x356b3ee4,0x3187308f,0x37ca34d6,0x247f303e,0x1fb81bc5,
0x277e237d,0x1b062094,0x15541715,0x07c614bd,0x036906dc,0xfb2500f6,0xeae0f19f,0xf25ded08,
0xfabff48a,0xfcb9fa6d,0xf52ef79e,0xf43bf585,0xf860fb90,0xf5d9f419,0xe7b9f064,0xe72ae367,
0xe830eda4,0xe0fbe087,0xe335e087,0xe756e79c,0xe57de214,0xde94e6a3,0xd48bd43d,0xdb63da7a,
0xdd73d906,0xebcde9c9,0xe954ee16,0x0524edcf,0x1d581823,0x21ae1daf,0x37e429e3,0x40074027,
0x3a843a69,0x39c43f20,0x2c4f326b,0x30bb2d0f,0x2b2a32f3,0x179b1cfe,0x1eed17dc,0x1a151d74,
0x0e8812a3,0x083d1092,0xfd130101,0xf7e0fb02,0xe6b6f209,0xe2eee149,0xeb27e58c,0xf1aaecc3,
0xec9aeff4,0xe70bebae,0xef25ec0a,0xeaddebad,0xe517eb5b,0xd85cdcf3,0xe316df81,0xd932db5c,
0xd5c3d6eb,0xdf77daf9,0xda71dbbc,0xdf2adf7c,0xce8ad59f,0xd503cf9a,0xd260d42d,0xe270db32,
0xe8dfe98b,0xec36e24e,0x12ad020d,0x1b5b18c5,0x29051d34,0x3eed35ce,0x38ec3de8,0x3e433d29,
0x328c3b33,0x2e592e73,0x35b034be,0x211c2dac,0x1fa91a76,0x248a20ca,0x18111e35,0x15bd17dd,
0x08190f49,0x02b10502,0xf8ae022e,0xe9f9f028,0xef5aea47,0xf6f2f0b6,0xf7a0f8ab,0xf179f726,
0xf573f185,0xf525f637,0xf550f503,0xe44aef4c,0xeb24e3e6,0xe538ea0c,0xdf23e479,0xe61bdf77,
0xe2f4e70f,0xe9f0e3d2,0xdd7fe638,0xda1bd6e6,0xd946dbba,0xe015dbac,0xf112ea6a,0xe783ebde,
0x069df35c,0x1d3d1570,0x210b1d0c,0x399d2bac,0x3de34099,0x3ec43c0b,0x3b12406b,0x2d72347d,
0x34ba30a5,0x2d163678,0x1d301f00,0x223f1c54,0x1b3c21a1,0x15eb17b5,0x0c741361,0x010405c8,
0xfcbd0230,0xebf4f61b,0xe78de4f1,0xed52e731,0xf1adf02f,0xeef7f396,0xec6beb3a,0xef70ede5,
0xeef9ee1f,0xe63df09f,0xdf93dd53,0xe14be3ee,0xdd27e021,0xd9b8d72a,0xde7fe012,0xdf2fda8d,
0xdfb5e306,0xd2e0d497,0xd2c2d468,0xd2f1d3cb,0xe547d971,0xe231e9d6,0xecdee1d1,0x0e56fe84,
0x160e143c,0x2658185d,0x38cd32b7,0x36303610,0x39d93963,0x2cf43735,0x2abe2a0c,0x3264323a,
0x1dd42744,0x1b3918aa,0x1e231fae,0x176918a8,0x12f214a0,0x043a0c4a,0x019903f8,0xf6fbfee4,
0xe908ec96,0xea93e6c0,0xf11def51,0xf626f5b5,0xefeff0d9,0xf1e3f008,0xf187f2d1,0xf56ff6a3,
0xe47be988,0xe8a7e75b,0xe7dbe849,0xdddbe34a,0xe73be398,0xe287e497,0xed5be7d3,0xde57e536,
0xdbc2ddbc,0xdbe1dc20,0xe34fda59,0xefc8f004,0xea2eea94,0x0646f517,0x1c1b1465,0x202c1ab4,
0x3a142d39,0x3ce73d16,0x3f573c94,0x3b3d41b2,0x2cfb3472,0x37cc3200,0x2cc4356d,0x1d8f212d,
0x23892019,0x1d5c1f4a,0x1899196f,0x0c9d1621,0x045d0882,0xfff0049d,0xef8ef705,0xe6cee80f,
0xec9beb0d,0xf4f1f065,0xef9ef2ca,0xeea2ed84,0xee4eefb1,0xf647eff0,0xe62bf071,0xe3b6e360,
0xe54ce4af,0xdd58e51c,0xe004db98,0xdeaae2a6,0xe62cdd51,0xdf4ce6af,0xd896db21,0xd7c8d676,
0xd3a2d440,0xe8a9dfe7,0xe29ae89f,0xedaae40c,0x0d0ffe61,0x122412ed,0x272f17fa,0x35af3015,
0x353d33e3,0x39a73921,0x2af23646,0x2c39272c,0x2f9c3094,0x1abd2645,0x1b59183a,0x1a4e1baa,
0x14c4166c,0x0f4b14e4,0x02470979,0x00fb01ad,0xf538fabb,0xe458eb7d,0xe691e50b,0xee71e931,
0xf08ff195,0xec34ecbd,0xed01ee48,0xf23bec1d,0xef33f5ec,0xe587e777,0xe64de43f,0xe589e8d2,
0xdee3e002,0xe55be431,0xe3b4df76,0xe9aeead4,0xe102e481,0xdd89dd23,0xd79bdcc2,0xe655db18,
0xecf8ef7c,0xe9e0e94b,0x043ef40c,0x17d81336,0x20a31693,0x37602c18,0x3ad63a96,0x3f923cd5,
0x3c544353,0x2f663225,0x37da345d,0x2c6437f1,0x211d2220,0x23952140,0x1ceb1eb9,0x19b21c32,
0x0d871640,0x08430819,0x00d304f4,0xef34fa67,0xe8c2ea3d,0xece8e980,0xf490f138,0xee4af2d6,
0xf0bbf07e,0xeec8ecb1,0xf700f57c,0xeaf5ef33,0xe4e1e657,0xe8f4e8be,0xdf2de5fe,0xe572e0da,
0xdedfe204,0xe8e4e464,0xe438e7b6,0xdd2dddea,0xd8fddc27,0xd874d403,0xea8be49e,0xe48ae933,
0xee8ee5ec,0x0cf00056,0x11cb0fdb,0x277719a9,0x341c2fbd,0x35f034e5,0x3d9c3bb1,0x2c5235ee,
0x2da12a97,0x312f33bb,0x1e3925bf,0x1d7d1a25,0x18261b7f,0x15441783,0x0f441524,0x03a006c4,
0xff4101ae,0xf3a6fc7a,0xe569ead1,0xe40fe2a1,0xec14e709,0xeb9defbc,0xed7bea12,0xe72ceaa6,
0xf2ccebad,0xecfff180,0xe27de84a,0xe682e353,0xe245e7ea,0xe1fcddd6,0xdee0e3c1,0xe428df69,
0xe8dce7c7,0xdf4fe2d7,0xddeddeb0,0xd4a8d867,0xe60fdaf6,0xe996ec30,0xe60fe73d,0x021cf201,
0x11710d8c,0x1de8128f,0x326b28e5,0x373736d6,0x40de39b9,0x398d4172,0x2e4931dd,0x3878347e,
0x2bcc3592,0x21ba2281,0x1fed228f,0x1bf51df2,0x1ad21bf8,0x0dc71382,0x07830913,0x019a064f,
0xf191f998,0xe843eae6,0xeb91e8e1,0xf30ff290,0xf02aef63,0xed62f307,0xf212eb59,0xf5f9f5dd,
0xec6af1f2,0xe779e6cc,0xeb3fec17,0xe31ce40c,0xe4dbe778,0xe302e28c,0xeb99e681,0xe512eaf1,
0xe2d0e1cb,0xd947df63,0xdd3ad5ad,0xebdde757,0xe57deb50,0xf1e1e6a5,0x0bde0104,0x11cd0dd1,
0x26a21bb4,0x33bc300a,0x38bd3359,0x3e3f3ecb,0x2d653843,0x317e2d44,0x32ec3556,0x208426fd,
0x1e211ebc,0x18601be0,0x188417ad,0x0f4f14db,0x03b408ec,0x01650391,0xf547fc17,0xe69aec9b,
0xe23ae2e8,0xed09e790,0xe96bec74,0xed0fed36,0xe7d9e67c,0xf100ec4e,0xedc1f0f2,0xe165e7c3,
0xe911e462,0xdf28e51c,0xe26ae1e6,0xde92e0d9,0xe34fdf16,0xe792e85d,0xe0b1e0c6,0xdd19e099,
0xd42fd4ef,0xe479db94,0xe7dfeae6,0xe4c4e3c6,0xffbbf10e,0x0bce08ad,0x1a6710cf,0x2ff325d3,
0x33df3129,0x3f05395c,0x37924088,0x2f0e2fd6,0x38b4334e,0x29bc335f,0x21712413,0x1da421ef,
0x1c161aa7,0x18601b60,0x0bd91373,0x08470852,0x012a0531,0xf24ff968,0xe669ebc1,0xecf1e6af,
0xeebff142,0xf30cef6b,0xeb8ceff8,0xf10cecc2,0xf5ddf54d,0xebfbf313,0xebdee605,0xe792ede5,
0xe714e5ce,0xe513e788,0xe313e392,0xed28e87a,0xe54fea5f,0xe69be590,0xd89ddf55,0xde50d81a,
0xecd6e896,0xe502eaa3,0xf3b5e73e,0x08990086,0x117d0c8e,0x27e41a6c,0x31412e4f,0x396c33ef,
0x3fa940c5,0x2fb337ca,0x34612e95,0x31f2377b,0x22d329ab,0x205e21f1,0x19d01aee,0x19801a4a,
0x10c41741,0x06f009bd,0x039305d1,0xf774fe57,0xe942f0fc,0xe422e2df,0xeb86eb4d,0xed1aead7,
0xebe1ef0d,0xe949e7d4,0xf14ded1a,0xf05cf2a0,0xe46de5e7,0xe890e9c4,0xe2e0e3cd,0xe376e468,
0xdebfe23b,0xe575dff5,0xe5e2e9b6,0xe4e4e165,0xdbdee297,0xd469d515,0xe503db5b,0xe634e9b6,
0xe466e091,0xfb50f0f6,0x080d0491,0x187a0c5a,0x2a59233a,0x2fd12d3f,0x3d7437d1,0x355a3d39,
0x2dc72c95,0x34e33277,0x27933038,0x21ab2261,0x19d01e34,0x18ff1915,0x164b19cd,0x09fb1080,
0x06ce071a,0xfef003d9,0xf38ef901,0xe349e9f5,0xebdee7b8,0xecccebd3,0xf0ecef8e,0xea8ded7d,
0xef24ec27,0xf7c7f42c,0xe988f1b6,0xee2dea43,0xe828ebbc,0xe8aae82d,0xe62ee920,0xe4b9e341,
0xee2eeb57,0xe837e8e1,0xe805ea47,0xd9d2e0ae,0xdfeed945,0xee35ea20,0xe42ee98a,0xf3ebea5a,
0x0794ff36,0x10af0993,0x26641b26,0x2e952ce1,0x3ab33393,0x40a74094,0x303b36ad,0x351a3118,
0x31ce37a0,0x263e29d7,0x1fc423a3,0x19df1bcc,0x1ae41b2d,0x114b1772,0x08870a93,0x04a20799,
0xfb10fea6,0xe853f43c,0xe809e3f4,0xe9e4e9c2,0xee41ec16,0xeb13ef78,0xe9bae9dc,0xf40cec18,
0xee8ef562,0xea2ce7fb,0xe93deb95,0xe5aee670,0xe6c6e77e,0xdfd4e411,0xe981e358,0xe630e9bf,
0xe873e61d,0xddc7e54c,0xd607d6e4,0xe777dcc0,0xe41fea87,0xe655e1ce,0xfb71f01a,0x0512013e,
0x16ff0b87,0x26cd222a,0x2f022a18,0x3d843686,0x32973bc0,0x2d752d3d,0x33a83257,0x27a82d20,
0x20922359,0x17e21cb7,0x186e1709,0x14b61831,0x085a0e7f,0x062d068c,0xfda4017c,0xf221fb59,
0xe436e6f0,0xe7b1e6f7,0xeaf8e87f,0xed3cee50,0xea0deb6e,0xecd6e7d5,0xf525f4f8,0xeaa8edd7,
0xecebeb7e,0xe7f7eaab,0xe998e821,0xe4ccea2c,0xe74fe29a,0xebd9eba8,0xea4ce8d2,0xe8eeebf4,
0xdac4e10e,0xe130d884,0xec17ebcb,0xe4bbe80b,0xf406e9d0,0x03d6fd6e,0x0e1a06f9,0x23ed1adf,
0x2c3e291f,0x3a793148,0x3e474095,0x3053360e,0x366c317d,0x309f356b,0x26fd2b53,0x1f442477,
0x19851ac2,0x1aac1b73,0x10c8176a,0x0a770a85,0x031507c9,0xfe1a013e,0xe991f352,0xe898e6d8,
0xe942e834,0xee18ed4c,0xed10ee33,0xe77aea1a,0xf604ee9d,0xeec6f3d2,0xecaaeb82,0xeaf8ecf8,
0xe819e83b,0xe97eeb56,0xe33ee3e0,0xeaffe7c6,0xe87aea7a,0xebd2ea55,0xe143e805,0xd751d871,
0xe923e161,0xe580ea76,0xe87fe2a5,0xfafbf131,0x02cfffe6,0x174b0be6,0x25462069,0x2e412782,
0x3d033787,0x32303b3b,0x2fa62d4e,0x31cd32a4,0x288c2d6d,0x218f24d7,0x16fe1c15,0x17ed16ad,
0x146517c1,0x08a00c9b,0x03b907dd,0xfffe0066,0xf0d9fad9,0xe5a7e757,0xe44fe5eb,0xea68e7f3,
0xec4eeb34,0xe685ebcd,0xee57e5b2,0xf1ebf38d,0xeb86ed36,0xec7debc2,0xe6c9ea85,0xebe2e93d,
0xe370e8d9,0xe860e492,0xea51eb34,0xec22e99c,0xeacfec96,0xd8d2e208,0xe2cfda0c,0xeb91eaba,
0xe4d3e63f,0xf354e9ce,0xffabfc1e,0x0d340443,0x21dd1899,0x284f2549,0x38c13044,0x3c873f74,
0x30b433b5,0x35113250,0x2fdd33a4,0x28202b56,0x1e3e2472,0x18cc1a00,0x1abb1aac,0x0ed015ee,
0x09b90c95,0x03df0558,0xfda902d9,0xeafaf29a,0xe6e8e906,0xea5fe69e,0xecb4ebc0,0xecf3efad,
0xe863e73e,0xf50df090,0xefebf2ad,0xee09ed4e,0xeb04eee3,0xebe8e8ae,0xe96dedd5,0xe687e528,
0xeb9aea5b,0xeb9deaff,0xef3bec3a,0xe20fec57,0xdad8da29,0xeb05e3e9,0xe67ceaf0,0xea03e44e,
0xfa34f3a7,0x02b1fe0f,0x17b60b8e,0x228a1fb9,0x2e0e26a6,0x3e0037bc,0x327839b4,0x31302f8c,
0x315932f0,0x2a012dc5,0x220d2712,0x176f1c91,0x19091663,0x123d1843,0x0aa80d5d,0x02b70658,
0x017101cf,0xf077fa20,0xe68ae9c9,0xe464e365,0xe73fe7a0,0xed02eafe,0xe3e4e946,0xee7be687,
0xf08ff14c,0xeb6fed56,0xecd5ece4,0xe772e830,0xebe1eb26,0xe370e778,0xe89ce66d,0xea6ae98b,
0xebdee972,0xeb44efac,0xd932e18c,0xe3afdae1,0xea9fe9dc,0xe3b0e547,0xf2cfea76,0xfccbf8f3,
0x0b710108,0x1e351721,0x254f21cd,0x386c2e15,0x39903dc2,0x311a330d,0x33f1324c,0x2eee31ad,
0x28862c0c,0x1e3c23ea,0x184e182f,0x18881b90,0x0fe913e4,0x07d80c96,0x05670461,0xfbdd0358,
0xed84f393,0xe5c0e849,0xe871e7ab,0xedd9e970,0xea55ef62,0xea03e618,0xf389f03a,0xefa7f2cd,
0xf07eeec7,0xea90eebb,0xee5feae3,0xe8d6eed8,0xe97ae731,0xec9bea5a,0xeb77ec0e,0xf26fef4e,
0xe36cee18,0xddd6db9a,0xebf6e52a,0xe5e5ebe4,0xec16e5b7,0xf989f3a9,0x0129fbec,0x16980bf9,
0x206e1e3b,0x2e0d246d,0x3cf93878,0x334838b2,0x32f0311b,0x30d83328,0x2bf02ed0,0x244d2855,
0x16c51d0d,0x19e918d6,0x1297170a,0x0b4f0fa0,0x03ed058e,0x01a704f4,0xf3edfa1f,0xe66eec3b,
0xe586e501,0xe75ae589,0xec88ed01,0xe4b6e74e,0xedfde7ee,0xf02af14b,0xee1eed62,0xec64eec0,
0xe9a3e871,0xebd9edc2,0xe682e72c,0xe95ce72b,0xe981ea8f,0xee15e9da,0xec30f1bb,0xdaade187,
0xe3b9dc27,0xe918ea92,0xe43de3f5,0xf235ea50,0xf911f677,0x095bff1b,0x1b7714a4,0x21ea1d2b,
0x36b02c71,0x36f23aaa,0x309c31e8,0x317d3230,0x2e562fd3,0x28e52aff,0x1b752415,0x18b616fd,
0x15ce1946,0x104012f6,0x05340a9b,0x05ef050f,0xfbda00bf,0xecb8f555,0xe65ae7c8,0xe51ee60c,
0xee37e97b,0xe832ecc7,0xe947e639,0xf27def77,0xefc9f0ac,0xf117f078,0xea34edb4,0xefaaed66,
0xea41ed93,0xea47e8ea,0xecb7ec6b,0xec52ebd3,0xf523f217,0xe4f5eeda,0xdf22ddaf,0xecd5e742,
0xe6a3eb1d,0xed9ce6bb,0xf7a8f41f,0x003dfa7f,0x16130afc,0x1d0c1c2a,0x2db92327,0x3b8737a7,
0x335237a0,0x337c32b9,0x316f3233,0x2ce12e95,0x246f2ac0,0x18121c13,0x18c719eb,0x140f15dd,
0x09b710d4,0x06640551,0x00a704e0,0xf55ffc74,0xe846ec5c,0xe3f3e68c,0xe97ae41b,0xeaececff,
0xe4bfe733,0xee6be85b,0xef16f026,0xf018ee84,0xead8effa,0xecb7e9e1,0xeca0edcc,0xe7cce8bf,
0xeaffe955,0xe975eb22,0xf1cceb3d,0xedeaf39a,0xdc30e3d9,0xe5fadec3,0xe950eae8,0xe5ade442,
0xf206ec45,0xf7bbf555,0x08e0fdb9,0x188c1404,0x20bc1a0c,0x35722b67,0x350338e5,0x318e3226,
0x31333167,0x2d212f20,0x29f62c69,0x1aa722fc,0x18c6182d,0x14b81731,0x0f911467,0x05d20816,
0x041805fd,0xfd4a0094,0xecbdf4e5,0xe62ee9ba,0xe46de2fd,0xec84ea0c,0xe6e8eaff,0xe94be507,
0xf04cee65,0xefc0eecd,0xefb0f227,0xebc4eb9a,0xef47eda5,0xea2deda6,0xeb1ce969,0xebcbed08,
0xed7aea42,0xf599f3a6,0xe54cf040,0xe0f9deaf,0xecb6e7e7,0xe5f5ea17,0xee10e7c3,0xf63af359,
0xfe89f7f6,0x148c0a53,0x1a41186a,0x2c2d2154,0x38a936a7,0x33ed3632,0x336e32b6,0x2ff93241,
0x2edb2e8b,0x23e82b86,0x1a3c1c6d,0x17291a05,0x160116dc,0x09740fa9,0x06e20786,0x02880483,
0xf55bfe6f,0xeba2eee6,0xe319e652,0xea4be594,0xeaddecee,0xe57ce69b,0xeebae936,0xedfdef25,
0xf210f135,0xebc6eee6,0xedbcebea,0xed54ef0c,0xe914ea17,0xecadeb98,0xe9c9ea43,0xf35bed37,
0xef81f5ba,0xde7fe4e1,0xe796e0ab,0xe896eb5a,0xe723e4eb,0xf231ecff,0xf55ff41d,0x0882fcdb,
0x159211f6,0x1eb41783,0x33cc2aac,0x34853607,0x31ab31f7,0x307c3208,0x2d822d83,0x2a032e12,
0x1b92220e,0x176919d5,0x164015aa,0x0dac146b,0x06d208ad,0x03d4050c,0xfd15025e,0xefddf46d,
0xe50ceb1c,0xe4a7e276,0xec08e9ea,0xe604e9be,0xe97be4a1,0xed0bee15,0xf1c0ee4e,0xeedcf1df,
0xecceec0f,0xef95ee3b,0xea50ee20,0xed79ea5a,0xeadcece9,0xee0bea73,0xf6b7f4fe,0xe633f0bd,
0xe270dff0,0xebd2e8f4,0xe604e8f8,0xee30e80f,0xf3b5f2e5,0xfd76f529,0x11c4086e,0x166e14e8,
0x2a711f07,0x35c2333a,0x324e348a,0x32e73268,0x2db1301f,0x2f442e86,0x226d2a3d,0x1a5c1d86,
0x168b174b,0x144d179d,0x0a2a0e14,0x056c0721,0x03810551,0xf63cfd1f,0xebf9f1f1,0xe2ffe605,
0xeae7e5d4,0xea9fec69,0xe5d4e5f5,0xeda2eb42,0xefa6ed15,0xf2c6f2f9,0xeda0ef81,0xef68ee23,
0xeee0f148,0xec94eb39,0xede7eed2,0xeb17eba0,0xf656efc9,0xf21af82b,0xe179e74f,0xe9ede449,
0xe98aec27,0xe8f3e698,0xf30aef1a,0xf519f2b8,0x0811fcf8,0x12cc111c,0x1e22158d,0x31c52966,
0x336734aa,0x32733198,0x2ef23205,0x2eae2c5e,0x289c2eae,0x1d7d2230,0x15a11906,0x16651621,
0x0d4b125a,0x0522094f,0x04de0449,0xfb9b018a,0xf148f5f8,0xe42eeb2b,0xe470e183,0xeb26e8f8,
0xe3aee828,0xe9a7e55b,0xeb1aeaf4,0xf1e2ee88,0xee31f113,0xecc0ecd0,0xf089ef03,0xeae7ed3a,
0xee8eec74,0xea73ed27,0xef88ea84,0xf835f635,0xe719f201,0xe4ffe236,0xebcee9dd,0xe64ce93c,
0xef9fe97b,0xf24af248,0xfca8f47e,0x0ff3082c,0x14f4119b,0x28c61deb,0x3441315c,0x32503323,
0x32a83366,0x2d2e2e69,0x2ef2302f,0x23d128fc,0x18fd1edf,0x17781697,0x12da16c1,0x09df0ef7,
0x06260557,0x021b05c4,0xf792fccb,0xec18f354,0xe27fe515,0xea3ce4d3,0xe78debce,0xe69ee489,
0xea8be9f7,0xef9ceb44,0xf170f231,0xed26ef33,0xf07bedb4,0xedcdf0c8,0xeddbebc6,0xed96efa7,
0xeb1beadd,0xf73af04c,0xf27cf96d,0xe3d1e800,0xea7be64d,0xe924ec77,0xeacee6c4,0xf273efcf,
0xf408f1b3,0x07ebfcbd,0x10490ec6,0x1cf71484,0x307d282a,0x32b13366,0x34483282,0x2dc0322c,
0x30ca2dda,0x29352e52,0x1efe2528,0x175018ca,0x160917da,0x0fa11358,0x05be091d,0x059c06b7,
0xfca00204,0xf3edf8b8,0xe593ec3b,0xe4e0e1e7,0xeac5ea9f,0xe495e682,0xe925e6d4,0xeb00e914,
0xf163ef33,0xee9bf18d,0xee13eca3,0xf040f04d,0xebd2ed40,0xef72ee46,0xea50ece8,0xefecea68,
0xf937f76c,0xe814f1d8,0xe61be453,0xeb94ea81,0xe6c2e7e9,0xef75ea4e,0xeffdf146,0xfbe8f2c6,
0x0c85068e,0x12ac0e9a,0x26781b6c,0x31962ecc,0x32683107,0x30a533cb,0x2e1d2ca2,0x2d2e301f,
0x25852982,0x18891e3c,0x170c17d7,0x13fa159c,0x08cc0f29,0x06fa05fe,0x018c05cc,0xf9d3fd5d,
0xed62f47b,0xe1ede5cb,0xeb27e609,0xe672ea62,0xe7c3e584,0xe913e8cd,0xef41ebc2,0xf24ef257,
0xedbeeef9,0xf18aef7c,0xee11f0ef,0xf008ed69,0xee27f08b,0xeb30eb33,0xf929f156,0xf2e9fa36,
0xe5d0ea07,0xebcbe80e,0xe8a7ebff,0xeb87e7b2,0xf181f064,0xf328ef92,0x0615fc3d,0x0dca0bcd,
0x1aa5121b,0x2dec25ee,0x3089303d,0x33a8331c,0x2cc72f81,0x2f5c2e96,0x2a532cba,0x1d9925a2,
0x17c51939,0x15db163e,0x0ed413d4,0x05fe083e,0x04f50743,0xfdcd012e,0xf520f9e4,0xe53cedbc,
0xe660e1e8,0xe93feaca,0xe634e5ce,0xe7f3e757,0xeb07e8cd,0xf273eef9,0xeeaaf1ed,0xefeeedfb,
0xf074f1a3,0xee0bedef,0xf0d2f06d,0xeadbee5a,0xf20eead4,0xfa11f991,0xea68f379,0xe900e6cb,
0xebb3ebf6,0xe7e9e865,0xf0abebe7,0xeed1f079,0xfb90f2e4,0x0a3c0508,0x10940c8a,0x24dc1967,
0x2e442c4a,0x334d3005,0x2e5d3264,0x2e4c2ccb,0x2c882e08,0x24b32abf,0x197d1d81,0x15c716de,
0x138d158f,0x07780e30,0x06c60669,0x011b0422,0xfa28fd83,0xeda6f5b2,0xe1f7e4bf,0xea45e6ba,
0xe5e2e7d0,0xe6b1e64c,0xe81ae7a3,0xeee1ea7b,0xf18cf271,0xee59ee91,0xf1d5f0bf,0xee70f051,
0xf114eecd,0xeef9f19a,0xeb89ea81,0xfa06f31a,0xf41afaff,0xe871eb8f,0xece4ea87,0xe8f4ec34,
0xed8de8e9,0xf09ff16e,0xf393ef40,0x04e3fbf2,0x0c4b0a0a,0x198e1045,0x2b58250b,0x31342d97,
0x323a3428,0x2e312ee1,0x2e172e80,0x2b682e0d,0x1eea2544,0x176d1a44,0x166c162d,0x0dfa144e,
0x07800850,0x049d06e5,0xfdf70185,0xf6c0fb69,0xe4daee30,0xe7a5e2d6,0xe775e980,0xe62fe64b,
0xe742e6b2,0xea1ce772,0xf244eec8,0xee32f11c,0xf121eedf,0xf01ff188,0xeefcee9d,0xf244f15c,
0xe9f0ee59,0xf305eba4,0xfad3fa26,0xebcef401,0xeaf4e94e,0xeb9aece4,0xe946e84f,0xf0efedc6,
0xee83ef72,0xfb0df304,0x08a303b0,0x0e870a91,0x236e18c5,0x2c1c28be,0x331d30f8,0x2ea83092,
0x2cf42dc0,0x2dbc2dd1,0x25192ab0,0x1a311ed4,0x15da168e,0x13671682,0x086e0d3d,0x067b072f,
0x00fd045c,0xfbe3fdfd,0xede8f75f,0xe3c8e4a8,0xe8a2e778,0xe61ce710,0xe680e5ed,0xe6c2e691,
0xee9ce9a2,0xf063f208,0xef4eee1a,0xf139f15e,0xeeb4f03c,0xf24eeefc,0xee16f289,0xebd0e9e4,
0xfa7af35d,0xf422fb0e,0xea4ceca0,0xed61ebf1,0xe865eb34,0xee7ae9ff,0xef0bf0d9,0xf2f7ee9c,
0x0340fabc,0x094307d8,0x18cf0e0a,0x26fa2220,0x31712bd3,0x3083323e,0x2d6d2f81,0x2e572d08,
0x2b242e0f,0x200a25a6,0x16a11ab9,0x171116f9,0x0dec136b,0x07e2093f,0x04ce0724,0xfed60184,
0xf8abfdad,0xe613ee40,0xe7f3e558,0xe79be8f4,0xe6dae6ce,0xe6dde725,0xea17e700,0xf24fef66,
0xeed8f082,0xf1d5f098,0xf103f1e6,0xf02aeee8,0xf33cf380,0xea42ee6d,0xf402ec55,0xfb42fb1c,
0xed69f4a2,0xed19eb85,0xead9edab,0xeab6e88e,0xf08aeed2,0xee5aee85,0xfa20f262,0x06460290,
0x0d580778,0x1fd317ff,0x2b5824d0,0x30b2304c,0x2eaa3033,0x2c4b2c59,0x2d7c2db8,0x25862a2e,
0x19aa1ff8,0x16f0162d,0x12b6161f,0x08e80d69,0x0682078c,0x007f0444,0xfe46feea,0xede5f836,
0xe57fe698,0xe837e787,0xe699e6fb,0xe6d4e688,0xe646e611,0xef3be9d2,0xefd4f19f,0xf0bfef55,
0xf24cf1f6,0xef0ff0e1,0xf45ef0f6,0xeeacf39c,0xeccaea6e,0xfb76f4a5,0xf517fbbc,0xed02ee63,
0xee1aee6d,0xe928eadb,0xef77eba5,0xee97f08e,0xf221ee6c,0x0225fa50,0x067304ee,0x17550d77,
0x24021dbc,0x2f412b0d,0x30293067,0x2bf32e70,0x2dd32c1b,0x2a1f2d0d,0x20192640,0x16ba196f,
0x15fd171f,0x0d88128a,0x07a20935,0x03dd06cd,0xfffe0034,0xf841ff12,0xe796ee75,0xe7b3e630,
0xe718e800,0xe6f2e6cb,0xe5b7e6e3,0xea0fe5f1,0xf0f5ef54,0xefc5f00b,0xf293f118,0xf0e7f2b2,
0xf203ef78,0xf43cf526,0xeab4eee4,0xf542ed60,0xfc2afc00,0xef7bf58c,0xefb0eea2,0xeaf9ee7b,
0xec9ae9f3,0xf0bdeff4,0xee58eed2,0xfab7f244,0x037a01ac,0x0ddd05f7,0x1c4615e1,0x2a412382,
0x301a2ea1,0x2e303031,0x2c692b9c,0x2c8a2dcf,0x26cf2aab,0x199c1ffe,0x1751171b,0x126615a0,
0x090c0d81,0x06bf07e6,0x001902ed,0xff2400bf,0xee9df81c,0xe669e82d,0xe761e752,0xe66ee68b,
0xe669e6b3,0xe541e483,0xee3de9d3,0xef75effd,0xf0e0ef45,0xf22cf286,0xef40f01f,0xf556f214,
0xee63f415,0xed30ea67,0xfbcbf523,0xf537fbbc,0xef8aeff5,0xee19f01c,0xea2aea70,0xefd6ecbd,
0xee45f080,0xf1f1ed9b,0x002afab4,0x05c3019d,0x13fc0d07,0x22331acd,0x2d8a290e,0x2fd82f8e,
0x2b502d56,0x2d0f2c7c,0x2b252c50,0x201926f5,0x17a919bc,0x158f1759,0x0d6512a4,0x08bb0971,
0x027c069d,0x01b500ce,0xf889ffcd,0xe96fefa8,0xe7e5e74d,0xe709e7a6,0xe7d1e70b,0xe485e6a4,
0xea47e611,0xf04dee68,0xefdeeffb,0xf380f1ee,0xf0b1f2be,0xf379f02d,0xf50df6ae,0xeb2fef25,
0xf618ee20,0xfc49fcb3,0xf174f5f1,0xf17df168,0xeb29ee8e,0xed95eb30,0xf102f0a8,0xed67ee67,
0xfb10f2d9,0x010cfec3,0x0c5205cf,0x19c112d4,0x280d2145,0x2f652cc7,0x2ca82f49,0x2c1a2b7f,
0x2c212c56,0x26e82b39,0x19ee1fd1,0x170217d2,0x12521579,0x09db0cc9,0x05c908d8,0x00e901d7,
0xff9401fe,0xf007f876,0xe778e9f2,0xe736e7aa,0xe73ae663,0xe5c3e7c7,0xe5d3e3fc,0xed97e9a7,
0xef45efb4,0xf203ef9d,0xf264f362,0xf023f038,0xf6eef3c8,0xeefdf4ff,0xee15eb05,0xfc99f63d,
0xf5d2fbe3,0xf283f237,0xee6bf1d6,0xeb61eb30,0xf0e3edae,0xed61f10a,0xf371ed02,0xfd3efa20,
0x053b0050,0x116d0b38,0x1ffd1883,0x2c1626a4,0x2e4f2ede,0x2b332c46,0x2bac2b87,0x2b3e2bf0,
0x1fc026a4,0x17b71a1d,0x157f16ef,0x0cba11cf,0x08cc0a3f,0x01950553,0x02200126,0xf88dff9e,
0xea4cf079,0xe7d1e7bd,0xe66fe6f7,0xe7c6e787,0xe3fce58b,0xe98ee5d7,0xef98ed88,0xefbcef36,
0xf389f237,0xf03ef270,0xf411f056,0xf529f727,0xeb1cef1b,0xf665ee3f,0xfbecfcb4,0xf27df5ed,
0xf1fcf2c0,0xeb4bee7f,0xedbeeb76,0xf10ef0fe,0xed0bed5c,0xfa1ef376,0x004ffd3e,0x0b16053a,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_steelstrgtr_acgtrb3[3200] = {
0x00000000,0x008b009d,0x00f100b6,0x012a0118,0x01680141,0x0196018f,0x01c101a9,0x01fb01e2,
0x01e301e2,0x01f501f5,0x01dc01e5,0x01d201e8,0x01ae01c1,0x0176018f,0x01620165,0x01030132,
0x00bf00d3,0x007c009e,0x002d0045,0x00010006,0xffc3ffcd,0xff59ff90,0xff2cff3e,0xfefaff0c,
0xfed6fee8,0xfe98feb5,0xfeacfe9c,0xfe96fe93,0xfe5efe75,0xfe59fe57,0xfe3cfe55,0xfe3bfe46,
0xfe48fe53,0xfe44fe48,0xfe58fe6f,0xfd0efdef,0xf214fbf0,0x07d20672,0x089cff97,0xfe6702f8,
0xf96d009e,0xffb704b0,0xf481ec2e,0xefb2ed82,0xe875f10f,0xe860e602,0xf802fb98,0xf71009bd,
0xff860073,0x14ef0cc6,0x1e1e01f5,0x0d16066e,0x0e73fdb2,0x100816b7,0x20362050,0x1a052140,
0x1cf42707,0x281624c9,0x26ab207a,0x22990d9b,0x19b2073a,0x27f62083,0x188923a8,0x0e0e1a4b,
0xfeb41dae,0xf96f016e,0x01def6da,0xe261d5a3,0xe060de66,0xd6bbd8bd,0xfbc5ea62,0xe9a50241,
0xf1f0ea5d,0xe67b0323,0xcf4abfd7,0xe015e422,0xaee9c223,0xc05baad7,0x8648ada0,0xba51993c,
0xb48eda34,0x9abaa7dd,0xb55db597,0xaae2ac1e,0xd60fbc51,0xaa6cbd08,0xc14bb546,0xcf7ad063,
0xf010d7aa,0xff36f85b,0x08caf799,0x212511d9,0x1d881f26,0x3bc42f7a,0x43ed39a5,0x6a644f1e,
0x5fcc680f,0x742765f6,0x657069ba,0x6a8b4c90,0x67f67af2,0x52ca624b,0x59096ba1,0x525f6727,
0x5bdb662b,0x56b25a45,0x507b52af,0x4ab94c94,0x458a4717,0x40604239,0x13d63dbe,0x0e6728ee,
0xddc1043e,0x18920255,0x11ad21e5,0xf490f23e,0xfc55eb60,0xde1ad64c,0xeea6e627,0xa9e0cba8,
0xb045b7bc,0xb756c43a,0xc84db955,0xc682bd5c,0xbd22b370,0xce02bad7,0xcc75bba3,0xc777c2cd,
0xca2dd344,0xdf4aef41,0xeb56e99c,0xfa97e668,0xe29feb6f,0xf129eba8,0xf038f611,0xea5beeb3,
0xf2fff605,0xe9a3f04d,0x1a63ffe7,0x13b90c9d,0x33182945,0x154f126a,0x1198f7d8,0x09b41894,
0xe1a3eee5,0xd3a0edcc,0xbb0dc2ae,0xfa36dacc,0xf4aa03c3,0xdf89db8c,0xe849ef4e,0xea80dff4,
0xf57b02d5,0xcaa4ea36,0xe4f4d705,0xeaf6e6f5,0xedadeb11,0xf54f0191,0xf813ec5c,0x09d0f642,
0xfe660475,0x031e0b2e,0x1dcb129b,0x247f1510,0x275c16a3,0x255d2be1,0x1fea23e7,0x20ad2482,
0x203c271f,0x18001f3a,0x17601c99,0x0f80fbd7,0x215117f4,0x37cf11ea,0x31102cc4,0x0dcc20d3,
0x219f14da,0x0751242e,0xf17cfd9a,0xccffe720,0xc0b0bb3d,0xeec0ce0a,0xd70eef2a,0xd2b2d18f,
0xcd82dee1,0xd69adea1,0xe05ef74e,0xbe72c90b,0xce00bfba,0xd6d5dc09,0xf4acd617,0xf65cf150,
0xef60ecdb,0x03370675,0x06900b51,0x1b7bfb9a,0x2a8e1626,0x291e1f1a,0x3f763813,0x3b704227,
0x40a24896,0x3f444431,0x46805060,0x46304943,0x32c644c4,0x3fbf2d2b,0x463330e1,0x52514bf4,
0x4c4d59a0,0x32d33fc4,0x4b3c4413,0x32b445e9,0x20772be8,0xfca9021d,0xe62edb3d,0x129dfbce,
0xeaef0167,0xe475eaa3,0xdbe6ec57,0xec94d8ee,0xded1f55a,0xb587cdc1,0xde76c723,0xce24cc9a,
0xe813d3df,0xd164eb8c,0xdbf0d9ef,0xf03ce402,0xdad2db5c,0xed96dfbc,0xf39ff23d,0xfb9af2bd,
0x000c0882,0x051e06f5,0xffff102a,0x0e480756,0x0ae11519,0x09b4117c,0xfd0bfa4a,0xef1cf466,
0x04d0fb5c,0x15960af5,0x101e15e2,0x0260f778,0x150c0dc2,0x0c8c0756,0xefc5f7c8,0xc85bdbae,
0xc580b089,0xe5d7e545,0xcec9d8c6,0xd51fc319,0xbda0bf3e,0xd48ac892,0xca78e419,0xb502b2db,
0xcef2d157,0xc01fd944,0xeefef34f,0xefbbeba7,0xff56df9c,0x07f7fcb9,0xfa23f3dc,0x127e0621,
0x13061f0e,0x2bf025db,0x2d623ad8,0x3f933ef6,0x39bd3cb6,0x476b3f8a,0x527d3985,0x335c3982,
0x2bf432f3,0x190122bd,0x28422d5c,0x3c1c3b43,0x258039fb,0x32e61d5d,0x360228db,0x30842a93,
0x148e18e7,0xdbbafc0f,0xed0edd0d,0xfb10fec3,0xdf67ea5b,0xd175e0bf,0xc758cf89,0xe875cbda,
0xc5d7dbe6,0xb525b75b,0xc5c4da1b,0xcb6cc55e,0xe495dbda,0xd743de32,0xec6dd42c,0xeafded4c,
0xe251d9cc,0x050cf0b1,0x0256fca4,0x1e0612fa,0x207a22bb,0x31f131dd,0x39bf2fba,0x33e8322a,
0x3fc74cac,0x2f30306e,0x250b326a,0x1a1a1c95,0x2940257a,0x3d304268,0x27343088,0x325b331c,
0x3ace397a,0x36d740e2,0x22483376,0xf8b7fdd5,0x0bfaec36,0x07a50a15,0xf6edfcff,0xecdde6bd,
0xd61bd9a0,0xe919ecde,0xc573f3ee,0xd84fc626,0xdcc2d5d7,0xe026cd93,0xf3aae4bb,0xd944de02,
0xe86cdcdd,0xd9ffee14,0xd7b2cd00,0xe90aea7b,0xe97ce90f,0x01380045,0x0fddfde1,0x0e640097,
0x03901472,0x121d0362,0x03b91db2,0xf9b5005a,0xe8c3fdc6,0xdea1e8c3,0xfec2e9bf,0xfed1095b,
0xf94bf655,0xfcce009e,0x09d20d13,0x17ae0dcb,0xf62eff27,0xccadd36d,0xe5e8d69e,0xf04fdf66,
0xda10d214,0xc45ad03c,0xbc30c8a2,0xe012dcb6,0xc081cf36,0xcfdcc254,0xd931da80,0xea5ed49e,
0xfa26f86c,0xea5af07d,0x07e6fb2d,0xf19f083e,0x00fff564,0x0f2b13f2,0x24b40fd7,0x35882494,
0x33353c57,0x4e413d2a,0x37043fcd,0x4e083e1c,0x3896486b,0x2ebe32f7,0x1f2b2a32,0x06ec0f09,
0x2ead1ff4,0x1f942f35,0x1d862743,0x2bbb26ca,0x2eef24ea,0x32093330,0x044f23ee,0xf2f7ed4a,
0xfae0eb6c,0xf0aefbbf,0xdb5ef286,0xccaddfe6,0xd37dc695,0xdc39dc36,0xbf7bcc11,0xccaec108,
0xc9b9d582,0xe0ddd177,0xebc0ec47,0xdda8d9f3,0xf679ef66,0xdbf9ed2f,0xf9e4e0bc,0x01d8f2c5,
0x057c0137,0x2b4b1cec,0x2a061ecc,0x40b7385d,0x2f9d2c81,0x462937b8,0x365b3785,0x270f222a,
0x0e3929b5,0x002c04b5,0x1eae2d5d,0x1dc22b19,0x22651ca4,0x241a2992,0x2e902927,0x3d1836a6,
0x0718128d,0xee53f479,0xf2aefda8,0xf03202fe,0xe510f1aa,0xcda0d7f6,0xdc4ccdc1,0xe059d758,
0xc228c668,0xd1a2c492,0xc9cccdde,0xe0e1d0b5,0xd9b4ec57,0xd7ddd65f,0xecc1eb18,0xd65aceb9,
0xdea4d45e,0xe9ffe996,0xfb29e153,0x0c5b0888,0x16ff046f,0x1aeb2491,0x1866134e,0x28ff1de4,
0x100320b1,0x114c0778,0xe2490afe,0xf433e62f,0x0cd503e9,0xfb2d0aeb,0x065b0c27,0x10171275,
0x284907c0,0x1e0f2895,0xed3e0732,0xe6eee8c6,0xf3e3e77c,0xeed5ea4c,0xda45e9ee,0xcbffcccf,
0xd5c1d3b3,0xd849e14b,0xcb5fcb1b,0xdb41ce0f,0xd353d54a,0xf1ace5e0,0xe58cf7f7,0xf719e6ae,
0xef4f01dd,0xe3bff60a,0xfcadf02f,0xf7700424,0x1c3e02e9,0x23fc1ec3,0x3f4521e2,0x3b023231,
0x33b82fab,0x47123dae,0x1f663bd2,0x2ecc33fc,0x063814ba,0x1182fefc,0x23fb21e8,0x1c121ba3,
0x2f3c152e,0x1d951e88,0x34532c81,0x269a474d,0xfea91651,0xfb94fa23,0xfcc3fda6,0x05f9fa31,
0xe22ff45c,0xdb9ddc9e,0xe8c1e212,0xdd39e7a3,0xcfccdab2,0xd91be1f0,0xddb8db8f,0xfd7aebc4,
0xe265eec9,0xf315f87a,0xf7e8fb18,0xe402ea8b,0xfc56f327,0xf3e9f642,0x15d804a7,0x20c90fb0,
0x2ed61f7b,0x312d29fc,0x27dd2124,0x38183a69,0x24921f75,0x194f247e,0xee3a093c,0x0612f78c,
0x19db1054,0x075101f0,0x0f921440,0x07e31093,0x2e141a35,0x148c2b4f,0xe983fddf,0xec2eebc5,
0xe3cbe7dd,0xee67f6f0,0xd12ae0b8,0xd2e8c59e,0xd9a0d156,0xcbedd382,0xcb72c77f,0xd0b6c852,
0xd3fcc2e3,0xde24ec53,0xdec9dfdc,0xe722e8ed,0xe5eff5e1,0xe217dd1e,0xf0a6f00e,0xfb83e4ee,
0x0ab4fb6a,0x1a960fb5,0x23c620f5,0x1ff8327d,0x31471dca,0x2ad53353,0x1e7526c1,0x16072734,
0xf79bfb11,0x0e17edf1,0x07571645,0x06680902,0x0f2b1448,0x0b5f05d8,0x2f191e48,0x120826c9,
0xf0def510,0xe9daf17c,0xf04de53c,0xf4c7f5ec,0xd098dd6b,0xd764cf34,0xdf6bd7de,0xd98bce6c,
0xd0d0c8e4,0xc321d4cc,0xe24cd559,0xe060ed04,0xe36beddb,0xf4a0f197,0xe60dfbcd,0xf5e0e962,
0xf545f4ca,0x03a0fa5d,0x12e30a40,0x20ac2668,0x3ba93160,0x2e413533,0x3b2e3a97,0x3c4b4511,
0x407c326f,0x2e012beb,0x028b0c9e,0x21d01247,0x1a932540,0x220819db,0x1f2e2480,0x223d167c,
0x4251352d,0x17203980,0x08bb09e3,0xfbddfd93,0x02dcf5be,0xfcce0d49,0xdf62ec6f,0xee79db91,
0xe6ade2dd,0xda6ce09e,0xdc94decd,0xd149ce13,0xe48be42c,0xe666ed4e,0xe6dfec19,0xf936f50d,
0xe5d8eb1c,0xeb90ef7c,0xedf4ec86,0xf42ff92a,0x137cff9a,0x1e5d0b43,0x2264285a,0x23032604,
0x306825b4,0x2be5282b,0x2071246b,0x0b322344,0xf227f1fe,0x1028fce4,0x05c705d5,0x10ac0366,
0x05800b21,0x072a04e6,0x28e43023,0xff701e97,0xf0f5fc65,0xde89efd9,0xf968e769,0xf5c0f1c1,
0xd627c944,0xd97ed1e7,0xd14cdb55,0xd5e6cf1b,0xc31dd6d8,0xcd6ac567,0xde7ada45,0xe49ee0d2,
0xf0f4d8eb,0xef3cee0f,0xebd9e210,0xdfefeda0,0xf151efb5,0xf73af04b,0x01ae0858,0x1e2f1d9e,
0x2905245d,0x2fd61f06,0x2bc025c9,0x255f3251,0x26232971,0x05902071,0xf621f3d0,0x0aea0524,
0x05c70638,0x0cad0c37,0x02fb118a,0x1b6d0226,0x2a933066,0x00d31d30,0xf5e504de,0xeb04ecd3,
0x035fea40,0xebdffb96,0xd97ad6f4,0xebacd8f2,0xd46bda63,0xe3f5df03,0xccb8d71b,0xdca4cf93,
0xef68e122,0xe4d1e9d3,0xfdd4f055,0xedcafafd,0xfa75f961,0xf94cef01,0xf75ffbcd,0x03960a22,
0x1886111f,0x322a2ab8,0x30d83138,0x34553ee0,0x3d193c3c,0x3a643d1c,0x3d25386c,0x15df24e0,
0x0f16003e,0x135f136a,0x1104174c,0x1c731a29,0x04e31712,0x241a18e9,0x2e8d3eb4,0x15751ae6,
0x038dffd6,0xeb79eda8,0x0383fbc1,0xec4dfce0,0xd8bcd54f,0xe273eabb,0xd6dfd5f6,0xe0b8e57f,
0xcfd6cda8,0xd9b5caa6,0xe827e419,0xdea5dbca,0xf30ff49d,0xeeaee6bf,0xe5e0f0b8,0xe7bbf1aa,
0xf6ffecd3,0xfe54f469,0x1217fd78,0x1c6923da,0x27b12665,0x2ccf2d74,0x31ad2d4d,0x35e629d1,
0x323d2b17,0x03cf11a8,0x01defdfd,0x0a8a04d2,0x08a504d9,0x0743170e,0xf83e0b50,0x23fd1269,
0x2523283e,0x0470110e,0xeccbff0b,0xe6ece2b5,0xf7eff133,0xd2f7f71c,0xd564ceb8,0xd1a2e30a,
0xd993c915,0xd76cd68f,0xc270c71d,0xd6d7c415,0xd89fe1c7,0xeaf6ca7c,0xe64ee5de,0xe1d0e8db,
0xe8abe7f7,0xe656e20d,0xf3a4e585,0xed7df462,0x11da0317,0x1cb01b77,0x27aa216e,0x2fd72b07,
0x2e6c27c6,0x32c92c16,0x2518340b,0x08190f1e,0x03d5fcbd,0x01b10b1c,0x0e970ed5,0x0eaf17f1,
0x096e0109,0x269c1b4e,0x21bd36e5,0x102c1c7d,0xf3d00392,0xeebaf20b,0x0a530273,0xdd9ff6d9,
0xeec2df85,0xde02e612,0xe64ede54,0xe396e950,0xcc5bd75a,0xf4b4d91d,0xe1f3e46d,0xf39fe9d5,
0xfc90f5f0,0xfaefef0a,0xf8dcf501,0xeb3ef5ef,0xfa5405d2,0xfcdd0339,0x1e7a17af,0x2d8b27cc,
0x39d4269c,0x38de353b,0x3370323b,0x43133677,0x287932f7,0x03471883,0x029b0f28,0x08a50bc4,
0x1eaa0b38,0x09ee0e6e,0x0aeb02b7,0x2e7018a0,0x235725da,0x046b1b98,0xeb430165,0xec0ceb60,
0x01930429,0xdc86e410,0xe361e1c5,0xd764dff9,0xdef8d961,0xdfa8e385,0xca10c025,0xdccfe1d6,
0xdaabdf0c,0xeef7df16,0xefa2ed6e,0xecb2e9ee,0xec2ef618,0xeddce90f,0xf25dfb44,0xfc72f851,
0x1d360c82,0x204021bc,0x2fc32636,0x32ae31cf,0x33ff2134,0x38883401,0x1c602fbe,0x08b60c78,
0x079bfe4e,0x0463f89f,0x0f1f119d,0x00810923,0x0a4afaea,0x1f3c176f,0x1c71221b,0xff720f2b,
0xe1bbf58b,0xf028dec9,0xe8abfe94,0xd217e0b7,0xd4b2df0d,0xce2dda73,0xdf0bcb46,0xc265dffb,
0xcd48bc75,0xde29cd8e,0xd69acbc6,0xe412d7f1,0xdd57ed84,0xe7c0e87d,0xe11ff187,0xeeaae84b,
0xf513efc9,0xfcdff0ea,0x1ce80d7e,0x22d61dd4,0x385c2187,0x276b3440,0x2ea42f54,0x3c113fa6,
0x22dd2c5a,0x10c50dd3,0x03cf09c9,0x140900d8,0x1ac91604,0x03c30e10,0x13a10e48,0x2919234d,
0x260e30a2,0x11231b46,0xea28fcb1,0x01f4f993,0xf42908bb,0xe89cf1dd,0xefd6e6bf,0xd33ce64e,
0xf310ea9c,0xd773e00e,0xe068ccb3,0xe784df64,0xe006de65,0xf4d1eb71,0xe9fef4da,0xf5e0f78e,
0xf15bf3f2,0xf5dbf271,0xf717fd79,0x072bfa7b,0x279a1230,0x1e7b2077,0x32cf37d8,0x297a397a,
0x3b2f2c3d,0x3c173e84,0x182a2eb2,0x12c71656,0x03790138,0x12f5fef4,0x115e1626,0x037a028c,
0x11b206f5,0x299119d4,0x203c22d8,0x02ae1a63,0xe878ef17,0xfd0ef84b,0xf39bf65b,0xd9c2e786,
0xe235edee,0xdd09cf37,0xe975e084,0xccafd282,0xd291cc79,0xdb2edcf1,0xd8c6d526,0xeae1e8cb,
0xeb93e76e,0xecb8ed53,0xe62ef10e,0xef5df102,0xf524f2b7,0xfe23f284,0x13f719cc,0x1d041c60,
0x35c72bf0,0x24d72831,0x323d2917,0x33303cb0,0x17211cd4,0x07a50fd0,0xf613fcd4,0x10e1fba9,
0x08d00abf,0x041df4ef,0x1069f913,0x1a2916c6,0x1b501fef,0xf1e8155f,0xece0e6a9,0xee3bf44a,
0xe3f2fc9b,0xe728dcfb,0xda7fde48,0xdeeeca76,0xdc1ddfc8,0xc758d1d1,0xd085cd21,0xd13adec6,
0xdc5dd5f0,0xe821e5cd,0xea14eb8c,0xf357ebd7,0xf48de7ea,0xf3cbeaf0,0xec51fc3d,0x05b1ff3e,
0x1c83199d,0x25b41cbc,0x331837f1,0x27e231ff,0x43af2cac,0x347d3f3b,0x1d4424e5,0x0f4518cf,
0xfd69ff02,0x1ad70a9d,0x0b7810d1,0x02f70429,0x18c30cd4,0x22de1d64,0x2d302bc0,0xf4d31213,
0xf1f5fe23,0x036cfd62,0xef0af7fa,0xefeceed3,0xdc08e629,0xe75ae149,0xe51ae8e0,0xd3cdd950,
0xe5dcd4a6,0xdfc8dc88,0xe3ede254,0xf43af030,0xf879ee91,0xf887ef3c,0xee40f85b,0xfa26fad6,
0xfaa1f8b9,0x115bfd8e,0x19fc1d77,0x28d325fe,0x38313a64,0x23ee2e88,0x3e023d52,0x2e2a43c6,
0x2116259e,0x0e2b17ae,0x056cf4af,0x144f0bca,0x05a31081,0x01e2fe0e,0x14720c00,0x1eea133f,
0x184235ab,0xf9840830,0xf5b0ec23,0xfa51f868,0xeccae970,0xe4c5e9e1,0xd6e6d740,0xdbe3db3d,
0xd9dae0b8,0xcc20c9b6,0xd358d236,0xd823d513,0xe47cd142,0xec0adf23,0xe3b5e998,0xebe2ef6c,
0xed69e9b8,0xf1f6ed14,0xebe6ef95,0x04f2fe26,0x149b12bf,0x23db1a99,0x283338b3,0x2218247e,
0x3ab1364b,0x28033796,0x22741c43,0x00460f00,0x005af52e,0x12a00866,0x007208bc,0x0313f6c9,
0x00f5112d,0x29dc17bf,0x1d0c2576,0xf5db0171,0xfb41ee7e,0xf062facd,0xf1d1eea7,0xdec2ecbb,
0xdb8bdba3,0xe177dc1e,0xcff3e5e2,0xd00cd475,0xdcc3d0bf,0xdc8bd221,0xdf5ad9dd,0xebfbec81,
0xf0ebe7b1,0xf1c6ebe2,0xee61ef0d,0xf0b3f77a,0xf815f0ef,0x0c12fdb9,0x128b18c2,0x2f7a2282,
0x2b4637dc,0x2d472501,0x42a33a35,0x28b134f0,0x21d52b77,0x02f211a4,0x0741fbe1,0x18c70e67,
0xf92d0d35,0x0ddd082a,0x0f100579,0x2c3f2178,0x1d312deb,0xf546067d,0x0037ff9a,0xf185fdec,
0xf91ffbea,0xe812ecc5,0xddcfe35b,0xea08eb47,0xdf95e343,0xdbbad52d,0xd974dd91,0xdcf5e488,
0xf065e130,0xf839e9e2,0xf8dfecdf,0xf745f382,0xfe19f330,0xf713f55b,0xf73ff9d6,0x0d0d0b38,
0x14ed19ae,0x33f72aa6,0x2d2032e8,0x3374232c,0x3d3d3e61,0x30552ef9,0x1f7e2709,0xfeb10c37,
0xfa0dffcf,0x0cf11be5,0x0012fe01,0x01fb033a,0x0df7ffd9,0x27d7195e,0x12652716,0xf397f6ed,
0xf774fac4,0xed1fed44,0xe6f6f6a9,0xd725ebc2,0xdea5d586,0xe3ccdb5a,0xd0b5d5ca,0xcfc8d1f3,
0xd7eacf9c,0xd930cf9d,0xe156d9f3,0xe8cce5be,0xeff4e81c,0xefe5e57b,0xf04af0b0,0xedb7efcc,
0xf55def93,0x06cd0260,0x16fe0bf6,0x2d4b24e5,0x1e1c2f9b,0x32332721,0x36913883,0x2fbe2d96,
0x168a2597,0xf957108a,0x0dc5f5c0,0x061b11fd,0x0319fff6,0xff4eff3d,0x0b0f039a,0x2cfc1c82,
0x0b642467,0xfed5f574,0xf273fca6,0xf047f42d,0xf4a2f520,0xdb8be2f4,0xdb03df49,0xd9d7ee1a,
0xd83edd82,0xd9abd1f2,0xd87bd4a0,0xddedd893,0xeab4de72,0xf2c6e52d,0xec2cf084,0xf2d9f259,
0xf42cf95c,0xf038f5dd,0xff50f70a,0x0b3203a8,0x1d9c12f5,0x36112ca0,0x2ac928cb,0x3ac02d35,
0x36393d43,0x2e273f16,0x26782983,0xfc9b0ab0,0x15e106e7,0x0cf6104a,0x062808e9,0x074d03c1,
0x12310519,0x366d261a,0x063223b5,0xfeda0948,0xfa6302a5,0xfb09f190,0xf071fe02,0xd821ed89,
0xe708e829,0xe30fe7e4,0xd8a2de67,0xd84fdc82,0xdcb2d80c,0xe510d875,0xe69be0d8,0xf1c9ef9c,
0xed4cf085,0xf5cdf3c4,0xf721f893,0xf3d5eebd,0xfbeaf935,0x0a110226,0x24ba0c95,0x307b26ac,
0x25502457,0x2ea232bd,0x3a933804,0x2a852f83,0x17a32cf5,0xfc11ff56,0x0ac0065f,0x08f50962,
0x0112fe5e,0xff5efdab,0x0d68fa4b,0x25ff2ba8,0x06cf15ad,0xff66fbb6,0xea2afb24,0xef9cf3ef,
0xea94f94c,0xdb98d966,0xe00bdec8,0xd874e245,0xd5f6d6c4,0xd55ad287,0xd305d002,0xdac8da2e,
0xe498da01,0xec88ea11,0xeba4e810,0xf5f8ebc7,0xedb8f469,0xf1aceda4,0xfc12f48d,0x047dfbb1,
0x1eb911e3,0x23052c17,0x2ba82577,0x3374268f,0x326a3a47,0x31d32e0a,0x0bf12a80,0xfff1037a,
0x0c1304fe,0x0967090b,0x0342fd3b,0xf59a0243,0x1eabfd02,0x2bf921fb,0x055f1195,0xfc1107f5,
0xedcdfde7,0xfa7cf3a4,0xe63afa5f,0xdd4de24f,0xe930e458,0xe332de41,0xdc83d673,0xd55edb6e,
0xd9fcd6ac,0xdb29e1e1,0xe919e44e,0xefbbf0f1,0xeb4af084,0xfafdf944,0xf7c1f5e3,0xfbcdee4d,
0xfe30fbde,0x06060389,0x274e1e3b,0x2a10288c,0x2690311a,0x3c163308,0x33fc3a35,0x3a7c3ae0,
0x155323b8,0x0a9305c2,0x126f079b,0x05061038,0x0c680975,0xfe57f7e5,0x1f0b076d,0x21c92ed6,
0x0d4d16a4,0x07cc05b4,0xf269f71b,0xfbf7fc0d,0xe8d4f9f8,0xe38ee120,0xe5c9e7a8,0xdac3e60f,
0xdce2dce2,0xd2d7db3f,0xdbc1d906,0xde2cdbef,0xe691e31a,0xebe1f2ec,0xefc7eafe,0xfa59f396,
0xeeb4f49b,0xf59ff27a,0xfb27fc12,0x0f19f5a6,0x1f0c1936,0x295b2678,0x24452542,0x32333681,
0x35fe2fdd,0x31773997,0x0ea01c17,0xff0f063e,0x0f460992,0x0d7afd1c,0xff3d02e6,0xf388f4ad,
0x1c090a81,0x1d3b22e1,0x06460fa9,0xf9f708bb,0xf1dff2f6,0xfce5f451,0xe335eee9,0xdd74de9e,
0xe345e4a6,0xd680dc75,0xd8cfda9a,0xd1d3d243,0xd4afd4af,0xd78bdb8c,0xe9dbdd83,0xeb89e7ed,
0xece3e54f,0xf48af411,0xeb77f1fe,0xfba2ed0e,0xf003f6b5,0x0cc5fcc7,0x1d5c1500,0x1f7f29bd,
0x2cf12313,0x2d0c3147,0x391e3116,0x28473c99,0x0feb1fea,0x0e6cfdec,0x073d06ae,0x094509c8,
0xfae0091a,0xfe97f0eb,0x1ea50c9a,0x18362699,0x0d5715dc,0x00db066c,0xf952f32e,0xff42fb59,
0xe931f160,0xe720e054,0xe6adeabf,0xdf95de72,0xd93fe10f,0xd3b1ddd2,0xdf14da2c,0xe14bdb21,
0xee46e47b,0xec91f11d,0xf4beee16,0xffd8f7e2,0xee7ff239,0xfcc3fed0,0xf551f91a,0x0a690973,
0x27a51da9,0x244f24cd,0x328b2c38,0x2bbb32c7,0x3f533d86,0x34d537df,0x0d731c82,0x09900f8e,
0x08da0bfa,0x126f0d00,0xf9d30379,0xff67f613,0x229611a6,0x1eb51df7,0x0f5c133f,0xfc4507d8,
0xf935f75a,0xfd1cfdec,0xe4b4f1ac,0xec1ee0a7,0xe147e78b,0xdb82e155,0xdb2adf1b,0xd559d519,
0xd8fed873,0xd928dca8,0xea7be713,0xecd0ea2f,0xf385e672,0xf638fa1f,0xf38ae9a3,0xf328fbf6,
0xf716f4f4,0x0b95fdc4,0x1c411edc,0x1d68214c,0x2a0c30ce,0x35d12468,0x3b5931c6,0x276939af,
0x0dec1713,0x0abd0811,0x06ad00b4,0x057c1081,0xf0740231,0x00a1f0de,0x1c1a0e31,0x183f19f4,
0x0dc0101c,0xf9dc0076,0xf78cf383,0xfa24fcdb,0xde83ea14,0xe3cee802,0xdf16e56d,0xde1ddaf3,
0xd725da59,0xd2b4d415,0xd7f6d69e,0xe0b5d412,0xea70e001,0xe4acea53,0xf5f4e918,0xebeff835,
0xf7bef01f,0xf89af28d,0xf3f7f3a5,0x0ef3ff8d,0x18912039,0x2cbc1bf4,0x28e526e3,0x2c6c2dfd,
0x3e4439fb,0x283537c1,0x125515a0,0x03750f93,0x0b5a07d4,0x0cd2110d,0xf180fe01,0x03a6f888,
0x1b4215c9,0x1bd91cdd,0x108a14fc,0xff83020e,0xffd4f5c0,0xf6f6053c,0xe804ee13,0xec05ea1a,
0xe24de736,0xdf4ae416,0xdb11e133,0xdcf6d6aa,0xdd93d5e5,0xe284dbc9,0xf103e738,0xe807e992,
0xfadef450,0xf6acf2b5,0xf4f3f72b,0xf8f9fd41,0xf374f80b,0x1d030568,0x1b8215fa,0x254a2843,
0x2ac32e52,0x329a2b0d,0x41c83c51,0x2073388e,0x140e1eaa,0x06750d29,0x0f960780,0x098e14cd,
0xf266fb0b,0x07f7f9f2,0x19801427,0x1d1d1b68,0x0ef31322,0xf7b00393,0x0297fb80,0xf6cffe52,
0xe835ea23,0xe595ecb1,0xe01ae78b,0xe121e11f,0xdaf0d9b9,0xd691d6b5,0xda6ed58f,0xdf28d817,
0xe966e9b4,0xef01df64,0xef73effb,0xef03f590,0xef25f565,0xf84dfadb,0xf5f2e6e9,0x0c7809b8,
0x1a7f143b,0x28471c78,0x26f023e4,0x2c1d2575,0x3a053f91,0x1fb12df7,0x0f4b19dc,0xfe3d09e5,
0x0eee06ab,0x04f70f43,0xf1def0d5,0x0982f5be,0x16780bc5,0x147a1a32,0x07b6172c,0xf865fcc0,
0xfedafcfc,0xeeaefdd4,0xe888ec68,0xe91ee7e2,0xe402e0ab,0xdd0ae0cf,0xda4fdc0f,0xd407d6d8,
0xd563daaa,0xe796d97a,0xe3cee5ff,0xed86e9e9,0xf2d5ef6c,0xf7edf437,0xfdafea19,0xec6dfda8,
0xfb5bf10d,0x12c206ef,0x1c80132b,0x27b12167,0x239c2a47,0x3826256b,0x3b153eea,0x22ed2e05,
0x12a31dfa,0x018708b4,0x12c40d79,0x022f1282,0xf649f248,0x070cfd8c,0x17f51255,0x1f131899,
0x08db1465,0xfa0b0101,0xff020634,0xf33afee2,0xed71edcf,0xe7dfecf0,0xe57fe879,0xe100e38e,
0xdc77e0b1,0xe0d4d64e,0xd99cd418,0xe50ee504,0xe6b6e958,0xf0d2eef3,0xfc0eedca,0xed9df813,
0x0155fb18,0xf4e4f568,0x01def02a,0x11570943,0x1ad5177d,0x2c8624f3,0x21592598,0x37cc2e30,
0x36f14299,0x257c2f29,0x11ec1ef3,0x06fe0583,0x17ed0d13,0xfc5f0f0c,0xf477f6a7,0x0a72fd49,
0x14540e4c,0x19de1d58,0x030b14ee,0xff3cfec8,0x00eb0092,0xf0b0f91f,0xebd3ee3f,0xe616e950,
0xe1f0e779,0xe376dffa,0xda45d7c5,0xd270dc86,0xd94ad4e4,0xe2b5e16d,0xeac8dfc0,0xe4d2ea6c,
0xf2bcf7ad,0xf479ec08,0xfc0af61f,0xee7ef03d,0xfb5ef157,0x0ec3060d,0x191f0e89,0x230a25d8,
0x1dd5201a,0x36cd2ca0,0x31ff3c8b,0x261f2a83,0x0f5e17d0,0x0478ffe4,0x137e10d1,0xfcdd06f1,
0xf388ef34,0x0273001a,0x119a0d18,0x1b081bf9,0x04720a94,0xffe0fcd8,0xfd820141,0xf04cf769,
0xe975efd6,0xea31e8f2,0xe464e1a9,0xd8f2e646,0xdbc9dfc3,0xd41ad9aa,0xe196d3e9,0xde7fdf3b,
0xe60aec47,0xf336e637,0xf0b5f360,0xf657f0d3,0xf878fc82,0xf26af25b,0x01b2f069,0x0b510929,
0x1feb11c5,0x232a267b,0x22b61f06,0x3bf430e5,0x35f33927,0x26802e8c,0x0b0d1e13,0x0f0a0317,
0x17dc1088,0xfae80872,0xf8f8f40a,0x068e01e8,0x192b0b9d,0x18662022,0x02df1020,0x0357045b,
0xfe4b0621,0xf85bf9b6,0xf1a0ece7,0xe54fee4b,0xe8f3ec55,0xe081e396,0xe1dde1f1,0xd112da7c,
0xda3ce54b,0xeb22e295,0xe8e6e5d2,0xf6eeed4f,0xf173f235,0xfe03f43a,0xfb59f8da,0xee79f49b,
0x01b7f913,0x09340866,0x207516cf,0x21032564,0x28001bca,0x39fb3034,0x339b38a1,0x29052d6f,
0x090615bb,0x08c706c4,0x10c81677,0xf6170580,0xfbd5f122,0x010bfcbb,0x17540af9,0x143c1ce6,
0x004f09b4,0x04f40218,0xfe28fbea,0xedcff804,0xeb1af282,0xe819e620,0xe686e717,0xdd92dcd3,
0xd555e6f4,0xd91dd5cd,0xdac8d78b,0xe336e48e,0xe641e286,0xf244ef9c,0xf24dea63,0xf7e4f475,
0xf757f9fc,0xee20ef67,0xfe14fa03,0x094e0386,0x216d14e5,0x1a132106,0x23e21f67,0x391a3154,
0x3547323a,0x231a2e5b,0x05dd15c0,0x0cd0061f,0x11e314ab,0xf4afff06,0xf9a6f66b,0xffc5fb49,
0x197d0cca,0x15121ad3,0x0757025c,0x00060384,0xfc670292,0xf6d3f411,0xec5bee77,0xe8aae779,
0xdc4beef9,0xe6f2e305,0xdab5dcda,0xd659da75,0xe037d93c,0xe2b7e5a8,0xede3e19b,0xed87f1d8,
0xf329f048,0xfac5f69a,0xf469fdcf,0xf375f21a,0x00b2fb1b,0x0b620304,0x206b1c1d,0x1dec1fcd,
0x2b331d53,0x353433cc,0x35e23877,0x26363019,0x0b0611e0,0x13a8066e,0x0d4e191e,0xf74f00ba,
0xf930fbf4,0x0468fb8e,0x21ab0c5f,0x0fe11988,0x079b0b34,0x08d40331,0xff03fe8d,0xf65cf862,
0xe55af585,0xee9bf0cf,0xe489e591,0xe195e9a6,0xde50e1bd,0xd800d9e2,0xe7a6da73,0xe076e269,
0xee84e90b,0xedaef139,0xf03cf30b,0xfcd8fb0b,0xf590f9fe,0xf5edf120,0xfc67fc5f,0x10ab01b0,
0x227017d8,0x18f81b7b,0x27de22d3,0x3392323d,0x362d3638,0x21822de2,0x0483105e,0x13fd0a01,
0x079a14dc,0xf9e6fd02,0xf920f4e4,0xfe50f714,0x188c1485,0x10bf1440,0x072f03c6,0x0306034f,
0xf688ff62,0xf594fb7b,0xedbde7d1,0xe542ee6d,0xe4c7e710,0xdf32e459,0xdd06e134,0xd534d437,
0xe291df92,0xe21cdcad,0xec72e7bb,0xedbaeec7,0xf3efebc0,0xfa9cf953,0xefaff8ae,0xf6acf3f7,
0xfbb0f6cc,0x0e2701c4,0x1afe1cc2,0x1b93185f,0x2b581f37,0x33e72cd8,0x32b23782,0x1af0315c,
0x02b30fae,0x14cd0f80,0x087d0ef3,0xf78efc58,0xf36df9c4,0x0848f3d7,0x1bb60d79,0x0cba12df,
0x037a0851,0x01e009b5,0xffe6f99e,0xee35fb9b,0xf01ff042,0xeabfe961,0xe96fe6a8,0xe5d7df78,
0xda2ce44b,0xdb52d4d7,0xdea5e304,0xe3c6e1a4,0xf133e98b,0xecbbef4a,0xf5a1f05e,0xfcd3fe2b,
0xf773f4f7,0xf740f6b7,0xf9affaf8,0x144e0709,0x1c2e1b9e,0x1e47196c,0x29c423cd,0x343a3194,
0x36e73a81,0x1bce31c5,0x0c320c22,0x13af134c,0x04851550,0x0058ffaf,0xf81ef32d,0x083df75c,
0x17fa1537,0x0c9b16dd,0x0f9805da,0xfe4206d3,0x00fa03a8,0xf432f7a4,0xefa1f2f7,0xee13ea53,
0xe503ea1f,0xea5fe483,0xd6fae223,0xddadda72,0xe0efe071,0xe343e0f0,0xedf3ee83,0xebb0ef60,
0xfc09edfb,0xf854fb5e,0xf4a3f836,0xf78bf7c1,0xfcd6f417,0x14dc05bf,0x16d01909,0x1a0c1ad7,
0x272f239a,0x32c12ef1,0x39ae3726,0x14372aa5,0x089a0e9d,0x158612e8,0x06bc08cd,0xf8b2fee4,
0xeee1f46b,0x05ddf996,0x1a2a0f89,0x05b50d1d,0x07fc0dbe,0x014cff8f,0xfb7b010d,0xf3bcf4d1,
0xe8e0f06f,0xeb6fecca,0xe1bde492,0xe60ae8b3,0xd9eada62,0xdcc0d73f,0xdc23df06,0xe3a1e041,
0xef7feaf8,0xe7eae9f4,0xf742f3a5,0xf7c0fa48,0xf9cdf396,0xf75af3ac,0xfd32f15a,0x12a9083f,
0x15eb17f9,0x1a5d19c8,0x2794237d,0x30242d4c,0x34804016,0x1742280f,0x134e07df,0x113c126d,
0x049d0cb5,0xf7b60353,0xf424f163,0x057ff8d9,0x113819a5,0x0dda0c55,0x06260d26,0x06970230,
0xfcccff31,0xf775f826,0xeea5ed2d,0xe970f13b,0xe989e520,0xe410ea5d,0xd910e024,0xdf5edcb2,
0xe24dddb8,0xe7a1df0f,0xed6ef0fe,0xed9deaaf,0xfdeff36a,0xfa14f848,0xfb7bf762,0xf39ff8c1,
0xff58f66d,0x15460b82,0x194a1691,0x1d131879,0x22bd288d,0x389b2e69,0x38e93c5e,0x12702525,
0x114712b7,0x101b15e0,0x0b8b0bfa,0xf71cffcc,0xef19f6da,0x0e67fb20,0x0fb61322,0x104b0f16,
0x06d8096f,0x0443070e,0xfe72fe66,0xf273fb71,0xf4f8edee,0xe874ec0a,0xe8a9e8fe,0xe3aaeb02,
0xdc7cdd54,0xdd9bdbba,0xdad7e237,0xea21e260,0xee2bed92,0xefd4e64e,0xfbf1f48d,0xf6e7f78c,
0xfad6fa85,0xf23af5ac,0x00b0f532,0x11ad0b2e,0x114318a3,0x20c319f8,0x264a1d4b,0x377b2b16,
0x30473fdc,0x12442145,0x143710a8,0x0db20f3a,0x03a60fff,0xf8fdff28,0xeed0ed51,0x0b5afed7,
0x0e8b0cd9,0x0abd0f4f,0x07a906ec,0xfda905b2,0xffe0ff73,0xf05ef3f7,0xeee3f234,0xe736ea97,
0xeab0e6a2,0xe02de6ec,0xd5dddff3,0xdcaaded5,0xdc42dc5f,0xebe1e07c,0xea01eb4a,0xeec2e6ad,
0xf906f688,0xf936f408,0xfb65f9b9,0xf04bf273,0xfca6f93b,0x132c0ecb,0x187d0f4d,0x1efd18f3,
0x223e1f4b,0x3d3f2e36,0x31fc3ba1,0x15721c85,0x0e4e1765,0x10fe137e,0x070e0cbd,0xf507035d,
0xf524ecdd,0x08fb0213,0x129e0e13,0x0a840e37,0x0c600b20,0x02aa00b1,0xfb090629,0xf3e4f814,
0xf168f458,0xe90feb18,0xe8c8edae,0xe319eb8e,0xde84ddad,0xe080dea0,0xde97dc42,0xecdee6d8,
0xe980ee02,0xf4a5e92e,0xf984f725,0xfbeff5c0,0xf843ffa6,0xf52df45a,0x0888f3a9,0x10860c63,
0x159614d3,0x1dd01e01,0x24cb1c4d,0x3ed430d7,0x2a0e3d6a,0x19822002,0x130b11e2,0x0de9146d,
0x0b2c0d88,0xf01f0098,0xf705f056,0x067f00e2,0x10de10b7,0x0e6f0853,0x05050cef,0x06d201f0,
0xfc650055,0xf4b2f4fc,0xea1bf648,0xe736ee44,0xeaefec27,0xe1cee7ca,0xdf1fdcc6,0xdcf7deae,
0xdfc0daa3,0xee00e611,0xe8c1e841,0xf27ceab9,0xf143f915,0xfc49fa4c,0xfbf4fa23,0xf10ceff4,
0x0457fa67,0x0fd60bd7,0x1a470fea,0x1b3819ee,0x207a1bd4,0x3de236ec,0x2a3235df,0x147e2099,
0x14441471,0x0cc20f80,0x0a111116,0xefcefa63,0xf7d6f1b8,0x0ae2fb3f,0x08c10f15,0x0ec10cc4,
0x058a06f4,0x054702bb,0xf62c0069,0xf405f8f1,0xecf2f150,0xe935e95a,0xe9afeb64,0xde9be6b6,
0xde45def5,0xdb0edd5c,0xe098d935,0xe8e9e7f1,0xe37ae9eb,0xf248ef1b,0xf777f16b,0xfb27f63c,
0xf50eff0b,0xf245f017,0x0836f8fe,0x0ed7074d,0x17d21279,0x182a1c37,0x27ec16a8,0x39b43861,
0x2b1e3680,0x17511d18,0x11e2183f,0x11820e57,0x085713ab,0xf648f72f,0xf502f252,0x0cd00242,
0x0f1108da,0x0e4a0dfa,0x03d6099b,0x03e00ab8,0xfc48ffc8,0xf7eaf876,0xee5ff2df,0xeb2eec88,
0xeb56f017,0xe25fe76a,0xe244e1d6,0xda04df63,0xe19ddfe9,0xea9ded1c,0xee3ce643,0xf391edbc,
0xf4dff738,0x00c0fad4,0xf831fd54,0xf59def3e,0x04f4ff46,0x0ee10adf,0x1e3e1265,0x1454189b,
0x2c4a1b1e,0x3b943586,0x268b3781,0x1a811eaa,0x0ed4180a,0x17050ef1,0x03431142,0xf48afbf6,
0xfbfaecdd,0x08be002e,0x0c8c0923,0x08db105d,0x07520743,0x0227071d,0xf969ff15,0xf502f9b4,
0xec11f208,0xee2de9b8,0xebbfeb7b,0xe147e309,0xdd2fe450,0xd7abde49,0xe6aadcb8,0xe5a6e72a,
0xe721eb15,0xf29eef44,0xf735f0fe,0x01a9f7e2,0xf290fb32,0xf584f057,0x05cefc9b,0x0b100713,
0x19cc17fc,0x130f133b,0x278b1df1,0x3af937d3,0x24ac31f5,0x1d381ed4,0x0c37124d,0x150814d6,
0x08000bd9,0xf004f7c6,0xf851f304,0x031e028c,0x0fe609d2,0x09bd0989,0x084406f3,0x01a105b2,
0xfae8fdc7,0xf6ddf882,0xecf7ee6f,0xece0eb0c,0xe552ef46,0xe235e650,0xe13de222,0xd8cfd86a,
0xe1c4e2a9,0xe781e7fb,0xeb1fe75f,0xf1bdee44,0xf3acf2f9,0x009efdd4,0xf4b5f85d,0xf6baef62,
0x031400e5,0x10c50422,0x14af1990,0x13a314e5,0x2b071d1b,0x3a4f3a37,0x25cc2e63,0x19742611,
0x156b0fb4,0x15c712d1,0x055a10e2,0xf15ef8e3,0xfcedf62a,0x0759fd93,0x0e230d1d,0x0a5d0af5,
0x0a060a2a,0x04ba057e,0xff07fd21,0xf654fa64,0xead8f2ea,0xef7bf09d,0xeb1aecbc,0xe61ae447,
0xdb90e7ed,0xdc8cdcf8,0xe66be1b1,0xe8c6e760,0xeafdea5d,0xf107f278,0xf97af199,0x007ffe96,
0xf275fa7c,0xfcc7f06c,0xfe71ff8e,0x12c00930,0x14f316ca,0x125f1356,0x2d941d18,0x33843c25,
0x2e052bfa,0x182f1e7e,0x11c31308,0x157c147b,0x03a0101c,0xf4a3f3b8,0xf723f6c0,0x05bbfe93,
0x0a460ce6,0x0b2e08a4,0x0a7f06fb,0x02380305,0xfba4feae,0xf521faf0,0xeebaed40,0xee76ed23,
0xe2c1ee89,0xe60ee8e4,0xdca5e28e,0xdca8da1c,0xe3f0e1f5,0xe75ae71b,0xeefde74e,0xeee8edcf,
0xf873f2b7,0x00b2fea5,0xee37f6b6,0xfa58f758,0x0024fad7,0x123e09b0,0x13cc1536,0x0ed01168,
0x346a1f2d,0x32a43290,0x274c31dd,0x163320d8,0x113d1448,0x17d914f2,0xfe3c0f22,0xf5bef75a,
0xf730f512,0x092ffdc7,0x0b1f0852,0x097f0862,0x05f90b0b,0x01bc05ec,0x0069fcb6,0xf516f7b0,
0xeb09f00e,0xef2ff1f0,0xe84de903,0xe708e7c1,0xda9ee327,0xdcc0dc65,0xe624e219,0xe701e494,
0xee26eaf1,0xf14cebac,0xfa20f0a1,0xfcae02f5,0xf3bdf360,0xf786f890,0xffd7fbad,0x0fb60d01,
0x14e51709,0x13bb08db,0x2d27260b,0x33d03467,0x28283107,0x19711f15,0x10c312f1,0x16bb1ad2,
0xfde70d8d,0xf75afa19,0xfa25f2cf,0x08dbfeb3,0x096a09b4,0x0bdd0a16,0x0bb40825,0x02c702f1,
0xfcb80165,0xf3ccfd71,0xf1deedfb,0xeecbf17a,0xe8aeeae8,0xe7fceb69,0xde27e1eb,0xe071dae7,
0xe4d8e4e0,0xeb18e4ab,0xececec11,0xed8eefc0,0x000cf392,0xf99c012e,0xf62af6d3,0xf604f925,
0x0476fc6e,0x166e073a,0x0b90179a,0x16ed0cdc,0x2d9f23dd,0x35243330,0x26412f15,0x15a2228a,
0x141a11a9,0x16691af9,0x00a3083b,0xf4ebf940,0xf6d7f47b,0x07c10037,0x0b730568,0x0b1a05e6,
0x056b0a59,0x00540547,0x0081fea5,0xf090f870,0xefecefcf,0xeb87f129,0xea0be8de,0xe6b5e8ea,
0xda9ee081,0xe21eda69,0xe149e10d,0xe755e6e3,0xed3eeb98,0xebf9e9f5,0xfe0cf735,0xf79efd2a,
0xf834f6ce,0xfa40f10e,0xfd58fb1a,0x15710e12,0x0a5910be,0x17a20d05,0x2c2521fb,0x3050355c,
0x27ba2f27,0x1437200d,0x1953107c,0x134a199d,0xfe750a5d,0xf453fb59,0xfa6df304,0x06f1fed0,
0x05fe0899,0x0acb0a5d,0x0a1a0899,0x019501d5,0xfebe0393,0xf0d0f944,0xf2a3f283,0xec1cf0a8,
0xeac3ebc0,0xe90feb66,0xdc47deae,0xe1dddf97,0xe613e0a8,0xeba9e444,0xea38eefc,0xeeaeeae5,
0xfe59fb7c,0xfd4df991,0xf359f908,0xf97ef91b,0x04bdf6d1,0x158a0fb5,0x0b160ddb,0x151410e9,
0x2db924f3,0x30af33a3,0x295e30b6,0x120e1e14,0x1803172a,0x132c1af7,0x03f207ed,0xf660f76f,
0xf799f4f4,0x056d02d0,0x08c70660,0x0aa5088e,0x05230c91,0x02e8038d,0xff410415,0xf38af633,
0xf315f344,0xee84eebb,0xed44e94f,0xe55eedae,0xdf0cdf25,0xe1c1de9e,0xe112e38e,0xecfae859,
0xe9b3ed8c,0xf6b6e725,0xfa19f918,0xfbadff10,0xf99ef51a,0xf61af749,0x06edf815,0x0f3212a4,
0x0ae60f1f,0x170c0e54,0x2df6246a,0x31a22fc8,0x25053305,0x13d71bec,0x1b4015f9,0x12a01686,
0xfe910a05,0xf3e4fa7a,0xfad6f27f,0x04acfeb6,0x0485062d,0x0b1e08e3,0x041f08fd,0x04ac0186,
0xfbe602d9,0xf417f538,0xf1adf1c1,0xe988ef7a,0xeedfead3,0xe470e947,0xdafde003,0xe032e13d,
0xe186e00c,0xf030e708,0xe49de814,0xf34dee00,0xfe8af52a,0xf910fb1f,0xf9a8f734,0xf13ff597,
0x08bcfc69,0x10370eb0,0x0a810c63,0x186e0d13,0x28722668,0x345e314d,0x26512f5a,0x16d917f4,
0x17741960,0x11931a2c,0x025a08bd,0xf54ff7c7,0xf966f524,0x04eb012e,0x05b204a6,0x0b9f0af4,
0x03170932,0x066a0559,0xfc3d0214,0xf39bf81d,0xf469f472,0xecd5ec16,0xec87eef9,0xe475ed48,
0xdf67dfc2,0xe29ce156,0xe16fded7,0xeb54f062,0xeb83e661,0xf44eec11,0xfeebf8c7,0xf97efa0c,
0xf98afc50,0xf539f153,0x0995fe45,0x0f3b0f24,0x067b0d0a,0x1a2c1174,0x2b2421e0,0x36813069,
0x215b2ee4,0x18351b5f,0x1b891733,0x126a1707,0xfe5c0ada,0xf407fb08,0xf999f5b0,0x03030230,
0x062103c7,0x0be90b6b,0x0555054f,0x04d10668,0xfd5e021f,0xf65af4ef,0xeef9f68a,0xeb76f01c,
0xef05ef14,0xe54feaff,0xe048debd,0xdd37e523,0xea5bdd35,0xeb2deaad,0xe9f9e7e7,0xf44cec5d,
0xfad3fc26,0xfe6ff841,0xf682fbc4,0xf646f0cd,0x07f50038,0x0e6610e7,0x0b930722,0x1a130faf,
0x27d3215f,0x339e360d,0x23132ba4,0x18f31996,0x18cc18c2,0x11f118c7,0xffc5086e,0xf3d0f9b1,
0xfa80f4fa,0x01800102,0x079b0190,0x07e60b2a,0x06340571,0x06890339,0xf85401b2,0xf578f8ac,
0xf0a1f3a9,0xecd5ec7f,0xed5deee8,0xdf7fecda,0xe562e026,0xdceddd08,0xe86fe082,0xe9dfe9e4,
0xe6bce852,0xf87fec39,0xf7f7f809,0xfecdfad2,0xf1e6fb2d,0xf5d7f30e,0x0c3cfe7e,0x0b200dc0,
0x09700808,0x16ff129d,0x2d731df7,0x333a32dd,0x20832ae6,0x187f1bf3,0x1a711861,0x111c18d1,
0x009408d8,0xf46cf95f,0xfcaaf59c,0xff4a0077,0x09e8039f,0x0a7e0782,0x03c205f3,0x055908e3,
0xfba90041,0xf77ef84b,0xef31f50b,0xeb37f071,0xf183f251,0xe3a4e6bd,0xe208e5fb,0xde5dde5f,
0xe7d8e416,0xecfaebb5,0xe862e519,0xf7cbf1fa,0xf71cf80a,0xfec400dd,0xf625f8e3,0xf7b7f0dc,
0x0b5f0305,0x09450ee5,0x0f3b0787,0x17390ea5,0x2cf62077,0x31a234c8,0x219e29e5,0x18061c6e,
0x1ab31a9c,0x115f184a,0x017608d5,0xf433f861,0xfe05f795,0x01c1fb9a,0x063c03ff,0x06970bd3,
0x06f604c6,0x04e0075b,0xf9a00045,0xf51cfbd4,0xf11ff517,0xf0fbea3c,0xeba8f3a0,0xe5f6e7f8,
0xdec8e61f,0xe021deaf,0xe940e178,0xe837ed95,0xe976e46d,0xf4b5f40f,0xfcccf400,0xfe8dfd66,
0xf1e2f9be,0xf72bf220,0x0d7703ab,0x08ae0941,0x0bb109fe,0x15900ec5,0x2e952019,0x307732bf,
0x20f1290c,0x19101b32,0x19cd1ad1,0x10681818,0x005e09eb,0xf800f4d6,0xf9c2f7bb,0xff19fe4a,
0x09a002c4,0x06370711,0x05ff053d,0x014d093c,0xfc060045,0xf86cf7bd,0xeb41f45a,0xf279eec9,
0xea70f046,0xe929e8db,0xe0f9e063,0xdd88dec9,0xea0ce331,0xe42aed44,0xedefe449,0xf2bdf07b,
0xf94af718,0xfd66fff3,0xf2bbf7be,0xfb26ee16,0x0a1f0575,0x08f80834,0x0b4c09b5,0x14060d81,
0x2d3322e3,0x2f6232b7,0x1fef287e,0x19f31c33,0x1afe1adc,0x14fd15bd,0xfd570836,0xf764fa26,
0xfccff75f,0x00b0fb3c,0x0761055f,0x0414092d,0x094107b8,0x05b6052a,0xfac5000d,0xf922fccc,
0xedf7f148,0xf3b3f27d,0xee5ced34,0xe65cec3d,0xe0e8e4d6,0xdd4ae054,0xee74e6bf,0xe53de8d0,
0xec0de9c2,0xf322f31c,0xfd59f6d1,0x00a8fed8,0xef6ef7ea,0xfdfbf28d,0x09490647,0x098908a0,
0x09850ba8,0x15720d51,0x2d1423d1,0x2e823365,0x2179274e,0x1dbd1a80,0x19271915,0x11f91adf,
0x00470625,0xf89ff7d4,0xf8b8f8a6,0xff0bfcfb,0x07f2057f,0x07b30340,0x05fd06ac,0x02ff0811,
0xfd41fd49,0xf5e5fd34,0xf103ee58,0xee22f30e,0xece5f01a,0xe5aceb7d,0xe1b9e444,0xdffdda76,
0xe8a4e9ab,0xe4a0e8e5,0xed32e895,0xf35cef97,0xfb04f604,0xfea9019e,0xeeb4f3cb,0xfe53f3d3,
0x06ad0567,0x0a7507f0,0x07da0928,0x14be0ce8,0x2dcb233f,0x2ebd308e,0x1f3c2534,0x19d51f0a,
0x1da717d0,0x1287174c,0xfde7063e,0xf7aafb12,0xf966f873,0x02fef9b4,0x039a04b3,0x0533076f,
0x086f0662,0x016f072e,0x0242fd4d,0xf352fa98,0xf220f20b,0xefe0f163,0xeee3f01f,0xe8bfe953,
0xdb9fe6bc,0xe204df40,0xe9ede919,0xe7a6e677,0xed01e89c,0xf2eaf11c,0xff1cf4e2,0xfd5b0241,
0xef73f25f,0xff1ff6e1,0x05440505,0x090f0afe,0x08990899,0x178c0ab9,0x2d8a226a,0x2ae432ca,
0x23d12474,0x1a381ba8,0x1b2a1ad0,0x0f681b25,0xff780695,0xfacdf9df,0xf6a3f720,0x013cfe8a,
0x064302c1,0x058f04c6,0x0b2306a3,0x000003af,0xffde034c,0xf483f935,0xf2f6f2c5,0xf23def94,
0xeae5f111,0xe970ee74,0xde01e2b3,0xe562deac,0xe8b7e81c,0xe76be81e,0xef4fe8a0,0xf105f04c,
0x00b4f773,0xfab702e3,0xf07bf1f6,0xfdb4fa32,0x077e04ab,0x0a840998,0x06e507ed,0x15070dfc,
0x30f823da,0x2b162e0f,0x208f277d,0x18b81ed4,0x1e2d1bd1,0x11d71834,0xff020528,0xf84bfeb8,
0xf9c9f5d4,0x0130fd1f,0x067802ff,0x05d80233,0x06a10afe,0x0335024e,0xff7a0305,0xf680f75a,
0xef71f338,0xf0b8f417,0xef0aed8d,0xe91eee14,0xdd62e0e6,0xe43be1f5,0xe993e708,0xe691e6bf,
0xee49ea47,0xeff4ee30,0x00c4f94e,0xf686027c,0xf313f1b2,0xfeb0f764,0x05e5036b,0x06950b55,
0x07e80734,0x16ae0897,0x2c4c2597,0x29582e02,0x222625e6,0x1a981a52,0x1c131b6e,0x0c721b08,
0x01dd04e8,0xf739fc1d,0xfa03f577,0x012dfafa,0x0148044f,0x09870204,0x05c3072e,0x05c50139,
0xfbba0263,0xf3c1fbbd,0xf2dff1d8,0xef1ef2e2,0xf03cee74,0xe6f7ef94,0xe0b8df9c,0xe537e0e1,
0xe8f2e7d3,0xe805e61b,0xeca1ec39,0xefcdee30,0x030efc65,0xf79efe91,0xf377f29a,0xfdfef9d5,
0x0a20036b,0x09fe06fe,0x03b207f9,0x173d0c61,0x2d0025f0,0x2b592ba9,0x1fef267c,0x18891dfb,
0x1f921d8b,0x0d5f1770,0x035a06c8,0xf844fb1c,0xf72cf7ca,0x03bbfd75,0x0196004e,0x0a13045e,
0x032706a1,0x03c806cd,0x0012017d,0xf3f5f964,0xf433f3bf,0xee46f273,0xf3f5efd6,0xe696ed9f,
0xe129e119,0xe691e1c4,0xe6f2e86a,0xe919e7e2,0xece0ec75,0xf494ea75,0x015ffdd4,0xf5efff55,
0xf5f5f3e4,0x006bf720,0x06210540,0x08e90b21,0x050c0586,0x19f80ae2,0x2a2a2598,0x28ae2e76,
0x21692709,0x1a971ab0,0x1e5e1fb0,0x0d8a15dc,0xffe7093e,0xf90bfd32,0xf984f38a,0x01defe4d,
0x003bfe1a,0x0599086f,0x05df04e0,0x033e03c3,0xfe6202e3,0xf37bf7ef,0xf49bf461,0xeea2ee72,
0xf31cf183,0xe631ebc5,0xdfeae060,0xe585e33c,0xe66fe68a,0xeb10e688,0xe7c1eb34,0xf3fbed0d,
0x01bafdb5,0xf7d1fa24,0xf1e9f3da,0xfe8cfabc,0x089002a0,0x090b08ae,0x0296030f,0x172f0e56,
0x2a502527,0x29572b60,0x1e8d2751,0x1c4c1a86,0x1b3920aa,0x0f551690,0x03e80572,0xf753fcb3,
0xfa9af3e5,0xfd1500ea,0x0446fe54,0x056b0575,0x04440717,0x04a20482,0xfeb403f1,0xf6f0f64c,
0xf3c3f5e0,0xf14cee20,0xf276f3a9,0xe4f0ee55,0xe23be1b8,0xe742e440,0xe5d0e641,0xeaf3eba3,
0xea36e983,0xf935eba3,0xff2ffe6f,0xf757fdf4,0xf68af2b7,0xffc3f99e,0x080503f8,0x05280cb3,
0x04cd034e,0x19b00cd0,0x29432475,0x2ad22b7c,0x1c6825fc,0x1ea61cd4,0x1e4e1d0d,0x0d96155a,
0x03a607a8,0xf31efdb2,0xfd8bf698,0xfccffc01,0x0243fffd,0x060d0492,0x03c70576,0x0656039a,
0xfbea033a,0xf7dff761,0xf071f5c6,0xf078f065,0xf389f3f8,0xe56aebcd,0xe24ce12a,0xe4bae6bd,
0xe993e3f5,0xebf2e993,0xe68fe823,0xf77cf111,0x01a4fd09,0xf7aafa77,0xf61ff33e,0xfd6cfb02,
0x0ad804d9,0x0590091a,0x04390272,0x19920e31,0x275b2390,0x2a062e08,0x1f9e21f5,0x1db31cef,
0x1d221f44,0x0c4a158f,0x05540a6c,0xf572f8de,0xf9edfa54,0xfcc2fcd3,0x01950015,0x06ab04bd,
0x0331040b,0x0761052f,0xfb040162,0xf75ffa56,0xf195f46c,0xf258eeb0,0xf228f4b8,0xe27ded63,
0xe5c9e1e2,0xe44be3ef,0xe830e4be,0xe8afed56,0xeb02e4b4,0xf913edde,0xff70fd66,0xf54bfb2f,
0xf738f495,0xfec4f7a8,0x0953060e,0x0332096c,0x0337021d,0x180a100c,0x2b812005,0x27e32b7b,
0x1ecd2288,0x1ceb1d74,0x1c1c210e,0x0f45127c,0x001c0cae,0xf71bfa6c,0xf9caf953,0xfdb2fbf7,
0x023efe1d,0x060604f2,0x03be022f,0x054207f6,0xfd26007c,0xf7fdf9f8,0xefaaf4d2,0xf187f1bc,
0xf4b6f60d,0xe47ae949,0xe509e472,0xe26be62b,0xee28e4bf,0xe946e9aa,0xe9dce607,0xf848f15a,
0xff33ff92,0xf7a8f96c,0xf5d8f618,0xffb2f92a,0x09ac0799,0x02a00971,0x08310072,0x171c0dd5,
0x2ac422a5,0x26cf2b80,0x1f1f236f,0x201b1c85,0x19572112,0x110814f3,0x00e70adc,0xf89afaa9,
0xfab1f849,0xfd17fc04,0x0257fe3c,0x043b05e6,0x05200266,0x052f0735,0xfce200b7,0xf76efb08,
0xf084f48a,0xf292f0a6,0xf374f6b2,0xe42fe9d8,0xe5cee4ba,0xe290e503,0xed9ae582,0xe8d1e9f2,
0xe9f7e609,0xf8a4f11f,0xfefcff6c,0xf79ff985,0xf5c9f61b,0xffb0f931,0x09bf0798,0x0000094b,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};
