#include "strings_samples.h"
const AudioSynthWavetable::sample_data strings_samples[3] = {
	{
		(int16_t*)sample_0_strings_stringsg2, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(29) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(74) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)9308 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)9304 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)9304 - 1) << (32 - 14)) - (((uint32_t)2609 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-9.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(986.23 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_strings_stringsf3, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(50) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(88) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)8646 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)8642 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)8642 - 1) << (32 - 14)) - (((uint32_t)3415 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-9.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(986.23 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_strings_stringsdx4, // sample
		true, // LOOP
		14, // LENGTH_BITS
		(1 << (32 - 14)) * WAVETABLE_CENTS_SHIFT(36) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(94) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)10726 - 1) << (32 - 14), // MAX_PHASE
		((uint32_t)10722 - 1) << (32 - 14), // LOOP_PHASE_END
		(((uint32_t)10722 - 1) << (32 - 14)) - (((uint32_t)3098 - 1) << (32 - 14)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-9.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(986.23 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-0.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_strings_stringsg2[4736] = {
0x00000000,0x005d0181,0x002affba,0x02b60251,0x006401ff,0x02c00134,0x0211022f,0x04ed0455,
0x00850421,0xfec8fee8,0x0110011f,0xf585f949,0xfbfef67e,0xf824fde3,0xf93df587,0x0392001e,
0x03270296,0x0aa60968,0x024b06bf,0x0b3d0491,0x0a6b0e51,0xf15ffe6b,0xf923f01c,0x033501e3,
0x015a0272,0xfef7001f,0xfab2fb71,0xff80fbf4,0xf96cfe7c,0xf28bf516,0xf670f403,0xfd3cf8e6,
0x04fe012a,0x06be090b,0x0194036e,0x02090194,0x03e903e8,0xfc470040,0x0615ff1a,0x08140a15,
0x06e305fe,0x03930850,0x007b0165,0xffc2fe3b,0xfc75ffad,0xf9f7fa72,0x001afdae,0xfdcbfeb1,
0xfc5cfaf3,0xfbd5fc42,0xf8e4fc30,0xfb54f812,0x0069ff81,0x01300006,0x08030467,0x095c0a6b,
0x09d00a49,0x01a40a4b,0xf58bfa98,0xf969f73d,0xf9dffd27,0xf471f490,0x02e3fbba,0xf870fe83,
0xfad2f7f1,0x01a30117,0x0781028f,0x06540b5d,0x02f10073,0x16300df7,0x0ff31882,0xf498fe3f,
0xff20f792,0xff8d0191,0xfdadfe5c,0xfbd5fdea,0xfcfbfacd,0x01da0038,0xf814fd7e,0xf8fbf613,
0x006bfeb8,0xf9ebfc29,0x0498fde7,0x07680a45,0xfe38020e,0xfd59fc18,0x0124ff60,0x07af0292,
0x05ac0c0c,0x08770323,0x028f08c0,0xf92ef961,0xfb5afc1d,0xebcef495,0xf360eb42,0xf8d0fb3d,
0xf259f149,0x0936feb3,0x047f09d7,0x09c70459,0x05620b38,0x04b0ff9c,0x110e0fd1,0xfe2909d4,
0x03fffb71,0x10561075,0x0229068e,0x08dd043b,0x00e60606,0xfc9b0001,0xf7fffca5,0xed6eeee0,
0xf357f057,0xf33ef70e,0xf786f44e,0xfbd9f941,0xfbc5f93c,0x02a7ff32,0x09e107ae,0x00390717,
0x08eaff67,0x195213e0,0xf6420a86,0x0ce4faf8,0xfd5409fc,0xfa9ff607,0x034407b6,0x0274fc73,
0x0e0e068e,0xf94608a9,0x05fffb76,0x0a470d70,0xf0520006,0xe387df31,0xf0bdefe6,0xf8dff723,
0xfbaefc20,0xff73f929,0x18400fe5,0xff451263,0xf1adf21a,0xf63ef0f5,0xfb64f8f1,0xf966f9ff,
0xfa77fb86,0x0f100331,0x19a9180a,0x0af813b8,0x06a40290,0xfe150592,0x0037fd9b,0x0ef90c85,
0xf87fff7f,0xf524f86f,0xfd63f4f8,0x074c0a8a,0x00fe0039,0xfe13010d,0x0133fcd5,0x105f0b62,
0xfd5b0901,0xfa41f69a,0xfd08fa20,0x008dfee6,0xffe0065e,0xfd2bf8b3,0x005ffd41,0x07c50510,
0xfe090782,0x09e6fcd5,0xfbe80ddf,0xe2f2e9da,0xee0ce928,0xed83edd9,0xe186e48b,0xfec9f21a,
0x16110a88,0x1326192f,0x08a10c0d,0x15790935,0x0bee1d4b,0xea78f641,0xf04be5ce,0x1cd40983,
0x1d482006,0x17861d8f,0x07200cc2,0x03340452,0xeb44fe8c,0xe2a5e6fa,0xed98e818,0xec2ef03c,
0xf9c7eedb,0x0a7b07fb,0xf7a4067b,0xff53f5b9,0x0348012f,0x076d0772,0x0e5209bd,0x0fef10db,
0x1c681083,0x181b2448,0xf93206ad,0xd719e66b,0xf2a5eac8,0xe931ee67,0xfbfbe65f,0x104b128c,
0x0f160da0,0x00a30bcd,0xeed0f36b,0x01a9f46d,0x01850aa1,0xdaa6e790,0x0a6de867,0x20081fe9,
0x070e0fdb,0x00310787,0x00b6fcdd,0xf46bfb6d,0xe4b1e99c,0xed51e456,0xffe7f4ab,0x0ef40b39,
0xf90702b9,0x0801030d,0xeb56f5e5,0x0677f74e,0x116d1599,0x00bc0787,0x083e02c7,0x0b4b0d68,
0x02c50ac5,0x09c900ff,0x013006eb,0x0f4608cc,0x07cf12e9,0xffeafade,0x17950cfb,0x19df1c8b,
0xf9890932,0xe7bdf01c,0xecd6e92c,0xf095f471,0xe18ce212,0xfe0ff0bb,0x09df04af,0xfd6005c2,
0x097e01e7,0x01c50466,0xf1daf7df,0xf76ff67c,0x017bfa2a,0xfd170388,0xf306f2ab,0x0296fadc,
0x091407ad,0x0a1309e1,0xecc6fc9e,0xfc55ebb5,0x15a70d7a,0x1c931c63,0x0bdb14f4,0x00c50776,
0xf281f846,0x07430173,0xf1ec0738,0xe13bdc70,0xf507e9e7,0x04d60115,0x002402ec,0x0f8e02a8,
0x0fdd1af2,0x21fc1793,0xfcf51b55,0xf2d7f354,0xfec7f464,0x1b4e1176,0x0cea149d,0xfa280686,
0xf0e2f393,0xf100eebb,0xe016e991,0xecd4ecfd,0xe76fe78b,0xf5cbf010,0x0a0efce2,0x0d030d42,
0x0d2a0e79,0x22a014e6,0x19262319,0x018603db,0x145c0712,0x14d71dd1,0x091a13bb,0xf44cf806,
0xde77ed22,0xd905d7ea,0xf3f2e410,0x0270f955,0x09b30b78,0xf7cd0062,0xf30bf680,0xf8e6fa39,
0xe9f5f51a,0xe594e1d3,0xffd8efe6,0x047a04d5,0xf8a2f888,0x0f2e0685,0x35f1261c,0x268f30f1,
0x0af71d58,0x0c6404dc,0xf40105d3,0x0a2cffaf,0x079b11c4,0xf4fef7ad,0xea26ea2d,0x07edf7a5,
0xf83a02e2,0xffffff12,0xe77debb8,0xf466f0c3,0xf3a6f839,0xeca0efd6,0xf00df428,0xed57f221,
0x155ff873,0x267f2695,0x02b40ec1,0x1263185b,0x08d10630,0x05fa0124,0xfdd60eef,0xe40deee4,
0x028bf269,0x11ac0f5c,0x0aa50c94,0xfca004fb,0xf27af773,0x07f2fd17,0xe9a004a6,0xe1a3d969,
0xf656f19b,0xee01f950,0xe2f7e307,0x065bf66f,0x1ad610c4,0x0d7e15ab,0x1c16154c,0x0ee311fe,
0x0d681101,0x0b8a1455,0x041e00be,0xf0d50110,0xcddfddc8,0xf9b4dea2,0x048d0c07,0x05fef9dc,
0x16b613fa,0xfc8203fb,0xf95af84d,0xefccf7a1,0xf9bdec14,0x030f080b,0x0090fcd5,0x29e319b4,
0x0fa21fd0,0x1bc51727,0x0a5f1741,0xff810098,0xf78d0349,0xd1b7da99,0xddfdc6c9,0x09fb0094,
0x004b0852,0x0344fac1,0xfda1062f,0xe806efa7,0xf06fea02,0xf0bff682,0xe3f9dd30,0x0c65ffa1,
0xf5630658,0x09e0fdb8,0x012907c6,0x18420b38,0x35ab2a63,0x1e3c20f9,0x08b815e9,0x29d91167,
0x2e513540,0x04182235,0xd761e60c,0xdb3ad221,0xd218dc69,0xf996d6f6,0xe703f436,0xecb6e2d6,
0xf408f4f8,0xf618ef78,0xeda6f468,0xf568edee,0x24e908d8,0x19fb2ed4,0xf96f0369,0x2bc31214,
0x1a8a28cd,0x067c0ec3,0x020fff6e,0xf1a2f68d,0x0058f5ff,0x19600ea4,0x03ab1996,0x0ac3016a,
0x0b140cdc,0xffd10322,0xedc5f74a,0xdc5de402,0xe52fda3c,0x03c3f93c,0xe490fa0f,0xd695cdf2,
0xe166e7e2,0xf523e58b,0x21740e12,0xf7911570,0x0652fe14,0x10a0066c,0x33231ef9,0x216e323e,
0xe5d0fd0f,0xee71e365,0xf480f9e6,0xe462de5a,0xfbdefac3,0xf7c7fb4f,0xeb1ff314,0xf6ffe9b1,
0xfb0c04b0,0x1dc00054,0x3261353b,0x26bf2078,0x17c926d6,0x27631e82,0xf7281112,0x01c0fe45,
0xf21efb7c,0xfa20ed21,0xfb81031e,0x2252140b,0x17f92781,0xf981052c,0xee85f161,0xdd09e3be,
0xdfd9e1f1,0xc4b2d9f8,0xd191bedb,0x0fedf0bb,0xfec00654,0xec0cf0f2,0xdd9fe73d,0xffeae39a,
0x187a14c1,0x089e1402,0x170008f3,0x25921a0c,0x45dc3309,0x28842fa6,0xfbcb1709,0xe069e493,
0xf625ed3f,0xd6f2d8a5,0xff75f6e9,0xdb9feee9,0xdf3cd158,0xe1a5e5ca,0xe8c8e7ee,0x0711ee1d,
0x3f312c00,0x30833bb2,0x1e3a2d5c,0x21e81677,0x3a183e95,0x05f827ca,0xe56cf205,0xed34d74a,
0xeae6f945,0x10a0f810,0x1add1b85,0x2db11f77,0x140f190a,0xfd5d1281,0xe9a7ecfc,0xeb85efe0,
0xd95dd9ba,0xfcc3df9c,0xe3e6f20f,0xc9f0df63,0xc319c68b,0xcf8ac063,0xf2dee17e,0xfd020050,
0x018b034c,0x3599100c,0x3d8b2e6f,0x3ee445cf,0x041a2a5c,0xe304e095,0x0754f297,0xdb63f050,
0x012ff420,0xfc7c001e,0xe843ed91,0xc9a2d231,0xe6faddd1,0xfc8de9c7,0x15440817,0x1fcb1c54,
0x400c331c,0x39193982,0x308b33e9,0x2de83873,0x0d2c151d,0x03e3fd0d,0x045e132c,0x125f0436,
0x13f108fc,0x23591c5a,0x055d1084,0x0f311246,0xd3e8f81c,0xcdecc4a0,0xbd98c330,0xd78ec4dc,
0xd786e5ea,0xc794d880,0xbda6bc68,0xd5acc849,0x1068ec3b,0x155526c4,0xf7d9fd0d,0x292dffad,
0x36893110,0x46dc5a35,0x033a1c89,0xeaa4ea02,0xec18ea0f,0xdb6cf11f,0xe1add80a,0xe569d705,
0x0a970b53,0xd2f8f0b1,0xeca1d1c0,0x0dc1fd76,0x287d177d,0x4133378f,0x33ea3c8c,0x191a1838,
0x3f4b342d,0x1fa7340a,0x1bf316f2,0x0dc515a6,0x0f830db9,0x14530e9d,0xfa080041,0x25cc11a4,
0xfd521e86,0xf0f4efce,0xe9c5f11b,0xdb05ddbc,0xce31d576,0xe84fd77e,0xc1dade5a,0xcebbcf19,
0xaad1b38f,0xb5f8a447,0x005ed6ad,0x19801ef6,0x04e117c0,0x0eb9ee3d,0x44a03279,0x66b67700,
0x10692dd1,0xfb3afb6a,0xf7f6faa3,0xe1f3f608,0xcc87d07b,0xf245d9b1,0xfc820705,0xc0efd966,
0xd61fbbed,0x0afef4f0,0x226d10fe,0x3aed31b6,0x4264425b,0x11d5272a,0x38b62e84,0x2f662954,
0x333e3304,0x01021ab1,0x2463058b,0x32252b89,0x15f126bc,0x2717250a,0x0d1d1e98,0xefcef529,
0xc7f7d82f,0xc080b5cf,0xbce8d0e7,0xd2a6c0e6,0xc1f6c86c,0xcd05c694,0x9e43b2f1,0xb38da578,
0xdfdec4f8,0x22de08a9,0x0fac1baf,0x23cd0afa,0x4f913f28,0x5acc5413,0x13203b9e,0xfd4902e2,
0xf502fcf3,0xf2adfcc0,0xc274d17e,0xe298d286,0xf4eaf740,0xdaa3e1c5,0xcd35bbfb,0xf673ec83,
0x21c30a85,0x53084458,0x310945e6,0x29be2c22,0x3c5732bb,0x2839368a,0x2a4a1ae7,0x072e256b,
0x2b8f0a3d,0x31c83b64,0x1ea220fa,0x38813395,0x04ba2145,0xe59feb57,0xd4e9e11d,0xcf6bcb39,
0xc38ad97b,0xdc66b935,0xc0a7d284,0xbb15b652,0x973eaf68,0xbbd5ab29,0xc221b4c4,0x187ded3e,
0x35553290,0x2856236b,0x439f3c10,0x3fab36c8,0x1d453c27,0xf8b40204,0x01f60382,0xf821fbb3,
0xc9c2eaf8,0xd1d0c1e6,0x0484ef40,0xd2cbf0d7,0xc287c408,0xf13fe77a,0x2427fed1,0x55334e7f,
0x2b0939bd,0x3b42356b,0x24c12fd7,0x28e82bba,0x25fa1b0c,0x2d063c59,0x19600956,0x2d26323f,
0x20cc1e37,0x44533a2d,0x054c2406,0xdf56f77a,0xcba8dba5,0xca4bc3c4,0xbeb4c9b9,0xcf03b093,
0xc228d8c9,0xc10cbb9d,0x9a4fafc9,0xbf5bb0dc,0xab8aadfd,0x0c52dd98,0x32ca18be,0x364b318e,
0x37903730,0x27912ebf,0x26382f83,0xfe350bb2,0xf8bdfe2d,0xf497f93d,0xde61ee81,0xd822cd97,
0xffd1f0c5,0xd908f8c7,0xd253d882,0xe9f9e529,0x1cd7f9cc,0x4fce407a,0x2ca538c5,0x4d5540cf,
0x1785378a,0x2ac920af,0x279f1cd2,0x2cdc3c03,0x196b17d9,0x2e242e75,0x34592bb9,0x4a693a11,
0x04da2ca0,0xd843ff41,0xd25dd368,0xca4fc82f,0xc618c433,0xbae0b8cf,0xc87ecee1,0xbde8bb99,
0xac09c30f,0xb5b5ae58,0xad53b073,0xff05d10f,0x32d31029,0x3f873e23,0x30713cf7,0x1dd62919,
0x16761bbc,0xfcf20436,0xf7f3f9b8,0xfdcafb5f,0xe21cf1b7,0xdaa8d393,0x0014ec9e,0xdd19f6de,
0xd609e419,0xecd0dcdd,0x144bf6d4,0x35db2358,0x36173afc,0x47484479,0x22303f1a,0x30991e89,
0x1f4e2d8c,0x362033e5,0x0fd21d9f,0x30442156,0x481d3b06,0x3c5b3e4d,0x17af29de,0xd9760ada,
0xd148bf73,0xce7bd3df,0xc4d7b761,0xb6d0bf02,0xc594c464,0xccd3c2dd,0xccc1dbb1,0xa3daaf93,
0xbd5bac6f,0xe977d511,0x14f8f445,0x3f46349a,0x3aa24019,0x1fef3406,0x0d5f0fd5,0x0f36061b,
0xf492075a,0xf5fff0ba,0xebdaee1d,0xe251e22b,0xf551e827,0xedcbf6d0,0xe65cf910,0xebfad72f,
0x02cc00a1,0x20810e06,0x37ce3349,0x31e7364f,0x30323794,0x42bf2b01,0x0eda2fc4,0x32a42730,
0x0f7e2948,0x301e0ed7,0x4a0f39cb,0x489551dc,0x20ba3926,0xe2960dd1,0xc913bd7a,0xc60ed235,
0xb88dc175,0xa7f8b382,0xc734bb2a,0xdfb9d094,0xea48f131,0xacebbe49,0xc8fdb0c8,0xd0b3ca70,
0xfe16e6e1,0x40032887,0x4f58494a,0x15623f1e,0x195b0b24,0x13f819a9,0xffbbff95,0xd73aeb5c,
0xf428e51b,0xe085ee3c,0xf993e287,0xf43c063c,0xe6a7f4ab,0xebdae76c,0xf77ef5b3,0x26cd03cc,
0x31d83f5c,0x2bab2a7f,0x2eb02e91,0x470c2b15,0x11304386,0x30341623,0x04661be7,0x27740baa,
0x458d37c9,0x5cda5b10,0x1fee48e3,0xdea6fab7,0xce0ccc2b,0xbdfdcf07,0xb603bb9b,0xa749affe,
0xc46ca9ac,0xdbcadd02,0xe867e7a0,0xce14d85e,0xc5adc804,0xd068ca1c,0x0360ec0f,0x368b1d84,
0x4a69431d,0x278341b7,0x0e980978,0x08da182f,0xecd9fe42,0xd419db6e,0x0693f403,0xdfbff251,
0x0764e319,0xfdc119b5,0xef58f156,0xe23aeea0,0xf12addf4,0x1c5c0110,0x23db2bc1,0x161c0fb4,
0x483f2e1c,0x484240ea,0x16d8538b,0x10cc0388,0x037a0a9b,0x260d00c0,0x3ae03f1f,0x673c53cf,
0x2c3f5d08,0xdf8df467,0xd4bbe08e,0xc1e8cfee,0xb1cbc324,0xafd7ad17,0xc63ab0b2,0xd45cdbf7,
0xe4fadabb,0xd75ae5e2,0xcba2d1a2,0xdc39d871,0xfb3ad8b2,0x2ee30f4e,0x46683e6b,0x32b74c32,
0x038b0ad0,0x0c26167b,0xe5d0fcfd,0xd2a9d84b,0x0927efc5,0xe800001e,0x0a07ec27,0x018b11b2,
0xf971f89c,0xdcdaf375,0xfbe6da70,0x05590840,0x10a10d81,0xfb650089,0x40dc1660,0x4e62550d,
0x3cc25daa,0x129e0d52,0x07250fbe,0x17090780,0x30b53922,0x6ff83d47,0x37646b50,0xf004fe9c,
0xe0f9f1bf,0xcd92da21,0xadb8c03a,0xb100a50c,0xb2fbb17b,0xd520ca9e,0xea6dde45,0xf677f3e0,
0xdf40ead4,0xe12ce0ae,0xde84d647,0x10ddecbc,0x3b8e2d04,0x36a1493a,0x062d1056,0x1647127d,
0xf4ea067a,0xdd48e265,0xfd40e984,0xe979f997,0x035fe5cd,0x05471529,0xf786fac1,0xe9c0fe8f,
0xf736e19e,0xfb11f4cc,0xfa36f89b,0xefe1fef2,0x2cad06fb,0x52604b5d,0x472954d8,0x025c1b6c,
0xfde403bb,0x181cef2e,0x42043945,0x619f353c,0x49486ce1,0x01cb1c37,0xe343f6d8,0xd40fd36b,
0xa6a2b949,0xbf15ab95,0xadc2ba29,0xcfa1b67c,0xefbfe3a9,0xfe2cf43f,0xf080f81c,0xf7a8f361,
0xd31ae34b,0x01ade024,0x2ca4268a,0x3c573bf1,0x08b316a6,0x094d02d5,0xfda00177,0xf040f3e3,
0xf626eab1,0xff600b5a,0xf310e88a,0x097a17ad,0xf76bfe19,0xfb00f81e,0xe9c8ef86,0xf149ed82,
0xedc6ef24,0xfd88fea1,0x180d050c,0x49bf3437,0x48314af8,0xf4c32416,0x000bfe85,0xfedbf2ff,
0x3be31e5c,0x5040334d,0x48886af3,0x195e37ad,0xecf70519,0xd45ccc90,0xbcf6c532,0xb0babd71,
0xad79a1aa,0xd234bb5b,0xdf31dd8e,0x03e9eee8,0x06db10f1,0xfda4f8be,0xd288ee7e,0xeb4fd71b,
0x356313c7,0x3d4e3101,0x0d811c33,0x13c81645,0xf66b0567,0x0726fbc1,0xfa3701ff,0xfb4dfed7,
0xe1ebed62,0x1e4708cb,0xfe100b8e,0xfefaf730,0xde31f5e1,0xf2dde34b,0xf5e0f8ea,0xf540f4c7,
0x1d140561,0x472c2d27,0x42b14852,0x0deb36ad,0x0533007d,0xf85dff4c,0x1e950a68,0x3b142ffa,
0x56736172,0x1f7e3e15,0xf98604a7,0xc44bd355,0xc180c4b2,0xb604ce89,0xb1889f68,0xcc8db313,
0xd1cbd546,0x02e7e5bb,0x0dbd1a38,0x01cdff7b,0xe14cf75b,0xf686def2,0x1dcf0bd6,0x2aa82d50,
0x0616133b,0x0d520fe8,0xea03fad3,0x13eafbf7,0xf01d130d,0xf06eeec4,0xe44eeeb4,0x20abff7d,
0x1697243f,0xf72cf6a4,0xf2a4f993,0xef54ebb7,0xf807fcad,0xf860ef0b,0x034dfb2d,0x35ee1e4c,
0x30ab3b32,0x28cf2e1a,0x04790d6d,0xf84b07df,0x1336fc84,0x47003569,0x57224ac9,0x3cbf4b84,
0xf5b1186b,0xc102d582,0xc61acbe1,0xb983cc35,0xbde5a41b,0xbbd5be40,0xbeabc288,0xfaa6e5d4,
0x150c12ce,0xff3bfe3d,0xed580095,0xe31addaf,0x1e8303c1,0x187a1b43,0x0fa51749,0x0d971541,
0xeb0b0312,0x24e1fb7c,0xf6fa22c4,0xe473dcdb,0xe144f03d,0x20fdf5a2,0x1b7827c1,0xf8590173,
0xe8b5f857,0xf944eb1a,0xf4af0001,0xeee1e2e2,0xfeabfeed,0x2107127e,0x26fd2e22,0x3ed42aa1,
0x014b1c07,0xfbe60cd9,0x01d2f4a3,0x3be5253f,0x5974416a,0x44c45cfb,0xfa9e26bf,0xc262e1aa,
0xd2ddc7c2,0xbb3ac62a,0xc281b36d,0xb641c9d7,0xc313b6c0,0xfb11d935,0x19c70b75,0x05ca0dc6,
0xfa140853,0xe32dee0c,0x15a3fb6d,0x037f1111,0x159e13a8,0x093118e2,0xfed3fcca,0x1fc9fe6a,
0xf78e21c0,0xe7c7e02e,0xe322e454,0x12b1eae0,0x1b672e51,0xff880803,0xec2afca6,0x071cf017,
0xe908003c,0xf18aebfb,0xf32cf498,0x207b04cb,0x2edf2945,0x32ee29ba,0x0ebe2c2e,0xfdca0c7e,
0xfa3cecc2,0x2c930c5e,0x420f2581,0x58af7798,0x10c82eb0,0xd343e9ac,0xe7fadcdf,0xc2c3d41a,
0xcbcdbdea,0xb186d0b1,0xcd5ea9fa,0xe901d8f3,0x0a3ded80,0x0fcb159c,0x0e751008,0xefe9000b,
0x074ef5c9,0xf0d0f6bc,0x197b0ca4,0x0c160d4e,0x0fb0ff3b,0x088905d7,0xf9c81361,0xe091e14d,
0xe728e1fe,0x1353f081,0x14ee2208,0x090f13b5,0xeb7bf972,0x03d7f1b9,0xeb4ffe52,0xe937ebd7,
0xebd0dec0,0x257f04a2,0x277e2dc6,0x25d222cc,0x16ce33c7,0xfd1f0c69,0xf58af266,0x1aa8f6a8,
0x36972963,0x628a6b2e,0x2583345b,0xdf5ef585,0xe324de41,0xc89dd76f,0xd283bbdf,0xc2c3e157,
0xc4cfa9b1,0xd80bda6d,0xf3e0d83a,0x14bd19dc,0x0a7e10d1,0x049c116a,0x065ef47f,0xed76fb0c,
0x1274ffc4,0x1f7c1b6c,0x208f098c,0xf6911d74,0x010802d3,0xe6d1eb8e,0xe806e160,0xf861e6bd,
0x1d8c15f9,0x17a316f5,0xfaf9ffdd,0x089bf2f6,0xf2ed0bfb,0xe6a0e92c,0xdd51d822,0x20d8f5d6,
0x287836a7,0x1b370fea,0x1c273b67,0x028c03d2,0xfd2a014b,0x032fecbd,0x2cf5272c,0x571c4c74,
0x2bdc3f93,0xed7300ba,0xda95e75f,0xcf16d716,0xd1acc2d7,0xdfade568,0xb738b8ef,0xc9c0d608,
0xe9fdc8e0,0x107c10a5,0x0b9507cf,0x148f158a,0xf9eef831,0xf179fdec,0x15b5f950,0x2a81212e,
0x1f0c0c9a,0xf3d91ee9,0x0189fa5d,0xf08ef51e,0xea37e2f7,0xf6e9f295,0x19ab15c9,0x1d691176,
0x07f408b7,0xf528f5f6,0xfb560962,0xd706e174,0xe18dd507,0x1faafeb9,0x26dd3b42,0x1ad31317,
0x1d5b32e8,0x0379fcaf,0xfee50405,0xf4faeecc,0x33392059,0x4d6735a0,0x2d86398e,0x030e21fb,
0xd609eec4,0xd946ce29,0xd396c51c,0xe945dea9,0xbd2add04,0xb659c326,0xe013be77,0x0059f8cc,
0x0d48fe8d,0x179b17ed,0xea75fb6d,0x04fdf9f9,0x0dbc0272,0x2c7821bf,0x0e431b53,0xffab17c0,
0x01ddf5f6,0x049f0931,0xe02aeef4,0xf2e0f30f,0x115a047b,0x202a0677,0x06371ae7,0xeb44f51e,
0x09f800e4,0xd1bde541,0xea8ed677,0x20b90708,0x23062d04,0x124d14f7,0x0b781d87,0xf7c7f94a,
0x06a8082b,0xf60ef936,0x34a61659,0x4150380e,0x20a7310b,0x12352961,0xe830f8af,0xe698d407,
0xd944d9e7,0xee5fe6dd,0xd251f509,0xaf50bc0c,0xccafa66d,0xf8d4de33,0x04fdf80e,0x17ff1b93,
0xf74305c5,0x1d7200fe,0x17d41e9b,0x1e4f2826,0x0b5d1435,0x03310a2d,0xf55ff5d9,0x18840d34,
0xe48bf0eb,0xf975f08c,0x0ecbf841,0x0cfa0130,0x03dd2203,0xd972fd8c,0x0e9fe47e,0xdf7afc2f,
0xef7dde5f,0x16c50323,0x20fb20f1,0x14670f3a,0x0d97195e,0xf3b3fda9,0x12240cb7,0xf91b025c,
0x27e40d2e,0x1f982f53,0x1bfb1cd5,0x23d92ecc,0xf6870124,0xf641ed4c,0xe1fceeb0,0xfdaff34d,
0xd878f6dd,0xb0b0bc9a,0xb0b2a43f,0xde33ca58,0x02a0f0a3,0x1e831bb7,0xfbe705af,0x20ec06b9,
0x15801f48,0x1b87238c,0x08ed12c5,0x173e0e3a,0x0654028c,0x14070fef,0xedc7064a,0xf33fe59e,
0xf46dee85,0x0015fa85,0x0cc21f84,0xe79eeea9,0x105de7af,0x04b91c7c,0xffa2f679,0x09c30e76,
0x146008d1,0x029e0ebf,0x041dfd75,0xf20bf989,0x18f30557,0x178f1844,0x29731c6d,0x01e7278d,
0x0ad30319,0x20781da4,0xfca6fe2b,0xeb200076,0xd6caf043,0x0140e462,0xe69ef1e9,0xaca4c195,
0xb0a7b1d3,0xd5f1bcfd,0xff62ea8d,0x0fe10482,0x03f60b29,0x1b3b1121,0x17722137,0x31811dca,
0x1b202462,0x173f11b2,0x0d451960,0x1c1609e6,0xf32208b7,0xe524e2a8,0xef71efb9,0x08f6fd28,
0x165619d5,0xea93f517,0x0174f168,0x18f61aed,0xec00ec56,0x0667050b,0x08ecf9ab,0x03441055,
0x0335fee5,0xf3ce075f,0x054efd7e,0x1d9c1602,0x2aa622c2,0xfadd209f,0x086cf871,0x20891d4c,
0x1a710a25,0xf3871586,0xda10e472,0xeeafd70f,0xe15fee41,0xac51cdc3,0xb34db581,0xc7fcb371,
0xebfed678,0x0314eb07,0x0a5512de,0x1a9e0ea5,0x1cb1264c,0x31561601,0x20dc3a37,0x210e13e8,
0x21c6328f,0x0ae505d3,0xf4400f06,0xe738f0d3,0xdab4ed54,0x0b42e4fe,0x10c41bb7,0xe6e3f0ae,
0x0aaa043c,0x21471e58,0xf9550555,0x0af91750,0xf586ec6f,0x0356ff7b,0xfeb3009a,0xf6aa0bca,
0x022ef687,0x254a0f6b,0x2bca2a75,0xfc661996,0x0092e8f2,0x11bb0f1b,0x151b1375,0x09881cd7,
0xd4e2e95e,0xdbaec32b,0xd812ea92,0xc068dac6,0xbf8fb9d3,0xbe5abc01,0xdd48c40b,0xf173e419,
0x10ad117b,0x18d106de,0x26f629f6,0x2fcc1c86,0x2d703b76,0x1a49204c,0x2742300c,0x01e0fdb7,
0xf2e90877,0xebd7f6a3,0xdbcbec92,0x1155e023,0x0e1c1ee1,0xf4d1ffcd,0x0cce0309,0x1d5d1129,
0x07dc13d9,0x185b11ef,0xe1f2f8bf,0xfd7eeeee,0x0f6c10b0,0xf24f036e,0x0042f64b,0x119fffc4,
0x2bad1e9d,0x12b925f1,0x02fbfa3b,0x181609e5,0x0d2a21e0,0x19621e82,0xd696e895,0xba69ba2a,
0xd5a9d18a,0xce20de9e,0xd10fc36d,0xca9dcba8,0xc011c1e4,0xebc4d643,0x0616ffc5,0x1baafd6e,
0x2edb22df,0x27df2c5f,0x42803bf9,0x19492c46,0x25cf1d8d,0xefff01eb,0xef8a0216,0xf185f20d,
0xe5aded59,0xfb27dfb2,0x11de1202,0xf743050f,0x0a6dfaf8,0x21e815c3,0x174c2d6e,0x1f631167,
0xd3f3050c,0x00e2e1d9,0x182a1409,0xf5ea0002,0x06bcee62,0xfda90347,0x1fe01800,0x28532ff0,
0xfc9604eb,0x0d0a05af,0x0a1d1d48,0x237c1137,0xca78ee11,0xa82cc284,0xdb44c4b9,0xe8c7df16,
0xd34ed060,0xca32d64c,0xbcc3c06f,0xde8aceb3,0x04bcee80,0x1dfb1084,0x383627ae,0x30113fb1,
0x4fc63d95,0x0fcd3c90,0x16a40935,0xf83b03fa,0x04440641,0xfaaf0067,0xfad6f712,0xec77f1d6,
0x0a3206bf,0xec72f7db,0x06a9efa1,0x1d6b1729,0x23e22d38,0x263416fa,0xec571a47,0x00ece922,
0x07110d6b,0xef07f841,0x058bec6e,0xf524fbac,0x0d6a08f7,0x33763a8a,0x08a91bd3,0x001efc7a,
0x0aab0bf0,0x1c7d06e0,0xc355f1a4,0x9d35b57b,0xd01ab77c,0xea8ecb8b,0xd1e9e023,0xcba0d3dc,
0xc7b6cbc2,0xd26bca34,0xf1a7d571,0x20611703,0x39aa356c,0x451a4976,0x59c75064,0x1bc13e17,
0x11460716,0xf33a055d,0xfc35f694,0xf11ffa17,0x0608f9cd,0xf2d0fe4e,0x13dffd84,0xf8890953,
0x076af3f0,0x177918a5,0x27aa284c,0x190b19be,0x00931497,0xfb1cf643,0x074b0b02,0xfcdaf93c,
0xff28fefd,0xeb96f4dd,0x08deff70,0x36ed258a,0x1f232b3e,0xf5a8fdcf,0x05d5fbcd,0x096700c7,
0xc954ecf1,0x9ea0adb7,0xc3aba7d1,0xefc8d469,0xdc3eec86,0xe210de38,0xd0b1df36,0xc15cc797,
0xe411c2ec,0x21f20b2c,0x387d2df6,0x53004883,0x596c5788,0x22ed3c16,0x08af199f,0xee2bfed0,
0xf015ee96,0xe3a5ea73,0x0159fa25,0xf4a503b3,0x05ecef66,0xff070a23,0x0664fd0d,0x1beb1f24,
0x28031c2a,0x1fa926e1,0x109d190b,0xf7faf854,0x07ed0198,0x0dc00cb8,0xf19501e6,0xfad2f4ea,
0xf93ffe1f,0x296d158b,0x1e792fa1,0xf9d2071a,0xff4c02de,0xf175f7ea,0xdeaaec74,0xb2bec432,
0xb3e6a916,0xdf64ca7a,0xee61f31f,0xef11e4dd,0xd34ddcde,0xc0b0c7dd,0xde49c47b,0x1bd70809,
0x36b61fb8,0x59f34460,0x56935ba1,0x1e143975,0x063213e2,0xf0b001d3,0xdfefdeb4,0xee27eb29,
0x025cfabc,0xf9230695,0x05c5f690,0x07ba0822,0x025805a2,0x07a712b1,0x263909b5,0x33b72de5,
0x20f83c93,0x03610dd4,0x13860255,0x03870baf,0xf72d08b2,0xffb9f2ee,0xf6d00682,0x16c10b5b,
0x37542806,0xfe462066,0xef90013e,0xd5a2e4b8,0xd7d0d878,0xb6e2c53b,0xa5aba981,0xe83ec387,
0xfa59f68f,0xefebe3bf,0xca94e04b,0xc2c8c783,0xd757ca1f,0x14dfee83,0x3437258a,0x61734adb,
0x5cd86d1b,0x18903c07,0xf31c052f,0xf65bf192,0xe52be408,0xec0de472,0xf4f9ecb7,0xfa16fa23,
0xf91ef5ce,0x0b1402d1,0x0cf90e4d,0x108e0f4e,0x1cde0e73,0x409c34e8,0x2e70476e,0x0f5412ed,
0x11600ec3,0x0436134c,0x0afe0512,0x002af9e2,0xed00fbba,0x1604fce5,0x35f923d0,0x10ce2b7b,
0xecd3fe57,0xd772dce9,0xd97bd6fc,0xc0b3c68b,0xaf9cc34d,0xc168b007,0xfec7e809,0xf7a5ec30,
0xd2b7ec43,0xd0c8c9c3,0xd4fccd79,0x08d5dc8a,0x32833242,0x55e939d4,0x629a6194,0x24c345e7,
0xe4c40459,0xeec8d29e,0xd5d4eebe,0xdf64d5b6,0xee49ef0c,0xfc77effa,0x034df60f,0x0c3707bc,
0x0eb81319,0x1e0b10c4,0x1fe819fe,0x476930e0,0x3bb752ec,0x1a141747,0x0d910cb7,0xe8ef0536,
0x1561ebf5,0xfd2f0ad7,0xee67f3e5,0x2382096e,0x42b72ac7,0x12073c7e,0xef17f790,0xd9ffda7c,
0xc6d7d27a,0xbbf2bfd7,0xd04ccdcf,0xb70eb0a8,0xf459db9d,0xffe9f953,0xd608fb4f,0xc97cc260,
0xd43fd026,0x019ddda2,0x2de42b46,0x4a072b71,0x57b3587e,0x208b4718,0xe8f3fb72,0xf3fcd013,
0xe693fd1f,0xd7d3dbef,0xf231e9b9,0x0283f60e,0xf326f71d,0x0ff90d84,0x18cc20c8,0x1c770c15,
0x284c2ae2,0x447f2c59,0x50805844,0x1a541979,0xfe75134f,0xee910743,0x08fbe4eb,0x088e03b0,
0xf069fafd,0x1386ff47,0x3111256b,0x0fe42d57,0x0093f736,0xdc2cf30c,0xba5fc56c,0xd047c062,
0xdb57dedd,0xac7fb94e,0xddbfbb82,0x074eff8a,0xe0d20629,0xca1ec74c,0xd642c975,0x002fe8e3,
0x25b02103,0x3e982332,0x46d046a6,0x1b2a3f77,0xdff9fe45,0xed45d9e0,0xdfecf7b4,0xd402d761,
0xedcbdbe3,0x019ef42a,0xf2120107,0x153711ca,0x22b917d8,0x140a18cd,0x3435292c,0x434835cd,
0x57f1551b,0x11f03a3f,0x01341257,0xf54807a0,0xefa7de49,0x008300b5,0xf6d10140,0x124df9e6,
0x2f2b2c16,0x18181ddd,0x074906ce,0xe890fb49,0xbae5c9df,0xce07c44f,0xdff5ddd6,0xc0a7c585,
0xc530b91b,0x06f1f7ab,0xecac02c0,0xd5a8cfc0,0xd05bc12f,0x0847ef9f,0x2f501ddb,0x3e753001,
0x32603f85,0x1a2d373c,0xeb4f07cf,0xdfe0e54c,0xe382e700,0xce89d5f9,0xebe8d328,0xfd2cf8e4,
0xef1e0016,0x09a1fea4,0x2ca8156e,0x12bd2428,0x333622af,0x31333639,0x5260476a,0x13a63aed,
0x08e90cbf,0xfe3d09bf,0xe05ae62b,0x096cf900,0xf9da0c43,0x0da00193,0x31021c02,0x21a4224e,
0x06a42109,0xea51f82b,0xd0bae093,0xc152b6b6,0xdba2cce4,0xb911cd4f,0xca17b5a4,0x06c4f532,
0xfc56fd27,0xe10fe559,0xd3efd45d,0xfb88e8fe,0x28b91951,0x23011fe4,0x351a3376,0x19b83305,
0x05df0e3f,0xe784fc9b,0xdccbdac9,0xd3c2d762,0xde0fcac1,0xf469edd4,0xfc5603e2,0x038bfa77,
0x27540d16,0x157b29f7,0x29d11e73,0x2ec6326b,0x4a0c362e,0x1f543f27,0x11bf173d,0xf72d033d,
0xf0daf00e,0xffb0ff0a,0xfb930393,0x0ee70581,0x28dd1a2c,0x247f2809,0x0e172d78,0x02d8fb6c,
0xddb70005,0xa428a001,0xd797c17a,0xc04ae01b,0xc412b84a,0x0014e1b9,0xfcdbfb04,0xe6f1f6c4,
0xdaabe8f7,0xfd09e256,0x321d21ef,0x026b1a31,0x3441267c,0x25b43247,0x124c0f76,0xe4bdfecd,
0xd0e7ce87,0xd4c7e086,0xd3b4cbc8,0xf6d4dd8b,0xfb330249,0xf844f31e,0x22700ceb,0x1cec2778,
0x240c1d65,0x2e36253a,0x40852d38,0x2aa03c99,0x1fa5244f,0xf8a9044a,0xf372f2a3,0xef27f3e5,
0x0727f37f,0x0f9d0f38,0x1b2f1263,0x24632322,0x18d132ca,0x11210752,0xe79efbe4,0x98bda760,
0xd81dc3cb,0xd464e6bc,0xc88cbb7e,0xf83fd7c7,0xf40afb78,0xf4aff7a6,0xdfffebcb,0xf62bda7f,
0x24191181,0x0016101e,0x29b819a6,0x2aa331fb,0x1a551ca7,0xeaaf03ed,0xc4eed69e,0xd87ad882,
0xd9a1c9e5,0xfa15e407,0xfed507d2,0xf316fb63,0x13df0180,0x298a26bf,0x235627c4,0x1f6f1749,
0x28de23ab,0x35ea382b,0x24e63134,0x01c90b97,0xffa7064b,0xe44ef26f,0xfb08df66,0x18d414be,
0x0ed5152d,0x2d5121d9,0x26162cbd,0x1e491562,0xd8abfb77,0x922abc78,0xe307bf06,0xec8fdf12,
0xc6fac701,0xf4f0e113,0xe3bef379,0xf873f2d5,0xdec8e15c,0xeaf6eb41,0x1642007c,0x118f1fd5,
0x3af52109,0x2f83395d,0x1c6c20fd,0xecb2014c,0xca41dd49,0xc1a5cd5d,0xd78bbd1d,0xf93bdf73,
0x08bd1551,0xeaeaf9b9,0x141af92d,0x2a271b07,0x20952f02,0x0ef70ee0,0x25501d13,0x322228df,
0x215b349f,0x0bd91a62,0xfebf06a7,0xe023efe5,0xf0f1e10c,0x17a910be,0x13900cd5,0x20cd1c0b,
0x3ce63e57,0x14eb213a,0xdc44fccc,0xa595d5b4,0xddcabaa6,0xea15db57,0xc942da95,0xe6c4dcac,
0xe472eb1d,0xfdfdeb86,0xe2c3e764,0xdf62e8b2,0xfbd0e94a,0x229518dd,0x39581ef1,0x2c163ac4,
0x2227251e,0xf14b0e4c,0xcbcddfb4,0xc1d3c2f7,0xd344bc13,0xf629de58,0x026510ba,0xf625f786,
0x196802b9,0x21b21bb7,0x1a72286a,0x0a3710a2,0x1ca50dfb,0x28a61f3f,0x34bd3d87,0x1e102b24,
0xf6e308cc,0xe296eccf,0xec44ee92,0x10fe03da,0x0554f8ae,0x24cc1c3e,0x445747b1,0x167b1ee7,
0xecb4087c,0xaccbd908,0xe331afcc,0xdebfda03,0xd998e68f,0xdea7e19d,0xe517e567,0x02a0e253,
0xd8e3f4a5,0xd25be091,0xed40e161,0x28c513e8,0x34b026e8,0x2b9d39b3,0x2b1b2db4,0xfe6517d4,
0xccc6e72b,0xc5a7c412,0xca01b580,0xf47ed90e,0xfa140f01,0x0321f335,0x18b2104b,0x2426281c,
0x16982125,0x001003ef,0x17b50907,0x223b180e,0x44ba3468,0x240437c7,0xf47ffcc6,0xed1aed60,
0xf55ff903,0x0b17020e,0x01caecd3,0x2500229b,0x4be64e17,0x0f3f2865,0xffb603b7,0xbeaedfc8,
0xd659b0b5,0xcc74de4e,0xeddcdf1f,0xe331de3a,0xe0f9e32d,0xf301e5dc,0xd76af608,0xd509d840,
0xe178d6b6,0x30be0f5c,0x304133ca,0x2b433422,0x2c662cdd,0x0fb41aac,0xcbc5eb6f,0xbcfdc37a,
0xbca1bdf8,0xe784d5c1,0xf6d5f3f8,0x1260fa63,0x1d561934,0x21b02090,0x15f01d00,0xfc1c065a,
0x104a0747,0x1a2d1d58,0x4c7d2662,0x23483f5d,0xef2f0730,0xf49de8c2,0x04190218,0x027df681,
0xf800fbfb,0x2d5617e7,0x45f039c9,0x2a0a3508,0x00ee1ba4,0xd6ebe8eb,0xd069c30f,0xda19d54f,
0xf3b9e134,0xd51fd86d,0xdceedf84,0xe659e2a4,0xd82febf7,0xd00dd077,0xef4adab7,0x37c2111a,
0x335741f2,0x2ef12a25,0x2a053257,0x09351576,0xd9b6f821,0xb974d138,0xc634b927,0xdd9cc5a8,
0xf8edf09e,0x14d1fa8e,0x172a17c6,0x194518a6,0x09391669,0xfad7020a,0x0760fcc6,0x152219af,
0x3bbe1833,0x207b3ae1,0xfbd31642,0xf490f375,0x0383fd3f,0xfe4ff337,0x031e0673,0x25081544,
0x4cfa2c99,0x37bf45a1,0xfed61a38,0xde99f1b9,0xcb46d0c0,0xd461cb4a,0xf453dfa3,0xd498e4dc,
0xe135ea3c,0xd07bd84f,0xdcafe2f8,0xcb21d1f8,0xf3aad013,0x2aa70bf0,0x41e13e48,0x32e436de,
0x2eb82e00,0x04a114dc,0xe83ffe44,0xb747d7f8,0xc52bac9f,0xc8d6bb68,0x0309f0e5,0x15eb048d,
0x195d18f0,0x121213aa,0xfe1b0c17,0x0e450594,0x006d0992,0x21850d7d,0x164d167f,0x34b42f63,
0xfec22176,0xf778e942,0x06ff098d,0x04c8f208,0x0cb80d26,0x16481612,0x53e92921,0x39375331,
0x028218ed,0xf3430190,0xd177dddb,0xd3e8cf49,0xeb71dd4c,0xddbeee9d,0xd99ddbf9,0xd431d4b6,
0xe498dffe,0xd1e1db5e,0x046cdcb6,0x24711242,0x3142358a,0x325c37d1,0x2cbb2f92,0xff6c18cc,
0xf2d403ad,0xcd40e963,0xcf0cb75d,0xb86ac352,0x0257eba3,0xfef40231,0x13e5073a,0x00370f31,
0xf4bbff60,0x1171fbe8,0x0b5f108b,0x08a1ff67,0xff3d0e17,0x33911845,0x0dfa26d0,0xf372ed8b,
0x06ec056d,0xfd8df3ba,0x17cb1186,0x09a50f7f,0x4e51276d,0x3d3a5440,0xfc19226a,0xfef4008f,
0xd3a0e5be,0xdc33d3ed,0xd537de28,0xf2dafa39,0xc831e76c,0xcd08c502,0xe433dd7f,0xde4ddca3,
0xfdfde777,0x1cd713ea,0x2b4b2366,0x4f5f4402,0x31cf339c,0x07731e83,0xf8ae04c1,0xd8d0f3e3,
0xbb81b0e8,0xbb1bbb55,0x073dddb4,0x03ca1219,0x136c0a52,0x09c10b53,0x08ff0c90,0x0a14042c,
0x0a661782,0xee96f495,0x06550e19,0x2bd71234,0x1eb92436,0x02130d65,0x0bfd125b,0xf436fa5d,
0x1a110a0e,0xffdd07fb,0x331a1e5d,0x3f364107,0x09982ef6,0x0d0406a6,0xc90fe36b,0xd279c94a,
0xcc91d8ea,0xff7becc0,0xc6c4e597,0xc73ab683,0xd6a9de32,0xd61bd2dd,0xf2a6e3a1,0x19d20ca9,
0x28331bef,0x57464a9c,0x2e373907,0x145d1df2,0xf84b0628,0xec5ff302,0xb2cbbaf1,0xc0a7b6fa,
0xfcc6e39f,0xf7790dad,0x0e3fffc3,0x07a20246,0x112d06b2,0x0387102c,0x0a911154,0xf450f654,
0x0ea502f5,0x1a6901f4,0x1cfb2d12,0x08d5163c,0x0e600f4d,0x018e0937,0x1e8707e2,0x102a166f,
0x23221482,0x4015339b,0x203e37f5,0x06d009e3,0xd54bebe8,0xd73ed6d7,0xcc96d412,0x046ae360,
0xca63d812,0xc2d2bace,0xdc43e695,0xd806d483,0x054ff36d,0x116d11dc,0x291018af,0x4e4f4d21,
0x2bb53aab,0x1a311ef1,0xeca9036f,0xf1faeaf0,0xb2ddcdad,0xc30bb4d8,0xed18d7c6,0xf562fd93,
0xf694fc83,0x0beaf910,0x129b13fd,0xfc900bc3,0x03920a46,0xf757f705,0x12ccfa97,0x0d7cfe2e,
0x21212575,0x0a741f9d,0x0d5d0e7b,0x01b00439,0x1a6106cd,0x06be16a3,0x269c0ef9,0x399f31f0,
0x2a29315a,0x002a1624,0xd8dcf0c3,0xe327e80e,0xce83d40f,0xf873d613,0xd324ebbb,0xb99dcca4,
0xdd7dd9e9,0xda3ed2fc,0x03c3e781,0x0aef0ee1,0x2c4b1641,0x52d04b51,0x32413f66,0x14841a79,
0xfdaa12fa,0xf111ef4b,0xb9b8cf23,0xc7c3b5ba,0xdaebd7a3,0x0233ed2b,0xeda2fec3,0x099df9ce,
0x0e64172f,0x00a3ffa2,0x0f7f0222,0xfcf7094e,0x0fb6f502,0x08f812c0,0x23841c2b,0x0c861fc8,
0x11860b32,0x0b2c015f,0x102e057e,0x0c981f9e,0x346d18ff,0x38bb3468,0x20612bb2,0xecb81115,
0xecb7f0ca,0xe8f2f6c2,0xc65cc9f3,0xf200d5e8,0xe153fc52,0xcce8dd66,0xd44fc69a,0xdb13d029,
0xf203e217,0x0a4d02d4,0x340522a8,0x516449e6,0x317b3b76,0x09be17e4,0xfb1d1669,0xdebded69,
0xc056c91d,0xc510b55f,0xdfa2d30e,0x091fef94,0xfb90116a,0x0be70025,0x06ff0da8,0x03e0f55f,
0x0c900519,0xf97f130d,0x0888f3f8,0x0a841add,0x1d9b0e05,0x19e51f55,0x0a0e06c8,0x059df8a9,
0x0219fec4,0x17561340,0x33db210e,0x25ba2da7,0x1f332373,0xeade13cb,0xfe54ee38,0xfad202d0,
0xb90fd23a,0xe742d76f,0xed83f1ff,0xdcc1ecac,0xd095c2a1,0xd02dd27a,0xeab5d1e4,0x164706ed,
0x2a7c1ffd,0x529b41b7,0x29f14351,0x0cc21450,0x123326ec,0xdbfce8c7,0xcacece9c,0xb22bb1c9,
0xdc5cd293,0xfe3de720,0x13ff17d4,0xff1ffbbf,0xfbff0914,0x035bef2f,0x0ac70b7b,0x00f11759,
0x065efaaf,0x13931423,0x17bf05e1,0x23ae2907,0xf99407b6,0x0965f9c7,0xef44f17e,0x1f6c1200,
0x2754235b,0x1ec22e3a,0x1eba1f7c,0xed430cd8,0x0681ed31,0x02e70e1f,0xc66ddf10,0xd70dddd7,
0xfdbfe580,0xe706f2a1,0xd247cd73,0xbda8d6ca,0xe7b1d0a9,0x10f502b7,0x2a621d79,0x44e93b29,
0x25443bc9,0x1c951fac,0x1a1f1f9d,0xdbbbe81f,0xc938e92d,0xa6cbaad6,0xe646ca1a,0xfec9ea7d,
0x1ae71c18,0xfd88012f,0xf9acfa59,0xfbdaeb60,0x079e1204,0x0dfb07fb,0x0f700373,0x05f80abf,
0x21f201f4,0x1a8a3437,0xfafa0e5d,0x05a70eec,0xf8afe821,0x2a941f00,0x1c602bc4,0x24c424a9,
0x14a71503,0xef360790,0xfc56e649,0x061609c7,0xd055ebf0,0xee54e502,0x0945ed21,0xe9affae3,
0xda9ce8df,0xb039d1e3,0xe55fc169,0x152cfa97,0x2d5c2572,0x35553bf9,0x32802ef1,0x1e9a29e9,
0x18c1145e,0xd752f604,0xc88ed472,0xa30cad01,0xdf9fb327,0x1c6afa8a,0x287f2d66,0xf68f0f32,
0xf86ffc9b,0xfb09e9d8,0x089910c7,0xffb0ff63,0x0700029a,0x0ed207b6,0x28e815f4,0x208b30fb,
0xffde15f1,0xeefcfef3,0xf5a4d5a2,0x23001c4f,0x11bc22d6,0x19ac0b48,0x13ca17bd,0xfbf7059d,
0xf4e5f19c,0x0721fbb7,0xdc480651,0xf085d9e6,0xf945ed18,0xfba006a6,0xd8edf3df,0xbfa2ce5c,
0xd2b0b523,0x1d4bf03d,0x27cf2e98,0x31c3339a,0x2ee5277b,0x1c2e2572,0x17e21476,0xdb760ab6,
0xd8e9d5a6,0x9454b260,0xf0a4ac9f,0x1f5915d7,0x22dd2604,0xfa511498,0x0088f9db,0xead4ea23,
0x07ff14f9,0xfba2f0ea,0x0e4d11f1,0x1724078b,0x1ebd1a8e,0x16f02234,0x04da1608,0xf40dee10,
0xf1dddb69,0x1415109c,0x030115d3,0x12cbf68d,0x0d3b20f8,0xf552004f,0xf30cf47e,0x09270326,
0xebfa0efb,0xf7bcdf80,0xf568ff97,0xff6803aa,0xe828f733,0xd191da78,0xc497bc29,0x19dee99e,
0x21263373,0x2349224e,0x1cf71bbb,0x11011258,0x280322fe,0xe54b1392,0xea0bd704,0xa018cb44,
0xe70ab0e1,0x19301737,0x1d9b1186,0x0fd31d55,0x03f1fe2c,0xe6ecef3e,0x08ae0794,0xf9d3f782,
0x13791011,0x1c5c0ca4,0x0bb11cd9,0x0c090c90,0x0cff1b6d,0xf15ee3d7,0xdebaeb9d,0x01bc01da,
0xf087fb76,0x12caf240,0x0dc72959,0x04720b0b,0xf2b2f7fc,0x0cb3f7cc,0x02a7173d,0xf8bae442,
0x00a5051e,0x02180227,0xed1afbb7,0xddfbe9b4,0xb7f0b7c8,0x0e3fde43,0x1825312b,0x1f111046,
0x195915b5,0x0fe9065f,0x27a827ff,0xf6c41af3,0xdec4d799,0xad84cfea,0xd991c5c9,0x12eb081d,
0x2263026e,0x186f2bce,0x08180704,0xf026faee,0x009dfb42,0x02440590,0x1b1a0123,0x1ab615db,
0x05a81c11,0x0a130ac7,0x10d90975,0xe86af0f6,0xde8febd8,0xf326ec48,0xe071e0e1,0x0e58f2cf,
0x1895291d,0x08620b64,0x050d052c,0x126bf898,0x10ff28d6,0xfc97f659,0x1b98167b,0x01f1061e,
0xed15f258,0xd8b0f0e5,0xbbe7bdf4,0xf2ede45d,0x15631428,0x28bd12f3,0x149f2242,0x18530b01,
0x26cf2f0f,0x0d651d00,0xdbb3e2be,0xbdd2dbb6,0xcfcac0f7,0x1303f37b,0x15ba07f9,0x1c8c2638,
0x09e41121,0xf11bfe53,0x00e7f4b5,0xf0b2f8db,0x167cfc7c,0x18341a85,0x03360aea,0x089b0d25,
0x09300443,0xe3fbf71c,0xe6d9ed41,0xd311da73,0xdfd3d0f4,0x022cf063,0x17df17a0,0x151f1be0,
0x03c305a2,0x11abf875,0x13a52f24,0x09020511,0x247e186b,0x01800461,0xe72bf714,0xe647f361,
0xcb87db39,0xdb2bd2be,0x0bb0e8c3,0x1c821660,0x0bf926d3,0x106708bb,0x27a01bd6,0x16dd2345,
0xe80ff2f3,0xd1bde215,0xd265c587,0x1647de53,0x035a0cff,0x290c1e53,0x1e472b2c,0xfc99098d,
0x0501f756,0xe5cbf814,0x0a37ffbc,0x066a0b84,0x0acc02e7,0x1ad71738,0x0a910d26,0xed920205,
0xf35ef456,0xb84dcfee,0xd468c698,0xf68be75b,0x16d901f7,0x1cc0269e,0x08140bd8,0x14390a4e,
0x1fed279a,0x08830de2,0x15bb08f2,0xfc060230,0xe466f817,0xf4d7e985,0xe00ef651,0xca03c6f1,
0xf450d4a8,0x1f5410ab,0x1ac92cfc,0x0494fd0f,0x174d17d2,0x1c17173a,0xfbfb0a1f,0xd34de937,
0xcc84d023,0x096ee077,0xf76aff9f,0x25b80f62,0x242e2667,0x138724d1,0x06b90249,0xecf3011a,
0x076bfc43,0x041604c9,0x1395f97e,0x252d34d5,0xf717096f,0x0050fe7a,0xf298f651,0xa748c907,
0xcea1b5cf,0xf22fd8a7,0x17fafcd3,0x24df29aa,0x183e1a61,0x19b2158b,0x2ad52f3b,0x06c30c3d,
0x19930c4a,0xeb7706ad,0xe055f3b4,0xff78e9ac,0xf9ddfe63,0xc038d2cf,0xd719c164,0x1a0ff5b3,
0x1d9c2eec,0xf153f472,0x186e17a8,0x120a0e83,0xffbf0ea5,0xd273eb8f,0xdf0bd713,0xf4d7e245,
0xeeb4f8e6,0x209ff687,0x22682d16,0x29e3358e,0x0c290bef,0xfadb077d,0xfbb8f136,0x0c1203ab,
0x08770369,0x2bfe3aaa,0xec2bfdcc,0x07e60104,0xeb2bf6b3,0xa389d1f5,0xceb5a9c2,0xe831e2ca,
0x118fef54,0x23bd279f,0x26782382,0x1dd024f2,0x35902491,0x106e26b6,0x181e17a3,0xe0da023d,
0xe627dbdc,0x03bdf1fa,0xfb9301b8,0xc856eb7d,0xd540c521,0x1c91f59f,0x1fc22a44,0xe2faf464,
0x0f72105d,0x0a6b0414,0xfba50f1e,0xdbeceb20,0xf7dded27,0xdfe1e36c,0xe8eff1b2,0xffa3e217,
0x27432915,0x37a537f9,0x0f981a44,0xf84d072c,0xf3b4e603,0x012004c6,0x0cdc0152,0x3e15292d,
0xe4fe0a3b,0x05a3fa81,0xdccaf708,0xa88cc8d0,0xca71a26b,0xe9bfe6e7,0x01f2f5a6,0x289b266d,
0x28ca1f24,0x25062090,0x28e9261c,0x1ee3274c,0x14582381,0xea58fcf2,0xf247d7c5,0xf25cff47,
0xf225055d,0xde85f7b8,0xdccfc7f7,0x0f68f20a,0x237f1f54,0xf1081007,0x0568fd71,0xfbdef8c6,
0xfc47f2c0,0xe979fa56,0xfd95f331,0xe69ef4db,0xffaaf2e4,0xf8cdee88,0x29f222dd,0x441e32fe,
0x245b3697,0xe98f033f,0xfd96eb12,0x01630536,0x0f2903c0,0x2a451e1d,0xebfa1c12,0xf4f7edba,
0xcf8dea37,0xc504d2f2,0xc4acb2fa,0xe204ddb2,0xf7a6f666,0x26670ae4,0x21412047,0x1e7b283a,
0x28382831,0x3f1d3684,0x0b07310e,0xeb11f27a,0xebd9e0f9,0xf06706dc,0xf14cf1b2,0xed1cf0dd,
0xd9a1cb4b,0xee19e8bd,0x233d04eb,0xfd441f02,0x0006ec7c,0x0085feed,0x0299f719,0xfd171744,
0x04d6f488,0xec5003cf,0x04abe4ca,0xee20f906,0x1d3307dc,0x3f2b29c9,0x1f0f3d4b,0xfd9c085b,
0xf905fa2f,0xfd79fca6,0x11e702ae,0x2c8020a5,0x01de2c2a,0xd7a8e1bf,0xc3a6d416,0xc966cf44,
0xba28b0c3,0xe649d1b3,0x08420256,0x12f10cfe,0x1b081b42,0x0a7616b2,0x30be200a,0x3e4a3e2c,
0x165f353f,0xe6acf3e1,0xec9ef48b,0xee53fd76,0xf9ffe492,0x0027f2d1,0xdad3e47e,0xe8f9e857,
0x1881fcc0,0x036e1df0,0xee6fe50d,0xf690fc19,0x0c3cf786,0x00fb1d50,0x0b45eb13,0x01a91b14,
0x0423eda1,0xec4906f8,0x153afc1d,0x33931b72,0x194a34e9,0x08781044,0x03ae0163,0xfc3f0305,
0x0993ffef,0x2f852067,0x079f30a2,0xc9d2ceb6,0xc0c8ca95,0xd72bcffb,0xb6f6c657,0xdeb6c6c2,
0x0bb1f8bd,0x1c741083,0x155f1edc,0x01ac0e65,0x2fd61589,0x408e46e1,0x2133339f,0xe5f5fadc,
0xfb18f314,0xf6790205,0xe90ae8a5,0xf794e578,0xdf7ffc29,0xed7be60c,0x1265fbc2,0x0e0f2092,
0xf9b3f2f6,0xfb3a01eb,0x0426fd39,0xf7520518,0xf0f9d8df,0x09bc17ba,0x0015fb2e,0xf6f90b87,
0x16e7f147,0x271c206e,0x21cf34c6,0x0ba313dd,0xfe9bfe5f,0xefb200c3,0x10adfbe3,0x370826e5,
0x1e563589,0xd084e00b,0xbcd8c0b3,0xcabac90f,0xb62bc8ba,0xdb24b4ec,0x00a6efb0,0x136c1224,
0x1b1e1704,0xfdc10bb6,0x2f1d0e2f,0x4643452a,0x2cd23917,0xe4240e10,0xf360e744,0x011b021f,
0xdd09eced,0xdd08d896,0xf2640220,0xecdfe41f,0x053df781,0x0cb5139b,0x00cd0235,0x08af01d0,
0xff9207b5,0xf49cfe6c,0xe961ebcb,0x0d340aa5,0x0cb10801,0x0b60167f,0x05bdee3a,0x10031169,
0x23de245b,0x07001d09,0x0931079b,0xff3d0b26,0x1ce1037d,0x2fc92ecd,0x1e05284e,0xd89af69f,
0xb9e7c0a3,0xd24cc903,0xbf95d02e,0xd217ae1f,0x0541f769,0x0c000d17,0xff2d087a,0xfc4902c0,
0x379e132f,0x4b033ae5,0x2d3f4536,0xee72185d,0xf534e67d,0xf31cefbc,0xdce9ecb7,0xd885dc2a,
0xf927f665,0xeec4e6c7,0x0369f288,0x17511294,0x02690fe3,0x0160f5fe,0xf82307fc,0xf119edd4,
0xef9df319,0x0f76ff7c,0xfee214d2,0x17700f4a,0xfaa9ef94,0x096a0a1b,0x1bef24a9,0x10de2218,
0x0583fe31,0x00540ab5,0x23d6128f,0x2b1f33d9,0x35272e00,0xddef02b9,0xbc52cc3e,0xc1bdc8c3,
0xbae3be4b,0xc537ab55,0x066df4c3,0x0e610bc5,0x07c50a1a,0x05880b9d,0x4a3222ae,0x465947c4,
0x343e4f7c,0x047f1c90,0xea4be918,0xdcdee54f,0xdae6e7ed,0xe4b1d581,0x002af082,0xe513ea38,
0xf4b5ef23,0x2241118c,0x0b761b82,0x04fb03a9,0xf17ef265,0xf19bef6d,0xe0b0e9ca,0x1703fe02,
0x02091896,0x227e0948,0xec9effcd,0xfaa100ec,0x1f540d53,0x0bf00a8f,0x1167fc94,0x1145281c,
0x212e1500,0x24d52219,0x31ba279e,0xdefc0cef,0xc600d3f0,0xd2d5c980,0xba5fb699,0xb7beaf3c,
0x0d82ef92,0x03a3048e,0xfbe8f629,0x0da113c2,0x3f8416eb,0x426e4546,0x2f574658,0x158d207f,
0xe21cf47a,0xd231d88d,0xf5a8e74d,0xe727eb4b,0xfca4ecd5,0xeffef13f,0xfb99f1e7,0x210c1132,
0x07eb1c20,0x0a4dfc26,0xe157f55e,0xed96edd6,0xea56ee98,0x1f5af9e4,0x01da1ace,0x27ca022c,
0xea38101e,0x06b5fc22,0x1140024e,0x087904cc,0x00e4fb38,0x2156269e,0x22291300,0x21412c05,
0x207817c4,0xea930a93,0xd8c2e355,0xbd6ecd93,0xb664ab3c,0xa80ab723,0x0ba4decb,0xf8b303b7,
0x05b8f0bd,0x145d1d6d,0x383a1446,0x3b1e4e9f,0x3c9f3437,0x15dd3085,0xda0df649,0xcb77d04d,
0x0433e0ed,0xea7d0008,0xe5a2dfdc,0xec04f013,0xf888ec04,0x18090804,0x17dc213d,0x0dd60b2c,
0xd7e8f4c8,0xf18ce76e,0xec6a0252,0x0f52eb18,0x0115160d,0x2373fad4,0x026f2be1,0x02c7f686,
0x026101d5,0x09600ad0,0xf69203b8,0x24bf0c0b,0x1d5b19b5,0x2c9a3f0f,0x0fc80e9d,0x024d0774,
0xe73beefd,0xba01dea0,0xb08fa7b2,0xb0d2b889,0xfb22d65f,0xf8effd27,0x11d0f7fb,0x14402828,
0x2f6c0e4e,0x3e9f4e4e,0x3ae92555,0x17aa33d0,0xdaba043b,0xce35c267,0x0df3e96f,0xeaf00e15,
0xd58cdb68,0xe74defe7,0xfc0fea7c,0x11e70055,0x1abd2386,0x0913120f,0xdbb2f55d,0xee3ce124,
0xf256ffca,0xeff9e9c9,0x049a055c,0x231d0482,0x1ca2332d,0xfbcafb42,0x102402da,0x03100b7d,
0xfb240a0e,0x0956f7b6,0x26601a64,0x3e8749df,0xffff1804,0x05f0fdc1,0xf42dfe8a,0xb9e5e273,
0xb0f4a9e6,0xc809c086,0xf2e3d225,0xff90f970,0x08b4098d,0x1b7c125c,0x2a971eea,0x37e33c34,
0x3214268c,0x258b3878,0xe4ea1384,0xee30dfb9,0x02edf319,0xea970c9f,0xc6b2d74a,0xe283e402,
0xff0de062,0xfc83ff0f,0x1a980f6a,0x0dbb1454,0xe371f71b,0xe920e10a,0xed1cf170,0xcf53d8b0,
0x0673fa2a,0x211b1da4,0x2baf2547,0xf85308e8,0x098e00cf,0x085b1256,0xf66302cf,0x06eaedc3,
0x290f195c,0x48c34988,0x0c982e9d,0x0ee102f0,0xf2d0fe05,0xc661ec77,0xabeaade4,0xc81ab656,
0xdcded119,0x0272f690,0x19cf17c1,0x1af7144a,0x278126a8,0x352328a0,0x1f6830f9,0x161226d4,
0x06551542,0xf9f7ff78,0x0765fef5,0xfbd916b2,0xbf56ce32,0xe34bd8e8,0xe580d117,0xfc4cf442,
0x119b10f3,0x13140e1e,0xfb5c0cc4,0xdfc7ed3c,0xe56fe5ed,0xc713cff4,0x0236df2d,0x1cc61e75,
0x19061fe0,0xfe8e156d,0x1a250ef6,0x06381612,0xf02ff338,0xf164eb78,0x1eea0a94,0x59a53a32,
0x1d6b3f7f,0xf8fd01cd,0xf4f4fde8,0xced7eb3e,0xb231b209,0xc54bb8f2,0xda12d2f7,0x03ccf276,
0x11400864,0x23ef0cdd,0x20e72e9d,0x33472282,0x230535e6,0x160c203c,0x11241a61,0x06970a4a,
0x0566ff7b,0x0c38107d,0xbdc3de0c,0xdaebbff6,0xe79ce9c9,0xebc9f258,0x0de000c2,0x11e50aaf,
0x04db1a45,0xe4fcfbb6,0xd994d282,0xc941cd1e,0x0353dd28,0x22a016d3,0x1d992c16,0x033f06d4,
0x17dd05b9,0x02d01ab3,0xecc1ed4c,0xeb9eedfe,0x0adbf383,0x57a92c39,0x36c06275,0xf18bffbe,
0xfc04fccc,0xd8a7f76e,0xbf28c013,0xb98cbc42,0xdceecaa3,0xf9acf141,0x033bf3c8,0x20500bd2,
0x1e8728d4,0x34e91cda,0x1a582be7,0x237920c7,0x1b7c1d9f,0x0fd01835,0x02560479,0x139c05eb,
0xc41eefa6,0xdd36b9a0,0xe6f5f7af,0xecb9e7d3,0xffa7e578,0x14c40735,0x07ee2069,0xeb4604bc,
0xcd23cf4e,0xcb3ed2ee,0x03d1e1d9,0x2866117f,0x204b34c4,0x035a0d90,0x11c5031d,0x0fd71dcb,
0xf3b5faf0,0xd69be6ad,0xff73dc70,0x52ca25c5,0x45e06c41,0xec4d0b0f,0xf6d0ee92,0xe6aaf933,
0xc765cab0,0xc4eac5d2,0xdd78cf8f,0xefecf090,0xfed1e969,0x16cd0803,0x220f20ea,0x222b17f5,
0x297322e7,0x26853010,0x1f141e6b,0x16201ffe,0x01510bec,0x12c6f9ff,0xccbeff8b,0xdbc1c003,
0xee2602c7,0xde55d96d,0xfeeae05e,0x181612a9,0xfbc90ff0,0xf0740388,0xc1f6d85b,0xcf7abe80,
0x050de867,0x1fa00f88,0x2a5c3ae2,0xfba90cab,0x088df35b,0x19ae21d2,0xf199fe5e,0xd77fe0e2,
0xf907d7ad,0x43732273,0x54c66376,0xf28718f7,0xf144f2ad,0xeabaf84b,0xcbbccdbf,0xcfd8d0dc,
0xd654d7ec,0xe51adfc0,0xf8f1e3db,0x0e490564,0x19291bea,0x104e10a1,0x2e351949,0x34be3e80,
0x1c0c29e8,0x224229d2,0x0dcf18cc,0x114dfcc6,0xdb350b9d,0xe0e1cacd,0xfaecf714,0xda69e77a,
0xf9edde06,0x16121af5,0xf28e0787,0xeebbf1fb,0xc23fd402,0xdb5ac4f0,0x0145eac6,0x26dc127e,
0x3e0f444d,0x06721b55,0xf80ef911,0x20a6166e,0xf41110a5,0xce0fda9f,0xe4a7ca1f,0x456d17a9,
0x595b5a1d,0xfbfb35bd,0xe91eec3f,0xe897e59f,0xcdb5cd09,0xcd15daad,0xdaa8d563,0xdda5db07,
0xed0ed4b8,0x035b0553,0x0db907b6,0x0c69128a,0x293618f0,0x41733dc7,0x1d312fe9,0x1c8a1b14,
0x189c21eb,0x0be1079d,0xe20d116f,0xe3ebd969,0xfae5e6da,0xdcdbe7b8,0xf74cec58,0x118b0ed0,
0xf7d80a64,0xe284e028,0xc230d87f,0xd55dd2ec,0xf74ce83f,0x265010f3,0x3f133bec,0x054b268c,
0xffe0036f,0x23620392,0xf918167b,0xd4efe4bf,0xdcc9c83e,0x477816a8,0x551a52a5,0x167f49db,
0xe6ccf00d,0xe348df84,0xd254da9c,0xcbbfe36c,0xe326cd86,0xdba4dc5b,0xeb86d8c4,0x192f1abf,
0x0bba0e2d,0x0ba80913,0x2ca91809,0x3b393ebf,0x1d272f11,0x09f80e41,0x36ae1ad8,0x19563073,
0xecb61093,0xdac3d821,0xfa4fea6a,0xeb2ff2f7,0xf6fcf195,0x00e70312,0xf8430163,0xc6add0fa,
0xd232d769,0xece5ddc6,0xfe52ef63,0x229d13cd,0x38d3302d,0x0cf73011,0x028d096f,0x02f7f6ca,
0xfbc409ee,0xe2a9f1fe,0xcf55ca40,0x3e95078d,0x561550c9,0x2ac856f9,0xd5a1ff28,0xd890dae6,
0xc91bd801,0xd526d96d,0xe156cfa2,0xd5f8e72b,0xe1fbcf47,0x0830055f,0xeed5fd97,0x0decf4c5,
0x2b9d1651,0x409240c8,0x1fb53273,0xf5bfff8b,0x39f30f3c,0x27d54c37,0x096c0fe5,0xca87e002,
0xee4ae9e6,0xf857f65f,0xffa2ed1f,0xf7bdfd2f,0xf73bf940,0xb6c9d3d0,0xe6c7d04b,0xf084e2f6,
0xfd6cef78,0x20a612b3,0x35ca302d,0x225e3897,0x02000e5b,0xf663eda4,0x0a860bcf,0xf2e80729,
0xd31ad6bd,0x2a41f947,0x4fcd45db,0x35f94fa9,0xd69808ea,0xd318cb8c,0xd23ecc0f,0xe757e3eb,
0xdce0e04d,0xe13ee477,0xeafbdace,0xf810fc1c,0xe6f0f8cc,0x0f4eec0a,0x241120b7,0x389f4330,
0x1c0c2a0b,0x098c1272,0x3b19176f,0x368b53fb,0x031b1196,0xca21e6f6,0xe802da07,0xf148f476,
0xf6a5e2f8,0xf248ff34,0xe387dffe,0xbce2db10,0xfb57d913,0xfff6f81e,0xfb34f782,0x1a6910dd,
0x3586228d,0x28a53f94,0x036112dc,0x0718fccb,0x1de41a1b,0xf99b0118,0xd8efeaf8,0xfb65dd6f,
0x2f1f1d52,0x306d32f6,0xf6ce1e52,0xd54ce03a,0xd65ccdef,0x01a8f9f2,0xe333fd2d,0xd663d599,
0xe451dc1c,0xf1acefad,0xe22de6dc,0xff39df07,0x297d2a5a,0x47b251a6,0x0d212aa7,0x081c0476,
0x1f550f19,0x3f633cf6,0x0ed122fb,0xd8d1f783,0xd271c6e2,0xfdb5f0d9,0xe6cbe875,0x097a0a69,
0xdf37eb27,0xd119e5c1,0xf646d9bf,0xf1f8f287,0xf33bf249,0x0d96062a,0x320d19df,0x49f4457b,
0x17762277,0x08b712a2,0x2ba82588,0xf14205fa,0xe74ff1a9,0xdaa2e024,0x2203f682,0x313e29df,
0x11ca272e,0xe348f2db,0xcc74d1df,0xec61e4d2,0xd1feede5,0xd04fc9f9,0xe09fd72d,0xedb5e6f5,
0xd8bae438,0xee53e067,0x23791a47,0x36082fd8,0x20e037dc,0x1ae714aa,0x0e7509d7,0x3cd02ad6,
0x14ef3184,0xf4bb0709,0xc49cc8f9,0xfff6dbd5,0xe0f0fa40,0x0428f8c4,0xdf27e63a,0xe5fae87b,
0xe77de262,0xf134efd2,0xf4b1fadb,0x085202fe,0x36bc1546,0x494e48af,0x161b1f6c,0x12652656,
0x29b42497,0x028b0b4c,0xdcc3fda8,0xcfb1d119,0x10fae88d,0x2dad280f,0x264c2cfc,0xf1460da8,
0xd7fce082,0xf91bf357,0xd1cae6a7,0xd7a3d161,0xceafcfc4,0xee9be2a6,0xd2aae2c5,0xe8dbdb21,
0x1ef80aef,0x2a7b1b40,0x380a3441,0x1bf41cbc,0xfb3c0617,0x36101443,0x2c823aae,0xfe6c17cf,
0xba2ecf78,0xf02bd19b,0xe9be0551,0xfe84da04,0xf018ff42,0xe402e407,0xe462ea1c,0xe513dc48,
0xfae7edd5,0x0a4a01ff,0x2fdf157e,0x441e4b8a,0x14ee267f,0x1ac9211a,0x1cd71a24,0x0c8b18f0,
0xd688f93c,0xd752ca3b,0x0e30ddc8,0x29492a1b,0x25b9317c,0xf8b41360,0xe665f121,0xe41de7cf,
0xdce7d9a3,0xd4b4d503,0xd2b3c9e2,0xf9d1ec6d,0xd53de9e6,0xe4fdd17d,0x03b7fcca,0x1c9e03cb,
0x46234063,0x1522221b,0x00be05c8,0x2b12177c,0x3b313c8e,0x02ed24b0,0xc02ade1d,0xedc5d179,
0xe429008d,0xfecbd9bb,0xfaf60bd9,0xe4cfede7,0xe021e108,0xe406dbb5,0xf609f1f5,0x040bf9cd,
0x37821ae5,0x418b4b0f,0x11332db3,0x24681efe,0x1bc317d3,0x0bbc220d,0xcffbf3ab,0xdd22bebf,
0x0accf52d,0x2b2d2d6a,0x1ddf2f8c,0x03540f2b,0xf00cf9e9,0xd646de44,0xd95fd24d,0xd00ddbb1,
0xd68cc687,0x0137f33c,0xda0cee0b,0xdea4cf89,0xe9c7e753,0x1a9df551,0x47c641ff,0x0cac234c,
0x0b2a14bd,0x1776182f,0x45e2343a,0x09b52f71,0xd2a8e6d4,0xe0fed706,0xe727f228,0x0124d765,
0xfcb70f76,0xe4d3f29f,0xe21ee275,0xd7b7d6ce,0xef5ee9a3,0x0dbdfce3,0x33a31cff,0x3c344218,
0x135b33a9,0x2fdc1432,0x15151e0a,0x0a5220b1,0xd243fad4,0xdfe4bc6f,0x04fd00fb,0x28ae227c,
0x1cfb25c7,0x0efe194d,0xfd1d0613,0xd94dde81,0xcfbed736,0xc93cd7af,0xd752c433,0x034fecb9,
0xe8e0f213,0xd5f2d95a,0xd63dce54,0x1519f06c,0x3b3e3286,0x210932cf,0x0bbf120d,0x16550c39,
0x4bb53139,0x12473285,0xf04cfb25,0xda1ae4dd,0xf147e90c,0xf7bee316,0xfbdf0c30,0xf95dfaf0,
0xeec3f242,0xc301d73d,0xfabedd7e,0x05a2044b,0x25841677,0x409c3aea,0x25023514,0x25f814f8,
0x25b4312e,0x0d621f27,0xeb5c05e1,0xd378c033,0x0662f9f5,0x27c42025,0x1b08230a,0x28c324d6,
0xf6df099a,0xe2daea98,0xc48fdf8f,0xc400c35d,0xcf15be52,0xf0d4d994,0xe6d3f2c7,0xd787e6ca,
0xc57cc569,0x0117eec6,0x23df14d7,0x26dc3046,0x04f816e0,0x22310594,0x49d22d8c,0x20e440f6,
0xfac10ef7,0xdaade4e5,0xffc4dd0b,0xe1e2ed45,0xe635f753,0xfb78ecb2,0xfc57fa47,0xcab2e56c,
0xf621d79b,0x185d1264,0x29041b12,0x45be38b9,0x34e540f3,0x1b991a85,0x27ec29cd,0x0af81d09,
0xfc6707bb,0xd9dcd896,0xfc9cef42,0x1fa1120a,0x1f31157e,0x31cd2cbc,0xf51a0ead,0xf17df986,
0xbe2de713,0xb7d6abd0,0xd254bef3,0xe584dacc,0xe519fb9e,0xe01fe972,0xdc13d469,0xe90ce62b,
0x1793f804,0x26842cea,0xfedf12ee,0x1ee3ffd8,0x27e322dc,0x376b4763,0x08251bf4,0xe0a8e485,
0x03c5ea0c,0xe5d20612,0xe350e569,0xf41edb2e,0xfb8103e3,0xcc91ee4b,0xea59c64b,0x12510970,
0x305a187f,0x48783e76,0x3ae147ec,0xff730ccd,0x28751e7e,0x03d2162e,0xff270697,0xdbabe55e,
0xf79aea58,0x1c0e05ee,0x1f0915be,0x3d083466,0xf1e11c0d,0xf37eef98,0xc783ec0a,0xc5d6b226,
0xcd67c94e,0xecc7da01,0xe7d3eb3c,0xe35ce326,0xd24ad9ea,0xde5ecfdb,0x1436f1df,0x204b2af9,
0x126d2002,0x23830eab,0x186224a9,0x428d3cf7,0x0b9722ae,0xe419f290,0xff02ee58,0xfb680a3f,
0xea67ebc7,0xfcfae9e5,0x00140fb9,0xdea5f2be,0xd580c447,0xfdb2ecf3,0x24e80943,0x4c9d3ea4,
0x399a4b67,0xf06c0fc8,0x38141cf6,0x18bd2aa5,0x124316ef,0xdfbef967,0x04f7e734,0x09a1005d,
0x2024107b,0x3e103c07,0x04742a0c,0xe9dcee26,0xc616de5d,0xc6ecb2ad,0xac50c7f1,0xe1fac3b1,
0xdba7dd8b,0xe49bd5ea,0xc569dc5a,0xd026c481,0xfb1fe8d1,0x2b901853,0x185c1c50,0x1f0b1ced,
0x22132384,0x41022e90,0x0d912424,0xeadc03a4,0xf8bceab0,0x035a0c60,0xd95ee3c3,0xf6b6f0c5,
0x08ca0b1a,0xe9e0f98a,0xc889c081,0xef1ae8af,0x20fafeeb,0x523a495c,0x329a4ebf,0x041f2467,
0x289b0c2e,0x1652293a,0x225f14c2,0xe9610d79,0x0264e507,0x13b30ff8,0x1c1717b7,0x36ec363b,
0x08052c55,0xe964f239,0xda7fe8f8,0xd164c8cb,0xbb7cd7db,0xec72c98d,0xd082d7ca,0xd310cbfa,
0xc047d5de,0xd52dccd5,0xe7e5d4b4,0x2ee10adf,0x2ec33a72,0x29713288,0x28d825b1,0x398a17c4,
0x0d352b1b,0xec00004a,0x0191f113,0xfe8dfea0,0xcf9eefb2,0xe1f3db33,0x172f028a,0xe032f8ef,
0xc0edcb20,0xee48e799,0x1c30fa5e,0x476541f6,0x2e9a3e4d,0x1b992f23,0x0d730389,0x1cbf2b0c,
0x18690dac,0x065020d2,0xfd13e42e,0x0e391251,0x15421864,0x41252f32,0x11ab2c5e,0xdbb5fb3c,
0xd4fddd62,0xcbaec38f,0xb8edd016,0xdc66bcd4,0xdcf7da67,0xd2add213,0xd298d291,0xcdd4d581,
0xd633c0e5,0x207009e4,0x32af2b4a,0x3c8e3515,0x2f113218,0x144519eb,0x17381f23,0xfd7a0d1b,
0xf624ee06,0xfca3ff39,0xd20dec94,0xe94ad3a1,0x0ef40040,0xe17700c7,0xcc66dfcf,0xe3b0db32,
0x16a8ef1e,0x49233881,0x34a2375f,0x399a3c57,0xfce70db3,0x1fff1ddd,0x18a3103d,0x0a541d2f,
0xffb2f117,0x0ef913a3,0x2d8322de,0x3fa72f46,0x16202766,0xe1750cf5,0xe0c9e56d,0xc94acce4,
0xbd37c89c,0xc035aedb,0xd30fde1f,0xd117c6b2,0xdca3e043,0xcb5be497,0xd604c46b,0x1dd90098,
0x320f206d,0x45763cf1,0x26f4386a,0x06ca1707,0x0e0b0bf8,0x08f81219,0xf612f7e5,0x01de0277,
0xd844e819,0xea26d7c6,0x04a5f0d9,0xe217f5cb,0xd392eaa1,0xe35cd4dc,0x07c4e738,0x2f9d1ab3,
0x36ef3713,0x3b143f01,0x01071cd8,0x233714aa,0x0c8b1700,0x11911bf9,0xf26ff7a8,0x1b060cb7,
0x42312f0f,0x358f3735,0x231020f9,0xed931a0c,0xe126d602,0xce97d955,0xb86ab865,0xb991ad60,
0xd0fed82c,0xe20fd028,0xf45ff95a,0xc5e8e4bd,0xdcd4c235,0x09bef99c,0x1a3a066f,0x426b37bf,
0x2c5c3db7,0x1155217c,0x13120273,0x229a17fa,0xf30f0e97,0xfc84f796,0xdb2ae1df,0xed1fe37b,
0xf422ea12,0xf09afc5f,0xdf06fc1e,0xe884d0ac,0xf204ed21,0x15470599,0x32742c71,0x32362fd0,
0x08442508,0x33571ae9,0xfc06143b,0x10841427,0xeb55fc43,0x22dcfe18,0x4d9535c4,0x42f756f8,
0x209c2f03,0xf3b62019,0xdef7d54f,0xc4afdb2e,0xa564b3ea,0xab96a63d,0xd800c8f8,0xf532de93,
0x09930eea,0xd15ce923,0xe15fcb44,0xeeaee467,0x1001ff3b,0x40883142,0x401e4ad1,0x0a7f28cc,
0x1a6c0cab,0x26bb29f9,0x06581072,0xd4e1e038,0xe58fdbe2,0xeb91ef40,0xf887e840,0xf4a7065b,
0xe24ef256,0xe91de279,0xe0efe142,0x260701eb,0x2bc8337a,0x2d0626e6,0x0f502424,0x3c1c15aa,
0xfb072772,0x0df1ff4e,0xdfa5edc1,0x1d25fac9,0x4d703603,0x5aee5fa3,0x1fb03c96,0xf071078f,
0xe4c7dfb2,0xbc91dae8,0xa292b068,0xa3099cf1,0xdd76b6d4,0xeb81e405,0x0d7001e7,0xea5ffc6a,
0xde18e124,0xf090e529,0x16e2059c,0x3b1f2c82,0x3a64444b,0x1e103029,0x11a909e5,0x123e22b2,
0xf5e20c33,0xd0f2d287,0xfa6eec2f,0xe967f46c,0x0978eaf5,0xfdb711f4,0xedd7ed5e,0xd712e6cc,
0xdb68ca73,0x1822f8ee,0x1c602416,0x1a9e0dca,0x34c62d5a,0x3c882835,0xf58f3c2a,0xeda9ed59,
0xe095dff1,0x2012f1da,0x42a43b76,0x69ed5da1,0x25495457,0xeff3f7c3,0xe6a5f203,0xc205dc3a,
0xa5dcbad9,0xa7ed9b99,0xdc00bf61,0xde07e420,0x0305f0d9,0xeaac021f,0xe554ea97,0xf5d9f138,
0x17b2f256,0x37c02576,0x43cd3d92,0x258f3f74,0x0c4d0662,0x11e71daa,0xefe50687,0xcb57d43a,
0x0405ea02,0xef67027d,0x0a7ef7c2,0xfbdc0913,0xf7adf87b,0xcaf3ea7b,0xe80ecb0e,0xff8df5f2,
0x0fdf0d5d,0xf8c4fbd3,0x3bf01785,0x3e7844c7,0x1afc5094,0xf795f456,0xe63ce9d0,0x139af58c,
0x2fea3446,0x7afc4dc5,0x293268ca,0xfd60f9ed,0xec97016e,0xd069e354,0xa8babc43,0xa3e49843,
0xc552b8b7,0xe028d9e9,0x01b5eece,0x08e512e1,0xf74fff20,0xf337f5c0,0xf455ed06,0x1f000124,
0x3f8e346a,0x24eb413c,0x0dd30b68,0x1ba11a68,0xff470e0d,0xd230e370,0xfa69e2de,0xea10fd43,
0x04e0e9f5,0xff1c092f,0xf611f964,0xd324f974,0xe52ece7b,0xf437e3f8,0xfc58f77c,0xeb29f95a,
0x2d470a41,0x444f4225,0x2e2b4180,0xea89fefe,0xe1e4e901,0x1686e094,0x3ab53273,0x72c54058,
0x3e3f6fce,0x03320e2d,0xeaea00f1,0xd6b7dde1,0xa859b4dd,0xb915aa15,0xb676bf1a,0xe30fc938,
0xfa45ed02,0x17900bf9,0x032a0bee,0x054a01ff,0xe57bf015,0x1729f611,0x32393435,0x27fe3c47,
0x0aa711e7,0x0aac076f,0x094b06fe,0xe66bf657,0xfbd5e5ea,0xff010f52,0xf9f4e617,0x00990efc,
0xf151fc7a,0xeae0f53e,0xd7eed9b5,0xe5e1e196,0xf217ebe3,0xfd83fff8,0x170d0612,0x3f7c2fdb,
0x34fe38b0,0xe32806bc,0xe940f203,0xf5d2e0cd,0x34321c66,0x5d3b33cf,0x477e68d1,0x0ec82b6c,
0xeb9f0936,0xdcc0d50e,0xc0ffc348,0xb357baa4,0xb7b6ae5f,0xdd96c462,0xeae6e3f3,0x1ba60331,
0x13b32204,0x0bce046f,0xdd2df4e4,0x03c1e85e,0x3aaa2998,0x33fc30db,0x120216e0,0x0cd41432,
0xffdb0561,0x01fa08b4,0xfda6fceb,0xfa6c0399,0xe29ee503,0x17680ecf,0xf65e057f,0xf7c3f0ed,
0xd087e274,0xe752dd97,0xfa36f41d,0xf7e4f564,0x1d010b26,0x3e272ae5,0x3190376d,0x00bb2318,
0xf6defd26,0xedbaed79,0x17ee0899,0x41d92987,0x54e565f3,0x0d3b336e,0xf6c603c8,0xcdd5d18f,
0xc837c7f2,0xba9cd4c2,0xb8deab99,0xd366b7fd,0xd839d8b3,0x1b08f804,0x13f32756,0x07a50948,
0xe82bffa1,0x0ae6eea5,0x28af1a85,0x24942e47,0x07520dfd,0x06f00d1e,0xf227f327,0x16ea0989,
0xee840ab0,0xefc2f64e,0xde84e638,0x1ea103e5,0x0c6621dd,0xf2f2ef9d,0xe5ffebb3,0xec7de3ef,
0xf7c7f82c,0xfcc0f0ae,0x0761fe16,0x2cae1f58,0x24882e12,0x1fae2617,0xfea703b5,0xec94fe71,
0x10d8f794,0x446f3109,0x547f4e4d,0x2dcc4585,0xf07e0adb,0xc4e9cf71,0xcdb8d5f1,0xbab7da85,
0xc5a1acaa,0xc169c0d5,0xc800c5a3,0x0dfff119,0x1963216d,0x06940038,0xf39804ba,0xf29ae49b,
0x288613e3,0x1ab11db7,0x0d65153c,0x099a1194,0xef41fb6e,0x2c2f0861,0xefec1946,0xe81ee135,
0xd827e96f,0x21f0fa81,0x15a52268,0xf753fb3a,0xde41ee10,0xf6b5e6a7,0xf264fb24,0xf50de3b3,
0x0475024d,0x1b9d142e,0x1cb323d1,0x37aa2a8e,0xff640f6d,0xecb908ca,0xff5ff120,0x369923c5,
0x5b6741de,0x372556e8,0xf1af12d9,0xc2f3dadc,0xd9abd7f5,0xbef3d0d4,0xc9b0ba1a,0xb586cb04,
0xce10bf95,0x0484e3ce,0x20811699,0x09d01046,0xfb18088d,0xea26f38a,0x1f7c0d3b,0x07601159,
0x13881586,0x02521497,0xfe05fda1,0x286f05af,0xee1e1a70,0xeba8e589,0xda5fdea4,0x1a28e967,
0x15812b1b,0xff6204ce,0xe164f53e,0x0727ee77,0xe86df7fc,0xf48bef8d,0xf63ff5f9,0x201e0c72,
0x296f2445,0x2ffd24af,0x0c8520d1,0xf3110a41,0xf7dfe5bb,0x2a0a0a55,0x4cc22133,0x4798749c,
0x03201e4c,0xd74ee2ad,0xef10ec1b,0xc578d95e,0xd1a4c432,0xaf0cd009,0xd9dbb46d,0xebc5dfd4,
0x155cf786,0x11d919a6,0x0dfc0fed,0xf25c021f,0x0ddbffba,0xf683f6b3,0x15c2122f,0x07870ae0,
0x0f1401e2,0x0de90395,0xf14d141f,0xe19de0ff,0xe33cdf05,0x1724ee71,0x12861fe6,0x05f41211,
0xe578f436,0x04aaf12c,0xe7cffa84,0xe843ee66,0xf247e1c4,0x2a0a0da0,0x22512941,0x26971dcc,
0x131e2ab3,0xf7bb0987,0xf0d4ebc0,0x1f63f467,0x3bc42342,0x51d96bd6,0x178c278f,0xe1b3ef23,
0xe7c2e7bc,0xc7c0dca5,0xdc51c2f8,0xbdbde0fe,0xd17caefd,0xd748df94,0x0301de18,0x166f1ef8,
0x0c8f0d3f,0x013a13d7,0x0e70f892,0xf0bbf8bd,0x144e04f5,0x1a371be7,0x245d0abb,0xf7e41461,
0xfae60852,0xe67ce920,0xe622df55,0xfb81e24c,0x1b141975,0x13f315e4,0xf581fde5,0x0c72f2db,
0xee850927,0xe53de9dc,0xe44bd991,0x2906fe8d,0x209534e4,0x1ff90bf6,0x146c35c0,0x001e04bf,
0xf3ac0059,0x08ffea42,0x2a9226ea,0x4ded4ecc,0x1fe335f0,0xee70f874,0xdc72e8ab,0xcdd4dc61,
0xd845c845,0xdcfde9df,0xbfe0b6a8,0xc723da92,0xf6cccf32,0x0f6516dc,0x0c5607f2,0x0f4a18c7,
0x0160f4fc,0xf1e1fe24,0x19edfea6,0x254e2261,0x22f00b04,0xf19215bd,0xff95fe4b,0xf089f1e1,
0xef51deee,0xf8cdeec4,0x16f418f7,0x1bd111bc,0x04740750,0xf9d0f29c,0xf5520a8c,0xd584dff6,
0xe743d90e,0x26230798,0x1fb63c3d,0x1eb0108e,0x13f13073,0x03e2fd86,0xf9320389,0xf8fdea8f,
0x2f0b274e,0x4be636f9,0x295d312b,0xfe3d1a55,0xd2b8ec2b,0xd682d56f,0xd878c837,0xed2ce0a8,
0xbbc4d80a,0xb488c5d2,0xe82dc58e,0x008ffd9b,0x0fe0014a,0x13c219a6,0xee10f456,0x0629fea9,
0x1233027c,0x2a892463,0x0fe3165e,0xfb0c1511,0x0458f709,0x02c7089b,0xe2e3e86f,0xf096f567,
0x0fae0995,0x233f07d3,0x0238169d,0xed9bf196,0x03d6070d,0xd041e08b,0xeec6db59,0x240c0e96,
0x1f1d2de9,0x142b12a5,0x05a21afc,0xfcfbf726,0x020908f1,0x0031f5b9,0x367324c4,0x3b693b48,
0x242226e2,0x02d01e04,0xdae6eefc,0xdefddff6,0xe32cd8b5,0xf3aeec38,0xbf54dbdd,0xa77ab25a,
0xdc87c65e,0xf857f5e2,0x1aa70402,0x05c51820,0xfec0f958,0x00000843,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_strings_stringsf3[4352] = {
0x00000000,0x02b60200,0x03a00337,0x00ec0209,0x00afff86,0x02530002,0xfe740172,0x00a5fe42,
0xfc0dff47,0xfc00fbf6,0xfd80fc33,0xfcadfd0e,0x0059fdf3,0xfe030089,0x0077ff56,0x03b90280,
0x03050241,0x02cf03e9,0x043e02ff,0x047504e4,0x00ee02f6,0x00320067,0xffff005e,0x009a012b,
0xff02ffb7,0xfdfdff64,0xfc6afd83,0xfae0f9da,0xfabcfbf9,0xfcaffc3b,0xfe23feaf,0xff19ff4c,
0xffb1fe31,0x025201f9,0x03cd01f4,0x0281036b,0x02bd0292,0x043e0375,0x02cb01f6,0x015000ce,
0x014bffcc,0xfee20080,0xfe44fd3c,0xfccaff42,0xf8e8fa99,0xfc43fbab,0xfb6afa51,0xfe81fc30,
0xfd86fedb,0xff16fe40,0x00580171,0x055d028b,0x044405d3,0x0664043b,0x049a051d,0x049f05bb,
0x011c0322,0x01e0023f,0xfe4f01a8,0xfe94ff7a,0xfda90015,0xfb63fcc7,0xf8a9f994,0xfa31fb5f,
0xfcb4fad3,0xfddafe1f,0xfd6bfe3d,0x0258fda1,0x036e031d,0x07c70353,0x037a0410,0x04b5029d,
0x04d906db,0x04f70445,0x03220467,0x048302df,0xfdfb0384,0x0066fe6d,0xf883fcb3,0xf60ef726,
0xf8e4f89d,0xf922f6c7,0xfbb7fba9,0xfd71fab6,0xfd69fc40,0x04d20156,0x07f606d3,0x03c30579,
0x069a065e,0x071305b9,0x0558081e,0x046f0402,0x03b2059e,0xfd260051,0x01eb004a,0xf703fd3f,
0xf823f8fe,0xfb79f89b,0xf47efa3e,0xfd4cfc18,0x0109f8b4,0xf9e5f925,0x046303fc,0x06f9fe59,
0xff5806f0,0x0895011b,0x05b80a68,0x04af04d7,0x050704cd,0x04e8059c,0x00d20533,0xfe80fb9e,
0xf9530107,0xf6a3f643,0xfd86f787,0xf7a0f915,0xfd4dfca8,0xfcacfbce,0xff0afe3d,0x0117fe05,
0x01300109,0x014b0304,0x04df0383,0x073906ca,0x07b609cc,0x067d0322,0x0ab40a00,0xfe7704a4,
0x03a0fd54,0xfa0101c5,0xf3fdf3f9,0xf4f7f0d2,0xfab1f86d,0xf687fc48,0xfe1bf9bb,0xfe4df31e,
0xfc0affeb,0x07f50ccb,0x04c907a5,0x05f803e9,0x026f07df,0x08cc0164,0x0c180ea5,0x06e2059b,
0xff600534,0xfff3fac3,0xfa47ff7a,0xf18bf3e6,0xff23f788,0xf8def81f,0xf735fb73,0xff7d0006,
0xfbfafc73,0xfeb1fabb,0x05df06c8,0x02e905c5,0x0261048a,0x02a9fa23,0xfec3061b,0x102408a5,
0x0d840d2c,0x04cb08b1,0xfd8301b2,0xff4ffc0c,0xf612f75b,0xf613f446,0xf148f6ee,0xff07f3a5,
0xf587fe11,0xfed5f8c1,0x038c0225,0x0344fd3f,0x02bf08b7,0x0a64064c,0x09a1092f,0x0416058b,
0x0a970843,0x10e40bc9,0xffd80aa2,0x032d014a,0xfc58fd12,0xf6ffeea0,0xf0f0ec2c,0xeca4f6a5,
0xfe2bfd09,0xf6feee37,0x00e10186,0xfb7cfe6c,0x03fa08b3,0xfa36fd1a,0x11ec091c,0xfb810b02,
0x0df5054b,0x053208a9,0x17ff0ea9,0x024c0c6a,0x08dbfe3c,0xf35e09e0,0xf9a2f093,0xf50ef6de,
0xf757ebce,0xf3daf160,0xf7c3026f,0x023efba8,0xf7caf8c3,0xfdfbff7c,0xfbc70468,0x02b6ff03,
0x08a80c82,0x05d105d8,0x0eae0709,0x120e1270,0x0c910f92,0x0396063e,0xfc8dffb7,0xf3c6f61d,
0xf69ff685,0xf504f2a5,0xf235f1dd,0xffacf767,0xf29fef9d,0xfa6d04b9,0x099dff3c,0xfc2b0261,
0xf9d5fe41,0x0462ff9a,0x0ca80ee1,0x057a0791,0x15841415,0x0a2e188d,0x0ebf07d9,0xf2ae086f,
0xfcf5f209,0xf537f254,0xf624f2e2,0xf3bdf5c0,0xf1a7fea9,0xfba0f7e3,0x005fffe6,0x0b9c0402,
0xf76bfe1a,0x029d029e,0xf927fad9,0x0c5cffe0,0xfa920777,0x10c003d0,0x0d681032,0x07d002a7,
0x03cf1650,0xf9edf5c9,0xf9df00fb,0xf431f5c8,0xf703ebf7,0xf7fb0318,0x05f7fd7d,0xfe28f2e2,
0x00270322,0x0225fd49,0xfcce04a2,0xfe33f3b0,0x0a1df870,0x00a308a1,0x0568054a,0x149d0aaa,
0x0f161430,0x0a72114d,0xf2b0fe07,0xf2cdf0b2,0xfa55fd9d,0xec62ee37,0x00cc0432,0x0744ee49,
0xfa6ef8ee,0xfcd10b12,0x01a8fda2,0xf423fcfc,0xfe0ef493,0xff14fd54,0x0f6c1010,0xffadfecb,
0x161c086f,0x0f3b1448,0x03200b3d,0xf774fb8e,0xf2eff27a,0xfc8afa65,0xf300ee3b,0x08660894,
0x036af782,0xede70a88,0x13c005a3,0xf679fd4f,0xfe1ffa40,0xefbcf7b7,0xf0e1ecf6,0x0ac70a6d,
0x04ee0137,0x0fb80729,0x13d91111,0x00d211ed,0x0766f8f6,0xfdbffa1c,0xff0dfe98,0xee67fd09,
0x0ffdf853,0xedecf7f8,0xf642055e,0x0c6fff98,0xf7d5ff33,0xf76ff565,0xfa69f571,0xfb94f962,
0x0e890d2f,0x0a3a02e6,0x04130842,0x154a0e62,0xfec215cd,0xf7caf4df,0xfd57f8b7,0x0195fe89,
0xf706fa19,0x156b0191,0xf4760280,0xed9b091f,0x00c0ee09,0xf6a8fcdd,0xf7eff45c,0x02fb0709,
0xf4fef7da,0x142bffff,0x059b04ce,0xfecbff4e,0x13340795,0x0a5f1db9,0xfd31f595,0xfd32fe63,
0xf258faf0,0xfd66f8f9,0x0d5702f1,0xf9320f23,0xfa0708ee,0x04dcf1ae,0xf51ffc9b,0xf648ff06,
0xf4b8f74d,0xe77eedbe,0x0d2af01f,0x09bc0963,0xfd950461,0x19631039,0x12ca1dd9,0xfa6afefa,
0xfbbdff0f,0xf1bcff6c,0x004efaf5,0x0c85fd66,0xf3ac0d29,0x08b30f35,0xfe3fee1b,0xf7a1fba4,
0xf9d2f6bb,0xf94af927,0xee03f194,0x0ea8eec0,0xf34a0909,0xf823ef88,0x1ddd049f,0x18a41d06,
0x00eb0937,0x0e3afea9,0xfa100e76,0x00840694,0x1747f95e,0xf1f010fa,0x05a3f61f,0xec48e023,
0xf485fbb0,0xf6f1f220,0xf4cffbbc,0xf4eafb55,0x08c6f27c,0x052f12ac,0xeecd01a1,0x17810936,
0x1bf51dcc,0xf76bfc2b,0x06cb001e,0xedd4ff4e,0xfc74f519,0x0b9ff655,0x09df231a,0x1093fe0e,
0xf4e2f6ac,0xf8570124,0x029df5db,0xeeba0012,0xf499f45a,0xf4e4eb32,0xf3a90014,0xf0fbf891,
0x169ffc38,0x26ac1d9e,0xf25f11a7,0x0d3afdc8,0xef370512,0xf360f76c,0x00c2f7c0,0x18e7151b,
0x150c024d,0xfa3e08b2,0xfbd20bab,0xf756e321,0xec8bf7b7,0xfd59f941,0xfde0fac3,0xfe940808,
0xe84ff6e6,0x0436f834,0x24a510c0,0xf79213f6,0x0ecbf883,0xf5430607,0xfd4fe7b8,0xfa3c007b,
0x1ecd1483,0x1cab0c9e,0xed8efd4f,0xff1c02b8,0xec7ce683,0xfb05f9bb,0xfc8fe4b2,0xfcbd07b1,
0x028c007a,0xf5c1057e,0xf108e8f1,0x1a4502e7,0xfd1012bb,0x0d58fdc1,0x07a708e4,0xf7cb0401,
0xf930f67c,0x1a741362,0x1bfb0cb6,0xfbd90ab1,0x0dd103b4,0xe3f9ed2a,0xe654f56c,0xf770e888,
0x04a5fa29,0xff6b071d,0xf2e2fc4e,0xf9aaf48f,0x0ca805f1,0x02291d40,0x0a31f4ca,0xff3e09fd,
0xfcd4f992,0xf50bf472,0x1133ffbe,0x1a790dfb,0x018e13ae,0x0b750d72,0xf2aafb9f,0xd9d2eac0,
0xfa36d901,0xf9ea0435,0xfcb704ab,0xf74ef90a,0xf4d7f2d0,0x0dc6fdbd,0x0c9112de,0x152204f9,
0x065f013c,0x08300849,0xede4ff27,0x16d9fa4a,0x176a131c,0xf7d80bef,0x12860a7f,0xf1f70506,
0xea85fbe4,0x0250e366,0x0366033d,0xf3370833,0xfd48f8e6,0xe108e6c5,0x081be493,0x07cb1a50,
0x01f2f615,0x0ded0ce2,0x0401094f,0xea06fc3e,0x1017fb78,0x0ae906ea,0xf9321874,0x230d1327,
0xe42df355,0xe60ff940,0xeff8e44c,0x04eeed2c,0xf9d1fc34,0xf97c0684,0xf0fbfded,0x172cfa41,
0x10471b93,0x0320ee06,0x10e7096c,0x02fffcb9,0xf55f02b2,0x25020444,0x084726b0,0xf4e21684,
0x1d5bf14e,0xe96d0bfb,0xe0d2f829,0x03b5eae8,0xf8effbfc,0xfbc5fbe8,0xf8c7f64d,0xf0f5fbb8,
0x03e7efba,0x060b181c,0xf4b0e07d,0x0069083d,0x03fbfe29,0xf4010b54,0x192ffb68,0x03df233e,
0xf6d4fcf1,0x1abbf694,0xf654140c,0xf6c701f2,0x008af471,0xfa81f949,0x0be6f06c,0xe1e1fde9,
0xe432f3b1,0x118ffefc,0x0d7319cb,0xea55066c,0xf84b02e8,0x066fef2e,0x0332f3ea,0x1a910712,
0x17a22b8d,0x00511dcb,0x0e76e547,0x034d1cf4,0xe49cfaa6,0xfe88e578,0xf81702a2,0xf624e6e1,
0xfab2f8fc,0xeeccf13d,0x1562ff10,0x11b315a2,0x063b00ad,0xeb5ff276,0xfc8ffbc1,0xeb34ff2c,
0x178dfcfd,0x08a823f4,0xfde319ed,0x0662dc1d,0x01e716d3,0xf0d4fa6e,0xffbfed97,0x15330915,
0xf735f96f,0xea08e95d,0xf2e403a9,0xf9d5f55e,0x18a9127d,0xfcc902f2,0xeb48f721,0xf9f900fa,
0xf295f6bf,0x23aa007d,0x196a33d9,0x06ca1015,0xf01de362,0x14a91ca3,0xf17a09bf,0x0814f20b,
0xfb94f8b7,0x01a1f677,0xe670f8c4,0xf31af7a5,0x0c9afc2e,0x131503c6,0xfdd2f24c,0xe4fff787,
0xec81e3f0,0xf284efcc,0x1255fa7f,0x1c9638f8,0x12041d14,0xe314ea6d,0x19c1186c,0xf0ff0869,
0x1e28f5e6,0xfd5c1d77,0xf65beb69,0xee46f43f,0xf51ff322,0x0975f81f,0x0a6f144e,0xe48d067b,
0xf39df5ba,0xeabaf69d,0xf086eb24,0x0d9ffd84,0x1efb2488,0x246c018f,0xe424f9aa,0x16250b87,
0x0ac01e22,0x0d82e50d,0x06c61213,0xed7ef5d0,0xf1e8f039,0xfc53eeed,0x02d1fa41,0x0d050d2a,
0xe89c0fbf,0xf025e0e6,0xf186f874,0xeeebe22d,0x0cfcefe0,0x2e9f31ae,0x1a880756,0xd9d2128b,
0x0e6bf4d7,0x0a4a1ab1,0x07fce0e0,0x174e19d7,0xe2f2f2aa,0xf192f543,0xf52aeec6,0x05e1ed65,
0x0fb60756,0xf30f02b9,0xf608e5dd,0xfc2af57d,0xec23f3d9,0x049af31e,0x394e370c,0x004a0c25,
0xea62200d,0xf641fa5a,0x1f671664,0x0006f69a,0x20cd1899,0xe30e04f9,0xf761f158,0xf374f444,
0xfa16ec05,0x0adf0b68,0xefbe006d,0xdcf0dc92,0xfad3effb,0xf4b0e324,0xf4f7f62f,0x403c1b1c,
0x009d29c9,0xfd79173d,0xf169f2e3,0x1c740bca,0xfdcd03b4,0x1cb60b42,0xed260ef4,0xf5ebf060,
0xfaf0ff94,0xfe5ae7ec,0x0f66044b,0xf49d0803,0xd45fdcf5,0xff60eacc,0xe5f8ee0b,0x000d0103,
0x36290a69,0xfaa42d1c,0x058d089e,0xf136ee59,0x1b8406a2,0x0ecb1321,0x1b6d0e4a,0xf6420ecf,
0xfdeef1f3,0x03b2fa48,0xfaa3ed54,0x0d520a44,0xfb00105e,0xccf6dd54,0xed43d4dc,0xda48ee8f,
0x06cbf6b6,0x29350361,0x04e83c00,0x0805f669,0xe63ae7ff,0x0daef212,0x2c6e16b5,0x13301061,
0xfc2a09f1,0xfedff084,0x0e8e0b11,0x04dcfc56,0x07bf14a1,0x042615ca,0xd3a7e1cc,0xde2cd0c5,
0xd6caf817,0x0760eca3,0x1e2804c6,0x17723927,0x05a6f0e6,0xd87bf9c9,0x12b9f627,0x31c014a7,
0x06b2195c,0xff76100c,0xf19cec69,0x0aa00261,0x0015fa5b,0x0ff511c5,0x026e004e,0xdc48f330,
0xce7fd3b6,0xe836eccc,0xfc20e831,0x10930101,0x27d82bd4,0xe994efe0,0xdf730d8f,0x03f2eebf,
0x3180126f,0x169533c6,0x03490b63,0xf2d4f5f5,0x141c0bd8,0x067df88e,0x18511a8d,0xf2b200ef,
0xd849eb71,0xcde7d854,0xeb22d88c,0xff71e6bf,0x0b8203cd,0x2b4e19b7,0xe41f02d9,0xea5b08c1,
0x0daaec12,0x3a791c51,0x25a23831,0x020e0b2f,0xedb2f50c,0x0d7cffd9,0xfd5bfbb0,0x16121890,
0xe5d8043f,0xd3d6f36a,0xc3e1df8b,0xe670dde1,0xfe0fec57,0x0c0402de,0x1d9f0d62,0xe6b70732,
0xfc84f00e,0x046fd89f,0x3a6211a6,0x38c73d36,0x06fb1374,0xf55500ec,0x19a4fe63,0xfd0efedf,
0x207f1db3,0xea0f0d77,0xd69ae6a4,0xcd9fd9a7,0xd046d769,0xf60ff313,0x11240263,0x13f80135,
0xf3c11777,0xfaabe215,0xfd90d227,0x2d9c1590,0x38fa3b1a,0x02051f29,0xf5f500bf,0x1e28febd,
0xfe571319,0x280d12cf,0xf3401162,0xd56ed949,0xd177d6b6,0xcc78ce5d,0xfec3f168,0x0c370795,
0x03fffb39,0x03e31d73,0xf2e9ddb5,0xe16ee8b2,0x26241de3,0x3fa23f79,0xfe2e27eb,0xfa54054b,
0x1879f543,0x08121936,0x2804106b,0xff4f11c3,0xce18e43f,0xd046c91a,0xd183d4fa,0x05d6d97a,
0x0fd20c7e,0xf78e012d,0x1c3413ae,0xe214e418,0xcdb7f51f,0x314b0f8f,0x3af731a7,0x04ab2e59,
0xfad203bb,0x1381f62e,0x179a224c,0x23e809ba,0xf9ba1971,0xc5d3eb96,0xd17acd93,0xd59fdbec,
0x0001ced7,0x12640ef4,0xf349ffc7,0x227005a6,0xd77ff7cc,0xe304f5c3,0x3c38efac,0x3209311b,
0x08c3340e,0xff3e0cbc,0x06cdf191,0x1d041d8a,0x1bd11345,0xf8a429ac,0xc363ea59,0xce0ac2b3,
0xd8f1d9bd,0xf66ed3d6,0x1c08117d,0xf3d0fb20,0x2299f647,0xd0cb08dd,0xf543ebf5,0x2a50e323,
0x23cc376f,0x1772311f,0x0aa50b4a,0xfebbf4ca,0x23a11912,0x1d0d1ee1,0x05473266,0xcd05e4dd,
0xc5ebbdda,0xdb0bd6f2,0xe93dd5e0,0x1ba716b7,0xe8dc050d,0x0d43eeba,0xd78d1d21,0xf76cdd28,
0x1b95e22c,0x24053c52,0x23832997,0x0fb109c1,0xf530fbbb,0x248d11d3,0x20942410,0x166a27f2,
0xd61fea59,0xb8a9c27e,0xdcd8d841,0xe8edd8d4,0x1b3c0f1d,0xe8bd183b,0xfc52e615,0xece71921,
0xf02ad670,0x0bb9ef75,0x2b6a3907,0x21f9198c,0x100b14f0,0xed4c04a0,0x23fa0a6c,0x276f27ae,
0x1dc72b14,0xd0c3f9b0,0xb620ce11,0xe073c83c,0xe966d4bd,0x1f060452,0xf20d1c7b,0xfa0bdd49,
0xf91a0d6d,0xe56de173,0xfe03f8b3,0x3489299f,0x194d1ad6,0x11641d40,0xf3de093f,0x2335f8e0,
0x2ebd2514,0x22902a22,0xd75209c2,0xb7dbd546,0xdf25b7b7,0xe295d541,0x1603fc7d,0x03b81db3,
0xf3f9dbbc,0xff6c0579,0xe58aebe7,0x00e6f407,0x35191cfb,0x13171e9d,0x148820d9,0xfc580cb6,
0x143af042,0x283a2af7,0x23832f19,0xe9f91463,0xc271d76f,0xd858ad23,0xde7bd7fd,0x096ff51b,
0x0d441f2c,0xe988e4bb,0xf99dfa60,0xea73f310,0x0954e7ad,0x30d30cd5,0x124c2025,0x21391d4b,
0xff5e139a,0x01d3f778,0x27182a8f,0x2d2033bc,0xf97719b4,0xc9a5d756,0xc896aa65,0xe1e8dc4d,
0xfdcbefff,0x172119df,0xe1bff2df,0xf51ff32b,0xed52f630,0x01d0e73f,0x1b560e69,0x17ad2bc5,
0x27a419a6,0x00e01321,0xefc80716,0x24962083,0x36d82efe,0x02d423a5,0xd20fddf8,0xbbf5b0f0,
0xe5a3d3d1,0xf9c2e928,0x1882112e,0xe94402dd,0xe853f309,0xf5e0f3f0,0xf316ea08,0x1067151e,
0x230b2b0b,0x240f12cc,0x05051b8a,0xf90001ec,0x25c207a7,0x3aaf265f,0x11c0295c,0xce85ee5e,
0xbb5cb5be,0xe486cbfe,0xf2c6e722,0x1c460778,0xf75f0afa,0xe4d2ebc6,0xf8c9e876,0xeac9f042,
0x09060a0e,0x35231d7f,0x2044180f,0x0e5b22fc,0x050005ba,0x1f53ec6d,0x3b8722d8,0x1c8733b0,
0xd70fff81,0xbc7fba21,0xd720ca62,0xe78eed48,0x18e2fbd8,0x060711fb,0xdfa8f138,0xf630e0ff,
0xe74efb74,0x0b2af852,0x39d20d08,0x164d256d,0x14ab2437,0x049d0ab8,0x0ae6eb85,0x32fc25b6,
0x26e8392c,0xe5340f8d,0xb7b2bac3,0xcd12d22f,0xdc36ec0d,0x0dc6f6e4,0x0b9d1749,0xdcd3f91a,
0xed96dbe7,0xed67fd7a,0x08afeb9e,0x2e570c5f,0x167a37d0,0x1e9d240a,0x064c1225,0xf12ff3a6,
0x2c56227d,0x315a3bb7,0xf1f61b53,0xb892c20d,0xc90fcfbf,0xe447dc21,0x08abedb7,0x12e115b6,
0xdac00948,0xe09ad9a5,0xf3d0fbb5,0xfd76e461,0x21ca0edb,0x24c93ffe,0x24d91dde,0x0c7716b5,
0xe379f4f3,0x2b7810e4,0x3aa33754,0x000d2aeb,0xc1cccd31,0xcb11c6a3,0xe49dcba5,0x01e8e336,
0x15680c09,0xeae815db,0xd94ed337,0xf796f337,0xf2a6e502,0x18730763,0x37883a32,0x272f1c1a,
0x14e61d75,0xe47bf33b,0x29e8fb38,0x3dc73415,0x0e493ea1,0xc845d7f8,0xcedac997,0xd795c16f,
0xfd0edd58,0x12240729,0xf9932176,0xd179d1ee,0xfa7ce930,0xe462ea21,0x172bfd78,0x41d33113,
0x218a2304,0x1daf28ec,0xe1e4faba,0x195cebca,0x3693351f,0x19d5482c,0xd06eeabc,0xcd64d10d,
0xcc99c2ff,0xec21e365,0x072202e2,0x0d5a21de,0xcbc0d9af,0xfb2be0ab,0xe3eef06e,0x1137eb9f,
0x429b299f,0x1b1f2fa2,0x26422f2c,0xdfc20ba7,0x0282ec16,0x33c63040,0x2ce744a6,0xd58ff52d,
0xd287d7b4,0xc010c547,0xe969defd,0x0221f8bd,0x1b58188d,0xca80e600,0xfa72d43f,0xe7f5f3b6,
0x000de2af,0x3ebd2af7,0x1b8d3e02,0x301a2c9a,0xe06819f2,0xf5d9e915,0x299d1ec7,0x37d53f7e,
0xd908087c,0xe152da65,0xbfadcae5,0xf275c679,0xfc8cedc1,0x1d330e98,0xd2f1f405,0xf0cdcb16,
0xe924fe0c,0xee27e4d3,0x417b1d47,0x2b6d3d92,0x3a0c2195,0xf9bf213d,0xf75fdbef,0x29260c9d,
0x3ebf3895,0xe0ec2062,0xe8aadafa,0xc2e8d5f2,0xec2eb7d4,0xf424f168,0x1a610944,0xdf9a04b9,
0xdf53c6da,0xed3afdf1,0xe688e38d,0x3b0d07ba,0x3929401a,0x39281ed2,0x09842d74,0xece9e125,
0x1c2efc03,0x3f403611,0xea2132fa,0xebb0df01,0xcb3ce2e9,0xd733b179,0xe9b5f8d7,0x154600e9,
0xee0a0a19,0xd796cd12,0xf227f822,0xe2eae376,0x2fbdf27f,0x359248ee,0x2dd025c4,0x13373a88,
0xe05aedda,0x09c6f445,0x3faf2fa4,0x00983cbb,0xf43cda8a,0xd5e2ecbe,0xbcf5b1d9,0xf2e0f2b4,
0x130bec9f,0xf9590dca,0xd192d714,0xf7eff05e,0xe0b8e412,0x1dc3e8fd,0x3a684a4b,0x2f532f5a,
0x202a3c86,0xdea9fcbd,0xf871eb95,0x3c5c1e24,0x18de40a7,0xf116df7b,0xe5e7f4bf,0xaf0aba21,
0xfdc3df7f,0x0672e946,0xfcf30ec5,0xd301eb73,0xf2d2e6d8,0xdc8de828,0x0063ebb3,0x3e9147a8,
0x33df33a1,0x2be23e66,0xe65a0803,0xef62dfd8,0x3c0e0b68,0x2a9d3dcb,0xe949ee91,0xf03d01e2,
0xaf53c62e,0xf7d8c34a,0xf31cef4b,0xfd0a16ed,0xd82bf598,0xec87e520,0xd9e1ea5a,0xf6bce550,
0x45853213,0x388c307b,0x34a03ad5,0xf2b010a8,0xe745d891,0x2a7fff7f,0x33063ecc,0xe52b0be3,
0xfed801b5,0xb3c4d5f8,0xdbd8b608,0xeb2dff6d,0x076e10f8,0xeab4f685,0xeb1de4c8,0xe836e111,
0xf094da6b,0x495218c2,0x3cf636ca,0x36473e3a,0xf7e4232d,0xdb73e0e7,0x184ff2ad,0x36123eb0,
0xedcd1f9b,0x0ab3faac,0xbabae29c,0xc82cb394,0xf86bf665,0x15d7f57f,0xf607f4bb,0xe920e6d8,
0xe8a7dc20,0xe92dd9dc,0x342d0a57,0x379d48ed,0x34d3426a,0x018a2d81,0xd39fe639,0x06ede6a3,
0x380d3398,0x0623248c,0x0e93f453,0xc76cf0fe,0xc085b62b,0x0470d9e9,0x1078f055,0xf0d40681,
0xe93af249,0xdcdbe096,0xdf51e591,0x23c8ff0f,0x3ecc41e7,0x395b4645,0x100a2ff7,0xd1c0ed1f,
0xfa03dd83,0x36cb23aa,0x0fc828df,0x05d60137,0xcb940634,0xbfd1c0fe,0xfd63c598,0xfe1d00f9,
0xf27e0c69,0xeeeef6c6,0xd497e279,0xdf14e4cf,0x177ef36b,0x456d3970,0x3fa24491,0x1cf5321c,
0xda86f486,0xf483cd83,0x384a1242,0x1b0622b6,0x01060cfc,0xdb040ea6,0xc635c269,0xe575c1cc,
0xfbe80c1d,0xff9503b5,0xf85bf350,0xd431e1d4,0xe197dfee,0x0e32ed9a,0x41c429f4,0x3aca49a1,
0x2a62394b,0xdacdfa92,0xf157c8e1,0x2fb40251,0x209922a3,0x0c1c173a,0xebc50bb0,0xc1c9c7d9,
0xd1a8c827,0x04400557,0x05fefe30,0xfd05f76b,0xd2f6e7ee,0xe01cd34f,0x00bcf34e,0x3b811d6e,
0x3ff84c60,0x2cea3d04,0xdf3206bc,0xe2b9cc42,0x1b39028b,0x1c5f2910,0x161c1d17,0xfc2b0a6b,
0xc6d5cc84,0xd064c90c,0x100feb65,0xfed0f743,0xfdb3ffa6,0xd5faf581,0xdd34d05a,0xffabefe2,
0x28a115c9,0x4aaa47d9,0x2e363d9f,0xe88d10ea,0xda98ce72,0x0e6c0132,0x1e10290b,0x1b992257,
0x003718aa,0xc66edc36,0xda2ecaf9,0x042edda1,0xfdcbf8f6,0x001b0023,0xdc6ef8f4,0xdeebc862,
0xf7b8eba5,0x200114cc,0x4a2d36ad,0x371b42ff,0xed3215ff,0xd8b9cdfc,0x038bfb59,0x258818af,
0x1c4a1d1c,0x0c1d1c77,0xce8ce22a,0xde9bcab0,0xf52bd99b,0xfc31fcdb,0x0234fce7,0xe21cfda4,
0xdb78cea2,0xf87fef5f,0x14a00f22,0x3f1e2ff3,0x3cdc465d,0xf2e91a1e,0xdf0fd118,0x0023f3e5,
0x26f2077c,0x18b822e8,0x15c51f88,0xce92f217,0xe694c749,0xe998e60a,0xfc0af025,0x01a802a5,
0xe131009d,0xd9ffd605,0xf4c2efe9,0x14ea0ded,0x36561fcb,0x43884113,0xf7731d74,0xdb64dc4d,
0xf59cf64d,0x1fa7ff66,0x18b824a2,0x1ec11abb,0xd6bb0309,0xe78ec9d1,0xe23bf0ab,0xf1a3ebab,
0xfc660a2d,0xe7cffe8a,0xd884d777,0xfc0fee4d,0x204103c6,0x2a9c0eb3,0x4b423c87,0xf4762257,
0xde1deb43,0xeeeaf5cd,0x1838f6af,0x17a92e97,0x1d20106e,0xe6591406,0xe814c879,0xec64f1b6,
0xe6cbe863,0x0b4701b3,0xea2ef6d5,0xdc00d7d3,0xffaced0d,0x1843f7e4,0x18fc150b,0x3fc431ea,
0xfac62e08,0xe7afe9ca,0xf4f7f073,0x0d00eb6d,0x2433263b,0x199a0ba1,0xfb44191c,0xe7e8d109,
0xea17f3b6,0xe6e4ef6b,0x127cf30b,0xe712f8fb,0xddb4e2c8,0xf7a1f258,0x104e0032,0x09851e7f,
0x31b824b3,0x064638f8,0xefd1e8e3,0xf18fef1b,0x02b9ea8a,0x253f1b71,0x0f7012c0,0x09cb1ab5,
0xe87de09d,0xea8ef56e,0xecaff16e,0x0997ecc3,0xe498fcd6,0xe2abe6bc,0xfc18f009,0x0babfa5e,
0x09d92343,0x2c5f0dee,0x159d2d34,0xeb29f04d,0xf06cf4cf,0xf458f1d6,0x1e0d1308,0x0cad204a,
0x11ef1297,0xede3f94c,0xe5d0f705,0xf81af5c1,0xf957ea10,0xe30206ff,0xeb13dd93,0xfddce832,
0x064dfe9d,0x144b1b99,0x1f28ff49,0x1d092572,0xe608fd3c,0xf422fcec,0xf1a3f227,0x1921045e,
0x13ca256b,0x15f10343,0xf4c40b07,0xe84ff170,0x0288f447,0xee0bf213,0xf2b80515,0xe61cdbec,
0xf919ed7a,0x013a004f,0x178c195d,0x06fa03ee,0x217722a4,0xe8a40ae2,0xf3f3f598,0xf1c9f111,
0x0971fa77,0x23922884,0x0db3fbb8,0x00061d30,0xe96bf24a,0x0951eed1,0xe76b0046,0xfec2f9a3,
0xdd9de4c3,0xf82dedf8,0xf89500a1,0x141d12ff,0xf3b109f8,0x21471b09,0xf2541796,0xf97ee8f7,
0xef23f1d9,0xf556f591,0x3365205f,0x01800630,0x08a81feb,0xdfa5f9eb,0x0912eca1,0xe8930952,
0x06f8f0c9,0xdab7f3d6,0xfed7e7c8,0xf919ff66,0x15e00b81,0xf773076e,0x24bc09cf,0xff341dfa,
0xefffe43c,0xec03fcd1,0xec3af532,0x3ad50ecc,0xfda2133b,0x14821901,0xe4d3018f,0x0aa3e484,
0xef411209,0x0203ebdd,0xe3c805c8,0xfa82dd6c,0xfc9b0025,0x1675fc3e,0xf802076b,0x1c7d01de,
0x08f1211c,0xeab9e328,0xedbaf9c5,0xea70ed1c,0x3d49fd61,0x0814255f,0x183a12f2,0xedca01e3,
0x0cb7e06e,0xf99e12ed,0x0032ebea,0xf642072a,0xf3afd7d3,0xf6b7fc16,0x0dc5f6c6,0xf05e0a2e,
0x13f201d0,0x0d48294e,0xe7aef0ab,0xefe1f6ac,0xebbbeac5,0x2acaedfd,0x14ac360c,0x0f2c0a2c,
0xf7910369,0x00eedaef,0x020e1313,0xfd83f572,0x0452082b,0xe72ce7b3,0xf470fdc7,0x079ff80a,
0xee460c17,0x0e95002c,0x120d2135,0xee97f791,0xeba9eac1,0xf177e131,0x16a7e63d,0x286a3d08,
0x083b0f57,0xffc4030b,0xfba2e28c,0x033a12f0,0x0593012f,0x03d90602,0xe1b4fd09,0xf1d3f437,
0x05acf1da,0xf222084e,0x1171fad1,0x171c1a2c,0xf992f945,0xe436e91f,0xf37edac9,0x01f9e55a,
0x3d2138f2,0xfd5e1314,0xfe80fb4f,0xf078ecf5,0x09230beb,0x103b03a8,0x034d0ec7,0xf2d102cc,
0xf55ae6fc,0x02f6e4eb,0xfa5f07c6,0x0ed6ee38,0x14601bd2,0xf4400931,0xdda4ee85,0xe9fdd97c,
0xeedfe8c7,0x495e30f1,0xfdf92474,0xfb0ef4f8,0xedb3f9bf,0x0914037f,0x15400411,0x0931150b,
0x015c02a8,0xed13dd23,0xffaae6d7,0xf66d0638,0x05ebf33c,0x11951de2,0xfc2c0ea5,0xd7a1f71e,
0xe7bccff3,0xec0feb86,0x488d1e2b,0x075535b1,0xf47cea23,0xf9d7ff1a,0xfefcfb61,0x19760ae5,
0x1a1d14a0,0x035b003d,0xe43de6d3,0xf81ceebb,0xf9e507aa,0x0741f013,0x13201054,0x07ce0d16,
0xd57afb48,0xe0b2cbe7,0xe96feaf0,0x3bc80ec1,0x108d4733,0xeb94eb5e,0x0265f65e,0xf6c6fb2b,
0x1c4306a8,0x1cdc1b78,0x02530931,0xda15f436,0xf673f129,0x020d048a,0x0571f244,0x111a0b47,
0x0c8a039a,0xdda001f2,0xd345c665,0xebcfeb9a,0x29be0b75,0x20c44936,0xe7b9f059,0x017bf2af,
0xf4dc0242,0x1aac02fa,0x20971deb,0x008e16a9,0xd4e7f72d,0xfdc4eb56,0x048afc18,0x0413fe85,
0x0af3051b,0x0c5001dd,0xe4920ac2,0xcdd6c36f,0xea87ea5b,0x22240c3f,0x2e4e3b8b,0xe6d5f927,
0x004fe986,0xf96bffe6,0x2200fa0b,0x238e1cc4,0x054020fe,0xdeeaf6e2,0xff5fe28e,0x0383fb22,
0x07c00629,0x02cb0236,0x04e80266,0xea4b11a9,0xc66dc643,0xebfae018,0x2233062b,0x2d8b3172,
0xe9cd04aa,0xf77fe60e,0xff25fbc2,0x1d7cf4dc,0x1c4722dd,0x1041251e,0xe624f5d4,0xff3dd796,
0xff10fdbd,0x0a060fd2,0xfd6e0687,0xfd9dfc9f,0xf88c1117,0xbf70cc0a,0xeb99d652,0x1e7a0d66,
0x27c928af,0xf4900e8c,0xed96e2d1,0xfcbbfb42,0x14e9fc42,0x1e2d27c9,0x1b242800,0xe96cfb5f,
0xfbf6d3f5,0xfadc054f,0x10901172,0xfd4f0dac,0xfbd7f538,0x01dc0e62,0xc144d28c,0xe0b2ca46,
0x22fa0ed9,0x239c259b,0xf9050b6c,0xe138ef6c,0xf9b4f286,0x1001fbfb,0x20032529,0x2769235c,
0xef99ffbb,0xe72cdae2,0xf8f409cd,0x1aea0e9b,0xfd8314fc,0xf7b6f36c,0x07d80712,0xc4c0dc11,
0xcddfc420,0x234909ab,0x1e1e2e04,0xfae7114d,0xe575f604,0xf93de7a1,0x0bb7fd9d,0x25c01e1f,
0x268e221b,0xf04d0ba2,0xdab1e28c,0x007dffa1,0x1fbf0b76,0x06091c41,0xf69ff520,0x0f50fe83,
0xc83ce7a6,0xc621c17d,0x278df6a3,0x1fc92d4e,0xf9a7152a,0xe78bf3cd,0xf9e6e1df,0x05d5f772,
0x30461463,0x29351fe6,0xfad80f41,0xd9bee571,0x0705ec45,0x18e20623,0x10de2152,0xf38fff45,
0x11bbf7d5,0xcb93f26b,0xbbd5c1ae,0x1dd3e521,0x27bd3154,0x0479154c,0xee01f230,0xf200de20,
0x0423f95d,0x2b200a7e,0x2bbf2cab,0x028b160e,0xda3eee5a,0x013ce361,0x18a5034d,0x11ed2278,
0xf5ff0b81,0x0572f708,0xcf61058e,0xbb79c24a,0x101ad622,0x2baf27b8,0x134820f1,0xed59f0d8,
0xe3c4dd59,0xfeb40059,0x1b6bff86,0x2dd036d0,0x03ae1c1d,0xe17ef405,0xf463d703,0x0a1a0be9,
0x161326c1,0x01671155,0xfc08fafb,0xe4d60d75,0xc61dbda3,0x02ebc906,0x26901828,0x1cc42680,
0xeaf8f7b3,0xdc39de77,0x0070f970,0x0d7efd26,0x363831d9,0x09f725c3,0xee5af762,0xe521d8f2,
0x05630c35,0x2677144f,0x01781980,0x04aafc56,0xf5a80a1d,0xbf23c4f9,0xf31eca0c,0x1ab90fc4,
0x2bdb2887,0xe8dc03d7,0xd9e7e165,0x0139ec3d,0x00410066,0x360e23d5,0x103b3393,0xed27fc7e,
0xdc11e394,0x1139fa4b,0x25b60256,0x08881fbb,0x09bef9e5,0x0235090b,0xbfcad436,0xe589c89f,
0x09e409ee,0x31e228b2,0xebf50d08,0xda16e8ea,0xfc30e011,0x007104be,0x2dac13d6,0x214a3a36,
0xea08fefe,0xe15ee835,0x1435e8ef,0x143001e1,0x13482cc4,0x050dfb0e,0x092711a6,0xc155e315,
0xd9f2cbef,0x02edf6d1,0x35aa1d92,0xee1316b1,0xe4d7edb5,0xee85d783,0x06760749,0x1cec074b,
0x33443d0d,0xecd305ea,0xed6ee62c,0x0242e0cb,0x08780437,0x1e4928a3,0x0664fed5,0x0d7d13c3,
0xcbd3f37a,0xdb9ac9b8,0xfb4deb7d,0x334e172b,0xf3f51fcc,0xedf1eee9,0xdf31dbd9,0x0b420151,
0x129108b4,0x3f412b48,0xf12913b9,0xe9b8e41a,0xef16ec06,0x00a707ec,0x2a931c3d,0x00c70afc,
0x167a117b,0xd69904c9,0xdb5bc6d2,0xf27de149,0x286e0a53,0xfd191f2b,0xf055ef44,0xdb6eea3e,
0x06b0f891,0x07fb105e,0x3f701d48,0xf7351ffe,0xe470e769,0xefb0ef4e,0xfc43fbeb,0x2731153f,
0xff9a14c2,0x21790769,0xeb5f0cb1,0xdbbac905,0xf004e89c,0x1c8b000c,0x05f7219d,0xef7bef22,
0xdccff1b1,0x011fedd7,0x06190f3b,0x388713fb,0xfd8c24c8,0xe64beda1,0xf142ed27,0xfb0bf76b,
0x26f6104e,0x0924112b,0x17b105e4,0xfe93190f,0xd68acf24,0xf565ed09,0x17cff731,0x068c15a7,
0xf0baf8eb,0xe7b6eb4c,0x013aeb59,0x08450bf3,0x2d550af9,0x02362eb8,0xe8a7ee0b,0xef72e44f,
0xfdc8f5ca,0x244f0467,0x0031170d,0x0ea1110b,0x037c1b7a,0xd243e3b1,0xf774eeb6,0x0f4ffa8b,
0x00c71827,0xf678faf5,0xe07ded2b,0x006ce9e1,0x0c050d3f,0x25f00437,0x07bf2cff,0xe738f3c9,
0xe91bdb15,0xfd0bf62e,0x148f03d9,0x09f62342,0x102809a9,0x05a32291,0xdae3ee27,0xfab4e5ec,
0x03f60054,0xfeb618f8,0xfa9cf852,0xe442f1c0,0xf75adee4,0x10371373,0x18fc0343,0x13472c22,
0xec06f740,0xd8cfda2c,0xf661ff1b,0x0e0e0636,0x16c11ef3,0x11c6029f,0x13202176,0xe21aed7e,
0xfb04e7d1,0x03b40178,0x08941685,0xfbbaf1df,0xed6aeffa,0xec97e163,0x165d0afe,0x0eea0cc9,
0x167b2878,0xf300f9a8,0xc6fede77,0x0226f02b,0x0c1a0332,0x1b551205,0x02c00d9e,0x1f6c1b4a,
0xe0c3ee07,0xf53df43c,0x07fb03a1,0x13a10787,0xffadf001,0xebe6f063,0xe946e7ae,0x1176fddb,
0x13da0e89,0x17e121ff,0xf4f5fbbd,0xc3fde62e,0x05f1db03,0x0f580054,0x1be10eee,0x068e1648,
0x20951211,0xda06fdbc,0x003ef694,0x0c6d0066,0x18fc03ae,0xfc1cf651,0xe849f4e4,0xebf5e611,
0x0482f53e,0x14f7124b,0x17cc2164,0xf1bc03c2,0xd10cefba,0xf698c8d7,0x11c802f3,0x190b11f6,
0x13861cf1,0x17eb0c5e,0xe2ab0787,0x0468e800,0x0b9eff58,0x0a4a0a33,0xf8d504e5,0xe6260348,
0xe9c3e3df,0xfe2cf605,0x0e370fe6,0x1995205b,0xf5020f29,0xdcc0e7a4,0xe345c3f3,0x0ae2fc50,
0x1d1d16c1,0x198d1342,0x12ce0f87,0xef080b50,0x050cdaf1,0x0a9c08c6,0x01c00a4a,0xfb960945,
0xee18081d,0xe762e495,0xf9b6f524,0x121b0646,0x17731add,0x004a1056,0xe31fe77a,0xd134c83f,
0x0ba1f201,0x20121139,0x170415e5,0x11781ab9,0xf5090545,0xf16ae635,0x04720db6,0x018919c2,
0xff7f03c7,0x03f40589,0xdc8ae346,0x01c0f393,0x0f88fc57,0x16671ae1,0x09d50ba4,0xe218f39c,
0xd043ce5c,0x08d4dc40,0x1d570f62,0x17722076,0x108f1f4a,0xf31e0a7e,0xe974efd1,0x05aa072c,
0x0fbb186c,0xfde3fa53,0x1146041a,0xd958f431,0xfee2e8b4,0x0211065e,0x10a21ad2,0x043c0667,
0xe7dffef7,0xcd52cfeb,0xfb39c9d5,0x1aa7112f,0x1bd91e44,0x1c771af3,0xf5260935,0xf37df22a,
0x0a3df3c4,0x17c216c4,0xef27fd74,0x10400d20,0xe0230645,0xffb0d3dc,0xf8a40c34,0x159c160d,
0xfe3c04d6,0xf6a30214,0xd086d8ab,0xdedacafa,0x201714c6,0x22b41975,0x22cc17d0,0xf9d31028,
0xf30cf27e,0xf727fa92,0x157018f3,0xe76f090b,0x12e602dc,0xf454106b,0xf5c8cfe7,0x09260ea4,
0x17820405,0x00440191,0xfdfdfdca,0xd459e1de,0xc7bdcc90,0x224b0695,0x13121dac,0x1b9d2275,
0xfb611809,0xf3fbf26b,0xf3e102ed,0x1f5a0b23,0xef5b0ee0,0x1689eb32,0x01321471,0xdca7e31c,
0x102d0850,0x0cde0857,0xf9affa33,0xfc1300e0,0xd704e8d5,0xce2dd20b,0x1ae9ec66,0x141a2a8f,
0x1d2521e6,0x0374164d,0xf59cf68c,0xfb85fd51,0x2325ff53,0xf8580f30,0x0162e7ee,0x08a52059,
0xd9feefd4,0x1315f571,0x0c2113b3,0xf438f994,0xfc6a0151,0xe122e903,0xd649d50c,0x0a6fda67,
0x1fd33022,0x2461160d,0x0e57100f,0xf891f551,0x0584f9da,0x197bf9dd,0xf5a31ae5,0xf4fdf3e0,
0x0fef15d3,0xe78efd89,0x0cdae755,0x17c51572,0xed9af775,0x00c3f2f4,0xe023f0b8,0xcfcad893,
0xf76ee1e2,0x2c2d25c9,0x29c40f55,0x019a1bf8,0xf361fd31,0x029200b0,0x0225fe9e,0xf1e32a62,
0xeffff5cd,0x151a01cd,0xf91f05c8,0xf7d1e571,0x299c1739,0xeb2afda4,0xff5ae6df,0xea32fcb4,
0xcb91dc5b,0xf2e2e0da,0x2b4514b6,0x17f11bb4,0xf7783067,0xf3b803ff,0x04f4fe07,0xff41febd,
0x0a4b1aba,0xf5f4eac6,0x0dd5f256,0x090c0fb1,0xe470ed37,0x32480dcf,0xe7390e47,0xecf2e1c2,
0xf11b0711,0xd0bae3a9,0xf41adb0d,0x258008d4,0x16d629b3,0x0e2f28fa,0x01d7f694,0x0786f797,
0x08a8ff85,0x149a06be,0xf7e7ed93,0xfc40ebd7,0x0ada14ae,0xe21c0235,0x2f5efbd3,0xecf82671,
0xde7bdd75,0xf81afd3a,0xd51fec33,0xeb8fd720,0x2477fc58,0x222e26d2,0x1a6d1ab9,0xff3df41b,
0x004101d4,0x04db059c,0x0cea06bc,0xebe7fff1,0xec36eeb6,0x163d070f,0xeb3d0ba2,0x2379ebf9,
0xf8123a36,0xd79fe225,0xfd7ef055,0xdfe6f210,0xe7e5d2ef,0x1443fa76,0x276e2673,0x19391fdd,
0xfa47fc8d,0x022b07d4,0x0bceff54,0x02bd09b8,0xf957024e,0xea8ee62f,0x121bf703,0xf3fb1625,
0x0e57e6af,0x12083d0a,0xd103e745,0xf7edea29,0xec69fa08,0xe370d3c9,0x09d9f83b,0x27942398,
0x182225f0,0xf96201a4,0x04680426,0x0d6ff925,0x00ab1248,0xfeb0f57b,0xebb6ecb6,0x0488ea46,
0x03cc1cc0,0xfdc1e852,0x2a2736ef,0xd8d5ea71,0xf595dac5,0xf240fa25,0xe0d3d77a,0x0a42f21e,
0x22b620ca,0x28e42449,0xf37a0984,0x015e0621,0x01daffb0,0xfeab1cc6,0xfa2ff51c,0xe822fb44,
0xf953e490,0x13270fbf,0xf480ef15,0x36cb2431,0xdeb6fd43,0xedb8d8ba,0xfc87f529,0xd8bae03e,
0x02f7e9e2,0x2264161e,0x32d818ed,0xf2c6166c,0x01690384,0xfbf6ff58,0x0b801a6d,0xf333f330,
0xf639f80f,0xec06e1e3,0x136007b8,0xf10cffea,0x30f31561,0xdf7c15fe,0xe4dcdc31,0xfbc6f36b,
0xddb5f1b7,0x0116e1b3,0x24be1007,0x25d419c8,0xfeff27ad,0x0db6f929,0xfb0bfd4e,0x1a8e0d88,
0xef06f344,0xf3b3f560,0xdfd6efd1,0x0d7afc7f,0xf3a60aae,0x2c5907da,0xf4c91d60,0xe58ed5d6,
0xfdf1e7d9,0xea5bfca9,0xf324daa7,0x20cd114f,0x18e518f1,0x0fd22aed,0x0bbaf9dd,0xf6cb02d8,
0x167b059b,0xecf30416,0xead9f0f6,0xe226fafb,0x0904ea4c,0xff850b69,0x272afd0b,0x052a1f65,
0xe47bda11,0xf40be042,0xf287024e,0xe7f7dffe,0x192b0abb,0x148f1f23,0x171a2748,0xff6c07b7,
0xf90b1138,0x1112fd2c,0xf6540d01,0xec7fea48,0xf240f58b,0xfe9ce001,0x085d02da,0x163bfe7e,
0x0a67252f,0xe122e896,0xe589e6a2,0xfc05068a,0xe2eaef02,0x1474fe38,0x14241a8b,0x1c831f77,
0xfc6d11fb,0x0966124e,0x1016ef69,0xff1a0d9c,0xefa8e5d2,0xfed0ec0d,0xed88e201,0x016006ad,
0x07a30684,0x103128f7,0xdd3bf2f4,0xe071ebab,0x0241fa62,0xea0bf873,0x0fb5f656,0x15081590,
0x1c471eb9,0x04ee151d,0x1e45062f,0x0812ed54,0x04d00cbc,0xe54fe9d5,0xf62cf024,0xe13df6bb,
0x007aff86,0x0550096b,0x168721fe,0xdfecf848,0xe39ae63a,0x01c8ec2c,0xf8dcfae2,0x06f3f0ce,
0x117813f2,0x19a715f8,0x0f3d1929,0x1c3701dc,0xfc0cfc2b,0x000f18b2,0xe427ed4c,0xf38ee9c7,
0xe731fb47,0xfea1f01d,0x081805dc,0x1f071658,0xe408faf1,0xe6daeacf,0xfd0de5a1,0x03340140,
0xfee9f75f,0x1357130f,0x11d013ae,0x130418f0,0x10ec0774,0x03cd0b76,0x03e0129b,0xe02ff420,
0xf8aae5a7,0xf004f252,0xfd47f31f,0x06ff002e,0x1d79169e,0xe2180640,0xe8fce3df,0xf09be2f6,
0x005d05a0,0xf53006c0,0x1d970cc0,0x12200bca,0x1bb910a7,0x13580d7e,0x0fed0735,0x0f75058f,
0xdbf1f8d4,0xf38adf78,0xed28ef97,0xf998f6e7,0x0103fa21,0x20e40da7,0xe90e0fd0,0xe6f7da1f,
0xed5ce8dc,0x041e030d,0xfcca0a46,0x1b0b072c,0x0b7a0ecd,0x19400d0d,0x1069104b,0x0a800dd1,
0x0a1a0d08,0xe5c30624,0xf067d805,0xf0a2f2d9,0x0264f730,0xfff9f868,0x19a70809,0xf01a1a30,
0xdde1da6c,0xec53e56a,0x051afc2e,0x03fc0992,0x181e020a,0x05f116c0,0x10b70f3a,0x0f2017fb,
0x04351a2c,0x088310d6,0xf8ba04e3,0xdb9dd889,0xebfbfa24,0x089cf8d4,0xfe83f6b1,0x12080830,
0xfcb215d1,0xd611e0f5,0xe834df31,0x0685fbf4,0x09f909d5,0x0f680248,0x06bb1b3d,0x13ab0ec7,
0x0b0d11a2,0x0e92235f,0x0e9c04a1,0x0419ffbc,0xcef7e765,0xf668e9c8,0x1148eec2,0xf2d7f9af,
0x06c9099a,0x03f615bb,0xd801e61d,0xe463d775,0x0c0df958,0x05ad034f,0x06380c32,0x08e81357,
0x18430c78,0x03250ed9,0x2376213a,0x0a37fae1,0x09e9029b,0xd08bf964,0xf678daa7,0x09f4f66a,
0xee8c0707,0x07d4068b,0x11d80624,0xd813eb96,0xe51ecbb3,0x0c21f2f7,0x06cf044b,0x0f66105e,
0x122f08a8,0x1c030b60,0x050c1a4f,0x30cc10c0,0xfd140202,0xff630558,0xdbc60eca,0xea84cbc4,
0x062900a2,0xf2cf086a,0x046a00c8,0x0fc6fe66,0xd8a0f970,0xd93fced7,0x076af330,0xfa70092c,
0x14910ec7,0x06fe0970,0x1dc50c41,0x0dca1f6b,0x2a9e07c9,0xf078149d,0x02fcff2c,0xf6bc0b11,
0xe3eec85c,0x0e3efc57,0xfad30c85,0x079ffa1a,0x0327f4bb,0xd8700f71,0xd116ce59,0x02b8ef94,
0xf24507bd,0x141c05d6,0xfe6b0e18,0x20390930,0x1c82271c,0x1bab0e59,0xfad11e35,0x0120f147,
0x08a00feb,0xdaefce89,0x0f88f6ee,0xfd971297,0x02b3f665,0xf3a2f1b4,0xee410eed,0xd055cc77,
0x0416e887,0xf8c90ac8,0x1292fdb4,0x06de0cc5,0x1630fff8,0x24bf3212,0x0ffe15f3,0x040717fe,
0xfb43f0b3,0x144a054b,0xd293e447,0x0cdaf289,0xfc44205e,0xfc42f683,0xf13bf117,0xf923020e,
0xcd54d777,0xfaf4dcdd,0xfb020c5a,0x0682ef44,0x118e0a7e,0x0d2c0145,0x3436304f,0x0dd52ad8,
0x0a410e65,0xf22af3f3,0x0e66ff44,0xcfecfc38,0x0253ed92,0x0ca92055,0xfdcaf1cc,0xede1e7a4,
0xfa9201ad,0xd254e365,0xf7c2d6e9,0x04eb0922,0xffe2e9eb,0x10a0037a,0x040e077b,0x3a83272c,
0x13d13d3d,0x01300647,0xe71600f6,0x0cc1fec7,0xe35704f7,0xfd4ee87d,0x1d661e71,0xf78bf4d8,
0xe5dddf28,0xffc2f730,0xdfa1e745,0xeb15d4ce,0x033201da,0xec3ef949,0x0717f6bb,0x08f811dc,
0x3fa21d48,0x2e484435,0xf92505f4,0xf0fc02b2,0xfd23f62c,0xef1e0de9,0xf3b0f0ae,0x25aa1bb0,
0xf712fee8,0xdc39e2ea,0xf96cedef,0xe919f34f,0xe363db35,0x0568f83c,0xe920fdb7,0xf845e726,
0x157f115a,0x416d116c,0x40784812,0xf69b1102,0xf8b0fafb,0xf5e2ec44,0xf8f405dd,0xe767fbd7,
0x2f6b1169,0xf01f0691,0xd107e875,0xec69ea40,0xf543f96c,0xe5a1e40c,0x0221eeb4,0xef80090f,
0xe40dd966,0x12c209b3,0x36f210b9,0x48484dd6,0xfd051f98,0xfddcf791,0xe9a1f537,0x036901f0,
0xf21d044e,0x2bff057c,0xf8121ab9,0xd54aeab9,0xe92ddbdf,0x0039f45d,0xdfa3e336,0xfd9bee93,
0xf1d804da,0xd6f5df4a,0x1112f647,0x357916b0,0x44a0573d,0x072e2f6b,0xf9abfaf0,0xe4c0f73a,
0x051bf7d9,0xf60e0238,0x21f5022b,0x01181ed9,0xdb4ce7cf,0xde43d6d7,0x0bf1f4bb,0xdb69f880,
0x01c5e82d,0xfa9301f2,0xcf6ddfcd,0x07b3dcb7,0x2dee17ac,0x4ab851c0,0x14f52ffd,0xfbf50020,
0xe851f821,0x0e1ee92c,0x05940529,0x217dfc82,0x087c1f85,0xdc9eef12,0xcdbdd45e,0x0a28e6aa,
0xe15f0a4f,0xfde3d70d,0xf6d10616,0xcdade00b,0xf824d009,0x2fa90ef3,0x57915154,0x1a8634d7,
0x049a0e66,0xeb69f3cc,0x0685dd8c,0x02c01310,0x16b2fa12,0x08082588,0xd902fd91,0xc962dac1,
0x0951de93,0xf7ec140e,0xf407d723,0xfce30734,0xd687e641,0xe23ac3cd,0x2f0f041e,0x545d481e,
0x1e4f3ea1,0x0bb1168e,0xeeb3f2f8,0xf2bbe5ad,0x102f16c6,0x0f7e0527,0x10bf1f06,0xe260faa2,
0xc9e4d6ca,0x05c5d16f,0xffe713b7,0xec86e11c,0xf913fdb8,0xdad6ecc9,0xcafdc355,0x233af923,
0x50c543cc,0x26f53efb,0x117d21ad,0xeae0f731,0xeadbea2f,0x1ad60ed6,0x11900de3,0x0c761bca,
0xf030011f,0xce11cb25,0xf7a5c845,0x00ad1eb0,0xee11ed02,0xf5a4f989,0xdec8ee4e,0xc056d06d,
0x1c77e0a1,0x4e06408f,0x2c6c417d,0x206e2502,0xe039f888,0xeb3fee07,0x1d5cff95,0x1f45114c,
0x09dc1d18,0xfba30945,0xcd18cb65,0xe7ecc963,0x0a0a241a,0xf3bdf209,0xfb20fc2b,0xe26be314,
0xc164db7b,0x0974c93d,0x46253a23,0x35af4383,0x31c6236c,0xdbed06fa,0xfae1e9bb,0x2094f1da,
0x1b20133b,0x09c62b1f,0xf545083f,0xbd7ad966,0xd6a7ca60,0x182111fd,0xfd8ef682,0xfdf8f89c,
0xdbc4e9e6,0xc7bbdc6f,0xf6aec2f2,0x44e52ee8,0x3f1f3835,0x3373274c,0xe7921318,0xf6a9d34d,
0x1364f635,0x14e92323,0x15a5316c,0xfbc50945,0xbe45dee0,0xcbaccb3a,0x1d44030b,0x003400b0,
0xfd88f60c,0xd7c5f4ba,0xd694d77e,0xe8ccb66b,0x3dc01a49,0x36c33c6e,0x331d31ec,0xf54f273f,
0xe95cd074,0x0c46fe68,0x140e2aab,0x25032bcf,0x02dc1439,0xbe0ce600,0xd1b2c5d0,0x161ae41d,
0x097e08aa,0xf289fbb5,0xdf10f949,0xd677d79c,0xd2a4b6bf,0x33e90f94,0x2f423c68,0x33103a71,
0x005833b3,0xd44fde98,0x061afa76,0x1eb4298c,0x2e4a2419,0x13251798,0xc649e9f4,0xd6a4b902,
0x0453d611,0x0b6b1300,0xee7b05e0,0xe9bbfc6b,0xd8d0d889,0xc37dbf88,0x2497fd52,0x309e38b0,
0x2f983462,0x14d02fe9,0xcc97efe1,0x0606e723,0x2f0b21d8,0x2953228b,0x1a491ca9,0xcf47ff9a,
0xd39cb4d3,0xf2bcd68b,0x068a0ef2,0xf6a307b5,0xeaabf6f4,0xddccdeb6,0xbedcc883,0x17b6e900,
0x3c572d96,0x32e432af,0x224b2ca4,0xdc96fdad,0x002ed891,0x33ee12fe,0x2483267d,0x17ce252a,
0xdd2b0d7c,0xc4a1bf4a,0xde5ddba0,0x109a0ceb,0xfbda02d8,0xf192f4b2,0xdf88e45d,0xc05ad985,
0x066ad580,0x352724a7,0x2f5d34d5,0x25fd2707,0xed5709b0,0xfa02cb9f,0x28610e4d,0x232f3042,
0x13cb2f93,0xf4a7131c,0xc045ca04,0xda86d9d1,0x15ad01f0,0xf3b602ed,0xf4bff0d5,0xe156e5a7,
0xc750dca0,0xf477c86e,0x32041b03,0x2934316d,0x281328a4,0xf8c70eba,0xe900da58,0x1d551383,
0x28172fbb,0x1d833250,0x00ad133e,0xc730d783,0xdf56d3b3,0x1667ed75,0xf2df0658,0xf150e259,
0xe188eae8,0xd217e340,0xdd6cc949,0x2c6f15a2,0x231531d0,0x2ddd26c0,0xfc7513e0,0xe24deb5e,
0x1d1b0932,0x289e2323,0x305d2c9b,0x0ab00af5,0xd400dca4,0xe424d1c0,0x133fe7d3,0xf93a1117,
0xe429e1b1,0xec6feaf5,0xdaa3e53e,0xcf28ce0e,0x289e037f,0x1ef72de5,0x29a71dcc,0x049d163b,
0xe9eff310,0x1ca2fb83,0x2eb72214,0x373519c2,0x1163143e,0xd0bbe5e5,0xe1c9ddcf,0x023eece4,
0xf4df1b2c,0xdcbce5c0,0xe01be2fa,0xe134eb0c,0xd3ced745,0x20a2e946,0x27603889,0x22261738,
0x0a9e18ab,0xf081f91a,0x16bcf042,0x299f23b2,0x2f031960,0x0de32bf0,0xd1b7f515,0xebcade66,
0xf7f2f5c8,0x0146180e,0xd8dfea40,0xd589de28,0xe485e1bd,0xd214e1ed,0x1266dd8c,0x2ec12f55,
0x1e2c179e,0x0cb512c0,0xfd6702f5,0x0c03f2ad,0x27fc2275,0x191f258a,0x16d6338c,0xd29e00ea,
0xed51d6eb,0xfd2dfcdd,0x08090fa7,0xd8e6f082,0xce2cd9c0,0xe1a2d3e5,0xdca9e0bc,0x036fdfac,
0x2cfe2446,0x1f6f2533,0xfc400f5d,0x085507c6,0x038bf618,0x22d1249f,0x15ca2bc3,0x25832991,
0xe66e04f0,0xe74cc91f,0x099d07ce,0x0c7d0726,0xdf10fa32,0xd418dc08,0xd646c461,0xdd28de96,
0xf86fe538,0x26621e3a,0x24572cc0,0xf50e179a,0x0b2afc8d,0xf9bdfee0,0x20f323b7,0x1dbb27c7,
0x2b621ddb,0xf3ed0ba2,0xda37d2a0,0x1951fd2b,0x0bd40cd4,0xe53bf456,0xe235e165,0xbd9fbd13,
0xde77d791,0xf39be094,0x27c516c1,0x2cc426a7,0xfce820d4,0x05f1fa39,0xfb170698,0x34e41221,
0x18001ec8,0x23102211,0xf7bd1436,0xd0cddf20,0x13c7f7fd,0x120c1c46,0xe4d6f96c,0xedeae052,
0xaf2acb5c,0xd7e2c530,0xf121e009,0x1df10838,0x333a26b9,0x018123fc,0x076bf644,0xfd840896,
0x35420146,0x135c2e69,0x22eb24c4,0xfee519db,0xd129e82c,0x101fec43,0x186b21bf,0xdf8b02c9,
0xed8cdd93,0xb2f3d8c4,0xc856b548,0xf0b2de37,0x1e9cfa31,0x33262658,0x187a2914,0x0225f01a,
0x06f30d44,0x1ceaf906,0x277e34d5,0x28a51524,0x00e61a8d,0xdf37ee97,0x049be1b4,0x20a52747,
0xe4af0f50,0xe9d6de0b,0xb830eba5,0xbcc1b1dd,0xeb3ecda6,0x082ff3a5,0x30a82323,0x1c2f2dcb,
0x0059fb66,0x0b760904,0x1508fc26,0x317222a5,0x25101db3,0x0ae01fe8,0xf1ebe8e9,0xefd6e1cf,
0x2a3324d9,0xf00812a7,0xe085df89,0xccf0eb6a,0xb578b114,0xe024c664,0xfbb7f55e,0x24431cdc,
0x1f1934d6,0xfefc069f,0x0d6b04ae,0x1239084e,0x243b155a,0x2f1626a9,0x138d1f27,0xe8e5f6b5,
0xf2c7ed62,0x2f541120,0xf9181bdc,0xdface09f,0xd46ce48e,0xab94c130,0xda89b854,0xf7fdf0ea,
0x21370e28,0x2bf92fc8,0xfa9f0c3c,0x089c0aa2,0x0d6a0d8f,0x17491450,0x2d2e20f9,0x11162ef9,
0xf02802e6,0xf24ee834,0x30310cd2,0xfd63216c,0xe3f3eca7,0xd41be3d7,0xb0e8c3a7,0xcb9fb3a9,
0xefefe794,0x1a4107fb,0x31f42179,0x009217bb,0x11d90463,0x12200e2a,0x13300bf6,0x2a2e1fbf,
0x20892d2f,0x004005dc,0xeeaeea14,0x3167003e,0x0475266c,0xebebef28,0xd6b1ed28,0xb87dc0c8,
0xc0edb651,0xea9ddfa2,0x192c01f0,0x279b14a2,0x0c1d2125,0x0bc9fedc,0x174e145d,0x059710c7,
0x2ead1169,0x1e4e2975,0x07e811e1,0xe8f9fc03,0x25a8f5a6,0x097037fe,0xe797ed69,0xdf2feedc,
0xb599be05,0xbcc7b6fe,0xe141dcaa,0x1147fa92,0x14ab18f3,0x13b72401,0x046f0097,0x21081532,
0x0d8218b8,0x28a0fe9e,0x21e33455,0x0fa20da3,0xf13606bc,0x0bd4fd2a,0x23c1323d,0xe470f20b,
0xec08e906,0xb52bc63f,0xb4bbb1b2,0xeae1d7be,0x083def8a,0x16201944,0x1ba7189e,0xfe1f0645,
0x26130c1f,0x0dc61d78,0x0d07fc04,0x2aef39fc,0x0e440bfe,0xfb4411ca,0x0a59fdd6,0x2ca423e2,
0xe30602c7,0xeb96ea24,0xb770d265,0xae18af17,0xe929ce7a,0xfacaf0fc,0x197d0dd3,0x1cec10a0,
0x04310c6c,0x1f0201fb,0x17d228f1,0xfe92fe3b,0x397b3351,0x094913d5,0x08c7150d,0x10f9ff86,
0x253f19b0,0xead112ff,0xe857e072,0xba19db99,0xa63aae27,0xe141c2df,0xfb6af6a9,0x118607b7,
0x188c0ecc,0x08e4134f,0x10affe75,0x28ad293b,0xf2fc08db,0x3e3f1d5c,0x069d20e9,0x105b1806,
0x09540726,0x151e26d8,0xf7b21bd4,0xeb4ddbe7,0xbf51df7f,0xaafbada5,0xd60cb747,0x0432efbb,
0x0e820836,0x12fb08a8,0x0aba1b33,0x047f04d6,0x28471fb6,0xf6c71ce8,0x35e0099f,0x0a9331c0,
0x1e831005,0x0ace0f52,0x181125ba,0x0825154e,0xe31ce165,0xc54de6fc,0xa8cfb379,0xcae6aa56,
0x0aaae16e,0x0b1e020a,0x04c90531,0x11b21d1b,0xfe650e15,0x1d8718e3,0x09f71dee,0x2062fb4d,
0x1d2032c0,0x1a8b0b21,0x127a1a47,0x1e4118af,0x0c6d1387,0xe4aae7f3,0xcb6ce7cf,0xb2b4b36a,
0xc355a1ad,0x0441d7c5,0x071d0d31,0xff3203cc,0x1cdf12f2,0x049b13ff,0x212a1400,0x13a01e36,
0x0cf701f5,0x228a2ce4,0x12c216f8,0x1e701bc5,0x1e371c20,0x0da8147b,0xdee5f27f,0xd458e8fe,
0xb029b34d,0xba92a78c,0xf318d0eb,0x07b30d58,0xfe6d0909,0x135609a2,0x05ca2050,0x200a1205,
0x12da1be6,0x087506ea,0x1ed9227a,0x18601818,0x1d5d16f9,0x1c6a2716,0x10a0165b,0xe2b9f84b,
0xe163e5f4,0xaab9bd7e,0xb688a1fb,0xea7dcdba,0x0b550230,0x04350970,0x0d91047e,0x128c116d,
0x1e2f1076,0x18f11da0,0xff8a10c2,0x25401cc1,0x1f9819db,0x1a1e1524,0x26f22ac5,0x101e1e0f,
0xe35b0231,0xe72de756,0xa2fad046,0xad34a149,0xec9bc72d,0x0791f0c6,0x089f07d9,0x0aa603e3,
0x10d90c71,0x1a5f1268,0x15f120d1,0x022e1506,0x2255128d,0x1f0e1d94,0x10321b7a,0x2e0b26fe,
0x13b328af,0xec3b0236,0xe52be4e5,0xb420d88a,0xa75696bb,0xe55ebf73,0xff66ef77,0x03120777,
0x0f6d05e5,0x09b9095d,0x108f1697,0x1c962506,0x058f17c5,0x1bff0c10,0x1928258a,0x1001241c,
0x340a1a0a,0x19d62a7c,0xf76507a8,0xe7c2df22,0xc681dd90,0x9b4a9bb8,0xd673b53e,0xf567f77a,
0xf86f0629,0x0feb06f1,0x080f09fe,0x181e0ab3,0x27bc1ff0,0x0eef0eec,0x13120c9e,0x1b72243a,
0x1ad1263c,0x30200bd2,0x25f92b29,0xf5e710c2,0xe61be777,0xcdcbdeb8,0x90fdb08c,0xca77a6cc,
0xf327f36f,0xf8f300ce,0x1842fa4a,0x0e56095d,0x1c63fbc4,0x2e281b77,0x17560d72,0x172f0f24,
0x27a919c2,0x26211b82,0x1ae50f36,0x23f738d5,0xfbc01d90,0xe37dfa12,0xc565e993,0x9cd6bd3f,
0xbfc89d1f,0xf3b6e29f,0xfc16ff5e,0x0e1ef007,0x0ca01373,0x0a590334,0x375a1328,0x0a0116ba,
0x15a2161f,0x21591a32,0x193b221b,0x0e871fab,0x27392ea1,0x088b1ba6,0xeb91f9a7,0xd8f4e70a,
0xaa7bb94b,0xb7959861,0xe6afd8c9,0x0045feab,0xfccef313,0x0dc21a31,0x04a909db,0x242413b5,
0x01b62ee1,0x1a8914ae,0x27351edb,0x1c5b2224,0x14571dcb,0x34501c4d,0x107816e0,0xf3ccfecc,
0xf057e567,0xad4fb8c9,0xad3c9bf9,0xdda4cd19,0x0421f695,0xf65af535,0x148f0ff4,0x05510e8c,
0x14d0117f,0x1014339b,0x16480c9a,0x29dc1af3,0x226e267f,0x23531285,0x333f0ce6,0x04ae2409,
0xfa0605a0,0xf2bee9e6,0xa608cd7d,0xa2aea265,0xd74dc630,0xfbd2e5c0,0xf5a6f7c5,0x1804ff8d,
0x108f0fa2,0x16640cd3,0x18862a58,0x151e1249,0x27d0190e,0x24b42f85,0x25010d6b,0x1e51184d,
0x060e2cdc,0xfc9a069e,0xea67efa8,0xb248e267,0x9d74a0d0,0xd309bba9,0xf488ddd4,0xf5acf813,
0x0d90ffbb,0x14480d34,0x0b681718,0x20a31ee3,0x18e214fc,0x2281120f,0x2f132f96,0x1768112d,
0x196129f8,0x11d22694,0x06c00602,0xf2c5ef72,0xcc3fe8b7,0x9eb1a8b7,0xc994af64,0xe923d946,
0xf46ef98d,0x0777005d,0x14b60496,0x0cb71ff8,0x1ed012a7,0x1737201a,0x210c0f1b,0x2f063305,
0x102d1e7b,0x26732310,0x1782163d,0x09840691,0xf060f6f4,0xddcceb4d,0xa08cb6f0,0xbb11a8b0,
0xe4e4cd47,0xf5b5f43b,0x0812f69d,0x0daaff5a,0x10c924b8,0x12d40fc4,0x2218249f,0x1d970861,
0x2edb3038,0x144e2729,0x2eaa17bb,0x12e31890,0x01090a4d,0xf2fd01ec,0xe70ee611,0xabcbc5b2,
0xab20ac47,0xddd1bc38,0xf5f2f188,0xfb78f589,0x06cd0493,0x1bb928be,0x0e0b10fb,0x294e19d6,
0x11951416,0x30502efe,0x1f982bfe,0x2c4a0d56,0x0f8722f5,0xff8d0f91,0x0089fd5e,0xe098eb9b,
0xc534d2d5,0xad26aa2c,0xcc6da7a3,0xf8a1f1dd,0xf5bcf83e,0x060efa03,0x22582987,0x0cb60e87,
0x29ea135d,0x0a1f2498,0x2f5a223a,0x2a9d2f53,0x1e8b0fd1,0x0ff32ff5,0x0fc30e54,0x01beefe1,
0xe473f454,0xd41dd5f8,0xa54fb396,0xb867a634,0xf0cee4d6,0xf37dfe22,0x00e1eff4,0x325e1f5f,
0x0f311720,0x247a057b,0x18b72f6d,0x26cb1198,0x320936ea,0x14e51dbc,0x1e572519,0x1d5a0ad7,
0xf69def83,0xe9f8007c,0xd639d735,0xa496c2f6,0xa901a0e1,0xe916d240,0xfd0df8ea,0xf6fae86f,
0x36301174,0x14771e93,0x12f604a2,0x28743928,0x18f61233,0x3e003238,0x11b5299f,0x20861ab0,
0x177d11c6,0xefaf04b1,0xf3affc9f,0xdb89e095,0xaaf1d5de,0xa54397a9,0xe090c7b1,0xfd96eedd,
0xe8cbee4b,0x211213ed,0x19c22c12,0x04a109f9,0x36462ea0,0x112a2204,0x3fdd27d4,0x1c9b3770,
0x19131205,0x13861c52,0xfc160d08,0xf7bbf47f,0xe922e657,0xb530ddbe,0x9e5a8d71,0xdb83bfb6,
0xf344e151,0xe9faf4d4,0x16d60656,0x1fa02515,0xfa01128d,0x3b481d1e,0x115f28d4,0x38e01f4f,
0x2b5e3f70,0x16690bff,0x1c5217ba,0x04130cba,0xf783fa86,0xeb5ee884,0xbe9be97a,0x91a5935b,
0xd66db420,0xe68de4cd,0xf6c2ee66,0x112e025a,0x24b91a8f,0x02aa1a06,0x317d129a,0x191a334d,
0x332d1ed1,0x34553808,0x1ac20ea0,0x1e140de4,0x07d4165d,0xfcd60566,0xf047ef8f,0xc844ef9a,
0x84369eac,0xcdb3a786,0xe480e4ac,0xf495e2bd,0x13b00194,0x23d40b39,0x118c13e3,0x2da00374,
0x270531b2,0x30751db9,0x2fa239b7,0x1449211d,0x10881092,0x0ba3230b,0x017f086f,0xf2dafa69,
0xd1a4f13d,0x8848a857,0xc7f39650,0xe5c8da81,0xe571e01a,0x0ee9030d,0x1bb1083f,0x0b2f16c0,
0x25c70823,0x2ba82d38,0x29cc2819,0x30993c90,0x18001e5b,0x0415155c,0x140627df,0x05940c05,
0x054cfb91,0xd3ceecfb,0x96c7b289,0xb29a85e5,0xe245d8a2,0xe45ce41d,0x0dcaf4f3,0x11260a40,
0x06a61095,0x21550fff,0x2d1b2a00,0x2e3f2e9a,0x37c1393b,0x1af31fd5,0xf9181a3f,0x25ee1f8f,
0x0fff12c9,0x11d2fe10,0xd698f3f7,0x9d47bbdf,0x9e9c8910,0xe041cf61,0xe595e870,0x0aa2eca0,
0x070f0620,0x02f20f2d,0x20660479,0x2a802ae4,0x39e52f7e,0x3c0038ca,0x1a0b22a2,0xf8f2197a,
0x31690a36,0x12b91783,0x0dd90927,0xdb4c09f4,0xa810bcb7,0x8dc58fcc,0xe1c5b859,0xe532e701,
0x0351e2e4,0xfe940914,0xfc7f06fb,0x1480039a,0x26ab2aa5,0x375434d7,0x3e453b28,0x1a612a5c,
0xfa712045,0x2ba9fbd5,0x1c4f2453,0x11731382,0xe77f11a2,0xb1f3c483,0x869d96d2,0xd88ca7fa,
0xe94ae9c9,0xfb37e4c9,0xf7d40957,0xff5dfd32,0x08d50384,0x2d4e22b8,0x36c4334a,0x4520406b,
0x1fb633c7,0x06a81ef6,0x1b19ed93,0x1cf42eb5,0x15aa195b,0xf8f10eaf,0xb6bacb65,0x8685a95a,
0xc3f095ac,0xeb5af0a8,0xf661e152,0xf7340712,0xfdcff382,0x0aa3fdc1,0x2a4915d8,0x37dd3592,
0x42ac41d2,0x25613db3,0x10121d5c,0x054bee76,0x1dda3274,0x1b9323e9,0xff4f13cb,0xbe8dd706,
0x8903b45d,0xb1218a54,0xed80e3e5,0xf152e994,0xfba8ff76,0xfa0fe9c8,0x0414fc84,0x28e00703,
0x34973362,0x447b3ead,0x330b4046,0x175f1f75,0xf48bf529,0x26082836,0x1ee32651,0x06931e0f,
0xc24ae023,0x95b0c519,0x9f9d8415,0xeef0d679,0xf279e882,0xff05fb78,0xec18e504,0x039100b7,
0x2374fd4c,0x2eb5354f,0x4a5c3b1a,0x3f3c43da,0x1ad31dd1,0xed8405f4,0x250613de,0x221f2d06,
0x0dd521e7,0xcfcef136,0xa1caccda,0x907b8acd,0xefb6bec1,0xe7fdec51,0x0330f9c3,0xe4ade68c,
0x0472f691,0x1953f78e,0x29213036,0x45b439e0,0x46d9488c,0x17fb2e87,0xf36d1081,0x182503ae,
0x213e3029,0x149b1f94,0xd7a3fe4f,0xb168cfc4,0x87ce952b,0xe4d7a918,0xeaf9ecb2,0x01dcf62b,
0xe8acea16,0xfcc6ef46,0x1217f464,0x2c5e2a94,0x440b2fdb,0x4ed64a36,0x24c13794,0xfd180f35,
0x0655fff8,0x27342616,0x1f9422ff,0xe8220597,0xc0bfd603,0x8b28a050,0xcbce9a02,0xec86ea26,
0x07e2f0e7,0xea07e788,0xfe20e823,0x078feeae,0x2e7d243a,0x39a1249f,0x55144db9,0x2b5b42a0,
0x04631664,0xf98a002e,0x29ac1b17,0x1f5e1d62,0xf8d90a28,0xca41e073,0x9435adcb,0xb72b9602,
0xed8bda10,0x0386f151,0xe8cdf30a,0xf567eaf5,0xf731f597,0x2e261c7e,0x26a92352,0x59674b77,
0x31c950a1,0x08122281,0xfbcd0647,0x23660c33,0x1fd3198e,0xfe521741,0xd27aedec,0xa10db846,
0xa7259622,0xe618ccb2,0xf9b0f379,0xe4ecfe27,0xea84ed10,0xf36bf6dc,0x2a020f14,0x1bbc2638,
0x603c4135,0x414b55e5,0x0dd12227,0x0169074c,0x19c600ac,0x16991a31,0x03b320b1,0xded3f5be,
0xaa59c33b,0xa2219cb6,0xd237bf5e,0xfae2f43b,0xefffff08,0xe966e9ce,0xf5a4f0a7,0x223002ec,
0x138e2623,0x5b6d33ee,0x50c45e23,0x11ca2b6d,0x0b5509cc,0x10aff8db,0x0f5d12b4,0x14f81d16,
0xf1d9f2b7,0xb534ce7a,0xa843a346,0xbfccb747,0x0475e7be,0xf832f8eb,0xe422e593,0xf4d7f4af,
0x1984f969,0x136f2211,0x51382693,0x5d616780,0x193c3869,0x13c808f5,0x033f0061,0x0bca07a0,
0x17001cc0,0xf1ebf9e4,0xbd71e09a,0xa420a740,0xbbdab922,0xfd43d57f,0xf86afdc8,0xded6eebd,
0xf138ede3,0x14c9f5e3,0x11e11f35,0x405a1d8b,0x67ec6173,0x20d9429e,0x0ef90e86,0xfe230abd,
0xfcd307af,0x15721a18,0xf3c90505,0xcdc3edd0,0xa3c7b33b,0xbf0db6c2,0xf243c567,0xfb260664,
0xebdfeed1,0xef63e974,0x0554ef36,0x1aeb1c74,0x31f91584,0x6f8555b5,0x2b26540b,0x0dd40d88,
0xff050ff9,0xf3c2081b,0x14bc0e4e,0xf5b70ed2,0xde18f9af,0xaa1eb9b8,0xc324b553,0xdbfac06f,
0xfc40021d,0xeab4ed95,0xec27edd2,0xfadcedc3,0x1e13132f,0x26fb1658,0x6c8f4379,0x3c3c648c,
0x0cdd11a2,0x0764147e,0xf9d70576,0x15b6fb77,0xfff81322,0xeecef900,0xb47fc271,0xc4b1b2c6,
0xd1cbc629,0xff55f3c7,0xe6d8f25f,0xe9d1f43a,0xec77e751,0x1aaf1002,0x23f81427,0x59843264,
0x4b3268a0,0x08341e51,0x03be1023,0xff1b0790,0x08edeff9,0x063713b8,0xf818fadd,0xb745d6c4,
0xc2d0bef8,0xc988cf31,0xfd74e996,0xe48ef648,0xee1af58e,0xecfbe0a8,0x1ebc0537,0x1f0e16f0,
0x4b752592,0x55bb5ef3,0x060c3133,0x047e0b15,0x099b112e,0xf5e7eeb3,0x0fcb11e2,0xf866feb1,
0xc775e35c,0xc3a7bbc9,0xce87dab6,0xefb0de75,0xebb5f954,0xf4d6f080,0xec9fd933,0x1f0ffb66,
0x1d1416c4,0x37ba25e4,0x58475317,0x0c3e3f53,0x08210652,0x172f0922,0xe94fed19,0x0e480a3b,
0xf83605a7,0xd92dec55,0xc4ebc076,0xd9a5e1e3,0xe999d2f3,0xf944f0b2,0xf3bee91e,0xe407dbc9,
0x1800f31a,0x14e0210c,0x223f2ef9,0x5353462f,0x16f14e53,0x0cfafc3a,0x1d970905,0xe10df556,
0x146a02a5,0xf8e9076b,0xe2f3ec05,0xc475d4f0,0xded5e243,0xe3aed90b,0xf5e0e4fa,0xe862f865,
0xd87ddf5b,0x10b9f139,0x0a6d23bb,0x283124d2,0x42e9345e,0x27bc4ea4,0x099cfd51,0x1ad70fb8,
0xd95809c4,0x0febf96c,0xfb520e4f,0xe893f0ba,0xccb2e0b3,0xe476e57a,0xe577d9c9,0xed4de348,
0xe957022c,0xdf1cdc52,0x110de911,0x14661daa,0x2e861a7f,0x37692180,0x38883cd3,0xfdbd04b3,
0x16781290,0xe3d30ec1,0x08cfec96,0x01a80f07,0xe7cdf292,0xdb4ce9fe,0xeb0ce839,0xe585dbe8,
0xe866e7cb,0xedbafec0,0xe11dd747,0x07eee326,0x13321eb7,0x2e141422,0x253f1ea5,0x32523422,
0x00201387,0x19270b77,0xf45a148a,0x02f3e441,0x0b8a0ac9,0xe672f7ff,0xed78ecd0,0xf0e2eac3,
0xe832dbda,0xe72df024,0xfb3af0dc,0xd77cd71d,0xf887e6dd,0x19e61e86,0x27f71034,0x1506250c,
0x2c352930,0x05fe1c18,0x1c4f013d,0xfdcb17f0,0xf26ce5bb,0x0db60d3d,0xe1bd00e5,0xf846ed27,
0xf0e2f174,0xe891de62,0xf361f690,0xf7b9e6c7,0xd611e637,0xf0c1e139,0x1dc71384,0x23d90cfe,
0x1636266f,0x264c1642,0x0c942313,0x1034ff98,0x066217d9,0xe96ceae1,0x148e0103,0xe5db0bd8,
0x0584e65e,0xf38af862,0xe551e129,0xfe6cfc74,0xed9fe4a3,0xdb0df288,0xea67db94,0x1cd20a7b,
0x1c5c07bb,0x190f263d,0x1e3403c2,0x1a082482,0x029f0080,0x0b5316c6,0xe892f209,0x13a4ece3,
0xf68f1919,0x034de0ff,0xf96bfea0,0xe1c4de93,0x0652fd6c,0xe5cbea56,0xe8dbfb91,0xe57bd6df,
0x185a05b9,0x152f08bc,0x19b32527,0x111202a0,0x2032243e,0xf92d087e,0x14a50bea,0xeceef62c,
0x061fe3c1,0x043b21c5,0xfadee78d,0xff8e0737,0xdf7be484,0x0b80fbd3,0xe475f25b,0xfaeff582,
0xde7bdb44,0x1151fe06,0x04750c10,0x18fb2524,0x079a04a7,0x214d1bea,0xf24f1141,0x0fed030b,
0xe9b9fded,0xf67ce456,0x11bb2984,0xf722fa4e,0xfed307f5,0xde2decfa,0x0aa7ff3b,0xe8b0fbd7,
0xfdfef4f9,0xd61dec65,0x07ddf686,0xfdd70516,0x1a0c1a46,0x06600094,0x26191493,0xfcb712df,
0x0d9cfb94,0xeeaafc25,0xe9a1e7bc,0x21861ce1,0xf6c209c7,0xff3dfbbb,0xd91df81a,0x093af788,
0xf5c000fd,0xfe22f489,0xe1b9fc7f,0x0589ea7c,0xfd0f025a,0x1b7f0eb5,0x050cff88,0x1dec1094,
0x01b513da,0x01b5fce4,0xe9d7f73f,0xe3c9ee2d,0x2c9d0e13,0x02cb1805,0xfbdcf8bc,0xe2d50041,
0x09f2f288,0xfd630239,0xfdaefe75,0xf528fc42,0xfab6e38a,0xf778fd19,0x139f0830,0x030902a4,
0x18871362,0x01241470,0xfd7b0335,0xe0baf283,0xe449f3de,0x2d1bfc0c,0x07ca2c5e,0xf3b3f2c6,
0xeeb8fd36,0x027deb90,0x01f90721,0x08400901,0xfbfefd9a,0xecddf0a9,0xec43fd3a,0x0e250439,
0xfa5906be,0x1b3d1098,0x0cb21088,0xfd60fc4e,0xde0fee07,0xe84dec00,0x27deec26,0x17a23bf4,
0xee9df6a9,0xf9c8fa75,0xfcebebda,0x025b048d,0x0ed11038,0xfda80446,0xe2aefc94,0xed67f463,
0x096f017b,0xfc69ffba,0x1e090a5d,0x0d610fbf,0x00cc02a8,0xd6c9e5de,0xeca4e8ae,0x1800ea03,
0x29eb3f16,0xe62900e2,0xff83f33c,0xf6cef95c,0x091ffbbb,0x10a3147d,0xfbb514ef,0xe8b2ff88,
0xf3e6ea8a,0x0989fa33,0xf68c0037,0x122e0b55,0x0b10130e,0x01d70aa7,0xd442dfdd,0xec0fe146,
0x0a35e851,0x3dd635d6,0xe9740949,0xf6d7e9aa,0xf8fb02b6,0x0532f417,0x17ee1887,0x057a190f,
0xf3e1ff69,0xf59cde5d,0x0648f898,0xf70404cb,0x0d9408b3,0x02ad10c4,0x06260d94,0xcd13e3e4,
0xebb1d56c,0x084cec19,0x43b32646,0xee4a1aa2,0xf2dfe740,0x016501c8,0x020ef36b,0x1b0c18a1,
0x13fb1e61,0xf66bfe62,0xee2bd6ed,0xfd58ff56,0x019a05a6,0x06c30596,0x01e20b41,0x0cad0b9d,
0xc79ce814,0xea2dd00d,0x0ad7eaeb,0x39181ff9,0xf7262ab4,0xe96de722,0xffd70088,0xf992f8fb,
0x1b282107,0x1fa12279,0xf6810428,0xe3eadf70,0xfbcb0002,0x07090414,0x0305085c,0x024d032d,
0x120904be,0xc752eb27,0xe035c744,0x05f9ec06,0x310221ae,0x043f2d03,0xe60fe9ce,0xfbc1f786,
0xf4daff24,0x22bd1d73,0x00001c22,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_strings_stringsdx4[5376] = {
0x00000000,0x0037002f,0x00a60067,0xffa80120,0x007b004f,0x00c4fe18,0xff9a0037,0x024cfd23,
0x02b703b2,0xfb46015a,0x02fa0273,0x0239feb8,0x00c0fcf2,0xf53efb8f,0x011cfeeb,0xfe71fcca,
0x049bfd3c,0xfeb902b6,0x023e04ed,0x0249fe93,0xfe650103,0xfd00022f,0xff9a0208,0xfe0ffd0a,
0xfe30fce8,0x02020012,0x076e01ac,0xff9400fe,0xfa64fdc6,0xfc360133,0x014a0071,0xffe2ff03,
0xfd18ff2a,0xffba01b8,0x0068000b,0xfddefcde,0xfe4bff0b,0x05060012,0x03db0461,0x040901ce,
0x0027018c,0x01260506,0xfc3afaf6,0xfcfcfa20,0xfe8efe63,0x00af05d2,0xfc4efebb,0xff5bfc52,
0xfe590266,0x01520217,0x0154fbef,0x01cef8e0,0xfd0f04c3,0x011ffe83,0x029104ce,0xfdb900eb,
0x01abf8e5,0x071203e3,0x03fcfdea,0xf5ef01d4,0x03dbfe44,0x05060186,0xfbbfffea,0xffec0571,
0x047002cb,0xfea9fc7c,0x01b30003,0x02750433,0x0475fd97,0xf871fe8c,0x0200fb74,0x040aff53,
0xfebf05fa,0xf8b5fdb9,0x006efff0,0xffb1fb2a,0xf933fd0f,0x008d02f5,0xf944fb44,0xfd820a92,
0x02e601b3,0x062af8b3,0xff6dfff3,0xfb040148,0x0b7803cf,0x06f8fa7f,0xfcfb0034,0xfd4502b2,
0x00b50242,0xfd89016d,0xfcdb0125,0xfe8d05b4,0x01250320,0x037ff71c,0x041ffa6d,0x0083ff83,
0x00c70390,0x0200f84b,0xfe7b0045,0xf99b03a3,0x062dfefe,0x0086f8b8,0xfd23fad4,0xf8af0a38,
0x04e9fbc2,0xf834ff9d,0xfd7a015f,0x018606b2,0x07d90335,0x05c3fe29,0x013d07e3,0x01e30011,
0x034df6f2,0xfb33fc4b,0xf6aeffe9,0x00f8fc7c,0x0b38ff29,0x01500686,0xfce3fecd,0xfef501d2,
0x043b04c7,0xfd540339,0xfa43fc83,0x010cfb72,0x0191ffb0,0xfb9dfbfe,0xff970305,0x0222059c,
0x042d065a,0xf867ff0d,0x0062fe98,0x01feff95,0xf393f870,0xfbebf34b,0x04880879,0x08ad06cb,
0xfc000140,0x051f08f1,0x00860954,0xfb34ffbb,0xfc8af4ab,0x092700dc,0x014f0583,0xfc8ffcb6,
0x04f9fca1,0xf0c60449,0x02b8f6ac,0xfa87fd4f,0x035bfc4e,0xfe6705ea,0x085c07e1,0x01fdf8c2,
0xfd13ff9e,0xf90d0564,0x013a03c6,0x0531f6de,0xf9edfcfb,0xfbd90507,0xf884f900,0x0c6afa3e,
0x002d05f9,0x0126fc13,0x0ea00afc,0xff780979,0xfd54018a,0x0467ff56,0xfd930171,0xfa97fa36,
0xf429fb4d,0x02e2fb8f,0x0077000f,0xf760fb0b,0x0c6804e3,0xfe81fa50,0x023afe00,0xfc6dfb4b,
0x06ae0567,0x08de07ba,0xff1b0ac7,0xfda10142,0xfb93011b,0xfac0fce9,0xfcaef4f3,0x03f7fd44,
0x02190887,0x0602f783,0x0b95fd02,0xfd020186,0xfee10878,0x044bf859,0x040f004f,0xfbac08d9,
0xf929f593,0x010dfb13,0xfdaffdae,0xfac600d2,0x14480823,0xfd600357,0x0272f625,0xf8a104cb,
0xffea02de,0xfbcef726,0xfd30fc0a,0xfcd10bd4,0xfe93037c,0x0607f846,0x09cb00f4,0xf98a059c,
0xf9c7000b,0x060c01ab,0xf755fbc1,0x02d3fdc3,0xfa82f4d3,0xffb6ffac,0x03e5032f,0xffbf00ab,
0x01ed04fd,0xf882002d,0x07faf738,0x015a0ca4,0x0ae00461,0x024802de,0xf14ef6ec,0xfed002e7,
0xffe2fd3f,0xfc83f666,0xf9b80234,0xfa85ff12,0x06a8f736,0xfe2d015c,0x02e2019b,0x02120769,
0x0a1d0732,0x000b02ca,0x03aff2c8,0x00710698,0xfe63017f,0xf642f814,0x0199f300,0xfc8a08d8,
0x03c51042,0xfaa3fb86,0x0e97ffd8,0xfe811414,0x07c5fdd7,0xfb600545,0xf8fdebc7,0x01910aea,
0x0842f10d,0x03e9fb41,0xf83207b6,0xecb4fd6e,0x04c3fc3f,0xfb11fafe,0x0290fef5,0x07560a35,
0x0873ffe5,0x03190366,0xf898ea95,0x064d0120,0x095b0514,0x05fd0260,0x061a056c,0xf7ea07a5,
0xf8f3f0f7,0xfc92fa97,0x047b0041,0x01e60945,0x063bf8c7,0x05b0ffe2,0xf44ffbf6,0x07b7015f,
0xff4cf9f0,0x007f0172,0xfab2008d,0xf5850f7c,0x06b6f6c1,0xfe77feb5,0xfc7705ac,0x00fe061e,
0x00ceec74,0xf9d8069c,0xf629eafb,0x1c2e08e9,0xfd45f83f,0x0389fc1c,0x02f00734,0x01ac0e51,
0x0c80f9a5,0xf8ea0182,0x05fd01c9,0x03040c52,0xf06ae5d2,0xf6bc0224,0xf281fba4,0x1638fed7,
0x04df07d5,0x0d9c0256,0xfdfd089f,0x00b5096c,0xfaabf513,0xf49d0347,0x0a760534,0xff070309,
0xffabf1f8,0xf7c3f975,0xf07df4a3,0x178ffe98,0xec1efbde,0x177b02ff,0xe8ebfe5e,0x0c131373,
0xfc18fb6d,0xfe711092,0x06760732,0xfd231422,0x04c4ee7e,0xfa7f0fb6,0xee36ec0d,0x0dcf025b,
0xf31afd82,0xfd70ef5f,0x05c40769,0xf8e502ca,0x04dff75c,0xf2eafe97,0x0a80076b,0x088312b6,
0xfbb60761,0x0f3ff3c2,0xe447fc06,0x1851f60e,0x05a1085c,0xfa36f033,0x02b207a9,0xf5130812,
0x0611f359,0xf38400d3,0x05670a83,0x012e18e3,0xff01f722,0xfb15f118,0xff0af907,0x0ee3fb6d,
0xf634ff93,0x0761e93d,0xf52d0f5e,0x05d7fc94,0xf5250687,0xfea9f31c,0x093a148c,0x02fa202c,
0x0668eaa1,0xf09bfeb9,0xf73deb7e,0x12c51109,0x03ecfc38,0xfd40f7db,0xf7e40f16,0xf174faff,
0x09befb0b,0xfb7cf8cd,0x14040abe,0xff1f2507,0x0b5ee6da,0x017c0400,0x010de209,0xff7c10f0,
0x1948f423,0xe92ef541,0x05f00308,0xe074f770,0x12adfef3,0xfbd400ab,0x15320d1c,0xfa371691,
0x0d23f634,0x0037f764,0xfa5fe947,0xf4f918e8,0x0f87e9d0,0xfcaaf9bd,0x008904b5,0xe8ea0405,
0x07d8f6eb,0x0261feac,0x0f7a0f61,0xffe918d0,0x0e95fa1f,0x00380120,0xf27edaa3,0x020e13f2,
0xfc86f004,0x0461fb42,0xf64b01dd,0xeaea06c9,0x022a0314,0x0034f92d,0x1b671900,0xea4216c9,
0x0ac8f1e1,0xf2eef972,0xf118e242,0x007b0e45,0xfeb9f59d,0x0eedff94,0xf7db0e21,0xf07405cd,
0x0923096c,0xef54f458,0x29781059,0xf0cd108e,0x1694f388,0xf060fb41,0x0b46e44b,0x02480d9b,
0x0386fccb,0x0eaffd93,0xf232fc7f,0xebc9fe7f,0x0007049b,0xfc2cf48f,0x1c6118ea,0xda980843,
0x0c03fdc8,0xebd7edf9,0x0f52ef9e,0xf9a313a5,0x002008a3,0x1928053b,0xecca0a96,0xefa7f129,
0x05fe1246,0xfb52eedd,0x2e8c1c8c,0xe8fc0a72,0x057fed66,0xe580f708,0xf9e9e1d9,0xee1f0c4b,
0x04210a59,0x21d705c0,0xfee9132b,0xee68f4c0,0x0705152e,0xfcf8e935,0x1fcc161e,0xe86c082f,
0xf7bcef03,0xe902f94f,0x00f3e682,0xf48b0576,0x00000371,0x23180cf7,0xf8b0184e,0xed54f8e9,
0x083a0ab9,0x01c9ee7c,0x27761387,0xe8b50248,0xf9f4e2f8,0xe7eafddb,0xfb42eabe,0xf23a069f,
0x093501c4,0x30d61314,0xf3bf1568,0xf15ceea7,0x01c80ef1,0xf2b8f324,0x25412033,0xe84afb5c,
0xfea1f656,0xdd9dfb4c,0x0475efc2,0xea55f33b,0x0f5c0ac4,0x21ff07a9,0xf9db15b9,0xf7ccf174,
0x04930bc1,0x0112ee29,0x20ec26d7,0xeb4af67b,0xf419f710,0xe891f307,0x0b1afc1d,0xf085ec65,
0x1462026e,0x22ec0d01,0xfe11116e,0xed0becbb,0xffdd0aa6,0x003eef32,0x226426f5,0xeca701a4,
0xf41efac3,0xd9eaf1b2,0x043ef829,0xe7cfeb2b,0x07d2fa25,0x261a163c,0x05201b1b,0xef63eaef,
0x054005a2,0x00f6efb7,0x267f2725,0xe80ef81f,0xfe6806e0,0xeae7e915,0x05f40250,0xf7fde1f7,
0x1187f7e4,0x28a6183e,0xf9b10a2e,0xf17eebf7,0xf13d0130,0x0760f179,0x1290276d,0xf16ef0e1,
0xf97efc6f,0xf53ee6aa,0xfc7709fe,0xeebae370,0x0c32fd36,0x26761fba,0xfcf3090c,0x0366f7cc,
0xf29e030e,0x0d9bedea,0x0c392926,0xfcbcf455,0xffdb0024,0xf706e41b,0xfc0e0874,0xf8bfdf62,
0x00d2f08b,0x2f581d09,0xfc961875,0xfac3edbe,0xe86cf6da,0x1028f882,0x0f4421c5,0xfc9af74e,
0xfb6aefaf,0x03d1edbf,0xf8c90ff0,0xf7e5e483,0xfb9ef4fd,0x22da2089,0x05010d7a,0x00bcf2d4,
0xeae7f33c,0x0bb6fc1e,0x066e240a,0x0682f086,0xe9d301c3,0x03dddda2,0xfa0312e1,0x01f7da94,
0xf6d3060b,0x26231e1a,0xfe130ac8,0x0e48fc06,0xdb35fdaf,0x1e5cf6a8,0x02171da4,0x0f1ff0ca,
0xece2f7a5,0x070fdd43,0xef580de7,0xfb29e10c,0xfd2afff3,0x1ab41e48,0x01081503,0x0453f340,
0xd95df7aa,0x1a4600ea,0xf78113ad,0x00e0ecde,0xe891fc86,0x1b4bdea7,0xef362573,0xfb37dccb,
0xfb5a11a7,0x16631df5,0xfd5910d3,0x0ba209cd,0xdd31f4f5,0x220e0116,0xeff80d94,0x0a19ec6a,
0xdc49f19e,0x143fdb4a,0xefe21b24,0xf57be010,0x08f50f45,0x1a5a20d4,0x07c612fa,0x043f0212,
0xdb6fe5f1,0x23f60523,0xf3720c5e,0x06ceec17,0xe47e0071,0x0bcadd8b,0xe8801e10,0xfd5cd783,
0x0e5b0ff8,0x0c7d1a52,0x06c91992,0x0bf00f6c,0xde6be968,0x24ae0514,0xe9a301ce,0x0a0cee4d,
0xda090028,0x1f81de62,0xe7d01562,0xfeffe34e,0x12dd0da7,0x0fe314f7,0x057f0ee3,0x0fee139a,
0xee4addcc,0x23d60f46,0xdcf3fd9d,0x0e47ee76,0xd560054e,0x0bd7e0d2,0xe2a60fc8,0x09b3df3b,
0x1ef21017,0x11411c51,0x07440b2a,0x0a2916dc,0xeda6e151,0x26e10c50,0xd2fbf8ab,0xff01e4a0,
0xe0cb0fc0,0x0dd9e0e1,0xdcc20b98,0x05b2e41e,0x29e8143b,0x0fee1a66,0x0d3f0724,0x083e120d,
0xf67ee0ac,0x21301104,0xd3b1f94f,0x071af3ba,0xe0650216,0x0b19f2ee,0xdbd5140e,0xee1fe155,
0x2265fcb8,0x0c9818de,0x19480f38,0x0e2d1092,0xf5cfe398,0x248c17bb,0xca5dfccb,0xfed7e792,
0xe8320348,0x0e65f648,0xdf010d6a,0xf611eb89,0x1dd5f7aa,0x112417b3,0x164b1012,0x02ff09c8,
0x0bd2e78b,0x171b134a,0xcefaff0c,0xfeeff148,0xec0dfae2,0x0e730708,0xd660073e,0xfb04fe05,
0x15e7ec35,0x0ace0dec,0x18dd1468,0xfb7d056d,0x04b0e5d4,0x133022d0,0xc15bf8d1,0x070eebdd,
0xeb9bff02,0x133d0845,0xcbf6fbd8,0x0780fd54,0x125efb59,0x099706be,0x1773131d,0x073f1531,
0x0abeef6c,0x05bf1e47,0xcab1f0d0,0x0108e5cb,0xf6b8ef7b,0x2a411247,0xccde0791,0x00ecf2bc,
0x110d0322,0xf1f20d29,0x1051168a,0x08030a53,0x0a64fc2a,0x069d1d96,0xc6e6f0c0,0xfd61e39d,
0xede0ee1a,0x193e15d6,0xd9b9ff20,0x0374f2d2,0x052705a2,0xfe220b8a,0x1f581f96,0x05ab0ae0,
0x18e7fc3e,0x07521062,0xcb27f859,0xfbc6e127,0xf2bcf81e,0x1a7c0ea2,0xd92aef34,0x0e35f5e2,
0x006b0e8c,0xf830ff99,0x21a716db,0x05501178,0x094efe0b,0x089e1606,0xc87beae7,0x03f7eba4,
0xf1c2fedb,0x1b3b0d77,0xe125f419,0x0147f191,0x023010e7,0x02a8fb52,0x15d60f5a,0x0e7d13ff,
0x17dd164a,0xfc260140,0xca2cef41,0xfd13e29b,0xf5cb056e,0x1cac0d29,0xe8c2e5c5,0x0064009c,
0xfe300d2a,0xff7ff2f8,0x17b10eb0,0x09a02328,0x0d8612c2,0xf4d70593,0xc634ddaf,0xf3d0e329,
0x001f018e,0x16951484,0xe8cdd92e,0x0c860534,0x10a11879,0x0c4af714,0x063c17dd,0x114c1c7e,
0x0cb6240a,0xfaf402a8,0xc6a3df0c,0xeea1e91f,0xfffe01cb,0x03f4074d,0xe3e6d0c6,0xfcd4fd70,
0x01291984,0x1b62ee11,0x045d1409,0x189631ae,0x12e22b5f,0xf0cb0bf4,0xcf6bc4cf,0xeb6fe5f8,
0x114d04f3,0xff9a1632,0xe40acb6a,0x057fffc9,0xf9eb1221,0x11a9f030,0x0e7d156e,0x1a2c2310,
0x12f8329b,0xf45c0c03,0xec58d1d5,0xea2ff52f,0x091f0c9b,0xfadc13b3,0xd891c77e,0xfa56fa03,
0xf1b40443,0x18fff0a1,0x0be211cd,0x235627ca,0x1d9c399f,0xec350fac,0xe6e8bca0,0xf3daee6a,
0x1502f074,0xf477238e,0xe529c39a,0x01320678,0xf12c020a,0x10efe63f,0x162e0b38,0x22d418c8,
0x15f42fce,0xee9312a9,0xfa4ec0de,0xf6f7ff4b,0x1be0031c,0xf80e30f4,0xd709b6d0,0xfbc6feac,
0xe8a9faa2,0x12cce8da,0x17b31028,0x28c224b9,0x1d392a22,0xe5ad0ac8,0xf0b7bd95,0xf30eefb7,
0x138cf996,0xface2ff2,0xdeffc90e,0x089ff620,0xd8d700a6,0xff23eda4,0x178b108e,0x25e51f99,
0x219f3250,0xe7431016,0xf748c5e2,0x02cfff41,0x1c20f638,0xf3232fbb,0xd2a1c925,0xfa2ae85c,
0xe866090f,0x010ce398,0x16091a2c,0x2d7c1f76,0x24e03404,0xdbe809d0,0xf91bcf5e,0xf792fc8a,
0x1695f607,0xf3682e56,0xe0d3d3c3,0x04f7e4c2,0xce230555,0x074ce513,0x0d391181,0x31c41f30,
0x225f2dcc,0xd58e04ba,0xee33d4ab,0xff230a93,0x20eff6a4,0xed5423db,0xe344d594,0x1277e20a,
0xd646ff83,0x019eef62,0x123f1e12,0x350c1960,0x1d0832e2,0xc5d60b2c,0xf2f8def5,0xff680b31,
0x1f2cf44b,0xeec21853,0xed9ad490,0x04e1da47,0xd391f42d,0x0424e54a,0x08cf2337,0x29e31968,
0x1f7636ef,0xcb1508f7,0xf2e9e7a6,0x0a800983,0x2b11fc7a,0xe62c1c25,0xf200e12c,0xfa67d050,
0xca89fab1,0xfb72e138,0x127323b9,0x2c801806,0x197a3dff,0xcffbfe87,0x0296f174,0x0b8705a0,
0x2ba1047f,0xdff0111a,0xe84de6a4,0x0191dba5,0xd1f3f77c,0xf853dfee,0x092c1a58,0x2f941650,
0x129f37fe,0xd608f12f,0x0ef1f258,0x0b9d0d95,0x25550812,0xe33c1a20,0xda87f152,0xf98dd626,
0xd243f09d,0xff3cd801,0x112f1e24,0x2aae1f3f,0x10702cf4,0xd300f4b5,0x0f0bf6a0,0x03e31654,
0x2b0115a1,0xe4411093,0xea340af0,0xf1a0ddd7,0xd2f7ed65,0xfa65cccb,0x02970c81,0x2d190f5e,
0x0b022e67,0xdef0e6cc,0x0feefb4d,0x01cb19ee,0x208d1a5e,0xee06044b,0xe6501134,0xf828df6e,
0xd884f0a1,0x040ccd57,0x0e57147f,0x27a80b2c,0x01712d72,0xdf01d756,0x16b9fa3e,0xffd71665,
0x1d9b28af,0xf059f60a,0xdedd1adc,0xf896d968,0xd88ef1b8,0x0194c9d3,0x1b7b0f23,0x308809e9,
0xf26030a5,0xeb4dd0b5,0x0f02fa1f,0x095c0ed1,0x18692b58,0xffadea85,0xe4661e32,0xf70fe183,
0xe087eb83,0xf788ccd8,0x1e100e40,0x38ca0720,0xf83f248f,0xf540cc84,0x12f1fb55,0x0b100a29,
0x1671301f,0xfefedf46,0xea9f1d9c,0xf66ae82b,0xe05aefa3,0xfb74c970,0x1e9b053b,0x3a1d0ba8,
0xf3dc236f,0xf45cca59,0x0c48072e,0x1b580224,0x0f873704,0x06dcc6e8,0xf13a0e67,0xf3a7f192,
0xe0d2e8cd,0xf1fad8fe,0x1b5308e9,0x39c80ba8,0xf2701dff,0xf2d7c890,0x0c180bb5,0x2046f9dd,
0x0c27352a,0x044fcc5c,0xf3d7134d,0xf34ff997,0xdc09e6c2,0xeb4de057,0x1c4b051f,0x393e158e,
0xe9ba1f88,0xf470d60f,0x051d18e8,0x2884f3a7,0x05112fd8,0x06c4caf3,0xf21e083b,0xe526fae2,
0xe8cde2bd,0xec6bede7,0x15ba0200,0x360b1d0f,0xeedb1a3d,0xef3cdc66,0x0068180f,0x290bf907,
0xf91f3163,0x0783d3f4,0xf0c60d5b,0xe832f84b,0xe6b1e117,0xe6a4ec8f,0x175ffd93,0x33c32171,
0xef9f19a9,0xfbb1e3ea,0x0248270a,0x2f96f3cd,0xf0a13179,0xfe63d834,0xeb790558,0xe8e3f6e2,
0xee26de81,0xe740f525,0x0d53fe37,0x265b2768,0xef291391,0xf7e8e93a,0xf99d1ec8,0x31efff7c,
0xe93a2c74,0x0250e70b,0xeb130eb0,0xdf14eeda,0xf47bdc86,0xe900f5bc,0x058efa4b,0x23102dc5,
0xf5081334,0x0776e9a6,0xf7751d7c,0x315cffac,0xea5e2255,0x0204e8f1,0xe8631134,0xe239efab,
0xf5ecdad3,0xefc5f429,0xff7cf85e,0x13f82e7a,0xfed50966,0x08dbee99,0xf3fd1c96,0x2a310bd4,
0xf57d1764,0x0220e818,0xea411809,0xe155e534,0xf64bde36,0xf535f472,0xfb78fe49,0x0f7130b6,
0x056400bf,0x18adf5b6,0xf0bf1423,0x2b8e0a0f,0xfea20f20,0x0330e89a,0xe6b518f6,0xe3e4dc45,
0xf1c0dda8,0x00b1f2a0,0xf933f9db,0x0b602d17,0x0794fd6c,0x1ecb00dc,0xf1b811dc,0x253f1177,
0x0af0059b,0x0180eeaa,0xe5291b62,0xeb1dd7c3,0xee9dda31,0x03c1eefd,0xf827fbe1,0x03de261a,
0x0952f677,0x234d120c,0xfbb7061a,0x16b0131b,0x14e0ffa8,0xfb3ef24a,0xeea01aeb,0xef69cc31,
0xe836d9a2,0x09c3f10a,0xf2d40028,0xfffa181b,0x004cf797,0x23d7219d,0x00f604b7,0x0e6a15e0,
0x1d3d0221,0xfaebf77a,0xf3921918,0xf103c3d0,0xdc9fd96f,0x0e49f16d,0x0003feea,0xfb3a0fa1,
0xfc52f96d,0x2af02a0f,0x048302d3,0xf6c61370,0x1eef053d,0xf83cfc49,0x03220e1f,0xf483c38c,
0xd4b0d986,0x16b1f7f3,0xf994036e,0xf2ee0532,0xf9a50424,0x32ce3524,0x0bd9ff01,0xe728134e,
0x1adb1146,0xfa1105d8,0x0905feb3,0xe7eeca50,0xc83ed4bd,0x1faef618,0xf98f03c5,0xefe1fd78,
0xfaf411b6,0x30fd3676,0x12ff05be,0xe0a40edb,0x18d611a2,0x0ae60773,0x0bd8f6de,0xdbf1da0f,
0xc3a5d910,0x1e10f4ad,0xef7b05a2,0xe6f6fa36,0x08b1144d,0x2ec5327c,0x12b90d08,0xd8e60919,
0x15541615,0x0ff80290,0x00b1f7f8,0xd8d7ea17,0xc6b8d893,0x23f6f059,0xe9b509bd,0xea3ef488,
0x13ad17e1,0x29432fbb,0x163c14a0,0xd97000f4,0x14fb105a,0x1569fcaa,0xf622f7c3,0xd06ff85d,
0xcbe8d394,0x1f88ea77,0xe6a514b1,0xe942ec7a,0x208f1098,0x1e1f30aa,0x180d1f35,0xde6dfb9f,
0x13f810fb,0x141af9f0,0xf51102c0,0xd015f975,0xd95fcbb2,0x1996e548,0xe83f1813,0xf523e06c,
0x2623102f,0x162d36ab,0x1a9c2882,0xe7c8f333,0x0cfb0bcf,0x0b37fb29,0xf6e10b16,0xd257f7e4,
0xdbaebfff,0x1098e815,0xe81415c2,0x01e3d728,0x2a0e0cd5,0x0e873ee7,0x210d2cc5,0xeed3f5d8,
0x095c0aa5,0x0590ff59,0x01240e3b,0xd4d8efbe,0xda8dbd96,0x0b46f079,0xeb5b097f,0x01ced2c6,
0x22391715,0x0b9f3da8,0x226d26d4,0xf48ff888,0xfefa0861,0x04b4fec8,0x14fb0c33,0xd1afe43c,
0xd7b7c3aa,0x0b60fae1,0xebc1fac9,0x0224db05,0x1d2a1fdd,0x0fce3b15,0x23e81c3a,0xf678047b,
0xf5820698,0x03da00a6,0x25370457,0xc913e440,0xd52ec8cf,0x0959ff51,0xe5b2ea29,0x08c6e1a9,
0x1bc5249d,0x1a9630bc,0x1c2e1621,0xf91614f0,0xedf20523,0x05dffc08,0x269800bb,0xbb89f13a,
0xd91ac7ec,0x0c070742,0xdfa2dc27,0x111fefc5,0x21b5247f,0x26c01f4e,0x20e41246,0xfd341e74,
0xe5650053,0x0124fd5d,0x16f40684,0xbda3f807,0xe23fc1de,0x09670a54,0xd391d180,0x1ce7fd26,
0x2a3122d8,0x23f11694,0x20fb10b5,0x066d2a94,0xe284ff69,0xf7e4fc9c,0x03f210ee,0xc5e8f991,
0xe2ddb57b,0x05b60d05,0xc29ccfb2,0x2bb9fcac,0x273a22d6,0x1d4b1558,0x2c300fae,0x121c2a9c,
0xe6bafba4,0xf27cfb68,0xf71419e1,0xd7d5f3bd,0xe472ae94,0xfddb10ec,0xbf8ed002,0x34f2f9e1,
0x1fe12922,0x12991721,0x3cd50b15,0x1b3225bb,0xe0a9f968,0xeefffca9,0xf72215b4,0xe5cde6e7,
0xe01db05f,0xec6a1e2b,0xc1b9d32e,0x39b7f2e4,0x1e322e87,0x0b681b9f,0x490c0511,0x195c266a,
0xe307fc52,0xed48fc92,0xf7c21400,0xe7c8d885,0xd8c3bd06,0xf01a2001,0xc975ca2c,0x356df52f,
0x1bcc39f8,0x069c1e1c,0x517e028c,0x13f83125,0xe644fd7b,0xef95f5ef,0xf6eb09df,0xe314d2ae,
0xd5d6cedf,0xf1881b3d,0xd2bbc3be,0x32d1f341,0x1dd83d2b,0x03391d94,0x526a0301,0x10563b24,
0xe90200a2,0xee36faef,0xf533090a,0xd200ce4d,0xe121dfc4,0xf4110780,0xd8f3be4d,0x29def481,
0x255836e6,0x0067138b,0x4803097f,0x113c41e0,0xf635f985,0xf026fd1d,0xf2da0877,0xc48dd0b3,
0xf535e84a,0xf725f8c9,0xdb2fbe54,0x2180fef3,0x2aa53179,0xfa4c0c7c,0x38ed16ef,0x14f542ff,
0xf77ef366,0xea28fffa,0xf21e0974,0xbe3dd068,0x06a6eb11,0xeca5f14e,0xdc5bc543,0x23f60387,
0x322523c0,0xf96d07a8,0x362d1bb1,0x1a283da6,0xfd1fedcf,0xe91f0181,0xefc5089f,0xbd7ed096,
0x1ba1e22f,0xe4adf130,0xd8efce93,0x21811002,0x2d121dde,0xf77408d9,0x35722527,0x22e732e6,
0xf72ff009,0xe8800873,0xf07b0606,0xbf17cb66,0x21d0d9b6,0xd4b9fb74,0xe127d06e,0x25ff1037,
0x21bf1777,0x00710896,0x35a82a64,0x1f842989,0xf7c2f8f2,0xe8c30cbc,0xf4ef04c9,0xc603c9dc,
0x1da3d3ab,0xc90e0682,0xea54d526,0x2b4205b4,0x183d16e3,0xfbb70845,0x37982ab9,0x1ce428de,
0xf3a703a8,0xeec605d6,0xf50900d2,0xc5aecb83,0x16f8d402,0xc31012c1,0xf113d291,0x27b50b76,
0x09871a76,0xf8b208f7,0x3f5f2aa8,0x14912387,0xf5821281,0xfa50fbc1,0xf7f3f9c3,0xbf0dd104,
0x118ad380,0xbffb1bf4,0xfe00c967,0x225210c8,0x00ac1f27,0xfeb00146,0x4822279e,0x094e1e22,
0x008a1ba3,0xfe0eef15,0xfc6bf62a,0xbb9fd94f,0x09f7d33c,0xc7771c89,0x096bc38a,0x16e31545,
0xfa8729e9,0xfaa7fc66,0x4bcc2362,0xfd6c206d,0x097524b5,0x02a8e587,0xf775f69a,0xb97ee2ea,
0x08c1d3b1,0xd0820f36,0x0d38c2c6,0x15f81a30,0x004120d4,0xfdd4f682,0x4b08239a,0xf9da26b0,
0x16dc25fd,0x01cedb3f,0xf236fa95,0xbbc8ea39,0x05a0cda1,0xd74205e6,0x0bf4c45c,0x13ff24ee,
0x06e119bd,0xfc1beaea,0x466f1b59,0xf86724a4,0x1f9326a3,0xfb74dc39,0xf32201a7,0xc2a4f42d,
0xfea9ce5d,0xdc25feab,0xfea9cd59,0x18de2db6,0x0f7109a5,0xfcd4e69b,0x44b81ccd,0xf513286a,
0x24fd2106,0xf25deb9a,0xec5602b2,0xcb55f0b8,0xf8c8cf7b,0xd4c0f90f,0xfa81e1f7,0x1a2c33da,
0x1334fab1,0xf7b8e78b,0x38b218ca,0xf9fe26db,0x2751229f,0xf0c5f02b,0xf35802f2,0xd063f3dc,
0xf0a8d3d3,0xdb17ed90,0xfbd8ed80,0x263c2c2f,0x18caf0ae,0xf661e8d9,0x28621b24,0x000b25e7,
0x26bf1d9e,0xefe9f727,0xf306f83a,0xd423f84a,0xf170d908,0xdbdde127,0x00b4f3de,0x2efc264f,
0x0f38ed14,0xef77f78c,0x21fb2017,0x047f2ac7,0x292616ac,0xf57d00d6,0xf17ef50e,0xdafff0ab,
0xebaddac1,0xe2f2d24f,0x0875f7f8,0x34301d6d,0xff75ef17,0xf1c9f4cd,0x15d61baf,0x0d532cd7,
0x26cd126d,0xfb0c07c0,0xef54f289,0xd751fcf0,0xe7b1e338,0xdb76d114,0x14c2facf,0x341812c9,
0xf130fb09,0xf3acfa9a,0x0f0a185c,0x132128c6,0x27e216d7,0xff110a70,0xea17f113,0xdbd0fab2,
0xe219e584,0xdd37c958,0x182f0194,0x302a0f96,0xe92e02bd,0xf471fbab,0x03cb1a9d,0x1ea4261f,
0x216f1404,0x024e0d73,0xe6adf3bd,0xe509f712,0xda04e5ea,0xd74acc05,0x21ad0357,0x2f610b2c,
0xe4d805c3,0xf781f24e,0xfe49196c,0x24821deb,0x1ed9193c,0x04351538,0xe7f3f2cd,0xec66fa78,
0xd913e86c,0xd8eec8d4,0x279402e8,0x28bc0d73,0xe1611010,0xf971e8bf,0x01a619fc,0x289010c8,
0x1f0a206c,0x02ca1702,0xe2c2f59f,0xf60af5de,0xcfcfe315,0xe19ecc5d,0x274bfe0f,0x215c0b0b,
0xe3e11ab1,0xfba9dded,0x05b0155f,0x29580b39,0x19ee27c4,0x03b31e98,0xe1fcf714,0xf8b2f700,
0xc9e6e7cc,0xeb09c901,0x2a27f79a,0x16120a14,0xe3a52022,0xfc84d580,0x032c1457,0x2524043b,
0x1f3131f7,0x04e91d7a,0xe5e0f253,0xfdabf815,0xc6eee68b,0xfd23c6ec,0x284af262,0x0dc51286,
0xe6382681,0xf6f7d5b0,0x05920e0b,0x1910068f,0x21ad37a9,0x05b91c2f,0xe441efb5,0xfac4fab7,
0xc23aecc9,0x08adc0ca,0x2135f406,0x04071291,0xedf32491,0xf10ad4ca,0x076b09f2,0x15960783,
0x2b713a59,0x09f3199d,0xdf1ef4f9,0xf71c0220,0xc3a4f151,0x115eb80c,0x155000c0,0x04531191,
0xf1e4245c,0xed4dd065,0x055a051b,0x15d106b0,0x359236c8,0x0d841367,0xd410f9c2,0xfb5006ae,
0xbf0af38e,0x175fb276,0x0a0a0a89,0x04001064,0xf67b2118,0xedc5d957,0x03aefb30,0x199d05f4,
0x3d5a3156,0x09a0151d,0xc7400353,0x026408d4,0xbb2df38c,0x165eb506,0x07f61235,0x0a230988,
0xf45f14e9,0xf156df95,0x07e7eeaa,0x1df004c2,0x45e62e37,0x0d6f14ba,0xc74902a8,0x08530427,
0xba5df4df,0x0e51b41d,0x07251ec1,0x08940748,0xf1770f54,0xf4f5e46b,0x049ddf8f,0x2191fe19,
0x40e02e60,0x111a1b4a,0xca38060b,0x1088fa99,0xb8cdfdf8,0x00bfb922,0x08e7272e,0x0875036e,
0xeb150b42,0xfc8deb87,0xfcc7da2c,0x1fb8fee5,0x36a434cb,0x0f7a2010,0xc97c079a,0x138bf520,
0xb3a70202,0xfe13c169,0x12bd21e3,0x0a19030e,0xe933095b,0xffbbef11,0xf89dd74a,0x1fafff8f,
0x30a83f31,0x1142279a,0xd1de05ea,0x1c3ce3e6,0xb540069f,0xf453c9eb,0x1bab1542,0x0bd406c8,
0xe38e0007,0x02c2f0a7,0xe8a2dced,0x179d03ab,0x299d4037,0x137d2ca8,0xe0b3ffdc,0x20cdd84f,
0xbe220b19,0xf03ec9fd,0x26bf0b41,0x0d970d3f,0xdf3bfc7e,0x08e5f1f8,0xdd40e0a3,0x10b0060b,
0x276046f8,0x10f831e6,0xe84ffd3c,0x1ed5cd8d,0xcb740b65,0xea08cb0e,0x2c56fd90,0x120d10ca,
0xddcff47e,0x09c1f1e4,0xd8dce4a8,0x158e0194,0x2de441fb,0x11572f91,0xee94038b,0x1b70ccb6,
0xd2710d57,0xe4a2cf15,0x1f0af34a,0x18c21d00,0xd817f08b,0x095ce6a5,0xd3afe7e5,0x19bdfcee,
0x331737e8,0x11a92b15,0xf91b021c,0x1884cd01,0xde131334,0xe2edd22d,0x1968eccc,0x1c0927eb,
0xd8c4f83e,0x0ff8db0d,0xd209eb39,0x20b5f354,0x36b22d2a,0x0db22413,0xfa3d01b1,0x0554d6a2,
0xe36c1970,0xd908dfb1,0x0c4ceabb,0x203c341d,0xd801fc74,0x1387cdfb,0xd6bdef5f,0x277eec56,
0x3cb32818,0x11411da4,0xffc90633,0xf8cbe449,0xe1e123b4,0xd7b3e410,0xfb26e8dc,0x247e38c6,
0xd7bb085d,0x1184c761,0xd472f411,0x2744ebab,0x36012ab9,0x13691400,0x02c50446,0xeee6eba0,
0xdfca2685,0xd9d3eabe,0xefe1e4c9,0x28af3680,0xd4290ffe,0x1073bf81,0xdec4ee0e,0x22bfeac8,
0x2fd12b59,0x11321680,0x06ba0f14,0xead7eef9,0xe24a2392,0xdc58ee4d,0xe6a5e6a2,0x2e6a2eec,
0xd8af15bb,0x075cc114,0xe3ceeca5,0x15eeee4f,0x23872f55,0x0d571070,0x096f1a72,0xee38f282,
0xe90c1f9b,0xe31ded93,0xe6d0e60f,0x36f11b7d,0xdd2b1755,0xfeacc94d,0xe5efe451,0x1295f28b,
0x19343327,0x0a140be7,0x113e1c38,0xf445f2c6,0xf5171612,0xea08f010,0xec53e8c2,0x3e060d48,
0xdc3d1b89,0xefcdd75d,0xeb1de24f,0x159cf511,0x10702e21,0x09a908c7,0x17f527b1,0xf9a7f276,
0xf47f06be,0xeabcf06c,0xed39e700,0x3debfdf3,0xe34b1dde,0xe251e683,0xedcadbda,0x1b3bf7b8,
0x0a752085,0x09930041,0x1a8e2faf,0x00acf75c,0xfc5af822,0xe7b4fc66,0xef64ed18,0x38b7f469,
0xea031a58,0xd541f13e,0xf1a0d412,0x1feff87b,0x04211225,0xfe22ffba,0x1a583db9,0x005d01a2,
0xfe07ef8b,0xe473fb35,0xf830f345,0x2f1fefcd,0xfaca1482,0xd243fc33,0xf481cd30,0x240efbda,
0x000b0781,0x0125fde8,0x19d0414c,0xf93f131b,0xfa21e846,0xe06503d2,0xfdfdf6f7,0x1a0eeb71,
0x046111e2,0xd2090180,0xf2bec90e,0x24100094,0xfda1f61b,0x045e0001,0x1f1044f4,0xf8be2135,
0xf9fcdf49,0xe6b5096f,0x039efe45,0x0d03ec58,0x0f961488,0xd1870820,0xf360c3a5,0x17bb0f19,
0xf7edebd9,0x0ccef8b9,0x1b6c40c8,0xf54b2c2f,0xf262e384,0xee160b82,0x07a5fd14,0xfc78edf9,
0x1a361014,0xd5780989,0xf1cfc0bb,0x0f281330,0xed9ce752,0x13c6f64e,0x20ba428b,0xed6233a8,
0xf105dda6,0xf1b40ec3,0x0b7afbec,0xf03af0c6,0x223314e3,0xdbea041c,0xf3e9c23a,0x01121899,
0xe7a1e33f,0x1d40f23e,0x281e3adf,0xee9e33a9,0xf2ecddfe,0xf8480849,0x0f05f8c9,0xe191f135,
0x29e30d17,0xda8e06d8,0xf3dbc670,0xf9591cfe,0xe23be365,0x2382ee18,0x32c43913,0xf07e2dd4,
0xf2eedb34,0x01f6088d,0x0d0c047a,0xe3cbf50d,0x2d72078d,0xda2a064b,0xf039cc61,0xea111eb2,
0xdc20e316,0x2926ee65,0x356d3754,0xfaeb2724,0xf0b1d676,0x04e90200,0x05080bc0,0xe846f696,
0x31a1ff11,0xd4a20ef8,0xf6dad9a3,0xe68b15db,0xdbcee0fb,0x2b71eb52,0x3cd936e5,0x020022c5,
0xf3a4d402,0x05860419,0xfed01275,0xe8bcf4fc,0x280afb17,0xcd2a0e1d,0xfa1fe0a2,0xe5650754,
0xdc40d9e2,0x2e7dee18,0x35ac39d1,0x03c62918,0xf14cd812,0x0a0b0975,0xfce5192b,0xed4df893,
0x26f1f7bc,0xcc311432,0x00cae99e,0xe605f797,0xd572d220,0x2a86ed8b,0x2f583c04,0x03fb2c96,
0xee9dd767,0x08210d55,0xfb4c1a5c,0xeafbf97f,0x221df4c2,0xd5601159,0x0be3e7bc,0xea02e8e5,
0xd61fcc7f,0x2523f571,0x28843cf0,0xff7c346d,0xee0edba3,0x0e2b1785,0xfb901d51,0xece2fff5,
0x1df0f3ef,0xd7a10ff8,0x0e95ebcd,0xe0a2e509,0xd997c7b8,0x251ff147,0x21eb3bbe,0xfef037c1,
0xf04ad8cf,0x16d717df,0xfd3113c2,0xeb3e0658,0x1b63f3ee,0xe1140a92,0x1231ead7,0xd7c5e25c,
0xd46ed30c,0x2268f2a8,0x263e381c,0xff17393e,0xf411da3e,0x224217c5,0x024911c9,0xe203082d,
0x18eaf4df,0xe9f00585,0x0c38e7ff,0xcb80e53c,0xd4cad92a,0x2285efb4,0x2f992e65,0x00272fb8,
0xf73bd81f,0x26f51b85,0xffdb12cb,0xde72111a,0x1673f9c5,0xec58ff23,0x05daeb39,0xba1eec7d,
0xd3c7e069,0x2514ed3b,0x3cfe253c,0x02b225a0,0xfda1d75a,0x30f41336,0xff8d10ef,0xdbf41288,
0x0b07fef4,0xf1c20010,0xfd67eed3,0xa971f7ca,0xd0e8ea8b,0x2448ec8b,0x4021200a,0x043b2097,
0x03a0dc34,0x30161733,0x026b168b,0xda8714f5,0x05b9f7cd,0xf9ebfe01,0xfceee9cc,0xa765f6ed,
0xd6adec87,0x16f1e9bb,0x48811ebc,0x02ec1aaa,0x0954d8c4,0x3429153a,0x05bd1f8e,0xdc4c16a6,
0x039bf600,0xf4e9fd2c,0xf814ef97,0xa567f74f,0xdc6bebbb,0x13f6e7bc,0x43ec24cc,0x00531ef4,
0x072be05c,0x30881d4c,0x0c63245e,0xe53913ec,0x0646f166,0xfbdaf4e6,0xf955e77a,0xac5def5f,
0xdaeee38c,0x075ce7cb,0x3d1729b7,0xf61f217d,0x03a8ead4,0x31e01d4c,0x0f7e2639,0xeee10d2b,
0x05f4ed15,0xfbd8f214,0xf91fe4f4,0xc0a3e4d2,0xe57bdb35,0x027ee719,0x36f42e4c,0xf5b726a6,
0xfcd6f5b7,0x34532482,0x147f2277,0xf76e0a93,0xfe1bec65,0xf92eee55,0xf7a0e3d6,0xc666dcd3,
0xe641d92e,0xfe97e333,0x2a993168,0xf1992aa1,0xf49200fd,0x3897272c,0x1aaf1f1d,0x02ca0680,
0xfabff1ad,0xf292ec60,0xf4b5deb6,0xd27cd7ea,0xe46edc21,0xfba4e157,0x2b4b2ec2,0xf2ee2e3a,
0xf88c024c,0x41e227ca,0x17b61d06,0x0be30400,0xf444f75f,0xe657ed7a,0xf64ee094,0xd9a8d454,
0xe84dd3ce,0xf8a6e896,0x25e72d88,0xfa172466,0xfd630225,0x3f062295,0x1cfa17cc,0x148e02bd,
0xeed7fb5b,0xda8af281,0xec9adc27,0xdba0dc08,0xe2bdd829,0xf95ee9f5,0x25832592,0x04a52bec,
0x06fefae2,0x46992113,0x21a71a66,0x18e7010b,0xefa801c6,0xcbfaf1d0,0xf1e4d4f1,0xd5e7e649,
0xda31dd35,0xf88cee24,0x25b91af5,0x094f2310,0x0af7f829,0x421c1f33,0x21fc1c8c,0x1b800a6b,
0xe9540cac,0xc758f302,0xf1dac83f,0xd63cebed,0xd582dee6,0xfc1df4a5,0x23471665,0x10391e0e,
0x1383ef77,0x38c51cbf,0x25921b38,0x16070c9e,0xf0640c9b,0xc91feb93,0xef14bcca,0xd58ef692,
0xd589e4c5,0x05bff318,0x1f1011cb,0x0b4224db,0x1b68f7da,0x2ac522f2,0x2b071ea4,0x11f51498,
0xf3bc1306,0xc6b1dce6,0xec33ae0e,0xda5dfca6,0xd08ae3c4,0x0f30ef20,0x18be0a92,0x061e2b1f,
0x201eff16,0x1e8e2834,0x2f8824c6,0x09071cb5,0xf9771764,0xc530d7fb,0xe5a79f78,0xe428fe4d,
0xcf5de6dc,0x14c7e9d3,0x1e260a46,0xfebf293a,0x205904d2,0x131e2ef2,0x38d42b60,0x0a84232b,
0xfeb51b84,0xc0c5d38c,0xe3fc9bbc,0xed89fd84,0xc8cce265,0x1804e068,0x1af50cd5,0xf8df20ba,
0x214308dd,0x03fd30ac,0x3d5a2f61,0x0b072ca7,0x03261df8,0xc14bccce,0xe2c39576,0x00c8f666,
0xc9d3de7e,0x1454ddc1,0x1dc60e9f,0xf5ab2318,0x1d990f7a,0xfb52326b,0x45cc2f6a,0x10442873,
0x03fc1aa1,0xb52ece15,0xdc08960d,0x0cbfedd4,0xc3b5e2b7,0x1181db87,0x1b9f18a5,0xf7781bc8,
0x1b8717b7,0xf7943378,0x4ddb2f05,0x147f2ac2,0x071a168a,0xb488c986,0xd9e797af,0x1321e6e4,
0xc222e72f,0x09f7d683,0x1d3d2167,0xf78e1531,0x185b1b87,0xfcf03281,0x4f7b2693,0x1ff82f1f,
0x02c5141e,0xae1ac991,0xd4429dec,0x17b1e006,0xc652ef11,0x0580d27f,0x1a7f2be6,0xfae50ead,
0x0e7d2729,0x03912eec,0x5063268b,0x22e437cb,0x0104128d,0xb12fc4c3,0xce61a420,0x18e4da3c,
0xbfeef5fb,0x06b9cd69,0x17b5319e,0x0037080d,0x128f26f4,0x0db728a3,0x49d91ebe,0x260343fb,
0xfce91093,0xaeafc374,0xc365ad39,0x17a9ddad,0xc95afa08,0x012ec2c0,0x1b42317e,0x04a707b3,
0x15921b55,0x134724b3,0x3eb321c9,0x28e45217,0xf6911154,0xac4ebf8d,0xba9fb3c1,0x14d9e595,
0xcfa7f929,0xfad7c58c,0x176d3457,0x078a03f1,0x1cbf1904,0x13cb1b6c,0x36132199,0x2be65971,
0xfb2d0f0f,0xab63b76f,0xb576ba51,0x0b02eaff,0xd394fb7e,0xf766c1fa,0x152c3722,0x0d3100f8,
0x24b31275,0x153c1cde,0x34161f41,0x319d5b53,0xfbe60af7,0xac1bb722,0xb3e3c085,0x0a11e6ba,
0xd723fc6a,0xee2dc81c,0x12bf3ae0,0x10d201be,0x29260cea,0x140e1ee4,0x30b91fa4,0x3cfe5efc,
0xf6d40b34,0xab59b946,0xb6fbc31e,0x0536e3e0,0xdd27f655,0xeb35c89a,0x0b873c68,0x12390393,
0x2f26087d,0x1139237d,0x2df21ae9,0x447256ff,0xf7a00c72,0xa922bec1,0xbf97bf0a,0x08a9e188,
0xdbf0f3df,0xee63c6cc,0x0f583645,0x0f83fed7,0x30840a59,0x0b5929da,0x2bb917a0,0x50db4d06,
0xf1210b0c,0xb055c09e,0xc688befa,0x06e8dd6b,0xe324e848,0xe7a3c9c5,0x0b2432ae,0x064c0194,
0x2fe9125b,0x06643296,0x2d6b1599,0x546d45f5,0xf1c61213,0xaee6c612,0xcc1cbd7d,0x0379de81,
0xdddfeabf,0xeb26c95f,0x0edc2d74,0xfc1b02da,0x31801c6f,0x0138378a,0x2dee14e3,0x5554394f,
0xef771add,0xb902c5e3,0xd5bcb74a,0x029be237,0xdbb0ea2e,0xe319d275,0x11b529e8,0xf747ffdd,
0x37c4247f,0x02203cba,0x273a0ea4,0x4f8e3159,0xf4642845,0xbf29bc5c,0xd8a9b4aa,0xfa63ed24,
0xd80ce447,0xea3dcfde,0x0c812821,0xf0d5fc7e,0x37ec2ebc,0x03ed3e9f,0x27b70ae0,0x4d8f2987,
0xf44f3629,0xca36b688,0xd8e6b96d,0xf52af082,0xd1c7de72,0xedf1d345,0x045e22c0,0xf164fe83,
0x398330b9,0x0dcf3c5e,0x20d300a8,0x45e722f0,0xf5973d73,0xcc6dafe0,0xd762c436,0xf831f455,
0xd08eda01,0xf772d447,0x00bb1e70,0xef9dffa5,0x3c9b31e5,0x1bea34b3,0x1cd3fd19,0x3a6b2264,
0xf6744ab1,0xcd59b150,0xcf94cc7c,0xfa1ffa65,0xc726d0c8,0xfe05d16f,0xfe4f198c,0xefdd009c,
0x42e32f89,0x293a2c42,0x1a2ef9fc,0x2fa21ea0,0xfeb85191,0xd05cb25c,0xd41dd71e,0xfcf2f6b8,
0xbcf0d2a1,0x03d5d484,0xfa2e144a,0xf9550093,0x44b02df6,0x2daa28d8,0x0ce7fc0e,0x22552178,
0x07ce4d3f,0xcbeab232,0xd3dce258,0x0b43f3fc,0xbc11cc29,0x0b72cfc4,0xf68113cb,0xffb1fa0b,
0x47da26bb,0x329e297b,0xfc5d05d2,0x257a2132,0x11b14454,0xc8e8b859,0xd97fea06,0x09b8ec1c,
0xb462cd76,0x0c0ecf4c,0xf16a12b2,0x10f4f4a1,0x40f8205d,0x2f96267b,0xe9a713cb,0x241c2137,
0x17633a0b,0xc5b9c013,0xe791f330,0x0905e094,0xaf81d6f7,0x0be7d2e0,0xe8c21314,0x22c1ecf5,
0x38271bf4,0x32ce29af,0xdba31f26,0x29871c3c,0x17df2faf,0xc2f6cdd7,0xf396f5dd,0x0040d98d,
0xb4fcd6ac,0x06ded497,0xe6491231,0x2960ea95,0x26321ea9,0x336132dd,0xd74525d4,0x2d94118b,
0x137a2b75,0xc7a8d98d,0x0061f16d,0xf3aadcad,0xbd3cddd2,0x0752d45d,0xe63c0ce1,0x2eb7e2cd,
0x11ea2956,0x3b4635d7,0xd984254e,0x31d803ca,0x0b7827ad,0xce4be814,0x05e6f111,0xe6c7d8ee,
0xc90be12a,0x002dd2e7,0xea340875,0x299ae1dc,0x06723164,0x44c43285,0xe1922277,0x32bbee7c,
0x06762b37,0xd70beb76,0x0887f0d7,0xd4cde92e,0xd612e084,0x0501d3f5,0xf1f2faf0,0x2325dc19,
0xffc73901,0x4feb2d77,0xe6e11bc9,0x2e7debed,0x05e62ab8,0xe6d5eb15,0x036ff1f7,0xc10af4f5,
0xe192e630,0x02dfdbb6,0xf089edb0,0x1e41e179,0x04363685,0x52e62036,0xec5512e9,0x260be841,
0x02722a63,0xf144ed65,0xfec9f130,0xc4b1f9f0,0xeb02dcd8,0xffc3e61a,0xf177e9c3,0x157fe82e,
0x0da438cf,0x5d1416b6,0xec0917d9,0x1fc6eb30,0x04852768,0xf4c7ebc5,0xf3fdf83c,0xc4adfbe8,
0xf206d537,0x00e5f0cd,0xe717dfa3,0x0cbbf0c3,0x10ee34fb,0x50140ebd,0xe9be1e2b,0x16abf2d4,
0x05372726,0xfb8feb3a,0xf1bc001b,0xd6d2f366,0xeff1d029,0x01b1fd12,0xde83e2e0,0x07d3f7bc,
0x18bb2da0,0x46680f4f,0xea3920cd,0x152ef8f7,0x08041dbb,0xfab9f206,0xee2304ee,0xdd7aeb89,
0xeed6d23e,0x076f0396,0xd183e1d1,0x07e7f6b8,0x189b2bc0,0x34ce158a,0xeffd22ca,0x1518f262,
0x09f8134a,0xfcb2f338,0xf0bc0bb2,0xe444e603,0xe6dadd17,0x0ff30b2e,0xcdf3e1c4,0x0bd9f32d,
0x18bd2053,0x26511ecb,0xf2cc2634,0x18e8f258,0x0ae009e0,0xf034f92c,0xf2d60eb9,0xe5f9e455,
0xe576e3eb,0x1a620cc5,0xc900e941,0x0dc5e8b4,0x1afd1f3f,0x239f1f6d,0xf9b61a0a,0x184cf417,
0x0cf107e8,0xf0e5fd36,0xf2b20f01,0xe7adde14,0xe169ee32,0x179b0b9d,0xc107f01b,0x0dade5c9,
0x12191bfe,0x263e2589,0xfe6f0d08,0x13c5f2a5,0x0cc40838,0xed97fa45,0xfa090c25,0xe122e70d,
0xeecef76e,0x2239011c,0xbfb7fbfb,0x0cdedb38,0x11f5229a,0x1f1d2626,0xffa80830,0x07fa01a6,
0x0ad60c25,0xec27fe05,0xfaa3046f,0xe1e9eb4a,0xf537fcd1,0x1e7af9a0,0xc2280375,0x074dd360,
0x0d781fe4,0x20d921e8,0xff250150,0x01b00466,0x0d6d0f09,0xef9f00a7,0xffe2f3d1,0xe2e3f1aa,
0x04effe41,0x1b5bf31c,0xc8eb07e9,0x0102d88e,0x0e6f233e,0x1a381eb5,0xffce0110,0xfe29021c,
0x0bf40f98,0xed97078a,0x00d4e563,0xe971f985,0x0748fd31,0x1a52fc3a,0xceeb05f9,0xfce3d698,
0x0ee32155,0x11021fe1,0xfbf00107,0xfdec01dd,0x12d30773,0xe9be0a4f,0x0260db94,0xe9bb0028,
0x07c0fef3,0x14b60461,0xd53c0411,0xf7e9dd06,0x18e21647,0x0cff18e7,0xfd6cfd53,0xfee100a2,
0x19f2039e,0xe6960df3,0x0343d678,0xeff3020a,0x077401e8,0x17171012,0xd65e00c4,0xfc5adffe,
0x23c60d0e,0x03a01501,0xfe4bfa75,0xfbae0025,0x1b1ef8e4,0xebf211d5,0xfdcbcb9d,0xf44704af,
0x092702da,0x194916ad,0xd7b1f8c3,0xf905ebb5,0x27460648,0xff3713c1,0x01a4f85e,0xfb0000cc,
0x1fb8ff0f,0xe9ee1639,0xf867c717,0xf7c20750,0x0acd0562,0x1b08172b,0xd67efb30,0xf47ff81c,
0x24980248,0xf69118fc,0x01fdf316,0xf201fdc3,0x1b750604,0xeac81aa1,0xf58bc6fa,0xf8fd0764,
0x10d60318,0x1fc71391,0xd670f5ac,0xf853fc9b,0x204bfe85,0xf14721f9,0x05d2e97e,0xeda8ff75,
0x1a61fed7,0xe9f91c57,0xf1d4cd9b,0xfecd04f9,0x13260be3,0x1bd9153d,0xd767fc88,0xfc4efd7f,
0x18e7f5cd,0xf23d2255,0x0395defe,0xe13f0b19,0x1c33fc22,0xf3661b8b,0xeb8cd1c4,0x0571028a,
0x19430a94,0x1c6d0eb4,0xdb4aff53,0x0708f7f2,0x13b3f060,0xf7df2088,0x03e7da68,0xdb871233,
0x19b4f5de,0xf5d71900,0xe5eadae0,0x0b12fe0a,0x225509da,0x1536150b,0xe3fe0553,0x10abf898,
0x0dfbef75,0xf9961c07,0xfb80d760,0xdb3215ab,0x1b6de858,0xef1a1b84,0xe2e4e195,0x0b8afa42,
0x26b70c76,0x08bc16bb,0xec950c87,0x0d16f403,0x0ecbf477,0xf91b1a0e,0xf774d160,0xdf361d9e,
0x196fe09f,0xed621ca4,0xe941ec60,0x10c0ee0c,0x2f3b0d30,0x00501beb,0xf8ab087d,0x0df8f225,
0x02fbf983,0xf552168b,0xf0b7d348,0xe5ad1c38,0x0d29d6f6,0xe8602022,0xec1bf267,0x0e61ee5c,
0x2f180fb8,0xfd91252c,0x09d000f8,0x0746f033,0x05570155,0xeec9104a,0xeb9bdcb3,0xf22a1a1e,
0x0322cf80,0xe6a520b1,0xed51f712,0x0fc6e902,0x30851405,0xf4a72e39,0x19f2f7b9,0x0077f8c7,
0x02e207dd,0xeef90921,0xe698e36c,0xfa8013d2,0xf6ebd343,0xeb821b4b,0xf1c0f9cd,0x0d20e99c,
0x33491336,0xf0852d06,0x2632f2ad,0xf878018a,0x04e50d79,0xe81406f4,0xebb0e976,0xfd4a07bd,
0xea9fd690,0xf3c9133f,0xf393f955,0x0a3cee77,0x33641984,0xf13e2c02,0x297bea71,0xf90709a9,
0x083d067c,0xe257feb3,0xf3eff16e,0xfd84ff9e,0xe307d7ab,0xfda10bf6,0xf059f9eb,0x00bef844,
0x32dd208e,0xf1ec2c4c,0x260eea17,0xf3c619c6,0x0bee0554,0xdd7df49e,0xfba8f42e,0xf902f8d7,
0xda9ee026,0x0979f74c,0xed4ff9e6,0xfb8800c4,0x353f2743,0xee5e2c20,0x1b65ede5,0xf74f2af9,
0x10f005c4,0xd829e884,0x07a9fc6e,0xf10aef7b,0xdbd2e35e,0x1208e966,0xecfcfb8c,0xff1600db,
0x39b22a79,0xebf2262b,0x0fd6f1b1,0x0344360e,0x0e26ffef,0xd365e585,0x0d9f0053,0xe05cf028,
0xe2e4e1ac,0x1313daf3,0xe37b0488,0x095d0212,0x40a626c9,0xebe81f59,0x02edf682,0x14213641,
0x0a72021c,0xcc45e590,0x15030222,0xd961f6d4,0xec7adfe0,0x0dbecfa5,0xe42e0676,0x0cbd04ef,
0x43d72967,0xe84d1aaa,0xfe0cff72,0x1a6131ba,0x01fe0bad,0xc5a1e37e,0x1bc808b1,0xcec0f493,
0xf83ad846,0xffa8ce1b,0xe47b0dd9,0x12f5049f,0x457c2974,0xe5321691,0xfbf60256,0x2a582581,
0xfef011b2,0xc63cd7d9,0x247409f7,0xcde7f691,0xf929d084,0xf719d072,0xe79c1483,0x0bad033a,
0x49e02f2d,0xe69d1522,0xfe27024e,0x355d19f8,0xf9911ae0,0xc952d127,0x248c085a,0xd034f258,
0xfb0ec777,0xe810d6e9,0xf8000e15,0x1554fdd1,0x463336f8,0xe0e012ec,0x0182016d,0x3c681235,
0xfcce24f7,0xd0b6cafe,0x257f0c04,0xd26fefcd,0xf5fac479,0xe13de0a2,0xff25fe0b,0x16adf7fc,
0x43583c9b,0xe2b8168b,0x0489fa47,0x36ca1528,0xf5213111,0xd594cb4b,0x21ef0fb9,0xd928f01c,
0xf38ec752,0xdd7ae7b4,0x1143ede5,0x1892f06d,0x441e3913,0xdff411ba,0x0b59f217,0x3093133e,
0xf39a3af7,0xd048cd2a,0x184715f1,0xd7fbeae3,0xec49cc57,0xe41deed0,0x13fbdf39,0x2645f0e0,
0x46d93d3e,0xdfea102e,0x08cfef5d,0x285c1268,0xf7063e08,0xd20fcd6e,0x14e4146b,0xdb6ee4a6,
0xdef4d0ef,0xe800f1d0,0x14d3d4e2,0x208ef2d6,0x46e046d9,0xe2a312ca,0x0b92e5fe,0x261c1693,
0x02973e73,0xd716cdc3,0x0ca81a99,0xdf36e0da,0xdb3adef2,0xe749ef7f,0x0684d427,0x218afd28,
0x409547a7,0xdeba115e,0x0cd3e098,0x1f571e65,0x0e6b336f,0xe196cd4c,0x09b31703,0xdf64d92e,
0xe29ceac5,0xeb57e422,0xfce3d259,0x22f20b43,0x3ebc4bef,0xde380dc3,0x0c43de7e,0x21061aaa,
0x193a2b71,0xe654d09d,0x02900d5b,0xe20ad82f,0xe4f1f292,0xecf5d801,0xef73da68,0x22570cbd,
0x43ff51bd,0xd25f0d0f,0x0823e925,0x1cf12264,0x22c42503,0xf375d4ec,0xfc7006c6,0xdbb0d6d8,
0xed5e0138,0xe9ffcc07,0xe0a7dcfd,0x24840f09,0x47b74d5f,0xcdb2fe24,0x028df185,0x177921e3,
0x261325b1,0xf542dc73,0xf5c3091a,0xdb61dd12,0xf9970968,0xee8ac0c5,0xda58e3ee,0x25a80f91,
0x4fe54bbe,0xc9e1f2cc,0xff72f5c6,0x1281235f,0x222625ad,0xf44be860,0xef8f0819,0xdd7bd72f,
0x00af11c9,0xf161b61d,0xd304e1dd,0x2f3a0781,0x53ba4c5f,0xc794e5a9,0xfed8fea5,0x0df72685,
0x18082680,0xf7daffc8,0xe97101ce,0xdd09dd1f,0x03911932,0xec6bbb22,0xd568e67e,0x2a74ff7b,
0x4ff94f63,0xc5dde1c2,0x004a0176,0x12d31dff,0x0dbc27eb,0xf8b0072f,0xf0daf7e0,0xe357dc75,
0x051b15ea,0xe9a8bceb,0xdacfe504,0x2dd8f805,0x47ac5577,0xc25fe0c4,0x08bdff64,0x1c6d13a3,
0x09e9236a,0xfc8a1261,0xf3abef03,0xe843dc75,0x044f17b5,0xdf64d42e,0xe14be0f7,0x319becd0,
0x41bd5626,0xbfbbe1a2,0x1487f7d5,0x1e4e0db9,0x069f1c47,0x017610f9,0xf947e709,0xef95d786,
0xfd8615d6,0xdbb0e4b1,0xec0ed98b,0x3174e48f,0x380e4e71,0xc38ce7c3,0x1d6df8e4,0x303102ed,
0x0a451744,0x03951506,0xf8a6e121,0xf3e1dd0d,0xf5cf0d91,0xd457f41b,0xed92d79e,0x2c54e4fa,
0x37274592,0xc0abea59,0x220df295,0x2e89032b,0x0ee81763,0x020a1453,0xf8f9e7f2,0xfcf0e521,
0xf9d10882,0xd521fef3,0xf5cfd521,0x1b84e366,0x31684139,0xbf89eeee,0x1aafed43,0x27390946,
0x0c1b1939,0xfcdf0c64,0xf201f118,0xfe52f151,0xf9380459,0xd8bf061f,0xf71bd2c3,0x0d43ee4a,
0x2cfc3b46,0xbccaf914,0x1351edb8,0x1f8316a7,0x108e2277,0xfd3b0163,0xe7eef6ce,0xfe15f5b3,
0x0147035b,0xdfc40191,0xf4dad434,0x05b0fb42,0x3435284f,0xc3ebf643,0x015aec5c,0x17ac2804,
0x12502844,0xfdeffe07,0xedbaf8bd,0x010ef9da,0x05670037,0xe42afb29,0xec51d086,0xf27e0c20,
0x346f1b3b,0xca8dfb9d,0xfb66eb78,0x15b02886,0x1a2229a0,0xfa86f3bc,0xf1daf8c6,0xfea7ff6d,
0x0c460598,0xf48ff34a,0xef9fd686,0xeaa10e01,0x32e80ec3,0xd6fafa4b,0xfa5fe49b,0x15a623d2,
0x20e12bd6,0xfb48ebf2,0xee74f7bb,0xfbe300dc,0x0b6c0b4e,0xf6c6e962,0xeed7db8e,0xe45110fb,
0x2e1206e2,0xe1ed003c,0xfadddce6,0x1c211694,0x25762ebc,0xf9c2eb74,0xf415fd1c,0xfb3affcf,
0x09f7155c,0xfcdee8fe,0xf245df2e,0xe2cc08ed,0x2a33fe6b,0xee4d0373,0x0028d39f,0x272b01a6,
0x213731b0,0xf6e3ea7d,0xf5d4fff0,0xf5f1feef,0x08171e9b,0xf9ebee26,0xf11fe62e,0xee30031d,
0x1a00fbda,0xf29209f3,0xfac9ddf9,0x2cc2f03d,0x235c343a,0xf4a7ee9c,0xf888ff89,0xf725fbf2,
0xfda1239a,0xf1adfd74,0xf301ecad,0xf65cf4c9,0x0c3efd6e,0xf4e61051,0xf5bfde7c,0x2bd6e837,
0x1ef43c2d,0xef6cef9e,0xf5de0a11,0xfa01f59e,0xfed32051,0xeeb90282,0xf2f9f08f,0x0373ebd7,
0x0256f829,0xfd350dc1,0xeb87ea15,0x2510e3ba,0x1d5a42cc,0xf069f6a0,0xfc4b0b29,0x0646ed7a,
0x086514c1,0xec18086a,0xed48f384,0x0843e69b,0xf849fc9e,0xfe8007af,0xe36cefaa,0x1d0fe59a,
0x21764457,0xf5f6f1df,0x0032092c,0x0680ed0e,0x077c12a3,0xeff10fcc,0xe521f2b0,0x0ea6e762,
0xf6dafa4f,0xff1b0a53,0xe27eef08,0x11c9e6eb,0x22114381,0xf49efe3a,0x0656051b,0x0597e9e4,
0x0eb40ced,0xf8ed0f4d,0xdacaf429,0x131be633,0xf7fcf897,0xfc1606b6,0xe4c8f199,0x07b2e7a4,
0x28963f01,0xeea004bf,0x02ce0d1b,0xfeffec52,0x0f1a1357,0x04aa0de7,0xd172ee7f,0x0d8be873,
0xf8eafe9e,0xfa25040c,0xe840f010,0xfd59e71e,0x2a2739ef,0xf4c50cf7,0xfe8a139f,0xf4ceed44,
0x13af105b,0x0cea0bcd,0xc5eded34,0x0bf8eea2,0xfbcb099b,0x000ffb41,0xf545e5ae,0xf26ae76c,
0x2ac7336f,0xf7c00f2b,0x0413163c,0xede4ebb7,0x18bb11ce,0x1a63057f,0xc1d6e91f,0x04e6f0c9,
0xfcfd0ff4,0xf830feef,0xfe4bde49,0xe7f5ea8f,0x2ee52b23,0xfd08179b,0x08491799,0xe88ee3ce,
0x22551146,0x1a80025e,0xc112ebb2,0xffeaea03,0x04051e8c,0xf4fffd53,0x0142dd61,0xe9f9eb13,
0x324b1f80,0x019416ff,0x0f581dd9,0xe4c9dd9c,0x281e091d,0x191301a2,0xc2e8ea2a,0xfa8de61f,
0x1251223e,0xf657f961,0x017cd8f4,0xe532ec9f,0x32d41beb,0x0c6112dc,0x0be7245c,0xd991dd24,
0x1fa00be1,0x0fe30f9c,0xc782e907,0xf3c4e096,0x1d142410,0xf247f9b8,0xfd0bda94,0xe6b7e85b,
0x2f7e1a8f,0x0f4017da,0x0c502f96,0xd3c4e1d9,0x1687105e,0x01da210c,0xc8c9e8a6,0xf488d9d3,
0x25c01b53,0xf04a0304,0xf4bdd9be,0xe887e8b4,0x21451698,0x0f461c61,0x129031b6,0xcf8edfac,
0x08b711d5,0xffab2f14,0xc6fae7f6,0xf8b8d88a,0x28be144e,0xea760fb4,0xf1c9e0f7,0xed62e273,
0x1e4e17f1,0x13ec2016,0x1e0632e1,0xda53d7fd,0x03050ca4,0x0aa62830,0xc927df5b,0xff81d47c,
0x2ad8092c,0xe72f1a29,0xe646ed4e,0xec5cdaa6,0x1b32172e,0x19141ffd,0x28162cb5,0xea1ad0b5,
0x0246ffb6,0x12c92780,0xc4b5d9e7,0x0532d36b,0x2cbc0572,0xec142726,0xdffef38d,0xe9d2da56,
0x1c5a1443,0x17542126,0x29622601,0xece7d5ff,0xff03f8a1,0x18732019,0xba07d8ed,0x07c5d767,
0x2e010297,0xf2902a6b,0xde7cf469,0xe91fd276,0x23961016,0x1cd71f88,0x26992024,0xecf5e21d,
0xf815fd6e,0x1b4017d0,0xada9dcce,0x0921db4c,0x2f83fba8,0xfc7f3036,0xd786f7a5,0xe635d4a2,
0x2bc60ab3,0x16c821f9,0x2a101cd3,0xea8bee62,0xec9c033a,0x18e31388,0xa230e3a2,0x092fd78d,
0x2cac0309,0x01ab2c56,0xd9f7ff51,0xe7a6d958,0x3623fade,0x15ba2a57,0x22c915e7,0xee33f706,
0xebd90678,0x13170628,0xa290e6cb,0x02e3d935,0x30f40429,0x06fb2944,0xd6d502af,0xdd31df88,
0x3c50ef9e,0x0c122bbf,0x25ff1536,0xf2b403e2,0xe94b052a,0x10d60280,0xa901e8a6,0xfa8bd66a,
0x32b612c0,0x048d2abd,0xddaf0330,0xda36e1da,0x3c76eb77,0x122f2cd5,0x2c3e0d8d,0xf718018a,
0xe882057b,0x0782fff0,0xaaece0c8,0xf4f1da3e,0x2f2c152c,0x043f2f33,0xeb560637,0xd602e321,
0x3842e179,0x109a2c25,0x2f550261,0xfbda02ec,0xe42a0996,0xfe53ff2f,0xb329e16b,0xea2fd7be,
0x2bab1eb8,0x077435ce,0xf8cdfdbc,0xd950e310,0x33e8dfd4,0x186c2e88,0x3029013c,0xf9710787,
0xda2a1084,0xf804ff97,0xbb13d7af,0xe4c5d4d8,0x2b1b1ff9,0x02a83cf4,0x0493f98b,0xd4cae892,
0x2a5ce008,0x21592864,0x35e5fac0,0xfb7707e3,0xdd88172b,0xef69fd79,0xbfecd00b,0xe60fd451,
0x2b8b2109,0x06bf3d16,0x1184f852,0xd572f109,0x1cabe1ac,0x1f2c247a,0x3008024c,0xf718126b,
0xe2171514,0xeebbf7e2,0xc2aecaf3,0xe6d9cfe7,0x30311e51,0x10cf32ac,0x133bf033,0xdd59faa1,
0x0ebee1bf,0x20841fd3,0x29070b20,0xf9551db3,0xe64b1124,0xee77f228,0xc788c1b9,0xedfcc8e1,
0x29b41c1b,0x17133141,0x15afefe9,0xe23502ce,0xfff5df3c,0x20ea17a0,0x270714c6,0xfa7d1e91,
0xf3c20887,0xf740e31e,0xc3c6c2af,0xf539c637,0x277619f4,0x1bef2f6d,0x11c5f22c,0xeab7117d,
0xf657ddee,0x1f2210cc,0x1ce7189f,0xfe3d27a3,0xfb2afd45,0xf5bcd9bb,0xc3aac2b8,0xf75fc4db,
0x2555166c,0x22742b9d,0x125ff9c3,0xf65f1430,0xefffdd17,0x1b100d5d,0x1be81eca,0xfc8431bc,
0xffecf55d,0xf48fd885,0xb96dc503,0xf362c800,0x1eb01d20,0x20292988,0x1873fcbe,0x01cb1577,
0xe922dbf5,0x169c0899,0x1c771c00,0xffa53cba,0xff2af0b7,0xf382d9df,0xb55acb94,0xef7ccee6,
0x1aaf1dbc,0x20de249a,0x1b1bfd3e,0x0d211a16,0xe676d449,0x0ef103f7,0x1b6216b0,0x04243e4a,
0xff08eaeb,0xea24ddd5,0xaca8d2ef,0xec9cdc90,0x126b20a1,0x1c6523fd,0x1ff304f8,0x16891c11,
0xe5a7d66e,0x0d5d055e,0x27330e15,0x05d13a53,0xfa2fe858,0xe672e4bb,0xa4eed259,0xe7dddf12,
0x0b0921c5,0x1a401fe9,0x1f0a07e9,0x20512660,0xe33fd745,0x041907ae,0x28730864,0x0ff43b2b,
0xfaa1e7d6,0xe1b7e71b,0xa8afd58e,0xecafe1aa,0x0c87168f,0x1b1f1b5a,0x1dfa0b01,0x21252a30,
0xe3fbde94,0xfa3b046d,0x27c6063e,0x13d932f2,0xf03eeb33,0xdde3f177,0xb039d316,0xf92cdbfc,
0x14360501,0x1a8313e3,0x231e0ca9,0x260b3177,0xe795dde3,0xef880221,0x27d800bf,0x17723068,
0xf485ef36,0xdc01f2a4,0xb661d200,0x018fdaa6,0x1805f8ea,0x149f0bcc,0x27d30d7d,0x2ad535bf,
0xecf3e8e4,0xe3c4ff64,0x20ef044f,0x1f2c247a,0xeb4df331,0xd837efeb,0xc1d6d05c,0x0564dd97,
0x1275ee7c,0x1a770983,0x21591027,0x2a033ebe,0xeca3f599,0xd756fe03,0x1a9207ac,0x23762347,
0xebc6f633,0xdafbeedb,0xc71cc98c,0x0a84da38,0x089fea90,0x1ccb043b,0x1eda1001,0x2d504d6a,
0xf7e202a9,0xd2a1f688,0x184e053b,0x25251cbb,0xeb040046,0xe0d5ea12,0xc575c8a4,0x0405e219,
0xfe71e9fc,0x11720918,0x19ac1137,0x2ab9580b,0xfa89130e,0xd2fdea84,0x143602ce,0x23ec177e,
0xed300d6a,0xe5a9dbed,0xc6c0cbde,0x053be3ba,0xf4bbec3a,0x1506005a,0x14980e1d,0x2c245b0f,
0x04f71eb8,0xd618dcad,0x0ee0facf,0x239f0f8c,0xf2c01899,0xe971d2fd,0xc4abd519,0x06e8e870,
0xe302ee84,0x1b4a00f8,0x127d0a1d,0x3a5d5628,0x100121fe,0xd8e6d008,0x0c34f742,0x21f60c8f,
0xf61b1914,0xe7a0d245,0xbee8e3d0,0x0705e4b4,0xe0a2efee,0x1d70020c,0x10e707b6,0x4b1b58b2,
0x16cb25f3,0xd772c87b,0x069ef1b8,0x1c1708b7,0xf66a215e,0xe0f2ce27,0xc794ecf2,0x08e0daf6,
0xd9b1f296,0x1de7fc44,0x10f003e2,0x63e0525c,0x14ea2c63,0xd56ccb82,0x0383ef47,0x196f0326,
0xf52922c2,0xdaccd3e3,0xcd6af122,0x053bcbac,0xd969fbe3,0x1bc1f8d7,0x0bf00027,0x6c6e4eec,
0x0fea3798,0xd2d7d66a,0xfcd1ec0c,0x1534fdb8,0xf5152a6f,0xd961d278,0xddb4f79b,0xff8dbb77,
0xd9fcf914,0x1a88f625,0x070e027d,0x73b045c2,0x069447e4,0xd438dce4,0xf778e6a3,0x119401ac,
0xf99b2930,0xd60fdc4d,0xeaa1fc45,0xf7a6b503,0xd815fca1,0x175ff9a3,0xfdef0aea,0x74f0457e,
0xfe995864,0xd976e436,0xf4b6db9b,0x0a75fb82,0xfea420fd,0xda5bdfba,0xf121fc18,0xe9efb528,
0xdff1f618,0x1227fff9,0xf4f00f01,0x7aff43a5,0x04f863f9,0xe462e121,0xf71ed65b,0x0690fc18,
0x09370bb2,0xdeaae33a,0xf529f4aa,0xdb6ab3fb,0xe745f796,0x0d13000b,0xf61d0deb,0x7c044312,
0x10515fcd,0xeed1dea2,0xf20bd31c,0x056bfc04,0x0f3b0419,0xdd09ea81,0xf199ff9d,0xd353b5ed,
0xe940ef4f,0x0df5025c,0xf2ab0cc4,0x78353cc7,0x1d515de4,0xed62df4c,0xe966d6a8,0x0550fdf6,
0x0c48f5cf,0xe20bf5e2,0xf3fe0242,0xd09aafe4,0xe75be950,0x13cf0c63,0xf94105e6,0x75a53242,
0x2ae7586e,0xe486ea65,0xe7a0e004,0xff56fe07,0x048deed7,0xe4ca089a,0xef700897,0xcfd8b177,
0xdfeee57a,0x1c44117c,0xfd5dfc82,0x6c482f61,0x2f165628,0xdd75f54b,0xe289e5c9,0xfe37fbba,
0xf5a4ea06,0xf2621826,0xf7420357,0xceedab10,0xdbf1e1dc,0x1fbb176b,0x0062fe3f,0x66a12cc4,
0x35664de7,0xdc62040a,0xe79ae177,0xfb5ff3e8,0xe9c3e75f,0x01941a46,0xf4e90067,0xc937abe2,
0xda51e989,0x248c140e,0xfc6a0483,0x58622fb1,0x3d014827,0xe5020fda,0xf19adb1d,0xf3a4ef70,
0xe484e809,0x108b1ad3,0xf0aefaec,0xbd95b18f,0xd4eaee8f,0x2aa50d64,0xfd7907a8,0x4e412c32,
0x3d08410d,0xe97a1391,0xf40cd643,0xf1eeece8,0xeb80e765,0x1d990e7d,0xe8b003cd,0xb75ab914,
0xd739ecf8,0x2d1909b7,0xfcf70d45,0x478f2c51,0x3ed63cad,0xf578172f,0xf7f6d8c4,0xe7f1ee1e,
0xee67e506,0x1e660620,0xdeb31108,0xb4f8bfe1,0xe383e716,0x269702ae,0xff0f19c4,0x3d9424aa,
0x39c13ee3,0xf8b8170f,0xf1c7ddbf,0xd8e1f7e5,0xfce4e455,0x1862036f,0xd8911c9f,0xb970c8cd,
0xf7e2d76e,0x20fdf8a1,0x05b923ec,0x3455207b,0x3a793bc0,0xfa87174b,0xeef9ebcd,0xcdb9f89a,
0x03ffe29b,0x09b50242,0xd7f32303,0xc515c295,0x00b4cf29,0x1ac8f52b,0x0f8c23e2,0x2b9a1ebe,
0x3d823b8a,0xfa90172f,0xf2b9f46d,0xca7df4d3,0x0c5be06f,0xff34ff2d,0xe054265d,0xcbd7bba4,
0x03d5cabc,0x0f32fc1b,0x0ca927d4,0x21062051,0x3fdc3150,0xf5ca1913,0xf8e0fd9a,0xc8a7f2d6,
0x1283dc19,0xfa770494,0xed6a1de8,0xd129b4b8,0xfd1fd0a4,0x059d04af,0x157c22b1,0x1e221f3d,
0x40d6294e,0xf95d183d,0x0a66f7f8,0xcc6be7d0,0x1193d607,0xf9f00e87,0xf7c60b24,0xcc45bb2b,
0xf76bdd45,0xf7ec1209,0x17bb1dc9,0x19b027f9,0x3f5c1f22,0xf15b1c69,0x1410fae6,0xcdcde37d,
0x11acd47c,0xf933125f,0xf882fed5,0xcbb5c457,0xf382e62c,0xfb4617e2,0x194010e0,0x1ba42be5,
0x37871a40,0xf11f2039,0x18e8f5db,0xcdcdeab5,0x0fc0d68d,0x01f611d5,0xf5ecf333,0xc51cd05c,
0xf423f065,0x003e1813,0x17490730,0x1d2c2a4c,0x30c71e78,0xecc72623,0x1dbcf24a,0xc817eef2,
0x06cedf23,0x09e510fa,0xe8f4ef69,0xc85cd401,0x00e0f310,0x09220e6f,0x130fffb6,0x1eba25cf,
0x2b421c83,0xee3c2576,0x1db4eeda,0xc602f5eb,0x0208e77a,0x0f3a0fd2,0xde40ebfc,0xcea2da53,
0x0ce7f0bb,0x0cc90538,0x14f5f87e,0x21dd22de,0x22b11b99,0xf2842068,0x1b08e765,0xd0cdfc00,
0x01ebe8e0,0x0f920cad,0xd056f438,0xdd3cd923,0x14aaf24a,0x0a410351,0x0cfafca8,0x1a332476,
0x26ef1cd7,0xf4381902,0x119de103,0xd6e6013a,0x0266e766,0x0e62065a,0xcd48f9ed,0xe784d6c7,
0x180ff761,0x0a3603db,0x09910282,0x0eb727f2,0x2a701fb8,0xf56911ce,0x0a20ddd7,0xe72808dd,
0x0a35e2c6,0x04dffe15,0xc66b0107,0xef11ca53,0x1891fe67,0x0142074c,0x01ff08b6,0x0e4325df,
0x2e3b1f1b,0xeec90fff,0x0849ddf2,0xf0040b89,0x0d9ce9c3,0x0168fcda,0xcaf3013d,0xf1f2c0f5,
0x15470b29,0xfca40919,0x070e06c6,0x0aea1e36,0x2f0e153a,0xe61f11b1,0x03dbda1a,0xf9ed0856,
0x0ea1ef2d,0xfa4efb66,0xd81ffd5d,0xefddbeb0,0x1b4619ed,0xfcf00847,0x1181062a,0x0b9c1615,
0x2e6a11dc,0xd83417fa,0x01f5d969,0x000709e6,0x08f7fbb6,0xf744fcdb,0xe021f6ac,0xe5c1bec2,
0x1da72a57,0xfc52018a,0x16db03ef,0x10920dd5,0x29c7083e,0xd1531d4d,0x024cd2ab,0x077d05cd,
0x03600659,0xf33101f7,0xe7b4f25d,0xe2a9bc6f,0x256730b1,0xfee2fd9d,0x1f6c0281,0x13650676,
0x2477052d,0xce041e78,0x00cac92e,0x0c0c0313,0x01f00a8e,0xec4e0533,0xe0a9f37e,0xd92eca90,
0x31e83987,0xfadcfe71,0x21b20312,0x12ca0533,0x211f08c8,0xd6731b95,0xf98ac12e,0x0cf10a84,
0x04fe0bf0,0xea2f019e,0xdb54ed96,0xd3bad5a9,0x3d233523,0xf5f6fdee,0x205b0aed,0x103801d2,
0x1d1d064d,0xe0b811f9,0xf54dbc1b,0x15ab0be6,0x0a321247,0xe7a60342,0xd3b9e895,0xe12fde94,
0x42e724e8,0xecb8051e,0x1bfd12dc,0x08cb048d,0x1ee40185,0xde6b0cb6,0xe796c300,0x19b71117,
0x0c5010c2,0xe4f80646,0xceb9e986,0xe84ee006,0x454e1c32,0xe71b1448,0x1bb7160d,0x08900400,
0x2199ffa2,0xd86f046b,0xe158c831,0x1a1e0e87,0x17350da5,0xe5d401e6,0xcd8de8dc,0xf710d925,
0x42131a99,0xe61d1f49,0x287e11d2,0x0584faff,0x2617fd7b,0xdaaff58b,0xe017cd93,0x1bb008c8,
0x18a40d35,0xe6070691,0xd0d2e721,0xfe65d345,0x3d611708,0xe5a42a15,0x2d340faa,0x04d7f679,
0x1f62feb1,0xd539f7a0,0xe07dd6c7,0x190e04ab,0x1bd30e71,0xe2c60783,0xd77ae7f2,0xfdafd119,
0x34981c71,0xef4533d5,0x29580a3c,0xfc77fddb,0x1f700226,0xd484f329,0xe874d158,0x15befbe6,
0x21930ad1,0xe8d201f7,0xd9ede87b,0xf758d37d,0x3006293b,0xfa2a382b,0x23520995,0xf89a0478,
0x152aff64,0xd643f266,0xefc2d136,0x0dcafb18,0x28b2068a,0xed82041d,0xd93de858,0xf2afd18a,
0x352c26b5,0x05ea328a,0x14130d79,0xf2391162,0x0cf5fb9a,0xd3f5f284,0xec8fd5dd,0x044bfdfd,
0x26dd0286,0xf4010347,0xde8aec56,0xecaed41a,0x3cb0239a,0x10b730c9,0x094b10b4,0xfe7515af,
0x07e6ef25,0xdad2ede8,0xe876da6e,0xf651fe7b,0x28c7ffe6,0xf5b5ffac,0xdfe6f57c,0xe70ed33a,
0x454e1f81,0x17fa3154,0x01b1188b,0x0e211358,0xfdf2e32b,0xdeacec44,0xe800e127,0xeedb0393,
0x23e4fc12,0xfaf906ac,0xe0a7f9fc,0xe147d089,0x4cea1708,0x16ea2f3f,0xfdbc2244,0x22940ce2,
0xf687d7a6,0xe70eed7a,0xe19fe56c,0xe96901f7,0x231cf307,0x02020351,0xeade028b,0xdff5c630,
0x4dac15f0,0x187338f1,0xfaf62826,0x2ebc0612,0xec66d4ec,0xf07de68d,0xe80be8d9,0xe898f8cd,
0x1dbbe885,0x02c50a4a,0xe80a08b6,0xe1d1c51b,0x49571216,0x17113cdc,0x00682a22,0x26f50383,
0xda31dbf7,0xefabeb85,0xdf72f692,0xe7f5f3a2,0x1d29e41d,0x00720869,0xef5d1461,0xd873c032,
0x4a96154c,0x20d73a27,0x08f5255f,0x20ad0918,0xd33ce774,0xf699e813,0xdb0c0236,0xeba5e9a2,
0x14d9dff5,0x020a1094,0xf3851a6b,0xd66bb76c,0x47801ba6,0x222e387c,0x10171e02,0x175f0a40,
0xcb7eecbb,0xfaabe196,0xddc20da4,0xe976ddd2,0x0d45e0dc,0xff9319df,0xf9f420c3,0xcf83b8b7,
0x43d4228a,0x293a37fe,0x176f1ef6,0x0a6b127c,0xd49eeaa3,0xff7bd79b,0xe3c910ef,0xe1dfd274,
0x060ce322,0x02bd1d17,0x010e2500,0xc933b60f,0x3d0922bb,0x259b3ef4,0x17af19bc,0x05701616,
0xdfd9e649,0x05d6d098,0xf0cb0e5e,0xd887c35b,0x06d3e1e3,0x089f1772,0x0da81d40,0xcbfab432,
0x362823f8,0x26db43d7,0x153b1e63,0x00f91f31,0xe0d0e03c,0x057ad526,0xf8a40c1c,0xd0febaaa,
0x0f10df61,0x10a012ad,0x148311ff,0xcf61b490,0x2b7f1fe4,0x223a4a96,0x12c72173,0x048720e7,
0xe26bdd66,0x0a31dd91,0xf7b20985,0xc8dfb828,0x0f83dedd,0x158a1036,0x18be0e5c,0xd0c4bb35,
0x24741cda,0x2c93484f,0x116f1c35,0x07341b21,0xde4dddfe,0x067bec29,0xef700de3,0xbd0ec226,
0x11e7df23,0x18841146,0x15670f92,0xd6f1c319,0x26331264,0x3a574750,0x08a32024,0x09ef10c2,
0xd6c7e0ff,0x0219f7e4,0xe6310d20,0xa8e6d116,0x06c6dd47,0x1c2d1de7,0x09c40dd5,0xde70cdb5,
0x2bfd095c,0x4e85378a,0x0bb21fcc,0x0aa10cb2,0xd586e933,0x0d610214,0xe00906e6,0x9fb2d961,
0x0351d992,0x15f12721,0xff0d0fb4,0xde31da4c,0x2a49fca8,0x58212d36,0x002a2910,0x0ad7fd45,
0xd980ef7c,0x14ee084d,0xe494fd6c,0x9dd2de10,0x0256cd19,0x1f292c2d,0xf54d0b56,0xe084e72d,
0x2f49f3c9,0x5889288b,0xf94e2ff9,0x0242fafa,0xdf98f599,0x1cb6038b,0xeb04f117,0xa762d880,
0xfb9fcab7,0x27f62fdc,0xf1660d81,0xe2b0eeaa,0x2430f31a,0x574b2e8d,0xf704331c,0xf9e6f451,
0xea8b0357,0x20db047d,0xf1ccea0d,0xafffcaca,0xfb09bd73,0x30eb310b,0xf67204fc,0xe2e0f0fb,
0x1b2cf918,0x47073320,0xf7043b6c,0xf665e7ff,0xf95702a0,0x1ae00208,0xf46becd4,0xb107cde3,
0xf148bfec,0x37b22fbf,0xf69104ed,0xe425ef03,0x1ce1f95d,0x462a3ab9,0x0032350a,0xf2cce62f,
0x079e0503,0x0cb602c2,0xf302ed15,0xb374cdc1,0xe3f2c144,0x38a32c46,0xfb210467,0xe543e5fe,
0x1542f9ed,0x402c3b02,0x09dc2bcd,0xf0d7e31a,0x125805d7,0xf8f30d20,0xec14fdfb,0xb5e3d5ae,
0xdbf7c504,0x34fb2b39,0x020e1034,0xe8e8df68,0x1ae4fb39,0x4169328d,0x10d71e10,0xeea7e6ed,
0x1ce60313,0xe7920fe0,0xe993092d,0xb7e8db83,0xd63cc8d7,0x2f6a2544,0x04331b4f,0xe8f6d31a,
0x1de2ffd7,0x3c0e2d6e,0x10221bb1,0xf1faec75,0x206dfc3f,0xdc7c17c5,0xe5a61061,0xbf4fd9f3,
0xd876cb7c,0x2aed1e65,0x000d2d0e,0xebd4d35b,0x1f8800c0,0x31c828e9,0x09fe1cdc,0xf7b4f332,
0x2e2cf4fc,0xdc4715db,0xeaad0769,0xc071db0e,0xdbe4c8fd,0x2770110c,0x036037c6,0xe3c1d015,
0x27c20256,0x3159221b,0x059c1ca9,0xfc52f6dd,0x301cf4fc,0xe1e315c3,0xf714f6a9,0xc7c7dbd0,
0xdd39c39c,0x23bc04e6,0xfe9e4247,0xde46d1c7,0x2be50b68,0x26ad1d57,0x06801cf6,0x0727f81e,
0x28eef34b,0xe7811890,0xfbc6ec69,0xca9ae6aa,0xe75cc355,0x225bf8a0,0x03d740d2,0xd615d1bf,
0x2b1b0bee,0x22a816db,0xfdb922b6,0x0c8bf933,0x18f1019e,0xec0e1813,0x0116df47,0xc8c2ed26,
0xe098c28c,0x2ad6f49e,0x08d336d9,0xd937d0bf,0x25610f28,0x1e5e0eae,0xffec1fe0,0x0c6403cb,
0x0519131b,0xedf6268e,0xfbf9e3aa,0xc251ffe9,0xe2a6c93b,0x25a1f53e,0x11042c60,0xd9bdd243,
0x1e6c0e30,0x1da909d5,0x011219ae,0x08f50698,0xf5d71e1f,0xed062730,0xf8efdf28,0xc1850c3d,
0xdcc7c608,0x298cf6d3,0x1e742444,0xddbece3d,0x16c80850,0x1d4d0a70,0x067b1287,0x0f610acc,
0xedd2228a,0xf6852941,0xfa23d945,0xc63c1572,0xdfcfc551,0x21b5fd54,0x22961cb1,0xddb7d9aa,
0x0da4fd6b,0x1f7a08c1,0x08df0bad,0x0db70bff,0xf3291d8c,0xfdbd234c,0xfee9d46e,0xca891567,
0xe55ebbae,0x1e0d043b,0x1f741a75,0xe3e3e344,0x041dfc94,0x17c70aa5,0x12120357,0x13610d34,
0xfa781840,0x049b1b32,0xff86cffa,0xd9f716f8,0xead9b7c6,0x0fdd087f,0x1f551d9c,0xe598ea37,
0xfd74ee6a,0x14800b0c,0x127906c4,0x14ae0f46,0x0101158a,0x09be1061,0xfd6ecc6d,0xe5c4146b,
0xe727afa6,0x06850dc1,0x18fa24f7,0xeab1f95e,0xf80cea21,0x093505bd,0x15a30a0f,0x118b112f,
0x054f15c4,0x0c910f7c,0xf4ddd42a,0xf2a011ff,0xe0feb105,0xfe9d0cef,0x1dd82454,0xf1f2fc61,
0xfab9dd98,0x06780214,0x17760bbf,0x12171460,0x072f1886,0x086c062e,0xf397e3e3,0xfd270842,
0xdd5bb59c,0x01020ed5,0x20b916ab,0xf8010172,0xf7c2d62c,0xff6df355,0x1e0a10ba,0x0b2119a2,
0x0cfe20c3,0x087f03a8,0xee03f21a,0x037503c6,0xcee8be4a,0x01d80e1f,0x27e810a1,0xf7f204bd,
0xf7a6d429,0xfcdeec03,0x1b250e0b,0xff551921,0x1179253f,0x0924fb78,0xfc49f600,0x05e20309,
0xc9cbce04,0x0c64050b,0x2cab07e1,0xf1740daf,0xf5f6d38c,0xf563e521,0x19020e27,0xfd371e74,
0x165e294e,0x0399f51e,0xfa72fea1,0xff9eff47,0xc648da01,0x14a400e5,0x2b0ffced,0xef1a1e1c,
0xec56d878,0xf7a5e1f0,0x16321056,0xf91f205f,0x18192beb,0x0184f6de,0xfd23fc0f,0xf5670e23,
0xc8f2dde9,0x1a20fb56,0x24bcf927,0xef8923c6,0xe5d7d889,0xeebbe340,0x1aef0f1a,0x00fd1efc,
0x22eb2630,0xfe45f87b,0xfd6cfe0c,0xee371636,0xc2d1e70a,0x18adecc2,0x19ba00d6,0xef3d2cbf,
0xdeb8d94f,0xec14e2ad,0x13df0e43,0x09b81aea,0x28ae1e36,0xfe76fe4d,0x036afe29,0xefad1ebc,
0xcdf9e731,0x15e5ed4f,0x12910371,0xed882e1f,0xd5c3d9e2,0xe551e7c1,0x1982065a,0x134d1462,
0x33d412a5,0xfb37fd48,0x09a0ff94,0xead71d12,0xcd3be4a3,0x1422ec7e,0x0e980ad0,0xffb92c9d,
0xcc0edb64,0xe56ae952,0x16e0fe6d,0x176d0c9b,0x317c0bcc,0xfb2d07fe,0x0e6bfc38,0xf535229d,
0xcc0edfd8,0x0a5cef51,0x0d69075a,0xfeed2890,0xc742e2a6,0xe661f0d9,0x1cd0ff0a,0x16640827,
0x2d8b0f14,0xf97b1275,0x121cfbb7,0xf28e1d81,0xd060db9b,0x0562ef4e,0x10ff071a,0x047f2137,
0xc744db65,0xe5ebeca8,0x1796fa9e,0x13da091d,0x24be1687,0xf8cb1f11,0x160703f7,0xf7221d6f,
0xd300dcc5,0x009eefe5,0x14f40326,0x01b11d58,0xcc2cddf4,0xea02e6e9,0x14d9f6c6,0x0a6b07d2,
0x202c1d35,0xfb421fa2,0x1a530fba,0xfcf0195e,0xde57de02,0xfc86ec0f,0x1116013e,0xff4f2310,
0xd318df76,0xeaa3e1b4,0x0d61f135,0x05ce097e,0x1c021f8d,0xffa8154a,0x1eba1bf3,0xfc0615eb,
0xe33cde83,0xfac1eb61,0x0b54ff49,0xf5c624be,0xd91bddba,0xef70dd35,0x0983f86d,0xfc400d7f,
0x20242178,0xfaf912a9,0x1f882948,0xf9111387,0xed9ce587,0xf5b6e47b,0x05f704d1,0xefc52b78,
0xdf49dcf8,0xed7dd5e5,0x0140f42c,0xfbcb05e4,0x26332027,0xfd8906d9,0x24583685,0xf453108e,
0xf0c3e94f,0xf4c2e4b5,0x030efc96,0xf1e72a83,0xe3bde298,0xf4ced4f7,0x040ff807,0xf7960191,
0x23172590,0x00bcfe26,0x285d3e0d,0xf56909bd,0xf860f376,0xeaf6e50d,0x0063fcd5,0xf195209d,
0xe177e832,0xf0cfd5ed,0x010cfce8,0xfe5cf681,0x1b14274b,0x01f0f9e7,0x280e490f,0xf93004a2,
0xf7fdfaa4,0xebdee826,0xff68f6d0,0xf37b1e13,0xe257e862,0xf158d5ca,0x00a8fde8,0x00f6f15c,
0x1e9f1ef2,0x02a4fc3a,0x2c424924,0xf9db0296,0xfa6e02e2,0xe6f4ee50,0xfe85efa3,0xf9e516e3,
0xe595ee0a,0xf78ecec3,0xfd70fa5f,0x05c8edbf,0x1b2d1cd8,0x0640f991,0x2e3b4570,0x03260189,
0xf4dd03c0,0xe5a4ef73,0x0098e8c6,0xfcfd0dd4,0xe930eeab,0xf818d295,0xfba2fd71,0x0beae8f4,
0x19fc11c3,0x0ae0f792,0x2a2a4573,0x068005ea,0xf8bc0634,0xda48f936,0xfaa3e88a,0x03310a40,
0xe9aaee0e,0xf37fd5ec,0xf7fa0010,0x0869ee88,0x178510b7,0x0ef6fc44,0x26d442d9,0x0c630adf,
0xfd3704f3,0xde0bf9c9,0xf278e391,0xfc6603cb,0xed0ef02f,0xec92e3be,0xf7aefcdf,0x0a06f200,
0x18650bca,0x11dcfee1,0x20a33d38,0x143910e2,0xf9fe0280,0xdf42ff49,0xeb76e27f,0xff5f0227,
0xe8c3f5f6,0xe1aaed37,0xf63ffe07,0x088ef59d,0x152a07e1,0x1b14053b,0x20bc3c49,0x22861424,
0xfb2bfddf,0xddb7fb16,0xe39cdf2f,0xfbf0fa45,0xeec4f574,0xded1f849,0xee33f453,0x0239fcb9,
0x0d8b05e1,0x1a5008b3,0x22363230,0x24821af4,0xfc86028c,0xe48afd01,0xd9b6e7d1,0xef92fc2e,
0xf677f5ab,0xe23dffd4,0xec2fe8cd,0x01ba0305,0x0a6803ed,0x246a07d0,0x20222a4e,0x25281931,
0xfea7079b,0xe56ef879,0xd717e679,0xea09fe68,0xfadbfa6d,0xe8be0301,0xe7d9e288,0xfb8c043b,
0x0d1701fa,0x249b0bca,0x19f82b6e,0x20ab217b,0x02a00ab4,0xeaadf192,0xd254e6a5,0xe752f625,
0x02c0f72c,0xf4c703f1,0xe762ded2,0xfbfb07f1,0x0efefbba,0x2eae0e21,0x150a26f6,0x1cc22776,
0x096b0c27,0xed1aef95,0xcfa8e405,0xdf44f34e,0x05f3f181,0xfff40283,0xe24ad86c,0xff2f0453,
0x0f36fd01,0x352e108b,0x15fd2547,0x16d32ea8,0x0c8f0e10,0xefecf2ee,0xceb3e7f5,0xe319e755,
0x0be7ec2c,0xff930142,0xdccfd913,0xfe5cfe6d,0x0c1cf5d4,0x35f4198e,0x169f283e,0x125e2f29,
0x166f0b5e,0xf077f43d,0xd289e969,0xe643e1ac,0x0c68e5cf,0x01fd0528,0xd44cdeb4,0xff19f295,
0x0a53f3fe,0x349821e5,0x17832c9a,0x12772cf2,0x17ad0a67,0xf004f9e9,0xd2c6e6f4,0xea09d562,
0x07afe2d6,0x0b9506cb,0xd806e293,0xfb6eec92,0x0491f9e9,0x352026b0,0x1c633053,0x09532611,
0x17c107a5,0xf0a801f7,0xdcfbe27f,0xede0cd3b,0x016dddcf,0x11790d82,0xd333e6ae,0xf57adc3b,
0x00cc0236,0x3aa02e65,0x226f30c0,0x03ed2384,0x13910c32,0xf1ee0d7d,0xe0a2db35,0xe9c8ca71,
0xf9efd9ca,0x16e00de7,0xd0caea87,0xf75dd494,0x01250874,0x39e32edf,0x2a703541,0x01261d47,
0x0ce30bc1,0x035a0ef6,0xe1eed7f7,0xdf5bcd78,0xf7d4df38,0x17f70e97,0xce75ed70,0xef9fcdba,
0x097407b7,0x3bf32e78,0x2f153796,0xffd713cb,0x077d0fbe,0x089f0c0e,0xd6ccdebd,0xd7ddd772,
0xf6fce30c,0x17330adb,0xca37f7cc,0xf08bc807,0x1236095d,0x394d2de4,0x322e3d62,0x02f60c64,
0x04fb0afc,0x137800db,0xcd53e1c9,0xce74e117,0xfcb8e25b,0x10d708e3,0xcaf3018c,0xec7dc56a,
0x1a72032d,0x313c2a18,0x2ffe43c8,0x07e70ae0,0x02031278,0x1126fa86,0xcafef284,0xc654e520,
0x051ddc2f,0x08cf072a,0xcf050727,0xf119bedd,0x1865066d,0x289a33a8,0x29a74d40,0x0be6089b,
0xfd701199,0x0adcf5d9,0xd363fb03,0xcc7fe161,0x0624cee3,0x02640724,0xd3fb02ff,0xf262be1b,
0x19a9041f,0x20ab3d2e,0x2c1550d4,0x11a70aab,0xfdd7148c,0x04eef719,0xe100fec6,0xcdcbdc3b,
0x0349c9b3,0x02560cdc,0xdc35f6f6,0xed4abfb1,0x10a00e91,0x1d5c3ab8,0x2de54953,0x13a908a4,
0xf84512cf,0xff83f4c9,0xfa01fafa,0xd08acda5,0xfc9eccfd,0x0290178b,0xdfd9eb4a,0xeb43cd47,
0x0f0512b2,0x20f13929,0x32a939d1,0x14fc0f6f,0xf3d61340,0xfc30f5e6,0x097bf509,0xcc8dcf1c,
0xefffce76,0xffc91958,0xda2fdf27,0xef28db9b,0x120d12f7,0x284c2fda,0x2f703129,0x15061da0,
0xf3281225,0xfb56f001,0x0ee3f084,0xc1f2d9df,0xefddd002,0x04051cf5,0xd5d4d23f,0xf50ded36,
0x18111067,0x30eb1f37,0x33c02834,0x113327b7,0xeee5120d,0xf736f2e2,0x00b5f37a,0xc3e9e7e5,
0xf260cbda,0x03c61a4a,0xceb1cbef,0x03a1fab1,0x21b10bec,0x2e8b18dd,0x325e222a,0x15843450,
0xeedb0fd6,0xed30f323,0xf156fbf2,0xcb7cef5f,0xf09ac045,0x02601351,0xc13dccd1,0x1428f95c,
0x1e280cfe,0x27e71799,0x393c20ef,0x20393872,0xf5e60b6c,0xe7bef436,0xe3410389,0xdeeded1c,
0xf06eb6f9,0xfc9e11ef,0xc13dd0da,0x2132f4da,0x18d511cd,0x1dff150a,0x44131a0f,0x27473397,
0xef3c079e,0xe3a7f8c9,0xe2ea0344,0xebdee217,0xe981b9e4,0xea56197e,0xc493d5cd,0x26a3ed28,
0x15e7193f,0x183d17df,0x4e2b144a,0x29933400,0xf1e708fa,0xe3b4fa53,0xe34b03de,0xf14ed42d,
0xde01c5d0,0xe7281d7e,0xcc08d346,0x218af1d4,0x10272806,0x104219e4,0x51651140,0x260b3ba8,
0xf2d7093f,0xe7b4f635,0xe529fac5,0xee77cc7c,0xd767d7be,0xe41a1b1f,0xd8c7ccb8,0x200af04f,
0x10a62eaa,0x0ab31982,0x4f2e13c1,0x23e841a6,0xf0fb0dd3,0xe810fd00,0xe5f8fb0c,0xde94c8c7,
0xde92e70b,0xe87108b1,0xe3b5c567,0x1dc2edc8,0x17852a59,0x060e115e,0x42f719ed,0x24b846e6,
0xf8da07f6,0xecd3007c,0xe5b0f989,0xd016ca3e,0xee8eefe2,0xeb35fb48,0xe858c034,0x1965f83a,
0x1e6f2525,0x00030c21,0x374323d7,0x2722468c,0xf9b60286,0xe91a00d4,0xe639fb85,0xc979c8c4,
0x00c7f270,0xe4bdef11,0xe8bec4b9,0x1dd3ffa2,0x24c61779,0xff310751,0x364225e5,0x2d203e91,
0xfdf6fdf3,0xe8dc03b2,0xe49dfeae,0xc717cb7b,0x160de6aa,0xdd27ed13,0xe48bcb1b,0x1e6e0ef3,
0x20b110c0,0xfc6b0842,0x355a2e58,0x33c5322e,0xfaddfc3f,0xeaa306ce,0xe4b4fd13,0xc5e0c93a,
0x1f44de36,0xce33f4da,0xe680cf42,0x23b21603,0x15e00e1f,0x068707c9,0x356e31c3,0x2f93291c,
0xfc5a03dd,0xebb50a4f,0xea07fa94,0xcbcdc7c6,0x1d7ad42f,0xc1740010,0xec9ad245,0x2a770fba,
0x0a270f09,0x00ac0a22,0x37af3238,0x29b828b2,0xf8d00d72,0xf2be02f5,0xeb55f77f,0xcc6fc7ed,
0x18d0d1f1,0xba7a0cbd,0xf26eced5,0x2a91143f,0xfc0a1317,0xfde50a4a,0x3d9431de,0x1ff82315,
0xfa721c43,0xfc3efb52,0xee23f47f,0xc75dcd32,0x1270cfa7,0xb922169c,0xfdb9c493,0x28901612,
0xf56d18cb,0x04880133,0x45402ecd,0x12951daa,0x02c62511,0xfe76f292,0xf310f209,0xc457d3f7,
0x09f7d030,0xc1f618c0,0x08dfbd04,0x2155169d,0xf0b22433,0xfff4fb44,0x4a132b26,0x064d1e69,
0x0b082ca2,0x0234ea1e,0xeeb4f453,0xc0c8dcf0,0x06a9d2d7,0xca6e0d7f,0x0c9dbca1,0x1ff51abe,
0xf7b81df2,0x0176f519,0x4b142a4f,0xffca23b5,0x19242c81,0x02acdff9,0xeb32f7c2,0xc13ee441,
0x0252cfb2,0xd197051d,0x0a05bf69,0x1b36250a,0xfefe1aae,0xff6de988,0x480b216d,0xfd7f2248,
0x22d02b17,0xfcf2e09b,0xecbefeb5,0xc654ed32,0xfac5d1aa,0xd72bfda4,0xfcf0c908,0x1d8c2d38,
0x09850d43,0xff1ce54d,0x470c20d7,0xf871268c,0x284824f3,0xf49ceece,0xe6bb0034,0xcd2cebd4,
0xf61cd33b,0xd19df734,0xf76eddad,0x1c953308,0x0fe8fee5,0xf9bbe5f1,0x3a6f1c17,0xfbac2711,
0x2a8d24fb,0xf264f35e,0xee6a00a5,0xd0caefd3,0xef86d6af,0xd8c4ec35,0xf941ea15,0x27202bb9,
0x17c9f44b,0xf7cce6fc,0x2a711d0d,0x0068272b,0x29751f57,0xf157fa37,0xef3df6e4,0xd3c6f501,
0xf151db0d,0xd9c0dfc5,0xfe6bf18f,0x2edf25d4,0x0ff0ef89,0xf021f5b9,0x231821a2,0x04d12bc3,
0x2a7f17fc,0xf6810367,0xef0af3fe,0xdaaaee38,0xebdedbbb,0xe10cd210,0x06c4f677,0x33bb1cf2,
0x00d3f09f,0xf1a3f447,0x16c11cbb,0x0d8f2da8,0x27991326,0xfbc60974,0xee13f1b3,0xd719fb5c,
0xe7cce3a0,0xda6bd10c,0x13f2f9b5,0x33b71257,0xf20afb78,0xf360fabc,0x0f9c18ca,0x1347291e,
0x283b171d,0xff5e0b10,0xe9acf0d3,0xdba9fa36,0xe213e595,0xdd10c96f,0x181b0156,0x30230f83,
0xe92e02c0,0xf46bfbae,0x00001a98,0x00000000,0x00000000,0x00000000,0x00000000,
};
