#include "timpani_samples.h"
const AudioSynthWavetable::sample_data timpani_samples[3] = {
	{
		(int16_t*)sample_0_timpani_timpani, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(0) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(60) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7698 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7695 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7695 - 1) << (32 - 13)) - (((uint32_t)7079 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-12.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(540.24 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(3398.74 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(2353.81 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_timpani_timpani, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(0) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(60) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7698 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7695 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7695 - 1) << (32 - 13)) - (((uint32_t)7079 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-12.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(540.24 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(3198.73 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_timpani_timpani, // sample
		true, // LOOP
		13, // LENGTH_BITS
		(1 << (32 - 13)) * WAVETABLE_CENTS_SHIFT(0) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(60) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)7698 - 1) << (32 - 13), // MAX_PHASE
		((uint32_t)7695 - 1) << (32 - 13), // LOOP_PHASE_END
		(((uint32_t)7695 - 1) << (32 - 13)) - (((uint32_t)7079 - 1) << (32 - 13)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-12.7)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(540.24 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(2599.68 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(918.06 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-100.0)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.4 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_timpani_timpani[3968] = {
0x00000000,0xfff9fff5,0xfff9fff5,0x0004fff5,0x004fffd7,0x010dff91,0x0f21fd95,0x4fbb460b,
0x598a625b,0x40225439,0x1dc43113,0xcebe1dfc,0xa00faa38,0x8dee95d9,0xa37e9a5c,0xc251ae3d,
0xce93bae0,0x0511d76d,0x3eb12a28,0x4c583de2,0x57c249d3,0x71fb4441,0x23dd71fb,0xe630f1b5,
0xe648e7ed,0xeec9ef46,0xcda5dd06,0xb7a1c669,0x8ede8dee,0x8dee8dee,0x8dee8dee,0xc0548ff3,
0x0a45edec,0x71fb5de5,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x63ea65a4,0x1d0f436b,
0xee5d0f5a,0xe57305f9,0xb625c17f,0x8deeaa98,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xc0a68dee,0xfbd5dff8,0x3d3529ab,0x55755d07,0x67ae6ddf,0x71fb71fb,0x4f7e71fb,0x13161b8c,
0x1d472442,0xfa441de7,0xcf52e857,0xd173e353,0xe3c8e00a,0x0295e5f9,0x0f271317,0x2b7b286d,
0x22d1246c,0xa55de909,0xd89caf6a,0x38f2130d,0x53b04e5a,0x3fcc54bc,0x0adb2513,0xf0652688,
0xd155e5e1,0xfba9dd25,0xf8551268,0x9d19b5bf,0x9acea20f,0xad5bb3e4,0xed96daf5,0xf3e2f0de,
0x10511045,0x4bf33ede,0x2b5b3d9b,0x29bb3343,0xffc50b15,0x0027ebe8,0xfec7f3a9,0x10b60585,
0x2b5f16fb,0x11ff1190,0xdf53f16d,0xeca9de8c,0xd533d6a4,0xcb59bbe0,0x0a3cd75a,0x2ffe10b0,
0x51a051c1,0x4d464a90,0x71fb558f,0x4c346c85,0xe693195c,0xc947d26b,0xb29bcfe6,0xd9cfc45b,
0x05d9e1d2,0xf35a17dc,0xe47fe2b5,0x9e06a4c7,0xc216b13e,0x004bdab5,0x14061d0b,0x00cafd35,
0xff13ef19,0x288f131d,0x3ce019c6,0x2b4f3101,0x04c10d54,0xc8fbea58,0xa9669f86,0x8deeb3ed,
0xc2fba7ce,0xf0a8ce3f,0x0d69f6ef,0x41e33da6,0x48ae4ae9,0x5d2c3a27,0x65f8634d,0x4b764493,
0x5810406f,0x4a9b649b,0x4343455f,0x2c0c4275,0xe114030a,0xb1e6cd24,0xc151b261,0xa540ac33,
0x8dee8fcc,0x8dee8dee,0x8dee8dee,0x91fb8dee,0xe178bead,0x15e3f073,0x063211a2,0x20a40606,
0x4ae02a5e,0x662c5d72,0x4da64ee4,0x3b7d34a9,0x29b54196,0x42eb351b,0x491b4bf0,0x599d6206,
0x2c094a20,0xed231a6f,0xcd85ea5b,0xe852d9a6,0xf8adfc73,0x1b280bb1,0x22ad224f,0x1562130a,
0x0ecc125f,0xf0b70311,0xbec9f2c8,0x909eaec4,0x8dee8dee,0x8dee8dee,0xc16f9eb2,0xa6ffb95f,
0xdb97b77b,0xf408db2f,0xf6abfaf8,0x058501cb,0xfbd80c9c,0x0ea10add,0x36792da4,0x67ac4ba2,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4ca36dc4,0x3e9f3f5b,0x067e1bcb,0x085afcfa,0x01461670,
0xe891fff2,0xe74aecef,0xfc92f08b,0xf4d7f80c,0x987dc84c,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xb84c9a36,0xbb70c776,0xc9b5cbaa,0xc9ebd25d,0xfaa7d65b,0x31b420a0,0x36262852,0x3a6e340e,
0x37cd3a0b,0x5a4b49e5,0x71fb6b6a,0x71fb71fb,0x71fb71fb,0x6bf96d27,0x34275100,0x2c1831b4,
0xeb3d2305,0xe341e747,0xd083cb12,0xe01dc9e5,0xea3adc7d,0xcc09dcd0,0xc3c9cab1,0x93e4a51c,
0x8dee8dee,0x8dee8dee,0x9c468dee,0xaef2a646,0xc838b98a,0x1a70ef95,0x11b4ffec,0x28fe19ea,
0x0a971634,0xff680f97,0xff8602d1,0x18930661,0x3bc82224,0x650c6590,0x5b8162af,0x66bf59b8,
0x71fb71fb,0x715f71fb,0x5a586b92,0x282e37d9,0x09631b2b,0x0930fe19,0x05541030,0xf2a0f255,
0xce93eefc,0x943d9f37,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xabd58ecb,
0xf6e2ccf0,0x14d40bb6,0x308c1fd4,0x3cc83642,0x4d1441cb,0x58a454ef,0x54f55933,0x6aab5d25,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4dff6b8e,0x273825fc,0x1d5131ad,0xe9ae0de2,0xcb9ddd3e,
0xc6e9c6dd,0x9e7eab38,0xcb85af2d,0xc1a3bb94,0xad7db412,0x9b3daf10,0x93f193cf,0x900b938e,
0x8dee8f27,0xb6319605,0x17e8f839,0x23232783,0x1f56235e,0xfdc91211,0x0a31f343,0x103f09a2,
0x23d41d97,0x1fcd26b7,0x43003222,0x603e588b,0x6e406635,0x6c526a3b,0x6ee871fb,0x613c68f3,
0x44e551be,0x1c9d290b,0x0b85134a,0x11270d1c,0x09ad1dc6,0xf4bb03c8,0xa06ecc52,0x8dee92a4,
0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xa2ac8dee,0xcb33c27f,0xdbfcd848,0xe91edd0b,
0x19bb024c,0x5a023657,0x627b61be,0x4ac44f22,0x71fb4e69,0x71fb71fb,0x71fb71fb,0x71fb71fb,
0x4bac646a,0x3460374a,0x15141ac5,0xf4c108e7,0xe3b6fd3b,0xdc99dba0,0xae51b249,0xb0cab142,
0xdc46c25a,0xe4b0e258,0xca7ddfcb,0xc81dc1bf,0xc85ed0b7,0x9c7e9bdf,0xa5719cdd,0xbcf2a722,
0xe7a6e365,0xf0c3fc49,0xf5cbf135,0xf9f7fb00,0xef710010,0xff91f2d9,0x054ef957,0x34e02252,
0x53354cae,0x5ad14d72,0x71fb71fb,0x71fb71fb,0x6f3871fb,0x39a058a2,0x29e3309e,0x121f1c60,
0x113b1e47,0x1d881a32,0x0f9a1928,0xfcd4febe,0xc87ce08b,0x8f00a429,0x98c38dee,0x8dee8dee,
0x8e178dee,0x8dee8dee,0x90c88dee,0xc201b78f,0xc9f5c20d,0xf88ae686,0xfb42f39e,0x17da1b73,
0x17ed1155,0x2a750ca7,0x71fb45f3,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4e0871fb,0x28a93e22,
0x0e341dfe,0x18280ebe,0x18301cc3,0x039015b6,0xdb97e75b,0xcb0fd9c7,0xcb33c14c,0xccafcb4f,
0xb0b8cb7a,0xb53eb409,0xafecb29b,0x91d6a409,0xcf3db0ae,0xe1d2ec38,0xdcedd1ca,0xd951e49f,
0xef96e106,0xfa88fb3c,0xea75e9f4,0xfda2f975,0x1a3a0203,0x35f92d77,0x2be02f48,0x4b9a3949,
0x58a151eb,0x71fb6f95,0x650667d0,0x42355a2f,0x40443b7b,0x40d134c8,0x2d564336,0x408939cf,
0x2d9a3875,0xef4106b1,0xc38edeea,0x95d7ab99,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0x8dee8dee,0xc804aa74,0xc589c984,0xe8f4dd31,0x0e73f788,0x01540a20,0x2de20e8f,0x4c283918,
0x67d35439,0x71fb7038,0x71fb71fb,0x71fb71fb,0x6ae471fb,0x2d433cae,0x10ed19eb,0x1c3e1a8e,
0x0a5d1401,0xe8b5fbd8,0xe63be7ac,0x093f02ae,0xdc35facc,0xc536ca7a,0xaab8c1b6,0xa2519cb2,
0xa7a4ad63,0xbdf7ad7f,0xcae8c7cb,0xd885ce7c,0xc219cc6c,0xf091d575,0xf232f7bf,0x099ef61e,
0xe0c5f447,0xe92ae38e,0x0a69f805,0x30071977,0x367133b3,0x64ee4ad7,0x71fb71fb,0x641971fb,
0x414e4b25,0x35e03489,0x374134ff,0x44c13c88,0x3bcf4669,0x31503829,0x16fa31d5,0xe45a02da,
0xcbfdd5b2,0xaa30c075,0x94f799c7,0x8dee8dee,0x8dee8dee,0x943e8dee,0xb4fba87b,0xb038b474,
0xbe6bb283,0xd2e6c6c9,0xff87e844,0x0a1406d0,0x258314c9,0x46db2963,0x4af25722,0x71fb5275,
0x71fb71fb,0x71fb71fb,0x53aa71fb,0x35ce396c,0x2ab23295,0x1eb02bfb,0xf9a80b3f,0xee36ee36,
0xf4a5f487,0xede9fc15,0xdee4e4f9,0xb698ca86,0xbf37bc59,0xb69db8ae,0xcdedb760,0xd733d7d2,
0xb98ac90f,0xd349c196,0xd264ceff,0xdb7cdd82,0xf2b5e40f,0xf686ee56,0xf633f816,0xf169ecdf,
0x0c40fbaa,0x0e940d16,0x30a21e62,0x3fd93ce0,0x6314519c,0x546361a1,0x513a4a63,0x64d15f52,
0x32355255,0x2206225d,0x16212090,0x2bc2229d,0x1b4b291c,0x059e10df,0xeed5059e,0xc3b7d989,
0x8dee9c7e,0x8dee8dee,0x95898dee,0xb1a1a4f8,0xaacba7a6,0xadc5aa68,0xc15ab142,0xd545cf62,
0xe7a0d904,0x0874f0dc,0x1e87151d,0x41592fff,0x4a2543f2,0x5f2954da,0x61266823,0x5f7b5e92,
0x71fb678b,0x592f6f74,0x25c142ce,0x03761141,0xffcbfc45,0x111b0957,0x190820b9,0xe699f7bf,
0xd2d1e2a0,0xc669c88e,0xaf97c3b8,0xc0edb1d2,0xc6febcf2,0xf229e9e2,0xe975e9b3,0xd2b9e13f,
0xb88fc0cb,0xd635c866,0xf8d9eac0,0xddd0ea3d,0xeceae827,0xf7aaef85,0x12570078,0x1c212356,
0x1b471658,0x26162538,0x2d6f2987,0x425f3122,0x525c4c83,0x60055e8f,0x40c559c2,0x34792cc5,
0x461a453d,0x1b8c3816,0xfe9d0a92,0xf5d6f1e0,0x02a30ace,0xe190ef72,0xb9cfcdd0,0x8dee93b8,
0x919992d7,0x9d4192ea,0xba17b0a6,0xb167b97a,0xb606af81,0xbe84be14,0xd530c5cc,0x02e0e7bc,
0x2aba15dd,0x2b263246,0x3f272f39,0x48373db3,0x580b52ee,0x63e45b8a,0x6ac16f06,0x3a8e552a,
0x1e9e264c,0x24e81ed6,0x1f9220d6,0x0afb1682,0x017d0468,0xe8c2fa63,0xe7dce3d8,0xecf8f513,
0xc975d71e,0xafd3b7e2,0xcf6fc276,0xde94d472,0xec44ea02,0xd37edb4a,0xe072dcc9,0xdce2dff7,
0xdd19e21f,0xbb50cbfe,0xcbcbc024,0xf84bdc24,0x116702c5,0x2d6127d3,0x2b5b30dc,0x240f2677,
0x18fb20a0,0x24ca1a9f,0x4f653cc0,0x41cb4bad,0x5d4a4c6d,0x50a861e9,0x37543d77,0x110e2ac1,
0x152d047c,0x20fb27b3,0xfbff0e5e,0xe0dbf390,0xa6d4bbcd,0xa911a405,0xb858b109,0xbe30bf04,
0xb988c035,0x9cb2ab27,0x96c5958b,0xbdeba69d,0xdd77cec4,0xf702e607,0x0ab20256,0x2c4d1632,
0x46433df5,0x53ed4692,0x4c4b5690,0x3df53c75,0x4b944548,0x54e756fe,0x3e0c4681,0x280c33b3,
0x23452400,0x083714ef,0x07930af7,0x04a30565,0xeb51fad6,0xd97cde70,0xd246d2d9,0xd354cce9,
0xdceadc22,0xcb65d743,0xc3e9c397,0xccc6c4d2,0xef84deea,0xe7f4f2e3,0xd610d7e5,0xd728ded1,
0xcefacdc1,0xe820dc15,0xf46cecaf,0x1aac04af,0x1b2820e8,0x24931f19,0x363b2eea,0x275f2c8d,
0x34352bc7,0x41203baa,0x442b463d,0x4e97491e,0x3d744977,0x3a183580,0x1f4a328a,0x108c14ed,
0xf0a7055a,0xeb5bea1b,0xd2dce595,0xa58cb79e,0xa207a039,0xaca4a6af,0xacc1abbf,0xbe40b236,
0xcbe1cc7f,0xc531c4b7,0xc8f9c807,0xd3cace23,0xf3a5e044,0x16a0061c,0x4cb3326d,0x45384e67,
0x54d04b49,0x47314f13,0x40cb4176,0x40154410,0x27e930de,0x38382ae8,0x3f344294,0x2883356d,
0x0c221c8f,0xed29f960,0xe20ce954,0xe488dcea,0xe888e7b5,0xd164e0ce,0xb9b4c228,0xce4ebf72,
0xe571d76d,0xed4df1f5,0xce6cdc2b,0xdc03d3df,0xe906e5bc,0xe5cfead2,0xcc97d669,0xdc7dce63,
0xfcbaedd7,0x080002c6,0x1f1c1582,0x0fd7192b,0x23f712b7,0x377f33d4,0x31013322,0x4af73cac,
0x3d104a01,0x47913bf6,0x47754bff,0x30984204,0x119e1993,0x07590cb8,0x08700777,0xf7bf0492,
0xd4a3e4d2,0xc7cecd00,0xb541bd13,0xb7fcb39b,0xa91fb346,0xadcca73a,0xc3b6b815,0xd998cc11,
0xdc40de8e,0xd8cedbfd,0xe06bd98a,0xfba5ef80,0x15db0768,0x3c052973,0x4ab0456e,0x62ef57c4,
0x4f375cae,0x3cb3453c,0x3f9d3722,0x32fc3fcb,0x1ab525ac,0x05330df9,0x0f4208cf,0x0f7514fd,
0xf5a80474,0xe879eb08,0xd86ce2d4,0xd442d332,0xd8eed47e,0xe3f4dfb8,0xe184e7ab,0xcdeed7e1,
0xce4ecbcf,0xe3c6d579,0xea00eb3d,0xdc34e195,0xdc8cdae0,0xee27e733,0xe5daebb2,0xebc0e330,
0x0787f802,0x298318b1,0x365331e8,0x39443988,0x262f314a,0x18641b15,0x33a62212,0x547148c5,
0x51c35433,0x34724abf,0x0c961b41,0x01f50611,0x07d30660,0x0068017b,0xf06efe32,0xdf89e428,
0xd4b4dd64,0xc04fc699,0xa856b55d,0x9fa7a0fd,0xb6dca861,0xcd8bc393,0xd0ccd3d0,0xd3c7cf43,
0xf571e246,0x09e70107,0x1b0614af,0x28421d76,0x394c34d1,0x326d32e0,0x43a13bb1,0x48ec46bd,
0x5234502a,0x31c7447a,0x1810243a,0x12a2120d,0x0f4e13d2,0x0ace0bbd,0x0370077a,0xf3b5fe97,
0xe75dede0,0xd6faddb1,0xe298dbe2,0xe49fe5a4,0xd830dfa0,0xd3ccd3f4,0xd28ed239,0xd29bd5b2,
0xd25dcf35,0xe48ddaf3,0x0096f46d,0xef40fdf9,0xe667e5b7,0xe8b0e6fb,0x0806f478,0x20491a21,
0x17e91d4e,0x1c4613c9,0x25942709,0x2b9725fa,0x34942fd2,0x338334ed,0x3bdd384a,0x3ccb39a3,
0x39313d65,0x2917344b,0x0b5219b3,0xee91fbb0,0xe780e8e3,0xd837dfac,0xda21d7ad,0xc3ddd376,
0xbb54b9dc,0xbea6bf22,0xc0f4bdcf,0xb41abd3c,0xbc8ab395,0xe1a9cd24,0xf2c7ed68,0x07b1fa6c,
0x16971272,0x1f9c1a66,0x1e961ebd,0x2341232c,0x34ad26e4,0x495141a9,0x432b49bd,0x2e3f3a18,
0x30e129af,0x2e2b34ba,0x20a52414,0x190f1e6b,0xfeff0ca5,0xeccaf9a3,0xce78da18,0xdb19cee3,
0xe260e2a1,0xeb8ce45b,0xe9abed09,0xdee9e38c,0xd54bdab3,0xce85d249,0xd3a6d031,0xe43adb17,
0xf74aeb81,0xf788fcba,0xe8c5ee92,0xf2b5ebac,0x01fcf8cb,0xfc2702a7,0x0951004a,0x1b6111b6,
0x2a8f25fb,0x26ef2b1f,0x2d20265b,0x3c2c3492,0x508046ff,0x425a501a,0x1fd02e4b,0x15a41956,
0x109812c0,0x036c0b94,0xf826fed7,0xdd74eb6e,0xc1eece9d,0xca5fc19c,0xdaced49d,0xdcb9de22,
0xc275d187,0xbb29b94b,0xc21fbec4,0xcf2ac65e,0xd61bd546,0xe747daee,0x0b00f851,0x1ec81883,
0x23a61f96,0x2b0d291a,0x364e2e2b,0x3ce03a4e,0x47744428,0x38244383,0x25fc2b12,0x1efa22ca,
0x282d227f,0x1ba02434,0x10211925,0xf71200e0,0xe01aee72,0xcdced15e,0xcfa7cf10,0xd901d200,
0xed86e2b1,0xfc5ef82b,0xf690fa8d,0xe370ed5f,0xd8e3dceb,0xcd47d44d,0xcf36c8bc,0xde51d9e0,
0xeac4e28f,0xfda9f1d0,0x0f330af0,0x091907e4,0x12911214,0x17291077,0x18281c7d,0x1c34172d,
0x33b62440,0x44b443b1,0x2318339c,0x23be206c,0x2f1d28e6,0x2ea030fa,0x24682c5b,0x01561436,
0xef77f566,0xec5cecf6,0xe8a7eca9,0xdcb0e10b,0xd9bbdbc1,0xc92dd25d,0xb80fbe7e,0xc384bbad,
0xccb5c9e2,0xc265c741,0xd26ec67c,0xee88e318,0xf9c1f2e9,0x161406dc,0x29eb2356,0x26ae2902,
0x2bdf26ae,0x367e3427,0x41c13b57,0x3dde4172,0x27203534,0x175d1a9c,0x1ed91ca0,0x1c901cd4,
0x0e161a10,0xf9e901ba,0xf708f54d,0xfca4fc1e,0xeab4f52e,0xd1c9dff6,0xc33cc406,0xde12ce31,
0xf53cebd2,0xf0a8f425,0xe02feb63,0xd6d9d66b,0xdd7ddc99,0xdfc5dc5f,0xe8ede71d,0xf136e75a,
0x0870000e,0x13840d02,0x1b491af8,0x0f6b15da,0x0d160cd6,0x17bf1244,0x169b1634,0x1a141814,
0x27fd2132,0x34ed2cb2,0x47144120,0x2f453e8a,0x1acb2305,0x0e2a1356,0x0b1f0beb,0x023b0a0e,
0xdb17f0f9,0xc9d6cc05,0xca00ca68,0xd1b3cd38,0xd32dd381,0xcfa2d390,0xc3bfc7d9,0xcbcdc7b8,
0xd261cd61,0xe365dafb,0xef5fe9a7,0x0eedfd0a,0x280c1ef7,0x1ea52580,0x18951a5b,0x27891c48,
0x36c432b9,0x30d53522,0x319c2f88,0x346933c0,0x27672f8f,0x1caf2368,0x09b80fe9,0x0e850ceb,
0x05a30a9a,0xf48efeda,0xd811e68e,0xcf1dcfdf,0xd6c9d292,0xdf40da38,0xe550e2ff,0xe543e629,
0xe26fe2af,0xedeae83f,0xf33ceef7,0xfa90fa11,0xe9c6f30b,0xe7c4e5ed,0xee36ea0c,0xfb28f63e,
0xff81fbc9,0x0a2d045b,0x18ea115a,0x24e520c2,0x1d4721e6,0x1adb1b6a,0x2a621fd9,0x36843451,
0x2a4a309c,0x2b3d2991,0x219d279c,0x16dc1c8b,0x0a301003,0xfcee054e,0xeca0f382,0xe181e590,
0xdd74e16f,0xc7f0d487,0xc49ec12a,0xd4cbccc2,0xdb17d96f,0xe06ade1b,0xd52cdced,0xc9d2cc0e,
0xdac7cffa,0xfc8beacf,0x14130a6d,0x18b21861,0x145c1579,0x2a0d1d9a,0x368d3163,0x3ad63a70,
0x38dd39b5,0x35e937ed,0x2e363237,0x20bd29f2,0x0cdf15e6,0x01a80653,0xf826fe0a,0xe5c3ed8d,
0xe7abe4da,0xe34ce713,0xded2e029,0xe817e1c7,0xef77ec13,0xed20f1c8,0xe008e571,0xe3dadfac,
0xe51ee609,0xe3f9e3a4,0xf03ae936,0xed69efd5,0xf903f1dd,0xfeb6fe32,0x015dfdb5,0x075305fb,
0x0ead09ea,0x12a91225,0x14061207,0x203d197d,0x33d22969,0x30ee3758,0x29302a13,0x21f92a31,
0x0fd115dd,0x08a40c9c,0x0dd807f1,0x107f1372,0x0dd80cd3,0xf8cd07db,0xe720ec13,0xd671e2e1,
0xc3dec87e,0xcde2c83f,0xccdbcebc,0xcd7dcbfe,0xc8b5cd24,0xcdc1c788,0xeab9da0d,0x035ffa2d,
0x0162046c,0x01c2ffd9,0x1c9a0b7d,0x359c2cbd,0x38cf381c,0x365e38cf,0x2ed7328a,0x2415291a,
0x21ad22e6,0x1e7e203d,0x1bae1d2f,0x10761825,0x026a07be,0xf9b5fd5b,0xef12f56d,0xe5f3ea3a,
0xdc6ee051,0xe660de9b,0xf1e9eee5,0xe5c3edcf,0xd3eadb45,0xdc9ed419,0xef1ce862,0xeccbef5f,
0xecbbeb29,0xf174ef0f,0xf709f353,0x08dfffc4,0x0d1c0d5f,0x09570ad5,0x07dc0927,0x04aa0472,
0x02e00502,0x0ce50472,0x173a14f9,0x21a319e0,0x39f92d17,0x429f443b,0x228e34fb,0x0a5e1247,
0x092d0926,0x0d1c0a24,0x01db0a9d,0xf908faf8,0xf951f9f8,0xf37ef6ee,0xd69fe9f0,0xbf60c61b,
0xb95cbc30,0xbad2b8f7,0xcdc2c10d,0xe3d4db37,0xec1be79a,0xfc9ef483,0x02c80107,0x0aa6057c,
0x184d12a5,0x10b315a1,0x14a20f6c,0x28f71e8d,0x32cb307a,0x347d32a8,0x36bc3774,0x284530a8,
0x1ebb21cb,0x115c1984,0x0a270c81,0xffe804e9,0xf26bfb7c,0xdd25e61f,0xd951d94a,0xdf5adb7a,
0xe43be28c,0xe1d0e3c6,0xe946e341,0xf071ee33,0xeefdf04e,0xed16ee3b,0xeb5deac0,0xf94cf08a,
0xfdb8ff50,0xf971f89b,0x03530013,0xfb43ffcf,0x01a2fc31,0x054004e6,0x0b970674,0x0c3f0f9a,
0x09880842,0x1c031091,0x3384294f,0x35a2385b,0x2f1d3130,0x25c02b66,0x1e8d2258,0x06f41555,
0xec47f767,0xeafae971,0xf518ef46,0xf38cf75a,0xe9cbede6,0xe239e584,0xdeeae1d2,0xcb4fd6fd,
0xbd3cc068,0xcc5fc254,0xda10d4f3,0xe65bdf57,0xf758ef95,0x05acfd42,0x150e0f75,0x148815a1,
0x19fa1551,0x2c84222a,0x321c337b,0x2dbd2e4a,0x33802ff5,0x30da34f6,0x220628c2,0x1ac91e4c,
0x0a1e1406,0xf3c7fea5,0xea50ed51,0xe5fce807,0xe393e2ff,0xe990e7bc,0xe126e65b,0xe405df2f,
0xf3d9ec9a,0xf58ff6eb,0xe84ef022,0xe45ae2c4,0xf353ebc6,0xfb0ef8f1,0xf4bdf8bb,0xedc2efd2,
0xfab5f238,0x07f40309,0xfdfb04b1,0x0328fd4f,0x0ca208f0,0x10c50ec5,0x13f51365,0x175f1447,
0x1a5e1a7d,0x21b81c2a,0x295d270a,0x26332939,0x17ed2037,0x04920d54,0x06b70317,0x0fdb0c6f,
0x023b0be2,0xef2ff7ac,0xe842ea8c,0xe39ee529,0xdef3e32b,0xcc6cd6bb,0xc0b1c2ef,0xce68c63e,
0xd69dd560,0xcf10d1fd,0xe491d530,0x02eaf42b,0x1ba1125a,0x1fae1f1b,0x1f0d1f74,0x231b1f99,
0x2d282883,0x2dfc2ed0,0x30ab2e3c,0x281c306a,0x13c11c8f,0x0f0a0eb0,0x161213a5,0x0b6712da,
0xfafb0207,0xf519f752,0xe722efce,0xd9c1df23,0xdba3d8c7,0xeca6e2aa,0xf5d8f3d0,0xedddf3ce,
0xe53de6dc,0xe7cae7af,0xe967e625,0xf5dbf0da,0xfb80f847,0x0196feb5,0x04e10397,0x03c50524,
0xfb23ffc5,0x0181fb09,0x0e0a0a82,0x0095088c,0x01c2fe8e,0x083105bd,0x126c0ba5,0x25411c16,
0x28d229a1,0x25b82764,0x1c9b2133,0x1b471b0f,0x19ba1b35,0x11f816e0,0xff540a0e,0xeeebf568,
0xefc9edd4,0xe71fee9c,0xd170dc92,0xc39ec8fd,0xc999c34c,0xda8ad2ce,0xda60dd6b,0xda24d75f,
0xeb64e0e6,0x00fbf753,0x024c04db,0x0449003d,0x10f90aa7,0x1ff7186c,0x2dc326df,0x37fe3417,
0x340e3846,0x25322da3,0x18a81d22,0x17fc1724,0x1320181f,0x05480b5c,0xff8e0216,0xfde6fd55,
0xf814fe57,0xe232ecd1,0xdbc8dc62,0xdc56dcde,0xd8d0da0a,0xe2ccdbf3,0xef18e936,0xfd49f5fc,
0xff100076,0xfd52fbc6,0x01660218,0xf7ccfae5,0xfaecf988,0xfc31faee,0xfddefddd,0xfeb5fd29,
0xfcdbff97,0xf6fdf944,0xfb08f739,0x1027044e,0x1a1317ed,0x1a0919c0,0x267e1e7e,0x301d2e1d,
0x232a2bdf,0x14791afd,0x111010ec,0x0ab50fc8,0x018904c6,0x001f00fe,0xf727fc1e,0xef0bf3b5,
0xdbb1e605,0xd65ed63e,0xd5dbd704,0xd1f7d3e4,0xcd72d03d,0xd0e4cc73,0xe63cd9bb,0xfe42f4ad,
0x027f015f,0x01cb0291,0x03760195,0x0fea08dc,0x2121175d,0x35c72c5c,0x3bb23acc,0x38f33ac5,
0x30933505,0x23b92b79,0x0ac3188d,0xf25afd0c,0xef34ecf1,0xfe07f794,0xf6bdfc92,0xe99bf0a8,
0xe393e346,0xeb3fe818,0xed63ec42,0xea0ced84,0xe374e5a2,0xe6ffe3b4,0xf94dee77,0x08e0030a,
0x068909b0,0xff5602d5,0xf7eafb40,0xf662f6a7,0xf26bf4ec,0xf4dcf20d,0xff90f9e6,0x06e5041d,
0x0b7b09d2,0x0c020b93,0x08000bd4,0x08d00478,0x1fa21495,0x266c25d2,0x19a12118,0x158b157d,
0x1ba617a4,0x1dde1f28,0x0c28165b,0xfc73028f,0xfe23fc27,0xf8a7fd03,0xef61f3c9,0xdd39e7e6,
0xcb6bd30d,0xc957c82a,0xd0b3cd30,0xd22dd1de,0xd788d381,0xe748de68,0xfe35f27c,0x0718055f,
0x0e730919,0x17d01455,0x21901be0,0x2a91262f,0x2c402d04,0x299529ec,0x2ce82b1f,0x2c312daa,
0x1b7026c3,0xfcb60ba8,0xef8af2e7,0xf587f1ea,0xf468f712,0xe87fed88,0xeec9ea30,0xf47af1bc,
0xf712f79c,0xe818f073,0xe246e2f7,0xe8dee4f9,0xee6beb8a,0xf8d1f379,0xfd18fc7c,0xfb6cfb49,
0x071e003a,0x10580cd9,0x098b101a,0xf13cfd69,0xf1a8ed29,0xf6c9f630,0xfb0ef801,0xff51fcf7,
0x07d40395,0x0f150b8d,0x1869131c,0x19441b9a,0x1af11708,0x2266205c,0x27ba249f,0x1b702510,
0x0ec812d6,0x08e20b7d,0x08fa08f6,0xfefb05af,0xe813f480,0xd4e2dcca,0xd36ed1c3,0xd920d7bb,
0xcefbd4c5,0xca49cb19,0xd8b2cf3f,0xe8abe120,0xf995f160,0x0521ffc3,0x0ea00a7c,0x0c3a0e75,
0x14500d53,0x25f51e47,0x2b31295d,0x28172b40,0x251c24ca,0x299f2859,0x1e892676,0x08b01300,
0x070a0589,0x0107060a,0xf881fbeb,0xeb88f343,0xdf40e3cf,0xe146ded7,0xe64ee3e8,0xef3aea63,
0xf260f1a6,0xf3b9f2c5,0xf561f4ec,0xf88ff658,0xffecfc2f,0x010401c6,0x03cd0113,0x05bb0678,
0xfc79014d,0xf95df9e5,0xf790f8a5,0xf808f76d,0xf737f823,0xfaa1f764,0xfb23fc80,0xff10fb4d,
0x0eb40572,0x23f71a3b,0x29c42965,0x236326fc,0x1f9920e0,0x1b1e1e6c,0x0df1145c,0x0eab0c9c,
0x0a890e96,0xfbe903f7,0xeb29f319,0xe6cce6d6,0xe76ae801,0xdabee334,0xc84ed028,0xcbdbc6e3,
0xdd74d454,0xe6eae418,0xe586e5ed,0xf359e9e7,0x060afdd6,0x0f910b65,0x16671389,0x1b8c18bb,
0x21a71ec6,0x2add24e3,0x37783244,0x316437a5,0x1bf126c3,0x0c0d1301,0x01c006f4,0xfac1fd35,
0xf3eef830,0xf046f0fa,0xebd6eefd,0xe85be955,0xe486e6e5,0xe6e3e455,0xee61ea2e,0xf674f314,
0xfeb0f98a,0x07ac0454,0x04c406f4,0xfea90288,0xf580f951,0xfba7f698,0x0001004b,0xf6f7fb28,
0xf50df5ed,0xf441f356,0x0084f9c1,0x05e60513,0x0004031b,0xfbe9fe5c,0xffd9fb2f,0x106d0882,
0x1adc1664,0x1e9e1d40,0x24262132,0x252b25c9,0x212f23bf,0x11d01b25,0x05bb0995,0x022d04bb,
0xf566fbd4,0xf3aef32c,0xeacff09e,0xddb8e4aa,0xd142d60c,0xd107d0e3,0xcc4ecea5,0xce7ccc11,
0xdee7d478,0xfa53ec91,0x08c903e6,0x0cdc0b00,0x12f20f15,0x1c69183e,0x20f61e4e,0x2a4d25c9,
0x2e862d1f,0x27df2cc4,0x1d6322bd,0x124e179a,0x07300cf7,0x007e02c0,0xf5c9fcf7,0xeb54ee95,
0xecb9eb4c,0xf2e3f01e,0xeed7f1c2,0xebf5ed08,0xec41eb00,0xf2fff054,0xf11cf25e,0xf798f277,
0x041bfebb,0x07be06d3,0x0724079c,0x0553069d,0xfe8702e0,0xef22f739,0xecacea64,0xfdb0f561,
0xfc5eff3d,0xfb53fabc,0xfa22fafe,0xfd1efa76,0x0681018f,0x0b1e09d1,0x0c440bba,0x103f0d4f,
0x1c7c159b,0x291d2393,0x2bb62c6e,0x22fd2731,0x1be7202e,0x0bc41542,0xf3a20038,0xe2f0e88f,
0xe649e3fa,0xe108e517,0xd72edbfa,0xd5bbd439,0xda85d9c8,0xd1cbd5e6,0xd948d350,0xebcbe19e,
0xfbcff577,0x06550044,0x183f0ee4,0x20441e9b,0x1c4c1ec0,0x1be51a40,0x27972221,0x254a27ba,
0x221e23cc,0x18a51deb,0x11301450,0x086d0de6,0xf8130076,0xf083f2b9,0xf244f0bf,0xf0ccf30b,
0xe884ec76,0xe51be5ba,0xea19e726,0xf136ed0b,0xfbb4f6eb,0xfea0fda7,0x035500ef,0x03340386,
0x05fb0435,0x04b5062c,0x01fd02ae,0x01c6024c,0xf7d1fe1a,0xedc6f1c7,0xe850eaa8,0xed8fe895,
0xfe2ff670,0xff7400cd,0xfed7fe1d,0x078601c4,0x16860f30,0x1b771ab9,0x184a19b6,0x1ab118fa,
0x1ec71c8b,0x226420e2,0x208d22b8,0x12ae1b29,0x017d08d7,0xfc30fe5c,0xeed0f737,0xda7fe509,
0xca49d070,0xd3b3cbe0,0xe184dc74,0xdef0e1ba,0xdabfdbf3,0xe2aedcab,0xf232eac2,0xfeb5f8b9,
0x093f0497,0x0def0bab,0x1c4513c5,0x286a233d,0x2d152c17,0x26fd2b2f,0x1d1821c1,0x1c211b73,
0x16141b16,0x06ef0ece,0xf7acfee0,0xf1d4f37b,0xf13af15a,0xf05af131,0xeb7bee16,0xea08e9fc,
0xee9febd2,0xf343f17d,0xf42cf3b0,0xfba1f6f9,0x04a10034,0x0ce208ff,0x0b5a0e08,0x03860737,
0xfd280050,0xf694f9f1,0xf43cf4bb,0xf0c3f2da,0xf437f0d9,0xf86ff7f5,0xf5eef6ee,0xf460f551,
0xf574f367,0x05affc21,0x16580f3f,0x175f18e1,0x159e1598,0x1a211732,0x247b1f0f,0x22d1265b,
0x16de1cd8,0x0fcb128a,0x0cf10e76,0x09b70b3d,0x00f40713,0xe488f4b7,0xd177d758,0xd834d2d2,
0xd95fdbaa,0xcc41d2bb,0xcd23c989,0xe3a3d6e3,0xf8b8ef61,0x01baff04,0x03860272,0x0bdc069c,
0x185d11fb,0x23681ee8,0x237f245a,0x22ff22f8,0x22c022dd,0x22a222e1,0x1d6a2147,0x06c714cb,
0xf1a1f901,0xf168f0b0,0xf43af20f,0xf808f758,0xf1fef56e,0xec41eefa,0xec96ead8,0xf57df0cb,
0xf8c2f889,0xf76df788,0xfdd5f9bb,0x0597024d,0x067706b5,0x07cc067a,0x09850936,0x00ac06ec,
0xf47af96c,0xef6bf1b6,0xeb5becd1,0xef2eec4a,0xf5f6f282,0xfc4ef9d6,0xfa0afbe5,0xfb6df9ac,
0x0189fe7b,0x09130490,0x1a5510c7,0x25ec222a,0x24a8264f,0x21082288,0x1cb61f72,0x172019ae,
0x100613f8,0x08520bdc,0xff8704b5,0xee8cf808,0xdc86e483,0xd9f2d8dc,0xdd07dcab,0xd1cbd8f8,
0xc9aacadf,0xdb89d05b,0xed68e641,0xf420f0ff,0x0376fa4b,0x15e70dd1,0x1a3319d4,0x1bf51a84,
0x1c821ce4,0x19d31b3c,0x1b1a1977,0x20241e1c,0x1e322029,0x14b01aa2,0x04d30cc4,0xfa3bfef3,
0xf1c2f5b0,0xec69eeea,0xe8f0ea2b,0xedb9ea1a,0xf3b0f136,0xf9a0f621,0xfca5fca1,0xf6d7f9da,
0xf806f5a5,0x0355fdcf,0x07f90674,0x0ac8099e,0x0a1a0b13,0x034f073a,0xf9ecff4b,0xf016f393,
0xf16df098,0xec0aef18,0xede6ebd3,0xf098efa2,0xf4acf204,0xfc4ef871,0x04cb000e,0x0f0c0a4e,
0x14071234,0x17df1592,0x1cdd1a82,0x252b1fa2,0x2e692c04,0x1e3628f9,0x0a391256,0x077e0755,
0x033406f5,0xf41ffc1d,0xe75ced6d,0xddc0e1af,0xddbddd08,0xdae0dd67,0xd2add676,0xd616d23a,
0xe46fdd21,0xeec0e9d8,0xf9a0f42f,0x03b8fe94,0x0f55093f,0x1d5515dd,0x2cb225f5,0x268d2d09,
0x17da1de7,0x16db15cf,0x1a411944,0x12811826,0x025e0a9e,0xfb3cfc83,0x01ebfe8d,0xfc64018f,
0xeb26f463,0xe048e388,0xe995e299,0xf93bf29a,0xf9c8fb16,0xfd6cf9d1,0x05650258,0x05dc05c8,
0x05c1064a,0x02a203b5,0x050f03d1,0x019903c5,0xfee70044,0xf93bfc7d,0xefeef489,0xedecede6,
0xeb30ece0,0xecb9eacf,0xf3caf012,0xf7eff646,0xff63fab3,0x08360417,0x0f270bc3,0x17141272,
0x23391d30,0x27fd270f,0x1f86256f,0x142018d1,0x14cc12d3,0x19d918b5,0x0cb215d4,0xf50800ea,
0xe891ec66,0xe90be863,0xe221e7c7,0xd0b7d926,0xcf5acd58,0xdb5cd4d9,0xe5c4e13a,0xea43e86c,
0xf121ecb5,0x0066f82f,0x0df007e2,0x17ed1332,0x1e6b1bcb,0x1efa1f43,0x1e791e79,0x21131f4a,
0x239a233f,0x13801ed3,0xfb3005a3,0xf88df72b,0xff74fc31,0xfa92ff38,0xeefdf3d3,0xf09eee23,
0xf66af3f0,0xf5abf718,0xf18af344,0xf18cf0c2,0xfcb6f58b,0x093d0400,0x0e760c62,0x0e620f3f,
0x08940bfd,0xff130405,0xf69efa4c,0xf449f4c1,0xf443f47a,0xf1dbf337,0xeffaf0cf,0xedbfeea1,
0xf32eef5e,0xf72cf667,0xf7a1f6cc,0xfe1dfa15,0x081502df,0x11640cfd,0x1c391619,0x29b023ed,
0x27852a67,0x22112468,0x1d3b1fd9,0x12e519b3,0x00d00972,0xf823faee,0xf928f811,0xf3bdf863,
0xe346ec34,0xd360da50,0xd2add099,0xdceed7c0,0xe12de011,0xe2a0e166,0xee3ce687,0x0026f7f3,
0x086c0558,0x0d840ad1,0x17431190,0x1f991cbf,0x1eb01fa5,0x1e9f1e29,0x1f4d1f78,0x18031d03,
0x0a361117,0x02700576,0xfbcefffe,0xefbcf5e4,0xec9bec1b,0xf650f0f1,0xf733f8d3,0xf1a9f392,
0xfa02f456,0x00ddfee7,0xfbfcff75,0xfa63f95f,0x02aafe60,0x099b066b,0x0bd70b7d,0x0a550b6d,
0x049207cc,0xfcc300df,0xf2c9f7b0,0xe618eca3,0xe296e1bb,0xeea4e7e6,0xf7adf463,0xf71bf840,
0xf7dff67f,0xff69fb51,0x05730324,0x095406ef,0x15870e6a,0x20491c33,0x236d2224,0x251c24b8,
0x238b24b8,0x1b3520c9,0x0b60139e,0xfe8e03e6,0xfa49fc15,0xedb8f5b0,0xdf4ee4fa,0xe18dde71,
0xe434e478,0xdb87e084,0xd6f4d7ba,0xddd6d960,0xe95ee321,0xf7ddf0a9,0x04fefe6c,0x10600b23,
0x16bf145c,0x185717d2,0x17691830,0x1b6a1823,0x21d71fe0,0x1ac01ffb,0x0d8313f0,0x05e50913,
0xffc502fc,0xf5edfb37,0xef8cf119,0xf2ecf0e8,0xf145f302,0xf1edf012,0xfb42f658,0x0087ff05,
0xfce8ffb5,0xfc97fb18,0x065c00cb,0x0e210b73,0x08700ca8,0xff990340,0xff81fe31,0x01fe015b,
0xfc2e001a,0xf1c6f700,0xe77cec56,0xe722e586,0xed0dea7d,0xf0c2eecc,0xf80df3d3,0x0019fc9b,
0x04c8025a,0x0c620867,0x11040f27,0x148b12b1,0x197d16b9,0x24651e68,0x27c0282a,0x1fe2246e,
0x14641a95,0x085a0dde,0xfebc03b5,0xf285f8d0,0xe4a9ebb2,0xda29de1f,0xda23d929,0xddfedbee,
0xe391e0ab,0xe7d3e611,0xe9bde91b,0xed8feab0,0xf938f2c8,0x0680ffdd,0x11330c9c,0x14fd13a4,
0x1a16170d,0x1df21ca3,0x1e8d1e9e,0x18831caf,0x0e2812e5,0x0bf00be8,0x08430bb6,0xf92f0178,
0xee6ef220,0xf176eeb0,0xf27cf31a,0xf14af0e0,0xf9f7f4d0,0xfe53fd98,0xfda9fd83,0x0195ff42,
0x050f03a1,0x05c605af,0x074a0611,0x08e40899,0x06370849,0xffa90305,0xf823fc4c,0xf0dcf3a5,
0xefa2f02b,0xe9f3ed48,0xeb83e8bc,0xf393f025,0xf399f4a5,0xf169f1d4,0xfac5f45a,0x0c22030e,
0x18691412,0x181618d3,0x1ab818cc,0x1f2c1cf9,0x217920f9,0x1b9a1fb7,0x11481655,0x0d210df7,
0x0ada0d16,0xfdf90576,0xed1df594,0xe096e5d1,0xdd0fdded,0xdededdbf,0xde1edf0e,0xdcf9dce2,
0xe32aded2,0xf2e8e9ee,0x0385fc46,0x05a5069c,0x03d103d5,0x0a6f062c,0x15620fa3,0x1dd91a8a,
0x1a841d97,0x17021788,0x188d1810,0x14181777,0x06e80e44,0xf8a6ff4a,0xf342f480,0xf4c6f3fb,
0xf2acf47a,0xee69eff4,0xf5eaf071,0x012ffc97,0xffa301df,0xfdb0fd44,0x043500e8,0x05e70594,
0x0a49073a,0x0df40d58,0x05560ad7,0xfd5e0050,0xfb49fbf9,0xf7aafa3a,0xececf2d0,0xe4e7e7ef,
0xe832e4cf,0xf424ee51,0xf774f737,0xf600f64f,0xfe67f8ad,0x081c0492,0x07130838,0x09510727,
0x139e0d58,0x23f11bb0,0x2c242a46,0x217f28db,0x10bf1883,0x0adb0c2b,0x0bff0ba2,0x04470a0b,
0xf226fb79,0xe793eb3a,0xe600e64e,0xe306e52d,0xdc5edfc4,0xd9c1d9f5,0xe05adc13,0xed4ae636,
0xf98bf46e,0xfda1fc11,0x05900082,0x14250c83,0x1ba619eb,0x140018e6,0x0e150fa0,0x112a0f2a,
0x15931313,0x15ea173a,0x0cc11165,0x074a09bf,0xfd6a034a,0xf1cff6f9,0xeb67eddf,0xec7aead3,
0xf62df07a,0x0086fc39,0x01bb0250,0xfedafff5,0x0478004d,0x0b2008f2,0x068a09f3,0x008f02e3,
0x00ccfff5,0x05350317,0x049905d7,0xfbb70151,0xee7cf4b6,0xe897ea64,0xec11e938,0xf02eef06,
0xef4ceff4,0xf0c7ef34,0xfb83f55a,0x04e900f4,0x076f0709,0x09940787,0x12fe0e0e,0x1bbf17aa,
0x20241ee0,0x1fb6200d,0x1ee01f72,0x19661d1d,0x0c7c135b,0x0066063b,0xf4c3fa6e,0xeb58efc6,
0xe6a5e80d,0xe774e6fb,0xe585e732,0xdf32e26c,0xdfd2ddd5,0xe918e46d,0xeff8ecb2,0xf763f3aa,
0x0159fb9c,0x0e53085c,0x15541253,0x183e179a,0x15f91708,0x14d415c4,0x0e21120d,0x0a0e0b6d,
0x07e20930,0x064306d1,0x05f70667,0x01380435,0xf9b2fd80,0xf335f664,0xeef3f072,0xf1b6ef67,
0xf7ccf4c6,0xfeddfb27,0x046c021a,0x08b7066c,0x0ad70a8f,0x092f0a0c,0x07550886,0x020f04ff,
0xff320002,0xfc77fe54,0xf5c2f960,0xedecf1a3,0xeaa2eb9a,0xea9bea77,0xeb12eab4,0xf034ec69,
0xfb8ef5c4,0x03bc0039,0x05db057e,0x078b062c,0x0e530a49,0x188313a4,0x1d4c1baa,0x1f321e73,
0x1d101f04,0x15aa198e,0x0f481231,0x097b0c66,0x00fd0629,0xf15df972,0xe690eac0,0xe5dce4e7,
0xe6d9e741,0xe2f1e4ba,0xe37fe284,0xea03e605,0xf1faee8a,0xf472f3be,0xf69ef540,0xfe4ef965,
0x0dfd0594,0x1a6f1548,0x1a831c30,0x127b1670,0x11241098,0x12f2125b,0x0fc5124d,0x03950a83,
0xfad4fdaa,0xfcf4fb37,0xfeb2fe7a,0xfa8dfd1d,0xf5dbf7fc,0xf577f4d0,0xf9ccf7cc,0xf910fa05,
0xfb8ef91a,0x0448ffcb,0x0bd70882,0x0e650e03,0x0a940d10,0x05210799,0x012f0331,0xfbbafed5,
0xf3a9f816,0xeca6ef90,0xebb2eb83,0xee33ecc7,0xf054ef96,0xf04ff058,0xf571f1d4,0xff79fa90,
0x03e302b0,0x054d0438,0x09f90735,0x12190dbb,0x19e81656,0x1da31c70,0x1ad31cd1,0x18121911,
0x16fd17d3,0x0eea1424,0x004b07db,0xf3a9f91f,0xf118f125,0xf1acf220,0xe8e4ee56,0xdf80e35a,
0xe096de62,0xe781e45b,0xec4be9b1,0xf215ef1c,0xf8cdf513,0x009cfcc0,0x07f4043f,0x0ef60bc6,
0x121c10b5,0x16bd1442,0x18321832,0x146e170a,0x0bab106c,0x04c207ac,0xff870251,0xfc00fd33,
0xfb11fbb0,0xf764f95f,0xf76bf65e,0xfe59fa77,0x01f50129,0xfe4e00ba,0xfb37fbd8,0xff38fc97,
0x01b9011b,0x019f017f,0x050d02f3,0x0a1707d0,0x09fb0b1a,0x034f071e,0xfc27ff8b,0xf40ef863,
0xeccbefc3,0xe94aeabe,0xe8efe895,0xebdee9f4,0xf52eef7d,0x00fefba3,0x03aa03bc,0x01b50222,
0x07d403c5,0x0ee60c13,0x11201030,0x161212fe,0x1d3919ea,0x1e341ec4,0x19df1c66,0x128a16dc,
0x06470cf1,0xfb2c003e,0xf3aef72f,0xed79f093,0xe78eea52,0xe4aae595,0xe75be534,0xebebea34,
0xea4beb92,0xeb59e9a1,0xf526ef7d,0xff63facc,0x058e02c2,0x0b740855,0x11090e96,0x11d6121d,
0x108b1141,0x0cfa0f28,0x0b8a0b5e,0x0df20cf4,0x0c200db8,0x024c0831,0xf9bffce7,0xf92cf8f5,
0xfb24fa11,0xf9a7fb24,0xf6a1f7d2,0xf9f0f742,0x0291fe60,0x057c0519,0x032a04d3,0x000a010f,
0x04170127,0x05db0629,0x01f103da,0x00c600eb,0x023b012f,0x005d025d,0xf74ffc65,0xee16f277,
0xe7edeaad,0xe6a9e673,0xec1ce8bc,0xf45af00e,0xfcc9f878,0x0613014d,0x0dd30a32,0x13351130,
0x112912f4,0x10700fe0,0x158f12a5,0x1984181a,0x185c1974,0x13c4168d,0x0bb9100e,0x02bf072e,
0xfa78fe90,0xf1e6f64f,0xebdaee25,0xe9b1ea7d,0xe84ee8e3,0xe7b2e7b7,0xebc6e912,0xf197eee5,
0xf4dcf39a,0xf48df4f1,0xf800f510,0x03ccfd4c,0x0edf0a0e,0x13951225,0x121d1325,0x11ce11ad,
0x104c1147,0x0cea0f0e,0x05a50995,0x01e702f3,0x00fe01b5,0xff04ffef,0xfca9fe79,0xf650f977,
0xf558f4be,0xfb11f7b3,0x0078fe42,0x01950176,0x001600b2,0x04e9012d,0x0c840952,0x0a920cea,
0xff8d057e,0xf9a9fafb,0xfd09fb35,0xfcc3fda2,0xf8fffb37,0xf47af66a,0xf2e3f392,0xf086f1c2,
0xee04ef4d,0xed9aed28,0xf260ef83,0xfd03f6e6,0x091103a7,0x0e2c0c53,0x119e0fde,0x15c913ab,
0x185c1775,0x155417a4,0x0fba123b,0x0ef40ede,0x0eff0f52,0x0a760d72,0x0234066e,0xfb2ffe53,
0xf508f86a,0xec31f093,0xe75ae8f7,0xe72ce6e0,0xe859e7c4,0xeb44e96b,0xef47ed6d,0xf307f0e6,
0xfb53f676,0x058b00ba,0x0ac008c8,0x0d160c0e,0x0e4e0dd6,0x0fec0f1e,0x107f109a,0x0dab0f5f,
0x09e70bf6,0x02f60699,0xffd4008f,0xfe1eff54,0xfc39fcab,0xfe39fd05,0xfd06fe47,0xfaf3fb8f,
0xfb8efb21,0xfdcffc70,0x00caff8e,0x03aa021b,0x074c05b8,0x06ae07a3,0x033a04e6,0x01b1024d,
0xfe91008d,0xf9f7fc52,0xf5f5f782,0xf58ff5ad,0xf3b7f4a9,0xf535f401,0xf679f614,0xf6c9f6c9,
0xf34bf556,0xf22cf1c6,0xf9f0f4bf,0x04a9ffec,0x0907076f,0x0fd70bb8,0x1a7c153d,0x20bb1ee2,
0x1b341f61,0x117715f2,0x0bc30e2f,0x06870920,0x018603de,0xfcc9ff26,0xf753fa38,0xf266f478,
0xeffaf12a,0xebecee3c,0xe8b7e9e7,0xe918e86e,0xee32ead5,0xf4dcf1f5,0xf6eff627,0xfc70f8d1,
0x04c700c1,0x0b490822,0x10ea0e41,0x104611c1,0x0a3f0d06,0x097208ed,0x0b5e0aa5,0x088d0ab9,
0x023b0551,0x01fe0104,0x03f303ba,0xfe5001c0,0xf8a5fb09,0xf89df7b8,0x0002fbd8,0x021402b9,
0xfa4cfe69,0xfa65f893,0x0317fea0,0x093906fd,0x087909bc,0x02fd0607,0xfdf9001c,0xfdd4fd3b,
0xffa0ff14,0xf9a6fdd6,0xefc3f458,0xee11ed4a,0xf51bf160,0xf5bff6a5,0xf331f406,0xf630f400,
0xfde2f9af,0x04e6020d,0x04210585,0x02ea0270,0x0eb90717,0x1d1616f6,0x1ec61f7b,0x181f1bd1,
0x12c714f4,0x0d4c1088,0x039808c8,0xf8ddfe59,0xf206f468,0xf3d0f238,0xf6dbf5d7,0xf3dcf64b,
0xeec3f0cf,0xef2fee6e,0xf07ef037,0xed9def83,0xecbfec36,0xf359ef25,0xff47f8b5,0x0a8305d7,
0x0bc40c31,0x0ae40ac0,0x0f550c76,0x13e0123b,0x0e151290,0x03a3084f,0x01290170,0x03a40230,
0x054804f3,0x0116040f,0xfa4bfd3a,0xfb9cf9c4,0xfefbfe0c,0xfb30fdde,0xf782f87e,0xfe31f975,
0x07c7039b,0x0830092b,0x03ef0605,0x025802ba,0x02df028c,0x016202d1,0xfb9cfeb8,0xf62df8d8,
0xf320f42b,0xf457f35c,0xf64ff576,0xf4bef626,0xf1faf320,0xf600f2f0,0xfe3dfa57,0x024000c1,
0x033a02d2,0x055803bc,0x0bdc0830,0x10bf0f0c,0x109110fb,0x12ab10f9,0x170a1530,0x16621780,
0x0fb913c2,0x05bb0a97,0xfd52018d,0xf3d3f896,0xee96f04f,0xed9cedf1,0xed54ed83,0xef3eedd5,
0xf400f193,0xf55bf53e,0xf2b5f456,0xf12bf155,0xf42bf222,0xfc6ef792,0x06f401f5,0x0c720a5c,
0x113c0e9a,0x14b713c9,0x0f8c1329,0x07a50b28,0x055405c8,0x045d0526,0x00060280,0xfc28fdb7,
0xfbcffb7d,0x0094fd80,0x05a10408,0xff9703b1,0xf948fb58,0xfc25f9c8,0x006efeca,0xffa90050,
0x01d4ffc9,0x072404ec,0x044906db,0xff320158,0xfc24fdb7,0xf95ffa92,0xf8ddf8e1,0xf8bff8dd,
0xf7fdf881,0xf589f6d9,0xf2eef40e,0xf3d9f2a9,0xf9e8f680,0xfe05fcca,0xfd86fdd2,0x01e7feec,
0x096f05e7,0x0d900c13,0x10450ecc,0x146d1259,0x160f15ed,0x11591460,0x0cfb0e78,0x0c200ca5,
0x06aa0a24,0xfd99025f,0xf4cff8d8,0xef9bf1db,0xeb58ed8a,0xe7fee946,0xea0ce802,0xf279edea,
0xf870f632,0xf9caf984,0xfb71fa54,0xfdc7fcfa,0xfe42fdfc,0x00f4ff56,0x04380271,0x0a6f06ca,
0x11760e4d,0x12a31319,0x0ca6102e,0x080009bf,0x053b06e2,0xfffd02d1,0xfc40fd95,0xfcb4fc1c,
0xff14fdda,0xffc3ffdd,0xfdbefeb5,0xfe98fdc3,0xfe84ff07,0xfd33fd84,0xfffbfe30,0x0236018e,
0x013801e0,0x01df0127,0x056c03b3,0x012d04ee,0xf764fbd5,0xf5dff587,0xf956f7aa,0xf965fa15,
0xf4a8f77c,0xf1f8f262,0xf59bf367,0xf98df7c1,0xfd73fb53,0x01b8ff75,0x0743044e,0x0cfa0a5d,
0x10c70f22,0x1185117a,0x107c1111,0x0f710fcf,0x0fb00f85,0x0db40f4d,0x070c0ad7,0x0074035b,
0xfd13fe98,0xf8a5fb55,0xf269f599,0xed23ef8c,0xeb52ebad,0xed0bebdf,0xeef8ee01,0xf0a8efb4,
0xf6e2f2d7,0x008ffc09,0x039a0327,0x02de0303,0x04b3039c,0x04e50507,0x0649050f,0x09bc07f9,
0x0dbd0ba6,0x10b50fa9,0x0f8510c8,0x09290cdf,0x002c04b1,0xf9b8fc55,0xf82df88a,0xf981f896,
0xfc60fb04,0xfd1dfd1c,0xfe34fd29,0x013dffc2,0x042c02e8,0x03530473,0x0056014d,0x00fd0071,
0x001f00e2,0xfcfefed5,0xf9dafb4c,0xfb4ef9db,0xfda2fd1e,0xf935fc45,0xf24df55a,0xf387f193,
0xf9f0f6d2,0xfb4afb97,0xf881f9cd,0xfbb3f910,0x0336ff7e,0x085e0637,0x0c160a4b,0x0f3c0df1,
0x0ff00ff3,0x0fd80fdb,0x0f880fde,0x0d100e95,0x09700b56,0x061c07ae,0x039e04e1,0xfee901ac,
0xf6a1fafc,0xef5ff26d,0xed54edcd,0xecdeed3b,0xea80ebcd,0xec72ea58,0xf3d9f00e,0xf815f65d,
0xfc4ef9b8,0x0403ffa9,0x0b650839,0x0ca70cf1,0x08b20b04,0x062f06b7,0x07ee06f1,0x095008d7,
0x08860948,0x078d079f,0x0a3908b2,0x09fb0afb,0x024706de,0xf80dfce1,0xf506f550,0xf8dff68e,
0xfca5fb2a,0xfe11fd8c,0x000efeca,0x043301ed,0x062905d4,0x036704ff,0xffbe0195,0xfb6cfd78,
0xfa2bfa54,0xfad6fa83,0xfb35faf9,0xfc5bfbae,0xfd6ffcfa,0xfce0fd7c,0xf8b1fb28,0xf33bf5c6,
0xf2d1f20c,0xf95af587,0x008dfd8f,0x0358027c,0x07b104e4,0x0ef10b70,0x1191110e,0x103a10f2,
0x0f9a0fc5,0x0ebf0f4c,0x0d3e0df9,0x0a360c0e,0x03bf071e,0xfe8200bd,0xfaa1fca7,0xf5edf871,
0xf086f32e,0xebf9ee20,0xeb03eab9,0xef3aeccc,0xf1bcf10f,0xf18af1aa,0xf602f2b9,0x01d4fb9e,
0x08870693,0x06e0082b,0x075f0654,0x0bc10999,0x0c810ce6,0x097a0b26,0x069e07c1,0x056105da,
0x063e0572,0x07ee077a,0x04cb06de,0x022802fd,0x017801eb,0xfdc90028,0xf6abfa7b,0xf17ff34b,
0xf4b1f1ea,0xfe39f947,0x05b80288,0x06ef0738,0x0458058b,0x03e603eb,0x01f10367,0xfd3dffe9,
0xf76afa47,0xf55cf586,0xf951f6f5,0xfc5efb6d,0xfaa8fc11,0xf89ff938,0xf9f5f90a,0xfa6ffa9e,
0xf7b9f956,0xf8aff702,0x031afd0c,0x0e080944,0x11b410de,0x110e1164,0x10ec1105,0x0ed1102e,
0x0b820d40,0x083809bc,0x06920718,0x04f8060a,0xffec02c8,0xf920fc9e,0xf28df5b4,0xeeeaf03a,
0xee85ee72,0xef4feed7,0xef0aef6a,0xeeb4ee7c,0xf39af079,0xfb35f76f,0x0057fe26,0x032101e9,
0x07d3050b,0x0d690ae6,0x0f4b0ed3,0x0d890eb9,0x0a0e0bba,0x08c8090e,0x08e608df,0x066e081d,
0x01ba0424,0xfe1affac,0xfe60fdbc,0xff22ff1f,0xfde6fe97,0xfc78fd67,0xf8edfabf,0xf7d1f7c8,
0xfabff8df,0xff7cfd33,0x03360186,0x062504a1,0x07610731,0x03550605,0xfd4e0019,0xfa24fb5e,
0xf78ef901,0xf659f69b,0xf75cf6cc,0xf8bbf808,0xf9dff94b,0xfc06fab8,0xfe3dfd46,0xfe99fea3,
0xfe8bfe7a,0x0086ff19,0x05c102b4,0x0cab092d,0x11b40f83,0x133e130b,0x10cc125c,0x0ddd0f70,
0x09320bb6,0x052b070a,0x01af0376,0xfd6affd7,0xf7d8fac0,0xf24df508,0xeebaf00b,0xede5ee1c,
0xecd3ed5a,0xecbbec84,0xf0a5edfa,0xf7fcf460,0xfc40faa5,0x0002fdd5,0x06770333,0x0b310949,
0x0cfd0c44,0x0f330e0a,0x0f350ff6,0x0abb0d38,0x079208a5,0x065006f8,0x027d04da,0xfdb8ffe3,
0xfcf9fcb9,0x0034fe53,0x00a00122,0xfba5fe67,0xf85ff975,0xfaf1f8e6,0xffe2fde0,0xfe48fff9,
0xfa38fbcc,0xfc5efa5f,0x0200ff47,0x05a30452,0x057f0619,0x02cd0445,0xff8d0127,0xfbd8fdb0,
0xf73ef9ae,0xf350f4e9,0xf2f4f294,0xf6bdf456,0xfc98f9b2,0xfed0fe72,0xfe17fe48,0x0172ff10,
0x081304e5,0x0aad0a31,0x09140a12,0x095408ac,0x0ed30b88,0x14731222,0x133714e5,0x0bbd0fc8,
0x060c0855,0x00e603da,0xf7dbfcb4,0xef85f329,0xed39ed78,0xf00bee6e,0xf130f13a,0xeed5f025,
0xef04ee48,0xf4fbf17d,0xfafef887,0xfce4fc34,0xfff9fdf9,0x05f802c5,0x0c380957,0x0ee70e34,
0x0e230eba,0x0ca60d5f,0x0cc40c62,0x0ce80d4c,0x06d50ac4,0xfe3101fe,0xfcabfc58,0xfea2fdce,
0xfce1fe2c,0xf960fb11,0xf8cdf87d,0xfc64fa4b,0xfebbfe14,0xfd44fe55,0xfc03fc28,0x0002fd80,
0x03a4027d,0x01a20316,0xff1d0013,0xff41fea5,0x02ba007d,0x063204ec,0x01b40526,0xf78ffcd3,
0xf14af377,0xf1ccf106,0xf42bf2d5,0xf670f55a,0xfa49f7ea,0x0264fddd,0x0aac0723,0x0c810c66,
0x0a9b0ba0,0x0a690a08,0x0cef0b85,0x0d830dcc,0x0abb0c38,0x0ad10a14,0x0e0a0c7b,0x0bae0e16,
0x01220703,0xf627fb3b,0xefeef27b,0xec42eddf,0xea94eb1e,0xebfeeadc,0xf0c6ee01,0xf614f3aa,
0xf875f7c1,0xf92ff8c4,0xfbc3fa1c,0x016afe44,0x08b2052f,0x0db40b9b,0x0ef00ed8,0x0f350ebf,
0x11fb1088,0x1055123b,0x07670c86,0xfe82024c,0xfd35fcc7,0xff1ffe6c,0xfc33fe4e,0xf7e6f9be,
0xf7fcf745,0xfb1cf968,0xfcfafc67,0xfd15fd02,0xfea9fd89,0x00e8ffe9,0x01df019f,0x02110215,
0x026a0233,0x01c6027d,0xff7000a2,0xfe8dfea2,0x001fff62,0xfee20019,0xfb41fcf3,0xf868f9b4,
0xf64bf745,0xf36cf4f6,0xf289f23e,0xf7e6f44a,0x019dfc8b,0x0a1e0672,0x0dfd0c9b,0x0f8b0eeb,
0x0f2f0fb5,0x0beb0dd1,0x09f90a70,0x0b9b0aa4,0x0c2d0c3f,0x09670b41,0x055f074e,0x016203a1,
0xf9f5fe23,0xf0dcf56b,0xe9f9ecde,0xe825e875,0xe925e863,0xed53ead3,0xf3e9f08c,0xfb4df771,
0x0211ff11,0x044103bc,0x0492044e,0x07050574,0x0b74093d,0x0ead0d65,0x10640fa1,0x10b410da,
0x0ca80f2c,0x074a09e3,0x020304d1,0xfc7dff50,0xf863fa35,0xf6e2f727,0xf8edf789,0xfb0cfa44,
0xfb0ffb28,0xfbf2fb42,0xfd83fca7,0x0028feb2,0x02ea0199,0x045f03c8,0x03550436,0x000f019d,
0xff27ff1e,0x01d80046,0x02e30309,0xfe910138,0xf953fb84,0xf91af87e,0xfa1cf9e8,0xf86cf981,
0xf55cf6fd,0xf37ff3f5,0xf7a7f4b8,0x000efbd8,0x06ae03b8,0x0be90954,0x11110ea0,0x142012ff,
0x13a41458,0x0f5811f6,0x09390c3f,0x05d206fd,0x0517055f,0x02bc0473,0xfb4cff92,0xf3acf6de,
0xf10df1fe,0xef77f03d,0xed65ee8a,0xeb10ebfd,0xed10eb5d,0xf273ef85,0xf932f5bd,0xffcffc97,
0x06ae0327,0x0ceb0a30,0x0dbb0e06,0x0cd30d16,0x0d960d2e,0x0d5d0dc4,0x0c0e0cc1,0x09f50b49,
0x06050815,0x014403b1,0xfc67febc,0xf8b5fa6f,0xf658f74f,0xf63df612,0xf758f6b7,0xf9c8f85c,
0xfcdcfb57,0xff4efe23,0x020c007a,0x051603a4,0x05c105e0,0x03a404db,0x028802b4,0x034302c4,
0x015102f6,0xfbe1fec1,0xfa1cfa3a,0xfc9ffb46,0xfb43fcc0,0xf568f870,0xf2b6f33e,0xf5d8f3cd,
0xfa69f848,0xfdb2fc2e,0x0164ff59,0x06c103ec,0x0c4109a7,0x0f670e26,0x110c1058,0x125611c1,
0x11bc1262,0x0e5f105e,0x089c0bb4,0x015f0504,0xfa9afdcc,0xf550f7d6,0xf1c4f323,0xeff9f0da,
0xee14eeeb,0xee8aedf6,0xf001ef58,0xf1b6f0c2,0xf3d3f2d4,0xf811f53d,0xffddfbdc,0x06610367,
0x0c530955,0x12460f67,0x15b11499,0x122f14e2,0x0b260e9a,0x079408ba,0x058e06d3,0x01410395,
0xfe17ff92,0xfbc0fcfa,0xf9aefab3,0xf833f8dd,0xf66ef776,0xf4bff54d,0xf7aaf587,0xfddefaa5,
0x028e0069,0x05ca0445,0x076306ef,0x06900741,0x04b5058b,0x03aa0417,0x00f502ac,0xfd1cfeff,
0xfb68fc06,0xfa47fb01,0xf920f989,0xf89af8e3,0xf813f85f,0xf763f7ca,0xf65df6c6,0xf78ef65d,
0xfdc9fa2f,0x04d10150,0x09c4078d,0x0d040b6f,0x0ffc0e8f,0x11841110,0x10b01155,0x0f780ffe,
0x0def0ee4,0x0a1a0c62,0x033e072b,0xf896fe60,0xee04f2e9,0xe9f9eaef,0xec63ead8,0xee7ced9d,
0xf04eef5c,0xf1e3f10b,0xf5ebf37b,0xfad3f8a3,0xfc4cfbfd,0xfd1cfc65,0x03e1ff68,0x0f8b09d2,
0x1523137e,0x143d1506,0x12fb1377,0x10881222,0x09890dba,0xfef3045b,0xf77dfa47,0xf792f6d7,
0xfa78f903,0xfc37fbce,0xf9fefb7c,0xf782f888,0xf81df768,0xfadff98d,0xfc1efbb3,0xfeeffcfe,
0x049901a6,0x08cf0700,0x0ac40a17,0x08e90a76,0x03970669,0xfece00de,0xfc00fd12,0xfa31fb16,
0xf81df914,0xf798f785,0xf813f80d,0xf60ff75e,0xf4d7f4ee,0xf8d6f646,0xfe8bfbcc,0x01780056,
0x02ec0214,0x08cb0511,0x11440d43,0x13db1393,0x10bb128d,0x0e580f33,0x0e0f0e19,0x0ca80dd9,
0x070e0a60,0xfe9e030f,0xf630fa1c,0xf108f34b,0xec7feee4,0xe7a4e9de,0xe766e699,0xee1dea0c,
0xf687f26b,0xfd1efa17,0xfef2fec1,0xfe6cfe60,0x02c0ffed,0x09e20662,0x0dfb0cb2,0x0e6a0e42,
0x117e0f63,0x14c913af,0x10f213db,0x07c30cb1,0xfed002e4,0xf916fb83,0xf613f75e,0xf4c1f531,
0xf4b7f49b,0xf69df549,0xfb1ff8af,0xfe1afd18,0xfe30fe5a,0xfe8dfe2c,0x0059ff4a,0x044e0221,
0x086e0690,0x09760951,0x07e208d2,0x059c06e0,0x01c80408,0xfb35fed0,0xf50df7b8,0xf2d1f36c,
0xf493f345,0xf7b1f640,0xf826f853,0xf76df797,0xf9baf823,0xfe7efc03,0x036a00dd,0x088005f9,
0x0cae0ac0,0x0ec80e0a,0x0f700f0a,0x112e102d,0x11171188,0x0e530fe4,0x09cb0c41,0x02850687,
0xf9bbfe2c,0xf35cf61c,0xef37f14c,0xeb07ed08,0xe912e9ba,0xeb12e992,0xf023ed70,0xf55af2d4,
0xfa77f7d0,0xff9ffd05,0x05a3025f,0x0b2808e8,0x0bfa0c08,0x0ceb0c26,0x100f0e71,0x122911a5,
0x0ffc11c3,0x0aca0da8,0x043a07b5,0xfd02007a,0xf8f1fa65,0xf7bff835,0xf5acf6ea,0xf2a9f420,
0xf226f1c2,0xf87df486,0x0028fce5,0x02a201f7,0x032202c9,0x059d041f,0x08380735,0x075f0843,
0x047805e0,0x037c03af,0x035a037e,0x01c002cc,0xfdd50028,0xf7b1fac1,0xf310f4f4,0xf219f20c,
0xf31af2a3,0xf3ebf345,0xf884f594,0xffb0fc2a,0x0449027d,0x0637054d,0x09a20799,0x0e0d0bcf,
0x11350fd5,0x114611d5,0x0df40fdb,0x0be50c66,0x0c930c32,0x09af0bf4,0x009005aa,0xf680fb1b,
0xf1b5f37b,0xeda1f00b,0xe7c9ea99,0xe699e647,0xecaee8e7,0xf510f122,0xf94cf7cb,0xfb3cfa2b,
0x003dfd37,0x08b5045a,0x0e6f0c65,0x0ec10eea,0x0fcb0efd,0x10e5109e,0x0fcb1097,0x0c0a0e67,
0x04c108b9,0xfe47011f,0xfbb6fc85,0xfa8bfb58,0xf709f925,0xf3f7f51d,0xf4c1f3ec,0xf73ff5e1,
0xf972f87b,0xfa8dfa0d,0xfe60fbce,0x06ae0229,0x0d310aa9,0x0cc70dc5,0x08690ab7,0x046e0636,
0x01e00329,0xfee3007d,0xfb33fcf6,0xf7eef943,0xf75df740,0xf7a8f7d0,0xf4b5f6b5,0xf0dcf273,
0xf257f0bf,0xf7c1f4e2,0xfd53fa93,0x0473008b,0x0c92089a,0x11500f8e,0x1091116d,0x0e600f5e,
0x0d4e0db7,0x0d780d41,0x0d650db3,0x09950c18,0x029c0629,0xfd54ffa8,0xf91bfb65,0xf264f61e,
0xeb78ee99,0xe9f7e9d0,0xedc0eb87,0xf1deeffc,0xf5a3f3b4,0xfa59f7b6,0x0157fd99,0x079904fc,
0x09670902,0x09530962,0x0b0009cb,0x0f0e0cdb,0x10691084,0x0af30e70,0x031806de,0xfe5c003a,
0xfbc6fcfb,0xf8abfa4e,0xf596f6ec,0xf4e0f4d6,0xf746f5c7,0xfa83f910,0xfbdffb68,0xfd75fc73,
0x01a3ff39,0x06ce043f,0x0a8908ed,0x0c9d0bb2,0x0dd10d5e,0x0ce10dcb,0x084c0b08,0x016204ed,
0xfb03fe09,0xf647f879,0xf35af47f,0xf2f4f2f0,0xf34ff331,0xf387f373,0xf3edf3a4,0xf568f47a,
0xf798f678,0xfb68f906,0x0299fea0,0x0a10068b,0x0ff00d29,0x1436125a,0x14dc1531,0x1017131b,
0x09b80cc6,0x065007a1,0x044d0567,0x012302e2,0xfd0bff45,0xf7defa90,0xf397f574,0xf186f256,
0xeff2f0c1,0xef4cef58,0xf2bff06a,0xf9ecf614,0x0072fd6f,0x051602f0,0x081b06d0,0x09bc0912,
0x0a580a24,0x0a020a41,0x08750966,0x05bd0741,0x029e0434,0xff46010a,0xfc2ffda7,0xf959fac5,
0xf6a6f7f3,0xf508f5a9,0xf519f4c4,0xf7ebf613,0xfd24fa76,0x00f6ff3c,0x0389023f,0x06d90500,
0x0b1a08f4,0x0df70cdf,0x0e2c0e5f,0x0d470dc2,0x0c080cc5,0x09230ae6,0x031806a6,0xf98bfeae,
0xf0b7f4ba,0xed43ee2f,0xeeceedc3,0xf039efa2,0xf1b1f0d3,0xf42af2c5,0xf849f606,0xfc74fa96,
0xfea3fdc9,0x00c2ff7f,0x069302fa,0x0fb40b2e,0x14971310,0x13d514a2,0x121912ee,0x0f611111,
0x08980ca2,0xfe71039b,0xf74af9ff,0xf6d5f674,0xf864f7ad,0xf875f8c0,0xf607f764,0xf451f4e4,
0xf578f48c,0xf8a7f709,0xfb09fa00,0xfe88fc58,0x04ca0174,0x09e807ac,0x0c370b65,0x0b140c21,
0x0756094e,0x03d9056b,0x00900229,0xfd18fed4,0xfa05fb61,0xf8c8f919,0xf851f8b5,0xf602f75c,
0xf4a9f4e5,0xf7b1f5af,0xfca0fa2c,0xffc8fe79,0x0190009f,0x06de0390,0x0e750ada,0x112d10ae,
0x0eeb104c,0x0d190db8,0x0d270d0d,0x0c0d0d15,0x06ae09ea,0xfe7502be,0xf6a4fa31,0xf223f416,
0xee01f039,0xe971eb89,0xe927e873,0xef43eb93,0xf6ebf335,0xfcf6fa25,0xff7dfec7,0x0033ffa7,
0x047401d7,0x0ac307ad,0x0e850d4b,0x0ed10ec8,0x10e20f68,0x13451281,0x0fcb1263,0x07790bff,
0xfee902e3,0xf8e1fb86,0xf541f6dd,0xf393f425,0xf3a0f372,0xf573f438,0xf997f758,0xfcb4fb8a,
0xfd72fd3c,0xfe5cfdc2,0x005cff34,0x0466022d,0x089e06af,0x0a1f09af,0x095909ea,0x0754088c,
0x035b05ac,0xfcdb005d,0xf6bdf974,0xf3f4f4e8,0xf4bef3f1,0xf736f602,0xf7b9f7cc,0xf74ef753,
0xf9acf819,0xfe1efbd4,0x029e0047,0x076d0502,0x0bae09ae,0x0e1d0d33,0x0efb0e85,0x10a70fb6,
0x109110fd,0x0de70f6c,0x09710be0,0x025a063e,0xf9e0fe2a,0xf3acf65e,0xef95f1a1,0xeb89ed75,
0xe9baea51,0xeb9fea37,0xf06eedda,0xf58ef30b,0xfabcf80c,0xffedfd54,0x05d102a5,0x0b490904,
0x0c580c43,0x0d470c90,0x10070e9e,0x11d51169,0x0fa81164,0x0a8c0d5e,0x0412077e,0xfcf10060,
0xf8d5fa53,0xf78af80c,0xf56ff6af,0xf267f3e2,0xf1d2f176,0xf81ff42b,0xffe9fc8e,0x028801cb,
0x031702bc,0x058e0410,0x0839072a,0x07860858,0x04b80614,0x03c703f6,0x03ab03cd,0x021b0323,
0xfe260082,0xf7e8fb07,0xf32df51d,0xf227f221,0xf31bf2ab,0xf3e0f340,0xf86df582,0xff92fc11,
0x042f0261,0x06210536,0x09830780,0x0de50bad,0x110d0fac,0x112a11b2,0x0dea0fc8,0x0be10c61,
0x0c8a0c2f,0x09a30be9,0x008b05a0,0xf684fb1b,0xf1b9f37f,0xedaaf00f,0xe7dceaa7,0xe6abe65b,
0xecb7e8f5,0xf514f128,0xf951f7ce,0xfb41fa2e,0x003ffd3a,0x08b6045b,0x0e710c67,0x0ec30eec,
0x0fcb0eff,0x10e3109e,0x0fcb1096,0x0c080e65,0x04bf08b6,0xfe46011e,0xfbb6fc84,0xfa8afb57,
0xf708f925,0xf3f7f51d,0xf4c0f3eb,0xf73ef5e0,0xf971f87a,0xfa8dfa0c,0xfe60fbcd,0x071e0229,
0x00000513,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_timpani_timpani[3968] = {
0x00000000,0xfff9fff5,0xfff9fff5,0x0004fff5,0x004fffd7,0x010dff91,0x0f21fd95,0x4fbb460b,
0x598a625b,0x40225439,0x1dc43113,0xcebe1dfc,0xa00faa38,0x8dee95d9,0xa37e9a5c,0xc251ae3d,
0xce93bae0,0x0511d76d,0x3eb12a28,0x4c583de2,0x57c249d3,0x71fb4441,0x23dd71fb,0xe630f1b5,
0xe648e7ed,0xeec9ef46,0xcda5dd06,0xb7a1c669,0x8ede8dee,0x8dee8dee,0x8dee8dee,0xc0548ff3,
0x0a45edec,0x71fb5de5,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x63ea65a4,0x1d0f436b,
0xee5d0f5a,0xe57305f9,0xb625c17f,0x8deeaa98,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xc0a68dee,0xfbd5dff8,0x3d3529ab,0x55755d07,0x67ae6ddf,0x71fb71fb,0x4f7e71fb,0x13161b8c,
0x1d472442,0xfa441de7,0xcf52e857,0xd173e353,0xe3c8e00a,0x0295e5f9,0x0f271317,0x2b7b286d,
0x22d1246c,0xa55de909,0xd89caf6a,0x38f2130d,0x53b04e5a,0x3fcc54bc,0x0adb2513,0xf0652688,
0xd155e5e1,0xfba9dd25,0xf8551268,0x9d19b5bf,0x9acea20f,0xad5bb3e4,0xed96daf5,0xf3e2f0de,
0x10511045,0x4bf33ede,0x2b5b3d9b,0x29bb3343,0xffc50b15,0x0027ebe8,0xfec7f3a9,0x10b60585,
0x2b5f16fb,0x11ff1190,0xdf53f16d,0xeca9de8c,0xd533d6a4,0xcb59bbe0,0x0a3cd75a,0x2ffe10b0,
0x51a051c1,0x4d464a90,0x71fb558f,0x4c346c85,0xe693195c,0xc947d26b,0xb29bcfe6,0xd9cfc45b,
0x05d9e1d2,0xf35a17dc,0xe47fe2b5,0x9e06a4c7,0xc216b13e,0x004bdab5,0x14061d0b,0x00cafd35,
0xff13ef19,0x288f131d,0x3ce019c6,0x2b4f3101,0x04c10d54,0xc8fbea58,0xa9669f86,0x8deeb3ed,
0xc2fba7ce,0xf0a8ce3f,0x0d69f6ef,0x41e33da6,0x48ae4ae9,0x5d2c3a27,0x65f8634d,0x4b764493,
0x5810406f,0x4a9b649b,0x4343455f,0x2c0c4275,0xe114030a,0xb1e6cd24,0xc151b261,0xa540ac33,
0x8dee8fcc,0x8dee8dee,0x8dee8dee,0x91fb8dee,0xe178bead,0x15e3f073,0x063211a2,0x20a40606,
0x4ae02a5e,0x662c5d72,0x4da64ee4,0x3b7d34a9,0x29b54196,0x42eb351b,0x491b4bf0,0x599d6206,
0x2c094a20,0xed231a6f,0xcd85ea5b,0xe852d9a6,0xf8adfc73,0x1b280bb1,0x22ad224f,0x1562130a,
0x0ecc125f,0xf0b70311,0xbec9f2c8,0x909eaec4,0x8dee8dee,0x8dee8dee,0xc16f9eb2,0xa6ffb95f,
0xdb97b77b,0xf408db2f,0xf6abfaf8,0x058501cb,0xfbd80c9c,0x0ea10add,0x36792da4,0x67ac4ba2,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4ca36dc4,0x3e9f3f5b,0x067e1bcb,0x085afcfa,0x01461670,
0xe891fff2,0xe74aecef,0xfc92f08b,0xf4d7f80c,0x987dc84c,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xb84c9a36,0xbb70c776,0xc9b5cbaa,0xc9ebd25d,0xfaa7d65b,0x31b420a0,0x36262852,0x3a6e340e,
0x37cd3a0b,0x5a4b49e5,0x71fb6b6a,0x71fb71fb,0x71fb71fb,0x6bf96d27,0x34275100,0x2c1831b4,
0xeb3d2305,0xe341e747,0xd083cb12,0xe01dc9e5,0xea3adc7d,0xcc09dcd0,0xc3c9cab1,0x93e4a51c,
0x8dee8dee,0x8dee8dee,0x9c468dee,0xaef2a646,0xc838b98a,0x1a70ef95,0x11b4ffec,0x28fe19ea,
0x0a971634,0xff680f97,0xff8602d1,0x18930661,0x3bc82224,0x650c6590,0x5b8162af,0x66bf59b8,
0x71fb71fb,0x715f71fb,0x5a586b92,0x282e37d9,0x09631b2b,0x0930fe19,0x05541030,0xf2a0f255,
0xce93eefc,0x943d9f37,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xabd58ecb,
0xf6e2ccf0,0x14d40bb6,0x308c1fd4,0x3cc83642,0x4d1441cb,0x58a454ef,0x54f55933,0x6aab5d25,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4dff6b8e,0x273825fc,0x1d5131ad,0xe9ae0de2,0xcb9ddd3e,
0xc6e9c6dd,0x9e7eab38,0xcb85af2d,0xc1a3bb94,0xad7db412,0x9b3daf10,0x93f193cf,0x900b938e,
0x8dee8f27,0xb6319605,0x17e8f839,0x23232783,0x1f56235e,0xfdc91211,0x0a31f343,0x103f09a2,
0x23d41d97,0x1fcd26b7,0x43003222,0x603e588b,0x6e406635,0x6c526a3b,0x6ee871fb,0x613c68f3,
0x44e551be,0x1c9d290b,0x0b85134a,0x11270d1c,0x09ad1dc6,0xf4bb03c8,0xa06ecc52,0x8dee92a4,
0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xa2ac8dee,0xcb33c27f,0xdbfcd848,0xe91edd0b,
0x19bb024c,0x5a023657,0x627b61be,0x4ac44f22,0x71fb4e69,0x71fb71fb,0x71fb71fb,0x71fb71fb,
0x4bac646a,0x3460374a,0x15141ac5,0xf4c108e7,0xe3b6fd3b,0xdc99dba0,0xae51b249,0xb0cab142,
0xdc46c25a,0xe4b0e258,0xca7ddfcb,0xc81dc1bf,0xc85ed0b7,0x9c7e9bdf,0xa5719cdd,0xbcf2a722,
0xe7a6e365,0xf0c3fc49,0xf5cbf135,0xf9f7fb00,0xef710010,0xff91f2d9,0x054ef957,0x34e02252,
0x53354cae,0x5ad14d72,0x71fb71fb,0x71fb71fb,0x6f3871fb,0x39a058a2,0x29e3309e,0x121f1c60,
0x113b1e47,0x1d881a32,0x0f9a1928,0xfcd4febe,0xc87ce08b,0x8f00a429,0x98c38dee,0x8dee8dee,
0x8e178dee,0x8dee8dee,0x90c88dee,0xc201b78f,0xc9f5c20d,0xf88ae686,0xfb42f39e,0x17da1b73,
0x17ed1155,0x2a750ca7,0x71fb45f3,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4e0871fb,0x28a93e22,
0x0e341dfe,0x18280ebe,0x18301cc3,0x039015b6,0xdb97e75b,0xcb0fd9c7,0xcb33c14c,0xccafcb4f,
0xb0b8cb7a,0xb53eb409,0xafecb29b,0x91d6a409,0xcf3db0ae,0xe1d2ec38,0xdcedd1ca,0xd951e49f,
0xef96e106,0xfa88fb3c,0xea75e9f4,0xfda2f975,0x1a3a0203,0x35f92d77,0x2be02f48,0x4b9a3949,
0x58a151eb,0x71fb6f95,0x650667d0,0x42355a2f,0x40443b7b,0x40d134c8,0x2d564336,0x408939cf,
0x2d9a3875,0xef4106b1,0xc38edeea,0x95d7ab99,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0x8dee8dee,0xc804aa74,0xc589c984,0xe8f4dd31,0x0e73f788,0x01540a20,0x2de20e8f,0x4c283918,
0x67d35439,0x71fb7038,0x71fb71fb,0x71fb71fb,0x6ae471fb,0x2d433cae,0x10ed19eb,0x1c3e1a8e,
0x0a5d1401,0xe8b5fbd8,0xe63be7ac,0x093f02ae,0xdc35facc,0xc536ca7a,0xaab8c1b6,0xa2519cb2,
0xa7a4ad63,0xbdf7ad7f,0xcae8c7cb,0xd885ce7c,0xc219cc6c,0xf091d575,0xf232f7bf,0x099ef61e,
0xe0c5f447,0xe92ae38e,0x0a69f805,0x30071977,0x367133b3,0x64ee4ad7,0x71fb71fb,0x641971fb,
0x414e4b25,0x35e03489,0x374134ff,0x44c13c88,0x3bcf4669,0x31503829,0x16fa31d5,0xe45a02da,
0xcbfdd5b2,0xaa30c075,0x94f799c7,0x8dee8dee,0x8dee8dee,0x943e8dee,0xb4fba87b,0xb038b474,
0xbe6bb283,0xd2e6c6c9,0xff87e844,0x0a1406d0,0x258314c9,0x46db2963,0x4af25722,0x71fb5275,
0x71fb71fb,0x71fb71fb,0x53aa71fb,0x35ce396c,0x2ab23295,0x1eb02bfb,0xf9a80b3f,0xee36ee36,
0xf4a5f487,0xede9fc15,0xdee4e4f9,0xb698ca86,0xbf37bc59,0xb69db8ae,0xcdedb760,0xd733d7d2,
0xb98ac90f,0xd349c196,0xd264ceff,0xdb7cdd82,0xf2b5e40f,0xf686ee56,0xf633f816,0xf169ecdf,
0x0c40fbaa,0x0e940d16,0x30a21e62,0x3fd93ce0,0x6314519c,0x546361a1,0x513a4a63,0x64d15f52,
0x32355255,0x2206225d,0x16212090,0x2bc2229d,0x1b4b291c,0x059e10df,0xeed5059e,0xc3b7d989,
0x8dee9c7e,0x8dee8dee,0x95898dee,0xb1a1a4f8,0xaacba7a6,0xadc5aa68,0xc15ab142,0xd545cf62,
0xe7a0d904,0x0874f0dc,0x1e87151d,0x41592fff,0x4a2543f2,0x5f2954da,0x61266823,0x5f7b5e92,
0x71fb678b,0x592f6f74,0x25c142ce,0x03761141,0xffcbfc45,0x111b0957,0x190820b9,0xe699f7bf,
0xd2d1e2a0,0xc669c88e,0xaf97c3b8,0xc0edb1d2,0xc6febcf2,0xf229e9e2,0xe975e9b3,0xd2b9e13f,
0xb88fc0cb,0xd635c866,0xf8d9eac0,0xddd0ea3d,0xeceae827,0xf7aaef85,0x12570078,0x1c212356,
0x1b471658,0x26162538,0x2d6f2987,0x425f3122,0x525c4c83,0x60055e8f,0x40c559c2,0x34792cc5,
0x461a453d,0x1b8c3816,0xfe9d0a92,0xf5d6f1e0,0x02a30ace,0xe190ef72,0xb9cfcdd0,0x8dee93b8,
0x919992d7,0x9d4192ea,0xba17b0a6,0xb167b97a,0xb606af81,0xbe84be14,0xd530c5cc,0x02e0e7bc,
0x2aba15dd,0x2b263246,0x3f272f39,0x48373db3,0x580b52ee,0x63e45b8a,0x6ac16f06,0x3a8e552a,
0x1e9e264c,0x24e81ed6,0x1f9220d6,0x0afb1682,0x017d0468,0xe8c2fa63,0xe7dce3d8,0xecf8f513,
0xc975d71e,0xafd3b7e2,0xcf6fc276,0xde94d472,0xec44ea02,0xd37edb4a,0xe072dcc9,0xdce2dff7,
0xdd19e21f,0xbb50cbfe,0xcbcbc024,0xf84bdc24,0x116702c5,0x2d6127d3,0x2b5b30dc,0x240f2677,
0x18fb20a0,0x24ca1a9f,0x4f653cc0,0x41cb4bad,0x5d4a4c6d,0x50a861e9,0x37543d77,0x110e2ac1,
0x152d047c,0x20fb27b3,0xfbff0e5e,0xe0dbf390,0xa6d4bbcd,0xa911a405,0xb858b109,0xbe30bf04,
0xb988c035,0x9cb2ab27,0x96c5958b,0xbdeba69d,0xdd77cec4,0xf702e607,0x0ab20256,0x2c4d1632,
0x46433df5,0x53ed4692,0x4c4b5690,0x3df53c75,0x4b944548,0x54e756fe,0x3e0c4681,0x280c33b3,
0x23452400,0x083714ef,0x07930af7,0x04a30565,0xeb51fad6,0xd97cde70,0xd246d2d9,0xd354cce9,
0xdceadc22,0xcb65d743,0xc3e9c397,0xccc6c4d2,0xef84deea,0xe7f4f2e3,0xd610d7e5,0xd728ded1,
0xcefacdc1,0xe820dc15,0xf46cecaf,0x1aac04af,0x1b2820e8,0x24931f19,0x363b2eea,0x275f2c8d,
0x34352bc7,0x41203baa,0x442b463d,0x4e97491e,0x3d744977,0x3a183580,0x1f4a328a,0x108c14ed,
0xf0a7055a,0xeb5bea1b,0xd2dce595,0xa58cb79e,0xa207a039,0xaca4a6af,0xacc1abbf,0xbe40b236,
0xcbe1cc7f,0xc531c4b7,0xc8f9c807,0xd3cace23,0xf3a5e044,0x16a0061c,0x4cb3326d,0x45384e67,
0x54d04b49,0x47314f13,0x40cb4176,0x40154410,0x27e930de,0x38382ae8,0x3f344294,0x2883356d,
0x0c221c8f,0xed29f960,0xe20ce954,0xe488dcea,0xe888e7b5,0xd164e0ce,0xb9b4c228,0xce4ebf72,
0xe571d76d,0xed4df1f5,0xce6cdc2b,0xdc03d3df,0xe906e5bc,0xe5cfead2,0xcc97d669,0xdc7dce63,
0xfcbaedd7,0x080002c6,0x1f1c1582,0x0fd7192b,0x23f712b7,0x377f33d4,0x31013322,0x4af73cac,
0x3d104a01,0x47913bf6,0x47754bff,0x30984204,0x119e1993,0x07590cb8,0x08700777,0xf7bf0492,
0xd4a3e4d2,0xc7cecd00,0xb541bd13,0xb7fcb39b,0xa91fb346,0xadcca73a,0xc3b6b815,0xd998cc11,
0xdc40de8e,0xd8cedbfd,0xe06bd98a,0xfba5ef80,0x15db0768,0x3c052973,0x4ab0456e,0x62ef57c4,
0x4f375cae,0x3cb3453c,0x3f9d3722,0x32fc3fcb,0x1ab525ac,0x05330df9,0x0f4208cf,0x0f7514fd,
0xf5a80474,0xe879eb08,0xd86ce2d4,0xd442d332,0xd8eed47e,0xe3f4dfb8,0xe184e7ab,0xcdeed7e1,
0xce4ecbcf,0xe3c6d579,0xea00eb3d,0xdc34e195,0xdc8cdae0,0xee27e733,0xe5daebb2,0xebc0e330,
0x0787f802,0x298318b1,0x365331e8,0x39443988,0x262f314a,0x18641b15,0x33a62212,0x547148c5,
0x51c35433,0x34724abf,0x0c961b41,0x01f50611,0x07d30660,0x0068017b,0xf06efe32,0xdf89e428,
0xd4b4dd64,0xc04fc699,0xa856b55d,0x9fa7a0fd,0xb6dca861,0xcd8bc393,0xd0ccd3d0,0xd3c7cf43,
0xf571e246,0x09e70107,0x1b0614af,0x28421d76,0x394c34d1,0x326d32e0,0x43a13bb1,0x48ec46bd,
0x5234502a,0x31c7447a,0x1810243a,0x12a2120d,0x0f4e13d2,0x0ace0bbd,0x0370077a,0xf3b5fe97,
0xe75dede0,0xd6faddb1,0xe298dbe2,0xe49fe5a4,0xd830dfa0,0xd3ccd3f4,0xd28ed239,0xd29bd5b2,
0xd25dcf35,0xe48ddaf3,0x0096f46d,0xef40fdf9,0xe667e5b7,0xe8b0e6fb,0x0806f478,0x20491a21,
0x17e91d4e,0x1c4613c9,0x25942709,0x2b9725fa,0x34942fd2,0x338334ed,0x3bdd384a,0x3ccb39a3,
0x39313d65,0x2917344b,0x0b5219b3,0xee91fbb0,0xe780e8e3,0xd837dfac,0xda21d7ad,0xc3ddd376,
0xbb54b9dc,0xbea6bf22,0xc0f4bdcf,0xb41abd3c,0xbc8ab395,0xe1a9cd24,0xf2c7ed68,0x07b1fa6c,
0x16971272,0x1f9c1a66,0x1e961ebd,0x2341232c,0x34ad26e4,0x495141a9,0x432b49bd,0x2e3f3a18,
0x30e129af,0x2e2b34ba,0x20a52414,0x190f1e6b,0xfeff0ca5,0xeccaf9a3,0xce78da18,0xdb19cee3,
0xe260e2a1,0xeb8ce45b,0xe9abed09,0xdee9e38c,0xd54bdab3,0xce85d249,0xd3a6d031,0xe43adb17,
0xf74aeb81,0xf788fcba,0xe8c5ee92,0xf2b5ebac,0x01fcf8cb,0xfc2702a7,0x0951004a,0x1b6111b6,
0x2a8f25fb,0x26ef2b1f,0x2d20265b,0x3c2c3492,0x508046ff,0x425a501a,0x1fd02e4b,0x15a41956,
0x109812c0,0x036c0b94,0xf826fed7,0xdd74eb6e,0xc1eece9d,0xca5fc19c,0xdaced49d,0xdcb9de22,
0xc275d187,0xbb29b94b,0xc21fbec4,0xcf2ac65e,0xd61bd546,0xe747daee,0x0b00f851,0x1ec81883,
0x23a61f96,0x2b0d291a,0x364e2e2b,0x3ce03a4e,0x47744428,0x38244383,0x25fc2b12,0x1efa22ca,
0x282d227f,0x1ba02434,0x10211925,0xf71200e0,0xe01aee72,0xcdced15e,0xcfa7cf10,0xd901d200,
0xed86e2b1,0xfc5ef82b,0xf690fa8d,0xe370ed5f,0xd8e3dceb,0xcd47d44d,0xcf36c8bc,0xde51d9e0,
0xeac4e28f,0xfda9f1d0,0x0f330af0,0x091907e4,0x12911214,0x17291077,0x18281c7d,0x1c34172d,
0x33b62440,0x44b443b1,0x2318339c,0x23be206c,0x2f1d28e6,0x2ea030fa,0x24682c5b,0x01561436,
0xef77f566,0xec5cecf6,0xe8a7eca9,0xdcb0e10b,0xd9bbdbc1,0xc92dd25d,0xb80fbe7e,0xc384bbad,
0xccb5c9e2,0xc265c741,0xd26ec67c,0xee88e318,0xf9c1f2e9,0x161406dc,0x29eb2356,0x26ae2902,
0x2bdf26ae,0x367e3427,0x41c13b57,0x3dde4172,0x27203534,0x175d1a9c,0x1ed91ca0,0x1c901cd4,
0x0e161a10,0xf9e901ba,0xf708f54d,0xfca4fc1e,0xeab4f52e,0xd1c9dff6,0xc33cc406,0xde12ce31,
0xf53cebd2,0xf0a8f425,0xe02feb63,0xd6d9d66b,0xdd7ddc99,0xdfc5dc5f,0xe8ede71d,0xf136e75a,
0x0870000e,0x13840d02,0x1b491af8,0x0f6b15da,0x0d160cd6,0x17bf1244,0x169b1634,0x1a141814,
0x27fd2132,0x34ed2cb2,0x47144120,0x2f453e8a,0x1acb2305,0x0e2a1356,0x0b1f0beb,0x023b0a0e,
0xdb17f0f9,0xc9d6cc05,0xca00ca68,0xd1b3cd38,0xd32dd381,0xcfa2d390,0xc3bfc7d9,0xcbcdc7b8,
0xd261cd61,0xe365dafb,0xef5fe9a7,0x0eedfd0a,0x280c1ef7,0x1ea52580,0x18951a5b,0x27891c48,
0x36c432b9,0x30d53522,0x319c2f88,0x346933c0,0x27672f8f,0x1caf2368,0x09b80fe9,0x0e850ceb,
0x05a30a9a,0xf48efeda,0xd811e68e,0xcf1dcfdf,0xd6c9d292,0xdf40da38,0xe550e2ff,0xe543e629,
0xe26fe2af,0xedeae83f,0xf33ceef7,0xfa90fa11,0xe9c6f30b,0xe7c4e5ed,0xee36ea0c,0xfb28f63e,
0xff81fbc9,0x0a2d045b,0x18ea115a,0x24e520c2,0x1d4721e6,0x1adb1b6a,0x2a621fd9,0x36843451,
0x2a4a309c,0x2b3d2991,0x219d279c,0x16dc1c8b,0x0a301003,0xfcee054e,0xeca0f382,0xe181e590,
0xdd74e16f,0xc7f0d487,0xc49ec12a,0xd4cbccc2,0xdb17d96f,0xe06ade1b,0xd52cdced,0xc9d2cc0e,
0xdac7cffa,0xfc8beacf,0x14130a6d,0x18b21861,0x145c1579,0x2a0d1d9a,0x368d3163,0x3ad63a70,
0x38dd39b5,0x35e937ed,0x2e363237,0x20bd29f2,0x0cdf15e6,0x01a80653,0xf826fe0a,0xe5c3ed8d,
0xe7abe4da,0xe34ce713,0xded2e029,0xe817e1c7,0xef77ec13,0xed20f1c8,0xe008e571,0xe3dadfac,
0xe51ee609,0xe3f9e3a4,0xf03ae936,0xed69efd5,0xf903f1dd,0xfeb6fe32,0x015dfdb5,0x075305fb,
0x0ead09ea,0x12a91225,0x14061207,0x203d197d,0x33d22969,0x30ee3758,0x29302a13,0x21f92a31,
0x0fd115dd,0x08a40c9c,0x0dd807f1,0x107f1372,0x0dd80cd3,0xf8cd07db,0xe720ec13,0xd671e2e1,
0xc3dec87e,0xcde2c83f,0xccdbcebc,0xcd7dcbfe,0xc8b5cd24,0xcdc1c788,0xeab9da0d,0x035ffa2d,
0x0162046c,0x01c2ffd9,0x1c9a0b7d,0x359c2cbd,0x38cf381c,0x365e38cf,0x2ed7328a,0x2415291a,
0x21ad22e6,0x1e7e203d,0x1bae1d2f,0x10761825,0x026a07be,0xf9b5fd5b,0xef12f56d,0xe5f3ea3a,
0xdc6ee051,0xe660de9b,0xf1e9eee5,0xe5c3edcf,0xd3eadb45,0xdc9ed419,0xef1ce862,0xeccbef5f,
0xecbbeb29,0xf174ef0f,0xf709f353,0x08dfffc4,0x0d1c0d5f,0x09570ad5,0x07dc0927,0x04aa0472,
0x02e00502,0x0ce50472,0x173a14f9,0x21a319e0,0x39f92d17,0x429f443b,0x228e34fb,0x0a5e1247,
0x092d0926,0x0d1c0a24,0x01db0a9d,0xf908faf8,0xf951f9f8,0xf37ef6ee,0xd69fe9f0,0xbf60c61b,
0xb95cbc30,0xbad2b8f7,0xcdc2c10d,0xe3d4db37,0xec1be79a,0xfc9ef483,0x02c80107,0x0aa6057c,
0x184d12a5,0x10b315a1,0x14a20f6c,0x28f71e8d,0x32cb307a,0x347d32a8,0x36bc3774,0x284530a8,
0x1ebb21cb,0x115c1984,0x0a270c81,0xffe804e9,0xf26bfb7c,0xdd25e61f,0xd951d94a,0xdf5adb7a,
0xe43be28c,0xe1d0e3c6,0xe946e341,0xf071ee33,0xeefdf04e,0xed16ee3b,0xeb5deac0,0xf94cf08a,
0xfdb8ff50,0xf971f89b,0x03530013,0xfb43ffcf,0x01a2fc31,0x054004e6,0x0b970674,0x0c3f0f9a,
0x09880842,0x1c031091,0x3384294f,0x35a2385b,0x2f1d3130,0x25c02b66,0x1e8d2258,0x06f41555,
0xec47f767,0xeafae971,0xf518ef46,0xf38cf75a,0xe9cbede6,0xe239e584,0xdeeae1d2,0xcb4fd6fd,
0xbd3cc068,0xcc5fc254,0xda10d4f3,0xe65bdf57,0xf758ef95,0x05acfd42,0x150e0f75,0x148815a1,
0x19fa1551,0x2c84222a,0x321c337b,0x2dbd2e4a,0x33802ff5,0x30da34f6,0x220628c2,0x1ac91e4c,
0x0a1e1406,0xf3c7fea5,0xea50ed51,0xe5fce807,0xe393e2ff,0xe990e7bc,0xe126e65b,0xe405df2f,
0xf3d9ec9a,0xf58ff6eb,0xe84ef022,0xe45ae2c4,0xf353ebc6,0xfb0ef8f1,0xf4bdf8bb,0xedc2efd2,
0xfab5f238,0x07f40309,0xfdfb04b1,0x0328fd4f,0x0ca208f0,0x10c50ec5,0x13f51365,0x175f1447,
0x1a5e1a7d,0x21b81c2a,0x295d270a,0x26332939,0x17ed2037,0x04920d54,0x06b70317,0x0fdb0c6f,
0x023b0be2,0xef2ff7ac,0xe842ea8c,0xe39ee529,0xdef3e32b,0xcc6cd6bb,0xc0b1c2ef,0xce68c63e,
0xd69dd560,0xcf10d1fd,0xe491d530,0x02eaf42b,0x1ba1125a,0x1fae1f1b,0x1f0d1f74,0x231b1f99,
0x2d282883,0x2dfc2ed0,0x30ab2e3c,0x281c306a,0x13c11c8f,0x0f0a0eb0,0x161213a5,0x0b6712da,
0xfafb0207,0xf519f752,0xe722efce,0xd9c1df23,0xdba3d8c7,0xeca6e2aa,0xf5d8f3d0,0xedddf3ce,
0xe53de6dc,0xe7cae7af,0xe967e625,0xf5dbf0da,0xfb80f847,0x0196feb5,0x04e10397,0x03c50524,
0xfb23ffc5,0x0181fb09,0x0e0a0a82,0x0095088c,0x01c2fe8e,0x083105bd,0x126c0ba5,0x25411c16,
0x28d229a1,0x25b82764,0x1c9b2133,0x1b471b0f,0x19ba1b35,0x11f816e0,0xff540a0e,0xeeebf568,
0xefc9edd4,0xe71fee9c,0xd170dc92,0xc39ec8fd,0xc999c34c,0xda8ad2ce,0xda60dd6b,0xda24d75f,
0xeb64e0e6,0x00fbf753,0x024c04db,0x0449003d,0x10f90aa7,0x1ff7186c,0x2dc326df,0x37fe3417,
0x340e3846,0x25322da3,0x18a81d22,0x17fc1724,0x1320181f,0x05480b5c,0xff8e0216,0xfde6fd55,
0xf814fe57,0xe232ecd1,0xdbc8dc62,0xdc56dcde,0xd8d0da0a,0xe2ccdbf3,0xef18e936,0xfd49f5fc,
0xff100076,0xfd52fbc6,0x01660218,0xf7ccfae5,0xfaecf988,0xfc31faee,0xfddefddd,0xfeb5fd29,
0xfcdbff97,0xf6fdf944,0xfb08f739,0x1027044e,0x1a1317ed,0x1a0919c0,0x267e1e7e,0x301d2e1d,
0x232a2bdf,0x14791afd,0x111010ec,0x0ab50fc8,0x018904c6,0x001f00fe,0xf727fc1e,0xef0bf3b5,
0xdbb1e605,0xd65ed63e,0xd5dbd704,0xd1f7d3e4,0xcd72d03d,0xd0e4cc73,0xe63cd9bb,0xfe42f4ad,
0x027f015f,0x01cb0291,0x03760195,0x0fea08dc,0x2121175d,0x35c72c5c,0x3bb23acc,0x38f33ac5,
0x30933505,0x23b92b79,0x0ac3188d,0xf25afd0c,0xef34ecf1,0xfe07f794,0xf6bdfc92,0xe99bf0a8,
0xe393e346,0xeb3fe818,0xed63ec42,0xea0ced84,0xe374e5a2,0xe6ffe3b4,0xf94dee77,0x08e0030a,
0x068909b0,0xff5602d5,0xf7eafb40,0xf662f6a7,0xf26bf4ec,0xf4dcf20d,0xff90f9e6,0x06e5041d,
0x0b7b09d2,0x0c020b93,0x08000bd4,0x08d00478,0x1fa21495,0x266c25d2,0x19a12118,0x158b157d,
0x1ba617a4,0x1dde1f28,0x0c28165b,0xfc73028f,0xfe23fc27,0xf8a7fd03,0xef61f3c9,0xdd39e7e6,
0xcb6bd30d,0xc957c82a,0xd0b3cd30,0xd22dd1de,0xd788d381,0xe748de68,0xfe35f27c,0x0718055f,
0x0e730919,0x17d01455,0x21901be0,0x2a91262f,0x2c402d04,0x299529ec,0x2ce82b1f,0x2c312daa,
0x1b7026c3,0xfcb60ba8,0xef8af2e7,0xf587f1ea,0xf468f712,0xe87fed88,0xeec9ea30,0xf47af1bc,
0xf712f79c,0xe818f073,0xe246e2f7,0xe8dee4f9,0xee6beb8a,0xf8d1f379,0xfd18fc7c,0xfb6cfb49,
0x071e003a,0x10580cd9,0x098b101a,0xf13cfd69,0xf1a8ed29,0xf6c9f630,0xfb0ef801,0xff51fcf7,
0x07d40395,0x0f150b8d,0x1869131c,0x19441b9a,0x1af11708,0x2266205c,0x27ba249f,0x1b702510,
0x0ec812d6,0x08e20b7d,0x08fa08f6,0xfefb05af,0xe813f480,0xd4e2dcca,0xd36ed1c3,0xd920d7bb,
0xcefbd4c5,0xca49cb19,0xd8b2cf3f,0xe8abe120,0xf995f160,0x0521ffc3,0x0ea00a7c,0x0c3a0e75,
0x14500d53,0x25f51e47,0x2b31295d,0x28172b40,0x251c24ca,0x299f2859,0x1e892676,0x08b01300,
0x070a0589,0x0107060a,0xf881fbeb,0xeb88f343,0xdf40e3cf,0xe146ded7,0xe64ee3e8,0xef3aea63,
0xf260f1a6,0xf3b9f2c5,0xf561f4ec,0xf88ff658,0xffecfc2f,0x010401c6,0x03cd0113,0x05bb0678,
0xfc79014d,0xf95df9e5,0xf790f8a5,0xf808f76d,0xf737f823,0xfaa1f764,0xfb23fc80,0xff10fb4d,
0x0eb40572,0x23f71a3b,0x29c42965,0x236326fc,0x1f9920e0,0x1b1e1e6c,0x0df1145c,0x0eab0c9c,
0x0a890e96,0xfbe903f7,0xeb29f319,0xe6cce6d6,0xe76ae801,0xdabee334,0xc84ed028,0xcbdbc6e3,
0xdd74d454,0xe6eae418,0xe586e5ed,0xf359e9e7,0x060afdd6,0x0f910b65,0x16671389,0x1b8c18bb,
0x21a71ec6,0x2add24e3,0x37783244,0x316437a5,0x1bf126c3,0x0c0d1301,0x01c006f4,0xfac1fd35,
0xf3eef830,0xf046f0fa,0xebd6eefd,0xe85be955,0xe486e6e5,0xe6e3e455,0xee61ea2e,0xf674f314,
0xfeb0f98a,0x07ac0454,0x04c406f4,0xfea90288,0xf580f951,0xfba7f698,0x0001004b,0xf6f7fb28,
0xf50df5ed,0xf441f356,0x0084f9c1,0x05e60513,0x0004031b,0xfbe9fe5c,0xffd9fb2f,0x106d0882,
0x1adc1664,0x1e9e1d40,0x24262132,0x252b25c9,0x212f23bf,0x11d01b25,0x05bb0995,0x022d04bb,
0xf566fbd4,0xf3aef32c,0xeacff09e,0xddb8e4aa,0xd142d60c,0xd107d0e3,0xcc4ecea5,0xce7ccc11,
0xdee7d478,0xfa53ec91,0x08c903e6,0x0cdc0b00,0x12f20f15,0x1c69183e,0x20f61e4e,0x2a4d25c9,
0x2e862d1f,0x27df2cc4,0x1d6322bd,0x124e179a,0x07300cf7,0x007e02c0,0xf5c9fcf7,0xeb54ee95,
0xecb9eb4c,0xf2e3f01e,0xeed7f1c2,0xebf5ed08,0xec41eb00,0xf2fff054,0xf11cf25e,0xf798f277,
0x041bfebb,0x07be06d3,0x0724079c,0x0553069d,0xfe8702e0,0xef22f739,0xecacea64,0xfdb0f561,
0xfc5eff3d,0xfb53fabc,0xfa22fafe,0xfd1efa76,0x0681018f,0x0b1e09d1,0x0c440bba,0x103f0d4f,
0x1c7c159b,0x291d2393,0x2bb62c6e,0x22fd2731,0x1be7202e,0x0bc41542,0xf3a20038,0xe2f0e88f,
0xe649e3fa,0xe108e517,0xd72edbfa,0xd5bbd439,0xda85d9c8,0xd1cbd5e6,0xd948d350,0xebcbe19e,
0xfbcff577,0x06550044,0x183f0ee4,0x20441e9b,0x1c4c1ec0,0x1be51a40,0x27972221,0x254a27ba,
0x221e23cc,0x18a51deb,0x11301450,0x086d0de6,0xf8130076,0xf083f2b9,0xf244f0bf,0xf0ccf30b,
0xe884ec76,0xe51be5ba,0xea19e726,0xf136ed0b,0xfbb4f6eb,0xfea0fda7,0x035500ef,0x03340386,
0x05fb0435,0x04b5062c,0x01fd02ae,0x01c6024c,0xf7d1fe1a,0xedc6f1c7,0xe850eaa8,0xed8fe895,
0xfe2ff670,0xff7400cd,0xfed7fe1d,0x078601c4,0x16860f30,0x1b771ab9,0x184a19b6,0x1ab118fa,
0x1ec71c8b,0x226420e2,0x208d22b8,0x12ae1b29,0x017d08d7,0xfc30fe5c,0xeed0f737,0xda7fe509,
0xca49d070,0xd3b3cbe0,0xe184dc74,0xdef0e1ba,0xdabfdbf3,0xe2aedcab,0xf232eac2,0xfeb5f8b9,
0x093f0497,0x0def0bab,0x1c4513c5,0x286a233d,0x2d152c17,0x26fd2b2f,0x1d1821c1,0x1c211b73,
0x16141b16,0x06ef0ece,0xf7acfee0,0xf1d4f37b,0xf13af15a,0xf05af131,0xeb7bee16,0xea08e9fc,
0xee9febd2,0xf343f17d,0xf42cf3b0,0xfba1f6f9,0x04a10034,0x0ce208ff,0x0b5a0e08,0x03860737,
0xfd280050,0xf694f9f1,0xf43cf4bb,0xf0c3f2da,0xf437f0d9,0xf86ff7f5,0xf5eef6ee,0xf460f551,
0xf574f367,0x05affc21,0x16580f3f,0x175f18e1,0x159e1598,0x1a211732,0x247b1f0f,0x22d1265b,
0x16de1cd8,0x0fcb128a,0x0cf10e76,0x09b70b3d,0x00f40713,0xe488f4b7,0xd177d758,0xd834d2d2,
0xd95fdbaa,0xcc41d2bb,0xcd23c989,0xe3a3d6e3,0xf8b8ef61,0x01baff04,0x03860272,0x0bdc069c,
0x185d11fb,0x23681ee8,0x237f245a,0x22ff22f8,0x22c022dd,0x22a222e1,0x1d6a2147,0x06c714cb,
0xf1a1f901,0xf168f0b0,0xf43af20f,0xf808f758,0xf1fef56e,0xec41eefa,0xec96ead8,0xf57df0cb,
0xf8c2f889,0xf76df788,0xfdd5f9bb,0x0597024d,0x067706b5,0x07cc067a,0x09850936,0x00ac06ec,
0xf47af96c,0xef6bf1b6,0xeb5becd1,0xef2eec4a,0xf5f6f282,0xfc4ef9d6,0xfa0afbe5,0xfb6df9ac,
0x0189fe7b,0x09130490,0x1a5510c7,0x25ec222a,0x24a8264f,0x21082288,0x1cb61f72,0x172019ae,
0x100613f8,0x08520bdc,0xff8704b5,0xee8cf808,0xdc86e483,0xd9f2d8dc,0xdd07dcab,0xd1cbd8f8,
0xc9aacadf,0xdb89d05b,0xed68e641,0xf420f0ff,0x0376fa4b,0x15e70dd1,0x1a3319d4,0x1bf51a84,
0x1c821ce4,0x19d31b3c,0x1b1a1977,0x20241e1c,0x1e322029,0x14b01aa2,0x04d30cc4,0xfa3bfef3,
0xf1c2f5b0,0xec69eeea,0xe8f0ea2b,0xedb9ea1a,0xf3b0f136,0xf9a0f621,0xfca5fca1,0xf6d7f9da,
0xf806f5a5,0x0355fdcf,0x07f90674,0x0ac8099e,0x0a1a0b13,0x034f073a,0xf9ecff4b,0xf016f393,
0xf16df098,0xec0aef18,0xede6ebd3,0xf098efa2,0xf4acf204,0xfc4ef871,0x04cb000e,0x0f0c0a4e,
0x14071234,0x17df1592,0x1cdd1a82,0x252b1fa2,0x2e692c04,0x1e3628f9,0x0a391256,0x077e0755,
0x033406f5,0xf41ffc1d,0xe75ced6d,0xddc0e1af,0xddbddd08,0xdae0dd67,0xd2add676,0xd616d23a,
0xe46fdd21,0xeec0e9d8,0xf9a0f42f,0x03b8fe94,0x0f55093f,0x1d5515dd,0x2cb225f5,0x268d2d09,
0x17da1de7,0x16db15cf,0x1a411944,0x12811826,0x025e0a9e,0xfb3cfc83,0x01ebfe8d,0xfc64018f,
0xeb26f463,0xe048e388,0xe995e299,0xf93bf29a,0xf9c8fb16,0xfd6cf9d1,0x05650258,0x05dc05c8,
0x05c1064a,0x02a203b5,0x050f03d1,0x019903c5,0xfee70044,0xf93bfc7d,0xefeef489,0xedecede6,
0xeb30ece0,0xecb9eacf,0xf3caf012,0xf7eff646,0xff63fab3,0x08360417,0x0f270bc3,0x17141272,
0x23391d30,0x27fd270f,0x1f86256f,0x142018d1,0x14cc12d3,0x19d918b5,0x0cb215d4,0xf50800ea,
0xe891ec66,0xe90be863,0xe221e7c7,0xd0b7d926,0xcf5acd58,0xdb5cd4d9,0xe5c4e13a,0xea43e86c,
0xf121ecb5,0x0066f82f,0x0df007e2,0x17ed1332,0x1e6b1bcb,0x1efa1f43,0x1e791e79,0x21131f4a,
0x239a233f,0x13801ed3,0xfb3005a3,0xf88df72b,0xff74fc31,0xfa92ff38,0xeefdf3d3,0xf09eee23,
0xf66af3f0,0xf5abf718,0xf18af344,0xf18cf0c2,0xfcb6f58b,0x093d0400,0x0e760c62,0x0e620f3f,
0x08940bfd,0xff130405,0xf69efa4c,0xf449f4c1,0xf443f47a,0xf1dbf337,0xeffaf0cf,0xedbfeea1,
0xf32eef5e,0xf72cf667,0xf7a1f6cc,0xfe1dfa15,0x081502df,0x11640cfd,0x1c391619,0x29b023ed,
0x27852a67,0x22112468,0x1d3b1fd9,0x12e519b3,0x00d00972,0xf823faee,0xf928f811,0xf3bdf863,
0xe346ec34,0xd360da50,0xd2add099,0xdceed7c0,0xe12de011,0xe2a0e166,0xee3ce687,0x0026f7f3,
0x086c0558,0x0d840ad1,0x17431190,0x1f991cbf,0x1eb01fa5,0x1e9f1e29,0x1f4d1f78,0x18031d03,
0x0a361117,0x02700576,0xfbcefffe,0xefbcf5e4,0xec9bec1b,0xf650f0f1,0xf733f8d3,0xf1a9f392,
0xfa02f456,0x00ddfee7,0xfbfcff75,0xfa63f95f,0x02aafe60,0x099b066b,0x0bd70b7d,0x0a550b6d,
0x049207cc,0xfcc300df,0xf2c9f7b0,0xe618eca3,0xe296e1bb,0xeea4e7e6,0xf7adf463,0xf71bf840,
0xf7dff67f,0xff69fb51,0x05730324,0x095406ef,0x15870e6a,0x20491c33,0x236d2224,0x251c24b8,
0x238b24b8,0x1b3520c9,0x0b60139e,0xfe8e03e6,0xfa49fc15,0xedb8f5b0,0xdf4ee4fa,0xe18dde71,
0xe434e478,0xdb87e084,0xd6f4d7ba,0xddd6d960,0xe95ee321,0xf7ddf0a9,0x04fefe6c,0x10600b23,
0x16bf145c,0x185717d2,0x17691830,0x1b6a1823,0x21d71fe0,0x1ac01ffb,0x0d8313f0,0x05e50913,
0xffc502fc,0xf5edfb37,0xef8cf119,0xf2ecf0e8,0xf145f302,0xf1edf012,0xfb42f658,0x0087ff05,
0xfce8ffb5,0xfc97fb18,0x065c00cb,0x0e210b73,0x08700ca8,0xff990340,0xff81fe31,0x01fe015b,
0xfc2e001a,0xf1c6f700,0xe77cec56,0xe722e586,0xed0dea7d,0xf0c2eecc,0xf80df3d3,0x0019fc9b,
0x04c8025a,0x0c620867,0x11040f27,0x148b12b1,0x197d16b9,0x24651e68,0x27c0282a,0x1fe2246e,
0x14641a95,0x085a0dde,0xfebc03b5,0xf285f8d0,0xe4a9ebb2,0xda29de1f,0xda23d929,0xddfedbee,
0xe391e0ab,0xe7d3e611,0xe9bde91b,0xed8feab0,0xf938f2c8,0x0680ffdd,0x11330c9c,0x14fd13a4,
0x1a16170d,0x1df21ca3,0x1e8d1e9e,0x18831caf,0x0e2812e5,0x0bf00be8,0x08430bb6,0xf92f0178,
0xee6ef220,0xf176eeb0,0xf27cf31a,0xf14af0e0,0xf9f7f4d0,0xfe53fd98,0xfda9fd83,0x0195ff42,
0x050f03a1,0x05c605af,0x074a0611,0x08e40899,0x06370849,0xffa90305,0xf823fc4c,0xf0dcf3a5,
0xefa2f02b,0xe9f3ed48,0xeb83e8bc,0xf393f025,0xf399f4a5,0xf169f1d4,0xfac5f45a,0x0c22030e,
0x18691412,0x181618d3,0x1ab818cc,0x1f2c1cf9,0x217920f9,0x1b9a1fb7,0x11481655,0x0d210df7,
0x0ada0d16,0xfdf90576,0xed1df594,0xe096e5d1,0xdd0fdded,0xdededdbf,0xde1edf0e,0xdcf9dce2,
0xe32aded2,0xf2e8e9ee,0x0385fc46,0x05a5069c,0x03d103d5,0x0a6f062c,0x15620fa3,0x1dd91a8a,
0x1a841d97,0x17021788,0x188d1810,0x14181777,0x06e80e44,0xf8a6ff4a,0xf342f480,0xf4c6f3fb,
0xf2acf47a,0xee69eff4,0xf5eaf071,0x012ffc97,0xffa301df,0xfdb0fd44,0x043500e8,0x05e70594,
0x0a49073a,0x0df40d58,0x05560ad7,0xfd5e0050,0xfb49fbf9,0xf7aafa3a,0xececf2d0,0xe4e7e7ef,
0xe832e4cf,0xf424ee51,0xf774f737,0xf600f64f,0xfe67f8ad,0x081c0492,0x07130838,0x09510727,
0x139e0d58,0x23f11bb0,0x2c242a46,0x217f28db,0x10bf1883,0x0adb0c2b,0x0bff0ba2,0x04470a0b,
0xf226fb79,0xe793eb3a,0xe600e64e,0xe306e52d,0xdc5edfc4,0xd9c1d9f5,0xe05adc13,0xed4ae636,
0xf98bf46e,0xfda1fc11,0x05900082,0x14250c83,0x1ba619eb,0x140018e6,0x0e150fa0,0x112a0f2a,
0x15931313,0x15ea173a,0x0cc11165,0x074a09bf,0xfd6a034a,0xf1cff6f9,0xeb67eddf,0xec7aead3,
0xf62df07a,0x0086fc39,0x01bb0250,0xfedafff5,0x0478004d,0x0b2008f2,0x068a09f3,0x008f02e3,
0x00ccfff5,0x05350317,0x049905d7,0xfbb70151,0xee7cf4b6,0xe897ea64,0xec11e938,0xf02eef06,
0xef4ceff4,0xf0c7ef34,0xfb83f55a,0x04e900f4,0x076f0709,0x09940787,0x12fe0e0e,0x1bbf17aa,
0x20241ee0,0x1fb6200d,0x1ee01f72,0x19661d1d,0x0c7c135b,0x0066063b,0xf4c3fa6e,0xeb58efc6,
0xe6a5e80d,0xe774e6fb,0xe585e732,0xdf32e26c,0xdfd2ddd5,0xe918e46d,0xeff8ecb2,0xf763f3aa,
0x0159fb9c,0x0e53085c,0x15541253,0x183e179a,0x15f91708,0x14d415c4,0x0e21120d,0x0a0e0b6d,
0x07e20930,0x064306d1,0x05f70667,0x01380435,0xf9b2fd80,0xf335f664,0xeef3f072,0xf1b6ef67,
0xf7ccf4c6,0xfeddfb27,0x046c021a,0x08b7066c,0x0ad70a8f,0x092f0a0c,0x07550886,0x020f04ff,
0xff320002,0xfc77fe54,0xf5c2f960,0xedecf1a3,0xeaa2eb9a,0xea9bea77,0xeb12eab4,0xf034ec69,
0xfb8ef5c4,0x03bc0039,0x05db057e,0x078b062c,0x0e530a49,0x188313a4,0x1d4c1baa,0x1f321e73,
0x1d101f04,0x15aa198e,0x0f481231,0x097b0c66,0x00fd0629,0xf15df972,0xe690eac0,0xe5dce4e7,
0xe6d9e741,0xe2f1e4ba,0xe37fe284,0xea03e605,0xf1faee8a,0xf472f3be,0xf69ef540,0xfe4ef965,
0x0dfd0594,0x1a6f1548,0x1a831c30,0x127b1670,0x11241098,0x12f2125b,0x0fc5124d,0x03950a83,
0xfad4fdaa,0xfcf4fb37,0xfeb2fe7a,0xfa8dfd1d,0xf5dbf7fc,0xf577f4d0,0xf9ccf7cc,0xf910fa05,
0xfb8ef91a,0x0448ffcb,0x0bd70882,0x0e650e03,0x0a940d10,0x05210799,0x012f0331,0xfbbafed5,
0xf3a9f816,0xeca6ef90,0xebb2eb83,0xee33ecc7,0xf054ef96,0xf04ff058,0xf571f1d4,0xff79fa90,
0x03e302b0,0x054d0438,0x09f90735,0x12190dbb,0x19e81656,0x1da31c70,0x1ad31cd1,0x18121911,
0x16fd17d3,0x0eea1424,0x004b07db,0xf3a9f91f,0xf118f125,0xf1acf220,0xe8e4ee56,0xdf80e35a,
0xe096de62,0xe781e45b,0xec4be9b1,0xf215ef1c,0xf8cdf513,0x009cfcc0,0x07f4043f,0x0ef60bc6,
0x121c10b5,0x16bd1442,0x18321832,0x146e170a,0x0bab106c,0x04c207ac,0xff870251,0xfc00fd33,
0xfb11fbb0,0xf764f95f,0xf76bf65e,0xfe59fa77,0x01f50129,0xfe4e00ba,0xfb37fbd8,0xff38fc97,
0x01b9011b,0x019f017f,0x050d02f3,0x0a1707d0,0x09fb0b1a,0x034f071e,0xfc27ff8b,0xf40ef863,
0xeccbefc3,0xe94aeabe,0xe8efe895,0xebdee9f4,0xf52eef7d,0x00fefba3,0x03aa03bc,0x01b50222,
0x07d403c5,0x0ee60c13,0x11201030,0x161212fe,0x1d3919ea,0x1e341ec4,0x19df1c66,0x128a16dc,
0x06470cf1,0xfb2c003e,0xf3aef72f,0xed79f093,0xe78eea52,0xe4aae595,0xe75be534,0xebebea34,
0xea4beb92,0xeb59e9a1,0xf526ef7d,0xff63facc,0x058e02c2,0x0b740855,0x11090e96,0x11d6121d,
0x108b1141,0x0cfa0f28,0x0b8a0b5e,0x0df20cf4,0x0c200db8,0x024c0831,0xf9bffce7,0xf92cf8f5,
0xfb24fa11,0xf9a7fb24,0xf6a1f7d2,0xf9f0f742,0x0291fe60,0x057c0519,0x032a04d3,0x000a010f,
0x04170127,0x05db0629,0x01f103da,0x00c600eb,0x023b012f,0x005d025d,0xf74ffc65,0xee16f277,
0xe7edeaad,0xe6a9e673,0xec1ce8bc,0xf45af00e,0xfcc9f878,0x0613014d,0x0dd30a32,0x13351130,
0x112912f4,0x10700fe0,0x158f12a5,0x1984181a,0x185c1974,0x13c4168d,0x0bb9100e,0x02bf072e,
0xfa78fe90,0xf1e6f64f,0xebdaee25,0xe9b1ea7d,0xe84ee8e3,0xe7b2e7b7,0xebc6e912,0xf197eee5,
0xf4dcf39a,0xf48df4f1,0xf800f510,0x03ccfd4c,0x0edf0a0e,0x13951225,0x121d1325,0x11ce11ad,
0x104c1147,0x0cea0f0e,0x05a50995,0x01e702f3,0x00fe01b5,0xff04ffef,0xfca9fe79,0xf650f977,
0xf558f4be,0xfb11f7b3,0x0078fe42,0x01950176,0x001600b2,0x04e9012d,0x0c840952,0x0a920cea,
0xff8d057e,0xf9a9fafb,0xfd09fb35,0xfcc3fda2,0xf8fffb37,0xf47af66a,0xf2e3f392,0xf086f1c2,
0xee04ef4d,0xed9aed28,0xf260ef83,0xfd03f6e6,0x091103a7,0x0e2c0c53,0x119e0fde,0x15c913ab,
0x185c1775,0x155417a4,0x0fba123b,0x0ef40ede,0x0eff0f52,0x0a760d72,0x0234066e,0xfb2ffe53,
0xf508f86a,0xec31f093,0xe75ae8f7,0xe72ce6e0,0xe859e7c4,0xeb44e96b,0xef47ed6d,0xf307f0e6,
0xfb53f676,0x058b00ba,0x0ac008c8,0x0d160c0e,0x0e4e0dd6,0x0fec0f1e,0x107f109a,0x0dab0f5f,
0x09e70bf6,0x02f60699,0xffd4008f,0xfe1eff54,0xfc39fcab,0xfe39fd05,0xfd06fe47,0xfaf3fb8f,
0xfb8efb21,0xfdcffc70,0x00caff8e,0x03aa021b,0x074c05b8,0x06ae07a3,0x033a04e6,0x01b1024d,
0xfe91008d,0xf9f7fc52,0xf5f5f782,0xf58ff5ad,0xf3b7f4a9,0xf535f401,0xf679f614,0xf6c9f6c9,
0xf34bf556,0xf22cf1c6,0xf9f0f4bf,0x04a9ffec,0x0907076f,0x0fd70bb8,0x1a7c153d,0x20bb1ee2,
0x1b341f61,0x117715f2,0x0bc30e2f,0x06870920,0x018603de,0xfcc9ff26,0xf753fa38,0xf266f478,
0xeffaf12a,0xebecee3c,0xe8b7e9e7,0xe918e86e,0xee32ead5,0xf4dcf1f5,0xf6eff627,0xfc70f8d1,
0x04c700c1,0x0b490822,0x10ea0e41,0x104611c1,0x0a3f0d06,0x097208ed,0x0b5e0aa5,0x088d0ab9,
0x023b0551,0x01fe0104,0x03f303ba,0xfe5001c0,0xf8a5fb09,0xf89df7b8,0x0002fbd8,0x021402b9,
0xfa4cfe69,0xfa65f893,0x0317fea0,0x093906fd,0x087909bc,0x02fd0607,0xfdf9001c,0xfdd4fd3b,
0xffa0ff14,0xf9a6fdd6,0xefc3f458,0xee11ed4a,0xf51bf160,0xf5bff6a5,0xf331f406,0xf630f400,
0xfde2f9af,0x04e6020d,0x04210585,0x02ea0270,0x0eb90717,0x1d1616f6,0x1ec61f7b,0x181f1bd1,
0x12c714f4,0x0d4c1088,0x039808c8,0xf8ddfe59,0xf206f468,0xf3d0f238,0xf6dbf5d7,0xf3dcf64b,
0xeec3f0cf,0xef2fee6e,0xf07ef037,0xed9def83,0xecbfec36,0xf359ef25,0xff47f8b5,0x0a8305d7,
0x0bc40c31,0x0ae40ac0,0x0f550c76,0x13e0123b,0x0e151290,0x03a3084f,0x01290170,0x03a40230,
0x054804f3,0x0116040f,0xfa4bfd3a,0xfb9cf9c4,0xfefbfe0c,0xfb30fdde,0xf782f87e,0xfe31f975,
0x07c7039b,0x0830092b,0x03ef0605,0x025802ba,0x02df028c,0x016202d1,0xfb9cfeb8,0xf62df8d8,
0xf320f42b,0xf457f35c,0xf64ff576,0xf4bef626,0xf1faf320,0xf600f2f0,0xfe3dfa57,0x024000c1,
0x033a02d2,0x055803bc,0x0bdc0830,0x10bf0f0c,0x109110fb,0x12ab10f9,0x170a1530,0x16621780,
0x0fb913c2,0x05bb0a97,0xfd52018d,0xf3d3f896,0xee96f04f,0xed9cedf1,0xed54ed83,0xef3eedd5,
0xf400f193,0xf55bf53e,0xf2b5f456,0xf12bf155,0xf42bf222,0xfc6ef792,0x06f401f5,0x0c720a5c,
0x113c0e9a,0x14b713c9,0x0f8c1329,0x07a50b28,0x055405c8,0x045d0526,0x00060280,0xfc28fdb7,
0xfbcffb7d,0x0094fd80,0x05a10408,0xff9703b1,0xf948fb58,0xfc25f9c8,0x006efeca,0xffa90050,
0x01d4ffc9,0x072404ec,0x044906db,0xff320158,0xfc24fdb7,0xf95ffa92,0xf8ddf8e1,0xf8bff8dd,
0xf7fdf881,0xf589f6d9,0xf2eef40e,0xf3d9f2a9,0xf9e8f680,0xfe05fcca,0xfd86fdd2,0x01e7feec,
0x096f05e7,0x0d900c13,0x10450ecc,0x146d1259,0x160f15ed,0x11591460,0x0cfb0e78,0x0c200ca5,
0x06aa0a24,0xfd99025f,0xf4cff8d8,0xef9bf1db,0xeb58ed8a,0xe7fee946,0xea0ce802,0xf279edea,
0xf870f632,0xf9caf984,0xfb71fa54,0xfdc7fcfa,0xfe42fdfc,0x00f4ff56,0x04380271,0x0a6f06ca,
0x11760e4d,0x12a31319,0x0ca6102e,0x080009bf,0x053b06e2,0xfffd02d1,0xfc40fd95,0xfcb4fc1c,
0xff14fdda,0xffc3ffdd,0xfdbefeb5,0xfe98fdc3,0xfe84ff07,0xfd33fd84,0xfffbfe30,0x0236018e,
0x013801e0,0x01df0127,0x056c03b3,0x012d04ee,0xf764fbd5,0xf5dff587,0xf956f7aa,0xf965fa15,
0xf4a8f77c,0xf1f8f262,0xf59bf367,0xf98df7c1,0xfd73fb53,0x01b8ff75,0x0743044e,0x0cfa0a5d,
0x10c70f22,0x1185117a,0x107c1111,0x0f710fcf,0x0fb00f85,0x0db40f4d,0x070c0ad7,0x0074035b,
0xfd13fe98,0xf8a5fb55,0xf269f599,0xed23ef8c,0xeb52ebad,0xed0bebdf,0xeef8ee01,0xf0a8efb4,
0xf6e2f2d7,0x008ffc09,0x039a0327,0x02de0303,0x04b3039c,0x04e50507,0x0649050f,0x09bc07f9,
0x0dbd0ba6,0x10b50fa9,0x0f8510c8,0x09290cdf,0x002c04b1,0xf9b8fc55,0xf82df88a,0xf981f896,
0xfc60fb04,0xfd1dfd1c,0xfe34fd29,0x013dffc2,0x042c02e8,0x03530473,0x0056014d,0x00fd0071,
0x001f00e2,0xfcfefed5,0xf9dafb4c,0xfb4ef9db,0xfda2fd1e,0xf935fc45,0xf24df55a,0xf387f193,
0xf9f0f6d2,0xfb4afb97,0xf881f9cd,0xfbb3f910,0x0336ff7e,0x085e0637,0x0c160a4b,0x0f3c0df1,
0x0ff00ff3,0x0fd80fdb,0x0f880fde,0x0d100e95,0x09700b56,0x061c07ae,0x039e04e1,0xfee901ac,
0xf6a1fafc,0xef5ff26d,0xed54edcd,0xecdeed3b,0xea80ebcd,0xec72ea58,0xf3d9f00e,0xf815f65d,
0xfc4ef9b8,0x0403ffa9,0x0b650839,0x0ca70cf1,0x08b20b04,0x062f06b7,0x07ee06f1,0x095008d7,
0x08860948,0x078d079f,0x0a3908b2,0x09fb0afb,0x024706de,0xf80dfce1,0xf506f550,0xf8dff68e,
0xfca5fb2a,0xfe11fd8c,0x000efeca,0x043301ed,0x062905d4,0x036704ff,0xffbe0195,0xfb6cfd78,
0xfa2bfa54,0xfad6fa83,0xfb35faf9,0xfc5bfbae,0xfd6ffcfa,0xfce0fd7c,0xf8b1fb28,0xf33bf5c6,
0xf2d1f20c,0xf95af587,0x008dfd8f,0x0358027c,0x07b104e4,0x0ef10b70,0x1191110e,0x103a10f2,
0x0f9a0fc5,0x0ebf0f4c,0x0d3e0df9,0x0a360c0e,0x03bf071e,0xfe8200bd,0xfaa1fca7,0xf5edf871,
0xf086f32e,0xebf9ee20,0xeb03eab9,0xef3aeccc,0xf1bcf10f,0xf18af1aa,0xf602f2b9,0x01d4fb9e,
0x08870693,0x06e0082b,0x075f0654,0x0bc10999,0x0c810ce6,0x097a0b26,0x069e07c1,0x056105da,
0x063e0572,0x07ee077a,0x04cb06de,0x022802fd,0x017801eb,0xfdc90028,0xf6abfa7b,0xf17ff34b,
0xf4b1f1ea,0xfe39f947,0x05b80288,0x06ef0738,0x0458058b,0x03e603eb,0x01f10367,0xfd3dffe9,
0xf76afa47,0xf55cf586,0xf951f6f5,0xfc5efb6d,0xfaa8fc11,0xf89ff938,0xf9f5f90a,0xfa6ffa9e,
0xf7b9f956,0xf8aff702,0x031afd0c,0x0e080944,0x11b410de,0x110e1164,0x10ec1105,0x0ed1102e,
0x0b820d40,0x083809bc,0x06920718,0x04f8060a,0xffec02c8,0xf920fc9e,0xf28df5b4,0xeeeaf03a,
0xee85ee72,0xef4feed7,0xef0aef6a,0xeeb4ee7c,0xf39af079,0xfb35f76f,0x0057fe26,0x032101e9,
0x07d3050b,0x0d690ae6,0x0f4b0ed3,0x0d890eb9,0x0a0e0bba,0x08c8090e,0x08e608df,0x066e081d,
0x01ba0424,0xfe1affac,0xfe60fdbc,0xff22ff1f,0xfde6fe97,0xfc78fd67,0xf8edfabf,0xf7d1f7c8,
0xfabff8df,0xff7cfd33,0x03360186,0x062504a1,0x07610731,0x03550605,0xfd4e0019,0xfa24fb5e,
0xf78ef901,0xf659f69b,0xf75cf6cc,0xf8bbf808,0xf9dff94b,0xfc06fab8,0xfe3dfd46,0xfe99fea3,
0xfe8bfe7a,0x0086ff19,0x05c102b4,0x0cab092d,0x11b40f83,0x133e130b,0x10cc125c,0x0ddd0f70,
0x09320bb6,0x052b070a,0x01af0376,0xfd6affd7,0xf7d8fac0,0xf24df508,0xeebaf00b,0xede5ee1c,
0xecd3ed5a,0xecbbec84,0xf0a5edfa,0xf7fcf460,0xfc40faa5,0x0002fdd5,0x06770333,0x0b310949,
0x0cfd0c44,0x0f330e0a,0x0f350ff6,0x0abb0d38,0x079208a5,0x065006f8,0x027d04da,0xfdb8ffe3,
0xfcf9fcb9,0x0034fe53,0x00a00122,0xfba5fe67,0xf85ff975,0xfaf1f8e6,0xffe2fde0,0xfe48fff9,
0xfa38fbcc,0xfc5efa5f,0x0200ff47,0x05a30452,0x057f0619,0x02cd0445,0xff8d0127,0xfbd8fdb0,
0xf73ef9ae,0xf350f4e9,0xf2f4f294,0xf6bdf456,0xfc98f9b2,0xfed0fe72,0xfe17fe48,0x0172ff10,
0x081304e5,0x0aad0a31,0x09140a12,0x095408ac,0x0ed30b88,0x14731222,0x133714e5,0x0bbd0fc8,
0x060c0855,0x00e603da,0xf7dbfcb4,0xef85f329,0xed39ed78,0xf00bee6e,0xf130f13a,0xeed5f025,
0xef04ee48,0xf4fbf17d,0xfafef887,0xfce4fc34,0xfff9fdf9,0x05f802c5,0x0c380957,0x0ee70e34,
0x0e230eba,0x0ca60d5f,0x0cc40c62,0x0ce80d4c,0x06d50ac4,0xfe3101fe,0xfcabfc58,0xfea2fdce,
0xfce1fe2c,0xf960fb11,0xf8cdf87d,0xfc64fa4b,0xfebbfe14,0xfd44fe55,0xfc03fc28,0x0002fd80,
0x03a4027d,0x01a20316,0xff1d0013,0xff41fea5,0x02ba007d,0x063204ec,0x01b40526,0xf78ffcd3,
0xf14af377,0xf1ccf106,0xf42bf2d5,0xf670f55a,0xfa49f7ea,0x0264fddd,0x0aac0723,0x0c810c66,
0x0a9b0ba0,0x0a690a08,0x0cef0b85,0x0d830dcc,0x0abb0c38,0x0ad10a14,0x0e0a0c7b,0x0bae0e16,
0x01220703,0xf627fb3b,0xefeef27b,0xec42eddf,0xea94eb1e,0xebfeeadc,0xf0c6ee01,0xf614f3aa,
0xf875f7c1,0xf92ff8c4,0xfbc3fa1c,0x016afe44,0x08b2052f,0x0db40b9b,0x0ef00ed8,0x0f350ebf,
0x11fb1088,0x1055123b,0x07670c86,0xfe82024c,0xfd35fcc7,0xff1ffe6c,0xfc33fe4e,0xf7e6f9be,
0xf7fcf745,0xfb1cf968,0xfcfafc67,0xfd15fd02,0xfea9fd89,0x00e8ffe9,0x01df019f,0x02110215,
0x026a0233,0x01c6027d,0xff7000a2,0xfe8dfea2,0x001fff62,0xfee20019,0xfb41fcf3,0xf868f9b4,
0xf64bf745,0xf36cf4f6,0xf289f23e,0xf7e6f44a,0x019dfc8b,0x0a1e0672,0x0dfd0c9b,0x0f8b0eeb,
0x0f2f0fb5,0x0beb0dd1,0x09f90a70,0x0b9b0aa4,0x0c2d0c3f,0x09670b41,0x055f074e,0x016203a1,
0xf9f5fe23,0xf0dcf56b,0xe9f9ecde,0xe825e875,0xe925e863,0xed53ead3,0xf3e9f08c,0xfb4df771,
0x0211ff11,0x044103bc,0x0492044e,0x07050574,0x0b74093d,0x0ead0d65,0x10640fa1,0x10b410da,
0x0ca80f2c,0x074a09e3,0x020304d1,0xfc7dff50,0xf863fa35,0xf6e2f727,0xf8edf789,0xfb0cfa44,
0xfb0ffb28,0xfbf2fb42,0xfd83fca7,0x0028feb2,0x02ea0199,0x045f03c8,0x03550436,0x000f019d,
0xff27ff1e,0x01d80046,0x02e30309,0xfe910138,0xf953fb84,0xf91af87e,0xfa1cf9e8,0xf86cf981,
0xf55cf6fd,0xf37ff3f5,0xf7a7f4b8,0x000efbd8,0x06ae03b8,0x0be90954,0x11110ea0,0x142012ff,
0x13a41458,0x0f5811f6,0x09390c3f,0x05d206fd,0x0517055f,0x02bc0473,0xfb4cff92,0xf3acf6de,
0xf10df1fe,0xef77f03d,0xed65ee8a,0xeb10ebfd,0xed10eb5d,0xf273ef85,0xf932f5bd,0xffcffc97,
0x06ae0327,0x0ceb0a30,0x0dbb0e06,0x0cd30d16,0x0d960d2e,0x0d5d0dc4,0x0c0e0cc1,0x09f50b49,
0x06050815,0x014403b1,0xfc67febc,0xf8b5fa6f,0xf658f74f,0xf63df612,0xf758f6b7,0xf9c8f85c,
0xfcdcfb57,0xff4efe23,0x020c007a,0x051603a4,0x05c105e0,0x03a404db,0x028802b4,0x034302c4,
0x015102f6,0xfbe1fec1,0xfa1cfa3a,0xfc9ffb46,0xfb43fcc0,0xf568f870,0xf2b6f33e,0xf5d8f3cd,
0xfa69f848,0xfdb2fc2e,0x0164ff59,0x06c103ec,0x0c4109a7,0x0f670e26,0x110c1058,0x125611c1,
0x11bc1262,0x0e5f105e,0x089c0bb4,0x015f0504,0xfa9afdcc,0xf550f7d6,0xf1c4f323,0xeff9f0da,
0xee14eeeb,0xee8aedf6,0xf001ef58,0xf1b6f0c2,0xf3d3f2d4,0xf811f53d,0xffddfbdc,0x06610367,
0x0c530955,0x12460f67,0x15b11499,0x122f14e2,0x0b260e9a,0x079408ba,0x058e06d3,0x01410395,
0xfe17ff92,0xfbc0fcfa,0xf9aefab3,0xf833f8dd,0xf66ef776,0xf4bff54d,0xf7aaf587,0xfddefaa5,
0x028e0069,0x05ca0445,0x076306ef,0x06900741,0x04b5058b,0x03aa0417,0x00f502ac,0xfd1cfeff,
0xfb68fc06,0xfa47fb01,0xf920f989,0xf89af8e3,0xf813f85f,0xf763f7ca,0xf65df6c6,0xf78ef65d,
0xfdc9fa2f,0x04d10150,0x09c4078d,0x0d040b6f,0x0ffc0e8f,0x11841110,0x10b01155,0x0f780ffe,
0x0def0ee4,0x0a1a0c62,0x033e072b,0xf896fe60,0xee04f2e9,0xe9f9eaef,0xec63ead8,0xee7ced9d,
0xf04eef5c,0xf1e3f10b,0xf5ebf37b,0xfad3f8a3,0xfc4cfbfd,0xfd1cfc65,0x03e1ff68,0x0f8b09d2,
0x1523137e,0x143d1506,0x12fb1377,0x10881222,0x09890dba,0xfef3045b,0xf77dfa47,0xf792f6d7,
0xfa78f903,0xfc37fbce,0xf9fefb7c,0xf782f888,0xf81df768,0xfadff98d,0xfc1efbb3,0xfeeffcfe,
0x049901a6,0x08cf0700,0x0ac40a17,0x08e90a76,0x03970669,0xfece00de,0xfc00fd12,0xfa31fb16,
0xf81df914,0xf798f785,0xf813f80d,0xf60ff75e,0xf4d7f4ee,0xf8d6f646,0xfe8bfbcc,0x01780056,
0x02ec0214,0x08cb0511,0x11440d43,0x13db1393,0x10bb128d,0x0e580f33,0x0e0f0e19,0x0ca80dd9,
0x070e0a60,0xfe9e030f,0xf630fa1c,0xf108f34b,0xec7feee4,0xe7a4e9de,0xe766e699,0xee1dea0c,
0xf687f26b,0xfd1efa17,0xfef2fec1,0xfe6cfe60,0x02c0ffed,0x09e20662,0x0dfb0cb2,0x0e6a0e42,
0x117e0f63,0x14c913af,0x10f213db,0x07c30cb1,0xfed002e4,0xf916fb83,0xf613f75e,0xf4c1f531,
0xf4b7f49b,0xf69df549,0xfb1ff8af,0xfe1afd18,0xfe30fe5a,0xfe8dfe2c,0x0059ff4a,0x044e0221,
0x086e0690,0x09760951,0x07e208d2,0x059c06e0,0x01c80408,0xfb35fed0,0xf50df7b8,0xf2d1f36c,
0xf493f345,0xf7b1f640,0xf826f853,0xf76df797,0xf9baf823,0xfe7efc03,0x036a00dd,0x088005f9,
0x0cae0ac0,0x0ec80e0a,0x0f700f0a,0x112e102d,0x11171188,0x0e530fe4,0x09cb0c41,0x02850687,
0xf9bbfe2c,0xf35cf61c,0xef37f14c,0xeb07ed08,0xe912e9ba,0xeb12e992,0xf023ed70,0xf55af2d4,
0xfa77f7d0,0xff9ffd05,0x05a3025f,0x0b2808e8,0x0bfa0c08,0x0ceb0c26,0x100f0e71,0x122911a5,
0x0ffc11c3,0x0aca0da8,0x043a07b5,0xfd02007a,0xf8f1fa65,0xf7bff835,0xf5acf6ea,0xf2a9f420,
0xf226f1c2,0xf87df486,0x0028fce5,0x02a201f7,0x032202c9,0x059d041f,0x08380735,0x075f0843,
0x047805e0,0x037c03af,0x035a037e,0x01c002cc,0xfdd50028,0xf7b1fac1,0xf310f4f4,0xf219f20c,
0xf31af2a3,0xf3ebf345,0xf884f594,0xffb0fc2a,0x0449027d,0x0637054d,0x09a20799,0x0e0d0bcf,
0x11350fd5,0x114611d5,0x0df40fdb,0x0be50c66,0x0c930c32,0x09af0bf4,0x009005aa,0xf680fb1b,
0xf1b5f37b,0xeda1f00b,0xe7c9ea99,0xe699e647,0xecaee8e7,0xf510f122,0xf94cf7cb,0xfb3cfa2b,
0x003dfd37,0x08b5045a,0x0e6f0c65,0x0ec10eea,0x0fcb0efd,0x10e5109e,0x0fcb1097,0x0c0a0e67,
0x04c108b9,0xfe47011f,0xfbb6fc85,0xfa8bfb58,0xf709f925,0xf3f7f51d,0xf4c1f3ec,0xf73ff5e1,
0xf972f87b,0xfa8dfa0d,0xfe60fbce,0x06ae0229,0x0d310aa9,0x0cc70dc5,0x08690ab7,0x046e0636,
0x01e00329,0xfee3007d,0xfb33fcf6,0xf7eef943,0xf75df740,0xf7a8f7d0,0xf4b5f6b5,0xf0dcf273,
0xf257f0bf,0xf7c1f4e2,0xfd53fa93,0x0473008b,0x0c92089a,0x11500f8e,0x1091116d,0x0e600f5e,
0x0d4e0db7,0x0d780d41,0x0d650db3,0x09950c18,0x029c0629,0xfd54ffa8,0xf91bfb65,0xf264f61e,
0xeb78ee99,0xe9f7e9d0,0xedc0eb87,0xf1deeffc,0xf5a3f3b4,0xfa59f7b6,0x0157fd99,0x079904fc,
0x09670902,0x09530962,0x0b0009cb,0x0f0e0cdb,0x10691084,0x0af30e70,0x031806de,0xfe5c003a,
0xfbc6fcfb,0xf8abfa4e,0xf596f6ec,0xf4e0f4d6,0xf746f5c7,0xfa83f910,0xfbdffb68,0xfd75fc73,
0x01a3ff39,0x06ce043f,0x0a8908ed,0x0c9d0bb2,0x0dd10d5e,0x0ce10dcb,0x084c0b08,0x016204ed,
0xfb03fe09,0xf647f879,0xf35af47f,0xf2f4f2f0,0xf34ff331,0xf387f373,0xf3edf3a4,0xf568f47a,
0xf798f678,0xfb68f906,0x0299fea0,0x0a10068b,0x0ff00d29,0x1436125a,0x14dc1531,0x1017131b,
0x09b80cc6,0x065007a1,0x044d0567,0x012302e2,0xfd0bff45,0xf7defa90,0xf397f574,0xf186f256,
0xeff2f0c1,0xef4cef58,0xf2bff06a,0xf9ecf614,0x0072fd6f,0x051602f0,0x081b06d0,0x09bc0912,
0x0a580a24,0x0a020a41,0x08750966,0x05bd0741,0x029e0434,0xff46010a,0xfc2ffda7,0xf959fac5,
0xf6a6f7f3,0xf508f5a9,0xf519f4c4,0xf7ebf613,0xfd24fa76,0x00f6ff3c,0x0389023f,0x06d90500,
0x0b1a08f4,0x0df70cdf,0x0e2c0e5f,0x0d470dc2,0x0c080cc5,0x09230ae6,0x031806a6,0xf98bfeae,
0xf0b7f4ba,0xed43ee2f,0xeeceedc3,0xf039efa2,0xf1b1f0d3,0xf42af2c5,0xf849f606,0xfc74fa96,
0xfea3fdc9,0x00c2ff7f,0x069302fa,0x0fb40b2e,0x14971310,0x13d514a2,0x121912ee,0x0f611111,
0x08980ca2,0xfe71039b,0xf74af9ff,0xf6d5f674,0xf864f7ad,0xf875f8c0,0xf607f764,0xf451f4e4,
0xf578f48c,0xf8a7f709,0xfb09fa00,0xfe88fc58,0x04ca0174,0x09e807ac,0x0c370b65,0x0b140c21,
0x0756094e,0x03d9056b,0x00900229,0xfd18fed4,0xfa05fb61,0xf8c8f919,0xf851f8b5,0xf602f75c,
0xf4a9f4e5,0xf7b1f5af,0xfca0fa2c,0xffc8fe79,0x0190009f,0x06de0390,0x0e750ada,0x112d10ae,
0x0eeb104c,0x0d190db8,0x0d270d0d,0x0c0d0d15,0x06ae09ea,0xfe7502be,0xf6a4fa31,0xf223f416,
0xee01f039,0xe971eb89,0xe927e873,0xef43eb93,0xf6ebf335,0xfcf6fa25,0xff7dfec7,0x0033ffa7,
0x047401d7,0x0ac307ad,0x0e850d4b,0x0ed10ec8,0x10e20f68,0x13451281,0x0fcb1263,0x07790bff,
0xfee902e3,0xf8e1fb86,0xf541f6dd,0xf393f425,0xf3a0f372,0xf573f438,0xf997f758,0xfcb4fb8a,
0xfd72fd3c,0xfe5cfdc2,0x005cff34,0x0466022d,0x089e06af,0x0a1f09af,0x095909ea,0x0754088c,
0x035b05ac,0xfcdb005d,0xf6bdf974,0xf3f4f4e8,0xf4bef3f1,0xf736f602,0xf7b9f7cc,0xf74ef753,
0xf9acf819,0xfe1efbd4,0x029e0047,0x076d0502,0x0bae09ae,0x0e1d0d33,0x0efb0e85,0x10a70fb6,
0x109110fd,0x0de70f6c,0x09710be0,0x025a063e,0xf9e0fe2a,0xf3acf65e,0xef95f1a1,0xeb89ed75,
0xe9baea51,0xeb9fea37,0xf06eedda,0xf58ef30b,0xfabcf80c,0xffedfd54,0x05d102a5,0x0b490904,
0x0c580c43,0x0d470c90,0x10070e9e,0x11d51169,0x0fa81164,0x0a8c0d5e,0x0412077e,0xfcf10060,
0xf8d5fa53,0xf78af80c,0xf56ff6af,0xf267f3e2,0xf1d2f176,0xf81ff42b,0xffe9fc8e,0x028801cb,
0x031702bc,0x058e0410,0x0839072a,0x07860858,0x04b80614,0x03c703f6,0x03ab03cd,0x021b0323,
0xfe260082,0xf7e8fb07,0xf32df51d,0xf227f221,0xf31bf2ab,0xf3e0f340,0xf86df582,0xff92fc11,
0x042f0261,0x06210536,0x09830780,0x0de50bad,0x110d0fac,0x112a11b2,0x0dea0fc8,0x0be10c61,
0x0c8a0c2f,0x09a30be9,0x008b05a0,0xf684fb1b,0xf1b9f37f,0xedaaf00f,0xe7dceaa7,0xe6abe65b,
0xecb7e8f5,0xf514f128,0xf951f7ce,0xfb41fa2e,0x003ffd3a,0x08b6045b,0x0e710c67,0x0ec30eec,
0x0fcb0eff,0x10e3109e,0x0fcb1096,0x0c080e65,0x04bf08b6,0xfe46011e,0xfbb6fc84,0xfa8afb57,
0xf708f925,0xf3f7f51d,0xf4c0f3eb,0xf73ef5e0,0xf971f87a,0xfa8dfa0c,0xfe60fbcd,0x071e0229,
0x00000513,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_timpani_timpani[3968] = {
0x00000000,0xfff9fff5,0xfff9fff5,0x0004fff5,0x004fffd7,0x010dff91,0x0f21fd95,0x4fbb460b,
0x598a625b,0x40225439,0x1dc43113,0xcebe1dfc,0xa00faa38,0x8dee95d9,0xa37e9a5c,0xc251ae3d,
0xce93bae0,0x0511d76d,0x3eb12a28,0x4c583de2,0x57c249d3,0x71fb4441,0x23dd71fb,0xe630f1b5,
0xe648e7ed,0xeec9ef46,0xcda5dd06,0xb7a1c669,0x8ede8dee,0x8dee8dee,0x8dee8dee,0xc0548ff3,
0x0a45edec,0x71fb5de5,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x63ea65a4,0x1d0f436b,
0xee5d0f5a,0xe57305f9,0xb625c17f,0x8deeaa98,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xc0a68dee,0xfbd5dff8,0x3d3529ab,0x55755d07,0x67ae6ddf,0x71fb71fb,0x4f7e71fb,0x13161b8c,
0x1d472442,0xfa441de7,0xcf52e857,0xd173e353,0xe3c8e00a,0x0295e5f9,0x0f271317,0x2b7b286d,
0x22d1246c,0xa55de909,0xd89caf6a,0x38f2130d,0x53b04e5a,0x3fcc54bc,0x0adb2513,0xf0652688,
0xd155e5e1,0xfba9dd25,0xf8551268,0x9d19b5bf,0x9acea20f,0xad5bb3e4,0xed96daf5,0xf3e2f0de,
0x10511045,0x4bf33ede,0x2b5b3d9b,0x29bb3343,0xffc50b15,0x0027ebe8,0xfec7f3a9,0x10b60585,
0x2b5f16fb,0x11ff1190,0xdf53f16d,0xeca9de8c,0xd533d6a4,0xcb59bbe0,0x0a3cd75a,0x2ffe10b0,
0x51a051c1,0x4d464a90,0x71fb558f,0x4c346c85,0xe693195c,0xc947d26b,0xb29bcfe6,0xd9cfc45b,
0x05d9e1d2,0xf35a17dc,0xe47fe2b5,0x9e06a4c7,0xc216b13e,0x004bdab5,0x14061d0b,0x00cafd35,
0xff13ef19,0x288f131d,0x3ce019c6,0x2b4f3101,0x04c10d54,0xc8fbea58,0xa9669f86,0x8deeb3ed,
0xc2fba7ce,0xf0a8ce3f,0x0d69f6ef,0x41e33da6,0x48ae4ae9,0x5d2c3a27,0x65f8634d,0x4b764493,
0x5810406f,0x4a9b649b,0x4343455f,0x2c0c4275,0xe114030a,0xb1e6cd24,0xc151b261,0xa540ac33,
0x8dee8fcc,0x8dee8dee,0x8dee8dee,0x91fb8dee,0xe178bead,0x15e3f073,0x063211a2,0x20a40606,
0x4ae02a5e,0x662c5d72,0x4da64ee4,0x3b7d34a9,0x29b54196,0x42eb351b,0x491b4bf0,0x599d6206,
0x2c094a20,0xed231a6f,0xcd85ea5b,0xe852d9a6,0xf8adfc73,0x1b280bb1,0x22ad224f,0x1562130a,
0x0ecc125f,0xf0b70311,0xbec9f2c8,0x909eaec4,0x8dee8dee,0x8dee8dee,0xc16f9eb2,0xa6ffb95f,
0xdb97b77b,0xf408db2f,0xf6abfaf8,0x058501cb,0xfbd80c9c,0x0ea10add,0x36792da4,0x67ac4ba2,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4ca36dc4,0x3e9f3f5b,0x067e1bcb,0x085afcfa,0x01461670,
0xe891fff2,0xe74aecef,0xfc92f08b,0xf4d7f80c,0x987dc84c,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0xb84c9a36,0xbb70c776,0xc9b5cbaa,0xc9ebd25d,0xfaa7d65b,0x31b420a0,0x36262852,0x3a6e340e,
0x37cd3a0b,0x5a4b49e5,0x71fb6b6a,0x71fb71fb,0x71fb71fb,0x6bf96d27,0x34275100,0x2c1831b4,
0xeb3d2305,0xe341e747,0xd083cb12,0xe01dc9e5,0xea3adc7d,0xcc09dcd0,0xc3c9cab1,0x93e4a51c,
0x8dee8dee,0x8dee8dee,0x9c468dee,0xaef2a646,0xc838b98a,0x1a70ef95,0x11b4ffec,0x28fe19ea,
0x0a971634,0xff680f97,0xff8602d1,0x18930661,0x3bc82224,0x650c6590,0x5b8162af,0x66bf59b8,
0x71fb71fb,0x715f71fb,0x5a586b92,0x282e37d9,0x09631b2b,0x0930fe19,0x05541030,0xf2a0f255,
0xce93eefc,0x943d9f37,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xabd58ecb,
0xf6e2ccf0,0x14d40bb6,0x308c1fd4,0x3cc83642,0x4d1441cb,0x58a454ef,0x54f55933,0x6aab5d25,
0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4dff6b8e,0x273825fc,0x1d5131ad,0xe9ae0de2,0xcb9ddd3e,
0xc6e9c6dd,0x9e7eab38,0xcb85af2d,0xc1a3bb94,0xad7db412,0x9b3daf10,0x93f193cf,0x900b938e,
0x8dee8f27,0xb6319605,0x17e8f839,0x23232783,0x1f56235e,0xfdc91211,0x0a31f343,0x103f09a2,
0x23d41d97,0x1fcd26b7,0x43003222,0x603e588b,0x6e406635,0x6c526a3b,0x6ee871fb,0x613c68f3,
0x44e551be,0x1c9d290b,0x0b85134a,0x11270d1c,0x09ad1dc6,0xf4bb03c8,0xa06ecc52,0x8dee92a4,
0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,0xa2ac8dee,0xcb33c27f,0xdbfcd848,0xe91edd0b,
0x19bb024c,0x5a023657,0x627b61be,0x4ac44f22,0x71fb4e69,0x71fb71fb,0x71fb71fb,0x71fb71fb,
0x4bac646a,0x3460374a,0x15141ac5,0xf4c108e7,0xe3b6fd3b,0xdc99dba0,0xae51b249,0xb0cab142,
0xdc46c25a,0xe4b0e258,0xca7ddfcb,0xc81dc1bf,0xc85ed0b7,0x9c7e9bdf,0xa5719cdd,0xbcf2a722,
0xe7a6e365,0xf0c3fc49,0xf5cbf135,0xf9f7fb00,0xef710010,0xff91f2d9,0x054ef957,0x34e02252,
0x53354cae,0x5ad14d72,0x71fb71fb,0x71fb71fb,0x6f3871fb,0x39a058a2,0x29e3309e,0x121f1c60,
0x113b1e47,0x1d881a32,0x0f9a1928,0xfcd4febe,0xc87ce08b,0x8f00a429,0x98c38dee,0x8dee8dee,
0x8e178dee,0x8dee8dee,0x90c88dee,0xc201b78f,0xc9f5c20d,0xf88ae686,0xfb42f39e,0x17da1b73,
0x17ed1155,0x2a750ca7,0x71fb45f3,0x71fb71fb,0x71fb71fb,0x71fb71fb,0x4e0871fb,0x28a93e22,
0x0e341dfe,0x18280ebe,0x18301cc3,0x039015b6,0xdb97e75b,0xcb0fd9c7,0xcb33c14c,0xccafcb4f,
0xb0b8cb7a,0xb53eb409,0xafecb29b,0x91d6a409,0xcf3db0ae,0xe1d2ec38,0xdcedd1ca,0xd951e49f,
0xef96e106,0xfa88fb3c,0xea75e9f4,0xfda2f975,0x1a3a0203,0x35f92d77,0x2be02f48,0x4b9a3949,
0x58a151eb,0x71fb6f95,0x650667d0,0x42355a2f,0x40443b7b,0x40d134c8,0x2d564336,0x408939cf,
0x2d9a3875,0xef4106b1,0xc38edeea,0x95d7ab99,0x8dee8dee,0x8dee8dee,0x8dee8dee,0x8dee8dee,
0x8dee8dee,0xc804aa74,0xc589c984,0xe8f4dd31,0x0e73f788,0x01540a20,0x2de20e8f,0x4c283918,
0x67d35439,0x71fb7038,0x71fb71fb,0x71fb71fb,0x6ae471fb,0x2d433cae,0x10ed19eb,0x1c3e1a8e,
0x0a5d1401,0xe8b5fbd8,0xe63be7ac,0x093f02ae,0xdc35facc,0xc536ca7a,0xaab8c1b6,0xa2519cb2,
0xa7a4ad63,0xbdf7ad7f,0xcae8c7cb,0xd885ce7c,0xc219cc6c,0xf091d575,0xf232f7bf,0x099ef61e,
0xe0c5f447,0xe92ae38e,0x0a69f805,0x30071977,0x367133b3,0x64ee4ad7,0x71fb71fb,0x641971fb,
0x414e4b25,0x35e03489,0x374134ff,0x44c13c88,0x3bcf4669,0x31503829,0x16fa31d5,0xe45a02da,
0xcbfdd5b2,0xaa30c075,0x94f799c7,0x8dee8dee,0x8dee8dee,0x943e8dee,0xb4fba87b,0xb038b474,
0xbe6bb283,0xd2e6c6c9,0xff87e844,0x0a1406d0,0x258314c9,0x46db2963,0x4af25722,0x71fb5275,
0x71fb71fb,0x71fb71fb,0x53aa71fb,0x35ce396c,0x2ab23295,0x1eb02bfb,0xf9a80b3f,0xee36ee36,
0xf4a5f487,0xede9fc15,0xdee4e4f9,0xb698ca86,0xbf37bc59,0xb69db8ae,0xcdedb760,0xd733d7d2,
0xb98ac90f,0xd349c196,0xd264ceff,0xdb7cdd82,0xf2b5e40f,0xf686ee56,0xf633f816,0xf169ecdf,
0x0c40fbaa,0x0e940d16,0x30a21e62,0x3fd93ce0,0x6314519c,0x546361a1,0x513a4a63,0x64d15f52,
0x32355255,0x2206225d,0x16212090,0x2bc2229d,0x1b4b291c,0x059e10df,0xeed5059e,0xc3b7d989,
0x8dee9c7e,0x8dee8dee,0x95898dee,0xb1a1a4f8,0xaacba7a6,0xadc5aa68,0xc15ab142,0xd545cf62,
0xe7a0d904,0x0874f0dc,0x1e87151d,0x41592fff,0x4a2543f2,0x5f2954da,0x61266823,0x5f7b5e92,
0x71fb678b,0x592f6f74,0x25c142ce,0x03761141,0xffcbfc45,0x111b0957,0x190820b9,0xe699f7bf,
0xd2d1e2a0,0xc669c88e,0xaf97c3b8,0xc0edb1d2,0xc6febcf2,0xf229e9e2,0xe975e9b3,0xd2b9e13f,
0xb88fc0cb,0xd635c866,0xf8d9eac0,0xddd0ea3d,0xeceae827,0xf7aaef85,0x12570078,0x1c212356,
0x1b471658,0x26162538,0x2d6f2987,0x425f3122,0x525c4c83,0x60055e8f,0x40c559c2,0x34792cc5,
0x461a453d,0x1b8c3816,0xfe9d0a92,0xf5d6f1e0,0x02a30ace,0xe190ef72,0xb9cfcdd0,0x8dee93b8,
0x919992d7,0x9d4192ea,0xba17b0a6,0xb167b97a,0xb606af81,0xbe84be14,0xd530c5cc,0x02e0e7bc,
0x2aba15dd,0x2b263246,0x3f272f39,0x48373db3,0x580b52ee,0x63e45b8a,0x6ac16f06,0x3a8e552a,
0x1e9e264c,0x24e81ed6,0x1f9220d6,0x0afb1682,0x017d0468,0xe8c2fa63,0xe7dce3d8,0xecf8f513,
0xc975d71e,0xafd3b7e2,0xcf6fc276,0xde94d472,0xec44ea02,0xd37edb4a,0xe072dcc9,0xdce2dff7,
0xdd19e21f,0xbb50cbfe,0xcbcbc024,0xf84bdc24,0x116702c5,0x2d6127d3,0x2b5b30dc,0x240f2677,
0x18fb20a0,0x24ca1a9f,0x4f653cc0,0x41cb4bad,0x5d4a4c6d,0x50a861e9,0x37543d77,0x110e2ac1,
0x152d047c,0x20fb27b3,0xfbff0e5e,0xe0dbf390,0xa6d4bbcd,0xa911a405,0xb858b109,0xbe30bf04,
0xb988c035,0x9cb2ab27,0x96c5958b,0xbdeba69d,0xdd77cec4,0xf702e607,0x0ab20256,0x2c4d1632,
0x46433df5,0x53ed4692,0x4c4b5690,0x3df53c75,0x4b944548,0x54e756fe,0x3e0c4681,0x280c33b3,
0x23452400,0x083714ef,0x07930af7,0x04a30565,0xeb51fad6,0xd97cde70,0xd246d2d9,0xd354cce9,
0xdceadc22,0xcb65d743,0xc3e9c397,0xccc6c4d2,0xef84deea,0xe7f4f2e3,0xd610d7e5,0xd728ded1,
0xcefacdc1,0xe820dc15,0xf46cecaf,0x1aac04af,0x1b2820e8,0x24931f19,0x363b2eea,0x275f2c8d,
0x34352bc7,0x41203baa,0x442b463d,0x4e97491e,0x3d744977,0x3a183580,0x1f4a328a,0x108c14ed,
0xf0a7055a,0xeb5bea1b,0xd2dce595,0xa58cb79e,0xa207a039,0xaca4a6af,0xacc1abbf,0xbe40b236,
0xcbe1cc7f,0xc531c4b7,0xc8f9c807,0xd3cace23,0xf3a5e044,0x16a0061c,0x4cb3326d,0x45384e67,
0x54d04b49,0x47314f13,0x40cb4176,0x40154410,0x27e930de,0x38382ae8,0x3f344294,0x2883356d,
0x0c221c8f,0xed29f960,0xe20ce954,0xe488dcea,0xe888e7b5,0xd164e0ce,0xb9b4c228,0xce4ebf72,
0xe571d76d,0xed4df1f5,0xce6cdc2b,0xdc03d3df,0xe906e5bc,0xe5cfead2,0xcc97d669,0xdc7dce63,
0xfcbaedd7,0x080002c6,0x1f1c1582,0x0fd7192b,0x23f712b7,0x377f33d4,0x31013322,0x4af73cac,
0x3d104a01,0x47913bf6,0x47754bff,0x30984204,0x119e1993,0x07590cb8,0x08700777,0xf7bf0492,
0xd4a3e4d2,0xc7cecd00,0xb541bd13,0xb7fcb39b,0xa91fb346,0xadcca73a,0xc3b6b815,0xd998cc11,
0xdc40de8e,0xd8cedbfd,0xe06bd98a,0xfba5ef80,0x15db0768,0x3c052973,0x4ab0456e,0x62ef57c4,
0x4f375cae,0x3cb3453c,0x3f9d3722,0x32fc3fcb,0x1ab525ac,0x05330df9,0x0f4208cf,0x0f7514fd,
0xf5a80474,0xe879eb08,0xd86ce2d4,0xd442d332,0xd8eed47e,0xe3f4dfb8,0xe184e7ab,0xcdeed7e1,
0xce4ecbcf,0xe3c6d579,0xea00eb3d,0xdc34e195,0xdc8cdae0,0xee27e733,0xe5daebb2,0xebc0e330,
0x0787f802,0x298318b1,0x365331e8,0x39443988,0x262f314a,0x18641b15,0x33a62212,0x547148c5,
0x51c35433,0x34724abf,0x0c961b41,0x01f50611,0x07d30660,0x0068017b,0xf06efe32,0xdf89e428,
0xd4b4dd64,0xc04fc699,0xa856b55d,0x9fa7a0fd,0xb6dca861,0xcd8bc393,0xd0ccd3d0,0xd3c7cf43,
0xf571e246,0x09e70107,0x1b0614af,0x28421d76,0x394c34d1,0x326d32e0,0x43a13bb1,0x48ec46bd,
0x5234502a,0x31c7447a,0x1810243a,0x12a2120d,0x0f4e13d2,0x0ace0bbd,0x0370077a,0xf3b5fe97,
0xe75dede0,0xd6faddb1,0xe298dbe2,0xe49fe5a4,0xd830dfa0,0xd3ccd3f4,0xd28ed239,0xd29bd5b2,
0xd25dcf35,0xe48ddaf3,0x0096f46d,0xef40fdf9,0xe667e5b7,0xe8b0e6fb,0x0806f478,0x20491a21,
0x17e91d4e,0x1c4613c9,0x25942709,0x2b9725fa,0x34942fd2,0x338334ed,0x3bdd384a,0x3ccb39a3,
0x39313d65,0x2917344b,0x0b5219b3,0xee91fbb0,0xe780e8e3,0xd837dfac,0xda21d7ad,0xc3ddd376,
0xbb54b9dc,0xbea6bf22,0xc0f4bdcf,0xb41abd3c,0xbc8ab395,0xe1a9cd24,0xf2c7ed68,0x07b1fa6c,
0x16971272,0x1f9c1a66,0x1e961ebd,0x2341232c,0x34ad26e4,0x495141a9,0x432b49bd,0x2e3f3a18,
0x30e129af,0x2e2b34ba,0x20a52414,0x190f1e6b,0xfeff0ca5,0xeccaf9a3,0xce78da18,0xdb19cee3,
0xe260e2a1,0xeb8ce45b,0xe9abed09,0xdee9e38c,0xd54bdab3,0xce85d249,0xd3a6d031,0xe43adb17,
0xf74aeb81,0xf788fcba,0xe8c5ee92,0xf2b5ebac,0x01fcf8cb,0xfc2702a7,0x0951004a,0x1b6111b6,
0x2a8f25fb,0x26ef2b1f,0x2d20265b,0x3c2c3492,0x508046ff,0x425a501a,0x1fd02e4b,0x15a41956,
0x109812c0,0x036c0b94,0xf826fed7,0xdd74eb6e,0xc1eece9d,0xca5fc19c,0xdaced49d,0xdcb9de22,
0xc275d187,0xbb29b94b,0xc21fbec4,0xcf2ac65e,0xd61bd546,0xe747daee,0x0b00f851,0x1ec81883,
0x23a61f96,0x2b0d291a,0x364e2e2b,0x3ce03a4e,0x47744428,0x38244383,0x25fc2b12,0x1efa22ca,
0x282d227f,0x1ba02434,0x10211925,0xf71200e0,0xe01aee72,0xcdced15e,0xcfa7cf10,0xd901d200,
0xed86e2b1,0xfc5ef82b,0xf690fa8d,0xe370ed5f,0xd8e3dceb,0xcd47d44d,0xcf36c8bc,0xde51d9e0,
0xeac4e28f,0xfda9f1d0,0x0f330af0,0x091907e4,0x12911214,0x17291077,0x18281c7d,0x1c34172d,
0x33b62440,0x44b443b1,0x2318339c,0x23be206c,0x2f1d28e6,0x2ea030fa,0x24682c5b,0x01561436,
0xef77f566,0xec5cecf6,0xe8a7eca9,0xdcb0e10b,0xd9bbdbc1,0xc92dd25d,0xb80fbe7e,0xc384bbad,
0xccb5c9e2,0xc265c741,0xd26ec67c,0xee88e318,0xf9c1f2e9,0x161406dc,0x29eb2356,0x26ae2902,
0x2bdf26ae,0x367e3427,0x41c13b57,0x3dde4172,0x27203534,0x175d1a9c,0x1ed91ca0,0x1c901cd4,
0x0e161a10,0xf9e901ba,0xf708f54d,0xfca4fc1e,0xeab4f52e,0xd1c9dff6,0xc33cc406,0xde12ce31,
0xf53cebd2,0xf0a8f425,0xe02feb63,0xd6d9d66b,0xdd7ddc99,0xdfc5dc5f,0xe8ede71d,0xf136e75a,
0x0870000e,0x13840d02,0x1b491af8,0x0f6b15da,0x0d160cd6,0x17bf1244,0x169b1634,0x1a141814,
0x27fd2132,0x34ed2cb2,0x47144120,0x2f453e8a,0x1acb2305,0x0e2a1356,0x0b1f0beb,0x023b0a0e,
0xdb17f0f9,0xc9d6cc05,0xca00ca68,0xd1b3cd38,0xd32dd381,0xcfa2d390,0xc3bfc7d9,0xcbcdc7b8,
0xd261cd61,0xe365dafb,0xef5fe9a7,0x0eedfd0a,0x280c1ef7,0x1ea52580,0x18951a5b,0x27891c48,
0x36c432b9,0x30d53522,0x319c2f88,0x346933c0,0x27672f8f,0x1caf2368,0x09b80fe9,0x0e850ceb,
0x05a30a9a,0xf48efeda,0xd811e68e,0xcf1dcfdf,0xd6c9d292,0xdf40da38,0xe550e2ff,0xe543e629,
0xe26fe2af,0xedeae83f,0xf33ceef7,0xfa90fa11,0xe9c6f30b,0xe7c4e5ed,0xee36ea0c,0xfb28f63e,
0xff81fbc9,0x0a2d045b,0x18ea115a,0x24e520c2,0x1d4721e6,0x1adb1b6a,0x2a621fd9,0x36843451,
0x2a4a309c,0x2b3d2991,0x219d279c,0x16dc1c8b,0x0a301003,0xfcee054e,0xeca0f382,0xe181e590,
0xdd74e16f,0xc7f0d487,0xc49ec12a,0xd4cbccc2,0xdb17d96f,0xe06ade1b,0xd52cdced,0xc9d2cc0e,
0xdac7cffa,0xfc8beacf,0x14130a6d,0x18b21861,0x145c1579,0x2a0d1d9a,0x368d3163,0x3ad63a70,
0x38dd39b5,0x35e937ed,0x2e363237,0x20bd29f2,0x0cdf15e6,0x01a80653,0xf826fe0a,0xe5c3ed8d,
0xe7abe4da,0xe34ce713,0xded2e029,0xe817e1c7,0xef77ec13,0xed20f1c8,0xe008e571,0xe3dadfac,
0xe51ee609,0xe3f9e3a4,0xf03ae936,0xed69efd5,0xf903f1dd,0xfeb6fe32,0x015dfdb5,0x075305fb,
0x0ead09ea,0x12a91225,0x14061207,0x203d197d,0x33d22969,0x30ee3758,0x29302a13,0x21f92a31,
0x0fd115dd,0x08a40c9c,0x0dd807f1,0x107f1372,0x0dd80cd3,0xf8cd07db,0xe720ec13,0xd671e2e1,
0xc3dec87e,0xcde2c83f,0xccdbcebc,0xcd7dcbfe,0xc8b5cd24,0xcdc1c788,0xeab9da0d,0x035ffa2d,
0x0162046c,0x01c2ffd9,0x1c9a0b7d,0x359c2cbd,0x38cf381c,0x365e38cf,0x2ed7328a,0x2415291a,
0x21ad22e6,0x1e7e203d,0x1bae1d2f,0x10761825,0x026a07be,0xf9b5fd5b,0xef12f56d,0xe5f3ea3a,
0xdc6ee051,0xe660de9b,0xf1e9eee5,0xe5c3edcf,0xd3eadb45,0xdc9ed419,0xef1ce862,0xeccbef5f,
0xecbbeb29,0xf174ef0f,0xf709f353,0x08dfffc4,0x0d1c0d5f,0x09570ad5,0x07dc0927,0x04aa0472,
0x02e00502,0x0ce50472,0x173a14f9,0x21a319e0,0x39f92d17,0x429f443b,0x228e34fb,0x0a5e1247,
0x092d0926,0x0d1c0a24,0x01db0a9d,0xf908faf8,0xf951f9f8,0xf37ef6ee,0xd69fe9f0,0xbf60c61b,
0xb95cbc30,0xbad2b8f7,0xcdc2c10d,0xe3d4db37,0xec1be79a,0xfc9ef483,0x02c80107,0x0aa6057c,
0x184d12a5,0x10b315a1,0x14a20f6c,0x28f71e8d,0x32cb307a,0x347d32a8,0x36bc3774,0x284530a8,
0x1ebb21cb,0x115c1984,0x0a270c81,0xffe804e9,0xf26bfb7c,0xdd25e61f,0xd951d94a,0xdf5adb7a,
0xe43be28c,0xe1d0e3c6,0xe946e341,0xf071ee33,0xeefdf04e,0xed16ee3b,0xeb5deac0,0xf94cf08a,
0xfdb8ff50,0xf971f89b,0x03530013,0xfb43ffcf,0x01a2fc31,0x054004e6,0x0b970674,0x0c3f0f9a,
0x09880842,0x1c031091,0x3384294f,0x35a2385b,0x2f1d3130,0x25c02b66,0x1e8d2258,0x06f41555,
0xec47f767,0xeafae971,0xf518ef46,0xf38cf75a,0xe9cbede6,0xe239e584,0xdeeae1d2,0xcb4fd6fd,
0xbd3cc068,0xcc5fc254,0xda10d4f3,0xe65bdf57,0xf758ef95,0x05acfd42,0x150e0f75,0x148815a1,
0x19fa1551,0x2c84222a,0x321c337b,0x2dbd2e4a,0x33802ff5,0x30da34f6,0x220628c2,0x1ac91e4c,
0x0a1e1406,0xf3c7fea5,0xea50ed51,0xe5fce807,0xe393e2ff,0xe990e7bc,0xe126e65b,0xe405df2f,
0xf3d9ec9a,0xf58ff6eb,0xe84ef022,0xe45ae2c4,0xf353ebc6,0xfb0ef8f1,0xf4bdf8bb,0xedc2efd2,
0xfab5f238,0x07f40309,0xfdfb04b1,0x0328fd4f,0x0ca208f0,0x10c50ec5,0x13f51365,0x175f1447,
0x1a5e1a7d,0x21b81c2a,0x295d270a,0x26332939,0x17ed2037,0x04920d54,0x06b70317,0x0fdb0c6f,
0x023b0be2,0xef2ff7ac,0xe842ea8c,0xe39ee529,0xdef3e32b,0xcc6cd6bb,0xc0b1c2ef,0xce68c63e,
0xd69dd560,0xcf10d1fd,0xe491d530,0x02eaf42b,0x1ba1125a,0x1fae1f1b,0x1f0d1f74,0x231b1f99,
0x2d282883,0x2dfc2ed0,0x30ab2e3c,0x281c306a,0x13c11c8f,0x0f0a0eb0,0x161213a5,0x0b6712da,
0xfafb0207,0xf519f752,0xe722efce,0xd9c1df23,0xdba3d8c7,0xeca6e2aa,0xf5d8f3d0,0xedddf3ce,
0xe53de6dc,0xe7cae7af,0xe967e625,0xf5dbf0da,0xfb80f847,0x0196feb5,0x04e10397,0x03c50524,
0xfb23ffc5,0x0181fb09,0x0e0a0a82,0x0095088c,0x01c2fe8e,0x083105bd,0x126c0ba5,0x25411c16,
0x28d229a1,0x25b82764,0x1c9b2133,0x1b471b0f,0x19ba1b35,0x11f816e0,0xff540a0e,0xeeebf568,
0xefc9edd4,0xe71fee9c,0xd170dc92,0xc39ec8fd,0xc999c34c,0xda8ad2ce,0xda60dd6b,0xda24d75f,
0xeb64e0e6,0x00fbf753,0x024c04db,0x0449003d,0x10f90aa7,0x1ff7186c,0x2dc326df,0x37fe3417,
0x340e3846,0x25322da3,0x18a81d22,0x17fc1724,0x1320181f,0x05480b5c,0xff8e0216,0xfde6fd55,
0xf814fe57,0xe232ecd1,0xdbc8dc62,0xdc56dcde,0xd8d0da0a,0xe2ccdbf3,0xef18e936,0xfd49f5fc,
0xff100076,0xfd52fbc6,0x01660218,0xf7ccfae5,0xfaecf988,0xfc31faee,0xfddefddd,0xfeb5fd29,
0xfcdbff97,0xf6fdf944,0xfb08f739,0x1027044e,0x1a1317ed,0x1a0919c0,0x267e1e7e,0x301d2e1d,
0x232a2bdf,0x14791afd,0x111010ec,0x0ab50fc8,0x018904c6,0x001f00fe,0xf727fc1e,0xef0bf3b5,
0xdbb1e605,0xd65ed63e,0xd5dbd704,0xd1f7d3e4,0xcd72d03d,0xd0e4cc73,0xe63cd9bb,0xfe42f4ad,
0x027f015f,0x01cb0291,0x03760195,0x0fea08dc,0x2121175d,0x35c72c5c,0x3bb23acc,0x38f33ac5,
0x30933505,0x23b92b79,0x0ac3188d,0xf25afd0c,0xef34ecf1,0xfe07f794,0xf6bdfc92,0xe99bf0a8,
0xe393e346,0xeb3fe818,0xed63ec42,0xea0ced84,0xe374e5a2,0xe6ffe3b4,0xf94dee77,0x08e0030a,
0x068909b0,0xff5602d5,0xf7eafb40,0xf662f6a7,0xf26bf4ec,0xf4dcf20d,0xff90f9e6,0x06e5041d,
0x0b7b09d2,0x0c020b93,0x08000bd4,0x08d00478,0x1fa21495,0x266c25d2,0x19a12118,0x158b157d,
0x1ba617a4,0x1dde1f28,0x0c28165b,0xfc73028f,0xfe23fc27,0xf8a7fd03,0xef61f3c9,0xdd39e7e6,
0xcb6bd30d,0xc957c82a,0xd0b3cd30,0xd22dd1de,0xd788d381,0xe748de68,0xfe35f27c,0x0718055f,
0x0e730919,0x17d01455,0x21901be0,0x2a91262f,0x2c402d04,0x299529ec,0x2ce82b1f,0x2c312daa,
0x1b7026c3,0xfcb60ba8,0xef8af2e7,0xf587f1ea,0xf468f712,0xe87fed88,0xeec9ea30,0xf47af1bc,
0xf712f79c,0xe818f073,0xe246e2f7,0xe8dee4f9,0xee6beb8a,0xf8d1f379,0xfd18fc7c,0xfb6cfb49,
0x071e003a,0x10580cd9,0x098b101a,0xf13cfd69,0xf1a8ed29,0xf6c9f630,0xfb0ef801,0xff51fcf7,
0x07d40395,0x0f150b8d,0x1869131c,0x19441b9a,0x1af11708,0x2266205c,0x27ba249f,0x1b702510,
0x0ec812d6,0x08e20b7d,0x08fa08f6,0xfefb05af,0xe813f480,0xd4e2dcca,0xd36ed1c3,0xd920d7bb,
0xcefbd4c5,0xca49cb19,0xd8b2cf3f,0xe8abe120,0xf995f160,0x0521ffc3,0x0ea00a7c,0x0c3a0e75,
0x14500d53,0x25f51e47,0x2b31295d,0x28172b40,0x251c24ca,0x299f2859,0x1e892676,0x08b01300,
0x070a0589,0x0107060a,0xf881fbeb,0xeb88f343,0xdf40e3cf,0xe146ded7,0xe64ee3e8,0xef3aea63,
0xf260f1a6,0xf3b9f2c5,0xf561f4ec,0xf88ff658,0xffecfc2f,0x010401c6,0x03cd0113,0x05bb0678,
0xfc79014d,0xf95df9e5,0xf790f8a5,0xf808f76d,0xf737f823,0xfaa1f764,0xfb23fc80,0xff10fb4d,
0x0eb40572,0x23f71a3b,0x29c42965,0x236326fc,0x1f9920e0,0x1b1e1e6c,0x0df1145c,0x0eab0c9c,
0x0a890e96,0xfbe903f7,0xeb29f319,0xe6cce6d6,0xe76ae801,0xdabee334,0xc84ed028,0xcbdbc6e3,
0xdd74d454,0xe6eae418,0xe586e5ed,0xf359e9e7,0x060afdd6,0x0f910b65,0x16671389,0x1b8c18bb,
0x21a71ec6,0x2add24e3,0x37783244,0x316437a5,0x1bf126c3,0x0c0d1301,0x01c006f4,0xfac1fd35,
0xf3eef830,0xf046f0fa,0xebd6eefd,0xe85be955,0xe486e6e5,0xe6e3e455,0xee61ea2e,0xf674f314,
0xfeb0f98a,0x07ac0454,0x04c406f4,0xfea90288,0xf580f951,0xfba7f698,0x0001004b,0xf6f7fb28,
0xf50df5ed,0xf441f356,0x0084f9c1,0x05e60513,0x0004031b,0xfbe9fe5c,0xffd9fb2f,0x106d0882,
0x1adc1664,0x1e9e1d40,0x24262132,0x252b25c9,0x212f23bf,0x11d01b25,0x05bb0995,0x022d04bb,
0xf566fbd4,0xf3aef32c,0xeacff09e,0xddb8e4aa,0xd142d60c,0xd107d0e3,0xcc4ecea5,0xce7ccc11,
0xdee7d478,0xfa53ec91,0x08c903e6,0x0cdc0b00,0x12f20f15,0x1c69183e,0x20f61e4e,0x2a4d25c9,
0x2e862d1f,0x27df2cc4,0x1d6322bd,0x124e179a,0x07300cf7,0x007e02c0,0xf5c9fcf7,0xeb54ee95,
0xecb9eb4c,0xf2e3f01e,0xeed7f1c2,0xebf5ed08,0xec41eb00,0xf2fff054,0xf11cf25e,0xf798f277,
0x041bfebb,0x07be06d3,0x0724079c,0x0553069d,0xfe8702e0,0xef22f739,0xecacea64,0xfdb0f561,
0xfc5eff3d,0xfb53fabc,0xfa22fafe,0xfd1efa76,0x0681018f,0x0b1e09d1,0x0c440bba,0x103f0d4f,
0x1c7c159b,0x291d2393,0x2bb62c6e,0x22fd2731,0x1be7202e,0x0bc41542,0xf3a20038,0xe2f0e88f,
0xe649e3fa,0xe108e517,0xd72edbfa,0xd5bbd439,0xda85d9c8,0xd1cbd5e6,0xd948d350,0xebcbe19e,
0xfbcff577,0x06550044,0x183f0ee4,0x20441e9b,0x1c4c1ec0,0x1be51a40,0x27972221,0x254a27ba,
0x221e23cc,0x18a51deb,0x11301450,0x086d0de6,0xf8130076,0xf083f2b9,0xf244f0bf,0xf0ccf30b,
0xe884ec76,0xe51be5ba,0xea19e726,0xf136ed0b,0xfbb4f6eb,0xfea0fda7,0x035500ef,0x03340386,
0x05fb0435,0x04b5062c,0x01fd02ae,0x01c6024c,0xf7d1fe1a,0xedc6f1c7,0xe850eaa8,0xed8fe895,
0xfe2ff670,0xff7400cd,0xfed7fe1d,0x078601c4,0x16860f30,0x1b771ab9,0x184a19b6,0x1ab118fa,
0x1ec71c8b,0x226420e2,0x208d22b8,0x12ae1b29,0x017d08d7,0xfc30fe5c,0xeed0f737,0xda7fe509,
0xca49d070,0xd3b3cbe0,0xe184dc74,0xdef0e1ba,0xdabfdbf3,0xe2aedcab,0xf232eac2,0xfeb5f8b9,
0x093f0497,0x0def0bab,0x1c4513c5,0x286a233d,0x2d152c17,0x26fd2b2f,0x1d1821c1,0x1c211b73,
0x16141b16,0x06ef0ece,0xf7acfee0,0xf1d4f37b,0xf13af15a,0xf05af131,0xeb7bee16,0xea08e9fc,
0xee9febd2,0xf343f17d,0xf42cf3b0,0xfba1f6f9,0x04a10034,0x0ce208ff,0x0b5a0e08,0x03860737,
0xfd280050,0xf694f9f1,0xf43cf4bb,0xf0c3f2da,0xf437f0d9,0xf86ff7f5,0xf5eef6ee,0xf460f551,
0xf574f367,0x05affc21,0x16580f3f,0x175f18e1,0x159e1598,0x1a211732,0x247b1f0f,0x22d1265b,
0x16de1cd8,0x0fcb128a,0x0cf10e76,0x09b70b3d,0x00f40713,0xe488f4b7,0xd177d758,0xd834d2d2,
0xd95fdbaa,0xcc41d2bb,0xcd23c989,0xe3a3d6e3,0xf8b8ef61,0x01baff04,0x03860272,0x0bdc069c,
0x185d11fb,0x23681ee8,0x237f245a,0x22ff22f8,0x22c022dd,0x22a222e1,0x1d6a2147,0x06c714cb,
0xf1a1f901,0xf168f0b0,0xf43af20f,0xf808f758,0xf1fef56e,0xec41eefa,0xec96ead8,0xf57df0cb,
0xf8c2f889,0xf76df788,0xfdd5f9bb,0x0597024d,0x067706b5,0x07cc067a,0x09850936,0x00ac06ec,
0xf47af96c,0xef6bf1b6,0xeb5becd1,0xef2eec4a,0xf5f6f282,0xfc4ef9d6,0xfa0afbe5,0xfb6df9ac,
0x0189fe7b,0x09130490,0x1a5510c7,0x25ec222a,0x24a8264f,0x21082288,0x1cb61f72,0x172019ae,
0x100613f8,0x08520bdc,0xff8704b5,0xee8cf808,0xdc86e483,0xd9f2d8dc,0xdd07dcab,0xd1cbd8f8,
0xc9aacadf,0xdb89d05b,0xed68e641,0xf420f0ff,0x0376fa4b,0x15e70dd1,0x1a3319d4,0x1bf51a84,
0x1c821ce4,0x19d31b3c,0x1b1a1977,0x20241e1c,0x1e322029,0x14b01aa2,0x04d30cc4,0xfa3bfef3,
0xf1c2f5b0,0xec69eeea,0xe8f0ea2b,0xedb9ea1a,0xf3b0f136,0xf9a0f621,0xfca5fca1,0xf6d7f9da,
0xf806f5a5,0x0355fdcf,0x07f90674,0x0ac8099e,0x0a1a0b13,0x034f073a,0xf9ecff4b,0xf016f393,
0xf16df098,0xec0aef18,0xede6ebd3,0xf098efa2,0xf4acf204,0xfc4ef871,0x04cb000e,0x0f0c0a4e,
0x14071234,0x17df1592,0x1cdd1a82,0x252b1fa2,0x2e692c04,0x1e3628f9,0x0a391256,0x077e0755,
0x033406f5,0xf41ffc1d,0xe75ced6d,0xddc0e1af,0xddbddd08,0xdae0dd67,0xd2add676,0xd616d23a,
0xe46fdd21,0xeec0e9d8,0xf9a0f42f,0x03b8fe94,0x0f55093f,0x1d5515dd,0x2cb225f5,0x268d2d09,
0x17da1de7,0x16db15cf,0x1a411944,0x12811826,0x025e0a9e,0xfb3cfc83,0x01ebfe8d,0xfc64018f,
0xeb26f463,0xe048e388,0xe995e299,0xf93bf29a,0xf9c8fb16,0xfd6cf9d1,0x05650258,0x05dc05c8,
0x05c1064a,0x02a203b5,0x050f03d1,0x019903c5,0xfee70044,0xf93bfc7d,0xefeef489,0xedecede6,
0xeb30ece0,0xecb9eacf,0xf3caf012,0xf7eff646,0xff63fab3,0x08360417,0x0f270bc3,0x17141272,
0x23391d30,0x27fd270f,0x1f86256f,0x142018d1,0x14cc12d3,0x19d918b5,0x0cb215d4,0xf50800ea,
0xe891ec66,0xe90be863,0xe221e7c7,0xd0b7d926,0xcf5acd58,0xdb5cd4d9,0xe5c4e13a,0xea43e86c,
0xf121ecb5,0x0066f82f,0x0df007e2,0x17ed1332,0x1e6b1bcb,0x1efa1f43,0x1e791e79,0x21131f4a,
0x239a233f,0x13801ed3,0xfb3005a3,0xf88df72b,0xff74fc31,0xfa92ff38,0xeefdf3d3,0xf09eee23,
0xf66af3f0,0xf5abf718,0xf18af344,0xf18cf0c2,0xfcb6f58b,0x093d0400,0x0e760c62,0x0e620f3f,
0x08940bfd,0xff130405,0xf69efa4c,0xf449f4c1,0xf443f47a,0xf1dbf337,0xeffaf0cf,0xedbfeea1,
0xf32eef5e,0xf72cf667,0xf7a1f6cc,0xfe1dfa15,0x081502df,0x11640cfd,0x1c391619,0x29b023ed,
0x27852a67,0x22112468,0x1d3b1fd9,0x12e519b3,0x00d00972,0xf823faee,0xf928f811,0xf3bdf863,
0xe346ec34,0xd360da50,0xd2add099,0xdceed7c0,0xe12de011,0xe2a0e166,0xee3ce687,0x0026f7f3,
0x086c0558,0x0d840ad1,0x17431190,0x1f991cbf,0x1eb01fa5,0x1e9f1e29,0x1f4d1f78,0x18031d03,
0x0a361117,0x02700576,0xfbcefffe,0xefbcf5e4,0xec9bec1b,0xf650f0f1,0xf733f8d3,0xf1a9f392,
0xfa02f456,0x00ddfee7,0xfbfcff75,0xfa63f95f,0x02aafe60,0x099b066b,0x0bd70b7d,0x0a550b6d,
0x049207cc,0xfcc300df,0xf2c9f7b0,0xe618eca3,0xe296e1bb,0xeea4e7e6,0xf7adf463,0xf71bf840,
0xf7dff67f,0xff69fb51,0x05730324,0x095406ef,0x15870e6a,0x20491c33,0x236d2224,0x251c24b8,
0x238b24b8,0x1b3520c9,0x0b60139e,0xfe8e03e6,0xfa49fc15,0xedb8f5b0,0xdf4ee4fa,0xe18dde71,
0xe434e478,0xdb87e084,0xd6f4d7ba,0xddd6d960,0xe95ee321,0xf7ddf0a9,0x04fefe6c,0x10600b23,
0x16bf145c,0x185717d2,0x17691830,0x1b6a1823,0x21d71fe0,0x1ac01ffb,0x0d8313f0,0x05e50913,
0xffc502fc,0xf5edfb37,0xef8cf119,0xf2ecf0e8,0xf145f302,0xf1edf012,0xfb42f658,0x0087ff05,
0xfce8ffb5,0xfc97fb18,0x065c00cb,0x0e210b73,0x08700ca8,0xff990340,0xff81fe31,0x01fe015b,
0xfc2e001a,0xf1c6f700,0xe77cec56,0xe722e586,0xed0dea7d,0xf0c2eecc,0xf80df3d3,0x0019fc9b,
0x04c8025a,0x0c620867,0x11040f27,0x148b12b1,0x197d16b9,0x24651e68,0x27c0282a,0x1fe2246e,
0x14641a95,0x085a0dde,0xfebc03b5,0xf285f8d0,0xe4a9ebb2,0xda29de1f,0xda23d929,0xddfedbee,
0xe391e0ab,0xe7d3e611,0xe9bde91b,0xed8feab0,0xf938f2c8,0x0680ffdd,0x11330c9c,0x14fd13a4,
0x1a16170d,0x1df21ca3,0x1e8d1e9e,0x18831caf,0x0e2812e5,0x0bf00be8,0x08430bb6,0xf92f0178,
0xee6ef220,0xf176eeb0,0xf27cf31a,0xf14af0e0,0xf9f7f4d0,0xfe53fd98,0xfda9fd83,0x0195ff42,
0x050f03a1,0x05c605af,0x074a0611,0x08e40899,0x06370849,0xffa90305,0xf823fc4c,0xf0dcf3a5,
0xefa2f02b,0xe9f3ed48,0xeb83e8bc,0xf393f025,0xf399f4a5,0xf169f1d4,0xfac5f45a,0x0c22030e,
0x18691412,0x181618d3,0x1ab818cc,0x1f2c1cf9,0x217920f9,0x1b9a1fb7,0x11481655,0x0d210df7,
0x0ada0d16,0xfdf90576,0xed1df594,0xe096e5d1,0xdd0fdded,0xdededdbf,0xde1edf0e,0xdcf9dce2,
0xe32aded2,0xf2e8e9ee,0x0385fc46,0x05a5069c,0x03d103d5,0x0a6f062c,0x15620fa3,0x1dd91a8a,
0x1a841d97,0x17021788,0x188d1810,0x14181777,0x06e80e44,0xf8a6ff4a,0xf342f480,0xf4c6f3fb,
0xf2acf47a,0xee69eff4,0xf5eaf071,0x012ffc97,0xffa301df,0xfdb0fd44,0x043500e8,0x05e70594,
0x0a49073a,0x0df40d58,0x05560ad7,0xfd5e0050,0xfb49fbf9,0xf7aafa3a,0xececf2d0,0xe4e7e7ef,
0xe832e4cf,0xf424ee51,0xf774f737,0xf600f64f,0xfe67f8ad,0x081c0492,0x07130838,0x09510727,
0x139e0d58,0x23f11bb0,0x2c242a46,0x217f28db,0x10bf1883,0x0adb0c2b,0x0bff0ba2,0x04470a0b,
0xf226fb79,0xe793eb3a,0xe600e64e,0xe306e52d,0xdc5edfc4,0xd9c1d9f5,0xe05adc13,0xed4ae636,
0xf98bf46e,0xfda1fc11,0x05900082,0x14250c83,0x1ba619eb,0x140018e6,0x0e150fa0,0x112a0f2a,
0x15931313,0x15ea173a,0x0cc11165,0x074a09bf,0xfd6a034a,0xf1cff6f9,0xeb67eddf,0xec7aead3,
0xf62df07a,0x0086fc39,0x01bb0250,0xfedafff5,0x0478004d,0x0b2008f2,0x068a09f3,0x008f02e3,
0x00ccfff5,0x05350317,0x049905d7,0xfbb70151,0xee7cf4b6,0xe897ea64,0xec11e938,0xf02eef06,
0xef4ceff4,0xf0c7ef34,0xfb83f55a,0x04e900f4,0x076f0709,0x09940787,0x12fe0e0e,0x1bbf17aa,
0x20241ee0,0x1fb6200d,0x1ee01f72,0x19661d1d,0x0c7c135b,0x0066063b,0xf4c3fa6e,0xeb58efc6,
0xe6a5e80d,0xe774e6fb,0xe585e732,0xdf32e26c,0xdfd2ddd5,0xe918e46d,0xeff8ecb2,0xf763f3aa,
0x0159fb9c,0x0e53085c,0x15541253,0x183e179a,0x15f91708,0x14d415c4,0x0e21120d,0x0a0e0b6d,
0x07e20930,0x064306d1,0x05f70667,0x01380435,0xf9b2fd80,0xf335f664,0xeef3f072,0xf1b6ef67,
0xf7ccf4c6,0xfeddfb27,0x046c021a,0x08b7066c,0x0ad70a8f,0x092f0a0c,0x07550886,0x020f04ff,
0xff320002,0xfc77fe54,0xf5c2f960,0xedecf1a3,0xeaa2eb9a,0xea9bea77,0xeb12eab4,0xf034ec69,
0xfb8ef5c4,0x03bc0039,0x05db057e,0x078b062c,0x0e530a49,0x188313a4,0x1d4c1baa,0x1f321e73,
0x1d101f04,0x15aa198e,0x0f481231,0x097b0c66,0x00fd0629,0xf15df972,0xe690eac0,0xe5dce4e7,
0xe6d9e741,0xe2f1e4ba,0xe37fe284,0xea03e605,0xf1faee8a,0xf472f3be,0xf69ef540,0xfe4ef965,
0x0dfd0594,0x1a6f1548,0x1a831c30,0x127b1670,0x11241098,0x12f2125b,0x0fc5124d,0x03950a83,
0xfad4fdaa,0xfcf4fb37,0xfeb2fe7a,0xfa8dfd1d,0xf5dbf7fc,0xf577f4d0,0xf9ccf7cc,0xf910fa05,
0xfb8ef91a,0x0448ffcb,0x0bd70882,0x0e650e03,0x0a940d10,0x05210799,0x012f0331,0xfbbafed5,
0xf3a9f816,0xeca6ef90,0xebb2eb83,0xee33ecc7,0xf054ef96,0xf04ff058,0xf571f1d4,0xff79fa90,
0x03e302b0,0x054d0438,0x09f90735,0x12190dbb,0x19e81656,0x1da31c70,0x1ad31cd1,0x18121911,
0x16fd17d3,0x0eea1424,0x004b07db,0xf3a9f91f,0xf118f125,0xf1acf220,0xe8e4ee56,0xdf80e35a,
0xe096de62,0xe781e45b,0xec4be9b1,0xf215ef1c,0xf8cdf513,0x009cfcc0,0x07f4043f,0x0ef60bc6,
0x121c10b5,0x16bd1442,0x18321832,0x146e170a,0x0bab106c,0x04c207ac,0xff870251,0xfc00fd33,
0xfb11fbb0,0xf764f95f,0xf76bf65e,0xfe59fa77,0x01f50129,0xfe4e00ba,0xfb37fbd8,0xff38fc97,
0x01b9011b,0x019f017f,0x050d02f3,0x0a1707d0,0x09fb0b1a,0x034f071e,0xfc27ff8b,0xf40ef863,
0xeccbefc3,0xe94aeabe,0xe8efe895,0xebdee9f4,0xf52eef7d,0x00fefba3,0x03aa03bc,0x01b50222,
0x07d403c5,0x0ee60c13,0x11201030,0x161212fe,0x1d3919ea,0x1e341ec4,0x19df1c66,0x128a16dc,
0x06470cf1,0xfb2c003e,0xf3aef72f,0xed79f093,0xe78eea52,0xe4aae595,0xe75be534,0xebebea34,
0xea4beb92,0xeb59e9a1,0xf526ef7d,0xff63facc,0x058e02c2,0x0b740855,0x11090e96,0x11d6121d,
0x108b1141,0x0cfa0f28,0x0b8a0b5e,0x0df20cf4,0x0c200db8,0x024c0831,0xf9bffce7,0xf92cf8f5,
0xfb24fa11,0xf9a7fb24,0xf6a1f7d2,0xf9f0f742,0x0291fe60,0x057c0519,0x032a04d3,0x000a010f,
0x04170127,0x05db0629,0x01f103da,0x00c600eb,0x023b012f,0x005d025d,0xf74ffc65,0xee16f277,
0xe7edeaad,0xe6a9e673,0xec1ce8bc,0xf45af00e,0xfcc9f878,0x0613014d,0x0dd30a32,0x13351130,
0x112912f4,0x10700fe0,0x158f12a5,0x1984181a,0x185c1974,0x13c4168d,0x0bb9100e,0x02bf072e,
0xfa78fe90,0xf1e6f64f,0xebdaee25,0xe9b1ea7d,0xe84ee8e3,0xe7b2e7b7,0xebc6e912,0xf197eee5,
0xf4dcf39a,0xf48df4f1,0xf800f510,0x03ccfd4c,0x0edf0a0e,0x13951225,0x121d1325,0x11ce11ad,
0x104c1147,0x0cea0f0e,0x05a50995,0x01e702f3,0x00fe01b5,0xff04ffef,0xfca9fe79,0xf650f977,
0xf558f4be,0xfb11f7b3,0x0078fe42,0x01950176,0x001600b2,0x04e9012d,0x0c840952,0x0a920cea,
0xff8d057e,0xf9a9fafb,0xfd09fb35,0xfcc3fda2,0xf8fffb37,0xf47af66a,0xf2e3f392,0xf086f1c2,
0xee04ef4d,0xed9aed28,0xf260ef83,0xfd03f6e6,0x091103a7,0x0e2c0c53,0x119e0fde,0x15c913ab,
0x185c1775,0x155417a4,0x0fba123b,0x0ef40ede,0x0eff0f52,0x0a760d72,0x0234066e,0xfb2ffe53,
0xf508f86a,0xec31f093,0xe75ae8f7,0xe72ce6e0,0xe859e7c4,0xeb44e96b,0xef47ed6d,0xf307f0e6,
0xfb53f676,0x058b00ba,0x0ac008c8,0x0d160c0e,0x0e4e0dd6,0x0fec0f1e,0x107f109a,0x0dab0f5f,
0x09e70bf6,0x02f60699,0xffd4008f,0xfe1eff54,0xfc39fcab,0xfe39fd05,0xfd06fe47,0xfaf3fb8f,
0xfb8efb21,0xfdcffc70,0x00caff8e,0x03aa021b,0x074c05b8,0x06ae07a3,0x033a04e6,0x01b1024d,
0xfe91008d,0xf9f7fc52,0xf5f5f782,0xf58ff5ad,0xf3b7f4a9,0xf535f401,0xf679f614,0xf6c9f6c9,
0xf34bf556,0xf22cf1c6,0xf9f0f4bf,0x04a9ffec,0x0907076f,0x0fd70bb8,0x1a7c153d,0x20bb1ee2,
0x1b341f61,0x117715f2,0x0bc30e2f,0x06870920,0x018603de,0xfcc9ff26,0xf753fa38,0xf266f478,
0xeffaf12a,0xebecee3c,0xe8b7e9e7,0xe918e86e,0xee32ead5,0xf4dcf1f5,0xf6eff627,0xfc70f8d1,
0x04c700c1,0x0b490822,0x10ea0e41,0x104611c1,0x0a3f0d06,0x097208ed,0x0b5e0aa5,0x088d0ab9,
0x023b0551,0x01fe0104,0x03f303ba,0xfe5001c0,0xf8a5fb09,0xf89df7b8,0x0002fbd8,0x021402b9,
0xfa4cfe69,0xfa65f893,0x0317fea0,0x093906fd,0x087909bc,0x02fd0607,0xfdf9001c,0xfdd4fd3b,
0xffa0ff14,0xf9a6fdd6,0xefc3f458,0xee11ed4a,0xf51bf160,0xf5bff6a5,0xf331f406,0xf630f400,
0xfde2f9af,0x04e6020d,0x04210585,0x02ea0270,0x0eb90717,0x1d1616f6,0x1ec61f7b,0x181f1bd1,
0x12c714f4,0x0d4c1088,0x039808c8,0xf8ddfe59,0xf206f468,0xf3d0f238,0xf6dbf5d7,0xf3dcf64b,
0xeec3f0cf,0xef2fee6e,0xf07ef037,0xed9def83,0xecbfec36,0xf359ef25,0xff47f8b5,0x0a8305d7,
0x0bc40c31,0x0ae40ac0,0x0f550c76,0x13e0123b,0x0e151290,0x03a3084f,0x01290170,0x03a40230,
0x054804f3,0x0116040f,0xfa4bfd3a,0xfb9cf9c4,0xfefbfe0c,0xfb30fdde,0xf782f87e,0xfe31f975,
0x07c7039b,0x0830092b,0x03ef0605,0x025802ba,0x02df028c,0x016202d1,0xfb9cfeb8,0xf62df8d8,
0xf320f42b,0xf457f35c,0xf64ff576,0xf4bef626,0xf1faf320,0xf600f2f0,0xfe3dfa57,0x024000c1,
0x033a02d2,0x055803bc,0x0bdc0830,0x10bf0f0c,0x109110fb,0x12ab10f9,0x170a1530,0x16621780,
0x0fb913c2,0x05bb0a97,0xfd52018d,0xf3d3f896,0xee96f04f,0xed9cedf1,0xed54ed83,0xef3eedd5,
0xf400f193,0xf55bf53e,0xf2b5f456,0xf12bf155,0xf42bf222,0xfc6ef792,0x06f401f5,0x0c720a5c,
0x113c0e9a,0x14b713c9,0x0f8c1329,0x07a50b28,0x055405c8,0x045d0526,0x00060280,0xfc28fdb7,
0xfbcffb7d,0x0094fd80,0x05a10408,0xff9703b1,0xf948fb58,0xfc25f9c8,0x006efeca,0xffa90050,
0x01d4ffc9,0x072404ec,0x044906db,0xff320158,0xfc24fdb7,0xf95ffa92,0xf8ddf8e1,0xf8bff8dd,
0xf7fdf881,0xf589f6d9,0xf2eef40e,0xf3d9f2a9,0xf9e8f680,0xfe05fcca,0xfd86fdd2,0x01e7feec,
0x096f05e7,0x0d900c13,0x10450ecc,0x146d1259,0x160f15ed,0x11591460,0x0cfb0e78,0x0c200ca5,
0x06aa0a24,0xfd99025f,0xf4cff8d8,0xef9bf1db,0xeb58ed8a,0xe7fee946,0xea0ce802,0xf279edea,
0xf870f632,0xf9caf984,0xfb71fa54,0xfdc7fcfa,0xfe42fdfc,0x00f4ff56,0x04380271,0x0a6f06ca,
0x11760e4d,0x12a31319,0x0ca6102e,0x080009bf,0x053b06e2,0xfffd02d1,0xfc40fd95,0xfcb4fc1c,
0xff14fdda,0xffc3ffdd,0xfdbefeb5,0xfe98fdc3,0xfe84ff07,0xfd33fd84,0xfffbfe30,0x0236018e,
0x013801e0,0x01df0127,0x056c03b3,0x012d04ee,0xf764fbd5,0xf5dff587,0xf956f7aa,0xf965fa15,
0xf4a8f77c,0xf1f8f262,0xf59bf367,0xf98df7c1,0xfd73fb53,0x01b8ff75,0x0743044e,0x0cfa0a5d,
0x10c70f22,0x1185117a,0x107c1111,0x0f710fcf,0x0fb00f85,0x0db40f4d,0x070c0ad7,0x0074035b,
0xfd13fe98,0xf8a5fb55,0xf269f599,0xed23ef8c,0xeb52ebad,0xed0bebdf,0xeef8ee01,0xf0a8efb4,
0xf6e2f2d7,0x008ffc09,0x039a0327,0x02de0303,0x04b3039c,0x04e50507,0x0649050f,0x09bc07f9,
0x0dbd0ba6,0x10b50fa9,0x0f8510c8,0x09290cdf,0x002c04b1,0xf9b8fc55,0xf82df88a,0xf981f896,
0xfc60fb04,0xfd1dfd1c,0xfe34fd29,0x013dffc2,0x042c02e8,0x03530473,0x0056014d,0x00fd0071,
0x001f00e2,0xfcfefed5,0xf9dafb4c,0xfb4ef9db,0xfda2fd1e,0xf935fc45,0xf24df55a,0xf387f193,
0xf9f0f6d2,0xfb4afb97,0xf881f9cd,0xfbb3f910,0x0336ff7e,0x085e0637,0x0c160a4b,0x0f3c0df1,
0x0ff00ff3,0x0fd80fdb,0x0f880fde,0x0d100e95,0x09700b56,0x061c07ae,0x039e04e1,0xfee901ac,
0xf6a1fafc,0xef5ff26d,0xed54edcd,0xecdeed3b,0xea80ebcd,0xec72ea58,0xf3d9f00e,0xf815f65d,
0xfc4ef9b8,0x0403ffa9,0x0b650839,0x0ca70cf1,0x08b20b04,0x062f06b7,0x07ee06f1,0x095008d7,
0x08860948,0x078d079f,0x0a3908b2,0x09fb0afb,0x024706de,0xf80dfce1,0xf506f550,0xf8dff68e,
0xfca5fb2a,0xfe11fd8c,0x000efeca,0x043301ed,0x062905d4,0x036704ff,0xffbe0195,0xfb6cfd78,
0xfa2bfa54,0xfad6fa83,0xfb35faf9,0xfc5bfbae,0xfd6ffcfa,0xfce0fd7c,0xf8b1fb28,0xf33bf5c6,
0xf2d1f20c,0xf95af587,0x008dfd8f,0x0358027c,0x07b104e4,0x0ef10b70,0x1191110e,0x103a10f2,
0x0f9a0fc5,0x0ebf0f4c,0x0d3e0df9,0x0a360c0e,0x03bf071e,0xfe8200bd,0xfaa1fca7,0xf5edf871,
0xf086f32e,0xebf9ee20,0xeb03eab9,0xef3aeccc,0xf1bcf10f,0xf18af1aa,0xf602f2b9,0x01d4fb9e,
0x08870693,0x06e0082b,0x075f0654,0x0bc10999,0x0c810ce6,0x097a0b26,0x069e07c1,0x056105da,
0x063e0572,0x07ee077a,0x04cb06de,0x022802fd,0x017801eb,0xfdc90028,0xf6abfa7b,0xf17ff34b,
0xf4b1f1ea,0xfe39f947,0x05b80288,0x06ef0738,0x0458058b,0x03e603eb,0x01f10367,0xfd3dffe9,
0xf76afa47,0xf55cf586,0xf951f6f5,0xfc5efb6d,0xfaa8fc11,0xf89ff938,0xf9f5f90a,0xfa6ffa9e,
0xf7b9f956,0xf8aff702,0x031afd0c,0x0e080944,0x11b410de,0x110e1164,0x10ec1105,0x0ed1102e,
0x0b820d40,0x083809bc,0x06920718,0x04f8060a,0xffec02c8,0xf920fc9e,0xf28df5b4,0xeeeaf03a,
0xee85ee72,0xef4feed7,0xef0aef6a,0xeeb4ee7c,0xf39af079,0xfb35f76f,0x0057fe26,0x032101e9,
0x07d3050b,0x0d690ae6,0x0f4b0ed3,0x0d890eb9,0x0a0e0bba,0x08c8090e,0x08e608df,0x066e081d,
0x01ba0424,0xfe1affac,0xfe60fdbc,0xff22ff1f,0xfde6fe97,0xfc78fd67,0xf8edfabf,0xf7d1f7c8,
0xfabff8df,0xff7cfd33,0x03360186,0x062504a1,0x07610731,0x03550605,0xfd4e0019,0xfa24fb5e,
0xf78ef901,0xf659f69b,0xf75cf6cc,0xf8bbf808,0xf9dff94b,0xfc06fab8,0xfe3dfd46,0xfe99fea3,
0xfe8bfe7a,0x0086ff19,0x05c102b4,0x0cab092d,0x11b40f83,0x133e130b,0x10cc125c,0x0ddd0f70,
0x09320bb6,0x052b070a,0x01af0376,0xfd6affd7,0xf7d8fac0,0xf24df508,0xeebaf00b,0xede5ee1c,
0xecd3ed5a,0xecbbec84,0xf0a5edfa,0xf7fcf460,0xfc40faa5,0x0002fdd5,0x06770333,0x0b310949,
0x0cfd0c44,0x0f330e0a,0x0f350ff6,0x0abb0d38,0x079208a5,0x065006f8,0x027d04da,0xfdb8ffe3,
0xfcf9fcb9,0x0034fe53,0x00a00122,0xfba5fe67,0xf85ff975,0xfaf1f8e6,0xffe2fde0,0xfe48fff9,
0xfa38fbcc,0xfc5efa5f,0x0200ff47,0x05a30452,0x057f0619,0x02cd0445,0xff8d0127,0xfbd8fdb0,
0xf73ef9ae,0xf350f4e9,0xf2f4f294,0xf6bdf456,0xfc98f9b2,0xfed0fe72,0xfe17fe48,0x0172ff10,
0x081304e5,0x0aad0a31,0x09140a12,0x095408ac,0x0ed30b88,0x14731222,0x133714e5,0x0bbd0fc8,
0x060c0855,0x00e603da,0xf7dbfcb4,0xef85f329,0xed39ed78,0xf00bee6e,0xf130f13a,0xeed5f025,
0xef04ee48,0xf4fbf17d,0xfafef887,0xfce4fc34,0xfff9fdf9,0x05f802c5,0x0c380957,0x0ee70e34,
0x0e230eba,0x0ca60d5f,0x0cc40c62,0x0ce80d4c,0x06d50ac4,0xfe3101fe,0xfcabfc58,0xfea2fdce,
0xfce1fe2c,0xf960fb11,0xf8cdf87d,0xfc64fa4b,0xfebbfe14,0xfd44fe55,0xfc03fc28,0x0002fd80,
0x03a4027d,0x01a20316,0xff1d0013,0xff41fea5,0x02ba007d,0x063204ec,0x01b40526,0xf78ffcd3,
0xf14af377,0xf1ccf106,0xf42bf2d5,0xf670f55a,0xfa49f7ea,0x0264fddd,0x0aac0723,0x0c810c66,
0x0a9b0ba0,0x0a690a08,0x0cef0b85,0x0d830dcc,0x0abb0c38,0x0ad10a14,0x0e0a0c7b,0x0bae0e16,
0x01220703,0xf627fb3b,0xefeef27b,0xec42eddf,0xea94eb1e,0xebfeeadc,0xf0c6ee01,0xf614f3aa,
0xf875f7c1,0xf92ff8c4,0xfbc3fa1c,0x016afe44,0x08b2052f,0x0db40b9b,0x0ef00ed8,0x0f350ebf,
0x11fb1088,0x1055123b,0x07670c86,0xfe82024c,0xfd35fcc7,0xff1ffe6c,0xfc33fe4e,0xf7e6f9be,
0xf7fcf745,0xfb1cf968,0xfcfafc67,0xfd15fd02,0xfea9fd89,0x00e8ffe9,0x01df019f,0x02110215,
0x026a0233,0x01c6027d,0xff7000a2,0xfe8dfea2,0x001fff62,0xfee20019,0xfb41fcf3,0xf868f9b4,
0xf64bf745,0xf36cf4f6,0xf289f23e,0xf7e6f44a,0x019dfc8b,0x0a1e0672,0x0dfd0c9b,0x0f8b0eeb,
0x0f2f0fb5,0x0beb0dd1,0x09f90a70,0x0b9b0aa4,0x0c2d0c3f,0x09670b41,0x055f074e,0x016203a1,
0xf9f5fe23,0xf0dcf56b,0xe9f9ecde,0xe825e875,0xe925e863,0xed53ead3,0xf3e9f08c,0xfb4df771,
0x0211ff11,0x044103bc,0x0492044e,0x07050574,0x0b74093d,0x0ead0d65,0x10640fa1,0x10b410da,
0x0ca80f2c,0x074a09e3,0x020304d1,0xfc7dff50,0xf863fa35,0xf6e2f727,0xf8edf789,0xfb0cfa44,
0xfb0ffb28,0xfbf2fb42,0xfd83fca7,0x0028feb2,0x02ea0199,0x045f03c8,0x03550436,0x000f019d,
0xff27ff1e,0x01d80046,0x02e30309,0xfe910138,0xf953fb84,0xf91af87e,0xfa1cf9e8,0xf86cf981,
0xf55cf6fd,0xf37ff3f5,0xf7a7f4b8,0x000efbd8,0x06ae03b8,0x0be90954,0x11110ea0,0x142012ff,
0x13a41458,0x0f5811f6,0x09390c3f,0x05d206fd,0x0517055f,0x02bc0473,0xfb4cff92,0xf3acf6de,
0xf10df1fe,0xef77f03d,0xed65ee8a,0xeb10ebfd,0xed10eb5d,0xf273ef85,0xf932f5bd,0xffcffc97,
0x06ae0327,0x0ceb0a30,0x0dbb0e06,0x0cd30d16,0x0d960d2e,0x0d5d0dc4,0x0c0e0cc1,0x09f50b49,
0x06050815,0x014403b1,0xfc67febc,0xf8b5fa6f,0xf658f74f,0xf63df612,0xf758f6b7,0xf9c8f85c,
0xfcdcfb57,0xff4efe23,0x020c007a,0x051603a4,0x05c105e0,0x03a404db,0x028802b4,0x034302c4,
0x015102f6,0xfbe1fec1,0xfa1cfa3a,0xfc9ffb46,0xfb43fcc0,0xf568f870,0xf2b6f33e,0xf5d8f3cd,
0xfa69f848,0xfdb2fc2e,0x0164ff59,0x06c103ec,0x0c4109a7,0x0f670e26,0x110c1058,0x125611c1,
0x11bc1262,0x0e5f105e,0x089c0bb4,0x015f0504,0xfa9afdcc,0xf550f7d6,0xf1c4f323,0xeff9f0da,
0xee14eeeb,0xee8aedf6,0xf001ef58,0xf1b6f0c2,0xf3d3f2d4,0xf811f53d,0xffddfbdc,0x06610367,
0x0c530955,0x12460f67,0x15b11499,0x122f14e2,0x0b260e9a,0x079408ba,0x058e06d3,0x01410395,
0xfe17ff92,0xfbc0fcfa,0xf9aefab3,0xf833f8dd,0xf66ef776,0xf4bff54d,0xf7aaf587,0xfddefaa5,
0x028e0069,0x05ca0445,0x076306ef,0x06900741,0x04b5058b,0x03aa0417,0x00f502ac,0xfd1cfeff,
0xfb68fc06,0xfa47fb01,0xf920f989,0xf89af8e3,0xf813f85f,0xf763f7ca,0xf65df6c6,0xf78ef65d,
0xfdc9fa2f,0x04d10150,0x09c4078d,0x0d040b6f,0x0ffc0e8f,0x11841110,0x10b01155,0x0f780ffe,
0x0def0ee4,0x0a1a0c62,0x033e072b,0xf896fe60,0xee04f2e9,0xe9f9eaef,0xec63ead8,0xee7ced9d,
0xf04eef5c,0xf1e3f10b,0xf5ebf37b,0xfad3f8a3,0xfc4cfbfd,0xfd1cfc65,0x03e1ff68,0x0f8b09d2,
0x1523137e,0x143d1506,0x12fb1377,0x10881222,0x09890dba,0xfef3045b,0xf77dfa47,0xf792f6d7,
0xfa78f903,0xfc37fbce,0xf9fefb7c,0xf782f888,0xf81df768,0xfadff98d,0xfc1efbb3,0xfeeffcfe,
0x049901a6,0x08cf0700,0x0ac40a17,0x08e90a76,0x03970669,0xfece00de,0xfc00fd12,0xfa31fb16,
0xf81df914,0xf798f785,0xf813f80d,0xf60ff75e,0xf4d7f4ee,0xf8d6f646,0xfe8bfbcc,0x01780056,
0x02ec0214,0x08cb0511,0x11440d43,0x13db1393,0x10bb128d,0x0e580f33,0x0e0f0e19,0x0ca80dd9,
0x070e0a60,0xfe9e030f,0xf630fa1c,0xf108f34b,0xec7feee4,0xe7a4e9de,0xe766e699,0xee1dea0c,
0xf687f26b,0xfd1efa17,0xfef2fec1,0xfe6cfe60,0x02c0ffed,0x09e20662,0x0dfb0cb2,0x0e6a0e42,
0x117e0f63,0x14c913af,0x10f213db,0x07c30cb1,0xfed002e4,0xf916fb83,0xf613f75e,0xf4c1f531,
0xf4b7f49b,0xf69df549,0xfb1ff8af,0xfe1afd18,0xfe30fe5a,0xfe8dfe2c,0x0059ff4a,0x044e0221,
0x086e0690,0x09760951,0x07e208d2,0x059c06e0,0x01c80408,0xfb35fed0,0xf50df7b8,0xf2d1f36c,
0xf493f345,0xf7b1f640,0xf826f853,0xf76df797,0xf9baf823,0xfe7efc03,0x036a00dd,0x088005f9,
0x0cae0ac0,0x0ec80e0a,0x0f700f0a,0x112e102d,0x11171188,0x0e530fe4,0x09cb0c41,0x02850687,
0xf9bbfe2c,0xf35cf61c,0xef37f14c,0xeb07ed08,0xe912e9ba,0xeb12e992,0xf023ed70,0xf55af2d4,
0xfa77f7d0,0xff9ffd05,0x05a3025f,0x0b2808e8,0x0bfa0c08,0x0ceb0c26,0x100f0e71,0x122911a5,
0x0ffc11c3,0x0aca0da8,0x043a07b5,0xfd02007a,0xf8f1fa65,0xf7bff835,0xf5acf6ea,0xf2a9f420,
0xf226f1c2,0xf87df486,0x0028fce5,0x02a201f7,0x032202c9,0x059d041f,0x08380735,0x075f0843,
0x047805e0,0x037c03af,0x035a037e,0x01c002cc,0xfdd50028,0xf7b1fac1,0xf310f4f4,0xf219f20c,
0xf31af2a3,0xf3ebf345,0xf884f594,0xffb0fc2a,0x0449027d,0x0637054d,0x09a20799,0x0e0d0bcf,
0x11350fd5,0x114611d5,0x0df40fdb,0x0be50c66,0x0c930c32,0x09af0bf4,0x009005aa,0xf680fb1b,
0xf1b5f37b,0xeda1f00b,0xe7c9ea99,0xe699e647,0xecaee8e7,0xf510f122,0xf94cf7cb,0xfb3cfa2b,
0x003dfd37,0x08b5045a,0x0e6f0c65,0x0ec10eea,0x0fcb0efd,0x10e5109e,0x0fcb1097,0x0c0a0e67,
0x04c108b9,0xfe47011f,0xfbb6fc85,0xfa8bfb58,0xf709f925,0xf3f7f51d,0xf4c1f3ec,0xf73ff5e1,
0xf972f87b,0xfa8dfa0d,0xfe60fbce,0x06ae0229,0x0d310aa9,0x0cc70dc5,0x08690ab7,0x046e0636,
0x01e00329,0xfee3007d,0xfb33fcf6,0xf7eef943,0xf75df740,0xf7a8f7d0,0xf4b5f6b5,0xf0dcf273,
0xf257f0bf,0xf7c1f4e2,0xfd53fa93,0x0473008b,0x0c92089a,0x11500f8e,0x1091116d,0x0e600f5e,
0x0d4e0db7,0x0d780d41,0x0d650db3,0x09950c18,0x029c0629,0xfd54ffa8,0xf91bfb65,0xf264f61e,
0xeb78ee99,0xe9f7e9d0,0xedc0eb87,0xf1deeffc,0xf5a3f3b4,0xfa59f7b6,0x0157fd99,0x079904fc,
0x09670902,0x09530962,0x0b0009cb,0x0f0e0cdb,0x10691084,0x0af30e70,0x031806de,0xfe5c003a,
0xfbc6fcfb,0xf8abfa4e,0xf596f6ec,0xf4e0f4d6,0xf746f5c7,0xfa83f910,0xfbdffb68,0xfd75fc73,
0x01a3ff39,0x06ce043f,0x0a8908ed,0x0c9d0bb2,0x0dd10d5e,0x0ce10dcb,0x084c0b08,0x016204ed,
0xfb03fe09,0xf647f879,0xf35af47f,0xf2f4f2f0,0xf34ff331,0xf387f373,0xf3edf3a4,0xf568f47a,
0xf798f678,0xfb68f906,0x0299fea0,0x0a10068b,0x0ff00d29,0x1436125a,0x14dc1531,0x1017131b,
0x09b80cc6,0x065007a1,0x044d0567,0x012302e2,0xfd0bff45,0xf7defa90,0xf397f574,0xf186f256,
0xeff2f0c1,0xef4cef58,0xf2bff06a,0xf9ecf614,0x0072fd6f,0x051602f0,0x081b06d0,0x09bc0912,
0x0a580a24,0x0a020a41,0x08750966,0x05bd0741,0x029e0434,0xff46010a,0xfc2ffda7,0xf959fac5,
0xf6a6f7f3,0xf508f5a9,0xf519f4c4,0xf7ebf613,0xfd24fa76,0x00f6ff3c,0x0389023f,0x06d90500,
0x0b1a08f4,0x0df70cdf,0x0e2c0e5f,0x0d470dc2,0x0c080cc5,0x09230ae6,0x031806a6,0xf98bfeae,
0xf0b7f4ba,0xed43ee2f,0xeeceedc3,0xf039efa2,0xf1b1f0d3,0xf42af2c5,0xf849f606,0xfc74fa96,
0xfea3fdc9,0x00c2ff7f,0x069302fa,0x0fb40b2e,0x14971310,0x13d514a2,0x121912ee,0x0f611111,
0x08980ca2,0xfe71039b,0xf74af9ff,0xf6d5f674,0xf864f7ad,0xf875f8c0,0xf607f764,0xf451f4e4,
0xf578f48c,0xf8a7f709,0xfb09fa00,0xfe88fc58,0x04ca0174,0x09e807ac,0x0c370b65,0x0b140c21,
0x0756094e,0x03d9056b,0x00900229,0xfd18fed4,0xfa05fb61,0xf8c8f919,0xf851f8b5,0xf602f75c,
0xf4a9f4e5,0xf7b1f5af,0xfca0fa2c,0xffc8fe79,0x0190009f,0x06de0390,0x0e750ada,0x112d10ae,
0x0eeb104c,0x0d190db8,0x0d270d0d,0x0c0d0d15,0x06ae09ea,0xfe7502be,0xf6a4fa31,0xf223f416,
0xee01f039,0xe971eb89,0xe927e873,0xef43eb93,0xf6ebf335,0xfcf6fa25,0xff7dfec7,0x0033ffa7,
0x047401d7,0x0ac307ad,0x0e850d4b,0x0ed10ec8,0x10e20f68,0x13451281,0x0fcb1263,0x07790bff,
0xfee902e3,0xf8e1fb86,0xf541f6dd,0xf393f425,0xf3a0f372,0xf573f438,0xf997f758,0xfcb4fb8a,
0xfd72fd3c,0xfe5cfdc2,0x005cff34,0x0466022d,0x089e06af,0x0a1f09af,0x095909ea,0x0754088c,
0x035b05ac,0xfcdb005d,0xf6bdf974,0xf3f4f4e8,0xf4bef3f1,0xf736f602,0xf7b9f7cc,0xf74ef753,
0xf9acf819,0xfe1efbd4,0x029e0047,0x076d0502,0x0bae09ae,0x0e1d0d33,0x0efb0e85,0x10a70fb6,
0x109110fd,0x0de70f6c,0x09710be0,0x025a063e,0xf9e0fe2a,0xf3acf65e,0xef95f1a1,0xeb89ed75,
0xe9baea51,0xeb9fea37,0xf06eedda,0xf58ef30b,0xfabcf80c,0xffedfd54,0x05d102a5,0x0b490904,
0x0c580c43,0x0d470c90,0x10070e9e,0x11d51169,0x0fa81164,0x0a8c0d5e,0x0412077e,0xfcf10060,
0xf8d5fa53,0xf78af80c,0xf56ff6af,0xf267f3e2,0xf1d2f176,0xf81ff42b,0xffe9fc8e,0x028801cb,
0x031702bc,0x058e0410,0x0839072a,0x07860858,0x04b80614,0x03c703f6,0x03ab03cd,0x021b0323,
0xfe260082,0xf7e8fb07,0xf32df51d,0xf227f221,0xf31bf2ab,0xf3e0f340,0xf86df582,0xff92fc11,
0x042f0261,0x06210536,0x09830780,0x0de50bad,0x110d0fac,0x112a11b2,0x0dea0fc8,0x0be10c61,
0x0c8a0c2f,0x09a30be9,0x008b05a0,0xf684fb1b,0xf1b9f37f,0xedaaf00f,0xe7dceaa7,0xe6abe65b,
0xecb7e8f5,0xf514f128,0xf951f7ce,0xfb41fa2e,0x003ffd3a,0x08b6045b,0x0e710c67,0x0ec30eec,
0x0fcb0eff,0x10e3109e,0x0fcb1096,0x0c080e65,0x04bf08b6,0xfe46011e,0xfbb6fc84,0xfa8afb57,
0xf708f925,0xf3f7f51d,0xf4c0f3eb,0xf73ef5e0,0xf971f87a,0xfa8dfa0c,0xfe60fbcd,0x071e0229,
0x00000513,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};
