#include "trumpet_samples.h"
const AudioSynthWavetable::sample_data trumpet_samples[5] = {
	{
		(int16_t*)sample_0_trumpet_htrumpetd2, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-43) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(84) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1673 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1669 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1669 - 1) << (32 - 11)) - (((uint32_t)1628 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-5.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(536.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-2.3)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_trumpet_htrumpetg2, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-20) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(88) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1635 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1631 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1631 - 1) << (32 - 11)) - (((uint32_t)1598 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-5.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(536.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-2.3)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_trumpet_htrumpetc3, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-1) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(93) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1652 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1648 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1648 - 1) << (32 - 11)) - (((uint32_t)1598 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-5.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(536.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-2.3)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_3_trumpet_htrumpetf3, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(24) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(98) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1496 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1492 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1492 - 1) << (32 - 11)) - (((uint32_t)1454 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-5.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(536.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-2.3)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_4_trumpet_htrumpetax3, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(-4) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(103) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1662 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1658 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1658 - 1) << (32 - 11)) - (((uint32_t)1602 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-5.2)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(536.20 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-2.3)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_trumpet_htrumpetd2[896] = {
0x00000000,0x0002ffef,0x00190017,0x00110014,0x0002000d,0xffd7ffe6,0xfffdffe7,0xfff10002,
0xffeeffeb,0x001a0000,0x00060014,0xffe7fff4,0xffe1ffe5,0xffefffe9,0xffefffef,0x000c0000,
0x001a0015,0x00100022,0x00100006,0x00060002,0x0006000c,0x0027fff3,0x02a80006,0x029e04c6,
0xfda20280,0xfc12fbd5,0x0045fbb1,0xff77ff66,0x0211ff11,0xffb00028,0x0073ff5e,0xfe7c0058,
0xfebafe3c,0xff2cffef,0xff58ff85,0xfadbfd4a,0xf1e3f512,0x0a63f87e,0x20c218a3,0x08281a08,
0xea6cf73b,0xeec8e89f,0x0489f9c5,0x164d0ebf,0x0af310de,0xed00f57d,0xf8b4ef7d,0x02c60374,
0xfeb40113,0x02690107,0xfca301ab,0xfc8cfb77,0xff39fde0,0x0224fff9,0x00e40200,0xfc6afbb5,
0xf8ebf9b5,0xf78df634,0xfde9f79f,0x19a90da0,0x28f1293c,0xf217125a,0xe2f7e118,0x0159edfc,
0x03ae0306,0x04f9035f,0x014f04b9,0xf726fa20,0xfb8bf924,0x00dbff16,0x06210381,0xff0b0423,
0xfc96fb73,0x0032fccf,0xfeccff1a,0xfe36ff1a,0xf740fc58,0xf332f718,0xfe53f06d,0x132f0a3a,
0x449f24b4,0xf0424b78,0xcb61c087,0x01d0e554,0xfdd2ffee,0x05d8fdfe,0x097f05c5,0xfccb0304,
0xf846f866,0x046c00d4,0x010b0330,0xfe31003d,0xfb55fb65,0xfaeff936,0x0006fb64,0x04a403d4,
0xff1103b4,0xf723faa1,0xf319f0ce,0x014ff8cc,0x26ed0ee1,0x3b9e5f54,0xbb57ba9e,0xf6c0cfe1,
0x06dbfe38,0xf627fd1a,0x15b201fe,0xfeea1baf,0xf2f8f2a6,0x01ba0111,0xfc35038e,0xfe0cff20,
0x0010ff92,0xf608fe62,0xfcaef735,0x0527002c,0xfe700285,0xfb2afc60,0xf93cfa72,0xfed0fe20,
0x185d0768,0x57c15165,0xb52dce52,0xe319c58a,0x0d36fae1,0xf9d704cd,0x0ad502e6,0x02d41216,
0xfc75fd28,0xfea70436,0x02eb0512,0x0095fc4d,0xfde1fcfc,0xf70bf79a,0x0051f9e6,0x00d10036,
0xfe4802dd,0xfee4fdd0,0xfa2ffd22,0x01cafc81,0x14f70639,0x66d344d8,0xa540e4d6,0xd2d1c2da,
0x0485ef60,0x06be11ce,0x0a550d5c,0x01010d0a,0x00400457,0xfc1b0093,0x0093ffab,0x0282fcd0,
0xf96cfad6,0xfea2fa07,0x0182010c,0x0171fe58,0xff030154,0xff73fc39,0xfb3502ee,0xfe52f882,
0x0bfd010e,0x52971c79,0xd57a5dee,0xc32da54c,0xed12d88d,0x1357066d,0x0c8e0b2c,0x06011146,
0x005d0626,0xf79ffd96,0x046afe4e,0x03bc0185,0xf7affe01,0xfabef2e7,0x0559fed6,0x024b03a0,
0x02600389,0xfeacfece,0x0218feae,0xf853fb55,0x0343ff94,0x1bc507c9,0x56bb56a8,0xa7f8b8aa,
0xdeeac44a,0x0d7ff15b,0x0a5d10f0,0x084c0e1f,0x0aeb0b31,0xfea606db,0xfc05fb61,0xff44fda5,
0xf9ba041c,0xf795f3d5,0x050ffea6,0x033d06a3,0x03dd0148,0x021304ae,0x036602c9,0xff5a05a5,
0xf516fafb,0xfeb0f405,0x42790ff7,0xcedd6d79,0xd2d09b54,0xee57d9ab,0x13b3037e,0x0db803ad,
0x0c590ee4,0x089e0fe3,0xf6fcfc7d,0xf8c6fa33,0x0577001e,0xf7dd0015,0x0103f805,0x0667055d,
0xffba03ab,0x0697025f,0x04e105f7,0x07850715,0xf99803b2,0xedcbf371,0x04aef765,0x587a1a0c,
0xa282558f,0xd4ebb6f7,0xeaa6e9fe,0x06c004e8,0x1b68047e,0x143c0e7f,0x03060af9,0xfad3f372,
0xfafdf503,0x067f0365,0xfb27016f,0x0278fbf9,0x05cf053c,0x019900a6,0x094803bc,0x0a06090a,
0x09670d03,0xed6cf9e6,0xedfdef2a,0x0e9ff7e3,0x6f4e2a7e,0x8e0112ce,0xd60addbf,0xeb78ee94,
0xfed30a7c,0x1cc8165d,0x13470ca4,0xf932064a,0xf824f10e,0x0295efba,0x0cc20a7e,0xffbf05d1,
0xfe4afa99,0x012b021b,0x01fefd3c,0x0d3b0a29,0x0d920990,0xfbc50a0e,0xed1def3c,0xf8c9f051,
0x2049016d,0x60a34e49,0xbeb5a462,0xddc3d548,0xfb5fedb9,0x09920c8f,0x0ac322b6,0x0c721064,
0xf1cf011a,0xf118f706,0x09dbf9ea,0x0b580cc0,0xfd570536,0xff20f952,0xfa890304,0x0781fdd2,
0x0b8b0b45,0x0c1f0c34,0xf7bb0187,0xef4bf3db,0xf876ef37,0x2c9d10b4,0x12946f41,0xdaa28e01,
0xece5c87f,0x1053eaea,0x1d79059c,0x08111c42,0xffe911c6,0xee97fbd8,0xefbcf81d,0x0c8e03ae,
0x0ca21268,0xf989048c,0xffa1fa47,0xf6ebf7f1,0x09cf01ff,0x0b920e64,0x06d80b07,0xf86cfe7c,
0xedaff72d,0x046ff30b,0x47c218a5,0xb45968fc,0xd5fdb074,0xed63dea9,0x0e12fc13,0x20c00bd4,
0x0bf5098c,0x02da0838,0xf5d3f75f,0xf8eaef5e,0x10fd07dc,0x0d941137,0xf88efb85,0xf777f4e0,
0xfd96f48b,0x0de80c89,0x086e0d58,0x04d00db2,0xf506f91d,0xf4a6f3b4,0x10d4f7bd,0x720a2ee5,
0x9158f84d,0xcaa8de6b,0xed3ff398,0x0add0f30,0x0ff71de6,0x0e830630,0x044ffcdd,0xf2fcf412,
0x0906ee6c,0x10fd08ab,0x022216d6,0xf08ff398,0xf3e0fa3c,0x0934fcca,0x088b0cca,0x0be00a2c,
0x00760bf9,0xf420f66e,0xf71df05b,0x1f5505fc,0x3b4f616c,0xd5fa9050,0xeb13c7e0,0x02d4eccb,
0x0ef70d77,0x024319d9,0x027c0f41,0xfe8d0741,0xebbbf9a8,0x0557fdc7,0x1a590afd,0xea500603,
0xf4daf3f8,0xfe1bfb6d,0x07b6056d,0x0b820830,0x0d250e0a,0xf8da0566,0xf0c0f524,0x0169f498,
0x4a8113d9,0xaeb16498,0xd1adba8b,0xf034d727,0x128df854,0x19680a7e,0x08dd0a3a,0x010d06db,
0xfc30016d,0xf831ee28,0x09900441,0x0c151684,0xf28eecf3,0xfd04f353,0x022bfeda,0x0a4b0839,
0x0be50db6,0x095208a5,0xf7d1fc0e,0xf45eefa2,0x0baff604,0x720a3007,0x9b09ed43,0xca12d9a1,
0xeb34f21a,0x0c54107b,0x114f1086,0x0ceb0623,0x05a503d9,0xf3defb7c,0x0371f0e6,0x160e03ee,
0xf1c50f37,0xf330f22b,0xfd32fa9e,0x07290047,0x0d080c3d,0x095b0b55,0x00f50864,0xf577f72b,
0xf95cf31f,0x2743fec8,0x14826e4a,0xda6b933a,0xf306c38e,0x0777e957,0x0c410ffa,0x07681044,
0x01890c9a,0xfb2f0b90,0xec87f8c2,0xfe3600c9,0x10de14e9,0xf7c2f372,0xf5abf446,0x0386fd06,
0x0dc00995,0x0a000a30,0x07d708df,0xf9020268,0xee0af906,0x028cf3c3,0x5fea1af0,0x92924196,
0xc646d1ee,0xec45e7ed,0x0dceff24,0x11eb0c59,0x11ae08b6,0x09affd83,0xf704fd78,0xff59f034,
0x0c7701ef,0xf9281a64,0xf8ccf0ca,0xf7b0f24d,0x0c8f02ca,0x0c100b7b,0x05c504ae,0x0760042b,
0xf446fcf2,0xf4f0f581,0x1eed00c3,0x4cbd5825,0xca6e945c,0xe3c7c8b5,0xfb47f06d,0x08b60a74,
0x0c2714ae,0xfb8b16d0,0x027c02e6,0xf1e3f721,0x014afba7,0x168609d6,0xeadd059e,0xf424fabf,
0x010df83a,0x0cac0ac0,0x02c10bdb,0x02900421,0xfde105be,0xfa72f8b9,0xfe6cf177,0x53231b89,
0x9c9c5676,0xcb7ec060,0xf23ae17a,0x0d9bf7c2,0x13ae023a,0x19760c4f,0xfe8000fd,0xf5d8025a,
0xfd83f06e,0x096e0111,0x09d9140e,0xf641f121,0xf753f96f,0x0342000c,0x09f70aed,0x027c04de,
0x06cf037a,0xf9c500d1,0xf4daf639,0x132afcda,0x6799468a,0xb206ad37,0xdb17cf71,0xf210f550,
0x03890cfe,0x0d011099,0x08451c51,0x002cfc6a,0xf06ef3ab,0xff44ffa3,0x14530978,0xf8c805d3,
0xf858f3a1,0xfe8ff86f,0x0a30018f,0x072609a5,0x058e0310,0xfe8409ac,0xf324f858,0xfb99f910,
0x40250f0b,0xbe656d7e,0xd1caa63e,0xf6f7d6a0,0x0cd4f062,0x0cf501c1,0x1d060ce4,0xfb03118a,
0xf2f3ff7b,0xfcfcf07c,0x06a700b5,0x046a13c1,0xfab6fd69,0xfacef396,0x01b8fca0,0x092d05b8,
0x071f0549,0x09d00799,0xf876fa51,0xf95ff2a5,0x0ff7ffbe,0x70723aa3,0xa08bc9b6,0xd0cfd078,
0xf24df922,0x01850d3d,0x0c020af2,0x18bc19ea,0xfe09fde4,0xedc3f2be,0x02a2ff2c,0x140702eb,
0xf98e0566,0xf2aefefc,0xfdb7f731,0x061003d4,0x0444085d,0x091c066e,0xfa2d094d,0xf853f8a9,
0x01fbf52e,0x33b80b97,0xd6fc720a,0xd1749aa3,0xf9d8cf4e,0x0ca0f1cf,0x0a28fd65,0x1b010d27,
0x022e1a32,0xf217fe24,0xf8a0eea2,0xff5a04a9,0x0809148d,0x0354f986,0xf2c2f659,0x0039fc8c,
0x0721078f,0x06be0512,0x08670b04,0xf2ddfd47,0xf53df77f,0x0eca0281,0x720a2b29,0x9116ed01,
0xca24cee8,0xf1defc84,0xfd8d0d08,0x0aaa070e,0x1d0f1943,0x0272037f,0xed97eee0,0x0559f7bb,
0x1416fe58,0xf8b80a3d,0xfb9404d7,0xfa24f0f7,0x057efe84,0x08080729,0x0a40045c,0x008b0707,
0xf38cf45a,0xffc5fcd4,0x2d2b1348,0xe621720a,0xcbda91f2,0xfd51ca69,0x0fdbf2fb,0x05aafe98,
0x16b20a58,0x02631df5,0xf0e204cd,0xf90de9e9,0x01890386,0x0baf0fd5,0x05c8f7c5,0xeef402ff,
0xfd26f7da,0x08d80502,0x03ef0922,0x092807b6,0xf774fd91,0xf82df183,0x176e04b9,0x720a37fc,
0x9b26d02f,0xd012c6c1,0xf88cf8d2,0xfe761290,0x08dd081b,0x1bac1915,0x0354016a,0xeaf0f024,
0x0260fa65,0x0e3e03b2,0xfbb50522,0x0b2906ef,0xf442eef2,0x02f2f9ae,0x06a809f6,0x03c50575,
0xff710b5d,0xf217f8f2,0x0f9bf454,0x46301c57,0xad1d689c,0xbf0faade,0xf80fdd53,0x1354fe31,
0x0820fc3f,0x18d30711,0xfe0a1a61,0xf2abff32,0xff46ee13,0x03e4038c,0x001908f2,0x0673fbcd,
0xf56911d5,0xf94af047,0x081b00e1,0x07b80433,0x089e0358,0xf9c5fe2b,0xf95af512,0x2b5511ca,
0x3cce5f4a,0xbe988e01,0xef70b9a2,0x0b0ff25f,0x00c91033,0x04780741,0x11501867,0xffc5ffbf,
0xf094f2a4,0x0076044b,0x016a0a63,0xfffff7e3,0x15610760,0xedc5fc73,0xfa6df962,0x0418068b,
0x04ed09e8,0xff1704b8,0xf01afda8,0x136bfb41,0x7023373f,0x8e01fc2f,0xc3cbc643,0xf541fc12,
0x0a70124e,0x05a501b5,0x151b0663,0xfd610dcc,0xf437fa84,0x082cf7b4,0x09f6033d,0xf15bfb34,
0x08c001e8,0x01fe1726,0xf884eda1,0x00a6f9c9,0x0a9305f3,0x010308ab,0xfe38fb3d,0x060df427,
0x4e43184f,0xb1ad6378,0xbaf1a863,0xfc34de63,0x1382014b,0x0610073d,0x07ba0029,0x0c5c0da3,
0xf977fdf7,0x020cf532,0x08e90555,0xf4c404c1,0x0623f1cb,0x14f50918,0xed1a0577,0xf7a9fbe4,
0x0607fb4b,0x09820e12,0xfc17fee0,0xf686fbbf,0x26f90fe3,0x2e0066c5,0xbfc28e01,0xf4f4b6bd,
0x1218f91e,0x072c106b,0xffeb059e,0x08fd0ada,0xf8f40975,0xf791f955,0x0317070d,0xff1f09e8,
0xf621f19a,0x0d990890,0x060613bc,0xfa6ceed2,0xf906f358,0x1178067f,0xf9540c56,0xf82bfbc2,
0x162002a7,0x6a4b483a,0xa366c5dc,0xce75bb3d,0x0699fbf9,0x081118ea,0x01e20799,0x09870729,
0x038806f5,0xf95ff296,0x08aa00b9,0x076904cd,0xf0d2f92d,0x0a3afd35,0x10670f67,0xf1560411,
0xf098fa98,0x0577f8a6,0x0aa3128a,0xf8f6ff32,0x0693f608,0x68a624a7,0x926130ea,0xb766c060,
0xf54ce91e,0x139f17d4,0x0936073e,0x0fcb02f3,0x068503ec,0xee05fb83,0x05f1fc75,0x09f603a8,
0xf5160148,0x0133f5ea,0x0ff70ca5,0x03d40f09,0xf565f2be,0xfb20f002,0x102c061e,0xfe380e90,
0xf865f62b,0x3d2c0e9a,0xde99714c,0xc25298cc,0xf408c7b9,0x217ffc4e,0x07f40c82,0x0b250599,
0x03e80b4b,0xf51103ca,0xfe70eeac,0x03d707d7,0xf9180a1b,0xf9eef6f6,0x0e9d04a7,0x0ead0f91,
0xf21005a6,0xf26ff0b0,0x0a4bf8c6,0x0eda0d96,0xf376ff4f,0x1702fa67,0x5cd35343,0xb0b3a5c0,
0xdf9dbeb5,0x08a1f1bb,0x05c71fd0,0x0404074b,0x095113fb,0xff1a02c4,0xf19bf375,0x03b80243,
0x05690897,0xf5c1f546,0x074bfe31,0x0cc010e4,0x08c00e44,0xf052eee6,0xf969f3a9,0x0bb90a33,
0x00060d50,0x0448f463,0x65c71d90,0x95403593,0xbf14bdcf,0xef9febc0,0x1ac30fdf,0x065807a7,
0x142406c6,0x02560803,0xf34efd10,0x0343f1cf,0x0a3b0226,0xf55f0390,0xfeccf608,0x10cd0785,
0x0e1c0cca,0xeeba08e9,0xf462f072,0x0a03f9a3,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_1_trumpet_htrumpetg2[896] = {
0x00000000,0x00020002,0x00110010,0xfffa000a,0xffdaffe7,0xffe0ffda,0xfffefff2,0x00110005,
0x00290027,0x0006001a,0xffd2ffed,0xffdeffce,0x0016fffc,0x00550046,0xffea0027,0xffc6ffb6,
0xffc3ffdb,0xffd2ffb9,0x000cfff4,0x00190014,0x0013001c,0x00000005,0x001a000b,0x0011001d,
0xfff10003,0xffdfffe0,0x0001ffdf,0x0113fffc,0x056b0320,0x02df06b7,0xf9e0fed9,0xfbfbf9af,
0xff38fa13,0x0295ffd9,0x02bd02c6,0xfd0f00a9,0xfd7bfb3c,0xfb11fd59,0xf6a4f818,0xf996f740,
0x0c4900d5,0x22f71a9d,0x092c1d9d,0xe8c2f22c,0xf25ae814,0x0381ff60,0x016602c6,0x050d028f,
0xfdc40265,0xf9e9f7ee,0xfdfafb08,0x016b01f1,0xff960404,0xf6b4fc60,0xeea2f1bc,0xfa94f03c,
0x17bb0808,0x36a627c0,0x01a23020,0xd475e184,0xf4a9dcff,0x061d0166,0x063002cf,0x09120acb,
0xf4ec005e,0xf284f3bc,0xff0ff9b8,0x060803e2,0xfdd403a5,0xf2bbf7f7,0xf1faf2e3,0xfc20f236,
0x16bd045b,0x445029cd,0xff134858,0xca08d016,0xf925dcb7,0x00a5fd7b,0x0d3c035a,0x07460cd5,
0xf592fe04,0xee88f082,0x0078f565,0x0c3f08d3,0xfb330393,0xf336f4e0,0xeccaf1d5,0xfae3f34b,
0x11be055c,0x47a3243d,0x05f858c7,0xc944b857,0xf867df1f,0xffe6f2df,0x099e068c,0x0a480dc6,
0xee6d0618,0xed5eea86,0x05e6f7a3,0x063907dc,0xf86fff48,0xf616f653,0xf2daf4c3,0xfd4af68b,
0x10f70408,0x3c2b1e11,0x212c5d6d,0xca37b187,0xe2eedfad,0xfe0ae4cc,0x0c4d0d0f,0x0e751091,
0xf24c085c,0xef26ec65,0xfebff5bc,0x04e5014d,0xfe7d00f0,0xf657f944,0xf741faec,0xf7b1f96e,
0x111f01cf,0x3c441bda,0x3d2957da,0xbd58c2e2,0xdc9ad884,0xf65ee385,0x0b9a0d4f,0x106a15d2,
0xf65804eb,0xef65eb7b,0xfd58f3a0,0x025a0254,0x02310300,0xfbafff10,0xfa56fcdb,0xfc03f9ce,
0x042bfaad,0x1fba11cc,0x59ea4401,0xb88d2cc0,0xd544bfa5,0xe9a0dec9,0x0fe4fd95,0x0fe30e16,
0xfc650483,0xf061f2e8,0xfb33f491,0x00dcfd8c,0x04b102b5,0x034d02f2,0x017c0553,0xf802fb6c,
0xf992f5fe,0x0a14027c,0x3fdc1985,0x40035798,0xb40abfc8,0xdee1d4a2,0xf76ae927,0x0b5f0f9f,
0x02670a82,0xf3bbfd12,0xf509f0f9,0x024bfd16,0x06d50390,0x06000751,0x08a006de,0xfd350579,
0xf039f457,0xfb6cf342,0x119a021d,0x4fb82ceb,0xdc8a5a40,0xd96c96a7,0xe0cbe129,0x0e1ff398,
0x049d01db,0xfd1b08fd,0xf453f62d,0x0248fb70,0x064306b1,0x074506fd,0x08c70642,0x0b0209e8,
0xf650019a,0xeb5beb9d,0xfd06f81c,0x1a8d0ae6,0x63023e0a,0x8dff1542,0xe64ed329,0xea89d862,
0xfaa90754,0x10b0fc1d,0xfb1501e4,0x047dfcdf,0x091f050a,0x02da076e,0x04a60663,0x0a4105ea,
0x06130e4b,0xed67f9d2,0xf54be988,0x0360f8e5,0x374112cd,0x37fc5dad,0xc655969f,0xd334e724,
0x02fae59c,0xf8dbff5f,0x0a6413e6,0x02b5fe0f,0x03de0913,0x08e205c4,0x03a503ee,0x042e038c,
0x0ed507e3,0xf5890ade,0xeed2f067,0xf5e0f8b0,0x1297fe81,0x5a632b04,0x9fad491c,0xe580bcf8,
0xe0b3cd22,0x04bbfe7d,0x17e7fac2,0x022913f8,0x071e0700,0x043d0141,0x062b0c4e,0x030dffe3,
0x075f03e0,0x0b740c99,0xf145f72a,0xf2b1ea5d,0xffb2fca2,0x295d1130,0x5de15017,0xa2ebc081,
0xcdeee30b,0xfae5daec,0xfc950c2e,0x1c851772,0x022406b4,0x025907d9,0x0dd5febb,0xffac0507,
0x034f049a,0x08780764,0xf7270a7e,0xed4ff386,0xfff3f3ae,0x0c4ef8bd,0x48612161,0xe757660f,
0xe07292c0,0xd4d4d2b2,0x126ff7ae,0x104d0207,0x07311fe0,0x066e0170,0xfc780173,0x09890d58,
0x03d9ffc6,0x04930321,0x0bb6053f,0xf3bbfab2,0xed8cee55,0xfbc4fe7b,0x15920ba4,0x62dd411d,
0x8eec1dc9,0xdce3d439,0xeffed306,0x070f0d31,0x1e5b0348,0x00ff0cb8,0x04400538,0x09c4fac9,
0x00630dd7,0x04220176,0x044f03ad,0x02a70a55,0xeefdf26c,0xf9b1ed25,0x02d8f840,0x352f15a4,
0x4ab659c0,0xb9cea77e,0xcebee912,0x0275e4d0,0xffb60887,0x17161d8e,0x056bff5e,0xf9b50581,
0x0d85039c,0xfe68feb2,0x04c00502,0x096b047e,0xf3c0069b,0xe894efbd,0xfa60fa56,0x13cbff8b,
0x51792b4e,0xd4305e49,0xee20a034,0xdd66c96e,0x0883f77a,0x16560524,0xffd71ce6,0x06da041d,
0xfd50fb81,0x00e30be9,0x04c4fa49,0x042f035f,0x0a440606,0xefc4f613,0xf795eefc,0xfeb8fdd2,
0x1fbb1136,0x63b94646,0x91430605,0xcae9e6ea,0xf0ddd5dd,0x0d0a0579,0x233d0a3c,0x02440385,
0xfc8006db,0x05d0f880,0xfa010562,0x02bc0256,0x05c50462,0xfbc20935,0xf115f0bb,0xff74fa52,
0x0bfaf964,0x4263195b,0x2cd15e2e,0xd65e91e2,0xcb52d232,0xfe75ee01,0x052e0f85,0x0cf421e2,
0x09310267,0xf5fcfd62,0x053f00c2,0xffabf9a0,0x04c80295,0x07dc052e,0xf1f100a9,0xf834f71e,
0xf7d40311,0x10450cb1,0x5b8739d8,0xa2594216,0xd964c4cb,0xec76c503,0x0f6af730,0x1bd705c6,
0x004a12f2,0xfed709e2,0xfed8f403,0xfa80045f,0x0388ff3f,0x05200398,0x0777097e,0xf6a7f3d9,
0xff95f6a6,0x0466f705,0x34b412d8,0x56e45447,0xadcebec5,0xbd22e1af,0xf15ce4af,0x08950b58,
0x19e51367,0x077a02bb,0xf4e802ec,0x01b4fa30,0xffd7fa2f,0x02b3064e,0x07fa0706,0xf5930951,
0xf422f61d,0xfdaefd2d,0x13de0229,0x4cb32afe,0xdffa60ca,0xe48c9b54,0xdc89ba47,0x041ced3e,
0x0d6e0dc6,0x03121c72,0x05d90655,0xf694f74f,0xfc260273,0x06dcfef8,0x073903d6,0x09e6078b,
0xf56ff674,0xf91df685,0x053bfe73,0x231e1388,0x61784647,0x90a804e0,0xbc07e0b3,0xeb74d434,
0x10b6fdc9,0x19e20b06,0x07b60460,0xf9cc0647,0x0115f27e,0xfdc0fd06,0x04b309a8,0x081807f7,
0xfcf60a24,0xf98cf08b,0xff26fa76,0x151cfbfd,0x3f2e1e0b,0x1312637f,0xdd2b91d0,0xcdadbd89,
0xf9eceb79,0x0af612a4,0x069317dc,0x06b70601,0xf1e7faf8,0xfd04fe9d,0x0cd8fd27,0x06420866,
0x062f0723,0xf19602e0,0xf888fcf1,0x0330fcd3,0x1ccb0b70,0x61433f44,0x90821b1e,0xbc37db9b,
0xec4bcb5c,0x118ff677,0x16890c21,0x051807cd,0xfaca05a1,0xff54f2eb,0xfef5fcef,0x0a770ee8,
0x03900554,0x04fd0800,0xfa3ef317,0x0365fe44,0x0b4bf4fb,0x38bb16d7,0x35465df2,0xc8f09916,
0xc079c928,0xf2a0ec90,0x0dc00e3d,0x0a451426,0x067a0413,0xf42bfdac,0xfd58fe42,0x0eb2fc76,
0x05a70bf4,0x094b068a,0xf30c0792,0xf684fa7b,0xf94bff39,0x15610581,0x58043336,0xabb14b25,
0xd4c2b4ef,0xe9b6b6b6,0x078df01f,0x13460f1a,0x02bc0d75,0xfe9c07d0,0xfd37f57f,0xfbac0183,
0x0f440c89,0x061006de,0x08f2072d,0xf690f670,0xfd07f88d,0x0509f43b,0x2c9715ec,0x53ef547f,
0xab37b930,0xb471da08,0xf0fde7c5,0x0e7e03d5,0x0c61124f,0x080702fe,0xf7270229,0x02aefcea,
0x0adef97b,0x092d1043,0x06610806,0xf5870980,0xf6e5f42e,0xfbfff6d3,0x1309020f,0x524927b0,
0xb9865700,0xdcdaab78,0xe744b3eb,0x00b4f37e,0x150c0bd8,0x02260c86,0x010105dc,0xfdbafa5d,
0xfa5204c7,0x10a0081a,0x07980aa5,0x085c0460,0xedc0f851,0xfca4fb04,0xff22f9ff,0x29770f62,
0x5ba84ecd,0xa41ebfd9,0xb736dfe9,0xf573e659,0x09fcfde0,0x0d17144a,0x069002f1,0xfac20163,
0x0551ff73,0x075af7c1,0x0b7711fc,0x03fd07b5,0xf7350701,0xf573ef24,0xfe71fb1f,0x11c6fe15,
0x4ed62c37,0xc11c5bf4,0xe098a12b,0xe3feba01,0xfcb6f849,0x14a607ff,0x03020ddd,0x00ff0472,
0x00cffe02,0xfa9d055d,0x11730586,0x07e60931,0x049b041d,0xeff2f641,0xfb13f4fc,0xfc21fdea,
0x2ba81088,0x5fae4c11,0x9a32cd0f,0xbc4ee41a,0xf995ddce,0x0591fbc1,0x0e511511,0x029c039c,
0x0029fefb,0x06e201ff,0x0389fba8,0x08fe11a5,0x040408ac,0xf35b03ad,0xf2b1eeb7,0x02cff83e,
0x106e0045,0x4da22c95,0xc8db5e51,0xe22e9b15,0xdf65bfd8,0xff99f99e,0x133f027f,0x01d90eff,
0xfb7d033d,0x04160058,0xff1a06c3,0x116e025f,0x0733097c,0x02c70360,0xf045f1c2,0xf396f4e8,
0x07a8ffba,0x2efe0e86,0x5ca24e22,0x9c39c571,0xc00ce11b,0xf970e3c2,0x01cf01a0,0x0e351093,
0x033700b0,0xff59f964,0x05af0737,0x03dfffe0,0x083b1268,0x045d03d5,0xf04104fe,0xf0cfee81,
0x00faf84d,0x0f5906a3,0x5118332c,0xc1585896,0xdc8d9d4d,0xe6c9c455,0x0426fb3c,0x0c77007f,
0x023a0dca,0xf7100343,0x0a7bfcc1,0x00460676,0x110e0507,0x030e05af,0x03c80680,0xef20ef0a,
0xf3b3f388,0x04b50619,0x39671086,0x54e45184,0xa405b5cb,0xc6d1d729,0xfb17eb55,0xff72068a,
0x0e580b2a,0x037f0245,0xf8c1f63e,0x077d0af6,0x06e4017f,0x05c60dce,0x07610167,0xeef40563,
0xf0b7ee2f,0x09e3f4c1,0x11b208d2,0x57603ab1,0xa2cd46eb,0xd0dbb333,0xf03acc5a,0x0775faf5,
0x0aba00e2,0x03f709c0,0xf5e001dd,0x0e0af77e,0x00430af2,0x0a2c0878,0x000505a0,0x08240798,
0xef28ed3c,0xf2bdf1d2,0x0b880a50,0x3c3816a8,0x376e5bd7,0xc2b795dd,0xd105c86a,0xfc84f2ec,
0x00fb0863,0x05d0098a,0x010c05bd,0xf75af710,0x0c6d0f26,0x0ac80066,0x047607ff,0x07d50051,
0xeb800889,0xf22ced8f,0x0c47f6d2,0x1b68098b,0x5dd23d8b,0x90b82ef6,0xc6c3c9db,0xf3f4d2b1,
0x085100b5,0x06d7ffdb,0x0971001c,0xfa11fe74,0x0eedfa9e,0xfee10e16,0x05c10cb0,0xfe980242,
0x0b5a09b5,0xef2dec7f,0xf445ef62,0x0b810d25,0x3d361a79,0x26495f85,0xd3718e27,0xd504c26d,
0xfe07f667,0xfdf50997,0xfc8c0837,0x026a0c80,0xfb8ef94a,0x0dea0ab6,0x0d5efe1e,0x01730641,
0x089e00d7,0xed5b0ae6,0xef95f03d,0x0793f80f,0x1fb20be0,0x62993fe4,0x8dff1528,0xbec6dc37,
0xf850d724,0x099d0014,0x0929fd3e,0x0ec2fb49,0xf779012c,0x0a6efd65,0xff670d01,0x05ac0efb,
0x0189ff4d,0x0d500767,0xef75efb3,0xf37eecd5,0x0ea90b8b,0x4426249b,0x09a061e0,0xe0ca8dff,
0xd946bd62,0xfed5f874,0xfe6e0ae8,0xfa9609a3,0x029a0f16,0xff81f6aa,0x08750932,0x108bff92,
0xfc2f05c0,0x086103ff,0xf03709d4,0xeeb7f105,0x0c6df5ae,0x24380c6a,0x634441c9,0x8dff0518,
0xba05e2d5,0xf6d4db93,0x0d4bff4e,0x0a8cff70,0x0e60fac5,0xf69002b3,0x08ef019e,0x008f04a8,
0x04fc0f97,0x0687fb98,0x077f07ee,0xf126f119,0xf7dbeda8,0x10b50ca2,0x45392821,0xf47d63dc,
0xe31890a0,0xdebeb93e,0x0170f779,0x00600c80,0xfd100a8f,0x016b0e0c,0x010cf5a3,0x033d09f0,
0x11a10178,0xf96e05c9,0x0931054f,0xf5160426,0xed15f2e3,0x0f12f36d,0x288d10cd,0x62be4663,
0x9425eab7,0xb783e657,0xf81ce28e,0x0c9402a2,0x07a4020e,0x0be4fd42,0xf5ca0094,0x0afb0376,
0xfff1000e,0x06a5125c,0x0794fac1,0x00a609c2,0xf1a2f7b5,0xf7a7e86f,0x11311075,0x47a827fd,
0xe2fa61ea,0xe6339722,0xe638b7c2,0x0332f795,0x03450b42,0x00cb0639,0xfd6e0a1a,0x0481f6c8,
0xfe980c43,0x124bff04,0xfb660627,0x0b9b089e,0xf4ddfd35,0xea74f291,0x0ec8fc8d,0x2cd01152,
0x6095481f,0x9d77d360,0xb715e460,0xf749ec28,0x093a057c,0x03a2058b,0x0a4a025f,0xf759fd32,
0x0dc50348,0xfef4fd44,0x06011223,0x082afbc8,0xfcb40c49,0xf2c0f55f,0xfc85ea58,0x11640ea4,
0x48d92d0a,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_2_trumpet_htrumpetc3[896] = {
0x00000000,0x001e0050,0xff9fffd2,0xff73ff62,0x0048ffba,0x014c00e7,0x00dc014c,0xff880031,
0xfee6ff10,0xff8aff15,0x0096001a,0x00cb00d6,0x00290082,0xff9effde,0xff6fff6f,0xffdeff96,
0x00680026,0x00cf00a7,0x009f00cb,0x00160057,0xff9affdb,0xff5eff7e,0xff66ff4c,0x0025ffbe,
0x008f0073,0x00390070,0xffd8ffff,0xffceffc7,0x0013ffeb,0x004f0038,0x001c0037,0x00050013,
0xfff1fffb,0x0005fffa,0x00150010,0x00070016,0xffe40001,0x033400e0,0x09150785,0xfffa034e,
0xf907fa4e,0xf916f955,0xfee1fc65,0xff2c002b,0xfc2dfe0b,0xf561f735,0xf979f4f6,0x167d06d1,
0x2d412756,0xf36013a5,0xe33ce2ef,0xf658edb5,0x048bff16,0x04f10659,0x016d02fb,0xf8b8fbfa,
0xf194f4e0,0xf37af319,0x0162f799,0x290d12cb,0x2f8439e3,0xe1830170,0xdec1dc7d,0xfce7ed33,
0x057405dc,0x06100071,0x04ac0a8e,0xf054f954,0xf2fbef47,0xf953f558,0xfcdff585,0x196f088a,
0x40402dad,0xef672ae9,0xd54ad5a3,0xf719e488,0x0437015e,0x0b4d0774,0x05c70c15,0xf438f98e,
0xef30ea81,0xf798f1eb,0xf5aff8ad,0x0ba002d0,0x37d51b01,0x1a4e5a42,0xcc69cfdd,0xf23cd6fa,
0x02d1f6fc,0x0d4d078b,0x041b0bc5,0xf49ffe6c,0xede8f0a3,0xf519f0e9,0xf7aef64b,0x0892fc13,
0x292b11c3,0x44935b68,0xc0b9da72,0xe652d22d,0xf5adf020,0x09a60919,0x086d0ae5,0xf601fc72,
0xed97f063,0xfb30f468,0xf880fc2b,0xff81fbdd,0x17280917,0x625542ff,0xbb921513,0xd1b1c7d7,
0xec16e19c,0x11b205d5,0x0cdf0b2c,0x022d00e9,0xed79f330,0xf51ff593,0xfaccfa76,0xf960f759,
0x0945ff24,0x4bcc1e6a,0xf90160c5,0xc72fb2f0,0xdf88cfd5,0x0c3ff300,0x13ef07f5,0x0306111b,
0xf162f883,0xf3adf327,0xfa79f9b5,0xf4bef954,0x031efba4,0x1daa0907,0x5f0451b0,0xab7fdba0,
0xcd51cc58,0xf658df8c,0x0e431278,0x10e316b8,0xf8620231,0xf1bdf08b,0xfc6ff63c,0xfc1dfe57,
0xf902f980,0x0781fefb,0x4a68171c,0xe98f67b3,0xcdc3a00b,0xe200cbfc,0x1362f2de,0x0e810bc5,
0x063013db,0xf61bfe88,0xfc59f74a,0x02990013,0xfa90f8aa,0xf89dfc01,0x07fefda6,0x64aa2d3b,
0x94bb3862,0xd011bfc8,0xe3fed1b5,0x15cc0030,0x1af20984,0x07c212b3,0xfc8900cb,0x002f0142,
0xf653ff91,0xf9b6f4e9,0xff5dfa97,0x1ea809a5,0x694d49dc,0x9fd7c230,0xccbdd984,0xf47edb7f,
0x0c9d16ce,0x1e43163f,0x013e0e70,0x0290fe05,0xfd650287,0xf4b6fa68,0xfb9ef775,0x08de032d,
0x345b1892,0xf988721c,0xd6448f6b,0xd4d3c8ba,0x1567eaed,0x112311fb,0x19662593,0xfd4b03c9,
0xff56043c,0xfd45fc5d,0xf86ff874,0x01c6f6de,0x16890b24,0x6b83291c,0x8e0f1e63,0xc674dc9a,
0xe46bc685,0x1a3711ff,0x292b0f06,0x06a11e7d,0x050afbb4,0xfaf501d4,0xf922fe82,0xfe10fa1c,
0x0917042b,0x1eb311c1,0x46195c6d,0xce17932a,0xc94bd7fa,0x0e07e076,0x09671be8,0x1f6c272f,
0xfb3906c3,0x04fb03ba,0x02fdff34,0xfbe5ff35,0x00a9fbdc,0x051f0294,0x402219a0,0xbcaa6c96,
0xef3dae9b,0xde79c6ee,0x1a1fff17,0x1b7d0681,0x091c281c,0x030cfb11,0x02570b5a,0x0540046b,
0xf8bdf9ae,0xfcbaf77f,0x0e5d0062,0x674c2b40,0x8e0f24d9,0xdc5ae92f,0xf4f3cf79,0x12c906cb,
0x26bf07da,0xfcf217e7,0x0b1a0005,0x03c9109e,0xfc5109ed,0xf04bf305,0xfe59ef0f,0x1d70040d,
0x6c983c78,0xa7f3d128,0xc9cc0499,0xefbbe887,0x084f0b9f,0x27291164,0x01ff0598,0x160f086d,
0x060e0e46,0xec570433,0xe877eb0f,0x01f1f840,0x2ac313a0,0x388a5cf6,0xf04a8f60,0xce65e0ce,
0xf8aff07b,0x04f41460,0x190d2652,0x05470221,0x17110d35,0x06460076,0xe3c3f35b,0xf232f027,
0x08630157,0x3f9221ee,0xbd3268c2,0xf730be19,0xee49bbb3,0x1294f0a3,0x18730943,0x08692638,
0x07050480,0x062417f6,0xfb5e01c2,0xef60e653,0x0431e93e,0x16750602,0x6aec31c0,0x96c60066,
0xbe37ff9a,0xf0f6df63,0x107f050f,0x2a350ee0,0x05da107a,0x121a01bd,0xfd460b5a,0xeaf60251,
0xf05cef18,0x0746fbb3,0x28680d93,0x3eea5adf,0xe7da9291,0xd0d4d37e,0xf86bf5e1,0x094d1280,
0x150526b8,0x03d5031f,0x12a90b72,0x0191fe70,0xeafef218,0xf43cf5cd,0x07e5041b,0x3edd1c76,
0xcd346bcb,0xf28caf34,0xf276c2b4,0x0ba7ed80,0x18e90ab7,0x01b620f9,0x07400477,0x044a14fc,
0xfc04003b,0xf827e80a,0xfc30efe0,0x11a102a5,0x5fbc2bff,0x8f493404,0xd591eab8,0xf424da86,
0x1260f2ed,0x24e908e3,0x04d30a98,0x0bbb0b6a,0xfb481397,0xeccb0043,0xf174ec69,0xfff3f0eb,
0x27920af3,0x6adf40af,0xb99cbe6d,0xbf53f738,0xe762f859,0x071f0809,0x21ef1921,0x097403ad,
0x16430789,0xf9c1004a,0xe40af86e,0xebc0f23a,0x0deffa59,0x336d1ed6,0x03a26c98,0xfaae92d7,
0xe2bcc1a2,0xf91cee5d,0x12850fbd,0x0d572a8a,0x05deffdf,0x07d61373,0xfa77f45f,0xeecee6ff,
0xf584f3eb,0x1aa70b73,0x60b82bc5,0x8f253328,0xcbf2e9d4,0xf331d023,0x10cdf1b4,0x2ef210ee,
0xfc6f166d,0x0b2a00ab,0xf3870d1f,0xf091f9ed,0xf6faecac,0x055bef06,0x2c391a5c,0x585a50a5,
0xc94ba33c,0xc2f9dd01,0xecfff32b,0x11990da9,0x1dfd2aab,0xfcebfe0d,0x0e8e033d,0xfa22fabe,
0xe641f681,0xf10ef7d8,0x141dff2f,0x3f262613,0xd8c56d6f,0xe7b9a22d,0xeb9db9ab,0x0412eb0a,
0x200e142a,0x05d027f1,0x0432fb40,0xfea30b11,0xf9c8f4d8,0xf1e1e77a,0xf876f58d,0x23391185,
0x6a263862,0x8f1c0df3,0xbe33e640,0xf04cddc7,0x1469fb16,0x289e19ce,0xf9ef0f64,0x0c56ff38,
0xf36402ec,0xee73f89a,0xf5b8ede3,0x090df299,0x364a1da0,0x409e5c6f,0xd6629237,0xc5f5c881,
0xf1adf3d5,0x1702133b,0x172229dd,0xfc2bffa7,0x08760a64,0xf57ef485,0xe91df3a0,0xedc8f779,
0x1acd0176,0x4e9a315a,0xb1eb5fc9,0xdba5b72d,0xeed2b6f7,0x0a35f1b8,0x27e51332,0x01861ebd,
0x09d7fe99,0xf82b095a,0xf47cee55,0xf1a1eac9,0xfe7bf4df,0x2e850f87,0x6a064910,0xa8ccc78b,
0xb455e0ba,0xf1cfe1d7,0x0f7b0879,0x260d26b0,0xfcf60705,0x051a0670,0xf211fe1e,0xef42f2aa,
0xfa4beff8,0x0972f505,0x42822bab,0xed086fe0,0xdee4984a,0xd848b3d5,0x0977ec71,0x21560cb3,
0x0d982cb4,0x047800f9,0xfce402c6,0xf38ef5ce,0xed70f2ec,0xfa64f899,0x2050fed3,0x6af93ab5,
0x8e0f1b1e,0xba20dc24,0xe562d22a,0x1069055a,0x2d3718e5,0x0502120c,0x048dff0f,0xfb93fc9f,
0xf27ff4e9,0xf208ef2d,0xff2afc13,0x354512db,0x3378664b,0xd8748e32,0xcd49c24a,0xff4be43e,
0x0fb01278,0x13d72bdf,0x00970c25,0x01440007,0xf912fa59,0xf3e8f32c,0xffefe6e4,0x08dbfe16,
0x5cd43075,0x942d4b3d,0xc671d12c,0xe5ccc9bc,0x158af843,0x2b7e08c8,0x098812b9,0xfc970919,
0xfd5006d0,0xee8efbf3,0xe839f676,0x036bf9af,0x2c4400ba,0x50dd594c,0xcf079882,0xc5facc52,
0xf3eded23,0x069416b8,0x163b2381,0x0d1707f1,0x0229013c,0xfe2bff72,0xf5dbf0b7,0xf128f199,
0x00be04be,0x53df1c4a,0xa13b5aee,0xd5f1ca23,0xec6bc598,0x1034f446,0x1b550a32,0x09631424,
0x094509a2,0x034f0195,0xf5580175,0xf40defc6,0xfba4eea1,0x171c0265,0x685249f2,0xbe13b0d8,
0xc62ada7f,0xf45fe6d8,0x07c60ba8,0x11ad1903,0x0add0d19,0x01e00f48,0xffa90056,0xf4e5f733,
0xee5df4f7,0x04b6f989,0x48d2158a,0xaf246867,0xd688c0a6,0xe5c8cd11,0x0b96f333,0x1ace03bb,
0x125c0d05,0x11280806,0xf91c07b0,0xf7c20630,0xf6a1f3b5,0xf7d9f590,0x150c05e2,0x6b424553,
0xc179ada4,0xd2a0d7cf,0xf01de5bb,0xff9f127f,0x044d1df1,0x095b11dc,0x140c0bb9,0x0930f31a,
0xf19ffc9e,0xf6e6f909,0x03f8f8d0,0x44b91482,0xa8fa69d2,0xdc34c6b5,0xeafdd3c3,0x16f5efab,
0x1ed2fa6d,0x0bcb0184,0x05d50aad,0xf7661868,0x04b703e1,0xf158f7a6,0xfc79f669,0x19960217,
0x5f184b9e,0xce929d95,0xdad9d26e,0xee4df4fe,0xf9471f81,0xfc3d1dea,0x0a3f0487,0x168904fb,
0xfea1fa0d,0x00620900,0xf71cf19f,0xfb8504a0,0x51371825,0x9b8d5740,0xd2f1ca6b,0xf894dd7d,
0x1eb9f53b,0x183cfe10,0xfc78fd2b,0x073a05d3,0xfecd14c6,0x09b6fde6,0xf862ff9f,0x06c5f249,
0x12e3fcdb,0x486d5bcc,0xce9a96fe,0xe281d1a6,0x0160f4fd,0x07001a6e,0xfa36141a,0xfe25f9d5,
0x1090097a,0xfc29031b,0x04a806c3,0xf5a0f9bb,0x03210700,0x612b0f55,0x91403cd9,0xcfcdced4,
0xef6bedb0,0x19c109ca,0x13dc0a25,0xf9abfa14,0x08bdf7f6,0x05250a4c,0x0056ff73,0xfe7c085b,
0x06a7f4d8,0x0e150bd9,0x2bcf684f,0xcfab8e0f,0xf729ca9a,0x1047f01a,0x0fd21607,0xf6211337,
0xefd9fcf9,0x0b0d08d5,0x039b008e,0x0544fce7,0xf9ae0082,0x0fad0758,0x6e0b174c,0x8e0f14cc,
0xc517cf0a,0xf29efa4c,0x159c1632,0x135c1549,0xfc6df4a8,0x07eceb48,0x01550970,0xfdcc045a,
0x01c70476,0x0038fe0e,0x1ff3150b,0x06766fa1,0xca528e0f,0xfc18c3ef,0x17c0f6e1,0x1a2e1787,
0xf6a90fea,0xe977fb07,0x0939038a,0x047bfd56,0x01bdfd86,0x01f90a27,0x149cff4e,0x721c2cb1,
0x8ff8e7d6,0xc700c3f6,0xf999fc14,0x15941f38,0x0b40258c,0xf908f97b,0xfe20e40a,0xff4805af,
0xfc0001a0,0x0d950641,0xff570493,0x3423117d,0xdb607057,0xc0f692eb,0xf9f9c6fa,0x21abff24,
0x2b44148b,0xf82a0685,0xe560f9fc,0x02daf9f4,0x017efd61,0x04fdfde2,0x07340ea3,0x0fa6fdfb,
0x70893342,0x924ddcac,0xc566c045,0xff6ffb03,0x1586204f,0x065c2db4,0xf876f4ad,0xf812e6e9,
0xfbdcfe8b,0xfd12034c,0x0e6f089c,0x049b0a69,0x3d580b77,0xc6536bcf,0xbbc59a8e,0xf9accd00,
0x23de028b,0x31c616af,0xf6b703c8,0xe76af5dd,0xf8bef6b7,0x0317fc27,0x041d00a3,0x0a821284,
0x0e7d0597,0x656c462d,0xa352b2ad,0xcd82b5d5,0x0664fc0f,0x16872325,0x05693393,0xf5d7f8b5,
0xf5cbe6c0,0xfc64f480,0x035a01ce,0x17cd003f,0x077d0db8,0x507b1205,0x9e4f5811,0xae9cae02,
0xfed9d4cb,0x1fc40ea4,0x33471670,0xfc21024f,0xe9dcf292,0xf2b7f565,0x0409fbc2,0xfa160542,
0x0c4f1952,0x1374049f,0x56444fe4,0xafc89a2c,0xd5d3b0f6,0x1265fd80,0x14fd1ca4,0x01f13148,
0xf0c4ff29,0xf602eb35,0xf66bf350,0x05e30478,0x16f4f7fe,0x07350ee1,0x5330191f,0x95194f1c,
0xb0ddb247,0xfb82d565,0x1a8715f0,0x311e1677,0x03f40138,0xed26ed4f,0xf590f803,0x02e0f3a4,
0xf73509a5,0x11800ffe,0x1909039c,0x4f8951c5,0xb04a96e4,0xd394b8ec,0x1799f79f,0x160614b3,
0x02752f9d,0xef17092d,0xf842eea0,0xf19df60f,0x0c9eff26,0x08eff6d1,0x07381292,0x550b1bce,
0x97744c43,0xbbc6afdb,0xf47cd5c5,0x131d1985,0x2fdc1386,0x08cb053f,0xed26f376,0xf4eaf723,
0xfd0df58a,0xf9570821,0x0f670890,0x1ea50b54,0x41635c22,0xb50591f7,0xd88ac1a2,0x1c1af0eb,
0x129013b7,0x05902e24,0xf61305f6,0xf5c2ec53,0xf6e6f38a,0x0957fbee,0x0b0afdab,0x0ed00c8a,
0x623422f8,0x8e0f31dc,0xbc1fba6b,0xf065e063,0x17171da9,0x2cf71141,0x05dc0604,0xecf3f650,
0xf315f4e6,0xfbedf786,0xfd9e0945,0x0c8a0b0a,0x22f80ed0,0x31dc6234,0xba6b8e0f,0xdfe5bc1f,
0x1d5ef074,0x11a9163f,0x05d12d68,0xf62e05e9,0xf578ec91,0xf709f369,0x0954fbed,0x0b0afdaa,
0x0ec40c89,0x00002335,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

const uint32_t sample_3_trumpet_htrumpetf3[768] = {
0x00000000,0xfff3fff9,0xfffefffd,0xfffbfffc,0xfff9fffc,0xffedfff5,0xffeaffef,0xfff6fff1,
0xffedfff2,0xfff5fff4,0xfffcfffc,0xfff8fff8,0xfff2fff5,0xfff0fff3,0xfff0fff0,0xfffefff6,
0x000f0004,0xffc6fff5,0xffbcffb0,0x0037ffed,0x000b0045,0xffccffde,0xffccffcf,0xffffffdd,
0x00c10054,0xff94005f,0xff1fff16,0x0022ffb0,0x003f004f,0xffea0002,0xffeafff9,0xffffffde,
0xfff40000,0x001c0005,0xffe8000f,0xffc4ffd1,0xffd2ffa6,0x000cffe7,0x05d80011,0x076812d4,
0xf80dfd2f,0xf807fab0,0xfb81f551,0xfeacf86f,0xe9b8f6f2,0xff64ee9c,0x20c613eb,0x216e2a50,
0xfdf80738,0xe3d5f662,0xee56e7b5,0xfee5fa52,0x03830160,0xf991fe23,0xe96af050,0xf297e41e,
0x25410ccb,0x54643d9a,0xea7f2d4f,0xc622e05f,0xf295da65,0x0176f484,0x03f2fc39,0xfeaa026b,
0xe162f1d4,0xeed7e49a,0x23c40b13,0x55ba4383,0xf6ca417a,0xbc08d99c,0xf385cf70,0xf673ef00,
0x0445f795,0x0084042d,0xe3e3f69a,0xefeee67f,0x1bca03e0,0x513d35e7,0x19c05318,0xbaadcc8b,
0xeeeecbcf,0xe5c3e47c,0x003ffa68,0x04400e06,0xebfdf569,0xef54e11f,0x19e704e2,0x4e54333f,
0x22f95757,0xb170b696,0xef9cd217,0xe221e0c6,0x04e2fc24,0x040f0b4b,0xe495f2c6,0xf219e537,
0x226c0cd4,0x569b44a2,0xb25045e5,0xc761a65a,0xf8f1fd1c,0xfbd1de40,0x047bf2e8,0xf4ee0151,
0xe416ebc9,0x02b5f490,0x43382007,0x43395969,0xb2499d34,0x022abd3d,0xe8520764,0xef4a0211,
0x013e03d9,0xee70fa17,0xed38e769,0x1ae6fd96,0x58f83554,0xa1084f2f,0xba4eb3f2,0x061bfcd3,
0x07dde71a,0x0d2af08d,0x0a6a0806,0xe417f5c2,0xedfaed1b,0x24f81205,0x6fac43e1,0x9917e3a6,
0xe492c170,0xd0b21349,0xfe8b013c,0x17320ac0,0x0e201594,0xee71dee7,0xf705e47d,0x37c11593,
0x5c015a55,0xa732b910,0x12f4cbc8,0xcff9e4e6,0x0d290eaf,0x103718ae,0x0bd8212f,0xde9ce320,
0x008ee58b,0x47bf16af,0x5f335524,0xa281c00a,0x0ba2d91a,0xd9ecdcc8,0x15931ef3,0x0b950573,
0x0e252a15,0xd7bcde77,0xf99ff0f5,0x43f32199,0x664e4c40,0xa789b4d9,0x14f5dace,0xeb63ee3a,
0x004321dd,0x0df5f915,0xfef92d61,0xdf57d586,0x057ee819,0x42092bd5,0x52625924,0xb16ba2da,
0x1d91e1fe,0xfcb6f4a6,0xf13b16fb,0x1332feec,0xee0128b2,0xdd0bce9d,0x0b13e92b,0x492a3449,
0x1b7a6853,0xc5129190,0x10d5fe61,0x1c02ed3f,0xf1f30428,0x14b105c4,0xd7e21218,0xda37d58a,
0x13bff662,0x5ce54786,0xb862588b,0xdd56a754,0xf04318bb,0x241c07bf,0xfdd4f080,0x17dc0556,
0xdb7cf62a,0xd5bee326,0x1e2c021e,0x69a55014,0x969920cb,0xf533c3d8,0xf1110670,0x10931fc9,
0x0508edec,0x131c1243,0xd554ee38,0xe582d7ec,0x37ce0d58,0x6ba4535d,0x9a20dde9,0xff43dcf4,
0xf727f4ea,0xfe662519,0x0cdbf5a3,0x045618ea,0xdddedebe,0xf560e37c,0x483e170c,0x5e6b5893,
0xa8bab75f,0xf88aeaf4,0x023aeb69,0xf3301f15,0x13b5fb98,0xfb9a2116,0xdf72e186,0xfb12e45f,
0x4e822336,0x5429593d,0xb702a3af,0xf22cf0b8,0x04f1e899,0xedbb1752,0x1cb201ea,0xf385129c,
0xdf42ef61,0x005df42a,0x4eee352b,0x35ba6160,0xcb408e64,0xf2edf2f2,0x14d1ecdc,0xe76a0d19,
0x23010697,0xf93d07cc,0xdc96ebe9,0x0453f4e5,0x4a11468c,0x06d06bf9,0xdc748df8,0xf1e1f5c5,
0x1cfbf7bd,0xe845fc60,0x22190d32,0xf5f211d2,0xda89d8fc,0x148efc30,0x54784df5,0xc9d2655d,
0xe8f59d1d,0xedccfa6a,0x2010099d,0xf3f8ee64,0x20b3169c,0xebd6ff7f,0xe313d2fd,0x21e90136,
0x5d085853,0x98754067,0xf474bd00,0xf280f9c7,0x132121a2,0x0689e605,0x103f1bb4,0xe290f042,
0xe892d9ef,0x391f08b6,0x677258d9,0x945feaca,0xf76edb03,0x0aa8ef12,0xf6d42d4c,0x1352f0ff,
0xfd9e18d4,0xdf72e84b,0xf632dd35,0x480b1f03,0x4d065f24,0xb5d1a232,0xf309e5d0,0x2396f560,
0xe5bb1b62,0x18da07cd,0xefab047d,0xdfc0e6e8,0x0a53ea1d,0x4c0333af,0xf8246e5d,0xd6b4919a,
0xf228e04e,0x28890aa0,0xef34f925,0x14e31e40,0xf19df6f4,0xe2c0dfd1,0x0f20f906,0x599d45cf,
0xb51c5c5f,0xe1f0a956,0xf87fe7b1,0x19331577,0x06a1e313,0x09502504,0xec8bf1a1,0xea7ee11b,
0x238d0154,0x66724f38,0x8f8d24f4,0xe775cbd2,0xfe23effa,0xfff3223e,0x197ce6e6,0xff061bca,
0xe962e85d,0x010be08d,0x351f075f,0x631559b7,0x94fdddcc,0xeb23e329,0x0b06f3be,0xec821fcd,
0x1f59f66d,0xf6740dcc,0xe1d0ecc7,0x014aebe2,0x47d513ab,0x4a9d5dde,0xb7f19f80,0xf2e1ea35,
0x1707f5d2,0xe5b2132c,0x1d500c5c,0xe746fb23,0xe25cec69,0x06f0f484,0x55a833b9,0xf4e066f3,
0xddf88e61,0xe9b8f110,0x2324079e,0xf7f0f651,0x157915f2,0xe46ae867,0xed8de133,0x14be03fb,
0x5e674a26,0x9d69464a,0xeadcb78b,0xf2abe394,0x104d2233,0x1111eb1a,0xfad11e04,0xea18dab2,
0xf6b9e841,0x32530864,0x66dd5451,0x989fdbdd,0xddfbdd93,0x0dfbe243,0xeeb32a1c,0x285ff9f6,
0xe42a0d19,0xef83e536,0xfd8deccd,0x46db1547,0x2c7066d1,0xc951921b,0xde16dc6d,0x2275f3e1,
0xdfe511fe,0x241e1a56,0xe608f91a,0xf04ce24d,0x085bfb42,0x52563126,0xba8364e0,0xda74a8c8,
0xf271d8f3,0x2672048f,0xff59e53f,0x0e1e23c1,0xde51f2c4,0xfe1aeed7,0x2008fe81,0x6d2d4224,
0x8df80652,0xc99ad8c0,0x03d3eee1,0x030419b2,0x2544e3e2,0xfee01206,0xe853e412,0xfae5fd56,
0x3a3f123b,0x4b045ed2,0xbf2a9a42,0xd196d08c,0x10740985,0xe4b914df,0x22990fd8,0xf23f01d7,
0xf6e7db3a,0x04e60596,0x4eca2365,0xd4666bc6,0xda9b9d8f,0xf3a8c0ae,0x175c13b2,0xf75df6f9,
0x12ef298b,0xe110f638,0xfc24e7cb,0x13a90567,0x6d793a68,0x8f351fa9,0xc719d2e4,0x0d1dd0e8,
0x08531e92,0x1dddebf7,0x06cf1be7,0xd7e0ea58,0x0320f634,0x2cd50ff7,0x57e95a68,0xb920a559,
0xc3b7d6a1,0x242fee61,0xe9bc1c2d,0x1de00d16,0x011e07fd,0xf2c4d87c,0x05be0523,0x41ea1d24,
0xda2d7205,0xdf779cfc,0xd719ccbc,0x335e0e0a,0xf9dff084,0x0b1b1f2b,0xe82a0146,0x0588e811,
0x148a08b6,0x72052a98,0x8eb9100e,0xce5adc41,0xf3a0d489,0x144031cb,0x2009e407,0xf3e51309,
0xf3c5e834,0x104ff9f6,0x1f3b16b1,0x3d856420,0xcdab9301,0xcc35d441,0x15f4e85e,0xf1ef30e6,
0x2489099f,0xe82ff606,0xfd10e66a,0x1bfd0d32,0x4efb1e5f,0xa4395ec4,0xda90ba5f,0xdc15c902,
0x273309e5,0x048716ae,0x07cd1cbe,0xd8e5eb5d,0x0a14f5d3,0x25d1142f,0x72053bd7,0xa364c9c5,
0xc8c3dd6d,0xf8fbd7e3,0x1457216e,0x15ca1ef0,0xf0f11771,0xdfb7d31f,0x14cf035e,0x384229d4,
0xf83e7080,0xdc91924e,0xd9cdc856,0x185ded42,0x1caf0f28,0x0ca92da3,0xd5440465,0xed49d5af,
0x27180dcb,0x683e360f,0x8df82765,0xcc8ed1bf,0xedaed390,0x0d8d0e8e,0x3f1b0851,0xff0b12ca,
0xd2b9e2e1,0x0279e73c,0x3545290c,0x45bb60ae,0xbff897da,0xd16fd587,0x12afe436,0xf4ef1063,
0x2a913916,0xeccafcb0,0xddface85,0x2812f8c0,0x53f8348e,0xa9665d91,0xd48fb24b,0xe281d339,
0x19e61090,0x18b3edda,0x08be438b,0xd6f5ec6b,0xef92d00c,0x3a7118f2,0x6a5749ca,0xa359c38d,
0xcdb8d1e3,0x0e63e14d,0xf2fd1f53,0x3a5603b1,0xe8f22798,0xcd41e41f,0x0bc4e33e,0x4a0535b9,
0xdf176a4c,0xd2579640,0xdad8c814,0x2c67091c,0x021ef2fc,0x371f25f0,0xd53d0367,0xd04ce48e,
0x2556fbac,0x7055464e,0x958af397,0xc00aca06,0xfc71d5c5,0xfe743530,0x222afcde,0x22082f91,
0xd720d80f,0xee98d9f5,0x39bd1f33,0x018b7205,0xcd52919a,0xd2f0b847,0x3bc7ef29,0xfb7d07f0,
0x23711dad,0xeef42ddf,0xdfd1d6c8,0x1326e56d,0x6ef72edf,0x8df81df3,0xb664d1aa,0xe158d1b7,
0x16d634a3,0x2021f4fc,0x2a8817b8,0xd9ff0ffc,0xe3a4de85,0x27000e3e,0x343a6781,0xced58e7a,
0xc9fec44e,0x2133dd8a,0xf1df2600,0x1b4220c6,0x19fc14c8,0xdc71f028,0x0604eb4d,0x5cdc2816,
0x93f2469b,0xcdcec421,0xd890cae2,0x29d11524,0x1e64f6d1,0x0e852481,0x017f08eb,0xe627e209,
0x238006b5,0x52045b0c,0xba54a105,0xcd18d092,0x0939d630,0xfa362abc,0x269b1b12,0x01811282,
0xf62f003c,0x02aee120,0x56cd1d9a,0xa6265c3e,0xcf5eb614,0xd331d2a0,0x29b5025a,0x171df90b,
0x1f772705,0xf87afbef,0xe294063e,0x187b0131,0x66244c4f,0xb694a78d,0xd385c97b,0xfb9ad8c5,
0xf7ab2e11,0x297c10b9,0xfd7e1db2,0x0b44f262,0x0041f153,0x421a18c1,0xafb46e25,0xc83ab019,
0xe04dc8a4,0x312df70e,0x09dcfa83,0x19f829f6,0xe4920de9,0xfa97049d,0x24120169,0x70833c47,
0xae84b1f8,0xc067c5ed,0xf518e77a,0xfb9236dd,0x2a020215,0x06f91ce2,0xfbeee552,0x021607cb,
0x3ef8236a,0xb94a6dc0,0xcb1aa875,0xe1fdb32e,0x2fa9f8de,0xfb0c0ac0,0x1e952afd,0xeb6309cc,
0x059cf0d6,0x1fba085a,0x6e044241,0xa02ccc3d,0xb6d5cf0d,0xfa20d29c,0x10fd2cbd,0x1c230058,
0x08dc293d,0xee9ee7ec,0x1000ff61,0x3ed22167,0xd20d7205,0xcc519d66,0xcd38bb76,0x2e61f117,
0x06181133,0x1f3e1d4f,0xe7731148,0xfd3ce710,0x258a101e,0x72053be6,0x9acad948,0xb8d7c824,
0xe284ced8,0x16143173,0x1f5b058f,0x0d4725e1,0xeab1e5e7,0x12a5ef8a,0x35bd2d33,0xe63e7205,
0xc97497f1,0xd0f0b32f,0x29bfd8d6,0x082b1b55,0x23fb21ea,0xe5ce1211,0xf0b5e7bb,0x3158092f,
0x72053b7b,0x9357ece8,0xb0d6cace,0xd9d9cc3c,0x1d17210a,0x1e860d05,0x187f26f9,0xe589e660,
0x0395ec23,0x3a5833cc,0xe8e17205,0xcbad949a,0xcf75b2dd,0x20ecd09e,0x151b124a,0x29101fc0,
0xebd312c1,0xefabe746,0x2fb2ffba,0x720536d0,0x9263f13f,0xaed1ce28,0xca67d56b,0x0fe61a32,
0x28500fa0,0x1f042d21,0xdd28edb1,0x00a2ee56,0x390d2ebd,0xf7e670bd,0xd0d08eba,0xd9e1ad2b,
0x0db4cf64,0x092710b9,0x36612815,0xf2511ffc,0xe7b3e700,0x2abcfd2d,0x6f153814,0x8ea70c73,
0xaef8ceb3,0xd7c0d691,0x1124033f,0x210007a7,0x26513860,0xe43bf389,0xfc60e798,0x38622b42,
0x07c76f61,0xcf5f8eab,0xd7ecae50,0x087ad3f3,0x088710e9,0x370b256d,0xf29f21d4,0xe7ade66c,
0x2ac1fd0c,0x6f153815,0x8e7b0c9e,0x0000ceb1,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_4_trumpet_htrumpetax3[896] = {
0x00000000,0x002c002e,0x0029002c,0x00290029,0x00280029,0x00290029,0x00290028,0x0029002a,
0x00290029,0x00260028,0x00260028,0x00280028,0x00250027,0x00260020,0x0020001f,0x001f0020,
0x00220025,0x002f002e,0x002f002c,0x002b002e,0x001d0027,0x00040010,0x0026000f,0x0045003b,
0x00310041,0x002e0028,0x00190021,0x0023001c,0x00230025,0x002a002a,0x0031002e,0x00200031,
0x00290026,0x0000000f,0x00150006,0x00390025,0x0466019f,0x02e50450,0xfdbd00a5,0xf8c3f994,
0xf62bf574,0x01bafb4a,0x15500c2b,0x10201b37,0xee64f978,0xf1d9ef0c,0xf2fdf431,0xfb60f4b8,
0x0eb80562,0x37da1dba,0xf0be1018,0xe977e50b,0xec47f06c,0xf3a9f1dd,0x02d2fdef,0x13910f46,
0x238245b1,0xebcee9de,0xed56df64,0xf2e8e821,0xfa07f5fb,0x085a02eb,0x29800f22,0xf2e3513c,
0xe25de95a,0xee7de391,0xfc49e872,0x0258f435,0x0ef603aa,0x4e11112b,0xe0862179,0xde02ec84,
0xe8a1efe8,0xf870f5e9,0x02d8f7ff,0x0f2f0657,0x550f23e4,0xe6a9f7fc,0xe455e5f4,0xe7acf03a,
0xf365f9dd,0x029a011a,0x0c0e0f24,0x3d4e4487,0xed18dfcb,0xeaaddd2e,0xeddee9e6,0xf5aafa9d,
0x03fc05b4,0x148c106d,0x12136828,0xe852dad2,0xed75d4c7,0xf714e0b6,0xfe50f77a,0x0d050816,
0x349b0e47,0xe81162dd,0xd78ee4df,0xe8b5d830,0xfffae205,0x0a05f7bc,0x12fb070b,0x56800c33,
0xd2424403,0xc9b2e645,0xe45ae250,0x0367ee84,0x0d60fb14,0x136b062a,0x6c690ff7,0xcd131d1b,
0xc84ae0b6,0xe27aec11,0xfdd2faa6,0x0c1bfedf,0x12d806da,0x7237168f,0xcbb8fe23,0xcbb6ddac,
0xe451f2cc,0xf97b001c,0x08ca00b4,0x10b105b8,0x72371883,0xcb86f0b8,0xcfc6dcf0,0xe5f7f7c5,
0xf6d20174,0x07e30081,0x110d03e0,0x72371341,0xc7ecf6b4,0xd34adedf,0xe7dbfca9,0xf7fa015f,
0x076afdb3,0x149cfe1f,0x6c8302f7,0xbf751ccf,0xd4b2e373,0xead9011d,0xfcc3fa3f,0x07a5f6c5,
0x145ef9cd,0x54c4fe1f,0xc09842e5,0xd6c3e3d3,0xf08a0127,0x0186f0fc,0x06e5f179,0x0f0ef8d0,
0x357d016d,0xcf1065aa,0xda3be02f,0xf739fba6,0x05e1e699,0x0334ef16,0x0beaf78b,0x21210806,
0xdf367103,0xdeb1dd80,0xf965f65b,0x05d3e39e,0x0037ec1c,0x08aefa9e,0x19c10c2f,0xe8847098,
0xe1c5dc5f,0xf827f2ff,0x02fae395,0xfeb5ecde,0x07a6fd18,0x18d40e10,0xe8f07237,0xe2ecd998,
0xf7a5eff4,0x021fe491,0xff81eb35,0x0b5afe60,0x1c110dd3,0xe2ff717c,0xe1a2d911,0xf727eef1,
0x0197e6fb,0x0172ec17,0x0a5fff4a,0x1ed10c0c,0xde6770da,0xe0f6d8db,0xf8ddedee,0x0141e740,
0x0365ecc7,0x0912ffa8,0x18440c6f,0xe45e7237,0xdfe3d45c,0xfe16eaad,0x0170e3fb,0x0145edb7,
0x05820421,0x0a2710d6,0xf8e47237,0xe319cd53,0x009ae33f,0xfeb2e04a,0x008ff400,0xff110949,
0xfdfb132d,0x1be06c49,0xe5dac686,0x0167dd0b,0xf89ae09b,0xfc8ef9fe,0xfd3e0b46,0xfb201384,
0x466f504f,0xe433c772,0xfa9edb6c,0xefd6e47c,0xf9ae02c9,0xfc480cc0,0x00060e98,0x67853091,
0xdf65d439,0xef43dbfd,0xe8d0ec71,0xf6d20872,0xfe770a45,0x07ec0941,0x72371a30,0xd702e810,
0xe6bedf2a,0xe490f159,0xf8940838,0x029e0843,0x0c3104c8,0x72370bfa,0xce53f934,0xe09ee47e,
0xe3d7f3ee,0xf9ed0786,0x05fe02e0,0x114f033e,0x7237048d,0xcab20108,0xdd74e683,0xe3f0f697,
0xfb98058f,0x08d4028f,0x10d800dd,0x70a90319,0xc8c70399,0xdc68e5eb,0xe622f91b,0xfc940556,
0x082fff75,0x11870135,0x723704a6,0xc7c300ec,0xdc56e483,0xe70cfb27,0xfafc0553,0x0937feae,
0x12650115,0x6fa204c2,0xc52d0405,0xdbfae404,0xe8c5fe07,0xfb8402df,0x089afd4c,0x146b01a1,
0x6edf01e4,0xc2d60caa,0xdbc9e3fe,0xe84b015f,0xfb43009d,0x0a63fa8e,0x15fbffbe,0x6327faac,
0xbf1d275a,0xdab7e660,0xe9b801e4,0xfd9bf9ca,0x0c83f682,0x1439fd19,0x52ecf815,0xc0804300,
0xda19e84b,0xeb40fe9a,0x01f2f32a,0x0cfbf3b3,0x0f4bfc72,0x3635f9e6,0xce6d6397,0xdc09e3bd,
0xf0fbf7bf,0x043fe979,0x0a1cf2ee,0x07c3fc1a,0x1fc801d7,0xe5097237,0xe110db94,0xf31feedb,
0x049de27a,0x04b5f3b7,0x00fd00ea,0x107c0b27,0xfa197237,0xe5c2d48a,0xf50ee698,0x0317df5d,
0x00b5f508,0xfedd03cd,0x06a710eb,0x0a0d7237,0xe748cdf1,0xf578df98,0x01f9e01e,0xfe33f788,
0xfef00650,0x022213b6,0x15df7237,0xe6c8c864,0xf76bdc1f,0xfff0e271,0xfdb1fa20,0xfedc0955,
0x01a012e3,0x18836ed0,0xe545c520,0xfb0bdba3,0x001ee587,0xfc39fbd7,0xfdc90aba,0xfea6132a,
0x244767f5,0xe63cc0a6,0xfc51da95,0xfdf0e891,0xf9c1fedd,0xfca50ae5,0xfc8a1556,0x2be861a3,
0xe69fbe66,0xffdbd990,0xfbfaea2f,0xf7c2fff2,0xfabc0d43,0xf9ab1667,0x3a0f58e5,0xe5dbbbfc,
0x0128d8be,0xf8baed51,0xf73e024e,0xf7ed0e7a,0xf83614ff,0x5001480f,0xe438bddb,0x00c8d948,
0xf34eef32,0xf35e0600,0xf7cb0fe6,0xf9ca1086,0x653d32f8,0xe1aec698,0xfbd8dc67,0xecd1f367,
0xf1e807eb,0xf9a90e98,0xff0e0a51,0x72372012,0xdc7dd417,0xf7b5dfe1,0xe63ef880,0xf25608b9,
0xfbe90a02,0x0749024c,0x72370c7c,0xd4a6ede6,0xee67e712,0xe06dfc48,0xf4270565,0x007901f2,
0x0e53fd8b,0x72370335,0xcd300687,0xe88bea65,0xddfffd35,0xf5ed00d7,0x0369fc93,0x133cfb0e,
0x72370114,0xc9691637,0xe25cea75,0xde0dfd80,0xf70afc56,0x085dfaea,0x1530fa87,0x6d8000dd,
0xc49b1fc7,0xdff8eb4d,0xdff3fd35,0xf97bf94c,0x0934f7b3,0x15e2fae3,0x68df01f0,0xc4082628,
0xde3ee961,0xe190fdaf,0xf7bff5df,0x0b2cf892,0x17e9fb51,0x663d01b4,0xc2932ba2,0xdb4ae892,
0xe195fdb4,0xf9c1f3ff,0x0d93f6f5,0x19d2fc48,0x609c0161,0xbff634dd,0xda89e698,0xe291fd35,
0xfb18f25e,0x1046f7f3,0x19fdfb02,0x57eafe9d,0xbfa1409e,0xd8d8e5ed,0xe3e4fdd6,0xfe50ef9f,
0x1203f60d,0x18c3faca,0x4b89ff66,0xc0334f48,0xd730e3e0,0xe7b3fbc3,0x0357ec54,0x117bf422,
0x146efd28,0x3c0a00f8,0xc56b5fad,0xd8c6e1a1,0xed9af714,0x0643e77d,0x0fedf2b1,0x0fb5fef4,
0x32000429,0xcb8066a0,0xdac1e03c,0xf14af425,0x0822e4f1,0x0d4cf251,0x090c0082,0x254807d9,
0xd78b6ff4,0xddafdb3e,0xf649ee9f,0x084de1b2,0x08e0f27d,0x05140347,0x1f7e0a48,0xdf4c7237,
0xe094d8e9,0xf954eaf2,0x0593e15e,0x0686f33d,0x033503cd,0x19520ad5,0xea5f7237,0xe246d555,
0xfaf3e85e,0x03bfe17c,0x015df3bf,0x014804f6,0x16ef0c7c,0xf3fa7237,0xe20bd2ea,0xfac9e357,
0x01bbe31d,0x0102f287,0x023b066c,0x13c50e94,0xf5407237,0xe173d167,0xfe27e0d7,0x0094e403,
0xff10f3bc,0x0273060c,0x14910f56,0xf6627237,0xdfd8d1b7,0xfe4ddfb1,0x0102e368,0xff43f45c,
0x01a8079a,0x11b711c7,0xfa2b7237,0xdfdfce75,0x003fddec,0xff97e4ea,0xfe53f556,0x00cf0924,
0x0cdc135e,0x02ff7237,0xe11dcab7,0x0146dc35,0xfe7de4ea,0xfc8df6e3,0x01110aa6,0x0ab8134f,
0x09887237,0xe318c817,0x0214d8d5,0xfd77e64c,0xfab5f8a2,0x003c0d7b,0x07d812b9,0x12006d9f,
0xe403c65c,0x00a3d7f2,0xfcd7e83b,0xf976fa2e,0x00df0d72,0x060810f9,0x14bf6eb9,0xe565c6e3,
0xffdfd728,0xfbe9e9d1,0xf834fd66,0x01aa0c4e,0x01d60eef,0x1de469e7,0xe610c644,0xfe9fd718,
0xfaedebe7,0xf85ffd35,0x00260c0b,0xffac0e79,0x21856940,0xe6a0c87e,0xfdb2d863,0xfaaeec69,
0xf9e4fc9f,0xff950913,0xfbd70e78,0x2d84642a,0xe894c85b,0xfb5ed7f0,0xf93aeeb1,0xf695fbfb,
0xfee80994,0xfc820eea,0x2be3643c,0xea18c94c,0xfad2d67f,0xfa99ee00,0xf75cfb82,0xfd8208ec,
0xfbe10e93,0x2f7562d7,0xeb11c96b,0xf965d593,0xf99feeca,0xf6affba4,0xfd9b088b,0xfc790e9d,
0x3031633d,0xebb4c84e,0xfa3fd5d5,0xf93eef75,0xf5dbfaea,0xfbc907da,0xfd210fba,0x310860f8,
0xec1ac78b,0xf984d631,0xf95eefba,0xf41afb27,0xfc830806,0xfd330fa8,0x32126239,0xed23c738,
0xf887d5b5,0xf8d1ee05,0xf524fc77,0xfd720743,0xfad01079,0x356f5ede,0xecf0c785,0xf797d66a,
0xf801ee1e,0xf4a5fd0f,0xfd2408d7,0xf96b1199,0x34735f4a,0xedeac756,0xf6c0d5b3,0xf949ecea,
0xf421fdeb,0xfcb309de,0xf85b1357,0x3ac05ae2,0xef30c5bb,0xf646d4bc,0xf9c7ecdb,0xf43fff76,
0xfb97095c,0xf77e1385,0x35245dff,0xf14fc750,0xf6f8d431,0xfacceaf0,0xf405fe06,0xfbbb0bd4,
0xf8131499,0x31445fc6,0xf1e0c617,0xf7fad4a1,0xfc5eea7d,0xf4c7feb3,0xf9a80be7,0xf75813e9,
0x35045f28,0xf19bc6ca,0xf792d4fc,0xfabce985,0xf2e70048,0xf9890cde,0xf95f1360,0x33f1608e,
0xf236c4e7,0xf685d674,0xfbcee938,0xf39a010e,0xf9da0c95,0xf9f511be,0x2c0f6318,0xf1adc658,
0xf827d6a3,0xfd78e9be,0xf342fff2,0xf9bd0aa6,0xf8fe11bf,0x32dc61af,0xf20ec538,0xf69bd685,
0xfb3ee92e,0xf34500bd,0xfa880a8f,0xfc781150,0x28896732,0xf06fc694,0xf797d6f1,0xfdf2e87b,
0xf37ffe65,0xfb0809f9,0xfc681337,0x29df6792,0xf14dc492,0xf795d62b,0xfc82e817,0xf488ff1c,
0xfc360a42,0xfe94143f,0x20b569cb,0xf06ec68f,0xf7f5d812,0xfe1de68a,0xf44dfe9c,0xfd1e0a79,
0xfff51412,0x1e886a2b,0xefc3c633,0xf6e3d79b,0xfe6ce5d6,0xf5f4007a,0xff0c0b55,0x0105144b,
0x15126d4e,0xefc6c7ab,0xf8e3d8dc,0xfffee52a,0xf776fee3,0xfff509ed,0x01271464,0x13346cc1,
0xefd7c8d7,0xf7abd947,0x000fe450,0xf6f9ff7a,0x02320ac8,0x04731204,0x0a5c6f1f,0xee7ccb89,
0xf7c5da6d,0x00cee467,0xf953fd38,0x033f0b17,0x06521128,0x03e26fe3,0xec9ccc63,0xf8c2db3a,
0x0148e407,0xfb9afcb9,0x04c408bb,0x07db10b1,0xfbd17237,0xead9ce95,0xf902dcf1,0x02d9e37e,
0xfebbfafc,0x05a70872,0x0d020e69,0xf2477237,0xe802d208,0xf871dfd1,0x0463e398,0xfffefab8,
0x05d7067f,0x0f3f0e3b,0xee887230,0xe7a5d2c4,0xf8c3e076,0x046ae403,0x0078fa4b,0x057506d1,
0x14360d49,0xe7bd7237,0xe667d5cb,0xf849e201,0x04bee3ce,0x0203f91c,0x077105e0,0x1b550c73,
0xdf4a6fe2,0xe4d4d90a,0xf723e3b1,0x051ae473,0x0221f9b6,0x093f05ea,0x1f830af8,0xdac46f35,
0xe4bfda50,0xf614e483,0x05a3e43c,0x02dff9ac,0x0b2e05a3,0x293a09ff,0xcfa96b3a,0xe1f4dfd8,
0xf4a4e874,0x0618e550,0x0669f8bb,0x0d0c0321,0x30610776,0xcb12664d,0xdef9e120,0xf353eb52,
0x05b0e616,0x0a0ef879,0x0f5901f1,0x337b0673,0xc6e66148,0xdd9ae421,0xf19aeea8,0x0670e7fe,
0x09faf880,0x10df003e,0x3b110468,0xc4115c26,0xda8be4c8,0xf01af227,0x04d0ea0b,0x0b21f87d,
0x1238ffac,0x3ebc036e,0xc2c45ae2,0xd9bde50f,0xef1ef221,0x0572ea2a,0x0a42f8a8,0x141c0071,
0x4bdd014d,0xbd834dd5,0xd77ce90e,0xec02f548,0x04b7eca5,0x0d14f97a,0x14ccff8c,0x5329002e,
0xbcbc4117,0xd6deea3c,0xe988f82e,0x02baf006,0x0df5fac0,0x15ddfe26,0x5b0cfff4,0xbb2336a9,
0xd567eb92,0xe80bf969,0x01b2f267,0x0e8bfbf2,0x1614fdf5,0x5e46ff82,0xbbaa333c,0xd567eb83,
0xe80bf969,0x01b2f267,0x0e8bfbf2,0x1614fdf5,0x5e46ff82,0xbbaa333c,0xd567eb83,0xe80bf969,
0x01b2f267,0x0e8bfbf2,0x1614fdf5,0x5e46ff82,0xbbaa333c,0xd567eb83,0xe80bf969,0x01b2f267,
0x0e8bfbf2,0x1614fdf5,0x5e46ff82,0xbbaa333c,0xd515eb83,0xe769fa52,0x0000f368,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,

};
