#include "tuba_samples.h"
const AudioSynthWavetable::sample_data tuba_samples[2] = {
	{
		(int16_t*)sample_0_tuba_tubaax1, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(38) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(65) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1963 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1960 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1960 - 1) << (32 - 11)) - (((uint32_t)1831 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(493.12 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-5.5)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_tuba_tromg4, // sample
		true, // LOOP
		11, // LENGTH_BITS
		(1 << (32 - 11)) * WAVETABLE_CENTS_SHIFT(16) * 44100.0 / WAVETABLE_NOTE_TO_FREQUENCY(90) / AUDIO_SAMPLE_RATE_EXACT + 0.5, // PER_HERTZ_PHASE_INCREMENT
		((uint32_t)1568 - 1) << (32 - 11), // MAX_PHASE
		((uint32_t)1564 - 1) << (32 - 11), // LOOP_PHASE_END
		(((uint32_t)1564 - 1) << (32 - 11)) - (((uint32_t)1504 - 1) << (32 - 11)), // LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-0.0)), // INITIAL_ATTENUATION_SCALAR
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DELAY_COUNT
		uint32_t(6.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // ATTACK_COUNT
		uint32_t(20.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // HOLD_COUNT
		uint32_t(11993.38 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // DECAY_COUNT
		uint32_t(493.12 * AudioSynthWavetable::SAMPLES_PER_MSEC / AudioSynthWavetable::ENVELOPE_PERIOD + 0.5), // RELEASE_COUNT
		int32_t((1.0 - WAVETABLE_DECIBEL_SHIFT(-5.5)) * AudioSynthWavetable::UNITY_GAIN), // SUSTAIN_MULT
		uint32_t(0.00 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // VIBRATO_DELAY
		uint32_t(0.1 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(0) - 1.0) * 4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0)) * 4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(260.01 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(9) - 1.0) * 4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(-9)) * 4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(0) - 1.0)) * 4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0))) * 4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

const uint32_t sample_0_tuba_tubaax1[1024] = {
0x00000000,0x003c0084,0xff770005,0xfe98ff1e,0xfdcbfe1b,0xfd61fd7e,0xfd88fd69,0xfe52fde3,
0xff83fedf,0x00cf0028,0x01d80165,0x027c0246,0x02800292,0x01ea023f,0x0102017f,0x002d0093,
0xffafffe0,0xffbeff9d,0x00640006,0x016900e7,0x026901de,0x034702e1,0x03d9039f,0x04150404,
0x040e0414,0x03d203ef,0x038e03bb,0x0343036e,0x02e4030e,0x026d02ac,0x01f10236,0x018901ba,
0x0150015f,0x014f014a,0x017c0164,0x01c9019b,0x021101eb,0x022a0226,0x02210230,0x01ef020a,
0x019301c1,0x0145016f,0x00e50111,0x008900b5,0x002c0059,0xffea0008,0xffb7ffc9,0xffacffb0,
0xffacffac,0xffccffbc,0xfff4ffdb,0x0003fffd,0xfff40006,0xffccffec,0xff94ffa8,0xff6cff7a,
0xff71ff70,0xff89ff7b,0xffb5ff98,0xffdeffca,0xfff1fff0,0xfff4fff4,0xffe0ffef,0xffb6ffcf,
0xff89ffa5,0xff6cff72,0xff4cff58,0xff45ff4a,0xff54ff4a,0xff99ff6d,0x001affd2,0x00ad0067,
0x011600ea,0x0140012e,0x01500147,0x015c015e,0x015b015c,0x01430150,0x0141013c,0x0176015c,
0x01b50195,0x01eb01ce,0x02240209,0x024c023c,0x02630257,0x02820272,0x02b902a0,0x02f002d3,
0x031b0308,0x03510332,0x03730365,0x03740376,0x03540362,0x03350348,0x03250334,0x02f70310,
0x02b402d1,0x028d029d,0x028c028c,0x0288028b,0x027a0280,0x0275027a,0x02900281,0x02b102a0,
0x02b302b4,0x029502b1,0x023c0270,0x017201e0,0x005800ef,0xff2effc9,0xfe02fe96,0xfcd5fd62,
0xfba7fc45,0xfa2afaf9,0xf835f936,0xf5fef71d,0xf3d6f4e7,0xf209f2d6,0xf122f17a,0xf11cf108,
0xf1b2f151,0xf2abf227,0xf3fcf345,0xf5bef4c3,0xf7e7f6ce,0xfa39f913,0xfc69fb5a,0xfe18fd53,
0xff1cfeaa,0xffb0ff75,0x0008ffdd,0x0059002a,0x00f4009c,0x01c3015f,0x029b0231,0x034c02fa,
0x03cc0396,0x041603fb,0x04550433,0x048e0472,0x04da04b3,0x05330508,0x05750555,0x05890586,
0x05810590,0x054a056b,0x04fc0523,0x04c204da,0x04b104b1,0x04cb04bd,0x04ea04da,0x050204f4,
0x0519050f,0x053c052f,0x051b0533,0x04ac04e8,0x0429046a,0x03e70404,0x03e903de,0x045c0410,
0x055c04c6,0x06fd0620,0x08cd07eb,0x0a230990,0x0adc0a8f,0x0aba0aef,0x09980a47,0x085b08e9,
0x07e40800,0x079307c5,0x06e60755,0x05c00652,0x047f0529,0x033403e9,0x01560249,0xfe850014,
0xfa69fcb7,0xf47af7a9,0xecaaf0c6,0xe2c7e7ff,0xd6e7dd10,0xcb7dd0d8,0xc521c764,0xc5fac4a0,
0xce23c949,0xdc73d4ab,0xed43e4c5,0xfc16f52f,0x062801be,0x0b6c0951,0x0d0a0ca0,0x0c3c0cd5,
0x0a7e0b64,0x08c6099f,0x078a0816,0x06fa0724,0x06eb06ed,0x06c406e0,0x06c906ba,0x074806ec,
0x084507c1,0x09bd08f6,0x0b5b0a8e,0x0c6d0bfb,0x0cda0cbd,0x0cd00cde,0x0c560c9b,0x0bd60c11,
0x0b8a0bb0,0x0b290b62,0x0a5e0ad0,0x094109d9,0x07e10895,0x06d30749,0x066c068c,0x064a065b,
0x062e063b,0x068c0648,0x073906db,0x0819079d,0x092908a9,0x0a02099f,0x0aa20a54,0x0b860afe,
0x0d8a0c5a,0x10b10f06,0x13971255,0x148d144f,0x13ea146d,0x11c31304,0x0e48102c,0x0a3d0c3f,
0x06500845,0x02b4047e,0xfefd00d9,0xfad6fcff,0xf6e9f8d4,0xf391f51a,0xf09ef213,0xed83ef34,
0xe8b3eb5b,0xe1a4e57d,0xd875dd4c,0xcd22d2fa,0xc017c6ed,0xb213b90b,0xa8d9ac13,0xaecea975,
0xc659b8e1,0xe551d5b1,0x005ef3db,0x114b0a32,0x178315b6,0x1581172f,0x10e41331,0x0e130f20,
0x0e0b0dcf,0x0f550e9b,0x0fd60fd8,0x0e2f0f43,0x0b5e0cc4,0x09aa0a4a,0x0a3d09aa,0x0d230b71,
0x10f60f11,0x13e212b3,0x14b9148a,0x13c6146a,0x11dc12dc,0x104f10ff,0x0fd30feb,0x0fa70fc9,
0x0ed10f59,0x0d0f0e12,0x0a9b0bde,0x0826094e,0x069c073d,0x05f1063c,0x056d05a5,0x056b054f,
0x064105c2,0x07e406fe,0x09de08dd,0x0b690ac7,0x0be50bc4,0x0bd80beb,0x0bb50bb6,0x0c5c0bd9,
0x0ead0d52,0x11cb1038,0x141a1328,0x14721488,0x12d913dd,0x0fbb1171,0x0c030deb,0x083f0a08,
0x059606b6,0x042204c6,0x032f03bc,0x0189026a,0xfebd0042,0xfa34fcd3,0xf3bef73e,0xead4ef67,
0xe0ace5f5,0xd63edb76,0xcca9d12b,0xc51cc887,0xc147c2be,0xc21cc102,0xc795c445,0xd035cbac,
0xd983d4f4,0xe0ecdd83,0xe61ae3b0,0xeb6fe885,0xf3c4ef34,0xfdd5f8c4,0x071b02b4,0x0d350aa7,
0x0f960ed6,0x0f160f97,0x0d330e37,0x0ba80c4a,0x0bcd0b8a,0x0cfe0c55,0x0e4c0da4,0x0f320ee7,
0x0ec50f1f,0x0de00e4e,0x0d9e0d9f,0x0e310dda,0x0f130e93,0x0fe50f99,0x0faa0ff0,0x0e6e0f1b,
0x0d420dbe,0x0c8a0cde,0x0c370c55,0x0c320c35,0x0b9f0bfd,0x0a710b17,0x091509ba,0x08130887,
0x07aa07c4,0x07fe07c5,0x088c0849,0x08f008c3,0x0990092f,0x0ab10a15,0x0c3d0b70,0x0e0b0d1e,
0x0fa40ee0,0x10fb1058,0x120c1195,0x128b1261,0x12921297,0x12af129b,0x12f812d3,0x12ac12f2,
0x11781231,0x0f5f108f,0x0c660de6,0x097b0aed,0x069c080f,0x031204fb,0xfe1500bb,0xf6f1faee,
0xedadf27d,0xe2bce83e,0xd80add63,0xcf5ed36f,0xc8e6cbbc,0xc463c678,0xc1ebc2fc,0xc143c14c,
0xc222c18f,0xc440c313,0xc7dfc5bb,0xce29cab0,0xd82bd2ae,0xe6added1,0xf8aeef71,0x09e401c0,
0x15bd10b7,0x19d218b7,0x17b51958,0x12f21572,0x0eba109a,0x0cb50d68,0x0ccd0c9a,0x0d740d21,
0x0d8f0d9a,0x0d050d62,0x0c2b0c8e,0x0c0e0bf0,0x0d690c98,0x0fa10e84,0x118910a8,0x123b120d,
0x119b1219,0x106210fb,0x0f960fdd,0x0f720f72,0x0fd20f9d,0x10121001,0x0f710fe4,0x0dce0eb7,
0x0bf40cda,0x0aa50b31,0x0a2e0a4a,0x0a920a4d,0x0b650af5,0x0c2d0bcd,0x0cf40c8e,0x0ddb0d6d,
0x0e580e2c,0x0e510e5e,0x0da90e15,0x0c910d21,0x0bf80c1f,0x0c7e0c1a,0x0d9b0d05,0x0f1b0e4e,
0x10d40ff2,0x11ed1182,0x12201227,0x119011f1,0x0ff010de,0x0d790ed2,0x0a580bf8,0x065a087a,
0x00cd03e2,0xf80bfcc1,0xed3ef300,0xe133e72d,0xd463dad2,0xc7d5ce29,0xbc04c1c0,0xb161b657,
0xa9c3ad32,0xa73ea7c6,0xaae7a849,0xb47eaf10,0xc2b3bb09,0xd51fcb65,0xeb35dfdb,0x01e2f6c6,
0x13c70ba4,0x1da419ee,0x1f041f43,0x1aae1d3b,0x149117a0,0x0fbb11ed,0x0db20e4c,0x0d810d72,
0x0de00dbb,0x0e1e0e09,0x0e1f0e22,0x0e020dff,0x0f1e0e6f,0x11511012,0x13da1294,0x15d614ee,
0x16be168b,0x16041681,0x148c1547,0x133e13dd,0x126312cc,0x11fa1217,0x117211ce,0x0ff210d4,
0x0d810ed1,0x0acd0c21,0x08870995,0x074b07bf,0x072c0725,0x0776074d,0x07a8078f,0x07e907c7,
0x085a0826,0x08ec089b,0x09af0945,0x0a930a18,0x0bc10b21,0x0d8f0c8e,0x103e0ec6,0x138911d3,
0x16e01542,0x198a1853,0x1b3c1a85,0x1c221bcf,0x1b851c13,0x18961a52,0x13471640,0x0b600fc4,
0x00a10648,0xf35dfa16,0xe52eec9e,0xd647ddcd,0xc599ce06,0xb363bcc9,0xa16baa4c,0x9329995f,
0x8d378ee9,0x938a8ed5,0xa5549b39,0xbea6b144,0xda2ecc70,0xf3e0e78c,0x08ccff12,0x179e10f1,
0x1f941c80,0x21482126,0x1e692040,0x19371be8,0x13f71685,0x106911f2,0x0eba0f5e,0x0e6c0e69,
0x0f060ea8,0x0fdd0f79,0x1077102c,0x114d10d1,0x12b611f7,0x149113a3,0x163e156d,0x173116cf,
0x171a174b,0x162916ba,0x14b81573,0x132713ea,0x11a41266,0x103e10f8,0x0ea60f72,0x0d0c0dd5,
0x0b510c37,0x099f0a79,0x080d08c3,0x06f3076e,0x06400691,0x05e70608,0x05f705df,0x066a0626,
0x072f06c3,0x084407ac,0x098c08e7,0x0af70a3d,0x0ca30bc1,0x0e710d8b,0x105b0f5d,0x12c11182,
0x152f13ff,0x171d162e,0x187417e2,0x18f818e0,0x181e18bb,0x157a170a,0x10c7137f,0x09060d27,
0xfe0103fd,0xf1a0f80f,0xe3d5ea8f,0xd5f4dcf2,0xc90ecf8e,0xbc96c29c,0xb024b64b,0xa4b8aa5e,
0x9c269fd9,0x99f299f5,0xa1039c33,0xb25ba884,0xcb5cbe24,0xe6b6d91f,0xff2df3a1,0x110908ff,
0x1af916f4,0x1e861d7f,0x1dde1e8d,0x1b1c1c98,0x17d21978,0x14f41654,0x12ad13b0,0x111311cb,
0x102d1085,0x0ff50fff,0x104c1015,0x110d10a5,0x11ff1173,0x130d1285,0x14111395,0x14af1475,
0x14ce14ce,0x145c14a2,0x13a01404,0x12d9133f,0x122a1281,0x115111c0,0x103810ce,0x0ee90fa0,
0x0d530e2a,0x0b970c74,0x09f40ab8,0x08bd094b,0x08190858,0x07e607ee,0x080507f0,0x08770831,
0x090208bb,0x09a5095c,0x0a3d09ed,0x0ab80a79,0x0b530b04,0x0c340bbf,0x0d3a0ca0,0x0eb50de4,
0x10be0fb8,0x12dc11d7,0x14af13d5,0x16041563,0x164b1651,0x157e1616,0x13311485,0x0e801137,
0x06870b09,0xfb610129,0xee84f52d,0xe0f4e7c0,0xd3c8da40,0xc7ffcda6,0xbd73c2a4,0xb35eb86c,
0xa8fcae32,0x9f8aa3e6,0x9b529c91,0xa0069c65,0xaf8da65b,0xc8b4bb47,0xe5cad727,0x0040f3b4,
0x13d00b04,0x1ee41a66,0x22642177,0x20ac2207,0x1c931ebe,0x18331a52,0x14e11665,0x12b413ad,
0x115b11f2,0x106e10e2,0x0fe6101c,0x0fc40fc0,0x10460ff3,0x112310af,0x125611b6,0x135d12e6,
0x13d213ab,0x139213ca,0x12d4133e,0x11be1249,0x10e91148,0x105d1098,0x0fd3101e,0x0ee10f65,
0x0da10e4f,0x0bf40cce,0x0a5f0b23,0x097509cd,0x09660958,0x09cd0996,0x0a4d0a0a,0x0aa20a75,
0x0ae70ace,0x0b090af8,0x0b390b23,0x0b590b4e,0x0b730b64,0x0baf0b8d,0x0c050bd9,0x0c7c0c35,
0x0d550cd8,0x0eab0dfa,0x10630f6f,0x125e1152,0x14631371,0x15db1542,0x1609161f,0x14321570,
0x0f01120f,0x05f70aff,0xfab00084,0xedb0f445,0xe072e70e,0xd3e6da04,0xc8e0ce3f,0xbeb9c3ba,
0xb45fb9a0,0xa8d6aec7,0x9d8ea307,0x96a5992b,0x99949693,0xaa4aa01c,0xc753b7af,0xe8f8d814,
0x065ef8a7,0x1a7411cb,0x24262085,0x25a825ad,0x22682474,0x1db12014,0x19481b5b,0x15ac176d,
0x12cb1428,0x1083118f,0x0ef40fa9,0x0e5c0e88,0x0eb20e66,0x0f8f0f1b,0x10b7101c,0x11e81152,
0x12a7125a,0x12d012cc,0x129b12bb,0x121f1268,0x11a611d5,0x119d1198,0x11c111b5,0x118e11b5,
0x10b41139,0x0f2e1007,0x0d550e3f,0x0bee0c8a,0x0b630b8b,0x0b7b0b5f,0x0bdc0baa,0x0c0b0bfe,
0x0bc60bef,0x0b1c0b7a,0x0a5f0abd,0x09de0a1a,0x098a09ab,0x099f0984,0x0a2d09d9,0x0b3b0aa2,
0x0ce40bf3,0x0f4e0dfd,0x124410c7,0x155813d5,0x17e716b4,0x195e18d3,0x195b1998,0x178218a9,
0x130615aa,0x0b1a0f7f,0xffc405c2,0xf2cff98a,0xe4cfebc6,0xd67eddb0,0xc857cf7a,0xb99ec113,
0xa925b19b,0x977da06f,0x88cf8f46,0x84d584fa,0x917d88f9,0xadee9df4,0xd31fc00d,0xf787e612,
0x13010690,0x23081c74,0x289c2700,0x27182870,0x224324db,0x1d231fac,0x18c01ad2,0x155516e3,
0x129113ea,0x1070116c,0x0f330faf,0x0edb0ee4,0x0f520f04,0x10710fd3,0x119d1109,0x12b8122c,
0x134c1310,0x133e135f,0x128512f5,0x11a11207,0x10cd112d,0x10661092,0x103e104f,0x0fe31017,
0x0eca0f76,0x0d270dfd,0x0b540c3a,0x0a110a96,0x09b309c8,0x0a1b09d9,0x0a8e0a5f,0x0aa80aa3,
0x0a580a8d,0x09d50a19,0x0944098a,0x08cd0900,0x089608aa,0x08d8089f,0x09b70939,0x0b1f0a61,
0x0ced0bfb,0x0f650e08,0x127010e7,0x154c13f1,0x177e1687,0x189c1828,0x185518aa,0x163d1793,
0x1196144b,0x09620df1,0xfe260405,0xf15ff7fb,0xe403ea98,0xd6ccdd5d,0xca71d0a2,0xbdbcc427,
0xaf67b6c6,0x9f53a794,0x90409757,0x88578add,0x8eee896d,0xa7a69938,0xcc88b927,0xf286e00e,
0x108902fc,0x22c61b32,0x295e274b,0x280e2976,0x236225ee,0x1e8e20db,0x1aa01c76,0x17af1917,
0x1522165f,0x12cf13e5,0x110411d0,0x10161072,0x10120ffd,0x10de1071,0x11c3114b,0x12951235,
0x130612e2,0x12e9130d,0x12361296,0x115f11cb,0x10ad10fd,0x10411072,0x0fd3100f,0x0f1a0f87,
0x0dd30e7b,0x0c050cfe,0x0a130b0c,0x0897093e,0x080b082c,0x086e0826,0x094608d5,0x09fd09b0,
0x0a2a0a25,0x09e00a18,0x095c099b,0x0907092c,0x08f008f8,0x092b0904,0x09a2095d,0x0a6409fb,
0x0b7f0ae4,0x0d270c3f,0x0f5a0e32,0x11b2108b,0x137612ac,0x14841416,0x14e514be,0x148214d9,
0x12f113ed,0x0f411171,0x07af0bfb,0xfd1802b2,0xf0a6f70a,0xe362e9fa,0xd634dcc3,0xc9f9d010,
0xbd92c3c8,0xafe7b6fb,0xa093a86f,0x921c98e3,0x8ab78d03,0x924a8c3b,0xac619d32,0xd287beae,
0xf8f2e661,0x16240904,0x27182032,0x2c342aef,0x29932b80,0x23e526de,0x1e6a2109,0x1a0b1c13,
0x16be1843,0x13931529,0x10bc1221,0x0eb20f96,0x0ddb0e17,0x0e390de6,0x0f8f0ed6,0x10e01041,
0x119f1156,0x11cf11c9,0x11a911c3,0x11401176,0x10f01112,0x10b510d9,0x107810a3,0x0fc0102a,
0x0e6c0f2c,0x0c760d84,0x0a300b53,0x082d0919,0x070d077c,0x072906f8,0x0836079d,0x097408e2,
0x0a3b09f1,0x0a670a68,0x0a1f0a4a,0x09d109ef,0x09dc09cf,0x0a2909fd,0x0a860a53,0x0afa0abd,
0x0b9f0b42,0x0c8e0c0e,0x0e080d38,0x0ff40ef7,0x11a110e0,0x12911236,0x12fa12d0,0x13101308,
0x127012e1,0x10be11c3,0x0d600f5a,0x066a0a66,0xfc1c019b,0xf00cf62f,0xe2dbe977,0xd5e2dc72,
0xc9dccfa2,0xbe16c3f2,0xb15eb805,0xa32baa7b,0x95349bd0,0x8d1f8fe7,0x93148dda,0xabcb9d3c,
0xd17dbdbc,0xf85ee56d,0x163608cd,0x278f209a,0x2c8e2b60,0x29822ba8,0x237a26ac,0x1dee2088,
0x19981b99,0x163c17dd,0x130614a2,0x101b1172,0x0e4f0f0e,0x0e020e00,0x0ee50e53,0x10510f99,
0x116510f1,0x11cb11ab,0x11be11cd,0x117611a6,0x0fab1137,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,
};

const uint32_t sample_1_tuba_tromg4[896] = {
0x00000000,0xffc7ffd4,0xffb9ffc2,0xffa1ffab,0xff9eff9d,0xffb9ffa8,0xfff4ffcf,0x00370014,
0x0072004f,0x00980080,0x0099009c,0x00750089,0x003b005d,0xfff6001c,0xffc4ffe1,0xff95ffaa,
0xff80ff8b,0xff83ff7f,0xff8eff84,0xff90ff88,0xffa8ff99,0xffecffd2,0x00440020,0x0083005d,
0x00bb009e,0x00d300cc,0x009e00ba,0x003b0070,0xfff00015,0xffb4ffd7,0xff94ffa5,0xff72ff81,
0xff68ff71,0xfeffff75,0xf9e9fc6f,0xf7d0f800,0xfe46fa39,0x059e0238,0x088807b8,0x072e07f0,
0x047e0598,0x03c00366,0x06a4047e,0x07da0804,0x01720585,0xf892fd80,0xef66f3d9,0xea1eec11,
0xedc7eaaf,0xfcfdf42d,0x0dd5062a,0x13bb1244,0x0e73120c,0x056609f4,0xff5e0186,0xfeeffec6,
0x0112ffd3,0x049202c0,0x06b1068f,0x01c3055f,0xf6b6fcbe,0xea9ff069,0xdfffe516,0xe7a9df4a,
0x0952f7b0,0x20ff1826,0x1dc322b3,0x0cd015d4,0xfe7a051a,0xf86cfacf,0xf9daf83c,0xfdf9fc00,
0x012fff45,0x05db0353,0x05cd06b6,0xfbac0168,0xee0ef4c8,0xe0d3e74c,0xe2fadd41,0x0718f333,
0x22ff1855,0x216d25a7,0x0f0418cd,0xff1205ba,0xf83ffab5,0xf828f740,0xfa46f9a2,0xfa0ffa03,
0x0283fda2,0x0a4507d7,0x052e09cc,0xf70bfece,0xe70bef12,0xdc6fdfec,0xf310e16f,0x195206f6,
0x27202440,0x18ad2217,0x04430dc7,0xf8cefceb,0xf745f738,0xfa0bf90f,0xfb83fb2b,0x00b7fd9d,
0x086604ea,0x083b0a2a,0xfcee0390,0xef5bf5ab,0xe51eea17,0xddc8e045,0xf916e5cb,0x22600f98,
0x2aab2bb4,0x15cd223b,0xfe4d08f3,0xf403f717,0xf78ef4d1,0xfc23fa1f,0xfef3fd2c,0x041d00b7,
0x09560729,0x03d1083d,0xf696fd9b,0xec40f07e,0xe4abe8cc,0xdb9fde1f,0xfe48e6dd,0x2c381910,
0x2e5632c9,0x132b220d,0xf9f004c3,0xf46bf48b,0xf8d7f6e6,0xfc06fb0c,0xfed5fc5f,0x055101b3,
0x097508bc,0x00e40764,0xf20ff975,0xe6bdec30,0xcd00de5f,0xd9cdc020,0x2b3305cd,0x434f411d,
0x25a538c6,0x019512d4,0xf2eff698,0xf71bf4df,0xfb6af8af,0xfdbafd7b,0xfd52fd12,0x00c0fe6d,
0x00d6039a,0xf5a2fc12,0xeaa8efca,0xd9ede39b,0xd186cbf6,0x15eaf009,0x41ac347a,0x3354406b,
0x0d8820de,0xf48ffe11,0xf35bf254,0xf700f48b,0xfe89fb29,0xfbfbfda2,0xfedafcb7,0x04af039b,
0xfbe80214,0xed37f434,0xe0b3e73d,0xc883d67e,0xf7abd402,0x3b011e71,0x40e64508,0x1d99313c,
0xfa3e094e,0xee3cf0e1,0xf0d0ee61,0xfc03f5a9,0x014200a0,0x024e0216,0x056d03c1,0xffd30419,
0xef9ff821,0xe006e76c,0xcc8ad84b,0xe51ec919,0x2ef70bb5,0x4562430e,0x28863a9d,0x017d1475,
0xeea9f415,0xef51ee1f,0xf9e1f372,0x02d1000c,0x05af03d9,0x054f060d,0xfe420334,0xf0f9f74c,
0xe188e891,0xcfa2d8ab,0xddc5ca41,0x229600f9,0x435d3b23,0x2eb83ef4,0x07871bbe,0xefddf870,
0xf134ef2a,0xfa14f4c3,0x0133fece,0x00c90001,0x037e0291,0xff4502b8,0xf490f994,0xe8deeee6,
0xd545e033,0xd278ca19,0x18e4f462,0x43ad36d2,0x35cd438d,0x0d6a226a,0xee96fb4d,0xeb15e96f,
0xf43deefc,0xffecfa26,0x04b9031e,0x087906b0,0x0567082d,0xf82eff64,0xe9a5f0e6,0xd32be0e6,
0xc43fc102,0x1477e96c,0x465f363c,0x38e9461b,0x10a724db,0xf150feb9,0xeaebeaa4,0xf2c3ed98,
0x006efa15,0x03d502c1,0x08b60611,0x06f309f9,0xf97f0099,0xebb3f223,0xd06ce1b8,0xbe74b81a,
0x14e0e67e,0x48bb385b,0x3b59492e,0x1317278f,0xf3c10168,0xeca1ed39,0xf0c9ed43,0xfd26f772,
0x0016feb0,0x08d603fa,0x083a0aa2,0xfa850230,0xeaecf230,0xd1d1e254,0xb781b24c,0x1844e7a5,
0x4f293f7e,0x3e214ede,0x10332713,0xf175fe4b,0xeb2fec3f,0xed47ea3c,0xfcb3f464,0x01b70005,
0x09db058a,0x08e30b99,0xf9f201fb,0xe9d0f0dc,0xd309e214,0xac5cad00,0x1a5de54b,0x56c94699,
0x43ab5604,0x107f2a20,0xed97fb42,0xe961e8d9,0xed7fe9c5,0xfdbaf4cc,0x011b0076,0x07760280,
0x09e50aa1,0xfc6d03b3,0xea1ff274,0xd503e10c,0xa708b359,0x14a4dcc9,0x56e342b6,0x4909584a,
0x15a23032,0xec97fd1d,0xe7aee63c,0xee79e986,0xfd6ff62b,0xfcc5fdda,0x058e0006,0x0a4d0a96,
0xfe1605c3,0xeb9af532,0xdad9e405,0xa029c2c5,0x0651c5bc,0x57fe3906,0x53e75c8e,0x20a23b7d,
0xefdc04b4,0xe2f1e3d0,0xeae0e47b,0xfe89f49e,0xfc3bffb0,0xff77fb86,0x0a5906ab,0x02e3099c,
0xf06efa2d,0xde79e836,0xa41bca99,0xf558b27d,0x53a02d49,0x573e5cd0,0x28d94247,0xf63f0dc2,
0xe12ee60a,0xe525e147,0xfbf2ef4f,0xffdd031c,0xfdfdfcd5,0x07e2033d,0x04d908a4,0xf540fd28,
0xe46ced75,0xaed6d4e9,0xdb3da0f2,0x48061812,0x5a8d5b2e,0x326b4aa7,0x0199194a,0xe6adf010,
0xe33be3cc,0xf683ea87,0x000200a7,0xfc75fcb4,0x0686017c,0x04d607bd,0xf6ddfdbd,0xe54cef80,
0xa89ad2c7,0xdb7d9e99,0x46f617cf,0x5a645982,0x33764b65,0x05931bc0,0xec6df5ae,0xe2eae7c3,
0xf206e73b,0x0106fde3,0xfbb5fccc,0x028cfe72,0x025504bd,0xf7b3fe81,0xe720f1f2,0xaa7fd374,
0xdc05a630,0x447916b7,0x58f55750,0x31c84a14,0x033f1852,0xeeeff55e,0xe74eebbb,0xf09ae802,
0xfed7fafe,0xfeebfd40,0x065b032b,0x00c404af,0xf565fbe7,0xe558ef1a,0xa16dcea4,0xe486a8a1,
0x49e51e4a,0x588d58ec,0x2f24477e,0xff56147f,0xf09ef37b,0xea3deeaf,0xf14cea78,0xfc36fa3b,
0xfe63fbf1,0x06d20439,0xfe720452,0xf3b6f9ac,0xe54dee16,0x9824cda1,0xeb07a8a4,0x518924fc,
0x5bf35d30,0x2d7d4734,0xf964101f,0xebbded1f,0xeb5bebbc,0xf6aeee96,0xfda5fdb2,0xfee9fbb0,
0x08950550,0xfd1f04ac,0xf16df7fb,0xe4fded4e,0x91e8cec0,0xefc8a5e3,0x589a2b4b,0x5ecc60bf,
0x2cac478f,0xf6630d9c,0xe7efe981,0xe93ce82b,0xf79eee36,0xfd1eff40,0xfc3ff9d2,0x093003c3,
0xff9005dc,0xf564fb2b,0xe78ef0d5,0x936bd38a,0xea5d9eb5,0x5730267f,0x607b6002,0x30934afc,
0xf6ed10e1,0xe461e6a2,0xe60de564,0xf773ecd0,0xfc72001f,0xfc3ff93d,0x090b0399,0x01bb06fe,
0xf867fd19,0xec6ff520,0xa12ede2b,0xd922872f,0x54331760,0x64136238,0x366a5203,0xfb5e184f,
0xe19fe8b3,0xe31de49d,0xf565eae7,0xff270209,0xfa77faad,0x05a20055,0x01cd05ff,0xf83afd32,
0xefbcf6bd,0xae06e314,0xcb71871c,0x4a910c54,0x644d6150,0x3c9456b7,0x027c20d8,0xe29ced6e,
0xdfe2e2b3,0xf1cbe66d,0xff47007a,0xf9fdf9bd,0x05f4ff4a,0x02f205ef,0xf8bffde3,0xf12bf679,
0xb2efe4af,0xc48f85fa,0x459e06b0,0x65a761bd,0x3e895a2c,0x02d0220f,0xe469eed5,0xe1a5e567,
0xefe5e5c8,0x0051feaa,0xfaf9fb38,0x060e0165,0xfe050480,0xf46ef98a,0xf001f431,0xaffbe4df,
0xcf378fec,0x453a0a1a,0x61ad5d31,0x3bbe5511,0x03bc20d8,0xe85ef1c4,0xe539e98b,0xeee5e5e6,
0xff24fd14,0xfa43fae6,0x04df0112,0xfb3401f6,0xf374f806,0xee42f1cc,0xa4f8df3e,0xdda49e59,
0x477d14eb,0x5d0c58f5,0x378a4ee8,0x02c11ce8,0xeb3af215,0xe9a2ebba,0xf087e88d,0x000afe3d,
0xfb4dfa7f,0x0664021c,0xf7ad0067,0xefd4f3d9,0xea84ed5e,0x9d09d5f6,0xef92b1fe,0x4b482502,
0x5753566c,0x2fbe466f,0xffca169e,0xe9efeee3,0xecacead8,0xf520ed2b,0xfebbff08,0xfb48f8b2,
0x086502de,0xf7b300a7,0xefb1f35d,0xe958ec5b,0x954ad037,0xf8bcbd3b,0x4d9e2f80,0x532853e4,
0x2ab44157,0xfbfe1064,0xe957ebd2,0xeebfea90,0xf859f030,0xfd76ff3c,0xfd5df88e,0x0b4205dd,
0xf851017c,0xedb4f1a4,0xe81dea75,0x93fcd152,0xfaebbb4c,0x53aa344d,0x54775562,0x29ba4195,
0xf7d30d1b,0xe43be68d,0xecd1e6d4,0xfc03f24d,0xffff03b8,0xfe0afaa8,0x0a740650,0xf676006b,
0xebb0ef54,0xe9d6eb61,0x9a1fdbc2,0xf858b0ec,0x56bb3015,0x565f5687,0x2b5842e7,0xf6b60e09,
0xe001e3d2,0xe9ffe393,0xfd22f257,0x011305e7,0xfda0fbfe,0x0a9e05c9,0xf73f00e0,0xebebef05,
0xeb18ec2b,0x9eede0eb,0xf3b8a860,0x58862bb1,0x58a85a19,0x2c69455a,0xf5d80ecc,0xdd37e2a6,
0xe674e15f,0xfb1aef94,0x03cf074d,0xfe70fd59,0x0bd706fd,0xf6eb01f2,0xebeceed5,0xec11ed54,
0xa4c5e367,0xeddba304,0x56b02677,0x5be55d60,0x2d8347fe,0xf55b0f85,0xdc5de248,0xe43fe0e5,
0xf9fded15,0x053d084a,0xfe81fd9d,0x0c0c06d4,0xf63f01e6,0xece9eec7,0xec70ee26,0xa7f8e333,
0xec65a587,0x52d0242e,0x5cac5d12,0x2e6f498c,0xf5b91033,0xdf14e492,0xe4b2e2e7,0xf61deaf0,
0x03f804f9,0xfdd0fcd5,0x0e6207ed,0xf6f503f2,0xeca1eef0,0xea09eca7,0xa40adac1,0xf281b195,
0x4fd5291e,0x5a385a18,0x2e01482d,0xf5460f58,0xe10ce479,0xe680e2fa,0xf665ea95,0x03da03df,
0xfebbfd24,0x0f7108a9,0xf63402bc,0xecd1edb2,0xe8f2eb27,0x9e93d1d1,0xfb1fbfc7,0x4e2a312a,
0x55675628,0x2afc4406,0xf4640c81,0xe350e489,0xe955e4cc,0xf677ec29,0x028501ff,0x00c8fdef,
0x10b50aa0,0xf49702bf,0xeac0ec30,0xe56fe851,0x9e0ac807,0x05b6cda0,0x50023b34,0x50c5533e,
0x278d3f4e,0xf20d0904,0xe2b9e304,0xead1e4a5,0xf8e9eeb5,0x013c0239,0x020afe61,0x10b50baf,
0xf2e00169,0xe963ea76,0xe4dae775,0x9d74c2ad,0x0d0ed61f,0x538942d3,0x4e21533e,0x24293baf,
0xefdb0664,0xe0bde18f,0xe906e1fb,0xfa64f06f,0xff1100f4,0x03f4fe8a,0x11e70dc6,0xf34602d9,
0xe859e903,0xe418e6aa,0x9b7bbf55,0x10ced8b5,0x57d74856,0x4f2855af,0x23793ba3,0xed750527,
0xdcb9de74,0xe5b7de81,0xfd06f08c,0xffab02bb,0x03b4fe8d,0x11c30db9,0xf4540230,0xe898e8f9,
0xe4a1e753,0x9b9dc3be,0x1011d56a,0x597846b5,0x51065777,0x23203bb5,0xecf2051d,0xdc01dd4c,
0xe3f8de2b,0xfcc7ef66,0xfcbd00e6,0x03e0fd4e,0x13bd0f89,0xf5ac04c1,0xe9a1ea3e,0xe440e883,
0x9b44c573,0x0d27d0fa,0x59454313,0x55125a27,0x25923ede,0xed69065b,0xdb96dc36,0xe261ddc8,
0xfceeedf6,0xfd0a02a4,0x0235fbe6,0x14360ed9,0xf5cb0522,0xe9e4ea82,0xe4b8e8b8,0x9ae7c683,
0x0b11cc94,0x59fe40cf,0x57785d5f,0x25714010,0xed6605ec,0xdcc9dcbb,0xe0cade37,0xfba0eb8e,
0xfd1d02c2,0x02f3fc40,0x15f71077,0xf55f0571,0xe950e961,0xe391e7c3,0x9a46c249,0x0b85cecc,
0x58443f8a,0x57255d9e,0x263340bb,0xeda6075a,0xe07cde99,0xe343e19d,0xfaadea40,0xfedd035f,
0x030dfd02,0x13e40f53,0xf24802ae,0xe7f6e7b1,0xe1fbe5ac,0x9c85ba7d,0x11f2d866,0x569d4444,
0x545e5c26,0x24d53f53,0xed3706cf,0xe0bdded2,0xe3d3e218,0xfad9ea7c,0xfedd0352,0x030dfd02,
0x13e40f53,0xf24802ae,0xe7f6e7b1,0xe1fbe5ac,0x9c85ba7d,0x11f2d866,0x569d4444,0x545e5c26,
0x24d53f53,0xed3706cf,0xe0bdded2,0xe3d3e218,0xfad9ea7c,0xfee90352,0x032ffce8,0x00000fba,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};
