#include "Pizzicato_samples.h"
const AudioSynthWavetable::sample_data Pizzicato_samples[4] = {
	{
		(int16_t*)sample_0_Pizzicato_PizzViolinE3,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		13,	//Number of bits needed to hold length
		(524288*1.0*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 622.2539674441618 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)5687-1) << (32 - 13),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)5679-1) << (32 - 13),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)5679-1) << (32 - 13)) - (((uint32_t)5608-1) << (32 - 13)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-550/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(4110*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(2940*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(1*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_Pizzicato_PizzViolinC4,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		13,	//Number of bits needed to hold length
		(524288*1.0*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 1046.5022612023945 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)4607-1) << (32 - 13),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)4599-1) << (32 - 13),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)4599-1) << (32 - 13)) - (((uint32_t)4557-1) << (32 - 13)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-550/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(3929*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(2849*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(1*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_Pizzicato_PizzViolinE5,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*1.0157180609309646*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 2793.825851464031 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1355-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1347-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1347-1) << (32 - 11)) - (((uint32_t)1331-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-550/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(2569*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(1449*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(1*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_3_Pizzicato_PizzViolinE5,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*1.0157180609309646*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 2793.825851464031 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1355-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1347-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1347-1) << (32 - 11)) - (((uint32_t)1331-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-550/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(2329*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(1309*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(1*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5129/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

PROGMEM
const uint32_t sample_0_Pizzicato_PizzViolinE3[2944] = {
0xffeeffbc,0x03230104,0x062004f3,0x0d4f07cb,0x1c351736,0x16ae18bd,0x1cad1a19,0x1ed81ede,
0x1a1b1b79,0x1ea61c1e,0x11081a2f,0x074a0a00,0x034305c7,0x012e02b7,0xf781fc58,0xf5d7f770,
0xeee8f0ff,0xf371f15c,0xef28f0cc,0xede5f0bd,0xe732e7dd,0xebbbea4d,0xed82eb55,0xf290f040,
0xee91f29a,0xf701f0c4,0xf7a6f4b1,0xfdd4fe96,0xf0b0f71e,0xfbbef36a,0x092e02ae,0x0ced0f60,
0x0d2608b1,0x0458132a,0x0e8806b3,0x1a481173,0x20e522d4,0x27291a4f,0x08911e87,0x09ee04e7,
0x1da30f8e,0x2bd62b41,0x0c131ff1,0xe059ed1c,0xf1fbe235,0xf8c8f96b,0xd543ee0c,0xd6ead00b,
0xd392d175,0xee0ae952,0xe826e46f,0xdcd5e6c6,0xe04ee179,0xe420e191,0x06edf0d0,0x0cf50986,
0xf7dd0c93,0x080ff61d,0x05440d94,0x0cc702b9,0x1e411675,0x2129212d,0x1e9e22df,0xfecc0f69,
0x061afdcd,0x219c14d3,0x1e6a247a,0x07fa1447,0xfc4ffe52,0x122d04fd,0x2f712104,0x27a43038,
0x3545292a,0x2fc73706,0x1b0626f1,0x116c118a,0x190a1217,0x02cf1843,0xde2aed6f,0xd609d122,
0xe451e85f,0xa074c17b,0x9ad39b63,0xb5149f6a,0xb084ba89,0xb02dae2b,0xb9fab61d,0xab0eb1f3,
0xb228ab61,0xfc4ccec0,0x0176100a,0xebc8e99e,0x1fe90ab2,0x18211f73,0x28571897,0x3bee3711,
0x45dd3a9c,0x62955eda,0x4cd856a3,0x2f523e05,0x30ae2f04,0x323c3272,0x3aae3840,0x270b32d0,
0x22d12145,0x2beb2b9b,0x359d29cc,0x4db14687,0x3e0f4866,0x20312e80,0x02701445,0x0931fcc1,
0x0532123c,0xe4c5ebb8,0xd922e5fb,0xcc1acd6a,0xb775c790,0x8e6da0a0,0x99b98c94,0xad5fa66b,
0xb405b0fe,0xab63b14f,0x9abfa438,0xaccd9ce4,0xd336c454,0xb683ca97,0xc468b3a6,0xcad7ce87,
0xde49cbe1,0xf644f231,0xf4c6f495,0x11cbfb5f,0x4f4f36d4,0x49e35269,0x42f1435d,0x3f1540f5,
0x552d472e,0x51ef5abb,0x388a4478,0x41a037aa,0x50e549d6,0x62a759db,0x71be6a25,0x788a75a8,
0x685f75b9,0x48235640,0x494c4599,0x40ab49ed,0x1d443142,0xf4fd0766,0xdc90e81f,0xba58ce0c,
0x9f6bab07,0x9d1499a7,0xa0439f83,0xa523a1b9,0xa4f8a73a,0x98dea003,0x9dca954c,0xa76aa934,
0x9eaf9d41,0xac85a867,0xabb9ab26,0xc360b3df,0xc888cca6,0xc48ac1b6,0xea72d530,0x03fcf9a0,
0x1d40112c,0x1baa1f45,0x27d21b38,0x3d28382b,0x34f138ae,0x293e31df,0x231821d3,0x40972dc2,
0x59ee5400,0x5c7057b0,0x70466981,0x647b69a6,0x66d8650e,0x69c1697d,0x68406c2c,0x4665577f,
0x26fe32a1,0x1f6923cb,0x023b167e,0xd5d7e8f5,0xcf93ce3b,0xcd2dcfcc,0xdb80d112,0xd285de2b,
0xb540c10d,0xb795b223,0xc02cbdbf,0xc3b7c2d1,0xb1fdbd0f,0xa405a8b4,0xa7afa49b,0xa8cba8c6,
0xbbfbb039,0xc9efc4d5,0xe41cd4ef,0xf481f054,0xf0bfefea,0x06a3fab6,0x17161183,0x11ef16b9,
0x050b0b18,0xf8fdfd2a,0x0cfcfd52,0x365223cc,0x44ee3ffa,0x4954492d,0x4e2d48cd,0x5c5957af,
0x5cb15b6a,0x5b9f5e7c,0x46ef5213,0x2f0639de,0x3763304d,0x235a34c0,0xf6aa0b0b,0xe69cec3c,
0xe25adfe7,0xf58fee4c,0xe131ef10,0xd045d69b,0xca44cc0e,0xcf45cb4c,0xd705d57b,0xc362ceb8,
0xb827bb3a,0xb7b1b71c,0xbcbcb9f7,0xc4e2c04c,0xd82dcb2f,0xf360e85e,0xf828f607,0x05ebfd08,
0x1afa10f0,0x272d22b5,0x263327ee,0x1398200e,0xfe480519,0x118e03cf,0x27971ed7,0x2c392b3d,
0x2db82c38,0x3f683652,0x45374494,0x456343ea,0x40264553,0x2d2e37ce,0x233a25a2,0x21d3247f,
0xfd6a132b,0xddc6ea6b,0xd0c0d6c8,0xcbe0caf3,0xda3dd42d,0xc954d5a8,0xbf4bc1c8,0xbcb1bd87,
0xc5afbf0b,0xc978cad6,0xc07cc453,0xbf45be5b,0xbe83bf1b,0xc763c18b,0xd0c7cc63,0xe322d77c,
0xfb00efb1,0x144606b9,0x2eee2246,0x43743a52,0x4a6447dc,0x44024a28,0x2f793992,0x23632785,
0x2ddd260f,0x41fd37ba,0x48d9484a,0x4f8f4ab4,0x4f755183,0x51494ecc,0x503551eb,0x419a4b2f,
0x24a83300,0x13301afe,0xfca508fb,0xe4e6efe2,0xcbf6d965,0xb1a7beb8,0xb024aaaa,0xb255b5a1,
0xa916ac2e,0xa7fca999,0xa26aa3f6,0xa5b4a2e5,0xac3fa90d,0xb23caf30,0xb108b2d0,0xb86cb269,
0xc895c058,0xda94d1c5,0xe731e13a,0xfa2cf010,0x0ee60372,0x334f202a,0x481c418c,0x4b5b4ae8,
0x441f4834,0x41504251,0x336a3bc4,0x310d2e8e,0x439338f7,0x4bdb49f3,0x58a85090,0x5ed65ecd,
0x5bb15d75,0x575f5956,0x51295629,0x37d044cf,0x2fea329a,0x1c1b27e4,0x0a3f131d,0xeb62fb3d,
0xd01bdb98,0xc5edc7cc,0xc85fc7aa,0xc378c6e7,0xb460bb9c,0xab64aee0,0xaaf5ab8d,0xa254a672,
0x9c2e9fe6,0x933895bc,0x97dc948c,0xa3b99c93,0xb4b2ace8,0xc03abae1,0xcfa0c909,0xe16bd38c,
0x0329f68b,0x101e08cc,0x26a81a8c,0x2f4e2ee1,0x286c2ca5,0x20562308,0x2851232a,0x3a172f0e,
0x5076466b,0x5e0b5791,0x71826720,0x7b6b7807,0x757b7ab5,0x5fe06b34,0x5491586c,0x4cbb50b1,
0x455d48a5,0x37673f50,0x19282b10,0xf4ef0554,0xecaded1b,0xe779ec4e,0xdc7be16c,0xceb3d68f,
0xc00ac5b8,0xb35cb9ef,0xb20db1e0,0xa4bfacf3,0x96ba9cad,0x946d935f,0x9da49881,0xac03a53d,
0xac77acce,0xb258af3b,0xc635baa1,0xd259ce75,0xe741db17,0xf6baf00a,0x01fbfba9,0x056a0775,
0x046e03ea,0x06a703e0,0x1fe91082,0x2daf2922,0x431a3506,0x6a8157dc,0x7c8a7530,0x77597ca6,
0x7642765b,0x6c207224,0x61ed6672,0x5da9607d,0x50ea57e9,0x31ec42a9,0x14f92110,0xfdf409cd,
0xef31f37c,0xeaabeecb,0xdb26e360,0xcc15d383,0xbf23c3f4,0xc4b9c163,0xbbe8c247,0xae9fb671,
0x9a8ca21f,0xa45e9c2f,0xb0cdad4e,0xb310b147,0xbf17b88c,0xcaa0c4d0,0xd510cfcc,0xe026d958,
0xf46eead9,0x0b00fe43,0x19661647,0x07381316,0xf6fefc15,0x04a9fac4,0x15cb0f39,0x268e1c0d,
0x42c033f4,0x59f350a0,0x5ecd5f74,0x58ba5a0a,0x5a545b27,0x51c1553f,0x53d05218,0x48be51d9,
0x296e397d,0x0f1b1c35,0xf4360072,0xeb0ced1a,0xe76cea36,0xe2f1e56d,0xd23cdb9b,0xc671cb0e,
0xc424c4c8,0xc48fc430,0xc19bc395,0xbb36bdc3,0xc126bd6f,0xc1c5c307,0xc0babe91,0xd5dcc937,
0xe5e8e107,0xecb8e7fe,0xfbf3f672,0xfe7afb3f,0x19890b00,0x26e62361,0x18a522f5,0x08d90d54,
0x09f60a2b,0x02f00599,0x108a073d,0x2c3e1d1b,0x3fe038b1,0x4ba7458e,0x4f084f7b,0x4bc94d5a,
0x47704953,0x495348b1,0x3bba447d,0x24ee306c,0x07b9170c,0xece2f9f7,0xd5b8dfff,0xcbbece1b,
0xcb42cc6d,0xc608c7c8,0xc6d5c674,0xc005c3d9,0xc3f4c0ef,0xc30bc4aa,0xc5c9c2ff,0xc761c704,
0xc9a1c945,0xcb22c824,0xd840d1ce,0xe138dcff,0xede4e65e,0xfacaf524,0x09180187,0x1e4b10b5,
0x35ed2e9e,0x298a31bc,0x202523e0,0x16661c37,0x0cf10f3a,0x1a7f117c,0x31562669,0x412a3944,
0x4db44800,0x5a7d5462,0x5ea25e7a,0x5b985c9e,0x512b591a,0x4252487a,0x30ca3b1c,0x165e2475,
0xf7c20808,0xd79fe679,0xc5eecbf1,0xbeadc27e,0xb5d2baf8,0xad34b014,0xac92ac91,0xa8cbac41,
0xa32ea4bf,0xa8eda540,0xab97aac0,0xb1ccae65,0xbafdb512,0xc56bc078,0xce3dc97c,0xe024d59f,
0xf33deae8,0x0339fae4,0x1c2a0de3,0x2e8c27ce,0x34c3327b,0x3bca386c,0x33873aa8,0x200d27fe,
0x25a81f65,0x37922dbc,0x4b294267,0x5beb52c7,0x66f1632d,0x6bd46966,0x67ce6b5f,0x60d662fe,
0x5ba160cb,0x45cf5212,0x28f33785,0x08bf19e7,0xe93ff73b,0xd2ddde94,0xbc62c5fa,0xba04b82e,
0xb1bdb958,0xa623abd1,0xa72da234,0x9cfca78e,0x8c6b9240,0xa110923d,0xaf99a9a2,0xb4f3b46d,
0xb70bb738,0xb762b6a3,0xc741be71,0xe885d47d,0x00bbf844,0x098405cd,0x186d0dee,0x2c9f2636,
0x2f0c2d07,0x22162a5c,0x19a31bd5,0x1ef31d12,0x25581f88,0x34f52e96,0x4e9a3f37,0x6c325e99,
0x69da6dd2,0x6dec6af9,0x6a8e6b2f,0x68416c9c,0x563d5f08,0x41194caf,0x1e433229,0xfd240cd8,
0xdb51eaab,0xc763cf35,0xc1bfc42b,0xbf14bf48,0xb5fcbd6e,0xa8daad3b,0xb140aea1,0xaaeea9b6,
0xbb33b74d,0xb3dab538,0xc14cba58,0xc515c596,0xc8aac495,0xd9c6cf3c,0xe82ee32c,0xf4c4eea6,
0xf836f638,0x0393fe4d,0x132e0a18,0x197c1855,0x14c21808,0x018e0c6e,0xfcd0fb28,0x07df0245,
0x248e1369,0x3f98333d,0x553c4c8e,0x5fc95ba5,0x68a9639d,0x65d16809,0x5bf962b6,0x5196561d,
0x3eea4916,0x26ec347d,0x0efe1ab6,0xee65ff34,0xd96ae1f9,0xd0e3d476,0xc0edc973,0xb847bb22,
0xb143b550,0xae0cae89,0xb4aaafb9,0xb989ba95,0xb0c5b289,0xbaafb4d5,0xc284bfe1,0xc9a1c483,
0xdd46d265,0xf165e7c5,0x089cfd37,0x10630e82,0x199f13fe,0x26a91fcb,0x2fdf2c93,0x2cc33009,
0x205c2747,0x14611a22,0x1188112f,0x1bee1603,0x240f1f78,0x3f9f2f78,0x55aa4d35,0x52e7569a,
0x4cd74f99,0x45604916,0x38cd402f,0x2aaa30fd,0x1e65251c,0x01f613fe,0xdfb5ee25,0xce2ed5f6,
0xc37dc818,0xbc67bf7c,0xb9aebbc3,0xaf96b40f,0xae98ae6c,0xb4c2b13a,0xb5deb659,0xb4afb4b8,
0xbc45b792,0xc7e7c22d,0xd463cd23,0xe1f0db47,0xf30ce9e2,0x031efcc6,0x0f63087e,0x1f83177f,
0x2b812609,0x391d31e9,0x3c063dfd,0x329835c2,0x2d263055,0x2aab2a4f,0x293d2aae,0x30602a77,
0x430e3986,0x4c644972,0x4c954d69,0x48094abd,0x3fe94448,0x32d138e2,0x27882e02,0x191d2098,
0x05d51002,0xf0fffb60,0xdccce638,0xccb2d490,0xbf32c5b2,0xafa4b8fc,0xa330a67c,0xa243a294,
0xa2e5a245,0xa4a1a3da,0xaa07a6bf,0xb1a8adc4,0xbb13b638,0xc5d3c00d,0xd287cb42,0xe3d6daa1,
0xf6c8ecf7,0x0c8a029b,0x17bd127d,0x25191de5,0x31732b3b,0x3c843780,0x3cff3e06,0x38c43b08,
0x331f361c,0x32c03171,0x3a653653,0x49cc40d8,0x5829520e,0x60405c16,0x62ea636e,0x55d15eb6,
0x416b4ac3,0x35363b24,0x281a2e34,0x12861fbd,0xf46f02fa,0xdb3ce74e,0xc5cccfef,0xb95dbd7e,
0xb407b6fa,0xab6fb0b5,0x9e8fa4a5,0x97579995,0x957596d2,0x94b49404,0x9cfc96fc,0xaaf8a4e5,
0xb532af8f,0xc0ecbaf8,0xd064c7bf,0xe85ddc30,0x0243f492,0x19cd0f77,0x28f021f1,0x33ab2e27,
0x40e03a5d,0x443743dd,0x44cd44d2,0x43e94478,0x40a142f2,0x3eaf3ec0,0x4a91433a,0x58985264,
0x65195ed3,0x64f167dd,0x58f35fce,0x457d4f98,0x372b3dc4,0x28592fee,0x13de1fee,0xf9ad0619,
0xe4e3ef95,0xd0ead9f8,0xc1e2c8b7,0xb885bd1e,0xacd8b296,0x9f2da5c2,0x98699ac1,0x972096fa,
0x94d4965f,0x9a2a959f,0xa5c49fc5,0xb426ac9e,0xbf7eb98f,0xcc8fc53f,0xdd48d4b0,0xf3fbe72f,
0x0ccb01bb,0x17ad1392,0x26e41e6f,0x2e4a2c1a,0x30ea3012,0x36a6327c,0x3f0a3b77,0x3e283ff2,
0x3eca3caf,0x4a1c440e,0x57ad5064,0x63c95e40,0x65b66643,0x5bd06234,0x50a05576,0x470a4c34,
0x37933fd8,0x28a52fe4,0x14d12077,0xfb6307ef,0xe325ef3a,0xd3bad988,0xc92acec4,0xbd5ec34a,
0xabeeb597,0x9eeea4a0,0x9a2b9bdf,0x9619987c,0x937a931e,0x9a0795f6,0xa697a051,0xb1b5abb9,
0xbb8ab6df,0xcaf8c2a2,0xe241d58c,0xf716edcb,0x0a6bfff5,0x1a3c1342,0x237c209c,0x28ae2519,
0x32a82df3,0x383c3558,0x36f23927,0x32aa3422,0x3a49347e,0x4ae941ce,0x5ce95541,0x637a61d2,
0x5ec361db,0x560b5a93,0x52485340,0x4d205119,0x3c6e4572,0x2ab133ab,0x15d8203d,0x01110bc0,
0xf29bf88e,0xe326ebb6,0xd0a5da3d,0xbd55c6eb,0xadefb48e,0xa131a75b,0x94579b57,0x8c018f13,
0x8df18b33,0x957d9221,0x9c6c98db,0xa3989fba,0xb118a91c,0xcb2fbcf7,0xe170d7d9,0xf4c1eabb,
0x0b1d0049,0x19db12f7,0x255f201b,0x32b62b01,0x3cf63a01,0x3de23cd2,0x430e409d,0x46904492,
0x543a4c17,0x62775bae,0x684e669f,0x632e6741,0x59ad5e61,0x4fe354e4,0x41c5499f,0x30e238e6,
0x20ee2983,0x0f9c1797,0xfecd0718,0xf126f7bd,0xe4d6eafb,0xd70ede3c,0xc477ce19,0xb47fbb6a,
0xab23af02,0xa1bba765,0x97689b76,0x961c95a3,0x9af1985d,0xa1b49de3,0xaad5a66a,0xb4cdaf23,
0xc778bd58,0xdc60d164,0xf368e811,0x0b19ff5b,0x1cd3155d,0x26c0224a,0x31222c2c,0x349c3317,
0x3a3637c0,0x3c933c06,0x3ddf3be0,0x49e84340,0x55394fc3,0x5cf35a92,0x589b5b44,0x55c856b0,
0x51c154cb,0x47314cf1,0x36f53fda,0x24162dba,0x13671b43,0x05cb0cb5,0xfa0dff63,0xef5ef50c,
0xdd87e804,0xc620d135,0xb4b7bce0,0xab04ae8b,0xa390a76b,0x99089e93,0x950895d0,0x9672951e,
0x9db39a0a,0xa621a0e9,0xb258ac6f,0xc023b8da,0xd3cbc912,0xe85ede80,0xfe68f2f9,0x146f09e5,
0x26561de6,0x31df2d58,0x39f935aa,0x3ef93d3a,0x40b63fd0,0x4253413a,0x4a6e45b2,0x52414e9b,
0x5b4b56bb,0x62825f38,0x618463ca,0x59df5d4e,0x51c156d4,0x406b4aef,0x2ce335d2,0x1a4f232f,
0x0c21132b,0xfcd9046d,0xed38f516,0xdb07e418,0xca87d35d,0xb674c04a,0xa98baebd,0xa21ba54a,
0x9ccd9f25,0x9a349bbb,0x98109873,0x9bba9983,0xa2609e90,0xab00a672,0xb816b054,0xc9bbc176,
0xdcadd23d,0xf209e740,0x0940fd9d,0x1e9414e6,0x2bda256c,0x38033282,0x3c953b45,0x3dfa3d81,
0x3dd33da4,0x40603e42,0x46ba43a0,0x4f944a6d,0x58c9553e,0x55e5582f,0x561d55f8,0x50b1549d,
0x47354c22,0x359b3fda,0x238a2bce,0x15751c34,0x09d30f5b,0xfc1b036f,0xef4ff53a,0xde63e7f4,
0xcc68d512,0xbc71c3ee,0xb343b6eb,0xabcfaf38,0xa889aa19,0xa5d6a723,0xa7e4a5ff,0xadc4aacc,
0xaf60af03,0xb3dab0a0,0xc1dcb9e0,0xd617cbca,0xe6bdde8f,0xf9bdf026,0x0c9502f8,0x1a4b14e1,
0x25721eae,0x31502cce,0x2f5d31c1,0x2a0e2c3c,0x2a272a13,0x2c6d2a99,0x33fc2fe9,0x3f9a3948,
0x4670447d,0x432544f3,0x43654300,0x3fb042b6,0x35a93a85,0x2e1231b3,0x256e2a84,0x187e1f80,
0x0c191172,0x03eb07e3,0xf8abfec9,0xe8d6f192,0xd81be027,0xce45d250,0xc508c9fc,0xbd34c08f,
0xb769b9fc,0xb8f6b71f,0xbcdfbba4,0xb815bab0,0xb6f1b637,0xc213bb50,0xd00ac8bc,0xe316d953,
0xf663ed5b,0x0462fded,0x0d2608ee,0x162011a0,0x1cef19fd,0x20e21f60,0x228e219f,0x1e47215e,
0x1bf51bea,0x22941e7c,0x2e8b27fb,0x37a334cf,0x37aa377a,0x38a238cd,0x344e3702,0x2d4230c2,
0x27e029cb,0x23e326c3,0x19cd1eff,0x124815ba,0x0be70f17,0x02dd087f,0xf14cfa63,0xe34ce92a,
0xda6ddf01,0xd398d64d,0xcd19d12b,0xc1efc726,0xbeb1bf5b,0xc1bcbfe7,0xc0dfc1fb,0xc0bec00f,
0xc5dac239,0xd3bacb97,0xe4a7dd0a,0xf3c8ebbe,0x02d6fc24,0x0e140880,0x17181330,0x1dc01ac2,
0x1e141e8e,0x1ba81ce9,0x19c11a41,0x1b061a67,0x1d5f1b3c,0x294a22e8,0x30202dcf,0x348f3215,
0x37fe36ff,0x364b37aa,0x2fe433a1,0x277e2b67,0x222e2508,0x179e1d7e,0x0b131155,0x02a0064a,
0xfafffecb,0xf0bff6a9,0xe203e994,0xd815dbe5,0xd0ffd4e8,0xc91bcd06,0xc17fc4e5,0xbda0bed2,
0xc03bbec7,0xc1c9c11a,0xbf33c0d2,0xc2a5beea,0xd0f5c982,0xe18fd8f4,0xf2feea23,0x0493fc48,
0x10470b20,0x19211473,0x23311e57,0x282f269f,0x27ac2886,0x27b52704,0x28bf2878,0x2b6829a1,
0x300c2dcc,0x345b3260,0x36273582,0x37133688,0x32ba35a2,0x2a5b2eff,0x202524df,0x1b801d88,
0x13bd183e,0x08f30e36,0x00a20446,0xfa7efdb0,0xeee7f5ec,0xe22be7d1,0xd9b1ddda,0xd19ed533,
0xc89bcddf,0xbf7cc388,0xba9abc25,0xbe2abb96,0xbf8cbfe0,0xbd41be10,0xbfaabda9,0xc80dc2c1,
0xd8ddd003,0xebbce1ed,0xfe47f5b7,0x0a9904a5,0x190b11c4,0x24581f24,0x2a0227ef,0x2a942a50,
0x2d282bce,0x2e492e26,0x2e132e78,0x2e5b2dcf,0x30cd2f65,0x35f03360,0x381b3782,0x35d83757,
0x2fec3350,0x277d2bef,0x20d423f5,0x173d1c59,0x0e30128f,0x07160a7e,0xff6b036b,0xf597fadb,
0xec4cf07f,0xe1f5e7f5,0xd554db34,0xcd69d145,0xc4fec957,0xbdaac06d,0xbe1abd93,0xbdb0bdf1,
0xbcbbbd5e,0xbbbabbfe,0xbe92bc7a,0xca47c2f9,0xdc64d31d,0xef0ee5dd,0xfeb4f76a,0x0b3b04ee,
0x19611257,0x22811ef2,0x2869258f,0x2ba32a34,0x2d2f2cd6,0x2c412cfa,0x2d412bee,0x317f2f60,
0x34ff3369,0x37f93662,0x37703837,0x330935e4,0x2cd62f96,0x26922a40,0x1d7d2269,0x13ec1897,
0x0a890efb,0x03eb06e3,0xfc9800b5,0xf2dbf86a,0xe6bbec6d,0xdd8fe1c1,0xd667da01,0xceead2e5,
0xc6e7ca5e,0xc561c584,0xc655c626,0xc458c5b6,0xc116c2bf,0xbf67bf7c,0xc814c260,0xd836cfb1,
0xe84ae087,0xf443eebe,0x00e0fa2f,0x0db00788,0x17871346,0x1cde1a37,0x22a51fe3,0x263f2492,
0x27a027d7,0x25632649,0x277125df,0x2af92982,0x2e342c0a,0x3208308c,0x30ca321d,0x2c782eee,
0x29a22ab8,0x22e826ed,0x1c0b1f02,0x14ea1919,0x0bdd103b,0x0291070c,0xfbcdff72,0xf040f674,
0xe5f4ea83,0xde82e237,0xd60bda57,0xcf63d227,0xccf8cdcf,0xcc76ccf2,0xc927caec,0xc458c726,
0xc12cc202,0xc56ec21d,0xd315cb93,0xe17eda62,0xee26e7c7,0xfcd3f597,0x0b000466,0x12920f40,
0x176c154a,0x1b8f195a,0x1fee1dec,0x23012193,0x23be23d7,0x241523b3,0x263424ac,0x2b4228d8,
0x2d972ce8,0x2df12d89,0x2cbb2dc3,0x29702b4b,0x22b3269c,0x1c0f1eda,0x172b19ee,0x106013dd,
0x0af90d6d,0x029207a3,0xf4e2fbfd,0xe96bee7c,0xe1bae54e,0xd9ccdde0,0xd259d5b2,0xcf32d040,
0xcf97cf23,0xce96cf8d,0xcbe2cd80,0xc7b3c99c,0xc881c728,0xd04ecbe7,0xdb8fd5ba,0xe707e12d,
0xf535edc4,0x03b6fcae,0x0d680971,0x132c107e,0x18571550,0x1c1e1b1a,0x1d1c1c86,0x200f1e59,
0x23c32202,0x253724f9,0x250624d9,0x282d2638,0x2b672a39,0x2bb92bcc,0x29232b08,0x22c22604,
0x1d352000,0x173619e7,0x123c14a9,0x0de61025,0x068b0af1,0xf9970040,0xee62f394,0xe5aeea0b,
0xdd29e145,0xd6e9d9b5,0xd38fd47b,0xd5c7d456,0xd5c5d648,0xd1a0d428,0xcc90ceea,0xcd6ecbe6,
0xd443d087,0xdb0cd797,0xe3aedeee,0xefb7e92f,0xff1df75b,0x0b770625,0x11e40f3a,0x162813df,
0x190817b7,0x1d6b1af9,0x21011f97,0x21d621c0,0x20a02184,0x1ebb1f6f,0x21721f43,0x272d24b1,
0x27692802,0x239325be,0x1f60216f,0x1b211d3b,0x16ce1924,0x11a71402,0x0e3a0fdd,0x09990c7d,
0xff7004f1,0xf42af9bf,0xe773edfb,0xddc7e20b,0xd702da31,0xd381d47e,0xd3e1d373,0xd55fd4df,
0xd2aed48e,0xd03fd113,0xd111d00f,0xd63cd342,0xdc88d946,0xe524e091,0xf0d3ea47,0x019ff919,
0x0e7a0915,0x147d1218,0x18031632,0x1be41a1a,0x1edb1d95,0x1fd81f7b,0x20312045,0x1f731fd3,
0x1d5e1e68,0x1de01d29,0x21201f3a,0x229f22a2,0x1e7220e1,0x18da1ba6,0x15a416c6,0x12c6145f,
0x1096119b,0x0fde0ff7,0x0c970f0b,0x03920888,0xf830fdea,0xef56f35f,0xe6eeeb49,0xde87e27e,
0xd7fadaea,0xd605d645,0xd769d6b5,0xd5b2d72b,0xd152d374,0xd0c6d06e,0xd447d218,0xd96ad6e1,
0xe05adc87,0xe95de476,0xf6b8efa5,0x0341fd43,0x0d0708c9,0x110c0f99,0x140b1237,0x19b616c3,
0x1fb81ccf,0x23f42259,0x237d241d,0x21aa2282,0x22322156,0x27af24e9,0x29492930,0x2516278b,
0x202922b5,0x1a781d6d,0x16e71828,0x13e115d4,0x0ed21123,0x0b110cf5,0x04be088e,0xfa5fff9d,
0xf03ef556,0xe6fbeb58,0xde5ce2d0,0xd59fd99f,0xd33dd3b2,0xd41bd38d,0xd45dd46b,0xd2aed386,
0xd16dd1ff,0xd30dd185,0xd945d5e6,0xe01ddcbf,0xe8fde412,0xf5caef0c,0x01e8fc7e,0x08a005a7,
0x0df40b65,0x11d10fe3,0x159413c6,0x19b81781,0x1d571bf0,0x1f0e1e1e,0x212b200f,0x23b92295,
0x2531248e,0x262825a1,0x24de2634,0x2082229d,0x1bd01e76,0x182d19cd,0x142b1660,0x10c211f0,
0x0f831081,0x0b000d81,0x02f707ab,0xf7f9fd68,0xeea0f300,0xe588ea3e,0xdb48e048,0xd5efd7b4,
0xd681d5d0,0xd850d78c,0xd696d7e0,0xd39dd4eb,0xd529d3ad,0xdaa2d79c,0xe171dde8,0xe8ede50c,
0xf170ed0e,0xfa26f5ea,0x0174fe0a,0x060503f6,0x0aa0084b,0x0dac0c70,0x10900edf,0x150412e6,
0x19491746,0x1bf11ac6,0x1d311c88,0x20f11e88,0x25f623b9,0x27502734,0x24df2695,0x208a22a8,
0x1c761eac,0x180519f9,0x148e1656,0x11a312e6,0x0dca1026,0x06a80aa3,0xfd860205,0xf50df95b,
0xebb3f063,0xe16fe6a5,0xd981dce4,0xd6f7d77f,0xd8fed7c5,0xd844d93c,0xd549d6c1,0xd5acd4ae,
0xda59d7cf,0xdfc6dd03,0xe64ee2e2,0xee98ea1f,0xf7fbf363,0xffa9fc18,0x051702a6,0x09250738,
0x0b740a63,0x0e080cc5,0x10640f5d,0x12811118,0x172e14cb,0x1a3718e4,0x1d3e1bc9,0x20001eb1,
0x20602093,0x1f0a1fc0,0x1e711e99,0x1ca31df9,0x18cd1ac3,0x15741703,0x1353141f,0x11f612e8,
0x0c850fee,0x02de07f4,0xfa0efe2e,0xf1d4f5f7,0xe8ceed74,0xdf5ee3c9,0xdad8dc57,0xdac5daad,
0xda27dab8,0xd81fd915,0xd7ebd78b,0xdd13d9f5,0xe21cdfe1,0xe59fe415,0xea8be759,0xf325eeb9,
0xfc2af7a6,0x0434007b,0x0a440769,0x0c930be4,0x0ddd0d52,0x0e2d0ddd,0x11130f53,0x15981316,
0x194817b6,0x1b891a6e,0x1db51ca8,0x1f9a1e87,0x20142079,0x1df71f14,0x1a751c63,0x1610187b,
0x10df1360,0x0cb00ea2,0x0a6c0b4b,0x08160981,0x039e0634,0xfd12006b,0xf5faf9c6,0xed2df1cb,
0xe452e874,0xde8ae0f9,0xdc7fdd1e,0xdb5bdc17,0xda38da82,0xdc84da97,0xe24ddf92,0xe643e48b,
0xe941e7ac,0xeccbeace,0xf344efcc,0xfa6cf6d7,0x0116fdc2,0x07ff0496,0x0d390af9,0x0f250e95,
0x0ef00f39,0x0ee30ed0,0x0fb10f1c,0x123310a9,0x167d1442,0x19a5185c,0x1ad21a75,0x1a5d1acc,
0x1a191a0f,0x18d019d1,0x158b175e,0x10871337,0x0d000e48,0x0d810cd8,0x0dd40e19,0x09840c21,
0x025e060b,0xfb6cff0a,0xf2c7f76a,0xe949edee,0xe2a2e568,0xdf1ce0aa,0xdcbdddaa,0xdc7fdc83,
0xde25dcd5,0xe20ae000,0xe639e43b,0xe8d5e7c1,0xeb47e9ea,0xf05ced7d,0xf541f2e9,0xfb0ef7e0,
0x020dfe89,0x086d0585,0x0a9609f2,0x0ae80aed,0x09ad0a6c,0x0a2e095f,0x0f340c4b,0x166912de,
0x1aee191a,0x1c361bac,0x1bc51c59,0x1a671b25,0x192f19aa,0x180318d7,0x14fe16b6,0x12001352,
0x0fc510da,0x0e840f09,0x0b160d5b,0x0540081a,0xfe79022f,0xf69afa91,0xee13f244,0xe63cea1d,
0xe0cce2f4,0xdebedfa2,0xde31de2e,0xdf17de9c,0xe0e5dfce,0xe455e286,0xe739e5e1,0xea93e8b1,
0xef1eece9,0xf386f126,0xf979f64b,0x0082fd0f,0x0615037c,0x09e0083c,0x09300a1b,0x06c607de,
0x06fc0666,0x0b0b0896,0x11b40e43,0x177714e9,0x19ae18f7,0x1a0b19f9,0x1a301a23,0x18dc19c7,
0x172b17ea,0x158f1651,0x140c14e7,0x112412a1,0x0e880ffb,0x0b600cd2,0x082409f6,0x0394060f,
0xfc5a003d,0xf402f84b,0xead5ef51,0xe3cbe6eb,0xe0dae1c1,0xe0d9e0ba,0xe15ee106,0xe2e8e1f4,
0xe610e45d,0xe897e77d,0xeb40e9af,0xef94ed6b,0xf31ff178,0xf6f1f4ef,0xfbd7f945,0x0143fea5,
0x0535035e,0x074e0698,0x07420788,0x067606bb,0x083206dc,0x0def0a89,0x14f11195,0x18961779,
0x194218fc,0x18f61929,0x1704183a,0x14f215d8,0x137e144f,0x11b11274,0x1060111b,0x0df50f62,
0x0a690c2f,0x07d00919,0x038405f0,0xff040131,0xf8e0fc55,0xf06ef4bd,0xe952ec7f,0xe54be709,
0xe388e42d,0xe39de35b,0xe477e3fa,0xe573e4f5,0xe727e628,0xea1de866,0xee50ec3d,0xf1a5f02a,
0xf4f2f315,0xfa4ef763,0x0035fd5b,0x049e02c8,0x068a05b8,0x07d8074a,0x08230815,0x0899082a,
0x0bd709c8,0x11b30eac,0x164e1461,0x18c517b4,0x1981195b,0x1853192a,0x163a174f,0x13d61504,
0x1283130e,0x10ce11e0,0x0e9b0fb1,0x0baf0d42,0x080709ec,0x048d065c,0x008a02a8,0xfaa3fdcd,
0xf3b2f746,0xecadf01e,0xe5f2e930,0xe208e397,0xe176e17e,0xe221e190,0xe47ce336,0xe6d9e5ad,
0xe98ee82c,0xecd7eb0d,0xf083eea1,0xf4baf298,0xf933f6ed,0xfe0bfb92,0x0215003e,0x051803cf,
0x06a105f3,0x070f0707,0x074a0711,0x0a1f0836,0x0f870cb0,0x151a1262,0x19a1178f,0x1c221b3d,
0x1bf11c61,0x19b51afe,0x16f71848,0x153f1604,0x13541458,0x1073121b,0x0c5c0e5c,0x08c90a93,
0x04fd06e7,0x0181034c,0xfc46ff24,0xf567f90b,0xed3ef15f,0xe5c8e93f,0xe119e31b,0xe001dffd,
0xe223e0d9,0xe48be367,0xe68ee5b0,0xe8c3e762,0xebb6ea49,0xeeb9ecfc,0xf348f0e8,0xf80df59d,
0xfce4fa87,0x006bfee3,0x02970194,0x042f0376,0x050e04b1,0x05c30577,0x063005bb,0x09890782,
0x0fd50c6d,0x15ce132b,0x198517d9,0x1b3a1aaa,0x1a661b1d,0x17ed1936,0x16a21717,0x1611165d,
0x13fd1553,0x1102128d,0x0d390f3d,0x09b70b4b,0x0764088e,0x032905a9,0xfcb70023,0xf481f8bc,
0xeb7ef019,0xe3eae74c,0xe074e19a,0xe0dae045,0xe315e1ea,0xe4c0e41b,0xe6d5e589,0xe929e830,
0xeb98ea57,0xee83ecdd,0xf29df074,0xf7b3f517,0xfc87fa2d,0x0035fe95,0x028f018d,0x03d70355,
0x03bb0415,0x037a0357,0x05b4043d,0x0b880826,0x12a50f57,0x17241539,0x18dd1862,0x18a918ee,
0x174617fb,0x164b1699,0x1658164e,0x15d9164b,0x1441150c,0x11bf133d,0x0f50104a,0x0d6b0e84,
0x09910bc8,0x03090691,0xfb63ff56,0xf306f750,0xeb30eed8,0xe63de831,0xe449e504,0xe430e41c,
0xe4cbe461,0xe628e569,0xe7bce702,0xe8f8e83a,0xeb99ea22,0xeee4ed33,0xf31bf0ee,0xf775f53d,
0xfbb9f9a7,0xff1afd9c,0x0124002e,0x01e201be,0x00dc0187,0x01de00ca,0x07360427,0x0dbc0a7f,
0x134010c4,0x1696152b,0x177b1765,0x168e1718,0x152415e0,0x144614a9,0x136a13c6,0x129b1327,
0x10d811c3,0x0f570ff9,0x0eef0f1e,0x0cf00e58,0x08040ad0,0x00f404a4,0xf8f4fd22,0xf050f481,
0xea4fecc6,0xe823e8e2,0xe80fe7fc,0xe803e810,0xe870e818,0xe96be8e0,0xeb1fea18,0xee01ec88,
0xf05eef36,0xf32df1a6,0xf71bf506,0xfaf3f917,0xfe72fcc0,0x015c0012,0x019b01e0,0x004a0102,
0xff99ffa0,0x02270072,0x07500489,0x0d370a53,0x116c0f9b,0x137712b2,0x136e1395,0x124c1303,
0x10ac1179,0x0fee1037,0x0f090f82,0x0e4a0ea1,0x0e260e12,0x0ec20e72,0x0e510ec9,0x0b670d47,
0x05ba08d8,0xfd5a01c9,0xf532f905,0xefc8f22e,0xecd7edf4,0xebc4ec26,0xebbaeba7,0xecf7ec46,
0xedd4ed86,0xee75ee13,0xef78eede,0xf11cf039,0xf386f239,0xf62ff4d0,0xf93bf7aa,0xfc73fae0,
0xff5cfdfe,0x011f0070,0x007f0127,0xfe51ff53,0xff3bfe4a,0x02f500cf,0x08e705b9,0x0f010c30,
0x120110ef,0x12f8128f,0x13011327,0x11711266,0x0fa21079,0x0e9b0f07,0x0dc20e38,0x0d6f0d6d,
0x0dac0d94,0x0d2d0db1,0x0a2c0bfe,0x052307d9,0xfe5f0207,0xf66efa3e,0xf0acf33f,0xec94ee74,
0xea6aeb45,0xea72ea2b,0xebb8eb01,0xed46ec87,0xee42edc7,0xef92eebf,0xf269f0e5,0xf550f3df,
0xf83ef6af,0xfbf7fa1c,0xff0afda1,0x01800044,0x03340292,0x02b10349,0x0088019f,0xffaeffd2,
0x01dd0059,0x07180424,0x0ca50a13,0x10430ecd,0x116e110e,0x117a118d,0x10231101,0x0e220f09,
0x0d0e0d82,0x0ca90cce,0x0c760c7a,0x0c7c0c85,0x0c100c4c,0x0aac0ba3,0x06f00913,0x01020439,
0xf98dfd5b,0xf35ff61f,0xef6df13f,0xeca6ede9,0xeb10ebbc,0xeb0eeab9,0xec6eebc0,0xed88ecf7,
0xeee2ee1b,0xf114eff8,0xf336f21c,0xf68df4ab,0xfa94f898,0xfe07fc59,0x00f7ff92,0x03930265,
0x03fa0439,0x02780342,0x00e601a0,0x015a00c4,0x04ce02b9,0x09ae0743,0x0d7d0bbf,0x0fa50eb4,
0x10fe1076,0x10db1126,0x0f0b101f,0x0d120df6,0x0c400c7c,0x0c740c48,0x0cd50ca9,0x0ca90ce2,
0x0a8b0bec,0x06dd08df,0x01ed048f,0xfb81fec9,0xf572f850,0xf15af330,0xeee2efeb,0xeda7ee1d,
0xed90ed82,0xee06edc1,0xee7aee4c,0xeef3eea5,0xf04fef79,0xf24af148,0xf4bbf367,0xf7faf63a,
0xfbe5f9e7,0xff6cfdcb,0x023900e4,0x03a00320,0x032603a0,0x01920257,0x00d40104,0x02930155,
0x06a5046d,0x0ae208d9,0x0e2b0cad,0x10520f72,0x103e1083,0x0eee0fb5,0x0d330e02,0x0c7a0c9c,
0x0cc30ca4,0x0cce0cdd,0x0c980cb6,0x0bda0c51,0x09850b02,0x05600791,0x00470301,0xfa68fd4b,
0xf5a0f7cb,0xf29cf3e5,0xf119f1b9,0xefbff074,0xeeb6ef1b,0xeeddeeb8,0xef4eef19,0xef9eef6d,
0xf076efee,0xf213f12c,0xf502f367,0xf80ff69e,0xfb58f987,0xff53fd71,0x01d500c2,0x02580270,
0x00f501ad,0xffc0005a,0x0008ff79,0x03c30194,0x08860631,0x0c870aa0,0x0f0d0e0b,0x0fc30fa5,
0x0eef0f6e,0x0db00e4d,0x0cfc0d40,0x0c7c0cc2,0x0c260c4f,0x0bb70be6,0x0b410b8d,0x093a0a89,
0x05620772,0x011f033c,0xfc93fee7,0xf7cbfa2f,0xf44af5c6,0xf24ef335,0xf09df16e,0xefc3f000,
0xeff1efdd,0xf026f003,0xf0c8f062,0xf21df14e,0xf443f31f,0xf69ff575,0xf939f7cf,0xfc82fad2,
0xffc9fe39,0x02230104,0x02f802e3,0x020402af,0x000d0106,0xff48ff6e,0x00f8ffcf,0x04e702b2,
0x095e0734,0x0cd10b4f,0x0e1e0dc6,0x0e180e27,0x0dc00dfa,0x0d210d85,0x0c1d0c95,0x0b8b0bcf,
0x0af90b44,0x0a3c0a90,0x097f09f7,0x079b08b7,0x0408060d,0xff5101a9,0xfb0bfd15,0xf78ef92a,
0xf51cf63c,0xf356f42f,0xf1cdf285,0xf126f156,0xf163f12c,0xf1daf1a2,0xf257f211,0xf2f7f296,
0xf4e9f3bc,0xf784f632,0xfad2f915,0xfd9dfc5b,0xffc7fec9,0x0132008f,0x01290178,0xff780075,
0xfdeefe86,0xfe9bfde7,0x02010014,0x06840436,0x0a5908a9,0x0c800ba1,0x0da70d1c,0x0eca0e42,
0x0e9f0ef5,0x0ced0dd8,0x0b390c05,0x0a770abc,0x0a080a3d,0x097d09d9,0x079808bd,0x04670615,
0x00d002ad,0xfd5cff0b,0xfa05fba7,0xf76bf8a0,0xf528f645,0xf348f437,0xf1fef281,0xf15ff19d,
0xf168f145,0xf205f1a4,0xf32af28b,0xf4a8f3e2,0xf703f5aa,0xf9fdf87c,0xfcf1fb84,0xff9dfe44,
0x021000ee,0x031102e0,0x0162027e,0xff27002a,0xfee6feb5,0x0100ffb7,0x04240282,0x07cc05e0,
0x0ace0985,0x0c790bc9,0x0d0a0ce3,0x0c910cf0,0x0b370bec,0x0a1d0aa0,0x094909b8,0x084508be,
0x07e10806,0x079207bb,0x060d0714,0x033904ae,0x002a01bc,0xfcf4fe91,0xf9d6fb4e,0xf77af8a1,
0xf58ef66f,0xf462f4d5,0xf3a1f404,0xf2c4f337,0xf253f266,0xf2f1f292,0xf3faf366,0xf5baf4b8,
0xf82af6da,0xfb0df9a0,0xfdd4fc6c,0x0053ff29,0x01a90132,0x014c01a6,0xffef00ab,0xfeedff48,
0xff9eff0c,0x022e00b1,0x05e80400,0x08fb079f,0x0af60a1c,0x0bea0b8b,0x0bdc0c0b,0x0ac60b67,
0x09680a11,0x082908c4,0x075807ac,0x06c3070d,0x06610699,0x05ab0617,0x040504f2,0x019a02e6,
0xfea10022,0xfbd4fd2b,0xf998fab4,0xf808f8ae,0xf74af79b,0xf697f6ff,0xf5caf61e,0xf583f58a,
0xf57bf580,0xf5e9f596,0xf6cdf64d,0xf87df797,0xfa9cf97d,0xfcc9fbbd,0xfefdfde3,0x00e6000c,
0x01850179,0x005a011a,0xfe7aff5a,0xfe1cfe07,0xffb7feb5,0x029600fe,0x05fa0440,0x08d10787,
0x0a6509c7,0x0ae20acd,0x0a470aa4,0x097a09e6,0x084e08fe,0x0714079f,0x06a106be,0x065d067a,
0x05f4063a,0x04ca058d,0x02c303d6,0x00270180,0xfd89fed0,0xfb3bfc4e,0xf98cfa5a,0xf82cf8bb,
0xf75af7c9,0xf660f6df,0xf5bdf5f5,0xf5aef5b3,0xf59ef597,0xf5e2f5c3,0xf6daf62b,0xf8eef7cf,
0xfb78fa28,0xfdfffcc7,0x0064ff30,0x02040165,0x01b8021c,0xffda00e2,0xfea3ff10,0xff0bfe9f,
0x00fbffd9,0x03c60249,0x06dc0559,0x095e0844,0x0a7c0a12,0x0a8a0aa9,0x09d10a46,0x0885093a,
0x06df07af,0x05c40633,0x0567058d,0x05690553,0x053a056e,0x038f0493,0x00ec0247,0xfe62ffa5,
0xfbe1fd20,0xfa00fad6,0xf896f93f,0xf791f808,0xf698f70d,0xf5f0f62e,0xf635f5fc,0xf6a9f67c,
0xf746f6e7,0xf84df7bd,0xfa0df90d,0xfc85fb33,0xff37fdec,0x017a006c,0x02c50247,0x029302d3,
0x015d021f,0xffb7007d,0xff03ff34,0xffb8ff2f,0x01ae0096,0x047a02f5,0x071505ee,0x089507fb,
0x092b08fd,0x08f3092e,0x078c0857,0x05b806a6,0x045f04e8,0x04140422,0x044c042a,0x046e046e,
0x039d042b,0x020902ea,0x0015010c,0xfdd5feff,0xfbb5fcba,0xf9fffac7,0xf8e0f95c,0xf849f890,
0xf7aaf7f9,0xf748f772,0xf6f4f71a,0xf6fdf6e6,0xf782f735,0xf904f819,0xfb48fa23,0xfdcffc80,
0x0086ff2d,0x02a601b6,0x0343031d,0x02b10328,0x01570201,0x00b000de,0x00eb00bb,0x01d10148,
0x03650291,0x0587045e,0x07a006a0,0x08df0861,0x090a0920,0x07a2087c,0x056e069a,0x0336043c,
0x023c0284,0x02c30263,0x0377032c,0x0382038e,0x03240366,0x01c1029b,0xff8b00b0,0xfd21fe55,
0xfb36fc12,0xf9e8fa8a,0xf8e4f959,0xf7d0f85d,0xf701f75e,0xf67df6a6,0xf685f67c,0xf6fcf6a3,
0xf828f781,0xfa15f90d,0xfc93fb3d,0xff88fe13,0x01db00c9,0x02ea029a,0x02d402ea,0x024a02a6,
0x017201d4,0x00f60124,0x01660113,0x02c301f1,0x04d303b8,0x070f05f9,0x08c8080c,0x091a0929,
0x07ce08aa,0x05b406c2,0x039404a0,0x01c80291,0x0157015a,0x01f501a0,0x02600238,0x02a4028c,
0x02110280,0x001c013f,0xfda5fecb,0xfbf8fcc2,0xfa6cfb2b,0xf99bf9f4,0xf8f1f94d,0xf7fdf874,
0xf743f797,0xf748f721,0xf7e0f796,0xf894f837,0xf9acf8fd,0xfbbdfa9c,0xfe59fd00,0x00faffbc,
0x029b01f3,0x030f02ef,0x02d20306,0x023c028b,0x018301e0,0x019b016f,0x023101d6,0x03b302d4,
0x056a048e,0x075a065f,0x08870823,0x07da0861,0x06230719,0x03fb0512,0x020202ee,0x0120015e,
0x01a30144,0x02830213,0x032a02f0,0x02a1030b,0x011c01f5,0xff0b0026,0xfd3afe0a,0xfc20fc9d,
0xfb1bfba9,0xfa40fa93,0xf99ff9f7,0xf89cf922,0xf7f3f82e,0xf80ff7e7,0xf8cbf865,0xf9acf932,
0xfb1dfa56,0xfd4bfc1d,0xff4dfe62,0x00cf0026,0x016d0134,0x01670182,0x00f50135,0x005b00ab,
0xffe80009,0x0061000c,0x016c00db,0x034f0241,0x059c0470,0x076806ac,0x07c407bc,0x070e078e,
0x0558064e,0x035a0456,0x0217028b,0x020101ec,0x0312026e,0x040c03a4,0x04340443,0x032303cf,
0x01250237,0xff320014,0xfd6afe56,0xfba4fc77,0xfa6afaef,0xf96af9ee,0xf83ef8e3,0xf734f79f,
0xf727f70e,0xf7bff76a,0xf8bbf828,0xfa51f979,0xfc3dfb3b,0xfe5cfd59,0x0036ff4b,0x018b00fb,
0x022101e7,0x0267024d,0x020a0249,0x018301cb,0x013a014c,0x0156013a,0x024501ad,0x0452032c,
0x0647056c,0x073d06e2,0x0715074d,0x05f1069d,0x044e0526,0x02cc037a,0x02170251,0x02710225,
0x036b02ef,0x041e03d3,0x03db0431,0x02420329,0xfffe012c,0xfdc3fed2,0xfbdbfcc8,0xfa7cfb12,
0xf94df9ed,0xf823f8b2,0xf73cf7a0,0xf701f70a,0xf75df71f,0xf819f7b5,0xf97af8ab,0xfb7cfa75,
0xfd92fc88,0xff72fe92,0x00ed003a,0x02470192,0x036a02e7,0x03d903c1,0x034803ad,0x025502c8,
0x01a301ee,0x01e00194,0x03680287,0x05560468,0x06690604,0x0648067c,0x054f05d8,0x03fb04b8,
0x02350317,0x00eb016d,0x00e400c2,0x01de0153,0x02e3026a,0x03250325,0x025c02e3,0x00a901a2,
0xfe9fff9d,0xfcfafdbd,0xfbdafc59,0xfae1fb64,0xf9effa63,0xf91bf97d,0xf89cf8c5,0xf8d7f8aa,
0xf94af90c,0xfa0ef9a4,0xfb2efa90,0xfcacfbe2,0xfe52fd77,0xfff4ff29,0x016800af,0x02de0231,
0x03960356,0x03a103ab,0x02df0356,0x01e5025b,0x017c019b,0x023001a8,0x03e602f2,0x056a04c6,
0x060405d6,0x059a05ee,0x0480051d,0x032503d9,0x019c0257,0x00cf010c,0x016000f4,0x029601f6,
0x0336030c,0x02be0314,0x01590224,0xff360058,0xfd34fe1e,0xfbc8fc6e,0xfad8fb44,0xfa31fa84,
0xf96ef9d2,0xf912f930,0xf92bf912,0xf981f952,0xfa13f9c6,0xfaeefa7a,0xfbe0fb62,0xfd36fc7f,
0xfec3fdfd,0x0041ff79,0x01f1011f,0x036602bc,0x040a03dc,0x039e03f0,0x028c031e,0x01c0020a,
0x020101ba,0x03440293,0x049203f6,0x0568050f,0x05af059c,0x053a058f,0x040304b5,0x025a0331,
0x010b019a,0x00cc00cb,0x01710108,0x025a01f0,0x0279028a,0x01620217,0xff770080,0xfd57fe5d,
0xfbb8fc6f,0xfac9fb31,0xfa37fa78,0xf9dbfa03,0xf9adf9bd,0xf97df999,0xf96bf961,0xfa29f9b6,
0xfb35faaa,0xfc15fbad,0xfcf4fc80,0xfe11fd79,0xff8dfebf,0x01960087,0x037f02a0,0x04710421,
0x04320470,0x031303b4,0x01f90273,0x01b301b7,0x026d01f1,0x03ae030a,0x04c30445,0x05630523,
0x0569057a,0x04a80529,0x033403f6,0x02030293,0x015c0194,0x01a90167,0x02790210,0x02e902c5,
0x026502ce,0x00770193,0xfe3dff50,0xfc6efd48,0xfb62fbdb,0xfa86faf5,0xf9d5fa1e,0xf989f9a4,
0xf960f977,0xf943f94f,0xf95ff940,0xf9f4f9a2,0xfacdfa57,0xfbc5fb4e,0xfcb6fc3b,0xfddefd37,
0xffb8feb8,0x01dd00c7,0x03ad02e5,0x044a0425,0x0398040d,0x025b02fd,0x01b801ed,0x01e401b3,
0x02fa0256,0x044f03a0,0x055704e6,0x05ae059a,0x05650598,0x04bd0522,0x03ab043d,0x02ce0327,
0x02be02a9,0x033d02f5,0x03b70389,0x036d03b1,0x021c02e6,0x00070120,0xfdcafee8,0xfbeafcc6,
0xfab3fb38,0xf9eefa4a,0xf950f9a0,0xf8a8f8fa,0xf837f869,0xf7fff812,0xf870f81f,0xf965f8e2,
0xfa56f9e3,0xfb42fac3,0xfc8bfbdb,0xfe74fd68,0x00bbff99,0x02e601d7,0x047a03d1,0x04c304cf,
0x03ef046a,0x03230377,0x02fb02f5,0x039a0331,0x04be0424,0x06040567,0x06960669,0x0660068f,
0x05a6060f,0x04d50546,0x03af0447,0x02ad0323,0x0243025f,0x02810253,0x02a302a8,0x01d2025e,
0xffd900f7,0xfd57fe95,0xfb72fc49,0xfa46fac6,0xf9a7f9e7,0xf945f96c,0xf8daf919,0xf857f89b,
0xf812f822,0xf857f826,0xf924f8ae,0xf9e0f98f,0xfabdfa37,0xfc1dfb66,0xfddbfce7,0x000bfee6,
0x029e0151,0x04ce03d3,0x05da0581,0x057205d1,0x046104ec,0x03a103e5,0x03af038a,0x04740401,
0x058504f8,0x064e05ff,0x0660066f,0x05f10632,0x051c0596,0x03db0480,0x0284032d,0x018a01f9,
0x0175015e,0x01bb01a5,0x015301a2,0xfff300be,0xfe1aff0d,0xfc35fd1d,0xfabffb6a,0xf9e2fa43,
0xf990f9a4,0xf9a5f996,0xf98af9a1,0xf956f96d,0xf94ef94a,0xf9acf96b,0xfa7efa09,0xfb66fafd,
0xfc50fbd0,0xfd93fceb,0xff31fe4f,0x01360031,0x03440242,0x049c0417,0x049504be,0x03d10444,
0x02fc0360,0x02b102bc,0x032f02d2,0x043c03b2,0x054004c4,0x05f105ac,0x05fd0610,0x057105c4,
0x047e0502,0x035b03ee,0x025b02ca,0x0209021c,0x021f0217,0x01f00216,0x00fa0192,0xff3f002f,
0xfd12fe2c,0xfb12fc08,0xf9b4fa43,0xf94cf967,0xf952f947,0xf962f95e,0xf944f95e,0xf907f91c,
0xf93ef913,0xf9f3f98d,0xfabbfa5f,0xfb65fb11,0xfc61fbd0,0xfdd0fd0e,0xffd1febe,0x023300fb,
0x04300345,0x04fe04c7,0x049d04ea,0x03d40436,0x03440384,0x034c032d,0x041c03a4,0x0515049d,
0x05f9058f,0x06780646,0x064b067b,0x056805e5,0x042804ca,0x02f90388,0x0241028a,0x02310226,
0x02420248,0x01a3020a,0x003e0108,0xfe67ff62,0xfc4afd5c,0xfa83fb53,0xf991f9e8,0xf967f96b,
0xf97cf970,0xf96df97b,0xf92af951,0xf8e0f902,0xf910f8e2,0xf9cdf962,0xfabbfa43,0xfbbefb37,
0xfcd7fc42,0xfe81fd94,0x00d9ff9e,0x033c0219,0x04b20421,0x04ce04e5,0x0416047d,0x035c03ab,
0x031f0332,0x036d0334,0x043103c3,0x052804ae,0x05ee0597,0x06260619,0x05be0604,0x04d30554,
0x03cb044c,0x03180349,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_1_Pizzicato_PizzViolinC4[2304] = {
0x02770000,0x0b55063e,0x109c0f35,0x0d690fda,0x088109dd,0xfea10525,0xea5bf55e,0xec27e61c,
0xf843f547,0xebc1f337,0xeb4be81f,0xf9dcf398,0xf90ffa32,0xfe29faae,0x043a0215,0xf9d20247,
0xee37ef71,0xf351f35a,0xf0aff06b,0xfa47f6fb,0x0604fd7a,0x13ce0bc6,0x2a7721ba,0x1fab2dd7,
0x1a9112a4,0x07e112e8,0xfcb80639,0xf146f1c2,0xfa96f479,0x02f7fdb2,0x0bba0b58,0xfbaf0536,
0xfa6ef4f6,0x0b1efe31,0x0fc0094f,0xe7b305ed,0xc29bd7d1,0xeb3ecd85,0xe149e292,0xf5aef15e,
0xe6e8eca2,0x09e3fa5a,0x221a021d,0x1ad93923,0x1c821626,0xf2570bf7,0xf79fecf3,0x08abfc30,
0xf5fd067f,0xf514f90b,0x0935f545,0x5f1b2901,0x230a535e,0x1d3e21fc,0x3efe2fdd,0x17d119f7,
0x081a2422,0xcdfaec6b,0xd78ac4ef,0xe681d8f5,0xcde7e17e,0xdb6dd264,0xe02be17e,0x0cfaf42a,
0x07ad0f59,0x009900f2,0xcd98ee19,0xd788c7d0,0x0482edcb,0xc97beef8,0xe90fd017,0xf573ec3d,
0x31921a9b,0x236d26ff,0x103e1c65,0x313528e4,0x246c2163,0x19b322e0,0xee5607cf,0xebdce81c,
0xfdbcf828,0xdedfedc5,0xec75dfef,0xf87cf3cd,0x20f80b85,0x34853179,0x2230276e,0x0cb42003,
0xf40bf3da,0x30cc13bd,0xfdf51970,0xf7d10080,0xff95ee27,0x194a1775,0x1d3620f3,0x0671084f,
0x07000f49,0x1b6f0e6e,0xf9dd136d,0xc980df3f,0xb6cebc0e,0xcfafc0a7,0xb6a2c61d,0xbe30b76b,
0xdbf5cb3d,0xea10ddc9,0x06a403ad,0x16830784,0x06ce199d,0xfe91fa3d,0x2ce417ba,0x186e2173,
0x10bc1a98,0x36921f7e,0x32632fdb,0x1f913585,0x0e940f61,0x01090c44,0x24a013c3,0x0c941874,
0xd9e5f5a8,0xd553cfbb,0xe907e57d,0xcd3ddbe0,0xcd85c2c8,0xdc90e1d1,0xecbbd88e,0xfe21fc2c,
0x0f900207,0x036311bf,0x0e58fb9a,0x4c6a3b76,0x434944ad,0x46333c45,0x46b2572d,0x40dc3c15,
0x2a373969,0x10e01f2a,0xebf4f594,0x0b7b04b6,0xed3afded,0xb630cd76,0xaa99af01,0xac66aecb,
0x8e87a09f,0xaaba91f5,0xb486baab,0xcdd7bd7b,0xc74bd150,0xf87bd0eb,0x02c60eff,0xfdc7f39f,
0x35a11faa,0x43ee3b1c,0x5fcc54d4,0x58675e6d,0x62ef5dd1,0x602b62ac,0x4e4157fd,0x46c94427,
0x43c74f33,0x039f2dd1,0xd933de25,0xc5ced63b,0xbf88c53d,0x8d0f9fe8,0xb67ea1db,0xa48faefd,
0xb8e9ad97,0xb530b50a,0xef76d214,0xe2e6ef45,0xe473d689,0x1ef108eb,0x3b3e2dfe,0x4fce46f4,
0x4f175199,0x5adf5264,0x523e5cc5,0x5715500c,0x3f7e507e,0x3da53ff9,0x069c2595,0xfa02f732,
0xe633f32b,0xceefe853,0x9e06a53c,0xb70bada5,0x9adbaa3a,0xb23caa48,0xa359a2bc,0xc8fcb7c5,
0xc22dcd32,0xcf81b872,0x1002f91a,0x257e1806,0x39873392,0x38c83d78,0x4ae33ccd,0x4b2d5025,
0x50494cc3,0x4fa14eaa,0x48505120,0x1f02327d,0x16eb1a9c,0x087b0e0b,0xe2f400d7,0xb842c06a,
0xcfe9c912,0xc83bc5be,0xca88cfca,0xc76ec4f7,0xdfa0d1ed,0xc574db0d,0xe633c541,0x17d40c23,
0x1dcc14ab,0x2fb12bb7,0x19942418,0x37c42805,0x2c3b3181,0x344431ad,0x43793aec,0x2826407b,
0xf90e0868,0xff5afccb,0xf1b6fb64,0xc582e0f1,0xb87db19f,0xbf55c1e4,0xc381bbd1,0xce90cd88,
0xc98dcaee,0xdeacd463,0xc3afd19f,0xfb55d6b2,0x1d37158e,0x2256189f,0x338436ab,0x2e21263c,
0x50c8467c,0x4fb14ba5,0x57d75634,0x5ea76058,0x2d1e4958,0x165f1ac0,0x053a10bb,0xf38ff9e4,
0xd2c0eb61,0xb6babcad,0xb1feb12e,0xd1b6c073,0xc65ed42c,0xb54ab7eb,0xbe78bcbd,0xaf38b25d,
0xea80c6de,0x016a02eb,0x0c87fe06,0x10a81335,0x28511a33,0x3d7e33e2,0x45b54530,0x680a4e66,
0x6c137893,0x40ee5399,0x28163320,0x12811ee1,0x017607c1,0xdd18f4e7,0xbca8c700,0xbdc2b800,
0xd8e1ccf6,0xcc8bd769,0xba99c1cd,0xabe0b13b,0xab2ca8bc,0xe2fbc19a,0xef87f622,0xe4a0e68c,
0xf966e9cb,0x21fe0c5b,0x4dd03dac,0x4d8b4add,0x6f9d61c1,0x63656c12,0x527758f9,0x46d74fe3,
0x210e3485,0x16eb194b,0xf31b06cd,0xe08be7fc,0xe3bdde85,0xeb9ceb0c,0xd357df2c,0xb614c6cd,
0xab5bad4b,0xa3c2a5b3,0xc7dab2ba,0xc12ccd61,0xbd79b761,0xd5ddc82f,0x085bedfe,0x2d572076,
0x3ab8327c,0x49d9405a,0x554c5378,0x5c215ac2,0x44725389,0x2bbb321b,0x1f68299f,0x0a5a12a8,
0xfd8e0581,0x056cfd60,0xf9aa04f7,0xdbbce94d,0xcf4ad45f,0xc215ca21,0xacb2b278,0xcad1bb58,
0xbb0bc661,0xc6d1bdcd,0xdaeccf67,0xfef5e9cb,0x1edc1196,0x239d240b,0x376829ec,0x4fc34504,
0x56c5540f,0x464c53f4,0x36fd3b5c,0x19fe2d00,0x0d2c0d7f,0x13461126,0x13ee130c,0xfe660d18,
0xde01ecb9,0xcbd6d5a6,0xc173c4e6,0xafa5b6ef,0xb73cb4a1,0xae24b2dc,0xc4cdb2bd,0xd31ace55,
0xfb3be327,0x194f11c0,0x19d01629,0x3d442736,0x51ab4f1e,0x51064e81,0x467450e0,0x34183c51,
0x1717263a,0x0ae50b7d,0x143011b6,0x15b31582,0xf48c0847,0xd55de2cc,0xc7aecb0a,0xca52ca6c,
0xbbd5c558,0xb917b70b,0xaf83b41f,0xcd63bb8a,0xe335d896,0x06d0f315,0x110913dc,0x11fc0ba3,
0x46f526b3,0x64615f03,0x65a364d5,0x591061de,0x42164e34,0x1e80307d,0x1ad018ed,0x0ac515bf,
0x00dc068c,0xe2c9f229,0xc8a0d6ae,0xb95bbd13,0xbb50b99c,0xa9eeb47c,0xa7e9a7e4,0xac46a64b,
0xbf0eb806,0xd75bc7c2,0x04ceedb2,0x08df0c79,0x12290892,0x49302b78,0x5f7058a1,0x69d6659d,
0x53476280,0x44a64c11,0x35423898,0x306435eb,0x1ca4276d,0x076e12b0,0xe712f5a6,0xd6efdf4f,
0xc89ecf41,0xbf99c5c2,0x9f52aeb9,0x9bab9c60,0xae67a0ff,0xc53eb9ea,0xe321d18c,0x09e4fa60,
0x07830bc1,0x14e405b9,0x4695326b,0x55ce4dc9,0x5db96061,0x477c5165,0x38de3fce,0x396e38ce,
0x312d351a,0x258d2dcb,0x0bad1a62,0xe8f3f9bf,0xd50eddb6,0xc2dbcb92,0xb955be32,0xa4a5af5a,
0xa2efa031,0xa2c1a27a,0xbfc8b09c,0xd6b1c8df,0xf7fbe7c4,0xfb5afed0,0x11e30033,0x2e092415,
0x462637ca,0x52424fe5,0x47db505d,0x3e4c4003,0x404c4024,0x4be1444c,0x2c394346,0x11fc1cb4,
0xfe0706d3,0xeba6f59d,0xd577e099,0xd6c7d296,0xc9dcd204,0xb46ac3a6,0xb3e6a9af,0xcc9ec11b,
0xd982d55e,0xf5a6e63f,0xf95bfa1c,0x0d110126,0x147c0fb3,0x27781fb6,0x31842d63,0x2aa63193,
0x2485234c,0x31332946,0x42813fa6,0x187e30ed,0xf5ee04aa,0xe6fceded,0xded7e162,0xd5b4d84c,
0xdea0dd1a,0xd7fcda40,0xc0d2cd31,0xc838c09a,0xdc17d3cc,0xe247dd3a,0x0b84f514,0x0f24130e,
0x11230da9,0x1d7515f8,0x286323e1,0x356b2f91,0x2e6333a8,0x32ed2e49,0x3dcf36c8,0x429345dd,
0x144a2f55,0xf470fe04,0xe334ec8f,0xd7fbdc85,0xdb9dd797,0xdbf7ddf3,0xd666da1c,0xcd13cee1,
0xda08d33d,0xd73bdc38,0xe060d2a8,0x0c83fa3c,0x07ef0efe,0x020f0314,0x0d9c04de,0x19811586,
0x29af203d,0x2efc2e07,0x2d4b2e23,0x363d2f33,0x2ec63935,0x0a041b09,0xefaffc91,0xd8bae4a2,
0xcc9ccd74,0xd8d3d4e2,0xe02cda6f,0xdd00e1e1,0xd7ddd83c,0xe1bcdd59,0xd0eddb76,0xf441d947,
0x17300d77,0x112a148d,0x0aad1025,0x0c8f072d,0x20531477,0x36b22d42,0x41243e6e,0x3c5e3c58,
0x48a2469f,0x30dc3d85,0x146922d1,0xf92b06f1,0xd524e873,0xd191cbad,0xd904d840,0xe176dd01,
0xcecfdc3d,0xc19ec2cc,0xc8edc90d,0xbe76c01d,0xebe1ce81,0x068001a4,0x066f064f,0xf8b70174,
0xfc83f65f,0x168508be,0x2e0f2174,0x3e413b34,0x450c3da1,0x48b74bdf,0x31923ea5,0x1b242502,
0x0231110b,0xde51ee50,0xe3aadc8f,0xeb72e77d,0xee6bef0e,0xdc4be8ce,0xd5e1d3b9,0xc939d3d4,
0xc94bc174,0xfd79e344,0x0d1809ef,0x0abf0e45,0xf176fed0,0xf6f3ed4a,0x13420675,0x2e332016,
0x36c835d0,0x3bf937cf,0x39ff3f2c,0x2a36312c,0x1693222a,0xebd0045d,0xd6bed889,0xe807dff7,
0xeb6aeb3f,0xe736ea08,0xcf11dd16,0xc867c879,0xbeb2c508,0xd1eac0d8,0xfc33eae2,0x09e00473,
0x10020ed7,0xefea015c,0xfb46ef5f,0x13430821,0x2dd420b0,0x393834b0,0x470c4098,0x42c64776,
0x3f624045,0x26803736,0xf40d0c75,0xe96fe97a,0xf177ee1d,0xf3d6f2be,0xe862f1c9,0xc49ed594,
0xb929bdbb,0xbb9db725,0xdf3bc891,0x0305f53c,0x0ba609d6,0xfdf20a0a,0xe436ebec,0xf296e8f9,
0x0ee3fd10,0x2f05240e,0x30cc314c,0x3b793536,0x376139da,0x3b523980,0x2417362e,0xf2580916,
0xeab9e9e8,0xf0b1ecdb,0xf7d8f5a3,0xe770f2ff,0xc8dbd975,0xb062b8b4,0xbb5db1b5,0xe6eace7a,
0xff6cf8c0,0x0a6604a3,0xf9fa0772,0xea23ecc8,0xf4c9ee3a,0x18180267,0x3a2f2e01,0x37fb3a11,
0x3ac939b4,0x33ae3682,0x3ee2390e,0x22723913,0xf89a071d,0xf447f537,0xf4c4f3db,0xf537f60f,
0xe8e8f1f6,0xc13dd754,0xaa13af16,0xbf6fb145,0xecaed4e5,0x0633fd65,0x05b308e1,0xf4bcfe60,
0xebfaed34,0xf397ee5f,0x19120121,0x3bc3316a,0x36693953,0x386a38b2,0x2ea0317d,0x39d43547,
0x17592e5a,0xf9ee03a6,0xf2a4f5ed,0xf079f022,0xebf7effc,0xdc4be648,0xb621cb16,0xa367a6c8,
0xc1e7ae16,0xef11d94c,0x01f3fce1,0xfe1500e1,0xf571fa8d,0xef61f065,0xf674f14c,0x224107c9,
0x3ed83745,0x445040fc,0x3fa345c5,0x3b033752,0x48a046f2,0x2ac33c0a,0x123f1c67,0x05b70bb2,
0xfb34ffd1,0xeec1f4af,0xe084eabf,0xb838ce45,0xa69ba87c,0xbf29af5d,0xe567d402,0xf03def10,
0xe7f6eca6,0xde13e3b3,0xdb46d99f,0xe5f8dee2,0x0f52f90a,0x27281ddd,0x342b2ebf,0x2e0b3502,
0x35ed2bfc,0x3de23f40,0x2b1d349f,0x1a9e2234,0x106b150e,0x05e60bba,0xfadeff2f,0xea69f639,
0xc4abd6c4,0xc255be77,0xdc19cd26,0xf6d9eaa9,0xfc37fd52,0xf207f6fb,0xe769ed21,0xe647e52f,
0xee2be795,0x092bfb61,0x1eb71546,0x2b8f2699,0x241f290e,0x2ef426f9,0x304e3262,0x232e2b99,
0x0dd417e5,0x05080711,0x02c50518,0xf9aefe59,0xe35cf268,0xc16bcfe9,0xc3afbda7,0xdd99cf89,
0xf29cea56,0xf0eaf34f,0xeb06ee12,0xe6b8e859,0xe9f7e7ff,0xf717ee29,0x0bc301e5,0x204d1580,
0x2cef2ae9,0x26af27d2,0x30b82afa,0x310d3329,0x237d2b2f,0x16511ca1,0x139013bc,0x08b20feb,
0xfc67019d,0xe283f31e,0xc52bd0eb,0xc42bc10a,0xd85bccb3,0xeb50e494,0xe9ebeb42,0xe5e1e913,
0xe683e3ec,0xf105eae8,0xfc8af7cc,0x0c9e0332,0x222b1734,0x249a2659,0x275924b9,0x2f532b12,
0x325132c9,0x275f2de5,0x1b8a2038,0x18271a84,0x07bb10a6,0xfe0702b3,0xe00cf210,0xc772d08d,
0xc689c47c,0xd8eccd61,0xe4c4e27c,0xe6efe500,0xe708e7c0,0xe6ade699,0xefceea52,0xf065f0bc,
0xff92f4bc,0x17170dd6,0x1926183b,0x1ea91b6b,0x2afa24e7,0x2b872d91,0x24a027de,0x22142291,
0x1a0120d6,0x08a10f1d,0x02ea06d7,0xe4f6f641,0xd3f3d936,0xd6a2d2b7,0xeb82e130,0xee9eef46,
0xeec2ed51,0xf612f3bc,0xf652f4a6,0xfba8fa63,0xf6b5f8fb,0x06adfb04,0x17f7129e,0x1c1d19c4,
0x1f7a1d77,0x21f2222b,0x1cc11ee7,0x1b691c4f,0x15ee19be,0x035c0df1,0xf30ef888,0xe92ff133,
0xcfd6db48,0xcbb0cb75,0xd4d7ce34,0xe684de8f,0xe657e8e1,0xe86ae422,0xf3c1ef8c,0x0003f841,
0x087e06db,0xfd6c038a,0x083dfe86,0x1e62141a,0x2b122774,0x28692943,0x233c2740,0x22aa20ff,
0x2a9026cd,0x21772921,0x09a61565,0xffb402bc,0xee89fa67,0xd72ce0dd,0xcdd5d154,0xd4fcce4f,
0xe516de91,0xe65ae71d,0xed07e7ba,0xf221f045,0x02ebf8fe,0x072d0938,0xfa9fff35,0x01effc8e,
0x18590ab6,0x24d62259,0x22242554,0x14841a6e,0x1b4f1454,0x29da25de,0x19a7246f,0x00930ca2,
0xf850fa8c,0xe756f15c,0xdbacdfbe,0xcf6bd6dd,0xcf36cc35,0xd799d3b2,0xdb3dd957,0xea5ae25b,
0xf494ee6b,0x0a84ffd1,0x07d70cf0,0x008802fe,0x039cff63,0x1dab0fd4,0x279925a1,0x1fde25be,
0x11841693,0x229f16b1,0x2f0f2cc7,0x22f32aaa,0x0edd17cd,0x06460b80,0xf761fdec,0xf01ff415,
0xddece7a3,0xd964d897,0xddf8dc3d,0xe562dfe7,0xece1eb42,0xf741eef3,0x09a102e4,0x024307fa,
0xf5e0fc44,0xf3aff0af,0x0b6affa5,0x103f0ff1,0x0c31103a,0x00aa0456,0x11780680,0x1ba2193b,
0x13801a20,0x01ff08d9,0xfbeb0006,0xf4e1f62e,0xf5e0f706,0xe626ef4f,0xdde7df1d,0xe3a2e053,
0xf032e956,0xf3c3f391,0x002af690,0x0f1f0adf,0x09150d28,0xfec304ec,0xff5ffa4b,0x119309eb,
0x1748150e,0x13c31849,0x0ad00c3c,0x1648101a,0x20411b9b,0x1941203f,0x07990f90,0xf9dc0074,
0xf963f70f,0xfb22fc43,0xe9d6f446,0xe0f9e2c8,0xe552e1a3,0xf008eb9f,0xf260f109,0x0311f8e0,
0x08700947,0x025a0557,0xf597fce5,0xf6c4f256,0x032bfe40,0x0bd40740,0x06210c73,0xff58ffc3,
0x088602d9,0x16100ff6,0x11ef16c7,0x01a30a7d,0xf6cdf9b7,0xf9b0f7c0,0xf91bfb03,0xeb2cf255,
0xe3bbe693,0xe5c1e315,0xee6fea8e,0xf8ecf203,0x0e7403be,0x12571363,0x0bd40fef,0xfd98049d,
0xff9dfbda,0x09ca0485,0x141c0f80,0x0fd013db,0x0cc30d14,0x12900eb5,0x1b97175f,0x18811c9f,
0x04ad0f66,0xfa10fcfb,0xfbcbfa13,0xf9bdfc7d,0xecedf430,0xe130e5d2,0xe029df82,0xe650e29a,
0xf2b6eb37,0x04a6fcf7,0x04fe06d4,0xfd5b0197,0xf74bf975,0xfa61f7d9,0x0091fd13,0x0a06055c,
0x0a9a0c16,0x0a23090c,0x109d0ce3,0x18db14fe,0x127818f4,0x018f090c,0xfa21fc7d,0xfbb4fa77,
0xf9cbfbf4,0xefedf563,0xec52ecbd,0xeaa9ec07,0xeceeea11,0xff49f48b,0x0dcc0922,0x06c10bf6,
0xfbf10124,0xf881f8de,0xfc59fa4d,0x03a7fece,0x10470a23,0x0e8a121b,0x0c2c0b44,0x128f0f22,
0x19061653,0x112f1726,0x05cd0b2a,0x02bf02d8,0xff19018c,0xf8d4fc88,0xef67f3e5,0xec27ed74,
0xe3a3e86a,0xe6d2e247,0xfa2aeffb,0x03a90184,0xfd9f01c5,0xf378f824,0xee6af053,0xf2c2ef8c,
0xfc5bf6a2,0x0c0804b5,0x0b470dbc,0x0c910a87,0x14af101d,0x1ac6191a,0x14e318c5,0x0eb0113e,
0x0b5d0d5d,0x02c5078f,0xf8b6fd32,0xf522f694,0xf280f42c,0xe9c1ee0f,0xed9fe976,0xfe15f574,
0x06910476,0xfd29033e,0xf5bcf8c8,0xed26f0ea,0xeddfec85,0xf972f204,0x08630288,0x078d0876,
0x0d17098c,0x150710e5,0x1c3819ca,0x16381a1c,0x0ed61257,0x0adf0c9d,0x033807e9,0xf9e6fe21,
0xf705f6fc,0xf65cf842,0xeeccf1c5,0xf316efc2,0xfb7df6bc,0x027c00d8,0xf9b3fed7,0xeeadf4ba,
0xe53ae907,0xe4e3e3c3,0xf23de978,0xfe87fad4,0xfe5dfe44,0x0459010f,0x0fa2085a,0x1b521795,
0x1a201b84,0x13e216d6,0x12fc1340,0x0c51109f,0x013f06e3,0xfd77fdb2,0xfb4cfdc0,0xf7cbf831,
0xfd7efa80,0x0472002a,0x044c06bf,0xfc21003d,0xf15df71c,0xe5c6eb06,0xe2ece32c,0xee6de68a,
0xfb3df692,0xfdb4fca8,0x00e4ff52,0x0a6c0477,0x13460fb4,0x16d9161b,0x10c41426,0x0d7c0eea,
0x06010ab2,0xfbd70088,0xfaa2f9f4,0xf953fad3,0xfb6bf8d6,0xfff3fe9f,0x06fd025d,0x0714095c,
0xfda80271,0xf399f8f8,0xe861ed78,0xe4e9e57d,0xeefee84c,0xfa9ff5e0,0xfd24fc85,0x02a1fe87,
0x119d09df,0x198c1696,0x19ed1b63,0x1172159b,0x0c5d0e87,0x07680a64,0xfe1802d5,0xfa2cfb49,
0xf7a8f8ef,0xf9c0f7f9,0xff65fc10,0x069403e1,0x022e05d8,0xf96efda2,0xee22f436,0xe311e84e,
0xe0cbe009,0xef58e651,0xf8aaf6a5,0xf897f7c4,0x025efc2c,0x11e50a61,0x1a49173e,0x1a181b5a,
0x11e5165e,0x0b0c0e10,0x070408e0,0x032404da,0x006d021d,0xfcacfe35,0xfce5fc07,0x061c009a,
0x094e0990,0x003405b2,0xf8bdfbf5,0xefeef4c7,0xe5bfea9c,0xe2aae246,0xf27ee90f,0xf9dcf85f,
0xfd5afb43,0x066700ca,0x12550cf2,0x18e61615,0x180d19b1,0x0e3313d0,0x069709d9,0x01520376,
0xffdb004b,0xfe4dff87,0xf781fb9d,0xf5caf479,0x017cfb67,0x03ef049b,0xfb51fff6,0xf5a2f87a,
0xee02f179,0xe8a3eb9a,0xe8fee672,0xf7b4f0b9,0xfbb5fa53,0x00bcfdbf,0x0c9805d4,0x19ad139a,
0x1f531df4,0x19fd1da8,0x0eae149d,0x0545094c,0x02c3038a,0xffba014f,0xfb26fe10,0xf280f6e9,
0xf311f06e,0x00c5f9c5,0x0119038b,0xf890fc85,0xf1c7f520,0xf008f043,0xea1eeddb,0xec22e8c6,
0xf3a1f0bf,0xf823f5e5,0x0288fbdc,0x12800a91,0x1fe11a24,0x22b22293,0x1c7620b3,0x0f801633,
0x07360a6c,0x029904c7,0xfe1e0078,0xf821fb92,0xef40f342,0xf366ef16,0x000dfa81,0xfd1f00b1,
0xf267f7d5,0xec13edee,0xec95ecbc,0xe96bea81,0xedbfeaf3,0xf3bdf0e6,0xf8b3f5d0,0x0442fdad,
0x15180be9,0x23981e3e,0x2204241e,0x196e1e9a,0x0d0612d5,0x0750096e,0x03ff05b1,0xffd601a7,
0xfa85fe4f,0xf052f4cd,0xf399efad,0xff32fa03,0xff30010c,0xf3adfa0c,0xecdfeedb,0xed79ecfb,
0xef4fedfc,0xf2c1f10d,0xf696f4c3,0xfc81f89c,0x08df024a,0x1a5010c1,0x24d42247,0x1c9b21f6,
0x1272174b,0x0a640de6,0x06020802,0xff1f030c,0xfa79fc0e,0xf471f881,0xed0def93,0xf304ee77,
0xfbb4f842,0xf91bfc04,0xee89f404,0xeab7eb0a,0xee6dec5e,0xf144f021,0xf42af24e,0xf8dff669,
0x00c6fc88,0x0a4204b0,0x1de9134a,0x26c6257f,0x1c682294,0x11f716cd,0x0c3e0e2a,0x0a080ba9,
0x01fa0662,0xfb07fe41,0xf449f79f,0xf269f220,0xf8c3f4f8,0xfdfdfc52,0xf907fd22,0xed23f2c0,
0xe98de9f4,0xecbeeb1e,0xec4eece5,0xeee9ecd5,0xf7fff2a4,0x0129fd76,0x09c40441,0x1b971266,
0x221e21a3,0x1ad81efe,0x101e15bc,0x0be20c7f,0x0a7f0bf4,0x02d50753,0xf882fd81,0xf2eef4ec,
0xf38df259,0xfa01f659,0xfdcffd13,0xf829fbee,0xefe2f3b8,0xee56edfb,0xf075efe3,0xeda7ef1e,
0xef1ced8e,0xf9b0f333,0x04220009,0x0c5b0763,0x1ab2139a,0x1dd41e3d,0x18ab1bb3,0x10401463,
0x0cf60dfc,0x08f80bb2,0xff310496,0xf5def9db,0xf4b4f442,0xf6f4f5d2,0xfaa4f862,0xfc21fc6c,
0xf6cbf9e7,0xf1d1f3fc,0xf110f0ac,0xf05bf17c,0xee32eed8,0xf0d9ee72,0xfdeef682,0x07f7042d,
0x0eb70ab9,0x18741423,0x1846199e,0x121715a8,0x0cd00e9a,0x0c2e0c95,0x06880a47,0xfc9101be,
0xf43bf798,0xf43af367,0xf60cf538,0xf8f1f74d,0xf940f9e0,0xf571f766,0xf2c7f3cc,0xf48cf33f,
0xf493f4f9,0xf370f3e5,0xf833f459,0x0601ff05,0x0c7f0a88,0x10990de9,0x167713fc,0x154216f6,
0x0f0c1254,0x0bc90cae,0x0abe0b9b,0x047c0854,0xf951ff6d,0xf157f3e5,0xf2f0f190,0xf504f41f,
0xf7ccf657,0xf740f839,0xf3eef590,0xf31df2f9,0xf59ff436,0xf769f6d3,0xf625f6f5,0xfb0af6ff,
0x08170184,0x0f270cba,0x130310e7,0x16071519,0x12d11518,0x0dec103f,0x0a770bf6,0x07350913,
0x01af04b4,0xf716fd10,0xf19af296,0xf48af31c,0xf651f52c,0xfb4ef8c6,0xfafafc12,0xf716f912,
0xf461f571,0xf291f366,0xf44ff2f8,0xf6acf578,0xfcbbf8dd,0x086b0263,0x0d950c4f,0x0f610e3e,
0x105a1055,0x0d5f0f26,0x0b710bfc,0x0b440ba0,0x0616092c,0xffc80330,0xf64bfaea,0xf511f454,
0xf789f694,0xf9cff845,0xfdbffc16,0xfe28fe39,0xfceffde1,0xf8aafb1e,0xf3eaf5ee,0xf463f370,
0xf7adf5e9,0xff18fa7e,0x0898048a,0x0a3c09ff,0x0c8f0b0c,0x0edb0e25,0x0ba80dcd,0x0a190a2e,
0x084b0a13,0x02880533,0xfc860024,0xf4b6f7e6,0xf62af47c,0xf8d2f7be,0xfb1cf9e9,0xfd3efc42,
0xfda0fdc4,0xfafefcd3,0xf57df83d,0xf328f395,0xf5f7f433,0xf9ecf7e6,0x01abfcf5,0x0a9b06fa,
0x0af80b8b,0x0afb0a82,0x0cf60c15,0x0cc60d03,0x0d7e0d1b,0x085e0c04,0x0184046f,0xfc49ff1a,
0xf841f996,0xf9daf8ad,0xfacdfa99,0xfbbffb12,0xfdfafcc3,0xfe87fed3,0xf937fca2,0xf15ef512,
0xeee6ef2a,0xf43ef0c5,0xfb58f7f6,0x033ffeea,0x0a340791,0x099c0a83,0x085008b2,0x08f40882,
0x0b7209bb,0x0e210d87,0x08670c28,0x015d048d,0xfc33feb4,0xf9f5fa48,0xfc30fb02,0xfc97fcb5,
0xfc4cfc5a,0xfe43fcf2,0xff15ff4d,0xf9b7fd2b,0xf15af55e,0xedfeeead,0xf3e1efed,0xfbeff820,
0x03faffde,0x09e7079a,0x09250a40,0x078507d2,0x09f80870,0x0dd70bce,0x0f1c0f5f,0x085c0c6e,
0x00e60460,0xf9f9fd6c,0xf73df7ae,0xf97af81b,0xfc05fadd,0xfd5afcc5,0xff8cfe49,0x0031006b,
0xfa6ffe25,0xf21ef61b,0xef17ef7b,0xf4a3f12f,0xfc52f874,0x04d10073,0x0a700873,0x098c0aa8,
0x072407fa,0x09d507d4,0x0e570c41,0x0e1a0f31,0x07260b32,0xffaf0311,0xfa54fcb2,0xf7f6f8d6,
0xf812f7a0,0xfa7df931,0xfd17fbd4,0xff05fe2c,0xfe64ff51,0xf857fbe3,0xf0e3f469,0xef58eef1,
0xf5bff1e2,0xfdc4f9c9,0x062e020a,0x0b11094b,0x09fb0b38,0x0765083e,0x09b20808,0x0e020bfc,
0x0db50eba,0x07340aea,0x0040037a,0xfc5cfdcf,0xfa82fb6d,0xf996f9c4,0xfb3efa2c,0xfca5fc36,
0xfd94fcf2,0xfd63fe05,0xf825fb55,0xf146f484,0xefc6ef75,0xf662f24e,0xff6cfaf1,0x072c0399,
0x0b4109d9,0x08de0ad8,0x0580069a,0x08e50657,0x0d390bb3,0x0b760d1f,0x052c08a6,0xfecb01a1,
0xfc53fd27,0xfb10fbab,0xfb53fae3,0xfd1bfc2e,0xfe18fdb4,0xfee5fe8e,0xfcaafe5e,0xf6a1f9f4,
0xf080f32e,0xf038ef60,0xf697f2d0,0xffeafb1a,0x0805045b,0x0c100ac1,0x09550b6f,0x063a0721,
0x08e90709,0x0b6f0aa2,0x09d90b24,0x04bf07b0,0xffd001ce,0xfe02fec7,0xfd12fd58,0xfe41fd6d,
0xfffaff3c,0x0052003d,0x004b006d,0xfcdbff30,0xf588f975,0xef92f1f9,0xefb0eeb7,0xf67df277,
0xfebafad5,0x044201d9,0x07090614,0x05b306cd,0x04710497,0x06b70568,0x0761076d,0x05ea06dd,
0x023f045e,0xff3d0046,0xfed6feee,0xff13fee6,0xffaeff3b,0x017f0091,0x02c10231,0x0307032d,
0xff4301b9,0xf87ffc01,0xf30bf54f,0xf332f245,0xfa32f5f9,0x02b6fece,0x071b056c,0x08860828,
0x069607eb,0x05560583,0x05a105a2,0x04700514,0x033003ef,0xffbf01b0,0xfd56fe27,0xfd51fd25,
0xfdf3fdb2,0xfe67fe10,0xfffeff27,0x00d30093,0x00a400fc,0xfcdeff42,0xf6b4f9d4,0xf1eaf3eb,
0xf2b4f156,0xfb14f62d,0x0409001f,0x0758064e,0x07cb07d0,0x06230718,0x060105ae,0x06380666,
0x054705ab,0x043904f6,0x013c02e6,0xff40ffdc,0xff58ff36,0xff01ff55,0xfe14fe80,0xfe60fe06,
0xffb4fef8,0x005b0053,0xfcffff37,0xf796fa4d,0xf31cf508,0xf3f9f292,0xfbd1f751,0x035c0021,
0x06970561,0x07370742,0x05f20699,0x058505a4,0x04e20542,0x04a704a8,0x03ac0473,0x009c025c,
0xfea9ff33,0xfe47fe84,0xfd5bfdef,0xfbccfc7a,0xfc72fbb8,0xff22fdbd,0x00c50053,0xfdf1fff1,
0xf8d7fb63,0xf4d8f67f,0xf658f49b,0xfea7fa0c,0x059f02c7,0x07a90718,0x07ec07da,0x07cc07e9,
0x06ac0770,0x050305c9,0x04290487,0x0296039a,0xff2700f9,0xfcf4fdc6,0xfbc8fc55,0xfa76fb38,
0xf943f9a6,0xfa9af998,0xfdcffc0c,0x007aff93,0xfe22ffe9,0xf968fbc5,0xf62bf760,0xf916f687,
0x026efd84,0x09bf06bc,0x0b890b46,0x0a570b0a,0x094c09be,0x07a408b4,0x04680622,0x017002ba,
0xfff000a0,0xfde8ff00,0xfbd0fcdd,0xf9a9fabf,0xf74ff887,0xf5c1f634,0xf7a4f638,0xfcb1f9ec,
0x0078ff36,0xfda7ffdc,0xf8c8fb04,0xf5fff70b,0xf93ef67e,0x033ffde9,0x0ae207e3,0x0be50c0e,
0x0a680b23,0x094e09d6,0x072f0871,0x04b005ed,0x02380369,0x00cf0161,0xff8d003f,0xfe10fecf,
0xfc9bfd5b,0xfa16fb8a,0xf7f9f8aa,0xfa5ff883,0x0030fd2c,0x0335027b,0xffbc021e,0xfa32fcef,
0xf667f7d5,0xf90ff6a2,0x021afd48,0x09570661,0x0a610aa2,0x07520914,0x03fe0597,0x0159028a,
0xffac0081,0xfde3feb4,0xfd64fd73,0xfd29fd56,0xfd2cfd12,0xfd3afd64,0xfb14fc65,0xf9a3f9e1,
0xfd90fae0,0x04490108,0x06b20663,0x0288052f,0xfceeff99,0xf983facb,0xfc27f9cd,0x04700017,
0x0a6c081a,0x0a6e0b2d,0x069408ae,0x02240463,0xfead0020,0xfcf3fdba,0xfbfafc54,0xfc08fbf1,
0xfbf6fc01,0xfcc2fc28,0xfd16fd48,0xfa5dfbf7,0xf919f912,0xfdeffae3,0x04490155,0x06440615,
0x025904e0,0xfd1fff9b,0xf9d0fb03,0xfc9cfa35,0x04530059,0x09be079a,0x0a770ab1,0x070f0932,
0x0149043c,0xfdefff17,0xfcf5fd62,0xfc66fc9e,0xfc47fc48,0xfcacfc64,0xfdc3fd32,0xfd67fdf5,
0xfa7ffc15,0xf9ebf97f,0xfefffbef,0x05500260,0x07170712,0x02470545,0xfc4aff1c,0xf96cfa35,
0xfd1dfa6c,0x048500c7,0x0a2807c4,0x0bba0b82,0x08180a9d,0x013c049d,0xfe19ff0f,0xfde6fddd,
0xfddefdf9,0xfd3bfd97,0xfcacfcde,0xfd00fcc5,0xfc75fd02,0xf9f4fb54,0xf9def94d,0xfe3afba0,
0x03d9012c,0x05170562,0xffc502f5,0xf9dffc80,0xf82bf842,0xfcc4f9ce,0x03ef0057,0x09b8072a,
0x0b5d0b35,0x075a0a0c,0x00f603ff,0xfe0cfef1,0xfe51fdfa,0xfef7feb3,0xff0cff1c,0xfe77fed0,
0xfdb9fe15,0xfcb7fd4d,0xfacffbc4,0xfb02fa73,0xfeb4fc71,0x04280179,0x05b005d2,0x00c603c2,
0xfb0cfda8,0xf8d0f952,0xfbe4f9ba,0x020bfed6,0x07760515,0x08ee08cd,0x053807b1,0xffaf023d,
0xfd97fe15,0xfe81fde2,0xffb4ff27,0xfffd0005,0xfebaff86,0xfd2afddf,0xfbf2fc96,0xfaaffb40,
0xfb6dfaa8,0xff3afd03,0x047201da,0x0625061b,0x01d4047f,0xfc4cfeea,0xf966fa50,0xfbe3f9e7,
0x0274fef8,0x081f05b6,0x08f70947,0x046a0737,0xfe9d0141,0xfd03fd2a,0xfe88fdae,0xff84ff31,
0xff58ff8d,0xfe64fee4,0xfdb5fdfd,0xfd19fd6d,0xfcd4fcd5,0xfe41fd4e,0x0150ff9c,0x050c0341,
0x05d0060c,0x023e046d,0xfd15ffaf,0xf983facf,0xfb9af9c1,0x0208fe9f,0x0720050e,0x075307e9,
0x022b0547,0xfbcefebb,0xf9effa24,0xfbfafac6,0xfd96fd04,0xfd74fdb6,0xfca3fd02,0xfcf1fc99,
0xfdf1fd78,0xfecdfe58,0x006aff79,0x030c0194,0x066b04cb,0x06d3073e,0x02cb0532,0xfd440012,
0xf990fadd,0xfbfbf9e3,0x02a9ff3a,0x0778058b,0x077a0832,0x01fa0546,0xfbdcfe85,0xfab7fa9e,
0xfcc6fba6,0xfe33fdbb,0xfd97fe14,0xfccafd0a,0xfda8fd00,0xff68fe92,0x00940009,0x01bc0122,
0x03fc029e,0x076605bf,0x07b90831,0x03730602,0xfd450075,0xf8a1fa68,0xfa50f897,0x005cfd36,
0x04ad0303,0x044e0522,0xff40022e,0xfa52fc59,0xf9f0f994,0xfc3afb02,0xfddbfd47,0xfd9cfde6,
0xfd4efd49,0xfee5fdd8,0x01550028,0x02b00229,0x036c030d,0x04f00400,0x074e062d,0x076a07d6,
0x038705ee,0xfd1f0078,0xf890fa2c,0xfabaf8cc,0x0084fd9d,0x041102c7,0x02d30425,0xfd89005f,
0xfa31fb40,0xfb8bfa72,0xfe29fcf3,0xfed8fed4,0xfde7fe63,0xfe43fdcd,0x0098ff44,0x03400206,
0x04a3041b,0x053304f0,0x0635059c,0x077106e8,0x06b10772,0x02760506,0xfb6cff17,0xf6fcf867,
0xf9b6f78c,0xff13fc7e,0x01cb00f1,0xffeb0179,0xfad9fd6c,0xf876f908,0xfa41f901,0xfd2ffbce,
0xfe29fe08,0xfd7cfdca,0xfe7efdad,0x0199ffe0,0x04b60351,0x05e60594,0x05fe05f0,0x06d00641,
0x08230788,0x0787083e,0x036a05e6,0xfd0c004c,0xf951fa71,0xfbc3f9e1,0x004ffe2d,0x01d301a7,
0xfed400cf,0xfa33fc5e,0xf8aff8ed,0xfa89f953,0xfcebfbdc,0xfd6dfd73,0xfd20fd2f,0xfe81fd83,
0x01d50007,0x04c7038d,0x05450548,0x05020510,0x05f2054e,0x075f06bd,0x06df0781,0x03040564,
0xfcf8ffff,0xf9befaab,0xfc5ffa6e,0x009cfeb2,0x01520190,0xfdd5fff3,0xfa0ffba7,0xf998f968,
0xfb44fa59,0xfc47fbfd,0xfbadfc1c,0xfb5efb50,0xfd68fc0b,0x016eff48,0x04a90359,0x0573054e,
0x05940578,0x067605e2,0x07920716,0x071307a2,0x037705b2,0xfe0300b3,0xfb7efc1a,0xfe09fc43,
0x01b00011,0x01bc0256,0xfe0c001f,0xfafdfc2a,0xfb02faae,0xfc1cfb9c,0xfbfafc3f,0xfac6fb68,
0xfa80fa63,0xfca3fb3c,0x00adfe90,0x03ae0279,0x0482044a,0x04c30499,0x05a60524,0x0680062c,
0x05b90667,0x02470459,0xfdb3ffe4,0xfbf4fc44,0xfe3efcb8,0x014afff7,0x00fc01af,0xfd97ff6e,
0xfb03fbfd,0xfaf0fab6,0xfbfefb77,0xfc1afc40,0xfb44fbad,0xfb7dfb19,0xfe45fc8f,0x025c0051,
0x052d0405,0x061805d0,0x06640639,0x070706ac,0x0733074b,0x056f0694,0x018f03b1,0xfd8cff63,
0xfbf7fc5b,0xfd4cfc56,0xff65fe78,0xfef0ff9c,0xfbe7fd8f,0xf9a2fa7b,0xf99ff96a,0xfa4bfa02,
0xfa2afa57,0xfa02f9fc,0xfbacfa85,0xff74fd61,0x03ca01b1,0x06a30576,0x07a10758,0x07ad07a8,
0x082d07d7,0x085a0872,0x067207b7,0x026a0495,0xfe810046,0xfce2fd56,0xfdd8fd1b,0xff51febf,
0xfe24ff29,0xfad7fc86,0xf8d4f989,0xf8ebf8ab,0xf9a6f957,0xf99ff9b9,0xf9dcf996,0xfbf2faa2,
0xffbffdb4,0x03ff01e5,0x074305d5,0x087a0827,0x08250864,0x080007fd,0x07b607fe,0x058806e9,
0x01ab03b2,0xfe4affc6,0xfd1ffd5d,0xfe3efd7d,0xff5dff01,0xfdddfefd,0xfa97fc40,0xf892f946,
0xf8eef880,0xf9b6f96e,0xf9aef9bd,0xfa6bf9d7,0xfd13fb84,0x00cafee4,0x047b02b1,0x075f0614,
0x087f0830,0x07de0851,0x07180765,0x068606e5,0x046905b7,0x00df02b2,0xfdf2ff3b,0xfcc0fd17,
0xfd8afcf6,0xfe7bfe2b,0xfd21fe26,0xfa3efbb1,0xf8abf928,0xf95bf8cf,0xfa74f9fe,0xfaddfab0,
0xfbfffb3b,0xfeadfd30,0x01b80039,0x04ba0335,0x076d062f,0x08720838,0x0776081c,0x066e06d7,
0x05cb0630,0x039204f2,0x001001d2,0xfd5bfe85,0xfc67fc9f,0xfd68fcb8,0xfe6ffe1e,0xfd47fe2c,
0xfaaefbfd,0xf971f9ba,0xfa9ef9d7,0xfbd3fb5b,0xfc36fc07,0xfd57fc98,0xff85fe5e,0x01c400a8,
0x044b02f2,0x074705d2,0x087d083f,0x07220801,0x05820637,0x046a04fd,0x02420381,0xff4300c7,
0xfcdcfde4,0xfc48fc4d,0xfd96fcc7,0xfedefe62,0xfe05fec4,0xfb7ffcd1,0xf9f6fa70,0xfab0fa1c,
0xfbbdfb50,0xfc50fc06,0xfd8dfcc8,0xff72fe7b,0x0153005b,0x03ed027c,0x0736059a,0x089f084b,
0x07470837,0x054e063f,0x037e046a,0x0142026c,0xff1c0024,0xfd30fe18,0xfc4dfc8c,0xfd30fc8a,
0xfe9ffdfc,0xfe67fed3,0xfc1cfd64,0xfa4afaf6,0xfa95fa36,0xfb80fb17,0xfc30fbd4,0xfd55fcae,
0xfedafe14,0x0093ff9e,0x039f01e8,0x0720057c,0x089c083b,0x076c083a,0x05790675,0x038c0487,
0x019b028f,0xffc700b1,0xfe17fee5,0xfd45fd85,0xfde0fd66,0xfef7fe7e,0xfe7aff03,0xfc26fd6b,
0xfa87fb12,0xfb0ffa98,0xfc22fb9e,0xfd1efc9b,0xfe34fdab,0xfefafea8,0xffd3ff4a,0x026200da,
0x05e60431,0x07bb0725,0x06f1079c,0x04d905ef,0x02e903d8,0x010e01fd,0xff4a0021,0xfdcafe85,
0xfce4fd37,0xfd3ffcea,0xfe0efdb8,0xfd84fe05,0xfbb9fcac,0xfaacfaf8,0xfb58fad9,0xfc7ffbee,
0xfdd1fd1d,0xff41fe93,0x0010ffbe,0x00c8004e,0x031301b1,0x068604ca,0x08a507ec,0x07e20898,
0x057d06bf,0x0312043f,0x00fb0204,0xfef4fff7,0xfd15fdf2,0xfc03fc68,0xfc44fbfa,0xfd0afcb7,
0xfca5fd10,0xfb0dfbe5,0xfa28fa6b,0xfac0fa51,0xfbdcfb49,0xfd4cfc87,0xfeeefe23,0x0002ff93,
0x00b4004a,0x02c4017c,0x0665047d,0x091f0812,0x08b3094f,0x05ff0782,0x02f7046b,0x00a001b4,
0xfeedffbb,0xfd86fe33,0xfc81fcf0,0xfc89fc53,0xfd58fcf4,0xfd59fd88,0xfc4ffcde,0xfbc7fbe2,
0xfc69fbff,0xfd56fcdc,0xfe71fdda,0xffb9ff1c,0x00760030,0x00ed00a3,0x02b80194,0x064f045e,
0x093b0816,0x08b10971,0x056a073e,0x01bc0382,0xff1d0037,0xfdd1fe5b,0xfce9fd67,0xfbc1fc52,
0xfb3efb5d,0xfb8dfb56,0xfbddfbc3,0xfbbdfbd2,0xfc0ffbc9,0xfd0bfc85,0xfddffd7b,0xfec2fe45,
0xffefff55,0x00d10079,0x01430106,0x029501b9,0x057b03e6,0x080d06ff,0x07e2085d,0x051806b9,
0x016d033c,0xfee0ffed,0xfdf0fe42,0xfd44fdaa,0xfc47fcc7,0xfbabfbde,0xfbdbfbac,0xfc7afc24,
0xfd22fccf,0xfdb4fd67,0xfe55fe09,0xfeeefea3,0xffbdff4c,0x00be0040,0x01320110,0x01480137,
0x023f0194,0x04b60355,0x07270617,0x0749079b,0x047b062f,0x0095027e,0xfe05ff0b,0xfd5efd84,
0xfd24fd51,0xfc50fcc5,0xfba6fbe7,0xfbd3fb9d,0xfcc8fc40,0xfdf3fd4a,0x00000000,0x00000000,

};

PROGMEM
const uint32_t sample_2_Pizzicato_PizzViolinE5[768] = {
0x00330000,0x0c1e0957,0x100c0a13,0xefb7085e,0xef13e447,0x25e11a69,0x23032238,0xc02ed183,
0xe93ddc07,0x0e2f1cb4,0x0a35fcfa,0xe333f478,0xee61d669,0x14351329,0x34ef33f1,0xd8cee3ff,
0x062cec10,0x198b2b9d,0x193a07fd,0xd6bde8be,0xd7a8c832,0x0378ff34,0x2677219c,0xf91fe026,
0x0c3fef9c,0x32823c3d,0x17073394,0xe2d4ede5,0xbfc0c23a,0x158fd484,0xec170259,0x02cdfad7,
0xe664d236,0x5dbb270d,0x24d658ac,0x073c31fa,0x050bf4c3,0x1e5bd9d1,0xbf540f01,0xe4b3afcf,
0x8959d90a,0x29dcfc42,0xf18ffe56,0xfbd124f4,0x08a43234,0x4dd4f45b,0xf9ae42fc,0x2a8fef47,
0xa13febca,0x31b21b6a,0xf20fff1f,0xe72c0ec2,0xe8d41084,0x40dacf79,0xed4343bc,0x0fd6c8c4,
0xacabd019,0x1933286b,0xfd90f483,0xe98e179a,0xdc2e1526,0x50c5d83c,0xdf173921,0x2901e160,
0xcbc0c44a,0x3e37547d,0x105b0b69,0xe9c6eae1,0xc038fd0b,0x2dabcf96,0xc2d11a7e,0x1720e7ff,
0xfdb0a8d1,0x642c60c6,0x398b3e54,0x107b1a2d,0x9c07f475,0x31a1c899,0xb931063e,0xcd50dcb5,
0xc8c3839d,0x2e1f35d9,0x414e2c69,0x2acd344f,0xb86bfb5b,0x317303da,0xfba51a6e,0xe40f29ba,
0xeb349d9f,0x1e3a41e0,0x37671be1,0x197c2794,0x8000c27b,0xfa1ac66a,0xd951e226,0xe2e811a6,
0x231bc125,0x22f35a63,0x55c24788,0x4eaf403b,0xb462e1f1,0x01f4e144,0xce8bd2e7,0xc380058a,
0x0970b08b,0x09822346,0x1b401d45,0x4c9636f8,0xe143e99c,0x056af32a,0xde73cdaf,0xbb79fdd7,
0x0722ba96,0x043d1366,0x1e1f1dd4,0x5adc467a,0xf5c7120f,0x25d10de6,0x0437ed60,0xbb9efeec,
0x15a5c754,0xef0d03fd,0x02320194,0x1c6b204d,0xcb98dd74,0xed84fbd6,0xee84cd49,0xcfb7eed3,
0x3a740749,0x242c1b66,0x2b083aa7,0x22893ec8,0xe33dece0,0xd418edce,0xe6dad4bc,0xc80ee47f,
0x1a54002a,0x258205a3,0x2e6a3690,0x163d32d4,0xeef90542,0xd6bdf663,0xf710e8f9,0xbc5fcf70,
0xf8f9f53d,0x091ae26e,0x321520d9,0x22323062,0xffd00da1,0xce8f031c,0x0d13eb9d,0xd4dee26a,
0xfe5f01fd,0x1058eced,0x30f91c6f,0x1a402bae,0x1598fab8,0xdb2beb0a,0x1dedfd02,0xf09afdcf,
0xf46a087b,0xfd9eed0c,0x161afd30,0x01020468,0xe44fdaf7,0xcaf6bab4,0x09f6e26e,0x1c35ff72,
0x176b2cb4,0x29412285,0x4bd74430,0x1bd82890,0xf084f10f,0xafd7bd09,0xd419beca,0xfaaed6aa,
0xfc480477,0x31cd1787,0x3fae4754,0x264433bb,0xeffcfc0d,0xa8f6b8c0,0xc855cf88,0xfa53c92a,
0x04a3080d,0x34251a02,0x4a65510a,0x2aac40cd,0xfd8f114c,0xb608b993,0xc670d5d8,0xf9b7cbae,
0xf664f201,0x30120e38,0x3e2745a9,0x20e838c6,0xf6fa11e9,0xc681b726,0xc6a2e4b4,0xfffadf2e,
0xf368e858,0x2e690c5f,0x3a45397c,0x2b1f3b23,0xf2bc2a38,0xc46eb039,0xbe22db52,0x07feed7f,
0xe6eee43d,0x2c3900c1,0x3d5136a0,0x27113138,0xeac02c79,0xcb5ab914,0xd719de05,0x1d6816eb,
0xec1fef53,0x1c81faef,0x25381f21,0x25121eb9,0xd2801deb,0xd305b28e,0xdc96e18f,0x24e81527,
0xea12f950,0x1a860eaf,0x220e1f3f,0x2e841e31,0xca2d19a2,0xce99b5ef,0xe4fdceac,0x17d71a72,
0xfcf3f6f8,0x1d6f19a7,0x3027309d,0x366220d7,0xcf3b093b,0xcae6bbe7,0xed67c6a1,0x0a0010c6,
0xf978f422,0x19cd116a,0x24eb268f,0x301518af,0xcb530ce5,0xc6bcc3a3,0xf486c6b9,0x03f41131,
0xfc8df4ba,0x1eec1579,0x2b512be4,0x393e29da,0xc7900eea,0xcfcdce61,0xfa00d51d,0xff1c01bf,
0xfee2f6e5,0x1bc10c29,0x30dd3265,0x34ae2c0e,0xc1e90344,0xb968c0ef,0xf110cbaf,0xfb48f557,
0xf9a5f561,0x1e900c5f,0x37f23936,0x37f635c1,0xd1e7fd4c,0xb8f3c76c,0xf350d48f,0x04990372,
0xfc59fbf2,0x1fdd10a4,0x38233029,0x3dc037ed,0xcd90fc7f,0xc2f6c9d3,0xedeadda2,0x06f701e7,
0xf6daf827,0x18bf040a,0x28fc2e38,0x236a2701,0xbbf6e26b,0xc1c3b616,0xeeeed544,0x0fd50d26,
0x0ab30ad7,0x333c181d,0x38c949b7,0x31fe378a,0xd187f35a,0xce9db638,0xeac7e23d,0xf8c0f995,
0xecf1f10a,0x1787f8db,0x1d112e11,0x1bea2928,0xd656f0c7,0xe3b3c384,0x03e8f3b7,0x146615cd,
0x01230976,0x28150a4b,0x12462dce,0xfc8413a9,0xc093dd15,0xda66b3a6,0x0630f258,0x1149124b,
0x00270dbe,0x358f0ed6,0x1c22324c,0x02d81c21,0xc564ed27,0xe4abc1c7,0x13c5fd95,0x101b152a,
0xfc6e0c80,0x1a170654,0x117318a1,0xe7cbfb35,0xb566dfbb,0xda08bcca,0x121bf7fa,0x1f2f1708,
0x0f7a196d,0x2d351c3f,0x29f83496,0xfe930843,0xc191ef5c,0xdddec93c,0x10f1fd6f,0x16a70cd3,
0xf7d409de,0x17cc08b5,0x0e041ae9,0xef71f1f8,0xbc33d9dc,0xe299c622,0x17000a15,0x252e19df,
0x02511232,0x1d7f104e,0x19bc29cb,0xf590f927,0xc669d9f4,0xeda8cd79,0x1ab81403,0x252b20ea,
0xfcba0df2,0x18470b18,0x072819fb,0xe6b6f00d,0xba4ecba8,0xea2ec7d3,0x15710a8f,0x27961ff1,
0x01890dd1,0x28621554,0x119c2bf3,0xee33fcaf,0xbd12d240,0xe825c6fd,0x10b208c8,0x19fa1482,
0xfe030103,0x295712ef,0x11212e7f,0xefc9fee2,0xca86d925,0xf98adc25,0x1a64157f,0x1c111b91,
0xf659f8b7,0x16c60630,0xf573171e,0xde6ce6a2,0xc2fbc949,0x0582db4e,0x1b141d72,0x21f22934,
0x039903a5,0x1c13095f,0x04c71ce3,0xe1a9f11d,0xd332d7f6,0x0a29e4b4,0x26631e31,0x21be33c8,
0xfd210658,0x0ed801fc,0xf2fd05e5,0xd0e8d8af,0xc4d3c412,0xfae6dbd0,0x20b60d6e,0x1f41317d,
0x04eb0c81,0x1ebb1086,0x083618ed,0xe232f22b,0xd317cc46,0x0008e9bf,0x24d20e2b,0x20c133cb,
0x00e10b51,0x18320ea3,0xf5a80ca0,0xd8fcea16,0xc592be49,0xf689e382,0x20f2024b,0x1d7b2b69,
0x028d0d6a,0x1d4d13bf,0xf7530ce0,0xde22f3e8,0xd2e5cb84,0xfab9e99c,0x1eb208ba,0x22e52396,
0x08be10d3,0x1df51dda,0xf9840cab,0xd901f0f0,0xd5a1cd13,0xf949edf0,0x146a00d5,0x20891d90,
0x038a0506,0x1e58218b,0xf50808ef,0xd889e9e2,0xd78ece1d,0xf60fec87,0x0ca903c6,0x1c2a15b4,
0x09de0047,0x1cfd21c4,0xfd370e6b,0xe133f043,0xea93dba2,0x0927fc8d,0x0ede1379,0x16f516c0,
0x06c5fb23,0x0f55150b,0xf10b01ab,0xd8eee82d,0xec99d8c4,0x0907fb68,0x05900e5d,0x0d8f12c6,
0x0466f91a,0x07890aa5,0xea92fa5a,0xe1ebe964,0xf876e1d6,0x18a30afd,0x17f91ca3,0x184d2162,
0x0cdb0988,0x062a0acb,0xe80af5f4,0xd806e441,0xf57cdccd,0x09630380,0x0a8208e3,0x111b1700,
0x050b02d8,0x049f08a3,0xe70ff35c,0xdf91e62c,0xfe8de7d2,0x0a3c0587,0x0e5d0c0a,0x15cf1a83,
0x0a040708,0x02aa0ee9,0xf571f4da,0xe240f24f,0x0014eaf8,0x09bf0592,0x0d0f0b79,0x113a18d1,
0xfd9efc40,0xf90901ad,0xe94ae894,0xdf4ceb25,0x025bef52,0x0c0a0582,0x15db1062,0x165d20b2,
0x036002bb,0xfc3804cd,0xefcaea49,0xdfccec78,0xf6f6ed0c,0x05befc8f,0x15ec0ac1,0x19ad21dd,
0x0ce10c8a,0xff04095d,0xf88af2a7,0xe514f02e,0xf298f013,0x0075f938,0x0ea60340,0x108c185f,
0x00fb04fc,0xf457fb21,0xf38dee09,0xeb76ebf2,0xf7e4f6dc,0x0ab9015e,0x190d0f9e,0x189a1f3b,
0x06060dee,0xf5dbfba0,0xf69df49d,0xedd6ec41,0xf77cf58b,0x06210062,0x0f340a88,0x0d42118a,
0xfb290491,0xeec1f070,0xf0b9f160,0xf0b9eb1a,0x0459f9ed,0x107b0e47,0x1e0d1499,0x160a1f20,
0xf9010818,0xeaf7f105,0xe68ceab6,0xe6d0e1a5,0xfc4ceeb0,0x0a8905b4,0x1f6d14bc,0x1ab1224e,
0x02120dd9,0xf215f802,0xec6ef1ab,0xec23ea3a,0xfefdf0c4,0x08d10808,0x19910fde,0x10f41ae8,
0xfa7f040e,0xec50ede7,0xe635ecba,0xea3ee74b,0x0340f3b2,0x10a90dc1,0x1e731523,0x11871d9e,
0xffc50a36,0xf148f330,0xef57efaf,0xea43ecc8,0x01eaf54b,0x098307f6,0x15880ec1,0x0ccb1562,
0xf94903d8,0xf01cf16f,0xf0d8eddc,0xedb7ee3b,0x02abf75e,0x0a870aba,0x1b8f125d,0x12121a2d,
0xfd4005ae,0xf1b4f6d1,0xf297efc3,0xf194eff7,0x006ef83e,0x028d0507,0x14c00d81,0x0f6d138e,
0xfa4d02e7,0xeef1f32a,0xf285ef36,0xf476f14d,0x01c3f9f4,0x07510436,0x1744152d,0x10e5136d,
0xfe3a0711,0xed77f2b3,0xf295ef28,0xf4e6f21e,0x00b5f8f1,0x0693013e,0x0ecc1173,0x0cec0f80,
0xff7e07a1,0xefd3f144,0xf761f233,0xfbd8f924,0x061a0252,0x0b6302a5,0x0a8d1123,0x0473098d,
0xf7d301bc,0xe68ae8ff,0xf1acea05,0xfd6ef5dd,0x0a26079a,0x166e0a77,0x0f1a171c,0x09ac0e8b,
0xfa6007f3,0xe43aeb5c,0xee34e520,0xfa08f220,0x071504e3,0x13570941,0x0ee213db,0x06760ad6,
0xfc720867,0xe560ee9e,0xee18e65f,0xfd4ff365,0x07830484,0x16710db2,0x0ef0167f,0x08c609b6,
0xfa2508ab,0xe390ec5f,0xe71de254,0xf81aee60,0x05aeff7c,0x1a811069,0x11c41a1f,0x0abc0a9c,
0x00b10b51,0xe9c8f357,0xed82e929,0xf8c8f2e1,0x00bdfc82,0x15280d13,0x0991118d,0x03f1016f,
0xfd5e0537,0xea5ef1d9,0xf33aee30,0xfa37f6bb,0x0570fce6,0x176010d0,0x0bd31478,0x03ae059a,
0xfe7b0565,0xef38f222,0xf2baefd6,0xf77cf69c,0x02acf8ac,0x15830ef3,0x06811176,0x01f700b0,
0xf99d030f,0xeed0efc0,0xf635f20e,0xf9e8f88a,0x0803fe20,0x18801323,0x08c712b2,0x01b503d7,
0xf8130139,0xeef1ef86,0xf5e1f20e,0xf816f7bc,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_3_Pizzicato_PizzViolinE5[768] = {
0x00330000,0x0c1e0957,0x100c0a13,0xefb7085e,0xef13e447,0x25e11a69,0x23032238,0xc02ed183,
0xe93ddc07,0x0e2f1cb4,0x0a35fcfa,0xe333f478,0xee61d669,0x14351329,0x34ef33f1,0xd8cee3ff,
0x062cec10,0x198b2b9d,0x193a07fd,0xd6bde8be,0xd7a8c832,0x0378ff34,0x2677219c,0xf91fe026,
0x0c3fef9c,0x32823c3d,0x17073394,0xe2d4ede5,0xbfc0c23a,0x158fd484,0xec170259,0x02cdfad7,
0xe664d236,0x5dbb270d,0x24d658ac,0x073c31fa,0x050bf4c3,0x1e5bd9d1,0xbf540f01,0xe4b3afcf,
0x8959d90a,0x29dcfc42,0xf18ffe56,0xfbd124f4,0x08a43234,0x4dd4f45b,0xf9ae42fc,0x2a8fef47,
0xa13febca,0x31b21b6a,0xf20fff1f,0xe72c0ec2,0xe8d41084,0x40dacf79,0xed4343bc,0x0fd6c8c4,
0xacabd019,0x1933286b,0xfd90f483,0xe98e179a,0xdc2e1526,0x50c5d83c,0xdf173921,0x2901e160,
0xcbc0c44a,0x3e37547d,0x105b0b69,0xe9c6eae1,0xc038fd0b,0x2dabcf96,0xc2d11a7e,0x1720e7ff,
0xfdb0a8d1,0x642c60c6,0x398b3e54,0x107b1a2d,0x9c07f475,0x31a1c899,0xb931063e,0xcd50dcb5,
0xc8c3839d,0x2e1f35d9,0x414e2c69,0x2acd344f,0xb86bfb5b,0x317303da,0xfba51a6e,0xe40f29ba,
0xeb349d9f,0x1e3a41e0,0x37671be1,0x197c2794,0x8000c27b,0xfa1ac66a,0xd951e226,0xe2e811a6,
0x231bc125,0x22f35a63,0x55c24788,0x4eaf403b,0xb462e1f1,0x01f4e144,0xce8bd2e7,0xc380058a,
0x0970b08b,0x09822346,0x1b401d45,0x4c9636f8,0xe143e99c,0x056af32a,0xde73cdaf,0xbb79fdd7,
0x0722ba96,0x043d1366,0x1e1f1dd4,0x5adc467a,0xf5c7120f,0x25d10de6,0x0437ed60,0xbb9efeec,
0x15a5c754,0xef0d03fd,0x02320194,0x1c6b204d,0xcb98dd74,0xed84fbd6,0xee84cd49,0xcfb7eed3,
0x3a740749,0x242c1b66,0x2b083aa7,0x22893ec8,0xe33dece0,0xd418edce,0xe6dad4bc,0xc80ee47f,
0x1a54002a,0x258205a3,0x2e6a3690,0x163d32d4,0xeef90542,0xd6bdf663,0xf710e8f9,0xbc5fcf70,
0xf8f9f53d,0x091ae26e,0x321520d9,0x22323062,0xffd00da1,0xce8f031c,0x0d13eb9d,0xd4dee26a,
0xfe5f01fd,0x1058eced,0x30f91c6f,0x1a402bae,0x1598fab8,0xdb2beb0a,0x1dedfd02,0xf09afdcf,
0xf46a087b,0xfd9eed0c,0x161afd30,0x01020468,0xe44fdaf7,0xcaf6bab4,0x09f6e26e,0x1c35ff72,
0x176b2cb4,0x29412285,0x4bd74430,0x1bd82890,0xf084f10f,0xafd7bd09,0xd419beca,0xfaaed6aa,
0xfc480477,0x31cd1787,0x3fae4754,0x264433bb,0xeffcfc0d,0xa8f6b8c0,0xc855cf88,0xfa53c92a,
0x04a3080d,0x34251a02,0x4a65510a,0x2aac40cd,0xfd8f114c,0xb608b993,0xc670d5d8,0xf9b7cbae,
0xf664f201,0x30120e38,0x3e2745a9,0x20e838c6,0xf6fa11e9,0xc681b726,0xc6a2e4b4,0xfffadf2e,
0xf368e858,0x2e690c5f,0x3a45397c,0x2b1f3b23,0xf2bc2a38,0xc46eb039,0xbe22db52,0x07feed7f,
0xe6eee43d,0x2c3900c1,0x3d5136a0,0x27113138,0xeac02c79,0xcb5ab914,0xd719de05,0x1d6816eb,
0xec1fef53,0x1c81faef,0x25381f21,0x25121eb9,0xd2801deb,0xd305b28e,0xdc96e18f,0x24e81527,
0xea12f950,0x1a860eaf,0x220e1f3f,0x2e841e31,0xca2d19a2,0xce99b5ef,0xe4fdceac,0x17d71a72,
0xfcf3f6f8,0x1d6f19a7,0x3027309d,0x366220d7,0xcf3b093b,0xcae6bbe7,0xed67c6a1,0x0a0010c6,
0xf978f422,0x19cd116a,0x24eb268f,0x301518af,0xcb530ce5,0xc6bcc3a3,0xf486c6b9,0x03f41131,
0xfc8df4ba,0x1eec1579,0x2b512be4,0x393e29da,0xc7900eea,0xcfcdce61,0xfa00d51d,0xff1c01bf,
0xfee2f6e5,0x1bc10c29,0x30dd3265,0x34ae2c0e,0xc1e90344,0xb968c0ef,0xf110cbaf,0xfb48f557,
0xf9a5f561,0x1e900c5f,0x37f23936,0x37f635c1,0xd1e7fd4c,0xb8f3c76c,0xf350d48f,0x04990372,
0xfc59fbf2,0x1fdd10a4,0x38233029,0x3dc037ed,0xcd90fc7f,0xc2f6c9d3,0xedeadda2,0x06f701e7,
0xf6daf827,0x18bf040a,0x28fc2e38,0x236a2701,0xbbf6e26b,0xc1c3b616,0xeeeed544,0x0fd50d26,
0x0ab30ad7,0x333c181d,0x38c949b7,0x31fe378a,0xd187f35a,0xce9db638,0xeac7e23d,0xf8c0f995,
0xecf1f10a,0x1787f8db,0x1d112e11,0x1bea2928,0xd656f0c7,0xe3b3c384,0x03e8f3b7,0x146615cd,
0x01230976,0x28150a4b,0x12462dce,0xfc8413a9,0xc093dd15,0xda66b3a6,0x0630f258,0x1149124b,
0x00270dbe,0x358f0ed6,0x1c22324c,0x02d81c21,0xc564ed27,0xe4abc1c7,0x13c5fd95,0x101b152a,
0xfc6e0c80,0x1a170654,0x117318a1,0xe7cbfb35,0xb566dfbb,0xda08bcca,0x121bf7fa,0x1f2f1708,
0x0f7a196d,0x2d351c3f,0x29f83496,0xfe930843,0xc191ef5c,0xdddec93c,0x10f1fd6f,0x16a70cd3,
0xf7d409de,0x17cc08b5,0x0e041ae9,0xef71f1f8,0xbc33d9dc,0xe299c622,0x17000a15,0x252e19df,
0x02511232,0x1d7f104e,0x19bc29cb,0xf590f927,0xc669d9f4,0xeda8cd79,0x1ab81403,0x252b20ea,
0xfcba0df2,0x18470b18,0x072819fb,0xe6b6f00d,0xba4ecba8,0xea2ec7d3,0x15710a8f,0x27961ff1,
0x01890dd1,0x28621554,0x119c2bf3,0xee33fcaf,0xbd12d240,0xe825c6fd,0x10b208c8,0x19fa1482,
0xfe030103,0x295712ef,0x11212e7f,0xefc9fee2,0xca86d925,0xf98adc25,0x1a64157f,0x1c111b91,
0xf659f8b7,0x16c60630,0xf573171e,0xde6ce6a2,0xc2fbc949,0x0582db4e,0x1b141d72,0x21f22934,
0x039903a5,0x1c13095f,0x04c71ce3,0xe1a9f11d,0xd332d7f6,0x0a29e4b4,0x26631e31,0x21be33c8,
0xfd210658,0x0ed801fc,0xf2fd05e5,0xd0e8d8af,0xc4d3c412,0xfae6dbd0,0x20b60d6e,0x1f41317d,
0x04eb0c81,0x1ebb1086,0x083618ed,0xe232f22b,0xd317cc46,0x0008e9bf,0x24d20e2b,0x20c133cb,
0x00e10b51,0x18320ea3,0xf5a80ca0,0xd8fcea16,0xc592be49,0xf689e382,0x20f2024b,0x1d7b2b69,
0x028d0d6a,0x1d4d13bf,0xf7530ce0,0xde22f3e8,0xd2e5cb84,0xfab9e99c,0x1eb208ba,0x22e52396,
0x08be10d3,0x1df51dda,0xf9840cab,0xd901f0f0,0xd5a1cd13,0xf949edf0,0x146a00d5,0x20891d90,
0x038a0506,0x1e58218b,0xf50808ef,0xd889e9e2,0xd78ece1d,0xf60fec87,0x0ca903c6,0x1c2a15b4,
0x09de0047,0x1cfd21c4,0xfd370e6b,0xe133f043,0xea93dba2,0x0927fc8d,0x0ede1379,0x16f516c0,
0x06c5fb23,0x0f55150b,0xf10b01ab,0xd8eee82d,0xec99d8c4,0x0907fb68,0x05900e5d,0x0d8f12c6,
0x0466f91a,0x07890aa5,0xea92fa5a,0xe1ebe964,0xf876e1d6,0x18a30afd,0x17f91ca3,0x184d2162,
0x0cdb0988,0x062a0acb,0xe80af5f4,0xd806e441,0xf57cdccd,0x09630380,0x0a8208e3,0x111b1700,
0x050b02d8,0x049f08a3,0xe70ff35c,0xdf91e62c,0xfe8de7d2,0x0a3c0587,0x0e5d0c0a,0x15cf1a83,
0x0a040708,0x02aa0ee9,0xf571f4da,0xe240f24f,0x0014eaf8,0x09bf0592,0x0d0f0b79,0x113a18d1,
0xfd9efc40,0xf90901ad,0xe94ae894,0xdf4ceb25,0x025bef52,0x0c0a0582,0x15db1062,0x165d20b2,
0x036002bb,0xfc3804cd,0xefcaea49,0xdfccec78,0xf6f6ed0c,0x05befc8f,0x15ec0ac1,0x19ad21dd,
0x0ce10c8a,0xff04095d,0xf88af2a7,0xe514f02e,0xf298f013,0x0075f938,0x0ea60340,0x108c185f,
0x00fb04fc,0xf457fb21,0xf38dee09,0xeb76ebf2,0xf7e4f6dc,0x0ab9015e,0x190d0f9e,0x189a1f3b,
0x06060dee,0xf5dbfba0,0xf69df49d,0xedd6ec41,0xf77cf58b,0x06210062,0x0f340a88,0x0d42118a,
0xfb290491,0xeec1f070,0xf0b9f160,0xf0b9eb1a,0x0459f9ed,0x107b0e47,0x1e0d1499,0x160a1f20,
0xf9010818,0xeaf7f105,0xe68ceab6,0xe6d0e1a5,0xfc4ceeb0,0x0a8905b4,0x1f6d14bc,0x1ab1224e,
0x02120dd9,0xf215f802,0xec6ef1ab,0xec23ea3a,0xfefdf0c4,0x08d10808,0x19910fde,0x10f41ae8,
0xfa7f040e,0xec50ede7,0xe635ecba,0xea3ee74b,0x0340f3b2,0x10a90dc1,0x1e731523,0x11871d9e,
0xffc50a36,0xf148f330,0xef57efaf,0xea43ecc8,0x01eaf54b,0x098307f6,0x15880ec1,0x0ccb1562,
0xf94903d8,0xf01cf16f,0xf0d8eddc,0xedb7ee3b,0x02abf75e,0x0a870aba,0x1b8f125d,0x12121a2d,
0xfd4005ae,0xf1b4f6d1,0xf297efc3,0xf194eff7,0x006ef83e,0x028d0507,0x14c00d81,0x0f6d138e,
0xfa4d02e7,0xeef1f32a,0xf285ef36,0xf476f14d,0x01c3f9f4,0x07510436,0x1744152d,0x10e5136d,
0xfe3a0711,0xed77f2b3,0xf295ef28,0xf4e6f21e,0x00b5f8f1,0x0693013e,0x0ecc1173,0x0cec0f80,
0xff7e07a1,0xefd3f144,0xf761f233,0xfbd8f924,0x061a0252,0x0b6302a5,0x0a8d1123,0x0473098d,
0xf7d301bc,0xe68ae8ff,0xf1acea05,0xfd6ef5dd,0x0a26079a,0x166e0a77,0x0f1a171c,0x09ac0e8b,
0xfa6007f3,0xe43aeb5c,0xee34e520,0xfa08f220,0x071504e3,0x13570941,0x0ee213db,0x06760ad6,
0xfc720867,0xe560ee9e,0xee18e65f,0xfd4ff365,0x07830484,0x16710db2,0x0ef0167f,0x08c609b6,
0xfa2508ab,0xe390ec5f,0xe71de254,0xf81aee60,0x05aeff7c,0x1a811069,0x11c41a1f,0x0abc0a9c,
0x00b10b51,0xe9c8f357,0xed82e929,0xf8c8f2e1,0x00bdfc82,0x15280d13,0x0991118d,0x03f1016f,
0xfd5e0537,0xea5ef1d9,0xf33aee30,0xfa37f6bb,0x0570fce6,0x176010d0,0x0bd31478,0x03ae059a,
0xfe7b0565,0xef38f222,0xf2baefd6,0xf77cf69c,0x02acf8ac,0x15830ef3,0x06811176,0x01f700b0,
0xf99d030f,0xeed0efc0,0xf635f20e,0xf9e8f88a,0x0803fe20,0x18801323,0x08c712b2,0x01b503d7,
0xf8130139,0xeef1ef86,0xf5e1f20e,0xf816f7bc,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};
