#include "Viola_samples.h"
const AudioSynthWavetable::sample_data Viola_samples[8] = {
	{
		(int16_t*)sample_0_Viola_ViolinBb2,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*0.9959648048147479*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 466.1637615180899 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1306-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1299-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1299-1) << (32 - 11)) - (((uint32_t)1205-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-950/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(27*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_1_Viola_ViolinD3,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*1.0*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 587.3295358348151 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1593-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1585-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1585-1) << (32 - 11)) - (((uint32_t)1510-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-950/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(29*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_2_Viola_ViolinG3,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*0.9971160533345892*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 783.9908719634985 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1526-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1518-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1518-1) << (32 - 11)) - (((uint32_t)1462-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-800/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(32*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_3_Viola_ViolinC4,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*0.9982686325973925*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 1046.5022612023945 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1343-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1335-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1335-1) << (32 - 11)) - (((uint32_t)1293-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-800/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(14*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_4_Viola_ViolinGb4,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*0.9833884619739165*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 1396.9129257320155 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1331-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1323-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1323-1) << (32 - 11)) - (((uint32_t)1292-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-870/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(14*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_5_Viola_ViolinC5,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*0.987943197140516*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 1975.533205024496 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1255-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1247-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1247-1) << (32 - 11)) - (((uint32_t)1225-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-650/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(19*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_6_Viola_ViolinEb5,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		11,	//Number of bits needed to hold length
		(2097152*1.013959479790029*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 2349.31814333926 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)1454-1) << (32 - 11),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)1446-1) << (32 - 11),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)1446-1) << (32 - 11)) - (((uint32_t)1427-1) << (32 - 11)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-720/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(25*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
	{
		(int16_t*)sample_7_Viola_ViolinEb6,	//16-bit PCM encoded audio sample
		true,	//Whether or not to loop this sample
		10,	//Number of bits needed to hold length
		(4194304*1.0075373584071088*(44100.0 / AUDIO_SAMPLE_RATE_EXACT)) / 4434.922095629953 + 0.5,	//((0x80000000 >> (index_bits - 1)) * cents_offset * sampling_rate / AUDIO_SAME_RATE_EXACT) / sample_freq + 0.5
		((uint32_t)817-1) << (32 - 10),	//(sample_length-1) << (32 - sample_length_bits)
		((uint32_t)809-1) << (32 - 10),	//(loop_end-1) << (32 - sample_length_bits) == LOOP_PHASE_END
		(((uint32_t)809-1) << (32 - 10)) - (((uint32_t)799-1) << (32 - 10)),	//LOOP_PHASE_END - (loop_start-1) << (32 - sample_length_bits) == LOOP_PHASE_END - LOOP_PHASE_START == LOOP_PHASE_LENGTH
		uint16_t(UINT16_MAX * WAVETABLE_DECIBEL_SHIFT(-870/100.0)), //INITIAL_ATTENUATION_SCALAR
		uint32_t(0*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DELAY_COUNT
		uint32_t(27*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//ATTACK_COUNT
		uint32_t(413*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//HOLD_COUNT
		uint32_t(28197*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//DECAY_COUNT
		uint32_t(356*AudioSynthWavetable::SAMPLES_PER_MSEC/8.0+0.5),	//RELEASE_COUNT
		int32_t(0*AudioSynthWavetable::UNITY_GAIN),	//SUSTAIN_MULT
		uint32_t(9 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), 	// VIBRATO_DELAY
		uint32_t(5711/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // VIBRATO_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-0/1000.0) - 1.0)*4, // VIBRATO_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(0/1000.0))*4, // VIBRATO_COEFFICIENT_SECONDARY
		uint32_t(383 * AudioSynthWavetable::SAMPLES_PER_MSEC / (2 * AudioSynthWavetable::LFO_PERIOD)), // MODULATION_DELAY
		uint32_t(5171/1000.0 * AudioSynthWavetable::LFO_PERIOD * (UINT32_MAX / AUDIO_SAMPLE_RATE_EXACT)), // MODULATION_INCREMENT
		(WAVETABLE_CENTS_SHIFT(-8223/1000.0) - 1.0)*4, // MODULATION_PITCH_COEFFICIENT_INITIAL
		(1.0 - WAVETABLE_CENTS_SHIFT(8223/1000.0))*4, // MODULATION_PITCH_COEFFICIENT_SECOND
		int32_t(UINT16_MAX * (WAVETABLE_DECIBEL_SHIFT(-0.1) - 1.0)) *4, // MODULATION_AMPLITUDE_INITIAL_GAIN
		int32_t(UINT16_MAX * (1.0 - WAVETABLE_DECIBEL_SHIFT(0.1))) *4, // MODULATION_AMPLITUDE_FINAL_GAIN
	},
};

PROGMEM
const uint32_t sample_0_Viola_ViolinBb2[768] = {
0x00c00062,0x01d00177,0x00d901a3,0xfd26ff1b,0xfbfffc14,0xfcc2fc94,0xfbf4fc33,0xfdbcfca6,
0xfe03fe3f,0xfe96fddc,0x035100ee,0x035d0423,0x002c01be,0x00e00025,0x002f0108,0xff46ff54,
0x018e0027,0x010d019a,0x05fe0274,0x0f010a96,0x10fa111b,0x0c9b0f37,0x04d6090f,0x0174022f,
0x01820101,0x078d03c0,0x0ea40c00,0x0f4f0f3a,0x0fcc0fa5,0x12781016,0x1875162f,0x1376177e,
0x0bb90ec8,0x055d09d6,0xfaddfee4,0xfdabfb25,0xfd54ff5e,0xf4b6f856,0xf7b4f526,0xf6f9f8f4,
0xeea2f249,0xed47eda4,0xe459ea26,0xde68df34,0xe896e1ec,0xf28bef5b,0xf007f1bf,0xf44af0e8,
0xf91bf760,0xfa98f9da,0xf9c5fb56,0xefbef4f1,0xf367ee72,0x04fefcbe,0x01c506e1,0xf3a9f975,
0xf7d1f3af,0x0112fca1,0x08990584,0x06d708f2,0x013a035d,0x089e0340,0x10010d6a,0x0e35106e,
0x0b5f0bb6,0x10330da1,0x10771179,0x0e4e0ebe,0x10940e7d,0x0e491078,0x10dd0ed6,0x0db111ac,
0x03f306f5,0x014d0299,0x00e2ffb4,0x120f07a9,0x1b891c81,0x15bb1812,0x19db16e8,0x18911739,
0x1b8f1a03,0x0dc018b2,0xfeac04c3,0xf906fda4,0xf562f495,0xf48bf784,0xdc3ae8a7,0xccb1d4bd,
0xcb9dc7b4,0xf37fdc35,0x0757040b,0xfc390411,0xe234ef03,0xdc2eda84,0xe545e1a0,0xe269e565,
0xdca0deaa,0xe018dc33,0xf2d4e8f6,0x05f5fdb5,0x0a920939,0x074e0a44,0x00670463,0xfd8efe2d,
0xfd58fdb8,0xfdabfcf5,0x05410077,0x154f0c44,0x29ef1f1b,0x3a83334d,0x387a3d5b,0x22302e24,
0x19741a84,0x18141906,0x1c6318f7,0x228f217f,0x18841e09,0x141c1508,0x180e14f0,0x22901e34,
0x1cb521ff,0x0d7714b3,0x00080756,0xf5b2f906,0xf659f5e7,0xec35f36d,0xe29fe516,0xe7a5e528,
0xe337e700,0xda98dd5c,0xd577d9ef,0xc6eecd13,0xd161c9aa,0xd345d3b4,0xdd9cd403,0xfb08ecee,
0xfebbfeb8,0x11c905df,0x1e861cad,0x11ad1801,0x06ca0a31,0xfe1a0124,0x0190fe55,0x032f0550,
0xf94efde3,0xed59f327,0xf057eb91,0xf7cdf5cb,0xfe8ff8f1,0x145d0a46,0x1682181e,0x0d091300,
0x09ef09a1,0x10eb0d91,0x104b1147,0x08950de3,0xf542ff11,0xfd31f34a,0x1f7c0e62,0x2f832a97,
0x309f317c,0x1d552a50,0xfe980d43,0xf9f5f84d,0x016dfe38,0xfe6701b3,0xf7a6fafb,0xf829f626,
0x0186fc90,0x04ea050d,0xfc6d01a4,0xf7cdf7d5,0x010cfcb9,0xfa87002d,0xed3cf353,0xe5b2e845,
0xec96e66d,0x06caf8df,0x17d811e2,0x12081786,0x03f60ab5,0xfab7fe4b,0xfa9ff8e1,0x06520084,
0xfb7e052d,0xe0d2ed4f,0xdff9dc11,0xee01e76e,0xfc60f42a,0x096f04f7,0x022707c5,0xf95efca4,
0xf43cf78e,0xeb64eee1,0xf568ee4a,0x0465fe63,0x02a8067c,0x0a6703ff,0x01060b08,0xecebf12b,
0xfaf8f30b,0x01b700e6,0x1c330c9f,0x2eda2c0b,0x240e25ea,0x31ce2b76,0x29a52f6f,0x2adb2aa6,
0x1c1227ff,0x11eb118b,0x0ab110b7,0xfcb2feb1,0xfbf9008a,0xe22fef7d,0xd370dbc8,0xc21cc641,
0xe938ce0e,0x09c3006e,0x01c6095d,0xe970f519,0xe220e21e,0xe405e45c,0xe04fe175,0xe42de29f,
0xde91e15a,0xe7e9e037,0xfa31f1ac,0x09040005,0x11d711b6,0xfff80abb,0xefd4f538,0xf134ef37,
0xfad4f4f7,0x052d006b,0x0fa40907,0x21ec18e0,0x2e92290a,0x30033263,0x161f24d0,0x11780e88,
0x14b114ba,0x1b7c160c,0x3133273f,0x2eda330a,0x1e0826cb,0x1bde1914,0x16fd1ba4,0x0b4e0f32,
0x0e7f0e97,0xfd8c08fc,0x02b8f9d5,0x1e91137e,0x061b1602,0xf9d7fbe3,0xfb54fe6d,0xfcb6fcc7,
0xfaa1fd4e,0xf04bf730,0xc7d1dcce,0xc011bbfa,0xcad2c92a,0xd14bcbc5,0xddd6d985,0xdb03dc5a,
0xe888dd1a,0x0971f9c4,0xfa9a0b6d,0xcb1fdfbf,0xbde8c091,0xc45dc073,0xdc48ce22,0xf8f3ed49,
0xf953fc88,0xff34f787,0x10ec0bac,0x01f40c12,0xf9f7fa19,0x0e9d02da,0x1fd11866,0x30372799,
0x2eab3479,0x1adb2242,0x2adb1d86,0x4a6f3cb8,0x54a9522e,0x4eb95404,0x2ea840cd,0x19a72090,
0x193518e2,0x17d517f1,0x27cc1da1,0x306c3036,0x0f722349,0xf541fe2b,0xe273ef94,0xd8bad6a7,
0xf6b3e8b2,0xe217f3b4,0xd15cd1d1,0xf40be0e1,0xf920f9c0,0x1519037a,0x23122120,0x13571cfe,
0xf6e904fb,0xdc5ae85e,0xbe27cce2,0xbed0b6f9,0xdbe7cf61,0xdec9ded2,0xe5ede281,0xd345df8a,
0xd378ccf5,0xe5dcded2,0xe668e9b5,0xcdb2db18,0xc6d2c520,0xdea4d2e7,0xefa5e7f2,0xf829f4eb,
0xf3fdf6bf,0xff83f61a,0x1e0d0e93,0x28e426fd,0x27a228bd,0x283e275b,0x296a282a,0x29672a7f,
0x2c102983,0x33f42fa4,0x42c13b43,0x47504720,0x3cf6439e,0x2d5534d5,0x1d0c25c2,0x1c2f1932,
0x16f21e1e,0x032d0a83,0x02610176,0x065a0466,0x0805077c,0x09b409fb,0xf7270081,0xed2df006,
0xe47aeba0,0xd8f9dea6,0xf3dee037,0x157108e2,0x25f41d96,0x16e61ff8,0x17d813e9,0x058513c3,
0xeab4f3f0,0xd9aee49b,0xbab0c54a,0xc7b7beb0,0xbb09c756,0xab6caf66,0xac68ab48,0xcad4b52d,
0x001ae996,0x09830a06,0xe5e5fea1,0xba4ac9d2,0xc6c4bc0c,0xd8aad07b,0xeb0be26c,0xecb3ee52,
0xfb11ef6e,0x235d0cd8,0x440638ca,0x370242cf,0x166524e8,0x164c116f,0x2dca2212,0x3285336a,
0x25ca2df8,0x23611fd3,0x4062306c,0x54e14d25,0x55195870,0x3213481e,0x16031db3,0x1a021910,
0x12c515cd,0x1be1152d,0x17b71bf4,0x16b614de,0x15b81888,0x067810a7,0xef94f969,0xe92ae85e,
0xe730e856,0xe646e242,0xf8bff111,0xf7e2fb99,0xf7b0f615,0x0516fd61,0x07780ae6,0xf6b5003b,
0xd75dea6c,0xaff5c25b,0xac7fa99b,0xb2e7b0d8,0xb3d2b32b,0xbc51b75f,0xd4e6c571,0xf829e580,
0x106307de,0xfa260af2,0xcb73e1f8,0xbeb4bff1,0xcc64c371,0xe879da8f,0xf14df028,0xf774f32e,
0x0e0e013e,0x29aa1b33,0x2cc030d8,0x1a282343,0x1f3817e3,0x35d22ad0,0x44883f1a,0x36fa413e,
0x2b5a2d22,0x46d2351b,0x60ba566c,0x61526359,0x499259d9,0x29e4373d,0x20b52317,0x1bd71f19,
0x1652188c,0x0fd2122b,0x0d040e0e,0xfe330873,0xe59af2b0,0xdca3de74,0xe5cfdef7,0xef08eae7,
0xe809ea62,0xe6ede5a9,0xf062ed7b,0xfb0df540,0x101c06cf,0x15f417e1,0xfe7a0b21,0xdd56f02a,
0xb75fc7dd,0xb424b374,0xb103b34b,0xb470b1c6,0xba43b6a5,0xd4dac208,0xf6b2e8ab,0xf523fa47,
0xdb4be988,0xc150cd0a,0xb8d1bab6,0xc62ebc86,0xe722d555,0xf706f329,0x0330fb48,0x187a0dd8,
0x27821f28,0x321d2ff8,0x278f2dbc,0x2a0825ef,0x3a3c3189,0x47304176,0x45f3494b,0x3e3240b1,
0x51414455,0x60345b82,0x59f25f6d,0x39304e2f,0x18df2419,0x101113c6,0x0f850d4b,0x1afd1488,
0x084214ee,0xfc08fd01,0xfa92fe35,0xefeaf61a,0xf107f179,0xe8f1ed05,0xe672e27c,0xf18fe8b7,
0xf86cf4ca,0x07df03e2,0x0a710ac4,0x16400efc,0x1804179f,0x0afd110e,0xe484fc30,0xb52eca95,
0xa998ae21,0xa4c9a6e9,0xab82a642,0xabfaac38,0xc458b06c,0xeb10dab0,0xf75bf577,0xe020f096,
0xbf40cc75,0xc01bbd74,0xc84ec1f0,0xe0e2d402,0xe76ce612,0xf66aeae1,0x175a07d0,0x310d240f,
0x3d163cbb,0x296133a1,0x297524be,0x33812f31,0x3e963852,0x4208435b,0x3b1e3ce8,0x4f544280,
0x5cac5978,0x5b895c96,0x4a0f56be,0x2de4399b,0x1e2624e8,0x14fc1823,0x198815f4,0x13cc1884,
0x134211cd,0x0c5b145c,0xf95c00fd,0xf981f8d9,0xe922f003,0xe46de42d,0xea2de51e,0xf1c9ef80,
0x04eafcf0,0xfb0d0142,0x0104f940,0x00d303f8,0xeba7f59c,0xd486e340,0xafc5c117,0xa6a9a8c2,
0xa479a3d5,0xad1fa821,0xad18adba,0xcb54b3d9,0xf53ce644,0xfdb5fb0b,0xeb68fa0d,0xc8d1d7ad,
0xc594c2e5,0xcb20c748,0xe22dd475,0xe841e9aa,0xf62fe935,0x1a1108ab,0x29002383,0x316d2fcd,
0x1de8292c,0x1efd17f9,0x3ee52f5f,0x49eb479b,0x3e4a470e,0x340a3583,0x4fea3e96,0x68385eb4,
0x72906fc0,0x55d86b97,0x28a93a28,0x20ce2352,0x1a461c7b,0x212f1b78,0x19752015,0x11ff1339,
0x02801055,0xea34f493,0xe10ce6c9,0xd9eada0b,0xe42cdace,0xedf8e6cf,0xf567f30a,0x035dff84,
0xf908004c,0x0af5fc12,0x0bec113d,0xf32dfc82,0xdd53ec45,0xb576c78b,0xb497b39b,0xa8b4b059,
0xace8a794,0xaf6caf32,0xd712b91b,0xfec7f2cc,0xfa85ff90,0xdc99efe4,0xb3e1c4e1,0xb68fb179,
0xb8d0b88d,0xce4ebf8d,0xd79bd779,0xe2eed66e,0x1270fac9,0x28f72067,0x2cab2f38,0x1cfb2501,
0x2390195c,0x482a3668,0x54e3523b,0x41334f0f,0x3579359e,0x5d914637,0x751f6ee5,0x7414747f,
0x543c6c26,0x2663378d,0x23b72347,0x2005222f,0x274721f2,0x0e8b1f4f,0x05f104a6,0xffb20aa8,
0xed21f48b,0xef11eff5,0xdd96e394,0xe6d8dea6,0xf454ece9,0xfa71f963,0x0faf08dd,0xfe9e083a,
0x164a0246,0x16bb209e,0xf76f02ad,0xdffef19a,0xb248c5b4,0xb458b242,0x9f16ab38,0x9b9a999d,
0x9da59db7,0xc7f0a694,0xfbefebae,0xf0d5fb61,0xce05e2f2,0xa905b72a,0xb431aaa8,0xbc3bb966,
0xd13bc363,0xd773d836,0xe4dfd66e,0x0000fe72,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_1_Viola_ViolinD3[896] = {
0xf22af42c,0xf477f50d,0x02bbf927,0x0e000a05,0x143e1088,0x15ac15b8,0x11f914ba,0x12870f75,
0x17fa1743,0x0d0c1332,0x07180989,0xfdef036b,0xfc75f893,0x0a50048f,0x0761093c,0x0e180a9b,
0x08480d3b,0x00460361,0xfd98fe13,0xfda9fd44,0x081b0138,0x0d300d25,0x0cd20c11,0x07910c9f,
0x03750379,0x0717049b,0x0d110b63,0x050f0a35,0x004a025c,0xf607fba0,0xf028f215,0xe4dcebf1,
0xe25fe0ae,0xf0a4e859,0xfcd4f804,0xfa9ffd15,0xf458f837,0xead7eee1,0xedf6eac8,0xf60af1c7,
0xfa60f8f2,0x0056fc4b,0x08040508,0x0bfa0a20,0x08cb0b0f,0x04840694,0x05c803af,0x0e7609ed,
0x168a12e7,0x0f871562,0xfee606d4,0xf860f95f,0xfbeaf96d,0x04d10020,0x085c07dc,0x035a0690,
0xfa48fdfd,0xfe41fd5d,0xf00bf7a0,0xfca1f0e1,0x007c035b,0xfd35fb4d,0x1d7d0b51,0x19561b71,
0x1d5217ec,0x31942c3d,0x2b152842,0x35143031,0x18bb2aa5,0x03b50c46,0xf7d30648,0xe262e5a9,
0xd480db22,0xc9a7d397,0xc208bd36,0xd3f0d1bd,0xe228d7bb,0xf488f0ca,0xd873e778,0xdafad781,
0xe252dbc8,0xf2f2ed71,0xecccf1d3,0xe311e63c,0xf3e1e757,0x18ec047d,0x291c250d,0x2e012dde,
0x2bfe3027,0x1cf52145,0x1ceb1fba,0x069114b8,0x00ceff2f,0xffc003c1,0xfae2f9a5,0x0b5604ce,
0x0a220d11,0x0e4409cc,0x0d471073,0x0366072f,0x08bd04fc,0x0a310a64,0x0f3a0a29,0x0daf1208,
0x042107b7,0x0a6f05da,0x0f2d0d5d,0x1a161398,0x19bf1e32,0x0a361221,0xf93a03e5,0xe617edfe,
0xdaafe368,0xbb65c7a1,0xce33c3e5,0xd098cfef,0xed9ddf12,0xf630f51f,0xfe77fa2d,0x00ebffcf,
0x137f08c1,0x1d2b1acd,0x00630f6c,0xfb37f83c,0x095702df,0x04760b59,0xfcd0fb80,0xf68cfcee,
0xe559e898,0xf788f141,0xf3f5f0e8,0x1f0a0d91,0xf9220f79,0xf9bdf5e2,0xf377f5a8,0xf316f5a1,
0xd072e3c1,0xd918cc62,0x0396edb9,0x2e95190a,0x39fe3a80,0x27223011,0x1dda22ae,0x081b13a4,
0x14f20865,0x1d3f1d2a,0x178519d6,0x0d9b1354,0x08270803,0x04c707c7,0x059d02f2,0x06ff07eb,
0x07b6081d,0xf3140077,0xe4ece8a2,0xdde4e2dd,0xd701d870,0xdc51d862,0xec9fe34d,0x0108f81f,
0x04680708,0x064c044b,0xf69401e8,0xe75fee1f,0xe4c0e18a,0xf8f9efb1,0xde5eeb17,0xec03e2b5,
0xcbbddfea,0xe28ecb86,0x1f0e0874,0x292d269a,0x35ce2e75,0x34383db9,0x271a21d0,0x1e4c22a0,
0xff2d1309,0x0b12f710,0x1e182358,0x1f311930,0x11d51e12,0xdce9f6cb,0xd0d2d46c,0xdb21cf7b,
0x0625f499,0x10a81125,0xeac902a2,0xd57ad980,0xe986dd39,0xee0ef0a8,0xdf46e893,0xd4e4d150,
0x0309e6d4,0x2a361c2b,0x22e429f3,0x0f191980,0xf6370458,0xfec7f129,0x14be0ede,0x10d914ea,
0x0b840d60,0x02270a1f,0xf718f90b,0x08d0ffef,0xfa9f040f,0x0315fb86,0xfb0304b0,0xeb9bf0fc,
0xee88ea81,0xec75eeac,0x004bf232,0x07bf0a08,0x024400ec,0x0b5e0801,0x180a123f,0x1b1e1b9c,
0x16e61895,0x00720db7,0xfe6bfb71,0xfdd9fea7,0xfad7fb72,0xe48bf2c5,0xdeafdc8f,0xf65aebb7,
0xfe80fa4f,0x054b02a0,0xf3d1ff2e,0xef9ded24,0xfab2f38f,0xfb94031c,0xf883f916,0x0181f77a,
0x27701500,0x31523058,0x1d352cc4,0xfdae09a5,0xf3b1f7e9,0xed1eeb60,0xfb4ff857,0xeab5f36d,
0xd31ce10f,0xd9f3ce9d,0x0d17f3d1,0x0ee01508,0xe9d7030b,0xbf44d40c,0xbf8db61d,0x0369de83,
0x164c0e88,0x18e31b14,0x1036166f,0x18620ec5,0x25df1fdd,0x43973160,0x410d48fc,0x38af4019,
0x14dc1f70,0x0deb16c1,0xe9eaf9a7,0xe906e669,0xd339df3c,0xe6f9d4db,0xe22deccc,0xd649d582,
0xd7b6db61,0xd49cd0b0,0xed6ae0d9,0xf8bcf533,0xfab2fa8a,0xec68f34b,0xf301eaa6,0x05fefec7,
0x15bb0f1d,0x15eb1900,0x16451151,0x16081b2d,0x0ea40c51,0x13dd1659,0x12611448,0xf466084c,
0xe9d0ed04,0xe591e86f,0xf212ea7f,0xddb7ed5d,0xdfa5d980,0xe5bee4b0,0xeae5e1df,0x1e9300f4,
0x331c3575,0x2540286a,0x208d23bc,0x1e6f199d,0x2b41283e,0x1de0274c,0x09ba1117,0x00310af4,
0xed23f0b8,0xfc19f4eb,0xe898fc62,0xc913d332,0xd791ced1,0xf77fe4b4,0x20d414e9,0x019e1bf3,
0xdd65e5fb,0xe4cadcfb,0xfee8f2de,0x10cd0b29,0x14041510,0x04a10cb2,0x07860640,0xf45afe59,
0x02e8f72c,0xf6560457,0xf35dee72,0xf2abf652,0xfa42f490,0xe4ecf494,0xdae0da56,0xe784e220,
0xf6a5f14b,0xebaef1ae,0xe008e3f4,0xecf6e281,0x01c3fb4f,0x11430708,0x20371d17,0x17f219b5,
0x23621f84,0x1abf206c,0x0ebd138e,0x15720e4a,0x1d9f1e79,0x0ccf1002,0x13401702,0xf69effc4,
0x0a10fd45,0xfa8d0932,0xe646eb93,0xe5ebe52b,0xfbf7eec3,0x1e980f44,0x205e2497,0x19271cb8,
0x08d50dd6,0x111b0de0,0x0faf1111,0x113e17d3,0xe7adf5db,0xeb90ea29,0xd7b9e1e1,0xe00cdbf1,
0xc35bd3d9,0xda1ec7bd,0xf1eee70b,0x01f2fe41,0xe800f73d,0xc4ccd5a8,0xcaa2c39d,0xe539d79f,
0x012af4b5,0xf7eeffee,0x0212f688,0x1a6211b3,0x2b3c2141,0x2e882f03,0x2f3f2fef,0x176927ca,
0x0c850c8a,0xfffb09ac,0x01aefba4,0xfd930572,0x0769f9bb,0x119d1805,0x06f50632,0x04270b95,
0xe379f248,0xfab6eaf5,0x02cb0520,0x0fa40483,0x20b7198c,0x1fdf2370,0x193e20b5,0xea900112,
0xf166e9f3,0x086cfdd2,0x0ada094a,0x151a123d,0xf71409cb,0xdbd2e9b5,0xd418d39c,0xf3abdd2c,
0x10510df8,0xe490f9c9,0xd7a6ddc8,0xc49dcd93,0xdd9bc726,0xed3aec99,0xf122ebab,0xffdcfd75,
0x0476fdd4,0x25b014ae,0x1ad62518,0xfc0f0a4a,0xebf5f503,0xe66be6a4,0x08dbf2fd,0x11ba13c8,
0x07c50ae0,0xf46b00e2,0xfa43ec36,0x128509a2,0x1f0e186b,0x1b502229,0x0ab30dde,0x053c057a,
0x0da40bf8,0x19d70de0,0x3bb72e05,0x2dd8378c,0x2cb0306b,0xfd65166d,0xfbb8f8de,0xeb9af127,
0x0453f618,0xfab50725,0xe0d9ec7a,0xd276d46c,0xf0cddf88,0xfcf7fa5b,0xeb02f83a,0xc649d898,
0xbd8cbcbb,0xd490ca8a,0xe528de6c,0xe310e7dd,0xdbf5db56,0xf582e3be,0x129508d1,0x0da41476,
0x1d790fed,0x1523218f,0x038d098a,0x0987052c,0x10780d04,0x1b461727,0x19611b2d,0x148d1979,
0x0f1a13b8,0x04f20778,0x0ebc05ee,0x107b0dd1,0x069a110c,0xffe6019e,0x0c3804ac,0x392922e8,
0x30893965,0x09fb1efc,0xdffff61f,0xddf8db43,0xede7e8a2,0x0776f786,0xfdcb0bff,0xde7ce86c,
0xcdd7d8cf,0xe180cb6c,0x1f480a1e,0xfff81827,0xccfae220,0xd95ccd25,0xe788debd,0x0ca7fe7c,
0xf7d3061a,0xeb65edca,0xef99eea7,0x020af5e1,0x0b8f0a2c,0x04ce0913,0xe6fcf24f,0xeca0eb93,
0xe1e7e82e,0x015fe8ba,0x1b101640,0x041d0c4a,0xfc88037e,0x068af86a,0x18b3151a,0x2d601dbc,
0x398e3bd6,0x35663566,0x1e572988,0x1f371c99,0x368e29c9,0x35e93cbf,0x194926ba,0xff4c1171,
0xe5d7eabe,0xe2aaeb04,0xdf39d680,0xfdbaf3bf,0xe9caf54d,0xd0b0e095,0xc7f0c58e,0xe293d79a,
0xddbae0d0,0xc112d309,0xbb8fb7cd,0xe02dca8f,0x069ef73b,0x059e09fd,0xf412ffdc,0xe44ae3de,
0x0fa1f810,0x1eca1a4a,0x1825201f,0x06200fc2,0xf517fc7f,0xea9fed95,0xef22eaca,0x0cf7fb4b,
0x08da1693,0xf4ccf5a8,0x0cd501fb,0x1d291711,0x31fe275c,0x33273360,0x3f7935af,0x32913f1d,
0x3b7a34c3,0x422a3adc,0x41864dee,0x120220c7,0xef3606b6,0xd362d7bd,0xee1be513,0xdea0e47e,
0xf789ed2f,0xdd7decb4,0xc512d42a,0xb944b848,0xd727c62e,0xe874e7fc,0xbfdfd751,0xb0abafc4,
0xccb2bb32,0xf81fe243,0x0cd40a7b,0x0ccf092b,0x04c20af2,0x10e6062e,0x16f21787,0x119314c1,
0x07000c57,0xf775fda6,0xf503f5c6,0xec8cf11f,0xefb7ea28,0x07f4fc6e,0xea1efc08,0xf18fe7a6,
0x1258017c,0x1e581a8f,0x3fd02b3b,0x403b470c,0x41693f35,0x47d84708,0x508e498c,0x63b85da6,
0x38fd527a,0x179e285c,0xf830049b,0xf48af485,0xe25ff15b,0xc9f2cee3,0xd4dbcee3,0xd289d3db,
0xcb2dd201,0xb93ac3e1,0xb080b1cb,0xb055b08a,0xb55eb0fe,0xbe7bb8e4,0xcf8ec8bf,0xe185d7e2,
0xf511eb87,0x0de301d8,0x15be130e,0x1cae184d,0x1f971f3a,0x1a8f1b0d,0x1671179f,0x0f4313de,
0xf9b50189,0x0134fd3f,0xf337f464,0xfe33fd4a,0xe2edf1c9,0xfc65e616,0x23131452,0x32cf2e61,
0x3b8239db,0x469e3e24,0x61895309,0x5a6264cb,0x504f50b5,0x3e5e4a50,0x27de3491,0x08df14d9,
0x003d043c,0xdf8ef3df,0xc61bcf5e,0xc026c45f,0xd7a3c4f5,0xdadbe2b7,0xc1b9ce0b,0xac8fb2e4,
0xb2cfb076,0xa62aae72,0xa669a29f,0xb717b098,0xcdf9bdf8,0xec4bdf49,0x0813f7b2,0x2066157f,
0x1c89227d,0x25541cce,0x22d427d4,0x1a991d7c,0x1e221b63,0x07e8183d,0x01e0fd79,0xe900fdaf,
0xec26e262,0xfc66f650,0xf4e7f5e3,0x17c20458,0x24de216f,0x2f6624bf,0x486c39d1,0x58c65448,
0x69c166be,0x5a185efb,0x42e15176,0x462b4365,0x203337e3,0x105813d1,0xebae0208,0xd83cdc8d,
0xc012d08c,0xbd5bb44a,0xd4fece09,0xd29ed528,0xa92cc185,0xa462a078,0xa681a821,0xa157a4c2,
0xa72ba387,0xb2a6ab4f,0xcf3ebe2d,0xf44be261,0x163c0220,0x2dd52ae2,0x1b6522b1,0x23e420b5,
0x1f4021e8,0x14fc1b01,0x13f8194e,0xfda908b7,0xfc16ffe0,0xe428ed0b,0x01e8f0ff,0x05860eb9,
0x0016f91b,0x23da13be,0x2a742b86,0x3b712dbc,0x5c9450cd,0x6e695ff0,0x696a7365,0x49a45978,
0x3f133eba,0x35dc44c7,0x1ed022e1,0x053f173f,0xe509eeef,0xce1ddc3b,0xb085bc39,0xcf7cbc1c,
0xdaf1dc65,0xc195d368,0xa9f8b03c,0xa4a0a5dc,0xa0aca3b3,0x963d9bc4,0x9aa29644,0xbc94a7d6,
0xefded8af,0xfaacf822,0x21520927,0x26332bab,0x29b82357,0x250b2adf,0x0e0f1931,0x1397140e,
0xfdba0c32,0x0b1102ff,0xef22030f,0xed44e9ee,0x0383fefa,0xfd7bfd3a,0x1b1f0c11,0x2a312794,
0x2c222941,0x54c23d20,0x635c5c61,0x70566f02,0x4f636629,0x36243a71,0x3ed23cfa,0x22962ef9,
0x1a4a1edf,0xe8d7033e,0xe495e603,0xbce2d3c6,0xd5fac10c,0xdacedd34,0xda53d721,0xb4fecc52,
0xa683a94e,0xabd3acc5,0x9f0ba6e1,0x9b999c0c,0xa5689aba,0xd31cb817,0xf77aeb25,0x1b2d0505,
0x300c2f5d,0x218a25cd,0x1c6f238c,0x104015b0,0x098e080d,0x030f0ac3,0xfc87fb42,0xf68f006d,
0xebede73d,0x0305f626,0xf4f00524,0xff54f21a,0x22b61181,0x2dec2cae,0x4be13953,0x5d5a5c66,
0x70b96157,0x664a729b,0x3e80517b,0x42ee3b42,0x2da83f5e,0x205e2342,0x01a115cd,0xeabeeff9,
0xd0dee27d,0xc0cdc030,0xdf2cd178,0xe63fe5dd,0xc900dde1,0xa60cb484,0xa9eaa3ae,0xa8f3ae5e,
0x99cea0ec,0x9650960c,0xb7129fd4,0xecf8d51a,0x067af8ae,0x2ae61b5d,0x25492b11,0x1f5f2354,
0x140b1a62,0x0c391157,0x07760b54,0xfb040001,0x059cfe65,0xec43f957,0xf95fee1e,0x03e50584,
0xf1b4f408,0x13da005d,0x2d5023d4,0x395c2ef1,0x5b924c81,0x61fc5c0a,0x733771ea,0x510265e6,
0x3b2d3e32,0x3e6042ee,0x22702c10,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_2_Viola_ViolinG3[768] = {
0xff4afeb7,0xfeb0fed3,0xff55ff4a,0xffbeff92,0xffd9fff0,0x000f0001,0xfff0000b,0x00750031,
0x00be00e0,0x017f009a,0x020e01c7,0x025d024c,0x031002b9,0x036e02ec,0x038e0306,0x03420271,
0x02790262,0x024c024a,0x01b301e3,0x019501bd,0x0162016c,0x017f01c0,0x01f001a8,0x027801e9,
0x02d202e2,0x02ad02df,0x03a10323,0x0372033b,0x029702be,0x028202c8,0x01b901fa,0x00d2016b,
0xffd7004d,0xff42ff25,0x0101fe03,0xff39fd43,0xfff4005b,0xeb8df691,0xefcff62f,0xe28be803,
0xf0fbe7e4,0xdcc2dfe2,0xe923e678,0x07d801ea,0x0f70082a,0x2e3c1e3b,0x2d9d3261,0x41fe2b56,
0x43dd4150,0x52645329,0x2ce3493d,0x18ec1acf,0x00c70898,0xf8dffd6c,0xcf7ce6fc,0xbca1cb6e,
0x9c14a3ef,0xe84bbacd,0xdf89f4ca,0xd52bd743,0xcc97d31a,0xd793cc50,0xe582dd6e,0xea8aee67,
0xe482e1c7,0xec41e979,0xfe06f000,0x17d60c98,0x21e4161a,0x307d2e86,0x31f32fa5,0x2e0b2cd7,
0x385338d3,0x27c02e2d,0x18b725e3,0x10b40dc9,0x186916f6,0x19b71c67,0x09a31557,0x013c04ad,
0xf7eaf82d,0x0146ffb8,0xf831f910,0x0034ffb3,0xf843f835,0xf80dfda0,0x0090f810,0x08380a4c,
0x05b704c4,0x03190558,0xf7a9febf,0xe5e8ea2d,0xf828f261,0xe0c2ecc1,0xdbe0dc43,0xecf9e19a,
0xf892f502,0xf9bef6cc,0xf36bfc73,0xef71ebfa,0xf346f3ea,0xf60ff16b,0x00b90043,0xfeeb0001,
0x01bdfdbe,0x07af05a1,0x0ecb0910,0x12cb159c,0x0bea0de7,0x11100fb7,0x137d1110,0x167816a1,
0x03650e13,0xf29bf7db,0xfe40f69b,0x00d60226,0x0165029e,0xf745feda,0xf3baf484,0xfaaafc25,
0xf912fe7e,0xf8a3fb3d,0xffc7f968,0x12ab0031,0x0d1a1299,0x25a01b8e,0x3b652d16,0x36ff3556,
0x3cff3d70,0x48893cd7,0x33914288,0x0856196e,0xfed303a1,0xe956f5cb,0xd9f8e2bf,0xb66ec5fa,
0x9b02ab3a,0xb014a18e,0xce64c598,0xc371ca0b,0xcd13c57d,0xd579d31e,0xe672df1e,0xecd5e980,
0xeadfebd5,0xf165ef3a,0xf9e2f29f,0x111402b6,0x29b2210b,0x311529f9,0x345b34a2,0x31613206,
0x385f3481,0x2581325b,0x17e41b96,0x0ae31079,0x0d5f0aff,0x1711124e,0x1232167d,0x06280c28,
0xff9b03ed,0x020efec9,0xffba0438,0x00e5fb84,0x04a50619,0x03280340,0x07b603fa,0x143c0d11,
0x144118b9,0x0f8b0f55,0x091d0ec8,0xfc6f02e6,0xf65efaeb,0xe5ecee85,0xc87ad9b7,0xbed9c0b2,
0xc8facc08,0xc981ca06,0xe118cc03,0xe3cee8a1,0xf457ef67,0x132b014a,0x19d41526,0x2c242520,
0x3a772dce,0x3fde41a4,0x18842eb7,0x12c40fcb,0x112914b3,0x09050ed5,0xe1afeeb9,0xd083dfdd,
0xd76cced8,0xfd7aee85,0xe207f5a9,0xdeccda0c,0xe229e4ca,0xe640e5eb,0xe2b4e0f0,0xeb68e764,
0xf6adf571,0xf2cbf2e5,0x1244fd17,0x2bfb2549,0x26af2549,0x2c7f28fe,0x38a633c8,0x3b03378b,
0x307d3950,0x1d40240e,0x11301909,0x042308be,0x09a80594,0x098d0bd2,0xf20900b9,0xe649ea61,
0xe827e5bf,0xeb30ed3a,0xdc4fe139,0xdfa1dd34,0xe407e164,0xe715e4a5,0xf8dded6f,0x061e04b7,
0xfa6efd13,0xfd6cf8fa,0xec1df65b,0xed1deb8a,0xeebcefe2,0xecd7efcf,0xe2c2dd40,0xf46ae82c,
0x0f270905,0x13100f0f,0x0bf70c50,0x11430cc8,0x20ca1606,0x23701d32,0x32972e48,0x2574313e,
0x149f1e4b,0x00040315,0x14ec085f,0xfa8012bf,0xd1fbe4bb,0xd346c9dc,0x0e38edd1,0x0afe18c3,
0xe420f5ee,0xdea0dc45,0xf50fe7a7,0xf0d9f73f,0xed85edf1,0xf610efea,0xf41af69a,0xf142f043,
0x055afac8,0x11cf09ac,0x110f162e,0x0b420d20,0x0d420ac2,0x135b15b0,0x0bb30ed5,0x0d250e4a,
0x055105fa,0x014d0534,0xfbcf00e9,0x0304fe5f,0x0d170a72,0xf2d2fb47,0x0280f67d,0xff9c0756,
0x068b0486,0x0f02045a,0xfe8e0e9c,0xf007ed05,0x0df7fe2e,0x1f001c69,0x0001181c,0xe6a0eb48,
0xe412e805,0xea68e0e7,0xf568f272,0xe7c4f854,0xc94ad491,0xe6f3ce8d,0xfdf5fb21,0xf6cff805,
0xf413faeb,0xebd0ecb3,0xf4ffebd9,0x1b470512,0x236e2a96,0x1ae4177d,0x28e122eb,0x37b9309a,
0x1fdf2e09,0x0f2e133d,0x13f412e7,0x058d0cd0,0xf27dfeb1,0xe37ce4d3,0xf239ebe6,0xf5c1f3e7,
0xf77fff4a,0xd33ae184,0xeea2dfc7,0x12ea048a,0xf0160a80,0xe08bdd41,0xf542e8fc,0x040406a5,
0xf2d50093,0x0053f035,0x0e7308ad,0x03ac0bc2,0xfc09f5a9,0x1cb4152f,0x05e01407,0xe0c5ed91,
0x0b17ee1f,0x14e7178b,0x026e072a,0x036e0553,0x06f3032e,0x093b046b,0x385822ed,0x0ef42eb7,
0xe0a3ee9b,0x0c8deac1,0x24592680,0xd6cbff8e,0xcf69c98a,0xef6ae460,0xee57f1b5,0xf665ee94,
0xef9df5fb,0xf943f2fe,0xf9fcfc10,0xf4dcfac8,0xf291f03a,0x066bfd79,0xefbaffb6,0xdb54dc32,
0xff8eedcd,0x086b0dbb,0xeac4f7f3,0xf64ae7ed,0x029a02fe,0x0bee01d2,0x224b1bd4,0x0bd015f8,
0x22660fde,0x3a31332d,0x1e213161,0x20781254,0x45fc362d,0x1ba14025,0xed9bf82b,0x07ddf476,
0x165c15d9,0xf0000bf9,0xbfd2ce68,0xb9bfbb08,0xf584d001,0xffc808b0,0xd4a4ea42,0xc89cc9b2,
0xe1a0d300,0xe1caea3f,0xd288d8e0,0xd31acdc2,0xe767e411,0xf8faeac4,0x04270486,0x07c5ff43,
0x1cc71439,0x028612a9,0x12bafcda,0x4afd3732,0x12a03a16,0x14c10115,0x3bf22ec3,0x460c47e8,
0x2c133736,0x28b028ca,0x18922835,0x0dc209da,0x122e19ff,0xd606f44a,0xc526c2e3,0xe2f9d874,
0xba9ad418,0xc9fbb17f,0xf5f1ed02,0xeadef11d,0xe173e231,0xf5cfeae1,0xe92ef24f,0xed87e98a,
0xe727ed19,0xdc25e25a,0xf04ce2d1,0x0715fe72,0xf598fae6,0x0797fa4a,0x0bf1101a,0xfce302ca,
0x0d7201a8,0x1cb11255,0x204020a1,0x23fd1bee,0x3ba030b9,0x4873448f,0x54a44ed4,0x30094bc0,
0x05c70e5f,0x216913de,0x11ac1eb5,0xec46025e,0xc689d3f6,0xb277bd11,0xd62fb899,0xf1f3f100,
0xd095dcd0,0xd468d06b,0xde7bda85,0xcb97d6ea,0xd6eacba3,0xd6b0d8d2,0xcfced2ae,0xc372c8e2,
0xf412d75e,0x0aff0750,0x12460e63,0x0b8d0f52,0x14f41498,0x34c72a64,0x295e3184,0x35922db7,
0x49604611,0x48634618,0x4c525197,0x521b4fd3,0x448b4fa7,0x128a2e3e,0xe7cbf916,0xe627e05b,
0xe9def359,0xc1f8d206,0x90e2a7bc,0xba749724,0xf936e89d,0xdad7e95a,0xc8bed252,0xda22c97c,
0xea42eb72,0xeac4e85c,0xe2d1e879,0xe8bae581,0xda7bdfe2,0xf072dda1,0xfa1cfaa9,0x1e280cd3,
0x018a172d,0x0107fd28,0x25141460,0x21602340,0x30cf2b2b,0x2a8c372f,0x36cc28cb,0x5d4d5207,
0x670563a2,0x46445c6f,0x113f2816,0x068a0cea,0xfbe3011f,0xeec4f9f5,0xc695d6d2,0xa05cb052,
0xc8eea7a3,0xf5cbed50,0xddd9e67c,0xd984e2b6,0xc375c792,0xcf28c967,0xe6dbdce4,0xc7a5daf5,
0xc5a1c149,0xcc35cd97,0xe195d1da,0xff7df64a,0x25c012e0,0x074618ef,0x0c5703c4,0x357a21e1,
0x300936c7,0x3aed340e,0x3d553f9b,0x3d0a37dd,0x58594cc3,0x653f5e6c,0x4c3a5f43,0x1f6a36d3,
0x03151079,0xf1d4f645,0xf640f779,0xcb1de1ec,0xa024b425,0xba0aa04a,0xef5adf23,0xcf94e09c,
0xd965d533,0xd3efd66d,0xcec5d2f7,0xe2dfd503,0xd7c3e5e4,0xcd16cb7f,0xd655d3d2,0xe2b6d978,
0xf10fecf9,0x1a1404b7,0x05151922,0x0120f8c2,0x2bd515f8,0x2fb33121,0x32192df6,0x3fb43a5f,
0x3f5f3cf9,0x594b4bcc,0x650f5fd4,0x4d045d83,0x20673702,0x04f310ed,0xeba5f3e9,0xebf6ed05,
0xc583dde2,0x96baa7ae,0xc7afa5d6,0xf472e9ce,0xd0f9e294,0xd7b2d2a5,0xd7c3d63f,0xde1cdb35,
0xe861e236,0xd463e4d3,0xc7fdc8c4,0xe2afd92c,0xe4d5e322,0xee27e262,0x1676fd49,0x09e21cf9,
0x0d0f053b,0x2d071f78,0x37403228,0x3ee13873,0x3c833a20,0x46b741bc,0x603e5488,0x5cf06268,
0x43a2524f,0x1a9f2b9f,0x07ac10ff,0xe88cf8f5,0xe3a1e2c6,0xb6cad4f8,0xa581a294,0xd314b91f,
0xe626e431,0xcdc8d788,0xcb31cb27,0xce25cb69,0xd60dd3fc,0xdb09d93d,0xc735da69,0xbcf9b55f,
0xe3cacf3b,0xe310e50f,0xf797ed85,0x14ec08f7,0x18a41498,0x2a7c1eeb,0x422f3731,0x4d4a4990,
0x43514caf,0x529947b5,0x623757b3,0x70996d69,0x4d28611c,0x229b3757,0x142119d7,0xfb160c0a,
0xd5a7e463,0xc29ed24b,0x9a32a758,0xbad7a347,0xdff8d196,0xd3fee043,0xc118cb35,0xbfa2bc27,
0xce4cc4b9,0xe18ddb4b,0xe18be76b,0xb9f9cb5d,0xd057bd83,0xf2e0ea1c,0xf840f6d5,0x03fafca7,
0x0bc7006b,0x27611bf3,0x341d2cf7,0x3f033ad0,0x427e4310,0x47b53e38,0x58204ec5,0x66e46061,
0x5fe6663e,0x2a8c4aa4,0x13681526,0x0d691340,0xe3d1f7fe,0xd238dc18,0xa6a4b907,0xb6dea54d,
0xdfffd161,0xe3afe69e,0xdd6adfc0,0xc49fd080,0xc617bf38,0xd7dace17,0xe79adf63,0xc601dbcf,
0xb7a1b8df,0xd87dc70e,0xfa08eb33,0x01c4fbc9,0xfc0ffa28,0x1e250bdf,0x35212d94,0x48743fbf,
0x4bfa4bfc,0x441f3dae,0x5f3c4fc0,0x70706c2c,0x5d5e6aa9,0x37675031,0x06e216ef,0x033e0197,
0xea2dfcf2,0xd446df1a,0x9d27b65c,0xb2519d9f,0xdcaacdac,0xdf15e0b9,0xd6cdd63c,0xcb31d516,
0xbf82c034,0xcd58c36e,0xdcd4d2c1,0xd51de588,0xc364c8be,0xd840cbda,0xf5c7e489,0x120003ff,
0x04c30f27,0x165b0aad,0x3a2a2c9e,0x53524869,0x4fa452a3,0x3d513fa2,0x5b3b4802,0x77c87225,
0x6354711d,0x3ee05623,0xfe701a04,0xf765f6b7,0xec33f7ea,0xd507e017,0x9d40bd65,0x9df09042,
0xe5cec520,0xebacf046,0xd09bde32,0xc0a2c639,0xc2acc049,0xc1fbc2ed,0xcd87c58e,0xcacfd68a,
0xbaf0c052,0xda89c68d,0xf4f1e94e,0x08c0fbbd,0x0e9812e5,0x1fa31457,0x381e2a19,0x50d844d7,
0x5a535772,0x3fbb4a5c,0x4d9d4211,0x77be6505,0x6dee79a7,0x4aeb61ac,0xfe272349,0xfd38f4d9,
0xf6620528,0xdf12e4ce,0xa73ccc4e,0x9d7e95f0,0xe1ddbe71,0xf521f46e,0xdac6e758,0xc97fd1e7,
0xc0d4c01f,0xcf99c87c,0xcda0d2d5,0xc6b9d3d7,0xbd0cbe54,0xd884c648,0xee9ee1a5,0xf4e0ef11,
0xfb25ff46,0x0f9406dc,0x2b631d4c,0x426d37a8,0x4eb647f8,0x4152485f,0x49564371,0x75f26205,
0x6a2577f2,0x50d75fd1,0x09bb2f24,0xfa20f915,0xef76fbdd,0xe003e223,0xb98cd64a,0xa34ba5cb,
0xdc32baf0,0xffd2f564,0xed94f8d3,0xd0e6e1be,0xbf56c3db,0xcafac41c,0xd327cf9f,0xcf8adaec,
0xb853bc89,0xd02cbbe5,0xf65be705,0xfa51ffc2,0xffb800b2,0x12ab0628,0x2ece1ffc,0x473a3bc2,
0x52e54e42,0x3ff74ca4,0x497b4271,0x77286167,0x6c987a9d,0x513160cf,0x09f72ff1,0xfa20f8e4,
0xed98fa3f,0x0000dd29,0x00000000,0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_3_Viola_ViolinC4[768] = {
0x02720224,0x01790179,0x015b010f,0x023001a2,0x02dc0298,0x01d50280,0x00970141,0x011300f4,
0x00be00f3,0xffe3002b,0xffbdffdf,0x00560035,0x007900af,0xffd30046,0xff02fef0,0xfed0feb6,
0xfeafff31,0xfed0fef2,0xff64fee6,0x0080ffe3,0x00b200b3,0x0020006b,0x00200010,0x00480046,
0x0046008d,0x003f0030,0x00e50027,0x0193015a,0x015a0172,0x009700fe,0x0035005a,0xffd70020,
0xff49ff66,0xff72ff43,0x000eff79,0x00c10089,0x01750119,0x01ac01bd,0x01f801e3,0x016f01d5,
0x00e50105,0x01410154,0x017601f7,0x0116019b,0x00ca00ff,0x00c400c3,0x0026003f,0xffb4ffe6,
0xffd0ff83,0x009c0035,0x00460080,0xffadfff4,0xff6cff69,0xff73ff74,0xff8aff6c,0xffd7ff9f,
0x0005ffd5,0x03040135,0x00940234,0x020f032e,0xf7080056,0xe993f849,0xed00ee7d,0x0368ed00,
0xf726f7ce,0xf141f6ea,0x1495fcf2,0x29d0270a,0x1f7a2efe,0x1fe11ca0,0x1c6316a7,0x1db51b07,
0x1def2746,0x1a40265c,0xed3afa94,0xdd3cdb09,0xeb72e771,0xf2b0f7f3,0xd4cce281,0xb1c7bcbd,
0xe5ebbbb9,0x32be1b51,0x14a6382a,0xcc8de92e,0xd640c161,0xf293e938,0xfef7fc0f,0xf731fc46,
0xe996ea46,0x0a84f584,0x3a532734,0x29f337c7,0x19db1f71,0x1a1b1be7,0x0a691551,0xf94efea0,
0x0298fe3b,0xffeb03ff,0xf2d9f77c,0xf801ef41,0x1a0005e3,0x34202e8d,0x0a402715,0xdd4eed53,
0xe948dc66,0x011ff654,0x0cff0602,0x06090cff,0xf8e200cf,0x00e5f6b9,0x1f820fda,0x19582189,
0xf6b00ae7,0xe5cdebc3,0xeb91e6ae,0xfa7df1b5,0xf913fd5d,0xde3dee7c,0xde2fd480,0x13ccf65d,
0x1dcf2034,0xf4ed0dc4,0xdc28e661,0xeb6ae033,0xf00be7da,0xf8b9f7f0,0x0e4400af,0x1c371406,
0x1de421eb,0x208821c5,0x22ef1e7f,0x25dc2686,0x063f1526,0xf041fb84,0xf212ef22,0xfddcfcce,
0xf295fb5d,0xe5afea72,0xe90ee0f5,0xf746f045,0x0c43fef0,0x0b910fbf,0xf3830354,0xe7cbec67,
0xf642eaba,0xffb3fddc,0x071d038a,0xffae056c,0xfa16f85d,0x154a0449,0x2fd8294b,0x126c26b5,
0xfa1c009c,0x0be4ff8f,0x0c5410cd,0xf6f50119,0xf2b9f34c,0xedf6f2a1,0xecc3ed76,0xfe14f5d6,
0xfe120360,0xf312fe9b,0xe463e9a1,0xe9b5db33,0xfb58f2a9,0x00fb0126,0x098302c1,0x210a1d8f,
0x18261fa7,0x10490a44,0x1d3d16da,0x1d411e7c,0x27b629b5,0x2c4f2fc8,0xfa3110f4,0xe367e589,
0xe414e370,0xdbd6e334,0xcbe4d1b8,0xcb3bcb84,0xe37ccf02,0x24140b84,0x183a2b0b,0xd75ff52f,
0xd4eac909,0xf29ee55f,0xfdb0f8fc,0xfadf004a,0xeb9bf097,0x0987f69e,0x3f32253f,0x3d084903,
0x1de52b45,0x13bb1582,0x108a115c,0x00ea0ad2,0xf6d4fa7d,0xf64af639,0xf5fdf468,0xf784f64f,
0x0380fb20,0x17000ffe,0x00ba14a9,0xd9eaeaba,0xdf90d2b7,0xe92de97b,0xf1d4eaf6,0x12c801ac,
0x1b0d1a56,0x145b175c,0x2b081ba8,0x274930ac,0x0a461d1f,0x06a60289,0x01d205a8,0xe833f367,
0xe95ce4ca,0xecbaf204,0xdccce06a,0xeeaedd52,0xf148f6b3,0xec11ecb5,0x0ee7fe03,0xedf907b4,
0xc780cd27,0xfa8de03a,0xfd130921,0xfbf2f4ac,0x11bb09c2,0xfcc90825,0x1069f9e2,0x38e32cea,
0x13052bc0,0x06060687,0x18a314ee,0x0d991287,0xfef403e0,0xf8edfb46,0xfb94f7db,0x055d04fb,
0xf67cfb2b,0x05c8f8c2,0x148112f5,0xeddb0817,0xcffbe128,0xf990dfa7,0x1c2c077d,0xfa0f1036,
0xf012f74a,0x08f0fc40,0x10840779,0x2fdc2381,0x13d3293b,0xe092f000,0x0308eace,0x0c091621,
0xf849ffed,0xf29af66e,0xd138e277,0xdd10ce7d,0x0823f8b4,0xead10215,0xd7c8d565,0xfe43e1e8,
0x03cf09f4,0xe994f5bc,0xf939eb45,0xfe65ff64,0xf9a3f8c8,0x0e40010e,0x16c81762,0x1c3e11f9,
0x3e32354c,0x27563bc4,0x00100513,0x2da2144e,0x29f93b2f,0xedea0e4d,0xce14d462,0xe652d6e0,
0x168901fe,0xfd2a1a44,0xc442d5c8,0xd851c361,0x0dd9fa2d,0x0c330ff4,0xf96b027d,0xd921e6eb,
0xe45ad58e,0xfb46ee48,0x075f0816,0x16ab10bb,0x0adf0c33,0x05a20531,0x2baf16e5,0x253e2946,
0x04681a4b,0xfcc50172,0xf85bf448,0x0702fa95,0x06d30a4a,0xf32a0213,0xe659eb31,0xefa4e56b,
0x09eefcf7,0x0302119b,0xd9a6ef45,0xc9d5cd14,0xffa2dee7,0x191108e0,0x14101d41,0xf2c108f8,
0xe96ee853,0x18d0fd10,0x33d53043,0x05ed1bf3,0xf91ef05d,0x084c0a6e,0x01c810de,0x080dfcaf,
0x08020931,0x0175058a,0xfca50018,0xf7e9fcd5,0xfbc0f8ad,0x083c054a,0xe8abfae4,0xe1b1e153,
0xf84cec67,0x007cfb9e,0x0bdd03fb,0xfa7709f1,0xfbc7f4bd,0x0d790dc8,0x047c08dc,0x00e9fc79,
0xff550858,0xecfbf20c,0x0b20f24c,0x18982206,0x00910905,0xf879f510,0x04650794,0x0fbf07f5,
0x17391318,0xfac70b62,0xeccaf03b,0xf9ebf6d8,0x0356fa25,0x0280025a,0xe89ef975,0xe032e317,
0xf560e2d0,0x0ea309d2,0x184012ea,0x033b0f3d,0xf597fa67,0x0161fdf1,0xfd50ff8d,0xe65cf16e,
0xf16ee882,0xfbd8f319,0x0afa011d,0x0ccc14bb,0x10580f8e,0x13170e92,0x15e01639,0x0aa91373,
0x0cf50843,0x06df0e11,0xf64cff61,0xebd9efef,0xf107e95c,0x01d1f6c4,0x03f3078a,0xe912f637,
0xf49ae638,0x1f4a0fd7,0x12e4259d,0xee8004a6,0xe144e2c3,0xdd96d832,0xff51eb07,0x10b0119f,
0xfc530868,0x0d1b04ca,0x1bd71877,0x10921287,0x11b50eb4,0x08b413ee,0xf91c0497,0x0549fd10,
0xf43ef93c,0xee5cec78,0xf794f569,0xf5dbf7a8,0xf0d8eedb,0xf160f43e,0x00edf828,0x16141677,
0xfb200deb,0xe33de3b4,0xec33e1c7,0xf6c1f556,0xfc03f71e,0x0af20372,0x1a071647,0x31452140,
0x28352f4d,0x09241ac5,0x089c03d8,0x17db13bb,0x05f5122f,0xdf88f141,0xd868d5e0,0xee37de8b,
0xfb77f80d,0xed00f556,0xe8b6e70f,0x10bbfd68,0x1b892594,0xf4020c54,0xd78fdead,0xec8cd58b,
0x01eefad2,0x015a094d,0xff43fcc0,0x203e11a6,0x33402cf0,0x313e2cf0,0x21fd2e2b,0x045e1440,
0xfe4403b3,0xfe0d01dc,0xd180e4d0,0xd233c653,0xefece385,0xf6a6f464,0xec90f07c,0xe0e8e86d,
0x0586ecc4,0x2bdb2953,0xeb0c1a37,0xc13cc9c7,0xf1dec87f,0x07730108,0x1f291ce4,0x1be41b66,
0x1b971ed8,0x43d73105,0x429f3d62,0x10e42bce,0x058a0a20,0x0e0d1081,0x04f00ba2,0xcc21e4b1,
0xb9a5b905,0xe02dcb72,0xfd1ef2c0,0xe396ec67,0xd100dc70,0xfd44df6a,0x28e82704,0xf5ca1acc,
0xc1dfd5e1,0xe13bc05c,0xf68beab6,0x1b650f32,0x337d261b,0x34d23a54,0x4c554451,0x4be24715,
0x1d4e358a,0x125f14cf,0x0dd61a0d,0xf96f0945,0xc7a2db41,0xba11b5a7,0xd4b3c2fb,0xefdce92d,
0xd62be111,0xc343c7e9,0x0320dacf,0x2f1f30fb,0xf41d237b,0xaf78c8b0,0xd3ddadb9,0x0030e848,
0x242a1e4e,0x290824e6,0x2aa22867,0x605a4809,0x69eb64fa,0x2d454ec5,0x062a1685,0x02a908a8,
0xfb770567,0xc315db06,0xbc18b3a5,0xe007cc3c,0xeca7ebcd,0xd709dde8,0xd26fd2cf,0x0b91e64b,
0x2e632fa8,0xe1971811,0xa84db9db,0xe417b49d,0xff42ef3a,0x17b21492,0x3b3d2737,0x3aed3cd7,
0x5fe55441,0x69c5613e,0x23a74969,0x030f0d84,0xfffb0798,0xe2f5f889,0xb6a0c656,0xb6b8af47,
0xd9d7c62a,0xfb0ced23,0xe012ebef,0xbd44c74c,0x0309d33d,0x2a6e2e84,0xe3291495,0xad5bc167,
0xe18cbe0a,0x0443e95f,0x24ec1ba0,0x3ec63056,0x45823fb1,0x69fc66ca,0x64546a98,0x26de3e0f,
0x15551a07,0x0521151f,0xe3360004,0xadb2c490,0xabc39ec4,0xe0f2c408,0xf362f4e0,0xcfa9db58,
0xc297be61,0x1072e0bf,0x291c2fe2,0xe31b1955,0xa688c168,0xe2ccbb04,0x035be9d7,0x19fd16c8,
0x3f8127b6,0x470c3fbf,0x62425e71,0x6e5b6a7a,0x316b4c7d,0x09c819fc,0xfb5b02b6,0xdfd8f831,
0xa89fbee2,0xa9b09df2,0xd5b7bf2d,0xef09eaf0,0xd70cdee8,0xc3c3c27b,0x1abfe20d,0x3e584377,
0xe2532060,0xa2d3ba60,0xe130ba20,0x04cfe8d5,0x260a2003,0x4582362d,0x3f7b3995,0x68846093,
0x784f7567,0x30464efd,0x03cb10e4,0xf1040048,0xd165ec60,0xa646b5b9,0xae0b9d84,0xd7a6c28d,
0xebefeab2,0xd6f8dc4f,0xc87ac569,0x1d58e7b1,0x352b3d20,0xe22514bb,0xae8bc1d8,0xe8e5cebd,
0x06b7e86b,0x2e0e20ab,0x4ec541d9,0x48134139,0x65ed6451,0x68bb757b,0x24263d92,0x0a8e0af1,
0xf17f01f3,0xc8c3e741,0xa21db867,0xa35a9a5f,0xd294b40d,0xef30eb15,0xcadadae8,0xc0e3b80b,
0x21cdea16,0x2b8232fb,0xe1280a5b,0xb89dcbaa,0xe80ad9c6,0x148fef02,0x2f6e299d,0x487a3dcb,
0x54d54382,0x6b966f6a,0x61397660,0x29233a19,0x11f41581,0xf7b403fe,0xce14eaf3,0x9c6fb6d7,
0xa1a796b7,0xdb06be2a,0xe515eb74,0xc6cbd047,0xc5f1b7d8,0x227eef0c,0x2f7836f4,0xdf560b24,
0xb181c12b,0xeb03d8ff,0x150df6b2,0x2f0922d3,0x5166464e,0x57e1472d,0x68206de6,0x622e772d,
0x29263a23,0x0998108b,0xefb2f901,0xc287e4e5,0x9318ac3a,0xa4998fe0,0xe0c7c1ce,0xe46eeeb9,
0xc8b6d547,0xcc16bbb2,0x26f0f089,0x349c372a,0xdd2d0bcc,0xaa26ba37,0xe556d392,0x1739f5f4,
0x32452845,0x51534b6a,0x5a6546fc,0x6be86e96,0x63be7aeb,0x25f73af7,0x05c00cc8,0xef5af73b,
0xc201e436,0x92faab66,0xa4c99029,0xe0bbc1fd,0xe559eeb9,0xcc13d881,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,

};

PROGMEM
const uint32_t sample_4_Viola_ViolinGb4[768] = {
0x0014001b,0x00150027,0x00390028,0x00450027,0x00120028,0x001b0022,0xffecfffe,0xffe6ffe0,
0xffeefffd,0x00370014,0x0093fff8,0xff980066,0x02d90135,0xf8f6052d,0xf60cf32b,0xfefdf844,
0xfecd009a,0xf251f7d5,0x0896feb9,0x0a44044b,0x167b13b2,0x111f1251,0x0d650fa9,0x0bcd0cd3,
0x15b10e2d,0x1c6617f4,0x0c3713f7,0xf10d0171,0xe94cee61,0xe984e93f,0xef7ae75b,0xde32ede0,
0xd411d719,0xef3edeaf,0x177c06a6,0x17b21a58,0x04a60cca,0xf05bf686,0xf01af472,0xfb0ef677,
0xfd52fa2a,0xfaabf9e0,0xfcf8f9f7,0x119607b7,0x1acc1983,0x12bf198c,0x06b70c78,0x05ac0471,
0xfdb80549,0xfa64fcdf,0xfedafc50,0xfe4efc58,0x0291fd17,0x11ff0bd2,0x179e1818,0x15291699,
0x057b0d7c,0xfa34fd1a,0xf824f78e,0xf252f6e8,0xf06af11f,0x0247f5c6,0x07d207ce,0xf5abfb76,
0xff75fbca,0x05d8045b,0xf922ff7a,0xfde3f5dd,0xf96cff1e,0x0528fee1,0x0c650c27,0x103e0e82,
0x08820ab6,0x0bad07c6,0x1785134d,0x14b51cba,0xf6ed08da,0xde50e2a1,0xde07dceb,0xdf98defc,
0xed47ec40,0xdffae3c9,0xf03de206,0x175100af,0x1dcb1e7d,0x137c1ed9,0xf8d70806,0xe4a6ea2f,
0xe7cddf10,0xfb2af1f3,0x00f90137,0xf758fd3c,0x060efaeb,0x10ba0f5d,0x1c161b2a,0x145815d7,
0xfc510d97,0xf78cf8ae,0x0225fa0f,0x110109f9,0x0ca014e9,0x02640485,0x16a30bee,0x20bb1d6a,
0x2c3c261a,0x25072983,0x062e14d1,0xef60f9ba,0xeba5f18d,0xe210e350,0xe7ece13e,0xd9dbe575,
0xdb7dd928,0xec86dd58,0x067dfd61,0x01c40693,0xf15ffad4,0xeb87e4bf,0xeae6eefa,0x03b7f586,
0x0b7f0bd3,0x0c170cc9,0x08140828,0x132a0dd1,0x249a1a8b,0x0eca2124,0xf41402e1,0xf06cefad,
0xec77ef7a,0xe8f6e92c,0xf3c4f6bb,0xe964ebcd,0xfaf3e9f3,0x0b120110,0x2b952244,0x1fb021d7,
0x00ec1590,0xf0e6f243,0xfc77f043,0x05a50046,0x09880a80,0x0a1d08b9,0x0b720ab8,0x0cb60c17,
0x0df00fa5,0xfbb30847,0xf85df4c0,0xefeff59c,0xe93bea8e,0xfd08f6a9,0x0b110457,0x028b03b8,
0x0a5f0c55,0xfe1301be,0x084a024b,0x0a890ad5,0xdf0af8c1,0xf2dfe411,0xf02af02f,0xff20fa70,
0x083801da,0x0c2b0a99,0x0e870cf6,0x04980e19,0xfb15028a,0x0193f5dc,0xeefcfbc0,0xe660ec81,
0xe9abe9b1,0x02e7f01a,0x04edfeae,0xfc450820,0xf597f598,0xf02ef3e4,0x0592fd1c,0xf9dbfe74,
0xfdf2f4cd,0x08ad05d1,0x1190139b,0x10c3104f,0x112e1205,0x25811a2e,0x290b288d,0x06401fba,
0xf408f936,0xf503f1e8,0xe654e8c7,0xef0def2c,0xdbbde3ba,0xeb9ee6e8,0x0c4af424,0x071f106e,
0x09e10639,0x01070809,0x02d8fedb,0xfe8e00d3,0x09d904e0,0x1a250d86,0x1b452208,0x091e1795,
0x0011f89c,0x0b6d04ed,0xe800f9b5,0xf06cec88,0xda86e56a,0xcbaccbd0,0xfca4da9a,0x0d1b0de6,
0x0eec0c2b,0x07de0f8a,0x0ed50b41,0x042102f1,0xffa20334,0xfe2402c0,0xf5e000c9,0xf46df696,
0xf45df168,0xfd1ef940,0xf1e3f67e,0xf3cdf80b,0xee98ee42,0xecdfe9e7,0x22f5fc4e,0x1dc224dc,
0x17fc2116,0x01da07b3,0x0ef60538,0x17ff0ef4,0x15ac1520,0x150716f8,0x04760f85,0xfe140309,
0x032cfe91,0xf122feff,0xdb99db77,0xd941e231,0xd7abd575,0xdea2d621,0x1bd6f498,0x20ef2823,
0x15021a42,0x0d9e0ce2,0x10e20dfa,0x12800e9a,0x12f81266,0x15b6128a,0x0eb31840,0x064010a3,
0xf1d9f4db,0xe476edee,0xca9ecf15,0xd247db74,0xd113c837,0xcc3dc9e9,0x082cdd5d,0x24961f1a,
0x20a326fb,0x0a711179,0x15670b8e,0x0e090d03,0x05a109de,0x12cb0e98,0x11b31b78,0x195d1704,
0x0b330d31,0xf99904ac,0xe93de98a,0xe696f3c8,0xd283d112,0xcd91c9e4,0x0962dbe6,0x245e2386,
0x238629ac,0x0adf115e,0x13a00a88,0x13490c72,0x09fc13a9,0x0eb90dd1,0x05201358,0xfbe4053d,
0xf093e9aa,0xf368f45d,0xdf1ae6ae,0xebd2ec92,0xde98dce6,0xd5c4d831,0x083bdd3e,0x29012870,
0x227e25c9,0x0ea113ae,0x17e90e2f,0x11d0107c,0x0d131335,0x165911ef,0x197120ac,0x099b13c6,
0xe4d7f1bd,0xdcbedfcd,0xc742cd6b,0xd3d1d2fd,0xc54dc983,0xcc86c627,0x01c0d61a,0x306d2f5d,
0x334f307d,0x1aee26ba,0x16f6159b,0x113a118a,0x0ce11419,0x212b16be,0x27512d70,0x16871e05,
0xf972015a,0xee87f6d3,0xc733d5f4,0xd91bd3e6,0xc08ac86f,0xb782b415,0xfcedca8d,0x385b314b,
0x382c3721,0x1cae2d6e,0x1a7e143f,0x11d41806,0x127318fc,0x24fb1e10,0x23672d8c,0x0cd8175b,
0xe8d9f297,0xe576eb98,0xc8f1ccc0,0xd824d2c1,0xbae0c5c5,0xb2d9ab47,0x02d6cd4f,0x3b5034c9,
0x31bf348a,0x07e91e4c,0x12bf042d,0x1093152c,0x1c4c1c3f,0x257e25d7,0x19e529b0,0x0a8011be,
0xf650f92c,0xe081f4bd,0xca0ccdb0,0xdc8ada47,0xbb42c447,0xc5c9b50e,0x205ae9ac,0x48233f48,
0x351e3e21,0x09d61c7c,0x1a75097f,0x15b517da,0x1b411c6a,0x1b691bba,0x11a21c4c,0xff760cc8,
0xed67f603,0xca34def5,0xc6d7c0f9,0xd213d7b9,0xac60bd2d,0xd528b58e,0x2f0900b6,0x54fe4cd0,
0x39dc4acc,0x0fba1d34,0x1dd411f1,0x1ced1e3c,0x2177222c,0x11a61479,0x0af41042,0x00f90617,
0xe182f672,0xbaf0d008,0xc72dbad4,0xbbc2cd40,0xa3cea7cb,0xe31cbef7,0x39c612eb,0x520f53ed,
0x27eb3ff0,0x0efc13fc,0x2608185d,0x31282e65,0x26ac3049,0x155416ec,0x138c12d4,0x05230f46,
0xd7aaeaee,0xbbecbdc6,0xc425bdba,0xadecc1a4,0xb890a5cd,0x0101db22,0x49312ba6,0x487556ac,
0x14332daf,0x08ec0a1e,0x2484191f,0x2f33305f,0x0e5223b3,0x0c10086f,0x1c7e1253,0xfe6d141f,
0xc958e510,0xc22cc2be,0xbeabbe82,0xa66babcf,0xd713b418,0x23d6faa4,0x52fc3cac,0x36e34f15,
0x0de81ce3,0x1d030c85,0x31eb2939,0x23f733ad,0xfc9e0afc,0x0433fd7b,0x142d16c1,0xe81803de,
0xbf00c794,0xc173c1ca,0xa7cfbb2b,0xb63aa866,0xfcb6d6c4,0x38c21f81,0x512e4ee1,0x246d3add,
0x0ec213d0,0x2c941c42,0x3b3437ce,0x11712b1c,0xf577f98e,0x15bfff16,0x0725195c,0xca63ee75,
0xbf78c0b8,0xb8dcbdf9,0x9f8da047,0xda8eb971,0x1ed0fe8e,0x471a371a,0x38a04b12,0x16942304,
0x1b4210fe,0x3d002fb6,0x2cfe3c49,0xf97e129f,0xfae3f009,0x1e3a1357,0xf1650a69,0xbe27cc09,
0xb59db92d,0x9c16b45e,0xb5d397f6,0xfdb7daa7,0x3ad023af,0x47af47ff,0x294d3aa1,0x175f1de8,
0x31a7205f,0x42f742d3,0x0ff72d04,0xe9faf7ad,0x154af48b,0x13232269,0xd6cafcaa,0xbd3cc65b,
0xae99b3bf,0x9882990a,0xd50db2ae,0x1c05f765,0x3f6d31f4,0x2eb33b03,0x1b5d2313,0x21a21836,
0x495e3511,0x2e3749a5,0xf1c20b5e,0xf2a5e690,0x1efc143b,0x033411ec,0xc99bdcaf,0xafadbd1f,
0x9769a632,0xb97b9ca3,0xfedfddf7,0x38bd2299,0x36ba3e6c,0x212e29ee,0x1a531ac5,0x39e12798,
0x4c074b87,0x07872e24,0xe0b7ea40,0x14fded49,0x0fcb1f02,0xe31304df,0xbf10d0e5,0xa57cb089,
0xa1c0922f,0xe0f1c462,0x2134ff8b,0x399234d5,0x20272fa9,0x18ab1bb7,0x28fb176e,0x4fdb3ebc,
0x310d51a9,0xe8df0474,0xed17df0c,0x1ecd1604,0x01760fe8,0xd582e1aa,0xa9c5bd80,0x8c479d25,
0xcc7aa212,0x054ee903,0x32c22315,0x2ebe384a,0x1ad61e63,0x16731761,0x40242a00,0x4ef951f6,
0xff142d62,0xdb6de40f,0x14ebf0ae,0x0ed61a1f,0xe16101b8,0xc109da3d,0x952daa5e,0x9f80863c,
0xed2bcaba,0x230b09cc,0x35f42f1b,0x1f6d29f9,0x1f4d1fba,0x30591c04,0x571745a8,0x2bdd50ba,
0xe249fe53,0xf080dcdf,0x1905190a,0xfeef0aa1,0xdc2be2e7,0xb096c3da,0x844e9ace,0xd2ab9fe5,
0x0feff647,0x34a5296b,0x23733389,0x1ada18d6,0x1a8a1813,0x48ab303b,0x4c865742,0xf66f2450,
0xdb3de0c1,0x15d4f08f,0xff6d106e,0xda8af291,0xbec6d7c0,0x957aae89,0xa18f828b,0xfa6ed499,
0x2d7815be,0x34463819,0x164722a4,0x1df21b38,0x38841db2,0x5e235041,0x1ffc4d44,0xdcfcf18a,
0xf5a6dafa,0x0de31a08,0xee71fb27,0xdafdd957,0xad98c035,0x8673978f,0xde58a789,0x175ffe5e,
0x3ac73115,0x1c8735a6,0x137a0ef1,0x1c2518a3,0x4fa737f1,0x4b685e67,0xed2c1ba6,0xdca9d950,
0x23affd95,0xfd1e1572,0xd9ebeb69,0xc3b4dd3b,0x95b1b024,0xaf2c8829,0x03f3e5f6,0x2a1f1766,
0x338736b7,0x0b2419a2,0x16e01199,0x3d081f23,0x5dad5376,0x143f46c6,0xd5bfe7e9,0xff56d83b,
0x11a8236a,0xe400f8e8,0xd5ffd19f,0xabf6be15,0x85848e91,0xf00eb5a8,0x1be20ac4,0x37592c13,
0x1ca83230,0x14e9106b,0x246d1b68,0x5853426b,0x40475f0f,0xe0180dc2,0xd935d605,0x261b032d,
0xf33f0f0c,0xcd02deed,0xb836ce01,0x9104ac2b,0xbea187e2,0x1362fd88,0x30ba1d5a,0x2ab134d9,
0x131016f1,0x23841c0c,0x4aea2bb5,0x620f5f83,0x078d3d4b,0xd2b0dec2,0x09d9ded6,0x099229d4,
0xd7fdee10,0xc6f7c613,0xa319af19,0x88e48acc,0x0393c718,0x219116e5,0x344f2f46,0x11d32990,
0x23780ff7,0x2f542844,0x68ad529a,0x3ab564a0,0xdcd1030a,0xe267d8a4,0x2e43119e,0xeaf30856,
0xc4bfd3a4,0xaafdc585,0x87429fea,0xc85488cb,0x16f8041d,0x2f3521b1,0x2900344f,0x0db110a6,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_5_Viola_ViolinC5[640] = {
0x01eafdb7,0xf3c6fadb,0xf8bef4e7,0x0c1aff72,0x15b51664,0x12ce16b5,0x0f101140,0x0b890d0a,
0x0aaa0be0,0x1905125c,0x2b9824a1,0x14a51f92,0xe92efcc9,0xe20ae403,0xde50e318,0xd902def2,
0xc9a5ce9e,0xd116cad4,0x0252e663,0x20fb11c1,0x1e9b2cff,0xf84509ef,0xda4ae87f,0xe062d4e5,
0xec23e40f,0xf4baf3f7,0xf666f38d,0xfcbcf772,0x12a0070a,0x2c1b2008,0x220f2b5a,0x20fe1ff4,
0x0f791883,0x01520ce8,0xf456f407,0xf3f7f6c5,0xf382f24c,0xf297f1c6,0x16ca0261,0x2673219a,
0x1eaf2315,0x0d911901,0xfbc202dc,0xe3c7f11b,0xebb0e4e9,0xf5fbf040,0xfd1afc96,0x0214fcf0,
0x0eef093f,0x0bdd0f8e,0x0610098a,0x03bb0226,0xfd9007b1,0xd21ce50b,0xd828d322,0xeb6cdfa5,
0xf185ecb4,0xfab5f504,0x11400410,0x1b5f1532,0x192419a0,0x0f131703,0xf2d101de,0xf37be74f,
0x0b1cff47,0x18fa1b07,0x16081e44,0x03af0a11,0xfb2afc47,0xed05f44a,0xea4fecc6,0xd93ce40f,
0xd6d8d23b,0xfb3aeb48,0x1bc108be,0x13751d77,0xfcd50989,0xd67eebae,0xe152d6e6,0xfb26efde,
0xff0ffeb6,0xf9d50022,0xf57af8fd,0x066cf41d,0x27771681,0x33172f4f,0x3154368f,0x1f8a2185,
0x08bc1571,0x09c807f0,0x0b200d4d,0x171a0b86,0x19e91998,0x1952216e,0x07b61264,0x01b20294,
0xe54bf5cb,0xaf95ce57,0xa85ea23d,0xd7cfbbbd,0xf821e8df,0x14520848,0x151e1485,0x0a2e0e0a,
0xf821fe62,0xf812fc49,0x0317fc06,0xfdcc020e,0xf65cf72f,0xfdf80241,0x0f99075b,0x0a2d0e9f,
0x03e30011,0x05ee07d9,0x087a0765,0xe445f794,0xe0d7df02,0xeeb4ee0e,0x0020ef73,0xfb5206e8,
0x11780507,0x0a920eb7,0x16a30f45,0x04a01919,0xfde103ee,0x0603f2de,0x08d50510,0x1d5f110d,
0x20dc24c3,0x16c91a8b,0x1b46195d,0x0c4113d4,0xe686f5d7,0xe710dcc5,0xf470f463,0x16250f59,
0x0dbc0c5e,0x094007d9,0xfce40621,0xf7a8ffbe,0xf6bcfd2f,0xd27ee0c0,0xc4bacb5f,0xe4b8d44a,
0xe929dd74,0x0a80fcae,0x206715d8,0x22bf2107,0x26e822ca,0x137e200d,0x03a90f1f,0xf038f63f,
0xec29e8c6,0xfcb7f896,0x0135feff,0xff1e0358,0x0630fa94,0xfec60968,0xe537fc19,0xcd0dd247,
0xd0a7c890,0xeeb6debd,0x20d203aa,0x253f266a,0x0ed116de,0x048f0e57,0x0a67062f,0x0b470426,
0x08820dfc,0x1a8f12f7,0x254121b7,0x15d220a8,0x0dce0bc3,0x14a11103,0x0c4d18ae,0xeecb0099,
0xcb0cd980,0xdce7cd65,0xf569ebe3,0x0265f9cc,0xf7d50146,0x09b9fc11,0x093a0e60,0x10730ea2,
0x119a15d8,0xee1907d3,0xc74cd1a3,0xda14c6f0,0x06cfe9e7,0x1bef1778,0x11e617ac,0x28e71af9,
0x30de29b8,0x2b3d3433,0x120d1bf8,0xfbc50b69,0xce05e6c0,0xaf76b18c,0xcc66bc53,0xed9ae225,
0xeee8efca,0xeda4edcf,0xfd43f5b9,0x16901222,0x324b1c91,0x0d3b2113,0xff8108e7,0xe1d3f53c,
0xdbc8db63,0xfa41ea9c,0x04d70507,0x08ad06a6,0x07040827,0x188307b7,0x2a232ee4,0x30aa23fb,
0x1ef131d3,0x00080b4e,0xed75f7ee,0xe032e680,0xdd8ddab6,0xe9fadf28,0xf9b3efa5,0x1ad10cac,
0x1f812005,0x2e492390,0x2a7c291d,0x1c823353,0xef050393,0xecbbeb56,0xd129e2e4,0xc9dacef2,
0xe240ccb4,0xfd08f040,0x18a508f8,0x1eb81e34,0x31992343,0x10a1239c,0xfae70e0f,0xe437ee63,
0xf08be9ca,0xce3be6bf,0xc752b9b9,0xd47ec6a3,0xf925eca1,0xf024f757,0xede8f087,0xf7bbe7fc,
0x192210be,0x39e83598,0x1a55283a,0x11ac0ecc,0xfcbe067b,0xef0cef44,0xf2daef24,0x0f4b05b8,
0x0cec126d,0x09c10aaa,0x182d0a59,0x294e2b56,0x41eb2ff8,0x1de92ffd,0x06900f54,0xf293ff62,
0xd222e09f,0xd4d1d984,0xde1ad95c,0xe6b2e2d4,0xf01bec62,0x02dafa92,0x1f591782,0x29d11827,
0x119b2943,0xf1dafd9f,0xe51cf0fc,0xd3b3dbcd,0xe88cda9f,0x0a11f8d5,0x157311b7,0xfc45077b,
0xff45f9ce,0x26951085,0x245022e7,0x0e692869,0xe36af5c3,0xd796e146,0xc212cdb9,0xd501c52e,
0xfaa6df9d,0x05c90280,0x0c8309a6,0x06ae0b8a,0x1b4b091a,0x11ac1949,0x15a71e8d,0xf17e02e3,
0x00faf72f,0xfa0f01ab,0xf428ed73,0x093bfaeb,0x21391ae2,0x15d81bb9,0x04090ce2,0x16db039b,
0x22a5270e,0x1cfb1e76,0xee71039b,0xf774ef4a,0xf5f2fe99,0xde0fe09d,0xe988e6f6,0xfcb9f7d3,
0xf91dfa2f,0xf74cf67b,0xf874f589,0x1ca2147d,0x2b3d1b9a,0x025a1aa0,0xf4d4f190,0xf3f9fc72,
0xd3f7df0d,0xdef9db00,0xff8bf068,0x068107a5,0x064f05cc,0x00ea0524,0x19cc1209,0x14ba0c0d,
0xf8f40c59,0xe48de843,0xf1b8ee6c,0xd841e8b2,0xf22fe4c0,0x0979f981,0x076e0e86,0x05fc03de,
0x0b3106b6,0x2fd11a61,0x2ea52e63,0x194d3545,0xe90efa92,0xf1c6e937,0xe1f5ee61,0xf8e9e554,
0x0a68ff8b,0x061b0e04,0xf194f92a,0xf42df0f2,0x1751fe1b,0x17ca1fcd,0x079d1b65,0xe25beed8,
0xf609e922,0xe251f5a9,0xe539d9ca,0x07f2f2e5,0x19fd16ff,0x1169159d,0x083b0b17,0x1b3b08b1,
0x22092aef,0x170824c8,0xdac1f6d1,0xe30ad405,0xe0c0e82e,0xe1d8d6da,0xfb91eea9,0x12530cba,
0x09180ccb,0xfe7201f5,0x0fcd01fa,0x1ca823aa,0x07f61452,0xd3ede9b4,0xdb15cca9,0xe6bae9f3,
0xdf62d802,0x0458f524,0x262e1d5b,0x1db322ed,0x0b3112da,0x10cc090c,0x25542855,0x18881d04,
0xe83efd08,0xe7b1dbdc,0xf59ff9b3,0xddcae61f,0xf405ea37,0x0d1600b9,0x0bb7118a,0x00290778,
0x0ae001d8,0x2cc920e1,0x23aa2655,0xeec40b84,0xde26da53,0xef60ee13,0xd3c1dd98,0xf0bbe2e9,
0x11a301b0,0x12ac173e,0x07ae0fd2,0x14130ac3,0x33a426d8,0x22c12b90,0xf2140dda,0xd336daf3,
0xe51cdd43,0xcba7d781,0xed4cda16,0x1186fd23,0x18361ce7,0x03cf144d,0x08180046,0x3112192d,
0x29822ffe,0xf04d1739,0xc834d57a,0xe125d0b5,0xd173dc16,0xefcddb72,0x13cdfff4,0x1cc5214a,
0x068116d2,0x0882fed0,0x33d4173f,0x2b453586,0xf68f1cf5,0xcb78da8f,0xe5d2d0ad,0xd441e1cb,
0xea7ad924,0x0ab0f8c7,0x24a120ea,0x1bde2330,0x11840d96,0x372a17f2,0x3c5b4540,0x054231d5,
0xca45e074,0xd54fc425,0xc604d4a5,0xdebeccc0,0x0319eed0,0x227818f1,0x18612050,0x08c70646,
0x325f1327,0x3f0143f6,0x05793037,0xc550dc72,0xce74bd5b,0xc416d605,0xd9b6c4f3,0xfac5e8e4,
0x23b5131d,0x24f8260e,0x0afa107b,0x2ac7147d,0x3bf04111,0x0ef63300,0xcb13e0eb,0xcdf6bf19,
0xcdfcdc2f,0xdd79ccae,0xfa4aee3d,0x21300d82,0x20d7226f,0x00fe0ab5,0x24230a6d,0x461a426e,
0x1dd83e26,0xce30ed3c,0xc964bf3c,0xc9d5d80e,0xd95cc458,0xfa8de9c0,0x1f400c1a,0x26b223b9,
0x0d8c1b36,0x2ad5149c,0x4ccf4507,0x252d4286,0xd1bbf470,0xc40fc0d9,0xca8dd53c,0xd042bd56,
0xf029e1e6,0x1bd301a8,0x2af52772,0x0d0a1fba,0x25890e71,0x544444c9,0x2edc4cd5,0xcb8af959,
0xb319b6c1,0xc063c447,0xcb0cb4a5,0xf3a6e309,0x194e04dc,0x26842564,0x05991a1b,0x18df04f3,
0x4c5c3bac,0x2fed4bab,0xcfc7f9dd,0xb4fdb87e,0xc498c79c,0xc812b507,0xf212e391,0x15dc0010,
0x2eb7274d,0x153427ce,0x19cb0e21,0x557a3eb8,0x45815a0d,0xdca80bcc,0xb1aebe0f,0xbf2ac0eb,
0xc121ae09,0xf677e22a,0x167203fc,0x31f42858,0x15502961,0x17960c39,0x56fb3e59,0x4bcd61a6,
0xdd1810bf,0xa9c9b93d,0xb805b440,0xba63a67d,0xf83ee486,0x148e0444,0x32262581,0x1a5e304f,
0x13780f91,0x515735e7,0x47f455d7,0xd6f00eb4,0xa15cb3d0,0xb75bae76,0xb113a4ac,0xf18bd9d1,
0x09b3fb50,0x2fab1e87,0x17342cb2,0x0af409a1,0x54773168,0x587c5f8e,0xe4451ef3,0xa328ba8e,
0xb9feb150,0xb36ba73d,0xfcf6de23,0x13ee07ba,0x2ef3243f,0x1fab309c,0x11e60fb6,0x56023147,
0x5ae0641b,0xe7232652,0xa1bcbcc9,0xb7cda8e3,0xa2f2a08a,0xf1d3cfec,0x076bfbd9,0x2d601b9f,
0x269a34b4,0x14c817d5,0x580831b0,0x66036d1d,0xedf73444,0xa06ebd96,0xb025a129,0x9c519c25,
0xf3e9cac3,0x0f46035a,0x2e8d1ecc,0x255e36dc,0x10fe15f5,0x54142c33,0x63ef6617,0xeda23384,
0x995abbe7,0xa62c97a9,0x90d093f8,0xef1bbf77,0x0c1f017c,0x30e41e0e,0x2f743dfb,0x152f1da7,
0x50e02a6c,0x69f6671d,0xf84a4039,0x9dd9c27f,0xa6e7972a,0x8b9d95e6,0xec20b980,0x0fdb03ca,
0x30232054,0x334a3fe4,0x13d41e7e,0x4cf0249b,0x6d2a64a7,0xfd404466,0xa0eac735,0xa68897ab,
0x88979813,0xf20eb72d,0x150209d5,0x325c2300,0x36a242df,0x1712239f,0x4c2f2226,0x6f026717,
0x01ec4bbf,0x9f16c93a,0xa02f90ec,0x81f192a0,0xec01ad27,0x12f60818,0x319b2191,0x369c42a8,
0x1659239f,0x13282024,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_6_Viola_ViolinEb5[768] = {
0xff93feb8,0xfde4fb64,0xfe2dfc67,0x12fafe5e,0x120d13e5,0x00ca05cc,0x076307c9,0x0f5f06b9,
0x08080e4a,0x0f820d05,0x1c4813ad,0x0f4413f8,0xf9d10825,0xef44ec7d,0xeda5ec23,0xe7b9ed75,
0xe0d4e5dd,0xdef9d723,0x0642f295,0x1b7a183a,0x07e714d0,0xf4bbf8f4,0xf5acf7d0,0xedc7eea1,
0xf28dee8d,0xf512f680,0xfec0f963,0xff4ffde5,0xfe00ff6e,0x0f76071c,0x13d91515,0x14371199,
0x0fbe142b,0x07630b41,0x04710497,0x00a200dd,0xf3e4fad6,0xf81ef17e,0x04d6fe22,0x12cb0e52,
0x0e6c1118,0x083808a4,0x0a4f0c22,0x00150430,0xeaecf470,0xf2e4eba9,0x03c5fb8a,0x082c06d4,
0x02b406f8,0x00ad0078,0x052f04c8,0xfece0260,0xf9e5fc3f,0xff7dfc00,0xfa4bfc3a,0xf335f6b5,
0xebd2f03a,0xf4e9e958,0x048f074b,0xfa34017d,0xf712f56d,0x00d2fe7f,0x15bb0e0d,0xfff00f72,
0xf39cf253,0xfcd1f980,0x0f2305c5,0x0ed00d22,0x14a9162b,0x23832098,0x0dee1866,0xf2c805c9,
0xedbeedd0,0xeddeea84,0xe403ebe7,0xd981e1b8,0xe2d9d259,0x1443fec7,0x1cff20e1,0xf7bb0b9c,
0xef15ecf6,0xfb5ef781,0xfd3cfd6c,0xf5cff983,0xf0d8f10c,0xff83f6e9,0x06e30263,0x077905ad,
0x12820d82,0x166913da,0x1af81a45,0xff500ed5,0x035d02f6,0x047b0103,0xffb7004b,0xf36bfb80,
0x059bf5b3,0x13340f33,0x0df110cf,0x05d70c63,0x064cfccb,0xff590e93,0xff9201d5,0xfacaf69a,
0xf6b3f7e5,0xfe2d0319,0xffd8f73f,0xf41ffc0d,0xf17ef1f6,0xefcaf152,0xe4b2e7e8,0xfe99f3c4,
0x0af707d5,0xf7d30549,0xe48deab4,0xeef9ed28,0xfacdf0bf,0x087e032f,0xf0840250,0xff1bee8e,
0x0199033f,0xf8d601dd,0xfb25f8de,0xf6f2f777,0x135c094a,0x0ec1135c,0x141e0f41,0x10311359,
0x1b9f1951,0x07680b26,0x10020878,0x120d173c,0x155c11c8,0xf1ff0128,0xed27f109,0xf49bf0cd,
0xf408f29a,0xd8a5eb03,0xf353d8be,0x18b60476,0x21fc22b2,0xff5516e1,0xf8aef3d0,0xece3f0c9,
0xeda8ef05,0xf1defaa2,0xf9a7ede7,0xf723faee,0xf068f589,0xfe75f0d7,0x0b140461,0x14fd12e8,
0x0fbe0f2d,0x0a860ac3,0x064814ba,0x01d90a69,0xed4af6ac,0xe677ddd5,0xf028f119,0xff85f5de,
0x005a00c8,0x0401fefa,0x15ea08c6,0xfb320b29,0xe714f800,0xf345eb3a,0x0cb8fd7f,0x0e890cca,
0x015f0c26,0x075bff86,0x014b001b,0xea53f2d2,0xf01aeaea,0x0061eef8,0x0eed0b8d,0x08860db3,
0x01cdfad7,0x0c6e0ba2,0x18dd1d1e,0x0ceb0fae,0x0869028c,0x03910760,0xfa1bfb6a,0xed2beeda,
0xe40ae89c,0xf87aefdc,0xf71bf87d,0xeeaaeda2,0x10ca0b56,0x1f4b18ad,0x0b631577,0xf17eff1b,
0xf597ed9c,0xea11f0eb,0xef90e87a,0xfbc4f43c,0x0a490423,0x0af90bf6,0x0ef916dd,0x173813ab,
0x0e7f0ecb,0xff770cf5,0x01e1fdcb,0xf0adf964,0xdface882,0xd892d8e3,0xe2b4d744,0x0628f75b,
0x143513cb,0x04851186,0x06eb04f5,0x08600e23,0xf871fa12,0xf9c8fac3,0xfa20f65b,0xf874f49e,
0x079a04f7,0x104a10c5,0x10c30d5c,0x04b310c8,0x044e0260,0x032305e5,0xf024fac5,0xfa85f6a7,
0xfd3af3e6,0xf40cf8e3,0x077cfd95,0x14140709,0x105418c7,0x06a11157,0x04baf90c,0x0a330d91,
0xf4020142,0xe1dfe5ea,0xe5f6dcfc,0x0c59f761,0x1cb811f0,0x21162310,0x0dca11bf,0x044d0b09,
0xef12f817,0xeb69ebd0,0xeefdf1a4,0xe2b8eab1,0xdb95dccf,0xf840e449,0x1c720ef1,0x1ed720b9,
0xfe570592,0x056d0be9,0xfbeafc9f,0xe646ebef,0xe56fea2c,0xf39beb9d,0xf4b5f526,0xef8eed1a,
0x1c35028b,0x36be2bad,0x29583373,0x1afd1cb2,0x13c31799,0xf28708e7,0xe459ea7b,0xdd88d897,
0xff4cf00c,0x063b0ba3,0x00f90099,0xfdc2009c,0x168c092f,0x17831a4b,0x09430e92,0xfaf505b6,
0xe3baee79,0xd6a9de87,0xe8dfdca7,0x044af16e,0x011a052f,0xf490f81f,0x05ddf83b,0x2cb818b7,
0x2b6033b2,0x01fa1851,0xffa300ad,0xefd3f102,0xf015f0c8,0xfdfefaeb,0xfc0dfbb0,0xfc45f9dc,
0xf344f7ca,0xf9b0f2bc,0x138e0886,0x13c81cc5,0xfccc0e1a,0xf4eef46c,0xf0adf720,0xf085ed86,
0xf35df060,0xf269f16d,0x07a5000b,0x049c0506,0x05440984,0x0fd505d5,0x1b551a50,0x072c1154,
0x0b5407dd,0x02ac0536,0xf62ffa64,0xfc60f204,0x083d0034,0x06d40c52,0xf00cfc29,0xebeced7b,
0x0429f166,0x1bd80fea,0x10a719a7,0x097e092f,0xf826febe,0xefc0f040,0xf95aed17,0xfc35fd78,
0xf497f6fb,0xf9f4f73a,0xeefaf710,0x0a7bf072,0x23ea1d22,0x229b2076,0x06d21045,0xf7670365,
0xfbbcfce0,0xed0ff4fc,0xec9ef1bc,0xe71ce748,0xf993ed69,0x15ec0b0d,0x2c442625,0x176528bc,
0x058f0bf4,0xf29cfb09,0xdf78e8a5,0xd913dd09,0xd81dd75f,0xe44ee355,0xf1a3e637,0x28c10db8,
0x4a273765,0x2fe04145,0x12141e27,0x02630734,0xf222f75f,0xdc6ee893,0xd7e0d295,0xd69fd6aa,
0xf33edc43,0x26dd09cc,0x3e3e33bb,0x31173a92,0x190a24be,0x00ec0d8f,0xe2aaf2d1,0xce19d4f8,
0xd069d283,0xcd44cc38,0xfa9ce56c,0x314b18d0,0x37f53eda,0x254c2f3c,0x1bfe1e56,0x107c1d14,
0xe338f9ff,0xce83d39c,0xc975d001,0xdafecffb,0x1230f236,0x278a244d,0x17802487,0x10af1162,
0x18d81076,0x072e1146,0xe918f796,0xd4fddcda,0xc257c66b,0xef49cb1a,0x30991154,0x350f38fa,
0x0d361e8d,0xfcda0154,0x089008b7,0xfc9b055d,0xeb98f2ee,0xe634e92e,0xdee5db37,0x0e96f57a,
0x47d5321f,0x3a724b01,0x04a920b4,0xf853f875,0xef33f755,0xd6cee08f,0xcc81cfe9,0xc087c936,
0xef5fccac,0x331c0d21,0x54114bb7,0x2f7447d9,0x0e8b1cdf,0x039b09e4,0xe3a0f534,0xd0efd9c9,
0xc139c7db,0xbf83b5c5,0x000cdd88,0x47882569,0x4ed75858,0x25eb3497,0x19611613,0x0b1a1501,
0xe7c8f87e,0xc8afd851,0xab79bbfc,0xccc9b10f,0x18bdf0a3,0x5062383f,0x371a4b9c,0x13732691,
0x15771507,0xfca30dc3,0xe5faf29c,0xc048d23e,0xaca5abab,0xe97cc9f7,0x3547122e,0x4a134e6f,
0x296039c1,0x13ae17ce,0x03a80cc5,0xf1f8f7d6,0xd9b8eac1,0xb34bc958,0xca2ab1a4,0x0a46e83c,
0x482d2fef,0x35054757,0x0fac2209,0x11121075,0x00ab0c48,0xf309fa92,0xcf63e0fc,0xb46db98e,
0xe55dc8bc,0x34970c32,0x53cb5045,0x29483cad,0x173416d6,0x0b1614e4,0xea36f786,0xd1a0e17c,
0xafafc362,0xcbd3b1f0,0x0bc5e573,0x4b173154,0x3b5b4c64,0x1b7628c2,0x0e61140a,0xf6e802ad,
0xe34eeedc,0xbce0d186,0xa289a431,0xe17ebd08,0x382b0f31,0x558653c6,0x2a083b4a,0x170a1712,
0x0f4914d6,0xfdd602e8,0xe3c9f5de,0xac00ca21,0xbaafa5f1,0x0343d8a1,0x54802fd6,0x4b3c5adf,
0x297839e9,0x1cd322ee,0xfcf80e67,0xeb0cf524,0xbfb0d6a8,0xa150a477,0xd621ba3b,0x255afca3,
0x4d534510,0x31153f32,0x1bb61f26,0x095e14c4,0xf5e1fd67,0xd9fded7d,0x9fcfbe79,0xb71d9ec8,
0xfffbd5a7,0x49462be1,0x3feb4e8b,0x251d3039,0x26cf274b,0x0c8e1bd4,0xf87d02e7,0xc38de046,
0x9547a06f,0xcb90ad28,0x29f1f85d,0x55c74c10,0x30c74303,0x247222af,0x198021da,0x0343092b,
0xe3abfea2,0xa4b1c69b,0xb1d19dc3,0xf50ccb18,0x3d621cde,0x39de46c3,0x1fc92c87,0x1b5d1d4e,
0x05f911b6,0x00840487,0xcc7dec69,0x9c97a700,0xcc0fb165,0x1f5ef52a,0x49123eb0,0x2a7a38c6,
0x20621db4,0x15831e0b,0x05630835,0xeb24020c,0xa621c93d,0xb6b89f63,0xf918d1a0,0x4869251f,
0x41695216,0x23b23044,0x21e32636,0x060b15ea,0xfd1d013e,0xc5f0e627,0x9d06a273,0xcebbb3be,
0x1f57f7c6,0x46e64032,0x269932fa,0x1ec31beb,0x16631e71,0x0726085d,0xe7a9ffee,0xa0f9c55a,
0xb30b9dab,0xf477cd19,0x3dd81b25,0x36a44826,0x1fb129df,0x1efd2364,0x0a9b1519,0x06ea0a2d,
0xc711ed39,0x9fb4a411,0xd20fb511,0x245bfca0,0x47ec4256,0x2651373e,0x23831c83,0x1752200f,
0x080007cc,0xed1805e6,0xa7a0cb1c,0xbf4ea62e,0x0028d8f6,0x425f2761,0x33594561,0x19672317,
0x13cf1835,0x01b70cde,0xff080303,0xc38ae528,0xa538a345,0xdf75c0ca,0x29ac0751,0x43d04241,
0x1e872e65,0x1e711919,0x0da717ac,0xff5efe19,0xe328fc14,0x9c91bd43,0xb9649fff,0x0a54dc18,
0x4d673361,0x36c44f38,0x1d0a263b,0x19a01f24,0x07241068,0x05dd0bc8,0xc19fe8ab,0xa3339fad,
0xdff8be9b,0x2f770cb1,0x44e8472c,0x20d830dd,0x1a7918dd,0x0ba61484,0x043a01f7,0xe581ffec,
0x9c6bbe30,0xbeeda1df,0x0e5ce1f2,0x48e732b7,0x2dcb44b9,0x17031dcc,0x10c317b1,0xfec7082d,
0x022b0663,0xc0e0e7c6,0xa38e9f05,0xe0c4bcd6,0x3b0f1216,0x51045379,0x22273529,0x195917e4,
0x0afe13ec,0x04bd00e4,0xe27cfc81,0x9ba6bd5b,0xc45ca50e,0x1a29e849,0x52313d65,0x308f4a71,
0x16171cc5,0x105a155e,0xfe760705,0xfb5a02f7,0xb183db91,0x99e9910f,0xe311ba47,0x40981709,
0x50375742,0x218e3497,0x1a081ac3,0x071a1226,0x068bffb1,0xdf20fef2,0x933cb497,0xba1e9cf2,
0x16dee293,0x590e3f48,0x37f95304,0x20292431,0x13e01d40,0xfdca043e,0xfbac06f1,0xafe1dc18,
0x9e3392aa,0xe53ebb7d,0x40021881,0x4bac543a,0x209c3007,0x1b7d19ac,0x0aaf162a,0x064002f1,
0xd922f928,0x9249ad8e,0xc084a03a,0x2109ec97,0x5d1646bc,0x35054f05,0x1d192171,0x13ee1a7f,
0x02000638,0xfbc40904,0xa791d764,0x96638b0b,0xe19eb403,0x3f62174c,0x4f2b573d,0x1f0930a2,
0x1ce11e28,0x098915dc,0x0baa0235,0xdb4a001f,0x9082ae15,0xbc089e28,0x1e48e7e5,0x5a6144e5,
0x318c4e89,0x1fae1fbe,0x18921dce,0x016d0735,0xfd440ad3,0xab32d954,0xa234928b,0xf085c1bf,
0x47d12345,0x4b155ad3,0x1b552d5a,0x135319e4,0x00220d38,0x068bfe81,0xd339f923,0x8e46a474,
0xc1c4a021,0x2458f021,0x5ddb47f9,0x2bbe4b55,0x1ebf1b6b,0x125a187e,0x010e04e1,0xfeab0e36,
0xa51bd40c,0xa37b91b1,0xf5c8c310,0x4e7e2970,0x4c476060,0x1cf12e9c,0x14be1ada,0xfe480d3e,
0x097efe44,0xd286face,0x916fa3b3,0xc310a3b0,0x2a20f5f4,0x00004e96,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,
};

PROGMEM
const uint32_t sample_7_Viola_ViolinEb6[512] = {
0xfde7ff2e,0xffebfcf6,0x09180f77,0x066b0250,0x07fe09b7,0x12670b88,0xfd950d9b,0xf116f10d,
0xe96aef60,0xf60fe23f,0x129212e1,0xf943fe40,0xf013f48b,0xf7b2f480,0x000afda7,0x0d25014e,
0x0f101144,0x050e0d86,0xff4c0110,0xf598f94d,0x0b91ff37,0x0955100d,0x05da07d0,0xed84f98e,
0x0213f4af,0x048d06f8,0x05b802e6,0xfacd00db,0xfaa3fbd9,0xf237f695,0x033df05d,0xfade0427,
0x0671fba1,0xfb800d8c,0xfef2f3cc,0x0d4208eb,0x1b61137b,0xfc2c10e7,0xee49ef4b,0xe509ec71,
0xfc2fdef0,0x10db1b9e,0xf609f671,0xf9b4fbb2,0xf253f3ab,0x055ffe8f,0x0f610939,0x14d61372,
0xfd080638,0xfe4bff1a,0xf986fa0a,0x112d0c6f,0x02cf0c50,0x00dc0474,0xf6c7f9bb,0xfeaafaae,
0xfc61ff44,0xf541f6c3,0xf511ebe1,0x0118053d,0xeff7ef15,0x02ebf58c,0xf4ad04ad,0x009fff00,
0xf7e6fa7b,0x0c14fc1a,0x0d800f7f,0x12e01168,0x060508c5,0x0d710e1f,0xf251018f,0xf8e1f3cb,
0xe379f1e4,0x16ecf841,0x012917d7,0xf24cf60e,0xf659f2bb,0xfc86f5b3,0xf8a0f589,0x0e9605a0,
0x08cb0da4,0x064a0a2f,0xea47fc45,0xf651ed3b,0x012dff38,0x0dfa03b3,0xefd80293,0x017bf12a,
0x05920b06,0x047601cf,0xefb6f7ac,0x040ff43a,0x00e00b19,0x108e01bf,0x07ef1344,0x02d20562,
0xf0acf8cb,0xf541ea44,0xf35cfa7b,0x16a7071a,0xff55136f,0xf294f2ce,0xf1b0ec56,0x0865ff8b,
0x114d0e4f,0x0c3e1143,0xfc090189,0xe71af517,0xe386e042,0x1264fc3c,0x04fa0f2f,0xfe1c09a0,
0xf7d6f651,0xfc2ff58d,0x0eda0a8a,0x087a104a,0x01a2029c,0xf46ff479,0xf883f8b1,0x0c79ff97,
0x0ef81447,0x05b2ff5c,0xee740189,0xef23e1e9,0x1aff0849,0x0f3b1b04,0xf412055d,0xef7debfd,
0xe218e943,0x0ea8ee3d,0x0cdc1fd4,0x01e30597,0xe7b8f0b0,0xf486e8c5,0xf8ccf56a,0x2f0b17f6,
0x154323fb,0xfa0c0dcf,0xdef2e5f5,0x0977f2f7,0x04ba06e7,0x1562099c,0x01220cae,0xe3b3f3b7,
0xed5bdf86,0x06960459,0x029cfc52,0x23941c55,0xfa5f081a,0xf0b8f3d4,0x0071fc0b,0xfe03ffc4,
0xfed8f67d,0x0cc90fd1,0xf682fa29,0xf45ef505,0xf850f6bd,0x05dd02d9,0x05af035b,0x0c0d12d7,
0x06ad053e,0xf76cfd83,0x084efe32,0xf32601c1,0x01e2efd5,0x0f481405,0xfd70062f,0xf5a4f18a,
0xf6dffccf,0xf76af9a5,0x14acf73e,0x12ec1d88,0xfbed01df,0xf1baf78f,0xecabee0a,0x134bfaec,
0x1a5823dc,0xf9050683,0xdfa4e83e,0xe63fdd03,0x08c0ed29,0x39a52fcb,0x099820ba,0xed01faff,
0xdabcdd1b,0xf42fdf74,0x348b1dc6,0x1a182f77,0xec1c04f7,0xd4b1d59a,0xe714d4d0,0x354b1406,
0x1dba30de,0x02c8163a,0xd0e3de50,0xe078d216,0x289a0c3f,0x12eb2043,0x07e910d6,0xdbd5ee61,
0xd42ccd2c,0x341d0a8b,0x0ca72a6d,0x038503a5,0xe732f2a2,0xe37ee1fd,0x3a84093b,0x16f53efd,
0xf47afc87,0xd0afdd5c,0xd453cac8,0x3e1a07db,0x27a548a7,0xfc250e07,0xcf1ddef0,0xc8c8c2d0,
0x394cfaeb,0x2ece4ec7,0x0c171819,0xd315eddd,0xbb9cbd51,0x2e17eda5,0x32034b9d,0x0d821809,
0xdc28f394,0xb79cbf9d,0x299fe766,0x35974abf,0x08611b5a,0xdfc8f03e,0xba80c523,0x239be4ab,
0x31a647c7,0x0d731758,0xe5eff85e,0xbc03ca41,0x254ee1cd,0x38484f2c,0x111c1d56,0xd8aaf0bd,
0xb851bf73,0x2356e25f,0x38ab4a7c,0x0c041f2e,0xdb28f062,0xabd9ba12,0x280cdb99,0x39fd5165,
0x131c1f6d,0xe89bfb07,0xadd6c477,0x1f71d533,0x468b5412,0x18282ce8,0xdfd8f705,0xa91ebb02,
0x176dd2e1,0x3f2a490f,0x140a2732,0xe257f737,0xa53eba1b,0x1ac0d148,0x3f074b85,0x22b92dca,
0xea4603dd,0x9f7cbd81,0x1690c76e,0x41824ef5,0x21112c9f,0xeddf0346,0xa390bfeb,0x0e3ac85f,
0x3c0f4294,0x1bd52a1f,0xf1d901f9,0xa323c535,0x0e76c7b5,0x3a90434a,0x1f6f29ed,0xf3400431,
0xa4bbc34e,0x11cecb32,0x3fd74a45,0x220e2ec7,0xef4c02d2,0xa1e1c091,0x0ea2c911,0x36c241eb,
0x204a28f0,0xf2ce05da,0xa1e6c015,0x0b00c7ac,0x391a412e,0x20b82c7b,0xf77407d4,0xa2aec366,
0x10e5caf6,0x374d4317,0x22912a9c,0xf749064d,0xa877c4fe,0x1383d091,0x34bd4163,0x188a2564,
0xf20301de,0xa727bffe,0x1749d53d,0x30c24081,0x1b692647,0xf038fe7e,0xa264bc29,0x1d04d208,
0x370049d9,0x1b742914,0xf6e105e9,0xa49dbf7f,0x1bf9d631,0x325f437b,0x18082533,0xf31a0094,
0xa40abc90,0x1ec2d6fd,0x30004401,0x142e2377,0xf436ff96,0xa4c6bf8a,0x237fd6cf,0x34d44d77,
0x16aa23d3,0xf0daff73,0xa626bb19,0x2826dd14,0x30e14a8f,0x127421b0,0xede1fdda,0x9d0eb3cd,
0x28f4d843,0x34c34f91,0x13df2559,0xf118fdd5,0x9f3bb4ed,0x2918d7a4,0x377f5183,0x13472965,
0xee31fd05,0x9ea4b27b,0x29a0da21,0x32e14d81,0x167a25f1,0xec97ff6b,0xa095afb7,0x30c1de98,
0x3563523a,0x12fd2773,0xed18ff54,0x985dac55,0x2a16d62a,0x33fb503a,0x15f72814,0xf0b4ffaa,
0x9e44af7f,0x2ee9db29,0x33e35183,0x15792a1a,0xedebff90,0xa026aeea,0x3205e173,0x31215058,
0x0df52374,0xeb29fb8b,0x9fa6a8fc,0x33eee0f9,0x30895144,0x108b2749,0xeda3ffd9,0xa0dcaaee,
0x37f9e504,0x31e05397,0x0b632457,0xe80ff8c1,0xa304a640,0x3ae2e6cf,0x33ca544a,0x0c3f2825,
0xe798fcb6,0xa33fa635,0x3b5ce9a4,0x2e615126,0x09e02344,0xe748f976,0xa388a36f,0x3f40eb73,
0x2faa5252,0x09e225ba,0xe2abfa19,0xa8dea382,0x4595f3e0,0x32e2589d,0x082823f0,0xdd85f835,
0x9f7997e5,0x4572ee57,0x2f445449,0x051223e0,0xdda7f763,0xa09e97e5,0x4a22f245,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,
};
