% Talkie library
% Copyright 2011 Peter Knight
% This code is released under GPLv2 license.
%
% Quantise model coefficients, and generate bit codings

function [pitchq,energyq,kq,fields]=lpcQuantise(pitch,energy,k)
    fields = zeros(1,13);
    energyList = [0,2,3,4,5,7,10,15,20,32,41,57,81,114,161] / 255;
    err = 9999;
    for b = 1:length(energyList)
        if err > abs(energyList(b)-energy)
            err = abs(energyList(b)-energy);
            energyq = energyList(b);
            fields(1) = b-1;
        end
    end
    
    fields(2) = 0; % Repeat field
    
    pitchList = [0,500,471,444,421,400,381,364,348,333,320,308,296,286,276,267,258,250,242,235,229,222,216,211,205,200,195,190,186,178,170,163,157,151,148,140,136,131,127,121,116,113,110,104,101,99,94,92,87,84,81,78,75,73,70,67,65,63,60,58,56,54,52,50];
    err = 9999;
    for a = 1:length(pitchList)
        if err > abs(pitchList(a)-pitch)
            err = abs(pitchList(a)-pitch);
            pitchq = pitchList(a);
            fields(3) = a-1;
        end
    end

    coefficientsq(1) = 1;
    
    k1List = [-0.978515625,-0.97265625,-0.970703125,-0.966796875,-0.962890625,-0.958984375,-0.953125,-0.94140625,-0.93359375,-0.92578125,-0.916015625,-0.90625,-0.896484375,-0.8828125,-0.869140625,-0.853515625,-0.8046875,-0.740234375,-0.66015625,-0.560546875,-0.443359375,-0.556640625,-0.158203125,0,0.158203125,0.306640625,0.443359375,0.560546875,0.66015625,0.740234375,0.8046875,0.853515625];
    err = 9999;
    for c = 1:length(k1List)
        if err > abs(k1List(c)-k(2))
            err = abs(k1List(c)-k(2));
            kq(2) = k1List(c);
            fields(4) = c-1;
        end
    end

    k2List = [-0.640625,-0.58984375,-0.53515625,-0.474609375,-0.41015625,-0.341796875,-0.267578125,-0.19140625,-0.11328125,-0.033203125,0.046875,0.126953125,0.205078125,0.28125,0.353515625,0.421875,0.486328125,0.544921875,0.599609375,0.6484375,0.69140625,0.732421875,0.767578125,0.798828125,0.826171875,0.849609375,0.87109375,0.888671875,0.904296875,0.91796875,0.9296875,0.98828125];
    err = 9999;
    for d = 1:length(k2List)
        if err > abs(k2List(d)-k(3))
            err = abs(k2List(d)-k(3));
            kq(3) = k2List(d);
            fields(5) = d-1;
        end
    end

    k3List = [-0.859375,-0.7578125,-0.6484375,-0.546875,-0.4375,-0.3359375,-0.2265625,-0.125,-0.015625,-0.546875,0.1953125,0.296875,0.40625,0.5078125,0.6171875,0.71875];
    err = 9999;
    for e1 = 1:length(k3List)
        if err > abs(k3List(e1)-k(4))
            err = abs(k3List(e1)-k(4));
            kq(4) = k3List(e1);
            fields(6) = e1-1;
        end
    end

    k4List = [-0.640625,-0.53125,-0.421875,-0.3125,-0.203125,-0.09375,0.0078125,0.1171875,0.2265625,0.3359375,0.4453125,0.5546875,0.6640625,0.7734375,0.8828125,0.984375];
    err = 9999;
    for f = 1:length(k4List)
        if err > abs(k4List(f)-k(5))
            err = abs(k4List(f)-k(5));
            kq(5) = k4List(f);
            fields(7) = f-1;
        end
    end

    k5List = [-0.640625,-0.546875,-0.4609375,-0.3671875,-0.2734375,-0.1875,-0.09375,-0.0078125,0.0859375,0.1796875,0.265625,0.359375,0.4453125,0.5390625,0.6328125,0.71875];
    err = 9999;
    for g = 1:length(k5List)
        if err > abs(k5List(g)-k(6))
            err = abs(k5List(g)-k(6));
            kq(6) = k5List(g);
            fields(8) = g-1;
        end
    end

    k6List = [-0.5,-0.4140625,-0.328125,-0.2421875,-0.15625,-0.0703125,0.0234375,0.109375,0.1953125,0.28125,0.3671875,0.453125,0.5390625,0.625,0.7109375,0.796875];
    err = 9999;
    for h = 1:length(k6List)
        if err > abs(k6List(h)-k(7))
            err = abs(k6List(h)-k(7));
            kq(7) = k6List(h);
            fields(9) = h-1;
        end
    end

    k7List = [-0.6015625,-0.5078125,-0.4140625,-0.3203125,-0.2265625,-0.1328125,-0.0390625,0.0546875,0.1484375,0.2421875,0.3359375,0.4296875,0.5234375,0.6171875,0.703125,0.796875];
    err = 9999;
    for w = 1:length(k7List)
        if err > abs(k7List(w)-k(8))
            err = abs(k7List(w)-k(8));
            kq(8) = k7List(w);
            fields(10) = w-1;
        end
    end

    k8List = [-0.5,-0.3125,-0.125,0.0546875,0.2421875,0.4296875,0.6171875,0.796875];
    err = 9999;
    for x = 1:length(k8List)
        if err > abs(k8List(x)-k(9))
            err = abs(k8List(x)-k(9));
            kq(9) = k8List(x);
            fields(11) = x-1;
        end
    end

    k9List = [-0.5,-0.34375,-0.1875,-0.03125,0.125,0.2890625,0.4453125,0.6015625];
    err = 9999;
    for y = 1:length(k9List)
        if err > abs(k9List(y)-k(10))
            err = abs(k9List(y)-k(10));
            kq(10) = k9List(y);
            fields(12) = y-1;
        end
    end

    k10List = [-0.3984375,-0.2578125,-0.1171875,0.03125,0.171875,0.25,0.4375,0.6015625];
    err = 9999;
    for z = 1:length(k10List)
        if err > abs(k10List(z)-k(11))
            err = abs(k10List(z)-k(11));
            kq(11) = k10List(z);
            fields(13) = z-1;
        end
    end