// Talkie library
// Copyright 2011 Peter Knight
// This code is released under GPLv2 license.
//
// The following phrases are derived from those built into the
// Acorn Computers Speech Synthesiser add-on from 1983.
//
// A male voice with an RP English accent, voiced by Kenneth Kendall.
//
// Due to the large vocabulary, this file takes up 16Kbytes of flash.
// To save space, just copy and paste the words you need.

#define ACORN
#include <Talkie.h>

#ifdef ACORN
const uint8_t spPAUSE1[]    PROGMEM = {0x08, 0x14, 0xC1, 0xDD, 0x45, 0x64, 0x03, 0x00, 0xFC, 0x4A, 0x56, 0x26, 0x3A, 0x06, 0x0A};
const uint8_t spPAUSE2[]    PROGMEM = {0x08, 0x14, 0xC1, 0xDD, 0x45, 0x64, 0x03, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x4A, 0x46, 0x51, 0x39, 0x79, 0x15, 0x0A};
const uint8_t spTONE1[]     PROGMEM = {0x8D, 0xF2, 0xDE, 0xDD, 0xDD, 0x93, 0x74, 0xAA, 0x53, 0x9D, 0xEA, 0x54, 0xA7, 0x3A, 0xD5, 0xA9, 0x4E, 0x75, 0xAA, 0x53, 0x9D, 0xEA, 0x54, 0xA7, 0x3A, 0xD5, 0xA9, 0x4E, 0x75, 0xAA, 0x53, 0x9D, 0xEA, 0x54, 0xA7, 0x3A, 0xD5, 0xA9, 0x4E, 0x75, 0xAA, 0x53, 0x9D, 0xEA, 0x54, 0xA7, 0x3A, 0xD5, 0xA9, 0x4E, 0x75, 0xAA, 0x53, 0x9D, 0xFA, 0x4A, 0x26, 0x51, 0x39, 0x79, 0x15, 0x0A};
const uint8_t spTONE2[]     PROGMEM = {0x4D, 0xF1, 0xDE, 0xDD, 0xDD, 0x93, 0x74, 0xA5, 0x2B, 0x5D, 0xE9, 0x4A, 0x57, 0xBA, 0xD2, 0x95, 0xAE, 0x74, 0xA5, 0x2B, 0x5D, 0xE9, 0x4A, 0x57, 0xBA, 0xD2, 0x95, 0xAE, 0x74, 0xA5, 0x2B, 0x5D, 0xE9, 0x4A, 0x57, 0xBA, 0xD2, 0x95, 0xAE, 0x74, 0xA5, 0x2B, 0x5D, 0xE9, 0x4A, 0x57, 0xBA, 0xD2, 0x95, 0xAE, 0x74, 0xA5, 0x2B, 0x5D, 0xF9, 0x11, 0x5A};
const uint8_t spTHREE[]     PROGMEM = {0x08, 0xA8, 0xC2, 0x8C, 0x02, 0x04, 0x68, 0x2A, 0xDC, 0xF9, 0x51, 0x5B, 0x96, 0x79, 0x8D, 0x10, 0xE5, 0xCA, 0x2E, 0x9A, 0x76, 0x72, 0xD0, 0xC2, 0x5C, 0x25, 0x21, 0x23, 0xCD, 0x0C, 0x4F, 0xD4, 0x22, 0x7A, 0x46, 0x34, 0x3E, 0xF1, 0x48, 0x86, 0xD2, 0xB1, 0xEA, 0x24, 0x33, 0x16, 0x62, 0xE7, 0xAA, 0x55, 0xAC, 0xD4, 0x04, 0xD5, 0x8D, 0x47, 0xB3, 0x53, 0x33, 0xE4, 0x2C, 0x69, 0xED, 0x4E, 0x81, 0x30, 0x53, 0xA7, 0xF5, 0xBB, 0x14, 0x43, 0xF4, 0x92, 0x36, 0xEC, 0x92, 0x04, 0xD5, 0x4B, 0xD2, 0xB8, 0xAB, 0x23, 0xF4, 0x34, 0xCE, 0x63, 0x19, 0x57, 0x73, 0x84, 0xAE, 0x26, 0x69, 0x9C, 0x8D, 0xC0, 0xAB, 0x6B, 0x87, 0xB1, 0x7B, 0x94, 0x99, 0x8A, 0xF2, 0x5A, 0x66};
const uint8_t spEIGH_[]     PROGMEM = {0x23, 0x1E, 0xC5, 0x58, 0x33, 0xA7, 0x9E, 0xA0, 0x6A, 0xF1, 0xAD, 0x9E, 0xB2, 0xE2, 0xEE, 0x49, 0xAB, 0x3A, 0xCA, 0x2A, 0x66, 0x72, 0x94, 0xE9, 0xDA, 0xBB, 0x0A, 0xC3, 0x30, 0x8C, 0xB5, 0x1D, 0x5B, 0x4C, 0x42, 0xB9, 0xBB, 0x88, 0x6C, 0x00, 0x80, 0xFF, 0x4E};
const uint8_t spNINE_[]     PROGMEM = {0xA1, 0x4A, 0x4C, 0xF4, 0x31, 0xDD, 0x85, 0x32, 0x71, 0xB6, 0xC7, 0x74, 0x57, 0xF2, 0x4C, 0x4D, 0x1F, 0x33, 0x79, 0xCB, 0x1A, 0x48, 0x3E, 0xD6, 0xFA, 0x27, 0xE9, 0xB2, 0xD5, 0xC4, 0x1B, 0x9D, 0xB8, 0xD9, 0x4B, 0x17, 0x4F, 0x74, 0xD2, 0xAE, 0x6E, 0x42, 0x3C, 0xD1, 0x29, 0xA7, 0xE9, 0xAA, 0x90, 0x54, 0xA7, 0x9A, 0xBE, 0x3D, 0x52, 0x5A, 0x9D, 0x66, 0xC5, 0x51, 0x49, 0x6B, 0x74, 0xDA, 0x95, 0x46, 0x30, 0xA2, 0xD1, 0xE8, 0x66, 0x2E, 0xE4, 0xCA, 0xCA, 0x6D, 0x58, 0x21, 0x89, 0x3A, 0x23, 0x87, 0x21, 0x73, 0xB5, 0x71, 0x4D, 0x6A, 0x86, 0x20, 0x2C, 0xCE, 0xCD, 0xC9, 0xFF, 0x41};
const uint8_t spACORN[]     PROGMEM = {0x23, 0x9B, 0x35, 0x85, 0xD3, 0x96, 0x9C, 0x64, 0xD6, 0x12, 0x0A, 0x5F, 0x7C, 0xA2, 0x95, 0xD6, 0x30, 0x6C, 0xF1, 0x89, 0x56, 0x18, 0x86, 0xCC, 0x45, 0x2B, 0x5A, 0xA1, 0x11, 0x2B, 0x1B, 0xB7, 0x68, 0x34, 0x06, 0xCF, 0x9E, 0x94, 0xB2, 0x91, 0x19, 0x32, 0xAB, 0x96, 0x2A, 0x84, 0x72, 0x77, 0x11, 0xD9, 0x00, 0x0A, 0x08, 0x51, 0xC9, 0x02, 0x25, 0x8F, 0x6D, 0x54, 0x4D, 0x66, 0xB6, 0x22, 0x86, 0x09, 0x33, 0xDA, 0xD5, 0xDA, 0xE8, 0x2A, 0xD3, 0xB0, 0x4F, 0xEB, 0x92, 0xA9, 0xCA, 0xA0, 0xBC, 0x6D, 0x48, 0xA6, 0x2A, 0x83, 0xF2, 0x95, 0x29, 0xD9, 0xEC, 0x34, 0xEC, 0x9B, 0xE6, 0x90, 0xAA, 0x5D, 0x78, 0x73, 0x98, 0x63, 0xC9, 0x74, 0xD6, 0x57, 0x6E, 0x8E, 0xCB, 0x42, 0x6C, 0x66, 0xB9, 0x29, 0x0D, 0x4B, 0xE6, 0x8E, 0x1B, 0xC6, 0x94, 0x2C, 0x84, 0xA2, 0x73, 0x98, 0xB2, 0x71, 0x0B, 0xF0, 0xCC, 0x6E, 0x4E, 0x3A, 0xD4, 0xD8, 0xB3, 0xAA, 0xB9, 0x68, 0x33, 0x23, 0xD5, 0xF2, 0x25, 0x51, 0x15, 0x31, 0x41};
const uint8_t spCASSETTE[]  PROGMEM = {0x06, 0x68, 0x86, 0x65, 0x84, 0x55, 0x8B, 0x74, 0xB9, 0xAD, 0x13, 0xB5, 0xEC, 0x1A, 0x16, 0x8D, 0x4F, 0xD6, 0xC3, 0x68, 0x98, 0xB4, 0x3A, 0x79, 0x77, 0xA5, 0x69, 0xB6, 0xBA, 0x14, 0xD5, 0xAB, 0xB9, 0x75, 0x29, 0x04, 0x2C, 0xA4, 0x86, 0x80, 0x83, 0x23, 0x10, 0x70, 0x99, 0x3B, 0x03, 0x3E, 0xCB, 0x64, 0xC0, 0x67, 0x91, 0x02, 0xB8, 0x2A, 0x42, 0x01, 0x4B, 0x95, 0x2D, 0xB7, 0x59, 0x97, 0xD2, 0x58, 0x7C, 0xA2, 0xEE, 0x52, 0xC2, 0x7D, 0xF1, 0xC9, 0xBA, 0x2F, 0x09, 0xB7, 0xD5, 0xA7, 0xEA, 0x3E, 0x25, 0xDC, 0x57, 0xA7, 0xA6, 0x19, 0x93, 0x8A, 0x98, 0x89, 0x1A, 0xA1, 0xDC, 0x5D, 0x44, 0x36, 0x80, 0x00, 0xAE, 0x48, 0x93, 0x00, 0x02, 0xAA, 0x6F, 0xF8, 0x25, 0x51, 0x15, 0x61, 0x41, 0x25, 0x41, 0x09, 0x61};
const uint8_t spCOMPUTER[]  PROGMEM = {0x06, 0x28, 0x29, 0x68, 0x44, 0x29, 0xAA, 0xA6, 0xD6, 0xEC, 0x15, 0xE7, 0x9C, 0xE6, 0x64, 0xAB, 0x5A, 0x9E, 0xBD, 0x96, 0x41, 0xB6, 0x0D, 0x79, 0xB2, 0xDC, 0x48, 0xDD, 0xCD, 0x94, 0x49, 0x53, 0x15, 0x7B, 0x12, 0x54, 0x09, 0xE5, 0xEE, 0x22, 0xB2, 0x81, 0x01, 0xD5, 0x86, 0x97, 0xA0, 0x47, 0x22, 0xCF, 0xAA, 0xDC, 0xFC, 0x26, 0x8D, 0xB2, 0x7D, 0xF5, 0xF2, 0x33, 0x6D, 0xCD, 0xB0, 0xD7, 0x3B, 0xE8, 0x11, 0x2A, 0x84, 0x72, 0x77, 0x11, 0xD9, 0xA0, 0x80, 0x6D, 0x35, 0x1D, 0xB0, 0x89, 0xFB, 0x48, 0x8A, 0x35, 0x75, 0xED, 0xDA, 0xAB, 0xAA, 0xDE, 0x2D, 0x24, 0x57, 0xAF, 0xB6, 0xF9, 0xB6, 0x14, 0x5D, 0x5D, 0xA6, 0x52, 0xD3, 0x5C, 0x73, 0xB6, 0xDB, 0xB3, 0x4F, 0x4F, 0x89, 0x31, 0xFF, 0x15, 0x61, 0x51, 0x25, 0x25, 0x79, 0x61};
const uint8_t spFILE[]      PROGMEM = {0x08, 0xE8, 0xD2, 0x95, 0x00, 0x4D, 0xA7, 0x09, 0xA0, 0xC8, 0xF0, 0xE6, 0xE5, 0x54, 0x9E, 0x4A, 0x8F, 0x4E, 0x50, 0xFC, 0x95, 0xB9, 0x36, 0xB8, 0xE1, 0x89, 0xAA, 0xB9, 0x52, 0xF3, 0x86, 0x27, 0x6E, 0xFA, 0xDA, 0xCD, 0x5A, 0x9E, 0xB4, 0xEA, 0x6B, 0x77, 0x6B, 0x79, 0x8A, 0xA6, 0xB7, 0x32, 0xA4, 0xD3, 0xA9, 0xBA, 0xDD, 0xC8, 0x94, 0x55, 0xA7, 0xEB, 0xA1, 0x3D, 0x83, 0x17, 0x9F, 0xBE, 0x87, 0x90, 0x08, 0x5B, 0x3C, 0x86, 0xEE, 0x4C, 0xB2, 0x6C, 0x71, 0x99, 0x8A, 0x97, 0x48, 0xAF, 0xD9, 0x61, 0xCE, 0x4E, 0x2B, 0xB4, 0xE6, 0x84, 0x25, 0x79, 0xCF, 0x22, 0x5F, 0xED, 0x67, 0x33, 0x85, 0xEE, 0x66, 0xD2, 0x8D, 0xDD, 0x18, 0x62, 0x64, 0x52, 0xAC, 0xB2, 0xE3, 0xFF, 0x15, 0x65, 0x25, 0x49, 0x31};
const uint8_t spFROM[]      PROGMEM = {0x08, 0xE8, 0xDA, 0x84, 0x02, 0x0A, 0x68, 0x26, 0x54, 0x03, 0xAE, 0x88, 0x83, 0x2A, 0xC4, 0x73, 0x97, 0x2A, 0x2D, 0x8D, 0x90, 0xC8, 0xBD, 0xEA, 0x1C, 0xAD, 0x22, 0xA8, 0xF7, 0x69, 0xB2, 0xAF, 0x8A, 0xA4, 0x3E, 0xA7, 0xCD, 0xBE, 0x2A, 0x12, 0xF7, 0x9C, 0x2E, 0x9B, 0x6D, 0x0B, 0xEA, 0x72, 0xFA, 0x6C, 0x6E, 0x34, 0xB8, 0xF5, 0xEA, 0xB3, 0xBE, 0xB5, 0xE0, 0xD6, 0xA3, 0xCF, 0x7A, 0x5A, 0x43, 0x3D, 0xB7, 0x2E, 0xAB, 0xB6, 0x14, 0x52, 0x5D, 0xDA, 0x24, 0x5A, 0x43, 0x58, 0x4B, 0x6E, 0x43, 0x13, 0x9D, 0x85, 0x91, 0xB6, 0xF1, 0xCD, 0xFF, 0x71};
const uint8_t spILLEGAL[]   PROGMEM = {0x25, 0x19, 0x4C, 0xA9, 0x6F, 0x42, 0xF7, 0x2C, 0x67, 0x21, 0x5F, 0x20, 0x38, 0xC3, 0x1E, 0x96, 0xE4, 0x70, 0x65, 0x4B, 0x5F, 0xDD, 0xA2, 0x43, 0x85, 0xAD, 0xA2, 0xF5, 0x08, 0xB6, 0x36, 0xD0, 0xD6, 0x26, 0x2B, 0x9A, 0xD6, 0x40, 0xBB, 0xAA, 0xAC, 0x64, 0x79, 0x03, 0xDD, 0xAE, 0x3D, 0xB2, 0x99, 0x08, 0x6A, 0xBA, 0x72, 0xA9, 0x56, 0x37, 0xE0, 0xE9, 0x46, 0xA6, 0x5A, 0xDD, 0x81, 0xAA, 0x67, 0x21, 0x50, 0x04, 0x77, 0x11, 0x91, 0x0D, 0xAE, 0x28, 0xA9, 0xC1, 0xD4, 0x6C, 0x97, 0x36, 0xC7, 0x46, 0xF7, 0x48, 0x34, 0xFA, 0xAA, 0xC3, 0x4A, 0x7D, 0xF1, 0x18, 0xB2, 0x8F, 0x0C, 0xCE, 0x35, 0x65, 0x8A, 0xB1, 0xDC, 0x39, 0x5B, 0x87, 0x39, 0x94, 0x72, 0xE3, 0x5E, 0x1C, 0xA6, 0x10, 0xDB, 0x83, 0xB2, 0xAB, 0x1B, 0xA3, 0x1B, 0x6B, 0xB4, 0xB5, 0x7E, 0xF8, 0x5A, 0x39, 0x49};
const uint8_t spIS[]        PROGMEM = {0xC9, 0x5F, 0x3E, 0x90, 0xB2, 0x17, 0xDF, 0xE0, 0x04, 0xDB, 0x04, 0x72, 0xF5, 0xA2, 0x13, 0x6E, 0x1D, 0xC8, 0xD5, 0x8B, 0x4E, 0xB4, 0x5C, 0x23, 0x65, 0x2F, 0x3A, 0xE9, 0x76, 0x85, 0x1C, 0xB5, 0xE8, 0x94, 0x33, 0x24, 0x89, 0xD6, 0xA2, 0xD5, 0xCD, 0xD4, 0x24, 0x54, 0x8B, 0xC6, 0xD8, 0x0D, 0x4B, 0xF8, 0xD6, 0x29, 0x63, 0xE2, 0x6E, 0x9D, 0x1D, 0x3B, 0x8F, 0x66, 0x3C, 0xD0, 0xCD, 0xA3, 0x12, 0xDA, 0x89, 0x01, 0x13, 0xB0, 0x23, 0xE0, 0x61, 0x76, 0x04, 0x7C, 0x4A, 0xFA, 0x29};
const uint8_t spNEGATIVE[]  PROGMEM = {0x26, 0x2E, 0x4C, 0x24, 0xCC, 0x13, 0xC5, 0x32, 0x14, 0x49, 0xD0, 0x9C, 0xA4, 0x9B, 0x92, 0x25, 0xC9, 0x33, 0x9C, 0x6E, 0x46, 0x32, 0x94, 0x91, 0x7B, 0x2C, 0x3E, 0xD1, 0x74, 0x21, 0x6E, 0xD1, 0xF8, 0x84, 0xCB, 0x26, 0x9B, 0x7B, 0xE3, 0x13, 0x4C, 0x93, 0xE8, 0x9D, 0xAB, 0x46, 0x30, 0x4A, 0x41, 0x44, 0xCE, 0x22, 0x49, 0xD7, 0x06, 0x16, 0xB5, 0x7A, 0x64, 0xDD, 0x15, 0x87, 0x8A, 0xE2, 0x95, 0x75, 0xA3, 0xD0, 0x13, 0xB5, 0x56, 0xDA, 0x94, 0x70, 0x75, 0xD4, 0x26, 0x9D, 0x50, 0xEE, 0x2E, 0x22, 0x1B, 0x0C, 0xB0, 0xA8, 0x85, 0x03, 0x16, 0x0B, 0x0D, 0xED, 0x16, 0x4E, 0x5A, 0x16, 0xBB, 0xB4, 0xC3, 0x2A, 0xA5, 0x57, 0x9D, 0x32, 0x74, 0x27, 0x1C, 0x59, 0x73, 0xC2, 0xD2, 0x8D, 0x70, 0x65, 0xCE, 0x76, 0x4B, 0x33, 0x22, 0xE5, 0x39, 0xCB, 0x2D, 0xD5, 0x93, 0xA5, 0xD5, 0x2C, 0x33, 0x67, 0x23, 0x5A, 0x5A, 0x35, 0xC5, 0x5C, 0x55, 0x88, 0xA9, 0x35, 0x36, 0xF3, 0x70, 0xA9, 0xA9, 0xAA, 0x98, 0x00, 0x4D, 0x9B, 0xFC, 0x75, 0x51, 0x39};
const uint8_t spNO[]        PROGMEM = {0xAC, 0xEF, 0xCC, 0xD9, 0x25, 0x6C, 0xBB, 0xB6, 0x50, 0xD1, 0xC7, 0x74, 0x17, 0x9A, 0x42, 0xD9, 0x1E, 0xD3, 0x5D, 0xAA, 0x2B, 0x51, 0x7D, 0x2C, 0x77, 0x29, 0xAF, 0xC4, 0xF4, 0x31, 0x93, 0xB7, 0xAC, 0x81, 0xE4, 0x63, 0xAD, 0x7F, 0xD2, 0x2E, 0x5B, 0x4D, 0xBC, 0xD1, 0x89, 0x9B, 0x6E, 0x33, 0xF5, 0x4D, 0x27, 0x6B, 0x26, 0x3D, 0xD8, 0x56, 0x9F, 0xA2, 0xEA, 0x0E, 0x53, 0xDB, 0x74, 0xAA, 0xA6, 0x32, 0x42, 0xE5, 0xD3, 0xEE, 0xC7, 0xD8, 0x44, 0xA7, 0x19, 0x7E, 0x0E, 0x53, 0x32, 0xE3, 0x6C, 0xF6, 0x28, 0x8C, 0xC1, 0xB7, 0x19, 0xE5, 0x9C, 0x38, 0xDA, 0xF1, 0xFF, 0x15, 0x79, 0x39};
const uint8_t spNUMBER[]    PROGMEM = {0xA6, 0x0A, 0x42, 0x72, 0xB9, 0xDC, 0x84, 0x32, 0x0A, 0x89, 0xA3, 0x72, 0x13, 0xF2, 0xC0, 0x35, 0x0E, 0xDB, 0x4D, 0x49, 0x13, 0x57, 0x3D, 0xAA, 0xA4, 0x27, 0xAE, 0xAE, 0xC3, 0x25, 0x12, 0x9F, 0xA8, 0xBA, 0x2D, 0x37, 0x4F, 0x74, 0x82, 0x62, 0xAF, 0xC3, 0x3C, 0xD5, 0xF1, 0x8B, 0xBD, 0x0E, 0xB5, 0x44, 0xCB, 0xAF, 0x72, 0xAD, 0x91, 0xDC, 0xAC, 0xA0, 0xCA, 0xB1, 0x46, 0x4A, 0x33, 0x82, 0x6C, 0x46, 0x03, 0xA4, 0x4B, 0x8A, 0xB2, 0x0C, 0x2B, 0x90, 0x2D, 0x2A, 0x33, 0xD2, 0xB2, 0xC4, 0x3E, 0x8B, 0xCA, 0xCA, 0xD2, 0x10, 0x5F, 0xD5, 0xAA, 0xE2, 0xDB, 0x8C, 0x65, 0x53, 0xAB, 0x73, 0x09, 0x57, 0xAE, 0xDB, 0x6D, 0x28, 0xB1, 0xDC, 0xC5, 0x1F, 0xB7, 0x29, 0x87, 0xF0, 0xD0, 0xBE, 0x94, 0xE7, 0xB0, 0x64, 0x1F, 0x16, 0x5A, 0x53, 0xEC, 0xFA, 0x79};
const uint8_t spPARAMETER[] PROGMEM = {0x04, 0xD0, 0xA2, 0x3D, 0xA5, 0xC5, 0xA7, 0x9B, 0x6B, 0xCD, 0x91, 0xE6, 0x21, 0x85, 0xE3, 0x71, 0x7B, 0xDA, 0xB2, 0x1C, 0xB8, 0x38, 0x3C, 0x6E, 0xCA, 0xD2, 0xC5, 0x32, 0xF5, 0xB6, 0x31, 0x6B, 0x69, 0x39, 0x6C, 0x61, 0xE9, 0x65, 0x45, 0xA5, 0x5B, 0x71, 0x45, 0xA3, 0x13, 0xD4, 0x9C, 0x11, 0x9A, 0x8D, 0x4E, 0xD0, 0xEC, 0x46, 0xBA, 0xD5, 0x5A, 0x49, 0x89, 0x9E, 0x42, 0x39, 0xB9, 0xE4, 0xC9, 0x49, 0x31, 0x74, 0xBB, 0x92, 0x67, 0x23, 0xA5, 0x50, 0xDD, 0x4A, 0x9E, 0x8C, 0xB4, 0x42, 0xAE, 0x3B, 0x65, 0x2D, 0x5E, 0xC6, 0x3E, 0xA5, 0xB5, 0xD5, 0x69, 0x28, 0xC7, 0x62, 0xD2, 0x0A, 0xE5, 0xEE, 0x22, 0xB2, 0x41, 0x01, 0x9B, 0x65, 0x1A, 0xA0, 0xE0, 0xF0, 0xD6, 0x24, 0xEF, 0x96, 0xDA, 0xB5, 0xCE, 0xD0, 0x82, 0x7B, 0xAA, 0xAE, 0x1E, 0x53, 0x4D, 0x15, 0xA1, 0xF2, 0xB8, 0x8D, 0x25, 0x57, 0x84, 0xEA, 0xE2, 0x32, 0x96, 0x9C, 0x11, 0xEC, 0x93, 0xFF, 0x51, 0x61, 0x39, 0x51, 0x05};
const uint8_t spPROGRAMME[] PROGMEM = {0x0C, 0x48, 0x2E, 0x95, 0x03, 0x2E, 0x0A, 0x8D, 0x3D, 0xDA, 0x13, 0xD5, 0x68, 0xF9, 0xA9, 0x73, 0x68, 0xC7, 0x94, 0x13, 0x94, 0x62, 0xA9, 0xC6, 0xAB, 0x4F, 0x50, 0x63, 0x84, 0x19, 0xAD, 0x3E, 0x41, 0x0B, 0xEE, 0x6E, 0xB8, 0xE9, 0x04, 0xD5, 0x69, 0x84, 0xF0, 0xAB, 0x11, 0x66, 0xE7, 0x66, 0x22, 0xAF, 0x5C, 0x14, 0xA3, 0x2B, 0xAB, 0x2E, 0x34, 0xA9, 0x54, 0x19, 0x1D, 0x96, 0x4A, 0xE5, 0x3E, 0xAB, 0xB8, 0x44, 0x9C, 0x50, 0xA7, 0x66, 0x21, 0xA4, 0x71, 0x52, 0x95, 0x33, 0x17, 0x66, 0xA7, 0x1D, 0x75, 0x69, 0x1A, 0x94, 0xE9, 0x75, 0xB5, 0xA5, 0xA9, 0x9B, 0xE7, 0x9A, 0x33, 0xB4, 0xD8, 0xE1, 0xC1, 0x5D, 0xCE, 0xD8, 0xFC, 0x44, 0x24, 0x75, 0x3E, 0x53, 0x8B, 0xE5, 0x19, 0xBC, 0x78, 0xCC, 0x35, 0x76, 0x64, 0xF2, 0xED, 0x36, 0xD7, 0x54, 0x51, 0xCE, 0xB3, 0xEB, 0x1C, 0xE6, 0xEC, 0x34, 0x0C, 0xAC, 0x89, 0x9F, 0xED, 0xF2, 0x45};
const uint8_t spTHIS[]      PROGMEM = {0xAA, 0xF2, 0xD2, 0x6C, 0xA4, 0x2A, 0xAA, 0xCA, 0x4B, 0xB5, 0xB6, 0x6C, 0x18, 0xCA, 0xAA, 0x94, 0x53, 0xB4, 0xF1, 0x8A, 0x3B, 0x0B, 0xEC, 0xD2, 0x45, 0x27, 0xEC, 0xDC, 0x71, 0xCA, 0x67, 0x9D, 0x68, 0x48, 0xC7, 0xE9, 0x58, 0x74, 0xD2, 0x69, 0x13, 0x22, 0x63, 0xF1, 0xA9, 0x86, 0x35, 0xEC, 0xCC, 0xC5, 0xAD, 0xEE, 0x5E, 0x68, 0xE4, 0xE2, 0x2A, 0x20, 0xE3, 0x10, 0x01, 0x2C, 0x62, 0x66, 0x80, 0xC7, 0xDC, 0x15, 0xF0, 0x98, 0x94, 0x00, 0x3E, 0xB7, 0x10, 0xC0, 0xA3, 0x96, 0x0C, 0xF8, 0x42, 0x9D, 0x01, 0xDF, 0x09, 0x33, 0xE0, 0x1B, 0x31, 0x02, 0x7C, 0xA7, 0x42, 0x80, 0x6F, 0x94, 0x10, 0xF0, 0x95, 0x39, 0x02, 0x1A, 0x0E, 0xFD, 0x51, 0x59, 0x49, 0x15};
const uint8_t spYOUR[]      PROGMEM = {0xA1, 0x69, 0x86, 0xD1, 0xA7, 0x2B, 0xE5, 0x3A, 0x55, 0x2D, 0x08, 0xDA, 0xC4, 0xCA, 0x56, 0x16, 0xA9, 0x5C, 0xA3, 0x3D, 0x4F, 0x99, 0x44, 0x59, 0x85, 0xF4, 0x5A, 0x65, 0x74, 0xE3, 0xA9, 0xDC, 0xFB, 0x96, 0xA7, 0x4A, 0x7A, 0xA2, 0x8C, 0x72, 0x9F, 0x2A, 0xDA, 0xC9, 0x54, 0xCE, 0xBD, 0xEA, 0x10, 0x26, 0x42, 0xB4, 0xF7, 0xAA, 0xA3, 0xDF, 0x08, 0xD1, 0xDE, 0xA3, 0x8E, 0x6E, 0x23, 0x44, 0x73, 0x8F, 0x3A, 0x9A, 0x8D, 0x54, 0xC9, 0x35, 0xEA, 0xE4, 0xBA, 0xD2, 0xB0, 0xF7, 0x68, 0x92, 0xDF, 0x74, 0x91, 0x9C, 0xA5, 0x89, 0xBD, 0xD3, 0x48, 0x3B, 0xF8, 0xF6, 0xFF, 0x2D};
const uint8_t * indexArray [] {spTHIS, spIS, spNO, spNEGATIVE, spPARAMETER, spPROGRAMME, spNUMBER, spILLEGAL, spCASSETTE, spPAUSE1, spPAUSE2};
#endif

Talkie voice;

#define qBlink() (digitalWriteFast(LED_BUILTIN, !digitalReadFast(LED_BUILTIN) ))  // This toggles the Teensy 3.2 Builtin LED pin 13
void setup() {
  while (!Serial && 5000 > millis());
  Serial.println("\nSetting up");
  pinMode(LED_BUILTIN, OUTPUT);
  qBlink();
  pinMode(5, OUTPUT);
  digitalWrite(5, HIGH);//Enable Amplified PROP shield
  delay(10);
  voice.say( spACORN ); // This orignal function when used blocks until all queued sounds have played
}

int wordarray[] {0, 1, 2, 3, 6, 9, 0, 1, 2, 3, 4, 9, 7, 8, 10, 7, 8, 10};
int wordarraysize = sizeof (wordarray) / 4;
void loop() {
  arrayInterface (wordarray, wordarraysize);
  uint8_t xx = voice.active(), yy;
  while ( (yy = voice.active()) > 15 ) {
    if ( xx != yy ) {
      qBlink();
      xx = yy;
      Serial.print( "." );
    }
    delay (5);
  }
}
uint8_t aI_cnt = 0;
bool waitAcorn = true;
void arrayInterface (int * wordArray, int wordArraySize) {
  Serial.print( "Array Adding: Active=" );
  Serial.print( voice.active() );
  if ( 2 < ++aI_cnt ) {
    if ( waitAcorn ) voice.say( spACORN ); // This orignal function when used blocks until all queued sounds have played
    else voice.sayQ( 0 ); // Empty queue to test code
    waitAcorn = !waitAcorn;
    aI_cnt = 0;
    Serial.print( " EMPTY QUEUE: " );
    while ( voice.active() ) Serial.print( "^" ); // Allow silence to come, a PAUSE is played to turn off synthesis
    Serial.print( " :: Active=" );
    Serial.println( voice.active() );
    delay(1000);  // Sweet Silence!
  }
  for (uint8_t i = 0; i < wordArraySize; i++) {
    qBlink();
    Serial.print( " Q=" );
    Serial.print( voice.sayQ (indexArray[wordArray[i]]) );
  }
  Serial.print( ":: Array Added: Active=" );
  Serial.println( voice.active() );
}

