/******************************************************************************/
/*                                                                            */
/*  PACMAN GAME FOR ARDUINO DUE                                               */
/*                                                                            */
/******************************************************************************/

#ifndef byte
typedef unsigned char byte;
typedef unsigned short ushort;
typedef unsigned long ulong;
#endif

#ifndef uchar
typedef unsigned char uchar;
#endif
/*
#define PROGMEM 
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long uint32_t;
#define pgm_read_byte(_x) (*(_x))
#define pgm_read_word(_x) (*(_x))
*/

#ifndef _max
#define _max(_a,_b) (((_a) > (_b)) ? (_a) : (_b))
#define _min(_a,_b) (((_a) < (_b)) ? (_a) : (_b))
#endif

#define ASSERT(_x) if (!(_x)) assertFailed(NULL,__LINE__);

// Playfield (36 tiles)
const byte playTiles[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,   // 0
0x0F,0x30,0x40,0x47,0x88,0x90,0x90,0x90,   // 1
0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,   // 2
0xFF,0x00,0x00,0xE0,0x10,0x08,0x08,0x08,   // 3
0xFF,0x00,0x00,0x07,0x08,0x10,0x10,0x10,   // 4
0xF0,0x0C,0x02,0xE2,0x11,0x09,0x09,0x09,   // 5
0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,   // 6
0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,   // 7 - Dot
0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,   // 8
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,   // 9
0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,   // 10
0x00,0x00,0x00,0x00,0x03,0x04,0x08,0x08,   // 11
0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,   // 12
0x00,0x00,0x00,0x00,0xC0,0x20,0x10,0x10,   // 13
0x3C,0x7E,0xFF,0xFF,0xFF,0xFF,0x7E,0x3C,   // 14 - Pill
0x08,0x08,0x04,0x03,0x00,0x00,0x00,0x00,   // 15
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,   // 16
0x10,0x10,0x20,0xC0,0x00,0x00,0x00,0x00,   // 17
0x00,0x00,0x00,0xE0,0x10,0x08,0x08,0x08,   // 18
0x00,0x00,0x00,0x07,0x08,0x10,0x10,0x10,   // 19
0x90,0x90,0x90,0x88,0x47,0x40,0x30,0x0F,   // 20
0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,   // 21
0x10,0x10,0x10,0x08,0x07,0x00,0x00,0x00,   // 22
0x08,0x08,0x08,0x10,0xE0,0x00,0x00,0x00,   // 23
0x09,0x09,0x09,0x11,0xE2,0x02,0x0C,0xF0,   // 24
0x00,0x00,0x00,0x00,0x0F,0x08,0x08,0x09,   // 25
0x00,0x00,0x00,0x00,0xFF,0x01,0x01,0xFF,   // 26
0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,   // 27
0x00,0x00,0x00,0x00,0xFF,0x80,0x80,0xFF,   // 28
0x00,0x00,0x00,0x00,0xF0,0x10,0x10,0x90,   // 29
0x09,0x08,0x08,0x0F,0x00,0x00,0x00,0x00,   // 30
0x90,0x10,0x10,0xF0,0x00,0x00,0x00,0x00,   // 31
0x90,0x90,0x90,0x88,0x87,0x80,0x80,0x80,   // 32    ascii space
0x09,0x09,0x09,0x11,0xE1,0x01,0x01,0x01,   // 33
0x80,0x80,0x80,0x87,0x88,0x90,0x90,0x90,   // 34
0x01,0x01,0x01,0xE1,0x11,0x09,0x09,0x09,   // 35

//  0x24
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x24
0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,// 0x25 .
0x36,0x36,0x12,0x24,0x00,0x00,0x00,0x00,// 0x26 "
0x36,0x36,0x12,0x24,0x00,0x00,0x00,0x00,// 0x27 "
0xFE,0xFF,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,// 0x28 n
0x1F,0x1F,0x00,0x3F,0x3F,0x30,0x3F,0x3F,// 0x29  
0x8F,0xCF,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,// 0x2A a
0xF8,0xFC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,// 0x2B m
0x7F,0xFF,0xC0,0xC0,0xC0,0xC0,0xFF,0x7F,// 0x2C c
0x1F,0x3F,0x30,0x30,0x30,0x30,0x3F,0x1F,// 0x2D
0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,// 0x2E o
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x2F

//  ASCII 0..9
0x1C,0x26,0x63,0x63,0x63,0x32,0x1C,0x00,// 0x30 0
0x0C,0x1C,0x0C,0x0C,0x0C,0x0C,0x3F,0x00,// 0x31 1
0x3E,0x63,0x07,0x1E,0x3C,0x70,0x7F,0x00,// 0x32 2
0x3F,0x06,0x0C,0x1E,0x03,0x63,0x3E,0x00,// 0x33 3
0x0E,0x1E,0x36,0x66,0x7F,0x06,0x06,0x00,// 0x34 4
0x7E,0x60,0x7E,0x03,0x03,0x63,0x3E,0x00,// 0x35 5
0x1E,0x30,0x60,0x7E,0x63,0x63,0x3E,0x00,// 0x36 6
0x7F,0x63,0x06,0x0C,0x18,0x18,0x18,0x00,// 0x37 7
0x3C,0x62,0x72,0x3C,0x4F,0x43,0x3E,0x00,// 0x38 8
0x3E,0x63,0x63,0x3F,0x03,0x06,0x3C,0x00,// 0x39 9
0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x00,// 0x3A /
0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,// 0x3B -
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,// 0x3C
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,// 0x3D
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,// 0x3E
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,// 0x3F

//  ASCII A starts at 65
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x40 ' '
0x1C,0x36,0x63,0x63,0x7F,0x63,0x63,0x00,// 0x41 a
0x7E,0x63,0x63,0x7E,0x63,0x63,0x7E,0x00,// 0x42 b
0x1E,0x33,0x60,0x60,0x60,0x33,0x1E,0x00,// 0x43 c
0x7C,0x66,0x63,0x63,0x63,0x66,0x7C,0x00,// 0x44 d
0x3F,0x30,0x30,0x3E,0x30,0x30,0x3F,0x00,// 0x45 e
0x7F,0x60,0x60,0x7E,0x60,0x60,0x60,0x00,// 0x46 f
0x1F,0x30,0x60,0x67,0x63,0x33,0x1F,0x00,// 0x47 g
0x63,0x63,0x63,0x7F,0x63,0x63,0x63,0x00,// 0x48 h
0x3F,0x0C,0x0C,0x0C,0x0C,0x0C,0x3F,0x00,// 0x49 i
0x03,0x03,0x03,0x03,0x03,0x63,0x3E,0x00,// 0x4A j
0x63,0x66,0x6C,0x78,0x7C,0x6E,0x67,0x00,// 0x4B k
0x30,0x30,0x30,0x30,0x30,0x30,0x3F,0x00,// 0x4C l
0x63,0x77,0x7F,0x7F,0x6B,0x63,0x63,0x00,// 0x4D m
0x63,0x73,0x7B,0x7F,0x6F,0x67,0x63,0x00,// 0x4E n
0x3E,0x63,0x63,0x63,0x63,0x63,0x3E,0x00,// 0x4F o
0x7E,0x63,0x63,0x63,0x7E,0x60,0x60,0x00,// 0x50 p
0x3E,0x63,0x63,0x63,0x6F,0x66,0x3D,0x00,// 0x51 q
0x7E,0x63,0x63,0x67,0x7C,0x6E,0x67,0x00,// 0x52 r
0x3C,0x66,0x60,0x3E,0x03,0x63,0x3E,0x00,// 0x53 s
0x3F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,// 0x54 t
0x63,0x63,0x63,0x63,0x63,0x63,0x3E,0x00,// 0x55 u
0x63,0x63,0x63,0x77,0x3E,0x1C,0x08,0x00,// 0x56 v
0x63,0x63,0x6B,0x7F,0x7F,0x77,0x63,0x00,// 0x57 w
0x63,0x77,0x3E,0x1C,0x3E,0x77,0x63,0x00,// 0x58 x
0x33,0x33,0x33,0x1E,0x0C,0x0C,0x0C,0x00,// 0x59 y
0x7F,0x07,0x0E,0x1C,0x38,0x70,0x7F,0x00,// 0x5A z
0x0E,0x0E,0x1C,0x18,0x10,0x00,0x20,0x00,// 0x5B !
0x3C,0x42,0x99,0xA1,0xA1,0x99,0x42,0x3C,// 0x5C copyright
0x00,0x00,0xF3,0x88,0xF0,0x80,0x80,0x00,// 0x5D p
0x00,0x00,0xE7,0x88,0x87,0x80,0x8F,0x00,// 0x5E t
0x00,0x00,0x80,0x00,0x00,0x80,0x00,0x00,// 0x5F s

};

#define EXCM ('Z'+1)

// Playfield map 28x32 
const byte playMap1[] = {
0x00,0x00,0x00, '1', 'U', 'P',0x00,0x00,0x00, 'H', 'I', 'G', 'H',0x00, 'S', 'C', 'O', 'R', 'E',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00, '0', '0',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x0E,0x08,0x00,0x00,0x09,0x07,0x08,0x00,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x00,0x09,0x07,0x08,0x00,0x00,0x09,0x0E,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x15,0x15,0x15,0x0D,0x07,0x08,0x16,0x0C,0x0C,0x0D,0x00,0x08,0x09,0x00,0x0B,0x0C,0x0C,0x17,0x09,0x07,0x0B,0x15,0x15,0x15,0x15,0x18,
0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x13,0x10,0x10,0x11,0x00,0x0F,0x11,0x00,0x0F,0x10,0x10,0x12,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x00,0x19,0x15,0x1A,0x1B,0x1B,0x1C,0x15,0x1D,0x00,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,
0x02,0x02,0x02,0x02,0x02,0x11,0x07,0x0F,0x11,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0F,0x11,0x07,0x0F,0x02,0x02,0x02,0x02,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
0x15,0x15,0x15,0x15,0x15,0x0D,0x07,0x0B,0x0D,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0B,0x0D,0x07,0x0B,0x15,0x15,0x15,0x15,0x15,
0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x00,0x1E,0x02,0x02,0x02,0x02,0x02,0x02,0x1F,0x00,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x00,0x00, 'R', 'E', 'A', 'D', 'Y',EXCM,0x00,0x00,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x00,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x00,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x02,0x02,0x02,0x11,0x07,0x0F,0x11,0x00,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x00,0x0F,0x11,0x07,0x0F,0x02,0x02,0x02,0x02,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x12,0x09,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x08,0x13,0x10,0x11,0x07,0x0A,
0x06,0x0E,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x0E,0x0A,
0x20,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x21,
0x22,0x10,0x11,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0F,0x10,0x23,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x18,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

/******************************************************************************/        
/******************************************************************************/        
/******************************************************************************/        

// Playfield map 28x32 
const byte playMap2[] = {
0x00,0x00,0x00, '1', 'U', 'P',0x00,0x00,0x00, 'H', 'I', 'G', 'H',0x00, 'S', 'C', 'O', 'R', 'E',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00, '0', '0',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x0E,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0E,0x07,0x07,0x0A,
0x14,0x15,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x15,0x18,
0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,
0x02,0x02,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x02,0x02,
0x00,0x00,0x00,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x00,0x00,0x00,
0x15,0x15,0x0D,0x07,0x08,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x09,0x07,0x0B,0x15,0x15,
0x00,0x00,0x06,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x19,0x15,0x1A,0x1B,0x1B,0x1C,0x15,0x1D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x08,0x13,0x10,0x10,0x11,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x0F,0x10,0x10,0x12,0x09,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,
0x02,0x02,0x11,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x1E,0x02,0x02,0x02,0x02,0x02,0x02,0x1F,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0F,0x02,0x02,
0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x00, 'R', 'E', 'A', 'D', 'Y',EXCM,0x00,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x00,0x00,0x00,
0x15,0x15,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x15,0x15,
0x00,0x00,0x06,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0A,0x00,0x00,
0x01,0x02,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x02,0x05,
0x06,0x07,0x07,0x0E,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0E,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x13,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x12,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x0A,
0x06,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x0A,
0x06,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x18,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};


/******************************************************************************/        
/******************************************************************************/        
/******************************************************************************/        
// Playfield map 28x32 
const byte playMap3[] = {
0x00,0x00,0x00, '1', 'U', 'P',0x00,0x00,0x00, 'H', 'I', 'G', 'H',0x00, 'S', 'C', 'O', 'R', 'E',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00, '0', '0',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
0x15,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x15,
0x01,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x08,0x13,0x10,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x10,0x12,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x0E,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x0E,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x11,0x07,0x0F,0x10,0x12,0x09,0x07,0x08,0x16,0x0C,0x0C,0x0C,0x0C,0x17,0x09,0x07,0x08,0x13,0x10,0x11,0x07,0x0F,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x18,
0x01,0x10,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x19,0x15,0x1A,0x1B,0x1B,0x1C,0x15,0x1D,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x10,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0F,0x11,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x0F,0x11,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x12,0x09,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x08,0x13,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x1E,0x02,0x02,0x02,0x02,0x02,0x02,0x1F,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x07,0x07,0x0A,
0x14,0x15,0x0D,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x00, 'R', 'E', 'A', 'D', 'Y',EXCM,0x00,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x0B,0x15,0x18,
0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x17,0x09,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x00,0x00,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x00,0x00,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x00,0x00,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0A,0x00,0x00,
0x02,0x02,0x11,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x0F,0x02,0x02,
0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x00,0x00,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
0x15,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x15,
0x01,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x05,
0x06,0x07,0x07,0x0E,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x0E,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x17,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x18,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};


/******************************************************************************/        
/******************************************************************************/        
/******************************************************************************/        
// Playfield map 28x32     
const byte playMap4[] = {
0x00,0x00,0x00, '1', 'U', 'P',0x00,0x00,0x00, 'H', 'I', 'G', 'H',0x00, 'S', 'C', 'O', 'R', 'E',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00, '0', '0',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x03,0x04,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x05,
0x06,0x07,0x07,0x0E,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0E,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x08,0x13,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x12,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x11,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0F,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x0A,
0x14,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x18,
0x02,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x02,
0x07,0x07,0x07,0x07,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x17,0x09,0x07,0x07,0x07,0x07,0x07,
0x0D,0x07,0x0B,0x0D,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0B,0x0D,0x07,0x0B,
0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x19,0x15,0x1A,0x1B,0x1B,0x1C,0x15,0x1D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x17,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x17,0x09,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x1E,0x02,0x02,0x02,0x02,0x02,0x02,0x1F,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x00, 'R', 'E', 'A', 'D', 'Y',EXCM,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x17,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x13,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x12,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x18,
0x01,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x05,
0x06,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x17,0x09,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0D,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x13,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x12,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x0E,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x0E,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x18,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

/******************************************************************************/        
/******************************************************************************/        
/******************************************************************************/        
// Playfield map 28x32 
const byte playMap5[] = {
0x00,0x00,0x00, '1', 'U', 'P',0x00,0x00,0x00, 'H', 'I', 'G', 'H',0x00, 'S', 'C', 'O', 'R', 'E',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00, '0', '0',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x13,0x10,0x10,0x10,0x10,0x12,0x09,0x07,0x08,0x00,0x00,0x09,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x16,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x17,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x15,0x18,
0x00,0x00,0x06,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x12,0x13,0x10,0x10,0x11,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,
0x02,0x02,0x11,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x19,0x15,0x1A,0x1B,0x1B,0x1C,0x15,0x1D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0F,0x02,0x02,
0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x07,0x07,0x07,
0x0C,0x0C,0x0C,0x0C,0x17,0x09,0x0E,0x07,0x07,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x07,0x07,0x0E,0x08,0x16,0x0C,0x0C,0x0C,0x0C,
0x10,0x10,0x10,0x10,0x12,0x09,0x07,0x0B,0x0D,0x07,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x07,0x0B,0x0D,0x07,0x08,0x13,0x10,0x10,0x10,0x10,
0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x1E,0x02,0x02,0x02,0x02,0x02,0x02,0x1F,0x07,0x08,0x09,0x07,0x08,0x09,0x07,0x07,0x07,0x07,
0x15,0x15,0x0D,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x00, 'R', 'E', 'A', 'D', 'Y',EXCM,0x00,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x0B,0x15,0x15,
0x00,0x00,0x06,0x07,0x07,0x07,0x07,0x08,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x09,0x07,0x07,0x07,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x0B,0x0D,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0B,0x0D,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,0x00,0x00,
0x00,0x00,0x06,0x07,0x08,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x09,0x07,0x0A,0x00,0x00,
0x01,0x02,0x11,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x11,0x07,0x0F,0x02,0x05,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x06,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x08,0x16,0x0C,0x0C,0x0C,0x0C,0x17,0x09,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x0D,0x07,0x0A,
0x06,0x07,0x08,0x13,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x12,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x08,0x09,0x07,0x0B,0x0C,0x17,0x16,0x0C,0x0C,0x0D,0x07,0x0B,0x0D,0x07,0x0B,0x0C,0x0C,0x17,0x16,0x0C,0x0D,0x07,0x08,0x09,0x07,0x0A,
0x06,0x07,0x0F,0x11,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x08,0x09,0x07,0x0F,0x10,0x10,0x10,0x10,0x10,0x11,0x07,0x0F,0x11,0x07,0x0A,
0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x08,0x09,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x0A,
0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x18,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x18,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

/******************************************************************************/        
/******************************************************************************/        
/******************************************************************************/        

// 8x8 sprites 256,1 bit
const byte textTiles[] = {
0x00,0x1C,0x26,0x63,0x63,0x63,0x32,0x1C,// 0x00
0x00,0x0C,0x1C,0x0C,0x0C,0x0C,0x0C,0x3F,// 0x01
0x00,0x3E,0x63,0x07,0x1E,0x3C,0x70,0x7F,// 0x02
0x00,0x3F,0x06,0x0C,0x1E,0x03,0x63,0x3E,// 0x03
0x00,0x0E,0x1E,0x36,0x66,0x7F,0x06,0x06,// 0x04
0x00,0x7E,0x60,0x7E,0x03,0x03,0x63,0x3E,// 0x05
0x00,0x1E,0x30,0x60,0x7E,0x63,0x63,0x3E,// 0x06
0x00,0x7F,0x63,0x06,0x0C,0x18,0x18,0x18,// 0x07
0x00,0x3C,0x62,0x72,0x3C,0x4F,0x43,0x3E,// 0x08
0x00,0x3E,0x63,0x63,0x3F,0x03,0x06,0x3C,// 0x09
0x00,0x1C,0x36,0x63,0x63,0x7F,0x63,0x63,// 0x0A
0x00,0x7E,0x63,0x63,0x7E,0x63,0x63,0x7E,// 0x0B
0x00,0x1E,0x33,0x60,0x60,0x60,0x33,0x1E,// 0x0C
0x00,0x7C,0x66,0x63,0x63,0x63,0x66,0x7C,// 0x0D
0x00,0x7E,0x60,0x60,0x7C,0x60,0x60,0x7E,// 0x0E
0x00,0xFE,0xC0,0xC0,0xFC,0xC0,0xC0,0xC0,// 0x0F
0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,// 0x10
0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,// 0x11
0x00,0x00,0x30,0x78,0x78,0x30,0x00,0x00,// 0x12
0x00,0x00,0x30,0x78,0x78,0x30,0x00,0x00,// 0x13
0x3C,0x7E,0xFF,0xFF,0xFF,0xFF,0x7E,0x3C,// 0x14
0x3C,0x7E,0xFF,0xFF,0xFF,0xFF,0x7E,0x3C,// 0x15
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x16
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x17
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x18
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x19
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x1A
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x1B
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x1C
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x1D
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x1E
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x1F

0x00,0x00,0xC0,0xE0,0xF0,0xF8,0xF8,0x78,// 0x20 pacman
0x00,0x00,0x07,0x0F,0x1F,0x07,0x01,0x00,// 0x21
0xF8,0xF8,0xF0,0xE0,0xC0,0x00,0x00,0x00,// 0x22
0x01,0x07,0x1F,0x0F,0x07,0x00,0x00,0x00,// 0x23

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x24
0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,// 0x25 .
0x36,0x36,0x12,0x24,0x00,0x00,0x00,0x00,// 0x26 "
0x36,0x36,0x12,0x24,0x00,0x00,0x00,0x00,// 0x27 "
0xFE,0xFF,0xC3,0xC3,0xC3,0xC3,0xC3,0xC3,// 0x28 n
0x1F,0x1F,0x00,0x3F,0x3F,0x30,0x3F,0x3F,// 0x29  
0x8F,0xCF,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,// 0x2A a
0xF8,0xFC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,// 0x2B m
0x7F,0xFF,0xC0,0xC0,0xC0,0xC0,0xFF,0x7F,// 0x2C c
0x1F,0x3F,0x30,0x30,0x30,0x30,0x3F,0x1F,// 0x2D
0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,// 0x2E o
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x2F

0x1C,0x26,0x63,0x63,0x63,0x32,0x1C,0x00,// 0x30 0
0x0C,0x1C,0x0C,0x0C,0x0C,0x0C,0x3F,0x00,// 0x31 1
0x3E,0x63,0x07,0x1E,0x3C,0x70,0x7F,0x00,// 0x32 2
0x3F,0x06,0x0C,0x1E,0x03,0x63,0x3E,0x00,// 0x33 3
0x0E,0x1E,0x36,0x66,0x7F,0x06,0x06,0x00,// 0x34 4
0x7E,0x60,0x7E,0x03,0x03,0x63,0x3E,0x00,// 0x35 5
0x1E,0x30,0x60,0x7E,0x63,0x63,0x3E,0x00,// 0x36 6
0x7F,0x63,0x06,0x0C,0x18,0x18,0x18,0x00,// 0x37 7
0x3C,0x62,0x72,0x3C,0x4F,0x43,0x3E,0x00,// 0x38 8
0x3E,0x63,0x63,0x3F,0x03,0x06,0x3C,0x00,// 0x39 9
0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x00,// 0x3A /
0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,// 0x3B -
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,// 0x3C
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,// 0x3D
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,// 0x3E
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,// 0x3F

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x40 ' '
0x1C,0x36,0x63,0x63,0x7F,0x63,0x63,0x00,// 0x41 a
0x7E,0x63,0x63,0x7E,0x63,0x63,0x7E,0x00,// 0x42 b
0x1E,0x33,0x60,0x60,0x60,0x33,0x1E,0x00,// 0x43 c
0x7C,0x66,0x63,0x63,0x63,0x66,0x7C,0x00,// 0x44 d
0x3F,0x30,0x30,0x3E,0x30,0x30,0x3F,0x00,// 0x45 e
0x7F,0x60,0x60,0x7E,0x60,0x60,0x60,0x00,// 0x46 f
0x1F,0x30,0x60,0x67,0x63,0x33,0x1F,0x00,// 0x47 g
0x63,0x63,0x63,0x7F,0x63,0x63,0x63,0x00,// 0x48 h
0x3F,0x0C,0x0C,0x0C,0x0C,0x0C,0x3F,0x00,// 0x49 i
0x03,0x03,0x03,0x03,0x03,0x63,0x3E,0x00,// 0x4A j
0x63,0x66,0x6C,0x78,0x7C,0x6E,0x67,0x00,// 0x4B k
0x30,0x30,0x30,0x30,0x30,0x30,0x3F,0x00,// 0x4C l
0x63,0x77,0x7F,0x7F,0x6B,0x63,0x63,0x00,// 0x4D m
0x63,0x73,0x7B,0x7F,0x6F,0x67,0x63,0x00,// 0x4E n
0x3E,0x63,0x63,0x63,0x63,0x63,0x3E,0x00,// 0x4F o
0x7E,0x63,0x63,0x63,0x7E,0x60,0x60,0x00,// 0x50 p
0x3E,0x63,0x63,0x63,0x6F,0x66,0x3D,0x00,// 0x51 q
0x7E,0x63,0x63,0x67,0x7C,0x6E,0x67,0x00,// 0x52 r
0x3C,0x66,0x60,0x3E,0x03,0x63,0x3E,0x00,// 0x53 s
0x3F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x00,// 0x54 t
0x63,0x63,0x63,0x63,0x63,0x63,0x3E,0x00,// 0x55 u
0x63,0x63,0x63,0x77,0x3E,0x1C,0x08,0x00,// 0x56 v
0x63,0x63,0x6B,0x7F,0x7F,0x77,0x63,0x00,// 0x57 w
0x63,0x77,0x3E,0x1C,0x3E,0x77,0x63,0x00,// 0x58 x
0x33,0x33,0x33,0x1E,0x0C,0x0C,0x0C,0x00,// 0x59 y
0x7F,0x07,0x0E,0x1C,0x38,0x70,0x7F,0x00,// 0x5A z
0x0E,0x0E,0x1C,0x18,0x10,0x00,0x20,0x00,// 0x5B !
0x3C,0x42,0x99,0xA1,0xA1,0x99,0x42,0x3C,// 0x5C copyright
0x00,0x00,0xF3,0x88,0xF0,0x80,0x80,0x00,// 0x5D p
0x00,0x00,0xE7,0x88,0x87,0x80,0x8F,0x00,// 0x5E t
0x00,0x00,0x80,0x00,0x00,0x80,0x00,0x00,// 0x5F s

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,// 0x60 - weird geometry
0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,// 0x61
0x00,0x00,0x78,0x78,0x7C,0x7E,0x7F,0x7F,// 0x62
0x7F,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,// 0x63
0x00,0x00,0xC0,0xE0,0xF0,0xFC,0xFF,0xFF,// 0x64
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,// 0x65
0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,// 0x66
0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,// 0x67
0x00,0x00,0x00,0x00,0x80,0xE0,0xFF,0xFF,// 0x68
0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,// 0x69
0x00,0x00,0x1E,0x1F,0x1F,0x1F,0x1F,0x1F,// 0x6A
0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,// 0x6B
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,// 0x6C
0x0F,0x1F,0x7F,0x00,0x00,0x00,0x00,0x00,// 0x6D
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x6E
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x6F

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x80 - mapped to 0x70
0x11,0x32,0x12,0x12,0x12,0x12,0x39,0x00,// 0x81 10
0xF9,0x12,0x22,0x12,0x0A,0x8A,0x71,0x00,// 0x82 30
0xF9,0x82,0xF2,0x0A,0x0A,0x8A,0x71,0x00,// 0x83 50
0xF9,0x8A,0x12,0x12,0x22,0x22,0x21,0x00,// 0x84 70
0x8C,0x52,0x52,0x52,0x52,0x52,0x8C,0x00,// 0x85 00
0x46,0xC9,0x49,0x49,0x49,0x49,0xE6,0x00,// 0x86 10
0x01,0x02,0x02,0x00,0x00,0x01,0x03,0x00,// 0x87
0xC6,0x29,0x29,0x49,0x89,0x09,0xE6,0x00,// 0x88 20
0x03,0x00,0x00,0x00,0x00,0x02,0x01,0x00,// 0x89
0xE6,0x49,0x89,0x49,0x29,0x29,0xC6,0x00,// 0x8A 30
0x03,0x02,0x03,0x00,0x00,0x02,0x01,0x00,// 0x8B
0xE6,0x09,0xC9,0x29,0x29,0x29,0xC6,0x00,// 0x8C 50
0x31,0x4A,0x4A,0x4A,0x4A,0x4A,0x31,0x00,// 0x8D 00
0x80,0x40,0x40,0x40,0x40,0x40,0x80,0x00,// 0x8E
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// 0x8F
};

// 8x8 sprites 256,2 bit
const byte pacman8x8x2[] = {
// pacman
0x00,0x00,0x00,0x00,0xA0,0x00,0xA8,0x00,0xAA,0x00,0xAA,0x80,0xAA,0x80,0x2A,0x80,
0x00,0x00,0x00,0x00,0x00,0x2A,0x00,0xAA,0x02,0xAA,0x00,0x2A,0x00,0x02,0x00,0x00,
0xAA,0x80,0xAA,0x80,0xAA,0x00,0xA8,0x00,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x2A,0x02,0xAA,0x00,0xAA,0x00,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,

// cherry
0x00,0x00,0x00,0x00,0x00,0x50,0x05,0x50,0x51,0x00,0x01,0x00,0x04,0x00,0x10,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0xF4,0x0F,0xDF,
0xDF,0x00,0xDF,0xC0,0xFF,0xC0,0xBF,0xC0,0xEF,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFC,0x0E,0xF3,0x0F,0xB3,0x03,0xF3,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,

//#if 0
// strawberry
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00,0x5F,0x00,0xFE,0xC0,0xEF,0xC0,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x56,0x03,0xD5,0x0F,0xFD,0x0E,0xFF,0x0F,0xEE,
0xFB,0xC0,0xFF,0x00,0xFF,0x00,0xE0,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0x03,0xBE,0x03,0xFF,0x00,0xFB,0x00,0x3F,0x00,0x03,0x00,0x00,0x00,0x00,

// peach
0x00,0x00,0x00,0x00,0x14,0x00,0x55,0x40,0x15,0x00,0xBF,0x00,0xFF,0xC0,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0xFA,0x03,0xFE,0x0F,0xFF,
0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xFF,0xC0,0xFF,0xC0,0xFC,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,0x03,0xFF,0x03,0xFF,0x00,0x3F,0x00,0x00,0x00,0x00,

// bell
0x00,0x00,0x00,0x00,0xC0,0x00,0x3C,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0xC0,
0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x3C,0x00,0xFF,0x00,0xF3,0x00,0xCF,0x03,0xCF,
0xFF,0xC0,0xFF,0xC0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xA5,0x70,0xA5,0x40,0x00,0x00,
0x03,0xCF,0x03,0xFF,0x0F,0x3F,0x0F,0x3F,0x0F,0xFF,0x0D,0x55,0x01,0x55,0x00,0x00,

// apple
0x00,0x00,0x00,0x00,0x40,0x00,0x3F,0x00,0xFF,0xC0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xF1,0x0F,0xFD,0x0F,0xFF,0x0F,0xFF,0x0F,0xFF,
0xFE,0xF0,0xFE,0xF0,0xFB,0xC0,0xFF,0xC0,0xFF,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,
0x0F,0xFF,0x0F,0xFF,0x03,0xFF,0x03,0xFF,0x00,0xFF,0x00,0x3C,0x00,0x00,0x00,0x00,

// grape
0x00,0x00,0x00,0x00,0xFC,0x00,0xC0,0x00,0x90,0x00,0xD5,0x00,0x57,0x40,0x6D,0x40,
0x00,0x00,0x00,0x30,0x00,0x0F,0x00,0x00,0x00,0x01,0x00,0x15,0x00,0x7B,0x00,0x5D,
0x77,0x50,0xD6,0xD0,0x75,0x50,0xED,0x40,0x57,0x40,0x5D,0x00,0x70,0x00,0x00,0x00,
0x01,0xB5,0x01,0xD6,0x01,0xB5,0x00,0x5E,0x00,0x57,0x00,0x1D,0x00,0x01,0x00,0x00,

// galaxian
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0xC0,0x50,0xC0,0x96,0xC0,0xAA,0xC0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0C,0x05,0x0C,0x15,0x0E,0x59,0x0E,0xA9,
0xAB,0xC0,0x2F,0x00,0x3C,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0xAA,0x03,0xE2,0x00,0xF2,0x00,0x32,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,

// key
0x00,0x00,0x00,0x00,0x40,0x00,0x14,0x00,0x54,0x00,0x54,0x00,0x54,0x00,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x50,0x00,0x55,0x00,0x55,0x00,0x55,0x00,0x08,
0xA0,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0xA0,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x02,0x00,0x00,
///#endif
};

//  16x16 sprites 2 bit
//  Pixels are swizzled within byte 3210 instead of 0123
const byte pacman16x16[] = {
// 0
0x00,0x00,0x00,0x00,
0x00,0x50,0x05,0x00,
0x00,0x55,0x55,0x00,
0x40,0x55,0x55,0x01,
0x50,0x55,0x55,0x05,
0x50,0x55,0x55,0x05,
0x50,0x69,0x69,0x05,
0x54,0x69,0x69,0x15,
0x54,0x55,0x55,0x15,
0x54,0x55,0x55,0x15,
0x94,0x96,0x96,0x16,
0x64,0x69,0x69,0x19,
0x54,0x55,0x55,0x15,
0x14,0x15,0x54,0x14,
0x04,0x14,0x14,0x10,
0x00,0x00,0x00,0x00,
// 1
0x00,0x00,0x00,0x00,
0x00,0x50,0x05,0x00,
0x00,0x55,0x55,0x00,
0x40,0x55,0x55,0x01,
0x50,0x55,0x55,0x05,
0x50,0x55,0x55,0x05,
0x50,0x69,0x69,0x05,
0x54,0x69,0x69,0x15,
0x54,0x55,0x55,0x15,
0x54,0x55,0x55,0x15,
0x94,0x96,0x96,0x16,
0x64,0x69,0x69,0x19,
0x54,0x55,0x55,0x15,
0x54,0x51,0x45,0x15,
0x50,0x40,0x01,0x05,
0x00,0x00,0x00,0x00,
// 2
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xAA,0xAA,0x00,
0x80,0xAA,0xAA,0x02,
0xA0,0xBE,0xEA,0x0B,
0xA0,0xFF,0xFA,0x0F,
0xA0,0x5F,0xFA,0x05,
0xA8,0x5F,0xFA,0x25,
0xA8,0xBE,0xEA,0x2B,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0x28,0x2A,0xA8,0x28,
0x08,0x28,0x28,0x20,
0x00,0x00,0x00,0x00,
// 3
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xAA,0xAA,0x00,
0x80,0xAA,0xAA,0x02,
0xA0,0xBE,0xEA,0x0B,
0xA0,0xFF,0xFA,0x0F,
0xA0,0x5F,0xFA,0x05,
0xA8,0x5F,0xFA,0x25,
0xA8,0xBE,0xEA,0x2B,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xA2,0x8A,0x2A,
0xA0,0x80,0x02,0x0A,
0x00,0x00,0x00,0x00,
// 4
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xAA,0xAA,0x00,
0x80,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x0A,
0xA0,0xAF,0xFA,0x0A,
0xE0,0xBF,0xFE,0x0B,
0xE8,0xBF,0xFE,0x2B,
0xE8,0xB5,0x5E,0x2B,
0xA8,0xA5,0x5A,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0x28,0x2A,0xA8,0x28,
0x08,0x28,0x28,0x20,
0x00,0x00,0x00,0x00,
// 5
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xAA,0xAA,0x00,
0x80,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x0A,
0xA0,0xAF,0xFA,0x0A,
0xE0,0xBF,0xFE,0x0B,
0xE8,0xBF,0xFE,0x2B,
0xE8,0xB5,0x5E,0x2B,
0xA8,0xA5,0x5A,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xA2,0x8A,0x2A,
0xA0,0x80,0x02,0x0A,
0x00,0x00,0x00,0x00,
// 6
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xAA,0xAA,0x00,
0x80,0xAA,0xAA,0x02,
0xE0,0xAB,0xBE,0x0A,
0xF0,0xAF,0xFF,0x0A,
0x50,0xAF,0xF5,0x0A,
0x58,0xAF,0xF5,0x2A,
0xE8,0xAB,0xBE,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0x28,0x2A,0xA8,0x28,
0x08,0x28,0x28,0x20,
0x00,0x00,0x00,0x00,
// 7
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xAA,0xAA,0x00,
0x80,0xAA,0xAA,0x02,
0xE0,0xAB,0xBE,0x0A,
0xF0,0xAF,0xFF,0x0A,
0x50,0xAF,0xF5,0x0A,
0x58,0xAF,0xF5,0x2A,
0xE8,0xAB,0xBE,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xA2,0x8A,0x2A,
0xA0,0x80,0x02,0x0A,
0x00,0x00,0x00,0x00,
// 8
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xA5,0x5A,0x00,
0xC0,0xB5,0x5E,0x03,
0xE0,0xBF,0xFE,0x0B,
0xE0,0xBF,0xFE,0x0B,
0xA0,0xAF,0xFA,0x0A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0x28,0x2A,0xA8,0x28,
0x08,0x28,0x28,0x20,
0x00,0x00,0x00,0x00,
// 9
0x00,0x00,0x00,0x00,
0x00,0xA0,0x0A,0x00,
0x00,0xA5,0x5A,0x00,
0xC0,0xB5,0x5E,0x03,
0xE0,0xBF,0xFE,0x0B,
0xE0,0xBF,0xFE,0x0B,
0xA0,0xAF,0xFA,0x0A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xAA,0xAA,0x2A,
0xA8,0xA2,0x8A,0x2A,
0xA0,0x80,0x02,0x0A,
0x00,0x00,0x00,0x00,
// 10
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0xFC,0xC0,0x03,0x0F,
0x03,0x33,0xCC,0x30,
0x03,0x33,0xCC,0x30,
0xC0,0x30,0xCC,0x30,
0x30,0x30,0xCC,0x30,
0x0C,0x30,0xCC,0x30,
0xFF,0xC3,0x03,0x0F,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 11
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0xC0,0xC0,0x03,0x0F,
0xF0,0x30,0xCC,0x30,
0xCC,0x30,0xCC,0x30,
0xC3,0x30,0xCC,0x30,
0xFF,0x33,0xCC,0x30,
0xC0,0x30,0xCC,0x30,
0xC0,0xC0,0x03,0x0F,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 12
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0xFC,0xC0,0x03,0x0F,
0x03,0x33,0xCC,0x30,
0x03,0x33,0xCC,0x30,
0xFC,0x30,0xCC,0x30,
0x03,0x33,0xCC,0x30,
0x03,0x33,0xCC,0x30,
0xFC,0xC0,0x03,0x0F,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 13
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0xC3,0x0F,0x0F,0x3C,
0x33,0xC0,0x30,0xC3,
0x33,0xC0,0x30,0xC3,
0xF3,0xCF,0x30,0xC3,
0x33,0xCC,0x30,0xC3,
0x33,0xCC,0x30,0xC3,
0xC3,0x03,0x0F,0x3C,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 14
0x00,0x00,0x00,0x00,
0x00,0xA8,0x0A,0x00,
0x80,0xAA,0x0A,0x00,
0xA0,0xAA,0x02,0x00,
0xA0,0xAA,0x00,0x00,
0xA8,0x2A,0x00,0x00,
0xA8,0x0A,0x00,0x00,
0xA8,0x02,0x00,0x00,
0xA8,0x0A,0x00,0x00,
0xA8,0x2A,0x00,0x00,
0xA0,0xAA,0x00,0x00,
0xA0,0xAA,0x02,0x00,
0x80,0xAA,0x0A,0x00,
0x00,0xA8,0x0A,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 15
0x00,0x00,0x00,0x00,
0x00,0xA8,0x0A,0x00,
0x80,0xAA,0xAA,0x00,
0xA0,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x02,
0xA8,0x2A,0xAA,0x0A,
0xA8,0x0A,0xA8,0x0A,
0xA8,0x02,0xA0,0x0A,
0xA8,0x00,0x80,0x0A,
0x28,0x00,0x00,0x0A,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 16
0x00,0x00,0x00,0x00,
0x00,0xA8,0x0A,0x00,
0x80,0xAA,0xAA,0x00,
0xA0,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x02,
0xA8,0xAA,0x2A,0x00,
0xA8,0xAA,0x00,0x00,
0xA8,0x02,0x00,0x00,
0xA8,0xAA,0x00,0x00,
0xA8,0xAA,0x2A,0x00,
0xA0,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x02,
0x80,0xAA,0xAA,0x00,
0x00,0xA8,0x0A,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 17
0x00,0x00,0x00,0x00,
0x00,0xA8,0x0A,0x00,
0x80,0xAA,0xAA,0x00,
0xA0,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x02,
0xA8,0xAA,0xAA,0x0A,
0xA8,0x2A,0xAA,0x0A,
0xA8,0x2A,0xAA,0x0A,
0xA8,0x0A,0xA8,0x0A,
0xA8,0x0A,0xA8,0x0A,
0xA0,0x0A,0xA8,0x02,
0xA0,0x02,0xA0,0x02,
0x80,0x02,0xA0,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 18
0x00,0x00,0x00,0x00,
0x00,0xA8,0x0A,0x00,
0x80,0xAA,0xAA,0x00,
0xA0,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x02,
0xA8,0xAA,0xAA,0x0A,
0xA8,0xAA,0xAA,0x0A,
0xA8,0xAA,0xAA,0x0A,
0xA8,0xAA,0xAA,0x0A,
0xA8,0xAA,0xAA,0x0A,
0xA0,0xAA,0xAA,0x02,
0xA0,0xAA,0xAA,0x02,
0x80,0xAA,0xAA,0x00,
0x00,0xA8,0x0A,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 19
0x00,0x00,0x00,0x00,
0x00,0xA0,0x2A,0x00,
0x00,0xAA,0xAA,0x02,
0x80,0xAA,0xAA,0x0A,
0x80,0xAA,0xAA,0x0A,
0x00,0xA8,0xAA,0x2A,
0x00,0x00,0xAA,0x2A,
0x00,0x00,0x80,0x2A,
0x00,0x00,0xAA,0x2A,
0x00,0xA8,0xAA,0x2A,
0x80,0xAA,0xAA,0x0A,
0x80,0xAA,0xAA,0x0A,
0x00,0xAA,0xAA,0x02,
0x00,0xA0,0x2A,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 20
0x00,0x00,0x00,0x00,
0x00,0xA0,0x2A,0x00,
0x00,0xA0,0xAA,0x02,
0x00,0x80,0xAA,0x0A,
0x00,0x00,0xAA,0x0A,
0x00,0x00,0xA8,0x2A,
0x00,0x00,0xA0,0x2A,
0x00,0x00,0x80,0x2A,
0x00,0x00,0xA0,0x2A,
0x00,0x00,0xA8,0x2A,
0x00,0x00,0xAA,0x0A,
0x00,0x80,0xAA,0x0A,
0x00,0xA0,0xAA,0x02,
0x00,0xA0,0x2A,0x00,
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 21 = CHERRY
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xF0, 0x0F, 
  0x00, 0x00, 0xCF, 0x00, 0x00, 0xC0, 0xC0, 0x00, 
  0x40, 0x35, 0x30, 0x00, 0x50, 0x5D, 0x0C, 0x00, 
  0x50, 0x15, 0x5D, 0x00, 0x90, 0x45, 0x5D, 0x01, 
  0x50, 0x46, 0x55, 0x01, 0x40, 0x45, 0x56, 0x01, 
  0x00, 0x40, 0x59, 0x01, 0x00, 0x00, 0x55, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  
// 22 = STRAWBERRY
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x80, 0x00, 0x00, 0x00, 0xBF, 0x3F, 0x00, 
  0x40, 0xFD, 0x5F, 0x00, 0x50, 0xD5, 0x95, 0x01, 
  0x90, 0x55, 0x59, 0x01, 0x50, 0x99, 0x55, 0x01, 
  0x50, 0x55, 0x65, 0x01, 0x40, 0x96, 0x55, 0x00, 
  0x40, 0x55, 0x55, 0x00, 0x00, 0x65, 0x19, 0x00, 
  0x00, 0x54, 0x05, 0x00, 0x00, 0x40, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

// 23 = PEACH
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x3C, 0x00, 0x00, 0x80, 0xFF, 0x03, 
  0x00, 0x80, 0xFC, 0x00, 0x00, 0xA5, 0x56, 0x00, 
  0x40, 0x95, 0x55, 0x01, 0x50, 0x55, 0x55, 0x05, 
  0x50, 0x55, 0x55, 0x05, 0x50, 0x55, 0x55, 0x05, 
  0x50, 0x55, 0x55, 0x05, 0x40, 0x55, 0x55, 0x01, 
  0x40, 0x55, 0x55, 0x01, 0x00, 0x54, 0x15, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  
// 24 = BELL
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01, 0x00, 
  0x00, 0x14, 0x14, 0x00, 0x00, 0x55, 0x15, 0x00, 
  0x40, 0x41, 0x55, 0x00, 0x40, 0x54, 0x55, 0x01, 
  0x50, 0x54, 0x55, 0x01, 0x50, 0x54, 0x55, 0x05, 
  0x50, 0x55, 0x55, 0x05, 0x10, 0x55, 0x55, 0x05, 
  0x14, 0x55, 0x55, 0x15, 0x54, 0x55, 0x55, 0x15, 
  0x54, 0x55, 0x55, 0x15, 0x04, 0x00, 0x2A, 0x14, 
  0x00, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00,
  
// 25 = APPLE
  0x00, 0x00, 0x03, 0x00, 0xA0, 0xC2, 0xA8, 0x02, 
  0xA8, 0xEA, 0xAA, 0x2A, 0xAA, 0xAA, 0xAA, 0x2A, 
  0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
  0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA9, 
  0xAA, 0xAA, 0xAA, 0xA9, 0xAA, 0xAA, 0xAA, 0xA9, 
  0xA8, 0xAA, 0x6A, 0x2A, 0xA8, 0xAA, 0x6A, 0x2A, 
  0xA8, 0xAA, 0xAA, 0x2A, 0x80, 0xAA, 0xAA, 0x02, 
  0x00, 0xAA, 0xAA, 0x00, 0x00, 0x28, 0x2A, 0x00,
  
// 26 = GRAPE
  0x00, 0x03, 0x00, 0x00, 0x00, 0xFC, 0x3F, 0x00, 
  0x00, 0xC0, 0x00, 0x00, 0x00, 0xD0, 0x09, 0x00, 
  0x00, 0xD0, 0x09, 0x00, 0x00, 0xD5, 0x55, 0x00, 
  0x40, 0x7F, 0xD5, 0x01, 0x40, 0x5D, 0x7F, 0x01, 
  0xD0, 0x57, 0xD7, 0x05, 0xD0, 0xF5, 0xD5, 0x07, 
  0xD0, 0x57, 0x57, 0x05, 0x40, 0xFD, 0x7F, 0x01, 
  0x40, 0xFD, 0x7F, 0x01, 0x40, 0x75, 0xD5, 0x01, 
  0x00, 0x55, 0x55, 0x00, 0x00, 0x50, 0x0B, 0x00, 
  
// 27 = GALAXIAN
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 
  0x10, 0xF0, 0x03, 0x01, 0x10, 0xFC, 0x0F, 0x01, 
  0x90, 0xEF, 0xBE, 0x01, 0x90, 0xEA, 0xAA, 0x01, 
  0x50, 0xAA, 0x6A, 0x01, 0x40, 0x89, 0x58, 0x00, 
  0x00, 0x85, 0x14, 0x00, 0x00, 0x84, 0x04, 0x00, 
  0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  
// 28 = KEY
  0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x01, 0x00, 
  0x00, 0x05, 0x14, 0x00, 0x00, 0x55, 0x15, 0x00, 
  0x00, 0x55, 0x15, 0x00, 0x00, 0x55, 0x15, 0x00, 
  0x00, 0xE0, 0x02, 0x00, 0x00, 0xE0, 0x0A, 0x00, 
  0x00, 0xE0, 0x02, 0x00, 0x00, 0xE0, 0x03, 0x00, 
  0x00, 0xE0, 0x02, 0x00, 0x00, 0xE0, 0x0A, 0x00, 
  0x00, 0xE0, 0x02, 0x00, 0x00, 0x80, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

};
