

/*
 *
 * new Font
 *
 * created with GLCDFontCreator
 * original framework by F. Maximilian Thiele
 * Modified By Siddharth Kaul
 *
 *
 * File Name           : callibri_size8.h
 * Date                : 10.11.2012
 * Font size in bytes  : 2438
 * Font width          : 10
 * Font height         : 8
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef NEW_FONT_H
#define NEW_FONT_H

#define NEW_FONT_WIDTH 10
#define NEW_FONT_HEIGHT 8

static uint8_t new_Font[] PROGMEM = {
    0x09, 0x86, // size
    0x0A, // width
    0x08, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x01, 0x01, 0x04, 0x04, 0x05, 0x05, 0x01, 0x01, 0x02, 
    0x02, 0x04, 0x01, 0x02, 0x01, 0x03, 0x04, 0x03, 0x04, 0x04, 
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x02, 0x04, 0x04, 
    0x04, 0x02, 0x05, 0x04, 0x03, 0x04, 0x04, 0x02, 0x02, 0x04, 
    0x03, 0x01, 0x02, 0x03, 0x02, 0x05, 0x04, 0x05, 0x03, 0x05, 
    0x03, 0x03, 0x04, 0x03, 0x04, 0x07, 0x04, 0x04, 0x04, 0x01, 
    0x03, 0x01, 0x03, 0x04, 0x01, 0x03, 0x03, 0x03, 0x04, 0x04, 
    0x02, 0x04, 0x03, 0x01, 0x01, 0x02, 0x01, 0x05, 0x03, 0x04, 
    0x03, 0x04, 0x02, 0x03, 0x02, 0x03, 0x03, 0x05, 0x03, 0x03, 
    0x03, 0x02, 0x01, 0x01, 0x04, 0x04, 
    
    // font data
    0x3E, // 33
    0x06, // 34
    0x1C, 0x16, 0x3C, 0x14, // 35
    0x24, 0x6B, 0x2A, 0x10, // 36
    0x26, 0x17, 0x0C, 0x32, 0x38, // 37
    0x10, 0x2E, 0x2E, 0x32, 0x28, // 38
    0x06, // 39
    0x7F, // 40
    0x42, 0x3C, // 41
    0x02, 0x02, // 42
    0x08, 0x18, 0x08, 0x08, // 43
    0x40, // 44
    0x10, 0x10, // 45
    0x20, // 46
    0x60, 0x1C, 0x03, // 47
    0x1C, 0x22, 0x22, 0x1C, // 48
    0x22, 0x3E, 0x20, // 49
    0x20, 0x32, 0x2E, 0x20, // 50
    0x20, 0x2A, 0x2E, 0x10, // 51
    0x18, 0x14, 0x3E, 0x10, // 52
    0x24, 0x2A, 0x2A, 0x10, // 53
    0x1C, 0x2A, 0x2A, 0x18, // 54
    0x02, 0x32, 0x0E, 0x02, // 55
    0x14, 0x2A, 0x2E, 0x10, // 56
    0x24, 0x2A, 0x2A, 0x1C, // 57
    0x20, // 58
    0x40, 0x20, // 59
    0x08, 0x18, 0x24, 0x24, // 60
    0x10, 0x18, 0x18, 0x10, // 61
    0x24, 0x24, 0x18, 0x08, // 62
    0x38, 0x06, // 63
    0x3C, 0x5A, 0x66, 0x5E, 0x1E, // 64
    0x20, 0x1C, 0x16, 0x38, // 65
    0x3E, 0x2A, 0x34, // 66
    0x1C, 0x22, 0x22, 0x22, // 67
    0x3E, 0x22, 0x36, 0x08, // 68
    0x3E, 0x2A, // 69
    0x1E, 0x0A, // 70
    0x1C, 0x22, 0x2A, 0x3A, // 71
    0x1C, 0x08, 0x1C, // 72
    0x3E, // 73
    0x20, 0x3E, // 74
    0x1C, 0x14, 0x22, // 75
    0x3C, 0x20, // 76
    0x1E, 0x18, 0x30, 0x0C, 0x1E, // 77
    0x1E, 0x08, 0x30, 0x3E, // 78
    0x1C, 0x22, 0x22, 0x22, 0x1C, // 79
    0x1E, 0x0A, 0x04, // 80
    0x1C, 0x22, 0x22, 0x22, 0x5C, // 81
    0x1E, 0x0A, 0x36, // 82
    0x24, 0x2A, 0x3A, // 83
    0x02, 0x1E, 0x02, 0x02, // 84
    0x3C, 0x20, 0x3C, // 85
    0x06, 0x18, 0x30, 0x0C, // 86
    0x06, 0x18, 0x3C, 0x06, 0x38, 0x3C, 0x02, // 87
    0x22, 0x14, 0x1C, 0x22, // 88
    0x02, 0x1C, 0x0C, 0x02, // 89
    0x22, 0x3A, 0x26, 0x20, // 90
    0x7E, // 91
    0x07, 0x18, 0x60, // 92
    0x7E, // 93
    0x08, 0x06, 0x0E, // 94
    0x80, 0x80, 0x80, 0x80, // 95
    0x02, // 96
    0x30, 0x34, 0x3C, // 97
    0x3C, 0x24, 0x18, // 98
    0x18, 0x24, 0x24, // 99
    0x18, 0x24, 0x24, 0x3E, // 100
    0x18, 0x34, 0x34, 0x08, // 101
    0x1E, 0x06, // 102
    0x58, 0x74, 0x7C, 0x04, // 103
    0x1C, 0x04, 0x38, // 104
    0x3E, // 105
    0x7C, // 106
    0x1C, 0x24, // 107
    0x3E, // 108
    0x18, 0x04, 0x38, 0x04, 0x38, // 109
    0x18, 0x04, 0x38, // 110
    0x18, 0x24, 0x24, 0x18, // 111
    0x38, 0x24, 0x18, // 112
    0x18, 0x24, 0x24, 0x7C, // 113
    0x18, 0x04, // 114
    0x28, 0x34, 0x34, // 115
    0x1C, 0x24, // 116
    0x38, 0x20, 0x3C, // 117
    0x0C, 0x30, 0x18, // 118
    0x0C, 0x30, 0x18, 0x38, 0x3C, // 119
    0x24, 0x18, 0x2C, // 120
    0x0C, 0x70, 0x18, // 121
    0x24, 0x3C, 0x24, // 122
    0x08, 0x76, // 123
    0x7F, // 124
    0x7E, // 125
    0x04, 0x04, 0x04, 0x04, // 126
    0x3E, 0x26, 0x2E, 0x3E // 127
    
};

#endif
