

/*
 *
 * new Font
 *
 * created with GLCDFontCreator
 * original framework by F. Maximilian Thiele
 * Modified By Siddharth Kaul
 *
 *
 * File Name           : cooper_std_black_size20.h
 * Date                : 10.11.2012
 * Font size in bytes  : 23979
 * Font width          : 10
 * Font height         : 21
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef NEW_FONT_H
#define NEW_FONT_H

#define NEW_FONT_WIDTH 10
#define NEW_FONT_HEIGHT 21

static uint8_t new_Font[] PROGMEM = {
    0x5D, 0xAB, // size
    0x0A, // width
    0x15, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x05, 0x0A, 0x09, 0x0B, 0x11, 0x12, 0x05, 0x0A, 0x09, 
    0x08, 0x0A, 0x05, 0x06, 0x05, 0x0A, 0x0C, 0x0B, 0x0C, 0x0C, 
    0x0C, 0x0B, 0x0D, 0x0C, 0x0C, 0x0C, 0x05, 0x05, 0x0A, 0x0A, 
    0x0A, 0x0A, 0x0F, 0x12, 0x0F, 0x0E, 0x10, 0x0F, 0x0E, 0x10, 
    0x10, 0x09, 0x0E, 0x12, 0x0D, 0x12, 0x12, 0x0F, 0x0E, 0x0F, 
    0x10, 0x0C, 0x0F, 0x11, 0x11, 0x16, 0x10, 0x10, 0x0E, 0x08, 
    0x0A, 0x08, 0x0A, 0x0A, 0x05, 0x0C, 0x0D, 0x0B, 0x0E, 0x0B, 
    0x09, 0x0C, 0x0E, 0x07, 0x06, 0x10, 0x08, 0x14, 0x0E, 0x0D, 
    0x0E, 0x0E, 0x0B, 0x09, 0x0A, 0x0E, 0x0D, 0x15, 0x0D, 0x0D, 
    0x0B, 0x08, 0x02, 0x08, 0x0A, 0x0A, 
    
    // font data
    0x78, 0xFC, 0xFC, 0xFC, 0x78, 0x60, 0xF1, 0xF3, 0xF1, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, // 33
    0x78, 0xFC, 0xFC, 0xFC, 0x78, 0x78, 0xFC, 0xFC, 0xFC, 0x78, 0x00, 0x01, 0x03, 0x01, 0x00, 0x00, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x00, 0x00, 0x00, 0xE0, 0x20, 0x00, 0xE0, 0x60, 0x00, 0x1B, 0xDB, 0xFF, 0x1F, 0x9B, 0xFF, 0x1F, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 35
    0xC0, 0xE0, 0xF0, 0xF0, 0xFC, 0xBC, 0x30, 0x70, 0x70, 0xF0, 0x40, 0x79, 0x77, 0xE7, 0xCF, 0xCF, 0xCF, 0xFF, 0xFF, 0x7E, 0x7E, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, // 36
    0x70, 0xF8, 0xF8, 0xCC, 0x9C, 0xFC, 0xF8, 0x70, 0x80, 0xC0, 0x70, 0x38, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x81, 0xC1, 0x71, 0x18, 0x0E, 0x03, 0x39, 0x7C, 0xFC, 0xE6, 0xCE, 0xFE, 0x7C, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 37
    0x70, 0xF8, 0xF8, 0xFC, 0xFC, 0x8C, 0x8C, 0x1C, 0x18, 0x80, 0x80, 0xC0, 0xE8, 0xFC, 0xFC, 0xFC, 0x7C, 0x38, 0x0E, 0x3F, 0x7F, 0x7F, 0xFF, 0xF1, 0xE1, 0xCE, 0xCF, 0xC7, 0xE7, 0x7F, 0x7F, 0x7F, 0x3D, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 38
    0x78, 0xFC, 0xFC, 0xFC, 0x78, 0x00, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 39
    0xC0, 0xF0, 0xFC, 0xFE, 0xFE, 0x1F, 0x07, 0x03, 0x03, 0x02, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x18, 0x18, 0x18, 0x10, // 40
    0x03, 0x03, 0x07, 0x1F, 0xFE, 0xFE, 0xFC, 0xF0, 0xC0, 0x00, 0x00, 0x80, 0xE0, 0xFF, 0xFF, 0xFF, 0x3F, 0x0F, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x00, 0x00, // 41
    0x10, 0xB0, 0xF0, 0xFC, 0xFC, 0xF0, 0xB0, 0x30, 0x00, 0x01, 0x01, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0xFF, 0xFF, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00, 0x60, 0x78, 0x38, 0x08, // 44
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xF8, 0xF8, 0xF8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, // 46
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xFC, 0x3C, 0x0C, 0x00, 0x80, 0xE0, 0xF8, 0x3E, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x30, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 47
    0x00, 0xC0, 0xE0, 0xE0, 0xF0, 0x70, 0xF0, 0xF0, 0xE0, 0xE0, 0xC0, 0x00, 0x0F, 0x3F, 0x7F, 0x7F, 0xFF, 0xF0, 0xE0, 0xFF, 0x7F, 0x7F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 48
    0x40, 0x40, 0x60, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0x30, 0x20, 0x00, 0x40, 0xC0, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xC0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 49
    0x80, 0xC0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xC0, 0x00, 0x81, 0xC1, 0xE1, 0xF0, 0xFC, 0xFF, 0xFF, 0xFF, 0xE7, 0xE3, 0xF1, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, // 50
    0xC0, 0x40, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x0E, 0x0F, 0x9F, 0xFF, 0xFF, 0xFD, 0xFC, 0xF8, 0x70, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x08, 0x00, 0x00, // 51
    0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xF0, 0xF0, 0xF8, 0xF8, 0xF8, 0x00, 0x70, 0x7C, 0x7E, 0x73, 0x71, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, // 52
    0x00, 0xC0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0x70, 0x0E, 0x1F, 0x1F, 0x1F, 0x3E, 0xFE, 0xFC, 0xFC, 0xFC, 0xF8, 0x70, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x00, // 53
    0x00, 0xC0, 0xE0, 0xF0, 0xF8, 0xF8, 0x30, 0x10, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x3F, 0x7F, 0x7F, 0xFF, 0xF3, 0xE3, 0xE7, 0xFF, 0x7F, 0x7F, 0x3F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 54
    0xE0, 0xF8, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0x70, 0x01, 0x01, 0x01, 0x00, 0x80, 0xE0, 0xF8, 0xFE, 0x7F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, // 55
    0x00, 0xE0, 0xF0, 0xF0, 0xF8, 0xF8, 0x98, 0x98, 0xF8, 0xF0, 0xF0, 0xE0, 0x18, 0x7C, 0x7F, 0xE7, 0xC7, 0xCF, 0xCF, 0xFF, 0xFF, 0x7F, 0x7E, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 56
    0x80, 0xC0, 0xE0, 0xE0, 0xF0, 0x70, 0xF0, 0xF0, 0xE0, 0xE0, 0xC0, 0x80, 0x07, 0x0F, 0x1F, 0x1F, 0x9F, 0xDC, 0xF8, 0xFF, 0xFF, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x08, 0x08, 0x18, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, // 57
    0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0x71, 0xFB, 0xFB, 0xFB, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, // 58
    0xC0, 0xE0, 0xE0, 0xE0, 0xC0, 0xF1, 0xF3, 0xF3, 0xF3, 0xE1, 0x00, 0x60, 0x78, 0x38, 0x08, // 59
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0x0C, 0x0E, 0x1E, 0x1F, 0x3F, 0x33, 0x33, 0x71, 0x61, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0xC0, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x61, 0x71, 0x33, 0x33, 0x3F, 0x1F, 0x1E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x70, 0x78, 0x78, 0x1C, 0xCC, 0xFC, 0xFC, 0xF8, 0xF8, 0x70, 0x00, 0x00, 0x60, 0xF3, 0xF3, 0xF3, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 63
    0x00, 0xC0, 0x30, 0x18, 0x88, 0xC8, 0xE4, 0xE4, 0x64, 0xC4, 0xEC, 0xE8, 0x18, 0xF0, 0xE0, 0x07, 0x3F, 0x70, 0x5E, 0x5F, 0x9F, 0x89, 0x8C, 0x9E, 0x9F, 0x5F, 0x68, 0x2C, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 64
    0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xFC, 0x7C, 0xFE, 0xFC, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0xF0, 0xFC, 0xFF, 0xCF, 0x0D, 0x0C, 0x0C, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF0, 0xE0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 65
    0x00, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xF8, 0x70, 0x00, 0x80, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xC3, 0xFF, 0xFF, 0xFF, 0x7F, 0x7E, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 66
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x3C, 0x1C, 0x1C, 0x1C, 0x3C, 0x78, 0xF8, 0xF8, 0xF0, 0x07, 0x1F, 0x3F, 0x7F, 0x7F, 0xFE, 0xF8, 0xF8, 0xF0, 0xF0, 0x70, 0x70, 0x78, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 67
    0x00, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x1C, 0x3C, 0xF8, 0xF8, 0xF8, 0xF0, 0xC0, 0x40, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0xE0, 0xF0, 0x7F, 0x7F, 0x3F, 0x3F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 68
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0xCC, 0xCC, 0x1C, 0x3C, 0x38, 0x00, 0x80, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xC3, 0xCF, 0xC7, 0xE0, 0xF0, 0x78, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 69
    0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0xCC, 0x9C, 0x1C, 0x7C, 0x78, 0x40, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x43, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x3C, 0x0C, 0x0C, 0x0C, 0x1C, 0x3C, 0x7C, 0x7C, 0x78, 0x00, 0x00, 0x07, 0x1F, 0x3F, 0x7F, 0x7F, 0x7C, 0xF0, 0xE0, 0xE4, 0xE6, 0x7E, 0x7E, 0x3E, 0x1E, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 71
    0x00, 0x18, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x1C, 0x00, 0x18, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x1C, 0x40, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x43, 0x03, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 72
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x08, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 73
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x1C, 0x08, 0x38, 0x78, 0x7C, 0xF8, 0xF8, 0xC0, 0xE0, 0xFF, 0xFF, 0x7F, 0x3F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 74
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0xC0, 0xF8, 0xFC, 0x3C, 0x1C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x0F, 0x1F, 0x3F, 0x7F, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 75
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0xC0, 0xE0, 0xF0, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 76
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xF8, 0xF0, 0x80, 0x00, 0xC0, 0xF0, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0x1C, 0xC0, 0xE0, 0xFF, 0xFF, 0xFF, 0xC3, 0x0F, 0x3F, 0x7F, 0x3F, 0x0F, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 77
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0xC0, 0x88, 0x0C, 0xFC, 0xFC, 0xFC, 0x1C, 0x08, 0x80, 0xE0, 0xFF, 0xFF, 0xFF, 0xE3, 0x43, 0x07, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 78
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x3C, 0x1C, 0x1C, 0x3C, 0xFC, 0xF8, 0xF8, 0xF0, 0xE0, 0x80, 0x07, 0x1F, 0x3F, 0x7F, 0x7F, 0xFE, 0xF0, 0xE0, 0xE0, 0xF0, 0x7F, 0x7F, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 79
    0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x1C, 0xFC, 0xFC, 0xF8, 0xF8, 0xE0, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x46, 0x06, 0x07, 0x07, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x3C, 0x1C, 0x1C, 0x3C, 0xFC, 0xF8, 0xF8, 0xF0, 0xE0, 0x80, 0x0F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF0, 0xE0, 0xE0, 0xE1, 0xFF, 0x7F, 0x3F, 0x3F, 0x0F, 0x08, 0x08, 0x08, 0x18, 0x18, 0x38, 0x38, 0x38, 0x78, 0x78, 0x78, 0x70, 0x70, 0x30, 0x10, // 81
    0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0xFC, 0xFC, 0xFC, 0xF8, 0x70, 0x00, 0x00, 0x80, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x03, 0x1F, 0x7F, 0xFF, 0xFE, 0xFC, 0xF8, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 82
    0xE0, 0xF8, 0xF8, 0xFC, 0xFC, 0xCC, 0xCC, 0x8C, 0x9C, 0x3C, 0x3C, 0x30, 0x78, 0x73, 0xE3, 0xC7, 0xC7, 0xCF, 0xCF, 0xFF, 0x7F, 0x7F, 0x7F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 83
    0x60, 0x78, 0x7C, 0x3C, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x1C, 0x3C, 0x7C, 0x7C, 0x70, 0x00, 0x00, 0x00, 0x40, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 84
    0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x08, 0x00, 0x00, 0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0x0C, 0x08, 0x00, 0x1F, 0x3F, 0x7F, 0x7F, 0x7F, 0xF8, 0xE0, 0xE0, 0xE0, 0x60, 0x70, 0x7F, 0x3F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 85
    0x08, 0x1C, 0x3C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x80, 0x00, 0x00, 0xC8, 0xFC, 0xFC, 0x3C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1F, 0x7F, 0xFF, 0xFF, 0x7E, 0x3F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 86
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x80, 0x08, 0x9C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xC8, 0x00, 0x8C, 0xFC, 0xFC, 0x3C, 0x0C, 0x00, 0x00, 0x00, 0x03, 0x1F, 0x7F, 0xFF, 0xFF, 0x7F, 0x1F, 0x07, 0x03, 0x0F, 0x7F, 0xFF, 0xFF, 0x7F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 87
    0x08, 0x1C, 0x3C, 0x7C, 0xFC, 0xFC, 0xFC, 0xFC, 0xE8, 0xEC, 0x7C, 0x3C, 0x1C, 0x0C, 0x0C, 0x00, 0xC0, 0xC0, 0xE0, 0xF0, 0xF8, 0xFF, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0xF8, 0xF0, 0xE0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 88
    0x0C, 0x0C, 0x1E, 0x7E, 0xFE, 0xFE, 0xFC, 0xFC, 0xE8, 0xC0, 0xFC, 0x7E, 0x3E, 0x1E, 0x0E, 0x04, 0x00, 0x00, 0x00, 0x40, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 89
    0x70, 0x7C, 0x3C, 0x1C, 0x8C, 0xCC, 0xFC, 0xFC, 0xFC, 0xFC, 0x7E, 0x1E, 0x0C, 0x00, 0x80, 0xE0, 0xF8, 0xFE, 0xFF, 0xFF, 0xFF, 0xDF, 0xC7, 0xC1, 0xE0, 0xF0, 0xF8, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 90
    0xFE, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, // 91
    0x0C, 0x3C, 0x7C, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x1F, 0x7C, 0xF0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x38, 0x38, // 92
    0x02, 0x03, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, // 93
    0x00, 0x00, 0x80, 0xF0, 0xF8, 0xF8, 0xF0, 0x80, 0x00, 0x00, 0x18, 0x1E, 0x0F, 0x03, 0x00, 0x00, 0x03, 0x0F, 0x1E, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, // 95
    0x0C, 0x0C, 0x1C, 0x1C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 96
    0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x60, 0x73, 0xFB, 0xFB, 0xF9, 0xC8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 97
    0x10, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x7F, 0xFF, 0xC1, 0xC3, 0xFF, 0x7F, 0x7F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 98
    0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x1E, 0x3F, 0x7F, 0x7F, 0xFF, 0xF0, 0xE0, 0xE1, 0xE3, 0x77, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 99
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xD0, 0xD8, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x1E, 0x7F, 0x7F, 0xFF, 0xFF, 0xE1, 0xC0, 0x60, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 100
    0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x00, 0x0E, 0x3F, 0x7F, 0x7F, 0xFF, 0xF6, 0xE6, 0xE7, 0x67, 0x77, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 101
    0x00, 0x70, 0xF8, 0xFC, 0xCC, 0x8C, 0x1C, 0x3C, 0x38, 0x83, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 102
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0xC0, 0xC0, 0xC0, 0xC0, 0x60, 0x63, 0xF7, 0xFF, 0xFF, 0xCF, 0xC8, 0xC8, 0xCF, 0xE7, 0xC7, 0xC3, 0x80, 0x10, 0x38, 0x78, 0x68, 0x68, 0x68, 0x68, 0x78, 0x38, 0x38, 0x18, 0x08, // 103
    0x18, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 104
    0x98, 0x98, 0xD8, 0xDC, 0xDC, 0xC8, 0x00, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 105
    0x98, 0x98, 0xD8, 0xDC, 0xDC, 0xC8, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x78, 0x78, 0x78, 0x38, 0x18, // 106
    0x20, 0x10, 0xF8, 0xF8, 0xF8, 0xF8, 0xFC, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4E, 0x3F, 0x7F, 0xFF, 0xFD, 0xF8, 0xE0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 107
    0x10, 0x18, 0xF8, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 108
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x41, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 109
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0x01, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 110
    0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x1C, 0x7F, 0x7F, 0xFF, 0xFF, 0xF0, 0xC0, 0xC3, 0xFF, 0x7F, 0x7F, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 111
    0x00, 0x80, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xE0, 0xE0, 0xC0, 0xC0, 0x00, 0x01, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xE1, 0xFF, 0xFF, 0x7F, 0x3F, 0x0F, 0x00, 0x38, 0x38, 0x78, 0x78, 0x78, 0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 112
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x1E, 0x7F, 0x7F, 0xFF, 0xFF, 0xE1, 0x40, 0x41, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x78, 0x78, 0x78, 0x78, 0x78, 0x30, // 113
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x43, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 114
    0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x73, 0xEF, 0xCF, 0xDF, 0xFF, 0xFE, 0xFC, 0x7D, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 115
    0xC0, 0xC0, 0xE0, 0xE0, 0xF0, 0xF8, 0xF0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 116
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x7F, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x40, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 117
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0x40, 0x00, 0x01, 0x07, 0x0F, 0x3F, 0xFF, 0xFE, 0x7C, 0x3E, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 118
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x01, 0x03, 0x0F, 0x3F, 0x7F, 0xFF, 0xFC, 0x3C, 0x0F, 0x0F, 0x1F, 0x3F, 0xFF, 0xFE, 0x7C, 0x1F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 119
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xE1, 0xF3, 0xFF, 0x0F, 0xDF, 0xFF, 0xFE, 0xFF, 0xF1, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 120
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x03, 0x0F, 0x3F, 0xFF, 0xFF, 0xFE, 0xF8, 0x7C, 0x0F, 0x03, 0x00, 0x00, 0x38, 0x78, 0x78, 0x60, 0x60, 0x38, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, // 121
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x83, 0xE1, 0xF8, 0xFC, 0xFF, 0xFF, 0xFF, 0xCF, 0xC3, 0xE1, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 122
    0x00, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x01, 0x01, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x18, 0x18, 0x10, 0x10, // 123
    0xFE, 0xFE, 0xFF, 0xFF, 0xF8, 0xF8, // 124
    0x01, 0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x10, 0x10, 0x18, 0x18, 0x18, 0x08, 0x00, 0x00, // 125
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1E, 0x1E, 0x0E, 0x0C, 0x0C, 0x1C, 0x1E, 0x1E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFC, 0x1C, 0x34, 0xC4, 0x84, 0x84, 0xC4, 0x34, 0x1C, 0xFC, 0xFF, 0xE0, 0xB0, 0x8C, 0x87, 0x87, 0x8C, 0xB0, 0xE0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 127
    
};

#endif
