

/*
 *
 * new Font
 *
 * created with GLCDFontCreator
 * original framework by F. Maximilian Thiele
 * Modified By Siddharth Kaul
 *
 *
 * File Name           : times_news_roman_size16_italic.h
 * Date                : 10.11.2012
 * Font size in bytes  : 10998
 * Font width          : 10
 * Font height         : 16
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef NEW_FONT_H
#define NEW_FONT_H

#define NEW_FONT_WIDTH 10
#define NEW_FONT_HEIGHT 16

static uint8_t new_Font[] PROGMEM = {
    0x2A, 0xF6, // size
    0x0A, // width
    0x10, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x03, 0x05, 0x07, 0x07, 0x0C, 0x0B, 0x01, 0x04, 0x04, 
    0x06, 0x09, 0x02, 0x04, 0x02, 0x04, 0x07, 0x05, 0x07, 0x06, 
    0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x04, 0x05, 0x09, 0x09, 
    0x09, 0x06, 0x0E, 0x09, 0x09, 0x0A, 0x0B, 0x0A, 0x0A, 0x0B, 
    0x0B, 0x05, 0x07, 0x0B, 0x08, 0x0D, 0x0B, 0x0A, 0x0A, 0x0A, 
    0x09, 0x08, 0x08, 0x0A, 0x08, 0x0B, 0x0A, 0x07, 0x09, 0x07, 
    0x02, 0x07, 0x07, 0x08, 0x02, 0x07, 0x07, 0x06, 0x08, 0x06, 
    0x05, 0x08, 0x07, 0x03, 0x04, 0x08, 0x04, 0x0B, 0x07, 0x07, 
    0x07, 0x07, 0x06, 0x06, 0x04, 0x07, 0x07, 0x0A, 0x07, 0x07, 
    0x06, 0x05, 0x01, 0x05, 0x08, 0x08, 
    
    // font data
    0x00, 0xC0, 0x3E, 0x08, 0x03, 0x00, // 33
    0x3C, 0x06, 0x00, 0x3C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x20, 0xE0, 0x38, 0x26, 0x20, 0xE0, 0x38, 0x0D, 0x03, 0x01, 0x01, 0x0D, 0x03, 0x01, // 35
    0x00, 0x1C, 0x32, 0xE2, 0x5E, 0x83, 0x0C, 0x06, 0x08, 0x1E, 0x09, 0x0C, 0x07, 0x00, // 36
    0x38, 0x44, 0x42, 0x22, 0x1C, 0xC0, 0x60, 0x10, 0x88, 0x44, 0x42, 0x80, 0x00, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x07, 0x08, 0x08, 0x04, 0x03, // 37
    0x80, 0x80, 0x40, 0x40, 0xFC, 0xA2, 0x12, 0x0E, 0x40, 0xC0, 0x40, 0x07, 0x0C, 0x08, 0x08, 0x08, 0x0B, 0x06, 0x0D, 0x09, 0x08, 0x04, // 38
    0x3C, 0x00, // 39
    0x80, 0xE0, 0x30, 0x08, 0x3F, 0x40, 0x00, 0x00, // 40
    0x00, 0x00, 0x06, 0xF8, 0x10, 0x08, 0x07, 0x01, // 41
    0x24, 0x24, 0x18, 0x7E, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x40, 0x40, 0x40, 0x40, 0xFC, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x14, 0x0C, // 44
    0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, // 45
    0x00, 0x00, 0x0C, 0x0C, // 46
    0x00, 0x80, 0x70, 0x0C, 0x06, 0x01, 0x00, 0x00, // 47
    0xE0, 0x18, 0x04, 0x02, 0x02, 0x02, 0xFC, 0x07, 0x08, 0x08, 0x08, 0x04, 0x03, 0x00, // 48
    0x00, 0x00, 0x80, 0x72, 0x0E, 0x08, 0x0C, 0x0B, 0x08, 0x00, // 49
    0x00, 0x00, 0x04, 0x02, 0x82, 0x62, 0x1C, 0x08, 0x0C, 0x0A, 0x09, 0x08, 0x04, 0x00, // 50
    0x00, 0x00, 0x44, 0x62, 0x92, 0x0C, 0x0C, 0x08, 0x08, 0x04, 0x03, 0x00, // 51
    0x80, 0x40, 0x30, 0x08, 0xE4, 0x1E, 0x01, 0x01, 0x01, 0x0D, 0x03, 0x01, // 52
    0x00, 0x00, 0x10, 0x1E, 0x22, 0xC2, 0x02, 0x0C, 0x08, 0x08, 0x08, 0x06, 0x01, 0x00, // 53
    0xC0, 0x70, 0x18, 0x14, 0x14, 0xE2, 0x02, 0x07, 0x08, 0x08, 0x08, 0x06, 0x01, 0x00, // 54
    0x04, 0x02, 0x02, 0xC2, 0x32, 0x0E, 0x02, 0x08, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, // 55
    0x00, 0x80, 0x5C, 0x22, 0x42, 0xA2, 0x1C, 0x07, 0x08, 0x08, 0x08, 0x04, 0x03, 0x00, // 56
    0x00, 0xF0, 0x0C, 0x02, 0x02, 0x82, 0x7C, 0x08, 0x08, 0x09, 0x05, 0x03, 0x01, 0x00, // 57
    0x00, 0x00, 0x60, 0x60, 0x0C, 0x0C, 0x00, 0x00, // 58
    0x00, 0x00, 0x00, 0x60, 0x60, 0x20, 0x14, 0x0C, 0x00, 0x00, // 59
    0x80, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x04, 0x04, // 60
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0x10, 0x10, 0x20, 0x20, 0x20, 0x40, 0x40, 0x40, 0x80, 0x04, 0x04, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x00, // 62
    0x00, 0x0C, 0x82, 0x42, 0x22, 0x1C, 0x08, 0x03, 0x00, 0x00, 0x00, 0x00, // 63
    0xC0, 0x30, 0x08, 0x04, 0xC4, 0x22, 0x12, 0x12, 0xE2, 0x32, 0x04, 0x08, 0xF0, 0x00, 0x0F, 0x10, 0x20, 0x4F, 0x88, 0x88, 0x84, 0x8F, 0x89, 0x88, 0x44, 0x26, 0x11, 0x08, // 64
    0x00, 0x00, 0x00, 0x80, 0xE0, 0x98, 0x84, 0xFE, 0x00, 0x08, 0x0C, 0x0B, 0x00, 0x00, 0x08, 0x08, 0x0F, 0x08, // 65
    0x00, 0x00, 0x80, 0x72, 0x4E, 0x42, 0x42, 0xA2, 0x1C, 0x08, 0x0C, 0x0B, 0x08, 0x08, 0x08, 0x04, 0x03, 0x00, // 66
    0xE0, 0x18, 0x04, 0x04, 0x02, 0x02, 0x02, 0x04, 0x1C, 0x06, 0x03, 0x04, 0x08, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00, 0x00, // 67
    0x00, 0x00, 0x80, 0x72, 0x0E, 0x02, 0x02, 0x02, 0x02, 0x04, 0xF8, 0x08, 0x0C, 0x0B, 0x08, 0x08, 0x08, 0x08, 0x04, 0x04, 0x03, 0x00, // 68
    0x00, 0x00, 0x80, 0x72, 0x4E, 0x42, 0xC2, 0x72, 0x02, 0x0E, 0x08, 0x0C, 0x0B, 0x08, 0x08, 0x08, 0x09, 0x0C, 0x02, 0x00, // 69
    0x00, 0x00, 0x80, 0x72, 0x4E, 0x42, 0xC2, 0x72, 0x02, 0x0E, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, // 70
    0xE0, 0x18, 0x04, 0x04, 0x02, 0x02, 0x02, 0x42, 0xC4, 0x5C, 0x46, 0x03, 0x04, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C, 0x03, 0x00, 0x00, // 71
    0x00, 0x00, 0x80, 0x72, 0x4E, 0x42, 0x40, 0x40, 0xC0, 0x72, 0x0E, 0x08, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x0B, 0x08, 0x00, // 72
    0x00, 0x00, 0x80, 0x72, 0x0E, 0x08, 0x0C, 0x0B, 0x08, 0x00, // 73
    0x00, 0x00, 0x00, 0x00, 0xC2, 0x3A, 0x06, 0x0E, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00, // 74
    0x00, 0x00, 0x80, 0x72, 0xCE, 0x22, 0x10, 0x08, 0x0A, 0x06, 0x02, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x01, 0x0A, 0x0C, 0x08, 0x08, 0x00, // 75
    0x00, 0x00, 0x80, 0x72, 0x0E, 0x02, 0x02, 0x00, 0x08, 0x0C, 0x0B, 0x08, 0x08, 0x08, 0x08, 0x0E, // 76
    0x00, 0x00, 0x80, 0x72, 0x0E, 0xFC, 0x00, 0x00, 0xC0, 0x20, 0x90, 0x7C, 0x0E, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x0F, 0x06, 0x01, 0x08, 0x0C, 0x0B, 0x08, 0x00, // 77
    0x00, 0x00, 0x82, 0x72, 0x0E, 0x38, 0xC0, 0x00, 0x00, 0xE2, 0x1E, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x00, 0x03, 0x0C, 0x07, 0x00, 0x00, // 78
    0xC0, 0x30, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x84, 0x78, 0x03, 0x04, 0x08, 0x08, 0x08, 0x08, 0x04, 0x02, 0x01, 0x00, // 79
    0x00, 0x00, 0x80, 0x72, 0x4E, 0x42, 0x42, 0x42, 0x22, 0x1C, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0xC0, 0x30, 0x08, 0x04, 0x02, 0x02, 0x02, 0x02, 0x84, 0x78, 0x47, 0x3C, 0x28, 0x28, 0x48, 0x44, 0x44, 0x22, 0x21, 0x00, // 81
    0x00, 0x00, 0x80, 0x72, 0x4E, 0xC2, 0x42, 0x22, 0x1C, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x00, 0x03, 0x0C, 0x08, // 82
    0x00, 0x00, 0x1C, 0x22, 0x42, 0x82, 0x04, 0x1C, 0x0C, 0x07, 0x04, 0x08, 0x08, 0x08, 0x07, 0x00, // 83
    0x08, 0x06, 0x02, 0x82, 0x72, 0x0E, 0x02, 0x02, 0x00, 0x08, 0x0C, 0x0B, 0x08, 0x00, 0x00, 0x00, // 84
    0x82, 0x72, 0x0E, 0x02, 0x02, 0x00, 0x00, 0x80, 0x72, 0x0E, 0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00, // 85
    0xC2, 0x3E, 0x02, 0x82, 0x40, 0x30, 0x0E, 0x06, 0x0F, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, // 86
    0x82, 0x7E, 0x02, 0xC0, 0x32, 0x8A, 0x7E, 0x82, 0x42, 0x30, 0x0A, 0x0F, 0x06, 0x01, 0x00, 0x00, 0x0F, 0x06, 0x01, 0x00, 0x00, 0x00, // 87
    0x00, 0x00, 0x02, 0x02, 0x9E, 0xE2, 0x20, 0x10, 0x0A, 0x06, 0x08, 0x0C, 0x0A, 0x01, 0x00, 0x08, 0x0F, 0x08, 0x08, 0x00, // 88
    0x00, 0x02, 0x1E, 0xE2, 0x20, 0x10, 0x0A, 0x08, 0x08, 0x0F, 0x08, 0x00, 0x00, 0x00, // 89
    0x00, 0x00, 0x0E, 0x82, 0x42, 0x22, 0x1A, 0x06, 0x02, 0x08, 0x0C, 0x0B, 0x08, 0x08, 0x08, 0x0C, 0x02, 0x00, // 90
    0x00, 0x00, 0x80, 0x78, 0x06, 0x02, 0x02, 0x60, 0x5C, 0x43, 0x40, 0x00, 0x00, 0x00, // 91
    0x7E, 0xC0, 0x00, 0x0F, // 92
    0x00, 0x00, 0x00, 0x02, 0xC2, 0x3A, 0x06, 0x40, 0x40, 0x60, 0x1C, 0x03, 0x00, 0x00, // 93
    0x40, 0x30, 0x0C, 0x02, 0x0C, 0x30, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, // 95
    0x02, 0x0C, 0x00, 0x00, // 96
    0x00, 0x80, 0x40, 0x20, 0x20, 0xC0, 0x60, 0x0F, 0x08, 0x08, 0x04, 0x0E, 0x0B, 0x04, // 97
    0x00, 0x80, 0x72, 0x4E, 0x20, 0x20, 0xC0, 0x04, 0x0B, 0x08, 0x08, 0x04, 0x06, 0x01, // 98
    0x00, 0xC0, 0x40, 0x20, 0x20, 0x60, 0x07, 0x08, 0x08, 0x08, 0x04, 0x00, // 99
    0x00, 0x80, 0x40, 0x20, 0x20, 0xC0, 0x72, 0x0E, 0x0F, 0x08, 0x08, 0x04, 0x0E, 0x0B, 0x04, 0x00, // 100
    0x00, 0xC0, 0x40, 0x20, 0x20, 0xE0, 0x07, 0x0A, 0x0A, 0x09, 0x05, 0x00, // 101
    0x00, 0x20, 0xA0, 0x70, 0x2C, 0x20, 0x1C, 0x03, 0x00, 0x00, // 102
    0x00, 0xC0, 0x40, 0x20, 0x20, 0x20, 0xE0, 0x20, 0x30, 0x4D, 0x4A, 0x4A, 0x4A, 0x51, 0x30, 0x00, // 103
    0x00, 0x80, 0x72, 0x8E, 0x40, 0x20, 0xE0, 0x0C, 0x03, 0x01, 0x00, 0x0C, 0x0B, 0x04, // 104
    0x20, 0xA0, 0x64, 0x0C, 0x0B, 0x04, // 105
    0x00, 0x00, 0xA0, 0x64, 0x20, 0x1C, 0x03, 0x00, // 106
    0x00, 0x80, 0x72, 0x8E, 0x60, 0x20, 0x20, 0x20, 0x0C, 0x03, 0x01, 0x03, 0x0C, 0x08, 0x04, 0x00, // 107
    0x00, 0x80, 0x72, 0x0E, 0x0C, 0x0B, 0x04, 0x00, // 108
    0x00, 0xA0, 0x60, 0x80, 0x40, 0x20, 0xE0, 0x80, 0x40, 0x20, 0xE0, 0x0C, 0x03, 0x01, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x0C, 0x0B, 0x04, // 109
    0x00, 0x20, 0xE0, 0x80, 0x40, 0x20, 0xE0, 0x0C, 0x03, 0x01, 0x00, 0x0C, 0x0B, 0x04, // 110
    0x00, 0xC0, 0x40, 0x20, 0x20, 0x20, 0xC0, 0x07, 0x08, 0x08, 0x08, 0x04, 0x06, 0x01, // 111
    0x20, 0xA0, 0xE0, 0x40, 0x20, 0x20, 0xC0, 0x5C, 0x0B, 0x08, 0x08, 0x04, 0x02, 0x01, // 112
    0x00, 0x80, 0x40, 0x20, 0x20, 0xC0, 0x60, 0x07, 0x08, 0x48, 0x64, 0x5E, 0x03, 0x00, // 113
    0x00, 0xA0, 0xE0, 0x40, 0x20, 0x60, 0x0C, 0x03, 0x00, 0x00, 0x00, 0x00, // 114
    0x00, 0xC0, 0x20, 0x20, 0x20, 0x60, 0x0E, 0x08, 0x09, 0x09, 0x06, 0x00, // 115
    0x00, 0xA0, 0x70, 0x28, 0x0C, 0x0B, 0x08, 0x04, // 116
    0x40, 0xA0, 0x60, 0x00, 0x00, 0x80, 0x60, 0x0C, 0x0B, 0x08, 0x04, 0x0E, 0x0B, 0x04, // 117
    0x20, 0x60, 0xC0, 0x00, 0x00, 0x20, 0xE0, 0x00, 0x00, 0x0F, 0x04, 0x02, 0x01, 0x00, // 118
    0x20, 0x60, 0xC0, 0x00, 0x00, 0x80, 0xE0, 0x00, 0x20, 0xE0, 0x00, 0x00, 0x0F, 0x02, 0x01, 0x00, 0x0F, 0x04, 0x03, 0x00, // 119
    0x00, 0x20, 0x20, 0xE0, 0x40, 0x20, 0x20, 0x08, 0x0C, 0x02, 0x01, 0x0E, 0x08, 0x00, // 120
    0x20, 0x60, 0xC0, 0x00, 0x00, 0xA0, 0x60, 0x20, 0x10, 0x0F, 0x04, 0x02, 0x01, 0x00, // 121
    0x40, 0x20, 0x20, 0xA0, 0x60, 0x20, 0x0C, 0x0A, 0x09, 0x08, 0x04, 0x00, // 122
    0x80, 0x40, 0x38, 0x0C, 0x02, 0x38, 0x47, 0x00, 0x00, 0x00, // 123
    0xFE, 0xFF, // 124
    0x00, 0x00, 0x00, 0xE2, 0x1C, 0x40, 0x30, 0x1C, 0x02, 0x01, // 125
    0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, // 126
    0xFE, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x0F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0F // 127
    
};

#endif
