/*
 * vi:ts=4
 * test code for the openGLCD library.
 */


#include <openGLCD.h>
#include "fonts/Arial14.h"             // proportional font
#include "fonts/SystemFont5x7.h"       // system font
#include "bitmaps/ArduinoIcon64x64.h"  // 64x64 bitmap 
#include "bitmaps/ArduinoIcon64x32.h"

unsigned long startMillis;
unsigned int loops = 0;
unsigned int iter = 0;
Image_t icon;


#define BAPDEBUG
#define SERIALPRINTF

GLCDXBMAPDECL(Bill1_xbm) = {
114,64,
   0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 0x80, 0xff, 0x07, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x1f, 0x00, 0x80,
   0xff, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff,
   0x01, 0x00, 0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfe, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0x38, 0x00, 0x00,
   0x00, 0x80, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0f, 0x00, 0x00,
   0x38, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x07, 0x00, 0x00, 0x80, 0xff,
   0x01, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x7e, 0x00,
   0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00, 0x00, 0x18,
   0x00, 0xc0, 0x01, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x9c, 0x03, 0x00,
   0x00, 0x00, 0x70, 0x01, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00,
   0x9c, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x1f,
   0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,
   0x00, 0xfe, 0x07, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x03, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00, 0x00, 0xdc, 0x03, 0x00,
   0x00, 0x80, 0x00, 0x80, 0x03, 0x00, 0x80, 0xff, 0x1f, 0x00, 0x00, 0x00,
   0xdc, 0x07, 0x00, 0x00, 0x80, 0x01, 0x00, 0x0e, 0x00, 0xc0, 0x7f, 0x07,
   0x00, 0x00, 0x00, 0xcc, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x38, 0x00,
   0xe0, 0x7f, 0x0a, 0x00, 0x00, 0x00, 0xdc, 0x07, 0x00, 0x00, 0x00, 0x07,
   0x00, 0x30, 0x00, 0xe0, 0x97, 0x00, 0x00, 0x00, 0x00, 0xde, 0x07, 0x00,
   0x00, 0x00, 0x06, 0x00, 0x78, 0x00, 0xf0, 0x35, 0x03, 0x00, 0x00, 0x00,
   0x9c, 0x03, 0x00, 0x00, 0x00, 0x06, 0x00, 0x60, 0x00, 0xfc, 0x63, 0x06,
   0x00, 0x00, 0x00, 0x9c, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0xc0, 0x00,
   0xfc, 0x83, 0x01, 0x00, 0x00, 0x00, 0x3c, 0x05, 0x00, 0x00, 0x02, 0x18,
   0x00, 0xc0, 0x00, 0xfe, 0x03, 0x03, 0x00, 0x00, 0x00, 0x78, 0x06, 0x00,
   0x00, 0x06, 0x20, 0x00, 0x00, 0x00, 0xff, 0x03, 0x07, 0x00, 0x00, 0x00,
   0x50, 0x00, 0x00, 0x00, 0x08, 0x20, 0x00, 0x80, 0x01, 0xdf, 0x80, 0x0f,
   0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x1f, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
   0x00, 0x00, 0x01, 0x1f, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x01, 0x0e, 0x8c, 0x1b, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x03, 0x12, 0x18, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01,
   0x62, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x40,
   0x00, 0x80, 0x01, 0x13, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x40, 0x00, 0x80, 0x03, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x80, 0x03, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xc0, 0x03,
   0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00,
   0x10, 0xe0, 0x01, 0x02, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x02, 0x00,
   0x00, 0x1e, 0x24, 0x18, 0xf0, 0x01, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x01, 0x00, 0x00, 0x1e, 0x32, 0x18, 0xf0, 0x03, 0x06, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0x12, 0x1c, 0xfc, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x03, 0xde,
   0x1e, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x08, 0x00,
   0x00, 0x20, 0x1e, 0x1d, 0x7e, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x0c, 0x00, 0x00, 0x60, 0x0e, 0x18, 0x7f, 0x00, 0x26, 0xc0, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x06, 0x00, 0x00, 0xe0, 0x07, 0xe4, 0x3f, 0x00,
   0x02, 0xfb, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x02, 0x00, 0x00, 0xf0, 0x07,
   0xf0, 0x1f, 0x00, 0xc4, 0x7d, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x02, 0x00,
   0x00, 0xe0, 0x0f, 0xf0, 0x0f, 0x00, 0x70, 0xfe, 0x02, 0x00, 0x00, 0x00,
   0xe0, 0x1e, 0x00, 0x00, 0x80, 0x01, 0xfc, 0x03, 0x00, 0xfe, 0xf8, 0x01,
   0x00, 0x00, 0x00, 0xe0, 0x3e, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00,
   0x68, 0x3e, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x3a, 0x00, 0x00, 0x00, 0x00,
   0xff, 0x01, 0x00, 0xbc, 0xdb, 0x03, 0x00, 0x00, 0x00, 0xc0, 0x3e, 0x00,
   0x00, 0x00, 0x80, 0xfb, 0x00, 0x00, 0xfc, 0xed, 0x0f, 0x00, 0x00, 0x00,
   0xc0, 0x3e, 0x00, 0x00, 0x00, 0xc0, 0xfe, 0x00, 0x00, 0xf8, 0xf6, 0x0f,
   0x00, 0x00, 0x00, 0xc0, 0x0d, 0x00, 0x00, 0x00, 0xc0, 0x7e, 0x00, 0x00,
   0xd0, 0xf9, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x2d, 0x00, 0x00, 0x00, 0x80,
   0x3f, 0x00, 0x00, 0xf0, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00,
   0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00, 0x00,
   0x80, 0x3f, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x00, 0xe0, 0xff, 0x07,
   0x00, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00,
   0xc0, 0xff, 0x03, 0x00, 0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0x00, 0xfc,
   0x03, 0x00, 0x00, 0xc0, 0xff, 0x0b, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00,
   0x00, 0x50, 0xff, 0x01, 0x00, 0x00, 0xc0, 0xff, 0x3f, 0x00, 0x00, 0x00,
   0x80, 0x1f, 0x00, 0x00, 0xd8, 0xff, 0x06, 0x00, 0x00, 0x80, 0xff, 0x7f,
   0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0xff, 0x0f, 0x1e, 0x00, 0x00,
   0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0xc0, 0xff, 0x03,
   0x3c, 0x00, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x80,
   0xff, 0xff, 0x00, 0x38, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 0x00, 0xff,
   0x13, 0x00, 0xe6, 0xff, 0x07, 0x00, 0x30, 0x00, 0x00, 0x00, 0xfe, 0xff,
   0x0f, 0xff, 0xff, 0x07, 0x80, 0xdf, 0xff, 0x03, 0x00, 0xf0, 0x00, 0x00,
   0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf7, 0x2f, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00 };

GLCDXBMAPDECL(hello_xbm) = {
64,64,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x80, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x40, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0xc0,
   0x02, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x00, 0x60, 0x02, 0x00, 0x00, 0x00,
   0xc0, 0x21, 0x38, 0x20, 0x03, 0x07, 0x00, 0x00, 0x20, 0x1f, 0x2c, 0xa0,
   0x01, 0x19, 0x00, 0x00, 0x20, 0x3e, 0x34, 0xf0, 0x80, 0x11, 0x00, 0x00,
   0x20, 0xf4, 0x1f, 0x30, 0x80, 0x18, 0x00, 0x00, 0x30, 0x18, 0x04, 0x1e,
   0x40, 0x04, 0x00, 0x00, 0x10, 0x08, 0x04, 0x19, 0x40, 0x03, 0x00, 0x00,
   0x08, 0x00, 0xcc, 0x09, 0xc0, 0x01, 0x00, 0x00, 0x08, 0x00, 0x70, 0x08,
   0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x47, 0xf0, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x98, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x1f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x04, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x90, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x38, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x1e, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0x0f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0xc1, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x60, 0x20, 0x10,
   0x63, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x10, 0x88, 0xa3, 0xc0, 0x01, 0x00,
   0x00, 0x00, 0x10, 0x88, 0xa3, 0x41, 0x02, 0x00, 0x00, 0x00, 0x00, 0xf8,
   0x11, 0x41, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe1, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

GLCDXBMAPDECL(crossblack_xbm) = {
12,12,
   0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f,
   0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0f };

GLCDXBMAPDECL(movie_xbm) = {
20,23,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 0xf9, 0xff, 0x0c,
   0x19, 0xe0, 0x0c, 0x1f, 0xc0, 0x0f, 0x19, 0xe0, 0x0c, 0x19, 0xc0, 0x0c,
   0x1f, 0xe0, 0x0f, 0x59, 0xd5, 0x0c, 0xf9, 0xff, 0x0c, 0xff, 0xff, 0x0f,
   0x19, 0xe0, 0x0c, 0x19, 0xc0, 0x0c, 0x1f, 0xe0, 0x0f, 0x19, 0xc0, 0x0c,
   0x19, 0xe0, 0x0c, 0x5f, 0xd5, 0x0f, 0xf9, 0xff, 0x0c, 0xff, 0xff, 0x0f,
   0xfe, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const static unsigned char letter_a_bits[] PROGMEM = {
   0xff, 0xff, 0xff, 0x01, 0xff, 0xef, 0xff, 0x01, 0xff, 0xc7, 0xff, 0x01,
   0xff, 0x83, 0xff, 0x01, 0xff, 0x81, 0xff, 0x01, 0xff, 0x00, 0xff, 0x01,
   0xff, 0x18, 0xff, 0x01, 0xff, 0x3c, 0xff, 0x01, 0x7f, 0x3c, 0xfe, 0x01,
   0x7f, 0x7e, 0xfe, 0x01, 0x3f, 0x7e, 0xfc, 0x01, 0x3f, 0x00, 0xfc, 0x01,
   0x1f, 0x00, 0xf8, 0x01, 0x1f, 0x00, 0xf8, 0x01, 0x1f, 0x7e, 0xf8, 0x01,
   0x0f, 0xff, 0xf0, 0x01, 0x0f, 0xff, 0xf0, 0x01, 0x07, 0xff, 0xe0, 0x01,
   0x87, 0xff, 0xe1, 0x01, 0xc7, 0xff, 0xe3, 0x01, 0xc3, 0xff, 0xc3, 0x01,
   0xc3, 0xff, 0xc3, 0x01, 0xe3, 0xff, 0x8f, 0x01, 0xe1, 0xff, 0x0f, 0x01,
   0xff, 0xff, 0xff, 0x01};

GLCDXBMAPDECL(letter_a_xbm) = {
25,25,
   0xff, 0xff, 0xff, 0x01, 0xff, 0xef, 0xff, 0x01, 0xff, 0xc7, 0xff, 0x01,
   0xff, 0x83, 0xff, 0x01, 0xff, 0x81, 0xff, 0x01, 0xff, 0x00, 0xff, 0x01,
   0xff, 0x18, 0xff, 0x01, 0xff, 0x3c, 0xff, 0x01, 0x7f, 0x3c, 0xfe, 0x01,
   0x7f, 0x7e, 0xfe, 0x01, 0x3f, 0x7e, 0xfc, 0x01, 0x3f, 0x00, 0xfc, 0x01,
   0x1f, 0x00, 0xf8, 0x01, 0x1f, 0x00, 0xf8, 0x01, 0x1f, 0x7e, 0xf8, 0x01,
   0x0f, 0xff, 0xf0, 0x01, 0x0f, 0xff, 0xf0, 0x01, 0x07, 0xff, 0xe0, 0x01,
   0x87, 0xff, 0xe1, 0x01, 0xc7, 0xff, 0xe3, 0x01, 0xc3, 0xff, 0xc3, 0x01,
   0xc3, 0xff, 0xc3, 0x01, 0xe3, 0xff, 0x8f, 0x01, 0xe1, 0xff, 0x0f, 0x01,
   0xff, 0xff, 0xff, 0x01};


const static unsigned char icon_bits[] PROGMEM= {
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xFF, 0x0F,
  0xFF, 0x0F,
  0xFF, 0x0F,
  0xFF, 0x0F,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00 };

const static unsigned char test_bits[] PROGMEM = {
     0xff, 0xff, 0x01, 0x80, 0xfd, 0xbf, 0x05, 0xa0, 0xf5, 0xaf, 0x15, 0xa8,
     0xd5, 0xab, 0x55, 0xaa, 0x55, 0xaa, 0xd5, 0xab, 0x15, 0xa8, 0xf5, 0xaf,
     0x05, 0xa0, 0xfd, 0xbf, 0x01, 0x80, 0xff, 0xff};

GLCDXBMAPDECL(test_bits_xbm) = {
16,16,
     0xff, 0xff, 0x01, 0x80, 0xfd, 0xbf, 0x05, 0xa0, 0xf5, 0xaf, 0x15, 0xa8,
     0xd5, 0xab, 0x55, 0xaa, 0x55, 0xaa, 0xd5, 0xab, 0x15, 0xa8, 0xf5, 0xaf,
     0x05, 0xa0, 0xfd, 0xbf, 0x01, 0x80, 0xff, 0xff};


/*
 * Define a REAL printf since Arduino doesn't have one
 *
 * printf() will automatically put the format string in AVR program space
 * 
 */

#define printf(fmt, ...) GLCD.Printf_P(PSTR(fmt), ##__VA_ARGS__)


#ifdef SERIALPRINTF

/*
 * Define a REAL printf since Arduino doesn't have one
 *
 * SerialPrintf() will automatically put the format string in AVR program space
 * 
 */

#define SerialPrintf(fmt, ...) _SerialPrintf(PSTR(fmt), ##__VA_ARGS__)

extern "C" {
  int serialputc(char c, FILE *fp)
  { 
      if(c == '\n')
        Serial.write('\r'); 
    Serial.write(c); 
  }
}


void _SerialPrintf(const char *fmt, ...)
{
FILE stdiostr;
va_list ap;

  fdev_setup_stream(&stdiostr, serialputc, NULL, _FDEV_SETUP_WRITE);

  va_start(ap, fmt);
  vfprintf_P(&stdiostr, fmt, ap);
  va_end(ap);
}

/*
 * Define an eprintf() function for error output
 * (map it to the SerialPrintf() defined above)
 */
#define eprintf(...) SerialPrintf(__VA_ARGS__)

#endif //SERIALPRINTF


 // Create an array of text areas 
 // In a typical app, each text area would be a meaningful named variable
 // that is initialized when its declared 
 // but its an array here to keep the old example logic unchanged

gText textArea[3];

void
PreDefareatest(uint8_t area)
{
	GLCD.ClearScreen();

	textArea[area].DefineArea(textAreaFULL);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("Full");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaTOP);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("Top");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaBOTTOM);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("Bottom");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaLEFT);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("Left");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaRIGHT);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("Right");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaTOPLEFT);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("TLeft");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaTOPRIGHT);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("TRight");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaBOTTOMLEFT);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("BLeft");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);

	textArea[area].DefineArea(textAreaBOTTOMRIGHT);
	textArea[area].SelectFont(System5x7, BLACK);
	textArea[area].ClearArea();
	textArea[area].print("BRight");
	delay(750);
	textArea[area].SelectFont(System5x7, WHITE);
	textArea[area].ClearArea();
	delay(750);
}

void DefRowColtest(void)
{

	GLCD.SetDisplayMode(NON_INVERTED);
	GLCD.ClearScreen(BLACK);
	
	/*
	 * create a 10 column, 4 row text area
	 */
	GLCD.DefineArea(0,0, 10, 4, System5x7);
	GLCD.ClearArea();

	GLCD.print("10x4 chars");
	delay(750);
	GLCD.print("1234567890");
	delay(750);
	GLCD.print("1234567890");
	delay(750);
	GLCD.print("1234567890");

	delay(2000);

	for(uint8_t x = 0; x < 5; x++)
	{
		GLCD.Printf("line%d\n", x);
		delay(750);
	}
	delay(2000);

	/*
	 * Restore default text area
	 */
  	GLCD.DefineArea(textAreaFULL);
}

void testfunc(void)
{

uint8_t a;

	textArea[0].DefineArea(textAreaTOPLEFT);
  	textArea[0].SelectFont(System5x7, BLACK);

	textArea[1].DefineArea(textAreaTOPRIGHT);
  	textArea[1].SelectFont(System5x7, WHITE);

	textArea[2].DefineArea(textAreaBOTTOM);
  	textArea[2].SelectFont(System5x7, BLACK);

	for(a = 0; a < 3; a++)
	{
		textArea[a].CursorTo(0,1);
		textArea[a].Printf("Area: %d", a);
	}

	for(uint8_t y = 0; y < 3; y++)
	{
		for(uint8_t x = 0; x < 100; x++)
		{
			for(a = 0; a < 3; a++)
			{
				/*
				 * Can use overstrike instead of cleararea() with fixed width fonts
				 */
				textArea[a].CursorTo(0,0);
				textArea[a].Printf("a:%d:%d:%02d", a, y,x);
			}
			delay(20);
		}
	}
	delay(2000);
}

void
setup()
{
#ifdef BAPDEBUG
	Serial.begin(9600);
#ifdef CORE_TEENSY
	delay(500);    // allow USB time to come up.
#endif
eprintf("Serial initialized\n");

#endif
	delay(5);    // allow the hardware time settle

	
	GLCD.Init();   // initialise the library, non inverted writes pixels onto a clear screen
	if(GLCD.Height >= 64)   
		icon = ArduinoIcon64x64;  // the 64 pixel high icon
	else
		icon = ArduinoIcon64x32;  // the 32 pixel high icon


	GLCD.DrawBitmapXBM(Bill1_xbm, 0, 0);


	delay(5000);

	testfunc();

	DefRowColtest();
	PreDefareatest(1);

	GLCD.ClearScreen();

	introScreen();
  	scrollingDemo();

	/*
	 * create/restore full display for "default" text area.
	 */
  	GLCD.DefineArea(textAreaFULL);
  	GLCD.SelectFont(System5x7, BLACK);
	GLCD.ClearScreen();

	printf("hello world\n");
	for(int x = 5; x ; x--)
	{
		printf("%02d\n", x);
		delay(1000);
	}
	delay(5000);
}

void introScreen()
{  
  GLCD.ClearScreen();
  GLCD.SelectFont(Arial_14); // you can also make your own fonts, see playground for details   
   
  GLCD.DrawString(GLCD_GLCDLIB_NAMESTR, gTextfmt_center, 3);
  GLCD.DrawString("v" GLCD_GLCDLIB_VERSIONSTR, gTextfmt_center, GLCD.CharHeight(0) + 2);
  GLCD.DrawRoundRect(0+10,0, GLCD.Right-20, GLCD.CharHeight(0) *2 + 1, 5);  // rounded rectangle around text area   
  countdown(5);  
  GLCD.ClearScreen();
  GLCD.DrawBitmap(icon, GLCD.CenterX-32,0); //draw the bitmap at the given x,y position
  countdown(3);
  GLCD.ClearScreen(); 
  GLCD.SelectFont(System5x7);
  showCharacters("5x7 font:", System5x7);
  countdown(3);
  showCharacters("Arial_14:", Arial_14);
  countdown(3);
  scrollingDemo();
}


void showCharacters(const char * title, const uint8_t * font)
{
	/*
	 * print title on default text area
	 */
	GLCD.CursorTo(0,0);
	GLCD.print(title);

	/*
	 * Create text area #1
	 */
	textArea[1].SelectFont(font, BLACK);
	textArea[1].DefineArea(GLCD.CenterX + 5, 3, GLCD.Right-2, GLCD.Bottom-4, SCROLL_UP);

	GLCD.DrawRoundRect(GLCD.CenterX + 2, 0, GLCD.CenterX -3, GLCD.Bottom, 5);  // rounded rectangle around text area 

	/*
	 * Dump the text to area #1 with 50ms between chars
	 */
	showAscii(1, 50);
}

void  loop(){   // run over and over again
  iter=0; 
  startMillis = millis();
  while(iter++ < 10){   // do 10 iterations
    GLCD.DrawRect(0, 0, GLCD.CenterX, GLCD.Bottom); // rectangle in left side of screen
    GLCD.DrawRoundRect(GLCD.CenterX + 2, 0, GLCD.CenterX - 3, GLCD.Bottom, 5);  // rounded rectangle around text area   
    for(int i=0; i < GLCD.Bottom; i += 4)
      GLCD.DrawLine(1,1, GLCD.CenterX-1, i);  // draw lines from upper left down right side of rectangle  
    GLCD.DrawCircle(GLCD.CenterX/2, GLCD.CenterY-1, GLCD.CenterY-2);   // draw circle centered in the left side of screen  
    GLCD.FillRect( GLCD.CenterX + GLCD.CenterX/2-8 ,GLCD.CenterY + GLCD.CenterY/2 -8,16,16, WHITE); // clear previous spinner position  
    drawSpinner(loops++, GLCD.CenterX + GLCD.CenterX/2, GLCD.CenterY + GLCD.CenterY/2);       // draw new spinner position
    GLCD.GotoXY(GLCD.CenterX/2, GLCD.Bottom -15); // todo             
    GLCD.print(iter);            // print current iteration at the current cursor position 
  } 
  // display iterations per second
  unsigned long duration = millis() - startMillis;
  int fps = 10000 / duration;
  int fps_fract = (10000 % duration) / 10;
  GLCD.ClearScreen();               // clear the screen  
  //  GLCD.CursorTo(GLCD.CenterX/8 + 1,1);   // position cursor - TODO 
  GLCD.GotoXY(GLCD.CenterX + 4, GLCD.CenterY - 8);
  GLCD.print("FPS=");               // print a text string
  GLCD.print(fps);              
  GLCD.print(".");
  GLCD.print(fps_fract);
}

void showAscii(int area, int _delay)
{
  for( char ch = 0x40; ch < 0x7f; ch++)
  {
    textArea[area].print(ch);
    delay(_delay);
  }   
}

void drawSpinner(byte pos, byte x, byte y) {   
  // this draws an object that appears to spin
  switch(pos % 8) {
    case 0 : GLCD.DrawLine( x, y-8, x, y+8); break;
    case 1 : GLCD.DrawLine( x+3, y-7, x-3, y+7);  break;
    case 2 : GLCD.DrawLine( x+6, y-6, x-6, y+6);  break;
    case 3 : GLCD.DrawLine( x+7, y-3, x-7, y+3);  break;
    case 4 : GLCD.DrawLine( x+8, y, x-8, y);      break;
    case 5 : GLCD.DrawLine( x+7, y+3, x-7, y-3);  break;
    case 6 : GLCD.DrawLine( x+6, y+6, x-6, y-6);  break; 
    case 7 : GLCD.DrawLine( x+3, y+7, x-3, y-7);  break;
  } 
}

void countdown(int count){
  GLCD.SelectFont(System5x7); // select fixed width system font 
  while(count--){  // do countdown  
    GLCD.CursorTo(0,1);   // first column, second row (offset is from 0)
    GLCD.print((char)(count + '0'));
    delay(1000);  
  }  
}

// this function demonstrates scrolling bitmaps and text
void scrollingDemo()
{
  int x;

  GLCD.ClearScreen(WHITE);
  GLCD.SelectFont(System5x7, WHITE); // switch to fixed width system font 
  for(x = 0; x< 32; x++)
  {
    GLCD.FillRect(x, x, 31-x, 31-x, BLACK);
    delay(40);
    GLCD.FillRect(x, x, 31-x, 31-x, WHITE);
  }
  for(x = 31; x; x--)
  {
    GLCD.FillRect(x, x, 31-x, 31-x, BLACK);
    delay(40);
    GLCD.FillRect(x, x, 31-x, 31-x, WHITE);
  }

  for(x = 0; x < 8; x++)
  {
    if(GLCD.Height > 32)
      GLCD.DrawBitmap(ArduinoIcon64x64, x, 0, BLACK);
    else
      GLCD.DrawBitmap(ArduinoIcon64x32, x, x, BLACK);
    delay(50);
  }
  GLCD.ClearScreen();

  for(x = 0; x < 16; x++)
  {
    GLCD.DrawBitmap(ArduinoIcon64x32, GLCD.Width /2 -16 + x, 0, WHITE);
    delay(50);
  }
 
 // gotoxy using default text area  
  textArea[0].SelectFont(Arial_14, WHITE);
  for(x=0; x< 15; x++)
  {
    for(byte p = 0; p < GLCD.Height; p+=8)
    {
      GLCD.DrawHLine(0,p, 8);
    }
    GLCD.GotoXY(x,x);
     GLCD.print("@ABCDFGHIJ");
    delay(200);
    GLCD.ClearScreen();
  }

  // CursorToXY using user defined text area  
  textArea[0].DefineArea(0,0, GLCD.Right,GLCD.Bottom, SCROLL_UP);
  textArea[0].SelectFont(Arial_14, WHITE);
  for(x=0; x< 15; x++)
  {
    for(byte p = 0; p < GLCD.Height; p+=8)
    {
      GLCD.DrawHLine(0,p, 8);
    }
     textArea[0].CursorToXY(x,x);
     textArea[0].print("@ABCDFGHIJ");
    delay(200);
    GLCD.ClearScreen();
  }

  GLCD.ClearScreen();  
  textArea[0].DefineArea(0,0, GLCD.CenterX -1,GLCD.CenterY -1, SCROLL_UP);
  textArea[0].SelectFont(System5x7, WHITE);
  textArea[0].CursorTo(0,0);
  textArea[1].DefineArea(GLCD.CenterX,0, GLCD.Right,GLCD.CenterY-1, SCROLL_DOWN);
  textArea[1].SelectFont(System5x7, BLACK);
  textArea[1].CursorTo(0,0);
  textArea[2].DefineArea(textAreaBOTTOM,SCROLL_UP); 
  
  textArea[2].SelectFont(Arial_14, BLACK);
  textArea[2].CursorTo(0,0);

  for(byte area = 0; area< 3; area++)
  {
    showAscii(area, 80);
  }
  for(char c = 0x20; c < 0x7f; c++)
  {
    for(byte area = 0; area < 3; area++)
    {
       textArea[area].print(c);
    }
    delay(50);
  }  

  for(byte area = 0; area< 3; area++)
  {
     textArea[area].ClearArea();
  }
  for(x = 0; x< 15; x++)
  {
    for(byte area = 0; area < 3; area++)
    {
      // The newline needs to be sent just before the string to make
      // the scrolling look correct. It can be moved below
      // the delay but it won't look as good.
      // if the newline is done while printing the number,
      // you lose a line in the text area because of the scroll
      // and it no longer works with only a 2 line text area.

#ifdef XXX
       textArea[area].print("\nline ");
       textArea[area].print(x);
#else
       textArea[area].print("line ");
       textArea[area].println(x);
#endif
       delay(100);
    }
  }
  textArea[1].ClearArea();
  for(x = 0; x < 16; x++)
  {
    GLCD.DrawBitmap(ArduinoIcon64x32, GLCD.Width/2 -16 + x, 0, WHITE);
    delay(50);
  }
  if(GLCD.Height < 64)
  {
     textArea[0].DefineArea(0,0,GLCD.CenterX-1, GLCD.Bottom-1, SCROLL_UP);
  }

  for(char c = 0x20; c < 0x7f; c++)
  {
    textArea[0].print(c);
    if(GLCD.Height > 32 )
    {    
       textArea[2].print(c);
    }           
    delay(50);
  }
  delay(2000);
}
