/*
 *
 * Cooper19
 * Cooper std black size20
 *
 * created with GLCDFontCreator
 * original framework by F. Maximilian Thiele
 * Modified By Siddharth Kaul
 *
 *
 * File Name           : cooper_std_black_size18.h
 * Date                : 10.11.2012
 * Font size in bytes  : 19140
 * Font width          : 10
 * Font height         : 19
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#ifndef _Cooper19_H
#define _Cooper19_H

#define Cooper19_WIDTH 10
#define Cooper19_HEIGHT 19

GLCDFONTDECL(Cooper19) = {
    0x4A, 0xC4, // size
    0x0A, // width
    0x13, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x04, 0x04, 0x09, 0x07, 0x0A, 0x0F, 0x11, 0x04, 0x08, 0x08, 
    0x08, 0x08, 0x05, 0x05, 0x04, 0x09, 0x0B, 0x0A, 0x0B, 0x0B, 
    0x0B, 0x0A, 0x0A, 0x0B, 0x0B, 0x0B, 0x04, 0x05, 0x09, 0x09, 
    0x09, 0x09, 0x0C, 0x0F, 0x0C, 0x0D, 0x0F, 0x0D, 0x0D, 0x0F, 
    0x0D, 0x06, 0x0C, 0x0F, 0x0C, 0x10, 0x10, 0x0E, 0x0D, 0x0E, 
    0x0E, 0x0B, 0x0C, 0x0E, 0x10, 0x14, 0x0F, 0x0F, 0x0D, 0x06, 
    0x09, 0x06, 0x09, 0x09, 0x05, 0x0A, 0x0C, 0x09, 0x0B, 0x0A, 
    0x08, 0x0B, 0x0D, 0x06, 0x06, 0x0D, 0x06, 0x12, 0x0D, 0x0B, 
    0x0B, 0x0B, 0x0A, 0x09, 0x09, 0x0D, 0x0C, 0x13, 0x0C, 0x0B, 
    0x09, 0x07, 0x02, 0x07, 0x08, 0x09, 
    
    // font data
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 0x20 <space>
    0x78, 0xFC, 0xFC, 0x78, 0x30, 0x7B, 0x79, 0x30, 0x00, 0x00, 0x00, 0x00, // 33
    0x78, 0xFC, 0xFC, 0x78, 0x00, 0x78, 0xFC, 0xFC, 0x78, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x00, 0x00, 0xE0, 0x20, 0xE0, 0x60, 0x00, 0x08, 0x69, 0x3F, 0x49, 0x7F, 0x09, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 35
    0xC0, 0xE0, 0xF0, 0xF8, 0xB8, 0x30, 0x20, 0x70, 0xE0, 0xC0, 0x7B, 0xE7, 0xE7, 0xCF, 0xCF, 0xCF, 0xFF, 0x7E, 0x7E, 0x38, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, // 36
    0x30, 0x78, 0xFC, 0xE4, 0xCC, 0xFC, 0x78, 0x38, 0xC0, 0x30, 0x1C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x38, 0x0C, 0x03, 0x18, 0x3C, 0x7E, 0x62, 0x7E, 0x3E, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 37
    0x00, 0xB0, 0xF8, 0xFC, 0xFC, 0xCC, 0xCC, 0x1C, 0x08, 0x80, 0xC0, 0xC0, 0xD8, 0xF8, 0xF8, 0x78, 0x30, 0x07, 0x1F, 0x3F, 0x3F, 0x7F, 0x78, 0x70, 0x60, 0x67, 0x63, 0x33, 0x3F, 0x3F, 0x1F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 38
    0x78, 0xFC, 0xFC, 0x78, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, // 39
    0xC0, 0xF8, 0xFC, 0xFE, 0x0F, 0x07, 0x03, 0x03, 0x07, 0x3F, 0x7F, 0xFF, 0xE0, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, // 40
    0x03, 0x03, 0x07, 0x0F, 0xFE, 0xFC, 0xF8, 0xC0, 0x80, 0x80, 0xC0, 0xE0, 0xFF, 0x7F, 0x3F, 0x07, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, // 41
    0x20, 0xB0, 0xF0, 0xFC, 0xFC, 0xF0, 0xB0, 0x30, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x3F, 0x3F, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x7C, 0xF8, 0xF8, 0x70, 0x00, 0x40, 0x60, 0x20, 0x00, // 44
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x00, 0x00, 0x38, 0x78, 0x78, 0x38, 0x00, 0x00, 0x00, 0x00, // 46
    0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0xF8, 0x3C, 0x0C, 0x80, 0xC0, 0xF8, 0x3E, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 47
    0x80, 0xC0, 0xE0, 0xF0, 0x70, 0x70, 0xF0, 0xE0, 0xE0, 0xC0, 0x00, 0x07, 0x1F, 0x3F, 0x3F, 0x78, 0x70, 0x70, 0x3F, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 48
    0x00, 0x60, 0x60, 0xE0, 0xF0, 0xF0, 0xF0, 0x30, 0x00, 0x00, 0x20, 0x20, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 49
    0xC0, 0xE0, 0x60, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xC0, 0x00, 0x60, 0x70, 0x78, 0x7E, 0x7F, 0x7F, 0x7F, 0x77, 0xF3, 0x78, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 50
    0xC0, 0x40, 0x60, 0x60, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0x00, 0x00, 0x80, 0x80, 0x8C, 0x8E, 0x8F, 0xCF, 0xFF, 0xFF, 0xFC, 0x7C, 0x38, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, // 51
    0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xF0, 0xF0, 0xF0, 0x00, 0x78, 0x7C, 0x76, 0x73, 0x71, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, // 52
    0x00, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x60, 0x8E, 0x8F, 0x8F, 0x9E, 0xFE, 0xFE, 0xFC, 0xFC, 0x7C, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, // 53
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x88, 0x80, 0x80, 0x80, 0x00, 0x07, 0x1F, 0x3F, 0x7F, 0x79, 0x73, 0x7F, 0x3F, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 54
    0xE0, 0xF0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x60, 0x01, 0x01, 0x00, 0x00, 0xC0, 0xF0, 0xFC, 0xFF, 0x1F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, // 55
    0x00, 0xE0, 0xF0, 0xF8, 0xF8, 0xD8, 0x98, 0x98, 0xF8, 0xF0, 0x60, 0x1C, 0x3E, 0x3F, 0x73, 0x63, 0x67, 0x67, 0x7F, 0x3F, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 56
    0x80, 0xE0, 0xE0, 0xF0, 0x70, 0x70, 0xF0, 0xF0, 0xE0, 0xE0, 0x80, 0x07, 0x0F, 0x1F, 0x9F, 0xDC, 0xF8, 0xF8, 0xFF, 0x7F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, // 57
    0x80, 0xC0, 0xC0, 0x80, 0x31, 0x7B, 0x7B, 0x31, 0x00, 0x00, 0x00, 0x00, // 58
    0x00, 0x80, 0xC0, 0xC0, 0x80, 0x38, 0x7D, 0xFB, 0xFB, 0x71, 0x00, 0x40, 0x60, 0x20, 0x00, // 59
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0x06, 0x0E, 0x0F, 0x1F, 0x1B, 0x19, 0x31, 0x31, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0xC0, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x31, 0x31, 0x19, 0x1B, 0x1F, 0x0F, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x20, 0x78, 0x78, 0x3C, 0xCC, 0xFC, 0xFC, 0xF8, 0x70, 0x00, 0x00, 0x30, 0x7A, 0x7B, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 63
    0xC0, 0x30, 0x18, 0x88, 0x84, 0xC4, 0x44, 0xC4, 0xC4, 0x68, 0x18, 0xE0, 0x0F, 0x38, 0x2E, 0x2F, 0x4F, 0x44, 0x4E, 0x4F, 0x2F, 0x34, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 64
    0x00, 0x00, 0x00, 0x00, 0xC0, 0xF8, 0x7C, 0xFC, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x78, 0x7F, 0x6F, 0x0D, 0x0C, 0x0D, 0x6F, 0x7F, 0x7F, 0x7F, 0x7C, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 65
    0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x8C, 0xFC, 0xFC, 0xF8, 0x38, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x61, 0x61, 0x7F, 0x7F, 0x3F, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 66
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x3C, 0x1C, 0x1C, 0x1C, 0x3C, 0x78, 0xF8, 0xF0, 0x07, 0x0F, 0x1F, 0x3F, 0x3F, 0x7E, 0x78, 0x70, 0x70, 0x70, 0x30, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 67
    0x00, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x1C, 0x3C, 0xFC, 0xF8, 0xF8, 0xF0, 0xC0, 0x40, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x70, 0x3F, 0x3F, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 68
    0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x8C, 0xEC, 0xCC, 0x1C, 0x1C, 0x10, 0x40, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x61, 0x61, 0x67, 0x63, 0x70, 0x78, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 69
    0x00, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0xCC, 0x9C, 0x1C, 0x7C, 0x30, 0x40, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x43, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
    0xC0, 0xE0, 0xF0, 0xF8, 0xF8, 0x1C, 0x0C, 0x0C, 0x0C, 0x1C, 0x3C, 0x3C, 0x38, 0x00, 0x00, 0x03, 0x0F, 0x1F, 0x3F, 0x3F, 0x7E, 0x78, 0x70, 0x73, 0x7F, 0x3F, 0x3F, 0x0F, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 71
    0x08, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x80, 0x8C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x21, 0x01, 0x61, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 72
    0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 73
    0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x08, 0x1C, 0x3C, 0x7C, 0x7C, 0x60, 0x70, 0x7F, 0x3F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 74
    0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xCC, 0xE0, 0xFC, 0xFC, 0x1C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x67, 0x07, 0x0F, 0x3F, 0x7F, 0x7E, 0x7C, 0x70, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 75
    0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x70, 0x7C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 76
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xF8, 0xF0, 0xC0, 0x80, 0xC0, 0xF0, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x60, 0x7C, 0x7F, 0x7F, 0x61, 0x07, 0x1F, 0x7F, 0x1F, 0x07, 0x61, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 77
    0x08, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80, 0x8C, 0xFC, 0xFC, 0x0C, 0x08, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x61, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 78
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x1C, 0x1C, 0x3C, 0xFC, 0xF8, 0xF8, 0xF0, 0xE0, 0x80, 0x03, 0x0F, 0x1F, 0x3F, 0x3F, 0x7E, 0x78, 0x70, 0x70, 0x3F, 0x3F, 0x1F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 79
    0x08, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x0C, 0x9C, 0xFC, 0xF8, 0xF8, 0xF0, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x23, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0x80, 0xE0, 0xF0, 0xF8, 0xF8, 0x1C, 0x1C, 0x3C, 0xFC, 0xF8, 0xF8, 0xF0, 0xE0, 0x80, 0x87, 0xDF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF8, 0xF0, 0xF0, 0xBF, 0x9F, 0x9F, 0x8F, 0x87, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x00, // 81
    0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x8C, 0x8C, 0xFC, 0xFC, 0xFC, 0x78, 0x30, 0x00, 0x00, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x61, 0x01, 0x0F, 0x3F, 0x7F, 0x7F, 0x7E, 0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 82
    0xF0, 0xF8, 0xF8, 0xFC, 0xFC, 0xCC, 0xCC, 0x98, 0x98, 0x38, 0x30, 0x3C, 0x39, 0x73, 0x63, 0x67, 0x67, 0x7F, 0x7F, 0x3F, 0x3F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 83
    0x78, 0x3C, 0x1C, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x1C, 0x3C, 0x38, 0x00, 0x00, 0x20, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 84
    0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0xFC, 0xFC, 0xFC, 0x0C, 0x00, 0x0F, 0x1F, 0x3F, 0x3F, 0x78, 0x70, 0x70, 0x70, 0x38, 0x3F, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 85
    0x08, 0x0C, 0x3C, 0xFC, 0xFC, 0xFC, 0xFC, 0xC8, 0x00, 0x00, 0xC8, 0xFC, 0x7C, 0x1C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1F, 0x7F, 0x7F, 0x7F, 0x1F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 86
    0x08, 0x3C, 0xFC, 0xFC, 0xFC, 0xFC, 0x80, 0x0C, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xCC, 0x80, 0x8C, 0xFC, 0xFC, 0x1C, 0x0C, 0x00, 0x00, 0x01, 0x07, 0x3F, 0x7F, 0x7F, 0x3F, 0x0F, 0x01, 0x03, 0x0F, 0x3F, 0x7F, 0x7F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 87
    0x08, 0x1C, 0x3C, 0x7C, 0xFC, 0xFC, 0xFC, 0xE8, 0xEC, 0x7C, 0x3C, 0x1C, 0x0C, 0x0C, 0x00, 0x60, 0x60, 0x70, 0x78, 0x7F, 0x2F, 0x07, 0x7F, 0x7F, 0x7F, 0x7E, 0x7C, 0x78, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 88
    0x08, 0x18, 0x3C, 0x7C, 0xFC, 0xFC, 0xF8, 0xE8, 0xC0, 0xF8, 0xFC, 0x3C, 0x1C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x20, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 89
    0x70, 0x7C, 0x1C, 0x0C, 0x88, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC, 0x3C, 0x0C, 0x00, 0x40, 0x70, 0x7C, 0x7F, 0x7F, 0x7F, 0x7F, 0x67, 0x61, 0x60, 0x70, 0x7C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 90
    0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, // 91
    0x0C, 0x1C, 0x78, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x1F, 0x7C, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, // 92
    0x03, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0xFF, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, // 93
    0x00, 0x00, 0xC0, 0xF8, 0x38, 0xF8, 0xC0, 0x00, 0x00, 0x0C, 0x0F, 0x07, 0x01, 0x00, 0x01, 0x07, 0x0F, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, // 95
    0x0C, 0x0C, 0x1C, 0x1C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 96
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x38, 0x7B, 0x7D, 0x7D, 0x64, 0x3F, 0x7F, 0x7F, 0x7F, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 97
    0x10, 0xF8, 0xF8, 0xF8, 0xFC, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x3F, 0x3F, 0x3F, 0x7F, 0x61, 0x61, 0x63, 0x3F, 0x3F, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 98
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x0E, 0x3F, 0x3F, 0x7F, 0x78, 0x70, 0x71, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 99
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC8, 0xF8, 0xFC, 0xFC, 0xFC, 0x00, 0x0E, 0x3F, 0x7F, 0x7F, 0x61, 0x20, 0x7F, 0x7F, 0x7F, 0x7F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 100
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x0E, 0x3F, 0x3F, 0x7F, 0x76, 0x66, 0x66, 0x67, 0x37, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 101
    0x30, 0xF8, 0xFC, 0xEC, 0xCC, 0x9C, 0xB8, 0x98, 0x00, 0x61, 0x7F, 0x7F, 0x7F, 0x7F, 0x71, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 102
    0x00, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x40, 0xC0, 0xC0, 0xC0, 0x60, 0x9B, 0xFF, 0xFF, 0x77, 0x74, 0x74, 0x74, 0xF7, 0xF3, 0xF1, 0x60, 0x00, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x00, // 103
    0x18, 0xF8, 0xFC, 0xFC, 0xFC, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x41, 0x01, 0x43, 0x7F, 0x7F, 0x7F, 0x7F, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 104
    0x98, 0x98, 0xDC, 0xDC, 0xC8, 0x00, 0x61, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 105
    0x18, 0x98, 0x9C, 0xDC, 0xC8, 0xC0, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x60, 0x60, 0x60, 0x20, 0x20, // 106
    0x10, 0xF8, 0xF8, 0xF8, 0xFC, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x2F, 0x1F, 0x7F, 0x7F, 0x78, 0x70, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 107
    0x18, 0xF8, 0xFC, 0xFC, 0xFC, 0x00, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 108
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x41, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x41, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x01, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 109
    0x00, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x61, 0x7F, 0x7F, 0x7F, 0x7F, 0x41, 0x01, 0x63, 0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 110
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x00, 0x1E, 0x3F, 0x3F, 0x7F, 0x78, 0x60, 0x61, 0x3F, 0x3F, 0x1F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 111
    0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xE0, 0xC0, 0xC0, 0x00, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0x21, 0x61, 0x7F, 0x7F, 0x3F, 0x0F, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, // 112
    0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x1E, 0x3F, 0x7F, 0x7F, 0x70, 0x60, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, // 113
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x61, 0x23, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 114
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x18, 0x73, 0x67, 0x6F, 0x7F, 0x7E, 0x3C, 0x1D, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 115
    0x80, 0xC0, 0xE0, 0xE0, 0xF0, 0xF0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x3F, 0x7F, 0x7F, 0x7F, 0x70, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 116
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x3F, 0x7F, 0x7F, 0x7F, 0x60, 0x20, 0x20, 0x7F, 0x7F, 0x7F, 0x7F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 117
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0xC0, 0x40, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0x7F, 0x7E, 0x1C, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 118
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x01, 0x07, 0x1F, 0x3F, 0x7F, 0x7E, 0x1E, 0x07, 0x0F, 0x3F, 0x7F, 0x7E, 0x1C, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 119
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0xC0, 0x40, 0x40, 0x60, 0x71, 0x7F, 0x0F, 0x7F, 0x7F, 0x7E, 0x7B, 0x71, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 120
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0xC3, 0x8F, 0x3F, 0xFF, 0xFF, 0x7C, 0x1E, 0x07, 0x00, 0x00, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, // 121
    0x80, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x40, 0x61, 0x71, 0x7C, 0x7F, 0x7F, 0x7F, 0x67, 0x71, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 122
    0x00, 0x00, 0xFC, 0xFE, 0xFE, 0x02, 0x02, 0x01, 0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, // 123
    0xFE, 0xFE, 0xFF, 0xFF, 0xE0, 0xE0, // 124
    0x02, 0x02, 0xFE, 0xFE, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0xFF, 0x01, 0x01, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, // 125
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x06, 0x06, 0x0C, 0x0C, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFC, 0x1C, 0x24, 0xC4, 0x04, 0xC4, 0x24, 0x1C, 0xFC, 0x7F, 0x70, 0x48, 0x46, 0x41, 0x46, 0x48, 0x70, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 127
    
};

#endif
